// This file is auto-generated by @hey-api/openapi-ts

export type Account = {
  /**
   * Type of account
   */
  account_type?: 'PINNER' | 'BUSINESS';
  /**
   * User account ID.
   */
  id?: string;
  profile_image?: string;
  website_url?: string;
  username?: string;
  /**
   * Profile about description.
   */
  about?: string;
  business_name?: string | null;
  /**
   * User account board count.<br/>**Note**: Board count on user account level may differ from counts found elsewhere due to attribution of collaborative Boards.
   */
  readonly board_count?: number | null;
  /**
   * User account pin count. This includes both created and saved pins.
   */
  readonly pin_count?: number | null;
  /**
   * User account follower count.
   */
  readonly follower_count?: number | null;
  /**
   * User account following count.
   */
  readonly following_count?: number | null;
  /**
   * User account monthly views.
   */
  readonly monthly_views?: number | null;
};

/**
 * Type of account
 */
export type account_type = 'PINNER' | 'BUSINESS';

/**
 * Ad group billable event type. For update, only draft ad groups may update billable event.
 */
export type ActionType = 'CLICKTHROUGH' | 'IMPRESSION' | 'VIDEO_V_50_MRC';

export type AdAccount = {
  id?: string;
  name?: string;
  owner?: {
    /**
     * Public username for the user account
     */
    username?: string;
    /**
     * The owning account's user ID.
     */
    id?: string;
  };
  country?: Country;
  currency?: Currency;
  permissions?: Array<BusinessAccessRole>;
  /**
   * Creation time. Unix timestamp in seconds.
   */
  created_time?: number | null;
  /**
   * Last update time. Unix timestamp in seconds.
   */
  updated_time?: number | null;
};

export type AdAccountAnalyticsResponse = Array<{
  /**
   * The ID of the advertiser that this metrics belongs to.
   */
  AD_ACCOUNT_ID: string;
  /**
   * Current metrics date. Only returned when granularity is a time-based value (`DAY`, `HOUR`, `WEEK`, `MONTH`)
   */
  DATE?: string;
  [key: string]: unknown | string;
}>;

export type AdAccountCreateRequest = {
  country?: Country;
  /**
   * Ad Account name.
   */
  name?: string;
  /**
   * Advertiser's owning user ID.
   */
  owner_user_id?: string;
};

export type AdAccountCreateSubscriptionRequest = {
  /**
   * Standard HTTPS webhook URL.
   */
  webhook_url: string;
  /**
   * Lead form ID.
   */
  lead_form_id?: string;
  /**
   * Partner access token. Only for clients that requires authentication. We recommend to aany this param.
   */
  partner_access_token?: string;
  /**
   * Partner refresh token. Only for clients that requires authentication. We recommend to aany this param.
   */
  partner_refresh_token?: string;
  /**
   * Partner metadata. Only for clients that requires special handling. We recommend to aany this param.
   */
  partner_metadata?: {
    /**
     * Text field value that uniquely identifies a subscriber.
     */
    subscriber_key?: string;
  };
};

export type AdAccountCreateSubscriptionResponse = {
  /**
   * Subscription ID.
   */
  id?: string;
  /**
   * Base64 encoded key for client to decrypt lead data.
   */
  cryptographic_key?: string | null;
  /**
   * Lead data encryption algorithm.
   */
  cryptographic_algorithm?: string | null;
  /**
   * Subscription creation time. Unix timestamp in milliseconds.
   */
  created_time?: number;
};

export type AdAccountGetSubscriptionResponse = {
  /**
   * Lead form ID.
   */
  lead_form_id?: string | null;
  /**
   * Standard HTTPS webhook URL.
   */
  webhook_url?: string;
} & {
  /**
   * Subscription ID.
   */
  id?: string;
  /**
   * User account used to subscribe lead data.
   */
  user_account_id?: string;
  /**
   * The Ad Account ID that this lead form belongs to.
   */
  ad_account_id?: string;
  /**
   * API version.
   */
  api_version?: string;
  /**
   * Base64 encoded key for client to decrypt lead data.
   */
  cryptographic_key?: string | null;
  /**
   * Lead data encryption algorithm.
   */
  cryptographic_algorithm?: string | null;
  /**
   * Lead form creation time. Unix timestamp in milliseconds.
   */
  created_time?: number;
};

export type AdAccountsCountryResponse = {
  items?: Array<AdAccountsCountryResponseData>;
};

export type AdAccountsCountryResponseData = {
  code?: AdCountry;
  /**
   * Country currency.
   */
  currency?: string;
  /**
   * Country index
   */
  index?: number;
  /**
   * Country name
   */
  name?: string;
};

export type AdArrayResponse = {
  items?: Array<AdArrayResponseElement>;
};

export type AdArrayResponseElement = {
  data?: AdResponse;
  exceptions?: Exception;
};

/**
 * Creation fields
 */
export type AdCommon = {
  /**
   * ID of the ad group that contains the ad.
   */
  ad_group_id?: string;
  /**
   * Deep link URL for Android devices.
   */
  android_deep_link?: string | null;
  /**
   * Comma-separated deep links for the carousel pin on Android.
   */
  carousel_android_deep_links?: Array<string> | null;
  /**
   * Comma-separated destination URLs for the carousel pin to promote.
   */
  carousel_destination_urls?: Array<string> | null;
  /**
   * Comma-separated deep links for the carousel pin on iOS.
   */
  carousel_ios_deep_links?: Array<string> | null;
  /**
   * Tracking url for the ad clicks.
   */
  click_tracking_url?: string | null;
  creative_type?: CreativeType;
  /**
   * Destination URL.
   */
  destination_url?: string | null;
  /**
   * Deep link URL for iOS devices.
   */
  ios_deep_link?: string | null;
  /**
   * Is original pin deleted?
   */
  is_pin_deleted?: boolean;
  /**
   * Is pin repinnable?
   */
  is_removable?: boolean;
  /**
   * Name of the ad - 255 chars max.
   */
  name?: string | null;
  status?: EntityStatus;
  tracking_urls?: TrackingUrls | null;
  /**
   * Tracking URL for ad impressions.
   */
  view_tracking_url?: string | null;
  /**
   * Lead form ID for lead ad generation.
   */
  lead_form_id?: string | null;
  grid_click_type?: GridClickType;
  /**
   * Select a call to action (CTA) to display below your ad. Available only for ads with direct links enabled. CTA options for consideration and conversion campaigns are LEARN_MORE, SHOP_NOW, BOOK_NOW, SIGN_UP, VISIT_SITE, BUY_NOW, GET_OFFER, ORDER_NOW, ADD_TO_CART (for conversion campaigns with add to cart conversion events only)
   */
  customizable_cta_type?:
    | (
        | 'GET_OFFER'
        | 'LEARN_MORE'
        | 'ORDER_NOW'
        | 'SHOP_NOW'
        | 'SIGN_UP'
        | 'SUBSCRIBE'
        | 'BUY_NOW'
        | 'CONTACT_US'
        | 'GET_QUOTE'
        | 'VISIT_SITE'
        | 'APPLY_NOW'
        | 'BOOK_NOW'
        | 'REQUEST_DEMO'
        | 'REGISTER_NOW'
        | 'FIND_A_DEALER'
        | 'ADD_TO_CART'
        | 'WATCH_NOW'
        | 'READ_MORE'
      )
    | null;
  /**
   * Before creating a quiz ad, you must create an organic Pin using POST/Create Pin for each result in the quiz. Quiz ads cannot be saved by a Pinner. Quiz ad results can be saved.
   */
  quiz_pin_data?: QuizPinData | null;
};

/**
 * Select a call to action (CTA) to display below your ad. Available only for ads with direct links enabled. CTA options for consideration and conversion campaigns are LEARN_MORE, SHOP_NOW, BOOK_NOW, SIGN_UP, VISIT_SITE, BUY_NOW, GET_OFFER, ORDER_NOW, ADD_TO_CART (for conversion campaigns with add to cart conversion events only)
 */
export type customizable_cta_type =
  | 'GET_OFFER'
  | 'LEARN_MORE'
  | 'ORDER_NOW'
  | 'SHOP_NOW'
  | 'SIGN_UP'
  | 'SUBSCRIBE'
  | 'BUY_NOW'
  | 'CONTACT_US'
  | 'GET_QUOTE'
  | 'VISIT_SITE'
  | 'APPLY_NOW'
  | 'BOOK_NOW'
  | 'REQUEST_DEMO'
  | 'REGISTER_NOW'
  | 'FIND_A_DEALER'
  | 'ADD_TO_CART'
  | 'WATCH_NOW'
  | 'READ_MORE';

/**
 * Country ID from ISO 3166-1 alpha-2.
 */
export type AdCountry =
  | 'AD'
  | 'AE'
  | 'AF'
  | 'AG'
  | 'AI'
  | 'AL'
  | 'AM'
  | 'AO'
  | 'AQ'
  | 'AR'
  | 'AS'
  | 'AT'
  | 'AU'
  | 'AW'
  | 'AX'
  | 'AZ'
  | 'BA'
  | 'BB'
  | 'BD'
  | 'BE'
  | 'BF'
  | 'BG'
  | 'BH'
  | 'BI'
  | 'BJ'
  | 'BL'
  | 'BM'
  | 'BN'
  | 'BO'
  | 'BQ'
  | 'BR'
  | 'BS'
  | 'BT'
  | 'BV'
  | 'BW'
  | 'BY'
  | 'BZ'
  | 'CA'
  | 'CC'
  | 'CD'
  | 'CF'
  | 'CG'
  | 'CH'
  | 'CI'
  | 'CK'
  | 'CL'
  | 'CM'
  | 'CN'
  | 'CO'
  | 'CR'
  | 'CU'
  | 'CV'
  | 'CW'
  | 'CX'
  | 'CY'
  | 'CZ'
  | 'DE'
  | 'DJ'
  | 'DK'
  | 'DM'
  | 'DO'
  | 'DZ'
  | 'EC'
  | 'EE'
  | 'EG'
  | 'EH'
  | 'ER'
  | 'ES'
  | 'ET'
  | 'FI'
  | 'FJ'
  | 'FK'
  | 'FM'
  | 'FO'
  | 'FR'
  | 'GA'
  | 'GB'
  | 'GD'
  | 'GE'
  | 'GF'
  | 'GG'
  | 'GH'
  | 'GI'
  | 'GL'
  | 'GM'
  | 'GN'
  | 'GP'
  | 'GQ'
  | 'GR'
  | 'GS'
  | 'GT'
  | 'GU'
  | 'GW'
  | 'GY'
  | 'HK'
  | 'HM'
  | 'HN'
  | 'HR'
  | 'HT'
  | 'HU'
  | 'ID'
  | 'IE'
  | 'IL'
  | 'IM'
  | 'IN'
  | 'IO'
  | 'IQ'
  | 'IR'
  | 'IS'
  | 'IT'
  | 'JE'
  | 'JM'
  | 'JO'
  | 'JP'
  | 'KE'
  | 'KG'
  | 'KH'
  | 'KI'
  | 'KM'
  | 'KN'
  | 'KR'
  | 'KW'
  | 'KY'
  | 'KZ'
  | 'LA'
  | 'LB'
  | 'LC'
  | 'LI'
  | 'LK'
  | 'LR'
  | 'LS'
  | 'LT'
  | 'LU'
  | 'LV'
  | 'LY'
  | 'MA'
  | 'MC'
  | 'MD'
  | 'ME'
  | 'MF'
  | 'MG'
  | 'MH'
  | 'MK'
  | 'ML'
  | 'MM'
  | 'MN'
  | 'MO'
  | 'MP'
  | 'MQ'
  | 'MR'
  | 'MS'
  | 'MT'
  | 'MU'
  | 'MV'
  | 'MW'
  | 'MX'
  | 'MY'
  | 'MZ'
  | 'NA'
  | 'NC'
  | 'NE'
  | 'NF'
  | 'NG'
  | 'NI'
  | 'NL'
  | 'NO'
  | 'NP'
  | 'NR'
  | 'NU'
  | 'NZ'
  | 'OM'
  | 'PA'
  | 'PE'
  | 'PF'
  | 'PG'
  | 'PH'
  | 'PK'
  | 'PL'
  | 'PM'
  | 'PN'
  | 'PR'
  | 'PS'
  | 'PT'
  | 'PW'
  | 'PY'
  | 'QA'
  | 'RE'
  | 'RO'
  | 'RS'
  | 'RU'
  | 'RW'
  | 'SA'
  | 'SB'
  | 'SC'
  | 'SD'
  | 'SE'
  | 'SG'
  | 'SH'
  | 'SI'
  | 'SJ'
  | 'SK'
  | 'SL'
  | 'SM'
  | 'SN'
  | 'SO'
  | 'SR'
  | 'SS'
  | 'ST'
  | 'SV'
  | 'SX'
  | 'SY'
  | 'SZ'
  | 'TC'
  | 'TD'
  | 'TF'
  | 'TG'
  | 'TH'
  | 'TJ'
  | 'TK'
  | 'TL'
  | 'TM'
  | 'TN'
  | 'TO'
  | 'TR'
  | 'TT'
  | 'TV'
  | 'TW'
  | 'TZ'
  | 'UA'
  | 'UG'
  | 'UM'
  | 'US'
  | 'UY'
  | 'UZ'
  | 'VA'
  | 'VC'
  | 'VE'
  | 'VG'
  | 'VI'
  | 'VN'
  | 'VU'
  | 'WF'
  | 'WS'
  | 'YE'
  | 'YT'
  | 'ZA'
  | 'ZM'
  | 'ZW';

export type AdCreateRequest = AdCommon &
  AdPinId & {
    [key: string]: unknown;
  };

/**
 * Request object used to get bid options values for a batch of retail catalog items
 */
export type AdvancedAuctionItemsGetRequest = {
  /**
   * Catalog id pertaining to the retail item
   */
  catalog_id: string;
  /**
   * A list of retail catalog items to fetch bid options for
   */
  items: Array<AdvancedAuctionItemsGetRecord>;
};

/**
 * Object uniquely identifying a retail catalog item
 */
export type AdvancedAuctionItemsGetRecord = AdvancedAuctionKey;

/**
 * Response object containing item bid options
 */
export type AdvancedAuctionItems = {
  /**
   * Response object of item bid options
   */
  catalog_id?: string;
  /**
   * Array with item bid options
   */
  items?: Array<AdvancedAuctionItem>;
};

/**
 * Request containing operations to perform on bid prices and bid multipliers for a batch of retail catalog items
 */
export type AdvancedAuctionItemsSubmitRequest = {
  /**
   * Catalog id pertaining to all items
   */
  catalog_id: string;
  /**
   * Array of item bid option operations
   */
  items: Array<AdvancedAuctionItemsSubmitRecord>;
};

/**
 * Object describing an item bid option operation
 */
export type AdvancedAuctionItemsSubmitRecord = (
  | AdvancedAuctionItemsSubmitUpsertRecord
  | AdvancedAuctionItemsSubmitDeleteRecord
) & {
  operation: AdvancedAuctionOperation;
};

/**
 * Object describing an item bid option upsert operation
 */
export type AdvancedAuctionItemsSubmitUpsertRecord = AdvancedAuctionItem & {
  /**
   * The list of item bid option fields to be set or updated. Fields specified in the updated mask without a value specified in the `bid_options` object in the body will be set to `null`. If an item bid option record is being created, fields not specified in the update mask will be initialized to `null`.
   */
  update_mask: Array<UpdateMaskBidOptionField> | null;
};

/**
 * Object describing an item bid option deletion operation
 */
export type AdvancedAuctionItemsSubmitDeleteRecord = AdvancedAuctionKey;

/**
 * Response object containing the results of an operation on an item bid option
 */
export type AdvancedAuctionProcessedItems = {
  /**
   * Catalog id pertaining to all items
   */
  catalog_id?: string;
  /**
   * Array of advanced auction processed items
   */
  items?: Array<AdvancedAuctionProcessedItem>;
};

/**
 * Object describing the result of an operation on an item bid option
 */
export type AdvancedAuctionProcessedItem = AdvancedAuctionItemsSubmitRecord & {
  /**
   * Array with validation errors for the supplied item bid option modification operation.
   * A non empty errors list means this single item operation was not applied.
   */
  errors?: Array<AdvancedAuctionOperationError>;
};

export type AdvancedAuctionItem = AdvancedAuctionKey & {
  bid_options: AdvancedAuctionBidOptions;
};

/**
 * Object uniquely identifying a retail catalog item
 */
export type AdvancedAuctionKey = {
  /**
   * The catalog retail item id in the merchant namespace
   */
  item_id: string;
  country: Country;
  language: Language;
};

export type AdvancedAuctionOperation = 'UPSERT' | 'DELETE';

/**
 * Object describing a retail catalog item's bid options (bid price and bid multipliers).
 */
export type AdvancedAuctionBidOptions = {
  bid_in_micro_currency?: BidInMicroCurrency;
  app_type_multipliers?: AppTypeMultipliers;
  placement_multipliers?: PlacementMultipliers;
};

/**
 * Error which occurred when applying a bid options operation to a specific item.
 */
export type AdvancedAuctionOperationError = {
  /**
   * The error code for the item bid option operation validation error
   */
  code?: number;
  /**
   * Message describing the item bid option operation validation error
   */
  message?: string;
};

/**
 * Bid price in micro currency. A value of 0 will stop distribution for this item in `MAX_BID` ad groups in `CATALOG_SALES` campaigns. A value of `null` will fallback to the ad group's `bid_in_micro_currency`.
 */
export type BidInMicroCurrency = number | null;

/**
 * This represents a mapping from app type targeting criteria to a bid price adjustment.
 *
 * Multiplier values must be between 0 and 10. A value of 10 represents a 900% increase in bid price (from $1 to $10 for example). A value of 0 will stop distribution for this item on the specified app type in `MAX_BID` ad groups in `CATALOG_SALES` campaigns. All app type multipliers must be set at the same time. If a multiplier is not provided it is assumed to be 1 (no bid adjustment).
 */
export type AppTypeMultipliers = {
  APP_TYPE?: TargetingSpecAppType;
  [key: string]: (number | TargetingSpecAppType) | undefined;
} | null;

export type TargetingSpecAppType = 'android_mobile' | 'android_tablet' | 'ipad' | 'iphone' | 'web' | 'web_mobile';

/**
 * This represents a mapping from placement to a bid price adjustment.
 *
 * Multiplier values must be between 0 and 10. A value of 10 represents a 900% increase in bid price (from $1 to $10 for example). A value of 0 will stop distribution for this item on the specified placement in `MAX_BID` ad groups in `CATALOG_SALES` campaigns. All placement multipliers must be set at the same time. If a multiplier is not provided it is assumed to be 1 (no bid adjustment).
 */
export type PlacementMultipliers = {
  PLACEMENT?: 'SEARCH' | 'BROWSE';
  [key: string]: (number | string) | undefined;
} | null;

export type PLACEMENT = 'SEARCH' | 'BROWSE';

/**
 * bid option field to apply operation updates to
 */
export type UpdateMaskBidOptionField = 'BID' | 'APP_TYPE_BID_MULTIPLIER_SET' | 'PLACEMENT_BID_MULTIPLIER_SET';

export type AdGroupArrayResponse = {
  items?: Array<AdGroupArrayResponseElement>;
};

export type AdGroupArrayResponseElement = {
  data?: AdGroupResponse;
  exceptions?: Array<Exception>;
};

export type AdGroupCommon = {
  /**
   * Ad group name.
   */
  name?: string;
  /**
   * Ad group/entity status.
   */
  status?: EntityStatus;
  /**
   * Budget in micro currency. This field is **REQUIRED** for non-CBO (campaign budget optimization) campaigns.  A CBO campaign automatically generates ad group budgets from its campaign budget to maximize campaign outcome. A CBO campaign is limited to 70 or less ad groups.
   */
  budget_in_micro_currency?: number | null;
  /**
   * Bid price in micro currency. This field is **REQUIRED** for the following campaign objective_type/billable_event combinations: AWARENESS/IMPRESSION, CONSIDERATION/CLICKTHROUGH, CATALOG_SALES/CLICKTHROUGH, VIDEO_VIEW/VIDEO_V_50_MRC.
   */
  bid_in_micro_currency?: number | null;
  /**
   * Optimization goals for objective-based performance campaigns. **REQUIRED** when campaign's `objective_type` is set to `"WEB_CONVERSION"`.
   */
  optimization_goal_metadata?: OptimizationGoalMetadata | null;
  budget_type?: BudgetType;
  /**
   * Ad group start time. Unix timestamp in seconds. Defaults to current time.
   */
  start_time?: number | null;
  /**
   * Ad group end time. Unix timestamp in seconds.
   */
  end_time?: number | null;
  targeting_spec?: TargetingSpec;
  /**
   * Set a limit to the number of times a promoted pin from this campaign can be impressed by a pinner within the past rolling 30 days. Only available for CPM (cost per mille (1000 impressions))  ad groups. A CPM ad group has an IMPRESSION <a href="/docs/redoc/#section/Billable-event">billable_event</a> value. This field **REQUIRES** the `end_time` field.
   */
  lifetime_frequency_cap?: number;
  /**
   * Third-party tracking URLs.<br> JSON object with the format: {"<a href="/docs/redoc/#section/Tracking-URL-event">Tracking event enum</a>":[URL string array],...}<br> For example: {"impression": ["URL1", "URL2"], "click": ["URL1", "URL2", "URL3"]}.<br>Up to three tracking URLs are supported for each event type. Tracking URLs set at the ad group or ad level can override those set at the campaign level. May be null. Pass in an empty object - {} - to remove tracking URLs.<br><br> For more information, see <a href="https://help.pinterest.com/en/business/article/third-party-and-dynamic-tracking" target="_blank">Third-party and dynamic tracking</a>.
   */
  tracking_urls?: TrackingUrls | null;
  /**
   * Enable auto-targeting for ad group. Also known as <a href="https://help.pinterest.com/en/business/article/expanded-targeting" target="_blank">"expanded targeting"</a>.
   */
  auto_targeting_enabled?: boolean | null;
  /**
   * <a href="/docs/redoc/#section/Placement-group">Placement group</a>.
   */
  placement_group?: PlacementGroupType;
  pacing_delivery_type?: PacingDeliveryType;
  /**
   * Campaign ID of the ad group.
   */
  campaign_id?: string;
  billable_event?: ActionType;
  /**
   * Bid strategy type. For Campaigns with Video Completion objectives, the only supported bid strategy type is AUTOMATIC_BID.
   */
  bid_strategy_type?: ('AUTOMATIC_BID' | 'MAX_BID' | 'TARGET_AVG') | null;
  /**
   * Targeting template IDs applied to the ad group. We currently only support 1 targeting template per ad group. To use targeting templates, do not set any other targeting fields: targeting_spec, tracking_urls, auto_targeting_enabled, placement_group. To clear all targeting template IDs, set this field to ['0'].
   */
  targeting_template_ids?: Array<string> | null;
};

/**
 * Bid strategy type. For Campaigns with Video Completion objectives, the only supported bid strategy type is AUTOMATIC_BID.
 */
export type bid_strategy_type = 'AUTOMATIC_BID' | 'MAX_BID' | 'TARGET_AVG';

export type AdGroupCreateRequest = AdGroupCommon & {
  pacing_delivery_type?: PacingDeliveryType;
  auto_targeting_enabled?: boolean;
  budget_type?: BudgetType;
};

export type AdGroupResponse = AdGroupCommon & {
  /**
   * Ad group ID.
   */
  id?: string;
  /**
   * Advertiser ID.
   */
  ad_account_id?: string;
  /**
   * Ad group creation time. Unix timestamp in seconds.
   */
  created_time?: number;
  /**
   * Ad group last update time. Unix timestamp in seconds.
   */
  updated_time?: number;
  /**
   * Always "adgroup".
   */
  type?: string;
  /**
   * oCPM learn mode
   */
  conversion_learning_mode_type?: ('NOT_ACTIVE' | 'ACTIVE') | null;
  /**
   * Ad group summary status.
   */
  summary_status?: AdGroupSummaryStatus;
  /**
   * Feed Profile ID associated to the adgroup.
   */
  feed_profile_id?: string;
  /**
   * [DCA] The Dynamic creative assets to use for DCA. Dynamic Creative Assembly (DCA) accepts basic creative assets of an ad (image, video, title, call to action, logo etc). Then it automatically generates optimized ad combinations based on these assets.
   */
  dca_assets?: unknown;
};

/**
 * oCPM learn mode
 */
export type conversion_learning_mode_type = 'NOT_ACTIVE' | 'ACTIVE';

/**
 * Summary status for ad group
 */
export type AdGroupSummaryStatus =
  | 'RUNNING'
  | 'PAUSED'
  | 'NOT_STARTED'
  | 'COMPLETED'
  | 'ADVERTISER_DISABLED'
  | 'ARCHIVED'
  | 'DRAFT'
  | 'DELETED_DRAFT';

export type AdGroupUpdateRequest = AdGroupCommon & {
  /**
   * Ad group ID.
   */
  id: string;
};

export type AdGroupsAnalyticsResponse = Array<{
  /**
   * The ID of the ad group that this metrics belongs to.
   */
  AD_GROUP_ID: string;
  /**
   * Current metrics date. Only returned when granularity is a time-based value (`DAY`, `HOUR`, `WEEK`, `MONTH`)
   */
  DATE?: string;
  [key: string]: unknown | string;
}>;

export type AdGroupAudienceSizingRequest = {
  /**
   * Enable auto-targeting for ad group. Also known as <a href="https://help.pinterest.com/en/business/article/expanded-targeting" target="_blank">"expanded targeting"</a>.
   */
  auto_targeting_enabled?: boolean;
  /**
   * <a href="/docs/redoc/#section/Placement-group">Placement group</a>.
   */
  placement_group?: PlacementGroupType;
  /**
   * Pin creative types filter. </p><strong>Note:</strong> SHOP_THE_PIN has been deprecated. Please use COLLECTION instead.
   */
  creative_types?: Array<
    'REGULAR' | 'VIDEO' | 'SHOPPING' | 'CAROUSEL' | 'MAX_VIDEO' | 'SHOP_THE_PIN' | 'COLLECTION' | 'IDEA'
  > | null;
  targeting_spec?: TargetingSpec;
  /**
   * Targeted product group IDs. </p><strong>Note:</strong> This can only be combined with shopping/catalog sales campaigns. For more information, <a href="https://help.pinterest.com/en/business/article/shopping-ads#section-14571" target="_blank">click here</a>. SHOPPING_RETARGETING must be included in targeting_spec object or this field will be ignored.
   */
  product_group_ids?: Array<string> | null;
  /**
   * Array of keyword objects. If the keywords field is missing, all keywords will be targeted.
   */
  keywords?: Array<{
    match_type: MatchTypeResponse;
    /**
     * Keyword value (120 chars max).
     */
    value: string;
  }> | null;
};

export type AdGroupAudienceSizingResponse = {
  /**
   * The lower confidence bound of the estimated potential audience size. "Potential audience size" estimates the number of people you may be able to reach per month with your campaign. It is based on historical advertising data and the targeting criteria you select. It does not guarantee results or take into account factors such as bid, budget, schedule, seasonality or product experiments.
   */
  audience_size_lower_bound?: number;
  /**
   * The upper confidence bound of the estimated potential audience size. "Potential audience size" estimates the number of people you may be able to reach per month with your campaign. It is based on historical advertising data and the targeting criteria you select. It does not guarantee results or take into account factors such as bid, budget, schedule, seasonality or product experiments.
   */
  audience_size_upper_bound?: number;
};

export type AdPinId = {
  /**
   * Pin ID.
   */
  pin_id?: string;
};

export type AdPreviewRequest =
  | {
      /**
       * Image URL.
       */
      image_url: string;
      /**
       * Title displayed below ad.
       */
      title: string;
    }
  | {
      /**
       * Pin ID.
       */
      pin_id: string;
    };

export type AdPreviewURLResponse = {
  /**
   * 'Preview URL, expires in 7 days. Can be used in an iframe.
   * For example: https://ads.pinterest.com/ad-preview/74667c814dd2b19/
   * The preview object ID/key is the last param - 74667c814dd2b19'
   */
  url?: string;
};

export type AdResponse = AdCommon &
  AdPinId & {
    /**
     * The ID of the advertiser that this ad belongs to.
     */
    ad_account_id?: string;
    /**
     * ID of the ad campaign that contains this ad.
     */
    campaign_id?: string;
    /**
     * Destination URL template for all items within a collections drawer.
     */
    collection_items_destination_url_template?: string | null;
    /**
     * Pin creation time. Unix timestamp in seconds.
     */
    created_time?: number;
    /**
     * The ID of this ad.
     */
    id?: string;
    /**
     * Enum reason why the pin was rejected. Returned if <code>review_status</code> is "REJECTED".
     */
    rejected_reasons?: Array<
      | 'HASHTAGS'
      | 'PROMOTIONS_AND_PRICES'
      | 'TARGETING'
      | 'LANDING_PAGE'
      | 'CAPS_AND_SYMBOLS'
      | 'SHOCKING'
      | 'WEIGHT_LOSS'
      | 'PROHIBITED_PRODUCT'
      | 'AUTHENTICITY'
      | 'NUDITY'
      | 'CONFUSING_DESIGN'
      | 'URGENCY'
      | 'RATINGS'
      | 'APP'
      | 'ALCOHOL'
      | 'CONTESTS'
      | 'POLITICAL'
      | 'OTHER'
      | 'IMAGE'
      | 'NAR'
      | 'INCONSISTENT'
      | 'CLICKBAIT'
      | 'NO_DESCRIPTION'
      | 'LOW_QUALITY'
      | 'EXAGGERATED_CLAIMS'
      | 'PINTEREST_BRAND'
      | 'ALCOHOL_NO_SALE'
      | 'LANDING_PAGE_SPEED'
      | 'LANDING_PAGE_HARDWALL'
      | 'LANDING_PAGE_BROKEN'
      | 'LANDING_PAGE_QUALITY'
      | 'OUT_OF_STOCK'
      | 'IMAGE_LOW_QUALITY'
      | 'IMAGE_BUSY'
      | 'IMAGE_POORLY_EDITED'
      | 'IMAGE_BEFORE_AFTER'
      | 'UGC'
      | 'FAKE_BUTTONS'
      | 'WEAPONS'
      | 'SENSITIVE'
      | 'UNACCEPTABLE_BUSINESS'
      | 'SUSPICIOUS_CLAIMS'
      | 'PHARMA'
      | 'SUSPICIOUS_SUPPLEMENTS'
      | 'ILLEGAL_RECREATIONAL_DRUG'
      | 'LOW_QUALITY_LANDING_PAGE'
      | 'RESTRICTED_HEALTHCARE'
      | 'INCONSISTENT_LANG_FR'
    >;
    /**
     * Text reason why the pin was rejected. Returned if <code>review_status</code> is "REJECTED".
     */
    rejection_labels?: Array<string>;
    /**
     * Ad review status
     */
    review_status?: 'OTHER' | 'PENDING' | 'REJECTED' | 'APPROVED';
    /**
     * Always "ad".
     */
    type?: string;
    /**
     * Last update time. Unix timestamp in seconds.
     */
    updated_time?: number;
    /**
     * Ad summary status
     */
    summary_status?: PinPromotionSummaryStatus;
  };

/**
 * Ad review status
 */
export type review_status = 'OTHER' | 'PENDING' | 'REJECTED' | 'APPROVED';

export type AdUpdateRequest = AdCommon & {
  /**
   * The ID of this ad.
   */
  id: string;
  /**
   * Pin ID. This field may only be updated for draft ads.
   */
  pin_id?: string | null;
};

/**
 * Reporting targeting type for ads
 */
export type AdsAnalyticsAdTargetingType =
  | 'KEYWORD'
  | 'APPTYPE'
  | 'GENDER'
  | 'LOCATION'
  | 'PLACEMENT'
  | 'COUNTRY'
  | 'TARGETED_INTEREST'
  | 'PINNER_INTEREST'
  | 'AUDIENCE_INCLUDE'
  | 'GEO'
  | 'AGE_BUCKET'
  | 'REGION'
  | 'QUIZ_RESULT'
  | 'AGE_BUCKET_AND_GENDER';

/**
 * Reporting targeting type for campaigns
 */
export type AdsAnalyticsCampaignTargetingType =
  | 'KEYWORD'
  | 'APPTYPE'
  | 'GENDER'
  | 'LOCATION'
  | 'PLACEMENT'
  | 'COUNTRY'
  | 'TARGETED_INTEREST'
  | 'PINNER_INTEREST'
  | 'AUDIENCE_INCLUDE'
  | 'GEO'
  | 'AGE_BUCKET'
  | 'REGION'
  | 'CREATIVE_TYPE'
  | 'AGE_BUCKET_AND_GENDER';

export type AdsAnalyticsCreateAsyncRequest = {
  /**
   * Metric report start date (UTC). Format: YYYY-MM-DD
   */
  start_date: string;
  /**
   * Metric report end date (UTC). Format: YYYY-MM-DD
   */
  end_date: string;
  /**
   * TOTAL - metrics are aggregated over the specified date range.<br> DAY - metrics are broken down daily.<br> HOUR - metrics are broken down hourly.<br>WEEKLY - metrics are broken down weekly.<br>MONTHLY - metrics are broken down monthly
   */
  granularity: Granularity;
  /**
   * Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
   */
  click_window_days?: ConversionAttributionWindowDays;
  /**
   * Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
   */
  engagement_window_days?: ConversionAttributionWindowDays;
  /**
   * Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.
   */
  view_window_days?: ConversionAttributionWindowDays;
  /**
   * The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.
   */
  conversion_report_time?: ConversionReportTimeType;
  /**
   * List of types of attribution for the conversion report
   */
  attribution_types?: Array<ConversionReportAttributionType>;
} & ({
  /**
   * List of campaign ids
   */
  campaign_ids?: Array<string>;
} & {
  /**
   * List of status values for filtering
   */
  campaign_statuses?: Array<CampaignSummaryStatus>;
} & {
  /**
   * List of values for filtering. ["WEB_SESSIONS"] in BETA.
   */
  campaign_objective_types?: Array<ObjectiveType>;
} & {
  /**
   * List of ad group ids
   */
  ad_group_ids?: Array<string>;
} & {
  /**
   * List of values for filtering
   */
  ad_group_statuses?: Array<AdGroupSummaryStatus>;
} & {
  /**
   * List of ad ids [This parameter is no supported for Product Item Level Reports]
   */
  ad_ids?: Array<string>;
} & {
  /**
   * List of values for filtering [This parameter is not supported for Product Item Level Reports]
   */
  ad_statuses?: Array<PinPromotionSummaryStatus>;
} & {
  /**
   * List of product group ids
   */
  product_group_ids?: Array<string>;
} & {
  /**
   * List of values for filtering
   */
  product_group_statuses?: Array<ProductGroupSummaryStatus>;
} & {
  /**
   * List of product item ids
   */
  product_item_ids?: Array<string>;
} & TargetingTypeFilter & {
    /**
     * List of metrics filters
     */
    metrics_filters?: Array<AdsAnalyticsMetricsFilter>;
  }) & {
    /**
     * Metric and entity columns. Pin promotion and ad related columns are not supported for the Product Item level reports.
     */
    columns: Array<ReportingColumnAsync>;
    /**
     * Level of the report
     */
    level: MetricsReportingLevel;
    /**
     * Specification for formatting the report data. Reports in JSON will not zero-fill metrics, whereas reports in CSV will. Both report formats will omit rows where all the columns are equal to 0.
     */
    report_format?: DataOutputFormat;
    primary_sort?: 'BY_ID' | 'BY_DATE';
    /**
     * Which hour of the start date to begin the report. The entire day will be included if no start hour is provided. Only allowed for hourly reports.
     */
    start_hour?: number;
    /**
     * Which hour of the end date to stop the report (inclusive). For example, with an end_date of '2020-01-01' and end_hour of '15', the report will contain metrics up to '2020-01-01 14:59:59'. The entire day will be included if no end hour is provided. Only allowed for hourly reports.
     */
    end_hour?: number;
  };

export type AdsAnalyticsCreateAsyncResponse = {
  report_status?: BulkReportingJobStatus;
  token?: string;
  message?: string | null;
};

/**
 * Reporting columns for sync reporting data filter
 */
export type AdsAnalyticsFilterColumn = 'SPEND_IN_DOLLAR' | 'TOTAL_IMPRESSION';

/**
 * Filter operator for sync reporting
 */
export type AdsAnalyticsFilterOperator = 'LESS_THAN' | 'GREATER_THAN';

export type AdsAnalyticsGetAsyncResponse = {
  report_status?: BulkReportingJobStatus;
  url?: string | null;
  size?: number | null;
};

export type AdsAnalyticsMetricsFilter = {
  field: AdsAnalyticsFilterColumn;
  operator: AdsAnalyticsFilterOperator;
  /**
   * List of values for filtering
   */
  values: Array<number>;
};

export type AdsAnalyticsResponse = Array<{
  /**
   * The ID of the ad that this metrics belongs to.
   */
  AD_ID: string;
  /**
   * Current metrics date. Only returned when granularity is a time-based value (`DAY`, `HOUR`, `WEEK`, `MONTH`)
   */
  DATE?: string;
  [key: string]: unknown | string;
}>;

/**
 * Reporting targeting type
 */
export type AdsAnalyticsTargetingType =
  | 'KEYWORD'
  | 'APPTYPE'
  | 'GENDER'
  | 'LOCATION'
  | 'PLACEMENT'
  | 'COUNTRY'
  | 'TARGETED_INTEREST'
  | 'PINNER_INTEREST'
  | 'AUDIENCE_INCLUDE'
  | 'GEO'
  | 'AGE_BUCKET'
  | 'REGION'
  | 'AGE_BUCKET_AND_GENDER';

export type AdsCreditDiscountsResponse = {
  /**
   * True if the offer code is currently active.
   */
  active?: boolean;
  /**
   * Advertiser ID the offer was applied to.
   */
  advertiser_id?: string;
  /**
   * The type of discount of this credit
   */
  discountType?:
    | (
        | 'COUPON'
        | 'CREDIT'
        | 'COUPON_APPLIED'
        | 'CREDIT_APPLIED'
        | 'MARKETING_OFFER_CREDIT'
        | 'MARKETING_OFFER_CREDIT_APPLIED'
        | 'GOODWILL_CREDIT'
        | 'GOODWILL_CREDIT_APPLIED'
        | 'INTERNAL_CREDIT'
        | 'INTERNAL_CREDIT_APPLIED'
        | 'PREPAID_CREDIT'
        | 'PREPAID_CREDIT_APPLIED'
        | 'SALES_INCENTIVE_CREDIT'
        | 'SALES_INCENTIVE_CREDIT_APPLIED'
        | 'CREDIT_EXPIRED'
        | 'FUTURE_CREDIT'
        | 'REFERRAL_CREDIT'
        | 'INVOICE_SALES_INCENTIVE_CREDIT'
        | 'INVOICE_SALES_INCENTIVE_CREDIT_APPLIED'
        | 'PREPAID_CREDIT_REFUND'
      )
    | null;
  /**
   * The discount applied in the offer’s currency value.
   */
  discountInMicroCurrency?: number | null;
  /**
   * Currency value for the discount.
   */
  discountCurrency?: string | null;
  /**
   * Human readable title of the offer code.
   */
  title?: string | null;
  /**
   * The credits left to spend.
   */
  remainingDiscountInMicroCurrency?: number | null;
};

/**
 * The type of discount of this credit
 */
export type discountType =
  | 'COUPON'
  | 'CREDIT'
  | 'COUPON_APPLIED'
  | 'CREDIT_APPLIED'
  | 'MARKETING_OFFER_CREDIT'
  | 'MARKETING_OFFER_CREDIT_APPLIED'
  | 'GOODWILL_CREDIT'
  | 'GOODWILL_CREDIT_APPLIED'
  | 'INTERNAL_CREDIT'
  | 'INTERNAL_CREDIT_APPLIED'
  | 'PREPAID_CREDIT'
  | 'PREPAID_CREDIT_APPLIED'
  | 'SALES_INCENTIVE_CREDIT'
  | 'SALES_INCENTIVE_CREDIT_APPLIED'
  | 'CREDIT_EXPIRED'
  | 'FUTURE_CREDIT'
  | 'REFERRAL_CREDIT'
  | 'INVOICE_SALES_INCENTIVE_CREDIT'
  | 'INVOICE_SALES_INCENTIVE_CREDIT_APPLIED'
  | 'PREPAID_CREDIT_REFUND';

export type AdsCreditRedeemRequest = {
  /**
   * Takes in a SHA256 hash of the offerCode.
   */
  offerCodeHash: string;
  /**
   * If true, only validate if we can redeem offer code. Otherwise it will actually apply the offer code to the account
   */
  validateOnly: boolean;
};

export type AdsCreditRedeemResponse = {
  /**
   * Returns true if the offer code was successfully applied(validateOnly=false) or can be applied(validateOnly=true).
   */
  success?: boolean;
  /**
   * Error code type if error occurs
   */
  errorCode?: number | null;
  /**
   * Reason for failure
   */
  errorMessage?: string | null;
};

export type AgeBucketList = Array<'18-24' | '25-34' | '35-44' | '45-49' | '50-54' | '55-64' | '65+'>;

export type AnalyticsDailyMetrics = {
  data_status?: DataStatus;
  /**
   * Metrics date (UTC): YYYY-MM-DD.
   */
  date?: string;
  metrics?: Metrics;
};

export type AnalyticsMetricsResponse = {
  /**
   * The metric name and value over the requested period for each requested metric
   */
  summary_metrics?: {
    [key: string]: number;
  };
  /**
   * Array with the requested daily metric records
   */
  daily_metrics?: Array<AnalyticsDailyMetrics>;
};

export type AnalyticsResponse = {
  [key: string]: AnalyticsMetricsResponse;
};

/**
 * An object containing the permissions a business member has on the asset.
 */
export type AssetIdPermissions = {
  /**
   * Unique identifier of a business asset.
   */
  asset_id?: string;
  asset_type?: AssetTypeResponse;
  permissions?: PermissionsResponse;
  /**
   * An object containing all the information specific to the provided asset group. This field will be populated only if asset_type equals 'ASSET_GROUP'.
   */
  asset_group_info?: AssetGroupBinding | null;
};

/**
 * An object mapping asset ids to lists of business permissions. This can be used to setting/requesting permissions on various assets. If accepting an invite or request, this object would be used to grant asset permissions to the member or partner.
 *
 */
export type AssetIdToPermissions = {
  [key: string]: Array<Permissions>;
};

/**
 * Type of asset. Currently we only support AD_ACCOUNT and PROFILE, and ASSET_GROUP.
 */
export type AssetTypeResponse = string;

export type Audience = {
  /**
   * Ad account ID.
   */
  ad_account_id?: string;
  /**
   * Audience ID.
   */
  id?: string;
  /**
   * Audience name.
   */
  name?: string;
  /**
   * <a href="/docs/reference/glossary/#Audience Types">Audience types</a>: ACTALIKE, ENGAGEMENT, CUSTOMER_LIST and VISITOR
   */
  audience_type?: string;
  /**
   * Audience description.
   */
  description?: string | null;
  rule?: AudienceRule;
  /**
   * Audience size.
   */
  size?: number | null;
  /**
   * Audience status. READY, INITIALIZING, TOO_SMALL - Each audience list needs to have at least 100 people with Pinterest accounts before you can start using it.
   */
  status?: string;
  /**
   * Always "audience".
   */
  type?: string;
  /**
   * Creation time. Unix timestamp in seconds.
   */
  created_timestamp?: number | null;
  /**
   * Last update time. Unix timestamp in seconds.
   */
  updated_timestamp?: number | null;
};

export type AudienceCategory = {
  /**
   * Interest unique key (same as ID).
   */
  key?: string;
  /**
   * Interest name.
   */
  name?: string;
  /**
   * Interest's percent of category's total audience.
   */
  ratio?: number;
  /**
   * Interest affinity index.
   */
  index?: number;
  /**
   * Interest ID.
   */
  id?: string;
  /**
   * Subcategory interest distribution
   */
  subcategories?: Array<{
    /**
     * Interest unique key (same as ID).
     */
    key?: string;
    /**
     * Subinterest name.
     */
    name?: string;
    /**
     * Subinterest's percent of category's total audience.
     */
    ratio?: number;
    /**
     * Subinterest affinity index.
     */
    index?: number;
    /**
     * Subinterest ID.
     */
    id?: string;
  }>;
};

export type AudienceCommon = {
  /**
   * Ad account ID.
   */
  ad_account_id?: string;
  /**
   * Audience name.
   */
  name?: string;
  rule?: AudienceRule;
};

export type AudienceCreateCustomRequest = AudienceCommon & {
  sharing_type: AudienceSharingType;
  data_party: AudienceDataParty;
  category?: string;
};

export type AudienceCreateRequest = AudienceCommon & {
  description?: AudienceDescription;
  audience_type: AudienceType & unknown;
};

/**
 * Whether the data is owned by the partner (1p) or by the data provider (3p)
 */
export type AudienceDataParty = '1p' | '3p';

/**
 * Queryable audience representation.
 */
export type AudienceDefinition = {
  /**
   * Generation date
   */
  date?: string | null;
  type?: AudienceDefinitionType;
  scope?: AudienceDefinitionScope;
};

export type AudienceDefinitionResponse = {
  items?: Array<AudienceDefinition>;
};

/**
 * Generated audience scope to request.
 */
export type AudienceDefinitionScope = {
  scope?: 'PARTNER' | 'PINTEREST';
};

export type scope = 'PARTNER' | 'PINTEREST';

/**
 * Generated audience type to request.
 */
export type AudienceDefinitionType = {
  scope?: 'IMPRESSION_PLUS_ENGAGEMENT' | 'ENGAGEMENT';
};

export type scope2 = 'IMPRESSION_PLUS_ENGAGEMENT' | 'ENGAGEMENT';

/**
 * Demographic detail for a single audience demographic
 */
export type AudienceDemographicValue = {
  /**
   * Unique key for demographic item
   */
  key?: string;
  /**
   * Display name for demographic
   */
  name?: string;
  /**
   * Value of demographic item as a percent of total audience
   */
  ratio?: number;
};

/**
 * Audience demographics
 */
export type AudienceDemographics = {
  /**
   * Ages distribution.
   */
  ages?: Array<AudienceDemographicValue>;
  /**
   * Gender distribution.
   */
  genders?: Array<AudienceDemographicValue>;
  /**
   * Device usage distribution.
   */
  devices?: Array<AudienceDemographicValue>;
  /**
   * Geographic metro area distribution.
   */
  metros?: Array<AudienceDemographicValue>;
  /**
   * Country area distribution.
   */
  countries?: Array<AudienceDemographicValue>;
};

/**
 * Audience description.
 */
export type AudienceDescription = string;

/**
 * @deprecated
 */
export type AudienceInsightCategoryArrayResponse = {
  items?: Array<AudienceInsightCategoryCommon>;
};

/**
 * @deprecated
 */
export type AudienceInsightCategoryCommon = {
  key?: string;
  name?: string;
  ratio?: number;
  index?: number;
  id?: string;
};

export type AudienceInsightType = 'YOUR_TOTAL_AUDIENCE' | 'YOUR_ENGAGED_AUDIENCE' | 'PINTEREST_TOTAL_AUDIENCE';

/**
 * Audience interests and demographics.
 */
export type AudienceInsightsResponse = {
  /**
   * Category interest distribution
   */
  categories?: Array<AudienceCategory>;
  demographics?: AudienceDemographics;
  type?: AudienceInsightType;
  /**
   * Generation date
   */
  date?: string | null;
  /**
   * Population count.
   */
  size?: number;
  /**
   * Indicates whether the audience size has been rounded up to the next highest upper boundary.
   */
  size_is_upper_bound?: boolean;
};

/**
 * JSON object defining targeted audience users. Example rule formats per audience type:<br>CUSTOMER_LIST: { "customer_list_id": "&lt;customer list ID&gt;"}<br>ACTALIKE: { "seed_id": ["&lt;audience ID&gt;"], "country": "US", "percentage": "10" }<br>(Valid countries include: "US", "CA", and "GB". Percentage should be 1-10.<br>The targeted audience should be this % size across Pinterest.)<br>VISITOR: { "visitor_source_id": ["&lt;conversion tag ID&gt;"], "retention_days": "180", "event_source": {"=": ["web", "mobile"]}, "ingestion_source": {"=": ["tag"]}}<br>(Retention days should be 1-540. Retention applies to specific customers.)<br>ENGAGEMENT: {"engagement_domain": ["www.entomi.com"], "engager_type": 1}<br>For more details on engagement audiences, see <a href="/docs/redoc/adtech_ads_v4/#section/November-2021" target="_blank">November 2021 changelog</a>.
 */
export type AudienceRule = {
  /**
   * Valid countries include: "US", "CA", and "GB".
   */
  country?: string;
  /**
   * Customer list ID. For CUSTOMER_LIST `audience_type`.
   */
  customer_list_id?: string;
  /**
   * The audience account's verified domain. **Required** for ENGAGEMENT `audience_type`.
   */
  engagement_domain?: Array<string>;
  /**
   * Engagement type enum. Optional for ENGAGEMENT `audience_type`. Supported values are `click`, `save`, `closeup`, `comment` and `like`. All engagements are included if this field is not set.
   */
  engagement_type?: string;
  /**
   * A Pinterest tag event. Optional for VISITOR `audience_type`. Possible values are `pagevisit`, `signup`, `checkout`, `viewcategory`, `search`, `addtocart`, `watchvideo`, `lead`, and `custom`. This field also accepts a partner-defined Pinterest tag event.
   */
  event?: string;
  /**
   * Optional for VISITOR `audience_type`. With the Pinterest tag, you can use event data to capture event details from your website. This object lists all the available predefined event data fields in the Pinterest tag. You can include these event data fields as part of a VISITOR audience’ s `rule`; however, you **must** specify an `event` for the `event_data` fields to be evaluated. Besides what’s listed, you can also create your own set of `event_data` fields and define their usages or purposes according to your website needs. However, the benefit of using the predefined event data fields is that we can provide various metrics based on those fields' data.<br>Examples per `event` type:<br>`pagevisit`<br>"event_data": { "page_name": "My online store 123 | view items | shoe" }<br>`signup`<br>"event_data": { "lead_type": "New release promotion" }<br>`checkout`<br>"event_data": { "value": 116, "order_quantity": 2, "currency": "USD", "line_items": [ { "product_name": "Pillows (Set of 2)", "product_id": "11", "product_price": 48, "product_quantity": 1 }, { "product_name": "Pillows, Large (Set of 2)", "product_id": "15", "product_price": 68, "product_quantity": 1 } ] }<br>`addtocart`<br>"event_data": { "value": 499, "order_quantity": 1, "currency": "USD", "line_items": [ { "product_name": "Red leather boots", "product_id": "3486", "product_category": "shoe", "product_variant_id": "JB11103000", "product_price": 499, "product_quantity": "1" , "product_brand": "My brand" }]}<br>`watchvideo`<br>"event_data": { "video_title": "My Product Video 01" }<br>`lead`<br>"event_data": { "lead_type": "Newsletter" }
   */
  event_data?: {
    currency?: Currency;
    /**
     * Promotion code. For example, "Newsletter".
     */
    lead_type?: string;
    line_items?: {
      /**
       * Product brand. For example, "Parker".
       */
      product_brand?: string;
      /**
       * Product category. For example, "Shoes".
       */
      product_category?: string;
      /**
       * Product ID. For example, 1414.
       */
      product_id?: number;
      /**
       * Product name. For example, "Parker Boots".
       */
      product_name?: string;
      /**
       * Product price. For example, "99.99".
       */
      product_price?: string;
      /**
       * Product quantity. For example, 2.
       */
      product_quantity?: number;
      /**
       * Product variant. For example, "Red".
       */
      product_variant?: string;
      /**
       * Product variant ID. For example, "1414-34832".
       */
      product_variant_id?: string;
    };
    /**
     * Order ID. For example, "X-151481".
     */
    order_id?: string;
    /**
     * Order quantity. For example, 1.
     */
    order_quantity?: number;
    /**
     * Page name. For example, "Our Favorite Pins on Pinterest".
     */
    page_name?: string;
    /**
     * Promotion code. For example, "WINTER10".
     */
    promo_code?: string;
    /**
     * Property. For example, "Athleta".
     */
    property?: string;
    /**
     * Search query string. For example, "boots".
     */
    search_query?: string;
    /**
     * Product value. For example, "199.98"
     */
    value?: string;
    /**
     * Video title. For example, "How to style your Parker Boots".
     */
    video_title?: string;
  };
  /**
   * Percentage should be 1-10. The targeted audience should be this % size across Pinterest.
   */
  percentage?: number;
  /**
   * IDs of engaged organic pins. Optional for ENGAGEMENT `audience_type`. For example, "pin_id:": ["34567"]
   */
  pin_id?: Array<string>;
  /**
   * Optional for VISITOR `audience_type`. If `true`, the specified rule on existing engagement data is applied to pre-populate the audience. If `false`, the audience is empty at creation time. The default is `true`.
   */
  prefill?: boolean;
  /**
   * Number of days a Pinterest user remains in the audience. Optional for ENGAGEMENT and VISITOR `audience_type`. Accepted range is 1-540. Defaults to 180 if not specified.
   */
  retention_days?: number;
  /**
   * Audience ID(s). For ACTALIKE `audience_type`.
   */
  seed_id?: Array<string>;
  /**
   * Optional for ENGAGEMENT or VISITOR `audience_type`. For ENGAGEMENT, it is the engaged pin's URL. For VISITOR, you can use it as a string or a {operator: value} object for filtering visitors based on conversion tag event URLs. Supported operators are [ =, !=, contains, not_contains].<br>Example 1:  "url": "http://www.myonlinestore123.com/view_item/shoe"<br>Example 2: "url": {"contains": "/view_item/shoe"}
   */
  url?: Array<string>;
  /**
   * The conversion tag ID, or the Pinterest tag ID, that you use on your website. For VISITOR `audience_type`.
   */
  visitor_source_id?: string;
  /**
   * Optional for VISITOR. You can use it as a {'=': [value]}. Supported values are: web, mobile, offline
   */
  event_source?: {
    [key: string]: unknown;
  };
  /**
   * Optional for VISITOR. You can use it as a {'=': [value]}. Supported values are: tag, mmp, file_upload, conversions_api
   */
  ingestion_source?: {
    [key: string]: unknown;
  };
  /**
   * Optional for ENGAGEMENT. Engager type value should be 1-2.
   */
  engager_type?: number;
  /**
   * Campaign ID for engagement audience filter.
   */
  campaign_id?: Array<string>;
  /**
   * Ad ID for engagement audience filter.
   */
  ad_id?: Array<string>;
  /**
   * Objective for engagement audience filter.
   */
  objective_type?: Array<ObjectiveType>;
  /**
   * Ad account ID.
   */
  ad_account_id?: string;
};

export type AudienceShareType = 'SHARED' | 'RECEIVED';

export type AudienceAccountType = 'AD_ACCOUNT' | 'BUSINESS_ACCOUNT';

/**
 * Audience sharing type: ["CUSTOM", "SYNDICATED"]
 */
export type AudienceSharingType = 'CUSTOM' | 'SYNDICATED';

/**
 * Audience type
 */
export type AudienceType = 'CUSTOMER_LIST' | 'VISITOR' | 'ENGAGEMENT' | 'ACTALIKE' | 'PERSONA';

/**
 * Audience operation type (update or remove).
 */
export type AudienceUpdateOperationType = 'UPDATE' | 'REMOVE';

export type AudienceUpdateRequest = AudienceCommon & {
  description?: AudienceDescription;
  operation_type?: AudienceUpdateOperationType;
};

/**
 * An object with a list of all the invites the user would like to respond to and the action to take.
 */
export type AuthRespondInvitesBody = {
  invites: Array<{
    action: {
      /**
       * Whether the invite/request is accepted.
       */
      accept_invite: boolean;
      asset_id_to_permissions?: AssetIdToPermissions;
    };
    /**
     * Unique identifier of an invite.
     */
    invite_id: string;
  }>;
};

export type AvailabilityFilter = {
  AVAILABILITY: CatalogsProductGroupMultipleStringCriteria;
};

export type BaseInviteDataResponse = {
  /**
   * Unique identifier of the invite/request.
   */
  id?: string;
  /**
   * Metadata for the invite/request.
   */
  invite_data?: {
    /**
     * The date and time when the invite/request will expire. Returned in milliseconds.
     */
    invite_expiration?: number;
    /**
     * The current status of the invite. The invite can be in one of the following states PENDING, ACCEPTED, DECLINED, CANCELLED, EXPIRED.
     */
    invite_status?: string;
    /**
     * The type of invite. <br>'MEMBER_INVITE' is to invite a member to access your business assets. <br>'PARTNER_INVITE' is to invite a partner to access your business assets. <br>'PARTNER_REQUEST' is to request access a partner's business assets.
     */
    invite_type?: string;
    /**
     * The date and time the invite/request was last updated. Returned in milliseconds.
     */
    last_updated_time?: number;
    /**
     * The date and time the invite/request was sent/created. Returned in milliseconds.
     */
    sent_at?: number;
  };
  /**
   * Indicates whether the invite/request was received.
   */
  is_received_invite?: boolean;
  /**
   * Metadata for the member/partner that was sent the invite/request.
   */
  user?: BusinessAccessUserSummary;
} | null;

/**
 * The operation performed by the batch. The DELETE_DISCONTINUED operation only updates availablity to "Out of Stock".
 */
export type BatchOperation = 'UPDATE' | 'UPSERT' | 'CREATE' | 'DELETE_DISCONTINUED' | 'DELETE';

/**
 * The status of the operation performed by the batch
 */
export type BatchOperationStatus = 'PROCESSING' | 'COMPLETED' | 'FAILED';

export type BidFloor = {
  /**
   * A list of bid floors in micro currency. For example, [100000, 200000]
   */
  bid_floors?: Array<number>;
  /**
   * Always the string 'bidfloor'
   */
  type?: string;
};

export type BidFloorRequest = {
  bid_floor_specs: Array<{
    countries?: Array<Country>;
    currency: Currency;
    objective_type?: ObjectiveType;
    billable_event: ActionType;
    optimization_goal_metadata?: OptimizationGoalMetadata;
    creative_type?: CreativeType;
  }>;
  targeting_spec?: TargetingSpec;
};

export type BillingProfilesResponse = {
  /**
   * Billing ID.
   */
  id?: string;
  /**
   * Type of the card.
   */
  card_type?: 'UNKNOWN' | 'VISA' | 'MASTERCARD' | 'AMERICAN_EXPRESS' | 'DISCOVER' | 'ELO';
  /**
   * Status of the billing.
   */
  status?: 'UNSPECIFIED' | 'VALID' | 'INVALID' | 'PENDING' | 'DELETED' | 'SECONDARY' | 'PENDING_SECONDARY';
  /**
   * Advertiser ID of the billing.
   */
  advertiser_id?: string;
  /**
   * Brand of the payment method.
   */
  payment_method_brand?:
    | 'UNKNOWN'
    | 'VISA'
    | 'MASTERCARD'
    | 'AMERICAN_EXPRESS'
    | 'DISCOVER'
    | 'SOFORT'
    | 'DINERS_CLUB'
    | 'ELO'
    | 'CARTE_BANCAIRE';
};

/**
 * Type of the card.
 */
export type card_type = 'UNKNOWN' | 'VISA' | 'MASTERCARD' | 'AMERICAN_EXPRESS' | 'DISCOVER' | 'ELO';

/**
 * Status of the billing.
 */
export type status = 'UNSPECIFIED' | 'VALID' | 'INVALID' | 'PENDING' | 'DELETED' | 'SECONDARY' | 'PENDING_SECONDARY';

/**
 * Brand of the payment method.
 */
export type payment_method_brand =
  | 'UNKNOWN'
  | 'VISA'
  | 'MASTERCARD'
  | 'AMERICAN_EXPRESS'
  | 'DISCOVER'
  | 'SOFORT'
  | 'DINERS_CLUB'
  | 'ELO'
  | 'CARTE_BANCAIRE';

/**
 * Board
 */
export type Board = {
  readonly id?: string;
  /**
   * Date and time of board creation.
   */
  readonly created_at?: string;
  /**
   * Date and time of last board pins modified.
   */
  readonly board_pins_modified_at?: string;
  name: string;
  description?: string | null;
  /**
   * Count of collaborators on the board.
   */
  readonly collaborator_count?: number;
  /**
   * Count of pins on the board.
   */
  readonly pin_count?: number;
  /**
   * Board follower count.
   */
  readonly follower_count?: number;
  /**
   * Board media.
   */
  readonly media?: {
    /**
     * Board cover image.
     */
    image_cover_url?: string | null;
    /**
     * Board pin thumbnail urls.
     */
    pin_thumbnail_urls?: Array<string>;
  };
  readonly owner?: BoardOwner;
  /**
   * Privacy setting for a board. Learn more about <a href="https://help.pinterest.com/en/article/secret-boards">secret boards</a> and <a href="https://help.pinterest.com/en/business/article/protected-boards">protected boards</a>
   */
  privacy?: 'PUBLIC' | 'PROTECTED' | 'SECRET';
};

/**
 * Privacy setting for a board. Learn more about <a href="https://help.pinterest.com/en/article/secret-boards">secret boards</a> and <a href="https://help.pinterest.com/en/business/article/protected-boards">protected boards</a>
 */
export type privacy = 'PUBLIC' | 'PROTECTED' | 'SECRET';

export type BoardOwner = {
  readonly username?: string;
};

/**
 * Sections help organize pins within a board.
 */
export type BoardSection = {
  readonly id?: string;
  name: string;
};

/**
 * Board fields for updates
 */
export type BoardUpdate = {
  name?: string;
  description?: string | null;
  privacy?: 'PUBLIC' | 'SECRET';
};

export type privacy2 = 'PUBLIC' | 'SECRET';

/**
 * Creation fields
 */
export type BookClosedResponse = {
  /**
   * Are conversion metrics ready?
   */
  conversion_metrics_ready?: boolean;
  /**
   * Are non-conversion metrics ready?
   */
  non_conversion_metrics_ready?: boolean;
};

export type BrandFilter = {
  BRAND: CatalogsProductGroupMultipleStringCriteria;
};

/**
 * Budget type. If DAILY, an ad group's daily spend will not exceed the budget parameter value. If LIFETIME, the end_time parameter is **REQUIRED**, and the ad group spend is spread evenly between the ad group `start_time` and `end_time` range. A CBO campaign automatically generates ad group budgets from its campaign budget to maximize campaign outcome. For CBO campaigns, only "CBO_ADGROUP" is allowed. For WEB_SESSIONS campaigns, only "LIFETIME" is allowed. For update, only draft ad groups may update budget type.
 */
export type BudgetType = 'DAILY' | 'LIFETIME' | 'CBO_ADGROUP';

/**
 * Ad entities to get in bulk request.
 */
export type BulkDownloadRequest = {
  /**
   * All entity types specified will be downloaded. Fewer types result in faster downloads.
   */
  entity_types?: Array<BulkEntityType>;
  /**
   * All entities specified by these IDs as well as their children and grandchildren will be downloaded if the entity type is one of the types requested to be downloaded.
   */
  entity_ids?: Array<string>;
  /**
   * Unix UTC timestamp to retrieve all entities that have changed since this time.
   */
  updated_since?: string;
  campaign_filter?: {
    /**
     * Unix UTC timestamp.
     */
    start_time?: string;
    /**
     * Unix UTC timestamp.
     */
    end_time?: string;
    /**
     * Campaign name
     */
    name?: string;
    campaign_status?: Array<CampaignSummaryStatus>;
    objective_type?: Array<ObjectiveType>;
  };
  output_format?: BulkOutputFormat;
};

export type BulkDownloadResponse = {
  /**
   * ID of the bulk request.
   */
  request_id?: string;
};

/**
 * Refers ads entity type
 */
export type BulkEntityType = 'CAMPAIGN' | 'AD_GROUP' | 'PRODUCT_GROUP' | 'AD' | 'KEYWORD';

/**
 * Bulk file output format
 */
export type BulkOutputFormat = 'CSV' | 'JSON';

/**
 * Possible status for a bulk reporting job
 */
export type BulkReportingJobStatus = 'DOES_NOT_EXIST' | 'FINISHED' | 'IN_PROGRESS' | 'EXPIRED' | 'FAILED' | 'CANCELLED';

/**
 * Two set of objects to be managed asyncronusly by bulk. One for creations, one for modifications.
 */
export type BulkUpsertRequest = {
  create?: BulkUpsertRequestCreate;
  update?: BulkUpsertRequestUpdate;
};

/**
 * Request for creation of entities in bulk.
 */
export type BulkUpsertRequestCreate = {
  campaigns?: Array<CampaignCreateRequest>;
  ad_groups?: Array<AdGroupCreateRequest>;
  ads?: Array<AdCreateRequest>;
  product_groups?: Array<ProductGroupPromotionCreateRequest>;
  keywords?: Array<KeywordsRequest>;
};

/**
 * Request for creation of entities in bulk.
 */
export type BulkUpsertRequestUpdate = {
  campaigns?: Array<CampaignUpdateRequest>;
  ad_groups?: Array<AdGroupUpdateRequest>;
  ads?: Array<AdUpdateRequest>;
  product_groups?: Array<ProductGroupPromotionUpdateRequest>;
  keywords?: Array<KeywordUpdate>;
};

/**
 * ID of the bulk request.
 */
export type BulkUpsertResponse = {
  request_id?: string;
};

export type BulkUpsertStatus = 'RUNNING' | 'SUCCEEDED' | 'FAILED';

/**
 * ID of the bulk request.
 */
export type BulkUpsertStatusResponse = {
  status?: BulkUpsertStatus;
  result_url?: string;
};

export type BusinessAccessError = {
  code: number;
  message: string;
} | null;

/**
 * Metadata of the member/partner that has access to the asset.
 */
export type BusinessAccessUserSummary = {
  /**
   * Email of the business member/partner.
   */
  email?: string | null;
  /**
   * Unique identifier of the business member/partner.
   */
  id?: string | null;
  /**
   * Username of the business member/partner.
   */
  username?: string | null;
};

/**
 * Permission role for business access.
 */
export type BusinessAccessRole =
  | 'OWNER'
  | 'ADMIN'
  | 'ANALYST'
  | 'SOS_READER'
  | 'FINANCE_MANAGER'
  | 'AUDIENCE_MANAGER'
  | 'CAMPAIGN_MANAGER'
  | 'CATALOGS_MANAGER'
  | 'RESTRICTED_OWNER'
  | 'PROFILE_MANAGER'
  | 'PROFILE_PUBLISHER'
  | 'RESOURCE_PINNER_LIST_OWNER'
  | 'RESOURCE_PINNER_LIST_READER'
  | 'BIZ_PINNER_LIST_SHARER'
  | 'RESOURCE_CONVERSION_TAGS_READER';

/**
 * Ad accounts and profiles the business member/partner has access to.
 */
export type BusinessMemberAssetsSummary = {
  /**
   * List of ad account IDs and respective permission levels.
   */
  ad_accounts?: Array<{
    /**
     * Unique identifier of a business ad account.
     */
    id?: string;
    permissions?: PermissionsResponse;
  }>;
  /**
   * List of profile IDs and respective permission levels.
   */
  profiles?: Array<{
    /**
     * Unique identifier of a business profile.
     */
    id?: string;
    permissions?: PermissionsResponse;
  }>;
} | null;

/**
 * Specifies if the partner is internal or external.
 */
export type BusinessRoleCheckMode = 'INTERNAL' | 'EXTERNAL';

/**
 * The access level a member/partner has to the business. Values are case-sensitive.
 * <br> - EMPLOYEE: Can only view and access assets you assign to them.
 * They cannot see details about other employees, partners, or other assets.
 * <br> - BIZ_ADMIN: Have full control of roles and can add employees and partners as well as grant asset access.
 * <br> - PARTNER: Can only view and access assets you assign them to/or they assign to you.
 */
export type BusinessRole = 'EMPLOYEE' | 'BIZ_ADMIN' | 'PARTNER';

/**
 * The access level a member has to the business. Values are case-sensitive.
 * <br> - EMPLOYEE: Can only view and access assets you assign to them.
 * They cannot see details about other employees, partners, or other assets.
 * <br> - BIZ_ADMIN: Have full control of roles and can add employees and partners as well as grant asset access.
 */
export type BusinessRoleForMembers = 'EMPLOYEE' | 'BIZ_ADMIN';

/**
 * The access level a member/partner has to the business. Values are case-sensitive.
 * <br> - EMPLOYEE: Can only view and access assets you assign to them.
 * They cannot see details about other employees, partners, or other assets.
 * <br> - BIZ_ADMIN: Have full control of roles and can add employees or external partners as well as grant asset access.
 * <br> - PARTNER: Can only view and access assets you assign them to/or they assign to you.
 */
export type BusinessRoleResponse = string;

export type UpdatePartnerAssetAccessBody = {
  accesses: Array<{
    /**
     * Unique identifier of a business partner to update asset access to.
     */
    partner_id: string;
    /**
     * Unique identifier of the business asset.
     */
    asset_id: string;
    /**
     * A non-empty array of permissions to assign to the partner.
     */
    permissions: Array<Permissions>;
  }>;
};

export type DeletePartnerAssetAccessBody = {
  accesses: Array<{
    /**
     * Unique identifier of a business partner to update asset access to.
     */
    partner_id: string;
    /**
     * Unique identifier of the business asset.
     */
    asset_id: string;
    /**
     * If partner_type=INTERNAL, the deleted asset access is for the access the partner has to your business asset.<br>
     * If partner_type=EXTERNAL, the deleted asset access is for the access you have to the partner's business asset.
     */
    partner_type?: 'INTERNAL' | 'EXTERNAL';
  }>;
};

/**
 * The terminated asset access.
 */
export type DeletePartnerAssetsResult = {
  /**
   * Unique identifier of a business asset.
   */
  asset_id?: string;
  asset_type?: AssetTypeResponse;
  permissions?: PermissionsResponse;
  /**
   * If is_shared_partner=FALSE, you terminated a partner's asset access to your business asset.<br> If is_shared_partner=TRUE, you terminated your asset access to your partner's business asset.
   */
  is_shared_partner?: boolean;
  /**
   * Unique identifier of a business partner.
   */
  partner_id?: string;
};

export type DeletePartnerAssetsResultsResponseArray = {
  /**
   * List of terminated asset access.
   */
  items?: Array<DeletePartnerAssetsResult>;
};

export type UpdateMemberResult = {
  /**
   * The access level a member has to the business. Values are case-sensitive.
   * <br> - EMPLOYEE: Can only view and access assets you assign to them.
   * They cannot see details about other employees, partners, or other assets.
   * <br> - BIZ_ADMIN: Have full control of roles and can add employees and partners as well as grant asset access.
   */
  business_role?: string;
  /**
   * Unique identifier of the business member.
   */
  member_id?: string;
};

export type UpdateMemberResultsResponseArray = {
  /**
   * List of members with updated business access role.
   */
  items?: Array<UpdateMemberResult>;
};

/**
 * Single instance of a business member to have its role updated
 */
export type UpdateMemberBusinessRoleBody = {
  business_role: BusinessRoleForMembers;
  /**
   * Unique identifier of the member
   */
  member_id: string;
};

/**
 * An object with a list of all the new accesses.
 */
export type UpdateMemberAssetAccessBody = {
  accesses: Array<{
    /**
     * Id of the asset to update.
     */
    asset_id: string;
    /**
     * Unique identifier of the member on which to perform the update
     */
    member_id: string;
    /**
     * A non-empty array of permissions to assign to the member.
     */
    permissions: Array<Permissions>;
  }>;
};

/**
 * Campaign Data
 */
export type CampaignCommon = {
  /**
   * Campaign's Advertiser ID. If you want to create a campaign in a Business Account shared account you need to specify the Business Access advertiser ID in both the query path param as well as the request body schema.
   */
  ad_account_id?: string;
  /**
   * Campaign name.
   */
  name?: string;
  status?: EntityStatus;
  /**
   * Campaign total spending cap. Required for Campaign Budget Optimization (CBO) campaigns. This and "daily_spend_cap" cannot be set at the same time.
   */
  lifetime_spend_cap?: number | null;
  /**
   * Campaign daily spending cap. Required for Campaign Budget Optimization (CBO) campaigns. This and "lifetime_spend_cap" cannot be set at the same time.
   */
  daily_spend_cap?: number | null;
  /**
   * Order line ID that appears on the invoice.
   */
  order_line_id?: string | null;
  tracking_urls?: TrackingUrls | null;
  /**
   * Campaign start time. Unix timestamp in seconds. Only used for Campaign Budget Optimization (CBO) campaigns.
   */
  start_time?: number | null;
  /**
   * Campaign end time. Unix timestamp in seconds. Only used for Campaign Budget Optimization (CBO) campaigns.
   */
  end_time?: number | null;
  is_flexible_daily_budgets?: CampaignIsFlexibleDailyBudgets;
};

export type CampaignCreateCommon = CampaignCommon & {
  /**
   * When transitioning from campaign budget optimization to non-campaign budget optimization, the default_ad_group_budget_in_micro_currency will propagate to each child ad groups daily budget. Unit is micro currency of the associated advertiser account.
   */
  default_ad_group_budget_in_micro_currency?: number | null;
  is_automated_campaign?: CampaignIsAutomatedCampaign;
};

export type CampaignCreateRequest = CampaignCreateCommon & {
  is_flexible_daily_budgets?: CampaignIsFlexibleDailyBudgets;
  is_automated_campaign?: CampaignIsAutomatedCampaign;
  status?: EntityStatus;
  objective_type: ObjectiveType;
};

export type CampaignCreateResponse = {
  items?: Array<CampaignCreateResponseItem>;
};

export type CampaignCreateResponseData = CampaignCreateCommon &
  CampaignResponse & {
    objective_type?: ObjectiveType;
  };

export type CampaignCreateResponseItem = {
  data?: CampaignCreateResponseData;
  exceptions?: Array<Exception>;
};

export type CampaignId = {
  /**
   * Campaign ID.
   */
  id?: string;
};

/**
 * Specifies whether the campaign was created in the automated campaign flow
 */
export type CampaignIsAutomatedCampaign = boolean | null;

/**
 * Determines if a campaign automatically generate ad-group level budgets given a campaign budget to maximize campaign outcome. When transitioning from non-cbo to cbo, all previous child ad group budget will be cleared.
 */
export type CampaignIsCampaignBudgetOptimization = boolean | null;

/**
 * Determine if a campaign has flexible daily budgets setup.
 */
export type CampaignIsFlexibleDailyBudgets = boolean | null;

export type CampaignResponse = CampaignId &
  CampaignCommon & {
    objective_type?: ObjectiveType;
    /**
     * Campaign creation time. Unix timestamp in seconds.
     */
    created_time?: number;
    /**
     * UTC timestamp. Last update time.
     */
    updated_time?: number;
    /**
     * Always "campaign".
     */
    type?: string;
    is_campaign_budget_optimization?: CampaignIsCampaignBudgetOptimization;
    summary_status?: CampaignSummaryStatus;
  };

/**
 * Summary status for campaign
 */
export type CampaignSummaryStatus =
  | 'RUNNING'
  | 'PAUSED'
  | 'NOT_STARTED'
  | 'COMPLETED'
  | 'ADVERTISER_DISABLED'
  | 'ARCHIVED'
  | 'DRAFT'
  | 'DELETED_DRAFT';

export type CampaignUpdateRequest = CampaignId &
  CampaignCreateCommon & {
    is_campaign_budget_optimization?: CampaignIsCampaignBudgetOptimization;
    objective_type?: ObjectiveType | null;
  };

export type CampaignUpdateResponse = CampaignCreateResponse;

export type CampaignsAnalyticsResponse = Array<{
  /**
   * The ID of the campaing that this metrics belongs to.
   */
  CAMPAIGN_ID: string;
  /**
   * Current metrics date. Only returned when granularity is a time-based value (`DAY`, `HOUR`, `WEEK`, `MONTH`)
   */
  DATE?: string;
  [key: string]: unknown | string;
}>;

/**
 * Request body used to cancel invites
 */
export type CancelInvitesBody = {
  /**
   * List of invite/request ids to be cancelled
   */
  invite_ids: Array<string>;
};

/**
 * Catalog entity
 */
export type Catalog = CatalogsDbItem & {
  /**
   * ID of the catalog entity.
   */
  id: string;
  /**
   * A human-friendly name associated to a catalog entity.
   */
  name: string | null;
  catalog_type: CatalogsType;
};

/**
 * Request object for creating a catalog.
 */
export type CatalogsCreateRequest = {
  /**
   * Type of the catalog entity.
   */
  catalog_type: 'HOTEL';
  /**
   * A human-friendly name associated to a given catalog.
   */
  name: string;
};

/**
 * Type of the catalog entity.
 */
export type catalog_type = 'HOTEL';

export type CatalogsDbItem = {
  created_at: string;
  id: string;
  updated_at: string;
};

export type CatalogsCreateReportResponse = {
  /**
   * Token to be used to get the report
   */
  token?: string;
};

export type CatalogsReport = {
  report_status?: 'FINISHED' | 'IN_PROGRESS';
  /**
   * URL to download the report
   */
  url?: string | null;
  /**
   * Size of the report in bytes
   */
  size?: number | null;
};

export type report_status = 'FINISHED' | 'IN_PROGRESS';

/**
 * Diagnostics aggregated numbers
 */
export type CatalogsReportStats = (CatalogsReportFeedIngestionStats | CatalogsReportDistributionStats) & {
  report_type: 'FEED_INGESTION_ISSUES' | 'DISTRIBUTION_ISSUES';
};

export type report_type = 'FEED_INGESTION_ISSUES' | 'DISTRIBUTION_ISSUES';

export type CatalogsReportFeedIngestionStats = {
  report_type?: 'FEED_INGESTION_ISSUES';
  /**
   * ID of the catalog entity.
   */
  catalog_id?: string;
  /**
   * The event code that a diagnostics aggregated number references
   */
  code?: number;
  /**
   * A human-friendly label for the event code (e.g, 'AVAILABILITY_INVALID')
   */
  code_label?: string;
  /**
   * Title message describing the diagnostic issue
   */
  message?: string;
  /**
   * Number of occurrences of the issue
   */
  occurrences?: number;
  /**
   * An ERROR means that items have been dropped, while a WARN denotes that items have been ingested despite an issue
   */
  severity?: 'WARN' | 'ERROR';
};

/**
 * An ERROR means that items have been dropped, while a WARN denotes that items have been ingested despite an issue
 */
export type severity = 'WARN' | 'ERROR';

export type CatalogsReportDistributionStats = {
  report_type?: 'DISTRIBUTION_ISSUES';
  /**
   * ID of the catalog entity.
   */
  catalog_id?: string;
  /**
   * The event code that a diagnostics aggregated number references
   */
  code?: number;
  /**
   * A human-friendly label for the event code (e.g, 'SPAM')
   */
  code_label?: string;
  /**
   * Title message describing the diagnostic issue
   */
  message?: string;
  /**
   * Number of occurrences of the issue
   */
  occurrences?: number;
  /**
   * Indicates if issue makes items ineligible for ads distribution
   */
  ineligible_for_ads?: boolean;
  /**
   * Indicates if issue makes items ineligible for organic distribution
   */
  ineligible_for_organic?: boolean;
};

/**
 * Report parameters
 */
export type CatalogsReportParameters = (CatalogsRetailReportParameters | CatalogsHotelReportParameters) & {
  catalog_type: CatalogsType;
};

/**
 * Parameters for hotel report
 */
export type CatalogsHotelReportParameters = {
  catalog_type: 'HOTEL';
  report: (CatalogsReportFeedIngestionFilter | CatalogsReportDistributionIssueFilter) & {
    report_type?: 'FEED_INGESTION_ISSUES' | 'DISTRIBUTION_ISSUES';
  };
};

/**
 * Parameters for retail report
 */
export type CatalogsRetailReportParameters = {
  catalog_type: 'RETAIL';
  report: (CatalogsReportFeedIngestionFilter | CatalogsReportDistributionIssueFilter) & {
    report_type?: 'FEED_INGESTION_ISSUES' | 'DISTRIBUTION_ISSUES';
  };
};

export type CatalogsReportFeedIngestionFilter = {
  report_type: 'FEED_INGESTION_ISSUES';
  /**
   * ID of the feed entity.
   */
  feed_id: string;
  /**
   * Unique identifier of a feed processing result. It can be acquired from the "id" field of the "items" array within the response of the [List processing results for a given feed](/docs/api/v5/#operation/feed_processing_results/list). If not provided, default to most recent completed processing result.
   */
  processing_result_id?: string;
};

export type report_type2 = 'FEED_INGESTION_ISSUES';

export type CatalogsReportDistributionIssueFilter = {
  report_type: 'DISTRIBUTION_ISSUES';
  /**
   * Unique identifier of a catalog. If not given, oldest catalog will be used
   */
  catalog_id?: string;
};

export type report_type3 = 'DISTRIBUTION_ISSUES';

/**
 * Hotel batch item
 */
export type CatalogsHotelBatchItem =
  | CatalogsCreateHotelItem
  | CatalogsUpsertHotelItem
  | CatalogsUpdateHotelItem
  | CatalogsDeleteHotelItem;

/**
 * Catalogs Feed object
 */
export type CatalogsFeed = CatalogsRetailFeed | CatalogsHotelFeed | CatalogsCreativeAssetsFeed;

/**
 * Catalogs Creative Asset Feed object
 */
export type CatalogsCreativeAssetsFeed = CatalogsDbItem & {
  /**
   * A human-friendly name associated to a given feed. This value is currently nullable due to historical reasons. It is expected to become non-nullable in the future.
   */
  name: string | null;
  format: CatalogsFormat;
  catalog_type: CatalogsType;
  credentials: CatalogsFeedCredentials;
  /**
   * The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.
   */
  location: string;
  preferred_processing_schedule: CatalogsFeedProcessingSchedule;
  status: CatalogsStatus;
  default_currency: NullableCurrency;
  /**
   * The locale used within a feed for product descriptions.
   */
  default_locale: string;
  default_country: Country;
  /**
   * Catalog id pertaining to the feed. If not provided, feed will use a default catalog based on type.
   */
  catalog_id: string | null;
};

/**
 * Catalogs Hotel Feed object
 */
export type CatalogsHotelFeed = CatalogsDbItem & {
  /**
   * A human-friendly name associated to a given feed. This value is currently nullable due to historical reasons. It is expected to become non-nullable in the future.
   */
  name: string | null;
  format: CatalogsFormat;
  catalog_type: CatalogsType;
  credentials: CatalogsFeedCredentials;
  /**
   * The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.
   */
  location: string;
  preferred_processing_schedule: CatalogsFeedProcessingSchedule;
  status: CatalogsStatus;
  default_currency: NullableCurrency;
  /**
   * The locale used within a feed for product descriptions.
   */
  default_locale: string;
  /**
   * Catalog id pertaining to the feed. If not provided, feed will use a default catalog based on type.
   */
  catalog_id: string | null;
};

/**
 * Catalogs Retail Feed object
 */
export type CatalogsRetailFeed = CatalogsDbItem & {
  /**
   * A human-friendly name associated to a given feed. This value is currently nullable due to historical reasons. It is expected to become non-nullable in the future.
   */
  name: string | null;
  format: CatalogsFormat;
  catalog_type: CatalogsType;
  credentials: CatalogsFeedCredentials;
  /**
   * The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.
   */
  location: string;
  preferred_processing_schedule: CatalogsFeedProcessingSchedule;
  status: CatalogsStatus;
  default_currency: NullableCurrency;
  /**
   * The locale used within a feed for product descriptions.
   */
  default_locale: string;
  default_country: Country;
  default_availability: ProductAvailabilityType;
};

/**
 * This field is **OPTIONAL**. Use this if your feed file requires username and password.
 */
export type CatalogsFeedCredentials = {
  /**
   * The required password for downloading a feed.
   */
  password: string;
  /**
   * The required username for downloading a feed.
   */
  username: string;
} | null;

export type CatalogsFeedIngestionDetails = {
  errors: CatalogsFeedIngestionErrors;
  info: CatalogsFeedIngestionInfo;
  warnings: CatalogsFeedIngestionWarnings;
};

export type CatalogsFeedIngestionErrors = {
  /**
   * We experienced a technical difficulty and were unable to ingest this some items. The next ingestion will happen in 24 hours.
   */
  LINE_LEVEL_INTERNAL_ERROR?: number;
  /**
   * The product count has decreased by more than 99% compared to the last successful ingestion.
   */
  LARGE_PRODUCT_COUNT_DECREASE?: 1;
  /**
   * We detected an issue with your account and are not currently ingesting your items. Please review our policies at policy.pinterest.com/community-guidelines#section-spam or contact us at help.pinterest.com/contact for more information.
   */
  ACCOUNT_FLAGGED?: number;
  /**
   * We experienced a technical difficulty and were unable to download some images. The next download attempt will happen in 24 hours.
   */
  IMAGE_LEVEL_INTERNAL_ERROR?: number;
  /**
   * Image files are unreadable. Please upload new files to continue.
   */
  IMAGE_FILE_NOT_ACCESSIBLE?: number;
  /**
   * Image files are unreadable. Please check your link and upload new files to continue.
   */
  IMAGE_MALFORMED_URL?: number;
  /**
   * Image files are unreadable. Please upload new files to continue.
   */
  IMAGE_FILE_NOT_FOUND?: number;
  /**
   * Image files are unreadable. Please upload new files to continue.
   */
  IMAGE_INVALID_FILE?: number;
};

/**
 * The product count has decreased by more than 99% compared to the last successful ingestion.
 */
export type LARGE_PRODUCT_COUNT_DECREASE = 1;

export type CatalogsFeedIngestionInfo = {
  /**
   * The number of ingested products that are in stock.
   */
  IN_STOCK?: number;
  /**
   * The number of ingested products that are in out of stock.
   */
  OUT_OF_STOCK?: number;
  /**
   * The number of ingested products that are in preorder.
   */
  PREORDER?: number;
};

export type CatalogsFeedIngestion = {
  id: string;
  feed_id: string;
  created_at: string;
  status: CatalogsFeedProcessingStatus;
};

export type CatalogsFeedIngestionWarnings = {
  /**
   * We experienced a technical difficulty and were unable to download some additional images. The next download attempt will happen in 24 hours.
   */
  ADDITIONAL_IMAGE_LEVEL_INTERNAL_ERROR?: number;
  /**
   * Additional image files are unreadable. Please upload new files to continue.
   */
  ADDITIONAL_IMAGE_FILE_NOT_ACCESSIBLE?: number;
  /**
   * Additional image files are unreadable. Please check your link and upload new files to continue.
   */
  ADDITIONAL_IMAGE_MALFORMED_URL?: number;
  /**
   * Additional image files are unreadable. Please upload new files to continue.
   */
  ADDITIONAL_IMAGE_FILE_NOT_FOUND?: number;
  /**
   * Additional image files are unreadable. Please upload new files to continue.
   */
  ADDITIONAL_IMAGE_INVALID_FILE?: number;
  /**
   * price is not a supported column. Use base_price and sale_price instead.
   */
  HOTEL_PRICE_HEADER_IS_PRESENT?: number;
};

export type CatalogsFeedProcessingResult = CatalogsDbItem & {
  ingestion_details: CatalogsFeedIngestionDetails;
  status: CatalogsFeedProcessingStatus;
  product_counts: CatalogsFeedProductCounts;
  validation_details: CatalogsFeedValidationDetails;
};

/**
 * Daily processing schedule. This field is **OPTIONAL**. Use this to configure the preferred time for processing a feed (otherwise random).
 */
export type CatalogsFeedProcessingSchedule = {
  /**
   * A time in format HH:MM with leading 0 (zero)
   */
  time: string;
  /**
   * The timezone considered for the processing schedule time.
   */
  timezone:
    | (
        | 'Africa/Abidjan'
        | 'Africa/Accra'
        | 'Africa/Algiers'
        | 'Africa/Bissau'
        | 'Africa/Cairo'
        | 'Africa/Casablanca'
        | 'Africa/Ceuta'
        | 'Africa/El_Aaiun'
        | 'Africa/Johannesburg'
        | 'Africa/Juba'
        | 'Africa/Khartoum'
        | 'Africa/Lagos'
        | 'Africa/Maputo'
        | 'Africa/Monrovia'
        | 'Africa/Nairobi'
        | 'Africa/Ndjamena'
        | 'Africa/Sao_Tome'
        | 'Africa/Tripoli'
        | 'Africa/Tunis'
        | 'Africa/Windhoek'
        | 'America/Adak'
        | 'America/Anchorage'
        | 'America/Araguaina'
        | 'America/Argentina/Buenos_Aires'
        | 'America/Argentina/Catamarca'
        | 'America/Argentina/Cordoba'
        | 'America/Argentina/Jujuy'
        | 'America/Argentina/La_Rioja'
        | 'America/Argentina/Mendoza'
        | 'America/Argentina/Rio_Gallegos'
        | 'America/Argentina/Salta'
        | 'America/Argentina/San_Juan'
        | 'America/Argentina/San_Luis'
        | 'America/Argentina/Tucuman'
        | 'America/Argentina/Ushuaia'
        | 'America/Asuncion'
        | 'America/Atikokan'
        | 'America/Bahia'
        | 'America/Bahia_Banderas'
        | 'America/Barbados'
        | 'America/Belem'
        | 'America/Belize'
        | 'America/Blanc-Sablon'
        | 'America/Boa_Vista'
        | 'America/Bogota'
        | 'America/Boise'
        | 'America/Cambridge_Bay'
        | 'America/Campo_Grande'
        | 'America/Cancun'
        | 'America/Caracas'
        | 'America/Cayenne'
        | 'America/Chicago'
        | 'America/Chihuahua'
        | 'America/Costa_Rica'
        | 'America/Creston'
        | 'America/Cuiaba'
        | 'America/Curacao'
        | 'America/Danmarkshavn'
        | 'America/Dawson'
        | 'America/Dawson_Creek'
        | 'America/Denver'
        | 'America/Detroit'
        | 'America/Edmonton'
        | 'America/Eirunepe'
        | 'America/El_Salvador'
        | 'America/Fort_Nelson'
        | 'America/Fortaleza'
        | 'America/Glace_Bay'
        | 'America/Goose_Bay'
        | 'America/Grand_Turk'
        | 'America/Guatemala'
        | 'America/Guayaquil'
        | 'America/Guyana'
        | 'America/Halifax'
        | 'America/Havana'
        | 'America/Hermosillo'
        | 'America/Indiana/Indianapolis'
        | 'America/Indiana/Knox'
        | 'America/Indiana/Marengo'
        | 'America/Indiana/Petersburg'
        | 'America/Indiana/Tell_City'
        | 'America/Indiana/Vevay'
        | 'America/Indiana/Vincennes'
        | 'America/Indiana/Winamac'
        | 'America/Inuvik'
        | 'America/Iqaluit'
        | 'America/Jamaica'
        | 'America/Juneau'
        | 'America/Kentucky/Louisville'
        | 'America/Kentucky/Monticello'
        | 'America/La_Paz'
        | 'America/Lima'
        | 'America/Los_Angeles'
        | 'America/Maceio'
        | 'America/Managua'
        | 'America/Manaus'
        | 'America/Martinique'
        | 'America/Matamoros'
        | 'America/Mazatlan'
        | 'America/Menominee'
        | 'America/Merida'
        | 'America/Metlakatla'
        | 'America/Mexico_City'
        | 'America/Miquelon'
        | 'America/Moncton'
        | 'America/Monterrey'
        | 'America/Montevideo'
        | 'America/Nassau'
        | 'America/New_York'
        | 'America/Nipigon'
        | 'America/Nome'
        | 'America/Noronha'
        | 'America/North_Dakota/Beulah'
        | 'America/North_Dakota/Center'
        | 'America/North_Dakota/New_Salem'
        | 'America/Nuuk'
        | 'America/Ojinaga'
        | 'America/Panama'
        | 'America/Pangnirtung'
        | 'America/Paramaribo'
        | 'America/Phoenix'
        | 'America/Port-au-Prince'
        | 'America/Port_of_Spain'
        | 'America/Porto_Velho'
        | 'America/Puerto_Rico'
        | 'America/Punta_Arenas'
        | 'America/Rainy_River'
        | 'America/Rankin_Inlet'
        | 'America/Recife'
        | 'America/Regina'
        | 'America/Resolute'
        | 'America/Rio_Branco'
        | 'America/Santarem'
        | 'America/Santiago'
        | 'America/Santo_Domingo'
        | 'America/Sao_Paulo'
        | 'America/Scoresbysund'
        | 'America/Sitka'
        | 'America/St_Johns'
        | 'America/Swift_Current'
        | 'America/Tegucigalpa'
        | 'America/Thule'
        | 'America/Thunder_Bay'
        | 'America/Tijuana'
        | 'America/Toronto'
        | 'America/Vancouver'
        | 'America/Whitehorse'
        | 'America/Winnipeg'
        | 'America/Yakutat'
        | 'America/Yellowknife'
        | 'Antarctica/Casey'
        | 'Antarctica/Davis'
        | 'Antarctica/DumontDUrville'
        | 'Antarctica/Macquarie'
        | 'Antarctica/Mawson'
        | 'Antarctica/Palmer'
        | 'Antarctica/Rothera'
        | 'Antarctica/Syowa'
        | 'Antarctica/Troll'
        | 'Antarctica/Vostok'
        | 'Asia/Almaty'
        | 'Asia/Amman'
        | 'Asia/Anadyr'
        | 'Asia/Aqtau'
        | 'Asia/Aqtobe'
        | 'Asia/Ashgabat'
        | 'Asia/Atyrau'
        | 'Asia/Baghdad'
        | 'Asia/Baku'
        | 'Asia/Bangkok'
        | 'Asia/Barnaul'
        | 'Asia/Beirut'
        | 'Asia/Bishkek'
        | 'Asia/Brunei'
        | 'Asia/Chita'
        | 'Asia/Choibalsan'
        | 'Asia/Colombo'
        | 'Asia/Damascus'
        | 'Asia/Dhaka'
        | 'Asia/Dili'
        | 'Asia/Dubai'
        | 'Asia/Dushanbe'
        | 'Asia/Famagusta'
        | 'Asia/Gaza'
        | 'Asia/Hebron'
        | 'Asia/Ho_Chi_Minh'
        | 'Asia/Hong_Kong'
        | 'Asia/Hovd'
        | 'Asia/Irkutsk'
        | 'Asia/Jakarta'
        | 'Asia/Jayapura'
        | 'Asia/Jerusalem'
        | 'Asia/Kabul'
        | 'Asia/Kamchatka'
        | 'Asia/Karachi'
        | 'Asia/Kathmandu'
        | 'Asia/Khandyga'
        | 'Asia/Kolkata'
        | 'Asia/Krasnoyarsk'
        | 'Asia/Kuala_Lumpur'
        | 'Asia/Kuching'
        | 'Asia/Macau'
        | 'Asia/Magadan'
        | 'Asia/Makassar'
        | 'Asia/Manila'
        | 'Asia/Nicosia'
        | 'Asia/Novokuznetsk'
        | 'Asia/Novosibirsk'
        | 'Asia/Omsk'
        | 'Asia/Oral'
        | 'Asia/Pontianak'
        | 'Asia/Pyongyang'
        | 'Asia/Qatar'
        | 'Asia/Qostanay'
        | 'Asia/Qyzylorda'
        | 'Asia/Riyadh'
        | 'Asia/Sakhalin'
        | 'Asia/Samarkand'
        | 'Asia/Seoul'
        | 'Asia/Shanghai'
        | 'Asia/Singapore'
        | 'Asia/Srednekolymsk'
        | 'Asia/Taipei'
        | 'Asia/Tashkent'
        | 'Asia/Tbilisi'
        | 'Asia/Tehran'
        | 'Asia/Thimphu'
        | 'Asia/Tokyo'
        | 'Asia/Tomsk'
        | 'Asia/Ulaanbaatar'
        | 'Asia/Urumqi'
        | 'Asia/Ust-Nera'
        | 'Asia/Vladivostok'
        | 'Asia/Yakutsk'
        | 'Asia/Yangon'
        | 'Asia/Yekaterinburg'
        | 'Asia/Yerevan'
        | 'Atlantic/Azores'
        | 'Atlantic/Bermuda'
        | 'Atlantic/Canary'
        | 'Atlantic/Cape_Verde'
        | 'Atlantic/Faroe'
        | 'Atlantic/Madeira'
        | 'Atlantic/Reykjavik'
        | 'Atlantic/South_Georgia'
        | 'Atlantic/Stanley'
        | 'Australia/Adelaide'
        | 'Australia/Brisbane'
        | 'Australia/Broken_Hill'
        | 'Australia/Currie'
        | 'Australia/Darwin'
        | 'Australia/Eucla'
        | 'Australia/Hobart'
        | 'Australia/Lindeman'
        | 'Australia/Lord_Howe'
        | 'Australia/Melbourne'
        | 'Australia/Perth'
        | 'Australia/Sydney'
        | 'CET'
        | 'CST6CDT'
        | 'EET'
        | 'EST'
        | 'EST5EDT'
        | 'Etc/GMT'
        | 'Etc/GMT+1'
        | 'Etc/GMT+10'
        | 'Etc/GMT+11'
        | 'Etc/GMT+12'
        | 'Etc/GMT+2'
        | 'Etc/GMT+3'
        | 'Etc/GMT+4'
        | 'Etc/GMT+5'
        | 'Etc/GMT+6'
        | 'Etc/GMT+7'
        | 'Etc/GMT+8'
        | 'Etc/GMT+9'
        | 'Etc/GMT-1'
        | 'Etc/GMT-10'
        | 'Etc/GMT-11'
        | 'Etc/GMT-12'
        | 'Etc/GMT-13'
        | 'Etc/GMT-14'
        | 'Etc/GMT-2'
        | 'Etc/GMT-3'
        | 'Etc/GMT-4'
        | 'Etc/GMT-5'
        | 'Etc/GMT-6'
        | 'Etc/GMT-7'
        | 'Etc/GMT-8'
        | 'Etc/GMT-9'
        | 'Etc/UTC'
        | 'Europe/Amsterdam'
        | 'Europe/Andorra'
        | 'Europe/Astrakhan'
        | 'Europe/Athens'
        | 'Europe/Belgrade'
        | 'Europe/Berlin'
        | 'Europe/Brussels'
        | 'Europe/Bucharest'
        | 'Europe/Budapest'
        | 'Europe/Chisinau'
        | 'Europe/Copenhagen'
        | 'Europe/Dublin'
        | 'Europe/Gibraltar'
        | 'Europe/Helsinki'
        | 'Europe/Istanbul'
        | 'Europe/Kaliningrad'
        | 'Europe/Kiev'
        | 'Europe/Kirov'
        | 'Europe/Lisbon'
        | 'Europe/London'
        | 'Europe/Luxembourg'
        | 'Europe/Madrid'
        | 'Europe/Malta'
        | 'Europe/Minsk'
        | 'Europe/Monaco'
        | 'Europe/Moscow'
        | 'Europe/Oslo'
        | 'Europe/Paris'
        | 'Europe/Prague'
        | 'Europe/Riga'
        | 'Europe/Rome'
        | 'Europe/Samara'
        | 'Europe/Saratov'
        | 'Europe/Simferopol'
        | 'Europe/Sofia'
        | 'Europe/Stockholm'
        | 'Europe/Tallinn'
        | 'Europe/Tirane'
        | 'Europe/Ulyanovsk'
        | 'Europe/Uzhgorod'
        | 'Europe/Vienna'
        | 'Europe/Vilnius'
        | 'Europe/Volgograd'
        | 'Europe/Warsaw'
        | 'Europe/Zaporozhye'
        | 'Europe/Zurich'
        | 'HST'
        | 'Indian/Chagos'
        | 'Indian/Christmas'
        | 'Indian/Cocos'
        | 'Indian/Kerguelen'
        | 'Indian/Mahe'
        | 'Indian/Maldives'
        | 'Indian/Mauritius'
        | 'Indian/Reunion'
        | 'MET'
        | 'MST'
        | 'MST7MDT'
        | 'PST8PDT'
        | 'Pacific/Apia'
        | 'Pacific/Auckland'
        | 'Pacific/Bougainville'
        | 'Pacific/Chatham'
        | 'Pacific/Chuuk'
        | 'Pacific/Easter'
        | 'Pacific/Efate'
        | 'Pacific/Enderbury'
        | 'Pacific/Fakaofo'
        | 'Pacific/Fiji'
        | 'Pacific/Funafuti'
        | 'Pacific/Galapagos'
        | 'Pacific/Gambier'
        | 'Pacific/Guadalcanal'
        | 'Pacific/Guam'
        | 'Pacific/Honolulu'
        | 'Pacific/Kiritimati'
        | 'Pacific/Kosrae'
        | 'Pacific/Kwajalein'
        | 'Pacific/Majuro'
        | 'Pacific/Marquesas'
        | 'Pacific/Nauru'
        | 'Pacific/Niue'
        | 'Pacific/Norfolk'
        | 'Pacific/Noumea'
        | 'Pacific/Pago_Pago'
        | 'Pacific/Palau'
        | 'Pacific/Pitcairn'
        | 'Pacific/Pohnpei'
        | 'Pacific/Port_Moresby'
        | 'Pacific/Rarotonga'
        | 'Pacific/Tahiti'
        | 'Pacific/Tarawa'
        | 'Pacific/Tongatapu'
        | 'Pacific/Wake'
        | 'Pacific/Wallis'
        | 'WET'
      )
    | null;
} | null;

/**
 * The timezone considered for the processing schedule time.
 */
export type timezone =
  | 'Africa/Abidjan'
  | 'Africa/Accra'
  | 'Africa/Algiers'
  | 'Africa/Bissau'
  | 'Africa/Cairo'
  | 'Africa/Casablanca'
  | 'Africa/Ceuta'
  | 'Africa/El_Aaiun'
  | 'Africa/Johannesburg'
  | 'Africa/Juba'
  | 'Africa/Khartoum'
  | 'Africa/Lagos'
  | 'Africa/Maputo'
  | 'Africa/Monrovia'
  | 'Africa/Nairobi'
  | 'Africa/Ndjamena'
  | 'Africa/Sao_Tome'
  | 'Africa/Tripoli'
  | 'Africa/Tunis'
  | 'Africa/Windhoek'
  | 'America/Adak'
  | 'America/Anchorage'
  | 'America/Araguaina'
  | 'America/Argentina/Buenos_Aires'
  | 'America/Argentina/Catamarca'
  | 'America/Argentina/Cordoba'
  | 'America/Argentina/Jujuy'
  | 'America/Argentina/La_Rioja'
  | 'America/Argentina/Mendoza'
  | 'America/Argentina/Rio_Gallegos'
  | 'America/Argentina/Salta'
  | 'America/Argentina/San_Juan'
  | 'America/Argentina/San_Luis'
  | 'America/Argentina/Tucuman'
  | 'America/Argentina/Ushuaia'
  | 'America/Asuncion'
  | 'America/Atikokan'
  | 'America/Bahia'
  | 'America/Bahia_Banderas'
  | 'America/Barbados'
  | 'America/Belem'
  | 'America/Belize'
  | 'America/Blanc-Sablon'
  | 'America/Boa_Vista'
  | 'America/Bogota'
  | 'America/Boise'
  | 'America/Cambridge_Bay'
  | 'America/Campo_Grande'
  | 'America/Cancun'
  | 'America/Caracas'
  | 'America/Cayenne'
  | 'America/Chicago'
  | 'America/Chihuahua'
  | 'America/Costa_Rica'
  | 'America/Creston'
  | 'America/Cuiaba'
  | 'America/Curacao'
  | 'America/Danmarkshavn'
  | 'America/Dawson'
  | 'America/Dawson_Creek'
  | 'America/Denver'
  | 'America/Detroit'
  | 'America/Edmonton'
  | 'America/Eirunepe'
  | 'America/El_Salvador'
  | 'America/Fort_Nelson'
  | 'America/Fortaleza'
  | 'America/Glace_Bay'
  | 'America/Goose_Bay'
  | 'America/Grand_Turk'
  | 'America/Guatemala'
  | 'America/Guayaquil'
  | 'America/Guyana'
  | 'America/Halifax'
  | 'America/Havana'
  | 'America/Hermosillo'
  | 'America/Indiana/Indianapolis'
  | 'America/Indiana/Knox'
  | 'America/Indiana/Marengo'
  | 'America/Indiana/Petersburg'
  | 'America/Indiana/Tell_City'
  | 'America/Indiana/Vevay'
  | 'America/Indiana/Vincennes'
  | 'America/Indiana/Winamac'
  | 'America/Inuvik'
  | 'America/Iqaluit'
  | 'America/Jamaica'
  | 'America/Juneau'
  | 'America/Kentucky/Louisville'
  | 'America/Kentucky/Monticello'
  | 'America/La_Paz'
  | 'America/Lima'
  | 'America/Los_Angeles'
  | 'America/Maceio'
  | 'America/Managua'
  | 'America/Manaus'
  | 'America/Martinique'
  | 'America/Matamoros'
  | 'America/Mazatlan'
  | 'America/Menominee'
  | 'America/Merida'
  | 'America/Metlakatla'
  | 'America/Mexico_City'
  | 'America/Miquelon'
  | 'America/Moncton'
  | 'America/Monterrey'
  | 'America/Montevideo'
  | 'America/Nassau'
  | 'America/New_York'
  | 'America/Nipigon'
  | 'America/Nome'
  | 'America/Noronha'
  | 'America/North_Dakota/Beulah'
  | 'America/North_Dakota/Center'
  | 'America/North_Dakota/New_Salem'
  | 'America/Nuuk'
  | 'America/Ojinaga'
  | 'America/Panama'
  | 'America/Pangnirtung'
  | 'America/Paramaribo'
  | 'America/Phoenix'
  | 'America/Port-au-Prince'
  | 'America/Port_of_Spain'
  | 'America/Porto_Velho'
  | 'America/Puerto_Rico'
  | 'America/Punta_Arenas'
  | 'America/Rainy_River'
  | 'America/Rankin_Inlet'
  | 'America/Recife'
  | 'America/Regina'
  | 'America/Resolute'
  | 'America/Rio_Branco'
  | 'America/Santarem'
  | 'America/Santiago'
  | 'America/Santo_Domingo'
  | 'America/Sao_Paulo'
  | 'America/Scoresbysund'
  | 'America/Sitka'
  | 'America/St_Johns'
  | 'America/Swift_Current'
  | 'America/Tegucigalpa'
  | 'America/Thule'
  | 'America/Thunder_Bay'
  | 'America/Tijuana'
  | 'America/Toronto'
  | 'America/Vancouver'
  | 'America/Whitehorse'
  | 'America/Winnipeg'
  | 'America/Yakutat'
  | 'America/Yellowknife'
  | 'Antarctica/Casey'
  | 'Antarctica/Davis'
  | 'Antarctica/DumontDUrville'
  | 'Antarctica/Macquarie'
  | 'Antarctica/Mawson'
  | 'Antarctica/Palmer'
  | 'Antarctica/Rothera'
  | 'Antarctica/Syowa'
  | 'Antarctica/Troll'
  | 'Antarctica/Vostok'
  | 'Asia/Almaty'
  | 'Asia/Amman'
  | 'Asia/Anadyr'
  | 'Asia/Aqtau'
  | 'Asia/Aqtobe'
  | 'Asia/Ashgabat'
  | 'Asia/Atyrau'
  | 'Asia/Baghdad'
  | 'Asia/Baku'
  | 'Asia/Bangkok'
  | 'Asia/Barnaul'
  | 'Asia/Beirut'
  | 'Asia/Bishkek'
  | 'Asia/Brunei'
  | 'Asia/Chita'
  | 'Asia/Choibalsan'
  | 'Asia/Colombo'
  | 'Asia/Damascus'
  | 'Asia/Dhaka'
  | 'Asia/Dili'
  | 'Asia/Dubai'
  | 'Asia/Dushanbe'
  | 'Asia/Famagusta'
  | 'Asia/Gaza'
  | 'Asia/Hebron'
  | 'Asia/Ho_Chi_Minh'
  | 'Asia/Hong_Kong'
  | 'Asia/Hovd'
  | 'Asia/Irkutsk'
  | 'Asia/Jakarta'
  | 'Asia/Jayapura'
  | 'Asia/Jerusalem'
  | 'Asia/Kabul'
  | 'Asia/Kamchatka'
  | 'Asia/Karachi'
  | 'Asia/Kathmandu'
  | 'Asia/Khandyga'
  | 'Asia/Kolkata'
  | 'Asia/Krasnoyarsk'
  | 'Asia/Kuala_Lumpur'
  | 'Asia/Kuching'
  | 'Asia/Macau'
  | 'Asia/Magadan'
  | 'Asia/Makassar'
  | 'Asia/Manila'
  | 'Asia/Nicosia'
  | 'Asia/Novokuznetsk'
  | 'Asia/Novosibirsk'
  | 'Asia/Omsk'
  | 'Asia/Oral'
  | 'Asia/Pontianak'
  | 'Asia/Pyongyang'
  | 'Asia/Qatar'
  | 'Asia/Qostanay'
  | 'Asia/Qyzylorda'
  | 'Asia/Riyadh'
  | 'Asia/Sakhalin'
  | 'Asia/Samarkand'
  | 'Asia/Seoul'
  | 'Asia/Shanghai'
  | 'Asia/Singapore'
  | 'Asia/Srednekolymsk'
  | 'Asia/Taipei'
  | 'Asia/Tashkent'
  | 'Asia/Tbilisi'
  | 'Asia/Tehran'
  | 'Asia/Thimphu'
  | 'Asia/Tokyo'
  | 'Asia/Tomsk'
  | 'Asia/Ulaanbaatar'
  | 'Asia/Urumqi'
  | 'Asia/Ust-Nera'
  | 'Asia/Vladivostok'
  | 'Asia/Yakutsk'
  | 'Asia/Yangon'
  | 'Asia/Yekaterinburg'
  | 'Asia/Yerevan'
  | 'Atlantic/Azores'
  | 'Atlantic/Bermuda'
  | 'Atlantic/Canary'
  | 'Atlantic/Cape_Verde'
  | 'Atlantic/Faroe'
  | 'Atlantic/Madeira'
  | 'Atlantic/Reykjavik'
  | 'Atlantic/South_Georgia'
  | 'Atlantic/Stanley'
  | 'Australia/Adelaide'
  | 'Australia/Brisbane'
  | 'Australia/Broken_Hill'
  | 'Australia/Currie'
  | 'Australia/Darwin'
  | 'Australia/Eucla'
  | 'Australia/Hobart'
  | 'Australia/Lindeman'
  | 'Australia/Lord_Howe'
  | 'Australia/Melbourne'
  | 'Australia/Perth'
  | 'Australia/Sydney'
  | 'CET'
  | 'CST6CDT'
  | 'EET'
  | 'EST'
  | 'EST5EDT'
  | 'Etc/GMT'
  | 'Etc/GMT+1'
  | 'Etc/GMT+10'
  | 'Etc/GMT+11'
  | 'Etc/GMT+12'
  | 'Etc/GMT+2'
  | 'Etc/GMT+3'
  | 'Etc/GMT+4'
  | 'Etc/GMT+5'
  | 'Etc/GMT+6'
  | 'Etc/GMT+7'
  | 'Etc/GMT+8'
  | 'Etc/GMT+9'
  | 'Etc/GMT-1'
  | 'Etc/GMT-10'
  | 'Etc/GMT-11'
  | 'Etc/GMT-12'
  | 'Etc/GMT-13'
  | 'Etc/GMT-14'
  | 'Etc/GMT-2'
  | 'Etc/GMT-3'
  | 'Etc/GMT-4'
  | 'Etc/GMT-5'
  | 'Etc/GMT-6'
  | 'Etc/GMT-7'
  | 'Etc/GMT-8'
  | 'Etc/GMT-9'
  | 'Etc/UTC'
  | 'Europe/Amsterdam'
  | 'Europe/Andorra'
  | 'Europe/Astrakhan'
  | 'Europe/Athens'
  | 'Europe/Belgrade'
  | 'Europe/Berlin'
  | 'Europe/Brussels'
  | 'Europe/Bucharest'
  | 'Europe/Budapest'
  | 'Europe/Chisinau'
  | 'Europe/Copenhagen'
  | 'Europe/Dublin'
  | 'Europe/Gibraltar'
  | 'Europe/Helsinki'
  | 'Europe/Istanbul'
  | 'Europe/Kaliningrad'
  | 'Europe/Kiev'
  | 'Europe/Kirov'
  | 'Europe/Lisbon'
  | 'Europe/London'
  | 'Europe/Luxembourg'
  | 'Europe/Madrid'
  | 'Europe/Malta'
  | 'Europe/Minsk'
  | 'Europe/Monaco'
  | 'Europe/Moscow'
  | 'Europe/Oslo'
  | 'Europe/Paris'
  | 'Europe/Prague'
  | 'Europe/Riga'
  | 'Europe/Rome'
  | 'Europe/Samara'
  | 'Europe/Saratov'
  | 'Europe/Simferopol'
  | 'Europe/Sofia'
  | 'Europe/Stockholm'
  | 'Europe/Tallinn'
  | 'Europe/Tirane'
  | 'Europe/Ulyanovsk'
  | 'Europe/Uzhgorod'
  | 'Europe/Vienna'
  | 'Europe/Vilnius'
  | 'Europe/Volgograd'
  | 'Europe/Warsaw'
  | 'Europe/Zaporozhye'
  | 'Europe/Zurich'
  | 'HST'
  | 'Indian/Chagos'
  | 'Indian/Christmas'
  | 'Indian/Cocos'
  | 'Indian/Kerguelen'
  | 'Indian/Mahe'
  | 'Indian/Maldives'
  | 'Indian/Mauritius'
  | 'Indian/Reunion'
  | 'MET'
  | 'MST'
  | 'MST7MDT'
  | 'PST8PDT'
  | 'Pacific/Apia'
  | 'Pacific/Auckland'
  | 'Pacific/Bougainville'
  | 'Pacific/Chatham'
  | 'Pacific/Chuuk'
  | 'Pacific/Easter'
  | 'Pacific/Efate'
  | 'Pacific/Enderbury'
  | 'Pacific/Fakaofo'
  | 'Pacific/Fiji'
  | 'Pacific/Funafuti'
  | 'Pacific/Galapagos'
  | 'Pacific/Gambier'
  | 'Pacific/Guadalcanal'
  | 'Pacific/Guam'
  | 'Pacific/Honolulu'
  | 'Pacific/Kiritimati'
  | 'Pacific/Kosrae'
  | 'Pacific/Kwajalein'
  | 'Pacific/Majuro'
  | 'Pacific/Marquesas'
  | 'Pacific/Nauru'
  | 'Pacific/Niue'
  | 'Pacific/Norfolk'
  | 'Pacific/Noumea'
  | 'Pacific/Pago_Pago'
  | 'Pacific/Palau'
  | 'Pacific/Pitcairn'
  | 'Pacific/Pohnpei'
  | 'Pacific/Port_Moresby'
  | 'Pacific/Rarotonga'
  | 'Pacific/Tahiti'
  | 'Pacific/Tarawa'
  | 'Pacific/Tongatapu'
  | 'Pacific/Wake'
  | 'Pacific/Wallis'
  | 'WET';

export type CatalogsFeedProcessingStatus = 'COMPLETED' | 'FAILED' | 'PROCESSING';

/**
 * The counts can be null early in the process.
 */
export type CatalogsFeedProductCounts = {
  /**
   * The number of products in the feed file.
   */
  original?: number;
  /**
   * The number of products successfully ingested from the feed file.
   */
  ingested?: number;
} | null;

export type CatalogsFeedValidationDetails = {
  errors: CatalogsFeedValidationErrors;
  warnings: CatalogsFeedValidationWarnings;
};

export type CatalogsFeedValidationErrors = {
  /**
   * Pinterest couldn't download your feed.
   */
  FETCH_ERROR?: number;
  /**
   * Your feed wasn't ingested because it hasn’t changed in the previous 90 days.
   */
  FETCH_INACTIVE_FEED_ERROR?: number;
  /**
   * Your feed includes data with an unsupported encoding format.
   */
  ENCODING_ERROR?: number;
  /**
   * Your feed includes data with formatting errors.
   */
  DELIMITER_ERROR?: number;
  /**
   * Your feed is missing some required column headers.
   */
  REQUIRED_COLUMNS_MISSING?: number;
  /**
   * Some products are duplicated.
   */
  DUPLICATE_PRODUCTS?: number;
  /**
   * Some image links are formatted incorrectly.
   */
  IMAGE_LINK_INVALID?: number;
  /**
   * Some items are missing an item id in their product metadata, those items will not be published.
   */
  ITEMID_MISSING?: number;
  /**
   * Some items are missing a title in their product metadata, those items will not be published.
   */
  TITLE_MISSING?: number;
  /**
   * Some items are missing a description in their product metadata, those items will not be published.
   */
  DESCRIPTION_MISSING?: number;
  /**
   * Some items are missing a link URL in their product metadata, those items will not be published.
   */
  PRODUCT_LINK_MISSING?: number;
  /**
   * Some items are missing an image link URL in their product metadata, those items will not be published.
   */
  IMAGE_LINK_MISSING?: number;
  /**
   * Some items are missing an availability value in their product metadata, those items will not be published.
   */
  AVAILABILITY_INVALID?: number;
  /**
   * Some items have price formatting errors in their product metadata, those items will not be published.
   */
  PRODUCT_PRICE_INVALID?: number;
  /**
   * Some link values are formatted incorrectly.
   */
  LINK_FORMAT_INVALID?: number;
  /**
   * Your feed contains formatting errors for some items.
   */
  PARSE_LINE_ERROR?: number;
  /**
   * Some adwords links contain too many characters.
   */
  ADWORDS_FORMAT_INVALID?: number;
  /**
   * We experienced a technical difficulty and were unable to ingest your feed. The next ingestion will happen in 24 hours.
   */
  INTERNAL_SERVICE_ERROR?: number;
  /**
   * Your merchant domain needs to be claimed.
   */
  NO_VERIFIED_DOMAIN?: number;
  /**
   * Some items have invalid adult values.
   */
  ADULT_INVALID?: number;
  /**
   * Some items have image_link URLs that contain too many characters, so those items will not be published.
   */
  IMAGE_LINK_LENGTH_TOO_LONG?: number;
  /**
   * Some of your product link values don't match the verified domain associated with this account.
   */
  INVALID_DOMAIN?: number;
  /**
   * Your feed contains too many items, some items will not be published.
   */
  FEED_LENGTH_TOO_LONG?: number;
  /**
   * Some product links contain too many characters, those items will not be published.
   */
  LINK_LENGTH_TOO_LONG?: number;
  /**
   * Your feed couldn't be validated because the xml file is formatted incorrectly.
   */
  MALFORMED_XML?: number;
  /**
   * Some products are missing a price, those items will not be published.
   */
  PRICE_MISSING?: number;
  /**
   * Your feed couldn't be validated because the file doesn't contain the minimum number of lines required.
   */
  FEED_TOO_SMALL?: number;
  /**
   * Some items exceed the maximum number of items per item group, those items will not be published.
   */
  MAX_ITEMS_PER_ITEM_GROUP_EXCEEDED?: number;
  /**
   * Some items' main images can't be found.
   */
  ITEM_MAIN_IMAGE_DOWNLOAD_FAILURE?: number;
  /**
   * Some items were not published because they don't meet Pinterest's Merchant Guidelines.
   */
  PINJOIN_CONTENT_UNSAFE?: number;
  /**
   * Some items were not published because they don't meet Pinterest's Merchant Guidelines.
   */
  BLOCKLISTED_IMAGE_SIGNATURE?: number;
  /**
   * Some items have list price formatting errors in their product metadata, those items will not be published.
   */
  LIST_PRICE_INVALID?: number;
  /**
   * Some items were not published because price cannot be determined. The price, list price, and sale price are all different, so those items will not be published.
   */
  PRICE_CANNOT_BE_DETERMINED?: number;
};

export type CatalogsFeedValidationWarnings = {
  /**
   * Some items have ad links that are formatted incorrectly.
   */
  AD_LINK_FORMAT_WARNING?: number;
  /**
   * Some items have ad link URLs that are duplicates of the link URLs for those items.
   */
  AD_LINK_SAME_AS_LINK?: number;
  /**
   * The title for some items were truncated because they contain too many characters.
   */
  TITLE_LENGTH_TOO_LONG?: number;
  /**
   * The description for some items were truncated because they contain too many characters.
   */
  DESCRIPTION_LENGTH_TOO_LONG?: number;
  /**
   * Some items have gender values that are formatted incorrectly, which may limit visibility in recommendations, search results and shopping experiences.
   */
  GENDER_INVALID?: number;
  /**
   * Some items have age group values that are formatted incorrectly, which may limit visibility in recommendations, search results and shopping experiences.
   */
  AGE_GROUP_INVALID?: number;
  /**
   * Some items have size type values that are formatted incorrectly, which may limit visibility in recommendations, search results and shopping experiences.
   */
  SIZE_TYPE_INVALID?: number;
  /**
   * Some items have size system values which are not one of the supported size systems.
   */
  SIZE_SYSTEM_INVALID?: number;
  /**
   * Some items have an invalid product link which contains invalid UTM tracking paramaters.
   */
  LINK_FORMAT_WARNING?: number;
  /**
   * Some items have sale price values that are higher than the original price of the item.
   */
  SALES_PRICE_INVALID?: number;
  /**
   * Some items only have 1 or 2 levels of google_product_category values, which may limit visibility in recommendations, search results and shopping experiences.
   */
  PRODUCT_CATEGORY_DEPTH_WARNING?: number;
  /**
   * Some items have adwords_redirect links that are formatted incorrectly.
   */
  ADWORDS_FORMAT_WARNING?: number;
  /**
   * Some items have adwords_redirect URLs that are duplicates of the link URLs for those items.
   */
  ADWORDS_SAME_AS_LINK?: number;
  /**
   * Your feed contains duplicate headers.
   */
  DUPLICATE_HEADERS?: number;
  /**
   * Ingestion completed early because there are no changes to your feed since the last successful update.
   */
  FETCH_SAME_SIGNATURE?: 1;
  /**
   * Some items have additional_image_link URLs that contain too many characters, so those items will not be published.
   */
  ADDITIONAL_IMAGE_LINK_LENGTH_TOO_LONG?: number;
  /**
   * Some items have additional_image_link URLs that are formatted incorrectly and will not be published with your items.
   */
  ADDITIONAL_IMAGE_LINK_WARNING?: number;
  /**
   * Some items have image_link URLs that are formatted incorrectly and will not be published with those items.
   */
  IMAGE_LINK_WARNING?: number;
  /**
   * Some items have shipping values that are formatted incorrectly.
   */
  SHIPPING_INVALID?: number;
  /**
   * Some items have tax values that are formatted incorrectly.
   */
  TAX_INVALID?: number;
  /**
   * Some items have invalid shipping_weight values.
   */
  SHIPPING_WEIGHT_INVALID?: number;
  /**
   * Some items have expiration_date values that are formatted incorrectly, those items will be published without an expiration date.
   */
  EXPIRATION_DATE_INVALID?: number;
  /**
   * Some items have availability_date values that are formatted incorrectly, those items will be published without an availability date.
   */
  AVAILABILITY_DATE_INVALID?: number;
  /**
   * Some items have sale_price_effective_date values that are formatted incorrectly, those items will be published without a sale date.
   */
  SALE_DATE_INVALID?: number;
  /**
   * Some items have weight_unit values that are formatted incorrectly, those items will be published without a weight unit.
   */
  WEIGHT_UNIT_INVALID?: number;
  /**
   * Some items have is_bundle values that are formatted incorrectly, those items will be published without being bundled with other products.
   */
  IS_BUNDLE_INVALID?: number;
  /**
   * Some items have updated_time values thate are formatted incorrectly, those items will be published without an updated time.
   */
  UPDATED_TIME_INVALID?: number;
  /**
   * Some items have custom_label values that are too long, those items will be published without that custom label.
   */
  CUSTOM_LABEL_LENGTH_TOO_LONG?: number;
  /**
   * Some items have product_type values that are too long, those items will be published without that product type.
   */
  PRODUCT_TYPE_LENGTH_TOO_LONG?: number;
  /**
   * Some items have additional_image_link values that exceed the limit for additional images, those items will be published without some of your images.
   */
  TOO_MANY_ADDITIONAL_IMAGE_LINKS?: number;
  /**
   * Some items have invalid multipack values.
   */
  MULTIPACK_INVALID?: number;
  /**
   * The product count has increased or decreased significantly compared to the last successful ingestion.
   */
  INDEXED_PRODUCT_COUNT_LARGE_DELTA?: number;
  /**
   * Some items include additional_image_links that can't be found.
   */
  ITEM_ADDITIONAL_IMAGE_DOWNLOAD_FAILURE?: number;
  /**
   * Some items are missing a google_product_category.
   */
  OPTIONAL_PRODUCT_CATEGORY_MISSING?: number;
  /**
   * Some items include google_product_category values that are not formatted correctly according to the GPC taxonomy.
   */
  OPTIONAL_PRODUCT_CATEGORY_INVALID?: number;
  /**
   * Some items are missing a condition value, which may limit visibility in recommendations, search results and shopping experiences.
   */
  OPTIONAL_CONDITION_MISSING?: number;
  /**
   * Some items include condition values that are formatted incorrectly, which may limit visibility in recommendations, search results and shopping experiences.
   */
  OPTIONAL_CONDITION_INVALID?: number;
  /**
   * Some items include invalid ios_deep_link values.
   */
  IOS_DEEP_LINK_INVALID?: number;
  /**
   * Some items include invalid android_deep_link.
   */
  ANDROID_DEEP_LINK_INVALID?: number;
  /**
   * Some items include utm_source values that are formatted incorrectly and have been automatically corrected.
   */
  UTM_SOURCE_AUTO_CORRECTED?: number;
  /**
   * Some items include a currency that doesn't match the usual currency for the location where that product is sold or shipped.
   */
  COUNTRY_DOES_NOT_MAP_TO_CURRENCY?: number;
  /**
   * Some items include min_ad_price values that are formatted incorrectly.
   */
  MIN_AD_PRICE_INVALID?: number;
  /**
   * Some items include incorrectly formatted GTINs.
   */
  GTIN_INVALID?: number;
  /**
   * Some items include inconsistent currencies in price fields.
   */
  INCONSISTENT_CURRENCY_VALUES?: number;
  /**
   * Some items include sales price that is much lower than the list price.
   */
  SALES_PRICE_TOO_LOW?: number;
  /**
   * Some items include incorrectly formatted shipping_width.
   */
  SHIPPING_WIDTH_INVALID?: number;
  /**
   * Some items include incorrectly formatted shipping_height.
   */
  SHIPPING_HEIGHT_INVALID?: number;
  /**
   * Some items include a sales price that is higher than the list price. The sales price has been defaulted to the list price.
   */
  SALES_PRICE_TOO_HIGH?: number;
  /**
   * Some items include incorrectly formatted MPNs.
   */
  MPN_INVALID?: number;
};

/**
 * Ingestion completed early because there are no changes to your feed since the last successful update.
 */
export type FETCH_SAME_SIGNATURE = 1;

/**
 * Request object for creating a feed. Please, be aware that "default_country" and "default_locale" are not required in the spec for forward compatibility but for now the API will not accept requests without those fields.
 */
export type CatalogsFeedsCreateRequest = {
  default_currency?: NullableCurrency;
  /**
   * A human-friendly name associated to a given feed.
   */
  name: string;
  format: CatalogsFormat;
  /**
   * The locale used within a feed for product descriptions.
   */
  default_locale?: CatalogsLocale | string;
  credentials?: CatalogsFeedCredentials;
  /**
   * The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.
   */
  location: string;
  preferred_processing_schedule?: CatalogsFeedProcessingSchedule;
  default_country?: Country;
  default_availability?: ProductAvailabilityType;
  status?: CatalogsStatus & unknown;
};

export type CatalogsHotelAttributes = {
  /**
   * The main hotel image
   */
  main_image?: {
    /**
     * <p><= 2000 characters</p>
     * <p>The link to the main hotel image. Image should be at least
     * 75x75 pixels to aany errors. Use the additional_image_link field to add
     * more images of your hotel. The URL of your main_image.link must be accessible
     * by the Pinterest user-agent, and send the accurate image. Please make
     * sure there is no template or placeholder image at the link. Must start
     * with http:// or https://.</p>
     */
    link?: string;
    /**
     * Tag appended to the image that identifies image category or details. There can be multiple tags associated with an image
     */
    tag?: Array<string> | null;
  };
  /**
   * <p><= 2000 characters</p>
   * <p>The links to additional images for your hotel. Up to ten
   * additional images can be used to show a hotel from different angles.
   * Must begin with http:// or https://.</p>
   */
  additional_image_link?: Array<string> | null;
} & CatalogsUpdatableHotelAttributes;

/**
 * Request object for creating a retail feed.
 */
export type CatalogsRetailFeedsCreateRequest = {
  default_currency?: NullableCurrency;
  /**
   * A human-friendly name associated to a given feed.
   */
  name: string;
  format: CatalogsFormat;
  /**
   * The locale used within a feed for product descriptions.
   */
  default_locale: CatalogsLocale | string;
  credentials?: CatalogsFeedCredentials;
  /**
   * The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.
   */
  location: string;
  preferred_processing_schedule?: CatalogsFeedProcessingSchedule;
  catalog_type: 'RETAIL';
  default_country: Country;
  default_availability?: ProductAvailabilityType;
  status?: CatalogsStatus & unknown;
};

export type CatalogsRetailItemsFilter = {
  catalog_type: 'RETAIL';
  item_ids: Array<string>;
  /**
   * Catalog id pertaining to the retail item. If not provided, default to oldest retail catalog
   */
  catalog_id?: string;
};

export type CatalogsRetailItemsPostFilter = {
  catalog_type: 'RETAIL';
  item_ids: Array<string>;
  /**
   * Catalog id pertaining to the retail item. If not provided, default to oldest retail catalog
   */
  catalog_id?: string;
};

/**
 * Request object for creating a feed. Please, be aware that "default_country" and "default_locale" are not required in the spec for forward compatibility but for now the API will not accept requests without those fields.
 */
export type CatalogsHotelFeedsCreateRequest = {
  default_currency?: NullableCurrency;
  /**
   * A human-friendly name associated to a given feed.
   */
  name: string;
  format: CatalogsFormat;
  /**
   * The locale used within a feed for product descriptions.
   */
  default_locale: CatalogsLocale | string;
  credentials?: CatalogsFeedCredentials;
  /**
   * The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.
   */
  location: string;
  preferred_processing_schedule?: CatalogsFeedProcessingSchedule;
  catalog_type: 'HOTEL';
  /**
   * Catalog id pertaining to the feed. If not provided, feed will use a default catalog based on type. At the moment a catalog can not have multiple hotel feeds but this will change in the future.
   */
  catalog_id?: string | null;
  status?: CatalogsStatus & unknown;
};

export type CatalogsHotelItemsFilter = {
  catalog_type: 'HOTEL';
  hotel_ids: Array<string>;
  /**
   * Catalog id pertaining to the hotel item. If not provided, default to oldest hotel catalog
   */
  catalog_id?: string;
};

export type CatalogsHotelItemsPostFilter = {
  catalog_type: 'HOTEL';
  hotel_ids: Array<string>;
  /**
   * Catalog id pertaining to the hotel item. If not provided, default to oldest hotel catalog
   */
  catalog_id?: string;
};

export type CatalogsCreativeAssetsItemsFilter = {
  catalog_type: 'CREATIVE_ASSETS';
  creative_assets_ids: Array<string>;
  /**
   * Catalog id pertaining to the creative assets item. If not provided, default to oldest creative assets catalog
   */
  catalog_id?: string;
};

export type CatalogsCreativeAssetsItemsPostFilter = {
  catalog_type: 'CREATIVE_ASSETS';
  creative_assets_ids: Array<string>;
  /**
   * Catalog id pertaining to the creative assets item. If not provided, default to oldest creative assets catalog
   */
  catalog_id?: string;
};

/**
 * Request object for creating a feed.
 */
export type CatalogsCreativeAssetsFeedsCreateRequest = {
  default_currency?: NullableCurrency;
  /**
   * A human-friendly name associated to a given feed.
   */
  name: string;
  format: CatalogsFormat;
  /**
   * The locale used within a feed for product descriptions.
   */
  default_locale: CatalogsLocale | string;
  default_country: Country;
  credentials?: CatalogsFeedCredentials;
  /**
   * The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.
   */
  location: string;
  preferred_processing_schedule?: CatalogsFeedProcessingSchedule;
  catalog_type: 'CREATIVE_ASSETS';
  /**
   * Catalog id pertaining to the feed. If not provided, feed will use a default catalog based on type. At the moment a catalog can not have multiple creative assets feeds but this will change in the future.
   */
  catalog_id?: string | null;
  status?: CatalogsStatus & unknown;
};

/**
 * Request object for creating a feed.
 */
export type CatalogsVerticalFeedsCreateRequest =
  | CatalogsRetailFeedsCreateRequest
  | CatalogsHotelFeedsCreateRequest
  | CatalogsCreativeAssetsFeedsCreateRequest;

/**
 * Request object for updating a feed.
 */
export type CatalogsCreativeAssetsFeedsUpdateRequest = {
  default_currency?: NullableCurrency;
  /**
   * A human-friendly name associated to a given feed.
   */
  name?: string;
  format?: CatalogsFormat;
  credentials?: CatalogsFeedCredentials;
  /**
   * The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.
   */
  location?: string;
  preferred_processing_schedule?: CatalogsFeedProcessingSchedule;
  status?: CatalogsStatus;
  catalog_type: 'CREATIVE_ASSETS';
};

/**
 * Request object for updating a feed.
 */
export type CatalogsRetailFeedsUpdateRequest = {
  default_currency?: NullableCurrency;
  /**
   * A human-friendly name associated to a given feed.
   */
  name?: string;
  format?: CatalogsFormat;
  credentials?: CatalogsFeedCredentials;
  /**
   * The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.
   */
  location?: string;
  preferred_processing_schedule?: CatalogsFeedProcessingSchedule;
  status?: CatalogsStatus;
  catalog_type: 'RETAIL';
  default_availability?: ProductAvailabilityType;
};

/**
 * Request object for updating a feed.
 */
export type CatalogsHotelFeedsUpdateRequest = {
  default_currency?: NullableCurrency;
  /**
   * A human-friendly name associated to a given feed.
   */
  name?: string;
  format?: CatalogsFormat;
  credentials?: CatalogsFeedCredentials;
  /**
   * The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.
   */
  location?: string;
  preferred_processing_schedule?: CatalogsFeedProcessingSchedule;
  status?: CatalogsStatus;
  catalog_type: 'HOTEL';
};

/**
 * Request object for updating a feed.
 */
export type CatalogsVerticalFeedsUpdateRequest =
  | CatalogsRetailFeedsUpdateRequest
  | CatalogsHotelFeedsUpdateRequest
  | CatalogsCreativeAssetsFeedsUpdateRequest;

/**
 * Request object for updating a feed.
 */
export type CatalogsFeedsUpdateRequest = {
  default_availability?: ProductAvailabilityType;
  default_currency?: NullableCurrency;
  /**
   * A human-friendly name associated to a given feed.
   */
  name?: string;
  format?: CatalogsFormat;
  credentials?: CatalogsFeedCredentials;
  /**
   * The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.
   */
  location?: string;
  preferred_processing_schedule?: CatalogsFeedProcessingSchedule;
  status?: CatalogsStatus;
};

/**
 * The file format of a feed.
 */
export type CatalogsFormat = 'TSV' | 'CSV' | 'XML';

export type CatalogsItemValidationDetails = {
  /**
   * Attribute that has a validation issue.
   */
  attribute_name: NullableCatalogsItemFieldType;
  /**
   * Provided value that caused the validation issue.
   */
  provided_value: string | null;
};

export type CatalogsItemValidationErrors = {
  /**
   * Item has an invalid adult value.
   */
  ADULT_INVALID?: CatalogsItemValidationDetails;
  /**
   * Adword link contains too many characters.
   */
  ADWORDS_FORMAT_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item is missing availability value in its product metadata, this item will not be published.
   */
  AVAILABILITY_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item will not be published because it doesn't meet Pinterest's Merchant Guidelines.
   */
  BLOCKLISTED_IMAGE_SIGNATURE?: CatalogsItemValidationDetails;
  /**
   * Item is missing description in its product metadata, this item will not be published.
   */
  DESCRIPTION_MISSING?: CatalogsItemValidationDetails;
  /**
   * This product is duplicated. The duplicate entry will not be published.
   */
  DUPLICATE_PRODUCTS?: CatalogsItemValidationDetails;
  /**
   * Image link is invalid.
   */
  IMAGE_LINK_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item has image_link URL that contains too many characters, so the item will not be published.
   */
  IMAGE_LINK_LENGTH_TOO_LONG?: CatalogsItemValidationDetails;
  /**
   * Item is missing an image link URL in its product metadata, this item will not be published.
   */
  IMAGE_LINK_MISSING?: CatalogsItemValidationDetails;
  /**
   * Product link value doesn't match the verified domain associated with this account.
   */
  INVALID_DOMAIN?: CatalogsItemValidationDetails;
  /**
   * Item is missing item id in its product metadata, this item will not be published.
   */
  ITEMID_MISSING?: CatalogsItemValidationDetails;
  /**
   * Main image can't be found.
   */
  ITEM_MAIN_IMAGE_DOWNLOAD_FAILURE?: CatalogsItemValidationDetails;
  /**
   * Link is invalid.
   */
  LINK_FORMAT_INVALID?: CatalogsItemValidationDetails;
  /**
   * Product link contains too many characters, this item will not be published.
   */
  LINK_LENGTH_TOO_LONG?: CatalogsItemValidationDetails;
  /**
   * Item has a list price formatting error, this item will not be published.
   */
  LIST_PRICE_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item exceed the maximum number of items per item group, this item will not be published.
   */
  MAX_ITEMS_PER_ITEM_GROUP_EXCEEDED?: CatalogsItemValidationDetails;
  /**
   * Item contains formating errors.
   */
  PARSE_LINE_ERROR?: CatalogsItemValidationDetails;
  /**
   * Item will not be published because it doesn't meet Pinterest's Merchant Guidelines.
   */
  PINJOIN_CONTENT_UNSAFE?: CatalogsItemValidationDetails;
  /**
   * Item price cannot be determined because the price, list price, and sale price are all different.
   */
  PRICE_CANNOT_BE_DETERMINED?: CatalogsItemValidationDetails;
  /**
   * Product is missing a price, this item will not be published.
   */
  PRICE_MISSING?: CatalogsItemValidationDetails;
  /**
   * Item is missing a link URL in its product metadata, this item will not be published.
   */
  PRODUCT_LINK_MISSING?: CatalogsItemValidationDetails;
  /**
   * Item has a price formatting error in its product metadata, this item will not be published.
   */
  PRODUCT_PRICE_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item is missing title in its product metadata, this item will not be published.
   */
  TITLE_MISSING?: CatalogsItemValidationDetails;
};

export type CatalogsItemValidationIssue =
  | 'AD_LINK_FORMAT_WARNING'
  | 'AD_LINK_SAME_AS_LINK'
  | 'ADDITIONAL_IMAGE_LINK_LENGTH_TOO_LONG'
  | 'ADDITIONAL_IMAGE_LINK_WARNING'
  | 'ADULT_INVALID'
  | 'ADWORDS_FORMAT_INVALID'
  | 'ADWORDS_FORMAT_WARNING'
  | 'ADWORDS_SAME_AS_LINK'
  | 'AGE_GROUP_INVALID'
  | 'ANDROID_DEEP_LINK_INVALID'
  | 'AVAILABILITY_DATE_INVALID'
  | 'AVAILABILITY_INVALID'
  | 'BLOCKLISTED_IMAGE_SIGNATURE'
  | 'COUNTRY_DOES_NOT_MAP_TO_CURRENCY'
  | 'CUSTOM_LABEL_LENGTH_TOO_LONG'
  | 'DESCRIPTION_LENGTH_TOO_LONG'
  | 'DESCRIPTION_MISSING'
  | 'DUPLICATE_PRODUCTS'
  | 'EXPIRATION_DATE_INVALID'
  | 'GENDER_INVALID'
  | 'GTIN_INVALID'
  | 'IMAGE_LINK_INVALID'
  | 'IMAGE_LINK_LENGTH_TOO_LONG'
  | 'IMAGE_LINK_MISSING'
  | 'IMAGE_LINK_WARNING'
  | 'INVALID_DOMAIN'
  | 'IOS_DEEP_LINK_INVALID'
  | 'IS_BUNDLE_INVALID'
  | 'ITEM_ADDITIONAL_IMAGE_DOWNLOAD_FAILURE'
  | 'ITEM_MAIN_IMAGE_DOWNLOAD_FAILURE'
  | 'ITEMID_MISSING'
  | 'LINK_FORMAT_INVALID'
  | 'LINK_FORMAT_WARNING'
  | 'LINK_LENGTH_TOO_LONG'
  | 'LIST_PRICE_INVALID'
  | 'MAX_ITEMS_PER_ITEM_GROUP_EXCEEDED'
  | 'MIN_AD_PRICE_INVALID'
  | 'MPN_INVALID'
  | 'MULTIPACK_INVALID'
  | 'OPTIONAL_CONDITION_INVALID'
  | 'OPTIONAL_CONDITION_MISSING'
  | 'OPTIONAL_PRODUCT_CATEGORY_INVALID'
  | 'OPTIONAL_PRODUCT_CATEGORY_MISSING'
  | 'PARSE_LINE_ERROR'
  | 'PINJOIN_CONTENT_UNSAFE'
  | 'PRICE_CANNOT_BE_DETERMINED'
  | 'PRICE_MISSING'
  | 'PRODUCT_CATEGORY_DEPTH_WARNING'
  | 'PRODUCT_LINK_MISSING'
  | 'PRODUCT_PRICE_INVALID'
  | 'PRODUCT_TYPE_LENGTH_TOO_LONG'
  | 'SALE_DATE_INVALID'
  | 'SALES_PRICE_INVALID'
  | 'SALES_PRICE_TOO_HIGH'
  | 'SALES_PRICE_TOO_LOW'
  | 'SHIPPING_INVALID'
  | 'SHIPPING_HEIGHT_INVALID'
  | 'SHIPPING_WEIGHT_INVALID'
  | 'SHIPPING_WIDTH_INVALID'
  | 'SIZE_SYSTEM_INVALID'
  | 'SIZE_TYPE_INVALID'
  | 'TAX_INVALID'
  | 'TITLE_LENGTH_TOO_LONG'
  | 'TITLE_MISSING'
  | 'TOO_MANY_ADDITIONAL_IMAGE_LINKS'
  | 'UTM_SOURCE_AUTO_CORRECTED'
  | 'WEIGHT_UNIT_INVALID';

export type CatalogsItemValidationIssues = {
  /**
   * Item number based on order of appearance in the Catalogs Feed. For example, '0' refers to first item found in a feed that was downloaded from a 'location' specified during feed creation.
   */
  item_number: number;
  /**
   * The merchant-created unique ID that represents the product.
   */
  item_id: string | null;
  errors: CatalogsItemValidationErrors;
  warnings: CatalogsItemValidationWarnings;
};

export type CatalogsItemValidationWarnings = {
  /**
   * Item has an ad link that is formatted incorrectly.
   */
  AD_LINK_FORMAT_WARNING?: CatalogsItemValidationDetails;
  /**
   * Item has an ad link URL that is duplicate of the link URL.
   */
  AD_LINK_SAME_AS_LINK?: CatalogsItemValidationDetails;
  /**
   * Item has an additional_image_link URL that contains too many characters, so the item will not be published.
   */
  ADDITIONAL_IMAGE_LINK_LENGTH_TOO_LONG?: CatalogsItemValidationDetails;
  /**
   * Item has additional_image_link URLs that are formatted incorrectly and will not be published with your items.
   */
  ADDITIONAL_IMAGE_LINK_WARNING?: CatalogsItemValidationDetails;
  /**
   * Item has an adwords_redirect link that is formatted incorrectly.
   */
  ADWORDS_FORMAT_WARNING?: CatalogsItemValidationDetails;
  /**
   * Item has an adwords_redirect URL that is duplicate of the link URL.
   */
  ADWORDS_SAME_AS_LINK?: CatalogsItemValidationDetails;
  /**
   * Item has an age group value that is formatted incorrectly, which may limit visibility in recommendations, search results and shopping experiences.
   */
  AGE_GROUP_INVALID?: CatalogsItemValidationDetails;
  /**
   * Some items have size system values which are not one of the supported size systems.
   */
  SIZE_SYSTEM_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item includes an invalid android_deep_link.
   */
  ANDROID_DEEP_LINK_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item has an availability_date value that is formatted incorrectly, this item will be published without an availability date.
   */
  AVAILABILITY_DATE_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item includes a currency that doesn't match the usual currency for the location where the product is sold or shipped.
   */
  COUNTRY_DOES_NOT_MAP_TO_CURRENCY?: CatalogsItemValidationDetails;
  /**
   * Item has a custom_label value that is too long, this item will be published without that custom label.
   */
  CUSTOM_LABEL_LENGTH_TOO_LONG?: CatalogsItemValidationDetails;
  /**
   * The description for this item was truncated because it contains too many characters.
   */
  DESCRIPTION_LENGTH_TOO_LONG?: CatalogsItemValidationDetails;
  /**
   * Item has an expiration_date value that is formatted incorrectly, this item will be published without an expiration date.
   */
  EXPIRATION_DATE_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item has a gender value that is formatted incorrectly, which may limit visibility in recommendations, search results and shopping experiences.
   */
  GENDER_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item has a GTIN value that is formatted incorrectly.
   */
  GTIN_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item has an image_link URL that is formatted incorrectly and will not be published.
   */
  IMAGE_LINK_WARNING?: CatalogsItemValidationDetails;
  /**
   * Item includes an invalid ios_deep_link value.
   */
  IOS_DEEP_LINK_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item has an is_bundle value that is formatted incorrectly, this item will be published without being bundled with other products.
   */
  IS_BUNDLE_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item includes additional_image_links that can't be found.
   */
  ITEM_ADDITIONAL_IMAGE_DOWNLOAD_FAILURE?: CatalogsItemValidationDetails;
  /**
   * Item has an invalid product link which contains invalid UTM tracking paramaters.
   */
  LINK_FORMAT_WARNING?: CatalogsItemValidationDetails;
  /**
   * Item includes a min_ad_price value that is formatted incorrectly.
   */
  MIN_AD_PRICE_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item has a MPN value that is formatted incorrectly.
   */
  MPN_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item has an invalid multipack value.
   */
  MULTIPACK_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item includes a condition value that is formatted incorrectly, which may limit visibility in recommendations, search results and shopping experiences.
   */
  OPTIONAL_CONDITION_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item is missing condition value, which may limit visibility in recommendations, search results and shopping experiences.
   */
  OPTIONAL_CONDITION_MISSING?: CatalogsItemValidationDetails;
  /**
   * Item includes a google_product_category value that is not formatted correctly according to the GPC taxonomy.
   */
  OPTIONAL_PRODUCT_CATEGORY_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item is missing google_product_category.
   */
  OPTIONAL_PRODUCT_CATEGORY_MISSING?: CatalogsItemValidationDetails;
  /**
   * Item only has 1 or 2 levels of google_product_category value, which may limit visibility in recommendations, search results and shopping experiences.
   */
  PRODUCT_CATEGORY_DEPTH_WARNING?: CatalogsItemValidationDetails;
  /**
   * Item has a product_type value that is too long, this item will be published without that product type.
   */
  PRODUCT_TYPE_LENGTH_TOO_LONG?: CatalogsItemValidationDetails;
  /**
   * Item has an incorrectly formatted sales price.
   */
  SALES_PRICE_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item has a sale price value that is discounted very low compared to the price.
   */
  SALES_PRICE_TOO_LOW?: CatalogsItemValidationDetails;
  /**
   * Item has a sale price value that is higher than the original price of the item.
   */
  SALES_PRICE_TOO_HIGH?: CatalogsItemValidationDetails;
  /**
   * Item has a sale_price_effective_date value that is formatted incorrectly, this item will be published without a sale date.
   */
  SALE_DATE_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item has a shipping value that is formatted incorrectly.
   */
  SHIPPING_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item has an incorrectly formatted shipping_height value. The value must first contain a numeric value then a valid dimension unit type.
   */
  SHIPPING_HEIGHT_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item has an invalid shipping_weight value.
   */
  SHIPPING_WEIGHT_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item has an incorrectly formatted shipping_width value. The value must first contain a numeric value then a valid dimension unit type.
   */
  SHIPPING_WIDTH_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item has a size type value that is formatted incorrectly, which may limit visibility in recommendations, search results and shopping experiences.
   */
  SIZE_TYPE_INVALID?: CatalogsItemValidationDetails;
  /**
   * Item has a tax value that is formatted incorrectly.
   */
  TAX_INVALID?: CatalogsItemValidationDetails;
  /**
   * The title for the item was truncated because it contains too many characters.
   */
  TITLE_LENGTH_TOO_LONG?: CatalogsItemValidationDetails;
  /**
   * Item has a additional_image_link value that exceed the limit for additional images, this item will be published without some of your images.
   */
  TOO_MANY_ADDITIONAL_IMAGE_LINKS?: CatalogsItemValidationDetails;
  /**
   * Item includes an utm_source value that is formatted incorrectly and has been automatically corrected.
   */
  UTM_SOURCE_AUTO_CORRECTED?: CatalogsItemValidationDetails;
  /**
   * Item has a weight_unit value that is formatted incorrectly, this item will be published without a weight unit.
   */
  WEIGHT_UNIT_INVALID?: CatalogsItemValidationDetails;
};

/**
 * Response object of catalogs items
 */
export type CatalogsItems = {
  /**
   * Array with catalogs items
   */
  items?: Array<ItemResponse>;
};

/**
 * Object describing the catalogs items batch
 */
export type CatalogsItemsBatch = (
  | CatalogsRetailItemsBatch
  | CatalogsHotelItemsBatch
  | CatalogsCreativeAssetsItemsBatch
) & {
  catalog_type: CatalogsType;
};

export type CatalogsItemsFilters = (
  | CatalogsRetailItemsFilter
  | CatalogsHotelItemsFilter
  | CatalogsCreativeAssetsItemsFilter
) & {
  catalog_type: CatalogsType;
};

export type CatalogsItemsPostFilters = (
  | CatalogsRetailItemsPostFilter
  | CatalogsHotelItemsPostFilter
  | CatalogsCreativeAssetsItemsPostFilter
) & {
  catalog_type: CatalogsType;
};

/**
 * Object describing the catalogs creative assets items batch
 */
export type CatalogsCreativeAssetsItemsBatch = {
  /**
   * Id of the catalogs items batch
   */
  batch_id?: string;
  /**
   * Date and time (UTC) of the batch creation: YYYY-MM-DD'T'hh:mm:ss
   */
  readonly created_time?: string;
  /**
   * Date and time (UTC) of the batch completion: YYYY-MM-DD'T'hh:mm:ss
   */
  readonly completed_time?: string | null;
  status?: BatchOperationStatus;
  catalog_type: 'CREATIVE_ASSETS';
  /**
   * Array with the catalogs items processing records part of the catalogs items batch
   */
  items?: Array<CreativeAssetsProcessingRecord>;
};

/**
 * Object describing the catalogs hotel items batch
 */
export type CatalogsHotelItemsBatch = {
  /**
   * Id of the catalogs items batch
   */
  batch_id?: string;
  /**
   * Date and time (UTC) of the batch creation: YYYY-MM-DD'T'hh:mm:ss
   */
  readonly created_time?: string;
  /**
   * Date and time (UTC) of the batch completion: YYYY-MM-DD'T'hh:mm:ss
   */
  readonly completed_time?: string | null;
  status?: BatchOperationStatus;
  catalog_type: 'HOTEL';
  /**
   * Array with the catalogs items processing records part of the catalogs items batch
   */
  items?: Array<HotelProcessingRecord>;
};

/**
 * Object describing the catalogs retail items batch
 */
export type CatalogsRetailItemsBatch = {
  /**
   * Id of the catalogs items batch
   */
  batch_id?: string;
  /**
   * Date and time (UTC) of the batch creation: YYYY-MM-DD'T'hh:mm:ss
   */
  readonly created_time?: string;
  /**
   * Date and time (UTC) of the batch completion: YYYY-MM-DD'T'hh:mm:ss
   */
  readonly completed_time?: string | null;
  status?: BatchOperationStatus;
  catalog_type: 'RETAIL';
  /**
   * Array with the catalogs items processing records part of the catalogs items batch
   */
  items?: Array<ItemProcessingRecord>;
};

/**
 * Request object of catalogs items
 */
export type CatalogsItemsRequest = {
  country: Country;
  /**
   * We recommend using the CatalogsLocale values.
   */
  language: CatalogsLocale | Language;
  filters: CatalogsItemsPostFilters;
};

/**
 * Request object of catalogs items batch
 */
export type CatalogsItemsBatchRequest =
  | CatalogsItemsUpdateBatchRequest
  | CatalogsItemsUpsertBatchRequest
  | CatalogsItemsCreateBatchRequest
  | CatalogsItemsDeleteDiscontinuedBatchRequest
  | CatalogsItemsDeleteBatchRequest;

/**
 * Request object to create catalogs items
 */
export type CatalogsItemsCreateBatchRequest = {
  country: Country;
  /**
   * We recommend using the CatalogsLocale values.
   */
  language: CatalogsLocale | Language;
  operation: 'CREATE';
  /**
   * Array with catalogs items
   */
  items: Array<ItemCreateBatchRecord>;
};

/**
 * Request object to delete catalogs items
 */
export type CatalogsItemsDeleteBatchRequest = {
  country: Country;
  /**
   * We recommend using the CatalogsLocale values.
   */
  language: CatalogsLocale | Language;
  operation: 'DELETE';
  /**
   * Array with catalogs items
   */
  items: Array<ItemDeleteBatchRecord>;
};

/**
 * Request object to discontinue catalogs items
 */
export type CatalogsItemsDeleteDiscontinuedBatchRequest = {
  country: Country;
  /**
   * We recommend using the CatalogsLocale values.
   */
  language: CatalogsLocale | Language;
  operation: 'DELETE_DISCONTINUED';
  /**
   * Array with catalogs items
   */
  items: Array<ItemDeleteDiscontinuedBatchRecord>;
};

/**
 * Request object to update catalogs items
 */
export type CatalogsItemsUpdateBatchRequest = {
  country: Country;
  /**
   * We recommend using the CatalogsLocale values.
   */
  language: CatalogsLocale | Language;
  operation: 'UPDATE';
  /**
   * Array with catalogs items
   */
  items: Array<ItemUpdateBatchRecord>;
};

/**
 * Request object to upsert catalogs items
 */
export type CatalogsItemsUpsertBatchRequest = {
  country: Country;
  /**
   * We recommend using the CatalogsLocale values.
   */
  language: CatalogsLocale | Language;
  operation: 'UPSERT';
  /**
   * Array with catalogs items
   */
  items: Array<ItemUpsertBatchRecord>;
};

/**
 * Request object to list products for a given product group filter.
 */
export type CatalogsListProductsByFilterRequest =
  | CatalogsListProductsByFeedBasedFilter
  | CatalogsVerticalsListProductsByCatalogBasedFilterRequest;

/**
 * Request object to list products for a given feed_id and product group filter.
 */
export type CatalogsListProductsByFeedBasedFilter = {
  /**
   * Catalog Feed id pertaining to the catalog product group filter.
   */
  feed_id: string;
  filters: CatalogsProductGroupFilters;
};

/**
 * Request object to list products for a given catalog_id and product group filter.
 */
export type CatalogsVerticalsListProductsByCatalogBasedFilterRequest =
  | CatalogsRetailListProductsByCatalogBasedFilterRequest
  | CatalogsHotelListProductsByCatalogBasedFilterRequest
  | CatalogsCreativeAssetsListProductsByCatalogBasedFilterRequest;

/**
 * Request object to list products for a given retail catalog_id and product group filter.
 */
export type CatalogsRetailListProductsByCatalogBasedFilterRequest = {
  /**
   * Retail catalog based product group is available only for selected partners at the moment. If you are not eligible, please use feed based one.
   */
  catalog_type: 'RETAIL';
  /**
   * Catalog id pertaining to the retail product group.
   */
  catalog_id: string;
  filters: CatalogsProductGroupFilters;
  country: Country;
  locale: CatalogsLocale;
};

/**
 * Request object to list products for a given hotel catalog_id and product group filter.
 */
export type CatalogsHotelListProductsByCatalogBasedFilterRequest = {
  catalog_type: 'HOTEL';
  /**
   * Catalog id pertaining to the hotel product group.
   */
  catalog_id: string;
  filters: CatalogsHotelProductGroupFilters;
};

/**
 * Request object to list products for a given creative assets catalog_id and product group filter.
 */
export type CatalogsCreativeAssetsListProductsByCatalogBasedFilterRequest = {
  catalog_type: 'CREATIVE_ASSETS';
  /**
   * Catalog id pertaining to the creative assets product group.
   */
  catalog_id: string;
  filters: CatalogsCreativeAssetsProductGroupFilters;
};

export type CatalogsLocale =
  | 'af-ZA'
  | 'ar-SA'
  | 'bg-BG'
  | 'bn-IN'
  | 'cs-CZ'
  | 'da-DK'
  | 'de'
  | 'el-GR'
  | 'en-AU'
  | 'en-CA'
  | 'en-GB'
  | 'en-IN'
  | 'en-US'
  | 'es-419'
  | 'es-AR'
  | 'es-ES'
  | 'es-MX'
  | 'fi-FI'
  | 'fr'
  | 'fr-CA'
  | 'he-IL'
  | 'hi-IN'
  | 'hr-HR'
  | 'hu-HU'
  | 'id-ID'
  | 'it'
  | 'ja'
  | 'ko-KR'
  | 'ms-MY'
  | 'nb-NO'
  | 'nl'
  | 'pl-PL'
  | 'pt-BR'
  | 'pt-PT'
  | 'ro-RO'
  | 'ru-RU'
  | 'sk-SK'
  | 'sv-SE'
  | 'te-IN'
  | 'th-TH'
  | 'tl-PH'
  | 'tr'
  | 'uk-UA'
  | 'vi-VN'
  | 'zh-CN'
  | 'zh-TW';

/**
 * Catalogs product for all verticals
 */
export type CatalogsProduct = (CatalogsRetailProduct | CatalogsHotelProduct | CatalogsCreativeAssetsProduct) & {
  catalog_type: CatalogsType;
};

export type CatalogsVerticalProductGroup =
  | CatalogsRetailProductGroup
  | CatalogsHotelProductGroup
  | CatalogsCreativeAssetsProductGroup;

export type CatalogsCreativeAssetsProductGroup = {
  catalog_type: 'CREATIVE_ASSETS';
  /**
   * ID of the creative assets product group.
   */
  id: string;
  /**
   * Name of creative assets product group
   */
  name?: string;
  description?: string | null;
  filters: CatalogsCreativeAssetsProductGroupFilters;
  /**
   * Unix timestamp in seconds of when catalog product group was created.
   */
  created_at?: number;
  /**
   * Unix timestamp in seconds of last time catalog product group was updated.
   */
  updated_at?: number;
  /**
   * Catalog id pertaining to the creative assets product group.
   */
  catalog_id: string;
};

/**
 * Object holding a group of filters for a creative assets product group
 */
export type CatalogsCreativeAssetsProductGroupFilters =
  | CatalogsCreativeAssetsProductGroupFiltersAnyOf
  | CatalogsCreativeAssetsProductGroupFiltersAllOf;

export type CatalogsCreativeAssetsProductGroupFiltersAllOf = {
  all_of: Array<CatalogsCreativeAssetsProductGroupFilterKeys>;
};

export type CatalogsCreativeAssetsProductGroupFiltersAnyOf = {
  any_of: Array<CatalogsCreativeAssetsProductGroupFilterKeys>;
};

export type CatalogsCreativeAssetsProductGroupFilterKeys =
  | CreativeAssetsIdFilter
  | CustomLabel0Filter
  | CustomLabel1Filter
  | CustomLabel2Filter
  | CustomLabel3Filter
  | CustomLabel4Filter
  | GoogleProductCategory6Filter
  | GoogleProductCategory5Filter
  | GoogleProductCategory4Filter
  | GoogleProductCategory3Filter
  | GoogleProductCategory2Filter
  | GoogleProductCategory1Filter
  | GoogleProductCategory0Filter
  | MediaTypeFilter;

/**
 * Request object for creating a creative assets product group.
 */
export type CatalogsCreativeAssetsProductGroupCreateRequest = {
  catalog_type: 'CREATIVE_ASSETS';
  name: string;
  description?: string | null;
  filters: CatalogsCreativeAssetsProductGroupFilters;
  /**
   * Catalog id pertaining to the creative assets product group.
   */
  catalog_id: string;
};

/**
 * Request object for updating a creative assets product group.
 */
export type CatalogsCreativeAssetsProductGroupUpdateRequest = {
  catalog_type?: 'CREATIVE_ASSETS';
  name?: string;
  description?: string | null;
  filters?: CatalogsCreativeAssetsProductGroupFilters;
};

export type CatalogsHotelProductGroup = {
  catalog_type: 'HOTEL';
  /**
   * ID of the hotel product group.
   */
  id: string;
  /**
   * Name of hotel product group
   */
  name?: string;
  description?: string | null;
  filters: CatalogsHotelProductGroupFilters;
  /**
   * Unix timestamp in seconds of when catalog product group was created.
   */
  created_at?: number;
  /**
   * Unix timestamp in seconds of last time catalog product group was updated.
   */
  updated_at?: number;
  /**
   * Catalog id pertaining to the hotel product group.
   */
  catalog_id: string;
};

export type CatalogsHotelProductGroupFilterKeys =
  | PriceFilter
  | HotelIdFilter
  | BrandFilter
  | CustomLabel0Filter
  | CustomLabel1Filter
  | CustomLabel2Filter
  | CustomLabel3Filter
  | CustomLabel4Filter
  | CountryFilter;

/**
 * Object holding a group of filters for a hotel product group
 */
export type CatalogsHotelProductGroupFilters =
  | CatalogsHotelProductGroupFiltersAnyOf
  | CatalogsHotelProductGroupFiltersAllOf;

export type CatalogsHotelProductGroupFiltersAllOf = {
  all_of: Array<CatalogsHotelProductGroupFilterKeys>;
};

export type CatalogsHotelProductGroupFiltersAnyOf = {
  any_of: Array<CatalogsHotelProductGroupFilterKeys>;
};

export type CatalogsRetailProductGroup = {
  catalog_type: 'RETAIL';
  /**
   * ID of the catalog product group.
   */
  id: string;
  /**
   * Name of catalog product group
   */
  name?: string;
  description?: string | null;
  filters: CatalogsProductGroupFilters;
  /**
   * boolean indicator of whether the product group is being featured or not
   * @deprecated
   */
  is_featured?: boolean;
  type?: CatalogsProductGroupType;
  status?: CatalogsProductGroupStatus;
  /**
   * Unix timestamp in seconds of when catalog product group was created.
   */
  created_at?: number;
  /**
   * Unix timestamp in seconds of last time catalog product group was updated.
   */
  updated_at?: number;
  /**
   * Catalog id pertaining to the retail product group.
   */
  catalog_id: string;
  /**
   * id of the catalogs feed belonging to this catalog product group
   */
  feed_id: string | null;
  country?: string | null;
  locale?: string | null;
};

/**
 * Request object for creating a hotel product group.
 */
export type CatalogsHotelProductGroupCreateRequest = {
  catalog_type: 'HOTEL';
  name: string;
  description?: string | null;
  filters: CatalogsHotelProductGroupFilters;
  /**
   * Catalog id pertaining to the hotel product group.
   */
  catalog_id: string;
};

/**
 * Request object for creating a product group.
 */
export type CatalogsRetailProductGroupCreateRequest = {
  /**
   * Retail catalog based product group is available only for selected partners at the moment. If you are not eligible, please use feed based one.
   */
  catalog_type: 'RETAIL';
  name: string;
  description?: string | null;
  filters: CatalogsProductGroupFiltersRequest;
  /**
   * Catalog id pertaining to the retail product group.
   */
  catalog_id: string;
  country: Country;
  locale: CatalogsLocale;
};

/**
 * Request object for updating a hotel product group.
 */
export type CatalogsHotelProductGroupUpdateRequest = {
  catalog_type?: 'HOTEL';
  name?: string;
  description?: string | null;
  filters?: CatalogsHotelProductGroupFilters;
};

/**
 * Request object for updating a retail product group.
 */
export type CatalogsRetailProductGroupUpdateRequest = {
  /**
   * Retail catalog based product group is available only for selected partners at the moment. If you are not eligible, please use feed based one.
   */
  catalog_type?: 'RETAIL';
  name?: string;
  description?: string | null;
  filters?: CatalogsProductGroupFiltersRequest;
  country?: Country;
  locale?: CatalogsLocale;
};

/**
 * Request object for creating a product group.
 */
export type CatalogsProductGroupCreateRequest = {
  name: string;
  description?: string | null;
  /**
   * boolean indicator of whether the product group is being featured or not
   * @deprecated
   */
  is_featured?: boolean;
  filters: CatalogsProductGroupFiltersRequest;
  /**
   * Catalog Feed id pertaining to the catalog product group.
   */
  feed_id: string;
};

/**
 * A currency filter. This filter cannot be negated
 */
export type CatalogsProductGroupCurrencyCriteria = {
  values: NonNullableCatalogsCurrency;
  negated?: boolean;
};

export type CatalogsProductGroupFilterKeys =
  | MinPriceFilter
  | MaxPriceFilter
  | CurrencyFilter
  | ItemIdFilter
  | AvailabilityFilter
  | BrandFilter
  | ConditionFilter
  | CustomLabel0Filter
  | CustomLabel1Filter
  | CustomLabel2Filter
  | CustomLabel3Filter
  | CustomLabel4Filter
  | ItemGroupIdFilter
  | GenderFilter
  | MediaTypeFilter
  | ProductType4Filter
  | ProductType3Filter
  | ProductType2Filter
  | ProductType1Filter
  | ProductType0Filter
  | GoogleProductCategory6Filter
  | GoogleProductCategory5Filter
  | GoogleProductCategory4Filter
  | GoogleProductCategory3Filter
  | GoogleProductCategory2Filter
  | GoogleProductCategory1Filter
  | GoogleProductCategory0Filter
  | ProductGroupReferenceFilter;

/**
 * Object holding a group of filters for a catalog product group
 */
export type CatalogsProductGroupFilters = CatalogsProductGroupFiltersAnyOf | CatalogsProductGroupFiltersAllOf;

export type CatalogsProductGroupFiltersAllOf = {
  all_of: Array<CatalogsProductGroupFilterKeys>;
};

/**
 * Object holding a group of filters for request on catalog product group. This is a distinct schema It is not possible to create or update a Product Group with empty filters. But some automatically generated Product Groups might have empty filters.
 */
export type CatalogsProductGroupFiltersRequest =
  | {
      any_of: Array<CatalogsProductGroupFilterKeys>;
    }
  | {
      all_of: Array<CatalogsProductGroupFilterKeys>;
    };

export type CatalogsProductGroupFiltersAnyOf = {
  any_of: Array<CatalogsProductGroupFilterKeys>;
};

export type CatalogsProductGroupMultipleCountriesCriteria = {
  values: Array<Country>;
  negated?: boolean;
};

export type CatalogsProductGroupMultipleGenderCriteria = {
  values: Array<Gender>;
  negated?: boolean;
};

export type CatalogsProductGroupMultipleMediaTypesCriteria = {
  values: Array<MediaType>;
  negated?: boolean;
};

export type CatalogsProductGroupMultipleStringCriteria = {
  values: Array<string>;
  negated?: boolean;
};

export type CatalogsProductGroupMultipleStringListCriteria = {
  values: Array<Array<string>>;
  negated?: boolean;
};

export type CatalogsProductGroupPricingCriteria = {
  inclusion?: boolean;
  values: number;
  negated?: boolean;
};

/**
 * Product counts for a CatalogsProductGroup
 */
export type CatalogsProductGroupProductCountsVertical = (
  | CatalogsRetailProductGroupProductCounts
  | CatalogsHotelProductGroupProductCounts
  | CatalogsCreativeAssetsProductGroupProductCounts
) & {
  catalog_type: CatalogsType;
};

/**
 * Product counts for a Hotel CatalogsProductGroup
 */
export type CatalogsHotelProductGroupProductCounts = {
  catalog_type: 'HOTEL';
  total: number;
};

/**
 * Product counts for a Creative Assets CatalogsProductGroup
 */
export type CatalogsCreativeAssetsProductGroupProductCounts = {
  catalog_type: 'CREATIVE_ASSETS';
  total: number;
  videos: number;
};

/**
 * Product counts for a Retail CatalogsProductGroup
 */
export type CatalogsRetailProductGroupProductCounts = {
  catalog_type: 'RETAIL';
  in_stock: number;
  out_of_stock: number;
  preorder: number;
  total: number;
  videos?: number;
};

export type CatalogsProductGroupStatus = 'ACTIVE' | 'INACTIVE';

/**
 * <p>Catalog product group type</p>
 * <p>MERCHANT_CREATED: Product groups created by merchants.
 * <br>ALL_PRODUCTS: Consists of every product in your latest successful feed upload.
 * <br>BEST_DEALS: Consists of products with the deepest drop in price.
 * <br>PINNER_FAVORITES: Consists of products that are resonating most with people on Pinterest, based on engagement.
 * <br>TOP_SELLERS: Consists of products with the highest conversion rate, if you have the conversion tag installed.
 * <br>BACK_IN_STOCK: Consists of products that were previously out of stock and are now in stock.
 * <br>NEW_ARRIVALS: Consists of products that are new to your Catalog.
 * <br>SHOPIFY_COLLECTION: Product groups created based on Shopify Product Collections.
 * <br>I2PC: Product groups created based on predicted product category.</p>
 */
export type CatalogsProductGroupType =
  | 'MERCHANT_CREATED'
  | 'ALL_PRODUCTS'
  | 'BEST_DEALS'
  | 'PINNER_FAVORITES'
  | 'TOP_SELLERS'
  | 'BACK_IN_STOCK'
  | 'NEW_ARRIVALS'
  | 'SHOPIFY_COLLECTIONS'
  | 'I2PC';

/**
 * Request object for updating a product group.
 */
export type CatalogsProductGroupUpdateRequest = {
  name?: string;
  description?: string | null;
  /**
   * boolean indicator of whether the product group is being featured or not
   * @deprecated
   */
  is_featured?: boolean;
  filters?: CatalogsProductGroupFiltersRequest;
};

export type CatalogsRetailProduct = {
  catalog_type: 'RETAIL';
  metadata: CatalogsRetailProductMetadata;
  pin: Pin;
};

/**
 * Retail product metadata entity
 */
export type CatalogsRetailProductMetadata = {
  /**
   * The user-created unique ID that represents the product.
   */
  item_id: string;
  /**
   * The parent ID of the product.
   */
  item_group_id: string | null;
  availability: NonNullableProductAvailabilityType;
  /**
   * The price of the product.
   */
  price: number;
  /**
   * The discounted price of the product.
   */
  sale_price: number | null;
  currency: NonNullableCatalogsCurrency;
};

/**
 * Status for catalogs entities. Present in catalogs_feed values. When a feed is deleted, the response will inform DELETED as status.
 */
export type CatalogsStatus = 'ACTIVE' | 'INACTIVE';

/**
 * Type of the catalog entity.
 */
export type CatalogsType = 'RETAIL' | 'HOTEL' | 'CREATIVE_ASSETS';

/**
 * A request object that can have multiple operations on a single batch
 */
export type CatalogsVerticalBatchRequest =
  | CatalogsRetailBatchRequest
  | CatalogsHotelBatchRequest
  | CatalogsCreativeAssetsBatchRequest;

/**
 * If specified, you must provide all properties
 */
export type CatalogsHotelGuestRatings = {
  /**
   * Your hotel's rating.
   */
  score?: number;
  /**
   * Total number of people who have rated this hotel.
   */
  number_of_reviewers?: number;
  /**
   * Max value for the hotel rating score.
   */
  max_score?: number;
  /**
   * System you use for guest reviews.
   */
  rating_system?: string;
};

/**
 * Object describing a hotel item error
 */
export type CatalogsHotelItemErrorResponse = {
  catalog_type: CatalogsType;
  /**
   * The catalog hotel id in the merchant namespace
   */
  hotel_id?: string;
  /**
   * Array with the errors for the item id requested
   */
  errors?: Array<ItemValidationEvent>;
};

/**
 * Object describing a hotel record
 */
export type CatalogsHotelItemResponse = {
  catalog_type: CatalogsType;
  /**
   * The catalog hotel id in the merchant namespace
   */
  hotel_id?: string;
  /**
   * The pins mapped to the item
   */
  pins?: Array<Pin> | null;
  attributes?: CatalogsHotelAttributes;
};

/**
 * Object describing a creative assets item error
 */
export type CatalogsCreativeAssetsItemErrorResponse = {
  catalog_type: CatalogsType;
  /**
   * The catalog creative assets id in the merchant namespace
   */
  creative_assets_id?: string;
  /**
   * Array with the errors for the item id requested
   */
  errors?: Array<ItemValidationEvent>;
};

/**
 * Object describing a hotel record
 */
export type CatalogsCreativeAssetsItemResponse = {
  catalog_type: CatalogsType;
  /**
   * The catalog creative assets id in the merchant namespace
   */
  creative_assets_id?: string;
  /**
   * The pins mapped to the item
   */
  pins?: Array<Pin> | null;
  attributes?: CatalogsCreativeAssetsAttributes;
};

/**
 * Object describing an item processing record
 */
export type CreativeAssetsProcessingRecord = {
  /**
   * The catalog creative assets id in the merchant namespace
   */
  creative_assets_id?: string;
  /**
   * Array with the validation errors for the item processing record.
   * A non empty errors list causes the item processing to fail.
   */
  errors?: Array<ItemValidationEvent>;
  /**
   * Array with the validation warnings for the item processing record
   */
  warnings?: Array<ItemValidationEvent>;
  status?: ItemProcessingStatus;
};

/**
 * A request object that can have multiple operations on a single retail batch
 */
export type CatalogsRetailBatchRequest = {
  catalog_type: 'RETAIL';
  country: Country;
  /**
   * We recommend using the CatalogsLocale values.
   */
  language: CatalogsLocale | Language;
  /**
   * Array with catalogs item operations
   */
  items: Array<
    CatalogsCreateRetailItem | CatalogsUpdateRetailItem | CatalogsUpsertRetailItem | CatalogsDeleteRetailItem
  >;
};

/**
 * Object describing a retail item error
 */
export type CatalogsRetailItemErrorResponse = {
  catalog_type: CatalogsType;
  /**
   * The catalog item id in the merchant namespace
   */
  item_id?: string;
  /**
   * Array with the errors for the item id requested
   */
  errors?: Array<ItemValidationEvent>;
};

/**
 * Object describing a retail item record
 */
export type CatalogsRetailItemResponse = {
  catalog_type: CatalogsType;
  /**
   * The catalog retail item id in the merchant namespace
   */
  item_id?: string;
  /**
   * The pins mapped to the item
   */
  pins?: Array<Pin> | null;
  attributes?: ItemAttributes;
};

/**
 * An item to be created
 */
export type CatalogsCreateRetailItem = {
  /**
   * The catalog item id in the merchant namespace
   */
  item_id: string;
  operation: 'CREATE';
  attributes: ItemAttributesRequest;
};

export type operation = 'CREATE';

/**
 * An item to be updated
 */
export type CatalogsUpdateRetailItem = {
  /**
   * The catalog item id in the merchant namespace
   */
  item_id: string;
  operation: 'UPDATE';
  attributes: UpdatableItemAttributes;
  /**
   * The list of product attributes to be updated. Attributes specified in the update mask without a value specified in the body will be deleted from the product item.
   */
  update_mask?: Array<UpdateMaskFieldType> | null;
};

export type operation2 = 'UPDATE';

/**
 * An item to be upserted
 */
export type CatalogsUpsertRetailItem = {
  /**
   * The catalog item id in the merchant namespace
   */
  item_id: string;
  operation: 'UPSERT';
  attributes: ItemAttributesRequest;
};

export type operation3 = 'UPSERT';

/**
 * An item to be deleted
 */
export type CatalogsDeleteRetailItem = {
  /**
   * The catalog item id in the merchant namespace
   */
  item_id: string;
  operation: 'DELETE';
};

export type operation4 = 'DELETE';

/**
 * Request object to update catalogs hotel items
 */
export type CatalogsHotelBatchRequest = {
  catalog_type: 'HOTEL';
  country: Country;
  /**
   * We recommend using the CatalogsLocale values.
   */
  language: CatalogsLocale | Language;
  /**
   * Array with catalogs item operations
   */
  items: Array<CatalogsHotelBatchItem>;
  /**
   * Catalog id pertaining to the hotel item. If not provided, default to oldest hotel catalog
   */
  catalog_id?: string;
};

/**
 * A hotel item to be deleted
 */
export type CatalogsDeleteHotelItem = {
  /**
   * The catalog hotel id in the merchant namespace
   */
  hotel_id: string;
  operation: 'DELETE';
};

/**
 * A hotel item to be created.
 */
export type CatalogsCreateHotelItem = {
  /**
   * The catalog hotel id in the merchant namespace
   */
  hotel_id: string;
  operation: 'CREATE';
  attributes: CatalogsHotelAttributes;
};

/**
 * Object describing an hotel item batch record
 */
export type CatalogsUpdateHotelItem = {
  /**
   * The catalog hotel item id in the merchant namespace
   */
  hotel_id: string;
  operation: 'UPDATE';
  attributes: CatalogsUpdatableHotelAttributes;
};

/**
 * A hotel item to be upserted.
 */
export type CatalogsUpsertHotelItem = {
  /**
   * The catalog hotel id in the merchant namespace
   */
  hotel_id: string;
  operation: 'UPSERT';
  attributes: CatalogsHotelAttributes;
};

export type CatalogsHotelAddress = {
  /**
   * Primary street address of hotel.
   */
  addr1?: string;
  /**
   * City where the hotel is located.
   */
  city?: string;
  /**
   * State, county, province, where the hotel is located.
   */
  region?: string;
  /**
   * Country where the hotel is located.
   */
  country?: string;
  /**
   * Required for countries with a postal code system. Postal or zip code of the hotel.
   */
  postal_code?: string;
};

export type CatalogsHotelProduct = {
  catalog_type: 'HOTEL';
  metadata: CatalogsHotelProductMetadata;
  pin: Pin;
};

/**
 * Hotel product metadata entity
 */
export type CatalogsHotelProductMetadata = {
  /**
   * The user-created unique ID that represents the hotel item.
   */
  hotel_id: string;
};

export type CatalogsUpdatableHotelAttributes = {
  /**
   * The hotel's name.
   */
  name?: string | null;
  /**
   * Link to the product page
   */
  link?: string | null;
  /**
   * Brief description of the hotel.
   */
  description?: string | null;
  /**
   * The brand to which this hotel belongs to.
   */
  brand?: string | null;
  /**
   * Latitude of the hotel.
   */
  latitude?: number;
  /**
   * Longitude of the hotel.
   */
  longitude?: number | null;
  /**
   * A list of neighborhoods where the hotel is located
   */
  neighborhood?: Array<string> | null;
  /**
   * Hotel address
   */
  address?: CatalogsHotelAddress;
  /**
   * Custom grouping of hotels
   */
  custom_label_0?: string | null;
  /**
   * Custom grouping of hotels
   */
  custom_label_1?: string | null;
  /**
   * Custom grouping of hotels
   */
  custom_label_2?: string | null;
  /**
   * Custom grouping of hotels
   */
  custom_label_3?: string | null;
  /**
   * Custom grouping of hotels
   */
  custom_label_4?: string | null;
  /**
   * The type of property. The category can be any type of internal description desired.
   */
  category?: string | null;
  /**
   * Base price of the hotel room per night followed by the ISO currency code
   */
  base_price?: string | null;
  /**
   * Sale price of a hotel room per night. Used to advertise discounts off the regular price of the hotel.
   */
  sale_price?: string | null;
  /**
   * If specified, you must provide all properties
   */
  guest_ratings?: CatalogsHotelGuestRatings;
};

/**
 * Creative assets product metadata entity
 */
export type CatalogsCreativeAssetsProductMetadata = {
  /**
   * The user-created unique ID that represents the creative assets item.
   */
  creative_assets_id: string;
  visibility: CreativeAssetsVisibilityType;
};

export type CatalogsCreativeAssetsProduct = {
  catalog_type: 'CREATIVE_ASSETS';
  metadata: CatalogsCreativeAssetsProductMetadata;
  pin: Pin;
};

/**
 * Creative assets visibility.
 */
export type CreativeAssetsVisibilityType = 'VISIBLE' | 'HIDDEN';

/**
 * Request object to update catalogs creative assets items
 */
export type CatalogsCreativeAssetsBatchRequest = {
  catalog_type: 'CREATIVE_ASSETS';
  country: Country;
  /**
   * We recommend using the CatalogsLocale values.
   */
  language: CatalogsLocale | Language;
  /**
   * Array with creative assets item operations
   */
  items: Array<CatalogsCreativeAssetsBatchItem>;
  /**
   * Catalog id pertaining to the creative assets item. If not provided, default to oldest creative assets catalog
   */
  catalog_id?: string;
};

/**
 * Creative assets batch item
 */
export type CatalogsCreativeAssetsBatchItem =
  | CatalogsCreateCreativeAssetsItem
  | CatalogsUpsertCreativeAssetsItem
  | CatalogsUpdateCreativeAssetsItem
  | CatalogsDeleteCreativeAssetsItem;

/**
 * A creative assets item to be created.
 */
export type CatalogsCreateCreativeAssetsItem = {
  /**
   * The catalog creative assets id in the merchant namespace
   */
  creative_assets_id: string;
  operation: 'CREATE';
  attributes: CatalogsCreativeAssetsAttributes;
};

/**
 * A creative assets item to be updated.
 */
export type CatalogsUpdateCreativeAssetsItem = {
  /**
   * The catalog creative assets item id in the merchant namespace
   */
  creative_assets_id: string;
  operation: 'UPDATE';
  attributes: CatalogsUpdatableCreativeAssetsAttributes;
};

/**
 * A creative assets item to be upserted.
 */
export type CatalogsUpsertCreativeAssetsItem = {
  /**
   * The catalog creative assets id in the merchant namespace
   */
  creative_assets_id: string;
  operation: 'UPSERT';
  attributes: CatalogsCreativeAssetsAttributes;
};

/**
 * A creative assets item to be deleted
 */
export type CatalogsDeleteCreativeAssetsItem = {
  /**
   * The catalog creative assets id in the merchant namespace
   */
  creative_assets_id: string;
  operation: 'DELETE';
};

export type CatalogsUpdatableCreativeAssetsAttributes = {
  /**
   * The name of the creative assets.
   */
  title?: string;
  /**
   * Brief description of the creative assets.
   */
  description?: string;
  /**
   * Link to the creative assets page.
   */
  link?: string;
  /**
   * IOS deep link to the creative assets page.
   */
  ios_deep_link?: string | null;
  /**
   * Link to the creative assets page.
   */
  android_deep_link?: string | null;
  /**
   * The categorization of the product based on the standardized Google Product Taxonomy. This is a set taxonomy. Both the text values and numeric codes are accepted.
   */
  google_product_category?: string | null;
  /**
   * Custom grouping of creative assets.
   */
  custom_label_0?: string | null;
  /**
   * Custom grouping of creative assets.
   */
  custom_label_1?: string | null;
  /**
   * Custom grouping of creative assets.
   */
  custom_label_2?: string | null;
  /**
   * Custom grouping of creative assets.
   */
  custom_label_3?: string | null;
  /**
   * Custom grouping of creative assets.
   */
  custom_label_4?: string | null;
  /**
   * Visibility of the creative assets. Must be one of the following values (upper or lowercase): ‘visible’, ‘hidden’.
   */
  visibility?: string | null;
};

export type CatalogsCreativeAssetsAttributes = {
  /**
   * The creative assets image.
   */
  image_link?: string;
  /**
   * The creative assets video.
   */
  video_link?: string;
} & CatalogsUpdatableCreativeAssetsAttributes;

/**
 * Request object for creating a catalog based product group.
 */
export type CatalogsVerticalProductGroupCreateRequest =
  | CatalogsRetailProductGroupCreateRequest
  | CatalogsHotelProductGroupCreateRequest
  | CatalogsCreativeAssetsProductGroupCreateRequest;

/**
 * Request object for updating a catalog based product group.
 */
export type CatalogsVerticalProductGroupUpdateRequest =
  | CatalogsRetailProductGroupUpdateRequest
  | CatalogsHotelProductGroupUpdateRequest
  | CatalogsCreativeAssetsProductGroupUpdateRequest;

export type ConditionFilter = {
  CONDITION: CatalogsProductGroupMultipleStringCriteria;
};

/**
 * Schema describing the object in the response, which contains information about the events that were received and processed.
 */
export type ConversionApiResponse = {
  /**
   * Total number of events received in the request.
   */
  num_events_received: number;
  /**
   * Number of events that were successfully processed from the events.
   */
  num_events_processed: number;
  /**
   * Specific messages for each event received. The order will match the order in which the events were received in the request.
   */
  events: Array<{
    /**
     * Whether the event was processed successfully.
     */
    status: 'failed' | 'processed';
    /**
     * Error message containing more information about why the event failed to be processed.
     */
    error_message?: string | null;
    /**
     * Warning messages about any fields in the event which are not standard. These are not critical to event processing.
     */
    warning_message?: string | null;
  }>;
};

export type ConversionAttributionWindowDays = 0 | 1 | 7 | 14 | 30 | 60;

export type ConversionEventResponse = {
  conversion_event?: ConversionTagType;
  /**
   * Id of the tag.
   */
  conversion_tag_id?: string;
  /**
   * Id of the ad account.
   */
  ad_account_id?: string;
  /**
   * Creation date in epoch format.
   */
  created_time?: number;
};

/**
 * A list of events (one or more) encapsulated by a data object.
 */
export type ConversionEvents = {
  data: Array<{
    /**
     * <p>The type of the user event. Please use the right event_name otherwise the event won't be accepted and show up correctly in reports.
     * <ul>
     * <li><code>add_to_cart</code></li>
     * <li><code>checkout</code></li>
     * <li><code>custom</code></li>
     * <li><code>lead</code></li>
     * <li><code>page_visit</code></li>
     * <li><code>search</code></li>
     * <li><code>signup</code></li>
     * <li><code>view_category</code></li>
     * <li><code>watch_video</code></li>
     * </ul>
     * </p>
     *
     */
    event_name: string;
    /**
     * <p>
     * The source indicating where the conversion event occurred.
     * <ul>
     * <li><code>app_android</code></li>
     * <li><code>app_ios</code></li>
     * <li><code>web</code></li>
     * <li><code>offline</code></li>
     * </ul>
     * </p>
     *
     */
    action_source: string;
    /**
     * The time when the event happened. Unix timestamp in seconds.
     */
    event_time: number;
    /**
     * A unique id string that identifies this event and can be used for deduping between events ingested via both the conversion API and Pinterest tracking. Without this, event's data is likely to be double counted and will cause report metric inflation. Third-party vendors make sure this field is updated on both Pinterest tag and Conversions API side before rolling out template for Conversions API.
     */
    event_id: string;
    /**
     * URL of the web conversion event.
     */
    event_source_url?: string | null;
    /**
     * When action_source is web or offline, it defines whether the user has opted out of tracking for web conversion events. While when action_source is app_android or app_ios, it defines whether the user has enabled Limit Ad Tracking on their iOS device, or opted out of Ads Personalization on their Android device.
     */
    opt_out?: boolean;
    /**
     * The third party partner name responsible to send the event to Conversions API on behalf of the advertiser. The naming convention is "ss-partnername" lowercase. E.g ‘ss-shopify’
     */
    partner_name?: string | null;
    user_data: ConversionEventsUserData;
    /**
     * Object containing other custom data.
     */
    custom_data?: {
      /**
       * The ISO-4217 currency code. If not provided, we will default to the advertiser's currency set during account creation. Your campaign performance needs this field to report right ROAS/CPA.
       */
      currency?: string | null;
      /**
       * Total value of the event. Accepted as a string in the request; it will be parsed into a double. For example, if there are two items in a checkout event, the value should be the total price. We recommend to use pre-tax, pre-shipping final value.
       */
      value?: string | null;
      /**
       * List of products IDs. We recommend using this if you are a merchant for PageVisit, AddToCart and Checkouts. For detail, please check <a href="https://help.pinterest.com/en/business/article/before-you-get-started-with-catalogs" target="_blank">here</a> (Install the Pinterest tag section).
       */
      content_ids?: Array<string>;
      /**
       * The name of the page or product associated with the event.
       */
      content_name?: string | null;
      /**
       * The category of the content associated with the event.
       */
      content_category?: string | null;
      /**
       * The brand of the content associated with the event.
       */
      content_brand?: string | null;
      /**
       * A list of objects containing information about products, such as price and quantity. We recommend using this if you are a merchant for PageVisit, AddToCart and Checkouts. For detail, please check <a href="https://help.pinterest.com/en/business/article/before-you-get-started-with-catalogs" target="_blank">here</a> (Install the Pinterest tag section).
       */
      contents?: Array<{
        /**
         * The id of a product. We recommend using this if you are a merchant for AddToCart and Checkouts. For detail, please check <a href="https://help.pinterest.com/en/business/article/before-you-get-started-with-catalogs" target="_blank">here</a> (Install the Pinterest tag section).
         */
        id?: string;
        /**
         * The price of a product. Accepted as a string in the request; it will be parsed into a double. This is the original item value before any discount. We recommend using this if you are a merchant for PageVisit, AddToCart and Checkouts. For detail, please check <a href="https://help.pinterest.com/en/business/article/before-you-get-started-with-catalogs" target="_blank">here</a> (Install the Pinterest tag section).
         */
        item_price?: string;
        /**
         * The amount of a product. We recommend using this if you are a merchant for AddToCart and Checkouts. For detail, please check <a href="https://help.pinterest.com/en/business/article/before-you-get-started-with-catalogs" target="_blank">here</a> (Install the Pinterest tag section).
         */
        quantity?: number;
        /**
         * The name of a product.
         */
        item_name?: string;
        /**
         * The category of a product.
         */
        item_category?: string;
        /**
         * The brand of a product.
         */
        item_brand?: string;
      }>;
      /**
       * Total number of products of the event. For example, the total number of items purchased in a checkout event. We recommend using this if you are a merchant for AddToCart and Checkouts. For detail, please check <a href="https://help.pinterest.com/en/business/article/before-you-get-started-with-catalogs" target="_blank">here</a> (Install the Pinterest tag section).
       */
      num_items?: number;
      /**
       * The order ID. We recommend sending order_id to help us deduplicate events when necessary. This also helps to run other measurement products at Pinterest.
       */
      order_id?: string | null;
      /**
       * The search string related to the user conversion event.
       */
      search_string?: string | null;
      /**
       * Flags for different privacy rights laws to opt out users of sharing personal information. Values should be comma separated. Please follow the <a href="https://help.pinterest.com/en/business/article/limited-data-processing" target="_blank">Help Center</a> and <a href="/docs/api-features/conversion-overview/" target="_blank">dev site</a> for specific opt_out_type set up.
       */
      opt_out_type?: string | null;
      /**
       * Named partner. Not required, this is for Pinterest internal use only. Please do not use this unless specifically guided.
       */
      np?: string | null;
    };
    /**
     * The app store app ID.
     */
    app_id?: string | null;
    /**
     * Name of the app.
     */
    app_name?: string | null;
    /**
     * Version of the app.
     */
    app_version?: string | null;
    /**
     * Brand of the user device.
     */
    device_brand?: string | null;
    /**
     * User device's mobile carrier.
     */
    device_carrier?: string | null;
    /**
     * Model of the user device.
     */
    device_model?: string | null;
    /**
     * Type of the user device.
     */
    device_type?: string | null;
    /**
     * Version of the device operating system.
     */
    os_version?: string | null;
    /**
     * Whether the event occurred when the user device was connected to wifi.
     */
    wifi?: boolean;
    /**
     * Two-character ISO-639-1 language code indicating the user's language.
     */
    language?: string | null;
  }>;
};

/**
 * Object containing customer information data. Note, It is required at least one of 1) em, 2) hashed_maids or 3) pair client_ip_address + client_user_agent.
 */
export type ConversionEventsUserData =
  | {
      /**
       * Sha256 hashes of lowercase version of user's email addresses. Used for matching. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.
       */
      em: Array<string>;
      /**
       * Sha256 hashes of user's "Google Advertising IDs" (GAIDs) or "Apple's Identifier for Advertisers" (IDFAs). Used for matching. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.
       */
      hashed_maids?: Array<string>;
      /**
       * The user's IP address, which can be either in IPv4 or IPv6 format. Used for matching. We highly recommend this for all events. It may improve reporting performance such as ROAS/CPA.
       */
      client_ip_address?: string;
      /**
       * The user agent string of the user's web browser. We highly recommend this for all events. It may improve reporting performance such as ROAS/CPA.
       */
      client_user_agent?: string;
    }
  | {
      /**
       * Sha256 hashes of lowercase version of user's email addresses. Used for matching. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.
       */
      em?: Array<string>;
      /**
       * Sha256 hashes of user's "Google Advertising IDs" (GAIDs) or "Apple's Identifier for Advertisers" (IDFAs). Used for matching. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.
       */
      hashed_maids: Array<string>;
      /**
       * The user's IP address, which can be either in IPv4 or IPv6 format. Used for matching. We highly recommend this for all events. It may improve reporting performance such as ROAS/CPA.
       */
      client_ip_address?: string;
      /**
       * The user agent string of the user's web browser. We highly recommend this for all events. It may improve reporting performance such as ROAS/CPA.
       */
      client_user_agent?: string;
    }
  | {
      /**
       * Sha256 hashes of lowercase version of user's email addresses. Used for matching. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.
       */
      em?: Array<string>;
      /**
       * Sha256 hashes of user's "Google Advertising IDs" (GAIDs) or "Apple's Identifier for Advertisers" (IDFAs). Used for matching. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.
       */
      hashed_maids?: Array<string>;
      /**
       * The user's IP address, which can be either in IPv4 or IPv6 format. Used for matching. We highly recommend this for all events. It may improve reporting performance such as ROAS/CPA.
       */
      client_ip_address: string;
      /**
       * The user agent string of the user's web browser. We highly recommend this for all events. It may improve reporting performance such as ROAS/CPA.
       */
      client_user_agent: string;
    }
  | {
      /**
       * Sha256 hashes of user's phone numbers, only digits with country code, area code, and number. Remove any symbols, letters, spaces and leading zeros. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.
       */
      ph?: Array<string>;
      /**
       * Sha256 hashes of user's gender, in lowercase. Either "f" or "m" or "n" for non-binary gender. The string should be in the UTF-8 format.
       */
      ge?: Array<string>;
      /**
       * Sha256 hashes of user's date of birthday, given as year, month, and day. The string should be in the UTF-8 format.
       */
      db?: Array<string>;
      /**
       * Sha256 hashes of user's last name, in lowercase. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.
       */
      ln?: Array<string>;
      /**
       * Sha256 hashes of user's first name, in lowercase. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.
       */
      fn?: Array<string>;
      /**
       * Sha256 hashes of user's city, in lowercase, and without spaces or punctuation. User residency city (mostly billing). The string should be in the UTF-8 format.
       */
      ct?: Array<string>;
      /**
       * Sha256 hashes of user's state, given as a two-letter code in lowercase. User residency state (mostly billing). The string should be in the UTF-8 format.
       */
      st?: Array<string>;
      /**
       * Sha256 hashes of user's zipcode, only digits. User residency zipcode (mostly billing). The string should be in the UTF-8 format.
       */
      zp?: Array<string>;
      /**
       * Sha256 hashes of two-character ISO-3166 country code indicating the user's country, in lowercase. The string should be in the UTF-8 format.
       */
      country?: Array<string>;
      /**
       * Sha256 hashes of the unique id from the advertiser that identifies a user in their space, e.g. user id, loyalty id, etc. We highly recommend this on all events. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.
       */
      external_id?: Array<string>;
      /**
       * The unique identifier stored in _epik cookie on your domain or &epik= query parameter in the URL. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA.
       */
      click_id?: string | null;
      /**
       * A unique identifier of visitors' information defined by third party partners. e.g RampID
       */
      partner_id?: string | null;
    };

/**
 * Attribution type. Refers to the Pinterest Tag endpoints
 */
export type ConversionReportAttributionType = 'INDIVIDUAL' | 'HOUSEHOLD';

/**
 * Conversion report time type
 */
export type ConversionReportTimeType = 'TIME_OF_AD_ACTION' | 'TIME_OF_CONVERSION';

export type ConversionTagCommon = {
  /**
   * Ad account ID.
   */
  ad_account_id?: string;
  /**
   * Tag code snippet.
   */
  code_snippet?: string;
  enhanced_match_status?: EnhancedMatchStatusType;
  /**
   * Tag ID.
   */
  id?: string;
  /**
   * Time for the last event fired.
   */
  last_fired_time_ms?: number | null;
  /**
   * Conversion tag name.
   */
  name?: string;
  status?: EntityStatus;
  /**
   * Version number.
   */
  version?: string;
  configs?: ConversionTagConfigs;
};

export type ConversionTagConfigs = {
  /**
   * Whether Automatic Enhanced Match email is enabled. See <a href="https://help.pinterest.com/en/business/article/enhanced-match" target="_blank">Enhanced match</a> for more information.
   */
  aem_enabled?: boolean | null;
  /**
   * Metadata ingestion frequency.
   */
  md_frequency?: number | null;
  /**
   * Whether Automatic Enhanced Match name is enabled. See <a href="https://help.pinterest.com/en/business/article/enhanced-match" target="_blank">Enhanced match</a> for more information.
   */
  aem_fnln_enabled?: boolean | null;
  /**
   * Whether Automatic Enhanced Match phone is enabled. See <a href="https://help.pinterest.com/en/business/article/enhanced-match" target="_blank">Enhanced match</a> for more information.
   */
  aem_ph_enabled?: boolean | null;
  /**
   * Whether Automatic Enhanced Match gender is enabled. See <a href="https://help.pinterest.com/en/business/article/enhanced-match" target="_blank">Enhanced match</a> for more information.
   */
  aem_ge_enabled?: boolean | null;
  /**
   * Whether Automatic Enhanced Match birthdate is enabled. See <a href="https://help.pinterest.com/en/business/article/enhanced-match" target="_blank">Enhanced match</a> for more information.
   */
  aem_db_enabled?: boolean | null;
  /**
   * Whether Automatic Enhanced Match location is enabled. See <a href="https://help.pinterest.com/en/business/article/enhanced-match" target="_blank">Enhanced match</a> for more information.
   */
  aem_loc_enabled?: boolean | null;
};

export type ConversionTagCreate = ConversionTagConfigs & {
  /**
   * Conversion tag name.
   */
  name: string;
};

export type ConversionTagListResponse = {
  items?: Array<ConversionTagResponse>;
};

export type ConversionTagResponse = ConversionTagCommon;

/**
 * conversion tag type
 */
export type ConversionTagType =
  | 'PAGE_LOAD'
  | 'UNKNOWN'
  | 'INITIALIZED'
  | 'PAGE_VISIT'
  | 'SIGNUP'
  | 'CHECKOUT'
  | 'CUSTOM'
  | 'VIEW_CATEGORY'
  | 'SEARCH'
  | 'ADD_TO_CART'
  | 'WATCH_VIDEO'
  | 'LEAD'
  | 'APP_INSTALL'
  | 'WEB_SESSION'
  | 'EXTERNAL_MEASUREMENT';

export type ConversionTagsOcpmEligibleResponse = {
  [key: string]: Array<ConversionEventResponse>;
};

/**
 * Country ID from ISO 3166-1 alpha-2.
 */
export type Country =
  | 'AD'
  | 'AE'
  | 'AF'
  | 'AG'
  | 'AI'
  | 'AL'
  | 'AM'
  | 'AO'
  | 'AQ'
  | 'AR'
  | 'AS'
  | 'AT'
  | 'AU'
  | 'AW'
  | 'AX'
  | 'AZ'
  | 'BA'
  | 'BB'
  | 'BD'
  | 'BE'
  | 'BF'
  | 'BG'
  | 'BH'
  | 'BI'
  | 'BJ'
  | 'BL'
  | 'BM'
  | 'BN'
  | 'BO'
  | 'BQ'
  | 'BR'
  | 'BS'
  | 'BT'
  | 'BV'
  | 'BW'
  | 'BY'
  | 'BZ'
  | 'CA'
  | 'CC'
  | 'CD'
  | 'CF'
  | 'CG'
  | 'CH'
  | 'CI'
  | 'CK'
  | 'CL'
  | 'CM'
  | 'CN'
  | 'CO'
  | 'CR'
  | 'CU'
  | 'CV'
  | 'CW'
  | 'CX'
  | 'CY'
  | 'CZ'
  | 'DE'
  | 'DJ'
  | 'DK'
  | 'DM'
  | 'DO'
  | 'DZ'
  | 'EC'
  | 'EE'
  | 'EG'
  | 'EH'
  | 'ER'
  | 'ES'
  | 'ET'
  | 'FI'
  | 'FJ'
  | 'FK'
  | 'FM'
  | 'FO'
  | 'FR'
  | 'GA'
  | 'GB'
  | 'GD'
  | 'GE'
  | 'GF'
  | 'GG'
  | 'GH'
  | 'GI'
  | 'GL'
  | 'GM'
  | 'GN'
  | 'GP'
  | 'GQ'
  | 'GR'
  | 'GS'
  | 'GT'
  | 'GU'
  | 'GW'
  | 'GY'
  | 'HK'
  | 'HM'
  | 'HN'
  | 'HR'
  | 'HT'
  | 'HU'
  | 'ID'
  | 'IE'
  | 'IL'
  | 'IM'
  | 'IN'
  | 'IO'
  | 'IQ'
  | 'IR'
  | 'IS'
  | 'IT'
  | 'JE'
  | 'JM'
  | 'JO'
  | 'JP'
  | 'KE'
  | 'KG'
  | 'KH'
  | 'KI'
  | 'KM'
  | 'KN'
  | 'KR'
  | 'KW'
  | 'KY'
  | 'KZ'
  | 'LA'
  | 'LB'
  | 'LC'
  | 'LI'
  | 'LK'
  | 'LR'
  | 'LS'
  | 'LT'
  | 'LU'
  | 'LV'
  | 'LY'
  | 'MA'
  | 'MC'
  | 'MD'
  | 'ME'
  | 'MF'
  | 'MG'
  | 'MH'
  | 'MK'
  | 'ML'
  | 'MM'
  | 'MN'
  | 'MO'
  | 'MP'
  | 'MQ'
  | 'MR'
  | 'MS'
  | 'MT'
  | 'MU'
  | 'MV'
  | 'MW'
  | 'MX'
  | 'MY'
  | 'MZ'
  | 'NA'
  | 'NC'
  | 'NE'
  | 'NF'
  | 'NG'
  | 'NI'
  | 'NL'
  | 'NO'
  | 'NP'
  | 'NR'
  | 'NU'
  | 'NZ'
  | 'OM'
  | 'PA'
  | 'PE'
  | 'PF'
  | 'PG'
  | 'PH'
  | 'PK'
  | 'PL'
  | 'PM'
  | 'PN'
  | 'PR'
  | 'PS'
  | 'PT'
  | 'PW'
  | 'PY'
  | 'QA'
  | 'RE'
  | 'RO'
  | 'RS'
  | 'RU'
  | 'RW'
  | 'SA'
  | 'SB'
  | 'SC'
  | 'SD'
  | 'SE'
  | 'SG'
  | 'SH'
  | 'SI'
  | 'SJ'
  | 'SK'
  | 'SL'
  | 'SM'
  | 'SN'
  | 'SO'
  | 'SR'
  | 'SS'
  | 'ST'
  | 'SV'
  | 'SX'
  | 'SY'
  | 'SZ'
  | 'TC'
  | 'TD'
  | 'TF'
  | 'TG'
  | 'TH'
  | 'TJ'
  | 'TK'
  | 'TL'
  | 'TM'
  | 'TN'
  | 'TO'
  | 'TR'
  | 'TT'
  | 'TV'
  | 'TW'
  | 'TZ'
  | 'UA'
  | 'UG'
  | 'UM'
  | 'US'
  | 'UY'
  | 'UZ'
  | 'VA'
  | 'VC'
  | 'VE'
  | 'VG'
  | 'VI'
  | 'VN'
  | 'VU'
  | 'WF'
  | 'WS'
  | 'YE'
  | 'YT'
  | 'ZA'
  | 'ZM'
  | 'ZW';

export type CountryFilter = {
  COUNTRY: CatalogsProductGroupMultipleCountriesCriteria;
};

/**
 * An object containing a list of all the asset access requests
 */
export type CreateAssetAccessRequestBody = {
  asset_requests: Array<{
    /**
     * Unique identifier of a business partner to request asset access to.
     */
    partner_id: string;
    asset_id_to_permissions: AssetIdToPermissions;
  }>;
};

/**
 * A list of errors associated with the asset access requests. Will be returned if there is an error.
 */
export type CreateAssetAccessRequestErrorMessage = Array<{
  /**
   * Error code associated with the error in requesting asset access.
   */
  code?: number;
  messages?: Array<string>;
}> | null;

export type CreateAssetAccessRequestResponse = {
  exceptions?: CreateAssetAccessRequestErrorMessage;
  invites?: {
    [key: string]: string;
  } | null;
};

export type CreateAssetGroupBody = {
  /**
   * Asset Group name
   */
  asset_group_name: string;
  /**
   * Asset group description
   */
  asset_group_description: string;
  asset_group_types: AssetGroupTypes;
};

export type CreateAssetGroupResponse = {
  asset_group?: AssetGroupBinding;
};

export type CreateInvitesResultsResponseArray = {
  /**
   * List of invite/request creation status. If there is an error, an exception object will be returned. If the action was successfully completed, an invite object will be returned.
   */
  items?: Array<{
    exception?: InviteExceptionResponse;
    /**
     * An invite object if the invite/request was successfully created. Will only be provided if the an invite/request is successfully created.
     */
    invite?: {
      /**
       * Unique identifier of the invite/request.
       */
      id?: string;
      /**
       * Metadata for the member/partner that was sent the invite/request.
       */
      user?: BusinessAccessUserSummary;
    } | null;
  }>;
};

/**
 * Body to be used on path to send Members or Partners Invite or Request
 */
export type CreateMembershipOrPartnershipInvitesBody = {
  /**
   * The business access level to grant member/partner. Note, values are case-sensitive.
   * - EMPLOYEE: Can only view and access assets you assign them to. They cannot see details about other employees, partners, or other assets.
   * - BIZ_ADMIN: Have full control of roles and can add employees and partners as well as grant asset access.
   * - PARTNER: Can only view and access assets you assign them to/or they assign to you.
   */
  business_role: 'EMPLOYEE' | 'BIZ_ADMIN' | 'PARTNER';
  invite_type: InviteType;
  /**
   * A list of usernames, emails, or a mix of them. Should be used if invite_type is MEMBER_INVITE
   */
  members?: Array<string>;
  /**
   * A list of partner_id. Should be used if invite_type is PARTNER_INVITE or PARTNER_REQUEST
   */
  partners?: Array<string>;
};

/**
 * The business access level to grant member/partner. Note, values are case-sensitive.
 * - EMPLOYEE: Can only view and access assets you assign them to. They cannot see details about other employees, partners, or other assets.
 * - BIZ_ADMIN: Have full control of roles and can add employees and partners as well as grant asset access.
 * - PARTNER: Can only view and access assets you assign them to/or they assign to you.
 */
export type business_role = 'EMPLOYEE' | 'BIZ_ADMIN' | 'PARTNER';

export type CreateMMMReportRequest = {
  /**
   * A List of countries for filtering
   */
  countries?: Array<TargetingAdvertiserCountry>;
} & {
  /**
   * Name of the Marketing Mix Modeling (MMM) report
   */
  report_name: string;
  /**
   * Metric report start date (UTC). Format: YYYY-MM-DD
   */
  start_date: string;
  /**
   * Metric report end date (UTC). Format: YYYY-MM-DD
   */
  end_date: string;
  /**
   * DAY - metrics are broken down daily.<br> WEEK - metrics are broken down weekly.
   */
  granularity: 'DAY' | 'WEEK';
  /**
   * Level of the report
   */
  level: 'CAMPAIGN_TARGETING' | 'AD_GROUP_TARGETING';
  /**
   * List of targeting types
   */
  targeting_types: Array<MMMReportingTargetingType>;
  /**
   * Metric and entity columns
   */
  columns: Array<MMMReportingColumn>;
};

/**
 * DAY - metrics are broken down daily.<br> WEEK - metrics are broken down weekly.
 */
export type granularity = 'DAY' | 'WEEK';

/**
 * Level of the report
 */
export type level = 'CAMPAIGN_TARGETING' | 'AD_GROUP_TARGETING';

export type CreateMMMReportResponse = {
  code?: number;
  data?: {
    report_status?: BulkReportingJobStatus;
    token?: string;
    message?: string | null;
    status?: string;
  };
};

/**
 * Ad creative type enum. For update, only draft ads may update creative type. </p><strong>Note:</strong> SHOP_THE_PIN has been deprecated. Please use COLLECTION instead.
 */
export type CreativeType =
  | 'REGULAR'
  | 'VIDEO'
  | 'SHOPPING'
  | 'CAROUSEL'
  | 'MAX_VIDEO'
  | 'SHOP_THE_PIN'
  | 'COLLECTION'
  | 'IDEA'
  | 'SHOWCASE'
  | 'QUIZ';

/**
 * Currency Codes from ISO 4217
 */
export type Currency =
  | 'UNK'
  | 'USD'
  | 'GBP'
  | 'CAD'
  | 'EUR'
  | 'AUD'
  | 'NZD'
  | 'SEK'
  | 'ILS'
  | 'CHF'
  | 'HKD'
  | 'JPY'
  | 'SGD'
  | 'KRW'
  | 'NOK'
  | 'DKK'
  | 'PLN'
  | 'RON'
  | 'HUF'
  | 'CZK'
  | 'BRL'
  | 'MXN'
  | 'ARS'
  | 'CLP'
  | 'COP'
  | 'INR'
  | 'TRY';

export type CurrencyFilter = {
  CURRENCY: CatalogsProductGroupCurrencyCriteria;
};

/**
 * Custom Column ID
 */
export type CustomColumnId = string;

export type CustomLabel0Filter = {
  CUSTOM_LABEL_0: CatalogsProductGroupMultipleStringCriteria;
};

export type CustomLabel1Filter = {
  CUSTOM_LABEL_1: CatalogsProductGroupMultipleStringCriteria;
};

export type CustomLabel2Filter = {
  CUSTOM_LABEL_2: CatalogsProductGroupMultipleStringCriteria;
};

export type CustomLabel3Filter = {
  CUSTOM_LABEL_3: CatalogsProductGroupMultipleStringCriteria;
};

export type CustomLabel4Filter = {
  CUSTOM_LABEL_4: CatalogsProductGroupMultipleStringCriteria;
};

export type CustomerList = {
  /**
   * Associated ad account ID.
   */
  ad_account_id?: string;
  /**
   * Creation time. Unix timestamp in seconds.
   */
  created_time?: number;
  /**
   * Customer list ID.
   */
  id?: string;
  /**
   * Customer list name.
   */
  name?: string;
  /**
   * Total number of list updates.  List creation counts as one batch. Each <a href="/docs/redoc/#operation/ads_v3_customer_list_add_handler_PUT">Append</a> or <a href="/docs/redoc/#operation/ads_v3_customer_list_remove_handler_PUT">Remove API</a> call counts as another. List creation via the Ads Manager UI could result in more than one batch since the UI breaks up large lists.
   */
  num_batches?: number;
  /**
   * Number of removed user records. In a <a href="/docs/redoc/#operation/ads_v3_customer_list_remove_handler_PUT">Remove API</a> call, this counter increases even if the user is not found in the list.
   */
  num_removed_user_records?: number;
  /**
   * Number of uploaded user records. In an <a href="/docs/redoc/#operation/ads_v3_customer_list_add_handler_PUT">Append API</a> call, this counter increases even if the uploaded user is already in the list.
   */
  num_uploaded_user_records?: number;
  /**
   * Customer list status. TOO_SMALL - the list has less than 100 Pinterest users.
   */
  status?: 'PROCESSING' | 'READY' | 'TOO_SMALL' | 'UPLOADING';
  /**
   * Always "customerlist".
   */
  type?: string;
  /**
   * Last update time. Unix timestamp in seconds.
   */
  updated_time?: number;
  /**
   * Customer list errors
   */
  exceptions?: {
    [key: string]: unknown;
  };
};

/**
 * Customer list status. TOO_SMALL - the list has less than 100 Pinterest users.
 */
export type status2 = 'PROCESSING' | 'READY' | 'TOO_SMALL' | 'UPLOADING';

export type CustomerListRequest = {
  /**
   * Customer list name.
   */
  name: string;
  /**
   * Records list. Can be any combination of emails, MAIDs, or IDFAs. Emails must be lowercase and can be plain text or hashed using SHA1, SHA256, or MD5. MAIDs and IDFAs must be hashed with SHA1, SHA256, or MD5.
   */
  records: string;
  list_type?: UserListType;
  /**
   * Customer list errors.
   */
  exceptions?: {
    [key: string]: unknown;
  };
};

export type CustomerListUpdateRequest = {
  /**
   * Records list. Can be any combination of emails, MAIDs, or IDFAs. Emails must be lowercase and can be plain text or hashed using SHA1, SHA256, or MD5. MAIDs and IDFAs must be hashed with SHA1, SHA256, or MD5.
   */
  records: string;
  operation_type: UserListOperationType;
  exceptions?: Exception;
};

/**
 * Format of generated report
 */
export type DataOutputFormat = 'JSON' | 'CSV';

/**
 * Metrics availablity, e.g., "READY".
 */
export type DataStatus =
  | 'PROCESSING'
  | 'READY'
  | 'ESTIMATE'
  | 'BEFORE_BUSINESS_CREATED'
  | 'BEFORE_DATA_RETENTION_PERIOD'
  | 'BEFORE_PIN_DATA_RETENTION_PERIOD'
  | 'BEFORE_METRIC_START_DATE'
  | 'BEFORE_CORE_METRIC_START_DATE'
  | 'BEFORE_PIN_FORMAT_METRIC_START_DATE'
  | 'BEFORE_AUDIENCE_METRIC_START_DATE'
  | 'BEFORE_AUDIENCE_MONTHLY_METRIC_START_DATE'
  | 'BEFORE_VIDEO_METRIC_START_DATE'
  | 'BEFORE_CONVERSION_METRIC_START_DATE'
  | 'PURCHASERS_METRIC_SMALLER_THAN_THRESHOLD'
  | 'IN_BAD_TAG_DATE'
  | 'BEFORE_PUBLISHED_METRIC_START_DATE'
  | 'BEFORE_ASSIST_METRIC_START_DATE'
  | 'BEFORE_PIN_CREATED'
  | 'BEFORE_ACCOUNT_CLAIMED'
  | 'BEFORE_DEMOGRAPHIC_FILTERS_START_DATE'
  | 'AUDIENCE_SEGMENT_SMALLER_THAN_THRESHOLD'
  | 'AUDIENCE_TOTAL_SMALLER_THAN_THRESHOLD'
  | 'BEFORE_PRODUCT_GROUP_FILTER_START_DATE';

/**
 * The terminated asset access.
 */
export type DeleteMemberAccessResult = {
  /**
   * Unique identifier of the business asset.
   */
  asset_id?: string;
  /**
   * Unique identifier of the business member.
   */
  member_id?: string;
};

export type DeleteMemberAccessResultsResponseArray = {
  /**
   * List of member asset permissions that were deleted.
   */
  items?: Array<DeleteMemberAccessResult>;
};

/**
 * An object with a list of members that were deleted.
 */
export type DeletedMembersResponse = {
  /**
   * List of members whose business membership have been terminated.
   */
  deleted_members?: Array<string>;
};

export type DeletePartnersRequest = {
  partner_ids: Array<string>;
  partner_type?: (string | (null & BusinessRoleCheckMode)) | null;
};

/**
 * An object with a list of partners that were deleted.
 */
export type DeletePartnersResponse = {
  /**
   * List of partners whose business partnership have been terminated.
   */
  deleted_partners?: Array<string>;
};

export type DeliveryMetricsResponse = {
  items?: Array<{
    /**
     * Metric's name.
     */
    name?: string;
    /**
     * Category name
     */
    category?: 'ADS' | 'ORGANIC';
    /**
     * How the metric is defined.
     */
    definition?: string;
    /**
     * Display name, when available. If unavaible it will not be returned. Matches how the metric is named in our native tools like Pinterest Ads Manager.
     */
    display_name?: string;
  }>;
};

/**
 * Used for including extra details to a base error
 */
export type DetailedError = {
  code: number;
  message: string;
  details: {
    [key: string]: unknown;
  };
};

/**
 * Summarized pin information
 */
export type SummaryPin = {
  readonly media?: PinMedia;
  alt_text?: string | null;
  link?: string | null;
  title?: string | null;
  description?: string | null;
};

/**
 * The enhanced match status of the tag
 */
export type EnhancedMatchStatusType = 'UNKNOWN' | 'NOT_VALIDATED' | 'VALIDATING_IN_PROGRESS' | 'VALIDATION_COMPLETE';

/**
 * Entity status
 */
export type EntityStatus = 'ACTIVE' | 'PAUSED' | 'ARCHIVED' | 'DRAFT' | 'DELETED_DRAFT';

export type Error = {
  code: number;
  message: string;
};

export type Exception = {
  /**
   * Exception error code.
   */
  code?: number;
  /**
   * Exception message.
   */
  message?: string;
};

export type FollowUserRequest = {
  /**
   * Whether this request comes as result of auto-follow after clicking on a link. Follow links can be used by partners on their site or in emails. Only selected partners can be followed this way. We verify that partner can be auto-followed.
   */
  auto_follow?: boolean;
};

export type Gender = 'FEMALE' | 'MALE' | 'UNISEX';

export type GenderFilter = {
  GENDER: CatalogsProductGroupMultipleGenderCriteria;
};

export type MediaType = 'IMAGE' | 'VIDEO';

export type MediaTypeFilter = {
  MEDIA_TYPE: CatalogsProductGroupMultipleMediaTypesCriteria;
};

export type GenderList = Array<'female' | 'male' | 'unknown'>;

export type GetAudiencesOrderBy =
  | 'NONE'
  | 'ID'
  | 'SIZE'
  | 'CREATION_DATE'
  | 'UPDATED_TIME'
  | 'NAME'
  | 'STATUS'
  | 'TYPE';

/**
 * An object containing the permissions a business has on the asset.
 */
export type GetBusinessAssetsResponse = {
  /**
   * Unique identifier of a business asset.
   */
  asset_id?: string;
  asset_type?: AssetTypeResponse;
  /**
   * An object containing all the information specific to the provided asset group. This field will be populated only if asset_type equals 'ASSET_GROUP'.
   */
  asset_group_info?: AssetGroupBinding | null;
};

/**
 * Type of asset.
 */
export type GetBusinessAssetTypeResponse = 'AD_ACCOUNT' | 'PROFILE' | 'ASSET_GROUP' | 'CONVERSION_TAG';

export type GetMMMReportResponse = {
  code?: number;
  data?: {
    report_status?: 'DOES_NOT_EXIST' | 'FINISHED' | 'IN_PROGRESS' | 'EXPIRED' | 'FAILED' | 'CANCELLED';
    url?: string | null;
    size?: number | null;
  };
  message?: string;
  status?: string;
};

export type report_status2 = 'DOES_NOT_EXIST' | 'FINISHED' | 'IN_PROGRESS' | 'EXPIRED' | 'FAILED' | 'CANCELLED';

/**
 * An object containing the permissions a you/your business partner has on the asset.
 */
export type GetPartnerAssetsResponse = {
  /**
   * Unique identifier of a business asset.
   */
  asset_id?: string;
  asset_type?: AssetTypeResponse;
  /**
   * The permissions you or your partner has on the asset. If partner_type=INTERNAL, the permission levels are for the access the partner has to your business asset.<br> If partner_type=EXTERNAL, the permission levels are for the access you have to the partner's business asset.
   */
  permissions?: Array<string>;
  /**
   * An object containing all the information specific to the provided asset group. This field will be populated only if asset_type equals 'ASSET_GROUP'.
   */
  asset_group_info?: AssetGroupBinding | null;
};

export type GoogleProductCategory0Filter = {
  GOOGLE_PRODUCT_CATEGORY_0: CatalogsProductGroupMultipleStringListCriteria;
};

export type GoogleProductCategory1Filter = {
  GOOGLE_PRODUCT_CATEGORY_1: CatalogsProductGroupMultipleStringListCriteria;
};

export type GoogleProductCategory2Filter = {
  GOOGLE_PRODUCT_CATEGORY_2: CatalogsProductGroupMultipleStringListCriteria;
};

export type GoogleProductCategory3Filter = {
  GOOGLE_PRODUCT_CATEGORY_3: CatalogsProductGroupMultipleStringListCriteria;
};

export type GoogleProductCategory4Filter = {
  GOOGLE_PRODUCT_CATEGORY_4: CatalogsProductGroupMultipleStringListCriteria;
};

export type GoogleProductCategory5Filter = {
  GOOGLE_PRODUCT_CATEGORY_5: CatalogsProductGroupMultipleStringListCriteria;
};

export type GoogleProductCategory6Filter = {
  GOOGLE_PRODUCT_CATEGORY_6: CatalogsProductGroupMultipleStringListCriteria;
};

export type ProductGroupReferenceFilter = {
  PRODUCT_GROUP: CatalogsProductGroupMultipleStringCriteria;
};

/**
 * Granularity
 */
export type Granularity = 'TOTAL' | 'DAY' | 'HOUR' | 'WEEK' | 'MONTH';

/**
 * Where a user is taken after clicking on an ad in grid. </p><strong>Note:</strong>  This parameter is read-only and is set to DIRECT_TO_DESTINATION by default for direct links supported ads.  grid_click_type values provided will be ignored.
 */
export type GridClickType = 'CLOSEUP' | 'DIRECT_TO_DESTINATION';

export type HotelIdFilter = {
  HOTEL_ID: CatalogsProductGroupMultipleStringCriteria;
};

export type CreativeAssetsIdFilter = {
  CREATIVE_ASSETS_ID: CatalogsProductGroupMultipleStringCriteria;
};

/**
 * Object describing an item processing record
 */
export type HotelProcessingRecord = {
  /**
   * The catalog hotel id in the merchant namespace
   */
  hotel_id?: string;
  /**
   * Array with the validation errors for the item processing record.
   * A non empty errors list causes the item processing to fail.
   */
  errors?: Array<ItemValidationEvent>;
  /**
   * Array with the validation warnings for the item processing record
   */
  warnings?: Array<ItemValidationEvent>;
  status?: ItemProcessingStatus;
};

export type ImageDetails = {
  width: number;
  height: number | null;
  url: string;
};

export type ImageMetadata = {
  item_type?: string;
  title?: string | null;
  description?: string | null;
  link?: string | null;
  images?: {
    '150x150'?: ImageDetails;
    '400x300'?: ImageDetails;
    '600x'?: ImageDetails;
    '1200x'?: ImageDetails;
  };
};

/**
 * Schema for log sent from an integration application.
 */
export type IntegrationLog = {
  /**
   * Timestamp in milliseconds of when the log was executed at the client.
   */
  client_timestamp: number;
  /**
   * Log event type
   */
  event_type: 'APP' | 'API';
  /**
   * Log level type
   */
  log_level: 'INFO' | 'WARN' | 'ERROR';
  external_business_id?: string | null;
  advertiser_id?: string | null;
  merchant_id?: string | null;
  tag_id?: string | null;
  feed_profile_id?: string | null;
  /**
   * Explanation of the event that occured.
   */
  message?: string;
  /**
   * Version number of the integration application.
   */
  app_version_number?: string;
  /**
   * Version number of the platform the integration application is running on.
   */
  platform_version_number?: string;
  error?: IntegrationLogClientError;
  request?: IntegrationLogClientRequest;
};

/**
 * Log event type
 */
export type event_type = 'APP' | 'API';

/**
 * Log level type
 */
export type log_level = 'INFO' | 'WARN' | 'ERROR';

/**
 * System error details included in the log sent by the client.
 */
export type IntegrationLogClientError = {
  /**
   * Original cause of the error.
   */
  cause?: string;
  /**
   * Column number in the line of the file that raised the error.
   */
  column_number?: number;
  /**
   * Filename where the error happened.
   */
  file_name?: string;
  /**
   * Line number where the error happened.
   */
  line_number?: number;
  /**
   * Human-readable description of the error.
   */
  message?: string;
  /**
   * More detail about the message.
   */
  message_detail?: string;
  /**
   * Filename where the error happened.
   */
  name?: string;
  /**
   * Integer that specifies the error code.
   */
  number?: number;
  /**
   * Stack trace of where the error happened.
   */
  stack_trace?: string;
};

/**
 * HTTP request details included in the log sent by the client.
 */
export type IntegrationLogClientRequest = {
  method: 'GET' | 'HEAD' | 'POST' | 'PUT' | 'DELETE' | 'CONNECT' | 'OPTIONS' | 'TRACE' | 'PATCH';
  /**
   * HTTP request host from host header.
   */
  host: string;
  /**
   * HTTP request path.
   */
  path: string;
  /**
   * HTTP request headers as key-value pairs.
   */
  request_headers?: {
    [key: string]: string;
  };
  /**
   * HTTP response headers as key-value pairs.
   */
  response_headers?: {
    [key: string]: string;
  };
  response_status_code?: number;
};

export type method = 'GET' | 'HEAD' | 'POST' | 'PUT' | 'DELETE' | 'CONNECT' | 'OPTIONS' | 'TRACE' | 'PATCH';

/**
 * Schema describing the response when a log has invalid fields.
 */
export type IntegrationLogsInvalidLogResponse = {
  rejected_logs?: Array<{
    /**
     * Index of the log in the batch.
     */
    log_index?: number;
    /**
     * The field name containing an invalid value.
     */
    field: string;
    /**
     * The value that is invalid.
     */
    value: string;
    /**
     * The reason the value is invalid.
     */
    reason: string;
  }>;
};

/**
 * Batch of logs sent from an integration application.
 */
export type IntegrationLogsRequest = {
  logs: Array<IntegrationLog>;
};

/**
 * Response when logs are successfully processed.
 */
export type IntegrationLogsSuccessResponse = {
  message?: string;
};

/**
 * Integration metadata
 */
export type IntegrationMetadata = {
  id?: string;
  external_business_id?: string;
  connected_merchant_id?: string;
  readonly connected_user_id?: string;
  readonly connected_advertiser_id?: string;
  connected_lba_id?: string;
  connected_tag_id?: string;
  partner_access_token_expiry?: number;
  partner_refresh_token_expiry?: number;
  scopes?: string;
  created_timestamp?: number;
  updated_timestamp?: number;
  additional_id_1?: string;
  partner_metadata?: string;
};

/**
 * Schema used for creating the integration metadata.
 */
export type IntegrationRequest = {
  /**
   * External business ID for the integration.
   */
  external_business_id?: string | null;
  connected_merchant_id?: string;
  connected_advertiser_id?: string;
  connected_lba_id?: string;
  connected_tag_id?: string;
  partner_access_token?: string;
  partner_refresh_token?: string;
  partner_primary_email?: string;
  partner_access_token_expiry?: number;
  partner_refresh_token_expiry?: number;
  scopes?: string;
  additional_id_1?: string;
  partner_metadata?: string;
};

/**
 * Schema used for updating the integration metadata.
 */
export type IntegrationRequestPatch = {
  connected_merchant_id?: string;
  connected_advertiser_id?: string;
  connected_lba_id?: string;
  connected_tag_id?: string;
  partner_access_token?: string;
  partner_refresh_token?: string;
  partner_primary_email?: string;
  partner_access_token_expiry?: number;
  partner_refresh_token_expiry?: number;
  scopes?: string;
  additional_id_1?: string;
  partner_metadata?: string;
};

/**
 * Integration record
 */
export type IntegrationRecord = {
  id?: string;
  external_business_id?: string | null;
  connected_merchant_id?: string | null;
  readonly connected_user_id?: string;
  readonly connected_advertiser_id?: string | null;
  connected_lba_id?: string | null;
  connected_tag_id?: string | null;
  partner_access_token?: string | null;
  partner_refresh_token?: string | null;
  partner_primary_email?: string | null;
  partner_access_token_expiry?: number | null;
  partner_refresh_token_expiry?: number | null;
  scopes?: string | null;
  partner_metadata?: string | null;
  additional_id_1?: string | null;
  created_time?: number;
  updated_time?: number;
};

export type Interest = {
  canonical_url?: string;
  id?: string;
  key?: string;
  name?: string;
};

/**
 * Ad accounts and profiles the member/partner will be granted access to with this invite/request.
 */
export type InviteAssetsSummary = {
  /**
   * List of ad account IDs and respective permission levels that will be assigned.
   */
  ad_accounts?: Array<{
    /**
     * Unique identifier of a business ad account.
     */
    id?: string;
    permissions?: PermissionsResponse;
  }>;
  /**
   * List of profile IDs and respective permission levels that will be assigned.
   */
  profiles?: Array<{
    /**
     * Unique identifier of a business profile.
     */
    id?: string;
    permissions?: PermissionsResponse;
  }>;
} | null;

/**
 * An exception object if there is an error performing the action. Will only be provided if there is an error.
 */
export type InviteExceptionResponse = {
  /**
   * Unique identifier of the invite/request.
   */
  invite_or_request_id?: string | null;
  /**
   * Error code associated with the error in performing the action on the invite/request.
   */
  code?: number;
  /**
   * Error message associated with the error in performing the action on the invite/request.
   */
  message?: string;
  /**
   * A list of users' usernames or emails OR a list of partner ids that caused the error.
   */
  users_or_partner_ids?: Array<string> | null;
} | null;

/**
 * An invite object if the invite/request was successfully updated. Will only be provided if the an invite/request is successfully updated.
 */
export type InviteBusinessRoleBinding =
  | (BaseInviteDataResponse & {
      /**
       * Unique identifier for the business that created the invite/request.
       */
      created_by_business_id?: string;
      /**
       * Unique identifier for the user that created the invite/request.
       */
      created_by_user_id?: string;
      /**
       * Metadata for the user that updated the invite/request.
       */
      user?: BusinessAccessUserSummary;
    })
  | null;

export type InviteResponse = BaseInviteDataResponse & {
  assets_summary?: InviteAssetsSummary;
  /**
   * The access level a user would be granted on the business if the invite/request is accepted. This can be EMPLOYEE, BIZ_ADMIN, or PARTNER.
   */
  business_roles?: Array<BusinessRoleResponse>;
  /**
   * Metadata for the business that created the invite/request.
   */
  created_by_business?: BusinessAccessUserSummary | null;
  /**
   * Metadata for the user that created the invite/request.
   */
  created_by_user?: BusinessAccessUserSummary | null;
  /**
   * The time the invite/request was created. Returned in milliseconds.
   */
  created_time?: number;
};

/**
 * The current status of the invite.
 */
export type InviteStatus = 'PENDING' | 'ACCEPTED' | 'DECLINED' | 'CANCELLED' | 'EXPIRED';

/**
 * The type of invite. <br>'MEMBER_INVITE' is to invite a member to access your business assets. <br>'PARTNER INVITE' is to invite a partner to access your business assets. <br>'PARTNER_REQUEST' is to request access a partner's business assets.
 */
export type InviteType = 'MEMBER_INVITE' | 'PARTNER_INVITE' | 'PARTNER_REQUEST';

export type AssetGroupBinding = {
  /**
   * Asset Group ID.
   */
  id?: string;
  /**
   * Asset Group name
   */
  asset_group_name?: string | null;
  /**
   * Asset group description
   */
  asset_group_description?: string | null;
  /**
   * Asset group types
   */
  asset_group_types?: Array<string>;
  /**
   * A list of ad account IDs under the asset group
   */
  ad_accounts_ids?: Array<string> | null;
  /**
   * A list of profile IDs under asset group
   */
  profiles_ids?: Array<string> | null;
  /**
   * The creation time of the asset group
   */
  created_time?: number | null;
  /**
   * The last update time of the asset group
   */
  updated_time?: number | null;
  /**
   * The data of the business that owns the asset group.
   */
  owner?: BusinessAccessUserSummary | null;
  /**
   * The data of the user that created the asset group.
   */
  created_by?: BusinessAccessUserSummary | null;
};

/**
 * Asset group type
 */
export type AssetGroupType = 'BRAND' | 'LOCATION_OR_LANGUAGE' | 'PRODUCT_LINE' | 'OTHER';

/**
 * Asset Group Types. Note: The asset group types are used for user reference and categorization purposes only and do not impact the functionality of the asset group.
 */
export type AssetGroupTypes = Array<AssetGroupType>;

export type ItemAttributes = {
  /**
   * <p><= 2000 characters</p>
   * <p>The links to additional images for your product. Up to ten
   * additional images can be used to show a product from different angles
   * or to show different stages. Must begin with http:// or https://.</p>
   */
  additional_image_link?: Array<string> | null;
  /**
   * <p><= 2000 characters</p>
   * <p>The link to the main product images. Images should be at least
   * 75x75 pixels to aany errors. Use the additional_image_link field to add
   * more images of your product. The URL of your image_link must be accessible
   * by the Pinterest user-agent, and send the accurate images. Please make
   * sure there are no template or placeholder images at the link. Must start
   * with http:// or https://.</p>
   */
  image_link?: Array<string>;
  /**
   * <p><= 2,000 characters</p>
   * <p>Hosted link to the product video.</p>
   * <p>File types for linked videos must be .mp4, .mov or .m4v.</p>
   * <p>File size cannot exceed 2GB.</p>
   */
  video_link?: string | null;
} & UpdatableItemAttributes;

export type ItemAttributesRequest = {
  /**
   * <p><= 2000 characters</p>
   * <p>The links to additional images for your product. Up to ten
   * additional images can be used to show a product from different angles
   * or to show different stages. Must begin with http:// or https://.</p>
   */
  additional_image_link?: Array<string> | null;
  /**
   * <p><= 2000 characters</p>
   * <p>The links to the main product images. Images should be at least
   * 75x75 pixels to aany errors. Use the additional_image_link field to add
   * more images of your product. The URL of your image_link must be accessible
   * by the Pinterest user-agent, and send the accurate images. Please make
   * sure there are no template or placeholder images at the link. Must start
   * with http:// or https://.</p>
   */
  image_link?: Array<string> | string;
  /**
   * <p><= 2,000 characters</p>
   * <p>Hosted link to the product video.</p>
   * <p>File types for linked videos must be .mp4, .mov or .m4v.</p>
   * <p>File size cannot exceed 2GB.</p>
   */
  video_link?: string | null;
} & UpdatableItemAttributes;

/**
 * Object describing an item batch record
 */
export type ItemBatchRecord =
  | ItemCreateBatchRecord
  | ItemDeleteDiscontinuedBatchRecord
  | ItemUpdateBatchRecord
  | ItemUpsertBatchRecord
  | ItemDeleteBatchRecord;

/**
 * Object describing an item batch record to create items
 */
export type ItemCreateBatchRecord = {
  /**
   * The catalog item id in the merchant namespace
   */
  item_id?: string;
  attributes?: ItemAttributesRequest;
};

/**
 * Object describing an item batch record to delete items
 */
export type ItemDeleteBatchRecord = {
  /**
   * The catalog item id in the merchant namespace
   */
  item_id?: string;
};

/**
 * Object describing an item batch record to discontinue items
 */
export type ItemDeleteDiscontinuedBatchRecord = {
  /**
   * The catalog item id in the merchant namespace
   */
  item_id?: string;
};

export type ItemGroupIdFilter = {
  ITEM_GROUP_ID: CatalogsProductGroupMultipleStringCriteria;
};

export type ItemIdFilter = {
  ITEM_ID: CatalogsProductGroupMultipleStringCriteria;
};

/**
 * Object describing an item processing record
 */
export type ItemProcessingRecord = {
  /**
   * The catalog item id in the merchant namespace
   */
  item_id?: string;
  /**
   * Array with the validation errors for the item processing record.
   * A non empty errors list causes the item processing to fail.
   */
  errors?: Array<ItemValidationEvent>;
  /**
   * Array with the validation warnings for the item processing record
   */
  warnings?: Array<ItemValidationEvent>;
  status?: ItemProcessingStatus;
};

/**
 * The status of the item processing record
 */
export type ItemProcessingStatus = 'SUCCESS' | 'FAILURE' | 'PROCESSING';

/**
 * Object describing an item record
 */
export type ItemResponse =
  | ((CatalogsRetailItemResponse | CatalogsHotelItemResponse | CatalogsCreativeAssetsItemResponse) & {
      catalog_type: CatalogsType;
    })
  | ((CatalogsRetailItemErrorResponse | CatalogsHotelItemErrorResponse | CatalogsCreativeAssetsItemErrorResponse) & {
      catalog_type: CatalogsType;
    });

/**
 * Object describing an item batch record to update items
 */
export type ItemUpdateBatchRecord = {
  /**
   * The catalog item id in the merchant namespace
   */
  item_id?: string;
  attributes?: UpdatableItemAttributes;
  /**
   * The list of product attributes to be updated. Attributes specified in the update mask without a value specified in the body will be deleted from the product item.
   */
  update_mask?: Array<UpdateMaskFieldType> | null;
};

/**
 * Object describing an item batch record to upsert items
 */
export type ItemUpsertBatchRecord = {
  /**
   * The catalog item id in the merchant namespace
   */
  item_id?: string;
  attributes?: ItemAttributesRequest;
};

/**
 * Object describing an item validation event
 */
export type ItemValidationEvent = {
  /**
   * The attribute that the item validation event references
   */
  attribute?: string;
  /**
   * The event code that the item validation event references
   */
  code?: number;
  /**
   * Title message describing the item validation event
   */
  message?: string;
};

export type Keyword = KeywordsCommon & {
  archived?: boolean;
  /**
   * Keyword ID .
   */
  id?: string;
  /**
   * Keyword parent entity ID (advertiser, campaign, ad group).
   */
  parent_id?: string;
  /**
   * Parent entity type
   */
  parent_type?: string;
  /**
   * Always keyword
   */
  type?: string;
};

export type KeywordError = {
  data?: Keyword;
  error_messages?: Array<string>;
};

export type KeywordList = Array<string>;

/**
 * Keyword metrics JSON
 */
export type KeywordMetrics = {
  /**
   * Average cost per click
   */
  avg_cpc_in_micro_currency?: number;
  /**
   * Keyword's search frequency. This value is based on keyword frequency in pepsi client response
   */
  keyword_query_volume?: string;
};

export type KeywordMetricsResponse = {
  /**
   * Keyword name, e.g., "keyword":"fashion outfits"
   */
  keyword?: string;
  metrics?: KeywordMetrics;
};

export type KeywordUpdate = {
  /**
   * Keyword ID.
   */
  id: string;
  /**
   * Is keyword archived?
   */
  archived?: boolean;
  /**
   * </p><strong>Note:</strong> bid field has been deprecated. Input will not be set and field will return null. Keyword custom bid in microcurrency - null if inherited from parent ad group.
   */
  bid?: number | null;
};

export type KeywordUpdateBody = {
  /**
   * Keywords to update. Object array. Each object has 2 possible fields:<br>1. "id": (required) keyword ID<br>2. "archived": boolean. Should keyword be archived?<br>For example: [{"id":"2886610576653", "archived": false}, {"id":"2886610576654",  "archived": true}, ...]
   */
  keywords: Array<KeywordUpdate>;
};

export type KeywordsCommon = {
  /**
   * </p><strong>Note:</strong> bid field has been deprecated. Input will not be set and field will return null. Keyword custom bid in microcurrency - null if inherited from parent ad group.
   */
  bid?: number | null;
  match_type: MatchTypeResponse;
  /**
   * Keyword value (120 chars max).
   */
  value: string;
};

export type KeywordsMetricsArrayResponse = {
  data?: Array<KeywordMetricsResponse>;
};

export type KeywordsRequest = {
  /**
   * Keyword JSON array. Each array element has 3 fields
   */
  keywords: Array<KeywordsCommon>;
  /**
   * Keyword parent entity ID (advertiser, campaign, ad group).
   */
  parent_id: string;
};

export type KeywordsResponse = {
  errors?: Array<KeywordError>;
  keywords?: Array<Keyword>;
};

export type L1InterestList = Array<
  | 'animals'
  | 'architecture'
  | 'art'
  | 'beauty'
  | 'childrens_fashion'
  | 'design'
  | 'diy_and_crafts'
  | 'education'
  | 'electronics'
  | 'entertainment'
  | 'event_planning'
  | 'finance'
  | 'food_and_drinks'
  | 'gardening'
  | 'health'
  | 'home_decor'
  | 'mens_fashion'
  | 'parenting'
  | 'quotes'
  | 'sport'
  | 'travel'
  | 'vehicles'
  | 'wedding'
  | 'womens_fashion'
>;

/**
 * Language code, which is among the offical ISO 639-1 language list.
 */
export type Language =
  | 'AM'
  | 'AR'
  | 'AZ'
  | 'BG'
  | 'BN'
  | 'BS'
  | 'CA'
  | 'CS'
  | 'DA'
  | 'DV'
  | 'DZ'
  | 'DE'
  | 'EL'
  | 'EN'
  | 'ES'
  | 'ET'
  | 'FA'
  | 'FI'
  | 'FR'
  | 'HE'
  | 'HI'
  | 'HR'
  | 'HU'
  | 'HY'
  | 'ID'
  | 'IN'
  | 'IS'
  | 'IT'
  | 'IW'
  | 'JA'
  | 'KA'
  | 'KM'
  | 'KO'
  | 'LO'
  | 'LT'
  | 'LV'
  | 'MK'
  | 'MN'
  | 'MS'
  | 'MY'
  | 'NB'
  | 'NE'
  | 'NL'
  | 'NO'
  | 'PL'
  | 'PT'
  | 'RO'
  | 'RU'
  | 'SK'
  | 'SL'
  | 'SQ'
  | 'SR'
  | 'SV'
  | 'TL'
  | 'UK'
  | 'VI'
  | 'TE'
  | 'TH'
  | 'TR'
  | 'XX'
  | 'ZH';

/**
 * Creation fields
 */
export type LeadFormCommon = {
  /**
   * Internal name of the lead form.
   */
  name?: string | null;
  /**
   * A link to the advertiser's privacy policy. This will be included in the lead form's disclosure language.
   */
  privacy_policy_link?: string | null;
  /**
   * Whether the advertiser has accepted Pinterest's terms of service for creating a lead ad.
   *
   * By sending us TRUE for this parameter, you agree that (i) you will use any personal information received in
   * compliance with the privacy policy you share with Pinterest, and (ii) you will comply with Pinterest's <a href="https://policy.pinterest.com/en/lead-ad-terms">Lead Ad Terms</a>. As a reminder, all advertising on Pinterest is subject to the <a href="https://business.pinterest.com/en/pinterest-advertising-services-agreement/">Pinterest Advertising Services Agreement</a> or an equivalent agreement as set forth on an IO
   */
  has_accepted_terms?: boolean;
  /**
   * A message for people who complete the form to let them know what happens next.
   */
  completion_message?: string | null;
  status?: LeadFormStatus;
  /**
   * Additional disclosure language to be included in the lead form.
   */
  disclosure_language?: string | null;
  /**
   * List of questions to be displayed on the lead form.
   */
  questions?: Array<LeadFormQuestion>;
  /**
   * List of additional policy links to be displayed on the lead form.
   */
  policy_links?: Array<{
    /**
     * Policy label for an additional policy link.
     */
    label?: string;
    /**
     * Policy link for an additional policy link.
     */
    link?: string;
  }>;
};

export type LeadFormQuestion = {
  question_type?: LeadFormQuestionType;
  custom_question_field_type?: LeadFormQuestionFieldType;
  /**
   * Question label for a custom question.
   */
  custom_question_label?: string | null;
  /**
   * Question options for a custom question.
   */
  custom_question_options?: Array<string> | null;
};

/**
 * Lead form question field type
 */
export type LeadFormQuestionFieldType = 'TEXT_FIELD' | 'TEXT_AREA' | 'RADIO_LIST' | 'CHECKBOX';

/**
 * Lead form question type
 */
export type LeadFormQuestionType =
  | 'CUSTOM'
  | 'FULL_NAME'
  | 'FIRST_NAME'
  | 'LAST_NAME'
  | 'EMAIL'
  | 'PHONE_NUMBER'
  | 'ZIP_CODE'
  | 'GENDER'
  | 'CITY'
  | 'COUNTRY'
  | 'STATE_PROVINCE'
  | 'ADDRESS'
  | 'DATE_OF_BIRTH'
  | 'AGE';

/**
 * Request to create test data for lead data test API.
 */
export type LeadFormTestRequest = {
  /**
   * Test lead answers. Should follow the creation order.
   */
  answers: Array<string>;
};

/**
 * Response for lead data test API.
 */
export type LeadFormTestResponse = {
  /**
   * Subscription ID.
   */
  subscription_id?: string;
};

export type LeadFormResponse = LeadFormCommon & {
  /**
   * The ID of this lead form
   */
  id?: string;
  /**
   * The Ad Account ID that this lead form belongs to.
   */
  ad_account_id?: string;
  /**
   * Lead form creation time. Unix timestamp in seconds.
   */
  created_time?: number;
  /**
   * Last update time. Unix timestamp in seconds.
   */
  updated_time?: number;
};

/**
 * Status of the lead form
 */
export type LeadFormStatus = 'DRAFT' | 'ACTIVE';

export type LeadFormArrayResponse = {
  items?: Array<{
    data?: LeadFormResponse;
    exceptions?: Array<Exception>;
  }>;
};

export type LeadFormCreateRequest = LeadFormCommon & unknown;

export type LeadFormUpdateRequest = {
  [key: string]: unknown;
} & LeadFormCommon & {
    /**
     * The ID of this lead form to be updated
     */
    id: string;
  };

export type LeadsExportCreateRequest = {
  /**
   * Export leads collected on and after start date (UTC). Format: YYYY-MM-DD
   */
  start_date: string;
  /**
   * Export leads collected on and before end date (UTC). Format: YYYY-MM-DD
   */
  end_date: string;
  /**
   * ID for the ad collecting leads
   */
  ad_id: string;
};

export type LeadsExportCreateResponse = {
  /**
   * ID for the leads export job
   */
  leads_export_id?: string;
};

/**
 * Status of a leads export job
 */
export type LeadsExportStatus = 'IN_PROGRESS' | 'FINISHED' | 'FAILED';

export type LeadsExportResponseData = {
  export_status?: LeadsExportStatus;
  download_url?: string | null;
};

export type LinkedBusiness = {
  /**
   * Username
   */
  username?: string;
  /**
   * image_small_url
   */
  image_small_url?: string;
  /**
   * image_medium_url
   */
  image_medium_url?: string;
  /**
   * image_large_url
   */
  image_large_url?: string;
  /**
   * image_xlarge_url
   */
  image_xlarge_url?: string;
};

/**
 * The access level a member/partner has to the business. Values are case-sensitive.
 * <br> - EMPLOYEE: Can only view and access ad accounts you assign to them.
 * They cannot see details about other employees, external partners or other ad accounts.
 * <br> - BIZ_ADMIN: Have full control of roles and can add employees, external partners as well as grant ad account access.
 */
export type MemberBusinessRole = 'EMPLOYEE' | 'BIZ_ADMIN';

/**
 * Keyword match type
 */
export type MatchType = 'BROAD' | 'PHRASE' | 'EXACT' | 'EXACT_NEGATIVE' | 'PHRASE_NEGATIVE';

/**
 * Keyword match type
 */
export type MatchTypeResponse = 'BROAD' | 'PHRASE' | 'EXACT' | 'EXACT_NEGATIVE' | 'PHRASE_NEGATIVE';

export type MaxPriceFilter = {
  MAX_PRICE: CatalogsProductGroupPricingCriteria;
};

/**
 * Media upload that has been registered but not uploaded/processed yet.
 */
export type MediaUpload = {
  /**
   * Unique identifier for this media upload. Used to track status and for attaching during Pin creation.
   */
  media_id?: string;
  media_type?: MediaUploadType;
  /**
   * The URL where you will POST your media file.
   */
  upload_url?: string;
  /**
   * The list of parameter key/value pairs you will need to send with your POST request to upload your media file.
   */
  upload_parameters?: {
    'x-amz-date'?: string;
    'x-amz-signature'?: string;
    'x-amz-security-token'?: string;
    'x-amz-algorithm'?: string;
    key?: string;
    policy?: string;
    'x-amz-credential'?: string;
    'Content-Type'?: string;
  };
};

/**
 * Media upload details
 */
export type MediaUploadDetails = {
  readonly media_id?: string;
  readonly media_type?: MediaUploadType;
  readonly status?: MediaUploadStatus;
};

/**
 * Media upload request
 */
export type MediaUploadRequest = {
  media_type: MediaUploadType;
};

/**
 * Media upload status
 */
export type MediaUploadStatus = 'registered' | 'processing' | 'succeeded' | 'failed';

export type MediaUploadType = 'video';

export type MembersToDeleteBody = {
  members: Array<{
    /**
     * Unique identifier of the member
     */
    member_id: string;
    business_role: BusinessRoleForMembers;
  }>;
};

/**
 * The metric name and daily value for each requested metric
 */
export type Metrics = {
  [key: string]: number;
};

/**
 * Level of the reporting request
 */
export type MetricsReportingLevel =
  | 'ADVERTISER'
  | 'ADVERTISER_TARGETING'
  | 'CAMPAIGN'
  | 'CAMPAIGN_TARGETING'
  | 'AD_GROUP'
  | 'AD_GROUP_TARGETING'
  | 'PIN_PROMOTION'
  | 'PIN_PROMOTION_TARGETING'
  | 'KEYWORD'
  | 'PRODUCT_GROUP'
  | 'PRODUCT_GROUP_TARGETING'
  | 'PRODUCT_ITEM'
  | 'PRODUCT_ITEM_TARGETING';

export type MetricsResponse = {
  data?: Array<{
    [key: string]: unknown;
  }>;
};

export type PriceFilter = {
  PRICE: {
    operator: 'GREATER_THAN' | 'GREATER_THAN_OR_EQUALS' | 'LESS_THAN' | 'LESS_THAN_OR_EQUALS';
    value: number;
    currency: NonNullableCatalogsCurrency;
    negated?: boolean;
  };
};

export type operator = 'GREATER_THAN' | 'GREATER_THAN_OR_EQUALS' | 'LESS_THAN' | 'LESS_THAN_OR_EQUALS';

export type MinPriceFilter = {
  MIN_PRICE: CatalogsProductGroupPricingCriteria;
};

/**
 * Marketing Mix Modeling (MMM) Reporting Columns
 */
export type MMMReportingColumn =
  | 'SPEND_IN_DOLLAR'
  | 'SPEND_IN_MICRO_DOLLAR'
  | 'ECPC_IN_DOLLAR'
  | 'ECTR'
  | 'CAMPAIGN_NAME'
  | 'TOTAL_ENGAGEMENT'
  | 'EENGAGEMENT_RATE'
  | 'ECPM_IN_DOLLAR'
  | 'CAMPAIGN_ID'
  | 'ADVERTISER_ID'
  | 'AD_GROUP_ID'
  | 'AD_GROUP_NAME'
  | 'CLICKTHROUGH_1'
  | 'IMPRESSION_1'
  | 'CLICKTHROUGH_2'
  | 'IMPRESSION_2'
  | 'TOTAL_CLICKTHROUGH'
  | 'TOTAL_IMPRESSION'
  | 'ADVERTISER_NAME'
  | 'SPEND_ORDER_LINE_PAID_TYPE';

/**
 * Ad targeting types for MMM report
 */
export type MMMReportingTargetingType = 'APPTYPE' | 'COUNTRY' | 'CREATIVE_TYPE' | 'GENDER' | 'LOCATION';

/**
 * Currency Codes from ISO 4217.
 */
export type NonNullableCatalogsCurrency =
  | 'AED'
  | 'AFN'
  | 'ALL'
  | 'AMD'
  | 'ANG'
  | 'AOA'
  | 'ARS'
  | 'AUD'
  | 'AWG'
  | 'AZN'
  | 'BAM'
  | 'BBD'
  | 'BDT'
  | 'BGN'
  | 'BHD'
  | 'BIF'
  | 'BMD'
  | 'BND'
  | 'BOB'
  | 'BRL'
  | 'BSD'
  | 'BTN'
  | 'BWP'
  | 'BYN'
  | 'BYR'
  | 'BZD'
  | 'CAD'
  | 'CDF'
  | 'CHF'
  | 'CLP'
  | 'CNY'
  | 'COP'
  | 'CRC'
  | 'CUC'
  | 'CUP'
  | 'CVE'
  | 'CZK'
  | 'DJF'
  | 'DKK'
  | 'DOP'
  | 'DZD'
  | 'EGP'
  | 'ERN'
  | 'ETB'
  | 'EUR'
  | 'FJD'
  | 'FKP'
  | 'GBP'
  | 'GEL'
  | 'GGP'
  | 'GHS'
  | 'GIP'
  | 'GMD'
  | 'GNF'
  | 'GTQ'
  | 'GYD'
  | 'HKD'
  | 'HNL'
  | 'HRK'
  | 'HTG'
  | 'HUF'
  | 'IDR'
  | 'ILS'
  | 'IMP'
  | 'INR'
  | 'IQD'
  | 'IRR'
  | 'ISK'
  | 'JEP'
  | 'JMD'
  | 'JOD'
  | 'JPY'
  | 'KES'
  | 'KGS'
  | 'KHR'
  | 'KMF'
  | 'KPW'
  | 'KRW'
  | 'KWD'
  | 'KYD'
  | 'KZT'
  | 'LAK'
  | 'LBP'
  | 'LKR'
  | 'LRD'
  | 'LSL'
  | 'LYD'
  | 'MAD'
  | 'MDL'
  | 'MGA'
  | 'MKD'
  | 'MMK'
  | 'MNT'
  | 'MOP'
  | 'MRO'
  | 'MUR'
  | 'MVR'
  | 'MWK'
  | 'MXN'
  | 'MYR'
  | 'MZN'
  | 'NAD'
  | 'NGN'
  | 'NIO'
  | 'NOK'
  | 'NPR'
  | 'NZD'
  | 'OMR'
  | 'PAB'
  | 'PEN'
  | 'PGK'
  | 'PHP'
  | 'PKR'
  | 'PLN'
  | 'PYG'
  | 'QAR'
  | 'RON'
  | 'RSD'
  | 'RUB'
  | 'RWF'
  | 'SAR'
  | 'SBD'
  | 'SCR'
  | 'SDG'
  | 'SEK'
  | 'SGD'
  | 'SHP'
  | 'SLL'
  | 'SOS'
  | 'SPL'
  | 'SRD'
  | 'STD'
  | 'SVC'
  | 'SYP'
  | 'SZL'
  | 'THB'
  | 'TJS'
  | 'TMT'
  | 'TND'
  | 'TOP'
  | 'TRY'
  | 'TTD'
  | 'TVD'
  | 'TWD'
  | 'TZS'
  | 'UAH'
  | 'UGX'
  | 'USD'
  | 'UYU'
  | 'UZS'
  | 'VEF'
  | 'VND'
  | 'VUV'
  | 'WST'
  | 'XAF'
  | 'XCD'
  | 'XDR'
  | 'XOF'
  | 'XPF'
  | 'YER'
  | 'ZAR'
  | 'ZMW'
  | 'ZWD';

/**
 * Product availability.
 */
export type NonNullableProductAvailabilityType = 'IN_STOCK' | 'OUT_OF_STOCK' | 'PREORDER';

/**
 * Product item fields
 */
export type NullableCatalogsItemFieldType =
  | 'ITEM_ID'
  | 'ITEM_GROUP_ID'
  | 'TITLE'
  | 'DESCRIPTION'
  | 'ITEM_LINK'
  | 'ORGANIC_LINK'
  | 'IMAGE_LINK'
  | 'ADWORDS_REDIRECT_LINK'
  | 'AD_LINK'
  | 'SIZE'
  | 'GOOGLE_PRODUCT_CATEGORY'
  | 'PRODUCT_CATEGORY'
  | 'CONDITION'
  | 'AVAILABILITY'
  | 'GENDER'
  | 'AGE_GROUP'
  | 'SIZE_TYPE'
  | 'SIZE_SYSTEM'
  | 'ADULT'
  | 'SHIPPING'
  | 'SHIPPING_WEIGHT'
  | 'TAX'
  | 'MULTIPACK'
  | 'ADDITIONAL_IMAGE_LINK'
  | 'PRICE'
  | 'SALE_PRICE'
  | 'IS_BUNDLE'
  | 'EXPIRATION_DATE'
  | 'SALE_PRICE_EFFECTIVE_DATE'
  | 'AVAILABILITY_DATE'
  | 'WEIGHT_UNIT'
  | 'PRODUCT_TYPE'
  | 'CUSTOM_LABEL_0'
  | 'CUSTOM_LABEL_1'
  | 'CUSTOM_LABEL_2'
  | 'CUSTOM_LABEL_3'
  | 'CUSTOM_LABEL_4'
  | 'MATERIAL'
  | 'PATTERN'
  | 'COLOR'
  | 'BRAND'
  | 'GTIN'
  | 'MPN'
  | 'IOS_DEEP_LINK'
  | 'ANDROID_DEEP_LINK'
  | 'FREE_SHIPPING_LABEL'
  | 'FREE_SHIPPING_LIMIT'
  | 'AVG_REVIEW_RATING'
  | 'NUM_RATINGS'
  | 'NUM_REVIEWS'
  | 'ALT_TEXT'
  | 'VARIANT_NAMES'
  | 'VARIANT_VALUES'
  | 'MIN_AD_PRICE'
  | 'SHIPPING_WIDTH'
  | 'SHIPPING_HEIGHT';

/**
 * Currency Codes from ISO 4217.
 */
export type NullableCurrency =
  | 'AED'
  | 'AFN'
  | 'ALL'
  | 'AMD'
  | 'ANG'
  | 'AOA'
  | 'ARS'
  | 'AUD'
  | 'AWG'
  | 'AZN'
  | 'BAM'
  | 'BBD'
  | 'BDT'
  | 'BGN'
  | 'BHD'
  | 'BIF'
  | 'BMD'
  | 'BND'
  | 'BOB'
  | 'BRL'
  | 'BSD'
  | 'BTN'
  | 'BWP'
  | 'BYN'
  | 'BYR'
  | 'BZD'
  | 'CAD'
  | 'CDF'
  | 'CHF'
  | 'CLP'
  | 'CNY'
  | 'COP'
  | 'CRC'
  | 'CUC'
  | 'CUP'
  | 'CVE'
  | 'CZK'
  | 'DJF'
  | 'DKK'
  | 'DOP'
  | 'DZD'
  | 'EGP'
  | 'ERN'
  | 'ETB'
  | 'EUR'
  | 'FJD'
  | 'FKP'
  | 'GBP'
  | 'GEL'
  | 'GGP'
  | 'GHS'
  | 'GIP'
  | 'GMD'
  | 'GNF'
  | 'GTQ'
  | 'GYD'
  | 'HKD'
  | 'HNL'
  | 'HRK'
  | 'HTG'
  | 'HUF'
  | 'IDR'
  | 'ILS'
  | 'IMP'
  | 'INR'
  | 'IQD'
  | 'IRR'
  | 'ISK'
  | 'JEP'
  | 'JMD'
  | 'JOD'
  | 'JPY'
  | 'KES'
  | 'KGS'
  | 'KHR'
  | 'KMF'
  | 'KPW'
  | 'KRW'
  | 'KWD'
  | 'KYD'
  | 'KZT'
  | 'LAK'
  | 'LBP'
  | 'LKR'
  | 'LRD'
  | 'LSL'
  | 'LYD'
  | 'MAD'
  | 'MDL'
  | 'MGA'
  | 'MKD'
  | 'MMK'
  | 'MNT'
  | 'MOP'
  | 'MRO'
  | 'MUR'
  | 'MVR'
  | 'MWK'
  | 'MXN'
  | 'MYR'
  | 'MZN'
  | 'NAD'
  | 'NGN'
  | 'NIO'
  | 'NOK'
  | 'NPR'
  | 'NZD'
  | 'OMR'
  | 'PAB'
  | 'PEN'
  | 'PGK'
  | 'PHP'
  | 'PKR'
  | 'PLN'
  | 'PYG'
  | 'QAR'
  | 'RON'
  | 'RSD'
  | 'RUB'
  | 'RWF'
  | 'SAR'
  | 'SBD'
  | 'SCR'
  | 'SDG'
  | 'SEK'
  | 'SGD'
  | 'SHP'
  | 'SLL'
  | 'SOS'
  | 'SPL'
  | 'SRD'
  | 'STD'
  | 'SVC'
  | 'SYP'
  | 'SZL'
  | 'THB'
  | 'TJS'
  | 'TMT'
  | 'TND'
  | 'TOP'
  | 'TRY'
  | 'TTD'
  | 'TVD'
  | 'TWD'
  | 'TZS'
  | 'UAH'
  | 'UGX'
  | 'USD'
  | 'UYU'
  | 'UZS'
  | 'VEF'
  | 'VND'
  | 'VUV'
  | 'WST'
  | 'XAF'
  | 'XCD'
  | 'XDR'
  | 'XOF'
  | 'XPF'
  | 'YER'
  | 'ZAR'
  | 'ZMW'
  | 'ZWD';

/**
 * Describes the valid schema for possible OAuth access token requests.
 */
export type OauthAccessTokenRequest = {
  grant_type: 'authorization_code' | 'refresh_token' | 'client_credentials';
};

export type grant_type = 'authorization_code' | 'refresh_token' | 'client_credentials';

/**
 * A request to exchange an authorization code for an access token.
 */
export type OauthAccessTokenRequestCode = {
  code: string;
  redirect_uri: string;
} & {
  grant_type: 'authorization_code' | 'refresh_token' | 'client_credentials';
};

/**
 * A request to exchange a refresh token for a new access token.
 */
export type OauthAccessTokenRequestRefresh = {
  refresh_token: string;
  scope?: string;
  /**
   * Setting this field to <code>true</code> will add a new refresh token to your 200 response, as well as the refresh_token_expires_in and refresh_token_expires_at fields. To see the structure of this payload, set the 200 response_type to "everlasting_refresh".
   */
  refresh_on?: boolean;
} & {
  grant_type: 'authorization_code' | 'refresh_token' | 'client_credentials';
};

/**
 * A request to receive a client token.
 */
export type OauthAccessTokenRequestClientCredentials = {
  scope: string;
} & {
  grant_type: 'authorization_code' | 'refresh_token' | 'client_credentials';
};

/**
 * A successful OAuth access token response.
 */
export type OauthAccessTokenResponse = {
  response_type?: 'authorization_code' | 'refresh_token' | 'client_credentials';
  access_token: string;
  token_type: string;
  expires_in: number;
  scope: string;
};

export type response_type = 'authorization_code' | 'refresh_token' | 'client_credentials';

/**
 * A successful OAuth access token response for the authorization code flow.
 */
export type OauthAccessTokenResponseCode = {
  refresh_token: string;
  refresh_token_expires_in: number;
} & {
  response_type?: 'authorization_code' | 'refresh_token' | 'client_credentials';
  access_token: string;
  token_type: string;
  expires_in: number;
  scope: string;
};

/**
 * A successful OAuth access token response for the refresh token flow, with an added everlasting refresh token.
 */
export type OauthAccessTokenResponseEverlastingRefresh = {
  refresh_token: string;
  refresh_token_expires_in: number;
  refresh_token_expires_at: number;
} & {
  response_type?: 'authorization_code' | 'refresh_token' | 'client_credentials';
  access_token: string;
  token_type: string;
  expires_in: number;
  scope: string;
};

/**
 * A successful OAuth access token response for the refresh token flow, with an added refresh token.
 */
export type OauthAccessTokenResponseIntegrationRefresh = {
  refresh_token: string;
  refresh_token_expires_in: number;
} & {
  response_type?: 'authorization_code' | 'refresh_token' | 'client_credentials';
  access_token: string;
  token_type: string;
  expires_in: number;
  scope: string;
};

/**
 * A successful OAuth access token response for the refresh token flow.
 */
export type OauthAccessTokenResponseRefresh = {
  response_type?: 'authorization_code' | 'refresh_token' | 'client_credentials';
  access_token: string;
  token_type: string;
  expires_in: number;
  scope: string;
};

/**
 * A successful OAuth client token response for the client token flow.
 */
export type OauthAccessTokenResponseClientCredentials = {
  response_type?: 'authorization_code' | 'refresh_token' | 'client_credentials';
  access_token: string;
  token_type: string;
  expires_in: number;
  scope: string;
};

/**
 * Campaign objective type. If set as one of ["AWARENESS", "CONSIDERATION", "WEB_CONVERSION", "CATALOG_SALES", "VIDEO_COMPLETION"] the campaign is considered as a Campaign Budget Optimization (CBO) campaign, meaning budget needs to be set at the campaign level rather than at the ad group level. ["WEB_SESSIONS"] is DEPRECATED. For update, only draft campaigns may update objective type.
 */
export type ObjectiveType =
  | 'AWARENESS'
  | 'CONSIDERATION'
  | 'VIDEO_VIEW'
  | 'WEB_CONVERSION'
  | 'CATALOG_SALES'
  | 'WEB_SESSIONS'
  | 'VIDEO_COMPLETION';

export type OptimizationGoalMetadata = {
  conversion_tag_v3_goal_metadata?: {
    attribution_windows?: {
      click_window_days?: number;
      engagement_window_days?: number;
      view_window_days?: number;
    };
    conversion_event?:
      | 'PAGE_VISIT'
      | 'SIGNUP'
      | 'CHECKOUT'
      | 'CUSTOM'
      | 'VIEW_CATEGORY'
      | 'SEARCH'
      | 'ADD_TO_CART'
      | 'WATCH_VIDEO'
      | 'LEAD'
      | 'APP_INSTALL';
    conversion_tag_id?: string;
    cpa_goal_value_in_micro_currency?: string;
    /**
     * ROAS optimization is not supported
     */
    is_roas_optimized?: boolean | null;
    /**
     * Conversion learning model type
     */
    learning_mode_type?: ('NOT_ACTIVE' | 'ACTIVE') | null;
  };
  frequency_goal_metadata?: {
    frequency?: number;
    /**
     * User entity counts time range
     */
    timerange?: 'THIRTY_DAY' | 'DAY' | 'SEVEN_DAY' | 'TWENTY_MINUTE' | 'TEN_MINUTE' | 'TWENTY_FOUR_HOUR';
  };
  scrollup_goal_metadata?: {
    scrollup_goal_value_in_micro_currency?: string | null;
  };
};

export type conversion_event =
  | 'PAGE_VISIT'
  | 'SIGNUP'
  | 'CHECKOUT'
  | 'CUSTOM'
  | 'VIEW_CATEGORY'
  | 'SEARCH'
  | 'ADD_TO_CART'
  | 'WATCH_VIDEO'
  | 'LEAD'
  | 'APP_INSTALL';

/**
 * Conversion learning model type
 */
export type learning_mode_type = 'NOT_ACTIVE' | 'ACTIVE';

/**
 * User entity counts time range
 */
export type timerange = 'THIRTY_DAY' | 'DAY' | 'SEVEN_DAY' | 'TWENTY_MINUTE' | 'TEN_MINUTE' | 'TWENTY_FOUR_HOUR';

export type OrderLine = OrderLines & {
  /**
   * Associated List of campaign IDs.
   */
  campaign_ids: Array<string>;
};

export type OrderLineError = {
  data?: OrderLine;
  error_messages?: Array<string>;
};

/**
 * Order Line Paid Type
 */
export type OrderLinePaidType = 'PAID' | 'BONUS' | 'MAKE_GOOD' | 'TEST';

export type OrderLineResponse = {
  /**
   * Error list if update(s) fail.
   */
  errors?: Array<OrderLineError>;
  /**
   * Order Line object array.
   */
  order_line?: Array<OrderLine>;
};

export type OrderLineSingleResponse = {
  data?: OrderLineResponse;
};

/**
 * Order Line Status
 */
export type OrderLineStatus = 'ACTIVE' | 'PAUSED' | 'DELETED';

/**
 * Order Line
 */
export type OrderLines = {
  /**
   * Order line ID.
   */
  id?: string;
  /**
   * Always "orderline".
   */
  type?: string;
  /**
   * Ad account ID.
   */
  ad_account_id?: string;
  /**
   * Purchase order ID.
   */
  purchase_order_id?: string | null;
  /**
   * Start time. Unix timestamp.
   */
  start_time?: number;
  /**
   * End time. Unix timestamp.
   */
  end_time?: number | null;
  /**
   * Order line budget in micro currency.
   */
  budget?: number | null;
  /**
   * Order line paid budget in micro currency.
   */
  paid_budget?: number | null;
  /**
   * Order line status.
   */
  status?: OrderLineStatus;
  /**
   * Order line name.
   */
  name?: string | null;
  /**
   * Order line paid type.
   */
  paid_type?: OrderLinePaidType | null;
};

export type OrderLinesArrayResponse = {
  items?: Array<OrderLines>;
};

/**
 * Ad group pacing delivery type. With ACCELERATED, an ad group budget is spent as fast as possible. With STANDARD, an ad group budget is spent smoothly over a day. When using CBO, only the STANDARD pacing delivery type is allowed.
 */
export type PacingDeliveryType = 'STANDARD' | 'ACCELERATED';

export type Paginated = {
  items: Array<{
    [key: string]: unknown;
  }>;
  bookmark?: string | null;
};

export type Permissions =
  | 'ADMIN'
  | 'ANALYST'
  | 'FINANCE_MANAGER'
  | 'AUDIENCE_MANAGER'
  | 'CAMPAIGN_MANAGER'
  | 'CATALOGS_MANAGER'
  | 'PROFILE_PUBLISHER';

/**
 * Permission levels member or partner has on an asset.
 */
export type PermissionsResponse = Array<string>;

export type PermissionsWithOwner =
  | 'ADMIN'
  | 'ANALYST'
  | 'FINANCE_MANAGER'
  | 'AUDIENCE_MANAGER'
  | 'CAMPAIGN_MANAGER'
  | 'CATALOGS_MANAGER'
  | 'CATALOGS_VIEWER'
  | 'PROFILE_PUBLISHER'
  | 'OWNER';

/**
 * Pin
 */
export type Pin = {
  readonly id?: string;
  readonly created_at?: string;
  link?: string | null;
  title?: string | null;
  description?: string | null;
  /**
   * Dominant pin color. Hex number, e.g. \"#6E7874\".
   */
  dominant_color?: string | null;
  alt_text?: string | null;
  readonly creative_type?: CreativeType | null;
  /**
   * The board to which this Pin belongs.
   */
  board_id?: string;
  /**
   * The board section to which this Pin belongs.
   */
  board_section_id?: string | null;
  readonly board_owner?: BoardOwner;
  /**
   * Whether the "operation user_account" is the Pin owner.
   */
  readonly is_owner?: boolean;
  readonly media?: PinMedia;
  media_source?: PinMediaSource;
  /**
   * The source pin id if this pin was saved from another pin. <a href="https://help.pinterest.com/article/save-pins-on-pinterest">Learn more</a>.
   */
  parent_pin_id?: string | null;
  /**
   * Whether the Pin is standard or not. See documentation on <a href="/docs/api-features/content-overview/">Changes to Pin creation</a> for more information.
   */
  is_standard?: boolean;
  /**
   * Whether the Pin has been promoted or not.
   */
  readonly has_been_promoted?: boolean;
  /**
   * Private note for this Pin. <a href="https://help.pinterest.com/en/article/add-notes-to-your-pins">Learn more</a>.
   */
  note?: string | null;
  /**
   * Pin metrics with associated time intervals if any.
   */
  pin_metrics?: {
    [key: string]: unknown;
  } | null;
} | null;

export type PinAnalyticsMetricsResponse = {
  /**
   * The lifetime metric name and value.
   */
  lifetime_metrics?: {
    [key: string]: number;
  };
  /**
   * Array with the requested daily metric records
   */
  daily_metrics?: Array<{
    data_status?: DataStatus;
    /**
     * Metrics date (UTC): YYYY-MM-DD.
     */
    date?: string;
    /**
     * The metric name and daily value for each requested metric
     */
    metrics?: {
      [key: string]: number;
    };
  }>;
  /**
   * The metric name and value over the requested period for each requested metric
   */
  summary_metrics?: {
    [key: string]: number;
  };
};

export type PinAnalyticsResponse = {
  [key: string]: PinAnalyticsMetricsResponse;
};

export type BulkPinAnalyticsResponse = {
  [key: string]: PinAnalyticsResponse;
};

/**
 * Pin
 */
export type PinCreate = {
  readonly id?: string;
  readonly created_at?: string;
  link?: string | null;
  title?: string | null;
  description?: string | null;
  /**
   * Dominant pin color. Hex number, e.g. \"#6E7874\".
   */
  dominant_color?: string | null;
  alt_text?: string | null;
  /**
   * The board to which this Pin belongs.
   */
  board_id?: string;
  /**
   * The board section to which this Pin belongs.
   */
  board_section_id?: string | null;
  readonly board_owner?: BoardOwner;
  readonly media?: PinMedia;
  media_source?: PinMediaSource;
  /**
   * The source pin id if this pin was saved from another pin. <a href="https://help.pinterest.com/article/save-pins-on-pinterest">Learn more</a>.
   */
  parent_pin_id?: string | null;
  /**
   * Private note for this Pin. <a href="https://help.pinterest.com/en/article/add-notes-to-your-pins">Learn more</a>.
   */
  note?: string | null;
} | null;

/**
 * Pin media objects.
 */
export type PinMedia = {
  media_type?: string;
};

export type PinMediaMetadata = ImageMetadata | VideoMetadata;

/**
 * Pin media source.
 */
export type PinMediaSource =
  | PinMediaSourceImageBase64
  | PinMediaSourceImageURL
  | PinMediaSourceVideoID
  | PinMediaSourceImagesBase64
  | PinMediaSourceImagesURL
  | PinMediaSourcePinURL;

/**
 * Base64-encoded image media source
 */
export type PinMediaSourceImageBase64 = {
  source_type: 'image_base64';
  content_type: 'image/jpeg' | 'image/png';
  data: string;
  /**
   * Set the parameter to false to create the new simplified Pin instead of the standard pin. Currently the field is only available to a list of beta users.
   */
  is_standard?: boolean;
};

export type content_type = 'image/jpeg' | 'image/png';

/**
 * Image URL-based media source
 */
export type PinMediaSourceImageURL = {
  source_type: 'image_url';
  url: string;
  /**
   * Set the parameter to false to create the new simplified Pin instead of the standard pin. Currently the field is only available to a list of beta users.
   */
  is_standard?: boolean;
};

/**
 * Multiple Base64-encoded images media source
 */
export type PinMediaSourceImagesBase64 = {
  source_type?: 'multiple_image_base64';
  /**
   * Array with image objects.
   */
  items: Array<{
    title?: string;
    description?: string;
    /**
     * Destination link for the image.
     */
    link?: string;
    content_type: 'image/jpeg' | 'image/png';
    /**
     * Image to upload as base64 string.
     */
    data: string;
  }>;
  index?: number;
};

/**
 * Multiple images urls-based media source
 */
export type PinMediaSourceImagesURL = {
  source_type?: 'multiple_image_urls';
  /**
   * Array with image objects.
   */
  items: Array<{
    title?: string;
    description?: string;
    /**
     * Destination link for the image.
     */
    link?: string;
    /**
     * URL of image to upload.
     */
    url: string;
  }>;
  index?: number;
};

/**
 * Pin URL-based media source for product pin creation. Currently the field is only available to a list of beta users.
 */
export type PinMediaSourcePinURL = {
  source_type: 'pin_url';
  /**
   * This is an affiliate link or sponsored product. The FTC requires disclosure for paid partnerships and affiliate products.
   */
  is_affiliate_link?: boolean;
};

/**
 * Video ID-based media source
 */
export type PinMediaSourceVideoID = {
  source_type: 'video_id';
  /**
   * Cover image url.
   */
  cover_image_url?: string;
  /**
   * Content type for cover image Base64.
   */
  cover_image_content_type?: 'image/jpeg' | 'image/png';
  /**
   * Cover image Base64.
   */
  cover_image_data?: string;
  media_id: string;
  /**
   * Set the parameter to false to create the new simplified Pin instead of the standard pin. Currently the field is only available to a list of beta users.
   */
  is_standard?: boolean;
};

/**
 * Content type for cover image Base64.
 */
export type cover_image_content_type = 'image/jpeg' | 'image/png';

/**
 * Pin with image.
 */
export type PinMediaWithImage = {
  images?: {
    '150x150'?: ImageDetails;
    '400x300'?: ImageDetails;
    '600x'?: ImageDetails;
    '1200x'?: ImageDetails;
  };
} & PinMedia;

/**
 * Pin with a mix of images and videos.
 */
export type PinMediaWithImageAndVideo = {
  items?: Array<PinMediaMetadata>;
} & PinMedia;

/**
 * Pin with multiple images.
 */
export type PinMediaWithImages = {
  items?: Array<ImageMetadata>;
} & PinMedia;

/**
 * Pin with video.
 */
export type PinMediaWithVideo = {
  images?: {
    '150x150'?: ImageDetails;
    '400x300'?: ImageDetails;
    '600x'?: ImageDetails;
    '1200x'?: ImageDetails;
  };
  cover_image_url?: string;
  /**
   * Video url (720p). </p><strong>Note:</strong> This field is limited and not available to all apps.
   */
  video_url?: string | null;
  /**
   * Duration (in milliseconds)
   */
  duration?: number;
  /**
   * Height (in pixels)
   */
  height?: number;
  /**
   * Width (in pixels)
   */
  width?: number;
} & PinMedia;

/**
 * Pin with multiple videos.
 */
export type PinMediaWithVideos = {
  items?: Array<VideoMetadata>;
} & PinMedia;

/**
 * Summary status for pin promotions
 */
export type PinPromotionSummaryStatus =
  | 'APPROVED'
  | 'PAUSED'
  | 'PENDING'
  | 'REJECTED'
  | 'ADVERTISER_DISABLED'
  | 'ARCHIVED'
  | 'DRAFT'
  | 'DELETED_DRAFT';

/**
 * Pin fields for updates
 */
export type PinUpdate = {
  /**
   * Pin's alternative text.
   */
  alt_text?: string | null;
  /**
   * The id of the board to move the Pin onto.
   */
  board_id?: string | null;
  /**
   * <a href="https://help.pinterest.com/en/article/create-a-board-section">Board section</a> ID.
   */
  board_section_id?: string | null;
  /**
   * Pin description - 800 characters maximum.
   */
  description?: string | null;
  /**
   * URL viewer is taken to when they click pin.
   */
  link?: string | null;
  /**
   * The native pin title that creators explicitly prefer to display.
   */
  title?: string | null;
  /**
   * Carousel Pin slots data.
   */
  carousel_slots?: Array<{
    /**
     * Carousel Pin slot title.
     */
    title?: string;
    /**
     * Carousel Pin slot description.
     */
    description?: string;
    /**
     * Carousel Pin slot link.
     */
    link?: string;
  }>;
  /**
   * Private note for this Pin. <a href="https://help.pinterest.com/en/article/add-notes-to-your-pins">Learn more</a>.
   */
  note?: string | null;
} | null;

/**
 * Campaign placement group type
 */
export type PlacementGroupType = 'ALL' | 'SEARCH' | 'BROWSE' | 'OTHER';

/**
 * Default availability for products in a feed.
 */
export type ProductAvailabilityType = 'IN_STOCK' | 'OUT_OF_STOCK' | 'PREORDER';

export type ProductGroupAnalyticsResponse = Array<{
  /**
   * The ID of the product group that this metrics belongs to.
   */
  PRODUCT_GROUP_ID: string;
  /**
   * Current metrics date. Only returned when granularity is a time-based value (`DAY`, `HOUR`, `WEEK`, `MONTH`)
   */
  DATE?: string;
  [key: string]: unknown | string;
}>;

export type ProductGroupPromotion = {
  /**
   * ID of the product group promotion.
   */
  id?: string;
  /**
   * ID of the ad group the product group belongs to.
   */
  ad_group_id?: string;
  /**
   * The bid in micro currency.
   */
  bid_in_micro_currency?: number | null;
  /**
   * True if the group is BIDDABLE, false if it should be EXCLUDED from serving ads.
   */
  included?: boolean | null;
  /**
   * The full product group definition path
   */
  definition?: string | null;
  /**
   * The definition of the product group, relative to its parent - an attribute name/value pair
   */
  relative_definition?: string | null;
  /**
   * The parent Product Group ID of this Product Group
   */
  parent_id?: string | null;
  /**
   * Slideshow Collections Title
   */
  slideshow_collections_title?: string | null;
  /**
   * Slideshow Collections Description
   */
  slideshow_collections_description?: string | null;
  /**
   * If set to true products promoted in this product group will use the Mobile Deep Link specified in your catalog
   */
  is_mdl?: boolean | null;
  status?: EntityStatus;
  /**
   * Tracking template for proudct group promotions. 4000 limit
   */
  tracking_url?: string | null;
  /**
   * ID of the catalogs product group that this product group promotion references
   */
  catalog_product_group_id?: string | null;
  /**
   * Catalogs product group name
   */
  catalog_product_group_name?: string | null;
  /**
   * Hero Pin ID if this PG is promoted as a Collection
   */
  collections_hero_pin_id?: string | null;
  /**
   * Collections Hero Destination Url
   */
  collections_hero_destination_url?: string | null;
  grid_click_type?: GridClickType;
};

export type ProductGroupPromotionCreateRequest = {
  /**
   * ID of the Ad Group the Product Group Promotion belongs to.
   */
  ad_group_id: string;
  product_group_promotion: Array<ProductGroupPromotionCreateRequestElement>;
};

export type ProductGroupPromotionCreateRequestElement = ProductGroupPromotion & {
  creative_type?: CreativeType;
};

export type ProductGroupPromotionResponse = {
  items?: Array<ProductGroupPromotionResponseItem>;
};

export type ProductGroupPromotionResponseElement = ProductGroupPromotion & {
  creative_type?: CreativeType;
};

export type ProductGroupPromotionResponseItem = {
  data?: ProductGroupPromotionResponseElement;
  exceptions?: unknown;
};

export type ProductGroupPromotionUpdateRequest = {
  /**
   * ID of the ad group the product group belongs to.
   */
  ad_group_id: string;
  product_group_promotion: Array<ProductGroupPromotion>;
};

/**
 * Summary status for product group
 */
export type ProductGroupSummaryStatus = 'RUNNING' | 'PAUSED' | 'EXCLUDED' | 'ARCHIVED';

export type ProductType0Filter = {
  PRODUCT_TYPE_0: CatalogsProductGroupMultipleStringListCriteria;
};

export type ProductType1Filter = {
  PRODUCT_TYPE_1: CatalogsProductGroupMultipleStringListCriteria;
};

export type ProductType2Filter = {
  PRODUCT_TYPE_2: CatalogsProductGroupMultipleStringListCriteria;
};

export type ProductType3Filter = {
  PRODUCT_TYPE_3: CatalogsProductGroupMultipleStringListCriteria;
};

export type ProductType4Filter = {
  PRODUCT_TYPE_4: CatalogsProductGroupMultipleStringListCriteria;
};

/**
 * This field includes all quiz data including questions, options, and results.
 */
export type QuizPinData = {
  questions?: Array<QuizPinQuestion>;
  results?: Array<QuizPinResult>;
  /**
   * Quiz ad tie breaker type, default is RANDOM
   */
  tie_breaker_type?: 'RANDOM' | 'CUSTOM';
  tie_breaker_custom_result?: QuizPinResult;
} | null;

/**
 * Quiz ad tie breaker type, default is RANDOM
 */
export type tie_breaker_type = 'RANDOM' | 'CUSTOM';

/**
 *  This field contains multiple options to a quiz question.
 */
export type QuizPinOption = {
  id?: number;
  text?: string;
} | null;

/**
 * A specific quiz inquiry.
 */
export type QuizPinQuestion = {
  question_id?: number;
  question_text?: string;
  options?: Array<QuizPinOption>;
} | null;

/**
 * The result, and link out, based on the user’s choice.
 */
export type QuizPinResult = {
  organic_pin_id?: string;
  android_deep_link?: string;
  ios_deep_link?: string;
  destination_url?: string;
  result_id?: number;
} | null;

export type RelatedTerms = {
  /**
   * First input term. For example, if you pass "?terms=clothes,workout", then id will be "clothes"
   */
  id?: string;
  /**
   * Total number of related terms returned
   */
  related_term_count?: number;
  /**
   * The id of the advertiser.
   */
  related_terms_list?: Array<{
    term?: string;
    related_terms?: Array<string>;
  }>;
};

/**
 * Reporting columns
 */
export type ReportingColumnAsync =
  | 'SPEND_IN_MICRO_DOLLAR'
  | 'PAID_IMPRESSION'
  | 'SPEND_IN_DOLLAR'
  | 'CPC_IN_MICRO_DOLLAR'
  | 'ECPC_IN_MICRO_DOLLAR'
  | 'ECPC_IN_DOLLAR'
  | 'CTR'
  | 'ECTR'
  | 'OUTBOUND_CTR'
  | 'COST_PER_OUTBOUND_CLICK'
  | 'CAMPAIGN_NAME'
  | 'CAMPAIGN_STATUS'
  | 'PIN_PROMOTION_STATUS'
  | 'AD_STATUS'
  | 'PIN_ID'
  | 'TOTAL_ENGAGEMENT'
  | 'ENGAGEMENT_1'
  | 'ENGAGEMENT_2'
  | 'ECPE_IN_DOLLAR'
  | 'ENGAGEMENT_RATE'
  | 'EENGAGEMENT_RATE'
  | 'ECPM_IN_MICRO_DOLLAR'
  | 'REPIN_RATE'
  | 'CTR_2'
  | 'CAMPAIGN_ID'
  | 'ADVERTISER_ID'
  | 'AD_ACCOUNT_ID'
  | 'PIN_PROMOTION_ID'
  | 'AD_ID'
  | 'AD_GROUP_ID'
  | 'CAMPAIGN_ENTITY_STATUS'
  | 'CAMPAIGN_MANAGED_STATUS'
  | 'CAMPAIGN_OBJECTIVE_TYPE'
  | 'CPM_IN_MICRO_DOLLAR'
  | 'CPM_IN_DOLLAR'
  | 'AD_GROUP_NAME'
  | 'AD_GROUP_STATUS'
  | 'AD_GROUP_ENTITY_STATUS'
  | 'PRODUCT_GROUP_ID'
  | 'PRODUCT_GROUP_STATUS'
  | 'ORDER_LINE_ID'
  | 'ORDER_LINE_NAME'
  | 'CLICKTHROUGH_1'
  | 'REPIN_1'
  | 'IMPRESSION_1'
  | 'IMPRESSION_1_GROSS'
  | 'CLICKTHROUGH_1_GROSS'
  | 'OUTBOUND_CLICK_1'
  | 'CLICKTHROUGH_2'
  | 'REPIN_2'
  | 'IMPRESSION_2'
  | 'OUTBOUND_CLICK_2'
  | 'TOTAL_CLICKTHROUGH'
  | 'TOTAL_IMPRESSION'
  | 'TOTAL_IMPRESSION_USER'
  | 'TOTAL_IMPRESSION_FREQUENCY'
  | 'COST_PER_OUTBOUND_CLICK_IN_DOLLAR'
  | 'TOTAL_ENGAGEMENT_PAGE_VISIT'
  | 'TOTAL_ENGAGEMENT_SIGNUP'
  | 'TOTAL_ENGAGEMENT_CHECKOUT'
  | 'TOTAL_ENGAGEMENT_CUSTOM'
  | 'TOTAL_ENGAGEMENT_ADD_TO_CART'
  | 'TOTAL_ENGAGEMENT_LEAD'
  | 'TOTAL_ENGAGEMENT_SEARCH'
  | 'TOTAL_ENGAGEMENT_WATCH_VIDEO'
  | 'TOTAL_ENGAGEMENT_VIEW_CATEGORY'
  | 'TOTAL_ENGAGEMENT_APP_INSTALL'
  | 'TOTAL_ENGAGEMENT_UNKNOWN'
  | 'TOTAL_CLICK_PAGE_VISIT'
  | 'TOTAL_CLICK_SIGNUP'
  | 'TOTAL_CLICK_CHECKOUT'
  | 'TOTAL_CLICK_CUSTOM'
  | 'TOTAL_CLICK_ADD_TO_CART'
  | 'TOTAL_CLICK_LEAD'
  | 'TOTAL_CLICK_SEARCH'
  | 'TOTAL_CLICK_WATCH_VIDEO'
  | 'TOTAL_CLICK_VIEW_CATEGORY'
  | 'TOTAL_CLICK_APP_INSTALL'
  | 'TOTAL_CLICK_UNKNOWN'
  | 'TOTAL_VIEW_PAGE_VISIT'
  | 'TOTAL_VIEW_SIGNUP'
  | 'TOTAL_VIEW_CHECKOUT'
  | 'TOTAL_VIEW_CUSTOM'
  | 'TOTAL_VIEW_ADD_TO_CART'
  | 'TOTAL_VIEW_LEAD'
  | 'TOTAL_VIEW_SEARCH'
  | 'TOTAL_VIEW_WATCH_VIDEO'
  | 'TOTAL_VIEW_VIEW_CATEGORY'
  | 'TOTAL_VIEW_APP_INSTALL'
  | 'TOTAL_VIEW_UNKNOWN'
  | 'TOTAL_CONVERSIONS'
  | 'TOTAL_ENGAGEMENT_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_ENGAGEMENT_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_ENGAGEMENT_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CLICK_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CLICK_LEAD_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CLICK_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CLICK_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CLICK_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_VIEW_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_VIEW_LEAD_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_VIEW_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_VIEW_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_VIEW_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CONVERSIONS_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_ENGAGEMENT_PAGE_VISIT_QUANTITY'
  | 'TOTAL_ENGAGEMENT_SIGNUP_QUANTITY'
  | 'TOTAL_ENGAGEMENT_CHECKOUT_QUANTITY'
  | 'TOTAL_ENGAGEMENT_CUSTOM_QUANTITY'
  | 'TOTAL_ENGAGEMENT_ADD_TO_CART_QUANTITY'
  | 'TOTAL_ENGAGEMENT_LEAD_QUANTITY'
  | 'TOTAL_ENGAGEMENT_SEARCH_QUANTITY'
  | 'TOTAL_ENGAGEMENT_WATCH_VIDEO_QUANTITY'
  | 'TOTAL_ENGAGEMENT_VIEW_CATEGORY_QUANTITY'
  | 'TOTAL_ENGAGEMENT_UNKNOWN_QUANTITY'
  | 'TOTAL_CLICK_PAGE_VISIT_QUANTITY'
  | 'TOTAL_CLICK_SIGNUP_QUANTITY'
  | 'TOTAL_CLICK_CHECKOUT_QUANTITY'
  | 'TOTAL_CLICK_CUSTOM_QUANTITY'
  | 'TOTAL_CLICK_ADD_TO_CART_QUANTITY'
  | 'TOTAL_CLICK_LEAD_QUANTITY'
  | 'TOTAL_CLICK_SEARCH_QUANTITY'
  | 'TOTAL_CLICK_WATCH_VIDEO_QUANTITY'
  | 'TOTAL_CLICK_VIEW_CATEGORY_QUANTITY'
  | 'TOTAL_CLICK_UNKNOWN_QUANTITY'
  | 'TOTAL_VIEW_PAGE_VISIT_QUANTITY'
  | 'TOTAL_VIEW_SIGNUP_QUANTITY'
  | 'TOTAL_VIEW_CHECKOUT_QUANTITY'
  | 'TOTAL_VIEW_CUSTOM_QUANTITY'
  | 'TOTAL_VIEW_ADD_TO_CART_QUANTITY'
  | 'TOTAL_VIEW_LEAD_QUANTITY'
  | 'TOTAL_VIEW_SEARCH_QUANTITY'
  | 'TOTAL_VIEW_WATCH_VIDEO_QUANTITY'
  | 'TOTAL_VIEW_VIEW_CATEGORY_QUANTITY'
  | 'TOTAL_VIEW_UNKNOWN_QUANTITY'
  | 'TOTAL_CONVERSIONS_QUANTITY'
  | 'TOTAL_WEB_SESSIONS'
  | 'WEB_SESSIONS_1'
  | 'WEB_SESSIONS_2'
  | 'ONSITE_CHECKOUTS_1'
  | 'PIN_PROMOTION_NAME'
  | 'AD_NAME'
  | 'CAMPAIGN_LIFETIME_SPEND_CAP'
  | 'CAMPAIGN_DAILY_SPEND_CAP'
  | 'TOTAL_PAGE_VISIT_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_PAGE_VISIT_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_PAGE_VISIT_DESKTOP_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_PAGE_VISIT_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_PAGE_VISIT_MOBILE_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_PAGE_VISIT_MOBILE_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_PAGE_VISIT_TABLET_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_PAGE_VISIT_TABLET_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_PAGE_VISIT_TABLET_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_SIGNUP_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_SIGNUP_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_SIGNUP_DESKTOP_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_SIGNUP_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_SIGNUP_MOBILE_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_SIGNUP_MOBILE_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_SIGNUP_TABLET_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_SIGNUP_TABLET_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_SIGNUP_TABLET_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_CHECKOUT_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_CHECKOUT_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_CHECKOUT_DESKTOP_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_CHECKOUT_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_CHECKOUT_MOBILE_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_CHECKOUT_MOBILE_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_CHECKOUT_TABLET_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_CHECKOUT_TABLET_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_CHECKOUT_TABLET_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_CUSTOM_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_CUSTOM_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_CUSTOM_DESKTOP_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_CUSTOM_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_CUSTOM_MOBILE_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_CUSTOM_MOBILE_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_CUSTOM_TABLET_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_CUSTOM_TABLET_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_CUSTOM_TABLET_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_ADD_TO_CART_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_ADD_TO_CART_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_ADD_TO_CART_DESKTOP_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_ADD_TO_CART_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_ADD_TO_CART_MOBILE_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_ADD_TO_CART_MOBILE_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_ADD_TO_CART_TABLET_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_ADD_TO_CART_TABLET_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_ADD_TO_CART_TABLET_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_LEAD_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_LEAD_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_LEAD_DESKTOP_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_LEAD_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_LEAD_MOBILE_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_LEAD_MOBILE_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_LEAD_TABLET_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_LEAD_TABLET_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_LEAD_TABLET_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_SEARCH_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_SEARCH_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_SEARCH_DESKTOP_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_SEARCH_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_SEARCH_MOBILE_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_SEARCH_MOBILE_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_SEARCH_TABLET_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_SEARCH_TABLET_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_SEARCH_TABLET_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_WATCH_VIDEO_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_WATCH_VIDEO_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_WATCH_VIDEO_DESKTOP_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_WATCH_VIDEO_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_WATCH_VIDEO_MOBILE_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_WATCH_VIDEO_MOBILE_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_WATCH_VIDEO_TABLET_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_WATCH_VIDEO_TABLET_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_WATCH_VIDEO_TABLET_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_VIEW_CATEGORY_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_VIEW_CATEGORY_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_VIEW_CATEGORY_DESKTOP_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_VIEW_CATEGORY_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_VIEW_CATEGORY_MOBILE_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_VIEW_CATEGORY_MOBILE_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_VIEW_CATEGORY_TABLET_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_VIEW_CATEGORY_TABLET_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_VIEW_CATEGORY_TABLET_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_APP_INSTALL_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_APP_INSTALL_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_APP_INSTALL_DESKTOP_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_APP_INSTALL_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_APP_INSTALL_MOBILE_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_APP_INSTALL_MOBILE_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_APP_INSTALL_TABLET_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_APP_INSTALL_TABLET_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_APP_INSTALL_TABLET_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_UNKNOWN_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_UNKNOWN_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_UNKNOWN_DESKTOP_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_UNKNOWN_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_UNKNOWN_MOBILE_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_UNKNOWN_MOBILE_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_UNKNOWN_TABLET_ACTION_TO_DESKTOP_CONVERSION'
  | 'TOTAL_UNKNOWN_TABLET_ACTION_TO_MOBILE_CONVERSION'
  | 'TOTAL_UNKNOWN_TABLET_ACTION_TO_TABLET_CONVERSION'
  | 'TOTAL_PAGE_VISIT'
  | 'TOTAL_SIGNUP'
  | 'TOTAL_CHECKOUT'
  | 'TOTAL_CUSTOM'
  | 'TOTAL_ADD_TO_CART'
  | 'TOTAL_LEAD'
  | 'TOTAL_SEARCH'
  | 'TOTAL_WATCH_VIDEO'
  | 'TOTAL_VIEW_CATEGORY'
  | 'TOTAL_APP_INSTALL'
  | 'TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_LEAD_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_SEARCH_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CHECKOUT_QUANTITY'
  | 'PAGE_VISIT_COST_PER_ACTION'
  | 'APP_INSTALL_COST_PER_ACTION'
  | 'PAGE_VISIT_ROAS'
  | 'CHECKOUT_ROAS'
  | 'CUSTOM_ROAS'
  | 'VIDEO_3SEC_VIEWS_1'
  | 'VIDEO_P100_COMPLETE_1'
  | 'VIDEO_P0_COMBINED_1'
  | 'VIDEO_P25_COMBINED_1'
  | 'VIDEO_P50_COMBINED_1'
  | 'VIDEO_P75_COMBINED_1'
  | 'VIDEO_P95_COMBINED_1'
  | 'VIDEO_MRC_VIEWS_1'
  | 'VIDEO_3SEC_VIEWS_2'
  | 'VIDEO_P100_COMPLETE_2'
  | 'VIDEO_P0_COMBINED_2'
  | 'VIDEO_P25_COMBINED_2'
  | 'VIDEO_P50_COMBINED_2'
  | 'VIDEO_P75_COMBINED_2'
  | 'VIDEO_P95_COMBINED_2'
  | 'VIDEO_MRC_VIEWS_2'
  | 'PAID_VIDEO_VIEWABLE_RATE'
  | 'VIDEO_LENGTH'
  | 'CPV_IN_MICRO_DOLLAR'
  | 'ECPV_IN_DOLLAR'
  | 'CPCV_IN_MICRO_DOLLAR'
  | 'ECPCV_IN_DOLLAR'
  | 'CPCV_P95_IN_MICRO_DOLLAR'
  | 'ECPCV_P95_IN_DOLLAR'
  | 'TOTAL_VIDEO_3SEC_VIEWS'
  | 'TOTAL_VIDEO_P100_COMPLETE'
  | 'TOTAL_VIDEO_P0_COMBINED'
  | 'TOTAL_VIDEO_P25_COMBINED'
  | 'TOTAL_VIDEO_P50_COMBINED'
  | 'TOTAL_VIDEO_P75_COMBINED'
  | 'TOTAL_VIDEO_P95_COMBINED'
  | 'TOTAL_VIDEO_MRC_VIEWS'
  | 'VIDEO_AVG_WATCHTIME_IN_SECOND_1'
  | 'VIDEO_AVG_WATCHTIME_IN_SECOND_2'
  | 'TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'
  | 'TOTAL_DESTINATION_VIEWS'
  | 'TOTAL_REPIN_RATE'
  | 'WEB_CHECKOUT_COST_PER_ACTION'
  | 'WEB_CHECKOUT_ROAS'
  | 'TOTAL_WEB_CHECKOUT'
  | 'TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_CLICK_CHECKOUT'
  | 'TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT'
  | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_VIEW_CHECKOUT'
  | 'TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'INAPP_CHECKOUT_COST_PER_ACTION'
  | 'INAPP_CHECKOUT_ROAS'
  | 'TOTAL_INAPP_CHECKOUT'
  | 'TOTAL_INAPP_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_INAPP_CLICK_CHECKOUT'
  | 'TOTAL_INAPP_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_INAPP_ENGAGEMENT_CHECKOUT'
  | 'TOTAL_INAPP_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_INAPP_VIEW_CHECKOUT'
  | 'TOTAL_INAPP_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'OFFLINE_CHECKOUT_COST_PER_ACTION'
  | 'OFFLINE_CHECKOUT_ROAS'
  | 'TOTAL_OFFLINE_CHECKOUT'
  | 'TOTAL_OFFLINE_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_OFFLINE_CLICK_CHECKOUT'
  | 'TOTAL_OFFLINE_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_OFFLINE_ENGAGEMENT_CHECKOUT'
  | 'TOTAL_OFFLINE_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_OFFLINE_VIEW_CHECKOUT'
  | 'TOTAL_OFFLINE_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'PINTEREST_CHECKOUT_COST_PER_ACTION'
  | 'PINTEREST_CHECKOUT_ROAS'
  | 'TOTAL_PINTEREST_CHECKOUT'
  | 'TOTAL_PINTEREST_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'WEB_ADD_TO_CART_COST_PER_ACTION'
  | 'WEB_ADD_TO_CART_ROAS'
  | 'TOTAL_WEB_ADD_TO_CART'
  | 'TOTAL_WEB_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_CLICK_ADD_TO_CART'
  | 'TOTAL_WEB_CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_ENGAGEMENT_ADD_TO_CART'
  | 'TOTAL_WEB_ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_VIEW_ADD_TO_CART'
  | 'TOTAL_WEB_VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
  | 'INAPP_ADD_TO_CART_COST_PER_ACTION'
  | 'INAPP_ADD_TO_CART_ROAS'
  | 'TOTAL_INAPP_ADD_TO_CART'
  | 'TOTAL_INAPP_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_INAPP_CLICK_ADD_TO_CART'
  | 'TOTAL_INAPP_CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_INAPP_ENGAGEMENT_ADD_TO_CART'
  | 'TOTAL_INAPP_ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_INAPP_VIEW_ADD_TO_CART'
  | 'TOTAL_INAPP_VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
  | 'WEB_PAGE_VISIT_COST_PER_ACTION'
  | 'WEB_PAGE_VISIT_ROAS'
  | 'TOTAL_WEB_PAGE_VISIT'
  | 'TOTAL_WEB_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_CLICK_PAGE_VISIT'
  | 'TOTAL_WEB_CLICK_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_ENGAGEMENT_PAGE_VISIT'
  | 'TOTAL_WEB_ENGAGEMENT_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_VIEW_PAGE_VISIT'
  | 'TOTAL_WEB_VIEW_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'
  | 'WEB_SIGNUP_COST_PER_ACTION'
  | 'WEB_SIGNUP_ROAS'
  | 'TOTAL_WEB_SIGNUP'
  | 'TOTAL_WEB_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_CLICK_SIGNUP'
  | 'TOTAL_WEB_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_ENGAGEMENT_SIGNUP'
  | 'TOTAL_WEB_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_VIEW_SIGNUP'
  | 'TOTAL_WEB_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'INAPP_SIGNUP_COST_PER_ACTION'
  | 'INAPP_SIGNUP_ROAS'
  | 'TOTAL_INAPP_SIGNUP'
  | 'TOTAL_INAPP_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_INAPP_CLICK_SIGNUP'
  | 'TOTAL_INAPP_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_INAPP_ENGAGEMENT_SIGNUP'
  | 'TOTAL_INAPP_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_INAPP_VIEW_SIGNUP'
  | 'TOTAL_INAPP_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'OFFLINE_SIGNUP_COST_PER_ACTION'
  | 'OFFLINE_SIGNUP_ROAS'
  | 'TOTAL_OFFLINE_SIGNUP'
  | 'TOTAL_OFFLINE_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_OFFLINE_CLICK_SIGNUP'
  | 'TOTAL_OFFLINE_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_OFFLINE_ENGAGEMENT_SIGNUP'
  | 'TOTAL_OFFLINE_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_OFFLINE_VIEW_SIGNUP'
  | 'TOTAL_OFFLINE_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'WEB_WATCH_VIDEO_COST_PER_ACTION'
  | 'WEB_WATCH_VIDEO_ROAS'
  | 'TOTAL_WEB_WATCH_VIDEO'
  | 'TOTAL_WEB_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_CLICK_WATCH_VIDEO'
  | 'TOTAL_WEB_CLICK_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_ENGAGEMENT_WATCH_VIDEO'
  | 'TOTAL_WEB_ENGAGEMENT_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_VIEW_WATCH_VIDEO'
  | 'TOTAL_WEB_VIEW_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'
  | 'WEB_LEAD_COST_PER_ACTION'
  | 'WEB_LEAD_ROAS'
  | 'TOTAL_WEB_LEAD'
  | 'TOTAL_WEB_LEAD_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_CLICK_LEAD'
  | 'TOTAL_WEB_CLICK_LEAD_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_ENGAGEMENT_LEAD'
  | 'TOTAL_WEB_ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_VIEW_LEAD'
  | 'TOTAL_WEB_VIEW_LEAD_VALUE_IN_MICRO_DOLLAR'
  | 'OFFLINE_LEAD_COST_PER_ACTION'
  | 'OFFLINE_LEAD_ROAS'
  | 'TOTAL_OFFLINE_LEAD'
  | 'TOTAL_OFFLINE_LEAD_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_OFFLINE_CLICK_LEAD'
  | 'TOTAL_OFFLINE_CLICK_LEAD_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_OFFLINE_ENGAGEMENT_LEAD'
  | 'TOTAL_OFFLINE_ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_OFFLINE_VIEW_LEAD'
  | 'TOTAL_OFFLINE_VIEW_LEAD_VALUE_IN_MICRO_DOLLAR'
  | 'WEB_SEARCH_COST_PER_ACTION'
  | 'WEB_SEARCH_ROAS'
  | 'TOTAL_WEB_SEARCH'
  | 'TOTAL_WEB_SEARCH_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_CLICK_SEARCH'
  | 'TOTAL_WEB_CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_ENGAGEMENT_SEARCH'
  | 'TOTAL_WEB_ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_VIEW_SEARCH'
  | 'TOTAL_WEB_VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR'
  | 'INAPP_SEARCH_COST_PER_ACTION'
  | 'INAPP_SEARCH_ROAS'
  | 'TOTAL_INAPP_SEARCH'
  | 'TOTAL_INAPP_SEARCH_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_INAPP_CLICK_SEARCH'
  | 'TOTAL_INAPP_CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_INAPP_ENGAGEMENT_SEARCH'
  | 'TOTAL_INAPP_ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_INAPP_VIEW_SEARCH'
  | 'TOTAL_INAPP_VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR'
  | 'WEB_VIEW_CATEGORY_COST_PER_ACTION'
  | 'WEB_VIEW_CATEGORY_ROAS'
  | 'TOTAL_WEB_VIEW_CATEGORY'
  | 'TOTAL_WEB_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_CLICK_VIEW_CATEGORY'
  | 'TOTAL_WEB_CLICK_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_ENGAGEMENT_VIEW_CATEGORY'
  | 'TOTAL_WEB_ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_VIEW_VIEW_CATEGORY'
  | 'TOTAL_WEB_VIEW_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'
  | 'WEB_CUSTOM_COST_PER_ACTION'
  | 'WEB_CUSTOM_ROAS'
  | 'TOTAL_WEB_CUSTOM'
  | 'TOTAL_WEB_CUSTOM_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_CLICK_CUSTOM'
  | 'TOTAL_WEB_CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_ENGAGEMENT_CUSTOM'
  | 'TOTAL_WEB_ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_VIEW_CUSTOM'
  | 'TOTAL_WEB_VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR'
  | 'OFFLINE_CUSTOM_COST_PER_ACTION'
  | 'OFFLINE_CUSTOM_ROAS'
  | 'TOTAL_OFFLINE_CUSTOM'
  | 'TOTAL_OFFLINE_CUSTOM_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_OFFLINE_CLICK_CUSTOM'
  | 'TOTAL_OFFLINE_CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_OFFLINE_ENGAGEMENT_CUSTOM'
  | 'TOTAL_OFFLINE_ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_OFFLINE_VIEW_CUSTOM'
  | 'TOTAL_OFFLINE_VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR'
  | 'WEB_UNKNOWN_COST_PER_ACTION'
  | 'WEB_UNKNOWN_ROAS'
  | 'TOTAL_WEB_UNKNOWN'
  | 'TOTAL_WEB_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_CLICK_UNKNOWN'
  | 'TOTAL_WEB_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_ENGAGEMENT_UNKNOWN'
  | 'TOTAL_WEB_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_VIEW_UNKNOWN'
  | 'TOTAL_WEB_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
  | 'INAPP_UNKNOWN_COST_PER_ACTION'
  | 'INAPP_UNKNOWN_ROAS'
  | 'TOTAL_INAPP_UNKNOWN'
  | 'TOTAL_INAPP_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_INAPP_CLICK_UNKNOWN'
  | 'TOTAL_INAPP_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_INAPP_ENGAGEMENT_UNKNOWN'
  | 'TOTAL_INAPP_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_INAPP_VIEW_UNKNOWN'
  | 'TOTAL_INAPP_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
  | 'OFFLINE_UNKNOWN_COST_PER_ACTION'
  | 'OFFLINE_UNKNOWN_ROAS'
  | 'TOTAL_OFFLINE_UNKNOWN'
  | 'TOTAL_OFFLINE_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_OFFLINE_CLICK_UNKNOWN'
  | 'TOTAL_OFFLINE_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_OFFLINE_ENGAGEMENT_UNKNOWN'
  | 'TOTAL_OFFLINE_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_OFFLINE_VIEW_UNKNOWN'
  | 'TOTAL_OFFLINE_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
  | 'INAPP_APP_INSTALL_COST_PER_ACTION'
  | 'INAPP_APP_INSTALL_ROAS'
  | 'TOTAL_INAPP_APP_INSTALL'
  | 'TOTAL_INAPP_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_INAPP_CLICK_APP_INSTALL'
  | 'TOTAL_INAPP_CLICK_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_INAPP_ENGAGEMENT_APP_INSTALL'
  | 'TOTAL_INAPP_ENGAGEMENT_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_INAPP_VIEW_APP_INSTALL'
  | 'TOTAL_INAPP_VIEW_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'
  | 'IDEA_PIN_PRODUCT_TAG_VISIT_1'
  | 'IDEA_PIN_PRODUCT_TAG_VISIT_2'
  | 'TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'
  | 'LEADS'
  | 'COST_PER_LEAD'
  | 'QUIZ_COMPLETED'
  | 'QUIZ_COMPLETION_RATE'
  | 'SHOWCASE_PIN_CLICKTHROUGH'
  | 'SHOWCASE_SUBPAGE_CLICKTHROUGH'
  | 'SHOWCASE_SUBPIN_CLICKTHROUGH'
  | 'SHOWCASE_SUBPAGE_IMPRESSION'
  | 'SHOWCASE_SUBPIN_IMPRESSION'
  | 'SHOWCASE_SUBPAGE_SWIPE_LEFT'
  | 'SHOWCASE_SUBPAGE_SWIPE_RIGHT'
  | 'SHOWCASE_SUBPIN_SWIPE_LEFT'
  | 'SHOWCASE_SUBPIN_SWIPE_RIGHT'
  | 'SHOWCASE_SUBPAGE_REPIN'
  | 'SHOWCASE_SUBPIN_REPIN'
  | 'SHOWCASE_SUBPAGE_CLOSEUP'
  | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'
  | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'
  | 'SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'
  | 'TOTAL_CHECKOUT_CONVERSION_RATE'
  | 'TOTAL_VIEW_CATEGORY_CONVERSION_RATE'
  | 'TOTAL_ADD_TO_CART_CONVERSION_RATE'
  | 'TOTAL_SIGNUP_CONVERSION_RATE'
  | 'TOTAL_PAGE_VISIT_CONVERSION_RATE'
  | 'TOTAL_LEAD_CONVERSION_RATE'
  | 'TOTAL_SEARCH_CONVERSION_RATE'
  | 'TOTAL_WATCH_VIDEO_CONVERSION_RATE'
  | 'TOTAL_UNKNOWN_CONVERSION_RATE'
  | 'TOTAL_CUSTOM_CONVERSION_RATE'
  | 'STANDARD_AD_FEED_ITEM_ID';

/**
 * A string representing a json object mapping a resource id to a list of business roles.
 *
 */
export type ResourceIdToRoles = string;

export type RespondToInvitesResponseArray = {
  /**
   * List of invite/request accept/decline status. If there is an error, an exception object will be returned. If the invite/request was successfully accepted/declined, an invite object will be returned.
   */
  items?: Array<{
    exception?: InviteExceptionResponse;
    /**
     * An invite object for the invite/request that was successfully accepted/declined. Will only be provided if the an invite/request is successfully created.
     */
    invite?: BaseInviteDataResponse;
  }>;
};

/**
 * An internal role type used on business access, EMPLOYEE, ADMIN.
 */
export type Role =
  | 'UNKNOWN'
  | 'OWNER'
  | 'ADMIN'
  | 'ANALYST'
  | 'SOS_READER'
  | 'FINANCE_MANAGER'
  | 'AUDIENCE_MANAGER'
  | 'CAMPAIGN_MANAGER'
  | 'CATALOGS_MANAGER'
  | 'RESTRICTED_OWNER'
  | 'PROFILE_MANAGER'
  | 'PROFILE_PUBLISHER'
  | 'RESOURCE_PINNER_LIST_OWNER'
  | 'RESOURCE_PINNER_LIST_READER'
  | 'BIZ_PINNER_LIST_SHARER'
  | 'RESOURCE_CONVERSION_TAGS_READER';

export type SSIOAccountAddress = {
  /**
   * Address display
   */
  display?: string;
  /**
   * Purpose for which the address is used, usually Billing or Businness
   */
  purpose?: string;
  /**
   * Salesforce id for address
   */
  address_id?: string;
  /**
   * Legal entity for this insertion order
   */
  order_legal_entity?: string;
};

export type SSIOAccountItem = {
  /**
   * Salesforce id for billto_info
   */
  id?: string;
  /**
   * Salesforce id for IO Terms and Conditions
   */
  io_terms_id?: string;
  /**
   * Salesforce text for IO Terms and Conditions
   */
  io_terms?: string;
  /**
   * Salesforce id for US Terms and Conditions
   */
  us_terms_id?: string;
  /**
   * Salesforce text for US Terms and Conditions
   */
  us_terms?: string;
  /**
   * Salesforce id for Rest of the World Terms and Conditions
   */
  row_terms_id?: string;
  /**
   * Salesforce text for Rest of the World Terms and Conditions
   */
  row_terms?: string;
  /**
   * Insertion Order Type - Pinterest Paper or Agency Paper
   */
  io_type?: string;
  /**
   * Address information that is associated with this account.
   */
  addresses?: Array<SSIOAccountAddress>;
};

export type SSIOAccountPMPName = {
  /**
   * Display name
   */
  name?: string;
  /**
   * Salesforce id for PMP
   */
  id?: string;
};

export type SSIOAccountResponse = {
  /**
   * Advertiser eligible to create order lines
   */
  eligible?: boolean;
  /**
   * Advertiser eligible to update order lines
   */
  can_edit?: boolean;
  /**
   * An array of Salesforce account information that includes address, io terms, etc.
   */
  billto_infos?: Array<SSIOAccountItem>;
  currency?: string;
  pmp_names?: Array<SSIOAccountPMPName>;
  /**
   * Error indicator from Salesforce which could be "No Error"
   */
  error?: string;
};

export type SSIOCreateInsertionOrderRequest = SSIOInsertionOrderCommon & {
  /**
   * The UTC timestamp (to the nearest sec) of when terms were accepted
   */
  accepted_terms_time?: number;
  /**
   * The pmp id
   */
  pmp_id: string;
  /**
   * The order name
   */
  order_name: string;
  /**
   * Type can be Budget or Perpetual
   */
  order_line_type: 'BUDGET' | 'PERPETUALS';
  /**
   * The SFDC id for the terms
   */
  accepted_terms_id: string;
  /**
   * The bill-to company id
   */
  billto_company_id: string;
  /**
   * The bill-to business address id
   */
  billto_business_address_id: string;
  /**
   * The bill-to billing address id
   */
  billto_billing_address_id: string;
  /**
   * If Ongoing (perpetual) order line, the estimated monthly spend
   */
  estimated_monthly_spend?: number;
  currency_info: Currency;
};

/**
 * Type can be Budget or Perpetual
 */
export type order_line_type = 'BUDGET' | 'PERPETUALS';

export type SSIOCreateInsertionOrderResponse = {
  /**
   * Salesforce order id
   */
  pin_order_id?: string;
};

export type SSIOEditInsertionOrderRequest = SSIOInsertionOrderCommon & {
  /**
   * LineId in the Oracle DB
   */
  oracle_line_id?: string;
  /**
   * OrderId in SFDC
   */
  salesforce_order_id?: string;
  /**
   * OrderLineId in SFDC
   */
  salesforce_order_line_id?: string;
  /**
   * Ads manager OrderLineId
   */
  ads_manager_order_line_id?: string;
};

export type SSIOEditInsertionOrderResponse = {
  /**
   * Salesforce order id
   */
  pin_order_id?: string;
};

export type SSIOInsertionOrderCommon = {
  /**
   * Starting date of time period. Format: YYYY-MM-DD
   */
  start_date?: string;
  /**
   * End date of time period. Format: YYYY-MM-DD
   */
  end_date?: string;
  /**
   * The po number
   */
  po_number?: string;
  /**
   * If Budget order line, the budget amount.
   */
  budget_amount?: number;
  /**
   * The billing contact first name
   */
  billing_contact_firstname?: string;
  /**
   * The billing contact last name
   */
  billing_contact_lastname?: string;
  /**
   * The billing contact email
   */
  billing_contact_email?: string;
  /**
   * The media contact first name
   */
  media_contact_firstname?: string;
  /**
   * The media contact last name
   */
  media_contact_lastname?: string;
  /**
   * The media contact email
   */
  media_contact_email?: string;
  /**
   * URL link for agency
   */
  agency_link?: string;
  /**
   * The email of user submitting the insertion order
   */
  user_email?: string;
};

export type SSIOInsertionOrderStatus = {
  /**
   * Salesforce order id
   */
  pin_order_id?: string;
  /**
   * Salesforce insertion order status
   */
  status?: string;
  /**
   * Salesforce insertion order creation time
   */
  creation_time?: string | null;
};

export type SSIOInsertionOrderStatusResponse = SSIOInsertionOrderStatus & {
  [key: string]: unknown;
};

export type SSIOOrderLine = {
  /**
   * OrderLineId in SFDC
   */
  salesforce_order_line_id?: string | null;
  /**
   * Ads manager OrderLineId
   */
  ads_manager_order_line_id?: string | null;
  /**
   * The pin order id associated with the order line in SFDC
   */
  pin_order_id?: string | null;
  /**
   * Last modified date.
   */
  last_modified_date_time?: string | null;
  /**
   * Start date of the order line.
   */
  start_date?: string | null;
  /**
   * End date of the order line.
   */
  end_date?: string | null;
  /**
   * Bill To Company name
   */
  bill_to_company_name?: string | null;
  /**
   * Billing contact first name
   */
  billing_contact_firstname?: string | null;
  /**
   * Billing contact last name
   */
  billing_contact_lastname?: string | null;
  /**
   * Billing contact email
   */
  billing_contact_email?: string | null;
  /**
   * Billing media email
   */
  media_contact_email?: string | null;
  /**
   * Billing contact first name
   */
  media_contact_firstname?: string | null;
  /**
   * Billing contact first name
   */
  media_contact_lastname?: string | null;
  currency_info?: Currency | null;
  /**
   * Agency link
   */
  agency_link?: string | null;
  /**
   * The po number
   */
  po_number?: string | null;
  /**
   * The order name
   */
  order_name?: string | null;
  /**
   * The Pinterest marketing partner name
   */
  pmp_name?: string | null;
  /**
   * The SFDC id for the terms
   */
  accepted_terms_id?: string | null;
  /**
   * The UTC timestamp (to the nearest sec) of when terms were accepted
   */
  accepted_terms_time?: string | null;
  /**
   * If Budget order line, the budget amount.
   */
  budget_amount?: number | null;
  /**
   * If Ongoing (perpetual) order line, the estimated monthly spend
   */
  estimated_monthly_spend?: number | null;
};

export type SharedAudienceAccount = {
  /**
   * Account ID (ad account or business ID).
   */
  account_id: string;
  /**
   * Account name.
   */
  account_name: string;
  /**
   * account type
   */
  account_type: 'AD_ACCOUNT' | 'BUSINESS_ACCOUNT';
  /**
   * Epoch timestamp in seconds for the shared audience event
   */
  shared_on_timestamp: number;
};

/**
 * account type
 */
export type account_type2 = 'AD_ACCOUNT' | 'BUSINESS_ACCOUNT';

export type SingleInterestTargetingOptionResponse = {
  id?: string;
  name?: string;
  child_interests?: Array<string>;
  level?: number;
};

/**
 * Advertiser's ISO two character country code.
 */
export type TargetingAdvertiserCountry =
  | 'US'
  | 'GB'
  | 'CA'
  | 'IE'
  | 'AU'
  | 'NZ'
  | 'FR'
  | 'SE'
  | 'IL'
  | 'DE'
  | 'AT'
  | 'IT'
  | 'ES'
  | 'NL'
  | 'BE'
  | 'PT'
  | 'CH'
  | 'HK'
  | 'JP'
  | 'KR'
  | 'SG'
  | 'NO'
  | 'DK'
  | 'FI'
  | 'CY'
  | 'LU'
  | 'MT'
  | 'PL'
  | 'RO'
  | 'HU'
  | 'CZ'
  | 'GR'
  | 'SK'
  | 'BR'
  | 'MX'
  | 'AR'
  | 'CL'
  | 'CO';

export type TargetingOptionResponse = Array<{
  [key: string]: unknown;
}> | null;

/**
 * Ad group targeting specification defining the ad group target audience. For example, `{"APPTYPE":["iphone"], "GENDER":["male"], "LOCALE":["en-US"], "LOCATION":["501"], "AGE_BUCKET":["25-34"]}`
 */
export type TargetingSpec = {
  /**
   * Age ranges. If the AGE_BUCKET field is missing, the default behavior in terms of ad delivery is that **All age buckets** will be targeted.
   */
  AGE_BUCKET?: Array<'18-24' | '21+' | '25-34' | '35-44' | '45-49' | '50-54' | '55-64' | '65+'> | null;
  /**
   * Allowed devices. If the APPTYPE field is missing, the default behavior in terms of ad delivery is that **All devices/apptypes** will be targeted.
   */
  APPTYPE?: Array<'android_mobile' | 'android_tablet' | 'ipad' | 'iphone' | 'web' | 'web_mobile'> | null;
  /**
   * Excluded customer list IDs. Used to drive new customer acquisition goals. For example: ["2542620905475"]. Audience lists need to have at least 100 people with Pinterest accounts in them. If the AUDIENCE_EXCLUDE field is missing, the default behavior in terms of ad delivery is that **No users will be excluded**.
   */
  AUDIENCE_EXCLUDE?: Array<string> | null;
  /**
   * Targeted customer list IDs. For example: ["2542620905473"]. Audience lists need to have at least 100 people with Pinterest accounts in them Audience lists need to have at least 100 people with Pinterest accounts in them. If the AUDIENCE_INCLUDE field is missing, the default behavior in terms of ad delivery is that **All users will be included**.
   */
  AUDIENCE_INCLUDE?: Array<string> | null;
  /**
   * Targeted genders. Values: ["unknown","male","female"]. If the GENDER field is missing, the default behavior in terms of ad delivery is that **All genders will be targeted**.
   */
  GENDER?: Array<'unknown' | 'male' | 'female'> | null;
  /**
   * Location region codes, e.g., "BE-VOV" (East Flanders, Belgium) For complete list, <a href="https://help.pinterest.com/sub/helpcenter/partner/pinterest_location_targeting_codes.xlsx" target="_blank">click here</a> or postal codes, e.g., "US-94107". Use either region codes or postal codes but not both. At least one of LOCATION or GEO must be specified. If the GEO field is missing, then only LOCATION values will be targeted (see LOCATION field below).
   */
  GEO?: Array<string> | null;
  /**
   * Array of interest object IDs. If the INTEREST field is missing, the default behavior in terms of ad delivery is that **All interests will be targeted**.
   */
  INTEREST?: Array<string>;
  /**
   * 24 ISO 639-1 two letter language codes. If the LOCALE field is missing, the default behavior in terms of ad delivery is that **All languages will be targeted, only english non-sublanguage will be targeted**.
   */
  LOCALE?: Array<string> | null;
  /**
   * 22 ISO Alpha 2 two letter country codes or US Nielsen DMA (Designated Market Area) codes (location region codes) (e.g., ["US", "807"]). For complete list, click here. Location-Country and Location-Metro codes apply. At least one of LOCATION or GEO must be specified. If the LOCATION field is missing, then only GEO values will be targeted (see GEO field above).
   */
  LOCATION?: Array<string> | null;
  /**
   * Array of object: lookback_window	[Integer]: Number of days ago to start lookback timeframe for dynamic retargeting tag_types [Array of integer]: Event types to target for dynamic retargeting exclusion_window [Integer]: Number of days ago to stop lookback timeframe for dynamic retargeting
   */
  SHOPPING_RETARGETING?: Array<{
    /**
     * Number of days ago to start lookback timeframe for dynamic retargeting
     */
    lookback_window?: number;
    /**
     * Event types to target for dynamic retargeting
     */
    tag_types?: Array<number>;
    /**
     * Number of days ago to stop lookback timeframe for dynamic retargeting
     */
    exclusion_window?: number;
  }> | null;
  TARGETING_STRATEGY?: Array<'CHOOSE_YOUR_OWN' | 'FIND_NEW_CUSTOMERS' | 'RECONNECT_WITH_USERS'> | null;
};

/**
 * Gets an audience size estimate for a set of given targeting spec data. <p>Returns:</p> An object containing an audience size estimate that has a reach estimate (number of unique users) against the given targeting template. This by default provides a monthly estimate.
 */
export type TargetingTemplateAudienceSizing = {
  reach_estimate?: {
    estimate?: number;
    lower_bound?: number;
    upper_bound?: number;
  };
} | null;

export type TargetingTemplateCommon = {
  /**
   * targeting template name
   */
  name?: string;
  /**
   * Enable auto-targeting for ad group. Also known as <a href="https://help.pinterest.com/en/business/article/expanded-targeting" target="_blank">"expanded targeting"</a>.
   */
  auto_targeting_enabled?: boolean;
  targeting_attributes?: TargetingSpec;
  placement_group?: PlacementGroupType;
  keywords?: Array<TargetingTemplateKeyword>;
  tracking_urls?: TrackingUrls;
};

export type TargetingTemplateCreate = TargetingTemplateCommon & {
  /**
   * Name of targeting template.
   */
  name: string;
  targeting_attributes: TargetingSpec;
};

export type TargetingTemplateKeyword = {
  match_type?: MatchType;
  /**
   * The keyword targeting (120 chars max).
   */
  value?: string;
};

export type TargetingTemplateGetResponseData = TargetingTemplateResponseData & {
  /**
   * Inform if the targeting template is valid (ex. would be false if has revoked audience)
   */
  valid?: boolean | null;
};

export type TargetingTemplateResponseData = TargetingTemplateCommon & {
  /**
   * Targeting template ID.
   */
  id?: string;
  /**
   * Targeting template created time. Unix timestamp in seconds.
   */
  created_time?: number;
  /**
   * Targeting template updated time.Unix timestamp in seconds.
   */
  updated_time?: number;
  /**
   * The ID of the advertiser that this targeting template belongs to.
   */
  ad_account_id?: string;
  /**
   * Indicate targeting template is active or Deleted
   */
  status?: 'ACTIVE' | 'DELETED';
  sizing?: TargetingTemplateAudienceSizing;
};

export type TargetingTemplateUpdateRequest = {
  operation_type: 'REMOVE';
  /**
   * Targeting template ID
   */
  id: string;
};

export type operation_type = 'REMOVE';

export type TargetingTypeFilter = {
  /**
   * List of targeting types. Requires `level` to be a value ending in `_TARGETING`. ["AGE_BUCKET_AND_GENDER"] is in BETA and not yet available to all users.
   */
  targeting_types?: Array<AdsAnalyticsTargetingType>;
};

/**
 * Template fields
 */
export type TemplateResponse = {
  /**
   * Template ID
   */
  id?: string;
  /**
   * ID of the Ad Account that owns the template
   */
  ad_account_id?: string;
  /**
   * IDs of the Ad Accounts that have access to this template
   */
  ad_account_ids?: Array<string>;
  /**
   * ID of the user who created the template
   */
  user_id?: string;
  /**
   * Template Name
   */
  name?: string | null;
  /**
   * The number of days prior to the day the report will be delivered at which the report will start
   */
  report_start_relative_days_in_past?: number;
  /**
   * The number of days prior to the day the report will be delivered at which the report will end
   */
  report_end_relative_days_in_past?: number;
  date_range?: {
    /**
     * The dynamic date range of the template
     */
    dynamic_date_range?: {
      /**
       * The date range type
       */
      type?: string;
      /**
       * The dynamic range type
       */
      range?: 'YEAR_TO_DATE' | 'QUARTER_TO_DATE' | 'MONTH_TO_DATE' | 'LAST_MONTH';
    } | null;
    /**
     * The relative date range of the template
     */
    relative_date_range?: {
      /**
       * The date range type
       */
      type?: string;
      /**
       * The start date of the date range
       */
      start_days_in_past?: number;
      /**
       * The end date of the date range
       */
      end_days_in_past?: number;
    } | null;
    /**
     * The absolute date range of the template
     */
    absolute_date_range?: {
      /**
       * The date range type
       */
      type?: string;
      /**
       * The start date of the date range
       */
      start_date?: number;
      /**
       * The end date of the date range
       */
      end_date?: number;
    } | null;
  };
  report_level?: MetricsReportingLevel;
  report_format?: DataOutputFormat;
  /**
   * A list of columns to be included in the report
   */
  columns?: Array<
    | 'SPEND_IN_MICRO_DOLLAR'
    | 'SPEND_IN_MICRO_US_DOLLAR'
    | 'BONUS_SPEND_IN_MICRO_DOLLAR'
    | 'BONUS_SPEND_IN_DOLLAR'
    | 'PAID_IMPRESSION'
    | 'PAID_CLICKTHROUGH'
    | 'SPEND_IN_DOLLAR'
    | 'SPEND_IN_US_DOLLAR'
    | 'CPC_IN_MICRO_DOLLAR'
    | 'ECPC_IN_MICRO_DOLLAR'
    | 'CPC_IN_DOLLAR'
    | 'ECPC_IN_DOLLAR'
    | 'CTR'
    | 'ECTR'
    | 'OUTBOUND_CTR'
    | 'CPC_IN_MICRO_CURRENCY'
    | 'CPW_IN_MICRO_DOLLAR'
    | 'CPW_IN_DOLLAR'
    | 'COST_PER_OUTBOUND_CLICK'
    | 'AD_ONLY_PIN'
    | 'CAMPAIGN_NAME'
    | 'CAMPAIGN_STATUS'
    | 'IS_CAMPAIGN_LEARNING_PHASE'
    | 'DATE'
    | 'DATE_AS_TIMESTAMP'
    | 'BUDGET_IN_DOLLAR'
    | 'AVAILABLE_BUDGET_IN_DOLLAR'
    | 'TARGETING_TYPE'
    | 'TARGETING_VALUE'
    | 'TARGETING_VALUE_NAME'
    | 'PAID_EVENTS'
    | 'BONUS_EVENTS'
    | 'INSERTION'
    | 'LEGACY_CAMPAIGN_ID'
    | 'HBASE_ID'
    | 'PIN_DESCRIPTION'
    | 'CAMPAIGN_END_DATE'
    | 'PIN_PROMOTION_STATUS'
    | 'AD_STATUS'
    | 'PIN_ID'
    | 'CROSS_DEVICE_TYPE'
    | 'INGESTION_SOURCE'
    | 'SOURCE_PLATFORM'
    | 'PIN_PROMOTION_IS_RUNNING'
    | 'TOTAL_ENGAGEMENT'
    | 'ENGAGEMENT_1'
    | 'ENGAGEMENT_2'
    | 'CPE_IN_MICRO_DOLLAR'
    | 'ECPE_IN_MICRO_DOLLAR'
    | 'CPE_IN_DOLLAR'
    | 'ECPE_IN_DOLLAR'
    | 'ENGAGEMENT_RATE'
    | 'EENGAGEMENT_RATE'
    | 'INTERNAL_ECPE_IN_MICRO_DOLLAR'
    | 'INTERNAL_ECPE_IN_DOLLAR'
    | 'ECPM_IN_MICRO_DOLLAR'
    | 'ECPM_IN_DOLLAR'
    | 'REPIN_RATE'
    | 'REPIN_RATE_2'
    | 'CTR_2'
    | 'CAMPAIGN_ID'
    | 'ADVERTISER_ID'
    | 'AD_ACCOUNT_ID'
    | 'ADVERTISER_OWNER_USER_ID'
    | 'ADVERTISER_OWNER_USER_NAME'
    | 'PIN_PROMOTION_ID'
    | 'AD_ID'
    | 'AD_GROUP_ID'
    | 'KEYWORD_ID'
    | 'KEYWORD_IS_DELETED'
    | 'BRAND_SFDC_ACCOUNT_ID'
    | 'CAMPAIGN_ACTION_TYPE'
    | 'CAMPAIGN_BID_TYPE'
    | 'CAMPAIGN_ENTITY_STATUS'
    | 'CAMPAIGN_MANAGED_STATUS'
    | 'CAMPAIGN_OBJECTIVE_TYPE'
    | 'CPM_IN_MICRO_DOLLAR'
    | 'CPM_IN_DOLLAR'
    | 'BUDGET_TYPE'
    | 'BUDGET_IN_LOCAL_CURRENCY'
    | 'AD_GROUP_NAME'
    | 'AD_GROUP_STATUS'
    | 'AD_GROUP_END_DATE'
    | 'AD_GROUP_BUDGET_TYPE'
    | 'AD_GROUP_BUDGET_IN_LOCAL_CURRENCY'
    | 'AD_GROUP_SUGGESTED_BUDGET_IN_LOCAL_CURRENCY'
    | 'AD_GROUP_SUGGESTED_BONUS_BUDGET_IN_LOCAL_CURRENCY'
    | 'AD_GROUP_ENTITY_STATUS'
    | 'AD_GROUP_ACTION_TYPE'
    | 'AD_GROUP_CONVERSION_LEARNING_MODE_TYPE'
    | 'AD_GROUP_TARGET_CPA'
    | 'AD_GROUP_BID_STRATEGY_TYPE'
    | 'AD_GROUP_EXPERIMENT_NAME'
    | 'AD_GROUP_EXPERIMENT_CELL'
    | 'CAMPAIGN_WEB_CLOSEUP_WHITELISTED'
    | 'PRODUCT_GROUP_ID'
    | 'PRODUCT_GROUP_DEFINITION'
    | 'PARENT_PRODUCT_GROUP_ID'
    | 'PRODUCT_GROUP_TYPE'
    | 'PRODUCT_GROUP_BID_IN_MICRO_CURRENCY'
    | 'PRODUCT_GROUP_STATUS'
    | 'PRODUCT_GROUP_ENTITY_STATUS'
    | 'PRODUCT_GROUP_INCLUSION'
    | 'PRODUCT_GROUP_CREATIVE_TYPE'
    | 'ITEM_ID'
    | 'PRODUCT_ITEM_ID'
    | 'INTERNAL_PRODUCT_ITEM_ID'
    | 'INTERNAL_PRODUCT_ITEM_ID_STR'
    | 'PRODUCT_ITEM_NAME'
    | 'PRODUCT_ITEM_IMAGE_URL'
    | 'PRODUCT_ITEM_PRICE'
    | 'ORDER_LINE_ID'
    | 'ORDER_LINE_NAME'
    | 'ORDER_LINE_PIN_REV_SHARE'
    | 'ORDER_LINE_PAID_TYPE'
    | 'SPEND_ORDER_LINE_ID'
    | 'SPEND_ORDER_LINE_PAID_TYPE'
    | 'CONVERSION_PRODUCT_ID'
    | 'CONVERSION_PRODUCT_NAME'
    | 'CONVERSION_PRODUCT_BRAND'
    | 'CONVERSION_PRODUCT_CATEGORY'
    | 'CLICKTHROUGH_1'
    | 'REPIN_1'
    | 'IMPRESSION_1'
    | 'LIKE_1'
    | 'SEND_1'
    | 'FLAG_1'
    | 'HIDE_1'
    | 'INSERTION_1'
    | 'IMPRESSION_1_GROSS'
    | 'CLICKTHROUGH_1_GROSS'
    | 'OUTBOUND_CLICK_1'
    | 'CLICKTHROUGH_USER_1'
    | 'REPIN_USER_1'
    | 'IMPRESSION_USER_1'
    | 'LIKE_USER_1'
    | 'SEND_USER_1'
    | 'FLAG_USER_1'
    | 'HIDE_USER_1'
    | 'INSERTION_USER_1'
    | 'CLICKTHROUGH_2'
    | 'REPIN_2'
    | 'IMPRESSION_2'
    | 'LIKE_2'
    | 'SEND_2'
    | 'FLAG_2'
    | 'OUTBOUND_CLICK_2'
    | 'CLICKTHROUGH_USER_2'
    | 'REPIN_USER_2'
    | 'IMPRESSION_USER_2'
    | 'LIKE_USER_2'
    | 'SEND_USER_2'
    | 'FLAG_USER_2'
    | 'TOTAL_CLICKTHROUGH'
    | 'TOTAL_REPIN'
    | 'TOTAL_IMPRESSION'
    | 'TOTAL_LIKE'
    | 'TOTAL_SEND'
    | 'TOTAL_FLAG'
    | 'TOTAL_IMPRESSION_USER'
    | 'TOTAL_IMPRESSION_USER_HLL'
    | 'TOTAL_IMPRESSION_FREQUENCY'
    | 'TOTAL_IMPRESSION_FREQUENCY_HLL'
    | 'TOTAL_OUTBOUND_CLICK'
    | 'COST_PER_OUTBOUND_CLICK_IN_DOLLAR'
    | 'ENGAGEMENT_PAGE_VISIT_1'
    | 'ENGAGEMENT_SIGNUP_1'
    | 'ENGAGEMENT_CHECKOUT_1'
    | 'ENGAGEMENT_CUSTOM_1'
    | 'ENGAGEMENT_ADD_TO_CART_1'
    | 'ENGAGEMENT_LEAD_1'
    | 'ENGAGEMENT_SEARCH_1'
    | 'ENGAGEMENT_WATCH_VIDEO_1'
    | 'ENGAGEMENT_VIEW_CATEGORY_1'
    | 'ENGAGEMENT_APP_INSTALL_1'
    | 'ENGAGEMENT_UNKNOWN_1'
    | 'CLICK_PAGE_VISIT_1'
    | 'CLICK_SIGNUP_1'
    | 'CLICK_CHECKOUT_1'
    | 'CLICK_CUSTOM_1'
    | 'CLICK_ADD_TO_CART_1'
    | 'CLICK_LEAD_1'
    | 'CLICK_SEARCH_1'
    | 'CLICK_WATCH_VIDEO_1'
    | 'CLICK_VIEW_CATEGORY_1'
    | 'CLICK_APP_INSTALL_1'
    | 'CLICK_UNKNOWN_1'
    | 'VIEW_PAGE_VISIT_1'
    | 'VIEW_SIGNUP_1'
    | 'VIEW_CHECKOUT_1'
    | 'VIEW_CUSTOM_1'
    | 'VIEW_ADD_TO_CART_1'
    | 'VIEW_LEAD_1'
    | 'VIEW_SEARCH_1'
    | 'VIEW_WATCH_VIDEO_1'
    | 'VIEW_VIEW_CATEGORY_1'
    | 'VIEW_APP_INSTALL_1'
    | 'VIEW_UNKNOWN_1'
    | 'CONVERSIONS_1'
    | 'ENGAGEMENT_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR_1'
    | 'ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR_1'
    | 'ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR_1'
    | 'ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR_1'
    | 'ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR_1'
    | 'ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR_1'
    | 'ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR_1'
    | 'ENGAGEMENT_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR_1'
    | 'ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR_1'
    | 'ENGAGEMENT_APP_INSTALL_VALUE_IN_MICRO_DOLLAR_1'
    | 'ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR_1'
    | 'CLICK_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR_1'
    | 'CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR_1'
    | 'CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR_1'
    | 'CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR_1'
    | 'CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR_1'
    | 'CLICK_LEAD_VALUE_IN_MICRO_DOLLAR_1'
    | 'CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR_1'
    | 'CLICK_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR_1'
    | 'CLICK_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR_1'
    | 'CLICK_APP_INSTALL_VALUE_IN_MICRO_DOLLAR_1'
    | 'CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR_1'
    | 'VIEW_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR_1'
    | 'VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR_1'
    | 'VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR_1'
    | 'VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR_1'
    | 'VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR_1'
    | 'VIEW_LEAD_VALUE_IN_MICRO_DOLLAR_1'
    | 'VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR_1'
    | 'VIEW_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR_1'
    | 'VIEW_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR_1'
    | 'VIEW_APP_INSTALL_VALUE_IN_MICRO_DOLLAR_1'
    | 'VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR_1'
    | 'CONVERSIONS_VALUE_IN_MICRO_DOLLAR_1'
    | 'ENGAGEMENT_PAGE_VISIT_QUANTITY_1'
    | 'ENGAGEMENT_SIGNUP_QUANTITY_1'
    | 'ENGAGEMENT_CHECKOUT_QUANTITY_1'
    | 'ENGAGEMENT_CUSTOM_QUANTITY_1'
    | 'ENGAGEMENT_ADD_TO_CART_QUANTITY_1'
    | 'ENGAGEMENT_LEAD_QUANTITY_1'
    | 'ENGAGEMENT_SEARCH_QUANTITY_1'
    | 'ENGAGEMENT_WATCH_VIDEO_QUANTITY_1'
    | 'ENGAGEMENT_VIEW_CATEGORY_QUANTITY_1'
    | 'ENGAGEMENT_APP_INSTALL_QUANTITY_1'
    | 'ENGAGEMENT_UNKNOWN_QUANTITY_1'
    | 'CLICK_PAGE_VISIT_QUANTITY_1'
    | 'CLICK_SIGNUP_QUANTITY_1'
    | 'CLICK_CHECKOUT_QUANTITY_1'
    | 'CLICK_CUSTOM_QUANTITY_1'
    | 'CLICK_ADD_TO_CART_QUANTITY_1'
    | 'CLICK_LEAD_QUANTITY_1'
    | 'CLICK_SEARCH_QUANTITY_1'
    | 'CLICK_WATCH_VIDEO_QUANTITY_1'
    | 'CLICK_VIEW_CATEGORY_QUANTITY_1'
    | 'CLICK_APP_INSTALL_QUANTITY_1'
    | 'CLICK_UNKNOWN_QUANTITY_1'
    | 'VIEW_PAGE_VISIT_QUANTITY_1'
    | 'VIEW_SIGNUP_QUANTITY_1'
    | 'VIEW_CHECKOUT_QUANTITY_1'
    | 'VIEW_CUSTOM_QUANTITY_1'
    | 'VIEW_ADD_TO_CART_QUANTITY_1'
    | 'VIEW_LEAD_QUANTITY_1'
    | 'VIEW_SEARCH_QUANTITY_1'
    | 'VIEW_WATCH_VIDEO_QUANTITY_1'
    | 'VIEW_VIEW_CATEGORY_QUANTITY_1'
    | 'VIEW_APP_INSTALL_QUANTITY_1'
    | 'VIEW_UNKNOWN_QUANTITY_1'
    | 'CONVERSIONS_QUANTITY_1'
    | 'ENGAGEMENT_PAGE_VISIT_2'
    | 'ENGAGEMENT_SIGNUP_2'
    | 'ENGAGEMENT_CHECKOUT_2'
    | 'ENGAGEMENT_CUSTOM_2'
    | 'ENGAGEMENT_ADD_TO_CART_2'
    | 'ENGAGEMENT_LEAD_2'
    | 'ENGAGEMENT_SEARCH_2'
    | 'ENGAGEMENT_WATCH_VIDEO_2'
    | 'ENGAGEMENT_VIEW_CATEGORY_2'
    | 'ENGAGEMENT_APP_INSTALL_2'
    | 'ENGAGEMENT_UNKNOWN_2'
    | 'CLICK_PAGE_VISIT_2'
    | 'CLICK_SIGNUP_2'
    | 'CLICK_CHECKOUT_2'
    | 'CLICK_CUSTOM_2'
    | 'CLICK_ADD_TO_CART_2'
    | 'CLICK_LEAD_2'
    | 'CLICK_SEARCH_2'
    | 'CLICK_WATCH_VIDEO_2'
    | 'CLICK_VIEW_CATEGORY_2'
    | 'CLICK_APP_INSTALL_2'
    | 'CLICK_UNKNOWN_2'
    | 'VIEW_PAGE_VISIT_2'
    | 'VIEW_SIGNUP_2'
    | 'VIEW_CHECKOUT_2'
    | 'VIEW_CUSTOM_2'
    | 'VIEW_ADD_TO_CART_2'
    | 'VIEW_LEAD_2'
    | 'VIEW_SEARCH_2'
    | 'VIEW_WATCH_VIDEO_2'
    | 'VIEW_VIEW_CATEGORY_2'
    | 'VIEW_APP_INSTALL_2'
    | 'VIEW_UNKNOWN_2'
    | 'CONVERSIONS_2'
    | 'ENGAGEMENT_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR_2'
    | 'ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR_2'
    | 'ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR_2'
    | 'ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR_2'
    | 'ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR_2'
    | 'ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR_2'
    | 'ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR_2'
    | 'ENGAGEMENT_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR_2'
    | 'ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR_2'
    | 'ENGAGEMENT_APP_INSTALL_VALUE_IN_MICRO_DOLLAR_2'
    | 'ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR_2'
    | 'CLICK_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR_2'
    | 'CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR_2'
    | 'CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR_2'
    | 'CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR_2'
    | 'CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR_2'
    | 'CLICK_LEAD_VALUE_IN_MICRO_DOLLAR_2'
    | 'CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR_2'
    | 'CLICK_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR_2'
    | 'CLICK_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR_2'
    | 'CLICK_APP_INSTALL_VALUE_IN_MICRO_DOLLAR_2'
    | 'CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR_2'
    | 'VIEW_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR_2'
    | 'VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR_2'
    | 'VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR_2'
    | 'VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR_2'
    | 'VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR_2'
    | 'VIEW_LEAD_VALUE_IN_MICRO_DOLLAR_2'
    | 'VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR_2'
    | 'VIEW_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR_2'
    | 'VIEW_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR_2'
    | 'VIEW_APP_INSTALL_VALUE_IN_MICRO_DOLLAR_2'
    | 'VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR_2'
    | 'CONVERSIONS_VALUE_IN_MICRO_DOLLAR_2'
    | 'ENGAGEMENT_PAGE_VISIT_QUANTITY_2'
    | 'ENGAGEMENT_SIGNUP_QUANTITY_2'
    | 'ENGAGEMENT_CHECKOUT_QUANTITY_2'
    | 'ENGAGEMENT_CUSTOM_QUANTITY_2'
    | 'ENGAGEMENT_ADD_TO_CART_QUANTITY_2'
    | 'ENGAGEMENT_LEAD_QUANTITY_2'
    | 'ENGAGEMENT_SEARCH_QUANTITY_2'
    | 'ENGAGEMENT_WATCH_VIDEO_QUANTITY_2'
    | 'ENGAGEMENT_VIEW_CATEGORY_QUANTITY_2'
    | 'ENGAGEMENT_APP_INSTALL_QUANTITY_2'
    | 'ENGAGEMENT_UNKNOWN_QUANTITY_2'
    | 'CLICK_PAGE_VISIT_QUANTITY_2'
    | 'CLICK_SIGNUP_QUANTITY_2'
    | 'CLICK_CHECKOUT_QUANTITY_2'
    | 'CLICK_CUSTOM_QUANTITY_2'
    | 'CLICK_ADD_TO_CART_QUANTITY_2'
    | 'CLICK_LEAD_QUANTITY_2'
    | 'CLICK_SEARCH_QUANTITY_2'
    | 'CLICK_WATCH_VIDEO_QUANTITY_2'
    | 'CLICK_VIEW_CATEGORY_QUANTITY_2'
    | 'CLICK_APP_INSTALL_QUANTITY_2'
    | 'CLICK_UNKNOWN_QUANTITY_2'
    | 'VIEW_PAGE_VISIT_QUANTITY_2'
    | 'VIEW_SIGNUP_QUANTITY_2'
    | 'VIEW_CHECKOUT_QUANTITY_2'
    | 'VIEW_CUSTOM_QUANTITY_2'
    | 'VIEW_ADD_TO_CART_QUANTITY_2'
    | 'VIEW_LEAD_QUANTITY_2'
    | 'VIEW_SEARCH_QUANTITY_2'
    | 'VIEW_WATCH_VIDEO_QUANTITY_2'
    | 'VIEW_VIEW_CATEGORY_QUANTITY_2'
    | 'VIEW_APP_INSTALL_QUANTITY_2'
    | 'VIEW_UNKNOWN_QUANTITY_2'
    | 'CONVERSIONS_QUANTITY_2'
    | 'TOTAL_ENGAGEMENT_PAGE_VISIT'
    | 'TOTAL_ENGAGEMENT_SIGNUP'
    | 'TOTAL_ENGAGEMENT_CHECKOUT'
    | 'TOTAL_ENGAGEMENT_CUSTOM'
    | 'TOTAL_ENGAGEMENT_ADD_TO_CART'
    | 'TOTAL_ENGAGEMENT_LEAD'
    | 'TOTAL_ENGAGEMENT_SEARCH'
    | 'TOTAL_ENGAGEMENT_WATCH_VIDEO'
    | 'TOTAL_ENGAGEMENT_VIEW_CATEGORY'
    | 'TOTAL_ENGAGEMENT_APP_INSTALL'
    | 'TOTAL_ENGAGEMENT_UNKNOWN'
    | 'TOTAL_CLICK_PAGE_VISIT'
    | 'TOTAL_CLICK_SIGNUP'
    | 'TOTAL_CLICK_CHECKOUT'
    | 'TOTAL_CLICK_CUSTOM'
    | 'TOTAL_CLICK_ADD_TO_CART'
    | 'TOTAL_CLICK_LEAD'
    | 'TOTAL_CLICK_SEARCH'
    | 'TOTAL_CLICK_WATCH_VIDEO'
    | 'TOTAL_CLICK_VIEW_CATEGORY'
    | 'TOTAL_CLICK_APP_INSTALL'
    | 'TOTAL_CLICK_UNKNOWN'
    | 'TOTAL_VIEW_PAGE_VISIT'
    | 'TOTAL_VIEW_SIGNUP'
    | 'TOTAL_VIEW_CHECKOUT'
    | 'TOTAL_VIEW_CUSTOM'
    | 'TOTAL_VIEW_ADD_TO_CART'
    | 'TOTAL_VIEW_LEAD'
    | 'TOTAL_VIEW_SEARCH'
    | 'TOTAL_VIEW_WATCH_VIDEO'
    | 'TOTAL_VIEW_VIEW_CATEGORY'
    | 'TOTAL_VIEW_APP_INSTALL'
    | 'TOTAL_VIEW_UNKNOWN'
    | 'TOTAL_CONVERSIONS'
    | 'TOTAL_WEB_CONVERSIONS'
    | 'TOTAL_INAPP_CONVERSIONS'
    | 'TOTAL_OFFLINE_CONVERSIONS'
    | 'TOTAL_ENGAGEMENT_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_ENGAGEMENT_PAGE_VISIT_VALUE_IN_DOLLAR'
    | 'TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_DOLLAR'
    | 'TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_DOLLAR'
    | 'TOTAL_ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_ENGAGEMENT_CUSTOM_VALUE_IN_DOLLAR'
    | 'TOTAL_ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_ENGAGEMENT_ADD_TO_CART_VALUE_IN_DOLLAR'
    | 'TOTAL_ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_ENGAGEMENT_LEAD_VALUE_IN_DOLLAR'
    | 'TOTAL_ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_ENGAGEMENT_SEARCH_VALUE_IN_DOLLAR'
    | 'TOTAL_ENGAGEMENT_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_ENGAGEMENT_WATCH_VIDEO_VALUE_IN_DOLLAR'
    | 'TOTAL_ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_DOLLAR'
    | 'TOTAL_ENGAGEMENT_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_CLICK_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_CLICK_PAGE_VISIT_VALUE_IN_DOLLAR'
    | 'TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_CLICK_SIGNUP_VALUE_IN_DOLLAR'
    | 'TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_CLICK_CHECKOUT_VALUE_IN_DOLLAR'
    | 'TOTAL_CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_CLICK_CUSTOM_VALUE_IN_DOLLAR'
    | 'TOTAL_CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_CLICK_ADD_TO_CART_VALUE_IN_DOLLAR'
    | 'TOTAL_CLICK_LEAD_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_CLICK_LEAD_VALUE_IN_DOLLAR'
    | 'TOTAL_CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_CLICK_SEARCH_VALUE_IN_DOLLAR'
    | 'TOTAL_CLICK_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_CLICK_WATCH_VIDEO_VALUE_IN_DOLLAR'
    | 'TOTAL_CLICK_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_CLICK_VIEW_CATEGORY_VALUE_IN_DOLLAR'
    | 'TOTAL_CLICK_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_VIEW_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_VIEW_PAGE_VISIT_VALUE_IN_DOLLAR'
    | 'TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_VIEW_SIGNUP_VALUE_IN_DOLLAR'
    | 'TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_VIEW_CHECKOUT_VALUE_IN_DOLLAR'
    | 'TOTAL_VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_VIEW_CUSTOM_VALUE_IN_DOLLAR'
    | 'TOTAL_VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_VIEW_ADD_TO_CART_VALUE_IN_DOLLAR'
    | 'TOTAL_VIEW_LEAD_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_VIEW_LEAD_VALUE_IN_DOLLAR'
    | 'TOTAL_VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_VIEW_SEARCH_VALUE_IN_DOLLAR'
    | 'TOTAL_VIEW_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_VIEW_WATCH_VIDEO_VALUE_IN_DOLLAR'
    | 'TOTAL_VIEW_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_VIEW_VIEW_CATEGORY_VALUE_IN_DOLLAR'
    | 'TOTAL_VIEW_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_CONVERSIONS_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_CONVERSIONS_VALUE_IN_DOLLAR'
    | 'TOTAL_ENGAGEMENT_PAGE_VISIT_QUANTITY'
    | 'TOTAL_ENGAGEMENT_SIGNUP_QUANTITY'
    | 'TOTAL_ENGAGEMENT_CHECKOUT_QUANTITY'
    | 'TOTAL_ENGAGEMENT_CUSTOM_QUANTITY'
    | 'TOTAL_ENGAGEMENT_ADD_TO_CART_QUANTITY'
    | 'TOTAL_ENGAGEMENT_LEAD_QUANTITY'
    | 'TOTAL_ENGAGEMENT_SEARCH_QUANTITY'
    | 'TOTAL_ENGAGEMENT_WATCH_VIDEO_QUANTITY'
    | 'TOTAL_ENGAGEMENT_VIEW_CATEGORY_QUANTITY'
    | 'TOTAL_ENGAGEMENT_APP_INSTALL_QUANTITY'
    | 'TOTAL_ENGAGEMENT_UNKNOWN_QUANTITY'
    | 'TOTAL_CLICK_PAGE_VISIT_QUANTITY'
    | 'TOTAL_CLICK_SIGNUP_QUANTITY'
    | 'TOTAL_CLICK_CHECKOUT_QUANTITY'
    | 'TOTAL_CLICK_CUSTOM_QUANTITY'
    | 'TOTAL_CLICK_ADD_TO_CART_QUANTITY'
    | 'TOTAL_CLICK_LEAD_QUANTITY'
    | 'TOTAL_CLICK_SEARCH_QUANTITY'
    | 'TOTAL_CLICK_WATCH_VIDEO_QUANTITY'
    | 'TOTAL_CLICK_VIEW_CATEGORY_QUANTITY'
    | 'TOTAL_CLICK_APP_INSTALL_QUANTITY'
    | 'TOTAL_CLICK_UNKNOWN_QUANTITY'
    | 'TOTAL_VIEW_PAGE_VISIT_QUANTITY'
    | 'TOTAL_VIEW_SIGNUP_QUANTITY'
    | 'TOTAL_VIEW_CHECKOUT_QUANTITY'
    | 'TOTAL_VIEW_CUSTOM_QUANTITY'
    | 'TOTAL_VIEW_ADD_TO_CART_QUANTITY'
    | 'TOTAL_VIEW_LEAD_QUANTITY'
    | 'TOTAL_VIEW_SEARCH_QUANTITY'
    | 'TOTAL_VIEW_WATCH_VIDEO_QUANTITY'
    | 'TOTAL_VIEW_VIEW_CATEGORY_QUANTITY'
    | 'TOTAL_VIEW_APP_INSTALL_QUANTITY'
    | 'TOTAL_VIEW_UNKNOWN_QUANTITY'
    | 'TOTAL_CONVERSIONS_QUANTITY'
    | 'COST_PER_CONVERSION_IN_DOLLAR'
    | 'TOTAL_WEB_SESSIONS'
    | 'WEB_SESSIONS_1'
    | 'WEB_SESSIONS_2'
    | 'APP_INSTALLS_CPA_BILLABLE'
    | 'APP_INSTALLS_CLICK'
    | 'APP_INSTALLS_CLOSEUPREPIN'
    | 'APP_INSTALLS_VIEW'
    | 'APP_INSTALLS'
    | 'APP_INSTALLS_ENGAGEMENT'
    | 'APP_INSTALLS_CLICK_1'
    | 'APP_INSTALLS_CLICK_2'
    | 'APP_INSTALLS_VIEW_1'
    | 'APP_INSTALLS_VIEW_2'
    | 'APP_INSTALLS_ENGAGEMENT_1'
    | 'APP_INSTALLS_ENGAGEMENT_2'
    | 'APP_INSTALLS_1'
    | 'APP_INSTALLS_2'
    | 'CPI_IN_MICRO_DOLLAR'
    | 'ECPI_IN_MICRO_DOLLAR'
    | 'CPI_IN_DOLLAR'
    | 'ECPI_IN_DOLLAR'
    | 'ONSITE_CHECKOUTS_CPA_BILLABLE_1'
    | 'ONSITE_CHECKOUTS_CPA_BILLABLE_2'
    | 'ONSITE_CHECKOUTS_CPA_BILLABLE'
    | 'ONSITE_CHECKOUTS_VALUE_1'
    | 'ONSITE_CHECKOUTS_VALUE_2'
    | 'ONSITE_CHECKOUTS_VALUE'
    | 'ONSITE_CHECKOUTS_1'
    | 'ONSITE_CHECKOUTS_2'
    | 'ONSITE_CHECKOUTS'
    | 'ONSITE_CHECKOUTS_VALUE_IN_MICRO_DOLLAR_1'
    | 'ONSITE_CHECKOUTS_VALUE_IN_MICRO_DOLLAR_2'
    | 'CONVERSION_RATE'
    | 'AVERAGE_CHECKOUT_VALUE'
    | 'RETURN_ON_ADVERTISER_SPEND'
    | 'BUY_BUTTON_CLICKS_1'
    | 'BUY_BUTTON_CLICKS_2'
    | 'TOTAL_BUY_BUTTON_CLICKS'
    | 'ORDER_DROPOFF_RATE'
    | 'ONSITE_CHECKOUTS_VALUE_IN_MICRO_DOLLAR'
    | 'ONSITE_CHECKOUTS_VALUE_IN_DOLLAR'
    | 'PIN_PROMOTION_NAME'
    | 'AD_NAME'
    | 'LIFETIME_IMPRESSION_USER_1'
    | 'PIN_PROMOTION_CAMPAIGN_ID'
    | 'PIN_PROMOTION_CAMPAIGN_NAME'
    | 'PIN_PROMOTION_CAMPAIGN_ACTION_TYPE'
    | 'TOTAL_LIFETIME_IMPRESSION_USER'
    | 'PIN_PROMOTION_CAMPAIGN_STATUS'
    | 'PIN_PROMOTION_CAMPAIGN_MANAGED_STATUS'
    | 'PIN_PROMOTION_CAMPAIGN_ENTITY_STATUS'
    | 'PIN_PROMOTION_AD_GROUP_ID'
    | 'PIN_PROMOTION_AD_GROUP_NAME'
    | 'PIN_PROMOTION_AD_GROUP_STATUS'
    | 'PIN_PROMOTION_AD_GROUP_ENTITY_STATUS'
    | 'PIN_PROMOTION_CREATIVE_TYPE'
    | 'PIN_PROMOTION_ENTITY_STATUS'
    | 'PIN_PROMOTION_CREATIVE_TYPE_V2'
    | 'PIN_PROMOTION_REVIEW_STATUS'
    | 'AD_GROUP_CAMPAIGN_ACTION_TYPE'
    | 'AD_GROUP_CAMPAIGN_ID'
    | 'AD_GROUP_CAMPAIGN_NAME'
    | 'AD_GROUP_CAMPAIGN_STATUS'
    | 'AD_GROUP_CREATIVE_TYPE'
    | 'AD_GROUP_CAMPAIGN_MANAGED_STATUS'
    | 'AD_GROUP_CAMPAIGN_ENTITY_STATUS'
    | 'AD_GROUP_START_DATE'
    | 'CAMPAIGN_LIFETIME_SPEND_CAP'
    | 'AD_GROUP_BID_IN_MICRO_CURRENCY'
    | 'CAMPAIGN_AD_GROUP_START_DATE'
    | 'CAMPAIGN_AD_GROUP_END_DATE'
    | 'CAMPAIGN_NUMBER_OF_AD_GROUPS'
    | 'AD_GROUP_NUMBER_OF_PIN_PROMOTIONS'
    | 'TODAY_SPEND_IN_LOCAL_CURRENCY'
    | 'TOTAL_LIFETIME_SPEND_IN_LOCAL_CURRENCY'
    | 'BUDGET_UTILIZATION'
    | 'AD_GROUP_OPTIMIZATION'
    | 'INSERTION_ORDER'
    | 'AD_GROUP_BONUS_BUDGET'
    | 'FREQUENCY'
    | 'CAMPAIGN_DAILY_SPEND_CAP'
    | 'CAMPAIGN_CREATIVE_TYPE'
    | 'AD_GROUP_PLACEMENT_GROUP_TYPE'
    | 'AD_GROUP_IS_PREFETCH_ENABLED'
    | 'CAMPAIGN_BUDGET_OPTIMIZATION'
    | 'CAMPAIGN_START_DATE'
    | 'IS_AUTOMATED_CAMPAIGN'
    | 'IS_PREMIERE_CAMPAIGN'
    | 'FLEXIBLE_DAILY_BUDGETS'
    | 'IS_PERFORMANCE_PLUS_CAMPAIGN'
    | 'IS_DCO_FORMAT_ENHANCMENT'
    | 'PERCENT_CROSS_DEVICE_CONVERSIONS'
    | 'PAGE_VISIT_PERCENT_CROSS_DEVICE_CONVERSIONS'
    | 'SIGNUP_PERCENT_CROSS_DEVICE_CONVERSIONS'
    | 'CHECKOUT_PERCENT_CROSS_DEVICE_CONVERSIONS'
    | 'CUSTOM_PERCENT_CROSS_DEVICE_CONVERSIONS'
    | 'ADD_TO_CART_PERCENT_CROSS_DEVICE_CONVERSIONS'
    | 'LEAD_PERCENT_CROSS_DEVICE_CONVERSIONS'
    | 'SEARCH_PERCENT_CROSS_DEVICE_CONVERSIONS'
    | 'WATCH_VIDEO_PERCENT_CROSS_DEVICE_CONVERSIONS'
    | 'VIEW_CATEGORY_PERCENT_CROSS_DEVICE_CONVERSIONS'
    | 'APP_INSTALL_PERCENT_CROSS_DEVICE_CONVERSIONS'
    | 'UNKNOWN_PERCENT_CROSS_DEVICE_CONVERSIONS'
    | 'TOTAL_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_DESKTOP_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_MOBILE_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_MOBILE_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_TABLET_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_TABLET_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_TABLET_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_PAGE_VISIT_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_PAGE_VISIT_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_PAGE_VISIT_DESKTOP_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_PAGE_VISIT_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_PAGE_VISIT_MOBILE_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_PAGE_VISIT_MOBILE_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_PAGE_VISIT_TABLET_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_PAGE_VISIT_TABLET_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_PAGE_VISIT_TABLET_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_SIGNUP_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_SIGNUP_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_SIGNUP_DESKTOP_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_SIGNUP_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_SIGNUP_MOBILE_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_SIGNUP_MOBILE_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_SIGNUP_TABLET_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_SIGNUP_TABLET_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_SIGNUP_TABLET_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_CHECKOUT_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_CHECKOUT_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_CHECKOUT_DESKTOP_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_CHECKOUT_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_CHECKOUT_MOBILE_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_CHECKOUT_MOBILE_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_CHECKOUT_TABLET_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_CHECKOUT_TABLET_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_CHECKOUT_TABLET_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_CUSTOM_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_CUSTOM_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_CUSTOM_DESKTOP_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_CUSTOM_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_CUSTOM_MOBILE_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_CUSTOM_MOBILE_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_CUSTOM_TABLET_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_CUSTOM_TABLET_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_CUSTOM_TABLET_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_ADD_TO_CART_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_ADD_TO_CART_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_ADD_TO_CART_DESKTOP_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_ADD_TO_CART_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_ADD_TO_CART_MOBILE_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_ADD_TO_CART_MOBILE_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_ADD_TO_CART_TABLET_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_ADD_TO_CART_TABLET_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_ADD_TO_CART_TABLET_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_LEAD_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_LEAD_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_LEAD_DESKTOP_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_LEAD_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_LEAD_MOBILE_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_LEAD_MOBILE_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_LEAD_TABLET_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_LEAD_TABLET_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_LEAD_TABLET_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_SEARCH_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_SEARCH_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_SEARCH_DESKTOP_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_SEARCH_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_SEARCH_MOBILE_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_SEARCH_MOBILE_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_SEARCH_TABLET_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_SEARCH_TABLET_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_SEARCH_TABLET_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_WATCH_VIDEO_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_WATCH_VIDEO_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_WATCH_VIDEO_DESKTOP_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_WATCH_VIDEO_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_WATCH_VIDEO_MOBILE_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_WATCH_VIDEO_MOBILE_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_WATCH_VIDEO_TABLET_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_WATCH_VIDEO_TABLET_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_WATCH_VIDEO_TABLET_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_VIEW_CATEGORY_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_VIEW_CATEGORY_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_VIEW_CATEGORY_DESKTOP_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_VIEW_CATEGORY_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_VIEW_CATEGORY_MOBILE_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_VIEW_CATEGORY_MOBILE_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_VIEW_CATEGORY_TABLET_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_VIEW_CATEGORY_TABLET_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_VIEW_CATEGORY_TABLET_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_APP_INSTALL_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_APP_INSTALL_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_APP_INSTALL_DESKTOP_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_APP_INSTALL_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_APP_INSTALL_MOBILE_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_APP_INSTALL_MOBILE_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_APP_INSTALL_TABLET_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_APP_INSTALL_TABLET_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_APP_INSTALL_TABLET_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_UNKNOWN_DESKTOP_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_UNKNOWN_DESKTOP_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_UNKNOWN_DESKTOP_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_UNKNOWN_MOBILE_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_UNKNOWN_MOBILE_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_UNKNOWN_MOBILE_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_UNKNOWN_TABLET_ACTION_TO_DESKTOP_CONVERSION'
    | 'TOTAL_UNKNOWN_TABLET_ACTION_TO_MOBILE_CONVERSION'
    | 'TOTAL_UNKNOWN_TABLET_ACTION_TO_TABLET_CONVERSION'
    | 'TOTAL_PAGE_VISIT'
    | 'TOTAL_SIGNUP'
    | 'TOTAL_CHECKOUT'
    | 'TOTAL_CUSTOM'
    | 'TOTAL_ADD_TO_CART'
    | 'TOTAL_LEAD'
    | 'TOTAL_SEARCH'
    | 'TOTAL_WATCH_VIDEO'
    | 'TOTAL_VIEW_CATEGORY'
    | 'TOTAL_APP_INSTALL'
    | 'TOTAL_UNKNOWN'
    | 'TOTAL_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_LEAD_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_SEARCH_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
    | 'AVERAGE_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'
    | 'AVERAGE_SIGNUP_VALUE_IN_MICRO_DOLLAR'
    | 'AVERAGE_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
    | 'AVERAGE_CUSTOM_VALUE_IN_MICRO_DOLLAR'
    | 'AVERAGE_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
    | 'AVERAGE_LEAD_VALUE_IN_MICRO_DOLLAR'
    | 'AVERAGE_SEARCH_VALUE_IN_MICRO_DOLLAR'
    | 'AVERAGE_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'
    | 'AVERAGE_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'
    | 'AVERAGE_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
    | 'AVERAGE_PAGE_VISIT_VALUE_IN_MICRO_US_DOLLAR'
    | 'AVERAGE_SIGNUP_VALUE_IN_MICRO_US_DOLLAR'
    | 'AVERAGE_CHECKOUT_VALUE_IN_MICRO_US_DOLLAR'
    | 'AVERAGE_CUSTOM_VALUE_IN_MICRO_US_DOLLAR'
    | 'AVERAGE_ADD_TO_CART_VALUE_IN_MICRO_US_DOLLAR'
    | 'AVERAGE_LEAD_VALUE_IN_MICRO_US_DOLLAR'
    | 'AVERAGE_SEARCH_VALUE_IN_MICRO_US_DOLLAR'
    | 'AVERAGE_WATCH_VIDEO_VALUE_IN_MICRO_US_DOLLAR'
    | 'AVERAGE_VIEW_CATEGORY_VALUE_IN_MICRO_US_DOLLAR'
    | 'AVERAGE_UNKNOWN_VALUE_IN_MICRO_US_DOLLAR'
    | 'TOTAL_PAGE_VISIT_VALUE_IN_MICRO_US_DOLLAR'
    | 'TOTAL_SIGNUP_VALUE_IN_MICRO_US_DOLLAR'
    | 'TOTAL_CHECKOUT_VALUE_IN_MICRO_US_DOLLAR'
    | 'TOTAL_CUSTOM_VALUE_IN_MICRO_US_DOLLAR'
    | 'TOTAL_ADD_TO_CART_VALUE_IN_MICRO_US_DOLLAR'
    | 'TOTAL_LEAD_VALUE_IN_MICRO_US_DOLLAR'
    | 'TOTAL_SEARCH_VALUE_IN_MICRO_US_DOLLAR'
    | 'TOTAL_WATCH_VIDEO_VALUE_IN_MICRO_US_DOLLAR'
    | 'TOTAL_VIEW_CATEGORY_VALUE_IN_MICRO_US_DOLLAR'
    | 'TOTAL_UNKNOWN_VALUE_IN_MICRO_US_DOLLAR'
    | 'TOTAL_PAGE_VISIT_QUANTITY'
    | 'TOTAL_SIGNUP_QUANTITY'
    | 'TOTAL_CHECKOUT_QUANTITY'
    | 'TOTAL_CUSTOM_QUANTITY'
    | 'TOTAL_ADD_TO_CART_QUANTITY'
    | 'TOTAL_LEAD_QUANTITY'
    | 'TOTAL_SEARCH_QUANTITY'
    | 'TOTAL_WATCH_VIDEO_QUANTITY'
    | 'TOTAL_VIEW_CATEGORY_QUANTITY'
    | 'TOTAL_APP_INSTALL_QUANTITY'
    | 'TOTAL_UNKNOWN_QUANTITY'
    | 'TOTAL_PAGE_VISIT_VALUE_IN_DOLLAR'
    | 'TOTAL_SIGNUP_VALUE_IN_DOLLAR'
    | 'TOTAL_CHECKOUT_VALUE_IN_DOLLAR'
    | 'TOTAL_CUSTOM_VALUE_IN_DOLLAR'
    | 'TOTAL_ADD_TO_CART_VALUE_IN_DOLLAR'
    | 'TOTAL_LEAD_VALUE_IN_DOLLAR'
    | 'TOTAL_SEARCH_VALUE_IN_DOLLAR'
    | 'TOTAL_WATCH_VIDEO_VALUE_IN_DOLLAR'
    | 'TOTAL_VIEW_CATEGORY_VALUE_IN_DOLLAR'
    | 'TOTAL_APP_INSTALL_VALUE_IN_DOLLAR'
    | 'TOTAL_UNKNOWN_VALUE_IN_DOLLAR'
    | 'PAGE_VISIT_COST_PER_ACTION'
    | 'SIGNUP_COST_PER_ACTION'
    | 'CHECKOUT_COST_PER_ACTION'
    | 'CUSTOM_COST_PER_ACTION'
    | 'ADD_TO_CART_COST_PER_ACTION'
    | 'LEAD_COST_PER_ACTION'
    | 'SEARCH_COST_PER_ACTION'
    | 'WATCH_VIDEO_COST_PER_ACTION'
    | 'VIEW_CATEGORY_COST_PER_ACTION'
    | 'APP_INSTALL_COST_PER_ACTION'
    | 'UNKNOWN_COST_PER_ACTION'
    | 'AD_GROUP_CPA_IN_MICRO_CURRENCY'
    | 'PAGE_VISIT_COST_PER_ACTION_IN_US_DOLLAR'
    | 'SIGNUP_COST_PER_ACTION_IN_US_DOLLAR'
    | 'CHECKOUT_COST_PER_ACTION_IN_US_DOLLAR'
    | 'CUSTOM_COST_PER_ACTION_IN_US_DOLLAR'
    | 'ADD_TO_CART_COST_PER_ACTION_IN_US_DOLLAR'
    | 'LEAD_COST_PER_ACTION_IN_US_DOLLAR'
    | 'SEARCH_COST_PER_ACTION_IN_US_DOLLAR'
    | 'WATCH_VIDEO_COST_PER_ACTION_IN_US_DOLLAR'
    | 'VIEW_CATEGORY_COST_PER_ACTION_IN_US_DOLLAR'
    | 'UNKNOWN_COST_PER_ACTION_IN_US_DOLLAR'
    | 'PAGE_VISIT_ROAS'
    | 'SIGNUP_ROAS'
    | 'CHECKOUT_ROAS'
    | 'CUSTOM_ROAS'
    | 'ADD_TO_CART_ROAS'
    | 'LEAD_ROAS'
    | 'SEARCH_ROAS'
    | 'WATCH_VIDEO_ROAS'
    | 'VIEW_CATEGORY_ROAS'
    | 'APP_INSTALL_ROAS'
    | 'UNKNOWN_ROAS'
    | 'ROAS'
    | 'CLICK_ROAS'
    | 'ENGAGEMENT_ROAS'
    | 'VIEW_ROAS'
    | 'HOUR'
    | 'BOARD_ENGAGEMENT'
    | 'BOARD_INSERTION'
    | 'BOARD_IMPRESSION'
    | 'BOARD_FOLLOW'
    | 'BOARD_SEND'
    | 'BOARD_HIDE'
    | 'PRODUCT_GROUP_CAMPAIGN_ID'
    | 'PRODUCT_GROUP_CAMPAIGN_NAME'
    | 'PRODUCT_GROUP_CAMPAIGN_ACTION_TYPE'
    | 'PRODUCT_GROUP_CAMPAIGN_STATUS'
    | 'PRODUCT_GROUP_CAMPAIGN_MANAGED_STATUS'
    | 'PRODUCT_GROUP_AD_GROUP_ID'
    | 'PRODUCT_GROUP_AD_GROUP_NAME'
    | 'PRODUCT_GROUP_AD_GROUP_STATUS'
    | 'PROMOTED_CATALOG_PRODUCT_GROUP_REFERENCE_ID'
    | 'PROMOTED_CATALOG_PRODUCT_GROUP_REFERENCE_NAME'
    | 'PROMOTED_CATALOG_PRODUCT_GROUP_ID'
    | 'PROMOTED_CATALOG_PRODUCT_GROUP_BID_IN_MICRO_CURRENCY'
    | 'PROMOTED_CATALOG_PRODUCT_GROUP_STATUS'
    | 'PROMOTED_CATALOG_PRODUCT_GROUP_ENTITY_STATUS'
    | 'PROMOTED_CATALOG_PRODUCT_GROUP_CAMPAIGN_ID'
    | 'PROMOTED_CATALOG_PRODUCT_GROUP_CAMPAIGN_NAME'
    | 'PROMOTED_CATALOG_PRODUCT_GROUP_CAMPAIGN_ACTION_TYPE'
    | 'PROMOTED_CATALOG_PRODUCT_GROUP_CAMPAIGN_STATUS'
    | 'PROMOTED_CATALOG_PRODUCT_GROUP_CAMPAIGN_MANAGED_STATUS'
    | 'PROMOTED_CATALOG_PRODUCT_GROUP_AD_GROUP_ID'
    | 'PROMOTED_CATALOG_PRODUCT_GROUP_AD_GROUP_NAME'
    | 'PROMOTED_CATALOG_PRODUCT_GROUP_AD_GROUP_STATUS'
    | 'PROMOTED_CATALOG_PRODUCT_GROUP_TRACKING_TEMPLATE_URL'
    | 'VIDEO_3SEC_VIEWS_1'
    | 'VIDEO_P0_COMPLETE_1'
    | 'VIDEO_P25_COMPLETE_1'
    | 'VIDEO_P50_COMPLETE_1'
    | 'VIDEO_P75_COMPLETE_1'
    | 'VIDEO_P95_COMPLETE_1'
    | 'VIDEO_P97_COMPLETE_1'
    | 'VIDEO_P100_COMPLETE_1'
    | 'VIDEO_P0_COMBINED_1'
    | 'VIDEO_P25_COMBINED_1'
    | 'VIDEO_P50_COMBINED_1'
    | 'VIDEO_P75_COMBINED_1'
    | 'VIDEO_P95_COMBINED_1'
    | 'VIDEO_P97_COMBINED_1'
    | 'VIDEO_P100_COMBINED_1'
    | 'VIDEO_AVG_WATCHTIME_1'
    | 'VIDEO_MRC_VIEWS_1'
    | 'VIDEO_VIEW_RATE_1'
    | 'VIDEO_3SEC_VIEWS_2'
    | 'VIDEO_P0_COMPLETE_2'
    | 'VIDEO_P25_COMPLETE_2'
    | 'VIDEO_P50_COMPLETE_2'
    | 'VIDEO_P75_COMPLETE_2'
    | 'VIDEO_P95_COMPLETE_2'
    | 'VIDEO_P97_COMPLETE_2'
    | 'VIDEO_P100_COMPLETE_2'
    | 'VIDEO_P0_COMBINED_2'
    | 'VIDEO_P25_COMBINED_2'
    | 'VIDEO_P50_COMBINED_2'
    | 'VIDEO_P75_COMBINED_2'
    | 'VIDEO_P95_COMBINED_2'
    | 'VIDEO_P97_COMBINED_2'
    | 'VIDEO_P100_COMBINED_2'
    | 'VIDEO_AVG_WATCHTIME_2'
    | 'VIDEO_MRC_VIEWS_2'
    | 'VIDEO_VIEW_RATE_2'
    | 'PAID_VIDEO_VIEW'
    | 'PAID_VIDEO_IMPRESSION'
    | 'PAID_VIDEO_VIEWABLE_RATE'
    | 'VIDEO_LENGTH'
    | 'CPV_IN_MICRO_DOLLAR'
    | 'CPV_IN_DOLLAR'
    | 'CP3SV_IN_MICRO_DOLLAR'
    | 'CP3SV_IN_DOLLAR'
    | 'ECPV_IN_MICRO_DOLLAR'
    | 'ECPV_IN_DOLLAR'
    | 'ECP3SV_IN_MICRO_DOLLAR'
    | 'ECP3SV_IN_DOLLAR'
    | 'CPCV_IN_DOLLAR'
    | 'CPCV_IN_MICRO_DOLLAR'
    | 'ECPCV_IN_DOLLAR'
    | 'ECPCV_IN_MICRO_DOLLAR'
    | 'CPCV_P95_IN_DOLLAR'
    | 'CPCV_P95_IN_MICRO_DOLLAR'
    | 'ECPCV_P95_IN_DOLLAR'
    | 'ECPCV_P95_IN_MICRO_DOLLAR'
    | 'TOTAL_VIDEO_3SEC_VIEWS'
    | 'TOTAL_VIDEO_P0_COMPLETE'
    | 'TOTAL_VIDEO_P25_COMPLETE'
    | 'TOTAL_VIDEO_P50_COMPLETE'
    | 'TOTAL_VIDEO_P75_COMPLETE'
    | 'TOTAL_VIDEO_P95_COMPLETE'
    | 'TOTAL_VIDEO_P97_COMPLETE'
    | 'TOTAL_VIDEO_P100_COMPLETE'
    | 'TOTAL_VIDEO_P0_COMBINED'
    | 'TOTAL_VIDEO_P25_COMBINED'
    | 'TOTAL_VIDEO_P50_COMBINED'
    | 'TOTAL_VIDEO_P75_COMBINED'
    | 'TOTAL_VIDEO_P95_COMBINED'
    | 'TOTAL_VIDEO_P97_COMBINED'
    | 'TOTAL_VIDEO_P100_COMBINED'
    | 'TOTAL_VIDEO_AVG_WATCHTIME'
    | 'TOTAL_VIDEO_MRC_VIEWS'
    | 'TOTAL_VIDEO_VIEW_RATE'
    | 'VIDEO_V50_WATCHTIME_1'
    | 'VIDEO_V50_WATCHTIME_2'
    | 'TOTAL_VIDEO_V50_WATCHTIME'
    | 'VIDEO_SUM_V50_WATCHTIME_IN_MILLISECOND_1'
    | 'VIDEO_SUM_V50_WATCHTIME_IN_MILLISECOND_2'
    | 'TOTAL_VIDEO_SUM_V50_WATCHTIME_IN_MILLISECOND'
    | 'VIDEO_SUM_V50_WATCHTIME_IN_SECOND_1'
    | 'VIDEO_SUM_V50_WATCHTIME_IN_SECOND_2'
    | 'TOTAL_VIDEO_SUM_V50_WATCHTIME_IN_SECOND'
    | 'VIDEO_AVG_WATCHTIME_IN_MILLISECOND_1'
    | 'VIDEO_AVG_WATCHTIME_IN_MILLISECOND_2'
    | 'TOTAL_VIDEO_AVG_WATCHTIME_IN_MILLISECOND'
    | 'VIDEO_AVG_WATCHTIME_IN_SECOND_1'
    | 'VIDEO_AVG_WATCHTIME_IN_SECOND_2'
    | 'TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'
    | 'DELIVERY_STATUS_NO_FANOUT'
    | 'DELIVERY_STATUS_WITH_FANOUT'
    | 'KEYWORD_COMPETITION_BAND'
    | 'KEYWORD_QUERY_VOLUME'
    | 'KEYWORD_VALUE'
    | 'KEYWORD_MATCH_TYPE'
    | 'KEYWORD_BID_IN_MICRO_CURRENCY'
    | 'KEYWORD_USER_QUERY'
    | 'KEYWORD_SQR_KEYWORD_VALUE'
    | 'KEYWORD_AD_GROUP_ID'
    | 'KEYWORD_AD_GROUP_NAME'
    | 'KEYWORD_CAMPAIGN_ID'
    | 'KEYWORD_CAMPAIGN_NAME'
    | 'KEYWORD_SEARCH_TERM_AD_GROUP_ID'
    | 'KEYWORD_SEARCH_TERM_AD_GROUP_NAME'
    | 'KEYWORD_SEARCH_TERM_CAMPAIGN_ID'
    | 'KEYWORD_SEARCH_TERM_CAMPAIGN_NAME'
    | 'NEGATIVE_KEYWORD_AD_GROUP_ID'
    | 'NEGATIVE_KEYWORD_AD_GROUP_NAME'
    | 'NEGATIVE_KEYWORD_CAMPAIGN_ID'
    | 'NEGATIVE_KEYWORD_CAMPAIGN_NAME'
    | 'ONE_TAP_V2_WEBSITE_VIEW_1'
    | 'ONE_TAP_V2_WEBSITE_VIEW_2'
    | 'TOTAL_ONE_TAP_V2_WEBSITE_VIEW'
    | 'ONE_TAP_V2_WEBSITE_VIEW_USER_1'
    | 'ONE_TAP_V2_WEBSITE_VIEW_USER_2'
    | 'TOTAL_LANDING_PAGE_VIEWS'
    | 'LANDING_PAGE_VIEWS_1'
    | 'LANDING_PAGE_VIEWS_2'
    | 'COST_PER_LANDING_PAGE_VIEW'
    | 'LANDING_PAGE_VIEW_RATE'
    | 'TOTAL_DESTINATION_VIEWS'
    | 'DESTINATION_VIEWS_1'
    | 'DESTINATION_VIEWS_2'
    | 'COST_PER_DESTINATION_VIEW_IN_DOLLAR'
    | 'COST_PER_DESTINATION_VIEW_IN_MICRO_DOLLAR'
    | 'DESTINATION_VIEW_RATE'
    | 'CAROUSEL_SLOT_INDEX'
    | 'CAROUSEL_ID'
    | 'CAROUSEL_SLOT_PROMOTION_ID'
    | 'CAROUSEL_SLOT_IMPRESSION_1'
    | 'CAROUSEL_SLOT_IMPRESSION_2'
    | 'TOTAL_CAROUSEL_SLOT_IMPRESSION'
    | 'CAROUSEL_SLOT_IMPRESSION_USER_1'
    | 'CAROUSEL_SLOT_IMPRESSION_USER_2'
    | 'CAROUSEL_SLOT_CLICKTHROUGH_1'
    | 'CAROUSEL_SLOT_CLICKTHROUGH_2'
    | 'TOTAL_CAROUSEL_SLOT_CLICKTHROUGH'
    | 'CAROUSEL_SLOT_CLICKTHROUGH_USER_1'
    | 'CAROUSEL_SLOT_CLICKTHROUGH_USER_2'
    | 'CAROUSEL_SLOT_SIDESWIPE_1'
    | 'CAROUSEL_SLOT_SIDESWIPE_2'
    | 'TOTAL_CAROUSEL_SLOT_SIDESWIPE'
    | 'CAROUSEL_SLOT_SIDESWIPE_USER_1'
    | 'CAROUSEL_SLOT_SIDESWIPE_USER_2'
    | 'CAROUSEL_SLOT_VIEW_WEBSITE_1'
    | 'CAROUSEL_SLOT_VIEW_WEBSITE_2'
    | 'TOTAL_CAROUSEL_SLOT_VIEW_WEBSITE'
    | 'CAROUSEL_SLOT_VIEW_WEBSITE_USER_1'
    | 'CAROUSEL_SLOT_VIEW_WEBSITE_USER_2'
    | 'COLLECTION_PIN_ITEM_IMPRESSION_1'
    | 'COLLECTION_PIN_ITEM_IMPRESSION_2'
    | 'TOTAL_COLLECTION_PIN_ITEM_IMPRESSION'
    | 'COLLECTION_PIN_ITEM_CLICKTHROUGH_1'
    | 'COLLECTION_PIN_ITEM_CLICKTHROUGH_2'
    | 'TOTAL_COLLECTION_PIN_ITEM_CLICKTHROUGH'
    | 'HOLDOUT_EXPERIMENT'
    | 'AD_GROUP_HOLDOUT_EXPERIMENT'
    | 'PIN_PROMOTION_HOLDOUT_EXPERIMENT'
    | 'MULTI_OBJECTIVE_RESULT'
    | 'MULTI_OBJECTIVE_COST'
    | 'MULTI_OBJECTIVE_RESULT_DESCRIPTION'
    | 'MULTI_OBJECTIVE_COST_DESCRIPTION'
    | 'DATE_RANGE'
    | 'DATE_RANGE_START'
    | 'DATE_RANGE_END'
    | 'REPORT_DATE_START'
    | 'REPORT_DATE_END'
    | 'PINNER_LIST_NAME'
    | 'PINNER_LIST_TYPE'
    | 'ORDER_VALUE'
    | 'ORDER_QUANTITY'
    | 'ADVERTISER_NAME'
    | 'ADVERTISER_CURRENCY'
    | 'TOTAL_REPIN_RATE'
    | 'SPEND_YESTERDAY_IN_DOLLAR'
    | 'PIN_PROMOTION_REJECTION_LABELS'
    | 'PIN_PROMOTION_DESTINATION_URL'
    | 'VIDEO_COMPLETION_RATE'
    | 'CAMPAIGN_BOOKING_REFERENCE'
    | 'WEB_CHECKOUT_COST_PER_ACTION'
    | 'WEB_CHECKOUT_ROAS'
    | 'TOTAL_WEB_CHECKOUT'
    | 'TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_CHECKOUT_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_CLICK_CHECKOUT'
    | 'TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT'
    | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_VIEW_CHECKOUT'
    | 'TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_DOLLAR'
    | 'INAPP_CHECKOUT_COST_PER_ACTION'
    | 'INAPP_CHECKOUT_ROAS'
    | 'TOTAL_INAPP_CHECKOUT'
    | 'TOTAL_INAPP_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_CHECKOUT_VALUE_IN_DOLLAR'
    | 'TOTAL_INAPP_CLICK_CHECKOUT'
    | 'TOTAL_INAPP_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_CLICK_CHECKOUT_VALUE_IN_DOLLAR'
    | 'TOTAL_INAPP_ENGAGEMENT_CHECKOUT'
    | 'TOTAL_INAPP_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_ENGAGEMENT_CHECKOUT_VALUE_IN_DOLLAR'
    | 'TOTAL_INAPP_VIEW_CHECKOUT'
    | 'TOTAL_INAPP_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_VIEW_CHECKOUT_VALUE_IN_DOLLAR'
    | 'OFFLINE_CHECKOUT_COST_PER_ACTION'
    | 'OFFLINE_CHECKOUT_ROAS'
    | 'TOTAL_OFFLINE_CHECKOUT'
    | 'TOTAL_OFFLINE_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_CHECKOUT_VALUE_IN_DOLLAR'
    | 'TOTAL_OFFLINE_CLICK_CHECKOUT'
    | 'TOTAL_OFFLINE_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_CLICK_CHECKOUT_VALUE_IN_DOLLAR'
    | 'TOTAL_OFFLINE_ENGAGEMENT_CHECKOUT'
    | 'TOTAL_OFFLINE_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_ENGAGEMENT_CHECKOUT_VALUE_IN_DOLLAR'
    | 'TOTAL_OFFLINE_VIEW_CHECKOUT'
    | 'TOTAL_OFFLINE_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_VIEW_CHECKOUT_VALUE_IN_DOLLAR'
    | 'PINTEREST_CHECKOUT_COST_PER_ACTION'
    | 'PINTEREST_CHECKOUT_ROAS'
    | 'TOTAL_PINTEREST_CHECKOUT'
    | 'TOTAL_PINTEREST_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_PINTEREST_CHECKOUT_VALUE_IN_DOLLAR'
    | 'WEB_ADD_TO_CART_COST_PER_ACTION'
    | 'WEB_ADD_TO_CART_ROAS'
    | 'TOTAL_WEB_ADD_TO_CART'
    | 'TOTAL_WEB_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_ADD_TO_CART_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_CLICK_ADD_TO_CART'
    | 'TOTAL_WEB_CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_CLICK_ADD_TO_CART_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_ADD_TO_CART'
    | 'TOTAL_WEB_ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_VIEW_ADD_TO_CART'
    | 'TOTAL_WEB_VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_VIEW_ADD_TO_CART_VALUE_IN_DOLLAR'
    | 'INAPP_ADD_TO_CART_COST_PER_ACTION'
    | 'INAPP_ADD_TO_CART_ROAS'
    | 'TOTAL_INAPP_ADD_TO_CART'
    | 'TOTAL_INAPP_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_ADD_TO_CART_VALUE_IN_DOLLAR'
    | 'TOTAL_INAPP_CLICK_ADD_TO_CART'
    | 'TOTAL_INAPP_CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_CLICK_ADD_TO_CART_VALUE_IN_DOLLAR'
    | 'TOTAL_INAPP_ENGAGEMENT_ADD_TO_CART'
    | 'TOTAL_INAPP_ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_ENGAGEMENT_ADD_TO_CART_VALUE_IN_DOLLAR'
    | 'TOTAL_INAPP_VIEW_ADD_TO_CART'
    | 'TOTAL_INAPP_VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_VIEW_ADD_TO_CART_VALUE_IN_DOLLAR'
    | 'WEB_PAGE_VISIT_COST_PER_ACTION'
    | 'WEB_PAGE_VISIT_ROAS'
    | 'TOTAL_WEB_PAGE_VISIT'
    | 'TOTAL_WEB_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_PAGE_VISIT_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_CLICK_PAGE_VISIT'
    | 'TOTAL_WEB_CLICK_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_CLICK_PAGE_VISIT_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_PAGE_VISIT'
    | 'TOTAL_WEB_ENGAGEMENT_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_PAGE_VISIT_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_VIEW_PAGE_VISIT'
    | 'TOTAL_WEB_VIEW_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_VIEW_PAGE_VISIT_VALUE_IN_DOLLAR'
    | 'WEB_SIGNUP_COST_PER_ACTION'
    | 'WEB_SIGNUP_ROAS'
    | 'TOTAL_WEB_SIGNUP'
    | 'TOTAL_WEB_SIGNUP_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_SIGNUP_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_CLICK_SIGNUP'
    | 'TOTAL_WEB_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_CLICK_SIGNUP_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_SIGNUP'
    | 'TOTAL_WEB_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_SIGNUP_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_VIEW_SIGNUP'
    | 'TOTAL_WEB_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_VIEW_SIGNUP_VALUE_IN_DOLLAR'
    | 'INAPP_SIGNUP_COST_PER_ACTION'
    | 'INAPP_SIGNUP_ROAS'
    | 'TOTAL_INAPP_SIGNUP'
    | 'TOTAL_INAPP_SIGNUP_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_SIGNUP_VALUE_IN_DOLLAR'
    | 'TOTAL_INAPP_CLICK_SIGNUP'
    | 'TOTAL_INAPP_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_CLICK_SIGNUP_VALUE_IN_DOLLAR'
    | 'TOTAL_INAPP_ENGAGEMENT_SIGNUP'
    | 'TOTAL_INAPP_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_ENGAGEMENT_SIGNUP_VALUE_IN_DOLLAR'
    | 'TOTAL_INAPP_VIEW_SIGNUP'
    | 'TOTAL_INAPP_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_VIEW_SIGNUP_VALUE_IN_DOLLAR'
    | 'OFFLINE_SIGNUP_COST_PER_ACTION'
    | 'OFFLINE_SIGNUP_ROAS'
    | 'TOTAL_OFFLINE_SIGNUP'
    | 'TOTAL_OFFLINE_SIGNUP_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_SIGNUP_VALUE_IN_DOLLAR'
    | 'TOTAL_OFFLINE_CLICK_SIGNUP'
    | 'TOTAL_OFFLINE_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_CLICK_SIGNUP_VALUE_IN_DOLLAR'
    | 'TOTAL_OFFLINE_ENGAGEMENT_SIGNUP'
    | 'TOTAL_OFFLINE_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_ENGAGEMENT_SIGNUP_VALUE_IN_DOLLAR'
    | 'TOTAL_OFFLINE_VIEW_SIGNUP'
    | 'TOTAL_OFFLINE_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_VIEW_SIGNUP_VALUE_IN_DOLLAR'
    | 'WEB_WATCH_VIDEO_COST_PER_ACTION'
    | 'WEB_WATCH_VIDEO_ROAS'
    | 'TOTAL_WEB_WATCH_VIDEO'
    | 'TOTAL_WEB_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_WATCH_VIDEO_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_CLICK_WATCH_VIDEO'
    | 'TOTAL_WEB_CLICK_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_CLICK_WATCH_VIDEO_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_WATCH_VIDEO'
    | 'TOTAL_WEB_ENGAGEMENT_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_WATCH_VIDEO_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_VIEW_WATCH_VIDEO'
    | 'TOTAL_WEB_VIEW_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_VIEW_WATCH_VIDEO_VALUE_IN_DOLLAR'
    | 'WEB_LEAD_COST_PER_ACTION'
    | 'WEB_LEAD_ROAS'
    | 'TOTAL_WEB_LEAD'
    | 'TOTAL_WEB_LEAD_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_LEAD_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_CLICK_LEAD'
    | 'TOTAL_WEB_CLICK_LEAD_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_CLICK_LEAD_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_LEAD'
    | 'TOTAL_WEB_ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_LEAD_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_VIEW_LEAD'
    | 'TOTAL_WEB_VIEW_LEAD_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_VIEW_LEAD_VALUE_IN_DOLLAR'
    | 'OFFLINE_LEAD_COST_PER_ACTION'
    | 'OFFLINE_LEAD_ROAS'
    | 'TOTAL_OFFLINE_LEAD'
    | 'TOTAL_OFFLINE_LEAD_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_LEAD_VALUE_IN_DOLLAR'
    | 'TOTAL_OFFLINE_CLICK_LEAD'
    | 'TOTAL_OFFLINE_CLICK_LEAD_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_CLICK_LEAD_VALUE_IN_DOLLAR'
    | 'TOTAL_OFFLINE_ENGAGEMENT_LEAD'
    | 'TOTAL_OFFLINE_ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_ENGAGEMENT_LEAD_VALUE_IN_DOLLAR'
    | 'TOTAL_OFFLINE_VIEW_LEAD'
    | 'TOTAL_OFFLINE_VIEW_LEAD_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_VIEW_LEAD_VALUE_IN_DOLLAR'
    | 'WEB_SEARCH_COST_PER_ACTION'
    | 'WEB_SEARCH_ROAS'
    | 'TOTAL_WEB_SEARCH'
    | 'TOTAL_WEB_SEARCH_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_SEARCH_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_CLICK_SEARCH'
    | 'TOTAL_WEB_CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_CLICK_SEARCH_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_SEARCH'
    | 'TOTAL_WEB_ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_SEARCH_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_VIEW_SEARCH'
    | 'TOTAL_WEB_VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_VIEW_SEARCH_VALUE_IN_DOLLAR'
    | 'INAPP_SEARCH_COST_PER_ACTION'
    | 'INAPP_SEARCH_ROAS'
    | 'TOTAL_INAPP_SEARCH'
    | 'TOTAL_INAPP_SEARCH_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_SEARCH_VALUE_IN_DOLLAR'
    | 'TOTAL_INAPP_CLICK_SEARCH'
    | 'TOTAL_INAPP_CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_CLICK_SEARCH_VALUE_IN_DOLLAR'
    | 'TOTAL_INAPP_ENGAGEMENT_SEARCH'
    | 'TOTAL_INAPP_ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_ENGAGEMENT_SEARCH_VALUE_IN_DOLLAR'
    | 'TOTAL_INAPP_VIEW_SEARCH'
    | 'TOTAL_INAPP_VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_VIEW_SEARCH_VALUE_IN_DOLLAR'
    | 'WEB_VIEW_CATEGORY_COST_PER_ACTION'
    | 'WEB_VIEW_CATEGORY_ROAS'
    | 'TOTAL_WEB_VIEW_CATEGORY'
    | 'TOTAL_WEB_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_VIEW_CATEGORY_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_CLICK_VIEW_CATEGORY'
    | 'TOTAL_WEB_CLICK_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_CLICK_VIEW_CATEGORY_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_VIEW_CATEGORY'
    | 'TOTAL_WEB_ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_VIEW_VIEW_CATEGORY'
    | 'TOTAL_WEB_VIEW_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_VIEW_VIEW_CATEGORY_VALUE_IN_DOLLAR'
    | 'WEB_CUSTOM_COST_PER_ACTION'
    | 'WEB_CUSTOM_ROAS'
    | 'TOTAL_WEB_CUSTOM'
    | 'TOTAL_WEB_CUSTOM_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_CUSTOM_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_CLICK_CUSTOM'
    | 'TOTAL_WEB_CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_CLICK_CUSTOM_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_CUSTOM'
    | 'TOTAL_WEB_ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_CUSTOM_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_VIEW_CUSTOM'
    | 'TOTAL_WEB_VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_VIEW_CUSTOM_VALUE_IN_DOLLAR'
    | 'OFFLINE_CUSTOM_COST_PER_ACTION'
    | 'OFFLINE_CUSTOM_ROAS'
    | 'TOTAL_OFFLINE_CUSTOM'
    | 'TOTAL_OFFLINE_CUSTOM_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_CUSTOM_VALUE_IN_DOLLAR'
    | 'TOTAL_OFFLINE_CLICK_CUSTOM'
    | 'TOTAL_OFFLINE_CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_CLICK_CUSTOM_VALUE_IN_DOLLAR'
    | 'TOTAL_OFFLINE_ENGAGEMENT_CUSTOM'
    | 'TOTAL_OFFLINE_ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_ENGAGEMENT_CUSTOM_VALUE_IN_DOLLAR'
    | 'TOTAL_OFFLINE_VIEW_CUSTOM'
    | 'TOTAL_OFFLINE_VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_VIEW_CUSTOM_VALUE_IN_DOLLAR'
    | 'WEB_UNKNOWN_COST_PER_ACTION'
    | 'WEB_UNKNOWN_ROAS'
    | 'TOTAL_WEB_UNKNOWN'
    | 'TOTAL_WEB_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_UNKNOWN_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_CLICK_UNKNOWN'
    | 'TOTAL_WEB_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_CLICK_UNKNOWN_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_UNKNOWN'
    | 'TOTAL_WEB_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_ENGAGEMENT_UNKNOWN_VALUE_IN_DOLLAR'
    | 'TOTAL_WEB_VIEW_UNKNOWN'
    | 'TOTAL_WEB_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_WEB_VIEW_UNKNOWN_VALUE_IN_DOLLAR'
    | 'INAPP_UNKNOWN_COST_PER_ACTION'
    | 'INAPP_UNKNOWN_ROAS'
    | 'TOTAL_INAPP_UNKNOWN'
    | 'TOTAL_INAPP_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_UNKNOWN_VALUE_IN_DOLLAR'
    | 'TOTAL_INAPP_CLICK_UNKNOWN'
    | 'TOTAL_INAPP_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_CLICK_UNKNOWN_VALUE_IN_DOLLAR'
    | 'TOTAL_INAPP_ENGAGEMENT_UNKNOWN'
    | 'TOTAL_INAPP_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_ENGAGEMENT_UNKNOWN_VALUE_IN_DOLLAR'
    | 'TOTAL_INAPP_VIEW_UNKNOWN'
    | 'TOTAL_INAPP_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_VIEW_UNKNOWN_VALUE_IN_DOLLAR'
    | 'OFFLINE_UNKNOWN_COST_PER_ACTION'
    | 'OFFLINE_UNKNOWN_ROAS'
    | 'TOTAL_OFFLINE_UNKNOWN'
    | 'TOTAL_OFFLINE_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_UNKNOWN_VALUE_IN_DOLLAR'
    | 'TOTAL_OFFLINE_CLICK_UNKNOWN'
    | 'TOTAL_OFFLINE_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_CLICK_UNKNOWN_VALUE_IN_DOLLAR'
    | 'TOTAL_OFFLINE_ENGAGEMENT_UNKNOWN'
    | 'TOTAL_OFFLINE_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_ENGAGEMENT_UNKNOWN_VALUE_IN_DOLLAR'
    | 'TOTAL_OFFLINE_VIEW_UNKNOWN'
    | 'TOTAL_OFFLINE_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_OFFLINE_VIEW_UNKNOWN_VALUE_IN_DOLLAR'
    | 'INAPP_APP_INSTALL_COST_PER_ACTION'
    | 'INAPP_APP_INSTALL_ROAS'
    | 'TOTAL_INAPP_APP_INSTALL'
    | 'TOTAL_INAPP_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_APP_INSTALL_VALUE_IN_DOLLAR'
    | 'TOTAL_INAPP_CLICK_APP_INSTALL'
    | 'TOTAL_INAPP_CLICK_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_CLICK_APP_INSTALL_VALUE_IN_DOLLAR'
    | 'TOTAL_INAPP_ENGAGEMENT_APP_INSTALL'
    | 'TOTAL_INAPP_ENGAGEMENT_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_ENGAGEMENT_APP_INSTALL_VALUE_IN_DOLLAR'
    | 'TOTAL_INAPP_VIEW_APP_INSTALL'
    | 'TOTAL_INAPP_VIEW_APP_INSTALL_VALUE_IN_MICRO_DOLLAR'
    | 'TOTAL_INAPP_VIEW_APP_INSTALL_VALUE_IN_DOLLAR'
    | 'IDEA_PIN_PAGE_FORWARD_1'
    | 'IDEA_PIN_PAGE_FORWARD_2'
    | 'IDEA_PIN_PAGE_BACKWARD_1'
    | 'IDEA_PIN_PAGE_BACKWARD_2'
    | 'TOTAL_IDEA_PIN_PAGE_FORWARD'
    | 'TOTAL_IDEA_PIN_PAGE_BACKWARD'
    | 'IDEA_PIN_PRODUCT_TAG_VISIT_1'
    | 'IDEA_PIN_PRODUCT_TAG_VISIT_2'
    | 'TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'
    | 'CPM_IN_US_DOLLAR'
    | 'ECPC_IN_US_DOLLAR'
    | 'LEADS'
    | 'COST_PER_LEAD'
    | 'QUIZ_STARTED'
    | 'QUIZ_COMPLETED'
    | 'QUIZ_PIN_RESULT_OPEN'
    | 'QUIZ_COMPLETION_RATE'
    | 'SHOWCASE_PIN_CLICKTHROUGH'
    | 'SHOWCASE_SUBPAGE_CLICKTHROUGH'
    | 'SHOWCASE_SUBPIN_CLICKTHROUGH'
    | 'SHOWCASE_SUBPAGE_IMPRESSION'
    | 'SHOWCASE_SUBPIN_IMPRESSION'
    | 'SHOWCASE_SUBPAGE_SWIPE_LEFT'
    | 'SHOWCASE_SUBPAGE_SWIPE_RIGHT'
    | 'SHOWCASE_SUBPIN_SWIPE_LEFT'
    | 'SHOWCASE_SUBPIN_SWIPE_RIGHT'
    | 'SHOWCASE_SUBPAGE_REPIN'
    | 'SHOWCASE_SUBPIN_REPIN'
    | 'SHOWCASE_SUBPAGE_CLOSEUP'
    | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'
    | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'
    | '_SHOWCASE_SUBPAGE_CLOSEUP_INTERNAL'
    | 'SHOWCASE_CARD_LANDING'
    | 'SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'
    | 'TOTAL_CHECKOUT_CONVERSION_RATE'
    | 'TOTAL_VIEW_CATEGORY_CONVERSION_RATE'
    | 'TOTAL_ADD_TO_CART_CONVERSION_RATE'
    | 'TOTAL_SIGNUP_CONVERSION_RATE'
    | 'TOTAL_PAGE_VISIT_CONVERSION_RATE'
    | 'TOTAL_LEAD_CONVERSION_RATE'
    | 'TOTAL_SEARCH_CONVERSION_RATE'
    | 'TOTAL_WATCH_VIDEO_CONVERSION_RATE'
    | 'TOTAL_UNKNOWN_CONVERSION_RATE'
    | 'TOTAL_CUSTOM_CONVERSION_RATE'
    | 'STANDARD_AD_FEED_ITEM_ID'
    | 'IS_STANDARD_FEED_AD'
    | 'TARGETING_GENDER'
    | 'TARGETING_CREATIVE_TYPE'
    | 'TARGETING_COUNTRY'
    | 'TARGETING_LOCATION'
    | 'TARGETING_APPTYPE'
    | 'TARGETING_LOCATION_CODE'
    | 'TARGETING_MEDIA_TYPE'
    | 'TOTAL_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_WEB_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_INAPP_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_OFFLINE_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_WEB_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_INAPP_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_OFFLINE_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_WEB_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_INAPP_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_OFFLINE_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_WEB_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_INAPP_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_OFFLINE_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_WEB_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_INAPP_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_OFFLINE_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_CHECKOUT_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_CHECKOUT_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_WEB_CHECKOUT_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_WEB_CHECKOUT_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_WEB_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_WEB_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_WEB_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_INAPP_CHECKOUT_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_INAPP_CHECKOUT_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_INAPP_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_INAPP_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_INAPP_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_OFFLINE_CHECKOUT_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_OFFLINE_CHECKOUT_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_OFFLINE_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_OFFLINE_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_OFFLINE_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_ADD_TO_CART_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_ADD_TO_CART_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_WEB_ADD_TO_CART_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_WEB_ADD_TO_CART_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_WEB_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_WEB_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_WEB_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_INAPP_ADD_TO_CART_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_INAPP_ADD_TO_CART_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_INAPP_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_INAPP_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_INAPP_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_PAGE_VISIT_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_PAGE_VISIT_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_PAGE_VISIT_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_PAGE_VISIT_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_PAGE_VISIT_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_WEB_PAGE_VISIT_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_WEB_PAGE_VISIT_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_WEB_PAGE_VISIT_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_WEB_PAGE_VISIT_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_WEB_PAGE_VISIT_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_SIGNUP_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_SIGNUP_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_WEB_SIGNUP_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_WEB_SIGNUP_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_WEB_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_WEB_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_WEB_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_INAPP_SIGNUP_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_INAPP_SIGNUP_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_INAPP_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_INAPP_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_INAPP_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_OFFLINE_SIGNUP_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_OFFLINE_SIGNUP_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_OFFLINE_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_OFFLINE_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_OFFLINE_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_WATCH_VIDEO_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_WEB_WATCH_VIDEO_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_WEB_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_WEB_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_WEB_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_WEB_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_LEAD_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_LEAD_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_LEAD_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_LEAD_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_LEAD_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_WEB_LEAD_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_WEB_LEAD_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_WEB_LEAD_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_WEB_LEAD_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_WEB_LEAD_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_OFFLINE_LEAD_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_OFFLINE_LEAD_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_OFFLINE_LEAD_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_OFFLINE_LEAD_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_OFFLINE_LEAD_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_SEARCH_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_SEARCH_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_SEARCH_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_SEARCH_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_SEARCH_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_WEB_SEARCH_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_WEB_SEARCH_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_WEB_SEARCH_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_WEB_SEARCH_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_WEB_SEARCH_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_INAPP_SEARCH_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_INAPP_SEARCH_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_INAPP_SEARCH_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_INAPP_SEARCH_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_INAPP_SEARCH_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_VIEW_CATEGORY_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_WEB_VIEW_CATEGORY_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_WEB_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_WEB_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_WEB_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_WEB_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_CUSTOM_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_CUSTOM_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_WEB_CUSTOM_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_WEB_CUSTOM_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_WEB_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_WEB_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_WEB_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_OFFLINE_CUSTOM_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_OFFLINE_CUSTOM_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_OFFLINE_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_OFFLINE_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_OFFLINE_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_UNKNOWN_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_UNKNOWN_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_WEB_UNKNOWN_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_WEB_UNKNOWN_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_WEB_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_WEB_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_WEB_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_INAPP_UNKNOWN_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_INAPP_UNKNOWN_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_INAPP_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_INAPP_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_INAPP_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_OFFLINE_UNKNOWN_CONVERSION_PRODUCT_QUANTITY'
    | 'TOTAL_OFFLINE_UNKNOWN_CONVERSION_PRODUCT_VALUE'
    | 'TOTAL_OFFLINE_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS'
    | 'TOTAL_OFFLINE_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_USD'
    | 'TOTAL_OFFLINE_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD'
    | 'TOTAL_CHECKOUT_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_WEB_CHECKOUT_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_INAPP_CHECKOUT_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_OFFLINE_CHECKOUT_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_ADD_TO_CART_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_WEB_ADD_TO_CART_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_INAPP_ADD_TO_CART_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_PAGE_VISIT_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_WEB_PAGE_VISIT_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_SIGNUP_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_WEB_SIGNUP_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_INAPP_SIGNUP_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_OFFLINE_SIGNUP_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_WATCH_VIDEO_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_WEB_WATCH_VIDEO_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_LEAD_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_WEB_LEAD_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_OFFLINE_LEAD_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_SEARCH_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_WEB_SEARCH_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_INAPP_SEARCH_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_VIEW_CATEGORY_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_WEB_VIEW_CATEGORY_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_CUSTOM_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_WEB_CUSTOM_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_OFFLINE_CUSTOM_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_UNKNOWN_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_WEB_UNKNOWN_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_INAPP_UNKNOWN_CONVERSION_PRODUCT_COUNT_UNIQUE'
    | 'TOTAL_OFFLINE_UNKNOWN_CONVERSION_PRODUCT_COUNT_UNIQUE'
  >;
  granularity?: Granularity;
  /**
   * The length of the sliding window over which view conversions will be attributed
   */
  view_window_days?: number;
  /**
   * The length of the sliding window over which click conversions will be attributed
   */
  click_window_days?: number;
  /**
   * The length of the sliding window over which engagement conversions will be attributed
   */
  engagement_window_days?: number;
  /**
   * Conversion report time type
   */
  conversion_report_time_type?: 'TIME_OF_AD_ACTION' | 'TIME_OF_CONVERSION';
  /**
   * A JSON representation of any filters to be applied before returning report data. Each filter object should contain all of the following fields:<br> "field": The column name<br> "operator": The operator. Allowed operators: ["=", "!=", "in", "not_in", "~", ">", "<", "contains_substring"]<br> "value": A single value or a list of values
   */
  filters_json?: string | null;
  /**
   * A boolean value that indicates if the user owns the template
   */
  is_owned_by_user?: boolean;
  /**
   * A boolean value that indicates if this template has been used to create a scheduled report
   */
  is_scheduled?: boolean;
  /**
   * The surface used to create this template
   */
  creation_source?: 'ADS_API' | 'ADS_MANAGER_REPORTING_PAGE' | 'ADS_MANAGER_REPORT_BUILDER';
  /**
   * A boolean that indicates if the template has been deleted
   */
  is_deleted?: boolean | null;
  /**
   * Time of last update in seconds since Unix epoch
   */
  updated_time?: number;
  /**
   * A list of custom column IDs
   */
  custom_column_ids?: Array<CustomColumnId> | null;
  /**
   * Type of the template
   */
  type?: 'UNSPECIFIED' | 'BULK' | 'OVERVIEW' | 'TABLE';
  /**
   * The filter on the conversion ingestion source method for conversion metrics
   */
  ingestion_sources?: Array<'TAG' | 'MMP' | 'FILE_UPLOAD' | 'CONVERSIONS_API' | 'NATIVE'> | null;
};

/**
 * The dynamic range type
 */
export type range = 'YEAR_TO_DATE' | 'QUARTER_TO_DATE' | 'MONTH_TO_DATE' | 'LAST_MONTH';

/**
 * Conversion report time type
 */
export type conversion_report_time_type = 'TIME_OF_AD_ACTION' | 'TIME_OF_CONVERSION';

/**
 * The surface used to create this template
 */
export type creation_source = 'ADS_API' | 'ADS_MANAGER_REPORTING_PAGE' | 'ADS_MANAGER_REPORT_BUILDER';

export type TermsOfService = {
  /**
   * The ID of the terms of service
   */
  id?: string;
  /**
   * The terms of service content
   */
  html?: string | null;
  /**
   * Whether the ad account has accepted terms of service.
   */
  has_accepted?: boolean;
  /**
   * The ID of the ad account.
   */
  ad_account_id?: string;
};

export type TermsSuggestedResponse = Array<string>;

export type TopPinsAnalyticsResponse = {
  date_availability?: {
    latest_available_timestamp?: number;
    is_realtime?: boolean;
  };
  pins?: Array<{
    metrics?: Metrics;
    data_status?: {
      [key: string]: DataStatus;
    };
    /**
     * The pin id
     */
    pin_id?: string;
  }>;
  sort_by?: 'ENGAGEMENT' | 'SAVE' | 'IMPRESSION' | 'OUTBOUND_CLICK' | 'PIN_CLICK';
};

export type sort_by = 'ENGAGEMENT' | 'SAVE' | 'IMPRESSION' | 'OUTBOUND_CLICK' | 'PIN_CLICK';

export type TopVideoPinsAnalyticsResponse = {
  date_availability?: {
    latest_available_timestamp?: number;
    is_realtime?: boolean;
  };
  pins?: Array<{
    /**
     * The metric name and daily value for each requested metric
     */
    metrics?: {
      [key: string]: number;
    };
    data_status?: {
      [key: string]: DataStatus;
    };
    /**
     * The pin id
     */
    pin_id?: string;
  }>;
  sort_by?:
    | 'SAVE'
    | 'IMPRESSION'
    | 'OUTBOUND_CLICK'
    | 'VIDEO_MRC_VIEW'
    | 'VIDEO_AVG_WATCH_TIME'
    | 'VIDEO_V50_WATCH_TIME'
    | 'QUARTILE_95_PERCENT_VIEW'
    | 'VIDEO_10S_VIEW'
    | 'VIDEO_START';
};

export type sort_by2 =
  | 'SAVE'
  | 'IMPRESSION'
  | 'OUTBOUND_CLICK'
  | 'VIDEO_MRC_VIEW'
  | 'VIDEO_AVG_WATCH_TIME'
  | 'VIDEO_V50_WATCH_TIME'
  | 'QUARTILE_95_PERCENT_VIEW'
  | 'VIDEO_10S_VIEW'
  | 'VIDEO_START';

/**
 * Third-party tracking URLs. Up to three tracking URLs - with a max length of 2,000 - are supported for each event type. Tracking URLs set at the ad group or ad level can override those set at the campaign level. For more information, see <a href="https://help.pinterest.com/en/business/article/third-party-and-dynamic-tracking" target="_blank">Third-party and dynamic tracking</a>.
 */
export type TrackingUrls = {
  impression?: Array<string>;
  click?: Array<string>;
  engagement?: Array<string>;
  buyable_button?: Array<string>;
  audience_verification?: Array<string>;
} | null;

export type TrendType = 'growing' | 'monthly' | 'yearly' | 'seasonal';

export type TrendingKeywordsResponse = {
  /**
   * The top trending keywords for the specified trend type in the requested region.<br />
   * Results are ordered, with the first element in the array representing the #1 top trend.
   */
  trends?: Array<{
    /**
     * The keyword that is trending.
     */
    keyword?: string;
    /**
     * The week-over-week percent change in search volume for this keyword.<br />
     * For example, a value of "50" would represent a 50% increase in searches in the last seven days compared to the week prior.<br />
     * **Note**: growth rates are rounded, with a maximum of +/- 10000% change.  A value of 10001 indicates that this keyword experienced > 10000% week-over-week growth.
     */
    pct_growth_wow?: number;
    /**
     * The month-over-month percent change in search volume for this keyword.<br />
     * For example, a value of "400" would represent a 400% increase in searches in the last 30 days compared to the month prior.<br />
     * **Note**: growth rates are rounded, with a maximum of +/- 10000% change.  A value of 10001 indicates that this keyword experienced > 10000% month-over-month growth.
     */
    pct_growth_mom?: number;
    /**
     * The year-over-year percent change in search volume for this keyword.<br />
     * For example, a value of "-5" would represent a 5% decrease in searches in the last 365 days compared to the month prior.<br />
     * **Note**: growth rates are rounded, with a maximum of +/- 10000% change.  A value of 10001 indicates that this keyword experienced > 10000% year-over-year growth.
     */
    pct_growth_yoy?: number;
    /**
     * A sequence of weekly observations of the relative search volume for this keyword over the past year.<br />
     * These values are normalized to a [0-100] range, and can be used to visualize the history of user interest in this keyword.
     * By default, normalization is applied independently to the time series of each keyword, but the `normalize_against_group` query parameter can be used in cases where you wish to compare relative volume between keywords.<br />
     * **Note**: The date of each observation is in ISO-8601 format and represents the *end* of the week.  For example, a value of `2023-10-31` would include searches that happened between `2023-10-25` and `2023-10-31`.
     */
    time_series?: {
      date?: string;
      [key: string]: (number | string) | undefined;
    };
  }>;
};

export type TrendsSupportedRegion =
  | 'US'
  | 'CA'
  | 'DE'
  | 'FR'
  | 'ES'
  | 'IT'
  | 'DE+AT+CH'
  | 'GB+IE'
  | 'IT+ES+PT+GR+MT'
  | 'PL+RO+HU+SK+CZ'
  | 'SE+DK+FI+NO'
  | 'NL+BE+LU'
  | 'AR'
  | 'BR'
  | 'CO'
  | 'MX'
  | 'MX+AR+CO+CL'
  | 'AU+NZ';

export type UpdatableItemAttributes = {
  /**
   * Allows advertisers to specify a separate URL that can be used to track traffic coming from Pinterest shopping ads. Must send full URL including tracking—do not send tracking parameters only. At this time we do not support impression tracking. Must begin with http:// or https://.
   */
  ad_link?: string | null;
  /**
   * Set this attribute to TRUE if you're submitting items that are considered “adult”. These will not be shown on Pinterest.
   */
  adult?: boolean | null;
  /**
   * The age group to apply a demographic range to the product. Must be one of the following values (upper or lowercased): ‘newborn’ , ‘infant’, ‘toddler’, ‘kids’, or ‘adult’.
   */
  age_group?: string | null;
  /**
   * The availability of the product. Must be one of the following values (upper or lowercased): ‘in stock’, ‘out of stock’ , ‘preorder’.
   */
  availability?: string;
  /**
   * Average reviews for the item. Can be a number from 1-5.
   */
  average_review_rating?: number | null;
  /**
   * The brand of the product.
   */
  brand?: string | null;
  /**
   * This attribute is not supported anymore.
   * @deprecated
   */
  checkout_enabled?: boolean | null;
  /**
   * The primary color of the product.
   */
  color?: string | null;
  /**
   * The condition of the product. Must be one of the following values (upper or lowercased): ‘new’, ‘used’, or ‘refurbished’.
   */
  condition?: string | null;
  /**
   * <p><= 1000 characters</p>
   * <p>Custom grouping of products.</p>
   */
  custom_label_0?: string | null;
  /**
   * <p><= 1000 characters</p>
   * <p>Custom grouping of products.</p>
   */
  custom_label_1?: string | null;
  /**
   * <p><= 1000 characters</p>
   * <p>Custom grouping of products.</p>
   */
  custom_label_2?: string | null;
  /**
   * <p><= 1000 characters</p>
   * <p>Custom grouping of products.</p>
   */
  custom_label_3?: string | null;
  /**
   * <p><= 1000 characters</p>
   * <p>Custom grouping of products.</p>
   */
  custom_label_4?: string | null;
  /**
   * <p><= 10000 characters</p>
   * <p>The description of the product.</p>
   */
  description?: string;
  /**
   * The item is free to ship.
   */
  free_shipping_label?: boolean | null;
  /**
   * The minimum order purchase necessary for the customer to get free shipping. Only relevant if free shipping is offered.
   */
  free_shipping_limit?: string | null;
  /**
   * The gender associated with the product. Must be one of the following values (upper or lowercased): ‘male’, ‘female’ , or ‘unisex’.
   */
  gender?: string | null;
  /**
   * The categorization of the product based on the standardized Google Product Taxonomy. This is a set taxonomy. Both the text values and numeric codes are accepted.
   */
  google_product_category?: string | null;
  /**
   * The unique universal product identifier.
   */
  gtin?: number | null;
  /**
   * <p><= 127 characters</p>
   * <p>The user-created unique ID that represents the product. Only
   * Unicode characters are accepted.</p>
   * @deprecated
   */
  id?: string;
  /**
   * <p><= 127 characters</p>
   * <p>The parent ID of the product.</p>
   */
  item_group_id?: string | null;
  /**
   * The millisecond timestamp when the item was lastly modified by the merchant.
   */
  last_updated_time?: number | null;
  /**
   * <p><= 511 characters</p>
   * <p>The landing page for the product.</p>
   */
  link?: string;
  /**
   * The material used to make the product.
   */
  material?: string | null;
  /**
   * The minimum advertised price of the product. It supports the following formats, "19.99 USD", "19.99USD" and "19.99". If the currency is not included, we default to US dollars.
   */
  min_ad_price?: string | null;
  /**
   * The mobile-optimized version of your landing page. Must begin with http:// or https://.
   */
  mobile_link?: string | null;
  /**
   * Manufacturer Part Number are alpha-numeric codes created by the manufacturer of a product to uniquely identify it among all products from the same manufacturer.
   */
  mpn?: string | null;
  /**
   * The number of ratings for the item.
   */
  number_of_ratings?: number | null;
  /**
   * The number of reviews available for the item.
   */
  number_of_reviews?: number | null;
  /**
   * The description of the pattern used for the product.
   */
  pattern?: string | null;
  /**
   * The price of the product. It supports the following formats, "24.99 USD", "24.99USD" and "24.99". If the currency is not included, we default to US dollars.
   */
  price?: string;
  /**
   * <p><= 1000 characters</p>
   * <p>The categorization of your product based on your custom product
   * taxonomy. Subcategories must be sent separated by “ > “. The > must be
   * wrapped by spaces. We do not recognize any other delimiters such as comma
   * or pipe.</p>
   */
  product_type?: string | null;
  /**
   * The discounted price of the product. The sale_price must be lower than the price. It supports the following formats, "14.99 USD", "14.99USD" and "14.99". If the currency is not included, we default to US dollars.
   */
  sale_price?: string | null;
  /**
   * Shipping consists of one group of up to four elements, country, region, service (all optional) and price (required). All colons, even for blank values, are required.
   */
  shipping?: string | null;
  /**
   * The height of the package needed to ship the product. Ensure there is a space between the numeric string and the metric.
   */
  shipping_height?: string | null;
  /**
   * The weight of the product. Ensure there is a space between the numeric string and the metric.
   */
  shipping_weight?: string | null;
  /**
   * The width of the package needed to ship the product. Ensure there is a space between the numeric string and the metric.
   */
  shipping_width?: string | null;
  /**
   * The size of the product.
   */
  size?: string | null;
  /**
   * Indicates the country’s sizing system in which you are submitting your product. Must be one of the following values (upper or lowercased): ‘US’, ‘UK’, ‘EU’, ‘DE’ , ‘FR’, ‘JP’, ‘CN’, ‘IT’, ‘ BR’, ‘MEX’, or ‘AU’.
   */
  size_system?: string | null;
  /**
   * Additional description for the size. Must be one of the following values (upper or lowercased): ‘regular’, ‘petite’ , ‘plus’, ‘big_and_tall’, or ‘maternity’.
   */
  size_type?: string | null;
  /**
   * Tax consists of one group of up to four elements, country, region, rate (all required) and tax_ship (optional). All colons, even for blank values, are required.
   */
  tax?: string | null;
  /**
   * <p><= 500 characters</p>
   * <p>The name of the product.</p>
   */
  title?: string;
  /**
   * Options for this variant. People will see these options next to your Pin and can select the one they want. List them in the order you want them displayed.
   */
  variant_names?: Array<string> | null;
  /**
   * Option values for this variant. People will see these options next to your Pin and can select the one they want. List them in the order you want them displayed. The order of the variant values must be consistent with the order of the variant names.
   */
  variant_values?: Array<string> | null;
};

export type UserBusinessRoleBinding = {
  assets_summary?: BusinessMemberAssetsSummary | null;
  /**
   * The access level a user has on the business. This can be EMPLOYEE, BIZ_ADMIN, or PARTNER.
   */
  business_roles?: Array<BusinessRoleResponse>;
  /**
   * Metadata for the business that created the business relationship.
   */
  created_by_business?: BusinessAccessUserSummary | null;
  /**
   * Metadata for the user that created the business relationship.
   */
  created_by_user?: BusinessAccessUserSummary | null;
  /**
   * The time the business relationship was created. Returned in milliseconds.
   */
  created_time?: number | null;
  /**
   * Unique identifier of the business member/business partner/employer.
   */
  id?: string;
  /**
   * This field is only relevant when business_role="PARTNER".
   * <br>If is_shared_partner=FALSE, the partner can access your business assets. If assets_summary
   * is not empty, the assets listed are your business assets the partner has access to.
   * <br>If is_shared_partner=TRUE, you can access the partner's business asset. If assets_summary
   * is not empty, the assets listed are the partner's business assets you have access to.
   */
  is_shared_partner?: boolean;
  /**
   * Metadata for the business member/business partner/employer.
   */
  user?: BusinessAccessUserSummary | null;
};

/**
 * Object declaring an asset role update to an invite.
 */
export type CreateAssetInvitesRequestItem = {
  /**
   * Unique identifier of an invite.
   */
  invite_id: string;
  invite_type: InviteType;
  asset_id_to_permissions: AssetIdToPermissions;
};

/**
 * Request body for updating asset roles for existing invites.
 */
export type CreateAssetInvitesRequest = {
  invites: Array<CreateAssetInvitesRequestItem>;
};

export type UpdateAssetGroupBody = {
  /**
   * A list of asset groups and the data that will be used to update them.
   */
  asset_groups_to_update?: Array<{
    /**
     * Unique identifier of the asset group to update.
     */
    asset_group_id: string;
    /**
     * Asset Group name
     */
    name?: string;
    /**
     * Asset group description
     */
    description?: string;
    asset_group_types?: AssetGroupTypes;
    /**
     * A list of asset ids to add to the asset group.
     */
    assets_to_add?: Array<string>;
    /**
     * A list of asset ids to remove from the asset group.
     */
    assets_to_remove?: Array<string>;
  }>;
};

export type UpdateAssetGroupResponse = {
  /**
   * A list of successfully edited asset groups.
   */
  updated_asset_groups?: Array<AssetGroupBinding>;
  /**
   * A list of errors associated with the asset groups. Will be returned if there is an error.
   */
  exceptions?: Array<{
    /**
     * Error code associated with the error editing asset group.
     */
    code?: number;
    /**
     * Error message associated with the error editing asset group.
     */
    message?: string;
    /**
     * Asset group id of the exception.
     */
    asset_group_id?: string;
  }> | null;
};

/**
 * Request body used to delete asset groups
 */
export type DeleteAssetGroupBody = {
  /**
   * List of ids of asset groups to be deleted
   */
  asset_groups_to_delete: Array<string>;
};

export type DeleteAssetGroupResponse = {
  /**
   * A list of ids of successfully deleted asset groups.
   */
  deleted_asset_groups?: Array<string>;
  /**
   * A list of errors associated with the asset groups. Will be returned if there is an error.
   */
  exceptions?: Array<{
    /**
     * Error code associated with the error deleting asset group.
     */
    code?: number;
    /**
     * Error message associated with the error deleting asset group.
     */
    message?: string;
    /**
     * Asset group id of the exception.
     */
    asset_group_id?: string;
  }> | null;
};

export type UpdateInvitesResultsResponseArray = {
  /**
   * List of invite/Request action status. If there is an error, an exception object will be returned. If the action was successfully completed, an invite object will be returned.
   */
  items?: Array<{
    exception?: InviteExceptionResponse;
    invite?: InviteBusinessRoleBinding;
  }>;
};

/**
 * Response to delete invites sent to Members or Partners, if there is an exception, return the exception mapped with the invite id
 */
export type DeleteInvitesResultsResponseArray = {
  /**
   * List of invite/Request deletion status. If there is an error, an exception object will be returned. If the invite/request was successfully cancelled, an invite object will be returned for the invite that was cancelled.
   */
  items?: Array<{
    /**
     * An exception object if there is an error performing the cancellation. It will only be provided if there is an error.
     */
    exception?: {
      /**
       * Unique identifier of an invite.
       */
      invite_id?: string;
      /**
       * Error message associated with the error in performing the action on the invite/request.
       */
      message?: string;
    } | null;
    invite?: BaseInviteDataResponse;
  }>;
};

export type UpdateMemberAssetsResultsResponseArray = {
  /**
   * List of assigned/updated member asset access.
   * If there is an error, an exception object will be returned. If the action was successfully completed, a response object will be returned.
   */
  items?: Array<{
    response?: UsersForIndividualAssetResponse;
  }>;
};

/**
 * An object containing the permissions a business member has on the asset.
 */
export type UsersForIndividualAssetResponse = {
  /**
   * Unique identifier of a business asset.
   */
  asset_id?: string;
  /**
   * Unique identifier of the business member with asset access.
   */
  member_id?: string;
  permissions?: PermissionsResponse;
};

/**
 * The field types supported by the update mask
 */
export type UpdateMaskFieldType =
  | 'ad_link'
  | 'adult'
  | 'age_group'
  | 'availability'
  | 'average_review_rating'
  | 'brand'
  | 'checkout_enabled'
  | 'color'
  | 'condition'
  | 'custom_label_0'
  | 'custom_label_1'
  | 'custom_label_2'
  | 'custom_label_3'
  | 'custom_label_4'
  | 'description'
  | 'free_shipping_label'
  | 'free_shipping_limit'
  | 'gender'
  | 'google_product_category'
  | 'gtin'
  | 'item_group_id'
  | 'last_updated_time'
  | 'link'
  | 'material'
  | 'min_ad_price'
  | 'mpn'
  | 'number_of_ratings'
  | 'number_of_reviews'
  | 'pattern'
  | 'price'
  | 'product_type'
  | 'sale_price'
  | 'shipping'
  | 'shipping_height'
  | 'shipping_weight'
  | 'shipping_width'
  | 'size'
  | 'size_system'
  | 'size_type'
  | 'tax'
  | 'title'
  | 'variant_names'
  | 'variant_values';

export type UpdatePartnerResultsResponseArray = {
  items?: Array<{
    exception?: BusinessAccessError;
    member_or_partner_id?: string | null;
  }>;
};

/**
 * Specifies the type of followees to be kept when filtering them.
 */
export type UserFollowingFeedType = 'ALL' | 'RANKED' | 'CREATOR_ONLY' | 'RANKED_CREATOR_ONLY';

/**
 * User list operation type (add or remove)
 */
export type UserListOperationType = 'ADD' | 'REMOVE';

/**
 * User list type
 */
export type UserListType = 'EMAIL' | 'IDFA' | 'MAID' | 'LR_ID' | 'DLX_ID' | 'HASHED_PINNER_ID';

/**
 * An object containing the permissions a business member/partner has on the asset.
 */
export type UserSingleAssetBinding = {
  permissions?: PermissionsResponse;
  user?: BusinessAccessUserSummary;
};

export type UserSummary = {
  /**
   * Username
   */
  username?: string;
  /**
   * Always "user"
   */
  type?: string;
};

export type UserWebsiteSummary = {
  /**
   * Website with path or domain only
   */
  website?: string;
  /**
   * Status of the verification process
   */
  status?: string;
  /**
   * UTC timestamp when the verification happened - sometimes missing
   */
  verified_at?: string;
};

export type UserWebsiteVerificationCode = {
  /**
   * Code to check against the user claiming the website
   */
  verification_code?: string;
  /**
   * DNS TXT record to check against for the website to be claimed
   */
  dns_txt_record?: string;
  /**
   * Metatag the verification process searchs for the website to be claimed
   */
  metatag?: string;
  /**
   * File expected to find on the website being claimed
   */
  filename?: string;
  /**
   * A full html file to upload to the website in order for it to be claimed
   */
  file_content?: string;
};

/**
 * User website verification request
 */
export type UserWebsiteVerifyRequest = {
  website?: string;
  verification_method?: 'FILENAME' | 'METATAG' | 'DNSTXT';
};

export type verification_method = 'FILENAME' | 'METATAG' | 'DNSTXT';

export type VideoMetadata = {
  item_type?: string;
  cover_image_url?: string;
  /**
   * Video url (720p). </p><strong>Note:</strong> This field is limited and not available to all apps.
   */
  video_url?: string | null;
  /**
   * Duration (in milliseconds)
   */
  duration?: number;
  /**
   * Height (in pixels)
   */
  height?: number;
  /**
   * Width (in pixels)
   */
  width?: number;
};

export type PartnerType = 'INTERNAL' | 'EXTERNAL';

/**
 * An object containing the permissions a business partner has on the asset.
 */
export type UpdatePartnerAssetsResult = {
  /**
   * Unique identifier of a business asset.
   */
  asset_id?: string;
  asset_type?: AssetTypeResponse;
  /**
   * Unique identifier of a business partner.
   */
  partner_id?: string;
  permissions?: PermissionsResponse;
};

export type UpdatePartnerAssetsResultsResponseArray = {
  /**
   * List of assigned/updated partner asset access.
   */
  items?: Array<UpdatePartnerAssetsResult>;
};

export type SharedAudienceCommon = {
  /**
   * Unique identifier of an audience
   */
  audience_id?: string;
  operation_type?: OperationType;
};

export type SharedAudience = SharedAudienceCommon & {
  /**
   * List of ad account IDs to share with or revoke from.
   */
  recipient_account_ids: Array<string>;
};

export type BusinessSharedAudience = SharedAudienceCommon & {
  /**
   * List of business IDs to share with or revoke from.
   */
  recipient_business_ids: Array<string>;
};

export type SharedAudienceResponseCommon = {
  /**
   * Audience ID that was shared
   */
  audience_id?: string;
  permissions?: Array<Role>;
} | null;

export type SharedAudienceResponse =
  | (SharedAudienceResponseCommon & {
      /**
       * Account IDs that received the audience
       */
      recipient_account_ids?: Array<string>;
    })
  | null;

export type BusinessSharedAudienceResponse =
  | (SharedAudienceResponseCommon & {
      /**
       * Business IDs that received the audience
       */
      recipient_business_ids?: Array<string>;
    })
  | null;

/**
 * Operation type to share a specific audience or revoke access to a previously shared audience
 */
export type OperationType = 'SHARE' | 'REVOKE';

/**
 * Max search result size
 */
export type Parameterresult_limit = number;

/**
 * Unique identifier of an ad account.
 */
export type Parameterpath_ad_account_id = string;

/**
 * Unique identifier of an ad group.
 */
export type Parameterpath_ad_group_id = string;

/**
 * Unique identifier of an ad.
 */
export type Parameterpath_ad_id = string;

/**
 * Unique identifier of a business asset.
 */
export type Parameterpath_asset_id = string;

/**
 * Unique identifier of a lead form.
 */
export type Parameterpath_lead_form_id = string;

/**
 * Id of aggregated pin data
 */
export type Parameterpath_aggregated_pin_data = string;

/**
 * Unique identifier of an audience
 */
export type Parameterpath_audience_id = string;

/**
 * Unique identifier of a board.
 */
export type Parameterpath_board_id = string;

/**
 * Unique identifier of a board section.
 */
export type Parameterpath_board_section_id = string;

/**
 * Unique identifier of a bulk upsert request.
 */
export type Parameterpath_bulk_request_id = string;

/**
 * if set to True then attach the errors/details to all the requests
 */
export type Parameterinclude_details = boolean;

/**
 * Business id
 */
export type Parameterpath_business_id = string;

/**
 * Unique identifier of the requesting business.
 */
export type Parameterpath_business_user = string;

/**
 * The partner id to be bound to the Business
 */
export type Parameterpath_business_partner_user = string;

/**
 * The member id to fetch assets for.
 */
export type Parameterpath_business_member_user = string;

/**
 * Campaign ID, must be associated with the ad account ID provided in the path.
 */
export type Parameterpath_campaign_id = string;

/**
 * Unique identifier of a feed
 */
export type Parameterpath_catalogs_feed_id = string;

/**
 * Id of a catalogs items batch to fetch
 */
export type Parameterpath_catalogs_items_batch_id = string;

/**
 * Unique identifier of a feed processing result. It can be acquired from the "id" field of the "items" array within the response of the [List processing results for a given feed](/docs/api/v5/#operation/feed_processing_results/list).
 */
export type Parameterpath_catalogs_processing_result_id = string;

/**
 * Unique identifier of a product group
 */
export type Parameterpath_catalogs_product_group_id = string;

/**
 * Category (L1 interest) numeric ID.
 */
export type Parameterpath_category_id = string;

/**
 * Id of the conversion tag.
 */
export type Parameterpath_conversion_tag_id = string;

/**
 * Unique identifier of a customer list
 */
export type Parameterpath_customer_list_id = string;

/**
 * External business ID for the integration.
 */
export type Parameterpath_external_business_id = string;

/**
 * Unique identifier of an interest.
 */
export type Parameterpath_interest_id = string;

/**
 * Media identifier
 */
export type Parameterpath_media_id = string;

/**
 * The member id to be bound to the Business
 */
export type Parameterpath_member_id = string;

/**
 * Unique identifier of an order line.
 */
export type Parameterpath_order_line_id = string;

/**
 * Unique identifier of a Pin.
 */
export type Parameterpath_pin_id = string;

/**
 * The pin order id associated with the ssio insertion order
 */
export type Parameterpath_pin_order_id = string;

/**
 * Unique identifier of a product group promotion
 */
export type Parameterpath_product_group_promotion_id = string;

/**
 * Generated audience scope to request.
 */
export type Parameterpath_scope = AudienceDefinitionScope;

/**
 * Unique identifier of a subscription.
 */
export type Parameterpath_subscription_id = string;

/**
 * Public targeting type.
 */
export type Parameterpath_targeting_type =
  | 'APPTYPE'
  | 'GENDER'
  | 'LOCALE'
  | 'AGE_BUCKET'
  | 'LOCATION'
  | 'GEO'
  | 'INTEREST'
  | 'KEYWORD'
  | 'AUDIENCE_INCLUDE'
  | 'AUDIENCE_EXCLUDE';

/**
 * Unique identifier of a template.
 */
export type Parameterpath_template_id = string;

/**
 * The geographic region of interest. Only top trends within the specified region will be returned.<br />
 * The `region` parameter is formatted as ISO 3166-2 country codes delimited by `+`, corresponding to the following geographic areas:
 * - `US` - United States
 * - `CA` - Canada
 * - `DE` - Germany
 * - `FR` - France
 * - `ES` - Spain
 * - `IT` - Italy
 * - `DE+AT+CH` - Germanic countries
 * - `GB+IE` - Great Britain & Ireland
 * - `IT+ES+PT+GR+MT` - Southern Europe
 * - `PL+RO+HU+SK+CZ` - Eastern Europe
 * - `SE+DK+FI+NO` - Nordic countries
 * - `NL+BE+LU` - Benelux
 * - `AR` - Argentina
 * - `BR` - Brazil
 * - `CO` - Colombia
 * - `MX` - Mexico
 * - `MX+AR+CO+CL` - Hispanic LatAm
 * - `AU+NZ` - Australasia
 */
export type Parameterpath_trend_region = TrendsSupportedRegion;

/**
 * The methodology used to rank how trendy a keyword is.
 * - `growing` trends have high upward growth in search volume over the last quarter
 * - `monthly` trends have high search volume in the last month
 * - `yearly` trends have high search volume in the last year
 * - `seasonal` trends have high upward growth in search volume over the last month and exhibit a seasonal recurring pattern (typically annual)
 */
export type Parameterpath_trend_type = TrendType;

/**
 * Generated audience type to request.
 */
export type Parameterpath_type = AudienceDefinitionType;

/**
 * A valid username
 */
export type Parameterpath_username = string;

/**
 * Unique identifier of an ad account.
 */
export type Parameterquery_ad_account_id = string;

/**
 * Ad group Id.
 */
export type Parameterquery_ad_group_id = string;

/**
 * List of Ad group Ids to use to filter the results.
 */
export type Parameterquery_ad_group_ids = Array<string>;

/**
 * List of Ad group Ids to use to filter the results.
 */
export type Parameterquery_ad_group_ids_required = Array<string>;

/**
 * List of Ad Ids to use to filter the results.
 */
export type Parameterquery_ad_ids = Array<string>;

/**
 * List of Ad Ids to use to filter the results.
 */
export type Parameterquery_ad_ids_required = Array<string>;

/**
 * Targeting type breakdowns for the report. The reporting per targeting type <br> is independent from each other. ["AGE_BUCKET_AND_GENDER"] is in BETA and not yet available to all users.
 */
export type Parameterquery_ad_targeting_types = Array<AdsAnalyticsAdTargetingType>;

/**
 * If set, filters the results to trends among users in the specified age range(s).<br />
 * If unset, trends among all age groups will be returned.
 */
export type Parameterquery_age_bucket_list = AgeBucketList;

/**
 * Apps or devices to get data for, default is all.
 */
export type Parameterquery_app_types = 'ALL' | 'MOBILE' | 'TABLET' | 'WEB';

/**
 * Include assets summary in the response if this is true.
 *
 * The assets summary returns a dictionary representing a summary of the assets
 * for the business user ID, with information like the ad accounts and profiles
 * the user has permissions for and what those permissions are
 */
export type Parameterquery_assets_summary = boolean;

/**
 * List of types of attribution for the conversion report
 */
export type Parameterquery_attribution_types = ConversionReportAttributionType;

/**
 * Unique identifier of the audience to use to filter the results.
 */
export type Parameterquery_audience_id = string;

/**
 * List of audience ids to use to filter the results.
 */
export type Parameterquery_audience_ids = Array<string>;

/**
 * Type of audience insights.
 */
export type Parameterquery_audience_insight_type = AudienceInsightType;

/**
 * The type of audience to filter for.
 */
export type Parameterquery_audience_type = string;

/**
 * The types of audience to filter for.
 */
export type Parameterquery_audience_types = Array<AudienceType>;

/**
 * Cursor used to fetch the next page of items
 */
export type Parameterquery_bookmark = string;

/**
 * Campaign Id to use to filter the results.
 */
export type Parameterquery_campaign_id = string;

/**
 * List of Campaign Ids to use to filter the results.
 */
export type Parameterquery_campaign_ids = Array<string>;

/**
 * List of Campaign Ids to use to filter the results.
 */
export type Parameterquery_campaign_ids_required = Array<string>;

/**
 * Targeting type breakdowns for the report. The reporting per targeting type <br> is independent from each other. ["AGE_BUCKET_AND_GENDER"] is in BETA and not yet available to all users.
 */
export type Parameterquery_campaign_targeting_types = Array<AdsAnalyticsCampaignTargetingType>;

/**
 * Filter entities for a given catalog_id. If not given, all catalogs are considered.
 */
export type Parameterquery_catalogs_catalog_id = string;

/**
 * Contains the parameters for report identification.
 */
export type Parameterquery_catalogs_report_stats_parameters = CatalogsReportParameters;

/**
 * Filter entities for a given feed_id. If not given, all feeds are considered.
 */
export type Parameterquery_catalogs_feed_id = string;

/**
 * Item number based on order of appearance in the Catalogs Feed. For example, '0' refers to first item found in a feed that was downloaded from a 'location' specified during feed creation.
 */
export type Parameterquery_catalogs_item_numbers = Array<number>;

/**
 * Filter item validation issues that have a given type of item validation issue.
 */
export type Parameterquery_catalogs_item_validation_issue = CatalogsItemValidationIssue;

/**
 * This parameter is deprecated. Use filters instead.
 * @deprecated
 */
export type Parameterquery_catalogs_items = Array<string>;

/**
 * Country for the Catalogs Items
 */
export type Parameterquery_catalogs_items_country = string;

/**
 * Identifies items to be retrieved. This is a required parameter.
 */
export type Parameterquery_catalogs_items_filters = CatalogsItemsFilters;

/**
 * Language for the Catalogs Items
 */
export type Parameterquery_catalogs_items_language = string;

/**
 * Token returned from async build report call
 */
export type Parameterquery_catalogs_report_token = string;

/**
 * Comma-separated list of product group ids
 */
export type Parameterquery_catalogs_product_group_ids = Array<number>;

/**
 * Comma-separated list of product group ids
 */
export type Parameterquery_catalogs_product_group_ids_required = Array<number>;

/**
 * Client ID.
 */
export type Parameterquery_client_id = string;

/**
 * Columns to retrieve, encoded as a comma-separated string. **NOTE**: Any metrics defined as MICRO_DOLLARS returns a value based on the advertiser profile's currency field. For USD,($1/1,000,000, or $0.000001 - one one-ten-thousandth of a cent). it's microdollars. Otherwise, it's in microunits of the advertiser's currency.<br/>For example, if the advertiser's currency is GBP (British pound sterling), all MICRO_DOLLARS fields will be in GBP microunits (1/1,000,000 British pound).<br/>If a column has no value, it may not be returned
 */
export type Parameterquery_columns = Array<
  | 'SPEND_IN_MICRO_DOLLAR'
  | 'PAID_IMPRESSION'
  | 'SPEND_IN_DOLLAR'
  | 'CPC_IN_MICRO_DOLLAR'
  | 'ECPC_IN_MICRO_DOLLAR'
  | 'ECPC_IN_DOLLAR'
  | 'CTR'
  | 'ECTR'
  | 'CAMPAIGN_NAME'
  | 'PIN_ID'
  | 'TOTAL_ENGAGEMENT'
  | 'ENGAGEMENT_1'
  | 'ENGAGEMENT_2'
  | 'ECPE_IN_DOLLAR'
  | 'ENGAGEMENT_RATE'
  | 'EENGAGEMENT_RATE'
  | 'ECPM_IN_MICRO_DOLLAR'
  | 'REPIN_RATE'
  | 'CTR_2'
  | 'CAMPAIGN_ID'
  | 'ADVERTISER_ID'
  | 'AD_ACCOUNT_ID'
  | 'PIN_PROMOTION_ID'
  | 'AD_ID'
  | 'AD_GROUP_ID'
  | 'CAMPAIGN_ENTITY_STATUS'
  | 'CAMPAIGN_OBJECTIVE_TYPE'
  | 'CPM_IN_MICRO_DOLLAR'
  | 'CPM_IN_DOLLAR'
  | 'AD_GROUP_ENTITY_STATUS'
  | 'ORDER_LINE_ID'
  | 'ORDER_LINE_NAME'
  | 'CLICKTHROUGH_1'
  | 'REPIN_1'
  | 'IMPRESSION_1'
  | 'IMPRESSION_1_GROSS'
  | 'CLICKTHROUGH_1_GROSS'
  | 'OUTBOUND_CLICK_1'
  | 'CLICKTHROUGH_2'
  | 'REPIN_2'
  | 'IMPRESSION_2'
  | 'OUTBOUND_CLICK_2'
  | 'TOTAL_CLICKTHROUGH'
  | 'TOTAL_IMPRESSION'
  | 'TOTAL_IMPRESSION_USER'
  | 'TOTAL_IMPRESSION_FREQUENCY'
  | 'COST_PER_OUTBOUND_CLICK_IN_DOLLAR'
  | 'TOTAL_ENGAGEMENT_SIGNUP'
  | 'TOTAL_ENGAGEMENT_CHECKOUT'
  | 'TOTAL_ENGAGEMENT_LEAD'
  | 'TOTAL_CLICK_SIGNUP'
  | 'TOTAL_CLICK_CHECKOUT'
  | 'TOTAL_CLICK_ADD_TO_CART'
  | 'TOTAL_CLICK_LEAD'
  | 'TOTAL_VIEW_SIGNUP'
  | 'TOTAL_VIEW_CHECKOUT'
  | 'TOTAL_VIEW_ADD_TO_CART'
  | 'TOTAL_VIEW_LEAD'
  | 'TOTAL_CONVERSIONS'
  | 'TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_SESSIONS'
  | 'WEB_SESSIONS_1'
  | 'WEB_SESSIONS_2'
  | 'CAMPAIGN_LIFETIME_SPEND_CAP'
  | 'CAMPAIGN_DAILY_SPEND_CAP'
  | 'TOTAL_PAGE_VISIT'
  | 'TOTAL_SIGNUP'
  | 'TOTAL_CHECKOUT'
  | 'TOTAL_CUSTOM'
  | 'TOTAL_LEAD'
  | 'TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'
  | 'PAGE_VISIT_COST_PER_ACTION'
  | 'PAGE_VISIT_ROAS'
  | 'CHECKOUT_ROAS'
  | 'CUSTOM_ROAS'
  | 'VIDEO_MRC_VIEWS_1'
  | 'VIDEO_3SEC_VIEWS_2'
  | 'VIDEO_P100_COMPLETE_2'
  | 'VIDEO_P0_COMBINED_2'
  | 'VIDEO_P25_COMBINED_2'
  | 'VIDEO_P50_COMBINED_2'
  | 'VIDEO_P75_COMBINED_2'
  | 'VIDEO_P95_COMBINED_2'
  | 'VIDEO_MRC_VIEWS_2'
  | 'PAID_VIDEO_VIEWABLE_RATE'
  | 'VIDEO_LENGTH'
  | 'ECPV_IN_DOLLAR'
  | 'ECPCV_IN_DOLLAR'
  | 'ECPCV_P95_IN_DOLLAR'
  | 'TOTAL_VIDEO_3SEC_VIEWS'
  | 'TOTAL_VIDEO_P100_COMPLETE'
  | 'TOTAL_VIDEO_P0_COMBINED'
  | 'TOTAL_VIDEO_P25_COMBINED'
  | 'TOTAL_VIDEO_P50_COMBINED'
  | 'TOTAL_VIDEO_P75_COMBINED'
  | 'TOTAL_VIDEO_P95_COMBINED'
  | 'TOTAL_VIDEO_MRC_VIEWS'
  | 'TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'
  | 'TOTAL_REPIN_RATE'
  | 'WEB_CHECKOUT_COST_PER_ACTION'
  | 'WEB_CHECKOUT_ROAS'
  | 'TOTAL_WEB_CHECKOUT'
  | 'TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_CLICK_CHECKOUT'
  | 'TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT'
  | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'TOTAL_WEB_VIEW_CHECKOUT'
  | 'TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
  | 'INAPP_CHECKOUT_COST_PER_ACTION'
  | 'TOTAL_OFFLINE_CHECKOUT'
  | 'IDEA_PIN_PRODUCT_TAG_VISIT_1'
  | 'IDEA_PIN_PRODUCT_TAG_VISIT_2'
  | 'TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'
  | 'LEADS'
  | 'COST_PER_LEAD'
  | 'QUIZ_COMPLETED'
  | 'QUIZ_PIN_RESULT_OPEN'
  | 'QUIZ_COMPLETION_RATE'
  | 'SHOWCASE_PIN_CLICKTHROUGH'
  | 'SHOWCASE_SUBPAGE_CLICKTHROUGH'
  | 'SHOWCASE_SUBPIN_CLICKTHROUGH'
  | 'SHOWCASE_SUBPAGE_IMPRESSION'
  | 'SHOWCASE_SUBPIN_IMPRESSION'
  | 'SHOWCASE_SUBPAGE_SWIPE_LEFT'
  | 'SHOWCASE_SUBPAGE_SWIPE_RIGHT'
  | 'SHOWCASE_SUBPIN_SWIPE_LEFT'
  | 'SHOWCASE_SUBPIN_SWIPE_RIGHT'
  | 'SHOWCASE_SUBPAGE_REPIN'
  | 'SHOWCASE_SUBPIN_REPIN'
  | 'SHOWCASE_SUBPAGE_CLOSEUP'
  | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'
  | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'
  | 'SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'
  | 'TOTAL_CHECKOUT_CONVERSION_RATE'
  | 'TOTAL_VIEW_CATEGORY_CONVERSION_RATE'
  | 'TOTAL_ADD_TO_CART_CONVERSION_RATE'
  | 'TOTAL_SIGNUP_CONVERSION_RATE'
  | 'TOTAL_PAGE_VISIT_CONVERSION_RATE'
  | 'TOTAL_LEAD_CONVERSION_RATE'
  | 'TOTAL_SEARCH_CONVERSION_RATE'
  | 'TOTAL_WATCH_VIDEO_CONVERSION_RATE'
  | 'TOTAL_UNKNOWN_CONVERSION_RATE'
  | 'TOTAL_CUSTOM_CONVERSION_RATE'
>;

/**
 * Comment feed type.
 */
export type Parameterquery_comment_feed_type = 'ranked' | 'recent';

/**
 * Filter to paid or organic data. Default is all.
 */
export type Parameterquery_content_type = 'ALL' | 'PAID' | 'ORGANIC';

/**
 * Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
 */
export type Parameterquery_conversion_attribution_click_window_days = 0 | 1 | 7 | 14 | 30 | 60;

/**
 * The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.
 */
export type Parameterquery_conversion_attribution_conversion_report_time = 'TIME_OF_AD_ACTION' | 'TIME_OF_CONVERSION';

/**
 * Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
 */
export type Parameterquery_conversion_attribution_engagement_window_days = 0 | 1 | 7 | 14 | 30 | 60;

/**
 * Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.
 */
export type Parameterquery_conversion_attribution_view_window_days = 0 | 1 | 7 | 14 | 30 | 60;

/**
 * Two letter country code (ISO 3166-1 alpha-2)
 */
export type Parameterquery_country_code = string;

/**
 * Get metrics for pins created in the last "n" days.
 */
export type Parameterquery_created_in_last_n_days = 30;

/**
 * Pin creative types filter. </p><strong>Note:</strong> SHOP_THE_PIN has been deprecated. Please use COLLECTION instead.
 */
export type Parameterquery_creative_types = Array<
  'REGULAR' | 'VIDEO' | 'SHOPPING' | 'CAROUSEL' | 'MAX_VIDEO' | 'SHOP_THE_PIN' | 'COLLECTION' | 'IDEA'
>;

/**
 * Metric report end date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days past start_date.
 */
export type Parameterquery_end_date = string;

/**
 * Metric report end date (UTC). Format: YYYY-MM-DD. Cannot be more than 2.5 years past start date.
 */
export type Parameterquery_end_date_async = string;

/**
 * Entity status
 */
export type Parameterquery_entity_statuses = Array<'ACTIVE' | 'PAUSED' | 'ARCHIVED' | 'DRAFT' | 'DELETED_DRAFT'>;

/**
 * Whether or not to include implicit user follows, which means followees with board follows. When explicit_following is True, it means we only want explicit user follows.
 */
export type Parameterquery_explicit_following = boolean;

/**
 * Filter out deleted tags.
 */
export type Parameterquery_filter_deleted = boolean;

/**
 * Uniform the format of Audiences rules for presentation on Web UI.
 */
export type Parameterquery_flatten_rule = boolean;

/**
 * Filter on Pins that match your claimed domain.
 */
export type Parameterquery_from_claimed_content = 'OTHER' | 'CLAIMED' | 'BOTH';

/**
 * If set, filters the results to trends among users who identify with the specified gender(s).<br />
 * If unset, trends among all genders will be returned.<br />
 * The `unknown` group includes users with unspecified or customized gender profile settings.
 */
export type Parameterquery_gender_list = GenderList;

/**
 * TOTAL - metrics are aggregated over the specified date range.<br> DAY - metrics are broken down daily.<br> HOUR - metrics are broken down hourly.<br>WEEKLY - metrics are broken down weekly.<br>MONTHLY - metrics are broken down monthly
 */
export type Parameterquery_granularity = Granularity;

/**
 * TOTAL - metrics are aggregated over the specified date range.<br> DAY - metrics are broken down daily.<br> HOUR - metrics are broken down hourly.<br>WEEKLY - metrics are broken down weekly.<br>MONTHLY - metrics are broken down monthly
 */
export type Parameterquery_granularity_async = Granularity;

/**
 * Return HTML in TOS text.
 */
export type Parameterquery_include_html = boolean;

/**
 * Specify if return pins from protected boards
 */
export type Parameterquery_include_protected_pins = boolean;

/**
 * Include shared ad accounts
 */
export type Parameterquery_include_shared_accounts = boolean;

/**
 * Input term.
 */
export type Parameterquery_input_term = string;

/**
 * If set, filters the results to trends associated with the specified interests.<br />
 * If unset, trends for all interests will be returned.<br />
 * The list of supported interests is:
 * - `animals` - Animals
 * - `architecture` - Architecture
 * - `art` - Art
 * - `beauty` - Beauty
 * - `childrens_fashion` - Children's Fashion
 * - `design` - Design
 * - `diy_and_crafts` - DIY & Crafts
 * - `education` - Education
 * - `electronics` - Electronics
 * - `entertainment` - Entertainment
 * - `event_planning` - Event Planning
 * - `finance` - Finance
 * - `food_and_drinks` - Food & Drink
 * - `gardening` - Gardening
 * - `health` - Health
 * - `home_decor` - Home Decor
 * - `mens_fashion` - Men's Fashion
 * - `parenting` - Parenting
 * - `quotes` - Quotes
 * - `sport` - Sports
 * - `travel` - Travel
 * - `vehicles` - Vehicles
 * - `wedding` - Wedding
 * - `womens_fashion` - Women's Fashion
 */
export type Parameterquery_interest_list = L1InterestList;

/**
 * A boolean field to indicate whether the invite is to create a partnership or a membership.
 */
export type Parameterquery_is_member = boolean;

/**
 * Comma-separated keywords
 */
export type Parameterquery_keywords = Array<string>;

/**
 * Specify whether to return 90d and lifetime Pin metrics. Total comments and total reactions are only available with lifetime Pin metrics. If Pin was created before <code>2023-03-20</code> lifetime metrics will only be available for Video and Idea Pin formats. Lifetime metrics are available for all Pin formats since then.
 */
export type Parameterquery_pin_metrics = boolean;

/**
 * List of input terms.
 */
export type Parameterquery_list_input_terms = Array<string>;

/**
 * Keyword <a target="_blank" href="/docs/api-features/targeting-overview/">match type</a>
 */
export type Parameterquery_match_types = Array<MatchType>;

/**
 * A list of business members ids separated by comma to filter the results. Only members with the specified ids will be returned.
 */
export type Parameterquery_members = string;

/**
 * A list of business partners ids separated by comma.
 */
export type Parameterquery_partners = string;

/**
 * Metric types to get data for, default is all.
 */
export type Parameterquery_metric_types = Array<
  | 'ENGAGEMENT'
  | 'ENGAGEMENT_RATE'
  | 'IMPRESSION'
  | 'OUTBOUND_CLICK'
  | 'OUTBOUND_CLICK_RATE'
  | 'PIN_CLICK'
  | 'PIN_CLICK_RATE'
  | 'SAVE'
  | 'SAVE_RATE'
>;

/**
 * Governs how the resulting time series data will be normalized to a [0-100] scale.<br />
 * By default (`false`), the data will be normalized independently for each keyword.  The peak search volume observation in *each* keyword's time series will be represented by the value 100.  This is ideal for analyzing when an individual keyword is expected to peak in interest.<br />
 * If set to `true`, the data will be normalized as a group.  The peak search volume observation across *all* keywords in the response will be represented by the value 100, and all other values scaled accordingly.  Use this option when you wish to compare relative search volume between multiple keywords.
 */
export type Parameterquery_normalize_against_group = boolean;

/**
 * Number of pins to include, default is 10. Max is 50.
 */
export type Parameterquery_num_of_pins = number;

/**
 * Oauth signature
 */
export type Parameterquery_oauth_signature = string;

/**
 * The order in which to sort the items returned: “ASCENDING” or “DESCENDING”
 * by ID. Note that higher-value IDs are associated with more-recently added
 * items.
 */
export type Parameterquery_order = 'ASCENDING' | 'DESCENDING';

/**
 * The audience field to order results by.
 */
export type Parameterquery_order_by = GetAudiencesOrderBy;

/**
 * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
 */
export type Parameterquery_page_size = number;

/**
 * Pin metric types to get data for. VIDEO_MRC_VIEW are Video views, VIDEO_V50_WATCH_TIME is Total play time. If Pin was created before <code>2023-03-20</code>, Profile visits and Follows will only be available for Idea Pins. These metrics are available for all Pin formats since then. Keep in mind this cannot have ALL if split_field is set to any value other than <code>NO_SPLIT</code>.
 */
export type Parameterquery_pin_analytics_metric_types = Array<
  | 'IMPRESSION'
  | 'OUTBOUND_CLICK'
  | 'PIN_CLICK'
  | 'SAVE'
  | 'SAVE_RATE'
  | 'TOTAL_COMMENTS'
  | 'TOTAL_REACTIONS'
  | 'USER_FOLLOW'
  | 'PROFILE_VISIT'
  | 'IMPRESSION'
  | 'OUTBOUND_CLICK'
  | 'PIN_CLICK'
  | 'SAVE'
  | 'SAVE_RATE'
  | 'VIDEO_MRC_VIEW'
  | 'VIDEO_10S_VIEW'
  | 'QUARTILE_95_PERCENT_VIEW'
  | 'VIDEO_V50_WATCH_TIME'
  | 'VIDEO_START'
  | 'VIDEO_AVG_WATCH_TIME'
  | 'TOTAL_COMMENTS'
  | 'TOTAL_REACTIONS'
>;

/**
 * Pin filter.
 */
export type Parameterquery_pin_filter = 'exclude_native' | 'exclude_repins' | 'has_been_promoted';

/**
 * Pin formats to get data for, default is all.
 */
export type Parameterquery_pin_format =
  | 'ALL'
  | 'ORGANIC_IMAGE'
  | 'ORGANIC_PRODUCT'
  | 'ORGANIC_VIDEO'
  | 'ADS_STANDARD'
  | 'ADS_PRODUCT'
  | 'ADS_VIDEO'
  | 'ADS_IDEA';

/**
 * The pin order id associated with the ssio insertino order
 */
export type Parameterquery_pin_order_id = string;

/**
 * The type of pins to return, currently only enabled for private pins
 */
export type Parameterquery_pin_type = 'PRIVATE';

/**
 * List of Product group Ids to use to filter the results.
 */
export type Parameterquery_product_group_ids_required = Array<string>;

/**
 * List of Product group promotion Ids.
 */
export type Parameterquery_product_group_promotion_ids = Array<string>;

/**
 * Search query. Can contain pin description keywords or comma-separated pin IDs.
 */
export type Parameterquery_query = string;

/**
 * Filter accounts by account type.
 */
export type Parameterquery_account_type = AudienceAccountType;

/**
 * Report type.
 */
export type Parameterquery_report_type = 'SYNC' | 'ASYNC';

/**
 * List of Pin IDs.
 */
export type Parameterquery_required_pin_ids = Array<string>;

/**
 * Search query. Can contain pin description keywords or comma-separated pin IDs.
 */
export type Parameterquery_required_search_query = string;

/**
 * A resource type to filter the assets by. Only assets of the specified type will be returned.
 */
export type Parameterquery_resource_type = 'AD_ACCOUNT' | 'PROFILE' | 'ASSET_GROUP';

/**
 * String keywords to search for audiences by.
 */
export type Parameterquery_search_query = string;

/**
 * Sort method. Only RATIO is supported.
 */
export type Parameterquery_sort = 'RATIO';

/**
 * Specify sorting order for metrics
 */
export type Parameterquery_sort_by = 'ENGAGEMENT' | 'IMPRESSION' | 'OUTBOUND_CLICK' | 'PIN_CLICK' | 'SAVE';

/**
 * Filter to activity from Pins created and saved by your, or activity created and saved by others from your claimed accounts
 */
export type Parameterquery_source = 'ALL' | 'YOUR_PINS' | 'OTHER_PINS';

/**
 * How to split the data into groups. Not including this param means data won't be split.
 */
export type Parameterquery_split_field_pins = 'NO_SPLIT' | 'APP_TYPE';

/**
 * How to split the data into groups. Not including this param means data won't be split.
 */
export type Parameterquery_split_field_user_account =
  | 'NO_SPLIT'
  | 'APP_TYPE'
  | 'OWNED_CONTENT'
  | 'SOURCE'
  | 'PIN_FORMAT';

/**
 * Metric report start date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days back from today.
 */
export type Parameterquery_start_date = string;

/**
 * Metric report start date (UTC). Format: YYYY-MM-DD. Cannot be more than 2.5 years back from today.
 */
export type Parameterquery_start_date_async = string;

/**
 * The starting index for returned list.
 */
export type Parameterquery_start_index = string;

/**
 * An index to start fetching the results from. Only the results starting from this index will be returned.
 */
export type Parameterquery_business_access_start_index = number;

/**
 * Specifies whether to fetch internal or external (shared) partners.
 * If partner_type=INTERNAL, the asset being queried is for accesses the partner has to your business assets.<br>
 * If partner_type=EXTERNAL, the asset being queried is for the accesses you have to the partner's business asset.
 */
export type Parameterquery_business_partner_type = PartnerType;

/**
 * Targeting type breakdowns for the report. The reporting per targeting type <br> is independent from each other. ["AGE_BUCKET_AND_GENDER"] is in BETA and not yet available to all users.
 */
export type Parameterquery_targeting_types = Array<AdsAnalyticsTargetingType>;

/**
 * Max suggested terms to return.
 */
export type Parameterquery_term_limit = number;

/**
 * Timestamp
 */
export type Parameterquery_timestamp = string;

/**
 * Token returned from the post request creation call
 */
export type Parameterquery_token_required = string;

/**
 * Request type.
 */
export type Parameterquery_tos_type = string;

/**
 * Return interests as text names (if value is true) rather than topic IDs.
 */
export type Parameterquery_translate_interests_to_names = boolean;

/**
 * The maximum number of trending keywords that will be returned. Keywords are returned in trend-ranked order, so a `limit` of 50 will return the top 50 trends.
 */
export type Parameterquery_trending_keyword_limit = number;

/**
 * Thrift param specifying what type of followees will be kept. Default to include all followees.
 */
export type Parameterquery_user_following_feed_type = UserFollowingFeedType;

/**
 * Name of the user to be looked up.
 */
export type Parameterquery_username = string;

/**
 * Metric types to get video data for, default is all.
 */
export type Parameterquery_video_pin_metric_types = Array<
  | 'IMPRESSION'
  | 'SAVE'
  | 'VIDEO_MRC_VIEW'
  | 'VIDEO_AVG_WATCH_TIME'
  | 'VIDEO_V50_WATCH_TIME'
  | 'QUARTILE_95_PERCENT_VIEW'
  | 'VIDEO_10S_VIEW'
  | 'VIDEO_START'
  | 'OUTBOUND_CLICK'
>;

/**
 * Specify sorting order for video metrics
 */
export type Parameterquery_video_pin_sort_by =
  | 'IMPRESSION'
  | 'SAVE'
  | 'OUTBOUND_CLICK'
  | 'VIDEO_MRC_VIEW'
  | 'VIDEO_AVG_WATCH_TIME'
  | 'VIDEO_V50_WATCH_TIME'
  | 'QUARTILE_95_PERCENT_VIEW'
  | 'VIDEO_10S_VIEW'
  | 'VIDEO_START';

/**
 * Website with path or domain only
 */
export type Parameterquery_website = string;

/**
 * A list of invite statuses to filter invites by. Only invites whose status is in the provided statuses will be returned.
 */
export type Parameterquery_invite_status = Array<'PENDING' | 'EXPIRED'>;

/**
 * Invite type to filter invites by. Only invites of the specified type will be returned.
 */
export type Parameterquery_invite_type = InviteType;

export type AdAccountsListData = {
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Include shared ad accounts
     */
    include_shared_accounts?: boolean;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type AdAccountsListResponse = Paginated & {
  /**
   * Ad accounts
   */
  items?: unknown;
};

export type AdAccountsListError = Error;

export type AdAccountsCreateData = {
  /**
   * Ad account to create.
   */
  body: AdAccountCreateRequest;
};

export type AdAccountsCreateResponse = AdAccount;

export type AdAccountsCreateError = Error;

export type AdAccountsGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type AdAccountsGetResponse = AdAccount;

export type AdAccountsGetError = Error;

export type AdGroupsListData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * List of Ad group Ids to use to filter the results.
     */
    ad_group_ids?: Array<string>;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * List of Campaign Ids to use to filter the results.
     */
    campaign_ids?: Array<string>;
    /**
     * Entity status
     */
    entity_statuses?: Array<'ACTIVE' | 'PAUSED' | 'ARCHIVED' | 'DRAFT' | 'DELETED_DRAFT'>;
    /**
     * The order in which to sort the items returned: “ASCENDING” or “DESCENDING”
     * by ID. Note that higher-value IDs are associated with more-recently added
     * items.
     */
    order?: 'ASCENDING' | 'DESCENDING';
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
    /**
     * Return interests as text names (if value is true) rather than topic IDs.
     */
    translate_interests_to_names?: boolean;
  };
};

export type AdGroupsListResponse = Paginated & {
  items?: Array<AdGroupResponse>;
};

export type AdGroupsListError = Error;

export type AdGroupsCreateData = {
  /**
   * List of ad groups to create, size limit [1, 30].
   */
  body: Array<AdGroupCreateRequest>;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type AdGroupsCreateResponse = AdGroupArrayResponse;

export type AdGroupsCreateError = Error;

export type AdGroupsUpdateData = {
  /**
   * List of ad groups to update, size limit [1, 30].
   */
  body: Array<AdGroupUpdateRequest>;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type AdGroupsUpdateResponse = AdGroupArrayResponse;

export type AdGroupsUpdateError = Error;

export type AdGroupsAnalyticsData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query: {
    /**
     * List of Ad group Ids to use to filter the results.
     */
    ad_group_ids: Array<string>;
    /**
     * Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
     */
    click_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
    /**
     * Columns to retrieve, encoded as a comma-separated string. **NOTE**: Any metrics defined as MICRO_DOLLARS returns a value based on the advertiser profile's currency field. For USD,($1/1,000,000, or $0.000001 - one one-ten-thousandth of a cent). it's microdollars. Otherwise, it's in microunits of the advertiser's currency.<br/>For example, if the advertiser's currency is GBP (British pound sterling), all MICRO_DOLLARS fields will be in GBP microunits (1/1,000,000 British pound).<br/>If a column has no value, it may not be returned
     */
    columns: Array<
      | 'SPEND_IN_MICRO_DOLLAR'
      | 'PAID_IMPRESSION'
      | 'SPEND_IN_DOLLAR'
      | 'CPC_IN_MICRO_DOLLAR'
      | 'ECPC_IN_MICRO_DOLLAR'
      | 'ECPC_IN_DOLLAR'
      | 'CTR'
      | 'ECTR'
      | 'CAMPAIGN_NAME'
      | 'PIN_ID'
      | 'TOTAL_ENGAGEMENT'
      | 'ENGAGEMENT_1'
      | 'ENGAGEMENT_2'
      | 'ECPE_IN_DOLLAR'
      | 'ENGAGEMENT_RATE'
      | 'EENGAGEMENT_RATE'
      | 'ECPM_IN_MICRO_DOLLAR'
      | 'REPIN_RATE'
      | 'CTR_2'
      | 'CAMPAIGN_ID'
      | 'ADVERTISER_ID'
      | 'AD_ACCOUNT_ID'
      | 'PIN_PROMOTION_ID'
      | 'AD_ID'
      | 'AD_GROUP_ID'
      | 'CAMPAIGN_ENTITY_STATUS'
      | 'CAMPAIGN_OBJECTIVE_TYPE'
      | 'CPM_IN_MICRO_DOLLAR'
      | 'CPM_IN_DOLLAR'
      | 'AD_GROUP_ENTITY_STATUS'
      | 'ORDER_LINE_ID'
      | 'ORDER_LINE_NAME'
      | 'CLICKTHROUGH_1'
      | 'REPIN_1'
      | 'IMPRESSION_1'
      | 'IMPRESSION_1_GROSS'
      | 'CLICKTHROUGH_1_GROSS'
      | 'OUTBOUND_CLICK_1'
      | 'CLICKTHROUGH_2'
      | 'REPIN_2'
      | 'IMPRESSION_2'
      | 'OUTBOUND_CLICK_2'
      | 'TOTAL_CLICKTHROUGH'
      | 'TOTAL_IMPRESSION'
      | 'TOTAL_IMPRESSION_USER'
      | 'TOTAL_IMPRESSION_FREQUENCY'
      | 'COST_PER_OUTBOUND_CLICK_IN_DOLLAR'
      | 'TOTAL_ENGAGEMENT_SIGNUP'
      | 'TOTAL_ENGAGEMENT_CHECKOUT'
      | 'TOTAL_ENGAGEMENT_LEAD'
      | 'TOTAL_CLICK_SIGNUP'
      | 'TOTAL_CLICK_CHECKOUT'
      | 'TOTAL_CLICK_ADD_TO_CART'
      | 'TOTAL_CLICK_LEAD'
      | 'TOTAL_VIEW_SIGNUP'
      | 'TOTAL_VIEW_CHECKOUT'
      | 'TOTAL_VIEW_ADD_TO_CART'
      | 'TOTAL_VIEW_LEAD'
      | 'TOTAL_CONVERSIONS'
      | 'TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_SESSIONS'
      | 'WEB_SESSIONS_1'
      | 'WEB_SESSIONS_2'
      | 'CAMPAIGN_LIFETIME_SPEND_CAP'
      | 'CAMPAIGN_DAILY_SPEND_CAP'
      | 'TOTAL_PAGE_VISIT'
      | 'TOTAL_SIGNUP'
      | 'TOTAL_CHECKOUT'
      | 'TOTAL_CUSTOM'
      | 'TOTAL_LEAD'
      | 'TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'
      | 'PAGE_VISIT_COST_PER_ACTION'
      | 'PAGE_VISIT_ROAS'
      | 'CHECKOUT_ROAS'
      | 'CUSTOM_ROAS'
      | 'VIDEO_MRC_VIEWS_1'
      | 'VIDEO_3SEC_VIEWS_2'
      | 'VIDEO_P100_COMPLETE_2'
      | 'VIDEO_P0_COMBINED_2'
      | 'VIDEO_P25_COMBINED_2'
      | 'VIDEO_P50_COMBINED_2'
      | 'VIDEO_P75_COMBINED_2'
      | 'VIDEO_P95_COMBINED_2'
      | 'VIDEO_MRC_VIEWS_2'
      | 'PAID_VIDEO_VIEWABLE_RATE'
      | 'VIDEO_LENGTH'
      | 'ECPV_IN_DOLLAR'
      | 'ECPCV_IN_DOLLAR'
      | 'ECPCV_P95_IN_DOLLAR'
      | 'TOTAL_VIDEO_3SEC_VIEWS'
      | 'TOTAL_VIDEO_P100_COMPLETE'
      | 'TOTAL_VIDEO_P0_COMBINED'
      | 'TOTAL_VIDEO_P25_COMBINED'
      | 'TOTAL_VIDEO_P50_COMBINED'
      | 'TOTAL_VIDEO_P75_COMBINED'
      | 'TOTAL_VIDEO_P95_COMBINED'
      | 'TOTAL_VIDEO_MRC_VIEWS'
      | 'TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'
      | 'TOTAL_REPIN_RATE'
      | 'WEB_CHECKOUT_COST_PER_ACTION'
      | 'WEB_CHECKOUT_ROAS'
      | 'TOTAL_WEB_CHECKOUT'
      | 'TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_CLICK_CHECKOUT'
      | 'TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT'
      | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_VIEW_CHECKOUT'
      | 'TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'INAPP_CHECKOUT_COST_PER_ACTION'
      | 'TOTAL_OFFLINE_CHECKOUT'
      | 'IDEA_PIN_PRODUCT_TAG_VISIT_1'
      | 'IDEA_PIN_PRODUCT_TAG_VISIT_2'
      | 'TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'
      | 'LEADS'
      | 'COST_PER_LEAD'
      | 'QUIZ_COMPLETED'
      | 'QUIZ_PIN_RESULT_OPEN'
      | 'QUIZ_COMPLETION_RATE'
      | 'SHOWCASE_PIN_CLICKTHROUGH'
      | 'SHOWCASE_SUBPAGE_CLICKTHROUGH'
      | 'SHOWCASE_SUBPIN_CLICKTHROUGH'
      | 'SHOWCASE_SUBPAGE_IMPRESSION'
      | 'SHOWCASE_SUBPIN_IMPRESSION'
      | 'SHOWCASE_SUBPAGE_SWIPE_LEFT'
      | 'SHOWCASE_SUBPAGE_SWIPE_RIGHT'
      | 'SHOWCASE_SUBPIN_SWIPE_LEFT'
      | 'SHOWCASE_SUBPIN_SWIPE_RIGHT'
      | 'SHOWCASE_SUBPAGE_REPIN'
      | 'SHOWCASE_SUBPIN_REPIN'
      | 'SHOWCASE_SUBPAGE_CLOSEUP'
      | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'
      | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'
      | 'SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'
      | 'TOTAL_CHECKOUT_CONVERSION_RATE'
      | 'TOTAL_VIEW_CATEGORY_CONVERSION_RATE'
      | 'TOTAL_ADD_TO_CART_CONVERSION_RATE'
      | 'TOTAL_SIGNUP_CONVERSION_RATE'
      | 'TOTAL_PAGE_VISIT_CONVERSION_RATE'
      | 'TOTAL_LEAD_CONVERSION_RATE'
      | 'TOTAL_SEARCH_CONVERSION_RATE'
      | 'TOTAL_WATCH_VIDEO_CONVERSION_RATE'
      | 'TOTAL_UNKNOWN_CONVERSION_RATE'
      | 'TOTAL_CUSTOM_CONVERSION_RATE'
    >;
    /**
     * The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.
     */
    conversion_report_time?: 'TIME_OF_AD_ACTION' | 'TIME_OF_CONVERSION';
    /**
     * Metric report end date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days past start_date.
     */
    end_date: string;
    /**
     * Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
     */
    engagement_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
    /**
     * TOTAL - metrics are aggregated over the specified date range.<br> DAY - metrics are broken down daily.<br> HOUR - metrics are broken down hourly.<br>WEEKLY - metrics are broken down weekly.<br>MONTHLY - metrics are broken down monthly
     */
    granularity: Granularity;
    /**
     * Metric report start date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days back from today.
     */
    start_date: string;
    /**
     * Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.
     */
    view_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
  };
};

export type AdGroupsAnalyticsResponse2 = AdGroupsAnalyticsResponse;

export type AdGroupsAnalyticsError = Error;

export type AdGroupsTargetingAnalyticsGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query: {
    /**
     * List of Ad group Ids to use to filter the results.
     */
    ad_group_ids: Array<string>;
    /**
     * List of types of attribution for the conversion report
     */
    attribution_types?: ConversionReportAttributionType;
    /**
     * Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
     */
    click_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
    /**
     * Columns to retrieve, encoded as a comma-separated string. **NOTE**: Any metrics defined as MICRO_DOLLARS returns a value based on the advertiser profile's currency field. For USD,($1/1,000,000, or $0.000001 - one one-ten-thousandth of a cent). it's microdollars. Otherwise, it's in microunits of the advertiser's currency.<br/>For example, if the advertiser's currency is GBP (British pound sterling), all MICRO_DOLLARS fields will be in GBP microunits (1/1,000,000 British pound).<br/>If a column has no value, it may not be returned
     */
    columns: Array<
      | 'SPEND_IN_MICRO_DOLLAR'
      | 'PAID_IMPRESSION'
      | 'SPEND_IN_DOLLAR'
      | 'CPC_IN_MICRO_DOLLAR'
      | 'ECPC_IN_MICRO_DOLLAR'
      | 'ECPC_IN_DOLLAR'
      | 'CTR'
      | 'ECTR'
      | 'CAMPAIGN_NAME'
      | 'PIN_ID'
      | 'TOTAL_ENGAGEMENT'
      | 'ENGAGEMENT_1'
      | 'ENGAGEMENT_2'
      | 'ECPE_IN_DOLLAR'
      | 'ENGAGEMENT_RATE'
      | 'EENGAGEMENT_RATE'
      | 'ECPM_IN_MICRO_DOLLAR'
      | 'REPIN_RATE'
      | 'CTR_2'
      | 'CAMPAIGN_ID'
      | 'ADVERTISER_ID'
      | 'AD_ACCOUNT_ID'
      | 'PIN_PROMOTION_ID'
      | 'AD_ID'
      | 'AD_GROUP_ID'
      | 'CAMPAIGN_ENTITY_STATUS'
      | 'CAMPAIGN_OBJECTIVE_TYPE'
      | 'CPM_IN_MICRO_DOLLAR'
      | 'CPM_IN_DOLLAR'
      | 'AD_GROUP_ENTITY_STATUS'
      | 'ORDER_LINE_ID'
      | 'ORDER_LINE_NAME'
      | 'CLICKTHROUGH_1'
      | 'REPIN_1'
      | 'IMPRESSION_1'
      | 'IMPRESSION_1_GROSS'
      | 'CLICKTHROUGH_1_GROSS'
      | 'OUTBOUND_CLICK_1'
      | 'CLICKTHROUGH_2'
      | 'REPIN_2'
      | 'IMPRESSION_2'
      | 'OUTBOUND_CLICK_2'
      | 'TOTAL_CLICKTHROUGH'
      | 'TOTAL_IMPRESSION'
      | 'TOTAL_IMPRESSION_USER'
      | 'TOTAL_IMPRESSION_FREQUENCY'
      | 'COST_PER_OUTBOUND_CLICK_IN_DOLLAR'
      | 'TOTAL_ENGAGEMENT_SIGNUP'
      | 'TOTAL_ENGAGEMENT_CHECKOUT'
      | 'TOTAL_ENGAGEMENT_LEAD'
      | 'TOTAL_CLICK_SIGNUP'
      | 'TOTAL_CLICK_CHECKOUT'
      | 'TOTAL_CLICK_ADD_TO_CART'
      | 'TOTAL_CLICK_LEAD'
      | 'TOTAL_VIEW_SIGNUP'
      | 'TOTAL_VIEW_CHECKOUT'
      | 'TOTAL_VIEW_ADD_TO_CART'
      | 'TOTAL_VIEW_LEAD'
      | 'TOTAL_CONVERSIONS'
      | 'TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_SESSIONS'
      | 'WEB_SESSIONS_1'
      | 'WEB_SESSIONS_2'
      | 'CAMPAIGN_LIFETIME_SPEND_CAP'
      | 'CAMPAIGN_DAILY_SPEND_CAP'
      | 'TOTAL_PAGE_VISIT'
      | 'TOTAL_SIGNUP'
      | 'TOTAL_CHECKOUT'
      | 'TOTAL_CUSTOM'
      | 'TOTAL_LEAD'
      | 'TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'
      | 'PAGE_VISIT_COST_PER_ACTION'
      | 'PAGE_VISIT_ROAS'
      | 'CHECKOUT_ROAS'
      | 'CUSTOM_ROAS'
      | 'VIDEO_MRC_VIEWS_1'
      | 'VIDEO_3SEC_VIEWS_2'
      | 'VIDEO_P100_COMPLETE_2'
      | 'VIDEO_P0_COMBINED_2'
      | 'VIDEO_P25_COMBINED_2'
      | 'VIDEO_P50_COMBINED_2'
      | 'VIDEO_P75_COMBINED_2'
      | 'VIDEO_P95_COMBINED_2'
      | 'VIDEO_MRC_VIEWS_2'
      | 'PAID_VIDEO_VIEWABLE_RATE'
      | 'VIDEO_LENGTH'
      | 'ECPV_IN_DOLLAR'
      | 'ECPCV_IN_DOLLAR'
      | 'ECPCV_P95_IN_DOLLAR'
      | 'TOTAL_VIDEO_3SEC_VIEWS'
      | 'TOTAL_VIDEO_P100_COMPLETE'
      | 'TOTAL_VIDEO_P0_COMBINED'
      | 'TOTAL_VIDEO_P25_COMBINED'
      | 'TOTAL_VIDEO_P50_COMBINED'
      | 'TOTAL_VIDEO_P75_COMBINED'
      | 'TOTAL_VIDEO_P95_COMBINED'
      | 'TOTAL_VIDEO_MRC_VIEWS'
      | 'TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'
      | 'TOTAL_REPIN_RATE'
      | 'WEB_CHECKOUT_COST_PER_ACTION'
      | 'WEB_CHECKOUT_ROAS'
      | 'TOTAL_WEB_CHECKOUT'
      | 'TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_CLICK_CHECKOUT'
      | 'TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT'
      | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_VIEW_CHECKOUT'
      | 'TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'INAPP_CHECKOUT_COST_PER_ACTION'
      | 'TOTAL_OFFLINE_CHECKOUT'
      | 'IDEA_PIN_PRODUCT_TAG_VISIT_1'
      | 'IDEA_PIN_PRODUCT_TAG_VISIT_2'
      | 'TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'
      | 'LEADS'
      | 'COST_PER_LEAD'
      | 'QUIZ_COMPLETED'
      | 'QUIZ_PIN_RESULT_OPEN'
      | 'QUIZ_COMPLETION_RATE'
      | 'SHOWCASE_PIN_CLICKTHROUGH'
      | 'SHOWCASE_SUBPAGE_CLICKTHROUGH'
      | 'SHOWCASE_SUBPIN_CLICKTHROUGH'
      | 'SHOWCASE_SUBPAGE_IMPRESSION'
      | 'SHOWCASE_SUBPIN_IMPRESSION'
      | 'SHOWCASE_SUBPAGE_SWIPE_LEFT'
      | 'SHOWCASE_SUBPAGE_SWIPE_RIGHT'
      | 'SHOWCASE_SUBPIN_SWIPE_LEFT'
      | 'SHOWCASE_SUBPIN_SWIPE_RIGHT'
      | 'SHOWCASE_SUBPAGE_REPIN'
      | 'SHOWCASE_SUBPIN_REPIN'
      | 'SHOWCASE_SUBPAGE_CLOSEUP'
      | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'
      | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'
      | 'SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'
      | 'TOTAL_CHECKOUT_CONVERSION_RATE'
      | 'TOTAL_VIEW_CATEGORY_CONVERSION_RATE'
      | 'TOTAL_ADD_TO_CART_CONVERSION_RATE'
      | 'TOTAL_SIGNUP_CONVERSION_RATE'
      | 'TOTAL_PAGE_VISIT_CONVERSION_RATE'
      | 'TOTAL_LEAD_CONVERSION_RATE'
      | 'TOTAL_SEARCH_CONVERSION_RATE'
      | 'TOTAL_WATCH_VIDEO_CONVERSION_RATE'
      | 'TOTAL_UNKNOWN_CONVERSION_RATE'
      | 'TOTAL_CUSTOM_CONVERSION_RATE'
    >;
    /**
     * The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.
     */
    conversion_report_time?: 'TIME_OF_AD_ACTION' | 'TIME_OF_CONVERSION';
    /**
     * Metric report end date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days past start_date.
     */
    end_date: string;
    /**
     * Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
     */
    engagement_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
    /**
     * TOTAL - metrics are aggregated over the specified date range.<br> DAY - metrics are broken down daily.<br> HOUR - metrics are broken down hourly.<br>WEEKLY - metrics are broken down weekly.<br>MONTHLY - metrics are broken down monthly
     */
    granularity: Granularity;
    /**
     * Metric report start date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days back from today.
     */
    start_date: string;
    /**
     * Targeting type breakdowns for the report. The reporting per targeting type <br> is independent from each other. ["AGE_BUCKET_AND_GENDER"] is in BETA and not yet available to all users.
     */
    targeting_types: Array<AdsAnalyticsTargetingType>;
    /**
     * Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.
     */
    view_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
  };
};

export type AdGroupsTargetingAnalyticsGetResponse = MetricsResponse;

export type AdGroupsTargetingAnalyticsGetError = Error;

export type AdGroupsAudienceSizingData = {
  body?: AdGroupAudienceSizingRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type AdGroupsAudienceSizingResponse = AdGroupAudienceSizingResponse;

export type AdGroupsAudienceSizingError = Error;

export type AdGroupsGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
    /**
     * Unique identifier of an ad group.
     */
    ad_group_id: string;
  };
};

export type AdGroupsGetResponse = AdGroupResponse;

export type AdGroupsGetError = Error;

export type AdPreviewsCreateData = {
  /**
   * Create ad preview with pin or image.
   */
  body: AdPreviewRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type AdPreviewsCreateResponse = AdPreviewURLResponse;

export type AdPreviewsCreateError = Error;

export type AdsListData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * List of Ad group Ids to use to filter the results.
     */
    ad_group_ids?: Array<string>;
    /**
     * List of Ad Ids to use to filter the results.
     */
    ad_ids?: Array<string>;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * List of Campaign Ids to use to filter the results.
     */
    campaign_ids?: Array<string>;
    /**
     * Entity status
     */
    entity_statuses?: Array<'ACTIVE' | 'PAUSED' | 'ARCHIVED' | 'DRAFT' | 'DELETED_DRAFT'>;
    /**
     * The order in which to sort the items returned: “ASCENDING” or “DESCENDING”
     * by ID. Note that higher-value IDs are associated with more-recently added
     * items.
     */
    order?: 'ASCENDING' | 'DESCENDING';
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type AdsListResponse = Paginated & {
  items?: Array<AdResponse>;
};

export type AdsListError = Error;

export type AdsCreateData = {
  /**
   * List of ads to create, size limit [1, 30].
   */
  body: Array<AdCreateRequest>;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type AdsCreateResponse = AdArrayResponse;

export type AdsCreateError = Error;

export type AdsUpdateData = {
  /**
   * List of ads to update, size limit [1, 30]
   */
  body: Array<AdUpdateRequest>;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type AdsUpdateResponse = AdArrayResponse;

export type AdsUpdateError = Error;

export type AdsAnalyticsData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query: {
    /**
     * List of Ad Ids to use to filter the results.
     */
    ad_ids?: Array<string>;
    /**
     * List of Campaign Ids to use to filter the results.
     */
    campaign_ids?: Array<string>;
    /**
     * Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
     */
    click_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
    /**
     * Columns to retrieve, encoded as a comma-separated string. **NOTE**: Any metrics defined as MICRO_DOLLARS returns a value based on the advertiser profile's currency field. For USD,($1/1,000,000, or $0.000001 - one one-ten-thousandth of a cent). it's microdollars. Otherwise, it's in microunits of the advertiser's currency.<br/>For example, if the advertiser's currency is GBP (British pound sterling), all MICRO_DOLLARS fields will be in GBP microunits (1/1,000,000 British pound).<br/>If a column has no value, it may not be returned
     */
    columns: Array<
      | 'SPEND_IN_MICRO_DOLLAR'
      | 'PAID_IMPRESSION'
      | 'SPEND_IN_DOLLAR'
      | 'CPC_IN_MICRO_DOLLAR'
      | 'ECPC_IN_MICRO_DOLLAR'
      | 'ECPC_IN_DOLLAR'
      | 'CTR'
      | 'ECTR'
      | 'CAMPAIGN_NAME'
      | 'PIN_ID'
      | 'TOTAL_ENGAGEMENT'
      | 'ENGAGEMENT_1'
      | 'ENGAGEMENT_2'
      | 'ECPE_IN_DOLLAR'
      | 'ENGAGEMENT_RATE'
      | 'EENGAGEMENT_RATE'
      | 'ECPM_IN_MICRO_DOLLAR'
      | 'REPIN_RATE'
      | 'CTR_2'
      | 'CAMPAIGN_ID'
      | 'ADVERTISER_ID'
      | 'AD_ACCOUNT_ID'
      | 'PIN_PROMOTION_ID'
      | 'AD_ID'
      | 'AD_GROUP_ID'
      | 'CAMPAIGN_ENTITY_STATUS'
      | 'CAMPAIGN_OBJECTIVE_TYPE'
      | 'CPM_IN_MICRO_DOLLAR'
      | 'CPM_IN_DOLLAR'
      | 'AD_GROUP_ENTITY_STATUS'
      | 'ORDER_LINE_ID'
      | 'ORDER_LINE_NAME'
      | 'CLICKTHROUGH_1'
      | 'REPIN_1'
      | 'IMPRESSION_1'
      | 'IMPRESSION_1_GROSS'
      | 'CLICKTHROUGH_1_GROSS'
      | 'OUTBOUND_CLICK_1'
      | 'CLICKTHROUGH_2'
      | 'REPIN_2'
      | 'IMPRESSION_2'
      | 'OUTBOUND_CLICK_2'
      | 'TOTAL_CLICKTHROUGH'
      | 'TOTAL_IMPRESSION'
      | 'TOTAL_IMPRESSION_USER'
      | 'TOTAL_IMPRESSION_FREQUENCY'
      | 'COST_PER_OUTBOUND_CLICK_IN_DOLLAR'
      | 'TOTAL_ENGAGEMENT_SIGNUP'
      | 'TOTAL_ENGAGEMENT_CHECKOUT'
      | 'TOTAL_ENGAGEMENT_LEAD'
      | 'TOTAL_CLICK_SIGNUP'
      | 'TOTAL_CLICK_CHECKOUT'
      | 'TOTAL_CLICK_ADD_TO_CART'
      | 'TOTAL_CLICK_LEAD'
      | 'TOTAL_VIEW_SIGNUP'
      | 'TOTAL_VIEW_CHECKOUT'
      | 'TOTAL_VIEW_ADD_TO_CART'
      | 'TOTAL_VIEW_LEAD'
      | 'TOTAL_CONVERSIONS'
      | 'TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_SESSIONS'
      | 'WEB_SESSIONS_1'
      | 'WEB_SESSIONS_2'
      | 'CAMPAIGN_LIFETIME_SPEND_CAP'
      | 'CAMPAIGN_DAILY_SPEND_CAP'
      | 'TOTAL_PAGE_VISIT'
      | 'TOTAL_SIGNUP'
      | 'TOTAL_CHECKOUT'
      | 'TOTAL_CUSTOM'
      | 'TOTAL_LEAD'
      | 'TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'
      | 'PAGE_VISIT_COST_PER_ACTION'
      | 'PAGE_VISIT_ROAS'
      | 'CHECKOUT_ROAS'
      | 'CUSTOM_ROAS'
      | 'VIDEO_MRC_VIEWS_1'
      | 'VIDEO_3SEC_VIEWS_2'
      | 'VIDEO_P100_COMPLETE_2'
      | 'VIDEO_P0_COMBINED_2'
      | 'VIDEO_P25_COMBINED_2'
      | 'VIDEO_P50_COMBINED_2'
      | 'VIDEO_P75_COMBINED_2'
      | 'VIDEO_P95_COMBINED_2'
      | 'VIDEO_MRC_VIEWS_2'
      | 'PAID_VIDEO_VIEWABLE_RATE'
      | 'VIDEO_LENGTH'
      | 'ECPV_IN_DOLLAR'
      | 'ECPCV_IN_DOLLAR'
      | 'ECPCV_P95_IN_DOLLAR'
      | 'TOTAL_VIDEO_3SEC_VIEWS'
      | 'TOTAL_VIDEO_P100_COMPLETE'
      | 'TOTAL_VIDEO_P0_COMBINED'
      | 'TOTAL_VIDEO_P25_COMBINED'
      | 'TOTAL_VIDEO_P50_COMBINED'
      | 'TOTAL_VIDEO_P75_COMBINED'
      | 'TOTAL_VIDEO_P95_COMBINED'
      | 'TOTAL_VIDEO_MRC_VIEWS'
      | 'TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'
      | 'TOTAL_REPIN_RATE'
      | 'WEB_CHECKOUT_COST_PER_ACTION'
      | 'WEB_CHECKOUT_ROAS'
      | 'TOTAL_WEB_CHECKOUT'
      | 'TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_CLICK_CHECKOUT'
      | 'TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT'
      | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_VIEW_CHECKOUT'
      | 'TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'INAPP_CHECKOUT_COST_PER_ACTION'
      | 'TOTAL_OFFLINE_CHECKOUT'
      | 'IDEA_PIN_PRODUCT_TAG_VISIT_1'
      | 'IDEA_PIN_PRODUCT_TAG_VISIT_2'
      | 'TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'
      | 'LEADS'
      | 'COST_PER_LEAD'
      | 'QUIZ_COMPLETED'
      | 'QUIZ_PIN_RESULT_OPEN'
      | 'QUIZ_COMPLETION_RATE'
      | 'SHOWCASE_PIN_CLICKTHROUGH'
      | 'SHOWCASE_SUBPAGE_CLICKTHROUGH'
      | 'SHOWCASE_SUBPIN_CLICKTHROUGH'
      | 'SHOWCASE_SUBPAGE_IMPRESSION'
      | 'SHOWCASE_SUBPIN_IMPRESSION'
      | 'SHOWCASE_SUBPAGE_SWIPE_LEFT'
      | 'SHOWCASE_SUBPAGE_SWIPE_RIGHT'
      | 'SHOWCASE_SUBPIN_SWIPE_LEFT'
      | 'SHOWCASE_SUBPIN_SWIPE_RIGHT'
      | 'SHOWCASE_SUBPAGE_REPIN'
      | 'SHOWCASE_SUBPIN_REPIN'
      | 'SHOWCASE_SUBPAGE_CLOSEUP'
      | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'
      | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'
      | 'SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'
      | 'TOTAL_CHECKOUT_CONVERSION_RATE'
      | 'TOTAL_VIEW_CATEGORY_CONVERSION_RATE'
      | 'TOTAL_ADD_TO_CART_CONVERSION_RATE'
      | 'TOTAL_SIGNUP_CONVERSION_RATE'
      | 'TOTAL_PAGE_VISIT_CONVERSION_RATE'
      | 'TOTAL_LEAD_CONVERSION_RATE'
      | 'TOTAL_SEARCH_CONVERSION_RATE'
      | 'TOTAL_WATCH_VIDEO_CONVERSION_RATE'
      | 'TOTAL_UNKNOWN_CONVERSION_RATE'
      | 'TOTAL_CUSTOM_CONVERSION_RATE'
    >;
    /**
     * The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.
     */
    conversion_report_time?: 'TIME_OF_AD_ACTION' | 'TIME_OF_CONVERSION';
    /**
     * Metric report end date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days past start_date.
     */
    end_date: string;
    /**
     * Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
     */
    engagement_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
    /**
     * TOTAL - metrics are aggregated over the specified date range.<br> DAY - metrics are broken down daily.<br> HOUR - metrics are broken down hourly.<br>WEEKLY - metrics are broken down weekly.<br>MONTHLY - metrics are broken down monthly
     */
    granularity: Granularity;
    /**
     * List of Pin IDs.
     */
    pin_ids?: Array<string>;
    /**
     * Metric report start date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days back from today.
     */
    start_date: string;
    /**
     * Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.
     */
    view_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
  };
};

export type AdsAnalyticsResponse2 = AdsAnalyticsResponse;

export type AdsAnalyticsError = Error;

export type AdsCreditsDiscountsGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type AdsCreditsDiscountsGetResponse = Paginated & {
  items?: Array<AdsCreditDiscountsResponse>;
};

export type AdsCreditsDiscountsGetError = Error;

export type AdsCreditRedeemData = {
  /**
   * Redeem ad credits request.
   */
  body: AdsCreditRedeemRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type AdsCreditRedeemResponse2 = AdsCreditRedeemResponse;

export type AdsCreditRedeemError = Error;

export type AdTargetingAnalyticsGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query: {
    /**
     * List of Ad Ids to use to filter the results.
     */
    ad_ids: Array<string>;
    /**
     * List of types of attribution for the conversion report
     */
    attribution_types?: ConversionReportAttributionType;
    /**
     * Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
     */
    click_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
    /**
     * Columns to retrieve, encoded as a comma-separated string. **NOTE**: Any metrics defined as MICRO_DOLLARS returns a value based on the advertiser profile's currency field. For USD,($1/1,000,000, or $0.000001 - one one-ten-thousandth of a cent). it's microdollars. Otherwise, it's in microunits of the advertiser's currency.<br/>For example, if the advertiser's currency is GBP (British pound sterling), all MICRO_DOLLARS fields will be in GBP microunits (1/1,000,000 British pound).<br/>If a column has no value, it may not be returned
     */
    columns: Array<
      | 'SPEND_IN_MICRO_DOLLAR'
      | 'PAID_IMPRESSION'
      | 'SPEND_IN_DOLLAR'
      | 'CPC_IN_MICRO_DOLLAR'
      | 'ECPC_IN_MICRO_DOLLAR'
      | 'ECPC_IN_DOLLAR'
      | 'CTR'
      | 'ECTR'
      | 'CAMPAIGN_NAME'
      | 'PIN_ID'
      | 'TOTAL_ENGAGEMENT'
      | 'ENGAGEMENT_1'
      | 'ENGAGEMENT_2'
      | 'ECPE_IN_DOLLAR'
      | 'ENGAGEMENT_RATE'
      | 'EENGAGEMENT_RATE'
      | 'ECPM_IN_MICRO_DOLLAR'
      | 'REPIN_RATE'
      | 'CTR_2'
      | 'CAMPAIGN_ID'
      | 'ADVERTISER_ID'
      | 'AD_ACCOUNT_ID'
      | 'PIN_PROMOTION_ID'
      | 'AD_ID'
      | 'AD_GROUP_ID'
      | 'CAMPAIGN_ENTITY_STATUS'
      | 'CAMPAIGN_OBJECTIVE_TYPE'
      | 'CPM_IN_MICRO_DOLLAR'
      | 'CPM_IN_DOLLAR'
      | 'AD_GROUP_ENTITY_STATUS'
      | 'ORDER_LINE_ID'
      | 'ORDER_LINE_NAME'
      | 'CLICKTHROUGH_1'
      | 'REPIN_1'
      | 'IMPRESSION_1'
      | 'IMPRESSION_1_GROSS'
      | 'CLICKTHROUGH_1_GROSS'
      | 'OUTBOUND_CLICK_1'
      | 'CLICKTHROUGH_2'
      | 'REPIN_2'
      | 'IMPRESSION_2'
      | 'OUTBOUND_CLICK_2'
      | 'TOTAL_CLICKTHROUGH'
      | 'TOTAL_IMPRESSION'
      | 'TOTAL_IMPRESSION_USER'
      | 'TOTAL_IMPRESSION_FREQUENCY'
      | 'COST_PER_OUTBOUND_CLICK_IN_DOLLAR'
      | 'TOTAL_ENGAGEMENT_SIGNUP'
      | 'TOTAL_ENGAGEMENT_CHECKOUT'
      | 'TOTAL_ENGAGEMENT_LEAD'
      | 'TOTAL_CLICK_SIGNUP'
      | 'TOTAL_CLICK_CHECKOUT'
      | 'TOTAL_CLICK_ADD_TO_CART'
      | 'TOTAL_CLICK_LEAD'
      | 'TOTAL_VIEW_SIGNUP'
      | 'TOTAL_VIEW_CHECKOUT'
      | 'TOTAL_VIEW_ADD_TO_CART'
      | 'TOTAL_VIEW_LEAD'
      | 'TOTAL_CONVERSIONS'
      | 'TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_SESSIONS'
      | 'WEB_SESSIONS_1'
      | 'WEB_SESSIONS_2'
      | 'CAMPAIGN_LIFETIME_SPEND_CAP'
      | 'CAMPAIGN_DAILY_SPEND_CAP'
      | 'TOTAL_PAGE_VISIT'
      | 'TOTAL_SIGNUP'
      | 'TOTAL_CHECKOUT'
      | 'TOTAL_CUSTOM'
      | 'TOTAL_LEAD'
      | 'TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'
      | 'PAGE_VISIT_COST_PER_ACTION'
      | 'PAGE_VISIT_ROAS'
      | 'CHECKOUT_ROAS'
      | 'CUSTOM_ROAS'
      | 'VIDEO_MRC_VIEWS_1'
      | 'VIDEO_3SEC_VIEWS_2'
      | 'VIDEO_P100_COMPLETE_2'
      | 'VIDEO_P0_COMBINED_2'
      | 'VIDEO_P25_COMBINED_2'
      | 'VIDEO_P50_COMBINED_2'
      | 'VIDEO_P75_COMBINED_2'
      | 'VIDEO_P95_COMBINED_2'
      | 'VIDEO_MRC_VIEWS_2'
      | 'PAID_VIDEO_VIEWABLE_RATE'
      | 'VIDEO_LENGTH'
      | 'ECPV_IN_DOLLAR'
      | 'ECPCV_IN_DOLLAR'
      | 'ECPCV_P95_IN_DOLLAR'
      | 'TOTAL_VIDEO_3SEC_VIEWS'
      | 'TOTAL_VIDEO_P100_COMPLETE'
      | 'TOTAL_VIDEO_P0_COMBINED'
      | 'TOTAL_VIDEO_P25_COMBINED'
      | 'TOTAL_VIDEO_P50_COMBINED'
      | 'TOTAL_VIDEO_P75_COMBINED'
      | 'TOTAL_VIDEO_P95_COMBINED'
      | 'TOTAL_VIDEO_MRC_VIEWS'
      | 'TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'
      | 'TOTAL_REPIN_RATE'
      | 'WEB_CHECKOUT_COST_PER_ACTION'
      | 'WEB_CHECKOUT_ROAS'
      | 'TOTAL_WEB_CHECKOUT'
      | 'TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_CLICK_CHECKOUT'
      | 'TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT'
      | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_VIEW_CHECKOUT'
      | 'TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'INAPP_CHECKOUT_COST_PER_ACTION'
      | 'TOTAL_OFFLINE_CHECKOUT'
      | 'IDEA_PIN_PRODUCT_TAG_VISIT_1'
      | 'IDEA_PIN_PRODUCT_TAG_VISIT_2'
      | 'TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'
      | 'LEADS'
      | 'COST_PER_LEAD'
      | 'QUIZ_COMPLETED'
      | 'QUIZ_PIN_RESULT_OPEN'
      | 'QUIZ_COMPLETION_RATE'
      | 'SHOWCASE_PIN_CLICKTHROUGH'
      | 'SHOWCASE_SUBPAGE_CLICKTHROUGH'
      | 'SHOWCASE_SUBPIN_CLICKTHROUGH'
      | 'SHOWCASE_SUBPAGE_IMPRESSION'
      | 'SHOWCASE_SUBPIN_IMPRESSION'
      | 'SHOWCASE_SUBPAGE_SWIPE_LEFT'
      | 'SHOWCASE_SUBPAGE_SWIPE_RIGHT'
      | 'SHOWCASE_SUBPIN_SWIPE_LEFT'
      | 'SHOWCASE_SUBPIN_SWIPE_RIGHT'
      | 'SHOWCASE_SUBPAGE_REPIN'
      | 'SHOWCASE_SUBPIN_REPIN'
      | 'SHOWCASE_SUBPAGE_CLOSEUP'
      | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'
      | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'
      | 'SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'
      | 'TOTAL_CHECKOUT_CONVERSION_RATE'
      | 'TOTAL_VIEW_CATEGORY_CONVERSION_RATE'
      | 'TOTAL_ADD_TO_CART_CONVERSION_RATE'
      | 'TOTAL_SIGNUP_CONVERSION_RATE'
      | 'TOTAL_PAGE_VISIT_CONVERSION_RATE'
      | 'TOTAL_LEAD_CONVERSION_RATE'
      | 'TOTAL_SEARCH_CONVERSION_RATE'
      | 'TOTAL_WATCH_VIDEO_CONVERSION_RATE'
      | 'TOTAL_UNKNOWN_CONVERSION_RATE'
      | 'TOTAL_CUSTOM_CONVERSION_RATE'
    >;
    /**
     * The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.
     */
    conversion_report_time?: 'TIME_OF_AD_ACTION' | 'TIME_OF_CONVERSION';
    /**
     * Metric report end date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days past start_date.
     */
    end_date: string;
    /**
     * Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
     */
    engagement_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
    /**
     * TOTAL - metrics are aggregated over the specified date range.<br> DAY - metrics are broken down daily.<br> HOUR - metrics are broken down hourly.<br>WEEKLY - metrics are broken down weekly.<br>MONTHLY - metrics are broken down monthly
     */
    granularity: Granularity;
    /**
     * Metric report start date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days back from today.
     */
    start_date: string;
    /**
     * Targeting type breakdowns for the report. The reporting per targeting type <br> is independent from each other. ["AGE_BUCKET_AND_GENDER"] is in BETA and not yet available to all users.
     */
    targeting_types: Array<AdsAnalyticsAdTargetingType>;
    /**
     * Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.
     */
    view_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
  };
};

export type AdTargetingAnalyticsGetResponse = MetricsResponse;

export type AdTargetingAnalyticsGetError = Error;

export type AdsGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
    /**
     * Unique identifier of an ad.
     */
    ad_id: string;
  };
};

export type AdsGetResponse = AdResponse;

export type AdsGetError = Error;

export type AdAccountAnalyticsData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query: {
    /**
     * Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
     */
    click_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
    /**
     * Columns to retrieve, encoded as a comma-separated string. **NOTE**: Any metrics defined as MICRO_DOLLARS returns a value based on the advertiser profile's currency field. For USD,($1/1,000,000, or $0.000001 - one one-ten-thousandth of a cent). it's microdollars. Otherwise, it's in microunits of the advertiser's currency.<br/>For example, if the advertiser's currency is GBP (British pound sterling), all MICRO_DOLLARS fields will be in GBP microunits (1/1,000,000 British pound).<br/>If a column has no value, it may not be returned
     */
    columns: Array<
      | 'SPEND_IN_MICRO_DOLLAR'
      | 'PAID_IMPRESSION'
      | 'SPEND_IN_DOLLAR'
      | 'CPC_IN_MICRO_DOLLAR'
      | 'ECPC_IN_MICRO_DOLLAR'
      | 'ECPC_IN_DOLLAR'
      | 'CTR'
      | 'ECTR'
      | 'CAMPAIGN_NAME'
      | 'PIN_ID'
      | 'TOTAL_ENGAGEMENT'
      | 'ENGAGEMENT_1'
      | 'ENGAGEMENT_2'
      | 'ECPE_IN_DOLLAR'
      | 'ENGAGEMENT_RATE'
      | 'EENGAGEMENT_RATE'
      | 'ECPM_IN_MICRO_DOLLAR'
      | 'REPIN_RATE'
      | 'CTR_2'
      | 'CAMPAIGN_ID'
      | 'ADVERTISER_ID'
      | 'AD_ACCOUNT_ID'
      | 'PIN_PROMOTION_ID'
      | 'AD_ID'
      | 'AD_GROUP_ID'
      | 'CAMPAIGN_ENTITY_STATUS'
      | 'CAMPAIGN_OBJECTIVE_TYPE'
      | 'CPM_IN_MICRO_DOLLAR'
      | 'CPM_IN_DOLLAR'
      | 'AD_GROUP_ENTITY_STATUS'
      | 'ORDER_LINE_ID'
      | 'ORDER_LINE_NAME'
      | 'CLICKTHROUGH_1'
      | 'REPIN_1'
      | 'IMPRESSION_1'
      | 'IMPRESSION_1_GROSS'
      | 'CLICKTHROUGH_1_GROSS'
      | 'OUTBOUND_CLICK_1'
      | 'CLICKTHROUGH_2'
      | 'REPIN_2'
      | 'IMPRESSION_2'
      | 'OUTBOUND_CLICK_2'
      | 'TOTAL_CLICKTHROUGH'
      | 'TOTAL_IMPRESSION'
      | 'TOTAL_IMPRESSION_USER'
      | 'TOTAL_IMPRESSION_FREQUENCY'
      | 'COST_PER_OUTBOUND_CLICK_IN_DOLLAR'
      | 'TOTAL_ENGAGEMENT_SIGNUP'
      | 'TOTAL_ENGAGEMENT_CHECKOUT'
      | 'TOTAL_ENGAGEMENT_LEAD'
      | 'TOTAL_CLICK_SIGNUP'
      | 'TOTAL_CLICK_CHECKOUT'
      | 'TOTAL_CLICK_ADD_TO_CART'
      | 'TOTAL_CLICK_LEAD'
      | 'TOTAL_VIEW_SIGNUP'
      | 'TOTAL_VIEW_CHECKOUT'
      | 'TOTAL_VIEW_ADD_TO_CART'
      | 'TOTAL_VIEW_LEAD'
      | 'TOTAL_CONVERSIONS'
      | 'TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_SESSIONS'
      | 'WEB_SESSIONS_1'
      | 'WEB_SESSIONS_2'
      | 'CAMPAIGN_LIFETIME_SPEND_CAP'
      | 'CAMPAIGN_DAILY_SPEND_CAP'
      | 'TOTAL_PAGE_VISIT'
      | 'TOTAL_SIGNUP'
      | 'TOTAL_CHECKOUT'
      | 'TOTAL_CUSTOM'
      | 'TOTAL_LEAD'
      | 'TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'
      | 'PAGE_VISIT_COST_PER_ACTION'
      | 'PAGE_VISIT_ROAS'
      | 'CHECKOUT_ROAS'
      | 'CUSTOM_ROAS'
      | 'VIDEO_MRC_VIEWS_1'
      | 'VIDEO_3SEC_VIEWS_2'
      | 'VIDEO_P100_COMPLETE_2'
      | 'VIDEO_P0_COMBINED_2'
      | 'VIDEO_P25_COMBINED_2'
      | 'VIDEO_P50_COMBINED_2'
      | 'VIDEO_P75_COMBINED_2'
      | 'VIDEO_P95_COMBINED_2'
      | 'VIDEO_MRC_VIEWS_2'
      | 'PAID_VIDEO_VIEWABLE_RATE'
      | 'VIDEO_LENGTH'
      | 'ECPV_IN_DOLLAR'
      | 'ECPCV_IN_DOLLAR'
      | 'ECPCV_P95_IN_DOLLAR'
      | 'TOTAL_VIDEO_3SEC_VIEWS'
      | 'TOTAL_VIDEO_P100_COMPLETE'
      | 'TOTAL_VIDEO_P0_COMBINED'
      | 'TOTAL_VIDEO_P25_COMBINED'
      | 'TOTAL_VIDEO_P50_COMBINED'
      | 'TOTAL_VIDEO_P75_COMBINED'
      | 'TOTAL_VIDEO_P95_COMBINED'
      | 'TOTAL_VIDEO_MRC_VIEWS'
      | 'TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'
      | 'TOTAL_REPIN_RATE'
      | 'WEB_CHECKOUT_COST_PER_ACTION'
      | 'WEB_CHECKOUT_ROAS'
      | 'TOTAL_WEB_CHECKOUT'
      | 'TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_CLICK_CHECKOUT'
      | 'TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT'
      | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_VIEW_CHECKOUT'
      | 'TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'INAPP_CHECKOUT_COST_PER_ACTION'
      | 'TOTAL_OFFLINE_CHECKOUT'
      | 'IDEA_PIN_PRODUCT_TAG_VISIT_1'
      | 'IDEA_PIN_PRODUCT_TAG_VISIT_2'
      | 'TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'
      | 'LEADS'
      | 'COST_PER_LEAD'
      | 'QUIZ_COMPLETED'
      | 'QUIZ_PIN_RESULT_OPEN'
      | 'QUIZ_COMPLETION_RATE'
      | 'SHOWCASE_PIN_CLICKTHROUGH'
      | 'SHOWCASE_SUBPAGE_CLICKTHROUGH'
      | 'SHOWCASE_SUBPIN_CLICKTHROUGH'
      | 'SHOWCASE_SUBPAGE_IMPRESSION'
      | 'SHOWCASE_SUBPIN_IMPRESSION'
      | 'SHOWCASE_SUBPAGE_SWIPE_LEFT'
      | 'SHOWCASE_SUBPAGE_SWIPE_RIGHT'
      | 'SHOWCASE_SUBPIN_SWIPE_LEFT'
      | 'SHOWCASE_SUBPIN_SWIPE_RIGHT'
      | 'SHOWCASE_SUBPAGE_REPIN'
      | 'SHOWCASE_SUBPIN_REPIN'
      | 'SHOWCASE_SUBPAGE_CLOSEUP'
      | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'
      | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'
      | 'SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'
      | 'TOTAL_CHECKOUT_CONVERSION_RATE'
      | 'TOTAL_VIEW_CATEGORY_CONVERSION_RATE'
      | 'TOTAL_ADD_TO_CART_CONVERSION_RATE'
      | 'TOTAL_SIGNUP_CONVERSION_RATE'
      | 'TOTAL_PAGE_VISIT_CONVERSION_RATE'
      | 'TOTAL_LEAD_CONVERSION_RATE'
      | 'TOTAL_SEARCH_CONVERSION_RATE'
      | 'TOTAL_WATCH_VIDEO_CONVERSION_RATE'
      | 'TOTAL_UNKNOWN_CONVERSION_RATE'
      | 'TOTAL_CUSTOM_CONVERSION_RATE'
    >;
    /**
     * The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.
     */
    conversion_report_time?: 'TIME_OF_AD_ACTION' | 'TIME_OF_CONVERSION';
    /**
     * Metric report end date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days past start_date.
     */
    end_date: string;
    /**
     * Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
     */
    engagement_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
    /**
     * TOTAL - metrics are aggregated over the specified date range.<br> DAY - metrics are broken down daily.<br> HOUR - metrics are broken down hourly.<br>WEEKLY - metrics are broken down weekly.<br>MONTHLY - metrics are broken down monthly
     */
    granularity: Granularity;
    /**
     * Metric report start date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days back from today.
     */
    start_date: string;
    /**
     * Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.
     */
    view_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
  };
};

export type AdAccountAnalyticsResponse2 = AdAccountAnalyticsResponse;

export type AdAccountAnalyticsError = Error;

export type AudienceInsightsGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query: {
    /**
     * Type of audience insights.
     */
    audience_insight_type: AudienceInsightType;
  };
};

export type AudienceInsightsGetResponse = AudienceInsightsResponse;

export type AudienceInsightsGetError = Error;

export type AudiencesListData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * The order in which to sort the items returned: “ASCENDING” or “DESCENDING” by ID.
     * For received audiences, it is sorted by sharing event time.
     * Note that higher-value IDs are associated with more-recently added items.
     */
    order?: 'ASCENDING' | 'DESCENDING';
    /**
     * Filter audiences by ownership type.
     */
    ownership_type?: 'OWNED' | 'RECEIVED';
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type AudiencesListResponse = Paginated & {
  items?: Array<Audience>;
};

export type AudiencesListError = Error;

export type AudiencesCreateData = {
  /**
   * List of ads to create, size limit [1, 30]
   */
  body: AudienceCreateRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type AudiencesCreateResponse = Audience;

export type AudiencesCreateError = Error;

export type AudiencesGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
    /**
     * Unique identifier of an audience
     */
    audience_id: string;
  };
};

export type AudiencesGetResponse = Audience;

export type AudiencesGetError = Error;

export type AudiencesUpdateData = {
  /**
   * The audience to be updated.
   */
  body?: AudienceUpdateRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
    /**
     * Unique identifier of an audience
     */
    audience_id: string;
  };
};

export type AudiencesUpdateResponse = Audience;

export type AudiencesUpdateError = Error;

export type AudiencesCreateCustomData = {
  /**
   * Custom audience to create.
   */
  body: AudienceCreateCustomRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type AudiencesCreateCustomResponse = Audience;

export type AudiencesCreateCustomError = Error;

export type AdAccountsAudiencesSharedAccountsListData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query: {
    /**
     * Filter accounts by account type.
     */
    account_type: AudienceAccountType;
    /**
     * Unique identifier of the audience to use to filter the results.
     */
    audience_id: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type AdAccountsAudiencesSharedAccountsListResponse = Paginated & {
  items?: Array<SharedAudienceAccount>;
};

export type AdAccountsAudiencesSharedAccountsListError = Error;

export type UpdateAdAccountToAdAccountSharedAudienceData = {
  body: SharedAudience;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type UpdateAdAccountToAdAccountSharedAudienceResponse = SharedAudienceResponse;

export type UpdateAdAccountToAdAccountSharedAudienceError = Error;

export type UpdateAdAccountToBusinessSharedAudienceData = {
  body: BusinessSharedAudience;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type UpdateAdAccountToBusinessSharedAudienceResponse = BusinessSharedAudienceResponse;

export type UpdateAdAccountToBusinessSharedAudienceError = Error;

export type AdGroupsBidFloorGetData = {
  /**
   * Parameters to get bid_floor info
   */
  body: BidFloorRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type AdGroupsBidFloorGetResponse = BidFloor;

export type AdGroupsBidFloorGetError = Error;

export type BillingProfilesGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Return active billing profiles, if false return all billing profiles.
     */
    is_active: boolean;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type BillingProfilesGetResponse = Paginated & {
  items?: Array<BillingProfilesResponse>;
};

export type BillingProfilesGetError = Error;

export type BulkDownloadCreateData = {
  /**
   * Parameters to get ad entities in bulk
   */
  body: BulkDownloadRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type BulkDownloadCreateResponse = BulkDownloadResponse;

export type BulkDownloadCreateError = Error;

export type BulkUpsertCreateData = {
  /**
   * Parameters to get create/update ad entities in bulk
   */
  body: BulkUpsertRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type BulkUpsertCreateResponse = BulkUpsertResponse;

export type BulkUpsertCreateError = Error;

export type BulkRequestGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
    /**
     * Unique identifier of a bulk upsert request.
     */
    bulk_request_id: string;
  };
  query?: {
    /**
     * if set to True then attach the errors/details to all the requests
     */
    include_details?: boolean;
  };
};

export type BulkRequestGetResponse = BulkUpsertStatusResponse;

export type BulkRequestGetError = Error;

export type CampaignsListData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * List of Campaign Ids to use to filter the results.
     */
    campaign_ids?: Array<string>;
    /**
     * Entity status
     */
    entity_statuses?: Array<'ACTIVE' | 'PAUSED' | 'ARCHIVED' | 'DRAFT' | 'DELETED_DRAFT'>;
    /**
     * The order in which to sort the items returned: “ASCENDING” or “DESCENDING”
     * by ID. Note that higher-value IDs are associated with more-recently added
     * items.
     */
    order?: 'ASCENDING' | 'DESCENDING';
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type CampaignsListResponse = Paginated & {
  items?: Array<CampaignResponse>;
};

export type CampaignsListError = Error;

export type CampaignsCreateData = {
  /**
   * Array of campaigns.
   */
  body: Array<CampaignCreateRequest>;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type CampaignsCreateResponse = CampaignCreateResponse;

export type CampaignsCreateError = Error;

export type CampaignsUpdateData = {
  /**
   * Array of campaigns.
   */
  body: Array<CampaignUpdateRequest>;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type CampaignsUpdateResponse = CampaignUpdateResponse;

export type CampaignsUpdateError = Error;

export type CampaignsAnalyticsData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query: {
    /**
     * List of Campaign Ids to use to filter the results.
     */
    campaign_ids: Array<string>;
    /**
     * Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
     */
    click_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
    /**
     * Columns to retrieve, encoded as a comma-separated string. **NOTE**: Any metrics defined as MICRO_DOLLARS returns a value based on the advertiser profile's currency field. For USD,($1/1,000,000, or $0.000001 - one one-ten-thousandth of a cent). it's microdollars. Otherwise, it's in microunits of the advertiser's currency.<br/>For example, if the advertiser's currency is GBP (British pound sterling), all MICRO_DOLLARS fields will be in GBP microunits (1/1,000,000 British pound).<br/>If a column has no value, it may not be returned
     */
    columns: Array<
      | 'SPEND_IN_MICRO_DOLLAR'
      | 'PAID_IMPRESSION'
      | 'SPEND_IN_DOLLAR'
      | 'CPC_IN_MICRO_DOLLAR'
      | 'ECPC_IN_MICRO_DOLLAR'
      | 'ECPC_IN_DOLLAR'
      | 'CTR'
      | 'ECTR'
      | 'CAMPAIGN_NAME'
      | 'PIN_ID'
      | 'TOTAL_ENGAGEMENT'
      | 'ENGAGEMENT_1'
      | 'ENGAGEMENT_2'
      | 'ECPE_IN_DOLLAR'
      | 'ENGAGEMENT_RATE'
      | 'EENGAGEMENT_RATE'
      | 'ECPM_IN_MICRO_DOLLAR'
      | 'REPIN_RATE'
      | 'CTR_2'
      | 'CAMPAIGN_ID'
      | 'ADVERTISER_ID'
      | 'AD_ACCOUNT_ID'
      | 'PIN_PROMOTION_ID'
      | 'AD_ID'
      | 'AD_GROUP_ID'
      | 'CAMPAIGN_ENTITY_STATUS'
      | 'CAMPAIGN_OBJECTIVE_TYPE'
      | 'CPM_IN_MICRO_DOLLAR'
      | 'CPM_IN_DOLLAR'
      | 'AD_GROUP_ENTITY_STATUS'
      | 'ORDER_LINE_ID'
      | 'ORDER_LINE_NAME'
      | 'CLICKTHROUGH_1'
      | 'REPIN_1'
      | 'IMPRESSION_1'
      | 'IMPRESSION_1_GROSS'
      | 'CLICKTHROUGH_1_GROSS'
      | 'OUTBOUND_CLICK_1'
      | 'CLICKTHROUGH_2'
      | 'REPIN_2'
      | 'IMPRESSION_2'
      | 'OUTBOUND_CLICK_2'
      | 'TOTAL_CLICKTHROUGH'
      | 'TOTAL_IMPRESSION'
      | 'TOTAL_IMPRESSION_USER'
      | 'TOTAL_IMPRESSION_FREQUENCY'
      | 'COST_PER_OUTBOUND_CLICK_IN_DOLLAR'
      | 'TOTAL_ENGAGEMENT_SIGNUP'
      | 'TOTAL_ENGAGEMENT_CHECKOUT'
      | 'TOTAL_ENGAGEMENT_LEAD'
      | 'TOTAL_CLICK_SIGNUP'
      | 'TOTAL_CLICK_CHECKOUT'
      | 'TOTAL_CLICK_ADD_TO_CART'
      | 'TOTAL_CLICK_LEAD'
      | 'TOTAL_VIEW_SIGNUP'
      | 'TOTAL_VIEW_CHECKOUT'
      | 'TOTAL_VIEW_ADD_TO_CART'
      | 'TOTAL_VIEW_LEAD'
      | 'TOTAL_CONVERSIONS'
      | 'TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_SESSIONS'
      | 'WEB_SESSIONS_1'
      | 'WEB_SESSIONS_2'
      | 'CAMPAIGN_LIFETIME_SPEND_CAP'
      | 'CAMPAIGN_DAILY_SPEND_CAP'
      | 'TOTAL_PAGE_VISIT'
      | 'TOTAL_SIGNUP'
      | 'TOTAL_CHECKOUT'
      | 'TOTAL_CUSTOM'
      | 'TOTAL_LEAD'
      | 'TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'
      | 'PAGE_VISIT_COST_PER_ACTION'
      | 'PAGE_VISIT_ROAS'
      | 'CHECKOUT_ROAS'
      | 'CUSTOM_ROAS'
      | 'VIDEO_MRC_VIEWS_1'
      | 'VIDEO_3SEC_VIEWS_2'
      | 'VIDEO_P100_COMPLETE_2'
      | 'VIDEO_P0_COMBINED_2'
      | 'VIDEO_P25_COMBINED_2'
      | 'VIDEO_P50_COMBINED_2'
      | 'VIDEO_P75_COMBINED_2'
      | 'VIDEO_P95_COMBINED_2'
      | 'VIDEO_MRC_VIEWS_2'
      | 'PAID_VIDEO_VIEWABLE_RATE'
      | 'VIDEO_LENGTH'
      | 'ECPV_IN_DOLLAR'
      | 'ECPCV_IN_DOLLAR'
      | 'ECPCV_P95_IN_DOLLAR'
      | 'TOTAL_VIDEO_3SEC_VIEWS'
      | 'TOTAL_VIDEO_P100_COMPLETE'
      | 'TOTAL_VIDEO_P0_COMBINED'
      | 'TOTAL_VIDEO_P25_COMBINED'
      | 'TOTAL_VIDEO_P50_COMBINED'
      | 'TOTAL_VIDEO_P75_COMBINED'
      | 'TOTAL_VIDEO_P95_COMBINED'
      | 'TOTAL_VIDEO_MRC_VIEWS'
      | 'TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'
      | 'TOTAL_REPIN_RATE'
      | 'WEB_CHECKOUT_COST_PER_ACTION'
      | 'WEB_CHECKOUT_ROAS'
      | 'TOTAL_WEB_CHECKOUT'
      | 'TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_CLICK_CHECKOUT'
      | 'TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT'
      | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_VIEW_CHECKOUT'
      | 'TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'INAPP_CHECKOUT_COST_PER_ACTION'
      | 'TOTAL_OFFLINE_CHECKOUT'
      | 'IDEA_PIN_PRODUCT_TAG_VISIT_1'
      | 'IDEA_PIN_PRODUCT_TAG_VISIT_2'
      | 'TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'
      | 'LEADS'
      | 'COST_PER_LEAD'
      | 'QUIZ_COMPLETED'
      | 'QUIZ_PIN_RESULT_OPEN'
      | 'QUIZ_COMPLETION_RATE'
      | 'SHOWCASE_PIN_CLICKTHROUGH'
      | 'SHOWCASE_SUBPAGE_CLICKTHROUGH'
      | 'SHOWCASE_SUBPIN_CLICKTHROUGH'
      | 'SHOWCASE_SUBPAGE_IMPRESSION'
      | 'SHOWCASE_SUBPIN_IMPRESSION'
      | 'SHOWCASE_SUBPAGE_SWIPE_LEFT'
      | 'SHOWCASE_SUBPAGE_SWIPE_RIGHT'
      | 'SHOWCASE_SUBPIN_SWIPE_LEFT'
      | 'SHOWCASE_SUBPIN_SWIPE_RIGHT'
      | 'SHOWCASE_SUBPAGE_REPIN'
      | 'SHOWCASE_SUBPIN_REPIN'
      | 'SHOWCASE_SUBPAGE_CLOSEUP'
      | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'
      | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'
      | 'SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'
      | 'TOTAL_CHECKOUT_CONVERSION_RATE'
      | 'TOTAL_VIEW_CATEGORY_CONVERSION_RATE'
      | 'TOTAL_ADD_TO_CART_CONVERSION_RATE'
      | 'TOTAL_SIGNUP_CONVERSION_RATE'
      | 'TOTAL_PAGE_VISIT_CONVERSION_RATE'
      | 'TOTAL_LEAD_CONVERSION_RATE'
      | 'TOTAL_SEARCH_CONVERSION_RATE'
      | 'TOTAL_WATCH_VIDEO_CONVERSION_RATE'
      | 'TOTAL_UNKNOWN_CONVERSION_RATE'
      | 'TOTAL_CUSTOM_CONVERSION_RATE'
    >;
    /**
     * The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.
     */
    conversion_report_time?: 'TIME_OF_AD_ACTION' | 'TIME_OF_CONVERSION';
    /**
     * Metric report end date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days past start_date.
     */
    end_date: string;
    /**
     * Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
     */
    engagement_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
    /**
     * TOTAL - metrics are aggregated over the specified date range.<br> DAY - metrics are broken down daily.<br> HOUR - metrics are broken down hourly.<br>WEEKLY - metrics are broken down weekly.<br>MONTHLY - metrics are broken down monthly
     */
    granularity: Granularity;
    /**
     * Metric report start date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days back from today.
     */
    start_date: string;
    /**
     * Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.
     */
    view_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
  };
};

export type CampaignsAnalyticsResponse2 = CampaignsAnalyticsResponse;

export type CampaignsAnalyticsError = Error;

export type CampaignTargetingAnalyticsGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query: {
    /**
     * List of types of attribution for the conversion report
     */
    attribution_types?: ConversionReportAttributionType;
    /**
     * List of Campaign Ids to use to filter the results.
     */
    campaign_ids: Array<string>;
    /**
     * Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
     */
    click_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
    /**
     * Columns to retrieve, encoded as a comma-separated string. **NOTE**: Any metrics defined as MICRO_DOLLARS returns a value based on the advertiser profile's currency field. For USD,($1/1,000,000, or $0.000001 - one one-ten-thousandth of a cent). it's microdollars. Otherwise, it's in microunits of the advertiser's currency.<br/>For example, if the advertiser's currency is GBP (British pound sterling), all MICRO_DOLLARS fields will be in GBP microunits (1/1,000,000 British pound).<br/>If a column has no value, it may not be returned
     */
    columns: Array<
      | 'SPEND_IN_MICRO_DOLLAR'
      | 'PAID_IMPRESSION'
      | 'SPEND_IN_DOLLAR'
      | 'CPC_IN_MICRO_DOLLAR'
      | 'ECPC_IN_MICRO_DOLLAR'
      | 'ECPC_IN_DOLLAR'
      | 'CTR'
      | 'ECTR'
      | 'CAMPAIGN_NAME'
      | 'PIN_ID'
      | 'TOTAL_ENGAGEMENT'
      | 'ENGAGEMENT_1'
      | 'ENGAGEMENT_2'
      | 'ECPE_IN_DOLLAR'
      | 'ENGAGEMENT_RATE'
      | 'EENGAGEMENT_RATE'
      | 'ECPM_IN_MICRO_DOLLAR'
      | 'REPIN_RATE'
      | 'CTR_2'
      | 'CAMPAIGN_ID'
      | 'ADVERTISER_ID'
      | 'AD_ACCOUNT_ID'
      | 'PIN_PROMOTION_ID'
      | 'AD_ID'
      | 'AD_GROUP_ID'
      | 'CAMPAIGN_ENTITY_STATUS'
      | 'CAMPAIGN_OBJECTIVE_TYPE'
      | 'CPM_IN_MICRO_DOLLAR'
      | 'CPM_IN_DOLLAR'
      | 'AD_GROUP_ENTITY_STATUS'
      | 'ORDER_LINE_ID'
      | 'ORDER_LINE_NAME'
      | 'CLICKTHROUGH_1'
      | 'REPIN_1'
      | 'IMPRESSION_1'
      | 'IMPRESSION_1_GROSS'
      | 'CLICKTHROUGH_1_GROSS'
      | 'OUTBOUND_CLICK_1'
      | 'CLICKTHROUGH_2'
      | 'REPIN_2'
      | 'IMPRESSION_2'
      | 'OUTBOUND_CLICK_2'
      | 'TOTAL_CLICKTHROUGH'
      | 'TOTAL_IMPRESSION'
      | 'TOTAL_IMPRESSION_USER'
      | 'TOTAL_IMPRESSION_FREQUENCY'
      | 'COST_PER_OUTBOUND_CLICK_IN_DOLLAR'
      | 'TOTAL_ENGAGEMENT_SIGNUP'
      | 'TOTAL_ENGAGEMENT_CHECKOUT'
      | 'TOTAL_ENGAGEMENT_LEAD'
      | 'TOTAL_CLICK_SIGNUP'
      | 'TOTAL_CLICK_CHECKOUT'
      | 'TOTAL_CLICK_ADD_TO_CART'
      | 'TOTAL_CLICK_LEAD'
      | 'TOTAL_VIEW_SIGNUP'
      | 'TOTAL_VIEW_CHECKOUT'
      | 'TOTAL_VIEW_ADD_TO_CART'
      | 'TOTAL_VIEW_LEAD'
      | 'TOTAL_CONVERSIONS'
      | 'TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_SESSIONS'
      | 'WEB_SESSIONS_1'
      | 'WEB_SESSIONS_2'
      | 'CAMPAIGN_LIFETIME_SPEND_CAP'
      | 'CAMPAIGN_DAILY_SPEND_CAP'
      | 'TOTAL_PAGE_VISIT'
      | 'TOTAL_SIGNUP'
      | 'TOTAL_CHECKOUT'
      | 'TOTAL_CUSTOM'
      | 'TOTAL_LEAD'
      | 'TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'
      | 'PAGE_VISIT_COST_PER_ACTION'
      | 'PAGE_VISIT_ROAS'
      | 'CHECKOUT_ROAS'
      | 'CUSTOM_ROAS'
      | 'VIDEO_MRC_VIEWS_1'
      | 'VIDEO_3SEC_VIEWS_2'
      | 'VIDEO_P100_COMPLETE_2'
      | 'VIDEO_P0_COMBINED_2'
      | 'VIDEO_P25_COMBINED_2'
      | 'VIDEO_P50_COMBINED_2'
      | 'VIDEO_P75_COMBINED_2'
      | 'VIDEO_P95_COMBINED_2'
      | 'VIDEO_MRC_VIEWS_2'
      | 'PAID_VIDEO_VIEWABLE_RATE'
      | 'VIDEO_LENGTH'
      | 'ECPV_IN_DOLLAR'
      | 'ECPCV_IN_DOLLAR'
      | 'ECPCV_P95_IN_DOLLAR'
      | 'TOTAL_VIDEO_3SEC_VIEWS'
      | 'TOTAL_VIDEO_P100_COMPLETE'
      | 'TOTAL_VIDEO_P0_COMBINED'
      | 'TOTAL_VIDEO_P25_COMBINED'
      | 'TOTAL_VIDEO_P50_COMBINED'
      | 'TOTAL_VIDEO_P75_COMBINED'
      | 'TOTAL_VIDEO_P95_COMBINED'
      | 'TOTAL_VIDEO_MRC_VIEWS'
      | 'TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'
      | 'TOTAL_REPIN_RATE'
      | 'WEB_CHECKOUT_COST_PER_ACTION'
      | 'WEB_CHECKOUT_ROAS'
      | 'TOTAL_WEB_CHECKOUT'
      | 'TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_CLICK_CHECKOUT'
      | 'TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT'
      | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_VIEW_CHECKOUT'
      | 'TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'INAPP_CHECKOUT_COST_PER_ACTION'
      | 'TOTAL_OFFLINE_CHECKOUT'
      | 'IDEA_PIN_PRODUCT_TAG_VISIT_1'
      | 'IDEA_PIN_PRODUCT_TAG_VISIT_2'
      | 'TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'
      | 'LEADS'
      | 'COST_PER_LEAD'
      | 'QUIZ_COMPLETED'
      | 'QUIZ_PIN_RESULT_OPEN'
      | 'QUIZ_COMPLETION_RATE'
      | 'SHOWCASE_PIN_CLICKTHROUGH'
      | 'SHOWCASE_SUBPAGE_CLICKTHROUGH'
      | 'SHOWCASE_SUBPIN_CLICKTHROUGH'
      | 'SHOWCASE_SUBPAGE_IMPRESSION'
      | 'SHOWCASE_SUBPIN_IMPRESSION'
      | 'SHOWCASE_SUBPAGE_SWIPE_LEFT'
      | 'SHOWCASE_SUBPAGE_SWIPE_RIGHT'
      | 'SHOWCASE_SUBPIN_SWIPE_LEFT'
      | 'SHOWCASE_SUBPIN_SWIPE_RIGHT'
      | 'SHOWCASE_SUBPAGE_REPIN'
      | 'SHOWCASE_SUBPIN_REPIN'
      | 'SHOWCASE_SUBPAGE_CLOSEUP'
      | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'
      | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'
      | 'SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'
      | 'TOTAL_CHECKOUT_CONVERSION_RATE'
      | 'TOTAL_VIEW_CATEGORY_CONVERSION_RATE'
      | 'TOTAL_ADD_TO_CART_CONVERSION_RATE'
      | 'TOTAL_SIGNUP_CONVERSION_RATE'
      | 'TOTAL_PAGE_VISIT_CONVERSION_RATE'
      | 'TOTAL_LEAD_CONVERSION_RATE'
      | 'TOTAL_SEARCH_CONVERSION_RATE'
      | 'TOTAL_WATCH_VIDEO_CONVERSION_RATE'
      | 'TOTAL_UNKNOWN_CONVERSION_RATE'
      | 'TOTAL_CUSTOM_CONVERSION_RATE'
    >;
    /**
     * The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.
     */
    conversion_report_time?: 'TIME_OF_AD_ACTION' | 'TIME_OF_CONVERSION';
    /**
     * Metric report end date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days past start_date.
     */
    end_date: string;
    /**
     * Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
     */
    engagement_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
    /**
     * TOTAL - metrics are aggregated over the specified date range.<br> DAY - metrics are broken down daily.<br> HOUR - metrics are broken down hourly.<br>WEEKLY - metrics are broken down weekly.<br>MONTHLY - metrics are broken down monthly
     */
    granularity: Granularity;
    /**
     * Metric report start date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days back from today.
     */
    start_date: string;
    /**
     * Targeting type breakdowns for the report. The reporting per targeting type <br> is independent from each other. ["AGE_BUCKET_AND_GENDER"] is in BETA and not yet available to all users.
     */
    targeting_types: Array<AdsAnalyticsCampaignTargetingType>;
    /**
     * Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.
     */
    view_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
  };
};

export type CampaignTargetingAnalyticsGetResponse = MetricsResponse;

export type CampaignTargetingAnalyticsGetError = Error;

export type CampaignsGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
    /**
     * Campaign ID, must be associated with the ad account ID provided in the path.
     */
    campaign_id: string;
  };
};

export type CampaignsGetResponse = CampaignResponse;

export type CampaignsGetError = Error;

export type ConversionTagsListData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * Filter out deleted tags.
     */
    filter_deleted?: boolean;
  };
};

export type ConversionTagsListResponse = ConversionTagListResponse;

export type ConversionTagsListError = Error;

export type ConversionTagsCreateData = {
  /**
   * Conversion Tag to create
   */
  body: ConversionTagCreate;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type ConversionTagsCreateResponse = ConversionTagResponse;

export type ConversionTagsCreateError = Error;

export type OcpmEligibleConversionTagsGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type OcpmEligibleConversionTagsGetResponse = ConversionTagsOcpmEligibleResponse;

export type OcpmEligibleConversionTagsGetError = Error;

export type PageVisitConversionTagsGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * The order in which to sort the items returned: “ASCENDING” or “DESCENDING”
     * by ID. Note that higher-value IDs are associated with more-recently added
     * items.
     */
    order?: 'ASCENDING' | 'DESCENDING';
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type PageVisitConversionTagsGetResponse = Paginated & {
  items?: Array<ConversionEventResponse>;
};

export type PageVisitConversionTagsGetError = Error;

export type ConversionTagsGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
    /**
     * Id of the conversion tag.
     */
    conversion_tag_id: string;
  };
};

export type ConversionTagsGetResponse = ConversionTagResponse;

export type ConversionTagsGetError = Error;

export type CustomerListsCreateData = {
  /**
   * Parameters to get Customer lists info
   */
  body: CustomerListRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type CustomerListsCreateResponse = CustomerList;

export type CustomerListsCreateError = Error;

export type CustomerListsListData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * The order in which to sort the items returned: “ASCENDING” or “DESCENDING”
     * by ID. Note that higher-value IDs are associated with more-recently added
     * items.
     */
    order?: 'ASCENDING' | 'DESCENDING';
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type CustomerListsListResponse = Paginated & {
  items?: Array<CustomerList>;
};

export type CustomerListsListError = Error;

export type CustomerListsGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
    /**
     * Unique identifier of a customer list
     */
    customer_list_id: string;
  };
};

export type CustomerListsGetResponse = CustomerList;

export type CustomerListsGetError = Error;

export type CustomerListsUpdateData = {
  body: CustomerListUpdateRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
    /**
     * Unique identifier of a customer list
     */
    customer_list_id: string;
  };
};

export type CustomerListsUpdateResponse = CustomerList;

export type CustomerListsUpdateError = Error;

export type EventsCreateData = {
  /**
   * Conversion events.
   */
  body: ConversionEvents;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * Include query param ?test=true to mark the request as a test request. The events will not be recorded but the API will still return the same response messages. Use this mode to verify your requests are working and your events are constructed correctly.
     * Warning: If you use this query parameter, be certain that it is off (set to false or deleted) before sending a legitimate (non-testing) request.
     */
    test?: boolean;
  };
};

export type EventsCreateResponse = ConversionApiResponse;

export type EventsCreateError = Error | DetailedError;

export type AudienceInsightsScopeAndTypeGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type AudienceInsightsScopeAndTypeGetResponse = AudienceDefinitionResponse;

export type AudienceInsightsScopeAndTypeGetError = Error;

export type KeywordsGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * Ad group Id.
     */
    ad_group_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Campaign Id to use to filter the results.
     */
    campaign_id?: string;
    /**
     * Keyword <a target="_blank" href="/docs/api-features/targeting-overview/">match type</a>
     */
    match_types?: Array<MatchType>;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type KeywordsGetResponse = Paginated & {
  items?: Array<Keyword>;
};

export type KeywordsGetError = Error;

export type KeywordsCreateData = {
  body: KeywordsRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type KeywordsCreateResponse = KeywordsResponse;

export type KeywordsCreateError = Error;

export type KeywordsUpdateData = {
  body: KeywordUpdateBody;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type KeywordsUpdateResponse = KeywordsResponse;

export type KeywordsUpdateError = Error;

export type CountryKeywordsMetricsGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query: {
    /**
     * Two letter country code (ISO 3166-1 alpha-2)
     */
    country_code: string;
    /**
     * Comma-separated keywords
     */
    keywords: Array<string>;
  };
};

export type CountryKeywordsMetricsGetResponse = KeywordsMetricsArrayResponse;

export type CountryKeywordsMetricsGetError = Error;

export type LeadFormsListData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * The order in which to sort the items returned: “ASCENDING” or “DESCENDING”
     * by ID. Note that higher-value IDs are associated with more-recently added
     * items.
     */
    order?: 'ASCENDING' | 'DESCENDING';
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type LeadFormsListResponse = Paginated & {
  items?: Array<LeadFormResponse>;
};

export type LeadFormsListError = Error;

export type LeadFormsCreateData = {
  /**
   * List of lead forms to create, size limit [1, 30].
   */
  body: Array<LeadFormCreateRequest>;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type LeadFormsCreateResponse = LeadFormArrayResponse;

export type LeadFormsCreateError = Error;

export type LeadFormsUpdateData = {
  /**
   * List of lead forms to update, size limit [1, 30].
   */
  body: Array<LeadFormUpdateRequest>;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type LeadFormsUpdateResponse = LeadFormArrayResponse;

export type LeadFormsUpdateError = Error;

export type LeadFormGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
    /**
     * Unique identifier of a lead form.
     */
    lead_form_id: string;
  };
};

export type LeadFormGetResponse = LeadFormResponse;

export type LeadFormGetError = Error;

export type LeadFormTestCreateData = {
  /**
   * Subscription to create.
   */
  body: LeadFormTestRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
    /**
     * Unique identifier of a lead form.
     */
    lead_form_id: string;
  };
};

export type LeadFormTestCreateResponse = LeadFormTestResponse;

export type LeadFormTestCreateError = Error;

export type AdAccountsSubscriptionsPostData = {
  /**
   * Subscription to create.
   */
  body: AdAccountCreateSubscriptionRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type AdAccountsSubscriptionsPostResponse = AdAccountCreateSubscriptionResponse;

export type AdAccountsSubscriptionsPostError = Error;

export type AdAccountsSubscriptionsGetListData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type AdAccountsSubscriptionsGetListResponse = Paginated & {
  items?: Array<AdAccountGetSubscriptionResponse>;
};

export type AdAccountsSubscriptionsGetListError = Error;

export type AdAccountsSubscriptionsGetByIdData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
    /**
     * Unique identifier of a subscription.
     */
    subscription_id: string;
  };
};

export type AdAccountsSubscriptionsGetByIdResponse = AdAccountGetSubscriptionResponse;

export type AdAccountsSubscriptionsGetByIdError = Error;

export type AdAccountsSubscriptionsDelByIdData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
    /**
     * Unique identifier of a subscription.
     */
    subscription_id: string;
  };
};

export type AdAccountsSubscriptionsDelByIdResponse = any;

export type AdAccountsSubscriptionsDelByIdError = Error;

export type LeadsExportCreateData = {
  body: LeadsExportCreateRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type LeadsExportCreateResponse2 = LeadsExportCreateResponse;

export type LeadsExportCreateError = Error;

export type LeadsExportGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
    /**
     * lead_export_id token returned from the create a lead export endpoint
     */
    leads_export_id: string;
  };
};

export type LeadsExportGetResponse = LeadsExportResponseData;

export type LeadsExportGetError = Error;

export type AnalyticsGetMmmReportData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query: {
    /**
     * Token returned from the post request creation call
     */
    token: string;
  };
};

export type AnalyticsGetMmmReportResponse = GetMMMReportResponse;

export type AnalyticsGetMmmReportError = Error;

export type AnalyticsCreateMmmReportData = {
  body: CreateMMMReportRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type AnalyticsCreateMmmReportResponse = CreateMMMReportResponse;

export type AnalyticsCreateMmmReportError = Error;

export type OrderLinesListData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * The order in which to sort the items returned: “ASCENDING” or “DESCENDING”
     * by ID. Note that higher-value IDs are associated with more-recently added
     * items.
     */
    order?: 'ASCENDING' | 'DESCENDING';
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type OrderLinesListResponse = Paginated & {
  items?: Array<OrderLine>;
};

export type OrderLinesListError = Error;

export type OrderLinesGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
    /**
     * Unique identifier of an order line.
     */
    order_line_id: string;
  };
};

export type OrderLinesGetResponse = OrderLine;

export type OrderLinesGetError = Error;

export type ProductGroupPromotionsCreateData = {
  /**
   * List of Product Group Promotions to create, size limit [1, 30].
   */
  body: ProductGroupPromotionCreateRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type ProductGroupPromotionsCreateResponse = ProductGroupPromotionResponse;

export type ProductGroupPromotionsCreateError = Error;

export type ProductGroupPromotionsUpdateData = {
  /**
   * Parameters to update Product group promotions
   */
  body: ProductGroupPromotionUpdateRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type ProductGroupPromotionsUpdateResponse = ProductGroupPromotionResponse;

export type ProductGroupPromotionsUpdateError = Error;

export type ProductGroupPromotionsListData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * Ad group Id.
     */
    ad_group_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Entity status
     */
    entity_statuses?: Array<'ACTIVE' | 'PAUSED' | 'ARCHIVED' | 'DRAFT' | 'DELETED_DRAFT'>;
    /**
     * The order in which to sort the items returned: “ASCENDING” or “DESCENDING”
     * by ID. Note that higher-value IDs are associated with more-recently added
     * items.
     */
    order?: 'ASCENDING' | 'DESCENDING';
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
    /**
     * List of Product group promotion Ids.
     */
    product_group_promotion_ids?: Array<string>;
  };
};

export type ProductGroupPromotionsListResponse = Paginated & {
  items?: Array<ProductGroupPromotionResponseItem>;
};

export type ProductGroupPromotionsListError = Error;

export type ProductGroupPromotionsGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
    /**
     * Unique identifier of a product group promotion
     */
    product_group_promotion_id: string;
  };
};

export type ProductGroupPromotionsGetResponse = ProductGroupPromotionResponse;

export type ProductGroupPromotionsGetError = Error;

export type ProductGroupsAnalyticsData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query: {
    /**
     * Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
     */
    click_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
    /**
     * Columns to retrieve, encoded as a comma-separated string. **NOTE**: Any metrics defined as MICRO_DOLLARS returns a value based on the advertiser profile's currency field. For USD,($1/1,000,000, or $0.000001 - one one-ten-thousandth of a cent). it's microdollars. Otherwise, it's in microunits of the advertiser's currency.<br/>For example, if the advertiser's currency is GBP (British pound sterling), all MICRO_DOLLARS fields will be in GBP microunits (1/1,000,000 British pound).<br/>If a column has no value, it may not be returned
     */
    columns: Array<
      | 'SPEND_IN_MICRO_DOLLAR'
      | 'PAID_IMPRESSION'
      | 'SPEND_IN_DOLLAR'
      | 'CPC_IN_MICRO_DOLLAR'
      | 'ECPC_IN_MICRO_DOLLAR'
      | 'ECPC_IN_DOLLAR'
      | 'CTR'
      | 'ECTR'
      | 'CAMPAIGN_NAME'
      | 'PIN_ID'
      | 'TOTAL_ENGAGEMENT'
      | 'ENGAGEMENT_1'
      | 'ENGAGEMENT_2'
      | 'ECPE_IN_DOLLAR'
      | 'ENGAGEMENT_RATE'
      | 'EENGAGEMENT_RATE'
      | 'ECPM_IN_MICRO_DOLLAR'
      | 'REPIN_RATE'
      | 'CTR_2'
      | 'CAMPAIGN_ID'
      | 'ADVERTISER_ID'
      | 'AD_ACCOUNT_ID'
      | 'PIN_PROMOTION_ID'
      | 'AD_ID'
      | 'AD_GROUP_ID'
      | 'CAMPAIGN_ENTITY_STATUS'
      | 'CAMPAIGN_OBJECTIVE_TYPE'
      | 'CPM_IN_MICRO_DOLLAR'
      | 'CPM_IN_DOLLAR'
      | 'AD_GROUP_ENTITY_STATUS'
      | 'ORDER_LINE_ID'
      | 'ORDER_LINE_NAME'
      | 'CLICKTHROUGH_1'
      | 'REPIN_1'
      | 'IMPRESSION_1'
      | 'IMPRESSION_1_GROSS'
      | 'CLICKTHROUGH_1_GROSS'
      | 'OUTBOUND_CLICK_1'
      | 'CLICKTHROUGH_2'
      | 'REPIN_2'
      | 'IMPRESSION_2'
      | 'OUTBOUND_CLICK_2'
      | 'TOTAL_CLICKTHROUGH'
      | 'TOTAL_IMPRESSION'
      | 'TOTAL_IMPRESSION_USER'
      | 'TOTAL_IMPRESSION_FREQUENCY'
      | 'COST_PER_OUTBOUND_CLICK_IN_DOLLAR'
      | 'TOTAL_ENGAGEMENT_SIGNUP'
      | 'TOTAL_ENGAGEMENT_CHECKOUT'
      | 'TOTAL_ENGAGEMENT_LEAD'
      | 'TOTAL_CLICK_SIGNUP'
      | 'TOTAL_CLICK_CHECKOUT'
      | 'TOTAL_CLICK_ADD_TO_CART'
      | 'TOTAL_CLICK_LEAD'
      | 'TOTAL_VIEW_SIGNUP'
      | 'TOTAL_VIEW_CHECKOUT'
      | 'TOTAL_VIEW_ADD_TO_CART'
      | 'TOTAL_VIEW_LEAD'
      | 'TOTAL_CONVERSIONS'
      | 'TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_SESSIONS'
      | 'WEB_SESSIONS_1'
      | 'WEB_SESSIONS_2'
      | 'CAMPAIGN_LIFETIME_SPEND_CAP'
      | 'CAMPAIGN_DAILY_SPEND_CAP'
      | 'TOTAL_PAGE_VISIT'
      | 'TOTAL_SIGNUP'
      | 'TOTAL_CHECKOUT'
      | 'TOTAL_CUSTOM'
      | 'TOTAL_LEAD'
      | 'TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'
      | 'PAGE_VISIT_COST_PER_ACTION'
      | 'PAGE_VISIT_ROAS'
      | 'CHECKOUT_ROAS'
      | 'CUSTOM_ROAS'
      | 'VIDEO_MRC_VIEWS_1'
      | 'VIDEO_3SEC_VIEWS_2'
      | 'VIDEO_P100_COMPLETE_2'
      | 'VIDEO_P0_COMBINED_2'
      | 'VIDEO_P25_COMBINED_2'
      | 'VIDEO_P50_COMBINED_2'
      | 'VIDEO_P75_COMBINED_2'
      | 'VIDEO_P95_COMBINED_2'
      | 'VIDEO_MRC_VIEWS_2'
      | 'PAID_VIDEO_VIEWABLE_RATE'
      | 'VIDEO_LENGTH'
      | 'ECPV_IN_DOLLAR'
      | 'ECPCV_IN_DOLLAR'
      | 'ECPCV_P95_IN_DOLLAR'
      | 'TOTAL_VIDEO_3SEC_VIEWS'
      | 'TOTAL_VIDEO_P100_COMPLETE'
      | 'TOTAL_VIDEO_P0_COMBINED'
      | 'TOTAL_VIDEO_P25_COMBINED'
      | 'TOTAL_VIDEO_P50_COMBINED'
      | 'TOTAL_VIDEO_P75_COMBINED'
      | 'TOTAL_VIDEO_P95_COMBINED'
      | 'TOTAL_VIDEO_MRC_VIEWS'
      | 'TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'
      | 'TOTAL_REPIN_RATE'
      | 'WEB_CHECKOUT_COST_PER_ACTION'
      | 'WEB_CHECKOUT_ROAS'
      | 'TOTAL_WEB_CHECKOUT'
      | 'TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_CLICK_CHECKOUT'
      | 'TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT'
      | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_VIEW_CHECKOUT'
      | 'TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'INAPP_CHECKOUT_COST_PER_ACTION'
      | 'TOTAL_OFFLINE_CHECKOUT'
      | 'IDEA_PIN_PRODUCT_TAG_VISIT_1'
      | 'IDEA_PIN_PRODUCT_TAG_VISIT_2'
      | 'TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'
      | 'LEADS'
      | 'COST_PER_LEAD'
      | 'QUIZ_COMPLETED'
      | 'QUIZ_PIN_RESULT_OPEN'
      | 'QUIZ_COMPLETION_RATE'
      | 'SHOWCASE_PIN_CLICKTHROUGH'
      | 'SHOWCASE_SUBPAGE_CLICKTHROUGH'
      | 'SHOWCASE_SUBPIN_CLICKTHROUGH'
      | 'SHOWCASE_SUBPAGE_IMPRESSION'
      | 'SHOWCASE_SUBPIN_IMPRESSION'
      | 'SHOWCASE_SUBPAGE_SWIPE_LEFT'
      | 'SHOWCASE_SUBPAGE_SWIPE_RIGHT'
      | 'SHOWCASE_SUBPIN_SWIPE_LEFT'
      | 'SHOWCASE_SUBPIN_SWIPE_RIGHT'
      | 'SHOWCASE_SUBPAGE_REPIN'
      | 'SHOWCASE_SUBPIN_REPIN'
      | 'SHOWCASE_SUBPAGE_CLOSEUP'
      | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'
      | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'
      | 'SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'
      | 'TOTAL_CHECKOUT_CONVERSION_RATE'
      | 'TOTAL_VIEW_CATEGORY_CONVERSION_RATE'
      | 'TOTAL_ADD_TO_CART_CONVERSION_RATE'
      | 'TOTAL_SIGNUP_CONVERSION_RATE'
      | 'TOTAL_PAGE_VISIT_CONVERSION_RATE'
      | 'TOTAL_LEAD_CONVERSION_RATE'
      | 'TOTAL_SEARCH_CONVERSION_RATE'
      | 'TOTAL_WATCH_VIDEO_CONVERSION_RATE'
      | 'TOTAL_UNKNOWN_CONVERSION_RATE'
      | 'TOTAL_CUSTOM_CONVERSION_RATE'
    >;
    /**
     * The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.
     */
    conversion_report_time?: 'TIME_OF_AD_ACTION' | 'TIME_OF_CONVERSION';
    /**
     * Metric report end date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days past start_date.
     */
    end_date: string;
    /**
     * Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
     */
    engagement_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
    /**
     * TOTAL - metrics are aggregated over the specified date range.<br> DAY - metrics are broken down daily.<br> HOUR - metrics are broken down hourly.<br>WEEKLY - metrics are broken down weekly.<br>MONTHLY - metrics are broken down monthly
     */
    granularity: Granularity;
    /**
     * List of Product group Ids to use to filter the results.
     */
    product_group_ids: Array<string>;
    /**
     * Metric report start date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days back from today.
     */
    start_date: string;
    /**
     * Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.
     */
    view_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
  };
};

export type ProductGroupsAnalyticsResponse = ProductGroupAnalyticsResponse;

export type ProductGroupsAnalyticsError = Error;

export type AnalyticsGetReportData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query: {
    /**
     * Token returned from the post request creation call
     */
    token: string;
  };
};

export type AnalyticsGetReportResponse = AdsAnalyticsGetAsyncResponse;

export type AnalyticsGetReportError = Error;

export type AnalyticsCreateReportData = {
  body: AdsAnalyticsCreateAsyncRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type AnalyticsCreateReportResponse = AdsAnalyticsCreateAsyncResponse;

export type AnalyticsCreateReportError = Error;

export type SandboxDeleteData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type SandboxDeleteResponse = string;

export type SandboxDeleteError = Error;

export type SsioAccountsGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type SsioAccountsGetResponse = SSIOAccountResponse;

export type SsioAccountsGetError = Error;

export type SsioInsertionOrderCreateData = {
  /**
   * Order line to create.
   */
  body: SSIOCreateInsertionOrderRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type SsioInsertionOrderCreateResponse = SSIOCreateInsertionOrderResponse;

export type SsioInsertionOrderCreateError = Error;

export type SsioInsertionOrderEditData = {
  /**
   * Order line to create.
   */
  body: SSIOEditInsertionOrderRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type SsioInsertionOrderEditResponse = SSIOEditInsertionOrderResponse;

export type SsioInsertionOrderEditError = Error;

export type SsioInsertionOrdersStatusGetByAdAccountData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type SsioInsertionOrdersStatusGetByAdAccountResponse = Paginated & {
  /**
   * Insertion orders status by ad acount id
   */
  items?: unknown;
};

export type SsioInsertionOrdersStatusGetByAdAccountError = Error;

export type SsioInsertionOrdersStatusGetByPinOrderIdData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
    /**
     * The pin order id associated with the ssio insertion order
     */
    pin_order_id: string;
  };
};

export type SsioInsertionOrdersStatusGetByPinOrderIdResponse = SSIOInsertionOrderStatusResponse;

export type SsioInsertionOrdersStatusGetByPinOrderIdError = Error;

export type SsioOrderLinesGetByAdAccountData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
    /**
     * The pin order id associated with the ssio insertino order
     */
    pin_order_id?: string;
  };
};

export type SsioOrderLinesGetByAdAccountResponse = Paginated & {
  /**
   * SSIO order lines by ad acount id
   */
  items?: unknown;
};

export type SsioOrderLinesGetByAdAccountError = Error;

export type AdAccountTargetingAnalyticsGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query: {
    /**
     * List of types of attribution for the conversion report
     */
    attribution_types?: ConversionReportAttributionType;
    /**
     * Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
     */
    click_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
    /**
     * Columns to retrieve, encoded as a comma-separated string. **NOTE**: Any metrics defined as MICRO_DOLLARS returns a value based on the advertiser profile's currency field. For USD,($1/1,000,000, or $0.000001 - one one-ten-thousandth of a cent). it's microdollars. Otherwise, it's in microunits of the advertiser's currency.<br/>For example, if the advertiser's currency is GBP (British pound sterling), all MICRO_DOLLARS fields will be in GBP microunits (1/1,000,000 British pound).<br/>If a column has no value, it may not be returned
     */
    columns: Array<
      | 'SPEND_IN_MICRO_DOLLAR'
      | 'PAID_IMPRESSION'
      | 'SPEND_IN_DOLLAR'
      | 'CPC_IN_MICRO_DOLLAR'
      | 'ECPC_IN_MICRO_DOLLAR'
      | 'ECPC_IN_DOLLAR'
      | 'CTR'
      | 'ECTR'
      | 'CAMPAIGN_NAME'
      | 'PIN_ID'
      | 'TOTAL_ENGAGEMENT'
      | 'ENGAGEMENT_1'
      | 'ENGAGEMENT_2'
      | 'ECPE_IN_DOLLAR'
      | 'ENGAGEMENT_RATE'
      | 'EENGAGEMENT_RATE'
      | 'ECPM_IN_MICRO_DOLLAR'
      | 'REPIN_RATE'
      | 'CTR_2'
      | 'CAMPAIGN_ID'
      | 'ADVERTISER_ID'
      | 'AD_ACCOUNT_ID'
      | 'PIN_PROMOTION_ID'
      | 'AD_ID'
      | 'AD_GROUP_ID'
      | 'CAMPAIGN_ENTITY_STATUS'
      | 'CAMPAIGN_OBJECTIVE_TYPE'
      | 'CPM_IN_MICRO_DOLLAR'
      | 'CPM_IN_DOLLAR'
      | 'AD_GROUP_ENTITY_STATUS'
      | 'ORDER_LINE_ID'
      | 'ORDER_LINE_NAME'
      | 'CLICKTHROUGH_1'
      | 'REPIN_1'
      | 'IMPRESSION_1'
      | 'IMPRESSION_1_GROSS'
      | 'CLICKTHROUGH_1_GROSS'
      | 'OUTBOUND_CLICK_1'
      | 'CLICKTHROUGH_2'
      | 'REPIN_2'
      | 'IMPRESSION_2'
      | 'OUTBOUND_CLICK_2'
      | 'TOTAL_CLICKTHROUGH'
      | 'TOTAL_IMPRESSION'
      | 'TOTAL_IMPRESSION_USER'
      | 'TOTAL_IMPRESSION_FREQUENCY'
      | 'COST_PER_OUTBOUND_CLICK_IN_DOLLAR'
      | 'TOTAL_ENGAGEMENT_SIGNUP'
      | 'TOTAL_ENGAGEMENT_CHECKOUT'
      | 'TOTAL_ENGAGEMENT_LEAD'
      | 'TOTAL_CLICK_SIGNUP'
      | 'TOTAL_CLICK_CHECKOUT'
      | 'TOTAL_CLICK_ADD_TO_CART'
      | 'TOTAL_CLICK_LEAD'
      | 'TOTAL_VIEW_SIGNUP'
      | 'TOTAL_VIEW_CHECKOUT'
      | 'TOTAL_VIEW_ADD_TO_CART'
      | 'TOTAL_VIEW_LEAD'
      | 'TOTAL_CONVERSIONS'
      | 'TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_SESSIONS'
      | 'WEB_SESSIONS_1'
      | 'WEB_SESSIONS_2'
      | 'CAMPAIGN_LIFETIME_SPEND_CAP'
      | 'CAMPAIGN_DAILY_SPEND_CAP'
      | 'TOTAL_PAGE_VISIT'
      | 'TOTAL_SIGNUP'
      | 'TOTAL_CHECKOUT'
      | 'TOTAL_CUSTOM'
      | 'TOTAL_LEAD'
      | 'TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR'
      | 'PAGE_VISIT_COST_PER_ACTION'
      | 'PAGE_VISIT_ROAS'
      | 'CHECKOUT_ROAS'
      | 'CUSTOM_ROAS'
      | 'VIDEO_MRC_VIEWS_1'
      | 'VIDEO_3SEC_VIEWS_2'
      | 'VIDEO_P100_COMPLETE_2'
      | 'VIDEO_P0_COMBINED_2'
      | 'VIDEO_P25_COMBINED_2'
      | 'VIDEO_P50_COMBINED_2'
      | 'VIDEO_P75_COMBINED_2'
      | 'VIDEO_P95_COMBINED_2'
      | 'VIDEO_MRC_VIEWS_2'
      | 'PAID_VIDEO_VIEWABLE_RATE'
      | 'VIDEO_LENGTH'
      | 'ECPV_IN_DOLLAR'
      | 'ECPCV_IN_DOLLAR'
      | 'ECPCV_P95_IN_DOLLAR'
      | 'TOTAL_VIDEO_3SEC_VIEWS'
      | 'TOTAL_VIDEO_P100_COMPLETE'
      | 'TOTAL_VIDEO_P0_COMBINED'
      | 'TOTAL_VIDEO_P25_COMBINED'
      | 'TOTAL_VIDEO_P50_COMBINED'
      | 'TOTAL_VIDEO_P75_COMBINED'
      | 'TOTAL_VIDEO_P95_COMBINED'
      | 'TOTAL_VIDEO_MRC_VIEWS'
      | 'TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND'
      | 'TOTAL_REPIN_RATE'
      | 'WEB_CHECKOUT_COST_PER_ACTION'
      | 'WEB_CHECKOUT_ROAS'
      | 'TOTAL_WEB_CHECKOUT'
      | 'TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_CLICK_CHECKOUT'
      | 'TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT'
      | 'TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'TOTAL_WEB_VIEW_CHECKOUT'
      | 'TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR'
      | 'INAPP_CHECKOUT_COST_PER_ACTION'
      | 'TOTAL_OFFLINE_CHECKOUT'
      | 'IDEA_PIN_PRODUCT_TAG_VISIT_1'
      | 'IDEA_PIN_PRODUCT_TAG_VISIT_2'
      | 'TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT'
      | 'LEADS'
      | 'COST_PER_LEAD'
      | 'QUIZ_COMPLETED'
      | 'QUIZ_PIN_RESULT_OPEN'
      | 'QUIZ_COMPLETION_RATE'
      | 'SHOWCASE_PIN_CLICKTHROUGH'
      | 'SHOWCASE_SUBPAGE_CLICKTHROUGH'
      | 'SHOWCASE_SUBPIN_CLICKTHROUGH'
      | 'SHOWCASE_SUBPAGE_IMPRESSION'
      | 'SHOWCASE_SUBPIN_IMPRESSION'
      | 'SHOWCASE_SUBPAGE_SWIPE_LEFT'
      | 'SHOWCASE_SUBPAGE_SWIPE_RIGHT'
      | 'SHOWCASE_SUBPIN_SWIPE_LEFT'
      | 'SHOWCASE_SUBPIN_SWIPE_RIGHT'
      | 'SHOWCASE_SUBPAGE_REPIN'
      | 'SHOWCASE_SUBPIN_REPIN'
      | 'SHOWCASE_SUBPAGE_CLOSEUP'
      | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD'
      | 'SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD'
      | 'SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION'
      | 'TOTAL_CHECKOUT_CONVERSION_RATE'
      | 'TOTAL_VIEW_CATEGORY_CONVERSION_RATE'
      | 'TOTAL_ADD_TO_CART_CONVERSION_RATE'
      | 'TOTAL_SIGNUP_CONVERSION_RATE'
      | 'TOTAL_PAGE_VISIT_CONVERSION_RATE'
      | 'TOTAL_LEAD_CONVERSION_RATE'
      | 'TOTAL_SEARCH_CONVERSION_RATE'
      | 'TOTAL_WATCH_VIDEO_CONVERSION_RATE'
      | 'TOTAL_UNKNOWN_CONVERSION_RATE'
      | 'TOTAL_CUSTOM_CONVERSION_RATE'
    >;
    /**
     * The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.
     */
    conversion_report_time?: 'TIME_OF_AD_ACTION' | 'TIME_OF_CONVERSION';
    /**
     * Metric report end date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days past start_date.
     */
    end_date: string;
    /**
     * Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.
     */
    engagement_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
    /**
     * TOTAL - metrics are aggregated over the specified date range.<br> DAY - metrics are broken down daily.<br> HOUR - metrics are broken down hourly.<br>WEEKLY - metrics are broken down weekly.<br>MONTHLY - metrics are broken down monthly
     */
    granularity: Granularity;
    /**
     * Metric report start date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days back from today.
     */
    start_date: string;
    /**
     * Targeting type breakdowns for the report. The reporting per targeting type <br> is independent from each other. ["AGE_BUCKET_AND_GENDER"] is in BETA and not yet available to all users.
     */
    targeting_types: Array<AdsAnalyticsTargetingType>;
    /**
     * Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.
     */
    view_window_days?: 0 | 1 | 7 | 14 | 30 | 60;
  };
};

export type AdAccountTargetingAnalyticsGetResponse = MetricsResponse;

export type AdAccountTargetingAnalyticsGetError = Error;

export type TargetingTemplateListData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Include audience sizing in result or not
     */
    include_sizing?: boolean;
    /**
     * The order in which to sort the items returned: “ASCENDING” or “DESCENDING”
     * by ID. Note that higher-value IDs are associated with more-recently added
     * items.
     */
    order?: 'ASCENDING' | 'DESCENDING';
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
    /**
     * Search keyword for targeting templates
     */
    search_query?: string;
  };
};

export type TargetingTemplateListResponse = Paginated & {
  items?: Array<TargetingTemplateResponseData>;
};

export type TargetingTemplateListError = Error;

export type TargetingTemplateCreateData = {
  /**
   * targeting template creation entity
   */
  body: TargetingTemplateCreate;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type TargetingTemplateCreateResponse = TargetingTemplateGetResponseData;

export type TargetingTemplateCreateError = Error;

export type TargetingTemplateUpdateData = {
  /**
   * Operation type and targeting template ID
   */
  body: TargetingTemplateUpdateRequest;
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
};

export type TargetingTemplateUpdateResponse = unknown;

export type TargetingTemplateUpdateError = Error;

export type TemplatesListData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * The order in which to sort the items returned: “ASCENDING” or “DESCENDING”
     * by ID. Note that higher-value IDs are associated with more-recently added
     * items.
     */
    order?: 'ASCENDING' | 'DESCENDING';
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type TemplatesListResponse = Paginated & {
  items?: Array<TemplateResponse>;
};

export type TemplatesListError = Error;

export type AnalyticsCreateTemplateReportData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
    /**
     * Unique identifier of a template.
     */
    template_id: string;
  };
  query?: {
    /**
     * Metric report end date (UTC). Format: YYYY-MM-DD. Cannot be more than 2.5 years past start date.
     */
    end_date?: string;
    /**
     * TOTAL - metrics are aggregated over the specified date range.<br> DAY - metrics are broken down daily.<br> HOUR - metrics are broken down hourly.<br>WEEKLY - metrics are broken down weekly.<br>MONTHLY - metrics are broken down monthly
     */
    granularity?: Granularity;
    /**
     * Metric report start date (UTC). Format: YYYY-MM-DD. Cannot be more than 2.5 years back from today.
     */
    start_date?: string;
  };
};

export type AnalyticsCreateTemplateReportResponse = AdsAnalyticsCreateAsyncResponse;

export type AnalyticsCreateTemplateReportError = Error;

export type TermsOfServiceGetData = {
  path: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id: string;
  };
  query?: {
    /**
     * Return HTML in TOS text.
     */
    include_html?: boolean;
    /**
     * Request type.
     */
    tos_type?: string;
  };
};

export type TermsOfServiceGetResponse = TermsOfService;

export type TermsOfServiceGetError = Error;

export type AdvancedAuctionItemsGetPostData = {
  /**
   * Request object used to get bid options values for a batch of retail catalog items
   */
  body: AdvancedAuctionItemsGetRequest;
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type AdvancedAuctionItemsGetPostResponse = AdvancedAuctionItems;

export type AdvancedAuctionItemsGetPostError = Error;

export type AdvancedAuctionItemsSubmitPostData = {
  /**
   * Request object used to upsert or delete bid options for a batch of retail catalog items
   */
  body: AdvancedAuctionItemsSubmitRequest;
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type AdvancedAuctionItemsSubmitPostResponse = AdvancedAuctionProcessedItems;

export type AdvancedAuctionItemsSubmitPostError = Error;

export type BoardsListData = {
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
    /**
     * Privacy setting for a board.
     */
    privacy?: 'ALL' | 'PROTECTED' | 'PUBLIC' | 'SECRET' | 'PUBLIC_AND_SECRET';
  };
};

export type BoardsListResponse = Paginated & {
  /**
   * Boards
   */
  items?: unknown;
};

export type BoardsListError = Error;

export type BoardsCreateData = {
  /**
   * Create a board using a single board json object.
   */
  body: Board;
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type BoardsCreateResponse = Board;

export type BoardsCreateError = Error;

export type BoardsGetData = {
  path: {
    /**
     * Unique identifier of a board.
     */
    board_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type BoardsGetResponse = Board;

export type BoardsGetError = Error;

export type BoardsUpdateData = {
  /**
   * Update a board.
   */
  body: BoardUpdate;
  path: {
    /**
     * Unique identifier of a board.
     */
    board_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type BoardsUpdateResponse = Board;

export type BoardsUpdateError = Error;

export type BoardsDeleteData = {
  path: {
    /**
     * Unique identifier of a board.
     */
    board_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type BoardsDeleteResponse = any;

export type BoardsDeleteError = Error;

export type BoardsListPinsData = {
  path: {
    /**
     * Unique identifier of a board.
     */
    board_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Pin creative types filter. </p><strong>Note:</strong> SHOP_THE_PIN has been deprecated. Please use COLLECTION instead.
     */
    creative_types?: Array<
      'REGULAR' | 'VIDEO' | 'SHOPPING' | 'CAROUSEL' | 'MAX_VIDEO' | 'SHOP_THE_PIN' | 'COLLECTION' | 'IDEA'
    >;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
    /**
     * Specify whether to return 90d and lifetime Pin metrics. Total comments and total reactions are only available with lifetime Pin metrics. If Pin was created before <code>2023-03-20</code> lifetime metrics will only be available for Video and Idea Pin formats. Lifetime metrics are available for all Pin formats since then.
     */
    pin_metrics?: boolean;
  };
};

export type BoardsListPinsResponse = Paginated & {
  /**
   * Pins
   */
  items?: unknown;
};

export type BoardsListPinsError = Error;

export type BoardSectionsListData = {
  path: {
    /**
     * Unique identifier of a board.
     */
    board_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type BoardSectionsListResponse = Paginated & {
  /**
   * Board sections
   */
  items?: unknown;
};

export type BoardSectionsListError = Error;

export type BoardSectionsCreateData = {
  /**
   * Create a board section.
   */
  body: BoardSection;
  path: {
    /**
     * Unique identifier of a board.
     */
    board_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type BoardSectionsCreateResponse = BoardSection;

export type BoardSectionsCreateError = Error;

export type BoardSectionsUpdateData = {
  /**
   * Update a board section.
   */
  body: BoardSection;
  path: {
    /**
     * Unique identifier of a board.
     */
    board_id: string;
    /**
     * Unique identifier of a board section.
     */
    section_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type BoardSectionsUpdateResponse = BoardSection;

export type BoardSectionsUpdateError = Error;

export type BoardSectionsDeleteData = {
  path: {
    /**
     * Unique identifier of a board.
     */
    board_id: string;
    /**
     * Unique identifier of a board section.
     */
    section_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type BoardSectionsDeleteResponse = any;

export type BoardSectionsDeleteError = Error;

export type BoardSectionsListPinsData = {
  path: {
    /**
     * Unique identifier of a board.
     */
    board_id: string;
    /**
     * Unique identifier of a board section.
     */
    section_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type BoardSectionsListPinsResponse = Paginated & {
  /**
   * Pins
   */
  items?: unknown;
};

export type BoardSectionsListPinsError = Error;

export type GetBusinessEmployersData = {
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type GetBusinessEmployersResponse = Paginated & {
  /**
   * List of employers.
   */
  items?: Array<UserBusinessRoleBinding>;
};

export type GetBusinessEmployersError = Error;

export type RespondBusinessAccessInvitesData = {
  body: AuthRespondInvitesBody;
};

export type RespondBusinessAccessInvitesResponse = RespondToInvitesResponseArray;

export type RespondBusinessAccessInvitesError = Error;

export type BusinessAssetMembersGetData = {
  path: {
    /**
     * Unique identifier of a business asset.
     */
    asset_id: string;
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
    /**
     * An index to start fetching the results from. Only the results starting from this index will be returned.
     */
    start_index?: number;
  };
};

export type BusinessAssetMembersGetResponse = Paginated & {
  /**
   * List of members with permissions to the asset.
   */
  items?: Array<UserSingleAssetBinding>;
};

export type BusinessAssetMembersGetError = Error;

export type BusinessAssetPartnersGetData = {
  path: {
    /**
     * Unique identifier of a business asset.
     */
    asset_id: string;
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
    /**
     * An index to start fetching the results from. Only the results starting from this index will be returned.
     */
    start_index?: number;
  };
};

export type BusinessAssetPartnersGetResponse = Paginated & {
  /**
   * List of partners with permissions to the asset.
   */
  items?: Array<UserSingleAssetBinding>;
};

export type BusinessAssetPartnersGetError = Error;

export type CreateAssetInvitesData = {
  /**
   * A list of invites/requests together with the asset permissions to be assigned to the invite/request.
   *
   */
  body: CreateAssetInvitesRequest;
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
};

export type CreateAssetInvitesResponse = UpdateInvitesResultsResponseArray;

export type CreateAssetInvitesError = Error;

export type AssetAccessRequestsCreateData = {
  body: CreateAssetAccessRequestBody;
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
};

export type AssetAccessRequestsCreateResponse = CreateAssetAccessRequestResponse;

export type AssetAccessRequestsCreateError = Error;

export type GetBusinessMembersData = {
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
  query?: {
    /**
     * Include assets summary in the response if this is true.
     *
     * The assets summary returns a dictionary representing a summary of the assets
     * for the business user ID, with information like the ad accounts and profiles
     * the user has permissions for and what those permissions are
     */
    assets_summary?: boolean;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * A list of business roles to filter the members by. Only members whose roles are in the specified roles will be returned.
     */
    business_roles?: Array<MemberBusinessRole>;
    /**
     * A list of business members ids separated by comma.
     */
    member_ids?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
    /**
     * An index to start fetching the results from. Only the results starting from this index will be returned.
     */
    start_index?: number;
  };
};

export type GetBusinessMembersResponse = Paginated & {
  /**
   * List of business members.
   */
  items?: Array<UserBusinessRoleBinding>;
};

export type GetBusinessMembersError = Error;

export type UpdateBusinessMembershipsData = {
  /**
   * List of objects with the member id and the business_role.
   */
  body: Array<UpdateMemberBusinessRoleBody>;
  path: {
    /**
     * Business id
     */
    business_id: string;
  };
};

export type UpdateBusinessMembershipsResponse = UpdateMemberResultsResponseArray;

export type UpdateBusinessMembershipsError = Error;

export type DeleteBusinessMembershipData = {
  /**
   * List of members with role to delete.
   */
  body: MembersToDeleteBody;
  path: {
    /**
     * Business id
     */
    business_id: string;
  };
};

export type DeleteBusinessMembershipResponse = DeletedMembersResponse;

export type DeleteBusinessMembershipError = Error;

export type BusinessAssetsGetData = {
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
  query?: {
    /**
     * An asset group unique identifier. Used to fetch assets contained within the specified asset group.
     */
    asset_group_id?: string;
    /**
     * A resource type to filter the assets by. Only assets of the specified type will be returned.
     */
    asset_type?: 'AD_ACCOUNT' | 'PROFILE' | 'ASSET_GROUP';
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * A child asset unique identifier. Used to fetch asset groups that contain the asset id as a child.
     */
    child_asset_id?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
    /**
     * A list of asset permissions used to filter the assets. Only assets where the requesting business has at least one of the specified permissions will be returned.
     */
    permissions?: Array<PermissionsWithOwner>;
    /**
     * An index to start fetching the results from. Only the results starting from this index will be returned.
     */
    start_index?: number;
  };
};

export type BusinessAssetsGetResponse = Paginated & {
  /**
   * List of assets the requesting business has access to.
   */
  items?: Array<GetBusinessAssetsResponse>;
};

export type BusinessAssetsGetError = Error;

export type BusinessMemberAssetsGetData = {
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
    /**
     * The member id to fetch assets for.
     */
    member_id: string;
  };
  query?: {
    /**
     * A resource type to filter the assets by. Only assets of the specified type will be returned.
     */
    asset_type?: 'AD_ACCOUNT' | 'PROFILE' | 'ASSET_GROUP';
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
    /**
     * An index to start fetching the results from. Only the results starting from this index will be returned.
     */
    start_index?: number;
  };
};

export type BusinessMemberAssetsGetResponse = Paginated & {
  /**
   * List asset permissions the given member was granted.
   */
  items?: Array<AssetIdPermissions>;
};

export type BusinessMemberAssetsGetError = Error;

export type BusinessMembersAssetAccessUpdateData = {
  /**
   * List of member asset permissions to create or update.
   */
  body: UpdateMemberAssetAccessBody;
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
};

export type BusinessMembersAssetAccessUpdateResponse = UpdateMemberAssetsResultsResponseArray;

export type BusinessMembersAssetAccessUpdateError = Error;

export type BusinessMembersAssetAccessDeleteData = {
  /**
   * List member assset permissions to delete.
   */
  body: {
    /**
     * List of members asset access to be deleted
     */
    accesses: Array<{
      /**
       * Id of the asset on which to remove member permissions.
       */
      asset_id: string;
      /**
       * Unique identifier of the member on which to perform the asset permission removal
       */
      member_id: string;
    }>;
  };
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
};

export type BusinessMembersAssetAccessDeleteResponse = DeleteMemberAccessResultsResponseArray;

export type BusinessMembersAssetAccessDeleteError = Error;

export type GetInvitesData = {
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * A list of invite statuses to filter invites by. Only invites whose status is in the provided statuses will be returned.
     */
    invite_status?: Array<'PENDING' | 'EXPIRED'>;
    /**
     * Invite type to filter invites by. Only invites of the specified type will be returned.
     */
    invite_type?: InviteType;
    /**
     * A boolean field to indicate whether the invite is to create a partnership or a membership.
     */
    is_member?: boolean;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type GetInvitesResponse = Paginated & {
  /**
   * List of invite and request data.
   */
  items?: Array<InviteResponse>;
};

export type GetInvitesError = Error;

export type CreateMembershipOrPartnershipInvitesData = {
  /**
   * An object with the properties: invite_type, partners, members, business_role
   */
  body: CreateMembershipOrPartnershipInvitesBody;
  path: {
    /**
     * Business id
     */
    business_id: string;
  };
};

export type CreateMembershipOrPartnershipInvitesResponse = CreateInvitesResultsResponseArray;

export type CreateMembershipOrPartnershipInvitesError = Error;

export type CancelInvitesOrRequestsData = {
  /**
   * A list with invite ids
   */
  body: CancelInvitesBody;
  path: {
    /**
     * Business id
     */
    business_id: string;
  };
};

export type CancelInvitesOrRequestsResponse = DeleteInvitesResultsResponseArray;

export type CancelInvitesOrRequestsError = Error;

export type UpdatePartnerAssetAccessHandlerImplData = {
  /**
   * A list of assets and permissions to assign to your partners.
   */
  body: UpdatePartnerAssetAccessBody;
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
};

export type UpdatePartnerAssetAccessHandlerImplResponse = UpdatePartnerAssetsResultsResponseArray;

export type UpdatePartnerAssetAccessHandlerImplError = Error;

export type DeletePartnerAssetAccessHandlerImplData = {
  body: DeletePartnerAssetAccessBody;
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
};

export type DeletePartnerAssetAccessHandlerImplResponse = DeletePartnerAssetsResultsResponseArray;

export type DeletePartnerAssetAccessHandlerImplError = Error;

export type BusinessPartnerAssetAccessGetData = {
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
    /**
     * The partner id to be bound to the Business
     */
    partner_id: string;
  };
  query?: {
    /**
     * A resource type to filter the assets by. Only assets of the specified type will be returned.
     */
    asset_type?: 'AD_ACCOUNT' | 'PROFILE' | 'ASSET_GROUP';
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
    /**
     * Specifies whether to fetch internal or external (shared) partners.
     * If partner_type=INTERNAL, the asset being queried is for accesses the partner has to your business assets.<br>
     * If partner_type=EXTERNAL, the asset being queried is for the accesses you have to the partner's business asset.
     */
    partner_type?: PartnerType & unknown;
    /**
     * An index to start fetching the results from. Only the results starting from this index will be returned.
     */
    start_index?: number;
  };
};

export type BusinessPartnerAssetAccessGetResponse = Paginated & {
  /**
   * List assets on which you granted access to your partner or assets on which your partner has granted you access.
   */
  items?: Array<GetPartnerAssetsResponse>;
};

export type BusinessPartnerAssetAccessGetError = Error;

export type GetBusinessPartnersData = {
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
  query?: {
    /**
     * Include assets summary in the response if this is true.
     *
     * The assets summary returns a dictionary representing a summary of the assets
     * for the business user ID, with information like the ad accounts and profiles
     * the user has permissions for and what those permissions are
     */
    assets_summary?: boolean;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
    /**
     * A list of business partner ids separated by commas used to filter the results. Only partners with the specified ids will be returned.
     */
    partner_ids?: string;
    /**
     * Specifies whether to fetch internal or external (shared) partners.
     * If partner_type=INTERNAL, the asset being queried is for accesses the partner has to your business assets.<br>
     * If partner_type=EXTERNAL, the asset being queried is for the accesses you have to the partner's business asset.
     */
    partner_type?: PartnerType;
    /**
     * An index to start fetching the results from. Only the results starting from this index will be returned.
     */
    start_index?: number;
  };
};

export type GetBusinessPartnersResponse = Paginated & {
  /**
   * List of business partners.
   */
  items?: Array<UserBusinessRoleBinding>;
};

export type GetBusinessPartnersError = Error;

export type DeleteBusinessPartnersData = {
  /**
   * An object containing a "partner_ids" property composed of a list of partner IDs and a "partners_type" property specifying the type of partners to delete.
   *
   */
  body: DeletePartnersRequest;
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
};

export type DeleteBusinessPartnersResponse = DeletePartnersResponse;

export type DeleteBusinessPartnersError = Error;

export type SharedAudiencesForBusinessListData = {
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * The order in which to sort the items returned: “ASCENDING” or “DESCENDING”
     * by ID. Note that higher-value IDs are associated with more-recently added
     * items.
     */
    order?: 'ASCENDING' | 'DESCENDING';
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type SharedAudiencesForBusinessListResponse = Paginated & {
  items?: Array<Audience>;
};

export type SharedAudiencesForBusinessListError = Error;

export type BusinessAccountAudiencesSharedAccountsListData = {
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
  query: {
    /**
     * Filter accounts by account type.
     */
    account_type: AudienceAccountType;
    /**
     * Unique identifier of the audience to use to filter the results.
     */
    audience_id: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type BusinessAccountAudiencesSharedAccountsListResponse = Paginated & {
  items?: Array<SharedAudienceAccount>;
};

export type BusinessAccountAudiencesSharedAccountsListError = Error;

export type UpdateBusinessToAdAccountSharedAudienceData = {
  body: SharedAudience;
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
};

export type UpdateBusinessToAdAccountSharedAudienceResponse = SharedAudienceResponse;

export type UpdateBusinessToAdAccountSharedAudienceError = Error;

export type UpdateBusinessToBusinessSharedAudienceData = {
  body: BusinessSharedAudience;
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
};

export type UpdateBusinessToBusinessSharedAudienceResponse = BusinessSharedAudienceResponse;

export type UpdateBusinessToBusinessSharedAudienceError = Error;

export type AssetGroupCreateData = {
  body: CreateAssetGroupBody;
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
};

export type AssetGroupCreateResponse = CreateAssetGroupResponse;

export type AssetGroupCreateError = Error;

export type AssetGroupUpdateData = {
  body: UpdateAssetGroupBody;
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
};

export type AssetGroupUpdateResponse = UpdateAssetGroupResponse;

export type AssetGroupUpdateError = Error;

export type AssetGroupDeleteData = {
  body: DeleteAssetGroupBody;
  path: {
    /**
     * Unique identifier of the requesting business.
     */
    business_id: string;
  };
};

export type AssetGroupDeleteResponse = DeleteAssetGroupResponse;

export type AssetGroupDeleteError = Error;

export type CatalogsListData = {
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type CatalogsListResponse = Paginated & {
  items?: Array<Catalog>;
};

export type CatalogsListError = Error;

export type CatalogsCreateData = {
  /**
   * Request object used to created a feed.
   */
  body: CatalogsCreateRequest;
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type CatalogsCreateResponse = Catalog;

export type CatalogsCreateError = Error;

export type FeedsListData = {
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Filter entities for a given catalog_id. If not given, all catalogs are considered.
     */
    catalog_id?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type FeedsListResponse = Paginated & {
  items?: Array<CatalogsFeed>;
};

export type FeedsListError = Error;

export type FeedsCreateData = {
  /**
   * Request object used to created a feed.
   */
  body: CatalogsVerticalFeedsCreateRequest | CatalogsFeedsCreateRequest;
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type FeedsCreateResponse = CatalogsFeed;

export type FeedsCreateError = Error;

export type FeedsGetData = {
  path: {
    /**
     * Unique identifier of a feed
     */
    feed_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type FeedsGetResponse = CatalogsFeed;

export type FeedsGetError = Error;

export type FeedsUpdateData = {
  /**
   * Request object used to update a feed.
   */
  body: CatalogsVerticalFeedsUpdateRequest | CatalogsFeedsUpdateRequest;
  path: {
    /**
     * Unique identifier of a feed
     */
    feed_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type FeedsUpdateResponse = CatalogsFeed;

export type FeedsUpdateError = Error;

export type FeedsDeleteData = {
  path: {
    /**
     * Unique identifier of a feed
     */
    feed_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type FeedsDeleteResponse = any;

export type FeedsDeleteError = Error;

export type FeedsIngestData = {
  path: {
    /**
     * Unique identifier of a feed
     */
    feed_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type FeedsIngestResponse = CatalogsFeedIngestion;

export type FeedsIngestError = Error;

export type FeedProcessingResultsListData = {
  path: {
    /**
     * Unique identifier of a feed
     */
    feed_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type FeedProcessingResultsListResponse = Paginated & {
  items?: Array<CatalogsFeedProcessingResult>;
};

export type FeedProcessingResultsListError = Error;

export type ItemsIssuesListData = {
  path: {
    /**
     * Unique identifier of a feed processing result. It can be acquired from the "id" field of the "items" array within the response of the [List processing results for a given feed](/docs/api/v5/#operation/feed_processing_results/list).
     */
    processing_result_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Item number based on order of appearance in the Catalogs Feed. For example, '0' refers to first item found in a feed that was downloaded from a 'location' specified during feed creation.
     */
    item_numbers?: Array<number>;
    /**
     * Filter item validation issues that have a given type of item validation issue.
     */
    item_validation_issue?: CatalogsItemValidationIssue;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type ItemsIssuesListResponse = Paginated & {
  items?: Array<CatalogsItemValidationIssues>;
};

export type ItemsIssuesListError = Error;

export type ItemsGetData = {
  query: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Country for the Catalogs Items
     */
    country: string;
    /**
     * Identifies items to be retrieved. This is a required parameter.
     */
    filters?: CatalogsItemsFilters;
    /**
     * This parameter is deprecated. Use filters instead.
     * @deprecated
     */
    item_ids?: Array<string>;
    /**
     * Language for the Catalogs Items
     */
    language: string;
  };
};

export type ItemsGetResponse = CatalogsItems;

export type ItemsGetError = Error;

export type ItemsPostData = {
  /**
   * Request object used to get catalogs items
   */
  body: CatalogsItemsRequest;
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type ItemsPostResponse = CatalogsItems;

export type ItemsPostError = Error;

export type ItemsBatchPostData = {
  /**
   * Request object used to create catalogs items in a batch
   */
  body: CatalogsVerticalBatchRequest | CatalogsItemsBatchRequest;
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type ItemsBatchPostResponse = CatalogsItemsBatch;

export type ItemsBatchPostError = Error;

export type ItemsBatchGetData = {
  path: {
    /**
     * Id of a catalogs items batch to fetch
     */
    batch_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type ItemsBatchGetResponse = CatalogsItemsBatch;

export type ItemsBatchGetError = Error;

export type CatalogsProductGroupsDeleteManyData = {
  query: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Comma-separated list of product group ids
     */
    id: Array<number>;
  };
};

export type CatalogsProductGroupsDeleteManyResponse = any;

export type CatalogsProductGroupsDeleteManyError = Error;

export type CatalogsProductGroupsCreateManyData = {
  /**
   * Request object used to create one or more catalogs product groups.
   */
  body: Array<CatalogsProductGroupCreateRequest | CatalogsVerticalProductGroupCreateRequest>;
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type CatalogsProductGroupsCreateManyResponse = Array<string>;

export type CatalogsProductGroupsCreateManyError = Error;

export type CatalogsProductGroupsListData = {
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Filter entities for a given catalog_id. If not given, all catalogs are considered.
     */
    catalog_id?: string;
    /**
     * Filter entities for a given feed_id. If not given, all feeds are considered.
     */
    feed_id?: string;
    /**
     * Comma-separated list of product group ids
     */
    id?: Array<number>;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type CatalogsProductGroupsListResponse = Paginated & {
  items?: Array<CatalogsVerticalProductGroup>;
};

export type CatalogsProductGroupsListError = Error;

export type CatalogsProductGroupsCreateData = {
  /**
   * Request object used to create a single catalogs product groups.
   */
  body: CatalogsProductGroupCreateRequest | CatalogsVerticalProductGroupCreateRequest;
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type CatalogsProductGroupsCreateResponse = CatalogsVerticalProductGroup;

export type CatalogsProductGroupsCreateError = Error;

export type CatalogsProductGroupsGetData = {
  path: {
    /**
     * Unique identifier of a product group
     */
    product_group_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type CatalogsProductGroupsGetResponse = CatalogsVerticalProductGroup;

export type CatalogsProductGroupsGetError = Error;

export type CatalogsProductGroupsDeleteData = {
  path: {
    /**
     * Unique identifier of a product group
     */
    product_group_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type CatalogsProductGroupsDeleteResponse = any;

export type CatalogsProductGroupsDeleteError = Error;

export type CatalogsProductGroupsUpdateData = {
  /**
   * Request object used to Update a catalogs product group.
   */
  body: CatalogsProductGroupUpdateRequest | CatalogsVerticalProductGroupUpdateRequest;
  path: {
    /**
     * Unique identifier of a product group
     */
    product_group_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type CatalogsProductGroupsUpdateResponse = CatalogsVerticalProductGroup;

export type CatalogsProductGroupsUpdateError = Error;

export type CatalogsProductGroupsProductCountsGetData = {
  path: {
    /**
     * Unique identifier of a product group
     */
    product_group_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type CatalogsProductGroupsProductCountsGetResponse = CatalogsProductGroupProductCountsVertical;

export type CatalogsProductGroupsProductCountsGetError = Error;

export type CatalogsProductGroupPinsListData = {
  path: {
    /**
     * Unique identifier of a product group
     */
    product_group_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
    /**
     * Specify whether to return 90d and lifetime Pin metrics. Total comments and total reactions are only available with lifetime Pin metrics. If Pin was created before <code>2023-03-20</code> lifetime metrics will only be available for Video and Idea Pin formats. Lifetime metrics are available for all Pin formats since then.
     */
    pin_metrics?: boolean;
  };
};

export type CatalogsProductGroupPinsListResponse = Paginated & {
  /**
   * Pins
   */
  items?: unknown;
};

export type CatalogsProductGroupPinsListError = Error;

export type ProductsByProductGroupFilterListData = {
  /**
   * Object holding a group of filters for a catalog product group
   */
  body: CatalogsListProductsByFilterRequest;
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
    /**
     * Specify whether to return 90d and lifetime Pin metrics. Total comments and total reactions are only available with lifetime Pin metrics. If Pin was created before <code>2023-03-20</code> lifetime metrics will only be available for Video and Idea Pin formats. Lifetime metrics are available for all Pin formats since then.
     */
    pin_metrics?: boolean;
  };
};

export type ProductsByProductGroupFilterListResponse = Paginated & {
  /**
   * Pins
   */
  items?: unknown;
};

export type ProductsByProductGroupFilterListError = Error;

export type ReportsCreateData = {
  /**
   * Request object to asynchronously create a report.
   */
  body: CatalogsReportParameters;
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type ReportsCreateResponse = CatalogsCreateReportResponse;

export type ReportsCreateError = Error;

export type ReportsGetData = {
  query: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Token returned from async build report call
     */
    token: string;
  };
};

export type ReportsGetResponse = CatalogsReport;

export type ReportsGetError = Error;

export type ReportsStatsData = {
  query: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
    /**
     * Contains the parameters for report identification.
     */
    parameters: CatalogsReportParameters;
  };
};

export type ReportsStatsResponse = Paginated & {
  items?: Array<CatalogsReportStats>;
};

export type ReportsStatsError = Error;

export type IntegrationsCommercePostData = {
  /**
   * Parameters to get create/update the Integration Metadata
   */
  body?: IntegrationRequest;
};

export type IntegrationsCommercePostResponse = IntegrationMetadata;

export type IntegrationsCommercePostError = Error;

export type IntegrationsCommerceGetData = {
  path: {
    /**
     * External business ID for the integration.
     */
    external_business_id: string;
  };
};

export type IntegrationsCommerceGetResponse = IntegrationMetadata;

export type IntegrationsCommerceGetError = Error;

export type IntegrationsCommercePatchData = {
  /**
   * Parameters to get create/update the Integration Metadata
   */
  body?: IntegrationRequestPatch;
  path: {
    /**
     * External business ID for the integration.
     */
    external_business_id: string;
  };
};

export type IntegrationsCommercePatchResponse = IntegrationMetadata;

export type IntegrationsCommercePatchError = Error;

export type IntegrationsCommerceDelData = {
  path: {
    /**
     * External business ID for the integration.
     */
    external_business_id: string;
  };
};

export type IntegrationsCommerceDelResponse = any;

export type IntegrationsCommerceDelError = Error;

export type IntegrationsLogsPostData = {
  /**
   * Ingest log information from external integration application.
   */
  body: IntegrationLogsRequest;
};

export type IntegrationsLogsPostResponse = IntegrationLogsSuccessResponse;

export type IntegrationsLogsPostError = DetailedError | Error;

export type IntegrationsGetListData = {
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type IntegrationsGetListResponse = Paginated & {
  items?: Array<IntegrationRecord>;
};

export type IntegrationsGetListError = Error;

export type IntegrationsGetByIdData = {
  path: {
    /**
     * Integration ID.
     */
    id: string;
  };
};

export type IntegrationsGetByIdResponse = IntegrationRecord;

export type IntegrationsGetByIdError = Error;

export type MediaListData = {
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type MediaListResponse = Paginated & {
  /**
   * Media
   */
  items?: unknown;
};

export type MediaListError = Error;

export type MediaCreateData = {
  /**
   * Create a media upload request
   */
  body: MediaUploadRequest;
};

export type MediaCreateResponse = MediaUpload;

export type MediaCreateError = Error;

export type MediaGetData = {
  path: {
    /**
     * Media identifier
     */
    media_id: string;
  };
};

export type MediaGetResponse = MediaUploadDetails;

export type MediaGetError = Error;

export type OauthTokenData = {
  /**
   * Generate an OAuth access token.
   */
  body: OauthAccessTokenRequest;
};

export type OauthTokenResponse = OauthAccessTokenResponse;

export type OauthTokenError = Error;

export type PinsListData = {
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Pin creative types filter. </p><strong>Note:</strong> SHOP_THE_PIN has been deprecated. Please use COLLECTION instead.
     */
    creative_types?: Array<
      'REGULAR' | 'VIDEO' | 'SHOPPING' | 'CAROUSEL' | 'MAX_VIDEO' | 'SHOP_THE_PIN' | 'COLLECTION' | 'IDEA'
    >;
    /**
     * Specify if return pins from protected boards
     */
    include_protected_pins?: boolean;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
    /**
     * Pin filter.
     */
    pin_filter?: 'exclude_native' | 'exclude_repins' | 'has_been_promoted';
    /**
     * Specify whether to return 90d and lifetime Pin metrics. Total comments and total reactions are only available with lifetime Pin metrics. If Pin was created before <code>2023-03-20</code> lifetime metrics will only be available for Video and Idea Pin formats. Lifetime metrics are available for all Pin formats since then.
     */
    pin_metrics?: boolean;
    /**
     * The type of pins to return, currently only enabled for private pins
     */
    pin_type?: 'PRIVATE';
  };
};

export type PinsListResponse = Paginated & {
  items?: Array<Pin>;
};

export type PinsListError = Error;

export type PinsCreateData = {
  /**
   * Create a new Pin.
   */
  body: PinCreate;
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type PinsCreateResponse = Pin;

export type PinsCreateError = Error;

export type PinsGetData = {
  path: {
    /**
     * Unique identifier of a Pin.
     */
    pin_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Specify whether to return 90d and lifetime Pin metrics. Total comments and total reactions are only available with lifetime Pin metrics. If Pin was created before <code>2023-03-20</code> lifetime metrics will only be available for Video and Idea Pin formats. Lifetime metrics are available for all Pin formats since then.
     */
    pin_metrics?: boolean;
  };
};

export type PinsGetResponse = Pin;

export type PinsGetError = Error;

export type PinsDeleteData = {
  path: {
    /**
     * Unique identifier of a Pin.
     */
    pin_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type PinsDeleteResponse = any;

export type PinsDeleteError = Error;

export type PinsUpdateData = {
  body: PinUpdate;
  path: {
    /**
     * Unique identifier of a Pin.
     */
    pin_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type PinsUpdateResponse = Pin;

export type PinsUpdateError = Error;

export type PinsAnalyticsData = {
  path: {
    /**
     * Unique identifier of a Pin.
     */
    pin_id: string;
  };
  query: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Apps or devices to get data for, default is all.
     */
    app_types?: 'ALL' | 'MOBILE' | 'TABLET' | 'WEB';
    /**
     * Metric report end date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days past start_date.
     */
    end_date: string;
    /**
     * Pin metric types to get data for. VIDEO_MRC_VIEW are Video views, VIDEO_V50_WATCH_TIME is Total play time. If Pin was created before <code>2023-03-20</code>, Profile visits and Follows will only be available for Idea Pins. These metrics are available for all Pin formats since then. Keep in mind this cannot have ALL if split_field is set to any value other than <code>NO_SPLIT</code>.
     */
    metric_types: Array<
      | 'IMPRESSION'
      | 'OUTBOUND_CLICK'
      | 'PIN_CLICK'
      | 'SAVE'
      | 'SAVE_RATE'
      | 'TOTAL_COMMENTS'
      | 'TOTAL_REACTIONS'
      | 'USER_FOLLOW'
      | 'PROFILE_VISIT'
      | 'IMPRESSION'
      | 'OUTBOUND_CLICK'
      | 'PIN_CLICK'
      | 'SAVE'
      | 'SAVE_RATE'
      | 'VIDEO_MRC_VIEW'
      | 'VIDEO_10S_VIEW'
      | 'QUARTILE_95_PERCENT_VIEW'
      | 'VIDEO_V50_WATCH_TIME'
      | 'VIDEO_START'
      | 'VIDEO_AVG_WATCH_TIME'
      | 'TOTAL_COMMENTS'
      | 'TOTAL_REACTIONS'
    >;
    /**
     * How to split the data into groups. Not including this param means data won't be split.
     */
    split_field?: 'NO_SPLIT' | 'APP_TYPE';
    /**
     * Metric report start date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days back from today.
     */
    start_date: string;
  };
};

export type PinsAnalyticsResponse = PinAnalyticsResponse;

export type PinsAnalyticsError = Error;

export type MultiPinsAnalyticsData = {
  query: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Apps or devices to get data for, default is all.
     */
    app_types?: 'ALL' | 'MOBILE' | 'TABLET' | 'WEB';
    /**
     * Metric report end date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days past start_date.
     */
    end_date: string;
    /**
     * Pin metric types to get data for.
     */
    metric_types: Array<
      | 'IMPRESSION'
      | 'OUTBOUND_CLICK'
      | 'PIN_CLICK'
      | 'SAVE'
      | 'SAVE_RATE'
      | 'TOTAL_COMMENTS'
      | 'TOTAL_REACTIONS'
      | 'USER_FOLLOW'
      | 'PROFILE_VISIT'
      | 'IMPRESSION'
      | 'OUTBOUND_CLICK'
      | 'PIN_CLICK'
      | 'SAVE'
      | 'SAVE_RATE'
      | 'VIDEO_MRC_VIEW'
      | 'VIDEO_10S_VIEW'
      | 'QUARTILE_95_PERCENT_VIEW'
      | 'VIDEO_V50_WATCH_TIME'
      | 'VIDEO_START'
      | 'VIDEO_AVG_WATCH_TIME'
      | 'TOTAL_COMMENTS'
      | 'TOTAL_REACTIONS'
    >;
    /**
     * List of Pin IDs.
     */
    pin_ids: Array<string>;
    /**
     * Metric report start date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days back from today.
     */
    start_date: string;
  };
};

export type MultiPinsAnalyticsResponse = BulkPinAnalyticsResponse;

export type MultiPinsAnalyticsError = Error;

export type PinsSaveData = {
  /**
   * Request object used to save an existing pin
   */
  body: {
    /**
     * Unique identifier of the board to which the pin will be saved.
     */
    board_id?: string | null;
    /**
     * Unique identifier of the board section to which the pin will be saved.
     */
    board_section_id?: string | null;
  };
  path: {
    /**
     * Unique identifier of a Pin.
     */
    pin_id: string;
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type PinsSaveResponse = Pin;

export type PinsSaveError = Error;

export type AdAccountCountriesGetResponse = AdAccountsCountryResponse;

export type AdAccountCountriesGetError = Error;

export type DeliveryMetricsGetData = {
  query?: {
    /**
     * Report type.
     */
    report_type?: 'SYNC' | 'ASYNC';
  };
};

export type DeliveryMetricsGetResponse = DeliveryMetricsResponse;

export type DeliveryMetricsGetError = Error;

export type LeadFormQuestionsGetResponse = unknown;

export type LeadFormQuestionsGetError = Error;

export type MetricsReadyStateGetData = {
  query: {
    /**
     * Analytics reports request date (UTC). Format: YYYY-MM-DD
     */
    date: string;
  };
};

export type MetricsReadyStateGetResponse = BookClosedResponse;

export type MetricsReadyStateGetError = Error;

export type InterestTargetingOptionsGetData = {
  path: {
    /**
     * Unique identifier of an interest.
     */
    interest_id: string;
  };
};

export type InterestTargetingOptionsGetResponse = SingleInterestTargetingOptionResponse;

export type InterestTargetingOptionsGetError = Error;

export type TargetingOptionsGetData = {
  path: {
    /**
     * Public targeting type.
     */
    targeting_type:
      | 'APPTYPE'
      | 'GENDER'
      | 'LOCALE'
      | 'AGE_BUCKET'
      | 'LOCATION'
      | 'GEO'
      | 'INTEREST'
      | 'KEYWORD'
      | 'AUDIENCE_INCLUDE'
      | 'AUDIENCE_EXCLUDE';
  };
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Client ID.
     */
    client_id?: string;
    /**
     * Oauth signature
     */
    oauth_signature?: string;
    /**
     * Timestamp
     */
    timestamp?: string;
  };
};

export type TargetingOptionsGetResponse = TargetingOptionResponse;

export type TargetingOptionsGetError = Error;

export type SearchUserBoardsGetData = {
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
    /**
     * Search query. Can contain pin description keywords or comma-separated pin IDs.
     */
    query?: string;
  };
};

export type SearchUserBoardsGetResponse = Paginated & {
  /**
   * items
   */
  items?: unknown;
};

export type SearchUserBoardsGetError = Error;

export type SearchUserPinsListData = {
  query: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Search query. Can contain pin description keywords or comma-separated pin IDs.
     */
    query: string;
  };
};

export type SearchUserPinsListResponse = Paginated & {
  items?: Array<Pin>;
};

export type SearchUserPinsListError = Error;

export type SearchPartnerPinsData = {
  query: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Two letter country code (ISO 3166-1 alpha-2)
     */
    country_code: string;
    /**
     * Max search result size
     */
    limit?: number;
    /**
     * Search locale.
     */
    locale?: string;
    /**
     * Search term to look up pins.
     */
    term: string;
  };
};

export type SearchPartnerPinsResponse = Paginated & {
  items?: Array<SummaryPin>;
};

export type SearchPartnerPinsError = Error;

export type TermsRelatedListData = {
  query: {
    /**
     * List of input terms.
     */
    terms: Array<string>;
  };
};

export type TermsRelatedListResponse = RelatedTerms;

export type TermsRelatedListError = Error;

export type TermsSuggestedListData = {
  query: {
    /**
     * Max suggested terms to return.
     */
    limit?: number;
    /**
     * Input term.
     */
    term: string;
  };
};

export type TermsSuggestedListResponse = TermsSuggestedResponse;

export type TermsSuggestedListError = Error;

export type TrendingKeywordsListData = {
  path: {
    /**
     * The geographic region of interest. Only top trends within the specified region will be returned.<br />
     * The `region` parameter is formatted as ISO 3166-2 country codes delimited by `+`, corresponding to the following geographic areas:
     * - `US` - United States
     * - `CA` - Canada
     * - `DE` - Germany
     * - `FR` - France
     * - `ES` - Spain
     * - `IT` - Italy
     * - `DE+AT+CH` - Germanic countries
     * - `GB+IE` - Great Britain & Ireland
     * - `IT+ES+PT+GR+MT` - Southern Europe
     * - `PL+RO+HU+SK+CZ` - Eastern Europe
     * - `SE+DK+FI+NO` - Nordic countries
     * - `NL+BE+LU` - Benelux
     * - `AR` - Argentina
     * - `BR` - Brazil
     * - `CO` - Colombia
     * - `MX` - Mexico
     * - `MX+AR+CO+CL` - Hispanic LatAm
     * - `AU+NZ` - Australasia
     */
    region: TrendsSupportedRegion;
    /**
     * The methodology used to rank how trendy a keyword is.
     * - `growing` trends have high upward growth in search volume over the last quarter
     * - `monthly` trends have high search volume in the last month
     * - `yearly` trends have high search volume in the last year
     * - `seasonal` trends have high upward growth in search volume over the last month and exhibit a seasonal recurring pattern (typically annual)
     */
    trend_type: TrendType;
  };
  query?: {
    /**
     * If set, filters the results to trends among users in the specified age range(s).<br />
     * If unset, trends among all age groups will be returned.
     */
    ages?: AgeBucketList;
    /**
     * If set, filters the results to trends among users who identify with the specified gender(s).<br />
     * If unset, trends among all genders will be returned.<br />
     * The `unknown` group includes users with unspecified or customized gender profile settings.
     */
    genders?: GenderList;
    /**
     * If set, filters the results to top trends which include at least one of the specified keywords.<br />
     * If unset, no keyword filtering logic is applied.
     */
    include_keywords?: KeywordList;
    /**
     * If set, filters the results to trends associated with the specified interests.<br />
     * If unset, trends for all interests will be returned.<br />
     * The list of supported interests is:
     * - `animals` - Animals
     * - `architecture` - Architecture
     * - `art` - Art
     * - `beauty` - Beauty
     * - `childrens_fashion` - Children's Fashion
     * - `design` - Design
     * - `diy_and_crafts` - DIY & Crafts
     * - `education` - Education
     * - `electronics` - Electronics
     * - `entertainment` - Entertainment
     * - `event_planning` - Event Planning
     * - `finance` - Finance
     * - `food_and_drinks` - Food & Drink
     * - `gardening` - Gardening
     * - `health` - Health
     * - `home_decor` - Home Decor
     * - `mens_fashion` - Men's Fashion
     * - `parenting` - Parenting
     * - `quotes` - Quotes
     * - `sport` - Sports
     * - `travel` - Travel
     * - `vehicles` - Vehicles
     * - `wedding` - Wedding
     * - `womens_fashion` - Women's Fashion
     */
    interests?: L1InterestList;
    /**
     * The maximum number of trending keywords that will be returned. Keywords are returned in trend-ranked order, so a `limit` of 50 will return the top 50 trends.
     */
    limit?: number;
    /**
     * Governs how the resulting time series data will be normalized to a [0-100] scale.<br />
     * By default (`false`), the data will be normalized independently for each keyword.  The peak search volume observation in *each* keyword's time series will be represented by the value 100.  This is ideal for analyzing when an individual keyword is expected to peak in interest.<br />
     * If set to `true`, the data will be normalized as a group.  The peak search volume observation across *all* keywords in the response will be represented by the value 100, and all other values scaled accordingly.  Use this option when you wish to compare relative search volume between multiple keywords.
     */
    normalize_against_group?: boolean;
  };
};

export type TrendingKeywordsListResponse = TrendingKeywordsResponse;

export type TrendingKeywordsListError = Error;

export type UserAccountGetData = {
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type UserAccountGetResponse = Account;

export type UserAccountGetError = Error;

export type UserAccountAnalyticsData = {
  query: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Apps or devices to get data for, default is all.
     */
    app_types?: 'ALL' | 'MOBILE' | 'TABLET' | 'WEB';
    /**
     * Filter to paid or organic data. Default is all.
     */
    content_type?: 'ALL' | 'PAID' | 'ORGANIC';
    /**
     * Metric report end date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days past start_date.
     */
    end_date: string;
    /**
     * Filter on Pins that match your claimed domain.
     */
    from_claimed_content?: 'OTHER' | 'CLAIMED' | 'BOTH';
    /**
     * Metric types to get data for, default is all.
     */
    metric_types?: Array<
      | 'ENGAGEMENT'
      | 'ENGAGEMENT_RATE'
      | 'IMPRESSION'
      | 'OUTBOUND_CLICK'
      | 'OUTBOUND_CLICK_RATE'
      | 'PIN_CLICK'
      | 'PIN_CLICK_RATE'
      | 'SAVE'
      | 'SAVE_RATE'
    >;
    /**
     * Pin formats to get data for, default is all.
     */
    pin_format?:
      | 'ALL'
      | 'ORGANIC_IMAGE'
      | 'ORGANIC_PRODUCT'
      | 'ORGANIC_VIDEO'
      | 'ADS_STANDARD'
      | 'ADS_PRODUCT'
      | 'ADS_VIDEO'
      | 'ADS_IDEA';
    /**
     * Filter to activity from Pins created and saved by your, or activity created and saved by others from your claimed accounts
     */
    source?: 'ALL' | 'YOUR_PINS' | 'OTHER_PINS';
    /**
     * How to split the data into groups. Not including this param means data won't be split.
     */
    split_field?: 'NO_SPLIT' | 'APP_TYPE' | 'OWNED_CONTENT' | 'SOURCE' | 'PIN_FORMAT';
    /**
     * Metric report start date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days back from today.
     */
    start_date: string;
  };
};

export type UserAccountAnalyticsResponse = AnalyticsResponse;

export type UserAccountAnalyticsError = Error;

export type UserAccountAnalyticsTopPinsData = {
  query: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Apps or devices to get data for, default is all.
     */
    app_types?: 'ALL' | 'MOBILE' | 'TABLET' | 'WEB';
    /**
     * Filter to paid or organic data. Default is all.
     */
    content_type?: 'ALL' | 'PAID' | 'ORGANIC';
    /**
     * Get metrics for pins created in the last "n" days.
     */
    created_in_last_n_days?: 30;
    /**
     * Metric report end date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days past start_date.
     */
    end_date: string;
    /**
     * Filter on Pins that match your claimed domain.
     */
    from_claimed_content?: 'OTHER' | 'CLAIMED' | 'BOTH';
    /**
     * Metric types to get data for, default is all.
     */
    metric_types?: Array<
      | 'ENGAGEMENT'
      | 'ENGAGEMENT_RATE'
      | 'IMPRESSION'
      | 'OUTBOUND_CLICK'
      | 'OUTBOUND_CLICK_RATE'
      | 'PIN_CLICK'
      | 'PIN_CLICK_RATE'
      | 'SAVE'
      | 'SAVE_RATE'
    >;
    /**
     * Number of pins to include, default is 10. Max is 50.
     */
    num_of_pins?: number;
    /**
     * Pin formats to get data for, default is all.
     */
    pin_format?:
      | 'ALL'
      | 'ORGANIC_IMAGE'
      | 'ORGANIC_PRODUCT'
      | 'ORGANIC_VIDEO'
      | 'ADS_STANDARD'
      | 'ADS_PRODUCT'
      | 'ADS_VIDEO'
      | 'ADS_IDEA';
    /**
     * Specify sorting order for metrics
     */
    sort_by: 'ENGAGEMENT' | 'IMPRESSION' | 'OUTBOUND_CLICK' | 'PIN_CLICK' | 'SAVE';
    /**
     * Filter to activity from Pins created and saved by your, or activity created and saved by others from your claimed accounts
     */
    source?: 'ALL' | 'YOUR_PINS' | 'OTHER_PINS';
    /**
     * Metric report start date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days back from today.
     */
    start_date: string;
  };
};

export type UserAccountAnalyticsTopPinsResponse = TopPinsAnalyticsResponse;

export type UserAccountAnalyticsTopPinsError = Error;

export type UserAccountAnalyticsTopVideoPinsData = {
  query: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Apps or devices to get data for, default is all.
     */
    app_types?: 'ALL' | 'MOBILE' | 'TABLET' | 'WEB';
    /**
     * Filter to paid or organic data. Default is all.
     */
    content_type?: 'ALL' | 'PAID' | 'ORGANIC';
    /**
     * Get metrics for pins created in the last "n" days.
     */
    created_in_last_n_days?: 30;
    /**
     * Metric report end date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days past start_date.
     */
    end_date: string;
    /**
     * Filter on Pins that match your claimed domain.
     */
    from_claimed_content?: 'OTHER' | 'CLAIMED' | 'BOTH';
    /**
     * Metric types to get video data for, default is all.
     */
    metric_types?: Array<
      | 'IMPRESSION'
      | 'SAVE'
      | 'VIDEO_MRC_VIEW'
      | 'VIDEO_AVG_WATCH_TIME'
      | 'VIDEO_V50_WATCH_TIME'
      | 'QUARTILE_95_PERCENT_VIEW'
      | 'VIDEO_10S_VIEW'
      | 'VIDEO_START'
      | 'OUTBOUND_CLICK'
    >;
    /**
     * Number of pins to include, default is 10. Max is 50.
     */
    num_of_pins?: number;
    /**
     * Pin formats to get data for, default is all.
     */
    pin_format?:
      | 'ALL'
      | 'ORGANIC_IMAGE'
      | 'ORGANIC_PRODUCT'
      | 'ORGANIC_VIDEO'
      | 'ADS_STANDARD'
      | 'ADS_PRODUCT'
      | 'ADS_VIDEO'
      | 'ADS_IDEA';
    /**
     * Specify sorting order for video metrics
     */
    sort_by:
      | 'IMPRESSION'
      | 'SAVE'
      | 'OUTBOUND_CLICK'
      | 'VIDEO_MRC_VIEW'
      | 'VIDEO_AVG_WATCH_TIME'
      | 'VIDEO_V50_WATCH_TIME'
      | 'QUARTILE_95_PERCENT_VIEW'
      | 'VIDEO_10S_VIEW'
      | 'VIDEO_START';
    /**
     * Filter to activity from Pins created and saved by your, or activity created and saved by others from your claimed accounts
     */
    source?: 'ALL' | 'YOUR_PINS' | 'OTHER_PINS';
    /**
     * Metric report start date (UTC). Format: YYYY-MM-DD. Cannot be more than 90 days back from today.
     */
    start_date: string;
  };
};

export type UserAccountAnalyticsTopVideoPinsResponse = TopVideoPinsAnalyticsResponse;

export type UserAccountAnalyticsTopVideoPinsError = Error;

export type LinkedBusinessAccountsGetResponse = Array<LinkedBusiness>;

export type LinkedBusinessAccountsGetError = Error;

export type FollowersListData = {
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type FollowersListResponse = Paginated & {
  items?: Array<UserSummary>;
};

export type FollowersListError = Error;

export type UserFollowingGetData = {
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Whether or not to include implicit user follows, which means followees with board follows. When explicit_following is True, it means we only want explicit user follows.
     */
    explicit_following?: boolean;
    /**
     * Thrift param specifying what type of followees will be kept. Default to include all followees.
     */
    feed_type?: UserFollowingFeedType;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type UserFollowingGetResponse = Paginated & {
  /**
   * Users
   */
  items?: unknown;
};

export type UserFollowingGetError = Error;

export type BoardsUserFollowsListData = {
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Whether or not to include implicit user follows, which means followees with board follows. When explicit_following is True, it means we only want explicit user follows.
     */
    explicit_following?: boolean;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type BoardsUserFollowsListResponse = Paginated & {
  items?: Array<Board>;
};

export type BoardsUserFollowsListError = Error;

export type FollowUserUpdateData = {
  /**
   * Follow a user.
   */
  body: FollowUserRequest;
  path: {
    /**
     * A valid username
     */
    username: string;
  };
};

export type FollowUserUpdateResponse = UserSummary;

export type FollowUserUpdateError = Error;

export type VerifyWebsiteUpdateData = {
  /**
   * Verify a website.
   */
  body: UserWebsiteVerifyRequest;
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type VerifyWebsiteUpdateResponse = UserWebsiteSummary;

export type VerifyWebsiteUpdateError = Error;

export type UserWebsitesGetData = {
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type UserWebsitesGetResponse = Paginated & {
  items?: Array<UserWebsiteSummary>;
};

export type UserWebsitesGetError = Error;

export type UnverifyWebsiteDeleteData = {
  query: {
    /**
     * Website with path or domain only
     */
    website: string;
  };
};

export type UnverifyWebsiteDeleteResponse = any;

export type UnverifyWebsiteDeleteError = Error;

export type WebsiteVerificationGetData = {
  query?: {
    /**
     * Unique identifier of an ad account.
     */
    ad_account_id?: string;
  };
};

export type WebsiteVerificationGetResponse = UserWebsiteVerificationCode;

export type WebsiteVerificationGetError = Error;

export type UserAccountFollowedInterestsData = {
  path: {
    /**
     * A valid username
     */
    username: string;
  };
  query?: {
    /**
     * Cursor used to fetch the next page of items
     */
    bookmark?: string;
    /**
     * Maximum number of items to include in a single page of the response. See documentation on <a href='/docs/reference/pagination/'>Pagination</a> for more information.
     */
    page_size?: number;
  };
};

export type UserAccountFollowedInterestsResponse = Paginated & {
  items?: Array<Interest>;
};

export type UserAccountFollowedInterestsError = Error;
