// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options, urlSearchParamsBodySerializer } from '@hey-api/client-fetch';

import type {
  AdAccountsListData,
  AdAccountsListError,
  AdAccountsListResponse,
  AdAccountsCreateData,
  AdAccountsCreateError,
  AdAccountsCreateResponse,
  AdAccountsGetData,
  AdAccountsGetError,
  AdAccountsGetResponse,
  AdGroupsListData,
  AdGroupsListError,
  AdGroupsListResponse,
  AdGroupsCreateData,
  AdGroupsCreateError,
  AdGroupsCreateResponse,
  AdGroupsUpdateData,
  AdGroupsUpdateError,
  AdGroupsUpdateResponse,
  AdGroupsAnalyticsData,
  AdGroupsAnalyticsError,
  AdGroupsAnalyticsResponse2,
  AdGroupsTargetingAnalyticsGetData,
  AdGroupsTargetingAnalyticsGetError,
  AdGroupsTargetingAnalyticsGetResponse,
  AdGroupsAudienceSizingData,
  AdGroupsAudienceSizingError,
  AdGroupsAudienceSizingResponse,
  AdGroupsGetData,
  AdGroupsGetError,
  AdGroupsGetResponse,
  AdPreviewsCreateData,
  AdPreviewsCreateError,
  AdPreviewsCreateResponse,
  AdsListData,
  AdsListError,
  AdsListResponse,
  AdsCreateData,
  AdsCreateError,
  AdsCreateResponse,
  AdsUpdateData,
  AdsUpdateError,
  AdsUpdateResponse,
  AdsAnalyticsData,
  AdsAnalyticsError,
  AdsAnalyticsResponse2,
  AdsCreditsDiscountsGetData,
  AdsCreditsDiscountsGetError,
  AdsCreditsDiscountsGetResponse,
  AdsCreditRedeemData,
  AdsCreditRedeemError,
  AdsCreditRedeemResponse2,
  AdTargetingAnalyticsGetData,
  AdTargetingAnalyticsGetError,
  AdTargetingAnalyticsGetResponse,
  AdsGetData,
  AdsGetError,
  AdsGetResponse,
  AdAccountAnalyticsData,
  AdAccountAnalyticsError,
  AdAccountAnalyticsResponse2,
  AudienceInsightsGetData,
  AudienceInsightsGetError,
  AudienceInsightsGetResponse,
  AudiencesListData,
  AudiencesListError,
  AudiencesListResponse,
  AudiencesCreateData,
  AudiencesCreateError,
  AudiencesCreateResponse,
  AudiencesGetData,
  AudiencesGetError,
  AudiencesGetResponse,
  AudiencesUpdateData,
  AudiencesUpdateError,
  AudiencesUpdateResponse,
  AudiencesCreateCustomData,
  AudiencesCreateCustomError,
  AudiencesCreateCustomResponse,
  AdAccountsAudiencesSharedAccountsListData,
  AdAccountsAudiencesSharedAccountsListError,
  AdAccountsAudiencesSharedAccountsListResponse,
  UpdateAdAccountToAdAccountSharedAudienceData,
  UpdateAdAccountToAdAccountSharedAudienceError,
  UpdateAdAccountToAdAccountSharedAudienceResponse,
  UpdateAdAccountToBusinessSharedAudienceData,
  UpdateAdAccountToBusinessSharedAudienceError,
  UpdateAdAccountToBusinessSharedAudienceResponse,
  AdGroupsBidFloorGetData,
  AdGroupsBidFloorGetError,
  AdGroupsBidFloorGetResponse,
  BillingProfilesGetData,
  BillingProfilesGetError,
  BillingProfilesGetResponse,
  BulkDownloadCreateData,
  BulkDownloadCreateError,
  BulkDownloadCreateResponse,
  BulkUpsertCreateData,
  BulkUpsertCreateError,
  BulkUpsertCreateResponse,
  BulkRequestGetData,
  BulkRequestGetError,
  BulkRequestGetResponse,
  CampaignsListData,
  CampaignsListError,
  CampaignsListResponse,
  CampaignsCreateData,
  CampaignsCreateError,
  CampaignsCreateResponse,
  CampaignsUpdateData,
  CampaignsUpdateError,
  CampaignsUpdateResponse,
  CampaignsAnalyticsData,
  CampaignsAnalyticsError,
  CampaignsAnalyticsResponse2,
  CampaignTargetingAnalyticsGetData,
  CampaignTargetingAnalyticsGetError,
  CampaignTargetingAnalyticsGetResponse,
  CampaignsGetData,
  CampaignsGetError,
  CampaignsGetResponse,
  ConversionTagsListData,
  ConversionTagsListError,
  ConversionTagsListResponse,
  ConversionTagsCreateData,
  ConversionTagsCreateError,
  ConversionTagsCreateResponse,
  OcpmEligibleConversionTagsGetData,
  OcpmEligibleConversionTagsGetError,
  OcpmEligibleConversionTagsGetResponse,
  PageVisitConversionTagsGetData,
  PageVisitConversionTagsGetError,
  PageVisitConversionTagsGetResponse,
  ConversionTagsGetData,
  ConversionTagsGetError,
  ConversionTagsGetResponse,
  CustomerListsCreateData,
  CustomerListsCreateError,
  CustomerListsCreateResponse,
  CustomerListsListData,
  CustomerListsListError,
  CustomerListsListResponse,
  CustomerListsGetData,
  CustomerListsGetError,
  CustomerListsGetResponse,
  CustomerListsUpdateData,
  CustomerListsUpdateError,
  CustomerListsUpdateResponse,
  EventsCreateData,
  EventsCreateError,
  EventsCreateResponse,
  AudienceInsightsScopeAndTypeGetData,
  AudienceInsightsScopeAndTypeGetError,
  AudienceInsightsScopeAndTypeGetResponse,
  KeywordsGetData,
  KeywordsGetError,
  KeywordsGetResponse,
  KeywordsCreateData,
  KeywordsCreateError,
  KeywordsCreateResponse,
  KeywordsUpdateData,
  KeywordsUpdateError,
  KeywordsUpdateResponse,
  CountryKeywordsMetricsGetData,
  CountryKeywordsMetricsGetError,
  CountryKeywordsMetricsGetResponse,
  LeadFormsListData,
  LeadFormsListError,
  LeadFormsListResponse,
  LeadFormsCreateData,
  LeadFormsCreateError,
  LeadFormsCreateResponse,
  LeadFormsUpdateData,
  LeadFormsUpdateError,
  LeadFormsUpdateResponse,
  LeadFormGetData,
  LeadFormGetError,
  LeadFormGetResponse,
  LeadFormTestCreateData,
  LeadFormTestCreateError,
  LeadFormTestCreateResponse,
  AdAccountsSubscriptionsPostData,
  AdAccountsSubscriptionsPostError,
  AdAccountsSubscriptionsPostResponse,
  AdAccountsSubscriptionsGetListData,
  AdAccountsSubscriptionsGetListError,
  AdAccountsSubscriptionsGetListResponse,
  AdAccountsSubscriptionsGetByIdData,
  AdAccountsSubscriptionsGetByIdError,
  AdAccountsSubscriptionsGetByIdResponse,
  AdAccountsSubscriptionsDelByIdData,
  AdAccountsSubscriptionsDelByIdError,
  AdAccountsSubscriptionsDelByIdResponse,
  LeadsExportCreateData,
  LeadsExportCreateError,
  LeadsExportCreateResponse2,
  LeadsExportGetData,
  LeadsExportGetError,
  LeadsExportGetResponse,
  AnalyticsGetMmmReportData,
  AnalyticsGetMmmReportError,
  AnalyticsGetMmmReportResponse,
  AnalyticsCreateMmmReportData,
  AnalyticsCreateMmmReportError,
  AnalyticsCreateMmmReportResponse,
  OrderLinesListData,
  OrderLinesListError,
  OrderLinesListResponse,
  OrderLinesGetData,
  OrderLinesGetError,
  OrderLinesGetResponse,
  ProductGroupPromotionsCreateData,
  ProductGroupPromotionsCreateError,
  ProductGroupPromotionsCreateResponse,
  ProductGroupPromotionsUpdateData,
  ProductGroupPromotionsUpdateError,
  ProductGroupPromotionsUpdateResponse,
  ProductGroupPromotionsListData,
  ProductGroupPromotionsListError,
  ProductGroupPromotionsListResponse,
  ProductGroupPromotionsGetData,
  ProductGroupPromotionsGetError,
  ProductGroupPromotionsGetResponse,
  ProductGroupsAnalyticsData,
  ProductGroupsAnalyticsError,
  ProductGroupsAnalyticsResponse,
  AnalyticsGetReportData,
  AnalyticsGetReportError,
  AnalyticsGetReportResponse,
  AnalyticsCreateReportData,
  AnalyticsCreateReportError,
  AnalyticsCreateReportResponse,
  SandboxDeleteData,
  SandboxDeleteError,
  SandboxDeleteResponse,
  SsioAccountsGetData,
  SsioAccountsGetError,
  SsioAccountsGetResponse,
  SsioInsertionOrderCreateData,
  SsioInsertionOrderCreateError,
  SsioInsertionOrderCreateResponse,
  SsioInsertionOrderEditData,
  SsioInsertionOrderEditError,
  SsioInsertionOrderEditResponse,
  SsioInsertionOrdersStatusGetByAdAccountData,
  SsioInsertionOrdersStatusGetByAdAccountError,
  SsioInsertionOrdersStatusGetByAdAccountResponse,
  SsioInsertionOrdersStatusGetByPinOrderIdData,
  SsioInsertionOrdersStatusGetByPinOrderIdError,
  SsioInsertionOrdersStatusGetByPinOrderIdResponse,
  SsioOrderLinesGetByAdAccountData,
  SsioOrderLinesGetByAdAccountError,
  SsioOrderLinesGetByAdAccountResponse,
  AdAccountTargetingAnalyticsGetData,
  AdAccountTargetingAnalyticsGetError,
  AdAccountTargetingAnalyticsGetResponse,
  TargetingTemplateListData,
  TargetingTemplateListError,
  TargetingTemplateListResponse,
  TargetingTemplateCreateData,
  TargetingTemplateCreateError,
  TargetingTemplateCreateResponse,
  TargetingTemplateUpdateData,
  TargetingTemplateUpdateError,
  TargetingTemplateUpdateResponse,
  TemplatesListData,
  TemplatesListError,
  TemplatesListResponse,
  AnalyticsCreateTemplateReportData,
  AnalyticsCreateTemplateReportError,
  AnalyticsCreateTemplateReportResponse,
  TermsOfServiceGetData,
  TermsOfServiceGetError,
  TermsOfServiceGetResponse,
  AdvancedAuctionItemsGetPostData,
  AdvancedAuctionItemsGetPostError,
  AdvancedAuctionItemsGetPostResponse,
  AdvancedAuctionItemsSubmitPostData,
  AdvancedAuctionItemsSubmitPostError,
  AdvancedAuctionItemsSubmitPostResponse,
  BoardsListData,
  BoardsListError,
  BoardsListResponse,
  BoardsCreateData,
  BoardsCreateError,
  BoardsCreateResponse,
  BoardsGetData,
  BoardsGetError,
  BoardsGetResponse,
  BoardsUpdateData,
  BoardsUpdateError,
  BoardsUpdateResponse,
  BoardsDeleteData,
  BoardsDeleteError,
  BoardsDeleteResponse,
  BoardsListPinsData,
  BoardsListPinsError,
  BoardsListPinsResponse,
  BoardSectionsListData,
  BoardSectionsListError,
  BoardSectionsListResponse,
  BoardSectionsCreateData,
  BoardSectionsCreateError,
  BoardSectionsCreateResponse,
  BoardSectionsUpdateData,
  BoardSectionsUpdateError,
  BoardSectionsUpdateResponse,
  BoardSectionsDeleteData,
  BoardSectionsDeleteError,
  BoardSectionsDeleteResponse,
  BoardSectionsListPinsData,
  BoardSectionsListPinsError,
  BoardSectionsListPinsResponse,
  GetBusinessEmployersData,
  GetBusinessEmployersError,
  GetBusinessEmployersResponse,
  RespondBusinessAccessInvitesData,
  RespondBusinessAccessInvitesError,
  RespondBusinessAccessInvitesResponse,
  BusinessAssetMembersGetData,
  BusinessAssetMembersGetError,
  BusinessAssetMembersGetResponse,
  BusinessAssetPartnersGetData,
  BusinessAssetPartnersGetError,
  BusinessAssetPartnersGetResponse,
  CreateAssetInvitesData,
  CreateAssetInvitesError,
  CreateAssetInvitesResponse,
  AssetAccessRequestsCreateData,
  AssetAccessRequestsCreateError,
  AssetAccessRequestsCreateResponse,
  GetBusinessMembersData,
  GetBusinessMembersError,
  GetBusinessMembersResponse,
  UpdateBusinessMembershipsData,
  UpdateBusinessMembershipsError,
  UpdateBusinessMembershipsResponse,
  DeleteBusinessMembershipData,
  DeleteBusinessMembershipError,
  DeleteBusinessMembershipResponse,
  BusinessAssetsGetData,
  BusinessAssetsGetError,
  BusinessAssetsGetResponse,
  BusinessMemberAssetsGetData,
  BusinessMemberAssetsGetError,
  BusinessMemberAssetsGetResponse,
  BusinessMembersAssetAccessUpdateData,
  BusinessMembersAssetAccessUpdateError,
  BusinessMembersAssetAccessUpdateResponse,
  BusinessMembersAssetAccessDeleteData,
  BusinessMembersAssetAccessDeleteError,
  BusinessMembersAssetAccessDeleteResponse,
  GetInvitesData,
  GetInvitesError,
  GetInvitesResponse,
  CreateMembershipOrPartnershipInvitesData,
  CreateMembershipOrPartnershipInvitesError,
  CreateMembershipOrPartnershipInvitesResponse,
  CancelInvitesOrRequestsData,
  CancelInvitesOrRequestsError,
  CancelInvitesOrRequestsResponse,
  UpdatePartnerAssetAccessHandlerImplData,
  UpdatePartnerAssetAccessHandlerImplError,
  UpdatePartnerAssetAccessHandlerImplResponse,
  DeletePartnerAssetAccessHandlerImplData,
  DeletePartnerAssetAccessHandlerImplError,
  DeletePartnerAssetAccessHandlerImplResponse,
  BusinessPartnerAssetAccessGetData,
  BusinessPartnerAssetAccessGetError,
  BusinessPartnerAssetAccessGetResponse,
  GetBusinessPartnersData,
  GetBusinessPartnersError,
  GetBusinessPartnersResponse,
  DeleteBusinessPartnersData,
  DeleteBusinessPartnersError,
  DeleteBusinessPartnersResponse,
  SharedAudiencesForBusinessListData,
  SharedAudiencesForBusinessListError,
  SharedAudiencesForBusinessListResponse,
  BusinessAccountAudiencesSharedAccountsListData,
  BusinessAccountAudiencesSharedAccountsListError,
  BusinessAccountAudiencesSharedAccountsListResponse,
  UpdateBusinessToAdAccountSharedAudienceData,
  UpdateBusinessToAdAccountSharedAudienceError,
  UpdateBusinessToAdAccountSharedAudienceResponse,
  UpdateBusinessToBusinessSharedAudienceData,
  UpdateBusinessToBusinessSharedAudienceError,
  UpdateBusinessToBusinessSharedAudienceResponse,
  AssetGroupCreateData,
  AssetGroupCreateError,
  AssetGroupCreateResponse,
  AssetGroupUpdateData,
  AssetGroupUpdateError,
  AssetGroupUpdateResponse,
  AssetGroupDeleteData,
  AssetGroupDeleteError,
  AssetGroupDeleteResponse,
  CatalogsListData,
  CatalogsListError,
  CatalogsListResponse,
  CatalogsCreateData,
  CatalogsCreateError,
  CatalogsCreateResponse,
  FeedsListData,
  FeedsListError,
  FeedsListResponse,
  FeedsCreateData,
  FeedsCreateError,
  FeedsCreateResponse,
  FeedsGetData,
  FeedsGetError,
  FeedsGetResponse,
  FeedsUpdateData,
  FeedsUpdateError,
  FeedsUpdateResponse,
  FeedsDeleteData,
  FeedsDeleteError,
  FeedsDeleteResponse,
  FeedsIngestData,
  FeedsIngestError,
  FeedsIngestResponse,
  FeedProcessingResultsListData,
  FeedProcessingResultsListError,
  FeedProcessingResultsListResponse,
  ItemsIssuesListData,
  ItemsIssuesListError,
  ItemsIssuesListResponse,
  ItemsGetData,
  ItemsGetError,
  ItemsGetResponse,
  ItemsPostData,
  ItemsPostError,
  ItemsPostResponse,
  ItemsBatchPostData,
  ItemsBatchPostError,
  ItemsBatchPostResponse,
  ItemsBatchGetData,
  ItemsBatchGetError,
  ItemsBatchGetResponse,
  CatalogsProductGroupsDeleteManyData,
  CatalogsProductGroupsDeleteManyError,
  CatalogsProductGroupsDeleteManyResponse,
  CatalogsProductGroupsCreateManyData,
  CatalogsProductGroupsCreateManyError,
  CatalogsProductGroupsCreateManyResponse,
  CatalogsProductGroupsListData,
  CatalogsProductGroupsListError,
  CatalogsProductGroupsListResponse,
  CatalogsProductGroupsCreateData,
  CatalogsProductGroupsCreateError,
  CatalogsProductGroupsCreateResponse,
  CatalogsProductGroupsGetData,
  CatalogsProductGroupsGetError,
  CatalogsProductGroupsGetResponse,
  CatalogsProductGroupsDeleteData,
  CatalogsProductGroupsDeleteError,
  CatalogsProductGroupsDeleteResponse,
  CatalogsProductGroupsUpdateData,
  CatalogsProductGroupsUpdateError,
  CatalogsProductGroupsUpdateResponse,
  CatalogsProductGroupsProductCountsGetData,
  CatalogsProductGroupsProductCountsGetError,
  CatalogsProductGroupsProductCountsGetResponse,
  CatalogsProductGroupPinsListData,
  CatalogsProductGroupPinsListError,
  CatalogsProductGroupPinsListResponse,
  ProductsByProductGroupFilterListData,
  ProductsByProductGroupFilterListError,
  ProductsByProductGroupFilterListResponse,
  ReportsCreateData,
  ReportsCreateError,
  ReportsCreateResponse,
  ReportsGetData,
  ReportsGetError,
  ReportsGetResponse,
  ReportsStatsData,
  ReportsStatsError,
  ReportsStatsResponse,
  IntegrationsCommercePostData,
  IntegrationsCommercePostError,
  IntegrationsCommercePostResponse,
  IntegrationsCommerceGetData,
  IntegrationsCommerceGetError,
  IntegrationsCommerceGetResponse,
  IntegrationsCommercePatchData,
  IntegrationsCommercePatchError,
  IntegrationsCommercePatchResponse,
  IntegrationsCommerceDelData,
  IntegrationsCommerceDelError,
  IntegrationsCommerceDelResponse,
  IntegrationsLogsPostData,
  IntegrationsLogsPostError,
  IntegrationsLogsPostResponse,
  IntegrationsGetListData,
  IntegrationsGetListError,
  IntegrationsGetListResponse,
  IntegrationsGetByIdData,
  IntegrationsGetByIdError,
  IntegrationsGetByIdResponse,
  MediaListData,
  MediaListError,
  MediaListResponse,
  MediaCreateData,
  MediaCreateError,
  MediaCreateResponse,
  MediaGetData,
  MediaGetError,
  MediaGetResponse,
  OauthTokenData,
  OauthTokenError,
  OauthTokenResponse,
  PinsListData,
  PinsListError,
  PinsListResponse,
  PinsCreateData,
  PinsCreateError,
  PinsCreateResponse,
  PinsGetData,
  PinsGetError,
  PinsGetResponse,
  PinsDeleteData,
  PinsDeleteError,
  PinsDeleteResponse,
  PinsUpdateData,
  PinsUpdateError,
  PinsUpdateResponse,
  PinsAnalyticsData,
  PinsAnalyticsError,
  PinsAnalyticsResponse,
  MultiPinsAnalyticsData,
  MultiPinsAnalyticsError,
  MultiPinsAnalyticsResponse,
  PinsSaveData,
  PinsSaveError,
  PinsSaveResponse,
  AdAccountCountriesGetError,
  AdAccountCountriesGetResponse,
  DeliveryMetricsGetData,
  DeliveryMetricsGetError,
  DeliveryMetricsGetResponse,
  LeadFormQuestionsGetError,
  LeadFormQuestionsGetResponse,
  MetricsReadyStateGetData,
  MetricsReadyStateGetError,
  MetricsReadyStateGetResponse,
  InterestTargetingOptionsGetData,
  InterestTargetingOptionsGetError,
  InterestTargetingOptionsGetResponse,
  TargetingOptionsGetData,
  TargetingOptionsGetError,
  TargetingOptionsGetResponse,
  SearchUserBoardsGetData,
  SearchUserBoardsGetError,
  SearchUserBoardsGetResponse,
  SearchUserPinsListData,
  SearchUserPinsListError,
  SearchUserPinsListResponse,
  SearchPartnerPinsData,
  SearchPartnerPinsError,
  SearchPartnerPinsResponse,
  TermsRelatedListData,
  TermsRelatedListError,
  TermsRelatedListResponse,
  TermsSuggestedListData,
  TermsSuggestedListError,
  TermsSuggestedListResponse,
  TrendingKeywordsListData,
  TrendingKeywordsListError,
  TrendingKeywordsListResponse,
  UserAccountGetData,
  UserAccountGetError,
  UserAccountGetResponse,
  UserAccountAnalyticsData,
  UserAccountAnalyticsError,
  UserAccountAnalyticsResponse,
  UserAccountAnalyticsTopPinsData,
  UserAccountAnalyticsTopPinsError,
  UserAccountAnalyticsTopPinsResponse,
  UserAccountAnalyticsTopVideoPinsData,
  UserAccountAnalyticsTopVideoPinsError,
  UserAccountAnalyticsTopVideoPinsResponse,
  LinkedBusinessAccountsGetError,
  LinkedBusinessAccountsGetResponse,
  FollowersListData,
  FollowersListError,
  FollowersListResponse,
  UserFollowingGetData,
  UserFollowingGetError,
  UserFollowingGetResponse,
  BoardsUserFollowsListData,
  BoardsUserFollowsListError,
  BoardsUserFollowsListResponse,
  FollowUserUpdateData,
  FollowUserUpdateError,
  FollowUserUpdateResponse,
  VerifyWebsiteUpdateData,
  VerifyWebsiteUpdateError,
  VerifyWebsiteUpdateResponse,
  UserWebsitesGetData,
  UserWebsitesGetError,
  UserWebsitesGetResponse,
  UnverifyWebsiteDeleteData,
  UnverifyWebsiteDeleteError,
  UnverifyWebsiteDeleteResponse,
  WebsiteVerificationGetData,
  WebsiteVerificationGetError,
  WebsiteVerificationGetResponse,
  UserAccountFollowedInterestsData,
  UserAccountFollowedInterestsError,
  UserAccountFollowedInterestsResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * List ad accounts
 * Get a list of the ad_accounts that the "operation user_account" has access to.
 * - This includes ad_accounts they own and ad_accounts that are owned by others who have granted them <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>.
 */
export const adAccountsList = <ThrowOnError extends boolean = false>(
  options?: Options<AdAccountsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AdAccountsListResponse, AdAccountsListError, ThrowOnError>({
    ...options,
    url: '/ad_accounts',
  });
};

/**
 * Create ad account
 * Create a new ad account. Different ad accounts can support different currencies, payment methods, etc.
 * An ad account is needed to create campaigns, ad groups, and ads; other accounts (your employees or partners) can be assigned business access and appropriate roles to access an ad account. <p/>
 * You can set up up to 50 ad accounts per user. (The user must have a business account to create an ad account.) <p/>
 * For more, see <a class="reference external" href="https://help.pinterest.com/en/business/article/create-an-advertiser-account">Create an advertiser account</a>.
 */
export const adAccountsCreate = <ThrowOnError extends boolean = false>(
  options: Options<AdAccountsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AdAccountsCreateResponse, AdAccountsCreateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts',
  });
};

/**
 * Get ad account
 * Get an ad account
 */
export const adAccountsGet = <ThrowOnError extends boolean = false>(
  options: Options<AdAccountsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AdAccountsGetResponse, AdAccountsGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}',
  });
};

/**
 * List ad groups
 * List ad groups based on provided campaign IDs or ad group IDs.(campaign_ids or ad_group_ids). <p/>
 * <strong>Note:</strong><p/>
 * Provide only campaign_id or ad_group_id. Do not provide both.
 */
export const adGroupsList = <ThrowOnError extends boolean = false>(
  options: Options<AdGroupsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AdGroupsListResponse, AdGroupsListError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ad_groups',
  });
};

/**
 * Create ad groups
 * Create multiple new ad groups. All ads in a given ad group will have the same budget, bid, run dates, targeting, and placement (search, browse, other). For more information, <a href="https://help.pinterest.com/en/business/article/campaign-structure" target="_blank"> click here</a>.</p>
 * <strong>Note:</strong>
 * - 'bid_in_micro_currency' and 'budget_in_micro_currency' should be expressed in microcurrency amounts based on the currency field set in the advertiser's profile.<p/>
 * <p>Microcurrency is used to track very small transactions, based on the currency set in the advertiser’s profile.</p>
 * <p>A microcurrency unit is 10^(-6) of the standard unit of currency selected in the advertiser’s profile.</p>
 * <p><strong>Equivalency equations</strong>, using dollars as an example currency:</p>
 * <ul>
 * <li>$1 = 1,000,000 microdollars</li>
 * <li>1 microdollar = $0.000001 </li>
 * </ul>
 * <p><strong>To convert between currency and microcurrency</strong>, using dollars as an example currency:</p>
 * <ul>
 * <li>To convert dollars to microdollars, mutiply dollars by 1,000,000</li>
 * <li>To convert microdollars to dollars, divide microdollars by 1,000,000</li>
 * </ul>
 * - Ad groups belong to ad campaigns. Some types of campaigns (e.g. budget optimization) have limits on the number of ad groups they can hold. If you exceed those limits, you will get an error message.
 * - Start and end time cannot be set for ad groups that belong to CBO campaigns. Currently, campaigns with the following objective types: TRAFFIC, AWARENESS, WEB_CONVERSIONS, and CATALOG_SALES will default to CBO.
 */
export const adGroupsCreate = <ThrowOnError extends boolean = false>(
  options: Options<AdGroupsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AdGroupsCreateResponse, AdGroupsCreateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ad_groups',
  });
};

/**
 * Update ad groups
 * Update multiple existing ad groups.
 */
export const adGroupsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<AdGroupsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<AdGroupsUpdateResponse, AdGroupsUpdateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ad_groups',
  });
};

/**
 * Get ad group analytics
 * Get analytics for the specified ad groups in the specified <code>ad_account_id</code>, filtered by the specified options.
 * - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Analyst, Campaign Manager.
 * - If granularity is not HOUR, the furthest back you can are allowed to pull data is 90 days before the current date in UTC time and the max time range supported is 90 days.
 * - If granularity is HOUR, the furthest back you can are allowed to pull data is 8 days before the current date in UTC time and the max time range supported is 3 days.
 */
export const adGroupsAnalytics = <ThrowOnError extends boolean = false>(
  options: Options<AdGroupsAnalyticsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AdGroupsAnalyticsResponse2, AdGroupsAnalyticsError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ad_groups/analytics',
  });
};

/**
 * Get targeting analytics for ad groups
 * Get targeting analytics for one or more ad groups.
 * For the requested ad group(s) and metrics, the response will include the requested metric information
 * (e.g. SPEND_IN_DOLLAR) for the requested target type (e.g. "age_bucket") for applicable values (e.g. "45-49"). <p/>
 * - The token's user_account must either be the Owner of the specified ad account, or have one
 * of the necessary roles granted to them via
 * <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Analyst, Campaign Manager.
 * - If granularity is not HOUR, the furthest back you can are allowed to pull data is 90 days before the current date in UTC time and the max time range supported is 90 days.
 * - If granularity is HOUR, the furthest back you can are allowed to pull data is 8 days before the current date in UTC time and the max time range supported is 3 days.
 */
export const adGroupsTargetingAnalyticsGet = <ThrowOnError extends boolean = false>(
  options: Options<AdGroupsTargetingAnalyticsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdGroupsTargetingAnalyticsGetResponse,
    AdGroupsTargetingAnalyticsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ad_groups/targeting_analytics',
  });
};

/**
 * Get audience sizing
 * Get potential audience size for an ad group with given targeting criteria.
 * Potential audience size estimates the number of people you may be able to reach per month with your campaign.
 * It is based on historical advertising data and the targeting criteria you select.
 * It does not guarantee results or take into account factors such as bid, budget, schedule, seasonality or product experiments.
 */
export const adGroupsAudienceSizing = <ThrowOnError extends boolean = false>(
  options: Options<AdGroupsAudienceSizingData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AdGroupsAudienceSizingResponse, AdGroupsAudienceSizingError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ad_groups/audience_sizing',
  });
};

/**
 * Get ad group
 * Get a specific ad given the ad ID. If your pin is rejected, rejected_reasons will
 * contain additional information from the Ad Review process.
 * For more information about our policies and rejection reasons see the <a href="https://www.pinterest.com/_/_/policy/advertising-guidelines/" target="_blank">Pinterest advertising standards</a>.
 */
export const adGroupsGet = <ThrowOnError extends boolean = false>(options: Options<AdGroupsGetData, ThrowOnError>) => {
  return (options?.client ?? client).get<AdGroupsGetResponse, AdGroupsGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ad_groups/{ad_group_id}',
  });
};

/**
 * Create ad preview with pin or image
 * Create an ad preview given an ad account ID and either an existing organic pin ID or the URL for an image to be used to create the Pin and the ad. <p/>
 * If you are creating a preview from an existing Pin, that Pin must be promotable: that is, it must have a clickthrough link and meet other requirements. (See <a href="https://help.pinterest.com/en/business/article/promoted-pins-overview" target="_blank">Ads Overview</a>.) <p/>
 * You can view the returned preview URL on a webpage or iframe for 7 days, after which the URL expires. Collection ads are not currently supported ad preview.
 */
export const adPreviewsCreate = <ThrowOnError extends boolean = false>(
  options: Options<AdPreviewsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AdPreviewsCreateResponse, AdPreviewsCreateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ad_previews',
  });
};

/**
 * List ads
 * List ads that meet the filters provided:
 * - Listed campaign ids or ad group ids or ad ids
 * - Listed entity statuses <p/>
 * If no filter is provided, all ads in the ad account are returned. <p/>
 * <strong>Note:</strong><p/>
 * Provide only campaign_id or ad_group_id or ad_id. Do not provide more than one type. <p/>
 * Review status is provided for each ad; if review_status is REJECTED, the rejected_reasons field will contain additional information.
 * For more, see <a href="https://policy.pinterest.com/en/advertising-guidelines">Pinterest advertising standards</a>.
 */
export const adsList = <ThrowOnError extends boolean = false>(options: Options<AdsListData, ThrowOnError>) => {
  return (options?.client ?? client).get<AdsListResponse, AdsListError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ads',
  });
};

/**
 * Create ads
 * Create multiple new ads. Request must contain ad_group_id, creative_type, and the source Pin pin_id.
 */
export const adsCreate = <ThrowOnError extends boolean = false>(options: Options<AdsCreateData, ThrowOnError>) => {
  return (options?.client ?? client).post<AdsCreateResponse, AdsCreateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ads',
  });
};

/**
 * Update ads
 * Update multiple existing ads
 */
export const adsUpdate = <ThrowOnError extends boolean = false>(options: Options<AdsUpdateData, ThrowOnError>) => {
  return (options?.client ?? client).patch<AdsUpdateResponse, AdsUpdateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ads',
  });
};

/**
 * Get ad analytics
 * Get analytics for the specified ads in the specified <code>ad_account_id</code>, filtered by the specified options.
 * - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Analyst, Campaign Manager.
 * - The request must contain either ad_ids or both campaign_ids and pin_ids.
 * - If granularity is not HOUR, the furthest back you can are allowed to pull data is 90 days before the current date in UTC time and the max time range supported is 90 days.
 * - If granularity is HOUR, the furthest back you can are allowed to pull data is 8 days before the current date in UTC time and the max time range supported is 3 days.
 */
export const adsAnalytics = <ThrowOnError extends boolean = false>(
  options: Options<AdsAnalyticsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AdsAnalyticsResponse2, AdsAnalyticsError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ads/analytics',
  });
};

/**
 * Get ads credit discounts
 * Returns the list of discounts applied to the account.
 *
 * <strong>This endpoint might not be available to all apps. <a href='/docs/getting-started/beta-and-advanced-access/'>Learn more</a>.</strong>
 */
export const adsCreditsDiscountsGet = <ThrowOnError extends boolean = false>(
  options: Options<AdsCreditsDiscountsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AdsCreditsDiscountsGetResponse, AdsCreditsDiscountsGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ads_credit/discounts',
  });
};

/**
 * Redeem ad credits
 * Redeem ads credit on behalf of the ad account id and apply it towards billing.
 *
 * <strong>This endpoint might not be available to all apps. <a href='/docs/getting-started/beta-and-advanced-access/'>Learn more</a>.</strong>
 */
export const adsCreditRedeem = <ThrowOnError extends boolean = false>(
  options: Options<AdsCreditRedeemData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AdsCreditRedeemResponse2, AdsCreditRedeemError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ads_credit/redeem',
  });
};

/**
 * Get targeting analytics for ads
 * Get targeting analytics for one or more ads. For the requested ad(s) and metrics,
 * the response will include the requested metric information (e.g. SPEND_IN_DOLLAR) for the requested target type
 * (e.g. "age_bucket") for applicable values (e.g. "45-49"). <p/>
 * - The token's user_account must either be the Owner of the specified ad account, or have one
 * of the necessary roles granted to them via
 * <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Analyst, Campaign Manager.
 * - If granularity is not HOUR, the furthest back you can are allowed to pull data is 90 days before the current date in UTC time and the max time range supported is 90 days.
 * - If granularity is HOUR, the furthest back you can are allowed to pull data is 8 days before the current date in UTC time and the max time range supported is 3 days.
 */
export const adTargetingAnalyticsGet = <ThrowOnError extends boolean = false>(
  options: Options<AdTargetingAnalyticsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AdTargetingAnalyticsGetResponse, AdTargetingAnalyticsGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ads/targeting_analytics',
  });
};

/**
 * Get ad
 * Get a specific ad given the ad ID. If your pin is rejected, rejected_reasons will
 * contain additional information from the Ad Review process.
 * For more information about our policies and rejection reasons see the <a href="https://www.pinterest.com/_/_/policy/advertising-guidelines/" target="_blank">Pinterest advertising standards</a>.
 */
export const adsGet = <ThrowOnError extends boolean = false>(options: Options<AdsGetData, ThrowOnError>) => {
  return (options?.client ?? client).get<AdsGetResponse, AdsGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ads/{ad_id}',
  });
};

/**
 * Get ad account analytics
 * Get analytics for the specified <code>ad_account_id</code>, filtered by the specified options.
 * - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Analyst, Campaign Manager.
 * - If granularity is not HOUR, the furthest back you can are allowed to pull data is 90 days before the current date in UTC time and the max time range supported is 90 days.
 * - If granularity is HOUR, the furthest back you can are allowed to pull data is 8 days before the current date in UTC time.
 */
export const adAccountAnalytics = <ThrowOnError extends boolean = false>(
  options: Options<AdAccountAnalyticsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AdAccountAnalyticsResponse2, AdAccountAnalyticsError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/analytics',
  });
};

/**
 * Get audience insights
 * Get Audience Insights for an ad account. The response will return insights for 3 types of audiences: the
 * ad account's engaged audience on Pinterest, the ad account's total audience on Pinterest and Pinterest's
 * total audience.<p/>
 * <a href="https://help.pinterest.com/en/business/article/audience-insights" target="_blank">Learn more about Audience Insights</a>.
 */
export const audienceInsightsGet = <ThrowOnError extends boolean = false>(
  options: Options<AudienceInsightsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AudienceInsightsGetResponse, AudienceInsightsGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/audience_insights',
  });
};

/**
 * List audiences
 * Get list of audiences for the ad account.
 */
export const audiencesList = <ThrowOnError extends boolean = false>(
  options: Options<AudiencesListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AudiencesListResponse, AudiencesListError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/audiences',
  });
};

/**
 * Create audience
 * Create an audience you can use in targeting for specific ad groups. Targeting combines customer information with
 * the ways users interact with Pinterest to help you reach specific groups of users; you can include or exclude
 * specific audience_ids when you create an ad group. <p/>
 * For more, see <a class="reference external" href="https://help.pinterest.com/en/business/article/audience-targeting" target="_blank">Audience targeting</a>.
 */
export const audiencesCreate = <ThrowOnError extends boolean = false>(
  options: Options<AudiencesCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AudiencesCreateResponse, AudiencesCreateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/audiences',
  });
};

/**
 * Get audience
 * Get a specific audience given the audience ID.
 */
export const audiencesGet = <ThrowOnError extends boolean = false>(
  options: Options<AudiencesGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AudiencesGetResponse, AudiencesGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/audiences/{audience_id}',
  });
};

/**
 * Update audience
 * Update (edit or remove) an existing targeting audience.
 */
export const audiencesUpdate = <ThrowOnError extends boolean = false>(
  options: Options<AudiencesUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<AudiencesUpdateResponse, AudiencesUpdateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/audiences/{audience_id}',
  });
};

/**
 * Create custom audience
 * Create a custom audience and find the audiences you want your ads to reach.
 */
export const audiencesCreateCustom = <ThrowOnError extends boolean = false>(
  options: Options<AudiencesCreateCustomData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AudiencesCreateCustomResponse, AudiencesCreateCustomError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/audiences/custom',
  });
};

/**
 * List accounts with access to an audience owned by an ad account
 * List all ad accounts and/or businesses that have access to a specific audience. The audience must be owned by the requesting ad account.
 */
export const adAccountsAudiencesSharedAccountsList = <ThrowOnError extends boolean = false>(
  options: Options<AdAccountsAudiencesSharedAccountsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdAccountsAudiencesSharedAccountsListResponse,
    AdAccountsAudiencesSharedAccountsListError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/audiences/shared/accounts',
  });
};

/**
 * Update audience sharing between ad accounts
 * From an ad account, share a specific audience with another ad account, or revoke access to a previously shared audience. Only the audience owner account can share the audience. The recipient ad account(s) must be in the same <a href='https://help.pinterest.com/en/business/article/create-and-manage-accounts'>Pinterest Business Hierarchy</a> as the business owner of the ad account.<br> This endpoint is not available to all apps.<a href='/docs/getting-started/beta-and-advanced-access/'>Learn more</a>.
 */
export const updateAdAccountToAdAccountSharedAudience = <ThrowOnError extends boolean = false>(
  options: Options<UpdateAdAccountToAdAccountSharedAudienceData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    UpdateAdAccountToAdAccountSharedAudienceResponse,
    UpdateAdAccountToAdAccountSharedAudienceError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/audiences/ad_accounts/shared',
  });
};

/**
 * Update audience sharing from an ad account to businesses
 * From an ad account, share a specific audience with a business account, or revoke access to a previously shared audience. Only the audience owner account can share the audience. The recipient business account must be in the same business hierarchy as the business owner of the ad account.<br> This endpoint is not available to all apps.<a href='/docs/getting-started/beta-and-advanced-access/'>Learn more</a>.
 */
export const updateAdAccountToBusinessSharedAudience = <ThrowOnError extends boolean = false>(
  options: Options<UpdateAdAccountToBusinessSharedAudienceData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    UpdateAdAccountToBusinessSharedAudienceResponse,
    UpdateAdAccountToBusinessSharedAudienceError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/audiences/businesses/shared',
  });
};

/**
 * Get bid floors
 * List bid floors for your campaign configuration. Bid floors are given in microcurrency values based on the currency in the bid floor specification. <p/>
 * <p>Microcurrency is used to track very small transactions, based on the currency set in the advertiser’s profile.</p>
 * <p>A microcurrency unit is 10^(-6) of the standard unit of currency selected in the advertiser’ s profile.</p>
 * <p><strong>Equivalency equations</strong>, using dollars as an example currency:</p>
 * <ul>
 * <li>$1 = 1,000,000 microdollars</li>
 * <li>1 microdollar = $0.000001 </li>
 * </ul>
 * <p><strong>To convert between currency and microcurrency</strong>, using dollars as an example currency:</p>
 * <ul>
 * <li>To convert dollars to microdollars, mutiply dollars by 1,000,000</li>
 * <li>To convert microdollars to dollars, divide microdollars by 1,000,000</li>
 * </ul>
 * For more on bid floors see <a class="reference external" href="https://help.pinterest.com/en/business/article/set-your-bid"> Set your bid</a>.
 */
export const adGroupsBidFloorGet = <ThrowOnError extends boolean = false>(
  options: Options<AdGroupsBidFloorGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AdGroupsBidFloorGetResponse, AdGroupsBidFloorGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/bid_floor',
  });
};

/**
 * Get billing profiles
 * Get billing profiles in the advertiser account.
 *
 * <strong>This endpoint might not be available to all apps. <a href='/docs/getting-started/beta-and-advanced-access/'>Learn more</a>.</strong>
 */
export const billingProfilesGet = <ThrowOnError extends boolean = false>(
  options: Options<BillingProfilesGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<BillingProfilesGetResponse, BillingProfilesGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/billing_profiles',
  });
};

/**
 * Get advertiser entities in bulk
 * Create an asynchronous report that may include information on campaigns, ad groups, product groups, ads,
 * and/or keywords; can filter by campaigns. Though the entities may be active, archived, or paused,
 * only active entities will return data.
 */
export const bulkDownloadCreate = <ThrowOnError extends boolean = false>(
  options: Options<BulkDownloadCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<BulkDownloadCreateResponse, BulkDownloadCreateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/bulk/download',
  });
};

/**
 * Create/update ad entities in bulk
 * Either create or update any combination of campaigns, ad groups, product groups, ads, or keywords.
 * Note that this request will be processed asynchronously; the response will include a <code>request_id</code>
 * that can be used to obtain the status of the request.
 */
export const bulkUpsertCreate = <ThrowOnError extends boolean = false>(
  options: Options<BulkUpsertCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<BulkUpsertCreateResponse, BulkUpsertCreateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/bulk/upsert',
  });
};

/**
 * Download advertiser entities in bulk
 * Get the status of a bulk request by <code>request_id</code>, along with a download URL that will allow you to download the
 * new or updated entity data (campaigns, ad groups, product groups, ads, or keywords).
 */
export const bulkRequestGet = <ThrowOnError extends boolean = false>(
  options: Options<BulkRequestGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<BulkRequestGetResponse, BulkRequestGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/bulk/{bulk_request_id}',
  });
};

/**
 * List campaigns
 * Get a list of the campaigns in the specified <code>ad_account_id</code>, filtered by the specified options.
 * - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Analyst, Campaign Manager.
 */
export const campaignsList = <ThrowOnError extends boolean = false>(
  options: Options<CampaignsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CampaignsListResponse, CampaignsListError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/campaigns',
  });
};

/**
 * Create campaigns
 * Create multiple new campaigns. Every campaign has its own campaign_id and houses one or more ad groups, which contain one or more ads.
 * For more, see <a href="https://help.pinterest.com/en/business/article/set-up-your-campaign/">Set up your campaign</a>. <p/>
 * <strong>Note:</strong>
 * - The values for 'lifetime_spend_cap' and 'daily_spend_cap' are microcurrency amounts based on the currency field set in the advertiser's profile. (e.g. USD) <p/>
 * <p>Microcurrency is used to track very small transactions, based on the currency set in the advertiser’s profile.</p>
 * <p>A microcurrency unit is 10^(-6) of the standard unit of currency selected in the advertiser’s profile.</p>
 * <p><strong>Equivalency equations</strong>, using dollars as an example currency:</p>
 * <ul>
 * <li>$1 = 1,000,000 microdollars</li>
 * <li>1 microdollar = $0.000001 </li>
 * </ul>
 * <p><strong>To convert between currency and microcurrency</strong>, using dollars as an example currency:</p>
 * <ul>
 * <li>To convert dollars to microdollars, mutiply dollars by 1,000,000</li>
 * <li>To convert microdollars to dollars, divide microdollars by 1,000,000</li>
 * </ul>
 */
export const campaignsCreate = <ThrowOnError extends boolean = false>(
  options: Options<CampaignsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CampaignsCreateResponse, CampaignsCreateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/campaigns',
  });
};

/**
 * Update campaigns
 * Update multiple ad campaigns based on campaign_ids. <p/>
 * <strong>Note:</strong><p/>
 * - <p>The values for 'lifetime_spend_cap' and 'daily_spend_cap' are microcurrency amounts based on the currency field set in the advertiser's profile. (e.g. USD) <p/>
 * <p>Microcurrency is used to track very small transactions, based on the currency set in the advertiser’s profile.</p>
 * <p>A microcurrency unit is 10^(-6) of the standard unit of currency selected in the advertiser’ s profile.</p>
 * <p><strong>Equivalency equations</strong>, using dollars as an example currency:</p>
 * <ul>
 * <li>$1 = 1,000,000 microdollars</li>
 * <li>1 microdollar = $0.000001 </li>
 * </ul>
 * <p><strong>To convert between currency and microcurrency</strong>, using dollars as an example currency:</p>
 * <ul>
 * <li>To convert dollars to microdollars, mutiply dollars by 1,000,000</li>
 * <li>To convert microdollars to dollars, divide microdollars by 1,000,000</li>
 * </ul>
 */
export const campaignsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<CampaignsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<CampaignsUpdateResponse, CampaignsUpdateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/campaigns',
  });
};

/**
 * Get campaign analytics
 * Get analytics for the specified campaigns in the specified <code>ad_account_id</code>, filtered by the specified options.
 * - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Analyst, Campaign Manager.
 * - If granularity is not HOUR, the furthest back you can are allowed to pull data is 90 days before the current date in UTC time and the max time range supported is 90 days.
 * - If granularity is HOUR, the furthest back you can are allowed to pull data is 8 days before the current date in UTC time and the max time range supported is 3 days.
 */
export const campaignsAnalytics = <ThrowOnError extends boolean = false>(
  options: Options<CampaignsAnalyticsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CampaignsAnalyticsResponse2, CampaignsAnalyticsError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/campaigns/analytics',
  });
};

/**
 * Get targeting analytics for campaigns
 * Get targeting analytics for one or more campaigns.
 * For the requested account and metrics, the response will include the requested metric information
 * (e.g. SPEND_IN_DOLLAR) for the requested target type (e.g. "age_bucket") for applicable values (e.g. "45-49"). <p/>
 * - The token's user_account must either be the Owner of the specified ad account, or have one
 * of the necessary roles granted to them via
 * <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Analyst, Campaign Manager.
 * - If granularity is not HOUR, the furthest back you can are allowed to pull data is 90 days before the current date in UTC time and the max time range supported is 90 days.
 * - If granularity is HOUR, the furthest back you can are allowed to pull data is 8 days before the current date in UTC time and the max time range supported is 3 days.
 */
export const campaignTargetingAnalyticsGet = <ThrowOnError extends boolean = false>(
  options: Options<CampaignTargetingAnalyticsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    CampaignTargetingAnalyticsGetResponse,
    CampaignTargetingAnalyticsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/campaigns/targeting_analytics',
  });
};

/**
 * Get campaign
 * Get a specific campaign given the campaign ID.
 */
export const campaignsGet = <ThrowOnError extends boolean = false>(
  options: Options<CampaignsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CampaignsGetResponse, CampaignsGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/campaigns/{campaign_id}',
  });
};

/**
 * Get conversion tags
 * List conversion tags associated with an ad account.
 */
export const conversionTagsList = <ThrowOnError extends boolean = false>(
  options: Options<ConversionTagsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ConversionTagsListResponse, ConversionTagsListError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/conversion_tags',
  });
};

/**
 * Create conversion tag
 * Create a conversion tag, also known as <a href="https://help.pinterest.com/en/business/article/set-up-the-pinterest-tag" target="_blank">Pinterest tag</a>, with the option to enable enhanced match.<p/>
 * The Pinterest Tag tracks actions people take on the ad account’ s website after they view the ad account's ad on Pinterest. The advertiser needs to customize this tag to track conversions.<p/>
 * For more information, see:<p/>
 * <a class="reference external" href="https://help.pinterest.com/en/business/article/set-up-the-pinterest-tag">Set up the Pinterest tag</a><p/>
 * <a class="reference external" href="/docs/api-features/pinterest-tag/">Pinterest Tag</a><p/>
 * <a class="reference external" href="/docs/api-features/pinterest-tag/#enhanced-match">Enhanced match</a>
 */
export const conversionTagsCreate = <ThrowOnError extends boolean = false>(
  options: Options<ConversionTagsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ConversionTagsCreateResponse, ConversionTagsCreateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/conversion_tags',
  });
};

/**
 * Get Ocpm eligible conversion tags
 * Get Ocpm eligible conversion tag events for an ad account.
 */
export const ocpmEligibleConversionTagsGet = <ThrowOnError extends boolean = false>(
  options: Options<OcpmEligibleConversionTagsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    OcpmEligibleConversionTagsGetResponse,
    OcpmEligibleConversionTagsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/conversion_tags/ocpm_eligible',
  });
};

/**
 * Get page visit conversion tags
 * Get all page visit conversion tag events for an ad account.
 */
export const pageVisitConversionTagsGet = <ThrowOnError extends boolean = false>(
  options: Options<PageVisitConversionTagsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    PageVisitConversionTagsGetResponse,
    PageVisitConversionTagsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/conversion_tags/page_visit',
  });
};

/**
 * Get conversion tag
 * Get information about an existing conversion tag.
 */
export const conversionTagsGet = <ThrowOnError extends boolean = false>(
  options: Options<ConversionTagsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ConversionTagsGetResponse, ConversionTagsGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/conversion_tags/{conversion_tag_id}',
  });
};

/**
 * Create customer lists
 * <p>Create a customer list from your records(hashed or plain-text email addresses, or hashed MAIDs or IDFAs).</p>
 * <p>A customer list is one of the four types of Pinterest audiences: for more information, see <a href="https://help.pinterest.com/en/business/article/audience-targeting" target="_blank">Audience targeting</a>
 * or the <a href="/docs/api-features/targeting-overview/" target="_blank">Audiences</a> section of the ads management guide.<p/>
 * <p><b>Please review our <u><a href="https://help.pinterest.com/en/business/article/audience-targeting#section-13341" target="_blank">requirements</a></u> for what type of information is allowed when uploading a customer list.</b></p>
 * <p>When you create a customer list, the system scans the list for existing Pinterest accounts;
 * the list must include at least 100 Pinterest accounts. Your original list will be deleted when the matching process
 * is complete. The filtered list – containing only the Pinterest accounts that were included in your starting
 * list – is what will be used to create the audience.</p>
 * <p>Note that once you have created your customer list, you must convert it into an audience (of the “ CUSTOMER_LIST” type)
 * using the <a href="#operation/create_audience_handler">create audience endpoint</a> before it can be used.</p>
 */
export const customerListsCreate = <ThrowOnError extends boolean = false>(
  options: Options<CustomerListsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CustomerListsCreateResponse, CustomerListsCreateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/customer_lists',
  });
};

/**
 * Get customer lists
 * <p>Get a set of customer lists including id and name based on the filters provided.</p>
 * <p>(Customer lists are a type of audience.) For more information, see
 * <a href="https://help.pinterest.com/en/business/article/audience-targeting" target="_blank">Audience targeting</a>
 * or the <a href="/docs/api-features/targeting-overview/" target="_blank">Audiences</a>
 * section of the ads management guide.</p>
 */
export const customerListsList = <ThrowOnError extends boolean = false>(
  options: Options<CustomerListsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CustomerListsListResponse, CustomerListsListError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/customer_lists',
  });
};

/**
 * Get customer list
 * Gets a specific customer list given the customer list ID.
 */
export const customerListsGet = <ThrowOnError extends boolean = false>(
  options: Options<CustomerListsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CustomerListsGetResponse, CustomerListsGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/customer_lists/{customer_list_id}',
  });
};

/**
 * Update customer list
 * <p>Append or remove records to/from an existing customer list. (A customer list is one of the four types of Pinterest audiences.)</p>
 * <p>When you add records to an existing customer list, the system scans the additions for existing Pinterest
 * accounts; those are the records that will be added to your “CUSTOMER_LIST” audience. Your original list of records
 * to add will be deleted when the matching process is complete.</p>
 * <p>For more information, see <a href="https://help.pinterest.com/en/business/article/audience-targeting" target="_blank">Audience targeting</a>
 * or the <a href="/docs/api-features/targeting-overview/" target="_blank">Audiences</a>
 * section of the ads management guide.</p>
 */
export const customerListsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<CustomerListsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<CustomerListsUpdateResponse, CustomerListsUpdateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/customer_lists/{customer_list_id}',
  });
};

/**
 * Send conversions
 * The Pinterest API offers advertisers a way to send Pinterest their conversion information (including web conversions, in-app conversions, or even offline conversions) based on their <code>ad_account_id</code>. The request body should be a JSON object.
 * - This endpoint requires an <code>access_token</code> be generated through Ads Manager. Review the <a href="/docs/api-features/conversion-overview/">Conversions Guide</a> for more details. (Note that the authorization header required is <code>Authorization: Bearer &lt;access_token&gt;</code>).
 * - The token's <code>user_account</code> must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Analyst, Audience, Campaign. (Note that the token can be used across multiple ad accounts under an user ID.)
 * - This endpoint has a rate limit of 5,000 calls per minute per ad account.
 * - If the merchant is submitting this information using both Pinterest conversion tags and the Pinterest API, Pinterest will remove duplicate information before reporting. (Note that events that took place offline cannot be deduplicated.)
 */
export const eventsCreate = <ThrowOnError extends boolean = false>(
  options: Options<EventsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<EventsCreateResponse, EventsCreateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/events',
  });
};

/**
 * Get audience insights scope and type
 * Get the scope and type of available audiences, which along with a date, is an audience that has recently had an interaction (referred to here as a type) on pins. Interacted pins can belong to at least the most common **partner** or **Pinterest** scopes. This means that user interactions made on advertiser or partner pins will have the **partner** scope. You can also have user interactions performed in general on Pinterest with the **Pinterest** scope. In that case, you can then use the returned type and scope values together on requests to other endpoints to retrieve insight metrics for a desired audience.
 */
export const audienceInsightsScopeAndTypeGet = <ThrowOnError extends boolean = false>(
  options: Options<AudienceInsightsScopeAndTypeGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AudienceInsightsScopeAndTypeGetResponse,
    AudienceInsightsScopeAndTypeGetError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/insights/audiences',
  });
};

/**
 * Get keywords
 * <p>Get a list of keywords based on the filters provided. If no filter is provided, it will default to the ad_account_id filter, which means it will only return keywords that specifically have parent_id set to the ad_account_id. Note: Keywords can have ad_account_ids, campaign_ids, and ad_group_ids set as their parent_ids. Keywords created through Ads Manager will have their parent_id set to an ad_group_id, not ad_account_id.</p>
 * <p>For more information, see <a target="_blank" href="https://help.pinterest.com/en/business/article/keyword-targeting">Keyword targeting</a>.</p>
 * <p><b>Notes:</b></p> <ul style="list-style-type: square;"> <li>Advertisers and campaigns can only be assigned keywords with excluding ('_NEGATIVE').</li> <li>All keyword match types are available for ad groups.</li> </ul> <p>For more information on match types, see <a target="_blank" href="/docs/api-features/targeting-overview/">match type enums</a>.</p>
 * <p><b>Returns:</b></p> <ul style="list-style-type: square;"> <li><p>A successful call returns an object containing an array of new keyword objects and an empty &quot;errors&quot; object array.</p></li> <li><p>An unsuccessful call returns an empty keywords array, and, instead, inserts the entire object with nulled/negated properties into the &quot;errors&quot; object array:</p> <pre class="last literal-block"> { "keywords": [], "errors": [ { "data": { "archived": null, "match_type": "EXACT", "parent_type": null, "value": "foobar", "parent_id": null, "type": "keyword", "id": null }, "error_messages": [ "Advertisers and Campaigns only accept excluded targeting attributes." ] } } </pre></li> </ul>
 */
export const keywordsGet = <ThrowOnError extends boolean = false>(options: Options<KeywordsGetData, ThrowOnError>) => {
  return (options?.client ?? client).get<KeywordsGetResponse, KeywordsGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/keywords',
  });
};

/**
 * Create keywords
 * <p>Create keywords for following entity types(advertiser, campaign, ad group or ad).</p> <p>For more information, see <a target="_blank" href="https://help.pinterest.com/en/business/article/keyword-targeting">Keyword targeting</a>.</p>
 * <p><b>Notes:</b></p> <ul style="list-style-type: square;"> <li>Advertisers and campaigns can only be assigned keywords with excluding ('_NEGATIVE').</li> <li>All keyword match types are available for ad groups.</li> </ul> <p>For more information on match types, see <a  target="_blank" href="/docs/api-features/targeting-overview/">match type enums</a>.</p>
 * <p><b>Returns:</b></p> <ul style="list-style-type: square;"> <li><p>A successful call returns an object containing an array of new keyword objects and an empty &quot;errors&quot; object array.</p></li> <li><p>An unsuccessful call returns an empty keywords array, and, instead, inserts the entire object with nulled/negated properties into the &quot;errors&quot; object array:</p> <pre class="last literal-block"> { "keywords": [], "errors": [ { "data": { "archived": null, "match_type": "EXACT", "parent_type": null, "value": "foobar", "parent_id": null, "type": "keyword", "id": null }, "error_messages": [ "Advertisers and Campaigns only accept excluded targeting attributes." ] } } </pre></li> </ul>
 * <p><b>Rate limit</b>: <a href="/docs/reference/rate-limits/">WRITE</a>.</p>
 */
export const keywordsCreate = <ThrowOnError extends boolean = false>(
  options: Options<KeywordsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<KeywordsCreateResponse, KeywordsCreateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/keywords',
  });
};

/**
 * Update keywords
 * <p>Update one or more keywords' bid and archived fields.</p> <p>Archiving a keyword effectively deletes it - keywords no longer receive metrics and no longer visible within the parent entity's keywords list.</p>
 */
export const keywordsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<KeywordsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<KeywordsUpdateResponse, KeywordsUpdateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/keywords',
  });
};

/**
 * Get country's keyword metrics
 * See keyword metrics for a specified country, aggregated across all of Pinterest.
 * (Definitions are available from the "Get delivery metrics definitions"
 * <a href="/docs/api/v5/#operation/delivery_metrics/get">API endpoint</a>).
 */
export const countryKeywordsMetricsGet = <ThrowOnError extends boolean = false>(
  options: Options<CountryKeywordsMetricsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    CountryKeywordsMetricsGetResponse,
    CountryKeywordsMetricsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/keywords/metrics',
  });
};

/**
 * List lead forms
 * <strong>This feature is currently in beta and not available to all apps, if you're interested in joining the beta, please reach out to your Pinterest account manager.</strong>
 *
 * List lead forms associated with an ad account ID.
 *
 * For more, see <a class="reference external" href="https://help.pinterest.com/en/business/article/lead-ads">Lead ads</a>.
 */
export const leadFormsList = <ThrowOnError extends boolean = false>(
  options: Options<LeadFormsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<LeadFormsListResponse, LeadFormsListError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/lead_forms',
  });
};

/**
 * Create lead forms
 * <strong>This feature is currently in beta and not available to all apps, if you're interested in joining the beta, please reach out to your Pinterest account manager.</strong>
 *
 * Create lead forms. Lead forms are used in lead ads and allow you to control what text appears on the lead form’ s description, questions and confirmation sections.
 *
 * For more, see <a class="reference external" href="https://help.pinterest.com/en/business/article/lead-ads">Lead ads</a>.
 */
export const leadFormsCreate = <ThrowOnError extends boolean = false>(
  options: Options<LeadFormsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<LeadFormsCreateResponse, LeadFormsCreateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/lead_forms',
  });
};

/**
 * Update lead forms
 * <strong>This feature is currently in beta and not available to all apps, if you're interested in joining the beta, please reach out to your Pinterest account manager.</strong>
 *
 * Update lead forms. Lead ads help you reach people who are actively looking for, and interested in, your goods and services. The lead form can be associated with an ad to allow people to fill out the form.
 *
 * For more, see <a class="reference external" href="https://help.pinterest.com/en/business/article/lead-ads">Lead ads</a>.
 */
export const leadFormsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<LeadFormsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<LeadFormsUpdateResponse, LeadFormsUpdateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/lead_forms',
  });
};

/**
 * Get lead form by id
 * <strong>This feature is currently in beta and not available to all apps, if you're interested in joining the beta, please reach out to your Pinterest account manager.</strong>
 *
 * Gets a lead form given it's ID. It must also be associated with the provided ad account ID.
 *
 * For more, see <a class="reference external" href="https://help.pinterest.com/en/business/article/lead-ads">Lead ads</a>.
 */
export const leadFormGet = <ThrowOnError extends boolean = false>(options: Options<LeadFormGetData, ThrowOnError>) => {
  return (options?.client ?? client).get<LeadFormGetResponse, LeadFormGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/lead_forms/{lead_form_id}',
  });
};

/**
 * Create lead form test data
 * Create lead form test data based on the list of answers provided as part of the body.
 * - List of answers should follow the questions creation order.
 *
 * <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/getting-started/beta-and-advanced-access/'>Learn more</a>.</strong>
 */
export const leadFormTestCreate = <ThrowOnError extends boolean = false>(
  options: Options<LeadFormTestCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<LeadFormTestCreateResponse, LeadFormTestCreateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/lead_forms/{lead_form_id}/test',
  });
};

/**
 * Create lead ads subscription
 * Create a lead ads webhook subscription.
 * Subscriptions allow Pinterest to deliver lead data from Ads Manager directly to the subscriber. Subscriptions can exist for a specific lead form or at ad account level.
 * - Only requests for the OWNER or ADMIN of the ad_account will be allowed.
 * - Advertisers can set up multiple integrations using ad_account_id + lead_form_id but only one integration per unique records.
 * - For data security, egress lead data is encrypted with AES-256-GCM.
 *
 * <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/getting-started/beta-and-advanced-access/'>Learn more</a>.</strong>
 */
export const adAccountsSubscriptionsPost = <ThrowOnError extends boolean = false>(
  options: Options<AdAccountsSubscriptionsPostData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AdAccountsSubscriptionsPostResponse,
    AdAccountsSubscriptionsPostError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/leads/subscriptions',
  });
};

/**
 * Get lead ads subscriptions
 * Get the advertiser's list of lead ads subscriptions.
 * - Only requests for the OWNER or ADMIN of the ad_account will be allowed.
 *
 * <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/getting-started/beta-and-advanced-access/'>Learn more</a>.</strong>
 */
export const adAccountsSubscriptionsGetList = <ThrowOnError extends boolean = false>(
  options: Options<AdAccountsSubscriptionsGetListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdAccountsSubscriptionsGetListResponse,
    AdAccountsSubscriptionsGetListError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/leads/subscriptions',
  });
};

/**
 * Get lead ads subscription
 * Get a specific lead ads subscription record.
 * - Only requests for the OWNER or ADMIN of the ad_account will be allowed.
 *
 * <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/getting-started/beta-and-advanced-access/'>Learn more</a>.</strong>
 */
export const adAccountsSubscriptionsGetById = <ThrowOnError extends boolean = false>(
  options: Options<AdAccountsSubscriptionsGetByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdAccountsSubscriptionsGetByIdResponse,
    AdAccountsSubscriptionsGetByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/leads/subscriptions/{subscription_id}',
  });
};

/**
 * Delete lead ads subscription
 * Delete an existing lead ads webhook subscription by ID.
 * - Only requests for the OWNER or ADMIN of the ad_account will be allowed.
 *
 * <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/getting-started/beta-and-advanced-access/'>Learn more</a>.</strong>
 */
export const adAccountsSubscriptionsDelById = <ThrowOnError extends boolean = false>(
  options: Options<AdAccountsSubscriptionsDelByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    AdAccountsSubscriptionsDelByIdResponse,
    AdAccountsSubscriptionsDelByIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/leads/subscriptions/{subscription_id}',
  });
};

/**
 * Create a request to export leads collected from a lead ad
 * <strong>This feature is currently in beta and not available to all apps, if you're interested in joining the beta, please reach out to your Pinterest account manager.</strong>
 *
 * Create an export of leads collected from a lead ad. This returns a lead_export_id  token that you can use to download the export when it is ready.
 *
 * Note: Lead ad data will be available up to 30 days after the lead has been submitted.
 *
 * For more, see <a class="reference external" href="https://help.pinterest.com/en/business/article/lead-ads">Lead ads</a>.
 */
export const leadsExportCreate = <ThrowOnError extends boolean = false>(
  options: Options<LeadsExportCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<LeadsExportCreateResponse2, LeadsExportCreateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/leads_export',
  });
};

/**
 * Get the lead export from the lead export create call
 * <strong>This feature is currently in beta and not available to all apps, if you're interested in joining the beta, please reach out to your Pinterest account manager.</strong>
 *
 * Get the export of leads collected from a lead ad. This returns a URL to a list of lead export given a lead_export_id token returned from the create a lead export call. You can use the URL to download the report.
 *
 * Note: Lead ad data will be available up to 30 days after the lead has been submitted.
 *
 * For more, see <a class="reference external" href="https://help.pinterest.com/en/business/article/lead-ads">Lead ads</a>.
 */
export const leadsExportGet = <ThrowOnError extends boolean = false>(
  options: Options<LeadsExportGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<LeadsExportGetResponse, LeadsExportGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/leads_export/{leads_export_id}',
  });
};

/**
 * Get advertiser Marketing Mix Modeling (MMM) report.
 * Get an mmm report for an ad account. This returns a URL to an mmm metrics report given a token returned from the
 * create mmm report endpoint.
 */
export const analyticsGetMmmReport = <ThrowOnError extends boolean = false>(
  options: Options<AnalyticsGetMmmReportData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AnalyticsGetMmmReportResponse, AnalyticsGetMmmReportError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/mmm_reports',
  });
};

/**
 * Create a request for a Marketing Mix Modeling (MMM) report
 * This creates an asynchronous mmm report based on the given request. It returns a token that you can use to download
 * the report when it is ready. NOTE: An additional limit of 5 queries per minute per advertiser applies to this endpoint while it's in beta release.
 */
export const analyticsCreateMmmReport = <ThrowOnError extends boolean = false>(
  options: Options<AnalyticsCreateMmmReportData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AnalyticsCreateMmmReportResponse,
    AnalyticsCreateMmmReportError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/mmm_reports',
  });
};

/**
 * Get order lines
 * List existing order lines associated with an ad account.
 */
export const orderLinesList = <ThrowOnError extends boolean = false>(
  options: Options<OrderLinesListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<OrderLinesListResponse, OrderLinesListError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/order_lines',
  });
};

/**
 * Get order line
 * Get a specific existing order line associated with an ad account.
 */
export const orderLinesGet = <ThrowOnError extends boolean = false>(
  options: Options<OrderLinesGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<OrderLinesGetResponse, OrderLinesGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/order_lines/{order_line_id}',
  });
};

/**
 * Create product group promotions
 * Add one or more product groups from your catalog to an existing ad group. (Product groups added to an ad group are a 'product group promotion.')
 */
export const productGroupPromotionsCreate = <ThrowOnError extends boolean = false>(
  options: Options<ProductGroupPromotionsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    ProductGroupPromotionsCreateResponse,
    ProductGroupPromotionsCreateError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/product_group_promotions',
  });
};

/**
 * Update product group promotions
 * Update multiple existing Product Group Promotions (by product_group_id)
 */
export const productGroupPromotionsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<ProductGroupPromotionsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    ProductGroupPromotionsUpdateResponse,
    ProductGroupPromotionsUpdateError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/product_group_promotions',
  });
};

/**
 * Get product group promotions
 * List existing product group promotions associated with an ad account.
 *
 * Include either ad_group_id or product_group_promotion_ids in your request.
 *
 * <b>Note:</b> ad_group_ids and product_group_promotion_ids are mutually exclusive parameters.
 * Only provide one. If multiple options are provided, product_group_promotion_ids takes precedence over ad_group_ids. If none are provided, the endpoint returns an error.
 */
export const productGroupPromotionsList = <ThrowOnError extends boolean = false>(
  options: Options<ProductGroupPromotionsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ProductGroupPromotionsListResponse,
    ProductGroupPromotionsListError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/product_group_promotions',
  });
};

/**
 * Get a product group promotion by id
 * Get a product group promotion by id
 */
export const productGroupPromotionsGet = <ThrowOnError extends boolean = false>(
  options: Options<ProductGroupPromotionsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ProductGroupPromotionsGetResponse,
    ProductGroupPromotionsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/product_group_promotions/{product_group_promotion_id}',
  });
};

/**
 * Get product group analytics
 * Get analytics for the specified product groups in the specified <code>ad_account_id</code>, filtered by the specified options.
 * - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Analyst, Campaign Manager.
 * - If granularity is not HOUR, the furthest back you can are allowed to pull data is 90 days before the current date in UTC time and the max time range supported is 90 days.
 * - If granularity is HOUR, the furthest back you can are allowed to pull data is 8 days before the current date in UTC time and the max time range supported is 3 days.
 */
export const productGroupsAnalytics = <ThrowOnError extends boolean = false>(
  options: Options<ProductGroupsAnalyticsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ProductGroupsAnalyticsResponse, ProductGroupsAnalyticsError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/product_groups/analytics',
  });
};

/**
 * Get the account analytics report created by the async call
 * This returns a URL to an analytics report given a token returned from the post request report creation call. You can use the URL to download the report. The link is valid for five minutes and the report is valid for one hour.
 * - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Analyst, Campaign Manager.
 */
export const analyticsGetReport = <ThrowOnError extends boolean = false>(
  options: Options<AnalyticsGetReportData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AnalyticsGetReportResponse, AnalyticsGetReportError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/reports',
  });
};

/**
 * Create async request for an account analytics report
 * This returns a token that you can use to download the report when it is ready. Note that this endpoint requires the parameters to be passed as JSON-formatted in the request body. This endpoint does not support URL query parameters.
 * - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Analyst, Campaign Manager.
 * - If granularity is not HOUR, the furthest back you can are allowed to pull data is 914 days before the current date in UTC time and the max time range supported is 186 days.
 * - If granularity is HOUR, the furthest back you can are allowed to pull data is 8 days before the current date in UTC time and the max time range supported is 3 days.
 * - If level is PRODUCT_ITEM, the furthest back you can are allowed to pull data is 92 days before the current date in UTC time and the max time range supported is 31 days.
 * - If level is PRODUCT_ITEM, ad_ids and ad_statuses parameters are not allowed. Any columns related to pin promotion and ad is not allowed either.
 */
export const analyticsCreateReport = <ThrowOnError extends boolean = false>(
  options: Options<AnalyticsCreateReportData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AnalyticsCreateReportResponse, AnalyticsCreateReportError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/reports',
  });
};

/**
 * Delete ads data for ad account in API Sandbox
 * Delete an ad account and all the ads data associated with that account.
 * A string message is returned indicating the status of the delete operation.
 *
 * Note: This endpoint is only allowed in the Pinterest API Sandbox (https://api-sandbox.pinterest.com/v5).
 * Go to /docs/developer-tools/sandbox/ for more information.
 */
export const sandboxDelete = <ThrowOnError extends boolean = false>(
  options: Options<SandboxDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<SandboxDeleteResponse, SandboxDeleteError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/sandbox',
  });
};

/**
 * Get Salesforce account details including bill-to information.
 * Get Salesforce account details including bill-to information to be used in insertion orders process for <code>ad_account_id</code>.
 * - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Finance, Campaign.
 */
export const ssioAccountsGet = <ThrowOnError extends boolean = false>(
  options: Options<SsioAccountsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<SsioAccountsGetResponse, SsioAccountsGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ssio/accounts',
  });
};

/**
 * Create insertion order through SSIO.
 * Create insertion order through SSIO for <code>ad_account_id</code>.
 * - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Finance, Campaign.
 */
export const ssioInsertionOrderCreate = <ThrowOnError extends boolean = false>(
  options: Options<SsioInsertionOrderCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SsioInsertionOrderCreateResponse,
    SsioInsertionOrderCreateError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ssio/insertion_orders',
  });
};

/**
 * Edit insertion order through SSIO.
 * Edit insertion order through SSIO for <code>ad_account_id</code>.
 * - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Finance, Campaign.
 */
export const ssioInsertionOrderEdit = <ThrowOnError extends boolean = false>(
  options: Options<SsioInsertionOrderEditData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<SsioInsertionOrderEditResponse, SsioInsertionOrderEditError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ssio/insertion_orders',
  });
};

/**
 * Get insertion order status by ad account id.
 * Get insertion order status for account id <code>ad_account_id</code>.
 * - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Finance, Campaign.
 */
export const ssioInsertionOrdersStatusGetByAdAccount = <ThrowOnError extends boolean = false>(
  options: Options<SsioInsertionOrdersStatusGetByAdAccountData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    SsioInsertionOrdersStatusGetByAdAccountResponse,
    SsioInsertionOrdersStatusGetByAdAccountError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ssio/insertion_orders/status',
  });
};

/**
 * Get insertion order status by pin order id.
 * Get insertion order status for pin order id <code>pin_order_id</code>.
 * - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Finance, Campaign.
 */
export const ssioInsertionOrdersStatusGetByPinOrderId = <ThrowOnError extends boolean = false>(
  options: Options<SsioInsertionOrdersStatusGetByPinOrderIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    SsioInsertionOrdersStatusGetByPinOrderIdResponse,
    SsioInsertionOrdersStatusGetByPinOrderIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ssio/insertion_orders/{pin_order_id}/status',
  });
};

/**
 * Get Salesforce order lines by ad account id.
 * Get Salesforce order lines for account id <code>ad_account_id</code>.
 * - The token's user_account must either be the Owner of the specified ad account, or have one of the necessary roles granted to them via <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Finance, Campaign.
 */
export const ssioOrderLinesGetByAdAccount = <ThrowOnError extends boolean = false>(
  options: Options<SsioOrderLinesGetByAdAccountData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    SsioOrderLinesGetByAdAccountResponse,
    SsioOrderLinesGetByAdAccountError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/ssio/order_lines',
  });
};

/**
 * Get targeting analytics for an ad account
 * Get targeting analytics for an ad account.
 * For the requested account and metrics, the response will include the requested metric information
 * (e.g. SPEND_IN_DOLLAR) for the requested target type (e.g. "age_bucket") for applicable values (e.g. "45-49"). <p/>
 * - The token's user_account must either be the Owner of the specified ad account, or have one
 * of the necessary roles granted to them via
 * <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a>: Admin, Analyst, Campaign Manager.
 * - If granularity is not HOUR, the furthest back you can are allowed to pull data is 90 days before the current date in UTC time and the max time range supported is 90 days.
 * - If granularity is HOUR, the furthest back you can are allowed to pull data is 8 days before the current date in UTC time and the max time range supported is 3 days.
 */
export const adAccountTargetingAnalyticsGet = <ThrowOnError extends boolean = false>(
  options: Options<AdAccountTargetingAnalyticsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdAccountTargetingAnalyticsGetResponse,
    AdAccountTargetingAnalyticsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/targeting_analytics',
  });
};

/**
 * List targeting templates
 * Get a list of the targeting templates in the specified <code>ad_account_id</code>
 */
export const targetingTemplateList = <ThrowOnError extends boolean = false>(
  options: Options<TargetingTemplateListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<TargetingTemplateListResponse, TargetingTemplateListError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/targeting_templates',
  });
};

/**
 * Create targeting templates
 * <p>Targeting templates allow advertisers to save a set of targeting details including audience lists,
 * keywords & interest, demographics, and placements to use more than once during the campaign creation process.</p>
 * <p>Templates can be used to build out basic targeting criteria that you plan to use across campaigns and to reuse
 * performance targeting from prior campaigns for new campaigns.</p>
 */
export const targetingTemplateCreate = <ThrowOnError extends boolean = false>(
  options: Options<TargetingTemplateCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<TargetingTemplateCreateResponse, TargetingTemplateCreateError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/targeting_templates',
  });
};

/**
 * Update targeting templates
 * <p>Update the targeting template given advertiser ID and targeting template ID</p>
 */
export const targetingTemplateUpdate = <ThrowOnError extends boolean = false>(
  options: Options<TargetingTemplateUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<TargetingTemplateUpdateResponse, TargetingTemplateUpdateError, ThrowOnError>(
    {
      ...options,
      url: '/ad_accounts/{ad_account_id}/targeting_templates',
    },
  );
};

/**
 * List templates
 * Gets all Templates associated with an ad account ID.
 */
export const templatesList = <ThrowOnError extends boolean = false>(
  options: Options<TemplatesListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<TemplatesListResponse, TemplatesListError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/templates',
  });
};

/**
 * Create async request for an analytics report using a template
 * This takes a template ID and an optional custom timeframe and constructs an asynchronous report based on the
 * template. It returns a token that you can use to download the report when it is ready.
 */
export const analyticsCreateTemplateReport = <ThrowOnError extends boolean = false>(
  options: Options<AnalyticsCreateTemplateReportData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AnalyticsCreateTemplateReportResponse,
    AnalyticsCreateTemplateReportError,
    ThrowOnError
  >({
    ...options,
    url: '/ad_accounts/{ad_account_id}/templates/{template_id}/reports',
  });
};

/**
 * Get terms of service
 * Get the text of the terms of service and see whether the advertiser has accepted the terms of service.
 */
export const termsOfServiceGet = <ThrowOnError extends boolean = false>(
  options: Options<TermsOfServiceGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<TermsOfServiceGetResponse, TermsOfServiceGetError, ThrowOnError>({
    ...options,
    url: '/ad_accounts/{ad_account_id}/terms_of_service',
  });
};

/**
 * Get item bid options (POST)
 * Get the bid options for a batch of retail catalog items.
 *
 * The catalog must be owned by the "operation user_account". <a href="/docs/api-features/shopping-overview/#Update%20items%20in%20batch" target="_blank">See detailed documentation here.</a> By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: `Owner`, `Admin`.
 *
 * This endpoint is not available to all users.
 */
export const advancedAuctionItemsGetPost = <ThrowOnError extends boolean = false>(
  options: Options<AdvancedAuctionItemsGetPostData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AdvancedAuctionItemsGetPostResponse,
    AdvancedAuctionItemsGetPostError,
    ThrowOnError
  >({
    ...options,
    url: '/advanced_auction/items/get',
  });
};

/**
 * Operate on item level bid options
 * This endpoint supports multiple operations on a set of one or more bid options (bid price and bid adjustments for targeting categories) for retail catalog items. These advanced auction settings are applied in campaigns using objective_type `CATALOG_SALES` and ad groups using bid_strategy_type `MAX_BID`.
 *
 * The catalog must be owned by the "operation user_account". <a href="/docs/api-features/modify-items-in-batch/" target="_blank">See detailed documentation here.</a> By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: `Owner`, `Admin`.
 *
 * This endpoint is not available to all users.
 */
export const advancedAuctionItemsSubmitPost = <ThrowOnError extends boolean = false>(
  options: Options<AdvancedAuctionItemsSubmitPostData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AdvancedAuctionItemsSubmitPostResponse,
    AdvancedAuctionItemsSubmitPostError,
    ThrowOnError
  >({
    ...options,
    url: '/advanced_auction/items/submit',
  });
};

/**
 * List boards
 * Get a list of the boards owned by the "operation user_account" + group boards where this account is a collaborator
 * Optional: Business Access: Specify an ad_account_id to use the owner of that ad_account as the "operation user_account".
 * Optional: Specify a privacy type (public, protected, or secret) to indicate which boards to return.
 * - If no privacy is specified, all boards that can be returned (based on the scopes of the token and ad_account role if applicable) will be returned.
 */
export const boardsList = <ThrowOnError extends boolean = false>(options?: Options<BoardsListData, ThrowOnError>) => {
  return (options?.client ?? client).get<BoardsListResponse, BoardsListError, ThrowOnError>({
    ...options,
    url: '/boards',
  });
};

/**
 * Create board
 * Create a board owned by the "operation user_account".
 * Optional: Business Access: Specify an ad_account_id to use the owner of that ad_account as the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 */
export const boardsCreate = <ThrowOnError extends boolean = false>(
  options: Options<BoardsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<BoardsCreateResponse, BoardsCreateError, ThrowOnError>({
    ...options,
    url: '/boards',
  });
};

/**
 * Get board
 * Get a board owned by the operation user_account - or a group board that has been shared with this account.
 * - Optional: Business Access: Specify an ad_account_id to use the owner of that ad_account as the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 */
export const boardsGet = <ThrowOnError extends boolean = false>(options: Options<BoardsGetData, ThrowOnError>) => {
  return (options?.client ?? client).get<BoardsGetResponse, BoardsGetError, ThrowOnError>({
    ...options,
    url: '/boards/{board_id}',
  });
};

/**
 * Update board
 * Update a board owned by the "operating user_account".
 * - Optional: Business Access: Specify an ad_account_id to use the owner of that ad_account as the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 */
export const boardsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<BoardsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<BoardsUpdateResponse, BoardsUpdateError, ThrowOnError>({
    ...options,
    url: '/boards/{board_id}',
  });
};

/**
 * Delete board
 * Delete a board owned by the "operation user_account".
 * - Optional: Business Access: Specify an ad_account_id to use the owner of that ad_account as the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 */
export const boardsDelete = <ThrowOnError extends boolean = false>(
  options: Options<BoardsDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<BoardsDeleteResponse, BoardsDeleteError, ThrowOnError>({
    ...options,
    url: '/boards/{board_id}',
  });
};

/**
 * List Pins on board
 * Get a list of the Pins on a board owned by the "operation user_account" - or on a group board that has been shared with this account.
 * - Optional: Business Access: Specify an ad_account_id to use the owner of that ad_account as the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 */
export const boardsListPins = <ThrowOnError extends boolean = false>(
  options: Options<BoardsListPinsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<BoardsListPinsResponse, BoardsListPinsError, ThrowOnError>({
    ...options,
    url: '/boards/{board_id}/pins',
  });
};

/**
 * List board sections
 * Get a list of all board sections from a board owned by the "operation user_account" - or a group board that has been shared with this account.
 * Optional: Business Access: Specify an ad_account_id to use the owner of that ad_account as the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 */
export const boardSectionsList = <ThrowOnError extends boolean = false>(
  options: Options<BoardSectionsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<BoardSectionsListResponse, BoardSectionsListError, ThrowOnError>({
    ...options,
    url: '/boards/{board_id}/sections',
  });
};

/**
 * Create board section
 * Create a board section on a board owned by the "operation user_account" - or on a group board that has been shared with this account.
 * Optional: Business Access: Specify an ad_account_id to use the owner of that ad_account as the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 */
export const boardSectionsCreate = <ThrowOnError extends boolean = false>(
  options: Options<BoardSectionsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<BoardSectionsCreateResponse, BoardSectionsCreateError, ThrowOnError>({
    ...options,
    url: '/boards/{board_id}/sections',
  });
};

/**
 * Update board section
 * Update a board section on a board owned by the "operation user_account" - or on a group board that has been shared with this account.
 * Optional: Business Access: Specify an ad_account_id to use the owner of that ad_account as the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 */
export const boardSectionsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<BoardSectionsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<BoardSectionsUpdateResponse, BoardSectionsUpdateError, ThrowOnError>({
    ...options,
    url: '/boards/{board_id}/sections/{section_id}',
  });
};

/**
 * Delete board section
 * Delete a board section on a board owned by the "operation user_account" - or on a group board that has been shared with this account.
 * Optional: Business Access: Specify an ad_account_id to use the owner of that ad_account as the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 */
export const boardSectionsDelete = <ThrowOnError extends boolean = false>(
  options: Options<BoardSectionsDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<BoardSectionsDeleteResponse, BoardSectionsDeleteError, ThrowOnError>({
    ...options,
    url: '/boards/{board_id}/sections/{section_id}',
  });
};

/**
 * List Pins on board section
 * Get a list of the Pins on a board section of a board owned by the "operation user_account" - or on a group board that has been shared with this account.
 * Optional: Business Access: Specify an ad_account_id to use the owner of that ad_account as the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 */
export const boardSectionsListPins = <ThrowOnError extends boolean = false>(
  options: Options<BoardSectionsListPinsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<BoardSectionsListPinsResponse, BoardSectionsListPinsError, ThrowOnError>({
    ...options,
    url: '/boards/{board_id}/sections/{section_id}/pins',
  });
};

/**
 * List business employers for user
 * Get all of the viewing user's business employers.
 */
export const getBusinessEmployers = <ThrowOnError extends boolean = false>(
  options?: Options<GetBusinessEmployersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetBusinessEmployersResponse, GetBusinessEmployersError, ThrowOnError>({
    ...options,
    url: '/businesses/employers',
  });
};

/**
 * Accept or decline an invite/request
 * Accept or decline invites or requests.
 */
export const respondBusinessAccessInvites = <ThrowOnError extends boolean = false>(
  options: Options<RespondBusinessAccessInvitesData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    RespondBusinessAccessInvitesResponse,
    RespondBusinessAccessInvitesError,
    ThrowOnError
  >({
    ...options,
    url: '/businesses/invites',
  });
};

/**
 * Get members with access to asset
 * Get all the members the requesting business has granted access to on the given asset.
 */
export const businessAssetMembersGet = <ThrowOnError extends boolean = false>(
  options: Options<BusinessAssetMembersGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<BusinessAssetMembersGetResponse, BusinessAssetMembersGetError, ThrowOnError>({
    ...options,
    url: '/businesses/{business_id}/assets/{asset_id}/members',
  });
};

/**
 * Get partners with access to asset
 * Get all the partners the requesting business has granted access to on the given asset.
 * Note: If the asset has been shared with you, an empty array will be returned. This is because an asset shared with
 * you cannot be shared with a different partner.
 */
export const businessAssetPartnersGet = <ThrowOnError extends boolean = false>(
  options: Options<BusinessAssetPartnersGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<BusinessAssetPartnersGetResponse, BusinessAssetPartnersGetError, ThrowOnError>(
    {
      ...options,
      url: '/businesses/{business_id}/assets/{asset_id}/partners',
    },
  );
};

/**
 * Update invite/request with an asset permission
 * Assign asset permissions information to an existing invite/request. Can be used to:
 * - Request access to a partner's asset. Note: This is only for when no existing partnership exists. If an existing
 * partnership exists, use "Create a request to access an existing partner's assets" to request access to your
 * partner's assets.
 * - invite_type="PARTNER_REQUEST"
 * - Invite a partner to access your business assets. Note: This is only for when there is no existing partnership.
 * If there is an existing partnership, use "Assign/Update partner asset permissions" to assign a partner access to
 * new assets.
 * - invite_type="PARTNER_INVITE"
 * - Invite a member to access your business assets. Note: This is only for when there is no existing membership.
 * If there is an existing membership, use "Assign/Update member asset permissions" to assign a member access to new
 * assets.
 * - invite_type="MEMBER_INVITE"
 *
 * To learn more about permission levels, visit https://help.pinterest.com/en/business/article/business-manager-overview.
 */
export const createAssetInvites = <ThrowOnError extends boolean = false>(
  options: Options<CreateAssetInvitesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateAssetInvitesResponse, CreateAssetInvitesError, ThrowOnError>({
    ...options,
    url: '/businesses/{business_id}/invites/assets/access',
  });
};

/**
 * Create a request to access an existing partner's assets.
 * Create a request to access an existing partner's assets with the specified permissions. The request will be sent to the partner for approval. The assets that can be requested are ad accounts and profiles.
 */
export const assetAccessRequestsCreate = <ThrowOnError extends boolean = false>(
  options: Options<AssetAccessRequestsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AssetAccessRequestsCreateResponse,
    AssetAccessRequestsCreateError,
    ThrowOnError
  >({
    ...options,
    url: '/businesses/{business_id}/requests/assets/access',
  });
};

/**
 * Get business members
 * Get all members of the specified business.
 * The return response will include the member's business_role and assets they have access to if assets_summary=TRUE
 */
export const getBusinessMembers = <ThrowOnError extends boolean = false>(
  options: Options<GetBusinessMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetBusinessMembersResponse, GetBusinessMembersError, ThrowOnError>({
    ...options,
    url: '/businesses/{business_id}/members',
  });
};

/**
 * Update member's business role
 * Update a member's business role within the business.
 */
export const updateBusinessMemberships = <ThrowOnError extends boolean = false>(
  options: Options<UpdateBusinessMembershipsData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    UpdateBusinessMembershipsResponse,
    UpdateBusinessMembershipsError,
    ThrowOnError
  >({
    ...options,
    url: '/businesses/{business_id}/members',
  });
};

/**
 * Terminate business memberships
 * Terminate memberships between the specified members and your business.
 */
export const deleteBusinessMembership = <ThrowOnError extends boolean = false>(
  options: Options<DeleteBusinessMembershipData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteBusinessMembershipResponse,
    DeleteBusinessMembershipError,
    ThrowOnError
  >({
    ...options,
    url: '/businesses/{business_id}/members',
  });
};

/**
 * List business assets
 * Get all the assets the requesting business has access to. This includes assets the business owns and assets the business has access to through partnerships.
 */
export const businessAssetsGet = <ThrowOnError extends boolean = false>(
  options: Options<BusinessAssetsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<BusinessAssetsGetResponse, BusinessAssetsGetError, ThrowOnError>({
    ...options,
    url: '/businesses/{business_id}/assets',
  });
};

/**
 * Get assets assigned to a member
 * Get assets on which you assigned asset permissions to the given member. Can be used to:
 * - get all assets, regardless of asset type or
 * - get assets of one asset type by using the asset_type query.
 * The return response will include the permissions the member has to that asset and the asset type.
 */
export const businessMemberAssetsGet = <ThrowOnError extends boolean = false>(
  options: Options<BusinessMemberAssetsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<BusinessMemberAssetsGetResponse, BusinessMemberAssetsGetError, ThrowOnError>({
    ...options,
    url: '/businesses/{business_id}/members/{member_id}/assets',
  });
};

/**
 * Assign/Update member asset permissions
 * Grant multiple members access to assets and/or update multiple member's exisiting permissions to an asset.
 * Note: Not all listed permissions are applicable to each asset type. For example, PROFILE_PUBLISHER would not be applicable to an asset of type AD_ACCOUNT. The permission level PROFILE_PUBLISHER is only available to an asset of the type PROFILE.
 *
 */
export const businessMembersAssetAccessUpdate = <ThrowOnError extends boolean = false>(
  options: Options<BusinessMembersAssetAccessUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    BusinessMembersAssetAccessUpdateResponse,
    BusinessMembersAssetAccessUpdateError,
    ThrowOnError
  >({
    ...options,
    url: '/businesses/{business_id}/members/assets/access',
  });
};

/**
 * Delete member access to asset
 * Terminate multiple members' access to an asset.
 */
export const businessMembersAssetAccessDelete = <ThrowOnError extends boolean = false>(
  options: Options<BusinessMembersAssetAccessDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    BusinessMembersAssetAccessDeleteResponse,
    BusinessMembersAssetAccessDeleteError,
    ThrowOnError
  >({
    ...options,
    url: '/businesses/{business_id}/members/assets/access',
  });
};

/**
 * Get invites/requests
 * Get the membership/partnership invites and/or requests for the authorized user.
 */
export const getInvites = <ThrowOnError extends boolean = false>(options: Options<GetInvitesData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetInvitesResponse, GetInvitesError, ThrowOnError>({
    ...options,
    url: '/businesses/{business_id}/invites',
  });
};

/**
 * Create invites or requests
 * Create batch invites or requests. Can create batch invites or requests as described below.
 * - Invite members to join the business. This would required specifying the following:
 * - invite_type="MEMBER_INVITE"
 * - business_role="EMPLOYEE" OR business_role="BIZ_ADMIN" (To learn more about business roles, visit
 * https://help.pinterest.com/en/business/article/profile-permissions-in-business-access.)
 * - members
 * - Invite partners to access your business assets. This would require specifying the following:
 * - invite_type="PARTNER_INVITE"
 * - business_role="PARTNER"
 * - partners
 * - Request to be a partner so you can access their assets. This would require specifying the following:
 * - invite_type="PARTNER_REQUEST"
 * - business_role="PARTNER"
 * - partners
 */
export const createMembershipOrPartnershipInvites = <ThrowOnError extends boolean = false>(
  options: Options<CreateMembershipOrPartnershipInvitesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateMembershipOrPartnershipInvitesResponse,
    CreateMembershipOrPartnershipInvitesError,
    ThrowOnError
  >({
    ...options,
    url: '/businesses/{business_id}/invites',
  });
};

/**
 * Cancel invites/requests
 * Cancel membership/partnership invites and/or requests.
 */
export const cancelInvitesOrRequests = <ThrowOnError extends boolean = false>(
  options: Options<CancelInvitesOrRequestsData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    CancelInvitesOrRequestsResponse,
    CancelInvitesOrRequestsError,
    ThrowOnError
  >({
    ...options,
    url: '/businesses/{business_id}/invites',
  });
};

/**
 * Assign/Update partner asset permissions
 * Grant multiple partners access to assets and/or update multiple partner's exisiting permissions to an asset.
 * If your partner already had permissions on the asset, they will be overriden with the new permissions you assign to them.
 * To learn more about permission levels, visit https://help.pinterest.com/en/business/article/business-manager-overview
 *
 * Note: Not all listed permissions are applicable to each asset type. For example, PROFILE_PUBLISHER would not be
 * applicable to an asset of type AD_ACCOUNT. The permission level PROFILE_PUBLISHER is only available to an asset of
 * the type PROFILE.
 */
export const updatePartnerAssetAccessHandlerImpl = <ThrowOnError extends boolean = false>(
  options: Options<UpdatePartnerAssetAccessHandlerImplData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    UpdatePartnerAssetAccessHandlerImplResponse,
    UpdatePartnerAssetAccessHandlerImplError,
    ThrowOnError
  >({
    ...options,
    url: '/businesses/{business_id}/partners/assets',
  });
};

/**
 * Delete partner access to asset
 * Terminate multiple partners' access to an asset. If
 * - partner_type=INTERNAL: You will terminate a partner's asset access to your business assets.
 * - partner_type=EXTERNAL: You will terminate your own access to your partner's business assets.
 */
export const deletePartnerAssetAccessHandlerImpl = <ThrowOnError extends boolean = false>(
  options: Options<DeletePartnerAssetAccessHandlerImplData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeletePartnerAssetAccessHandlerImplResponse,
    DeletePartnerAssetAccessHandlerImplError,
    ThrowOnError
  >({
    ...options,
    url: '/businesses/{business_id}/partners/assets',
  });
};

/**
 * Get assets assigned to a partner or assets assigned by a partner
 * Can be used to get the business assets your partner has granted you access to or the business assets you have
 * granted your partner access to. If you specify:
 * - partner_type=INTERNAL, you will retrieve your business assets that the partner has access to.
 * - partner_type=EXTERNAL, you will retrieve the partner's business assets that the partner has granted you access to.
 */
export const businessPartnerAssetAccessGet = <ThrowOnError extends boolean = false>(
  options: Options<BusinessPartnerAssetAccessGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    BusinessPartnerAssetAccessGetResponse,
    BusinessPartnerAssetAccessGetError,
    ThrowOnError
  >({
    ...options,
    url: '/businesses/{business_id}/partners/{partner_id}/assets',
  });
};

/**
 * Get business partners
 * Get all partners of the specified business.
 *
 * If the assets_summary=TRUE and:
 * - partner_type=INTERNAL, the business assets returned are your business assets the partner has access to.
 * - partner_type=EXTERNAL, the business assets returned are your partner's business assets the partner has granted you
 * access to.
 */
export const getBusinessPartners = <ThrowOnError extends boolean = false>(
  options: Options<GetBusinessPartnersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetBusinessPartnersResponse, GetBusinessPartnersError, ThrowOnError>({
    ...options,
    url: '/businesses/{business_id}/partners',
  });
};

/**
 * Terminate business partnerships
 * Terminate partnerships between the specified partners and your business.
 * Note: You may only batch terminate partners of the same partner type.
 */
export const deleteBusinessPartners = <ThrowOnError extends boolean = false>(
  options: Options<DeleteBusinessPartnersData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteBusinessPartnersResponse, DeleteBusinessPartnersError, ThrowOnError>({
    ...options,
    url: '/businesses/{business_id}/partners',
  });
};

/**
 * List received audiences for a business
 * Get a list of received audiences for the given business.
 */
export const sharedAudiencesForBusinessList = <ThrowOnError extends boolean = false>(
  options: Options<SharedAudiencesForBusinessListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    SharedAudiencesForBusinessListResponse,
    SharedAudiencesForBusinessListError,
    ThrowOnError
  >({
    ...options,
    url: '/businesses/{business_id}/audiences',
  });
};

/**
 * List accounts with access to an audience owned by a business
 * List all ad accounts and/or businesses that have access to a specific audience.
 * The audience must either be owned by an ad account in the requesting business, or it must have been shared with the requesting business.
 * If the requesting business is not the owner of the audience, only ad accounts owned by the requesting business will be returned.
 */
export const businessAccountAudiencesSharedAccountsList = <ThrowOnError extends boolean = false>(
  options: Options<BusinessAccountAudiencesSharedAccountsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    BusinessAccountAudiencesSharedAccountsListResponse,
    BusinessAccountAudiencesSharedAccountsListError,
    ThrowOnError
  >({
    ...options,
    url: '/businesses/{business_id}/audiences/shared/accounts',
  });
};

/**
 * Update audience sharing from a business to ad accounts
 * From a business, share a specific audience with other ad account(s), or revoke access to a previously shared audience. <ul> <li>If the business is the owner of the audience, it can share with any ad account within the same business hierarchy.</li> <li>If the business is the recipient of the audience, it can share with any of its owned ad accounts.</li> </ul> This endpoint is not available to all apps.<a href='/docs/getting-started/beta-and-advanced-access/'>Learn more</a>.
 */
export const updateBusinessToAdAccountSharedAudience = <ThrowOnError extends boolean = false>(
  options: Options<UpdateBusinessToAdAccountSharedAudienceData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    UpdateBusinessToAdAccountSharedAudienceResponse,
    UpdateBusinessToAdAccountSharedAudienceError,
    ThrowOnError
  >({
    ...options,
    url: '/businesses/{business_id}/audiences/ad_accounts/shared',
  });
};

/**
 * Update audience sharing between businesses
 * From a business, share a specific audience with another business account, or revoke access to a previously shared audience. Only the audience owner can share the audience with other businesses, and the recipient business must be within the same business hierarchy.<br> This endpoint is not available to all apps.<a href='/docs/getting-started/beta-and-advanced-access/'>Learn more</a>.
 */
export const updateBusinessToBusinessSharedAudience = <ThrowOnError extends boolean = false>(
  options: Options<UpdateBusinessToBusinessSharedAudienceData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    UpdateBusinessToBusinessSharedAudienceResponse,
    UpdateBusinessToBusinessSharedAudienceError,
    ThrowOnError
  >({
    ...options,
    url: '/businesses/{business_id}/audiences/businesses/shared',
  });
};

/**
 * Create a new asset group.
 * Create a new asset group with the specified parameters.
 * - An <a href="https://help.pinterest.com/en/business/article/asset-groups">asset group</a> is a custom group of assets based on how you’d like to manage your accounts.
 */
export const assetGroupCreate = <ThrowOnError extends boolean = false>(
  options: Options<AssetGroupCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AssetGroupCreateResponse, AssetGroupCreateError, ThrowOnError>({
    ...options,
    url: '/businesses/{business_id}/asset_groups',
  });
};

/**
 * Update asset groups.
 * Update a batch of asset groups with the specified parameters.
 */
export const assetGroupUpdate = <ThrowOnError extends boolean = false>(
  options: Options<AssetGroupUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<AssetGroupUpdateResponse, AssetGroupUpdateError, ThrowOnError>({
    ...options,
    url: '/businesses/{business_id}/asset_groups',
  });
};

/**
 * Delete asset groups.
 * Delete a batch of asset groups.
 */
export const assetGroupDelete = <ThrowOnError extends boolean = false>(
  options: Options<AssetGroupDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<AssetGroupDeleteResponse, AssetGroupDeleteError, ThrowOnError>({
    ...options,
    url: '/businesses/{business_id}/asset_groups',
  });
};

/**
 * List catalogs
 * Fetch catalogs owned by the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * <a href='/docs/api-features/shopping-overview/'>Learn more</a>
 */
export const catalogsList = <ThrowOnError extends boolean = false>(
  options?: Options<CatalogsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CatalogsListResponse, CatalogsListError, ThrowOnError>({
    ...options,
    url: '/catalogs',
  });
};

/**
 * Create catalog
 * Create a new catalog owned by the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * <a href='/docs/api-features/shopping-overview/'>Learn more</a>
 *
 * Note: this API only supports the catalog type of HOTEL for now.
 */
export const catalogsCreate = <ThrowOnError extends boolean = false>(
  options: Options<CatalogsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CatalogsCreateResponse, CatalogsCreateError, ThrowOnError>({
    ...options,
    url: '/catalogs',
  });
};

/**
 * List feeds
 * Fetch feeds owned by the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * For Retail partners, refer to <a href='https://help.pinterest.com/en/business/article/before-you-get-started-with-catalogs'>Before you get started with Catalogs</a>. For Hotel parterns, refer to <a href='/docs/api-features/shopping-overview/'>Pinterest API for shopping</a>.
 */
export const feedsList = <ThrowOnError extends boolean = false>(options?: Options<FeedsListData, ThrowOnError>) => {
  return (options?.client ?? client).get<FeedsListResponse, FeedsListError, ThrowOnError>({
    ...options,
    url: '/catalogs/feeds',
  });
};

/**
 * Create feed
 * Create a new feed owned by the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 *
 * Please, be aware that "default_country"
 * and "default_locale" are not required in the spec for forward compatibility
 * but for now the API will not accept requests without those fields.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * For Retail partners, refer to <a href='https://help.pinterest.com/en/business/article/before-you-get-started-with-catalogs'>Before you get started with Catalogs</a>. For Hotel parterns, refer to <a href='/docs/api-features/shopping-overview/'>Pinterest API for shopping</a>.
 *
 * Note: Access to the Creative Assets catalog type is restricted to a specific group of users.
 * If you require access, please reach out to your partner manager.
 */
export const feedsCreate = <ThrowOnError extends boolean = false>(options: Options<FeedsCreateData, ThrowOnError>) => {
  return (options?.client ?? client).post<FeedsCreateResponse, FeedsCreateError, ThrowOnError>({
    ...options,
    url: '/catalogs/feeds',
  });
};

/**
 * Get feed
 * Get a single feed owned by the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * For Retail partners, refer to <a href='https://help.pinterest.com/en/business/article/before-you-get-started-with-catalogs'>Before you get started with Catalogs</a>. For Hotel parterns, refer to <a href='/docs/api-features/shopping-overview/'>Pinterest API for shopping</a>.
 */
export const feedsGet = <ThrowOnError extends boolean = false>(options: Options<FeedsGetData, ThrowOnError>) => {
  return (options?.client ?? client).get<FeedsGetResponse, FeedsGetError, ThrowOnError>({
    ...options,
    url: '/catalogs/feeds/{feed_id}',
  });
};

/**
 * Update feed
 * Update a feed owned by the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * For Retail partners, refer to <a href='https://help.pinterest.com/en/business/article/before-you-get-started-with-catalogs'>Before you get started with Catalogs</a>. For Hotel parterns, refer to <a href='/docs/api-features/shopping-overview/'>Pinterest API for shopping</a>.
 *
 * Note: Access to the Creative Assets catalog type is restricted to a specific group of users.
 * If you require access, please reach out to your partner manager.
 */
export const feedsUpdate = <ThrowOnError extends boolean = false>(options: Options<FeedsUpdateData, ThrowOnError>) => {
  return (options?.client ?? client).patch<FeedsUpdateResponse, FeedsUpdateError, ThrowOnError>({
    ...options,
    url: '/catalogs/feeds/{feed_id}',
  });
};

/**
 * Delete feed
 * Delete a feed owned by the "operating user_account".
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * For Retail partners, refer to <a href='https://help.pinterest.com/en/business/article/before-you-get-started-with-catalogs'>Before you get started with Catalogs</a>. For Hotel parterns, refer to <a href='/docs/api-features/shopping-overview/'>Pinterest API for shopping</a>.
 */
export const feedsDelete = <ThrowOnError extends boolean = false>(options: Options<FeedsDeleteData, ThrowOnError>) => {
  return (options?.client ?? client).delete<FeedsDeleteResponse, FeedsDeleteError, ThrowOnError>({
    ...options,
    url: '/catalogs/feeds/{feed_id}',
  });
};

/**
 * Ingest feed items
 * Ingest items for a given feed owned by the "operation user_account".
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * <a href='/docs/api-features/shopping-overview/'>Learn more</a>
 *
 * Note: This endpoint is restricted to a specific group of users. If you require access, please reach out to your partner manager.
 */
export const feedsIngest = <ThrowOnError extends boolean = false>(options: Options<FeedsIngestData, ThrowOnError>) => {
  return (options?.client ?? client).post<FeedsIngestResponse, FeedsIngestError, ThrowOnError>({
    ...options,
    url: '/catalogs/feeds/{feed_id}/ingest',
  });
};

/**
 * List feed processing results
 * Fetch a feed processing results owned by the "operation user_account". Please note that for now the bookmark parameter is not functional and only the first page will be available until it is implemented in some release in the near future.
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * <a href='/docs/api-features/shopping-overview/'>Learn more</a>
 */
export const feedProcessingResultsList = <ThrowOnError extends boolean = false>(
  options: Options<FeedProcessingResultsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    FeedProcessingResultsListResponse,
    FeedProcessingResultsListError,
    ThrowOnError
  >({
    ...options,
    url: '/catalogs/feeds/{feed_id}/processing_results',
  });
};

/**
 * List item issues
 * List item validation issues for a given feed processing result owned by the "operation user_account". Up to 20 random samples of affected items are returned for each error and warning code. Please note that for now query parameters 'item_numbers' and 'item_validation_issue' cannot be used simultaneously until it is implemented in some release in the future.
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * Note: To get a list of all affected items instead of sampled issues, please refer to <a href='/docs/api/v5/#operation/reports/create'>Build catalogs report</a> and <a href='/docs/api/v5/#operation/reports/get'>Get catalogs report</a> endpoints. Moreover, they support multiple types of catalogs.
 *
 * <a href='/docs/api-features/shopping-overview/'>Learn more</a>
 */
export const itemsIssuesList = <ThrowOnError extends boolean = false>(
  options: Options<ItemsIssuesListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ItemsIssuesListResponse, ItemsIssuesListError, ThrowOnError>({
    ...options,
    url: '/catalogs/processing_results/{processing_result_id}/item_issues',
  });
};

/**
 * @deprecated
 * Get catalogs items
 * Get the items of the catalog owned by the "operation user_account". <a href="/docs/api-features/shopping-overview/#Update%20items%20in%20batch" target="_blank">See detailed documentation here.</a>
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * Note: this endpoint is deprecated and will be deleted soon. Please use <a href='/docs/api/v5/#operation/items/post'>Get catalogs items (POST)</a> instead.
 */
export const itemsGet = <ThrowOnError extends boolean = false>(options: Options<ItemsGetData, ThrowOnError>) => {
  return (options?.client ?? client).get<ItemsGetResponse, ItemsGetError, ThrowOnError>({
    ...options,
    url: '/catalogs/items',
  });
};

/**
 * Get catalogs items (POST)
 * Get the items of the catalog owned by the "operation user_account". <a href="/docs/api-features/shopping-overview/#Update%20items%20in%20batch" target="_blank">See detailed documentation here.</a>
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * Note: Access to the Creative Assets catalog type is restricted to a specific group of users.
 * If you require access, please reach out to your partner manager.
 */
export const itemsPost = <ThrowOnError extends boolean = false>(options: Options<ItemsPostData, ThrowOnError>) => {
  return (options?.client ?? client).post<ItemsPostResponse, ItemsPostError, ThrowOnError>({
    ...options,
    url: '/catalogs/items',
  });
};

/**
 * Operate on item batch
 * This endpoint supports multiple operations on a set of one or more catalog items owned by the "operation user_account". <a href="/docs/api-features/shopping-overview/#Update%20items%20in%20batch" target="_blank">See detailed documentation here.</a>
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * Note:
 * - Access to the Creative Assets catalog type is restricted to a specific group of users.
 * If you require access, please reach out to your partner manager.
 * - The item UPSERT operation is restricted to users without a feed data source. If you plan to migrate item ingestion from feeds to the API, please reach out to your partner manager to get assistance.
 */
export const itemsBatchPost = <ThrowOnError extends boolean = false>(
  options: Options<ItemsBatchPostData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ItemsBatchPostResponse, ItemsBatchPostError, ThrowOnError>({
    ...options,
    url: '/catalogs/items/batch',
  });
};

/**
 * Get item batch status
 * Get a single catalogs items batch owned by the "operating user_account". <a href="/docs/api-features/shopping-overview/#Update%20items%20in%20batch" target="_blank">See detailed documentation here.</a>
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 */
export const itemsBatchGet = <ThrowOnError extends boolean = false>(
  options: Options<ItemsBatchGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ItemsBatchGetResponse, ItemsBatchGetError, ThrowOnError>({
    ...options,
    url: '/catalogs/items/batch/{batch_id}',
  });
};

/**
 * Delete product groups
 * Delete product groups owned by the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * <a href='/docs/api-features/shopping-overview/'>Learn more</a>
 */
export const catalogsProductGroupsDeleteMany = <ThrowOnError extends boolean = false>(
  options: Options<CatalogsProductGroupsDeleteManyData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    CatalogsProductGroupsDeleteManyResponse,
    CatalogsProductGroupsDeleteManyError,
    ThrowOnError
  >({
    ...options,
    url: '/catalogs/product_groups/multiple',
  });
};

/**
 * Create product groups
 * Create product group to use in Catalogs owned by the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * <a href='/docs/api-features/shopping-overview/'>Learn more</a>
 *
 * Note: Access to the Creative Assets catalog type is restricted to a specific group of users.
 * If you require access, please reach out to your partner manager.
 */
export const catalogsProductGroupsCreateMany = <ThrowOnError extends boolean = false>(
  options: Options<CatalogsProductGroupsCreateManyData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CatalogsProductGroupsCreateManyResponse,
    CatalogsProductGroupsCreateManyError,
    ThrowOnError
  >({
    ...options,
    url: '/catalogs/product_groups/multiple',
  });
};

/**
 * List product groups
 * Get a list of product groups for a given Catalogs Feed Id owned by the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * <a href='/docs/api-features/shopping-overview/'>Learn more</a>
 */
export const catalogsProductGroupsList = <ThrowOnError extends boolean = false>(
  options?: Options<CatalogsProductGroupsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    CatalogsProductGroupsListResponse,
    CatalogsProductGroupsListError,
    ThrowOnError
  >({
    ...options,
    url: '/catalogs/product_groups',
  });
};

/**
 * Create product group
 * Create product group to use in Catalogs owned by the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * <a href='/docs/api-features/shopping-overview/'>Learn more</a>
 *
 * Note: Access to the Creative Assets catalog type is restricted to a specific group of users.
 * If you require access, please reach out to your partner manager.
 */
export const catalogsProductGroupsCreate = <ThrowOnError extends boolean = false>(
  options: Options<CatalogsProductGroupsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CatalogsProductGroupsCreateResponse,
    CatalogsProductGroupsCreateError,
    ThrowOnError
  >({
    ...options,
    url: '/catalogs/product_groups',
  });
};

/**
 * Get product group
 * Get a singe product group for a given Catalogs Product Group Id owned by the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * <a href='/docs/api-features/shopping-overview/'>Learn more</a>
 */
export const catalogsProductGroupsGet = <ThrowOnError extends boolean = false>(
  options: Options<CatalogsProductGroupsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CatalogsProductGroupsGetResponse, CatalogsProductGroupsGetError, ThrowOnError>(
    {
      ...options,
      url: '/catalogs/product_groups/{product_group_id}',
    },
  );
};

/**
 * Delete product group
 * Delete a product group owned by the "operation user_account" from being in use in Catalogs.
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * <a href='/docs/api-features/shopping-overview/'>Learn more</a>
 */
export const catalogsProductGroupsDelete = <ThrowOnError extends boolean = false>(
  options: Options<CatalogsProductGroupsDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    CatalogsProductGroupsDeleteResponse,
    CatalogsProductGroupsDeleteError,
    ThrowOnError
  >({
    ...options,
    url: '/catalogs/product_groups/{product_group_id}',
  });
};

/**
 * Update single product group
 * Update product group owned by the "operation user_account" to use in Catalogs.
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * <a href='/docs/api-features/shopping-overview/'>Learn more</a>
 *
 * Note: Access to the Creative Assets catalog type is restricted to a specific group of users.
 * If you require access, please reach out to your partner manager.
 */
export const catalogsProductGroupsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<CatalogsProductGroupsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    CatalogsProductGroupsUpdateResponse,
    CatalogsProductGroupsUpdateError,
    ThrowOnError
  >({
    ...options,
    url: '/catalogs/product_groups/{product_group_id}',
  });
};

/**
 * Get product counts
 * Get a product counts for a given Catalogs Product Group owned by the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * <a href='/docs/api-features/shopping-overview/'>Learn more</a>
 */
export const catalogsProductGroupsProductCountsGet = <ThrowOnError extends boolean = false>(
  options: Options<CatalogsProductGroupsProductCountsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    CatalogsProductGroupsProductCountsGetResponse,
    CatalogsProductGroupsProductCountsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/catalogs/product_groups/{product_group_id}/product_counts',
  });
};

/**
 * List products by product group
 * Get a list of product pins for a given Catalogs Product Group Id owned by the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * <a href='/docs/api-features/shopping-overview/'>Learn more</a>
 */
export const catalogsProductGroupPinsList = <ThrowOnError extends boolean = false>(
  options: Options<CatalogsProductGroupPinsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    CatalogsProductGroupPinsListResponse,
    CatalogsProductGroupPinsListError,
    ThrowOnError
  >({
    ...options,
    url: '/catalogs/product_groups/{product_group_id}/products',
  });
};

/**
 * List products by filter
 * List products Pins owned by the "operation user_account" that meet the criteria specified in the Catalogs Product Group Filter given in the request.
 * - This endpoint has been implemented in POST to allow for complex filters. This specific POST endpoint is designed to be idempotent.
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 *
 * Note: This endpoint only supports RETAIL catalog at the moment.
 *
 * <a href='/docs/api-features/shopping-overview/'>Learn more</a>
 */
export const productsByProductGroupFilterList = <ThrowOnError extends boolean = false>(
  options: Options<ProductsByProductGroupFilterListData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    ProductsByProductGroupFilterListResponse,
    ProductsByProductGroupFilterListError,
    ThrowOnError
  >({
    ...options,
    url: '/catalogs/products/get_by_product_group_filters',
  });
};

/**
 * Build catalogs report
 * Async request to create a report of the catalog owned by the "operation user_account". This endpoint generates a report upon receiving the first approved request of the day. Any following requests with identical parameters will yield the same report even if data has changed.
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 */
export const reportsCreate = <ThrowOnError extends boolean = false>(
  options: Options<ReportsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ReportsCreateResponse, ReportsCreateError, ThrowOnError>({
    ...options,
    url: '/catalogs/reports',
  });
};

/**
 * Get catalogs report
 * This returns a URL to a report given a token returned from <a href='/docs/api/v5/#operation/reports/create'>Build catalogs report</a>. You can use the URL to download the report.
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 */
export const reportsGet = <ThrowOnError extends boolean = false>(options: Options<ReportsGetData, ThrowOnError>) => {
  return (options?.client ?? client).get<ReportsGetResponse, ReportsGetError, ThrowOnError>({
    ...options,
    url: '/catalogs/reports',
  });
};

/**
 * List report stats
 * List aggregated numbers of issues for a catalog owned by the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account: Owner, Admin, Catalogs Manager.
 */
export const reportsStats = <ThrowOnError extends boolean = false>(
  options: Options<ReportsStatsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ReportsStatsResponse, ReportsStatsError, ThrowOnError>({
    ...options,
    url: '/catalogs/reports/stats',
  });
};

/**
 * Create commerce integration
 * Create commerce integration metadata to link an external business ID with a Pinterest merchant & ad account.
 * Note: If you're interested in joining the beta, please reach out to your Pinterest account manager.
 */
export const integrationsCommercePost = <ThrowOnError extends boolean = false>(
  options?: Options<IntegrationsCommercePostData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    IntegrationsCommercePostResponse,
    IntegrationsCommercePostError,
    ThrowOnError
  >({
    ...options,
    url: '/integrations/commerce',
  });
};

/**
 * Get commerce integration
 * Get commerce integration metadata associated with the given external business ID.
 * Note: If you're interested in joining the beta, please reach out to your Pinterest account manager.
 */
export const integrationsCommerceGet = <ThrowOnError extends boolean = false>(
  options: Options<IntegrationsCommerceGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<IntegrationsCommerceGetResponse, IntegrationsCommerceGetError, ThrowOnError>({
    ...options,
    url: '/integrations/commerce/{external_business_id}',
  });
};

/**
 * Update commerce integration
 * Update commerce integration metadata for the given external business ID.
 * Note: If you're interested in joining the beta, please reach out to your Pinterest account manager.
 */
export const integrationsCommercePatch = <ThrowOnError extends boolean = false>(
  options: Options<IntegrationsCommercePatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    IntegrationsCommercePatchResponse,
    IntegrationsCommercePatchError,
    ThrowOnError
  >({
    ...options,
    url: '/integrations/commerce/{external_business_id}',
  });
};

/**
 * Delete commerce integration
 * Delete commerce integration metadata for the given external business ID.
 * Note: If you're interested in joining the beta, please reach out to your Pinterest account manager.
 */
export const integrationsCommerceDel = <ThrowOnError extends boolean = false>(
  options: Options<IntegrationsCommerceDelData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    IntegrationsCommerceDelResponse,
    IntegrationsCommerceDelError,
    ThrowOnError
  >({
    ...options,
    url: '/integrations/commerce/{external_business_id}',
  });
};

/**
 * Receives batched logs from integration applications.
 * This endpoint receives batched logs from integration applications on partner platforms.
 * Note: If you're interested in joining the beta, please reach out to your Pinterest account manager.
 */
export const integrationsLogsPost = <ThrowOnError extends boolean = false>(
  options: Options<IntegrationsLogsPostData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<IntegrationsLogsPostResponse, IntegrationsLogsPostError, ThrowOnError>({
    ...options,
    url: '/integrations/logs',
  });
};

/**
 * Get integration metadata list
 * Get integration metadata list.
 * Note: If you're interested in joining the beta, please reach out to your Pinterest account manager.
 */
export const integrationsGetList = <ThrowOnError extends boolean = false>(
  options?: Options<IntegrationsGetListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<IntegrationsGetListResponse, IntegrationsGetListError, ThrowOnError>({
    ...options,
    url: '/integrations',
  });
};

/**
 * Get integration metadata
 * Get integration metadata by ID.
 * Note: If you're interested in joining the beta, please reach out to your Pinterest account manager.
 */
export const integrationsGetById = <ThrowOnError extends boolean = false>(
  options: Options<IntegrationsGetByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<IntegrationsGetByIdResponse, IntegrationsGetByIdError, ThrowOnError>({
    ...options,
    url: '/integrations/{id}',
  });
};

/**
 * List media uploads
 * List media uploads filtered by given parameters.
 *
 * <strong><a href='/docs/api-features/creating-boards-and-pins/#creating-video-pins'>Learn more</a></strong> about video Pin creation.
 */
export const mediaList = <ThrowOnError extends boolean = false>(options?: Options<MediaListData, ThrowOnError>) => {
  return (options?.client ?? client).get<MediaListResponse, MediaListError, ThrowOnError>({
    ...options,
    url: '/media',
  });
};

/**
 * Register media upload
 * Register your intent to upload media
 *
 * The response includes all of the information needed to upload the media
 * to Pinterest.
 *
 * To upload the media, make an HTTP POST request (using <tt>curl</tt>, for
 * example) to <tt>upload_url</tt> using the <tt>Content-Type</tt> header
 * value. Send the media file's contents as the request's <tt>file</tt>
 * parameter and also include all of the parameters from
 * <tt>upload_parameters</tt>.
 *
 * <strong><a href='/docs/api-features/creating-boards-and-pins/#creating-video-pins'>Learn more</a></strong> about video Pin creation.
 */
export const mediaCreate = <ThrowOnError extends boolean = false>(options: Options<MediaCreateData, ThrowOnError>) => {
  return (options?.client ?? client).post<MediaCreateResponse, MediaCreateError, ThrowOnError>({
    ...options,
    url: '/media',
  });
};

/**
 * Get media upload details
 * Get details for a registered media upload, including its current status.
 *
 * <strong><a href='/docs/api-features/creating-boards-and-pins/#creating-video-pins'>Learn more</a></strong> about video Pin creation.
 */
export const mediaGet = <ThrowOnError extends boolean = false>(options: Options<MediaGetData, ThrowOnError>) => {
  return (options?.client ?? client).get<MediaGetResponse, MediaGetError, ThrowOnError>({
    ...options,
    url: '/media/{media_id}',
  });
};

/**
 * Generate OAuth access token
 * Generate an OAuth access token by using an authorization code or a refresh token.
 *
 * IMPORTANT: You need to start the OAuth flow via www.pinterest.com/oauth before calling this endpoint (or have an existing refresh token).
 *
 * See <a href='/docs/getting-started/authentication-and-scopes/'>Authentication</a> for more.
 *
 * <strong>Parameter <i>refresh_on</i> and its corresponding response type <i>everlasting_refresh</i> are now available to all apps! Later this year, continuous refresh will become the default behavior (ie you will no longer need to send this parameter). <a href='/docs/getting-started/beta-and-advanced-access/'>Learn more</a>.</strong>
 *
 * <strong>Grant type <i>client_credentials</i> and its corresponding response type are not fully available. You will likely get a default error if you attempt to use this grant_type.</strong>
 */
export const oauthToken = <ThrowOnError extends boolean = false>(options: Options<OauthTokenData, ThrowOnError>) => {
  return (options?.client ?? client).post<OauthTokenResponse, OauthTokenError, ThrowOnError>({
    ...options,
    ...urlSearchParamsBodySerializer,
    headers: {
      'Content-Type': 'application/x-www-form-urlencoded',
      ...options?.headers,
    },
    url: '/oauth/token',
  });
};

/**
 * List Pins
 * Get a list of the Pins owned by the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 * - All Pins owned by the "operation user_account" are included, regardless of who owns the board they are on.
 * Optional: Business Access: Specify an ad_account_id to use the owner of that ad_account as the "operation user_account".
 *
 * Disclaimer: there are known performance issues when filtering by field <code>creative_type</code> and including protected pins. If your
 * request is timing out in this scenario we encourage you to use <a href='/docs/api/v5/#operation/boards/list_pins'>GET List Pins on Board</a>.
 */
export const pinsList = <ThrowOnError extends boolean = false>(options?: Options<PinsListData, ThrowOnError>) => {
  return (options?.client ?? client).get<PinsListResponse, PinsListError, ThrowOnError>({
    ...options,
    url: '/pins',
  });
};

/**
 * Create Pin
 * Create a Pin on a board or board section owned by the "operation user_account".
 *
 * Note: If the current "operation user_account" (defined by the access token) has access to another user's Ad Accounts via Pinterest Business Access, you can modify your request to make use of the current operation_user_account's permissions to those Ad Accounts by including the ad_account_id in the path parameters for the request (e.g. .../?ad_account_id=12345&...).
 *
 * - This function is intended solely for publishing new content created by the user. If you are interested in saving content created by others to your Pinterest boards, sometimes called 'curated content', please use our <a href='/docs/web-features/add-ons-overview/'>Save button</a> instead. For more tips on creating fresh content for Pinterest, review our <a href='/docs/api-features/content-overview/'>Content App Solutions Guide</a>.
 *
 * <strong><a href='/docs/api-features/creating-boards-and-pins/#creating-video-pins'>Learn more</a></strong> about video Pin creation.
 */
export const pinsCreate = <ThrowOnError extends boolean = false>(options: Options<PinsCreateData, ThrowOnError>) => {
  return (options?.client ?? client).post<PinsCreateResponse, PinsCreateError, ThrowOnError>({
    ...options,
    url: '/pins',
  });
};

/**
 * Get Pin
 * Get a Pin owned by the "operation user_account" - or on a group board that has been shared with this account.
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account:
 *
 * - For Pins on public or protected boards: Owner, Admin, Analyst, Campaign Manager.
 * - For Pins on secret boards: Owner, Admin.
 */
export const pinsGet = <ThrowOnError extends boolean = false>(options: Options<PinsGetData, ThrowOnError>) => {
  return (options?.client ?? client).get<PinsGetResponse, PinsGetError, ThrowOnError>({
    ...options,
    url: '/pins/{pin_id}',
  });
};

/**
 * Delete Pin
 * Delete a Pins owned by the "operation user_account" - or on a group board that has been shared with this account.
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account:
 *
 * - For Pins on public or protected boards: Owner, Admin, Analyst, Campaign Manager.
 * - For Pins on secret boards: Owner, Admin.
 */
export const pinsDelete = <ThrowOnError extends boolean = false>(options: Options<PinsDeleteData, ThrowOnError>) => {
  return (options?.client ?? client).delete<PinsDeleteResponse, PinsDeleteError, ThrowOnError>({
    ...options,
    url: '/pins/{pin_id}',
  });
};

/**
 * Update Pin
 * Update a pin owned by the "operating user_account".
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account:
 *
 * - For Pins on public or protected boards: Owner, Admin, Analyst, Campaign Manager.
 * - For Pins on secret boards: Owner, Admin.
 *
 * <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/getting-started/beta-and-advanced-access/'>Learn more</a>.</strong>
 */
export const pinsUpdate = <ThrowOnError extends boolean = false>(options: Options<PinsUpdateData, ThrowOnError>) => {
  return (options?.client ?? client).patch<PinsUpdateResponse, PinsUpdateError, ThrowOnError>({
    ...options,
    url: '/pins/{pin_id}',
  });
};

/**
 * Get Pin analytics
 * Get analytics for a Pin owned by the "operation user_account" - or on a group board that has been shared with this account.
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href="/docs/api/v5/#operation/ad_accounts/list">List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account:
 *
 * - For Pins on public or protected boards: Admin, Analyst.
 * - For Pins on secret boards: Admin.
 *
 * If Pin was created before <code>2023-03-20</code> lifetime metrics will only be available for Video and Idea Pin formats. Lifetime metrics are available for all Pin formats since then.
 */
export const pinsAnalytics = <ThrowOnError extends boolean = false>(
  options: Options<PinsAnalyticsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<PinsAnalyticsResponse, PinsAnalyticsError, ThrowOnError>({
    ...options,
    url: '/pins/{pin_id}/analytics',
  });
};

/**
 * Get multiple Pin analytics
 * <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/getting-started/beta-and-advanced-access/'>Learn more</a>.</strong>
 *
 * Get analytics for multiple pins owned by the "operation user_account" - or on a group board that has been shared with this account.
 * - The maximum number of pins supported in a single request is 100.
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href="/docs/api/v5/#operation/ad_accounts/list">List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account:
 *
 * - For Pins on public or protected boards: Admin, Analyst.
 * - For Pins on secret boards: Admin.
 *
 * If Pin was created before <code>2023-03-20</code> lifetime metrics will only be available for Video and Idea Pin formats. Lifetime metrics are available for all Pin formats since then.
 */
export const multiPinsAnalytics = <ThrowOnError extends boolean = false>(
  options: Options<MultiPinsAnalyticsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<MultiPinsAnalyticsResponse, MultiPinsAnalyticsError, ThrowOnError>({
    ...options,
    url: '/pins/analytics',
  });
};

/**
 * Save Pin
 * Save a Pin on a board or board section owned by the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 * Optional: Business Access: Specify an <code>ad_account_id</code> (obtained via <a href='/docs/api/v5/#operation/ad_accounts/list'>List ad accounts</a>) to use the owner of that ad_account as the "operation user_account". In order to do this, the token user_account must have one of the following <a href="https://help.pinterest.com/en/business/article/share-and-manage-access-to-your-ad-accounts">Business Access</a> roles on the ad_account:
 *
 * - For Pins on public or protected boards: Owner, Admin, Analyst, Campaign Manager.
 * - For Pins on secret boards: Owner, Admin.
 *
 * - Any Pin type can be saved: image Pin, video Pin, Idea Pin, product Pin, etc.
 * - Any public Pin can be saved given a pin ID.
 */
export const pinsSave = <ThrowOnError extends boolean = false>(options: Options<PinsSaveData, ThrowOnError>) => {
  return (options?.client ?? client).post<PinsSaveResponse, PinsSaveError, ThrowOnError>({
    ...options,
    url: '/pins/{pin_id}/save',
  });
};

/**
 * Get ad accounts countries
 * Get Ad Accounts countries
 */
export const adAccountCountriesGet = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AdAccountCountriesGetResponse, AdAccountCountriesGetError, ThrowOnError>({
    ...options,
    url: '/resources/ad_account_countries',
  });
};

/**
 * Get available metrics' definitions
 * Get the definitions for ads and organic metrics available across both synchronous and asynchronous report endpoints.
 * The `display_name` attribute will match how the metric is named in our native tools like Ads Manager.
 * See <a href='/docs/api-features/analytics-overview/'>Organic Analytics</a> and <a href='/docs/api-features/ads-reporting/'>Ads Analytics</a> for more information.
 */
export const deliveryMetricsGet = <ThrowOnError extends boolean = false>(
  options?: Options<DeliveryMetricsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DeliveryMetricsGetResponse, DeliveryMetricsGetError, ThrowOnError>({
    ...options,
    url: '/resources/delivery_metrics',
  });
};

/**
 * Get lead form questions
 * Get a list of all lead form question type names. Some questions might not be used.
 *
 * <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/getting-started/beta-and-advanced-access/'>Learn more</a>.</strong>
 */
export const leadFormQuestionsGet = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).get<LeadFormQuestionsGetResponse, LeadFormQuestionsGetError, ThrowOnError>({
    ...options,
    url: '/resources/lead_form_questions',
  });
};

/**
 * Get metrics ready state
 * Learn whether conversion or non-conversion metrics are finalized and ready to query.
 */
export const metricsReadyStateGet = <ThrowOnError extends boolean = false>(
  options: Options<MetricsReadyStateGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<MetricsReadyStateGetResponse, MetricsReadyStateGetError, ThrowOnError>({
    ...options,
    url: '/resources/metrics_ready_state',
  });
};

/**
 * Get interest details
 * <p>Get details of a specific interest given interest ID.</p> <p>Click <a href="https://docs.google.com/spreadsheets/d/1HxL-0Z3p2fgxis9YBP2HWC3tvPrs1hAuHDRtH-NJTIM/edit#gid=118370875" target="_blank">here</a> for a spreadsheet listing interests and their IDs.</p>
 */
export const interestTargetingOptionsGet = <ThrowOnError extends boolean = false>(
  options: Options<InterestTargetingOptionsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    InterestTargetingOptionsGetResponse,
    InterestTargetingOptionsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/resources/targeting/interests/{interest_id}',
  });
};

/**
 * Get targeting options
 * <p>You can use targeting values in ads placement to define your intended audience. </p> <p>Targeting metrics are organized around targeting specifications.</p> <p>For more information on ads targeting, see <a class="reference external" href="https://help.pinterest.com/en/business/article/audience-targeting" target="_blank">Audience targeting</a>.</p>
 * <p><b>Sample return:</b></p> <pre class="literal-block"> [{&quot;36313&quot;: &quot;Australia: Moreton Bay - North&quot;, &quot;124735&quot;: &quot;Canada: North Battleford&quot;, &quot;36109&quot;: &quot;Australia: Murray&quot;, &quot;36108&quot;: &quot;Australia: Mid North Coast&quot;, &quot;36101&quot;: &quot;Australia: Capital Region&quot;, &quot;811&quot;: &quot;U.S.: Reno&quot;, &quot;36103&quot;: &quot;Australia: Central West&quot;, &quot;36102&quot;: &quot;Australia: Central Coast&quot;, &quot;36105&quot;: &quot;Australia: Far West and Orana&quot;, &quot;36104&quot;: &quot;Australia: Coffs Harbour - Grafton&quot;, &quot;36107&quot;: &quot;Australia: Illawarra&quot;, &quot;36106&quot;: &quot;Australia: Hunter Valley Exc Newcastle&quot;, &quot;554017&quot;: &quot;New Zealand: Wanganui&quot;, &quot;554016&quot;: &quot;New Zealand: Marlborough&quot;, &quot;554015&quot;: &quot;New Zealand: Gisborne&quot;, &quot;554014&quot;: &quot;New Zealand: Tararua&quot;, &quot;554013&quot;: &quot;New Zealand: Invercargill&quot;, &quot;GR&quot;: &quot;Greece&quot;, &quot;554011&quot;: &quot;New Zealand: Whangarei&quot;, &quot;554010&quot;: &quot;New Zealand: Far North&quot;, &quot;717&quot;: &quot;U.S.: Quincy-Hannibal-Keokuk&quot;, &quot;716&quot;: &quot;U.S.: Baton Rouge&quot;,...}] </pre>
 */
export const targetingOptionsGet = <ThrowOnError extends boolean = false>(
  options: Options<TargetingOptionsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<TargetingOptionsGetResponse, TargetingOptionsGetError, ThrowOnError>({
    ...options,
    url: '/resources/targeting/{targeting_type}',
  });
};

/**
 * Search user's boards
 * Search for boards for the "operation user_account". This includes boards of all board types.
 * - By default, the "operation user_account" is the token user_account.
 *
 * If using Business Access: Specify an ad_account_id to use the owner of that ad_account as the "operation user_account". See <a href='/docs/getting-started/using-business-access/'>Understanding Business Access</a> for more information.
 */
export const searchUserBoardsGet = <ThrowOnError extends boolean = false>(
  options?: Options<SearchUserBoardsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<SearchUserBoardsGetResponse, SearchUserBoardsGetError, ThrowOnError>({
    ...options,
    url: '/search/boards',
  });
};

/**
 * Search user's Pins
 * Search for pins for the "operation user_account".
 * - By default, the "operation user_account" is the token user_account.
 *
 * If using Business Access: Specify an ad_account_id to use the owner of that ad_account as the "operation user_account". See <a href='/docs/getting-started/using-business-access/'>Understanding Business Access</a> for more information.
 */
export const searchUserPinsList = <ThrowOnError extends boolean = false>(
  options: Options<SearchUserPinsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<SearchUserPinsListResponse, SearchUserPinsListError, ThrowOnError>({
    ...options,
    url: '/search/pins',
  });
};

/**
 * Search pins by a given search term
 * <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/getting-started/beta-and-advanced-access/'>Learn more</a>.</strong>
 *
 * Get the top 10 Pins by a given search term.
 */
export const searchPartnerPins = <ThrowOnError extends boolean = false>(
  options: Options<SearchPartnerPinsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<SearchPartnerPinsResponse, SearchPartnerPinsError, ThrowOnError>({
    ...options,
    url: '/search/partner/pins',
  });
};

/**
 * List related terms
 * Get a list of terms logically related to each input term. <p/>
 * Example: the term 'workout' would list related terms like 'one song workout', 'yoga workout', 'workout motivation', etc.
 */
export const termsRelatedList = <ThrowOnError extends boolean = false>(
  options: Options<TermsRelatedListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<TermsRelatedListResponse, TermsRelatedListError, ThrowOnError>({
    ...options,
    url: '/terms/related',
  });
};

/**
 * List suggested terms
 * Get popular search terms that begin with your input term. <p/>
 * Example: 'sport' would return popular terms like 'sports bar' and 'sportswear', but not 'motor sports' since the phrase does not begin with the given term.
 */
export const termsSuggestedList = <ThrowOnError extends boolean = false>(
  options: Options<TermsSuggestedListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<TermsSuggestedListResponse, TermsSuggestedListError, ThrowOnError>({
    ...options,
    url: '/terms/suggested',
  });
};

/**
 * List trending keywords
 * <p>Get the top trending search keywords among the Pinterest user audience.</p> <p>Trending keywords can be used to inform ad targeting, budget strategy, and creative decisions about which products and Pins will resonate with your audience.</p> <p>Geographic, demographic and interest-based filters are available to narrow down to the top trends among a specific audience. Multiple trend types are supported that can be used to identify newly-popular, evergreen or seasonal keywords.</p> <p>For an interactive way to explore this data, please visit <a href="https://trends.pinterest.com">trends.pinterest.com</a>.
 *
 */
export const trendingKeywordsList = <ThrowOnError extends boolean = false>(
  options: Options<TrendingKeywordsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<TrendingKeywordsListResponse, TrendingKeywordsListError, ThrowOnError>({
    ...options,
    url: '/trends/keywords/{region}/top/{trend_type}',
  });
};

/**
 * Get user account
 * Get account information for the "operation user_account"
 * - By default, the "operation user_account" is the token user_account.
 *
 * If using Business Access: Specify an ad_account_id to use the owner of that ad_account as the "operation user_account". See <a href='/docs/getting-started/using-business-access/'>Understanding Business Access</a> for more information.
 */
export const userAccountGet = <ThrowOnError extends boolean = false>(
  options?: Options<UserAccountGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UserAccountGetResponse, UserAccountGetError, ThrowOnError>({
    ...options,
    url: '/user_account',
  });
};

/**
 * Get user account analytics
 * Get analytics for the "operation user_account"
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an ad_account_id to use the owner of that ad_account as the "operation user_account".
 */
export const userAccountAnalytics = <ThrowOnError extends boolean = false>(
  options: Options<UserAccountAnalyticsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UserAccountAnalyticsResponse, UserAccountAnalyticsError, ThrowOnError>({
    ...options,
    url: '/user_account/analytics',
  });
};

/**
 * Get user account top pins analytics
 * Gets analytics data about a user's top pins (limited to the top 50).
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an ad_account_id to use the owner of that ad_account as the "operation user_account".
 */
export const userAccountAnalyticsTopPins = <ThrowOnError extends boolean = false>(
  options: Options<UserAccountAnalyticsTopPinsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    UserAccountAnalyticsTopPinsResponse,
    UserAccountAnalyticsTopPinsError,
    ThrowOnError
  >({
    ...options,
    url: '/user_account/analytics/top_pins',
  });
};

/**
 * Get user account top video pins analytics
 * Gets analytics data about a user's top video pins (limited to the top 50).
 * - By default, the "operation user_account" is the token user_account.
 *
 * Optional: Business Access: Specify an ad_account_id to use the owner of that ad_account as the "operation user_account".
 */
export const userAccountAnalyticsTopVideoPins = <ThrowOnError extends boolean = false>(
  options: Options<UserAccountAnalyticsTopVideoPinsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    UserAccountAnalyticsTopVideoPinsResponse,
    UserAccountAnalyticsTopVideoPinsError,
    ThrowOnError
  >({
    ...options,
    url: '/user_account/analytics/top_video_pins',
  });
};

/**
 * List linked businesses
 * Get a list of your linked business accounts.
 */
export const linkedBusinessAccountsGet = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    LinkedBusinessAccountsGetResponse,
    LinkedBusinessAccountsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/user_account/businesses',
  });
};

/**
 * List followers
 * Get a list of your followers.
 */
export const followersList = <ThrowOnError extends boolean = false>(
  options?: Options<FollowersListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<FollowersListResponse, FollowersListError, ThrowOnError>({
    ...options,
    url: '/user_account/followers',
  });
};

/**
 * List following
 * Get a list of who a certain user follows.
 */
export const userFollowingGet = <ThrowOnError extends boolean = false>(
  options?: Options<UserFollowingGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UserFollowingGetResponse, UserFollowingGetError, ThrowOnError>({
    ...options,
    url: '/user_account/following',
  });
};

/**
 * List following boards
 * Get a list of the boards a user follows. The request returns a board summary object array.
 */
export const boardsUserFollowsList = <ThrowOnError extends boolean = false>(
  options?: Options<BoardsUserFollowsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<BoardsUserFollowsListResponse, BoardsUserFollowsListError, ThrowOnError>({
    ...options,
    url: '/user_account/following/boards',
  });
};

/**
 * Follow user
 * <strong>This endpoint is currently in beta and not available to all apps. <a href='/docs/getting-started/beta-and-advanced-access/'>Learn more</a>.</strong>
 *
 * Use this request, as a signed-in user, to follow another user.
 */
export const followUserUpdate = <ThrowOnError extends boolean = false>(
  options: Options<FollowUserUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<FollowUserUpdateResponse, FollowUserUpdateError, ThrowOnError>({
    ...options,
    url: '/user_account/following/{username}',
  });
};

/**
 * Verify website
 * Verify a website as a signed-in user.
 */
export const verifyWebsiteUpdate = <ThrowOnError extends boolean = false>(
  options: Options<VerifyWebsiteUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<VerifyWebsiteUpdateResponse, VerifyWebsiteUpdateError, ThrowOnError>({
    ...options,
    url: '/user_account/websites',
  });
};

/**
 * Get user websites
 * Get user websites, claimed or not
 */
export const userWebsitesGet = <ThrowOnError extends boolean = false>(
  options?: Options<UserWebsitesGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<UserWebsitesGetResponse, UserWebsitesGetError, ThrowOnError>({
    ...options,
    url: '/user_account/websites',
  });
};

/**
 * Unverify website
 * Unverifu a website verified by the signed-in user.
 */
export const unverifyWebsiteDelete = <ThrowOnError extends boolean = false>(
  options: Options<UnverifyWebsiteDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<UnverifyWebsiteDeleteResponse, UnverifyWebsiteDeleteError, ThrowOnError>({
    ...options,
    url: '/user_account/websites',
  });
};

/**
 * Get user verification code for website claiming
 * Get verification code for user to install on the website to claim it.
 */
export const websiteVerificationGet = <ThrowOnError extends boolean = false>(
  options?: Options<WebsiteVerificationGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<WebsiteVerificationGetResponse, WebsiteVerificationGetError, ThrowOnError>({
    ...options,
    url: '/user_account/websites/verification',
  });
};

/**
 * List following interests
 * Get a list of a user's following interests in one place.
 */
export const userAccountFollowedInterests = <ThrowOnError extends boolean = false>(
  options: Options<UserAccountFollowedInterestsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    UserAccountFollowedInterestsResponse,
    UserAccountFollowedInterestsError,
    ThrowOnError
  >({
    ...options,
    url: '/users/{username}/interests/follow',
  });
};
