// This file is auto-generated by @hey-api/openapi-ts

export const AccountSchema = {
  type: 'object',
  readOnly: true,
  properties: {
    account_type: {
      description: 'Type of account',
      type: 'string',
      enum: ['PINNER', 'BUSINESS'],
    },
    id: {
      description: 'User account ID.',
      type: 'string',
      pattern: '^\\d+$',
      example: '2783136121146311751',
    },
    profile_image: {
      type: 'string',
    },
    website_url: {
      type: 'string',
    },
    username: {
      type: 'string',
    },
    about: {
      description: 'Profile about description.',
      type: 'string',
    },
    business_name: {
      type: 'string',
      nullable: true,
    },
    board_count: {
      type: 'integer',
      readOnly: true,
      nullable: true,
      example: 14,
      description:
        'User account board count.<br/>**Note**: Board count on user account level may differ from counts found elsewhere due to attribution of collaborative Boards.',
    },
    pin_count: {
      type: 'integer',
      readOnly: true,
      nullable: true,
      example: 339,
      description: 'User account pin count. This includes both created and saved pins.',
    },
    follower_count: {
      type: 'integer',
      readOnly: true,
      nullable: true,
      example: 10,
      description: 'User account follower count.',
    },
    following_count: {
      type: 'integer',
      readOnly: true,
      nullable: true,
      example: 347,
      description: 'User account following count.',
    },
    monthly_views: {
      type: 'integer',
      readOnly: true,
      nullable: true,
      example: 163,
      description: 'User account monthly views.',
    },
  },
} as const;

export const ActionTypeSchema = {
  type: 'string',
  description: 'Ad group billable event type. For update, only draft ad groups may update billable event.',
  example: 'CLICKTHROUGH',
  enum: ['CLICKTHROUGH', 'IMPRESSION', 'VIDEO_V_50_MRC'],
} as const;

export const AdAccountSchema = {
  type: 'object',
  readOnly: true,
  properties: {
    id: {
      type: 'string',
    },
    name: {
      type: 'string',
    },
    owner: {
      title: 'Ad account owner',
      type: 'object',
      properties: {
        username: {
          type: 'string',
          description: 'Public username for the user account',
        },
        id: {
          type: 'string',
          description: "The owning account's user ID.",
        },
      },
    },
    country: {
      $ref: '#/components/schemas/Country',
    },
    currency: {
      $ref: '#/components/schemas/Currency',
    },
    permissions: {
      title: 'permissions',
      type: 'array',
      items: {
        $ref: '#/components/schemas/BusinessAccessRole',
        nullable: true,
      },
    },
    created_time: {
      description: 'Creation time. Unix timestamp in seconds.',
      example: 1451431341,
      nullable: true,
      title: 'created_time',
      type: 'integer',
    },
    updated_time: {
      description: 'Last update time. Unix timestamp in seconds.',
      example: 1451431341,
      nullable: true,
      title: 'updated_time',
      type: 'integer',
    },
  },
} as const;

export const AdAccountAnalyticsResponseSchema = {
  type: 'array',
  items: {
    type: 'object',
    properties: {
      AD_ACCOUNT_ID: {
        description: 'The ID of the advertiser that this metrics belongs to.',
        type: 'string',
        pattern: '^\\d+$',
      },
      DATE: {
        description:
          'Current metrics date. Only returned when granularity is a time-based value (`DAY`, `HOUR`, `WEEK`, `MONTH`)',
        type: 'string',
        format: 'date',
      },
    },
    required: ['AD_ACCOUNT_ID'],
    additionalProperties: true,
    example: {
      DATE: '2021-04-01',
      AD_ACCOUNT_ID: '547602124502',
      SPEND_IN_DOLLAR: 30,
      TOTAL_CLICKTHROUGH: 216,
    },
  },
} as const;

export const AdAccountCreateRequestSchema = {
  title: 'AdAccountCreate',
  type: 'object',
  example: {
    country: 'US',
    owner_user_id: '383791336903426391',
    name: 'ACME Tools',
  },
  properties: {
    country: {
      $ref: '#/components/schemas/Country',
    },
    name: {
      description: 'Ad Account name.',
      example: 'ACME Tools',
      maxLength: 256,
      title: 'name',
      type: 'string',
    },
    owner_user_id: {
      description: "Advertiser's owning user ID.",
      example: '383791336903426391',
      pattern: '^\\d+$',
      title: 'owner_user_id',
      type: 'string',
    },
  },
} as const;

export const AdAccountCreateSubscriptionRequestSchema = {
  title: 'AdAccountCreateSubscriptionRequest',
  type: 'object',
  example: {
    webhook_url: 'https://webhook.example.com/xyz',
    lead_form_id: '383791336903426390',
  },
  properties: {
    webhook_url: {
      description: 'Standard HTTPS webhook URL.',
      example: 'https://webhook.example.com/xyz',
      title: 'webhook_url',
      type: 'string',
    },
    lead_form_id: {
      description: 'Lead form ID.',
      example: '383791336903426390',
      title: 'Lead form ID',
      type: 'string',
      pattern: '^\\d+$',
    },
    partner_access_token: {
      description:
        'Partner access token. Only for clients that requires authentication. We recommend to avoid this param.',
      type: 'string',
    },
    partner_refresh_token: {
      description:
        'Partner refresh token. Only for clients that requires authentication. We recommend to avoid this param.',
      type: 'string',
    },
    partner_metadata: {
      description:
        'Partner metadata. Only for clients that requires special handling. We recommend to avoid this param.',
      type: 'object',
      properties: {
        subscriber_key: {
          description: 'Text field value that uniquely identifies a subscriber.',
          type: 'string',
        },
      },
    },
  },
  required: ['webhook_url'],
} as const;

export const AdAccountCreateSubscriptionResponseSchema = {
  title: 'AdAccountCreateSubscriptionResponse',
  type: 'object',
  properties: {
    id: {
      description: 'Subscription ID.',
      example: '8078432025948590686',
      type: 'string',
      pattern: '^\\d+$',
    },
    cryptographic_key: {
      description: 'Base64 encoded key for client to decrypt lead data.',
      example: 'ucvxbV2Tdss0vNeYsdh4Qfa/1Khm2b0PqXvXeTTZh54',
      type: 'string',
      nullable: true,
    },
    cryptographic_algorithm: {
      description: 'Lead data encryption algorithm.',
      example: 'AES-256-GCM',
      type: 'string',
      nullable: true,
    },
    created_time: {
      description: 'Subscription creation time. Unix timestamp in milliseconds.',
      example: 1699209842000,
      type: 'integer',
    },
  },
} as const;

export const AdAccountGetSubscriptionResponseSchema = {
  title: 'AdAccountGetSubscriptionsResponse',
  type: 'object',
  allOf: [
    {
      type: 'object',
      description: 'Lead ads subscription response common fields.',
      properties: {
        lead_form_id: {
          description: 'Lead form ID.',
          example: '383791336903426390',
          type: 'string',
          pattern: '^\\d+$',
          nullable: true,
        },
        webhook_url: {
          description: 'Standard HTTPS webhook URL.',
          example: 'https://webhook.example.com/xyz',
          type: 'string',
        },
      },
    },
    {
      type: 'object',
      properties: {
        id: {
          description: 'Subscription ID.',
          example: '8078432025948590686',
          type: 'string',
          pattern: '^\\d+$',
        },
        user_account_id: {
          description: 'User account used to subscribe lead data.',
          example: '549755885175',
          type: 'string',
          pattern: '^\\d+$',
        },
        ad_account_id: {
          description: 'The Ad Account ID that this lead form belongs to.',
          example: '549755885176',
          type: 'string',
          pattern: '^\\d+$',
        },
        api_version: {
          description: 'API version.',
          example: 'v5',
          type: 'string',
        },
        cryptographic_key: {
          description: 'Base64 encoded key for client to decrypt lead data.',
          example: 'ucvxbV2Tdss0vNeYsdh4Qfa/1Khm2b0PqXvXeTTZh54',
          type: 'string',
          nullable: true,
        },
        cryptographic_algorithm: {
          description: 'Lead data encryption algorithm.',
          example: 'AES-256-GCM',
          type: 'string',
          nullable: true,
        },
        created_time: {
          description: 'Lead form creation time. Unix timestamp in milliseconds.',
          example: 1699209842000,
          type: 'integer',
        },
      },
    },
  ],
} as const;

export const AdAccountsCountryResponseSchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AdAccountsCountryResponseData',
      },
    },
  },
} as const;

export const AdAccountsCountryResponseDataSchema = {
  type: 'object',
  properties: {
    code: {
      $ref: '#/components/schemas/AdCountry',
      type: 'string',
    },
    currency: {
      description: 'Country currency.',
      example: 'Dollars',
      type: 'string',
    },
    index: {
      type: 'number',
      description: 'Country index',
      example: 1,
    },
    name: {
      type: 'string',
      description: 'Country name',
      example: 'United States of America',
    },
  },
} as const;

export const AdArrayResponseSchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AdArrayResponseElement',
      },
    },
  },
  title: 'AdArrayResponse',
} as const;

export const AdArrayResponseElementSchema = {
  type: 'object',
  properties: {
    data: {
      $ref: '#/components/schemas/AdResponse',
    },
    exceptions: {
      $ref: '#/components/schemas/Exception',
    },
  },
} as const;

export const AdCommonSchema = {
  type: 'object',
  description: 'Creation fields',
  properties: {
    ad_group_id: {
      description: 'ID of the ad group that contains the ad.',
      example: '2680059592705',
      type: 'string',
      pattern: '^(AG)?\\d+$',
    },
    android_deep_link: {
      description: 'Deep link URL for Android devices.',
      nullable: true,
      type: 'string',
    },
    carousel_android_deep_links: {
      description: 'Comma-separated deep links for the carousel pin on Android.',
      type: 'array',
      nullable: true,
      items: {
        type: 'string',
      },
    },
    carousel_destination_urls: {
      description: 'Comma-separated destination URLs for the carousel pin to promote.',
      type: 'array',
      nullable: true,
      items: {
        type: 'string',
      },
    },
    carousel_ios_deep_links: {
      description: 'Comma-separated deep links for the carousel pin on iOS.',
      type: 'array',
      nullable: true,
      items: {
        type: 'string',
      },
    },
    click_tracking_url: {
      description: 'Tracking url for the ad clicks.',
      type: 'string',
      nullable: true,
    },
    creative_type: {
      $ref: '#/components/schemas/CreativeType',
    },
    destination_url: {
      description: 'Destination URL.',
      type: 'string',
      nullable: true,
    },
    ios_deep_link: {
      description: 'Deep link URL for iOS devices.',
      type: 'string',
      nullable: true,
    },
    is_pin_deleted: {
      description: 'Is original pin deleted?',
      example: false,
      type: 'boolean',
    },
    is_removable: {
      description: 'Is pin repinnable?',
      example: false,
      type: 'boolean',
    },
    name: {
      description: 'Name of the ad - 255 chars max.',
      type: 'string',
      nullable: true,
    },
    status: {
      $ref: '#/components/schemas/EntityStatus',
    },
    tracking_urls: {
      type: 'object',
      allOf: [
        {
          $ref: '#/components/schemas/TrackingUrls',
        },
      ],
      nullable: true,
    },
    view_tracking_url: {
      description: 'Tracking URL for ad impressions.',
      type: 'string',
      nullable: true,
    },
    lead_form_id: {
      description: 'Lead form ID for lead ad generation.',
      type: 'string',
      pattern: '^(AG)?\\d+$',
      nullable: true,
    },
    grid_click_type: {
      $ref: '#/components/schemas/GridClickType',
    },
    customizable_cta_type: {
      type: 'string',
      description:
        'Select a call to action (CTA) to display below your ad. Available only for ads with direct links enabled. CTA options for consideration and conversion campaigns are LEARN_MORE, SHOP_NOW, BOOK_NOW, SIGN_UP, VISIT_SITE, BUY_NOW, GET_OFFER, ORDER_NOW, ADD_TO_CART (for conversion campaigns with add to cart conversion events only)',
      example: 'LEARN_MORE',
      nullable: true,
      enum: [
        'GET_OFFER',
        'LEARN_MORE',
        'ORDER_NOW',
        'SHOP_NOW',
        'SIGN_UP',
        'SUBSCRIBE',
        'BUY_NOW',
        'CONTACT_US',
        'GET_QUOTE',
        'VISIT_SITE',
        'APPLY_NOW',
        'BOOK_NOW',
        'REQUEST_DEMO',
        'REGISTER_NOW',
        'FIND_A_DEALER',
        'ADD_TO_CART',
        'WATCH_NOW',
        'READ_MORE',
        null,
      ],
    },
    quiz_pin_data: {
      type: 'object',
      allOf: [
        {
          $ref: '#/components/schemas/QuizPinData',
        },
      ],
      description:
        'Before creating a quiz ad, you must create an organic Pin using POST/Create Pin for each result in the quiz. Quiz ads cannot be saved by a Pinner. Quiz ad results can be saved.',
      nullable: true,
    },
  },
} as const;

export const AdCountrySchema = {
  type: 'string',
  description: 'Country ID from ISO 3166-1 alpha-2.',
  example: 'US',
  enum: [
    'AD',
    'AE',
    'AF',
    'AG',
    'AI',
    'AL',
    'AM',
    'AO',
    'AQ',
    'AR',
    'AS',
    'AT',
    'AU',
    'AW',
    'AX',
    'AZ',
    'BA',
    'BB',
    'BD',
    'BE',
    'BF',
    'BG',
    'BH',
    'BI',
    'BJ',
    'BL',
    'BM',
    'BN',
    'BO',
    'BQ',
    'BR',
    'BS',
    'BT',
    'BV',
    'BW',
    'BY',
    'BZ',
    'CA',
    'CC',
    'CD',
    'CF',
    'CG',
    'CH',
    'CI',
    'CK',
    'CL',
    'CM',
    'CN',
    'CO',
    'CR',
    'CU',
    'CV',
    'CW',
    'CX',
    'CY',
    'CZ',
    'DE',
    'DJ',
    'DK',
    'DM',
    'DO',
    'DZ',
    'EC',
    'EE',
    'EG',
    'EH',
    'ER',
    'ES',
    'ET',
    'FI',
    'FJ',
    'FK',
    'FM',
    'FO',
    'FR',
    'GA',
    'GB',
    'GD',
    'GE',
    'GF',
    'GG',
    'GH',
    'GI',
    'GL',
    'GM',
    'GN',
    'GP',
    'GQ',
    'GR',
    'GS',
    'GT',
    'GU',
    'GW',
    'GY',
    'HK',
    'HM',
    'HN',
    'HR',
    'HT',
    'HU',
    'ID',
    'IE',
    'IL',
    'IM',
    'IN',
    'IO',
    'IQ',
    'IR',
    'IS',
    'IT',
    'JE',
    'JM',
    'JO',
    'JP',
    'KE',
    'KG',
    'KH',
    'KI',
    'KM',
    'KN',
    'KR',
    'KW',
    'KY',
    'KZ',
    'LA',
    'LB',
    'LC',
    'LI',
    'LK',
    'LR',
    'LS',
    'LT',
    'LU',
    'LV',
    'LY',
    'MA',
    'MC',
    'MD',
    'ME',
    'MF',
    'MG',
    'MH',
    'MK',
    'ML',
    'MM',
    'MN',
    'MO',
    'MP',
    'MQ',
    'MR',
    'MS',
    'MT',
    'MU',
    'MV',
    'MW',
    'MX',
    'MY',
    'MZ',
    'NA',
    'NC',
    'NE',
    'NF',
    'NG',
    'NI',
    'NL',
    'NO',
    'NP',
    'NR',
    'NU',
    'NZ',
    'OM',
    'PA',
    'PE',
    'PF',
    'PG',
    'PH',
    'PK',
    'PL',
    'PM',
    'PN',
    'PR',
    'PS',
    'PT',
    'PW',
    'PY',
    'QA',
    'RE',
    'RO',
    'RS',
    'RU',
    'RW',
    'SA',
    'SB',
    'SC',
    'SD',
    'SE',
    'SG',
    'SH',
    'SI',
    'SJ',
    'SK',
    'SL',
    'SM',
    'SN',
    'SO',
    'SR',
    'SS',
    'ST',
    'SV',
    'SX',
    'SY',
    'SZ',
    'TC',
    'TD',
    'TF',
    'TG',
    'TH',
    'TJ',
    'TK',
    'TL',
    'TM',
    'TN',
    'TO',
    'TR',
    'TT',
    'TV',
    'TW',
    'TZ',
    'UA',
    'UG',
    'UM',
    'US',
    'UY',
    'UZ',
    'VA',
    'VC',
    'VE',
    'VG',
    'VI',
    'VN',
    'VU',
    'WF',
    'WS',
    'YE',
    'YT',
    'ZA',
    'ZM',
    'ZW',
  ],
} as const;

export const AdCreateRequestSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/AdCommon',
    },
    {
      $ref: '#/components/schemas/AdPinId',
    },
    {
      type: 'object',
      title: 'Request schema for creating ads',
      required: ['ad_group_id', 'pin_id', 'creative_type'],
    },
  ],
} as const;

export const AdvancedAuctionItemsGetRequestSchema = {
  type: 'object',
  description: 'Request object used to get bid options values for a batch of retail catalog items',
  additionalProperties: false,
  properties: {
    catalog_id: {
      description: 'Catalog id pertaining to the retail item',
      example: '2680059592705',
      type: 'string',
      pattern: '^\\d+$',
    },
    items: {
      type: 'array',
      minItems: 1,
      maxItems: 10000,
      description: 'A list of retail catalog items to fetch bid options for',
      items: {
        $ref: '#/components/schemas/AdvancedAuctionItemsGetRecord',
      },
    },
  },
  required: ['catalog_id', 'items'],
} as const;

export const AdvancedAuctionItemsGetRecordSchema = {
  description: 'Object uniquely identifying a retail catalog item',
  allOf: [
    {
      $ref: '#/components/schemas/AdvancedAuctionKey',
    },
  ],
} as const;

export const AdvancedAuctionItemsSchema = {
  type: 'object',
  description: 'Response object containing item bid options',
  properties: {
    catalog_id: {
      description: 'Response object of item bid options',
      example: '2680059592705',
      type: 'string',
      pattern: '^\\d+$',
    },
    items: {
      type: 'array',
      description: 'Array with item bid options',
      items: {
        $ref: '#/components/schemas/AdvancedAuctionItem',
      },
    },
  },
} as const;

export const AdvancedAuctionItemsSubmitRequestSchema = {
  type: 'object',
  description:
    'Request containing operations to perform on bid prices and bid multipliers for a batch of retail catalog items',
  additionalProperties: false,
  properties: {
    catalog_id: {
      description: 'Catalog id pertaining to all items',
      example: '2680059592705',
      type: 'string',
      pattern: '^\\d+$',
    },
    items: {
      type: 'array',
      minItems: 1,
      maxItems: 10000,
      description: 'Array of item bid option operations',
      items: {
        $ref: '#/components/schemas/AdvancedAuctionItemsSubmitRecord',
      },
    },
  },
  required: ['catalog_id', 'items'],
} as const;

export const AdvancedAuctionItemsSubmitRecordSchema = {
  type: 'object',
  description: 'Object describing an item bid option operation',
  oneOf: [
    {
      $ref: '#/components/schemas/AdvancedAuctionItemsSubmitUpsertRecord',
    },
    {
      $ref: '#/components/schemas/AdvancedAuctionItemsSubmitDeleteRecord',
    },
  ],
  discriminator: {
    propertyName: 'operation',
    mapping: {
      UPSERT: '#/components/schemas/AdvancedAuctionItemsSubmitUpsertRecord',
      DELETE: '#/components/schemas/AdvancedAuctionItemsSubmitDeleteRecord',
    },
  },
  properties: {
    operation: {
      $ref: '#/components/schemas/AdvancedAuctionOperation',
    },
  },
  required: ['operation'],
} as const;

export const AdvancedAuctionItemsSubmitUpsertRecordSchema = {
  description: 'Object describing an item bid option upsert operation',
  example: {
    item_id: 'DS0294-M',
    country: 'US',
    language: 'EN',
    operation: 'UPSERT',
    bid_options: {
      bid_in_micro_currency: 5000000,
      app_type_multipliers: {
        android_mobile: 1.1,
        android_tablet: 1.1,
        ipad: 1.2,
        iphone: 1.2,
        web: 0.9,
        web_mobile: 0.8,
      },
    },
    update_mask: ['BID', 'APP_TYPE_BID_MULTIPLIER_SET'],
  },
  allOf: [
    {
      $ref: '#/components/schemas/AdvancedAuctionItem',
    },
    {
      type: 'object',
      properties: {
        update_mask: {
          type: 'array',
          description:
            'The list of item bid option fields to be set or updated. Fields specified in the updated mask without a value specified in the `bid_options` object in the body will be set to `null`. If an item bid option record is being created, fields not specified in the update mask will be initialized to `null`.',
          example: ['BID', 'APP_TYPE_BID_MULTIPLIER_SET'],
          nullable: true,
          items: {
            $ref: '#/components/schemas/UpdateMaskBidOptionField',
          },
        },
      },
      required: ['update_mask'],
    },
  ],
} as const;

export const AdvancedAuctionItemsSubmitDeleteRecordSchema = {
  description: 'Object describing an item bid option deletion operation',
  example: {
    item_id: 'DS0294-M',
    country: 'US',
    language: 'EN',
    operation: 'DELETE',
  },
  allOf: [
    {
      $ref: '#/components/schemas/AdvancedAuctionKey',
    },
  ],
} as const;

export const AdvancedAuctionProcessedItemsSchema = {
  type: 'object',
  description: 'Response object containing the results of an operation on an item bid option',
  properties: {
    catalog_id: {
      description: 'Catalog id pertaining to all items',
      example: '2680059592705',
      type: 'string',
      pattern: '^\\d+$',
    },
    items: {
      type: 'array',
      description: 'Array of advanced auction processed items',
      items: {
        $ref: '#/components/schemas/AdvancedAuctionProcessedItem',
      },
    },
  },
} as const;

export const AdvancedAuctionProcessedItemSchema = {
  description: 'Object describing the result of an operation on an item bid option',
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/AdvancedAuctionItemsSubmitRecord',
    },
    {
      type: 'object',
      properties: {
        errors: {
          type: 'array',
          description: `Array with validation errors for the supplied item bid option modification operation.
A non empty errors list means this single item operation was not applied.`,
          items: {
            $ref: '#/components/schemas/AdvancedAuctionOperationError',
          },
        },
      },
    },
  ],
} as const;

export const AdvancedAuctionItemSchema = {
  title: 'Advanced Auction Item',
  allOf: [
    {
      $ref: '#/components/schemas/AdvancedAuctionKey',
    },
    {
      type: 'object',
      properties: {
        bid_options: {
          $ref: '#/components/schemas/AdvancedAuctionBidOptions',
        },
      },
      required: ['bid_options'],
    },
  ],
} as const;

export const AdvancedAuctionKeySchema = {
  type: 'object',
  description: 'Object uniquely identifying a retail catalog item',
  properties: {
    item_id: {
      description: 'The catalog retail item id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    country: {
      $ref: '#/components/schemas/Country',
    },
    language: {
      $ref: '#/components/schemas/Language',
    },
  },
  required: ['item_id', 'country', 'language'],
} as const;

export const AdvancedAuctionOperationSchema = {
  type: 'string',
  enum: ['UPSERT', 'DELETE'],
} as const;

export const AdvancedAuctionBidOptionsSchema = {
  type: 'object',
  description: "Object describing a retail catalog item's bid options (bid price and bid multipliers).",
  properties: {
    bid_in_micro_currency: {
      $ref: '#/components/schemas/BidInMicroCurrency',
    },
    app_type_multipliers: {
      $ref: '#/components/schemas/AppTypeMultipliers',
    },
    placement_multipliers: {
      $ref: '#/components/schemas/PlacementMultipliers',
    },
  },
} as const;

export const AdvancedAuctionOperationErrorSchema = {
  description: 'Error which occurred when applying a bid options operation to a specific item.',
  type: 'object',
  properties: {
    code: {
      description: 'The error code for the item bid option operation validation error',
      type: 'integer',
      example: 6,
    },
    message: {
      description: 'Message describing the item bid option operation validation error',
      type: 'string',
      example: 'Bid in micro currency should be non-negative',
    },
  },
} as const;

export const BidInMicroCurrencySchema = {
  type: 'integer',
  format: 'int64',
  description:
    "Bid price in micro currency. A value of 0 will stop distribution for this item in `MAX_BID` ad groups in `CATALOG_SALES` campaigns. A value of `null` will fallback to the ad group's `bid_in_micro_currency`.",
  example: 5000000,
  nullable: true,
} as const;

export const AppTypeMultipliersSchema = {
  type: 'object',
  description: `This represents a mapping from app type targeting criteria to a bid price adjustment.

Multiplier values must be between 0 and 10. A value of 10 represents a 900% increase in bid price (from $1 to $10 for example). A value of 0 will stop distribution for this item on the specified app type in \`MAX_BID\` ad groups in \`CATALOG_SALES\` campaigns. All app type multipliers must be set at the same time. If a multiplier is not provided it is assumed to be 1 (no bid adjustment).`,
  example: {
    android_mobile: 1.1,
    android_tablet: 1.1,
    ipad: 1.2,
    iphone: 1.2,
    web: 0.9,
    web_mobile: 0.8,
  },
  properties: {
    APP_TYPE: {
      $ref: '#/components/schemas/TargetingSpecAppType',
    },
  },
  additionalProperties: {
    type: 'number',
    format: 'double',
  },
  nullable: true,
} as const;

export const TargetingSpecAppTypeSchema = {
  type: 'string',
  enum: ['android_mobile', 'android_tablet', 'ipad', 'iphone', 'web', 'web_mobile'],
} as const;

export const PlacementMultipliersSchema = {
  type: 'object',
  description: `This represents a mapping from placement to a bid price adjustment.

Multiplier values must be between 0 and 10. A value of 10 represents a 900% increase in bid price (from $1 to $10 for example). A value of 0 will stop distribution for this item on the specified placement in \`MAX_BID\` ad groups in \`CATALOG_SALES\` campaigns. All placement multipliers must be set at the same time. If a multiplier is not provided it is assumed to be 1 (no bid adjustment).`,
  example: {
    browse: 0.9,
    search: 1.2,
  },
  properties: {
    PLACEMENT: {
      type: 'string',
      enum: ['SEARCH', 'BROWSE'],
    },
  },
  additionalProperties: {
    type: 'number',
    format: 'double',
  },
  nullable: true,
} as const;

export const UpdateMaskBidOptionFieldSchema = {
  type: 'string',
  description: 'bid option field to apply operation updates to',
  example: 'BID',
  enum: ['BID', 'APP_TYPE_BID_MULTIPLIER_SET', 'PLACEMENT_BID_MULTIPLIER_SET'],
} as const;

export const AdGroupArrayResponseSchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AdGroupArrayResponseElement',
      },
    },
  },
} as const;

export const AdGroupArrayResponseElementSchema = {
  type: 'object',
  properties: {
    data: {
      $ref: '#/components/schemas/AdGroupResponse',
    },
    exceptions: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/Exception',
      },
    },
  },
} as const;

export const AdGroupCommonSchema = {
  type: 'object',
  properties: {
    name: {
      description: 'Ad group name.',
      type: 'string',
      example: 'Ad Group For Pin: 687195905986',
    },
    status: {
      type: 'string',
      allOf: [
        {
          $ref: '#/components/schemas/EntityStatus',
        },
      ],
      description: 'Ad group/entity status.',
    },
    budget_in_micro_currency: {
      description:
        'Budget in micro currency. This field is **REQUIRED** for non-CBO (campaign budget optimization) campaigns.  A CBO campaign automatically generates ad group budgets from its campaign budget to maximize campaign outcome. A CBO campaign is limited to 70 or less ad groups.',
      type: 'integer',
      example: 5000000,
      nullable: true,
    },
    bid_in_micro_currency: {
      description:
        'Bid price in micro currency. This field is **REQUIRED** for the following campaign objective_type/billable_event combinations: AWARENESS/IMPRESSION, CONSIDERATION/CLICKTHROUGH, CATALOG_SALES/CLICKTHROUGH, VIDEO_VIEW/VIDEO_V_50_MRC.',
      type: 'integer',
      example: 5000000,
      nullable: true,
    },
    optimization_goal_metadata: {
      type: 'object',
      allOf: [
        {
          $ref: '#/components/schemas/OptimizationGoalMetadata',
        },
      ],
      description: `Optimization goals for objective-based performance campaigns. **REQUIRED** when campaign's \`objective_type\` is set to \`"WEB_CONVERSION"\`.`,
      nullable: true,
    },
    budget_type: {
      type: 'string',
      allOf: [
        {
          $ref: '#/components/schemas/BudgetType',
        },
      ],
    },
    start_time: {
      description: 'Ad group start time. Unix timestamp in seconds. Defaults to current time.',
      type: 'integer',
      example: 5686848000,
      nullable: true,
    },
    end_time: {
      description: 'Ad group end time. Unix timestamp in seconds.',
      type: 'integer',
      example: 5705424000,
      nullable: true,
    },
    targeting_spec: {
      $ref: '#/components/schemas/TargetingSpec',
    },
    lifetime_frequency_cap: {
      description:
        'Set a limit to the number of times a promoted pin from this campaign can be impressed by a pinner within the past rolling 30 days. Only available for CPM (cost per mille (1000 impressions))  ad groups. A CPM ad group has an IMPRESSION <a href="/docs/redoc/#section/Billable-event">billable_event</a> value. This field **REQUIRES** the `end_time` field.',
      type: 'integer',
      example: 100,
    },
    tracking_urls: {
      type: 'object',
      allOf: [
        {
          $ref: '#/components/schemas/TrackingUrls',
        },
      ],
      description:
        'Third-party tracking URLs.<br> JSON object with the format: {"<a href="/docs/redoc/#section/Tracking-URL-event">Tracking event enum</a>":[URL string array],...}<br> For example: {"impression": ["URL1", "URL2"], "click": ["URL1", "URL2", "URL3"]}.<br>Up to three tracking URLs are supported for each event type. Tracking URLs set at the ad group or ad level can override those set at the campaign level. May be null. Pass in an empty object - {} - to remove tracking URLs.<br><br> For more information, see <a href="https://help.pinterest.com/en/business/article/third-party-and-dynamic-tracking" target="_blank">Third-party and dynamic tracking</a>.',
      nullable: true,
    },
    auto_targeting_enabled: {
      type: 'boolean',
      description:
        'Enable auto-targeting for ad group. Also known as <a href="https://help.pinterest.com/en/business/article/expanded-targeting" target="_blank">"expanded targeting"</a>.',
      example: true,
      nullable: true,
    },
    placement_group: {
      type: 'string',
      allOf: [
        {
          $ref: '#/components/schemas/PlacementGroupType',
        },
      ],
      description: '<a href="/docs/redoc/#section/Placement-group">Placement group</a>.',
    },
    pacing_delivery_type: {
      type: 'string',
      allOf: [
        {
          $ref: '#/components/schemas/PacingDeliveryType',
        },
      ],
    },
    campaign_id: {
      description: 'Campaign ID of the ad group.',
      type: 'string',
      pattern: '^[C]?\\d+$',
      example: '626736533506',
    },
    billable_event: {
      $ref: '#/components/schemas/ActionType',
    },
    bid_strategy_type: {
      nullable: true,
      description:
        'Bid strategy type. For Campaigns with Video Completion objectives, the only supported bid strategy type is AUTOMATIC_BID.',
      enum: ['AUTOMATIC_BID', 'MAX_BID', 'TARGET_AVG', null],
      example: 'MAX_BID',
      title: 'BidStrategyType',
      type: 'string',
    },
    targeting_template_ids: {
      type: 'array',
      description:
        "Targeting template IDs applied to the ad group. We currently only support 1 targeting template per ad group. To use targeting templates, do not set any other targeting fields: targeting_spec, tracking_urls, auto_targeting_enabled, placement_group. To clear all targeting template IDs, set this field to ['0'].",
      items: {
        description: 'Targeting template ID.',
        type: 'string',
        pattern: '^\\d+$',
        example: '643',
      },
      maxItems: 1,
      nullable: true,
    },
  },
} as const;

export const AdGroupCreateRequestSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/AdGroupCommon',
    },
    {
      type: 'object',
      properties: {
        pacing_delivery_type: {
          type: 'string',
          allOf: [
            {
              $ref: '#/components/schemas/PacingDeliveryType',
            },
          ],
          default: 'STANDARD',
        },
        auto_targeting_enabled: {
          type: 'boolean',
          allOf: [
            {
              type: 'boolean',
              description:
                'Enable auto-targeting for ad group.Default value is True. Also known as <a href="https://help.pinterest.com/en/business/article/expanded-targeting" target="_blank">"expanded targeting"</a>.',
              example: true,
            },
          ],
        },
        budget_type: {
          type: 'string',
          allOf: [
            {
              $ref: '#/components/schemas/BudgetType',
            },
          ],
          default: 'DAILY',
        },
      },
      required: ['billable_event', 'campaign_id', 'name'],
    },
  ],
} as const;

export const AdGroupResponseSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/AdGroupCommon',
    },
    {
      type: 'object',
      properties: {
        id: {
          description: 'Ad group ID.',
          type: 'string',
          pattern: '^\\d+$',
          example: '2680060704746',
        },
        ad_account_id: {
          description: 'Advertiser ID.',
          type: 'string',
          pattern: '^\\d+$',
          example: '549755885175',
        },
        created_time: {
          description: 'Ad group creation time. Unix timestamp in seconds.',
          type: 'integer',
          example: 1476477189,
        },
        updated_time: {
          description: 'Ad group last update time. Unix timestamp in seconds.',
          type: 'integer',
          example: 1476477189,
        },
        type: {
          description: 'Always "adgroup".',
          type: 'string',
          default: 'adgroup',
        },
        conversion_learning_mode_type: {
          type: 'string',
          description: 'oCPM learn mode',
          example: 'ACTIVE',
          nullable: true,
          enum: ['NOT_ACTIVE', 'ACTIVE', null],
        },
        summary_status: {
          type: 'string',
          allOf: [
            {
              $ref: '#/components/schemas/AdGroupSummaryStatus',
            },
          ],
          description: 'Ad group summary status.',
        },
        feed_profile_id: {
          description: 'Feed Profile ID associated to the adgroup.',
          type: 'string',
          example: '626736533506',
        },
        dca_assets: {
          description:
            '[DCA] The Dynamic creative assets to use for DCA. Dynamic Creative Assembly (DCA) accepts basic creative assets of an ad (image, video, title, call to action, logo etc). Then it automatically generates optimized ad combinations based on these assets.',
        },
      },
    },
  ],
} as const;

export const AdGroupSummaryStatusSchema = {
  type: 'string',
  description: 'Summary status for ad group',
  example: 'RUNNING',
  enum: ['RUNNING', 'PAUSED', 'NOT_STARTED', 'COMPLETED', 'ADVERTISER_DISABLED', 'ARCHIVED', 'DRAFT', 'DELETED_DRAFT'],
} as const;

export const AdGroupUpdateRequestSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/AdGroupCommon',
    },
    {
      type: 'object',
      properties: {
        id: {
          description: 'Ad group ID.',
          type: 'string',
          pattern: '^\\d+$',
          example: '2680060704746',
        },
      },
      required: ['id'],
    },
  ],
} as const;

export const AdGroupsAnalyticsResponseSchema = {
  type: 'array',
  items: {
    type: 'object',
    properties: {
      AD_GROUP_ID: {
        description: 'The ID of the ad group that this metrics belongs to.',
        type: 'string',
        pattern: '^\\d+$',
      },
      DATE: {
        description:
          'Current metrics date. Only returned when granularity is a time-based value (`DAY`, `HOUR`, `WEEK`, `MONTH`)',
        type: 'string',
        format: 'date',
      },
    },
    required: ['AD_GROUP_ID'],
    additionalProperties: true,
    example: {
      DATE: '2021-04-01',
      AD_GROUP_ID: '547602124502',
      SPEND_IN_DOLLAR: 30,
      TOTAL_CLICKTHROUGH: 216,
    },
  },
} as const;

export const AdGroupAudienceSizingRequestSchema = {
  type: 'object',
  properties: {
    auto_targeting_enabled: {
      type: 'boolean',
      description:
        'Enable auto-targeting for ad group. Also known as <a href="https://help.pinterest.com/en/business/article/expanded-targeting" target="_blank">"expanded targeting"</a>.',
      example: true,
      default: true,
    },
    placement_group: {
      type: 'string',
      allOf: [
        {
          $ref: '#/components/schemas/PlacementGroupType',
        },
      ],
      default: 'ALL',
      description: '<a href="/docs/redoc/#section/Placement-group">Placement group</a>.',
    },
    creative_types: {
      description:
        'Pin creative types filter. </p><strong>Note:</strong> SHOP_THE_PIN has been deprecated. Please use COLLECTION instead.',
      type: 'array',
      items: {
        type: 'string',
        example: 'REGULAR',
        enum: ['REGULAR', 'VIDEO', 'SHOPPING', 'CAROUSEL', 'MAX_VIDEO', 'SHOP_THE_PIN', 'COLLECTION', 'IDEA'],
      },
      nullable: true,
    },
    targeting_spec: {
      $ref: '#/components/schemas/TargetingSpec',
    },
    product_group_ids: {
      type: 'array',
      items: {
        type: 'string',
        pattern: '^\\d+$',
        example: '23423422123',
      },
      description:
        'Targeted product group IDs. </p><strong>Note:</strong> This can only be combined with shopping/catalog sales campaigns. For more information, <a href="https://help.pinterest.com/en/business/article/shopping-ads#section-14571" target="_blank">click here</a>. SHOPPING_RETARGETING must be included in targeting_spec object or this field will be ignored.',
      nullable: true,
    },
    keywords: {
      type: 'array',
      description: 'Array of keyword objects. If the keywords field is missing, all keywords will be targeted.',
      items: {
        type: 'object',
        properties: {
          match_type: {
            $ref: '#/components/schemas/MatchTypeResponse',
          },
          value: {
            type: 'string',
            description: 'Keyword value (120 chars max).',
          },
        },
        required: ['match_type', 'value'],
      },
      nullable: true,
    },
  },
} as const;

export const AdGroupAudienceSizingResponseSchema = {
  type: 'object',
  properties: {
    audience_size_lower_bound: {
      description:
        'The lower confidence bound of the estimated potential audience size. "Potential audience size" estimates the number of people you may be able to reach per month with your campaign. It is based on historical advertising data and the targeting criteria you select. It does not guarantee results or take into account factors such as bid, budget, schedule, seasonality or product experiments.',
      type: 'number',
      example: 100000,
    },
    audience_size_upper_bound: {
      description:
        'The upper confidence bound of the estimated potential audience size. "Potential audience size" estimates the number of people you may be able to reach per month with your campaign. It is based on historical advertising data and the targeting criteria you select. It does not guarantee results or take into account factors such as bid, budget, schedule, seasonality or product experiments.',
      type: 'number',
      example: 150000,
    },
  },
} as const;

export const AdPinIdSchema = {
  type: 'object',
  properties: {
    pin_id: {
      description: 'Pin ID.',
      example: '394205773611545468',
      type: 'string',
      pattern: '^\\d+$',
    },
  },
} as const;

export const AdPreviewRequestSchema = {
  oneOf: [
    {
      example: {
        image_url: 'https://somewebsite.com/someimage.jpg',
        title: 'My Preview Image',
      },
      properties: {
        image_url: {
          description: 'Image URL.',
          example: 'https://somewebsite.com/someimage.jpg',
          title: 'image_url',
          type: 'string',
        },
        title: {
          description: 'Title displayed below ad.',
          example: 'My Preview Image',
          title: 'title',
          type: 'string',
        },
      },
      required: ['image_url', 'title'],
      title: 'AdPreviewCreateFromImage',
      type: 'object',
    },
    {
      example: {
        pin_id: '7389479023',
      },
      properties: {
        pin_id: {
          description: 'Pin ID.',
          example: '7389479023',
          title: 'pin_id',
          type: 'string',
        },
      },
      required: ['pin_id'],
      title: 'AdPreviewCreateFromPin',
      type: 'object',
    },
  ],
} as const;

export const AdPreviewURLResponseSchema = {
  example: {
    url: 'https://ads.pinterest.com/ad-preview/58f1a0e9ab0bd0f99462a0e4c5dd7e8297888c8a36331e88f757abe8f0295d31/',
  },
  properties: {
    url: {
      description: `'Preview URL, expires in 7 days. Can be used in an iframe.
For example: https://ads.pinterest.com/ad-preview/74667c814dd2b19/
The preview object ID/key is the last param - 74667c814dd2b19'`,
      example: 'https://ads.pinterest.com/ad-preview/58f1a0e9ab0bd0f99462a0e4c5dd7e8297888c8a36331e88f757abe8f0295d31/',
      title: 'url',
      type: 'string',
    },
  },
  title: 'AdPreviewURLResponse',
  type: 'object',
} as const;

export const AdResponseSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/AdCommon',
    },
    {
      $ref: '#/components/schemas/AdPinId',
    },
    {
      type: 'object',
      properties: {
        ad_account_id: {
          description: 'The ID of the advertiser that this ad belongs to.',
          example: '549755885175',
          type: 'string',
          pattern: '^\\d+$',
        },
        campaign_id: {
          description: 'ID of the ad campaign that contains this ad.',
          example: '626735565838',
          type: 'string',
          pattern: '^\\d+$',
        },
        collection_items_destination_url_template: {
          description: 'Destination URL template for all items within a collections drawer.',
          type: 'string',
          nullable: true,
        },
        created_time: {
          description: 'Pin creation time. Unix timestamp in seconds.',
          example: 1451431341,
          type: 'integer',
        },
        id: {
          description: 'The ID of this ad.',
          example: '687195134316',
          type: 'string',
          pattern: '^\\d+$',
        },
        rejected_reasons: {
          description: 'Enum reason why the pin was rejected. Returned if <code>review_status</code> is "REJECTED".',
          type: 'array',
          items: {
            type: 'string',
            description: 'ad disapproval reasons',
            enum: [
              'HASHTAGS',
              'PROMOTIONS_AND_PRICES',
              'TARGETING',
              'LANDING_PAGE',
              'CAPS_AND_SYMBOLS',
              'SHOCKING',
              'WEIGHT_LOSS',
              'PROHIBITED_PRODUCT',
              'AUTHENTICITY',
              'NUDITY',
              'CONFUSING_DESIGN',
              'URGENCY',
              'RATINGS',
              'APP',
              'ALCOHOL',
              'CONTESTS',
              'POLITICAL',
              'OTHER',
              'IMAGE',
              'NAR',
              'INCONSISTENT',
              'CLICKBAIT',
              'NO_DESCRIPTION',
              'LOW_QUALITY',
              'EXAGGERATED_CLAIMS',
              'PINTEREST_BRAND',
              'ALCOHOL_NO_SALE',
              'LANDING_PAGE_SPEED',
              'LANDING_PAGE_HARDWALL',
              'LANDING_PAGE_BROKEN',
              'LANDING_PAGE_QUALITY',
              'OUT_OF_STOCK',
              'IMAGE_LOW_QUALITY',
              'IMAGE_BUSY',
              'IMAGE_POORLY_EDITED',
              'IMAGE_BEFORE_AFTER',
              'UGC',
              'FAKE_BUTTONS',
              'WEAPONS',
              'SENSITIVE',
              'UNACCEPTABLE_BUSINESS',
              'SUSPICIOUS_CLAIMS',
              'PHARMA',
              'SUSPICIOUS_SUPPLEMENTS',
              'ILLEGAL_RECREATIONAL_DRUG',
              'LOW_QUALITY_LANDING_PAGE',
              'RESTRICTED_HEALTHCARE',
              'INCONSISTENT_LANG_FR',
            ],
          },
        },
        rejection_labels: {
          description: 'Text reason why the pin was rejected. Returned if <code>review_status</code> is "REJECTED".',
          type: 'array',
          items: {
            type: 'string',
          },
        },
        review_status: {
          type: 'string',
          description: 'Ad review status',
          example: 'PENDING',
          enum: ['OTHER', 'PENDING', 'REJECTED', 'APPROVED'],
        },
        type: {
          description: 'Always "ad".',
          example: 'pinpromotion',
          type: 'string',
        },
        updated_time: {
          description: 'Last update time. Unix timestamp in seconds.',
          example: 1451431341,
          type: 'integer',
        },
        summary_status: {
          type: 'string',
          allOf: [
            {
              $ref: '#/components/schemas/PinPromotionSummaryStatus',
            },
          ],
          description: 'Ad summary status',
        },
      },
    },
  ],
} as const;

export const AdUpdateRequestSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/AdCommon',
    },
    {
      type: 'object',
      title: 'AdUpdateRequest',
      properties: {
        id: {
          type: 'string',
          example: '687195134316',
          pattern: '^\\d+$',
          description: 'The ID of this ad.',
          title: 'id',
        },
        pin_id: {
          type: 'string',
          description: 'Pin ID. This field may only be updated for draft ads.',
          example: '394205773611545468',
          pattern: '^\\d+$',
          nullable: true,
        },
      },
      required: ['id'],
    },
  ],
} as const;

export const AdsAnalyticsAdTargetingTypeSchema = {
  type: 'string',
  description: 'Reporting targeting type for ads',
  example: 'APPTYPE',
  enum: [
    'KEYWORD',
    'APPTYPE',
    'GENDER',
    'LOCATION',
    'PLACEMENT',
    'COUNTRY',
    'TARGETED_INTEREST',
    'PINNER_INTEREST',
    'AUDIENCE_INCLUDE',
    'GEO',
    'AGE_BUCKET',
    'REGION',
    'QUIZ_RESULT',
    'AGE_BUCKET_AND_GENDER',
  ],
} as const;

export const AdsAnalyticsCampaignTargetingTypeSchema = {
  type: 'string',
  description: 'Reporting targeting type for campaigns',
  example: 'APPTYPE',
  enum: [
    'KEYWORD',
    'APPTYPE',
    'GENDER',
    'LOCATION',
    'PLACEMENT',
    'COUNTRY',
    'TARGETED_INTEREST',
    'PINNER_INTEREST',
    'AUDIENCE_INCLUDE',
    'GEO',
    'AGE_BUCKET',
    'REGION',
    'CREATIVE_TYPE',
    'AGE_BUCKET_AND_GENDER',
  ],
} as const;

export const AdsAnalyticsCreateAsyncRequestSchema = {
  type: 'object',
  allOf: [
    {
      type: 'object',
      properties: {
        start_date: {
          description: 'Metric report start date (UTC). Format: YYYY-MM-DD',
          type: 'string',
          pattern: '^(\\d{4})-(\\d{2})-(\\d{2})$',
          example: '2020-12-20',
        },
        end_date: {
          description: 'Metric report end date (UTC). Format: YYYY-MM-DD',
          type: 'string',
          pattern: '^(\\d{4})-(\\d{2})-(\\d{2})$',
          example: '2020-12-20',
        },
        granularity: {
          description:
            'TOTAL - metrics are aggregated over the specified date range.<br> DAY - metrics are broken down daily.<br> HOUR - metrics are broken down hourly.<br>WEEKLY - metrics are broken down weekly.<br>MONTHLY - metrics are broken down monthly',
          type: 'string',
          allOf: [
            {
              $ref: '#/components/schemas/Granularity',
            },
          ],
        },
        click_window_days: {
          description:
            'Number of days to use as the conversion attribution window for a pin click action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.',
          type: 'integer',
          allOf: [
            {
              $ref: '#/components/schemas/ConversionAttributionWindowDays',
            },
          ],
          default: 30,
        },
        engagement_window_days: {
          description:
            'Number of days to use as the conversion attribution window for an engagement action. Engagements include saves, closeups, link clicks, and carousel card swipes. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `30` days.',
          type: 'integer',
          allOf: [
            {
              $ref: '#/components/schemas/ConversionAttributionWindowDays',
            },
          ],
          default: 30,
        },
        view_window_days: {
          description:
            'Number of days to use as the conversion attribution window for a view action. Applies to Pinterest Tag conversion metrics. Prior conversion tags use their defined attribution windows. If not specified, defaults to `1` day.',
          type: 'integer',
          allOf: [
            {
              $ref: '#/components/schemas/ConversionAttributionWindowDays',
            },
          ],
          default: 1,
        },
        conversion_report_time: {
          description:
            'The date by which the conversion metrics returned from this endpoint will be reported. There are two dates associated with a conversion event: the date that the user interacted with the ad, and the date that the user completed a conversion event.',
          type: 'string',
          allOf: [
            {
              $ref: '#/components/schemas/ConversionReportTimeType',
            },
          ],
          default: 'TIME_OF_AD_ACTION',
        },
        attribution_types: {
          description: 'List of types of attribution for the conversion report',
          type: 'array',
          items: {
            $ref: '#/components/schemas/ConversionReportAttributionType',
          },
        },
      },
      required: ['start_date', 'end_date', 'granularity'],
    },
    {
      type: 'object',
      allOf: [
        {
          type: 'object',
          properties: {
            campaign_ids: {
              type: 'array',
              description: 'List of campaign ids',
              example: ['12345678'],
              items: {
                type: 'string',
                pattern: '^\\d+$',
              },
              maxItems: 500,
              minItems: 1,
            },
          },
        },
        {
          type: 'object',
          properties: {
            campaign_statuses: {
              type: 'array',
              description: 'List of status values for filtering',
              example: ['RUNNING', 'PAUSED'],
              items: {
                $ref: '#/components/schemas/CampaignSummaryStatus',
              },
              maxItems: 6,
              minItems: 1,
            },
          },
        },
        {
          type: 'object',
          properties: {
            campaign_objective_types: {
              type: 'array',
              description: 'List of values for filtering. ["WEB_SESSIONS"] in BETA.',
              example: ['AWARENESS', 'VIDEO_VIEW'],
              items: {
                $ref: '#/components/schemas/ObjectiveType',
              },
              maxItems: 7,
              minItems: 1,
            },
          },
        },
        {
          type: 'object',
          properties: {
            ad_group_ids: {
              type: 'array',
              description: 'List of ad group ids',
              example: ['12345678'],
              items: {
                type: 'string',
                pattern: '^\\d+$',
              },
              maxItems: 500,
              minItems: 1,
            },
          },
        },
        {
          type: 'object',
          properties: {
            ad_group_statuses: {
              type: 'array',
              description: 'List of values for filtering',
              example: ['RUNNING', 'PAUSED'],
              items: {
                $ref: '#/components/schemas/AdGroupSummaryStatus',
              },
              maxItems: 6,
              minItems: 1,
            },
          },
        },
        {
          type: 'object',
          properties: {
            ad_ids: {
              type: 'array',
              description: 'List of ad ids [This parameter is no supported for Product Item Level Reports]',
              example: ['12345678'],
              items: {
                type: 'string',
                pattern: '^\\d+$',
              },
              maxItems: 500,
              minItems: 1,
            },
          },
        },
        {
          type: 'object',
          properties: {
            ad_statuses: {
              type: 'array',
              description:
                'List of values for filtering [This parameter is not supported for Product Item Level Reports]',
              example: ['APPROVED', 'PAUSED'],
              items: {
                $ref: '#/components/schemas/PinPromotionSummaryStatus',
              },
              maxItems: 6,
              minItems: 1,
            },
          },
        },
        {
          type: 'object',
          properties: {
            product_group_ids: {
              type: 'array',
              description: 'List of product group ids',
              example: ['12345678'],
              items: {
                type: 'string',
                pattern: '^\\d+$',
              },
              maxItems: 500,
              minItems: 1,
            },
          },
        },
        {
          type: 'object',
          properties: {
            product_group_statuses: {
              type: 'array',
              description: 'List of values for filtering',
              example: ['RUNNING', 'PAUSED'],
              items: {
                $ref: '#/components/schemas/ProductGroupSummaryStatus',
              },
              maxItems: 6,
              minItems: 1,
            },
          },
        },
        {
          type: 'object',
          properties: {
            product_item_ids: {
              type: 'array',
              description: 'List of product item ids',
              example: ['12345678'],
              items: {
                type: 'string',
                pattern: '^\\d+$',
              },
              maxItems: 500,
              minItems: 1,
            },
          },
        },
        {
          $ref: '#/components/schemas/TargetingTypeFilter',
        },
        {
          type: 'object',
          properties: {
            metrics_filters: {
              type: 'array',
              description: 'List of metrics filters',
              minItems: 1,
              items: {
                $ref: '#/components/schemas/AdsAnalyticsMetricsFilter',
              },
            },
          },
        },
      ],
    },
    {
      type: 'object',
      required: ['level', 'columns'],
      properties: {
        columns: {
          description:
            'Metric and entity columns. Pin promotion and ad related columns are not supported for the Product Item level reports.',
          type: 'array',
          items: {
            $ref: '#/components/schemas/ReportingColumnAsync',
          },
        },
        level: {
          type: 'string',
          description: 'Level of the report',
          allOf: [
            {
              $ref: '#/components/schemas/MetricsReportingLevel',
            },
          ],
          example: 'CAMPAIGN',
        },
        report_format: {
          description:
            'Specification for formatting the report data. Reports in JSON will not zero-fill metrics, whereas reports in CSV will. Both report formats will omit rows where all the columns are equal to 0.',
          type: 'string',
          allOf: [
            {
              $ref: '#/components/schemas/DataOutputFormat',
            },
          ],
          default: 'JSON',
        },
        primary_sort: {
          type: 'string',
          allOf: [
            {
              type: 'string',
              description:
                'Whether to first sort the report by date or by entity ID of the reporting entity level. Date will be used as the first level key for JSON reports that use BY_DATE. BY_DATE is recommended for large requests.',
              example: 'BY_ID',
              enum: ['BY_ID', 'BY_DATE'],
            },
          ],
          default: 'BY_ID',
        },
        start_hour: {
          description:
            'Which hour of the start date to begin the report. The entire day will be included if no start hour is provided. Only allowed for hourly reports.',
          type: 'integer',
          minimum: 0,
          maximum: 23,
        },
        end_hour: {
          description:
            "Which hour of the end date to stop the report (inclusive). For example, with an end_date of '2020-01-01' and end_hour of '15', the report will contain metrics up to '2020-01-01 14:59:59'. The entire day will be included if no end hour is provided. Only allowed for hourly reports.",
          type: 'integer',
          minimum: 0,
          maximum: 23,
        },
      },
    },
  ],
} as const;

export const AdsAnalyticsCreateAsyncResponseSchema = {
  type: 'object',
  properties: {
    report_status: {
      type: 'string',
      allOf: [
        {
          $ref: '#/components/schemas/BulkReportingJobStatus',
        },
      ],
    },
    token: {
      type: 'string',
    },
    message: {
      type: 'string',
      nullable: true,
    },
  },
} as const;

export const AdsAnalyticsFilterColumnSchema = {
  type: 'string',
  description: 'Reporting columns for sync reporting data filter',
  example: 'SPEND_IN_DOLLAR',
  enum: ['SPEND_IN_DOLLAR', 'TOTAL_IMPRESSION'],
} as const;

export const AdsAnalyticsFilterOperatorSchema = {
  type: 'string',
  description: 'Filter operator for sync reporting',
  example: 'LESS_THAN',
  enum: ['LESS_THAN', 'GREATER_THAN'],
} as const;

export const AdsAnalyticsGetAsyncResponseSchema = {
  type: 'object',
  properties: {
    report_status: {
      type: 'string',
      allOf: [
        {
          $ref: '#/components/schemas/BulkReportingJobStatus',
        },
      ],
    },
    url: {
      type: 'string',
      nullable: true,
    },
    size: {
      type: 'number',
      nullable: true,
    },
  },
} as const;

export const AdsAnalyticsMetricsFilterSchema = {
  type: 'object',
  properties: {
    field: {
      $ref: '#/components/schemas/AdsAnalyticsFilterColumn',
    },
    operator: {
      $ref: '#/components/schemas/AdsAnalyticsFilterOperator',
    },
    values: {
      type: 'array',
      description: 'List of values for filtering',
      items: {
        type: 'number',
      },
      minItems: 1,
    },
  },
  required: ['field', 'operator', 'values'],
} as const;

export const AdsAnalyticsResponseSchema = {
  type: 'array',
  items: {
    type: 'object',
    properties: {
      AD_ID: {
        description: 'The ID of the ad that this metrics belongs to.',
        type: 'string',
        pattern: '^\\d+$',
      },
      DATE: {
        description:
          'Current metrics date. Only returned when granularity is a time-based value (`DAY`, `HOUR`, `WEEK`, `MONTH`)',
        type: 'string',
        format: 'date',
      },
    },
    required: ['AD_ID'],
    additionalProperties: true,
    example: {
      DATE: '2021-04-01',
      AD_ID: '547602124502',
      SPEND_IN_DOLLAR: 30,
      TOTAL_CLICKTHROUGH: 216,
    },
  },
} as const;

export const AdsAnalyticsTargetingTypeSchema = {
  type: 'string',
  description: 'Reporting targeting type',
  example: 'APPTYPE',
  enum: [
    'KEYWORD',
    'APPTYPE',
    'GENDER',
    'LOCATION',
    'PLACEMENT',
    'COUNTRY',
    'TARGETED_INTEREST',
    'PINNER_INTEREST',
    'AUDIENCE_INCLUDE',
    'GEO',
    'AGE_BUCKET',
    'REGION',
    'AGE_BUCKET_AND_GENDER',
  ],
} as const;

export const AdsCreditDiscountsResponseSchema = {
  type: 'object',
  properties: {
    active: {
      description: 'True if the offer code is currently active.',
      type: 'boolean',
      example: true,
    },
    advertiser_id: {
      description: 'Advertiser ID the offer was applied to.',
      type: 'string',
      pattern: '^\\d+$',
      example: '12312451231',
    },
    discountType: {
      description: 'The type of discount of this credit',
      type: 'string',
      nullable: true,
      enum: [
        'COUPON',
        'CREDIT',
        'COUPON_APPLIED',
        'CREDIT_APPLIED',
        'MARKETING_OFFER_CREDIT',
        'MARKETING_OFFER_CREDIT_APPLIED',
        'GOODWILL_CREDIT',
        'GOODWILL_CREDIT_APPLIED',
        'INTERNAL_CREDIT',
        'INTERNAL_CREDIT_APPLIED',
        'PREPAID_CREDIT',
        'PREPAID_CREDIT_APPLIED',
        'SALES_INCENTIVE_CREDIT',
        'SALES_INCENTIVE_CREDIT_APPLIED',
        'CREDIT_EXPIRED',
        'FUTURE_CREDIT',
        'REFERRAL_CREDIT',
        'INVOICE_SALES_INCENTIVE_CREDIT',
        'INVOICE_SALES_INCENTIVE_CREDIT_APPLIED',
        'PREPAID_CREDIT_REFUND',
        null,
      ],
    },
    discountInMicroCurrency: {
      description: 'The discount applied in the offer’s currency value.',
      type: 'number',
      nullable: true,
      example: 125000000,
    },
    discountCurrency: {
      type: 'string',
      nullable: true,
      description: 'Currency value for the discount.',
      example: 'USD',
    },
    title: {
      description: 'Human readable title of the offer code.',
      type: 'string',
      nullable: true,
      example: 'Ads Credits',
    },
    remainingDiscountInMicroCurrency: {
      type: 'number',
      nullable: true,
      description: 'The credits left to spend.',
      example: 125000000,
    },
  },
} as const;

export const AdsCreditRedeemRequestSchema = {
  type: 'object',
  required: ['offerCodeHash', 'validateOnly'],
  properties: {
    offerCodeHash: {
      description: 'Takes in a SHA256 hash of the offerCode.',
      example: '138e9e0ff7e38cf511b880975eb574c09aa9d5e1657590ab0431040da68caa67',
      type: 'string',
      pattern: '^[a-z0-9]*$',
    },
    validateOnly: {
      description:
        'If true, only validate if we can redeem offer code. Otherwise it will actually apply the offer code to the account',
      example: true,
      type: 'boolean',
    },
  },
} as const;

export const AdsCreditRedeemResponseSchema = {
  type: 'object',
  properties: {
    success: {
      description:
        'Returns true if the offer code was successfully applied(validateOnly=false) or can be applied(validateOnly=true).',
      type: 'boolean',
      example: false,
    },
    errorCode: {
      description: 'Error code type if error occurs',
      type: 'integer',
      nullable: true,
      example: 2708,
    },
    errorMessage: {
      description: 'Reason for failure',
      type: 'string',
      nullable: true,
      example: 'The offer has already been redeemed by this advertiser',
    },
  },
} as const;

export const AgeBucketListSchema = {
  title: 'AgeRange',
  type: 'array',
  example: ['35-44', '50-54'],
  items: {
    type: 'string',
    enum: ['18-24', '25-34', '35-44', '45-49', '50-54', '55-64', '65+'],
  },
} as const;

export const AnalyticsDailyMetricsSchema = {
  type: 'object',
  properties: {
    data_status: {
      $ref: '#/components/schemas/DataStatus',
    },
    date: {
      description: 'Metrics date (UTC): YYYY-MM-DD.',
      example: '2019-12-01',
      type: 'string',
    },
    metrics: {
      $ref: '#/components/schemas/Metrics',
    },
  },
} as const;

export const AnalyticsMetricsResponseSchema = {
  type: 'object',
  properties: {
    summary_metrics: {
      description: 'The metric name and value over the requested period for each requested metric',
      type: 'object',
      additionalProperties: {
        type: 'number',
      },
      example: {
        CLOSEUP: 1,
        CLOSEUP_RATE: 0,
        ENGAGEMENT: 1,
        ENGAGEMENT_RATE: 0,
        IMPRESSION: 240,
        OUTBOUND_CLICK: 20,
        OUTBOUND_CLICK_RATE: 0.08,
        PIN_CLICK: 37,
        PIN_CLICK_RATE: 0.15,
        PROFILE_VISIT: 0,
        QUARTILE_95_PERCENT_VIEW: 8,
        SAVE: 20,
        SAVE_RATE: 0.18,
        VIDEO_10S_VIEW: 2,
        VIDEO_AVG_WATCH_TIME: 2507.75,
        VIDEO_MRC_VIEW: 20,
        VIDEO_START: 29,
        VIDEO_V50_WATCH_TIME: 10031,
      },
    },
    daily_metrics: {
      description: 'Array with the requested daily metric records',
      items: {
        $ref: '#/components/schemas/AnalyticsDailyMetrics',
      },
      type: 'array',
    },
  },
} as const;

export const AnalyticsResponseSchema = {
  type: 'object',
  additionalProperties: {
    $ref: '#/components/schemas/AnalyticsMetricsResponse',
  },
} as const;

export const AssetIdPermissionsSchema = {
  type: 'object',
  description: 'An object containing the permissions a business member has on the asset.',
  properties: {
    asset_id: {
      description: 'Unique identifier of a business asset.',
      example: '549755885175',
      pattern: '^\\d+$',
      type: 'string',
      maxLength: 20,
      minLength: 1,
    },
    asset_type: {
      $ref: '#/components/schemas/AssetTypeResponse',
    },
    permissions: {
      $ref: '#/components/schemas/PermissionsResponse',
    },
    asset_group_info: {
      nullable: true,
      description:
        "An object containing all the information specific to the provided asset group. This field will be populated only if asset_type equals 'ASSET_GROUP'.",
      $ref: '#/components/schemas/AssetGroupBinding',
    },
  },
} as const;

export const AssetIdToPermissionsSchema = {
  description: `An object mapping asset ids to lists of business permissions. This can be used to setting/requesting permissions on various assets. If accepting an invite or request, this object would be used to grant asset permissions to the member or partner.
`,
  type: 'object',
  minProperties: 1,
  additionalProperties: {
    type: 'array',
    minItems: 1,
    maxItems: 50,
    items: {
      $ref: '#/components/schemas/Permissions',
    },
  },
  example: {
    549760723247: ['ANALYST'],
    549760723248: ['ANALYST', 'ADMIN'],
    809944451643622187: ['PROFILE_PUBLISHER'],
  },
} as const;

export const AssetTypeResponseSchema = {
  description: 'Type of asset. Currently we only support AD_ACCOUNT and PROFILE, and ASSET_GROUP.',
  example: 'AD_ACCOUNT',
  type: 'string',
} as const;

export const AudienceSchema = {
  properties: {
    ad_account_id: {
      description: 'Ad account ID.',
      example: '549755885175',
      pattern: '^\\d+$',
      title: 'ad_account_id',
      type: 'string',
    },
    id: {
      description: 'Audience ID.',
      example: '1234',
      pattern: '^\\d+$',
      title: 'id',
      type: 'string',
    },
    name: {
      description: 'Audience name.',
      example: 'ACME Tools',
      title: 'name',
      type: 'string',
    },
    audience_type: {
      type: 'string',
      description:
        '<a href="/docs/reference/glossary/#Audience Types">Audience types</a>: ACTALIKE, ENGAGEMENT, CUSTOMER_LIST and VISITOR',
      title: 'audience_type',
    },
    description: {
      description: 'Audience description.',
      example: 'People who love making quilts.',
      nullable: true,
      title: 'description',
      type: 'string',
    },
    rule: {
      $ref: '#/components/schemas/AudienceRule',
    },
    size: {
      description: 'Audience size.',
      example: 1000,
      nullable: true,
      title: 'size',
      type: 'integer',
    },
    status: {
      type: 'string',
      description:
        'Audience status. READY, INITIALIZING, TOO_SMALL - Each audience list needs to have at least 100 people with Pinterest accounts before you can start using it.',
      title: 'status',
    },
    type: {
      description: 'Always "audience".',
      example: 'audience',
      title: 'type',
      type: 'string',
    },
    created_timestamp: {
      description: 'Creation time. Unix timestamp in seconds.',
      example: 1451431341,
      nullable: true,
      title: 'created_time',
      type: 'integer',
    },
    updated_timestamp: {
      description: 'Last update time. Unix timestamp in seconds.',
      example: 1451431341,
      nullable: true,
      title: 'updated_time',
      type: 'integer',
    },
  },
  title: 'Audience',
  type: 'object',
} as const;

export const AudienceCategorySchema = {
  title: 'AudienceCategory',
  type: 'object',
  properties: {
    key: {
      title: 'key',
      description: 'Interest unique key (same as ID).',
      type: 'string',
      example: '1234567',
    },
    name: {
      title: 'name',
      description: 'Interest name.',
      type: 'string',
      example: 'travel',
    },
    ratio: {
      title: 'ratio',
      description: "Interest's percent of category's total audience.",
      type: 'number',
      example: 0.551,
    },
    index: {
      title: 'index',
      description: 'Interest affinity index.',
      type: 'number',
      example: 1.2,
    },
    id: {
      title: 'id',
      description: 'Interest ID.',
      type: 'string',
      example: '1234567',
    },
    subcategories: {
      title: 'subcategories',
      description: 'Subcategory interest distribution',
      type: 'array',
      items: {
        title: 'AudienceSubcategory',
        type: 'object',
        properties: {
          key: {
            title: 'key',
            description: 'Interest unique key (same as ID).',
            type: 'string',
            example: '958862518888',
          },
          name: {
            title: 'name',
            description: 'Subinterest name.',
            type: 'string',
            example: 'travel destinations',
          },
          ratio: {
            title: 'ratio',
            description: "Subinterest's percent of category's total audience.",
            type: 'number',
            example: 0.482,
          },
          index: {
            title: 'index',
            description: 'Subinterest affinity index.',
            type: 'number',
            example: 1.2,
          },
          id: {
            title: 'id',
            description: 'Subinterest ID.',
            type: 'string',
            example: '958862518888',
          },
        },
      },
    },
  },
} as const;

export const AudienceCommonSchema = {
  title: 'AudienceCommon',
  type: 'object',
  properties: {
    ad_account_id: {
      title: 'ad_account_id',
      description: 'Ad account ID.',
      type: 'string',
      example: '549755885175',
      pattern: '^\\d+$',
    },
    name: {
      title: 'name',
      description: 'Audience name.',
      type: 'string',
      example: 'string',
    },
    rule: {
      $ref: '#/components/schemas/AudienceRule',
    },
  },
} as const;

export const AudienceCreateCustomRequestSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/AudienceCommon',
    },
    {
      title: 'AudienceCreateCustomRequest',
      required: ['sharing_type', 'name', 'rule', 'data_party'],
      properties: {
        sharing_type: {
          $ref: '#/components/schemas/AudienceSharingType',
        },
        data_party: {
          $ref: '#/components/schemas/AudienceDataParty',
        },
        category: {
          type: 'string',
          example: 'DLX Demographics',
        },
      },
    },
  ],
} as const;

export const AudienceCreateRequestSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/AudienceCommon',
    },
    {
      title: 'AudienceCreateRequest',
      required: ['audience_type', 'name', 'rule'],
      properties: {
        description: {
          $ref: '#/components/schemas/AudienceDescription',
        },
        audience_type: {
          type: 'string',
          allOf: [
            {
              $ref: '#/components/schemas/AudienceType',
            },
            {
              title: 'audience_type',
              description:
                '<a href="/docs/reference/glossary/#Audience Types">Audience types</a>: ACTALIKE, ENGAGEMENT, CUSTOMER_LIST and VISITOR. Values are case-sensitive.',
            },
          ],
        },
      },
    },
  ],
} as const;

export const AudienceDataPartySchema = {
  description: 'Whether the data is owned by the partner (1p) or by the data provider (3p)',
  type: 'string',
  enum: ['1p', '3p'],
} as const;

export const AudienceDefinitionSchema = {
  title: 'AudienceDefinition',
  description: 'Queryable audience representation.',
  type: 'object',
  properties: {
    date: {
      title: 'date',
      description: 'Generation date',
      type: 'string',
      nullable: true,
      example: '2022-10-09',
    },
    type: {
      $ref: '#/components/schemas/AudienceDefinitionType',
    },
    scope: {
      $ref: '#/components/schemas/AudienceDefinitionScope',
    },
  },
  example: {
    date: '2022-10-09',
    scope: 'PARTNER',
    type: 'IMPRESSION_PLUS_ENGAGEMENT',
  },
} as const;

export const AudienceDefinitionResponseSchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AudienceDefinition',
      },
    },
  },
} as const;

export const AudienceDefinitionScopeSchema = {
  description: 'Generated audience scope to request.',
  type: 'string',
  properties: {
    scope: {
      enum: ['PARTNER', 'PINTEREST'],
    },
  },
} as const;

export const AudienceDefinitionTypeSchema = {
  description: 'Generated audience type to request.',
  type: 'string',
  properties: {
    scope: {
      enum: ['IMPRESSION_PLUS_ENGAGEMENT', 'ENGAGEMENT'],
    },
  },
} as const;

export const AudienceDemographicValueSchema = {
  title: 'AudienceDemographicValue',
  description: 'Demographic detail for a single audience demographic',
  type: 'object',
  properties: {
    key: {
      title: 'key',
      description: 'Unique key for demographic item',
      type: 'string',
      example: 'us',
    },
    name: {
      title: 'name',
      description: 'Display name for demographic',
      type: 'string',
      example: 'United States',
    },
    ratio: {
      title: 'ratio',
      description: 'Value of demographic item as a percent of total audience',
      type: 'number',
      example: 0.551,
    },
  },
  example: {
    name: 'United States',
    key: 'us',
    ratio: 0.551,
  },
} as const;

export const AudienceDemographicsSchema = {
  title: 'AudienceDemographics',
  description: 'Audience demographics',
  type: 'object',
  properties: {
    ages: {
      title: 'ages',
      description: 'Ages distribution.',
      type: 'array',
      items: {
        $ref: '#/components/schemas/AudienceDemographicValue',
      },
    },
    genders: {
      title: 'genders',
      description: 'Gender distribution.',
      type: 'array',
      items: {
        $ref: '#/components/schemas/AudienceDemographicValue',
      },
    },
    devices: {
      title: 'devices',
      description: 'Device usage distribution.',
      type: 'array',
      items: {
        $ref: '#/components/schemas/AudienceDemographicValue',
      },
    },
    metros: {
      title: 'metros',
      description: 'Geographic metro area distribution.',
      type: 'array',
      items: {
        $ref: '#/components/schemas/AudienceDemographicValue',
      },
    },
    countries: {
      title: 'countries',
      description: 'Country area distribution.',
      type: 'array',
      items: {
        $ref: '#/components/schemas/AudienceDemographicValue',
      },
    },
  },
} as const;

export const AudienceDescriptionSchema = {
  title: 'description',
  description: 'Audience description.',
  type: 'string',
  example: 'string',
} as const;

export const AudienceInsightCategoryArrayResponseSchema = {
  deprecated: true,
  type: 'object',
  properties: {
    items: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AudienceInsightCategoryCommon',
      },
    },
  },
} as const;

export const AudienceInsightCategoryCommonSchema = {
  deprecated: true,
  type: 'object',
  properties: {
    key: {
      example: '549755885175',
      type: 'string',
    },
    name: {
      example: 'travel',
      type: 'string',
    },
    ratio: {
      example: 0.551,
      type: 'number',
    },
    index: {
      example: 1.2,
      type: 'number',
    },
    id: {
      example: '549755885175',
      type: 'string',
    },
  },
} as const;

export const AudienceInsightTypeSchema = {
  default: 'YOUR_TOTAL_AUDIENCE',
  type: 'string',
  example: 'YOUR_TOTAL_AUDIENCE',
  enum: ['YOUR_TOTAL_AUDIENCE', 'YOUR_ENGAGED_AUDIENCE', 'PINTEREST_TOTAL_AUDIENCE'],
} as const;

export const AudienceInsightsResponseSchema = {
  title: 'AudienceInsightsResponse',
  description: 'Audience interests and demographics.',
  type: 'object',
  properties: {
    categories: {
      title: 'categories',
      description: 'Category interest distribution',
      type: 'array',
      items: {
        $ref: '#/components/schemas/AudienceCategory',
      },
    },
    demographics: {
      $ref: '#/components/schemas/AudienceDemographics',
    },
    type: {
      $ref: '#/components/schemas/AudienceInsightType',
    },
    date: {
      title: 'date',
      description: 'Generation date',
      type: 'string',
      nullable: true,
      example: '2022-10-09',
      pattern: '^\\d{4}-\\d{2}-\\d{2}$',
    },
    size: {
      title: 'size',
      description: 'Population count.',
      type: 'integer',
      example: 10000,
    },
    size_is_upper_bound: {
      title: 'size_is_upper_bound',
      description: 'Indicates whether the audience size has been rounded up to the next highest upper boundary.',
      type: 'boolean',
      example: true,
    },
  },
} as const;

export const AudienceRuleSchema = {
  description:
    'JSON object defining targeted audience users. Example rule formats per audience type:<br>CUSTOMER_LIST: { "customer_list_id": "&lt;customer list ID&gt;"}<br>ACTALIKE: { "seed_id": ["&lt;audience ID&gt;"], "country": "US", "percentage": "10" }<br>(Valid countries include: "US", "CA", and "GB". Percentage should be 1-10.<br>The targeted audience should be this % size across Pinterest.)<br>VISITOR: { "visitor_source_id": ["&lt;conversion tag ID&gt;"], "retention_days": "180", "event_source": {"=": ["web", "mobile"]}, "ingestion_source": {"=": ["tag"]}}<br>(Retention days should be 1-540. Retention applies to specific customers.)<br>ENGAGEMENT: {"engagement_domain": ["www.entomi.com"], "engager_type": 1}<br>For more details on engagement audiences, see <a href="/docs/redoc/adtech_ads_v4/#section/November-2021" target="_blank">November 2021 changelog</a>.',
  properties: {
    country: {
      description: 'Valid countries include: "US", "CA", and "GB".',
      example: 'US',
      title: 'country',
      type: 'string',
    },
    customer_list_id: {
      description: 'Customer list ID. For CUSTOMER_LIST `audience_type`.',
      example: '5497558859876',
      pattern: '^\\d+$',
      title: 'customer_list_id',
      type: 'string',
    },
    engagement_domain: {
      description: "The audience account's verified domain. **Required** for ENGAGEMENT `audience_type`.",
      example: ['www.somedomain.com'],
      items: {
        type: 'string',
      },
      title: 'engagement_domain',
      type: 'array',
    },
    engagement_type: {
      description:
        'Engagement type enum. Optional for ENGAGEMENT `audience_type`. Supported values are `click`, `save`, `closeup`, `comment` and `like`. All engagements are included if this field is not set. ',
      example: 'click',
      title: 'engagement_type',
      type: 'string',
    },
    event: {
      description:
        'A Pinterest tag event. Optional for VISITOR `audience_type`. Possible values are `pagevisit`, `signup`, `checkout`, `viewcategory`, `search`, `addtocart`, `watchvideo`, `lead`, and `custom`. This field also accepts a partner-defined Pinterest tag event.',
      example: 'checkout',
      title: 'event',
      type: 'string',
    },
    event_data: {
      description: `Optional for VISITOR \`audience_type\`. With the Pinterest tag, you can use event data to capture event details from your website. This object lists all the available predefined event data fields in the Pinterest tag. You can include these event data fields as part of a VISITOR audience’ s \`rule\`; however, you **must** specify an \`event\` for the \`event_data\` fields to be evaluated. Besides what’s listed, you can also create your own set of \`event_data\` fields and define their usages or purposes according to your website needs. However, the benefit of using the predefined event data fields is that we can provide various metrics based on those fields' data.<br>Examples per \`event\` type:<br>\`pagevisit\`<br>"event_data": { "page_name": "My online store 123 | view items | shoe" }<br>\`signup\`<br>"event_data": { "lead_type": "New release promotion" }<br>\`checkout\`<br>"event_data": { "value": 116, "order_quantity": 2, "currency": "USD", "line_items": [ { "product_name": "Pillows (Set of 2)", "product_id": "11", "product_price": 48, "product_quantity": 1 }, { "product_name": "Pillows, Large (Set of 2)", "product_id": "15", "product_price": 68, "product_quantity": 1 } ] }<br>\`addtocart\`<br>"event_data": { "value": 499, "order_quantity": 1, "currency": "USD", "line_items": [ { "product_name": "Red leather boots", "product_id": "3486", "product_category": "shoe", "product_variant_id": "JB11103000", "product_price": 499, "product_quantity": "1" , "product_brand": "My brand" }]}<br>\`watchvideo\`<br>"event_data": { "video_title": "My Product Video 01" }<br>\`lead\`<br>"event_data": { "lead_type": "Newsletter" }`,
      properties: {
        currency: {
          $ref: '#/components/schemas/Currency',
        },
        lead_type: {
          description: 'Promotion code. For example, "Newsletter".',
          example: 'Newsletter',
          title: 'lead_type',
          type: 'string',
        },
        line_items: {
          properties: {
            product_brand: {
              description: 'Product brand. For example, "Parker".',
              example: 'Parker',
              title: 'product_brand',
              type: 'string',
            },
            product_category: {
              description: 'Product category. For example, "Shoes".',
              example: 'Shoes',
              title: 'product_category',
              type: 'string',
            },
            product_id: {
              description: 'Product ID. For example, 1414.',
              example: 1414,
              title: 'product_id',
              type: 'integer',
            },
            product_name: {
              description: 'Product name. For example, "Parker Boots".',
              example: 'Parker Boots',
              title: 'product_name',
              type: 'string',
            },
            product_price: {
              description: 'Product price. For example, "99.99".',
              example: '99.99',
              title: 'product_price',
              type: 'string',
            },
            product_quantity: {
              description: 'Product quantity. For example, 2.',
              example: 2,
              title: 'product_quantity',
              type: 'integer',
            },
            product_variant: {
              description: 'Product variant. For example, "Red".',
              example: 'Red',
              title: 'product_variant',
              type: 'string',
            },
            product_variant_id: {
              description: 'Product variant ID. For example, "1414-34832".',
              example: '1414-34832',
              title: 'product_variant_id',
              type: 'string',
            },
          },
          title: 'LineItem',
          type: 'object',
        },
        order_id: {
          description: 'Order ID. For example, "X-151481".',
          example: 'X-151481',
          title: 'order_id',
          type: 'string',
        },
        order_quantity: {
          description: 'Order quantity. For example, 1.',
          example: 1,
          title: 'order_quantity',
          type: 'integer',
        },
        page_name: {
          description: 'Page name. For example, "Our Favorite Pins on Pinterest".',
          example: 'Our Favorite Pins on Pinterest.',
          title: 'page_name',
          type: 'string',
        },
        promo_code: {
          description: 'Promotion code. For example, "WINTER10".',
          example: 'WINTER10',
          title: 'promo_code',
          type: 'string',
        },
        property: {
          description: 'Property. For example, "Athleta".',
          example: 'Athleta',
          title: 'property',
          type: 'string',
        },
        search_query: {
          description: 'Search query string. For example, "boots".',
          example: 'boots',
          title: 'search_query',
          type: 'string',
        },
        value: {
          description: 'Product value. For example, "199.98"',
          example: '199.98',
          title: 'value',
          type: 'string',
        },
        video_title: {
          description: 'Video title. For example, "How to style your Parker Boots".',
          example: 'How to style your Parker Boots',
          title: 'video_title',
          type: 'string',
        },
      },
      title: 'PinterestTagEventData',
      type: 'object',
    },
    percentage: {
      description: 'Percentage should be 1-10. The targeted audience should be this % size across Pinterest.',
      example: 3,
      title: 'percentage',
      type: 'integer',
    },
    pin_id: {
      description:
        'IDs of engaged organic pins. Optional for ENGAGEMENT `audience_type`. For example, "pin_id:": ["34567"]',
      example: ['34567'],
      items: {
        pattern: '^\\d+$',
        type: 'string',
      },
      title: 'pin_id',
      type: 'array',
    },
    prefill: {
      description:
        'Optional for VISITOR `audience_type`. If `true`, the specified rule on existing engagement data is applied to pre-populate the audience. If `false`, the audience is empty at creation time. The default is `true`.',
      example: true,
      title: 'prefill',
      type: 'boolean',
    },
    retention_days: {
      description:
        'Number of days a Pinterest user remains in the audience. Optional for ENGAGEMENT and VISITOR `audience_type`. Accepted range is 1-540. Defaults to 180 if not specified.',
      example: 30,
      title: 'retention_days',
      type: 'integer',
    },
    seed_id: {
      description: 'Audience ID(s). For ACTALIKE `audience_type`. ',
      example: ['2542620639259', '2542620639261'],
      items: {
        pattern: '^\\d+$',
        type: 'string',
      },
      title: 'seed_id',
      type: 'array',
    },
    url: {
      description: `Optional for ENGAGEMENT or VISITOR \`audience_type\`. For ENGAGEMENT, it is the engaged pin's URL. For VISITOR, you can use it as a string or a {operator: value} object for filtering visitors based on conversion tag event URLs. Supported operators are [ =, !=, contains, not_contains].<br>Example 1:  "url": "http://www.myonlinestore123.com/view_item/shoe"<br>Example 2: "url": {"contains": "/view_item/shoe"}`,
      items: {
        type: 'string',
      },
      title: 'url',
      type: 'array',
    },
    visitor_source_id: {
      description:
        'The conversion tag ID, or the Pinterest tag ID, that you use on your website. For VISITOR `audience_type`.',
      example: '549755885175',
      pattern: '^\\d+$',
      title: 'visitor_source_id',
      type: 'string',
    },
    event_source: {
      description:
        "Optional for VISITOR. You can use it as a {'=': [value]}. Supported values are: web, mobile, offline",
      example: {
        '=': ['web', 'mobile'],
      },
      title: 'event_source',
      type: 'object',
    },
    ingestion_source: {
      description:
        "Optional for VISITOR. You can use it as a {'=': [value]}. Supported values are: tag, mmp, file_upload, conversions_api",
      example: {
        '=': ['tag'],
      },
      title: 'ingestion_source',
      type: 'object',
    },
    engager_type: {
      description: 'Optional for ENGAGEMENT. Engager type value should be 1-2.',
      example: 1,
      title: 'engager_type',
      type: 'integer',
    },
    campaign_id: {
      description: 'Campaign ID for engagement audience filter.',
      example: ['626744528398'],
      items: {
        pattern: '^\\d+$',
        type: 'string',
      },
      title: 'campaign_id',
      type: 'array',
    },
    ad_id: {
      description: 'Ad ID for engagement audience filter.',
      example: ['687201361754'],
      items: {
        pattern: '^\\d+$',
        type: 'string',
      },
      title: 'ad_id',
      type: 'array',
    },
    objective_type: {
      description: 'Objective for engagement audience filter.',
      example: ['AWARENESS'],
      items: {
        $ref: '#/components/schemas/ObjectiveType',
      },
      title: 'objective_type',
      type: 'array',
    },
    ad_account_id: {
      description: 'Ad account ID.',
      example: '549755885175',
      pattern: '^\\d+$',
      title: 'ad_account_id',
      type: 'string',
    },
  },
  title: 'Rule',
  type: 'object',
} as const;

export const AudienceShareTypeSchema = {
  type: 'string',
  default: 'SHARED',
  enum: ['SHARED', 'RECEIVED'],
} as const;

export const AudienceAccountTypeSchema = {
  type: 'string',
  default: 'AD_ACCOUNT',
  enum: ['AD_ACCOUNT', 'BUSINESS_ACCOUNT'],
} as const;

export const AudienceSharingTypeSchema = {
  description: 'Audience sharing type: ["CUSTOM", "SYNDICATED"]',
  type: 'string',
  enum: ['CUSTOM', 'SYNDICATED'],
} as const;

export const AudienceTypeSchema = {
  description: 'Audience type',
  enum: ['CUSTOMER_LIST', 'VISITOR', 'ENGAGEMENT', 'ACTALIKE', 'PERSONA'],
  example: 'ACTALIKE',
  title: 'AudienceType',
  type: 'string',
} as const;

export const AudienceUpdateOperationTypeSchema = {
  title: 'operation_type',
  type: 'string',
  description: 'Audience operation type (update or remove).',
  example: 'UPDATE',
  default: 'UPDATE',
  enum: ['UPDATE', 'REMOVE'],
} as const;

export const AudienceUpdateRequestSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/AudienceCommon',
    },
    {
      title: 'AudienceUpdateRequest',
      type: 'object',
      properties: {
        description: {
          $ref: '#/components/schemas/AudienceDescription',
        },
        operation_type: {
          $ref: '#/components/schemas/AudienceUpdateOperationType',
        },
      },
    },
  ],
} as const;

export const AuthRespondInvitesBodySchema = {
  description: 'An object with a list of all the invites the user would like to respond to and the action to take.',
  type: 'object',
  required: ['invites'],
  properties: {
    invites: {
      type: 'array',
      minItems: 1,
      maxItems: 100,
      items: {
        properties: {
          action: {
            type: 'object',
            properties: {
              accept_invite: {
                description: 'Whether the invite/request is accepted.',
                type: 'boolean',
              },
              asset_id_to_permissions: {
                $ref: '#/components/schemas/AssetIdToPermissions',
              },
            },
            required: ['accept_invite'],
          },
          invite_id: {
            description: 'Unique identifier of an invite.',
            pattern: '^\\d+$',
            type: 'string',
            minLength: 1,
            maxLength: 25,
          },
        },
        required: ['invite_id', 'action'],
        type: 'object',
      },
    },
  },
} as const;

export const AvailabilityFilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    AVAILABILITY: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringCriteria',
    },
  },
  required: ['AVAILABILITY'],
} as const;

export const BaseInviteDataResponseSchema = {
  type: 'object',
  nullable: true,
  properties: {
    id: {
      type: 'string',
      description: 'Unique identifier of the invite/request.',
      example: '383791336903426391',
      pattern: '^\\d+$',
    },
    invite_data: {
      type: 'object',
      description: 'Metadata for the invite/request.',
      properties: {
        invite_expiration: {
          type: 'integer',
          description: 'The date and time when the invite/request will expire. Returned in milliseconds.',
          example: 1709748104775,
        },
        invite_status: {
          type: 'string',
          description:
            'The current status of the invite. The invite can be in one of the following states PENDING, ACCEPTED, DECLINED, CANCELLED, EXPIRED.',
          example: 'PENDING',
        },
        invite_type: {
          type: 'string',
          description:
            "The type of invite. <br>'MEMBER_INVITE' is to invite a member to access your business assets. <br>'PARTNER_INVITE' is to invite a partner to access your business assets. <br>'PARTNER_REQUEST' is to request access a partner's business assets.",
          example: 'MEMBER_INVITE',
        },
        last_updated_time: {
          type: 'integer',
          description: 'The date and time the invite/request was last updated. Returned in milliseconds.',
          example: 1646767577816,
        },
        sent_at: {
          type: 'integer',
          description: 'The date and time the invite/request was sent/created. Returned in milliseconds.',
          example: 1646767577816,
        },
      },
    },
    is_received_invite: {
      type: 'boolean',
      description: 'Indicates whether the invite/request was received.',
    },
    user: {
      type: 'object',
      description: 'Metadata for the member/partner that was sent the invite/request.',
      allOf: [
        {
          $ref: '#/components/schemas/BusinessAccessUserSummary',
        },
      ],
    },
  },
} as const;

export const BatchOperationSchema = {
  description:
    'The operation performed by the batch. The DELETE_DISCONTINUED operation only updates availablity to "Out of Stock".',
  example: 'UPDATE',
  type: 'string',
  enum: ['UPDATE', 'UPSERT', 'CREATE', 'DELETE_DISCONTINUED', 'DELETE'],
} as const;

export const BatchOperationStatusSchema = {
  description: 'The status of the operation performed by the batch',
  example: 'PROCESSING',
  type: 'string',
  enum: ['PROCESSING', 'COMPLETED', 'FAILED'],
} as const;

export const BidFloorSchema = {
  example: {
    bid_floors: [100000, 200000],
    type: 'bidfloor',
  },
  properties: {
    bid_floors: {
      description: 'A list of bid floors in micro currency. For example, [100000, 200000]',
      example: [100000, 200000],
      items: {
        type: 'integer',
      },
      title: 'bid_floors',
      type: 'array',
    },
    type: {
      default: 'bidfloor',
      description: "Always the string 'bidfloor'",
      example: 'bidfloor',
      title: 'type',
      type: 'string',
    },
  },
  title: 'BidFloor',
  type: 'object',
} as const;

export const BidFloorRequestSchema = {
  example: {
    targeting_spec: {
      GEO: ['BE-VOV'],
      LOCATION: ['US'],
      LOCALE: ['cs'],
      AGE_BUCKET: ['25-34'],
      AUDIENCE_INCLUDE: ['2542620905473'],
      SHOPPING_RETARGETING: [
        {
          lookback_window: 30,
          exclusion_window: 14,
          tag_types: [0, 6],
        },
        {
          lookback_window: 30,
          exclusion_window: 14,
          tag_types: [0, 6],
        },
      ],
      GENDER: ['male'],
      TARGETING_STRATEGY: ['CHOOSE_YOUR_OWN'],
      APPTYPE: ['iphone'],
      AUDIENCE_EXCLUDE: ['2542620905475'],
      INTEREST: ['925056443165'],
    },
    bid_floor_specs: [
      {
        billable_event: 'CLICKTHROUGH',
        creative_type: 'REGULAR',
        currency: 'USD',
        countries: ['US', 'US'],
        optimization_goal_metadata: {
          frequency_goal_metadata: {
            timerange: 'DAY',
            frequency: 5,
          },
          conversion_tag_v3_goal_metadata: {
            attribution_windows: {
              view_window_days: 1,
              click_window_days: 0,
              engagement_window_days: 6,
            },
            conversion_tag_id: '123456789',
            learning_mode_type: 'ACTIVE',
            conversion_event: 'PAGE_VISIT',
            is_roas_optimized: true,
            cpa_goal_value_in_micro_currency: '123456789',
          },
          scrollup_goal_metadata: {
            scrollup_goal_value_in_micro_currency: '123456789',
          },
        },
      },
      {
        billable_event: 'CLICKTHROUGH',
        creative_type: 'REGULAR',
        currency: 'USD',
        countries: ['US', 'US'],
        optimization_goal_metadata: {
          frequency_goal_metadata: {
            timerange: 'DAY',
            frequency: 5,
          },
          conversion_tag_v3_goal_metadata: {
            attribution_windows: {
              view_window_days: 1,
              click_window_days: 0,
              engagement_window_days: 6,
            },
            conversion_tag_id: '123456789',
            learning_mode_type: 'ACTIVE',
            conversion_event: 'PAGE_VISIT',
            is_roas_optimized: true,
            cpa_goal_value_in_micro_currency: '123456789',
          },
          scrollup_goal_metadata: {
            scrollup_goal_value_in_micro_currency: '123456789',
          },
        },
      },
    ],
  },
  properties: {
    bid_floor_specs: {
      items: {
        example: {
          billable_event: 'CLICKTHROUGH',
          creative_type: 'REGULAR',
          currency: 'USD',
          countries: ['US', 'US'],
          optimization_goal_metadata: {
            frequency_goal_metadata: {
              timerange: 'DAY',
              frequency: 5,
            },
            conversion_tag_v3_goal_metadata: {
              attribution_windows: {
                view_window_days: 1,
                click_window_days: 0,
                engagement_window_days: 6,
              },
              conversion_tag_id: '123456789',
              learning_mode_type: 'ACTIVE',
              conversion_event: 'PAGE_VISIT',
              is_roas_optimized: true,
              cpa_goal_value_in_micro_currency: '123456789',
            },
            scrollup_goal_metadata: {
              scrollup_goal_value_in_micro_currency: '123456789',
            },
          },
        },
        properties: {
          countries: {
            items: {
              $ref: '#/components/schemas/Country',
            },
            title: 'countries',
            type: 'array',
          },
          currency: {
            $ref: '#/components/schemas/Currency',
          },
          objective_type: {
            $ref: '#/components/schemas/ObjectiveType',
          },
          billable_event: {
            $ref: '#/components/schemas/ActionType',
          },
          optimization_goal_metadata: {
            $ref: '#/components/schemas/OptimizationGoalMetadata',
          },
          creative_type: {
            $ref: '#/components/schemas/CreativeType',
          },
        },
        required: ['billable_event', 'currency'],
        title: 'BidFloorSpec',
        type: 'object',
      },
      title: 'bid_floor_specs',
      type: 'array',
    },
    targeting_spec: {
      $ref: '#/components/schemas/TargetingSpec',
    },
  },
  required: ['bid_floor_specs'],
  title: 'BidFloorBody',
  type: 'object',
} as const;

export const BillingProfilesResponseSchema = {
  type: 'object',
  properties: {
    id: {
      description: 'Billing ID.',
      type: 'string',
      pattern: '^\\d+$',
      example: '12312451231',
    },
    card_type: {
      description: 'Type of the card.',
      type: 'string',
      enum: ['UNKNOWN', 'VISA', 'MASTERCARD', 'AMERICAN_EXPRESS', 'DISCOVER', 'ELO'],
      example: 'VISA',
    },
    status: {
      description: 'Status of the billing.',
      type: 'string',
      enum: ['UNSPECIFIED', 'VALID', 'INVALID', 'PENDING', 'DELETED', 'SECONDARY', 'PENDING_SECONDARY'],
      example: 'INVALID',
    },
    advertiser_id: {
      description: 'Advertiser ID of the billing.',
      type: 'string',
      pattern: '^\\d+$',
      example: '12312451231',
    },
    payment_method_brand: {
      description: 'Brand of the payment method.',
      type: 'string',
      enum: [
        'UNKNOWN',
        'VISA',
        'MASTERCARD',
        'AMERICAN_EXPRESS',
        'DISCOVER',
        'SOFORT',
        'DINERS_CLUB',
        'ELO',
        'CARTE_BANCAIRE',
      ],
      example: 'VISA',
    },
  },
} as const;

export const BoardSchema = {
  title: 'Board',
  description: 'Board',
  type: 'object',
  properties: {
    id: {
      type: 'string',
      readOnly: true,
      example: '549755885175',
    },
    created_at: {
      type: 'string',
      description: 'Date and time of board creation.',
      readOnly: true,
      format: 'date-time',
      example: '2020-01-01T20:10:40-00:00',
    },
    board_pins_modified_at: {
      type: 'string',
      description: 'Date and time of last board pins modified.',
      readOnly: true,
      format: 'date-time',
      example: '2020-01-01T20:10:40-00:00',
    },
    name: {
      type: 'string',
      example: 'Summer Recipes',
    },
    description: {
      type: 'string',
      nullable: true,
      example: 'My favorite summer recipes',
    },
    collaborator_count: {
      type: 'integer',
      description: 'Count of collaborators on the board.',
      minimum: 0,
      readOnly: true,
      example: 17,
    },
    pin_count: {
      type: 'integer',
      description: 'Count of pins on the board.',
      minimum: 0,
      readOnly: true,
      example: 5,
    },
    follower_count: {
      type: 'integer',
      description: 'Board follower count.',
      readOnly: true,
      minimum: 0,
      example: 13,
    },
    media: {
      type: 'object',
      readOnly: true,
      description: 'Board media.',
      properties: {
        image_cover_url: {
          type: 'string',
          nullable: true,
          description: 'Board cover image.',
          example: 'https://i.pinimg.com/400x300/fd/cd/d5/fdcdd5a6d8a80824add0d054125cd957.jpg',
        },
        pin_thumbnail_urls: {
          type: 'array',
          description: 'Board pin thumbnail urls.',
          items: {
            type: 'string',
          },
          example: [
            'https://i.pinimg.com/150x150/b4/57/10/b45710f1ede96af55230f4b43935c4af.jpg',
            'https://i.pinimg.com/150x150/dd/ff/46/ddff4616e39c1935cd05738794fa860e.jpg',
            'https://i.pinimg.com/150x150/84/ac/59/84ac59b670ccb5b903dace480a98930c.jpg',
            'https://i.pinimg.com/150x150/4c/54/6f/4c546f521be85e30838fb742bfff6936.jpg',
          ],
        },
      },
    },
    owner: {
      allOf: [
        {
          $ref: '#/components/schemas/BoardOwner',
        },
      ],
      type: 'object',
      readOnly: true,
    },
    privacy: {
      type: 'string',
      default: 'PUBLIC',
      description:
        'Privacy setting for a board. Learn more about <a href="https://help.pinterest.com/en/article/secret-boards">secret boards</a> and <a href="https://help.pinterest.com/en/business/article/protected-boards">protected boards</a>',
      enum: ['PUBLIC', 'PROTECTED', 'SECRET'],
    },
  },
  required: ['name'],
} as const;

export const BoardOwnerSchema = {
  title: 'Board owner',
  type: 'object',
  properties: {
    username: {
      type: 'string',
      readOnly: true,
    },
  },
} as const;

export const BoardSectionSchema = {
  title: 'Board section',
  description: 'Sections help organize pins within a board.',
  type: 'object',
  properties: {
    id: {
      type: 'string',
      readOnly: true,
      example: '549755885175',
    },
    name: {
      type: 'string',
      example: 'Salads',
      minLength: 1,
      maxLength: 180,
    },
  },
  required: ['name'],
} as const;

export const BoardUpdateSchema = {
  title: 'BoardUpdate',
  description: 'Board fields for updates',
  type: 'object',
  properties: {
    name: {
      type: 'string',
      example: 'Summer Recipes',
    },
    description: {
      type: 'string',
      nullable: true,
      example: 'My favorite summer recipes',
    },
    privacy: {
      type: 'string',
      enum: ['PUBLIC', 'SECRET'],
    },
  },
} as const;

export const BookClosedResponseSchema = {
  title: 'BookClosed',
  description: 'Creation fields',
  type: 'object',
  properties: {
    conversion_metrics_ready: {
      title: 'conversion_metrics_ready',
      description: 'Are conversion metrics ready?',
      type: 'boolean',
      example: false,
    },
    non_conversion_metrics_ready: {
      title: 'non_conversion_metrics_ready',
      description: 'Are non-conversion metrics ready?',
      type: 'boolean',
      example: false,
    },
  },
} as const;

export const BrandFilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    BRAND: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringCriteria',
    },
  },
  required: ['BRAND'],
} as const;

export const BudgetTypeSchema = {
  description: `Budget type. If DAILY, an ad group's daily spend will not exceed the budget parameter value. If LIFETIME, the end_time parameter is **REQUIRED**, and the ad group spend is spread evenly between the ad group \`start_time\` and \`end_time\` range. A CBO campaign automatically generates ad group budgets from its campaign budget to maximize campaign outcome. For CBO campaigns, only "CBO_ADGROUP" is allowed. For WEB_SESSIONS campaigns, only "LIFETIME" is allowed. For update, only draft ad groups may update budget type.`,
  example: 'DAILY',
  enum: ['DAILY', 'LIFETIME', 'CBO_ADGROUP'],
  type: 'string',
} as const;

export const BulkDownloadRequestSchema = {
  type: 'object',
  description: 'Ad entities to get in bulk request.',
  properties: {
    entity_types: {
      type: 'array',
      items: {
        type: 'string',
        allOf: [
          {
            $ref: '#/components/schemas/BulkEntityType',
          },
        ],
      },
      minItems: 1,
      maxItems: 5,
      description: 'All entity types specified will be downloaded. Fewer types result in faster downloads.',
      example: ['CAMPAIGN', 'AD_GROUP'],
    },
    entity_ids: {
      type: 'array',
      items: {
        type: 'string',
        pattern: '^\\d+$',
      },
      description:
        'All entities specified by these IDs as well as their children and grandchildren will be downloaded if the entity type is one of the types requested to be downloaded.',
    },
    updated_since: {
      type: 'string',
      pattern: '^\\d+$',
      example: '1622848072',
      description: 'Unix UTC timestamp to retrieve all entities that have changed since this time.',
    },
    campaign_filter: {
      type: 'object',
      properties: {
        start_time: {
          type: 'string',
          pattern: '^\\d+$',
          example: '1622848072',
          description: 'Unix UTC timestamp.',
        },
        end_time: {
          type: 'string',
          pattern: '^\\d+$',
          example: '1622848072',
          description: 'Unix UTC timestamp.',
        },
        name: {
          type: 'string',
          example: 'campaign name',
          description: 'Campaign name',
        },
        campaign_status: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/CampaignSummaryStatus',
          },
        },
        objective_type: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/ObjectiveType',
          },
        },
      },
    },
    output_format: {
      type: 'string',
      allOf: [
        {
          $ref: '#/components/schemas/BulkOutputFormat',
        },
      ],
      default: 'JSON',
    },
  },
} as const;

export const BulkDownloadResponseSchema = {
  type: 'object',
  example: {
    request_id: '2680059592705',
  },
  properties: {
    request_id: {
      description: 'ID of the bulk request.',
      example: '2680059592705',
      type: 'string',
    },
  },
} as const;

export const BulkEntityTypeSchema = {
  type: 'string',
  description: 'Refers ads entity type',
  example: 'AD',
  enum: ['CAMPAIGN', 'AD_GROUP', 'PRODUCT_GROUP', 'AD', 'KEYWORD'],
} as const;

export const BulkOutputFormatSchema = {
  type: 'string',
  description: 'Bulk file output format',
  enum: ['CSV', 'JSON'],
} as const;

export const BulkReportingJobStatusSchema = {
  type: 'string',
  description: 'Possible status for a bulk reporting job',
  example: 'FINISHED',
  enum: ['DOES_NOT_EXIST', 'FINISHED', 'IN_PROGRESS', 'EXPIRED', 'FAILED', 'CANCELLED'],
} as const;

export const BulkUpsertRequestSchema = {
  type: 'object',
  description: 'Two set of objects to be managed asyncronusly by bulk. One for creations, one for modifications.',
  properties: {
    create: {
      $ref: '#/components/schemas/BulkUpsertRequestCreate',
    },
    update: {
      $ref: '#/components/schemas/BulkUpsertRequestUpdate',
    },
  },
} as const;

export const BulkUpsertRequestCreateSchema = {
  type: 'object',
  description: 'Request for creation of entities in bulk.',
  properties: {
    campaigns: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/CampaignCreateRequest',
      },
    },
    ad_groups: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AdGroupCreateRequest',
      },
    },
    ads: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AdCreateRequest',
      },
    },
    product_groups: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ProductGroupPromotionCreateRequest',
      },
    },
    keywords: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/KeywordsRequest',
      },
    },
  },
} as const;

export const BulkUpsertRequestUpdateSchema = {
  type: 'object',
  description: 'Request for creation of entities in bulk.',
  properties: {
    campaigns: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/CampaignUpdateRequest',
      },
    },
    ad_groups: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AdGroupUpdateRequest',
      },
    },
    ads: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/AdUpdateRequest',
      },
    },
    product_groups: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ProductGroupPromotionUpdateRequest',
      },
    },
    keywords: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/KeywordUpdate',
      },
    },
  },
} as const;

export const BulkUpsertResponseSchema = {
  description: 'ID of the bulk request.',
  type: 'object',
  properties: {
    request_id: {
      type: 'string',
      example: '549763856477-1660864560-1407e16a-c586-4add-94df-d0b160bec0ff, 549763856477-1660864560-d0b160bec0ff',
    },
  },
} as const;

export const BulkUpsertStatusSchema = {
  type: 'string',
  enum: ['RUNNING', 'SUCCEEDED', 'FAILED'],
  example: 'SUCCEEDED',
} as const;

export const BulkUpsertStatusResponseSchema = {
  description: 'ID of the bulk request.',
  type: 'object',
  properties: {
    status: {
      $ref: '#/components/schemas/BulkUpsertStatus',
    },
    result_url: {
      type: 'string',
      example:
        'https://pinterest-waterloo.s3.us-east-1.amazonaws.com/bulk_framework/AD_ENTITY_UPSERT/549763856637-1659122537-0b4d77d3-f620-48ce-bec9-616106afb8d4/(...)',
    },
  },
} as const;

export const BusinessAccessErrorSchema = {
  nullable: true,
  properties: {
    code: {
      type: 'integer',
    },
    message: {
      type: 'string',
    },
  },
  required: ['code', 'message'],
  type: 'object',
} as const;

export const BusinessAccessUserSummarySchema = {
  type: 'object',
  description: 'Metadata of the member/partner that has access to the asset.',
  properties: {
    email: {
      description: 'Email of the business member/partner.',
      example: 'business0101@business.com',
      type: 'string',
      nullable: true,
    },
    id: {
      description: 'Unique identifier of the business member/partner.',
      example: '383791336903426391',
      type: 'string',
      nullable: true,
      minLength: 1,
      maxLength: 20,
    },
    username: {
      description: 'Username of the business member/partner.',
      example: 'business0101',
      nullable: true,
      type: 'string',
    },
  },
} as const;

export const BusinessAccessRoleSchema = {
  type: 'string',
  description: 'Permission role for business access.',
  example: 'ADMIN',
  enum: [
    'OWNER',
    'ADMIN',
    'ANALYST',
    'SOS_READER',
    'FINANCE_MANAGER',
    'AUDIENCE_MANAGER',
    'CAMPAIGN_MANAGER',
    'CATALOGS_MANAGER',
    'RESTRICTED_OWNER',
    'PROFILE_MANAGER',
    'PROFILE_PUBLISHER',
    'RESOURCE_PINNER_LIST_OWNER',
    'RESOURCE_PINNER_LIST_READER',
    'BIZ_PINNER_LIST_SHARER',
    'RESOURCE_CONVERSION_TAGS_READER',
  ],
} as const;

export const BusinessMemberAssetsSummarySchema = {
  type: 'object',
  description: 'Ad accounts and profiles the business member/partner has access to.',
  nullable: true,
  properties: {
    ad_accounts: {
      type: 'array',
      description: 'List of ad account IDs and respective permission levels.',
      items: {
        type: 'object',
        properties: {
          id: {
            type: 'string',
            description: 'Unique identifier of a business ad account.',
            example: '549755885175',
            pattern: '^\\d+$',
            minLength: 1,
            maxLength: 20,
          },
          permissions: {
            $ref: '#/components/schemas/PermissionsResponse',
          },
        },
      },
    },
    profiles: {
      type: 'array',
      description: 'List of profile IDs and respective permission levels.',
      items: {
        type: 'object',
        properties: {
          id: {
            type: 'string',
            description: 'Unique identifier of a business profile.',
            example: '383791336903426391',
            pattern: '^\\d+$',
            minLength: 1,
            maxLength: 20,
          },
          permissions: {
            $ref: '#/components/schemas/PermissionsResponse',
          },
        },
      },
    },
  },
} as const;

export const BusinessRoleCheckModeSchema = {
  description: 'Specifies if the partner is internal or external.',
  enum: ['INTERNAL', 'EXTERNAL'],
  example: 'INTERNAL',
  type: 'string',
} as const;

export const BusinessRoleSchema = {
  type: 'string',
  description: `The access level a member/partner has to the business. Values are case-sensitive.
<br> - EMPLOYEE: Can only view and access assets you assign to them.
They cannot see details about other employees, partners, or other assets.
<br> - BIZ_ADMIN: Have full control of roles and can add employees and partners as well as grant asset access.
<br> - PARTNER: Can only view and access assets you assign them to/or they assign to you.`,
  example: 'BIZ_ADMIN',
  enum: ['EMPLOYEE', 'BIZ_ADMIN', 'PARTNER'],
} as const;

export const BusinessRoleForMembersSchema = {
  type: 'string',
  description: `The access level a member has to the business. Values are case-sensitive.
<br> - EMPLOYEE: Can only view and access assets you assign to them.
They cannot see details about other employees, partners, or other assets.
<br> - BIZ_ADMIN: Have full control of roles and can add employees and partners as well as grant asset access.`,
  example: 'BIZ_ADMIN',
  enum: ['EMPLOYEE', 'BIZ_ADMIN'],
} as const;

export const BusinessRoleResponseSchema = {
  type: 'string',
  description: `The access level a member/partner has to the business. Values are case-sensitive.
<br> - EMPLOYEE: Can only view and access assets you assign to them.
They cannot see details about other employees, partners, or other assets.
<br> - BIZ_ADMIN: Have full control of roles and can add employees or external partners as well as grant asset access.
<br> - PARTNER: Can only view and access assets you assign them to/or they assign to you.`,
  example: 'BIZ_ADMIN',
} as const;

export const UpdatePartnerAssetAccessBodySchema = {
  type: 'object',
  required: ['accesses'],
  properties: {
    accesses: {
      type: 'array',
      minItems: 1,
      maxItems: 50,
      items: {
        type: 'object',
        required: ['partner_id', 'asset_id', 'permissions'],
        properties: {
          partner_id: {
            type: 'string',
            description: 'Unique identifier of a business partner to update asset access to.',
            example: '1234567890123',
            maxLength: 25,
            pattern: '^\\d+$',
          },
          asset_id: {
            type: 'string',
            description: 'Unique identifier of the business asset.',
            example: '549755885175',
            maxLength: 25,
            pattern: '^\\d+$',
          },
          permissions: {
            type: 'array',
            description: 'A non-empty array of permissions to assign to the partner.',
            example: ['ANALYST', 'ADMIN'],
            minItems: 1,
            maxItems: 50,
            items: {
              $ref: '#/components/schemas/Permissions',
            },
          },
        },
      },
    },
  },
} as const;

export const DeletePartnerAssetAccessBodySchema = {
  type: 'object',
  required: ['accesses'],
  properties: {
    accesses: {
      type: 'array',
      minItems: 1,
      maxItems: 50,
      items: {
        type: 'object',
        properties: {
          partner_id: {
            type: 'string',
            description: 'Unique identifier of a business partner to update asset access to.',
            example: '1234567890123',
            maxLength: 25,
            pattern: '^\\d+$',
          },
          asset_id: {
            type: 'string',
            description: 'Unique identifier of the business asset.',
            example: '549755885175',
            maxLength: 25,
            pattern: '^\\d+$',
          },
          partner_type: {
            enum: ['INTERNAL', 'EXTERNAL'],
            example: 'INTERNAL',
            description: `If partner_type=INTERNAL, the deleted asset access is for the access the partner has to your business asset.<br>
If partner_type=EXTERNAL, the deleted asset access is for the access you have to the partner's business asset.`,
            default: 'INTERNAL',
            type: 'string',
          },
        },
        required: ['partner_id', 'asset_id'],
      },
    },
  },
} as const;

export const DeletePartnerAssetsResultSchema = {
  type: 'object',
  description: 'The terminated asset access.',
  properties: {
    asset_id: {
      description: 'Unique identifier of a business asset.',
      example: '549755885175',
      pattern: '^\\d+$',
      type: 'string',
    },
    asset_type: {
      $ref: '#/components/schemas/AssetTypeResponse',
    },
    permissions: {
      $ref: '#/components/schemas/PermissionsResponse',
    },
    is_shared_partner: {
      type: 'boolean',
      description:
        "If is_shared_partner=FALSE, you terminated a partner's asset access to your business asset.<br> If is_shared_partner=TRUE, you terminated your asset access to your partner's business asset.",
      example: false,
    },
    partner_id: {
      description: 'Unique identifier of a business partner.',
      example: '140943737684417',
      pattern: '^\\d+$',
      type: 'string',
    },
  },
} as const;

export const DeletePartnerAssetsResultsResponseArraySchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      description: 'List of terminated asset access.',
      items: {
        type: 'object',
        $ref: '#/components/schemas/DeletePartnerAssetsResult',
      },
    },
  },
} as const;

export const UpdateMemberResultSchema = {
  type: 'object',
  properties: {
    business_role: {
      type: 'string',
      description: `The access level a member has to the business. Values are case-sensitive.
<br> - EMPLOYEE: Can only view and access assets you assign to them.
They cannot see details about other employees, partners, or other assets.
<br> - BIZ_ADMIN: Have full control of roles and can add employees and partners as well as grant asset access.`,
      example: 'EMPLOYEE',
    },
    member_id: {
      type: 'string',
      description: 'Unique identifier of the business member.',
      example: '140943737684417',
      pattern: '^\\d+$',
    },
  },
} as const;

export const UpdateMemberResultsResponseArraySchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      description: 'List of members with updated business access role.',
      items: {
        $ref: '#/components/schemas/UpdateMemberResult',
      },
    },
  },
} as const;

export const UpdateMemberBusinessRoleBodySchema = {
  description: 'Single instance of a business member to have its role updated',
  properties: {
    business_role: {
      $ref: '#/components/schemas/BusinessRoleForMembers',
    },
    member_id: {
      type: 'string',
      description: 'Unique identifier of the member',
      maxLength: 25,
      example: '140943737684417',
      pattern: '^\\d+$',
    },
  },
  required: ['member_id', 'business_role'],
  type: 'object',
} as const;

export const UpdateMemberAssetAccessBodySchema = {
  type: 'object',
  description: 'An object with a list of all the new accesses.',
  required: ['accesses'],
  properties: {
    accesses: {
      type: 'array',
      minItems: 1,
      maxItems: 50,
      items: {
        type: 'object',
        required: ['asset_id', 'member_id', 'permissions'],
        properties: {
          asset_id: {
            type: 'string',
            description: 'Id of the asset to update.',
            example: '549755885175',
            maxLength: 25,
            pattern: '^\\d+$',
          },
          member_id: {
            type: 'string',
            description: 'Unique identifier of the member on which to perform the update',
            example: '140943737684417',
            maxLength: 25,
            pattern: '^\\d+$',
          },
          permissions: {
            type: 'array',
            description: 'A non-empty array of permissions to assign to the member.',
            example: ['ANALYST', 'ADMIN'],
            minItems: 1,
            maxItems: 50,
            items: {
              $ref: '#/components/schemas/Permissions',
            },
          },
        },
      },
    },
  },
} as const;

export const CampaignCommonSchema = {
  type: 'object',
  description: 'Campaign Data',
  properties: {
    ad_account_id: {
      description:
        "Campaign's Advertiser ID. If you want to create a campaign in a Business Account shared account you need to specify the Business Access advertiser ID in both the query path param as well as the request body schema.",
      example: '549755885175',
      type: 'string',
      pattern: '^\\d+$',
    },
    name: {
      type: 'string',
      description: 'Campaign name.',
      example: 'ACME Tools',
    },
    status: {
      type: 'string',
      allOf: [
        {
          $ref: '#/components/schemas/EntityStatus',
        },
      ],
    },
    lifetime_spend_cap: {
      description:
        'Campaign total spending cap. Required for Campaign Budget Optimization (CBO) campaigns. This and "daily_spend_cap" cannot be set at the same time.',
      example: 1432744744,
      type: 'integer',
      nullable: true,
    },
    daily_spend_cap: {
      description:
        'Campaign daily spending cap. Required for Campaign Budget Optimization (CBO) campaigns. This and "lifetime_spend_cap" cannot be set at the same time.',
      example: 1432744744,
      type: 'integer',
      nullable: true,
    },
    order_line_id: {
      description: 'Order line ID that appears on the invoice.',
      example: '549755885175',
      type: 'string',
      pattern: '^\\d+$',
      nullable: true,
    },
    tracking_urls: {
      type: 'object',
      nullable: true,
      allOf: [
        {
          $ref: '#/components/schemas/TrackingUrls',
        },
      ],
    },
    start_time: {
      type: 'integer',
      description:
        'Campaign start time. Unix timestamp in seconds. Only used for Campaign Budget Optimization (CBO) campaigns.',
      example: 1580865126,
      nullable: true,
    },
    end_time: {
      type: 'integer',
      description:
        'Campaign end time. Unix timestamp in seconds. Only used for Campaign Budget Optimization (CBO) campaigns.',
      example: 1644023526,
      nullable: true,
    },
    is_flexible_daily_budgets: {
      $ref: '#/components/schemas/CampaignIsFlexibleDailyBudgets',
    },
  },
} as const;

export const CampaignCreateCommonSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/CampaignCommon',
    },
    {
      type: 'object',
      properties: {
        default_ad_group_budget_in_micro_currency: {
          type: 'integer',
          description:
            'When transitioning from campaign budget optimization to non-campaign budget optimization, the default_ad_group_budget_in_micro_currency will propagate to each child ad groups daily budget. Unit is micro currency of the associated advertiser account.',
          example: 0,
          nullable: true,
        },
        is_automated_campaign: {
          $ref: '#/components/schemas/CampaignIsAutomatedCampaign',
        },
      },
    },
  ],
} as const;

export const CampaignCreateRequestSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/CampaignCreateCommon',
    },
    {
      type: 'object',
      properties: {
        is_flexible_daily_budgets: {
          type: 'boolean',
          default: false,
          allOf: [
            {
              $ref: '#/components/schemas/CampaignIsFlexibleDailyBudgets',
            },
          ],
        },
        is_automated_campaign: {
          type: 'boolean',
          default: false,
          allOf: [
            {
              $ref: '#/components/schemas/CampaignIsAutomatedCampaign',
            },
          ],
        },
        status: {
          type: 'string',
          default: 'ACTIVE',
          allOf: [
            {
              $ref: '#/components/schemas/EntityStatus',
            },
          ],
        },
        objective_type: {
          $ref: '#/components/schemas/ObjectiveType',
        },
      },
      required: ['name', 'objective_type', 'ad_account_id'],
    },
  ],
} as const;

export const CampaignCreateResponseSchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/CampaignCreateResponseItem',
      },
    },
  },
} as const;

export const CampaignCreateResponseDataSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/CampaignCreateCommon',
    },
    {
      $ref: '#/components/schemas/CampaignResponse',
    },
    {
      type: 'object',
      properties: {
        objective_type: {
          $ref: '#/components/schemas/ObjectiveType',
        },
      },
    },
  ],
} as const;

export const CampaignCreateResponseItemSchema = {
  type: 'object',
  properties: {
    data: {
      $ref: '#/components/schemas/CampaignCreateResponseData',
    },
    exceptions: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/Exception',
      },
    },
  },
} as const;

export const CampaignIdSchema = {
  properties: {
    id: {
      description: 'Campaign ID.',
      example: '549755885175',
      type: 'string',
      pattern: '^\\d+$',
    },
  },
  type: 'object',
} as const;

export const CampaignIsAutomatedCampaignSchema = {
  type: 'boolean',
  description: 'Specifies whether the campaign was created in the automated campaign flow',
  example: true,
  nullable: true,
} as const;

export const CampaignIsCampaignBudgetOptimizationSchema = {
  type: 'boolean',
  description:
    'Determines if a campaign automatically generate ad-group level budgets given a campaign budget to maximize campaign outcome. When transitioning from non-cbo to cbo, all previous child ad group budget will be cleared.',
  example: true,
  nullable: true,
} as const;

export const CampaignIsFlexibleDailyBudgetsSchema = {
  type: 'boolean',
  description: 'Determine if a campaign has flexible daily budgets setup.',
  example: true,
  nullable: true,
} as const;

export const CampaignResponseSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/CampaignId',
    },
    {
      $ref: '#/components/schemas/CampaignCommon',
    },
    {
      type: 'object',
      properties: {
        objective_type: {
          $ref: '#/components/schemas/ObjectiveType',
        },
        created_time: {
          type: 'integer',
          description: 'Campaign creation time. Unix timestamp in seconds.',
          example: 1432744744,
        },
        updated_time: {
          type: 'integer',
          description: 'UTC timestamp. Last update time.',
          example: 1432744744,
        },
        type: {
          type: 'string',
          description: 'Always "campaign".',
          example: 'campaign',
        },
        is_campaign_budget_optimization: {
          $ref: '#/components/schemas/CampaignIsCampaignBudgetOptimization',
        },
        summary_status: {
          $ref: '#/components/schemas/CampaignSummaryStatus',
        },
      },
    },
  ],
} as const;

export const CampaignSummaryStatusSchema = {
  type: 'string',
  description: 'Summary status for campaign',
  example: 'RUNNING',
  enum: ['RUNNING', 'PAUSED', 'NOT_STARTED', 'COMPLETED', 'ADVERTISER_DISABLED', 'ARCHIVED', 'DRAFT', 'DELETED_DRAFT'],
} as const;

export const CampaignUpdateRequestSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/CampaignId',
    },
    {
      $ref: '#/components/schemas/CampaignCreateCommon',
    },
    {
      type: 'object',
      properties: {
        is_campaign_budget_optimization: {
          $ref: '#/components/schemas/CampaignIsCampaignBudgetOptimization',
        },
        objective_type: {
          type: 'string',
          nullable: true,
          allOf: [
            {
              $ref: '#/components/schemas/ObjectiveType',
            },
          ],
        },
      },
      required: ['id', 'ad_account_id'],
    },
  ],
} as const;

export const CampaignUpdateResponseSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/CampaignCreateResponse',
    },
  ],
} as const;

export const CampaignsAnalyticsResponseSchema = {
  type: 'array',
  items: {
    type: 'object',
    properties: {
      CAMPAIGN_ID: {
        description: 'The ID of the campaing that this metrics belongs to.',
        type: 'string',
        pattern: '^\\d+$',
      },
      DATE: {
        description:
          'Current metrics date. Only returned when granularity is a time-based value (`DAY`, `HOUR`, `WEEK`, `MONTH`)',
        type: 'string',
        format: 'date',
      },
    },
    required: ['CAMPAIGN_ID'],
    additionalProperties: true,
    example: {
      DATE: '2021-04-01',
      CAMPAIGN_ID: '547602124502',
      SPEND_IN_DOLLAR: 30,
      TOTAL_CLICKTHROUGH: 216,
    },
  },
} as const;

export const CancelInvitesBodySchema = {
  description: 'Request body used to cancel invites',
  type: 'object',
  required: ['invite_ids'],
  properties: {
    invite_ids: {
      description: 'List of invite/request ids to be cancelled',
      example: ['1234567890123456789', '1122334455667788991'],
      items: {
        type: 'string',
        maxLength: 25,
        pattern: '^\\d+$',
      },
      type: 'array',
      minItems: 1,
      maxItems: 50,
    },
  },
} as const;

export const CatalogSchema = {
  type: 'object',
  title: 'catalog',
  description: 'Catalog entity',
  allOf: [
    {
      $ref: '#/components/schemas/CatalogsDbItem',
    },
    {
      type: 'object',
      properties: {
        id: {
          description: 'ID of the catalog entity.',
          example: '864344156814050986',
          type: 'string',
          pattern: '^\\d+$',
        },
        name: {
          description: 'A human-friendly name associated to a catalog entity.',
          nullable: true,
          type: 'string',
        },
        catalog_type: {
          $ref: '#/components/schemas/CatalogsType',
        },
      },
      required: ['id', 'name', 'catalog_type'],
    },
  ],
} as const;

export const CatalogsCreateRequestSchema = {
  type: 'object',
  title: 'catalogs_create_request',
  description: 'Request object for creating a catalog.',
  additionalProperties: false,
  properties: {
    catalog_type: {
      description: 'Type of the catalog entity.',
      type: 'string',
      enum: ['HOTEL'],
    },
    name: {
      description: 'A human-friendly name associated to a given catalog.',
      type: 'string',
    },
  },
  required: ['catalog_type', 'name'],
} as const;

export const CatalogsDbItemSchema = {
  type: 'object',
  title: 'db_item',
  properties: {
    created_at: {
      type: 'string',
      format: 'date-time',
      example: '2022-03-14T15:15:22Z',
    },
    id: {
      type: 'string',
    },
    updated_at: {
      type: 'string',
      format: 'date-time',
      example: '2022-03-14T15:16:34Z',
    },
  },
  required: ['id', 'created_at', 'updated_at'],
} as const;

export const CatalogsCreateReportResponseSchema = {
  type: 'object',
  properties: {
    token: {
      type: 'string',
      description: 'Token to be used to get the report',
    },
  },
} as const;

export const CatalogsReportSchema = {
  type: 'object',
  properties: {
    report_status: {
      type: 'string',
      enum: ['FINISHED', 'IN_PROGRESS'],
    },
    url: {
      type: 'string',
      nullable: true,
      description: 'URL to download the report',
    },
    size: {
      type: 'number',
      nullable: true,
      description: 'Size of the report in bytes',
    },
  },
} as const;

export const CatalogsReportStatsSchema = {
  type: 'object',
  description: 'Diagnostics aggregated numbers',
  oneOf: [
    {
      $ref: '#/components/schemas/CatalogsReportFeedIngestionStats',
    },
    {
      $ref: '#/components/schemas/CatalogsReportDistributionStats',
    },
  ],
  discriminator: {
    propertyName: 'report_type',
    mapping: {
      FEED_INGESTION_ISSUES: '#/components/schemas/CatalogsReportFeedIngestionStats',
      DISTRIBUTION_ISSUES: '#/components/schemas/CatalogsReportDistributionStats',
    },
  },
  properties: {
    report_type: {
      type: 'string',
      enum: ['FEED_INGESTION_ISSUES', 'DISTRIBUTION_ISSUES'],
    },
  },
  required: ['report_type'],
} as const;

export const CatalogsReportFeedIngestionStatsSchema = {
  type: 'object',
  properties: {
    report_type: {
      type: 'string',
      enum: ['FEED_INGESTION_ISSUES'],
    },
    catalog_id: {
      type: 'string',
      pattern: '^\\d+$',
      description: 'ID of the catalog entity.',
    },
    code: {
      description: 'The event code that a diagnostics aggregated number references',
      type: 'integer',
      example: 112,
    },
    code_label: {
      description: "A human-friendly label for the event code (e.g, 'AVAILABILITY_INVALID')",
      type: 'string',
      example: 'AVAILABILITY_INVALID',
    },
    message: {
      description: 'Title message describing the diagnostic issue',
      type: 'string',
    },
    occurrences: {
      description: 'Number of occurrences of the issue',
      example: 10,
      type: 'integer',
    },
    severity: {
      description:
        'An ERROR means that items have been dropped, while a WARN denotes that items have been ingested despite an issue',
      type: 'string',
      enum: ['WARN', 'ERROR'],
    },
  },
} as const;

export const CatalogsReportDistributionStatsSchema = {
  type: 'object',
  properties: {
    report_type: {
      type: 'string',
      enum: ['DISTRIBUTION_ISSUES'],
    },
    catalog_id: {
      type: 'string',
      pattern: '^\\d+$',
      description: 'ID of the catalog entity.',
    },
    code: {
      description: 'The event code that a diagnostics aggregated number references',
      type: 'integer',
    },
    code_label: {
      description: "A human-friendly label for the event code (e.g, 'SPAM')",
      type: 'string',
      example: 'SPAM',
    },
    message: {
      description: 'Title message describing the diagnostic issue',
      type: 'string',
    },
    occurrences: {
      description: 'Number of occurrences of the issue',
      example: 10,
      type: 'integer',
    },
    ineligible_for_ads: {
      description: 'Indicates if issue makes items ineligible for ads distribution',
      example: true,
      type: 'boolean',
    },
    ineligible_for_organic: {
      description: 'Indicates if issue makes items ineligible for organic distribution',
      example: true,
      type: 'boolean',
    },
  },
} as const;

export const CatalogsReportParametersSchema = {
  type: 'object',
  description: 'Report parameters',
  properties: {
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
  },
  required: ['catalog_type'],
  oneOf: [
    {
      $ref: '#/components/schemas/CatalogsRetailReportParameters',
    },
    {
      $ref: '#/components/schemas/CatalogsHotelReportParameters',
    },
  ],
  discriminator: {
    propertyName: 'catalog_type',
    mapping: {
      RETAIL: '#/components/schemas/CatalogsRetailReportParameters',
      HOTEL: '#/components/schemas/CatalogsHotelReportParameters',
    },
  },
} as const;

export const CatalogsHotelReportParametersSchema = {
  type: 'object',
  description: 'Parameters for hotel report',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['HOTEL'],
    },
    report: {
      type: 'object',
      oneOf: [
        {
          $ref: '#/components/schemas/CatalogsReportFeedIngestionFilter',
        },
        {
          $ref: '#/components/schemas/CatalogsReportDistributionIssueFilter',
        },
      ],
      discriminator: {
        propertyName: 'report_type',
        mapping: {
          FEED_INGESTION_ISSUES: '#/components/schemas/CatalogsReportFeedIngestionFilter',
          DISTRIBUTION_ISSUES: '#/components/schemas/CatalogsReportDistributionIssueFilter',
        },
      },
      properties: {
        report_type: {
          type: 'string',
          enum: ['FEED_INGESTION_ISSUES', 'DISTRIBUTION_ISSUES'],
        },
      },
    },
  },
  required: ['catalog_type', 'report'],
} as const;

export const CatalogsRetailReportParametersSchema = {
  type: 'object',
  description: 'Parameters for retail report',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['RETAIL'],
    },
    report: {
      type: 'object',
      oneOf: [
        {
          $ref: '#/components/schemas/CatalogsReportFeedIngestionFilter',
        },
        {
          $ref: '#/components/schemas/CatalogsReportDistributionIssueFilter',
        },
      ],
      discriminator: {
        propertyName: 'report_type',
        mapping: {
          FEED_INGESTION_ISSUES: '#/components/schemas/CatalogsReportFeedIngestionFilter',
          DISTRIBUTION_ISSUES: '#/components/schemas/CatalogsReportDistributionIssueFilter',
        },
      },
      properties: {
        report_type: {
          type: 'string',
          enum: ['FEED_INGESTION_ISSUES', 'DISTRIBUTION_ISSUES'],
        },
      },
    },
  },
  required: ['catalog_type', 'report'],
} as const;

export const CatalogsReportFeedIngestionFilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    report_type: {
      type: 'string',
      enum: ['FEED_INGESTION_ISSUES'],
    },
    feed_id: {
      type: 'string',
      pattern: '^\\d+$',
      description: 'ID of the feed entity.',
    },
    processing_result_id: {
      type: 'string',
      pattern: '^\\d+$',
      description:
        'Unique identifier of a feed processing result. It can be acquired from the "id" field of the "items" array within the response of the [List processing results for a given feed](/docs/api/v5/#operation/feed_processing_results/list). If not provided, default to most recent completed processing result.',
    },
  },
  required: ['report_type', 'feed_id'],
} as const;

export const CatalogsReportDistributionIssueFilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    report_type: {
      type: 'string',
      enum: ['DISTRIBUTION_ISSUES'],
    },
    catalog_id: {
      type: 'string',
      description: 'Unique identifier of a catalog. If not given, oldest catalog will be used',
      pattern: '^\\d+$',
    },
  },
  required: ['report_type'],
} as const;

export const CatalogsHotelBatchItemSchema = {
  description: 'Hotel batch item',
  type: 'object',
  anyOf: [
    {
      $ref: '#/components/schemas/CatalogsCreateHotelItem',
    },
    {
      $ref: '#/components/schemas/CatalogsUpsertHotelItem',
    },
    {
      $ref: '#/components/schemas/CatalogsUpdateHotelItem',
    },
    {
      $ref: '#/components/schemas/CatalogsDeleteHotelItem',
    },
  ],
  discriminator: {
    propertyName: 'operation',
    mapping: {
      CREATE: '#/components/schemas/CatalogsCreateHotelItem',
      UPSERT: '#/components/schemas/CatalogsUpsertHotelItem',
      UPDATE: '#/components/schemas/CatalogsUpdateHotelItem',
      DELETE: '#/components/schemas/CatalogsDeleteHotelItem',
    },
  },
} as const;

export const CatalogsFeedSchema = {
  type: 'object',
  title: 'catalogs_feed',
  description: 'Catalogs Feed object',
  oneOf: [
    {
      $ref: '#/components/schemas/CatalogsRetailFeed',
    },
    {
      $ref: '#/components/schemas/CatalogsHotelFeed',
    },
    {
      $ref: '#/components/schemas/CatalogsCreativeAssetsFeed',
    },
  ],
  discriminator: {
    propertyName: 'catalog_type',
    mapping: {
      RETAIL: '#/components/schemas/CatalogsRetailFeed',
      HOTEL: '#/components/schemas/CatalogsHotelFeed',
      CREATIVE_ASSETS: '#/components/schemas/CatalogsCreativeAssetsFeed',
    },
  },
} as const;

export const CatalogsCreativeAssetsFeedSchema = {
  type: 'object',
  title: 'catalogs_creative_assets_feed',
  description: 'Catalogs Creative Asset Feed object',
  allOf: [
    {
      $ref: '#/components/schemas/CatalogsDbItem',
    },
    {
      type: 'object',
      title: 'feed_fields',
      properties: {
        name: {
          description:
            'A human-friendly name associated to a given feed. This value is currently nullable due to historical reasons. It is expected to become non-nullable in the future.',
          nullable: true,
          type: 'string',
        },
        format: {
          $ref: '#/components/schemas/CatalogsFormat',
        },
        catalog_type: {
          $ref: '#/components/schemas/CatalogsType',
        },
        credentials: {
          $ref: '#/components/schemas/CatalogsFeedCredentials',
        },
        location: {
          description:
            'The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.',
          type: 'string',
        },
        preferred_processing_schedule: {
          $ref: '#/components/schemas/CatalogsFeedProcessingSchedule',
        },
        status: {
          $ref: '#/components/schemas/CatalogsStatus',
        },
        default_currency: {
          $ref: '#/components/schemas/NullableCurrency',
        },
        default_locale: {
          description: 'The locale used within a feed for product descriptions.',
          example: 'en-US',
          type: 'string',
        },
        default_country: {
          $ref: '#/components/schemas/Country',
        },
        catalog_id: {
          description:
            'Catalog id pertaining to the feed. If not provided, feed will use a default catalog based on type.',
          nullable: true,
          type: 'string',
          pattern: '^\\d+$',
        },
      },
      required: [
        'credentials',
        'format',
        'location',
        'name',
        'preferred_processing_schedule',
        'status',
        'catalog_type',
        'default_locale',
        'default_currency',
        'default_country',
        'catalog_id',
      ],
    },
  ],
} as const;

export const CatalogsHotelFeedSchema = {
  type: 'object',
  title: 'catalogs_hotel_feed',
  description: 'Catalogs Hotel Feed object',
  allOf: [
    {
      $ref: '#/components/schemas/CatalogsDbItem',
    },
    {
      type: 'object',
      title: 'feed_fields',
      properties: {
        name: {
          description:
            'A human-friendly name associated to a given feed. This value is currently nullable due to historical reasons. It is expected to become non-nullable in the future.',
          nullable: true,
          type: 'string',
        },
        format: {
          $ref: '#/components/schemas/CatalogsFormat',
        },
        catalog_type: {
          $ref: '#/components/schemas/CatalogsType',
        },
        credentials: {
          $ref: '#/components/schemas/CatalogsFeedCredentials',
        },
        location: {
          description:
            'The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.',
          type: 'string',
        },
        preferred_processing_schedule: {
          $ref: '#/components/schemas/CatalogsFeedProcessingSchedule',
        },
        status: {
          $ref: '#/components/schemas/CatalogsStatus',
        },
        default_currency: {
          $ref: '#/components/schemas/NullableCurrency',
        },
        default_locale: {
          description: 'The locale used within a feed for product descriptions.',
          example: 'en-US',
          type: 'string',
        },
        catalog_id: {
          description:
            'Catalog id pertaining to the feed. If not provided, feed will use a default catalog based on type.',
          nullable: true,
          type: 'string',
          pattern: '^\\d+$',
        },
      },
      required: [
        'credentials',
        'format',
        'location',
        'name',
        'preferred_processing_schedule',
        'status',
        'catalog_type',
        'default_locale',
        'default_currency',
        'catalog_id',
      ],
    },
  ],
} as const;

export const CatalogsRetailFeedSchema = {
  type: 'object',
  title: 'catalogs_retail_feed',
  description: 'Catalogs Retail Feed object',
  allOf: [
    {
      $ref: '#/components/schemas/CatalogsDbItem',
    },
    {
      type: 'object',
      title: 'feed_fields',
      properties: {
        name: {
          description:
            'A human-friendly name associated to a given feed. This value is currently nullable due to historical reasons. It is expected to become non-nullable in the future.',
          nullable: true,
          type: 'string',
        },
        format: {
          $ref: '#/components/schemas/CatalogsFormat',
        },
        catalog_type: {
          $ref: '#/components/schemas/CatalogsType',
        },
        credentials: {
          $ref: '#/components/schemas/CatalogsFeedCredentials',
        },
        location: {
          description:
            'The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.',
          type: 'string',
        },
        preferred_processing_schedule: {
          $ref: '#/components/schemas/CatalogsFeedProcessingSchedule',
        },
        status: {
          $ref: '#/components/schemas/CatalogsStatus',
        },
        default_currency: {
          $ref: '#/components/schemas/NullableCurrency',
        },
        default_locale: {
          description: 'The locale used within a feed for product descriptions.',
          example: 'en-US',
          type: 'string',
        },
        default_country: {
          $ref: '#/components/schemas/Country',
        },
        default_availability: {
          $ref: '#/components/schemas/ProductAvailabilityType',
        },
      },
      required: [
        'credentials',
        'default_availability',
        'default_country',
        'default_currency',
        'default_locale',
        'format',
        'location',
        'name',
        'preferred_processing_schedule',
        'status',
        'catalog_type',
      ],
    },
  ],
} as const;

export const CatalogsFeedCredentialsSchema = {
  type: 'object',
  nullable: true,
  description: 'This field is **OPTIONAL**. Use this if your feed file requires username and password.',
  properties: {
    password: {
      description: 'The required password for downloading a feed.',
      type: 'string',
      format: 'password',
    },
    username: {
      description: 'The required username for downloading a feed.',
      type: 'string',
    },
  },
  required: ['username', 'password'],
} as const;

export const CatalogsFeedIngestionDetailsSchema = {
  type: 'object',
  properties: {
    errors: {
      $ref: '#/components/schemas/CatalogsFeedIngestionErrors',
    },
    info: {
      $ref: '#/components/schemas/CatalogsFeedIngestionInfo',
    },
    warnings: {
      $ref: '#/components/schemas/CatalogsFeedIngestionWarnings',
    },
  },
  required: ['errors', 'info', 'warnings'],
} as const;

export const CatalogsFeedIngestionErrorsSchema = {
  type: 'object',
  properties: {
    LINE_LEVEL_INTERNAL_ERROR: {
      type: 'integer',
      description:
        'We experienced a technical difficulty and were unable to ingest this some items. The next ingestion will happen in 24 hours.',
    },
    LARGE_PRODUCT_COUNT_DECREASE: {
      type: 'integer',
      enum: [1],
      description: 'The product count has decreased by more than 99% compared to the last successful ingestion.',
    },
    ACCOUNT_FLAGGED: {
      type: 'integer',
      description:
        'We detected an issue with your account and are not currently ingesting your items. Please review our policies at policy.pinterest.com/community-guidelines#section-spam or contact us at help.pinterest.com/contact for more information.',
    },
    IMAGE_LEVEL_INTERNAL_ERROR: {
      type: 'integer',
      description:
        'We experienced a technical difficulty and were unable to download some images. The next download attempt will happen in 24 hours.',
    },
    IMAGE_FILE_NOT_ACCESSIBLE: {
      type: 'integer',
      description: 'Image files are unreadable. Please upload new files to continue.',
    },
    IMAGE_MALFORMED_URL: {
      type: 'integer',
      description: 'Image files are unreadable. Please check your link and upload new files to continue.',
    },
    IMAGE_FILE_NOT_FOUND: {
      type: 'integer',
      description: 'Image files are unreadable. Please upload new files to continue.',
    },
    IMAGE_INVALID_FILE: {
      type: 'integer',
      description: 'Image files are unreadable. Please upload new files to continue.',
    },
  },
} as const;

export const CatalogsFeedIngestionInfoSchema = {
  type: 'object',
  properties: {
    IN_STOCK: {
      type: 'integer',
      description: 'The number of ingested products that are in stock.',
    },
    OUT_OF_STOCK: {
      type: 'integer',
      description: 'The number of ingested products that are in out of stock.',
    },
    PREORDER: {
      type: 'integer',
      description: 'The number of ingested products that are in preorder.',
    },
  },
} as const;

export const CatalogsFeedIngestionSchema = {
  type: 'object',
  properties: {
    id: {
      type: 'string',
      example: '01234',
    },
    feed_id: {
      type: 'string',
      example: '56789',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      example: '2022-03-14T15:16:34Z',
    },
    status: {
      $ref: '#/components/schemas/CatalogsFeedProcessingStatus',
    },
  },
  required: ['id', 'feed_id', 'created_at', 'status'],
} as const;

export const CatalogsFeedIngestionWarningsSchema = {
  type: 'object',
  properties: {
    ADDITIONAL_IMAGE_LEVEL_INTERNAL_ERROR: {
      type: 'integer',
      description:
        'We experienced a technical difficulty and were unable to download some additional images. The next download attempt will happen in 24 hours.',
    },
    ADDITIONAL_IMAGE_FILE_NOT_ACCESSIBLE: {
      type: 'integer',
      description: 'Additional image files are unreadable. Please upload new files to continue.',
    },
    ADDITIONAL_IMAGE_MALFORMED_URL: {
      type: 'integer',
      description: 'Additional image files are unreadable. Please check your link and upload new files to continue.',
    },
    ADDITIONAL_IMAGE_FILE_NOT_FOUND: {
      type: 'integer',
      description: 'Additional image files are unreadable. Please upload new files to continue.',
    },
    ADDITIONAL_IMAGE_INVALID_FILE: {
      type: 'integer',
      description: 'Additional image files are unreadable. Please upload new files to continue.',
    },
    HOTEL_PRICE_HEADER_IS_PRESENT: {
      type: 'integer',
      description: 'price is not a supported column. Use base_price and sale_price instead.',
    },
  },
} as const;

export const CatalogsFeedProcessingResultSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/CatalogsDbItem',
    },
    {
      type: 'object',
      title: 'catalogs_feed_processing_result_fields',
      properties: {
        ingestion_details: {
          $ref: '#/components/schemas/CatalogsFeedIngestionDetails',
        },
        status: {
          $ref: '#/components/schemas/CatalogsFeedProcessingStatus',
        },
        product_counts: {
          $ref: '#/components/schemas/CatalogsFeedProductCounts',
        },
        validation_details: {
          $ref: '#/components/schemas/CatalogsFeedValidationDetails',
        },
      },
      required: ['ingestion_details', 'status', 'product_counts', 'validation_details'],
    },
  ],
} as const;

export const CatalogsFeedProcessingScheduleSchema = {
  type: 'object',
  title: 'catalogs_processing_schedule',
  description:
    'Daily processing schedule. This field is **OPTIONAL**. Use this to configure the preferred time for processing a feed (otherwise random).',
  nullable: true,
  properties: {
    time: {
      description: 'A time in format HH:MM with leading 0 (zero)',
      type: 'string',
      pattern: '^(0[0-9]|1[0-9]|2[0-3]):[0-5][0-9]$',
      example: '02:59',
    },
    timezone: {
      description: 'The timezone considered for the processing schedule time.',
      type: 'string',
      nullable: true,
      enum: [
        'Africa/Abidjan',
        'Africa/Accra',
        'Africa/Algiers',
        'Africa/Bissau',
        'Africa/Cairo',
        'Africa/Casablanca',
        'Africa/Ceuta',
        'Africa/El_Aaiun',
        'Africa/Johannesburg',
        'Africa/Juba',
        'Africa/Khartoum',
        'Africa/Lagos',
        'Africa/Maputo',
        'Africa/Monrovia',
        'Africa/Nairobi',
        'Africa/Ndjamena',
        'Africa/Sao_Tome',
        'Africa/Tripoli',
        'Africa/Tunis',
        'Africa/Windhoek',
        'America/Adak',
        'America/Anchorage',
        'America/Araguaina',
        'America/Argentina/Buenos_Aires',
        'America/Argentina/Catamarca',
        'America/Argentina/Cordoba',
        'America/Argentina/Jujuy',
        'America/Argentina/La_Rioja',
        'America/Argentina/Mendoza',
        'America/Argentina/Rio_Gallegos',
        'America/Argentina/Salta',
        'America/Argentina/San_Juan',
        'America/Argentina/San_Luis',
        'America/Argentina/Tucuman',
        'America/Argentina/Ushuaia',
        'America/Asuncion',
        'America/Atikokan',
        'America/Bahia',
        'America/Bahia_Banderas',
        'America/Barbados',
        'America/Belem',
        'America/Belize',
        'America/Blanc-Sablon',
        'America/Boa_Vista',
        'America/Bogota',
        'America/Boise',
        'America/Cambridge_Bay',
        'America/Campo_Grande',
        'America/Cancun',
        'America/Caracas',
        'America/Cayenne',
        'America/Chicago',
        'America/Chihuahua',
        'America/Costa_Rica',
        'America/Creston',
        'America/Cuiaba',
        'America/Curacao',
        'America/Danmarkshavn',
        'America/Dawson',
        'America/Dawson_Creek',
        'America/Denver',
        'America/Detroit',
        'America/Edmonton',
        'America/Eirunepe',
        'America/El_Salvador',
        'America/Fort_Nelson',
        'America/Fortaleza',
        'America/Glace_Bay',
        'America/Goose_Bay',
        'America/Grand_Turk',
        'America/Guatemala',
        'America/Guayaquil',
        'America/Guyana',
        'America/Halifax',
        'America/Havana',
        'America/Hermosillo',
        'America/Indiana/Indianapolis',
        'America/Indiana/Knox',
        'America/Indiana/Marengo',
        'America/Indiana/Petersburg',
        'America/Indiana/Tell_City',
        'America/Indiana/Vevay',
        'America/Indiana/Vincennes',
        'America/Indiana/Winamac',
        'America/Inuvik',
        'America/Iqaluit',
        'America/Jamaica',
        'America/Juneau',
        'America/Kentucky/Louisville',
        'America/Kentucky/Monticello',
        'America/La_Paz',
        'America/Lima',
        'America/Los_Angeles',
        'America/Maceio',
        'America/Managua',
        'America/Manaus',
        'America/Martinique',
        'America/Matamoros',
        'America/Mazatlan',
        'America/Menominee',
        'America/Merida',
        'America/Metlakatla',
        'America/Mexico_City',
        'America/Miquelon',
        'America/Moncton',
        'America/Monterrey',
        'America/Montevideo',
        'America/Nassau',
        'America/New_York',
        'America/Nipigon',
        'America/Nome',
        'America/Noronha',
        'America/North_Dakota/Beulah',
        'America/North_Dakota/Center',
        'America/North_Dakota/New_Salem',
        'America/Nuuk',
        'America/Ojinaga',
        'America/Panama',
        'America/Pangnirtung',
        'America/Paramaribo',
        'America/Phoenix',
        'America/Port-au-Prince',
        'America/Port_of_Spain',
        'America/Porto_Velho',
        'America/Puerto_Rico',
        'America/Punta_Arenas',
        'America/Rainy_River',
        'America/Rankin_Inlet',
        'America/Recife',
        'America/Regina',
        'America/Resolute',
        'America/Rio_Branco',
        'America/Santarem',
        'America/Santiago',
        'America/Santo_Domingo',
        'America/Sao_Paulo',
        'America/Scoresbysund',
        'America/Sitka',
        'America/St_Johns',
        'America/Swift_Current',
        'America/Tegucigalpa',
        'America/Thule',
        'America/Thunder_Bay',
        'America/Tijuana',
        'America/Toronto',
        'America/Vancouver',
        'America/Whitehorse',
        'America/Winnipeg',
        'America/Yakutat',
        'America/Yellowknife',
        'Antarctica/Casey',
        'Antarctica/Davis',
        'Antarctica/DumontDUrville',
        'Antarctica/Macquarie',
        'Antarctica/Mawson',
        'Antarctica/Palmer',
        'Antarctica/Rothera',
        'Antarctica/Syowa',
        'Antarctica/Troll',
        'Antarctica/Vostok',
        'Asia/Almaty',
        'Asia/Amman',
        'Asia/Anadyr',
        'Asia/Aqtau',
        'Asia/Aqtobe',
        'Asia/Ashgabat',
        'Asia/Atyrau',
        'Asia/Baghdad',
        'Asia/Baku',
        'Asia/Bangkok',
        'Asia/Barnaul',
        'Asia/Beirut',
        'Asia/Bishkek',
        'Asia/Brunei',
        'Asia/Chita',
        'Asia/Choibalsan',
        'Asia/Colombo',
        'Asia/Damascus',
        'Asia/Dhaka',
        'Asia/Dili',
        'Asia/Dubai',
        'Asia/Dushanbe',
        'Asia/Famagusta',
        'Asia/Gaza',
        'Asia/Hebron',
        'Asia/Ho_Chi_Minh',
        'Asia/Hong_Kong',
        'Asia/Hovd',
        'Asia/Irkutsk',
        'Asia/Jakarta',
        'Asia/Jayapura',
        'Asia/Jerusalem',
        'Asia/Kabul',
        'Asia/Kamchatka',
        'Asia/Karachi',
        'Asia/Kathmandu',
        'Asia/Khandyga',
        'Asia/Kolkata',
        'Asia/Krasnoyarsk',
        'Asia/Kuala_Lumpur',
        'Asia/Kuching',
        'Asia/Macau',
        'Asia/Magadan',
        'Asia/Makassar',
        'Asia/Manila',
        'Asia/Nicosia',
        'Asia/Novokuznetsk',
        'Asia/Novosibirsk',
        'Asia/Omsk',
        'Asia/Oral',
        'Asia/Pontianak',
        'Asia/Pyongyang',
        'Asia/Qatar',
        'Asia/Qostanay',
        'Asia/Qyzylorda',
        'Asia/Riyadh',
        'Asia/Sakhalin',
        'Asia/Samarkand',
        'Asia/Seoul',
        'Asia/Shanghai',
        'Asia/Singapore',
        'Asia/Srednekolymsk',
        'Asia/Taipei',
        'Asia/Tashkent',
        'Asia/Tbilisi',
        'Asia/Tehran',
        'Asia/Thimphu',
        'Asia/Tokyo',
        'Asia/Tomsk',
        'Asia/Ulaanbaatar',
        'Asia/Urumqi',
        'Asia/Ust-Nera',
        'Asia/Vladivostok',
        'Asia/Yakutsk',
        'Asia/Yangon',
        'Asia/Yekaterinburg',
        'Asia/Yerevan',
        'Atlantic/Azores',
        'Atlantic/Bermuda',
        'Atlantic/Canary',
        'Atlantic/Cape_Verde',
        'Atlantic/Faroe',
        'Atlantic/Madeira',
        'Atlantic/Reykjavik',
        'Atlantic/South_Georgia',
        'Atlantic/Stanley',
        'Australia/Adelaide',
        'Australia/Brisbane',
        'Australia/Broken_Hill',
        'Australia/Currie',
        'Australia/Darwin',
        'Australia/Eucla',
        'Australia/Hobart',
        'Australia/Lindeman',
        'Australia/Lord_Howe',
        'Australia/Melbourne',
        'Australia/Perth',
        'Australia/Sydney',
        'CET',
        'CST6CDT',
        'EET',
        'EST',
        'EST5EDT',
        'Etc/GMT',
        'Etc/GMT+1',
        'Etc/GMT+10',
        'Etc/GMT+11',
        'Etc/GMT+12',
        'Etc/GMT+2',
        'Etc/GMT+3',
        'Etc/GMT+4',
        'Etc/GMT+5',
        'Etc/GMT+6',
        'Etc/GMT+7',
        'Etc/GMT+8',
        'Etc/GMT+9',
        'Etc/GMT-1',
        'Etc/GMT-10',
        'Etc/GMT-11',
        'Etc/GMT-12',
        'Etc/GMT-13',
        'Etc/GMT-14',
        'Etc/GMT-2',
        'Etc/GMT-3',
        'Etc/GMT-4',
        'Etc/GMT-5',
        'Etc/GMT-6',
        'Etc/GMT-7',
        'Etc/GMT-8',
        'Etc/GMT-9',
        'Etc/UTC',
        'Europe/Amsterdam',
        'Europe/Andorra',
        'Europe/Astrakhan',
        'Europe/Athens',
        'Europe/Belgrade',
        'Europe/Berlin',
        'Europe/Brussels',
        'Europe/Bucharest',
        'Europe/Budapest',
        'Europe/Chisinau',
        'Europe/Copenhagen',
        'Europe/Dublin',
        'Europe/Gibraltar',
        'Europe/Helsinki',
        'Europe/Istanbul',
        'Europe/Kaliningrad',
        'Europe/Kiev',
        'Europe/Kirov',
        'Europe/Lisbon',
        'Europe/London',
        'Europe/Luxembourg',
        'Europe/Madrid',
        'Europe/Malta',
        'Europe/Minsk',
        'Europe/Monaco',
        'Europe/Moscow',
        'Europe/Oslo',
        'Europe/Paris',
        'Europe/Prague',
        'Europe/Riga',
        'Europe/Rome',
        'Europe/Samara',
        'Europe/Saratov',
        'Europe/Simferopol',
        'Europe/Sofia',
        'Europe/Stockholm',
        'Europe/Tallinn',
        'Europe/Tirane',
        'Europe/Ulyanovsk',
        'Europe/Uzhgorod',
        'Europe/Vienna',
        'Europe/Vilnius',
        'Europe/Volgograd',
        'Europe/Warsaw',
        'Europe/Zaporozhye',
        'Europe/Zurich',
        'HST',
        'Indian/Chagos',
        'Indian/Christmas',
        'Indian/Cocos',
        'Indian/Kerguelen',
        'Indian/Mahe',
        'Indian/Maldives',
        'Indian/Mauritius',
        'Indian/Reunion',
        'MET',
        'MST',
        'MST7MDT',
        'PST8PDT',
        'Pacific/Apia',
        'Pacific/Auckland',
        'Pacific/Bougainville',
        'Pacific/Chatham',
        'Pacific/Chuuk',
        'Pacific/Easter',
        'Pacific/Efate',
        'Pacific/Enderbury',
        'Pacific/Fakaofo',
        'Pacific/Fiji',
        'Pacific/Funafuti',
        'Pacific/Galapagos',
        'Pacific/Gambier',
        'Pacific/Guadalcanal',
        'Pacific/Guam',
        'Pacific/Honolulu',
        'Pacific/Kiritimati',
        'Pacific/Kosrae',
        'Pacific/Kwajalein',
        'Pacific/Majuro',
        'Pacific/Marquesas',
        'Pacific/Nauru',
        'Pacific/Niue',
        'Pacific/Norfolk',
        'Pacific/Noumea',
        'Pacific/Pago_Pago',
        'Pacific/Palau',
        'Pacific/Pitcairn',
        'Pacific/Pohnpei',
        'Pacific/Port_Moresby',
        'Pacific/Rarotonga',
        'Pacific/Tahiti',
        'Pacific/Tarawa',
        'Pacific/Tongatapu',
        'Pacific/Wake',
        'Pacific/Wallis',
        'WET',
        null,
      ],
    },
  },
  required: ['time', 'timezone'],
} as const;

export const CatalogsFeedProcessingStatusSchema = {
  type: 'string',
  enum: ['COMPLETED', 'FAILED', 'PROCESSING'],
} as const;

export const CatalogsFeedProductCountsSchema = {
  type: 'object',
  description: 'The counts can be null early in the process.',
  nullable: true,
  properties: {
    original: {
      description: 'The number of products in the feed file.',
      type: 'integer',
    },
    ingested: {
      description: 'The number of products successfully ingested from the feed file.',
      type: 'integer',
    },
  },
} as const;

export const CatalogsFeedValidationDetailsSchema = {
  type: 'object',
  properties: {
    errors: {
      $ref: '#/components/schemas/CatalogsFeedValidationErrors',
    },
    warnings: {
      $ref: '#/components/schemas/CatalogsFeedValidationWarnings',
    },
  },
  required: ['errors', 'warnings'],
} as const;

export const CatalogsFeedValidationErrorsSchema = {
  type: 'object',
  properties: {
    FETCH_ERROR: {
      type: 'integer',
      description: "Pinterest couldn't download your feed.",
    },
    FETCH_INACTIVE_FEED_ERROR: {
      type: 'integer',
      description: "Your feed wasn't ingested because it hasn’t changed in the previous 90 days.",
    },
    ENCODING_ERROR: {
      type: 'integer',
      description: 'Your feed includes data with an unsupported encoding format.',
    },
    DELIMITER_ERROR: {
      type: 'integer',
      description: 'Your feed includes data with formatting errors.',
    },
    REQUIRED_COLUMNS_MISSING: {
      type: 'integer',
      description: 'Your feed is missing some required column headers.',
    },
    DUPLICATE_PRODUCTS: {
      type: 'integer',
      description: 'Some products are duplicated.',
    },
    IMAGE_LINK_INVALID: {
      type: 'integer',
      description: 'Some image links are formatted incorrectly.',
    },
    ITEMID_MISSING: {
      type: 'integer',
      description: 'Some items are missing an item id in their product metadata, those items will not be published.',
    },
    TITLE_MISSING: {
      type: 'integer',
      description: 'Some items are missing a title in their product metadata, those items will not be published.',
    },
    DESCRIPTION_MISSING: {
      type: 'integer',
      description: 'Some items are missing a description in their product metadata, those items will not be published.',
    },
    PRODUCT_LINK_MISSING: {
      type: 'integer',
      description: 'Some items are missing a link URL in their product metadata, those items will not be published.',
    },
    IMAGE_LINK_MISSING: {
      type: 'integer',
      description:
        'Some items are missing an image link URL in their product metadata, those items will not be published.',
    },
    AVAILABILITY_INVALID: {
      type: 'integer',
      description:
        'Some items are missing an availability value in their product metadata, those items will not be published.',
    },
    PRODUCT_PRICE_INVALID: {
      type: 'integer',
      description:
        'Some items have price formatting errors in their product metadata, those items will not be published.',
    },
    LINK_FORMAT_INVALID: {
      type: 'integer',
      description: 'Some link values are formatted incorrectly.',
    },
    PARSE_LINE_ERROR: {
      type: 'integer',
      description: 'Your feed contains formatting errors for some items.',
    },
    ADWORDS_FORMAT_INVALID: {
      type: 'integer',
      description: 'Some adwords links contain too many characters.',
    },
    INTERNAL_SERVICE_ERROR: {
      type: 'integer',
      description:
        'We experienced a technical difficulty and were unable to ingest your feed. The next ingestion will happen in 24 hours.',
    },
    NO_VERIFIED_DOMAIN: {
      type: 'integer',
      description: 'Your merchant domain needs to be claimed.',
    },
    ADULT_INVALID: {
      type: 'integer',
      description: 'Some items have invalid adult values.',
    },
    IMAGE_LINK_LENGTH_TOO_LONG: {
      type: 'integer',
      description:
        'Some items have image_link URLs that contain too many characters, so those items will not be published.',
    },
    INVALID_DOMAIN: {
      type: 'integer',
      description: "Some of your product link values don't match the verified domain associated with this account.",
    },
    FEED_LENGTH_TOO_LONG: {
      type: 'integer',
      description: 'Your feed contains too many items, some items will not be published.',
    },
    LINK_LENGTH_TOO_LONG: {
      type: 'integer',
      description: 'Some product links contain too many characters, those items will not be published.',
    },
    MALFORMED_XML: {
      type: 'integer',
      description: "Your feed couldn't be validated because the xml file is formatted incorrectly.",
    },
    PRICE_MISSING: {
      type: 'integer',
      description: 'Some products are missing a price, those items will not be published.',
    },
    FEED_TOO_SMALL: {
      type: 'integer',
      description:
        "Your feed couldn't be validated because the file doesn't contain the minimum number of lines required.",
    },
    MAX_ITEMS_PER_ITEM_GROUP_EXCEEDED: {
      type: 'integer',
      description: 'Some items exceed the maximum number of items per item group, those items will not be published.',
    },
    ITEM_MAIN_IMAGE_DOWNLOAD_FAILURE: {
      type: 'integer',
      description: "Some items' main images can't be found.",
    },
    PINJOIN_CONTENT_UNSAFE: {
      type: 'integer',
      description: "Some items were not published because they don't meet Pinterest's Merchant Guidelines.",
    },
    BLOCKLISTED_IMAGE_SIGNATURE: {
      type: 'integer',
      description: "Some items were not published because they don't meet Pinterest's Merchant Guidelines.",
    },
    LIST_PRICE_INVALID: {
      type: 'integer',
      description:
        'Some items have list price formatting errors in their product metadata, those items will not be published.',
    },
    PRICE_CANNOT_BE_DETERMINED: {
      type: 'integer',
      description:
        'Some items were not published because price cannot be determined. The price, list price, and sale price are all different, so those items will not be published.',
    },
  },
} as const;

export const CatalogsFeedValidationWarningsSchema = {
  type: 'object',
  properties: {
    AD_LINK_FORMAT_WARNING: {
      type: 'integer',
      description: 'Some items have ad links that are formatted incorrectly.',
    },
    AD_LINK_SAME_AS_LINK: {
      type: 'integer',
      description: 'Some items have ad link URLs that are duplicates of the link URLs for those items.',
    },
    TITLE_LENGTH_TOO_LONG: {
      type: 'integer',
      description: 'The title for some items were truncated because they contain too many characters.',
    },
    DESCRIPTION_LENGTH_TOO_LONG: {
      type: 'integer',
      description: 'The description for some items were truncated because they contain too many characters.',
    },
    GENDER_INVALID: {
      type: 'integer',
      description:
        'Some items have gender values that are formatted incorrectly, which may limit visibility in recommendations, search results and shopping experiences.',
    },
    AGE_GROUP_INVALID: {
      type: 'integer',
      description:
        'Some items have age group values that are formatted incorrectly, which may limit visibility in recommendations, search results and shopping experiences.',
    },
    SIZE_TYPE_INVALID: {
      type: 'integer',
      description:
        'Some items have size type values that are formatted incorrectly, which may limit visibility in recommendations, search results and shopping experiences.',
    },
    SIZE_SYSTEM_INVALID: {
      type: 'integer',
      description: 'Some items have size system values which are not one of the supported size systems.',
    },
    LINK_FORMAT_WARNING: {
      type: 'integer',
      description: 'Some items have an invalid product link which contains invalid UTM tracking paramaters.',
    },
    SALES_PRICE_INVALID: {
      type: 'integer',
      description: 'Some items have sale price values that are higher than the original price of the item.',
    },
    PRODUCT_CATEGORY_DEPTH_WARNING: {
      type: 'integer',
      description:
        'Some items only have 1 or 2 levels of google_product_category values, which may limit visibility in recommendations, search results and shopping experiences.',
    },
    ADWORDS_FORMAT_WARNING: {
      type: 'integer',
      description: 'Some items have adwords_redirect links that are formatted incorrectly.',
    },
    ADWORDS_SAME_AS_LINK: {
      type: 'integer',
      description: 'Some items have adwords_redirect URLs that are duplicates of the link URLs for those items.',
    },
    DUPLICATE_HEADERS: {
      type: 'integer',
      description: 'Your feed contains duplicate headers.',
    },
    FETCH_SAME_SIGNATURE: {
      type: 'integer',
      description:
        'Ingestion completed early because there are no changes to your feed since the last successful update.',
      enum: [1],
    },
    ADDITIONAL_IMAGE_LINK_LENGTH_TOO_LONG: {
      type: 'integer',
      description:
        'Some items have additional_image_link URLs that contain too many characters, so those items will not be published.',
    },
    ADDITIONAL_IMAGE_LINK_WARNING: {
      type: 'integer',
      description:
        'Some items have additional_image_link URLs that are formatted incorrectly and will not be published with your items.',
    },
    IMAGE_LINK_WARNING: {
      type: 'integer',
      description:
        'Some items have image_link URLs that are formatted incorrectly and will not be published with those items.',
    },
    SHIPPING_INVALID: {
      type: 'integer',
      description: 'Some items have shipping values that are formatted incorrectly.',
    },
    TAX_INVALID: {
      type: 'integer',
      description: 'Some items have tax values that are formatted incorrectly.',
    },
    SHIPPING_WEIGHT_INVALID: {
      type: 'integer',
      description: 'Some items have invalid shipping_weight values.',
    },
    EXPIRATION_DATE_INVALID: {
      type: 'integer',
      description:
        'Some items have expiration_date values that are formatted incorrectly, those items will be published without an expiration date.',
    },
    AVAILABILITY_DATE_INVALID: {
      type: 'integer',
      description:
        'Some items have availability_date values that are formatted incorrectly, those items will be published without an availability date.',
    },
    SALE_DATE_INVALID: {
      type: 'integer',
      description:
        'Some items have sale_price_effective_date values that are formatted incorrectly, those items will be published without a sale date.',
    },
    WEIGHT_UNIT_INVALID: {
      type: 'integer',
      description:
        'Some items have weight_unit values that are formatted incorrectly, those items will be published without a weight unit.',
    },
    IS_BUNDLE_INVALID: {
      type: 'integer',
      description:
        'Some items have is_bundle values that are formatted incorrectly, those items will be published without being bundled with other products.',
    },
    UPDATED_TIME_INVALID: {
      type: 'integer',
      description:
        'Some items have updated_time values thate are formatted incorrectly, those items will be published without an updated time.',
    },
    CUSTOM_LABEL_LENGTH_TOO_LONG: {
      type: 'integer',
      description:
        'Some items have custom_label values that are too long, those items will be published without that custom label.',
    },
    PRODUCT_TYPE_LENGTH_TOO_LONG: {
      type: 'integer',
      description:
        'Some items have product_type values that are too long, those items will be published without that product type.',
    },
    TOO_MANY_ADDITIONAL_IMAGE_LINKS: {
      type: 'integer',
      description:
        'Some items have additional_image_link values that exceed the limit for additional images, those items will be published without some of your images.',
    },
    MULTIPACK_INVALID: {
      type: 'integer',
      description: 'Some items have invalid multipack values.',
    },
    INDEXED_PRODUCT_COUNT_LARGE_DELTA: {
      type: 'integer',
      description:
        'The product count has increased or decreased significantly compared to the last successful ingestion.',
    },
    ITEM_ADDITIONAL_IMAGE_DOWNLOAD_FAILURE: {
      type: 'integer',
      description: "Some items include additional_image_links that can't be found.",
    },
    OPTIONAL_PRODUCT_CATEGORY_MISSING: {
      type: 'integer',
      description: 'Some items are missing a google_product_category.',
    },
    OPTIONAL_PRODUCT_CATEGORY_INVALID: {
      type: 'integer',
      description:
        'Some items include google_product_category values that are not formatted correctly according to the GPC taxonomy.',
    },
    OPTIONAL_CONDITION_MISSING: {
      type: 'integer',
      description:
        'Some items are missing a condition value, which may limit visibility in recommendations, search results and shopping experiences.',
    },
    OPTIONAL_CONDITION_INVALID: {
      type: 'integer',
      description:
        'Some items include condition values that are formatted incorrectly, which may limit visibility in recommendations, search results and shopping experiences.',
    },
    IOS_DEEP_LINK_INVALID: {
      type: 'integer',
      description: 'Some items include invalid ios_deep_link values.',
    },
    ANDROID_DEEP_LINK_INVALID: {
      type: 'integer',
      description: 'Some items include invalid android_deep_link.',
    },
    UTM_SOURCE_AUTO_CORRECTED: {
      type: 'integer',
      description:
        'Some items include utm_source values that are formatted incorrectly and have been automatically corrected.',
    },
    COUNTRY_DOES_NOT_MAP_TO_CURRENCY: {
      type: 'integer',
      description:
        "Some items include a currency that doesn't match the usual currency for the location where that product is sold or shipped.",
    },
    MIN_AD_PRICE_INVALID: {
      type: 'integer',
      description: 'Some items include min_ad_price values that are formatted incorrectly.',
    },
    GTIN_INVALID: {
      type: 'integer',
      description: 'Some items include incorrectly formatted GTINs.',
    },
    INCONSISTENT_CURRENCY_VALUES: {
      type: 'integer',
      description: 'Some items include inconsistent currencies in price fields.',
    },
    SALES_PRICE_TOO_LOW: {
      type: 'integer',
      description: 'Some items include sales price that is much lower than the list price.',
    },
    SHIPPING_WIDTH_INVALID: {
      type: 'integer',
      description: 'Some items include incorrectly formatted shipping_width.',
    },
    SHIPPING_HEIGHT_INVALID: {
      type: 'integer',
      description: 'Some items include incorrectly formatted shipping_height.',
    },
    SALES_PRICE_TOO_HIGH: {
      type: 'integer',
      description:
        'Some items include a sales price that is higher than the list price. The sales price has been defaulted to the list price.',
    },
    MPN_INVALID: {
      type: 'integer',
      description: 'Some items include incorrectly formatted MPNs.',
    },
  },
} as const;

export const CatalogsFeedsCreateRequestSchema = {
  type: 'object',
  title: 'legacy_retail_only',
  description:
    'Request object for creating a feed. Please, be aware that "default_country" and "default_locale" are not required in the spec for forward compatibility but for now the API will not accept requests without those fields.',
  additionalProperties: false,
  properties: {
    default_currency: {
      $ref: '#/components/schemas/NullableCurrency',
    },
    name: {
      description: 'A human-friendly name associated to a given feed.',
      type: 'string',
    },
    format: {
      $ref: '#/components/schemas/CatalogsFormat',
    },
    default_locale: {
      description: 'The locale used within a feed for product descriptions.',
      example: 'en-US',
      anyOf: [
        {
          description: 'The locale used within a feed for product descriptions.',
          $ref: '#/components/schemas/CatalogsLocale',
        },
        {
          description:
            'The locale used within a feed for product descriptions. This free text string version is deprecated in favor of official list of supported locales defined by CatalogsLocale.',
          type: 'string',
          deprecated: true,
        },
      ],
    },
    credentials: {
      $ref: '#/components/schemas/CatalogsFeedCredentials',
    },
    location: {
      description:
        'The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.',
      pattern: '^(http|https|ftp|sftp)://',
      type: 'string',
    },
    preferred_processing_schedule: {
      $ref: '#/components/schemas/CatalogsFeedProcessingSchedule',
    },
    default_country: {
      $ref: '#/components/schemas/Country',
    },
    default_availability: {
      $ref: '#/components/schemas/ProductAvailabilityType',
    },
    status: {
      type: 'string',
      allOf: [
        {
          $ref: '#/components/schemas/CatalogsStatus',
        },
        {
          default: 'ACTIVE',
        },
      ],
    },
  },
  required: ['format', 'location', 'name'],
} as const;

export const CatalogsHotelAttributesSchema = {
  type: 'object',
  allOf: [
    {
      type: 'object',
      properties: {
        main_image: {
          type: 'object',
          description: 'The main hotel image',
          properties: {
            link: {
              type: 'string',
              description: `<p><= 2000 characters</p>
<p>The link to the main hotel image. Image should be at least
75x75 pixels to avoid errors. Use the additional_image_link field to add
more images of your hotel. The URL of your main_image.link must be accessible
by the Pinterest user-agent, and send the accurate image. Please make
sure there is no template or placeholder image at the link. Must start
with http:// or https://.</p>`,
            },
            tag: {
              type: 'array',
              nullable: true,
              description:
                'Tag appended to the image that identifies image category or details. There can be multiple tags associated with an image',
              items: {
                type: 'string',
              },
            },
          },
        },
        additional_image_link: {
          type: 'array',
          nullable: true,
          items: {
            type: 'string',
          },
          description: `<p><= 2000 characters</p>
<p>The links to additional images for your hotel. Up to ten
additional images can be used to show a hotel from different angles.
Must begin with http:// or https://.</p>`,
          example: ['https://scene.example.com/image/image_v2.jpg', 'https://scene.example.com/image/image_v3.jpg'],
        },
      },
    },
    {
      $ref: '#/components/schemas/CatalogsUpdatableHotelAttributes',
    },
  ],
} as const;

export const CatalogsRetailFeedsCreateRequestSchema = {
  type: 'object',
  title: 'feeds_retail_create_request',
  description: 'Request object for creating a retail feed.',
  additionalProperties: false,
  properties: {
    default_currency: {
      $ref: '#/components/schemas/NullableCurrency',
    },
    name: {
      description: 'A human-friendly name associated to a given feed.',
      type: 'string',
    },
    format: {
      $ref: '#/components/schemas/CatalogsFormat',
    },
    default_locale: {
      description: 'The locale used within a feed for product descriptions.',
      example: 'en-US',
      anyOf: [
        {
          description: 'The locale used within a feed for product descriptions.',
          $ref: '#/components/schemas/CatalogsLocale',
        },
        {
          description:
            'The locale used within a feed for product descriptions. This free text string version is deprecated in favor of official list of supported locales defined by CatalogsLocale.',
          type: 'string',
          deprecated: true,
        },
      ],
    },
    credentials: {
      $ref: '#/components/schemas/CatalogsFeedCredentials',
    },
    location: {
      description:
        'The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.',
      pattern: '^(http|https|ftp|sftp)://',
      type: 'string',
    },
    preferred_processing_schedule: {
      $ref: '#/components/schemas/CatalogsFeedProcessingSchedule',
    },
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
    default_country: {
      $ref: '#/components/schemas/Country',
    },
    default_availability: {
      $ref: '#/components/schemas/ProductAvailabilityType',
    },
    status: {
      type: 'string',
      allOf: [
        {
          $ref: '#/components/schemas/CatalogsStatus',
        },
        {
          default: 'ACTIVE',
        },
      ],
    },
  },
  required: ['format', 'location', 'name', 'catalog_type', 'default_country', 'default_locale'],
} as const;

export const CatalogsRetailItemsFilterSchema = {
  type: 'object',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['RETAIL'],
    },
    item_ids: {
      type: 'array',
      minItems: 1,
      maxItems: 100,
      items: {
        type: 'string',
      },
    },
    catalog_id: {
      type: 'string',
      pattern: '^\\d+$',
      description: 'Catalog id pertaining to the retail item. If not provided, default to oldest retail catalog',
    },
  },
  required: ['catalog_type', 'item_ids'],
} as const;

export const CatalogsRetailItemsPostFilterSchema = {
  type: 'object',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['RETAIL'],
    },
    item_ids: {
      type: 'array',
      minItems: 1,
      maxItems: 1000,
      items: {
        type: 'string',
      },
    },
    catalog_id: {
      type: 'string',
      pattern: '^\\d+$',
      description: 'Catalog id pertaining to the retail item. If not provided, default to oldest retail catalog',
    },
  },
  required: ['catalog_type', 'item_ids'],
} as const;

export const CatalogsHotelFeedsCreateRequestSchema = {
  type: 'object',
  title: 'feeds_hotel_create_request',
  description:
    'Request object for creating a feed. Please, be aware that "default_country" and "default_locale" are not required in the spec for forward compatibility but for now the API will not accept requests without those fields.',
  additionalProperties: false,
  properties: {
    default_currency: {
      $ref: '#/components/schemas/NullableCurrency',
    },
    name: {
      description: 'A human-friendly name associated to a given feed.',
      type: 'string',
    },
    format: {
      $ref: '#/components/schemas/CatalogsFormat',
    },
    default_locale: {
      description: 'The locale used within a feed for product descriptions.',
      example: 'en-US',
      anyOf: [
        {
          description: 'The locale used within a feed for product descriptions.',
          $ref: '#/components/schemas/CatalogsLocale',
        },
        {
          description:
            'The locale used within a feed for product descriptions. This free text string version is deprecated in favor of official list of supported locales defined by CatalogsLocale.',
          type: 'string',
          deprecated: true,
        },
      ],
    },
    credentials: {
      $ref: '#/components/schemas/CatalogsFeedCredentials',
    },
    location: {
      description:
        'The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.',
      pattern: '^(http|https|ftp|sftp)://',
      type: 'string',
    },
    preferred_processing_schedule: {
      $ref: '#/components/schemas/CatalogsFeedProcessingSchedule',
    },
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
    catalog_id: {
      description:
        'Catalog id pertaining to the feed. If not provided, feed will use a default catalog based on type. At the moment a catalog can not have multiple hotel feeds but this will change in the future.',
      nullable: true,
      type: 'string',
      pattern: '^\\d+$',
    },
    status: {
      type: 'string',
      allOf: [
        {
          $ref: '#/components/schemas/CatalogsStatus',
        },
        {
          default: 'ACTIVE',
        },
      ],
    },
  },
  required: ['format', 'location', 'name', 'catalog_type', 'default_locale'],
} as const;

export const CatalogsHotelItemsFilterSchema = {
  type: 'object',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['HOTEL'],
    },
    hotel_ids: {
      type: 'array',
      minItems: 1,
      maxItems: 100,
      items: {
        type: 'string',
      },
    },
    catalog_id: {
      type: 'string',
      pattern: '^\\d+$',
      description: 'Catalog id pertaining to the hotel item. If not provided, default to oldest hotel catalog',
    },
  },
  required: ['catalog_type', 'hotel_ids'],
} as const;

export const CatalogsHotelItemsPostFilterSchema = {
  type: 'object',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['HOTEL'],
    },
    hotel_ids: {
      type: 'array',
      minItems: 1,
      maxItems: 1000,
      items: {
        type: 'string',
      },
    },
    catalog_id: {
      type: 'string',
      pattern: '^\\d+$',
      description: 'Catalog id pertaining to the hotel item. If not provided, default to oldest hotel catalog',
    },
  },
  required: ['catalog_type', 'hotel_ids'],
} as const;

export const CatalogsCreativeAssetsItemsFilterSchema = {
  type: 'object',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['CREATIVE_ASSETS'],
    },
    creative_assets_ids: {
      type: 'array',
      minItems: 1,
      maxItems: 100,
      items: {
        type: 'string',
      },
    },
    catalog_id: {
      type: 'string',
      pattern: '^\\d+$',
      description:
        'Catalog id pertaining to the creative assets item. If not provided, default to oldest creative assets catalog',
    },
  },
  required: ['catalog_type', 'creative_assets_ids'],
} as const;

export const CatalogsCreativeAssetsItemsPostFilterSchema = {
  type: 'object',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['CREATIVE_ASSETS'],
    },
    creative_assets_ids: {
      type: 'array',
      minItems: 1,
      maxItems: 1000,
      items: {
        type: 'string',
      },
    },
    catalog_id: {
      type: 'string',
      pattern: '^\\d+$',
      description:
        'Catalog id pertaining to the creative assets item. If not provided, default to oldest creative assets catalog',
    },
  },
  required: ['catalog_type', 'creative_assets_ids'],
} as const;

export const CatalogsCreativeAssetsFeedsCreateRequestSchema = {
  type: 'object',
  title: 'feeds_creative_assets_create_request',
  description: 'Request object for creating a feed.',
  additionalProperties: false,
  properties: {
    default_currency: {
      $ref: '#/components/schemas/NullableCurrency',
    },
    name: {
      description: 'A human-friendly name associated to a given feed.',
      type: 'string',
    },
    format: {
      $ref: '#/components/schemas/CatalogsFormat',
    },
    default_locale: {
      description: 'The locale used within a feed for product descriptions.',
      example: 'en-US',
      anyOf: [
        {
          description: 'The locale used within a feed for product descriptions.',
          $ref: '#/components/schemas/CatalogsLocale',
        },
        {
          description:
            'The locale used within a feed for product descriptions. This free text string version is deprecated in favor of official list of supported locales defined by CatalogsLocale.',
          type: 'string',
          deprecated: true,
        },
      ],
    },
    default_country: {
      $ref: '#/components/schemas/Country',
    },
    credentials: {
      $ref: '#/components/schemas/CatalogsFeedCredentials',
    },
    location: {
      description:
        'The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.',
      pattern: '^(http|https|ftp|sftp)://',
      type: 'string',
    },
    preferred_processing_schedule: {
      $ref: '#/components/schemas/CatalogsFeedProcessingSchedule',
    },
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
    catalog_id: {
      description:
        'Catalog id pertaining to the feed. If not provided, feed will use a default catalog based on type. At the moment a catalog can not have multiple creative assets feeds but this will change in the future.',
      nullable: true,
      type: 'string',
      pattern: '^\\d+$',
    },
    status: {
      type: 'string',
      allOf: [
        {
          $ref: '#/components/schemas/CatalogsStatus',
        },
        {
          default: 'ACTIVE',
        },
      ],
    },
  },
  required: ['format', 'location', 'name', 'catalog_type', 'default_country', 'default_locale'],
} as const;

export const CatalogsVerticalFeedsCreateRequestSchema = {
  type: 'object',
  title: 'feeds_create_request',
  description: 'Request object for creating a feed.',
  oneOf: [
    {
      $ref: '#/components/schemas/CatalogsRetailFeedsCreateRequest',
    },
    {
      $ref: '#/components/schemas/CatalogsHotelFeedsCreateRequest',
    },
    {
      $ref: '#/components/schemas/CatalogsCreativeAssetsFeedsCreateRequest',
    },
  ],
  discriminator: {
    propertyName: 'catalog_type',
    mapping: {
      RETAIL: '#/components/schemas/CatalogsRetailFeedsCreateRequest',
      HOTEL: '#/components/schemas/CatalogsHotelFeedsCreateRequest',
      CREATIVE_ASSETS: '#/components/schemas/CatalogsCreativeAssetsFeedsCreateRequest',
    },
  },
} as const;

export const CatalogsCreativeAssetsFeedsUpdateRequestSchema = {
  type: 'object',
  title: 'catalogs_feeds_update_request',
  description: 'Request object for updating a feed.',
  additionalProperties: false,
  properties: {
    default_currency: {
      $ref: '#/components/schemas/NullableCurrency',
    },
    name: {
      description: 'A human-friendly name associated to a given feed.',
      type: 'string',
    },
    format: {
      $ref: '#/components/schemas/CatalogsFormat',
    },
    credentials: {
      $ref: '#/components/schemas/CatalogsFeedCredentials',
    },
    location: {
      type: 'string',
      pattern: '^(http|https|ftp|sftp)://',
      description:
        'The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.',
    },
    preferred_processing_schedule: {
      $ref: '#/components/schemas/CatalogsFeedProcessingSchedule',
    },
    status: {
      $ref: '#/components/schemas/CatalogsStatus',
    },
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
  },
  required: ['catalog_type'],
} as const;

export const CatalogsRetailFeedsUpdateRequestSchema = {
  type: 'object',
  title: 'catalogs_feeds_update_request',
  description: 'Request object for updating a feed.',
  additionalProperties: false,
  properties: {
    default_currency: {
      $ref: '#/components/schemas/NullableCurrency',
    },
    name: {
      description: 'A human-friendly name associated to a given feed.',
      type: 'string',
    },
    format: {
      $ref: '#/components/schemas/CatalogsFormat',
    },
    credentials: {
      $ref: '#/components/schemas/CatalogsFeedCredentials',
    },
    location: {
      type: 'string',
      pattern: '^(http|https|ftp|sftp)://',
      description:
        'The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.',
    },
    preferred_processing_schedule: {
      $ref: '#/components/schemas/CatalogsFeedProcessingSchedule',
    },
    status: {
      $ref: '#/components/schemas/CatalogsStatus',
    },
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
    default_availability: {
      $ref: '#/components/schemas/ProductAvailabilityType',
    },
  },
  required: ['catalog_type'],
} as const;

export const CatalogsHotelFeedsUpdateRequestSchema = {
  type: 'object',
  title: 'catalogs_feeds_update_request',
  description: 'Request object for updating a feed.',
  additionalProperties: false,
  properties: {
    default_currency: {
      $ref: '#/components/schemas/NullableCurrency',
    },
    name: {
      description: 'A human-friendly name associated to a given feed.',
      type: 'string',
    },
    format: {
      $ref: '#/components/schemas/CatalogsFormat',
    },
    credentials: {
      $ref: '#/components/schemas/CatalogsFeedCredentials',
    },
    location: {
      type: 'string',
      pattern: '^(http|https|ftp|sftp)://',
      description:
        'The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.',
    },
    preferred_processing_schedule: {
      $ref: '#/components/schemas/CatalogsFeedProcessingSchedule',
    },
    status: {
      $ref: '#/components/schemas/CatalogsStatus',
    },
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
  },
  required: ['catalog_type'],
} as const;

export const CatalogsVerticalFeedsUpdateRequestSchema = {
  type: 'object',
  title: 'feeds_update_request',
  description: 'Request object for updating a feed.',
  oneOf: [
    {
      $ref: '#/components/schemas/CatalogsRetailFeedsUpdateRequest',
    },
    {
      $ref: '#/components/schemas/CatalogsHotelFeedsUpdateRequest',
    },
    {
      $ref: '#/components/schemas/CatalogsCreativeAssetsFeedsUpdateRequest',
    },
  ],
  discriminator: {
    propertyName: 'catalog_type',
    mapping: {
      RETAIL: '#/components/schemas/CatalogsRetailFeedsUpdateRequest',
      HOTEL: '#/components/schemas/CatalogsHotelFeedsUpdateRequest',
      CREATIVE_ASSETS: '#/components/schemas/CatalogsCreativeAssetsFeedsUpdateRequest',
    },
  },
} as const;

export const CatalogsFeedsUpdateRequestSchema = {
  type: 'object',
  title: 'legacy_retail_only',
  description: 'Request object for updating a feed.',
  additionalProperties: false,
  properties: {
    default_availability: {
      $ref: '#/components/schemas/ProductAvailabilityType',
    },
    default_currency: {
      $ref: '#/components/schemas/NullableCurrency',
    },
    name: {
      description: 'A human-friendly name associated to a given feed.',
      type: 'string',
    },
    format: {
      $ref: '#/components/schemas/CatalogsFormat',
    },
    credentials: {
      $ref: '#/components/schemas/CatalogsFeedCredentials',
    },
    location: {
      type: 'string',
      pattern: '^(http|https|ftp|sftp)://',
      description:
        'The URL where a feed is available for download. This URL is what Pinterest will use to download a feed for processing.',
    },
    preferred_processing_schedule: {
      $ref: '#/components/schemas/CatalogsFeedProcessingSchedule',
    },
    status: {
      $ref: '#/components/schemas/CatalogsStatus',
    },
  },
} as const;

export const CatalogsFormatSchema = {
  description: 'The file format of a feed.',
  type: 'string',
  enum: ['TSV', 'CSV', 'XML'],
} as const;

export const CatalogsItemValidationDetailsSchema = {
  type: 'object',
  properties: {
    attribute_name: {
      $ref: '#/components/schemas/NullableCatalogsItemFieldType',
      description: 'Attribute that has a validation issue.',
    },
    provided_value: {
      type: 'string',
      nullable: true,
      description: 'Provided value that caused the validation issue.',
    },
  },
  required: ['attribute_name', 'provided_value'],
} as const;

export const CatalogsItemValidationErrorsSchema = {
  type: 'object',
  properties: {
    ADULT_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has an invalid adult value.',
    },
    ADWORDS_FORMAT_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Adword link contains too many characters.',
    },
    AVAILABILITY_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item is missing availability value in its product metadata, this item will not be published.',
    },
    BLOCKLISTED_IMAGE_SIGNATURE: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: "Item will not be published because it doesn't meet Pinterest's Merchant Guidelines.",
    },
    DESCRIPTION_MISSING: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item is missing description in its product metadata, this item will not be published.',
    },
    DUPLICATE_PRODUCTS: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'This product is duplicated. The duplicate entry will not be published.',
    },
    IMAGE_LINK_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Image link is invalid.',
    },
    IMAGE_LINK_LENGTH_TOO_LONG: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has image_link URL that contains too many characters, so the item will not be published.',
    },
    IMAGE_LINK_MISSING: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item is missing an image link URL in its product metadata, this item will not be published.',
    },
    INVALID_DOMAIN: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: "Product link value doesn't match the verified domain associated with this account.",
    },
    ITEMID_MISSING: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item is missing item id in its product metadata, this item will not be published.',
    },
    ITEM_MAIN_IMAGE_DOWNLOAD_FAILURE: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: "Main image can't be found.",
    },
    LINK_FORMAT_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Link is invalid.',
    },
    LINK_LENGTH_TOO_LONG: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Product link contains too many characters, this item will not be published.',
    },
    LIST_PRICE_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has a list price formatting error, this item will not be published.',
    },
    MAX_ITEMS_PER_ITEM_GROUP_EXCEEDED: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item exceed the maximum number of items per item group, this item will not be published.',
    },
    PARSE_LINE_ERROR: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item contains formating errors.',
    },
    PINJOIN_CONTENT_UNSAFE: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: "Item will not be published because it doesn't meet Pinterest's Merchant Guidelines.",
    },
    PRICE_CANNOT_BE_DETERMINED: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item price cannot be determined because the price, list price, and sale price are all different.',
    },
    PRICE_MISSING: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Product is missing a price, this item will not be published.',
    },
    PRODUCT_LINK_MISSING: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item is missing a link URL in its product metadata, this item will not be published.',
    },
    PRODUCT_PRICE_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has a price formatting error in its product metadata, this item will not be published.',
    },
    TITLE_MISSING: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item is missing title in its product metadata, this item will not be published.',
    },
  },
} as const;

export const CatalogsItemValidationIssueSchema = {
  type: 'string',
  enum: [
    'AD_LINK_FORMAT_WARNING',
    'AD_LINK_SAME_AS_LINK',
    'ADDITIONAL_IMAGE_LINK_LENGTH_TOO_LONG',
    'ADDITIONAL_IMAGE_LINK_WARNING',
    'ADULT_INVALID',
    'ADWORDS_FORMAT_INVALID',
    'ADWORDS_FORMAT_WARNING',
    'ADWORDS_SAME_AS_LINK',
    'AGE_GROUP_INVALID',
    'ANDROID_DEEP_LINK_INVALID',
    'AVAILABILITY_DATE_INVALID',
    'AVAILABILITY_INVALID',
    'BLOCKLISTED_IMAGE_SIGNATURE',
    'COUNTRY_DOES_NOT_MAP_TO_CURRENCY',
    'CUSTOM_LABEL_LENGTH_TOO_LONG',
    'DESCRIPTION_LENGTH_TOO_LONG',
    'DESCRIPTION_MISSING',
    'DUPLICATE_PRODUCTS',
    'EXPIRATION_DATE_INVALID',
    'GENDER_INVALID',
    'GTIN_INVALID',
    'IMAGE_LINK_INVALID',
    'IMAGE_LINK_LENGTH_TOO_LONG',
    'IMAGE_LINK_MISSING',
    'IMAGE_LINK_WARNING',
    'INVALID_DOMAIN',
    'IOS_DEEP_LINK_INVALID',
    'IS_BUNDLE_INVALID',
    'ITEM_ADDITIONAL_IMAGE_DOWNLOAD_FAILURE',
    'ITEM_MAIN_IMAGE_DOWNLOAD_FAILURE',
    'ITEMID_MISSING',
    'LINK_FORMAT_INVALID',
    'LINK_FORMAT_WARNING',
    'LINK_LENGTH_TOO_LONG',
    'LIST_PRICE_INVALID',
    'MAX_ITEMS_PER_ITEM_GROUP_EXCEEDED',
    'MIN_AD_PRICE_INVALID',
    'MPN_INVALID',
    'MULTIPACK_INVALID',
    'OPTIONAL_CONDITION_INVALID',
    'OPTIONAL_CONDITION_MISSING',
    'OPTIONAL_PRODUCT_CATEGORY_INVALID',
    'OPTIONAL_PRODUCT_CATEGORY_MISSING',
    'PARSE_LINE_ERROR',
    'PINJOIN_CONTENT_UNSAFE',
    'PRICE_CANNOT_BE_DETERMINED',
    'PRICE_MISSING',
    'PRODUCT_CATEGORY_DEPTH_WARNING',
    'PRODUCT_LINK_MISSING',
    'PRODUCT_PRICE_INVALID',
    'PRODUCT_TYPE_LENGTH_TOO_LONG',
    'SALE_DATE_INVALID',
    'SALES_PRICE_INVALID',
    'SALES_PRICE_TOO_HIGH',
    'SALES_PRICE_TOO_LOW',
    'SHIPPING_INVALID',
    'SHIPPING_HEIGHT_INVALID',
    'SHIPPING_WEIGHT_INVALID',
    'SHIPPING_WIDTH_INVALID',
    'SIZE_SYSTEM_INVALID',
    'SIZE_TYPE_INVALID',
    'TAX_INVALID',
    'TITLE_LENGTH_TOO_LONG',
    'TITLE_MISSING',
    'TOO_MANY_ADDITIONAL_IMAGE_LINKS',
    'UTM_SOURCE_AUTO_CORRECTED',
    'WEIGHT_UNIT_INVALID',
  ],
} as const;

export const CatalogsItemValidationIssuesSchema = {
  type: 'object',
  properties: {
    item_number: {
      description:
        "Item number based on order of appearance in the Catalogs Feed. For example, '0' refers to first item found in a feed that was downloaded from a 'location' specified during feed creation.",
      example: 0,
      type: 'integer',
    },
    item_id: {
      description: 'The merchant-created unique ID that represents the product.',
      example: 'DS0294-L',
      type: 'string',
      nullable: true,
    },
    errors: {
      $ref: '#/components/schemas/CatalogsItemValidationErrors',
    },
    warnings: {
      $ref: '#/components/schemas/CatalogsItemValidationWarnings',
    },
  },
  required: ['item_number', 'item_id', 'errors', 'warnings'],
} as const;

export const CatalogsItemValidationWarningsSchema = {
  type: 'object',
  properties: {
    AD_LINK_FORMAT_WARNING: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has an ad link that is formatted incorrectly.',
    },
    AD_LINK_SAME_AS_LINK: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has an ad link URL that is duplicate of the link URL.',
    },
    ADDITIONAL_IMAGE_LINK_LENGTH_TOO_LONG: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item has an additional_image_link URL that contains too many characters, so the item will not be published.',
    },
    ADDITIONAL_IMAGE_LINK_WARNING: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item has additional_image_link URLs that are formatted incorrectly and will not be published with your items.',
    },
    ADWORDS_FORMAT_WARNING: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has an adwords_redirect link that is formatted incorrectly.',
    },
    ADWORDS_SAME_AS_LINK: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has an adwords_redirect URL that is duplicate of the link URL.',
    },
    AGE_GROUP_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item has an age group value that is formatted incorrectly, which may limit visibility in recommendations, search results and shopping experiences.',
    },
    SIZE_SYSTEM_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Some items have size system values which are not one of the supported size systems.',
    },
    ANDROID_DEEP_LINK_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item includes an invalid android_deep_link.',
    },
    AVAILABILITY_DATE_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item has an availability_date value that is formatted incorrectly, this item will be published without an availability date.',
    },
    COUNTRY_DOES_NOT_MAP_TO_CURRENCY: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        "Item includes a currency that doesn't match the usual currency for the location where the product is sold or shipped.",
    },
    CUSTOM_LABEL_LENGTH_TOO_LONG: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item has a custom_label value that is too long, this item will be published without that custom label.',
    },
    DESCRIPTION_LENGTH_TOO_LONG: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'The description for this item was truncated because it contains too many characters.',
    },
    EXPIRATION_DATE_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item has an expiration_date value that is formatted incorrectly, this item will be published without an expiration date.',
    },
    GENDER_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item has a gender value that is formatted incorrectly, which may limit visibility in recommendations, search results and shopping experiences.',
    },
    GTIN_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has a GTIN value that is formatted incorrectly.',
    },
    IMAGE_LINK_WARNING: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has an image_link URL that is formatted incorrectly and will not be published.',
    },
    IOS_DEEP_LINK_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item includes an invalid ios_deep_link value.',
    },
    IS_BUNDLE_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item has an is_bundle value that is formatted incorrectly, this item will be published without being bundled with other products.',
    },
    ITEM_ADDITIONAL_IMAGE_DOWNLOAD_FAILURE: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: "Item includes additional_image_links that can't be found.",
    },
    LINK_FORMAT_WARNING: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has an invalid product link which contains invalid UTM tracking paramaters.',
    },
    MIN_AD_PRICE_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item includes a min_ad_price value that is formatted incorrectly.',
    },
    MPN_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has a MPN value that is formatted incorrectly.',
    },
    MULTIPACK_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has an invalid multipack value.',
    },
    OPTIONAL_CONDITION_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item includes a condition value that is formatted incorrectly, which may limit visibility in recommendations, search results and shopping experiences.',
    },
    OPTIONAL_CONDITION_MISSING: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item is missing condition value, which may limit visibility in recommendations, search results and shopping experiences.',
    },
    OPTIONAL_PRODUCT_CATEGORY_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item includes a google_product_category value that is not formatted correctly according to the GPC taxonomy.',
    },
    OPTIONAL_PRODUCT_CATEGORY_MISSING: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item is missing google_product_category.',
    },
    PRODUCT_CATEGORY_DEPTH_WARNING: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item only has 1 or 2 levels of google_product_category value, which may limit visibility in recommendations, search results and shopping experiences.',
    },
    PRODUCT_TYPE_LENGTH_TOO_LONG: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item has a product_type value that is too long, this item will be published without that product type.',
    },
    SALES_PRICE_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has an incorrectly formatted sales price.',
    },
    SALES_PRICE_TOO_LOW: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has a sale price value that is discounted very low compared to the price.',
    },
    SALES_PRICE_TOO_HIGH: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has a sale price value that is higher than the original price of the item.',
    },
    SALE_DATE_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item has a sale_price_effective_date value that is formatted incorrectly, this item will be published without a sale date.',
    },
    SHIPPING_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has a shipping value that is formatted incorrectly.',
    },
    SHIPPING_HEIGHT_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item has an incorrectly formatted shipping_height value. The value must first contain a numeric value then a valid dimension unit type.',
    },
    SHIPPING_WEIGHT_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has an invalid shipping_weight value.',
    },
    SHIPPING_WIDTH_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item has an incorrectly formatted shipping_width value. The value must first contain a numeric value then a valid dimension unit type.',
    },
    SIZE_TYPE_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item has a size type value that is formatted incorrectly, which may limit visibility in recommendations, search results and shopping experiences.',
    },
    TAX_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'Item has a tax value that is formatted incorrectly.',
    },
    TITLE_LENGTH_TOO_LONG: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description: 'The title for the item was truncated because it contains too many characters.',
    },
    TOO_MANY_ADDITIONAL_IMAGE_LINKS: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item has a additional_image_link value that exceed the limit for additional images, this item will be published without some of your images.',
    },
    UTM_SOURCE_AUTO_CORRECTED: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item includes an utm_source value that is formatted incorrectly and has been automatically corrected.',
    },
    WEIGHT_UNIT_INVALID: {
      $ref: '#/components/schemas/CatalogsItemValidationDetails',
      description:
        'Item has a weight_unit value that is formatted incorrectly, this item will be published without a weight unit.',
    },
  },
} as const;

export const CatalogsItemsSchema = {
  type: 'object',
  description: 'Response object of catalogs items',
  properties: {
    items: {
      type: 'array',
      description: 'Array with catalogs items',
      items: {
        $ref: '#/components/schemas/ItemResponse',
      },
    },
  },
} as const;

export const CatalogsItemsBatchSchema = {
  type: 'object',
  description: 'Object describing the catalogs items batch',
  properties: {
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
  },
  required: ['catalog_type'],
  oneOf: [
    {
      $ref: '#/components/schemas/CatalogsRetailItemsBatch',
    },
    {
      $ref: '#/components/schemas/CatalogsHotelItemsBatch',
    },
    {
      $ref: '#/components/schemas/CatalogsCreativeAssetsItemsBatch',
    },
  ],
  discriminator: {
    propertyName: 'catalog_type',
    mapping: {
      RETAIL: '#/components/schemas/CatalogsRetailItemsBatch',
      HOTEL: '#/components/schemas/CatalogsHotelItemsBatch',
      CREATIVE_ASSETS: '#/components/schemas/CatalogsCreativeAssetsItemsBatch',
    },
  },
} as const;

export const CatalogsItemsFiltersSchema = {
  type: 'object',
  properties: {
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
  },
  required: ['catalog_type'],
  oneOf: [
    {
      $ref: '#/components/schemas/CatalogsRetailItemsFilter',
    },
    {
      $ref: '#/components/schemas/CatalogsHotelItemsFilter',
    },
    {
      $ref: '#/components/schemas/CatalogsCreativeAssetsItemsFilter',
    },
  ],
  discriminator: {
    propertyName: 'catalog_type',
    mapping: {
      RETAIL: '#/components/schemas/CatalogsRetailItemsFilter',
      HOTEL: '#/components/schemas/CatalogsHotelItemsFilter',
      CREATIVE_ASSETS: '#/components/schemas/CatalogsCreativeAssetsItemsFilter',
    },
  },
} as const;

export const CatalogsItemsPostFiltersSchema = {
  type: 'object',
  properties: {
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
  },
  required: ['catalog_type'],
  oneOf: [
    {
      $ref: '#/components/schemas/CatalogsRetailItemsPostFilter',
    },
    {
      $ref: '#/components/schemas/CatalogsHotelItemsPostFilter',
    },
    {
      $ref: '#/components/schemas/CatalogsCreativeAssetsItemsPostFilter',
    },
  ],
  discriminator: {
    propertyName: 'catalog_type',
    mapping: {
      RETAIL: '#/components/schemas/CatalogsRetailItemsPostFilter',
      HOTEL: '#/components/schemas/CatalogsHotelItemsPostFilter',
      CREATIVE_ASSETS: '#/components/schemas/CatalogsCreativeAssetsItemsPostFilter',
    },
  },
} as const;

export const CatalogsCreativeAssetsItemsBatchSchema = {
  type: 'object',
  description: 'Object describing the catalogs creative assets items batch',
  properties: {
    batch_id: {
      description: 'Id of the catalogs items batch',
      example: '595953100599279259-66753b9bb65c46c49bd8503b27fecf9e',
      type: 'string',
    },
    created_time: {
      description: "Date and time (UTC) of the batch creation: YYYY-MM-DD'T'hh:mm:ss",
      example: '2024-01-01T20:10:40',
      type: 'string',
      format: 'date-time',
      readOnly: true,
    },
    completed_time: {
      description: "Date and time (UTC) of the batch completion: YYYY-MM-DD'T'hh:mm:ss",
      example: '2024-01-01T20:20:00',
      type: 'string',
      format: 'date-time',
      readOnly: true,
      nullable: true,
    },
    status: {
      $ref: '#/components/schemas/BatchOperationStatus',
    },
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
    items: {
      description: 'Array with the catalogs items processing records part of the catalogs items batch',
      items: {
        $ref: '#/components/schemas/CreativeAssetsProcessingRecord',
      },
      type: 'array',
    },
  },
  required: ['catalog_type'],
} as const;

export const CatalogsHotelItemsBatchSchema = {
  type: 'object',
  description: 'Object describing the catalogs hotel items batch',
  properties: {
    batch_id: {
      description: 'Id of the catalogs items batch',
      example: '595953100599279259-66753b9bb65c46c49bd8503b27fecf9e',
      type: 'string',
    },
    created_time: {
      description: "Date and time (UTC) of the batch creation: YYYY-MM-DD'T'hh:mm:ss",
      example: '2024-01-01T20:10:40',
      type: 'string',
      format: 'date-time',
      readOnly: true,
    },
    completed_time: {
      description: "Date and time (UTC) of the batch completion: YYYY-MM-DD'T'hh:mm:ss",
      example: '2024-01-01T20:20:00',
      type: 'string',
      format: 'date-time',
      readOnly: true,
      nullable: true,
    },
    status: {
      $ref: '#/components/schemas/BatchOperationStatus',
    },
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
    items: {
      description: 'Array with the catalogs items processing records part of the catalogs items batch',
      items: {
        $ref: '#/components/schemas/HotelProcessingRecord',
      },
      type: 'array',
    },
  },
  required: ['catalog_type'],
} as const;

export const CatalogsRetailItemsBatchSchema = {
  type: 'object',
  description: 'Object describing the catalogs retail items batch',
  properties: {
    batch_id: {
      description: 'Id of the catalogs items batch',
      example: '595953100599279259-66753b9bb65c46c49bd8503b27fecf9e',
      type: 'string',
    },
    created_time: {
      description: "Date and time (UTC) of the batch creation: YYYY-MM-DD'T'hh:mm:ss",
      example: '2024-01-01T20:10:40',
      type: 'string',
      format: 'date-time',
      readOnly: true,
    },
    completed_time: {
      description: "Date and time (UTC) of the batch completion: YYYY-MM-DD'T'hh:mm:ss",
      example: '2024-01-01T20:20:00',
      type: 'string',
      format: 'date-time',
      readOnly: true,
      nullable: true,
    },
    status: {
      $ref: '#/components/schemas/BatchOperationStatus',
    },
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
    items: {
      description: 'Array with the catalogs items processing records part of the catalogs items batch',
      items: {
        $ref: '#/components/schemas/ItemProcessingRecord',
      },
      type: 'array',
    },
  },
  required: ['catalog_type'],
} as const;

export const CatalogsItemsRequestSchema = {
  type: 'object',
  additionalProperties: false,
  description: 'Request object of catalogs items',
  properties: {
    country: {
      $ref: '#/components/schemas/Country',
    },
    language: {
      description: 'We recommend using the CatalogsLocale values.',
      anyOf: [
        {
          $ref: '#/components/schemas/CatalogsLocale',
        },
        {
          $ref: '#/components/schemas/Language',
        },
      ],
    },
    filters: {
      $ref: '#/components/schemas/CatalogsItemsPostFilters',
    },
  },
  required: ['country', 'language', 'filters'],
} as const;

export const CatalogsItemsBatchRequestSchema = {
  type: 'object',
  title: 'legacy_retail_only',
  description: 'Request object of catalogs items batch',
  oneOf: [
    {
      $ref: '#/components/schemas/CatalogsItemsUpdateBatchRequest',
    },
    {
      $ref: '#/components/schemas/CatalogsItemsUpsertBatchRequest',
    },
    {
      $ref: '#/components/schemas/CatalogsItemsCreateBatchRequest',
    },
    {
      $ref: '#/components/schemas/CatalogsItemsDeleteDiscontinuedBatchRequest',
    },
    {
      $ref: '#/components/schemas/CatalogsItemsDeleteBatchRequest',
    },
  ],
  discriminator: {
    propertyName: 'operation',
    mapping: {
      UPDATE: '#/components/schemas/CatalogsItemsUpdateBatchRequest',
      UPSERT: '#/components/schemas/CatalogsItemsUpsertBatchRequest',
      CREATE: '#/components/schemas/CatalogsItemsCreateBatchRequest',
      DELETE_DISCONTINUED: '#/components/schemas/CatalogsItemsDeleteDiscontinuedBatchRequest',
      DELETE: '#/components/schemas/CatalogsItemsDeleteBatchRequest',
    },
  },
} as const;

export const CatalogsItemsCreateBatchRequestSchema = {
  description: 'Request object to create catalogs items',
  type: 'object',
  additionalProperties: false,
  properties: {
    country: {
      $ref: '#/components/schemas/Country',
    },
    language: {
      description: 'We recommend using the CatalogsLocale values.',
      anyOf: [
        {
          $ref: '#/components/schemas/CatalogsLocale',
        },
        {
          $ref: '#/components/schemas/Language',
        },
      ],
    },
    operation: {
      $ref: '#/components/schemas/BatchOperation',
    },
    items: {
      type: 'array',
      description: 'Array with catalogs items',
      items: {
        $ref: '#/components/schemas/ItemCreateBatchRecord',
      },
      minItems: 1,
      maxItems: 1000,
    },
  },
  required: ['country', 'language', 'operation', 'items'],
} as const;

export const CatalogsItemsDeleteBatchRequestSchema = {
  description: 'Request object to delete catalogs items',
  type: 'object',
  additionalProperties: false,
  properties: {
    country: {
      $ref: '#/components/schemas/Country',
    },
    language: {
      description: 'We recommend using the CatalogsLocale values.',
      anyOf: [
        {
          $ref: '#/components/schemas/CatalogsLocale',
        },
        {
          $ref: '#/components/schemas/Language',
        },
      ],
    },
    operation: {
      $ref: '#/components/schemas/BatchOperation',
    },
    items: {
      type: 'array',
      description: 'Array with catalogs items',
      items: {
        $ref: '#/components/schemas/ItemDeleteBatchRecord',
      },
    },
  },
  required: ['country', 'language', 'operation', 'items'],
} as const;

export const CatalogsItemsDeleteDiscontinuedBatchRequestSchema = {
  description: 'Request object to discontinue catalogs items',
  type: 'object',
  additionalProperties: false,
  properties: {
    country: {
      $ref: '#/components/schemas/Country',
    },
    language: {
      description: 'We recommend using the CatalogsLocale values.',
      anyOf: [
        {
          $ref: '#/components/schemas/CatalogsLocale',
        },
        {
          $ref: '#/components/schemas/Language',
        },
      ],
    },
    operation: {
      $ref: '#/components/schemas/BatchOperation',
    },
    items: {
      type: 'array',
      description: 'Array with catalogs items',
      items: {
        $ref: '#/components/schemas/ItemDeleteDiscontinuedBatchRecord',
      },
    },
  },
  required: ['country', 'language', 'operation', 'items'],
} as const;

export const CatalogsItemsUpdateBatchRequestSchema = {
  description: 'Request object to update catalogs items',
  type: 'object',
  additionalProperties: false,
  properties: {
    country: {
      $ref: '#/components/schemas/Country',
    },
    language: {
      description: 'We recommend using the CatalogsLocale values.',
      anyOf: [
        {
          $ref: '#/components/schemas/CatalogsLocale',
        },
        {
          $ref: '#/components/schemas/Language',
        },
      ],
    },
    operation: {
      $ref: '#/components/schemas/BatchOperation',
    },
    items: {
      type: 'array',
      description: 'Array with catalogs items',
      items: {
        $ref: '#/components/schemas/ItemUpdateBatchRecord',
      },
      minItems: 1,
      maxItems: 1000,
    },
  },
  required: ['country', 'language', 'operation', 'items'],
} as const;

export const CatalogsItemsUpsertBatchRequestSchema = {
  description: 'Request object to upsert catalogs items',
  type: 'object',
  properties: {
    country: {
      $ref: '#/components/schemas/Country',
    },
    language: {
      description: 'We recommend using the CatalogsLocale values.',
      anyOf: [
        {
          $ref: '#/components/schemas/CatalogsLocale',
        },
        {
          $ref: '#/components/schemas/Language',
        },
      ],
    },
    operation: {
      $ref: '#/components/schemas/BatchOperation',
    },
    items: {
      type: 'array',
      description: 'Array with catalogs items',
      items: {
        $ref: '#/components/schemas/ItemUpsertBatchRecord',
      },
      minItems: 1,
      maxItems: 1000,
    },
  },
  required: ['country', 'language', 'operation', 'items'],
} as const;

export const CatalogsListProductsByFilterRequestSchema = {
  description: 'Request object to list products for a given product group filter.',
  type: 'object',
  oneOf: [
    {
      $ref: '#/components/schemas/CatalogsListProductsByFeedBasedFilter',
    },
    {
      $ref: '#/components/schemas/CatalogsVerticalsListProductsByCatalogBasedFilterRequest',
    },
  ],
} as const;

export const CatalogsListProductsByFeedBasedFilterSchema = {
  title: 'feed based product group',
  description: 'Request object to list products for a given feed_id and product group filter.',
  type: 'object',
  additionalProperties: false,
  properties: {
    feed_id: {
      description: 'Catalog Feed id pertaining to the catalog product group filter.',
      example: '2680059592705',
      type: 'string',
      pattern: '^\\d+$',
    },
    filters: {
      $ref: '#/components/schemas/CatalogsProductGroupFilters',
    },
  },
  required: ['feed_id', 'filters'],
} as const;

export const CatalogsVerticalsListProductsByCatalogBasedFilterRequestSchema = {
  type: 'object',
  title: 'catalog based product group',
  description: 'Request object to list products for a given catalog_id and product group filter.',
  oneOf: [
    {
      $ref: '#/components/schemas/CatalogsRetailListProductsByCatalogBasedFilterRequest',
    },
    {
      $ref: '#/components/schemas/CatalogsHotelListProductsByCatalogBasedFilterRequest',
    },
    {
      $ref: '#/components/schemas/CatalogsCreativeAssetsListProductsByCatalogBasedFilterRequest',
    },
  ],
  discriminator: {
    propertyName: 'catalog_type',
    mapping: {
      RETAIL: '#/components/schemas/CatalogsRetailListProductsByCatalogBasedFilterRequest',
      HOTEL: '#/components/schemas/CatalogsHotelListProductsByCatalogBasedFilterRequest',
      CREATIVE_ASSETS: '#/components/schemas/CatalogsCreativeAssetsListProductsByCatalogBasedFilterRequest',
    },
  },
} as const;

export const CatalogsRetailListProductsByCatalogBasedFilterRequestSchema = {
  type: 'object',
  title: 'retail_list_products_by_catalog_based_filter_request',
  additionalProperties: false,
  description: 'Request object to list products for a given retail catalog_id and product group filter.',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['RETAIL'],
      description:
        'Retail catalog based product group is available only for selected partners at the moment. If you are not eligible, please use feed based one.',
    },
    catalog_id: {
      description: 'Catalog id pertaining to the retail product group.',
      example: '2680059592705',
      type: 'string',
      pattern: '^\\d+$',
    },
    filters: {
      $ref: '#/components/schemas/CatalogsProductGroupFilters',
    },
    country: {
      $ref: '#/components/schemas/Country',
    },
    locale: {
      $ref: '#/components/schemas/CatalogsLocale',
    },
  },
  required: ['catalog_type', 'catalog_id', 'filters', 'country', 'locale'],
} as const;

export const CatalogsHotelListProductsByCatalogBasedFilterRequestSchema = {
  type: 'object',
  title: 'hotel_list_products_by_catalog_based_filter_request',
  additionalProperties: false,
  description: 'Request object to list products for a given hotel catalog_id and product group filter.',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['HOTEL'],
    },
    catalog_id: {
      description: 'Catalog id pertaining to the hotel product group.',
      example: '2680059592705',
      type: 'string',
      pattern: '^\\d+$',
    },
    filters: {
      $ref: '#/components/schemas/CatalogsHotelProductGroupFilters',
    },
  },
  required: ['catalog_type', 'catalog_id', 'filters'],
} as const;

export const CatalogsCreativeAssetsListProductsByCatalogBasedFilterRequestSchema = {
  type: 'object',
  title: 'creative_assets_list_products_by_catalog_based_filter_request',
  additionalProperties: false,
  description: 'Request object to list products for a given creative assets catalog_id and product group filter.',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['CREATIVE_ASSETS'],
    },
    catalog_id: {
      description: 'Catalog id pertaining to the creative assets product group.',
      example: '2680059592705',
      type: 'string',
      pattern: '^\\d+$',
    },
    filters: {
      $ref: '#/components/schemas/CatalogsCreativeAssetsProductGroupFilters',
    },
  },
  required: ['catalog_type', 'catalog_id', 'filters'],
} as const;

export const CatalogsLocaleSchema = {
  type: 'string',
  enum: [
    'af-ZA',
    'ar-SA',
    'bg-BG',
    'bn-IN',
    'cs-CZ',
    'da-DK',
    'de',
    'el-GR',
    'en-AU',
    'en-CA',
    'en-GB',
    'en-IN',
    'en-US',
    'es-419',
    'es-AR',
    'es-ES',
    'es-MX',
    'fi-FI',
    'fr',
    'fr-CA',
    'he-IL',
    'hi-IN',
    'hr-HR',
    'hu-HU',
    'id-ID',
    'it',
    'ja',
    'ko-KR',
    'ms-MY',
    'nb-NO',
    'nl',
    'pl-PL',
    'pt-BR',
    'pt-PT',
    'ro-RO',
    'ru-RU',
    'sk-SK',
    'sv-SE',
    'te-IN',
    'th-TH',
    'tl-PH',
    'tr',
    'uk-UA',
    'vi-VN',
    'zh-CN',
    'zh-TW',
  ],
} as const;

export const CatalogsProductSchema = {
  type: 'object',
  description: 'Catalogs product for all verticals',
  properties: {
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
  },
  required: ['catalog_type'],
  oneOf: [
    {
      $ref: '#/components/schemas/CatalogsRetailProduct',
    },
    {
      $ref: '#/components/schemas/CatalogsHotelProduct',
    },
    {
      $ref: '#/components/schemas/CatalogsCreativeAssetsProduct',
    },
  ],
  discriminator: {
    propertyName: 'catalog_type',
    mapping: {
      RETAIL: '#/components/schemas/CatalogsRetailProduct',
      HOTEL: '#/components/schemas/CatalogsHotelProduct',
      CREATIVE_ASSETS: '#/components/schemas/CatalogsCreativeAssetsProduct',
    },
  },
} as const;

export const CatalogsVerticalProductGroupSchema = {
  type: 'object',
  title: 'product_group',
  oneOf: [
    {
      $ref: '#/components/schemas/CatalogsRetailProductGroup',
    },
    {
      $ref: '#/components/schemas/CatalogsHotelProductGroup',
    },
    {
      $ref: '#/components/schemas/CatalogsCreativeAssetsProductGroup',
    },
  ],
  discriminator: {
    propertyName: 'catalog_type',
    mapping: {
      RETAIL: '#/components/schemas/CatalogsRetailProductGroup',
      HOTEL: '#/components/schemas/CatalogsHotelProductGroup',
      CREATIVE_ASSETS: '#/components/schemas/CatalogsCreativeAssetsProductGroup',
    },
  },
} as const;

export const CatalogsCreativeAssetsProductGroupSchema = {
  type: 'object',
  title: 'creative_assets_product_group',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['CREATIVE_ASSETS'],
    },
    id: {
      description: 'ID of the creative assets product group.',
      example: '443727193917',
      type: 'string',
      pattern: '^\\d+$',
    },
    name: {
      description: 'Name of creative assets product group',
      example: 'Most Popular',
      type: 'string',
    },
    description: {
      type: 'string',
      nullable: true,
    },
    filters: {
      $ref: '#/components/schemas/CatalogsCreativeAssetsProductGroupFilters',
    },
    created_at: {
      description: 'Unix timestamp in seconds of when catalog product group was created.',
      example: 1621350033000,
      type: 'integer',
    },
    updated_at: {
      description: 'Unix timestamp in seconds of last time catalog product group was updated.',
      example: 1622742155000,
      type: 'integer',
    },
    catalog_id: {
      description: 'Catalog id pertaining to the creative assets product group.',
      type: 'string',
      pattern: '^\\d+$',
    },
  },
  required: ['id', 'filters', 'catalog_type', 'catalog_id'],
} as const;

export const CatalogsCreativeAssetsProductGroupFiltersSchema = {
  description: 'Object holding a group of filters for a creative assets product group',
  title: 'catalogs_product_group_filters',
  type: 'object',
  anyOf: [
    {
      $ref: '#/components/schemas/CatalogsCreativeAssetsProductGroupFiltersAnyOf',
    },
    {
      $ref: '#/components/schemas/CatalogsCreativeAssetsProductGroupFiltersAllOf',
    },
  ],
} as const;

export const CatalogsCreativeAssetsProductGroupFiltersAllOfSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    all_of: {
      type: 'array',
      items: {
        type: 'object',
        $ref: '#/components/schemas/CatalogsCreativeAssetsProductGroupFilterKeys',
      },
    },
  },
  required: ['all_of'],
} as const;

export const CatalogsCreativeAssetsProductGroupFiltersAnyOfSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    any_of: {
      type: 'array',
      items: {
        type: 'object',
        $ref: '#/components/schemas/CatalogsCreativeAssetsProductGroupFilterKeys',
      },
    },
  },
  required: ['any_of'],
} as const;

export const CatalogsCreativeAssetsProductGroupFilterKeysSchema = {
  title: 'catalogs_product_group_keys',
  anyOf: [
    {
      $ref: '#/components/schemas/CreativeAssetsIdFilter',
    },
    {
      $ref: '#/components/schemas/CustomLabel0Filter',
    },
    {
      $ref: '#/components/schemas/CustomLabel1Filter',
    },
    {
      $ref: '#/components/schemas/CustomLabel2Filter',
    },
    {
      $ref: '#/components/schemas/CustomLabel3Filter',
    },
    {
      $ref: '#/components/schemas/CustomLabel4Filter',
    },
    {
      $ref: '#/components/schemas/GoogleProductCategory6Filter',
    },
    {
      $ref: '#/components/schemas/GoogleProductCategory5Filter',
    },
    {
      $ref: '#/components/schemas/GoogleProductCategory4Filter',
    },
    {
      $ref: '#/components/schemas/GoogleProductCategory3Filter',
    },
    {
      $ref: '#/components/schemas/GoogleProductCategory2Filter',
    },
    {
      $ref: '#/components/schemas/GoogleProductCategory1Filter',
    },
    {
      $ref: '#/components/schemas/GoogleProductCategory0Filter',
    },
    {
      $ref: '#/components/schemas/MediaTypeFilter',
    },
  ],
} as const;

export const CatalogsCreativeAssetsProductGroupCreateRequestSchema = {
  type: 'object',
  title: 'creative_assets_product_groups_create_request',
  additionalProperties: false,
  description: 'Request object for creating a creative assets product group.',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['CREATIVE_ASSETS'],
    },
    name: {
      type: 'string',
    },
    description: {
      type: 'string',
      nullable: true,
    },
    filters: {
      $ref: '#/components/schemas/CatalogsCreativeAssetsProductGroupFilters',
    },
    catalog_id: {
      description: 'Catalog id pertaining to the creative assets product group.',
      example: '2680059592705',
      type: 'string',
      pattern: '^\\d+$',
    },
  },
  required: ['name', 'filters', 'catalog_id', 'catalog_type'],
} as const;

export const CatalogsCreativeAssetsProductGroupUpdateRequestSchema = {
  type: 'object',
  title: 'creative_assets_product_groups_update_request',
  additionalProperties: false,
  description: 'Request object for updating a creative assets product group.',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['CREATIVE_ASSETS'],
    },
    name: {
      type: 'string',
    },
    description: {
      type: 'string',
      nullable: true,
    },
    filters: {
      $ref: '#/components/schemas/CatalogsCreativeAssetsProductGroupFilters',
    },
  },
} as const;

export const CatalogsHotelProductGroupSchema = {
  type: 'object',
  title: 'hotel_product_group',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['HOTEL'],
    },
    id: {
      description: 'ID of the hotel product group.',
      example: '443727193917',
      type: 'string',
      pattern: '^\\d+$',
    },
    name: {
      description: 'Name of hotel product group',
      example: 'Most Popular',
      type: 'string',
    },
    description: {
      type: 'string',
      nullable: true,
    },
    filters: {
      $ref: '#/components/schemas/CatalogsHotelProductGroupFilters',
    },
    created_at: {
      description: 'Unix timestamp in seconds of when catalog product group was created.',
      example: 1621350033000,
      type: 'integer',
    },
    updated_at: {
      description: 'Unix timestamp in seconds of last time catalog product group was updated.',
      example: 1622742155000,
      type: 'integer',
    },
    catalog_id: {
      description: 'Catalog id pertaining to the hotel product group.',
      type: 'string',
      pattern: '^\\d+$',
    },
  },
  required: ['id', 'filters', 'catalog_type', 'catalog_id'],
} as const;

export const CatalogsHotelProductGroupFilterKeysSchema = {
  title: 'catalogs_product_group_keys',
  anyOf: [
    {
      $ref: '#/components/schemas/PriceFilter',
    },
    {
      $ref: '#/components/schemas/HotelIdFilter',
    },
    {
      $ref: '#/components/schemas/BrandFilter',
    },
    {
      $ref: '#/components/schemas/CustomLabel0Filter',
    },
    {
      $ref: '#/components/schemas/CustomLabel1Filter',
    },
    {
      $ref: '#/components/schemas/CustomLabel2Filter',
    },
    {
      $ref: '#/components/schemas/CustomLabel3Filter',
    },
    {
      $ref: '#/components/schemas/CustomLabel4Filter',
    },
    {
      $ref: '#/components/schemas/CountryFilter',
    },
  ],
} as const;

export const CatalogsHotelProductGroupFiltersSchema = {
  description: 'Object holding a group of filters for a hotel product group',
  title: 'catalogs_product_group_filters',
  type: 'object',
  anyOf: [
    {
      $ref: '#/components/schemas/CatalogsHotelProductGroupFiltersAnyOf',
    },
    {
      $ref: '#/components/schemas/CatalogsHotelProductGroupFiltersAllOf',
    },
  ],
} as const;

export const CatalogsHotelProductGroupFiltersAllOfSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    all_of: {
      type: 'array',
      items: {
        type: 'object',
        $ref: '#/components/schemas/CatalogsHotelProductGroupFilterKeys',
      },
    },
  },
  required: ['all_of'],
} as const;

export const CatalogsHotelProductGroupFiltersAnyOfSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    any_of: {
      type: 'array',
      items: {
        type: 'object',
        $ref: '#/components/schemas/CatalogsHotelProductGroupFilterKeys',
      },
    },
  },
  required: ['any_of'],
} as const;

export const CatalogsRetailProductGroupSchema = {
  type: 'object',
  title: 'retail_product_group',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['RETAIL'],
    },
    id: {
      description: 'ID of the catalog product group.',
      example: '443727193917',
      type: 'string',
      pattern: '^\\d+$',
    },
    name: {
      description: 'Name of catalog product group',
      example: 'Most Popular',
      type: 'string',
    },
    description: {
      type: 'string',
      nullable: true,
    },
    filters: {
      $ref: '#/components/schemas/CatalogsProductGroupFilters',
    },
    is_featured: {
      deprecated: true,
      description: 'boolean indicator of whether the product group is being featured or not',
      type: 'boolean',
    },
    type: {
      $ref: '#/components/schemas/CatalogsProductGroupType',
    },
    status: {
      $ref: '#/components/schemas/CatalogsProductGroupStatus',
    },
    created_at: {
      description: 'Unix timestamp in seconds of when catalog product group was created.',
      example: 1621350033000,
      type: 'integer',
    },
    updated_at: {
      description: 'Unix timestamp in seconds of last time catalog product group was updated.',
      example: 1622742155000,
      type: 'integer',
    },
    catalog_id: {
      description: 'Catalog id pertaining to the retail product group.',
      type: 'string',
      pattern: '^\\d+$',
    },
    feed_id: {
      description: 'id of the catalogs feed belonging to this catalog product group',
      example: '2680059592705',
      type: 'string',
      pattern: '^\\d+$',
      nullable: true,
    },
    country: {
      type: 'string',
      nullable: true,
    },
    locale: {
      type: 'string',
      nullable: true,
    },
  },
  required: ['filters', 'id', 'catalog_id', 'feed_id', 'catalog_type'],
} as const;

export const CatalogsHotelProductGroupCreateRequestSchema = {
  type: 'object',
  title: 'hotel_product_groups_create_request',
  additionalProperties: false,
  description: 'Request object for creating a hotel product group.',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['HOTEL'],
    },
    name: {
      type: 'string',
    },
    description: {
      type: 'string',
      nullable: true,
    },
    filters: {
      $ref: '#/components/schemas/CatalogsHotelProductGroupFilters',
    },
    catalog_id: {
      description: 'Catalog id pertaining to the hotel product group.',
      example: '2680059592705',
      type: 'string',
      pattern: '^\\d+$',
    },
  },
  required: ['name', 'filters', 'catalog_id', 'catalog_type'],
} as const;

export const CatalogsRetailProductGroupCreateRequestSchema = {
  type: 'object',
  title: 'retail_product_groups_create_request',
  additionalProperties: false,
  description: 'Request object for creating a product group.',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['RETAIL'],
      description:
        'Retail catalog based product group is available only for selected partners at the moment. If you are not eligible, please use feed based one.',
    },
    name: {
      type: 'string',
    },
    description: {
      type: 'string',
      nullable: true,
    },
    filters: {
      $ref: '#/components/schemas/CatalogsProductGroupFiltersRequest',
    },
    catalog_id: {
      description: 'Catalog id pertaining to the retail product group.',
      example: '2680059592705',
      type: 'string',
      pattern: '^\\d+$',
    },
    country: {
      $ref: '#/components/schemas/Country',
    },
    locale: {
      $ref: '#/components/schemas/CatalogsLocale',
    },
  },
  required: ['name', 'filters', 'catalog_id', 'catalog_type', 'country', 'locale'],
} as const;

export const CatalogsHotelProductGroupUpdateRequestSchema = {
  type: 'object',
  title: 'hotel_product_groups_update_request',
  additionalProperties: false,
  description: 'Request object for updating a hotel product group.',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['HOTEL'],
    },
    name: {
      type: 'string',
    },
    description: {
      type: 'string',
      nullable: true,
    },
    filters: {
      $ref: '#/components/schemas/CatalogsHotelProductGroupFilters',
    },
  },
} as const;

export const CatalogsRetailProductGroupUpdateRequestSchema = {
  type: 'object',
  title: 'retail_product_groups_update_request',
  additionalProperties: false,
  description: 'Request object for updating a retail product group.',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['RETAIL'],
      description:
        'Retail catalog based product group is available only for selected partners at the moment. If you are not eligible, please use feed based one.',
    },
    name: {
      type: 'string',
    },
    description: {
      type: 'string',
      nullable: true,
    },
    filters: {
      $ref: '#/components/schemas/CatalogsProductGroupFiltersRequest',
    },
    country: {
      $ref: '#/components/schemas/Country',
    },
    locale: {
      $ref: '#/components/schemas/CatalogsLocale',
    },
  },
} as const;

export const CatalogsProductGroupCreateRequestSchema = {
  type: 'object',
  title: 'retail feed based',
  description: 'Request object for creating a product group.',
  properties: {
    name: {
      type: 'string',
    },
    description: {
      type: 'string',
      nullable: true,
    },
    is_featured: {
      deprecated: true,
      description: 'boolean indicator of whether the product group is being featured or not',
      type: 'boolean',
      default: false,
    },
    filters: {
      $ref: '#/components/schemas/CatalogsProductGroupFiltersRequest',
    },
    feed_id: {
      description: 'Catalog Feed id pertaining to the catalog product group.',
      example: '2680059592705',
      type: 'string',
      pattern: '^\\d+$',
    },
  },
  required: ['name', 'filters', 'feed_id'],
} as const;

export const CatalogsProductGroupCurrencyCriteriaSchema = {
  title: 'catalogs_product_group_currency_criteria',
  type: 'object',
  description: 'A currency filter. This filter cannot be negated',
  additionalProperties: false,
  properties: {
    values: {
      $ref: '#/components/schemas/NonNullableCatalogsCurrency',
    },
    negated: {
      type: 'boolean',
      default: false,
      enum: [false],
    },
  },
  required: ['values'],
} as const;

export const CatalogsProductGroupFilterKeysSchema = {
  title: 'catalogs_product_group_keys',
  anyOf: [
    {
      $ref: '#/components/schemas/MinPriceFilter',
    },
    {
      $ref: '#/components/schemas/MaxPriceFilter',
    },
    {
      $ref: '#/components/schemas/CurrencyFilter',
    },
    {
      $ref: '#/components/schemas/ItemIdFilter',
    },
    {
      $ref: '#/components/schemas/AvailabilityFilter',
    },
    {
      $ref: '#/components/schemas/BrandFilter',
    },
    {
      $ref: '#/components/schemas/ConditionFilter',
    },
    {
      $ref: '#/components/schemas/CustomLabel0Filter',
    },
    {
      $ref: '#/components/schemas/CustomLabel1Filter',
    },
    {
      $ref: '#/components/schemas/CustomLabel2Filter',
    },
    {
      $ref: '#/components/schemas/CustomLabel3Filter',
    },
    {
      $ref: '#/components/schemas/CustomLabel4Filter',
    },
    {
      $ref: '#/components/schemas/ItemGroupIdFilter',
    },
    {
      $ref: '#/components/schemas/GenderFilter',
    },
    {
      $ref: '#/components/schemas/MediaTypeFilter',
    },
    {
      $ref: '#/components/schemas/ProductType4Filter',
    },
    {
      $ref: '#/components/schemas/ProductType3Filter',
    },
    {
      $ref: '#/components/schemas/ProductType2Filter',
    },
    {
      $ref: '#/components/schemas/ProductType1Filter',
    },
    {
      $ref: '#/components/schemas/ProductType0Filter',
    },
    {
      $ref: '#/components/schemas/GoogleProductCategory6Filter',
    },
    {
      $ref: '#/components/schemas/GoogleProductCategory5Filter',
    },
    {
      $ref: '#/components/schemas/GoogleProductCategory4Filter',
    },
    {
      $ref: '#/components/schemas/GoogleProductCategory3Filter',
    },
    {
      $ref: '#/components/schemas/GoogleProductCategory2Filter',
    },
    {
      $ref: '#/components/schemas/GoogleProductCategory1Filter',
    },
    {
      $ref: '#/components/schemas/GoogleProductCategory0Filter',
    },
    {
      $ref: '#/components/schemas/ProductGroupReferenceFilter',
    },
  ],
} as const;

export const CatalogsProductGroupFiltersSchema = {
  description: 'Object holding a group of filters for a catalog product group',
  title: 'catalogs_product_group_filters',
  type: 'object',
  anyOf: [
    {
      $ref: '#/components/schemas/CatalogsProductGroupFiltersAnyOf',
    },
    {
      $ref: '#/components/schemas/CatalogsProductGroupFiltersAllOf',
    },
  ],
} as const;

export const CatalogsProductGroupFiltersAllOfSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    all_of: {
      type: 'array',
      items: {
        type: 'object',
        $ref: '#/components/schemas/CatalogsProductGroupFilterKeys',
      },
    },
  },
  required: ['all_of'],
} as const;

export const CatalogsProductGroupFiltersRequestSchema = {
  description:
    'Object holding a group of filters for request on catalog product group. This is a distinct schema It is not possible to create or update a Product Group with empty filters. But some automatically generated Product Groups might have empty filters.',
  title: 'catalogs_product_group_filters',
  type: 'object',
  anyOf: [
    {
      type: 'object',
      additionalProperties: false,
      properties: {
        any_of: {
          type: 'array',
          items: {
            type: 'object',
            $ref: '#/components/schemas/CatalogsProductGroupFilterKeys',
          },
          minItems: 1,
        },
      },
      required: ['any_of'],
    },
    {
      type: 'object',
      additionalProperties: false,
      properties: {
        all_of: {
          type: 'array',
          items: {
            type: 'object',
            $ref: '#/components/schemas/CatalogsProductGroupFilterKeys',
          },
          minItems: 1,
        },
      },
      required: ['all_of'],
    },
  ],
} as const;

export const CatalogsProductGroupFiltersAnyOfSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    any_of: {
      type: 'array',
      items: {
        type: 'object',
        $ref: '#/components/schemas/CatalogsProductGroupFilterKeys',
      },
    },
  },
  required: ['any_of'],
} as const;

export const CatalogsProductGroupMultipleCountriesCriteriaSchema = {
  title: 'catalogs_product_group_multiple_country_criteria',
  type: 'object',
  additionalProperties: false,
  properties: {
    values: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/Country',
      },
    },
    negated: {
      type: 'boolean',
      default: false,
    },
  },
  required: ['values'],
} as const;

export const CatalogsProductGroupMultipleGenderCriteriaSchema = {
  title: 'catalogs_product_group_multiple_gender_criteria',
  type: 'object',
  additionalProperties: false,
  properties: {
    values: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/Gender',
      },
    },
    negated: {
      type: 'boolean',
      default: false,
    },
  },
  required: ['values'],
} as const;

export const CatalogsProductGroupMultipleMediaTypesCriteriaSchema = {
  title: 'catalogs_product_group_multiple_media_type_criteria',
  type: 'object',
  additionalProperties: false,
  properties: {
    values: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/MediaType',
      },
    },
    negated: {
      type: 'boolean',
      default: false,
    },
  },
  required: ['values'],
} as const;

export const CatalogsProductGroupMultipleStringCriteriaSchema = {
  title: 'catalogs_product_group_multiple_string_criteria',
  type: 'object',
  additionalProperties: false,
  properties: {
    values: {
      type: 'array',
      items: {
        type: 'string',
      },
    },
    negated: {
      type: 'boolean',
      default: false,
    },
  },
  required: ['values'],
} as const;

export const CatalogsProductGroupMultipleStringListCriteriaSchema = {
  title: 'catalogs_product_group_multiple_string_list_criteria',
  type: 'object',
  additionalProperties: false,
  properties: {
    values: {
      type: 'array',
      items: {
        type: 'array',
        items: {
          type: 'string',
        },
      },
    },
    negated: {
      type: 'boolean',
      default: false,
    },
  },
  required: ['values'],
} as const;

export const CatalogsProductGroupPricingCriteriaSchema = {
  title: 'catalogs_product_group_pricing_criteria',
  type: 'object',
  additionalProperties: false,
  properties: {
    inclusion: {
      type: 'boolean',
      default: true,
    },
    values: {
      type: 'number',
      minimum: 0,
    },
    negated: {
      type: 'boolean',
      default: false,
    },
  },
  required: ['values'],
} as const;

export const CatalogsProductGroupProductCountsVerticalSchema = {
  type: 'object',
  description: 'Product counts for a CatalogsProductGroup',
  properties: {
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
  },
  required: ['catalog_type'],
  oneOf: [
    {
      $ref: '#/components/schemas/CatalogsRetailProductGroupProductCounts',
    },
    {
      $ref: '#/components/schemas/CatalogsHotelProductGroupProductCounts',
    },
    {
      $ref: '#/components/schemas/CatalogsCreativeAssetsProductGroupProductCounts',
    },
  ],
  discriminator: {
    propertyName: 'catalog_type',
    mapping: {
      RETAIL: '#/components/schemas/CatalogsRetailProductGroupProductCounts',
      HOTEL: '#/components/schemas/CatalogsHotelProductGroupProductCounts',
      CREATIVE_ASSETS: '#/components/schemas/CatalogsCreativeAssetsProductGroupProductCounts',
    },
  },
} as const;

export const CatalogsHotelProductGroupProductCountsSchema = {
  title: 'catalogs_hotel_product_group_product_counts',
  description: 'Product counts for a Hotel CatalogsProductGroup',
  type: 'object',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['HOTEL'],
    },
    total: {
      type: 'number',
      minimum: 0,
    },
  },
  required: ['catalog_type', 'total'],
} as const;

export const CatalogsCreativeAssetsProductGroupProductCountsSchema = {
  title: 'catalogs_creative_assets_product_group_product_counts',
  description: 'Product counts for a Creative Assets CatalogsProductGroup',
  type: 'object',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['CREATIVE_ASSETS'],
    },
    total: {
      type: 'number',
      minimum: 0,
    },
    videos: {
      type: 'number',
      minimum: 0,
    },
  },
  required: ['catalog_type', 'total', 'videos'],
} as const;

export const CatalogsRetailProductGroupProductCountsSchema = {
  title: 'catalogs_retail_product_group_product_counts',
  description: 'Product counts for a Retail CatalogsProductGroup',
  type: 'object',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['RETAIL'],
    },
    in_stock: {
      type: 'number',
      minimum: 0,
    },
    out_of_stock: {
      type: 'number',
      minimum: 0,
    },
    preorder: {
      type: 'number',
      minimum: 0,
    },
    total: {
      type: 'number',
      minimum: 0,
    },
    videos: {
      type: 'number',
      minimum: 0,
    },
  },
  required: ['catalog_type', 'in_stock', 'out_of_stock', 'preorder', 'total'],
} as const;

export const CatalogsProductGroupStatusSchema = {
  type: 'string',
  enum: ['ACTIVE', 'INACTIVE'],
} as const;

export const CatalogsProductGroupTypeSchema = {
  type: 'string',
  title: 'product_group_type',
  description: `<p>Catalog product group type</p>
<p>MERCHANT_CREATED: Product groups created by merchants.
<br>ALL_PRODUCTS: Consists of every product in your latest successful feed upload.
<br>BEST_DEALS: Consists of products with the deepest drop in price.
<br>PINNER_FAVORITES: Consists of products that are resonating most with people on Pinterest, based on engagement.
<br>TOP_SELLERS: Consists of products with the highest conversion rate, if you have the conversion tag installed.
<br>BACK_IN_STOCK: Consists of products that were previously out of stock and are now in stock.
<br>NEW_ARRIVALS: Consists of products that are new to your Catalog.
<br>SHOPIFY_COLLECTION: Product groups created based on Shopify Product Collections.
<br>I2PC: Product groups created based on predicted product category.</p>`,
  enum: [
    'MERCHANT_CREATED',
    'ALL_PRODUCTS',
    'BEST_DEALS',
    'PINNER_FAVORITES',
    'TOP_SELLERS',
    'BACK_IN_STOCK',
    'NEW_ARRIVALS',
    'SHOPIFY_COLLECTIONS',
    'I2PC',
  ],
  example: 'TOP_SELLERS',
} as const;

export const CatalogsProductGroupUpdateRequestSchema = {
  type: 'object',
  title: 'retail feed based',
  additionalProperties: false,
  description: 'Request object for updating a product group.',
  properties: {
    name: {
      type: 'string',
    },
    description: {
      type: 'string',
      nullable: true,
    },
    is_featured: {
      deprecated: true,
      description: 'boolean indicator of whether the product group is being featured or not',
      type: 'boolean',
    },
    filters: {
      $ref: '#/components/schemas/CatalogsProductGroupFiltersRequest',
    },
  },
} as const;

export const CatalogsRetailProductSchema = {
  type: 'object',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['RETAIL'],
    },
    metadata: {
      $ref: '#/components/schemas/CatalogsRetailProductMetadata',
    },
    pin: {
      $ref: '#/components/schemas/Pin',
    },
  },
  required: ['catalog_type', 'metadata', 'pin'],
} as const;

export const CatalogsRetailProductMetadataSchema = {
  type: 'object',
  description: 'Retail product metadata entity',
  properties: {
    item_id: {
      description: 'The user-created unique ID that represents the product.',
      example: 'DS0294-L',
      type: 'string',
    },
    item_group_id: {
      description: 'The parent ID of the product.',
      example: 'DS0294',
      type: 'string',
      nullable: true,
    },
    availability: {
      $ref: '#/components/schemas/NonNullableProductAvailabilityType',
    },
    price: {
      description: 'The price of the product.',
      example: 24.99,
      type: 'number',
    },
    sale_price: {
      description: 'The discounted price of the product.',
      example: 14.99,
      type: 'number',
      nullable: true,
    },
    currency: {
      $ref: '#/components/schemas/NonNullableCatalogsCurrency',
    },
  },
  required: ['item_id', 'item_group_id', 'availability', 'price', 'sale_price', 'currency'],
} as const;

export const CatalogsStatusSchema = {
  type: 'string',
  description:
    'Status for catalogs entities. Present in catalogs_feed values. When a feed is deleted, the response will inform DELETED as status.',
  enum: ['ACTIVE', 'INACTIVE'],
} as const;

export const CatalogsTypeSchema = {
  description: 'Type of the catalog entity.',
  type: 'string',
  enum: ['RETAIL', 'HOTEL', 'CREATIVE_ASSETS'],
} as const;

export const CatalogsVerticalBatchRequestSchema = {
  type: 'object',
  title: 'operate on item batch',
  description: 'A request object that can have multiple operations on a single batch',
  oneOf: [
    {
      $ref: '#/components/schemas/CatalogsRetailBatchRequest',
    },
    {
      $ref: '#/components/schemas/CatalogsHotelBatchRequest',
    },
    {
      $ref: '#/components/schemas/CatalogsCreativeAssetsBatchRequest',
    },
  ],
  discriminator: {
    propertyName: 'catalog_type',
    mapping: {
      RETAIL: '#/components/schemas/CatalogsRetailBatchRequest',
      HOTEL: '#/components/schemas/CatalogsHotelBatchRequest',
      CREATIVE_ASSETS: '#/components/schemas/CatalogsCreativeAssetsBatchRequest',
    },
  },
} as const;

export const CatalogsHotelGuestRatingsSchema = {
  type: 'object',
  description: 'If specified, you must provide all properties',
  properties: {
    score: {
      description: "Your hotel's rating.",
      type: 'number',
    },
    number_of_reviewers: {
      description: 'Total number of people who have rated this hotel.',
      type: 'integer',
    },
    max_score: {
      description: 'Max value for the hotel rating score.',
      type: 'number',
    },
    rating_system: {
      description: 'System you use for guest reviews.',
      type: 'string',
    },
  },
} as const;

export const CatalogsHotelItemErrorResponseSchema = {
  type: 'object',
  description: 'Object describing a hotel item error',
  properties: {
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
    hotel_id: {
      description: 'The catalog hotel id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    errors: {
      description: 'Array with the errors for the item id requested',
      items: {
        $ref: '#/components/schemas/ItemValidationEvent',
      },
      type: 'array',
    },
  },
  required: ['catalog_type'],
} as const;

export const CatalogsHotelItemResponseSchema = {
  type: 'object',
  description: 'Object describing a hotel record',
  properties: {
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
    hotel_id: {
      description: 'The catalog hotel id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    pins: {
      description: 'The pins mapped to the item',
      type: 'array',
      nullable: true,
      items: {
        $ref: '#/components/schemas/Pin',
      },
      maxItems: 11,
    },
    attributes: {
      $ref: '#/components/schemas/CatalogsHotelAttributes',
    },
  },
  required: ['catalog_type'],
} as const;

export const CatalogsCreativeAssetsItemErrorResponseSchema = {
  type: 'object',
  description: 'Object describing a creative assets item error',
  properties: {
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
    creative_assets_id: {
      description: 'The catalog creative assets id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    errors: {
      description: 'Array with the errors for the item id requested',
      items: {
        $ref: '#/components/schemas/ItemValidationEvent',
      },
      type: 'array',
    },
  },
  required: ['catalog_type'],
} as const;

export const CatalogsCreativeAssetsItemResponseSchema = {
  type: 'object',
  description: 'Object describing a hotel record',
  properties: {
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
    creative_assets_id: {
      description: 'The catalog creative assets id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    pins: {
      description: 'The pins mapped to the item',
      type: 'array',
      nullable: true,
      items: {
        $ref: '#/components/schemas/Pin',
      },
      maxItems: 11,
    },
    attributes: {
      $ref: '#/components/schemas/CatalogsCreativeAssetsAttributes',
    },
  },
  required: ['catalog_type'],
} as const;

export const CreativeAssetsProcessingRecordSchema = {
  type: 'object',
  description: 'Object describing an item processing record',
  properties: {
    creative_assets_id: {
      description: 'The catalog creative assets id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    errors: {
      description: `Array with the validation errors for the item processing record.
A non empty errors list causes the item processing to fail.`,
      items: {
        $ref: '#/components/schemas/ItemValidationEvent',
      },
      type: 'array',
    },
    warnings: {
      description: 'Array with the validation warnings for the item processing record',
      items: {
        $ref: '#/components/schemas/ItemValidationEvent',
      },
      type: 'array',
    },
    status: {
      $ref: '#/components/schemas/ItemProcessingStatus',
    },
  },
} as const;

export const CatalogsRetailBatchRequestSchema = {
  type: 'object',
  description: 'A request object that can have multiple operations on a single retail batch',
  additionalProperties: false,
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['RETAIL'],
    },
    country: {
      $ref: '#/components/schemas/Country',
    },
    language: {
      description: 'We recommend using the CatalogsLocale values.',
      anyOf: [
        {
          $ref: '#/components/schemas/CatalogsLocale',
        },
        {
          $ref: '#/components/schemas/Language',
        },
      ],
    },
    items: {
      minItems: 1,
      maxItems: 1000,
      type: 'array',
      description: 'Array with catalogs item operations',
      items: {
        anyOf: [
          {
            $ref: '#/components/schemas/CatalogsCreateRetailItem',
          },
          {
            $ref: '#/components/schemas/CatalogsUpdateRetailItem',
          },
          {
            $ref: '#/components/schemas/CatalogsUpsertRetailItem',
          },
          {
            $ref: '#/components/schemas/CatalogsDeleteRetailItem',
          },
        ],
        discriminator: {
          propertyName: 'operation',
          mapping: {
            CREATE: '#/components/schemas/CatalogsCreateRetailItem',
            UPDATE: '#/components/schemas/CatalogsUpdateRetailItem',
            UPSERT: '#/components/schemas/CatalogsUpsertRetailItem',
            DELETE: '#/components/schemas/CatalogsDeleteRetailItem',
          },
        },
      },
    },
  },
  required: ['catalog_type', 'country', 'language', 'items'],
} as const;

export const CatalogsRetailItemErrorResponseSchema = {
  type: 'object',
  description: 'Object describing a retail item error',
  properties: {
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
    item_id: {
      description: 'The catalog item id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    errors: {
      description: 'Array with the errors for the item id requested',
      items: {
        $ref: '#/components/schemas/ItemValidationEvent',
      },
      type: 'array',
    },
  },
  required: ['catalog_type'],
} as const;

export const CatalogsRetailItemResponseSchema = {
  type: 'object',
  description: 'Object describing a retail item record',
  properties: {
    catalog_type: {
      $ref: '#/components/schemas/CatalogsType',
    },
    item_id: {
      description: 'The catalog retail item id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    pins: {
      description: 'The pins mapped to the item',
      type: 'array',
      nullable: true,
      items: {
        $ref: '#/components/schemas/Pin',
      },
      maxItems: 11,
    },
    attributes: {
      $ref: '#/components/schemas/ItemAttributes',
    },
  },
  required: ['catalog_type'],
} as const;

export const CatalogsCreateRetailItemSchema = {
  type: 'object',
  description: 'An item to be created',
  properties: {
    item_id: {
      description: 'The catalog item id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    operation: {
      type: 'string',
      enum: ['CREATE'],
    },
    attributes: {
      $ref: '#/components/schemas/ItemAttributesRequest',
    },
  },
  required: ['item_id', 'operation', 'attributes'],
} as const;

export const CatalogsUpdateRetailItemSchema = {
  type: 'object',
  description: 'An item to be updated',
  properties: {
    item_id: {
      description: 'The catalog item id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    operation: {
      type: 'string',
      enum: ['UPDATE'],
    },
    attributes: {
      $ref: '#/components/schemas/UpdatableItemAttributes',
    },
    update_mask: {
      description:
        'The list of product attributes to be updated. Attributes specified in the update mask without a value specified in the body will be deleted from the product item.',
      example: [
        'ad_link',
        'adult',
        'age_group',
        'availability',
        'average_review_rating',
        'brand',
        'checkout_enabled',
        'color',
        'condition',
        'custom_label_0',
        'custom_label_1',
        'custom_label_2',
        'custom_label_3',
        'custom_label_4',
        'description',
        'free_shipping_label',
        'free_shipping_limit',
        'gender',
        'google_product_category',
        'gtin',
        'item_group_id',
        'last_updated_time',
        'link',
        'material',
        'min_ad_price',
        'mpn',
        'number_of_ratings',
        'number_of_reviews',
        'pattern',
        'price',
        'product_type',
        'sale_price',
        'shipping',
        'shipping_height',
        'shipping_weight',
        'shipping_width',
        'size',
        'size_system',
        'size_type',
        'tax',
        'title',
        'variant_names',
        'variant_values',
      ],
      type: 'array',
      nullable: true,
      items: {
        $ref: '#/components/schemas/UpdateMaskFieldType',
      },
    },
  },
  required: ['item_id', 'operation', 'attributes'],
} as const;

export const CatalogsUpsertRetailItemSchema = {
  type: 'object',
  description: 'An item to be upserted',
  properties: {
    item_id: {
      description: 'The catalog item id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    operation: {
      type: 'string',
      enum: ['UPSERT'],
    },
    attributes: {
      $ref: '#/components/schemas/ItemAttributesRequest',
    },
  },
  required: ['item_id', 'operation', 'attributes'],
} as const;

export const CatalogsDeleteRetailItemSchema = {
  type: 'object',
  description: 'An item to be deleted',
  properties: {
    item_id: {
      description: 'The catalog item id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    operation: {
      type: 'string',
      enum: ['DELETE'],
    },
  },
  required: ['item_id', 'operation'],
} as const;

export const CatalogsHotelBatchRequestSchema = {
  description: 'Request object to update catalogs hotel items',
  type: 'object',
  additionalProperties: false,
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['HOTEL'],
    },
    country: {
      $ref: '#/components/schemas/Country',
    },
    language: {
      description: 'We recommend using the CatalogsLocale values.',
      anyOf: [
        {
          $ref: '#/components/schemas/CatalogsLocale',
        },
        {
          $ref: '#/components/schemas/Language',
        },
      ],
    },
    items: {
      minItems: 1,
      maxItems: 1000,
      type: 'array',
      description: 'Array with catalogs item operations',
      items: {
        $ref: '#/components/schemas/CatalogsHotelBatchItem',
      },
    },
    catalog_id: {
      description: 'Catalog id pertaining to the hotel item. If not provided, default to oldest hotel catalog',
      example: '2680059592705',
      type: 'string',
      pattern: '^\\d+$',
    },
  },
  required: ['catalog_type', 'country', 'language', 'items'],
} as const;

export const CatalogsDeleteHotelItemSchema = {
  type: 'object',
  description: 'A hotel item to be deleted',
  properties: {
    hotel_id: {
      description: 'The catalog hotel id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    operation: {
      type: 'string',
      enum: ['DELETE'],
    },
  },
  required: ['hotel_id', 'operation'],
} as const;

export const CatalogsCreateHotelItemSchema = {
  type: 'object',
  description: 'A hotel item to be created.',
  properties: {
    hotel_id: {
      description: 'The catalog hotel id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    operation: {
      type: 'string',
      enum: ['CREATE'],
    },
    attributes: {
      $ref: '#/components/schemas/CatalogsHotelAttributes',
    },
  },
  required: ['hotel_id', 'operation', 'attributes'],
} as const;

export const CatalogsUpdateHotelItemSchema = {
  type: 'object',
  description: 'Object describing an hotel item batch record',
  properties: {
    hotel_id: {
      description: 'The catalog hotel item id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    operation: {
      type: 'string',
      enum: ['UPDATE'],
    },
    attributes: {
      $ref: '#/components/schemas/CatalogsUpdatableHotelAttributes',
    },
  },
  required: ['hotel_id', 'operation', 'attributes'],
} as const;

export const CatalogsUpsertHotelItemSchema = {
  type: 'object',
  description: 'A hotel item to be upserted.',
  properties: {
    hotel_id: {
      description: 'The catalog hotel id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    operation: {
      type: 'string',
      enum: ['UPSERT'],
    },
    attributes: {
      $ref: '#/components/schemas/CatalogsHotelAttributes',
    },
  },
  required: ['hotel_id', 'operation', 'attributes'],
} as const;

export const CatalogsHotelAddressSchema = {
  type: 'object',
  properties: {
    addr1: {
      description: 'Primary street address of hotel.',
      type: 'string',
    },
    city: {
      description: 'City where the hotel is located.',
      type: 'string',
    },
    region: {
      description: 'State, county, province, where the hotel is located.',
      type: 'string',
    },
    country: {
      description: 'Country where the hotel is located.',
      type: 'string',
    },
    postal_code: {
      description: 'Required for countries with a postal code system. Postal or zip code of the hotel.',
      type: 'string',
    },
  },
} as const;

export const CatalogsHotelProductSchema = {
  type: 'object',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['HOTEL'],
    },
    metadata: {
      $ref: '#/components/schemas/CatalogsHotelProductMetadata',
    },
    pin: {
      $ref: '#/components/schemas/Pin',
    },
  },
  required: ['catalog_type', 'metadata', 'pin'],
} as const;

export const CatalogsHotelProductMetadataSchema = {
  type: 'object',
  description: 'Hotel product metadata entity',
  properties: {
    hotel_id: {
      description: 'The user-created unique ID that represents the hotel item.',
      example: '123abc',
      type: 'string',
    },
  },
  required: ['hotel_id'],
} as const;

export const CatalogsUpdatableHotelAttributesSchema = {
  type: 'object',
  properties: {
    name: {
      description: "The hotel's name.",
      type: 'string',
      nullable: true,
    },
    link: {
      description: 'Link to the product page',
      type: 'string',
      nullable: true,
    },
    description: {
      description: 'Brief description of the hotel.',
      type: 'string',
      nullable: true,
    },
    brand: {
      description: 'The brand to which this hotel belongs to.',
      type: 'string',
      nullable: true,
    },
    latitude: {
      description: 'Latitude of the hotel.',
      type: 'number',
    },
    longitude: {
      description: 'Longitude of the hotel.',
      type: 'number',
      nullable: true,
    },
    neighborhood: {
      description: 'A list of neighborhoods where the hotel is located',
      type: 'array',
      nullable: true,
      items: {
        type: 'string',
      },
    },
    address: {
      description: 'Hotel address',
      $ref: '#/components/schemas/CatalogsHotelAddress',
    },
    custom_label_0: {
      description: 'Custom grouping of hotels',
      type: 'string',
      nullable: true,
    },
    custom_label_1: {
      description: 'Custom grouping of hotels',
      type: 'string',
      nullable: true,
    },
    custom_label_2: {
      description: 'Custom grouping of hotels',
      type: 'string',
      nullable: true,
    },
    custom_label_3: {
      description: 'Custom grouping of hotels',
      type: 'string',
      nullable: true,
    },
    custom_label_4: {
      description: 'Custom grouping of hotels',
      type: 'string',
      nullable: true,
    },
    category: {
      description: 'The type of property. The category can be any type of internal description desired.',
      type: 'string',
      nullable: true,
    },
    base_price: {
      description: 'Base price of the hotel room per night followed by the ISO currency code',
      type: 'string',
      nullable: true,
      example: '100 USD',
    },
    sale_price: {
      description:
        'Sale price of a hotel room per night. Used to advertise discounts off the regular price of the hotel.',
      type: 'string',
      nullable: true,
      example: '90 USD',
    },
    guest_ratings: {
      description: 'If specified, you must provide all properties',
      $ref: '#/components/schemas/CatalogsHotelGuestRatings',
    },
  },
} as const;

export const CatalogsCreativeAssetsProductMetadataSchema = {
  type: 'object',
  description: 'Creative assets product metadata entity',
  properties: {
    creative_assets_id: {
      description: 'The user-created unique ID that represents the creative assets item.',
      example: '123abc',
      type: 'string',
    },
    visibility: {
      $ref: '#/components/schemas/CreativeAssetsVisibilityType',
    },
  },
  required: ['creative_assets_id', 'visibility'],
} as const;

export const CatalogsCreativeAssetsProductSchema = {
  type: 'object',
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['CREATIVE_ASSETS'],
    },
    metadata: {
      $ref: '#/components/schemas/CatalogsCreativeAssetsProductMetadata',
    },
    pin: {
      $ref: '#/components/schemas/Pin',
    },
  },
  required: ['catalog_type', 'metadata', 'pin'],
} as const;

export const CreativeAssetsVisibilityTypeSchema = {
  description: 'Creative assets visibility.',
  nullable: false,
  type: 'string',
  enum: ['VISIBLE', 'HIDDEN'],
} as const;

export const CatalogsCreativeAssetsBatchRequestSchema = {
  description: 'Request object to update catalogs creative assets items',
  type: 'object',
  additionalProperties: false,
  properties: {
    catalog_type: {
      type: 'string',
      enum: ['CREATIVE_ASSETS'],
    },
    country: {
      $ref: '#/components/schemas/Country',
    },
    language: {
      description: 'We recommend using the CatalogsLocale values.',
      anyOf: [
        {
          $ref: '#/components/schemas/CatalogsLocale',
        },
        {
          $ref: '#/components/schemas/Language',
        },
      ],
    },
    items: {
      minItems: 1,
      maxItems: 1000,
      type: 'array',
      description: 'Array with creative assets item operations',
      items: {
        $ref: '#/components/schemas/CatalogsCreativeAssetsBatchItem',
      },
    },
    catalog_id: {
      description:
        'Catalog id pertaining to the creative assets item. If not provided, default to oldest creative assets catalog',
      example: '2680059592705',
      type: 'string',
      pattern: '^\\d+$',
    },
  },
  required: ['catalog_type', 'country', 'language', 'items'],
} as const;

export const CatalogsCreativeAssetsBatchItemSchema = {
  description: 'Creative assets batch item',
  type: 'object',
  anyOf: [
    {
      $ref: '#/components/schemas/CatalogsCreateCreativeAssetsItem',
    },
    {
      $ref: '#/components/schemas/CatalogsUpsertCreativeAssetsItem',
    },
    {
      $ref: '#/components/schemas/CatalogsUpdateCreativeAssetsItem',
    },
    {
      $ref: '#/components/schemas/CatalogsDeleteCreativeAssetsItem',
    },
  ],
  discriminator: {
    propertyName: 'operation',
    mapping: {
      CREATE: '#/components/schemas/CatalogsCreateCreativeAssetsItem',
      UPSERT: '#/components/schemas/CatalogsUpsertCreativeAssetsItem',
      UPDATE: '#/components/schemas/CatalogsUpdateCreativeAssetsItem',
      DELETE: '#/components/schemas/CatalogsDeleteCreativeAssetsItem',
    },
  },
} as const;

export const CatalogsCreateCreativeAssetsItemSchema = {
  type: 'object',
  description: 'A creative assets item to be created.',
  properties: {
    creative_assets_id: {
      description: 'The catalog creative assets id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    operation: {
      type: 'string',
      enum: ['CREATE'],
    },
    attributes: {
      $ref: '#/components/schemas/CatalogsCreativeAssetsAttributes',
    },
  },
  required: ['creative_assets_id', 'operation', 'attributes'],
} as const;

export const CatalogsUpdateCreativeAssetsItemSchema = {
  type: 'object',
  description: 'A creative assets item to be updated.',
  properties: {
    creative_assets_id: {
      description: 'The catalog creative assets item id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    operation: {
      type: 'string',
      enum: ['UPDATE'],
    },
    attributes: {
      $ref: '#/components/schemas/CatalogsUpdatableCreativeAssetsAttributes',
    },
  },
  required: ['creative_assets_id', 'operation', 'attributes'],
} as const;

export const CatalogsUpsertCreativeAssetsItemSchema = {
  type: 'object',
  description: 'A creative assets item to be upserted.',
  properties: {
    creative_assets_id: {
      description: 'The catalog creative assets id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    operation: {
      type: 'string',
      enum: ['UPSERT'],
    },
    attributes: {
      $ref: '#/components/schemas/CatalogsCreativeAssetsAttributes',
    },
  },
  required: ['creative_assets_id', 'operation', 'attributes'],
} as const;

export const CatalogsDeleteCreativeAssetsItemSchema = {
  type: 'object',
  description: 'A creative assets item to be deleted',
  properties: {
    creative_assets_id: {
      description: 'The catalog creative assets id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    operation: {
      type: 'string',
      enum: ['DELETE'],
    },
  },
  required: ['creative_assets_id', 'operation'],
} as const;

export const CatalogsUpdatableCreativeAssetsAttributesSchema = {
  type: 'object',
  properties: {
    title: {
      description: 'The name of the creative assets.',
      type: 'string',
    },
    description: {
      description: 'Brief description of the creative assets.',
      type: 'string',
    },
    link: {
      description: 'Link to the creative assets page.',
      type: 'string',
    },
    ios_deep_link: {
      description: 'IOS deep link to the creative assets page.',
      type: 'string',
      nullable: true,
    },
    android_deep_link: {
      description: 'Link to the creative assets page.',
      type: 'string',
      nullable: true,
    },
    google_product_category: {
      description:
        'The categorization of the product based on the standardized Google Product Taxonomy. This is a set taxonomy. Both the text values and numeric codes are accepted.',
      type: 'string',
      nullable: true,
    },
    custom_label_0: {
      description: 'Custom grouping of creative assets.',
      type: 'string',
      nullable: true,
    },
    custom_label_1: {
      description: 'Custom grouping of creative assets.',
      type: 'string',
      nullable: true,
    },
    custom_label_2: {
      description: 'Custom grouping of creative assets.',
      type: 'string',
      nullable: true,
    },
    custom_label_3: {
      description: 'Custom grouping of creative assets.',
      type: 'string',
      nullable: true,
    },
    custom_label_4: {
      description: 'Custom grouping of creative assets.',
      type: 'string',
      nullable: true,
    },
    visibility: {
      description:
        'Visibility of the creative assets. Must be one of the following values (upper or lowercase): ‘visible’, ‘hidden’.',
      type: 'string',
      nullable: true,
    },
  },
} as const;

export const CatalogsCreativeAssetsAttributesSchema = {
  type: 'object',
  allOf: [
    {
      type: 'object',
      properties: {
        image_link: {
          type: 'string',
          description: 'The creative assets image.',
          example: 'https://scene.example.com/image/image_v2.jpg',
        },
        video_link: {
          type: 'string',
          description: 'The creative assets video.',
          example: 'https://scene.example.com/image/image_v2.mp4',
        },
      },
    },
    {
      $ref: '#/components/schemas/CatalogsUpdatableCreativeAssetsAttributes',
    },
  ],
} as const;

export const CatalogsVerticalProductGroupCreateRequestSchema = {
  type: 'object',
  title: 'catalog based',
  description: 'Request object for creating a catalog based product group.',
  oneOf: [
    {
      $ref: '#/components/schemas/CatalogsRetailProductGroupCreateRequest',
    },
    {
      $ref: '#/components/schemas/CatalogsHotelProductGroupCreateRequest',
    },
    {
      $ref: '#/components/schemas/CatalogsCreativeAssetsProductGroupCreateRequest',
    },
  ],
  discriminator: {
    propertyName: 'catalog_type',
    mapping: {
      RETAIL: '#/components/schemas/CatalogsRetailProductGroupCreateRequest',
      HOTEL: '#/components/schemas/CatalogsHotelProductGroupCreateRequest',
      CREATIVE_ASSETS: '#/components/schemas/CatalogsCreativeAssetsProductGroupCreateRequest',
    },
  },
} as const;

export const CatalogsVerticalProductGroupUpdateRequestSchema = {
  type: 'object',
  title: 'catalog based',
  description: 'Request object for updating a catalog based product group.',
  oneOf: [
    {
      $ref: '#/components/schemas/CatalogsRetailProductGroupUpdateRequest',
    },
    {
      $ref: '#/components/schemas/CatalogsHotelProductGroupUpdateRequest',
    },
    {
      $ref: '#/components/schemas/CatalogsCreativeAssetsProductGroupUpdateRequest',
    },
  ],
  discriminator: {
    propertyName: 'catalog_type',
    mapping: {
      RETAIL: '#/components/schemas/CatalogsRetailProductGroupUpdateRequest',
      HOTEL: '#/components/schemas/CatalogsHotelProductGroupUpdateRequest',
      CREATIVE_ASSETS: '#/components/schemas/CatalogsCreativeAssetsProductGroupUpdateRequest',
    },
  },
} as const;

export const ConditionFilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    CONDITION: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringCriteria',
    },
  },
  required: ['CONDITION'],
} as const;

export const ConversionApiResponseSchema = {
  description:
    'Schema describing the object in the response, which contains information about the events that were received and processed.',
  type: 'object',
  properties: {
    num_events_received: {
      description: 'Total number of events received in the request.',
      type: 'integer',
    },
    num_events_processed: {
      description: 'Number of events that were successfully processed from the events.',
      type: 'integer',
    },
    events: {
      description:
        'Specific messages for each event received. The order will match the order in which the events were received in the request.',
      type: 'array',
      items: {
        type: 'object',
        properties: {
          status: {
            description: 'Whether the event was processed successfully.',
            type: 'string',
            example: 'processed',
            enum: ['failed', 'processed'],
          },
          error_message: {
            description: 'Error message containing more information about why the event failed to be processed.',
            type: 'string',
            nullable: true,
          },
          warning_message: {
            description:
              'Warning messages about any fields in the event which are not standard. These are not critical to event processing.',
            type: 'string',
            nullable: true,
          },
        },
        required: ['status'],
      },
    },
  },
  required: ['num_events_received', 'num_events_processed', 'events'],
} as const;

export const ConversionAttributionWindowDaysSchema = {
  type: 'integer',
  enum: [0, 1, 7, 14, 30, 60],
} as const;

export const ConversionEventResponseSchema = {
  title: 'ConversionEventResponse',
  type: 'object',
  properties: {
    conversion_event: {
      type: 'string',
      $ref: '#/components/schemas/ConversionTagType',
    },
    conversion_tag_id: {
      title: 'conversion_tag_id',
      description: 'Id of the tag.',
      type: 'string',
      pattern: '^\\d+$',
      example: '2614324385652',
    },
    ad_account_id: {
      title: 'ad_account_id',
      description: 'Id of the ad account.',
      type: 'string',
      pattern: '^\\d+$',
      example: '549757463328',
    },
    created_time: {
      title: 'created_time',
      description: 'Creation date in epoch format.',
      type: 'integer',
      example: 1564768710,
    },
  },
} as const;

export const ConversionEventsSchema = {
  description: 'A list of events (one or more) encapsulated by a data object.',
  type: 'object',
  additionalProperties: false,
  properties: {
    data: {
      type: 'array',
      minItems: 1,
      maxItems: 1000,
      items: {
        type: 'object',
        additionalProperties: false,
        properties: {
          event_name: {
            description: `<p>The type of the user event. Please use the right event_name otherwise the event won't be accepted and show up correctly in reports.
  <ul>
  <li><code>add_to_cart</code></li>
  <li><code>checkout</code></li>
  <li><code>custom</code></li>
  <li><code>lead</code></li>
  <li><code>page_visit</code></li>
  <li><code>search</code></li>
  <li><code>signup</code></li>
  <li><code>view_category</code></li>
  <li><code>watch_video</code></li>
  </ul>
</p>
`,
            type: 'string',
            example: 'checkout',
          },
          action_source: {
            description: `<p>
  The source indicating where the conversion event occurred.
  <ul>
    <li><code>app_android</code></li>
    <li><code>app_ios</code></li>
    <li><code>web</code></li>
    <li><code>offline</code></li>
  </ul>
</p>
`,
            type: 'string',
            example: 'app_ios',
          },
          event_time: {
            description: 'The time when the event happened. Unix timestamp in seconds.',
            example: 1451431341,
            type: 'integer',
            format: 'int64',
          },
          event_id: {
            description:
              "A unique id string that identifies this event and can be used for deduping between events ingested via both the conversion API and Pinterest tracking. Without this, event's data is likely to be double counted and will cause report metric inflation. Third-party vendors make sure this field is updated on both Pinterest tag and Conversions API side before rolling out template for Conversions API.",
            type: 'string',
            example: 'eventId0001',
          },
          event_source_url: {
            description: 'URL of the web conversion event.',
            type: 'string',
            example: 'https://www.my-clothing-shop.org/',
            nullable: true,
          },
          opt_out: {
            description:
              'When action_source is web or offline, it defines whether the user has opted out of tracking for web conversion events. While when action_source is app_android or app_ios, it defines whether the user has enabled Limit Ad Tracking on their iOS device, or opted out of Ads Personalization on their Android device.',
            type: 'boolean',
            example: false,
          },
          partner_name: {
            description:
              'The third party partner name responsible to send the event to Conversions API on behalf of the advertiser. The naming convention is "ss-partnername" lowercase. E.g ‘ss-shopify’',
            type: 'string',
            example: 'ss-partnername',
            nullable: true,
          },
          user_data: {
            $ref: '#/components/schemas/ConversionEventsUserData',
          },
          custom_data: {
            description: 'Object containing other custom data.',
            type: 'object',
            additionalProperties: false,
            properties: {
              currency: {
                description:
                  "The ISO-4217 currency code. If not provided, we will default to the advertiser's currency set during account creation. Your campaign performance needs this field to report right ROAS/CPA.",
                example: 'USD',
                type: 'string',
                nullable: true,
              },
              value: {
                description:
                  'Total value of the event. Accepted as a string in the request; it will be parsed into a double. For example, if there are two items in a checkout event, the value should be the total price. We recommend to use pre-tax, pre-shipping final value.',
                example: '72.39',
                type: 'string',
                nullable: true,
              },
              content_ids: {
                description:
                  'List of products IDs. We recommend using this if you are a merchant for PageVisit, AddToCart and Checkouts. For detail, please check <a href="https://help.pinterest.com/en/business/article/before-you-get-started-with-catalogs" target="_blank">here</a> (Install the Pinterest tag section).',
                type: 'array',
                items: {
                  type: 'string',
                },
                example: ['red-pinterest-shirt-logo-1', 'purple-pinterest-shirt-logo-3'],
              },
              content_name: {
                description: 'The name of the page or product associated with the event.',
                type: 'string',
                nullable: true,
                example: 'pinterest-themed-clothing',
              },
              content_category: {
                description: 'The category of the content associated with the event.',
                type: 'string',
                nullable: true,
                example: 'shirts',
              },
              content_brand: {
                description: 'The brand of the content associated with the event.',
                type: 'string',
                nullable: true,
                example: 'pinterest-brand',
              },
              contents: {
                description:
                  'A list of objects containing information about products, such as price and quantity. We recommend using this if you are a merchant for PageVisit, AddToCart and Checkouts. For detail, please check <a href="https://help.pinterest.com/en/business/article/before-you-get-started-with-catalogs" target="_blank">here</a> (Install the Pinterest tag section).',
                type: 'array',
                items: {
                  type: 'object',
                  additionalProperties: false,
                  properties: {
                    id: {
                      description:
                        'The id of a product. We recommend using this if you are a merchant for AddToCart and Checkouts. For detail, please check <a href="https://help.pinterest.com/en/business/article/before-you-get-started-with-catalogs" target="_blank">here</a> (Install the Pinterest tag section).',
                      example: 'red-pinterest-shirt-logo-1',
                      type: 'string',
                    },
                    item_price: {
                      description:
                        'The price of a product. Accepted as a string in the request; it will be parsed into a double. This is the original item value before any discount. We recommend using this if you are a merchant for PageVisit, AddToCart and Checkouts. For detail, please check <a href="https://help.pinterest.com/en/business/article/before-you-get-started-with-catalogs" target="_blank">here</a> (Install the Pinterest tag section).',
                      example: '1325.12',
                      type: 'string',
                    },
                    quantity: {
                      description:
                        'The amount of a product. We recommend using this if you are a merchant for AddToCart and Checkouts. For detail, please check <a href="https://help.pinterest.com/en/business/article/before-you-get-started-with-catalogs" target="_blank">here</a> (Install the Pinterest tag section).',
                      type: 'integer',
                      format: 'int64',
                      example: 5,
                    },
                    item_name: {
                      description: 'The name of a product.',
                      example: 'pinterest-clothing-shirt',
                      type: 'string',
                    },
                    item_category: {
                      description: 'The category of a product.',
                      example: 'pinterest-entertainment',
                      type: 'string',
                    },
                    item_brand: {
                      description: 'The brand of a product.',
                      example: 'pinterest',
                      type: 'string',
                    },
                  },
                },
              },
              num_items: {
                description:
                  'Total number of products of the event. For example, the total number of items purchased in a checkout event. We recommend using this if you are a merchant for AddToCart and Checkouts. For detail, please check <a href="https://help.pinterest.com/en/business/article/before-you-get-started-with-catalogs" target="_blank">here</a> (Install the Pinterest tag section).',
                type: 'integer',
                format: 'int64',
                example: 2,
              },
              order_id: {
                description:
                  'The order ID. We recommend sending order_id to help us deduplicate events when necessary. This also helps to run other measurement products at Pinterest.',
                type: 'string',
                nullable: true,
                example: 'my_order_id',
              },
              search_string: {
                description: 'The search string related to the user conversion event.',
                type: 'string',
                nullable: true,
                example: 'sample string',
              },
              opt_out_type: {
                description:
                  'Flags for different privacy rights laws to opt out users of sharing personal information. Values should be comma separated. Please follow the <a href="https://help.pinterest.com/en/business/article/limited-data-processing" target="_blank">Help Center</a> and <a href="/docs/api-features/conversion-overview/" target="_blank">dev site</a> for specific opt_out_type set up.',
                example: 'LDP',
                type: 'string',
                nullable: true,
              },
              np: {
                description:
                  'Named partner. Not required, this is for Pinterest internal use only. Please do not use this unless specifically guided.',
                type: 'string',
                nullable: true,
                example: 'ss-company',
              },
            },
          },
          app_id: {
            description: 'The app store app ID.',
            type: 'string',
            nullable: true,
            example: '429047995',
          },
          app_name: {
            description: 'Name of the app.',
            type: 'string',
            nullable: true,
            example: 'Pinterest',
          },
          app_version: {
            description: 'Version of the app.',
            type: 'string',
            nullable: true,
            example: '7.9',
          },
          device_brand: {
            description: 'Brand of the user device.',
            type: 'string',
            nullable: true,
            example: 'Apple',
          },
          device_carrier: {
            description: "User device's mobile carrier.",
            type: 'string',
            nullable: true,
            example: 'T-Mobile',
          },
          device_model: {
            description: 'Model of the user device.',
            type: 'string',
            nullable: true,
            example: 'iPhone X',
          },
          device_type: {
            description: 'Type of the user device.',
            type: 'string',
            nullable: true,
            example: 'iPhone',
          },
          os_version: {
            description: 'Version of the device operating system.',
            type: 'string',
            nullable: true,
            example: '12.1.4',
          },
          wifi: {
            description: 'Whether the event occurred when the user device was connected to wifi.',
            example: false,
            type: 'boolean',
          },
          language: {
            description: "Two-character ISO-639-1 language code indicating the user's language.",
            example: 'en',
            type: 'string',
            nullable: true,
          },
        },
        required: ['event_name', 'action_source', 'event_time', 'user_data', 'event_id'],
      },
    },
  },
  required: ['data'],
} as const;

export const ConversionEventsUserDataSchema = {
  description:
    'Object containing customer information data. Note, It is required at least one of 1) em, 2) hashed_maids or 3) pair client_ip_address + client_user_agent.',
  type: 'object',
  anyOf: [
    {
      properties: {
        em: {
          description:
            "Sha256 hashes of lowercase version of user's email addresses. Used for matching. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.",
          type: 'array',
          items: {
            type: 'string',
          },
          example: [
            '411e44ce1261728ffd2c0686e44e3fffe413c0e2c5adc498bc7da883d476b9c8',
            '09831ea51bd1b7b32a836683a00a9ccaf3d05f59499f42d9883412ed79289969',
          ],
        },
        hashed_maids: {
          description: `Sha256 hashes of user's "Google Advertising IDs" (GAIDs) or "Apple's Identifier for Advertisers" (IDFAs). Used for matching. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.`,
          type: 'array',
          items: {
            type: 'string',
          },
          example: [
            '0192518eb84137ccfe82c8b6322d29631dae7e28ed9d0f6dd5f245d73a58c5f1',
            '837b850ac46d62b2272a71de73c27801ff011ac1e36c5432620c8755cf90db46',
          ],
        },
        client_ip_address: {
          description:
            "The user's IP address, which can be either in IPv4 or IPv6 format. Used for matching. We highly recommend this for all events. It may improve reporting performance such as ROAS/CPA.",
          type: 'string',
          example: '216.3.128.12',
        },
        client_user_agent: {
          description:
            "The user agent string of the user's web browser. We highly recommend this for all events. It may improve reporting performance such as ROAS/CPA.",
          type: 'string',
          example:
            'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36',
        },
      },
      required: ['em'],
    },
    {
      properties: {
        em: {
          description:
            "Sha256 hashes of lowercase version of user's email addresses. Used for matching. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.",
          type: 'array',
          items: {
            type: 'string',
          },
          example: [
            '411e44ce1261728ffd2c0686e44e3fffe413c0e2c5adc498bc7da883d476b9c8',
            '09831ea51bd1b7b32a836683a00a9ccaf3d05f59499f42d9883412ed79289969',
          ],
        },
        hashed_maids: {
          description: `Sha256 hashes of user's "Google Advertising IDs" (GAIDs) or "Apple's Identifier for Advertisers" (IDFAs). Used for matching. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.`,
          type: 'array',
          items: {
            type: 'string',
          },
          example: [
            '0192518eb84137ccfe82c8b6322d29631dae7e28ed9d0f6dd5f245d73a58c5f1',
            '837b850ac46d62b2272a71de73c27801ff011ac1e36c5432620c8755cf90db46',
          ],
        },
        client_ip_address: {
          description:
            "The user's IP address, which can be either in IPv4 or IPv6 format. Used for matching. We highly recommend this for all events. It may improve reporting performance such as ROAS/CPA.",
          type: 'string',
          example: '216.3.128.12',
        },
        client_user_agent: {
          description:
            "The user agent string of the user's web browser. We highly recommend this for all events. It may improve reporting performance such as ROAS/CPA.",
          type: 'string',
          example:
            'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36',
        },
      },
      required: ['hashed_maids'],
    },
    {
      properties: {
        em: {
          description:
            "Sha256 hashes of lowercase version of user's email addresses. Used for matching. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.",
          type: 'array',
          items: {
            type: 'string',
          },
          example: [
            '411e44ce1261728ffd2c0686e44e3fffe413c0e2c5adc498bc7da883d476b9c8',
            '09831ea51bd1b7b32a836683a00a9ccaf3d05f59499f42d9883412ed79289969',
          ],
        },
        hashed_maids: {
          description: `Sha256 hashes of user's "Google Advertising IDs" (GAIDs) or "Apple's Identifier for Advertisers" (IDFAs). Used for matching. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.`,
          type: 'array',
          items: {
            type: 'string',
          },
          example: [
            '0192518eb84137ccfe82c8b6322d29631dae7e28ed9d0f6dd5f245d73a58c5f1',
            '837b850ac46d62b2272a71de73c27801ff011ac1e36c5432620c8755cf90db46',
          ],
        },
        client_ip_address: {
          description:
            "The user's IP address, which can be either in IPv4 or IPv6 format. Used for matching. We highly recommend this for all events. It may improve reporting performance such as ROAS/CPA.",
          type: 'string',
          example: '216.3.128.12',
        },
        client_user_agent: {
          description:
            "The user agent string of the user's web browser. We highly recommend this for all events. It may improve reporting performance such as ROAS/CPA.",
          type: 'string',
          example:
            'Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.87 Safari/537.36',
        },
      },
      required: ['client_ip_address', 'client_user_agent'],
    },
  ],
  properties: {
    ph: {
      description:
        "Sha256 hashes of user's phone numbers, only digits with country code, area code, and number. Remove any symbols, letters, spaces and leading zeros. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.",
      type: 'array',
      items: {
        type: 'string',
      },
      example: ['45df139772a81b6011bdc1c9cc3d1cb408fc0b10ec0c5cb9d4d4e107f0ddc49d'],
    },
    ge: {
      description: `Sha256 hashes of user's gender, in lowercase. Either "f" or "m" or "n" for non-binary gender. The string should be in the UTF-8 format.`,
      type: 'array',
      items: {
        type: 'string',
      },
      example: ['0d248e82c62c9386878327d491c762a002152d42ab2c391a31c44d9f62675ddf'],
    },
    db: {
      description:
        "Sha256 hashes of user's date of birthday, given as year, month, and day. The string should be in the UTF-8 format.",
      type: 'array',
      items: {
        type: 'string',
      },
      example: ['d4426a0086d10f12ad265539ae8d54221dc67786053d511407204b76e99d7739'],
    },
    ln: {
      description:
        "Sha256 hashes of user's last name, in lowercase. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.",
      type: 'array',
      items: {
        type: 'string',
      },
      example: ['7e546b3aa43f989dd359672e6c3409d4f9d4e8f155ae1e9b90ee060985468c19'],
    },
    fn: {
      description:
        "Sha256 hashes of user's first name, in lowercase. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.",
      type: 'array',
      items: {
        type: 'string',
      },
      example: ['ec1e6a072231703f1bc41429052fff8c00a7e0c6aaec2e7107241ca8f3ceb6b2'],
    },
    ct: {
      description:
        "Sha256 hashes of user's city, in lowercase, and without spaces or punctuation. User residency city (mostly billing). The string should be in the UTF-8 format.",
      type: 'array',
      items: {
        type: 'string',
      },
      example: ['4ac01a129bfd10385c9278c2cf2c46fac5ab57350841234f587c8522a2e4ce36'],
    },
    st: {
      description:
        "Sha256 hashes of user's state, given as a two-letter code in lowercase. User residency state (mostly billing). The string should be in the UTF-8 format.",
      type: 'array',
      items: {
        type: 'string',
      },
      example: ['49a6d05b8e4b516656e464271d9dd38d0a7e0142f7f49546f4dabd2720cafc34'],
    },
    zp: {
      description:
        "Sha256 hashes of user's zipcode, only digits. User residency zipcode (mostly billing). The string should be in the UTF-8 format.",
      type: 'array',
      items: {
        type: 'string',
      },
      example: ['fd5f56b40a79a385708428e7b32ab996a681080a166a2206e750eb4819186145'],
    },
    country: {
      description:
        "Sha256 hashes of two-character ISO-3166 country code indicating the user's country, in lowercase. The string should be in the UTF-8 format.",
      type: 'array',
      items: {
        type: 'string',
      },
      example: ['9b202ecbc6d45c6d8901d989a918878397a3eb9d00e8f48022fc051b19d21a1d'],
    },
    external_id: {
      description:
        'Sha256 hashes of the unique id from the advertiser that identifies a user in their space, e.g. user id, loyalty id, etc. We highly recommend this on all events. It may improve reporting performance such as ROAS/CPA. The string should be in the UTF-8 format.',
      type: 'array',
      items: {
        type: 'string',
      },
      example: ['6a7a73766627eb611720883d5a11cc62b5bfee237b00a6658d78c50032ec4aee'],
    },
    click_id: {
      description:
        'The unique identifier stored in _epik cookie on your domain or &epik= query parameter in the URL. We highly recommend this on checkout events at least. It may improve reporting performance such as ROAS/CPA.',
      type: 'string',
      example:
        'dj0yJnU9b2JDcFFHekV4SHJNcmVrbFBkUEdqakh0akdUT1VjVVUmcD0yJm49cnNBQ3F2Q2dOVDBXWWhkWklrUGxBUSZ0PUFBQUFBR1BaY3Bv',
      nullable: true,
    },
    partner_id: {
      description: "A unique identifier of visitors' information defined by third party partners. e.g RampID",
      type: 'string',
      example:
        'BUJrTlRRzGJmWhRXFZdkioV6wKPBve7Lom__GU9J74hq2NIQj4O3nOZJrp3mcUr5MptkXsI14juMOIM9mNZnM4zEUFT2JLVaFhcOfuuWz3IWEDtBf6I0DPc',
      nullable: true,
    },
  },
} as const;

export const ConversionReportAttributionTypeSchema = {
  type: 'string',
  description: 'Attribution type. Refers to the Pinterest Tag endpoints',
  example: 'INDIVIDUAL',
  enum: ['INDIVIDUAL', 'HOUSEHOLD'],
} as const;

export const ConversionReportTimeTypeSchema = {
  type: 'string',
  description: 'Conversion report time type',
  example: 'TIME_OF_AD_ACTION',
  enum: ['TIME_OF_AD_ACTION', 'TIME_OF_CONVERSION'],
} as const;

export const ConversionTagCommonSchema = {
  type: 'object',
  properties: {
    ad_account_id: {
      description: 'Ad account ID.',
      example: '549755885175',
      title: 'ad_account_id',
      type: 'string',
    },
    code_snippet: {
      description: 'Tag code snippet.',
      example: '<script type=text/javascript> [...]',
      title: 'code_snippet',
      type: 'string',
    },
    enhanced_match_status: {
      $ref: '#/components/schemas/EnhancedMatchStatusType',
    },
    id: {
      description: 'Tag ID.',
      example: '2617998078212',
      title: 'id',
      type: 'string',
    },
    last_fired_time_ms: {
      description: 'Time for the last event fired.',
      example: 1599030000000,
      nullable: true,
      title: 'last_fired_time_ms',
      type: 'number',
    },
    name: {
      description: 'Conversion tag name.',
      example: 'ACME Checkout Test Tag',
      title: 'name',
      type: 'string',
    },
    status: {
      $ref: '#/components/schemas/EntityStatus',
    },
    version: {
      description: 'Version number.',
      example: '3',
      title: 'version',
      type: 'string',
    },
    configs: {
      $ref: '#/components/schemas/ConversionTagConfigs',
    },
  },
  title: 'ConversionTagCommon',
} as const;

export const ConversionTagConfigsSchema = {
  type: 'object',
  properties: {
    aem_enabled: {
      description:
        'Whether Automatic Enhanced Match email is enabled. See <a href="https://help.pinterest.com/en/business/article/enhanced-match" target="_blank">Enhanced match</a> for more information.',
      example: true,
      title: 'aem_enabled',
      type: 'boolean',
      default: false,
      nullable: true,
    },
    md_frequency: {
      description: 'Metadata ingestion frequency.',
      example: 0.6,
      title: 'md_frequency',
      type: 'number',
      default: 1,
      nullable: true,
    },
    aem_fnln_enabled: {
      description:
        'Whether Automatic Enhanced Match name is enabled. See <a href="https://help.pinterest.com/en/business/article/enhanced-match" target="_blank">Enhanced match</a> for more information.',
      example: true,
      title: 'aem_fnln_enabled',
      type: 'boolean',
      default: false,
      nullable: true,
    },
    aem_ph_enabled: {
      description:
        'Whether Automatic Enhanced Match phone is enabled. See <a href="https://help.pinterest.com/en/business/article/enhanced-match" target="_blank">Enhanced match</a> for more information.',
      example: true,
      title: 'aem_ph_enabled',
      type: 'boolean',
      default: false,
      nullable: true,
    },
    aem_ge_enabled: {
      description:
        'Whether Automatic Enhanced Match gender is enabled. See <a href="https://help.pinterest.com/en/business/article/enhanced-match" target="_blank">Enhanced match</a> for more information.',
      example: true,
      title: 'aem_ge_enabled',
      type: 'boolean',
      default: false,
      nullable: true,
    },
    aem_db_enabled: {
      description:
        'Whether Automatic Enhanced Match birthdate is enabled. See <a href="https://help.pinterest.com/en/business/article/enhanced-match" target="_blank">Enhanced match</a> for more information.',
      example: true,
      title: 'aem_db_enabled',
      type: 'boolean',
      default: false,
      nullable: true,
    },
    aem_loc_enabled: {
      description:
        'Whether Automatic Enhanced Match location is enabled. See <a href="https://help.pinterest.com/en/business/article/enhanced-match" target="_blank">Enhanced match</a> for more information.',
      example: true,
      title: 'aem_loc_enabled',
      type: 'boolean',
      default: false,
      nullable: true,
    },
  },
  title: 'ConversionTagConfigs',
} as const;

export const ConversionTagCreateSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/ConversionTagConfigs',
    },
  ],
  example: {
    name: 'ACME Tools Tag',
  },
  properties: {
    name: {
      description: 'Conversion tag name.',
      example: 'ACME Tools Tag',
      title: 'name',
      type: 'string',
    },
  },
  required: ['name'],
  title: 'ConversionTagCreate',
} as const;

export const ConversionTagListResponseSchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ConversionTagResponse',
      },
    },
  },
} as const;

export const ConversionTagResponseSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/ConversionTagCommon',
    },
  ],
  title: 'ConversionTagResponse',
} as const;

export const ConversionTagTypeSchema = {
  title: 'ConversionTagType',
  description: 'conversion tag type',
  type: 'string',
  enum: [
    'PAGE_LOAD',
    'UNKNOWN',
    'INITIALIZED',
    'PAGE_VISIT',
    'SIGNUP',
    'CHECKOUT',
    'CUSTOM',
    'VIEW_CATEGORY',
    'SEARCH',
    'ADD_TO_CART',
    'WATCH_VIDEO',
    'LEAD',
    'APP_INSTALL',
    'WEB_SESSION',
    'EXTERNAL_MEASUREMENT',
  ],
  example: 'PAGE_LOAD',
} as const;

export const ConversionTagsOcpmEligibleResponseSchema = {
  type: 'object',
  additionalProperties: {
    type: 'array',
    items: {
      $ref: '#/components/schemas/ConversionEventResponse',
    },
  },
  example: {
    12345: [
      {
        conversion_event: 'PAGE_LOAD',
        created_time: 1564768710,
        conversion_tag_id: '2614324385652',
        ad_account_id: '549757463328',
      },
      {
        conversion_event: 'CHECKOUT',
        created_time: 1564710210,
        conversion_tag_id: '2614324315793',
        ad_account_id: '549757463328',
      },
    ],
  },
} as const;

export const CountrySchema = {
  type: 'string',
  description: 'Country ID from ISO 3166-1 alpha-2.',
  example: 'US',
  enum: [
    'AD',
    'AE',
    'AF',
    'AG',
    'AI',
    'AL',
    'AM',
    'AO',
    'AQ',
    'AR',
    'AS',
    'AT',
    'AU',
    'AW',
    'AX',
    'AZ',
    'BA',
    'BB',
    'BD',
    'BE',
    'BF',
    'BG',
    'BH',
    'BI',
    'BJ',
    'BL',
    'BM',
    'BN',
    'BO',
    'BQ',
    'BR',
    'BS',
    'BT',
    'BV',
    'BW',
    'BY',
    'BZ',
    'CA',
    'CC',
    'CD',
    'CF',
    'CG',
    'CH',
    'CI',
    'CK',
    'CL',
    'CM',
    'CN',
    'CO',
    'CR',
    'CU',
    'CV',
    'CW',
    'CX',
    'CY',
    'CZ',
    'DE',
    'DJ',
    'DK',
    'DM',
    'DO',
    'DZ',
    'EC',
    'EE',
    'EG',
    'EH',
    'ER',
    'ES',
    'ET',
    'FI',
    'FJ',
    'FK',
    'FM',
    'FO',
    'FR',
    'GA',
    'GB',
    'GD',
    'GE',
    'GF',
    'GG',
    'GH',
    'GI',
    'GL',
    'GM',
    'GN',
    'GP',
    'GQ',
    'GR',
    'GS',
    'GT',
    'GU',
    'GW',
    'GY',
    'HK',
    'HM',
    'HN',
    'HR',
    'HT',
    'HU',
    'ID',
    'IE',
    'IL',
    'IM',
    'IN',
    'IO',
    'IQ',
    'IR',
    'IS',
    'IT',
    'JE',
    'JM',
    'JO',
    'JP',
    'KE',
    'KG',
    'KH',
    'KI',
    'KM',
    'KN',
    'KR',
    'KW',
    'KY',
    'KZ',
    'LA',
    'LB',
    'LC',
    'LI',
    'LK',
    'LR',
    'LS',
    'LT',
    'LU',
    'LV',
    'LY',
    'MA',
    'MC',
    'MD',
    'ME',
    'MF',
    'MG',
    'MH',
    'MK',
    'ML',
    'MM',
    'MN',
    'MO',
    'MP',
    'MQ',
    'MR',
    'MS',
    'MT',
    'MU',
    'MV',
    'MW',
    'MX',
    'MY',
    'MZ',
    'NA',
    'NC',
    'NE',
    'NF',
    'NG',
    'NI',
    'NL',
    'NO',
    'NP',
    'NR',
    'NU',
    'NZ',
    'OM',
    'PA',
    'PE',
    'PF',
    'PG',
    'PH',
    'PK',
    'PL',
    'PM',
    'PN',
    'PR',
    'PS',
    'PT',
    'PW',
    'PY',
    'QA',
    'RE',
    'RO',
    'RS',
    'RU',
    'RW',
    'SA',
    'SB',
    'SC',
    'SD',
    'SE',
    'SG',
    'SH',
    'SI',
    'SJ',
    'SK',
    'SL',
    'SM',
    'SN',
    'SO',
    'SR',
    'SS',
    'ST',
    'SV',
    'SX',
    'SY',
    'SZ',
    'TC',
    'TD',
    'TF',
    'TG',
    'TH',
    'TJ',
    'TK',
    'TL',
    'TM',
    'TN',
    'TO',
    'TR',
    'TT',
    'TV',
    'TW',
    'TZ',
    'UA',
    'UG',
    'UM',
    'US',
    'UY',
    'UZ',
    'VA',
    'VC',
    'VE',
    'VG',
    'VI',
    'VN',
    'VU',
    'WF',
    'WS',
    'YE',
    'YT',
    'ZA',
    'ZM',
    'ZW',
  ],
} as const;

export const CountryFilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    COUNTRY: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleCountriesCriteria',
    },
  },
  required: ['COUNTRY'],
} as const;

export const CreateAssetAccessRequestBodySchema = {
  type: 'object',
  description: 'An object containing a list of all the asset access requests',
  required: ['asset_requests'],
  properties: {
    asset_requests: {
      type: 'array',
      minItems: 1,
      maxItems: 100,
      items: {
        type: 'object',
        required: ['partner_id', 'asset_id_to_permissions'],
        properties: {
          partner_id: {
            description: 'Unique identifier of a business partner to request asset access to.',
            example: '809944451643622187',
            type: 'string',
            pattern: '^\\d+$',
          },
          asset_id_to_permissions: {
            $ref: '#/components/schemas/AssetIdToPermissions',
          },
        },
      },
    },
  },
} as const;

export const CreateAssetAccessRequestErrorMessageSchema = {
  type: 'array',
  description: 'A list of errors associated with the asset access requests. Will be returned if there is an error.',
  nullable: true,
  items: {
    type: 'object',
    properties: {
      code: {
        type: 'integer',
        description: 'Error code associated with the error in requesting asset access.',
        example: 2932,
      },
      messages: {
        type: 'array',
        example: ['Invalid asset id: 549760723247', 'Invalid asset id: 546760723248'],
        items: {
          type: 'string',
        },
      },
    },
  },
} as const;

export const CreateAssetAccessRequestResponseSchema = {
  type: 'object',
  properties: {
    exceptions: {
      $ref: '#/components/schemas/CreateAssetAccessRequestErrorMessage',
    },
    invites: {
      type: 'object',
      nullable: true,
      additionalProperties: {
        description:
          'An object mapping each partner id to the asset access request id. Only one request id is returned per partner.',
        type: 'string',
        pattern: '^\\d+$',
      },
      example: {
        766456567741825556: '5349280584552211583',
        733242520489967216: '5349280584552211845',
      },
    },
  },
} as const;

export const CreateAssetGroupBodySchema = {
  type: 'object',
  properties: {
    asset_group_name: {
      description: 'Asset Group name',
      example: 'Canada Ad Accounts',
      type: 'string',
    },
    asset_group_description: {
      description: 'Asset group description',
      example: 'Asset groups that has ad accounts shared in Canada',
      type: 'string',
    },
    asset_group_types: {
      $ref: '#/components/schemas/AssetGroupTypes',
    },
  },
  required: ['asset_group_types', 'asset_group_description', 'asset_group_name'],
} as const;

export const CreateAssetGroupResponseSchema = {
  type: 'object',
  properties: {
    asset_group: {
      $ref: '#/components/schemas/AssetGroupBinding',
    },
  },
} as const;

export const CreateInvitesResultsResponseArraySchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      description:
        'List of invite/request creation status. If there is an error, an exception object will be returned. If the action was successfully completed, an invite object will be returned.',
      items: {
        type: 'object',
        properties: {
          exception: {
            $ref: '#/components/schemas/InviteExceptionResponse',
          },
          invite: {
            type: 'object',
            description:
              'An invite object if the invite/request was successfully created. Will only be provided if the an invite/request is successfully created.',
            nullable: true,
            properties: {
              id: {
                type: 'string',
                description: 'Unique identifier of the invite/request.',
                example: '383791336903426391',
                pattern: '^\\d+$',
              },
              user: {
                type: 'object',
                description: 'Metadata for the member/partner that was sent the invite/request.',
                allOf: [
                  {
                    $ref: '#/components/schemas/BusinessAccessUserSummary',
                  },
                ],
              },
            },
          },
        },
      },
    },
  },
} as const;

export const CreateMembershipOrPartnershipInvitesBodySchema = {
  description: 'Body to be used on path to send Members or Partners Invite or Request',
  required: ['business_role', 'invite_type'],
  properties: {
    business_role: {
      type: 'string',
      description: `The business access level to grant member/partner. Note, values are case-sensitive.
- EMPLOYEE: Can only view and access assets you assign them to. They cannot see details about other employees, partners, or other assets.
- BIZ_ADMIN: Have full control of roles and can add employees and partners as well as grant asset access.
- PARTNER: Can only view and access assets you assign them to/or they assign to you.`,
      example: 'BIZ_ADMIN',
      enum: ['EMPLOYEE', 'BIZ_ADMIN', 'PARTNER'],
    },
    invite_type: {
      $ref: '#/components/schemas/InviteType',
    },
    members: {
      description: 'A list of usernames, emails, or a mix of them. Should be used if invite_type is MEMBER_INVITE',
      example: ['business0101', 'user@business.com'],
      items: {
        type: 'string',
      },
      type: 'array',
      minItems: 1,
      maxItems: 50,
    },
    partners: {
      description: 'A list of partner_id. Should be used if invite_type is PARTNER_INVITE or PARTNER_REQUEST',
      example: ['809944451643622187', '766456567741825556'],
      items: {
        type: 'string',
        maxLength: 25,
        pattern: '^\\d+$',
      },
      minItems: 1,
      maxItems: 50,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const CreateMMMReportRequestSchema = {
  type: 'object',
  allOf: [
    {
      type: 'object',
      properties: {
        countries: {
          type: 'array',
          description: 'A List of countries for filtering',
          items: {
            $ref: '#/components/schemas/TargetingAdvertiserCountry',
          },
        },
      },
    },
  ],
  properties: {
    report_name: {
      description: 'Name of the Marketing Mix Modeling (MMM) report',
      title: 'report_name',
      type: 'string',
    },
    start_date: {
      description: 'Metric report start date (UTC). Format: YYYY-MM-DD',
      type: 'string',
      pattern: '^(\\d{4})-(\\d{2})-(\\d{2})$',
      example: '2020-12-20',
    },
    end_date: {
      description: 'Metric report end date (UTC). Format: YYYY-MM-DD',
      type: 'string',
      pattern: '^(\\d{4})-(\\d{2})-(\\d{2})$',
      example: '2020-12-20',
    },
    granularity: {
      description: 'DAY - metrics are broken down daily.<br> WEEK - metrics are broken down weekly.',
      type: 'string',
      enum: ['DAY', 'WEEK'],
    },
    level: {
      description: 'Level of the report',
      type: 'string',
      enum: ['CAMPAIGN_TARGETING', 'AD_GROUP_TARGETING'],
    },
    targeting_types: {
      description: 'List of targeting types',
      example: ['GENDER'],
      items: {
        $ref: '#/components/schemas/MMMReportingTargetingType',
      },
      maxItems: 5,
      minItems: 1,
      title: 'targeting_types',
      type: 'array',
    },
    columns: {
      description: 'Metric and entity columns',
      type: 'array',
      items: {
        $ref: '#/components/schemas/MMMReportingColumn',
      },
    },
  },
  required: ['report_name', 'start_date', 'end_date', 'granularity', 'level', 'targeting_types', 'columns'],
} as const;

export const CreateMMMReportResponseSchema = {
  type: 'object',
  properties: {
    code: {
      example: 0,
      type: 'number',
    },
    data: {
      title: 'CreateMMMReportResponseData',
      type: 'object',
      properties: {
        report_status: {
          type: 'string',
          allOf: [
            {
              $ref: '#/components/schemas/BulkReportingJobStatus',
            },
          ],
        },
        token: {
          type: 'string',
        },
        message: {
          type: 'string',
          nullable: true,
        },
        status: {
          example: 'success',
          type: 'string',
        },
      },
    },
  },
} as const;

export const CreativeTypeSchema = {
  type: 'string',
  description:
    'Ad creative type enum. For update, only draft ads may update creative type. </p><strong>Note:</strong> SHOP_THE_PIN has been deprecated. Please use COLLECTION instead.',
  enum: [
    'REGULAR',
    'VIDEO',
    'SHOPPING',
    'CAROUSEL',
    'MAX_VIDEO',
    'SHOP_THE_PIN',
    'COLLECTION',
    'IDEA',
    'SHOWCASE',
    'QUIZ',
  ],
  example: 'REGULAR',
  title: 'CreativeType',
} as const;

export const CurrencySchema = {
  type: 'string',
  description: 'Currency Codes from ISO 4217',
  example: 'USD',
  enum: [
    'UNK',
    'USD',
    'GBP',
    'CAD',
    'EUR',
    'AUD',
    'NZD',
    'SEK',
    'ILS',
    'CHF',
    'HKD',
    'JPY',
    'SGD',
    'KRW',
    'NOK',
    'DKK',
    'PLN',
    'RON',
    'HUF',
    'CZK',
    'BRL',
    'MXN',
    'ARS',
    'CLP',
    'COP',
    'INR',
    'TRY',
  ],
} as const;

export const CurrencyFilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    CURRENCY: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupCurrencyCriteria',
    },
  },
  required: ['CURRENCY'],
} as const;

export const CustomColumnIdSchema = {
  description: 'Custom Column ID',
  example: '123456789',
  type: 'string',
} as const;

export const CustomLabel0FilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    CUSTOM_LABEL_0: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringCriteria',
    },
  },
  required: ['CUSTOM_LABEL_0'],
} as const;

export const CustomLabel1FilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    CUSTOM_LABEL_1: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringCriteria',
    },
  },
  required: ['CUSTOM_LABEL_1'],
} as const;

export const CustomLabel2FilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    CUSTOM_LABEL_2: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringCriteria',
    },
  },
  required: ['CUSTOM_LABEL_2'],
} as const;

export const CustomLabel3FilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    CUSTOM_LABEL_3: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringCriteria',
    },
  },
  required: ['CUSTOM_LABEL_3'],
} as const;

export const CustomLabel4FilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    CUSTOM_LABEL_4: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringCriteria',
    },
  },
  required: ['CUSTOM_LABEL_4'],
} as const;

export const CustomerListSchema = {
  properties: {
    ad_account_id: {
      description: 'Associated ad account ID.',
      example: '549756359984',
      title: 'ad_account_id',
      type: 'string',
    },
    created_time: {
      description: 'Creation time. Unix timestamp in seconds.',
      example: 1452208622,
      title: 'created_time',
      type: 'number',
    },
    id: {
      description: 'Customer list ID.',
      example: '643',
      title: 'id',
      type: 'string',
    },
    name: {
      description: 'Customer list name.',
      example: 'The Glengarry Glen Ross leads',
      title: 'name',
      type: 'string',
    },
    num_batches: {
      description:
        'Total number of list updates.  List creation counts as one batch. Each <a href="/docs/redoc/#operation/ads_v3_customer_list_add_handler_PUT">Append</a> or <a href="/docs/redoc/#operation/ads_v3_customer_list_remove_handler_PUT">Remove API</a> call counts as another. List creation via the Ads Manager UI could result in more than one batch since the UI breaks up large lists.',
      example: 2,
      title: 'num_batches',
      type: 'number',
    },
    num_removed_user_records: {
      description:
        'Number of removed user records. In a <a href="/docs/redoc/#operation/ads_v3_customer_list_remove_handler_PUT">Remove API</a> call, this counter increases even if the user is not found in the list.',
      example: 0,
      title: 'num_removed_user_records',
      type: 'number',
    },
    num_uploaded_user_records: {
      description:
        'Number of uploaded user records. In an <a href="/docs/redoc/#operation/ads_v3_customer_list_add_handler_PUT">Append API</a> call, this counter increases even if the uploaded user is already in the list.',
      example: 11,
      title: 'num_uploaded_user_records',
      type: 'number',
    },
    status: {
      description: 'Customer list status. TOO_SMALL - the list has less than 100 Pinterest users.',
      enum: ['PROCESSING', 'READY', 'TOO_SMALL', 'UPLOADING'],
      example: 'PROCESSING',
      title: 'status',
      type: 'string',
    },
    type: {
      description: 'Always "customerlist".',
      example: 'customerlist',
      title: 'type',
      type: 'string',
    },
    updated_time: {
      description: 'Last update time. Unix timestamp in seconds.',
      example: 1461269616,
      title: 'updated_time',
      type: 'number',
    },
    exceptions: {
      description: 'Customer list errors',
      title: 'exceptions',
      type: 'object',
    },
  },
  title: 'CustomerList',
  type: 'object',
} as const;

export const CustomerListRequestSchema = {
  properties: {
    name: {
      description: 'Customer list name.',
      example: 'The Glengarry Glen Ross leads',
      title: 'name',
      type: 'string',
    },
    records: {
      description:
        'Records list. Can be any combination of emails, MAIDs, or IDFAs. Emails must be lowercase and can be plain text or hashed using SHA1, SHA256, or MD5. MAIDs and IDFAs must be hashed with SHA1, SHA256, or MD5.',
      example: 'email1@pinterest.com,email2@pinterest.com,..<more records>',
      title: 'records',
      type: 'string',
    },
    list_type: {
      allOf: [
        {
          $ref: '#/components/schemas/UserListType',
        },
      ],
      default: 'EMAIL',
      title: 'list_type',
      type: 'string',
    },
    exceptions: {
      description: 'Customer list errors.',
      title: 'exceptions',
      type: 'object',
    },
  },
  required: ['name', 'records'],
  title: 'CustomerListCreate',
  type: 'object',
} as const;

export const CustomerListUpdateRequestSchema = {
  properties: {
    records: {
      description:
        'Records list. Can be any combination of emails, MAIDs, or IDFAs. Emails must be lowercase and can be plain text or hashed using SHA1, SHA256, or MD5. MAIDs and IDFAs must be hashed with SHA1, SHA256, or MD5.',
      example: 'email2@pinterest.com,email6@pinterest.com,',
      title: 'records',
      type: 'string',
    },
    operation_type: {
      allOf: [
        {
          $ref: '#/components/schemas/UserListOperationType',
        },
      ],
      title: 'operation_type',
      type: 'string',
    },
    exceptions: {
      $ref: '#/components/schemas/Exception',
      type: 'object',
    },
  },
  required: ['operation_type', 'records'],
  title: 'CustomerListUpdate',
  type: 'object',
} as const;

export const DataOutputFormatSchema = {
  type: 'string',
  description: 'Format of generated report',
  example: 'JSON',
  enum: ['JSON', 'CSV'],
} as const;

export const DataStatusSchema = {
  description: 'Metrics availablity, e.g., "READY".',
  example: 'READY',
  type: 'string',
  enum: [
    'PROCESSING',
    'READY',
    'ESTIMATE',
    'BEFORE_BUSINESS_CREATED',
    'BEFORE_DATA_RETENTION_PERIOD',
    'BEFORE_PIN_DATA_RETENTION_PERIOD',
    'BEFORE_METRIC_START_DATE',
    'BEFORE_CORE_METRIC_START_DATE',
    'BEFORE_PIN_FORMAT_METRIC_START_DATE',
    'BEFORE_AUDIENCE_METRIC_START_DATE',
    'BEFORE_AUDIENCE_MONTHLY_METRIC_START_DATE',
    'BEFORE_VIDEO_METRIC_START_DATE',
    'BEFORE_CONVERSION_METRIC_START_DATE',
    'PURCHASERS_METRIC_SMALLER_THAN_THRESHOLD',
    'IN_BAD_TAG_DATE',
    'BEFORE_PUBLISHED_METRIC_START_DATE',
    'BEFORE_ASSIST_METRIC_START_DATE',
    'BEFORE_PIN_CREATED',
    'BEFORE_ACCOUNT_CLAIMED',
    'BEFORE_DEMOGRAPHIC_FILTERS_START_DATE',
    'AUDIENCE_SEGMENT_SMALLER_THAN_THRESHOLD',
    'AUDIENCE_TOTAL_SMALLER_THAN_THRESHOLD',
    'BEFORE_PRODUCT_GROUP_FILTER_START_DATE',
  ],
} as const;

export const DeleteMemberAccessResultSchema = {
  type: 'object',
  description: 'The terminated asset access.',
  properties: {
    asset_id: {
      type: 'string',
      description: 'Unique identifier of the business asset.',
      example: '549755885175',
      pattern: '^\\d+$',
    },
    member_id: {
      type: 'string',
      description: 'Unique identifier of the business member.',
      example: '140943737684417',
      pattern: '^\\d+$',
    },
  },
} as const;

export const DeleteMemberAccessResultsResponseArraySchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      description: 'List of member asset permissions that were deleted.',
      items: {
        $ref: '#/components/schemas/DeleteMemberAccessResult',
      },
    },
  },
} as const;

export const DeletedMembersResponseSchema = {
  type: 'object',
  description: 'An object with a list of members that were deleted.',
  properties: {
    deleted_members: {
      type: 'array',
      description: 'List of members whose business membership have been terminated.',
      example: ['809944451643622187', '383791336903426391'],
      items: {
        type: 'string',
        pattern: '^\\d+$',
        example: '809944451643622187',
      },
    },
  },
} as const;

export const DeletePartnersRequestSchema = {
  properties: {
    partner_ids: {
      items: {
        description: 'A list of partner ids to be deleted',
        example: '1234567890123',
        maxLength: 22,
        pattern: '^\\d+$',
        type: 'string',
      },
      minItems: 1,
      maxItems: 50,
      type: 'array',
    },
    partner_type: {
      allOf: [
        {
          description: `If partner_type=INTERNAL, the deleted relationship is the partnership
relationship a partner has with you
If partner_type=EXTERNAL, the deleted relationship is the partnership
relationship you have with a partner`,
          nullable: true,
          type: 'string',
          example: 'INTERNAL',
        },
        {
          $ref: '#/components/schemas/BusinessRoleCheckMode',
        },
      ],
      nullable: true,
      type: 'string',
    },
  },
  required: ['partner_ids'],
  type: 'object',
} as const;

export const DeletePartnersResponseSchema = {
  type: 'object',
  description: 'An object with a list of partners that were deleted.',
  properties: {
    deleted_partners: {
      type: 'array',
      description: 'List of partners whose business partnership have been terminated.',
      example: ['809944451643622187', '383791336903426391'],
      items: {
        type: 'string',
        pattern: '^\\d+$',
        example: '809944451643622187',
      },
    },
  },
} as const;

export const DeliveryMetricsResponseSchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          name: {
            type: 'string',
            description: "Metric's name.",
            example: 'AD_GROUP_ID',
          },
          category: {
            enum: ['ADS', 'ORGANIC'],
            description: 'Category name',
            example: 'ADS',
          },
          definition: {
            type: 'string',
            description: 'How the metric is defined.',
            example: 'Unique ID for your ad group',
          },
          display_name: {
            type: 'string',
            description:
              'Display name, when available. If unavaible it will not be returned. Matches how the metric is named in our native tools like Pinterest Ads Manager.',
            example: 'Ad group ID',
          },
        },
      },
    },
  },
} as const;

export const DetailedErrorSchema = {
  title: 'Detailed Error',
  description: 'Used for including extra details to a base error',
  type: 'object',
  properties: {
    code: {
      type: 'integer',
    },
    message: {
      type: 'string',
    },
    details: {
      type: 'object',
    },
  },
  required: ['code', 'message', 'details'],
} as const;

export const SummaryPinSchema = {
  description: 'Summarized pin information',
  title: 'SummaryPin',
  type: 'object',
  properties: {
    media: {
      allOf: [
        {
          $ref: '#/components/schemas/PinMedia',
        },
      ],
      type: 'object',
      readOnly: true,
    },
    alt_text: {
      type: 'string',
      nullable: true,
      maxLength: 500,
    },
    link: {
      type: 'string',
      nullable: true,
      example: 'https://www.pinterest.com/',
      maxLength: 2048,
    },
    title: {
      type: 'string',
      nullable: true,
    },
    description: {
      type: 'string',
      nullable: true,
    },
  },
} as const;

export const EnhancedMatchStatusTypeSchema = {
  description: 'The enhanced match status of the tag',
  enum: ['UNKNOWN', 'NOT_VALIDATED', 'VALIDATING_IN_PROGRESS', 'VALIDATION_COMPLETE', null],
  example: 'VALIDATION_COMPLETE',
  nullable: true,
  title: 'EnhancedMatchStatusType',
  type: 'string',
} as const;

export const EntityStatusSchema = {
  type: 'string',
  description: 'Entity status',
  example: 'ACTIVE',
  enum: ['ACTIVE', 'PAUSED', 'ARCHIVED', 'DRAFT', 'DELETED_DRAFT'],
} as const;

export const ErrorSchema = {
  title: 'Error',
  type: 'object',
  properties: {
    code: {
      type: 'integer',
    },
    message: {
      type: 'string',
    },
  },
  required: ['code', 'message'],
} as const;

export const ExceptionSchema = {
  title: 'Generic exception class to be used within schemas',
  type: 'object',
  properties: {
    code: {
      type: 'integer',
      example: 2,
      description: 'Exception error code.',
    },
    message: {
      type: 'string',
      example: 'Advertiser not found.',
      description: 'Exception message.',
    },
  },
} as const;

export const FollowUserRequestSchema = {
  title: 'FollowUserRequest',
  type: 'object',
  properties: {
    auto_follow: {
      title: 'auto_follow',
      type: 'boolean',
      description:
        'Whether this request comes as result of auto-follow after clicking on a link. Follow links can be used by partners on their site or in emails. Only selected partners can be followed this way. We verify that partner can be auto-followed.',
      default: false,
      example: false,
    },
  },
} as const;

export const GenderSchema = {
  type: 'string',
  enum: ['FEMALE', 'MALE', 'UNISEX'],
} as const;

export const GenderFilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    GENDER: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleGenderCriteria',
    },
  },
  required: ['GENDER'],
} as const;

export const MediaTypeSchema = {
  type: 'string',
  enum: ['IMAGE', 'VIDEO'],
} as const;

export const MediaTypeFilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    MEDIA_TYPE: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleMediaTypesCriteria',
    },
  },
  required: ['MEDIA_TYPE'],
} as const;

export const GenderListSchema = {
  title: 'Gender',
  type: 'array',
  example: ['female', 'unknown'],
  items: {
    type: 'string',
    enum: ['female', 'male', 'unknown'],
  },
} as const;

export const GetAudiencesOrderBySchema = {
  type: 'string',
  enum: ['NONE', 'ID', 'SIZE', 'CREATION_DATE', 'UPDATED_TIME', 'NAME', 'STATUS', 'TYPE'],
  example: 'NAME',
} as const;

export const GetBusinessAssetsResponseSchema = {
  type: 'object',
  description: 'An object containing the permissions a business has on the asset.',
  properties: {
    asset_id: {
      description: 'Unique identifier of a business asset.',
      example: '549755885175',
      pattern: '^\\d+$',
      type: 'string',
      maxLength: 20,
      minLength: 1,
    },
    asset_type: {
      $ref: '#/components/schemas/AssetTypeResponse',
    },
    asset_group_info: {
      nullable: true,
      description:
        "An object containing all the information specific to the provided asset group. This field will be populated only if asset_type equals 'ASSET_GROUP'.",
      $ref: '#/components/schemas/AssetGroupBinding',
    },
  },
} as const;

export const GetBusinessAssetTypeResponseSchema = {
  description: 'Type of asset.',
  enum: ['AD_ACCOUNT', 'PROFILE', 'ASSET_GROUP', 'CONVERSION_TAG'],
  example: 'AD_ACCOUNT',
  type: 'string',
} as const;

export const GetMMMReportResponseSchema = {
  properties: {
    code: {
      example: 0,
      type: 'number',
    },
    data: {
      title: 'GetMMMReportResponseData',
      type: 'object',
      properties: {
        report_status: {
          type: 'string',
          enum: ['DOES_NOT_EXIST', 'FINISHED', 'IN_PROGRESS', 'EXPIRED', 'FAILED', 'CANCELLED'],
        },
        url: {
          type: 'string',
          nullable: true,
        },
        size: {
          type: 'number',
          nullable: true,
        },
      },
    },
    message: {
      example: 'ok',
      type: 'string',
    },
    status: {
      example: 'success',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const GetPartnerAssetsResponseSchema = {
  type: 'object',
  description: 'An object containing the permissions a you/your business partner has on the asset.',
  properties: {
    asset_id: {
      description: 'Unique identifier of a business asset.',
      example: '549755885175',
      pattern: '^\\d+$',
      type: 'string',
      maxLength: 20,
      minLength: 1,
    },
    asset_type: {
      $ref: '#/components/schemas/AssetTypeResponse',
    },
    permissions: {
      type: 'array',
      description:
        "The permissions you or your partner has on the asset. If partner_type=INTERNAL, the permission levels are for the access the partner has to your business asset.<br> If partner_type=EXTERNAL, the permission levels are for the access you have to the partner's business asset.",
      example: ['FINANCE_MANAGER', 'CATALOGS_MANAGER', 'AUDIENCE_MANAGER'],
      items: {
        description: 'The permission level a user has on an asset.',
        example: 'FINANCE_MANAGER',
        type: 'string',
      },
    },
    asset_group_info: {
      nullable: true,
      description:
        "An object containing all the information specific to the provided asset group. This field will be populated only if asset_type equals 'ASSET_GROUP'.",
      $ref: '#/components/schemas/AssetGroupBinding',
    },
  },
} as const;

export const GoogleProductCategory0FilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    GOOGLE_PRODUCT_CATEGORY_0: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringListCriteria',
    },
  },
  required: ['GOOGLE_PRODUCT_CATEGORY_0'],
} as const;

export const GoogleProductCategory1FilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    GOOGLE_PRODUCT_CATEGORY_1: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringListCriteria',
    },
  },
  required: ['GOOGLE_PRODUCT_CATEGORY_1'],
} as const;

export const GoogleProductCategory2FilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    GOOGLE_PRODUCT_CATEGORY_2: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringListCriteria',
    },
  },
  required: ['GOOGLE_PRODUCT_CATEGORY_2'],
} as const;

export const GoogleProductCategory3FilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    GOOGLE_PRODUCT_CATEGORY_3: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringListCriteria',
    },
  },
  required: ['GOOGLE_PRODUCT_CATEGORY_3'],
} as const;

export const GoogleProductCategory4FilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    GOOGLE_PRODUCT_CATEGORY_4: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringListCriteria',
    },
  },
  required: ['GOOGLE_PRODUCT_CATEGORY_4'],
} as const;

export const GoogleProductCategory5FilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    GOOGLE_PRODUCT_CATEGORY_5: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringListCriteria',
    },
  },
  required: ['GOOGLE_PRODUCT_CATEGORY_5'],
} as const;

export const GoogleProductCategory6FilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    GOOGLE_PRODUCT_CATEGORY_6: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringListCriteria',
    },
  },
  required: ['GOOGLE_PRODUCT_CATEGORY_6'],
} as const;

export const ProductGroupReferenceFilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    PRODUCT_GROUP: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringCriteria',
    },
  },
  required: ['PRODUCT_GROUP'],
} as const;

export const GranularitySchema = {
  type: 'string',
  description: 'Granularity',
  enum: ['TOTAL', 'DAY', 'HOUR', 'WEEK', 'MONTH'],
} as const;

export const GridClickTypeSchema = {
  type: 'string',
  description:
    'Where a user is taken after clicking on an ad in grid. </p><strong>Note:</strong>  This parameter is read-only and is set to DIRECT_TO_DESTINATION by default for direct links supported ads.  grid_click_type values provided will be ignored.',
  example: 'CLOSEUP',
  nullable: true,
  enum: ['CLOSEUP', 'DIRECT_TO_DESTINATION'],
} as const;

export const HotelIdFilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    HOTEL_ID: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringCriteria',
    },
  },
  required: ['HOTEL_ID'],
} as const;

export const CreativeAssetsIdFilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    CREATIVE_ASSETS_ID: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringCriteria',
    },
  },
  required: ['CREATIVE_ASSETS_ID'],
} as const;

export const HotelProcessingRecordSchema = {
  type: 'object',
  description: 'Object describing an item processing record',
  properties: {
    hotel_id: {
      description: 'The catalog hotel id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    errors: {
      description: `Array with the validation errors for the item processing record.
A non empty errors list causes the item processing to fail.`,
      items: {
        $ref: '#/components/schemas/ItemValidationEvent',
      },
      type: 'array',
    },
    warnings: {
      description: 'Array with the validation warnings for the item processing record',
      items: {
        $ref: '#/components/schemas/ItemValidationEvent',
      },
      type: 'array',
    },
    status: {
      $ref: '#/components/schemas/ItemProcessingStatus',
    },
  },
} as const;

export const ImageDetailsSchema = {
  title: 'ImageDetails',
  type: 'object',
  properties: {
    width: {
      type: 'integer',
      minimum: 100,
    },
    height: {
      type: 'integer',
      minimum: 100,
      nullable: true,
    },
    url: {
      type: 'string',
    },
  },
  required: ['height', 'width', 'url'],
  example: {
    width: 400,
    height: 300,
    url: 'https://i.pinimg.com/400x300/0d/f6/f1/0df6f1f0bfe7aaca849c1bbc3607a34b.jpg',
  },
} as const;

export const ImageMetadataSchema = {
  title: 'Image metadata',
  type: 'object',
  properties: {
    item_type: {
      type: 'string',
    },
    title: {
      type: 'string',
      nullable: true,
    },
    description: {
      type: 'string',
      nullable: true,
    },
    link: {
      type: 'string',
      nullable: true,
    },
    images: {
      type: 'object',
      properties: {
        '150x150': {
          type: 'object',
          $ref: '#/components/schemas/ImageDetails',
        },
        '400x300': {
          type: 'object',
          $ref: '#/components/schemas/ImageDetails',
        },
        '600x': {
          type: 'object',
          $ref: '#/components/schemas/ImageDetails',
        },
        '1200x': {
          type: 'object',
          $ref: '#/components/schemas/ImageDetails',
        },
      },
    },
  },
} as const;

export const IntegrationLogSchema = {
  type: 'object',
  additionalProperties: false,
  description: 'Schema for log sent from an integration application.',
  required: ['client_timestamp', 'event_type', 'log_level'],
  properties: {
    client_timestamp: {
      type: 'integer',
      description: 'Timestamp in milliseconds of when the log was executed at the client.',
    },
    event_type: {
      type: 'string',
      enum: ['APP', 'API'],
      description: 'Log event type',
    },
    log_level: {
      type: 'string',
      enum: ['INFO', 'WARN', 'ERROR'],
      description: 'Log level type',
    },
    external_business_id: {
      type: 'string',
      maxLength: 2048,
      nullable: true,
    },
    advertiser_id: {
      type: 'string',
      maxLength: 128,
      nullable: true,
    },
    merchant_id: {
      type: 'string',
      maxLength: 128,
      nullable: true,
    },
    tag_id: {
      type: 'string',
      maxLength: 128,
      nullable: true,
    },
    feed_profile_id: {
      type: 'string',
      maxLength: 128,
      nullable: true,
    },
    message: {
      type: 'string',
      description: 'Explanation of the event that occured.',
      maxLength: 2048,
    },
    app_version_number: {
      type: 'string',
      description: 'Version number of the integration application.',
      maxLength: 20,
    },
    platform_version_number: {
      type: 'string',
      description: 'Version number of the platform the integration application is running on.',
      maxLength: 20,
    },
    error: {
      $ref: '#/components/schemas/IntegrationLogClientError',
    },
    request: {
      $ref: '#/components/schemas/IntegrationLogClientRequest',
    },
  },
} as const;

export const IntegrationLogClientErrorSchema = {
  type: 'object',
  additionalProperties: false,
  description: 'System error details included in the log sent by the client.',
  properties: {
    cause: {
      type: 'string',
      description: 'Original cause of the error.',
      maxLength: 512,
    },
    column_number: {
      type: 'integer',
      description: 'Column number in the line of the file that raised the error.',
    },
    file_name: {
      type: 'string',
      description: 'Filename where the error happened.',
      maxLength: 256,
    },
    line_number: {
      type: 'integer',
      description: 'Line number where the error happened.',
    },
    message: {
      type: 'string',
      description: 'Human-readable description of the error.',
      maxLength: 512,
    },
    message_detail: {
      type: 'string',
      description: 'More detail about the message.',
      maxLength: 1024,
    },
    name: {
      type: 'string',
      description: 'Filename where the error happened.',
      maxLength: 256,
    },
    number: {
      type: 'integer',
      description: 'Integer that specifies the error code.',
    },
    stack_trace: {
      type: 'string',
      description: 'Stack trace of where the error happened.',
    },
  },
} as const;

export const IntegrationLogClientRequestSchema = {
  type: 'object',
  additionalProperties: false,
  description: 'HTTP request details included in the log sent by the client.',
  required: ['method', 'host', 'path'],
  properties: {
    method: {
      type: 'string',
      enum: ['GET', 'HEAD', 'POST', 'PUT', 'DELETE', 'CONNECT', 'OPTIONS', 'TRACE', 'PATCH'],
    },
    host: {
      type: 'string',
      description: 'HTTP request host from host header.',
    },
    path: {
      type: 'string',
      description: 'HTTP request path.',
    },
    request_headers: {
      type: 'object',
      description: 'HTTP request headers as key-value pairs.',
      additionalProperties: {
        type: 'string',
      },
    },
    response_headers: {
      type: 'object',
      description: 'HTTP response headers as key-value pairs.',
      additionalProperties: {
        type: 'string',
      },
    },
    response_status_code: {
      type: 'integer',
    },
  },
} as const;

export const IntegrationLogsInvalidLogResponseSchema = {
  description: 'Schema describing the response when a log has invalid fields.',
  type: 'object',
  properties: {
    rejected_logs: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          log_index: {
            type: 'integer',
            description: 'Index of the log in the batch.',
          },
          field: {
            type: 'string',
            description: 'The field name containing an invalid value.',
          },
          value: {
            type: 'string',
            description: 'The value that is invalid.',
          },
          reason: {
            type: 'string',
            description: 'The reason the value is invalid.',
          },
        },
        required: ['field', 'value', 'reason'],
      },
    },
  },
} as const;

export const IntegrationLogsRequestSchema = {
  type: 'object',
  additionalProperties: false,
  description: 'Batch of logs sent from an integration application.',
  required: ['logs'],
  properties: {
    logs: {
      type: 'array',
      minItems: 1,
      maxItems: 250,
      items: {
        $ref: '#/components/schemas/IntegrationLog',
      },
    },
  },
} as const;

export const IntegrationLogsSuccessResponseSchema = {
  description: 'Response when logs are successfully processed.',
  type: 'object',
  properties: {
    message: {
      type: 'string',
    },
  },
} as const;

export const IntegrationMetadataSchema = {
  title: 'integration',
  description: 'Integration metadata',
  type: 'object',
  properties: {
    id: {
      type: 'string',
      pattern: '^\\d+$',
    },
    external_business_id: {
      type: 'string',
    },
    connected_merchant_id: {
      type: 'string',
    },
    connected_user_id: {
      type: 'string',
      readOnly: true,
    },
    connected_advertiser_id: {
      type: 'string',
      readOnly: true,
    },
    connected_lba_id: {
      type: 'string',
    },
    connected_tag_id: {
      type: 'string',
    },
    partner_access_token_expiry: {
      type: 'number',
    },
    partner_refresh_token_expiry: {
      type: 'number',
    },
    scopes: {
      type: 'string',
    },
    created_timestamp: {
      type: 'number',
    },
    updated_timestamp: {
      type: 'number',
    },
    additional_id_1: {
      type: 'string',
    },
    partner_metadata: {
      type: 'string',
    },
  },
  example: {
    id: '7329167449607351372',
    external_business_id: '1238401984',
    connected_merchant_id: '1445572885401',
    connected_user_id: '871939315263957401',
    connected_advertiser_id: '549764738871',
    connected_lba_id: '871939315263957402',
    connected_tag_id: '2412141155151',
    partner_access_token_expiry: 1621350033000,
    partner_refresh_token_expiry: 1621350033000,
    scopes: 'accounts:read',
    created_timestamp: 1621350033000,
    updated_timestamp: 1621350033000,
    additional_id_1: '128464',
    partner_metadata: '',
  },
} as const;

export const IntegrationRequestSchema = {
  type: 'object',
  description: 'Schema used for creating the integration metadata.',
  properties: {
    external_business_id: {
      type: 'string',
      nullable: true,
      description: 'External business ID for the integration.',
    },
    connected_merchant_id: {
      type: 'string',
    },
    connected_advertiser_id: {
      type: 'string',
    },
    connected_lba_id: {
      type: 'string',
    },
    connected_tag_id: {
      type: 'string',
    },
    partner_access_token: {
      type: 'string',
    },
    partner_refresh_token: {
      type: 'string',
    },
    partner_primary_email: {
      type: 'string',
    },
    partner_access_token_expiry: {
      type: 'integer',
    },
    partner_refresh_token_expiry: {
      type: 'integer',
    },
    scopes: {
      type: 'string',
    },
    additional_id_1: {
      type: 'string',
    },
    partner_metadata: {
      type: 'string',
    },
  },
} as const;

export const IntegrationRequestPatchSchema = {
  type: 'object',
  description: 'Schema used for updating the integration metadata.',
  properties: {
    connected_merchant_id: {
      type: 'string',
    },
    connected_advertiser_id: {
      type: 'string',
    },
    connected_lba_id: {
      type: 'string',
    },
    connected_tag_id: {
      type: 'string',
    },
    partner_access_token: {
      type: 'string',
    },
    partner_refresh_token: {
      type: 'string',
    },
    partner_primary_email: {
      type: 'string',
    },
    partner_access_token_expiry: {
      type: 'number',
    },
    partner_refresh_token_expiry: {
      type: 'number',
    },
    scopes: {
      type: 'string',
    },
    additional_id_1: {
      type: 'string',
    },
    partner_metadata: {
      type: 'string',
    },
  },
} as const;

export const IntegrationRecordSchema = {
  title: 'Integration record',
  description: 'Integration record',
  type: 'object',
  properties: {
    id: {
      type: 'string',
      pattern: '^\\d+$',
    },
    external_business_id: {
      type: 'string',
      nullable: true,
    },
    connected_merchant_id: {
      type: 'string',
      nullable: true,
    },
    connected_user_id: {
      type: 'string',
      readOnly: true,
    },
    connected_advertiser_id: {
      type: 'string',
      readOnly: true,
      nullable: true,
    },
    connected_lba_id: {
      type: 'string',
      nullable: true,
    },
    connected_tag_id: {
      type: 'string',
      nullable: true,
    },
    partner_access_token: {
      type: 'string',
      nullable: true,
    },
    partner_refresh_token: {
      type: 'string',
      nullable: true,
    },
    partner_primary_email: {
      type: 'string',
      nullable: true,
    },
    partner_access_token_expiry: {
      type: 'integer',
      nullable: true,
    },
    partner_refresh_token_expiry: {
      type: 'integer',
      nullable: true,
    },
    scopes: {
      type: 'string',
      nullable: true,
    },
    partner_metadata: {
      type: 'string',
      nullable: true,
    },
    additional_id_1: {
      type: 'string',
      nullable: true,
    },
    created_time: {
      type: 'integer',
    },
    updated_time: {
      type: 'integer',
    },
  },
  example: {
    id: '7329123456789012345',
    external_business_id: '1234567890',
    connected_merchant_id: '1234567890123',
    connected_user_id: '123456789012345678',
    connected_advertiser_id: '123456789012',
    connected_lba_id: '871234567890123456',
    connected_tag_id: '2412345678901',
    partner_access_token: 'ABCLUOJS5XDMWDE',
    partner_refresh_token: 'ABCLUOJS5XDMWDE',
    partner_primary_email: 'partner@server.com',
    partner_access_token_expiry: 1621350033000,
    partner_refresh_token_expiry: 1621350033000,
    scopes: 'accounts:read',
    partner_metadata: '',
    additional_id_1: '123456',
    created_time: 1621350033000,
    updated_time: 1621350033000,
  },
} as const;

export const InterestSchema = {
  title: 'Interest',
  type: 'object',
  properties: {
    canonical_url: {
      type: 'string',
    },
    id: {
      type: 'string',
      pattern: '^\\d+$',
      example: '903972677830',
    },
    key: {
      type: 'string',
      example: 'man cave',
    },
    name: {
      type: 'string',
      example: 'Man cave',
    },
  },
} as const;

export const InviteAssetsSummarySchema = {
  type: 'object',
  description: 'Ad accounts and profiles the member/partner will be granted access to with this invite/request.',
  nullable: true,
  properties: {
    ad_accounts: {
      type: 'array',
      description: 'List of ad account IDs and respective permission levels that will be assigned.',
      items: {
        type: 'object',
        properties: {
          id: {
            type: 'string',
            description: 'Unique identifier of a business ad account.',
            example: '549755885175',
            pattern: '^\\d+$',
          },
          permissions: {
            $ref: '#/components/schemas/PermissionsResponse',
          },
        },
      },
    },
    profiles: {
      type: 'array',
      description: 'List of profile IDs and respective permission levels that will be assigned.',
      items: {
        type: 'object',
        properties: {
          id: {
            type: 'string',
            description: 'Unique identifier of a business profile.',
            example: '383791336903426391',
            pattern: '^\\d+$',
          },
          permissions: {
            $ref: '#/components/schemas/PermissionsResponse',
          },
        },
      },
    },
  },
} as const;

export const InviteExceptionResponseSchema = {
  type: 'object',
  description:
    'An exception object if there is an error performing the action. Will only be provided if there is an error.',
  nullable: true,
  properties: {
    invite_or_request_id: {
      type: 'string',
      description: 'Unique identifier of the invite/request.',
      example: '383791336903426391',
      pattern: '^\\d+$',
      nullable: true,
    },
    code: {
      type: 'integer',
      description: 'Error code associated with the error in performing the action on the invite/request.',
      example: 403,
    },
    message: {
      type: 'string',
      description: 'Error message associated with the error in performing the action on the invite/request.',
      example: 'You hit the maximum number of pending invites allowed.',
    },
    users_or_partner_ids: {
      type: 'array',
      description: "A list of users' usernames or emails OR a list of partner ids that caused the error.",
      nullable: true,
      example: ['businessMember0101', 'business+member@business.com'],
      items: {
        type: 'string',
        description: "A user's username or email OR a partner id that caused the error.",
      },
    },
  },
} as const;

export const InviteBusinessRoleBindingSchema = {
  type: 'object',
  description:
    'An invite object if the invite/request was successfully updated. Will only be provided if the an invite/request is successfully updated.',
  nullable: true,
  allOf: [
    {
      $ref: '#/components/schemas/BaseInviteDataResponse',
    },
  ],
  properties: {
    created_by_business_id: {
      type: 'string',
      description: 'Unique identifier for the business that created the invite/request.',
      example: '1234567890123',
    },
    created_by_user_id: {
      type: 'string',
      description: 'Unique identifier for the user that created the invite/request.',
      example: '1234567890123',
    },
    user: {
      type: 'object',
      description: 'Metadata for the user that updated the invite/request.',
      allOf: [
        {
          $ref: '#/components/schemas/BusinessAccessUserSummary',
        },
      ],
    },
  },
} as const;

export const InviteResponseSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/BaseInviteDataResponse',
    },
  ],
  properties: {
    assets_summary: {
      $ref: '#/components/schemas/InviteAssetsSummary',
    },
    business_roles: {
      description:
        'The access level a user would be granted on the business if the invite/request is accepted. This can be EMPLOYEE, BIZ_ADMIN, or PARTNER.',
      type: 'array',
      example: ['BIZ_ADMIN'],
      items: {
        $ref: '#/components/schemas/BusinessRoleResponse',
      },
    },
    created_by_business: {
      type: 'object',
      description: 'Metadata for the business that created the invite/request.',
      nullable: true,
      allOf: [
        {
          $ref: '#/components/schemas/BusinessAccessUserSummary',
        },
      ],
    },
    created_by_user: {
      type: 'object',
      description: 'Metadata for the user that created the invite/request.',
      nullable: true,
      allOf: [
        {
          $ref: '#/components/schemas/BusinessAccessUserSummary',
        },
      ],
    },
    created_time: {
      type: 'integer',
      description: 'The time the invite/request was created. Returned in milliseconds.',
      example: 1646767577816,
    },
  },
} as const;

export const InviteStatusSchema = {
  description: 'The current status of the invite.',
  enum: ['PENDING', 'ACCEPTED', 'DECLINED', 'CANCELLED', 'EXPIRED'],
  example: 'PENDING',
  type: 'string',
} as const;

export const InviteTypeSchema = {
  description:
    "The type of invite. <br>'MEMBER_INVITE' is to invite a member to access your business assets. <br>'PARTNER INVITE' is to invite a partner to access your business assets. <br>'PARTNER_REQUEST' is to request access a partner's business assets.",
  example: 'MEMBER_INVITE',
  enum: ['MEMBER_INVITE', 'PARTNER_INVITE', 'PARTNER_REQUEST'],
  type: 'string',
} as const;

export const AssetGroupBindingSchema = {
  type: 'object',
  properties: {
    id: {
      description: 'Asset Group ID.',
      example: '666791336903426391',
      type: 'string',
      pattern: '^\\d+$',
    },
    asset_group_name: {
      type: 'string',
      description: 'Asset Group name',
      example: 'Canada Ad Accounts',
      nullable: true,
    },
    asset_group_description: {
      type: 'string',
      description: 'Asset group description',
      example: 'Asset group that has ad accounts used in Canada',
      nullable: true,
    },
    asset_group_types: {
      type: 'array',
      description: 'Asset group types',
      example: ['LOCATION_OR_LANGUAGE'],
      items: {
        description: 'The types of the asset group.',
        example: 'LOCATION_OR_LANGUAGE',
        type: 'string',
      },
    },
    ad_accounts_ids: {
      description: 'A list of ad account IDs under the asset group',
      example: ['549755885175'],
      type: 'array',
      nullable: true,
      items: {
        description: 'The ID of an ad account in the asset group.',
        example: '549755885175',
        type: 'string',
        pattern: '^\\d+$',
      },
    },
    profiles_ids: {
      description: 'A list of profile IDs under asset group',
      example: ['630433785246278264'],
      type: 'array',
      nullable: true,
      items: {
        description: 'The ID of a profile in an asset group.',
        example: '630433785246278264',
        type: 'string',
        pattern: '^\\d+$',
      },
    },
    created_time: {
      description: 'The creation time of the asset group',
      example: 1646767577816,
      nullable: true,
      type: 'integer',
    },
    updated_time: {
      description: 'The last update time of the asset group',
      example: 1646767577816,
      nullable: true,
      type: 'integer',
    },
    owner: {
      type: 'object',
      allOf: [
        {
          $ref: '#/components/schemas/BusinessAccessUserSummary',
        },
      ],
      description: 'The data of the business that owns the asset group.',
      nullable: true,
    },
    created_by: {
      type: 'object',
      allOf: [
        {
          $ref: '#/components/schemas/BusinessAccessUserSummary',
        },
      ],
      description: 'The data of the user that created the asset group.',
      nullable: true,
    },
  },
} as const;

export const AssetGroupTypeSchema = {
  description: 'Asset group type',
  enum: ['BRAND', 'LOCATION_OR_LANGUAGE', 'PRODUCT_LINE', 'OTHER'],
  example: 'BRAND',
  type: 'string',
} as const;

export const AssetGroupTypesSchema = {
  description:
    'Asset Group Types. Note: The asset group types are used for user reference and categorization purposes only and do not impact the functionality of the asset group.',
  example: ['BRAND', 'LOCATION_OR_LANGUAGE', 'PRODUCT_LINE', 'OTHER'],
  type: 'array',
  items: {
    $ref: '#/components/schemas/AssetGroupType',
  },
} as const;

export const ItemAttributesSchema = {
  type: 'object',
  allOf: [
    {
      type: 'object',
      properties: {
        additional_image_link: {
          description: `<p><= 2000 characters</p>
<p>The links to additional images for your product. Up to ten
additional images can be used to show a product from different angles
or to show different stages. Must begin with http:// or https://.</p>`,
          example: ['https://scene.example.com/image/image_v2.jpg', 'https://scene.example.com/image/image_v3.jpg'],
          type: 'array',
          nullable: true,
          items: {
            type: 'string',
          },
        },
        image_link: {
          description: `<p><= 2000 characters</p>
<p>The link to the main product images. Images should be at least
75x75 pixels to avoid errors. Use the additional_image_link field to add
more images of your product. The URL of your image_link must be accessible
by the Pinterest user-agent, and send the accurate images. Please make
sure there are no template or placeholder images at the link. Must start
with http:// or https://.</p>`,
          example: ['https://scene.example.com/image/image.jpg'],
          type: 'array',
          minItems: 1,
          items: {
            type: 'string',
          },
        },
        video_link: {
          description: `<p><= 2,000 characters</p>
<p>Hosted link to the product video.</p>
<p>File types for linked videos must be .mp4, .mov or .m4v.</p>
<p>File size cannot exceed 2GB.</p>`,
          example: 'https://www.example.com/cat/womens-clothing/denim-shirt-0294.mp4',
          type: 'string',
          nullable: true,
        },
      },
    },
    {
      $ref: '#/components/schemas/UpdatableItemAttributes',
    },
  ],
} as const;

export const ItemAttributesRequestSchema = {
  type: 'object',
  allOf: [
    {
      type: 'object',
      properties: {
        additional_image_link: {
          description: `<p><= 2000 characters</p>
<p>The links to additional images for your product. Up to ten
additional images can be used to show a product from different angles
or to show different stages. Must begin with http:// or https://.</p>`,
          example: ['https://scene.example.com/image/image_v2.jpg', 'https://scene.example.com/image/image_v3.jpg'],
          type: 'array',
          nullable: true,
          items: {
            type: 'string',
          },
        },
        image_link: {
          description: `<p><= 2000 characters</p>
<p>The links to the main product images. Images should be at least
75x75 pixels to avoid errors. Use the additional_image_link field to add
more images of your product. The URL of your image_link must be accessible
by the Pinterest user-agent, and send the accurate images. Please make
sure there are no template or placeholder images at the link. Must start
with http:// or https://.</p>`,
          example: ['https://scene.example.com/image/image.jpg'],
          oneOf: [
            {
              description: 'The list of links to the main product images',
              type: 'array',
              minItems: 1,
              items: {
                type: 'string',
              },
            },
            {
              description: 'The main product image link.',
              type: 'string',
              nullable: false,
            },
          ],
        },
        video_link: {
          description: `<p><= 2,000 characters</p>
<p>Hosted link to the product video.</p>
<p>File types for linked videos must be .mp4, .mov or .m4v.</p>
<p>File size cannot exceed 2GB.</p>`,
          example: 'https://www.example.com/cat/womens-clothing/denim-shirt-0294.mp4',
          type: 'string',
          nullable: true,
        },
      },
    },
    {
      $ref: '#/components/schemas/UpdatableItemAttributes',
    },
  ],
} as const;

export const ItemBatchRecordSchema = {
  type: 'object',
  description: 'Object describing an item batch record',
  oneOf: [
    {
      $ref: '#/components/schemas/ItemCreateBatchRecord',
    },
    {
      $ref: '#/components/schemas/ItemDeleteDiscontinuedBatchRecord',
    },
    {
      $ref: '#/components/schemas/ItemUpdateBatchRecord',
    },
    {
      $ref: '#/components/schemas/ItemUpsertBatchRecord',
    },
    {
      $ref: '#/components/schemas/ItemDeleteBatchRecord',
    },
  ],
} as const;

export const ItemCreateBatchRecordSchema = {
  type: 'object',
  description: 'Object describing an item batch record to create items',
  properties: {
    item_id: {
      description: 'The catalog item id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    attributes: {
      $ref: '#/components/schemas/ItemAttributesRequest',
    },
  },
} as const;

export const ItemDeleteBatchRecordSchema = {
  type: 'object',
  description: 'Object describing an item batch record to delete items',
  properties: {
    item_id: {
      description: 'The catalog item id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
  },
} as const;

export const ItemDeleteDiscontinuedBatchRecordSchema = {
  type: 'object',
  description: 'Object describing an item batch record to discontinue items',
  properties: {
    item_id: {
      description: 'The catalog item id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
  },
} as const;

export const ItemGroupIdFilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    ITEM_GROUP_ID: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringCriteria',
    },
  },
  required: ['ITEM_GROUP_ID'],
} as const;

export const ItemIdFilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    ITEM_ID: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringCriteria',
    },
  },
  required: ['ITEM_ID'],
} as const;

export const ItemProcessingRecordSchema = {
  type: 'object',
  description: 'Object describing an item processing record',
  properties: {
    item_id: {
      description: 'The catalog item id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    errors: {
      description: `Array with the validation errors for the item processing record.
A non empty errors list causes the item processing to fail.`,
      items: {
        $ref: '#/components/schemas/ItemValidationEvent',
      },
      type: 'array',
    },
    warnings: {
      description: 'Array with the validation warnings for the item processing record',
      items: {
        $ref: '#/components/schemas/ItemValidationEvent',
      },
      type: 'array',
    },
    status: {
      $ref: '#/components/schemas/ItemProcessingStatus',
    },
  },
} as const;

export const ItemProcessingStatusSchema = {
  description: 'The status of the item processing record',
  example: 'SUCCESS',
  type: 'string',
  enum: ['SUCCESS', 'FAILURE', 'PROCESSING'],
} as const;

export const ItemResponseSchema = {
  type: 'object',
  description: 'Object describing an item record',
  anyOf: [
    {
      type: 'object',
      properties: {
        catalog_type: {
          $ref: '#/components/schemas/CatalogsType',
        },
      },
      required: ['catalog_type'],
      oneOf: [
        {
          $ref: '#/components/schemas/CatalogsRetailItemResponse',
        },
        {
          $ref: '#/components/schemas/CatalogsHotelItemResponse',
        },
        {
          $ref: '#/components/schemas/CatalogsCreativeAssetsItemResponse',
        },
      ],
      discriminator: {
        propertyName: 'catalog_type',
        mapping: {
          RETAIL: '#/components/schemas/CatalogsRetailItemResponse',
          HOTEL: '#/components/schemas/CatalogsHotelItemResponse',
          CREATIVE_ASSETS: '#/components/schemas/CatalogsCreativeAssetsItemResponse',
        },
      },
    },
    {
      type: 'object',
      properties: {
        catalog_type: {
          $ref: '#/components/schemas/CatalogsType',
        },
      },
      required: ['catalog_type'],
      oneOf: [
        {
          $ref: '#/components/schemas/CatalogsRetailItemErrorResponse',
        },
        {
          $ref: '#/components/schemas/CatalogsHotelItemErrorResponse',
        },
        {
          $ref: '#/components/schemas/CatalogsCreativeAssetsItemErrorResponse',
        },
      ],
      discriminator: {
        propertyName: 'catalog_type',
        mapping: {
          RETAIL: '#/components/schemas/CatalogsRetailItemErrorResponse',
          HOTEL: '#/components/schemas/CatalogsHotelItemErrorResponse',
          CREATIVE_ASSETS: '#/components/schemas/CatalogsCreativeAssetsItemErrorResponse',
        },
      },
    },
  ],
} as const;

export const ItemUpdateBatchRecordSchema = {
  type: 'object',
  description: 'Object describing an item batch record to update items',
  properties: {
    item_id: {
      description: 'The catalog item id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    attributes: {
      $ref: '#/components/schemas/UpdatableItemAttributes',
    },
    update_mask: {
      description:
        'The list of product attributes to be updated. Attributes specified in the update mask without a value specified in the body will be deleted from the product item.',
      example: [
        'ad_link',
        'adult',
        'age_group',
        'availability',
        'average_review_rating',
        'brand',
        'checkout_enabled',
        'color',
        'condition',
        'custom_label_0',
        'custom_label_1',
        'custom_label_2',
        'custom_label_3',
        'custom_label_4',
        'description',
        'free_shipping_label',
        'free_shipping_limit',
        'gender',
        'google_product_category',
        'gtin',
        'item_group_id',
        'last_updated_time',
        'link',
        'material',
        'min_ad_price',
        'mpn',
        'number_of_ratings',
        'number_of_reviews',
        'pattern',
        'price',
        'product_type',
        'sale_price',
        'shipping',
        'shipping_height',
        'shipping_weight',
        'shipping_width',
        'size',
        'size_system',
        'size_type',
        'tax',
        'title',
        'variant_names',
        'variant_values',
      ],
      type: 'array',
      nullable: true,
      items: {
        $ref: '#/components/schemas/UpdateMaskFieldType',
      },
    },
  },
} as const;

export const ItemUpsertBatchRecordSchema = {
  type: 'object',
  description: 'Object describing an item batch record to upsert items',
  properties: {
    item_id: {
      description: 'The catalog item id in the merchant namespace',
      example: 'DS0294-M',
      type: 'string',
    },
    attributes: {
      $ref: '#/components/schemas/ItemAttributesRequest',
    },
  },
} as const;

export const ItemValidationEventSchema = {
  type: 'object',
  description: 'Object describing an item validation event',
  properties: {
    attribute: {
      description: 'The attribute that the item validation event references',
      example: 'title',
      type: 'string',
    },
    code: {
      description: 'The event code that the item validation event references',
      example: 106,
      type: 'integer',
    },
    message: {
      description: 'Title message describing the item validation event',
      example: 'Title is missing from product metadata.',
      type: 'string',
    },
  },
} as const;

export const KeywordSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/KeywordsCommon',
    },
    {
      type: 'object',
      properties: {
        archived: {
          type: 'boolean',
          example: false,
        },
        id: {
          description: 'Keyword ID .',
          example: '383791336903426391',
          pattern: '^\\d+$',
          title: 'id',
          type: 'string',
        },
        parent_id: {
          description: 'Keyword parent entity ID (advertiser, campaign, ad group).',
          example: '383791336903426391',
          pattern: '^\\d+$',
          title: 'parent_id',
          type: 'string',
        },
        parent_type: {
          type: 'string',
          description: 'Parent entity type',
          example: 'campaign',
        },
        type: {
          type: 'string',
          description: 'Always keyword',
          example: 'keyword',
        },
      },
    },
  ],
} as const;

export const KeywordErrorSchema = {
  type: 'object',
  properties: {
    data: {
      $ref: '#/components/schemas/Keyword',
    },
    error_messages: {
      type: 'array',
      items: {
        type: 'string',
      },
    },
  },
} as const;

export const KeywordListSchema = {
  title: 'Keywords',
  type: 'array',
  example: ['recipes', 'dessert'],
  items: {
    type: 'string',
    minLength: 1,
    maxLength: 100,
  },
  minItems: 1,
  maxItems: 50,
} as const;

export const KeywordMetricsSchema = {
  description: 'Keyword metrics JSON',
  title: 'KeywordMetrics',
  type: 'object',
  properties: {
    avg_cpc_in_micro_currency: {
      example: 100000,
      title: 'avg_cpc_in_micro_currency',
      description: 'Average cost per click',
      type: 'number',
    },
    keyword_query_volume: {
      example: '5M+',
      title: 'keyword_query_volume',
      description: "Keyword's search frequency. This value is based on keyword frequency in pepsi client response",
      type: 'string',
    },
  },
} as const;

export const KeywordMetricsResponseSchema = {
  title: 'KeywordMetricsResponse',
  type: 'object',
  properties: {
    keyword: {
      description: 'Keyword name, e.g., "keyword":"fashion outfits"',
      example: 'animals',
      title: 'keyword',
      type: 'string',
    },
    metrics: {
      $ref: '#/components/schemas/KeywordMetrics',
    },
  },
} as const;

export const KeywordUpdateSchema = {
  title: 'KeywordUpdate',
  type: 'object',
  properties: {
    id: {
      type: 'string',
      description: 'Keyword ID.',
      example: '2886364308355',
      pattern: '^\\d+$',
      title: 'id',
    },
    archived: {
      type: 'boolean',
      description: 'Is keyword archived?',
      example: false,
      title: 'archived',
    },
    bid: {
      type: 'integer',
      description:
        '</p><strong>Note:</strong> bid field has been deprecated. Input will not be set and field will return null. Keyword custom bid in microcurrency - null if inherited from parent ad group.',
      example: null,
      nullable: true,
      title: 'bid',
    },
  },
  required: ['id'],
} as const;

export const KeywordUpdateBodySchema = {
  type: 'object',
  properties: {
    keywords: {
      description:
        'Keywords to update. Object array. Each object has 2 possible fields:<br>1. "id": (required) keyword ID<br>2. "archived": boolean. Should keyword be archived?<br>For example: [{"id":"2886610576653", "archived": false}, {"id":"2886610576654",  "archived": true}, ...]',
      type: 'array',
      items: {
        $ref: '#/components/schemas/KeywordUpdate',
      },
      title: 'keywords',
    },
  },
  required: ['keywords'],
} as const;

export const KeywordsCommonSchema = {
  type: 'object',
  properties: {
    bid: {
      type: 'integer',
      description:
        '</p><strong>Note:</strong> bid field has been deprecated. Input will not be set and field will return null. Keyword custom bid in microcurrency - null if inherited from parent ad group.',
      example: null,
      nullable: true,
    },
    match_type: {
      $ref: '#/components/schemas/MatchTypeResponse',
    },
    value: {
      type: 'string',
      description: 'Keyword value (120 chars max).',
    },
  },
  required: ['match_type', 'value'],
} as const;

export const KeywordsMetricsArrayResponseSchema = {
  type: 'object',
  title: 'KeywordMetricsArrayResponse',
  properties: {
    data: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/KeywordMetricsResponse',
      },
    },
  },
} as const;

export const KeywordsRequestSchema = {
  type: 'object',
  properties: {
    keywords: {
      type: 'array',
      description: 'Keyword JSON array. Each array element has 3 fields',
      items: {
        $ref: '#/components/schemas/KeywordsCommon',
      },
    },
    parent_id: {
      description: 'Keyword parent entity ID (advertiser, campaign, ad group).',
      example: '383791336903426391',
      pattern: '^((AG)|C)?\\d+$',
      title: 'parent_id',
      type: 'string',
    },
  },
  required: ['keywords', 'parent_id'],
} as const;

export const KeywordsResponseSchema = {
  type: 'object',
  properties: {
    errors: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/KeywordError',
      },
    },
    keywords: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/Keyword',
      },
    },
  },
} as const;

export const L1InterestListSchema = {
  title: 'Interest',
  type: 'array',
  example: ['beauty', 'womens_fashion'],
  items: {
    type: 'string',
    enum: [
      'animals',
      'architecture',
      'art',
      'beauty',
      'childrens_fashion',
      'design',
      'diy_and_crafts',
      'education',
      'electronics',
      'entertainment',
      'event_planning',
      'finance',
      'food_and_drinks',
      'gardening',
      'health',
      'home_decor',
      'mens_fashion',
      'parenting',
      'quotes',
      'sport',
      'travel',
      'vehicles',
      'wedding',
      'womens_fashion',
    ],
  },
} as const;

export const LanguageSchema = {
  type: 'string',
  description: 'Language code, which is among the offical ISO 639-1 language list.',
  example: 'EN',
  enum: [
    'AM',
    'AR',
    'AZ',
    'BG',
    'BN',
    'BS',
    'CA',
    'CS',
    'DA',
    'DV',
    'DZ',
    'DE',
    'EL',
    'EN',
    'ES',
    'ET',
    'FA',
    'FI',
    'FR',
    'HE',
    'HI',
    'HR',
    'HU',
    'HY',
    'ID',
    'IN',
    'IS',
    'IT',
    'IW',
    'JA',
    'KA',
    'KM',
    'KO',
    'LO',
    'LT',
    'LV',
    'MK',
    'MN',
    'MS',
    'MY',
    'NB',
    'NE',
    'NL',
    'NO',
    'PL',
    'PT',
    'RO',
    'RU',
    'SK',
    'SL',
    'SQ',
    'SR',
    'SV',
    'TL',
    'UK',
    'VI',
    'TE',
    'TH',
    'TR',
    'XX',
    'ZH',
  ],
} as const;

export const LeadFormCommonSchema = {
  type: 'object',
  description: 'Creation fields',
  properties: {
    name: {
      description: 'Internal name of the lead form.',
      example: 'Lead Form 3/14/2023',
      type: 'string',
      nullable: true,
    },
    privacy_policy_link: {
      description:
        "A link to the advertiser's privacy policy. This will be included in the lead form's disclosure language.",
      example: 'https://www.advertisername.com/privacy-policy',
      type: 'string',
      nullable: true,
    },
    has_accepted_terms: {
      description: `Whether the advertiser has accepted Pinterest's terms of service for creating a lead ad.

By sending us TRUE for this parameter, you agree that (i) you will use any personal information received in
compliance with the privacy policy you share with Pinterest, and (ii) you will comply with Pinterest's <a href="https://policy.pinterest.com/en/lead-ad-terms">Lead Ad Terms</a>. As a reminder, all advertising on Pinterest is subject to the <a href="https://business.pinterest.com/en/pinterest-advertising-services-agreement/">Pinterest Advertising Services Agreement</a> or an equivalent agreement as set forth on an IO`,
      example: false,
      type: 'boolean',
    },
    completion_message: {
      description: 'A message for people who complete the form to let them know what happens next.',
      example: 'Thank you for submitting. We will contact you soon.',
      type: 'string',
      nullable: true,
    },
    status: {
      $ref: '#/components/schemas/LeadFormStatus',
    },
    disclosure_language: {
      description: 'Additional disclosure language to be included in the lead form.',
      example: 'By entering your personal information, you agree that your data will be collected and used.',
      type: 'string',
      nullable: true,
    },
    questions: {
      description: 'List of questions to be displayed on the lead form.',
      example: [
        {
          question_type: 'CUSTOM',
          custom_question_field_type: 'CHECKBOX',
          custom_question_label: 'What is your favorite animal?',
          custom_question_options: ['Dog', 'Cat', 'Bird', 'Turtle'],
        },
      ],
      type: 'array',
      minItems: 0,
      maxItems: 10,
      items: {
        $ref: '#/components/schemas/LeadFormQuestion',
      },
    },
    policy_links: {
      description: 'List of additional policy links to be displayed on the lead form.',
      example: [
        {
          label: 'Copyright',
          link: 'https://policy.pinterest.com/en/copyright',
        },
      ],
      type: 'array',
      minItems: 0,
      maxItems: 3,
      items: {
        type: 'object',
        properties: {
          label: {
            description: 'Policy label for an additional policy link.',
            nullable: false,
            type: 'string',
          },
          link: {
            description: 'Policy link for an additional policy link.',
            nullable: false,
            type: 'string',
          },
        },
      },
    },
  },
} as const;

export const LeadFormQuestionSchema = {
  type: 'object',
  properties: {
    question_type: {
      $ref: '#/components/schemas/LeadFormQuestionType',
    },
    custom_question_field_type: {
      $ref: '#/components/schemas/LeadFormQuestionFieldType',
    },
    custom_question_label: {
      description: 'Question label for a custom question.',
      nullable: true,
      type: 'string',
    },
    custom_question_options: {
      description: 'Question options for a custom question.',
      nullable: true,
      type: 'array',
      minItems: 0,
      maxItems: 5,
      items: {
        type: 'string',
      },
    },
  },
} as const;

export const LeadFormQuestionFieldTypeSchema = {
  type: 'string',
  description: 'Lead form question field type',
  example: 'RADIO_LIST',
  nullable: true,
  enum: ['TEXT_FIELD', 'TEXT_AREA', 'RADIO_LIST', 'CHECKBOX', null],
} as const;

export const LeadFormQuestionTypeSchema = {
  type: 'string',
  description: 'Lead form question type',
  example: 'FIRST_NAME',
  enum: [
    'CUSTOM',
    'FULL_NAME',
    'FIRST_NAME',
    'LAST_NAME',
    'EMAIL',
    'PHONE_NUMBER',
    'ZIP_CODE',
    'GENDER',
    'CITY',
    'COUNTRY',
    'STATE_PROVINCE',
    'ADDRESS',
    'DATE_OF_BIRTH',
    'AGE',
  ],
} as const;

export const LeadFormTestRequestSchema = {
  title: 'LeadFormTestRequest',
  description: 'Request to create test data for lead data test API.',
  type: 'object',
  properties: {
    answers: {
      description: 'Test lead answers. Should follow the creation order.',
      type: 'array',
      items: {
        type: 'string',
      },
      example: ['John', 'Doe', 'abc@email.com', '987654321'],
    },
  },
  required: ['answers'],
} as const;

export const LeadFormTestResponseSchema = {
  title: 'LeadFormTestResponse',
  type: 'object',
  description: 'Response for lead data test API.',
  properties: {
    subscription_id: {
      description: 'Subscription ID.',
      example: '8078432025948590686',
      type: 'string',
      pattern: '^\\d+$',
    },
  },
} as const;

export const LeadFormResponseSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/LeadFormCommon',
    },
    {
      type: 'object',
      properties: {
        id: {
          description: 'The ID of this lead form',
          example: '7765300871171',
          type: 'string',
          pattern: '^\\d+$',
        },
        ad_account_id: {
          description: 'The Ad Account ID that this lead form belongs to.',
          example: '549755885175',
          type: 'string',
          pattern: '^\\d+$',
        },
        created_time: {
          description: 'Lead form creation time. Unix timestamp in seconds.',
          example: 1451431341,
          type: 'integer',
        },
        updated_time: {
          description: 'Last update time. Unix timestamp in seconds.',
          example: 1451431341,
          type: 'integer',
        },
      },
    },
  ],
} as const;

export const LeadFormStatusSchema = {
  type: 'string',
  description: 'Status of the lead form',
  example: 'DRAFT',
  enum: ['DRAFT', 'ACTIVE'],
} as const;

export const LeadFormArrayResponseSchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      items: {
        type: 'object',
        properties: {
          data: {
            $ref: '#/components/schemas/LeadFormResponse',
          },
          exceptions: {
            type: 'array',
            items: {
              $ref: '#/components/schemas/Exception',
            },
          },
        },
      },
    },
  },
} as const;

export const LeadFormCreateRequestSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/LeadFormCommon',
    },
    {
      required: ['name', 'questions', 'privacy_policy_link', 'has_accepted_terms', 'completion_message'],
    },
  ],
} as const;

export const LeadFormUpdateRequestSchema = {
  type: 'object',
  allOf: [
    {
      type: 'object',
    },
    {
      $ref: '#/components/schemas/LeadFormCommon',
    },
    {
      required: ['id'],
      properties: {
        id: {
          title: 'id',
          description: 'The ID of this lead form to be updated',
          type: 'string',
          example: '7765300871171',
          pattern: '^\\d+$',
        },
      },
    },
  ],
} as const;

export const LeadsExportCreateRequestSchema = {
  type: 'object',
  properties: {
    start_date: {
      description: 'Export leads collected on and after start date (UTC). Format: YYYY-MM-DD',
      type: 'string',
      pattern: '^(\\d{4})-(\\d{2})-(\\d{2})$',
      example: '2020-12-20',
    },
    end_date: {
      description: 'Export leads collected on and before end date (UTC). Format: YYYY-MM-DD',
      type: 'string',
      pattern: '^(\\d{4})-(\\d{2})-(\\d{2})$',
      example: '2020-12-20',
    },
    ad_id: {
      description: 'ID for the ad collecting leads',
      type: 'string',
      pattern: '^\\d+$',
      example: '687201361754',
    },
  },
  required: ['start_date', 'end_date', 'ad_id'],
} as const;

export const LeadsExportCreateResponseSchema = {
  type: 'object',
  properties: {
    leads_export_id: {
      example: '123456789012',
      description: 'ID for the leads export job',
      type: 'string',
      pattern: '^\\d+$',
    },
  },
} as const;

export const LeadsExportStatusSchema = {
  type: 'string',
  description: 'Status of a leads export job',
  example: 'IN_PROGRESS',
  enum: ['IN_PROGRESS', 'FINISHED', 'FAILED'],
} as const;

export const LeadsExportResponseDataSchema = {
  type: 'object',
  properties: {
    export_status: {
      $ref: '#/components/schemas/LeadsExportStatus',
    },
    download_url: {
      type: 'string',
      nullable: true,
    },
  },
} as const;

export const LinkedBusinessSchema = {
  title: 'LinkedBusiness',
  type: 'object',
  properties: {
    username: {
      title: 'username',
      type: 'string',
      description: 'Username',
      example: 'username',
    },
    image_small_url: {
      title: 'image_small_url',
      type: 'string',
      description: 'image_small_url',
      example: 'https://www.example.com/dj23454f53dfk2324.jpg',
    },
    image_medium_url: {
      title: 'image_medium_url',
      type: 'string',
      description: 'image_medium_url',
      example: 'https://www.example.com/dj23454f53dfk2324.jpg',
    },
    image_large_url: {
      title: 'image_large_url',
      type: 'string',
      description: 'image_large_url',
      example: 'https://www.example.com/dj23454f53dfk2324.jpg',
    },
    image_xlarge_url: {
      title: 'image_xlarge_url',
      type: 'string',
      description: 'image_xlarge_url',
      example: 'https://www.example.com/dj23454f53dfk2324.jpg',
    },
  },
} as const;

export const MemberBusinessRoleSchema = {
  type: 'string',
  description: `The access level a member/partner has to the business. Values are case-sensitive.
<br> - EMPLOYEE: Can only view and access ad accounts you assign to them.
They cannot see details about other employees, external partners or other ad accounts.
<br> - BIZ_ADMIN: Have full control of roles and can add employees, external partners as well as grant ad account access.`,
  example: 'BIZ_ADMIN',
  enum: ['EMPLOYEE', 'BIZ_ADMIN'],
} as const;

export const MatchTypeSchema = {
  type: 'string',
  description: 'Keyword match type',
  example: 'BROAD',
  enum: ['BROAD', 'PHRASE', 'EXACT', 'EXACT_NEGATIVE', 'PHRASE_NEGATIVE'],
} as const;

export const MatchTypeResponseSchema = {
  type: 'string',
  description: 'Keyword match type',
  nullable: true,
  example: 'BROAD',
  enum: ['BROAD', 'PHRASE', 'EXACT', 'EXACT_NEGATIVE', 'PHRASE_NEGATIVE', null],
} as const;

export const MaxPriceFilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    MAX_PRICE: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupPricingCriteria',
    },
  },
  required: ['MAX_PRICE'],
} as const;

export const MediaUploadSchema = {
  type: 'object',
  title: 'Media upload',
  description: 'Media upload that has been registered but not uploaded/processed yet.',
  allOf: [
    {
      type: 'object',
      readOnly: true,
      properties: {
        media_id: {
          type: 'string',
          description:
            'Unique identifier for this media upload. Used to track status and for attaching during Pin creation.',
        },
        media_type: {
          allOf: [
            {
              $ref: '#/components/schemas/MediaUploadType',
            },
          ],
          type: 'string',
          example: 'video',
        },
        upload_url: {
          type: 'string',
          description: 'The URL where you will POST your media file.',
          example: 'https://pinterest-media-upload.s3-accelerate.amazonaws.com/',
        },
        upload_parameters: {
          type: 'object',
          description:
            'The list of parameter key/value pairs you will need to send with your POST request to upload your media file.',
          properties: {
            'x-amz-date': {
              type: 'string',
            },
            'x-amz-signature': {
              type: 'string',
            },
            'x-amz-security-token': {
              type: 'string',
            },
            'x-amz-algorithm': {
              type: 'string',
            },
            key: {
              type: 'string',
            },
            policy: {
              type: 'string',
            },
            'x-amz-credential': {
              type: 'string',
            },
            'Content-Type': {
              type: 'string',
              example: 'multipart/form-data',
            },
          },
        },
      },
    },
  ],
  example: {
    media_id: '12345',
    media_type: 'video',
    upload_url: 'https://pinterest-media-upload.s3-accelerate.amazonaws.com/',
    upload_parameters: {
      'x-amz-data': '20220127T185143Z',
      'x-amz-signature': 'fcd6309a6aaee213348666a72abed8b44552a43acb6b340e8e1b288d21a5fe92',
      key: 'uploads/11/aa/22/3:video:203014033110991560:5212123920968240771',
      policy: 'eyJleHBpcmF0aW9uIjoiMj..==',
      'x-amz-credential': 'ASIA6QZJ64OPIKV7FRVX/20220127/us-east-1/s3/aws4_request',
      'x-amz-security-token': 'IQoJb3JpZ2luX2VjEJr...==',
      'x-amz-algorithm': 'AWS4-HMAC-SHA256',
      'Content-Type': 'multipart/form-data',
    },
  },
} as const;

export const MediaUploadDetailsSchema = {
  title: 'Media upload details',
  description: 'Media upload details',
  type: 'object',
  properties: {
    media_id: {
      type: 'string',
      pattern: '^\\d+$',
      readOnly: true,
    },
    media_type: {
      allOf: [
        {
          $ref: '#/components/schemas/MediaUploadType',
        },
      ],
      type: 'string',
      readOnly: true,
    },
    status: {
      allOf: [
        {
          $ref: '#/components/schemas/MediaUploadStatus',
        },
      ],
      type: 'string',
      readOnly: true,
    },
  },
  example: {
    media_id: '12345',
    media_type: 'video',
    status: 'succeeded',
  },
} as const;

export const MediaUploadRequestSchema = {
  title: 'Media upload request',
  description: 'Media upload request',
  type: 'object',
  properties: {
    media_type: {
      allOf: [
        {
          $ref: '#/components/schemas/MediaUploadType',
        },
      ],
      type: 'string',
      writeOnly: true,
    },
  },
  required: ['media_type'],
  example: {
    media_type: 'video',
  },
} as const;

export const MediaUploadStatusSchema = {
  description: 'Media upload status',
  type: 'string',
  enum: ['registered', 'processing', 'succeeded', 'failed'],
} as const;

export const MediaUploadTypeSchema = {
  type: 'string',
  enum: ['video'],
} as const;

export const MembersToDeleteBodySchema = {
  required: ['members'],
  properties: {
    members: {
      items: {
        required: ['member_id', 'business_role'],
        properties: {
          member_id: {
            type: 'string',
            description: 'Unique identifier of the member',
            maxLength: 25,
            example: '140943737684417',
            pattern: '^\\d+$',
          },
          business_role: {
            $ref: '#/components/schemas/BusinessRoleForMembers',
          },
        },
        type: 'object',
      },
      type: 'array',
      minItems: 1,
      maxItems: 50,
    },
  },
  type: 'object',
} as const;

export const MetricsSchema = {
  description: 'The metric name and daily value for each requested metric',
  type: 'object',
  additionalProperties: {
    type: 'number',
  },
  example: {
    CLOSEUP: 1,
    CLOSEUP_RATE: 0,
    ENGAGEMENT: 1,
    ENGAGEMENT_RATE: 0,
    IMPRESSION: 240,
    OUTBOUND_CLICK: 20,
    OUTBOUND_CLICK_RATE: 0.08,
    PIN_CLICK: 37,
    PIN_CLICK_RATE: 0.15,
    QUARTILE_95_PERCENT_VIEW: 8,
    SAVE: 20,
    SAVE_RATE: 0.18,
    VIDEO_10S_VIEW: 2,
    VIDEO_AVG_WATCH_TIME: 2507.75,
    VIDEO_MRC_VIEW: 20,
    VIDEO_START: 29,
    VIDEO_V50_WATCH_TIME: 10031,
  },
} as const;

export const MetricsReportingLevelSchema = {
  type: 'string',
  description: 'Level of the reporting request',
  example: 'CAMPAIGN',
  enum: [
    'ADVERTISER',
    'ADVERTISER_TARGETING',
    'CAMPAIGN',
    'CAMPAIGN_TARGETING',
    'AD_GROUP',
    'AD_GROUP_TARGETING',
    'PIN_PROMOTION',
    'PIN_PROMOTION_TARGETING',
    'KEYWORD',
    'PRODUCT_GROUP',
    'PRODUCT_GROUP_TARGETING',
    'PRODUCT_ITEM',
    'PRODUCT_ITEM_TARGETING',
  ],
} as const;

export const MetricsResponseSchema = {
  properties: {
    data: {
      items: {
        type: 'object',
      },
      type: 'array',
      example: [
        {
          targeting_type: 'KEYWORD',
          targeting_value: 'christmas decor ideas',
          metrics: {
            AD_GROUP_ID: 2680067996745,
            DATE: '2022-04-26',
            SPEND_IN_DOLLAR: 240,
          },
        },
        {
          targeting_type: 'APPTYPE',
          targeting_value: 'iphone',
          metrics: {
            AD_GROUP_ID: 2680067996745,
            DATE: '2022-04-26',
            SPEND_IN_DOLLAR: 240,
          },
        },
        {
          targeting_type: 'APPTYPE',
          targeting_value: 'ipad',
          metrics: {
            AD_GROUP_ID: 2680067996745,
            DATE: '2022-04-26',
            SPEND_IN_DOLLAR: 240,
          },
        },
        {
          targeting_type: 'APPTYPE',
          targeting_value: 'web',
          metrics: {
            AD_GROUP_ID: 2680067996745,
            DATE: '2022-04-26',
            SPEND_IN_DOLLAR: 240,
          },
        },
        {
          targeting_type: 'APPTYPE',
          targeting_value: 'web_mobile',
          metrics: {
            AD_GROUP_ID: 2680067996745,
            DATE: '2022-04-26',
            SPEND_IN_DOLLAR: 240,
          },
        },
        {
          targeting_type: 'APPTYPE',
          targeting_value: 'android_mobile',
          metrics: {
            AD_GROUP_ID: 2680067996745,
            DATE: '2022-04-26',
            SPEND_IN_DOLLAR: 240,
          },
        },
        {
          targeting_type: 'APPTYPE',
          targeting_value: 'android_tablet',
          metrics: {
            AD_GROUP_ID: 2680067996745,
            DATE: '2022-04-26',
            SPEND_IN_DOLLAR: 240,
          },
        },
        {
          targeting_type: 'GENDER',
          targeting_value: 'female',
          metrics: {
            AD_GROUP_ID: 2680067996745,
            DATE: '2022-04-26',
            SPEND_IN_DOLLAR: 240,
          },
        },
        {
          targeting_type: 'LOCATION',
          targeting_value: 500,
          metrics: {
            AD_GROUP_ID: 2680067996745,
            DATE: '2022-04-26',
            SPEND_IN_DOLLAR: 240,
          },
        },
        {
          targeting_type: 'PLACEMENT',
          targeting_value: 'SEARCH',
          metrics: {
            AD_GROUP_ID: 2680067996745,
            DATE: '2022-04-26',
            SPEND_IN_DOLLAR: 240,
          },
        },
        {
          targeting_type: 'COUNTRY',
          targeting_value: 'US',
          metrics: {
            AD_GROUP_ID: 2680067996745,
            DATE: '2022-04-26',
            SPEND_IN_DOLLAR: 240,
          },
        },
        {
          targeting_type: 'TARGETED_INTEREST',
          targeting_value: 'Food and Drinks',
          metrics: {
            AD_GROUP_ID: 2680067996745,
            DATE: '2022-04-26',
            SPEND_IN_DOLLAR: 240,
          },
        },
        {
          targeting_type: 'PINNER_INTEREST',
          targeting_value: 'Chocolate Cookies',
          metrics: {
            AD_GROUP_ID: 2680067996745,
            DATE: '2022-04-26',
            SPEND_IN_DOLLAR: 240,
          },
        },
        {
          targeting_type: 'AUDIENCE_INCLUDE',
          targeting_value: 254261234567,
          metrics: {
            AD_GROUP_ID: 2680067996745,
            DATE: '2022-04-26',
            SPEND_IN_DOLLAR: 240,
          },
        },
        {
          targeting_type: 'GEO',
          targeting_value: 'US:94102',
          metrics: {
            AD_GROUP_ID: 2680067996745,
            DATE: '2022-04-26',
            SPEND_IN_DOLLAR: 240,
          },
        },
        {
          targeting_type: 'AGE_BUCKET',
          targeting_value: '45-49',
          metrics: {
            AD_GROUP_ID: 2680067996745,
            DATE: '2022-04-26',
            SPEND_IN_DOLLAR: 240,
          },
        },
        {
          targeting_type: 'REGION',
          targeting_value: 'US-CA',
          metrics: {
            AD_GROUP_ID: 2680067996745,
            DATE: '2022-04-26',
            SPEND_IN_DOLLAR: 240,
          },
        },
      ],
    },
  },
  type: 'object',
} as const;

export const PriceFilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    PRICE: {
      type: 'object',
      additionalProperties: false,
      title: 'catalogs_product_group_pricing_currency_criteria',
      properties: {
        operator: {
          type: 'string',
          enum: ['GREATER_THAN', 'GREATER_THAN_OR_EQUALS', 'LESS_THAN', 'LESS_THAN_OR_EQUALS'],
        },
        value: {
          type: 'number',
          minimum: 0,
        },
        currency: {
          $ref: '#/components/schemas/NonNullableCatalogsCurrency',
        },
        negated: {
          type: 'boolean',
          default: false,
        },
      },
      required: ['value', 'operator', 'currency'],
    },
  },
  required: ['PRICE'],
} as const;

export const MinPriceFilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    MIN_PRICE: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupPricingCriteria',
    },
  },
  required: ['MIN_PRICE'],
} as const;

export const MMMReportingColumnSchema = {
  type: 'string',
  description: 'Marketing Mix Modeling (MMM) Reporting Columns',
  example: 'SPEND_IN_DOLLAR',
  enum: [
    'SPEND_IN_DOLLAR',
    'SPEND_IN_MICRO_DOLLAR',
    'ECPC_IN_DOLLAR',
    'ECTR',
    'CAMPAIGN_NAME',
    'TOTAL_ENGAGEMENT',
    'EENGAGEMENT_RATE',
    'ECPM_IN_DOLLAR',
    'CAMPAIGN_ID',
    'ADVERTISER_ID',
    'AD_GROUP_ID',
    'AD_GROUP_NAME',
    'CLICKTHROUGH_1',
    'IMPRESSION_1',
    'CLICKTHROUGH_2',
    'IMPRESSION_2',
    'TOTAL_CLICKTHROUGH',
    'TOTAL_IMPRESSION',
    'ADVERTISER_NAME',
    'SPEND_ORDER_LINE_PAID_TYPE',
  ],
} as const;

export const MMMReportingTargetingTypeSchema = {
  type: 'string',
  description: 'Ad targeting types for MMM report',
  example: 'APPTYPE',
  enum: ['APPTYPE', 'COUNTRY', 'CREATIVE_TYPE', 'GENDER', 'LOCATION'],
} as const;

export const NonNullableCatalogsCurrencySchema = {
  type: 'string',
  description: 'Currency Codes from ISO 4217.',
  nullable: false,
  example: 'USD',
  enum: [
    'AED',
    'AFN',
    'ALL',
    'AMD',
    'ANG',
    'AOA',
    'ARS',
    'AUD',
    'AWG',
    'AZN',
    'BAM',
    'BBD',
    'BDT',
    'BGN',
    'BHD',
    'BIF',
    'BMD',
    'BND',
    'BOB',
    'BRL',
    'BSD',
    'BTN',
    'BWP',
    'BYN',
    'BYR',
    'BZD',
    'CAD',
    'CDF',
    'CHF',
    'CLP',
    'CNY',
    'COP',
    'CRC',
    'CUC',
    'CUP',
    'CVE',
    'CZK',
    'DJF',
    'DKK',
    'DOP',
    'DZD',
    'EGP',
    'ERN',
    'ETB',
    'EUR',
    'FJD',
    'FKP',
    'GBP',
    'GEL',
    'GGP',
    'GHS',
    'GIP',
    'GMD',
    'GNF',
    'GTQ',
    'GYD',
    'HKD',
    'HNL',
    'HRK',
    'HTG',
    'HUF',
    'IDR',
    'ILS',
    'IMP',
    'INR',
    'IQD',
    'IRR',
    'ISK',
    'JEP',
    'JMD',
    'JOD',
    'JPY',
    'KES',
    'KGS',
    'KHR',
    'KMF',
    'KPW',
    'KRW',
    'KWD',
    'KYD',
    'KZT',
    'LAK',
    'LBP',
    'LKR',
    'LRD',
    'LSL',
    'LYD',
    'MAD',
    'MDL',
    'MGA',
    'MKD',
    'MMK',
    'MNT',
    'MOP',
    'MRO',
    'MUR',
    'MVR',
    'MWK',
    'MXN',
    'MYR',
    'MZN',
    'NAD',
    'NGN',
    'NIO',
    'NOK',
    'NPR',
    'NZD',
    'OMR',
    'PAB',
    'PEN',
    'PGK',
    'PHP',
    'PKR',
    'PLN',
    'PYG',
    'QAR',
    'RON',
    'RSD',
    'RUB',
    'RWF',
    'SAR',
    'SBD',
    'SCR',
    'SDG',
    'SEK',
    'SGD',
    'SHP',
    'SLL',
    'SOS',
    'SPL',
    'SRD',
    'STD',
    'SVC',
    'SYP',
    'SZL',
    'THB',
    'TJS',
    'TMT',
    'TND',
    'TOP',
    'TRY',
    'TTD',
    'TVD',
    'TWD',
    'TZS',
    'UAH',
    'UGX',
    'USD',
    'UYU',
    'UZS',
    'VEF',
    'VND',
    'VUV',
    'WST',
    'XAF',
    'XCD',
    'XDR',
    'XOF',
    'XPF',
    'YER',
    'ZAR',
    'ZMW',
    'ZWD',
  ],
} as const;

export const NonNullableProductAvailabilityTypeSchema = {
  description: 'Product availability.',
  nullable: false,
  type: 'string',
  enum: ['IN_STOCK', 'OUT_OF_STOCK', 'PREORDER'],
} as const;

export const NullableCatalogsItemFieldTypeSchema = {
  description: 'Product item fields',
  example: 'TITLE',
  type: 'string',
  nullable: true,
  enum: [
    'ITEM_ID',
    'ITEM_GROUP_ID',
    'TITLE',
    'DESCRIPTION',
    'ITEM_LINK',
    'ORGANIC_LINK',
    'IMAGE_LINK',
    'ADWORDS_REDIRECT_LINK',
    'AD_LINK',
    'SIZE',
    'GOOGLE_PRODUCT_CATEGORY',
    'PRODUCT_CATEGORY',
    'CONDITION',
    'AVAILABILITY',
    'GENDER',
    'AGE_GROUP',
    'SIZE_TYPE',
    'SIZE_SYSTEM',
    'ADULT',
    'SHIPPING',
    'SHIPPING_WEIGHT',
    'TAX',
    'MULTIPACK',
    'ADDITIONAL_IMAGE_LINK',
    'PRICE',
    'SALE_PRICE',
    'IS_BUNDLE',
    'EXPIRATION_DATE',
    'SALE_PRICE_EFFECTIVE_DATE',
    'AVAILABILITY_DATE',
    'WEIGHT_UNIT',
    'PRODUCT_TYPE',
    'CUSTOM_LABEL_0',
    'CUSTOM_LABEL_1',
    'CUSTOM_LABEL_2',
    'CUSTOM_LABEL_3',
    'CUSTOM_LABEL_4',
    'MATERIAL',
    'PATTERN',
    'COLOR',
    'BRAND',
    'GTIN',
    'MPN',
    'IOS_DEEP_LINK',
    'ANDROID_DEEP_LINK',
    'FREE_SHIPPING_LABEL',
    'FREE_SHIPPING_LIMIT',
    'AVG_REVIEW_RATING',
    'NUM_RATINGS',
    'NUM_REVIEWS',
    'ALT_TEXT',
    'VARIANT_NAMES',
    'VARIANT_VALUES',
    'MIN_AD_PRICE',
    'SHIPPING_WIDTH',
    'SHIPPING_HEIGHT',
    null,
  ],
} as const;

export const NullableCurrencySchema = {
  type: 'string',
  description: 'Currency Codes from ISO 4217.',
  example: 'USD',
  nullable: true,
  enum: [
    'AED',
    'AFN',
    'ALL',
    'AMD',
    'ANG',
    'AOA',
    'ARS',
    'AUD',
    'AWG',
    'AZN',
    'BAM',
    'BBD',
    'BDT',
    'BGN',
    'BHD',
    'BIF',
    'BMD',
    'BND',
    'BOB',
    'BRL',
    'BSD',
    'BTN',
    'BWP',
    'BYN',
    'BYR',
    'BZD',
    'CAD',
    'CDF',
    'CHF',
    'CLP',
    'CNY',
    'COP',
    'CRC',
    'CUC',
    'CUP',
    'CVE',
    'CZK',
    'DJF',
    'DKK',
    'DOP',
    'DZD',
    'EGP',
    'ERN',
    'ETB',
    'EUR',
    'FJD',
    'FKP',
    'GBP',
    'GEL',
    'GGP',
    'GHS',
    'GIP',
    'GMD',
    'GNF',
    'GTQ',
    'GYD',
    'HKD',
    'HNL',
    'HRK',
    'HTG',
    'HUF',
    'IDR',
    'ILS',
    'IMP',
    'INR',
    'IQD',
    'IRR',
    'ISK',
    'JEP',
    'JMD',
    'JOD',
    'JPY',
    'KES',
    'KGS',
    'KHR',
    'KMF',
    'KPW',
    'KRW',
    'KWD',
    'KYD',
    'KZT',
    'LAK',
    'LBP',
    'LKR',
    'LRD',
    'LSL',
    'LYD',
    'MAD',
    'MDL',
    'MGA',
    'MKD',
    'MMK',
    'MNT',
    'MOP',
    'MRO',
    'MUR',
    'MVR',
    'MWK',
    'MXN',
    'MYR',
    'MZN',
    'NAD',
    'NGN',
    'NIO',
    'NOK',
    'NPR',
    'NZD',
    'OMR',
    'PAB',
    'PEN',
    'PGK',
    'PHP',
    'PKR',
    'PLN',
    'PYG',
    'QAR',
    'RON',
    'RSD',
    'RUB',
    'RWF',
    'SAR',
    'SBD',
    'SCR',
    'SDG',
    'SEK',
    'SGD',
    'SHP',
    'SLL',
    'SOS',
    'SPL',
    'SRD',
    'STD',
    'SVC',
    'SYP',
    'SZL',
    'THB',
    'TJS',
    'TMT',
    'TND',
    'TOP',
    'TRY',
    'TTD',
    'TVD',
    'TWD',
    'TZS',
    'UAH',
    'UGX',
    'USD',
    'UYU',
    'UZS',
    'VEF',
    'VND',
    'VUV',
    'WST',
    'XAF',
    'XCD',
    'XDR',
    'XOF',
    'XPF',
    'YER',
    'ZAR',
    'ZMW',
    'ZWD',
    null,
  ],
} as const;

export const OauthAccessTokenRequestSchema = {
  title: 'OAuth access token request',
  description: 'Describes the valid schema for possible OAuth access token requests.',
  type: 'object',
  discriminator: {
    propertyName: 'grant_type',
    mapping: {
      authorization_code: '#/components/schemas/OauthAccessTokenRequestCode',
      refresh_token: '#/components/schemas/OauthAccessTokenRequestRefresh',
      client_credentials: '#/components/schemas/OauthAccessTokenRequestClientCredentials',
    },
  },
  properties: {
    grant_type: {
      type: 'string',
      enum: ['authorization_code', 'refresh_token', 'client_credentials'],
    },
  },
  required: ['grant_type'],
} as const;

export const OauthAccessTokenRequestCodeSchema = {
  type: 'object',
  title: 'authorization_code',
  description: 'A request to exchange an authorization code for an access token.',
  allOf: [
    {
      type: 'object',
      properties: {
        code: {
          type: 'string',
        },
        redirect_uri: {
          type: 'string',
        },
      },
      required: ['code', 'redirect_uri'],
    },
  ],
  properties: {
    grant_type: {
      type: 'string',
      enum: ['authorization_code', 'refresh_token', 'client_credentials'],
    },
  },
  required: ['grant_type'],
} as const;

export const OauthAccessTokenRequestRefreshSchema = {
  title: 'refresh_token',
  description: 'A request to exchange a refresh token for a new access token.',
  type: 'object',
  allOf: [
    {
      type: 'object',
      properties: {
        refresh_token: {
          type: 'string',
        },
        scope: {
          type: 'string',
        },
        refresh_on: {
          description:
            'Setting this field to <code>true</code> will add a new refresh token to your 200 response, as well as the refresh_token_expires_in and refresh_token_expires_at fields. To see the structure of this payload, set the 200 response_type to "everlasting_refresh".',
          type: 'boolean',
        },
      },
      required: ['refresh_token'],
    },
  ],
  properties: {
    grant_type: {
      type: 'string',
      enum: ['authorization_code', 'refresh_token', 'client_credentials'],
    },
  },
  required: ['grant_type'],
} as const;

export const OauthAccessTokenRequestClientCredentialsSchema = {
  title: 'client_credentials',
  description: 'A request to receive a client token.',
  type: 'object',
  allOf: [
    {
      type: 'object',
      properties: {
        scope: {
          type: 'string',
        },
      },
      required: ['scope'],
    },
  ],
  properties: {
    grant_type: {
      type: 'string',
      enum: ['authorization_code', 'refresh_token', 'client_credentials'],
    },
  },
  required: ['grant_type'],
} as const;

export const OauthAccessTokenResponseSchema = {
  title: 'OAuth access token response',
  description: 'A successful OAuth access token response.',
  type: 'object',
  discriminator: {
    propertyName: 'response_type',
    mapping: {
      authorization_code: '#/components/schemas/OauthAccessTokenResponseCode',
      refresh_token: '#/components/schemas/OauthAccessTokenResponseRefresh',
      client_credentials: '#/components/schemas/OauthAccessTokenResponseClientCredentials',
      integration_refresh: '#/components/schemas/OauthAccessTokenResponseIntegrationRefresh',
      everlasting_refresh: '#/components/schemas/OauthAccessTokenResponseEverlastingRefresh',
    },
  },
  properties: {
    response_type: {
      type: 'string',
      enum: ['authorization_code', 'refresh_token', 'client_credentials'],
    },
    access_token: {
      type: 'string',
    },
    token_type: {
      type: 'string',
      default: 'bearer',
    },
    expires_in: {
      type: 'integer',
    },
    scope: {
      type: 'string',
    },
  },
  required: ['access_token', 'token_type', 'expires_in', 'scope'],
} as const;

export const OauthAccessTokenResponseCodeSchema = {
  title: 'OAuth access token response',
  description: 'A successful OAuth access token response for the authorization code flow.',
  type: 'object',
  allOf: [
    {
      type: 'object',
      properties: {
        refresh_token: {
          type: 'string',
        },
        refresh_token_expires_in: {
          type: 'integer',
        },
      },
      required: ['refresh_token', 'refresh_token_expires_in'],
    },
  ],
  properties: {
    response_type: {
      type: 'string',
      enum: ['authorization_code', 'refresh_token', 'client_credentials'],
    },
    access_token: {
      type: 'string',
    },
    token_type: {
      type: 'string',
      default: 'bearer',
    },
    expires_in: {
      type: 'integer',
    },
    scope: {
      type: 'string',
    },
  },
  required: ['access_token', 'token_type', 'expires_in', 'scope'],
} as const;

export const OauthAccessTokenResponseEverlastingRefreshSchema = {
  title: 'OAuth access token response',
  description:
    'A successful OAuth access token response for the refresh token flow, with an added everlasting refresh token.',
  type: 'object',
  allOf: [
    {
      type: 'object',
      properties: {
        refresh_token: {
          type: 'string',
        },
        refresh_token_expires_in: {
          type: 'integer',
        },
        refresh_token_expires_at: {
          type: 'integer',
        },
      },
      required: ['refresh_token', 'refresh_token_expires_in', 'refresh_token_expires_at'],
    },
  ],
  properties: {
    response_type: {
      type: 'string',
      enum: ['authorization_code', 'refresh_token', 'client_credentials'],
    },
    access_token: {
      type: 'string',
    },
    token_type: {
      type: 'string',
      default: 'bearer',
    },
    expires_in: {
      type: 'integer',
    },
    scope: {
      type: 'string',
    },
  },
  required: ['access_token', 'token_type', 'expires_in', 'scope'],
} as const;

export const OauthAccessTokenResponseIntegrationRefreshSchema = {
  title: 'OAuth access token response',
  description: 'A successful OAuth access token response for the refresh token flow, with an added refresh token.',
  type: 'object',
  allOf: [
    {
      type: 'object',
      properties: {
        refresh_token: {
          type: 'string',
        },
        refresh_token_expires_in: {
          type: 'integer',
        },
      },
      required: ['refresh_token', 'refresh_token_expires_in'],
    },
  ],
  properties: {
    response_type: {
      type: 'string',
      enum: ['authorization_code', 'refresh_token', 'client_credentials'],
    },
    access_token: {
      type: 'string',
    },
    token_type: {
      type: 'string',
      default: 'bearer',
    },
    expires_in: {
      type: 'integer',
    },
    scope: {
      type: 'string',
    },
  },
  required: ['access_token', 'token_type', 'expires_in', 'scope'],
} as const;

export const OauthAccessTokenResponseRefreshSchema = {
  title: 'OAuth access token response',
  description: 'A successful OAuth access token response for the refresh token flow.',
  type: 'object',
  allOf: [
    {
      type: 'object',
      properties: {
        response_type: {
          type: 'string',
          enum: ['authorization_code', 'refresh_token', 'client_credentials'],
        },
        access_token: {
          type: 'string',
        },
        token_type: {
          type: 'string',
          default: 'bearer',
        },
        expires_in: {
          type: 'integer',
        },
        scope: {
          type: 'string',
        },
      },
      required: ['access_token', 'token_type', 'expires_in', 'scope'],
    },
  ],
} as const;

export const OauthAccessTokenResponseClientCredentialsSchema = {
  title: 'OAuth client token response',
  description: 'A successful OAuth client token response for the client token flow.',
  type: 'object',
  properties: {
    response_type: {
      type: 'string',
      enum: ['authorization_code', 'refresh_token', 'client_credentials'],
    },
    access_token: {
      type: 'string',
    },
    token_type: {
      type: 'string',
      default: 'bearer',
    },
    expires_in: {
      type: 'integer',
    },
    scope: {
      type: 'string',
    },
  },
  required: ['access_token', 'token_type', 'expires_in', 'scope'],
} as const;

export const ObjectiveTypeSchema = {
  type: 'string',
  description:
    'Campaign objective type. If set as one of ["AWARENESS", "CONSIDERATION", "WEB_CONVERSION", "CATALOG_SALES", "VIDEO_COMPLETION"] the campaign is considered as a Campaign Budget Optimization (CBO) campaign, meaning budget needs to be set at the campaign level rather than at the ad group level. ["WEB_SESSIONS"] is DEPRECATED. For update, only draft campaigns may update objective type.',
  enum: [
    'AWARENESS',
    'CONSIDERATION',
    'VIDEO_VIEW',
    'WEB_CONVERSION',
    'CATALOG_SALES',
    'WEB_SESSIONS',
    'VIDEO_COMPLETION',
  ],
} as const;

export const OptimizationGoalMetadataSchema = {
  type: 'object',
  properties: {
    conversion_tag_v3_goal_metadata: {
      properties: {
        attribution_windows: {
          properties: {
            click_window_days: {
              type: 'integer',
            },
            engagement_window_days: {
              type: 'integer',
            },
            view_window_days: {
              type: 'integer',
            },
          },
          type: 'object',
        },
        conversion_event: {
          type: 'string',
          enum: [
            'PAGE_VISIT',
            'SIGNUP',
            'CHECKOUT',
            'CUSTOM',
            'VIEW_CATEGORY',
            'SEARCH',
            'ADD_TO_CART',
            'WATCH_VIDEO',
            'LEAD',
            'APP_INSTALL',
          ],
        },
        conversion_tag_id: {
          type: 'string',
          pattern: '^[0-9]+$',
        },
        cpa_goal_value_in_micro_currency: {
          type: 'string',
          pattern: '^[0-9]+$',
        },
        is_roas_optimized: {
          description: 'ROAS optimization is not supported',
          nullable: true,
          title: 'is_roas_optimized',
          type: 'boolean',
        },
        learning_mode_type: {
          description: 'Conversion learning model type',
          enum: ['NOT_ACTIVE', 'ACTIVE', null],
          example: 'ACTIVE',
          nullable: true,
          title: 'ConversionLearningModeType',
          type: 'string',
        },
      },
      type: 'object',
    },
    frequency_goal_metadata: {
      properties: {
        frequency: {
          type: 'integer',
        },
        timerange: {
          type: 'string',
          description: 'User entity counts time range',
          example: 'DAY',
          enum: ['THIRTY_DAY', 'DAY', 'SEVEN_DAY', 'TWENTY_MINUTE', 'TEN_MINUTE', 'TWENTY_FOUR_HOUR'],
        },
      },
      type: 'object',
    },
    scrollup_goal_metadata: {
      properties: {
        scrollup_goal_value_in_micro_currency: {
          pattern: '^[0-9]+$',
          type: 'string',
          nullable: true,
        },
      },
      type: 'object',
    },
  },
} as const;

export const OrderLineSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/OrderLines',
    },
    {
      type: 'object',
      properties: {
        campaign_ids: {
          description: 'Associated List of campaign IDs.',
          example: ['626735565838'],
          items: {
            type: 'string',
          },
          title: 'campaign_ids',
          type: 'array',
        },
      },
      required: ['campaign_ids'],
    },
  ],
  title: 'OrderLine',
} as const;

export const OrderLineErrorSchema = {
  properties: {
    data: {
      $ref: '#/components/schemas/OrderLine',
      type: 'object',
    },
    error_messages: {
      items: {
        type: 'string',
      },
      title: 'error_messages',
      type: 'array',
    },
  },
  title: 'OrderLineError',
  type: 'object',
} as const;

export const OrderLinePaidTypeSchema = {
  description: 'Order Line Paid Type',
  enum: ['PAID', 'BONUS', 'MAKE_GOOD', 'TEST', null],
  example: 'PAID',
  title: 'OrderLinePaidType',
  type: 'string',
  nullable: true,
} as const;

export const OrderLineResponseSchema = {
  properties: {
    errors: {
      description: 'Error list if update(s) fail.',
      items: {
        $ref: '#/components/schemas/OrderLineError',
        type: 'object',
      },
      title: 'errors',
      type: 'array',
    },
    order_line: {
      description: 'Order Line object array.',
      items: {
        $ref: '#/components/schemas/OrderLine',
        type: 'object',
      },
      title: 'order_line',
      type: 'array',
    },
  },
  title: 'OrderLineResponse',
  type: 'object',
} as const;

export const OrderLineSingleResponseSchema = {
  type: 'object',
  properties: {
    data: {
      $ref: '#/components/schemas/OrderLineResponse',
      type: 'object',
    },
  },
  title: 'OrderLineSingleResponse',
} as const;

export const OrderLineStatusSchema = {
  description: 'Order Line Status',
  enum: ['ACTIVE', 'PAUSED', 'DELETED'],
  example: 'ACTIVE',
  title: 'OrderLineStatus',
  type: 'string',
} as const;

export const OrderLinesSchema = {
  type: 'object',
  title: 'OrderLines',
  description: 'Order Line',
  properties: {
    id: {
      description: 'Order line ID.',
      example: '2680059592705',
      pattern: '^\\d+$',
      title: 'id',
      type: 'string',
    },
    type: {
      description: 'Always "orderline".',
      example: 'orderline',
      title: 'type',
      type: 'string',
    },
    ad_account_id: {
      description: 'Ad account ID.',
      example: '549755885175',
      title: 'ad_account_id',
      type: 'string',
    },
    purchase_order_id: {
      description: 'Purchase order ID.',
      example: 'PO12345',
      title: 'purchase_order_id',
      type: 'string',
      nullable: true,
    },
    start_time: {
      description: 'Start time. Unix timestamp.',
      example: 1452208622,
      title: 'start_time',
      type: 'number',
    },
    end_time: {
      description: 'End time. Unix timestamp.',
      example: 1461269616,
      title: 'end_time',
      type: 'number',
      nullable: true,
    },
    budget: {
      description: 'Order line budget in micro currency.',
      example: 5000000,
      title: 'budget',
      type: 'number',
      nullable: true,
    },
    paid_budget: {
      description: 'Order line paid budget in micro currency.',
      example: 5000000,
      title: 'paid_budget',
      type: 'number',
      nullable: true,
    },
    status: {
      allOf: [
        {
          $ref: '#/components/schemas/OrderLineStatus',
        },
      ],
      description: 'Order line status.',
      example: 'ACTIVE',
      type: 'string',
      title: 'status',
    },
    name: {
      description: 'Order line name.',
      example: 'Order Line Name 1',
      title: 'name',
      type: 'string',
      nullable: true,
    },
    paid_type: {
      allOf: [
        {
          $ref: '#/components/schemas/OrderLinePaidType',
        },
      ],
      type: 'string',
      description: 'Order line paid type.',
      example: 'PAID',
      title: 'paid_type',
      nullable: true,
    },
  },
} as const;

export const OrderLinesArrayResponseSchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/OrderLines',
      },
    },
  },
  title: 'OrderLinesArrayResponse',
} as const;

export const PacingDeliveryTypeSchema = {
  type: 'string',
  description:
    'Ad group pacing delivery type. With ACCELERATED, an ad group budget is spent as fast as possible. With STANDARD, an ad group budget is spent smoothly over a day. When using CBO, only the STANDARD pacing delivery type is allowed.',
  example: 'STANDARD',
  enum: ['STANDARD', 'ACCELERATED'],
} as const;

export const PaginatedSchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      items: {
        type: 'object',
      },
    },
    bookmark: {
      type: 'string',
      nullable: true,
    },
  },
  required: ['items'],
} as const;

export const PermissionsSchema = {
  type: 'string',
  enum: [
    'ADMIN',
    'ANALYST',
    'FINANCE_MANAGER',
    'AUDIENCE_MANAGER',
    'CAMPAIGN_MANAGER',
    'CATALOGS_MANAGER',
    'PROFILE_PUBLISHER',
  ],
} as const;

export const PermissionsResponseSchema = {
  type: 'array',
  description: 'Permission levels member or partner has on an asset.',
  example: ['FINANCE_MANAGER', 'CATALOGS_MANAGER', 'AUDIENCE_MANAGER'],
  items: {
    type: 'string',
  },
} as const;

export const PermissionsWithOwnerSchema = {
  type: 'string',
  enum: [
    'ADMIN',
    'ANALYST',
    'FINANCE_MANAGER',
    'AUDIENCE_MANAGER',
    'CAMPAIGN_MANAGER',
    'CATALOGS_MANAGER',
    'CATALOGS_VIEWER',
    'PROFILE_PUBLISHER',
    'OWNER',
  ],
} as const;

export const PinSchema = {
  title: 'Pin',
  description: 'Pin',
  type: 'object',
  nullable: true,
  properties: {
    id: {
      type: 'string',
      readOnly: true,
      example: '813744226420795884',
      pattern: '^\\d+$',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      readOnly: true,
      example: '2020-01-01T20:10:40-00:00',
    },
    link: {
      type: 'string',
      nullable: true,
      example: 'https://www.pinterest.com/',
      maxLength: 2048,
    },
    title: {
      type: 'string',
      nullable: true,
    },
    description: {
      type: 'string',
      nullable: true,
    },
    dominant_color: {
      type: 'string',
      nullable: true,
      description: 'Dominant pin color. Hex number, e.g. \\"#6E7874\\".',
      example: '#6E7874',
    },
    alt_text: {
      type: 'string',
      nullable: true,
      maxLength: 500,
    },
    creative_type: {
      readOnly: true,
      nullable: true,
      type: 'string',
      allOf: [
        {
          $ref: '#/components/schemas/CreativeType',
        },
      ],
    },
    board_id: {
      description: 'The board to which this Pin belongs.',
      type: 'string',
      pattern: '^\\d+$',
    },
    board_section_id: {
      description: 'The board section to which this Pin belongs.',
      type: 'string',
      pattern: '^\\d+$',
      nullable: true,
    },
    board_owner: {
      allOf: [
        {
          $ref: '#/components/schemas/BoardOwner',
        },
      ],
      type: 'object',
      readOnly: true,
    },
    is_owner: {
      description: 'Whether the "operation user_account" is the Pin owner.',
      type: 'boolean',
      readOnly: true,
    },
    media: {
      allOf: [
        {
          $ref: '#/components/schemas/PinMedia',
        },
      ],
      type: 'object',
      readOnly: true,
    },
    media_source: {
      allOf: [
        {
          $ref: '#/components/schemas/PinMediaSource',
        },
      ],
      type: 'object',
      writeOnly: true,
    },
    parent_pin_id: {
      description:
        'The source pin id if this pin was saved from another pin. <a href="https://help.pinterest.com/article/save-pins-on-pinterest">Learn more</a>.',
      type: 'string',
      pattern: '^\\d+$',
      nullable: true,
    },
    is_standard: {
      description:
        'Whether the Pin is standard or not. See documentation on <a href="/docs/api-features/content-overview/">Changes to Pin creation</a> for more information.',
      type: 'boolean',
    },
    has_been_promoted: {
      description: 'Whether the Pin has been promoted or not.',
      type: 'boolean',
      readOnly: true,
    },
    note: {
      description:
        'Private note for this Pin. <a href="https://help.pinterest.com/en/article/add-notes-to-your-pins">Learn more</a>.',
      type: 'string',
      nullable: true,
    },
    pin_metrics: {
      description: 'Pin metrics with associated time intervals if any.',
      type: 'object',
      nullable: true,
      example: {
        '90d': {
          pin_click: 7,
          impression: 2,
          clickthrough: 3,
        },
        lifetime_metrics: {
          pin_click: 7,
          impression: 2,
          clickthrough: 3,
          reaction: 10,
          comment: 2,
        },
      },
    },
  },
} as const;

export const PinAnalyticsMetricsResponseSchema = {
  type: 'object',
  properties: {
    lifetime_metrics: {
      description: 'The lifetime metric name and value.',
      type: 'object',
      additionalProperties: {
        type: 'integer',
      },
      example: {
        TOTAL_COMMENTS: 10,
        TOTAL_REACTIONS: 12,
      },
    },
    daily_metrics: {
      description: 'Array with the requested daily metric records',
      items: {
        type: 'object',
        properties: {
          data_status: {
            $ref: '#/components/schemas/DataStatus',
          },
          date: {
            description: 'Metrics date (UTC): YYYY-MM-DD.',
            example: '2019-12-01',
            type: 'string',
          },
          metrics: {
            description: 'The metric name and daily value for each requested metric',
            type: 'object',
            additionalProperties: {
              type: 'number',
            },
            example: {
              IMPRESSION: 240,
              OUTBOUND_CLICK: 20,
              PIN_CLICK: 37,
              QUARTILE_95_PERCENT_VIEW: 8,
              SAVE: 20,
              SAVE_RATE: 0.18,
              VIDEO_10S_VIEW: 2,
              VIDEO_AVG_WATCH_TIME: 2507.75,
              VIDEO_MRC_VIEW: 20,
              VIDEO_START: 29,
              VIDEO_V50_WATCH_TIME: 10031,
            },
          },
        },
      },
      type: 'array',
    },
    summary_metrics: {
      description: 'The metric name and value over the requested period for each requested metric',
      type: 'object',
      additionalProperties: {
        type: 'number',
      },
      example: {
        IMPRESSION: 240,
        OUTBOUND_CLICK: 20,
        PIN_CLICK: 37,
        QUARTILE_95_PERCENT_VIEW: 8,
        SAVE: 20,
        SAVE_RATE: 0.18,
        VIDEO_10S_VIEW: 2,
        VIDEO_AVG_WATCH_TIME: 2507.75,
        VIDEO_MRC_VIEW: 20,
        VIDEO_START: 29,
        VIDEO_V50_WATCH_TIME: 10031,
      },
    },
  },
} as const;

export const PinAnalyticsResponseSchema = {
  type: 'object',
  additionalProperties: {
    $ref: '#/components/schemas/PinAnalyticsMetricsResponse',
  },
} as const;

export const BulkPinAnalyticsResponseSchema = {
  type: 'object',
  additionalProperties: {
    $ref: '#/components/schemas/PinAnalyticsResponse',
  },
} as const;

export const PinCreateSchema = {
  title: 'PinCreate',
  description: 'Pin',
  type: 'object',
  nullable: true,
  properties: {
    id: {
      type: 'string',
      readOnly: true,
      example: '813744226420795884',
      pattern: '^\\d+$',
    },
    created_at: {
      type: 'string',
      format: 'date-time',
      readOnly: true,
      example: '2020-01-01T20:10:40-00:00',
    },
    link: {
      type: 'string',
      nullable: true,
      example: 'https://www.pinterest.com/',
      maxLength: 2048,
    },
    title: {
      type: 'string',
      nullable: true,
      maxLength: 100,
    },
    description: {
      type: 'string',
      nullable: true,
      maxLength: 800,
    },
    dominant_color: {
      type: 'string',
      nullable: true,
      description: 'Dominant pin color. Hex number, e.g. \\"#6E7874\\".',
      example: '#6E7874',
    },
    alt_text: {
      type: 'string',
      nullable: true,
      maxLength: 500,
    },
    board_id: {
      description: 'The board to which this Pin belongs.',
      type: 'string',
      pattern: '^\\d+$',
    },
    board_section_id: {
      description: 'The board section to which this Pin belongs.',
      type: 'string',
      pattern: '^\\d+$',
      nullable: true,
    },
    board_owner: {
      allOf: [
        {
          $ref: '#/components/schemas/BoardOwner',
        },
      ],
      type: 'object',
      readOnly: true,
    },
    media: {
      allOf: [
        {
          $ref: '#/components/schemas/PinMedia',
        },
      ],
      type: 'object',
      readOnly: true,
    },
    media_source: {
      allOf: [
        {
          $ref: '#/components/schemas/PinMediaSource',
        },
      ],
      type: 'object',
      writeOnly: true,
    },
    parent_pin_id: {
      description:
        'The source pin id if this pin was saved from another pin. <a href="https://help.pinterest.com/article/save-pins-on-pinterest">Learn more</a>.',
      type: 'string',
      pattern: '^\\d+$',
      nullable: true,
    },
    note: {
      description:
        'Private note for this Pin. <a href="https://help.pinterest.com/en/article/add-notes-to-your-pins">Learn more</a>.',
      type: 'string',
      nullable: true,
    },
  },
} as const;

export const PinMediaSchema = {
  title: 'Pin media',
  type: 'object',
  description: 'Pin media objects.',
  discriminator: {
    propertyName: 'media_type',
    mapping: {
      image: '#/components/schemas/PinMediaWithImage',
      video: '#/components/schemas/PinMediaWithVideo',
      multiple_images: '#/components/schemas/PinMediaWithImages',
      multiple_videos: '#/components/schemas/PinMediaWithVideos',
      multiple_mixed: '#/components/schemas/PinMediaWithImageAndVideo',
    },
  },
  properties: {
    media_type: {
      type: 'string',
    },
  },
} as const;

export const PinMediaMetadataSchema = {
  type: 'object',
  anyOf: [
    {
      $ref: '#/components/schemas/ImageMetadata',
    },
    {
      $ref: '#/components/schemas/VideoMetadata',
    },
  ],
} as const;

export const PinMediaSourceSchema = {
  title: 'Pin media source',
  description: 'Pin media source.',
  oneOf: [
    {
      $ref: '#/components/schemas/PinMediaSourceImageBase64',
    },
    {
      $ref: '#/components/schemas/PinMediaSourceImageURL',
    },
    {
      $ref: '#/components/schemas/PinMediaSourceVideoID',
    },
    {
      $ref: '#/components/schemas/PinMediaSourceImagesBase64',
    },
    {
      $ref: '#/components/schemas/PinMediaSourceImagesURL',
    },
    {
      $ref: '#/components/schemas/PinMediaSourcePinURL',
    },
  ],
  discriminator: {
    propertyName: 'source_type',
    mapping: {
      multiple_image_base64: '#/components/schemas/PinMediaSourceImagesBase64',
      image_base64: '#/components/schemas/PinMediaSourceImageBase64',
      multiple_image_urls: '#/components/schemas/PinMediaSourceImagesURL',
      image_url: '#/components/schemas/PinMediaSourceImageURL',
      video_id: '#/components/schemas/PinMediaSourceVideoID',
      pin_url: '#/components/schemas/PinMediaSourcePinURL',
    },
  },
} as const;

export const PinMediaSourceImageBase64Schema = {
  title: 'Image Base64',
  description: 'Base64-encoded image media source',
  type: 'object',
  properties: {
    source_type: {
      type: 'string',
      enum: ['image_base64'],
    },
    content_type: {
      type: 'string',
      enum: ['image/jpeg', 'image/png'],
    },
    data: {
      type: 'string',
      pattern: '[a-zA-Z0-9+\\/=]+',
    },
    is_standard: {
      type: 'boolean',
      description:
        'Set the parameter to false to create the new simplified Pin instead of the standard pin. Currently the field is only available to a list of beta users.',
      default: true,
    },
  },
  required: ['source_type', 'content_type', 'data'],
} as const;

export const PinMediaSourceImageURLSchema = {
  title: 'Image URL',
  description: 'Image URL-based media source',
  type: 'object',
  properties: {
    source_type: {
      type: 'string',
      enum: ['image_url'],
    },
    url: {
      type: 'string',
    },
    is_standard: {
      type: 'boolean',
      description:
        'Set the parameter to false to create the new simplified Pin instead of the standard pin. Currently the field is only available to a list of beta users.',
      default: true,
    },
  },
  required: ['source_type', 'url'],
} as const;

export const PinMediaSourceImagesBase64Schema = {
  title: 'Images Base64',
  description: 'Multiple Base64-encoded images media source',
  additionalProperties: false,
  properties: {
    source_type: {
      type: 'string',
      enum: ['multiple_image_base64'],
    },
    items: {
      items: {
        additionalProperties: false,
        properties: {
          title: {
            type: 'string',
          },
          description: {
            type: 'string',
          },
          link: {
            type: 'string',
            description: 'Destination link for the image.',
          },
          content_type: {
            type: 'string',
            enum: ['image/jpeg', 'image/png'],
          },
          data: {
            type: 'string',
            description: 'Image to upload as base64 string.',
            pattern: '[a-zA-Z0-9+\\/=]+',
          },
        },
        required: ['data', 'content_type'],
        type: 'object',
      },
      minItems: 2,
      maxItems: 5,
      description: 'Array with image objects.',
      type: 'array',
    },
    index: {
      type: 'integer',
      minimum: 0,
    },
  },
  required: ['items'],
  type: 'object',
} as const;

export const PinMediaSourceImagesURLSchema = {
  title: 'Images urls',
  description: 'Multiple images urls-based media source',
  additionalProperties: false,
  properties: {
    source_type: {
      type: 'string',
      enum: ['multiple_image_urls'],
    },
    items: {
      items: {
        additionalProperties: false,
        properties: {
          title: {
            type: 'string',
          },
          description: {
            type: 'string',
          },
          link: {
            type: 'string',
            description: 'Destination link for the image.',
          },
          url: {
            description: 'URL of image to upload.',
            type: 'string',
          },
        },
        required: ['url'],
        type: 'object',
      },
      minItems: 2,
      maxItems: 5,
      description: 'Array with image objects.',
      type: 'array',
    },
    index: {
      type: 'integer',
      minimum: 0,
    },
  },
  required: ['items'],
  type: 'object',
} as const;

export const PinMediaSourcePinURLSchema = {
  title: 'Pin URL',
  description:
    'Pin URL-based media source for product pin creation. Currently the field is only available to a list of beta users.',
  type: 'object',
  properties: {
    source_type: {
      type: 'string',
      enum: ['pin_url'],
    },
    is_affiliate_link: {
      type: 'boolean',
      description:
        'This is an affiliate link or sponsored product. The FTC requires disclosure for paid partnerships and affiliate products.',
      default: false,
    },
  },
  required: ['source_type'],
} as const;

export const PinMediaSourceVideoIDSchema = {
  title: 'Video ID',
  description: 'Video ID-based media source',
  type: 'object',
  properties: {
    source_type: {
      type: 'string',
      enum: ['video_id'],
    },
    cover_image_url: {
      type: 'string',
      description: 'Cover image url.',
    },
    cover_image_content_type: {
      type: 'string',
      description: 'Content type for cover image Base64.',
      enum: ['image/jpeg', 'image/png'],
    },
    cover_image_data: {
      type: 'string',
      description: 'Cover image Base64.',
    },
    media_id: {
      type: 'string',
      pattern: '^\\d+$',
    },
    is_standard: {
      type: 'boolean',
      description:
        'Set the parameter to false to create the new simplified Pin instead of the standard pin. Currently the field is only available to a list of beta users.',
      default: true,
    },
  },
  required: ['source_type', 'media_id'],
} as const;

export const PinMediaWithImageSchema = {
  type: 'object',
  title: 'image',
  description: 'Pin with image.',
  allOf: [
    {
      type: 'object',
      properties: {
        images: {
          type: 'object',
          properties: {
            '150x150': {
              type: 'object',
              $ref: '#/components/schemas/ImageDetails',
            },
            '400x300': {
              type: 'object',
              $ref: '#/components/schemas/ImageDetails',
            },
            '600x': {
              type: 'object',
              $ref: '#/components/schemas/ImageDetails',
            },
            '1200x': {
              type: 'object',
              $ref: '#/components/schemas/ImageDetails',
            },
          },
        },
      },
    },
    {
      $ref: '#/components/schemas/PinMedia',
    },
  ],
  example: {
    media_type: 'image',
    images: {
      '150x150': {
        width: 150,
        height: 150,
        url: 'https://i.pinimg.com/150x150/0d/f6/f1/0df6f1f0bfe7aaca849c1bbc3607a34b.jpg',
      },
      '400x300': {
        width: 400,
        height: 300,
        url: 'https://i.pinimg.com/400x300/0d/f6/f1/0df6f1f0bfe7aaca849c1bbc3607a34b.jpg',
      },
      '600x': {
        width: 600,
        height: 600,
        url: 'https://i.pinimg.com/600x/0d/f6/f1/0df6f1f0bfe7aaca849c1bbc3607a34b.jpg',
      },
      '1200x': {
        width: 1200,
        height: 1200,
        url: 'https://i.pinimg.com/1200x/0d/f6/f1/0df6f1f0bfe7aaca849c1bbc3607a34b.jpg',
      },
    },
  },
} as const;

export const PinMediaWithImageAndVideoSchema = {
  type: 'object',
  title: 'Video and image',
  description: 'Pin with a mix of images and videos.',
  allOf: [
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/PinMediaMetadata',
          },
        },
      },
    },
    {
      $ref: '#/components/schemas/PinMedia',
    },
  ],
} as const;

export const PinMediaWithImagesSchema = {
  type: 'object',
  title: 'Images',
  description: 'Pin with multiple images.',
  allOf: [
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/ImageMetadata',
          },
        },
      },
    },
    {
      $ref: '#/components/schemas/PinMedia',
    },
  ],
} as const;

export const PinMediaWithVideoSchema = {
  type: 'object',
  title: 'video',
  description: 'Pin with video.',
  allOf: [
    {
      type: 'object',
      properties: {
        images: {
          type: 'object',
          properties: {
            '150x150': {
              type: 'object',
              $ref: '#/components/schemas/ImageDetails',
            },
            '400x300': {
              type: 'object',
              $ref: '#/components/schemas/ImageDetails',
            },
            '600x': {
              type: 'object',
              $ref: '#/components/schemas/ImageDetails',
            },
            '1200x': {
              type: 'object',
              $ref: '#/components/schemas/ImageDetails',
            },
          },
        },
        cover_image_url: {
          type: 'string',
        },
        video_url: {
          type: 'string',
          nullable: true,
          description:
            'Video url (720p). </p><strong>Note:</strong> This field is limited and not available to all apps.',
        },
        duration: {
          type: 'number',
          description: 'Duration (in milliseconds)',
        },
        height: {
          type: 'integer',
          description: 'Height (in pixels)',
        },
        width: {
          type: 'integer',
          description: 'Width (in pixels)',
        },
      },
    },
    {
      $ref: '#/components/schemas/PinMedia',
    },
  ],
  example: {
    media_type: 'video',
    images: {
      '400x300': {
        width: 400,
        height: 300,
        url: 'https://i.pinimg.com/400x300/0d/f6/f1/0df6f1f0bfe7aaca849c1bbc3607a34b.jpg',
      },
      '600x': {
        width: 600,
        height: 600,
        url: 'https://i.pinimg.com/600x/0d/f6/f1/0df6f1f0bfe7aaca849c1bbc3607a34b.jpg',
      },
      orig: {
        width: 560,
        height: 560,
        url: 'https://i.pinimg.com/originals/0d/f6/f1/0df6f1f0bfe7aaca849c1bbc3607a34b.jpg',
      },
    },
    cover_image_url:
      'https://i.pinimg.com/videos/thumbnails/originals/a8/b9/38/a8b938b1dacc523054a6bac201e9f1d2.0000001.jpg',
    duration: 14000,
    height: 1064,
    width: 1280,
  },
} as const;

export const PinMediaWithVideosSchema = {
  type: 'object',
  title: 'Videos',
  description: 'Pin with multiple videos.',
  allOf: [
    {
      type: 'object',
      properties: {
        items: {
          type: 'array',
          items: {
            $ref: '#/components/schemas/VideoMetadata',
          },
        },
      },
    },
    {
      $ref: '#/components/schemas/PinMedia',
    },
  ],
} as const;

export const PinPromotionSummaryStatusSchema = {
  type: 'string',
  description: 'Summary status for pin promotions',
  example: 'APPROVED',
  enum: ['APPROVED', 'PAUSED', 'PENDING', 'REJECTED', 'ADVERTISER_DISABLED', 'ARCHIVED', 'DRAFT', 'DELETED_DRAFT'],
} as const;

export const PinUpdateSchema = {
  title: 'PinUpdate',
  description: 'Pin fields for updates',
  type: 'object',
  nullable: true,
  properties: {
    alt_text: {
      type: 'string',
      nullable: true,
      description: "Pin's alternative text.",
      maxLength: 500,
    },
    board_id: {
      type: 'string',
      nullable: true,
      description: 'The id of the board to move the Pin onto.',
      pattern: '^\\d+$',
    },
    board_section_id: {
      type: 'string',
      nullable: true,
      description: '<a href="https://help.pinterest.com/en/article/create-a-board-section">Board section</a> ID.',
      pattern: '^\\d+$',
    },
    description: {
      type: 'string',
      nullable: true,
      description: 'Pin description - 800 characters maximum.',
      maxLength: 800,
    },
    link: {
      type: 'string',
      nullable: true,
      description: 'URL viewer is taken to when they click pin.',
      example: 'https://www.pinterest.com/',
      maxLength: 2048,
    },
    title: {
      type: 'string',
      nullable: true,
      description: 'The native pin title that creators explicitly prefer to display.',
      maxLength: 100,
    },
    carousel_slots: {
      type: 'array',
      description: 'Carousel Pin slots data.',
      items: {
        type: 'object',
        properties: {
          title: {
            type: 'string',
            description: 'Carousel Pin slot title.',
          },
          description: {
            type: 'string',
            description: 'Carousel Pin slot description.',
          },
          link: {
            type: 'string',
            description: 'Carousel Pin slot link.',
          },
        },
      },
    },
    note: {
      description:
        'Private note for this Pin. <a href="https://help.pinterest.com/en/article/add-notes-to-your-pins">Learn more</a>.',
      type: 'string',
      nullable: true,
    },
  },
} as const;

export const PlacementGroupTypeSchema = {
  type: 'string',
  description: 'Campaign placement group type',
  example: 'ALL',
  default: 'ALL',
  enum: ['ALL', 'SEARCH', 'BROWSE', 'OTHER'],
} as const;

export const ProductAvailabilityTypeSchema = {
  nullable: true,
  description: 'Default availability for products in a feed.',
  type: 'string',
  enum: ['IN_STOCK', 'OUT_OF_STOCK', 'PREORDER', null],
} as const;

export const ProductGroupAnalyticsResponseSchema = {
  type: 'array',
  items: {
    type: 'object',
    properties: {
      PRODUCT_GROUP_ID: {
        description: 'The ID of the product group that this metrics belongs to.',
        type: 'string',
        pattern: '^\\d+$',
      },
      DATE: {
        description:
          'Current metrics date. Only returned when granularity is a time-based value (`DAY`, `HOUR`, `WEEK`, `MONTH`)',
        type: 'string',
        format: 'date',
      },
    },
    required: ['PRODUCT_GROUP_ID'],
    additionalProperties: true,
    example: {
      DATE: '2021-04-01',
      PRODUCT_GROUP_ID: '74629351736530',
      SPEND_IN_DOLLAR: 30,
      TOTAL_CLICKTHROUGH: 216,
    },
  },
} as const;

export const ProductGroupPromotionSchema = {
  properties: {
    id: {
      description: 'ID of the product group promotion.',
      example: '2680059592705',
      title: 'id',
      type: 'string',
      pattern: '^\\d+$',
    },
    ad_group_id: {
      description: 'ID of the ad group the product group belongs to.',
      example: '2680059592705',
      pattern: '^(AG)?\\d+$',
      title: 'ad_group_id',
      type: 'string',
    },
    bid_in_micro_currency: {
      description: 'The bid in micro currency.',
      example: 14000000,
      title: 'bid_in_micro_currency',
      type: 'integer',
      nullable: true,
    },
    included: {
      description: 'True if the group is BIDDABLE, false if it should be EXCLUDED from serving ads.',
      example: true,
      nullable: true,
      title: 'included',
      type: 'boolean',
    },
    definition: {
      description: 'The full product group definition path',
      example: "*/product_type_0='kitchen'/product_type_1='beverage appliances'",
      nullable: true,
      title: 'definition',
      type: 'string',
    },
    relative_definition: {
      description: 'The definition of the product group, relative to its parent - an attribute name/value pair',
      example: "product_type_1='beverage appliances'",
      nullable: true,
      title: 'relative_definition',
      type: 'string',
    },
    parent_id: {
      description: 'The parent Product Group ID of this Product Group',
      example: '1231234',
      nullable: true,
      title: 'parent_id',
      type: 'string',
      pattern: '^\\d+$',
    },
    slideshow_collections_title: {
      description: 'Slideshow Collections Title',
      example: 'slideshow title',
      nullable: true,
      title: 'slideshow_collections_title',
      type: 'string',
    },
    slideshow_collections_description: {
      description: 'Slideshow Collections Description',
      example: 'slideshow description',
      nullable: true,
      title: 'slideshow_collections_description',
      type: 'string',
    },
    is_mdl: {
      description:
        'If set to true products promoted in this product group will use the Mobile Deep Link specified in your catalog',
      example: true,
      nullable: true,
      title: 'is_mdl',
      type: 'boolean',
    },
    status: {
      $ref: '#/components/schemas/EntityStatus',
    },
    tracking_url: {
      description: 'Tracking template for proudct group promotions. 4000 limit',
      example: 'https://www.pinterest.com',
      nullable: true,
      title: 'tracking_url',
      type: 'string',
    },
    catalog_product_group_id: {
      description: 'ID of the catalogs product group that this product group promotion references',
      example: '1231235',
      title: 'catalog_product_group_id',
      type: 'string',
      pattern: '^\\d+$',
      nullable: true,
    },
    catalog_product_group_name: {
      description: 'Catalogs product group name',
      example: 'catalogProductGroupName',
      title: 'product_group_promotion_name',
      type: 'string',
      nullable: true,
    },
    collections_hero_pin_id: {
      description: 'Hero Pin ID if this PG is promoted as a Collection',
      example: '123123',
      nullable: true,
      title: 'collections_hero_pin_id',
      type: 'string',
      pattern: '^\\d+$',
    },
    collections_hero_destination_url: {
      description: 'Collections Hero Destination Url',
      example: 'http://www.pinterest.com',
      nullable: true,
      title: 'collections_hero_destination_url',
      type: 'string',
    },
    grid_click_type: {
      $ref: '#/components/schemas/GridClickType',
    },
  },
  type: 'object',
  title: 'ProductGroupPromotion',
} as const;

export const ProductGroupPromotionCreateRequestSchema = {
  example: {
    product_group_promotion: [
      {
        slideshow_collections_description: 'Description',
        collections_hero_pin_id: '123123',
        catalog_product_group_name: 'catalogProductGroupName',
        collections_hero_destination_url: 'http://www.pinterest.com',
        tracking_url: 'https://www.pinterest.com',
        slideshow_collections_title: 'Title',
        is_mdl: true,
        status: 'ACTIVE',
        creative_type: 'REGULAR',
      },
      {
        slideshow_collections_description: 'Description',
        collections_hero_pin_id: '123123',
        catalog_product_group_name: 'catalogProductGroupName',
        collections_hero_destination_url: 'http://www.pinterest.com',
        tracking_url: 'https://www.pinterest.com',
        slideshow_collections_title: 'Title',
        is_mdl: true,
        status: 'ACTIVE',
        creative_type: 'REGULAR',
      },
    ],
    ad_group_id: '2680059592705',
  },
  properties: {
    ad_group_id: {
      description: 'ID of the Ad Group the Product Group Promotion belongs to.',
      example: '2680059592705',
      pattern: '^(AG)?\\d+$',
      title: 'ad_group_id',
      type: 'string',
    },
    product_group_promotion: {
      items: {
        $ref: '#/components/schemas/ProductGroupPromotionCreateRequestElement',
      },
      title: 'product_group_promotion',
      type: 'array',
    },
  },
  required: ['ad_group_id', 'product_group_promotion'],
  title: 'ProductGroupPromotionCreateRequest',
  type: 'object',
} as const;

export const ProductGroupPromotionCreateRequestElementSchema = {
  type: 'object',
  title: 'ProductGroupPromotionCreateRequestElement',
  allOf: [
    {
      $ref: '#/components/schemas/ProductGroupPromotion',
    },
    {
      type: 'object',
      properties: {
        creative_type: {
          $ref: '#/components/schemas/CreativeType',
        },
      },
    },
  ],
} as const;

export const ProductGroupPromotionResponseSchema = {
  type: 'object',
  title: 'ProductGroupPromotionResponse',
  properties: {
    items: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/ProductGroupPromotionResponseItem',
      },
    },
  },
} as const;

export const ProductGroupPromotionResponseElementSchema = {
  type: 'object',
  title: 'ProductGroupPromotionResponseElement',
  allOf: [
    {
      $ref: '#/components/schemas/ProductGroupPromotion',
    },
    {
      type: 'object',
      properties: {
        creative_type: {
          $ref: '#/components/schemas/CreativeType',
        },
      },
    },
  ],
} as const;

export const ProductGroupPromotionResponseItemSchema = {
  type: 'object',
  title: 'ProductGroupPromotionResponseItem',
  properties: {
    data: {
      $ref: '#/components/schemas/ProductGroupPromotionResponseElement',
    },
    exceptions: {
      nullable: true,
      items: {
        nullable: true,
        $ref: '#/components/schemas/Exception',
      },
    },
  },
} as const;

export const ProductGroupPromotionUpdateRequestSchema = {
  example: {
    product_group_promotion: [
      {
        catalog_product_group_id: '1234123',
        slideshow_collections_description: 'Description',
        collections_hero_pin_id: '123123',
        catalog_product_group_name: 'ProductGroupName',
        collections_hero_destination_url: 'http://www.pinterest.com',
        tracking_url: 'https://www.pinterest.com',
        slideshow_collections_title: 'Title',
        status: 'ACTIVE',
        id: '2680059592705',
      },
      {
        catalog_product_group_id: '1231231',
        slideshow_collections_description: 'Other description',
        collections_hero_pin_id: '123124',
        catalog_product_group_name: 'ProductGroupName',
        collections_hero_destination_url: 'http://www.pinterest.com',
        tracking_url: 'https://www.pinterest.com',
        slideshow_collections_title: 'Title',
        status: 'ACTIVE',
        id: '2680059592706',
      },
    ],
    ad_group_id: '26823439592705',
  },
  properties: {
    ad_group_id: {
      description: 'ID of the ad group the product group belongs to.',
      example: '2680059592705',
      pattern: '^(AG)?\\d+$',
      title: 'ad_group_id',
      type: 'string',
    },
    product_group_promotion: {
      items: {
        $ref: '#/components/schemas/ProductGroupPromotion',
      },
      title: 'product_group_promotion',
      type: 'array',
    },
  },
  required: ['ad_group_id', 'product_group_promotion'],
  title: 'ProductGroupPromotionUpdateRequest',
  type: 'object',
} as const;

export const ProductGroupSummaryStatusSchema = {
  type: 'string',
  description: 'Summary status for product group',
  example: 'RUNNING',
  enum: ['RUNNING', 'PAUSED', 'EXCLUDED', 'ARCHIVED'],
} as const;

export const ProductType0FilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    PRODUCT_TYPE_0: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringListCriteria',
    },
  },
  required: ['PRODUCT_TYPE_0'],
} as const;

export const ProductType1FilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    PRODUCT_TYPE_1: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringListCriteria',
    },
  },
  required: ['PRODUCT_TYPE_1'],
} as const;

export const ProductType2FilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    PRODUCT_TYPE_2: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringListCriteria',
    },
  },
  required: ['PRODUCT_TYPE_2'],
} as const;

export const ProductType3FilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    PRODUCT_TYPE_3: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringListCriteria',
    },
  },
  required: ['PRODUCT_TYPE_3'],
} as const;

export const ProductType4FilterSchema = {
  type: 'object',
  additionalProperties: false,
  properties: {
    PRODUCT_TYPE_4: {
      type: 'object',
      $ref: '#/components/schemas/CatalogsProductGroupMultipleStringListCriteria',
    },
  },
  required: ['PRODUCT_TYPE_4'],
} as const;

export const QuizPinDataSchema = {
  description: 'This field includes all quiz data including questions, options, and results.',
  example: {
    questions: [
      {
        question_id: 1,
        question_text: 'Where do you thrive?',
        options: [
          {
            text: 'Hangout vibes',
          },
          {
            text: 'Time to party!',
          },
          {
            text: 'Keeping it lowkey',
          },
        ],
      },
      {
        question_id: 2,
        question_text: 'Where would you nap?',
        options: [
          {
            text: 'Hammock in the mountains',
          },
          {
            text: 'Beach towel in the sand',
          },
          {
            text: 'Tent under the stars',
          },
        ],
      },
      {
        question_id: 2,
        question_text: 'Who are you taking?',
        options: [
          {
            text: 'No one—solo trip!',
          },
          {
            text: 'My best friend',
          },
          {
            text: 'The family',
          },
        ],
      },
    ],
    results: [
      {
        organicPinId: '1234',
        android_deep_link: 'https://www.pinterest.com/',
        iOS_deep_link: 'https://www.pinterest.com/',
        destination_url: 'https://www.pinterest.com/',
        result_id: 1,
      },
      {
        organicPinId: '1234',
        android_deep_link: 'https://www.pinterest.com/',
        iOS_deep_link: 'https://www.pinterest.com/',
        destination_url: 'https://www.pinterest.com/',
        result_id: 2,
      },
      {
        organicPinId: '1234',
        android_deep_link: 'https://www.pinterest.com/',
        iOS_deep_link: 'https://www.pinterest.com/',
        destination_url: 'https://www.pinterest.com/',
        result_id: 3,
      },
    ],
  },
  type: 'object',
  nullable: true,
  properties: {
    questions: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/QuizPinQuestion',
      },
    },
    results: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/QuizPinResult',
      },
    },
    tie_breaker_type: {
      type: 'string',
      description: 'Quiz ad tie breaker type, default is RANDOM',
      enum: ['RANDOM', 'CUSTOM'],
    },
    tie_breaker_custom_result: {
      $ref: '#/components/schemas/QuizPinResult',
    },
  },
} as const;

export const QuizPinOptionSchema = {
  description: ' This field contains multiple options to a quiz question.',
  example: {
    id: 1,
    text: 'Where do you thrive?',
  },
  type: 'object',
  nullable: true,
  properties: {
    id: {
      type: 'number',
    },
    text: {
      type: 'string',
    },
  },
} as const;

export const QuizPinQuestionSchema = {
  description: 'A specific quiz inquiry.',
  example: {
    question_id: 1,
    question_text: 'Where do you thrive?',
    options: [
      {
        text: 'Hangout vibes',
      },
      {
        text: 'Time to party!',
      },
      {
        text: 'Keeping it lowkey',
      },
    ],
  },
  type: 'object',
  nullable: true,
  properties: {
    question_id: {
      type: 'number',
    },
    question_text: {
      type: 'string',
    },
    options: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/QuizPinOption',
      },
    },
  },
} as const;

export const QuizPinResultSchema = {
  description: 'The result, and link out, based on the user’s choice.',
  example: {
    organic_pin_id: 'pinId',
    android_deep_link: 'https://www.pinterest.com/',
    ios_deep_link: 'https://www.pinterest.com/',
    destination_url: 'https://www.pinterest.com/',
  },
  type: 'object',
  nullable: true,
  properties: {
    organic_pin_id: {
      type: 'string',
    },
    android_deep_link: {
      type: 'string',
    },
    ios_deep_link: {
      type: 'string',
    },
    destination_url: {
      type: 'string',
    },
    result_id: {
      type: 'number',
    },
  },
} as const;

export const RelatedTermsSchema = {
  type: 'object',
  properties: {
    id: {
      description: 'First input term. For example, if you pass "?terms=clothes,workout", then id will be "clothes"',
      type: 'string',
      example: 'clothes',
    },
    related_term_count: {
      description: 'Total number of related terms returned',
      type: 'integer',
      example: 2,
    },
    related_terms_list: {
      description: 'The id of the advertiser.',
      type: 'array',
      items: {
        type: 'object',
        properties: {
          term: {
            type: 'string',
            example: 'clothes',
          },
          related_terms: {
            type: 'array',
            items: {
              type: 'string',
            },
            example: ['shoes', 'cute clothes'],
          },
        },
      },
    },
  },
} as const;

export const ReportingColumnAsyncSchema = {
  type: 'string',
  description: 'Reporting columns',
  example: 'SPEND_IN_MICRO_DOLLAR',
  enum: [
    'SPEND_IN_MICRO_DOLLAR',
    'PAID_IMPRESSION',
    'SPEND_IN_DOLLAR',
    'CPC_IN_MICRO_DOLLAR',
    'ECPC_IN_MICRO_DOLLAR',
    'ECPC_IN_DOLLAR',
    'CTR',
    'ECTR',
    'OUTBOUND_CTR',
    'COST_PER_OUTBOUND_CLICK',
    'CAMPAIGN_NAME',
    'CAMPAIGN_STATUS',
    'PIN_PROMOTION_STATUS',
    'AD_STATUS',
    'PIN_ID',
    'TOTAL_ENGAGEMENT',
    'ENGAGEMENT_1',
    'ENGAGEMENT_2',
    'ECPE_IN_DOLLAR',
    'ENGAGEMENT_RATE',
    'EENGAGEMENT_RATE',
    'ECPM_IN_MICRO_DOLLAR',
    'REPIN_RATE',
    'CTR_2',
    'CAMPAIGN_ID',
    'ADVERTISER_ID',
    'AD_ACCOUNT_ID',
    'PIN_PROMOTION_ID',
    'AD_ID',
    'AD_GROUP_ID',
    'CAMPAIGN_ENTITY_STATUS',
    'CAMPAIGN_MANAGED_STATUS',
    'CAMPAIGN_OBJECTIVE_TYPE',
    'CPM_IN_MICRO_DOLLAR',
    'CPM_IN_DOLLAR',
    'AD_GROUP_NAME',
    'AD_GROUP_STATUS',
    'AD_GROUP_ENTITY_STATUS',
    'PRODUCT_GROUP_ID',
    'PRODUCT_GROUP_STATUS',
    'ORDER_LINE_ID',
    'ORDER_LINE_NAME',
    'CLICKTHROUGH_1',
    'REPIN_1',
    'IMPRESSION_1',
    'IMPRESSION_1_GROSS',
    'CLICKTHROUGH_1_GROSS',
    'OUTBOUND_CLICK_1',
    'CLICKTHROUGH_2',
    'REPIN_2',
    'IMPRESSION_2',
    'OUTBOUND_CLICK_2',
    'TOTAL_CLICKTHROUGH',
    'TOTAL_IMPRESSION',
    'TOTAL_IMPRESSION_USER',
    'TOTAL_IMPRESSION_FREQUENCY',
    'COST_PER_OUTBOUND_CLICK_IN_DOLLAR',
    'TOTAL_ENGAGEMENT_PAGE_VISIT',
    'TOTAL_ENGAGEMENT_SIGNUP',
    'TOTAL_ENGAGEMENT_CHECKOUT',
    'TOTAL_ENGAGEMENT_CUSTOM',
    'TOTAL_ENGAGEMENT_ADD_TO_CART',
    'TOTAL_ENGAGEMENT_LEAD',
    'TOTAL_ENGAGEMENT_SEARCH',
    'TOTAL_ENGAGEMENT_WATCH_VIDEO',
    'TOTAL_ENGAGEMENT_VIEW_CATEGORY',
    'TOTAL_ENGAGEMENT_APP_INSTALL',
    'TOTAL_ENGAGEMENT_UNKNOWN',
    'TOTAL_CLICK_PAGE_VISIT',
    'TOTAL_CLICK_SIGNUP',
    'TOTAL_CLICK_CHECKOUT',
    'TOTAL_CLICK_CUSTOM',
    'TOTAL_CLICK_ADD_TO_CART',
    'TOTAL_CLICK_LEAD',
    'TOTAL_CLICK_SEARCH',
    'TOTAL_CLICK_WATCH_VIDEO',
    'TOTAL_CLICK_VIEW_CATEGORY',
    'TOTAL_CLICK_APP_INSTALL',
    'TOTAL_CLICK_UNKNOWN',
    'TOTAL_VIEW_PAGE_VISIT',
    'TOTAL_VIEW_SIGNUP',
    'TOTAL_VIEW_CHECKOUT',
    'TOTAL_VIEW_CUSTOM',
    'TOTAL_VIEW_ADD_TO_CART',
    'TOTAL_VIEW_LEAD',
    'TOTAL_VIEW_SEARCH',
    'TOTAL_VIEW_WATCH_VIDEO',
    'TOTAL_VIEW_VIEW_CATEGORY',
    'TOTAL_VIEW_APP_INSTALL',
    'TOTAL_VIEW_UNKNOWN',
    'TOTAL_CONVERSIONS',
    'TOTAL_ENGAGEMENT_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_ENGAGEMENT_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_ENGAGEMENT_APP_INSTALL_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_CLICK_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_CLICK_LEAD_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_CLICK_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_CLICK_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_CLICK_APP_INSTALL_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_VIEW_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_VIEW_LEAD_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_VIEW_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_VIEW_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_VIEW_APP_INSTALL_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_CONVERSIONS_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_ENGAGEMENT_PAGE_VISIT_QUANTITY',
    'TOTAL_ENGAGEMENT_SIGNUP_QUANTITY',
    'TOTAL_ENGAGEMENT_CHECKOUT_QUANTITY',
    'TOTAL_ENGAGEMENT_CUSTOM_QUANTITY',
    'TOTAL_ENGAGEMENT_ADD_TO_CART_QUANTITY',
    'TOTAL_ENGAGEMENT_LEAD_QUANTITY',
    'TOTAL_ENGAGEMENT_SEARCH_QUANTITY',
    'TOTAL_ENGAGEMENT_WATCH_VIDEO_QUANTITY',
    'TOTAL_ENGAGEMENT_VIEW_CATEGORY_QUANTITY',
    'TOTAL_ENGAGEMENT_UNKNOWN_QUANTITY',
    'TOTAL_CLICK_PAGE_VISIT_QUANTITY',
    'TOTAL_CLICK_SIGNUP_QUANTITY',
    'TOTAL_CLICK_CHECKOUT_QUANTITY',
    'TOTAL_CLICK_CUSTOM_QUANTITY',
    'TOTAL_CLICK_ADD_TO_CART_QUANTITY',
    'TOTAL_CLICK_LEAD_QUANTITY',
    'TOTAL_CLICK_SEARCH_QUANTITY',
    'TOTAL_CLICK_WATCH_VIDEO_QUANTITY',
    'TOTAL_CLICK_VIEW_CATEGORY_QUANTITY',
    'TOTAL_CLICK_UNKNOWN_QUANTITY',
    'TOTAL_VIEW_PAGE_VISIT_QUANTITY',
    'TOTAL_VIEW_SIGNUP_QUANTITY',
    'TOTAL_VIEW_CHECKOUT_QUANTITY',
    'TOTAL_VIEW_CUSTOM_QUANTITY',
    'TOTAL_VIEW_ADD_TO_CART_QUANTITY',
    'TOTAL_VIEW_LEAD_QUANTITY',
    'TOTAL_VIEW_SEARCH_QUANTITY',
    'TOTAL_VIEW_WATCH_VIDEO_QUANTITY',
    'TOTAL_VIEW_VIEW_CATEGORY_QUANTITY',
    'TOTAL_VIEW_UNKNOWN_QUANTITY',
    'TOTAL_CONVERSIONS_QUANTITY',
    'TOTAL_WEB_SESSIONS',
    'WEB_SESSIONS_1',
    'WEB_SESSIONS_2',
    'ONSITE_CHECKOUTS_1',
    'PIN_PROMOTION_NAME',
    'AD_NAME',
    'CAMPAIGN_LIFETIME_SPEND_CAP',
    'CAMPAIGN_DAILY_SPEND_CAP',
    'TOTAL_PAGE_VISIT_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_PAGE_VISIT_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_PAGE_VISIT_DESKTOP_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_PAGE_VISIT_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_PAGE_VISIT_MOBILE_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_PAGE_VISIT_MOBILE_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_PAGE_VISIT_TABLET_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_PAGE_VISIT_TABLET_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_PAGE_VISIT_TABLET_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_SIGNUP_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_SIGNUP_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_SIGNUP_DESKTOP_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_SIGNUP_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_SIGNUP_MOBILE_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_SIGNUP_MOBILE_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_SIGNUP_TABLET_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_SIGNUP_TABLET_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_SIGNUP_TABLET_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_CHECKOUT_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_CHECKOUT_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_CHECKOUT_DESKTOP_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_CHECKOUT_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_CHECKOUT_MOBILE_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_CHECKOUT_MOBILE_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_CHECKOUT_TABLET_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_CHECKOUT_TABLET_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_CHECKOUT_TABLET_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_CUSTOM_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_CUSTOM_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_CUSTOM_DESKTOP_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_CUSTOM_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_CUSTOM_MOBILE_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_CUSTOM_MOBILE_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_CUSTOM_TABLET_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_CUSTOM_TABLET_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_CUSTOM_TABLET_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_ADD_TO_CART_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_ADD_TO_CART_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_ADD_TO_CART_DESKTOP_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_ADD_TO_CART_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_ADD_TO_CART_MOBILE_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_ADD_TO_CART_MOBILE_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_ADD_TO_CART_TABLET_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_ADD_TO_CART_TABLET_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_ADD_TO_CART_TABLET_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_LEAD_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_LEAD_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_LEAD_DESKTOP_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_LEAD_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_LEAD_MOBILE_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_LEAD_MOBILE_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_LEAD_TABLET_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_LEAD_TABLET_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_LEAD_TABLET_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_SEARCH_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_SEARCH_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_SEARCH_DESKTOP_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_SEARCH_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_SEARCH_MOBILE_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_SEARCH_MOBILE_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_SEARCH_TABLET_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_SEARCH_TABLET_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_SEARCH_TABLET_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_WATCH_VIDEO_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_WATCH_VIDEO_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_WATCH_VIDEO_DESKTOP_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_WATCH_VIDEO_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_WATCH_VIDEO_MOBILE_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_WATCH_VIDEO_MOBILE_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_WATCH_VIDEO_TABLET_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_WATCH_VIDEO_TABLET_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_WATCH_VIDEO_TABLET_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_VIEW_CATEGORY_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_VIEW_CATEGORY_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_VIEW_CATEGORY_DESKTOP_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_VIEW_CATEGORY_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_VIEW_CATEGORY_MOBILE_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_VIEW_CATEGORY_MOBILE_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_VIEW_CATEGORY_TABLET_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_VIEW_CATEGORY_TABLET_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_VIEW_CATEGORY_TABLET_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_APP_INSTALL_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_APP_INSTALL_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_APP_INSTALL_DESKTOP_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_APP_INSTALL_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_APP_INSTALL_MOBILE_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_APP_INSTALL_MOBILE_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_APP_INSTALL_TABLET_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_APP_INSTALL_TABLET_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_APP_INSTALL_TABLET_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_UNKNOWN_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_UNKNOWN_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_UNKNOWN_DESKTOP_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_UNKNOWN_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_UNKNOWN_MOBILE_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_UNKNOWN_MOBILE_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_UNKNOWN_TABLET_ACTION_TO_DESKTOP_CONVERSION',
    'TOTAL_UNKNOWN_TABLET_ACTION_TO_MOBILE_CONVERSION',
    'TOTAL_UNKNOWN_TABLET_ACTION_TO_TABLET_CONVERSION',
    'TOTAL_PAGE_VISIT',
    'TOTAL_SIGNUP',
    'TOTAL_CHECKOUT',
    'TOTAL_CUSTOM',
    'TOTAL_ADD_TO_CART',
    'TOTAL_LEAD',
    'TOTAL_SEARCH',
    'TOTAL_WATCH_VIDEO',
    'TOTAL_VIEW_CATEGORY',
    'TOTAL_APP_INSTALL',
    'TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_LEAD_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_SEARCH_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_APP_INSTALL_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_CHECKOUT_QUANTITY',
    'PAGE_VISIT_COST_PER_ACTION',
    'APP_INSTALL_COST_PER_ACTION',
    'PAGE_VISIT_ROAS',
    'CHECKOUT_ROAS',
    'CUSTOM_ROAS',
    'VIDEO_3SEC_VIEWS_1',
    'VIDEO_P100_COMPLETE_1',
    'VIDEO_P0_COMBINED_1',
    'VIDEO_P25_COMBINED_1',
    'VIDEO_P50_COMBINED_1',
    'VIDEO_P75_COMBINED_1',
    'VIDEO_P95_COMBINED_1',
    'VIDEO_MRC_VIEWS_1',
    'VIDEO_3SEC_VIEWS_2',
    'VIDEO_P100_COMPLETE_2',
    'VIDEO_P0_COMBINED_2',
    'VIDEO_P25_COMBINED_2',
    'VIDEO_P50_COMBINED_2',
    'VIDEO_P75_COMBINED_2',
    'VIDEO_P95_COMBINED_2',
    'VIDEO_MRC_VIEWS_2',
    'PAID_VIDEO_VIEWABLE_RATE',
    'VIDEO_LENGTH',
    'CPV_IN_MICRO_DOLLAR',
    'ECPV_IN_DOLLAR',
    'CPCV_IN_MICRO_DOLLAR',
    'ECPCV_IN_DOLLAR',
    'CPCV_P95_IN_MICRO_DOLLAR',
    'ECPCV_P95_IN_DOLLAR',
    'TOTAL_VIDEO_3SEC_VIEWS',
    'TOTAL_VIDEO_P100_COMPLETE',
    'TOTAL_VIDEO_P0_COMBINED',
    'TOTAL_VIDEO_P25_COMBINED',
    'TOTAL_VIDEO_P50_COMBINED',
    'TOTAL_VIDEO_P75_COMBINED',
    'TOTAL_VIDEO_P95_COMBINED',
    'TOTAL_VIDEO_MRC_VIEWS',
    'VIDEO_AVG_WATCHTIME_IN_SECOND_1',
    'VIDEO_AVG_WATCHTIME_IN_SECOND_2',
    'TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND',
    'TOTAL_DESTINATION_VIEWS',
    'TOTAL_REPIN_RATE',
    'WEB_CHECKOUT_COST_PER_ACTION',
    'WEB_CHECKOUT_ROAS',
    'TOTAL_WEB_CHECKOUT',
    'TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_CLICK_CHECKOUT',
    'TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_ENGAGEMENT_CHECKOUT',
    'TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_VIEW_CHECKOUT',
    'TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
    'INAPP_CHECKOUT_COST_PER_ACTION',
    'INAPP_CHECKOUT_ROAS',
    'TOTAL_INAPP_CHECKOUT',
    'TOTAL_INAPP_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_INAPP_CLICK_CHECKOUT',
    'TOTAL_INAPP_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_INAPP_ENGAGEMENT_CHECKOUT',
    'TOTAL_INAPP_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_INAPP_VIEW_CHECKOUT',
    'TOTAL_INAPP_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
    'OFFLINE_CHECKOUT_COST_PER_ACTION',
    'OFFLINE_CHECKOUT_ROAS',
    'TOTAL_OFFLINE_CHECKOUT',
    'TOTAL_OFFLINE_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_OFFLINE_CLICK_CHECKOUT',
    'TOTAL_OFFLINE_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_OFFLINE_ENGAGEMENT_CHECKOUT',
    'TOTAL_OFFLINE_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_OFFLINE_VIEW_CHECKOUT',
    'TOTAL_OFFLINE_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
    'PINTEREST_CHECKOUT_COST_PER_ACTION',
    'PINTEREST_CHECKOUT_ROAS',
    'TOTAL_PINTEREST_CHECKOUT',
    'TOTAL_PINTEREST_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
    'WEB_ADD_TO_CART_COST_PER_ACTION',
    'WEB_ADD_TO_CART_ROAS',
    'TOTAL_WEB_ADD_TO_CART',
    'TOTAL_WEB_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_CLICK_ADD_TO_CART',
    'TOTAL_WEB_CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_ENGAGEMENT_ADD_TO_CART',
    'TOTAL_WEB_ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_VIEW_ADD_TO_CART',
    'TOTAL_WEB_VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
    'INAPP_ADD_TO_CART_COST_PER_ACTION',
    'INAPP_ADD_TO_CART_ROAS',
    'TOTAL_INAPP_ADD_TO_CART',
    'TOTAL_INAPP_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_INAPP_CLICK_ADD_TO_CART',
    'TOTAL_INAPP_CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_INAPP_ENGAGEMENT_ADD_TO_CART',
    'TOTAL_INAPP_ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_INAPP_VIEW_ADD_TO_CART',
    'TOTAL_INAPP_VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
    'WEB_PAGE_VISIT_COST_PER_ACTION',
    'WEB_PAGE_VISIT_ROAS',
    'TOTAL_WEB_PAGE_VISIT',
    'TOTAL_WEB_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_CLICK_PAGE_VISIT',
    'TOTAL_WEB_CLICK_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_ENGAGEMENT_PAGE_VISIT',
    'TOTAL_WEB_ENGAGEMENT_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_VIEW_PAGE_VISIT',
    'TOTAL_WEB_VIEW_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR',
    'WEB_SIGNUP_COST_PER_ACTION',
    'WEB_SIGNUP_ROAS',
    'TOTAL_WEB_SIGNUP',
    'TOTAL_WEB_SIGNUP_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_CLICK_SIGNUP',
    'TOTAL_WEB_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_ENGAGEMENT_SIGNUP',
    'TOTAL_WEB_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_VIEW_SIGNUP',
    'TOTAL_WEB_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR',
    'INAPP_SIGNUP_COST_PER_ACTION',
    'INAPP_SIGNUP_ROAS',
    'TOTAL_INAPP_SIGNUP',
    'TOTAL_INAPP_SIGNUP_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_INAPP_CLICK_SIGNUP',
    'TOTAL_INAPP_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_INAPP_ENGAGEMENT_SIGNUP',
    'TOTAL_INAPP_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_INAPP_VIEW_SIGNUP',
    'TOTAL_INAPP_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR',
    'OFFLINE_SIGNUP_COST_PER_ACTION',
    'OFFLINE_SIGNUP_ROAS',
    'TOTAL_OFFLINE_SIGNUP',
    'TOTAL_OFFLINE_SIGNUP_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_OFFLINE_CLICK_SIGNUP',
    'TOTAL_OFFLINE_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_OFFLINE_ENGAGEMENT_SIGNUP',
    'TOTAL_OFFLINE_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_OFFLINE_VIEW_SIGNUP',
    'TOTAL_OFFLINE_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR',
    'WEB_WATCH_VIDEO_COST_PER_ACTION',
    'WEB_WATCH_VIDEO_ROAS',
    'TOTAL_WEB_WATCH_VIDEO',
    'TOTAL_WEB_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_CLICK_WATCH_VIDEO',
    'TOTAL_WEB_CLICK_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_ENGAGEMENT_WATCH_VIDEO',
    'TOTAL_WEB_ENGAGEMENT_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_VIEW_WATCH_VIDEO',
    'TOTAL_WEB_VIEW_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR',
    'WEB_LEAD_COST_PER_ACTION',
    'WEB_LEAD_ROAS',
    'TOTAL_WEB_LEAD',
    'TOTAL_WEB_LEAD_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_CLICK_LEAD',
    'TOTAL_WEB_CLICK_LEAD_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_ENGAGEMENT_LEAD',
    'TOTAL_WEB_ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_VIEW_LEAD',
    'TOTAL_WEB_VIEW_LEAD_VALUE_IN_MICRO_DOLLAR',
    'OFFLINE_LEAD_COST_PER_ACTION',
    'OFFLINE_LEAD_ROAS',
    'TOTAL_OFFLINE_LEAD',
    'TOTAL_OFFLINE_LEAD_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_OFFLINE_CLICK_LEAD',
    'TOTAL_OFFLINE_CLICK_LEAD_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_OFFLINE_ENGAGEMENT_LEAD',
    'TOTAL_OFFLINE_ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_OFFLINE_VIEW_LEAD',
    'TOTAL_OFFLINE_VIEW_LEAD_VALUE_IN_MICRO_DOLLAR',
    'WEB_SEARCH_COST_PER_ACTION',
    'WEB_SEARCH_ROAS',
    'TOTAL_WEB_SEARCH',
    'TOTAL_WEB_SEARCH_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_CLICK_SEARCH',
    'TOTAL_WEB_CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_ENGAGEMENT_SEARCH',
    'TOTAL_WEB_ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_VIEW_SEARCH',
    'TOTAL_WEB_VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR',
    'INAPP_SEARCH_COST_PER_ACTION',
    'INAPP_SEARCH_ROAS',
    'TOTAL_INAPP_SEARCH',
    'TOTAL_INAPP_SEARCH_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_INAPP_CLICK_SEARCH',
    'TOTAL_INAPP_CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_INAPP_ENGAGEMENT_SEARCH',
    'TOTAL_INAPP_ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_INAPP_VIEW_SEARCH',
    'TOTAL_INAPP_VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR',
    'WEB_VIEW_CATEGORY_COST_PER_ACTION',
    'WEB_VIEW_CATEGORY_ROAS',
    'TOTAL_WEB_VIEW_CATEGORY',
    'TOTAL_WEB_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_CLICK_VIEW_CATEGORY',
    'TOTAL_WEB_CLICK_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_ENGAGEMENT_VIEW_CATEGORY',
    'TOTAL_WEB_ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_VIEW_VIEW_CATEGORY',
    'TOTAL_WEB_VIEW_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR',
    'WEB_CUSTOM_COST_PER_ACTION',
    'WEB_CUSTOM_ROAS',
    'TOTAL_WEB_CUSTOM',
    'TOTAL_WEB_CUSTOM_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_CLICK_CUSTOM',
    'TOTAL_WEB_CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_ENGAGEMENT_CUSTOM',
    'TOTAL_WEB_ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_VIEW_CUSTOM',
    'TOTAL_WEB_VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR',
    'OFFLINE_CUSTOM_COST_PER_ACTION',
    'OFFLINE_CUSTOM_ROAS',
    'TOTAL_OFFLINE_CUSTOM',
    'TOTAL_OFFLINE_CUSTOM_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_OFFLINE_CLICK_CUSTOM',
    'TOTAL_OFFLINE_CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_OFFLINE_ENGAGEMENT_CUSTOM',
    'TOTAL_OFFLINE_ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_OFFLINE_VIEW_CUSTOM',
    'TOTAL_OFFLINE_VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR',
    'WEB_UNKNOWN_COST_PER_ACTION',
    'WEB_UNKNOWN_ROAS',
    'TOTAL_WEB_UNKNOWN',
    'TOTAL_WEB_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_CLICK_UNKNOWN',
    'TOTAL_WEB_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_ENGAGEMENT_UNKNOWN',
    'TOTAL_WEB_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_WEB_VIEW_UNKNOWN',
    'TOTAL_WEB_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
    'INAPP_UNKNOWN_COST_PER_ACTION',
    'INAPP_UNKNOWN_ROAS',
    'TOTAL_INAPP_UNKNOWN',
    'TOTAL_INAPP_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_INAPP_CLICK_UNKNOWN',
    'TOTAL_INAPP_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_INAPP_ENGAGEMENT_UNKNOWN',
    'TOTAL_INAPP_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_INAPP_VIEW_UNKNOWN',
    'TOTAL_INAPP_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
    'OFFLINE_UNKNOWN_COST_PER_ACTION',
    'OFFLINE_UNKNOWN_ROAS',
    'TOTAL_OFFLINE_UNKNOWN',
    'TOTAL_OFFLINE_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_OFFLINE_CLICK_UNKNOWN',
    'TOTAL_OFFLINE_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_OFFLINE_ENGAGEMENT_UNKNOWN',
    'TOTAL_OFFLINE_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_OFFLINE_VIEW_UNKNOWN',
    'TOTAL_OFFLINE_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
    'INAPP_APP_INSTALL_COST_PER_ACTION',
    'INAPP_APP_INSTALL_ROAS',
    'TOTAL_INAPP_APP_INSTALL',
    'TOTAL_INAPP_APP_INSTALL_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_INAPP_CLICK_APP_INSTALL',
    'TOTAL_INAPP_CLICK_APP_INSTALL_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_INAPP_ENGAGEMENT_APP_INSTALL',
    'TOTAL_INAPP_ENGAGEMENT_APP_INSTALL_VALUE_IN_MICRO_DOLLAR',
    'TOTAL_INAPP_VIEW_APP_INSTALL',
    'TOTAL_INAPP_VIEW_APP_INSTALL_VALUE_IN_MICRO_DOLLAR',
    'IDEA_PIN_PRODUCT_TAG_VISIT_1',
    'IDEA_PIN_PRODUCT_TAG_VISIT_2',
    'TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT',
    'LEADS',
    'COST_PER_LEAD',
    'QUIZ_COMPLETED',
    'QUIZ_COMPLETION_RATE',
    'SHOWCASE_PIN_CLICKTHROUGH',
    'SHOWCASE_SUBPAGE_CLICKTHROUGH',
    'SHOWCASE_SUBPIN_CLICKTHROUGH',
    'SHOWCASE_SUBPAGE_IMPRESSION',
    'SHOWCASE_SUBPIN_IMPRESSION',
    'SHOWCASE_SUBPAGE_SWIPE_LEFT',
    'SHOWCASE_SUBPAGE_SWIPE_RIGHT',
    'SHOWCASE_SUBPIN_SWIPE_LEFT',
    'SHOWCASE_SUBPIN_SWIPE_RIGHT',
    'SHOWCASE_SUBPAGE_REPIN',
    'SHOWCASE_SUBPIN_REPIN',
    'SHOWCASE_SUBPAGE_CLOSEUP',
    'SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD',
    'SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD',
    'SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION',
    'TOTAL_CHECKOUT_CONVERSION_RATE',
    'TOTAL_VIEW_CATEGORY_CONVERSION_RATE',
    'TOTAL_ADD_TO_CART_CONVERSION_RATE',
    'TOTAL_SIGNUP_CONVERSION_RATE',
    'TOTAL_PAGE_VISIT_CONVERSION_RATE',
    'TOTAL_LEAD_CONVERSION_RATE',
    'TOTAL_SEARCH_CONVERSION_RATE',
    'TOTAL_WATCH_VIDEO_CONVERSION_RATE',
    'TOTAL_UNKNOWN_CONVERSION_RATE',
    'TOTAL_CUSTOM_CONVERSION_RATE',
    'STANDARD_AD_FEED_ITEM_ID',
  ],
} as const;

export const ResourceIdToRolesSchema = {
  description: `A string representing a json object mapping a resource id to a list of business roles.
`,
  type: 'string',
  example: '{"549760723247": ["ANALYST"], "549760723248": ["ANALYST","ADMIN"]}',
} as const;

export const RespondToInvitesResponseArraySchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      description:
        'List of invite/request accept/decline status. If there is an error, an exception object will be returned. If the invite/request was successfully accepted/declined, an invite object will be returned.',
      items: {
        type: 'object',
        properties: {
          exception: {
            $ref: '#/components/schemas/InviteExceptionResponse',
          },
          invite: {
            description:
              'An invite object for the invite/request that was successfully accepted/declined. Will only be provided if the an invite/request is successfully created.',
            $ref: '#/components/schemas/BaseInviteDataResponse',
          },
        },
      },
    },
  },
} as const;

export const RoleSchema = {
  type: 'string',
  description: 'An internal role type used on business access, EMPLOYEE, ADMIN.',
  example: 'ADMIN',
  enum: [
    'UNKNOWN',
    'OWNER',
    'ADMIN',
    'ANALYST',
    'SOS_READER',
    'FINANCE_MANAGER',
    'AUDIENCE_MANAGER',
    'CAMPAIGN_MANAGER',
    'CATALOGS_MANAGER',
    'RESTRICTED_OWNER',
    'PROFILE_MANAGER',
    'PROFILE_PUBLISHER',
    'RESOURCE_PINNER_LIST_OWNER',
    'RESOURCE_PINNER_LIST_READER',
    'BIZ_PINNER_LIST_SHARER',
    'RESOURCE_CONVERSION_TAGS_READER',
  ],
} as const;

export const SSIOAccountAddressSchema = {
  type: 'object',
  properties: {
    display: {
      description: 'Address display',
      example: '475 Brannan Street, San Francisco, CA 94103',
      type: 'string',
    },
    purpose: {
      description: 'Purpose for which the address is used, usually Billing or Businness',
      example: 'Billing',
      type: 'string',
    },
    address_id: {
      description: 'Salesforce id for address',
      example: 'a1C1N000004MUrLUAW',
      type: 'string',
    },
    order_legal_entity: {
      description: 'Legal entity for this insertion order',
      example: 'PIN US OU',
      type: 'string',
    },
  },
} as const;

export const SSIOAccountItemSchema = {
  type: 'object',
  properties: {
    id: {
      description: 'Salesforce id for billto_info',
      example: '0011N00001LW8kAQAT',
      type: 'string',
    },
    io_terms_id: {
      description: 'Salesforce id for IO Terms and Conditions',
      example: 'a2S1N000000bKHgUAM',
      type: 'string',
    },
    io_terms: {
      description: 'Salesforce text for IO Terms and Conditions',
      example:
        'The IO is governed by the terms available at https://business.pinterest.com/en/pinterest-advertising-services-agreement/. If a budget is listed on this IO, the parties agree that Advertiser (or if applicable, its Agency) may apply any of the budget to any auction bid type or ad product. Price will be determined by auction closing price, plus any applicable non-auction fees. The terms of the Agreement supersede any terms on this IO. ANY ADDITIONAL TERMS AND CONDITIONS ON THIS IO ARE NULL AND VOID.',
      type: 'string',
    },
    us_terms_id: {
      description: 'Salesforce id for US Terms and Conditions',
      example: 'a2S1N000000bKIOUA2',
      type: 'string',
    },
    us_terms: {
      description: 'Salesforce text for US Terms and Conditions',
      example:
        'This Insertion Order ("IO") is subject to the Pinterest Addendum To IAB Standard Terms and Conditions for Internet Advertising For Media Buys One Year or Less (Version 3.0), as executed by Pinterest, Inc. and GroupM Worldwide LLC on May 7, 2014 and Amendment No. 1 to Pinterest Addendum to IAB Standard Terms and Conditions for Internet Advertising For Media Buys One Year or Less (Version 3.0) as executed by Pinterest, Inc. and GroupM Worldwide LLC on August 20, 2015. The parties agree that Agency may apply any of the budget listed on this IO to any auction bid type or ad product. Price will be determined by auction closing price, plus any applicable non-auction fees.The terms of the Addendum supersede any terms on this IO. ANY ADDITIONAL TERMS AND CONDITIONS ON THIS IO ARE NULL AND VOID.',
      type: 'string',
    },
    row_terms_id: {
      description: 'Salesforce id for Rest of the World Terms and Conditions',
      example: 'a2S1N000000bKHhUAM',
      type: 'string',
    },
    row_terms: {
      description: 'Salesforce text for Rest of the World Terms and Conditions',
      example: `The IO is governed by the terms available at
https://business.pinterest.com/en-gb/pinterest-advertising-services-agreement`,
      type: 'string',
    },
    io_type: {
      description: 'Insertion Order Type - Pinterest Paper or Agency Paper',
      example: 'Pinterest Paper',
      type: 'string',
    },
    addresses: {
      description: 'Address information that is associated with this account.',
      type: 'array',
      items: {
        $ref: '#/components/schemas/SSIOAccountAddress',
      },
    },
  },
} as const;

export const SSIOAccountPMPNameSchema = {
  type: 'object',
  properties: {
    name: {
      description: 'Display name',
      example: 'Bidalgo',
      type: 'string',
    },
    id: {
      description: 'Salesforce id for PMP',
      example: '0011N00001LW2aSQAT',
      type: 'string',
    },
  },
} as const;

export const SSIOAccountResponseSchema = {
  type: 'object',
  properties: {
    eligible: {
      description: 'Advertiser eligible to create order lines',
      example: true,
      type: 'boolean',
    },
    can_edit: {
      description: 'Advertiser eligible to update order lines',
      example: true,
      type: 'boolean',
    },
    billto_infos: {
      type: 'array',
      description: 'An array of Salesforce account information that includes address, io terms, etc.',
      items: {
        $ref: '#/components/schemas/SSIOAccountItem',
      },
    },
    currency: {
      type: 'string',
      example: 'USD',
    },
    pmp_names: {
      type: 'array',
      items: {
        $ref: '#/components/schemas/SSIOAccountPMPName',
      },
    },
    error: {
      description: 'Error indicator from Salesforce which could be "No Error"',
      example: 'No Error',
      type: 'string',
    },
  },
} as const;

export const SSIOCreateInsertionOrderRequestSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/SSIOInsertionOrderCommon',
    },
    {
      type: 'object',
      required: [
        'order_line_type',
        'start_date',
        'po_number',
        'pmp_id',
        'order_name',
        'media_contact_firstname',
        'media_contact_lastname',
        'media_contact_email',
        'currency_info',
        'billto_company_id',
        'billto_business_address_id',
        'billto_billing_address_id',
        'billing_contact_firstname',
        'billing_contact_lastname',
        'billing_contact_email',
        'accepted_terms_id',
      ],
      properties: {
        accepted_terms_time: {
          description: 'The UTC timestamp (to the nearest sec) of when terms were accepted',
          type: 'integer',
        },
        pmp_id: {
          description: 'The pmp id',
          type: 'string',
        },
        order_name: {
          description: 'The order name',
          type: 'string',
        },
        order_line_type: {
          type: 'string',
          description: 'Type can be Budget or Perpetual',
          enum: ['BUDGET', 'PERPETUALS'],
        },
        accepted_terms_id: {
          description: 'The SFDC id for the terms',
          type: 'string',
        },
        billto_company_id: {
          description: 'The bill-to company id',
          type: 'string',
        },
        billto_business_address_id: {
          description: 'The bill-to business address id',
          type: 'string',
        },
        billto_billing_address_id: {
          description: 'The bill-to billing address id',
          type: 'string',
        },
        estimated_monthly_spend: {
          description: 'If Ongoing (perpetual) order line, the estimated monthly spend',
          type: 'number',
        },
        currency_info: {
          $ref: '#/components/schemas/Currency',
        },
      },
    },
  ],
} as const;

export const SSIOCreateInsertionOrderResponseSchema = {
  type: 'object',
  properties: {
    pin_order_id: {
      description: 'Salesforce order id',
      type: 'string',
    },
  },
} as const;

export const SSIOEditInsertionOrderRequestSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/SSIOInsertionOrderCommon',
    },
    {
      type: 'object',
      properties: {
        oracle_line_id: {
          description: 'LineId in the Oracle DB',
          type: 'string',
        },
        salesforce_order_id: {
          description: 'OrderId in SFDC',
          type: 'string',
        },
        salesforce_order_line_id: {
          description: 'OrderLineId in SFDC',
          type: 'string',
        },
        ads_manager_order_line_id: {
          description: 'Ads manager OrderLineId',
          type: 'string',
        },
      },
    },
  ],
} as const;

export const SSIOEditInsertionOrderResponseSchema = {
  type: 'object',
  properties: {
    pin_order_id: {
      description: 'Salesforce order id',
      type: 'string',
    },
  },
} as const;

export const SSIOInsertionOrderCommonSchema = {
  type: 'object',
  properties: {
    start_date: {
      description: 'Starting date of time period. Format: YYYY-MM-DD',
      type: 'string',
      pattern: '^(\\d{4})-(\\d{2})-(\\d{2})$',
      example: '2020-12-20',
    },
    end_date: {
      description: 'End date of time period. Format: YYYY-MM-DD',
      type: 'string',
      pattern: '^(\\d{4})-(\\d{2})-(\\d{2})$',
      example: '2020-12-20',
    },
    po_number: {
      description: 'The po number',
      type: 'string',
    },
    budget_amount: {
      type: 'number',
      description: 'If Budget order line, the budget amount.',
      example: 5000000,
    },
    billing_contact_firstname: {
      description: 'The billing contact first name',
      type: 'string',
    },
    billing_contact_lastname: {
      description: 'The billing contact last name',
      type: 'string',
    },
    billing_contact_email: {
      description: 'The billing contact email',
      example: 'test@example',
      type: 'string',
    },
    media_contact_firstname: {
      description: 'The media contact first name',
      type: 'string',
    },
    media_contact_lastname: {
      description: 'The media contact last name',
      type: 'string',
    },
    media_contact_email: {
      description: 'The media contact email',
      example: 'test@example',
      type: 'string',
    },
    agency_link: {
      description: 'URL link for agency',
      type: 'string',
    },
    user_email: {
      description: 'The email of user submitting the insertion order',
      example: 'test@example',
      type: 'string',
    },
  },
} as const;

export const SSIOInsertionOrderStatusSchema = {
  type: 'object',
  properties: {
    pin_order_id: {
      description: 'Salesforce order id',
      example: '0Q01N0000015hekSAB',
      type: 'string',
    },
    status: {
      description: 'Salesforce insertion order status',
      example: 'Approved',
      type: 'string',
    },
    creation_time: {
      description: 'Salesforce insertion order creation time',
      example: '2017-06-21T23:11:11.000Z',
      type: 'string',
      nullable: true,
    },
  },
} as const;

export const SSIOInsertionOrderStatusResponseSchema = {
  allOf: [
    {
      $ref: '#/components/schemas/SSIOInsertionOrderStatus',
    },
    {
      type: 'object',
    },
  ],
} as const;

export const SSIOOrderLineSchema = {
  type: 'object',
  properties: {
    salesforce_order_line_id: {
      description: 'OrderLineId in SFDC',
      type: 'string',
      nullable: true,
    },
    ads_manager_order_line_id: {
      description: 'Ads manager OrderLineId',
      type: 'string',
      nullable: true,
    },
    pin_order_id: {
      description: 'The pin order id associated with the order line in SFDC',
      type: 'string',
      nullable: true,
    },
    last_modified_date_time: {
      description: 'Last modified date.',
      example: '2020-10-06T13:07:04.000Z',
      type: 'string',
      pattern: '^(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2}).(\\d{3})Z$',
      nullable: true,
    },
    start_date: {
      description: 'Start date of the order line.',
      example: '2018-03-01',
      type: 'string',
      format: 'date',
      nullable: true,
    },
    end_date: {
      description: 'End date of the order line.',
      example: '2020-10-05',
      type: 'string',
      format: 'date',
      nullable: true,
    },
    bill_to_company_name: {
      description: 'Bill To Company name',
      example: 'Home Depot Inc.',
      type: 'string',
      nullable: true,
    },
    billing_contact_firstname: {
      description: 'Billing contact first name',
      example: 'Mary',
      type: 'string',
      nullable: true,
    },
    billing_contact_lastname: {
      description: 'Billing contact last name',
      example: 'Smith',
      type: 'string',
      nullable: true,
    },
    billing_contact_email: {
      description: 'Billing contact email',
      example: 'mail@test.com',
      type: 'string',
      nullable: true,
    },
    media_contact_email: {
      description: 'Billing media email',
      example: 'mail@test.com',
      type: 'string',
      nullable: true,
    },
    media_contact_firstname: {
      description: 'Billing contact first name',
      example: 'John',
      type: 'string',
      nullable: true,
    },
    media_contact_lastname: {
      description: 'Billing contact first name',
      example: 'Doe',
      type: 'string',
      nullable: true,
    },
    currency_info: {
      $ref: '#/components/schemas/Currency',
      nullable: true,
    },
    agency_link: {
      description: 'Agency link',
      example: '',
      type: 'string',
      nullable: true,
    },
    po_number: {
      description: 'The po number',
      type: 'string',
      nullable: true,
    },
    order_name: {
      description: 'The order name',
      type: 'string',
      nullable: true,
    },
    pmp_name: {
      description: 'The Pinterest marketing partner name',
      type: 'string',
      nullable: true,
    },
    accepted_terms_id: {
      description: 'The SFDC id for the terms',
      type: 'string',
      nullable: true,
    },
    accepted_terms_time: {
      description: 'The UTC timestamp (to the nearest sec) of when terms were accepted',
      example: '2020-10-06T13:07:04.000Z',
      type: 'string',
      pattern: '^(\\d{4})-(\\d{2})-(\\d{2})T(\\d{2}):(\\d{2}):(\\d{2}).(\\d{3})Z$',
      nullable: true,
    },
    budget_amount: {
      type: 'number',
      description: 'If Budget order line, the budget amount.',
      example: 5000000,
      nullable: true,
    },
    estimated_monthly_spend: {
      description: 'If Ongoing (perpetual) order line, the estimated monthly spend',
      type: 'number',
      nullable: true,
    },
  },
} as const;

export const SharedAudienceAccountSchema = {
  type: 'object',
  properties: {
    account_id: {
      description: 'Account ID (ad account or business ID).',
      example: '549755885175',
      type: 'string',
      pattern: '^\\d+$',
    },
    account_name: {
      description: 'Account name.',
      example: 'Home Depot USA',
      type: 'string',
    },
    account_type: {
      type: 'string',
      description: 'account type',
      enum: ['AD_ACCOUNT', 'BUSINESS_ACCOUNT'],
    },
    shared_on_timestamp: {
      description: 'Epoch timestamp in seconds for the shared audience event',
      example: 1677003860,
      type: 'integer',
    },
  },
  required: ['account_id', 'account_name', 'account_type', 'shared_on_timestamp'],
} as const;

export const SingleInterestTargetingOptionResponseSchema = {
  title: 'SingleInterestTargetingOptionData',
  type: 'object',
  properties: {
    id: {
      type: 'string',
      title: 'id',
      pattern: '\\d+',
      example: '945391946569',
    },
    name: {
      type: 'string',
      title: 'name',
      example: 'Dress',
    },
    child_interests: {
      type: 'array',
      title: 'child_interests',
      items: {
        type: 'string',
      },
    },
    level: {
      type: 'integer',
      title: 'level',
      example: 2,
    },
  },
} as const;

export const TargetingAdvertiserCountrySchema = {
  type: 'string',
  description: "Advertiser's ISO two character country code.",
  example: 'US',
  nullable: true,
  enum: [
    'US',
    'GB',
    'CA',
    'IE',
    'AU',
    'NZ',
    'FR',
    'SE',
    'IL',
    'DE',
    'AT',
    'IT',
    'ES',
    'NL',
    'BE',
    'PT',
    'CH',
    'HK',
    'JP',
    'KR',
    'SG',
    'NO',
    'DK',
    'FI',
    'CY',
    'LU',
    'MT',
    'PL',
    'RO',
    'HU',
    'CZ',
    'GR',
    'SK',
    'BR',
    'MX',
    'AR',
    'CL',
    'CO',
  ],
} as const;

export const TargetingOptionResponseSchema = {
  title: 'TargetingOptionResponse',
  type: 'array',
  nullable: true,
  items: {
    type: 'object',
    example: {
      36313: 'Australia: Moreton Bay - North',
      124735: 'Canada: North Battleford',
    },
  },
} as const;

export const TargetingSpecSchema = {
  description:
    'Ad group targeting specification defining the ad group target audience. For example, `{"APPTYPE":["iphone"], "GENDER":["male"], "LOCALE":["en-US"], "LOCATION":["501"], "AGE_BUCKET":["25-34"]}`',
  type: 'object',
  properties: {
    AGE_BUCKET: {
      type: 'array',
      nullable: true,
      description:
        'Age ranges. If the AGE_BUCKET field is missing, the default behavior in terms of ad delivery is that **All age buckets** will be targeted.',
      example: ['35-44', '50-54'],
      items: {
        type: 'string',
        enum: ['18-24', '21+', '25-34', '35-44', '45-49', '50-54', '55-64', '65+'],
      },
    },
    APPTYPE: {
      type: 'array',
      nullable: true,
      description:
        'Allowed devices. If the APPTYPE field is missing, the default behavior in terms of ad delivery is that **All devices/apptypes** will be targeted.',
      example: ['ipad', 'iphone'],
      items: {
        type: 'string',
        enum: ['android_mobile', 'android_tablet', 'ipad', 'iphone', 'web', 'web_mobile'],
      },
    },
    AUDIENCE_EXCLUDE: {
      type: 'array',
      nullable: true,
      description:
        'Excluded customer list IDs. Used to drive new customer acquisition goals. For example: ["2542620905475"]. Audience lists need to have at least 100 people with Pinterest accounts in them. If the AUDIENCE_EXCLUDE field is missing, the default behavior in terms of ad delivery is that **No users will be excluded**.',
      items: {
        type: 'string',
        pattern: '^\\d+$',
        minItems: 100,
      },
    },
    AUDIENCE_INCLUDE: {
      type: 'array',
      nullable: true,
      description:
        'Targeted customer list IDs. For example: ["2542620905473"]. Audience lists need to have at least 100 people with Pinterest accounts in them Audience lists need to have at least 100 people with Pinterest accounts in them. If the AUDIENCE_INCLUDE field is missing, the default behavior in terms of ad delivery is that **All users will be included**.',
      items: {
        type: 'string',
        pattern: '^\\d+$',
        minItems: 100,
      },
    },
    GENDER: {
      type: 'array',
      nullable: true,
      description:
        'Targeted genders. Values: ["unknown","male","female"]. If the GENDER field is missing, the default behavior in terms of ad delivery is that **All genders will be targeted**.',
      items: {
        type: 'string',
        enum: ['unknown', 'male', 'female'],
      },
    },
    GEO: {
      type: 'array',
      nullable: true,
      description:
        'Location region codes, e.g., "BE-VOV" (East Flanders, Belgium) For complete list, <a href="https://help.pinterest.com/sub/helpcenter/partner/pinterest_location_targeting_codes.xlsx" target="_blank">click here</a> or postal codes, e.g., "US-94107". Use either region codes or postal codes but not both. At least one of LOCATION or GEO must be specified. If the GEO field is missing, then only LOCATION values will be targeted (see LOCATION field below).',
      items: {
        type: 'string',
      },
    },
    INTEREST: {
      type: 'array',
      description:
        'Array of interest object IDs. If the INTEREST field is missing, the default behavior in terms of ad delivery is that **All interests will be targeted**.',
      items: {
        type: 'string',
      },
    },
    LOCALE: {
      type: 'array',
      nullable: true,
      description:
        '24 ISO 639-1 two letter language codes. If the LOCALE field is missing, the default behavior in terms of ad delivery is that **All languages will be targeted, only english non-sublanguage will be targeted**.',
      items: {
        type: 'string',
      },
    },
    LOCATION: {
      type: 'array',
      nullable: true,
      description:
        '22 ISO Alpha 2 two letter country codes or US Nielsen DMA (Designated Market Area) codes (location region codes) (e.g., ["US", "807"]). For complete list, click here. Location-Country and Location-Metro codes apply. At least one of LOCATION or GEO must be specified. If the LOCATION field is missing, then only GEO values will be targeted (see GEO field above).',
      items: {
        type: 'string',
      },
    },
    SHOPPING_RETARGETING: {
      type: 'array',
      nullable: true,
      description:
        'Array of object: lookback_window\t[Integer]: Number of days ago to start lookback timeframe for dynamic retargeting tag_types [Array of integer]: Event types to target for dynamic retargeting exclusion_window [Integer]: Number of days ago to stop lookback timeframe for dynamic retargeting',
      items: {
        type: 'object',
        example: {
          lookback_window: 30,
          exclusion_window: 14,
          tag_types: [0, 6],
        },
        properties: {
          lookback_window: {
            description: 'Number of days ago to start lookback timeframe for dynamic retargeting',
            example: 30,
            title: 'lookback_window',
            type: 'integer',
          },
          tag_types: {
            description: 'Event types to target for dynamic retargeting',
            example: [0, 6],
            items: {
              type: 'integer',
            },
            title: 'tag_types',
            type: 'array',
          },
          exclusion_window: {
            description: 'Number of days ago to stop lookback timeframe for dynamic retargeting',
            example: 14,
            title: 'exclusion_window',
            type: 'integer',
          },
        },
        title: 'TargetingSpec_SHOPPING_RETARGETING',
      },
    },
    TARGETING_STRATEGY: {
      type: 'array',
      nullable: true,
      description: '',
      items: {
        enum: ['CHOOSE_YOUR_OWN', 'FIND_NEW_CUSTOMERS', 'RECONNECT_WITH_USERS'],
      },
    },
  },
} as const;

export const TargetingTemplateAudienceSizingSchema = {
  type: 'object',
  nullable: true,
  description:
    'Gets an audience size estimate for a set of given targeting spec data. <p>Returns:</p> An object containing an audience size estimate that has a reach estimate (number of unique users) against the given targeting template. This by default provides a monthly estimate. ',
  example: {
    reach_estimate: {
      estimate: 63492000,
      lower_bound: 47619000,
      upper_bound: 79365000,
    },
  },
  properties: {
    reach_estimate: {
      type: 'object',
      properties: {
        estimate: {
          example: 63492000,
          type: 'integer',
          format: 'int64',
        },
        lower_bound: {
          example: 47619000,
          type: 'integer',
          format: 'int64',
        },
        upper_bound: {
          example: 79365000,
          type: 'integer',
          format: 'int64',
        },
      },
    },
  },
} as const;

export const TargetingTemplateCommonSchema = {
  type: 'object',
  properties: {
    name: {
      type: 'string',
      example: 'Gaming',
      description: 'targeting template name',
    },
    auto_targeting_enabled: {
      type: 'boolean',
      default: true,
      description:
        'Enable auto-targeting for ad group. Also known as <a href="https://help.pinterest.com/en/business/article/expanded-targeting" target="_blank">"expanded targeting"</a>.',
    },
    targeting_attributes: {
      $ref: '#/components/schemas/TargetingSpec',
    },
    placement_group: {
      $ref: '#/components/schemas/PlacementGroupType',
    },
    keywords: {
      type: 'array',
      example: [
        {
          value: 'cats',
          match_type: 'EXACT_NEGATIVE',
        },
      ],
      items: {
        $ref: '#/components/schemas/TargetingTemplateKeyword',
      },
    },
    tracking_urls: {
      $ref: '#/components/schemas/TrackingUrls',
    },
  },
} as const;

export const TargetingTemplateCreateSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/TargetingTemplateCommon',
    },
    {
      type: 'object',
      required: ['name', 'targeting_attributes'],
      properties: {
        name: {
          type: 'string',
          example: 'Gaming',
          description: 'Name of targeting template.',
        },
        targeting_attributes: {
          $ref: '#/components/schemas/TargetingSpec',
        },
      },
    },
  ],
} as const;

export const TargetingTemplateKeywordSchema = {
  type: 'object',
  properties: {
    match_type: {
      $ref: '#/components/schemas/MatchType',
    },
    value: {
      type: 'string',
      description: 'The keyword targeting (120 chars max).',
      example: 'couples halloween costumes',
    },
  },
} as const;

export const TargetingTemplateGetResponseDataSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/TargetingTemplateResponseData',
    },
    {
      type: 'object',
      title: 'TargetingTemplateGetResponseData',
      properties: {
        valid: {
          nullable: true,
          description: 'Inform if the targeting template is valid (ex. would be false if has revoked audience)',
          type: 'boolean',
          example: true,
        },
      },
    },
  ],
} as const;

export const TargetingTemplateResponseDataSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/TargetingTemplateCommon',
    },
    {
      type: 'object',
      title: 'TargetingTemplateResponseData',
      properties: {
        id: {
          description: 'Targeting template ID.',
          example: '643',
          type: 'string',
          pattern: '^\\d+$',
        },
        created_time: {
          description: 'Targeting template created time. Unix timestamp in seconds.',
          example: 1432744744,
          title: 'created_time',
          type: 'integer',
        },
        updated_time: {
          description: 'Targeting template updated time.Unix timestamp in seconds.',
          example: 1432744744,
          title: 'updated_time',
          type: 'integer',
        },
        ad_account_id: {
          description: 'The ID of the advertiser that this targeting template belongs to.',
          example: '549755885175',
          type: 'string',
          pattern: '^\\d+$',
        },
        status: {
          type: 'string',
          description: 'Indicate targeting template is active or Deleted',
          allOf: [
            {
              type: 'string',
              description: 'Indicate targeting template is active or Deleted',
              example: 'ACTIVE',
              default: 'ACTIVE',
              enum: ['ACTIVE', 'DELETED'],
            },
          ],
        },
        sizing: {
          $ref: '#/components/schemas/TargetingTemplateAudienceSizing',
        },
      },
    },
  ],
} as const;

export const TargetingTemplateUpdateRequestSchema = {
  required: ['operation_type', 'id'],
  type: 'object',
  properties: {
    operation_type: {
      enum: ['REMOVE'],
      type: 'string',
    },
    id: {
      description: 'Targeting template ID',
      example: '643',
      type: 'string',
      pattern: '^\\d+$',
    },
  },
} as const;

export const TargetingTypeFilterSchema = {
  type: 'object',
  properties: {
    targeting_types: {
      type: 'array',
      description:
        'List of targeting types. Requires `level` to be a value ending in `_TARGETING`. ["AGE_BUCKET_AND_GENDER"] is in BETA and not yet available to all users.',
      items: {
        $ref: '#/components/schemas/AdsAnalyticsTargetingType',
      },
      maxItems: 5,
      minItems: 1,
    },
  },
} as const;

export const TemplateResponseSchema = {
  type: 'object',
  description: 'Template fields',
  properties: {
    id: {
      description: 'Template ID',
      example: '6739202847590',
      type: 'string',
    },
    ad_account_id: {
      description: 'ID of the Ad Account that owns the template',
      example: '547664674848',
      type: 'string',
    },
    ad_account_ids: {
      description: 'IDs of the Ad Accounts that have access to this template',
      example: ['547664674848'],
      type: 'array',
      items: {
        type: 'string',
      },
    },
    user_id: {
      description: 'ID of the user who created the template',
      example: '784762938748396',
      type: 'string',
    },
    name: {
      description: 'Template Name',
      example: 'Week over week spend',
      nullable: true,
      type: 'string',
    },
    report_start_relative_days_in_past: {
      description: 'The number of days prior to the day the report will be delivered at which the report will start',
      example: 7,
      type: 'number',
    },
    report_end_relative_days_in_past: {
      description: 'The number of days prior to the day the report will be delivered at which the report will end',
      example: 7,
      type: 'number',
    },
    date_range: {
      properties: {
        dynamic_date_range: {
          description: 'The dynamic date range of the template',
          nullable: true,
          example: {
            range: 'YEAR_TO_DATE',
            type: 'dynamic',
          },
          properties: {
            type: {
              description: 'The date range type',
              example: 'dynamic',
              type: 'string',
            },
            range: {
              description: 'The dynamic range type',
              enum: ['YEAR_TO_DATE', 'QUARTER_TO_DATE', 'MONTH_TO_DATE', 'LAST_MONTH'],
              example: 'YEAR_TO_DATE',
              type: 'string',
            },
          },
          type: 'object',
        },
        relative_date_range: {
          description: 'The relative date range of the template',
          nullable: true,
          example: {
            end_days_in_past: 7,
            type: 'relative',
            start_days_in_past: 14,
          },
          properties: {
            type: {
              description: 'The date range type',
              example: 'relative',
              type: 'string',
            },
            start_days_in_past: {
              description: 'The start date of the date range',
              example: 14,
              type: 'number',
            },
            end_days_in_past: {
              description: 'The end date of the date range',
              example: 7,
              type: 'number',
            },
          },
          type: 'object',
        },
        absolute_date_range: {
          description: 'The absolute date range of the template',
          nullable: true,
          example: {
            end_date: 6.027456183070403,
            type: 'absolute',
            start_date: 0.8008281904610115,
          },
          properties: {
            type: {
              description: 'The date range type',
              example: 'absolute',
              type: 'string',
            },
            start_date: {
              description: 'The start date of the date range',
              example: 0.8008281904610115,
              type: 'number',
            },
            end_date: {
              description: 'The end date of the date range',
              example: 6.027456183070403,
              type: 'number',
            },
          },
          type: 'object',
        },
      },
      type: 'object',
    },
    report_level: {
      $ref: '#/components/schemas/MetricsReportingLevel',
    },
    report_format: {
      $ref: '#/components/schemas/DataOutputFormat',
    },
    columns: {
      description: 'A list of columns to be included in the report',
      example: ['SPEND_IN_DOLLAR'],
      items: {
        type: 'string',
        description: 'Reporting Columns (Internal)',
        example: 'TOTAL_CONVERSIONS',
        enum: [
          'SPEND_IN_MICRO_DOLLAR',
          'SPEND_IN_MICRO_US_DOLLAR',
          'BONUS_SPEND_IN_MICRO_DOLLAR',
          'BONUS_SPEND_IN_DOLLAR',
          'PAID_IMPRESSION',
          'PAID_CLICKTHROUGH',
          'SPEND_IN_DOLLAR',
          'SPEND_IN_US_DOLLAR',
          'CPC_IN_MICRO_DOLLAR',
          'ECPC_IN_MICRO_DOLLAR',
          'CPC_IN_DOLLAR',
          'ECPC_IN_DOLLAR',
          'CTR',
          'ECTR',
          'OUTBOUND_CTR',
          'CPC_IN_MICRO_CURRENCY',
          'CPW_IN_MICRO_DOLLAR',
          'CPW_IN_DOLLAR',
          'COST_PER_OUTBOUND_CLICK',
          'AD_ONLY_PIN',
          'CAMPAIGN_NAME',
          'CAMPAIGN_STATUS',
          'IS_CAMPAIGN_LEARNING_PHASE',
          'DATE',
          'DATE_AS_TIMESTAMP',
          'BUDGET_IN_DOLLAR',
          'AVAILABLE_BUDGET_IN_DOLLAR',
          'TARGETING_TYPE',
          'TARGETING_VALUE',
          'TARGETING_VALUE_NAME',
          'PAID_EVENTS',
          'BONUS_EVENTS',
          'INSERTION',
          'LEGACY_CAMPAIGN_ID',
          'HBASE_ID',
          'PIN_DESCRIPTION',
          'CAMPAIGN_END_DATE',
          'PIN_PROMOTION_STATUS',
          'AD_STATUS',
          'PIN_ID',
          'CROSS_DEVICE_TYPE',
          'INGESTION_SOURCE',
          'SOURCE_PLATFORM',
          'PIN_PROMOTION_IS_RUNNING',
          'TOTAL_ENGAGEMENT',
          'ENGAGEMENT_1',
          'ENGAGEMENT_2',
          'CPE_IN_MICRO_DOLLAR',
          'ECPE_IN_MICRO_DOLLAR',
          'CPE_IN_DOLLAR',
          'ECPE_IN_DOLLAR',
          'ENGAGEMENT_RATE',
          'EENGAGEMENT_RATE',
          'INTERNAL_ECPE_IN_MICRO_DOLLAR',
          'INTERNAL_ECPE_IN_DOLLAR',
          'ECPM_IN_MICRO_DOLLAR',
          'ECPM_IN_DOLLAR',
          'REPIN_RATE',
          'REPIN_RATE_2',
          'CTR_2',
          'CAMPAIGN_ID',
          'ADVERTISER_ID',
          'AD_ACCOUNT_ID',
          'ADVERTISER_OWNER_USER_ID',
          'ADVERTISER_OWNER_USER_NAME',
          'PIN_PROMOTION_ID',
          'AD_ID',
          'AD_GROUP_ID',
          'KEYWORD_ID',
          'KEYWORD_IS_DELETED',
          'BRAND_SFDC_ACCOUNT_ID',
          'CAMPAIGN_ACTION_TYPE',
          'CAMPAIGN_BID_TYPE',
          'CAMPAIGN_ENTITY_STATUS',
          'CAMPAIGN_MANAGED_STATUS',
          'CAMPAIGN_OBJECTIVE_TYPE',
          'CPM_IN_MICRO_DOLLAR',
          'CPM_IN_DOLLAR',
          'BUDGET_TYPE',
          'BUDGET_IN_LOCAL_CURRENCY',
          'AD_GROUP_NAME',
          'AD_GROUP_STATUS',
          'AD_GROUP_END_DATE',
          'AD_GROUP_BUDGET_TYPE',
          'AD_GROUP_BUDGET_IN_LOCAL_CURRENCY',
          'AD_GROUP_SUGGESTED_BUDGET_IN_LOCAL_CURRENCY',
          'AD_GROUP_SUGGESTED_BONUS_BUDGET_IN_LOCAL_CURRENCY',
          'AD_GROUP_ENTITY_STATUS',
          'AD_GROUP_ACTION_TYPE',
          'AD_GROUP_CONVERSION_LEARNING_MODE_TYPE',
          'AD_GROUP_TARGET_CPA',
          'AD_GROUP_BID_STRATEGY_TYPE',
          'AD_GROUP_EXPERIMENT_NAME',
          'AD_GROUP_EXPERIMENT_CELL',
          'CAMPAIGN_WEB_CLOSEUP_WHITELISTED',
          'PRODUCT_GROUP_ID',
          'PRODUCT_GROUP_DEFINITION',
          'PARENT_PRODUCT_GROUP_ID',
          'PRODUCT_GROUP_TYPE',
          'PRODUCT_GROUP_BID_IN_MICRO_CURRENCY',
          'PRODUCT_GROUP_STATUS',
          'PRODUCT_GROUP_ENTITY_STATUS',
          'PRODUCT_GROUP_INCLUSION',
          'PRODUCT_GROUP_CREATIVE_TYPE',
          'ITEM_ID',
          'PRODUCT_ITEM_ID',
          'INTERNAL_PRODUCT_ITEM_ID',
          'INTERNAL_PRODUCT_ITEM_ID_STR',
          'PRODUCT_ITEM_NAME',
          'PRODUCT_ITEM_IMAGE_URL',
          'PRODUCT_ITEM_PRICE',
          'ORDER_LINE_ID',
          'ORDER_LINE_NAME',
          'ORDER_LINE_PIN_REV_SHARE',
          'ORDER_LINE_PAID_TYPE',
          'SPEND_ORDER_LINE_ID',
          'SPEND_ORDER_LINE_PAID_TYPE',
          'CONVERSION_PRODUCT_ID',
          'CONVERSION_PRODUCT_NAME',
          'CONVERSION_PRODUCT_BRAND',
          'CONVERSION_PRODUCT_CATEGORY',
          'CLICKTHROUGH_1',
          'REPIN_1',
          'IMPRESSION_1',
          'LIKE_1',
          'SEND_1',
          'FLAG_1',
          'HIDE_1',
          'INSERTION_1',
          'IMPRESSION_1_GROSS',
          'CLICKTHROUGH_1_GROSS',
          'OUTBOUND_CLICK_1',
          'CLICKTHROUGH_USER_1',
          'REPIN_USER_1',
          'IMPRESSION_USER_1',
          'LIKE_USER_1',
          'SEND_USER_1',
          'FLAG_USER_1',
          'HIDE_USER_1',
          'INSERTION_USER_1',
          'CLICKTHROUGH_2',
          'REPIN_2',
          'IMPRESSION_2',
          'LIKE_2',
          'SEND_2',
          'FLAG_2',
          'OUTBOUND_CLICK_2',
          'CLICKTHROUGH_USER_2',
          'REPIN_USER_2',
          'IMPRESSION_USER_2',
          'LIKE_USER_2',
          'SEND_USER_2',
          'FLAG_USER_2',
          'TOTAL_CLICKTHROUGH',
          'TOTAL_REPIN',
          'TOTAL_IMPRESSION',
          'TOTAL_LIKE',
          'TOTAL_SEND',
          'TOTAL_FLAG',
          'TOTAL_IMPRESSION_USER',
          'TOTAL_IMPRESSION_USER_HLL',
          'TOTAL_IMPRESSION_FREQUENCY',
          'TOTAL_IMPRESSION_FREQUENCY_HLL',
          'TOTAL_OUTBOUND_CLICK',
          'COST_PER_OUTBOUND_CLICK_IN_DOLLAR',
          'ENGAGEMENT_PAGE_VISIT_1',
          'ENGAGEMENT_SIGNUP_1',
          'ENGAGEMENT_CHECKOUT_1',
          'ENGAGEMENT_CUSTOM_1',
          'ENGAGEMENT_ADD_TO_CART_1',
          'ENGAGEMENT_LEAD_1',
          'ENGAGEMENT_SEARCH_1',
          'ENGAGEMENT_WATCH_VIDEO_1',
          'ENGAGEMENT_VIEW_CATEGORY_1',
          'ENGAGEMENT_APP_INSTALL_1',
          'ENGAGEMENT_UNKNOWN_1',
          'CLICK_PAGE_VISIT_1',
          'CLICK_SIGNUP_1',
          'CLICK_CHECKOUT_1',
          'CLICK_CUSTOM_1',
          'CLICK_ADD_TO_CART_1',
          'CLICK_LEAD_1',
          'CLICK_SEARCH_1',
          'CLICK_WATCH_VIDEO_1',
          'CLICK_VIEW_CATEGORY_1',
          'CLICK_APP_INSTALL_1',
          'CLICK_UNKNOWN_1',
          'VIEW_PAGE_VISIT_1',
          'VIEW_SIGNUP_1',
          'VIEW_CHECKOUT_1',
          'VIEW_CUSTOM_1',
          'VIEW_ADD_TO_CART_1',
          'VIEW_LEAD_1',
          'VIEW_SEARCH_1',
          'VIEW_WATCH_VIDEO_1',
          'VIEW_VIEW_CATEGORY_1',
          'VIEW_APP_INSTALL_1',
          'VIEW_UNKNOWN_1',
          'CONVERSIONS_1',
          'ENGAGEMENT_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR_1',
          'ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR_1',
          'ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR_1',
          'ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR_1',
          'ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR_1',
          'ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR_1',
          'ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR_1',
          'ENGAGEMENT_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR_1',
          'ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR_1',
          'ENGAGEMENT_APP_INSTALL_VALUE_IN_MICRO_DOLLAR_1',
          'ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR_1',
          'CLICK_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR_1',
          'CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR_1',
          'CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR_1',
          'CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR_1',
          'CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR_1',
          'CLICK_LEAD_VALUE_IN_MICRO_DOLLAR_1',
          'CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR_1',
          'CLICK_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR_1',
          'CLICK_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR_1',
          'CLICK_APP_INSTALL_VALUE_IN_MICRO_DOLLAR_1',
          'CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR_1',
          'VIEW_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR_1',
          'VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR_1',
          'VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR_1',
          'VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR_1',
          'VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR_1',
          'VIEW_LEAD_VALUE_IN_MICRO_DOLLAR_1',
          'VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR_1',
          'VIEW_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR_1',
          'VIEW_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR_1',
          'VIEW_APP_INSTALL_VALUE_IN_MICRO_DOLLAR_1',
          'VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR_1',
          'CONVERSIONS_VALUE_IN_MICRO_DOLLAR_1',
          'ENGAGEMENT_PAGE_VISIT_QUANTITY_1',
          'ENGAGEMENT_SIGNUP_QUANTITY_1',
          'ENGAGEMENT_CHECKOUT_QUANTITY_1',
          'ENGAGEMENT_CUSTOM_QUANTITY_1',
          'ENGAGEMENT_ADD_TO_CART_QUANTITY_1',
          'ENGAGEMENT_LEAD_QUANTITY_1',
          'ENGAGEMENT_SEARCH_QUANTITY_1',
          'ENGAGEMENT_WATCH_VIDEO_QUANTITY_1',
          'ENGAGEMENT_VIEW_CATEGORY_QUANTITY_1',
          'ENGAGEMENT_APP_INSTALL_QUANTITY_1',
          'ENGAGEMENT_UNKNOWN_QUANTITY_1',
          'CLICK_PAGE_VISIT_QUANTITY_1',
          'CLICK_SIGNUP_QUANTITY_1',
          'CLICK_CHECKOUT_QUANTITY_1',
          'CLICK_CUSTOM_QUANTITY_1',
          'CLICK_ADD_TO_CART_QUANTITY_1',
          'CLICK_LEAD_QUANTITY_1',
          'CLICK_SEARCH_QUANTITY_1',
          'CLICK_WATCH_VIDEO_QUANTITY_1',
          'CLICK_VIEW_CATEGORY_QUANTITY_1',
          'CLICK_APP_INSTALL_QUANTITY_1',
          'CLICK_UNKNOWN_QUANTITY_1',
          'VIEW_PAGE_VISIT_QUANTITY_1',
          'VIEW_SIGNUP_QUANTITY_1',
          'VIEW_CHECKOUT_QUANTITY_1',
          'VIEW_CUSTOM_QUANTITY_1',
          'VIEW_ADD_TO_CART_QUANTITY_1',
          'VIEW_LEAD_QUANTITY_1',
          'VIEW_SEARCH_QUANTITY_1',
          'VIEW_WATCH_VIDEO_QUANTITY_1',
          'VIEW_VIEW_CATEGORY_QUANTITY_1',
          'VIEW_APP_INSTALL_QUANTITY_1',
          'VIEW_UNKNOWN_QUANTITY_1',
          'CONVERSIONS_QUANTITY_1',
          'ENGAGEMENT_PAGE_VISIT_2',
          'ENGAGEMENT_SIGNUP_2',
          'ENGAGEMENT_CHECKOUT_2',
          'ENGAGEMENT_CUSTOM_2',
          'ENGAGEMENT_ADD_TO_CART_2',
          'ENGAGEMENT_LEAD_2',
          'ENGAGEMENT_SEARCH_2',
          'ENGAGEMENT_WATCH_VIDEO_2',
          'ENGAGEMENT_VIEW_CATEGORY_2',
          'ENGAGEMENT_APP_INSTALL_2',
          'ENGAGEMENT_UNKNOWN_2',
          'CLICK_PAGE_VISIT_2',
          'CLICK_SIGNUP_2',
          'CLICK_CHECKOUT_2',
          'CLICK_CUSTOM_2',
          'CLICK_ADD_TO_CART_2',
          'CLICK_LEAD_2',
          'CLICK_SEARCH_2',
          'CLICK_WATCH_VIDEO_2',
          'CLICK_VIEW_CATEGORY_2',
          'CLICK_APP_INSTALL_2',
          'CLICK_UNKNOWN_2',
          'VIEW_PAGE_VISIT_2',
          'VIEW_SIGNUP_2',
          'VIEW_CHECKOUT_2',
          'VIEW_CUSTOM_2',
          'VIEW_ADD_TO_CART_2',
          'VIEW_LEAD_2',
          'VIEW_SEARCH_2',
          'VIEW_WATCH_VIDEO_2',
          'VIEW_VIEW_CATEGORY_2',
          'VIEW_APP_INSTALL_2',
          'VIEW_UNKNOWN_2',
          'CONVERSIONS_2',
          'ENGAGEMENT_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR_2',
          'ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR_2',
          'ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR_2',
          'ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR_2',
          'ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR_2',
          'ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR_2',
          'ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR_2',
          'ENGAGEMENT_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR_2',
          'ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR_2',
          'ENGAGEMENT_APP_INSTALL_VALUE_IN_MICRO_DOLLAR_2',
          'ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR_2',
          'CLICK_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR_2',
          'CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR_2',
          'CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR_2',
          'CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR_2',
          'CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR_2',
          'CLICK_LEAD_VALUE_IN_MICRO_DOLLAR_2',
          'CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR_2',
          'CLICK_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR_2',
          'CLICK_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR_2',
          'CLICK_APP_INSTALL_VALUE_IN_MICRO_DOLLAR_2',
          'CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR_2',
          'VIEW_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR_2',
          'VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR_2',
          'VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR_2',
          'VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR_2',
          'VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR_2',
          'VIEW_LEAD_VALUE_IN_MICRO_DOLLAR_2',
          'VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR_2',
          'VIEW_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR_2',
          'VIEW_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR_2',
          'VIEW_APP_INSTALL_VALUE_IN_MICRO_DOLLAR_2',
          'VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR_2',
          'CONVERSIONS_VALUE_IN_MICRO_DOLLAR_2',
          'ENGAGEMENT_PAGE_VISIT_QUANTITY_2',
          'ENGAGEMENT_SIGNUP_QUANTITY_2',
          'ENGAGEMENT_CHECKOUT_QUANTITY_2',
          'ENGAGEMENT_CUSTOM_QUANTITY_2',
          'ENGAGEMENT_ADD_TO_CART_QUANTITY_2',
          'ENGAGEMENT_LEAD_QUANTITY_2',
          'ENGAGEMENT_SEARCH_QUANTITY_2',
          'ENGAGEMENT_WATCH_VIDEO_QUANTITY_2',
          'ENGAGEMENT_VIEW_CATEGORY_QUANTITY_2',
          'ENGAGEMENT_APP_INSTALL_QUANTITY_2',
          'ENGAGEMENT_UNKNOWN_QUANTITY_2',
          'CLICK_PAGE_VISIT_QUANTITY_2',
          'CLICK_SIGNUP_QUANTITY_2',
          'CLICK_CHECKOUT_QUANTITY_2',
          'CLICK_CUSTOM_QUANTITY_2',
          'CLICK_ADD_TO_CART_QUANTITY_2',
          'CLICK_LEAD_QUANTITY_2',
          'CLICK_SEARCH_QUANTITY_2',
          'CLICK_WATCH_VIDEO_QUANTITY_2',
          'CLICK_VIEW_CATEGORY_QUANTITY_2',
          'CLICK_APP_INSTALL_QUANTITY_2',
          'CLICK_UNKNOWN_QUANTITY_2',
          'VIEW_PAGE_VISIT_QUANTITY_2',
          'VIEW_SIGNUP_QUANTITY_2',
          'VIEW_CHECKOUT_QUANTITY_2',
          'VIEW_CUSTOM_QUANTITY_2',
          'VIEW_ADD_TO_CART_QUANTITY_2',
          'VIEW_LEAD_QUANTITY_2',
          'VIEW_SEARCH_QUANTITY_2',
          'VIEW_WATCH_VIDEO_QUANTITY_2',
          'VIEW_VIEW_CATEGORY_QUANTITY_2',
          'VIEW_APP_INSTALL_QUANTITY_2',
          'VIEW_UNKNOWN_QUANTITY_2',
          'CONVERSIONS_QUANTITY_2',
          'TOTAL_ENGAGEMENT_PAGE_VISIT',
          'TOTAL_ENGAGEMENT_SIGNUP',
          'TOTAL_ENGAGEMENT_CHECKOUT',
          'TOTAL_ENGAGEMENT_CUSTOM',
          'TOTAL_ENGAGEMENT_ADD_TO_CART',
          'TOTAL_ENGAGEMENT_LEAD',
          'TOTAL_ENGAGEMENT_SEARCH',
          'TOTAL_ENGAGEMENT_WATCH_VIDEO',
          'TOTAL_ENGAGEMENT_VIEW_CATEGORY',
          'TOTAL_ENGAGEMENT_APP_INSTALL',
          'TOTAL_ENGAGEMENT_UNKNOWN',
          'TOTAL_CLICK_PAGE_VISIT',
          'TOTAL_CLICK_SIGNUP',
          'TOTAL_CLICK_CHECKOUT',
          'TOTAL_CLICK_CUSTOM',
          'TOTAL_CLICK_ADD_TO_CART',
          'TOTAL_CLICK_LEAD',
          'TOTAL_CLICK_SEARCH',
          'TOTAL_CLICK_WATCH_VIDEO',
          'TOTAL_CLICK_VIEW_CATEGORY',
          'TOTAL_CLICK_APP_INSTALL',
          'TOTAL_CLICK_UNKNOWN',
          'TOTAL_VIEW_PAGE_VISIT',
          'TOTAL_VIEW_SIGNUP',
          'TOTAL_VIEW_CHECKOUT',
          'TOTAL_VIEW_CUSTOM',
          'TOTAL_VIEW_ADD_TO_CART',
          'TOTAL_VIEW_LEAD',
          'TOTAL_VIEW_SEARCH',
          'TOTAL_VIEW_WATCH_VIDEO',
          'TOTAL_VIEW_VIEW_CATEGORY',
          'TOTAL_VIEW_APP_INSTALL',
          'TOTAL_VIEW_UNKNOWN',
          'TOTAL_CONVERSIONS',
          'TOTAL_WEB_CONVERSIONS',
          'TOTAL_INAPP_CONVERSIONS',
          'TOTAL_OFFLINE_CONVERSIONS',
          'TOTAL_ENGAGEMENT_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_ENGAGEMENT_PAGE_VISIT_VALUE_IN_DOLLAR',
          'TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_ENGAGEMENT_SIGNUP_VALUE_IN_DOLLAR',
          'TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_ENGAGEMENT_CHECKOUT_VALUE_IN_DOLLAR',
          'TOTAL_ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_ENGAGEMENT_CUSTOM_VALUE_IN_DOLLAR',
          'TOTAL_ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_ENGAGEMENT_ADD_TO_CART_VALUE_IN_DOLLAR',
          'TOTAL_ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_ENGAGEMENT_LEAD_VALUE_IN_DOLLAR',
          'TOTAL_ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_ENGAGEMENT_SEARCH_VALUE_IN_DOLLAR',
          'TOTAL_ENGAGEMENT_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_ENGAGEMENT_WATCH_VIDEO_VALUE_IN_DOLLAR',
          'TOTAL_ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_DOLLAR',
          'TOTAL_ENGAGEMENT_APP_INSTALL_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_CLICK_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_CLICK_PAGE_VISIT_VALUE_IN_DOLLAR',
          'TOTAL_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_CLICK_SIGNUP_VALUE_IN_DOLLAR',
          'TOTAL_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_CLICK_CHECKOUT_VALUE_IN_DOLLAR',
          'TOTAL_CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_CLICK_CUSTOM_VALUE_IN_DOLLAR',
          'TOTAL_CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_CLICK_ADD_TO_CART_VALUE_IN_DOLLAR',
          'TOTAL_CLICK_LEAD_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_CLICK_LEAD_VALUE_IN_DOLLAR',
          'TOTAL_CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_CLICK_SEARCH_VALUE_IN_DOLLAR',
          'TOTAL_CLICK_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_CLICK_WATCH_VIDEO_VALUE_IN_DOLLAR',
          'TOTAL_CLICK_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_CLICK_VIEW_CATEGORY_VALUE_IN_DOLLAR',
          'TOTAL_CLICK_APP_INSTALL_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_VIEW_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_VIEW_PAGE_VISIT_VALUE_IN_DOLLAR',
          'TOTAL_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_VIEW_SIGNUP_VALUE_IN_DOLLAR',
          'TOTAL_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_VIEW_CHECKOUT_VALUE_IN_DOLLAR',
          'TOTAL_VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_VIEW_CUSTOM_VALUE_IN_DOLLAR',
          'TOTAL_VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_VIEW_ADD_TO_CART_VALUE_IN_DOLLAR',
          'TOTAL_VIEW_LEAD_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_VIEW_LEAD_VALUE_IN_DOLLAR',
          'TOTAL_VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_VIEW_SEARCH_VALUE_IN_DOLLAR',
          'TOTAL_VIEW_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_VIEW_WATCH_VIDEO_VALUE_IN_DOLLAR',
          'TOTAL_VIEW_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_VIEW_VIEW_CATEGORY_VALUE_IN_DOLLAR',
          'TOTAL_VIEW_APP_INSTALL_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_CONVERSIONS_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_CONVERSIONS_VALUE_IN_DOLLAR',
          'TOTAL_ENGAGEMENT_PAGE_VISIT_QUANTITY',
          'TOTAL_ENGAGEMENT_SIGNUP_QUANTITY',
          'TOTAL_ENGAGEMENT_CHECKOUT_QUANTITY',
          'TOTAL_ENGAGEMENT_CUSTOM_QUANTITY',
          'TOTAL_ENGAGEMENT_ADD_TO_CART_QUANTITY',
          'TOTAL_ENGAGEMENT_LEAD_QUANTITY',
          'TOTAL_ENGAGEMENT_SEARCH_QUANTITY',
          'TOTAL_ENGAGEMENT_WATCH_VIDEO_QUANTITY',
          'TOTAL_ENGAGEMENT_VIEW_CATEGORY_QUANTITY',
          'TOTAL_ENGAGEMENT_APP_INSTALL_QUANTITY',
          'TOTAL_ENGAGEMENT_UNKNOWN_QUANTITY',
          'TOTAL_CLICK_PAGE_VISIT_QUANTITY',
          'TOTAL_CLICK_SIGNUP_QUANTITY',
          'TOTAL_CLICK_CHECKOUT_QUANTITY',
          'TOTAL_CLICK_CUSTOM_QUANTITY',
          'TOTAL_CLICK_ADD_TO_CART_QUANTITY',
          'TOTAL_CLICK_LEAD_QUANTITY',
          'TOTAL_CLICK_SEARCH_QUANTITY',
          'TOTAL_CLICK_WATCH_VIDEO_QUANTITY',
          'TOTAL_CLICK_VIEW_CATEGORY_QUANTITY',
          'TOTAL_CLICK_APP_INSTALL_QUANTITY',
          'TOTAL_CLICK_UNKNOWN_QUANTITY',
          'TOTAL_VIEW_PAGE_VISIT_QUANTITY',
          'TOTAL_VIEW_SIGNUP_QUANTITY',
          'TOTAL_VIEW_CHECKOUT_QUANTITY',
          'TOTAL_VIEW_CUSTOM_QUANTITY',
          'TOTAL_VIEW_ADD_TO_CART_QUANTITY',
          'TOTAL_VIEW_LEAD_QUANTITY',
          'TOTAL_VIEW_SEARCH_QUANTITY',
          'TOTAL_VIEW_WATCH_VIDEO_QUANTITY',
          'TOTAL_VIEW_VIEW_CATEGORY_QUANTITY',
          'TOTAL_VIEW_APP_INSTALL_QUANTITY',
          'TOTAL_VIEW_UNKNOWN_QUANTITY',
          'TOTAL_CONVERSIONS_QUANTITY',
          'COST_PER_CONVERSION_IN_DOLLAR',
          'TOTAL_WEB_SESSIONS',
          'WEB_SESSIONS_1',
          'WEB_SESSIONS_2',
          'APP_INSTALLS_CPA_BILLABLE',
          'APP_INSTALLS_CLICK',
          'APP_INSTALLS_CLOSEUPREPIN',
          'APP_INSTALLS_VIEW',
          'APP_INSTALLS',
          'APP_INSTALLS_ENGAGEMENT',
          'APP_INSTALLS_CLICK_1',
          'APP_INSTALLS_CLICK_2',
          'APP_INSTALLS_VIEW_1',
          'APP_INSTALLS_VIEW_2',
          'APP_INSTALLS_ENGAGEMENT_1',
          'APP_INSTALLS_ENGAGEMENT_2',
          'APP_INSTALLS_1',
          'APP_INSTALLS_2',
          'CPI_IN_MICRO_DOLLAR',
          'ECPI_IN_MICRO_DOLLAR',
          'CPI_IN_DOLLAR',
          'ECPI_IN_DOLLAR',
          'ONSITE_CHECKOUTS_CPA_BILLABLE_1',
          'ONSITE_CHECKOUTS_CPA_BILLABLE_2',
          'ONSITE_CHECKOUTS_CPA_BILLABLE',
          'ONSITE_CHECKOUTS_VALUE_1',
          'ONSITE_CHECKOUTS_VALUE_2',
          'ONSITE_CHECKOUTS_VALUE',
          'ONSITE_CHECKOUTS_1',
          'ONSITE_CHECKOUTS_2',
          'ONSITE_CHECKOUTS',
          'ONSITE_CHECKOUTS_VALUE_IN_MICRO_DOLLAR_1',
          'ONSITE_CHECKOUTS_VALUE_IN_MICRO_DOLLAR_2',
          'CONVERSION_RATE',
          'AVERAGE_CHECKOUT_VALUE',
          'RETURN_ON_ADVERTISER_SPEND',
          'BUY_BUTTON_CLICKS_1',
          'BUY_BUTTON_CLICKS_2',
          'TOTAL_BUY_BUTTON_CLICKS',
          'ORDER_DROPOFF_RATE',
          'ONSITE_CHECKOUTS_VALUE_IN_MICRO_DOLLAR',
          'ONSITE_CHECKOUTS_VALUE_IN_DOLLAR',
          'PIN_PROMOTION_NAME',
          'AD_NAME',
          'LIFETIME_IMPRESSION_USER_1',
          'PIN_PROMOTION_CAMPAIGN_ID',
          'PIN_PROMOTION_CAMPAIGN_NAME',
          'PIN_PROMOTION_CAMPAIGN_ACTION_TYPE',
          'TOTAL_LIFETIME_IMPRESSION_USER',
          'PIN_PROMOTION_CAMPAIGN_STATUS',
          'PIN_PROMOTION_CAMPAIGN_MANAGED_STATUS',
          'PIN_PROMOTION_CAMPAIGN_ENTITY_STATUS',
          'PIN_PROMOTION_AD_GROUP_ID',
          'PIN_PROMOTION_AD_GROUP_NAME',
          'PIN_PROMOTION_AD_GROUP_STATUS',
          'PIN_PROMOTION_AD_GROUP_ENTITY_STATUS',
          'PIN_PROMOTION_CREATIVE_TYPE',
          'PIN_PROMOTION_ENTITY_STATUS',
          'PIN_PROMOTION_CREATIVE_TYPE_V2',
          'PIN_PROMOTION_REVIEW_STATUS',
          'AD_GROUP_CAMPAIGN_ACTION_TYPE',
          'AD_GROUP_CAMPAIGN_ID',
          'AD_GROUP_CAMPAIGN_NAME',
          'AD_GROUP_CAMPAIGN_STATUS',
          'AD_GROUP_CREATIVE_TYPE',
          'AD_GROUP_CAMPAIGN_MANAGED_STATUS',
          'AD_GROUP_CAMPAIGN_ENTITY_STATUS',
          'AD_GROUP_START_DATE',
          'CAMPAIGN_LIFETIME_SPEND_CAP',
          'AD_GROUP_BID_IN_MICRO_CURRENCY',
          'CAMPAIGN_AD_GROUP_START_DATE',
          'CAMPAIGN_AD_GROUP_END_DATE',
          'CAMPAIGN_NUMBER_OF_AD_GROUPS',
          'AD_GROUP_NUMBER_OF_PIN_PROMOTIONS',
          'TODAY_SPEND_IN_LOCAL_CURRENCY',
          'TOTAL_LIFETIME_SPEND_IN_LOCAL_CURRENCY',
          'BUDGET_UTILIZATION',
          'AD_GROUP_OPTIMIZATION',
          'INSERTION_ORDER',
          'AD_GROUP_BONUS_BUDGET',
          'FREQUENCY',
          'CAMPAIGN_DAILY_SPEND_CAP',
          'CAMPAIGN_CREATIVE_TYPE',
          'AD_GROUP_PLACEMENT_GROUP_TYPE',
          'AD_GROUP_IS_PREFETCH_ENABLED',
          'CAMPAIGN_BUDGET_OPTIMIZATION',
          'CAMPAIGN_START_DATE',
          'IS_AUTOMATED_CAMPAIGN',
          'IS_PREMIERE_CAMPAIGN',
          'FLEXIBLE_DAILY_BUDGETS',
          'IS_PERFORMANCE_PLUS_CAMPAIGN',
          'IS_DCO_FORMAT_ENHANCMENT',
          'PERCENT_CROSS_DEVICE_CONVERSIONS',
          'PAGE_VISIT_PERCENT_CROSS_DEVICE_CONVERSIONS',
          'SIGNUP_PERCENT_CROSS_DEVICE_CONVERSIONS',
          'CHECKOUT_PERCENT_CROSS_DEVICE_CONVERSIONS',
          'CUSTOM_PERCENT_CROSS_DEVICE_CONVERSIONS',
          'ADD_TO_CART_PERCENT_CROSS_DEVICE_CONVERSIONS',
          'LEAD_PERCENT_CROSS_DEVICE_CONVERSIONS',
          'SEARCH_PERCENT_CROSS_DEVICE_CONVERSIONS',
          'WATCH_VIDEO_PERCENT_CROSS_DEVICE_CONVERSIONS',
          'VIEW_CATEGORY_PERCENT_CROSS_DEVICE_CONVERSIONS',
          'APP_INSTALL_PERCENT_CROSS_DEVICE_CONVERSIONS',
          'UNKNOWN_PERCENT_CROSS_DEVICE_CONVERSIONS',
          'TOTAL_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_DESKTOP_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_MOBILE_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_MOBILE_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_TABLET_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_TABLET_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_TABLET_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_PAGE_VISIT_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_PAGE_VISIT_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_PAGE_VISIT_DESKTOP_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_PAGE_VISIT_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_PAGE_VISIT_MOBILE_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_PAGE_VISIT_MOBILE_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_PAGE_VISIT_TABLET_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_PAGE_VISIT_TABLET_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_PAGE_VISIT_TABLET_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_SIGNUP_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_SIGNUP_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_SIGNUP_DESKTOP_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_SIGNUP_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_SIGNUP_MOBILE_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_SIGNUP_MOBILE_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_SIGNUP_TABLET_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_SIGNUP_TABLET_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_SIGNUP_TABLET_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_CHECKOUT_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_CHECKOUT_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_CHECKOUT_DESKTOP_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_CHECKOUT_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_CHECKOUT_MOBILE_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_CHECKOUT_MOBILE_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_CHECKOUT_TABLET_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_CHECKOUT_TABLET_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_CHECKOUT_TABLET_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_CUSTOM_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_CUSTOM_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_CUSTOM_DESKTOP_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_CUSTOM_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_CUSTOM_MOBILE_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_CUSTOM_MOBILE_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_CUSTOM_TABLET_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_CUSTOM_TABLET_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_CUSTOM_TABLET_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_ADD_TO_CART_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_ADD_TO_CART_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_ADD_TO_CART_DESKTOP_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_ADD_TO_CART_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_ADD_TO_CART_MOBILE_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_ADD_TO_CART_MOBILE_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_ADD_TO_CART_TABLET_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_ADD_TO_CART_TABLET_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_ADD_TO_CART_TABLET_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_LEAD_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_LEAD_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_LEAD_DESKTOP_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_LEAD_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_LEAD_MOBILE_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_LEAD_MOBILE_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_LEAD_TABLET_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_LEAD_TABLET_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_LEAD_TABLET_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_SEARCH_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_SEARCH_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_SEARCH_DESKTOP_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_SEARCH_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_SEARCH_MOBILE_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_SEARCH_MOBILE_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_SEARCH_TABLET_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_SEARCH_TABLET_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_SEARCH_TABLET_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_WATCH_VIDEO_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_WATCH_VIDEO_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_WATCH_VIDEO_DESKTOP_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_WATCH_VIDEO_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_WATCH_VIDEO_MOBILE_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_WATCH_VIDEO_MOBILE_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_WATCH_VIDEO_TABLET_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_WATCH_VIDEO_TABLET_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_WATCH_VIDEO_TABLET_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_VIEW_CATEGORY_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_VIEW_CATEGORY_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_VIEW_CATEGORY_DESKTOP_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_VIEW_CATEGORY_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_VIEW_CATEGORY_MOBILE_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_VIEW_CATEGORY_MOBILE_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_VIEW_CATEGORY_TABLET_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_VIEW_CATEGORY_TABLET_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_VIEW_CATEGORY_TABLET_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_APP_INSTALL_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_APP_INSTALL_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_APP_INSTALL_DESKTOP_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_APP_INSTALL_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_APP_INSTALL_MOBILE_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_APP_INSTALL_MOBILE_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_APP_INSTALL_TABLET_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_APP_INSTALL_TABLET_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_APP_INSTALL_TABLET_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_UNKNOWN_DESKTOP_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_UNKNOWN_DESKTOP_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_UNKNOWN_DESKTOP_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_UNKNOWN_MOBILE_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_UNKNOWN_MOBILE_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_UNKNOWN_MOBILE_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_UNKNOWN_TABLET_ACTION_TO_DESKTOP_CONVERSION',
          'TOTAL_UNKNOWN_TABLET_ACTION_TO_MOBILE_CONVERSION',
          'TOTAL_UNKNOWN_TABLET_ACTION_TO_TABLET_CONVERSION',
          'TOTAL_PAGE_VISIT',
          'TOTAL_SIGNUP',
          'TOTAL_CHECKOUT',
          'TOTAL_CUSTOM',
          'TOTAL_ADD_TO_CART',
          'TOTAL_LEAD',
          'TOTAL_SEARCH',
          'TOTAL_WATCH_VIDEO',
          'TOTAL_VIEW_CATEGORY',
          'TOTAL_APP_INSTALL',
          'TOTAL_UNKNOWN',
          'TOTAL_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_SIGNUP_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_CUSTOM_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_LEAD_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_SEARCH_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_APP_INSTALL_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
          'AVERAGE_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR',
          'AVERAGE_SIGNUP_VALUE_IN_MICRO_DOLLAR',
          'AVERAGE_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
          'AVERAGE_CUSTOM_VALUE_IN_MICRO_DOLLAR',
          'AVERAGE_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
          'AVERAGE_LEAD_VALUE_IN_MICRO_DOLLAR',
          'AVERAGE_SEARCH_VALUE_IN_MICRO_DOLLAR',
          'AVERAGE_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR',
          'AVERAGE_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR',
          'AVERAGE_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
          'AVERAGE_PAGE_VISIT_VALUE_IN_MICRO_US_DOLLAR',
          'AVERAGE_SIGNUP_VALUE_IN_MICRO_US_DOLLAR',
          'AVERAGE_CHECKOUT_VALUE_IN_MICRO_US_DOLLAR',
          'AVERAGE_CUSTOM_VALUE_IN_MICRO_US_DOLLAR',
          'AVERAGE_ADD_TO_CART_VALUE_IN_MICRO_US_DOLLAR',
          'AVERAGE_LEAD_VALUE_IN_MICRO_US_DOLLAR',
          'AVERAGE_SEARCH_VALUE_IN_MICRO_US_DOLLAR',
          'AVERAGE_WATCH_VIDEO_VALUE_IN_MICRO_US_DOLLAR',
          'AVERAGE_VIEW_CATEGORY_VALUE_IN_MICRO_US_DOLLAR',
          'AVERAGE_UNKNOWN_VALUE_IN_MICRO_US_DOLLAR',
          'TOTAL_PAGE_VISIT_VALUE_IN_MICRO_US_DOLLAR',
          'TOTAL_SIGNUP_VALUE_IN_MICRO_US_DOLLAR',
          'TOTAL_CHECKOUT_VALUE_IN_MICRO_US_DOLLAR',
          'TOTAL_CUSTOM_VALUE_IN_MICRO_US_DOLLAR',
          'TOTAL_ADD_TO_CART_VALUE_IN_MICRO_US_DOLLAR',
          'TOTAL_LEAD_VALUE_IN_MICRO_US_DOLLAR',
          'TOTAL_SEARCH_VALUE_IN_MICRO_US_DOLLAR',
          'TOTAL_WATCH_VIDEO_VALUE_IN_MICRO_US_DOLLAR',
          'TOTAL_VIEW_CATEGORY_VALUE_IN_MICRO_US_DOLLAR',
          'TOTAL_UNKNOWN_VALUE_IN_MICRO_US_DOLLAR',
          'TOTAL_PAGE_VISIT_QUANTITY',
          'TOTAL_SIGNUP_QUANTITY',
          'TOTAL_CHECKOUT_QUANTITY',
          'TOTAL_CUSTOM_QUANTITY',
          'TOTAL_ADD_TO_CART_QUANTITY',
          'TOTAL_LEAD_QUANTITY',
          'TOTAL_SEARCH_QUANTITY',
          'TOTAL_WATCH_VIDEO_QUANTITY',
          'TOTAL_VIEW_CATEGORY_QUANTITY',
          'TOTAL_APP_INSTALL_QUANTITY',
          'TOTAL_UNKNOWN_QUANTITY',
          'TOTAL_PAGE_VISIT_VALUE_IN_DOLLAR',
          'TOTAL_SIGNUP_VALUE_IN_DOLLAR',
          'TOTAL_CHECKOUT_VALUE_IN_DOLLAR',
          'TOTAL_CUSTOM_VALUE_IN_DOLLAR',
          'TOTAL_ADD_TO_CART_VALUE_IN_DOLLAR',
          'TOTAL_LEAD_VALUE_IN_DOLLAR',
          'TOTAL_SEARCH_VALUE_IN_DOLLAR',
          'TOTAL_WATCH_VIDEO_VALUE_IN_DOLLAR',
          'TOTAL_VIEW_CATEGORY_VALUE_IN_DOLLAR',
          'TOTAL_APP_INSTALL_VALUE_IN_DOLLAR',
          'TOTAL_UNKNOWN_VALUE_IN_DOLLAR',
          'PAGE_VISIT_COST_PER_ACTION',
          'SIGNUP_COST_PER_ACTION',
          'CHECKOUT_COST_PER_ACTION',
          'CUSTOM_COST_PER_ACTION',
          'ADD_TO_CART_COST_PER_ACTION',
          'LEAD_COST_PER_ACTION',
          'SEARCH_COST_PER_ACTION',
          'WATCH_VIDEO_COST_PER_ACTION',
          'VIEW_CATEGORY_COST_PER_ACTION',
          'APP_INSTALL_COST_PER_ACTION',
          'UNKNOWN_COST_PER_ACTION',
          'AD_GROUP_CPA_IN_MICRO_CURRENCY',
          'PAGE_VISIT_COST_PER_ACTION_IN_US_DOLLAR',
          'SIGNUP_COST_PER_ACTION_IN_US_DOLLAR',
          'CHECKOUT_COST_PER_ACTION_IN_US_DOLLAR',
          'CUSTOM_COST_PER_ACTION_IN_US_DOLLAR',
          'ADD_TO_CART_COST_PER_ACTION_IN_US_DOLLAR',
          'LEAD_COST_PER_ACTION_IN_US_DOLLAR',
          'SEARCH_COST_PER_ACTION_IN_US_DOLLAR',
          'WATCH_VIDEO_COST_PER_ACTION_IN_US_DOLLAR',
          'VIEW_CATEGORY_COST_PER_ACTION_IN_US_DOLLAR',
          'UNKNOWN_COST_PER_ACTION_IN_US_DOLLAR',
          'PAGE_VISIT_ROAS',
          'SIGNUP_ROAS',
          'CHECKOUT_ROAS',
          'CUSTOM_ROAS',
          'ADD_TO_CART_ROAS',
          'LEAD_ROAS',
          'SEARCH_ROAS',
          'WATCH_VIDEO_ROAS',
          'VIEW_CATEGORY_ROAS',
          'APP_INSTALL_ROAS',
          'UNKNOWN_ROAS',
          'ROAS',
          'CLICK_ROAS',
          'ENGAGEMENT_ROAS',
          'VIEW_ROAS',
          'HOUR',
          'BOARD_ENGAGEMENT',
          'BOARD_INSERTION',
          'BOARD_IMPRESSION',
          'BOARD_FOLLOW',
          'BOARD_SEND',
          'BOARD_HIDE',
          'PRODUCT_GROUP_CAMPAIGN_ID',
          'PRODUCT_GROUP_CAMPAIGN_NAME',
          'PRODUCT_GROUP_CAMPAIGN_ACTION_TYPE',
          'PRODUCT_GROUP_CAMPAIGN_STATUS',
          'PRODUCT_GROUP_CAMPAIGN_MANAGED_STATUS',
          'PRODUCT_GROUP_AD_GROUP_ID',
          'PRODUCT_GROUP_AD_GROUP_NAME',
          'PRODUCT_GROUP_AD_GROUP_STATUS',
          'PROMOTED_CATALOG_PRODUCT_GROUP_REFERENCE_ID',
          'PROMOTED_CATALOG_PRODUCT_GROUP_REFERENCE_NAME',
          'PROMOTED_CATALOG_PRODUCT_GROUP_ID',
          'PROMOTED_CATALOG_PRODUCT_GROUP_BID_IN_MICRO_CURRENCY',
          'PROMOTED_CATALOG_PRODUCT_GROUP_STATUS',
          'PROMOTED_CATALOG_PRODUCT_GROUP_ENTITY_STATUS',
          'PROMOTED_CATALOG_PRODUCT_GROUP_CAMPAIGN_ID',
          'PROMOTED_CATALOG_PRODUCT_GROUP_CAMPAIGN_NAME',
          'PROMOTED_CATALOG_PRODUCT_GROUP_CAMPAIGN_ACTION_TYPE',
          'PROMOTED_CATALOG_PRODUCT_GROUP_CAMPAIGN_STATUS',
          'PROMOTED_CATALOG_PRODUCT_GROUP_CAMPAIGN_MANAGED_STATUS',
          'PROMOTED_CATALOG_PRODUCT_GROUP_AD_GROUP_ID',
          'PROMOTED_CATALOG_PRODUCT_GROUP_AD_GROUP_NAME',
          'PROMOTED_CATALOG_PRODUCT_GROUP_AD_GROUP_STATUS',
          'PROMOTED_CATALOG_PRODUCT_GROUP_TRACKING_TEMPLATE_URL',
          'VIDEO_3SEC_VIEWS_1',
          'VIDEO_P0_COMPLETE_1',
          'VIDEO_P25_COMPLETE_1',
          'VIDEO_P50_COMPLETE_1',
          'VIDEO_P75_COMPLETE_1',
          'VIDEO_P95_COMPLETE_1',
          'VIDEO_P97_COMPLETE_1',
          'VIDEO_P100_COMPLETE_1',
          'VIDEO_P0_COMBINED_1',
          'VIDEO_P25_COMBINED_1',
          'VIDEO_P50_COMBINED_1',
          'VIDEO_P75_COMBINED_1',
          'VIDEO_P95_COMBINED_1',
          'VIDEO_P97_COMBINED_1',
          'VIDEO_P100_COMBINED_1',
          'VIDEO_AVG_WATCHTIME_1',
          'VIDEO_MRC_VIEWS_1',
          'VIDEO_VIEW_RATE_1',
          'VIDEO_3SEC_VIEWS_2',
          'VIDEO_P0_COMPLETE_2',
          'VIDEO_P25_COMPLETE_2',
          'VIDEO_P50_COMPLETE_2',
          'VIDEO_P75_COMPLETE_2',
          'VIDEO_P95_COMPLETE_2',
          'VIDEO_P97_COMPLETE_2',
          'VIDEO_P100_COMPLETE_2',
          'VIDEO_P0_COMBINED_2',
          'VIDEO_P25_COMBINED_2',
          'VIDEO_P50_COMBINED_2',
          'VIDEO_P75_COMBINED_2',
          'VIDEO_P95_COMBINED_2',
          'VIDEO_P97_COMBINED_2',
          'VIDEO_P100_COMBINED_2',
          'VIDEO_AVG_WATCHTIME_2',
          'VIDEO_MRC_VIEWS_2',
          'VIDEO_VIEW_RATE_2',
          'PAID_VIDEO_VIEW',
          'PAID_VIDEO_IMPRESSION',
          'PAID_VIDEO_VIEWABLE_RATE',
          'VIDEO_LENGTH',
          'CPV_IN_MICRO_DOLLAR',
          'CPV_IN_DOLLAR',
          'CP3SV_IN_MICRO_DOLLAR',
          'CP3SV_IN_DOLLAR',
          'ECPV_IN_MICRO_DOLLAR',
          'ECPV_IN_DOLLAR',
          'ECP3SV_IN_MICRO_DOLLAR',
          'ECP3SV_IN_DOLLAR',
          'CPCV_IN_DOLLAR',
          'CPCV_IN_MICRO_DOLLAR',
          'ECPCV_IN_DOLLAR',
          'ECPCV_IN_MICRO_DOLLAR',
          'CPCV_P95_IN_DOLLAR',
          'CPCV_P95_IN_MICRO_DOLLAR',
          'ECPCV_P95_IN_DOLLAR',
          'ECPCV_P95_IN_MICRO_DOLLAR',
          'TOTAL_VIDEO_3SEC_VIEWS',
          'TOTAL_VIDEO_P0_COMPLETE',
          'TOTAL_VIDEO_P25_COMPLETE',
          'TOTAL_VIDEO_P50_COMPLETE',
          'TOTAL_VIDEO_P75_COMPLETE',
          'TOTAL_VIDEO_P95_COMPLETE',
          'TOTAL_VIDEO_P97_COMPLETE',
          'TOTAL_VIDEO_P100_COMPLETE',
          'TOTAL_VIDEO_P0_COMBINED',
          'TOTAL_VIDEO_P25_COMBINED',
          'TOTAL_VIDEO_P50_COMBINED',
          'TOTAL_VIDEO_P75_COMBINED',
          'TOTAL_VIDEO_P95_COMBINED',
          'TOTAL_VIDEO_P97_COMBINED',
          'TOTAL_VIDEO_P100_COMBINED',
          'TOTAL_VIDEO_AVG_WATCHTIME',
          'TOTAL_VIDEO_MRC_VIEWS',
          'TOTAL_VIDEO_VIEW_RATE',
          'VIDEO_V50_WATCHTIME_1',
          'VIDEO_V50_WATCHTIME_2',
          'TOTAL_VIDEO_V50_WATCHTIME',
          'VIDEO_SUM_V50_WATCHTIME_IN_MILLISECOND_1',
          'VIDEO_SUM_V50_WATCHTIME_IN_MILLISECOND_2',
          'TOTAL_VIDEO_SUM_V50_WATCHTIME_IN_MILLISECOND',
          'VIDEO_SUM_V50_WATCHTIME_IN_SECOND_1',
          'VIDEO_SUM_V50_WATCHTIME_IN_SECOND_2',
          'TOTAL_VIDEO_SUM_V50_WATCHTIME_IN_SECOND',
          'VIDEO_AVG_WATCHTIME_IN_MILLISECOND_1',
          'VIDEO_AVG_WATCHTIME_IN_MILLISECOND_2',
          'TOTAL_VIDEO_AVG_WATCHTIME_IN_MILLISECOND',
          'VIDEO_AVG_WATCHTIME_IN_SECOND_1',
          'VIDEO_AVG_WATCHTIME_IN_SECOND_2',
          'TOTAL_VIDEO_AVG_WATCHTIME_IN_SECOND',
          'DELIVERY_STATUS_NO_FANOUT',
          'DELIVERY_STATUS_WITH_FANOUT',
          'KEYWORD_COMPETITION_BAND',
          'KEYWORD_QUERY_VOLUME',
          'KEYWORD_VALUE',
          'KEYWORD_MATCH_TYPE',
          'KEYWORD_BID_IN_MICRO_CURRENCY',
          'KEYWORD_USER_QUERY',
          'KEYWORD_SQR_KEYWORD_VALUE',
          'KEYWORD_AD_GROUP_ID',
          'KEYWORD_AD_GROUP_NAME',
          'KEYWORD_CAMPAIGN_ID',
          'KEYWORD_CAMPAIGN_NAME',
          'KEYWORD_SEARCH_TERM_AD_GROUP_ID',
          'KEYWORD_SEARCH_TERM_AD_GROUP_NAME',
          'KEYWORD_SEARCH_TERM_CAMPAIGN_ID',
          'KEYWORD_SEARCH_TERM_CAMPAIGN_NAME',
          'NEGATIVE_KEYWORD_AD_GROUP_ID',
          'NEGATIVE_KEYWORD_AD_GROUP_NAME',
          'NEGATIVE_KEYWORD_CAMPAIGN_ID',
          'NEGATIVE_KEYWORD_CAMPAIGN_NAME',
          'ONE_TAP_V2_WEBSITE_VIEW_1',
          'ONE_TAP_V2_WEBSITE_VIEW_2',
          'TOTAL_ONE_TAP_V2_WEBSITE_VIEW',
          'ONE_TAP_V2_WEBSITE_VIEW_USER_1',
          'ONE_TAP_V2_WEBSITE_VIEW_USER_2',
          'TOTAL_LANDING_PAGE_VIEWS',
          'LANDING_PAGE_VIEWS_1',
          'LANDING_PAGE_VIEWS_2',
          'COST_PER_LANDING_PAGE_VIEW',
          'LANDING_PAGE_VIEW_RATE',
          'TOTAL_DESTINATION_VIEWS',
          'DESTINATION_VIEWS_1',
          'DESTINATION_VIEWS_2',
          'COST_PER_DESTINATION_VIEW_IN_DOLLAR',
          'COST_PER_DESTINATION_VIEW_IN_MICRO_DOLLAR',
          'DESTINATION_VIEW_RATE',
          'CAROUSEL_SLOT_INDEX',
          'CAROUSEL_ID',
          'CAROUSEL_SLOT_PROMOTION_ID',
          'CAROUSEL_SLOT_IMPRESSION_1',
          'CAROUSEL_SLOT_IMPRESSION_2',
          'TOTAL_CAROUSEL_SLOT_IMPRESSION',
          'CAROUSEL_SLOT_IMPRESSION_USER_1',
          'CAROUSEL_SLOT_IMPRESSION_USER_2',
          'CAROUSEL_SLOT_CLICKTHROUGH_1',
          'CAROUSEL_SLOT_CLICKTHROUGH_2',
          'TOTAL_CAROUSEL_SLOT_CLICKTHROUGH',
          'CAROUSEL_SLOT_CLICKTHROUGH_USER_1',
          'CAROUSEL_SLOT_CLICKTHROUGH_USER_2',
          'CAROUSEL_SLOT_SIDESWIPE_1',
          'CAROUSEL_SLOT_SIDESWIPE_2',
          'TOTAL_CAROUSEL_SLOT_SIDESWIPE',
          'CAROUSEL_SLOT_SIDESWIPE_USER_1',
          'CAROUSEL_SLOT_SIDESWIPE_USER_2',
          'CAROUSEL_SLOT_VIEW_WEBSITE_1',
          'CAROUSEL_SLOT_VIEW_WEBSITE_2',
          'TOTAL_CAROUSEL_SLOT_VIEW_WEBSITE',
          'CAROUSEL_SLOT_VIEW_WEBSITE_USER_1',
          'CAROUSEL_SLOT_VIEW_WEBSITE_USER_2',
          'COLLECTION_PIN_ITEM_IMPRESSION_1',
          'COLLECTION_PIN_ITEM_IMPRESSION_2',
          'TOTAL_COLLECTION_PIN_ITEM_IMPRESSION',
          'COLLECTION_PIN_ITEM_CLICKTHROUGH_1',
          'COLLECTION_PIN_ITEM_CLICKTHROUGH_2',
          'TOTAL_COLLECTION_PIN_ITEM_CLICKTHROUGH',
          'HOLDOUT_EXPERIMENT',
          'AD_GROUP_HOLDOUT_EXPERIMENT',
          'PIN_PROMOTION_HOLDOUT_EXPERIMENT',
          'MULTI_OBJECTIVE_RESULT',
          'MULTI_OBJECTIVE_COST',
          'MULTI_OBJECTIVE_RESULT_DESCRIPTION',
          'MULTI_OBJECTIVE_COST_DESCRIPTION',
          'DATE_RANGE',
          'DATE_RANGE_START',
          'DATE_RANGE_END',
          'REPORT_DATE_START',
          'REPORT_DATE_END',
          'PINNER_LIST_NAME',
          'PINNER_LIST_TYPE',
          'ORDER_VALUE',
          'ORDER_QUANTITY',
          'ADVERTISER_NAME',
          'ADVERTISER_CURRENCY',
          'TOTAL_REPIN_RATE',
          'SPEND_YESTERDAY_IN_DOLLAR',
          'PIN_PROMOTION_REJECTION_LABELS',
          'PIN_PROMOTION_DESTINATION_URL',
          'VIDEO_COMPLETION_RATE',
          'CAMPAIGN_BOOKING_REFERENCE',
          'WEB_CHECKOUT_COST_PER_ACTION',
          'WEB_CHECKOUT_ROAS',
          'TOTAL_WEB_CHECKOUT',
          'TOTAL_WEB_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_CHECKOUT_VALUE_IN_DOLLAR',
          'TOTAL_WEB_CLICK_CHECKOUT',
          'TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_CLICK_CHECKOUT_VALUE_IN_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_CHECKOUT',
          'TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_CHECKOUT_VALUE_IN_DOLLAR',
          'TOTAL_WEB_VIEW_CHECKOUT',
          'TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_VIEW_CHECKOUT_VALUE_IN_DOLLAR',
          'INAPP_CHECKOUT_COST_PER_ACTION',
          'INAPP_CHECKOUT_ROAS',
          'TOTAL_INAPP_CHECKOUT',
          'TOTAL_INAPP_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_CHECKOUT_VALUE_IN_DOLLAR',
          'TOTAL_INAPP_CLICK_CHECKOUT',
          'TOTAL_INAPP_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_CLICK_CHECKOUT_VALUE_IN_DOLLAR',
          'TOTAL_INAPP_ENGAGEMENT_CHECKOUT',
          'TOTAL_INAPP_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_ENGAGEMENT_CHECKOUT_VALUE_IN_DOLLAR',
          'TOTAL_INAPP_VIEW_CHECKOUT',
          'TOTAL_INAPP_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_VIEW_CHECKOUT_VALUE_IN_DOLLAR',
          'OFFLINE_CHECKOUT_COST_PER_ACTION',
          'OFFLINE_CHECKOUT_ROAS',
          'TOTAL_OFFLINE_CHECKOUT',
          'TOTAL_OFFLINE_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_CHECKOUT_VALUE_IN_DOLLAR',
          'TOTAL_OFFLINE_CLICK_CHECKOUT',
          'TOTAL_OFFLINE_CLICK_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_CLICK_CHECKOUT_VALUE_IN_DOLLAR',
          'TOTAL_OFFLINE_ENGAGEMENT_CHECKOUT',
          'TOTAL_OFFLINE_ENGAGEMENT_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_ENGAGEMENT_CHECKOUT_VALUE_IN_DOLLAR',
          'TOTAL_OFFLINE_VIEW_CHECKOUT',
          'TOTAL_OFFLINE_VIEW_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_VIEW_CHECKOUT_VALUE_IN_DOLLAR',
          'PINTEREST_CHECKOUT_COST_PER_ACTION',
          'PINTEREST_CHECKOUT_ROAS',
          'TOTAL_PINTEREST_CHECKOUT',
          'TOTAL_PINTEREST_CHECKOUT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_PINTEREST_CHECKOUT_VALUE_IN_DOLLAR',
          'WEB_ADD_TO_CART_COST_PER_ACTION',
          'WEB_ADD_TO_CART_ROAS',
          'TOTAL_WEB_ADD_TO_CART',
          'TOTAL_WEB_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_ADD_TO_CART_VALUE_IN_DOLLAR',
          'TOTAL_WEB_CLICK_ADD_TO_CART',
          'TOTAL_WEB_CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_CLICK_ADD_TO_CART_VALUE_IN_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_ADD_TO_CART',
          'TOTAL_WEB_ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_VIEW_ADD_TO_CART',
          'TOTAL_WEB_VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_VIEW_ADD_TO_CART_VALUE_IN_DOLLAR',
          'INAPP_ADD_TO_CART_COST_PER_ACTION',
          'INAPP_ADD_TO_CART_ROAS',
          'TOTAL_INAPP_ADD_TO_CART',
          'TOTAL_INAPP_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_ADD_TO_CART_VALUE_IN_DOLLAR',
          'TOTAL_INAPP_CLICK_ADD_TO_CART',
          'TOTAL_INAPP_CLICK_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_CLICK_ADD_TO_CART_VALUE_IN_DOLLAR',
          'TOTAL_INAPP_ENGAGEMENT_ADD_TO_CART',
          'TOTAL_INAPP_ENGAGEMENT_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_ENGAGEMENT_ADD_TO_CART_VALUE_IN_DOLLAR',
          'TOTAL_INAPP_VIEW_ADD_TO_CART',
          'TOTAL_INAPP_VIEW_ADD_TO_CART_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_VIEW_ADD_TO_CART_VALUE_IN_DOLLAR',
          'WEB_PAGE_VISIT_COST_PER_ACTION',
          'WEB_PAGE_VISIT_ROAS',
          'TOTAL_WEB_PAGE_VISIT',
          'TOTAL_WEB_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_PAGE_VISIT_VALUE_IN_DOLLAR',
          'TOTAL_WEB_CLICK_PAGE_VISIT',
          'TOTAL_WEB_CLICK_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_CLICK_PAGE_VISIT_VALUE_IN_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_PAGE_VISIT',
          'TOTAL_WEB_ENGAGEMENT_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_PAGE_VISIT_VALUE_IN_DOLLAR',
          'TOTAL_WEB_VIEW_PAGE_VISIT',
          'TOTAL_WEB_VIEW_PAGE_VISIT_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_VIEW_PAGE_VISIT_VALUE_IN_DOLLAR',
          'WEB_SIGNUP_COST_PER_ACTION',
          'WEB_SIGNUP_ROAS',
          'TOTAL_WEB_SIGNUP',
          'TOTAL_WEB_SIGNUP_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_SIGNUP_VALUE_IN_DOLLAR',
          'TOTAL_WEB_CLICK_SIGNUP',
          'TOTAL_WEB_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_CLICK_SIGNUP_VALUE_IN_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_SIGNUP',
          'TOTAL_WEB_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_SIGNUP_VALUE_IN_DOLLAR',
          'TOTAL_WEB_VIEW_SIGNUP',
          'TOTAL_WEB_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_VIEW_SIGNUP_VALUE_IN_DOLLAR',
          'INAPP_SIGNUP_COST_PER_ACTION',
          'INAPP_SIGNUP_ROAS',
          'TOTAL_INAPP_SIGNUP',
          'TOTAL_INAPP_SIGNUP_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_SIGNUP_VALUE_IN_DOLLAR',
          'TOTAL_INAPP_CLICK_SIGNUP',
          'TOTAL_INAPP_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_CLICK_SIGNUP_VALUE_IN_DOLLAR',
          'TOTAL_INAPP_ENGAGEMENT_SIGNUP',
          'TOTAL_INAPP_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_ENGAGEMENT_SIGNUP_VALUE_IN_DOLLAR',
          'TOTAL_INAPP_VIEW_SIGNUP',
          'TOTAL_INAPP_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_VIEW_SIGNUP_VALUE_IN_DOLLAR',
          'OFFLINE_SIGNUP_COST_PER_ACTION',
          'OFFLINE_SIGNUP_ROAS',
          'TOTAL_OFFLINE_SIGNUP',
          'TOTAL_OFFLINE_SIGNUP_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_SIGNUP_VALUE_IN_DOLLAR',
          'TOTAL_OFFLINE_CLICK_SIGNUP',
          'TOTAL_OFFLINE_CLICK_SIGNUP_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_CLICK_SIGNUP_VALUE_IN_DOLLAR',
          'TOTAL_OFFLINE_ENGAGEMENT_SIGNUP',
          'TOTAL_OFFLINE_ENGAGEMENT_SIGNUP_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_ENGAGEMENT_SIGNUP_VALUE_IN_DOLLAR',
          'TOTAL_OFFLINE_VIEW_SIGNUP',
          'TOTAL_OFFLINE_VIEW_SIGNUP_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_VIEW_SIGNUP_VALUE_IN_DOLLAR',
          'WEB_WATCH_VIDEO_COST_PER_ACTION',
          'WEB_WATCH_VIDEO_ROAS',
          'TOTAL_WEB_WATCH_VIDEO',
          'TOTAL_WEB_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_WATCH_VIDEO_VALUE_IN_DOLLAR',
          'TOTAL_WEB_CLICK_WATCH_VIDEO',
          'TOTAL_WEB_CLICK_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_CLICK_WATCH_VIDEO_VALUE_IN_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_WATCH_VIDEO',
          'TOTAL_WEB_ENGAGEMENT_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_WATCH_VIDEO_VALUE_IN_DOLLAR',
          'TOTAL_WEB_VIEW_WATCH_VIDEO',
          'TOTAL_WEB_VIEW_WATCH_VIDEO_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_VIEW_WATCH_VIDEO_VALUE_IN_DOLLAR',
          'WEB_LEAD_COST_PER_ACTION',
          'WEB_LEAD_ROAS',
          'TOTAL_WEB_LEAD',
          'TOTAL_WEB_LEAD_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_LEAD_VALUE_IN_DOLLAR',
          'TOTAL_WEB_CLICK_LEAD',
          'TOTAL_WEB_CLICK_LEAD_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_CLICK_LEAD_VALUE_IN_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_LEAD',
          'TOTAL_WEB_ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_LEAD_VALUE_IN_DOLLAR',
          'TOTAL_WEB_VIEW_LEAD',
          'TOTAL_WEB_VIEW_LEAD_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_VIEW_LEAD_VALUE_IN_DOLLAR',
          'OFFLINE_LEAD_COST_PER_ACTION',
          'OFFLINE_LEAD_ROAS',
          'TOTAL_OFFLINE_LEAD',
          'TOTAL_OFFLINE_LEAD_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_LEAD_VALUE_IN_DOLLAR',
          'TOTAL_OFFLINE_CLICK_LEAD',
          'TOTAL_OFFLINE_CLICK_LEAD_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_CLICK_LEAD_VALUE_IN_DOLLAR',
          'TOTAL_OFFLINE_ENGAGEMENT_LEAD',
          'TOTAL_OFFLINE_ENGAGEMENT_LEAD_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_ENGAGEMENT_LEAD_VALUE_IN_DOLLAR',
          'TOTAL_OFFLINE_VIEW_LEAD',
          'TOTAL_OFFLINE_VIEW_LEAD_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_VIEW_LEAD_VALUE_IN_DOLLAR',
          'WEB_SEARCH_COST_PER_ACTION',
          'WEB_SEARCH_ROAS',
          'TOTAL_WEB_SEARCH',
          'TOTAL_WEB_SEARCH_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_SEARCH_VALUE_IN_DOLLAR',
          'TOTAL_WEB_CLICK_SEARCH',
          'TOTAL_WEB_CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_CLICK_SEARCH_VALUE_IN_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_SEARCH',
          'TOTAL_WEB_ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_SEARCH_VALUE_IN_DOLLAR',
          'TOTAL_WEB_VIEW_SEARCH',
          'TOTAL_WEB_VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_VIEW_SEARCH_VALUE_IN_DOLLAR',
          'INAPP_SEARCH_COST_PER_ACTION',
          'INAPP_SEARCH_ROAS',
          'TOTAL_INAPP_SEARCH',
          'TOTAL_INAPP_SEARCH_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_SEARCH_VALUE_IN_DOLLAR',
          'TOTAL_INAPP_CLICK_SEARCH',
          'TOTAL_INAPP_CLICK_SEARCH_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_CLICK_SEARCH_VALUE_IN_DOLLAR',
          'TOTAL_INAPP_ENGAGEMENT_SEARCH',
          'TOTAL_INAPP_ENGAGEMENT_SEARCH_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_ENGAGEMENT_SEARCH_VALUE_IN_DOLLAR',
          'TOTAL_INAPP_VIEW_SEARCH',
          'TOTAL_INAPP_VIEW_SEARCH_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_VIEW_SEARCH_VALUE_IN_DOLLAR',
          'WEB_VIEW_CATEGORY_COST_PER_ACTION',
          'WEB_VIEW_CATEGORY_ROAS',
          'TOTAL_WEB_VIEW_CATEGORY',
          'TOTAL_WEB_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_VIEW_CATEGORY_VALUE_IN_DOLLAR',
          'TOTAL_WEB_CLICK_VIEW_CATEGORY',
          'TOTAL_WEB_CLICK_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_CLICK_VIEW_CATEGORY_VALUE_IN_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_VIEW_CATEGORY',
          'TOTAL_WEB_ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_VIEW_CATEGORY_VALUE_IN_DOLLAR',
          'TOTAL_WEB_VIEW_VIEW_CATEGORY',
          'TOTAL_WEB_VIEW_VIEW_CATEGORY_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_VIEW_VIEW_CATEGORY_VALUE_IN_DOLLAR',
          'WEB_CUSTOM_COST_PER_ACTION',
          'WEB_CUSTOM_ROAS',
          'TOTAL_WEB_CUSTOM',
          'TOTAL_WEB_CUSTOM_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_CUSTOM_VALUE_IN_DOLLAR',
          'TOTAL_WEB_CLICK_CUSTOM',
          'TOTAL_WEB_CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_CLICK_CUSTOM_VALUE_IN_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_CUSTOM',
          'TOTAL_WEB_ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_CUSTOM_VALUE_IN_DOLLAR',
          'TOTAL_WEB_VIEW_CUSTOM',
          'TOTAL_WEB_VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_VIEW_CUSTOM_VALUE_IN_DOLLAR',
          'OFFLINE_CUSTOM_COST_PER_ACTION',
          'OFFLINE_CUSTOM_ROAS',
          'TOTAL_OFFLINE_CUSTOM',
          'TOTAL_OFFLINE_CUSTOM_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_CUSTOM_VALUE_IN_DOLLAR',
          'TOTAL_OFFLINE_CLICK_CUSTOM',
          'TOTAL_OFFLINE_CLICK_CUSTOM_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_CLICK_CUSTOM_VALUE_IN_DOLLAR',
          'TOTAL_OFFLINE_ENGAGEMENT_CUSTOM',
          'TOTAL_OFFLINE_ENGAGEMENT_CUSTOM_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_ENGAGEMENT_CUSTOM_VALUE_IN_DOLLAR',
          'TOTAL_OFFLINE_VIEW_CUSTOM',
          'TOTAL_OFFLINE_VIEW_CUSTOM_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_VIEW_CUSTOM_VALUE_IN_DOLLAR',
          'WEB_UNKNOWN_COST_PER_ACTION',
          'WEB_UNKNOWN_ROAS',
          'TOTAL_WEB_UNKNOWN',
          'TOTAL_WEB_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_UNKNOWN_VALUE_IN_DOLLAR',
          'TOTAL_WEB_CLICK_UNKNOWN',
          'TOTAL_WEB_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_CLICK_UNKNOWN_VALUE_IN_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_UNKNOWN',
          'TOTAL_WEB_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_ENGAGEMENT_UNKNOWN_VALUE_IN_DOLLAR',
          'TOTAL_WEB_VIEW_UNKNOWN',
          'TOTAL_WEB_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_WEB_VIEW_UNKNOWN_VALUE_IN_DOLLAR',
          'INAPP_UNKNOWN_COST_PER_ACTION',
          'INAPP_UNKNOWN_ROAS',
          'TOTAL_INAPP_UNKNOWN',
          'TOTAL_INAPP_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_UNKNOWN_VALUE_IN_DOLLAR',
          'TOTAL_INAPP_CLICK_UNKNOWN',
          'TOTAL_INAPP_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_CLICK_UNKNOWN_VALUE_IN_DOLLAR',
          'TOTAL_INAPP_ENGAGEMENT_UNKNOWN',
          'TOTAL_INAPP_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_ENGAGEMENT_UNKNOWN_VALUE_IN_DOLLAR',
          'TOTAL_INAPP_VIEW_UNKNOWN',
          'TOTAL_INAPP_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_VIEW_UNKNOWN_VALUE_IN_DOLLAR',
          'OFFLINE_UNKNOWN_COST_PER_ACTION',
          'OFFLINE_UNKNOWN_ROAS',
          'TOTAL_OFFLINE_UNKNOWN',
          'TOTAL_OFFLINE_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_UNKNOWN_VALUE_IN_DOLLAR',
          'TOTAL_OFFLINE_CLICK_UNKNOWN',
          'TOTAL_OFFLINE_CLICK_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_CLICK_UNKNOWN_VALUE_IN_DOLLAR',
          'TOTAL_OFFLINE_ENGAGEMENT_UNKNOWN',
          'TOTAL_OFFLINE_ENGAGEMENT_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_ENGAGEMENT_UNKNOWN_VALUE_IN_DOLLAR',
          'TOTAL_OFFLINE_VIEW_UNKNOWN',
          'TOTAL_OFFLINE_VIEW_UNKNOWN_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_OFFLINE_VIEW_UNKNOWN_VALUE_IN_DOLLAR',
          'INAPP_APP_INSTALL_COST_PER_ACTION',
          'INAPP_APP_INSTALL_ROAS',
          'TOTAL_INAPP_APP_INSTALL',
          'TOTAL_INAPP_APP_INSTALL_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_APP_INSTALL_VALUE_IN_DOLLAR',
          'TOTAL_INAPP_CLICK_APP_INSTALL',
          'TOTAL_INAPP_CLICK_APP_INSTALL_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_CLICK_APP_INSTALL_VALUE_IN_DOLLAR',
          'TOTAL_INAPP_ENGAGEMENT_APP_INSTALL',
          'TOTAL_INAPP_ENGAGEMENT_APP_INSTALL_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_ENGAGEMENT_APP_INSTALL_VALUE_IN_DOLLAR',
          'TOTAL_INAPP_VIEW_APP_INSTALL',
          'TOTAL_INAPP_VIEW_APP_INSTALL_VALUE_IN_MICRO_DOLLAR',
          'TOTAL_INAPP_VIEW_APP_INSTALL_VALUE_IN_DOLLAR',
          'IDEA_PIN_PAGE_FORWARD_1',
          'IDEA_PIN_PAGE_FORWARD_2',
          'IDEA_PIN_PAGE_BACKWARD_1',
          'IDEA_PIN_PAGE_BACKWARD_2',
          'TOTAL_IDEA_PIN_PAGE_FORWARD',
          'TOTAL_IDEA_PIN_PAGE_BACKWARD',
          'IDEA_PIN_PRODUCT_TAG_VISIT_1',
          'IDEA_PIN_PRODUCT_TAG_VISIT_2',
          'TOTAL_IDEA_PIN_PRODUCT_TAG_VISIT',
          'CPM_IN_US_DOLLAR',
          'ECPC_IN_US_DOLLAR',
          'LEADS',
          'COST_PER_LEAD',
          'QUIZ_STARTED',
          'QUIZ_COMPLETED',
          'QUIZ_PIN_RESULT_OPEN',
          'QUIZ_COMPLETION_RATE',
          'SHOWCASE_PIN_CLICKTHROUGH',
          'SHOWCASE_SUBPAGE_CLICKTHROUGH',
          'SHOWCASE_SUBPIN_CLICKTHROUGH',
          'SHOWCASE_SUBPAGE_IMPRESSION',
          'SHOWCASE_SUBPIN_IMPRESSION',
          'SHOWCASE_SUBPAGE_SWIPE_LEFT',
          'SHOWCASE_SUBPAGE_SWIPE_RIGHT',
          'SHOWCASE_SUBPIN_SWIPE_LEFT',
          'SHOWCASE_SUBPIN_SWIPE_RIGHT',
          'SHOWCASE_SUBPAGE_REPIN',
          'SHOWCASE_SUBPIN_REPIN',
          'SHOWCASE_SUBPAGE_CLOSEUP',
          'SHOWCASE_CARD_THUMBNAIL_SWIPE_FORWARD',
          'SHOWCASE_CARD_THUMBNAIL_SWIPE_BACKWARD',
          '_SHOWCASE_SUBPAGE_CLOSEUP_INTERNAL',
          'SHOWCASE_CARD_LANDING',
          'SHOWCASE_AVERAGE_SUBPAGE_CLOSEUP_PER_SESSION',
          'TOTAL_CHECKOUT_CONVERSION_RATE',
          'TOTAL_VIEW_CATEGORY_CONVERSION_RATE',
          'TOTAL_ADD_TO_CART_CONVERSION_RATE',
          'TOTAL_SIGNUP_CONVERSION_RATE',
          'TOTAL_PAGE_VISIT_CONVERSION_RATE',
          'TOTAL_LEAD_CONVERSION_RATE',
          'TOTAL_SEARCH_CONVERSION_RATE',
          'TOTAL_WATCH_VIDEO_CONVERSION_RATE',
          'TOTAL_UNKNOWN_CONVERSION_RATE',
          'TOTAL_CUSTOM_CONVERSION_RATE',
          'STANDARD_AD_FEED_ITEM_ID',
          'IS_STANDARD_FEED_AD',
          'TARGETING_GENDER',
          'TARGETING_CREATIVE_TYPE',
          'TARGETING_COUNTRY',
          'TARGETING_LOCATION',
          'TARGETING_APPTYPE',
          'TARGETING_LOCATION_CODE',
          'TARGETING_MEDIA_TYPE',
          'TOTAL_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_WEB_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_INAPP_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_OFFLINE_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_CONVERSION_PRODUCT_VALUE',
          'TOTAL_WEB_CONVERSION_PRODUCT_VALUE',
          'TOTAL_INAPP_CONVERSION_PRODUCT_VALUE',
          'TOTAL_OFFLINE_CONVERSION_PRODUCT_VALUE',
          'TOTAL_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_WEB_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_INAPP_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_OFFLINE_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_WEB_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_INAPP_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_OFFLINE_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_WEB_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_INAPP_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_OFFLINE_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_CHECKOUT_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_CHECKOUT_CONVERSION_PRODUCT_VALUE',
          'TOTAL_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_WEB_CHECKOUT_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_WEB_CHECKOUT_CONVERSION_PRODUCT_VALUE',
          'TOTAL_WEB_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_WEB_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_WEB_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_INAPP_CHECKOUT_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_INAPP_CHECKOUT_CONVERSION_PRODUCT_VALUE',
          'TOTAL_INAPP_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_INAPP_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_INAPP_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_OFFLINE_CHECKOUT_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_OFFLINE_CHECKOUT_CONVERSION_PRODUCT_VALUE',
          'TOTAL_OFFLINE_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_OFFLINE_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_OFFLINE_CHECKOUT_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_ADD_TO_CART_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_ADD_TO_CART_CONVERSION_PRODUCT_VALUE',
          'TOTAL_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_WEB_ADD_TO_CART_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_WEB_ADD_TO_CART_CONVERSION_PRODUCT_VALUE',
          'TOTAL_WEB_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_WEB_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_WEB_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_INAPP_ADD_TO_CART_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_INAPP_ADD_TO_CART_CONVERSION_PRODUCT_VALUE',
          'TOTAL_INAPP_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_INAPP_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_INAPP_ADD_TO_CART_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_PAGE_VISIT_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_PAGE_VISIT_CONVERSION_PRODUCT_VALUE',
          'TOTAL_PAGE_VISIT_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_PAGE_VISIT_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_PAGE_VISIT_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_WEB_PAGE_VISIT_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_WEB_PAGE_VISIT_CONVERSION_PRODUCT_VALUE',
          'TOTAL_WEB_PAGE_VISIT_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_WEB_PAGE_VISIT_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_WEB_PAGE_VISIT_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_SIGNUP_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_SIGNUP_CONVERSION_PRODUCT_VALUE',
          'TOTAL_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_WEB_SIGNUP_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_WEB_SIGNUP_CONVERSION_PRODUCT_VALUE',
          'TOTAL_WEB_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_WEB_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_WEB_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_INAPP_SIGNUP_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_INAPP_SIGNUP_CONVERSION_PRODUCT_VALUE',
          'TOTAL_INAPP_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_INAPP_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_INAPP_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_OFFLINE_SIGNUP_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_OFFLINE_SIGNUP_CONVERSION_PRODUCT_VALUE',
          'TOTAL_OFFLINE_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_OFFLINE_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_OFFLINE_SIGNUP_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_WATCH_VIDEO_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE',
          'TOTAL_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_WEB_WATCH_VIDEO_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_WEB_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE',
          'TOTAL_WEB_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_WEB_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_WEB_WATCH_VIDEO_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_LEAD_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_LEAD_CONVERSION_PRODUCT_VALUE',
          'TOTAL_LEAD_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_LEAD_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_LEAD_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_WEB_LEAD_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_WEB_LEAD_CONVERSION_PRODUCT_VALUE',
          'TOTAL_WEB_LEAD_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_WEB_LEAD_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_WEB_LEAD_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_OFFLINE_LEAD_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_OFFLINE_LEAD_CONVERSION_PRODUCT_VALUE',
          'TOTAL_OFFLINE_LEAD_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_OFFLINE_LEAD_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_OFFLINE_LEAD_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_SEARCH_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_SEARCH_CONVERSION_PRODUCT_VALUE',
          'TOTAL_SEARCH_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_SEARCH_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_SEARCH_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_WEB_SEARCH_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_WEB_SEARCH_CONVERSION_PRODUCT_VALUE',
          'TOTAL_WEB_SEARCH_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_WEB_SEARCH_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_WEB_SEARCH_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_INAPP_SEARCH_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_INAPP_SEARCH_CONVERSION_PRODUCT_VALUE',
          'TOTAL_INAPP_SEARCH_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_INAPP_SEARCH_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_INAPP_SEARCH_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_VIEW_CATEGORY_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE',
          'TOTAL_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_WEB_VIEW_CATEGORY_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_WEB_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE',
          'TOTAL_WEB_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_WEB_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_WEB_VIEW_CATEGORY_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_CUSTOM_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_CUSTOM_CONVERSION_PRODUCT_VALUE',
          'TOTAL_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_WEB_CUSTOM_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_WEB_CUSTOM_CONVERSION_PRODUCT_VALUE',
          'TOTAL_WEB_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_WEB_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_WEB_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_OFFLINE_CUSTOM_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_OFFLINE_CUSTOM_CONVERSION_PRODUCT_VALUE',
          'TOTAL_OFFLINE_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_OFFLINE_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_OFFLINE_CUSTOM_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_UNKNOWN_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_UNKNOWN_CONVERSION_PRODUCT_VALUE',
          'TOTAL_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_WEB_UNKNOWN_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_WEB_UNKNOWN_CONVERSION_PRODUCT_VALUE',
          'TOTAL_WEB_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_WEB_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_WEB_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_INAPP_UNKNOWN_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_INAPP_UNKNOWN_CONVERSION_PRODUCT_VALUE',
          'TOTAL_INAPP_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_INAPP_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_INAPP_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_OFFLINE_UNKNOWN_CONVERSION_PRODUCT_QUANTITY',
          'TOTAL_OFFLINE_UNKNOWN_CONVERSION_PRODUCT_VALUE',
          'TOTAL_OFFLINE_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_UNITS',
          'TOTAL_OFFLINE_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_USD',
          'TOTAL_OFFLINE_UNKNOWN_CONVERSION_PRODUCT_VALUE_IN_MICRO_USD',
          'TOTAL_CHECKOUT_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_WEB_CHECKOUT_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_INAPP_CHECKOUT_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_OFFLINE_CHECKOUT_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_ADD_TO_CART_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_WEB_ADD_TO_CART_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_INAPP_ADD_TO_CART_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_PAGE_VISIT_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_WEB_PAGE_VISIT_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_SIGNUP_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_WEB_SIGNUP_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_INAPP_SIGNUP_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_OFFLINE_SIGNUP_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_WATCH_VIDEO_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_WEB_WATCH_VIDEO_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_LEAD_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_WEB_LEAD_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_OFFLINE_LEAD_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_SEARCH_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_WEB_SEARCH_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_INAPP_SEARCH_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_VIEW_CATEGORY_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_WEB_VIEW_CATEGORY_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_CUSTOM_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_WEB_CUSTOM_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_OFFLINE_CUSTOM_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_UNKNOWN_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_WEB_UNKNOWN_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_INAPP_UNKNOWN_CONVERSION_PRODUCT_COUNT_UNIQUE',
          'TOTAL_OFFLINE_UNKNOWN_CONVERSION_PRODUCT_COUNT_UNIQUE',
        ],
      },
      type: 'array',
    },
    granularity: {
      $ref: '#/components/schemas/Granularity',
    },
    view_window_days: {
      description: 'The length of the sliding window over which view conversions will be attributed',
      example: 7,
      type: 'number',
    },
    click_window_days: {
      description: 'The length of the sliding window over which click conversions will be attributed',
      example: 7,
      type: 'number',
    },
    engagement_window_days: {
      description: 'The length of the sliding window over which engagement conversions will be attributed',
      example: 7,
      type: 'number',
    },
    conversion_report_time_type: {
      description: 'Conversion report time type',
      enum: ['TIME_OF_AD_ACTION', 'TIME_OF_CONVERSION'],
      example: 'TIME_OF_AD_ACTION',
      type: 'string',
    },
    filters_json: {
      description:
        'A JSON representation of any filters to be applied before returning report data. Each filter object should contain all of the following fields:<br> "field": The column name<br> "operator": The operator. Allowed operators: ["=", "!=", "in", "not_in", "~", ">", "<", "contains_substring"]<br> "value": A single value or a list of values',
      example: '[{"field": "SPEND_IN_DOLLAR", "operator": "=", "value": 100}]',
      nullable: true,
      type: 'string',
    },
    is_owned_by_user: {
      description: 'A boolean value that indicates if the user owns the template',
      example: true,
      type: 'boolean',
    },
    is_scheduled: {
      description: 'A boolean value that indicates if this template has been used to create a scheduled report',
      example: true,
      type: 'boolean',
    },
    creation_source: {
      description: 'The surface used to create this template',
      enum: ['ADS_API', 'ADS_MANAGER_REPORTING_PAGE', 'ADS_MANAGER_REPORT_BUILDER'],
      example: 'ADS_MANAGER_REPORT_BUILDER',
      type: 'string',
    },
    is_deleted: {
      description: 'A boolean that indicates if the template has been deleted',
      example: false,
      nullable: true,
      type: 'boolean',
    },
    updated_time: {
      description: 'Time of last update in seconds since Unix epoch',
      example: 1432744744,
      type: 'number',
    },
    custom_column_ids: {
      description: 'A list of custom column IDs',
      example: ['1597252063'],
      items: {
        $ref: '#/components/schemas/CustomColumnId',
      },
      nullable: true,
      type: 'array',
    },
    type: {
      allOf: [
        {
          description: 'Reporting template type',
          enum: ['UNSPECIFIED', 'BULK', 'OVERVIEW', 'TABLE'],
          example: 'BULK',
          type: 'string',
        },
      ],
      description: 'Type of the template',
      example: 'BULK',
      type: 'string',
    },
    ingestion_sources: {
      description: 'The filter on the conversion ingestion source method for conversion metrics',
      items: {
        description: 'The source of conversion events ingestion',
        enum: ['TAG', 'MMP', 'FILE_UPLOAD', 'CONVERSIONS_API', 'NATIVE'],
        example: 'CONVERSIONS_API',
        type: 'string',
      },
      nullable: true,
      type: 'array',
    },
  },
} as const;

export const TermsOfServiceSchema = {
  example: {
    has_accepted: true,
    html: 'example test',
    id: '2650449554526',
    ad_account_id: '549755885175',
  },
  properties: {
    id: {
      description: 'The ID of the terms of service',
      example: '2650449554526',
      title: 'id',
      type: 'string',
    },
    html: {
      description: 'The terms of service content',
      example: 'example test',
      nullable: true,
      title: 'html',
      type: 'string',
    },
    has_accepted: {
      description: 'Whether the ad account has accepted terms of service.',
      example: true,
      title: 'hasAccepted',
      type: 'boolean',
    },
    ad_account_id: {
      description: 'The ID of the ad account.',
      example: '549755885175',
      title: 'adAccountId',
      type: 'string',
    },
  },
  title: 'TermsOfService',
  type: 'object',
} as const;

export const TermsSuggestedResponseSchema = {
  items: {
    type: 'string',
  },
  type: 'array',
} as const;

export const TopPinsAnalyticsResponseSchema = {
  type: 'object',
  properties: {
    date_availability: {
      type: 'object',
      properties: {
        latest_available_timestamp: {
          type: 'number',
          example: 1649116799000,
        },
        is_realtime: {
          type: 'boolean',
          example: false,
        },
      },
    },
    pins: {
      type: 'array',
      items: {
        description: 'Array with metrics, status, and pin id for the requested metric',
        type: 'object',
        properties: {
          metrics: {
            $ref: '#/components/schemas/Metrics',
          },
          data_status: {
            type: 'object',
            additionalProperties: {
              $ref: '#/components/schemas/DataStatus',
            },
          },
          pin_id: {
            description: 'The pin id',
            type: 'string',
            example: '642396334344813594',
          },
        },
      },
    },
    sort_by: {
      type: 'string',
      enum: ['ENGAGEMENT', 'SAVE', 'IMPRESSION', 'OUTBOUND_CLICK', 'PIN_CLICK'],
      example: 'IMPRESSION',
    },
  },
} as const;

export const TopVideoPinsAnalyticsResponseSchema = {
  type: 'object',
  properties: {
    date_availability: {
      type: 'object',
      properties: {
        latest_available_timestamp: {
          type: 'number',
          example: 1649116799000,
        },
        is_realtime: {
          type: 'boolean',
          example: false,
        },
      },
    },
    pins: {
      type: 'array',
      items: {
        description: 'Array with metrics, status, and pin id for the requested metric',
        type: 'object',
        properties: {
          metrics: {
            description: 'The metric name and daily value for each requested metric',
            type: 'object',
            additionalProperties: {
              type: 'number',
            },
            example: {
              IMPRESSION: 7,
              QUARTILE_95_PERCENT_VIEW: 2,
              SAVE: 1,
              VIDEO_10S_VIEW: 5,
              VIDEO_AVG_WATCH_TIME: 86989,
              VIDEO_MRC_VIEW: 2,
              VIDEO_START: 2,
              VIDEO_V50_WATCH_TIME: 173979,
              OUTBOUND_CLICK: 2,
            },
          },
          data_status: {
            type: 'object',
            additionalProperties: {
              $ref: '#/components/schemas/DataStatus',
            },
          },
          pin_id: {
            description: 'The pin id',
            type: 'string',
            example: '642396334344813594',
          },
        },
      },
    },
    sort_by: {
      type: 'string',
      enum: [
        'SAVE',
        'IMPRESSION',
        'OUTBOUND_CLICK',
        'VIDEO_MRC_VIEW',
        'VIDEO_AVG_WATCH_TIME',
        'VIDEO_V50_WATCH_TIME',
        'QUARTILE_95_PERCENT_VIEW',
        'VIDEO_10S_VIEW',
        'VIDEO_START',
      ],
      example: 'IMPRESSION',
    },
  },
} as const;

export const TrackingUrlsSchema = {
  description:
    'Third-party tracking URLs. Up to three tracking URLs - with a max length of 2,000 - are supported for each event type. Tracking URLs set at the ad group or ad level can override those set at the campaign level. For more information, see <a href="https://help.pinterest.com/en/business/article/third-party-and-dynamic-tracking" target="_blank">Third-party and dynamic tracking</a>.',
  example: {
    impression: ['URL1', 'URL2'],
    click: ['URL1', 'URL2'],
    engagement: ['URL1', 'URL2'],
    buyable_button: ['URL1', 'URL2'],
    audience_verification: ['URL1', 'URL2'],
  },
  type: 'object',
  nullable: true,
  properties: {
    impression: {
      type: 'array',
      items: {
        type: 'string',
      },
    },
    click: {
      type: 'array',
      items: {
        type: 'string',
      },
    },
    engagement: {
      type: 'array',
      items: {
        type: 'string',
      },
    },
    buyable_button: {
      type: 'array',
      items: {
        type: 'string',
      },
    },
    audience_verification: {
      type: 'array',
      items: {
        type: 'string',
      },
    },
  },
} as const;

export const TrendTypeSchema = {
  title: 'TrendType',
  type: 'string',
  example: 'monthly',
  enum: ['growing', 'monthly', 'yearly', 'seasonal'],
} as const;

export const TrendingKeywordsResponseSchema = {
  type: 'object',
  properties: {
    trends: {
      description: `The top trending keywords for the specified trend type in the requested region.<br />
Results are ordered, with the first element in the array representing the #1 top trend.`,
      type: 'array',
      items: {
        type: 'object',
        properties: {
          keyword: {
            description: 'The keyword that is trending.',
            example: 'couples halloween costumes',
            type: 'string',
            minLength: 1,
          },
          pct_growth_wow: {
            description: `The week-over-week percent change in search volume for this keyword.<br />
For example, a value of "50" would represent a 50% increase in searches in the last seven days compared to the week prior.<br />
**Note**: growth rates are rounded, with a maximum of +/- 10000% change.  A value of 10001 indicates that this keyword experienced > 10000% week-over-week growth.`,
            example: 50,
            type: 'integer',
          },
          pct_growth_mom: {
            description: `The month-over-month percent change in search volume for this keyword.<br />
For example, a value of "400" would represent a 400% increase in searches in the last 30 days compared to the month prior.<br />
**Note**: growth rates are rounded, with a maximum of +/- 10000% change.  A value of 10001 indicates that this keyword experienced > 10000% month-over-month growth.`,
            example: 400,
            type: 'integer',
          },
          pct_growth_yoy: {
            description: `The year-over-year percent change in search volume for this keyword.<br />
For example, a value of "-5" would represent a 5% decrease in searches in the last 365 days compared to the month prior.<br />
**Note**: growth rates are rounded, with a maximum of +/- 10000% change.  A value of 10001 indicates that this keyword experienced > 10000% year-over-year growth.`,
            example: -5,
            type: 'integer',
          },
          time_series: {
            description: `A sequence of weekly observations of the relative search volume for this keyword over the past year.<br />
These values are normalized to a [0-100] range, and can be used to visualize the history of user interest in this keyword.
By default, normalization is applied independently to the time series of each keyword, but the \`normalize_against_group\` query parameter can be used in cases where you wish to compare relative volume between keywords.<br />
**Note**: The date of each observation is in ISO-8601 format and represents the *end* of the week.  For example, a value of \`2023-10-31\` would include searches that happened between \`2023-10-25\` and \`2023-10-31\`.`,
            example: {
              '2023-10-10': 31,
              '2023-10-17': 54,
              '2023-10-24': 77,
              '2023-10-31': 100,
            },
            type: 'object',
            properties: {
              date: {
                type: 'string',
                format: 'date',
              },
            },
            additionalProperties: {
              type: 'integer',
            },
          },
        },
      },
    },
  },
} as const;

export const TrendsSupportedRegionSchema = {
  title: 'Region',
  type: 'string',
  example: 'GB+IE',
  enum: [
    'US',
    'CA',
    'DE',
    'FR',
    'ES',
    'IT',
    'DE+AT+CH',
    'GB+IE',
    'IT+ES+PT+GR+MT',
    'PL+RO+HU+SK+CZ',
    'SE+DK+FI+NO',
    'NL+BE+LU',
    'AR',
    'BR',
    'CO',
    'MX',
    'MX+AR+CO+CL',
    'AU+NZ',
  ],
} as const;

export const UpdatableItemAttributesSchema = {
  type: 'object',
  properties: {
    ad_link: {
      description:
        'Allows advertisers to specify a separate URL that can be used to track traffic coming from Pinterest shopping ads. Must send full URL including tracking—do not send tracking parameters only. At this time we do not support impression tracking. Must begin with http:// or https://.',
      example: 'https://www.example.com/cat/denim-shirt/item012?utm_source=Pinterest',
      type: 'string',
      nullable: true,
    },
    adult: {
      description:
        "Set this attribute to TRUE if you're submitting items that are considered “adult”. These will not be shown on Pinterest.",
      example: true,
      type: 'boolean',
      nullable: true,
    },
    age_group: {
      description:
        'The age group to apply a demographic range to the product. Must be one of the following values (upper or lowercased): ‘newborn’ , ‘infant’, ‘toddler’, ‘kids’, or ‘adult’.',
      example: 'newborn',
      type: 'string',
      nullable: true,
    },
    availability: {
      description:
        'The availability of the product. Must be one of the following values (upper or lowercased): ‘in stock’, ‘out of stock’ , ‘preorder’.',
      example: 'in stock',
      type: 'string',
    },
    average_review_rating: {
      description: 'Average reviews for the item. Can be a number from 1-5.',
      example: 5,
      type: 'number',
      nullable: true,
    },
    brand: {
      description: 'The brand of the product.',
      example: 'Josie’s Denim',
      type: 'string',
      nullable: true,
    },
    checkout_enabled: {
      description: 'This attribute is not supported anymore.',
      example: false,
      type: 'boolean',
      nullable: true,
      deprecated: true,
    },
    color: {
      description: 'The primary color of the product.',
      example: 'blue',
      type: 'string',
      nullable: true,
    },
    condition: {
      description:
        'The condition of the product. Must be one of the following values (upper or lowercased): ‘new’, ‘used’, or ‘refurbished’.',
      example: 'new',
      type: 'string',
      nullable: true,
    },
    custom_label_0: {
      description: `<p><= 1000 characters</p>
<p>Custom grouping of products.</p>`,
      example: 'Best sellers',
      type: 'string',
      nullable: true,
    },
    custom_label_1: {
      description: `<p><= 1000 characters</p>
<p>Custom grouping of products.</p>`,
      example: 'Summer promotion',
      type: 'string',
      nullable: true,
    },
    custom_label_2: {
      description: `<p><= 1000 characters</p>
<p>Custom grouping of products.</p>`,
      example: 'Winter sales',
      type: 'string',
      nullable: true,
    },
    custom_label_3: {
      description: `<p><= 1000 characters</p>
<p>Custom grouping of products.</p>`,
      example: 'Woman dress',
      type: 'string',
      nullable: true,
    },
    custom_label_4: {
      description: `<p><= 1000 characters</p>
<p>Custom grouping of products.</p>`,
      example: 'Man hat',
      type: 'string',
      nullable: true,
    },
    description: {
      description: `<p><= 10000 characters</p>
<p>The description of the product.</p>`,
      example: 'Casual fit denim shirt made with the finest quality Japanese denim.',
      type: 'string',
    },
    free_shipping_label: {
      description: 'The item is free to ship.',
      example: true,
      type: 'boolean',
      nullable: true,
    },
    free_shipping_limit: {
      description:
        'The minimum order purchase necessary for the customer to get free shipping. Only relevant if free shipping is offered.',
      example: '35 USD',
      type: 'string',
      nullable: true,
    },
    gender: {
      description:
        'The gender associated with the product. Must be one of the following values (upper or lowercased): ‘male’, ‘female’ , or ‘unisex’.',
      example: 'unisex',
      type: 'string',
      nullable: true,
    },
    google_product_category: {
      description:
        'The categorization of the product based on the standardized Google Product Taxonomy. This is a set taxonomy. Both the text values and numeric codes are accepted.',
      example: 'Apparel & Accessories > Clothing > Shirts & Tops',
      type: 'string',
      nullable: true,
    },
    gtin: {
      description: 'The unique universal product identifier.',
      example: 3234567890126,
      type: 'integer',
      nullable: true,
    },
    id: {
      description: `<p><= 127 characters</p>
<p>The user-created unique ID that represents the product. Only
Unicode characters are accepted.</p>`,
      example: 'DS0294-L',
      type: 'string',
      deprecated: true,
    },
    item_group_id: {
      description: `<p><= 127 characters</p>
<p>The parent ID of the product.</p>`,
      example: 'DS0294',
      type: 'string',
      nullable: true,
    },
    last_updated_time: {
      description: 'The millisecond timestamp when the item was lastly modified by the merchant.',
      example: 1641483432072,
      type: 'integer',
      format: 'int64',
      nullable: true,
    },
    link: {
      description: `<p><= 511 characters</p>
<p>The landing page for the product.</p>`,
      example: 'https://www.example.com/cat/womens-clothing/denim-shirt-0294',
      type: 'string',
    },
    material: {
      description: 'The material used to make the product.',
      example: 'cotton',
      type: 'string',
      nullable: true,
    },
    min_ad_price: {
      description:
        'The minimum advertised price of the product. It supports the following formats, "19.99 USD", "19.99USD" and "19.99". If the currency is not included, we default to US dollars.',
      example: '19.99 USD',
      type: 'string',
      nullable: true,
    },
    mobile_link: {
      description: 'The mobile-optimized version of your landing page. Must begin with http:// or https://.',
      example: 'https://m.example.com/cat/womens-clothing/denim-shirt-0294',
      type: 'string',
      nullable: true,
    },
    mpn: {
      description:
        'Manufacturer Part Number are alpha-numeric codes created by the manufacturer of a product to uniquely identify it among all products from the same manufacturer.',
      example: 'PI12345NTEREST',
      type: 'string',
      nullable: true,
    },
    number_of_ratings: {
      description: 'The number of ratings for the item.',
      example: 10,
      type: 'integer',
      nullable: true,
    },
    number_of_reviews: {
      description: 'The number of reviews available for the item.',
      example: 10,
      type: 'integer',
      nullable: true,
    },
    pattern: {
      description: 'The description of the pattern used for the product.',
      example: 'plaid',
      type: 'string',
      nullable: true,
    },
    price: {
      description:
        'The price of the product. It supports the following formats, "24.99 USD", "24.99USD" and "24.99". If the currency is not included, we default to US dollars.',
      example: '24.99 USD',
      type: 'string',
    },
    product_type: {
      description: `<p><= 1000 characters</p>
<p>The categorization of your product based on your custom product
taxonomy. Subcategories must be sent separated by “ > “. The > must be
wrapped by spaces. We do not recognize any other delimiters such as comma
or pipe.</p>`,
      example: 'Clothing > Women’s > Shirts > Denim',
      type: 'string',
      nullable: true,
    },
    sale_price: {
      description:
        'The discounted price of the product. The sale_price must be lower than the price. It supports the following formats, "14.99 USD", "14.99USD" and "14.99". If the currency is not included, we default to US dollars.',
      example: '14.99 USD',
      type: 'string',
      nullable: true,
    },
    shipping: {
      description:
        'Shipping consists of one group of up to four elements, country, region, service (all optional) and price (required). All colons, even for blank values, are required.',
      example: 'US:CA:Ground:0 USD',
      type: 'string',
      nullable: true,
    },
    shipping_height: {
      description:
        'The height of the package needed to ship the product. Ensure there is a space between the numeric string and the metric.',
      example: '12 in',
      type: 'string',
      nullable: true,
    },
    shipping_weight: {
      description: 'The weight of the product. Ensure there is a space between the numeric string and the metric.',
      example: '3 kg',
      type: 'string',
      nullable: true,
    },
    shipping_width: {
      description:
        'The width of the package needed to ship the product. Ensure there is a space between the numeric string and the metric.',
      example: '16 in',
      type: 'string',
      nullable: true,
    },
    size: {
      description: 'The size of the product.',
      example: 'M',
      type: 'string',
      nullable: true,
    },
    size_system: {
      description:
        'Indicates the country’s sizing system in which you are submitting your product. Must be one of the following values (upper or lowercased): ‘US’, ‘UK’, ‘EU’, ‘DE’ , ‘FR’, ‘JP’, ‘CN’, ‘IT’, ‘ BR’, ‘MEX’, or ‘AU’.',
      example: 'US',
      type: 'string',
      nullable: true,
    },
    size_type: {
      description:
        'Additional description for the size. Must be one of the following values (upper or lowercased): ‘regular’, ‘petite’ , ‘plus’, ‘big_and_tall’, or ‘maternity’.',
      example: 'regular',
      type: 'string',
      nullable: true,
    },
    tax: {
      description:
        'Tax consists of one group of up to four elements, country, region, rate (all required) and tax_ship (optional). All colons, even for blank values, are required.',
      example: 'US:1025433:6.00:y',
      type: 'string',
      nullable: true,
    },
    title: {
      description: `<p><= 500 characters</p>
<p>The name of the product.</p>`,
      example: 'Women’s denim shirt, large',
      type: 'string',
    },
    variant_names: {
      description:
        'Options for this variant. People will see these options next to your Pin and can select the one they want. List them in the order you want them displayed.',
      example: ['Color', 'Size'],
      type: 'array',
      nullable: true,
      items: {
        type: 'string',
      },
    },
    variant_values: {
      description:
        'Option values for this variant. People will see these options next to your Pin and can select the one they want. List them in the order you want them displayed. The order of the variant values must be consistent with the order of the variant names.',
      example: ['Red', 'Small'],
      type: 'array',
      nullable: true,
      items: {
        type: 'string',
      },
    },
  },
} as const;

export const UserBusinessRoleBindingSchema = {
  type: 'object',
  properties: {
    assets_summary: {
      type: 'object',
      nullable: true,
      allOf: [
        {
          $ref: '#/components/schemas/BusinessMemberAssetsSummary',
        },
      ],
    },
    business_roles: {
      description: 'The access level a user has on the business. This can be EMPLOYEE, BIZ_ADMIN, or PARTNER.',
      type: 'array',
      example: ['BIZ_ADMIN'],
      items: {
        $ref: '#/components/schemas/BusinessRoleResponse',
      },
    },
    created_by_business: {
      type: 'object',
      nullable: true,
      description: 'Metadata for the business that created the business relationship.',
      allOf: [
        {
          $ref: '#/components/schemas/BusinessAccessUserSummary',
        },
      ],
    },
    created_by_user: {
      type: 'object',
      nullable: true,
      description: 'Metadata for the user that created the business relationship.',
      allOf: [
        {
          $ref: '#/components/schemas/BusinessAccessUserSummary',
        },
      ],
    },
    created_time: {
      type: 'integer',
      nullable: true,
      description: 'The time the business relationship was created. Returned in milliseconds.',
      example: 1646767577816,
    },
    id: {
      type: 'string',
      description: 'Unique identifier of the business member/business partner/employer.',
      example: '383791336903426391',
      pattern: '^\\d+$',
    },
    is_shared_partner: {
      type: 'boolean',
      description: `This field is only relevant when business_role="PARTNER".
<br>If is_shared_partner=FALSE, the partner can access your business assets. If assets_summary
is not empty, the assets listed are your business assets the partner has access to.
<br>If is_shared_partner=TRUE, you can access the partner's business asset. If assets_summary
is not empty, the assets listed are the partner's business assets you have access to.`,
      example: false,
    },
    user: {
      type: 'object',
      nullable: true,
      description: 'Metadata for the business member/business partner/employer.',
      allOf: [
        {
          $ref: '#/components/schemas/BusinessAccessUserSummary',
        },
      ],
    },
  },
} as const;

export const CreateAssetInvitesRequestItemSchema = {
  description: 'Object declaring an asset role update to an invite.',
  type: 'object',
  required: ['invite_id', 'invite_type', 'asset_id_to_permissions'],
  properties: {
    invite_id: {
      description: 'Unique identifier of an invite.',
      example: '1234567890123',
      type: 'string',
      pattern: '^\\d+$',
    },
    invite_type: {
      $ref: '#/components/schemas/InviteType',
    },
    asset_id_to_permissions: {
      $ref: '#/components/schemas/AssetIdToPermissions',
    },
  },
} as const;

export const CreateAssetInvitesRequestSchema = {
  description: 'Request body for updating asset roles for existing invites.',
  type: 'object',
  required: ['invites'],
  properties: {
    invites: {
      type: 'array',
      minItems: 1,
      maxItems: 50,
      items: {
        $ref: '#/components/schemas/CreateAssetInvitesRequestItem',
      },
    },
  },
} as const;

export const UpdateAssetGroupBodySchema = {
  type: 'object',
  properties: {
    asset_groups_to_update: {
      type: 'array',
      description: 'A list of asset groups and the data that will be used to update them.',
      items: {
        type: 'object',
        properties: {
          asset_group_id: {
            description: 'Unique identifier of the asset group to update.',
            title: 'asset_group_id',
            type: 'string',
            example: '666791336903426391',
          },
          name: {
            description: 'Asset Group name',
            example: 'Canada Ad Accounts',
            title: 'name',
            type: 'string',
          },
          description: {
            description: 'Asset group description',
            example: 'Asset groups that has ad accounts shared in Canada',
            title: 'description',
            type: 'string',
          },
          asset_group_types: {
            $ref: '#/components/schemas/AssetGroupTypes',
          },
          assets_to_add: {
            type: 'array',
            description: 'A list of asset ids to add to the asset group.',
            items: {
              description: 'The ID of an asset that will be added to the asset group.',
              example: '549755885175',
              type: 'string',
            },
          },
          assets_to_remove: {
            type: 'array',
            description: 'A list of asset ids to remove from the asset group.',
            items: {
              description: 'The ID of an asset that will be removed from the asset group.',
              example: '549755885175',
              type: 'string',
            },
          },
        },
        required: ['asset_group_id'],
      },
    },
  },
} as const;

export const UpdateAssetGroupResponseSchema = {
  type: 'object',
  properties: {
    updated_asset_groups: {
      type: 'array',
      description: 'A list of successfully edited asset groups.',
      items: {
        $ref: '#/components/schemas/AssetGroupBinding',
      },
    },
    exceptions: {
      type: 'array',
      description: 'A list of errors associated with the asset groups. Will be returned if there is an error.',
      nullable: true,
      items: {
        type: 'object',
        properties: {
          code: {
            type: 'integer',
            description: 'Error code associated with the error editing asset group.',
            example: 29,
          },
          message: {
            type: 'string',
            description: 'Error message associated with the error editing asset group.',
            example: 'You are not permitted to access that resource.',
          },
          asset_group_id: {
            type: 'string',
            description: 'Asset group id of the exception.',
            example: '666791336903426391',
          },
        },
      },
    },
  },
} as const;

export const DeleteAssetGroupBodySchema = {
  description: 'Request body used to delete asset groups',
  type: 'object',
  required: ['asset_groups_to_delete'],
  properties: {
    asset_groups_to_delete: {
      description: 'List of ids of asset groups to be deleted',
      example: ['666791336903426391', '666791336903426392'],
      items: {
        type: 'string',
        pattern: '^\\d+$',
      },
      type: 'array',
      minItems: 1,
      maxItems: 50,
    },
  },
} as const;

export const DeleteAssetGroupResponseSchema = {
  type: 'object',
  properties: {
    deleted_asset_groups: {
      type: 'array',
      description: 'A list of ids of successfully deleted asset groups.',
      items: {
        type: 'string',
        pattern: '^\\d+$',
      },
    },
    exceptions: {
      type: 'array',
      description: 'A list of errors associated with the asset groups. Will be returned if there is an error.',
      nullable: true,
      items: {
        type: 'object',
        properties: {
          code: {
            type: 'integer',
            description: 'Error code associated with the error deleting asset group.',
            example: 29,
          },
          message: {
            type: 'string',
            description: 'Error message associated with the error deleting asset group.',
            example: 'You are not permitted to access that resource.',
          },
          asset_group_id: {
            type: 'string',
            description: 'Asset group id of the exception.',
            example: '666791336903426391',
          },
        },
      },
    },
  },
} as const;

export const UpdateInvitesResultsResponseArraySchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      description:
        'List of invite/Request action status. If there is an error, an exception object will be returned. If the action was successfully completed, an invite object will be returned.',
      items: {
        type: 'object',
        properties: {
          exception: {
            $ref: '#/components/schemas/InviteExceptionResponse',
          },
          invite: {
            $ref: '#/components/schemas/InviteBusinessRoleBinding',
          },
        },
      },
    },
  },
} as const;

export const DeleteInvitesResultsResponseArraySchema = {
  description:
    'Response to delete invites sent to Members or Partners, if there is an exception, return the exception mapped with the invite id',
  properties: {
    items: {
      description:
        'List of invite/Request deletion status. If there is an error, an exception object will be returned. If the invite/request was successfully cancelled, an invite object will be returned for the invite that was cancelled.',
      items: {
        properties: {
          exception: {
            description:
              'An exception object if there is an error performing the cancellation. It will only be provided if there is an error.',
            nullable: true,
            properties: {
              invite_id: {
                description: 'Unique identifier of an invite.',
                pattern: '^\\d+$',
                type: 'string',
              },
              message: {
                type: 'string',
                description: 'Error message associated with the error in performing the action on the invite/request.',
                example: 'Business Invite request cannot be performed on current invitation status.',
              },
            },
            type: 'object',
          },
          invite: {
            $ref: '#/components/schemas/BaseInviteDataResponse',
          },
        },
        type: 'object',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const UpdateMemberAssetsResultsResponseArraySchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      description: `List of assigned/updated member asset access.
If there is an error, an exception object will be returned. If the action was successfully completed, a response object will be returned.`,
      items: {
        type: 'object',
        properties: {
          response: {
            $ref: '#/components/schemas/UsersForIndividualAssetResponse',
          },
        },
      },
    },
  },
} as const;

export const UsersForIndividualAssetResponseSchema = {
  type: 'object',
  description: 'An object containing the permissions a business member has on the asset.',
  properties: {
    asset_id: {
      description: 'Unique identifier of a business asset.',
      example: '549755885175',
      type: 'string',
      pattern: '^\\d+$',
    },
    member_id: {
      description: 'Unique identifier of the business member with asset access.',
      example: '140943737684417',
      type: 'string',
      pattern: '^\\d+$',
    },
    permissions: {
      $ref: '#/components/schemas/PermissionsResponse',
    },
  },
} as const;

export const UpdateMaskFieldTypeSchema = {
  description: 'The field types supported by the update mask',
  example: 'availability',
  type: 'string',
  enum: [
    'ad_link',
    'adult',
    'age_group',
    'availability',
    'average_review_rating',
    'brand',
    'checkout_enabled',
    'color',
    'condition',
    'custom_label_0',
    'custom_label_1',
    'custom_label_2',
    'custom_label_3',
    'custom_label_4',
    'description',
    'free_shipping_label',
    'free_shipping_limit',
    'gender',
    'google_product_category',
    'gtin',
    'item_group_id',
    'last_updated_time',
    'link',
    'material',
    'min_ad_price',
    'mpn',
    'number_of_ratings',
    'number_of_reviews',
    'pattern',
    'price',
    'product_type',
    'sale_price',
    'shipping',
    'shipping_height',
    'shipping_weight',
    'shipping_width',
    'size',
    'size_system',
    'size_type',
    'tax',
    'title',
    'variant_names',
    'variant_values',
  ],
} as const;

export const UpdatePartnerResultsResponseArraySchema = {
  properties: {
    items: {
      items: {
        properties: {
          exception: {
            $ref: '#/components/schemas/BusinessAccessError',
          },
          member_or_partner_id: {
            example: '1234567890123',
            maxLength: 18,
            nullable: true,
            pattern: '^\\d+$',
            type: 'string',
          },
        },
        type: 'object',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const UserFollowingFeedTypeSchema = {
  description: 'Specifies the type of followees to be kept when filtering them.',
  enum: ['ALL', 'RANKED', 'CREATOR_ONLY', 'RANKED_CREATOR_ONLY'],
  example: 'CREATOR_ONLY',
  title: 'UserFollowingFeedType',
  type: 'string',
  default: 'ALL',
} as const;

export const UserListOperationTypeSchema = {
  description: 'User list operation type (add or remove)',
  enum: ['ADD', 'REMOVE'],
  example: 'REMOVE',
  title: 'UserListOperationType',
  type: 'string',
} as const;

export const UserListTypeSchema = {
  description: 'User list type',
  enum: ['EMAIL', 'IDFA', 'MAID', 'LR_ID', 'DLX_ID', 'HASHED_PINNER_ID'],
  example: 'EMAIL',
  title: 'UserListType',
  type: 'string',
} as const;

export const UserSingleAssetBindingSchema = {
  type: 'object',
  description: 'An object containing the permissions a business member/partner has on the asset.',
  properties: {
    permissions: {
      $ref: '#/components/schemas/PermissionsResponse',
    },
    user: {
      $ref: '#/components/schemas/BusinessAccessUserSummary',
    },
  },
} as const;

export const UserSummarySchema = {
  title: 'UserSummary',
  type: 'object',
  properties: {
    username: {
      title: 'username',
      type: 'string',
      description: 'Username',
      example: 'username',
    },
    type: {
      title: 'type',
      type: 'string',
      description: 'Always "user"',
      example: 'user',
    },
  },
} as const;

export const UserWebsiteSummarySchema = {
  title: 'UserWebsiteSummary',
  type: 'object',
  properties: {
    website: {
      title: 'website',
      type: 'string',
      description: 'Website with path or domain only',
      example: 'mysite.test',
    },
    status: {
      title: 'status',
      type: 'string',
      description: 'Status of the verification process',
      example: 'success',
    },
    verified_at: {
      title: 'verified_at',
      type: 'string',
      description: 'UTC timestamp when the verification happened - sometimes missing',
      example: '2022-12-14T21:03:01.602000',
    },
  },
} as const;

export const UserWebsiteVerificationCodeSchema = {
  title: 'UserWebsiteVerificationCode',
  type: 'object',
  properties: {
    verification_code: {
      title: 'verification_code',
      type: 'string',
      description: 'Code to check against the user claiming the website',
      example: 'e1edcc1a43976c646367e9c6c9a9b7b6',
    },
    dns_txt_record: {
      title: 'dns_txt_record',
      type: 'string',
      description: 'DNS TXT record to check against for the website to be claimed',
      example: 'pinterest-site-verification=e1edcc1a43976c646367e9c6c9a9b7b6',
    },
    metatag: {
      title: 'metatag',
      type: 'string',
      description: 'Metatag the verification process searchs for the website to be claimed',
      example: '<meta name="p:domain_verify" content="e1edcc1a43976c646367e9c6c9a9b7b6"/>',
    },
    filename: {
      title: 'filename',
      type: 'string',
      description: 'File expected to find on the website being claimed',
      example: 'pinterest-e1edc.html',
    },
    file_content: {
      title: 'file_content',
      type: 'string',
      description: 'A full html file to upload to the website in order for it to be claimed',
    },
  },
} as const;

export const UserWebsiteVerifyRequestSchema = {
  title: 'User website verification request',
  description: 'User website verification request',
  type: 'object',
  properties: {
    website: {
      type: 'string',
      example: 'pintest-website-12345678.test/test_1',
    },
    verification_method: {
      type: 'string',
      default: 'METATAG',
      enum: ['FILENAME', 'METATAG', 'DNSTXT'],
    },
  },
} as const;

export const VideoMetadataSchema = {
  title: 'Video metadata',
  type: 'object',
  properties: {
    item_type: {
      type: 'string',
    },
    cover_image_url: {
      type: 'string',
    },
    video_url: {
      type: 'string',
      nullable: true,
      description: 'Video url (720p). </p><strong>Note:</strong> This field is limited and not available to all apps.',
    },
    duration: {
      type: 'number',
      description: 'Duration (in milliseconds)',
    },
    height: {
      type: 'integer',
      description: 'Height (in pixels)',
    },
    width: {
      type: 'integer',
      description: 'Width (in pixels)',
    },
  },
} as const;

export const PartnerTypeSchema = {
  enum: ['INTERNAL', 'EXTERNAL'],
  example: 'INTERNAL',
  type: 'string',
} as const;

export const UpdatePartnerAssetsResultSchema = {
  type: 'object',
  description: 'An object containing the permissions a business partner has on the asset.',
  properties: {
    asset_id: {
      description: 'Unique identifier of a business asset.',
      example: '549755885175',
      pattern: '^\\d+$',
      type: 'string',
    },
    asset_type: {
      $ref: '#/components/schemas/AssetTypeResponse',
    },
    partner_id: {
      description: 'Unique identifier of a business partner.',
      example: '140943737684417',
      pattern: '^\\d+$',
      type: 'string',
    },
    permissions: {
      $ref: '#/components/schemas/PermissionsResponse',
    },
  },
} as const;

export const UpdatePartnerAssetsResultsResponseArraySchema = {
  type: 'object',
  properties: {
    items: {
      type: 'array',
      description: 'List of assigned/updated partner asset access.',
      items: {
        type: 'object',
        $ref: '#/components/schemas/UpdatePartnerAssetsResult',
      },
    },
  },
} as const;

export const SharedAudienceCommonSchema = {
  type: 'object',
  properties: {
    audience_id: {
      description: 'Unique identifier of an audience',
      example: '2542621871096',
      type: 'string',
      pattern: '^\\d+$',
    },
    operation_type: {
      $ref: '#/components/schemas/OperationType',
    },
  },
} as const;

export const SharedAudienceSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/SharedAudienceCommon',
    },
    {
      title: 'SharedAudience',
      type: 'object',
      properties: {
        recipient_account_ids: {
          description: 'List of ad account IDs to share with or revoke from.',
          type: 'array',
          items: {
            type: 'string',
            pattern: '^\\d+$',
          },
        },
      },
      required: ['audience_id', 'recipient_account_ids', 'operation_type'],
    },
  ],
} as const;

export const BusinessSharedAudienceSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/SharedAudienceCommon',
    },
    {
      title: 'BusinessSharedAudience',
      type: 'object',
      properties: {
        recipient_business_ids: {
          description: 'List of business IDs to share with or revoke from.',
          type: 'array',
          items: {
            type: 'string',
            pattern: '^\\d+$',
          },
        },
      },
      required: ['audience_id', 'recipient_business_ids', 'operation_type'],
    },
  ],
} as const;

export const SharedAudienceResponseCommonSchema = {
  type: 'object',
  nullable: true,
  properties: {
    audience_id: {
      description: 'Audience ID that was shared',
      example: '2542621871096',
      type: 'string',
    },
    permissions: {
      example: ['RESOURCE_PINNER_LIST_READER', 'RESOURCE_PINNER_LIST_OWNER'],
      type: 'array',
      items: {
        $ref: '#/components/schemas/Role',
      },
    },
  },
} as const;

export const SharedAudienceResponseSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/SharedAudienceResponseCommon',
    },
    {
      title: 'SharedAudienceResponse',
      type: 'object',
      nullable: true,
      properties: {
        recipient_account_ids: {
          description: 'Account IDs that received the audience',
          example: ['549755885175'],
          type: 'array',
          items: {
            type: 'string',
          },
        },
      },
    },
  ],
} as const;

export const BusinessSharedAudienceResponseSchema = {
  type: 'object',
  allOf: [
    {
      $ref: '#/components/schemas/SharedAudienceResponseCommon',
    },
    {
      title: 'BusinessSharedAudienceResponse',
      type: 'object',
      nullable: true,
      properties: {
        recipient_business_ids: {
          description: 'Business IDs that received the audience',
          example: ['549755885175'],
          type: 'array',
          items: {
            type: 'string',
          },
        },
      },
    },
  ],
} as const;

export const OperationTypeSchema = {
  type: 'string',
  description: 'Operation type to share a specific audience or revoke access to a previously shared audience',
  enum: ['SHARE', 'REVOKE'],
} as const;
