// Generated by ts-to-zod
import { z } from 'zod';

export const getUserDataSchema = z.object({
  headers: z.object({
    'Notion-Version': z.string(),
  }),
  path: z.object({
    user_id: z.string(),
  }),
});

export const getUserResponseSchema = z.unknown();

export const getUserErrorSchema = z.record(z.unknown());

export const getUsersDataSchema = z.object({
  headers: z.object({
    'Notion-Version': z.string(),
  }),
  query: z
    .object({
      page_size: z.number().optional(),
      start_cursor: z.string().optional(),
    })
    .optional(),
});

export const getUsersResponseSchema = z.unknown();

export const getUsersErrorSchema = z.record(z.unknown());

export const postDatabaseQueryDataSchema = z.object({
  body: z
    .object({
      filter: z.string().optional(),
      sorts: z.array(z.unknown()).optional(),
      start_cursor: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
  headers: z.object({
    'Notion-Version': z.string(),
  }),
  path: z.object({
    database_id: z.string(),
  }),
  query: z
    .object({
      filter_properties: z.string().optional(),
    })
    .optional(),
});

export const postDatabaseQueryResponseSchema = z.object({
  object: z.string().optional(),
  results: z
    .array(
      z.object({
        object: z.string().optional(),
        id: z.string().optional(),
        created_time: z.string().optional(),
        last_edited_time: z.string().optional(),
        created_by: z
          .object({
            object: z.string().optional(),
            id: z.string().optional(),
          })
          .optional(),
        last_edited_by: z
          .object({
            object: z.string().optional(),
            id: z.string().optional(),
          })
          .optional(),
        cover: z
          .object({
            type: z.string().optional(),
            external: z
              .object({
                url: z.string().optional(),
              })
              .optional(),
          })
          .optional(),
        icon: z
          .object({
            type: z.string().optional(),
            emoji: z.string().optional(),
          })
          .optional(),
        parent: z
          .object({
            type: z.string().optional(),
            database_id: z.string().optional(),
          })
          .optional(),
        archived: z.boolean().optional(),
        properties: z
          .object({
            'Store availability': z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                multi_select: z
                  .array(
                    z.object({
                      id: z.string().optional(),
                      name: z.string().optional(),
                      color: z.string().optional(),
                    }),
                  )
                  .optional(),
              })
              .optional(),
            'Food group': z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                select: z
                  .object({
                    id: z.string().optional(),
                    name: z.string().optional(),
                    color: z.string().optional(),
                  })
                  .optional(),
              })
              .optional(),
            Price: z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                number: z.number().optional(),
              })
              .optional(),
            'Responsible Person': z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                people: z
                  .array(
                    z.object({
                      object: z.string().optional(),
                      id: z.string().optional(),
                      name: z.string().optional(),
                      avatar_url: z.string().optional(),
                      type: z.string().optional(),
                      person: z
                        .object({
                          email: z.string().optional(),
                        })
                        .optional(),
                    }),
                  )
                  .optional(),
              })
              .optional(),
            'Last ordered': z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                date: z
                  .object({
                    start: z.string().optional(),
                    end: z.unknown().optional(),
                    time_zone: z.unknown().optional(),
                  })
                  .optional(),
              })
              .optional(),
            'Cost of next trip': z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                formula: z
                  .object({
                    type: z.string().optional(),
                    number: z.number().optional(),
                  })
                  .optional(),
              })
              .optional(),
            Recipes: z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                relation: z
                  .array(
                    z.object({
                      id: z.string().optional(),
                    }),
                  )
                  .optional(),
                has_more: z.boolean().optional(),
              })
              .optional(),
            Description: z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                rich_text: z
                  .array(
                    z.object({
                      type: z.string().optional(),
                      text: z
                        .object({
                          content: z.string().optional(),
                          link: z.unknown().optional(),
                        })
                        .optional(),
                      annotations: z
                        .object({
                          bold: z.boolean().optional(),
                          italic: z.boolean().optional(),
                          strikethrough: z.boolean().optional(),
                          underline: z.boolean().optional(),
                          code: z.boolean().optional(),
                          color: z.string().optional(),
                        })
                        .optional(),
                      plain_text: z.string().optional(),
                      href: z.unknown().optional(),
                    }),
                  )
                  .optional(),
              })
              .optional(),
            'In stock': z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                checkbox: z.boolean().optional(),
              })
              .optional(),
            'Number of meals': z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                rollup: z
                  .object({
                    type: z.string().optional(),
                    number: z.number().optional(),
                    function: z.string().optional(),
                  })
                  .optional(),
              })
              .optional(),
            Photo: z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                url: z.string().optional(),
              })
              .optional(),
            Name: z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                title: z
                  .array(
                    z.object({
                      type: z.string().optional(),
                      text: z
                        .object({
                          content: z.string().optional(),
                          link: z.unknown().optional(),
                        })
                        .optional(),
                      annotations: z
                        .object({
                          bold: z.boolean().optional(),
                          italic: z.boolean().optional(),
                          strikethrough: z.boolean().optional(),
                          underline: z.boolean().optional(),
                          code: z.boolean().optional(),
                          color: z.string().optional(),
                        })
                        .optional(),
                      plain_text: z.string().optional(),
                      href: z.unknown().optional(),
                    }),
                  )
                  .optional(),
              })
              .optional(),
          })
          .optional(),
        url: z.string().optional(),
      }),
    )
    .optional(),
  next_cursor: z.unknown().optional(),
  has_more: z.boolean().optional(),
  type: z.string().optional(),
  page_or_database: z.record(z.unknown()).optional(),
});

export const postDatabaseQueryErrorSchema = z.record(z.unknown());

export const postSearchDataSchema = z.object({
  body: z
    .object({
      query: z.string().optional(),
      sort: z
        .object({
          direction: z.string().optional(),
          timestamp: z.string().optional(),
        })
        .optional(),
      filter: z
        .object({
          value: z.string().optional(),
          property: z.string().optional(),
        })
        .optional(),
      start_cursor: z.string().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
  headers: z.object({
    'Notion-Version': z.string(),
  }),
});

export const postSearchResponseSchema = z.object({
  object: z.string().optional(),
  results: z
    .array(
      z.object({
        object: z.string().optional(),
        id: z.string().optional(),
        created_time: z.string().optional(),
        last_edited_time: z.string().optional(),
        created_by: z
          .object({
            object: z.string().optional(),
            id: z.string().optional(),
          })
          .optional(),
        last_edited_by: z
          .object({
            object: z.string().optional(),
            id: z.string().optional(),
          })
          .optional(),
        cover: z
          .object({
            type: z.string().optional(),
            external: z
              .object({
                url: z.string().optional(),
              })
              .optional(),
          })
          .optional(),
        icon: z
          .object({
            type: z.string().optional(),
            emoji: z.string().optional(),
          })
          .optional(),
        parent: z
          .object({
            type: z.string().optional(),
            database_id: z.string().optional(),
          })
          .optional(),
        archived: z.boolean().optional(),
        properties: z
          .object({
            'Store availability': z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                multi_select: z.array(z.unknown()).optional(),
              })
              .optional(),
            'Food group': z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                select: z
                  .object({
                    id: z.string().optional(),
                    name: z.string().optional(),
                    color: z.string().optional(),
                  })
                  .optional(),
              })
              .optional(),
            Price: z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                number: z.unknown().optional(),
              })
              .optional(),
            'Responsible Person': z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                people: z.array(z.unknown()).optional(),
              })
              .optional(),
            'Last ordered': z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                date: z.unknown().optional(),
              })
              .optional(),
            'Cost of next trip': z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                formula: z
                  .object({
                    type: z.string().optional(),
                    number: z.unknown().optional(),
                  })
                  .optional(),
              })
              .optional(),
            Recipes: z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                relation: z.array(z.unknown()).optional(),
              })
              .optional(),
            Description: z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                rich_text: z
                  .array(
                    z.object({
                      type: z.string().optional(),
                      text: z
                        .object({
                          content: z.string().optional(),
                          link: z.unknown().optional(),
                        })
                        .optional(),
                      annotations: z
                        .object({
                          bold: z.boolean().optional(),
                          italic: z.boolean().optional(),
                          strikethrough: z.boolean().optional(),
                          underline: z.boolean().optional(),
                          code: z.boolean().optional(),
                          color: z.string().optional(),
                        })
                        .optional(),
                      plain_text: z.string().optional(),
                      href: z.unknown().optional(),
                    }),
                  )
                  .optional(),
              })
              .optional(),
            'In stock': z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                checkbox: z.boolean().optional(),
              })
              .optional(),
            'Number of meals': z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                rollup: z
                  .object({
                    type: z.string().optional(),
                    number: z.number().optional(),
                    function: z.string().optional(),
                  })
                  .optional(),
              })
              .optional(),
            Photo: z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                url: z.unknown().optional(),
              })
              .optional(),
            Name: z
              .object({
                id: z.string().optional(),
                type: z.string().optional(),
                title: z
                  .array(
                    z.object({
                      type: z.string().optional(),
                      text: z
                        .object({
                          content: z.string().optional(),
                          link: z.unknown().optional(),
                        })
                        .optional(),
                      annotations: z
                        .object({
                          bold: z.boolean().optional(),
                          italic: z.boolean().optional(),
                          strikethrough: z.boolean().optional(),
                          underline: z.boolean().optional(),
                          code: z.boolean().optional(),
                          color: z.string().optional(),
                        })
                        .optional(),
                      plain_text: z.string().optional(),
                      href: z.unknown().optional(),
                    }),
                  )
                  .optional(),
              })
              .optional(),
          })
          .optional(),
        url: z.string().optional(),
      }),
    )
    .optional(),
  next_cursor: z.unknown().optional(),
  has_more: z.boolean().optional(),
  type: z.string().optional(),
  page_or_database: z.record(z.unknown()).optional(),
});

export const postSearchErrorSchema = z.object({
  object: z.string().optional(),
  status: z.number().optional(),
  code: z.string().optional(),
  message: z.string().optional(),
});

export const getBlockChildrenDataSchema = z.object({
  headers: z.object({
    'Notion-Version': z.string(),
  }),
  path: z.object({
    block_id: z.string(),
  }),
  query: z
    .object({
      page_size: z.number().optional(),
      start_cursor: z.string().optional(),
    })
    .optional(),
});

export const getBlockChildrenResponseSchema = z.object({
  object: z.string().optional(),
  results: z
    .array(
      z.object({
        object: z.string().optional(),
        id: z.string().optional(),
        parent: z
          .object({
            type: z.string().optional(),
            page_id: z.string().optional(),
          })
          .optional(),
        created_time: z.string().optional(),
        last_edited_time: z.string().optional(),
        created_by: z
          .object({
            object: z.string().optional(),
            id: z.string().optional(),
          })
          .optional(),
        last_edited_by: z
          .object({
            object: z.string().optional(),
            id: z.string().optional(),
          })
          .optional(),
        has_children: z.boolean().optional(),
        archived: z.boolean().optional(),
        type: z.string().optional(),
        heading_2: z
          .object({
            rich_text: z
              .array(
                z.object({
                  type: z.string().optional(),
                  text: z
                    .object({
                      content: z.string().optional(),
                      link: z.unknown().optional(),
                    })
                    .optional(),
                  annotations: z
                    .object({
                      bold: z.boolean().optional(),
                      italic: z.boolean().optional(),
                      strikethrough: z.boolean().optional(),
                      underline: z.boolean().optional(),
                      code: z.boolean().optional(),
                      color: z.string().optional(),
                    })
                    .optional(),
                  plain_text: z.string().optional(),
                  href: z.unknown().optional(),
                }),
              )
              .optional(),
            color: z.string().optional(),
            is_toggleable: z.boolean().optional(),
          })
          .optional(),
      }),
    )
    .optional(),
  next_cursor: z.unknown().optional(),
  has_more: z.boolean().optional(),
  type: z.string().optional(),
  block: z.record(z.unknown()).optional(),
});

export const getBlockChildrenErrorSchema = z.record(z.unknown());

export const patchBlockChildrenDataSchema = z.object({
  body: z
    .object({
      children: z.array(z.unknown()),
      after: z.string().optional(),
    })
    .optional(),
  headers: z.object({
    'Notion-Version': z.string(),
  }),
  path: z.object({
    block_id: z.string(),
  }),
});

export const patchBlockChildrenResponseSchema = z.object({
  object: z.string().optional(),
  results: z
    .array(
      z.object({
        object: z.string().optional(),
        id: z.string().optional(),
        parent: z
          .object({
            type: z.string().optional(),
            page_id: z.string().optional(),
          })
          .optional(),
        created_time: z.string().optional(),
        last_edited_time: z.string().optional(),
        created_by: z
          .object({
            object: z.string().optional(),
            id: z.string().optional(),
          })
          .optional(),
        last_edited_by: z
          .object({
            object: z.string().optional(),
            id: z.string().optional(),
          })
          .optional(),
        has_children: z.boolean().optional(),
        archived: z.boolean().optional(),
        type: z.string().optional(),
        heading_2: z
          .object({
            rich_text: z
              .array(
                z.object({
                  type: z.string().optional(),
                  text: z
                    .object({
                      content: z.string().optional(),
                      link: z.unknown().optional(),
                    })
                    .optional(),
                  annotations: z
                    .object({
                      bold: z.boolean().optional(),
                      italic: z.boolean().optional(),
                      strikethrough: z.boolean().optional(),
                      underline: z.boolean().optional(),
                      code: z.boolean().optional(),
                      color: z.string().optional(),
                    })
                    .optional(),
                  plain_text: z.string().optional(),
                  href: z.unknown().optional(),
                }),
              )
              .optional(),
            color: z.string().optional(),
            is_toggleable: z.boolean().optional(),
          })
          .optional(),
      }),
    )
    .optional(),
  next_cursor: z.unknown().optional(),
  has_more: z.boolean().optional(),
  type: z.string().optional(),
  block: z.record(z.unknown()).optional(),
});

export const patchBlockChildrenErrorSchema = z.record(z.unknown());

export const retrieveAblockDataSchema = z.object({
  headers: z
    .object({
      'Notion-Version': z.string().optional(),
    })
    .optional(),
  path: z.object({
    block_id: z.string(),
  }),
});

export const retrieveAblockResponseSchema = z.object({
  object: z.string().optional(),
  id: z.string().optional(),
  parent: z
    .object({
      type: z.string().optional(),
      page_id: z.string().optional(),
    })
    .optional(),
  created_time: z.string().optional(),
  last_edited_time: z.string().optional(),
  created_by: z
    .object({
      object: z.string().optional(),
      id: z.string().optional(),
    })
    .optional(),
  last_edited_by: z
    .object({
      object: z.string().optional(),
      id: z.string().optional(),
    })
    .optional(),
  has_children: z.boolean().optional(),
  archived: z.boolean().optional(),
  type: z.string().optional(),
  heading_2: z
    .object({
      rich_text: z
        .array(
          z.object({
            type: z.string().optional(),
            text: z
              .object({
                content: z.string().optional(),
                link: z.unknown().optional(),
              })
              .optional(),
            annotations: z
              .object({
                bold: z.boolean().optional(),
                italic: z.boolean().optional(),
                strikethrough: z.boolean().optional(),
                underline: z.boolean().optional(),
                code: z.boolean().optional(),
                color: z.string().optional(),
              })
              .optional(),
            plain_text: z.string().optional(),
            href: z.unknown().optional(),
          }),
        )
        .optional(),
      color: z.string().optional(),
      is_toggleable: z.boolean().optional(),
    })
    .optional(),
});

export const retrieveAblockErrorSchema = z.record(z.unknown());

export const updateAblockDataSchema = z.object({
  body: z
    .object({
      '{type}': z.record(z.unknown()).optional(),
      archived: z.boolean().optional(),
    })
    .optional(),
  headers: z
    .object({
      'Notion-Version': z.string().optional(),
    })
    .optional(),
  path: z.object({
    block_id: z.string(),
  }),
});

export const updateAblockResponseSchema = z.object({
  object: z.string().optional(),
  id: z.string().optional(),
  parent: z
    .object({
      type: z.string().optional(),
      page_id: z.string().optional(),
    })
    .optional(),
  created_time: z.string().optional(),
  last_edited_time: z.string().optional(),
  created_by: z
    .object({
      object: z.string().optional(),
      id: z.string().optional(),
    })
    .optional(),
  last_edited_by: z
    .object({
      object: z.string().optional(),
      id: z.string().optional(),
    })
    .optional(),
  has_children: z.boolean().optional(),
  archived: z.boolean().optional(),
  type: z.string().optional(),
  heading_2: z
    .object({
      rich_text: z
        .array(
          z.object({
            type: z.string().optional(),
            text: z
              .object({
                content: z.string().optional(),
                link: z.unknown().optional(),
              })
              .optional(),
            annotations: z
              .object({
                bold: z.boolean().optional(),
                italic: z.boolean().optional(),
                strikethrough: z.boolean().optional(),
                underline: z.boolean().optional(),
                code: z.boolean().optional(),
                color: z.string().optional(),
              })
              .optional(),
            plain_text: z.string().optional(),
            href: z.unknown().optional(),
          }),
        )
        .optional(),
      color: z.string().optional(),
      is_toggleable: z.boolean().optional(),
    })
    .optional(),
});

export const updateAblockErrorSchema = z.record(z.unknown());

export const deleteAblockDataSchema = z.object({
  headers: z
    .object({
      'Notion-Version': z.string().optional(),
    })
    .optional(),
  path: z.object({
    block_id: z.string(),
  }),
});

export const deleteAblockResponseSchema = z.object({
  object: z.string().optional(),
  id: z.string().optional(),
  parent: z
    .object({
      type: z.string().optional(),
      page_id: z.string().optional(),
    })
    .optional(),
  created_time: z.string().optional(),
  last_edited_time: z.string().optional(),
  created_by: z
    .object({
      object: z.string().optional(),
      id: z.string().optional(),
    })
    .optional(),
  last_edited_by: z
    .object({
      object: z.string().optional(),
      id: z.string().optional(),
    })
    .optional(),
  has_children: z.boolean().optional(),
  archived: z.boolean().optional(),
  type: z.string().optional(),
  paragraph: z
    .object({
      rich_text: z.array(z.unknown()).optional(),
      color: z.string().optional(),
    })
    .optional(),
});

export const deleteAblockErrorSchema = z.record(z.unknown());

export const retrieveApageDataSchema = z.object({
  headers: z.object({
    'Notion-Version': z.string(),
  }),
  path: z.object({
    page_id: z.string(),
  }),
  query: z
    .object({
      filter_properties: z.string().optional(),
    })
    .optional(),
});

export const retrieveApageResponseSchema = z.object({
  object: z.string().optional(),
  id: z.string().optional(),
  created_time: z.string().optional(),
  last_edited_time: z.string().optional(),
  created_by: z
    .object({
      object: z.string().optional(),
      id: z.string().optional(),
    })
    .optional(),
  last_edited_by: z
    .object({
      object: z.string().optional(),
      id: z.string().optional(),
    })
    .optional(),
  cover: z
    .object({
      type: z.string().optional(),
      external: z
        .object({
          url: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  icon: z
    .object({
      type: z.string().optional(),
      emoji: z.string().optional(),
    })
    .optional(),
  parent: z
    .object({
      type: z.string().optional(),
      database_id: z.string().optional(),
    })
    .optional(),
  archived: z.boolean().optional(),
  properties: z
    .object({
      'Store availability': z
        .object({
          id: z.string().optional(),
          type: z.string().optional(),
          multi_select: z
            .array(
              z.object({
                id: z.string().optional(),
                name: z.string().optional(),
                color: z.string().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      'Food group': z
        .object({
          id: z.string().optional(),
          type: z.string().optional(),
          select: z
            .object({
              id: z.string().optional(),
              name: z.string().optional(),
              color: z.string().optional(),
            })
            .optional(),
        })
        .optional(),
      Price: z
        .object({
          id: z.string().optional(),
          type: z.string().optional(),
          number: z.number().optional(),
        })
        .optional(),
      'Responsible Person': z
        .object({
          id: z.string().optional(),
          type: z.string().optional(),
          people: z
            .array(
              z.object({
                object: z.string().optional(),
                id: z.string().optional(),
                name: z.string().optional(),
                avatar_url: z.string().optional(),
                type: z.string().optional(),
                person: z
                  .object({
                    email: z.string().optional(),
                  })
                  .optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      'Last ordered': z
        .object({
          id: z.string().optional(),
          type: z.string().optional(),
          date: z
            .object({
              start: z.string().optional(),
              end: z.unknown().optional(),
              time_zone: z.unknown().optional(),
            })
            .optional(),
        })
        .optional(),
      'Cost of next trip': z
        .object({
          id: z.string().optional(),
          type: z.string().optional(),
          formula: z
            .object({
              type: z.string().optional(),
              number: z.number().optional(),
            })
            .optional(),
        })
        .optional(),
      Recipes: z
        .object({
          id: z.string().optional(),
          type: z.string().optional(),
          relation: z
            .array(
              z.object({
                id: z.string().optional(),
              }),
            )
            .optional(),
          has_more: z.boolean().optional(),
        })
        .optional(),
      Description: z
        .object({
          id: z.string().optional(),
          type: z.string().optional(),
          rich_text: z
            .array(
              z.object({
                type: z.string().optional(),
                text: z
                  .object({
                    content: z.string().optional(),
                    link: z.unknown().optional(),
                  })
                  .optional(),
                annotations: z
                  .object({
                    bold: z.boolean().optional(),
                    italic: z.boolean().optional(),
                    strikethrough: z.boolean().optional(),
                    underline: z.boolean().optional(),
                    code: z.boolean().optional(),
                    color: z.string().optional(),
                  })
                  .optional(),
                plain_text: z.string().optional(),
                href: z.unknown().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      'In stock': z
        .object({
          id: z.string().optional(),
          type: z.string().optional(),
          checkbox: z.boolean().optional(),
        })
        .optional(),
      'Number of meals': z
        .object({
          id: z.string().optional(),
          type: z.string().optional(),
          rollup: z
            .object({
              type: z.string().optional(),
              number: z.number().optional(),
              function: z.string().optional(),
            })
            .optional(),
        })
        .optional(),
      Photo: z
        .object({
          id: z.string().optional(),
          type: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
      Name: z
        .object({
          id: z.string().optional(),
          type: z.string().optional(),
          title: z
            .array(
              z.object({
                type: z.string().optional(),
                text: z
                  .object({
                    content: z.string().optional(),
                    link: z.unknown().optional(),
                  })
                  .optional(),
                annotations: z
                  .object({
                    bold: z.boolean().optional(),
                    italic: z.boolean().optional(),
                    strikethrough: z.boolean().optional(),
                    underline: z.boolean().optional(),
                    code: z.boolean().optional(),
                    color: z.string().optional(),
                  })
                  .optional(),
                plain_text: z.string().optional(),
                href: z.unknown().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
    })
    .optional(),
  url: z.string().optional(),
  public_url: z.unknown().optional(),
});

export const retrieveApageErrorSchema = z.record(z.unknown());

export const patchPageDataSchema = z.object({
  body: z
    .object({
      properties: z.string().optional(),
      in_trash: z.boolean().optional(),
      icon: z.string().optional(),
      cover: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      'Notion-Version': z.string().optional(),
    })
    .optional(),
  path: z.object({
    page_id: z.string(),
  }),
});

export const patchPageResponseSchema = z.object({
  object: z.string().optional(),
  id: z.string().optional(),
  created_time: z.string().optional(),
  last_edited_time: z.string().optional(),
  created_by: z
    .object({
      object: z.string().optional(),
      id: z.string().optional(),
    })
    .optional(),
  last_edited_by: z
    .object({
      object: z.string().optional(),
      id: z.string().optional(),
    })
    .optional(),
  cover: z
    .object({
      type: z.string().optional(),
      external: z
        .object({
          url: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  icon: z
    .object({
      type: z.string().optional(),
      emoji: z.string().optional(),
    })
    .optional(),
  parent: z
    .object({
      type: z.string().optional(),
      database_id: z.string().optional(),
    })
    .optional(),
  archived: z.boolean().optional(),
  properties: z
    .object({
      'Store availability': z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      'Food group': z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      Price: z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      'Responsible Person': z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      'Last ordered': z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      'Cost of next trip': z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      Recipes: z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      Description: z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      'In stock': z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      'Number of meals': z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      Photo: z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      Name: z
        .object({
          id: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  url: z.string().optional(),
});

export const patchPageErrorSchema = z.union([
  z.record(z.unknown()),
  z.object({
    object: z.string().optional(),
    status: z.number().optional(),
    code: z.string().optional(),
    message: z.string().optional(),
  }),
]);

export const postPageDataSchema = z.object({
  body: z
    .object({
      parent: z.string(),
      properties: z.string(),
      children: z.array(z.string()).optional(),
      icon: z.string().optional(),
      cover: z.string().optional(),
    })
    .optional(),
  headers: z.object({
    'Notion-Version': z.string(),
  }),
});

export const postPageResponseSchema = z.object({
  object: z.string().optional(),
  id: z.string().optional(),
  created_time: z.string().optional(),
  last_edited_time: z.string().optional(),
  created_by: z
    .object({
      object: z.string().optional(),
      id: z.string().optional(),
    })
    .optional(),
  last_edited_by: z
    .object({
      object: z.string().optional(),
      id: z.string().optional(),
    })
    .optional(),
  cover: z
    .object({
      type: z.string().optional(),
      external: z
        .object({
          url: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  icon: z
    .object({
      type: z.string().optional(),
      emoji: z.string().optional(),
    })
    .optional(),
  parent: z
    .object({
      type: z.string().optional(),
      database_id: z.string().optional(),
    })
    .optional(),
  archived: z.boolean().optional(),
  properties: z
    .object({
      'Store availability': z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      'Food group': z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      Price: z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      'Responsible Person': z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      'Last ordered': z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      'Cost of next trip': z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      Recipes: z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      Description: z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      'In stock': z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      'Number of meals': z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      Photo: z
        .object({
          id: z.string().optional(),
        })
        .optional(),
      Name: z
        .object({
          id: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  url: z.string().optional(),
});

export const postPageErrorSchema = z.union([
  z.record(z.unknown()),
  z.object({
    object: z.string().optional(),
    status: z.number().optional(),
    code: z.string().optional(),
    message: z.string().optional(),
  }),
]);

export const createAdatabaseDataSchema = z.object({
  body: z
    .object({
      parent: z.string(),
      title: z.array(z.unknown()).optional(),
      properties: z.string(),
    })
    .optional(),
  headers: z.object({
    'Notion-Version': z.string(),
  }),
});

export const createAdatabaseResponseSchema = z.unknown();

export const createAdatabaseErrorSchema = z.record(z.unknown());

export const updateAdatabaseDataSchema = z.object({
  body: z
    .object({
      title: z.array(z.unknown()).optional(),
      description: z.array(z.unknown()).optional(),
      properties: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      'Notion-Version': z.string().optional(),
    })
    .optional(),
  path: z.object({
    database_id: z.string(),
  }),
});

export const updateAdatabaseResponseSchema = z.unknown();

export const updateAdatabaseErrorSchema = z.union([
  z.object({
    object: z.string().optional(),
    status: z.number().optional(),
    code: z.string().optional(),
    message: z.string().optional(),
  }),
  z.object({
    object: z.string().optional(),
    status: z.number().optional(),
    code: z.string().optional(),
    message: z.string().optional(),
  }),
]);

export const retrieveAdatabaseDataSchema = z.object({
  headers: z.object({
    'Notion-Version': z.string(),
  }),
  path: z.object({
    database_id: z.string(),
  }),
});

export const retrieveAdatabaseResponseSchema = z.object({
  object: z.string().optional(),
  id: z.string().optional(),
  created_time: z.string().optional(),
  last_edited_time: z.string().optional(),
  icon: z
    .object({
      type: z.string().optional(),
      emoji: z.string().optional(),
    })
    .optional(),
  cover: z
    .object({
      type: z.string().optional(),
      external: z
        .object({
          url: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  url: z.string().optional(),
  title: z
    .array(
      z.object({
        type: z.string().optional(),
        text: z
          .object({
            content: z.string().optional(),
            link: z.unknown().optional(),
          })
          .optional(),
        annotations: z
          .object({
            bold: z.boolean().optional(),
            italic: z.boolean().optional(),
            strikethrough: z.boolean().optional(),
            underline: z.boolean().optional(),
            code: z.boolean().optional(),
            color: z.string().optional(),
          })
          .optional(),
        plain_text: z.string().optional(),
        href: z.unknown().optional(),
      }),
    )
    .optional(),
  description: z
    .array(
      z.object({
        type: z.string().optional(),
        text: z
          .object({
            content: z.string().optional(),
            link: z.unknown().optional(),
          })
          .optional(),
        annotations: z
          .object({
            bold: z.boolean().optional(),
            italic: z.boolean().optional(),
            strikethrough: z.boolean().optional(),
            underline: z.boolean().optional(),
            code: z.boolean().optional(),
            color: z.string().optional(),
          })
          .optional(),
        plain_text: z.string().optional(),
        href: z.unknown().optional(),
      }),
    )
    .optional(),
  properties: z
    .object({
      '+1': z
        .object({
          id: z.string().optional(),
          name: z.string().optional(),
          type: z.string().optional(),
          people: z.record(z.unknown()).optional(),
        })
        .optional(),
      'In stock': z
        .object({
          id: z.string().optional(),
          name: z.string().optional(),
          type: z.string().optional(),
          checkbox: z.record(z.unknown()).optional(),
        })
        .optional(),
      Price: z
        .object({
          id: z.string().optional(),
          name: z.string().optional(),
          type: z.string().optional(),
          number: z
            .object({
              format: z.string().optional(),
            })
            .optional(),
        })
        .optional(),
      Description: z
        .object({
          id: z.string().optional(),
          name: z.string().optional(),
          type: z.string().optional(),
          rich_text: z.record(z.unknown()).optional(),
        })
        .optional(),
      'Last ordered': z
        .object({
          id: z.string().optional(),
          name: z.string().optional(),
          type: z.string().optional(),
          date: z.record(z.unknown()).optional(),
        })
        .optional(),
      Meals: z
        .object({
          id: z.string().optional(),
          name: z.string().optional(),
          type: z.string().optional(),
          relation: z
            .object({
              database_id: z.string().optional(),
              synced_property_name: z.string().optional(),
            })
            .optional(),
        })
        .optional(),
      'Number of meals': z
        .object({
          id: z.string().optional(),
          name: z.string().optional(),
          type: z.string().optional(),
          rollup: z
            .object({
              rollup_property_name: z.string().optional(),
              relation_property_name: z.string().optional(),
              rollup_property_id: z.string().optional(),
              relation_property_id: z.string().optional(),
              function: z.string().optional(),
            })
            .optional(),
        })
        .optional(),
      'Store availability': z
        .object({
          id: z.string().optional(),
          name: z.string().optional(),
          type: z.string().optional(),
          multi_select: z
            .object({
              options: z
                .array(
                  z.object({
                    id: z.string().optional(),
                    name: z.string().optional(),
                    color: z.string().optional(),
                  }),
                )
                .optional(),
            })
            .optional(),
        })
        .optional(),
      Photo: z
        .object({
          id: z.string().optional(),
          name: z.string().optional(),
          type: z.string().optional(),
          files: z.record(z.unknown()).optional(),
        })
        .optional(),
      'Food group': z
        .object({
          id: z.string().optional(),
          name: z.string().optional(),
          type: z.string().optional(),
          select: z
            .object({
              options: z
                .array(
                  z.object({
                    id: z.string().optional(),
                    name: z.string().optional(),
                    color: z.string().optional(),
                  }),
                )
                .optional(),
            })
            .optional(),
        })
        .optional(),
      Name: z
        .object({
          id: z.string().optional(),
          name: z.string().optional(),
          type: z.string().optional(),
          title: z.record(z.unknown()).optional(),
        })
        .optional(),
    })
    .optional(),
  parent: z
    .object({
      type: z.string().optional(),
      page_id: z.string().optional(),
    })
    .optional(),
  archived: z.boolean().optional(),
  is_inline: z.boolean().optional(),
  public_url: z.unknown().optional(),
});

export const retrieveAdatabaseErrorSchema = z.union([
  z.record(z.unknown()),
  z.object({
    object: z.string().optional(),
    status: z.number().optional(),
    code: z.string().optional(),
    message: z.string().optional(),
  }),
]);

export const retrieveApagePropertyDataSchema = z.object({
  headers: z
    .object({
      'Notion-Version': z.string().optional(),
    })
    .optional(),
  path: z.object({
    page_id: z.string(),
    property_id: z.string(),
  }),
  query: z
    .object({
      page_size: z.number().optional(),
      start_cursor: z.string().optional(),
    })
    .optional(),
});

export const retrieveApagePropertyResponseSchema = z.unknown();

export const retrieveApagePropertyErrorSchema = z.unknown();

export const getSelfDataSchema = z.object({
  headers: z.object({
    'Notion-Version': z.string(),
  }),
});

export const getSelfResponseSchema = z.object({
  object: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  avatar_url: z.unknown().optional(),
  type: z.string().optional(),
  bot: z
    .object({
      owner: z
        .object({
          type: z.string().optional(),
          user: z
            .object({
              object: z.string().optional(),
              id: z.string().optional(),
              name: z.string().optional(),
              avatar_url: z.unknown().optional(),
              type: z.string().optional(),
              person: z
                .object({
                  email: z.string().optional(),
                })
                .optional(),
            })
            .optional(),
        })
        .optional(),
    })
    .optional(),
});

export const getSelfErrorSchema = z.record(z.unknown());

export const retrieveAcommentDataSchema = z.object({
  headers: z.object({
    'Notion-Version': z.string(),
  }),
  query: z.object({
    block_id: z.string(),
    page_size: z.number().optional(),
    start_cursor: z.string().optional(),
  }),
});

export const retrieveAcommentResponseSchema = z.object({
  object: z.string().optional(),
  results: z
    .array(
      z.object({
        object: z.string().optional(),
        id: z.string().optional(),
        parent: z
          .object({
            type: z.string().optional(),
            page_id: z.string().optional(),
          })
          .optional(),
        discussion_id: z.string().optional(),
        created_time: z.string().optional(),
        last_edited_time: z.string().optional(),
        created_by: z
          .object({
            object: z.string().optional(),
            id: z.string().optional(),
          })
          .optional(),
        rich_text: z
          .array(
            z.object({
              type: z.string().optional(),
              text: z
                .object({
                  content: z.string().optional(),
                  link: z.unknown().optional(),
                })
                .optional(),
              annotations: z
                .object({
                  bold: z.boolean().optional(),
                  italic: z.boolean().optional(),
                  strikethrough: z.boolean().optional(),
                  underline: z.boolean().optional(),
                  code: z.boolean().optional(),
                  color: z.string().optional(),
                })
                .optional(),
              plain_text: z.string().optional(),
              href: z.unknown().optional(),
            }),
          )
          .optional(),
      }),
    )
    .optional(),
  next_cursor: z.unknown().optional(),
  has_more: z.boolean().optional(),
  type: z.string().optional(),
  comment: z.record(z.unknown()).optional(),
});

export const retrieveAcommentErrorSchema = z.object({
  object: z.string().optional(),
  status: z.number().optional(),
  code: z.string().optional(),
  message: z.string().optional(),
});

export const createAcommentDataSchema = z.object({
  body: z
    .object({
      parent: z.string().optional(),
      discussion_id: z.string().optional(),
      rich_text: z.string(),
    })
    .optional(),
  headers: z.object({
    'Notion-Version': z.string(),
  }),
});

export const createAcommentResponseSchema = z.object({
  object: z.string().optional(),
  id: z.string().optional(),
  parent: z
    .object({
      type: z.string().optional(),
      page_id: z.string().optional(),
    })
    .optional(),
  discussion_id: z.string().optional(),
  created_time: z.string().optional(),
  last_edited_time: z.string().optional(),
  created_by: z
    .object({
      object: z.string().optional(),
      id: z.string().optional(),
    })
    .optional(),
  rich_text: z
    .array(
      z.object({
        type: z.string().optional(),
        text: z
          .object({
            content: z.string().optional(),
            link: z.unknown().optional(),
          })
          .optional(),
        annotations: z
          .object({
            bold: z.boolean().optional(),
            italic: z.boolean().optional(),
            strikethrough: z.boolean().optional(),
            underline: z.boolean().optional(),
            code: z.boolean().optional(),
            color: z.string().optional(),
          })
          .optional(),
        plain_text: z.string().optional(),
        href: z.unknown().optional(),
      }),
    )
    .optional(),
});

export const createAcommentErrorSchema = z.object({
  object: z.string().optional(),
  status: z.number().optional(),
  code: z.string().optional(),
  message: z.string().optional(),
});

export const createAtokenDataSchema = z.object({
  body: z
    .object({
      code: z.string(),
      grant_type: z.string(),
      redirect_uri: z.string(),
      external_account: z.record(z.unknown()).optional(),
    })
    .optional(),
});

export const createAtokenResponseSchema = z.object({
  access_token: z.string().optional(),
  bot_id: z.string().optional(),
  duplicated_template_id: z.unknown().optional(),
  owner: z
    .object({
      workspace: z.boolean().optional(),
    })
    .optional(),
  workspace_icon: z.string().optional(),
  workspace_id: z.string().optional(),
  workspace_name: z.string().optional(),
});

export const createAtokenErrorSchema = z.object({
  error: z.string().optional(),
  error_description: z.string().optional(),
});
