// This file is auto-generated by @hey-api/openapi-ts

export type GetUserData = {
  headers: {
    'Notion-Version': string;
  };
  path: {
    /**
     * Identifier for a Notion user
     */
    user_id: string;
  };
};

export type GetUserResponse = unknown;

export type GetUserError = {
  [key: string]: unknown;
};

export type GetUsersData = {
  headers: {
    'Notion-Version': string;
  };
  query?: {
    /**
     * The number of items from the full list desired in the response. Maximum: 100
     */
    page_size?: number;
    /**
     * If supplied, this endpoint will return a page of results starting after the cursor provided. If not supplied, this endpoint will return the first page of results.
     */
    start_cursor?: string;
  };
};

export type GetUsersResponse = unknown;

export type GetUsersError = {
  [key: string]: unknown;
};

export type PostDatabaseQueryData = {
  body?: {
    /**
     * When supplied, limits which pages are returned based on the [filter conditions](ref:post-database-query-filter).
     */
    filter?: string;
    /**
     * When supplied, orders the results based on the provided [sort criteria](ref:post-database-query-sort).
     */
    sorts?: unknown[];
    /**
     * When supplied, returns a page of results starting after the cursor provided. If not supplied, this endpoint will return the first page of results.
     */
    start_cursor?: string;
    /**
     * The number of items from the full list desired in the response. Maximum: 100
     */
    page_size?: number;
  };
  headers: {
    'Notion-Version': string;
  };
  path: {
    /**
     * Identifier for a Notion database.
     */
    database_id: string;
  };
  query?: {
    /**
     * A list of page property value IDs associated with the database. Use this param to limit the response to a specific page property value or values for pages that meet the `filter` criteria.
     */
    filter_properties?: string;
  };
};

export type PostDatabaseQueryResponse = {
  object?: string;
  results?: Array<{
    object?: string;
    id?: string;
    created_time?: string;
    last_edited_time?: string;
    created_by?: {
      object?: string;
      id?: string;
    };
    last_edited_by?: {
      object?: string;
      id?: string;
    };
    cover?: {
      type?: string;
      external?: {
        url?: string;
      };
    };
    icon?: {
      type?: string;
      emoji?: string;
    };
    parent?: {
      type?: string;
      database_id?: string;
    };
    archived?: boolean;
    properties?: {
      'Store availability'?: {
        id?: string;
        type?: string;
        multi_select?: Array<{
          id?: string;
          name?: string;
          color?: string;
        }>;
      };
      'Food group'?: {
        id?: string;
        type?: string;
        select?: {
          id?: string;
          name?: string;
          color?: string;
        };
      };
      Price?: {
        id?: string;
        type?: string;
        number?: number;
      };
      'Responsible Person'?: {
        id?: string;
        type?: string;
        people?: Array<{
          object?: string;
          id?: string;
          name?: string;
          avatar_url?: string;
          type?: string;
          person?: {
            email?: string;
          };
        }>;
      };
      'Last ordered'?: {
        id?: string;
        type?: string;
        date?: {
          start?: string;
          end?: unknown;
          time_zone?: unknown;
        };
      };
      'Cost of next trip'?: {
        id?: string;
        type?: string;
        formula?: {
          type?: string;
          number?: number;
        };
      };
      Recipes?: {
        id?: string;
        type?: string;
        relation?: Array<{
          id?: string;
        }>;
        has_more?: boolean;
      };
      Description?: {
        id?: string;
        type?: string;
        rich_text?: Array<{
          type?: string;
          text?: {
            content?: string;
            link?: unknown;
          };
          annotations?: {
            bold?: boolean;
            italic?: boolean;
            strikethrough?: boolean;
            underline?: boolean;
            code?: boolean;
            color?: string;
          };
          plain_text?: string;
          href?: unknown;
        }>;
      };
      'In stock'?: {
        id?: string;
        type?: string;
        checkbox?: boolean;
      };
      'Number of meals'?: {
        id?: string;
        type?: string;
        rollup?: {
          type?: string;
          number?: number;
          function?: string;
        };
      };
      Photo?: {
        id?: string;
        type?: string;
        url?: string;
      };
      Name?: {
        id?: string;
        type?: string;
        title?: Array<{
          type?: string;
          text?: {
            content?: string;
            link?: unknown;
          };
          annotations?: {
            bold?: boolean;
            italic?: boolean;
            strikethrough?: boolean;
            underline?: boolean;
            code?: boolean;
            color?: string;
          };
          plain_text?: string;
          href?: unknown;
        }>;
      };
    };
    url?: string;
  }>;
  next_cursor?: unknown;
  has_more?: boolean;
  type?: string;
  page_or_database?: {
    [key: string]: unknown;
  };
};

export type PostDatabaseQueryError = {
  [key: string]: unknown;
};

export type PostSearchData = {
  body?: {
    /**
     * The text that the API compares page and database titles against.
     */
    query?: string;
    /**
     * A set of criteria, `direction` and `timestamp` keys, that orders the results. The **only** supported timestamp value is `"last_edited_time"`. Supported `direction` values are `"ascending"` and `"descending"`. If `sort` is not provided, then the most recently edited results are returned first.
     */
    sort?: {
      /**
       * The direction to sort. Possible values include `ascending` and `descending`.
       */
      direction?: string;
      /**
       * The name of the timestamp to sort against. Possible values include `last_edited_time`.
       */
      timestamp?: string;
    };
    /**
     * A set of criteria, `value` and `property` keys, that limits the results to either only pages or only databases. Possible `value` values are `"page"` or `"database"`. The only supported `property` value is `"object"`.
     */
    filter?: {
      /**
       * The value of the property to filter the results by.  Possible values for object type include `page` or `database`.  **Limitation**: Currently the only filter allowed is `object` which will filter by type of object (either `page` or `database`)
       */
      value?: string;
      /**
       * The name of the property to filter by. Currently the only property you can filter by is the object type.  Possible values include `object`.   Limitation: Currently the only filter allowed is `object` which will filter by type of object (either `page` or `database`)
       */
      property?: string;
    };
    /**
     * A `cursor` value returned in a previous response that If supplied, limits the response to results starting after the `cursor`. If not supplied, then the first page of results is returned. Refer to [pagination](https://developers.notion.com/reference/intro#pagination) for more details.
     */
    start_cursor?: string;
    /**
     * The number of items from the full list to include in the response. Maximum: `100`.
     */
    page_size?: number;
  };
  headers: {
    'Notion-Version': string;
  };
};

export type PostSearchResponse = {
  object?: string;
  results?: Array<{
    object?: string;
    id?: string;
    created_time?: string;
    last_edited_time?: string;
    created_by?: {
      object?: string;
      id?: string;
    };
    last_edited_by?: {
      object?: string;
      id?: string;
    };
    cover?: {
      type?: string;
      external?: {
        url?: string;
      };
    };
    icon?: {
      type?: string;
      emoji?: string;
    };
    parent?: {
      type?: string;
      database_id?: string;
    };
    archived?: boolean;
    properties?: {
      'Store availability'?: {
        id?: string;
        type?: string;
        multi_select?: unknown[];
      };
      'Food group'?: {
        id?: string;
        type?: string;
        select?: {
          id?: string;
          name?: string;
          color?: string;
        };
      };
      Price?: {
        id?: string;
        type?: string;
        number?: unknown;
      };
      'Responsible Person'?: {
        id?: string;
        type?: string;
        people?: unknown[];
      };
      'Last ordered'?: {
        id?: string;
        type?: string;
        date?: unknown;
      };
      'Cost of next trip'?: {
        id?: string;
        type?: string;
        formula?: {
          type?: string;
          number?: unknown;
        };
      };
      Recipes?: {
        id?: string;
        type?: string;
        relation?: unknown[];
      };
      Description?: {
        id?: string;
        type?: string;
        rich_text?: Array<{
          type?: string;
          text?: {
            content?: string;
            link?: unknown;
          };
          annotations?: {
            bold?: boolean;
            italic?: boolean;
            strikethrough?: boolean;
            underline?: boolean;
            code?: boolean;
            color?: string;
          };
          plain_text?: string;
          href?: unknown;
        }>;
      };
      'In stock'?: {
        id?: string;
        type?: string;
        checkbox?: boolean;
      };
      'Number of meals'?: {
        id?: string;
        type?: string;
        rollup?: {
          type?: string;
          number?: number;
          function?: string;
        };
      };
      Photo?: {
        id?: string;
        type?: string;
        url?: unknown;
      };
      Name?: {
        id?: string;
        type?: string;
        title?: Array<{
          type?: string;
          text?: {
            content?: string;
            link?: unknown;
          };
          annotations?: {
            bold?: boolean;
            italic?: boolean;
            strikethrough?: boolean;
            underline?: boolean;
            code?: boolean;
            color?: string;
          };
          plain_text?: string;
          href?: unknown;
        }>;
      };
    };
    url?: string;
  }>;
  next_cursor?: unknown;
  has_more?: boolean;
  type?: string;
  page_or_database?: {
    [key: string]: unknown;
  };
};

export type PostSearchError = {
  object?: string;
  status?: number;
  code?: string;
  message?: string;
};

export type GetBlockChildrenData = {
  headers: {
    'Notion-Version': string;
  };
  path: {
    /**
     * Identifier for a [block](ref:block)
     */
    block_id: string;
  };
  query?: {
    /**
     * The number of items from the full list desired in the response. Maximum: 100
     */
    page_size?: number;
    /**
     * If supplied, this endpoint will return a page of results starting after the cursor provided. If not supplied, this endpoint will return the first page of results.
     */
    start_cursor?: string;
  };
};

export type GetBlockChildrenResponse = {
  object?: string;
  results?: Array<{
    object?: string;
    id?: string;
    parent?: {
      type?: string;
      page_id?: string;
    };
    created_time?: string;
    last_edited_time?: string;
    created_by?: {
      object?: string;
      id?: string;
    };
    last_edited_by?: {
      object?: string;
      id?: string;
    };
    has_children?: boolean;
    archived?: boolean;
    type?: string;
    heading_2?: {
      rich_text?: Array<{
        type?: string;
        text?: {
          content?: string;
          link?: unknown;
        };
        annotations?: {
          bold?: boolean;
          italic?: boolean;
          strikethrough?: boolean;
          underline?: boolean;
          code?: boolean;
          color?: string;
        };
        plain_text?: string;
        href?: unknown;
      }>;
      color?: string;
      is_toggleable?: boolean;
    };
  }>;
  next_cursor?: unknown;
  has_more?: boolean;
  type?: string;
  block?: {
    [key: string]: unknown;
  };
};

export type GetBlockChildrenError = {
  [key: string]: unknown;
};

export type PatchBlockChildrenData = {
  body?: {
    /**
     * Child content to append to a container block as an array of [block objects](ref:block)
     */
    children: unknown[];
    /**
     * The ID of the existing block that the new block should be appended after.
     */
    after?: string;
  };
  headers: {
    'Notion-Version': string;
  };
  path: {
    /**
     * Identifier for a [block](ref:block). Also accepts a [page](ref:page) ID.
     */
    block_id: string;
  };
};

export type PatchBlockChildrenResponse = {
  object?: string;
  results?: Array<{
    object?: string;
    id?: string;
    parent?: {
      type?: string;
      page_id?: string;
    };
    created_time?: string;
    last_edited_time?: string;
    created_by?: {
      object?: string;
      id?: string;
    };
    last_edited_by?: {
      object?: string;
      id?: string;
    };
    has_children?: boolean;
    archived?: boolean;
    type?: string;
    heading_2?: {
      rich_text?: Array<{
        type?: string;
        text?: {
          content?: string;
          link?: unknown;
        };
        annotations?: {
          bold?: boolean;
          italic?: boolean;
          strikethrough?: boolean;
          underline?: boolean;
          code?: boolean;
          color?: string;
        };
        plain_text?: string;
        href?: unknown;
      }>;
      color?: string;
      is_toggleable?: boolean;
    };
  }>;
  next_cursor?: unknown;
  has_more?: boolean;
  type?: string;
  block?: {
    [key: string]: unknown;
  };
};

export type PatchBlockChildrenError = {
  [key: string]: unknown;
};

export type RetrieveAblockData = {
  headers?: {
    'Notion-Version'?: string;
  };
  path: {
    /**
     * Identifier for a Notion block
     */
    block_id: string;
  };
};

export type RetrieveAblockResponse = {
  object?: string;
  id?: string;
  parent?: {
    type?: string;
    page_id?: string;
  };
  created_time?: string;
  last_edited_time?: string;
  created_by?: {
    object?: string;
    id?: string;
  };
  last_edited_by?: {
    object?: string;
    id?: string;
  };
  has_children?: boolean;
  archived?: boolean;
  type?: string;
  heading_2?: {
    rich_text?: Array<{
      type?: string;
      text?: {
        content?: string;
        link?: unknown;
      };
      annotations?: {
        bold?: boolean;
        italic?: boolean;
        strikethrough?: boolean;
        underline?: boolean;
        code?: boolean;
        color?: string;
      };
      plain_text?: string;
      href?: unknown;
    }>;
    color?: string;
    is_toggleable?: boolean;
  };
};

export type RetrieveAblockError = {
  [key: string]: unknown;
};

export type UpdateAblockData = {
  body?: {
    /**
     * The [block object `type`](ref:block#block-object-keys) value with the properties to be updated. Currently only `text` (for supported block types) and `checked` (for `to_do` blocks) fields can be updated.
     */
    '{type}'?: {
      [key: string]: unknown;
    };
    /**
     * Set to true to archive (delete) a block. Set to false to un-archive (restore) a block.
     */
    archived?: boolean;
  };
  headers?: {
    'Notion-Version'?: string;
  };
  path: {
    /**
     * Identifier for a Notion block
     */
    block_id: string;
  };
};

export type UpdateAblockResponse = {
  object?: string;
  id?: string;
  parent?: {
    type?: string;
    page_id?: string;
  };
  created_time?: string;
  last_edited_time?: string;
  created_by?: {
    object?: string;
    id?: string;
  };
  last_edited_by?: {
    object?: string;
    id?: string;
  };
  has_children?: boolean;
  archived?: boolean;
  type?: string;
  heading_2?: {
    rich_text?: Array<{
      type?: string;
      text?: {
        content?: string;
        link?: unknown;
      };
      annotations?: {
        bold?: boolean;
        italic?: boolean;
        strikethrough?: boolean;
        underline?: boolean;
        code?: boolean;
        color?: string;
      };
      plain_text?: string;
      href?: unknown;
    }>;
    color?: string;
    is_toggleable?: boolean;
  };
};

export type UpdateAblockError = {
  [key: string]: unknown;
};

export type DeleteAblockData = {
  headers?: {
    'Notion-Version'?: string;
  };
  path: {
    /**
     * Identifier for a Notion block
     */
    block_id: string;
  };
};

export type DeleteAblockResponse = {
  object?: string;
  id?: string;
  parent?: {
    type?: string;
    page_id?: string;
  };
  created_time?: string;
  last_edited_time?: string;
  created_by?: {
    object?: string;
    id?: string;
  };
  last_edited_by?: {
    object?: string;
    id?: string;
  };
  has_children?: boolean;
  archived?: boolean;
  type?: string;
  paragraph?: {
    rich_text?: unknown[];
    color?: string;
  };
};

export type DeleteAblockError = {
  [key: string]: unknown;
};

export type RetrieveApageData = {
  headers: {
    'Notion-Version': string;
  };
  path: {
    /**
     * Identifier for a Notion page
     */
    page_id: string;
  };
  query?: {
    /**
     * A list of page property value IDs associated with the page. Use this param to limit the response to a specific page property value or values. To retrieve multiple properties, specify each page property ID. For example: `?filter_properties=iAk8&filter_properties=b7dh`.
     */
    filter_properties?: string;
  };
};

export type RetrieveApageResponse = {
  object?: string;
  id?: string;
  created_time?: string;
  last_edited_time?: string;
  created_by?: {
    object?: string;
    id?: string;
  };
  last_edited_by?: {
    object?: string;
    id?: string;
  };
  cover?: {
    type?: string;
    external?: {
      url?: string;
    };
  };
  icon?: {
    type?: string;
    emoji?: string;
  };
  parent?: {
    type?: string;
    database_id?: string;
  };
  archived?: boolean;
  properties?: {
    'Store availability'?: {
      id?: string;
      type?: string;
      multi_select?: Array<{
        id?: string;
        name?: string;
        color?: string;
      }>;
    };
    'Food group'?: {
      id?: string;
      type?: string;
      select?: {
        id?: string;
        name?: string;
        color?: string;
      };
    };
    Price?: {
      id?: string;
      type?: string;
      number?: number;
    };
    'Responsible Person'?: {
      id?: string;
      type?: string;
      people?: Array<{
        object?: string;
        id?: string;
        name?: string;
        avatar_url?: string;
        type?: string;
        person?: {
          email?: string;
        };
      }>;
    };
    'Last ordered'?: {
      id?: string;
      type?: string;
      date?: {
        start?: string;
        end?: unknown;
        time_zone?: unknown;
      };
    };
    'Cost of next trip'?: {
      id?: string;
      type?: string;
      formula?: {
        type?: string;
        number?: number;
      };
    };
    Recipes?: {
      id?: string;
      type?: string;
      relation?: Array<{
        id?: string;
      }>;
      has_more?: boolean;
    };
    Description?: {
      id?: string;
      type?: string;
      rich_text?: Array<{
        type?: string;
        text?: {
          content?: string;
          link?: unknown;
        };
        annotations?: {
          bold?: boolean;
          italic?: boolean;
          strikethrough?: boolean;
          underline?: boolean;
          code?: boolean;
          color?: string;
        };
        plain_text?: string;
        href?: unknown;
      }>;
    };
    'In stock'?: {
      id?: string;
      type?: string;
      checkbox?: boolean;
    };
    'Number of meals'?: {
      id?: string;
      type?: string;
      rollup?: {
        type?: string;
        number?: number;
        function?: string;
      };
    };
    Photo?: {
      id?: string;
      type?: string;
      url?: string;
    };
    Name?: {
      id?: string;
      type?: string;
      title?: Array<{
        type?: string;
        text?: {
          content?: string;
          link?: unknown;
        };
        annotations?: {
          bold?: boolean;
          italic?: boolean;
          strikethrough?: boolean;
          underline?: boolean;
          code?: boolean;
          color?: string;
        };
        plain_text?: string;
        href?: unknown;
      }>;
    };
  };
  url?: string;
  public_url?: unknown;
};

export type RetrieveApageError = {
  [key: string]: unknown;
};

export type PatchPageData = {
  body?: {
    /**
     * The property values to update for the page. The keys are the names or IDs of the property and the values are property values. If a page property ID is not included, then it is not changed.
     */
    properties?: string;
    /**
     * Set to true to delete a block. Set to false to restore a block.
     */
    in_trash?: boolean;
    /**
     * A page icon for the page. Supported types are [external file object](https://developers.notion.com/reference/file-object) or [emoji object](https://developers.notion.com/reference/emoji-object).
     */
    icon?: string;
    /**
     * A cover image for the page. Only [external file objects](https://developers.notion.com/reference/file-object) are supported.
     */
    cover?: string;
  };
  headers?: {
    'Notion-Version'?: string;
  };
  path: {
    /**
     * The identifier for the Notion page to be updated.
     */
    page_id: string;
  };
};

export type PatchPageResponse = {
  object?: string;
  id?: string;
  created_time?: string;
  last_edited_time?: string;
  created_by?: {
    object?: string;
    id?: string;
  };
  last_edited_by?: {
    object?: string;
    id?: string;
  };
  cover?: {
    type?: string;
    external?: {
      url?: string;
    };
  };
  icon?: {
    type?: string;
    emoji?: string;
  };
  parent?: {
    type?: string;
    database_id?: string;
  };
  archived?: boolean;
  properties?: {
    'Store availability'?: {
      id?: string;
    };
    'Food group'?: {
      id?: string;
    };
    Price?: {
      id?: string;
    };
    'Responsible Person'?: {
      id?: string;
    };
    'Last ordered'?: {
      id?: string;
    };
    'Cost of next trip'?: {
      id?: string;
    };
    Recipes?: {
      id?: string;
    };
    Description?: {
      id?: string;
    };
    'In stock'?: {
      id?: string;
    };
    'Number of meals'?: {
      id?: string;
    };
    Photo?: {
      id?: string;
    };
    Name?: {
      id?: string;
    };
  };
  url?: string;
};

export type PatchPageError =
  | {
      [key: string]: unknown;
    }
  | {
      object?: string;
      status?: number;
      code?: string;
      message?: string;
    };

export type PostPageData = {
  body?: {
    /**
     * The parent page or database where the new page is inserted, represented as a JSON object with a `page_id` or `database_id` key, and the corresponding ID.
     */
    parent: string;
    /**
     * The values of the page’s properties. If the `parent` is a database, then the schema must match the parent database’s properties. If the `parent` is a page, then the only valid object key is `title`.
     */
    properties: string;
    /**
     * The content to be rendered on the new page, represented as an array of [block objects](https://developers.notion.com/reference/block).
     */
    children?: Array<string>;
    /**
     * The icon of the new page. Either an [emoji object](https://developers.notion.com/reference/emoji-object) or an [external file object](https://developers.notion.com/reference/file-object)..
     */
    icon?: string;
    /**
     * The cover image of the new page, represented as a [file object](https://developers.notion.com/reference/file-object).
     */
    cover?: string;
  };
  headers: {
    'Notion-Version': string;
  };
};

export type PostPageResponse = {
  object?: string;
  id?: string;
  created_time?: string;
  last_edited_time?: string;
  created_by?: {
    object?: string;
    id?: string;
  };
  last_edited_by?: {
    object?: string;
    id?: string;
  };
  cover?: {
    type?: string;
    external?: {
      url?: string;
    };
  };
  icon?: {
    type?: string;
    emoji?: string;
  };
  parent?: {
    type?: string;
    database_id?: string;
  };
  archived?: boolean;
  properties?: {
    'Store availability'?: {
      id?: string;
    };
    'Food group'?: {
      id?: string;
    };
    Price?: {
      id?: string;
    };
    'Responsible Person'?: {
      id?: string;
    };
    'Last ordered'?: {
      id?: string;
    };
    'Cost of next trip'?: {
      id?: string;
    };
    Recipes?: {
      id?: string;
    };
    Description?: {
      id?: string;
    };
    'In stock'?: {
      id?: string;
    };
    'Number of meals'?: {
      id?: string;
    };
    Photo?: {
      id?: string;
    };
    Name?: {
      id?: string;
    };
  };
  url?: string;
};

export type PostPageError =
  | {
      [key: string]: unknown;
    }
  | {
      object?: string;
      status?: number;
      code?: string;
      message?: string;
    };

export type CreateAdatabaseData = {
  body?: {
    /**
     * A [page parent](/reference/database#page-parent)
     */
    parent: string;
    /**
     * Title of database as it appears in Notion. An array of [rich text objects](ref:rich-text).
     */
    title?: unknown[];
    /**
     * Property schema of database. The keys are the names of properties as they appear in Notion and the values are [property schema objects](https://developers.notion.com/reference/property-schema-object).
     */
    properties: string;
  };
  headers: {
    'Notion-Version': string;
  };
};

export type CreateAdatabaseResponse = unknown;

export type CreateAdatabaseError = {
  [key: string]: unknown;
};

export type UpdateAdatabaseData = {
  body?: {
    /**
     * An array of [rich text objects](https://developers.notion.com/reference/rich-text) that represents the title of the database that is displayed in the Notion UI. If omitted, then the database title remains unchanged.
     */
    title?: unknown[];
    /**
     * An array of [rich text objects](https://developers.notion.com/reference/rich-text) that represents the description of the database that is displayed in the Notion UI. If omitted, then the database description remains unchanged.
     */
    description?: unknown[];
    /**
     * The properties of a database to be changed in the request, in the form of a JSON object. If updating an existing property, then the keys are the names or IDs of the properties as they appear in Notion, and the values are [property schema objects](ref:property-schema-object). If adding a new property, then the key is the name of the new database property and the value is a [property schema object](ref:property-schema-object).
     */
    properties?: string;
  };
  headers?: {
    'Notion-Version'?: string;
  };
  path: {
    /**
     * identifier for a Notion database
     */
    database_id: string;
  };
};

export type UpdateAdatabaseResponse = unknown;

export type UpdateAdatabaseError =
  | {
      object?: string;
      status?: number;
      code?: string;
      message?: string;
    }
  | {
      object?: string;
      status?: number;
      code?: string;
      message?: string;
    };

export type RetrieveAdatabaseData = {
  headers: {
    'Notion-Version': string;
  };
  path: {
    /**
     * An identifier for the Notion database.
     */
    database_id: string;
  };
};

export type RetrieveAdatabaseResponse = {
  object?: string;
  id?: string;
  created_time?: string;
  last_edited_time?: string;
  icon?: {
    type?: string;
    emoji?: string;
  };
  cover?: {
    type?: string;
    external?: {
      url?: string;
    };
  };
  url?: string;
  title?: Array<{
    type?: string;
    text?: {
      content?: string;
      link?: unknown;
    };
    annotations?: {
      bold?: boolean;
      italic?: boolean;
      strikethrough?: boolean;
      underline?: boolean;
      code?: boolean;
      color?: string;
    };
    plain_text?: string;
    href?: unknown;
  }>;
  description?: Array<{
    type?: string;
    text?: {
      content?: string;
      link?: unknown;
    };
    annotations?: {
      bold?: boolean;
      italic?: boolean;
      strikethrough?: boolean;
      underline?: boolean;
      code?: boolean;
      color?: string;
    };
    plain_text?: string;
    href?: unknown;
  }>;
  properties?: {
    '+1'?: {
      id?: string;
      name?: string;
      type?: string;
      people?: {
        [key: string]: unknown;
      };
    };
    'In stock'?: {
      id?: string;
      name?: string;
      type?: string;
      checkbox?: {
        [key: string]: unknown;
      };
    };
    Price?: {
      id?: string;
      name?: string;
      type?: string;
      number?: {
        format?: string;
      };
    };
    Description?: {
      id?: string;
      name?: string;
      type?: string;
      rich_text?: {
        [key: string]: unknown;
      };
    };
    'Last ordered'?: {
      id?: string;
      name?: string;
      type?: string;
      date?: {
        [key: string]: unknown;
      };
    };
    Meals?: {
      id?: string;
      name?: string;
      type?: string;
      relation?: {
        database_id?: string;
        synced_property_name?: string;
      };
    };
    'Number of meals'?: {
      id?: string;
      name?: string;
      type?: string;
      rollup?: {
        rollup_property_name?: string;
        relation_property_name?: string;
        rollup_property_id?: string;
        relation_property_id?: string;
        function?: string;
      };
    };
    'Store availability'?: {
      id?: string;
      name?: string;
      type?: string;
      multi_select?: {
        options?: Array<{
          id?: string;
          name?: string;
          color?: string;
        }>;
      };
    };
    Photo?: {
      id?: string;
      name?: string;
      type?: string;
      files?: {
        [key: string]: unknown;
      };
    };
    'Food group'?: {
      id?: string;
      name?: string;
      type?: string;
      select?: {
        options?: Array<{
          id?: string;
          name?: string;
          color?: string;
        }>;
      };
    };
    Name?: {
      id?: string;
      name?: string;
      type?: string;
      title?: {
        [key: string]: unknown;
      };
    };
  };
  parent?: {
    type?: string;
    page_id?: string;
  };
  archived?: boolean;
  is_inline?: boolean;
  public_url?: unknown;
};

export type RetrieveAdatabaseError =
  | {
      [key: string]: unknown;
    }
  | {
      object?: string;
      status?: number;
      code?: string;
      message?: string;
    };

export type RetrieveApagePropertyData = {
  headers?: {
    'Notion-Version'?: string;
  };
  path: {
    /**
     * Identifier for a Notion page
     */
    page_id: string;
    /**
     * Identifier for a page [property](https://developers.notion.com/reference/page#all-property-values)
     */
    property_id: string;
  };
  query?: {
    /**
     * For paginated properties. The max number of property item objects on a page. The default size is 100
     */
    page_size?: number;
    /**
     * For paginated properties.
     */
    start_cursor?: string;
  };
};

export type RetrieveApagePropertyResponse = unknown;

export type RetrieveApagePropertyError = unknown;

export type GetSelfData = {
  headers: {
    'Notion-Version': string;
  };
};

export type GetSelfResponse = {
  object?: string;
  id?: string;
  name?: string;
  avatar_url?: unknown;
  type?: string;
  bot?: {
    owner?: {
      type?: string;
      user?: {
        object?: string;
        id?: string;
        name?: string;
        avatar_url?: unknown;
        type?: string;
        person?: {
          email?: string;
        };
      };
    };
  };
};

export type GetSelfError = {
  [key: string]: unknown;
};

export type RetrieveAcommentData = {
  headers: {
    'Notion-Version': string;
  };
  query: {
    /**
     * Identifier for a Notion block or page
     */
    block_id: string;
    /**
     * The number of items from the full list desired in the response. Maximum: 100
     */
    page_size?: number;
    /**
     * If supplied, this endpoint will return a page of results starting after the cursor provided. If not supplied, this endpoint will return the first page of results.
     */
    start_cursor?: string;
  };
};

export type RetrieveAcommentResponse = {
  object?: string;
  results?: Array<{
    object?: string;
    id?: string;
    parent?: {
      type?: string;
      page_id?: string;
    };
    discussion_id?: string;
    created_time?: string;
    last_edited_time?: string;
    created_by?: {
      object?: string;
      id?: string;
    };
    rich_text?: Array<{
      type?: string;
      text?: {
        content?: string;
        link?: unknown;
      };
      annotations?: {
        bold?: boolean;
        italic?: boolean;
        strikethrough?: boolean;
        underline?: boolean;
        code?: boolean;
        color?: string;
      };
      plain_text?: string;
      href?: unknown;
    }>;
  }>;
  next_cursor?: unknown;
  has_more?: boolean;
  type?: string;
  comment?: {
    [key: string]: unknown;
  };
};

export type RetrieveAcommentError = {
  object?: string;
  status?: number;
  code?: string;
  message?: string;
};

export type CreateAcommentData = {
  body?: {
    /**
     * A [page parent](/reference/database#page-parent). Either this or a discussion_id is required (not both)
     */
    parent?: string;
    /**
     * A UUID identifier for a discussion thread. Either this or a parent object is required (not both)
     */
    discussion_id?: string;
    /**
     * A [rich text object](ref:rich-text)
     */
    rich_text: string;
  };
  headers: {
    'Notion-Version': string;
  };
};

export type CreateAcommentResponse = {
  object?: string;
  id?: string;
  parent?: {
    type?: string;
    page_id?: string;
  };
  discussion_id?: string;
  created_time?: string;
  last_edited_time?: string;
  created_by?: {
    object?: string;
    id?: string;
  };
  rich_text?: Array<{
    type?: string;
    text?: {
      content?: string;
      link?: unknown;
    };
    annotations?: {
      bold?: boolean;
      italic?: boolean;
      strikethrough?: boolean;
      underline?: boolean;
      code?: boolean;
      color?: string;
    };
    plain_text?: string;
    href?: unknown;
  }>;
};

export type CreateAcommentError = {
  object?: string;
  status?: number;
  code?: string;
  message?: string;
};

export type CreateAtokenData = {
  body?: {
    /**
     * A unique random code that Notion generates to authenticate with your service, generated when a user initiates the OAuth flow.
     */
    code: string;
    /**
     * A constant string: "authorization_code".
     */
    grant_type: string;
    /**
     * The `"redirect_uri"` that was provided in the OAuth Domain & URI section of the integration's Authorization settings. Do not include this field if a `"redirect_uri"` query param was not included in the Authorization URL provided to users. In most cases, this field is required.
     */
    redirect_uri: string;
    /**
     * Required if and only when building [Link Preview](https://developers.notion.com/docs/link-previews) integrations (otherwise ignored). An object with `key` and `name` properties. `key` should be a unique identifier for the account. Notion uses the `key` to determine whether or not the user is re-connecting the same account. `name` should be some way for the user to know which account they used to authenticate with your service. If a user has authenticated Notion with your integration before and `key` is the same but `name` is different, then Notion updates the `name` associated with your integration.
     */
    external_account?: {
      [key: string]: unknown;
    };
  };
};

export type CreateAtokenResponse = {
  access_token?: string;
  bot_id?: string;
  duplicated_template_id?: unknown;
  owner?: {
    workspace?: boolean;
  };
  workspace_icon?: string;
  workspace_id?: string;
  workspace_name?: string;
};

export type CreateAtokenError = {
  error?: string;
  error_description?: string;
};
