// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  GetUserData,
  GetUserError,
  GetUserResponse,
  GetUsersData,
  GetUsersError,
  GetUsersResponse,
  PostDatabaseQueryData,
  PostDatabaseQueryError,
  PostDatabaseQueryResponse,
  PostSearchData,
  PostSearchError,
  PostSearchResponse,
  GetBlockChildrenData,
  GetBlockChildrenError,
  GetBlockChildrenResponse,
  PatchBlockChildrenData,
  PatchBlockChildrenError,
  PatchBlockChildrenResponse,
  RetrieveAblockData,
  RetrieveAblockError,
  RetrieveAblockResponse,
  UpdateAblockData,
  UpdateAblockError,
  UpdateAblockResponse,
  DeleteAblockData,
  DeleteAblockError,
  DeleteAblockResponse,
  RetrieveApageData,
  RetrieveApageError,
  RetrieveApageResponse,
  PatchPageData,
  PatchPageError,
  PatchPageResponse,
  PostPageData,
  PostPageError,
  PostPageResponse,
  CreateAdatabaseData,
  CreateAdatabaseError,
  CreateAdatabaseResponse,
  UpdateAdatabaseData,
  UpdateAdatabaseError,
  UpdateAdatabaseResponse,
  RetrieveAdatabaseData,
  RetrieveAdatabaseError,
  RetrieveAdatabaseResponse,
  RetrieveApagePropertyData,
  RetrieveApagePropertyError,
  RetrieveApagePropertyResponse,
  GetSelfData,
  GetSelfError,
  GetSelfResponse,
  RetrieveAcommentData,
  RetrieveAcommentError,
  RetrieveAcommentResponse,
  CreateAcommentData,
  CreateAcommentError,
  CreateAcommentResponse,
  CreateAtokenData,
  CreateAtokenError,
  CreateAtokenResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Retrieve a user
 */
export const getUser = <ThrowOnError extends boolean = false>(options: Options<GetUserData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetUserResponse, GetUserError, ThrowOnError>({
    ...options,
    url: '/v1/users/{user_id}',
  });
};

/**
 * List all users
 */
export const getUsers = <ThrowOnError extends boolean = false>(options: Options<GetUsersData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetUsersResponse, GetUsersError, ThrowOnError>({
    ...options,
    url: '/v1/users',
  });
};

/**
 * Query a database
 */
export const postDatabaseQuery = <ThrowOnError extends boolean = false>(
  options: Options<PostDatabaseQueryData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostDatabaseQueryResponse, PostDatabaseQueryError, ThrowOnError>({
    ...options,
    url: '/v1/databases/{database_id}/query',
  });
};

/**
 * Search by title
 */
export const postSearch = <ThrowOnError extends boolean = false>(options: Options<PostSearchData, ThrowOnError>) => {
  return (options?.client ?? client).post<PostSearchResponse, PostSearchError, ThrowOnError>({
    ...options,
    url: '/v1/search',
  });
};

/**
 * Retrieve block children
 */
export const getBlockChildren = <ThrowOnError extends boolean = false>(
  options: Options<GetBlockChildrenData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetBlockChildrenResponse, GetBlockChildrenError, ThrowOnError>({
    ...options,
    url: '/v1/blocks/{block_id}/children',
  });
};

/**
 * Append block children
 */
export const patchBlockChildren = <ThrowOnError extends boolean = false>(
  options: Options<PatchBlockChildrenData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchBlockChildrenResponse, PatchBlockChildrenError, ThrowOnError>({
    ...options,
    url: '/v1/blocks/{block_id}/children',
  });
};

/**
 * Retrieve a block
 */
export const retrieveABlock = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveAblockData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveAblockResponse, RetrieveAblockError, ThrowOnError>({
    ...options,
    url: '/v1/blocks/{block_id}',
  });
};

/**
 * Update a block
 */
export const updateABlock = <ThrowOnError extends boolean = false>(
  options: Options<UpdateAblockData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateAblockResponse, UpdateAblockError, ThrowOnError>({
    ...options,
    url: '/v1/blocks/{block_id}',
  });
};

/**
 * Delete a block
 */
export const deleteABlock = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAblockData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteAblockResponse, DeleteAblockError, ThrowOnError>({
    ...options,
    url: '/v1/blocks/{block_id}',
  });
};

/**
 * Retrieve a page
 */
export const retrieveAPage = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveApageData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveApageResponse, RetrieveApageError, ThrowOnError>({
    ...options,
    url: '/v1/pages/{page_id}',
  });
};

/**
 * Update page properties
 */
export const patchPage = <ThrowOnError extends boolean = false>(options: Options<PatchPageData, ThrowOnError>) => {
  return (options?.client ?? client).patch<PatchPageResponse, PatchPageError, ThrowOnError>({
    ...options,
    url: '/v1/pages/{page_id}',
  });
};

/**
 * Create a page
 */
export const postPage = <ThrowOnError extends boolean = false>(options: Options<PostPageData, ThrowOnError>) => {
  return (options?.client ?? client).post<PostPageResponse, PostPageError, ThrowOnError>({
    ...options,
    url: '/v1/pages',
  });
};

/**
 * Create a database
 */
export const createADatabase = <ThrowOnError extends boolean = false>(
  options: Options<CreateAdatabaseData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateAdatabaseResponse, CreateAdatabaseError, ThrowOnError>({
    ...options,
    url: '/v1/databases',
  });
};

/**
 * Update a database
 */
export const updateADatabase = <ThrowOnError extends boolean = false>(
  options: Options<UpdateAdatabaseData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<UpdateAdatabaseResponse, UpdateAdatabaseError, ThrowOnError>({
    ...options,
    url: '/v1/databases/{database_id}',
  });
};

/**
 * Retrieve a database
 */
export const retrieveADatabase = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveAdatabaseData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveAdatabaseResponse, RetrieveAdatabaseError, ThrowOnError>({
    ...options,
    url: '/v1/databases/{database_id}',
  });
};

/**
 * Retrieve a page property item
 */
export const retrieveAPageProperty = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveApagePropertyData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveApagePropertyResponse, RetrieveApagePropertyError, ThrowOnError>({
    ...options,
    url: '/v1/pages/{page_id}/properties/{property_id}',
  });
};

/**
 * Retrieve your token's bot user
 */
export const getSelf = <ThrowOnError extends boolean = false>(options: Options<GetSelfData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetSelfResponse, GetSelfError, ThrowOnError>({
    ...options,
    url: '/v1/users/me',
  });
};

/**
 * Retrieve comments
 * Retrieves a list of un-resolved [Comment objects](ref:comment-object) from a page or block.
 */
export const retrieveAComment = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveAcommentData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveAcommentResponse, RetrieveAcommentError, ThrowOnError>({
    ...options,
    url: '/v1/comments',
  });
};

/**
 * Create comment
 * Creates a comment in a page or existing discussion thread.
 */
export const createAComment = <ThrowOnError extends boolean = false>(
  options: Options<CreateAcommentData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateAcommentResponse, CreateAcommentError, ThrowOnError>({
    ...options,
    url: '/v1/comments',
  });
};

/**
 * Create a token
 * Creates an access token that a third-party service can use to authenticate with Notion.
 */
export const createAToken = <ThrowOnError extends boolean = false>(
  options?: Options<CreateAtokenData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateAtokenResponse, CreateAtokenError, ThrowOnError>({
    ...options,
    url: '/v1/oauth/token',
  });
};
