// Generated by ts-to-zod
import { z } from 'zod';

export const getRootDataSchema = z.object({
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getRootResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  account_id: z.string().optional(),
  account_industry: z.string().optional(),
  account_name: z.string().optional(),
  account_timezone: z.string().optional(),
  avatar_url: z.string().optional(),
  contact: z
    .object({
      addr1: z.string().optional(),
      addr2: z.string().optional(),
      city: z.string().optional(),
      company: z.string().optional(),
      country: z.string().optional(),
      state: z.string().optional(),
      zip: z.string().optional(),
    })
    .optional(),
  email: z.string().optional(),
  first_name: z.string().optional(),
  first_payment: z.string().optional(),
  industry_stats: z
    .object({
      bounce_rate: z.number().optional(),
      click_rate: z.number().optional(),
      open_rate: z.number().optional(),
    })
    .optional(),
  last_login: z.string().optional(),
  last_name: z.string().optional(),
  login_id: z.string().optional(),
  member_since: z.string().optional(),
  pricing_plan_type: z.union([z.literal('monthly'), z.literal('pay_as_you_go'), z.literal('forever_free')]).optional(),
  pro_enabled: z.boolean().optional(),
  role: z.string().optional(),
  total_subscribers: z.number().optional(),
  username: z.string().optional(),
});

export const getRootErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getAccountExportsDataSchema = z.object({
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getAccountExportsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  exports: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        download_url: z.string().optional(),
        export_id: z.number().optional(),
        finished: z.string().optional(),
        size_in_bytes: z.number().optional(),
        started: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getAccountExportsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postAccountExportDataSchema = z.object({
  body: z.object({
    include_stages: z.array(
      z.union([
        z.literal('audiences'),
        z.literal('campaigns'),
        z.literal('events'),
        z.literal('gallery_files'),
        z.literal('reports'),
        z.literal('templates'),
      ]),
    ),
    since_timestamp: z.string().optional(),
  }),
});

export const postAccountExportResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  download_url: z.string().optional(),
  export_id: z.number().optional(),
  finished: z.string().optional(),
  size_in_bytes: z.number().optional(),
  started: z.string().optional(),
});

export const postAccountExportErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getAccountExportIdDataSchema = z.object({
  path: z.object({
    export_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getAccountExportIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  download_url: z.string().optional(),
  export_id: z.number().optional(),
  finished: z.string().optional(),
  size_in_bytes: z.number().optional(),
  started: z.string().optional(),
});

export const getAccountExportIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getActivityFeedChimpChatterDataSchema = z.object({
  query: z
    .object({
      count: z.number().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getActivityFeedChimpChatterResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  chimp_chatter: z
    .array(
      z.object({
        campaign_id: z.string().optional(),
        list_id: z.string().optional(),
        message: z.string().optional(),
        title: z.string().optional(),
        type: z
          .union([
            z.literal('lists:new-subscriber'),
            z.literal('lists:unsubscribes'),
            z.literal('lists:profile-updates'),
            z.literal('campaigns:facebook-likes'),
            z.literal('campaigns:forward-to-friend'),
            z.literal('lists:imports'),
          ])
          .optional(),
        update_time: z.string().optional(),
        url: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getActivityFeedChimpChatterErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getAuthorizedAppsDataSchema = z.object({
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getAuthorizedAppsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  apps: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        description: z.string().optional(),
        id: z.number().optional(),
        name: z.string().optional(),
        users: z.array(z.string()).optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getAuthorizedAppsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getAuthorizedAppsIdDataSchema = z.object({
  path: z.object({
    app_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getAuthorizedAppsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  description: z.string().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  users: z.array(z.string()).optional(),
});

export const getAuthorizedAppsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getAutomationsDataSchema = z.object({
  query: z
    .object({
      before_create_time: z.string().optional(),
      before_start_time: z.string().optional(),
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
      since_create_time: z.string().optional(),
      since_start_time: z.string().optional(),
      status: z.union([z.literal('save'), z.literal('paused'), z.literal('sending')]).optional(),
    })
    .optional(),
});

export const getAutomationsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  automations: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        create_time: z.string().optional(),
        emails_sent: z.number().optional(),
        id: z.string().optional(),
        recipients: z
          .object({
            list_id: z.string().optional(),
            list_is_active: z.boolean().optional(),
            list_name: z.string().optional(),
            segment_opts: z
              .object({
                conditions: z
                  .array(
                    z.union([
                      z.object({
                        condition_type: z.literal('Aim').optional(),
                        field: z.literal('aim').optional(),
                        op: z
                          .union([
                            z.literal('open'),
                            z.literal('click'),
                            z.literal('sent'),
                            z.literal('noopen'),
                            z.literal('noclick'),
                            z.literal('nosent'),
                          ])
                          .optional(),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('Automation').optional(),
                        field: z.literal('automation'),
                        op: z.union([
                          z.literal('started'),
                          z.literal('completed'),
                          z.literal('not_started'),
                          z.literal('not_completed'),
                        ]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('CampaignPoll').optional(),
                        field: z.literal('poll'),
                        op: z.union([z.literal('member'), z.literal('notmember')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('Conversation').optional(),
                        field: z.literal('conversation'),
                        op: z.union([z.literal('member'), z.literal('notmember')]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('Date').optional(),
                        extra: z.string().optional(),
                        field: z.union([
                          z.literal('timestamp_opt'),
                          z.literal('info_changed'),
                          z.literal('ecomm_date'),
                        ]),
                        op: z.union([
                          z.literal('greater'),
                          z.literal('less'),
                          z.literal('is'),
                          z.literal('not'),
                          z.literal('blank'),
                          z.literal('blank_not'),
                          z.literal('within'),
                          z.literal('notwithin'),
                        ]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('EmailClient').optional(),
                        field: z.literal('email_client'),
                        op: z.union([z.literal('client_is'), z.literal('client_not')]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('Language').optional(),
                        field: z.literal('language'),
                        op: z.union([z.literal('is'), z.literal('not')]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('MemberRating').optional(),
                        field: z.literal('rating'),
                        op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('SignupSource'),
                        field: z.literal('source'),
                        op: z.union([z.literal('source_is'), z.literal('source_not')]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('SurveyMonkey').optional(),
                        field: z.literal('survey_monkey'),
                        op: z.union([
                          z.literal('started'),
                          z.literal('completed'),
                          z.literal('not_started'),
                          z.literal('not_completed'),
                        ]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('VIP').optional(),
                        field: z.literal('gmonkey'),
                        op: z.union([z.literal('member'), z.literal('notmember')]),
                      }),
                      z.object({
                        condition_type: z.literal('Interests').optional(),
                        field: z.string().optional(),
                        op: z
                          .union([
                            z.literal('interestcontains'),
                            z.literal('interestcontainsall'),
                            z.literal('interestnotcontains'),
                          ])
                          .optional(),
                        value: z.array(z.string()).optional(),
                      }),
                      z.object({
                        condition_type: z.literal('EcommCategory').optional(),
                        field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                        op: z
                          .union([
                            z.literal('is'),
                            z.literal('not'),
                            z.literal('contains'),
                            z.literal('notcontain'),
                            z.literal('starts'),
                            z.literal('ends'),
                          ])
                          .optional(),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('EcommNumber').optional(),
                        field: z.union([
                          z.literal('ecomm_spent_avg'),
                          z.literal('ecomm_orders'),
                          z.literal('ecomm_prod_all'),
                          z.literal('ecomm_avg_ord'),
                        ]),
                        op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('EcommPurchased').optional(),
                        field: z.literal('ecomm_purchased').optional(),
                        op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                      }),
                      z.object({
                        condition_type: z.literal('EcommSpent').optional(),
                        field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                        op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                        value: z.number().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('EcommStore').optional(),
                        field: z.literal('ecomm_store').optional(),
                        op: z.union([z.literal('is'), z.literal('not')]).optional(),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('GoalActivity').optional(),
                        field: z.literal('goal'),
                        op: z.union([
                          z.literal('is'),
                          z.literal('goal_not'),
                          z.literal('contains'),
                          z.literal('goal_notcontain'),
                          z.literal('starts'),
                          z.literal('ends'),
                        ]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('GoalTimestamp').optional(),
                        field: z.literal('goal_last_visited'),
                        op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('FuzzySegment').optional(),
                        field: z.literal('fuzzy_segment'),
                        op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('StaticSegment').optional(),
                        field: z.literal('static_segment'),
                        op: z.union([z.literal('static_is'), z.literal('static_not')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('IPGeoCountryState').optional(),
                        field: z.literal('ipgeo'),
                        op: z.union([
                          z.literal('ipgeocountry'),
                          z.literal('ipgeonotcountry'),
                          z.literal('ipgeostate'),
                          z.literal('ipgeonotstate'),
                        ]),
                        value: z.string(),
                      }),
                      z.object({
                        addr: z.string(),
                        condition_type: z.literal('IPGeoIn').optional(),
                        field: z.literal('ipgeo'),
                        lat: z.string(),
                        lng: z.string(),
                        op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('IPGeoInZip').optional(),
                        extra: z.number(),
                        field: z.literal('ipgeo'),
                        op: z.literal('ipgeoinzip'),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('IPGeoUnknown').optional(),
                        field: z.literal('ipgeo'),
                        op: z.literal('ipgeounknown'),
                      }),
                      z.object({
                        condition_type: z.literal('IPGeoZip').optional(),
                        field: z.literal('ipgeo'),
                        op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('SocialAge').optional(),
                        field: z.literal('social_age'),
                        op: z.union([z.literal('is'), z.literal('not')]),
                        value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                      }),
                      z.object({
                        condition_type: z.literal('SocialGender').optional(),
                        field: z.literal('social_gender'),
                        op: z.union([z.literal('is'), z.literal('not')]),
                        value: z.union([z.literal('male'), z.literal('female')]),
                      }),
                      z.object({
                        condition_type: z.literal('SocialInfluence').optional(),
                        field: z.literal('social_influence'),
                        op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('SocialNetworkMember').optional(),
                        field: z.literal('social_network'),
                        op: z.union([z.literal('member'), z.literal('notmember')]),
                        value: z.union([
                          z.literal('twitter'),
                          z.literal('facebook'),
                          z.literal('linkedin'),
                          z.literal('flickr'),
                          z.literal('foursquare'),
                          z.literal('lastfm'),
                          z.literal('myspace'),
                          z.literal('quora'),
                          z.literal('vimeo'),
                          z.literal('yelp'),
                          z.literal('youtube'),
                        ]),
                      }),
                      z.object({
                        condition_type: z.literal('SocialNetworkFollow').optional(),
                        field: z.literal('social_network'),
                        op: z.union([z.literal('follow'), z.literal('notfollow')]),
                        value: z.literal('twitter_follow'),
                      }),
                      z.object({
                        condition_type: z.literal('AddressMerge').optional(),
                        field: z.string(),
                        op: z.union([
                          z.literal('contains'),
                          z.literal('notcontain'),
                          z.literal('blank'),
                          z.literal('blank_not'),
                        ]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('ZipMerge').optional(),
                        extra: z.string(),
                        field: z.string(),
                        op: z.literal('geoin'),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('BirthdayMerge').optional(),
                        field: z.string(),
                        op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('DateMerge').optional(),
                        field: z.string(),
                        op: z.union([
                          z.literal('is'),
                          z.literal('not'),
                          z.literal('less'),
                          z.literal('blank'),
                          z.literal('blank_not'),
                          z.literal('greater'),
                        ]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('SelectMerge').optional(),
                        field: z.string(),
                        op: z.union([
                          z.literal('is'),
                          z.literal('not'),
                          z.literal('blank'),
                          z.literal('blank_not'),
                          z.literal('notcontain'),
                          z.literal('contains'),
                        ]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('TextMerge').optional(),
                        field: z.string(),
                        op: z.union([
                          z.literal('is'),
                          z.literal('not'),
                          z.literal('contains'),
                          z.literal('notcontain'),
                          z.literal('starts'),
                          z.literal('ends'),
                          z.literal('greater'),
                          z.literal('less'),
                          z.literal('blank'),
                          z.literal('blank_not'),
                        ]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('EmailAddress').optional(),
                        field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                        op: z.union([
                          z.literal('is'),
                          z.literal('not'),
                          z.literal('contains'),
                          z.literal('notcontain'),
                          z.literal('starts'),
                          z.literal('ends'),
                          z.literal('greater'),
                          z.literal('less'),
                        ]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('PredictedGender').optional(),
                        field: z.literal('predicted_gender'),
                        op: z.union([z.literal('is'), z.literal('not')]),
                        value: z.union([z.literal('male'), z.literal('female')]),
                      }),
                      z.object({
                        condition_type: z.literal('PredictedAge').optional(),
                        field: z.literal('predicted_age_range'),
                        op: z.literal('is'),
                        value: z.union([
                          z.literal('18-24'),
                          z.literal('25-34'),
                          z.literal('35-44'),
                          z.literal('45-54'),
                          z.literal('55-64'),
                          z.literal('65+'),
                        ]),
                      }),
                      z.object({
                        condition_type: z.literal('NewSubscribers').optional(),
                        field: z.literal('timestamp_opt').optional(),
                        op: z.literal('date_within').optional(),
                        value: z.string().optional(),
                      }),
                    ]),
                  )
                  .optional(),
                match: z.union([z.literal('any'), z.literal('all')]).optional(),
                saved_segment_id: z.number().optional(),
              })
              .optional(),
            store_id: z.string().optional(),
          })
          .optional(),
        report_summary: z
          .object({
            click_rate: z.number().optional(),
            clicks: z.number().optional(),
            open_rate: z.number().optional(),
            opens: z.number().optional(),
            subscriber_clicks: z.number().optional(),
            unique_opens: z.number().optional(),
          })
          .optional(),
        settings: z
          .object({
            authenticate: z.boolean().optional(),
            auto_footer: z.boolean().optional(),
            from_name: z.string().optional(),
            inline_css: z.boolean().optional(),
            reply_to: z.string().optional(),
            title: z.string().optional(),
            to_name: z.string().optional(),
            use_conversation: z.boolean().optional(),
          })
          .optional(),
        start_time: z.string().optional(),
        status: z.union([z.literal('save'), z.literal('paused'), z.literal('sending')]).optional(),
        tracking: z
          .object({
            capsule: z
              .object({
                notes: z.boolean().optional(),
              })
              .optional(),
            clicktale: z.string().optional(),
            ecomm360: z.boolean().optional(),
            goal_tracking: z.boolean().optional(),
            google_analytics: z.string().optional(),
            html_clicks: z.boolean().optional(),
            opens: z.boolean().optional(),
            salesforce: z
              .object({
                campaign: z.boolean().optional(),
                notes: z.boolean().optional(),
              })
              .optional(),
            text_clicks: z.boolean().optional(),
          })
          .optional(),
        trigger_settings: z
          .object({
            runtime: z
              .object({
                days: z
                  .array(
                    z.union([
                      z.literal('sunday'),
                      z.literal('monday'),
                      z.literal('tuesday'),
                      z.literal('wednesday'),
                      z.literal('thursday'),
                      z.literal('friday'),
                      z.literal('saturday'),
                    ]),
                  )
                  .optional(),
                hours: z
                  .object({
                    type: z.union([z.literal('send_asap'), z.literal('send_between'), z.literal('send_at')]),
                  })
                  .optional(),
              })
              .optional(),
            workflow_emails_count: z.number().optional(),
            workflow_title: z.string().optional(),
            workflow_type: z.union([
              z.literal('abandonedBrowse'),
              z.literal('abandonedCart'),
              z.literal('api'),
              z.literal('bestCustomers'),
              z.literal('categoryFollowup'),
              z.literal('dateAdded'),
              z.literal('emailFollowup'),
              z.literal('emailSeries'),
              z.literal('groupAdd'),
              z.literal('groupRemove'),
              z.literal('mandrill'),
              z.literal('productFollowup'),
              z.literal('purchaseFollowup'),
              z.literal('recurringEvent'),
              z.literal('specialEvent'),
              z.literal('visitUrl'),
              z.literal('welcomeSeries'),
            ]),
          })
          .optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getAutomationsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postAutomationsDataSchema = z.object({
  body: z.object({
    recipients: z.object({
      list_id: z.string().optional(),
      store_id: z.string().optional(),
    }),
    settings: z
      .object({
        from_name: z.string().optional(),
        reply_to: z.string().optional(),
      })
      .optional(),
    trigger_settings: z.object({
      workflow_type: z.string(),
    }),
  }),
});

export const postAutomationsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  create_time: z.string().optional(),
  emails_sent: z.number().optional(),
  id: z.string().optional(),
  recipients: z
    .object({
      list_id: z.string().optional(),
      list_is_active: z.boolean().optional(),
      list_name: z.string().optional(),
      segment_opts: z
        .object({
          conditions: z
            .array(
              z.union([
                z.object({
                  condition_type: z.literal('Aim').optional(),
                  field: z.literal('aim').optional(),
                  op: z
                    .union([
                      z.literal('open'),
                      z.literal('click'),
                      z.literal('sent'),
                      z.literal('noopen'),
                      z.literal('noclick'),
                      z.literal('nosent'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('Automation').optional(),
                  field: z.literal('automation'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('CampaignPoll').optional(),
                  field: z.literal('poll'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('Conversation').optional(),
                  field: z.literal('conversation'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Date').optional(),
                  extra: z.string().optional(),
                  field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
                  op: z.union([
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('within'),
                    z.literal('notwithin'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('EmailClient').optional(),
                  field: z.literal('email_client'),
                  op: z.union([z.literal('client_is'), z.literal('client_not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Language').optional(),
                  field: z.literal('language'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('MemberRating').optional(),
                  field: z.literal('rating'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SignupSource'),
                  field: z.literal('source'),
                  op: z.union([z.literal('source_is'), z.literal('source_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SurveyMonkey').optional(),
                  field: z.literal('survey_monkey'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('VIP').optional(),
                  field: z.literal('gmonkey'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                }),
                z.object({
                  condition_type: z.literal('Interests').optional(),
                  field: z.string().optional(),
                  op: z
                    .union([
                      z.literal('interestcontains'),
                      z.literal('interestcontainsall'),
                      z.literal('interestnotcontains'),
                    ])
                    .optional(),
                  value: z.array(z.string()).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommCategory').optional(),
                  field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                  op: z
                    .union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommNumber').optional(),
                  field: z.union([
                    z.literal('ecomm_spent_avg'),
                    z.literal('ecomm_orders'),
                    z.literal('ecomm_prod_all'),
                    z.literal('ecomm_avg_ord'),
                  ]),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('EcommPurchased').optional(),
                  field: z.literal('ecomm_purchased').optional(),
                  op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommSpent').optional(),
                  field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                  op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                  value: z.number().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommStore').optional(),
                  field: z.literal('ecomm_store').optional(),
                  op: z.union([z.literal('is'), z.literal('not')]).optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('GoalActivity').optional(),
                  field: z.literal('goal'),
                  op: z.union([
                    z.literal('is'),
                    z.literal('goal_not'),
                    z.literal('contains'),
                    z.literal('goal_notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('GoalTimestamp').optional(),
                  field: z.literal('goal_last_visited'),
                  op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('FuzzySegment').optional(),
                  field: z.literal('fuzzy_segment'),
                  op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('StaticSegment').optional(),
                  field: z.literal('static_segment'),
                  op: z.union([z.literal('static_is'), z.literal('static_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoCountryState').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([
                    z.literal('ipgeocountry'),
                    z.literal('ipgeonotcountry'),
                    z.literal('ipgeostate'),
                    z.literal('ipgeonotstate'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  addr: z.string(),
                  condition_type: z.literal('IPGeoIn').optional(),
                  field: z.literal('ipgeo'),
                  lat: z.string(),
                  lng: z.string(),
                  op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoInZip').optional(),
                  extra: z.number(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeoinzip'),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoUnknown').optional(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeounknown'),
                }),
                z.object({
                  condition_type: z.literal('IPGeoZip').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialAge').optional(),
                  field: z.literal('social_age'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                }),
                z.object({
                  condition_type: z.literal('SocialGender').optional(),
                  field: z.literal('social_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('SocialInfluence').optional(),
                  field: z.literal('social_influence'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkMember').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.union([
                    z.literal('twitter'),
                    z.literal('facebook'),
                    z.literal('linkedin'),
                    z.literal('flickr'),
                    z.literal('foursquare'),
                    z.literal('lastfm'),
                    z.literal('myspace'),
                    z.literal('quora'),
                    z.literal('vimeo'),
                    z.literal('yelp'),
                    z.literal('youtube'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkFollow').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('follow'), z.literal('notfollow')]),
                  value: z.literal('twitter_follow'),
                }),
                z.object({
                  condition_type: z.literal('AddressMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('ZipMerge').optional(),
                  extra: z.string(),
                  field: z.string(),
                  op: z.literal('geoin'),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('BirthdayMerge').optional(),
                  field: z.string(),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('DateMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('greater'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SelectMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('notcontain'),
                    z.literal('contains'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('TextMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EmailAddress').optional(),
                  field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('PredictedGender').optional(),
                  field: z.literal('predicted_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('PredictedAge').optional(),
                  field: z.literal('predicted_age_range'),
                  op: z.literal('is'),
                  value: z.union([
                    z.literal('18-24'),
                    z.literal('25-34'),
                    z.literal('35-44'),
                    z.literal('45-54'),
                    z.literal('55-64'),
                    z.literal('65+'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('NewSubscribers').optional(),
                  field: z.literal('timestamp_opt').optional(),
                  op: z.literal('date_within').optional(),
                  value: z.string().optional(),
                }),
              ]),
            )
            .optional(),
          match: z.union([z.literal('any'), z.literal('all')]).optional(),
          saved_segment_id: z.number().optional(),
        })
        .optional(),
      store_id: z.string().optional(),
    })
    .optional(),
  report_summary: z
    .object({
      click_rate: z.number().optional(),
      clicks: z.number().optional(),
      open_rate: z.number().optional(),
      opens: z.number().optional(),
      subscriber_clicks: z.number().optional(),
      unique_opens: z.number().optional(),
    })
    .optional(),
  settings: z
    .object({
      authenticate: z.boolean().optional(),
      auto_footer: z.boolean().optional(),
      from_name: z.string().optional(),
      inline_css: z.boolean().optional(),
      reply_to: z.string().optional(),
      title: z.string().optional(),
      to_name: z.string().optional(),
      use_conversation: z.boolean().optional(),
    })
    .optional(),
  start_time: z.string().optional(),
  status: z.union([z.literal('save'), z.literal('paused'), z.literal('sending')]).optional(),
  tracking: z
    .object({
      capsule: z
        .object({
          notes: z.boolean().optional(),
        })
        .optional(),
      clicktale: z.string().optional(),
      ecomm360: z.boolean().optional(),
      goal_tracking: z.boolean().optional(),
      google_analytics: z.string().optional(),
      html_clicks: z.boolean().optional(),
      opens: z.boolean().optional(),
      salesforce: z
        .object({
          campaign: z.boolean().optional(),
          notes: z.boolean().optional(),
        })
        .optional(),
      text_clicks: z.boolean().optional(),
    })
    .optional(),
  trigger_settings: z
    .object({
      runtime: z
        .object({
          days: z
            .array(
              z.union([
                z.literal('sunday'),
                z.literal('monday'),
                z.literal('tuesday'),
                z.literal('wednesday'),
                z.literal('thursday'),
                z.literal('friday'),
                z.literal('saturday'),
              ]),
            )
            .optional(),
          hours: z
            .object({
              type: z.union([z.literal('send_asap'), z.literal('send_between'), z.literal('send_at')]),
            })
            .optional(),
        })
        .optional(),
      workflow_emails_count: z.number().optional(),
      workflow_title: z.string().optional(),
      workflow_type: z.union([
        z.literal('abandonedBrowse'),
        z.literal('abandonedCart'),
        z.literal('api'),
        z.literal('bestCustomers'),
        z.literal('categoryFollowup'),
        z.literal('dateAdded'),
        z.literal('emailFollowup'),
        z.literal('emailSeries'),
        z.literal('groupAdd'),
        z.literal('groupRemove'),
        z.literal('mandrill'),
        z.literal('productFollowup'),
        z.literal('purchaseFollowup'),
        z.literal('recurringEvent'),
        z.literal('specialEvent'),
        z.literal('visitUrl'),
        z.literal('welcomeSeries'),
      ]),
    })
    .optional(),
});

export const postAutomationsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getAutomationsIdDataSchema = z.object({
  path: z.object({
    workflow_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getAutomationsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  create_time: z.string().optional(),
  emails_sent: z.number().optional(),
  id: z.string().optional(),
  recipients: z
    .object({
      list_id: z.string().optional(),
      list_is_active: z.boolean().optional(),
      list_name: z.string().optional(),
      segment_opts: z
        .object({
          conditions: z
            .array(
              z.union([
                z.object({
                  condition_type: z.literal('Aim').optional(),
                  field: z.literal('aim').optional(),
                  op: z
                    .union([
                      z.literal('open'),
                      z.literal('click'),
                      z.literal('sent'),
                      z.literal('noopen'),
                      z.literal('noclick'),
                      z.literal('nosent'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('Automation').optional(),
                  field: z.literal('automation'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('CampaignPoll').optional(),
                  field: z.literal('poll'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('Conversation').optional(),
                  field: z.literal('conversation'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Date').optional(),
                  extra: z.string().optional(),
                  field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
                  op: z.union([
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('within'),
                    z.literal('notwithin'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('EmailClient').optional(),
                  field: z.literal('email_client'),
                  op: z.union([z.literal('client_is'), z.literal('client_not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Language').optional(),
                  field: z.literal('language'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('MemberRating').optional(),
                  field: z.literal('rating'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SignupSource'),
                  field: z.literal('source'),
                  op: z.union([z.literal('source_is'), z.literal('source_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SurveyMonkey').optional(),
                  field: z.literal('survey_monkey'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('VIP').optional(),
                  field: z.literal('gmonkey'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                }),
                z.object({
                  condition_type: z.literal('Interests').optional(),
                  field: z.string().optional(),
                  op: z
                    .union([
                      z.literal('interestcontains'),
                      z.literal('interestcontainsall'),
                      z.literal('interestnotcontains'),
                    ])
                    .optional(),
                  value: z.array(z.string()).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommCategory').optional(),
                  field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                  op: z
                    .union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommNumber').optional(),
                  field: z.union([
                    z.literal('ecomm_spent_avg'),
                    z.literal('ecomm_orders'),
                    z.literal('ecomm_prod_all'),
                    z.literal('ecomm_avg_ord'),
                  ]),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('EcommPurchased').optional(),
                  field: z.literal('ecomm_purchased').optional(),
                  op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommSpent').optional(),
                  field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                  op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                  value: z.number().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommStore').optional(),
                  field: z.literal('ecomm_store').optional(),
                  op: z.union([z.literal('is'), z.literal('not')]).optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('GoalActivity').optional(),
                  field: z.literal('goal'),
                  op: z.union([
                    z.literal('is'),
                    z.literal('goal_not'),
                    z.literal('contains'),
                    z.literal('goal_notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('GoalTimestamp').optional(),
                  field: z.literal('goal_last_visited'),
                  op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('FuzzySegment').optional(),
                  field: z.literal('fuzzy_segment'),
                  op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('StaticSegment').optional(),
                  field: z.literal('static_segment'),
                  op: z.union([z.literal('static_is'), z.literal('static_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoCountryState').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([
                    z.literal('ipgeocountry'),
                    z.literal('ipgeonotcountry'),
                    z.literal('ipgeostate'),
                    z.literal('ipgeonotstate'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  addr: z.string(),
                  condition_type: z.literal('IPGeoIn').optional(),
                  field: z.literal('ipgeo'),
                  lat: z.string(),
                  lng: z.string(),
                  op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoInZip').optional(),
                  extra: z.number(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeoinzip'),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoUnknown').optional(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeounknown'),
                }),
                z.object({
                  condition_type: z.literal('IPGeoZip').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialAge').optional(),
                  field: z.literal('social_age'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                }),
                z.object({
                  condition_type: z.literal('SocialGender').optional(),
                  field: z.literal('social_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('SocialInfluence').optional(),
                  field: z.literal('social_influence'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkMember').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.union([
                    z.literal('twitter'),
                    z.literal('facebook'),
                    z.literal('linkedin'),
                    z.literal('flickr'),
                    z.literal('foursquare'),
                    z.literal('lastfm'),
                    z.literal('myspace'),
                    z.literal('quora'),
                    z.literal('vimeo'),
                    z.literal('yelp'),
                    z.literal('youtube'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkFollow').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('follow'), z.literal('notfollow')]),
                  value: z.literal('twitter_follow'),
                }),
                z.object({
                  condition_type: z.literal('AddressMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('ZipMerge').optional(),
                  extra: z.string(),
                  field: z.string(),
                  op: z.literal('geoin'),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('BirthdayMerge').optional(),
                  field: z.string(),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('DateMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('greater'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SelectMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('notcontain'),
                    z.literal('contains'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('TextMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EmailAddress').optional(),
                  field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('PredictedGender').optional(),
                  field: z.literal('predicted_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('PredictedAge').optional(),
                  field: z.literal('predicted_age_range'),
                  op: z.literal('is'),
                  value: z.union([
                    z.literal('18-24'),
                    z.literal('25-34'),
                    z.literal('35-44'),
                    z.literal('45-54'),
                    z.literal('55-64'),
                    z.literal('65+'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('NewSubscribers').optional(),
                  field: z.literal('timestamp_opt').optional(),
                  op: z.literal('date_within').optional(),
                  value: z.string().optional(),
                }),
              ]),
            )
            .optional(),
          match: z.union([z.literal('any'), z.literal('all')]).optional(),
          saved_segment_id: z.number().optional(),
        })
        .optional(),
      store_id: z.string().optional(),
    })
    .optional(),
  report_summary: z
    .object({
      click_rate: z.number().optional(),
      clicks: z.number().optional(),
      open_rate: z.number().optional(),
      opens: z.number().optional(),
      subscriber_clicks: z.number().optional(),
      unique_opens: z.number().optional(),
    })
    .optional(),
  settings: z
    .object({
      authenticate: z.boolean().optional(),
      auto_footer: z.boolean().optional(),
      from_name: z.string().optional(),
      inline_css: z.boolean().optional(),
      reply_to: z.string().optional(),
      title: z.string().optional(),
      to_name: z.string().optional(),
      use_conversation: z.boolean().optional(),
    })
    .optional(),
  start_time: z.string().optional(),
  status: z.union([z.literal('save'), z.literal('paused'), z.literal('sending')]).optional(),
  tracking: z
    .object({
      capsule: z
        .object({
          notes: z.boolean().optional(),
        })
        .optional(),
      clicktale: z.string().optional(),
      ecomm360: z.boolean().optional(),
      goal_tracking: z.boolean().optional(),
      google_analytics: z.string().optional(),
      html_clicks: z.boolean().optional(),
      opens: z.boolean().optional(),
      salesforce: z
        .object({
          campaign: z.boolean().optional(),
          notes: z.boolean().optional(),
        })
        .optional(),
      text_clicks: z.boolean().optional(),
    })
    .optional(),
  trigger_settings: z
    .object({
      runtime: z
        .object({
          days: z
            .array(
              z.union([
                z.literal('sunday'),
                z.literal('monday'),
                z.literal('tuesday'),
                z.literal('wednesday'),
                z.literal('thursday'),
                z.literal('friday'),
                z.literal('saturday'),
              ]),
            )
            .optional(),
          hours: z
            .object({
              type: z.union([z.literal('send_asap'), z.literal('send_between'), z.literal('send_at')]),
            })
            .optional(),
        })
        .optional(),
      workflow_emails_count: z.number().optional(),
      workflow_title: z.string().optional(),
      workflow_type: z.union([
        z.literal('abandonedBrowse'),
        z.literal('abandonedCart'),
        z.literal('api'),
        z.literal('bestCustomers'),
        z.literal('categoryFollowup'),
        z.literal('dateAdded'),
        z.literal('emailFollowup'),
        z.literal('emailSeries'),
        z.literal('groupAdd'),
        z.literal('groupRemove'),
        z.literal('mandrill'),
        z.literal('productFollowup'),
        z.literal('purchaseFollowup'),
        z.literal('recurringEvent'),
        z.literal('specialEvent'),
        z.literal('visitUrl'),
        z.literal('welcomeSeries'),
      ]),
    })
    .optional(),
});

export const getAutomationsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const archiveAutomationsDataSchema = z.object({
  path: z.object({
    workflow_id: z.string(),
  }),
});

export const archiveAutomationsResponseSchema = z.any();

export const archiveAutomationsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postAutomationsIdActionsPauseAllEmailsDataSchema = z.object({
  path: z.object({
    workflow_id: z.string(),
  }),
});

export const postAutomationsIdActionsPauseAllEmailsResponseSchema = z.any();

export const postAutomationsIdActionsPauseAllEmailsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postAutomationsIdActionsStartAllEmailsDataSchema = z.object({
  path: z.object({
    workflow_id: z.string(),
  }),
});

export const postAutomationsIdActionsStartAllEmailsResponseSchema = z.any();

export const postAutomationsIdActionsStartAllEmailsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getAutomationsIdEmailsDataSchema = z.object({
  path: z.object({
    workflow_id: z.string(),
  }),
});

export const getAutomationsIdEmailsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  emails: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        archive_url: z.string().optional(),
        content_type: z.string().optional(),
        create_time: z.string().optional(),
        delay: z
          .object({
            action: z
              .union([
                z.literal('previous_campaign_sent'),
                z.literal('previous_campaign_opened'),
                z.literal('previous_campaign_not_opened'),
                z.literal('previous_campaign_clicked_any'),
                z.literal('previous_campaign_not_clicked_any'),
                z.literal('previous_campaign_specific_clicked'),
                z.literal('ecomm_bought_any'),
                z.literal('ecomm_bought_product'),
                z.literal('ecomm_bought_category'),
                z.literal('ecomm_not_bought_any'),
                z.literal('ecomm_abandoned_cart'),
                z.literal('campaign_sent'),
                z.literal('opened_email'),
                z.literal('not_opened_email'),
                z.literal('clicked_email'),
                z.literal('not_clicked_email'),
                z.literal('campaign_specific_clicked'),
                z.literal('manual'),
                z.literal('signup'),
                z.literal('merge_changed'),
                z.literal('group_add'),
                z.literal('group_remove'),
                z.literal('mandrill_sent'),
                z.literal('mandrill_opened'),
                z.literal('mandrill_clicked'),
                z.literal('mandrill_any'),
                z.literal('api'),
                z.literal('goal'),
                z.literal('annual'),
                z.literal('birthday'),
                z.literal('date'),
                z.literal('date_added'),
                z.literal('tag_add'),
              ])
              .optional(),
            action_description: z.string().optional(),
            amount: z.number().optional(),
            direction: z.union([z.literal('before'), z.literal('after')]).optional(),
            full_description: z.string().optional(),
            type: z.union([z.literal('now'), z.literal('day'), z.literal('hour'), z.literal('week')]).optional(),
          })
          .optional(),
        emails_sent: z.number().optional(),
        has_logo_merge_tag: z.boolean().optional(),
        id: z.string().optional(),
        needs_block_refresh: z.boolean().optional(),
        position: z.number().optional(),
        recipients: z
          .object({
            list_id: z.string().optional(),
            list_is_active: z.boolean().optional(),
            list_name: z.string().optional(),
            recipient_count: z.number().optional(),
            segment_opts: z
              .object({
                conditions: z
                  .array(
                    z.union([
                      z.object({
                        condition_type: z.literal('Aim').optional(),
                        field: z.literal('aim').optional(),
                        op: z
                          .union([
                            z.literal('open'),
                            z.literal('click'),
                            z.literal('sent'),
                            z.literal('noopen'),
                            z.literal('noclick'),
                            z.literal('nosent'),
                          ])
                          .optional(),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('Automation').optional(),
                        field: z.literal('automation'),
                        op: z.union([
                          z.literal('started'),
                          z.literal('completed'),
                          z.literal('not_started'),
                          z.literal('not_completed'),
                        ]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('CampaignPoll').optional(),
                        field: z.literal('poll'),
                        op: z.union([z.literal('member'), z.literal('notmember')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('Conversation').optional(),
                        field: z.literal('conversation'),
                        op: z.union([z.literal('member'), z.literal('notmember')]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('Date').optional(),
                        extra: z.string().optional(),
                        field: z.union([
                          z.literal('timestamp_opt'),
                          z.literal('info_changed'),
                          z.literal('ecomm_date'),
                        ]),
                        op: z.union([
                          z.literal('greater'),
                          z.literal('less'),
                          z.literal('is'),
                          z.literal('not'),
                          z.literal('blank'),
                          z.literal('blank_not'),
                          z.literal('within'),
                          z.literal('notwithin'),
                        ]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('EmailClient').optional(),
                        field: z.literal('email_client'),
                        op: z.union([z.literal('client_is'), z.literal('client_not')]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('Language').optional(),
                        field: z.literal('language'),
                        op: z.union([z.literal('is'), z.literal('not')]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('MemberRating').optional(),
                        field: z.literal('rating'),
                        op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('SignupSource'),
                        field: z.literal('source'),
                        op: z.union([z.literal('source_is'), z.literal('source_not')]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('SurveyMonkey').optional(),
                        field: z.literal('survey_monkey'),
                        op: z.union([
                          z.literal('started'),
                          z.literal('completed'),
                          z.literal('not_started'),
                          z.literal('not_completed'),
                        ]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('VIP').optional(),
                        field: z.literal('gmonkey'),
                        op: z.union([z.literal('member'), z.literal('notmember')]),
                      }),
                      z.object({
                        condition_type: z.literal('Interests').optional(),
                        field: z.string().optional(),
                        op: z
                          .union([
                            z.literal('interestcontains'),
                            z.literal('interestcontainsall'),
                            z.literal('interestnotcontains'),
                          ])
                          .optional(),
                        value: z.array(z.string()).optional(),
                      }),
                      z.object({
                        condition_type: z.literal('EcommCategory').optional(),
                        field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                        op: z
                          .union([
                            z.literal('is'),
                            z.literal('not'),
                            z.literal('contains'),
                            z.literal('notcontain'),
                            z.literal('starts'),
                            z.literal('ends'),
                          ])
                          .optional(),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('EcommNumber').optional(),
                        field: z.union([
                          z.literal('ecomm_spent_avg'),
                          z.literal('ecomm_orders'),
                          z.literal('ecomm_prod_all'),
                          z.literal('ecomm_avg_ord'),
                        ]),
                        op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('EcommPurchased').optional(),
                        field: z.literal('ecomm_purchased').optional(),
                        op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                      }),
                      z.object({
                        condition_type: z.literal('EcommSpent').optional(),
                        field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                        op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                        value: z.number().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('EcommStore').optional(),
                        field: z.literal('ecomm_store').optional(),
                        op: z.union([z.literal('is'), z.literal('not')]).optional(),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('GoalActivity').optional(),
                        field: z.literal('goal'),
                        op: z.union([
                          z.literal('is'),
                          z.literal('goal_not'),
                          z.literal('contains'),
                          z.literal('goal_notcontain'),
                          z.literal('starts'),
                          z.literal('ends'),
                        ]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('GoalTimestamp').optional(),
                        field: z.literal('goal_last_visited'),
                        op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('FuzzySegment').optional(),
                        field: z.literal('fuzzy_segment'),
                        op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('StaticSegment').optional(),
                        field: z.literal('static_segment'),
                        op: z.union([z.literal('static_is'), z.literal('static_not')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('IPGeoCountryState').optional(),
                        field: z.literal('ipgeo'),
                        op: z.union([
                          z.literal('ipgeocountry'),
                          z.literal('ipgeonotcountry'),
                          z.literal('ipgeostate'),
                          z.literal('ipgeonotstate'),
                        ]),
                        value: z.string(),
                      }),
                      z.object({
                        addr: z.string(),
                        condition_type: z.literal('IPGeoIn').optional(),
                        field: z.literal('ipgeo'),
                        lat: z.string(),
                        lng: z.string(),
                        op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('IPGeoInZip').optional(),
                        extra: z.number(),
                        field: z.literal('ipgeo'),
                        op: z.literal('ipgeoinzip'),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('IPGeoUnknown').optional(),
                        field: z.literal('ipgeo'),
                        op: z.literal('ipgeounknown'),
                      }),
                      z.object({
                        condition_type: z.literal('IPGeoZip').optional(),
                        field: z.literal('ipgeo'),
                        op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('SocialAge').optional(),
                        field: z.literal('social_age'),
                        op: z.union([z.literal('is'), z.literal('not')]),
                        value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                      }),
                      z.object({
                        condition_type: z.literal('SocialGender').optional(),
                        field: z.literal('social_gender'),
                        op: z.union([z.literal('is'), z.literal('not')]),
                        value: z.union([z.literal('male'), z.literal('female')]),
                      }),
                      z.object({
                        condition_type: z.literal('SocialInfluence').optional(),
                        field: z.literal('social_influence'),
                        op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('SocialNetworkMember').optional(),
                        field: z.literal('social_network'),
                        op: z.union([z.literal('member'), z.literal('notmember')]),
                        value: z.union([
                          z.literal('twitter'),
                          z.literal('facebook'),
                          z.literal('linkedin'),
                          z.literal('flickr'),
                          z.literal('foursquare'),
                          z.literal('lastfm'),
                          z.literal('myspace'),
                          z.literal('quora'),
                          z.literal('vimeo'),
                          z.literal('yelp'),
                          z.literal('youtube'),
                        ]),
                      }),
                      z.object({
                        condition_type: z.literal('SocialNetworkFollow').optional(),
                        field: z.literal('social_network'),
                        op: z.union([z.literal('follow'), z.literal('notfollow')]),
                        value: z.literal('twitter_follow'),
                      }),
                      z.object({
                        condition_type: z.literal('AddressMerge').optional(),
                        field: z.string(),
                        op: z.union([
                          z.literal('contains'),
                          z.literal('notcontain'),
                          z.literal('blank'),
                          z.literal('blank_not'),
                        ]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('ZipMerge').optional(),
                        extra: z.string(),
                        field: z.string(),
                        op: z.literal('geoin'),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('BirthdayMerge').optional(),
                        field: z.string(),
                        op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('DateMerge').optional(),
                        field: z.string(),
                        op: z.union([
                          z.literal('is'),
                          z.literal('not'),
                          z.literal('less'),
                          z.literal('blank'),
                          z.literal('blank_not'),
                          z.literal('greater'),
                        ]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('SelectMerge').optional(),
                        field: z.string(),
                        op: z.union([
                          z.literal('is'),
                          z.literal('not'),
                          z.literal('blank'),
                          z.literal('blank_not'),
                          z.literal('notcontain'),
                          z.literal('contains'),
                        ]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('TextMerge').optional(),
                        field: z.string(),
                        op: z.union([
                          z.literal('is'),
                          z.literal('not'),
                          z.literal('contains'),
                          z.literal('notcontain'),
                          z.literal('starts'),
                          z.literal('ends'),
                          z.literal('greater'),
                          z.literal('less'),
                          z.literal('blank'),
                          z.literal('blank_not'),
                        ]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('EmailAddress').optional(),
                        field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                        op: z.union([
                          z.literal('is'),
                          z.literal('not'),
                          z.literal('contains'),
                          z.literal('notcontain'),
                          z.literal('starts'),
                          z.literal('ends'),
                          z.literal('greater'),
                          z.literal('less'),
                        ]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('PredictedGender').optional(),
                        field: z.literal('predicted_gender'),
                        op: z.union([z.literal('is'), z.literal('not')]),
                        value: z.union([z.literal('male'), z.literal('female')]),
                      }),
                      z.object({
                        condition_type: z.literal('PredictedAge').optional(),
                        field: z.literal('predicted_age_range'),
                        op: z.literal('is'),
                        value: z.union([
                          z.literal('18-24'),
                          z.literal('25-34'),
                          z.literal('35-44'),
                          z.literal('45-54'),
                          z.literal('55-64'),
                          z.literal('65+'),
                        ]),
                      }),
                      z.object({
                        condition_type: z.literal('NewSubscribers').optional(),
                        field: z.literal('timestamp_opt').optional(),
                        op: z.literal('date_within').optional(),
                        value: z.string().optional(),
                      }),
                    ]),
                  )
                  .optional(),
                match: z.union([z.literal('any'), z.literal('all')]).optional(),
                prebuilt_segment_id: z.string().optional(),
                saved_segment_id: z.number().optional(),
              })
              .optional(),
            segment_text: z.string().optional(),
          })
          .optional(),
        report_summary: z
          .object({
            click_rate: z.number().optional(),
            clicks: z.number().optional(),
            open_rate: z.number().optional(),
            opens: z.number().optional(),
            subscriber_clicks: z.number().optional(),
            unique_opens: z.number().optional(),
          })
          .optional(),
        send_time: z.string().optional(),
        settings: z
          .object({
            authenticate: z.boolean().optional(),
            auto_fb_post: z.array(z.string()).optional(),
            auto_footer: z.boolean().optional(),
            auto_tweet: z.boolean().optional(),
            drag_and_drop: z.boolean().optional(),
            fb_comments: z.boolean().optional(),
            from_name: z.string().optional(),
            inline_css: z.boolean().optional(),
            preview_text: z.string().optional(),
            reply_to: z.string().optional(),
            subject_line: z.string().optional(),
            template_id: z.number().optional(),
            title: z.string().optional(),
          })
          .optional(),
        social_card: z
          .object({
            description: z.string().optional(),
            image_url: z.string().optional(),
            title: z.string().optional(),
          })
          .optional(),
        start_time: z.string().optional(),
        status: z.union([z.literal('save'), z.literal('paused'), z.literal('sending')]).optional(),
        tracking: z
          .object({
            capsule: z
              .object({
                notes: z.boolean().optional(),
              })
              .optional(),
            clicktale: z.string().optional(),
            ecomm360: z.boolean().optional(),
            goal_tracking: z.boolean().optional(),
            google_analytics: z.string().optional(),
            html_clicks: z.boolean().optional(),
            opens: z.boolean().optional(),
            salesforce: z
              .object({
                campaign: z.boolean().optional(),
                notes: z.boolean().optional(),
              })
              .optional(),
            text_clicks: z.boolean().optional(),
          })
          .optional(),
        trigger_settings: z
          .object({
            runtime: z
              .object({
                days: z
                  .array(
                    z.union([
                      z.literal('sunday'),
                      z.literal('monday'),
                      z.literal('tuesday'),
                      z.literal('wednesday'),
                      z.literal('thursday'),
                      z.literal('friday'),
                      z.literal('saturday'),
                    ]),
                  )
                  .optional(),
                hours: z
                  .object({
                    type: z.union([z.literal('send_asap'), z.literal('send_between'), z.literal('send_at')]),
                  })
                  .optional(),
              })
              .optional(),
            workflow_emails_count: z.number().optional(),
            workflow_title: z.string().optional(),
            workflow_type: z.union([
              z.literal('abandonedBrowse'),
              z.literal('abandonedCart'),
              z.literal('api'),
              z.literal('bestCustomers'),
              z.literal('categoryFollowup'),
              z.literal('dateAdded'),
              z.literal('emailFollowup'),
              z.literal('emailSeries'),
              z.literal('groupAdd'),
              z.literal('groupRemove'),
              z.literal('mandrill'),
              z.literal('productFollowup'),
              z.literal('purchaseFollowup'),
              z.literal('recurringEvent'),
              z.literal('specialEvent'),
              z.literal('visitUrl'),
              z.literal('welcomeSeries'),
            ]),
          })
          .optional(),
        web_id: z.number().optional(),
        workflow_id: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getAutomationsIdEmailsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteAutomationsIdEmailsIdDataSchema = z.object({
  path: z.object({
    workflow_email_id: z.string(),
    workflow_id: z.string(),
  }),
});

export const deleteAutomationsIdEmailsIdResponseSchema = z.any();

export const deleteAutomationsIdEmailsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getAutomationsIdEmailsIdDataSchema = z.object({
  path: z.object({
    workflow_email_id: z.string(),
    workflow_id: z.string(),
  }),
});

export const getAutomationsIdEmailsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  archive_url: z.string().optional(),
  content_type: z.string().optional(),
  create_time: z.string().optional(),
  delay: z
    .object({
      action: z
        .union([
          z.literal('previous_campaign_sent'),
          z.literal('previous_campaign_opened'),
          z.literal('previous_campaign_not_opened'),
          z.literal('previous_campaign_clicked_any'),
          z.literal('previous_campaign_not_clicked_any'),
          z.literal('previous_campaign_specific_clicked'),
          z.literal('ecomm_bought_any'),
          z.literal('ecomm_bought_product'),
          z.literal('ecomm_bought_category'),
          z.literal('ecomm_not_bought_any'),
          z.literal('ecomm_abandoned_cart'),
          z.literal('campaign_sent'),
          z.literal('opened_email'),
          z.literal('not_opened_email'),
          z.literal('clicked_email'),
          z.literal('not_clicked_email'),
          z.literal('campaign_specific_clicked'),
          z.literal('manual'),
          z.literal('signup'),
          z.literal('merge_changed'),
          z.literal('group_add'),
          z.literal('group_remove'),
          z.literal('mandrill_sent'),
          z.literal('mandrill_opened'),
          z.literal('mandrill_clicked'),
          z.literal('mandrill_any'),
          z.literal('api'),
          z.literal('goal'),
          z.literal('annual'),
          z.literal('birthday'),
          z.literal('date'),
          z.literal('date_added'),
          z.literal('tag_add'),
        ])
        .optional(),
      action_description: z.string().optional(),
      amount: z.number().optional(),
      direction: z.union([z.literal('before'), z.literal('after')]).optional(),
      full_description: z.string().optional(),
      type: z.union([z.literal('now'), z.literal('day'), z.literal('hour'), z.literal('week')]).optional(),
    })
    .optional(),
  emails_sent: z.number().optional(),
  has_logo_merge_tag: z.boolean().optional(),
  id: z.string().optional(),
  needs_block_refresh: z.boolean().optional(),
  position: z.number().optional(),
  recipients: z
    .object({
      list_id: z.string().optional(),
      list_is_active: z.boolean().optional(),
      list_name: z.string().optional(),
      recipient_count: z.number().optional(),
      segment_opts: z
        .object({
          conditions: z
            .array(
              z.union([
                z.object({
                  condition_type: z.literal('Aim').optional(),
                  field: z.literal('aim').optional(),
                  op: z
                    .union([
                      z.literal('open'),
                      z.literal('click'),
                      z.literal('sent'),
                      z.literal('noopen'),
                      z.literal('noclick'),
                      z.literal('nosent'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('Automation').optional(),
                  field: z.literal('automation'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('CampaignPoll').optional(),
                  field: z.literal('poll'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('Conversation').optional(),
                  field: z.literal('conversation'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Date').optional(),
                  extra: z.string().optional(),
                  field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
                  op: z.union([
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('within'),
                    z.literal('notwithin'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('EmailClient').optional(),
                  field: z.literal('email_client'),
                  op: z.union([z.literal('client_is'), z.literal('client_not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Language').optional(),
                  field: z.literal('language'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('MemberRating').optional(),
                  field: z.literal('rating'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SignupSource'),
                  field: z.literal('source'),
                  op: z.union([z.literal('source_is'), z.literal('source_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SurveyMonkey').optional(),
                  field: z.literal('survey_monkey'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('VIP').optional(),
                  field: z.literal('gmonkey'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                }),
                z.object({
                  condition_type: z.literal('Interests').optional(),
                  field: z.string().optional(),
                  op: z
                    .union([
                      z.literal('interestcontains'),
                      z.literal('interestcontainsall'),
                      z.literal('interestnotcontains'),
                    ])
                    .optional(),
                  value: z.array(z.string()).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommCategory').optional(),
                  field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                  op: z
                    .union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommNumber').optional(),
                  field: z.union([
                    z.literal('ecomm_spent_avg'),
                    z.literal('ecomm_orders'),
                    z.literal('ecomm_prod_all'),
                    z.literal('ecomm_avg_ord'),
                  ]),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('EcommPurchased').optional(),
                  field: z.literal('ecomm_purchased').optional(),
                  op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommSpent').optional(),
                  field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                  op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                  value: z.number().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommStore').optional(),
                  field: z.literal('ecomm_store').optional(),
                  op: z.union([z.literal('is'), z.literal('not')]).optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('GoalActivity').optional(),
                  field: z.literal('goal'),
                  op: z.union([
                    z.literal('is'),
                    z.literal('goal_not'),
                    z.literal('contains'),
                    z.literal('goal_notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('GoalTimestamp').optional(),
                  field: z.literal('goal_last_visited'),
                  op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('FuzzySegment').optional(),
                  field: z.literal('fuzzy_segment'),
                  op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('StaticSegment').optional(),
                  field: z.literal('static_segment'),
                  op: z.union([z.literal('static_is'), z.literal('static_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoCountryState').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([
                    z.literal('ipgeocountry'),
                    z.literal('ipgeonotcountry'),
                    z.literal('ipgeostate'),
                    z.literal('ipgeonotstate'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  addr: z.string(),
                  condition_type: z.literal('IPGeoIn').optional(),
                  field: z.literal('ipgeo'),
                  lat: z.string(),
                  lng: z.string(),
                  op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoInZip').optional(),
                  extra: z.number(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeoinzip'),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoUnknown').optional(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeounknown'),
                }),
                z.object({
                  condition_type: z.literal('IPGeoZip').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialAge').optional(),
                  field: z.literal('social_age'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                }),
                z.object({
                  condition_type: z.literal('SocialGender').optional(),
                  field: z.literal('social_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('SocialInfluence').optional(),
                  field: z.literal('social_influence'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkMember').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.union([
                    z.literal('twitter'),
                    z.literal('facebook'),
                    z.literal('linkedin'),
                    z.literal('flickr'),
                    z.literal('foursquare'),
                    z.literal('lastfm'),
                    z.literal('myspace'),
                    z.literal('quora'),
                    z.literal('vimeo'),
                    z.literal('yelp'),
                    z.literal('youtube'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkFollow').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('follow'), z.literal('notfollow')]),
                  value: z.literal('twitter_follow'),
                }),
                z.object({
                  condition_type: z.literal('AddressMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('ZipMerge').optional(),
                  extra: z.string(),
                  field: z.string(),
                  op: z.literal('geoin'),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('BirthdayMerge').optional(),
                  field: z.string(),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('DateMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('greater'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SelectMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('notcontain'),
                    z.literal('contains'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('TextMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EmailAddress').optional(),
                  field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('PredictedGender').optional(),
                  field: z.literal('predicted_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('PredictedAge').optional(),
                  field: z.literal('predicted_age_range'),
                  op: z.literal('is'),
                  value: z.union([
                    z.literal('18-24'),
                    z.literal('25-34'),
                    z.literal('35-44'),
                    z.literal('45-54'),
                    z.literal('55-64'),
                    z.literal('65+'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('NewSubscribers').optional(),
                  field: z.literal('timestamp_opt').optional(),
                  op: z.literal('date_within').optional(),
                  value: z.string().optional(),
                }),
              ]),
            )
            .optional(),
          match: z.union([z.literal('any'), z.literal('all')]).optional(),
          prebuilt_segment_id: z.string().optional(),
          saved_segment_id: z.number().optional(),
        })
        .optional(),
      segment_text: z.string().optional(),
    })
    .optional(),
  report_summary: z
    .object({
      click_rate: z.number().optional(),
      clicks: z.number().optional(),
      open_rate: z.number().optional(),
      opens: z.number().optional(),
      subscriber_clicks: z.number().optional(),
      unique_opens: z.number().optional(),
    })
    .optional(),
  send_time: z.string().optional(),
  settings: z
    .object({
      authenticate: z.boolean().optional(),
      auto_fb_post: z.array(z.string()).optional(),
      auto_footer: z.boolean().optional(),
      auto_tweet: z.boolean().optional(),
      drag_and_drop: z.boolean().optional(),
      fb_comments: z.boolean().optional(),
      from_name: z.string().optional(),
      inline_css: z.boolean().optional(),
      preview_text: z.string().optional(),
      reply_to: z.string().optional(),
      subject_line: z.string().optional(),
      template_id: z.number().optional(),
      title: z.string().optional(),
    })
    .optional(),
  social_card: z
    .object({
      description: z.string().optional(),
      image_url: z.string().optional(),
      title: z.string().optional(),
    })
    .optional(),
  start_time: z.string().optional(),
  status: z.union([z.literal('save'), z.literal('paused'), z.literal('sending')]).optional(),
  tracking: z
    .object({
      capsule: z
        .object({
          notes: z.boolean().optional(),
        })
        .optional(),
      clicktale: z.string().optional(),
      ecomm360: z.boolean().optional(),
      goal_tracking: z.boolean().optional(),
      google_analytics: z.string().optional(),
      html_clicks: z.boolean().optional(),
      opens: z.boolean().optional(),
      salesforce: z
        .object({
          campaign: z.boolean().optional(),
          notes: z.boolean().optional(),
        })
        .optional(),
      text_clicks: z.boolean().optional(),
    })
    .optional(),
  trigger_settings: z
    .object({
      runtime: z
        .object({
          days: z
            .array(
              z.union([
                z.literal('sunday'),
                z.literal('monday'),
                z.literal('tuesday'),
                z.literal('wednesday'),
                z.literal('thursday'),
                z.literal('friday'),
                z.literal('saturday'),
              ]),
            )
            .optional(),
          hours: z
            .object({
              type: z.union([z.literal('send_asap'), z.literal('send_between'), z.literal('send_at')]),
            })
            .optional(),
        })
        .optional(),
      workflow_emails_count: z.number().optional(),
      workflow_title: z.string().optional(),
      workflow_type: z.union([
        z.literal('abandonedBrowse'),
        z.literal('abandonedCart'),
        z.literal('api'),
        z.literal('bestCustomers'),
        z.literal('categoryFollowup'),
        z.literal('dateAdded'),
        z.literal('emailFollowup'),
        z.literal('emailSeries'),
        z.literal('groupAdd'),
        z.literal('groupRemove'),
        z.literal('mandrill'),
        z.literal('productFollowup'),
        z.literal('purchaseFollowup'),
        z.literal('recurringEvent'),
        z.literal('specialEvent'),
        z.literal('visitUrl'),
        z.literal('welcomeSeries'),
      ]),
    })
    .optional(),
  web_id: z.number().optional(),
  workflow_id: z.string().optional(),
});

export const getAutomationsIdEmailsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchAutomationEmailWorkflowIdDataSchema = z.object({
  body: z.object({
    delay: z
      .object({
        action: z.union([z.literal('signup'), z.literal('ecomm_abandoned_browse'), z.literal('ecomm_abandoned_cart')]),
        amount: z.number().optional(),
        direction: z.literal('after').optional(),
        type: z.union([z.literal('now'), z.literal('day'), z.literal('hour'), z.literal('week')]).optional(),
      })
      .optional(),
    settings: z
      .object({
        from_name: z.string().optional(),
        preview_text: z.string().optional(),
        reply_to: z.string().optional(),
        subject_line: z.string().optional(),
        title: z.string().optional(),
      })
      .optional(),
  }),
  path: z.object({
    workflow_email_id: z.string(),
    workflow_id: z.string(),
  }),
});

export const patchAutomationEmailWorkflowIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  archive_url: z.string().optional(),
  content_type: z.string().optional(),
  create_time: z.string().optional(),
  delay: z
    .object({
      action: z
        .union([
          z.literal('previous_campaign_sent'),
          z.literal('previous_campaign_opened'),
          z.literal('previous_campaign_not_opened'),
          z.literal('previous_campaign_clicked_any'),
          z.literal('previous_campaign_not_clicked_any'),
          z.literal('previous_campaign_specific_clicked'),
          z.literal('ecomm_bought_any'),
          z.literal('ecomm_bought_product'),
          z.literal('ecomm_bought_category'),
          z.literal('ecomm_not_bought_any'),
          z.literal('ecomm_abandoned_cart'),
          z.literal('campaign_sent'),
          z.literal('opened_email'),
          z.literal('not_opened_email'),
          z.literal('clicked_email'),
          z.literal('not_clicked_email'),
          z.literal('campaign_specific_clicked'),
          z.literal('manual'),
          z.literal('signup'),
          z.literal('merge_changed'),
          z.literal('group_add'),
          z.literal('group_remove'),
          z.literal('mandrill_sent'),
          z.literal('mandrill_opened'),
          z.literal('mandrill_clicked'),
          z.literal('mandrill_any'),
          z.literal('api'),
          z.literal('goal'),
          z.literal('annual'),
          z.literal('birthday'),
          z.literal('date'),
          z.literal('date_added'),
          z.literal('tag_add'),
        ])
        .optional(),
      action_description: z.string().optional(),
      amount: z.number().optional(),
      direction: z.union([z.literal('before'), z.literal('after')]).optional(),
      full_description: z.string().optional(),
      type: z.union([z.literal('now'), z.literal('day'), z.literal('hour'), z.literal('week')]).optional(),
    })
    .optional(),
  emails_sent: z.number().optional(),
  has_logo_merge_tag: z.boolean().optional(),
  id: z.string().optional(),
  needs_block_refresh: z.boolean().optional(),
  position: z.number().optional(),
  recipients: z
    .object({
      list_id: z.string().optional(),
      list_is_active: z.boolean().optional(),
      list_name: z.string().optional(),
      recipient_count: z.number().optional(),
      segment_opts: z
        .object({
          conditions: z
            .array(
              z.union([
                z.object({
                  condition_type: z.literal('Aim').optional(),
                  field: z.literal('aim').optional(),
                  op: z
                    .union([
                      z.literal('open'),
                      z.literal('click'),
                      z.literal('sent'),
                      z.literal('noopen'),
                      z.literal('noclick'),
                      z.literal('nosent'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('Automation').optional(),
                  field: z.literal('automation'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('CampaignPoll').optional(),
                  field: z.literal('poll'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('Conversation').optional(),
                  field: z.literal('conversation'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Date').optional(),
                  extra: z.string().optional(),
                  field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
                  op: z.union([
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('within'),
                    z.literal('notwithin'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('EmailClient').optional(),
                  field: z.literal('email_client'),
                  op: z.union([z.literal('client_is'), z.literal('client_not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Language').optional(),
                  field: z.literal('language'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('MemberRating').optional(),
                  field: z.literal('rating'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SignupSource'),
                  field: z.literal('source'),
                  op: z.union([z.literal('source_is'), z.literal('source_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SurveyMonkey').optional(),
                  field: z.literal('survey_monkey'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('VIP').optional(),
                  field: z.literal('gmonkey'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                }),
                z.object({
                  condition_type: z.literal('Interests').optional(),
                  field: z.string().optional(),
                  op: z
                    .union([
                      z.literal('interestcontains'),
                      z.literal('interestcontainsall'),
                      z.literal('interestnotcontains'),
                    ])
                    .optional(),
                  value: z.array(z.string()).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommCategory').optional(),
                  field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                  op: z
                    .union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommNumber').optional(),
                  field: z.union([
                    z.literal('ecomm_spent_avg'),
                    z.literal('ecomm_orders'),
                    z.literal('ecomm_prod_all'),
                    z.literal('ecomm_avg_ord'),
                  ]),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('EcommPurchased').optional(),
                  field: z.literal('ecomm_purchased').optional(),
                  op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommSpent').optional(),
                  field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                  op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                  value: z.number().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommStore').optional(),
                  field: z.literal('ecomm_store').optional(),
                  op: z.union([z.literal('is'), z.literal('not')]).optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('GoalActivity').optional(),
                  field: z.literal('goal'),
                  op: z.union([
                    z.literal('is'),
                    z.literal('goal_not'),
                    z.literal('contains'),
                    z.literal('goal_notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('GoalTimestamp').optional(),
                  field: z.literal('goal_last_visited'),
                  op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('FuzzySegment').optional(),
                  field: z.literal('fuzzy_segment'),
                  op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('StaticSegment').optional(),
                  field: z.literal('static_segment'),
                  op: z.union([z.literal('static_is'), z.literal('static_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoCountryState').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([
                    z.literal('ipgeocountry'),
                    z.literal('ipgeonotcountry'),
                    z.literal('ipgeostate'),
                    z.literal('ipgeonotstate'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  addr: z.string(),
                  condition_type: z.literal('IPGeoIn').optional(),
                  field: z.literal('ipgeo'),
                  lat: z.string(),
                  lng: z.string(),
                  op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoInZip').optional(),
                  extra: z.number(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeoinzip'),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoUnknown').optional(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeounknown'),
                }),
                z.object({
                  condition_type: z.literal('IPGeoZip').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialAge').optional(),
                  field: z.literal('social_age'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                }),
                z.object({
                  condition_type: z.literal('SocialGender').optional(),
                  field: z.literal('social_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('SocialInfluence').optional(),
                  field: z.literal('social_influence'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkMember').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.union([
                    z.literal('twitter'),
                    z.literal('facebook'),
                    z.literal('linkedin'),
                    z.literal('flickr'),
                    z.literal('foursquare'),
                    z.literal('lastfm'),
                    z.literal('myspace'),
                    z.literal('quora'),
                    z.literal('vimeo'),
                    z.literal('yelp'),
                    z.literal('youtube'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkFollow').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('follow'), z.literal('notfollow')]),
                  value: z.literal('twitter_follow'),
                }),
                z.object({
                  condition_type: z.literal('AddressMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('ZipMerge').optional(),
                  extra: z.string(),
                  field: z.string(),
                  op: z.literal('geoin'),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('BirthdayMerge').optional(),
                  field: z.string(),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('DateMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('greater'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SelectMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('notcontain'),
                    z.literal('contains'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('TextMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EmailAddress').optional(),
                  field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('PredictedGender').optional(),
                  field: z.literal('predicted_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('PredictedAge').optional(),
                  field: z.literal('predicted_age_range'),
                  op: z.literal('is'),
                  value: z.union([
                    z.literal('18-24'),
                    z.literal('25-34'),
                    z.literal('35-44'),
                    z.literal('45-54'),
                    z.literal('55-64'),
                    z.literal('65+'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('NewSubscribers').optional(),
                  field: z.literal('timestamp_opt').optional(),
                  op: z.literal('date_within').optional(),
                  value: z.string().optional(),
                }),
              ]),
            )
            .optional(),
          match: z.union([z.literal('any'), z.literal('all')]).optional(),
          prebuilt_segment_id: z.string().optional(),
          saved_segment_id: z.number().optional(),
        })
        .optional(),
      segment_text: z.string().optional(),
    })
    .optional(),
  report_summary: z
    .object({
      click_rate: z.number().optional(),
      clicks: z.number().optional(),
      open_rate: z.number().optional(),
      opens: z.number().optional(),
      subscriber_clicks: z.number().optional(),
      unique_opens: z.number().optional(),
    })
    .optional(),
  send_time: z.string().optional(),
  settings: z
    .object({
      authenticate: z.boolean().optional(),
      auto_fb_post: z.array(z.string()).optional(),
      auto_footer: z.boolean().optional(),
      auto_tweet: z.boolean().optional(),
      drag_and_drop: z.boolean().optional(),
      fb_comments: z.boolean().optional(),
      from_name: z.string().optional(),
      inline_css: z.boolean().optional(),
      preview_text: z.string().optional(),
      reply_to: z.string().optional(),
      subject_line: z.string().optional(),
      template_id: z.number().optional(),
      title: z.string().optional(),
    })
    .optional(),
  social_card: z
    .object({
      description: z.string().optional(),
      image_url: z.string().optional(),
      title: z.string().optional(),
    })
    .optional(),
  start_time: z.string().optional(),
  status: z.union([z.literal('save'), z.literal('paused'), z.literal('sending')]).optional(),
  tracking: z
    .object({
      capsule: z
        .object({
          notes: z.boolean().optional(),
        })
        .optional(),
      clicktale: z.string().optional(),
      ecomm360: z.boolean().optional(),
      goal_tracking: z.boolean().optional(),
      google_analytics: z.string().optional(),
      html_clicks: z.boolean().optional(),
      opens: z.boolean().optional(),
      salesforce: z
        .object({
          campaign: z.boolean().optional(),
          notes: z.boolean().optional(),
        })
        .optional(),
      text_clicks: z.boolean().optional(),
    })
    .optional(),
  trigger_settings: z
    .object({
      runtime: z
        .object({
          days: z
            .array(
              z.union([
                z.literal('sunday'),
                z.literal('monday'),
                z.literal('tuesday'),
                z.literal('wednesday'),
                z.literal('thursday'),
                z.literal('friday'),
                z.literal('saturday'),
              ]),
            )
            .optional(),
          hours: z
            .object({
              type: z.union([z.literal('send_asap'), z.literal('send_between'), z.literal('send_at')]),
            })
            .optional(),
        })
        .optional(),
      workflow_emails_count: z.number().optional(),
      workflow_title: z.string().optional(),
      workflow_type: z.union([
        z.literal('abandonedBrowse'),
        z.literal('abandonedCart'),
        z.literal('api'),
        z.literal('bestCustomers'),
        z.literal('categoryFollowup'),
        z.literal('dateAdded'),
        z.literal('emailFollowup'),
        z.literal('emailSeries'),
        z.literal('groupAdd'),
        z.literal('groupRemove'),
        z.literal('mandrill'),
        z.literal('productFollowup'),
        z.literal('purchaseFollowup'),
        z.literal('recurringEvent'),
        z.literal('specialEvent'),
        z.literal('visitUrl'),
        z.literal('welcomeSeries'),
      ]),
    })
    .optional(),
  web_id: z.number().optional(),
  workflow_id: z.string().optional(),
});

export const patchAutomationEmailWorkflowIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postAutomationsIdEmailsIdActionsPauseDataSchema = z.object({
  path: z.object({
    workflow_email_id: z.string(),
    workflow_id: z.string(),
  }),
});

export const postAutomationsIdEmailsIdActionsPauseResponseSchema = z.any();

export const postAutomationsIdEmailsIdActionsPauseErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postAutomationsIdEmailsIdActionsStartDataSchema = z.object({
  path: z.object({
    workflow_email_id: z.string(),
    workflow_id: z.string(),
  }),
});

export const postAutomationsIdEmailsIdActionsStartResponseSchema = z.any();

export const postAutomationsIdEmailsIdActionsStartErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getAutomationsIdEmailsIdQueueDataSchema = z.object({
  path: z.object({
    workflow_email_id: z.string(),
    workflow_id: z.string(),
  }),
});

export const getAutomationsIdEmailsIdQueueResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  email_id: z.string().optional(),
  queue: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        email_address: z.string(),
        email_id: z.string().optional(),
        id: z.string().optional(),
        list_id: z.string().optional(),
        next_send: z.string().optional(),
        workflow_id: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
  workflow_id: z.string().optional(),
});

export const getAutomationsIdEmailsIdQueueErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postAutomationsIdEmailsIdQueueDataSchema = z.object({
  body: z.object({
    email_address: z.string(),
  }),
  path: z.object({
    workflow_email_id: z.string(),
    workflow_id: z.string(),
  }),
});

export const postAutomationsIdEmailsIdQueueResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  email_address: z.string().optional(),
  email_id: z.string().optional(),
  id: z.string().optional(),
  list_id: z.string().optional(),
  list_is_active: z.boolean().optional(),
  next_send: z.string().optional(),
  workflow_id: z.string().optional(),
});

export const postAutomationsIdEmailsIdQueueErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getAutomationsIdEmailsIdQueueIdDataSchema = z.object({
  path: z.object({
    subscriber_hash: z.string(),
    workflow_email_id: z.string(),
    workflow_id: z.string(),
  }),
});

export const getAutomationsIdEmailsIdQueueIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  email_address: z.string().optional(),
  email_id: z.string().optional(),
  id: z.string().optional(),
  list_id: z.string().optional(),
  list_is_active: z.boolean().optional(),
  next_send: z.string().optional(),
  workflow_id: z.string().optional(),
});

export const getAutomationsIdEmailsIdQueueIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getAutomationsIdRemovedSubscribersDataSchema = z.object({
  path: z.object({
    workflow_id: z.string(),
  }),
});

export const getAutomationsIdRemovedSubscribersResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  subscribers: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        email_address: z.string().optional(),
        id: z.string().optional(),
        list_id: z.string().optional(),
        workflow_id: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
  workflow_id: z.string().optional(),
});

export const getAutomationsIdRemovedSubscribersErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postAutomationsIdRemovedSubscribersDataSchema = z.object({
  body: z.object({
    email_address: z.string(),
  }),
  path: z.object({
    workflow_id: z.string(),
  }),
});

export const postAutomationsIdRemovedSubscribersResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  email_address: z.string().optional(),
  id: z.string().optional(),
  list_id: z.string().optional(),
  workflow_id: z.string().optional(),
});

export const postAutomationsIdRemovedSubscribersErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getAutomationsIdRemovedSubscribersIdDataSchema = z.object({
  path: z.object({
    subscriber_hash: z.string(),
    workflow_id: z.string(),
  }),
});

export const getAutomationsIdRemovedSubscribersIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  email_address: z.string().optional(),
  id: z.string().optional(),
  list_id: z.string().optional(),
  workflow_id: z.string().optional(),
});

export const getAutomationsIdRemovedSubscribersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getBatchWebhooksDataSchema = z.object({
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getBatchWebhooksResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
  webhooks: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        enabled: z.boolean().optional(),
        id: z.string().optional(),
        url: z.string().optional(),
      }),
    )
    .optional(),
});

export const getBatchWebhooksErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postBatchWebhooksDataSchema = z.object({
  body: z.object({
    enabled: z.boolean().optional(),
    url: z.string(),
  }),
});

export const postBatchWebhooksResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  enabled: z.boolean().optional(),
  id: z.string().optional(),
  url: z.string().optional(),
});

export const postBatchWebhooksErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteBatchWebhookIdDataSchema = z.object({
  path: z.object({
    batch_webhook_id: z.string(),
  }),
});

export const deleteBatchWebhookIdResponseSchema = z.any();

export const deleteBatchWebhookIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getBatchWebhookDataSchema = z.object({
  path: z.object({
    batch_webhook_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getBatchWebhookResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  enabled: z.boolean().optional(),
  id: z.string().optional(),
  url: z.string().optional(),
});

export const getBatchWebhookErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchBatchWebhooksDataSchema = z.object({
  body: z.object({
    enabled: z.boolean().optional(),
    url: z.string().optional(),
  }),
  path: z.object({
    batch_webhook_id: z.string(),
  }),
});

export const patchBatchWebhooksResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  enabled: z.boolean().optional(),
  id: z.string().optional(),
  url: z.string().optional(),
});

export const patchBatchWebhooksErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getBatchesDataSchema = z.object({
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getBatchesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  batches: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        completed_at: z.string().optional(),
        errored_operations: z.number().optional(),
        finished_operations: z.number().optional(),
        id: z.string().optional(),
        response_body_url: z.string().optional(),
        status: z
          .union([
            z.literal('pending'),
            z.literal('preprocessing'),
            z.literal('started'),
            z.literal('finalizing'),
            z.literal('finished'),
          ])
          .optional(),
        submitted_at: z.string().optional(),
        total_operations: z.number().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getBatchesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postBatchesDataSchema = z.object({
  body: z.object({
    operations: z.array(
      z.object({
        body: z.string().optional(),
        method: z.union([
          z.literal('GET'),
          z.literal('POST'),
          z.literal('PUT'),
          z.literal('PATCH'),
          z.literal('DELETE'),
        ]),
        operation_id: z.string().optional(),
        params: z.record(z.unknown()).optional(),
        path: z.string(),
      }),
    ),
  }),
});

export const postBatchesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  completed_at: z.string().optional(),
  errored_operations: z.number().optional(),
  finished_operations: z.number().optional(),
  id: z.string().optional(),
  response_body_url: z.string().optional(),
  status: z
    .union([
      z.literal('pending'),
      z.literal('preprocessing'),
      z.literal('started'),
      z.literal('finalizing'),
      z.literal('finished'),
    ])
    .optional(),
  submitted_at: z.string().optional(),
  total_operations: z.number().optional(),
});

export const postBatchesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteBatchesIdDataSchema = z.object({
  path: z.object({
    batch_id: z.string(),
  }),
});

export const deleteBatchesIdResponseSchema = z.any();

export const deleteBatchesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getBatchesIdDataSchema = z.object({
  path: z.object({
    batch_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getBatchesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  completed_at: z.string().optional(),
  errored_operations: z.number().optional(),
  finished_operations: z.number().optional(),
  id: z.string().optional(),
  response_body_url: z.string().optional(),
  status: z
    .union([
      z.literal('pending'),
      z.literal('preprocessing'),
      z.literal('started'),
      z.literal('finalizing'),
      z.literal('finished'),
    ])
    .optional(),
  submitted_at: z.string().optional(),
  total_operations: z.number().optional(),
});

export const getBatchesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getCampaignFoldersDataSchema = z.object({
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getCampaignFoldersResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  folders: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        count: z.number().optional(),
        id: z.string().optional(),
        name: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getCampaignFoldersErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postCampaignFoldersDataSchema = z.object({
  body: z.object({
    name: z.string(),
  }),
});

export const postCampaignFoldersResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  count: z.number().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
});

export const postCampaignFoldersErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteCampaignFoldersIdDataSchema = z.object({
  path: z.object({
    folder_id: z.string(),
  }),
});

export const deleteCampaignFoldersIdResponseSchema = z.any();

export const deleteCampaignFoldersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getCampaignFoldersIdDataSchema = z.object({
  path: z.object({
    folder_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getCampaignFoldersIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  count: z.number().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
});

export const getCampaignFoldersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchCampaignFoldersIdDataSchema = z.object({
  body: z.object({
    name: z.string(),
  }),
  path: z.object({
    folder_id: z.string(),
  }),
});

export const patchCampaignFoldersIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  count: z.number().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
});

export const patchCampaignFoldersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getCampaignsDataSchema = z.object({
  query: z
    .object({
      before_create_time: z.string().optional(),
      before_send_time: z.string().optional(),
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      folder_id: z.string().optional(),
      list_id: z.string().optional(),
      member_id: z.string().optional(),
      offset: z.number().optional(),
      since_create_time: z.string().optional(),
      since_send_time: z.string().optional(),
      sort_dir: z.union([z.literal('ASC'), z.literal('DESC')]).optional(),
      sort_field: z.union([z.literal('create_time'), z.literal('send_time')]).optional(),
      status: z
        .union([z.literal('save'), z.literal('paused'), z.literal('schedule'), z.literal('sending'), z.literal('sent')])
        .optional(),
      type: z
        .union([
          z.literal('regular'),
          z.literal('plaintext'),
          z.literal('absplit'),
          z.literal('rss'),
          z.literal('variate'),
        ])
        .optional(),
    })
    .optional(),
});

export const getCampaignsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  campaigns: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        ab_split_opts: z
          .object({
            from_name_a: z.string().optional(),
            from_name_b: z.string().optional(),
            pick_winner: z.union([z.literal('opens'), z.literal('clicks'), z.literal('manual')]).optional(),
            reply_email_a: z.string().optional(),
            reply_email_b: z.string().optional(),
            send_time_a: z.string().optional(),
            send_time_b: z.string().optional(),
            send_time_winner: z.string().optional(),
            split_size: z.number().optional(),
            split_test: z.union([z.literal('subject'), z.literal('from_name'), z.literal('schedule')]).optional(),
            subject_a: z.string().optional(),
            subject_b: z.string().optional(),
            wait_time: z.number().optional(),
            wait_units: z.union([z.literal('hours'), z.literal('days')]).optional(),
          })
          .optional(),
        archive_url: z.string().optional(),
        content_type: z
          .union([z.literal('template'), z.literal('html'), z.literal('url'), z.literal('multichannel')])
          .optional(),
        create_time: z.string().optional(),
        delivery_status: z
          .object({
            can_cancel: z.boolean().optional(),
            emails_canceled: z.number().optional(),
            emails_sent: z.number().optional(),
            enabled: z.boolean().optional(),
            status: z
              .union([z.literal('delivering'), z.literal('delivered'), z.literal('canceling'), z.literal('canceled')])
              .optional(),
          })
          .optional(),
        emails_sent: z.number().optional(),
        id: z.string().optional(),
        long_archive_url: z.string().optional(),
        needs_block_refresh: z.boolean().optional(),
        parent_campaign_id: z.string().optional(),
        recipients: z
          .object({
            list_id: z.string().optional(),
            list_is_active: z.boolean().optional(),
            list_name: z.string().optional(),
            recipient_count: z.number().optional(),
            segment_opts: z
              .object({
                conditions: z
                  .array(
                    z.union([
                      z.object({
                        condition_type: z.literal('Aim').optional(),
                        field: z.literal('aim').optional(),
                        op: z
                          .union([
                            z.literal('open'),
                            z.literal('click'),
                            z.literal('sent'),
                            z.literal('noopen'),
                            z.literal('noclick'),
                            z.literal('nosent'),
                          ])
                          .optional(),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('Automation').optional(),
                        field: z.literal('automation'),
                        op: z.union([
                          z.literal('started'),
                          z.literal('completed'),
                          z.literal('not_started'),
                          z.literal('not_completed'),
                        ]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('CampaignPoll').optional(),
                        field: z.literal('poll'),
                        op: z.union([z.literal('member'), z.literal('notmember')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('Conversation').optional(),
                        field: z.literal('conversation'),
                        op: z.union([z.literal('member'), z.literal('notmember')]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('Date').optional(),
                        extra: z.string().optional(),
                        field: z.union([
                          z.literal('timestamp_opt'),
                          z.literal('info_changed'),
                          z.literal('ecomm_date'),
                        ]),
                        op: z.union([
                          z.literal('greater'),
                          z.literal('less'),
                          z.literal('is'),
                          z.literal('not'),
                          z.literal('blank'),
                          z.literal('blank_not'),
                          z.literal('within'),
                          z.literal('notwithin'),
                        ]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('EmailClient').optional(),
                        field: z.literal('email_client'),
                        op: z.union([z.literal('client_is'), z.literal('client_not')]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('Language').optional(),
                        field: z.literal('language'),
                        op: z.union([z.literal('is'), z.literal('not')]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('MemberRating').optional(),
                        field: z.literal('rating'),
                        op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('SignupSource'),
                        field: z.literal('source'),
                        op: z.union([z.literal('source_is'), z.literal('source_not')]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('SurveyMonkey').optional(),
                        field: z.literal('survey_monkey'),
                        op: z.union([
                          z.literal('started'),
                          z.literal('completed'),
                          z.literal('not_started'),
                          z.literal('not_completed'),
                        ]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('VIP').optional(),
                        field: z.literal('gmonkey'),
                        op: z.union([z.literal('member'), z.literal('notmember')]),
                      }),
                      z.object({
                        condition_type: z.literal('Interests').optional(),
                        field: z.string().optional(),
                        op: z
                          .union([
                            z.literal('interestcontains'),
                            z.literal('interestcontainsall'),
                            z.literal('interestnotcontains'),
                          ])
                          .optional(),
                        value: z.array(z.string()).optional(),
                      }),
                      z.object({
                        condition_type: z.literal('EcommCategory').optional(),
                        field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                        op: z
                          .union([
                            z.literal('is'),
                            z.literal('not'),
                            z.literal('contains'),
                            z.literal('notcontain'),
                            z.literal('starts'),
                            z.literal('ends'),
                          ])
                          .optional(),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('EcommNumber').optional(),
                        field: z.union([
                          z.literal('ecomm_spent_avg'),
                          z.literal('ecomm_orders'),
                          z.literal('ecomm_prod_all'),
                          z.literal('ecomm_avg_ord'),
                        ]),
                        op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('EcommPurchased').optional(),
                        field: z.literal('ecomm_purchased').optional(),
                        op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                      }),
                      z.object({
                        condition_type: z.literal('EcommSpent').optional(),
                        field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                        op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                        value: z.number().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('EcommStore').optional(),
                        field: z.literal('ecomm_store').optional(),
                        op: z.union([z.literal('is'), z.literal('not')]).optional(),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('GoalActivity').optional(),
                        field: z.literal('goal'),
                        op: z.union([
                          z.literal('is'),
                          z.literal('goal_not'),
                          z.literal('contains'),
                          z.literal('goal_notcontain'),
                          z.literal('starts'),
                          z.literal('ends'),
                        ]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('GoalTimestamp').optional(),
                        field: z.literal('goal_last_visited'),
                        op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('FuzzySegment').optional(),
                        field: z.literal('fuzzy_segment'),
                        op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('StaticSegment').optional(),
                        field: z.literal('static_segment'),
                        op: z.union([z.literal('static_is'), z.literal('static_not')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('IPGeoCountryState').optional(),
                        field: z.literal('ipgeo'),
                        op: z.union([
                          z.literal('ipgeocountry'),
                          z.literal('ipgeonotcountry'),
                          z.literal('ipgeostate'),
                          z.literal('ipgeonotstate'),
                        ]),
                        value: z.string(),
                      }),
                      z.object({
                        addr: z.string(),
                        condition_type: z.literal('IPGeoIn').optional(),
                        field: z.literal('ipgeo'),
                        lat: z.string(),
                        lng: z.string(),
                        op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('IPGeoInZip').optional(),
                        extra: z.number(),
                        field: z.literal('ipgeo'),
                        op: z.literal('ipgeoinzip'),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('IPGeoUnknown').optional(),
                        field: z.literal('ipgeo'),
                        op: z.literal('ipgeounknown'),
                      }),
                      z.object({
                        condition_type: z.literal('IPGeoZip').optional(),
                        field: z.literal('ipgeo'),
                        op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('SocialAge').optional(),
                        field: z.literal('social_age'),
                        op: z.union([z.literal('is'), z.literal('not')]),
                        value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                      }),
                      z.object({
                        condition_type: z.literal('SocialGender').optional(),
                        field: z.literal('social_gender'),
                        op: z.union([z.literal('is'), z.literal('not')]),
                        value: z.union([z.literal('male'), z.literal('female')]),
                      }),
                      z.object({
                        condition_type: z.literal('SocialInfluence').optional(),
                        field: z.literal('social_influence'),
                        op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                        value: z.number(),
                      }),
                      z.object({
                        condition_type: z.literal('SocialNetworkMember').optional(),
                        field: z.literal('social_network'),
                        op: z.union([z.literal('member'), z.literal('notmember')]),
                        value: z.union([
                          z.literal('twitter'),
                          z.literal('facebook'),
                          z.literal('linkedin'),
                          z.literal('flickr'),
                          z.literal('foursquare'),
                          z.literal('lastfm'),
                          z.literal('myspace'),
                          z.literal('quora'),
                          z.literal('vimeo'),
                          z.literal('yelp'),
                          z.literal('youtube'),
                        ]),
                      }),
                      z.object({
                        condition_type: z.literal('SocialNetworkFollow').optional(),
                        field: z.literal('social_network'),
                        op: z.union([z.literal('follow'), z.literal('notfollow')]),
                        value: z.literal('twitter_follow'),
                      }),
                      z.object({
                        condition_type: z.literal('AddressMerge').optional(),
                        field: z.string(),
                        op: z.union([
                          z.literal('contains'),
                          z.literal('notcontain'),
                          z.literal('blank'),
                          z.literal('blank_not'),
                        ]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('ZipMerge').optional(),
                        extra: z.string(),
                        field: z.string(),
                        op: z.literal('geoin'),
                        value: z.string(),
                      }),
                      z.object({
                        condition_type: z.literal('BirthdayMerge').optional(),
                        field: z.string(),
                        op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('DateMerge').optional(),
                        field: z.string(),
                        op: z.union([
                          z.literal('is'),
                          z.literal('not'),
                          z.literal('less'),
                          z.literal('blank'),
                          z.literal('blank_not'),
                          z.literal('greater'),
                        ]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('SelectMerge').optional(),
                        field: z.string(),
                        op: z.union([
                          z.literal('is'),
                          z.literal('not'),
                          z.literal('blank'),
                          z.literal('blank_not'),
                          z.literal('notcontain'),
                          z.literal('contains'),
                        ]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('TextMerge').optional(),
                        field: z.string(),
                        op: z.union([
                          z.literal('is'),
                          z.literal('not'),
                          z.literal('contains'),
                          z.literal('notcontain'),
                          z.literal('starts'),
                          z.literal('ends'),
                          z.literal('greater'),
                          z.literal('less'),
                          z.literal('blank'),
                          z.literal('blank_not'),
                        ]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('EmailAddress').optional(),
                        field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                        op: z.union([
                          z.literal('is'),
                          z.literal('not'),
                          z.literal('contains'),
                          z.literal('notcontain'),
                          z.literal('starts'),
                          z.literal('ends'),
                          z.literal('greater'),
                          z.literal('less'),
                        ]),
                        value: z.string().optional(),
                      }),
                      z.object({
                        condition_type: z.literal('PredictedGender').optional(),
                        field: z.literal('predicted_gender'),
                        op: z.union([z.literal('is'), z.literal('not')]),
                        value: z.union([z.literal('male'), z.literal('female')]),
                      }),
                      z.object({
                        condition_type: z.literal('PredictedAge').optional(),
                        field: z.literal('predicted_age_range'),
                        op: z.literal('is'),
                        value: z.union([
                          z.literal('18-24'),
                          z.literal('25-34'),
                          z.literal('35-44'),
                          z.literal('45-54'),
                          z.literal('55-64'),
                          z.literal('65+'),
                        ]),
                      }),
                      z.object({
                        condition_type: z.literal('NewSubscribers').optional(),
                        field: z.literal('timestamp_opt').optional(),
                        op: z.literal('date_within').optional(),
                        value: z.string().optional(),
                      }),
                    ]),
                  )
                  .optional(),
                match: z.union([z.literal('any'), z.literal('all')]).optional(),
                prebuilt_segment_id: z.string().optional(),
                saved_segment_id: z.number().optional(),
              })
              .optional(),
            segment_text: z.string().optional(),
          })
          .optional(),
        report_summary: z
          .object({
            click_rate: z.number().optional(),
            clicks: z.number().optional(),
            ecommerce: z
              .object({
                total_orders: z.number().optional(),
                total_revenue: z.number().optional(),
                total_spent: z.number().optional(),
              })
              .optional(),
            open_rate: z.number().optional(),
            opens: z.number().optional(),
            subscriber_clicks: z.number().optional(),
            unique_opens: z.number().optional(),
          })
          .optional(),
        resendable: z.boolean().optional(),
        rss_opts: z
          .object({
            constrain_rss_img: z.boolean().optional(),
            feed_url: z.string().optional(),
            frequency: z.union([z.literal('daily'), z.literal('weekly'), z.literal('monthly')]).optional(),
            last_sent: z.string().optional(),
            schedule: z
              .object({
                daily_send: z
                  .object({
                    friday: z.boolean().optional(),
                    monday: z.boolean().optional(),
                    saturday: z.boolean().optional(),
                    sunday: z.boolean().optional(),
                    thursday: z.boolean().optional(),
                    tuesday: z.boolean().optional(),
                    wednesday: z.boolean().optional(),
                  })
                  .optional(),
                hour: z.number().optional(),
                monthly_send_date: z.number().optional(),
                weekly_send_day: z
                  .union([
                    z.literal('sunday'),
                    z.literal('monday'),
                    z.literal('tuesday'),
                    z.literal('wednesday'),
                    z.literal('thursday'),
                    z.literal('friday'),
                    z.literal('saturday'),
                  ])
                  .optional(),
              })
              .optional(),
          })
          .optional(),
        send_time: z.string().optional(),
        settings: z
          .object({
            authenticate: z.boolean().optional(),
            auto_fb_post: z.array(z.string()).optional(),
            auto_footer: z.boolean().optional(),
            auto_tweet: z.boolean().optional(),
            drag_and_drop: z.boolean().optional(),
            fb_comments: z.boolean().optional(),
            folder_id: z.string().optional(),
            from_name: z.string().optional(),
            inline_css: z.boolean().optional(),
            preview_text: z.string().optional(),
            reply_to: z.string().optional(),
            subject_line: z.string().optional(),
            template_id: z.number().optional(),
            timewarp: z.boolean().optional(),
            title: z.string().optional(),
            to_name: z.string().optional(),
            use_conversation: z.boolean().optional(),
          })
          .optional(),
        social_card: z
          .object({
            description: z.string().optional(),
            image_url: z.string().optional(),
            title: z.string().optional(),
          })
          .optional(),
        status: z
          .union([
            z.literal('save'),
            z.literal('paused'),
            z.literal('schedule'),
            z.literal('sending'),
            z.literal('sent'),
            z.literal('canceled'),
            z.literal('canceling'),
            z.literal('archived'),
          ])
          .optional(),
        tracking: z
          .object({
            capsule: z
              .object({
                notes: z.boolean().optional(),
              })
              .optional(),
            clicktale: z.string().optional(),
            ecomm360: z.boolean().optional(),
            goal_tracking: z.boolean().optional(),
            google_analytics: z.string().optional(),
            html_clicks: z.boolean().optional(),
            opens: z.boolean().optional(),
            salesforce: z
              .object({
                campaign: z.boolean().optional(),
                notes: z.boolean().optional(),
              })
              .optional(),
            text_clicks: z.boolean().optional(),
          })
          .optional(),
        type: z
          .union([
            z.literal('regular'),
            z.literal('plaintext'),
            z.literal('absplit'),
            z.literal('rss'),
            z.literal('variate'),
          ])
          .optional(),
        variate_settings: z
          .object({
            combinations: z
              .array(
                z.object({
                  content_description: z.number().optional(),
                  from_name: z.number().optional(),
                  id: z.string().optional(),
                  recipients: z.number().optional(),
                  reply_to: z.number().optional(),
                  send_time: z.number().optional(),
                  subject_line: z.number().optional(),
                }),
              )
              .optional(),
            contents: z.array(z.string()).optional(),
            from_names: z.array(z.string()).optional(),
            reply_to_addresses: z.array(z.string()).optional(),
            send_times: z.array(z.string()).optional(),
            subject_lines: z.array(z.string()).optional(),
            test_size: z.number().optional(),
            wait_time: z.number().optional(),
            winner_criteria: z
              .union([z.literal('opens'), z.literal('clicks'), z.literal('manual'), z.literal('total_revenue')])
              .optional(),
            winning_campaign_id: z.string().optional(),
            winning_combination_id: z.string().optional(),
          })
          .optional(),
        web_id: z.number().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getCampaignsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postCampaignsDataSchema = z.object({
  body: z.object({
    content_type: z.union([z.literal('template'), z.literal('multichannel')]).optional(),
    recipients: z
      .object({
        list_id: z.string(),
        segment_opts: z
          .object({
            conditions: z
              .array(
                z.union([
                  z.object({
                    condition_type: z.literal('Aim').optional(),
                    field: z.literal('aim').optional(),
                    op: z
                      .union([
                        z.literal('open'),
                        z.literal('click'),
                        z.literal('sent'),
                        z.literal('noopen'),
                        z.literal('noclick'),
                        z.literal('nosent'),
                      ])
                      .optional(),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('Automation').optional(),
                    field: z.literal('automation'),
                    op: z.union([
                      z.literal('started'),
                      z.literal('completed'),
                      z.literal('not_started'),
                      z.literal('not_completed'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('CampaignPoll').optional(),
                    field: z.literal('poll'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('Conversation').optional(),
                    field: z.literal('conversation'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('Date').optional(),
                    extra: z.string().optional(),
                    field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
                    op: z.union([
                      z.literal('greater'),
                      z.literal('less'),
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                      z.literal('within'),
                      z.literal('notwithin'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('EmailClient').optional(),
                    field: z.literal('email_client'),
                    op: z.union([z.literal('client_is'), z.literal('client_not')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('Language').optional(),
                    field: z.literal('language'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('MemberRating').optional(),
                    field: z.literal('rating'),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('SignupSource'),
                    field: z.literal('source'),
                    op: z.union([z.literal('source_is'), z.literal('source_not')]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('SurveyMonkey').optional(),
                    field: z.literal('survey_monkey'),
                    op: z.union([
                      z.literal('started'),
                      z.literal('completed'),
                      z.literal('not_started'),
                      z.literal('not_completed'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('VIP').optional(),
                    field: z.literal('gmonkey'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                  }),
                  z.object({
                    condition_type: z.literal('Interests').optional(),
                    field: z.string().optional(),
                    op: z
                      .union([
                        z.literal('interestcontains'),
                        z.literal('interestcontainsall'),
                        z.literal('interestnotcontains'),
                      ])
                      .optional(),
                    value: z.array(z.string()).optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommCategory').optional(),
                    field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                    op: z
                      .union([
                        z.literal('is'),
                        z.literal('not'),
                        z.literal('contains'),
                        z.literal('notcontain'),
                        z.literal('starts'),
                        z.literal('ends'),
                      ])
                      .optional(),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommNumber').optional(),
                    field: z.union([
                      z.literal('ecomm_spent_avg'),
                      z.literal('ecomm_orders'),
                      z.literal('ecomm_prod_all'),
                      z.literal('ecomm_avg_ord'),
                    ]),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommPurchased').optional(),
                    field: z.literal('ecomm_purchased').optional(),
                    op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommSpent').optional(),
                    field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                    op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                    value: z.number().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommStore').optional(),
                    field: z.literal('ecomm_store').optional(),
                    op: z.union([z.literal('is'), z.literal('not')]).optional(),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('GoalActivity').optional(),
                    field: z.literal('goal'),
                    op: z.union([
                      z.literal('is'),
                      z.literal('goal_not'),
                      z.literal('contains'),
                      z.literal('goal_notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('GoalTimestamp').optional(),
                    field: z.literal('goal_last_visited'),
                    op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('FuzzySegment').optional(),
                    field: z.literal('fuzzy_segment'),
                    op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('StaticSegment').optional(),
                    field: z.literal('static_segment'),
                    op: z.union([z.literal('static_is'), z.literal('static_not')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoCountryState').optional(),
                    field: z.literal('ipgeo'),
                    op: z.union([
                      z.literal('ipgeocountry'),
                      z.literal('ipgeonotcountry'),
                      z.literal('ipgeostate'),
                      z.literal('ipgeonotstate'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    addr: z.string(),
                    condition_type: z.literal('IPGeoIn').optional(),
                    field: z.literal('ipgeo'),
                    lat: z.string(),
                    lng: z.string(),
                    op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoInZip').optional(),
                    extra: z.number(),
                    field: z.literal('ipgeo'),
                    op: z.literal('ipgeoinzip'),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoUnknown').optional(),
                    field: z.literal('ipgeo'),
                    op: z.literal('ipgeounknown'),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoZip').optional(),
                    field: z.literal('ipgeo'),
                    op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('SocialAge').optional(),
                    field: z.literal('social_age'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                  }),
                  z.object({
                    condition_type: z.literal('SocialGender').optional(),
                    field: z.literal('social_gender'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.union([z.literal('male'), z.literal('female')]),
                  }),
                  z.object({
                    condition_type: z.literal('SocialInfluence').optional(),
                    field: z.literal('social_influence'),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('SocialNetworkMember').optional(),
                    field: z.literal('social_network'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                    value: z.union([
                      z.literal('twitter'),
                      z.literal('facebook'),
                      z.literal('linkedin'),
                      z.literal('flickr'),
                      z.literal('foursquare'),
                      z.literal('lastfm'),
                      z.literal('myspace'),
                      z.literal('quora'),
                      z.literal('vimeo'),
                      z.literal('yelp'),
                      z.literal('youtube'),
                    ]),
                  }),
                  z.object({
                    condition_type: z.literal('SocialNetworkFollow').optional(),
                    field: z.literal('social_network'),
                    op: z.union([z.literal('follow'), z.literal('notfollow')]),
                    value: z.literal('twitter_follow'),
                  }),
                  z.object({
                    condition_type: z.literal('AddressMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('ZipMerge').optional(),
                    extra: z.string(),
                    field: z.string(),
                    op: z.literal('geoin'),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('BirthdayMerge').optional(),
                    field: z.string(),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('DateMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('less'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                      z.literal('greater'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('SelectMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                      z.literal('notcontain'),
                      z.literal('contains'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('TextMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                      z.literal('greater'),
                      z.literal('less'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EmailAddress').optional(),
                    field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                      z.literal('greater'),
                      z.literal('less'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('PredictedGender').optional(),
                    field: z.literal('predicted_gender'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.union([z.literal('male'), z.literal('female')]),
                  }),
                  z.object({
                    condition_type: z.literal('PredictedAge').optional(),
                    field: z.literal('predicted_age_range'),
                    op: z.literal('is'),
                    value: z.union([
                      z.literal('18-24'),
                      z.literal('25-34'),
                      z.literal('35-44'),
                      z.literal('45-54'),
                      z.literal('55-64'),
                      z.literal('65+'),
                    ]),
                  }),
                  z.object({
                    condition_type: z.literal('NewSubscribers').optional(),
                    field: z.literal('timestamp_opt').optional(),
                    op: z.literal('date_within').optional(),
                    value: z.string().optional(),
                  }),
                ]),
              )
              .optional(),
            match: z.union([z.literal('any'), z.literal('all')]).optional(),
            saved_segment_id: z.number().optional(),
          })
          .optional(),
      })
      .optional(),
    rss_opts: z
      .object({
        constrain_rss_img: z.boolean().optional(),
        feed_url: z.string(),
        frequency: z.union([z.literal('daily'), z.literal('weekly'), z.literal('monthly')]),
        schedule: z
          .object({
            daily_send: z
              .object({
                friday: z.boolean().optional(),
                monday: z.boolean().optional(),
                saturday: z.boolean().optional(),
                sunday: z.boolean().optional(),
                thursday: z.boolean().optional(),
                tuesday: z.boolean().optional(),
                wednesday: z.boolean().optional(),
              })
              .optional(),
            hour: z.number().optional(),
            monthly_send_date: z.number().optional(),
            weekly_send_day: z
              .union([
                z.literal('sunday'),
                z.literal('monday'),
                z.literal('tuesday'),
                z.literal('wednesday'),
                z.literal('thursday'),
                z.literal('friday'),
                z.literal('saturday'),
              ])
              .optional(),
          })
          .optional(),
      })
      .optional(),
    settings: z
      .object({
        authenticate: z.boolean().optional(),
        auto_fb_post: z.array(z.string()).optional(),
        auto_footer: z.boolean().optional(),
        auto_tweet: z.boolean().optional(),
        fb_comments: z.boolean().optional(),
        folder_id: z.string().optional(),
        from_name: z.string().optional(),
        inline_css: z.boolean().optional(),
        preview_text: z.string().optional(),
        reply_to: z.string().optional(),
        subject_line: z.string().optional(),
        template_id: z.number().optional(),
        title: z.string().optional(),
        to_name: z.string().optional(),
        use_conversation: z.boolean().optional(),
      })
      .optional(),
    social_card: z
      .object({
        description: z.string().optional(),
        image_url: z.string().optional(),
        title: z.string().optional(),
      })
      .optional(),
    tracking: z
      .object({
        capsule: z
          .object({
            notes: z.boolean().optional(),
          })
          .optional(),
        clicktale: z.string().optional(),
        ecomm360: z.boolean().optional(),
        goal_tracking: z.boolean().optional(),
        google_analytics: z.string().optional(),
        html_clicks: z.boolean().optional(),
        opens: z.boolean().optional(),
        salesforce: z
          .object({
            campaign: z.boolean().optional(),
            notes: z.boolean().optional(),
          })
          .optional(),
        text_clicks: z.boolean().optional(),
      })
      .optional(),
    type: z.union([
      z.literal('regular'),
      z.literal('plaintext'),
      z.literal('absplit'),
      z.literal('rss'),
      z.literal('variate'),
    ]),
    variate_settings: z
      .object({
        from_names: z.array(z.string()).optional(),
        reply_to_addresses: z.array(z.string()).optional(),
        send_times: z.array(z.string()).optional(),
        subject_lines: z.array(z.string()).optional(),
        test_size: z.number().optional(),
        wait_time: z.number().optional(),
        winner_criteria: z.union([
          z.literal('opens'),
          z.literal('clicks'),
          z.literal('manual'),
          z.literal('total_revenue'),
        ]),
      })
      .optional(),
  }),
});

export const postCampaignsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  ab_split_opts: z
    .object({
      from_name_a: z.string().optional(),
      from_name_b: z.string().optional(),
      pick_winner: z.union([z.literal('opens'), z.literal('clicks'), z.literal('manual')]).optional(),
      reply_email_a: z.string().optional(),
      reply_email_b: z.string().optional(),
      send_time_a: z.string().optional(),
      send_time_b: z.string().optional(),
      send_time_winner: z.string().optional(),
      split_size: z.number().optional(),
      split_test: z.union([z.literal('subject'), z.literal('from_name'), z.literal('schedule')]).optional(),
      subject_a: z.string().optional(),
      subject_b: z.string().optional(),
      wait_time: z.number().optional(),
      wait_units: z.union([z.literal('hours'), z.literal('days')]).optional(),
    })
    .optional(),
  archive_url: z.string().optional(),
  content_type: z
    .union([z.literal('template'), z.literal('html'), z.literal('url'), z.literal('multichannel')])
    .optional(),
  create_time: z.string().optional(),
  delivery_status: z
    .object({
      can_cancel: z.boolean().optional(),
      emails_canceled: z.number().optional(),
      emails_sent: z.number().optional(),
      enabled: z.boolean().optional(),
      status: z
        .union([z.literal('delivering'), z.literal('delivered'), z.literal('canceling'), z.literal('canceled')])
        .optional(),
    })
    .optional(),
  emails_sent: z.number().optional(),
  id: z.string().optional(),
  long_archive_url: z.string().optional(),
  needs_block_refresh: z.boolean().optional(),
  parent_campaign_id: z.string().optional(),
  recipients: z
    .object({
      list_id: z.string().optional(),
      list_is_active: z.boolean().optional(),
      list_name: z.string().optional(),
      recipient_count: z.number().optional(),
      segment_opts: z
        .object({
          conditions: z
            .array(
              z.union([
                z.object({
                  condition_type: z.literal('Aim').optional(),
                  field: z.literal('aim').optional(),
                  op: z
                    .union([
                      z.literal('open'),
                      z.literal('click'),
                      z.literal('sent'),
                      z.literal('noopen'),
                      z.literal('noclick'),
                      z.literal('nosent'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('Automation').optional(),
                  field: z.literal('automation'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('CampaignPoll').optional(),
                  field: z.literal('poll'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('Conversation').optional(),
                  field: z.literal('conversation'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Date').optional(),
                  extra: z.string().optional(),
                  field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
                  op: z.union([
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('within'),
                    z.literal('notwithin'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('EmailClient').optional(),
                  field: z.literal('email_client'),
                  op: z.union([z.literal('client_is'), z.literal('client_not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Language').optional(),
                  field: z.literal('language'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('MemberRating').optional(),
                  field: z.literal('rating'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SignupSource'),
                  field: z.literal('source'),
                  op: z.union([z.literal('source_is'), z.literal('source_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SurveyMonkey').optional(),
                  field: z.literal('survey_monkey'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('VIP').optional(),
                  field: z.literal('gmonkey'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                }),
                z.object({
                  condition_type: z.literal('Interests').optional(),
                  field: z.string().optional(),
                  op: z
                    .union([
                      z.literal('interestcontains'),
                      z.literal('interestcontainsall'),
                      z.literal('interestnotcontains'),
                    ])
                    .optional(),
                  value: z.array(z.string()).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommCategory').optional(),
                  field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                  op: z
                    .union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommNumber').optional(),
                  field: z.union([
                    z.literal('ecomm_spent_avg'),
                    z.literal('ecomm_orders'),
                    z.literal('ecomm_prod_all'),
                    z.literal('ecomm_avg_ord'),
                  ]),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('EcommPurchased').optional(),
                  field: z.literal('ecomm_purchased').optional(),
                  op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommSpent').optional(),
                  field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                  op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                  value: z.number().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommStore').optional(),
                  field: z.literal('ecomm_store').optional(),
                  op: z.union([z.literal('is'), z.literal('not')]).optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('GoalActivity').optional(),
                  field: z.literal('goal'),
                  op: z.union([
                    z.literal('is'),
                    z.literal('goal_not'),
                    z.literal('contains'),
                    z.literal('goal_notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('GoalTimestamp').optional(),
                  field: z.literal('goal_last_visited'),
                  op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('FuzzySegment').optional(),
                  field: z.literal('fuzzy_segment'),
                  op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('StaticSegment').optional(),
                  field: z.literal('static_segment'),
                  op: z.union([z.literal('static_is'), z.literal('static_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoCountryState').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([
                    z.literal('ipgeocountry'),
                    z.literal('ipgeonotcountry'),
                    z.literal('ipgeostate'),
                    z.literal('ipgeonotstate'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  addr: z.string(),
                  condition_type: z.literal('IPGeoIn').optional(),
                  field: z.literal('ipgeo'),
                  lat: z.string(),
                  lng: z.string(),
                  op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoInZip').optional(),
                  extra: z.number(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeoinzip'),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoUnknown').optional(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeounknown'),
                }),
                z.object({
                  condition_type: z.literal('IPGeoZip').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialAge').optional(),
                  field: z.literal('social_age'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                }),
                z.object({
                  condition_type: z.literal('SocialGender').optional(),
                  field: z.literal('social_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('SocialInfluence').optional(),
                  field: z.literal('social_influence'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkMember').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.union([
                    z.literal('twitter'),
                    z.literal('facebook'),
                    z.literal('linkedin'),
                    z.literal('flickr'),
                    z.literal('foursquare'),
                    z.literal('lastfm'),
                    z.literal('myspace'),
                    z.literal('quora'),
                    z.literal('vimeo'),
                    z.literal('yelp'),
                    z.literal('youtube'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkFollow').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('follow'), z.literal('notfollow')]),
                  value: z.literal('twitter_follow'),
                }),
                z.object({
                  condition_type: z.literal('AddressMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('ZipMerge').optional(),
                  extra: z.string(),
                  field: z.string(),
                  op: z.literal('geoin'),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('BirthdayMerge').optional(),
                  field: z.string(),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('DateMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('greater'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SelectMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('notcontain'),
                    z.literal('contains'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('TextMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EmailAddress').optional(),
                  field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('PredictedGender').optional(),
                  field: z.literal('predicted_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('PredictedAge').optional(),
                  field: z.literal('predicted_age_range'),
                  op: z.literal('is'),
                  value: z.union([
                    z.literal('18-24'),
                    z.literal('25-34'),
                    z.literal('35-44'),
                    z.literal('45-54'),
                    z.literal('55-64'),
                    z.literal('65+'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('NewSubscribers').optional(),
                  field: z.literal('timestamp_opt').optional(),
                  op: z.literal('date_within').optional(),
                  value: z.string().optional(),
                }),
              ]),
            )
            .optional(),
          match: z.union([z.literal('any'), z.literal('all')]).optional(),
          prebuilt_segment_id: z.string().optional(),
          saved_segment_id: z.number().optional(),
        })
        .optional(),
      segment_text: z.string().optional(),
    })
    .optional(),
  report_summary: z
    .object({
      click_rate: z.number().optional(),
      clicks: z.number().optional(),
      ecommerce: z
        .object({
          total_orders: z.number().optional(),
          total_revenue: z.number().optional(),
          total_spent: z.number().optional(),
        })
        .optional(),
      open_rate: z.number().optional(),
      opens: z.number().optional(),
      subscriber_clicks: z.number().optional(),
      unique_opens: z.number().optional(),
    })
    .optional(),
  resendable: z.boolean().optional(),
  rss_opts: z
    .object({
      constrain_rss_img: z.boolean().optional(),
      feed_url: z.string().optional(),
      frequency: z.union([z.literal('daily'), z.literal('weekly'), z.literal('monthly')]).optional(),
      last_sent: z.string().optional(),
      schedule: z
        .object({
          daily_send: z
            .object({
              friday: z.boolean().optional(),
              monday: z.boolean().optional(),
              saturday: z.boolean().optional(),
              sunday: z.boolean().optional(),
              thursday: z.boolean().optional(),
              tuesday: z.boolean().optional(),
              wednesday: z.boolean().optional(),
            })
            .optional(),
          hour: z.number().optional(),
          monthly_send_date: z.number().optional(),
          weekly_send_day: z
            .union([
              z.literal('sunday'),
              z.literal('monday'),
              z.literal('tuesday'),
              z.literal('wednesday'),
              z.literal('thursday'),
              z.literal('friday'),
              z.literal('saturday'),
            ])
            .optional(),
        })
        .optional(),
    })
    .optional(),
  send_time: z.string().optional(),
  settings: z
    .object({
      authenticate: z.boolean().optional(),
      auto_fb_post: z.array(z.string()).optional(),
      auto_footer: z.boolean().optional(),
      auto_tweet: z.boolean().optional(),
      drag_and_drop: z.boolean().optional(),
      fb_comments: z.boolean().optional(),
      folder_id: z.string().optional(),
      from_name: z.string().optional(),
      inline_css: z.boolean().optional(),
      preview_text: z.string().optional(),
      reply_to: z.string().optional(),
      subject_line: z.string().optional(),
      template_id: z.number().optional(),
      timewarp: z.boolean().optional(),
      title: z.string().optional(),
      to_name: z.string().optional(),
      use_conversation: z.boolean().optional(),
    })
    .optional(),
  social_card: z
    .object({
      description: z.string().optional(),
      image_url: z.string().optional(),
      title: z.string().optional(),
    })
    .optional(),
  status: z
    .union([
      z.literal('save'),
      z.literal('paused'),
      z.literal('schedule'),
      z.literal('sending'),
      z.literal('sent'),
      z.literal('canceled'),
      z.literal('canceling'),
      z.literal('archived'),
    ])
    .optional(),
  tracking: z
    .object({
      capsule: z
        .object({
          notes: z.boolean().optional(),
        })
        .optional(),
      clicktale: z.string().optional(),
      ecomm360: z.boolean().optional(),
      goal_tracking: z.boolean().optional(),
      google_analytics: z.string().optional(),
      html_clicks: z.boolean().optional(),
      opens: z.boolean().optional(),
      salesforce: z
        .object({
          campaign: z.boolean().optional(),
          notes: z.boolean().optional(),
        })
        .optional(),
      text_clicks: z.boolean().optional(),
    })
    .optional(),
  type: z
    .union([z.literal('regular'), z.literal('plaintext'), z.literal('absplit'), z.literal('rss'), z.literal('variate')])
    .optional(),
  variate_settings: z
    .object({
      combinations: z
        .array(
          z.object({
            content_description: z.number().optional(),
            from_name: z.number().optional(),
            id: z.string().optional(),
            recipients: z.number().optional(),
            reply_to: z.number().optional(),
            send_time: z.number().optional(),
            subject_line: z.number().optional(),
          }),
        )
        .optional(),
      contents: z.array(z.string()).optional(),
      from_names: z.array(z.string()).optional(),
      reply_to_addresses: z.array(z.string()).optional(),
      send_times: z.array(z.string()).optional(),
      subject_lines: z.array(z.string()).optional(),
      test_size: z.number().optional(),
      wait_time: z.number().optional(),
      winner_criteria: z
        .union([z.literal('opens'), z.literal('clicks'), z.literal('manual'), z.literal('total_revenue')])
        .optional(),
      winning_campaign_id: z.string().optional(),
      winning_combination_id: z.string().optional(),
    })
    .optional(),
  web_id: z.number().optional(),
});

export const postCampaignsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteCampaignsIdDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
  }),
});

export const deleteCampaignsIdResponseSchema = z.any();

export const deleteCampaignsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getCampaignsIdDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getCampaignsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  ab_split_opts: z
    .object({
      from_name_a: z.string().optional(),
      from_name_b: z.string().optional(),
      pick_winner: z.union([z.literal('opens'), z.literal('clicks'), z.literal('manual')]).optional(),
      reply_email_a: z.string().optional(),
      reply_email_b: z.string().optional(),
      send_time_a: z.string().optional(),
      send_time_b: z.string().optional(),
      send_time_winner: z.string().optional(),
      split_size: z.number().optional(),
      split_test: z.union([z.literal('subject'), z.literal('from_name'), z.literal('schedule')]).optional(),
      subject_a: z.string().optional(),
      subject_b: z.string().optional(),
      wait_time: z.number().optional(),
      wait_units: z.union([z.literal('hours'), z.literal('days')]).optional(),
    })
    .optional(),
  archive_url: z.string().optional(),
  content_type: z
    .union([z.literal('template'), z.literal('html'), z.literal('url'), z.literal('multichannel')])
    .optional(),
  create_time: z.string().optional(),
  delivery_status: z
    .object({
      can_cancel: z.boolean().optional(),
      emails_canceled: z.number().optional(),
      emails_sent: z.number().optional(),
      enabled: z.boolean().optional(),
      status: z
        .union([z.literal('delivering'), z.literal('delivered'), z.literal('canceling'), z.literal('canceled')])
        .optional(),
    })
    .optional(),
  emails_sent: z.number().optional(),
  id: z.string().optional(),
  long_archive_url: z.string().optional(),
  needs_block_refresh: z.boolean().optional(),
  parent_campaign_id: z.string().optional(),
  recipients: z
    .object({
      list_id: z.string().optional(),
      list_is_active: z.boolean().optional(),
      list_name: z.string().optional(),
      recipient_count: z.number().optional(),
      segment_opts: z
        .object({
          conditions: z
            .array(
              z.union([
                z.object({
                  condition_type: z.literal('Aim').optional(),
                  field: z.literal('aim').optional(),
                  op: z
                    .union([
                      z.literal('open'),
                      z.literal('click'),
                      z.literal('sent'),
                      z.literal('noopen'),
                      z.literal('noclick'),
                      z.literal('nosent'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('Automation').optional(),
                  field: z.literal('automation'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('CampaignPoll').optional(),
                  field: z.literal('poll'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('Conversation').optional(),
                  field: z.literal('conversation'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Date').optional(),
                  extra: z.string().optional(),
                  field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
                  op: z.union([
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('within'),
                    z.literal('notwithin'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('EmailClient').optional(),
                  field: z.literal('email_client'),
                  op: z.union([z.literal('client_is'), z.literal('client_not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Language').optional(),
                  field: z.literal('language'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('MemberRating').optional(),
                  field: z.literal('rating'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SignupSource'),
                  field: z.literal('source'),
                  op: z.union([z.literal('source_is'), z.literal('source_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SurveyMonkey').optional(),
                  field: z.literal('survey_monkey'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('VIP').optional(),
                  field: z.literal('gmonkey'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                }),
                z.object({
                  condition_type: z.literal('Interests').optional(),
                  field: z.string().optional(),
                  op: z
                    .union([
                      z.literal('interestcontains'),
                      z.literal('interestcontainsall'),
                      z.literal('interestnotcontains'),
                    ])
                    .optional(),
                  value: z.array(z.string()).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommCategory').optional(),
                  field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                  op: z
                    .union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommNumber').optional(),
                  field: z.union([
                    z.literal('ecomm_spent_avg'),
                    z.literal('ecomm_orders'),
                    z.literal('ecomm_prod_all'),
                    z.literal('ecomm_avg_ord'),
                  ]),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('EcommPurchased').optional(),
                  field: z.literal('ecomm_purchased').optional(),
                  op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommSpent').optional(),
                  field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                  op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                  value: z.number().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommStore').optional(),
                  field: z.literal('ecomm_store').optional(),
                  op: z.union([z.literal('is'), z.literal('not')]).optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('GoalActivity').optional(),
                  field: z.literal('goal'),
                  op: z.union([
                    z.literal('is'),
                    z.literal('goal_not'),
                    z.literal('contains'),
                    z.literal('goal_notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('GoalTimestamp').optional(),
                  field: z.literal('goal_last_visited'),
                  op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('FuzzySegment').optional(),
                  field: z.literal('fuzzy_segment'),
                  op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('StaticSegment').optional(),
                  field: z.literal('static_segment'),
                  op: z.union([z.literal('static_is'), z.literal('static_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoCountryState').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([
                    z.literal('ipgeocountry'),
                    z.literal('ipgeonotcountry'),
                    z.literal('ipgeostate'),
                    z.literal('ipgeonotstate'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  addr: z.string(),
                  condition_type: z.literal('IPGeoIn').optional(),
                  field: z.literal('ipgeo'),
                  lat: z.string(),
                  lng: z.string(),
                  op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoInZip').optional(),
                  extra: z.number(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeoinzip'),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoUnknown').optional(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeounknown'),
                }),
                z.object({
                  condition_type: z.literal('IPGeoZip').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialAge').optional(),
                  field: z.literal('social_age'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                }),
                z.object({
                  condition_type: z.literal('SocialGender').optional(),
                  field: z.literal('social_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('SocialInfluence').optional(),
                  field: z.literal('social_influence'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkMember').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.union([
                    z.literal('twitter'),
                    z.literal('facebook'),
                    z.literal('linkedin'),
                    z.literal('flickr'),
                    z.literal('foursquare'),
                    z.literal('lastfm'),
                    z.literal('myspace'),
                    z.literal('quora'),
                    z.literal('vimeo'),
                    z.literal('yelp'),
                    z.literal('youtube'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkFollow').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('follow'), z.literal('notfollow')]),
                  value: z.literal('twitter_follow'),
                }),
                z.object({
                  condition_type: z.literal('AddressMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('ZipMerge').optional(),
                  extra: z.string(),
                  field: z.string(),
                  op: z.literal('geoin'),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('BirthdayMerge').optional(),
                  field: z.string(),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('DateMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('greater'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SelectMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('notcontain'),
                    z.literal('contains'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('TextMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EmailAddress').optional(),
                  field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('PredictedGender').optional(),
                  field: z.literal('predicted_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('PredictedAge').optional(),
                  field: z.literal('predicted_age_range'),
                  op: z.literal('is'),
                  value: z.union([
                    z.literal('18-24'),
                    z.literal('25-34'),
                    z.literal('35-44'),
                    z.literal('45-54'),
                    z.literal('55-64'),
                    z.literal('65+'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('NewSubscribers').optional(),
                  field: z.literal('timestamp_opt').optional(),
                  op: z.literal('date_within').optional(),
                  value: z.string().optional(),
                }),
              ]),
            )
            .optional(),
          match: z.union([z.literal('any'), z.literal('all')]).optional(),
          prebuilt_segment_id: z.string().optional(),
          saved_segment_id: z.number().optional(),
        })
        .optional(),
      segment_text: z.string().optional(),
    })
    .optional(),
  report_summary: z
    .object({
      click_rate: z.number().optional(),
      clicks: z.number().optional(),
      ecommerce: z
        .object({
          total_orders: z.number().optional(),
          total_revenue: z.number().optional(),
          total_spent: z.number().optional(),
        })
        .optional(),
      open_rate: z.number().optional(),
      opens: z.number().optional(),
      subscriber_clicks: z.number().optional(),
      unique_opens: z.number().optional(),
    })
    .optional(),
  resendable: z.boolean().optional(),
  rss_opts: z
    .object({
      constrain_rss_img: z.boolean().optional(),
      feed_url: z.string().optional(),
      frequency: z.union([z.literal('daily'), z.literal('weekly'), z.literal('monthly')]).optional(),
      last_sent: z.string().optional(),
      schedule: z
        .object({
          daily_send: z
            .object({
              friday: z.boolean().optional(),
              monday: z.boolean().optional(),
              saturday: z.boolean().optional(),
              sunday: z.boolean().optional(),
              thursday: z.boolean().optional(),
              tuesday: z.boolean().optional(),
              wednesday: z.boolean().optional(),
            })
            .optional(),
          hour: z.number().optional(),
          monthly_send_date: z.number().optional(),
          weekly_send_day: z
            .union([
              z.literal('sunday'),
              z.literal('monday'),
              z.literal('tuesday'),
              z.literal('wednesday'),
              z.literal('thursday'),
              z.literal('friday'),
              z.literal('saturday'),
            ])
            .optional(),
        })
        .optional(),
    })
    .optional(),
  send_time: z.string().optional(),
  settings: z
    .object({
      authenticate: z.boolean().optional(),
      auto_fb_post: z.array(z.string()).optional(),
      auto_footer: z.boolean().optional(),
      auto_tweet: z.boolean().optional(),
      drag_and_drop: z.boolean().optional(),
      fb_comments: z.boolean().optional(),
      folder_id: z.string().optional(),
      from_name: z.string().optional(),
      inline_css: z.boolean().optional(),
      preview_text: z.string().optional(),
      reply_to: z.string().optional(),
      subject_line: z.string().optional(),
      template_id: z.number().optional(),
      timewarp: z.boolean().optional(),
      title: z.string().optional(),
      to_name: z.string().optional(),
      use_conversation: z.boolean().optional(),
    })
    .optional(),
  social_card: z
    .object({
      description: z.string().optional(),
      image_url: z.string().optional(),
      title: z.string().optional(),
    })
    .optional(),
  status: z
    .union([
      z.literal('save'),
      z.literal('paused'),
      z.literal('schedule'),
      z.literal('sending'),
      z.literal('sent'),
      z.literal('canceled'),
      z.literal('canceling'),
      z.literal('archived'),
    ])
    .optional(),
  tracking: z
    .object({
      capsule: z
        .object({
          notes: z.boolean().optional(),
        })
        .optional(),
      clicktale: z.string().optional(),
      ecomm360: z.boolean().optional(),
      goal_tracking: z.boolean().optional(),
      google_analytics: z.string().optional(),
      html_clicks: z.boolean().optional(),
      opens: z.boolean().optional(),
      salesforce: z
        .object({
          campaign: z.boolean().optional(),
          notes: z.boolean().optional(),
        })
        .optional(),
      text_clicks: z.boolean().optional(),
    })
    .optional(),
  type: z
    .union([z.literal('regular'), z.literal('plaintext'), z.literal('absplit'), z.literal('rss'), z.literal('variate')])
    .optional(),
  variate_settings: z
    .object({
      combinations: z
        .array(
          z.object({
            content_description: z.number().optional(),
            from_name: z.number().optional(),
            id: z.string().optional(),
            recipients: z.number().optional(),
            reply_to: z.number().optional(),
            send_time: z.number().optional(),
            subject_line: z.number().optional(),
          }),
        )
        .optional(),
      contents: z.array(z.string()).optional(),
      from_names: z.array(z.string()).optional(),
      reply_to_addresses: z.array(z.string()).optional(),
      send_times: z.array(z.string()).optional(),
      subject_lines: z.array(z.string()).optional(),
      test_size: z.number().optional(),
      wait_time: z.number().optional(),
      winner_criteria: z
        .union([z.literal('opens'), z.literal('clicks'), z.literal('manual'), z.literal('total_revenue')])
        .optional(),
      winning_campaign_id: z.string().optional(),
      winning_combination_id: z.string().optional(),
    })
    .optional(),
  web_id: z.number().optional(),
});

export const getCampaignsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchCampaignsIdDataSchema = z.object({
  body: z.object({
    recipients: z
      .object({
        list_id: z.string(),
        segment_opts: z
          .object({
            conditions: z
              .array(
                z.union([
                  z.object({
                    condition_type: z.literal('Aim').optional(),
                    field: z.literal('aim').optional(),
                    op: z
                      .union([
                        z.literal('open'),
                        z.literal('click'),
                        z.literal('sent'),
                        z.literal('noopen'),
                        z.literal('noclick'),
                        z.literal('nosent'),
                      ])
                      .optional(),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('Automation').optional(),
                    field: z.literal('automation'),
                    op: z.union([
                      z.literal('started'),
                      z.literal('completed'),
                      z.literal('not_started'),
                      z.literal('not_completed'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('CampaignPoll').optional(),
                    field: z.literal('poll'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('Conversation').optional(),
                    field: z.literal('conversation'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('Date').optional(),
                    extra: z.string().optional(),
                    field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
                    op: z.union([
                      z.literal('greater'),
                      z.literal('less'),
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                      z.literal('within'),
                      z.literal('notwithin'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('EmailClient').optional(),
                    field: z.literal('email_client'),
                    op: z.union([z.literal('client_is'), z.literal('client_not')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('Language').optional(),
                    field: z.literal('language'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('MemberRating').optional(),
                    field: z.literal('rating'),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('SignupSource'),
                    field: z.literal('source'),
                    op: z.union([z.literal('source_is'), z.literal('source_not')]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('SurveyMonkey').optional(),
                    field: z.literal('survey_monkey'),
                    op: z.union([
                      z.literal('started'),
                      z.literal('completed'),
                      z.literal('not_started'),
                      z.literal('not_completed'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('VIP').optional(),
                    field: z.literal('gmonkey'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                  }),
                  z.object({
                    condition_type: z.literal('Interests').optional(),
                    field: z.string().optional(),
                    op: z
                      .union([
                        z.literal('interestcontains'),
                        z.literal('interestcontainsall'),
                        z.literal('interestnotcontains'),
                      ])
                      .optional(),
                    value: z.array(z.string()).optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommCategory').optional(),
                    field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                    op: z
                      .union([
                        z.literal('is'),
                        z.literal('not'),
                        z.literal('contains'),
                        z.literal('notcontain'),
                        z.literal('starts'),
                        z.literal('ends'),
                      ])
                      .optional(),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommNumber').optional(),
                    field: z.union([
                      z.literal('ecomm_spent_avg'),
                      z.literal('ecomm_orders'),
                      z.literal('ecomm_prod_all'),
                      z.literal('ecomm_avg_ord'),
                    ]),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommPurchased').optional(),
                    field: z.literal('ecomm_purchased').optional(),
                    op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommSpent').optional(),
                    field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                    op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                    value: z.number().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommStore').optional(),
                    field: z.literal('ecomm_store').optional(),
                    op: z.union([z.literal('is'), z.literal('not')]).optional(),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('GoalActivity').optional(),
                    field: z.literal('goal'),
                    op: z.union([
                      z.literal('is'),
                      z.literal('goal_not'),
                      z.literal('contains'),
                      z.literal('goal_notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('GoalTimestamp').optional(),
                    field: z.literal('goal_last_visited'),
                    op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('FuzzySegment').optional(),
                    field: z.literal('fuzzy_segment'),
                    op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('StaticSegment').optional(),
                    field: z.literal('static_segment'),
                    op: z.union([z.literal('static_is'), z.literal('static_not')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoCountryState').optional(),
                    field: z.literal('ipgeo'),
                    op: z.union([
                      z.literal('ipgeocountry'),
                      z.literal('ipgeonotcountry'),
                      z.literal('ipgeostate'),
                      z.literal('ipgeonotstate'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    addr: z.string(),
                    condition_type: z.literal('IPGeoIn').optional(),
                    field: z.literal('ipgeo'),
                    lat: z.string(),
                    lng: z.string(),
                    op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoInZip').optional(),
                    extra: z.number(),
                    field: z.literal('ipgeo'),
                    op: z.literal('ipgeoinzip'),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoUnknown').optional(),
                    field: z.literal('ipgeo'),
                    op: z.literal('ipgeounknown'),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoZip').optional(),
                    field: z.literal('ipgeo'),
                    op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('SocialAge').optional(),
                    field: z.literal('social_age'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                  }),
                  z.object({
                    condition_type: z.literal('SocialGender').optional(),
                    field: z.literal('social_gender'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.union([z.literal('male'), z.literal('female')]),
                  }),
                  z.object({
                    condition_type: z.literal('SocialInfluence').optional(),
                    field: z.literal('social_influence'),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('SocialNetworkMember').optional(),
                    field: z.literal('social_network'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                    value: z.union([
                      z.literal('twitter'),
                      z.literal('facebook'),
                      z.literal('linkedin'),
                      z.literal('flickr'),
                      z.literal('foursquare'),
                      z.literal('lastfm'),
                      z.literal('myspace'),
                      z.literal('quora'),
                      z.literal('vimeo'),
                      z.literal('yelp'),
                      z.literal('youtube'),
                    ]),
                  }),
                  z.object({
                    condition_type: z.literal('SocialNetworkFollow').optional(),
                    field: z.literal('social_network'),
                    op: z.union([z.literal('follow'), z.literal('notfollow')]),
                    value: z.literal('twitter_follow'),
                  }),
                  z.object({
                    condition_type: z.literal('AddressMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('ZipMerge').optional(),
                    extra: z.string(),
                    field: z.string(),
                    op: z.literal('geoin'),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('BirthdayMerge').optional(),
                    field: z.string(),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('DateMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('less'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                      z.literal('greater'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('SelectMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                      z.literal('notcontain'),
                      z.literal('contains'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('TextMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                      z.literal('greater'),
                      z.literal('less'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EmailAddress').optional(),
                    field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                      z.literal('greater'),
                      z.literal('less'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('PredictedGender').optional(),
                    field: z.literal('predicted_gender'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.union([z.literal('male'), z.literal('female')]),
                  }),
                  z.object({
                    condition_type: z.literal('PredictedAge').optional(),
                    field: z.literal('predicted_age_range'),
                    op: z.literal('is'),
                    value: z.union([
                      z.literal('18-24'),
                      z.literal('25-34'),
                      z.literal('35-44'),
                      z.literal('45-54'),
                      z.literal('55-64'),
                      z.literal('65+'),
                    ]),
                  }),
                  z.object({
                    condition_type: z.literal('NewSubscribers').optional(),
                    field: z.literal('timestamp_opt').optional(),
                    op: z.literal('date_within').optional(),
                    value: z.string().optional(),
                  }),
                ]),
              )
              .optional(),
            match: z.union([z.literal('any'), z.literal('all')]).optional(),
            prebuilt_segment_id: z.string().optional(),
            saved_segment_id: z.number().optional(),
          })
          .optional(),
      })
      .optional(),
    rss_opts: z
      .object({
        constrain_rss_img: z.boolean().optional(),
        feed_url: z.string(),
        frequency: z.union([z.literal('daily'), z.literal('weekly'), z.literal('monthly')]),
        schedule: z
          .object({
            daily_send: z
              .object({
                friday: z.boolean().optional(),
                monday: z.boolean().optional(),
                saturday: z.boolean().optional(),
                sunday: z.boolean().optional(),
                thursday: z.boolean().optional(),
                tuesday: z.boolean().optional(),
                wednesday: z.boolean().optional(),
              })
              .optional(),
            hour: z.number().optional(),
            monthly_send_date: z.number().optional(),
            weekly_send_day: z
              .union([
                z.literal('sunday'),
                z.literal('monday'),
                z.literal('tuesday'),
                z.literal('wednesday'),
                z.literal('thursday'),
                z.literal('friday'),
                z.literal('saturday'),
              ])
              .optional(),
          })
          .optional(),
      })
      .optional(),
    settings: z.object({
      authenticate: z.boolean().optional(),
      auto_fb_post: z.array(z.string()).optional(),
      auto_footer: z.boolean().optional(),
      auto_tweet: z.boolean().optional(),
      fb_comments: z.boolean().optional(),
      folder_id: z.string().optional(),
      from_name: z.string(),
      inline_css: z.boolean().optional(),
      preview_text: z.string().optional(),
      reply_to: z.string(),
      subject_line: z.string(),
      template_id: z.number().optional(),
      title: z.string().optional(),
      to_name: z.string().optional(),
      use_conversation: z.boolean().optional(),
    }),
    social_card: z
      .object({
        description: z.string().optional(),
        image_url: z.string().optional(),
        title: z.string().optional(),
      })
      .optional(),
    tracking: z
      .object({
        capsule: z
          .object({
            notes: z.boolean().optional(),
          })
          .optional(),
        clicktale: z.string().optional(),
        ecomm360: z.boolean().optional(),
        goal_tracking: z.boolean().optional(),
        google_analytics: z.string().optional(),
        html_clicks: z.boolean().optional(),
        opens: z.boolean().optional(),
        salesforce: z
          .object({
            campaign: z.boolean().optional(),
            notes: z.boolean().optional(),
          })
          .optional(),
        text_clicks: z.boolean().optional(),
      })
      .optional(),
    variate_settings: z
      .object({
        from_names: z.array(z.string()).optional(),
        reply_to_addresses: z.array(z.string()).optional(),
        send_times: z.array(z.string()).optional(),
        subject_lines: z.array(z.string()).optional(),
        test_size: z.number().optional(),
        wait_time: z.number().optional(),
        winner_criteria: z.union([
          z.literal('opens'),
          z.literal('clicks'),
          z.literal('manual'),
          z.literal('total_revenue'),
        ]),
      })
      .optional(),
  }),
  path: z.object({
    campaign_id: z.string(),
  }),
});

export const patchCampaignsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  ab_split_opts: z
    .object({
      from_name_a: z.string().optional(),
      from_name_b: z.string().optional(),
      pick_winner: z.union([z.literal('opens'), z.literal('clicks'), z.literal('manual')]).optional(),
      reply_email_a: z.string().optional(),
      reply_email_b: z.string().optional(),
      send_time_a: z.string().optional(),
      send_time_b: z.string().optional(),
      send_time_winner: z.string().optional(),
      split_size: z.number().optional(),
      split_test: z.union([z.literal('subject'), z.literal('from_name'), z.literal('schedule')]).optional(),
      subject_a: z.string().optional(),
      subject_b: z.string().optional(),
      wait_time: z.number().optional(),
      wait_units: z.union([z.literal('hours'), z.literal('days')]).optional(),
    })
    .optional(),
  archive_url: z.string().optional(),
  content_type: z
    .union([z.literal('template'), z.literal('html'), z.literal('url'), z.literal('multichannel')])
    .optional(),
  create_time: z.string().optional(),
  delivery_status: z
    .object({
      can_cancel: z.boolean().optional(),
      emails_canceled: z.number().optional(),
      emails_sent: z.number().optional(),
      enabled: z.boolean().optional(),
      status: z
        .union([z.literal('delivering'), z.literal('delivered'), z.literal('canceling'), z.literal('canceled')])
        .optional(),
    })
    .optional(),
  emails_sent: z.number().optional(),
  id: z.string().optional(),
  long_archive_url: z.string().optional(),
  needs_block_refresh: z.boolean().optional(),
  parent_campaign_id: z.string().optional(),
  recipients: z
    .object({
      list_id: z.string().optional(),
      list_is_active: z.boolean().optional(),
      list_name: z.string().optional(),
      recipient_count: z.number().optional(),
      segment_opts: z
        .object({
          conditions: z
            .array(
              z.union([
                z.object({
                  condition_type: z.literal('Aim').optional(),
                  field: z.literal('aim').optional(),
                  op: z
                    .union([
                      z.literal('open'),
                      z.literal('click'),
                      z.literal('sent'),
                      z.literal('noopen'),
                      z.literal('noclick'),
                      z.literal('nosent'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('Automation').optional(),
                  field: z.literal('automation'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('CampaignPoll').optional(),
                  field: z.literal('poll'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('Conversation').optional(),
                  field: z.literal('conversation'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Date').optional(),
                  extra: z.string().optional(),
                  field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
                  op: z.union([
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('within'),
                    z.literal('notwithin'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('EmailClient').optional(),
                  field: z.literal('email_client'),
                  op: z.union([z.literal('client_is'), z.literal('client_not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Language').optional(),
                  field: z.literal('language'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('MemberRating').optional(),
                  field: z.literal('rating'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SignupSource'),
                  field: z.literal('source'),
                  op: z.union([z.literal('source_is'), z.literal('source_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SurveyMonkey').optional(),
                  field: z.literal('survey_monkey'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('VIP').optional(),
                  field: z.literal('gmonkey'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                }),
                z.object({
                  condition_type: z.literal('Interests').optional(),
                  field: z.string().optional(),
                  op: z
                    .union([
                      z.literal('interestcontains'),
                      z.literal('interestcontainsall'),
                      z.literal('interestnotcontains'),
                    ])
                    .optional(),
                  value: z.array(z.string()).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommCategory').optional(),
                  field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                  op: z
                    .union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommNumber').optional(),
                  field: z.union([
                    z.literal('ecomm_spent_avg'),
                    z.literal('ecomm_orders'),
                    z.literal('ecomm_prod_all'),
                    z.literal('ecomm_avg_ord'),
                  ]),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('EcommPurchased').optional(),
                  field: z.literal('ecomm_purchased').optional(),
                  op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommSpent').optional(),
                  field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                  op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                  value: z.number().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommStore').optional(),
                  field: z.literal('ecomm_store').optional(),
                  op: z.union([z.literal('is'), z.literal('not')]).optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('GoalActivity').optional(),
                  field: z.literal('goal'),
                  op: z.union([
                    z.literal('is'),
                    z.literal('goal_not'),
                    z.literal('contains'),
                    z.literal('goal_notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('GoalTimestamp').optional(),
                  field: z.literal('goal_last_visited'),
                  op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('FuzzySegment').optional(),
                  field: z.literal('fuzzy_segment'),
                  op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('StaticSegment').optional(),
                  field: z.literal('static_segment'),
                  op: z.union([z.literal('static_is'), z.literal('static_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoCountryState').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([
                    z.literal('ipgeocountry'),
                    z.literal('ipgeonotcountry'),
                    z.literal('ipgeostate'),
                    z.literal('ipgeonotstate'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  addr: z.string(),
                  condition_type: z.literal('IPGeoIn').optional(),
                  field: z.literal('ipgeo'),
                  lat: z.string(),
                  lng: z.string(),
                  op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoInZip').optional(),
                  extra: z.number(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeoinzip'),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoUnknown').optional(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeounknown'),
                }),
                z.object({
                  condition_type: z.literal('IPGeoZip').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialAge').optional(),
                  field: z.literal('social_age'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                }),
                z.object({
                  condition_type: z.literal('SocialGender').optional(),
                  field: z.literal('social_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('SocialInfluence').optional(),
                  field: z.literal('social_influence'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkMember').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.union([
                    z.literal('twitter'),
                    z.literal('facebook'),
                    z.literal('linkedin'),
                    z.literal('flickr'),
                    z.literal('foursquare'),
                    z.literal('lastfm'),
                    z.literal('myspace'),
                    z.literal('quora'),
                    z.literal('vimeo'),
                    z.literal('yelp'),
                    z.literal('youtube'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkFollow').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('follow'), z.literal('notfollow')]),
                  value: z.literal('twitter_follow'),
                }),
                z.object({
                  condition_type: z.literal('AddressMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('ZipMerge').optional(),
                  extra: z.string(),
                  field: z.string(),
                  op: z.literal('geoin'),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('BirthdayMerge').optional(),
                  field: z.string(),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('DateMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('greater'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SelectMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('notcontain'),
                    z.literal('contains'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('TextMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EmailAddress').optional(),
                  field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('PredictedGender').optional(),
                  field: z.literal('predicted_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('PredictedAge').optional(),
                  field: z.literal('predicted_age_range'),
                  op: z.literal('is'),
                  value: z.union([
                    z.literal('18-24'),
                    z.literal('25-34'),
                    z.literal('35-44'),
                    z.literal('45-54'),
                    z.literal('55-64'),
                    z.literal('65+'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('NewSubscribers').optional(),
                  field: z.literal('timestamp_opt').optional(),
                  op: z.literal('date_within').optional(),
                  value: z.string().optional(),
                }),
              ]),
            )
            .optional(),
          match: z.union([z.literal('any'), z.literal('all')]).optional(),
          prebuilt_segment_id: z.string().optional(),
          saved_segment_id: z.number().optional(),
        })
        .optional(),
      segment_text: z.string().optional(),
    })
    .optional(),
  report_summary: z
    .object({
      click_rate: z.number().optional(),
      clicks: z.number().optional(),
      ecommerce: z
        .object({
          total_orders: z.number().optional(),
          total_revenue: z.number().optional(),
          total_spent: z.number().optional(),
        })
        .optional(),
      open_rate: z.number().optional(),
      opens: z.number().optional(),
      subscriber_clicks: z.number().optional(),
      unique_opens: z.number().optional(),
    })
    .optional(),
  resendable: z.boolean().optional(),
  rss_opts: z
    .object({
      constrain_rss_img: z.boolean().optional(),
      feed_url: z.string().optional(),
      frequency: z.union([z.literal('daily'), z.literal('weekly'), z.literal('monthly')]).optional(),
      last_sent: z.string().optional(),
      schedule: z
        .object({
          daily_send: z
            .object({
              friday: z.boolean().optional(),
              monday: z.boolean().optional(),
              saturday: z.boolean().optional(),
              sunday: z.boolean().optional(),
              thursday: z.boolean().optional(),
              tuesday: z.boolean().optional(),
              wednesday: z.boolean().optional(),
            })
            .optional(),
          hour: z.number().optional(),
          monthly_send_date: z.number().optional(),
          weekly_send_day: z
            .union([
              z.literal('sunday'),
              z.literal('monday'),
              z.literal('tuesday'),
              z.literal('wednesday'),
              z.literal('thursday'),
              z.literal('friday'),
              z.literal('saturday'),
            ])
            .optional(),
        })
        .optional(),
    })
    .optional(),
  send_time: z.string().optional(),
  settings: z
    .object({
      authenticate: z.boolean().optional(),
      auto_fb_post: z.array(z.string()).optional(),
      auto_footer: z.boolean().optional(),
      auto_tweet: z.boolean().optional(),
      drag_and_drop: z.boolean().optional(),
      fb_comments: z.boolean().optional(),
      folder_id: z.string().optional(),
      from_name: z.string().optional(),
      inline_css: z.boolean().optional(),
      preview_text: z.string().optional(),
      reply_to: z.string().optional(),
      subject_line: z.string().optional(),
      template_id: z.number().optional(),
      timewarp: z.boolean().optional(),
      title: z.string().optional(),
      to_name: z.string().optional(),
      use_conversation: z.boolean().optional(),
    })
    .optional(),
  social_card: z
    .object({
      description: z.string().optional(),
      image_url: z.string().optional(),
      title: z.string().optional(),
    })
    .optional(),
  status: z
    .union([
      z.literal('save'),
      z.literal('paused'),
      z.literal('schedule'),
      z.literal('sending'),
      z.literal('sent'),
      z.literal('canceled'),
      z.literal('canceling'),
      z.literal('archived'),
    ])
    .optional(),
  tracking: z
    .object({
      capsule: z
        .object({
          notes: z.boolean().optional(),
        })
        .optional(),
      clicktale: z.string().optional(),
      ecomm360: z.boolean().optional(),
      goal_tracking: z.boolean().optional(),
      google_analytics: z.string().optional(),
      html_clicks: z.boolean().optional(),
      opens: z.boolean().optional(),
      salesforce: z
        .object({
          campaign: z.boolean().optional(),
          notes: z.boolean().optional(),
        })
        .optional(),
      text_clicks: z.boolean().optional(),
    })
    .optional(),
  type: z
    .union([z.literal('regular'), z.literal('plaintext'), z.literal('absplit'), z.literal('rss'), z.literal('variate')])
    .optional(),
  variate_settings: z
    .object({
      combinations: z
        .array(
          z.object({
            content_description: z.number().optional(),
            from_name: z.number().optional(),
            id: z.string().optional(),
            recipients: z.number().optional(),
            reply_to: z.number().optional(),
            send_time: z.number().optional(),
            subject_line: z.number().optional(),
          }),
        )
        .optional(),
      contents: z.array(z.string()).optional(),
      from_names: z.array(z.string()).optional(),
      reply_to_addresses: z.array(z.string()).optional(),
      send_times: z.array(z.string()).optional(),
      subject_lines: z.array(z.string()).optional(),
      test_size: z.number().optional(),
      wait_time: z.number().optional(),
      winner_criteria: z
        .union([z.literal('opens'), z.literal('clicks'), z.literal('manual'), z.literal('total_revenue')])
        .optional(),
      winning_campaign_id: z.string().optional(),
      winning_combination_id: z.string().optional(),
    })
    .optional(),
  web_id: z.number().optional(),
});

export const patchCampaignsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postCampaignsIdActionsCancelSendDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
  }),
});

export const postCampaignsIdActionsCancelSendResponseSchema = z.any();

export const postCampaignsIdActionsCancelSendErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postCampaignsIdActionsCreateResendDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
  }),
});

export const postCampaignsIdActionsCreateResendResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  ab_split_opts: z
    .object({
      from_name_a: z.string().optional(),
      from_name_b: z.string().optional(),
      pick_winner: z.union([z.literal('opens'), z.literal('clicks'), z.literal('manual')]).optional(),
      reply_email_a: z.string().optional(),
      reply_email_b: z.string().optional(),
      send_time_a: z.string().optional(),
      send_time_b: z.string().optional(),
      send_time_winner: z.string().optional(),
      split_size: z.number().optional(),
      split_test: z.union([z.literal('subject'), z.literal('from_name'), z.literal('schedule')]).optional(),
      subject_a: z.string().optional(),
      subject_b: z.string().optional(),
      wait_time: z.number().optional(),
      wait_units: z.union([z.literal('hours'), z.literal('days')]).optional(),
    })
    .optional(),
  archive_url: z.string().optional(),
  content_type: z.string().optional(),
  create_time: z.string().optional(),
  delivery_status: z
    .object({
      can_cancel: z.boolean().optional(),
      emails_canceled: z.number().optional(),
      emails_sent: z.number().optional(),
      enabled: z.boolean().optional(),
      status: z
        .union([z.literal('delivering'), z.literal('delivered'), z.literal('canceling'), z.literal('canceled')])
        .optional(),
    })
    .optional(),
  emails_sent: z.number().optional(),
  id: z.string().optional(),
  long_archive_url: z.string().optional(),
  needs_block_refresh: z.boolean().optional(),
  parent_campaign_id: z.string().optional(),
  recipients: z
    .object({
      list_id: z.string(),
      list_name: z.string().optional(),
      recipient_count: z.number().optional(),
      segment_opts: z
        .object({
          conditions: z
            .array(
              z.union([
                z.object({
                  condition_type: z.literal('Aim').optional(),
                  field: z.literal('aim').optional(),
                  op: z
                    .union([
                      z.literal('open'),
                      z.literal('click'),
                      z.literal('sent'),
                      z.literal('noopen'),
                      z.literal('noclick'),
                      z.literal('nosent'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('Automation').optional(),
                  field: z.literal('automation'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('CampaignPoll').optional(),
                  field: z.literal('poll'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('Conversation').optional(),
                  field: z.literal('conversation'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Date').optional(),
                  extra: z.string().optional(),
                  field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
                  op: z.union([
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('within'),
                    z.literal('notwithin'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('EmailClient').optional(),
                  field: z.literal('email_client'),
                  op: z.union([z.literal('client_is'), z.literal('client_not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Language').optional(),
                  field: z.literal('language'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('MemberRating').optional(),
                  field: z.literal('rating'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SignupSource'),
                  field: z.literal('source'),
                  op: z.union([z.literal('source_is'), z.literal('source_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SurveyMonkey').optional(),
                  field: z.literal('survey_monkey'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('VIP').optional(),
                  field: z.literal('gmonkey'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                }),
                z.object({
                  condition_type: z.literal('Interests').optional(),
                  field: z.string().optional(),
                  op: z
                    .union([
                      z.literal('interestcontains'),
                      z.literal('interestcontainsall'),
                      z.literal('interestnotcontains'),
                    ])
                    .optional(),
                  value: z.array(z.string()).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommCategory').optional(),
                  field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                  op: z
                    .union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommNumber').optional(),
                  field: z.union([
                    z.literal('ecomm_spent_avg'),
                    z.literal('ecomm_orders'),
                    z.literal('ecomm_prod_all'),
                    z.literal('ecomm_avg_ord'),
                  ]),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('EcommPurchased').optional(),
                  field: z.literal('ecomm_purchased').optional(),
                  op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommSpent').optional(),
                  field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                  op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                  value: z.number().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommStore').optional(),
                  field: z.literal('ecomm_store').optional(),
                  op: z.union([z.literal('is'), z.literal('not')]).optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('GoalActivity').optional(),
                  field: z.literal('goal'),
                  op: z.union([
                    z.literal('is'),
                    z.literal('goal_not'),
                    z.literal('contains'),
                    z.literal('goal_notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('GoalTimestamp').optional(),
                  field: z.literal('goal_last_visited'),
                  op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('FuzzySegment').optional(),
                  field: z.literal('fuzzy_segment'),
                  op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('StaticSegment').optional(),
                  field: z.literal('static_segment'),
                  op: z.union([z.literal('static_is'), z.literal('static_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoCountryState').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([
                    z.literal('ipgeocountry'),
                    z.literal('ipgeonotcountry'),
                    z.literal('ipgeostate'),
                    z.literal('ipgeonotstate'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  addr: z.string(),
                  condition_type: z.literal('IPGeoIn').optional(),
                  field: z.literal('ipgeo'),
                  lat: z.string(),
                  lng: z.string(),
                  op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoInZip').optional(),
                  extra: z.number(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeoinzip'),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoUnknown').optional(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeounknown'),
                }),
                z.object({
                  condition_type: z.literal('IPGeoZip').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialAge').optional(),
                  field: z.literal('social_age'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                }),
                z.object({
                  condition_type: z.literal('SocialGender').optional(),
                  field: z.literal('social_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('SocialInfluence').optional(),
                  field: z.literal('social_influence'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkMember').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.union([
                    z.literal('twitter'),
                    z.literal('facebook'),
                    z.literal('linkedin'),
                    z.literal('flickr'),
                    z.literal('foursquare'),
                    z.literal('lastfm'),
                    z.literal('myspace'),
                    z.literal('quora'),
                    z.literal('vimeo'),
                    z.literal('yelp'),
                    z.literal('youtube'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkFollow').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('follow'), z.literal('notfollow')]),
                  value: z.literal('twitter_follow'),
                }),
                z.object({
                  condition_type: z.literal('AddressMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('ZipMerge').optional(),
                  extra: z.string(),
                  field: z.string(),
                  op: z.literal('geoin'),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('BirthdayMerge').optional(),
                  field: z.string(),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('DateMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('greater'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SelectMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('notcontain'),
                    z.literal('contains'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('TextMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EmailAddress').optional(),
                  field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('PredictedGender').optional(),
                  field: z.literal('predicted_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('PredictedAge').optional(),
                  field: z.literal('predicted_age_range'),
                  op: z.literal('is'),
                  value: z.union([
                    z.literal('18-24'),
                    z.literal('25-34'),
                    z.literal('35-44'),
                    z.literal('45-54'),
                    z.literal('55-64'),
                    z.literal('65+'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('NewSubscribers').optional(),
                  field: z.literal('timestamp_opt').optional(),
                  op: z.literal('date_within').optional(),
                  value: z.string().optional(),
                }),
              ]),
            )
            .optional(),
          match: z.union([z.literal('any'), z.literal('all')]).optional(),
          prebuilt_segment_id: z.string().optional(),
          saved_segment_id: z.number().optional(),
        })
        .optional(),
      segment_text: z.string().optional(),
    })
    .optional(),
  report_summary: z
    .object({
      click_rate: z.number().optional(),
      clicks: z.number().optional(),
      ecommerce: z
        .object({
          total_orders: z.number().optional(),
          total_revenue: z.number().optional(),
          total_spent: z.number().optional(),
        })
        .optional(),
      open_rate: z.number().optional(),
      opens: z.number().optional(),
      subscriber_clicks: z.number().optional(),
      unique_opens: z.number().optional(),
    })
    .optional(),
  resendable: z.boolean().optional(),
  rss_opts: z
    .object({
      constrain_rss_img: z.boolean().optional(),
      feed_url: z.string(),
      frequency: z.union([z.literal('daily'), z.literal('weekly'), z.literal('monthly')]),
      last_sent: z.string().optional(),
      schedule: z
        .object({
          daily_send: z
            .object({
              friday: z.boolean().optional(),
              monday: z.boolean().optional(),
              saturday: z.boolean().optional(),
              sunday: z.boolean().optional(),
              thursday: z.boolean().optional(),
              tuesday: z.boolean().optional(),
              wednesday: z.boolean().optional(),
            })
            .optional(),
          hour: z.number().optional(),
          monthly_send_date: z.number().optional(),
          weekly_send_day: z
            .union([
              z.literal('sunday'),
              z.literal('monday'),
              z.literal('tuesday'),
              z.literal('wednesday'),
              z.literal('thursday'),
              z.literal('friday'),
              z.literal('saturday'),
            ])
            .optional(),
        })
        .optional(),
    })
    .optional(),
  send_time: z.string().optional(),
  settings: z
    .object({
      authenticate: z.boolean().optional(),
      auto_fb_post: z.array(z.string()).optional(),
      auto_footer: z.boolean().optional(),
      auto_tweet: z.boolean().optional(),
      drag_and_drop: z.boolean().optional(),
      fb_comments: z.boolean().optional(),
      folder_id: z.string().optional(),
      from_name: z.string().optional(),
      inline_css: z.boolean().optional(),
      preview_text: z.string().optional(),
      reply_to: z.string().optional(),
      subject_line: z.string().optional(),
      template_id: z.number().optional(),
      timewarp: z.boolean().optional(),
      title: z.string().optional(),
      to_name: z.string().optional(),
      use_conversation: z.boolean().optional(),
    })
    .optional(),
  social_card: z
    .object({
      description: z.string().optional(),
      image_url: z.string().optional(),
      title: z.string().optional(),
    })
    .optional(),
  status: z
    .union([
      z.literal('save'),
      z.literal('paused'),
      z.literal('schedule'),
      z.literal('sending'),
      z.literal('sent'),
      z.literal('canceled'),
      z.literal('canceling'),
      z.literal('archived'),
    ])
    .optional(),
  tracking: z
    .object({
      capsule: z
        .object({
          notes: z.boolean().optional(),
        })
        .optional(),
      clicktale: z.string().optional(),
      ecomm360: z.boolean().optional(),
      goal_tracking: z.boolean().optional(),
      google_analytics: z.string().optional(),
      html_clicks: z.boolean().optional(),
      opens: z.boolean().optional(),
      salesforce: z
        .object({
          campaign: z.boolean().optional(),
          notes: z.boolean().optional(),
        })
        .optional(),
      text_clicks: z.boolean().optional(),
    })
    .optional(),
  type: z.union([
    z.literal('regular'),
    z.literal('plaintext'),
    z.literal('absplit'),
    z.literal('rss'),
    z.literal('variate'),
  ]),
  variate_settings: z
    .object({
      combinations: z
        .array(
          z.object({
            content_description: z.number().optional(),
            from_name: z.number().optional(),
            id: z.string().optional(),
            recipients: z.number().optional(),
            reply_to: z.number().optional(),
            send_time: z.number().optional(),
            subject_line: z.number().optional(),
          }),
        )
        .optional(),
      contents: z.array(z.string()).optional(),
      from_names: z.array(z.string()).optional(),
      reply_to_addresses: z.array(z.string()).optional(),
      send_times: z.array(z.string()).optional(),
      subject_lines: z.array(z.string()).optional(),
      test_size: z.number().optional(),
      wait_time: z.number().optional(),
      winner_criteria: z.union([
        z.literal('opens'),
        z.literal('clicks'),
        z.literal('manual'),
        z.literal('total_revenue'),
      ]),
      winning_campaign_id: z.string().optional(),
      winning_combination_id: z.string().optional(),
    })
    .optional(),
  web_id: z.number().optional(),
});

export const postCampaignsIdActionsCreateResendErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postCampaignsIdActionsPauseDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
  }),
});

export const postCampaignsIdActionsPauseResponseSchema = z.any();

export const postCampaignsIdActionsPauseErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postCampaignsIdActionsReplicateDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
  }),
});

export const postCampaignsIdActionsReplicateResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  ab_split_opts: z
    .object({
      from_name_a: z.string().optional(),
      from_name_b: z.string().optional(),
      pick_winner: z.union([z.literal('opens'), z.literal('clicks'), z.literal('manual')]).optional(),
      reply_email_a: z.string().optional(),
      reply_email_b: z.string().optional(),
      send_time_a: z.string().optional(),
      send_time_b: z.string().optional(),
      send_time_winner: z.string().optional(),
      split_size: z.number().optional(),
      split_test: z.union([z.literal('subject'), z.literal('from_name'), z.literal('schedule')]).optional(),
      subject_a: z.string().optional(),
      subject_b: z.string().optional(),
      wait_time: z.number().optional(),
      wait_units: z.union([z.literal('hours'), z.literal('days')]).optional(),
    })
    .optional(),
  archive_url: z.string().optional(),
  content_type: z.string().optional(),
  create_time: z.string().optional(),
  delivery_status: z
    .object({
      can_cancel: z.boolean().optional(),
      emails_canceled: z.number().optional(),
      emails_sent: z.number().optional(),
      enabled: z.boolean().optional(),
      status: z
        .union([z.literal('delivering'), z.literal('delivered'), z.literal('canceling'), z.literal('canceled')])
        .optional(),
    })
    .optional(),
  emails_sent: z.number().optional(),
  id: z.string().optional(),
  long_archive_url: z.string().optional(),
  needs_block_refresh: z.boolean().optional(),
  parent_campaign_id: z.string().optional(),
  recipients: z
    .object({
      list_id: z.string(),
      list_name: z.string().optional(),
      recipient_count: z.number().optional(),
      segment_opts: z
        .object({
          conditions: z
            .array(
              z.union([
                z.object({
                  condition_type: z.literal('Aim').optional(),
                  field: z.literal('aim').optional(),
                  op: z
                    .union([
                      z.literal('open'),
                      z.literal('click'),
                      z.literal('sent'),
                      z.literal('noopen'),
                      z.literal('noclick'),
                      z.literal('nosent'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('Automation').optional(),
                  field: z.literal('automation'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('CampaignPoll').optional(),
                  field: z.literal('poll'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('Conversation').optional(),
                  field: z.literal('conversation'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Date').optional(),
                  extra: z.string().optional(),
                  field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
                  op: z.union([
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('within'),
                    z.literal('notwithin'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('EmailClient').optional(),
                  field: z.literal('email_client'),
                  op: z.union([z.literal('client_is'), z.literal('client_not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Language').optional(),
                  field: z.literal('language'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('MemberRating').optional(),
                  field: z.literal('rating'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SignupSource'),
                  field: z.literal('source'),
                  op: z.union([z.literal('source_is'), z.literal('source_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SurveyMonkey').optional(),
                  field: z.literal('survey_monkey'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('VIP').optional(),
                  field: z.literal('gmonkey'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                }),
                z.object({
                  condition_type: z.literal('Interests').optional(),
                  field: z.string().optional(),
                  op: z
                    .union([
                      z.literal('interestcontains'),
                      z.literal('interestcontainsall'),
                      z.literal('interestnotcontains'),
                    ])
                    .optional(),
                  value: z.array(z.string()).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommCategory').optional(),
                  field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                  op: z
                    .union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommNumber').optional(),
                  field: z.union([
                    z.literal('ecomm_spent_avg'),
                    z.literal('ecomm_orders'),
                    z.literal('ecomm_prod_all'),
                    z.literal('ecomm_avg_ord'),
                  ]),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('EcommPurchased').optional(),
                  field: z.literal('ecomm_purchased').optional(),
                  op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommSpent').optional(),
                  field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                  op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                  value: z.number().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommStore').optional(),
                  field: z.literal('ecomm_store').optional(),
                  op: z.union([z.literal('is'), z.literal('not')]).optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('GoalActivity').optional(),
                  field: z.literal('goal'),
                  op: z.union([
                    z.literal('is'),
                    z.literal('goal_not'),
                    z.literal('contains'),
                    z.literal('goal_notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('GoalTimestamp').optional(),
                  field: z.literal('goal_last_visited'),
                  op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('FuzzySegment').optional(),
                  field: z.literal('fuzzy_segment'),
                  op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('StaticSegment').optional(),
                  field: z.literal('static_segment'),
                  op: z.union([z.literal('static_is'), z.literal('static_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoCountryState').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([
                    z.literal('ipgeocountry'),
                    z.literal('ipgeonotcountry'),
                    z.literal('ipgeostate'),
                    z.literal('ipgeonotstate'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  addr: z.string(),
                  condition_type: z.literal('IPGeoIn').optional(),
                  field: z.literal('ipgeo'),
                  lat: z.string(),
                  lng: z.string(),
                  op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoInZip').optional(),
                  extra: z.number(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeoinzip'),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoUnknown').optional(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeounknown'),
                }),
                z.object({
                  condition_type: z.literal('IPGeoZip').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialAge').optional(),
                  field: z.literal('social_age'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                }),
                z.object({
                  condition_type: z.literal('SocialGender').optional(),
                  field: z.literal('social_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('SocialInfluence').optional(),
                  field: z.literal('social_influence'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkMember').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.union([
                    z.literal('twitter'),
                    z.literal('facebook'),
                    z.literal('linkedin'),
                    z.literal('flickr'),
                    z.literal('foursquare'),
                    z.literal('lastfm'),
                    z.literal('myspace'),
                    z.literal('quora'),
                    z.literal('vimeo'),
                    z.literal('yelp'),
                    z.literal('youtube'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkFollow').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('follow'), z.literal('notfollow')]),
                  value: z.literal('twitter_follow'),
                }),
                z.object({
                  condition_type: z.literal('AddressMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('ZipMerge').optional(),
                  extra: z.string(),
                  field: z.string(),
                  op: z.literal('geoin'),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('BirthdayMerge').optional(),
                  field: z.string(),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('DateMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('greater'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SelectMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('notcontain'),
                    z.literal('contains'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('TextMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EmailAddress').optional(),
                  field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('PredictedGender').optional(),
                  field: z.literal('predicted_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('PredictedAge').optional(),
                  field: z.literal('predicted_age_range'),
                  op: z.literal('is'),
                  value: z.union([
                    z.literal('18-24'),
                    z.literal('25-34'),
                    z.literal('35-44'),
                    z.literal('45-54'),
                    z.literal('55-64'),
                    z.literal('65+'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('NewSubscribers').optional(),
                  field: z.literal('timestamp_opt').optional(),
                  op: z.literal('date_within').optional(),
                  value: z.string().optional(),
                }),
              ]),
            )
            .optional(),
          match: z.union([z.literal('any'), z.literal('all')]).optional(),
          prebuilt_segment_id: z.string().optional(),
          saved_segment_id: z.number().optional(),
        })
        .optional(),
      segment_text: z.string().optional(),
    })
    .optional(),
  report_summary: z
    .object({
      click_rate: z.number().optional(),
      clicks: z.number().optional(),
      ecommerce: z
        .object({
          total_orders: z.number().optional(),
          total_revenue: z.number().optional(),
          total_spent: z.number().optional(),
        })
        .optional(),
      open_rate: z.number().optional(),
      opens: z.number().optional(),
      subscriber_clicks: z.number().optional(),
      unique_opens: z.number().optional(),
    })
    .optional(),
  resendable: z.boolean().optional(),
  rss_opts: z
    .object({
      constrain_rss_img: z.boolean().optional(),
      feed_url: z.string(),
      frequency: z.union([z.literal('daily'), z.literal('weekly'), z.literal('monthly')]),
      last_sent: z.string().optional(),
      schedule: z
        .object({
          daily_send: z
            .object({
              friday: z.boolean().optional(),
              monday: z.boolean().optional(),
              saturday: z.boolean().optional(),
              sunday: z.boolean().optional(),
              thursday: z.boolean().optional(),
              tuesday: z.boolean().optional(),
              wednesday: z.boolean().optional(),
            })
            .optional(),
          hour: z.number().optional(),
          monthly_send_date: z.number().optional(),
          weekly_send_day: z
            .union([
              z.literal('sunday'),
              z.literal('monday'),
              z.literal('tuesday'),
              z.literal('wednesday'),
              z.literal('thursday'),
              z.literal('friday'),
              z.literal('saturday'),
            ])
            .optional(),
        })
        .optional(),
    })
    .optional(),
  send_time: z.string().optional(),
  settings: z
    .object({
      authenticate: z.boolean().optional(),
      auto_fb_post: z.array(z.string()).optional(),
      auto_footer: z.boolean().optional(),
      auto_tweet: z.boolean().optional(),
      drag_and_drop: z.boolean().optional(),
      fb_comments: z.boolean().optional(),
      folder_id: z.string().optional(),
      from_name: z.string().optional(),
      inline_css: z.boolean().optional(),
      preview_text: z.string().optional(),
      reply_to: z.string().optional(),
      subject_line: z.string().optional(),
      template_id: z.number().optional(),
      timewarp: z.boolean().optional(),
      title: z.string().optional(),
      to_name: z.string().optional(),
      use_conversation: z.boolean().optional(),
    })
    .optional(),
  social_card: z
    .object({
      description: z.string().optional(),
      image_url: z.string().optional(),
      title: z.string().optional(),
    })
    .optional(),
  status: z
    .union([
      z.literal('save'),
      z.literal('paused'),
      z.literal('schedule'),
      z.literal('sending'),
      z.literal('sent'),
      z.literal('canceled'),
      z.literal('canceling'),
      z.literal('archived'),
    ])
    .optional(),
  tracking: z
    .object({
      capsule: z
        .object({
          notes: z.boolean().optional(),
        })
        .optional(),
      clicktale: z.string().optional(),
      ecomm360: z.boolean().optional(),
      goal_tracking: z.boolean().optional(),
      google_analytics: z.string().optional(),
      html_clicks: z.boolean().optional(),
      opens: z.boolean().optional(),
      salesforce: z
        .object({
          campaign: z.boolean().optional(),
          notes: z.boolean().optional(),
        })
        .optional(),
      text_clicks: z.boolean().optional(),
    })
    .optional(),
  type: z.union([
    z.literal('regular'),
    z.literal('plaintext'),
    z.literal('absplit'),
    z.literal('rss'),
    z.literal('variate'),
  ]),
  variate_settings: z
    .object({
      combinations: z
        .array(
          z.object({
            content_description: z.number().optional(),
            from_name: z.number().optional(),
            id: z.string().optional(),
            recipients: z.number().optional(),
            reply_to: z.number().optional(),
            send_time: z.number().optional(),
            subject_line: z.number().optional(),
          }),
        )
        .optional(),
      contents: z.array(z.string()).optional(),
      from_names: z.array(z.string()).optional(),
      reply_to_addresses: z.array(z.string()).optional(),
      send_times: z.array(z.string()).optional(),
      subject_lines: z.array(z.string()).optional(),
      test_size: z.number().optional(),
      wait_time: z.number().optional(),
      winner_criteria: z.union([
        z.literal('opens'),
        z.literal('clicks'),
        z.literal('manual'),
        z.literal('total_revenue'),
      ]),
      winning_campaign_id: z.string().optional(),
      winning_combination_id: z.string().optional(),
    })
    .optional(),
  web_id: z.number().optional(),
});

export const postCampaignsIdActionsReplicateErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postCampaignsIdActionsResumeDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
  }),
});

export const postCampaignsIdActionsResumeResponseSchema = z.any();

export const postCampaignsIdActionsResumeErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postCampaignsIdActionsScheduleDataSchema = z.object({
  body: z.object({
    batch_delivery: z
      .object({
        batch_count: z.number(),
        batch_delay: z.number(),
      })
      .optional(),
    schedule_time: z.string(),
    timewarp: z.boolean().optional(),
  }),
  path: z.object({
    campaign_id: z.string(),
  }),
});

export const postCampaignsIdActionsScheduleResponseSchema = z.any();

export const postCampaignsIdActionsScheduleErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postCampaignsIdActionsSendDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
  }),
});

export const postCampaignsIdActionsSendResponseSchema = z.any();

export const postCampaignsIdActionsSendErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postCampaignsIdActionsTestDataSchema = z.object({
  body: z.object({
    send_type: z.union([z.literal('html'), z.literal('plaintext')]),
    test_emails: z.array(z.string()),
  }),
  path: z.object({
    campaign_id: z.string(),
  }),
});

export const postCampaignsIdActionsTestResponseSchema = z.any();

export const postCampaignsIdActionsTestErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postCampaignsIdActionsUnscheduleDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
  }),
});

export const postCampaignsIdActionsUnscheduleResponseSchema = z.any();

export const postCampaignsIdActionsUnscheduleErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getCampaignsIdContentDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getCampaignsIdContentResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  archive_html: z.string().optional(),
  html: z.string().optional(),
  plain_text: z.string().optional(),
  variate_contents: z
    .array(
      z.object({
        content_label: z.string().optional(),
        html: z.string().optional(),
        plain_text: z.string().optional(),
      }),
    )
    .optional(),
});

export const getCampaignsIdContentErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const putCampaignsIdContentDataSchema = z.object({
  body: z.object({
    archive: z
      .object({
        archive_content: z.string(),
        archive_type: z
          .union([
            z.literal('zip'),
            z.literal('tar.gz'),
            z.literal('tar.bz2'),
            z.literal('tar'),
            z.literal('tgz'),
            z.literal('tbz'),
          ])
          .optional(),
      })
      .optional(),
    html: z.string().optional(),
    plain_text: z.string().optional(),
    template: z
      .object({
        id: z.number(),
        sections: z.record(z.unknown()).optional(),
      })
      .optional(),
    url: z.string().optional(),
    variate_contents: z
      .array(
        z.object({
          archive: z
            .object({
              archive_content: z.string(),
              archive_type: z
                .union([
                  z.literal('zip'),
                  z.literal('tar.gz'),
                  z.literal('tar.bz2'),
                  z.literal('tar'),
                  z.literal('tgz'),
                  z.literal('tbz'),
                ])
                .optional(),
            })
            .optional(),
          content_label: z.string(),
          html: z.string().optional(),
          plain_text: z.string().optional(),
          template: z
            .object({
              id: z.number(),
              sections: z.record(z.unknown()).optional(),
            })
            .optional(),
          url: z.string().optional(),
        }),
      )
      .optional(),
  }),
  path: z.object({
    campaign_id: z.string(),
  }),
});

export const putCampaignsIdContentResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  archive_html: z.string().optional(),
  html: z.string().optional(),
  plain_text: z.string().optional(),
  variate_contents: z
    .array(
      z.object({
        content_label: z.string().optional(),
        html: z.string().optional(),
        plain_text: z.string().optional(),
      }),
    )
    .optional(),
});

export const putCampaignsIdContentErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getCampaignsIdFeedbackDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getCampaignsIdFeedbackResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  campaign_id: z.string().optional(),
  feedback: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        block_id: z.number().optional(),
        campaign_id: z.string().optional(),
        created_at: z.string().optional(),
        created_by: z.string().optional(),
        feedback_id: z.number().optional(),
        is_complete: z.boolean().optional(),
        message: z.string(),
        parent_id: z.number().optional(),
        source: z
          .union([
            z.literal('api'),
            z.literal('email'),
            z.literal('sms'),
            z.literal('web'),
            z.literal('ios'),
            z.literal('android'),
          ])
          .optional(),
        updated_at: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getCampaignsIdFeedbackErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postCampaignsIdFeedbackDataSchema = z.object({
  body: z.object({
    block_id: z.number().optional(),
    is_complete: z.boolean().optional(),
    message: z.string(),
  }),
  path: z.object({
    campaign_id: z.string(),
  }),
});

export const postCampaignsIdFeedbackResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  block_id: z.number().optional(),
  campaign_id: z.string().optional(),
  created_at: z.string().optional(),
  created_by: z.string().optional(),
  feedback_id: z.number().optional(),
  is_complete: z.boolean().optional(),
  message: z.string().optional(),
  parent_id: z.number().optional(),
  source: z
    .union([
      z.literal('api'),
      z.literal('email'),
      z.literal('sms'),
      z.literal('web'),
      z.literal('ios'),
      z.literal('android'),
    ])
    .optional(),
  updated_at: z.string().optional(),
});

export const postCampaignsIdFeedbackErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteCampaignsIdFeedbackIdDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
    feedback_id: z.string(),
  }),
});

export const deleteCampaignsIdFeedbackIdResponseSchema = z.any();

export const deleteCampaignsIdFeedbackIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getCampaignsIdFeedbackIdDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
    feedback_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getCampaignsIdFeedbackIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  block_id: z.number().optional(),
  campaign_id: z.string().optional(),
  created_at: z.string().optional(),
  created_by: z.string().optional(),
  feedback_id: z.number().optional(),
  is_complete: z.boolean().optional(),
  message: z.string().optional(),
  parent_id: z.number().optional(),
  source: z
    .union([
      z.literal('api'),
      z.literal('email'),
      z.literal('sms'),
      z.literal('web'),
      z.literal('ios'),
      z.literal('android'),
    ])
    .optional(),
  updated_at: z.string().optional(),
});

export const getCampaignsIdFeedbackIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchCampaignsIdFeedbackIdDataSchema = z.object({
  body: z.object({
    block_id: z.number().optional(),
    is_complete: z.boolean().optional(),
    message: z.string().optional(),
  }),
  path: z.object({
    campaign_id: z.string(),
    feedback_id: z.string(),
  }),
});

export const patchCampaignsIdFeedbackIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  block_id: z.number().optional(),
  campaign_id: z.string().optional(),
  created_at: z.string().optional(),
  created_by: z.string().optional(),
  feedback_id: z.number().optional(),
  is_complete: z.boolean().optional(),
  message: z.string().optional(),
  parent_id: z.number().optional(),
  source: z
    .union([
      z.literal('api'),
      z.literal('email'),
      z.literal('sms'),
      z.literal('web'),
      z.literal('ios'),
      z.literal('android'),
    ])
    .optional(),
  updated_at: z.string().optional(),
});

export const patchCampaignsIdFeedbackIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getCampaignsIdSendChecklistDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getCampaignsIdSendChecklistResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  is_ready: z.boolean().optional(),
  items: z
    .array(
      z.object({
        details: z.string().optional(),
        heading: z.string().optional(),
        id: z.number().optional(),
        type: z.union([z.literal('success'), z.literal('warning'), z.literal('error')]).optional(),
      }),
    )
    .optional(),
});

export const getCampaignsIdSendChecklistErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getConnectedSitesDataSchema = z.object({
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getConnectedSitesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  sites: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        created_at: z.string().optional(),
        domain: z.string().optional(),
        foreign_id: z.string().optional(),
        platform: z.string().optional(),
        site_script: z
          .object({
            fragment: z.string().optional(),
            url: z.string().optional(),
          })
          .optional(),
        store_id: z.string().optional(),
        updated_at: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getConnectedSitesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postConnectedSitesDataSchema = z.object({
  body: z.object({
    domain: z.string(),
    foreign_id: z.string(),
  }),
});

export const postConnectedSitesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  created_at: z.string().optional(),
  domain: z.string().optional(),
  foreign_id: z.string().optional(),
  platform: z.string().optional(),
  site_script: z
    .object({
      fragment: z.string().optional(),
      url: z.string().optional(),
    })
    .optional(),
  store_id: z.string().optional(),
  updated_at: z.string().optional(),
});

export const postConnectedSitesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteConnectedSitesIdDataSchema = z.object({
  path: z.object({
    connected_site_id: z.string(),
  }),
});

export const deleteConnectedSitesIdResponseSchema = z.any();

export const deleteConnectedSitesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getConnectedSitesIdDataSchema = z.object({
  path: z.object({
    connected_site_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getConnectedSitesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  created_at: z.string().optional(),
  domain: z.string().optional(),
  foreign_id: z.string().optional(),
  platform: z.string().optional(),
  site_script: z
    .object({
      fragment: z.string().optional(),
      url: z.string().optional(),
    })
    .optional(),
  store_id: z.string().optional(),
  updated_at: z.string().optional(),
});

export const getConnectedSitesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postConnectedSitesIdActionsVerifyScriptInstallationDataSchema = z.object({
  path: z.object({
    connected_site_id: z.string(),
  }),
});

export const postConnectedSitesIdActionsVerifyScriptInstallationResponseSchema = z.any();

export const postConnectedSitesIdActionsVerifyScriptInstallationErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getConversationsDataSchema = z.object({
  query: z
    .object({
      campaign_id: z.string().optional(),
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      has_unread_messages: z.union([z.literal('true'), z.literal('false')]).optional(),
      list_id: z.string().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getConversationsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  conversations: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        campaign_id: z.string().optional(),
        from_email: z.string().optional(),
        from_label: z.string().optional(),
        id: z.string().optional(),
        last_message: z
          .object({
            from_email: z.string().optional(),
            from_label: z.string().optional(),
            message: z.string().optional(),
            read: z.boolean().optional(),
            subject: z.string().optional(),
            timestamp: z.string().optional(),
          })
          .optional(),
        list_id: z.string().optional(),
        message_count: z.number().optional(),
        subject: z.string().optional(),
        unread_messages: z.number().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getConversationsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getConversationsIdDataSchema = z.object({
  path: z.object({
    conversation_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getConversationsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  campaign_id: z.string().optional(),
  from_email: z.string().optional(),
  from_label: z.string().optional(),
  id: z.string().optional(),
  last_message: z
    .object({
      from_email: z.string().optional(),
      from_label: z.string().optional(),
      message: z.string().optional(),
      read: z.boolean().optional(),
      subject: z.string().optional(),
      timestamp: z.string().optional(),
    })
    .optional(),
  list_id: z.string().optional(),
  message_count: z.number().optional(),
  subject: z.string().optional(),
  unread_messages: z.number().optional(),
});

export const getConversationsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getConversationsIdMessagesDataSchema = z.object({
  path: z.object({
    conversation_id: z.string(),
  }),
  query: z
    .object({
      before_timestamp: z.string().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      is_read: z.union([z.literal('true'), z.literal('false')]).optional(),
      since_timestamp: z.string().optional(),
    })
    .optional(),
});

export const getConversationsIdMessagesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  conversation_id: z.string().optional(),
  conversation_messages: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        conversation_id: z.string().optional(),
        from_email: z.string().optional(),
        from_label: z.string().optional(),
        id: z.string().optional(),
        list_id: z.number().optional(),
        message: z.string().optional(),
        read: z.boolean().optional(),
        subject: z.string().optional(),
        timestamp: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getConversationsIdMessagesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getConversationsIdMessagesIdDataSchema = z.object({
  path: z.object({
    conversation_id: z.string(),
    message_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getConversationsIdMessagesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  conversation_id: z.string().optional(),
  from_email: z.string().optional(),
  from_label: z.string().optional(),
  id: z.string().optional(),
  list_id: z.number().optional(),
  message: z.string().optional(),
  read: z.boolean().optional(),
  subject: z.string().optional(),
  timestamp: z.string().optional(),
});

export const getConversationsIdMessagesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postCustomerJourneysJourneysIdStepsIdActionsTriggerDataSchema = z.object({
  body: z.object({
    email_address: z.string(),
  }),
  path: z.object({
    journey_id: z.number(),
    step_id: z.number(),
  }),
});

export const postCustomerJourneysJourneysIdStepsIdActionsTriggerResponseSchema = z.unknown();

export const postCustomerJourneysJourneysIdStepsIdActionsTriggerErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceOrdersDataSchema = z.object({
  query: z
    .object({
      campaign_id: z.string().optional(),
      count: z.number().optional(),
      customer_id: z.string().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      has_outreach: z.boolean().optional(),
      offset: z.number().optional(),
      outreach_id: z.string().optional(),
    })
    .optional(),
});

export const getEcommerceOrdersResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  orders: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        billing_address: z
          .object({
            address1: z.string().optional(),
            address2: z.string().optional(),
            city: z.string().optional(),
            company: z.string().optional(),
            country: z.string().optional(),
            country_code: z.string().optional(),
            latitude: z.number().optional(),
            longitude: z.number().optional(),
            name: z.string().optional(),
            phone: z.string().optional(),
            postal_code: z.string().optional(),
            province: z.string().optional(),
            province_code: z.string().optional(),
          })
          .optional(),
        campaign_id: z.string().optional(),
        cancelled_at_foreign: z.string().optional(),
        currency_code: z.string().optional(),
        customer: z
          .object({
            _links: z
              .array(
                z.object({
                  href: z.string().optional(),
                  method: z
                    .union([
                      z.literal('GET'),
                      z.literal('POST'),
                      z.literal('PUT'),
                      z.literal('PATCH'),
                      z.literal('DELETE'),
                      z.literal('OPTIONS'),
                      z.literal('HEAD'),
                    ])
                    .optional(),
                  rel: z.string().optional(),
                  schema: z.string().optional(),
                  targetSchema: z.string().optional(),
                }),
              )
              .optional(),
            address: z
              .object({
                address1: z.string().optional(),
                address2: z.string().optional(),
                city: z.string().optional(),
                country: z.string().optional(),
                country_code: z.string().optional(),
                postal_code: z.string().optional(),
                province: z.string().optional(),
                province_code: z.string().optional(),
              })
              .optional(),
            company: z.string().optional(),
            created_at: z.string().optional(),
            email_address: z.string().optional(),
            first_name: z.string().optional(),
            id: z.string().optional(),
            last_name: z.string().optional(),
            opt_in_status: z.boolean().optional(),
            orders_count: z.number().optional(),
            total_spent: z.number().optional(),
            updated_at: z.string().optional(),
          })
          .optional(),
        discount_total: z.number().optional(),
        financial_status: z.string().optional(),
        fulfillment_status: z.string().optional(),
        id: z.string().optional(),
        landing_site: z.string().optional(),
        lines: z
          .array(
            z.object({
              _links: z
                .array(
                  z.object({
                    href: z.string().optional(),
                    method: z
                      .union([
                        z.literal('GET'),
                        z.literal('POST'),
                        z.literal('PUT'),
                        z.literal('PATCH'),
                        z.literal('DELETE'),
                        z.literal('OPTIONS'),
                        z.literal('HEAD'),
                      ])
                      .optional(),
                    rel: z.string().optional(),
                    schema: z.string().optional(),
                    targetSchema: z.string().optional(),
                  }),
                )
                .optional(),
              discount: z.number().optional(),
              id: z.string().optional(),
              image_url: z.string().optional(),
              price: z.number().optional(),
              product_id: z.string().optional(),
              product_title: z.string().optional(),
              product_variant_id: z.string().optional(),
              product_variant_title: z.string().optional(),
              quantity: z.number().optional(),
            }),
          )
          .optional(),
        order_total: z.number().optional(),
        order_url: z.string().optional(),
        outreach: z
          .object({
            id: z.string().optional(),
            name: z.string().optional(),
            published_time: z.string().optional(),
            type: z.string().optional(),
          })
          .optional(),
        processed_at_foreign: z.string().optional(),
        promos: z
          .array(
            z.object({
              amount_discounted: z.number().optional(),
              code: z.string().optional(),
              type: z.union([z.literal('fixed'), z.literal('percentage')]).optional(),
            }),
          )
          .optional(),
        shipping_address: z
          .object({
            address1: z.string().optional(),
            address2: z.string().optional(),
            city: z.string().optional(),
            company: z.string().optional(),
            country: z.string().optional(),
            country_code: z.string().optional(),
            latitude: z.number().optional(),
            longitude: z.number().optional(),
            name: z.string().optional(),
            phone: z.string().optional(),
            postal_code: z.string().optional(),
            province: z.string().optional(),
            province_code: z.string().optional(),
          })
          .optional(),
        shipping_total: z.number().optional(),
        store_id: z.string().optional(),
        tax_total: z.number().optional(),
        tracking_carrier: z.string().optional(),
        tracking_code: z.literal('prec').optional(),
        tracking_number: z.string().optional(),
        tracking_url: z.string().optional(),
        updated_at_foreign: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getEcommerceOrdersErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresDataSchema = z.object({
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getEcommerceStoresResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  stores: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        address: z
          .object({
            address1: z.string().optional(),
            address2: z.string().optional(),
            city: z.string().optional(),
            country: z.string().optional(),
            country_code: z.string().optional(),
            latitude: z.number().optional(),
            longitude: z.number().optional(),
            postal_code: z.string().optional(),
            province: z.string().optional(),
            province_code: z.string().optional(),
          })
          .optional(),
        automations: z
          .object({
            abandoned_browse: z
              .object({
                id: z.string().optional(),
                is_supported: z.boolean().optional(),
                status: z.union([z.literal('save'), z.literal('sending'), z.literal('paused')]).optional(),
              })
              .optional(),
            abandoned_cart: z
              .object({
                id: z.string().optional(),
                is_supported: z.boolean().optional(),
                status: z.union([z.literal('save'), z.literal('sending'), z.literal('paused')]).optional(),
              })
              .optional(),
          })
          .optional(),
        connected_site: z
          .object({
            site_foreign_id: z.string().optional(),
            site_script: z
              .object({
                fragment: z.string().optional(),
                url: z.string().optional(),
              })
              .optional(),
          })
          .optional(),
        created_at: z.string().optional(),
        currency_code: z.string().optional(),
        domain: z.string().optional(),
        email_address: z.string().optional(),
        id: z.string().optional(),
        is_syncing: z.boolean().optional(),
        list_id: z.string().optional(),
        list_is_active: z.boolean().optional(),
        money_format: z.string().optional(),
        name: z.string().optional(),
        phone: z.string().optional(),
        platform: z.string().optional(),
        primary_locale: z.string().optional(),
        timezone: z.string().optional(),
        updated_at: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getEcommerceStoresErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postEcommerceStoresDataSchema = z.object({
  body: z.object({
    address: z
      .object({
        address1: z.string().optional(),
        address2: z.string().optional(),
        city: z.string().optional(),
        country: z.string().optional(),
        country_code: z.string().optional(),
        latitude: z.number().optional(),
        longitude: z.number().optional(),
        postal_code: z.string().optional(),
        province: z.string().optional(),
        province_code: z.string().optional(),
      })
      .optional(),
    currency_code: z.string(),
    domain: z.string().optional(),
    email_address: z.string().optional(),
    id: z.string(),
    is_syncing: z.boolean().optional(),
    list_id: z.string(),
    money_format: z.string().optional(),
    name: z.string(),
    phone: z.string().optional(),
    platform: z.string().optional(),
    primary_locale: z.string().optional(),
    timezone: z.string().optional(),
  }),
});

export const postEcommerceStoresResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  address: z
    .object({
      address1: z.string().optional(),
      address2: z.string().optional(),
      city: z.string().optional(),
      country: z.string().optional(),
      country_code: z.string().optional(),
      latitude: z.number().optional(),
      longitude: z.number().optional(),
      postal_code: z.string().optional(),
      province: z.string().optional(),
      province_code: z.string().optional(),
    })
    .optional(),
  automations: z
    .object({
      abandoned_browse: z
        .object({
          id: z.string().optional(),
          is_supported: z.boolean().optional(),
          status: z.union([z.literal('save'), z.literal('sending'), z.literal('paused')]).optional(),
        })
        .optional(),
      abandoned_cart: z
        .object({
          id: z.string().optional(),
          is_supported: z.boolean().optional(),
          status: z.union([z.literal('save'), z.literal('sending'), z.literal('paused')]).optional(),
        })
        .optional(),
    })
    .optional(),
  connected_site: z
    .object({
      site_foreign_id: z.string().optional(),
      site_script: z
        .object({
          fragment: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  created_at: z.string().optional(),
  currency_code: z.string().optional(),
  domain: z.string().optional(),
  email_address: z.string().optional(),
  id: z.string().optional(),
  is_syncing: z.boolean().optional(),
  list_id: z.string().optional(),
  list_is_active: z.boolean().optional(),
  money_format: z.string().optional(),
  name: z.string().optional(),
  phone: z.string().optional(),
  platform: z.string().optional(),
  primary_locale: z.string().optional(),
  timezone: z.string().optional(),
  updated_at: z.string().optional(),
});

export const postEcommerceStoresErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteEcommerceStoresIdDataSchema = z.object({
  path: z.object({
    store_id: z.string(),
  }),
});

export const deleteEcommerceStoresIdResponseSchema = z.unknown();

export const deleteEcommerceStoresIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdDataSchema = z.object({
  path: z.object({
    store_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  address: z
    .object({
      address1: z.string().optional(),
      address2: z.string().optional(),
      city: z.string().optional(),
      country: z.string().optional(),
      country_code: z.string().optional(),
      latitude: z.number().optional(),
      longitude: z.number().optional(),
      postal_code: z.string().optional(),
      province: z.string().optional(),
      province_code: z.string().optional(),
    })
    .optional(),
  automations: z
    .object({
      abandoned_browse: z
        .object({
          id: z.string().optional(),
          is_supported: z.boolean().optional(),
          status: z.union([z.literal('save'), z.literal('sending'), z.literal('paused')]).optional(),
        })
        .optional(),
      abandoned_cart: z
        .object({
          id: z.string().optional(),
          is_supported: z.boolean().optional(),
          status: z.union([z.literal('save'), z.literal('sending'), z.literal('paused')]).optional(),
        })
        .optional(),
    })
    .optional(),
  connected_site: z
    .object({
      site_foreign_id: z.string().optional(),
      site_script: z
        .object({
          fragment: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  created_at: z.string().optional(),
  currency_code: z.string().optional(),
  domain: z.string().optional(),
  email_address: z.string().optional(),
  id: z.string().optional(),
  is_syncing: z.boolean().optional(),
  list_id: z.string().optional(),
  list_is_active: z.boolean().optional(),
  money_format: z.string().optional(),
  name: z.string().optional(),
  phone: z.string().optional(),
  platform: z.string().optional(),
  primary_locale: z.string().optional(),
  timezone: z.string().optional(),
  updated_at: z.string().optional(),
});

export const getEcommerceStoresIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchEcommerceStoresIdDataSchema = z.object({
  body: z.object({
    address: z
      .object({
        address1: z.string().optional(),
        address2: z.string().optional(),
        city: z.string().optional(),
        country: z.string().optional(),
        country_code: z.string().optional(),
        latitude: z.number().optional(),
        longitude: z.number().optional(),
        postal_code: z.string().optional(),
        province: z.string().optional(),
        province_code: z.string().optional(),
      })
      .optional(),
    currency_code: z.string().optional(),
    domain: z.string().optional(),
    email_address: z.string().optional(),
    is_syncing: z.boolean().optional(),
    money_format: z.string().optional(),
    name: z.string().optional(),
    phone: z.string().optional(),
    platform: z.string().optional(),
    primary_locale: z.string().optional(),
    timezone: z.string().optional(),
  }),
  path: z.object({
    store_id: z.string(),
  }),
});

export const patchEcommerceStoresIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  address: z
    .object({
      address1: z.string().optional(),
      address2: z.string().optional(),
      city: z.string().optional(),
      country: z.string().optional(),
      country_code: z.string().optional(),
      latitude: z.number().optional(),
      longitude: z.number().optional(),
      postal_code: z.string().optional(),
      province: z.string().optional(),
      province_code: z.string().optional(),
    })
    .optional(),
  automations: z
    .object({
      abandoned_browse: z
        .object({
          id: z.string().optional(),
          is_supported: z.boolean().optional(),
          status: z.union([z.literal('save'), z.literal('sending'), z.literal('paused')]).optional(),
        })
        .optional(),
      abandoned_cart: z
        .object({
          id: z.string().optional(),
          is_supported: z.boolean().optional(),
          status: z.union([z.literal('save'), z.literal('sending'), z.literal('paused')]).optional(),
        })
        .optional(),
    })
    .optional(),
  connected_site: z
    .object({
      site_foreign_id: z.string().optional(),
      site_script: z
        .object({
          fragment: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  created_at: z.string().optional(),
  currency_code: z.string().optional(),
  domain: z.string().optional(),
  email_address: z.string().optional(),
  id: z.string().optional(),
  is_syncing: z.boolean().optional(),
  list_id: z.string().optional(),
  list_is_active: z.boolean().optional(),
  money_format: z.string().optional(),
  name: z.string().optional(),
  phone: z.string().optional(),
  platform: z.string().optional(),
  primary_locale: z.string().optional(),
  timezone: z.string().optional(),
  updated_at: z.string().optional(),
});

export const patchEcommerceStoresIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdCartsDataSchema = z.object({
  path: z.object({
    store_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdCartsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  carts: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        campaign_id: z.string().optional(),
        checkout_url: z.string().optional(),
        created_at: z.string().optional(),
        currency_code: z.string().optional(),
        customer: z
          .object({
            _links: z
              .array(
                z.object({
                  href: z.string().optional(),
                  method: z
                    .union([
                      z.literal('GET'),
                      z.literal('POST'),
                      z.literal('PUT'),
                      z.literal('PATCH'),
                      z.literal('DELETE'),
                      z.literal('OPTIONS'),
                      z.literal('HEAD'),
                    ])
                    .optional(),
                  rel: z.string().optional(),
                  schema: z.string().optional(),
                  targetSchema: z.string().optional(),
                }),
              )
              .optional(),
            address: z
              .object({
                address1: z.string().optional(),
                address2: z.string().optional(),
                city: z.string().optional(),
                country: z.string().optional(),
                country_code: z.string().optional(),
                postal_code: z.string().optional(),
                province: z.string().optional(),
                province_code: z.string().optional(),
              })
              .optional(),
            company: z.string().optional(),
            created_at: z.string().optional(),
            email_address: z.string().optional(),
            first_name: z.string().optional(),
            id: z.string().optional(),
            last_name: z.string().optional(),
            opt_in_status: z.boolean().optional(),
            orders_count: z.number().optional(),
            total_spent: z.number().optional(),
            updated_at: z.string().optional(),
          })
          .optional(),
        id: z.string().optional(),
        lines: z
          .array(
            z.object({
              _links: z
                .array(
                  z.object({
                    href: z.string().optional(),
                    method: z
                      .union([
                        z.literal('GET'),
                        z.literal('POST'),
                        z.literal('PUT'),
                        z.literal('PATCH'),
                        z.literal('DELETE'),
                        z.literal('OPTIONS'),
                        z.literal('HEAD'),
                      ])
                      .optional(),
                    rel: z.string().optional(),
                    schema: z.string().optional(),
                    targetSchema: z.string().optional(),
                  }),
                )
                .optional(),
              id: z.string().optional(),
              price: z.number().optional(),
              product_id: z.string().optional(),
              product_title: z.string().optional(),
              product_variant_id: z.string().optional(),
              product_variant_title: z.string().optional(),
              quantity: z.number().optional(),
            }),
          )
          .optional(),
        order_total: z.number().optional(),
        tax_total: z.number().optional(),
        updated_at: z.string().optional(),
      }),
    )
    .optional(),
  store_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getEcommerceStoresIdCartsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postEcommerceStoresIdCartsDataSchema = z.object({
  body: z.object({
    campaign_id: z.string().optional(),
    checkout_url: z.string().optional(),
    currency_code: z.string(),
    customer: z.object({
      address: z
        .object({
          address1: z.string().optional(),
          address2: z.string().optional(),
          city: z.string().optional(),
          country: z.string().optional(),
          country_code: z.string().optional(),
          postal_code: z.string().optional(),
          province: z.string().optional(),
          province_code: z.string().optional(),
        })
        .optional(),
      company: z.string().optional(),
      email_address: z.string().optional(),
      first_name: z.string().optional(),
      id: z.string(),
      last_name: z.string().optional(),
      opt_in_status: z.boolean().optional(),
    }),
    id: z.string(),
    lines: z.array(
      z.object({
        id: z.string(),
        price: z.number(),
        product_id: z.string(),
        product_variant_id: z.string(),
        quantity: z.number(),
      }),
    ),
    order_total: z.number(),
    tax_total: z.number().optional(),
  }),
  path: z.object({
    store_id: z.string(),
  }),
});

export const postEcommerceStoresIdCartsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  campaign_id: z.string().optional(),
  checkout_url: z.string().optional(),
  created_at: z.string().optional(),
  currency_code: z.string().optional(),
  customer: z
    .object({
      _links: z
        .array(
          z.object({
            href: z.string().optional(),
            method: z
              .union([
                z.literal('GET'),
                z.literal('POST'),
                z.literal('PUT'),
                z.literal('PATCH'),
                z.literal('DELETE'),
                z.literal('OPTIONS'),
                z.literal('HEAD'),
              ])
              .optional(),
            rel: z.string().optional(),
            schema: z.string().optional(),
            targetSchema: z.string().optional(),
          }),
        )
        .optional(),
      address: z
        .object({
          address1: z.string().optional(),
          address2: z.string().optional(),
          city: z.string().optional(),
          country: z.string().optional(),
          country_code: z.string().optional(),
          postal_code: z.string().optional(),
          province: z.string().optional(),
          province_code: z.string().optional(),
        })
        .optional(),
      company: z.string().optional(),
      created_at: z.string().optional(),
      email_address: z.string().optional(),
      first_name: z.string().optional(),
      id: z.string().optional(),
      last_name: z.string().optional(),
      opt_in_status: z.boolean().optional(),
      orders_count: z.number().optional(),
      total_spent: z.number().optional(),
      updated_at: z.string().optional(),
    })
    .optional(),
  id: z.string().optional(),
  lines: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        id: z.string().optional(),
        price: z.number().optional(),
        product_id: z.string().optional(),
        product_title: z.string().optional(),
        product_variant_id: z.string().optional(),
        product_variant_title: z.string().optional(),
        quantity: z.number().optional(),
      }),
    )
    .optional(),
  order_total: z.number().optional(),
  tax_total: z.number().optional(),
  updated_at: z.string().optional(),
});

export const postEcommerceStoresIdCartsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteEcommerceStoresIdCartsIdDataSchema = z.object({
  path: z.object({
    cart_id: z.string(),
    store_id: z.string(),
  }),
});

export const deleteEcommerceStoresIdCartsIdResponseSchema = z.any();

export const deleteEcommerceStoresIdCartsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdCartsIdDataSchema = z.object({
  path: z.object({
    cart_id: z.string(),
    store_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdCartsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  campaign_id: z.string().optional(),
  checkout_url: z.string().optional(),
  created_at: z.string().optional(),
  currency_code: z.string().optional(),
  customer: z
    .object({
      _links: z
        .array(
          z.object({
            href: z.string().optional(),
            method: z
              .union([
                z.literal('GET'),
                z.literal('POST'),
                z.literal('PUT'),
                z.literal('PATCH'),
                z.literal('DELETE'),
                z.literal('OPTIONS'),
                z.literal('HEAD'),
              ])
              .optional(),
            rel: z.string().optional(),
            schema: z.string().optional(),
            targetSchema: z.string().optional(),
          }),
        )
        .optional(),
      address: z
        .object({
          address1: z.string().optional(),
          address2: z.string().optional(),
          city: z.string().optional(),
          country: z.string().optional(),
          country_code: z.string().optional(),
          postal_code: z.string().optional(),
          province: z.string().optional(),
          province_code: z.string().optional(),
        })
        .optional(),
      company: z.string().optional(),
      created_at: z.string().optional(),
      email_address: z.string().optional(),
      first_name: z.string().optional(),
      id: z.string().optional(),
      last_name: z.string().optional(),
      opt_in_status: z.boolean().optional(),
      orders_count: z.number().optional(),
      total_spent: z.number().optional(),
      updated_at: z.string().optional(),
    })
    .optional(),
  id: z.string().optional(),
  lines: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        id: z.string().optional(),
        price: z.number().optional(),
        product_id: z.string().optional(),
        product_title: z.string().optional(),
        product_variant_id: z.string().optional(),
        product_variant_title: z.string().optional(),
        quantity: z.number().optional(),
      }),
    )
    .optional(),
  order_total: z.number().optional(),
  tax_total: z.number().optional(),
  updated_at: z.string().optional(),
});

export const getEcommerceStoresIdCartsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchEcommerceStoresIdCartsIdDataSchema = z.object({
  body: z.object({
    campaign_id: z.string().optional(),
    checkout_url: z.string().optional(),
    currency_code: z.string().optional(),
    customer: z
      .object({
        address: z
          .object({
            address1: z.string().optional(),
            address2: z.string().optional(),
            city: z.string().optional(),
            country: z.string().optional(),
            country_code: z.string().optional(),
            postal_code: z.string().optional(),
            province: z.string().optional(),
            province_code: z.string().optional(),
          })
          .optional(),
        company: z.string().optional(),
        first_name: z.string().optional(),
        last_name: z.string().optional(),
        opt_in_status: z.boolean().optional(),
      })
      .optional(),
    lines: z
      .array(
        z.object({
          price: z.number().optional(),
          product_id: z.string().optional(),
          product_variant_id: z.string().optional(),
          quantity: z.number().optional(),
        }),
      )
      .optional(),
    order_total: z.number().optional(),
    tax_total: z.number().optional(),
  }),
  path: z.object({
    cart_id: z.string(),
    store_id: z.string(),
  }),
});

export const patchEcommerceStoresIdCartsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  campaign_id: z.string().optional(),
  checkout_url: z.string().optional(),
  created_at: z.string().optional(),
  currency_code: z.string().optional(),
  customer: z
    .object({
      _links: z
        .array(
          z.object({
            href: z.string().optional(),
            method: z
              .union([
                z.literal('GET'),
                z.literal('POST'),
                z.literal('PUT'),
                z.literal('PATCH'),
                z.literal('DELETE'),
                z.literal('OPTIONS'),
                z.literal('HEAD'),
              ])
              .optional(),
            rel: z.string().optional(),
            schema: z.string().optional(),
            targetSchema: z.string().optional(),
          }),
        )
        .optional(),
      address: z
        .object({
          address1: z.string().optional(),
          address2: z.string().optional(),
          city: z.string().optional(),
          country: z.string().optional(),
          country_code: z.string().optional(),
          postal_code: z.string().optional(),
          province: z.string().optional(),
          province_code: z.string().optional(),
        })
        .optional(),
      company: z.string().optional(),
      created_at: z.string().optional(),
      email_address: z.string().optional(),
      first_name: z.string().optional(),
      id: z.string().optional(),
      last_name: z.string().optional(),
      opt_in_status: z.boolean().optional(),
      orders_count: z.number().optional(),
      total_spent: z.number().optional(),
      updated_at: z.string().optional(),
    })
    .optional(),
  id: z.string().optional(),
  lines: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        id: z.string().optional(),
        price: z.number().optional(),
        product_id: z.string().optional(),
        product_title: z.string().optional(),
        product_variant_id: z.string().optional(),
        product_variant_title: z.string().optional(),
        quantity: z.number().optional(),
      }),
    )
    .optional(),
  order_total: z.number().optional(),
  tax_total: z.number().optional(),
  updated_at: z.string().optional(),
});

export const patchEcommerceStoresIdCartsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdCartsIdLinesDataSchema = z.object({
  path: z.object({
    cart_id: z.string(),
    store_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdCartsIdLinesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  cart_id: z.string().optional(),
  lines: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        id: z.string().optional(),
        price: z.number().optional(),
        product_id: z.string().optional(),
        product_title: z.string().optional(),
        product_variant_id: z.string().optional(),
        product_variant_title: z.string().optional(),
        quantity: z.number().optional(),
      }),
    )
    .optional(),
  store_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getEcommerceStoresIdCartsIdLinesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postEcommerceStoresIdCartsIdLinesDataSchema = z.object({
  body: z.object({
    id: z.string(),
    price: z.number(),
    product_id: z.string(),
    product_variant_id: z.string(),
    quantity: z.number(),
  }),
  path: z.object({
    cart_id: z.string(),
    store_id: z.string(),
  }),
});

export const postEcommerceStoresIdCartsIdLinesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  id: z.string().optional(),
  price: z.number().optional(),
  product_id: z.string().optional(),
  product_title: z.string().optional(),
  product_variant_id: z.string().optional(),
  product_variant_title: z.string().optional(),
  quantity: z.number().optional(),
});

export const postEcommerceStoresIdCartsIdLinesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteEcommerceStoresIdCartsLinesIdDataSchema = z.object({
  path: z.object({
    cart_id: z.string(),
    line_id: z.string(),
    store_id: z.string(),
  }),
});

export const deleteEcommerceStoresIdCartsLinesIdResponseSchema = z.any();

export const deleteEcommerceStoresIdCartsLinesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdCartsIdLinesIdDataSchema = z.object({
  path: z.object({
    cart_id: z.string(),
    line_id: z.string(),
    store_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdCartsIdLinesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  id: z.string().optional(),
  price: z.number().optional(),
  product_id: z.string().optional(),
  product_title: z.string().optional(),
  product_variant_id: z.string().optional(),
  product_variant_title: z.string().optional(),
  quantity: z.number().optional(),
});

export const getEcommerceStoresIdCartsIdLinesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchEcommerceStoresIdCartsIdLinesIdDataSchema = z.object({
  body: z.object({
    price: z.number().optional(),
    product_id: z.string().optional(),
    product_variant_id: z.string().optional(),
    quantity: z.number().optional(),
  }),
  path: z.object({
    cart_id: z.string(),
    line_id: z.string(),
    store_id: z.string(),
  }),
});

export const patchEcommerceStoresIdCartsIdLinesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  id: z.string().optional(),
  price: z.number().optional(),
  product_id: z.string().optional(),
  product_title: z.string().optional(),
  product_variant_id: z.string().optional(),
  product_variant_title: z.string().optional(),
  quantity: z.number().optional(),
});

export const patchEcommerceStoresIdCartsIdLinesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdCustomersDataSchema = z.object({
  path: z.object({
    store_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      email_address: z.string().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdCustomersResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  customers: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        address: z
          .object({
            address1: z.string().optional(),
            address2: z.string().optional(),
            city: z.string().optional(),
            country: z.string().optional(),
            country_code: z.string().optional(),
            postal_code: z.string().optional(),
            province: z.string().optional(),
            province_code: z.string().optional(),
          })
          .optional(),
        company: z.string().optional(),
        created_at: z.string().optional(),
        email_address: z.string().optional(),
        first_name: z.string().optional(),
        id: z.string().optional(),
        last_name: z.string().optional(),
        opt_in_status: z.boolean().optional(),
        orders_count: z.number().optional(),
        total_spent: z.number().optional(),
        updated_at: z.string().optional(),
      }),
    )
    .optional(),
  store_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getEcommerceStoresIdCustomersErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postEcommerceStoresIdCustomersDataSchema = z.object({
  body: z.object({
    address: z
      .object({
        address1: z.string().optional(),
        address2: z.string().optional(),
        city: z.string().optional(),
        country: z.string().optional(),
        country_code: z.string().optional(),
        postal_code: z.string().optional(),
        province: z.string().optional(),
        province_code: z.string().optional(),
      })
      .optional(),
    company: z.string().optional(),
    email_address: z.string(),
    first_name: z.string().optional(),
    id: z.string(),
    last_name: z.string().optional(),
    opt_in_status: z.boolean(),
  }),
  path: z.object({
    store_id: z.string(),
  }),
});

export const postEcommerceStoresIdCustomersResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  address: z
    .object({
      address1: z.string().optional(),
      address2: z.string().optional(),
      city: z.string().optional(),
      country: z.string().optional(),
      country_code: z.string().optional(),
      postal_code: z.string().optional(),
      province: z.string().optional(),
      province_code: z.string().optional(),
    })
    .optional(),
  company: z.string().optional(),
  created_at: z.string().optional(),
  email_address: z.string().optional(),
  first_name: z.string().optional(),
  id: z.string().optional(),
  last_name: z.string().optional(),
  opt_in_status: z.boolean().optional(),
  orders_count: z.number().optional(),
  total_spent: z.number().optional(),
  updated_at: z.string().optional(),
});

export const postEcommerceStoresIdCustomersErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteEcommerceStoresIdCustomersIdDataSchema = z.object({
  path: z.object({
    customer_id: z.string(),
    store_id: z.string(),
  }),
});

export const deleteEcommerceStoresIdCustomersIdResponseSchema = z.any();

export const deleteEcommerceStoresIdCustomersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdCustomersIdDataSchema = z.object({
  path: z.object({
    customer_id: z.string(),
    store_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdCustomersIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  address: z
    .object({
      address1: z.string().optional(),
      address2: z.string().optional(),
      city: z.string().optional(),
      country: z.string().optional(),
      country_code: z.string().optional(),
      postal_code: z.string().optional(),
      province: z.string().optional(),
      province_code: z.string().optional(),
    })
    .optional(),
  company: z.string().optional(),
  created_at: z.string().optional(),
  email_address: z.string().optional(),
  first_name: z.string().optional(),
  id: z.string().optional(),
  last_name: z.string().optional(),
  opt_in_status: z.boolean().optional(),
  orders_count: z.number().optional(),
  total_spent: z.number().optional(),
  updated_at: z.string().optional(),
});

export const getEcommerceStoresIdCustomersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchEcommerceStoresIdCustomersIdDataSchema = z.object({
  body: z.object({
    address: z
      .object({
        address1: z.string().optional(),
        address2: z.string().optional(),
        city: z.string().optional(),
        country: z.string().optional(),
        country_code: z.string().optional(),
        postal_code: z.string().optional(),
        province: z.string().optional(),
        province_code: z.string().optional(),
      })
      .optional(),
    company: z.string().optional(),
    first_name: z.string().optional(),
    last_name: z.string().optional(),
    opt_in_status: z.boolean().optional(),
  }),
  path: z.object({
    customer_id: z.string(),
    store_id: z.string(),
  }),
});

export const patchEcommerceStoresIdCustomersIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  address: z
    .object({
      address1: z.string().optional(),
      address2: z.string().optional(),
      city: z.string().optional(),
      country: z.string().optional(),
      country_code: z.string().optional(),
      postal_code: z.string().optional(),
      province: z.string().optional(),
      province_code: z.string().optional(),
    })
    .optional(),
  company: z.string().optional(),
  created_at: z.string().optional(),
  email_address: z.string().optional(),
  first_name: z.string().optional(),
  id: z.string().optional(),
  last_name: z.string().optional(),
  opt_in_status: z.boolean().optional(),
  orders_count: z.number().optional(),
  total_spent: z.number().optional(),
  updated_at: z.string().optional(),
});

export const patchEcommerceStoresIdCustomersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const putEcommerceStoresIdCustomersIdDataSchema = z.object({
  body: z.object({
    address: z
      .object({
        address1: z.string().optional(),
        address2: z.string().optional(),
        city: z.string().optional(),
        country: z.string().optional(),
        country_code: z.string().optional(),
        postal_code: z.string().optional(),
        province: z.string().optional(),
        province_code: z.string().optional(),
      })
      .optional(),
    company: z.string().optional(),
    email_address: z.string(),
    first_name: z.string().optional(),
    id: z.string(),
    last_name: z.string().optional(),
    opt_in_status: z.boolean(),
  }),
  path: z.object({
    customer_id: z.string(),
    store_id: z.string(),
  }),
});

export const putEcommerceStoresIdCustomersIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  address: z
    .object({
      address1: z.string().optional(),
      address2: z.string().optional(),
      city: z.string().optional(),
      country: z.string().optional(),
      country_code: z.string().optional(),
      postal_code: z.string().optional(),
      province: z.string().optional(),
      province_code: z.string().optional(),
    })
    .optional(),
  company: z.string().optional(),
  created_at: z.string().optional(),
  email_address: z.string().optional(),
  first_name: z.string().optional(),
  id: z.string().optional(),
  last_name: z.string().optional(),
  opt_in_status: z.boolean().optional(),
  orders_count: z.number().optional(),
  total_spent: z.number().optional(),
  updated_at: z.string().optional(),
});

export const putEcommerceStoresIdCustomersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdOrdersDataSchema = z.object({
  path: z.object({
    store_id: z.string(),
  }),
  query: z
    .object({
      campaign_id: z.string().optional(),
      count: z.number().optional(),
      customer_id: z.string().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      has_outreach: z.boolean().optional(),
      offset: z.number().optional(),
      outreach_id: z.string().optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdOrdersResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  orders: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        billing_address: z
          .object({
            address1: z.string().optional(),
            address2: z.string().optional(),
            city: z.string().optional(),
            company: z.string().optional(),
            country: z.string().optional(),
            country_code: z.string().optional(),
            latitude: z.number().optional(),
            longitude: z.number().optional(),
            name: z.string().optional(),
            phone: z.string().optional(),
            postal_code: z.string().optional(),
            province: z.string().optional(),
            province_code: z.string().optional(),
          })
          .optional(),
        campaign_id: z.string().optional(),
        cancelled_at_foreign: z.string().optional(),
        currency_code: z.string().optional(),
        customer: z
          .object({
            _links: z
              .array(
                z.object({
                  href: z.string().optional(),
                  method: z
                    .union([
                      z.literal('GET'),
                      z.literal('POST'),
                      z.literal('PUT'),
                      z.literal('PATCH'),
                      z.literal('DELETE'),
                      z.literal('OPTIONS'),
                      z.literal('HEAD'),
                    ])
                    .optional(),
                  rel: z.string().optional(),
                  schema: z.string().optional(),
                  targetSchema: z.string().optional(),
                }),
              )
              .optional(),
            address: z
              .object({
                address1: z.string().optional(),
                address2: z.string().optional(),
                city: z.string().optional(),
                country: z.string().optional(),
                country_code: z.string().optional(),
                postal_code: z.string().optional(),
                province: z.string().optional(),
                province_code: z.string().optional(),
              })
              .optional(),
            company: z.string().optional(),
            created_at: z.string().optional(),
            email_address: z.string().optional(),
            first_name: z.string().optional(),
            id: z.string().optional(),
            last_name: z.string().optional(),
            opt_in_status: z.boolean().optional(),
            orders_count: z.number().optional(),
            total_spent: z.number().optional(),
            updated_at: z.string().optional(),
          })
          .optional(),
        discount_total: z.number().optional(),
        financial_status: z.string().optional(),
        fulfillment_status: z.string().optional(),
        id: z.string().optional(),
        landing_site: z.string().optional(),
        lines: z
          .array(
            z.object({
              _links: z
                .array(
                  z.object({
                    href: z.string().optional(),
                    method: z
                      .union([
                        z.literal('GET'),
                        z.literal('POST'),
                        z.literal('PUT'),
                        z.literal('PATCH'),
                        z.literal('DELETE'),
                        z.literal('OPTIONS'),
                        z.literal('HEAD'),
                      ])
                      .optional(),
                    rel: z.string().optional(),
                    schema: z.string().optional(),
                    targetSchema: z.string().optional(),
                  }),
                )
                .optional(),
              discount: z.number().optional(),
              id: z.string().optional(),
              image_url: z.string().optional(),
              price: z.number().optional(),
              product_id: z.string().optional(),
              product_title: z.string().optional(),
              product_variant_id: z.string().optional(),
              product_variant_title: z.string().optional(),
              quantity: z.number().optional(),
            }),
          )
          .optional(),
        order_total: z.number().optional(),
        order_url: z.string().optional(),
        outreach: z
          .object({
            id: z.string().optional(),
            name: z.string().optional(),
            published_time: z.string().optional(),
            type: z.string().optional(),
          })
          .optional(),
        processed_at_foreign: z.string().optional(),
        promos: z
          .array(
            z.object({
              amount_discounted: z.number().optional(),
              code: z.string().optional(),
              type: z.union([z.literal('fixed'), z.literal('percentage')]).optional(),
            }),
          )
          .optional(),
        shipping_address: z
          .object({
            address1: z.string().optional(),
            address2: z.string().optional(),
            city: z.string().optional(),
            company: z.string().optional(),
            country: z.string().optional(),
            country_code: z.string().optional(),
            latitude: z.number().optional(),
            longitude: z.number().optional(),
            name: z.string().optional(),
            phone: z.string().optional(),
            postal_code: z.string().optional(),
            province: z.string().optional(),
            province_code: z.string().optional(),
          })
          .optional(),
        shipping_total: z.number().optional(),
        store_id: z.string().optional(),
        tax_total: z.number().optional(),
        tracking_carrier: z.string().optional(),
        tracking_code: z.literal('prec').optional(),
        tracking_number: z.string().optional(),
        tracking_url: z.string().optional(),
        updated_at_foreign: z.string().optional(),
      }),
    )
    .optional(),
  store_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getEcommerceStoresIdOrdersErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postEcommerceStoresIdOrdersDataSchema = z.object({
  body: z.object({
    billing_address: z
      .object({
        address1: z.string().optional(),
        address2: z.string().optional(),
        city: z.string().optional(),
        company: z.string().optional(),
        country: z.string().optional(),
        country_code: z.string().optional(),
        latitude: z.number().optional(),
        longitude: z.number().optional(),
        name: z.string().optional(),
        phone: z.string().optional(),
        postal_code: z.string().optional(),
        province: z.string().optional(),
        province_code: z.string().optional(),
      })
      .optional(),
    campaign_id: z.string().optional(),
    cancelled_at_foreign: z.string().optional(),
    currency_code: z.string(),
    customer: z.object({
      address: z
        .object({
          address1: z.string().optional(),
          address2: z.string().optional(),
          city: z.string().optional(),
          country: z.string().optional(),
          country_code: z.string().optional(),
          postal_code: z.string().optional(),
          province: z.string().optional(),
          province_code: z.string().optional(),
        })
        .optional(),
      company: z.string().optional(),
      email_address: z.string().optional(),
      first_name: z.string().optional(),
      id: z.string(),
      last_name: z.string().optional(),
      opt_in_status: z.boolean().optional(),
    }),
    discount_total: z.number().optional(),
    financial_status: z.string().optional(),
    fulfillment_status: z.string().optional(),
    id: z.string(),
    landing_site: z.string().optional(),
    lines: z.array(
      z.object({
        discount: z.number().optional(),
        id: z.string(),
        price: z.number(),
        product_id: z.string(),
        product_variant_id: z.string(),
        quantity: z.number(),
      }),
    ),
    order_total: z.number(),
    order_url: z.string().optional(),
    outreach: z
      .object({
        id: z.string().optional(),
      })
      .optional(),
    processed_at_foreign: z.string().optional(),
    promos: z
      .array(
        z.object({
          amount_discounted: z.number(),
          code: z.string(),
          type: z.union([z.literal('fixed'), z.literal('percentage')]),
        }),
      )
      .optional(),
    shipping_address: z
      .object({
        address1: z.string().optional(),
        address2: z.string().optional(),
        city: z.string().optional(),
        company: z.string().optional(),
        country: z.string().optional(),
        country_code: z.string().optional(),
        latitude: z.number().optional(),
        longitude: z.number().optional(),
        name: z.string().optional(),
        phone: z.string().optional(),
        postal_code: z.string().optional(),
        province: z.string().optional(),
        province_code: z.string().optional(),
      })
      .optional(),
    shipping_total: z.number().optional(),
    tax_total: z.number().optional(),
    tracking_carrier: z.string().optional(),
    tracking_code: z.literal('prec').optional(),
    tracking_number: z.string().optional(),
    tracking_url: z.string().optional(),
    updated_at_foreign: z.string().optional(),
  }),
  path: z.object({
    store_id: z.string(),
  }),
});

export const postEcommerceStoresIdOrdersResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  billing_address: z
    .object({
      address1: z.string().optional(),
      address2: z.string().optional(),
      city: z.string().optional(),
      company: z.string().optional(),
      country: z.string().optional(),
      country_code: z.string().optional(),
      latitude: z.number().optional(),
      longitude: z.number().optional(),
      name: z.string().optional(),
      phone: z.string().optional(),
      postal_code: z.string().optional(),
      province: z.string().optional(),
      province_code: z.string().optional(),
    })
    .optional(),
  campaign_id: z.string().optional(),
  cancelled_at_foreign: z.string().optional(),
  currency_code: z.string().optional(),
  customer: z
    .object({
      _links: z
        .array(
          z.object({
            href: z.string().optional(),
            method: z
              .union([
                z.literal('GET'),
                z.literal('POST'),
                z.literal('PUT'),
                z.literal('PATCH'),
                z.literal('DELETE'),
                z.literal('OPTIONS'),
                z.literal('HEAD'),
              ])
              .optional(),
            rel: z.string().optional(),
            schema: z.string().optional(),
            targetSchema: z.string().optional(),
          }),
        )
        .optional(),
      address: z
        .object({
          address1: z.string().optional(),
          address2: z.string().optional(),
          city: z.string().optional(),
          country: z.string().optional(),
          country_code: z.string().optional(),
          postal_code: z.string().optional(),
          province: z.string().optional(),
          province_code: z.string().optional(),
        })
        .optional(),
      company: z.string().optional(),
      created_at: z.string().optional(),
      email_address: z.string().optional(),
      first_name: z.string().optional(),
      id: z.string().optional(),
      last_name: z.string().optional(),
      opt_in_status: z.boolean().optional(),
      orders_count: z.number().optional(),
      total_spent: z.number().optional(),
      updated_at: z.string().optional(),
    })
    .optional(),
  discount_total: z.number().optional(),
  financial_status: z.string().optional(),
  fulfillment_status: z.string().optional(),
  id: z.string().optional(),
  landing_site: z.string().optional(),
  lines: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        discount: z.number().optional(),
        id: z.string().optional(),
        image_url: z.string().optional(),
        price: z.number().optional(),
        product_id: z.string().optional(),
        product_title: z.string().optional(),
        product_variant_id: z.string().optional(),
        product_variant_title: z.string().optional(),
        quantity: z.number().optional(),
      }),
    )
    .optional(),
  order_total: z.number().optional(),
  order_url: z.string().optional(),
  outreach: z
    .object({
      id: z.string().optional(),
      name: z.string().optional(),
      published_time: z.string().optional(),
      type: z.string().optional(),
    })
    .optional(),
  processed_at_foreign: z.string().optional(),
  promos: z
    .array(
      z.object({
        amount_discounted: z.number().optional(),
        code: z.string().optional(),
        type: z.union([z.literal('fixed'), z.literal('percentage')]).optional(),
      }),
    )
    .optional(),
  shipping_address: z
    .object({
      address1: z.string().optional(),
      address2: z.string().optional(),
      city: z.string().optional(),
      company: z.string().optional(),
      country: z.string().optional(),
      country_code: z.string().optional(),
      latitude: z.number().optional(),
      longitude: z.number().optional(),
      name: z.string().optional(),
      phone: z.string().optional(),
      postal_code: z.string().optional(),
      province: z.string().optional(),
      province_code: z.string().optional(),
    })
    .optional(),
  shipping_total: z.number().optional(),
  store_id: z.string().optional(),
  tax_total: z.number().optional(),
  tracking_carrier: z.string().optional(),
  tracking_code: z.literal('prec').optional(),
  tracking_number: z.string().optional(),
  tracking_url: z.string().optional(),
  updated_at_foreign: z.string().optional(),
});

export const postEcommerceStoresIdOrdersErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteEcommerceStoresIdOrdersIdDataSchema = z.object({
  path: z.object({
    order_id: z.string(),
    store_id: z.string(),
  }),
});

export const deleteEcommerceStoresIdOrdersIdResponseSchema = z.any();

export const deleteEcommerceStoresIdOrdersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdOrdersIdDataSchema = z.object({
  path: z.object({
    order_id: z.string(),
    store_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdOrdersIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  billing_address: z
    .object({
      address1: z.string().optional(),
      address2: z.string().optional(),
      city: z.string().optional(),
      company: z.string().optional(),
      country: z.string().optional(),
      country_code: z.string().optional(),
      latitude: z.number().optional(),
      longitude: z.number().optional(),
      name: z.string().optional(),
      phone: z.string().optional(),
      postal_code: z.string().optional(),
      province: z.string().optional(),
      province_code: z.string().optional(),
    })
    .optional(),
  campaign_id: z.string().optional(),
  cancelled_at_foreign: z.string().optional(),
  currency_code: z.string().optional(),
  customer: z
    .object({
      _links: z
        .array(
          z.object({
            href: z.string().optional(),
            method: z
              .union([
                z.literal('GET'),
                z.literal('POST'),
                z.literal('PUT'),
                z.literal('PATCH'),
                z.literal('DELETE'),
                z.literal('OPTIONS'),
                z.literal('HEAD'),
              ])
              .optional(),
            rel: z.string().optional(),
            schema: z.string().optional(),
            targetSchema: z.string().optional(),
          }),
        )
        .optional(),
      address: z
        .object({
          address1: z.string().optional(),
          address2: z.string().optional(),
          city: z.string().optional(),
          country: z.string().optional(),
          country_code: z.string().optional(),
          postal_code: z.string().optional(),
          province: z.string().optional(),
          province_code: z.string().optional(),
        })
        .optional(),
      company: z.string().optional(),
      created_at: z.string().optional(),
      email_address: z.string().optional(),
      first_name: z.string().optional(),
      id: z.string().optional(),
      last_name: z.string().optional(),
      opt_in_status: z.boolean().optional(),
      orders_count: z.number().optional(),
      total_spent: z.number().optional(),
      updated_at: z.string().optional(),
    })
    .optional(),
  discount_total: z.number().optional(),
  financial_status: z.string().optional(),
  fulfillment_status: z.string().optional(),
  id: z.string().optional(),
  landing_site: z.string().optional(),
  lines: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        discount: z.number().optional(),
        id: z.string().optional(),
        image_url: z.string().optional(),
        price: z.number().optional(),
        product_id: z.string().optional(),
        product_title: z.string().optional(),
        product_variant_id: z.string().optional(),
        product_variant_title: z.string().optional(),
        quantity: z.number().optional(),
      }),
    )
    .optional(),
  order_total: z.number().optional(),
  order_url: z.string().optional(),
  outreach: z
    .object({
      id: z.string().optional(),
      name: z.string().optional(),
      published_time: z.string().optional(),
      type: z.string().optional(),
    })
    .optional(),
  processed_at_foreign: z.string().optional(),
  promos: z
    .array(
      z.object({
        amount_discounted: z.number().optional(),
        code: z.string().optional(),
        type: z.union([z.literal('fixed'), z.literal('percentage')]).optional(),
      }),
    )
    .optional(),
  shipping_address: z
    .object({
      address1: z.string().optional(),
      address2: z.string().optional(),
      city: z.string().optional(),
      company: z.string().optional(),
      country: z.string().optional(),
      country_code: z.string().optional(),
      latitude: z.number().optional(),
      longitude: z.number().optional(),
      name: z.string().optional(),
      phone: z.string().optional(),
      postal_code: z.string().optional(),
      province: z.string().optional(),
      province_code: z.string().optional(),
    })
    .optional(),
  shipping_total: z.number().optional(),
  store_id: z.string().optional(),
  tax_total: z.number().optional(),
  tracking_carrier: z.string().optional(),
  tracking_code: z.literal('prec').optional(),
  tracking_number: z.string().optional(),
  tracking_url: z.string().optional(),
  updated_at_foreign: z.string().optional(),
});

export const getEcommerceStoresIdOrdersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchEcommerceStoresIdOrdersIdDataSchema = z.object({
  body: z.object({
    billing_address: z
      .object({
        address1: z.string().optional(),
        address2: z.string().optional(),
        city: z.string().optional(),
        company: z.string().optional(),
        country: z.string().optional(),
        country_code: z.string().optional(),
        latitude: z.number().optional(),
        longitude: z.number().optional(),
        name: z.string().optional(),
        phone: z.string().optional(),
        postal_code: z.string().optional(),
        province: z.string().optional(),
        province_code: z.string().optional(),
      })
      .optional(),
    campaign_id: z.string().optional(),
    cancelled_at_foreign: z.string().optional(),
    currency_code: z.string().optional(),
    customer: z
      .object({
        address: z
          .object({
            address1: z.string().optional(),
            address2: z.string().optional(),
            city: z.string().optional(),
            country: z.string().optional(),
            country_code: z.string().optional(),
            postal_code: z.string().optional(),
            province: z.string().optional(),
            province_code: z.string().optional(),
          })
          .optional(),
        company: z.string().optional(),
        first_name: z.string().optional(),
        last_name: z.string().optional(),
        opt_in_status: z.boolean().optional(),
      })
      .optional(),
    discount_total: z.number().optional(),
    financial_status: z.string().optional(),
    fulfillment_status: z.string().optional(),
    landing_site: z.string().optional(),
    lines: z
      .array(
        z.object({
          discount: z.number().optional(),
          price: z.number().optional(),
          product_id: z.string().optional(),
          product_variant_id: z.string().optional(),
          quantity: z.number().optional(),
        }),
      )
      .optional(),
    order_total: z.number().optional(),
    order_url: z.string().optional(),
    outreach: z
      .object({
        id: z.string().optional(),
      })
      .optional(),
    processed_at_foreign: z.string().optional(),
    promos: z
      .array(
        z.object({
          amount_discounted: z.number(),
          code: z.string(),
          type: z.union([z.literal('fixed'), z.literal('percentage')]),
        }),
      )
      .optional(),
    shipping_address: z
      .object({
        address1: z.string().optional(),
        address2: z.string().optional(),
        city: z.string().optional(),
        company: z.string().optional(),
        country: z.string().optional(),
        country_code: z.string().optional(),
        latitude: z.number().optional(),
        longitude: z.number().optional(),
        name: z.string().optional(),
        phone: z.string().optional(),
        postal_code: z.string().optional(),
        province: z.string().optional(),
        province_code: z.string().optional(),
      })
      .optional(),
    shipping_total: z.number().optional(),
    tax_total: z.number().optional(),
    tracking_carrier: z.string().optional(),
    tracking_code: z.literal('prec').optional(),
    tracking_number: z.string().optional(),
    tracking_url: z.string().optional(),
    updated_at_foreign: z.string().optional(),
  }),
  path: z.object({
    order_id: z.string(),
    store_id: z.string(),
  }),
});

export const patchEcommerceStoresIdOrdersIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  billing_address: z
    .object({
      address1: z.string().optional(),
      address2: z.string().optional(),
      city: z.string().optional(),
      company: z.string().optional(),
      country: z.string().optional(),
      country_code: z.string().optional(),
      latitude: z.number().optional(),
      longitude: z.number().optional(),
      name: z.string().optional(),
      phone: z.string().optional(),
      postal_code: z.string().optional(),
      province: z.string().optional(),
      province_code: z.string().optional(),
    })
    .optional(),
  campaign_id: z.string().optional(),
  cancelled_at_foreign: z.string().optional(),
  currency_code: z.string().optional(),
  customer: z
    .object({
      _links: z
        .array(
          z.object({
            href: z.string().optional(),
            method: z
              .union([
                z.literal('GET'),
                z.literal('POST'),
                z.literal('PUT'),
                z.literal('PATCH'),
                z.literal('DELETE'),
                z.literal('OPTIONS'),
                z.literal('HEAD'),
              ])
              .optional(),
            rel: z.string().optional(),
            schema: z.string().optional(),
            targetSchema: z.string().optional(),
          }),
        )
        .optional(),
      address: z
        .object({
          address1: z.string().optional(),
          address2: z.string().optional(),
          city: z.string().optional(),
          country: z.string().optional(),
          country_code: z.string().optional(),
          postal_code: z.string().optional(),
          province: z.string().optional(),
          province_code: z.string().optional(),
        })
        .optional(),
      company: z.string().optional(),
      created_at: z.string().optional(),
      email_address: z.string().optional(),
      first_name: z.string().optional(),
      id: z.string().optional(),
      last_name: z.string().optional(),
      opt_in_status: z.boolean().optional(),
      orders_count: z.number().optional(),
      total_spent: z.number().optional(),
      updated_at: z.string().optional(),
    })
    .optional(),
  discount_total: z.number().optional(),
  financial_status: z.string().optional(),
  fulfillment_status: z.string().optional(),
  id: z.string().optional(),
  landing_site: z.string().optional(),
  lines: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        discount: z.number().optional(),
        id: z.string().optional(),
        image_url: z.string().optional(),
        price: z.number().optional(),
        product_id: z.string().optional(),
        product_title: z.string().optional(),
        product_variant_id: z.string().optional(),
        product_variant_title: z.string().optional(),
        quantity: z.number().optional(),
      }),
    )
    .optional(),
  order_total: z.number().optional(),
  order_url: z.string().optional(),
  outreach: z
    .object({
      id: z.string().optional(),
      name: z.string().optional(),
      published_time: z.string().optional(),
      type: z.string().optional(),
    })
    .optional(),
  processed_at_foreign: z.string().optional(),
  promos: z
    .array(
      z.object({
        amount_discounted: z.number().optional(),
        code: z.string().optional(),
        type: z.union([z.literal('fixed'), z.literal('percentage')]).optional(),
      }),
    )
    .optional(),
  shipping_address: z
    .object({
      address1: z.string().optional(),
      address2: z.string().optional(),
      city: z.string().optional(),
      company: z.string().optional(),
      country: z.string().optional(),
      country_code: z.string().optional(),
      latitude: z.number().optional(),
      longitude: z.number().optional(),
      name: z.string().optional(),
      phone: z.string().optional(),
      postal_code: z.string().optional(),
      province: z.string().optional(),
      province_code: z.string().optional(),
    })
    .optional(),
  shipping_total: z.number().optional(),
  store_id: z.string().optional(),
  tax_total: z.number().optional(),
  tracking_carrier: z.string().optional(),
  tracking_code: z.literal('prec').optional(),
  tracking_number: z.string().optional(),
  tracking_url: z.string().optional(),
  updated_at_foreign: z.string().optional(),
});

export const patchEcommerceStoresIdOrdersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdOrdersIdLinesDataSchema = z.object({
  path: z.object({
    order_id: z.string(),
    store_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdOrdersIdLinesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  lines: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        discount: z.number().optional(),
        id: z.string().optional(),
        image_url: z.string().optional(),
        price: z.number().optional(),
        product_id: z.string().optional(),
        product_title: z.string().optional(),
        product_variant_id: z.string().optional(),
        product_variant_title: z.string().optional(),
        quantity: z.number().optional(),
      }),
    )
    .optional(),
  order_id: z.string().optional(),
  store_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getEcommerceStoresIdOrdersIdLinesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postEcommerceStoresIdOrdersIdLinesDataSchema = z.object({
  body: z.object({
    discount: z.number().optional(),
    id: z.string(),
    price: z.number(),
    product_id: z.string(),
    product_variant_id: z.string(),
    quantity: z.number(),
  }),
  path: z.object({
    order_id: z.string(),
    store_id: z.string(),
  }),
});

export const postEcommerceStoresIdOrdersIdLinesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  discount: z.number().optional(),
  id: z.string().optional(),
  image_url: z.string().optional(),
  price: z.number().optional(),
  product_id: z.string().optional(),
  product_title: z.string().optional(),
  product_variant_id: z.string().optional(),
  product_variant_title: z.string().optional(),
  quantity: z.number().optional(),
});

export const postEcommerceStoresIdOrdersIdLinesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteEcommerceStoresIdOrdersIdLinesIdDataSchema = z.object({
  path: z.object({
    line_id: z.string(),
    order_id: z.string(),
    store_id: z.string(),
  }),
});

export const deleteEcommerceStoresIdOrdersIdLinesIdResponseSchema = z.any();

export const deleteEcommerceStoresIdOrdersIdLinesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdOrdersIdLinesIdDataSchema = z.object({
  path: z.object({
    line_id: z.string(),
    order_id: z.string(),
    store_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdOrdersIdLinesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  discount: z.number().optional(),
  id: z.string().optional(),
  image_url: z.string().optional(),
  price: z.number().optional(),
  product_id: z.string().optional(),
  product_title: z.string().optional(),
  product_variant_id: z.string().optional(),
  product_variant_title: z.string().optional(),
  quantity: z.number().optional(),
});

export const getEcommerceStoresIdOrdersIdLinesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchEcommerceStoresIdOrdersIdLinesIdDataSchema = z.object({
  body: z.object({
    discount: z.number().optional(),
    price: z.number().optional(),
    product_id: z.string().optional(),
    product_variant_id: z.string().optional(),
    quantity: z.number().optional(),
  }),
  path: z.object({
    line_id: z.string(),
    order_id: z.string(),
    store_id: z.string(),
  }),
});

export const patchEcommerceStoresIdOrdersIdLinesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  discount: z.number().optional(),
  id: z.string().optional(),
  image_url: z.string().optional(),
  price: z.number().optional(),
  product_id: z.string().optional(),
  product_title: z.string().optional(),
  product_variant_id: z.string().optional(),
  product_variant_title: z.string().optional(),
  quantity: z.number().optional(),
});

export const patchEcommerceStoresIdOrdersIdLinesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdProductsDataSchema = z.object({
  path: z.object({
    store_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdProductsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  products: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        currency_code: z.string().optional(),
        description: z.string().optional(),
        handle: z.string().optional(),
        id: z.string().optional(),
        image_url: z.string().optional(),
        images: z
          .array(
            z.object({
              _links: z
                .array(
                  z.object({
                    href: z.string().optional(),
                    method: z
                      .union([
                        z.literal('GET'),
                        z.literal('POST'),
                        z.literal('PUT'),
                        z.literal('PATCH'),
                        z.literal('DELETE'),
                        z.literal('OPTIONS'),
                        z.literal('HEAD'),
                      ])
                      .optional(),
                    rel: z.string().optional(),
                    schema: z.string().optional(),
                    targetSchema: z.string().optional(),
                  }),
                )
                .optional(),
              id: z.string().optional(),
              url: z.string().optional(),
              variant_ids: z.array(z.string()).optional(),
            }),
          )
          .optional(),
        published_at_foreign: z.string().optional(),
        title: z.string().optional(),
        type: z.string().optional(),
        url: z.string().optional(),
        variants: z
          .array(
            z.object({
              _links: z
                .array(
                  z.object({
                    href: z.string().optional(),
                    method: z
                      .union([
                        z.literal('GET'),
                        z.literal('POST'),
                        z.literal('PUT'),
                        z.literal('PATCH'),
                        z.literal('DELETE'),
                        z.literal('OPTIONS'),
                        z.literal('HEAD'),
                      ])
                      .optional(),
                    rel: z.string().optional(),
                    schema: z.string().optional(),
                    targetSchema: z.string().optional(),
                  }),
                )
                .optional(),
              backorders: z.string().optional(),
              created_at: z.string().optional(),
              id: z.string().optional(),
              image_url: z.string().optional(),
              inventory_quantity: z.number().optional(),
              price: z.number().optional(),
              sku: z.string().optional(),
              title: z.string().optional(),
              updated_at: z.string().optional(),
              url: z.string().optional(),
              visibility: z.string().optional(),
            }),
          )
          .optional(),
        vendor: z.string().optional(),
      }),
    )
    .optional(),
  store_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getEcommerceStoresIdProductsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postEcommerceStoresIdProductsDataSchema = z.object({
  body: z.object({
    description: z.string().optional(),
    handle: z.string().optional(),
    id: z.string(),
    image_url: z.string().optional(),
    images: z
      .array(
        z.object({
          id: z.string(),
          url: z.string(),
          variant_ids: z.array(z.string()).optional(),
        }),
      )
      .optional(),
    published_at_foreign: z.string().optional(),
    title: z.string(),
    type: z.string().optional(),
    url: z.string().optional(),
    variants: z.array(
      z.object({
        backorders: z.string().optional(),
        id: z.string(),
        image_url: z.string().optional(),
        inventory_quantity: z.number().optional(),
        price: z.number().optional(),
        sku: z.string().optional(),
        title: z.string(),
        url: z.string().optional(),
        visibility: z.string().optional(),
      }),
    ),
    vendor: z.string().optional(),
  }),
  path: z.object({
    store_id: z.string(),
  }),
});

export const postEcommerceStoresIdProductsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  currency_code: z.string().optional(),
  description: z.string().optional(),
  handle: z.string().optional(),
  id: z.string().optional(),
  image_url: z.string().optional(),
  images: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        id: z.string().optional(),
        url: z.string().optional(),
        variant_ids: z.array(z.string()).optional(),
      }),
    )
    .optional(),
  published_at_foreign: z.string().optional(),
  title: z.string().optional(),
  type: z.string().optional(),
  url: z.string().optional(),
  variants: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        backorders: z.string().optional(),
        created_at: z.string().optional(),
        id: z.string().optional(),
        image_url: z.string().optional(),
        inventory_quantity: z.number().optional(),
        price: z.number().optional(),
        sku: z.string().optional(),
        title: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        visibility: z.string().optional(),
      }),
    )
    .optional(),
  vendor: z.string().optional(),
});

export const postEcommerceStoresIdProductsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteEcommerceStoresIdProductsIdDataSchema = z.object({
  path: z.object({
    product_id: z.string(),
    store_id: z.string(),
  }),
});

export const deleteEcommerceStoresIdProductsIdResponseSchema = z.any();

export const deleteEcommerceStoresIdProductsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdProductsIdDataSchema = z.object({
  path: z.object({
    product_id: z.string(),
    store_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdProductsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  currency_code: z.string().optional(),
  description: z.string().optional(),
  handle: z.string().optional(),
  id: z.string().optional(),
  image_url: z.string().optional(),
  images: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        id: z.string().optional(),
        url: z.string().optional(),
        variant_ids: z.array(z.string()).optional(),
      }),
    )
    .optional(),
  published_at_foreign: z.string().optional(),
  title: z.string().optional(),
  type: z.string().optional(),
  url: z.string().optional(),
  variants: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        backorders: z.string().optional(),
        created_at: z.string().optional(),
        id: z.string().optional(),
        image_url: z.string().optional(),
        inventory_quantity: z.number().optional(),
        price: z.number().optional(),
        sku: z.string().optional(),
        title: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        visibility: z.string().optional(),
      }),
    )
    .optional(),
  vendor: z.string().optional(),
});

export const getEcommerceStoresIdProductsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchEcommerceStoresIdProductsIdDataSchema = z.object({
  body: z.object({
    description: z.string().optional(),
    handle: z.string().optional(),
    image_url: z.string().optional(),
    images: z
      .array(
        z.object({
          id: z.string().optional(),
          url: z.string().optional(),
          variant_ids: z.array(z.string()).optional(),
        }),
      )
      .optional(),
    published_at_foreign: z.string().optional(),
    title: z.string().optional(),
    type: z.string().optional(),
    url: z.string().optional(),
    variants: z
      .array(
        z.object({
          backorders: z.string().optional(),
          image_url: z.string().optional(),
          inventory_quantity: z.number().optional(),
          price: z.number().optional(),
          sku: z.string().optional(),
          title: z.string().optional(),
          url: z.string().optional(),
          visibility: z.string().optional(),
        }),
      )
      .optional(),
    vendor: z.string().optional(),
  }),
  path: z.object({
    product_id: z.string(),
    store_id: z.string(),
  }),
});

export const patchEcommerceStoresIdProductsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  currency_code: z.string().optional(),
  description: z.string().optional(),
  handle: z.string().optional(),
  id: z.string().optional(),
  image_url: z.string().optional(),
  images: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        id: z.string().optional(),
        url: z.string().optional(),
        variant_ids: z.array(z.string()).optional(),
      }),
    )
    .optional(),
  published_at_foreign: z.string().optional(),
  title: z.string().optional(),
  type: z.string().optional(),
  url: z.string().optional(),
  variants: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        backorders: z.string().optional(),
        created_at: z.string().optional(),
        id: z.string().optional(),
        image_url: z.string().optional(),
        inventory_quantity: z.number().optional(),
        price: z.number().optional(),
        sku: z.string().optional(),
        title: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        visibility: z.string().optional(),
      }),
    )
    .optional(),
  vendor: z.string().optional(),
});

export const patchEcommerceStoresIdProductsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdProductsIdImagesDataSchema = z.object({
  path: z.object({
    product_id: z.string(),
    store_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdProductsIdImagesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  images: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        id: z.string().optional(),
        url: z.string().optional(),
        variant_ids: z.array(z.string()).optional(),
      }),
    )
    .optional(),
  product_id: z.string().optional(),
  store_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getEcommerceStoresIdProductsIdImagesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postEcommerceStoresIdProductsIdImagesDataSchema = z.object({
  body: z.object({
    id: z.string(),
    url: z.string(),
    variant_ids: z.array(z.string()).optional(),
  }),
  path: z.object({
    product_id: z.string(),
    store_id: z.string(),
  }),
});

export const postEcommerceStoresIdProductsIdImagesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  id: z.string().optional(),
  url: z.string().optional(),
  variant_ids: z.array(z.string()).optional(),
});

export const postEcommerceStoresIdProductsIdImagesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteEcommerceStoresIdProductsIdImagesIdDataSchema = z.object({
  path: z.object({
    image_id: z.string(),
    product_id: z.string(),
    store_id: z.string(),
  }),
});

export const deleteEcommerceStoresIdProductsIdImagesIdResponseSchema = z.any();

export const deleteEcommerceStoresIdProductsIdImagesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdProductsIdImagesIdDataSchema = z.object({
  path: z.object({
    image_id: z.string(),
    product_id: z.string(),
    store_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdProductsIdImagesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  id: z.string().optional(),
  url: z.string().optional(),
  variant_ids: z.array(z.string()).optional(),
});

export const getEcommerceStoresIdProductsIdImagesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchEcommerceStoresIdProductsIdImagesIdDataSchema = z.object({
  body: z.object({
    id: z.string().optional(),
    url: z.string().optional(),
    variant_ids: z.array(z.string()).optional(),
  }),
  path: z.object({
    image_id: z.string(),
    product_id: z.string(),
    store_id: z.string(),
  }),
});

export const patchEcommerceStoresIdProductsIdImagesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  id: z.string().optional(),
  url: z.string().optional(),
  variant_ids: z.array(z.string()).optional(),
});

export const patchEcommerceStoresIdProductsIdImagesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdProductsIdVariantsDataSchema = z.object({
  path: z.object({
    product_id: z.string(),
    store_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdProductsIdVariantsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  product_id: z.string().optional(),
  store_id: z.string().optional(),
  total_items: z.number().optional(),
  variants: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        backorders: z.string().optional(),
        created_at: z.string().optional(),
        id: z.string().optional(),
        image_url: z.string().optional(),
        inventory_quantity: z.number().optional(),
        price: z.number().optional(),
        sku: z.string().optional(),
        title: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        visibility: z.string().optional(),
      }),
    )
    .optional(),
});

export const getEcommerceStoresIdProductsIdVariantsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postEcommerceStoresIdProductsIdVariantsDataSchema = z.object({
  body: z.object({
    backorders: z.string().optional(),
    id: z.string(),
    image_url: z.string().optional(),
    inventory_quantity: z.number().optional(),
    price: z.number().optional(),
    sku: z.string().optional(),
    title: z.string(),
    url: z.string().optional(),
    visibility: z.string().optional(),
  }),
  path: z.object({
    product_id: z.string(),
    store_id: z.string(),
  }),
});

export const postEcommerceStoresIdProductsIdVariantsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  backorders: z.string().optional(),
  created_at: z.string().optional(),
  id: z.string().optional(),
  image_url: z.string().optional(),
  inventory_quantity: z.number().optional(),
  price: z.number().optional(),
  sku: z.string().optional(),
  title: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  visibility: z.string().optional(),
});

export const postEcommerceStoresIdProductsIdVariantsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteEcommerceStoresIdProductsIdVariantsIdDataSchema = z.object({
  path: z.object({
    product_id: z.string(),
    store_id: z.string(),
    variant_id: z.string(),
  }),
});

export const deleteEcommerceStoresIdProductsIdVariantsIdResponseSchema = z.any();

export const deleteEcommerceStoresIdProductsIdVariantsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdProductsIdVariantsIdDataSchema = z.object({
  path: z.object({
    product_id: z.string(),
    store_id: z.string(),
    variant_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdProductsIdVariantsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  backorders: z.string().optional(),
  created_at: z.string().optional(),
  id: z.string().optional(),
  image_url: z.string().optional(),
  inventory_quantity: z.number().optional(),
  price: z.number().optional(),
  sku: z.string().optional(),
  title: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  visibility: z.string().optional(),
});

export const getEcommerceStoresIdProductsIdVariantsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchEcommerceStoresIdProductsIdVariantsIdDataSchema = z.object({
  body: z.object({
    backorders: z.string().optional(),
    image_url: z.string().optional(),
    inventory_quantity: z.number().optional(),
    price: z.number().optional(),
    sku: z.string().optional(),
    title: z.string().optional(),
    url: z.string().optional(),
    visibility: z.string().optional(),
  }),
  path: z.object({
    product_id: z.string(),
    store_id: z.string(),
    variant_id: z.string(),
  }),
});

export const patchEcommerceStoresIdProductsIdVariantsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  backorders: z.string().optional(),
  created_at: z.string().optional(),
  id: z.string().optional(),
  image_url: z.string().optional(),
  inventory_quantity: z.number().optional(),
  price: z.number().optional(),
  sku: z.string().optional(),
  title: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  visibility: z.string().optional(),
});

export const patchEcommerceStoresIdProductsIdVariantsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const putEcommerceStoresIdProductsIdVariantsIdDataSchema = z.object({
  body: z.object({
    backorders: z.string().optional(),
    id: z.string(),
    image_url: z.string().optional(),
    inventory_quantity: z.number().optional(),
    price: z.number().optional(),
    sku: z.string().optional(),
    title: z.string(),
    url: z.string().optional(),
    visibility: z.string().optional(),
  }),
  path: z.object({
    product_id: z.string(),
    store_id: z.string(),
    variant_id: z.string(),
  }),
});

export const putEcommerceStoresIdProductsIdVariantsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  backorders: z.string().optional(),
  created_at: z.string().optional(),
  id: z.string().optional(),
  image_url: z.string().optional(),
  inventory_quantity: z.number().optional(),
  price: z.number().optional(),
  sku: z.string().optional(),
  title: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  visibility: z.string().optional(),
});

export const putEcommerceStoresIdProductsIdVariantsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdPromorulesDataSchema = z.object({
  path: z.object({
    store_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdPromorulesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  promo_rules: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        amount: z.number().optional(),
        created_at_foreign: z.string().optional(),
        description: z.string().optional(),
        enabled: z.boolean().optional(),
        ends_at: z.string().optional(),
        id: z.string().optional(),
        starts_at: z.string().optional(),
        target: z.union([z.literal('per_item'), z.literal('total'), z.literal('shipping')]).optional(),
        title: z.string().optional(),
        type: z.union([z.literal('fixed'), z.literal('percentage')]).optional(),
        updated_at_foreign: z.string().optional(),
      }),
    )
    .optional(),
  store_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getEcommerceStoresIdPromorulesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postEcommerceStoresIdPromorulesDataSchema = z.object({
  body: z.object({
    amount: z.number(),
    created_at_foreign: z.string().optional(),
    description: z.string(),
    enabled: z.boolean().optional(),
    ends_at: z.string().optional(),
    id: z.string(),
    starts_at: z.string().optional(),
    target: z.union([z.literal('per_item'), z.literal('total'), z.literal('shipping')]),
    title: z.string().optional(),
    type: z.union([z.literal('fixed'), z.literal('percentage')]),
    updated_at_foreign: z.string().optional(),
  }),
  path: z.object({
    store_id: z.string(),
  }),
});

export const postEcommerceStoresIdPromorulesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  amount: z.number().optional(),
  created_at_foreign: z.string().optional(),
  description: z.string().optional(),
  enabled: z.boolean().optional(),
  ends_at: z.string().optional(),
  id: z.string().optional(),
  starts_at: z.string().optional(),
  target: z.union([z.literal('per_item'), z.literal('total'), z.literal('shipping')]).optional(),
  title: z.string().optional(),
  type: z.union([z.literal('fixed'), z.literal('percentage')]).optional(),
  updated_at_foreign: z.string().optional(),
});

export const postEcommerceStoresIdPromorulesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteEcommerceStoresIdPromorulesIdDataSchema = z.object({
  path: z.object({
    promo_rule_id: z.string(),
    store_id: z.string(),
  }),
});

export const deleteEcommerceStoresIdPromorulesIdResponseSchema = z.any();

export const deleteEcommerceStoresIdPromorulesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdPromorulesIdDataSchema = z.object({
  path: z.object({
    promo_rule_id: z.string(),
    store_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdPromorulesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  amount: z.number().optional(),
  created_at_foreign: z.string().optional(),
  description: z.string().optional(),
  enabled: z.boolean().optional(),
  ends_at: z.string().optional(),
  id: z.string().optional(),
  starts_at: z.string().optional(),
  target: z.union([z.literal('per_item'), z.literal('total'), z.literal('shipping')]).optional(),
  title: z.string().optional(),
  type: z.union([z.literal('fixed'), z.literal('percentage')]).optional(),
  updated_at_foreign: z.string().optional(),
});

export const getEcommerceStoresIdPromorulesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchEcommerceStoresIdPromorulesIdDataSchema = z.object({
  body: z.object({
    amount: z.number().optional(),
    created_at_foreign: z.string().optional(),
    description: z.string().optional(),
    enabled: z.boolean().optional(),
    ends_at: z.string().optional(),
    starts_at: z.string().optional(),
    target: z.union([z.literal('per_item'), z.literal('total'), z.literal('shipping')]).optional(),
    title: z.string().optional(),
    type: z.union([z.literal('fixed'), z.literal('percentage')]).optional(),
    updated_at_foreign: z.string().optional(),
  }),
  path: z.object({
    promo_rule_id: z.string(),
    store_id: z.string(),
  }),
});

export const patchEcommerceStoresIdPromorulesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  amount: z.number().optional(),
  created_at_foreign: z.string().optional(),
  description: z.string().optional(),
  enabled: z.boolean().optional(),
  ends_at: z.string().optional(),
  id: z.string().optional(),
  starts_at: z.string().optional(),
  target: z.union([z.literal('per_item'), z.literal('total'), z.literal('shipping')]).optional(),
  title: z.string().optional(),
  type: z.union([z.literal('fixed'), z.literal('percentage')]).optional(),
  updated_at_foreign: z.string().optional(),
});

export const patchEcommerceStoresIdPromorulesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdPromocodesDataSchema = z.object({
  path: z.object({
    promo_rule_id: z.string(),
    store_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdPromocodesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  promo_codes: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        code: z.string().optional(),
        created_at_foreign: z.string().optional(),
        enabled: z.boolean().optional(),
        id: z.string().optional(),
        redemption_url: z.string().optional(),
        updated_at_foreign: z.string().optional(),
        usage_count: z.number().optional(),
      }),
    )
    .optional(),
  store_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getEcommerceStoresIdPromocodesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postEcommerceStoresIdPromocodesDataSchema = z.object({
  body: z.object({
    code: z.string(),
    created_at_foreign: z.string().optional(),
    enabled: z.boolean().optional(),
    id: z.string(),
    redemption_url: z.string(),
    updated_at_foreign: z.string().optional(),
    usage_count: z.number().optional(),
  }),
  path: z.object({
    promo_rule_id: z.string(),
    store_id: z.string(),
  }),
});

export const postEcommerceStoresIdPromocodesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  code: z.string().optional(),
  created_at_foreign: z.string().optional(),
  enabled: z.boolean().optional(),
  id: z.string().optional(),
  redemption_url: z.string().optional(),
  updated_at_foreign: z.string().optional(),
  usage_count: z.number().optional(),
});

export const postEcommerceStoresIdPromocodesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteEcommerceStoresIdPromocodesIdDataSchema = z.object({
  path: z.object({
    promo_code_id: z.string(),
    promo_rule_id: z.string(),
    store_id: z.string(),
  }),
});

export const deleteEcommerceStoresIdPromocodesIdResponseSchema = z.any();

export const deleteEcommerceStoresIdPromocodesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getEcommerceStoresIdPromocodesIdDataSchema = z.object({
  path: z.object({
    promo_code_id: z.string(),
    promo_rule_id: z.string(),
    store_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getEcommerceStoresIdPromocodesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  code: z.string().optional(),
  created_at_foreign: z.string().optional(),
  enabled: z.boolean().optional(),
  id: z.string().optional(),
  redemption_url: z.string().optional(),
  updated_at_foreign: z.string().optional(),
  usage_count: z.number().optional(),
});

export const getEcommerceStoresIdPromocodesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchEcommerceStoresIdPromocodesIdDataSchema = z.object({
  body: z.object({
    code: z.string().optional(),
    created_at_foreign: z.string().optional(),
    enabled: z.boolean().optional(),
    redemption_url: z.string().optional(),
    updated_at_foreign: z.string().optional(),
    usage_count: z.number().optional(),
  }),
  path: z.object({
    promo_code_id: z.string(),
    promo_rule_id: z.string(),
    store_id: z.string(),
  }),
});

export const patchEcommerceStoresIdPromocodesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  code: z.string().optional(),
  created_at_foreign: z.string().optional(),
  enabled: z.boolean().optional(),
  id: z.string().optional(),
  redemption_url: z.string().optional(),
  updated_at_foreign: z.string().optional(),
  usage_count: z.number().optional(),
});

export const patchEcommerceStoresIdPromocodesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getAllFacebookAdsDataSchema = z.object({
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
      sort_dir: z.union([z.literal('ASC'), z.literal('DESC')]).optional(),
      sort_field: z.union([z.literal('created_at'), z.literal('updated_at'), z.literal('end_time')]).optional(),
    })
    .optional(),
});

export const getAllFacebookAdsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  facebook_ads: z
    .array(
      z
        .object({
          canceled_at: z.string().optional(),
          create_time: z.string().optional(),
          has_segment: z.boolean().optional(),
          id: z.string().optional(),
          name: z.string().optional(),
          published_time: z.string().optional(),
          recipients: z
            .object({
              list_id: z.string().optional(),
              list_is_active: z.boolean().optional(),
              list_name: z.string().optional(),
              recipient_count: z.number().optional(),
              segment_opts: z
                .object({
                  conditions: z
                    .array(
                      z.union([
                        z.object({
                          condition_type: z.literal('Aim').optional(),
                          field: z.literal('aim').optional(),
                          op: z
                            .union([
                              z.literal('open'),
                              z.literal('click'),
                              z.literal('sent'),
                              z.literal('noopen'),
                              z.literal('noclick'),
                              z.literal('nosent'),
                            ])
                            .optional(),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('Automation').optional(),
                          field: z.literal('automation'),
                          op: z.union([
                            z.literal('started'),
                            z.literal('completed'),
                            z.literal('not_started'),
                            z.literal('not_completed'),
                          ]),
                          value: z.string(),
                        }),
                        z.object({
                          condition_type: z.literal('CampaignPoll').optional(),
                          field: z.literal('poll'),
                          op: z.union([z.literal('member'), z.literal('notmember')]),
                          value: z.number(),
                        }),
                        z.object({
                          condition_type: z.literal('Conversation').optional(),
                          field: z.literal('conversation'),
                          op: z.union([z.literal('member'), z.literal('notmember')]),
                          value: z.string(),
                        }),
                        z.object({
                          condition_type: z.literal('Date').optional(),
                          extra: z.string().optional(),
                          field: z.union([
                            z.literal('timestamp_opt'),
                            z.literal('info_changed'),
                            z.literal('ecomm_date'),
                          ]),
                          op: z.union([
                            z.literal('greater'),
                            z.literal('less'),
                            z.literal('is'),
                            z.literal('not'),
                            z.literal('blank'),
                            z.literal('blank_not'),
                            z.literal('within'),
                            z.literal('notwithin'),
                          ]),
                          value: z.string(),
                        }),
                        z.object({
                          condition_type: z.literal('EmailClient').optional(),
                          field: z.literal('email_client'),
                          op: z.union([z.literal('client_is'), z.literal('client_not')]),
                          value: z.string(),
                        }),
                        z.object({
                          condition_type: z.literal('Language').optional(),
                          field: z.literal('language'),
                          op: z.union([z.literal('is'), z.literal('not')]),
                          value: z.string(),
                        }),
                        z.object({
                          condition_type: z.literal('MemberRating').optional(),
                          field: z.literal('rating'),
                          op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                          value: z.number(),
                        }),
                        z.object({
                          condition_type: z.literal('SignupSource'),
                          field: z.literal('source'),
                          op: z.union([z.literal('source_is'), z.literal('source_not')]),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('SurveyMonkey').optional(),
                          field: z.literal('survey_monkey'),
                          op: z.union([
                            z.literal('started'),
                            z.literal('completed'),
                            z.literal('not_started'),
                            z.literal('not_completed'),
                          ]),
                          value: z.string(),
                        }),
                        z.object({
                          condition_type: z.literal('VIP').optional(),
                          field: z.literal('gmonkey'),
                          op: z.union([z.literal('member'), z.literal('notmember')]),
                        }),
                        z.object({
                          condition_type: z.literal('Interests').optional(),
                          field: z.string().optional(),
                          op: z
                            .union([
                              z.literal('interestcontains'),
                              z.literal('interestcontainsall'),
                              z.literal('interestnotcontains'),
                            ])
                            .optional(),
                          value: z.array(z.string()).optional(),
                        }),
                        z.object({
                          condition_type: z.literal('EcommCategory').optional(),
                          field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                          op: z
                            .union([
                              z.literal('is'),
                              z.literal('not'),
                              z.literal('contains'),
                              z.literal('notcontain'),
                              z.literal('starts'),
                              z.literal('ends'),
                            ])
                            .optional(),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('EcommNumber').optional(),
                          field: z.union([
                            z.literal('ecomm_spent_avg'),
                            z.literal('ecomm_orders'),
                            z.literal('ecomm_prod_all'),
                            z.literal('ecomm_avg_ord'),
                          ]),
                          op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                          value: z.number(),
                        }),
                        z.object({
                          condition_type: z.literal('EcommPurchased').optional(),
                          field: z.literal('ecomm_purchased').optional(),
                          op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                        }),
                        z.object({
                          condition_type: z.literal('EcommSpent').optional(),
                          field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                          op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                          value: z.number().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('EcommStore').optional(),
                          field: z.literal('ecomm_store').optional(),
                          op: z.union([z.literal('is'), z.literal('not')]).optional(),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('GoalActivity').optional(),
                          field: z.literal('goal'),
                          op: z.union([
                            z.literal('is'),
                            z.literal('goal_not'),
                            z.literal('contains'),
                            z.literal('goal_notcontain'),
                            z.literal('starts'),
                            z.literal('ends'),
                          ]),
                          value: z.string(),
                        }),
                        z.object({
                          condition_type: z.literal('GoalTimestamp').optional(),
                          field: z.literal('goal_last_visited'),
                          op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                          value: z.string(),
                        }),
                        z.object({
                          condition_type: z.literal('FuzzySegment').optional(),
                          field: z.literal('fuzzy_segment'),
                          op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                          value: z.number(),
                        }),
                        z.object({
                          condition_type: z.literal('StaticSegment').optional(),
                          field: z.literal('static_segment'),
                          op: z.union([z.literal('static_is'), z.literal('static_not')]),
                          value: z.number(),
                        }),
                        z.object({
                          condition_type: z.literal('IPGeoCountryState').optional(),
                          field: z.literal('ipgeo'),
                          op: z.union([
                            z.literal('ipgeocountry'),
                            z.literal('ipgeonotcountry'),
                            z.literal('ipgeostate'),
                            z.literal('ipgeonotstate'),
                          ]),
                          value: z.string(),
                        }),
                        z.object({
                          addr: z.string(),
                          condition_type: z.literal('IPGeoIn').optional(),
                          field: z.literal('ipgeo'),
                          lat: z.string(),
                          lng: z.string(),
                          op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                          value: z.number(),
                        }),
                        z.object({
                          condition_type: z.literal('IPGeoInZip').optional(),
                          extra: z.number(),
                          field: z.literal('ipgeo'),
                          op: z.literal('ipgeoinzip'),
                          value: z.number(),
                        }),
                        z.object({
                          condition_type: z.literal('IPGeoUnknown').optional(),
                          field: z.literal('ipgeo'),
                          op: z.literal('ipgeounknown'),
                        }),
                        z.object({
                          condition_type: z.literal('IPGeoZip').optional(),
                          field: z.literal('ipgeo'),
                          op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                          value: z.number(),
                        }),
                        z.object({
                          condition_type: z.literal('SocialAge').optional(),
                          field: z.literal('social_age'),
                          op: z.union([z.literal('is'), z.literal('not')]),
                          value: z.union([
                            z.literal('18-24'),
                            z.literal('25-34'),
                            z.literal('35-54'),
                            z.literal('55+'),
                          ]),
                        }),
                        z.object({
                          condition_type: z.literal('SocialGender').optional(),
                          field: z.literal('social_gender'),
                          op: z.union([z.literal('is'), z.literal('not')]),
                          value: z.union([z.literal('male'), z.literal('female')]),
                        }),
                        z.object({
                          condition_type: z.literal('SocialInfluence').optional(),
                          field: z.literal('social_influence'),
                          op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                          value: z.number(),
                        }),
                        z.object({
                          condition_type: z.literal('SocialNetworkMember').optional(),
                          field: z.literal('social_network'),
                          op: z.union([z.literal('member'), z.literal('notmember')]),
                          value: z.union([
                            z.literal('twitter'),
                            z.literal('facebook'),
                            z.literal('linkedin'),
                            z.literal('flickr'),
                            z.literal('foursquare'),
                            z.literal('lastfm'),
                            z.literal('myspace'),
                            z.literal('quora'),
                            z.literal('vimeo'),
                            z.literal('yelp'),
                            z.literal('youtube'),
                          ]),
                        }),
                        z.object({
                          condition_type: z.literal('SocialNetworkFollow').optional(),
                          field: z.literal('social_network'),
                          op: z.union([z.literal('follow'), z.literal('notfollow')]),
                          value: z.literal('twitter_follow'),
                        }),
                        z.object({
                          condition_type: z.literal('AddressMerge').optional(),
                          field: z.string(),
                          op: z.union([
                            z.literal('contains'),
                            z.literal('notcontain'),
                            z.literal('blank'),
                            z.literal('blank_not'),
                          ]),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('ZipMerge').optional(),
                          extra: z.string(),
                          field: z.string(),
                          op: z.literal('geoin'),
                          value: z.string(),
                        }),
                        z.object({
                          condition_type: z.literal('BirthdayMerge').optional(),
                          field: z.string(),
                          op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('DateMerge').optional(),
                          field: z.string(),
                          op: z.union([
                            z.literal('is'),
                            z.literal('not'),
                            z.literal('less'),
                            z.literal('blank'),
                            z.literal('blank_not'),
                            z.literal('greater'),
                          ]),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('SelectMerge').optional(),
                          field: z.string(),
                          op: z.union([
                            z.literal('is'),
                            z.literal('not'),
                            z.literal('blank'),
                            z.literal('blank_not'),
                            z.literal('notcontain'),
                            z.literal('contains'),
                          ]),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('TextMerge').optional(),
                          field: z.string(),
                          op: z.union([
                            z.literal('is'),
                            z.literal('not'),
                            z.literal('contains'),
                            z.literal('notcontain'),
                            z.literal('starts'),
                            z.literal('ends'),
                            z.literal('greater'),
                            z.literal('less'),
                            z.literal('blank'),
                            z.literal('blank_not'),
                          ]),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('EmailAddress').optional(),
                          field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                          op: z.union([
                            z.literal('is'),
                            z.literal('not'),
                            z.literal('contains'),
                            z.literal('notcontain'),
                            z.literal('starts'),
                            z.literal('ends'),
                            z.literal('greater'),
                            z.literal('less'),
                          ]),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('PredictedGender').optional(),
                          field: z.literal('predicted_gender'),
                          op: z.union([z.literal('is'), z.literal('not')]),
                          value: z.union([z.literal('male'), z.literal('female')]),
                        }),
                        z.object({
                          condition_type: z.literal('PredictedAge').optional(),
                          field: z.literal('predicted_age_range'),
                          op: z.literal('is'),
                          value: z.union([
                            z.literal('18-24'),
                            z.literal('25-34'),
                            z.literal('35-44'),
                            z.literal('45-54'),
                            z.literal('55-64'),
                            z.literal('65+'),
                          ]),
                        }),
                        z.object({
                          condition_type: z.literal('NewSubscribers').optional(),
                          field: z.literal('timestamp_opt').optional(),
                          op: z.literal('date_within').optional(),
                          value: z.string().optional(),
                        }),
                      ]),
                    )
                    .optional(),
                  match: z.union([z.literal('any'), z.literal('all')]).optional(),
                  prebuilt_segment_id: z.string().optional(),
                  saved_segment_id: z.number().optional(),
                })
                .optional(),
              segment_text: z.string().optional(),
            })
            .optional(),
          report_summary: z
            .object({
              click_rate: z.number().optional(),
              clicks: z.number().optional(),
              conversion_rate: z.number().optional(),
              ecommerce: z
                .object({
                  average_order_revenue: z.number().optional(),
                  currency_code: z.string().optional(),
                  total_revenue: z.number().optional(),
                })
                .optional(),
              engagements: z.number().optional(),
              impressions: z.number().optional(),
              open_rate: z.number().optional(),
              opens: z.number().optional(),
              reach: z.number().optional(),
              subscriber_clicks: z.number().optional(),
              subscribes: z.number().optional(),
              total_sent: z.number().optional(),
              unique_opens: z.number().optional(),
              unique_visits: z.number().optional(),
              visits: z.number().optional(),
            })
            .optional(),
          show_report: z.boolean().optional(),
          start_time: z.string().optional(),
          status: z
            .union([
              z.literal('save'),
              z.literal('paused'),
              z.literal('schedule'),
              z.literal('scheduled'),
              z.literal('sending'),
              z.literal('sent'),
              z.literal('canceled'),
              z.literal('canceling'),
              z.literal('active'),
              z.literal('disconnected'),
              z.literal('somepaused'),
              z.literal('draft'),
              z.literal('completed'),
              z.literal('partialRejected'),
              z.literal('pending'),
              z.literal('rejected'),
              z.literal('published'),
              z.literal('unpublished'),
            ])
            .optional(),
          thumbnail: z.string().optional(),
          type: z
            .union([
              z.literal('regular'),
              z.literal('email-touchpoint'),
              z.literal('plaintext'),
              z.literal('rss'),
              z.literal('reconfirm'),
              z.literal('variate'),
              z.literal('absplit'),
              z.literal('automation'),
              z.literal('facebook'),
              z.literal('google'),
              z.literal('autoresponder'),
              z.literal('transactional'),
              z.literal('page'),
              z.literal('website'),
              z.literal('social_post'),
              z.literal('survey'),
              z.literal('customer_journey'),
            ])
            .optional(),
          updated_at: z.string().optional(),
          web_id: z.number().optional(),
        })
        .and(
          z.object({
            email_source_name: z.string().optional(),
            end_time: z.string().optional(),
            needs_attention: z.boolean().optional(),
            paused_at: z.string().optional(),
            was_canceled_by_facebook: z.boolean().optional(),
          }),
        )
        .and(
          z.object({
            audience: z
              .object({
                email_source: z
                  .object({
                    is_segment: z.boolean().optional(),
                    list_name: z.string().optional(),
                    name: z.string().optional(),
                    segment_type: z.string().optional(),
                    type: z.string().optional(),
                  })
                  .optional(),
                include_source_in_target: z.boolean().optional(),
                lookalike_country_code: z.string().optional(),
                source_type: z.union([z.literal('facebook'), z.literal('list')]).optional(),
                targeting_specs: z
                  .object({
                    gender: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
                    interests: z
                      .array(
                        z.object({
                          name: z.string().optional(),
                        }),
                      )
                      .optional(),
                    locations: z
                      .object({
                        cities: z.array(z.string()).optional(),
                        countries: z.array(z.string()).optional(),
                        regions: z.array(z.string()).optional(),
                        zips: z.array(z.string()).optional(),
                      })
                      .optional(),
                    max_age: z.number().optional(),
                    min_age: z.number().optional(),
                  })
                  .optional(),
                type: z
                  .union([
                    z.literal('Custom Audience'),
                    z.literal('Lookalike Audience'),
                    z.literal('Interest-based Audience'),
                  ])
                  .optional(),
              })
              .optional(),
            budget: z
              .object({
                currency_code: z.string().optional(),
                duration: z.number().optional(),
                total_amount: z.number().optional(),
              })
              .optional(),
            channel: z
              .object({
                fb_placement_audience: z.boolean().optional(),
                fb_placement_feed: z.boolean().optional(),
                ig_placement_feed: z.boolean().optional(),
              })
              .optional(),
            content: z
              .object({
                attachments: z
                  .array(
                    z.object({
                      call_to_action: z.string().optional(),
                      description: z.string().optional(),
                      image_url: z.string().optional(),
                      link_url: z.string().optional(),
                      name: z.string().optional(),
                    }),
                  )
                  .optional(),
                call_to_action: z.string().optional(),
                description: z.string().optional(),
                image_url: z.string().optional(),
                link_url: z.string().optional(),
                message: z.string().optional(),
                title: z.string().optional(),
              })
              .optional(),
            feedback: z
              .object({
                audience: z.string().optional(),
                budget: z.string().optional(),
                compliance: z.string().optional(),
                content: z.string().optional(),
              })
              .optional(),
            has_audience: z.boolean().optional(),
            has_content: z.boolean().optional(),
            is_connected: z.boolean().optional(),
            site: z
              .object({
                id: z.number().optional(),
                name: z.string().optional(),
                url: z.string().optional(),
              })
              .optional(),
          }),
        )
        .and(
          z.object({
            _links: z
              .array(
                z.object({
                  href: z.string().optional(),
                  method: z
                    .union([
                      z.literal('GET'),
                      z.literal('POST'),
                      z.literal('PUT'),
                      z.literal('PATCH'),
                      z.literal('DELETE'),
                      z.literal('OPTIONS'),
                      z.literal('HEAD'),
                    ])
                    .optional(),
                  rel: z.string().optional(),
                  schema: z.string().optional(),
                  targetSchema: z.string().optional(),
                }),
              )
              .optional(),
          }),
        ),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getAllFacebookAdsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getFacebookAdsIdDataSchema = z.object({
  path: z.object({
    outreach_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getFacebookAdsIdResponseSchema = z
  .object({
    canceled_at: z.string().optional(),
    create_time: z.string().optional(),
    has_segment: z.boolean().optional(),
    id: z.string().optional(),
    name: z.string().optional(),
    published_time: z.string().optional(),
    recipients: z
      .object({
        list_id: z.string().optional(),
        list_is_active: z.boolean().optional(),
        list_name: z.string().optional(),
        recipient_count: z.number().optional(),
        segment_opts: z
          .object({
            conditions: z
              .array(
                z.union([
                  z.object({
                    condition_type: z.literal('Aim').optional(),
                    field: z.literal('aim').optional(),
                    op: z
                      .union([
                        z.literal('open'),
                        z.literal('click'),
                        z.literal('sent'),
                        z.literal('noopen'),
                        z.literal('noclick'),
                        z.literal('nosent'),
                      ])
                      .optional(),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('Automation').optional(),
                    field: z.literal('automation'),
                    op: z.union([
                      z.literal('started'),
                      z.literal('completed'),
                      z.literal('not_started'),
                      z.literal('not_completed'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('CampaignPoll').optional(),
                    field: z.literal('poll'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('Conversation').optional(),
                    field: z.literal('conversation'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('Date').optional(),
                    extra: z.string().optional(),
                    field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
                    op: z.union([
                      z.literal('greater'),
                      z.literal('less'),
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                      z.literal('within'),
                      z.literal('notwithin'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('EmailClient').optional(),
                    field: z.literal('email_client'),
                    op: z.union([z.literal('client_is'), z.literal('client_not')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('Language').optional(),
                    field: z.literal('language'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('MemberRating').optional(),
                    field: z.literal('rating'),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('SignupSource'),
                    field: z.literal('source'),
                    op: z.union([z.literal('source_is'), z.literal('source_not')]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('SurveyMonkey').optional(),
                    field: z.literal('survey_monkey'),
                    op: z.union([
                      z.literal('started'),
                      z.literal('completed'),
                      z.literal('not_started'),
                      z.literal('not_completed'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('VIP').optional(),
                    field: z.literal('gmonkey'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                  }),
                  z.object({
                    condition_type: z.literal('Interests').optional(),
                    field: z.string().optional(),
                    op: z
                      .union([
                        z.literal('interestcontains'),
                        z.literal('interestcontainsall'),
                        z.literal('interestnotcontains'),
                      ])
                      .optional(),
                    value: z.array(z.string()).optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommCategory').optional(),
                    field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                    op: z
                      .union([
                        z.literal('is'),
                        z.literal('not'),
                        z.literal('contains'),
                        z.literal('notcontain'),
                        z.literal('starts'),
                        z.literal('ends'),
                      ])
                      .optional(),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommNumber').optional(),
                    field: z.union([
                      z.literal('ecomm_spent_avg'),
                      z.literal('ecomm_orders'),
                      z.literal('ecomm_prod_all'),
                      z.literal('ecomm_avg_ord'),
                    ]),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommPurchased').optional(),
                    field: z.literal('ecomm_purchased').optional(),
                    op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommSpent').optional(),
                    field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                    op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                    value: z.number().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommStore').optional(),
                    field: z.literal('ecomm_store').optional(),
                    op: z.union([z.literal('is'), z.literal('not')]).optional(),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('GoalActivity').optional(),
                    field: z.literal('goal'),
                    op: z.union([
                      z.literal('is'),
                      z.literal('goal_not'),
                      z.literal('contains'),
                      z.literal('goal_notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('GoalTimestamp').optional(),
                    field: z.literal('goal_last_visited'),
                    op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('FuzzySegment').optional(),
                    field: z.literal('fuzzy_segment'),
                    op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('StaticSegment').optional(),
                    field: z.literal('static_segment'),
                    op: z.union([z.literal('static_is'), z.literal('static_not')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoCountryState').optional(),
                    field: z.literal('ipgeo'),
                    op: z.union([
                      z.literal('ipgeocountry'),
                      z.literal('ipgeonotcountry'),
                      z.literal('ipgeostate'),
                      z.literal('ipgeonotstate'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    addr: z.string(),
                    condition_type: z.literal('IPGeoIn').optional(),
                    field: z.literal('ipgeo'),
                    lat: z.string(),
                    lng: z.string(),
                    op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoInZip').optional(),
                    extra: z.number(),
                    field: z.literal('ipgeo'),
                    op: z.literal('ipgeoinzip'),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoUnknown').optional(),
                    field: z.literal('ipgeo'),
                    op: z.literal('ipgeounknown'),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoZip').optional(),
                    field: z.literal('ipgeo'),
                    op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('SocialAge').optional(),
                    field: z.literal('social_age'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                  }),
                  z.object({
                    condition_type: z.literal('SocialGender').optional(),
                    field: z.literal('social_gender'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.union([z.literal('male'), z.literal('female')]),
                  }),
                  z.object({
                    condition_type: z.literal('SocialInfluence').optional(),
                    field: z.literal('social_influence'),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('SocialNetworkMember').optional(),
                    field: z.literal('social_network'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                    value: z.union([
                      z.literal('twitter'),
                      z.literal('facebook'),
                      z.literal('linkedin'),
                      z.literal('flickr'),
                      z.literal('foursquare'),
                      z.literal('lastfm'),
                      z.literal('myspace'),
                      z.literal('quora'),
                      z.literal('vimeo'),
                      z.literal('yelp'),
                      z.literal('youtube'),
                    ]),
                  }),
                  z.object({
                    condition_type: z.literal('SocialNetworkFollow').optional(),
                    field: z.literal('social_network'),
                    op: z.union([z.literal('follow'), z.literal('notfollow')]),
                    value: z.literal('twitter_follow'),
                  }),
                  z.object({
                    condition_type: z.literal('AddressMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('ZipMerge').optional(),
                    extra: z.string(),
                    field: z.string(),
                    op: z.literal('geoin'),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('BirthdayMerge').optional(),
                    field: z.string(),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('DateMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('less'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                      z.literal('greater'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('SelectMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                      z.literal('notcontain'),
                      z.literal('contains'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('TextMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                      z.literal('greater'),
                      z.literal('less'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EmailAddress').optional(),
                    field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                      z.literal('greater'),
                      z.literal('less'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('PredictedGender').optional(),
                    field: z.literal('predicted_gender'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.union([z.literal('male'), z.literal('female')]),
                  }),
                  z.object({
                    condition_type: z.literal('PredictedAge').optional(),
                    field: z.literal('predicted_age_range'),
                    op: z.literal('is'),
                    value: z.union([
                      z.literal('18-24'),
                      z.literal('25-34'),
                      z.literal('35-44'),
                      z.literal('45-54'),
                      z.literal('55-64'),
                      z.literal('65+'),
                    ]),
                  }),
                  z.object({
                    condition_type: z.literal('NewSubscribers').optional(),
                    field: z.literal('timestamp_opt').optional(),
                    op: z.literal('date_within').optional(),
                    value: z.string().optional(),
                  }),
                ]),
              )
              .optional(),
            match: z.union([z.literal('any'), z.literal('all')]).optional(),
            prebuilt_segment_id: z.string().optional(),
            saved_segment_id: z.number().optional(),
          })
          .optional(),
        segment_text: z.string().optional(),
      })
      .optional(),
    report_summary: z
      .object({
        click_rate: z.number().optional(),
        clicks: z.number().optional(),
        conversion_rate: z.number().optional(),
        ecommerce: z
          .object({
            average_order_revenue: z.number().optional(),
            currency_code: z.string().optional(),
            total_revenue: z.number().optional(),
          })
          .optional(),
        engagements: z.number().optional(),
        impressions: z.number().optional(),
        open_rate: z.number().optional(),
        opens: z.number().optional(),
        reach: z.number().optional(),
        subscriber_clicks: z.number().optional(),
        subscribes: z.number().optional(),
        total_sent: z.number().optional(),
        unique_opens: z.number().optional(),
        unique_visits: z.number().optional(),
        visits: z.number().optional(),
      })
      .optional(),
    show_report: z.boolean().optional(),
    start_time: z.string().optional(),
    status: z
      .union([
        z.literal('save'),
        z.literal('paused'),
        z.literal('schedule'),
        z.literal('scheduled'),
        z.literal('sending'),
        z.literal('sent'),
        z.literal('canceled'),
        z.literal('canceling'),
        z.literal('active'),
        z.literal('disconnected'),
        z.literal('somepaused'),
        z.literal('draft'),
        z.literal('completed'),
        z.literal('partialRejected'),
        z.literal('pending'),
        z.literal('rejected'),
        z.literal('published'),
        z.literal('unpublished'),
      ])
      .optional(),
    thumbnail: z.string().optional(),
    type: z
      .union([
        z.literal('regular'),
        z.literal('email-touchpoint'),
        z.literal('plaintext'),
        z.literal('rss'),
        z.literal('reconfirm'),
        z.literal('variate'),
        z.literal('absplit'),
        z.literal('automation'),
        z.literal('facebook'),
        z.literal('google'),
        z.literal('autoresponder'),
        z.literal('transactional'),
        z.literal('page'),
        z.literal('website'),
        z.literal('social_post'),
        z.literal('survey'),
        z.literal('customer_journey'),
      ])
      .optional(),
    updated_at: z.string().optional(),
    web_id: z.number().optional(),
  })
  .and(
    z.object({
      email_source_name: z.string().optional(),
      end_time: z.string().optional(),
      needs_attention: z.boolean().optional(),
      paused_at: z.string().optional(),
      was_canceled_by_facebook: z.boolean().optional(),
    }),
  )
  .and(
    z.object({
      audience: z
        .object({
          email_source: z
            .object({
              is_segment: z.boolean().optional(),
              list_name: z.string().optional(),
              name: z.string().optional(),
              segment_type: z.string().optional(),
              type: z.string().optional(),
            })
            .optional(),
          include_source_in_target: z.boolean().optional(),
          lookalike_country_code: z.string().optional(),
          source_type: z.union([z.literal('facebook'), z.literal('list')]).optional(),
          targeting_specs: z
            .object({
              gender: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
              interests: z
                .array(
                  z.object({
                    name: z.string().optional(),
                  }),
                )
                .optional(),
              locations: z
                .object({
                  cities: z.array(z.string()).optional(),
                  countries: z.array(z.string()).optional(),
                  regions: z.array(z.string()).optional(),
                  zips: z.array(z.string()).optional(),
                })
                .optional(),
              max_age: z.number().optional(),
              min_age: z.number().optional(),
            })
            .optional(),
          type: z
            .union([
              z.literal('Custom Audience'),
              z.literal('Lookalike Audience'),
              z.literal('Interest-based Audience'),
            ])
            .optional(),
        })
        .optional(),
      budget: z
        .object({
          currency_code: z.string().optional(),
          duration: z.number().optional(),
          total_amount: z.number().optional(),
        })
        .optional(),
      channel: z
        .object({
          fb_placement_audience: z.boolean().optional(),
          fb_placement_feed: z.boolean().optional(),
          ig_placement_feed: z.boolean().optional(),
        })
        .optional(),
      content: z
        .object({
          attachments: z
            .array(
              z.object({
                call_to_action: z.string().optional(),
                description: z.string().optional(),
                image_url: z.string().optional(),
                link_url: z.string().optional(),
                name: z.string().optional(),
              }),
            )
            .optional(),
          call_to_action: z.string().optional(),
          description: z.string().optional(),
          image_url: z.string().optional(),
          link_url: z.string().optional(),
          message: z.string().optional(),
          title: z.string().optional(),
        })
        .optional(),
      feedback: z
        .object({
          audience: z.string().optional(),
          budget: z.string().optional(),
          compliance: z.string().optional(),
          content: z.string().optional(),
        })
        .optional(),
      has_audience: z.boolean().optional(),
      has_content: z.boolean().optional(),
      is_connected: z.boolean().optional(),
      site: z
        .object({
          id: z.number().optional(),
          name: z.string().optional(),
          url: z.string().optional(),
        })
        .optional(),
    }),
  )
  .and(
    z.object({
      _links: z
        .array(
          z.object({
            href: z.string().optional(),
            method: z
              .union([
                z.literal('GET'),
                z.literal('POST'),
                z.literal('PUT'),
                z.literal('PATCH'),
                z.literal('DELETE'),
                z.literal('OPTIONS'),
                z.literal('HEAD'),
              ])
              .optional(),
            rel: z.string().optional(),
            schema: z.string().optional(),
            targetSchema: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const getFacebookAdsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getFileManagerFilesDataSchema = z.object({
  query: z
    .object({
      before_created_at: z.string().optional(),
      count: z.number().optional(),
      created_by: z.string().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
      since_created_at: z.string().optional(),
      sort_dir: z.union([z.literal('ASC'), z.literal('DESC')]).optional(),
      sort_field: z.union([z.literal('added_date'), z.literal('name'), z.literal('size')]).optional(),
      type: z.string().optional(),
    })
    .optional(),
});

export const getFileManagerFilesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  files: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        created_at: z.string().optional(),
        created_by: z.string().optional(),
        folder_id: z.number().optional(),
        full_size_url: z.string().optional(),
        height: z.number().optional(),
        id: z.number().optional(),
        name: z.string().optional(),
        size: z.number().optional(),
        thumbnail_url: z.string().optional(),
        type: z.union([z.literal('image'), z.literal('file')]).optional(),
        width: z.number().optional(),
      }),
    )
    .optional(),
  total_file_size: z.number().optional(),
  total_items: z.number().optional(),
});

export const getFileManagerFilesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postFileManagerFilesDataSchema = z.object({
  body: z.object({
    file_data: z.string(),
    folder_id: z.number().optional(),
    name: z.string(),
  }),
});

export const postFileManagerFilesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  created_at: z.string().optional(),
  created_by: z.string().optional(),
  folder_id: z.number().optional(),
  full_size_url: z.string().optional(),
  height: z.number().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  size: z.number().optional(),
  thumbnail_url: z.string().optional(),
  type: z.union([z.literal('image'), z.literal('file')]).optional(),
  width: z.number().optional(),
});

export const postFileManagerFilesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteFileManagerFilesIdDataSchema = z.object({
  path: z.object({
    file_id: z.string(),
  }),
});

export const deleteFileManagerFilesIdResponseSchema = z.any();

export const deleteFileManagerFilesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getFileManagerFilesIdDataSchema = z.object({
  path: z.object({
    file_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getFileManagerFilesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  created_at: z.string().optional(),
  created_by: z.string().optional(),
  folder_id: z.number().optional(),
  full_size_url: z.string().optional(),
  height: z.number().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  size: z.number().optional(),
  thumbnail_url: z.string().optional(),
  type: z.union([z.literal('image'), z.literal('file')]).optional(),
  width: z.number().optional(),
});

export const getFileManagerFilesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchFileManagerFilesIdDataSchema = z.object({
  body: z.object({
    folder_id: z.number().optional(),
    name: z.string().optional(),
  }),
  path: z.object({
    file_id: z.string(),
  }),
});

export const patchFileManagerFilesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  created_at: z.string().optional(),
  created_by: z.string().optional(),
  folder_id: z.number().optional(),
  full_size_url: z.string().optional(),
  height: z.number().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  size: z.number().optional(),
  thumbnail_url: z.string().optional(),
  type: z.union([z.literal('image'), z.literal('file')]).optional(),
  width: z.number().optional(),
});

export const patchFileManagerFilesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getFileManagerFoldersDataSchema = z.object({
  query: z
    .object({
      before_created_at: z.string().optional(),
      count: z.number().optional(),
      created_by: z.string().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
      since_created_at: z.string().optional(),
    })
    .optional(),
});

export const getFileManagerFoldersResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  folders: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        created_at: z.string().optional(),
        created_by: z.string().optional(),
        file_count: z.number().optional(),
        id: z.number().optional(),
        name: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getFileManagerFoldersErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postFileManagerFoldersDataSchema = z.object({
  body: z.object({
    name: z.string(),
  }),
});

export const postFileManagerFoldersResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  created_at: z.string().optional(),
  created_by: z.string().optional(),
  file_count: z.number().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
});

export const postFileManagerFoldersErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteFileManagerFoldersIdDataSchema = z.object({
  path: z.object({
    folder_id: z.string(),
  }),
});

export const deleteFileManagerFoldersIdResponseSchema = z.any();

export const deleteFileManagerFoldersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getFileManagerFoldersIdDataSchema = z.object({
  path: z.object({
    folder_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getFileManagerFoldersIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  created_at: z.string().optional(),
  created_by: z.string().optional(),
  file_count: z.number().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
});

export const getFileManagerFoldersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchFileManagerFoldersIdDataSchema = z.object({
  body: z.object({
    name: z.string(),
  }),
  path: z.object({
    folder_id: z.string(),
  }),
});

export const patchFileManagerFoldersIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  created_at: z.string().optional(),
  created_by: z.string().optional(),
  file_count: z.number().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
});

export const patchFileManagerFoldersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getFileManagerFoldersFilesDataSchema = z.object({
  path: z.object({
    folder_id: z.string(),
  }),
  query: z
    .object({
      before_created_at: z.string().optional(),
      count: z.number().optional(),
      created_by: z.string().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
      since_created_at: z.string().optional(),
      sort_dir: z.union([z.literal('ASC'), z.literal('DESC')]).optional(),
      sort_field: z.union([z.literal('added_date'), z.literal('name'), z.literal('size')]).optional(),
      type: z.string().optional(),
    })
    .optional(),
});

export const getFileManagerFoldersFilesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  files: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        created_at: z.string().optional(),
        created_by: z.string().optional(),
        folder_id: z.number().optional(),
        full_size_url: z.string().optional(),
        height: z.number().optional(),
        id: z.number().optional(),
        name: z.string().optional(),
        size: z.number().optional(),
        thumbnail_url: z.string().optional(),
        type: z.union([z.literal('image'), z.literal('file')]).optional(),
        width: z.number().optional(),
      }),
    )
    .optional(),
  total_file_size: z.number().optional(),
  total_items: z.number().optional(),
});

export const getFileManagerFoldersFilesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getAllLandingPagesDataSchema = z.object({
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      sort_dir: z.union([z.literal('ASC'), z.literal('DESC')]).optional(),
      sort_field: z.union([z.literal('created_at'), z.literal('updated_at')]).optional(),
    })
    .optional(),
});

export const getAllLandingPagesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  landing_pages: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        created_at: z.string().optional(),
        created_by_source: z.string().optional(),
        description: z.string().optional(),
        id: z.string().optional(),
        list_id: z.string().optional(),
        name: z.string().optional(),
        published_at: z.string().optional(),
        status: z.union([z.literal('published'), z.literal('unpublished'), z.literal('draft')]).optional(),
        store_id: z.string().optional(),
        template_id: z.number().optional(),
        title: z.string().optional(),
        tracking: z
          .object({
            enable_restricted_data_processing: z.boolean().optional(),
            track_with_mailchimp: z.boolean().optional(),
          })
          .optional(),
        unpublished_at: z.string().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        web_id: z.number().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getAllLandingPagesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postAllLandingPagesDataSchema = z.object({
  body: z.object({
    description: z.string().optional(),
    list_id: z.string().optional(),
    name: z.string().optional(),
    store_id: z.string().optional(),
    template_id: z.number().optional(),
    title: z.string().optional(),
    tracking: z
      .object({
        enable_restricted_data_processing: z.boolean().optional(),
        track_with_mailchimp: z.boolean().optional(),
      })
      .optional(),
    type: z.union([z.literal('signup'), z.literal('product')]).optional(),
  }),
  query: z
    .object({
      use_default_list: z.boolean().optional(),
    })
    .optional(),
});

export const postAllLandingPagesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  created_at: z.string().optional(),
  created_by_source: z.string().optional(),
  description: z.string().optional(),
  id: z.string().optional(),
  list_id: z.string().optional(),
  name: z.string().optional(),
  published_at: z.string().optional(),
  status: z.union([z.literal('published'), z.literal('unpublished'), z.literal('draft')]).optional(),
  store_id: z.string().optional(),
  template_id: z.number().optional(),
  title: z.string().optional(),
  tracking: z
    .object({
      enable_restricted_data_processing: z.boolean().optional(),
      track_with_mailchimp: z.boolean().optional(),
    })
    .optional(),
  unpublished_at: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  web_id: z.number().optional(),
});

export const postAllLandingPagesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteLandingPageIdDataSchema = z.object({
  path: z.object({
    page_id: z.string(),
  }),
});

export const deleteLandingPageIdResponseSchema = z.any();

export const deleteLandingPageIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getLandingPageIdDataSchema = z.object({
  path: z.object({
    page_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getLandingPageIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  created_at: z.string().optional(),
  created_by_source: z.string().optional(),
  description: z.string().optional(),
  id: z.string().optional(),
  list_id: z.string().optional(),
  name: z.string().optional(),
  published_at: z.string().optional(),
  status: z.union([z.literal('published'), z.literal('unpublished'), z.literal('draft')]).optional(),
  store_id: z.string().optional(),
  template_id: z.number().optional(),
  title: z.string().optional(),
  tracking: z
    .object({
      enable_restricted_data_processing: z.boolean().optional(),
      track_with_mailchimp: z.boolean().optional(),
    })
    .optional(),
  unpublished_at: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  web_id: z.number().optional(),
});

export const getLandingPageIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchLandingPageIdDataSchema = z.object({
  body: z.object({
    description: z.string().optional(),
    list_id: z.string().optional(),
    name: z.string().optional(),
    store_id: z.string().optional(),
    title: z.string().optional(),
    tracking: z
      .object({
        enable_restricted_data_processing: z.boolean().optional(),
        track_with_mailchimp: z.boolean().optional(),
      })
      .optional(),
  }),
  path: z.object({
    page_id: z.string(),
  }),
});

export const patchLandingPageIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  created_at: z.string().optional(),
  created_by_source: z.string().optional(),
  description: z.string().optional(),
  id: z.string().optional(),
  list_id: z.string().optional(),
  name: z.string().optional(),
  published_at: z.string().optional(),
  status: z.union([z.literal('published'), z.literal('unpublished'), z.literal('draft')]).optional(),
  store_id: z.string().optional(),
  template_id: z.number().optional(),
  title: z.string().optional(),
  tracking: z
    .object({
      enable_restricted_data_processing: z.boolean().optional(),
      track_with_mailchimp: z.boolean().optional(),
    })
    .optional(),
  unpublished_at: z.string().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  web_id: z.number().optional(),
});

export const patchLandingPageIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postLandingPageIdActionsPublishDataSchema = z.object({
  path: z.object({
    page_id: z.string(),
  }),
});

export const postLandingPageIdActionsPublishResponseSchema = z.any();

export const postLandingPageIdActionsPublishErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postLandingPageIdActionsUnpublishDataSchema = z.object({
  path: z.object({
    page_id: z.string(),
  }),
});

export const postLandingPageIdActionsUnpublishResponseSchema = z.any();

export const postLandingPageIdActionsUnpublishErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getLandingPageIdContentDataSchema = z.object({
  path: z.object({
    page_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getLandingPageIdContentResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  html: z.string().optional(),
  json: z.string().optional(),
});

export const getLandingPageIdContentErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsDataSchema = z.object({
  query: z
    .object({
      before_campaign_last_sent: z.string().optional(),
      before_date_created: z.string().optional(),
      count: z.number().optional(),
      email: z.string().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      has_ecommerce_store: z.boolean().optional(),
      include_total_contacts: z.boolean().optional(),
      offset: z.number().optional(),
      since_campaign_last_sent: z.string().optional(),
      since_date_created: z.string().optional(),
      sort_dir: z.union([z.literal('ASC'), z.literal('DESC')]).optional(),
      sort_field: z.literal('date_created').optional(),
    })
    .optional(),
});

export const getListsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  constraints: z
    .object({
      current_total_instances: z.number().optional(),
      max_instances: z.number(),
      may_create: z.boolean(),
    })
    .optional(),
  lists: z.array(
    z.object({
      _links: z
        .array(
          z.object({
            href: z.string().optional(),
            method: z
              .union([
                z.literal('GET'),
                z.literal('POST'),
                z.literal('PUT'),
                z.literal('PATCH'),
                z.literal('DELETE'),
                z.literal('OPTIONS'),
                z.literal('HEAD'),
              ])
              .optional(),
            rel: z.string().optional(),
            schema: z.string().optional(),
            targetSchema: z.string().optional(),
          }),
        )
        .optional(),
      beamer_address: z.string().optional(),
      campaign_defaults: z
        .object({
          from_email: z.string().optional(),
          from_name: z.string().optional(),
          language: z.string().optional(),
          subject: z.string().optional(),
        })
        .optional(),
      contact: z
        .object({
          address1: z.string().optional(),
          address2: z.string().optional(),
          city: z.string().optional(),
          company: z.string().optional(),
          country: z.string().optional(),
          phone: z.string().optional(),
          state: z.string().optional(),
          zip: z.string().optional(),
        })
        .optional(),
      date_created: z.string().optional(),
      double_optin: z.boolean().optional(),
      email_type_option: z.boolean().optional(),
      has_welcome: z.boolean().optional(),
      id: z.string().optional(),
      list_rating: z.number().optional(),
      marketing_permissions: z.boolean().optional(),
      modules: z.array(z.string()).optional(),
      name: z.string().optional(),
      notify_on_subscribe: z.string().optional(),
      notify_on_unsubscribe: z.string().optional(),
      permission_reminder: z.string().optional(),
      stats: z
        .object({
          avg_sub_rate: z.number().optional(),
          avg_unsub_rate: z.number().optional(),
          campaign_count: z.number().optional(),
          campaign_last_sent: z.string().optional(),
          cleaned_count: z.number().optional(),
          cleaned_count_since_send: z.number().optional(),
          click_rate: z.number().optional(),
          last_sub_date: z.string().optional(),
          last_unsub_date: z.string().optional(),
          member_count: z.number().optional(),
          member_count_since_send: z.number().optional(),
          merge_field_count: z.number().optional(),
          open_rate: z.number().optional(),
          target_sub_rate: z.number().optional(),
          total_contacts: z.number().optional(),
          unsubscribe_count: z.number().optional(),
          unsubscribe_count_since_send: z.number().optional(),
        })
        .optional(),
      subscribe_url_long: z.string().optional(),
      subscribe_url_short: z.string().optional(),
      use_archive_bar: z.boolean().optional(),
      visibility: z.union([z.literal('pub'), z.literal('prv')]).optional(),
      web_id: z.number().optional(),
    }),
  ),
  total_items: z.number().optional(),
});

export const getListsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postListsDataSchema = z.object({
  body: z.object({
    campaign_defaults: z.object({
      from_email: z.string(),
      from_name: z.string(),
      language: z.string(),
      subject: z.string(),
    }),
    contact: z.object({
      address1: z.string(),
      address2: z.string().optional(),
      city: z.string(),
      company: z.string(),
      country: z.string(),
      phone: z.string().optional(),
      state: z.string().optional(),
      zip: z.string().optional(),
    }),
    double_optin: z.boolean().optional(),
    email_type_option: z.boolean(),
    marketing_permissions: z.boolean().optional(),
    name: z.string(),
    notify_on_subscribe: z.string().optional(),
    notify_on_unsubscribe: z.string().optional(),
    permission_reminder: z.string(),
    use_archive_bar: z.boolean().optional(),
  }),
});

export const postListsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  beamer_address: z.string().optional(),
  campaign_defaults: z
    .object({
      from_email: z.string().optional(),
      from_name: z.string().optional(),
      language: z.string().optional(),
      subject: z.string().optional(),
    })
    .optional(),
  contact: z
    .object({
      address1: z.string().optional(),
      address2: z.string().optional(),
      city: z.string().optional(),
      company: z.string().optional(),
      country: z.string().optional(),
      phone: z.string().optional(),
      state: z.string().optional(),
      zip: z.string().optional(),
    })
    .optional(),
  date_created: z.string().optional(),
  double_optin: z.boolean().optional(),
  email_type_option: z.boolean().optional(),
  has_welcome: z.boolean().optional(),
  id: z.string().optional(),
  list_rating: z.number().optional(),
  marketing_permissions: z.boolean().optional(),
  modules: z.array(z.string()).optional(),
  name: z.string().optional(),
  notify_on_subscribe: z.string().optional(),
  notify_on_unsubscribe: z.string().optional(),
  permission_reminder: z.string().optional(),
  stats: z
    .object({
      avg_sub_rate: z.number().optional(),
      avg_unsub_rate: z.number().optional(),
      campaign_count: z.number().optional(),
      campaign_last_sent: z.string().optional(),
      cleaned_count: z.number().optional(),
      cleaned_count_since_send: z.number().optional(),
      click_rate: z.number().optional(),
      last_sub_date: z.string().optional(),
      last_unsub_date: z.string().optional(),
      member_count: z.number().optional(),
      member_count_since_send: z.number().optional(),
      merge_field_count: z.number().optional(),
      open_rate: z.number().optional(),
      target_sub_rate: z.number().optional(),
      total_contacts: z.number().optional(),
      unsubscribe_count: z.number().optional(),
      unsubscribe_count_since_send: z.number().optional(),
    })
    .optional(),
  subscribe_url_long: z.string().optional(),
  subscribe_url_short: z.string().optional(),
  use_archive_bar: z.boolean().optional(),
  visibility: z.union([z.literal('pub'), z.literal('prv')]).optional(),
  web_id: z.number().optional(),
});

export const postListsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteListsIdDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
  }),
});

export const deleteListsIdResponseSchema = z.any();

export const deleteListsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      include_total_contacts: z.boolean().optional(),
    })
    .optional(),
});

export const getListsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  beamer_address: z.string().optional(),
  campaign_defaults: z
    .object({
      from_email: z.string().optional(),
      from_name: z.string().optional(),
      language: z.string().optional(),
      subject: z.string().optional(),
    })
    .optional(),
  contact: z
    .object({
      address1: z.string().optional(),
      address2: z.string().optional(),
      city: z.string().optional(),
      company: z.string().optional(),
      country: z.string().optional(),
      phone: z.string().optional(),
      state: z.string().optional(),
      zip: z.string().optional(),
    })
    .optional(),
  date_created: z.string().optional(),
  double_optin: z.boolean().optional(),
  email_type_option: z.boolean().optional(),
  has_welcome: z.boolean().optional(),
  id: z.string().optional(),
  list_rating: z.number().optional(),
  marketing_permissions: z.boolean().optional(),
  modules: z.array(z.string()).optional(),
  name: z.string().optional(),
  notify_on_subscribe: z.string().optional(),
  notify_on_unsubscribe: z.string().optional(),
  permission_reminder: z.string().optional(),
  stats: z
    .object({
      avg_sub_rate: z.number().optional(),
      avg_unsub_rate: z.number().optional(),
      campaign_count: z.number().optional(),
      campaign_last_sent: z.string().optional(),
      cleaned_count: z.number().optional(),
      cleaned_count_since_send: z.number().optional(),
      click_rate: z.number().optional(),
      last_sub_date: z.string().optional(),
      last_unsub_date: z.string().optional(),
      member_count: z.number().optional(),
      member_count_since_send: z.number().optional(),
      merge_field_count: z.number().optional(),
      open_rate: z.number().optional(),
      target_sub_rate: z.number().optional(),
      total_contacts: z.number().optional(),
      unsubscribe_count: z.number().optional(),
      unsubscribe_count_since_send: z.number().optional(),
    })
    .optional(),
  subscribe_url_long: z.string().optional(),
  subscribe_url_short: z.string().optional(),
  use_archive_bar: z.boolean().optional(),
  visibility: z.union([z.literal('pub'), z.literal('prv')]).optional(),
  web_id: z.number().optional(),
});

export const getListsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchListsIdDataSchema = z.object({
  body: z.object({
    campaign_defaults: z.object({
      from_email: z.string(),
      from_name: z.string(),
      language: z.string(),
      subject: z.string(),
    }),
    contact: z.object({
      address1: z.string(),
      address2: z.string().optional(),
      city: z.string(),
      company: z.string(),
      country: z.string(),
      phone: z.string().optional(),
      state: z.string(),
      zip: z.string(),
    }),
    double_optin: z.boolean().optional(),
    email_type_option: z.boolean(),
    marketing_permissions: z.boolean().optional(),
    name: z.string(),
    notify_on_subscribe: z.string().optional(),
    notify_on_unsubscribe: z.string().optional(),
    permission_reminder: z.string(),
    use_archive_bar: z.boolean().optional(),
  }),
  path: z.object({
    list_id: z.string(),
  }),
});

export const patchListsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  beamer_address: z.string().optional(),
  campaign_defaults: z
    .object({
      from_email: z.string().optional(),
      from_name: z.string().optional(),
      language: z.string().optional(),
      subject: z.string().optional(),
    })
    .optional(),
  contact: z
    .object({
      address1: z.string().optional(),
      address2: z.string().optional(),
      city: z.string().optional(),
      company: z.string().optional(),
      country: z.string().optional(),
      phone: z.string().optional(),
      state: z.string().optional(),
      zip: z.string().optional(),
    })
    .optional(),
  date_created: z.string().optional(),
  double_optin: z.boolean().optional(),
  email_type_option: z.boolean().optional(),
  has_welcome: z.boolean().optional(),
  id: z.string().optional(),
  list_rating: z.number().optional(),
  marketing_permissions: z.boolean().optional(),
  modules: z.array(z.string()).optional(),
  name: z.string().optional(),
  notify_on_subscribe: z.string().optional(),
  notify_on_unsubscribe: z.string().optional(),
  permission_reminder: z.string().optional(),
  stats: z
    .object({
      avg_sub_rate: z.number().optional(),
      avg_unsub_rate: z.number().optional(),
      campaign_count: z.number().optional(),
      campaign_last_sent: z.string().optional(),
      cleaned_count: z.number().optional(),
      cleaned_count_since_send: z.number().optional(),
      click_rate: z.number().optional(),
      last_sub_date: z.string().optional(),
      last_unsub_date: z.string().optional(),
      member_count: z.number().optional(),
      member_count_since_send: z.number().optional(),
      merge_field_count: z.number().optional(),
      open_rate: z.number().optional(),
      target_sub_rate: z.number().optional(),
      total_contacts: z.number().optional(),
      unsubscribe_count: z.number().optional(),
      unsubscribe_count_since_send: z.number().optional(),
    })
    .optional(),
  subscribe_url_long: z.string().optional(),
  subscribe_url_short: z.string().optional(),
  use_archive_bar: z.boolean().optional(),
  visibility: z.union([z.literal('pub'), z.literal('prv')]).optional(),
  web_id: z.number().optional(),
});

export const patchListsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postListsIdDataSchema = z.object({
  body: z.object({
    members: z.array(
      z.object({
        email_address: z.string().optional(),
        email_type: z.string().optional(),
        interests: z.record(z.boolean()).optional(),
        ip_opt: z.string().optional(),
        ip_signup: z.string().optional(),
        language: z.string().optional(),
        location: z
          .object({
            latitude: z.number().optional(),
            longitude: z.number().optional(),
          })
          .optional(),
        merge_fields: z.record(z.unknown()).optional(),
        status: z
          .union([
            z.literal('subscribed'),
            z.literal('unsubscribed'),
            z.literal('cleaned'),
            z.literal('pending'),
            z.literal('transactional'),
          ])
          .optional(),
        timestamp_opt: z.string().optional(),
        timestamp_signup: z.string().optional(),
        vip: z.boolean().optional(),
      }),
    ),
    sync_tags: z.boolean().optional(),
    update_existing: z.boolean().optional(),
  }),
  path: z.object({
    list_id: z.string(),
  }),
  query: z
    .object({
      skip_duplicate_check: z.boolean().optional(),
      skip_merge_validation: z.boolean().optional(),
    })
    .optional(),
});

export const postListsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  error_count: z.number().optional(),
  errors: z
    .array(
      z.object({
        email_address: z.string().optional(),
        error: z.string().optional(),
        error_code: z.union([z.literal('ERROR_CONTACT_EXISTS'), z.literal('ERROR_GENERIC')]).optional(),
        field: z.string().optional(),
        field_message: z.string().optional(),
      }),
    )
    .optional(),
  new_members: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        email_address: z.string().optional(),
        email_client: z.string().optional(),
        email_type: z.string().optional(),
        id: z.string().optional(),
        interests: z.record(z.boolean()).optional(),
        ip_opt: z.string().optional(),
        ip_signup: z.string().optional(),
        language: z.string().optional(),
        last_changed: z.string().optional(),
        last_note: z
          .object({
            created_at: z.string().optional(),
            created_by: z.string().optional(),
            note: z.string().optional(),
            note_id: z.number().optional(),
          })
          .optional(),
        list_id: z.string().optional(),
        location: z
          .object({
            country_code: z.string().optional(),
            dstoff: z.number().optional(),
            gmtoff: z.number().optional(),
            latitude: z.number().optional(),
            longitude: z.number().optional(),
            timezone: z.string().optional(),
          })
          .optional(),
        member_rating: z.number().optional(),
        merge_fields: z.record(z.unknown()).optional(),
        stats: z
          .object({
            avg_click_rate: z.number().optional(),
            avg_open_rate: z.number().optional(),
          })
          .optional(),
        status: z
          .union([
            z.literal('subscribed'),
            z.literal('unsubscribed'),
            z.literal('cleaned'),
            z.literal('pending'),
            z.literal('transactional'),
          ])
          .optional(),
        tags: z
          .array(
            z.object({
              id: z.number().optional(),
              name: z.string().optional(),
            }),
          )
          .optional(),
        tags_count: z.number().optional(),
        timestamp_opt: z.string().optional(),
        timestamp_signup: z.string().optional(),
        unique_email_id: z.string().optional(),
        vip: z.boolean().optional(),
      }),
    )
    .optional(),
  total_created: z.number().optional(),
  total_updated: z.number().optional(),
  updated_members: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        email_address: z.string().optional(),
        email_client: z.string().optional(),
        email_type: z.string().optional(),
        id: z.string().optional(),
        interests: z.record(z.boolean()).optional(),
        ip_opt: z.string().optional(),
        ip_signup: z.string().optional(),
        language: z.string().optional(),
        last_changed: z.string().optional(),
        last_note: z
          .object({
            created_at: z.string().optional(),
            created_by: z.string().optional(),
            note: z.string().optional(),
            note_id: z.number().optional(),
          })
          .optional(),
        list_id: z.string().optional(),
        location: z
          .object({
            country_code: z.string().optional(),
            dstoff: z.number().optional(),
            gmtoff: z.number().optional(),
            latitude: z.number().optional(),
            longitude: z.number().optional(),
            timezone: z.string().optional(),
          })
          .optional(),
        member_rating: z.number().optional(),
        merge_fields: z.record(z.unknown()).optional(),
        stats: z
          .object({
            avg_click_rate: z.number().optional(),
            avg_open_rate: z.number().optional(),
          })
          .optional(),
        status: z
          .union([
            z.literal('subscribed'),
            z.literal('unsubscribed'),
            z.literal('cleaned'),
            z.literal('pending'),
            z.literal('transactional'),
          ])
          .optional(),
        tags: z
          .array(
            z.object({
              id: z.number().optional(),
              name: z.string().optional(),
            }),
          )
          .optional(),
        tags_count: z.number().optional(),
        timestamp_opt: z.string().optional(),
        timestamp_signup: z.string().optional(),
        unique_email_id: z.string().optional(),
        vip: z.boolean().optional(),
      }),
    )
    .optional(),
});

export const postListsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdAbuseReportsDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getListsIdAbuseReportsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  abuse_reports: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        campaign_id: z.string().optional(),
        date: z.string().optional(),
        email_address: z.string().optional(),
        email_id: z.string().optional(),
        id: z.number().optional(),
        list_id: z.string().optional(),
        merge_fields: z.record(z.unknown()).optional(),
        vip: z.boolean().optional(),
      }),
    )
    .optional(),
  list_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getListsIdAbuseReportsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdAbuseReportsIdDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    report_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getListsIdAbuseReportsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  campaign_id: z.string().optional(),
  date: z.string().optional(),
  email_address: z.string().optional(),
  email_id: z.string().optional(),
  id: z.number().optional(),
  list_id: z.string().optional(),
  merge_fields: z.record(z.unknown()).optional(),
  vip: z.boolean().optional(),
});

export const getListsIdAbuseReportsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdActivityDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getListsIdActivityResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  activity: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        day: z.string().optional(),
        emails_sent: z.number().optional(),
        hard_bounce: z.number().optional(),
        other_adds: z.number().optional(),
        other_removes: z.number().optional(),
        recipient_clicks: z.number().optional(),
        soft_bounce: z.number().optional(),
        subs: z.number().optional(),
        unique_opens: z.number().optional(),
        unsubs: z.number().optional(),
      }),
    )
    .optional(),
  list_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getListsIdActivityErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdClientsDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getListsIdClientsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  clients: z
    .array(
      z.object({
        client: z.string().optional(),
        members: z.number().optional(),
      }),
    )
    .optional(),
  list_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getListsIdClientsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdGrowthHistoryDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
      sort_dir: z.union([z.literal('ASC'), z.literal('DESC')]).optional(),
      sort_field: z.literal('month').optional(),
    })
    .optional(),
});

export const getListsIdGrowthHistoryResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  history: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        cleaned: z.number().optional(),
        deleted: z.number().optional(),
        existing: z.number().optional(),
        imports: z.number().optional(),
        list_id: z.string().optional(),
        month: z.string().optional(),
        optins: z.number().optional(),
        pending: z.number().optional(),
        reconfirm: z.number().optional(),
        subscribed: z.number().optional(),
        transactional: z.number().optional(),
        unsubscribed: z.number().optional(),
      }),
    )
    .optional(),
  list_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getListsIdGrowthHistoryErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdGrowthHistoryIdDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    month: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getListsIdGrowthHistoryIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  cleaned: z.number().optional(),
  deleted: z.number().optional(),
  existing: z.number().optional(),
  imports: z.number().optional(),
  list_id: z.string().optional(),
  month: z.string().optional(),
  optins: z.number().optional(),
  pending: z.number().optional(),
  reconfirm: z.number().optional(),
  subscribed: z.number().optional(),
  transactional: z.number().optional(),
  unsubscribed: z.number().optional(),
});

export const getListsIdGrowthHistoryIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdInterestCategoriesDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
      type: z.string().optional(),
    })
    .optional(),
});

export const getListsIdInterestCategoriesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  categories: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        display_order: z.number().optional(),
        id: z.string().optional(),
        list_id: z.string().optional(),
        title: z.string().optional(),
        type: z
          .union([z.literal('checkboxes'), z.literal('dropdown'), z.literal('radio'), z.literal('hidden')])
          .optional(),
      }),
    )
    .optional(),
  list_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getListsIdInterestCategoriesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postListsIdInterestCategoriesDataSchema = z.object({
  body: z.object({
    display_order: z.number().optional(),
    title: z.string(),
    type: z.union([z.literal('checkboxes'), z.literal('dropdown'), z.literal('radio'), z.literal('hidden')]),
  }),
  path: z.object({
    list_id: z.string(),
  }),
});

export const postListsIdInterestCategoriesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  display_order: z.number().optional(),
  id: z.string().optional(),
  list_id: z.string().optional(),
  title: z.string().optional(),
  type: z.union([z.literal('checkboxes'), z.literal('dropdown'), z.literal('radio'), z.literal('hidden')]).optional(),
});

export const postListsIdInterestCategoriesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteListsIdInterestCategoriesIdDataSchema = z.object({
  path: z.object({
    interest_category_id: z.string(),
    list_id: z.string(),
  }),
});

export const deleteListsIdInterestCategoriesIdResponseSchema = z.any();

export const deleteListsIdInterestCategoriesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdInterestCategoriesIdDataSchema = z.object({
  path: z.object({
    interest_category_id: z.string(),
    list_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getListsIdInterestCategoriesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  display_order: z.number().optional(),
  id: z.string().optional(),
  list_id: z.string().optional(),
  title: z.string().optional(),
  type: z.union([z.literal('checkboxes'), z.literal('dropdown'), z.literal('radio'), z.literal('hidden')]).optional(),
});

export const getListsIdInterestCategoriesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchListsIdInterestCategoriesIdDataSchema = z.object({
  body: z.object({
    display_order: z.number().optional(),
    title: z.string(),
    type: z.union([z.literal('checkboxes'), z.literal('dropdown'), z.literal('radio'), z.literal('hidden')]),
  }),
  path: z.object({
    interest_category_id: z.string(),
    list_id: z.string(),
  }),
});

export const patchListsIdInterestCategoriesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  display_order: z.number().optional(),
  id: z.string().optional(),
  list_id: z.string().optional(),
  title: z.string().optional(),
  type: z.union([z.literal('checkboxes'), z.literal('dropdown'), z.literal('radio'), z.literal('hidden')]).optional(),
});

export const patchListsIdInterestCategoriesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdInterestCategoriesIdInterestsDataSchema = z.object({
  path: z.object({
    interest_category_id: z.string(),
    list_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getListsIdInterestCategoriesIdInterestsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  category_id: z.string().optional(),
  interests: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        category_id: z.string().optional(),
        display_order: z.number().optional(),
        id: z.string().optional(),
        list_id: z.string().optional(),
        name: z.string().optional(),
        subscriber_count: z.string().optional(),
      }),
    )
    .optional(),
  list_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getListsIdInterestCategoriesIdInterestsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postListsIdInterestCategoriesIdInterestsDataSchema = z.object({
  body: z.object({
    display_order: z.number().optional(),
    name: z.string(),
  }),
  path: z.object({
    interest_category_id: z.string(),
    list_id: z.string(),
  }),
});

export const postListsIdInterestCategoriesIdInterestsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  category_id: z.string().optional(),
  display_order: z.number().optional(),
  id: z.string().optional(),
  list_id: z.string().optional(),
  name: z.string().optional(),
  subscriber_count: z.string().optional(),
});

export const postListsIdInterestCategoriesIdInterestsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteListsIdInterestCategoriesIdInterestsIdDataSchema = z.object({
  path: z.object({
    interest_category_id: z.string(),
    interest_id: z.string(),
    list_id: z.string(),
  }),
});

export const deleteListsIdInterestCategoriesIdInterestsIdResponseSchema = z.any();

export const deleteListsIdInterestCategoriesIdInterestsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdInterestCategoriesIdInterestsIdDataSchema = z.object({
  path: z.object({
    interest_category_id: z.string(),
    interest_id: z.string(),
    list_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getListsIdInterestCategoriesIdInterestsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  category_id: z.string().optional(),
  display_order: z.number().optional(),
  id: z.string().optional(),
  list_id: z.string().optional(),
  name: z.string().optional(),
  subscriber_count: z.string().optional(),
});

export const getListsIdInterestCategoriesIdInterestsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchListsIdInterestCategoriesIdInterestsIdDataSchema = z.object({
  body: z.object({
    display_order: z.number().optional(),
    name: z.string(),
  }),
  path: z.object({
    interest_category_id: z.string(),
    interest_id: z.string(),
    list_id: z.string(),
  }),
});

export const patchListsIdInterestCategoriesIdInterestsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  category_id: z.string().optional(),
  display_order: z.number().optional(),
  id: z.string().optional(),
  list_id: z.string().optional(),
  name: z.string().optional(),
  subscriber_count: z.string().optional(),
});

export const patchListsIdInterestCategoriesIdInterestsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdLocationsDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getListsIdLocationsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  list_id: z.string().optional(),
  locations: z
    .array(
      z.object({
        cc: z.string().optional(),
        country: z.string().optional(),
        percent: z.number().optional(),
        total: z.number().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getListsIdLocationsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdMembersDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
  }),
  query: z
    .object({
      before_last_changed: z.string().optional(),
      before_timestamp_opt: z.string().optional(),
      count: z.number().optional(),
      email_type: z.string().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      interest_category_id: z.string().optional(),
      interest_ids: z.string().optional(),
      interest_match: z.union([z.literal('any'), z.literal('all'), z.literal('none')]).optional(),
      offset: z.number().optional(),
      since_last_campaign: z.boolean().optional(),
      since_last_changed: z.string().optional(),
      since_timestamp_opt: z.string().optional(),
      sort_dir: z.union([z.literal('ASC'), z.literal('DESC')]).optional(),
      sort_field: z
        .union([z.literal('timestamp_opt'), z.literal('timestamp_signup'), z.literal('last_changed')])
        .optional(),
      status: z
        .union([
          z.literal('subscribed'),
          z.literal('unsubscribed'),
          z.literal('cleaned'),
          z.literal('pending'),
          z.literal('transactional'),
          z.literal('archived'),
        ])
        .optional(),
      unique_email_id: z.string().optional(),
      unsubscribed_since: z.string().optional(),
      vip_only: z.boolean().optional(),
    })
    .optional(),
});

export const getListsIdMembersResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  list_id: z.string().optional(),
  members: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        consents_to_one_to_one_messaging: z.boolean().optional(),
        contact_id: z.string().optional(),
        email_address: z.string().optional(),
        email_client: z.string().optional(),
        email_type: z.string().optional(),
        full_name: z.string().optional(),
        id: z.string().optional(),
        interests: z.record(z.boolean()).optional(),
        ip_opt: z.string().optional(),
        ip_signup: z.string().optional(),
        language: z.string().optional(),
        last_changed: z.string().optional(),
        last_note: z
          .object({
            created_at: z.string().optional(),
            created_by: z.string().optional(),
            note: z.string().optional(),
            note_id: z.number().optional(),
          })
          .optional(),
        list_id: z.string().optional(),
        location: z
          .object({
            country_code: z.string().optional(),
            dstoff: z.number().optional(),
            gmtoff: z.number().optional(),
            latitude: z.number().optional(),
            longitude: z.number().optional(),
            region: z.string().optional(),
            timezone: z.string().optional(),
          })
          .optional(),
        marketing_permissions: z
          .array(
            z.object({
              enabled: z.boolean().optional(),
              marketing_permission_id: z.string().optional(),
              text: z.string().optional(),
            }),
          )
          .optional(),
        member_rating: z.number().optional(),
        merge_fields: z.record(z.unknown()).optional(),
        source: z.string().optional(),
        stats: z
          .object({
            avg_click_rate: z.number().optional(),
            avg_open_rate: z.number().optional(),
            ecommerce_data: z
              .object({
                currency_code: z.string().optional(),
                number_of_orders: z.number().optional(),
                total_revenue: z.number().optional(),
              })
              .optional(),
          })
          .optional(),
        status: z
          .union([
            z.literal('subscribed'),
            z.literal('unsubscribed'),
            z.literal('cleaned'),
            z.literal('pending'),
            z.literal('transactional'),
            z.literal('archived'),
          ])
          .optional(),
        tags: z
          .array(
            z.object({
              id: z.number().optional(),
              name: z.string().optional(),
            }),
          )
          .optional(),
        tags_count: z.number().optional(),
        timestamp_opt: z.string().optional(),
        timestamp_signup: z.string().optional(),
        unique_email_id: z.string().optional(),
        unsubscribe_reason: z.string().optional(),
        vip: z.boolean().optional(),
        web_id: z.number().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getListsIdMembersErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postListsIdMembersDataSchema = z.object({
  body: z.object({
    email_address: z.string(),
    email_type: z.string().optional(),
    interests: z.record(z.boolean()).optional(),
    ip_opt: z.string().optional(),
    ip_signup: z.string().optional(),
    language: z.string().optional(),
    location: z
      .object({
        latitude: z.number().optional(),
        longitude: z.number().optional(),
      })
      .optional(),
    marketing_permissions: z
      .array(
        z.object({
          enabled: z.boolean().optional(),
          marketing_permission_id: z.string().optional(),
        }),
      )
      .optional(),
    merge_fields: z.record(z.unknown()).optional(),
    status: z.union([
      z.literal('subscribed'),
      z.literal('unsubscribed'),
      z.literal('cleaned'),
      z.literal('pending'),
      z.literal('transactional'),
    ]),
    tags: z.array(z.string()).optional(),
    timestamp_opt: z.string().optional(),
    timestamp_signup: z.string().optional(),
    vip: z.boolean().optional(),
  }),
  path: z.object({
    list_id: z.string(),
  }),
  query: z
    .object({
      skip_merge_validation: z.boolean().optional(),
    })
    .optional(),
});

export const postListsIdMembersResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  consents_to_one_to_one_messaging: z.boolean().optional(),
  contact_id: z.string().optional(),
  email_address: z.string().optional(),
  email_client: z.string().optional(),
  email_type: z.string().optional(),
  full_name: z.string().optional(),
  id: z.string().optional(),
  interests: z.record(z.boolean()).optional(),
  ip_opt: z.string().optional(),
  ip_signup: z.string().optional(),
  language: z.string().optional(),
  last_changed: z.string().optional(),
  last_note: z
    .object({
      created_at: z.string().optional(),
      created_by: z.string().optional(),
      note: z.string().optional(),
      note_id: z.number().optional(),
    })
    .optional(),
  list_id: z.string().optional(),
  location: z
    .object({
      country_code: z.string().optional(),
      dstoff: z.number().optional(),
      gmtoff: z.number().optional(),
      latitude: z.number().optional(),
      longitude: z.number().optional(),
      region: z.string().optional(),
      timezone: z.string().optional(),
    })
    .optional(),
  marketing_permissions: z
    .array(
      z.object({
        enabled: z.boolean().optional(),
        marketing_permission_id: z.string().optional(),
        text: z.string().optional(),
      }),
    )
    .optional(),
  member_rating: z.number().optional(),
  merge_fields: z.record(z.unknown()).optional(),
  source: z.string().optional(),
  stats: z
    .object({
      avg_click_rate: z.number().optional(),
      avg_open_rate: z.number().optional(),
      ecommerce_data: z
        .object({
          currency_code: z.string().optional(),
          number_of_orders: z.number().optional(),
          total_revenue: z.number().optional(),
        })
        .optional(),
    })
    .optional(),
  status: z
    .union([
      z.literal('subscribed'),
      z.literal('unsubscribed'),
      z.literal('cleaned'),
      z.literal('pending'),
      z.literal('transactional'),
      z.literal('archived'),
    ])
    .optional(),
  tags: z
    .array(
      z.object({
        id: z.number().optional(),
        name: z.string().optional(),
      }),
    )
    .optional(),
  tags_count: z.number().optional(),
  timestamp_opt: z.string().optional(),
  timestamp_signup: z.string().optional(),
  unique_email_id: z.string().optional(),
  unsubscribe_reason: z.string().optional(),
  vip: z.boolean().optional(),
  web_id: z.number().optional(),
});

export const postListsIdMembersErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteListsIdMembersIdDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    subscriber_hash: z.string(),
  }),
});

export const deleteListsIdMembersIdResponseSchema = z.any();

export const deleteListsIdMembersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdMembersIdDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    subscriber_hash: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getListsIdMembersIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  consents_to_one_to_one_messaging: z.boolean().optional(),
  contact_id: z.string().optional(),
  email_address: z.string().optional(),
  email_client: z.string().optional(),
  email_type: z.string().optional(),
  full_name: z.string().optional(),
  id: z.string().optional(),
  interests: z.record(z.boolean()).optional(),
  ip_opt: z.string().optional(),
  ip_signup: z.string().optional(),
  language: z.string().optional(),
  last_changed: z.string().optional(),
  last_note: z
    .object({
      created_at: z.string().optional(),
      created_by: z.string().optional(),
      note: z.string().optional(),
      note_id: z.number().optional(),
    })
    .optional(),
  list_id: z.string().optional(),
  location: z
    .object({
      country_code: z.string().optional(),
      dstoff: z.number().optional(),
      gmtoff: z.number().optional(),
      latitude: z.number().optional(),
      longitude: z.number().optional(),
      region: z.string().optional(),
      timezone: z.string().optional(),
    })
    .optional(),
  marketing_permissions: z
    .array(
      z.object({
        enabled: z.boolean().optional(),
        marketing_permission_id: z.string().optional(),
        text: z.string().optional(),
      }),
    )
    .optional(),
  member_rating: z.number().optional(),
  merge_fields: z.record(z.unknown()).optional(),
  source: z.string().optional(),
  stats: z
    .object({
      avg_click_rate: z.number().optional(),
      avg_open_rate: z.number().optional(),
      ecommerce_data: z
        .object({
          currency_code: z.string().optional(),
          number_of_orders: z.number().optional(),
          total_revenue: z.number().optional(),
        })
        .optional(),
    })
    .optional(),
  status: z
    .union([
      z.literal('subscribed'),
      z.literal('unsubscribed'),
      z.literal('cleaned'),
      z.literal('pending'),
      z.literal('transactional'),
      z.literal('archived'),
    ])
    .optional(),
  tags: z
    .array(
      z.object({
        id: z.number().optional(),
        name: z.string().optional(),
      }),
    )
    .optional(),
  tags_count: z.number().optional(),
  timestamp_opt: z.string().optional(),
  timestamp_signup: z.string().optional(),
  unique_email_id: z.string().optional(),
  unsubscribe_reason: z.string().optional(),
  vip: z.boolean().optional(),
  web_id: z.number().optional(),
});

export const getListsIdMembersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchListsIdMembersIdDataSchema = z.object({
  body: z.object({
    email_address: z.string().optional(),
    email_type: z.string().optional(),
    interests: z.record(z.boolean()).optional(),
    ip_opt: z.string().optional(),
    ip_signup: z.string().optional(),
    language: z.string().optional(),
    location: z
      .object({
        latitude: z.number().optional(),
        longitude: z.number().optional(),
      })
      .optional(),
    marketing_permissions: z
      .array(
        z.object({
          enabled: z.boolean().optional(),
          marketing_permission_id: z.string().optional(),
        }),
      )
      .optional(),
    merge_fields: z.record(z.unknown()).optional(),
    status: z
      .union([z.literal('subscribed'), z.literal('unsubscribed'), z.literal('cleaned'), z.literal('pending')])
      .optional(),
    timestamp_opt: z.string().optional(),
    timestamp_signup: z.string().optional(),
    vip: z.boolean().optional(),
  }),
  path: z.object({
    list_id: z.string(),
    subscriber_hash: z.string(),
  }),
  query: z
    .object({
      skip_merge_validation: z.boolean().optional(),
    })
    .optional(),
});

export const patchListsIdMembersIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  consents_to_one_to_one_messaging: z.boolean().optional(),
  contact_id: z.string().optional(),
  email_address: z.string().optional(),
  email_client: z.string().optional(),
  email_type: z.string().optional(),
  full_name: z.string().optional(),
  id: z.string().optional(),
  interests: z.record(z.boolean()).optional(),
  ip_opt: z.string().optional(),
  ip_signup: z.string().optional(),
  language: z.string().optional(),
  last_changed: z.string().optional(),
  last_note: z
    .object({
      created_at: z.string().optional(),
      created_by: z.string().optional(),
      note: z.string().optional(),
      note_id: z.number().optional(),
    })
    .optional(),
  list_id: z.string().optional(),
  location: z
    .object({
      country_code: z.string().optional(),
      dstoff: z.number().optional(),
      gmtoff: z.number().optional(),
      latitude: z.number().optional(),
      longitude: z.number().optional(),
      region: z.string().optional(),
      timezone: z.string().optional(),
    })
    .optional(),
  marketing_permissions: z
    .array(
      z.object({
        enabled: z.boolean().optional(),
        marketing_permission_id: z.string().optional(),
        text: z.string().optional(),
      }),
    )
    .optional(),
  member_rating: z.number().optional(),
  merge_fields: z.record(z.unknown()).optional(),
  source: z.string().optional(),
  stats: z
    .object({
      avg_click_rate: z.number().optional(),
      avg_open_rate: z.number().optional(),
      ecommerce_data: z
        .object({
          currency_code: z.string().optional(),
          number_of_orders: z.number().optional(),
          total_revenue: z.number().optional(),
        })
        .optional(),
    })
    .optional(),
  status: z
    .union([
      z.literal('subscribed'),
      z.literal('unsubscribed'),
      z.literal('cleaned'),
      z.literal('pending'),
      z.literal('transactional'),
      z.literal('archived'),
    ])
    .optional(),
  tags: z
    .array(
      z.object({
        id: z.number().optional(),
        name: z.string().optional(),
      }),
    )
    .optional(),
  tags_count: z.number().optional(),
  timestamp_opt: z.string().optional(),
  timestamp_signup: z.string().optional(),
  unique_email_id: z.string().optional(),
  unsubscribe_reason: z.string().optional(),
  vip: z.boolean().optional(),
  web_id: z.number().optional(),
});

export const patchListsIdMembersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const putListsIdMembersIdDataSchema = z.object({
  body: z.object({
    email_address: z.string(),
    email_type: z.string().optional(),
    interests: z.record(z.boolean()).optional(),
    ip_opt: z.string().optional(),
    ip_signup: z.string().optional(),
    language: z.string().optional(),
    location: z
      .object({
        latitude: z.number().optional(),
        longitude: z.number().optional(),
      })
      .optional(),
    marketing_permissions: z
      .array(
        z.object({
          enabled: z.boolean().optional(),
          marketing_permission_id: z.string().optional(),
        }),
      )
      .optional(),
    merge_fields: z.record(z.unknown()).optional(),
    status: z
      .union([
        z.literal('subscribed'),
        z.literal('unsubscribed'),
        z.literal('cleaned'),
        z.literal('pending'),
        z.literal('transactional'),
      ])
      .optional(),
    status_if_new: z.union([
      z.literal('subscribed'),
      z.literal('unsubscribed'),
      z.literal('cleaned'),
      z.literal('pending'),
      z.literal('transactional'),
    ]),
    timestamp_opt: z.string().optional(),
    timestamp_signup: z.string().optional(),
    vip: z.boolean().optional(),
  }),
  path: z.object({
    list_id: z.string(),
    subscriber_hash: z.string(),
  }),
  query: z
    .object({
      skip_merge_validation: z.boolean().optional(),
    })
    .optional(),
});

export const putListsIdMembersIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  consents_to_one_to_one_messaging: z.boolean().optional(),
  contact_id: z.string().optional(),
  email_address: z.string().optional(),
  email_client: z.string().optional(),
  email_type: z.string().optional(),
  full_name: z.string().optional(),
  id: z.string().optional(),
  interests: z.record(z.boolean()).optional(),
  ip_opt: z.string().optional(),
  ip_signup: z.string().optional(),
  language: z.string().optional(),
  last_changed: z.string().optional(),
  last_note: z
    .object({
      created_at: z.string().optional(),
      created_by: z.string().optional(),
      note: z.string().optional(),
      note_id: z.number().optional(),
    })
    .optional(),
  list_id: z.string().optional(),
  location: z
    .object({
      country_code: z.string().optional(),
      dstoff: z.number().optional(),
      gmtoff: z.number().optional(),
      latitude: z.number().optional(),
      longitude: z.number().optional(),
      region: z.string().optional(),
      timezone: z.string().optional(),
    })
    .optional(),
  marketing_permissions: z
    .array(
      z.object({
        enabled: z.boolean().optional(),
        marketing_permission_id: z.string().optional(),
        text: z.string().optional(),
      }),
    )
    .optional(),
  member_rating: z.number().optional(),
  merge_fields: z.record(z.unknown()).optional(),
  source: z.string().optional(),
  stats: z
    .object({
      avg_click_rate: z.number().optional(),
      avg_open_rate: z.number().optional(),
      ecommerce_data: z
        .object({
          currency_code: z.string().optional(),
          number_of_orders: z.number().optional(),
          total_revenue: z.number().optional(),
        })
        .optional(),
    })
    .optional(),
  status: z
    .union([
      z.literal('subscribed'),
      z.literal('unsubscribed'),
      z.literal('cleaned'),
      z.literal('pending'),
      z.literal('transactional'),
      z.literal('archived'),
    ])
    .optional(),
  tags: z
    .array(
      z.object({
        id: z.number().optional(),
        name: z.string().optional(),
      }),
    )
    .optional(),
  tags_count: z.number().optional(),
  timestamp_opt: z.string().optional(),
  timestamp_signup: z.string().optional(),
  unique_email_id: z.string().optional(),
  unsubscribe_reason: z.string().optional(),
  vip: z.boolean().optional(),
  web_id: z.number().optional(),
});

export const putListsIdMembersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postListsIdMembersHashActionsDeletePermanentDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    subscriber_hash: z.string(),
  }),
});

export const postListsIdMembersHashActionsDeletePermanentResponseSchema = z.any();

export const postListsIdMembersHashActionsDeletePermanentErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdMembersIdActivityDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    subscriber_hash: z.string(),
  }),
  query: z
    .object({
      action: z.array(z.string()).optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getListsIdMembersIdActivityResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  activity: z
    .array(
      z.object({
        action: z.string().optional(),
        campaign_id: z.string().optional(),
        parent_campaign: z.string().optional(),
        timestamp: z.string().optional(),
        title: z.string().optional(),
        type: z.string().optional(),
        url: z.string().optional(),
      }),
    )
    .optional(),
  contact_id: z.string().optional(),
  email_id: z.string().optional(),
  list_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getListsIdMembersIdActivityErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdMembersIdActivityFeedDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    subscriber_hash: z.string(),
  }),
  query: z
    .object({
      activity_filters: z.array(z.string()).optional(),
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getListsIdMembersIdActivityFeedResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  activity: z
    .array(
      z.union([
        z.object({
          activity_type: z.literal('open').optional(),
          campaign_id: z.string().optional(),
          campaign_title: z.string().optional(),
          created_at_timestamp: z.string().optional(),
        }),
        z.object({
          activity_type: z.literal('click').optional(),
          campaign_id: z.string().optional(),
          campaign_title: z.string().optional(),
          created_at_timestamp: z.string().optional(),
          link_clicked: z.string().optional(),
        }),
        z.object({
          activity_type: z.literal('bounce').optional(),
          bounce_has_open_activity: z.boolean().optional(),
          bounce_type: z.union([z.literal('hard'), z.literal('soft')]).optional(),
          campaign_id: z.string().optional(),
          campaign_title: z.string().optional(),
          created_at_timestamp: z.string().optional(),
        }),
        z.object({
          activity_type: z.literal('unsub').optional(),
          campaign_id: z.string().optional(),
          campaign_title: z.string().optional(),
          created_at_timestamp: z.string().optional(),
          is_admin_unsubscribed: z.boolean().optional(),
          unsubscribe_reason: z.string().optional(),
        }),
        z.object({
          activity_type: z.literal('sent').optional(),
          campaign_id: z.string().optional(),
          campaign_title: z.string().optional(),
          created_at_timestamp: z.string().optional(),
        }),
        z.object({
          activity_type: z.literal('conversation').optional(),
          avatar_url: z.string().optional(),
          campaign_id: z.string().optional(),
          campaign_title: z.string().optional(),
          created_at_timestamp: z.string().optional(),
          created_by: z.string().optional(),
          from_email: z.string().optional(),
          has_read: z.boolean().optional(),
          is_user: z.boolean().optional(),
          message_text: z.string().optional(),
          thread_id: z.string().optional(),
        }),
        z.object({
          activity_type: z.literal('note').optional(),
          avatar_url: z.string().optional(),
          created_at_timestamp: z.string().optional(),
          created_by: z.string().optional(),
          note_id: z.string().optional(),
          note_text: z.string().optional(),
          updated_at_timestamp: z.string().optional(),
        }),
        z.object({
          activity_type: z.literal('marketing_permission').optional(),
          created_at_timestamp: z.string().optional(),
          marketing_permission_opted_in: z.boolean().optional(),
          marketing_permisson_text: z.string().optional(),
          updated_by: z.string().optional(),
        }),
        z.object({
          activity_type: z.literal('postcard_sent').optional(),
          created_at_timestamp: z.string().optional(),
          outreach_id: z.string().optional(),
          outreach_title: z.string().optional(),
        }),
        z.object({
          activity_type: z.literal('squatter_signup').optional(),
          created_at_timestamp: z.string().optional(),
          outreach_id: z.string().optional(),
          outreach_title: z.string().optional(),
        }),
        z.object({
          activity_type: z.literal('website_signup').optional(),
          created_at_timestamp: z.string().optional(),
          outreach_id: z.string().optional(),
          outreach_title: z.string().optional(),
        }),
        z.object({
          activity_type: z.literal('landing_page_signup').optional(),
          created_at_timestamp: z.string().optional(),
          outreach_id: z.string().optional(),
          outreach_title: z.string().optional(),
        }),
        z.object({
          activity_type: z.literal('ecommerce_signup').optional(),
          created_at_timestamp: z.string().optional(),
          store_name: z.string().optional(),
        }),
        z.object({
          activity_type: z.literal('generic_signup').optional(),
          created_at_timestamp: z.string().optional(),
          signup_category: z.string().optional(),
        }),
        z.object({
          activity_type: z.literal('order').optional(),
          created_at_timestamp: z.string().optional(),
          order_id: z.string().optional(),
          order_items: z
            .array(
              z.object({
                _links: z
                  .array(
                    z.object({
                      href: z.string().optional(),
                      method: z
                        .union([
                          z.literal('GET'),
                          z.literal('POST'),
                          z.literal('PUT'),
                          z.literal('PATCH'),
                          z.literal('DELETE'),
                          z.literal('OPTIONS'),
                          z.literal('HEAD'),
                        ])
                        .optional(),
                      rel: z.string().optional(),
                      schema: z.string().optional(),
                      targetSchema: z.string().optional(),
                    }),
                  )
                  .optional(),
                discount: z.number().optional(),
                id: z.string().optional(),
                image_url: z.string().optional(),
                price: z.number().optional(),
                product_id: z.string().optional(),
                product_title: z.string().optional(),
                product_variant_id: z.string().optional(),
                product_variant_title: z.string().optional(),
                quantity: z.number().optional(),
              }),
            )
            .optional(),
          order_total: z.string().optional(),
          order_url: z.string().optional(),
          outreach_id: z.string().optional(),
          outreach_title: z.string().optional(),
          outreach_type: z.string().optional(),
          store_name: z.string().optional(),
        }),
        z.object({
          activity_type: z.literal('event').optional(),
          created_at_timestamp: z.string().optional(),
          event_name: z.string().optional(),
          event_properties: z.array(z.string()).optional(),
        }),
        z.object({
          activity_type: z.literal('survey_response').optional(),
          created_at_timestamp: z.string().optional(),
          survey_id: z.string().optional(),
          survey_title: z.string().optional(),
        }),
      ]),
    )
    .optional(),
  email_id: z.string().optional(),
  list_id: z.string().optional(),
});

export const getListsIdMembersIdActivityFeedErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdMembersIdEventsDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    subscriber_hash: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getListsIdMembersIdEventsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  events: z
    .array(
      z.object({
        name: z.string().optional(),
        occurred_at: z.string().optional(),
        properties: z.record(z.string()).optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getListsIdMembersIdEventsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postListMemberEventsDataSchema = z.object({
  body: z.object({
    is_syncing: z.boolean().optional(),
    name: z.string(),
    occurred_at: z.string().optional(),
    properties: z.record(z.string()).optional(),
  }),
  path: z.object({
    list_id: z.string(),
    subscriber_hash: z.string(),
  }),
});

export const postListMemberEventsResponseSchema = z.any();

export const postListMemberEventsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdMembersIdGoalsDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    subscriber_hash: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getListsIdMembersIdGoalsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  email_id: z.string().optional(),
  goals: z
    .array(
      z.object({
        data: z.string().optional(),
        event: z.string().optional(),
        goal_id: z.number().optional(),
        last_visited_at: z.string().optional(),
      }),
    )
    .optional(),
  list_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getListsIdMembersIdGoalsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdMembersIdNotesDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    subscriber_hash: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
      sort_dir: z.union([z.literal('ASC'), z.literal('DESC')]).optional(),
      sort_field: z.union([z.literal('created_at'), z.literal('updated_at'), z.literal('note_id')]).optional(),
    })
    .optional(),
});

export const getListsIdMembersIdNotesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  email_id: z.string().optional(),
  list_id: z.string().optional(),
  notes: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        contact_id: z.string().optional(),
        created_at: z.string().optional(),
        created_by: z.string().optional(),
        email_id: z.string().optional(),
        id: z.number().optional(),
        list_id: z.string().optional(),
        note: z.string().optional(),
        updated_at: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getListsIdMembersIdNotesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postListsIdMembersIdNotesDataSchema = z.object({
  body: z.object({
    note: z.string().optional(),
  }),
  path: z.object({
    list_id: z.string(),
    subscriber_hash: z.string(),
  }),
});

export const postListsIdMembersIdNotesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  contact_id: z.string().optional(),
  created_at: z.string().optional(),
  created_by: z.string().optional(),
  email_id: z.string().optional(),
  id: z.number().optional(),
  list_id: z.string().optional(),
  note: z.string().optional(),
  updated_at: z.string().optional(),
});

export const postListsIdMembersIdNotesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteListsIdMembersIdNotesIdDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    note_id: z.string(),
    subscriber_hash: z.string(),
  }),
});

export const deleteListsIdMembersIdNotesIdResponseSchema = z.any();

export const deleteListsIdMembersIdNotesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdMembersIdNotesIdDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    note_id: z.string(),
    subscriber_hash: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getListsIdMembersIdNotesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  contact_id: z.string().optional(),
  created_at: z.string().optional(),
  created_by: z.string().optional(),
  email_id: z.string().optional(),
  id: z.number().optional(),
  list_id: z.string().optional(),
  note: z.string().optional(),
  updated_at: z.string().optional(),
});

export const getListsIdMembersIdNotesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchListsIdMembersIdNotesIdDataSchema = z.object({
  body: z.object({
    note: z.string().optional(),
  }),
  path: z.object({
    list_id: z.string(),
    note_id: z.string(),
    subscriber_hash: z.string(),
  }),
});

export const patchListsIdMembersIdNotesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  contact_id: z.string().optional(),
  created_at: z.string().optional(),
  created_by: z.string().optional(),
  email_id: z.string().optional(),
  id: z.number().optional(),
  list_id: z.string().optional(),
  note: z.string().optional(),
  updated_at: z.string().optional(),
});

export const patchListsIdMembersIdNotesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListMemberTagsDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    subscriber_hash: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getListMemberTagsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  tags: z
    .array(
      z.object({
        date_added: z.string().optional(),
        id: z.number().optional(),
        name: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getListMemberTagsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postListMemberTagsDataSchema = z.object({
  body: z.object({
    is_syncing: z.boolean().optional(),
    tags: z.array(
      z.object({
        name: z.string(),
        status: z.union([z.literal('inactive'), z.literal('active')]),
      }),
    ),
  }),
  path: z.object({
    list_id: z.string(),
    subscriber_hash: z.string(),
  }),
});

export const postListMemberTagsResponseSchema = z.any();

export const postListMemberTagsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdMergeFieldsDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
      required: z.boolean().optional(),
      type: z.string().optional(),
    })
    .optional(),
});

export const getListsIdMergeFieldsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  list_id: z.string().optional(),
  merge_fields: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        default_value: z.string().optional(),
        display_order: z.number().optional(),
        help_text: z.string().optional(),
        list_id: z.string().optional(),
        merge_id: z.number().optional(),
        name: z.string().optional(),
        options: z
          .object({
            choices: z.array(z.string()).optional(),
            date_format: z.string().optional(),
            default_country: z.number().optional(),
            phone_format: z.string().optional(),
            size: z.number().optional(),
          })
          .optional(),
        public: z.boolean().optional(),
        required: z.boolean().optional(),
        tag: z.string().optional(),
        type: z
          .union([
            z.literal('text'),
            z.literal('number'),
            z.literal('address'),
            z.literal('phone'),
            z.literal('date'),
            z.literal('url'),
            z.literal('imageurl'),
            z.literal('radio'),
            z.literal('dropdown'),
            z.literal('birthday'),
            z.literal('zip'),
          ])
          .optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getListsIdMergeFieldsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postListsIdMergeFieldsDataSchema = z.object({
  body: z.object({
    default_value: z.string().optional(),
    display_order: z.number().optional(),
    help_text: z.string().optional(),
    name: z.string(),
    options: z
      .object({
        choices: z.array(z.string()).optional(),
        date_format: z.string().optional(),
        default_country: z.number().optional(),
        phone_format: z.string().optional(),
        size: z.number().optional(),
      })
      .optional(),
    public: z.boolean().optional(),
    required: z.boolean().optional(),
    tag: z.string().optional(),
    type: z.union([
      z.literal('text'),
      z.literal('number'),
      z.literal('address'),
      z.literal('phone'),
      z.literal('date'),
      z.literal('url'),
      z.literal('imageurl'),
      z.literal('radio'),
      z.literal('dropdown'),
      z.literal('birthday'),
      z.literal('zip'),
    ]),
  }),
  path: z.object({
    list_id: z.string(),
  }),
});

export const postListsIdMergeFieldsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  default_value: z.string().optional(),
  display_order: z.number().optional(),
  help_text: z.string().optional(),
  list_id: z.string().optional(),
  merge_id: z.number().optional(),
  name: z.string().optional(),
  options: z
    .object({
      choices: z.array(z.string()).optional(),
      date_format: z.string().optional(),
      default_country: z.number().optional(),
      phone_format: z.string().optional(),
      size: z.number().optional(),
    })
    .optional(),
  public: z.boolean().optional(),
  required: z.boolean().optional(),
  tag: z.string().optional(),
  type: z
    .union([
      z.literal('text'),
      z.literal('number'),
      z.literal('address'),
      z.literal('phone'),
      z.literal('date'),
      z.literal('url'),
      z.literal('imageurl'),
      z.literal('radio'),
      z.literal('dropdown'),
      z.literal('birthday'),
      z.literal('zip'),
    ])
    .optional(),
});

export const postListsIdMergeFieldsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteListsIdMergeFieldsIdDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    merge_id: z.string(),
  }),
});

export const deleteListsIdMergeFieldsIdResponseSchema = z.any();

export const deleteListsIdMergeFieldsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdMergeFieldsIdDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    merge_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getListsIdMergeFieldsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  default_value: z.string().optional(),
  display_order: z.number().optional(),
  help_text: z.string().optional(),
  list_id: z.string().optional(),
  merge_id: z.number().optional(),
  name: z.string().optional(),
  options: z
    .object({
      choices: z.array(z.string()).optional(),
      date_format: z.string().optional(),
      default_country: z.number().optional(),
      phone_format: z.string().optional(),
      size: z.number().optional(),
    })
    .optional(),
  public: z.boolean().optional(),
  required: z.boolean().optional(),
  tag: z.string().optional(),
  type: z
    .union([
      z.literal('text'),
      z.literal('number'),
      z.literal('address'),
      z.literal('phone'),
      z.literal('date'),
      z.literal('url'),
      z.literal('imageurl'),
      z.literal('radio'),
      z.literal('dropdown'),
      z.literal('birthday'),
      z.literal('zip'),
    ])
    .optional(),
});

export const getListsIdMergeFieldsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchListsIdMergeFieldsIdDataSchema = z.object({
  body: z.object({
    default_value: z.string().optional(),
    display_order: z.number().optional(),
    help_text: z.string().optional(),
    name: z.string(),
    options: z
      .object({
        choices: z.array(z.string()).optional(),
        date_format: z.string().optional(),
        default_country: z.number().optional(),
        phone_format: z.string().optional(),
      })
      .optional(),
    public: z.boolean().optional(),
    required: z.boolean().optional(),
    tag: z.string().optional(),
  }),
  path: z.object({
    list_id: z.string(),
    merge_id: z.string(),
  }),
});

export const patchListsIdMergeFieldsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  default_value: z.string().optional(),
  display_order: z.number().optional(),
  help_text: z.string().optional(),
  list_id: z.string().optional(),
  merge_id: z.number().optional(),
  name: z.string().optional(),
  options: z
    .object({
      choices: z.array(z.string()).optional(),
      date_format: z.string().optional(),
      default_country: z.number().optional(),
      phone_format: z.string().optional(),
      size: z.number().optional(),
    })
    .optional(),
  public: z.boolean().optional(),
  required: z.boolean().optional(),
  tag: z.string().optional(),
  type: z
    .union([
      z.literal('text'),
      z.literal('number'),
      z.literal('address'),
      z.literal('phone'),
      z.literal('date'),
      z.literal('url'),
      z.literal('imageurl'),
      z.literal('radio'),
      z.literal('dropdown'),
      z.literal('birthday'),
      z.literal('zip'),
    ])
    .optional(),
});

export const patchListsIdMergeFieldsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const previewAsegmentDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
  }),
  query: z
    .object({
      before_created_at: z.string().optional(),
      before_updated_at: z.string().optional(),
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      include_cleaned: z.boolean().optional(),
      include_transactional: z.boolean().optional(),
      include_unsubscribed: z.boolean().optional(),
      offset: z.number().optional(),
      since_created_at: z.string().optional(),
      since_updated_at: z.string().optional(),
      type: z.string().optional(),
    })
    .optional(),
});

export const previewAsegmentResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  list_id: z.string().optional(),
  segments: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        created_at: z.string().optional(),
        id: z.number().optional(),
        list_id: z.string().optional(),
        member_count: z.number().optional(),
        name: z.string().optional(),
        options: z
          .object({
            conditions: z
              .array(
                z.union([
                  z.object({
                    condition_type: z.literal('Aim').optional(),
                    field: z.literal('aim').optional(),
                    op: z
                      .union([
                        z.literal('open'),
                        z.literal('click'),
                        z.literal('sent'),
                        z.literal('noopen'),
                        z.literal('noclick'),
                        z.literal('nosent'),
                      ])
                      .optional(),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('Automation').optional(),
                    field: z.literal('automation'),
                    op: z.union([
                      z.literal('started'),
                      z.literal('completed'),
                      z.literal('not_started'),
                      z.literal('not_completed'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('CampaignPoll').optional(),
                    field: z.literal('poll'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('Conversation').optional(),
                    field: z.literal('conversation'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('Date').optional(),
                    extra: z.string().optional(),
                    field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
                    op: z.union([
                      z.literal('greater'),
                      z.literal('less'),
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                      z.literal('within'),
                      z.literal('notwithin'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('EmailClient').optional(),
                    field: z.literal('email_client'),
                    op: z.union([z.literal('client_is'), z.literal('client_not')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('Language').optional(),
                    field: z.literal('language'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('MemberRating').optional(),
                    field: z.literal('rating'),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('SignupSource'),
                    field: z.literal('source'),
                    op: z.union([z.literal('source_is'), z.literal('source_not')]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('SurveyMonkey').optional(),
                    field: z.literal('survey_monkey'),
                    op: z.union([
                      z.literal('started'),
                      z.literal('completed'),
                      z.literal('not_started'),
                      z.literal('not_completed'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('VIP').optional(),
                    field: z.literal('gmonkey'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                  }),
                  z.object({
                    condition_type: z.literal('Interests').optional(),
                    field: z.string().optional(),
                    op: z
                      .union([
                        z.literal('interestcontains'),
                        z.literal('interestcontainsall'),
                        z.literal('interestnotcontains'),
                      ])
                      .optional(),
                    value: z.array(z.string()).optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommCategory').optional(),
                    field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                    op: z
                      .union([
                        z.literal('is'),
                        z.literal('not'),
                        z.literal('contains'),
                        z.literal('notcontain'),
                        z.literal('starts'),
                        z.literal('ends'),
                      ])
                      .optional(),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommNumber').optional(),
                    field: z.union([
                      z.literal('ecomm_spent_avg'),
                      z.literal('ecomm_orders'),
                      z.literal('ecomm_prod_all'),
                      z.literal('ecomm_avg_ord'),
                    ]),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommPurchased').optional(),
                    field: z.literal('ecomm_purchased').optional(),
                    op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommSpent').optional(),
                    field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                    op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                    value: z.number().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommStore').optional(),
                    field: z.literal('ecomm_store').optional(),
                    op: z.union([z.literal('is'), z.literal('not')]).optional(),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('GoalActivity').optional(),
                    field: z.literal('goal'),
                    op: z.union([
                      z.literal('is'),
                      z.literal('goal_not'),
                      z.literal('contains'),
                      z.literal('goal_notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('GoalTimestamp').optional(),
                    field: z.literal('goal_last_visited'),
                    op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('FuzzySegment').optional(),
                    field: z.literal('fuzzy_segment'),
                    op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('StaticSegment').optional(),
                    field: z.literal('static_segment'),
                    op: z.union([z.literal('static_is'), z.literal('static_not')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoCountryState').optional(),
                    field: z.literal('ipgeo'),
                    op: z.union([
                      z.literal('ipgeocountry'),
                      z.literal('ipgeonotcountry'),
                      z.literal('ipgeostate'),
                      z.literal('ipgeonotstate'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    addr: z.string(),
                    condition_type: z.literal('IPGeoIn').optional(),
                    field: z.literal('ipgeo'),
                    lat: z.string(),
                    lng: z.string(),
                    op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoInZip').optional(),
                    extra: z.number(),
                    field: z.literal('ipgeo'),
                    op: z.literal('ipgeoinzip'),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoUnknown').optional(),
                    field: z.literal('ipgeo'),
                    op: z.literal('ipgeounknown'),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoZip').optional(),
                    field: z.literal('ipgeo'),
                    op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('SocialAge').optional(),
                    field: z.literal('social_age'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                  }),
                  z.object({
                    condition_type: z.literal('SocialGender').optional(),
                    field: z.literal('social_gender'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.union([z.literal('male'), z.literal('female')]),
                  }),
                  z.object({
                    condition_type: z.literal('SocialInfluence').optional(),
                    field: z.literal('social_influence'),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('SocialNetworkMember').optional(),
                    field: z.literal('social_network'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                    value: z.union([
                      z.literal('twitter'),
                      z.literal('facebook'),
                      z.literal('linkedin'),
                      z.literal('flickr'),
                      z.literal('foursquare'),
                      z.literal('lastfm'),
                      z.literal('myspace'),
                      z.literal('quora'),
                      z.literal('vimeo'),
                      z.literal('yelp'),
                      z.literal('youtube'),
                    ]),
                  }),
                  z.object({
                    condition_type: z.literal('SocialNetworkFollow').optional(),
                    field: z.literal('social_network'),
                    op: z.union([z.literal('follow'), z.literal('notfollow')]),
                    value: z.literal('twitter_follow'),
                  }),
                  z.object({
                    condition_type: z.literal('AddressMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('ZipMerge').optional(),
                    extra: z.string(),
                    field: z.string(),
                    op: z.literal('geoin'),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('BirthdayMerge').optional(),
                    field: z.string(),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('DateMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('less'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                      z.literal('greater'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('SelectMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                      z.literal('notcontain'),
                      z.literal('contains'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('TextMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                      z.literal('greater'),
                      z.literal('less'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EmailAddress').optional(),
                    field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                      z.literal('greater'),
                      z.literal('less'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('PredictedGender').optional(),
                    field: z.literal('predicted_gender'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.union([z.literal('male'), z.literal('female')]),
                  }),
                  z.object({
                    condition_type: z.literal('PredictedAge').optional(),
                    field: z.literal('predicted_age_range'),
                    op: z.literal('is'),
                    value: z.union([
                      z.literal('18-24'),
                      z.literal('25-34'),
                      z.literal('35-44'),
                      z.literal('45-54'),
                      z.literal('55-64'),
                      z.literal('65+'),
                    ]),
                  }),
                  z.object({
                    condition_type: z.literal('NewSubscribers').optional(),
                    field: z.literal('timestamp_opt').optional(),
                    op: z.literal('date_within').optional(),
                    value: z.string().optional(),
                  }),
                ]),
              )
              .optional(),
            match: z.union([z.literal('any'), z.literal('all')]).optional(),
          })
          .optional(),
        type: z.union([z.literal('saved'), z.literal('static'), z.literal('fuzzy')]).optional(),
        updated_at: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const previewAsegmentErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postListsIdSegmentsDataSchema = z.object({
  body: z.object({
    name: z.string(),
    options: z
      .object({
        conditions: z
          .array(
            z.union([
              z.object({
                condition_type: z.literal('Aim').optional(),
                field: z.literal('aim').optional(),
                op: z
                  .union([
                    z.literal('open'),
                    z.literal('click'),
                    z.literal('sent'),
                    z.literal('noopen'),
                    z.literal('noclick'),
                    z.literal('nosent'),
                  ])
                  .optional(),
                value: z.string().optional(),
              }),
              z.object({
                condition_type: z.literal('Automation').optional(),
                field: z.literal('automation'),
                op: z.union([
                  z.literal('started'),
                  z.literal('completed'),
                  z.literal('not_started'),
                  z.literal('not_completed'),
                ]),
                value: z.string(),
              }),
              z.object({
                condition_type: z.literal('CampaignPoll').optional(),
                field: z.literal('poll'),
                op: z.union([z.literal('member'), z.literal('notmember')]),
                value: z.number(),
              }),
              z.object({
                condition_type: z.literal('Conversation').optional(),
                field: z.literal('conversation'),
                op: z.union([z.literal('member'), z.literal('notmember')]),
                value: z.string(),
              }),
              z.object({
                condition_type: z.literal('Date').optional(),
                extra: z.string().optional(),
                field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
                op: z.union([
                  z.literal('greater'),
                  z.literal('less'),
                  z.literal('is'),
                  z.literal('not'),
                  z.literal('blank'),
                  z.literal('blank_not'),
                  z.literal('within'),
                  z.literal('notwithin'),
                ]),
                value: z.string(),
              }),
              z.object({
                condition_type: z.literal('EmailClient').optional(),
                field: z.literal('email_client'),
                op: z.union([z.literal('client_is'), z.literal('client_not')]),
                value: z.string(),
              }),
              z.object({
                condition_type: z.literal('Language').optional(),
                field: z.literal('language'),
                op: z.union([z.literal('is'), z.literal('not')]),
                value: z.string(),
              }),
              z.object({
                condition_type: z.literal('MemberRating').optional(),
                field: z.literal('rating'),
                op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                value: z.number(),
              }),
              z.object({
                condition_type: z.literal('SignupSource'),
                field: z.literal('source'),
                op: z.union([z.literal('source_is'), z.literal('source_not')]),
                value: z.string().optional(),
              }),
              z.object({
                condition_type: z.literal('SurveyMonkey').optional(),
                field: z.literal('survey_monkey'),
                op: z.union([
                  z.literal('started'),
                  z.literal('completed'),
                  z.literal('not_started'),
                  z.literal('not_completed'),
                ]),
                value: z.string(),
              }),
              z.object({
                condition_type: z.literal('VIP').optional(),
                field: z.literal('gmonkey'),
                op: z.union([z.literal('member'), z.literal('notmember')]),
              }),
              z.object({
                condition_type: z.literal('Interests').optional(),
                field: z.string().optional(),
                op: z
                  .union([
                    z.literal('interestcontains'),
                    z.literal('interestcontainsall'),
                    z.literal('interestnotcontains'),
                  ])
                  .optional(),
                value: z.array(z.string()).optional(),
              }),
              z.object({
                condition_type: z.literal('EcommCategory').optional(),
                field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                op: z
                  .union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                  ])
                  .optional(),
                value: z.string().optional(),
              }),
              z.object({
                condition_type: z.literal('EcommNumber').optional(),
                field: z.union([
                  z.literal('ecomm_spent_avg'),
                  z.literal('ecomm_orders'),
                  z.literal('ecomm_prod_all'),
                  z.literal('ecomm_avg_ord'),
                ]),
                op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                value: z.number(),
              }),
              z.object({
                condition_type: z.literal('EcommPurchased').optional(),
                field: z.literal('ecomm_purchased').optional(),
                op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
              }),
              z.object({
                condition_type: z.literal('EcommSpent').optional(),
                field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                value: z.number().optional(),
              }),
              z.object({
                condition_type: z.literal('EcommStore').optional(),
                field: z.literal('ecomm_store').optional(),
                op: z.union([z.literal('is'), z.literal('not')]).optional(),
                value: z.string().optional(),
              }),
              z.object({
                condition_type: z.literal('GoalActivity').optional(),
                field: z.literal('goal'),
                op: z.union([
                  z.literal('is'),
                  z.literal('goal_not'),
                  z.literal('contains'),
                  z.literal('goal_notcontain'),
                  z.literal('starts'),
                  z.literal('ends'),
                ]),
                value: z.string(),
              }),
              z.object({
                condition_type: z.literal('GoalTimestamp').optional(),
                field: z.literal('goal_last_visited'),
                op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                value: z.string(),
              }),
              z.object({
                condition_type: z.literal('FuzzySegment').optional(),
                field: z.literal('fuzzy_segment'),
                op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                value: z.number(),
              }),
              z.object({
                condition_type: z.literal('StaticSegment').optional(),
                field: z.literal('static_segment'),
                op: z.union([z.literal('static_is'), z.literal('static_not')]),
                value: z.number(),
              }),
              z.object({
                condition_type: z.literal('IPGeoCountryState').optional(),
                field: z.literal('ipgeo'),
                op: z.union([
                  z.literal('ipgeocountry'),
                  z.literal('ipgeonotcountry'),
                  z.literal('ipgeostate'),
                  z.literal('ipgeonotstate'),
                ]),
                value: z.string(),
              }),
              z.object({
                addr: z.string(),
                condition_type: z.literal('IPGeoIn').optional(),
                field: z.literal('ipgeo'),
                lat: z.string(),
                lng: z.string(),
                op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                value: z.number(),
              }),
              z.object({
                condition_type: z.literal('IPGeoInZip').optional(),
                extra: z.number(),
                field: z.literal('ipgeo'),
                op: z.literal('ipgeoinzip'),
                value: z.number(),
              }),
              z.object({
                condition_type: z.literal('IPGeoUnknown').optional(),
                field: z.literal('ipgeo'),
                op: z.literal('ipgeounknown'),
              }),
              z.object({
                condition_type: z.literal('IPGeoZip').optional(),
                field: z.literal('ipgeo'),
                op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                value: z.number(),
              }),
              z.object({
                condition_type: z.literal('SocialAge').optional(),
                field: z.literal('social_age'),
                op: z.union([z.literal('is'), z.literal('not')]),
                value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
              }),
              z.object({
                condition_type: z.literal('SocialGender').optional(),
                field: z.literal('social_gender'),
                op: z.union([z.literal('is'), z.literal('not')]),
                value: z.union([z.literal('male'), z.literal('female')]),
              }),
              z.object({
                condition_type: z.literal('SocialInfluence').optional(),
                field: z.literal('social_influence'),
                op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                value: z.number(),
              }),
              z.object({
                condition_type: z.literal('SocialNetworkMember').optional(),
                field: z.literal('social_network'),
                op: z.union([z.literal('member'), z.literal('notmember')]),
                value: z.union([
                  z.literal('twitter'),
                  z.literal('facebook'),
                  z.literal('linkedin'),
                  z.literal('flickr'),
                  z.literal('foursquare'),
                  z.literal('lastfm'),
                  z.literal('myspace'),
                  z.literal('quora'),
                  z.literal('vimeo'),
                  z.literal('yelp'),
                  z.literal('youtube'),
                ]),
              }),
              z.object({
                condition_type: z.literal('SocialNetworkFollow').optional(),
                field: z.literal('social_network'),
                op: z.union([z.literal('follow'), z.literal('notfollow')]),
                value: z.literal('twitter_follow'),
              }),
              z.object({
                condition_type: z.literal('AddressMerge').optional(),
                field: z.string(),
                op: z.union([
                  z.literal('contains'),
                  z.literal('notcontain'),
                  z.literal('blank'),
                  z.literal('blank_not'),
                ]),
                value: z.string().optional(),
              }),
              z.object({
                condition_type: z.literal('ZipMerge').optional(),
                extra: z.string(),
                field: z.string(),
                op: z.literal('geoin'),
                value: z.string(),
              }),
              z.object({
                condition_type: z.literal('BirthdayMerge').optional(),
                field: z.string(),
                op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                value: z.string().optional(),
              }),
              z.object({
                condition_type: z.literal('DateMerge').optional(),
                field: z.string(),
                op: z.union([
                  z.literal('is'),
                  z.literal('not'),
                  z.literal('less'),
                  z.literal('blank'),
                  z.literal('blank_not'),
                  z.literal('greater'),
                ]),
                value: z.string().optional(),
              }),
              z.object({
                condition_type: z.literal('SelectMerge').optional(),
                field: z.string(),
                op: z.union([
                  z.literal('is'),
                  z.literal('not'),
                  z.literal('blank'),
                  z.literal('blank_not'),
                  z.literal('notcontain'),
                  z.literal('contains'),
                ]),
                value: z.string().optional(),
              }),
              z.object({
                condition_type: z.literal('TextMerge').optional(),
                field: z.string(),
                op: z.union([
                  z.literal('is'),
                  z.literal('not'),
                  z.literal('contains'),
                  z.literal('notcontain'),
                  z.literal('starts'),
                  z.literal('ends'),
                  z.literal('greater'),
                  z.literal('less'),
                  z.literal('blank'),
                  z.literal('blank_not'),
                ]),
                value: z.string().optional(),
              }),
              z.object({
                condition_type: z.literal('EmailAddress').optional(),
                field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                op: z.union([
                  z.literal('is'),
                  z.literal('not'),
                  z.literal('contains'),
                  z.literal('notcontain'),
                  z.literal('starts'),
                  z.literal('ends'),
                  z.literal('greater'),
                  z.literal('less'),
                ]),
                value: z.string().optional(),
              }),
              z.object({
                condition_type: z.literal('PredictedGender').optional(),
                field: z.literal('predicted_gender'),
                op: z.union([z.literal('is'), z.literal('not')]),
                value: z.union([z.literal('male'), z.literal('female')]),
              }),
              z.object({
                condition_type: z.literal('PredictedAge').optional(),
                field: z.literal('predicted_age_range'),
                op: z.literal('is'),
                value: z.union([
                  z.literal('18-24'),
                  z.literal('25-34'),
                  z.literal('35-44'),
                  z.literal('45-54'),
                  z.literal('55-64'),
                  z.literal('65+'),
                ]),
              }),
              z.object({
                condition_type: z.literal('NewSubscribers').optional(),
                field: z.literal('timestamp_opt').optional(),
                op: z.literal('date_within').optional(),
                value: z.string().optional(),
              }),
            ]),
          )
          .optional(),
        match: z.union([z.literal('any'), z.literal('all')]).optional(),
      })
      .optional(),
    static_segment: z.array(z.string()).optional(),
  }),
  path: z.object({
    list_id: z.string(),
  }),
});

export const postListsIdSegmentsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  created_at: z.string().optional(),
  id: z.number().optional(),
  list_id: z.string().optional(),
  member_count: z.number().optional(),
  name: z.string().optional(),
  options: z
    .object({
      conditions: z
        .array(
          z.union([
            z.object({
              condition_type: z.literal('Aim').optional(),
              field: z.literal('aim').optional(),
              op: z
                .union([
                  z.literal('open'),
                  z.literal('click'),
                  z.literal('sent'),
                  z.literal('noopen'),
                  z.literal('noclick'),
                  z.literal('nosent'),
                ])
                .optional(),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('Automation').optional(),
              field: z.literal('automation'),
              op: z.union([
                z.literal('started'),
                z.literal('completed'),
                z.literal('not_started'),
                z.literal('not_completed'),
              ]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('CampaignPoll').optional(),
              field: z.literal('poll'),
              op: z.union([z.literal('member'), z.literal('notmember')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('Conversation').optional(),
              field: z.literal('conversation'),
              op: z.union([z.literal('member'), z.literal('notmember')]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('Date').optional(),
              extra: z.string().optional(),
              field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
              op: z.union([
                z.literal('greater'),
                z.literal('less'),
                z.literal('is'),
                z.literal('not'),
                z.literal('blank'),
                z.literal('blank_not'),
                z.literal('within'),
                z.literal('notwithin'),
              ]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('EmailClient').optional(),
              field: z.literal('email_client'),
              op: z.union([z.literal('client_is'), z.literal('client_not')]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('Language').optional(),
              field: z.literal('language'),
              op: z.union([z.literal('is'), z.literal('not')]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('MemberRating').optional(),
              field: z.literal('rating'),
              op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('SignupSource'),
              field: z.literal('source'),
              op: z.union([z.literal('source_is'), z.literal('source_not')]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('SurveyMonkey').optional(),
              field: z.literal('survey_monkey'),
              op: z.union([
                z.literal('started'),
                z.literal('completed'),
                z.literal('not_started'),
                z.literal('not_completed'),
              ]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('VIP').optional(),
              field: z.literal('gmonkey'),
              op: z.union([z.literal('member'), z.literal('notmember')]),
            }),
            z.object({
              condition_type: z.literal('Interests').optional(),
              field: z.string().optional(),
              op: z
                .union([
                  z.literal('interestcontains'),
                  z.literal('interestcontainsall'),
                  z.literal('interestnotcontains'),
                ])
                .optional(),
              value: z.array(z.string()).optional(),
            }),
            z.object({
              condition_type: z.literal('EcommCategory').optional(),
              field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
              op: z
                .union([
                  z.literal('is'),
                  z.literal('not'),
                  z.literal('contains'),
                  z.literal('notcontain'),
                  z.literal('starts'),
                  z.literal('ends'),
                ])
                .optional(),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('EcommNumber').optional(),
              field: z.union([
                z.literal('ecomm_spent_avg'),
                z.literal('ecomm_orders'),
                z.literal('ecomm_prod_all'),
                z.literal('ecomm_avg_ord'),
              ]),
              op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('EcommPurchased').optional(),
              field: z.literal('ecomm_purchased').optional(),
              op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
            }),
            z.object({
              condition_type: z.literal('EcommSpent').optional(),
              field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
              op: z.union([z.literal('greater'), z.literal('less')]).optional(),
              value: z.number().optional(),
            }),
            z.object({
              condition_type: z.literal('EcommStore').optional(),
              field: z.literal('ecomm_store').optional(),
              op: z.union([z.literal('is'), z.literal('not')]).optional(),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('GoalActivity').optional(),
              field: z.literal('goal'),
              op: z.union([
                z.literal('is'),
                z.literal('goal_not'),
                z.literal('contains'),
                z.literal('goal_notcontain'),
                z.literal('starts'),
                z.literal('ends'),
              ]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('GoalTimestamp').optional(),
              field: z.literal('goal_last_visited'),
              op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('FuzzySegment').optional(),
              field: z.literal('fuzzy_segment'),
              op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('StaticSegment').optional(),
              field: z.literal('static_segment'),
              op: z.union([z.literal('static_is'), z.literal('static_not')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('IPGeoCountryState').optional(),
              field: z.literal('ipgeo'),
              op: z.union([
                z.literal('ipgeocountry'),
                z.literal('ipgeonotcountry'),
                z.literal('ipgeostate'),
                z.literal('ipgeonotstate'),
              ]),
              value: z.string(),
            }),
            z.object({
              addr: z.string(),
              condition_type: z.literal('IPGeoIn').optional(),
              field: z.literal('ipgeo'),
              lat: z.string(),
              lng: z.string(),
              op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('IPGeoInZip').optional(),
              extra: z.number(),
              field: z.literal('ipgeo'),
              op: z.literal('ipgeoinzip'),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('IPGeoUnknown').optional(),
              field: z.literal('ipgeo'),
              op: z.literal('ipgeounknown'),
            }),
            z.object({
              condition_type: z.literal('IPGeoZip').optional(),
              field: z.literal('ipgeo'),
              op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('SocialAge').optional(),
              field: z.literal('social_age'),
              op: z.union([z.literal('is'), z.literal('not')]),
              value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
            }),
            z.object({
              condition_type: z.literal('SocialGender').optional(),
              field: z.literal('social_gender'),
              op: z.union([z.literal('is'), z.literal('not')]),
              value: z.union([z.literal('male'), z.literal('female')]),
            }),
            z.object({
              condition_type: z.literal('SocialInfluence').optional(),
              field: z.literal('social_influence'),
              op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('SocialNetworkMember').optional(),
              field: z.literal('social_network'),
              op: z.union([z.literal('member'), z.literal('notmember')]),
              value: z.union([
                z.literal('twitter'),
                z.literal('facebook'),
                z.literal('linkedin'),
                z.literal('flickr'),
                z.literal('foursquare'),
                z.literal('lastfm'),
                z.literal('myspace'),
                z.literal('quora'),
                z.literal('vimeo'),
                z.literal('yelp'),
                z.literal('youtube'),
              ]),
            }),
            z.object({
              condition_type: z.literal('SocialNetworkFollow').optional(),
              field: z.literal('social_network'),
              op: z.union([z.literal('follow'), z.literal('notfollow')]),
              value: z.literal('twitter_follow'),
            }),
            z.object({
              condition_type: z.literal('AddressMerge').optional(),
              field: z.string(),
              op: z.union([z.literal('contains'), z.literal('notcontain'), z.literal('blank'), z.literal('blank_not')]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('ZipMerge').optional(),
              extra: z.string(),
              field: z.string(),
              op: z.literal('geoin'),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('BirthdayMerge').optional(),
              field: z.string(),
              op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('DateMerge').optional(),
              field: z.string(),
              op: z.union([
                z.literal('is'),
                z.literal('not'),
                z.literal('less'),
                z.literal('blank'),
                z.literal('blank_not'),
                z.literal('greater'),
              ]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('SelectMerge').optional(),
              field: z.string(),
              op: z.union([
                z.literal('is'),
                z.literal('not'),
                z.literal('blank'),
                z.literal('blank_not'),
                z.literal('notcontain'),
                z.literal('contains'),
              ]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('TextMerge').optional(),
              field: z.string(),
              op: z.union([
                z.literal('is'),
                z.literal('not'),
                z.literal('contains'),
                z.literal('notcontain'),
                z.literal('starts'),
                z.literal('ends'),
                z.literal('greater'),
                z.literal('less'),
                z.literal('blank'),
                z.literal('blank_not'),
              ]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('EmailAddress').optional(),
              field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
              op: z.union([
                z.literal('is'),
                z.literal('not'),
                z.literal('contains'),
                z.literal('notcontain'),
                z.literal('starts'),
                z.literal('ends'),
                z.literal('greater'),
                z.literal('less'),
              ]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('PredictedGender').optional(),
              field: z.literal('predicted_gender'),
              op: z.union([z.literal('is'), z.literal('not')]),
              value: z.union([z.literal('male'), z.literal('female')]),
            }),
            z.object({
              condition_type: z.literal('PredictedAge').optional(),
              field: z.literal('predicted_age_range'),
              op: z.literal('is'),
              value: z.union([
                z.literal('18-24'),
                z.literal('25-34'),
                z.literal('35-44'),
                z.literal('45-54'),
                z.literal('55-64'),
                z.literal('65+'),
              ]),
            }),
            z.object({
              condition_type: z.literal('NewSubscribers').optional(),
              field: z.literal('timestamp_opt').optional(),
              op: z.literal('date_within').optional(),
              value: z.string().optional(),
            }),
          ]),
        )
        .optional(),
      match: z.union([z.literal('any'), z.literal('all')]).optional(),
    })
    .optional(),
  type: z.union([z.literal('saved'), z.literal('static'), z.literal('fuzzy')]).optional(),
  updated_at: z.string().optional(),
});

export const postListsIdSegmentsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteListsIdSegmentsIdDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    segment_id: z.string(),
  }),
});

export const deleteListsIdSegmentsIdResponseSchema = z.any();

export const deleteListsIdSegmentsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdSegmentsIdDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    segment_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      include_cleaned: z.boolean().optional(),
      include_transactional: z.boolean().optional(),
      include_unsubscribed: z.boolean().optional(),
    })
    .optional(),
});

export const getListsIdSegmentsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  created_at: z.string().optional(),
  id: z.number().optional(),
  list_id: z.string().optional(),
  member_count: z.number().optional(),
  name: z.string().optional(),
  options: z
    .object({
      conditions: z
        .array(
          z.union([
            z.object({
              condition_type: z.literal('Aim').optional(),
              field: z.literal('aim').optional(),
              op: z
                .union([
                  z.literal('open'),
                  z.literal('click'),
                  z.literal('sent'),
                  z.literal('noopen'),
                  z.literal('noclick'),
                  z.literal('nosent'),
                ])
                .optional(),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('Automation').optional(),
              field: z.literal('automation'),
              op: z.union([
                z.literal('started'),
                z.literal('completed'),
                z.literal('not_started'),
                z.literal('not_completed'),
              ]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('CampaignPoll').optional(),
              field: z.literal('poll'),
              op: z.union([z.literal('member'), z.literal('notmember')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('Conversation').optional(),
              field: z.literal('conversation'),
              op: z.union([z.literal('member'), z.literal('notmember')]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('Date').optional(),
              extra: z.string().optional(),
              field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
              op: z.union([
                z.literal('greater'),
                z.literal('less'),
                z.literal('is'),
                z.literal('not'),
                z.literal('blank'),
                z.literal('blank_not'),
                z.literal('within'),
                z.literal('notwithin'),
              ]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('EmailClient').optional(),
              field: z.literal('email_client'),
              op: z.union([z.literal('client_is'), z.literal('client_not')]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('Language').optional(),
              field: z.literal('language'),
              op: z.union([z.literal('is'), z.literal('not')]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('MemberRating').optional(),
              field: z.literal('rating'),
              op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('SignupSource'),
              field: z.literal('source'),
              op: z.union([z.literal('source_is'), z.literal('source_not')]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('SurveyMonkey').optional(),
              field: z.literal('survey_monkey'),
              op: z.union([
                z.literal('started'),
                z.literal('completed'),
                z.literal('not_started'),
                z.literal('not_completed'),
              ]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('VIP').optional(),
              field: z.literal('gmonkey'),
              op: z.union([z.literal('member'), z.literal('notmember')]),
            }),
            z.object({
              condition_type: z.literal('Interests').optional(),
              field: z.string().optional(),
              op: z
                .union([
                  z.literal('interestcontains'),
                  z.literal('interestcontainsall'),
                  z.literal('interestnotcontains'),
                ])
                .optional(),
              value: z.array(z.string()).optional(),
            }),
            z.object({
              condition_type: z.literal('EcommCategory').optional(),
              field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
              op: z
                .union([
                  z.literal('is'),
                  z.literal('not'),
                  z.literal('contains'),
                  z.literal('notcontain'),
                  z.literal('starts'),
                  z.literal('ends'),
                ])
                .optional(),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('EcommNumber').optional(),
              field: z.union([
                z.literal('ecomm_spent_avg'),
                z.literal('ecomm_orders'),
                z.literal('ecomm_prod_all'),
                z.literal('ecomm_avg_ord'),
              ]),
              op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('EcommPurchased').optional(),
              field: z.literal('ecomm_purchased').optional(),
              op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
            }),
            z.object({
              condition_type: z.literal('EcommSpent').optional(),
              field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
              op: z.union([z.literal('greater'), z.literal('less')]).optional(),
              value: z.number().optional(),
            }),
            z.object({
              condition_type: z.literal('EcommStore').optional(),
              field: z.literal('ecomm_store').optional(),
              op: z.union([z.literal('is'), z.literal('not')]).optional(),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('GoalActivity').optional(),
              field: z.literal('goal'),
              op: z.union([
                z.literal('is'),
                z.literal('goal_not'),
                z.literal('contains'),
                z.literal('goal_notcontain'),
                z.literal('starts'),
                z.literal('ends'),
              ]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('GoalTimestamp').optional(),
              field: z.literal('goal_last_visited'),
              op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('FuzzySegment').optional(),
              field: z.literal('fuzzy_segment'),
              op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('StaticSegment').optional(),
              field: z.literal('static_segment'),
              op: z.union([z.literal('static_is'), z.literal('static_not')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('IPGeoCountryState').optional(),
              field: z.literal('ipgeo'),
              op: z.union([
                z.literal('ipgeocountry'),
                z.literal('ipgeonotcountry'),
                z.literal('ipgeostate'),
                z.literal('ipgeonotstate'),
              ]),
              value: z.string(),
            }),
            z.object({
              addr: z.string(),
              condition_type: z.literal('IPGeoIn').optional(),
              field: z.literal('ipgeo'),
              lat: z.string(),
              lng: z.string(),
              op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('IPGeoInZip').optional(),
              extra: z.number(),
              field: z.literal('ipgeo'),
              op: z.literal('ipgeoinzip'),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('IPGeoUnknown').optional(),
              field: z.literal('ipgeo'),
              op: z.literal('ipgeounknown'),
            }),
            z.object({
              condition_type: z.literal('IPGeoZip').optional(),
              field: z.literal('ipgeo'),
              op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('SocialAge').optional(),
              field: z.literal('social_age'),
              op: z.union([z.literal('is'), z.literal('not')]),
              value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
            }),
            z.object({
              condition_type: z.literal('SocialGender').optional(),
              field: z.literal('social_gender'),
              op: z.union([z.literal('is'), z.literal('not')]),
              value: z.union([z.literal('male'), z.literal('female')]),
            }),
            z.object({
              condition_type: z.literal('SocialInfluence').optional(),
              field: z.literal('social_influence'),
              op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('SocialNetworkMember').optional(),
              field: z.literal('social_network'),
              op: z.union([z.literal('member'), z.literal('notmember')]),
              value: z.union([
                z.literal('twitter'),
                z.literal('facebook'),
                z.literal('linkedin'),
                z.literal('flickr'),
                z.literal('foursquare'),
                z.literal('lastfm'),
                z.literal('myspace'),
                z.literal('quora'),
                z.literal('vimeo'),
                z.literal('yelp'),
                z.literal('youtube'),
              ]),
            }),
            z.object({
              condition_type: z.literal('SocialNetworkFollow').optional(),
              field: z.literal('social_network'),
              op: z.union([z.literal('follow'), z.literal('notfollow')]),
              value: z.literal('twitter_follow'),
            }),
            z.object({
              condition_type: z.literal('AddressMerge').optional(),
              field: z.string(),
              op: z.union([z.literal('contains'), z.literal('notcontain'), z.literal('blank'), z.literal('blank_not')]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('ZipMerge').optional(),
              extra: z.string(),
              field: z.string(),
              op: z.literal('geoin'),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('BirthdayMerge').optional(),
              field: z.string(),
              op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('DateMerge').optional(),
              field: z.string(),
              op: z.union([
                z.literal('is'),
                z.literal('not'),
                z.literal('less'),
                z.literal('blank'),
                z.literal('blank_not'),
                z.literal('greater'),
              ]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('SelectMerge').optional(),
              field: z.string(),
              op: z.union([
                z.literal('is'),
                z.literal('not'),
                z.literal('blank'),
                z.literal('blank_not'),
                z.literal('notcontain'),
                z.literal('contains'),
              ]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('TextMerge').optional(),
              field: z.string(),
              op: z.union([
                z.literal('is'),
                z.literal('not'),
                z.literal('contains'),
                z.literal('notcontain'),
                z.literal('starts'),
                z.literal('ends'),
                z.literal('greater'),
                z.literal('less'),
                z.literal('blank'),
                z.literal('blank_not'),
              ]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('EmailAddress').optional(),
              field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
              op: z.union([
                z.literal('is'),
                z.literal('not'),
                z.literal('contains'),
                z.literal('notcontain'),
                z.literal('starts'),
                z.literal('ends'),
                z.literal('greater'),
                z.literal('less'),
              ]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('PredictedGender').optional(),
              field: z.literal('predicted_gender'),
              op: z.union([z.literal('is'), z.literal('not')]),
              value: z.union([z.literal('male'), z.literal('female')]),
            }),
            z.object({
              condition_type: z.literal('PredictedAge').optional(),
              field: z.literal('predicted_age_range'),
              op: z.literal('is'),
              value: z.union([
                z.literal('18-24'),
                z.literal('25-34'),
                z.literal('35-44'),
                z.literal('45-54'),
                z.literal('55-64'),
                z.literal('65+'),
              ]),
            }),
            z.object({
              condition_type: z.literal('NewSubscribers').optional(),
              field: z.literal('timestamp_opt').optional(),
              op: z.literal('date_within').optional(),
              value: z.string().optional(),
            }),
          ]),
        )
        .optional(),
      match: z.union([z.literal('any'), z.literal('all')]).optional(),
    })
    .optional(),
  type: z.union([z.literal('saved'), z.literal('static'), z.literal('fuzzy')]).optional(),
  updated_at: z.string().optional(),
});

export const getListsIdSegmentsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchListsIdSegmentsIdDataSchema = z.object({
  body: z.object({
    name: z.string(),
    options: z
      .object({
        conditions: z
          .array(
            z.array(
              z.union([
                z.object({
                  condition_type: z.literal('Aim').optional(),
                  field: z.literal('aim').optional(),
                  op: z
                    .union([
                      z.literal('open'),
                      z.literal('click'),
                      z.literal('sent'),
                      z.literal('noopen'),
                      z.literal('noclick'),
                      z.literal('nosent'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('Automation').optional(),
                  field: z.literal('automation'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('CampaignPoll').optional(),
                  field: z.literal('poll'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('Conversation').optional(),
                  field: z.literal('conversation'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Date').optional(),
                  extra: z.string().optional(),
                  field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
                  op: z.union([
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('within'),
                    z.literal('notwithin'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('EmailClient').optional(),
                  field: z.literal('email_client'),
                  op: z.union([z.literal('client_is'), z.literal('client_not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Language').optional(),
                  field: z.literal('language'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('MemberRating').optional(),
                  field: z.literal('rating'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SignupSource'),
                  field: z.literal('source'),
                  op: z.union([z.literal('source_is'), z.literal('source_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SurveyMonkey').optional(),
                  field: z.literal('survey_monkey'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('VIP').optional(),
                  field: z.literal('gmonkey'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                }),
                z.object({
                  condition_type: z.literal('Interests').optional(),
                  field: z.string().optional(),
                  op: z
                    .union([
                      z.literal('interestcontains'),
                      z.literal('interestcontainsall'),
                      z.literal('interestnotcontains'),
                    ])
                    .optional(),
                  value: z.array(z.string()).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommCategory').optional(),
                  field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                  op: z
                    .union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommNumber').optional(),
                  field: z.union([
                    z.literal('ecomm_spent_avg'),
                    z.literal('ecomm_orders'),
                    z.literal('ecomm_prod_all'),
                    z.literal('ecomm_avg_ord'),
                  ]),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('EcommPurchased').optional(),
                  field: z.literal('ecomm_purchased').optional(),
                  op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommSpent').optional(),
                  field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                  op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                  value: z.number().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommStore').optional(),
                  field: z.literal('ecomm_store').optional(),
                  op: z.union([z.literal('is'), z.literal('not')]).optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('GoalActivity').optional(),
                  field: z.literal('goal'),
                  op: z.union([
                    z.literal('is'),
                    z.literal('goal_not'),
                    z.literal('contains'),
                    z.literal('goal_notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('GoalTimestamp').optional(),
                  field: z.literal('goal_last_visited'),
                  op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('FuzzySegment').optional(),
                  field: z.literal('fuzzy_segment'),
                  op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('StaticSegment').optional(),
                  field: z.literal('static_segment'),
                  op: z.union([z.literal('static_is'), z.literal('static_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoCountryState').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([
                    z.literal('ipgeocountry'),
                    z.literal('ipgeonotcountry'),
                    z.literal('ipgeostate'),
                    z.literal('ipgeonotstate'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  addr: z.string(),
                  condition_type: z.literal('IPGeoIn').optional(),
                  field: z.literal('ipgeo'),
                  lat: z.string(),
                  lng: z.string(),
                  op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoInZip').optional(),
                  extra: z.number(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeoinzip'),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoUnknown').optional(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeounknown'),
                }),
                z.object({
                  condition_type: z.literal('IPGeoZip').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialAge').optional(),
                  field: z.literal('social_age'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                }),
                z.object({
                  condition_type: z.literal('SocialGender').optional(),
                  field: z.literal('social_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('SocialInfluence').optional(),
                  field: z.literal('social_influence'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkMember').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.union([
                    z.literal('twitter'),
                    z.literal('facebook'),
                    z.literal('linkedin'),
                    z.literal('flickr'),
                    z.literal('foursquare'),
                    z.literal('lastfm'),
                    z.literal('myspace'),
                    z.literal('quora'),
                    z.literal('vimeo'),
                    z.literal('yelp'),
                    z.literal('youtube'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkFollow').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('follow'), z.literal('notfollow')]),
                  value: z.literal('twitter_follow'),
                }),
                z.object({
                  condition_type: z.literal('AddressMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('ZipMerge').optional(),
                  extra: z.string(),
                  field: z.string(),
                  op: z.literal('geoin'),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('BirthdayMerge').optional(),
                  field: z.string(),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('DateMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('greater'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SelectMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('notcontain'),
                    z.literal('contains'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('TextMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EmailAddress').optional(),
                  field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('PredictedGender').optional(),
                  field: z.literal('predicted_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('PredictedAge').optional(),
                  field: z.literal('predicted_age_range'),
                  op: z.literal('is'),
                  value: z.union([
                    z.literal('18-24'),
                    z.literal('25-34'),
                    z.literal('35-44'),
                    z.literal('45-54'),
                    z.literal('55-64'),
                    z.literal('65+'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('NewSubscribers').optional(),
                  field: z.literal('timestamp_opt').optional(),
                  op: z.literal('date_within').optional(),
                  value: z.string().optional(),
                }),
              ]),
            ),
          )
          .optional(),
        match: z.union([z.literal('any'), z.literal('all')]).optional(),
      })
      .optional(),
    static_segment: z.array(z.string()).optional(),
  }),
  path: z.object({
    list_id: z.string(),
    segment_id: z.string(),
  }),
});

export const patchListsIdSegmentsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  created_at: z.string().optional(),
  id: z.number().optional(),
  list_id: z.string().optional(),
  member_count: z.number().optional(),
  name: z.string().optional(),
  options: z
    .object({
      conditions: z
        .array(
          z.union([
            z.object({
              condition_type: z.literal('Aim').optional(),
              field: z.literal('aim').optional(),
              op: z
                .union([
                  z.literal('open'),
                  z.literal('click'),
                  z.literal('sent'),
                  z.literal('noopen'),
                  z.literal('noclick'),
                  z.literal('nosent'),
                ])
                .optional(),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('Automation').optional(),
              field: z.literal('automation'),
              op: z.union([
                z.literal('started'),
                z.literal('completed'),
                z.literal('not_started'),
                z.literal('not_completed'),
              ]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('CampaignPoll').optional(),
              field: z.literal('poll'),
              op: z.union([z.literal('member'), z.literal('notmember')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('Conversation').optional(),
              field: z.literal('conversation'),
              op: z.union([z.literal('member'), z.literal('notmember')]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('Date').optional(),
              extra: z.string().optional(),
              field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
              op: z.union([
                z.literal('greater'),
                z.literal('less'),
                z.literal('is'),
                z.literal('not'),
                z.literal('blank'),
                z.literal('blank_not'),
                z.literal('within'),
                z.literal('notwithin'),
              ]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('EmailClient').optional(),
              field: z.literal('email_client'),
              op: z.union([z.literal('client_is'), z.literal('client_not')]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('Language').optional(),
              field: z.literal('language'),
              op: z.union([z.literal('is'), z.literal('not')]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('MemberRating').optional(),
              field: z.literal('rating'),
              op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('SignupSource'),
              field: z.literal('source'),
              op: z.union([z.literal('source_is'), z.literal('source_not')]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('SurveyMonkey').optional(),
              field: z.literal('survey_monkey'),
              op: z.union([
                z.literal('started'),
                z.literal('completed'),
                z.literal('not_started'),
                z.literal('not_completed'),
              ]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('VIP').optional(),
              field: z.literal('gmonkey'),
              op: z.union([z.literal('member'), z.literal('notmember')]),
            }),
            z.object({
              condition_type: z.literal('Interests').optional(),
              field: z.string().optional(),
              op: z
                .union([
                  z.literal('interestcontains'),
                  z.literal('interestcontainsall'),
                  z.literal('interestnotcontains'),
                ])
                .optional(),
              value: z.array(z.string()).optional(),
            }),
            z.object({
              condition_type: z.literal('EcommCategory').optional(),
              field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
              op: z
                .union([
                  z.literal('is'),
                  z.literal('not'),
                  z.literal('contains'),
                  z.literal('notcontain'),
                  z.literal('starts'),
                  z.literal('ends'),
                ])
                .optional(),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('EcommNumber').optional(),
              field: z.union([
                z.literal('ecomm_spent_avg'),
                z.literal('ecomm_orders'),
                z.literal('ecomm_prod_all'),
                z.literal('ecomm_avg_ord'),
              ]),
              op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('EcommPurchased').optional(),
              field: z.literal('ecomm_purchased').optional(),
              op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
            }),
            z.object({
              condition_type: z.literal('EcommSpent').optional(),
              field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
              op: z.union([z.literal('greater'), z.literal('less')]).optional(),
              value: z.number().optional(),
            }),
            z.object({
              condition_type: z.literal('EcommStore').optional(),
              field: z.literal('ecomm_store').optional(),
              op: z.union([z.literal('is'), z.literal('not')]).optional(),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('GoalActivity').optional(),
              field: z.literal('goal'),
              op: z.union([
                z.literal('is'),
                z.literal('goal_not'),
                z.literal('contains'),
                z.literal('goal_notcontain'),
                z.literal('starts'),
                z.literal('ends'),
              ]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('GoalTimestamp').optional(),
              field: z.literal('goal_last_visited'),
              op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('FuzzySegment').optional(),
              field: z.literal('fuzzy_segment'),
              op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('StaticSegment').optional(),
              field: z.literal('static_segment'),
              op: z.union([z.literal('static_is'), z.literal('static_not')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('IPGeoCountryState').optional(),
              field: z.literal('ipgeo'),
              op: z.union([
                z.literal('ipgeocountry'),
                z.literal('ipgeonotcountry'),
                z.literal('ipgeostate'),
                z.literal('ipgeonotstate'),
              ]),
              value: z.string(),
            }),
            z.object({
              addr: z.string(),
              condition_type: z.literal('IPGeoIn').optional(),
              field: z.literal('ipgeo'),
              lat: z.string(),
              lng: z.string(),
              op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('IPGeoInZip').optional(),
              extra: z.number(),
              field: z.literal('ipgeo'),
              op: z.literal('ipgeoinzip'),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('IPGeoUnknown').optional(),
              field: z.literal('ipgeo'),
              op: z.literal('ipgeounknown'),
            }),
            z.object({
              condition_type: z.literal('IPGeoZip').optional(),
              field: z.literal('ipgeo'),
              op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('SocialAge').optional(),
              field: z.literal('social_age'),
              op: z.union([z.literal('is'), z.literal('not')]),
              value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
            }),
            z.object({
              condition_type: z.literal('SocialGender').optional(),
              field: z.literal('social_gender'),
              op: z.union([z.literal('is'), z.literal('not')]),
              value: z.union([z.literal('male'), z.literal('female')]),
            }),
            z.object({
              condition_type: z.literal('SocialInfluence').optional(),
              field: z.literal('social_influence'),
              op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
              value: z.number(),
            }),
            z.object({
              condition_type: z.literal('SocialNetworkMember').optional(),
              field: z.literal('social_network'),
              op: z.union([z.literal('member'), z.literal('notmember')]),
              value: z.union([
                z.literal('twitter'),
                z.literal('facebook'),
                z.literal('linkedin'),
                z.literal('flickr'),
                z.literal('foursquare'),
                z.literal('lastfm'),
                z.literal('myspace'),
                z.literal('quora'),
                z.literal('vimeo'),
                z.literal('yelp'),
                z.literal('youtube'),
              ]),
            }),
            z.object({
              condition_type: z.literal('SocialNetworkFollow').optional(),
              field: z.literal('social_network'),
              op: z.union([z.literal('follow'), z.literal('notfollow')]),
              value: z.literal('twitter_follow'),
            }),
            z.object({
              condition_type: z.literal('AddressMerge').optional(),
              field: z.string(),
              op: z.union([z.literal('contains'), z.literal('notcontain'), z.literal('blank'), z.literal('blank_not')]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('ZipMerge').optional(),
              extra: z.string(),
              field: z.string(),
              op: z.literal('geoin'),
              value: z.string(),
            }),
            z.object({
              condition_type: z.literal('BirthdayMerge').optional(),
              field: z.string(),
              op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('DateMerge').optional(),
              field: z.string(),
              op: z.union([
                z.literal('is'),
                z.literal('not'),
                z.literal('less'),
                z.literal('blank'),
                z.literal('blank_not'),
                z.literal('greater'),
              ]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('SelectMerge').optional(),
              field: z.string(),
              op: z.union([
                z.literal('is'),
                z.literal('not'),
                z.literal('blank'),
                z.literal('blank_not'),
                z.literal('notcontain'),
                z.literal('contains'),
              ]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('TextMerge').optional(),
              field: z.string(),
              op: z.union([
                z.literal('is'),
                z.literal('not'),
                z.literal('contains'),
                z.literal('notcontain'),
                z.literal('starts'),
                z.literal('ends'),
                z.literal('greater'),
                z.literal('less'),
                z.literal('blank'),
                z.literal('blank_not'),
              ]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('EmailAddress').optional(),
              field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
              op: z.union([
                z.literal('is'),
                z.literal('not'),
                z.literal('contains'),
                z.literal('notcontain'),
                z.literal('starts'),
                z.literal('ends'),
                z.literal('greater'),
                z.literal('less'),
              ]),
              value: z.string().optional(),
            }),
            z.object({
              condition_type: z.literal('PredictedGender').optional(),
              field: z.literal('predicted_gender'),
              op: z.union([z.literal('is'), z.literal('not')]),
              value: z.union([z.literal('male'), z.literal('female')]),
            }),
            z.object({
              condition_type: z.literal('PredictedAge').optional(),
              field: z.literal('predicted_age_range'),
              op: z.literal('is'),
              value: z.union([
                z.literal('18-24'),
                z.literal('25-34'),
                z.literal('35-44'),
                z.literal('45-54'),
                z.literal('55-64'),
                z.literal('65+'),
              ]),
            }),
            z.object({
              condition_type: z.literal('NewSubscribers').optional(),
              field: z.literal('timestamp_opt').optional(),
              op: z.literal('date_within').optional(),
              value: z.string().optional(),
            }),
          ]),
        )
        .optional(),
      match: z.union([z.literal('any'), z.literal('all')]).optional(),
    })
    .optional(),
  type: z.union([z.literal('saved'), z.literal('static'), z.literal('fuzzy')]).optional(),
  updated_at: z.string().optional(),
});

export const patchListsIdSegmentsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postListsIdSegmentsIdDataSchema = z.object({
  body: z.object({
    members_to_add: z.array(z.string()).optional(),
    members_to_remove: z.array(z.string()).optional(),
  }),
  path: z.object({
    list_id: z.string(),
    segment_id: z.string(),
  }),
});

export const postListsIdSegmentsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  error_count: z.number().optional(),
  errors: z
    .array(
      z.object({
        email_addresses: z.array(z.string()).optional(),
        error: z.string().optional(),
      }),
    )
    .optional(),
  members_added: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        email_address: z.string().optional(),
        email_client: z.string().optional(),
        email_type: z.string().optional(),
        id: z.string().optional(),
        interests: z.record(z.boolean()).optional(),
        ip_opt: z.string().optional(),
        ip_signup: z.string().optional(),
        language: z.string().optional(),
        last_changed: z.string().optional(),
        last_note: z
          .object({
            created_at: z.string().optional(),
            created_by: z.string().optional(),
            note: z.string().optional(),
            note_id: z.number().optional(),
          })
          .optional(),
        list_id: z.string().optional(),
        location: z
          .object({
            country_code: z.string().optional(),
            dstoff: z.number().optional(),
            gmtoff: z.number().optional(),
            latitude: z.number().optional(),
            longitude: z.number().optional(),
            timezone: z.string().optional(),
          })
          .optional(),
        member_rating: z.number().optional(),
        merge_fields: z.record(z.unknown()).optional(),
        stats: z
          .object({
            avg_click_rate: z.number().optional(),
            avg_open_rate: z.number().optional(),
          })
          .optional(),
        status: z
          .union([
            z.literal('subscribed'),
            z.literal('unsubscribed'),
            z.literal('cleaned'),
            z.literal('pending'),
            z.literal('transactional'),
          ])
          .optional(),
        tags: z
          .array(
            z.object({
              id: z.number().optional(),
              name: z.string().optional(),
            }),
          )
          .optional(),
        tags_count: z.number().optional(),
        timestamp_opt: z.string().optional(),
        timestamp_signup: z.string().optional(),
        unique_email_id: z.string().optional(),
        vip: z.boolean().optional(),
      }),
    )
    .optional(),
  members_removed: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        email_address: z.string().optional(),
        email_client: z.string().optional(),
        email_type: z.string().optional(),
        id: z.string().optional(),
        interests: z.record(z.boolean()).optional(),
        ip_opt: z.string().optional(),
        ip_signup: z.string().optional(),
        language: z.string().optional(),
        last_changed: z.string().optional(),
        last_note: z
          .object({
            created_at: z.string().optional(),
            created_by: z.string().optional(),
            note: z.string().optional(),
            note_id: z.number().optional(),
          })
          .optional(),
        list_id: z.string().optional(),
        location: z
          .object({
            country_code: z.string().optional(),
            dstoff: z.number().optional(),
            gmtoff: z.number().optional(),
            latitude: z.number().optional(),
            longitude: z.number().optional(),
            timezone: z.string().optional(),
          })
          .optional(),
        member_rating: z.number().optional(),
        merge_fields: z.record(z.unknown()).optional(),
        stats: z
          .object({
            avg_click_rate: z.number().optional(),
            avg_open_rate: z.number().optional(),
          })
          .optional(),
        status: z
          .union([
            z.literal('subscribed'),
            z.literal('unsubscribed'),
            z.literal('cleaned'),
            z.literal('pending'),
            z.literal('transactional'),
          ])
          .optional(),
        tags: z
          .array(
            z.object({
              id: z.number().optional(),
              name: z.string().optional(),
            }),
          )
          .optional(),
        tags_count: z.number().optional(),
        timestamp_opt: z.string().optional(),
        timestamp_signup: z.string().optional(),
        unique_email_id: z.string().optional(),
        vip: z.boolean().optional(),
      }),
    )
    .optional(),
  total_added: z.number().optional(),
  total_removed: z.number().optional(),
});

export const postListsIdSegmentsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdSegmentsIdMembersDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    segment_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      include_cleaned: z.boolean().optional(),
      include_transactional: z.boolean().optional(),
      include_unsubscribed: z.boolean().optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getListsIdSegmentsIdMembersResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  members: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        email_address: z.string().optional(),
        email_client: z.string().optional(),
        email_type: z.string().optional(),
        id: z.string().optional(),
        interests: z.record(z.boolean()).optional(),
        ip_opt: z.string().optional(),
        ip_signup: z.string().optional(),
        language: z.string().optional(),
        last_changed: z.string().optional(),
        last_note: z
          .object({
            created_at: z.string().optional(),
            created_by: z.string().optional(),
            note: z.string().optional(),
            note_id: z.number().optional(),
          })
          .optional(),
        list_id: z.string().optional(),
        location: z
          .object({
            country_code: z.string().optional(),
            dstoff: z.number().optional(),
            gmtoff: z.number().optional(),
            latitude: z.number().optional(),
            longitude: z.number().optional(),
            timezone: z.string().optional(),
          })
          .optional(),
        member_rating: z.number().optional(),
        merge_fields: z.record(z.unknown()).optional(),
        stats: z
          .object({
            avg_click_rate: z.number().optional(),
            avg_open_rate: z.number().optional(),
          })
          .optional(),
        status: z
          .union([
            z.literal('subscribed'),
            z.literal('unsubscribed'),
            z.literal('cleaned'),
            z.literal('pending'),
            z.literal('transactional'),
          ])
          .optional(),
        timestamp_opt: z.string().optional(),
        timestamp_signup: z.string().optional(),
        unique_email_id: z.string().optional(),
        vip: z.boolean().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getListsIdSegmentsIdMembersErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postListsIdSegmentsIdMembersDataSchema = z.object({
  body: z.object({
    email_address: z.string(),
  }),
  path: z.object({
    list_id: z.string(),
    segment_id: z.string(),
  }),
});

export const postListsIdSegmentsIdMembersResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  email_address: z.string().optional(),
  email_client: z.string().optional(),
  email_type: z.string().optional(),
  id: z.string().optional(),
  interests: z.record(z.boolean()).optional(),
  ip_opt: z.string().optional(),
  ip_signup: z.string().optional(),
  language: z.string().optional(),
  last_changed: z.string().optional(),
  last_note: z
    .object({
      created_at: z.string().optional(),
      created_by: z.string().optional(),
      note: z.string().optional(),
      note_id: z.number().optional(),
    })
    .optional(),
  list_id: z.string().optional(),
  location: z
    .object({
      country_code: z.string().optional(),
      dstoff: z.number().optional(),
      gmtoff: z.number().optional(),
      latitude: z.number().optional(),
      longitude: z.number().optional(),
      timezone: z.string().optional(),
    })
    .optional(),
  member_rating: z.number().optional(),
  merge_fields: z.record(z.unknown()).optional(),
  stats: z
    .object({
      avg_click_rate: z.number().optional(),
      avg_open_rate: z.number().optional(),
    })
    .optional(),
  status: z
    .union([
      z.literal('subscribed'),
      z.literal('unsubscribed'),
      z.literal('cleaned'),
      z.literal('pending'),
      z.literal('transactional'),
    ])
    .optional(),
  timestamp_opt: z.string().optional(),
  timestamp_signup: z.string().optional(),
  unique_email_id: z.string().optional(),
  vip: z.boolean().optional(),
});

export const postListsIdSegmentsIdMembersErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteListsIdSegmentsIdMembersIdDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    segment_id: z.string(),
    subscriber_hash: z.string(),
  }),
});

export const deleteListsIdSegmentsIdMembersIdResponseSchema = z.any();

export const deleteListsIdSegmentsIdMembersIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdSignupFormsDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
  }),
});

export const getListsIdSignupFormsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  list_id: z.string().optional(),
  signup_forms: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        contents: z
          .array(
            z.object({
              section: z
                .union([z.literal('signup_message'), z.literal('unsub_message'), z.literal('signup_thank_you_title')])
                .optional(),
              value: z.string().optional(),
            }),
          )
          .optional(),
        header: z
          .object({
            image_align: z
              .union([z.literal('none'), z.literal('left'), z.literal('center'), z.literal('right')])
              .optional(),
            image_alt: z.string().optional(),
            image_border_color: z.string().optional(),
            image_border_style: z
              .union([
                z.literal('none'),
                z.literal('solid'),
                z.literal('dotted'),
                z.literal('dashed'),
                z.literal('double'),
                z.literal('groove'),
                z.literal('outset'),
                z.literal('inset'),
                z.literal('ridge'),
              ])
              .optional(),
            image_border_width: z.string().optional(),
            image_height: z.string().optional(),
            image_link: z.string().optional(),
            image_target: z.union([z.literal('_blank'), z.literal('null')]).optional(),
            image_url: z.string().optional(),
            image_width: z.string().optional(),
            text: z.string().optional(),
          })
          .optional(),
        list_id: z.string().optional(),
        signup_form_url: z.string().optional(),
        styles: z
          .array(
            z.object({
              options: z
                .array(
                  z.object({
                    property: z.string().optional(),
                    value: z.string().optional(),
                  }),
                )
                .optional(),
              selector: z
                .union([
                  z.literal('page_background'),
                  z.literal('page_header'),
                  z.literal('page_outer_wrapper'),
                  z.literal('body_background'),
                  z.literal('body_link_style'),
                  z.literal('forms_buttons'),
                  z.literal('forms_buttons_hovered'),
                  z.literal('forms_field_label'),
                  z.literal('forms_field_text'),
                  z.literal('forms_required'),
                  z.literal('forms_required_legend'),
                  z.literal('forms_help_text'),
                  z.literal('forms_errors'),
                  z.literal('monkey_rewards_badge'),
                ])
                .optional(),
            }),
          )
          .optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getListsIdSignupFormsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postListsIdSignupFormsDataSchema = z.object({
  body: z.object({
    contents: z
      .array(
        z.object({
          section: z
            .union([z.literal('signup_message'), z.literal('unsub_message'), z.literal('signup_thank_you_title')])
            .optional(),
          value: z.string().optional(),
        }),
      )
      .optional(),
    header: z
      .object({
        image_align: z
          .union([z.literal('none'), z.literal('left'), z.literal('center'), z.literal('right')])
          .optional(),
        image_alt: z.string().optional(),
        image_border_color: z.string().optional(),
        image_border_style: z
          .union([
            z.literal('none'),
            z.literal('solid'),
            z.literal('dotted'),
            z.literal('dashed'),
            z.literal('double'),
            z.literal('groove'),
            z.literal('outset'),
            z.literal('inset'),
            z.literal('ridge'),
          ])
          .optional(),
        image_border_width: z.string().optional(),
        image_height: z.string().optional(),
        image_link: z.string().optional(),
        image_target: z.union([z.literal('_blank'), z.literal('null')]).optional(),
        image_url: z.string().optional(),
        image_width: z.string().optional(),
        text: z.string().optional(),
      })
      .optional(),
    styles: z
      .array(
        z.object({
          options: z
            .array(
              z.object({
                property: z.string().optional(),
                value: z.string().optional(),
              }),
            )
            .optional(),
          selector: z
            .union([
              z.literal('page_background'),
              z.literal('page_header'),
              z.literal('page_outer_wrapper'),
              z.literal('body_background'),
              z.literal('body_link_style'),
              z.literal('forms_buttons'),
              z.literal('forms_buttons_hovered'),
              z.literal('forms_field_label'),
              z.literal('forms_field_text'),
              z.literal('forms_required'),
              z.literal('forms_required_legend'),
              z.literal('forms_help_text'),
              z.literal('forms_errors'),
              z.literal('monkey_rewards_badge'),
            ])
            .optional(),
        }),
      )
      .optional(),
  }),
  path: z.object({
    list_id: z.string(),
  }),
});

export const postListsIdSignupFormsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  contents: z
    .array(
      z.object({
        section: z
          .union([z.literal('signup_message'), z.literal('unsub_message'), z.literal('signup_thank_you_title')])
          .optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  header: z
    .object({
      image_align: z.union([z.literal('none'), z.literal('left'), z.literal('center'), z.literal('right')]).optional(),
      image_alt: z.string().optional(),
      image_border_color: z.string().optional(),
      image_border_style: z
        .union([
          z.literal('none'),
          z.literal('solid'),
          z.literal('dotted'),
          z.literal('dashed'),
          z.literal('double'),
          z.literal('groove'),
          z.literal('outset'),
          z.literal('inset'),
          z.literal('ridge'),
        ])
        .optional(),
      image_border_width: z.string().optional(),
      image_height: z.string().optional(),
      image_link: z.string().optional(),
      image_target: z.union([z.literal('_blank'), z.literal('null')]).optional(),
      image_url: z.string().optional(),
      image_width: z.string().optional(),
      text: z.string().optional(),
    })
    .optional(),
  list_id: z.string().optional(),
  signup_form_url: z.string().optional(),
  styles: z
    .array(
      z.object({
        options: z
          .array(
            z.object({
              property: z.string().optional(),
              value: z.string().optional(),
            }),
          )
          .optional(),
        selector: z
          .union([
            z.literal('page_background'),
            z.literal('page_header'),
            z.literal('page_outer_wrapper'),
            z.literal('body_background'),
            z.literal('body_link_style'),
            z.literal('forms_buttons'),
            z.literal('forms_buttons_hovered'),
            z.literal('forms_field_label'),
            z.literal('forms_field_text'),
            z.literal('forms_required'),
            z.literal('forms_required_legend'),
            z.literal('forms_help_text'),
            z.literal('forms_errors'),
            z.literal('monkey_rewards_badge'),
          ])
          .optional(),
      }),
    )
    .optional(),
});

export const postListsIdSignupFormsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdSurveysDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
  }),
});

export const getListsIdSurveysResponseSchema = z.unknown();

export const getListsIdSurveysErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdSurveysIdDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    survey_id: z.string(),
  }),
});

export const getListsIdSurveysIdResponseSchema = z.unknown();

export const getListsIdSurveysIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postListsIdSurveysIdActionsCreateEmailDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    survey_id: z.string(),
  }),
});

export const postListsIdSurveysIdActionsCreateEmailResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  ab_split_opts: z
    .object({
      from_name_a: z.string().optional(),
      from_name_b: z.string().optional(),
      pick_winner: z.union([z.literal('opens'), z.literal('clicks'), z.literal('manual')]).optional(),
      reply_email_a: z.string().optional(),
      reply_email_b: z.string().optional(),
      send_time_a: z.string().optional(),
      send_time_b: z.string().optional(),
      send_time_winner: z.string().optional(),
      split_size: z.number().optional(),
      split_test: z.union([z.literal('subject'), z.literal('from_name'), z.literal('schedule')]).optional(),
      subject_a: z.string().optional(),
      subject_b: z.string().optional(),
      wait_time: z.number().optional(),
      wait_units: z.union([z.literal('hours'), z.literal('days')]).optional(),
    })
    .optional(),
  archive_url: z.string().optional(),
  content_type: z.string().optional(),
  create_time: z.string().optional(),
  delivery_status: z
    .object({
      can_cancel: z.boolean().optional(),
      emails_canceled: z.number().optional(),
      emails_sent: z.number().optional(),
      enabled: z.boolean().optional(),
      status: z
        .union([z.literal('delivering'), z.literal('delivered'), z.literal('canceling'), z.literal('canceled')])
        .optional(),
    })
    .optional(),
  emails_sent: z.number().optional(),
  id: z.string().optional(),
  long_archive_url: z.string().optional(),
  needs_block_refresh: z.boolean().optional(),
  parent_campaign_id: z.string().optional(),
  recipients: z
    .object({
      list_id: z.string(),
      list_name: z.string().optional(),
      recipient_count: z.number().optional(),
      segment_opts: z
        .object({
          conditions: z
            .array(
              z.union([
                z.object({
                  condition_type: z.literal('Aim').optional(),
                  field: z.literal('aim').optional(),
                  op: z
                    .union([
                      z.literal('open'),
                      z.literal('click'),
                      z.literal('sent'),
                      z.literal('noopen'),
                      z.literal('noclick'),
                      z.literal('nosent'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('Automation').optional(),
                  field: z.literal('automation'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('CampaignPoll').optional(),
                  field: z.literal('poll'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('Conversation').optional(),
                  field: z.literal('conversation'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Date').optional(),
                  extra: z.string().optional(),
                  field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
                  op: z.union([
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('within'),
                    z.literal('notwithin'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('EmailClient').optional(),
                  field: z.literal('email_client'),
                  op: z.union([z.literal('client_is'), z.literal('client_not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('Language').optional(),
                  field: z.literal('language'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('MemberRating').optional(),
                  field: z.literal('rating'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SignupSource'),
                  field: z.literal('source'),
                  op: z.union([z.literal('source_is'), z.literal('source_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SurveyMonkey').optional(),
                  field: z.literal('survey_monkey'),
                  op: z.union([
                    z.literal('started'),
                    z.literal('completed'),
                    z.literal('not_started'),
                    z.literal('not_completed'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('VIP').optional(),
                  field: z.literal('gmonkey'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                }),
                z.object({
                  condition_type: z.literal('Interests').optional(),
                  field: z.string().optional(),
                  op: z
                    .union([
                      z.literal('interestcontains'),
                      z.literal('interestcontainsall'),
                      z.literal('interestnotcontains'),
                    ])
                    .optional(),
                  value: z.array(z.string()).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommCategory').optional(),
                  field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                  op: z
                    .union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                    ])
                    .optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommNumber').optional(),
                  field: z.union([
                    z.literal('ecomm_spent_avg'),
                    z.literal('ecomm_orders'),
                    z.literal('ecomm_prod_all'),
                    z.literal('ecomm_avg_ord'),
                  ]),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('EcommPurchased').optional(),
                  field: z.literal('ecomm_purchased').optional(),
                  op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommSpent').optional(),
                  field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                  op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                  value: z.number().optional(),
                }),
                z.object({
                  condition_type: z.literal('EcommStore').optional(),
                  field: z.literal('ecomm_store').optional(),
                  op: z.union([z.literal('is'), z.literal('not')]).optional(),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('GoalActivity').optional(),
                  field: z.literal('goal'),
                  op: z.union([
                    z.literal('is'),
                    z.literal('goal_not'),
                    z.literal('contains'),
                    z.literal('goal_notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('GoalTimestamp').optional(),
                  field: z.literal('goal_last_visited'),
                  op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('FuzzySegment').optional(),
                  field: z.literal('fuzzy_segment'),
                  op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('StaticSegment').optional(),
                  field: z.literal('static_segment'),
                  op: z.union([z.literal('static_is'), z.literal('static_not')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoCountryState').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([
                    z.literal('ipgeocountry'),
                    z.literal('ipgeonotcountry'),
                    z.literal('ipgeostate'),
                    z.literal('ipgeonotstate'),
                  ]),
                  value: z.string(),
                }),
                z.object({
                  addr: z.string(),
                  condition_type: z.literal('IPGeoIn').optional(),
                  field: z.literal('ipgeo'),
                  lat: z.string(),
                  lng: z.string(),
                  op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoInZip').optional(),
                  extra: z.number(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeoinzip'),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('IPGeoUnknown').optional(),
                  field: z.literal('ipgeo'),
                  op: z.literal('ipgeounknown'),
                }),
                z.object({
                  condition_type: z.literal('IPGeoZip').optional(),
                  field: z.literal('ipgeo'),
                  op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialAge').optional(),
                  field: z.literal('social_age'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                }),
                z.object({
                  condition_type: z.literal('SocialGender').optional(),
                  field: z.literal('social_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('SocialInfluence').optional(),
                  field: z.literal('social_influence'),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                  value: z.number(),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkMember').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('member'), z.literal('notmember')]),
                  value: z.union([
                    z.literal('twitter'),
                    z.literal('facebook'),
                    z.literal('linkedin'),
                    z.literal('flickr'),
                    z.literal('foursquare'),
                    z.literal('lastfm'),
                    z.literal('myspace'),
                    z.literal('quora'),
                    z.literal('vimeo'),
                    z.literal('yelp'),
                    z.literal('youtube'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('SocialNetworkFollow').optional(),
                  field: z.literal('social_network'),
                  op: z.union([z.literal('follow'), z.literal('notfollow')]),
                  value: z.literal('twitter_follow'),
                }),
                z.object({
                  condition_type: z.literal('AddressMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('ZipMerge').optional(),
                  extra: z.string(),
                  field: z.string(),
                  op: z.literal('geoin'),
                  value: z.string(),
                }),
                z.object({
                  condition_type: z.literal('BirthdayMerge').optional(),
                  field: z.string(),
                  op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('DateMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('greater'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('SelectMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                    z.literal('notcontain'),
                    z.literal('contains'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('TextMerge').optional(),
                  field: z.string(),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                    z.literal('blank'),
                    z.literal('blank_not'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('EmailAddress').optional(),
                  field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                  op: z.union([
                    z.literal('is'),
                    z.literal('not'),
                    z.literal('contains'),
                    z.literal('notcontain'),
                    z.literal('starts'),
                    z.literal('ends'),
                    z.literal('greater'),
                    z.literal('less'),
                  ]),
                  value: z.string().optional(),
                }),
                z.object({
                  condition_type: z.literal('PredictedGender').optional(),
                  field: z.literal('predicted_gender'),
                  op: z.union([z.literal('is'), z.literal('not')]),
                  value: z.union([z.literal('male'), z.literal('female')]),
                }),
                z.object({
                  condition_type: z.literal('PredictedAge').optional(),
                  field: z.literal('predicted_age_range'),
                  op: z.literal('is'),
                  value: z.union([
                    z.literal('18-24'),
                    z.literal('25-34'),
                    z.literal('35-44'),
                    z.literal('45-54'),
                    z.literal('55-64'),
                    z.literal('65+'),
                  ]),
                }),
                z.object({
                  condition_type: z.literal('NewSubscribers').optional(),
                  field: z.literal('timestamp_opt').optional(),
                  op: z.literal('date_within').optional(),
                  value: z.string().optional(),
                }),
              ]),
            )
            .optional(),
          match: z.union([z.literal('any'), z.literal('all')]).optional(),
          prebuilt_segment_id: z.string().optional(),
          saved_segment_id: z.number().optional(),
        })
        .optional(),
      segment_text: z.string().optional(),
    })
    .optional(),
  report_summary: z
    .object({
      click_rate: z.number().optional(),
      clicks: z.number().optional(),
      ecommerce: z
        .object({
          total_orders: z.number().optional(),
          total_revenue: z.number().optional(),
          total_spent: z.number().optional(),
        })
        .optional(),
      open_rate: z.number().optional(),
      opens: z.number().optional(),
      subscriber_clicks: z.number().optional(),
      unique_opens: z.number().optional(),
    })
    .optional(),
  resendable: z.boolean().optional(),
  rss_opts: z
    .object({
      constrain_rss_img: z.boolean().optional(),
      feed_url: z.string(),
      frequency: z.union([z.literal('daily'), z.literal('weekly'), z.literal('monthly')]),
      last_sent: z.string().optional(),
      schedule: z
        .object({
          daily_send: z
            .object({
              friday: z.boolean().optional(),
              monday: z.boolean().optional(),
              saturday: z.boolean().optional(),
              sunday: z.boolean().optional(),
              thursday: z.boolean().optional(),
              tuesday: z.boolean().optional(),
              wednesday: z.boolean().optional(),
            })
            .optional(),
          hour: z.number().optional(),
          monthly_send_date: z.number().optional(),
          weekly_send_day: z
            .union([
              z.literal('sunday'),
              z.literal('monday'),
              z.literal('tuesday'),
              z.literal('wednesday'),
              z.literal('thursday'),
              z.literal('friday'),
              z.literal('saturday'),
            ])
            .optional(),
        })
        .optional(),
    })
    .optional(),
  send_time: z.string().optional(),
  settings: z
    .object({
      authenticate: z.boolean().optional(),
      auto_fb_post: z.array(z.string()).optional(),
      auto_footer: z.boolean().optional(),
      auto_tweet: z.boolean().optional(),
      drag_and_drop: z.boolean().optional(),
      fb_comments: z.boolean().optional(),
      folder_id: z.string().optional(),
      from_name: z.string().optional(),
      inline_css: z.boolean().optional(),
      preview_text: z.string().optional(),
      reply_to: z.string().optional(),
      subject_line: z.string().optional(),
      template_id: z.number().optional(),
      timewarp: z.boolean().optional(),
      title: z.string().optional(),
      to_name: z.string().optional(),
      use_conversation: z.boolean().optional(),
    })
    .optional(),
  social_card: z
    .object({
      description: z.string().optional(),
      image_url: z.string().optional(),
      title: z.string().optional(),
    })
    .optional(),
  status: z
    .union([
      z.literal('save'),
      z.literal('paused'),
      z.literal('schedule'),
      z.literal('sending'),
      z.literal('sent'),
      z.literal('canceled'),
      z.literal('canceling'),
      z.literal('archived'),
    ])
    .optional(),
  tracking: z
    .object({
      capsule: z
        .object({
          notes: z.boolean().optional(),
        })
        .optional(),
      clicktale: z.string().optional(),
      ecomm360: z.boolean().optional(),
      goal_tracking: z.boolean().optional(),
      google_analytics: z.string().optional(),
      html_clicks: z.boolean().optional(),
      opens: z.boolean().optional(),
      salesforce: z
        .object({
          campaign: z.boolean().optional(),
          notes: z.boolean().optional(),
        })
        .optional(),
      text_clicks: z.boolean().optional(),
    })
    .optional(),
  type: z.union([
    z.literal('regular'),
    z.literal('plaintext'),
    z.literal('absplit'),
    z.literal('rss'),
    z.literal('variate'),
  ]),
  variate_settings: z
    .object({
      combinations: z
        .array(
          z.object({
            content_description: z.number().optional(),
            from_name: z.number().optional(),
            id: z.string().optional(),
            recipients: z.number().optional(),
            reply_to: z.number().optional(),
            send_time: z.number().optional(),
            subject_line: z.number().optional(),
          }),
        )
        .optional(),
      contents: z.array(z.string()).optional(),
      from_names: z.array(z.string()).optional(),
      reply_to_addresses: z.array(z.string()).optional(),
      send_times: z.array(z.string()).optional(),
      subject_lines: z.array(z.string()).optional(),
      test_size: z.number().optional(),
      wait_time: z.number().optional(),
      winner_criteria: z.union([
        z.literal('opens'),
        z.literal('clicks'),
        z.literal('manual'),
        z.literal('total_revenue'),
      ]),
      winning_campaign_id: z.string().optional(),
      winning_combination_id: z.string().optional(),
    })
    .optional(),
  web_id: z.number().optional(),
});

export const postListsIdSurveysIdActionsCreateEmailErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postListsIdSurveysIdActionsPublishDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    survey_id: z.string(),
  }),
});

export const postListsIdSurveysIdActionsPublishResponseSchema = z.unknown();

export const postListsIdSurveysIdActionsPublishErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postListsIdSurveysIdActionsUnpublishDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    survey_id: z.string(),
  }),
});

export const postListsIdSurveysIdActionsUnpublishResponseSchema = z.unknown();

export const postListsIdSurveysIdActionsUnpublishErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const searchTagsByNameDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
  }),
  query: z
    .object({
      name: z.string().optional(),
    })
    .optional(),
});

export const searchTagsByNameResponseSchema = z.object({
  tags: z
    .array(
      z.object({
        id: z.number().optional(),
        name: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const searchTagsByNameErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdWebhooksDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
  }),
});

export const getListsIdWebhooksResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  list_id: z.string().optional(),
  total_items: z.number().optional(),
  webhooks: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        events: z
          .object({
            campaign: z.boolean().optional(),
            cleaned: z.boolean().optional(),
            profile: z.boolean().optional(),
            subscribe: z.boolean().optional(),
            unsubscribe: z.boolean().optional(),
            upemail: z.boolean().optional(),
          })
          .optional(),
        id: z.string().optional(),
        list_id: z.string().optional(),
        sources: z
          .object({
            admin: z.boolean().optional(),
            api: z.boolean().optional(),
            user: z.boolean().optional(),
          })
          .optional(),
        url: z.string().optional(),
      }),
    )
    .optional(),
});

export const getListsIdWebhooksErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const postListsIdWebhooksDataSchema = z.object({
  body: z.object({
    events: z
      .object({
        campaign: z.boolean().optional(),
        cleaned: z.boolean().optional(),
        profile: z.boolean().optional(),
        subscribe: z.boolean().optional(),
        unsubscribe: z.boolean().optional(),
        upemail: z.boolean().optional(),
      })
      .optional(),
    sources: z
      .object({
        admin: z.boolean().optional(),
        api: z.boolean().optional(),
        user: z.boolean().optional(),
      })
      .optional(),
    url: z.string().optional(),
  }),
  path: z.object({
    list_id: z.string(),
  }),
});

export const postListsIdWebhooksResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  events: z
    .object({
      campaign: z.boolean().optional(),
      cleaned: z.boolean().optional(),
      profile: z.boolean().optional(),
      subscribe: z.boolean().optional(),
      unsubscribe: z.boolean().optional(),
      upemail: z.boolean().optional(),
    })
    .optional(),
  id: z.string().optional(),
  list_id: z.string().optional(),
  sources: z
    .object({
      admin: z.boolean().optional(),
      api: z.boolean().optional(),
      user: z.boolean().optional(),
    })
    .optional(),
  url: z.string().optional(),
});

export const postListsIdWebhooksErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const deleteListsIdWebhooksIdDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    webhook_id: z.string(),
  }),
});

export const deleteListsIdWebhooksIdResponseSchema = z.any();

export const deleteListsIdWebhooksIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getListsIdWebhooksIdDataSchema = z.object({
  path: z.object({
    list_id: z.string(),
    webhook_id: z.string(),
  }),
});

export const getListsIdWebhooksIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  events: z
    .object({
      campaign: z.boolean().optional(),
      cleaned: z.boolean().optional(),
      profile: z.boolean().optional(),
      subscribe: z.boolean().optional(),
      unsubscribe: z.boolean().optional(),
      upemail: z.boolean().optional(),
    })
    .optional(),
  id: z.string().optional(),
  list_id: z.string().optional(),
  sources: z
    .object({
      admin: z.boolean().optional(),
      api: z.boolean().optional(),
      user: z.boolean().optional(),
    })
    .optional(),
  url: z.string().optional(),
});

export const getListsIdWebhooksIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const patchListsIdWebhooksIdDataSchema = z.object({
  body: z.object({
    events: z
      .object({
        campaign: z.boolean().optional(),
        cleaned: z.boolean().optional(),
        profile: z.boolean().optional(),
        subscribe: z.boolean().optional(),
        unsubscribe: z.boolean().optional(),
        upemail: z.boolean().optional(),
      })
      .optional(),
    sources: z
      .object({
        admin: z.boolean().optional(),
        api: z.boolean().optional(),
        user: z.boolean().optional(),
      })
      .optional(),
    url: z.string().optional(),
  }),
  path: z.object({
    list_id: z.string(),
    webhook_id: z.string(),
  }),
});

export const patchListsIdWebhooksIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  events: z
    .object({
      campaign: z.boolean().optional(),
      cleaned: z.boolean().optional(),
      profile: z.boolean().optional(),
      subscribe: z.boolean().optional(),
      unsubscribe: z.boolean().optional(),
      upemail: z.boolean().optional(),
    })
    .optional(),
  id: z.string().optional(),
  list_id: z.string().optional(),
  sources: z
    .object({
      admin: z.boolean().optional(),
      api: z.boolean().optional(),
      user: z.boolean().optional(),
    })
    .optional(),
  url: z.string().optional(),
});

export const patchListsIdWebhooksIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getPingResponseSchema = z.object({
  health_status: z.string().optional(),
});

export const getPingErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportingFacebookAdsDataSchema = z.object({
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
      sort_dir: z.union([z.literal('ASC'), z.literal('DESC')]).optional(),
      sort_field: z.union([z.literal('created_at'), z.literal('updated_at'), z.literal('end_time')]).optional(),
    })
    .optional(),
});

export const getReportingFacebookAdsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  facebook_ads: z
    .array(
      z
        .object({
          canceled_at: z.string().optional(),
          create_time: z.string().optional(),
          has_segment: z.boolean().optional(),
          id: z.string().optional(),
          name: z.string().optional(),
          published_time: z.string().optional(),
          recipients: z
            .object({
              list_id: z.string().optional(),
              list_is_active: z.boolean().optional(),
              list_name: z.string().optional(),
              recipient_count: z.number().optional(),
              segment_opts: z
                .object({
                  conditions: z
                    .array(
                      z.union([
                        z.object({
                          condition_type: z.literal('Aim').optional(),
                          field: z.literal('aim').optional(),
                          op: z
                            .union([
                              z.literal('open'),
                              z.literal('click'),
                              z.literal('sent'),
                              z.literal('noopen'),
                              z.literal('noclick'),
                              z.literal('nosent'),
                            ])
                            .optional(),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('Automation').optional(),
                          field: z.literal('automation'),
                          op: z.union([
                            z.literal('started'),
                            z.literal('completed'),
                            z.literal('not_started'),
                            z.literal('not_completed'),
                          ]),
                          value: z.string(),
                        }),
                        z.object({
                          condition_type: z.literal('CampaignPoll').optional(),
                          field: z.literal('poll'),
                          op: z.union([z.literal('member'), z.literal('notmember')]),
                          value: z.number(),
                        }),
                        z.object({
                          condition_type: z.literal('Conversation').optional(),
                          field: z.literal('conversation'),
                          op: z.union([z.literal('member'), z.literal('notmember')]),
                          value: z.string(),
                        }),
                        z.object({
                          condition_type: z.literal('Date').optional(),
                          extra: z.string().optional(),
                          field: z.union([
                            z.literal('timestamp_opt'),
                            z.literal('info_changed'),
                            z.literal('ecomm_date'),
                          ]),
                          op: z.union([
                            z.literal('greater'),
                            z.literal('less'),
                            z.literal('is'),
                            z.literal('not'),
                            z.literal('blank'),
                            z.literal('blank_not'),
                            z.literal('within'),
                            z.literal('notwithin'),
                          ]),
                          value: z.string(),
                        }),
                        z.object({
                          condition_type: z.literal('EmailClient').optional(),
                          field: z.literal('email_client'),
                          op: z.union([z.literal('client_is'), z.literal('client_not')]),
                          value: z.string(),
                        }),
                        z.object({
                          condition_type: z.literal('Language').optional(),
                          field: z.literal('language'),
                          op: z.union([z.literal('is'), z.literal('not')]),
                          value: z.string(),
                        }),
                        z.object({
                          condition_type: z.literal('MemberRating').optional(),
                          field: z.literal('rating'),
                          op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                          value: z.number(),
                        }),
                        z.object({
                          condition_type: z.literal('SignupSource'),
                          field: z.literal('source'),
                          op: z.union([z.literal('source_is'), z.literal('source_not')]),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('SurveyMonkey').optional(),
                          field: z.literal('survey_monkey'),
                          op: z.union([
                            z.literal('started'),
                            z.literal('completed'),
                            z.literal('not_started'),
                            z.literal('not_completed'),
                          ]),
                          value: z.string(),
                        }),
                        z.object({
                          condition_type: z.literal('VIP').optional(),
                          field: z.literal('gmonkey'),
                          op: z.union([z.literal('member'), z.literal('notmember')]),
                        }),
                        z.object({
                          condition_type: z.literal('Interests').optional(),
                          field: z.string().optional(),
                          op: z
                            .union([
                              z.literal('interestcontains'),
                              z.literal('interestcontainsall'),
                              z.literal('interestnotcontains'),
                            ])
                            .optional(),
                          value: z.array(z.string()).optional(),
                        }),
                        z.object({
                          condition_type: z.literal('EcommCategory').optional(),
                          field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                          op: z
                            .union([
                              z.literal('is'),
                              z.literal('not'),
                              z.literal('contains'),
                              z.literal('notcontain'),
                              z.literal('starts'),
                              z.literal('ends'),
                            ])
                            .optional(),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('EcommNumber').optional(),
                          field: z.union([
                            z.literal('ecomm_spent_avg'),
                            z.literal('ecomm_orders'),
                            z.literal('ecomm_prod_all'),
                            z.literal('ecomm_avg_ord'),
                          ]),
                          op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                          value: z.number(),
                        }),
                        z.object({
                          condition_type: z.literal('EcommPurchased').optional(),
                          field: z.literal('ecomm_purchased').optional(),
                          op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                        }),
                        z.object({
                          condition_type: z.literal('EcommSpent').optional(),
                          field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                          op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                          value: z.number().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('EcommStore').optional(),
                          field: z.literal('ecomm_store').optional(),
                          op: z.union([z.literal('is'), z.literal('not')]).optional(),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('GoalActivity').optional(),
                          field: z.literal('goal'),
                          op: z.union([
                            z.literal('is'),
                            z.literal('goal_not'),
                            z.literal('contains'),
                            z.literal('goal_notcontain'),
                            z.literal('starts'),
                            z.literal('ends'),
                          ]),
                          value: z.string(),
                        }),
                        z.object({
                          condition_type: z.literal('GoalTimestamp').optional(),
                          field: z.literal('goal_last_visited'),
                          op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                          value: z.string(),
                        }),
                        z.object({
                          condition_type: z.literal('FuzzySegment').optional(),
                          field: z.literal('fuzzy_segment'),
                          op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                          value: z.number(),
                        }),
                        z.object({
                          condition_type: z.literal('StaticSegment').optional(),
                          field: z.literal('static_segment'),
                          op: z.union([z.literal('static_is'), z.literal('static_not')]),
                          value: z.number(),
                        }),
                        z.object({
                          condition_type: z.literal('IPGeoCountryState').optional(),
                          field: z.literal('ipgeo'),
                          op: z.union([
                            z.literal('ipgeocountry'),
                            z.literal('ipgeonotcountry'),
                            z.literal('ipgeostate'),
                            z.literal('ipgeonotstate'),
                          ]),
                          value: z.string(),
                        }),
                        z.object({
                          addr: z.string(),
                          condition_type: z.literal('IPGeoIn').optional(),
                          field: z.literal('ipgeo'),
                          lat: z.string(),
                          lng: z.string(),
                          op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                          value: z.number(),
                        }),
                        z.object({
                          condition_type: z.literal('IPGeoInZip').optional(),
                          extra: z.number(),
                          field: z.literal('ipgeo'),
                          op: z.literal('ipgeoinzip'),
                          value: z.number(),
                        }),
                        z.object({
                          condition_type: z.literal('IPGeoUnknown').optional(),
                          field: z.literal('ipgeo'),
                          op: z.literal('ipgeounknown'),
                        }),
                        z.object({
                          condition_type: z.literal('IPGeoZip').optional(),
                          field: z.literal('ipgeo'),
                          op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                          value: z.number(),
                        }),
                        z.object({
                          condition_type: z.literal('SocialAge').optional(),
                          field: z.literal('social_age'),
                          op: z.union([z.literal('is'), z.literal('not')]),
                          value: z.union([
                            z.literal('18-24'),
                            z.literal('25-34'),
                            z.literal('35-54'),
                            z.literal('55+'),
                          ]),
                        }),
                        z.object({
                          condition_type: z.literal('SocialGender').optional(),
                          field: z.literal('social_gender'),
                          op: z.union([z.literal('is'), z.literal('not')]),
                          value: z.union([z.literal('male'), z.literal('female')]),
                        }),
                        z.object({
                          condition_type: z.literal('SocialInfluence').optional(),
                          field: z.literal('social_influence'),
                          op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                          value: z.number(),
                        }),
                        z.object({
                          condition_type: z.literal('SocialNetworkMember').optional(),
                          field: z.literal('social_network'),
                          op: z.union([z.literal('member'), z.literal('notmember')]),
                          value: z.union([
                            z.literal('twitter'),
                            z.literal('facebook'),
                            z.literal('linkedin'),
                            z.literal('flickr'),
                            z.literal('foursquare'),
                            z.literal('lastfm'),
                            z.literal('myspace'),
                            z.literal('quora'),
                            z.literal('vimeo'),
                            z.literal('yelp'),
                            z.literal('youtube'),
                          ]),
                        }),
                        z.object({
                          condition_type: z.literal('SocialNetworkFollow').optional(),
                          field: z.literal('social_network'),
                          op: z.union([z.literal('follow'), z.literal('notfollow')]),
                          value: z.literal('twitter_follow'),
                        }),
                        z.object({
                          condition_type: z.literal('AddressMerge').optional(),
                          field: z.string(),
                          op: z.union([
                            z.literal('contains'),
                            z.literal('notcontain'),
                            z.literal('blank'),
                            z.literal('blank_not'),
                          ]),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('ZipMerge').optional(),
                          extra: z.string(),
                          field: z.string(),
                          op: z.literal('geoin'),
                          value: z.string(),
                        }),
                        z.object({
                          condition_type: z.literal('BirthdayMerge').optional(),
                          field: z.string(),
                          op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('DateMerge').optional(),
                          field: z.string(),
                          op: z.union([
                            z.literal('is'),
                            z.literal('not'),
                            z.literal('less'),
                            z.literal('blank'),
                            z.literal('blank_not'),
                            z.literal('greater'),
                          ]),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('SelectMerge').optional(),
                          field: z.string(),
                          op: z.union([
                            z.literal('is'),
                            z.literal('not'),
                            z.literal('blank'),
                            z.literal('blank_not'),
                            z.literal('notcontain'),
                            z.literal('contains'),
                          ]),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('TextMerge').optional(),
                          field: z.string(),
                          op: z.union([
                            z.literal('is'),
                            z.literal('not'),
                            z.literal('contains'),
                            z.literal('notcontain'),
                            z.literal('starts'),
                            z.literal('ends'),
                            z.literal('greater'),
                            z.literal('less'),
                            z.literal('blank'),
                            z.literal('blank_not'),
                          ]),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('EmailAddress').optional(),
                          field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                          op: z.union([
                            z.literal('is'),
                            z.literal('not'),
                            z.literal('contains'),
                            z.literal('notcontain'),
                            z.literal('starts'),
                            z.literal('ends'),
                            z.literal('greater'),
                            z.literal('less'),
                          ]),
                          value: z.string().optional(),
                        }),
                        z.object({
                          condition_type: z.literal('PredictedGender').optional(),
                          field: z.literal('predicted_gender'),
                          op: z.union([z.literal('is'), z.literal('not')]),
                          value: z.union([z.literal('male'), z.literal('female')]),
                        }),
                        z.object({
                          condition_type: z.literal('PredictedAge').optional(),
                          field: z.literal('predicted_age_range'),
                          op: z.literal('is'),
                          value: z.union([
                            z.literal('18-24'),
                            z.literal('25-34'),
                            z.literal('35-44'),
                            z.literal('45-54'),
                            z.literal('55-64'),
                            z.literal('65+'),
                          ]),
                        }),
                        z.object({
                          condition_type: z.literal('NewSubscribers').optional(),
                          field: z.literal('timestamp_opt').optional(),
                          op: z.literal('date_within').optional(),
                          value: z.string().optional(),
                        }),
                      ]),
                    )
                    .optional(),
                  match: z.union([z.literal('any'), z.literal('all')]).optional(),
                  prebuilt_segment_id: z.string().optional(),
                  saved_segment_id: z.number().optional(),
                })
                .optional(),
              segment_text: z.string().optional(),
            })
            .optional(),
          report_summary: z
            .object({
              click_rate: z.number().optional(),
              clicks: z.number().optional(),
              conversion_rate: z.number().optional(),
              ecommerce: z
                .object({
                  average_order_revenue: z.number().optional(),
                  currency_code: z.string().optional(),
                  total_revenue: z.number().optional(),
                })
                .optional(),
              engagements: z.number().optional(),
              impressions: z.number().optional(),
              open_rate: z.number().optional(),
              opens: z.number().optional(),
              reach: z.number().optional(),
              subscriber_clicks: z.number().optional(),
              subscribes: z.number().optional(),
              total_sent: z.number().optional(),
              unique_opens: z.number().optional(),
              unique_visits: z.number().optional(),
              visits: z.number().optional(),
            })
            .optional(),
          show_report: z.boolean().optional(),
          start_time: z.string().optional(),
          status: z
            .union([
              z.literal('save'),
              z.literal('paused'),
              z.literal('schedule'),
              z.literal('scheduled'),
              z.literal('sending'),
              z.literal('sent'),
              z.literal('canceled'),
              z.literal('canceling'),
              z.literal('active'),
              z.literal('disconnected'),
              z.literal('somepaused'),
              z.literal('draft'),
              z.literal('completed'),
              z.literal('partialRejected'),
              z.literal('pending'),
              z.literal('rejected'),
              z.literal('published'),
              z.literal('unpublished'),
            ])
            .optional(),
          thumbnail: z.string().optional(),
          type: z
            .union([
              z.literal('regular'),
              z.literal('email-touchpoint'),
              z.literal('plaintext'),
              z.literal('rss'),
              z.literal('reconfirm'),
              z.literal('variate'),
              z.literal('absplit'),
              z.literal('automation'),
              z.literal('facebook'),
              z.literal('google'),
              z.literal('autoresponder'),
              z.literal('transactional'),
              z.literal('page'),
              z.literal('website'),
              z.literal('social_post'),
              z.literal('survey'),
              z.literal('customer_journey'),
            ])
            .optional(),
          updated_at: z.string().optional(),
          web_id: z.number().optional(),
        })
        .and(
          z.object({
            email_source_name: z.string().optional(),
            end_time: z.string().optional(),
            needs_attention: z.boolean().optional(),
            paused_at: z.string().optional(),
            was_canceled_by_facebook: z.boolean().optional(),
          }),
        )
        .and(
          z.object({
            audience: z
              .object({
                email_source: z
                  .object({
                    is_segment: z.boolean().optional(),
                    list_name: z.string().optional(),
                    name: z.string().optional(),
                    segment_type: z.string().optional(),
                    type: z.string().optional(),
                  })
                  .optional(),
                include_source_in_target: z.boolean().optional(),
                lookalike_country_code: z.string().optional(),
                source_type: z.union([z.literal('facebook'), z.literal('list')]).optional(),
                targeting_specs: z
                  .object({
                    gender: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
                    interests: z
                      .array(
                        z.object({
                          name: z.string().optional(),
                        }),
                      )
                      .optional(),
                    locations: z
                      .object({
                        cities: z.array(z.string()).optional(),
                        countries: z.array(z.string()).optional(),
                        regions: z.array(z.string()).optional(),
                        zips: z.array(z.string()).optional(),
                      })
                      .optional(),
                    max_age: z.number().optional(),
                    min_age: z.number().optional(),
                  })
                  .optional(),
                type: z
                  .union([
                    z.literal('Custom Audience'),
                    z.literal('Lookalike Audience'),
                    z.literal('Interest-based Audience'),
                  ])
                  .optional(),
              })
              .optional(),
            audience_activity: z
              .object({
                clicks: z
                  .array(
                    z.object({
                      clicks: z.number().optional(),
                      date: z.string().optional(),
                    }),
                  )
                  .optional(),
                impressions: z
                  .array(
                    z.object({
                      date: z.string().optional(),
                      impressions: z.number().optional(),
                    }),
                  )
                  .optional(),
                revenue: z
                  .array(
                    z.object({
                      date: z.string().optional(),
                      revenue: z.number().optional(),
                    }),
                  )
                  .optional(),
              })
              .optional(),
            budget: z
              .object({
                currency_code: z.string().optional(),
                duration: z.number().optional(),
                total_amount: z.number().optional(),
              })
              .optional(),
            channel: z
              .object({
                fb_placement_audience: z.boolean().optional(),
                fb_placement_feed: z.boolean().optional(),
                ig_placement_feed: z.boolean().optional(),
              })
              .optional(),
            report_summary: z
              .object({
                average_daily_budget: z
                  .object({
                    amount: z.number().optional(),
                    currency_code: z.string().optional(),
                  })
                  .optional(),
                average_order_amount: z
                  .object({
                    amount: z.number().optional(),
                    currency_code: z.string().optional(),
                  })
                  .optional(),
                click_rate: z.number().optional(),
                clicks: z.number().optional(),
                comments: z.number().optional(),
                cost_per_click: z
                  .object({
                    amount: z.number().optional(),
                    currency_code: z.string().optional(),
                  })
                  .optional(),
                ecommerce: z
                  .object({
                    currency_code: z.string().optional(),
                    total_revenue: z.number().optional(),
                  })
                  .optional(),
                extended_at: z
                  .object({
                    datetime: z.string().optional(),
                    timezone: z.string().optional(),
                  })
                  .optional(),
                first_time_buyers: z.number().optional(),
                has_extended_ad_duration: z.boolean().optional(),
                impressions: z.number().optional(),
                likes: z.number().optional(),
                reach: z.number().optional(),
                return_on_investment: z.number().optional(),
                shares: z.number().optional(),
                total_orders: z.number().optional(),
                total_products_sold: z.number().optional(),
                unique_clicks: z.number().optional(),
              })
              .optional(),
          }),
        )
        .and(
          z.object({
            _links: z
              .array(
                z.object({
                  href: z.string().optional(),
                  method: z
                    .union([
                      z.literal('GET'),
                      z.literal('POST'),
                      z.literal('PUT'),
                      z.literal('PATCH'),
                      z.literal('DELETE'),
                      z.literal('OPTIONS'),
                      z.literal('HEAD'),
                    ])
                    .optional(),
                  rel: z.string().optional(),
                  schema: z.string().optional(),
                  targetSchema: z.string().optional(),
                }),
              )
              .optional(),
          }),
        ),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getReportingFacebookAdsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportingFacebookAdsIdDataSchema = z.object({
  path: z.object({
    outreach_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getReportingFacebookAdsIdResponseSchema = z
  .object({
    canceled_at: z.string().optional(),
    create_time: z.string().optional(),
    has_segment: z.boolean().optional(),
    id: z.string().optional(),
    name: z.string().optional(),
    published_time: z.string().optional(),
    recipients: z
      .object({
        list_id: z.string().optional(),
        list_is_active: z.boolean().optional(),
        list_name: z.string().optional(),
        recipient_count: z.number().optional(),
        segment_opts: z
          .object({
            conditions: z
              .array(
                z.union([
                  z.object({
                    condition_type: z.literal('Aim').optional(),
                    field: z.literal('aim').optional(),
                    op: z
                      .union([
                        z.literal('open'),
                        z.literal('click'),
                        z.literal('sent'),
                        z.literal('noopen'),
                        z.literal('noclick'),
                        z.literal('nosent'),
                      ])
                      .optional(),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('Automation').optional(),
                    field: z.literal('automation'),
                    op: z.union([
                      z.literal('started'),
                      z.literal('completed'),
                      z.literal('not_started'),
                      z.literal('not_completed'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('CampaignPoll').optional(),
                    field: z.literal('poll'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('Conversation').optional(),
                    field: z.literal('conversation'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('Date').optional(),
                    extra: z.string().optional(),
                    field: z.union([z.literal('timestamp_opt'), z.literal('info_changed'), z.literal('ecomm_date')]),
                    op: z.union([
                      z.literal('greater'),
                      z.literal('less'),
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                      z.literal('within'),
                      z.literal('notwithin'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('EmailClient').optional(),
                    field: z.literal('email_client'),
                    op: z.union([z.literal('client_is'), z.literal('client_not')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('Language').optional(),
                    field: z.literal('language'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('MemberRating').optional(),
                    field: z.literal('rating'),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('SignupSource'),
                    field: z.literal('source'),
                    op: z.union([z.literal('source_is'), z.literal('source_not')]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('SurveyMonkey').optional(),
                    field: z.literal('survey_monkey'),
                    op: z.union([
                      z.literal('started'),
                      z.literal('completed'),
                      z.literal('not_started'),
                      z.literal('not_completed'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('VIP').optional(),
                    field: z.literal('gmonkey'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                  }),
                  z.object({
                    condition_type: z.literal('Interests').optional(),
                    field: z.string().optional(),
                    op: z
                      .union([
                        z.literal('interestcontains'),
                        z.literal('interestcontainsall'),
                        z.literal('interestnotcontains'),
                      ])
                      .optional(),
                    value: z.array(z.string()).optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommCategory').optional(),
                    field: z.union([z.literal('ecomm_cat'), z.literal('ecomm_prod')]).optional(),
                    op: z
                      .union([
                        z.literal('is'),
                        z.literal('not'),
                        z.literal('contains'),
                        z.literal('notcontain'),
                        z.literal('starts'),
                        z.literal('ends'),
                      ])
                      .optional(),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommNumber').optional(),
                    field: z.union([
                      z.literal('ecomm_spent_avg'),
                      z.literal('ecomm_orders'),
                      z.literal('ecomm_prod_all'),
                      z.literal('ecomm_avg_ord'),
                    ]),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommPurchased').optional(),
                    field: z.literal('ecomm_purchased').optional(),
                    op: z.union([z.literal('member'), z.literal('notmember')]).optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommSpent').optional(),
                    field: z.union([z.literal('ecomm_spent_one'), z.literal('ecomm_spent_all')]).optional(),
                    op: z.union([z.literal('greater'), z.literal('less')]).optional(),
                    value: z.number().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EcommStore').optional(),
                    field: z.literal('ecomm_store').optional(),
                    op: z.union([z.literal('is'), z.literal('not')]).optional(),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('GoalActivity').optional(),
                    field: z.literal('goal'),
                    op: z.union([
                      z.literal('is'),
                      z.literal('goal_not'),
                      z.literal('contains'),
                      z.literal('goal_notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('GoalTimestamp').optional(),
                    field: z.literal('goal_last_visited'),
                    op: z.union([z.literal('greater'), z.literal('less'), z.literal('is')]),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('FuzzySegment').optional(),
                    field: z.literal('fuzzy_segment'),
                    op: z.union([z.literal('fuzzy_is'), z.literal('fuzzy_not')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('StaticSegment').optional(),
                    field: z.literal('static_segment'),
                    op: z.union([z.literal('static_is'), z.literal('static_not')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoCountryState').optional(),
                    field: z.literal('ipgeo'),
                    op: z.union([
                      z.literal('ipgeocountry'),
                      z.literal('ipgeonotcountry'),
                      z.literal('ipgeostate'),
                      z.literal('ipgeonotstate'),
                    ]),
                    value: z.string(),
                  }),
                  z.object({
                    addr: z.string(),
                    condition_type: z.literal('IPGeoIn').optional(),
                    field: z.literal('ipgeo'),
                    lat: z.string(),
                    lng: z.string(),
                    op: z.union([z.literal('ipgeoin'), z.literal('ipgeonotin')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoInZip').optional(),
                    extra: z.number(),
                    field: z.literal('ipgeo'),
                    op: z.literal('ipgeoinzip'),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoUnknown').optional(),
                    field: z.literal('ipgeo'),
                    op: z.literal('ipgeounknown'),
                  }),
                  z.object({
                    condition_type: z.literal('IPGeoZip').optional(),
                    field: z.literal('ipgeo'),
                    op: z.union([z.literal('ipgeoiszip'), z.literal('ipgeonotzip')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('SocialAge').optional(),
                    field: z.literal('social_age'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.union([z.literal('18-24'), z.literal('25-34'), z.literal('35-54'), z.literal('55+')]),
                  }),
                  z.object({
                    condition_type: z.literal('SocialGender').optional(),
                    field: z.literal('social_gender'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.union([z.literal('male'), z.literal('female')]),
                  }),
                  z.object({
                    condition_type: z.literal('SocialInfluence').optional(),
                    field: z.literal('social_influence'),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('greater'), z.literal('less')]),
                    value: z.number(),
                  }),
                  z.object({
                    condition_type: z.literal('SocialNetworkMember').optional(),
                    field: z.literal('social_network'),
                    op: z.union([z.literal('member'), z.literal('notmember')]),
                    value: z.union([
                      z.literal('twitter'),
                      z.literal('facebook'),
                      z.literal('linkedin'),
                      z.literal('flickr'),
                      z.literal('foursquare'),
                      z.literal('lastfm'),
                      z.literal('myspace'),
                      z.literal('quora'),
                      z.literal('vimeo'),
                      z.literal('yelp'),
                      z.literal('youtube'),
                    ]),
                  }),
                  z.object({
                    condition_type: z.literal('SocialNetworkFollow').optional(),
                    field: z.literal('social_network'),
                    op: z.union([z.literal('follow'), z.literal('notfollow')]),
                    value: z.literal('twitter_follow'),
                  }),
                  z.object({
                    condition_type: z.literal('AddressMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('ZipMerge').optional(),
                    extra: z.string(),
                    field: z.string(),
                    op: z.literal('geoin'),
                    value: z.string(),
                  }),
                  z.object({
                    condition_type: z.literal('BirthdayMerge').optional(),
                    field: z.string(),
                    op: z.union([z.literal('is'), z.literal('not'), z.literal('blank'), z.literal('blank_not')]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('DateMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('less'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                      z.literal('greater'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('SelectMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                      z.literal('notcontain'),
                      z.literal('contains'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('TextMerge').optional(),
                    field: z.string(),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                      z.literal('greater'),
                      z.literal('less'),
                      z.literal('blank'),
                      z.literal('blank_not'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('EmailAddress').optional(),
                    field: z.union([z.literal('merge0'), z.literal('EMAIL')]),
                    op: z.union([
                      z.literal('is'),
                      z.literal('not'),
                      z.literal('contains'),
                      z.literal('notcontain'),
                      z.literal('starts'),
                      z.literal('ends'),
                      z.literal('greater'),
                      z.literal('less'),
                    ]),
                    value: z.string().optional(),
                  }),
                  z.object({
                    condition_type: z.literal('PredictedGender').optional(),
                    field: z.literal('predicted_gender'),
                    op: z.union([z.literal('is'), z.literal('not')]),
                    value: z.union([z.literal('male'), z.literal('female')]),
                  }),
                  z.object({
                    condition_type: z.literal('PredictedAge').optional(),
                    field: z.literal('predicted_age_range'),
                    op: z.literal('is'),
                    value: z.union([
                      z.literal('18-24'),
                      z.literal('25-34'),
                      z.literal('35-44'),
                      z.literal('45-54'),
                      z.literal('55-64'),
                      z.literal('65+'),
                    ]),
                  }),
                  z.object({
                    condition_type: z.literal('NewSubscribers').optional(),
                    field: z.literal('timestamp_opt').optional(),
                    op: z.literal('date_within').optional(),
                    value: z.string().optional(),
                  }),
                ]),
              )
              .optional(),
            match: z.union([z.literal('any'), z.literal('all')]).optional(),
            prebuilt_segment_id: z.string().optional(),
            saved_segment_id: z.number().optional(),
          })
          .optional(),
        segment_text: z.string().optional(),
      })
      .optional(),
    report_summary: z
      .object({
        click_rate: z.number().optional(),
        clicks: z.number().optional(),
        conversion_rate: z.number().optional(),
        ecommerce: z
          .object({
            average_order_revenue: z.number().optional(),
            currency_code: z.string().optional(),
            total_revenue: z.number().optional(),
          })
          .optional(),
        engagements: z.number().optional(),
        impressions: z.number().optional(),
        open_rate: z.number().optional(),
        opens: z.number().optional(),
        reach: z.number().optional(),
        subscriber_clicks: z.number().optional(),
        subscribes: z.number().optional(),
        total_sent: z.number().optional(),
        unique_opens: z.number().optional(),
        unique_visits: z.number().optional(),
        visits: z.number().optional(),
      })
      .optional(),
    show_report: z.boolean().optional(),
    start_time: z.string().optional(),
    status: z
      .union([
        z.literal('save'),
        z.literal('paused'),
        z.literal('schedule'),
        z.literal('scheduled'),
        z.literal('sending'),
        z.literal('sent'),
        z.literal('canceled'),
        z.literal('canceling'),
        z.literal('active'),
        z.literal('disconnected'),
        z.literal('somepaused'),
        z.literal('draft'),
        z.literal('completed'),
        z.literal('partialRejected'),
        z.literal('pending'),
        z.literal('rejected'),
        z.literal('published'),
        z.literal('unpublished'),
      ])
      .optional(),
    thumbnail: z.string().optional(),
    type: z
      .union([
        z.literal('regular'),
        z.literal('email-touchpoint'),
        z.literal('plaintext'),
        z.literal('rss'),
        z.literal('reconfirm'),
        z.literal('variate'),
        z.literal('absplit'),
        z.literal('automation'),
        z.literal('facebook'),
        z.literal('google'),
        z.literal('autoresponder'),
        z.literal('transactional'),
        z.literal('page'),
        z.literal('website'),
        z.literal('social_post'),
        z.literal('survey'),
        z.literal('customer_journey'),
      ])
      .optional(),
    updated_at: z.string().optional(),
    web_id: z.number().optional(),
  })
  .and(
    z.object({
      email_source_name: z.string().optional(),
      end_time: z.string().optional(),
      needs_attention: z.boolean().optional(),
      paused_at: z.string().optional(),
      was_canceled_by_facebook: z.boolean().optional(),
    }),
  )
  .and(
    z.object({
      audience: z
        .object({
          email_source: z
            .object({
              is_segment: z.boolean().optional(),
              list_name: z.string().optional(),
              name: z.string().optional(),
              segment_type: z.string().optional(),
              type: z.string().optional(),
            })
            .optional(),
          include_source_in_target: z.boolean().optional(),
          lookalike_country_code: z.string().optional(),
          source_type: z.union([z.literal('facebook'), z.literal('list')]).optional(),
          targeting_specs: z
            .object({
              gender: z.union([z.literal(0), z.literal(1), z.literal(2)]).optional(),
              interests: z
                .array(
                  z.object({
                    name: z.string().optional(),
                  }),
                )
                .optional(),
              locations: z
                .object({
                  cities: z.array(z.string()).optional(),
                  countries: z.array(z.string()).optional(),
                  regions: z.array(z.string()).optional(),
                  zips: z.array(z.string()).optional(),
                })
                .optional(),
              max_age: z.number().optional(),
              min_age: z.number().optional(),
            })
            .optional(),
          type: z
            .union([
              z.literal('Custom Audience'),
              z.literal('Lookalike Audience'),
              z.literal('Interest-based Audience'),
            ])
            .optional(),
        })
        .optional(),
      audience_activity: z
        .object({
          clicks: z
            .array(
              z.object({
                clicks: z.number().optional(),
                date: z.string().optional(),
              }),
            )
            .optional(),
          impressions: z
            .array(
              z.object({
                date: z.string().optional(),
                impressions: z.number().optional(),
              }),
            )
            .optional(),
          revenue: z
            .array(
              z.object({
                date: z.string().optional(),
                revenue: z.number().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      budget: z
        .object({
          currency_code: z.string().optional(),
          duration: z.number().optional(),
          total_amount: z.number().optional(),
        })
        .optional(),
      channel: z
        .object({
          fb_placement_audience: z.boolean().optional(),
          fb_placement_feed: z.boolean().optional(),
          ig_placement_feed: z.boolean().optional(),
        })
        .optional(),
      report_summary: z
        .object({
          average_daily_budget: z
            .object({
              amount: z.number().optional(),
              currency_code: z.string().optional(),
            })
            .optional(),
          average_order_amount: z
            .object({
              amount: z.number().optional(),
              currency_code: z.string().optional(),
            })
            .optional(),
          click_rate: z.number().optional(),
          clicks: z.number().optional(),
          comments: z.number().optional(),
          cost_per_click: z
            .object({
              amount: z.number().optional(),
              currency_code: z.string().optional(),
            })
            .optional(),
          ecommerce: z
            .object({
              currency_code: z.string().optional(),
              total_revenue: z.number().optional(),
            })
            .optional(),
          extended_at: z
            .object({
              datetime: z.string().optional(),
              timezone: z.string().optional(),
            })
            .optional(),
          first_time_buyers: z.number().optional(),
          has_extended_ad_duration: z.boolean().optional(),
          impressions: z.number().optional(),
          likes: z.number().optional(),
          reach: z.number().optional(),
          return_on_investment: z.number().optional(),
          shares: z.number().optional(),
          total_orders: z.number().optional(),
          total_products_sold: z.number().optional(),
          unique_clicks: z.number().optional(),
        })
        .optional(),
    }),
  )
  .and(
    z.object({
      _links: z
        .array(
          z.object({
            href: z.string().optional(),
            method: z
              .union([
                z.literal('GET'),
                z.literal('POST'),
                z.literal('PUT'),
                z.literal('PATCH'),
                z.literal('DELETE'),
                z.literal('OPTIONS'),
                z.literal('HEAD'),
              ])
              .optional(),
            rel: z.string().optional(),
            schema: z.string().optional(),
            targetSchema: z.string().optional(),
          }),
        )
        .optional(),
    }),
  );

export const getReportingFacebookAdsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportingFacebookAdsIdEcommerceProductActivityDataSchema = z.object({
  path: z.object({
    outreach_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
      sort_field: z.union([z.literal('title'), z.literal('total_revenue'), z.literal('total_purchased')]).optional(),
    })
    .optional(),
});

export const getReportingFacebookAdsIdEcommerceProductActivityResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  products: z
    .array(
      z.object({
        currency_code: z.string().optional(),
        image_url: z.string().optional(),
        recommendation_purchased: z.number().optional(),
        recommendation_total: z.number().optional(),
        sku: z.string().optional(),
        title: z.string().optional(),
        total_purchased: z.number().optional(),
        total_revenue: z.number().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getReportingFacebookAdsIdEcommerceProductActivityErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportingLandingPagesDataSchema = z.object({
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getReportingLandingPagesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  landing_pages: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        clicks: z.number().optional(),
        conversion_rate: z.number().optional(),
        ecommerce: z
          .object({
            average_order_revenue: z.number().optional(),
            currency_code: z.string().optional(),
            total_orders: z.number().optional(),
            total_revenue: z.number().optional(),
          })
          .optional(),
        id: z.string().optional(),
        list_id: z.string().optional(),
        list_name: z.string().optional(),
        name: z.string().optional(),
        published_at: z.string().optional(),
        signup_tags: z
          .array(
            z.object({
              tag_id: z.number().optional(),
              tag_name: z.string().optional(),
            }),
          )
          .optional(),
        status: z.string().optional(),
        subscribes: z.number().optional(),
        timeseries: z
          .object({
            daily_stats: z
              .object({
                clicks: z
                  .array(
                    z.object({
                      date: z.string().optional(),
                      val: z.number().optional(),
                    }),
                  )
                  .optional(),
                unique_visits: z
                  .array(
                    z.object({
                      date: z.string().optional(),
                      val: z.number().optional(),
                    }),
                  )
                  .optional(),
                visits: z
                  .array(
                    z.object({
                      date: z.string().optional(),
                      val: z.number().optional(),
                    }),
                  )
                  .optional(),
              })
              .optional(),
            weekly_stats: z
              .object({
                clicks: z
                  .array(
                    z.object({
                      date: z.string().optional(),
                      val: z.number().optional(),
                    }),
                  )
                  .optional(),
                unique_visits: z
                  .array(
                    z.object({
                      date: z.string().optional(),
                      val: z.number().optional(),
                    }),
                  )
                  .optional(),
                visits: z
                  .array(
                    z.object({
                      date: z.string().optional(),
                      val: z.number().optional(),
                    }),
                  )
                  .optional(),
              })
              .optional(),
          })
          .optional(),
        title: z.string().optional(),
        unique_visits: z.number().optional(),
        unpublished_at: z.string().optional(),
        url: z.string().optional(),
        visits: z.number().optional(),
        web_id: z.number().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getReportingLandingPagesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportingLandingPagesIdDataSchema = z.object({
  path: z.object({
    outreach_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getReportingLandingPagesIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  clicks: z.number().optional(),
  conversion_rate: z.number().optional(),
  ecommerce: z
    .object({
      average_order_revenue: z.number().optional(),
      currency_code: z.string().optional(),
      total_orders: z.number().optional(),
      total_revenue: z.number().optional(),
    })
    .optional(),
  id: z.string().optional(),
  list_id: z.string().optional(),
  list_name: z.string().optional(),
  name: z.string().optional(),
  published_at: z.string().optional(),
  signup_tags: z
    .array(
      z.object({
        tag_id: z.number().optional(),
        tag_name: z.string().optional(),
      }),
    )
    .optional(),
  status: z.string().optional(),
  subscribes: z.number().optional(),
  timeseries: z
    .object({
      daily_stats: z
        .object({
          clicks: z
            .array(
              z.object({
                date: z.string().optional(),
                val: z.number().optional(),
              }),
            )
            .optional(),
          unique_visits: z
            .array(
              z.object({
                date: z.string().optional(),
                val: z.number().optional(),
              }),
            )
            .optional(),
          visits: z
            .array(
              z.object({
                date: z.string().optional(),
                val: z.number().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
      weekly_stats: z
        .object({
          clicks: z
            .array(
              z.object({
                date: z.string().optional(),
                val: z.number().optional(),
              }),
            )
            .optional(),
          unique_visits: z
            .array(
              z.object({
                date: z.string().optional(),
                val: z.number().optional(),
              }),
            )
            .optional(),
          visits: z
            .array(
              z.object({
                date: z.string().optional(),
                val: z.number().optional(),
              }),
            )
            .optional(),
        })
        .optional(),
    })
    .optional(),
  title: z.string().optional(),
  unique_visits: z.number().optional(),
  unpublished_at: z.string().optional(),
  url: z.string().optional(),
  visits: z.number().optional(),
  web_id: z.number().optional(),
});

export const getReportingLandingPagesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportingSurveysDataSchema = z.object({
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
    })
    .optional(),
});

export const getReportingSurveysResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  surveys: z
    .array(
      z.object({
        created_at: z.string().optional(),
        id: z.string().optional(),
        list_id: z.string().optional(),
        list_name: z.string().optional(),
        published_at: z.string().optional(),
        status: z.union([z.literal('published'), z.literal('unpublished')]).optional(),
        title: z.string().optional(),
        total_responses: z.number().optional(),
        updated_at: z.string().optional(),
        url: z.string().optional(),
        web_id: z.number().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getReportingSurveysErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportingSurveysIdDataSchema = z.object({
  path: z.object({
    outreach_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getReportingSurveysIdResponseSchema = z.object({
  created_at: z.string().optional(),
  id: z.string().optional(),
  list_id: z.string().optional(),
  list_name: z.string().optional(),
  published_at: z.string().optional(),
  status: z.union([z.literal('published'), z.literal('unpublished')]).optional(),
  title: z.string().optional(),
  total_responses: z.number().optional(),
  updated_at: z.string().optional(),
  url: z.string().optional(),
  web_id: z.number().optional(),
});

export const getReportingSurveysIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportingSurveysIdQuestionsDataSchema = z.object({
  path: z.object({
    outreach_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getReportingSurveysIdQuestionsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  questions: z
    .array(
      z.object({
        average_rating: z.number().optional(),
        contact_counts: z
          .object({
            known: z.number().optional(),
            new: z.number().optional(),
            unknown: z.number().optional(),
          })
          .optional(),
        has_other: z.boolean().optional(),
        id: z.string().optional(),
        is_required: z.boolean().optional(),
        merge_field: z
          .object({
            id: z.number().optional(),
            label: z.string().optional(),
            type: z
              .union([
                z.literal('text'),
                z.literal('number'),
                z.literal('address'),
                z.literal('phone'),
                z.literal('date'),
                z.literal('url'),
                z.literal('imageurl'),
                z.literal('radio'),
                z.literal('dropdown'),
                z.literal('birthday'),
                z.literal('zip'),
              ])
              .optional(),
          })
          .optional(),
        options: z
          .array(
            z.object({
              count: z.number().optional(),
              id: z.string().optional(),
              label: z.string().optional(),
            }),
          )
          .optional(),
        other_label: z.string().optional(),
        placeholder_label: z.string().optional(),
        query: z.string().optional(),
        range_high_label: z.string().optional(),
        range_low_label: z.string().optional(),
        subscribe_checkbox_enabled: z.boolean().optional(),
        subscribe_checkbox_label: z.string().optional(),
        survey_id: z.string().optional(),
        total_responses: z.number().optional(),
        type: z
          .union([
            z.literal('pickOne'),
            z.literal('pickMany'),
            z.literal('range'),
            z.literal('text'),
            z.literal('email'),
          ])
          .optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getReportingSurveysIdQuestionsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportingSurveysIdQuestionsIdDataSchema = z.object({
  path: z.object({
    outreach_id: z.string(),
    question_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getReportingSurveysIdQuestionsIdResponseSchema = z.object({
  average_rating: z.number().optional(),
  contact_counts: z
    .object({
      known: z.number().optional(),
      new: z.number().optional(),
      unknown: z.number().optional(),
    })
    .optional(),
  has_other: z.boolean().optional(),
  id: z.string().optional(),
  is_required: z.boolean().optional(),
  merge_field: z
    .object({
      id: z.number().optional(),
      label: z.string().optional(),
      type: z
        .union([
          z.literal('text'),
          z.literal('number'),
          z.literal('address'),
          z.literal('phone'),
          z.literal('date'),
          z.literal('url'),
          z.literal('imageurl'),
          z.literal('radio'),
          z.literal('dropdown'),
          z.literal('birthday'),
          z.literal('zip'),
        ])
        .optional(),
    })
    .optional(),
  options: z
    .array(
      z.object({
        count: z.number().optional(),
        id: z.string().optional(),
        label: z.string().optional(),
      }),
    )
    .optional(),
  other_label: z.string().optional(),
  placeholder_label: z.string().optional(),
  query: z.string().optional(),
  range_high_label: z.string().optional(),
  range_low_label: z.string().optional(),
  subscribe_checkbox_enabled: z.boolean().optional(),
  subscribe_checkbox_label: z.string().optional(),
  survey_id: z.string().optional(),
  total_responses: z.number().optional(),
  type: z
    .union([z.literal('pickOne'), z.literal('pickMany'), z.literal('range'), z.literal('text'), z.literal('email')])
    .optional(),
});

export const getReportingSurveysIdQuestionsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportingSurveysIdQuestionsIdAnswersDataSchema = z.object({
  path: z.object({
    outreach_id: z.string(),
    question_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      respondent_familiarity_is: z.union([z.literal('new'), z.literal('known'), z.literal('unknown')]).optional(),
    })
    .optional(),
});

export const getReportingSurveysIdQuestionsIdAnswersResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  answers: z
    .array(
      z.object({
        contact: z
          .object({
            avatar_url: z.string().optional(),
            consents_to_one_to_one_messaging: z.boolean().optional(),
            contact_id: z.string().optional(),
            email: z.string().optional(),
            email_id: z.string().optional(),
            full_name: z.string().optional(),
            status: z
              .union([
                z.literal('Subscribed'),
                z.literal('Unsubscribed'),
                z.literal('Non-Subscribed'),
                z.literal('Cleaned'),
                z.literal('Archived'),
              ])
              .optional(),
          })
          .optional(),
        id: z.string().optional(),
        is_new_contact: z.boolean().optional(),
        response_id: z.string().optional(),
        submitted_at: z.string().optional(),
        value: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getReportingSurveysIdQuestionsIdAnswersErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportingSurveysIdResponsesDataSchema = z.object({
  path: z.object({
    outreach_id: z.string(),
  }),
  query: z
    .object({
      answered_question: z.number().optional(),
      chose_answer: z.string().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      respondent_familiarity_is: z.union([z.literal('new'), z.literal('known'), z.literal('unknown')]).optional(),
    })
    .optional(),
});

export const getReportingSurveysIdResponsesResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  responses: z
    .array(
      z.object({
        contact: z
          .object({
            avatar_url: z.string().optional(),
            consents_to_one_to_one_messaging: z.boolean().optional(),
            contact_id: z.string().optional(),
            email: z.string().optional(),
            email_id: z.string().optional(),
            full_name: z.string().optional(),
            status: z
              .union([
                z.literal('Subscribed'),
                z.literal('Unsubscribed'),
                z.literal('Non-Subscribed'),
                z.literal('Cleaned'),
                z.literal('Archived'),
              ])
              .optional(),
          })
          .optional(),
        is_new_contact: z.boolean().optional(),
        response_id: z.string().optional(),
        submitted_at: z.string().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getReportingSurveysIdResponsesErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportingSurveysIdResponsesIdDataSchema = z.object({
  path: z.object({
    outreach_id: z.string(),
    response_id: z.string(),
  }),
});

export const getReportingSurveysIdResponsesIdResponseSchema = z.object({
  contact: z
    .object({
      avatar_url: z.string().optional(),
      consents_to_one_to_one_messaging: z.boolean().optional(),
      contact_id: z.string().optional(),
      email: z.string().optional(),
      email_id: z.string().optional(),
      full_name: z.string().optional(),
      status: z
        .union([
          z.literal('Subscribed'),
          z.literal('Unsubscribed'),
          z.literal('Non-Subscribed'),
          z.literal('Cleaned'),
          z.literal('Archived'),
        ])
        .optional(),
    })
    .optional(),
  is_new_contact: z.boolean().optional(),
  response_id: z.string().optional(),
  results: z
    .array(
      z.object({
        answer: z.string().optional(),
        query: z.string().optional(),
        question_id: z.string().optional(),
        question_type: z
          .union([
            z.literal('pickOne'),
            z.literal('pickMany'),
            z.literal('range'),
            z.literal('text'),
            z.literal('email'),
          ])
          .optional(),
      }),
    )
    .optional(),
  submitted_at: z.string().optional(),
});

export const getReportingSurveysIdResponsesIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportsDataSchema = z.object({
  query: z
    .object({
      before_send_time: z.string().optional(),
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
      since_send_time: z.string().optional(),
      type: z
        .union([
          z.literal('regular'),
          z.literal('plaintext'),
          z.literal('absplit'),
          z.literal('rss'),
          z.literal('variate'),
        ])
        .optional(),
    })
    .optional(),
});

export const getReportsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  reports: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        ab_split: z
          .object({
            a: z
              .object({
                abuse_reports: z.number().optional(),
                bounces: z.number().optional(),
                forwards: z.number().optional(),
                forwards_opens: z.number().optional(),
                last_open: z.string().optional(),
                opens: z.number().optional(),
                recipient_clicks: z.number().optional(),
                unique_opens: z.number().optional(),
                unsubs: z.number().optional(),
              })
              .optional(),
            b: z
              .object({
                abuse_reports: z.number().optional(),
                bounces: z.number().optional(),
                forwards: z.number().optional(),
                forwards_opens: z.number().optional(),
                last_open: z.string().optional(),
                opens: z.number().optional(),
                recipient_clicks: z.number().optional(),
                unique_opens: z.number().optional(),
                unsubs: z.number().optional(),
              })
              .optional(),
          })
          .optional(),
        abuse_reports: z.number().optional(),
        bounces: z
          .object({
            hard_bounces: z.number().optional(),
            soft_bounces: z.number().optional(),
            syntax_errors: z.number().optional(),
          })
          .optional(),
        campaign_title: z.string().optional(),
        clicks: z
          .object({
            click_rate: z.number().optional(),
            clicks_total: z.number().optional(),
            last_click: z.string().optional(),
            unique_clicks: z.number().optional(),
            unique_subscriber_clicks: z.number().optional(),
          })
          .optional(),
        delivery_status: z
          .object({
            can_cancel: z.boolean().optional(),
            emails_canceled: z.number().optional(),
            emails_sent: z.number().optional(),
            enabled: z.boolean().optional(),
            status: z
              .union([z.literal('delivering'), z.literal('delivered'), z.literal('canceling'), z.literal('canceled')])
              .optional(),
          })
          .optional(),
        ecommerce: z
          .object({
            currency_code: z.string().optional(),
            total_orders: z.number().optional(),
            total_revenue: z.number().optional(),
            total_spent: z.number().optional(),
          })
          .optional(),
        emails_sent: z.number().optional(),
        facebook_likes: z
          .object({
            facebook_likes: z.number().optional(),
            recipient_likes: z.number().optional(),
            unique_likes: z.number().optional(),
          })
          .optional(),
        forwards: z
          .object({
            forwards_count: z.number().optional(),
            forwards_opens: z.number().optional(),
          })
          .optional(),
        id: z.string().optional(),
        industry_stats: z
          .object({
            abuse_rate: z.number().optional(),
            bounce_rate: z.number().optional(),
            click_rate: z.number().optional(),
            open_rate: z.number().optional(),
            type: z.string().optional(),
            unopen_rate: z.number().optional(),
            unsub_rate: z.number().optional(),
          })
          .optional(),
        list_id: z.string().optional(),
        list_is_active: z.boolean().optional(),
        list_name: z.string().optional(),
        list_stats: z
          .object({
            click_rate: z.number().optional(),
            open_rate: z.number().optional(),
            sub_rate: z.number().optional(),
            unsub_rate: z.number().optional(),
          })
          .optional(),
        opens: z
          .object({
            last_open: z.string().optional(),
            open_rate: z.number().optional(),
            opens_total: z.number().optional(),
            unique_opens: z.number().optional(),
          })
          .optional(),
        preview_text: z.string().optional(),
        rss_last_send: z.string().optional(),
        send_time: z.string().optional(),
        share_report: z
          .object({
            share_password: z.string().optional(),
            share_url: z.string().optional(),
          })
          .optional(),
        subject_line: z.string().optional(),
        timeseries: z
          .array(
            z.object({
              emails_sent: z.number().optional(),
              recipients_clicks: z.number().optional(),
              timestamp: z.string().optional(),
              unique_opens: z.number().optional(),
            }),
          )
          .optional(),
        timewarp: z
          .array(
            z.object({
              bounces: z.number().optional(),
              clicks: z.number().optional(),
              gmt_offset: z.number().optional(),
              last_click: z.string().optional(),
              last_open: z.string().optional(),
              opens: z.number().optional(),
              unique_clicks: z.number().optional(),
              unique_opens: z.number().optional(),
            }),
          )
          .optional(),
        type: z.string().optional(),
        unsubscribed: z.number().optional(),
      }),
    )
    .optional(),
  total_items: z.number().optional(),
});

export const getReportsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportsIdDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getReportsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  ab_split: z
    .object({
      a: z
        .object({
          abuse_reports: z.number().optional(),
          bounces: z.number().optional(),
          forwards: z.number().optional(),
          forwards_opens: z.number().optional(),
          last_open: z.string().optional(),
          opens: z.number().optional(),
          recipient_clicks: z.number().optional(),
          unique_opens: z.number().optional(),
          unsubs: z.number().optional(),
        })
        .optional(),
      b: z
        .object({
          abuse_reports: z.number().optional(),
          bounces: z.number().optional(),
          forwards: z.number().optional(),
          forwards_opens: z.number().optional(),
          last_open: z.string().optional(),
          opens: z.number().optional(),
          recipient_clicks: z.number().optional(),
          unique_opens: z.number().optional(),
          unsubs: z.number().optional(),
        })
        .optional(),
    })
    .optional(),
  abuse_reports: z.number().optional(),
  bounces: z
    .object({
      hard_bounces: z.number().optional(),
      soft_bounces: z.number().optional(),
      syntax_errors: z.number().optional(),
    })
    .optional(),
  campaign_title: z.string().optional(),
  clicks: z
    .object({
      click_rate: z.number().optional(),
      clicks_total: z.number().optional(),
      last_click: z.string().optional(),
      unique_clicks: z.number().optional(),
      unique_subscriber_clicks: z.number().optional(),
    })
    .optional(),
  delivery_status: z
    .object({
      can_cancel: z.boolean().optional(),
      emails_canceled: z.number().optional(),
      emails_sent: z.number().optional(),
      enabled: z.boolean().optional(),
      status: z
        .union([z.literal('delivering'), z.literal('delivered'), z.literal('canceling'), z.literal('canceled')])
        .optional(),
    })
    .optional(),
  ecommerce: z
    .object({
      currency_code: z.string().optional(),
      total_orders: z.number().optional(),
      total_revenue: z.number().optional(),
      total_spent: z.number().optional(),
    })
    .optional(),
  emails_sent: z.number().optional(),
  facebook_likes: z
    .object({
      facebook_likes: z.number().optional(),
      recipient_likes: z.number().optional(),
      unique_likes: z.number().optional(),
    })
    .optional(),
  forwards: z
    .object({
      forwards_count: z.number().optional(),
      forwards_opens: z.number().optional(),
    })
    .optional(),
  id: z.string().optional(),
  industry_stats: z
    .object({
      abuse_rate: z.number().optional(),
      bounce_rate: z.number().optional(),
      click_rate: z.number().optional(),
      open_rate: z.number().optional(),
      type: z.string().optional(),
      unopen_rate: z.number().optional(),
      unsub_rate: z.number().optional(),
    })
    .optional(),
  list_id: z.string().optional(),
  list_is_active: z.boolean().optional(),
  list_name: z.string().optional(),
  list_stats: z
    .object({
      click_rate: z.number().optional(),
      open_rate: z.number().optional(),
      sub_rate: z.number().optional(),
      unsub_rate: z.number().optional(),
    })
    .optional(),
  opens: z
    .object({
      last_open: z.string().optional(),
      open_rate: z.number().optional(),
      opens_total: z.number().optional(),
      unique_opens: z.number().optional(),
    })
    .optional(),
  preview_text: z.string().optional(),
  rss_last_send: z.string().optional(),
  send_time: z.string().optional(),
  share_report: z
    .object({
      share_password: z.string().optional(),
      share_url: z.string().optional(),
    })
    .optional(),
  subject_line: z.string().optional(),
  timeseries: z
    .array(
      z.object({
        emails_sent: z.number().optional(),
        recipients_clicks: z.number().optional(),
        timestamp: z.string().optional(),
        unique_opens: z.number().optional(),
      }),
    )
    .optional(),
  timewarp: z
    .array(
      z.object({
        bounces: z.number().optional(),
        clicks: z.number().optional(),
        gmt_offset: z.number().optional(),
        last_click: z.string().optional(),
        last_open: z.string().optional(),
        opens: z.number().optional(),
        unique_clicks: z.number().optional(),
        unique_opens: z.number().optional(),
      }),
    )
    .optional(),
  type: z.string().optional(),
  unsubscribed: z.number().optional(),
});

export const getReportsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportsIdAbuseReportsIdDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getReportsIdAbuseReportsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  abuse_reports: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        campaign_id: z.string().optional(),
        date: z.string().optional(),
        email_address: z.string().optional(),
        email_id: z.string().optional(),
        id: z.number().optional(),
        list_id: z.string().optional(),
        list_is_active: z.boolean().optional(),
        merge_fields: z.record(z.unknown()).optional(),
        vip: z.boolean().optional(),
      }),
    )
    .optional(),
  campaign_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getReportsIdAbuseReportsIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportsIdAbuseReportsIdIdDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
    report_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getReportsIdAbuseReportsIdIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  campaign_id: z.string().optional(),
  date: z.string().optional(),
  email_address: z.string().optional(),
  email_id: z.string().optional(),
  id: z.number().optional(),
  list_id: z.string().optional(),
  list_is_active: z.boolean().optional(),
  merge_fields: z.record(z.unknown()).optional(),
  vip: z.boolean().optional(),
});

export const getReportsIdAbuseReportsIdIdErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportsIdAdviceDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getReportsIdAdviceResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  advice: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        message: z.string().optional(),
        type: z.union([z.literal('negative'), z.literal('positive'), z.literal('neutral')]).optional(),
      }),
    )
    .optional(),
  campaign_id: z.string().optional(),
  total_items: z.number().optional(),
});

export const getReportsIdAdviceErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportsIdClickDetailsDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
  }),
  query: z
    .object({
      count: z.number().optional(),
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
      offset: z.number().optional(),
      sort_dir: z.union([z.literal('ASC'), z.literal('DESC')]).optional(),
      sort_field: z.union([z.literal('total_clicks'), z.literal('unique_clicks')]).optional(),
    })
    .optional(),
});

export const getReportsIdClickDetailsResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  campaign_id: z.string().optional(),
  total_items: z.number().optional(),
  urls_clicked: z
    .array(
      z.object({
        _links: z
          .array(
            z.object({
              href: z.string().optional(),
              method: z
                .union([
                  z.literal('GET'),
                  z.literal('POST'),
                  z.literal('PUT'),
                  z.literal('PATCH'),
                  z.literal('DELETE'),
                  z.literal('OPTIONS'),
                  z.literal('HEAD'),
                ])
                .optional(),
              rel: z.string().optional(),
              schema: z.string().optional(),
              targetSchema: z.string().optional(),
            }),
          )
          .optional(),
        ab_split: z
          .object({
            a: z
              .object({
                click_percentage_a: z.number().optional(),
                total_clicks_a: z.number().optional(),
                unique_click_percentage_a: z.number().optional(),
                unique_clicks_a: z.number().optional(),
              })
              .optional(),
            b: z
              .object({
                click_percentage_b: z.number().optional(),
                total_clicks_b: z.number().optional(),
                unique_click_percentage_b: z.number().optional(),
                unique_clicks_b: z.number().optional(),
              })
              .optional(),
          })
          .optional(),
        campaign_id: z.string().optional(),
        click_percentage: z.number().optional(),
        id: z.string().optional(),
        last_click: z.string().optional(),
        total_clicks: z.number().optional(),
        unique_click_percentage: z.number().optional(),
        unique_clicks: z.number().optional(),
        url: z.string().optional(),
      }),
    )
    .optional(),
});

export const getReportsIdClickDetailsErrorSchema = z.object({
  detail: z.string(),
  instance: z.string(),
  status: z.number(),
  title: z.string(),
  type: z.string(),
});

export const getReportsIdClickDetailsIdDataSchema = z.object({
  path: z.object({
    campaign_id: z.string(),
    link_id: z.string(),
  }),
  query: z
    .object({
      exclude_fields: z.array(z.string()).optional(),
      fields: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getReportsIdClickDetailsIdResponseSchema = z.object({
  _links: z
    .array(
      z.object({
        href: z.string().optional(),
        method: z
          .union([
            z.literal('GET'),
            z.literal('POST'),
            z.literal('PUT'),
            z.literal('PATCH'),
            z.literal('DELETE'),
            z.literal('OPTIONS'),
            z.literal('HEAD'),
          ])
          .optional(),
        rel: z.string().optional(),
        schema: z.string().optional(),
        targetSchema: z.string().optional(),
      }),
    )
    .optional(),
  ab_split: z
    .object({
      a: z
        .object({
          click_percentage_a: z.number().optional(),
          total_clicks_a: z.number().optional(),
          unique_click_percenta