// This file is auto-generated by @hey-api/openapi-ts

export type GetRootData = {
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetRootResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The Mailchimp account ID.
   */
  readonly account_id?: string;
  /**
   * The user-specified industry associated with the account.
   */
  readonly account_industry?: string;
  /**
   * The name of the account.
   */
  readonly account_name?: string;
  /**
   * The timezone currently set for the account.
   */
  readonly account_timezone?: string;
  /**
   * URL of the avatar for the user.
   */
  readonly avatar_url?: string;
  /**
   * Information about the account contact.
   */
  readonly contact?: {
    /**
     * The street address for the account contact.
     */
    readonly addr1?: string;
    /**
     * The street address for the account contact.
     */
    readonly addr2?: string;
    /**
     * The city for the account contact.
     */
    readonly city?: string;
    /**
     * The company name for the account.
     */
    readonly company?: string;
    /**
     * The country for the account contact.
     */
    readonly country?: string;
    /**
     * The state for the account contact.
     */
    readonly state?: string;
    /**
     * The zip code for the account contact.
     */
    readonly zip?: string;
  };
  /**
   * The account email address.
   */
  readonly email?: string;
  /**
   * The first name tied to the account.
   */
  readonly first_name?: string;
  /**
   * Date of first payment for monthly plans.
   */
  readonly first_payment?: string;
  /**
   * The [average campaign statistics](https://mailchimp.com/resources/research/email-marketing-benchmarks/?utm_source=mc-api&utm_medium=docs&utm_campaign=apidocs) for all campaigns in the account's specified industry.
   */
  readonly industry_stats?: {
    /**
     * The average bounce rate for all campaigns in the account's specified industry.
     */
    readonly bounce_rate?: number;
    /**
     * The average unique click rate for all campaigns in the account's specified industry.
     */
    readonly click_rate?: number;
    /**
     * The average unique open rate for all campaigns in the account's specified industry.
     */
    readonly open_rate?: number;
  };
  /**
   * The date and time of the last login for this account in ISO 8601 format.
   */
  readonly last_login?: string;
  /**
   * The last name tied to the account.
   */
  readonly last_name?: string;
  /**
   * The ID associated with the user who owns this API key. If you can login to multiple accounts, this ID will be the same for each account.
   */
  readonly login_id?: string;
  /**
   * The date and time that the account was created in ISO 8601 format.
   */
  readonly member_since?: string;
  /**
   * The type of pricing plan the account is on.
   */
  readonly pricing_plan_type?: 'monthly' | 'pay_as_you_go' | 'forever_free';
  /**
   * Legacy - whether the account includes [Mailchimp Pro](https://mailchimp.com/help/about-mailchimp-pro/).
   */
  readonly pro_enabled?: boolean;
  /**
   * The [user role](https://mailchimp.com/help/manage-user-levels-in-your-account/) for the account.
   */
  readonly role?: string;
  /**
   * The total number of subscribers across all lists in the account.
   */
  readonly total_subscribers?: number;
  /**
   * The username tied to the account.
   */
  readonly username?: string;
};

export type GetRootError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetAccountExportsData = {
  query?: {
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
  };
};

export type GetAccountExportsResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of objects, each representing an account export.
   */
  exports?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * If the export is finished, the download URL for an export. URLs are only valid for 90 days after the export completes.
     */
    download_url?: string;
    /**
     * The ID for the export.
     */
    export_id?: number;
    /**
     * If finished, the finish time for the export.
     */
    finished?: string;
    /**
     * The size of the uncompressed export in bytes.
     */
    size_in_bytes?: number;
    /**
     * Start time for the export.
     */
    started?: string;
  }>;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetAccountExportsError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostAccountExportData = {
  body: {
    /**
     * The stages of an account export to include.
     */
    include_stages: Array<'audiences' | 'campaigns' | 'events' | 'gallery_files' | 'reports' | 'templates'>;
    /**
     * An ISO 8601 date that will limit the export to only records created after a given time. For instance, the reports stage will contain any campaign sent after the given timestamp. Audiences, however, are excluded from this limit.
     */
    since_timestamp?: string;
  };
};

export type PostAccountExportResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * If the export is finished, the download URL for an export. URLs are only valid for 90 days after the export completes.
   */
  download_url?: string;
  /**
   * The ID for the export.
   */
  export_id?: number;
  /**
   * If finished, the finish time for the export.
   */
  finished?: string;
  /**
   * The size of the uncompressed export in bytes.
   */
  size_in_bytes?: number;
  /**
   * Start time for the export.
   */
  started?: string;
};

export type PostAccountExportError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetAccountExportIdData = {
  path: {
    /**
     * The unique id for the account export.
     */
    export_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetAccountExportIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * If the export is finished, the download URL for an export. URLs are only valid for 90 days after the export completes.
   */
  download_url?: string;
  /**
   * The ID for the export.
   */
  export_id?: number;
  /**
   * If finished, the finish time for the export.
   */
  finished?: string;
  /**
   * The size of the uncompressed export in bytes.
   */
  size_in_bytes?: number;
  /**
   * Start time for the export.
   */
  started?: string;
};

export type GetAccountExportIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetActivityFeedChimpChatterData = {
  query?: {
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
  };
};

export type GetActivityFeedChimpChatterResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of Chimp Chatter messages. There's a maximum of 200 messages present for an account.
   */
  readonly chimp_chatter?: Array<{
    /**
     * If it exists, campaign ID for the associated campaign
     */
    readonly campaign_id?: string;
    /**
     * If it exists, list ID for the associated list
     */
    readonly list_id?: string;
    readonly message?: string;
    readonly title?: string;
    /**
     * The type of activity
     */
    readonly type?:
      | 'lists:new-subscriber'
      | 'lists:unsubscribes'
      | 'lists:profile-updates'
      | 'campaigns:facebook-likes'
      | 'campaigns:forward-to-friend'
      | 'lists:imports';
    /**
     * The date and time this activity was updated.
     */
    readonly update_time?: string;
    /**
     * URL to a report that includes this activity
     */
    readonly url?: string;
  }>;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetActivityFeedChimpChatterError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetAuthorizedAppsData = {
  query?: {
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
  };
};

export type GetAuthorizedAppsResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of objects, each representing an authorized application.
   */
  apps?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * A short description of the application.
     */
    description?: string;
    /**
     * The ID for the application.
     */
    id?: number;
    /**
     * The name of the application.
     */
    name?: string;
    /**
     * An array of usernames for users who have linked the app.
     */
    users?: Array<string>;
  }>;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetAuthorizedAppsError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetAuthorizedAppsIdData = {
  path: {
    /**
     * The unique id for the connected authorized application.
     */
    app_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetAuthorizedAppsIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * A short description of the application.
   */
  description?: string;
  /**
   * The ID for the application.
   */
  id?: number;
  /**
   * The name of the application.
   */
  name?: string;
  /**
   * An array of usernames for users who have linked the app.
   */
  users?: Array<string>;
};

export type GetAuthorizedAppsIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetAutomationsData = {
  query?: {
    /**
     * Restrict the response to automations created before this time. Uses the ISO 8601 time format: 2015-10-21T15:41:36+00:00.
     */
    before_create_time?: string;
    /**
     * Restrict the response to automations started before this time. Uses the ISO 8601 time format: 2015-10-21T15:41:36+00:00.
     */
    before_start_time?: string;
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
    /**
     * Restrict the response to automations created after this time. Uses the ISO 8601 time format: 2015-10-21T15:41:36+00:00.
     */
    since_create_time?: string;
    /**
     * Restrict the response to automations started after this time. Uses the ISO 8601 time format: 2015-10-21T15:41:36+00:00.
     */
    since_start_time?: string;
    /**
     * Restrict the results to automations with the specified status.
     */
    status?: 'save' | 'paused' | 'sending';
  };
};

export type GetAutomationsResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of objects, each representing an Automation workflow.
   */
  automations?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The date and time the Automation was created in ISO 8601 format.
     */
    readonly create_time?: string;
    /**
     * The total number of emails sent for the Automation.
     */
    readonly emails_sent?: number;
    /**
     * A string that identifies the Automation.
     */
    readonly id?: string;
    /**
     * List settings for the Automation.
     */
    recipients?: {
      /**
       * The unique list id.
       */
      list_id?: string;
      /**
       * The status of the list used, namely if it's deleted or disabled.
       */
      readonly list_is_active?: boolean;
      /**
       * List Name.
       */
      list_name?: string;
      /**
       * An object representing all segmentation options.
       */
      segment_opts?: {
        /**
         * Segment match conditions. There are multiple possible types, see the [condition types documentation](https://mailchimp.com/developer/marketing/docs/alternative-schemas/#segment-condition-schemas).
         */
        conditions?: Array<
          | {
              condition_type?: 'Aim';
              /**
               * Segment by interaction with a specific campaign.
               */
              field?: 'aim';
              /**
               * The status of the member with regard to their campaign interaction. One of the following: opened, clicked, was sent, didn't open, didn't click, or was not sent.
               */
              op?: 'open' | 'click' | 'sent' | 'noopen' | 'noclick' | 'nosent';
              /**
               * Either the web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
               */
              value?: string;
            }
          | {
              condition_type?: 'Automation';
              /**
               * Segment by interaction with an Automation workflow.
               */
              field: 'automation';
              /**
               * The status of the member with regard to the automation workflow. One of the following: has started the workflow, has completed the workflow, has not started the workflow, or has not completed the workflow.
               */
              op: 'started' | 'completed' | 'not_started' | 'not_completed';
              /**
               * The web id for the automation workflow to segment against.
               */
              value: string;
            }
          | {
              condition_type?: 'CampaignPoll';
              /**
               * Segment by poll activity.
               */
              field: 'poll';
              /**
               * Members have/have not interacted with a specific poll in a Mailchimp email.
               */
              op: 'member' | 'notmember';
              /**
               * The id for the poll.
               */
              value: number;
            }
          | {
              condition_type?: 'Conversation';
              /**
               * Segment by interaction with a campaign via Conversations.
               */
              field: 'conversation';
              /**
               * The status of a member's interaction with a conversation. One of the following: has replied or has not replied.
               */
              op: 'member' | 'notmember';
              /**
               * The web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
               */
              value: string;
            }
          | {
              condition_type?: 'Date';
              /**
               * When segmenting on 'date' or 'campaign', the date for the segment formatted as YYYY-MM-DD or the web id for the campaign.
               */
              extra?: string;
              /**
               * The type of date field to segment on: The opt-in time for a signup, the date the subscriber was last updated, or the date of their last ecomm purchase.
               */
              field: 'timestamp_opt' | 'info_changed' | 'ecomm_date';
              /**
               * When the event took place:  Before, after, is a specific date, is not a specific date, is blank, or is not blank.
               */
              op: 'greater' | 'less' | 'is' | 'not' | 'blank' | 'blank_not' | 'within' | 'notwithin';
              /**
               * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
               */
              value: string;
            }
          | {
              condition_type?: 'EmailClient';
              /**
               * Segment by use of a particular email client.
               */
              field: 'email_client';
              /**
               * The operation to determine whether we select clients that match the value, or clients that do not match the value.
               */
              op: 'client_is' | 'client_not';
              /**
               * The name of the email client.
               */
              value: string;
            }
          | {
              condition_type?: 'Language';
              /**
               * Segmenting based off of a subscriber's language.
               */
              field: 'language';
              /**
               * Whether the member's language is or is not set to a specific language.
               */
              op: 'is' | 'not';
              /**
               * A two-letter language identifier.
               */
              value: string;
            }
          | {
              condition_type?: 'MemberRating';
              /**
               * Segment by member rating.
               */
              field: 'rating';
              /**
               * Members who have have a rating that is/not exactly a given number or members who have a rating greater/less than a given number.
               */
              op: 'is' | 'not' | 'greater' | 'less';
              /**
               * The star rating number to segment against.
               */
              value: number;
            }
          | {
              condition_type: 'SignupSource';
              field: 'source';
              /**
               * Whether the member's signup source was/was not a particular value.
               */
              op: 'source_is' | 'source_not';
              /**
               * The signup source.
               */
              value?: string;
            }
          | {
              condition_type?: 'SurveyMonkey';
              /**
               * Segment by interaction with a SurveyMonkey survey.
               */
              field: 'survey_monkey';
              /**
               * The status of the member with regard to the survey.One of the following: has started the survey, has completed the survey, has not started the survey, or has not completed the survey.
               */
              op: 'started' | 'completed' | 'not_started' | 'not_completed';
              /**
               * The unique ID of the survey monkey survey.
               */
              value: string;
            }
          | {
              condition_type?: 'VIP';
              /**
               * Segment by VIP status.
               */
              field: 'gmonkey';
              /**
               * Whether the member is or is not marked as VIP.
               */
              op: 'member' | 'notmember';
            }
          | {
              condition_type?: 'Interests';
              /**
               * Segmenting based on interest group information. This should start with 'interests-' followed by the grouping id. Ex. 'interests-123'.
               */
              field?: string;
              /**
               * Whether the member is a part of one, all, or none of the groups.
               */
              op?: 'interestcontains' | 'interestcontainsall' | 'interestnotcontains';
              /**
               * An array containing strings, each representing a group id.
               */
              value?: Array<string>;
            }
          | {
              condition_type?: 'EcommCategory';
              /**
               * Segment by purchases in specific items or categories.
               */
              field?: 'ecomm_cat' | 'ecomm_prod';
              /**
               * A member who has purchased from a category/specific item that is/is not a specific name, where the category/item name contains/doesn't contain a specific phrase or string, or a category/item name that starts/ends with a string.
               */
              op?: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends';
              /**
               * The ecommerce category/item information.
               */
              value?: string;
            }
          | {
              condition_type?: 'EcommNumber';
              /**
               * Segment by average spent total, number of orders, total number of products purchased, or average number of products per order.
               */
              field: 'ecomm_spent_avg' | 'ecomm_orders' | 'ecomm_prod_all' | 'ecomm_avg_ord';
              /**
               * Members who have spent exactly, have not spent exactly, spent more, or spent less than the segment value.
               */
              op: 'is' | 'not' | 'greater' | 'less';
              /**
               * Members who have spent exactly, have not spent exactly, spent more, or spent less than this amount.
               */
              value: number;
            }
          | {
              condition_type?: 'EcommPurchased';
              /**
               * Segment by whether someone has purchased anything.
               */
              field?: 'ecomm_purchased';
              /**
               * Members who have have ('member') or have not ('notmember') purchased.
               */
              op?: 'member' | 'notmember';
            }
          | {
              condition_type?: 'EcommSpent';
              /**
               * Segment by amount spent on a single order or across all orders.
               */
              field?: 'ecomm_spent_one' | 'ecomm_spent_all';
              /**
               * Members who have spent 'more' or 'less' than then specified value.
               */
              op?: 'greater' | 'less';
              /**
               * The total amount a member spent.
               */
              value?: number;
            }
          | {
              condition_type?: 'EcommStore';
              /**
               * Segment by purchases from a specific store.
               */
              field?: 'ecomm_store';
              /**
               * Members who have or have not purchased from a specific store.
               */
              op?: 'is' | 'not';
              /**
               * The store id to segment against.
               */
              value?: string;
            }
          | {
              condition_type?: 'GoalActivity';
              /**
               * Segment by Goal activity.
               */
              field: 'goal';
              /**
               * Whether the website URL is/not exactly, contains/doesn't contain, starts with/ends with a string.
               */
              op: 'is' | 'goal_not' | 'contains' | 'goal_notcontain' | 'starts' | 'ends';
              /**
               * The URL to check Goal activity against.
               */
              value: string;
            }
          | {
              condition_type?: 'GoalTimestamp';
              /**
               * Segment by most recent interaction with a website.
               */
              field: 'goal_last_visited';
              /**
               * Whether the website activity happened after, before, or at a given timestamp.
               */
              op: 'greater' | 'less' | 'is';
              /**
               * The date to check Goal activity against.
               */
              value: string;
            }
          | {
              condition_type?: 'FuzzySegment';
              /**
               * Segment by similar subscribers.
               */
              field: 'fuzzy_segment';
              /**
               * Members who are/are not apart of a 'similar subscribers' segment.
               */
              op: 'fuzzy_is' | 'fuzzy_not';
              /**
               * The id for the 'similar subscribers' segment.
               */
              value: number;
            }
          | {
              condition_type?: 'StaticSegment';
              /**
               * Segment by a given static segment.
               */
              field: 'static_segment';
              /**
               * Members who are/are not apart of a static segment.
               */
              op: 'static_is' | 'static_not';
              /**
               * The id for the static segment.
               */
              value: number;
            }
          | {
              condition_type?: 'IPGeoCountryState';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members who are within a specific country or US state.
               */
              op: 'ipgeocountry' | 'ipgeonotcountry' | 'ipgeostate' | 'ipgeonotstate';
              /**
               * The two-letter country code or US state abbreviation.
               */
              value: string;
            }
          | {
              /**
               * The address of the target location.
               */
              addr: string;
              condition_type?: 'IPGeoIn';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * The latitude of the target location.
               */
              lat: string;
              /**
               * The longitude of the target location.
               */
              lng: string;
              /**
               * Segment members who are within a specific geographic region.
               */
              op: 'ipgeoin' | 'ipgeonotin';
              /**
               * The radius of the target location.
               */
              value: number;
            }
          | {
              condition_type?: 'IPGeoInZip';
              /**
               * The zip code to segment against.
               */
              extra: number;
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members who are within a specific US zip code.
               */
              op: 'ipgeoinzip';
              /**
               * The radius of the target location.
               */
              value: number;
            }
          | {
              condition_type?: 'IPGeoUnknown';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members for which location information is unknown.
               */
              op: 'ipgeounknown';
            }
          | {
              condition_type?: 'IPGeoZip';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members who are/are not within a specific US zip code.
               */
              op: 'ipgeoiszip' | 'ipgeonotzip';
              /**
               * The 5-digit zip code.
               */
              value: number;
            }
          | {
              condition_type?: 'SocialAge';
              /**
               * Segment by age ranges in Social Profiles data.
               */
              field: 'social_age';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is' | 'not';
              /**
               * The age range to segment.
               */
              value: '18-24' | '25-34' | '35-54' | '55+';
            }
          | {
              condition_type?: 'SocialGender';
              /**
               * Segment by listed gender in Social Profiles data.
               */
              field: 'social_gender';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is' | 'not';
              /**
               * The Social Profiles gender to segment.
               */
              value: 'male' | 'female';
            }
          | {
              condition_type?: 'SocialInfluence';
              /**
               * Segment by influence rating in Social Profiles data.
               */
              field: 'social_influence';
              /**
               * Members who have a rating that is/not or greater/less than the rating provided.
               */
              op: 'is' | 'not' | 'greater' | 'less';
              /**
               * The Social Profiles influence rating to segment.
               */
              value: number;
            }
          | {
              condition_type?: 'SocialNetworkMember';
              /**
               * Segment by social network in Social Profiles data.
               */
              field: 'social_network';
              /**
               * Members who are/not on a given social network.
               */
              op: 'member' | 'notmember';
              /**
               * The social network to segment against.
               */
              value:
                | 'twitter'
                | 'facebook'
                | 'linkedin'
                | 'flickr'
                | 'foursquare'
                | 'lastfm'
                | 'myspace'
                | 'quora'
                | 'vimeo'
                | 'yelp'
                | 'youtube';
            }
          | {
              condition_type?: 'SocialNetworkFollow';
              /**
               * Segment by social network in Social Profiles data.
               */
              field: 'social_network';
              /**
               * Members who are/not following a linked account on a given social network.
               */
              op: 'follow' | 'notfollow';
              /**
               * The social network to segment against.
               */
              value: 'twitter_follow';
            }
          | {
              condition_type?: 'AddressMerge';
              /**
               * An address-type merge field to segment.
               */
              field: string;
              /**
               * Whether the member's address merge field contains/does not contain a value or is/is not blank.
               */
              op: 'contains' | 'notcontain' | 'blank' | 'blank_not';
              /**
               * The value to segment a text merge field with.
               */
              value?: string;
            }
          | {
              condition_type?: 'ZipMerge';
              /**
               * The city or the zip being used to segment against.
               */
              extra: string;
              /**
               * An address or zip-type merge field to segment.
               */
              field: string;
              /**
               * Whether the member's address merge field is within a given distance from a city or zip.
               */
              op: 'geoin';
              /**
               * The distance from the city/zip.
               */
              value: string;
            }
          | {
              condition_type?: 'BirthdayMerge';
              /**
               * A date merge field to segment.
               */
              field: string;
              /**
               * Whether the member's birthday merge information is/is not a certain date or is/is not blank.
               */
              op: 'is' | 'not' | 'blank' | 'blank_not';
              /**
               * A date to segment against (mm/dd).
               */
              value?: string;
            }
          | {
              condition_type?: 'DateMerge';
              /**
               * A date merge field to segment.
               */
              field: string;
              /**
               * Whether the member's merge information is/is not, is greater/less than a value or is/is not blank.
               */
              op: 'is' | 'not' | 'less' | 'blank' | 'blank_not' | 'greater';
              /**
               * A date to segment against.
               */
              value?: string;
            }
          | {
              condition_type?: 'SelectMerge';
              /**
               * A merge field to segment.
               */
              field: string;
              /**
               * Whether the member's merge information is/is not a value or is/is not blank.
               */
              op: 'is' | 'not' | 'blank' | 'blank_not' | 'notcontain' | 'contains';
              /**
               * The value to segment a text merge field with.
               */
              value?: string;
            }
          | {
              condition_type?: 'TextMerge';
              /**
               * A text or number merge field to segment.
               */
              field: string;
              /**
               * Whether the member's merge information is/is not, contains/does not contain, starts/ends with, or is greater/less than a value
               */
              op:
                | 'is'
                | 'not'
                | 'contains'
                | 'notcontain'
                | 'starts'
                | 'ends'
                | 'greater'
                | 'less'
                | 'blank'
                | 'blank_not';
              /**
               * The value to segment a text or number merge field with.
               */
              value?: string;
            }
          | {
              condition_type?: 'EmailAddress';
              /**
               * Segmenting based off of a subscriber's email address.
               */
              field: 'merge0' | 'EMAIL';
              /**
               * Whether the email address is/not exactly, contains/doesn't contain, starts/ends with a string.
               */
              op: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends' | 'greater' | 'less';
              /**
               * The value to compare the email against.
               */
              value?: string;
            }
          | {
              condition_type?: 'PredictedGender';
              /**
               * Segment by predicted gender.
               */
              field: 'predicted_gender';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is' | 'not';
              /**
               * The predicted gender to segment.
               */
              value: 'male' | 'female';
            }
          | {
              condition_type?: 'PredictedAge';
              /**
               * Segment by predicted age.
               */
              field: 'predicted_age_range';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is';
              /**
               * The predicted age to segment.
               */
              value: '18-24' | '25-34' | '35-44' | '45-54' | '55-64' | '65+';
            }
          | {
              condition_type?: 'NewSubscribers';
              /**
               * Segment by when people subscribed.
               */
              field?: 'timestamp_opt';
              /**
               * Whe the event took place, namely within a time frame.
               */
              op?: 'date_within';
              /**
               * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
               */
              value?: string;
            }
        >;
        /**
         * Segment match type.
         */
        match?: 'any' | 'all';
        /**
         * The id for an existing saved segment.
         */
        saved_segment_id?: number;
      };
      /**
       * The id of the store.
       */
      store_id?: string;
    };
    /**
     * A summary of opens and clicks for sent campaigns.
     */
    report_summary?: {
      /**
       * The number of unique clicks, divided by the total number of successful deliveries.
       */
      readonly click_rate?: number;
      /**
       * The total number of clicks for an campaign.
       */
      readonly clicks?: number;
      /**
       * The number of unique opens divided by the total number of successful deliveries.
       */
      readonly open_rate?: number;
      /**
       * The total number of opens for a campaign.
       */
      readonly opens?: number;
      /**
       * The number of unique clicks.
       */
      readonly subscriber_clicks?: number;
      /**
       * The number of unique opens.
       */
      readonly unique_opens?: number;
    };
    /**
     * The settings for the Automation workflow.
     */
    settings?: {
      /**
       * Whether Mailchimp [authenticated](https://mailchimp.com/help/about-email-authentication/) the Automation. Defaults to `true`.
       */
      authenticate?: boolean;
      /**
       * Whether to automatically append Mailchimp's [default footer](https://mailchimp.com/help/about-campaign-footers/) to the Automation.
       */
      auto_footer?: boolean;
      /**
       * The 'from' name for the Automation (not an email address).
       */
      from_name?: string;
      /**
       * Whether to automatically inline the CSS included with the Automation content.
       */
      inline_css?: boolean;
      /**
       * The reply-to email address for the Automation.
       */
      reply_to?: string;
      /**
       * The title of the Automation.
       */
      title?: string;
      /**
       * The Automation's custom 'To' name, typically the first name [audience field](https://mailchimp.com/help/getting-started-with-merge-tags/).
       */
      to_name?: string;
      /**
       * Whether to use Mailchimp Conversation feature to manage replies
       */
      use_conversation?: boolean;
    };
    /**
     * The date and time the Automation was started in ISO 8601 format.
     */
    readonly start_time?: string;
    /**
     * The current status of the Automation.
     */
    readonly status?: 'save' | 'paused' | 'sending';
    /**
     * The tracking options for the Automation.
     */
    tracking?: {
      /**
       * Deprecated
       */
      capsule?: {
        /**
         * Update contact notes for a campaign based on a subscriber's email addresses.
         */
        notes?: boolean;
      };
      /**
       * The custom slug for [ClickTale](https://mailchimp.com/help/additional-tracking-options-for-campaigns/) tracking (max of 50 bytes).
       */
      clicktale?: string;
      /**
       * Whether to enable e-commerce tracking.
       */
      ecomm360?: boolean;
      /**
       * Deprecated
       */
      goal_tracking?: boolean;
      /**
       * The custom slug for [Google Analytics](https://mailchimp.com/help/integrate-google-analytics-with-mailchimp/) tracking (max of 50 bytes).
       */
      google_analytics?: string;
      /**
       * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the HTML version of the Automation. Defaults to `true`.
       */
      html_clicks?: boolean;
      /**
       * Whether to [track opens](https://mailchimp.com/help/about-open-tracking/). Defaults to `true`.
       */
      opens?: boolean;
      /**
       * Deprecated
       */
      salesforce?: {
        /**
         * Create a campaign in a connected Salesforce account.
         */
        campaign?: boolean;
        /**
         * Update contact notes for a campaign based on a subscriber's email address.
         */
        notes?: boolean;
      };
      /**
       * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the plain-text version of the Automation. Defaults to `true`.
       */
      text_clicks?: boolean;
    };
    /**
     * Available triggers for Automation workflows.
     */
    trigger_settings?: {
      /**
       * A workflow's runtime settings for an Automation.
       */
      runtime?: {
        /**
         * The days an Automation workflow can send.
         */
        days?: Array<'sunday' | 'monday' | 'tuesday' | 'wednesday' | 'thursday' | 'friday' | 'saturday'>;
        /**
         * The hours an Automation workflow can send.
         */
        hours?: {
          /**
           * When to send the Automation email.
           */
          type: 'send_asap' | 'send_between' | 'send_at';
        };
      };
      /**
       * The number of emails in the Automation workflow.
       */
      readonly workflow_emails_count?: number;
      /**
       * The title of the workflow type.
       */
      readonly workflow_title?: string;
      /**
       * The type of Automation workflow.
       */
      workflow_type:
        | 'abandonedBrowse'
        | 'abandonedCart'
        | 'api'
        | 'bestCustomers'
        | 'categoryFollowup'
        | 'dateAdded'
        | 'emailFollowup'
        | 'emailSeries'
        | 'groupAdd'
        | 'groupRemove'
        | 'mandrill'
        | 'productFollowup'
        | 'purchaseFollowup'
        | 'recurringEvent'
        | 'specialEvent'
        | 'visitUrl'
        | 'welcomeSeries';
    };
  }>;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetAutomationsError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostAutomationsData = {
  body: {
    /**
     * List settings for the Automation.
     */
    recipients: {
      /**
       * The id of the List.
       */
      list_id?: string;
      /**
       * The id of the store.
       */
      store_id?: string;
    };
    /**
     * The settings for the Automation workflow.
     */
    settings?: {
      /**
       * The 'from' name for the Automation (not an email address).
       */
      from_name?: string;
      /**
       * The reply-to email address for the Automation.
       */
      reply_to?: string;
    };
    /**
     * Trigger settings for the Automation.
     */
    trigger_settings: {
      /**
       * The type of Automation workflow. Currently only supports 'abandonedCart'.
       */
      workflow_type: string;
    };
  };
};

export type PostAutomationsResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The date and time the Automation was created in ISO 8601 format.
   */
  readonly create_time?: string;
  /**
   * The total number of emails sent for the Automation.
   */
  readonly emails_sent?: number;
  /**
   * A string that identifies the Automation.
   */
  readonly id?: string;
  /**
   * List settings for the Automation.
   */
  recipients?: {
    /**
     * The unique list id.
     */
    list_id?: string;
    /**
     * The status of the list used, namely if it's deleted or disabled.
     */
    readonly list_is_active?: boolean;
    /**
     * List Name.
     */
    list_name?: string;
    /**
     * An object representing all segmentation options.
     */
    segment_opts?: {
      /**
       * Segment match conditions. There are multiple possible types, see the [condition types documentation](https://mailchimp.com/developer/marketing/docs/alternative-schemas/#segment-condition-schemas).
       */
      conditions?: Array<
        | {
            condition_type?: 'Aim';
            /**
             * Segment by interaction with a specific campaign.
             */
            field?: 'aim';
            /**
             * The status of the member with regard to their campaign interaction. One of the following: opened, clicked, was sent, didn't open, didn't click, or was not sent.
             */
            op?: 'open' | 'click' | 'sent' | 'noopen' | 'noclick' | 'nosent';
            /**
             * Either the web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
             */
            value?: string;
          }
        | {
            condition_type?: 'Automation';
            /**
             * Segment by interaction with an Automation workflow.
             */
            field: 'automation';
            /**
             * The status of the member with regard to the automation workflow. One of the following: has started the workflow, has completed the workflow, has not started the workflow, or has not completed the workflow.
             */
            op: 'started' | 'completed' | 'not_started' | 'not_completed';
            /**
             * The web id for the automation workflow to segment against.
             */
            value: string;
          }
        | {
            condition_type?: 'CampaignPoll';
            /**
             * Segment by poll activity.
             */
            field: 'poll';
            /**
             * Members have/have not interacted with a specific poll in a Mailchimp email.
             */
            op: 'member' | 'notmember';
            /**
             * The id for the poll.
             */
            value: number;
          }
        | {
            condition_type?: 'Conversation';
            /**
             * Segment by interaction with a campaign via Conversations.
             */
            field: 'conversation';
            /**
             * The status of a member's interaction with a conversation. One of the following: has replied or has not replied.
             */
            op: 'member' | 'notmember';
            /**
             * The web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
             */
            value: string;
          }
        | {
            condition_type?: 'Date';
            /**
             * When segmenting on 'date' or 'campaign', the date for the segment formatted as YYYY-MM-DD or the web id for the campaign.
             */
            extra?: string;
            /**
             * The type of date field to segment on: The opt-in time for a signup, the date the subscriber was last updated, or the date of their last ecomm purchase.
             */
            field: 'timestamp_opt' | 'info_changed' | 'ecomm_date';
            /**
             * When the event took place:  Before, after, is a specific date, is not a specific date, is blank, or is not blank.
             */
            op: 'greater' | 'less' | 'is' | 'not' | 'blank' | 'blank_not' | 'within' | 'notwithin';
            /**
             * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
             */
            value: string;
          }
        | {
            condition_type?: 'EmailClient';
            /**
             * Segment by use of a particular email client.
             */
            field: 'email_client';
            /**
             * The operation to determine whether we select clients that match the value, or clients that do not match the value.
             */
            op: 'client_is' | 'client_not';
            /**
             * The name of the email client.
             */
            value: string;
          }
        | {
            condition_type?: 'Language';
            /**
             * Segmenting based off of a subscriber's language.
             */
            field: 'language';
            /**
             * Whether the member's language is or is not set to a specific language.
             */
            op: 'is' | 'not';
            /**
             * A two-letter language identifier.
             */
            value: string;
          }
        | {
            condition_type?: 'MemberRating';
            /**
             * Segment by member rating.
             */
            field: 'rating';
            /**
             * Members who have have a rating that is/not exactly a given number or members who have a rating greater/less than a given number.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * The star rating number to segment against.
             */
            value: number;
          }
        | {
            condition_type: 'SignupSource';
            field: 'source';
            /**
             * Whether the member's signup source was/was not a particular value.
             */
            op: 'source_is' | 'source_not';
            /**
             * The signup source.
             */
            value?: string;
          }
        | {
            condition_type?: 'SurveyMonkey';
            /**
             * Segment by interaction with a SurveyMonkey survey.
             */
            field: 'survey_monkey';
            /**
             * The status of the member with regard to the survey.One of the following: has started the survey, has completed the survey, has not started the survey, or has not completed the survey.
             */
            op: 'started' | 'completed' | 'not_started' | 'not_completed';
            /**
             * The unique ID of the survey monkey survey.
             */
            value: string;
          }
        | {
            condition_type?: 'VIP';
            /**
             * Segment by VIP status.
             */
            field: 'gmonkey';
            /**
             * Whether the member is or is not marked as VIP.
             */
            op: 'member' | 'notmember';
          }
        | {
            condition_type?: 'Interests';
            /**
             * Segmenting based on interest group information. This should start with 'interests-' followed by the grouping id. Ex. 'interests-123'.
             */
            field?: string;
            /**
             * Whether the member is a part of one, all, or none of the groups.
             */
            op?: 'interestcontains' | 'interestcontainsall' | 'interestnotcontains';
            /**
             * An array containing strings, each representing a group id.
             */
            value?: Array<string>;
          }
        | {
            condition_type?: 'EcommCategory';
            /**
             * Segment by purchases in specific items or categories.
             */
            field?: 'ecomm_cat' | 'ecomm_prod';
            /**
             * A member who has purchased from a category/specific item that is/is not a specific name, where the category/item name contains/doesn't contain a specific phrase or string, or a category/item name that starts/ends with a string.
             */
            op?: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends';
            /**
             * The ecommerce category/item information.
             */
            value?: string;
          }
        | {
            condition_type?: 'EcommNumber';
            /**
             * Segment by average spent total, number of orders, total number of products purchased, or average number of products per order.
             */
            field: 'ecomm_spent_avg' | 'ecomm_orders' | 'ecomm_prod_all' | 'ecomm_avg_ord';
            /**
             * Members who have spent exactly, have not spent exactly, spent more, or spent less than the segment value.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * Members who have spent exactly, have not spent exactly, spent more, or spent less than this amount.
             */
            value: number;
          }
        | {
            condition_type?: 'EcommPurchased';
            /**
             * Segment by whether someone has purchased anything.
             */
            field?: 'ecomm_purchased';
            /**
             * Members who have have ('member') or have not ('notmember') purchased.
             */
            op?: 'member' | 'notmember';
          }
        | {
            condition_type?: 'EcommSpent';
            /**
             * Segment by amount spent on a single order or across all orders.
             */
            field?: 'ecomm_spent_one' | 'ecomm_spent_all';
            /**
             * Members who have spent 'more' or 'less' than then specified value.
             */
            op?: 'greater' | 'less';
            /**
             * The total amount a member spent.
             */
            value?: number;
          }
        | {
            condition_type?: 'EcommStore';
            /**
             * Segment by purchases from a specific store.
             */
            field?: 'ecomm_store';
            /**
             * Members who have or have not purchased from a specific store.
             */
            op?: 'is' | 'not';
            /**
             * The store id to segment against.
             */
            value?: string;
          }
        | {
            condition_type?: 'GoalActivity';
            /**
             * Segment by Goal activity.
             */
            field: 'goal';
            /**
             * Whether the website URL is/not exactly, contains/doesn't contain, starts with/ends with a string.
             */
            op: 'is' | 'goal_not' | 'contains' | 'goal_notcontain' | 'starts' | 'ends';
            /**
             * The URL to check Goal activity against.
             */
            value: string;
          }
        | {
            condition_type?: 'GoalTimestamp';
            /**
             * Segment by most recent interaction with a website.
             */
            field: 'goal_last_visited';
            /**
             * Whether the website activity happened after, before, or at a given timestamp.
             */
            op: 'greater' | 'less' | 'is';
            /**
             * The date to check Goal activity against.
             */
            value: string;
          }
        | {
            condition_type?: 'FuzzySegment';
            /**
             * Segment by similar subscribers.
             */
            field: 'fuzzy_segment';
            /**
             * Members who are/are not apart of a 'similar subscribers' segment.
             */
            op: 'fuzzy_is' | 'fuzzy_not';
            /**
             * The id for the 'similar subscribers' segment.
             */
            value: number;
          }
        | {
            condition_type?: 'StaticSegment';
            /**
             * Segment by a given static segment.
             */
            field: 'static_segment';
            /**
             * Members who are/are not apart of a static segment.
             */
            op: 'static_is' | 'static_not';
            /**
             * The id for the static segment.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoCountryState';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are within a specific country or US state.
             */
            op: 'ipgeocountry' | 'ipgeonotcountry' | 'ipgeostate' | 'ipgeonotstate';
            /**
             * The two-letter country code or US state abbreviation.
             */
            value: string;
          }
        | {
            /**
             * The address of the target location.
             */
            addr: string;
            condition_type?: 'IPGeoIn';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * The latitude of the target location.
             */
            lat: string;
            /**
             * The longitude of the target location.
             */
            lng: string;
            /**
             * Segment members who are within a specific geographic region.
             */
            op: 'ipgeoin' | 'ipgeonotin';
            /**
             * The radius of the target location.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoInZip';
            /**
             * The zip code to segment against.
             */
            extra: number;
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are within a specific US zip code.
             */
            op: 'ipgeoinzip';
            /**
             * The radius of the target location.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoUnknown';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members for which location information is unknown.
             */
            op: 'ipgeounknown';
          }
        | {
            condition_type?: 'IPGeoZip';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are/are not within a specific US zip code.
             */
            op: 'ipgeoiszip' | 'ipgeonotzip';
            /**
             * The 5-digit zip code.
             */
            value: number;
          }
        | {
            condition_type?: 'SocialAge';
            /**
             * Segment by age ranges in Social Profiles data.
             */
            field: 'social_age';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The age range to segment.
             */
            value: '18-24' | '25-34' | '35-54' | '55+';
          }
        | {
            condition_type?: 'SocialGender';
            /**
             * Segment by listed gender in Social Profiles data.
             */
            field: 'social_gender';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The Social Profiles gender to segment.
             */
            value: 'male' | 'female';
          }
        | {
            condition_type?: 'SocialInfluence';
            /**
             * Segment by influence rating in Social Profiles data.
             */
            field: 'social_influence';
            /**
             * Members who have a rating that is/not or greater/less than the rating provided.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * The Social Profiles influence rating to segment.
             */
            value: number;
          }
        | {
            condition_type?: 'SocialNetworkMember';
            /**
             * Segment by social network in Social Profiles data.
             */
            field: 'social_network';
            /**
             * Members who are/not on a given social network.
             */
            op: 'member' | 'notmember';
            /**
             * The social network to segment against.
             */
            value:
              | 'twitter'
              | 'facebook'
              | 'linkedin'
              | 'flickr'
              | 'foursquare'
              | 'lastfm'
              | 'myspace'
              | 'quora'
              | 'vimeo'
              | 'yelp'
              | 'youtube';
          }
        | {
            condition_type?: 'SocialNetworkFollow';
            /**
             * Segment by social network in Social Profiles data.
             */
            field: 'social_network';
            /**
             * Members who are/not following a linked account on a given social network.
             */
            op: 'follow' | 'notfollow';
            /**
             * The social network to segment against.
             */
            value: 'twitter_follow';
          }
        | {
            condition_type?: 'AddressMerge';
            /**
             * An address-type merge field to segment.
             */
            field: string;
            /**
             * Whether the member's address merge field contains/does not contain a value or is/is not blank.
             */
            op: 'contains' | 'notcontain' | 'blank' | 'blank_not';
            /**
             * The value to segment a text merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'ZipMerge';
            /**
             * The city or the zip being used to segment against.
             */
            extra: string;
            /**
             * An address or zip-type merge field to segment.
             */
            field: string;
            /**
             * Whether the member's address merge field is within a given distance from a city or zip.
             */
            op: 'geoin';
            /**
             * The distance from the city/zip.
             */
            value: string;
          }
        | {
            condition_type?: 'BirthdayMerge';
            /**
             * A date merge field to segment.
             */
            field: string;
            /**
             * Whether the member's birthday merge information is/is not a certain date or is/is not blank.
             */
            op: 'is' | 'not' | 'blank' | 'blank_not';
            /**
             * A date to segment against (mm/dd).
             */
            value?: string;
          }
        | {
            condition_type?: 'DateMerge';
            /**
             * A date merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not, is greater/less than a value or is/is not blank.
             */
            op: 'is' | 'not' | 'less' | 'blank' | 'blank_not' | 'greater';
            /**
             * A date to segment against.
             */
            value?: string;
          }
        | {
            condition_type?: 'SelectMerge';
            /**
             * A merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not a value or is/is not blank.
             */
            op: 'is' | 'not' | 'blank' | 'blank_not' | 'notcontain' | 'contains';
            /**
             * The value to segment a text merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'TextMerge';
            /**
             * A text or number merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not, contains/does not contain, starts/ends with, or is greater/less than a value
             */
            op:
              | 'is'
              | 'not'
              | 'contains'
              | 'notcontain'
              | 'starts'
              | 'ends'
              | 'greater'
              | 'less'
              | 'blank'
              | 'blank_not';
            /**
             * The value to segment a text or number merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'EmailAddress';
            /**
             * Segmenting based off of a subscriber's email address.
             */
            field: 'merge0' | 'EMAIL';
            /**
             * Whether the email address is/not exactly, contains/doesn't contain, starts/ends with a string.
             */
            op: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends' | 'greater' | 'less';
            /**
             * The value to compare the email against.
             */
            value?: string;
          }
        | {
            condition_type?: 'PredictedGender';
            /**
             * Segment by predicted gender.
             */
            field: 'predicted_gender';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The predicted gender to segment.
             */
            value: 'male' | 'female';
          }
        | {
            condition_type?: 'PredictedAge';
            /**
             * Segment by predicted age.
             */
            field: 'predicted_age_range';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is';
            /**
             * The predicted age to segment.
             */
            value: '18-24' | '25-34' | '35-44' | '45-54' | '55-64' | '65+';
          }
        | {
            condition_type?: 'NewSubscribers';
            /**
             * Segment by when people subscribed.
             */
            field?: 'timestamp_opt';
            /**
             * Whe the event took place, namely within a time frame.
             */
            op?: 'date_within';
            /**
             * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
             */
            value?: string;
          }
      >;
      /**
       * Segment match type.
       */
      match?: 'any' | 'all';
      /**
       * The id for an existing saved segment.
       */
      saved_segment_id?: number;
    };
    /**
     * The id of the store.
     */
    store_id?: string;
  };
  /**
   * A summary of opens and clicks for sent campaigns.
   */
  report_summary?: {
    /**
     * The number of unique clicks, divided by the total number of successful deliveries.
     */
    readonly click_rate?: number;
    /**
     * The total number of clicks for an campaign.
     */
    readonly clicks?: number;
    /**
     * The number of unique opens divided by the total number of successful deliveries.
     */
    readonly open_rate?: number;
    /**
     * The total number of opens for a campaign.
     */
    readonly opens?: number;
    /**
     * The number of unique clicks.
     */
    readonly subscriber_clicks?: number;
    /**
     * The number of unique opens.
     */
    readonly unique_opens?: number;
  };
  /**
   * The settings for the Automation workflow.
   */
  settings?: {
    /**
     * Whether Mailchimp [authenticated](https://mailchimp.com/help/about-email-authentication/) the Automation. Defaults to `true`.
     */
    authenticate?: boolean;
    /**
     * Whether to automatically append Mailchimp's [default footer](https://mailchimp.com/help/about-campaign-footers/) to the Automation.
     */
    auto_footer?: boolean;
    /**
     * The 'from' name for the Automation (not an email address).
     */
    from_name?: string;
    /**
     * Whether to automatically inline the CSS included with the Automation content.
     */
    inline_css?: boolean;
    /**
     * The reply-to email address for the Automation.
     */
    reply_to?: string;
    /**
     * The title of the Automation.
     */
    title?: string;
    /**
     * The Automation's custom 'To' name, typically the first name [audience field](https://mailchimp.com/help/getting-started-with-merge-tags/).
     */
    to_name?: string;
    /**
     * Whether to use Mailchimp Conversation feature to manage replies
     */
    use_conversation?: boolean;
  };
  /**
   * The date and time the Automation was started in ISO 8601 format.
   */
  readonly start_time?: string;
  /**
   * The current status of the Automation.
   */
  readonly status?: 'save' | 'paused' | 'sending';
  /**
   * The tracking options for the Automation.
   */
  tracking?: {
    /**
     * Deprecated
     */
    capsule?: {
      /**
       * Update contact notes for a campaign based on a subscriber's email addresses.
       */
      notes?: boolean;
    };
    /**
     * The custom slug for [ClickTale](https://mailchimp.com/help/additional-tracking-options-for-campaigns/) tracking (max of 50 bytes).
     */
    clicktale?: string;
    /**
     * Whether to enable e-commerce tracking.
     */
    ecomm360?: boolean;
    /**
     * Deprecated
     */
    goal_tracking?: boolean;
    /**
     * The custom slug for [Google Analytics](https://mailchimp.com/help/integrate-google-analytics-with-mailchimp/) tracking (max of 50 bytes).
     */
    google_analytics?: string;
    /**
     * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the HTML version of the Automation. Defaults to `true`.
     */
    html_clicks?: boolean;
    /**
     * Whether to [track opens](https://mailchimp.com/help/about-open-tracking/). Defaults to `true`.
     */
    opens?: boolean;
    /**
     * Deprecated
     */
    salesforce?: {
      /**
       * Create a campaign in a connected Salesforce account.
       */
      campaign?: boolean;
      /**
       * Update contact notes for a campaign based on a subscriber's email address.
       */
      notes?: boolean;
    };
    /**
     * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the plain-text version of the Automation. Defaults to `true`.
     */
    text_clicks?: boolean;
  };
  /**
   * Available triggers for Automation workflows.
   */
  trigger_settings?: {
    /**
     * A workflow's runtime settings for an Automation.
     */
    runtime?: {
      /**
       * The days an Automation workflow can send.
       */
      days?: Array<'sunday' | 'monday' | 'tuesday' | 'wednesday' | 'thursday' | 'friday' | 'saturday'>;
      /**
       * The hours an Automation workflow can send.
       */
      hours?: {
        /**
         * When to send the Automation email.
         */
        type: 'send_asap' | 'send_between' | 'send_at';
      };
    };
    /**
     * The number of emails in the Automation workflow.
     */
    readonly workflow_emails_count?: number;
    /**
     * The title of the workflow type.
     */
    readonly workflow_title?: string;
    /**
     * The type of Automation workflow.
     */
    workflow_type:
      | 'abandonedBrowse'
      | 'abandonedCart'
      | 'api'
      | 'bestCustomers'
      | 'categoryFollowup'
      | 'dateAdded'
      | 'emailFollowup'
      | 'emailSeries'
      | 'groupAdd'
      | 'groupRemove'
      | 'mandrill'
      | 'productFollowup'
      | 'purchaseFollowup'
      | 'recurringEvent'
      | 'specialEvent'
      | 'visitUrl'
      | 'welcomeSeries';
  };
};

export type PostAutomationsError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetAutomationsIdData = {
  path: {
    /**
     * The unique id for the Automation workflow.
     */
    workflow_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetAutomationsIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The date and time the Automation was created in ISO 8601 format.
   */
  readonly create_time?: string;
  /**
   * The total number of emails sent for the Automation.
   */
  readonly emails_sent?: number;
  /**
   * A string that identifies the Automation.
   */
  readonly id?: string;
  /**
   * List settings for the Automation.
   */
  recipients?: {
    /**
     * The unique list id.
     */
    list_id?: string;
    /**
     * The status of the list used, namely if it's deleted or disabled.
     */
    readonly list_is_active?: boolean;
    /**
     * List Name.
     */
    list_name?: string;
    /**
     * An object representing all segmentation options.
     */
    segment_opts?: {
      /**
       * Segment match conditions. There are multiple possible types, see the [condition types documentation](https://mailchimp.com/developer/marketing/docs/alternative-schemas/#segment-condition-schemas).
       */
      conditions?: Array<
        | {
            condition_type?: 'Aim';
            /**
             * Segment by interaction with a specific campaign.
             */
            field?: 'aim';
            /**
             * The status of the member with regard to their campaign interaction. One of the following: opened, clicked, was sent, didn't open, didn't click, or was not sent.
             */
            op?: 'open' | 'click' | 'sent' | 'noopen' | 'noclick' | 'nosent';
            /**
             * Either the web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
             */
            value?: string;
          }
        | {
            condition_type?: 'Automation';
            /**
             * Segment by interaction with an Automation workflow.
             */
            field: 'automation';
            /**
             * The status of the member with regard to the automation workflow. One of the following: has started the workflow, has completed the workflow, has not started the workflow, or has not completed the workflow.
             */
            op: 'started' | 'completed' | 'not_started' | 'not_completed';
            /**
             * The web id for the automation workflow to segment against.
             */
            value: string;
          }
        | {
            condition_type?: 'CampaignPoll';
            /**
             * Segment by poll activity.
             */
            field: 'poll';
            /**
             * Members have/have not interacted with a specific poll in a Mailchimp email.
             */
            op: 'member' | 'notmember';
            /**
             * The id for the poll.
             */
            value: number;
          }
        | {
            condition_type?: 'Conversation';
            /**
             * Segment by interaction with a campaign via Conversations.
             */
            field: 'conversation';
            /**
             * The status of a member's interaction with a conversation. One of the following: has replied or has not replied.
             */
            op: 'member' | 'notmember';
            /**
             * The web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
             */
            value: string;
          }
        | {
            condition_type?: 'Date';
            /**
             * When segmenting on 'date' or 'campaign', the date for the segment formatted as YYYY-MM-DD or the web id for the campaign.
             */
            extra?: string;
            /**
             * The type of date field to segment on: The opt-in time for a signup, the date the subscriber was last updated, or the date of their last ecomm purchase.
             */
            field: 'timestamp_opt' | 'info_changed' | 'ecomm_date';
            /**
             * When the event took place:  Before, after, is a specific date, is not a specific date, is blank, or is not blank.
             */
            op: 'greater' | 'less' | 'is' | 'not' | 'blank' | 'blank_not' | 'within' | 'notwithin';
            /**
             * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
             */
            value: string;
          }
        | {
            condition_type?: 'EmailClient';
            /**
             * Segment by use of a particular email client.
             */
            field: 'email_client';
            /**
             * The operation to determine whether we select clients that match the value, or clients that do not match the value.
             */
            op: 'client_is' | 'client_not';
            /**
             * The name of the email client.
             */
            value: string;
          }
        | {
            condition_type?: 'Language';
            /**
             * Segmenting based off of a subscriber's language.
             */
            field: 'language';
            /**
             * Whether the member's language is or is not set to a specific language.
             */
            op: 'is' | 'not';
            /**
             * A two-letter language identifier.
             */
            value: string;
          }
        | {
            condition_type?: 'MemberRating';
            /**
             * Segment by member rating.
             */
            field: 'rating';
            /**
             * Members who have have a rating that is/not exactly a given number or members who have a rating greater/less than a given number.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * The star rating number to segment against.
             */
            value: number;
          }
        | {
            condition_type: 'SignupSource';
            field: 'source';
            /**
             * Whether the member's signup source was/was not a particular value.
             */
            op: 'source_is' | 'source_not';
            /**
             * The signup source.
             */
            value?: string;
          }
        | {
            condition_type?: 'SurveyMonkey';
            /**
             * Segment by interaction with a SurveyMonkey survey.
             */
            field: 'survey_monkey';
            /**
             * The status of the member with regard to the survey.One of the following: has started the survey, has completed the survey, has not started the survey, or has not completed the survey.
             */
            op: 'started' | 'completed' | 'not_started' | 'not_completed';
            /**
             * The unique ID of the survey monkey survey.
             */
            value: string;
          }
        | {
            condition_type?: 'VIP';
            /**
             * Segment by VIP status.
             */
            field: 'gmonkey';
            /**
             * Whether the member is or is not marked as VIP.
             */
            op: 'member' | 'notmember';
          }
        | {
            condition_type?: 'Interests';
            /**
             * Segmenting based on interest group information. This should start with 'interests-' followed by the grouping id. Ex. 'interests-123'.
             */
            field?: string;
            /**
             * Whether the member is a part of one, all, or none of the groups.
             */
            op?: 'interestcontains' | 'interestcontainsall' | 'interestnotcontains';
            /**
             * An array containing strings, each representing a group id.
             */
            value?: Array<string>;
          }
        | {
            condition_type?: 'EcommCategory';
            /**
             * Segment by purchases in specific items or categories.
             */
            field?: 'ecomm_cat' | 'ecomm_prod';
            /**
             * A member who has purchased from a category/specific item that is/is not a specific name, where the category/item name contains/doesn't contain a specific phrase or string, or a category/item name that starts/ends with a string.
             */
            op?: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends';
            /**
             * The ecommerce category/item information.
             */
            value?: string;
          }
        | {
            condition_type?: 'EcommNumber';
            /**
             * Segment by average spent total, number of orders, total number of products purchased, or average number of products per order.
             */
            field: 'ecomm_spent_avg' | 'ecomm_orders' | 'ecomm_prod_all' | 'ecomm_avg_ord';
            /**
             * Members who have spent exactly, have not spent exactly, spent more, or spent less than the segment value.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * Members who have spent exactly, have not spent exactly, spent more, or spent less than this amount.
             */
            value: number;
          }
        | {
            condition_type?: 'EcommPurchased';
            /**
             * Segment by whether someone has purchased anything.
             */
            field?: 'ecomm_purchased';
            /**
             * Members who have have ('member') or have not ('notmember') purchased.
             */
            op?: 'member' | 'notmember';
          }
        | {
            condition_type?: 'EcommSpent';
            /**
             * Segment by amount spent on a single order or across all orders.
             */
            field?: 'ecomm_spent_one' | 'ecomm_spent_all';
            /**
             * Members who have spent 'more' or 'less' than then specified value.
             */
            op?: 'greater' | 'less';
            /**
             * The total amount a member spent.
             */
            value?: number;
          }
        | {
            condition_type?: 'EcommStore';
            /**
             * Segment by purchases from a specific store.
             */
            field?: 'ecomm_store';
            /**
             * Members who have or have not purchased from a specific store.
             */
            op?: 'is' | 'not';
            /**
             * The store id to segment against.
             */
            value?: string;
          }
        | {
            condition_type?: 'GoalActivity';
            /**
             * Segment by Goal activity.
             */
            field: 'goal';
            /**
             * Whether the website URL is/not exactly, contains/doesn't contain, starts with/ends with a string.
             */
            op: 'is' | 'goal_not' | 'contains' | 'goal_notcontain' | 'starts' | 'ends';
            /**
             * The URL to check Goal activity against.
             */
            value: string;
          }
        | {
            condition_type?: 'GoalTimestamp';
            /**
             * Segment by most recent interaction with a website.
             */
            field: 'goal_last_visited';
            /**
             * Whether the website activity happened after, before, or at a given timestamp.
             */
            op: 'greater' | 'less' | 'is';
            /**
             * The date to check Goal activity against.
             */
            value: string;
          }
        | {
            condition_type?: 'FuzzySegment';
            /**
             * Segment by similar subscribers.
             */
            field: 'fuzzy_segment';
            /**
             * Members who are/are not apart of a 'similar subscribers' segment.
             */
            op: 'fuzzy_is' | 'fuzzy_not';
            /**
             * The id for the 'similar subscribers' segment.
             */
            value: number;
          }
        | {
            condition_type?: 'StaticSegment';
            /**
             * Segment by a given static segment.
             */
            field: 'static_segment';
            /**
             * Members who are/are not apart of a static segment.
             */
            op: 'static_is' | 'static_not';
            /**
             * The id for the static segment.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoCountryState';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are within a specific country or US state.
             */
            op: 'ipgeocountry' | 'ipgeonotcountry' | 'ipgeostate' | 'ipgeonotstate';
            /**
             * The two-letter country code or US state abbreviation.
             */
            value: string;
          }
        | {
            /**
             * The address of the target location.
             */
            addr: string;
            condition_type?: 'IPGeoIn';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * The latitude of the target location.
             */
            lat: string;
            /**
             * The longitude of the target location.
             */
            lng: string;
            /**
             * Segment members who are within a specific geographic region.
             */
            op: 'ipgeoin' | 'ipgeonotin';
            /**
             * The radius of the target location.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoInZip';
            /**
             * The zip code to segment against.
             */
            extra: number;
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are within a specific US zip code.
             */
            op: 'ipgeoinzip';
            /**
             * The radius of the target location.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoUnknown';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members for which location information is unknown.
             */
            op: 'ipgeounknown';
          }
        | {
            condition_type?: 'IPGeoZip';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are/are not within a specific US zip code.
             */
            op: 'ipgeoiszip' | 'ipgeonotzip';
            /**
             * The 5-digit zip code.
             */
            value: number;
          }
        | {
            condition_type?: 'SocialAge';
            /**
             * Segment by age ranges in Social Profiles data.
             */
            field: 'social_age';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The age range to segment.
             */
            value: '18-24' | '25-34' | '35-54' | '55+';
          }
        | {
            condition_type?: 'SocialGender';
            /**
             * Segment by listed gender in Social Profiles data.
             */
            field: 'social_gender';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The Social Profiles gender to segment.
             */
            value: 'male' | 'female';
          }
        | {
            condition_type?: 'SocialInfluence';
            /**
             * Segment by influence rating in Social Profiles data.
             */
            field: 'social_influence';
            /**
             * Members who have a rating that is/not or greater/less than the rating provided.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * The Social Profiles influence rating to segment.
             */
            value: number;
          }
        | {
            condition_type?: 'SocialNetworkMember';
            /**
             * Segment by social network in Social Profiles data.
             */
            field: 'social_network';
            /**
             * Members who are/not on a given social network.
             */
            op: 'member' | 'notmember';
            /**
             * The social network to segment against.
             */
            value:
              | 'twitter'
              | 'facebook'
              | 'linkedin'
              | 'flickr'
              | 'foursquare'
              | 'lastfm'
              | 'myspace'
              | 'quora'
              | 'vimeo'
              | 'yelp'
              | 'youtube';
          }
        | {
            condition_type?: 'SocialNetworkFollow';
            /**
             * Segment by social network in Social Profiles data.
             */
            field: 'social_network';
            /**
             * Members who are/not following a linked account on a given social network.
             */
            op: 'follow' | 'notfollow';
            /**
             * The social network to segment against.
             */
            value: 'twitter_follow';
          }
        | {
            condition_type?: 'AddressMerge';
            /**
             * An address-type merge field to segment.
             */
            field: string;
            /**
             * Whether the member's address merge field contains/does not contain a value or is/is not blank.
             */
            op: 'contains' | 'notcontain' | 'blank' | 'blank_not';
            /**
             * The value to segment a text merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'ZipMerge';
            /**
             * The city or the zip being used to segment against.
             */
            extra: string;
            /**
             * An address or zip-type merge field to segment.
             */
            field: string;
            /**
             * Whether the member's address merge field is within a given distance from a city or zip.
             */
            op: 'geoin';
            /**
             * The distance from the city/zip.
             */
            value: string;
          }
        | {
            condition_type?: 'BirthdayMerge';
            /**
             * A date merge field to segment.
             */
            field: string;
            /**
             * Whether the member's birthday merge information is/is not a certain date or is/is not blank.
             */
            op: 'is' | 'not' | 'blank' | 'blank_not';
            /**
             * A date to segment against (mm/dd).
             */
            value?: string;
          }
        | {
            condition_type?: 'DateMerge';
            /**
             * A date merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not, is greater/less than a value or is/is not blank.
             */
            op: 'is' | 'not' | 'less' | 'blank' | 'blank_not' | 'greater';
            /**
             * A date to segment against.
             */
            value?: string;
          }
        | {
            condition_type?: 'SelectMerge';
            /**
             * A merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not a value or is/is not blank.
             */
            op: 'is' | 'not' | 'blank' | 'blank_not' | 'notcontain' | 'contains';
            /**
             * The value to segment a text merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'TextMerge';
            /**
             * A text or number merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not, contains/does not contain, starts/ends with, or is greater/less than a value
             */
            op:
              | 'is'
              | 'not'
              | 'contains'
              | 'notcontain'
              | 'starts'
              | 'ends'
              | 'greater'
              | 'less'
              | 'blank'
              | 'blank_not';
            /**
             * The value to segment a text or number merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'EmailAddress';
            /**
             * Segmenting based off of a subscriber's email address.
             */
            field: 'merge0' | 'EMAIL';
            /**
             * Whether the email address is/not exactly, contains/doesn't contain, starts/ends with a string.
             */
            op: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends' | 'greater' | 'less';
            /**
             * The value to compare the email against.
             */
            value?: string;
          }
        | {
            condition_type?: 'PredictedGender';
            /**
             * Segment by predicted gender.
             */
            field: 'predicted_gender';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The predicted gender to segment.
             */
            value: 'male' | 'female';
          }
        | {
            condition_type?: 'PredictedAge';
            /**
             * Segment by predicted age.
             */
            field: 'predicted_age_range';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is';
            /**
             * The predicted age to segment.
             */
            value: '18-24' | '25-34' | '35-44' | '45-54' | '55-64' | '65+';
          }
        | {
            condition_type?: 'NewSubscribers';
            /**
             * Segment by when people subscribed.
             */
            field?: 'timestamp_opt';
            /**
             * Whe the event took place, namely within a time frame.
             */
            op?: 'date_within';
            /**
             * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
             */
            value?: string;
          }
      >;
      /**
       * Segment match type.
       */
      match?: 'any' | 'all';
      /**
       * The id for an existing saved segment.
       */
      saved_segment_id?: number;
    };
    /**
     * The id of the store.
     */
    store_id?: string;
  };
  /**
   * A summary of opens and clicks for sent campaigns.
   */
  report_summary?: {
    /**
     * The number of unique clicks, divided by the total number of successful deliveries.
     */
    readonly click_rate?: number;
    /**
     * The total number of clicks for an campaign.
     */
    readonly clicks?: number;
    /**
     * The number of unique opens divided by the total number of successful deliveries.
     */
    readonly open_rate?: number;
    /**
     * The total number of opens for a campaign.
     */
    readonly opens?: number;
    /**
     * The number of unique clicks.
     */
    readonly subscriber_clicks?: number;
    /**
     * The number of unique opens.
     */
    readonly unique_opens?: number;
  };
  /**
   * The settings for the Automation workflow.
   */
  settings?: {
    /**
     * Whether Mailchimp [authenticated](https://mailchimp.com/help/about-email-authentication/) the Automation. Defaults to `true`.
     */
    authenticate?: boolean;
    /**
     * Whether to automatically append Mailchimp's [default footer](https://mailchimp.com/help/about-campaign-footers/) to the Automation.
     */
    auto_footer?: boolean;
    /**
     * The 'from' name for the Automation (not an email address).
     */
    from_name?: string;
    /**
     * Whether to automatically inline the CSS included with the Automation content.
     */
    inline_css?: boolean;
    /**
     * The reply-to email address for the Automation.
     */
    reply_to?: string;
    /**
     * The title of the Automation.
     */
    title?: string;
    /**
     * The Automation's custom 'To' name, typically the first name [audience field](https://mailchimp.com/help/getting-started-with-merge-tags/).
     */
    to_name?: string;
    /**
     * Whether to use Mailchimp Conversation feature to manage replies
     */
    use_conversation?: boolean;
  };
  /**
   * The date and time the Automation was started in ISO 8601 format.
   */
  readonly start_time?: string;
  /**
   * The current status of the Automation.
   */
  readonly status?: 'save' | 'paused' | 'sending';
  /**
   * The tracking options for the Automation.
   */
  tracking?: {
    /**
     * Deprecated
     */
    capsule?: {
      /**
       * Update contact notes for a campaign based on a subscriber's email addresses.
       */
      notes?: boolean;
    };
    /**
     * The custom slug for [ClickTale](https://mailchimp.com/help/additional-tracking-options-for-campaigns/) tracking (max of 50 bytes).
     */
    clicktale?: string;
    /**
     * Whether to enable e-commerce tracking.
     */
    ecomm360?: boolean;
    /**
     * Deprecated
     */
    goal_tracking?: boolean;
    /**
     * The custom slug for [Google Analytics](https://mailchimp.com/help/integrate-google-analytics-with-mailchimp/) tracking (max of 50 bytes).
     */
    google_analytics?: string;
    /**
     * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the HTML version of the Automation. Defaults to `true`.
     */
    html_clicks?: boolean;
    /**
     * Whether to [track opens](https://mailchimp.com/help/about-open-tracking/). Defaults to `true`.
     */
    opens?: boolean;
    /**
     * Deprecated
     */
    salesforce?: {
      /**
       * Create a campaign in a connected Salesforce account.
       */
      campaign?: boolean;
      /**
       * Update contact notes for a campaign based on a subscriber's email address.
       */
      notes?: boolean;
    };
    /**
     * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the plain-text version of the Automation. Defaults to `true`.
     */
    text_clicks?: boolean;
  };
  /**
   * Available triggers for Automation workflows.
   */
  trigger_settings?: {
    /**
     * A workflow's runtime settings for an Automation.
     */
    runtime?: {
      /**
       * The days an Automation workflow can send.
       */
      days?: Array<'sunday' | 'monday' | 'tuesday' | 'wednesday' | 'thursday' | 'friday' | 'saturday'>;
      /**
       * The hours an Automation workflow can send.
       */
      hours?: {
        /**
         * When to send the Automation email.
         */
        type: 'send_asap' | 'send_between' | 'send_at';
      };
    };
    /**
     * The number of emails in the Automation workflow.
     */
    readonly workflow_emails_count?: number;
    /**
     * The title of the workflow type.
     */
    readonly workflow_title?: string;
    /**
     * The type of Automation workflow.
     */
    workflow_type:
      | 'abandonedBrowse'
      | 'abandonedCart'
      | 'api'
      | 'bestCustomers'
      | 'categoryFollowup'
      | 'dateAdded'
      | 'emailFollowup'
      | 'emailSeries'
      | 'groupAdd'
      | 'groupRemove'
      | 'mandrill'
      | 'productFollowup'
      | 'purchaseFollowup'
      | 'recurringEvent'
      | 'specialEvent'
      | 'visitUrl'
      | 'welcomeSeries';
  };
};

export type GetAutomationsIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type ArchiveAutomationsData = {
  path: {
    /**
     * The unique id for the Automation workflow.
     */
    workflow_id: string;
  };
};

export type ArchiveAutomationsResponse = any;

export type ArchiveAutomationsError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostAutomationsIdActionsPauseAllEmailsData = {
  path: {
    /**
     * The unique id for the Automation workflow.
     */
    workflow_id: string;
  };
};

export type PostAutomationsIdActionsPauseAllEmailsResponse = any;

export type PostAutomationsIdActionsPauseAllEmailsError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostAutomationsIdActionsStartAllEmailsData = {
  path: {
    /**
     * The unique id for the Automation workflow.
     */
    workflow_id: string;
  };
};

export type PostAutomationsIdActionsStartAllEmailsResponse = any;

export type PostAutomationsIdActionsStartAllEmailsError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetAutomationsIdEmailsData = {
  path: {
    /**
     * The unique id for the Automation workflow.
     */
    workflow_id: string;
  };
};

export type GetAutomationsIdEmailsResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of objects, each representing an email in an Automation workflow.
   */
  emails?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The link to the campaign's archive version in ISO 8601 format.
     */
    readonly archive_url?: string;
    /**
     * How the campaign's content is put together ('template', 'drag_and_drop', 'html', 'url').
     */
    readonly content_type?: string;
    /**
     * The date and time the campaign was created in ISO 8601 format.
     */
    readonly create_time?: string;
    /**
     * The delay settings for an Automation email.
     */
    delay?: {
      /**
       * The action that triggers the delay of an Automation email.
       */
      action?:
        | 'previous_campaign_sent'
        | 'previous_campaign_opened'
        | 'previous_campaign_not_opened'
        | 'previous_campaign_clicked_any'
        | 'previous_campaign_not_clicked_any'
        | 'previous_campaign_specific_clicked'
        | 'ecomm_bought_any'
        | 'ecomm_bought_product'
        | 'ecomm_bought_category'
        | 'ecomm_not_bought_any'
        | 'ecomm_abandoned_cart'
        | 'campaign_sent'
        | 'opened_email'
        | 'not_opened_email'
        | 'clicked_email'
        | 'not_clicked_email'
        | 'campaign_specific_clicked'
        | 'manual'
        | 'signup'
        | 'merge_changed'
        | 'group_add'
        | 'group_remove'
        | 'mandrill_sent'
        | 'mandrill_opened'
        | 'mandrill_clicked'
        | 'mandrill_any'
        | 'api'
        | 'goal'
        | 'annual'
        | 'birthday'
        | 'date'
        | 'date_added'
        | 'tag_add';
      /**
       * The user-friendly description of the action that triggers an Automation email.
       */
      readonly action_description?: string;
      /**
       * The delay amount for an Automation email.
       */
      readonly amount?: number;
      /**
       * Whether the delay settings describe before or after the delay action of an Automation email.
       */
      direction?: 'before' | 'after';
      /**
       * The user-friendly description of the delay and trigger action settings for an Automation email.
       */
      readonly full_description?: string;
      /**
       * The type of delay for an Automation email.
       */
      type?: 'now' | 'day' | 'hour' | 'week';
    };
    /**
     * The total number of emails sent for this campaign.
     */
    readonly emails_sent?: number;
    /**
     * Determines if the campaign contains the *|BRAND:LOGO|* merge tag.
     */
    readonly has_logo_merge_tag?: boolean;
    /**
     * A string that uniquely identifies the Automation email.
     */
    readonly id?: string;
    /**
     * Determines if the automation email needs its blocks refreshed by opening the web-based campaign editor.
     */
    readonly needs_block_refresh?: boolean;
    /**
     * The position of an Automation email in a workflow.
     */
    readonly position?: number;
    /**
     * List settings for the campaign.
     */
    recipients?: {
      /**
       * The unique list id.
       */
      list_id?: string;
      /**
       * The status of the list used, namely if it's deleted or disabled.
       */
      readonly list_is_active?: boolean;
      /**
       * The name of the list.
       */
      readonly list_name?: string;
      /**
       * Count of the recipients on the associated list. Formatted as an integer.
       */
      readonly recipient_count?: number;
      /**
       * An object representing all segmentation options. This object should contain a `saved_segment_id` to use an existing segment, or you can create a new segment by including both `match` and `conditions` options.
       */
      segment_opts?: {
        /**
         * Segment match conditions. There are multiple possible types, see the [condition types documentation](https://mailchimp.com/developer/marketing/docs/alternative-schemas/#segment-condition-schemas).
         */
        conditions?: Array<
          | {
              condition_type?: 'Aim';
              /**
               * Segment by interaction with a specific campaign.
               */
              field?: 'aim';
              /**
               * The status of the member with regard to their campaign interaction. One of the following: opened, clicked, was sent, didn't open, didn't click, or was not sent.
               */
              op?: 'open' | 'click' | 'sent' | 'noopen' | 'noclick' | 'nosent';
              /**
               * Either the web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
               */
              value?: string;
            }
          | {
              condition_type?: 'Automation';
              /**
               * Segment by interaction with an Automation workflow.
               */
              field: 'automation';
              /**
               * The status of the member with regard to the automation workflow. One of the following: has started the workflow, has completed the workflow, has not started the workflow, or has not completed the workflow.
               */
              op: 'started' | 'completed' | 'not_started' | 'not_completed';
              /**
               * The web id for the automation workflow to segment against.
               */
              value: string;
            }
          | {
              condition_type?: 'CampaignPoll';
              /**
               * Segment by poll activity.
               */
              field: 'poll';
              /**
               * Members have/have not interacted with a specific poll in a Mailchimp email.
               */
              op: 'member' | 'notmember';
              /**
               * The id for the poll.
               */
              value: number;
            }
          | {
              condition_type?: 'Conversation';
              /**
               * Segment by interaction with a campaign via Conversations.
               */
              field: 'conversation';
              /**
               * The status of a member's interaction with a conversation. One of the following: has replied or has not replied.
               */
              op: 'member' | 'notmember';
              /**
               * The web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
               */
              value: string;
            }
          | {
              condition_type?: 'Date';
              /**
               * When segmenting on 'date' or 'campaign', the date for the segment formatted as YYYY-MM-DD or the web id for the campaign.
               */
              extra?: string;
              /**
               * The type of date field to segment on: The opt-in time for a signup, the date the subscriber was last updated, or the date of their last ecomm purchase.
               */
              field: 'timestamp_opt' | 'info_changed' | 'ecomm_date';
              /**
               * When the event took place:  Before, after, is a specific date, is not a specific date, is blank, or is not blank.
               */
              op: 'greater' | 'less' | 'is' | 'not' | 'blank' | 'blank_not' | 'within' | 'notwithin';
              /**
               * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
               */
              value: string;
            }
          | {
              condition_type?: 'EmailClient';
              /**
               * Segment by use of a particular email client.
               */
              field: 'email_client';
              /**
               * The operation to determine whether we select clients that match the value, or clients that do not match the value.
               */
              op: 'client_is' | 'client_not';
              /**
               * The name of the email client.
               */
              value: string;
            }
          | {
              condition_type?: 'Language';
              /**
               * Segmenting based off of a subscriber's language.
               */
              field: 'language';
              /**
               * Whether the member's language is or is not set to a specific language.
               */
              op: 'is' | 'not';
              /**
               * A two-letter language identifier.
               */
              value: string;
            }
          | {
              condition_type?: 'MemberRating';
              /**
               * Segment by member rating.
               */
              field: 'rating';
              /**
               * Members who have have a rating that is/not exactly a given number or members who have a rating greater/less than a given number.
               */
              op: 'is' | 'not' | 'greater' | 'less';
              /**
               * The star rating number to segment against.
               */
              value: number;
            }
          | {
              condition_type: 'SignupSource';
              field: 'source';
              /**
               * Whether the member's signup source was/was not a particular value.
               */
              op: 'source_is' | 'source_not';
              /**
               * The signup source.
               */
              value?: string;
            }
          | {
              condition_type?: 'SurveyMonkey';
              /**
               * Segment by interaction with a SurveyMonkey survey.
               */
              field: 'survey_monkey';
              /**
               * The status of the member with regard to the survey.One of the following: has started the survey, has completed the survey, has not started the survey, or has not completed the survey.
               */
              op: 'started' | 'completed' | 'not_started' | 'not_completed';
              /**
               * The unique ID of the survey monkey survey.
               */
              value: string;
            }
          | {
              condition_type?: 'VIP';
              /**
               * Segment by VIP status.
               */
              field: 'gmonkey';
              /**
               * Whether the member is or is not marked as VIP.
               */
              op: 'member' | 'notmember';
            }
          | {
              condition_type?: 'Interests';
              /**
               * Segmenting based on interest group information. This should start with 'interests-' followed by the grouping id. Ex. 'interests-123'.
               */
              field?: string;
              /**
               * Whether the member is a part of one, all, or none of the groups.
               */
              op?: 'interestcontains' | 'interestcontainsall' | 'interestnotcontains';
              /**
               * An array containing strings, each representing a group id.
               */
              value?: Array<string>;
            }
          | {
              condition_type?: 'EcommCategory';
              /**
               * Segment by purchases in specific items or categories.
               */
              field?: 'ecomm_cat' | 'ecomm_prod';
              /**
               * A member who has purchased from a category/specific item that is/is not a specific name, where the category/item name contains/doesn't contain a specific phrase or string, or a category/item name that starts/ends with a string.
               */
              op?: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends';
              /**
               * The ecommerce category/item information.
               */
              value?: string;
            }
          | {
              condition_type?: 'EcommNumber';
              /**
               * Segment by average spent total, number of orders, total number of products purchased, or average number of products per order.
               */
              field: 'ecomm_spent_avg' | 'ecomm_orders' | 'ecomm_prod_all' | 'ecomm_avg_ord';
              /**
               * Members who have spent exactly, have not spent exactly, spent more, or spent less than the segment value.
               */
              op: 'is' | 'not' | 'greater' | 'less';
              /**
               * Members who have spent exactly, have not spent exactly, spent more, or spent less than this amount.
               */
              value: number;
            }
          | {
              condition_type?: 'EcommPurchased';
              /**
               * Segment by whether someone has purchased anything.
               */
              field?: 'ecomm_purchased';
              /**
               * Members who have have ('member') or have not ('notmember') purchased.
               */
              op?: 'member' | 'notmember';
            }
          | {
              condition_type?: 'EcommSpent';
              /**
               * Segment by amount spent on a single order or across all orders.
               */
              field?: 'ecomm_spent_one' | 'ecomm_spent_all';
              /**
               * Members who have spent 'more' or 'less' than then specified value.
               */
              op?: 'greater' | 'less';
              /**
               * The total amount a member spent.
               */
              value?: number;
            }
          | {
              condition_type?: 'EcommStore';
              /**
               * Segment by purchases from a specific store.
               */
              field?: 'ecomm_store';
              /**
               * Members who have or have not purchased from a specific store.
               */
              op?: 'is' | 'not';
              /**
               * The store id to segment against.
               */
              value?: string;
            }
          | {
              condition_type?: 'GoalActivity';
              /**
               * Segment by Goal activity.
               */
              field: 'goal';
              /**
               * Whether the website URL is/not exactly, contains/doesn't contain, starts with/ends with a string.
               */
              op: 'is' | 'goal_not' | 'contains' | 'goal_notcontain' | 'starts' | 'ends';
              /**
               * The URL to check Goal activity against.
               */
              value: string;
            }
          | {
              condition_type?: 'GoalTimestamp';
              /**
               * Segment by most recent interaction with a website.
               */
              field: 'goal_last_visited';
              /**
               * Whether the website activity happened after, before, or at a given timestamp.
               */
              op: 'greater' | 'less' | 'is';
              /**
               * The date to check Goal activity against.
               */
              value: string;
            }
          | {
              condition_type?: 'FuzzySegment';
              /**
               * Segment by similar subscribers.
               */
              field: 'fuzzy_segment';
              /**
               * Members who are/are not apart of a 'similar subscribers' segment.
               */
              op: 'fuzzy_is' | 'fuzzy_not';
              /**
               * The id for the 'similar subscribers' segment.
               */
              value: number;
            }
          | {
              condition_type?: 'StaticSegment';
              /**
               * Segment by a given static segment.
               */
              field: 'static_segment';
              /**
               * Members who are/are not apart of a static segment.
               */
              op: 'static_is' | 'static_not';
              /**
               * The id for the static segment.
               */
              value: number;
            }
          | {
              condition_type?: 'IPGeoCountryState';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members who are within a specific country or US state.
               */
              op: 'ipgeocountry' | 'ipgeonotcountry' | 'ipgeostate' | 'ipgeonotstate';
              /**
               * The two-letter country code or US state abbreviation.
               */
              value: string;
            }
          | {
              /**
               * The address of the target location.
               */
              addr: string;
              condition_type?: 'IPGeoIn';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * The latitude of the target location.
               */
              lat: string;
              /**
               * The longitude of the target location.
               */
              lng: string;
              /**
               * Segment members who are within a specific geographic region.
               */
              op: 'ipgeoin' | 'ipgeonotin';
              /**
               * The radius of the target location.
               */
              value: number;
            }
          | {
              condition_type?: 'IPGeoInZip';
              /**
               * The zip code to segment against.
               */
              extra: number;
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members who are within a specific US zip code.
               */
              op: 'ipgeoinzip';
              /**
               * The radius of the target location.
               */
              value: number;
            }
          | {
              condition_type?: 'IPGeoUnknown';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members for which location information is unknown.
               */
              op: 'ipgeounknown';
            }
          | {
              condition_type?: 'IPGeoZip';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members who are/are not within a specific US zip code.
               */
              op: 'ipgeoiszip' | 'ipgeonotzip';
              /**
               * The 5-digit zip code.
               */
              value: number;
            }
          | {
              condition_type?: 'SocialAge';
              /**
               * Segment by age ranges in Social Profiles data.
               */
              field: 'social_age';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is' | 'not';
              /**
               * The age range to segment.
               */
              value: '18-24' | '25-34' | '35-54' | '55+';
            }
          | {
              condition_type?: 'SocialGender';
              /**
               * Segment by listed gender in Social Profiles data.
               */
              field: 'social_gender';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is' | 'not';
              /**
               * The Social Profiles gender to segment.
               */
              value: 'male' | 'female';
            }
          | {
              condition_type?: 'SocialInfluence';
              /**
               * Segment by influence rating in Social Profiles data.
               */
              field: 'social_influence';
              /**
               * Members who have a rating that is/not or greater/less than the rating provided.
               */
              op: 'is' | 'not' | 'greater' | 'less';
              /**
               * The Social Profiles influence rating to segment.
               */
              value: number;
            }
          | {
              condition_type?: 'SocialNetworkMember';
              /**
               * Segment by social network in Social Profiles data.
               */
              field: 'social_network';
              /**
               * Members who are/not on a given social network.
               */
              op: 'member' | 'notmember';
              /**
               * The social network to segment against.
               */
              value:
                | 'twitter'
                | 'facebook'
                | 'linkedin'
                | 'flickr'
                | 'foursquare'
                | 'lastfm'
                | 'myspace'
                | 'quora'
                | 'vimeo'
                | 'yelp'
                | 'youtube';
            }
          | {
              condition_type?: 'SocialNetworkFollow';
              /**
               * Segment by social network in Social Profiles data.
               */
              field: 'social_network';
              /**
               * Members who are/not following a linked account on a given social network.
               */
              op: 'follow' | 'notfollow';
              /**
               * The social network to segment against.
               */
              value: 'twitter_follow';
            }
          | {
              condition_type?: 'AddressMerge';
              /**
               * An address-type merge field to segment.
               */
              field: string;
              /**
               * Whether the member's address merge field contains/does not contain a value or is/is not blank.
               */
              op: 'contains' | 'notcontain' | 'blank' | 'blank_not';
              /**
               * The value to segment a text merge field with.
               */
              value?: string;
            }
          | {
              condition_type?: 'ZipMerge';
              /**
               * The city or the zip being used to segment against.
               */
              extra: string;
              /**
               * An address or zip-type merge field to segment.
               */
              field: string;
              /**
               * Whether the member's address merge field is within a given distance from a city or zip.
               */
              op: 'geoin';
              /**
               * The distance from the city/zip.
               */
              value: string;
            }
          | {
              condition_type?: 'BirthdayMerge';
              /**
               * A date merge field to segment.
               */
              field: string;
              /**
               * Whether the member's birthday merge information is/is not a certain date or is/is not blank.
               */
              op: 'is' | 'not' | 'blank' | 'blank_not';
              /**
               * A date to segment against (mm/dd).
               */
              value?: string;
            }
          | {
              condition_type?: 'DateMerge';
              /**
               * A date merge field to segment.
               */
              field: string;
              /**
               * Whether the member's merge information is/is not, is greater/less than a value or is/is not blank.
               */
              op: 'is' | 'not' | 'less' | 'blank' | 'blank_not' | 'greater';
              /**
               * A date to segment against.
               */
              value?: string;
            }
          | {
              condition_type?: 'SelectMerge';
              /**
               * A merge field to segment.
               */
              field: string;
              /**
               * Whether the member's merge information is/is not a value or is/is not blank.
               */
              op: 'is' | 'not' | 'blank' | 'blank_not' | 'notcontain' | 'contains';
              /**
               * The value to segment a text merge field with.
               */
              value?: string;
            }
          | {
              condition_type?: 'TextMerge';
              /**
               * A text or number merge field to segment.
               */
              field: string;
              /**
               * Whether the member's merge information is/is not, contains/does not contain, starts/ends with, or is greater/less than a value
               */
              op:
                | 'is'
                | 'not'
                | 'contains'
                | 'notcontain'
                | 'starts'
                | 'ends'
                | 'greater'
                | 'less'
                | 'blank'
                | 'blank_not';
              /**
               * The value to segment a text or number merge field with.
               */
              value?: string;
            }
          | {
              condition_type?: 'EmailAddress';
              /**
               * Segmenting based off of a subscriber's email address.
               */
              field: 'merge0' | 'EMAIL';
              /**
               * Whether the email address is/not exactly, contains/doesn't contain, starts/ends with a string.
               */
              op: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends' | 'greater' | 'less';
              /**
               * The value to compare the email against.
               */
              value?: string;
            }
          | {
              condition_type?: 'PredictedGender';
              /**
               * Segment by predicted gender.
               */
              field: 'predicted_gender';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is' | 'not';
              /**
               * The predicted gender to segment.
               */
              value: 'male' | 'female';
            }
          | {
              condition_type?: 'PredictedAge';
              /**
               * Segment by predicted age.
               */
              field: 'predicted_age_range';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is';
              /**
               * The predicted age to segment.
               */
              value: '18-24' | '25-34' | '35-44' | '45-54' | '55-64' | '65+';
            }
          | {
              condition_type?: 'NewSubscribers';
              /**
               * Segment by when people subscribed.
               */
              field?: 'timestamp_opt';
              /**
               * Whe the event took place, namely within a time frame.
               */
              op?: 'date_within';
              /**
               * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
               */
              value?: string;
            }
        >;
        /**
         * Segment match type.
         */
        match?: 'any' | 'all';
        /**
         * The prebuilt segment id, if a prebuilt segment has been designated for this campaign.
         */
        prebuilt_segment_id?: string;
        /**
         * The id for an existing saved segment.
         */
        saved_segment_id?: number;
      };
      /**
       * A description of the [segment](https://mailchimp.com/help/getting-started-with-groups/) used for the campaign. Formatted as a string marked up with HTML.
       */
      readonly segment_text?: string;
    };
    /**
     * For sent campaigns, a summary of opens and clicks.
     */
    report_summary?: {
      /**
       * The number of unique clicks divided by the total number of successful deliveries.
       */
      readonly click_rate?: number;
      /**
       * The total number of clicks for an campaign.
       */
      readonly clicks?: number;
      /**
       * The number of unique opens divided by the total number of successful deliveries.
       */
      readonly open_rate?: number;
      /**
       * The total number of opens for a campaign.
       */
      readonly opens?: number;
      /**
       * The number of unique clicks.
       */
      readonly subscriber_clicks?: number;
      /**
       * The number of unique opens.
       */
      readonly unique_opens?: number;
    };
    /**
     *  The date and time a campaign was sent in ISO 8601 format
     */
    readonly send_time?: string;
    /**
     * Settings for the campaign including the email subject, from name, and from email address.
     */
    settings?: {
      /**
       * Whether Mailchimp [authenticated](https://mailchimp.com/help/about-email-authentication/) the campaign. Defaults to `true`.
       */
      authenticate?: boolean;
      /**
       * An array of [Facebook](https://mailchimp.com/help/connect-or-disconnect-the-facebook-integration/) page ids to auto-post to.
       */
      auto_fb_post?: Array<string>;
      /**
       * Automatically append Mailchimp's [default footer](https://mailchimp.com/help/about-campaign-footers/) to the campaign.
       */
      auto_footer?: boolean;
      /**
       * Automatically tweet a link to the [campaign archive](https://mailchimp.com/help/about-email-campaign-archives-and-pages/) page when the campaign is sent.
       */
      auto_tweet?: boolean;
      /**
       * Whether the campaign uses the drag-and-drop editor.
       */
      readonly drag_and_drop?: boolean;
      /**
       * Allows Facebook comments on the campaign (also force-enables the Campaign Archive toolbar). Defaults to `true`.
       */
      fb_comments?: boolean;
      /**
       * The 'from' name on the campaign (not an email address).
       */
      from_name?: string;
      /**
       * Automatically inline the CSS included with the campaign content.
       */
      inline_css?: boolean;
      /**
       * The preview text for the campaign.
       */
      preview_text?: string;
      /**
       * The reply-to email address for the campaign.
       */
      reply_to?: string;
      /**
       * The subject line for the campaign.
       */
      subject_line?: string;
      /**
       * The id for the template used in this campaign.
       */
      template_id?: number;
      /**
       * The title of the campaign.
       */
      title?: string;
    };
    /**
     * The preview for the campaign, rendered by social networks like Facebook and Twitter. [Learn more](https://mailchimp.com/help/enable-and-customize-social-cards/).
     */
    social_card?: {
      /**
       * A short summary of the campaign to display.
       */
      description?: string;
      /**
       * The url for the header image for the card.
       */
      image_url?: string;
      /**
       * The title for the card. Typically the subject line of the campaign.
       */
      title?: string;
    };
    /**
     * The date and time the campaign was started in ISO 8601 format.
     */
    readonly start_time?: string;
    /**
     * The current status of the campaign.
     */
    readonly status?: 'save' | 'paused' | 'sending';
    /**
     * The tracking options for a campaign.
     */
    tracking?: {
      /**
       * Deprecated
       */
      capsule?: {
        /**
         * Update contact notes for a campaign based on a subscriber's email address.
         */
        notes?: boolean;
      };
      /**
       * The custom slug for [Click Tale](https://mailchimp.com/help/additional-tracking-options-for-campaigns/) tracking (max of 50 bytes).
       */
      clicktale?: string;
      /**
       * Whether to enable e-commerce tracking.
       */
      ecomm360?: boolean;
      /**
       * Deprecated
       */
      goal_tracking?: boolean;
      /**
       * The custom slug for [Google Analytics](https://mailchimp.com/help/integrate-google-analytics-with-mailchimp/) tracking (max of 50 bytes).
       */
      google_analytics?: string;
      /**
       * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the HTML version of the campaign. Defaults to `true`.
       */
      html_clicks?: boolean;
      /**
       * Whether to [track opens](https://mailchimp.com/help/about-open-tracking/). Defaults to `true`.
       */
      opens?: boolean;
      /**
       * Deprecated
       */
      salesforce?: {
        /**
         * Create a campaign in a connected Salesforce account.
         */
        campaign?: boolean;
        /**
         * Update contact notes for a campaign based on a subscriber's email address.
         */
        notes?: boolean;
      };
      /**
       * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the plain-text version of the campaign. Defaults to `true`.
       */
      text_clicks?: boolean;
    };
    /**
     * Available triggers for Automation workflows.
     */
    trigger_settings?: {
      /**
       * A workflow's runtime settings for an Automation.
       */
      runtime?: {
        /**
         * The days an Automation workflow can send.
         */
        days?: Array<'sunday' | 'monday' | 'tuesday' | 'wednesday' | 'thursday' | 'friday' | 'saturday'>;
        /**
         * The hours an Automation workflow can send.
         */
        hours?: {
          /**
           * When to send the Automation email.
           */
          type: 'send_asap' | 'send_between' | 'send_at';
        };
      };
      /**
       * The number of emails in the Automation workflow.
       */
      readonly workflow_emails_count?: number;
      /**
       * The title of the workflow type.
       */
      readonly workflow_title?: string;
      /**
       * The type of Automation workflow.
       */
      workflow_type:
        | 'abandonedBrowse'
        | 'abandonedCart'
        | 'api'
        | 'bestCustomers'
        | 'categoryFollowup'
        | 'dateAdded'
        | 'emailFollowup'
        | 'emailSeries'
        | 'groupAdd'
        | 'groupRemove'
        | 'mandrill'
        | 'productFollowup'
        | 'purchaseFollowup'
        | 'recurringEvent'
        | 'specialEvent'
        | 'visitUrl'
        | 'welcomeSeries';
    };
    /**
     * The ID used in the Mailchimp web application. View this automation in your Mailchimp account at `https://{dc}.admin.mailchimp.com/campaigns/show/?id={web_id}`.
     */
    readonly web_id?: number;
    /**
     * A string that uniquely identifies an Automation workflow.
     */
    readonly workflow_id?: string;
  }>;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetAutomationsIdEmailsError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type DeleteAutomationsIdEmailsIdData = {
  path: {
    /**
     * The unique id for the Automation workflow email.
     */
    workflow_email_id: string;
    /**
     * The unique id for the Automation workflow.
     */
    workflow_id: string;
  };
};

export type DeleteAutomationsIdEmailsIdResponse = any;

export type DeleteAutomationsIdEmailsIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetAutomationsIdEmailsIdData = {
  path: {
    /**
     * The unique id for the Automation workflow email.
     */
    workflow_email_id: string;
    /**
     * The unique id for the Automation workflow.
     */
    workflow_id: string;
  };
};

export type GetAutomationsIdEmailsIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The link to the campaign's archive version in ISO 8601 format.
   */
  readonly archive_url?: string;
  /**
   * How the campaign's content is put together ('template', 'drag_and_drop', 'html', 'url').
   */
  readonly content_type?: string;
  /**
   * The date and time the campaign was created in ISO 8601 format.
   */
  readonly create_time?: string;
  /**
   * The delay settings for an Automation email.
   */
  delay?: {
    /**
     * The action that triggers the delay of an Automation email.
     */
    action?:
      | 'previous_campaign_sent'
      | 'previous_campaign_opened'
      | 'previous_campaign_not_opened'
      | 'previous_campaign_clicked_any'
      | 'previous_campaign_not_clicked_any'
      | 'previous_campaign_specific_clicked'
      | 'ecomm_bought_any'
      | 'ecomm_bought_product'
      | 'ecomm_bought_category'
      | 'ecomm_not_bought_any'
      | 'ecomm_abandoned_cart'
      | 'campaign_sent'
      | 'opened_email'
      | 'not_opened_email'
      | 'clicked_email'
      | 'not_clicked_email'
      | 'campaign_specific_clicked'
      | 'manual'
      | 'signup'
      | 'merge_changed'
      | 'group_add'
      | 'group_remove'
      | 'mandrill_sent'
      | 'mandrill_opened'
      | 'mandrill_clicked'
      | 'mandrill_any'
      | 'api'
      | 'goal'
      | 'annual'
      | 'birthday'
      | 'date'
      | 'date_added'
      | 'tag_add';
    /**
     * The user-friendly description of the action that triggers an Automation email.
     */
    readonly action_description?: string;
    /**
     * The delay amount for an Automation email.
     */
    readonly amount?: number;
    /**
     * Whether the delay settings describe before or after the delay action of an Automation email.
     */
    direction?: 'before' | 'after';
    /**
     * The user-friendly description of the delay and trigger action settings for an Automation email.
     */
    readonly full_description?: string;
    /**
     * The type of delay for an Automation email.
     */
    type?: 'now' | 'day' | 'hour' | 'week';
  };
  /**
   * The total number of emails sent for this campaign.
   */
  readonly emails_sent?: number;
  /**
   * Determines if the campaign contains the *|BRAND:LOGO|* merge tag.
   */
  readonly has_logo_merge_tag?: boolean;
  /**
   * A string that uniquely identifies the Automation email.
   */
  readonly id?: string;
  /**
   * Determines if the automation email needs its blocks refreshed by opening the web-based campaign editor.
   */
  readonly needs_block_refresh?: boolean;
  /**
   * The position of an Automation email in a workflow.
   */
  readonly position?: number;
  /**
   * List settings for the campaign.
   */
  recipients?: {
    /**
     * The unique list id.
     */
    list_id?: string;
    /**
     * The status of the list used, namely if it's deleted or disabled.
     */
    readonly list_is_active?: boolean;
    /**
     * The name of the list.
     */
    readonly list_name?: string;
    /**
     * Count of the recipients on the associated list. Formatted as an integer.
     */
    readonly recipient_count?: number;
    /**
     * An object representing all segmentation options. This object should contain a `saved_segment_id` to use an existing segment, or you can create a new segment by including both `match` and `conditions` options.
     */
    segment_opts?: {
      /**
       * Segment match conditions. There are multiple possible types, see the [condition types documentation](https://mailchimp.com/developer/marketing/docs/alternative-schemas/#segment-condition-schemas).
       */
      conditions?: Array<
        | {
            condition_type?: 'Aim';
            /**
             * Segment by interaction with a specific campaign.
             */
            field?: 'aim';
            /**
             * The status of the member with regard to their campaign interaction. One of the following: opened, clicked, was sent, didn't open, didn't click, or was not sent.
             */
            op?: 'open' | 'click' | 'sent' | 'noopen' | 'noclick' | 'nosent';
            /**
             * Either the web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
             */
            value?: string;
          }
        | {
            condition_type?: 'Automation';
            /**
             * Segment by interaction with an Automation workflow.
             */
            field: 'automation';
            /**
             * The status of the member with regard to the automation workflow. One of the following: has started the workflow, has completed the workflow, has not started the workflow, or has not completed the workflow.
             */
            op: 'started' | 'completed' | 'not_started' | 'not_completed';
            /**
             * The web id for the automation workflow to segment against.
             */
            value: string;
          }
        | {
            condition_type?: 'CampaignPoll';
            /**
             * Segment by poll activity.
             */
            field: 'poll';
            /**
             * Members have/have not interacted with a specific poll in a Mailchimp email.
             */
            op: 'member' | 'notmember';
            /**
             * The id for the poll.
             */
            value: number;
          }
        | {
            condition_type?: 'Conversation';
            /**
             * Segment by interaction with a campaign via Conversations.
             */
            field: 'conversation';
            /**
             * The status of a member's interaction with a conversation. One of the following: has replied or has not replied.
             */
            op: 'member' | 'notmember';
            /**
             * The web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
             */
            value: string;
          }
        | {
            condition_type?: 'Date';
            /**
             * When segmenting on 'date' or 'campaign', the date for the segment formatted as YYYY-MM-DD or the web id for the campaign.
             */
            extra?: string;
            /**
             * The type of date field to segment on: The opt-in time for a signup, the date the subscriber was last updated, or the date of their last ecomm purchase.
             */
            field: 'timestamp_opt' | 'info_changed' | 'ecomm_date';
            /**
             * When the event took place:  Before, after, is a specific date, is not a specific date, is blank, or is not blank.
             */
            op: 'greater' | 'less' | 'is' | 'not' | 'blank' | 'blank_not' | 'within' | 'notwithin';
            /**
             * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
             */
            value: string;
          }
        | {
            condition_type?: 'EmailClient';
            /**
             * Segment by use of a particular email client.
             */
            field: 'email_client';
            /**
             * The operation to determine whether we select clients that match the value, or clients that do not match the value.
             */
            op: 'client_is' | 'client_not';
            /**
             * The name of the email client.
             */
            value: string;
          }
        | {
            condition_type?: 'Language';
            /**
             * Segmenting based off of a subscriber's language.
             */
            field: 'language';
            /**
             * Whether the member's language is or is not set to a specific language.
             */
            op: 'is' | 'not';
            /**
             * A two-letter language identifier.
             */
            value: string;
          }
        | {
            condition_type?: 'MemberRating';
            /**
             * Segment by member rating.
             */
            field: 'rating';
            /**
             * Members who have have a rating that is/not exactly a given number or members who have a rating greater/less than a given number.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * The star rating number to segment against.
             */
            value: number;
          }
        | {
            condition_type: 'SignupSource';
            field: 'source';
            /**
             * Whether the member's signup source was/was not a particular value.
             */
            op: 'source_is' | 'source_not';
            /**
             * The signup source.
             */
            value?: string;
          }
        | {
            condition_type?: 'SurveyMonkey';
            /**
             * Segment by interaction with a SurveyMonkey survey.
             */
            field: 'survey_monkey';
            /**
             * The status of the member with regard to the survey.One of the following: has started the survey, has completed the survey, has not started the survey, or has not completed the survey.
             */
            op: 'started' | 'completed' | 'not_started' | 'not_completed';
            /**
             * The unique ID of the survey monkey survey.
             */
            value: string;
          }
        | {
            condition_type?: 'VIP';
            /**
             * Segment by VIP status.
             */
            field: 'gmonkey';
            /**
             * Whether the member is or is not marked as VIP.
             */
            op: 'member' | 'notmember';
          }
        | {
            condition_type?: 'Interests';
            /**
             * Segmenting based on interest group information. This should start with 'interests-' followed by the grouping id. Ex. 'interests-123'.
             */
            field?: string;
            /**
             * Whether the member is a part of one, all, or none of the groups.
             */
            op?: 'interestcontains' | 'interestcontainsall' | 'interestnotcontains';
            /**
             * An array containing strings, each representing a group id.
             */
            value?: Array<string>;
          }
        | {
            condition_type?: 'EcommCategory';
            /**
             * Segment by purchases in specific items or categories.
             */
            field?: 'ecomm_cat' | 'ecomm_prod';
            /**
             * A member who has purchased from a category/specific item that is/is not a specific name, where the category/item name contains/doesn't contain a specific phrase or string, or a category/item name that starts/ends with a string.
             */
            op?: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends';
            /**
             * The ecommerce category/item information.
             */
            value?: string;
          }
        | {
            condition_type?: 'EcommNumber';
            /**
             * Segment by average spent total, number of orders, total number of products purchased, or average number of products per order.
             */
            field: 'ecomm_spent_avg' | 'ecomm_orders' | 'ecomm_prod_all' | 'ecomm_avg_ord';
            /**
             * Members who have spent exactly, have not spent exactly, spent more, or spent less than the segment value.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * Members who have spent exactly, have not spent exactly, spent more, or spent less than this amount.
             */
            value: number;
          }
        | {
            condition_type?: 'EcommPurchased';
            /**
             * Segment by whether someone has purchased anything.
             */
            field?: 'ecomm_purchased';
            /**
             * Members who have have ('member') or have not ('notmember') purchased.
             */
            op?: 'member' | 'notmember';
          }
        | {
            condition_type?: 'EcommSpent';
            /**
             * Segment by amount spent on a single order or across all orders.
             */
            field?: 'ecomm_spent_one' | 'ecomm_spent_all';
            /**
             * Members who have spent 'more' or 'less' than then specified value.
             */
            op?: 'greater' | 'less';
            /**
             * The total amount a member spent.
             */
            value?: number;
          }
        | {
            condition_type?: 'EcommStore';
            /**
             * Segment by purchases from a specific store.
             */
            field?: 'ecomm_store';
            /**
             * Members who have or have not purchased from a specific store.
             */
            op?: 'is' | 'not';
            /**
             * The store id to segment against.
             */
            value?: string;
          }
        | {
            condition_type?: 'GoalActivity';
            /**
             * Segment by Goal activity.
             */
            field: 'goal';
            /**
             * Whether the website URL is/not exactly, contains/doesn't contain, starts with/ends with a string.
             */
            op: 'is' | 'goal_not' | 'contains' | 'goal_notcontain' | 'starts' | 'ends';
            /**
             * The URL to check Goal activity against.
             */
            value: string;
          }
        | {
            condition_type?: 'GoalTimestamp';
            /**
             * Segment by most recent interaction with a website.
             */
            field: 'goal_last_visited';
            /**
             * Whether the website activity happened after, before, or at a given timestamp.
             */
            op: 'greater' | 'less' | 'is';
            /**
             * The date to check Goal activity against.
             */
            value: string;
          }
        | {
            condition_type?: 'FuzzySegment';
            /**
             * Segment by similar subscribers.
             */
            field: 'fuzzy_segment';
            /**
             * Members who are/are not apart of a 'similar subscribers' segment.
             */
            op: 'fuzzy_is' | 'fuzzy_not';
            /**
             * The id for the 'similar subscribers' segment.
             */
            value: number;
          }
        | {
            condition_type?: 'StaticSegment';
            /**
             * Segment by a given static segment.
             */
            field: 'static_segment';
            /**
             * Members who are/are not apart of a static segment.
             */
            op: 'static_is' | 'static_not';
            /**
             * The id for the static segment.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoCountryState';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are within a specific country or US state.
             */
            op: 'ipgeocountry' | 'ipgeonotcountry' | 'ipgeostate' | 'ipgeonotstate';
            /**
             * The two-letter country code or US state abbreviation.
             */
            value: string;
          }
        | {
            /**
             * The address of the target location.
             */
            addr: string;
            condition_type?: 'IPGeoIn';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * The latitude of the target location.
             */
            lat: string;
            /**
             * The longitude of the target location.
             */
            lng: string;
            /**
             * Segment members who are within a specific geographic region.
             */
            op: 'ipgeoin' | 'ipgeonotin';
            /**
             * The radius of the target location.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoInZip';
            /**
             * The zip code to segment against.
             */
            extra: number;
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are within a specific US zip code.
             */
            op: 'ipgeoinzip';
            /**
             * The radius of the target location.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoUnknown';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members for which location information is unknown.
             */
            op: 'ipgeounknown';
          }
        | {
            condition_type?: 'IPGeoZip';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are/are not within a specific US zip code.
             */
            op: 'ipgeoiszip' | 'ipgeonotzip';
            /**
             * The 5-digit zip code.
             */
            value: number;
          }
        | {
            condition_type?: 'SocialAge';
            /**
             * Segment by age ranges in Social Profiles data.
             */
            field: 'social_age';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The age range to segment.
             */
            value: '18-24' | '25-34' | '35-54' | '55+';
          }
        | {
            condition_type?: 'SocialGender';
            /**
             * Segment by listed gender in Social Profiles data.
             */
            field: 'social_gender';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The Social Profiles gender to segment.
             */
            value: 'male' | 'female';
          }
        | {
            condition_type?: 'SocialInfluence';
            /**
             * Segment by influence rating in Social Profiles data.
             */
            field: 'social_influence';
            /**
             * Members who have a rating that is/not or greater/less than the rating provided.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * The Social Profiles influence rating to segment.
             */
            value: number;
          }
        | {
            condition_type?: 'SocialNetworkMember';
            /**
             * Segment by social network in Social Profiles data.
             */
            field: 'social_network';
            /**
             * Members who are/not on a given social network.
             */
            op: 'member' | 'notmember';
            /**
             * The social network to segment against.
             */
            value:
              | 'twitter'
              | 'facebook'
              | 'linkedin'
              | 'flickr'
              | 'foursquare'
              | 'lastfm'
              | 'myspace'
              | 'quora'
              | 'vimeo'
              | 'yelp'
              | 'youtube';
          }
        | {
            condition_type?: 'SocialNetworkFollow';
            /**
             * Segment by social network in Social Profiles data.
             */
            field: 'social_network';
            /**
             * Members who are/not following a linked account on a given social network.
             */
            op: 'follow' | 'notfollow';
            /**
             * The social network to segment against.
             */
            value: 'twitter_follow';
          }
        | {
            condition_type?: 'AddressMerge';
            /**
             * An address-type merge field to segment.
             */
            field: string;
            /**
             * Whether the member's address merge field contains/does not contain a value or is/is not blank.
             */
            op: 'contains' | 'notcontain' | 'blank' | 'blank_not';
            /**
             * The value to segment a text merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'ZipMerge';
            /**
             * The city or the zip being used to segment against.
             */
            extra: string;
            /**
             * An address or zip-type merge field to segment.
             */
            field: string;
            /**
             * Whether the member's address merge field is within a given distance from a city or zip.
             */
            op: 'geoin';
            /**
             * The distance from the city/zip.
             */
            value: string;
          }
        | {
            condition_type?: 'BirthdayMerge';
            /**
             * A date merge field to segment.
             */
            field: string;
            /**
             * Whether the member's birthday merge information is/is not a certain date or is/is not blank.
             */
            op: 'is' | 'not' | 'blank' | 'blank_not';
            /**
             * A date to segment against (mm/dd).
             */
            value?: string;
          }
        | {
            condition_type?: 'DateMerge';
            /**
             * A date merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not, is greater/less than a value or is/is not blank.
             */
            op: 'is' | 'not' | 'less' | 'blank' | 'blank_not' | 'greater';
            /**
             * A date to segment against.
             */
            value?: string;
          }
        | {
            condition_type?: 'SelectMerge';
            /**
             * A merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not a value or is/is not blank.
             */
            op: 'is' | 'not' | 'blank' | 'blank_not' | 'notcontain' | 'contains';
            /**
             * The value to segment a text merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'TextMerge';
            /**
             * A text or number merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not, contains/does not contain, starts/ends with, or is greater/less than a value
             */
            op:
              | 'is'
              | 'not'
              | 'contains'
              | 'notcontain'
              | 'starts'
              | 'ends'
              | 'greater'
              | 'less'
              | 'blank'
              | 'blank_not';
            /**
             * The value to segment a text or number merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'EmailAddress';
            /**
             * Segmenting based off of a subscriber's email address.
             */
            field: 'merge0' | 'EMAIL';
            /**
             * Whether the email address is/not exactly, contains/doesn't contain, starts/ends with a string.
             */
            op: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends' | 'greater' | 'less';
            /**
             * The value to compare the email against.
             */
            value?: string;
          }
        | {
            condition_type?: 'PredictedGender';
            /**
             * Segment by predicted gender.
             */
            field: 'predicted_gender';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The predicted gender to segment.
             */
            value: 'male' | 'female';
          }
        | {
            condition_type?: 'PredictedAge';
            /**
             * Segment by predicted age.
             */
            field: 'predicted_age_range';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is';
            /**
             * The predicted age to segment.
             */
            value: '18-24' | '25-34' | '35-44' | '45-54' | '55-64' | '65+';
          }
        | {
            condition_type?: 'NewSubscribers';
            /**
             * Segment by when people subscribed.
             */
            field?: 'timestamp_opt';
            /**
             * Whe the event took place, namely within a time frame.
             */
            op?: 'date_within';
            /**
             * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
             */
            value?: string;
          }
      >;
      /**
       * Segment match type.
       */
      match?: 'any' | 'all';
      /**
       * The prebuilt segment id, if a prebuilt segment has been designated for this campaign.
       */
      prebuilt_segment_id?: string;
      /**
       * The id for an existing saved segment.
       */
      saved_segment_id?: number;
    };
    /**
     * A description of the [segment](https://mailchimp.com/help/getting-started-with-groups/) used for the campaign. Formatted as a string marked up with HTML.
     */
    readonly segment_text?: string;
  };
  /**
   * For sent campaigns, a summary of opens and clicks.
   */
  report_summary?: {
    /**
     * The number of unique clicks divided by the total number of successful deliveries.
     */
    readonly click_rate?: number;
    /**
     * The total number of clicks for an campaign.
     */
    readonly clicks?: number;
    /**
     * The number of unique opens divided by the total number of successful deliveries.
     */
    readonly open_rate?: number;
    /**
     * The total number of opens for a campaign.
     */
    readonly opens?: number;
    /**
     * The number of unique clicks.
     */
    readonly subscriber_clicks?: number;
    /**
     * The number of unique opens.
     */
    readonly unique_opens?: number;
  };
  /**
   *  The date and time a campaign was sent in ISO 8601 format
   */
  readonly send_time?: string;
  /**
   * Settings for the campaign including the email subject, from name, and from email address.
   */
  settings?: {
    /**
     * Whether Mailchimp [authenticated](https://mailchimp.com/help/about-email-authentication/) the campaign. Defaults to `true`.
     */
    authenticate?: boolean;
    /**
     * An array of [Facebook](https://mailchimp.com/help/connect-or-disconnect-the-facebook-integration/) page ids to auto-post to.
     */
    auto_fb_post?: Array<string>;
    /**
     * Automatically append Mailchimp's [default footer](https://mailchimp.com/help/about-campaign-footers/) to the campaign.
     */
    auto_footer?: boolean;
    /**
     * Automatically tweet a link to the [campaign archive](https://mailchimp.com/help/about-email-campaign-archives-and-pages/) page when the campaign is sent.
     */
    auto_tweet?: boolean;
    /**
     * Whether the campaign uses the drag-and-drop editor.
     */
    readonly drag_and_drop?: boolean;
    /**
     * Allows Facebook comments on the campaign (also force-enables the Campaign Archive toolbar). Defaults to `true`.
     */
    fb_comments?: boolean;
    /**
     * The 'from' name on the campaign (not an email address).
     */
    from_name?: string;
    /**
     * Automatically inline the CSS included with the campaign content.
     */
    inline_css?: boolean;
    /**
     * The preview text for the campaign.
     */
    preview_text?: string;
    /**
     * The reply-to email address for the campaign.
     */
    reply_to?: string;
    /**
     * The subject line for the campaign.
     */
    subject_line?: string;
    /**
     * The id for the template used in this campaign.
     */
    template_id?: number;
    /**
     * The title of the campaign.
     */
    title?: string;
  };
  /**
   * The preview for the campaign, rendered by social networks like Facebook and Twitter. [Learn more](https://mailchimp.com/help/enable-and-customize-social-cards/).
   */
  social_card?: {
    /**
     * A short summary of the campaign to display.
     */
    description?: string;
    /**
     * The url for the header image for the card.
     */
    image_url?: string;
    /**
     * The title for the card. Typically the subject line of the campaign.
     */
    title?: string;
  };
  /**
   * The date and time the campaign was started in ISO 8601 format.
   */
  readonly start_time?: string;
  /**
   * The current status of the campaign.
   */
  readonly status?: 'save' | 'paused' | 'sending';
  /**
   * The tracking options for a campaign.
   */
  tracking?: {
    /**
     * Deprecated
     */
    capsule?: {
      /**
       * Update contact notes for a campaign based on a subscriber's email address.
       */
      notes?: boolean;
    };
    /**
     * The custom slug for [Click Tale](https://mailchimp.com/help/additional-tracking-options-for-campaigns/) tracking (max of 50 bytes).
     */
    clicktale?: string;
    /**
     * Whether to enable e-commerce tracking.
     */
    ecomm360?: boolean;
    /**
     * Deprecated
     */
    goal_tracking?: boolean;
    /**
     * The custom slug for [Google Analytics](https://mailchimp.com/help/integrate-google-analytics-with-mailchimp/) tracking (max of 50 bytes).
     */
    google_analytics?: string;
    /**
     * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the HTML version of the campaign. Defaults to `true`.
     */
    html_clicks?: boolean;
    /**
     * Whether to [track opens](https://mailchimp.com/help/about-open-tracking/). Defaults to `true`.
     */
    opens?: boolean;
    /**
     * Deprecated
     */
    salesforce?: {
      /**
       * Create a campaign in a connected Salesforce account.
       */
      campaign?: boolean;
      /**
       * Update contact notes for a campaign based on a subscriber's email address.
       */
      notes?: boolean;
    };
    /**
     * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the plain-text version of the campaign. Defaults to `true`.
     */
    text_clicks?: boolean;
  };
  /**
   * Available triggers for Automation workflows.
   */
  trigger_settings?: {
    /**
     * A workflow's runtime settings for an Automation.
     */
    runtime?: {
      /**
       * The days an Automation workflow can send.
       */
      days?: Array<'sunday' | 'monday' | 'tuesday' | 'wednesday' | 'thursday' | 'friday' | 'saturday'>;
      /**
       * The hours an Automation workflow can send.
       */
      hours?: {
        /**
         * When to send the Automation email.
         */
        type: 'send_asap' | 'send_between' | 'send_at';
      };
    };
    /**
     * The number of emails in the Automation workflow.
     */
    readonly workflow_emails_count?: number;
    /**
     * The title of the workflow type.
     */
    readonly workflow_title?: string;
    /**
     * The type of Automation workflow.
     */
    workflow_type:
      | 'abandonedBrowse'
      | 'abandonedCart'
      | 'api'
      | 'bestCustomers'
      | 'categoryFollowup'
      | 'dateAdded'
      | 'emailFollowup'
      | 'emailSeries'
      | 'groupAdd'
      | 'groupRemove'
      | 'mandrill'
      | 'productFollowup'
      | 'purchaseFollowup'
      | 'recurringEvent'
      | 'specialEvent'
      | 'visitUrl'
      | 'welcomeSeries';
  };
  /**
   * The ID used in the Mailchimp web application. View this automation in your Mailchimp account at `https://{dc}.admin.mailchimp.com/campaigns/show/?id={web_id}`.
   */
  readonly web_id?: number;
  /**
   * A string that uniquely identifies an Automation workflow.
   */
  readonly workflow_id?: string;
};

export type GetAutomationsIdEmailsIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PatchAutomationEmailWorkflowIdData = {
  body: {
    /**
     * The delay settings for an automation email.
     */
    delay?: {
      /**
       * The action that triggers the delay of an automation emails.
       */
      action: 'signup' | 'ecomm_abandoned_browse' | 'ecomm_abandoned_cart';
      /**
       * The delay amount for an automation email.
       */
      amount?: number;
      /**
       * Whether the delay settings describe before or after the delay action of an automation email.
       */
      direction?: 'after';
      /**
       * The type of delay for an automation email.
       */
      type?: 'now' | 'day' | 'hour' | 'week';
    };
    /**
     * Settings for the campaign including the email subject, from name, and from email address.
     */
    settings?: {
      /**
       * The 'from' name for the Automation (not an email address).
       */
      from_name?: string;
      /**
       * The preview text for the campaign.
       */
      preview_text?: string;
      /**
       * The reply-to email address for the Automation.
       */
      reply_to?: string;
      /**
       * The subject line for the campaign.
       */
      subject_line?: string;
      /**
       * The title of the Automation.
       */
      title?: string;
    };
  };
  path: {
    /**
     * The unique id for the Automation workflow email.
     */
    workflow_email_id: string;
    /**
     * The unique id for the Automation workflow.
     */
    workflow_id: string;
  };
};

export type PatchAutomationEmailWorkflowIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The link to the campaign's archive version in ISO 8601 format.
   */
  readonly archive_url?: string;
  /**
   * How the campaign's content is put together ('template', 'drag_and_drop', 'html', 'url').
   */
  readonly content_type?: string;
  /**
   * The date and time the campaign was created in ISO 8601 format.
   */
  readonly create_time?: string;
  /**
   * The delay settings for an Automation email.
   */
  delay?: {
    /**
     * The action that triggers the delay of an Automation email.
     */
    action?:
      | 'previous_campaign_sent'
      | 'previous_campaign_opened'
      | 'previous_campaign_not_opened'
      | 'previous_campaign_clicked_any'
      | 'previous_campaign_not_clicked_any'
      | 'previous_campaign_specific_clicked'
      | 'ecomm_bought_any'
      | 'ecomm_bought_product'
      | 'ecomm_bought_category'
      | 'ecomm_not_bought_any'
      | 'ecomm_abandoned_cart'
      | 'campaign_sent'
      | 'opened_email'
      | 'not_opened_email'
      | 'clicked_email'
      | 'not_clicked_email'
      | 'campaign_specific_clicked'
      | 'manual'
      | 'signup'
      | 'merge_changed'
      | 'group_add'
      | 'group_remove'
      | 'mandrill_sent'
      | 'mandrill_opened'
      | 'mandrill_clicked'
      | 'mandrill_any'
      | 'api'
      | 'goal'
      | 'annual'
      | 'birthday'
      | 'date'
      | 'date_added'
      | 'tag_add';
    /**
     * The user-friendly description of the action that triggers an Automation email.
     */
    readonly action_description?: string;
    /**
     * The delay amount for an Automation email.
     */
    readonly amount?: number;
    /**
     * Whether the delay settings describe before or after the delay action of an Automation email.
     */
    direction?: 'before' | 'after';
    /**
     * The user-friendly description of the delay and trigger action settings for an Automation email.
     */
    readonly full_description?: string;
    /**
     * The type of delay for an Automation email.
     */
    type?: 'now' | 'day' | 'hour' | 'week';
  };
  /**
   * The total number of emails sent for this campaign.
   */
  readonly emails_sent?: number;
  /**
   * Determines if the campaign contains the *|BRAND:LOGO|* merge tag.
   */
  readonly has_logo_merge_tag?: boolean;
  /**
   * A string that uniquely identifies the Automation email.
   */
  readonly id?: string;
  /**
   * Determines if the automation email needs its blocks refreshed by opening the web-based campaign editor.
   */
  readonly needs_block_refresh?: boolean;
  /**
   * The position of an Automation email in a workflow.
   */
  readonly position?: number;
  /**
   * List settings for the campaign.
   */
  recipients?: {
    /**
     * The unique list id.
     */
    list_id?: string;
    /**
     * The status of the list used, namely if it's deleted or disabled.
     */
    readonly list_is_active?: boolean;
    /**
     * The name of the list.
     */
    readonly list_name?: string;
    /**
     * Count of the recipients on the associated list. Formatted as an integer.
     */
    readonly recipient_count?: number;
    /**
     * An object representing all segmentation options. This object should contain a `saved_segment_id` to use an existing segment, or you can create a new segment by including both `match` and `conditions` options.
     */
    segment_opts?: {
      /**
       * Segment match conditions. There are multiple possible types, see the [condition types documentation](https://mailchimp.com/developer/marketing/docs/alternative-schemas/#segment-condition-schemas).
       */
      conditions?: Array<
        | {
            condition_type?: 'Aim';
            /**
             * Segment by interaction with a specific campaign.
             */
            field?: 'aim';
            /**
             * The status of the member with regard to their campaign interaction. One of the following: opened, clicked, was sent, didn't open, didn't click, or was not sent.
             */
            op?: 'open' | 'click' | 'sent' | 'noopen' | 'noclick' | 'nosent';
            /**
             * Either the web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
             */
            value?: string;
          }
        | {
            condition_type?: 'Automation';
            /**
             * Segment by interaction with an Automation workflow.
             */
            field: 'automation';
            /**
             * The status of the member with regard to the automation workflow. One of the following: has started the workflow, has completed the workflow, has not started the workflow, or has not completed the workflow.
             */
            op: 'started' | 'completed' | 'not_started' | 'not_completed';
            /**
             * The web id for the automation workflow to segment against.
             */
            value: string;
          }
        | {
            condition_type?: 'CampaignPoll';
            /**
             * Segment by poll activity.
             */
            field: 'poll';
            /**
             * Members have/have not interacted with a specific poll in a Mailchimp email.
             */
            op: 'member' | 'notmember';
            /**
             * The id for the poll.
             */
            value: number;
          }
        | {
            condition_type?: 'Conversation';
            /**
             * Segment by interaction with a campaign via Conversations.
             */
            field: 'conversation';
            /**
             * The status of a member's interaction with a conversation. One of the following: has replied or has not replied.
             */
            op: 'member' | 'notmember';
            /**
             * The web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
             */
            value: string;
          }
        | {
            condition_type?: 'Date';
            /**
             * When segmenting on 'date' or 'campaign', the date for the segment formatted as YYYY-MM-DD or the web id for the campaign.
             */
            extra?: string;
            /**
             * The type of date field to segment on: The opt-in time for a signup, the date the subscriber was last updated, or the date of their last ecomm purchase.
             */
            field: 'timestamp_opt' | 'info_changed' | 'ecomm_date';
            /**
             * When the event took place:  Before, after, is a specific date, is not a specific date, is blank, or is not blank.
             */
            op: 'greater' | 'less' | 'is' | 'not' | 'blank' | 'blank_not' | 'within' | 'notwithin';
            /**
             * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
             */
            value: string;
          }
        | {
            condition_type?: 'EmailClient';
            /**
             * Segment by use of a particular email client.
             */
            field: 'email_client';
            /**
             * The operation to determine whether we select clients that match the value, or clients that do not match the value.
             */
            op: 'client_is' | 'client_not';
            /**
             * The name of the email client.
             */
            value: string;
          }
        | {
            condition_type?: 'Language';
            /**
             * Segmenting based off of a subscriber's language.
             */
            field: 'language';
            /**
             * Whether the member's language is or is not set to a specific language.
             */
            op: 'is' | 'not';
            /**
             * A two-letter language identifier.
             */
            value: string;
          }
        | {
            condition_type?: 'MemberRating';
            /**
             * Segment by member rating.
             */
            field: 'rating';
            /**
             * Members who have have a rating that is/not exactly a given number or members who have a rating greater/less than a given number.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * The star rating number to segment against.
             */
            value: number;
          }
        | {
            condition_type: 'SignupSource';
            field: 'source';
            /**
             * Whether the member's signup source was/was not a particular value.
             */
            op: 'source_is' | 'source_not';
            /**
             * The signup source.
             */
            value?: string;
          }
        | {
            condition_type?: 'SurveyMonkey';
            /**
             * Segment by interaction with a SurveyMonkey survey.
             */
            field: 'survey_monkey';
            /**
             * The status of the member with regard to the survey.One of the following: has started the survey, has completed the survey, has not started the survey, or has not completed the survey.
             */
            op: 'started' | 'completed' | 'not_started' | 'not_completed';
            /**
             * The unique ID of the survey monkey survey.
             */
            value: string;
          }
        | {
            condition_type?: 'VIP';
            /**
             * Segment by VIP status.
             */
            field: 'gmonkey';
            /**
             * Whether the member is or is not marked as VIP.
             */
            op: 'member' | 'notmember';
          }
        | {
            condition_type?: 'Interests';
            /**
             * Segmenting based on interest group information. This should start with 'interests-' followed by the grouping id. Ex. 'interests-123'.
             */
            field?: string;
            /**
             * Whether the member is a part of one, all, or none of the groups.
             */
            op?: 'interestcontains' | 'interestcontainsall' | 'interestnotcontains';
            /**
             * An array containing strings, each representing a group id.
             */
            value?: Array<string>;
          }
        | {
            condition_type?: 'EcommCategory';
            /**
             * Segment by purchases in specific items or categories.
             */
            field?: 'ecomm_cat' | 'ecomm_prod';
            /**
             * A member who has purchased from a category/specific item that is/is not a specific name, where the category/item name contains/doesn't contain a specific phrase or string, or a category/item name that starts/ends with a string.
             */
            op?: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends';
            /**
             * The ecommerce category/item information.
             */
            value?: string;
          }
        | {
            condition_type?: 'EcommNumber';
            /**
             * Segment by average spent total, number of orders, total number of products purchased, or average number of products per order.
             */
            field: 'ecomm_spent_avg' | 'ecomm_orders' | 'ecomm_prod_all' | 'ecomm_avg_ord';
            /**
             * Members who have spent exactly, have not spent exactly, spent more, or spent less than the segment value.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * Members who have spent exactly, have not spent exactly, spent more, or spent less than this amount.
             */
            value: number;
          }
        | {
            condition_type?: 'EcommPurchased';
            /**
             * Segment by whether someone has purchased anything.
             */
            field?: 'ecomm_purchased';
            /**
             * Members who have have ('member') or have not ('notmember') purchased.
             */
            op?: 'member' | 'notmember';
          }
        | {
            condition_type?: 'EcommSpent';
            /**
             * Segment by amount spent on a single order or across all orders.
             */
            field?: 'ecomm_spent_one' | 'ecomm_spent_all';
            /**
             * Members who have spent 'more' or 'less' than then specified value.
             */
            op?: 'greater' | 'less';
            /**
             * The total amount a member spent.
             */
            value?: number;
          }
        | {
            condition_type?: 'EcommStore';
            /**
             * Segment by purchases from a specific store.
             */
            field?: 'ecomm_store';
            /**
             * Members who have or have not purchased from a specific store.
             */
            op?: 'is' | 'not';
            /**
             * The store id to segment against.
             */
            value?: string;
          }
        | {
            condition_type?: 'GoalActivity';
            /**
             * Segment by Goal activity.
             */
            field: 'goal';
            /**
             * Whether the website URL is/not exactly, contains/doesn't contain, starts with/ends with a string.
             */
            op: 'is' | 'goal_not' | 'contains' | 'goal_notcontain' | 'starts' | 'ends';
            /**
             * The URL to check Goal activity against.
             */
            value: string;
          }
        | {
            condition_type?: 'GoalTimestamp';
            /**
             * Segment by most recent interaction with a website.
             */
            field: 'goal_last_visited';
            /**
             * Whether the website activity happened after, before, or at a given timestamp.
             */
            op: 'greater' | 'less' | 'is';
            /**
             * The date to check Goal activity against.
             */
            value: string;
          }
        | {
            condition_type?: 'FuzzySegment';
            /**
             * Segment by similar subscribers.
             */
            field: 'fuzzy_segment';
            /**
             * Members who are/are not apart of a 'similar subscribers' segment.
             */
            op: 'fuzzy_is' | 'fuzzy_not';
            /**
             * The id for the 'similar subscribers' segment.
             */
            value: number;
          }
        | {
            condition_type?: 'StaticSegment';
            /**
             * Segment by a given static segment.
             */
            field: 'static_segment';
            /**
             * Members who are/are not apart of a static segment.
             */
            op: 'static_is' | 'static_not';
            /**
             * The id for the static segment.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoCountryState';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are within a specific country or US state.
             */
            op: 'ipgeocountry' | 'ipgeonotcountry' | 'ipgeostate' | 'ipgeonotstate';
            /**
             * The two-letter country code or US state abbreviation.
             */
            value: string;
          }
        | {
            /**
             * The address of the target location.
             */
            addr: string;
            condition_type?: 'IPGeoIn';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * The latitude of the target location.
             */
            lat: string;
            /**
             * The longitude of the target location.
             */
            lng: string;
            /**
             * Segment members who are within a specific geographic region.
             */
            op: 'ipgeoin' | 'ipgeonotin';
            /**
             * The radius of the target location.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoInZip';
            /**
             * The zip code to segment against.
             */
            extra: number;
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are within a specific US zip code.
             */
            op: 'ipgeoinzip';
            /**
             * The radius of the target location.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoUnknown';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members for which location information is unknown.
             */
            op: 'ipgeounknown';
          }
        | {
            condition_type?: 'IPGeoZip';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are/are not within a specific US zip code.
             */
            op: 'ipgeoiszip' | 'ipgeonotzip';
            /**
             * The 5-digit zip code.
             */
            value: number;
          }
        | {
            condition_type?: 'SocialAge';
            /**
             * Segment by age ranges in Social Profiles data.
             */
            field: 'social_age';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The age range to segment.
             */
            value: '18-24' | '25-34' | '35-54' | '55+';
          }
        | {
            condition_type?: 'SocialGender';
            /**
             * Segment by listed gender in Social Profiles data.
             */
            field: 'social_gender';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The Social Profiles gender to segment.
             */
            value: 'male' | 'female';
          }
        | {
            condition_type?: 'SocialInfluence';
            /**
             * Segment by influence rating in Social Profiles data.
             */
            field: 'social_influence';
            /**
             * Members who have a rating that is/not or greater/less than the rating provided.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * The Social Profiles influence rating to segment.
             */
            value: number;
          }
        | {
            condition_type?: 'SocialNetworkMember';
            /**
             * Segment by social network in Social Profiles data.
             */
            field: 'social_network';
            /**
             * Members who are/not on a given social network.
             */
            op: 'member' | 'notmember';
            /**
             * The social network to segment against.
             */
            value:
              | 'twitter'
              | 'facebook'
              | 'linkedin'
              | 'flickr'
              | 'foursquare'
              | 'lastfm'
              | 'myspace'
              | 'quora'
              | 'vimeo'
              | 'yelp'
              | 'youtube';
          }
        | {
            condition_type?: 'SocialNetworkFollow';
            /**
             * Segment by social network in Social Profiles data.
             */
            field: 'social_network';
            /**
             * Members who are/not following a linked account on a given social network.
             */
            op: 'follow' | 'notfollow';
            /**
             * The social network to segment against.
             */
            value: 'twitter_follow';
          }
        | {
            condition_type?: 'AddressMerge';
            /**
             * An address-type merge field to segment.
             */
            field: string;
            /**
             * Whether the member's address merge field contains/does not contain a value or is/is not blank.
             */
            op: 'contains' | 'notcontain' | 'blank' | 'blank_not';
            /**
             * The value to segment a text merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'ZipMerge';
            /**
             * The city or the zip being used to segment against.
             */
            extra: string;
            /**
             * An address or zip-type merge field to segment.
             */
            field: string;
            /**
             * Whether the member's address merge field is within a given distance from a city or zip.
             */
            op: 'geoin';
            /**
             * The distance from the city/zip.
             */
            value: string;
          }
        | {
            condition_type?: 'BirthdayMerge';
            /**
             * A date merge field to segment.
             */
            field: string;
            /**
             * Whether the member's birthday merge information is/is not a certain date or is/is not blank.
             */
            op: 'is' | 'not' | 'blank' | 'blank_not';
            /**
             * A date to segment against (mm/dd).
             */
            value?: string;
          }
        | {
            condition_type?: 'DateMerge';
            /**
             * A date merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not, is greater/less than a value or is/is not blank.
             */
            op: 'is' | 'not' | 'less' | 'blank' | 'blank_not' | 'greater';
            /**
             * A date to segment against.
             */
            value?: string;
          }
        | {
            condition_type?: 'SelectMerge';
            /**
             * A merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not a value or is/is not blank.
             */
            op: 'is' | 'not' | 'blank' | 'blank_not' | 'notcontain' | 'contains';
            /**
             * The value to segment a text merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'TextMerge';
            /**
             * A text or number merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not, contains/does not contain, starts/ends with, or is greater/less than a value
             */
            op:
              | 'is'
              | 'not'
              | 'contains'
              | 'notcontain'
              | 'starts'
              | 'ends'
              | 'greater'
              | 'less'
              | 'blank'
              | 'blank_not';
            /**
             * The value to segment a text or number merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'EmailAddress';
            /**
             * Segmenting based off of a subscriber's email address.
             */
            field: 'merge0' | 'EMAIL';
            /**
             * Whether the email address is/not exactly, contains/doesn't contain, starts/ends with a string.
             */
            op: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends' | 'greater' | 'less';
            /**
             * The value to compare the email against.
             */
            value?: string;
          }
        | {
            condition_type?: 'PredictedGender';
            /**
             * Segment by predicted gender.
             */
            field: 'predicted_gender';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The predicted gender to segment.
             */
            value: 'male' | 'female';
          }
        | {
            condition_type?: 'PredictedAge';
            /**
             * Segment by predicted age.
             */
            field: 'predicted_age_range';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is';
            /**
             * The predicted age to segment.
             */
            value: '18-24' | '25-34' | '35-44' | '45-54' | '55-64' | '65+';
          }
        | {
            condition_type?: 'NewSubscribers';
            /**
             * Segment by when people subscribed.
             */
            field?: 'timestamp_opt';
            /**
             * Whe the event took place, namely within a time frame.
             */
            op?: 'date_within';
            /**
             * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
             */
            value?: string;
          }
      >;
      /**
       * Segment match type.
       */
      match?: 'any' | 'all';
      /**
       * The prebuilt segment id, if a prebuilt segment has been designated for this campaign.
       */
      prebuilt_segment_id?: string;
      /**
       * The id for an existing saved segment.
       */
      saved_segment_id?: number;
    };
    /**
     * A description of the [segment](https://mailchimp.com/help/getting-started-with-groups/) used for the campaign. Formatted as a string marked up with HTML.
     */
    readonly segment_text?: string;
  };
  /**
   * For sent campaigns, a summary of opens and clicks.
   */
  report_summary?: {
    /**
     * The number of unique clicks divided by the total number of successful deliveries.
     */
    readonly click_rate?: number;
    /**
     * The total number of clicks for an campaign.
     */
    readonly clicks?: number;
    /**
     * The number of unique opens divided by the total number of successful deliveries.
     */
    readonly open_rate?: number;
    /**
     * The total number of opens for a campaign.
     */
    readonly opens?: number;
    /**
     * The number of unique clicks.
     */
    readonly subscriber_clicks?: number;
    /**
     * The number of unique opens.
     */
    readonly unique_opens?: number;
  };
  /**
   *  The date and time a campaign was sent in ISO 8601 format
   */
  readonly send_time?: string;
  /**
   * Settings for the campaign including the email subject, from name, and from email address.
   */
  settings?: {
    /**
     * Whether Mailchimp [authenticated](https://mailchimp.com/help/about-email-authentication/) the campaign. Defaults to `true`.
     */
    authenticate?: boolean;
    /**
     * An array of [Facebook](https://mailchimp.com/help/connect-or-disconnect-the-facebook-integration/) page ids to auto-post to.
     */
    auto_fb_post?: Array<string>;
    /**
     * Automatically append Mailchimp's [default footer](https://mailchimp.com/help/about-campaign-footers/) to the campaign.
     */
    auto_footer?: boolean;
    /**
     * Automatically tweet a link to the [campaign archive](https://mailchimp.com/help/about-email-campaign-archives-and-pages/) page when the campaign is sent.
     */
    auto_tweet?: boolean;
    /**
     * Whether the campaign uses the drag-and-drop editor.
     */
    readonly drag_and_drop?: boolean;
    /**
     * Allows Facebook comments on the campaign (also force-enables the Campaign Archive toolbar). Defaults to `true`.
     */
    fb_comments?: boolean;
    /**
     * The 'from' name on the campaign (not an email address).
     */
    from_name?: string;
    /**
     * Automatically inline the CSS included with the campaign content.
     */
    inline_css?: boolean;
    /**
     * The preview text for the campaign.
     */
    preview_text?: string;
    /**
     * The reply-to email address for the campaign.
     */
    reply_to?: string;
    /**
     * The subject line for the campaign.
     */
    subject_line?: string;
    /**
     * The id for the template used in this campaign.
     */
    template_id?: number;
    /**
     * The title of the campaign.
     */
    title?: string;
  };
  /**
   * The preview for the campaign, rendered by social networks like Facebook and Twitter. [Learn more](https://mailchimp.com/help/enable-and-customize-social-cards/).
   */
  social_card?: {
    /**
     * A short summary of the campaign to display.
     */
    description?: string;
    /**
     * The url for the header image for the card.
     */
    image_url?: string;
    /**
     * The title for the card. Typically the subject line of the campaign.
     */
    title?: string;
  };
  /**
   * The date and time the campaign was started in ISO 8601 format.
   */
  readonly start_time?: string;
  /**
   * The current status of the campaign.
   */
  readonly status?: 'save' | 'paused' | 'sending';
  /**
   * The tracking options for a campaign.
   */
  tracking?: {
    /**
     * Deprecated
     */
    capsule?: {
      /**
       * Update contact notes for a campaign based on a subscriber's email address.
       */
      notes?: boolean;
    };
    /**
     * The custom slug for [Click Tale](https://mailchimp.com/help/additional-tracking-options-for-campaigns/) tracking (max of 50 bytes).
     */
    clicktale?: string;
    /**
     * Whether to enable e-commerce tracking.
     */
    ecomm360?: boolean;
    /**
     * Deprecated
     */
    goal_tracking?: boolean;
    /**
     * The custom slug for [Google Analytics](https://mailchimp.com/help/integrate-google-analytics-with-mailchimp/) tracking (max of 50 bytes).
     */
    google_analytics?: string;
    /**
     * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the HTML version of the campaign. Defaults to `true`.
     */
    html_clicks?: boolean;
    /**
     * Whether to [track opens](https://mailchimp.com/help/about-open-tracking/). Defaults to `true`.
     */
    opens?: boolean;
    /**
     * Deprecated
     */
    salesforce?: {
      /**
       * Create a campaign in a connected Salesforce account.
       */
      campaign?: boolean;
      /**
       * Update contact notes for a campaign based on a subscriber's email address.
       */
      notes?: boolean;
    };
    /**
     * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the plain-text version of the campaign. Defaults to `true`.
     */
    text_clicks?: boolean;
  };
  /**
   * Available triggers for Automation workflows.
   */
  trigger_settings?: {
    /**
     * A workflow's runtime settings for an Automation.
     */
    runtime?: {
      /**
       * The days an Automation workflow can send.
       */
      days?: Array<'sunday' | 'monday' | 'tuesday' | 'wednesday' | 'thursday' | 'friday' | 'saturday'>;
      /**
       * The hours an Automation workflow can send.
       */
      hours?: {
        /**
         * When to send the Automation email.
         */
        type: 'send_asap' | 'send_between' | 'send_at';
      };
    };
    /**
     * The number of emails in the Automation workflow.
     */
    readonly workflow_emails_count?: number;
    /**
     * The title of the workflow type.
     */
    readonly workflow_title?: string;
    /**
     * The type of Automation workflow.
     */
    workflow_type:
      | 'abandonedBrowse'
      | 'abandonedCart'
      | 'api'
      | 'bestCustomers'
      | 'categoryFollowup'
      | 'dateAdded'
      | 'emailFollowup'
      | 'emailSeries'
      | 'groupAdd'
      | 'groupRemove'
      | 'mandrill'
      | 'productFollowup'
      | 'purchaseFollowup'
      | 'recurringEvent'
      | 'specialEvent'
      | 'visitUrl'
      | 'welcomeSeries';
  };
  /**
   * The ID used in the Mailchimp web application. View this automation in your Mailchimp account at `https://{dc}.admin.mailchimp.com/campaigns/show/?id={web_id}`.
   */
  readonly web_id?: number;
  /**
   * A string that uniquely identifies an Automation workflow.
   */
  readonly workflow_id?: string;
};

export type PatchAutomationEmailWorkflowIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostAutomationsIdEmailsIdActionsPauseData = {
  path: {
    /**
     * The unique id for the Automation workflow email.
     */
    workflow_email_id: string;
    /**
     * The unique id for the Automation workflow.
     */
    workflow_id: string;
  };
};

export type PostAutomationsIdEmailsIdActionsPauseResponse = any;

export type PostAutomationsIdEmailsIdActionsPauseError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostAutomationsIdEmailsIdActionsStartData = {
  path: {
    /**
     * The unique id for the Automation workflow email.
     */
    workflow_email_id: string;
    /**
     * The unique id for the Automation workflow.
     */
    workflow_id: string;
  };
};

export type PostAutomationsIdEmailsIdActionsStartResponse = any;

export type PostAutomationsIdEmailsIdActionsStartError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetAutomationsIdEmailsIdQueueData = {
  path: {
    /**
     * The unique id for the Automation workflow email.
     */
    workflow_email_id: string;
    /**
     * The unique id for the Automation workflow.
     */
    workflow_id: string;
  };
};

export type GetAutomationsIdEmailsIdQueueResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * A string that uniquely identifies an email in an Automation workflow.
   */
  readonly email_id?: string;
  /**
   * An array of objects, each representing a subscriber queue for an email in an Automation workflow.
   */
  readonly queue?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The list member's email address.
     */
    email_address: string;
    /**
     * A string that uniquely identifies an email in an Automation workflow.
     */
    readonly email_id?: string;
    /**
     * The MD5 hash of the lowercase version of the list member's email address.
     */
    readonly id?: string;
    /**
     * A string that uniquely identifies a list.
     */
    readonly list_id?: string;
    /**
     * The date and time of the next send for the workflow email in ISO 8601 format.
     */
    readonly next_send?: string;
    /**
     * A string that uniquely identifies an Automation workflow.
     */
    readonly workflow_id?: string;
  }>;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
  /**
   * A string that uniquely identifies an Automation workflow.
   */
  readonly workflow_id?: string;
};

export type GetAutomationsIdEmailsIdQueueError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostAutomationsIdEmailsIdQueueData = {
  body: {
    /**
     * The list member's email address.
     */
    email_address: string;
  };
  path: {
    /**
     * The unique id for the Automation workflow email.
     */
    workflow_email_id: string;
    /**
     * The unique id for the Automation workflow.
     */
    workflow_id: string;
  };
};

export type PostAutomationsIdEmailsIdQueueResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The list member's email address.
   */
  email_address?: string;
  /**
   * A string that uniquely identifies an email in an Automation workflow.
   */
  readonly email_id?: string;
  /**
   * The MD5 hash of the lowercase version of the list member's email address.
   */
  readonly id?: string;
  /**
   * A string that uniquely identifies a list.
   */
  readonly list_id?: string;
  /**
   * The status of the list used, namely if it's deleted or disabled.
   */
  readonly list_is_active?: boolean;
  /**
   * The date and time of the next send for the workflow email in ISO 8601 format.
   */
  readonly next_send?: string;
  /**
   * A string that uniquely identifies an Automation workflow.
   */
  readonly workflow_id?: string;
};

export type PostAutomationsIdEmailsIdQueueError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetAutomationsIdEmailsIdQueueIdData = {
  path: {
    /**
     * The MD5 hash of the lowercase version of the list member's email address.
     */
    subscriber_hash: string;
    /**
     * The unique id for the Automation workflow email.
     */
    workflow_email_id: string;
    /**
     * The unique id for the Automation workflow.
     */
    workflow_id: string;
  };
};

export type GetAutomationsIdEmailsIdQueueIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The list member's email address.
   */
  email_address?: string;
  /**
   * A string that uniquely identifies an email in an Automation workflow.
   */
  readonly email_id?: string;
  /**
   * The MD5 hash of the lowercase version of the list member's email address.
   */
  readonly id?: string;
  /**
   * A string that uniquely identifies a list.
   */
  readonly list_id?: string;
  /**
   * The status of the list used, namely if it's deleted or disabled.
   */
  readonly list_is_active?: boolean;
  /**
   * The date and time of the next send for the workflow email in ISO 8601 format.
   */
  readonly next_send?: string;
  /**
   * A string that uniquely identifies an Automation workflow.
   */
  readonly workflow_id?: string;
};

export type GetAutomationsIdEmailsIdQueueIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetAutomationsIdRemovedSubscribersData = {
  path: {
    /**
     * The unique id for the Automation workflow.
     */
    workflow_id: string;
  };
};

export type GetAutomationsIdRemovedSubscribersResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of objects, each representing a subscriber who was removed from an Automation workflow.
   */
  readonly subscribers?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The list member's email address.
     */
    email_address?: string;
    /**
     * The MD5 hash of the lowercase version of the list member's email address.
     */
    readonly id?: string;
    /**
     * A string that uniquely identifies a list.
     */
    readonly list_id?: string;
    /**
     * A string that uniquely identifies an Automation workflow.
     */
    readonly workflow_id?: string;
  }>;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
  /**
   * A string that uniquely identifies an Automation workflow.
   */
  readonly workflow_id?: string;
};

export type GetAutomationsIdRemovedSubscribersError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostAutomationsIdRemovedSubscribersData = {
  body: {
    /**
     * The list member's email address.
     */
    email_address: string;
  };
  path: {
    /**
     * The unique id for the Automation workflow.
     */
    workflow_id: string;
  };
};

export type PostAutomationsIdRemovedSubscribersResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The list member's email address.
   */
  email_address?: string;
  /**
   * The MD5 hash of the lowercase version of the list member's email address.
   */
  readonly id?: string;
  /**
   * A string that uniquely identifies a list.
   */
  readonly list_id?: string;
  /**
   * A string that uniquely identifies an Automation workflow.
   */
  readonly workflow_id?: string;
};

export type PostAutomationsIdRemovedSubscribersError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetAutomationsIdRemovedSubscribersIdData = {
  path: {
    /**
     * The MD5 hash of the lowercase version of the list member's email address.
     */
    subscriber_hash: string;
    /**
     * The unique id for the Automation workflow.
     */
    workflow_id: string;
  };
};

export type GetAutomationsIdRemovedSubscribersIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The list member's email address.
   */
  email_address?: string;
  /**
   * The MD5 hash of the lowercase version of the list member's email address.
   */
  readonly id?: string;
  /**
   * A string that uniquely identifies a list.
   */
  readonly list_id?: string;
  /**
   * A string that uniquely identifies an Automation workflow.
   */
  readonly workflow_id?: string;
};

export type GetAutomationsIdRemovedSubscribersIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetBatchWebhooksData = {
  query?: {
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
  };
};

export type GetBatchWebhooksResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
  /**
   * An array of objects, each representing a Batch Webhook.
   */
  webhooks?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * Whether the webhook receives requests or not.
     */
    enabled?: boolean;
    /**
     * A string that uniquely identifies this Batch Webhook.
     */
    readonly id?: string;
    /**
     * A valid URL for the Webhook.
     */
    url?: string;
  }>;
};

export type GetBatchWebhooksError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostBatchWebhooksData = {
  body: {
    /**
     * Whether the webhook receives requests or not.
     */
    enabled?: boolean;
    /**
     * A valid URL for the Webhook.
     */
    url: string;
  };
};

export type PostBatchWebhooksResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * Whether the webhook receives requests or not.
   */
  enabled?: boolean;
  /**
   * A string that uniquely identifies this Batch Webhook.
   */
  readonly id?: string;
  /**
   * A valid URL for the Webhook.
   */
  url?: string;
};

export type PostBatchWebhooksError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type DeleteBatchWebhookIdData = {
  path: {
    /**
     * The unique id for the batch webhook.
     */
    batch_webhook_id: string;
  };
};

export type DeleteBatchWebhookIdResponse = any;

export type DeleteBatchWebhookIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetBatchWebhookData = {
  path: {
    /**
     * The unique id for the batch webhook.
     */
    batch_webhook_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetBatchWebhookResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * Whether the webhook receives requests or not.
   */
  enabled?: boolean;
  /**
   * A string that uniquely identifies this Batch Webhook.
   */
  readonly id?: string;
  /**
   * A valid URL for the Webhook.
   */
  url?: string;
};

export type GetBatchWebhookError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PatchBatchWebhooksData = {
  body: {
    /**
     * Whether the webhook receives requests or not.
     */
    enabled?: boolean;
    /**
     * A valid URL for the Webhook.
     */
    url?: string;
  };
  path: {
    /**
     * The unique id for the batch webhook.
     */
    batch_webhook_id: string;
  };
};

export type PatchBatchWebhooksResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * Whether the webhook receives requests or not.
   */
  enabled?: boolean;
  /**
   * A string that uniquely identifies this Batch Webhook.
   */
  readonly id?: string;
  /**
   * A valid URL for the Webhook.
   */
  url?: string;
};

export type PatchBatchWebhooksError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetBatchesData = {
  query?: {
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
  };
};

export type GetBatchesResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of objects representing batch calls.
   */
  batches?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The date and time when all operations in the batch request completed in ISO 8601 format.
     */
    readonly completed_at?: string;
    /**
     * The number of completed operations that returned an error.
     */
    readonly errored_operations?: number;
    /**
     * The number of completed operations. This includes operations that returned an error.
     */
    readonly finished_operations?: number;
    /**
     * A string that uniquely identifies this batch request.
     */
    readonly id?: string;
    /**
     * The URL of the gzipped archive of the results of all the operations.
     */
    readonly response_body_url?: string;
    /**
     * The status of the batch call. [Learn more](https://mailchimp.com/developer/marketing/guides/run-async-requests-batch-endpoint/#check-the-status-of-a-batch-operation) about the batch operation status.
     */
    readonly status?: 'pending' | 'preprocessing' | 'started' | 'finalizing' | 'finished';
    /**
     * The date and time when the server received the batch request in ISO 8601 format.
     */
    readonly submitted_at?: string;
    /**
     * The total number of operations to complete as part of this batch request. For GET requests requiring pagination, each page counts as a separate operation.
     */
    readonly total_operations?: number;
  }>;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetBatchesError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostBatchesData = {
  body: {
    /**
     * An array of objects that describes operations to perform.
     */
    operations: Array<{
      /**
       * A string containing the JSON body to use with the request.
       */
      body?: string;
      /**
       * The HTTP method to use for the operation.
       */
      method: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE';
      /**
       * An optional client-supplied id returned with the operation results.
       */
      operation_id?: string;
      /**
       * Any request query parameters. Example parameters: {"count":10, "offset":0}
       */
      params?: {
        [key: string]: unknown;
      };
      /**
       * The relative path to use for the operation.
       */
      path: string;
    }>;
  };
};

export type PostBatchesResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The date and time when all operations in the batch request completed in ISO 8601 format.
   */
  readonly completed_at?: string;
  /**
   * The number of completed operations that returned an error.
   */
  readonly errored_operations?: number;
  /**
   * The number of completed operations. This includes operations that returned an error.
   */
  readonly finished_operations?: number;
  /**
   * A string that uniquely identifies this batch request.
   */
  readonly id?: string;
  /**
   * The URL of the gzipped archive of the results of all the operations.
   */
  readonly response_body_url?: string;
  /**
   * The status of the batch call. [Learn more](https://mailchimp.com/developer/marketing/guides/run-async-requests-batch-endpoint/#check-the-status-of-a-batch-operation) about the batch operation status.
   */
  readonly status?: 'pending' | 'preprocessing' | 'started' | 'finalizing' | 'finished';
  /**
   * The date and time when the server received the batch request in ISO 8601 format.
   */
  readonly submitted_at?: string;
  /**
   * The total number of operations to complete as part of this batch request. For GET requests requiring pagination, each page counts as a separate operation.
   */
  readonly total_operations?: number;
};

export type PostBatchesError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type DeleteBatchesIdData = {
  path: {
    /**
     * The unique id for the batch operation.
     */
    batch_id: string;
  };
};

export type DeleteBatchesIdResponse = any;

export type DeleteBatchesIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetBatchesIdData = {
  path: {
    /**
     * The unique id for the batch operation.
     */
    batch_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetBatchesIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The date and time when all operations in the batch request completed in ISO 8601 format.
   */
  readonly completed_at?: string;
  /**
   * The number of completed operations that returned an error.
   */
  readonly errored_operations?: number;
  /**
   * The number of completed operations. This includes operations that returned an error.
   */
  readonly finished_operations?: number;
  /**
   * A string that uniquely identifies this batch request.
   */
  readonly id?: string;
  /**
   * The URL of the gzipped archive of the results of all the operations.
   */
  readonly response_body_url?: string;
  /**
   * The status of the batch call. [Learn more](https://mailchimp.com/developer/marketing/guides/run-async-requests-batch-endpoint/#check-the-status-of-a-batch-operation) about the batch operation status.
   */
  readonly status?: 'pending' | 'preprocessing' | 'started' | 'finalizing' | 'finished';
  /**
   * The date and time when the server received the batch request in ISO 8601 format.
   */
  readonly submitted_at?: string;
  /**
   * The total number of operations to complete as part of this batch request. For GET requests requiring pagination, each page counts as a separate operation.
   */
  readonly total_operations?: number;
};

export type GetBatchesIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetCampaignFoldersData = {
  query?: {
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
  };
};

export type GetCampaignFoldersResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of objects representing campaign folders.
   */
  folders?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The number of campaigns in the folder.
     */
    readonly count?: number;
    /**
     * A string that uniquely identifies this campaign folder.
     */
    readonly id?: string;
    /**
     * The name of the folder.
     */
    name?: string;
  }>;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetCampaignFoldersError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostCampaignFoldersData = {
  body: {
    /**
     * Name to associate with the folder.
     */
    name: string;
  };
};

export type PostCampaignFoldersResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The number of campaigns in the folder.
   */
  readonly count?: number;
  /**
   * A string that uniquely identifies this campaign folder.
   */
  readonly id?: string;
  /**
   * The name of the folder.
   */
  name?: string;
};

export type PostCampaignFoldersError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type DeleteCampaignFoldersIdData = {
  path: {
    /**
     * The unique id for the campaign folder.
     */
    folder_id: string;
  };
};

export type DeleteCampaignFoldersIdResponse = any;

export type DeleteCampaignFoldersIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetCampaignFoldersIdData = {
  path: {
    /**
     * The unique id for the campaign folder.
     */
    folder_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetCampaignFoldersIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The number of campaigns in the folder.
   */
  readonly count?: number;
  /**
   * A string that uniquely identifies this campaign folder.
   */
  readonly id?: string;
  /**
   * The name of the folder.
   */
  name?: string;
};

export type GetCampaignFoldersIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PatchCampaignFoldersIdData = {
  body: {
    /**
     * Name to associate with the folder.
     */
    name: string;
  };
  path: {
    /**
     * The unique id for the campaign folder.
     */
    folder_id: string;
  };
};

export type PatchCampaignFoldersIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The number of campaigns in the folder.
   */
  readonly count?: number;
  /**
   * A string that uniquely identifies this campaign folder.
   */
  readonly id?: string;
  /**
   * The name of the folder.
   */
  name?: string;
};

export type PatchCampaignFoldersIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetCampaignsData = {
  query?: {
    /**
     * Restrict the response to campaigns created before the set time. Uses ISO 8601 time format: 2015-10-21T15:41:36+00:00.
     */
    before_create_time?: string;
    /**
     * Restrict the response to campaigns sent before the set time. Uses ISO 8601 time format: 2015-10-21T15:41:36+00:00.
     */
    before_send_time?: string;
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * The unique folder id.
     */
    folder_id?: string;
    /**
     * The unique id for the list.
     */
    list_id?: string;
    /**
     * Retrieve campaigns sent to a particular list member. Member ID is The MD5 hash of the lowercase version of the list member’s email address.
     */
    member_id?: string;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
    /**
     * Restrict the response to campaigns created after the set time. Uses ISO 8601 time format: 2015-10-21T15:41:36+00:00.
     */
    since_create_time?: string;
    /**
     * Restrict the response to campaigns sent after the set time. Uses ISO 8601 time format: 2015-10-21T15:41:36+00:00.
     */
    since_send_time?: string;
    /**
     * Determines the order direction for sorted results.
     */
    sort_dir?: 'ASC' | 'DESC';
    /**
     * Returns files sorted by the specified field.
     */
    sort_field?: 'create_time' | 'send_time';
    /**
     * The status of the campaign.
     */
    status?: 'save' | 'paused' | 'schedule' | 'sending' | 'sent';
    /**
     * The campaign type.
     */
    type?: 'regular' | 'plaintext' | 'absplit' | 'rss' | 'variate';
  };
};

export type GetCampaignsResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of campaigns.
   */
  campaigns?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * [A/B Testing](https://mailchimp.com/help/about-ab-testing-campaigns/) options for a campaign.
     */
    readonly ab_split_opts?: {
      /**
       * For campaigns split on 'From Name', the name for Group A.
       */
      from_name_a?: string;
      /**
       * For campaigns split on 'From Name', the name for Group B.
       */
      from_name_b?: string;
      /**
       * How we should evaluate a winner. Based on 'opens', 'clicks', or 'manual'.
       */
      pick_winner?: 'opens' | 'clicks' | 'manual';
      /**
       * For campaigns split on 'From Name', the reply-to address for Group A.
       */
      reply_email_a?: string;
      /**
       * For campaigns split on 'From Name', the reply-to address for Group B.
       */
      reply_email_b?: string;
      /**
       * The send time for Group A.
       */
      send_time_a?: string;
      /**
       * The send time for Group B.
       */
      send_time_b?: string;
      /**
       * The send time for the winning version.
       */
      send_time_winner?: string;
      /**
       * The size of the split groups. Campaigns split based on 'schedule' are forced to have a 50/50 split. Valid split integers are between 1-50.
       */
      split_size?: number;
      /**
       * The type of AB split to run.
       */
      split_test?: 'subject' | 'from_name' | 'schedule';
      /**
       * For campaigns split on 'Subject Line', the subject line for Group A.
       */
      subject_a?: string;
      /**
       * For campaigns split on 'Subject Line', the subject line for Group B.
       */
      subject_b?: string;
      /**
       * The amount of time to wait before picking a winner. This cannot be changed after a campaign is sent.
       */
      wait_time?: number;
      /**
       * How unit of time for measuring the winner ('hours' or 'days'). This cannot be changed after a campaign is sent.
       */
      wait_units?: 'hours' | 'days';
    };
    /**
     * The link to the campaign's archive version in ISO 8601 format.
     */
    readonly archive_url?: string;
    /**
     * How the campaign's content is put together.
     */
    content_type?: 'template' | 'html' | 'url' | 'multichannel';
    /**
     * The date and time the campaign was created in ISO 8601 format.
     */
    readonly create_time?: string;
    /**
     * Updates on campaigns in the process of sending.
     */
    delivery_status?: {
      /**
       * Whether a campaign send can be canceled.
       */
      readonly can_cancel?: boolean;
      /**
       * The total number of emails canceled for this campaign.
       */
      readonly emails_canceled?: number;
      /**
       * The total number of emails confirmed sent for this campaign so far.
       */
      readonly emails_sent?: number;
      /**
       * Whether Campaign Delivery Status is enabled for this account and campaign.
       */
      readonly enabled?: boolean;
      /**
       * The current state of a campaign delivery.
       */
      readonly status?: 'delivering' | 'delivered' | 'canceling' | 'canceled';
    };
    /**
     * The total number of emails sent for this campaign.
     */
    readonly emails_sent?: number;
    /**
     * A string that uniquely identifies this campaign.
     */
    readonly id?: string;
    /**
     * The original link to the campaign's archive version.
     */
    readonly long_archive_url?: string;
    /**
     * Determines if the campaign needs its blocks refreshed by opening the web-based campaign editor. Deprecated and will always return false.
     */
    readonly needs_block_refresh?: boolean;
    /**
     * If this campaign is the child of another campaign, this identifies the parent campaign. For Example, for RSS or Automation children.
     */
    readonly parent_campaign_id?: string;
    /**
     * List settings for the campaign.
     */
    recipients?: {
      /**
       * The unique list id.
       */
      list_id?: string;
      /**
       * The status of the list used, namely if it's deleted or disabled.
       */
      readonly list_is_active?: boolean;
      /**
       * The name of the list.
       */
      readonly list_name?: string;
      /**
       * Count of the recipients on the associated list. Formatted as an integer.
       */
      readonly recipient_count?: number;
      /**
       * An object representing all segmentation options. This object should contain a `saved_segment_id` to use an existing segment, or you can create a new segment by including both `match` and `conditions` options.
       */
      segment_opts?: {
        /**
         * Segment match conditions. There are multiple possible types, see the [condition types documentation](https://mailchimp.com/developer/marketing/docs/alternative-schemas/#segment-condition-schemas).
         */
        conditions?: Array<
          | {
              condition_type?: 'Aim';
              /**
               * Segment by interaction with a specific campaign.
               */
              field?: 'aim';
              /**
               * The status of the member with regard to their campaign interaction. One of the following: opened, clicked, was sent, didn't open, didn't click, or was not sent.
               */
              op?: 'open' | 'click' | 'sent' | 'noopen' | 'noclick' | 'nosent';
              /**
               * Either the web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
               */
              value?: string;
            }
          | {
              condition_type?: 'Automation';
              /**
               * Segment by interaction with an Automation workflow.
               */
              field: 'automation';
              /**
               * The status of the member with regard to the automation workflow. One of the following: has started the workflow, has completed the workflow, has not started the workflow, or has not completed the workflow.
               */
              op: 'started' | 'completed' | 'not_started' | 'not_completed';
              /**
               * The web id for the automation workflow to segment against.
               */
              value: string;
            }
          | {
              condition_type?: 'CampaignPoll';
              /**
               * Segment by poll activity.
               */
              field: 'poll';
              /**
               * Members have/have not interacted with a specific poll in a Mailchimp email.
               */
              op: 'member' | 'notmember';
              /**
               * The id for the poll.
               */
              value: number;
            }
          | {
              condition_type?: 'Conversation';
              /**
               * Segment by interaction with a campaign via Conversations.
               */
              field: 'conversation';
              /**
               * The status of a member's interaction with a conversation. One of the following: has replied or has not replied.
               */
              op: 'member' | 'notmember';
              /**
               * The web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
               */
              value: string;
            }
          | {
              condition_type?: 'Date';
              /**
               * When segmenting on 'date' or 'campaign', the date for the segment formatted as YYYY-MM-DD or the web id for the campaign.
               */
              extra?: string;
              /**
               * The type of date field to segment on: The opt-in time for a signup, the date the subscriber was last updated, or the date of their last ecomm purchase.
               */
              field: 'timestamp_opt' | 'info_changed' | 'ecomm_date';
              /**
               * When the event took place:  Before, after, is a specific date, is not a specific date, is blank, or is not blank.
               */
              op: 'greater' | 'less' | 'is' | 'not' | 'blank' | 'blank_not' | 'within' | 'notwithin';
              /**
               * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
               */
              value: string;
            }
          | {
              condition_type?: 'EmailClient';
              /**
               * Segment by use of a particular email client.
               */
              field: 'email_client';
              /**
               * The operation to determine whether we select clients that match the value, or clients that do not match the value.
               */
              op: 'client_is' | 'client_not';
              /**
               * The name of the email client.
               */
              value: string;
            }
          | {
              condition_type?: 'Language';
              /**
               * Segmenting based off of a subscriber's language.
               */
              field: 'language';
              /**
               * Whether the member's language is or is not set to a specific language.
               */
              op: 'is' | 'not';
              /**
               * A two-letter language identifier.
               */
              value: string;
            }
          | {
              condition_type?: 'MemberRating';
              /**
               * Segment by member rating.
               */
              field: 'rating';
              /**
               * Members who have have a rating that is/not exactly a given number or members who have a rating greater/less than a given number.
               */
              op: 'is' | 'not' | 'greater' | 'less';
              /**
               * The star rating number to segment against.
               */
              value: number;
            }
          | {
              condition_type: 'SignupSource';
              field: 'source';
              /**
               * Whether the member's signup source was/was not a particular value.
               */
              op: 'source_is' | 'source_not';
              /**
               * The signup source.
               */
              value?: string;
            }
          | {
              condition_type?: 'SurveyMonkey';
              /**
               * Segment by interaction with a SurveyMonkey survey.
               */
              field: 'survey_monkey';
              /**
               * The status of the member with regard to the survey.One of the following: has started the survey, has completed the survey, has not started the survey, or has not completed the survey.
               */
              op: 'started' | 'completed' | 'not_started' | 'not_completed';
              /**
               * The unique ID of the survey monkey survey.
               */
              value: string;
            }
          | {
              condition_type?: 'VIP';
              /**
               * Segment by VIP status.
               */
              field: 'gmonkey';
              /**
               * Whether the member is or is not marked as VIP.
               */
              op: 'member' | 'notmember';
            }
          | {
              condition_type?: 'Interests';
              /**
               * Segmenting based on interest group information. This should start with 'interests-' followed by the grouping id. Ex. 'interests-123'.
               */
              field?: string;
              /**
               * Whether the member is a part of one, all, or none of the groups.
               */
              op?: 'interestcontains' | 'interestcontainsall' | 'interestnotcontains';
              /**
               * An array containing strings, each representing a group id.
               */
              value?: Array<string>;
            }
          | {
              condition_type?: 'EcommCategory';
              /**
               * Segment by purchases in specific items or categories.
               */
              field?: 'ecomm_cat' | 'ecomm_prod';
              /**
               * A member who has purchased from a category/specific item that is/is not a specific name, where the category/item name contains/doesn't contain a specific phrase or string, or a category/item name that starts/ends with a string.
               */
              op?: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends';
              /**
               * The ecommerce category/item information.
               */
              value?: string;
            }
          | {
              condition_type?: 'EcommNumber';
              /**
               * Segment by average spent total, number of orders, total number of products purchased, or average number of products per order.
               */
              field: 'ecomm_spent_avg' | 'ecomm_orders' | 'ecomm_prod_all' | 'ecomm_avg_ord';
              /**
               * Members who have spent exactly, have not spent exactly, spent more, or spent less than the segment value.
               */
              op: 'is' | 'not' | 'greater' | 'less';
              /**
               * Members who have spent exactly, have not spent exactly, spent more, or spent less than this amount.
               */
              value: number;
            }
          | {
              condition_type?: 'EcommPurchased';
              /**
               * Segment by whether someone has purchased anything.
               */
              field?: 'ecomm_purchased';
              /**
               * Members who have have ('member') or have not ('notmember') purchased.
               */
              op?: 'member' | 'notmember';
            }
          | {
              condition_type?: 'EcommSpent';
              /**
               * Segment by amount spent on a single order or across all orders.
               */
              field?: 'ecomm_spent_one' | 'ecomm_spent_all';
              /**
               * Members who have spent 'more' or 'less' than then specified value.
               */
              op?: 'greater' | 'less';
              /**
               * The total amount a member spent.
               */
              value?: number;
            }
          | {
              condition_type?: 'EcommStore';
              /**
               * Segment by purchases from a specific store.
               */
              field?: 'ecomm_store';
              /**
               * Members who have or have not purchased from a specific store.
               */
              op?: 'is' | 'not';
              /**
               * The store id to segment against.
               */
              value?: string;
            }
          | {
              condition_type?: 'GoalActivity';
              /**
               * Segment by Goal activity.
               */
              field: 'goal';
              /**
               * Whether the website URL is/not exactly, contains/doesn't contain, starts with/ends with a string.
               */
              op: 'is' | 'goal_not' | 'contains' | 'goal_notcontain' | 'starts' | 'ends';
              /**
               * The URL to check Goal activity against.
               */
              value: string;
            }
          | {
              condition_type?: 'GoalTimestamp';
              /**
               * Segment by most recent interaction with a website.
               */
              field: 'goal_last_visited';
              /**
               * Whether the website activity happened after, before, or at a given timestamp.
               */
              op: 'greater' | 'less' | 'is';
              /**
               * The date to check Goal activity against.
               */
              value: string;
            }
          | {
              condition_type?: 'FuzzySegment';
              /**
               * Segment by similar subscribers.
               */
              field: 'fuzzy_segment';
              /**
               * Members who are/are not apart of a 'similar subscribers' segment.
               */
              op: 'fuzzy_is' | 'fuzzy_not';
              /**
               * The id for the 'similar subscribers' segment.
               */
              value: number;
            }
          | {
              condition_type?: 'StaticSegment';
              /**
               * Segment by a given static segment.
               */
              field: 'static_segment';
              /**
               * Members who are/are not apart of a static segment.
               */
              op: 'static_is' | 'static_not';
              /**
               * The id for the static segment.
               */
              value: number;
            }
          | {
              condition_type?: 'IPGeoCountryState';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members who are within a specific country or US state.
               */
              op: 'ipgeocountry' | 'ipgeonotcountry' | 'ipgeostate' | 'ipgeonotstate';
              /**
               * The two-letter country code or US state abbreviation.
               */
              value: string;
            }
          | {
              /**
               * The address of the target location.
               */
              addr: string;
              condition_type?: 'IPGeoIn';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * The latitude of the target location.
               */
              lat: string;
              /**
               * The longitude of the target location.
               */
              lng: string;
              /**
               * Segment members who are within a specific geographic region.
               */
              op: 'ipgeoin' | 'ipgeonotin';
              /**
               * The radius of the target location.
               */
              value: number;
            }
          | {
              condition_type?: 'IPGeoInZip';
              /**
               * The zip code to segment against.
               */
              extra: number;
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members who are within a specific US zip code.
               */
              op: 'ipgeoinzip';
              /**
               * The radius of the target location.
               */
              value: number;
            }
          | {
              condition_type?: 'IPGeoUnknown';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members for which location information is unknown.
               */
              op: 'ipgeounknown';
            }
          | {
              condition_type?: 'IPGeoZip';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members who are/are not within a specific US zip code.
               */
              op: 'ipgeoiszip' | 'ipgeonotzip';
              /**
               * The 5-digit zip code.
               */
              value: number;
            }
          | {
              condition_type?: 'SocialAge';
              /**
               * Segment by age ranges in Social Profiles data.
               */
              field: 'social_age';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is' | 'not';
              /**
               * The age range to segment.
               */
              value: '18-24' | '25-34' | '35-54' | '55+';
            }
          | {
              condition_type?: 'SocialGender';
              /**
               * Segment by listed gender in Social Profiles data.
               */
              field: 'social_gender';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is' | 'not';
              /**
               * The Social Profiles gender to segment.
               */
              value: 'male' | 'female';
            }
          | {
              condition_type?: 'SocialInfluence';
              /**
               * Segment by influence rating in Social Profiles data.
               */
              field: 'social_influence';
              /**
               * Members who have a rating that is/not or greater/less than the rating provided.
               */
              op: 'is' | 'not' | 'greater' | 'less';
              /**
               * The Social Profiles influence rating to segment.
               */
              value: number;
            }
          | {
              condition_type?: 'SocialNetworkMember';
              /**
               * Segment by social network in Social Profiles data.
               */
              field: 'social_network';
              /**
               * Members who are/not on a given social network.
               */
              op: 'member' | 'notmember';
              /**
               * The social network to segment against.
               */
              value:
                | 'twitter'
                | 'facebook'
                | 'linkedin'
                | 'flickr'
                | 'foursquare'
                | 'lastfm'
                | 'myspace'
                | 'quora'
                | 'vimeo'
                | 'yelp'
                | 'youtube';
            }
          | {
              condition_type?: 'SocialNetworkFollow';
              /**
               * Segment by social network in Social Profiles data.
               */
              field: 'social_network';
              /**
               * Members who are/not following a linked account on a given social network.
               */
              op: 'follow' | 'notfollow';
              /**
               * The social network to segment against.
               */
              value: 'twitter_follow';
            }
          | {
              condition_type?: 'AddressMerge';
              /**
               * An address-type merge field to segment.
               */
              field: string;
              /**
               * Whether the member's address merge field contains/does not contain a value or is/is not blank.
               */
              op: 'contains' | 'notcontain' | 'blank' | 'blank_not';
              /**
               * The value to segment a text merge field with.
               */
              value?: string;
            }
          | {
              condition_type?: 'ZipMerge';
              /**
               * The city or the zip being used to segment against.
               */
              extra: string;
              /**
               * An address or zip-type merge field to segment.
               */
              field: string;
              /**
               * Whether the member's address merge field is within a given distance from a city or zip.
               */
              op: 'geoin';
              /**
               * The distance from the city/zip.
               */
              value: string;
            }
          | {
              condition_type?: 'BirthdayMerge';
              /**
               * A date merge field to segment.
               */
              field: string;
              /**
               * Whether the member's birthday merge information is/is not a certain date or is/is not blank.
               */
              op: 'is' | 'not' | 'blank' | 'blank_not';
              /**
               * A date to segment against (mm/dd).
               */
              value?: string;
            }
          | {
              condition_type?: 'DateMerge';
              /**
               * A date merge field to segment.
               */
              field: string;
              /**
               * Whether the member's merge information is/is not, is greater/less than a value or is/is not blank.
               */
              op: 'is' | 'not' | 'less' | 'blank' | 'blank_not' | 'greater';
              /**
               * A date to segment against.
               */
              value?: string;
            }
          | {
              condition_type?: 'SelectMerge';
              /**
               * A merge field to segment.
               */
              field: string;
              /**
               * Whether the member's merge information is/is not a value or is/is not blank.
               */
              op: 'is' | 'not' | 'blank' | 'blank_not' | 'notcontain' | 'contains';
              /**
               * The value to segment a text merge field with.
               */
              value?: string;
            }
          | {
              condition_type?: 'TextMerge';
              /**
               * A text or number merge field to segment.
               */
              field: string;
              /**
               * Whether the member's merge information is/is not, contains/does not contain, starts/ends with, or is greater/less than a value
               */
              op:
                | 'is'
                | 'not'
                | 'contains'
                | 'notcontain'
                | 'starts'
                | 'ends'
                | 'greater'
                | 'less'
                | 'blank'
                | 'blank_not';
              /**
               * The value to segment a text or number merge field with.
               */
              value?: string;
            }
          | {
              condition_type?: 'EmailAddress';
              /**
               * Segmenting based off of a subscriber's email address.
               */
              field: 'merge0' | 'EMAIL';
              /**
               * Whether the email address is/not exactly, contains/doesn't contain, starts/ends with a string.
               */
              op: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends' | 'greater' | 'less';
              /**
               * The value to compare the email against.
               */
              value?: string;
            }
          | {
              condition_type?: 'PredictedGender';
              /**
               * Segment by predicted gender.
               */
              field: 'predicted_gender';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is' | 'not';
              /**
               * The predicted gender to segment.
               */
              value: 'male' | 'female';
            }
          | {
              condition_type?: 'PredictedAge';
              /**
               * Segment by predicted age.
               */
              field: 'predicted_age_range';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is';
              /**
               * The predicted age to segment.
               */
              value: '18-24' | '25-34' | '35-44' | '45-54' | '55-64' | '65+';
            }
          | {
              condition_type?: 'NewSubscribers';
              /**
               * Segment by when people subscribed.
               */
              field?: 'timestamp_opt';
              /**
               * Whe the event took place, namely within a time frame.
               */
              op?: 'date_within';
              /**
               * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
               */
              value?: string;
            }
        >;
        /**
         * Segment match type.
         */
        match?: 'any' | 'all';
        /**
         * The prebuilt segment id, if a prebuilt segment has been designated for this campaign.
         */
        prebuilt_segment_id?: string;
        /**
         * The id for an existing saved segment.
         */
        saved_segment_id?: number;
      };
      /**
       * A description of the [segment](https://mailchimp.com/help/create-and-send-to-a-segment/) used for the campaign. Formatted as a string marked up with HTML.
       */
      readonly segment_text?: string;
    };
    /**
     * For sent campaigns, a summary of opens, clicks, and e-commerce data.
     */
    report_summary?: {
      /**
       * The number of unique clicks divided by the total number of successful deliveries.
       */
      readonly click_rate?: number;
      /**
       * The total number of clicks for an campaign.
       */
      readonly clicks?: number;
      /**
       * E-Commerce stats for a campaign.
       */
      ecommerce?: {
        /**
         * The total orders for a campaign.
         */
        readonly total_orders?: number;
        /**
         * The total revenue for a campaign. Calculated as the sum of all order totals minus shipping and tax totals.
         */
        readonly total_revenue?: number;
        /**
         * The total spent for a campaign. Calculated as the sum of all order totals with no deductions.
         */
        readonly total_spent?: number;
      };
      /**
       * The number of unique opens divided by the total number of successful deliveries.
       */
      readonly open_rate?: number;
      /**
       * The total number of opens for a campaign.
       */
      readonly opens?: number;
      /**
       * The number of unique clicks.
       */
      readonly subscriber_clicks?: number;
      /**
       * The number of unique opens.
       */
      readonly unique_opens?: number;
    };
    /**
     * Determines if the campaign qualifies to be resent to non-openers.
     */
    readonly resendable?: boolean;
    /**
     * [RSS](https://mailchimp.com/help/share-your-blog-posts-with-mailchimp/) options for a campaign.
     */
    rss_opts?: {
      /**
       * Whether to add CSS to images in the RSS feed to constrain their width in campaigns.
       */
      constrain_rss_img?: boolean;
      /**
       * The URL for the RSS feed.
       */
      feed_url?: string;
      /**
       * The frequency of the RSS Campaign.
       */
      frequency?: 'daily' | 'weekly' | 'monthly';
      /**
       * The date the campaign was last sent.
       */
      readonly last_sent?: string;
      /**
       * The schedule for sending the RSS Campaign.
       */
      schedule?: {
        /**
         * The days of the week to send a daily RSS Campaign.
         */
        daily_send?: {
          /**
           * Sends the daily RSS Campaign on Fridays.
           */
          friday?: boolean;
          /**
           * Sends the daily RSS Campaign on Mondays.
           */
          monday?: boolean;
          /**
           * Sends the daily RSS Campaign on Saturdays.
           */
          saturday?: boolean;
          /**
           * Sends the daily RSS Campaign on Sundays.
           */
          sunday?: boolean;
          /**
           * Sends the daily RSS Campaign on Thursdays.
           */
          thursday?: boolean;
          /**
           * Sends the daily RSS Campaign on Tuesdays.
           */
          tuesday?: boolean;
          /**
           * Sends the daily RSS Campaign on Wednesdays.
           */
          wednesday?: boolean;
        };
        /**
         * The hour to send the campaign in local time. Acceptable hours are 0-23. For example, '4' would be 4am in [your account's default time zone](https://mailchimp.com/help/set-account-defaults/).
         */
        hour?: number;
        /**
         * The day of the month to send a monthly RSS Campaign. Acceptable days are 0-31, where '0' is always the last day of a month. Months with fewer than the selected number of days will not have an RSS campaign sent out that day. For example, RSS Campaigns set to send on the 30th will not go out in February.
         */
        monthly_send_date?: number;
        /**
         * The day of the week to send a weekly RSS Campaign.
         */
        weekly_send_day?: 'sunday' | 'monday' | 'tuesday' | 'wednesday' | 'thursday' | 'friday' | 'saturday';
      };
    };
    /**
     * The date and time a campaign was sent.
     */
    readonly send_time?: string;
    /**
     * The settings for your campaign, including subject, from name, reply-to address, and more.
     */
    settings?: {
      /**
       * Whether Mailchimp [authenticated](https://mailchimp.com/help/about-email-authentication/) the campaign. Defaults to `true`.
       */
      authenticate?: boolean;
      /**
       * An array of [Facebook](https://mailchimp.com/help/connect-or-disconnect-the-facebook-integration/) page ids to auto-post to.
       */
      auto_fb_post?: Array<string>;
      /**
       * Automatically append Mailchimp's [default footer](https://mailchimp.com/help/about-campaign-footers/) to the campaign.
       */
      auto_footer?: boolean;
      /**
       * Automatically tweet a link to the [campaign archive](https://mailchimp.com/help/about-email-campaign-archives-and-pages/) page when the campaign is sent.
       */
      auto_tweet?: boolean;
      /**
       * Whether the campaign uses the drag-and-drop editor.
       */
      readonly drag_and_drop?: boolean;
      /**
       * Allows Facebook comments on the campaign (also force-enables the Campaign Archive toolbar). Defaults to `true`.
       */
      fb_comments?: boolean;
      /**
       * If the campaign is listed in a folder, the id for that folder.
       */
      folder_id?: string;
      /**
       * The 'from' name on the campaign (not an email address).
       */
      from_name?: string;
      /**
       * Automatically inline the CSS included with the campaign content.
       */
      inline_css?: boolean;
      /**
       * The preview text for the campaign.
       */
      preview_text?: string;
      /**
       * The reply-to email address for the campaign.
       */
      reply_to?: string;
      /**
       * The subject line for the campaign.
       */
      subject_line?: string;
      /**
       * The id for the template used in this campaign.
       */
      template_id?: number;
      /**
       * Send this campaign using [Timewarp](https://mailchimp.com/help/use-timewarp/).
       */
      readonly timewarp?: boolean;
      /**
       * The title of the campaign.
       */
      title?: string;
      /**
       * The campaign's custom 'To' name. Typically the first name [audience field](https://mailchimp.com/help/getting-started-with-merge-tags/).
       */
      to_name?: string;
      /**
       * Use Mailchimp Conversation feature to manage out-of-office replies.
       */
      use_conversation?: boolean;
    };
    /**
     * The preview for the campaign, rendered by social networks like Facebook and Twitter. [Learn more](https://mailchimp.com/help/enable-and-customize-social-cards/).
     */
    social_card?: {
      /**
       * A short summary of the campaign to display.
       */
      description?: string;
      /**
       * The url for the header image for the card.
       */
      image_url?: string;
      /**
       * The title for the card. Typically the subject line of the campaign.
       */
      title?: string;
    };
    /**
     * The current status of the campaign.
     */
    readonly status?: 'save' | 'paused' | 'schedule' | 'sending' | 'sent' | 'canceled' | 'canceling' | 'archived';
    /**
     * The tracking options for a campaign.
     */
    tracking?: {
      /**
       * Deprecated
       */
      capsule?: {
        /**
         * Update contact notes for a campaign based on subscriber email addresses.
         */
        notes?: boolean;
      };
      /**
       * The custom slug for [ClickTale](https://mailchimp.com/help/additional-tracking-options-for-campaigns/) tracking (max of 50 bytes).
       */
      clicktale?: string;
      /**
       * Whether to enable e-commerce tracking.
       */
      ecomm360?: boolean;
      /**
       * Deprecated
       */
      goal_tracking?: boolean;
      /**
       * The custom slug for [Google Analytics](https://mailchimp.com/help/integrate-google-analytics-with-mailchimp/) tracking (max of 50 bytes).
       */
      google_analytics?: string;
      /**
       * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the HTML version of the campaign. Defaults to `true`. Cannot be set to false for variate campaigns.
       */
      html_clicks?: boolean;
      /**
       * Whether to [track opens](https://mailchimp.com/help/about-open-tracking/). Defaults to `true`. Cannot be set to false for variate campaigns.
       */
      opens?: boolean;
      /**
       * Deprecated
       */
      salesforce?: {
        /**
         * Create a campaign in a connected Salesforce account.
         */
        campaign?: boolean;
        /**
         * Update contact notes for a campaign based on subscriber email addresses.
         */
        notes?: boolean;
      };
      /**
       * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the plain-text version of the campaign. Defaults to `true`. Cannot be set to false for variate campaigns.
       */
      text_clicks?: boolean;
    };
    /**
     * There are four types of [campaigns](https://mailchimp.com/help/getting-started-with-campaigns/) you can create in Mailchimp. A/B Split campaigns have been deprecated and variate campaigns should be used instead.
     */
    type?: 'regular' | 'plaintext' | 'absplit' | 'rss' | 'variate';
    /**
     * The settings specific to A/B test campaigns.
     */
    variate_settings?: {
      /**
       * Combinations of possible variables used to build emails.
       */
      readonly combinations?: Array<{
        /**
         * The index of `variate_settings.contents` used.
         */
        content_description?: number;
        /**
         * The index of `variate_settings.from_names` used.
         */
        from_name?: number;
        /**
         * Unique ID for the combination.
         */
        id?: string;
        /**
         * The number of recipients for this combination.
         */
        recipients?: number;
        /**
         * The index of `variate_settings.reply_to_addresses` used.
         */
        reply_to?: number;
        /**
         * The index of `variate_settings.send_times` used.
         */
        send_time?: number;
        /**
         * The index of `variate_settings.subject_lines` used.
         */
        subject_line?: number;
      }>;
      /**
       * Descriptions of possible email contents. To set campaign contents, make a PUT request to /campaigns/{campaign_id}/content with the field 'variate_contents'.
       */
      readonly contents?: Array<string>;
      /**
       * The possible from names. The number of from_names provided must match the number of reply_to_addresses. If no from_names are provided, settings.from_name will be used.
       */
      from_names?: Array<string>;
      /**
       * The possible reply-to addresses. The number of reply_to_addresses provided must match the number of from_names. If no reply_to_addresses are provided, settings.reply_to will be used.
       */
      reply_to_addresses?: Array<string>;
      /**
       * The possible send times to test. The times provided should be in the format YYYY-MM-DD HH:MM:SS. If send_times are provided to test, the test_size will be set to 100% and winner_criteria will be ignored.
       */
      send_times?: Array<string>;
      /**
       * The possible subject lines to test. If no subject lines are provided, settings.subject_line will be used.
       */
      subject_lines?: Array<string>;
      /**
       * The percentage of recipients to send the test combinations to, must be a value between 10 and 100.
       */
      test_size?: number;
      /**
       * The number of minutes to wait before choosing the winning campaign. The value of wait_time must be greater than 0 and in whole hours, specified in minutes.
       */
      wait_time?: number;
      /**
       * The combination that performs the best. This may be determined automatically by click rate, open rate, or total revenue -- or you may choose manually based on the reporting data you find the most valuable. For Multivariate Campaigns testing send_time, winner_criteria is ignored. For Multivariate Campaigns with 'manual' as the winner_criteria, the winner must be chosen in the Mailchimp web application.
       */
      winner_criteria?: 'opens' | 'clicks' | 'manual' | 'total_revenue';
      /**
       * ID of the campaign that was sent to the remaining recipients based on the winning combination.
       */
      readonly winning_campaign_id?: string;
      /**
       * ID for the winning combination.
       */
      readonly winning_combination_id?: string;
    };
    /**
     * The ID used in the Mailchimp web application. View this campaign in your Mailchimp account at `https://{dc}.admin.mailchimp.com/campaigns/show/?id={web_id}`.
     */
    readonly web_id?: number;
  }>;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetCampaignsError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostCampaignsData = {
  body: {
    /**
     * How the campaign's content is put together. The old drag and drop editor uses 'template' while the new editor uses 'multichannel'. Defaults to template.
     */
    content_type?: 'template' | 'multichannel';
    /**
     * List settings for the campaign.
     */
    recipients?: {
      /**
       * The unique list id.
       */
      list_id: string;
      /**
       * An object representing all segmentation options. This object should contain a `saved_segment_id` to use an existing segment, or you can create a new segment by including both `match` and `conditions` options.
       */
      segment_opts?: {
        /**
         * Segment match conditions. There are multiple possible types, see the [condition types documentation](https://mailchimp.com/developer/marketing/docs/alternative-schemas/#segment-condition-schemas).
         */
        conditions?: Array<
          | {
              condition_type?: 'Aim';
              /**
               * Segment by interaction with a specific campaign.
               */
              field?: 'aim';
              /**
               * The status of the member with regard to their campaign interaction. One of the following: opened, clicked, was sent, didn't open, didn't click, or was not sent.
               */
              op?: 'open' | 'click' | 'sent' | 'noopen' | 'noclick' | 'nosent';
              /**
               * Either the web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
               */
              value?: string;
            }
          | {
              condition_type?: 'Automation';
              /**
               * Segment by interaction with an Automation workflow.
               */
              field: 'automation';
              /**
               * The status of the member with regard to the automation workflow. One of the following: has started the workflow, has completed the workflow, has not started the workflow, or has not completed the workflow.
               */
              op: 'started' | 'completed' | 'not_started' | 'not_completed';
              /**
               * The web id for the automation workflow to segment against.
               */
              value: string;
            }
          | {
              condition_type?: 'CampaignPoll';
              /**
               * Segment by poll activity.
               */
              field: 'poll';
              /**
               * Members have/have not interacted with a specific poll in a Mailchimp email.
               */
              op: 'member' | 'notmember';
              /**
               * The id for the poll.
               */
              value: number;
            }
          | {
              condition_type?: 'Conversation';
              /**
               * Segment by interaction with a campaign via Conversations.
               */
              field: 'conversation';
              /**
               * The status of a member's interaction with a conversation. One of the following: has replied or has not replied.
               */
              op: 'member' | 'notmember';
              /**
               * The web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
               */
              value: string;
            }
          | {
              condition_type?: 'Date';
              /**
               * When segmenting on 'date' or 'campaign', the date for the segment formatted as YYYY-MM-DD or the web id for the campaign.
               */
              extra?: string;
              /**
               * The type of date field to segment on: The opt-in time for a signup, the date the subscriber was last updated, or the date of their last ecomm purchase.
               */
              field: 'timestamp_opt' | 'info_changed' | 'ecomm_date';
              /**
               * When the event took place:  Before, after, is a specific date, is not a specific date, is blank, or is not blank.
               */
              op: 'greater' | 'less' | 'is' | 'not' | 'blank' | 'blank_not' | 'within' | 'notwithin';
              /**
               * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
               */
              value: string;
            }
          | {
              condition_type?: 'EmailClient';
              /**
               * Segment by use of a particular email client.
               */
              field: 'email_client';
              /**
               * The operation to determine whether we select clients that match the value, or clients that do not match the value.
               */
              op: 'client_is' | 'client_not';
              /**
               * The name of the email client.
               */
              value: string;
            }
          | {
              condition_type?: 'Language';
              /**
               * Segmenting based off of a subscriber's language.
               */
              field: 'language';
              /**
               * Whether the member's language is or is not set to a specific language.
               */
              op: 'is' | 'not';
              /**
               * A two-letter language identifier.
               */
              value: string;
            }
          | {
              condition_type?: 'MemberRating';
              /**
               * Segment by member rating.
               */
              field: 'rating';
              /**
               * Members who have have a rating that is/not exactly a given number or members who have a rating greater/less than a given number.
               */
              op: 'is' | 'not' | 'greater' | 'less';
              /**
               * The star rating number to segment against.
               */
              value: number;
            }
          | {
              condition_type: 'SignupSource';
              field: 'source';
              /**
               * Whether the member's signup source was/was not a particular value.
               */
              op: 'source_is' | 'source_not';
              /**
               * The signup source.
               */
              value?: string;
            }
          | {
              condition_type?: 'SurveyMonkey';
              /**
               * Segment by interaction with a SurveyMonkey survey.
               */
              field: 'survey_monkey';
              /**
               * The status of the member with regard to the survey.One of the following: has started the survey, has completed the survey, has not started the survey, or has not completed the survey.
               */
              op: 'started' | 'completed' | 'not_started' | 'not_completed';
              /**
               * The unique ID of the survey monkey survey.
               */
              value: string;
            }
          | {
              condition_type?: 'VIP';
              /**
               * Segment by VIP status.
               */
              field: 'gmonkey';
              /**
               * Whether the member is or is not marked as VIP.
               */
              op: 'member' | 'notmember';
            }
          | {
              condition_type?: 'Interests';
              /**
               * Segmenting based on interest group information. This should start with 'interests-' followed by the grouping id. Ex. 'interests-123'.
               */
              field?: string;
              /**
               * Whether the member is a part of one, all, or none of the groups.
               */
              op?: 'interestcontains' | 'interestcontainsall' | 'interestnotcontains';
              /**
               * An array containing strings, each representing a group id.
               */
              value?: Array<string>;
            }
          | {
              condition_type?: 'EcommCategory';
              /**
               * Segment by purchases in specific items or categories.
               */
              field?: 'ecomm_cat' | 'ecomm_prod';
              /**
               * A member who has purchased from a category/specific item that is/is not a specific name, where the category/item name contains/doesn't contain a specific phrase or string, or a category/item name that starts/ends with a string.
               */
              op?: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends';
              /**
               * The ecommerce category/item information.
               */
              value?: string;
            }
          | {
              condition_type?: 'EcommNumber';
              /**
               * Segment by average spent total, number of orders, total number of products purchased, or average number of products per order.
               */
              field: 'ecomm_spent_avg' | 'ecomm_orders' | 'ecomm_prod_all' | 'ecomm_avg_ord';
              /**
               * Members who have spent exactly, have not spent exactly, spent more, or spent less than the segment value.
               */
              op: 'is' | 'not' | 'greater' | 'less';
              /**
               * Members who have spent exactly, have not spent exactly, spent more, or spent less than this amount.
               */
              value: number;
            }
          | {
              condition_type?: 'EcommPurchased';
              /**
               * Segment by whether someone has purchased anything.
               */
              field?: 'ecomm_purchased';
              /**
               * Members who have have ('member') or have not ('notmember') purchased.
               */
              op?: 'member' | 'notmember';
            }
          | {
              condition_type?: 'EcommSpent';
              /**
               * Segment by amount spent on a single order or across all orders.
               */
              field?: 'ecomm_spent_one' | 'ecomm_spent_all';
              /**
               * Members who have spent 'more' or 'less' than then specified value.
               */
              op?: 'greater' | 'less';
              /**
               * The total amount a member spent.
               */
              value?: number;
            }
          | {
              condition_type?: 'EcommStore';
              /**
               * Segment by purchases from a specific store.
               */
              field?: 'ecomm_store';
              /**
               * Members who have or have not purchased from a specific store.
               */
              op?: 'is' | 'not';
              /**
               * The store id to segment against.
               */
              value?: string;
            }
          | {
              condition_type?: 'GoalActivity';
              /**
               * Segment by Goal activity.
               */
              field: 'goal';
              /**
               * Whether the website URL is/not exactly, contains/doesn't contain, starts with/ends with a string.
               */
              op: 'is' | 'goal_not' | 'contains' | 'goal_notcontain' | 'starts' | 'ends';
              /**
               * The URL to check Goal activity against.
               */
              value: string;
            }
          | {
              condition_type?: 'GoalTimestamp';
              /**
               * Segment by most recent interaction with a website.
               */
              field: 'goal_last_visited';
              /**
               * Whether the website activity happened after, before, or at a given timestamp.
               */
              op: 'greater' | 'less' | 'is';
              /**
               * The date to check Goal activity against.
               */
              value: string;
            }
          | {
              condition_type?: 'FuzzySegment';
              /**
               * Segment by similar subscribers.
               */
              field: 'fuzzy_segment';
              /**
               * Members who are/are not apart of a 'similar subscribers' segment.
               */
              op: 'fuzzy_is' | 'fuzzy_not';
              /**
               * The id for the 'similar subscribers' segment.
               */
              value: number;
            }
          | {
              condition_type?: 'StaticSegment';
              /**
               * Segment by a given static segment.
               */
              field: 'static_segment';
              /**
               * Members who are/are not apart of a static segment.
               */
              op: 'static_is' | 'static_not';
              /**
               * The id for the static segment.
               */
              value: number;
            }
          | {
              condition_type?: 'IPGeoCountryState';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members who are within a specific country or US state.
               */
              op: 'ipgeocountry' | 'ipgeonotcountry' | 'ipgeostate' | 'ipgeonotstate';
              /**
               * The two-letter country code or US state abbreviation.
               */
              value: string;
            }
          | {
              /**
               * The address of the target location.
               */
              addr: string;
              condition_type?: 'IPGeoIn';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * The latitude of the target location.
               */
              lat: string;
              /**
               * The longitude of the target location.
               */
              lng: string;
              /**
               * Segment members who are within a specific geographic region.
               */
              op: 'ipgeoin' | 'ipgeonotin';
              /**
               * The radius of the target location.
               */
              value: number;
            }
          | {
              condition_type?: 'IPGeoInZip';
              /**
               * The zip code to segment against.
               */
              extra: number;
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members who are within a specific US zip code.
               */
              op: 'ipgeoinzip';
              /**
               * The radius of the target location.
               */
              value: number;
            }
          | {
              condition_type?: 'IPGeoUnknown';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members for which location information is unknown.
               */
              op: 'ipgeounknown';
            }
          | {
              condition_type?: 'IPGeoZip';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members who are/are not within a specific US zip code.
               */
              op: 'ipgeoiszip' | 'ipgeonotzip';
              /**
               * The 5-digit zip code.
               */
              value: number;
            }
          | {
              condition_type?: 'SocialAge';
              /**
               * Segment by age ranges in Social Profiles data.
               */
              field: 'social_age';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is' | 'not';
              /**
               * The age range to segment.
               */
              value: '18-24' | '25-34' | '35-54' | '55+';
            }
          | {
              condition_type?: 'SocialGender';
              /**
               * Segment by listed gender in Social Profiles data.
               */
              field: 'social_gender';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is' | 'not';
              /**
               * The Social Profiles gender to segment.
               */
              value: 'male' | 'female';
            }
          | {
              condition_type?: 'SocialInfluence';
              /**
               * Segment by influence rating in Social Profiles data.
               */
              field: 'social_influence';
              /**
               * Members who have a rating that is/not or greater/less than the rating provided.
               */
              op: 'is' | 'not' | 'greater' | 'less';
              /**
               * The Social Profiles influence rating to segment.
               */
              value: number;
            }
          | {
              condition_type?: 'SocialNetworkMember';
              /**
               * Segment by social network in Social Profiles data.
               */
              field: 'social_network';
              /**
               * Members who are/not on a given social network.
               */
              op: 'member' | 'notmember';
              /**
               * The social network to segment against.
               */
              value:
                | 'twitter'
                | 'facebook'
                | 'linkedin'
                | 'flickr'
                | 'foursquare'
                | 'lastfm'
                | 'myspace'
                | 'quora'
                | 'vimeo'
                | 'yelp'
                | 'youtube';
            }
          | {
              condition_type?: 'SocialNetworkFollow';
              /**
               * Segment by social network in Social Profiles data.
               */
              field: 'social_network';
              /**
               * Members who are/not following a linked account on a given social network.
               */
              op: 'follow' | 'notfollow';
              /**
               * The social network to segment against.
               */
              value: 'twitter_follow';
            }
          | {
              condition_type?: 'AddressMerge';
              /**
               * An address-type merge field to segment.
               */
              field: string;
              /**
               * Whether the member's address merge field contains/does not contain a value or is/is not blank.
               */
              op: 'contains' | 'notcontain' | 'blank' | 'blank_not';
              /**
               * The value to segment a text merge field with.
               */
              value?: string;
            }
          | {
              condition_type?: 'ZipMerge';
              /**
               * The city or the zip being used to segment against.
               */
              extra: string;
              /**
               * An address or zip-type merge field to segment.
               */
              field: string;
              /**
               * Whether the member's address merge field is within a given distance from a city or zip.
               */
              op: 'geoin';
              /**
               * The distance from the city/zip.
               */
              value: string;
            }
          | {
              condition_type?: 'BirthdayMerge';
              /**
               * A date merge field to segment.
               */
              field: string;
              /**
               * Whether the member's birthday merge information is/is not a certain date or is/is not blank.
               */
              op: 'is' | 'not' | 'blank' | 'blank_not';
              /**
               * A date to segment against (mm/dd).
               */
              value?: string;
            }
          | {
              condition_type?: 'DateMerge';
              /**
               * A date merge field to segment.
               */
              field: string;
              /**
               * Whether the member's merge information is/is not, is greater/less than a value or is/is not blank.
               */
              op: 'is' | 'not' | 'less' | 'blank' | 'blank_not' | 'greater';
              /**
               * A date to segment against.
               */
              value?: string;
            }
          | {
              condition_type?: 'SelectMerge';
              /**
               * A merge field to segment.
               */
              field: string;
              /**
               * Whether the member's merge information is/is not a value or is/is not blank.
               */
              op: 'is' | 'not' | 'blank' | 'blank_not' | 'notcontain' | 'contains';
              /**
               * The value to segment a text merge field with.
               */
              value?: string;
            }
          | {
              condition_type?: 'TextMerge';
              /**
               * A text or number merge field to segment.
               */
              field: string;
              /**
               * Whether the member's merge information is/is not, contains/does not contain, starts/ends with, or is greater/less than a value
               */
              op:
                | 'is'
                | 'not'
                | 'contains'
                | 'notcontain'
                | 'starts'
                | 'ends'
                | 'greater'
                | 'less'
                | 'blank'
                | 'blank_not';
              /**
               * The value to segment a text or number merge field with.
               */
              value?: string;
            }
          | {
              condition_type?: 'EmailAddress';
              /**
               * Segmenting based off of a subscriber's email address.
               */
              field: 'merge0' | 'EMAIL';
              /**
               * Whether the email address is/not exactly, contains/doesn't contain, starts/ends with a string.
               */
              op: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends' | 'greater' | 'less';
              /**
               * The value to compare the email against.
               */
              value?: string;
            }
          | {
              condition_type?: 'PredictedGender';
              /**
               * Segment by predicted gender.
               */
              field: 'predicted_gender';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is' | 'not';
              /**
               * The predicted gender to segment.
               */
              value: 'male' | 'female';
            }
          | {
              condition_type?: 'PredictedAge';
              /**
               * Segment by predicted age.
               */
              field: 'predicted_age_range';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is';
              /**
               * The predicted age to segment.
               */
              value: '18-24' | '25-34' | '35-44' | '45-54' | '55-64' | '65+';
            }
          | {
              condition_type?: 'NewSubscribers';
              /**
               * Segment by when people subscribed.
               */
              field?: 'timestamp_opt';
              /**
               * Whe the event took place, namely within a time frame.
               */
              op?: 'date_within';
              /**
               * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
               */
              value?: string;
            }
        >;
        /**
         * Segment match type.
         */
        match?: 'any' | 'all';
        /**
         * The id for an existing saved segment.
         */
        saved_segment_id?: number;
      };
    };
    /**
     * [RSS](https://mailchimp.com/help/share-your-blog-posts-with-mailchimp/) options, specific to an RSS campaign.
     */
    rss_opts?: {
      /**
       * Whether to add CSS to images in the RSS feed to constrain their width in campaigns.
       */
      constrain_rss_img?: boolean;
      /**
       * The URL for the RSS feed.
       */
      feed_url: string;
      /**
       * The frequency of the RSS Campaign.
       */
      frequency: 'daily' | 'weekly' | 'monthly';
      /**
       * The schedule for sending the RSS Campaign.
       */
      schedule?: {
        /**
         * The days of the week to send a daily RSS Campaign.
         */
        daily_send?: {
          /**
           * Sends the daily RSS Campaign on Fridays.
           */
          friday?: boolean;
          /**
           * Sends the daily RSS Campaign on Mondays.
           */
          monday?: boolean;
          /**
           * Sends the daily RSS Campaign on Saturdays.
           */
          saturday?: boolean;
          /**
           * Sends the daily RSS Campaign on Sundays.
           */
          sunday?: boolean;
          /**
           * Sends the daily RSS Campaign on Thursdays.
           */
          thursday?: boolean;
          /**
           * Sends the daily RSS Campaign on Tuesdays.
           */
          tuesday?: boolean;
          /**
           * Sends the daily RSS Campaign on Wednesdays.
           */
          wednesday?: boolean;
        };
        /**
         * The hour to send the campaign in local time. Acceptable hours are 0-23. For example, '4' would be 4am in [your account's default time zone](https://mailchimp.com/help/set-account-defaults/).
         */
        hour?: number;
        /**
         * The day of the month to send a monthly RSS Campaign. Acceptable days are 0-31, where '0' is always the last day of a month. Months with fewer than the selected number of days will not have an RSS campaign sent out that day. For example, RSS Campaigns set to send on the 30th will not go out in February.
         */
        monthly_send_date?: number;
        /**
         * The day of the week to send a weekly RSS Campaign.
         */
        weekly_send_day?: 'sunday' | 'monday' | 'tuesday' | 'wednesday' | 'thursday' | 'friday' | 'saturday';
      };
    };
    /**
     * The settings for your campaign, including subject, from name, reply-to address, and more.
     */
    settings?: {
      /**
       * Whether Mailchimp [authenticated](https://mailchimp.com/help/about-email-authentication/) the campaign. Defaults to `true`.
       */
      authenticate?: boolean;
      /**
       * An array of [Facebook](https://mailchimp.com/help/connect-or-disconnect-the-facebook-integration/) page ids to auto-post to.
       */
      auto_fb_post?: Array<string>;
      /**
       * Automatically append Mailchimp's [default footer](https://mailchimp.com/help/about-campaign-footers/) to the campaign.
       */
      auto_footer?: boolean;
      /**
       * Automatically tweet a link to the [campaign archive](https://mailchimp.com/help/about-email-campaign-archives-and-pages/) page when the campaign is sent.
       */
      auto_tweet?: boolean;
      /**
       * Allows Facebook comments on the campaign (also force-enables the Campaign Archive toolbar). Defaults to `true`.
       */
      fb_comments?: boolean;
      /**
       * If the campaign is listed in a folder, the id for that folder.
       */
      folder_id?: string;
      /**
       * The 'from' name on the campaign (not an email address).
       */
      from_name?: string;
      /**
       * Automatically inline the CSS included with the campaign content.
       */
      inline_css?: boolean;
      /**
       * The preview text for the campaign.
       */
      preview_text?: string;
      /**
       * The reply-to email address for the campaign. Note: while this field is not required for campaign creation, it is required for sending.
       */
      reply_to?: string;
      /**
       * The subject line for the campaign.
       */
      subject_line?: string;
      /**
       * The id of the template to use.
       */
      template_id?: number;
      /**
       * The title of the campaign.
       */
      title?: string;
      /**
       * The campaign's custom 'To' name. Typically the first name [audience field](https://mailchimp.com/help/getting-started-with-merge-tags/).
       */
      to_name?: string;
      /**
       * Use Mailchimp Conversation feature to manage out-of-office replies.
       */
      use_conversation?: boolean;
    };
    /**
     * The preview for the campaign, rendered by social networks like Facebook and Twitter. [Learn more](https://mailchimp.com/help/enable-and-customize-social-cards/).
     */
    social_card?: {
      /**
       * A short summary of the campaign to display.
       */
      description?: string;
      /**
       * The url for the header image for the card.
       */
      image_url?: string;
      /**
       * The title for the card. Typically the subject line of the campaign.
       */
      title?: string;
    };
    /**
     * The tracking options for a campaign.
     */
    tracking?: {
      /**
       * Deprecated
       */
      capsule?: {
        /**
         * Update contact notes for a campaign based on subscriber email addresses.
         */
        notes?: boolean;
      };
      /**
       * The custom slug for [ClickTale](https://mailchimp.com/help/additional-tracking-options-for-campaigns/) tracking (max of 50 bytes).
       */
      clicktale?: string;
      /**
       * Whether to enable e-commerce tracking.
       */
      ecomm360?: boolean;
      /**
       * Deprecated
       */
      goal_tracking?: boolean;
      /**
       * The custom slug for [Google Analytics](https://mailchimp.com/help/integrate-google-analytics-with-mailchimp/) tracking (max of 50 bytes).
       */
      google_analytics?: string;
      /**
       * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the HTML version of the campaign. Defaults to `true`. Cannot be set to false for variate campaigns.
       */
      html_clicks?: boolean;
      /**
       * Whether to [track opens](https://mailchimp.com/help/about-open-tracking/). Defaults to `true`. Cannot be set to false for variate campaigns.
       */
      opens?: boolean;
      /**
       * Deprecated
       */
      salesforce?: {
        /**
         * Create a campaign in a connected Salesforce account.
         */
        campaign?: boolean;
        /**
         * Update contact notes for a campaign based on subscriber email addresses.
         */
        notes?: boolean;
      };
      /**
       * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the plain-text version of the campaign. Defaults to `true`. Cannot be set to false for variate campaigns.
       */
      text_clicks?: boolean;
    };
    /**
     * There are four types of [campaigns](https://mailchimp.com/help/getting-started-with-campaigns/) you can create in Mailchimp. A/B Split campaigns have been deprecated and variate campaigns should be used instead.
     */
    type: 'regular' | 'plaintext' | 'absplit' | 'rss' | 'variate';
    /**
     * The settings specific to A/B test campaigns.
     */
    variate_settings?: {
      /**
       * The possible from names. The number of from_names provided must match the number of reply_to_addresses. If no from_names are provided, settings.from_name will be used.
       */
      from_names?: Array<string>;
      /**
       * The possible reply-to addresses. The number of reply_to_addresses provided must match the number of from_names. If no reply_to_addresses are provided, settings.reply_to will be used.
       */
      reply_to_addresses?: Array<string>;
      /**
       * The possible send times to test. The times provided should be in the format YYYY-MM-DD HH:MM:SS. If send_times are provided to test, the test_size will be set to 100% and winner_criteria will be ignored.
       */
      send_times?: Array<string>;
      /**
       * The possible subject lines to test. If no subject lines are provided, settings.subject_line will be used.
       */
      subject_lines?: Array<string>;
      /**
       * The percentage of recipients to send the test combinations to, must be a value between 10 and 100.
       */
      test_size?: number;
      /**
       * The number of minutes to wait before choosing the winning campaign. The value of wait_time must be greater than 0 and in whole hours, specified in minutes.
       */
      wait_time?: number;
      /**
       * The combination that performs the best. This may be determined automatically by click rate, open rate, or total revenue -- or you may choose manually based on the reporting data you find the most valuable. For Multivariate Campaigns testing send_time, winner_criteria is ignored. For Multivariate Campaigns with 'manual' as the winner_criteria, the winner must be chosen in the Mailchimp web application.
       */
      winner_criteria: 'opens' | 'clicks' | 'manual' | 'total_revenue';
    };
  };
};

export type PostCampaignsResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * [A/B Testing](https://mailchimp.com/help/about-ab-testing-campaigns/) options for a campaign.
   */
  readonly ab_split_opts?: {
    /**
     * For campaigns split on 'From Name', the name for Group A.
     */
    from_name_a?: string;
    /**
     * For campaigns split on 'From Name', the name for Group B.
     */
    from_name_b?: string;
    /**
     * How we should evaluate a winner. Based on 'opens', 'clicks', or 'manual'.
     */
    pick_winner?: 'opens' | 'clicks' | 'manual';
    /**
     * For campaigns split on 'From Name', the reply-to address for Group A.
     */
    reply_email_a?: string;
    /**
     * For campaigns split on 'From Name', the reply-to address for Group B.
     */
    reply_email_b?: string;
    /**
     * The send time for Group A.
     */
    send_time_a?: string;
    /**
     * The send time for Group B.
     */
    send_time_b?: string;
    /**
     * The send time for the winning version.
     */
    send_time_winner?: string;
    /**
     * The size of the split groups. Campaigns split based on 'schedule' are forced to have a 50/50 split. Valid split integers are between 1-50.
     */
    split_size?: number;
    /**
     * The type of AB split to run.
     */
    split_test?: 'subject' | 'from_name' | 'schedule';
    /**
     * For campaigns split on 'Subject Line', the subject line for Group A.
     */
    subject_a?: string;
    /**
     * For campaigns split on 'Subject Line', the subject line for Group B.
     */
    subject_b?: string;
    /**
     * The amount of time to wait before picking a winner. This cannot be changed after a campaign is sent.
     */
    wait_time?: number;
    /**
     * How unit of time for measuring the winner ('hours' or 'days'). This cannot be changed after a campaign is sent.
     */
    wait_units?: 'hours' | 'days';
  };
  /**
   * The link to the campaign's archive version in ISO 8601 format.
   */
  readonly archive_url?: string;
  /**
   * How the campaign's content is put together.
   */
  content_type?: 'template' | 'html' | 'url' | 'multichannel';
  /**
   * The date and time the campaign was created in ISO 8601 format.
   */
  readonly create_time?: string;
  /**
   * Updates on campaigns in the process of sending.
   */
  delivery_status?: {
    /**
     * Whether a campaign send can be canceled.
     */
    readonly can_cancel?: boolean;
    /**
     * The total number of emails canceled for this campaign.
     */
    readonly emails_canceled?: number;
    /**
     * The total number of emails confirmed sent for this campaign so far.
     */
    readonly emails_sent?: number;
    /**
     * Whether Campaign Delivery Status is enabled for this account and campaign.
     */
    readonly enabled?: boolean;
    /**
     * The current state of a campaign delivery.
     */
    readonly status?: 'delivering' | 'delivered' | 'canceling' | 'canceled';
  };
  /**
   * The total number of emails sent for this campaign.
   */
  readonly emails_sent?: number;
  /**
   * A string that uniquely identifies this campaign.
   */
  readonly id?: string;
  /**
   * The original link to the campaign's archive version.
   */
  readonly long_archive_url?: string;
  /**
   * Determines if the campaign needs its blocks refreshed by opening the web-based campaign editor. Deprecated and will always return false.
   */
  readonly needs_block_refresh?: boolean;
  /**
   * If this campaign is the child of another campaign, this identifies the parent campaign. For Example, for RSS or Automation children.
   */
  readonly parent_campaign_id?: string;
  /**
   * List settings for the campaign.
   */
  recipients?: {
    /**
     * The unique list id.
     */
    list_id?: string;
    /**
     * The status of the list used, namely if it's deleted or disabled.
     */
    readonly list_is_active?: boolean;
    /**
     * The name of the list.
     */
    readonly list_name?: string;
    /**
     * Count of the recipients on the associated list. Formatted as an integer.
     */
    readonly recipient_count?: number;
    /**
     * An object representing all segmentation options. This object should contain a `saved_segment_id` to use an existing segment, or you can create a new segment by including both `match` and `conditions` options.
     */
    segment_opts?: {
      /**
       * Segment match conditions. There are multiple possible types, see the [condition types documentation](https://mailchimp.com/developer/marketing/docs/alternative-schemas/#segment-condition-schemas).
       */
      conditions?: Array<
        | {
            condition_type?: 'Aim';
            /**
             * Segment by interaction with a specific campaign.
             */
            field?: 'aim';
            /**
             * The status of the member with regard to their campaign interaction. One of the following: opened, clicked, was sent, didn't open, didn't click, or was not sent.
             */
            op?: 'open' | 'click' | 'sent' | 'noopen' | 'noclick' | 'nosent';
            /**
             * Either the web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
             */
            value?: string;
          }
        | {
            condition_type?: 'Automation';
            /**
             * Segment by interaction with an Automation workflow.
             */
            field: 'automation';
            /**
             * The status of the member with regard to the automation workflow. One of the following: has started the workflow, has completed the workflow, has not started the workflow, or has not completed the workflow.
             */
            op: 'started' | 'completed' | 'not_started' | 'not_completed';
            /**
             * The web id for the automation workflow to segment against.
             */
            value: string;
          }
        | {
            condition_type?: 'CampaignPoll';
            /**
             * Segment by poll activity.
             */
            field: 'poll';
            /**
             * Members have/have not interacted with a specific poll in a Mailchimp email.
             */
            op: 'member' | 'notmember';
            /**
             * The id for the poll.
             */
            value: number;
          }
        | {
            condition_type?: 'Conversation';
            /**
             * Segment by interaction with a campaign via Conversations.
             */
            field: 'conversation';
            /**
             * The status of a member's interaction with a conversation. One of the following: has replied or has not replied.
             */
            op: 'member' | 'notmember';
            /**
             * The web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
             */
            value: string;
          }
        | {
            condition_type?: 'Date';
            /**
             * When segmenting on 'date' or 'campaign', the date for the segment formatted as YYYY-MM-DD or the web id for the campaign.
             */
            extra?: string;
            /**
             * The type of date field to segment on: The opt-in time for a signup, the date the subscriber was last updated, or the date of their last ecomm purchase.
             */
            field: 'timestamp_opt' | 'info_changed' | 'ecomm_date';
            /**
             * When the event took place:  Before, after, is a specific date, is not a specific date, is blank, or is not blank.
             */
            op: 'greater' | 'less' | 'is' | 'not' | 'blank' | 'blank_not' | 'within' | 'notwithin';
            /**
             * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
             */
            value: string;
          }
        | {
            condition_type?: 'EmailClient';
            /**
             * Segment by use of a particular email client.
             */
            field: 'email_client';
            /**
             * The operation to determine whether we select clients that match the value, or clients that do not match the value.
             */
            op: 'client_is' | 'client_not';
            /**
             * The name of the email client.
             */
            value: string;
          }
        | {
            condition_type?: 'Language';
            /**
             * Segmenting based off of a subscriber's language.
             */
            field: 'language';
            /**
             * Whether the member's language is or is not set to a specific language.
             */
            op: 'is' | 'not';
            /**
             * A two-letter language identifier.
             */
            value: string;
          }
        | {
            condition_type?: 'MemberRating';
            /**
             * Segment by member rating.
             */
            field: 'rating';
            /**
             * Members who have have a rating that is/not exactly a given number or members who have a rating greater/less than a given number.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * The star rating number to segment against.
             */
            value: number;
          }
        | {
            condition_type: 'SignupSource';
            field: 'source';
            /**
             * Whether the member's signup source was/was not a particular value.
             */
            op: 'source_is' | 'source_not';
            /**
             * The signup source.
             */
            value?: string;
          }
        | {
            condition_type?: 'SurveyMonkey';
            /**
             * Segment by interaction with a SurveyMonkey survey.
             */
            field: 'survey_monkey';
            /**
             * The status of the member with regard to the survey.One of the following: has started the survey, has completed the survey, has not started the survey, or has not completed the survey.
             */
            op: 'started' | 'completed' | 'not_started' | 'not_completed';
            /**
             * The unique ID of the survey monkey survey.
             */
            value: string;
          }
        | {
            condition_type?: 'VIP';
            /**
             * Segment by VIP status.
             */
            field: 'gmonkey';
            /**
             * Whether the member is or is not marked as VIP.
             */
            op: 'member' | 'notmember';
          }
        | {
            condition_type?: 'Interests';
            /**
             * Segmenting based on interest group information. This should start with 'interests-' followed by the grouping id. Ex. 'interests-123'.
             */
            field?: string;
            /**
             * Whether the member is a part of one, all, or none of the groups.
             */
            op?: 'interestcontains' | 'interestcontainsall' | 'interestnotcontains';
            /**
             * An array containing strings, each representing a group id.
             */
            value?: Array<string>;
          }
        | {
            condition_type?: 'EcommCategory';
            /**
             * Segment by purchases in specific items or categories.
             */
            field?: 'ecomm_cat' | 'ecomm_prod';
            /**
             * A member who has purchased from a category/specific item that is/is not a specific name, where the category/item name contains/doesn't contain a specific phrase or string, or a category/item name that starts/ends with a string.
             */
            op?: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends';
            /**
             * The ecommerce category/item information.
             */
            value?: string;
          }
        | {
            condition_type?: 'EcommNumber';
            /**
             * Segment by average spent total, number of orders, total number of products purchased, or average number of products per order.
             */
            field: 'ecomm_spent_avg' | 'ecomm_orders' | 'ecomm_prod_all' | 'ecomm_avg_ord';
            /**
             * Members who have spent exactly, have not spent exactly, spent more, or spent less than the segment value.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * Members who have spent exactly, have not spent exactly, spent more, or spent less than this amount.
             */
            value: number;
          }
        | {
            condition_type?: 'EcommPurchased';
            /**
             * Segment by whether someone has purchased anything.
             */
            field?: 'ecomm_purchased';
            /**
             * Members who have have ('member') or have not ('notmember') purchased.
             */
            op?: 'member' | 'notmember';
          }
        | {
            condition_type?: 'EcommSpent';
            /**
             * Segment by amount spent on a single order or across all orders.
             */
            field?: 'ecomm_spent_one' | 'ecomm_spent_all';
            /**
             * Members who have spent 'more' or 'less' than then specified value.
             */
            op?: 'greater' | 'less';
            /**
             * The total amount a member spent.
             */
            value?: number;
          }
        | {
            condition_type?: 'EcommStore';
            /**
             * Segment by purchases from a specific store.
             */
            field?: 'ecomm_store';
            /**
             * Members who have or have not purchased from a specific store.
             */
            op?: 'is' | 'not';
            /**
             * The store id to segment against.
             */
            value?: string;
          }
        | {
            condition_type?: 'GoalActivity';
            /**
             * Segment by Goal activity.
             */
            field: 'goal';
            /**
             * Whether the website URL is/not exactly, contains/doesn't contain, starts with/ends with a string.
             */
            op: 'is' | 'goal_not' | 'contains' | 'goal_notcontain' | 'starts' | 'ends';
            /**
             * The URL to check Goal activity against.
             */
            value: string;
          }
        | {
            condition_type?: 'GoalTimestamp';
            /**
             * Segment by most recent interaction with a website.
             */
            field: 'goal_last_visited';
            /**
             * Whether the website activity happened after, before, or at a given timestamp.
             */
            op: 'greater' | 'less' | 'is';
            /**
             * The date to check Goal activity against.
             */
            value: string;
          }
        | {
            condition_type?: 'FuzzySegment';
            /**
             * Segment by similar subscribers.
             */
            field: 'fuzzy_segment';
            /**
             * Members who are/are not apart of a 'similar subscribers' segment.
             */
            op: 'fuzzy_is' | 'fuzzy_not';
            /**
             * The id for the 'similar subscribers' segment.
             */
            value: number;
          }
        | {
            condition_type?: 'StaticSegment';
            /**
             * Segment by a given static segment.
             */
            field: 'static_segment';
            /**
             * Members who are/are not apart of a static segment.
             */
            op: 'static_is' | 'static_not';
            /**
             * The id for the static segment.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoCountryState';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are within a specific country or US state.
             */
            op: 'ipgeocountry' | 'ipgeonotcountry' | 'ipgeostate' | 'ipgeonotstate';
            /**
             * The two-letter country code or US state abbreviation.
             */
            value: string;
          }
        | {
            /**
             * The address of the target location.
             */
            addr: string;
            condition_type?: 'IPGeoIn';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * The latitude of the target location.
             */
            lat: string;
            /**
             * The longitude of the target location.
             */
            lng: string;
            /**
             * Segment members who are within a specific geographic region.
             */
            op: 'ipgeoin' | 'ipgeonotin';
            /**
             * The radius of the target location.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoInZip';
            /**
             * The zip code to segment against.
             */
            extra: number;
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are within a specific US zip code.
             */
            op: 'ipgeoinzip';
            /**
             * The radius of the target location.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoUnknown';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members for which location information is unknown.
             */
            op: 'ipgeounknown';
          }
        | {
            condition_type?: 'IPGeoZip';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are/are not within a specific US zip code.
             */
            op: 'ipgeoiszip' | 'ipgeonotzip';
            /**
             * The 5-digit zip code.
             */
            value: number;
          }
        | {
            condition_type?: 'SocialAge';
            /**
             * Segment by age ranges in Social Profiles data.
             */
            field: 'social_age';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The age range to segment.
             */
            value: '18-24' | '25-34' | '35-54' | '55+';
          }
        | {
            condition_type?: 'SocialGender';
            /**
             * Segment by listed gender in Social Profiles data.
             */
            field: 'social_gender';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The Social Profiles gender to segment.
             */
            value: 'male' | 'female';
          }
        | {
            condition_type?: 'SocialInfluence';
            /**
             * Segment by influence rating in Social Profiles data.
             */
            field: 'social_influence';
            /**
             * Members who have a rating that is/not or greater/less than the rating provided.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * The Social Profiles influence rating to segment.
             */
            value: number;
          }
        | {
            condition_type?: 'SocialNetworkMember';
            /**
             * Segment by social network in Social Profiles data.
             */
            field: 'social_network';
            /**
             * Members who are/not on a given social network.
             */
            op: 'member' | 'notmember';
            /**
             * The social network to segment against.
             */
            value:
              | 'twitter'
              | 'facebook'
              | 'linkedin'
              | 'flickr'
              | 'foursquare'
              | 'lastfm'
              | 'myspace'
              | 'quora'
              | 'vimeo'
              | 'yelp'
              | 'youtube';
          }
        | {
            condition_type?: 'SocialNetworkFollow';
            /**
             * Segment by social network in Social Profiles data.
             */
            field: 'social_network';
            /**
             * Members who are/not following a linked account on a given social network.
             */
            op: 'follow' | 'notfollow';
            /**
             * The social network to segment against.
             */
            value: 'twitter_follow';
          }
        | {
            condition_type?: 'AddressMerge';
            /**
             * An address-type merge field to segment.
             */
            field: string;
            /**
             * Whether the member's address merge field contains/does not contain a value or is/is not blank.
             */
            op: 'contains' | 'notcontain' | 'blank' | 'blank_not';
            /**
             * The value to segment a text merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'ZipMerge';
            /**
             * The city or the zip being used to segment against.
             */
            extra: string;
            /**
             * An address or zip-type merge field to segment.
             */
            field: string;
            /**
             * Whether the member's address merge field is within a given distance from a city or zip.
             */
            op: 'geoin';
            /**
             * The distance from the city/zip.
             */
            value: string;
          }
        | {
            condition_type?: 'BirthdayMerge';
            /**
             * A date merge field to segment.
             */
            field: string;
            /**
             * Whether the member's birthday merge information is/is not a certain date or is/is not blank.
             */
            op: 'is' | 'not' | 'blank' | 'blank_not';
            /**
             * A date to segment against (mm/dd).
             */
            value?: string;
          }
        | {
            condition_type?: 'DateMerge';
            /**
             * A date merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not, is greater/less than a value or is/is not blank.
             */
            op: 'is' | 'not' | 'less' | 'blank' | 'blank_not' | 'greater';
            /**
             * A date to segment against.
             */
            value?: string;
          }
        | {
            condition_type?: 'SelectMerge';
            /**
             * A merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not a value or is/is not blank.
             */
            op: 'is' | 'not' | 'blank' | 'blank_not' | 'notcontain' | 'contains';
            /**
             * The value to segment a text merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'TextMerge';
            /**
             * A text or number merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not, contains/does not contain, starts/ends with, or is greater/less than a value
             */
            op:
              | 'is'
              | 'not'
              | 'contains'
              | 'notcontain'
              | 'starts'
              | 'ends'
              | 'greater'
              | 'less'
              | 'blank'
              | 'blank_not';
            /**
             * The value to segment a text or number merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'EmailAddress';
            /**
             * Segmenting based off of a subscriber's email address.
             */
            field: 'merge0' | 'EMAIL';
            /**
             * Whether the email address is/not exactly, contains/doesn't contain, starts/ends with a string.
             */
            op: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends' | 'greater' | 'less';
            /**
             * The value to compare the email against.
             */
            value?: string;
          }
        | {
            condition_type?: 'PredictedGender';
            /**
             * Segment by predicted gender.
             */
            field: 'predicted_gender';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The predicted gender to segment.
             */
            value: 'male' | 'female';
          }
        | {
            condition_type?: 'PredictedAge';
            /**
             * Segment by predicted age.
             */
            field: 'predicted_age_range';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is';
            /**
             * The predicted age to segment.
             */
            value: '18-24' | '25-34' | '35-44' | '45-54' | '55-64' | '65+';
          }
        | {
            condition_type?: 'NewSubscribers';
            /**
             * Segment by when people subscribed.
             */
            field?: 'timestamp_opt';
            /**
             * Whe the event took place, namely within a time frame.
             */
            op?: 'date_within';
            /**
             * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
             */
            value?: string;
          }
      >;
      /**
       * Segment match type.
       */
      match?: 'any' | 'all';
      /**
       * The prebuilt segment id, if a prebuilt segment has been designated for this campaign.
       */
      prebuilt_segment_id?: string;
      /**
       * The id for an existing saved segment.
       */
      saved_segment_id?: number;
    };
    /**
     * A description of the [segment](https://mailchimp.com/help/create-and-send-to-a-segment/) used for the campaign. Formatted as a string marked up with HTML.
     */
    readonly segment_text?: string;
  };
  /**
   * For sent campaigns, a summary of opens, clicks, and e-commerce data.
   */
  report_summary?: {
    /**
     * The number of unique clicks divided by the total number of successful deliveries.
     */
    readonly click_rate?: number;
    /**
     * The total number of clicks for an campaign.
     */
    readonly clicks?: number;
    /**
     * E-Commerce stats for a campaign.
     */
    ecommerce?: {
      /**
       * The total orders for a campaign.
       */
      readonly total_orders?: number;
      /**
       * The total revenue for a campaign. Calculated as the sum of all order totals minus shipping and tax totals.
       */
      readonly total_revenue?: number;
      /**
       * The total spent for a campaign. Calculated as the sum of all order totals with no deductions.
       */
      readonly total_spent?: number;
    };
    /**
     * The number of unique opens divided by the total number of successful deliveries.
     */
    readonly open_rate?: number;
    /**
     * The total number of opens for a campaign.
     */
    readonly opens?: number;
    /**
     * The number of unique clicks.
     */
    readonly subscriber_clicks?: number;
    /**
     * The number of unique opens.
     */
    readonly unique_opens?: number;
  };
  /**
   * Determines if the campaign qualifies to be resent to non-openers.
   */
  readonly resendable?: boolean;
  /**
   * [RSS](https://mailchimp.com/help/share-your-blog-posts-with-mailchimp/) options for a campaign.
   */
  rss_opts?: {
    /**
     * Whether to add CSS to images in the RSS feed to constrain their width in campaigns.
     */
    constrain_rss_img?: boolean;
    /**
     * The URL for the RSS feed.
     */
    feed_url?: string;
    /**
     * The frequency of the RSS Campaign.
     */
    frequency?: 'daily' | 'weekly' | 'monthly';
    /**
     * The date the campaign was last sent.
     */
    readonly last_sent?: string;
    /**
     * The schedule for sending the RSS Campaign.
     */
    schedule?: {
      /**
       * The days of the week to send a daily RSS Campaign.
       */
      daily_send?: {
        /**
         * Sends the daily RSS Campaign on Fridays.
         */
        friday?: boolean;
        /**
         * Sends the daily RSS Campaign on Mondays.
         */
        monday?: boolean;
        /**
         * Sends the daily RSS Campaign on Saturdays.
         */
        saturday?: boolean;
        /**
         * Sends the daily RSS Campaign on Sundays.
         */
        sunday?: boolean;
        /**
         * Sends the daily RSS Campaign on Thursdays.
         */
        thursday?: boolean;
        /**
         * Sends the daily RSS Campaign on Tuesdays.
         */
        tuesday?: boolean;
        /**
         * Sends the daily RSS Campaign on Wednesdays.
         */
        wednesday?: boolean;
      };
      /**
       * The hour to send the campaign in local time. Acceptable hours are 0-23. For example, '4' would be 4am in [your account's default time zone](https://mailchimp.com/help/set-account-defaults/).
       */
      hour?: number;
      /**
       * The day of the month to send a monthly RSS Campaign. Acceptable days are 0-31, where '0' is always the last day of a month. Months with fewer than the selected number of days will not have an RSS campaign sent out that day. For example, RSS Campaigns set to send on the 30th will not go out in February.
       */
      monthly_send_date?: number;
      /**
       * The day of the week to send a weekly RSS Campaign.
       */
      weekly_send_day?: 'sunday' | 'monday' | 'tuesday' | 'wednesday' | 'thursday' | 'friday' | 'saturday';
    };
  };
  /**
   * The date and time a campaign was sent.
   */
  readonly send_time?: string;
  /**
   * The settings for your campaign, including subject, from name, reply-to address, and more.
   */
  settings?: {
    /**
     * Whether Mailchimp [authenticated](https://mailchimp.com/help/about-email-authentication/) the campaign. Defaults to `true`.
     */
    authenticate?: boolean;
    /**
     * An array of [Facebook](https://mailchimp.com/help/connect-or-disconnect-the-facebook-integration/) page ids to auto-post to.
     */
    auto_fb_post?: Array<string>;
    /**
     * Automatically append Mailchimp's [default footer](https://mailchimp.com/help/about-campaign-footers/) to the campaign.
     */
    auto_footer?: boolean;
    /**
     * Automatically tweet a link to the [campaign archive](https://mailchimp.com/help/about-email-campaign-archives-and-pages/) page when the campaign is sent.
     */
    auto_tweet?: boolean;
    /**
     * Whether the campaign uses the drag-and-drop editor.
     */
    readonly drag_and_drop?: boolean;
    /**
     * Allows Facebook comments on the campaign (also force-enables the Campaign Archive toolbar). Defaults to `true`.
     */
    fb_comments?: boolean;
    /**
     * If the campaign is listed in a folder, the id for that folder.
     */
    folder_id?: string;
    /**
     * The 'from' name on the campaign (not an email address).
     */
    from_name?: string;
    /**
     * Automatically inline the CSS included with the campaign content.
     */
    inline_css?: boolean;
    /**
     * The preview text for the campaign.
     */
    preview_text?: string;
    /**
     * The reply-to email address for the campaign.
     */
    reply_to?: string;
    /**
     * The subject line for the campaign.
     */
    subject_line?: string;
    /**
     * The id for the template used in this campaign.
     */
    template_id?: number;
    /**
     * Send this campaign using [Timewarp](https://mailchimp.com/help/use-timewarp/).
     */
    readonly timewarp?: boolean;
    /**
     * The title of the campaign.
     */
    title?: string;
    /**
     * The campaign's custom 'To' name. Typically the first name [audience field](https://mailchimp.com/help/getting-started-with-merge-tags/).
     */
    to_name?: string;
    /**
     * Use Mailchimp Conversation feature to manage out-of-office replies.
     */
    use_conversation?: boolean;
  };
  /**
   * The preview for the campaign, rendered by social networks like Facebook and Twitter. [Learn more](https://mailchimp.com/help/enable-and-customize-social-cards/).
   */
  social_card?: {
    /**
     * A short summary of the campaign to display.
     */
    description?: string;
    /**
     * The url for the header image for the card.
     */
    image_url?: string;
    /**
     * The title for the card. Typically the subject line of the campaign.
     */
    title?: string;
  };
  /**
   * The current status of the campaign.
   */
  readonly status?: 'save' | 'paused' | 'schedule' | 'sending' | 'sent' | 'canceled' | 'canceling' | 'archived';
  /**
   * The tracking options for a campaign.
   */
  tracking?: {
    /**
     * Deprecated
     */
    capsule?: {
      /**
       * Update contact notes for a campaign based on subscriber email addresses.
       */
      notes?: boolean;
    };
    /**
     * The custom slug for [ClickTale](https://mailchimp.com/help/additional-tracking-options-for-campaigns/) tracking (max of 50 bytes).
     */
    clicktale?: string;
    /**
     * Whether to enable e-commerce tracking.
     */
    ecomm360?: boolean;
    /**
     * Deprecated
     */
    goal_tracking?: boolean;
    /**
     * The custom slug for [Google Analytics](https://mailchimp.com/help/integrate-google-analytics-with-mailchimp/) tracking (max of 50 bytes).
     */
    google_analytics?: string;
    /**
     * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the HTML version of the campaign. Defaults to `true`. Cannot be set to false for variate campaigns.
     */
    html_clicks?: boolean;
    /**
     * Whether to [track opens](https://mailchimp.com/help/about-open-tracking/). Defaults to `true`. Cannot be set to false for variate campaigns.
     */
    opens?: boolean;
    /**
     * Deprecated
     */
    salesforce?: {
      /**
       * Create a campaign in a connected Salesforce account.
       */
      campaign?: boolean;
      /**
       * Update contact notes for a campaign based on subscriber email addresses.
       */
      notes?: boolean;
    };
    /**
     * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the plain-text version of the campaign. Defaults to `true`. Cannot be set to false for variate campaigns.
     */
    text_clicks?: boolean;
  };
  /**
   * There are four types of [campaigns](https://mailchimp.com/help/getting-started-with-campaigns/) you can create in Mailchimp. A/B Split campaigns have been deprecated and variate campaigns should be used instead.
   */
  type?: 'regular' | 'plaintext' | 'absplit' | 'rss' | 'variate';
  /**
   * The settings specific to A/B test campaigns.
   */
  variate_settings?: {
    /**
     * Combinations of possible variables used to build emails.
     */
    readonly combinations?: Array<{
      /**
       * The index of `variate_settings.contents` used.
       */
      content_description?: number;
      /**
       * The index of `variate_settings.from_names` used.
       */
      from_name?: number;
      /**
       * Unique ID for the combination.
       */
      id?: string;
      /**
       * The number of recipients for this combination.
       */
      recipients?: number;
      /**
       * The index of `variate_settings.reply_to_addresses` used.
       */
      reply_to?: number;
      /**
       * The index of `variate_settings.send_times` used.
       */
      send_time?: number;
      /**
       * The index of `variate_settings.subject_lines` used.
       */
      subject_line?: number;
    }>;
    /**
     * Descriptions of possible email contents. To set campaign contents, make a PUT request to /campaigns/{campaign_id}/content with the field 'variate_contents'.
     */
    readonly contents?: Array<string>;
    /**
     * The possible from names. The number of from_names provided must match the number of reply_to_addresses. If no from_names are provided, settings.from_name will be used.
     */
    from_names?: Array<string>;
    /**
     * The possible reply-to addresses. The number of reply_to_addresses provided must match the number of from_names. If no reply_to_addresses are provided, settings.reply_to will be used.
     */
    reply_to_addresses?: Array<string>;
    /**
     * The possible send times to test. The times provided should be in the format YYYY-MM-DD HH:MM:SS. If send_times are provided to test, the test_size will be set to 100% and winner_criteria will be ignored.
     */
    send_times?: Array<string>;
    /**
     * The possible subject lines to test. If no subject lines are provided, settings.subject_line will be used.
     */
    subject_lines?: Array<string>;
    /**
     * The percentage of recipients to send the test combinations to, must be a value between 10 and 100.
     */
    test_size?: number;
    /**
     * The number of minutes to wait before choosing the winning campaign. The value of wait_time must be greater than 0 and in whole hours, specified in minutes.
     */
    wait_time?: number;
    /**
     * The combination that performs the best. This may be determined automatically by click rate, open rate, or total revenue -- or you may choose manually based on the reporting data you find the most valuable. For Multivariate Campaigns testing send_time, winner_criteria is ignored. For Multivariate Campaigns with 'manual' as the winner_criteria, the winner must be chosen in the Mailchimp web application.
     */
    winner_criteria?: 'opens' | 'clicks' | 'manual' | 'total_revenue';
    /**
     * ID of the campaign that was sent to the remaining recipients based on the winning combination.
     */
    readonly winning_campaign_id?: string;
    /**
     * ID for the winning combination.
     */
    readonly winning_combination_id?: string;
  };
  /**
   * The ID used in the Mailchimp web application. View this campaign in your Mailchimp account at `https://{dc}.admin.mailchimp.com/campaigns/show/?id={web_id}`.
   */
  readonly web_id?: number;
};

export type PostCampaignsError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type DeleteCampaignsIdData = {
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
  };
};

export type DeleteCampaignsIdResponse = any;

export type DeleteCampaignsIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetCampaignsIdData = {
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetCampaignsIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * [A/B Testing](https://mailchimp.com/help/about-ab-testing-campaigns/) options for a campaign.
   */
  readonly ab_split_opts?: {
    /**
     * For campaigns split on 'From Name', the name for Group A.
     */
    from_name_a?: string;
    /**
     * For campaigns split on 'From Name', the name for Group B.
     */
    from_name_b?: string;
    /**
     * How we should evaluate a winner. Based on 'opens', 'clicks', or 'manual'.
     */
    pick_winner?: 'opens' | 'clicks' | 'manual';
    /**
     * For campaigns split on 'From Name', the reply-to address for Group A.
     */
    reply_email_a?: string;
    /**
     * For campaigns split on 'From Name', the reply-to address for Group B.
     */
    reply_email_b?: string;
    /**
     * The send time for Group A.
     */
    send_time_a?: string;
    /**
     * The send time for Group B.
     */
    send_time_b?: string;
    /**
     * The send time for the winning version.
     */
    send_time_winner?: string;
    /**
     * The size of the split groups. Campaigns split based on 'schedule' are forced to have a 50/50 split. Valid split integers are between 1-50.
     */
    split_size?: number;
    /**
     * The type of AB split to run.
     */
    split_test?: 'subject' | 'from_name' | 'schedule';
    /**
     * For campaigns split on 'Subject Line', the subject line for Group A.
     */
    subject_a?: string;
    /**
     * For campaigns split on 'Subject Line', the subject line for Group B.
     */
    subject_b?: string;
    /**
     * The amount of time to wait before picking a winner. This cannot be changed after a campaign is sent.
     */
    wait_time?: number;
    /**
     * How unit of time for measuring the winner ('hours' or 'days'). This cannot be changed after a campaign is sent.
     */
    wait_units?: 'hours' | 'days';
  };
  /**
   * The link to the campaign's archive version in ISO 8601 format.
   */
  readonly archive_url?: string;
  /**
   * How the campaign's content is put together.
   */
  content_type?: 'template' | 'html' | 'url' | 'multichannel';
  /**
   * The date and time the campaign was created in ISO 8601 format.
   */
  readonly create_time?: string;
  /**
   * Updates on campaigns in the process of sending.
   */
  delivery_status?: {
    /**
     * Whether a campaign send can be canceled.
     */
    readonly can_cancel?: boolean;
    /**
     * The total number of emails canceled for this campaign.
     */
    readonly emails_canceled?: number;
    /**
     * The total number of emails confirmed sent for this campaign so far.
     */
    readonly emails_sent?: number;
    /**
     * Whether Campaign Delivery Status is enabled for this account and campaign.
     */
    readonly enabled?: boolean;
    /**
     * The current state of a campaign delivery.
     */
    readonly status?: 'delivering' | 'delivered' | 'canceling' | 'canceled';
  };
  /**
   * The total number of emails sent for this campaign.
   */
  readonly emails_sent?: number;
  /**
   * A string that uniquely identifies this campaign.
   */
  readonly id?: string;
  /**
   * The original link to the campaign's archive version.
   */
  readonly long_archive_url?: string;
  /**
   * Determines if the campaign needs its blocks refreshed by opening the web-based campaign editor. Deprecated and will always return false.
   */
  readonly needs_block_refresh?: boolean;
  /**
   * If this campaign is the child of another campaign, this identifies the parent campaign. For Example, for RSS or Automation children.
   */
  readonly parent_campaign_id?: string;
  /**
   * List settings for the campaign.
   */
  recipients?: {
    /**
     * The unique list id.
     */
    list_id?: string;
    /**
     * The status of the list used, namely if it's deleted or disabled.
     */
    readonly list_is_active?: boolean;
    /**
     * The name of the list.
     */
    readonly list_name?: string;
    /**
     * Count of the recipients on the associated list. Formatted as an integer.
     */
    readonly recipient_count?: number;
    /**
     * An object representing all segmentation options. This object should contain a `saved_segment_id` to use an existing segment, or you can create a new segment by including both `match` and `conditions` options.
     */
    segment_opts?: {
      /**
       * Segment match conditions. There are multiple possible types, see the [condition types documentation](https://mailchimp.com/developer/marketing/docs/alternative-schemas/#segment-condition-schemas).
       */
      conditions?: Array<
        | {
            condition_type?: 'Aim';
            /**
             * Segment by interaction with a specific campaign.
             */
            field?: 'aim';
            /**
             * The status of the member with regard to their campaign interaction. One of the following: opened, clicked, was sent, didn't open, didn't click, or was not sent.
             */
            op?: 'open' | 'click' | 'sent' | 'noopen' | 'noclick' | 'nosent';
            /**
             * Either the web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
             */
            value?: string;
          }
        | {
            condition_type?: 'Automation';
            /**
             * Segment by interaction with an Automation workflow.
             */
            field: 'automation';
            /**
             * The status of the member with regard to the automation workflow. One of the following: has started the workflow, has completed the workflow, has not started the workflow, or has not completed the workflow.
             */
            op: 'started' | 'completed' | 'not_started' | 'not_completed';
            /**
             * The web id for the automation workflow to segment against.
             */
            value: string;
          }
        | {
            condition_type?: 'CampaignPoll';
            /**
             * Segment by poll activity.
             */
            field: 'poll';
            /**
             * Members have/have not interacted with a specific poll in a Mailchimp email.
             */
            op: 'member' | 'notmember';
            /**
             * The id for the poll.
             */
            value: number;
          }
        | {
            condition_type?: 'Conversation';
            /**
             * Segment by interaction with a campaign via Conversations.
             */
            field: 'conversation';
            /**
             * The status of a member's interaction with a conversation. One of the following: has replied or has not replied.
             */
            op: 'member' | 'notmember';
            /**
             * The web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
             */
            value: string;
          }
        | {
            condition_type?: 'Date';
            /**
             * When segmenting on 'date' or 'campaign', the date for the segment formatted as YYYY-MM-DD or the web id for the campaign.
             */
            extra?: string;
            /**
             * The type of date field to segment on: The opt-in time for a signup, the date the subscriber was last updated, or the date of their last ecomm purchase.
             */
            field: 'timestamp_opt' | 'info_changed' | 'ecomm_date';
            /**
             * When the event took place:  Before, after, is a specific date, is not a specific date, is blank, or is not blank.
             */
            op: 'greater' | 'less' | 'is' | 'not' | 'blank' | 'blank_not' | 'within' | 'notwithin';
            /**
             * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
             */
            value: string;
          }
        | {
            condition_type?: 'EmailClient';
            /**
             * Segment by use of a particular email client.
             */
            field: 'email_client';
            /**
             * The operation to determine whether we select clients that match the value, or clients that do not match the value.
             */
            op: 'client_is' | 'client_not';
            /**
             * The name of the email client.
             */
            value: string;
          }
        | {
            condition_type?: 'Language';
            /**
             * Segmenting based off of a subscriber's language.
             */
            field: 'language';
            /**
             * Whether the member's language is or is not set to a specific language.
             */
            op: 'is' | 'not';
            /**
             * A two-letter language identifier.
             */
            value: string;
          }
        | {
            condition_type?: 'MemberRating';
            /**
             * Segment by member rating.
             */
            field: 'rating';
            /**
             * Members who have have a rating that is/not exactly a given number or members who have a rating greater/less than a given number.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * The star rating number to segment against.
             */
            value: number;
          }
        | {
            condition_type: 'SignupSource';
            field: 'source';
            /**
             * Whether the member's signup source was/was not a particular value.
             */
            op: 'source_is' | 'source_not';
            /**
             * The signup source.
             */
            value?: string;
          }
        | {
            condition_type?: 'SurveyMonkey';
            /**
             * Segment by interaction with a SurveyMonkey survey.
             */
            field: 'survey_monkey';
            /**
             * The status of the member with regard to the survey.One of the following: has started the survey, has completed the survey, has not started the survey, or has not completed the survey.
             */
            op: 'started' | 'completed' | 'not_started' | 'not_completed';
            /**
             * The unique ID of the survey monkey survey.
             */
            value: string;
          }
        | {
            condition_type?: 'VIP';
            /**
             * Segment by VIP status.
             */
            field: 'gmonkey';
            /**
             * Whether the member is or is not marked as VIP.
             */
            op: 'member' | 'notmember';
          }
        | {
            condition_type?: 'Interests';
            /**
             * Segmenting based on interest group information. This should start with 'interests-' followed by the grouping id. Ex. 'interests-123'.
             */
            field?: string;
            /**
             * Whether the member is a part of one, all, or none of the groups.
             */
            op?: 'interestcontains' | 'interestcontainsall' | 'interestnotcontains';
            /**
             * An array containing strings, each representing a group id.
             */
            value?: Array<string>;
          }
        | {
            condition_type?: 'EcommCategory';
            /**
             * Segment by purchases in specific items or categories.
             */
            field?: 'ecomm_cat' | 'ecomm_prod';
            /**
             * A member who has purchased from a category/specific item that is/is not a specific name, where the category/item name contains/doesn't contain a specific phrase or string, or a category/item name that starts/ends with a string.
             */
            op?: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends';
            /**
             * The ecommerce category/item information.
             */
            value?: string;
          }
        | {
            condition_type?: 'EcommNumber';
            /**
             * Segment by average spent total, number of orders, total number of products purchased, or average number of products per order.
             */
            field: 'ecomm_spent_avg' | 'ecomm_orders' | 'ecomm_prod_all' | 'ecomm_avg_ord';
            /**
             * Members who have spent exactly, have not spent exactly, spent more, or spent less than the segment value.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * Members who have spent exactly, have not spent exactly, spent more, or spent less than this amount.
             */
            value: number;
          }
        | {
            condition_type?: 'EcommPurchased';
            /**
             * Segment by whether someone has purchased anything.
             */
            field?: 'ecomm_purchased';
            /**
             * Members who have have ('member') or have not ('notmember') purchased.
             */
            op?: 'member' | 'notmember';
          }
        | {
            condition_type?: 'EcommSpent';
            /**
             * Segment by amount spent on a single order or across all orders.
             */
            field?: 'ecomm_spent_one' | 'ecomm_spent_all';
            /**
             * Members who have spent 'more' or 'less' than then specified value.
             */
            op?: 'greater' | 'less';
            /**
             * The total amount a member spent.
             */
            value?: number;
          }
        | {
            condition_type?: 'EcommStore';
            /**
             * Segment by purchases from a specific store.
             */
            field?: 'ecomm_store';
            /**
             * Members who have or have not purchased from a specific store.
             */
            op?: 'is' | 'not';
            /**
             * The store id to segment against.
             */
            value?: string;
          }
        | {
            condition_type?: 'GoalActivity';
            /**
             * Segment by Goal activity.
             */
            field: 'goal';
            /**
             * Whether the website URL is/not exactly, contains/doesn't contain, starts with/ends with a string.
             */
            op: 'is' | 'goal_not' | 'contains' | 'goal_notcontain' | 'starts' | 'ends';
            /**
             * The URL to check Goal activity against.
             */
            value: string;
          }
        | {
            condition_type?: 'GoalTimestamp';
            /**
             * Segment by most recent interaction with a website.
             */
            field: 'goal_last_visited';
            /**
             * Whether the website activity happened after, before, or at a given timestamp.
             */
            op: 'greater' | 'less' | 'is';
            /**
             * The date to check Goal activity against.
             */
            value: string;
          }
        | {
            condition_type?: 'FuzzySegment';
            /**
             * Segment by similar subscribers.
             */
            field: 'fuzzy_segment';
            /**
             * Members who are/are not apart of a 'similar subscribers' segment.
             */
            op: 'fuzzy_is' | 'fuzzy_not';
            /**
             * The id for the 'similar subscribers' segment.
             */
            value: number;
          }
        | {
            condition_type?: 'StaticSegment';
            /**
             * Segment by a given static segment.
             */
            field: 'static_segment';
            /**
             * Members who are/are not apart of a static segment.
             */
            op: 'static_is' | 'static_not';
            /**
             * The id for the static segment.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoCountryState';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are within a specific country or US state.
             */
            op: 'ipgeocountry' | 'ipgeonotcountry' | 'ipgeostate' | 'ipgeonotstate';
            /**
             * The two-letter country code or US state abbreviation.
             */
            value: string;
          }
        | {
            /**
             * The address of the target location.
             */
            addr: string;
            condition_type?: 'IPGeoIn';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * The latitude of the target location.
             */
            lat: string;
            /**
             * The longitude of the target location.
             */
            lng: string;
            /**
             * Segment members who are within a specific geographic region.
             */
            op: 'ipgeoin' | 'ipgeonotin';
            /**
             * The radius of the target location.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoInZip';
            /**
             * The zip code to segment against.
             */
            extra: number;
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are within a specific US zip code.
             */
            op: 'ipgeoinzip';
            /**
             * The radius of the target location.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoUnknown';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members for which location information is unknown.
             */
            op: 'ipgeounknown';
          }
        | {
            condition_type?: 'IPGeoZip';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are/are not within a specific US zip code.
             */
            op: 'ipgeoiszip' | 'ipgeonotzip';
            /**
             * The 5-digit zip code.
             */
            value: number;
          }
        | {
            condition_type?: 'SocialAge';
            /**
             * Segment by age ranges in Social Profiles data.
             */
            field: 'social_age';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The age range to segment.
             */
            value: '18-24' | '25-34' | '35-54' | '55+';
          }
        | {
            condition_type?: 'SocialGender';
            /**
             * Segment by listed gender in Social Profiles data.
             */
            field: 'social_gender';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The Social Profiles gender to segment.
             */
            value: 'male' | 'female';
          }
        | {
            condition_type?: 'SocialInfluence';
            /**
             * Segment by influence rating in Social Profiles data.
             */
            field: 'social_influence';
            /**
             * Members who have a rating that is/not or greater/less than the rating provided.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * The Social Profiles influence rating to segment.
             */
            value: number;
          }
        | {
            condition_type?: 'SocialNetworkMember';
            /**
             * Segment by social network in Social Profiles data.
             */
            field: 'social_network';
            /**
             * Members who are/not on a given social network.
             */
            op: 'member' | 'notmember';
            /**
             * The social network to segment against.
             */
            value:
              | 'twitter'
              | 'facebook'
              | 'linkedin'
              | 'flickr'
              | 'foursquare'
              | 'lastfm'
              | 'myspace'
              | 'quora'
              | 'vimeo'
              | 'yelp'
              | 'youtube';
          }
        | {
            condition_type?: 'SocialNetworkFollow';
            /**
             * Segment by social network in Social Profiles data.
             */
            field: 'social_network';
            /**
             * Members who are/not following a linked account on a given social network.
             */
            op: 'follow' | 'notfollow';
            /**
             * The social network to segment against.
             */
            value: 'twitter_follow';
          }
        | {
            condition_type?: 'AddressMerge';
            /**
             * An address-type merge field to segment.
             */
            field: string;
            /**
             * Whether the member's address merge field contains/does not contain a value or is/is not blank.
             */
            op: 'contains' | 'notcontain' | 'blank' | 'blank_not';
            /**
             * The value to segment a text merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'ZipMerge';
            /**
             * The city or the zip being used to segment against.
             */
            extra: string;
            /**
             * An address or zip-type merge field to segment.
             */
            field: string;
            /**
             * Whether the member's address merge field is within a given distance from a city or zip.
             */
            op: 'geoin';
            /**
             * The distance from the city/zip.
             */
            value: string;
          }
        | {
            condition_type?: 'BirthdayMerge';
            /**
             * A date merge field to segment.
             */
            field: string;
            /**
             * Whether the member's birthday merge information is/is not a certain date or is/is not blank.
             */
            op: 'is' | 'not' | 'blank' | 'blank_not';
            /**
             * A date to segment against (mm/dd).
             */
            value?: string;
          }
        | {
            condition_type?: 'DateMerge';
            /**
             * A date merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not, is greater/less than a value or is/is not blank.
             */
            op: 'is' | 'not' | 'less' | 'blank' | 'blank_not' | 'greater';
            /**
             * A date to segment against.
             */
            value?: string;
          }
        | {
            condition_type?: 'SelectMerge';
            /**
             * A merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not a value or is/is not blank.
             */
            op: 'is' | 'not' | 'blank' | 'blank_not' | 'notcontain' | 'contains';
            /**
             * The value to segment a text merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'TextMerge';
            /**
             * A text or number merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not, contains/does not contain, starts/ends with, or is greater/less than a value
             */
            op:
              | 'is'
              | 'not'
              | 'contains'
              | 'notcontain'
              | 'starts'
              | 'ends'
              | 'greater'
              | 'less'
              | 'blank'
              | 'blank_not';
            /**
             * The value to segment a text or number merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'EmailAddress';
            /**
             * Segmenting based off of a subscriber's email address.
             */
            field: 'merge0' | 'EMAIL';
            /**
             * Whether the email address is/not exactly, contains/doesn't contain, starts/ends with a string.
             */
            op: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends' | 'greater' | 'less';
            /**
             * The value to compare the email against.
             */
            value?: string;
          }
        | {
            condition_type?: 'PredictedGender';
            /**
             * Segment by predicted gender.
             */
            field: 'predicted_gender';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The predicted gender to segment.
             */
            value: 'male' | 'female';
          }
        | {
            condition_type?: 'PredictedAge';
            /**
             * Segment by predicted age.
             */
            field: 'predicted_age_range';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is';
            /**
             * The predicted age to segment.
             */
            value: '18-24' | '25-34' | '35-44' | '45-54' | '55-64' | '65+';
          }
        | {
            condition_type?: 'NewSubscribers';
            /**
             * Segment by when people subscribed.
             */
            field?: 'timestamp_opt';
            /**
             * Whe the event took place, namely within a time frame.
             */
            op?: 'date_within';
            /**
             * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
             */
            value?: string;
          }
      >;
      /**
       * Segment match type.
       */
      match?: 'any' | 'all';
      /**
       * The prebuilt segment id, if a prebuilt segment has been designated for this campaign.
       */
      prebuilt_segment_id?: string;
      /**
       * The id for an existing saved segment.
       */
      saved_segment_id?: number;
    };
    /**
     * A description of the [segment](https://mailchimp.com/help/create-and-send-to-a-segment/) used for the campaign. Formatted as a string marked up with HTML.
     */
    readonly segment_text?: string;
  };
  /**
   * For sent campaigns, a summary of opens, clicks, and e-commerce data.
   */
  report_summary?: {
    /**
     * The number of unique clicks divided by the total number of successful deliveries.
     */
    readonly click_rate?: number;
    /**
     * The total number of clicks for an campaign.
     */
    readonly clicks?: number;
    /**
     * E-Commerce stats for a campaign.
     */
    ecommerce?: {
      /**
       * The total orders for a campaign.
       */
      readonly total_orders?: number;
      /**
       * The total revenue for a campaign. Calculated as the sum of all order totals minus shipping and tax totals.
       */
      readonly total_revenue?: number;
      /**
       * The total spent for a campaign. Calculated as the sum of all order totals with no deductions.
       */
      readonly total_spent?: number;
    };
    /**
     * The number of unique opens divided by the total number of successful deliveries.
     */
    readonly open_rate?: number;
    /**
     * The total number of opens for a campaign.
     */
    readonly opens?: number;
    /**
     * The number of unique clicks.
     */
    readonly subscriber_clicks?: number;
    /**
     * The number of unique opens.
     */
    readonly unique_opens?: number;
  };
  /**
   * Determines if the campaign qualifies to be resent to non-openers.
   */
  readonly resendable?: boolean;
  /**
   * [RSS](https://mailchimp.com/help/share-your-blog-posts-with-mailchimp/) options for a campaign.
   */
  rss_opts?: {
    /**
     * Whether to add CSS to images in the RSS feed to constrain their width in campaigns.
     */
    constrain_rss_img?: boolean;
    /**
     * The URL for the RSS feed.
     */
    feed_url?: string;
    /**
     * The frequency of the RSS Campaign.
     */
    frequency?: 'daily' | 'weekly' | 'monthly';
    /**
     * The date the campaign was last sent.
     */
    readonly last_sent?: string;
    /**
     * The schedule for sending the RSS Campaign.
     */
    schedule?: {
      /**
       * The days of the week to send a daily RSS Campaign.
       */
      daily_send?: {
        /**
         * Sends the daily RSS Campaign on Fridays.
         */
        friday?: boolean;
        /**
         * Sends the daily RSS Campaign on Mondays.
         */
        monday?: boolean;
        /**
         * Sends the daily RSS Campaign on Saturdays.
         */
        saturday?: boolean;
        /**
         * Sends the daily RSS Campaign on Sundays.
         */
        sunday?: boolean;
        /**
         * Sends the daily RSS Campaign on Thursdays.
         */
        thursday?: boolean;
        /**
         * Sends the daily RSS Campaign on Tuesdays.
         */
        tuesday?: boolean;
        /**
         * Sends the daily RSS Campaign on Wednesdays.
         */
        wednesday?: boolean;
      };
      /**
       * The hour to send the campaign in local time. Acceptable hours are 0-23. For example, '4' would be 4am in [your account's default time zone](https://mailchimp.com/help/set-account-defaults/).
       */
      hour?: number;
      /**
       * The day of the month to send a monthly RSS Campaign. Acceptable days are 0-31, where '0' is always the last day of a month. Months with fewer than the selected number of days will not have an RSS campaign sent out that day. For example, RSS Campaigns set to send on the 30th will not go out in February.
       */
      monthly_send_date?: number;
      /**
       * The day of the week to send a weekly RSS Campaign.
       */
      weekly_send_day?: 'sunday' | 'monday' | 'tuesday' | 'wednesday' | 'thursday' | 'friday' | 'saturday';
    };
  };
  /**
   * The date and time a campaign was sent.
   */
  readonly send_time?: string;
  /**
   * The settings for your campaign, including subject, from name, reply-to address, and more.
   */
  settings?: {
    /**
     * Whether Mailchimp [authenticated](https://mailchimp.com/help/about-email-authentication/) the campaign. Defaults to `true`.
     */
    authenticate?: boolean;
    /**
     * An array of [Facebook](https://mailchimp.com/help/connect-or-disconnect-the-facebook-integration/) page ids to auto-post to.
     */
    auto_fb_post?: Array<string>;
    /**
     * Automatically append Mailchimp's [default footer](https://mailchimp.com/help/about-campaign-footers/) to the campaign.
     */
    auto_footer?: boolean;
    /**
     * Automatically tweet a link to the [campaign archive](https://mailchimp.com/help/about-email-campaign-archives-and-pages/) page when the campaign is sent.
     */
    auto_tweet?: boolean;
    /**
     * Whether the campaign uses the drag-and-drop editor.
     */
    readonly drag_and_drop?: boolean;
    /**
     * Allows Facebook comments on the campaign (also force-enables the Campaign Archive toolbar). Defaults to `true`.
     */
    fb_comments?: boolean;
    /**
     * If the campaign is listed in a folder, the id for that folder.
     */
    folder_id?: string;
    /**
     * The 'from' name on the campaign (not an email address).
     */
    from_name?: string;
    /**
     * Automatically inline the CSS included with the campaign content.
     */
    inline_css?: boolean;
    /**
     * The preview text for the campaign.
     */
    preview_text?: string;
    /**
     * The reply-to email address for the campaign.
     */
    reply_to?: string;
    /**
     * The subject line for the campaign.
     */
    subject_line?: string;
    /**
     * The id for the template used in this campaign.
     */
    template_id?: number;
    /**
     * Send this campaign using [Timewarp](https://mailchimp.com/help/use-timewarp/).
     */
    readonly timewarp?: boolean;
    /**
     * The title of the campaign.
     */
    title?: string;
    /**
     * The campaign's custom 'To' name. Typically the first name [audience field](https://mailchimp.com/help/getting-started-with-merge-tags/).
     */
    to_name?: string;
    /**
     * Use Mailchimp Conversation feature to manage out-of-office replies.
     */
    use_conversation?: boolean;
  };
  /**
   * The preview for the campaign, rendered by social networks like Facebook and Twitter. [Learn more](https://mailchimp.com/help/enable-and-customize-social-cards/).
   */
  social_card?: {
    /**
     * A short summary of the campaign to display.
     */
    description?: string;
    /**
     * The url for the header image for the card.
     */
    image_url?: string;
    /**
     * The title for the card. Typically the subject line of the campaign.
     */
    title?: string;
  };
  /**
   * The current status of the campaign.
   */
  readonly status?: 'save' | 'paused' | 'schedule' | 'sending' | 'sent' | 'canceled' | 'canceling' | 'archived';
  /**
   * The tracking options for a campaign.
   */
  tracking?: {
    /**
     * Deprecated
     */
    capsule?: {
      /**
       * Update contact notes for a campaign based on subscriber email addresses.
       */
      notes?: boolean;
    };
    /**
     * The custom slug for [ClickTale](https://mailchimp.com/help/additional-tracking-options-for-campaigns/) tracking (max of 50 bytes).
     */
    clicktale?: string;
    /**
     * Whether to enable e-commerce tracking.
     */
    ecomm360?: boolean;
    /**
     * Deprecated
     */
    goal_tracking?: boolean;
    /**
     * The custom slug for [Google Analytics](https://mailchimp.com/help/integrate-google-analytics-with-mailchimp/) tracking (max of 50 bytes).
     */
    google_analytics?: string;
    /**
     * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the HTML version of the campaign. Defaults to `true`. Cannot be set to false for variate campaigns.
     */
    html_clicks?: boolean;
    /**
     * Whether to [track opens](https://mailchimp.com/help/about-open-tracking/). Defaults to `true`. Cannot be set to false for variate campaigns.
     */
    opens?: boolean;
    /**
     * Deprecated
     */
    salesforce?: {
      /**
       * Create a campaign in a connected Salesforce account.
       */
      campaign?: boolean;
      /**
       * Update contact notes for a campaign based on subscriber email addresses.
       */
      notes?: boolean;
    };
    /**
     * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the plain-text version of the campaign. Defaults to `true`. Cannot be set to false for variate campaigns.
     */
    text_clicks?: boolean;
  };
  /**
   * There are four types of [campaigns](https://mailchimp.com/help/getting-started-with-campaigns/) you can create in Mailchimp. A/B Split campaigns have been deprecated and variate campaigns should be used instead.
   */
  type?: 'regular' | 'plaintext' | 'absplit' | 'rss' | 'variate';
  /**
   * The settings specific to A/B test campaigns.
   */
  variate_settings?: {
    /**
     * Combinations of possible variables used to build emails.
     */
    readonly combinations?: Array<{
      /**
       * The index of `variate_settings.contents` used.
       */
      content_description?: number;
      /**
       * The index of `variate_settings.from_names` used.
       */
      from_name?: number;
      /**
       * Unique ID for the combination.
       */
      id?: string;
      /**
       * The number of recipients for this combination.
       */
      recipients?: number;
      /**
       * The index of `variate_settings.reply_to_addresses` used.
       */
      reply_to?: number;
      /**
       * The index of `variate_settings.send_times` used.
       */
      send_time?: number;
      /**
       * The index of `variate_settings.subject_lines` used.
       */
      subject_line?: number;
    }>;
    /**
     * Descriptions of possible email contents. To set campaign contents, make a PUT request to /campaigns/{campaign_id}/content with the field 'variate_contents'.
     */
    readonly contents?: Array<string>;
    /**
     * The possible from names. The number of from_names provided must match the number of reply_to_addresses. If no from_names are provided, settings.from_name will be used.
     */
    from_names?: Array<string>;
    /**
     * The possible reply-to addresses. The number of reply_to_addresses provided must match the number of from_names. If no reply_to_addresses are provided, settings.reply_to will be used.
     */
    reply_to_addresses?: Array<string>;
    /**
     * The possible send times to test. The times provided should be in the format YYYY-MM-DD HH:MM:SS. If send_times are provided to test, the test_size will be set to 100% and winner_criteria will be ignored.
     */
    send_times?: Array<string>;
    /**
     * The possible subject lines to test. If no subject lines are provided, settings.subject_line will be used.
     */
    subject_lines?: Array<string>;
    /**
     * The percentage of recipients to send the test combinations to, must be a value between 10 and 100.
     */
    test_size?: number;
    /**
     * The number of minutes to wait before choosing the winning campaign. The value of wait_time must be greater than 0 and in whole hours, specified in minutes.
     */
    wait_time?: number;
    /**
     * The combination that performs the best. This may be determined automatically by click rate, open rate, or total revenue -- or you may choose manually based on the reporting data you find the most valuable. For Multivariate Campaigns testing send_time, winner_criteria is ignored. For Multivariate Campaigns with 'manual' as the winner_criteria, the winner must be chosen in the Mailchimp web application.
     */
    winner_criteria?: 'opens' | 'clicks' | 'manual' | 'total_revenue';
    /**
     * ID of the campaign that was sent to the remaining recipients based on the winning combination.
     */
    readonly winning_campaign_id?: string;
    /**
     * ID for the winning combination.
     */
    readonly winning_combination_id?: string;
  };
  /**
   * The ID used in the Mailchimp web application. View this campaign in your Mailchimp account at `https://{dc}.admin.mailchimp.com/campaigns/show/?id={web_id}`.
   */
  readonly web_id?: number;
};

export type GetCampaignsIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PatchCampaignsIdData = {
  body: {
    /**
     * List settings for the campaign.
     */
    recipients?: {
      /**
       * The unique list id.
       */
      list_id: string;
      /**
       * An object representing all segmentation options. This object should contain a `saved_segment_id` to use an existing segment, or you can create a new segment by including both `match` and `conditions` options.
       */
      segment_opts?: {
        /**
         * Segment match conditions. There are multiple possible types, see the [condition types documentation](https://mailchimp.com/developer/marketing/docs/alternative-schemas/#segment-condition-schemas).
         */
        conditions?: Array<
          | {
              condition_type?: 'Aim';
              /**
               * Segment by interaction with a specific campaign.
               */
              field?: 'aim';
              /**
               * The status of the member with regard to their campaign interaction. One of the following: opened, clicked, was sent, didn't open, didn't click, or was not sent.
               */
              op?: 'open' | 'click' | 'sent' | 'noopen' | 'noclick' | 'nosent';
              /**
               * Either the web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
               */
              value?: string;
            }
          | {
              condition_type?: 'Automation';
              /**
               * Segment by interaction with an Automation workflow.
               */
              field: 'automation';
              /**
               * The status of the member with regard to the automation workflow. One of the following: has started the workflow, has completed the workflow, has not started the workflow, or has not completed the workflow.
               */
              op: 'started' | 'completed' | 'not_started' | 'not_completed';
              /**
               * The web id for the automation workflow to segment against.
               */
              value: string;
            }
          | {
              condition_type?: 'CampaignPoll';
              /**
               * Segment by poll activity.
               */
              field: 'poll';
              /**
               * Members have/have not interacted with a specific poll in a Mailchimp email.
               */
              op: 'member' | 'notmember';
              /**
               * The id for the poll.
               */
              value: number;
            }
          | {
              condition_type?: 'Conversation';
              /**
               * Segment by interaction with a campaign via Conversations.
               */
              field: 'conversation';
              /**
               * The status of a member's interaction with a conversation. One of the following: has replied or has not replied.
               */
              op: 'member' | 'notmember';
              /**
               * The web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
               */
              value: string;
            }
          | {
              condition_type?: 'Date';
              /**
               * When segmenting on 'date' or 'campaign', the date for the segment formatted as YYYY-MM-DD or the web id for the campaign.
               */
              extra?: string;
              /**
               * The type of date field to segment on: The opt-in time for a signup, the date the subscriber was last updated, or the date of their last ecomm purchase.
               */
              field: 'timestamp_opt' | 'info_changed' | 'ecomm_date';
              /**
               * When the event took place:  Before, after, is a specific date, is not a specific date, is blank, or is not blank.
               */
              op: 'greater' | 'less' | 'is' | 'not' | 'blank' | 'blank_not' | 'within' | 'notwithin';
              /**
               * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
               */
              value: string;
            }
          | {
              condition_type?: 'EmailClient';
              /**
               * Segment by use of a particular email client.
               */
              field: 'email_client';
              /**
               * The operation to determine whether we select clients that match the value, or clients that do not match the value.
               */
              op: 'client_is' | 'client_not';
              /**
               * The name of the email client.
               */
              value: string;
            }
          | {
              condition_type?: 'Language';
              /**
               * Segmenting based off of a subscriber's language.
               */
              field: 'language';
              /**
               * Whether the member's language is or is not set to a specific language.
               */
              op: 'is' | 'not';
              /**
               * A two-letter language identifier.
               */
              value: string;
            }
          | {
              condition_type?: 'MemberRating';
              /**
               * Segment by member rating.
               */
              field: 'rating';
              /**
               * Members who have have a rating that is/not exactly a given number or members who have a rating greater/less than a given number.
               */
              op: 'is' | 'not' | 'greater' | 'less';
              /**
               * The star rating number to segment against.
               */
              value: number;
            }
          | {
              condition_type: 'SignupSource';
              field: 'source';
              /**
               * Whether the member's signup source was/was not a particular value.
               */
              op: 'source_is' | 'source_not';
              /**
               * The signup source.
               */
              value?: string;
            }
          | {
              condition_type?: 'SurveyMonkey';
              /**
               * Segment by interaction with a SurveyMonkey survey.
               */
              field: 'survey_monkey';
              /**
               * The status of the member with regard to the survey.One of the following: has started the survey, has completed the survey, has not started the survey, or has not completed the survey.
               */
              op: 'started' | 'completed' | 'not_started' | 'not_completed';
              /**
               * The unique ID of the survey monkey survey.
               */
              value: string;
            }
          | {
              condition_type?: 'VIP';
              /**
               * Segment by VIP status.
               */
              field: 'gmonkey';
              /**
               * Whether the member is or is not marked as VIP.
               */
              op: 'member' | 'notmember';
            }
          | {
              condition_type?: 'Interests';
              /**
               * Segmenting based on interest group information. This should start with 'interests-' followed by the grouping id. Ex. 'interests-123'.
               */
              field?: string;
              /**
               * Whether the member is a part of one, all, or none of the groups.
               */
              op?: 'interestcontains' | 'interestcontainsall' | 'interestnotcontains';
              /**
               * An array containing strings, each representing a group id.
               */
              value?: Array<string>;
            }
          | {
              condition_type?: 'EcommCategory';
              /**
               * Segment by purchases in specific items or categories.
               */
              field?: 'ecomm_cat' | 'ecomm_prod';
              /**
               * A member who has purchased from a category/specific item that is/is not a specific name, where the category/item name contains/doesn't contain a specific phrase or string, or a category/item name that starts/ends with a string.
               */
              op?: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends';
              /**
               * The ecommerce category/item information.
               */
              value?: string;
            }
          | {
              condition_type?: 'EcommNumber';
              /**
               * Segment by average spent total, number of orders, total number of products purchased, or average number of products per order.
               */
              field: 'ecomm_spent_avg' | 'ecomm_orders' | 'ecomm_prod_all' | 'ecomm_avg_ord';
              /**
               * Members who have spent exactly, have not spent exactly, spent more, or spent less than the segment value.
               */
              op: 'is' | 'not' | 'greater' | 'less';
              /**
               * Members who have spent exactly, have not spent exactly, spent more, or spent less than this amount.
               */
              value: number;
            }
          | {
              condition_type?: 'EcommPurchased';
              /**
               * Segment by whether someone has purchased anything.
               */
              field?: 'ecomm_purchased';
              /**
               * Members who have have ('member') or have not ('notmember') purchased.
               */
              op?: 'member' | 'notmember';
            }
          | {
              condition_type?: 'EcommSpent';
              /**
               * Segment by amount spent on a single order or across all orders.
               */
              field?: 'ecomm_spent_one' | 'ecomm_spent_all';
              /**
               * Members who have spent 'more' or 'less' than then specified value.
               */
              op?: 'greater' | 'less';
              /**
               * The total amount a member spent.
               */
              value?: number;
            }
          | {
              condition_type?: 'EcommStore';
              /**
               * Segment by purchases from a specific store.
               */
              field?: 'ecomm_store';
              /**
               * Members who have or have not purchased from a specific store.
               */
              op?: 'is' | 'not';
              /**
               * The store id to segment against.
               */
              value?: string;
            }
          | {
              condition_type?: 'GoalActivity';
              /**
               * Segment by Goal activity.
               */
              field: 'goal';
              /**
               * Whether the website URL is/not exactly, contains/doesn't contain, starts with/ends with a string.
               */
              op: 'is' | 'goal_not' | 'contains' | 'goal_notcontain' | 'starts' | 'ends';
              /**
               * The URL to check Goal activity against.
               */
              value: string;
            }
          | {
              condition_type?: 'GoalTimestamp';
              /**
               * Segment by most recent interaction with a website.
               */
              field: 'goal_last_visited';
              /**
               * Whether the website activity happened after, before, or at a given timestamp.
               */
              op: 'greater' | 'less' | 'is';
              /**
               * The date to check Goal activity against.
               */
              value: string;
            }
          | {
              condition_type?: 'FuzzySegment';
              /**
               * Segment by similar subscribers.
               */
              field: 'fuzzy_segment';
              /**
               * Members who are/are not apart of a 'similar subscribers' segment.
               */
              op: 'fuzzy_is' | 'fuzzy_not';
              /**
               * The id for the 'similar subscribers' segment.
               */
              value: number;
            }
          | {
              condition_type?: 'StaticSegment';
              /**
               * Segment by a given static segment.
               */
              field: 'static_segment';
              /**
               * Members who are/are not apart of a static segment.
               */
              op: 'static_is' | 'static_not';
              /**
               * The id for the static segment.
               */
              value: number;
            }
          | {
              condition_type?: 'IPGeoCountryState';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members who are within a specific country or US state.
               */
              op: 'ipgeocountry' | 'ipgeonotcountry' | 'ipgeostate' | 'ipgeonotstate';
              /**
               * The two-letter country code or US state abbreviation.
               */
              value: string;
            }
          | {
              /**
               * The address of the target location.
               */
              addr: string;
              condition_type?: 'IPGeoIn';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * The latitude of the target location.
               */
              lat: string;
              /**
               * The longitude of the target location.
               */
              lng: string;
              /**
               * Segment members who are within a specific geographic region.
               */
              op: 'ipgeoin' | 'ipgeonotin';
              /**
               * The radius of the target location.
               */
              value: number;
            }
          | {
              condition_type?: 'IPGeoInZip';
              /**
               * The zip code to segment against.
               */
              extra: number;
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members who are within a specific US zip code.
               */
              op: 'ipgeoinzip';
              /**
               * The radius of the target location.
               */
              value: number;
            }
          | {
              condition_type?: 'IPGeoUnknown';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members for which location information is unknown.
               */
              op: 'ipgeounknown';
            }
          | {
              condition_type?: 'IPGeoZip';
              /**
               * Segmenting subscribers who are within a specific location.
               */
              field: 'ipgeo';
              /**
               * Segment members who are/are not within a specific US zip code.
               */
              op: 'ipgeoiszip' | 'ipgeonotzip';
              /**
               * The 5-digit zip code.
               */
              value: number;
            }
          | {
              condition_type?: 'SocialAge';
              /**
               * Segment by age ranges in Social Profiles data.
               */
              field: 'social_age';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is' | 'not';
              /**
               * The age range to segment.
               */
              value: '18-24' | '25-34' | '35-54' | '55+';
            }
          | {
              condition_type?: 'SocialGender';
              /**
               * Segment by listed gender in Social Profiles data.
               */
              field: 'social_gender';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is' | 'not';
              /**
               * The Social Profiles gender to segment.
               */
              value: 'male' | 'female';
            }
          | {
              condition_type?: 'SocialInfluence';
              /**
               * Segment by influence rating in Social Profiles data.
               */
              field: 'social_influence';
              /**
               * Members who have a rating that is/not or greater/less than the rating provided.
               */
              op: 'is' | 'not' | 'greater' | 'less';
              /**
               * The Social Profiles influence rating to segment.
               */
              value: number;
            }
          | {
              condition_type?: 'SocialNetworkMember';
              /**
               * Segment by social network in Social Profiles data.
               */
              field: 'social_network';
              /**
               * Members who are/not on a given social network.
               */
              op: 'member' | 'notmember';
              /**
               * The social network to segment against.
               */
              value:
                | 'twitter'
                | 'facebook'
                | 'linkedin'
                | 'flickr'
                | 'foursquare'
                | 'lastfm'
                | 'myspace'
                | 'quora'
                | 'vimeo'
                | 'yelp'
                | 'youtube';
            }
          | {
              condition_type?: 'SocialNetworkFollow';
              /**
               * Segment by social network in Social Profiles data.
               */
              field: 'social_network';
              /**
               * Members who are/not following a linked account on a given social network.
               */
              op: 'follow' | 'notfollow';
              /**
               * The social network to segment against.
               */
              value: 'twitter_follow';
            }
          | {
              condition_type?: 'AddressMerge';
              /**
               * An address-type merge field to segment.
               */
              field: string;
              /**
               * Whether the member's address merge field contains/does not contain a value or is/is not blank.
               */
              op: 'contains' | 'notcontain' | 'blank' | 'blank_not';
              /**
               * The value to segment a text merge field with.
               */
              value?: string;
            }
          | {
              condition_type?: 'ZipMerge';
              /**
               * The city or the zip being used to segment against.
               */
              extra: string;
              /**
               * An address or zip-type merge field to segment.
               */
              field: string;
              /**
               * Whether the member's address merge field is within a given distance from a city or zip.
               */
              op: 'geoin';
              /**
               * The distance from the city/zip.
               */
              value: string;
            }
          | {
              condition_type?: 'BirthdayMerge';
              /**
               * A date merge field to segment.
               */
              field: string;
              /**
               * Whether the member's birthday merge information is/is not a certain date or is/is not blank.
               */
              op: 'is' | 'not' | 'blank' | 'blank_not';
              /**
               * A date to segment against (mm/dd).
               */
              value?: string;
            }
          | {
              condition_type?: 'DateMerge';
              /**
               * A date merge field to segment.
               */
              field: string;
              /**
               * Whether the member's merge information is/is not, is greater/less than a value or is/is not blank.
               */
              op: 'is' | 'not' | 'less' | 'blank' | 'blank_not' | 'greater';
              /**
               * A date to segment against.
               */
              value?: string;
            }
          | {
              condition_type?: 'SelectMerge';
              /**
               * A merge field to segment.
               */
              field: string;
              /**
               * Whether the member's merge information is/is not a value or is/is not blank.
               */
              op: 'is' | 'not' | 'blank' | 'blank_not' | 'notcontain' | 'contains';
              /**
               * The value to segment a text merge field with.
               */
              value?: string;
            }
          | {
              condition_type?: 'TextMerge';
              /**
               * A text or number merge field to segment.
               */
              field: string;
              /**
               * Whether the member's merge information is/is not, contains/does not contain, starts/ends with, or is greater/less than a value
               */
              op:
                | 'is'
                | 'not'
                | 'contains'
                | 'notcontain'
                | 'starts'
                | 'ends'
                | 'greater'
                | 'less'
                | 'blank'
                | 'blank_not';
              /**
               * The value to segment a text or number merge field with.
               */
              value?: string;
            }
          | {
              condition_type?: 'EmailAddress';
              /**
               * Segmenting based off of a subscriber's email address.
               */
              field: 'merge0' | 'EMAIL';
              /**
               * Whether the email address is/not exactly, contains/doesn't contain, starts/ends with a string.
               */
              op: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends' | 'greater' | 'less';
              /**
               * The value to compare the email against.
               */
              value?: string;
            }
          | {
              condition_type?: 'PredictedGender';
              /**
               * Segment by predicted gender.
               */
              field: 'predicted_gender';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is' | 'not';
              /**
               * The predicted gender to segment.
               */
              value: 'male' | 'female';
            }
          | {
              condition_type?: 'PredictedAge';
              /**
               * Segment by predicted age.
               */
              field: 'predicted_age_range';
              /**
               * Members who are/not the exact criteria listed.
               */
              op: 'is';
              /**
               * The predicted age to segment.
               */
              value: '18-24' | '25-34' | '35-44' | '45-54' | '55-64' | '65+';
            }
          | {
              condition_type?: 'NewSubscribers';
              /**
               * Segment by when people subscribed.
               */
              field?: 'timestamp_opt';
              /**
               * Whe the event took place, namely within a time frame.
               */
              op?: 'date_within';
              /**
               * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
               */
              value?: string;
            }
        >;
        /**
         * Segment match type.
         */
        match?: 'any' | 'all';
        /**
         * The prebuilt segment id, if a prebuilt segment has been designated for this campaign.
         */
        prebuilt_segment_id?: string;
        /**
         * The id for an existing saved segment.
         */
        saved_segment_id?: number;
      };
    };
    /**
     * [RSS](https://mailchimp.com/help/share-your-blog-posts-with-mailchimp/) options for a campaign.
     */
    rss_opts?: {
      /**
       * Whether to add CSS to images in the RSS feed to constrain their width in campaigns.
       */
      constrain_rss_img?: boolean;
      /**
       * The URL for the RSS feed.
       */
      feed_url: string;
      /**
       * The frequency of the RSS Campaign.
       */
      frequency: 'daily' | 'weekly' | 'monthly';
      /**
       * The schedule for sending the RSS Campaign.
       */
      schedule?: {
        /**
         * The days of the week to send a daily RSS Campaign.
         */
        daily_send?: {
          /**
           * Sends the daily RSS Campaign on Fridays.
           */
          friday?: boolean;
          /**
           * Sends the daily RSS Campaign on Mondays.
           */
          monday?: boolean;
          /**
           * Sends the daily RSS Campaign on Saturdays.
           */
          saturday?: boolean;
          /**
           * Sends the daily RSS Campaign on Sundays.
           */
          sunday?: boolean;
          /**
           * Sends the daily RSS Campaign on Thursdays.
           */
          thursday?: boolean;
          /**
           * Sends the daily RSS Campaign on Tuesdays.
           */
          tuesday?: boolean;
          /**
           * Sends the daily RSS Campaign on Wednesdays.
           */
          wednesday?: boolean;
        };
        /**
         * The hour to send the campaign in local time. Acceptable hours are 0-23. For example, '4' would be 4am in [your account's default time zone](https://mailchimp.com/help/set-account-defaults/).
         */
        hour?: number;
        /**
         * The day of the month to send a monthly RSS Campaign. Acceptable days are 0-31, where '0' is always the last day of a month. Months with fewer than the selected number of days will not have an RSS campaign sent out that day. For example, RSS Campaigns set to send on the 30th will not go out in February.
         */
        monthly_send_date?: number;
        /**
         * The day of the week to send a weekly RSS Campaign.
         */
        weekly_send_day?: 'sunday' | 'monday' | 'tuesday' | 'wednesday' | 'thursday' | 'friday' | 'saturday';
      };
    };
    /**
     * The settings for your campaign, including subject, from name, reply-to address, and more.
     */
    settings: {
      /**
       * Whether Mailchimp [authenticated](https://mailchimp.com/help/about-email-authentication/) the campaign. Defaults to `true`.
       */
      authenticate?: boolean;
      /**
       * An array of [Facebook](https://mailchimp.com/help/connect-or-disconnect-the-facebook-integration/) page ids to auto-post to.
       */
      auto_fb_post?: Array<string>;
      /**
       * Automatically append Mailchimp's [default footer](https://mailchimp.com/help/about-campaign-footers/) to the campaign.
       */
      auto_footer?: boolean;
      /**
       * Automatically tweet a link to the [campaign archive](https://mailchimp.com/help/about-email-campaign-archives-and-pages/) page when the campaign is sent.
       */
      auto_tweet?: boolean;
      /**
       * Allows Facebook comments on the campaign (also force-enables the Campaign Archive toolbar). Defaults to `true`.
       */
      fb_comments?: boolean;
      /**
       * If the campaign is listed in a folder, the id for that folder.
       */
      folder_id?: string;
      /**
       * The 'from' name on the campaign (not an email address).
       */
      from_name: string;
      /**
       * Automatically inline the CSS included with the campaign content.
       */
      inline_css?: boolean;
      /**
       * The preview text for the campaign.
       */
      preview_text?: string;
      /**
       * The reply-to email address for the campaign.
       */
      reply_to: string;
      /**
       * The subject line for the campaign.
       */
      subject_line: string;
      /**
       * The id of the template to use.
       */
      template_id?: number;
      /**
       * The title of the campaign.
       */
      title?: string;
      /**
       * The campaign's custom 'To' name. Typically the first name [audience field](https://mailchimp.com/help/getting-started-with-merge-tags/).
       */
      to_name?: string;
      /**
       * Use Mailchimp Conversation feature to manage out-of-office replies.
       */
      use_conversation?: boolean;
    };
    /**
     * The preview for the campaign, rendered by social networks like Facebook and Twitter. [Learn more](https://mailchimp.com/help/enable-and-customize-social-cards/).
     */
    social_card?: {
      /**
       * A short summary of the campaign to display.
       */
      description?: string;
      /**
       * The url for the header image for the card.
       */
      image_url?: string;
      /**
       * The title for the card. Typically the subject line of the campaign.
       */
      title?: string;
    };
    /**
     * The tracking options for a campaign.
     */
    tracking?: {
      /**
       * Deprecated
       */
      capsule?: {
        /**
         * Update contact notes for a campaign based on subscriber email addresses.
         */
        notes?: boolean;
      };
      /**
       * The custom slug for [ClickTale](https://mailchimp.com/help/additional-tracking-options-for-campaigns/) tracking (max of 50 bytes).
       */
      clicktale?: string;
      /**
       * Whether to enable e-commerce tracking.
       */
      ecomm360?: boolean;
      /**
       * Deprecated
       */
      goal_tracking?: boolean;
      /**
       * The custom slug for [Google Analytics](https://mailchimp.com/help/integrate-google-analytics-with-mailchimp/) tracking (max of 50 bytes).
       */
      google_analytics?: string;
      /**
       * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the HTML version of the campaign. Defaults to `true`. Cannot be set to false for variate campaigns.
       */
      html_clicks?: boolean;
      /**
       * Whether to [track opens](https://mailchimp.com/help/about-open-tracking/). Defaults to `true`. Cannot be set to false for variate campaigns.
       */
      opens?: boolean;
      /**
       * Deprecated
       */
      salesforce?: {
        /**
         * Create a campaign in a connected Salesforce account.
         */
        campaign?: boolean;
        /**
         * Update contact notes for a campaign based on subscriber email addresses.
         */
        notes?: boolean;
      };
      /**
       * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the plain-text version of the campaign. Defaults to `true`. Cannot be set to false for variate campaigns.
       */
      text_clicks?: boolean;
    };
    /**
     * The settings specific to A/B test campaigns.
     */
    variate_settings?: {
      /**
       * The possible from names. The number of from_names provided must match the number of reply_to_addresses. If no from_names are provided, settings.from_name will be used.
       */
      from_names?: Array<string>;
      /**
       * The possible reply-to addresses. The number of reply_to_addresses provided must match the number of from_names. If no reply_to_addresses are provided, settings.reply_to will be used.
       */
      reply_to_addresses?: Array<string>;
      /**
       * The possible send times to test. The times provided should be in the format YYYY-MM-DD HH:MM:SS. If send_times are provided to test, the test_size will be set to 100% and winner_criteria will be ignored.
       */
      send_times?: Array<string>;
      /**
       * The possible subject lines to test. If no subject lines are provided, settings.subject_line will be used.
       */
      subject_lines?: Array<string>;
      /**
       * The percentage of recipients to send the test combinations to, must be a value between 10 and 100.
       */
      test_size?: number;
      /**
       * The number of minutes to wait before choosing the winning campaign. The value of wait_time must be greater than 0 and in whole hours, specified in minutes.
       */
      wait_time?: number;
      /**
       * The combination that performs the best. This may be determined automatically by click rate, open rate, or total revenue -- or you may choose manually based on the reporting data you find the most valuable. For Multivariate Campaigns testing send_time, winner_criteria is ignored. For Multivariate Campaigns with 'manual' as the winner_criteria, the winner must be chosen in the Mailchimp web application.
       */
      winner_criteria: 'opens' | 'clicks' | 'manual' | 'total_revenue';
    };
  };
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
  };
};

export type PatchCampaignsIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * [A/B Testing](https://mailchimp.com/help/about-ab-testing-campaigns/) options for a campaign.
   */
  readonly ab_split_opts?: {
    /**
     * For campaigns split on 'From Name', the name for Group A.
     */
    from_name_a?: string;
    /**
     * For campaigns split on 'From Name', the name for Group B.
     */
    from_name_b?: string;
    /**
     * How we should evaluate a winner. Based on 'opens', 'clicks', or 'manual'.
     */
    pick_winner?: 'opens' | 'clicks' | 'manual';
    /**
     * For campaigns split on 'From Name', the reply-to address for Group A.
     */
    reply_email_a?: string;
    /**
     * For campaigns split on 'From Name', the reply-to address for Group B.
     */
    reply_email_b?: string;
    /**
     * The send time for Group A.
     */
    send_time_a?: string;
    /**
     * The send time for Group B.
     */
    send_time_b?: string;
    /**
     * The send time for the winning version.
     */
    send_time_winner?: string;
    /**
     * The size of the split groups. Campaigns split based on 'schedule' are forced to have a 50/50 split. Valid split integers are between 1-50.
     */
    split_size?: number;
    /**
     * The type of AB split to run.
     */
    split_test?: 'subject' | 'from_name' | 'schedule';
    /**
     * For campaigns split on 'Subject Line', the subject line for Group A.
     */
    subject_a?: string;
    /**
     * For campaigns split on 'Subject Line', the subject line for Group B.
     */
    subject_b?: string;
    /**
     * The amount of time to wait before picking a winner. This cannot be changed after a campaign is sent.
     */
    wait_time?: number;
    /**
     * How unit of time for measuring the winner ('hours' or 'days'). This cannot be changed after a campaign is sent.
     */
    wait_units?: 'hours' | 'days';
  };
  /**
   * The link to the campaign's archive version in ISO 8601 format.
   */
  readonly archive_url?: string;
  /**
   * How the campaign's content is put together.
   */
  content_type?: 'template' | 'html' | 'url' | 'multichannel';
  /**
   * The date and time the campaign was created in ISO 8601 format.
   */
  readonly create_time?: string;
  /**
   * Updates on campaigns in the process of sending.
   */
  delivery_status?: {
    /**
     * Whether a campaign send can be canceled.
     */
    readonly can_cancel?: boolean;
    /**
     * The total number of emails canceled for this campaign.
     */
    readonly emails_canceled?: number;
    /**
     * The total number of emails confirmed sent for this campaign so far.
     */
    readonly emails_sent?: number;
    /**
     * Whether Campaign Delivery Status is enabled for this account and campaign.
     */
    readonly enabled?: boolean;
    /**
     * The current state of a campaign delivery.
     */
    readonly status?: 'delivering' | 'delivered' | 'canceling' | 'canceled';
  };
  /**
   * The total number of emails sent for this campaign.
   */
  readonly emails_sent?: number;
  /**
   * A string that uniquely identifies this campaign.
   */
  readonly id?: string;
  /**
   * The original link to the campaign's archive version.
   */
  readonly long_archive_url?: string;
  /**
   * Determines if the campaign needs its blocks refreshed by opening the web-based campaign editor. Deprecated and will always return false.
   */
  readonly needs_block_refresh?: boolean;
  /**
   * If this campaign is the child of another campaign, this identifies the parent campaign. For Example, for RSS or Automation children.
   */
  readonly parent_campaign_id?: string;
  /**
   * List settings for the campaign.
   */
  recipients?: {
    /**
     * The unique list id.
     */
    list_id?: string;
    /**
     * The status of the list used, namely if it's deleted or disabled.
     */
    readonly list_is_active?: boolean;
    /**
     * The name of the list.
     */
    readonly list_name?: string;
    /**
     * Count of the recipients on the associated list. Formatted as an integer.
     */
    readonly recipient_count?: number;
    /**
     * An object representing all segmentation options. This object should contain a `saved_segment_id` to use an existing segment, or you can create a new segment by including both `match` and `conditions` options.
     */
    segment_opts?: {
      /**
       * Segment match conditions. There are multiple possible types, see the [condition types documentation](https://mailchimp.com/developer/marketing/docs/alternative-schemas/#segment-condition-schemas).
       */
      conditions?: Array<
        | {
            condition_type?: 'Aim';
            /**
             * Segment by interaction with a specific campaign.
             */
            field?: 'aim';
            /**
             * The status of the member with regard to their campaign interaction. One of the following: opened, clicked, was sent, didn't open, didn't click, or was not sent.
             */
            op?: 'open' | 'click' | 'sent' | 'noopen' | 'noclick' | 'nosent';
            /**
             * Either the web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
             */
            value?: string;
          }
        | {
            condition_type?: 'Automation';
            /**
             * Segment by interaction with an Automation workflow.
             */
            field: 'automation';
            /**
             * The status of the member with regard to the automation workflow. One of the following: has started the workflow, has completed the workflow, has not started the workflow, or has not completed the workflow.
             */
            op: 'started' | 'completed' | 'not_started' | 'not_completed';
            /**
             * The web id for the automation workflow to segment against.
             */
            value: string;
          }
        | {
            condition_type?: 'CampaignPoll';
            /**
             * Segment by poll activity.
             */
            field: 'poll';
            /**
             * Members have/have not interacted with a specific poll in a Mailchimp email.
             */
            op: 'member' | 'notmember';
            /**
             * The id for the poll.
             */
            value: number;
          }
        | {
            condition_type?: 'Conversation';
            /**
             * Segment by interaction with a campaign via Conversations.
             */
            field: 'conversation';
            /**
             * The status of a member's interaction with a conversation. One of the following: has replied or has not replied.
             */
            op: 'member' | 'notmember';
            /**
             * The web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
             */
            value: string;
          }
        | {
            condition_type?: 'Date';
            /**
             * When segmenting on 'date' or 'campaign', the date for the segment formatted as YYYY-MM-DD or the web id for the campaign.
             */
            extra?: string;
            /**
             * The type of date field to segment on: The opt-in time for a signup, the date the subscriber was last updated, or the date of their last ecomm purchase.
             */
            field: 'timestamp_opt' | 'info_changed' | 'ecomm_date';
            /**
             * When the event took place:  Before, after, is a specific date, is not a specific date, is blank, or is not blank.
             */
            op: 'greater' | 'less' | 'is' | 'not' | 'blank' | 'blank_not' | 'within' | 'notwithin';
            /**
             * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
             */
            value: string;
          }
        | {
            condition_type?: 'EmailClient';
            /**
             * Segment by use of a particular email client.
             */
            field: 'email_client';
            /**
             * The operation to determine whether we select clients that match the value, or clients that do not match the value.
             */
            op: 'client_is' | 'client_not';
            /**
             * The name of the email client.
             */
            value: string;
          }
        | {
            condition_type?: 'Language';
            /**
             * Segmenting based off of a subscriber's language.
             */
            field: 'language';
            /**
             * Whether the member's language is or is not set to a specific language.
             */
            op: 'is' | 'not';
            /**
             * A two-letter language identifier.
             */
            value: string;
          }
        | {
            condition_type?: 'MemberRating';
            /**
             * Segment by member rating.
             */
            field: 'rating';
            /**
             * Members who have have a rating that is/not exactly a given number or members who have a rating greater/less than a given number.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * The star rating number to segment against.
             */
            value: number;
          }
        | {
            condition_type: 'SignupSource';
            field: 'source';
            /**
             * Whether the member's signup source was/was not a particular value.
             */
            op: 'source_is' | 'source_not';
            /**
             * The signup source.
             */
            value?: string;
          }
        | {
            condition_type?: 'SurveyMonkey';
            /**
             * Segment by interaction with a SurveyMonkey survey.
             */
            field: 'survey_monkey';
            /**
             * The status of the member with regard to the survey.One of the following: has started the survey, has completed the survey, has not started the survey, or has not completed the survey.
             */
            op: 'started' | 'completed' | 'not_started' | 'not_completed';
            /**
             * The unique ID of the survey monkey survey.
             */
            value: string;
          }
        | {
            condition_type?: 'VIP';
            /**
             * Segment by VIP status.
             */
            field: 'gmonkey';
            /**
             * Whether the member is or is not marked as VIP.
             */
            op: 'member' | 'notmember';
          }
        | {
            condition_type?: 'Interests';
            /**
             * Segmenting based on interest group information. This should start with 'interests-' followed by the grouping id. Ex. 'interests-123'.
             */
            field?: string;
            /**
             * Whether the member is a part of one, all, or none of the groups.
             */
            op?: 'interestcontains' | 'interestcontainsall' | 'interestnotcontains';
            /**
             * An array containing strings, each representing a group id.
             */
            value?: Array<string>;
          }
        | {
            condition_type?: 'EcommCategory';
            /**
             * Segment by purchases in specific items or categories.
             */
            field?: 'ecomm_cat' | 'ecomm_prod';
            /**
             * A member who has purchased from a category/specific item that is/is not a specific name, where the category/item name contains/doesn't contain a specific phrase or string, or a category/item name that starts/ends with a string.
             */
            op?: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends';
            /**
             * The ecommerce category/item information.
             */
            value?: string;
          }
        | {
            condition_type?: 'EcommNumber';
            /**
             * Segment by average spent total, number of orders, total number of products purchased, or average number of products per order.
             */
            field: 'ecomm_spent_avg' | 'ecomm_orders' | 'ecomm_prod_all' | 'ecomm_avg_ord';
            /**
             * Members who have spent exactly, have not spent exactly, spent more, or spent less than the segment value.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * Members who have spent exactly, have not spent exactly, spent more, or spent less than this amount.
             */
            value: number;
          }
        | {
            condition_type?: 'EcommPurchased';
            /**
             * Segment by whether someone has purchased anything.
             */
            field?: 'ecomm_purchased';
            /**
             * Members who have have ('member') or have not ('notmember') purchased.
             */
            op?: 'member' | 'notmember';
          }
        | {
            condition_type?: 'EcommSpent';
            /**
             * Segment by amount spent on a single order or across all orders.
             */
            field?: 'ecomm_spent_one' | 'ecomm_spent_all';
            /**
             * Members who have spent 'more' or 'less' than then specified value.
             */
            op?: 'greater' | 'less';
            /**
             * The total amount a member spent.
             */
            value?: number;
          }
        | {
            condition_type?: 'EcommStore';
            /**
             * Segment by purchases from a specific store.
             */
            field?: 'ecomm_store';
            /**
             * Members who have or have not purchased from a specific store.
             */
            op?: 'is' | 'not';
            /**
             * The store id to segment against.
             */
            value?: string;
          }
        | {
            condition_type?: 'GoalActivity';
            /**
             * Segment by Goal activity.
             */
            field: 'goal';
            /**
             * Whether the website URL is/not exactly, contains/doesn't contain, starts with/ends with a string.
             */
            op: 'is' | 'goal_not' | 'contains' | 'goal_notcontain' | 'starts' | 'ends';
            /**
             * The URL to check Goal activity against.
             */
            value: string;
          }
        | {
            condition_type?: 'GoalTimestamp';
            /**
             * Segment by most recent interaction with a website.
             */
            field: 'goal_last_visited';
            /**
             * Whether the website activity happened after, before, or at a given timestamp.
             */
            op: 'greater' | 'less' | 'is';
            /**
             * The date to check Goal activity against.
             */
            value: string;
          }
        | {
            condition_type?: 'FuzzySegment';
            /**
             * Segment by similar subscribers.
             */
            field: 'fuzzy_segment';
            /**
             * Members who are/are not apart of a 'similar subscribers' segment.
             */
            op: 'fuzzy_is' | 'fuzzy_not';
            /**
             * The id for the 'similar subscribers' segment.
             */
            value: number;
          }
        | {
            condition_type?: 'StaticSegment';
            /**
             * Segment by a given static segment.
             */
            field: 'static_segment';
            /**
             * Members who are/are not apart of a static segment.
             */
            op: 'static_is' | 'static_not';
            /**
             * The id for the static segment.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoCountryState';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are within a specific country or US state.
             */
            op: 'ipgeocountry' | 'ipgeonotcountry' | 'ipgeostate' | 'ipgeonotstate';
            /**
             * The two-letter country code or US state abbreviation.
             */
            value: string;
          }
        | {
            /**
             * The address of the target location.
             */
            addr: string;
            condition_type?: 'IPGeoIn';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * The latitude of the target location.
             */
            lat: string;
            /**
             * The longitude of the target location.
             */
            lng: string;
            /**
             * Segment members who are within a specific geographic region.
             */
            op: 'ipgeoin' | 'ipgeonotin';
            /**
             * The radius of the target location.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoInZip';
            /**
             * The zip code to segment against.
             */
            extra: number;
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are within a specific US zip code.
             */
            op: 'ipgeoinzip';
            /**
             * The radius of the target location.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoUnknown';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members for which location information is unknown.
             */
            op: 'ipgeounknown';
          }
        | {
            condition_type?: 'IPGeoZip';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are/are not within a specific US zip code.
             */
            op: 'ipgeoiszip' | 'ipgeonotzip';
            /**
             * The 5-digit zip code.
             */
            value: number;
          }
        | {
            condition_type?: 'SocialAge';
            /**
             * Segment by age ranges in Social Profiles data.
             */
            field: 'social_age';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The age range to segment.
             */
            value: '18-24' | '25-34' | '35-54' | '55+';
          }
        | {
            condition_type?: 'SocialGender';
            /**
             * Segment by listed gender in Social Profiles data.
             */
            field: 'social_gender';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The Social Profiles gender to segment.
             */
            value: 'male' | 'female';
          }
        | {
            condition_type?: 'SocialInfluence';
            /**
             * Segment by influence rating in Social Profiles data.
             */
            field: 'social_influence';
            /**
             * Members who have a rating that is/not or greater/less than the rating provided.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * The Social Profiles influence rating to segment.
             */
            value: number;
          }
        | {
            condition_type?: 'SocialNetworkMember';
            /**
             * Segment by social network in Social Profiles data.
             */
            field: 'social_network';
            /**
             * Members who are/not on a given social network.
             */
            op: 'member' | 'notmember';
            /**
             * The social network to segment against.
             */
            value:
              | 'twitter'
              | 'facebook'
              | 'linkedin'
              | 'flickr'
              | 'foursquare'
              | 'lastfm'
              | 'myspace'
              | 'quora'
              | 'vimeo'
              | 'yelp'
              | 'youtube';
          }
        | {
            condition_type?: 'SocialNetworkFollow';
            /**
             * Segment by social network in Social Profiles data.
             */
            field: 'social_network';
            /**
             * Members who are/not following a linked account on a given social network.
             */
            op: 'follow' | 'notfollow';
            /**
             * The social network to segment against.
             */
            value: 'twitter_follow';
          }
        | {
            condition_type?: 'AddressMerge';
            /**
             * An address-type merge field to segment.
             */
            field: string;
            /**
             * Whether the member's address merge field contains/does not contain a value or is/is not blank.
             */
            op: 'contains' | 'notcontain' | 'blank' | 'blank_not';
            /**
             * The value to segment a text merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'ZipMerge';
            /**
             * The city or the zip being used to segment against.
             */
            extra: string;
            /**
             * An address or zip-type merge field to segment.
             */
            field: string;
            /**
             * Whether the member's address merge field is within a given distance from a city or zip.
             */
            op: 'geoin';
            /**
             * The distance from the city/zip.
             */
            value: string;
          }
        | {
            condition_type?: 'BirthdayMerge';
            /**
             * A date merge field to segment.
             */
            field: string;
            /**
             * Whether the member's birthday merge information is/is not a certain date or is/is not blank.
             */
            op: 'is' | 'not' | 'blank' | 'blank_not';
            /**
             * A date to segment against (mm/dd).
             */
            value?: string;
          }
        | {
            condition_type?: 'DateMerge';
            /**
             * A date merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not, is greater/less than a value or is/is not blank.
             */
            op: 'is' | 'not' | 'less' | 'blank' | 'blank_not' | 'greater';
            /**
             * A date to segment against.
             */
            value?: string;
          }
        | {
            condition_type?: 'SelectMerge';
            /**
             * A merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not a value or is/is not blank.
             */
            op: 'is' | 'not' | 'blank' | 'blank_not' | 'notcontain' | 'contains';
            /**
             * The value to segment a text merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'TextMerge';
            /**
             * A text or number merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not, contains/does not contain, starts/ends with, or is greater/less than a value
             */
            op:
              | 'is'
              | 'not'
              | 'contains'
              | 'notcontain'
              | 'starts'
              | 'ends'
              | 'greater'
              | 'less'
              | 'blank'
              | 'blank_not';
            /**
             * The value to segment a text or number merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'EmailAddress';
            /**
             * Segmenting based off of a subscriber's email address.
             */
            field: 'merge0' | 'EMAIL';
            /**
             * Whether the email address is/not exactly, contains/doesn't contain, starts/ends with a string.
             */
            op: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends' | 'greater' | 'less';
            /**
             * The value to compare the email against.
             */
            value?: string;
          }
        | {
            condition_type?: 'PredictedGender';
            /**
             * Segment by predicted gender.
             */
            field: 'predicted_gender';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The predicted gender to segment.
             */
            value: 'male' | 'female';
          }
        | {
            condition_type?: 'PredictedAge';
            /**
             * Segment by predicted age.
             */
            field: 'predicted_age_range';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is';
            /**
             * The predicted age to segment.
             */
            value: '18-24' | '25-34' | '35-44' | '45-54' | '55-64' | '65+';
          }
        | {
            condition_type?: 'NewSubscribers';
            /**
             * Segment by when people subscribed.
             */
            field?: 'timestamp_opt';
            /**
             * Whe the event took place, namely within a time frame.
             */
            op?: 'date_within';
            /**
             * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
             */
            value?: string;
          }
      >;
      /**
       * Segment match type.
       */
      match?: 'any' | 'all';
      /**
       * The prebuilt segment id, if a prebuilt segment has been designated for this campaign.
       */
      prebuilt_segment_id?: string;
      /**
       * The id for an existing saved segment.
       */
      saved_segment_id?: number;
    };
    /**
     * A description of the [segment](https://mailchimp.com/help/create-and-send-to-a-segment/) used for the campaign. Formatted as a string marked up with HTML.
     */
    readonly segment_text?: string;
  };
  /**
   * For sent campaigns, a summary of opens, clicks, and e-commerce data.
   */
  report_summary?: {
    /**
     * The number of unique clicks divided by the total number of successful deliveries.
     */
    readonly click_rate?: number;
    /**
     * The total number of clicks for an campaign.
     */
    readonly clicks?: number;
    /**
     * E-Commerce stats for a campaign.
     */
    ecommerce?: {
      /**
       * The total orders for a campaign.
       */
      readonly total_orders?: number;
      /**
       * The total revenue for a campaign. Calculated as the sum of all order totals minus shipping and tax totals.
       */
      readonly total_revenue?: number;
      /**
       * The total spent for a campaign. Calculated as the sum of all order totals with no deductions.
       */
      readonly total_spent?: number;
    };
    /**
     * The number of unique opens divided by the total number of successful deliveries.
     */
    readonly open_rate?: number;
    /**
     * The total number of opens for a campaign.
     */
    readonly opens?: number;
    /**
     * The number of unique clicks.
     */
    readonly subscriber_clicks?: number;
    /**
     * The number of unique opens.
     */
    readonly unique_opens?: number;
  };
  /**
   * Determines if the campaign qualifies to be resent to non-openers.
   */
  readonly resendable?: boolean;
  /**
   * [RSS](https://mailchimp.com/help/share-your-blog-posts-with-mailchimp/) options for a campaign.
   */
  rss_opts?: {
    /**
     * Whether to add CSS to images in the RSS feed to constrain their width in campaigns.
     */
    constrain_rss_img?: boolean;
    /**
     * The URL for the RSS feed.
     */
    feed_url?: string;
    /**
     * The frequency of the RSS Campaign.
     */
    frequency?: 'daily' | 'weekly' | 'monthly';
    /**
     * The date the campaign was last sent.
     */
    readonly last_sent?: string;
    /**
     * The schedule for sending the RSS Campaign.
     */
    schedule?: {
      /**
       * The days of the week to send a daily RSS Campaign.
       */
      daily_send?: {
        /**
         * Sends the daily RSS Campaign on Fridays.
         */
        friday?: boolean;
        /**
         * Sends the daily RSS Campaign on Mondays.
         */
        monday?: boolean;
        /**
         * Sends the daily RSS Campaign on Saturdays.
         */
        saturday?: boolean;
        /**
         * Sends the daily RSS Campaign on Sundays.
         */
        sunday?: boolean;
        /**
         * Sends the daily RSS Campaign on Thursdays.
         */
        thursday?: boolean;
        /**
         * Sends the daily RSS Campaign on Tuesdays.
         */
        tuesday?: boolean;
        /**
         * Sends the daily RSS Campaign on Wednesdays.
         */
        wednesday?: boolean;
      };
      /**
       * The hour to send the campaign in local time. Acceptable hours are 0-23. For example, '4' would be 4am in [your account's default time zone](https://mailchimp.com/help/set-account-defaults/).
       */
      hour?: number;
      /**
       * The day of the month to send a monthly RSS Campaign. Acceptable days are 0-31, where '0' is always the last day of a month. Months with fewer than the selected number of days will not have an RSS campaign sent out that day. For example, RSS Campaigns set to send on the 30th will not go out in February.
       */
      monthly_send_date?: number;
      /**
       * The day of the week to send a weekly RSS Campaign.
       */
      weekly_send_day?: 'sunday' | 'monday' | 'tuesday' | 'wednesday' | 'thursday' | 'friday' | 'saturday';
    };
  };
  /**
   * The date and time a campaign was sent.
   */
  readonly send_time?: string;
  /**
   * The settings for your campaign, including subject, from name, reply-to address, and more.
   */
  settings?: {
    /**
     * Whether Mailchimp [authenticated](https://mailchimp.com/help/about-email-authentication/) the campaign. Defaults to `true`.
     */
    authenticate?: boolean;
    /**
     * An array of [Facebook](https://mailchimp.com/help/connect-or-disconnect-the-facebook-integration/) page ids to auto-post to.
     */
    auto_fb_post?: Array<string>;
    /**
     * Automatically append Mailchimp's [default footer](https://mailchimp.com/help/about-campaign-footers/) to the campaign.
     */
    auto_footer?: boolean;
    /**
     * Automatically tweet a link to the [campaign archive](https://mailchimp.com/help/about-email-campaign-archives-and-pages/) page when the campaign is sent.
     */
    auto_tweet?: boolean;
    /**
     * Whether the campaign uses the drag-and-drop editor.
     */
    readonly drag_and_drop?: boolean;
    /**
     * Allows Facebook comments on the campaign (also force-enables the Campaign Archive toolbar). Defaults to `true`.
     */
    fb_comments?: boolean;
    /**
     * If the campaign is listed in a folder, the id for that folder.
     */
    folder_id?: string;
    /**
     * The 'from' name on the campaign (not an email address).
     */
    from_name?: string;
    /**
     * Automatically inline the CSS included with the campaign content.
     */
    inline_css?: boolean;
    /**
     * The preview text for the campaign.
     */
    preview_text?: string;
    /**
     * The reply-to email address for the campaign.
     */
    reply_to?: string;
    /**
     * The subject line for the campaign.
     */
    subject_line?: string;
    /**
     * The id for the template used in this campaign.
     */
    template_id?: number;
    /**
     * Send this campaign using [Timewarp](https://mailchimp.com/help/use-timewarp/).
     */
    readonly timewarp?: boolean;
    /**
     * The title of the campaign.
     */
    title?: string;
    /**
     * The campaign's custom 'To' name. Typically the first name [audience field](https://mailchimp.com/help/getting-started-with-merge-tags/).
     */
    to_name?: string;
    /**
     * Use Mailchimp Conversation feature to manage out-of-office replies.
     */
    use_conversation?: boolean;
  };
  /**
   * The preview for the campaign, rendered by social networks like Facebook and Twitter. [Learn more](https://mailchimp.com/help/enable-and-customize-social-cards/).
   */
  social_card?: {
    /**
     * A short summary of the campaign to display.
     */
    description?: string;
    /**
     * The url for the header image for the card.
     */
    image_url?: string;
    /**
     * The title for the card. Typically the subject line of the campaign.
     */
    title?: string;
  };
  /**
   * The current status of the campaign.
   */
  readonly status?: 'save' | 'paused' | 'schedule' | 'sending' | 'sent' | 'canceled' | 'canceling' | 'archived';
  /**
   * The tracking options for a campaign.
   */
  tracking?: {
    /**
     * Deprecated
     */
    capsule?: {
      /**
       * Update contact notes for a campaign based on subscriber email addresses.
       */
      notes?: boolean;
    };
    /**
     * The custom slug for [ClickTale](https://mailchimp.com/help/additional-tracking-options-for-campaigns/) tracking (max of 50 bytes).
     */
    clicktale?: string;
    /**
     * Whether to enable e-commerce tracking.
     */
    ecomm360?: boolean;
    /**
     * Deprecated
     */
    goal_tracking?: boolean;
    /**
     * The custom slug for [Google Analytics](https://mailchimp.com/help/integrate-google-analytics-with-mailchimp/) tracking (max of 50 bytes).
     */
    google_analytics?: string;
    /**
     * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the HTML version of the campaign. Defaults to `true`. Cannot be set to false for variate campaigns.
     */
    html_clicks?: boolean;
    /**
     * Whether to [track opens](https://mailchimp.com/help/about-open-tracking/). Defaults to `true`. Cannot be set to false for variate campaigns.
     */
    opens?: boolean;
    /**
     * Deprecated
     */
    salesforce?: {
      /**
       * Create a campaign in a connected Salesforce account.
       */
      campaign?: boolean;
      /**
       * Update contact notes for a campaign based on subscriber email addresses.
       */
      notes?: boolean;
    };
    /**
     * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the plain-text version of the campaign. Defaults to `true`. Cannot be set to false for variate campaigns.
     */
    text_clicks?: boolean;
  };
  /**
   * There are four types of [campaigns](https://mailchimp.com/help/getting-started-with-campaigns/) you can create in Mailchimp. A/B Split campaigns have been deprecated and variate campaigns should be used instead.
   */
  type?: 'regular' | 'plaintext' | 'absplit' | 'rss' | 'variate';
  /**
   * The settings specific to A/B test campaigns.
   */
  variate_settings?: {
    /**
     * Combinations of possible variables used to build emails.
     */
    readonly combinations?: Array<{
      /**
       * The index of `variate_settings.contents` used.
       */
      content_description?: number;
      /**
       * The index of `variate_settings.from_names` used.
       */
      from_name?: number;
      /**
       * Unique ID for the combination.
       */
      id?: string;
      /**
       * The number of recipients for this combination.
       */
      recipients?: number;
      /**
       * The index of `variate_settings.reply_to_addresses` used.
       */
      reply_to?: number;
      /**
       * The index of `variate_settings.send_times` used.
       */
      send_time?: number;
      /**
       * The index of `variate_settings.subject_lines` used.
       */
      subject_line?: number;
    }>;
    /**
     * Descriptions of possible email contents. To set campaign contents, make a PUT request to /campaigns/{campaign_id}/content with the field 'variate_contents'.
     */
    readonly contents?: Array<string>;
    /**
     * The possible from names. The number of from_names provided must match the number of reply_to_addresses. If no from_names are provided, settings.from_name will be used.
     */
    from_names?: Array<string>;
    /**
     * The possible reply-to addresses. The number of reply_to_addresses provided must match the number of from_names. If no reply_to_addresses are provided, settings.reply_to will be used.
     */
    reply_to_addresses?: Array<string>;
    /**
     * The possible send times to test. The times provided should be in the format YYYY-MM-DD HH:MM:SS. If send_times are provided to test, the test_size will be set to 100% and winner_criteria will be ignored.
     */
    send_times?: Array<string>;
    /**
     * The possible subject lines to test. If no subject lines are provided, settings.subject_line will be used.
     */
    subject_lines?: Array<string>;
    /**
     * The percentage of recipients to send the test combinations to, must be a value between 10 and 100.
     */
    test_size?: number;
    /**
     * The number of minutes to wait before choosing the winning campaign. The value of wait_time must be greater than 0 and in whole hours, specified in minutes.
     */
    wait_time?: number;
    /**
     * The combination that performs the best. This may be determined automatically by click rate, open rate, or total revenue -- or you may choose manually based on the reporting data you find the most valuable. For Multivariate Campaigns testing send_time, winner_criteria is ignored. For Multivariate Campaigns with 'manual' as the winner_criteria, the winner must be chosen in the Mailchimp web application.
     */
    winner_criteria?: 'opens' | 'clicks' | 'manual' | 'total_revenue';
    /**
     * ID of the campaign that was sent to the remaining recipients based on the winning combination.
     */
    readonly winning_campaign_id?: string;
    /**
     * ID for the winning combination.
     */
    readonly winning_combination_id?: string;
  };
  /**
   * The ID used in the Mailchimp web application. View this campaign in your Mailchimp account at `https://{dc}.admin.mailchimp.com/campaigns/show/?id={web_id}`.
   */
  readonly web_id?: number;
};

export type PatchCampaignsIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostCampaignsIdActionsCancelSendData = {
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
  };
};

export type PostCampaignsIdActionsCancelSendResponse = any;

export type PostCampaignsIdActionsCancelSendError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostCampaignsIdActionsCreateResendData = {
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
  };
};

export type PostCampaignsIdActionsCreateResendResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * [A/B Testing](https://mailchimp.com/help/about-ab-testing-campaigns/) options for a campaign.
   */
  readonly ab_split_opts?: {
    /**
     * For campaigns split on 'From Name', the name for Group A.
     */
    from_name_a?: string;
    /**
     * For campaigns split on 'From Name', the name for Group B.
     */
    from_name_b?: string;
    /**
     * How we should evaluate a winner. Based on 'opens', 'clicks', or 'manual'.
     */
    pick_winner?: 'opens' | 'clicks' | 'manual';
    /**
     * For campaigns split on 'From Name', the reply-to address for Group A.
     */
    reply_email_a?: string;
    /**
     * For campaigns split on 'From Name', the reply-to address for Group B.
     */
    reply_email_b?: string;
    /**
     * The send time for Group A.
     */
    send_time_a?: string;
    /**
     * The send time for Group B.
     */
    send_time_b?: string;
    /**
     * The send time for the winning version.
     */
    send_time_winner?: string;
    /**
     * The size of the split groups. Campaigns split based on 'schedule' are forced to have a 50/50 split. Valid split integers are between 1-50.
     */
    split_size?: number;
    /**
     * The type of AB split to run.
     */
    split_test?: 'subject' | 'from_name' | 'schedule';
    /**
     * For campaigns split on 'Subject Line', the subject line for Group A.
     */
    subject_a?: string;
    /**
     * For campaigns split on 'Subject Line', the subject line for Group B.
     */
    subject_b?: string;
    /**
     * The amount of time to wait before picking a winner. This cannot be changed after a campaign is sent.
     */
    wait_time?: number;
    /**
     * How unit of time for measuring the winner ('hours' or 'days'). This cannot be changed after a campaign is sent.
     */
    wait_units?: 'hours' | 'days';
  };
  /**
   * The link to the campaign's archive version.
   */
  readonly archive_url?: string;
  /**
   * How the campaign's content is put together ('template', 'drag_and_drop', 'html', 'url').
   */
  readonly content_type?: string;
  /**
   * The date and time the campaign was created in ISO 8601 format.
   */
  readonly create_time?: string;
  /**
   * Updates on campaigns in the process of sending.
   */
  delivery_status?: {
    /**
     * Whether a campaign send can be canceled.
     */
    readonly can_cancel?: boolean;
    /**
     * The total number of emails canceled for this campaign.
     */
    readonly emails_canceled?: number;
    /**
     * The total number of emails confirmed sent for this campaign so far.
     */
    readonly emails_sent?: number;
    /**
     * Whether Campaign Delivery Status is enabled for this account and campaign.
     */
    readonly enabled?: boolean;
    /**
     * The current state of a campaign delivery.
     */
    readonly status?: 'delivering' | 'delivered' | 'canceling' | 'canceled';
  };
  /**
   * The total number of emails sent for this campaign.
   */
  readonly emails_sent?: number;
  /**
   * A string that uniquely identifies this campaign.
   */
  readonly id?: string;
  /**
   * The original link to the campaign's archive version.
   */
  readonly long_archive_url?: string;
  /**
   * Determines if the campaign needs its blocks refreshed by opening the web-based campaign editor. Deprecated and will always return false.
   */
  readonly needs_block_refresh?: boolean;
  /**
   * If this campaign is the child of another campaign, this identifies the parent campaign. For Example, for RSS or Automation children.
   */
  readonly parent_campaign_id?: string;
  /**
   * List settings for the campaign.
   */
  recipients?: {
    /**
     * The unique list id.
     */
    list_id: string;
    /**
     * The name of the list.
     */
    readonly list_name?: string;
    /**
     * Count of the recipients on the associated list. Formatted as an integer.
     */
    readonly recipient_count?: number;
    /**
     * An object representing all segmentation options. This object should contain a `saved_segment_id` to use an existing segment, or you can create a new segment by including both `match` and `conditions` options.
     */
    segment_opts?: {
      /**
       * Segment match conditions. There are multiple possible types, see the [condition types documentation](https://mailchimp.com/developer/marketing/docs/alternative-schemas/#segment-condition-schemas).
       */
      conditions?: Array<
        | {
            condition_type?: 'Aim';
            /**
             * Segment by interaction with a specific campaign.
             */
            field?: 'aim';
            /**
             * The status of the member with regard to their campaign interaction. One of the following: opened, clicked, was sent, didn't open, didn't click, or was not sent.
             */
            op?: 'open' | 'click' | 'sent' | 'noopen' | 'noclick' | 'nosent';
            /**
             * Either the web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
             */
            value?: string;
          }
        | {
            condition_type?: 'Automation';
            /**
             * Segment by interaction with an Automation workflow.
             */
            field: 'automation';
            /**
             * The status of the member with regard to the automation workflow. One of the following: has started the workflow, has completed the workflow, has not started the workflow, or has not completed the workflow.
             */
            op: 'started' | 'completed' | 'not_started' | 'not_completed';
            /**
             * The web id for the automation workflow to segment against.
             */
            value: string;
          }
        | {
            condition_type?: 'CampaignPoll';
            /**
             * Segment by poll activity.
             */
            field: 'poll';
            /**
             * Members have/have not interacted with a specific poll in a Mailchimp email.
             */
            op: 'member' | 'notmember';
            /**
             * The id for the poll.
             */
            value: number;
          }
        | {
            condition_type?: 'Conversation';
            /**
             * Segment by interaction with a campaign via Conversations.
             */
            field: 'conversation';
            /**
             * The status of a member's interaction with a conversation. One of the following: has replied or has not replied.
             */
            op: 'member' | 'notmember';
            /**
             * The web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
             */
            value: string;
          }
        | {
            condition_type?: 'Date';
            /**
             * When segmenting on 'date' or 'campaign', the date for the segment formatted as YYYY-MM-DD or the web id for the campaign.
             */
            extra?: string;
            /**
             * The type of date field to segment on: The opt-in time for a signup, the date the subscriber was last updated, or the date of their last ecomm purchase.
             */
            field: 'timestamp_opt' | 'info_changed' | 'ecomm_date';
            /**
             * When the event took place:  Before, after, is a specific date, is not a specific date, is blank, or is not blank.
             */
            op: 'greater' | 'less' | 'is' | 'not' | 'blank' | 'blank_not' | 'within' | 'notwithin';
            /**
             * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
             */
            value: string;
          }
        | {
            condition_type?: 'EmailClient';
            /**
             * Segment by use of a particular email client.
             */
            field: 'email_client';
            /**
             * The operation to determine whether we select clients that match the value, or clients that do not match the value.
             */
            op: 'client_is' | 'client_not';
            /**
             * The name of the email client.
             */
            value: string;
          }
        | {
            condition_type?: 'Language';
            /**
             * Segmenting based off of a subscriber's language.
             */
            field: 'language';
            /**
             * Whether the member's language is or is not set to a specific language.
             */
            op: 'is' | 'not';
            /**
             * A two-letter language identifier.
             */
            value: string;
          }
        | {
            condition_type?: 'MemberRating';
            /**
             * Segment by member rating.
             */
            field: 'rating';
            /**
             * Members who have have a rating that is/not exactly a given number or members who have a rating greater/less than a given number.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * The star rating number to segment against.
             */
            value: number;
          }
        | {
            condition_type: 'SignupSource';
            field: 'source';
            /**
             * Whether the member's signup source was/was not a particular value.
             */
            op: 'source_is' | 'source_not';
            /**
             * The signup source.
             */
            value?: string;
          }
        | {
            condition_type?: 'SurveyMonkey';
            /**
             * Segment by interaction with a SurveyMonkey survey.
             */
            field: 'survey_monkey';
            /**
             * The status of the member with regard to the survey.One of the following: has started the survey, has completed the survey, has not started the survey, or has not completed the survey.
             */
            op: 'started' | 'completed' | 'not_started' | 'not_completed';
            /**
             * The unique ID of the survey monkey survey.
             */
            value: string;
          }
        | {
            condition_type?: 'VIP';
            /**
             * Segment by VIP status.
             */
            field: 'gmonkey';
            /**
             * Whether the member is or is not marked as VIP.
             */
            op: 'member' | 'notmember';
          }
        | {
            condition_type?: 'Interests';
            /**
             * Segmenting based on interest group information. This should start with 'interests-' followed by the grouping id. Ex. 'interests-123'.
             */
            field?: string;
            /**
             * Whether the member is a part of one, all, or none of the groups.
             */
            op?: 'interestcontains' | 'interestcontainsall' | 'interestnotcontains';
            /**
             * An array containing strings, each representing a group id.
             */
            value?: Array<string>;
          }
        | {
            condition_type?: 'EcommCategory';
            /**
             * Segment by purchases in specific items or categories.
             */
            field?: 'ecomm_cat' | 'ecomm_prod';
            /**
             * A member who has purchased from a category/specific item that is/is not a specific name, where the category/item name contains/doesn't contain a specific phrase or string, or a category/item name that starts/ends with a string.
             */
            op?: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends';
            /**
             * The ecommerce category/item information.
             */
            value?: string;
          }
        | {
            condition_type?: 'EcommNumber';
            /**
             * Segment by average spent total, number of orders, total number of products purchased, or average number of products per order.
             */
            field: 'ecomm_spent_avg' | 'ecomm_orders' | 'ecomm_prod_all' | 'ecomm_avg_ord';
            /**
             * Members who have spent exactly, have not spent exactly, spent more, or spent less than the segment value.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * Members who have spent exactly, have not spent exactly, spent more, or spent less than this amount.
             */
            value: number;
          }
        | {
            condition_type?: 'EcommPurchased';
            /**
             * Segment by whether someone has purchased anything.
             */
            field?: 'ecomm_purchased';
            /**
             * Members who have have ('member') or have not ('notmember') purchased.
             */
            op?: 'member' | 'notmember';
          }
        | {
            condition_type?: 'EcommSpent';
            /**
             * Segment by amount spent on a single order or across all orders.
             */
            field?: 'ecomm_spent_one' | 'ecomm_spent_all';
            /**
             * Members who have spent 'more' or 'less' than then specified value.
             */
            op?: 'greater' | 'less';
            /**
             * The total amount a member spent.
             */
            value?: number;
          }
        | {
            condition_type?: 'EcommStore';
            /**
             * Segment by purchases from a specific store.
             */
            field?: 'ecomm_store';
            /**
             * Members who have or have not purchased from a specific store.
             */
            op?: 'is' | 'not';
            /**
             * The store id to segment against.
             */
            value?: string;
          }
        | {
            condition_type?: 'GoalActivity';
            /**
             * Segment by Goal activity.
             */
            field: 'goal';
            /**
             * Whether the website URL is/not exactly, contains/doesn't contain, starts with/ends with a string.
             */
            op: 'is' | 'goal_not' | 'contains' | 'goal_notcontain' | 'starts' | 'ends';
            /**
             * The URL to check Goal activity against.
             */
            value: string;
          }
        | {
            condition_type?: 'GoalTimestamp';
            /**
             * Segment by most recent interaction with a website.
             */
            field: 'goal_last_visited';
            /**
             * Whether the website activity happened after, before, or at a given timestamp.
             */
            op: 'greater' | 'less' | 'is';
            /**
             * The date to check Goal activity against.
             */
            value: string;
          }
        | {
            condition_type?: 'FuzzySegment';
            /**
             * Segment by similar subscribers.
             */
            field: 'fuzzy_segment';
            /**
             * Members who are/are not apart of a 'similar subscribers' segment.
             */
            op: 'fuzzy_is' | 'fuzzy_not';
            /**
             * The id for the 'similar subscribers' segment.
             */
            value: number;
          }
        | {
            condition_type?: 'StaticSegment';
            /**
             * Segment by a given static segment.
             */
            field: 'static_segment';
            /**
             * Members who are/are not apart of a static segment.
             */
            op: 'static_is' | 'static_not';
            /**
             * The id for the static segment.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoCountryState';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are within a specific country or US state.
             */
            op: 'ipgeocountry' | 'ipgeonotcountry' | 'ipgeostate' | 'ipgeonotstate';
            /**
             * The two-letter country code or US state abbreviation.
             */
            value: string;
          }
        | {
            /**
             * The address of the target location.
             */
            addr: string;
            condition_type?: 'IPGeoIn';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * The latitude of the target location.
             */
            lat: string;
            /**
             * The longitude of the target location.
             */
            lng: string;
            /**
             * Segment members who are within a specific geographic region.
             */
            op: 'ipgeoin' | 'ipgeonotin';
            /**
             * The radius of the target location.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoInZip';
            /**
             * The zip code to segment against.
             */
            extra: number;
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are within a specific US zip code.
             */
            op: 'ipgeoinzip';
            /**
             * The radius of the target location.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoUnknown';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members for which location information is unknown.
             */
            op: 'ipgeounknown';
          }
        | {
            condition_type?: 'IPGeoZip';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are/are not within a specific US zip code.
             */
            op: 'ipgeoiszip' | 'ipgeonotzip';
            /**
             * The 5-digit zip code.
             */
            value: number;
          }
        | {
            condition_type?: 'SocialAge';
            /**
             * Segment by age ranges in Social Profiles data.
             */
            field: 'social_age';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The age range to segment.
             */
            value: '18-24' | '25-34' | '35-54' | '55+';
          }
        | {
            condition_type?: 'SocialGender';
            /**
             * Segment by listed gender in Social Profiles data.
             */
            field: 'social_gender';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The Social Profiles gender to segment.
             */
            value: 'male' | 'female';
          }
        | {
            condition_type?: 'SocialInfluence';
            /**
             * Segment by influence rating in Social Profiles data.
             */
            field: 'social_influence';
            /**
             * Members who have a rating that is/not or greater/less than the rating provided.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * The Social Profiles influence rating to segment.
             */
            value: number;
          }
        | {
            condition_type?: 'SocialNetworkMember';
            /**
             * Segment by social network in Social Profiles data.
             */
            field: 'social_network';
            /**
             * Members who are/not on a given social network.
             */
            op: 'member' | 'notmember';
            /**
             * The social network to segment against.
             */
            value:
              | 'twitter'
              | 'facebook'
              | 'linkedin'
              | 'flickr'
              | 'foursquare'
              | 'lastfm'
              | 'myspace'
              | 'quora'
              | 'vimeo'
              | 'yelp'
              | 'youtube';
          }
        | {
            condition_type?: 'SocialNetworkFollow';
            /**
             * Segment by social network in Social Profiles data.
             */
            field: 'social_network';
            /**
             * Members who are/not following a linked account on a given social network.
             */
            op: 'follow' | 'notfollow';
            /**
             * The social network to segment against.
             */
            value: 'twitter_follow';
          }
        | {
            condition_type?: 'AddressMerge';
            /**
             * An address-type merge field to segment.
             */
            field: string;
            /**
             * Whether the member's address merge field contains/does not contain a value or is/is not blank.
             */
            op: 'contains' | 'notcontain' | 'blank' | 'blank_not';
            /**
             * The value to segment a text merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'ZipMerge';
            /**
             * The city or the zip being used to segment against.
             */
            extra: string;
            /**
             * An address or zip-type merge field to segment.
             */
            field: string;
            /**
             * Whether the member's address merge field is within a given distance from a city or zip.
             */
            op: 'geoin';
            /**
             * The distance from the city/zip.
             */
            value: string;
          }
        | {
            condition_type?: 'BirthdayMerge';
            /**
             * A date merge field to segment.
             */
            field: string;
            /**
             * Whether the member's birthday merge information is/is not a certain date or is/is not blank.
             */
            op: 'is' | 'not' | 'blank' | 'blank_not';
            /**
             * A date to segment against (mm/dd).
             */
            value?: string;
          }
        | {
            condition_type?: 'DateMerge';
            /**
             * A date merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not, is greater/less than a value or is/is not blank.
             */
            op: 'is' | 'not' | 'less' | 'blank' | 'blank_not' | 'greater';
            /**
             * A date to segment against.
             */
            value?: string;
          }
        | {
            condition_type?: 'SelectMerge';
            /**
             * A merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not a value or is/is not blank.
             */
            op: 'is' | 'not' | 'blank' | 'blank_not' | 'notcontain' | 'contains';
            /**
             * The value to segment a text merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'TextMerge';
            /**
             * A text or number merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not, contains/does not contain, starts/ends with, or is greater/less than a value
             */
            op:
              | 'is'
              | 'not'
              | 'contains'
              | 'notcontain'
              | 'starts'
              | 'ends'
              | 'greater'
              | 'less'
              | 'blank'
              | 'blank_not';
            /**
             * The value to segment a text or number merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'EmailAddress';
            /**
             * Segmenting based off of a subscriber's email address.
             */
            field: 'merge0' | 'EMAIL';
            /**
             * Whether the email address is/not exactly, contains/doesn't contain, starts/ends with a string.
             */
            op: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends' | 'greater' | 'less';
            /**
             * The value to compare the email against.
             */
            value?: string;
          }
        | {
            condition_type?: 'PredictedGender';
            /**
             * Segment by predicted gender.
             */
            field: 'predicted_gender';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The predicted gender to segment.
             */
            value: 'male' | 'female';
          }
        | {
            condition_type?: 'PredictedAge';
            /**
             * Segment by predicted age.
             */
            field: 'predicted_age_range';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is';
            /**
             * The predicted age to segment.
             */
            value: '18-24' | '25-34' | '35-44' | '45-54' | '55-64' | '65+';
          }
        | {
            condition_type?: 'NewSubscribers';
            /**
             * Segment by when people subscribed.
             */
            field?: 'timestamp_opt';
            /**
             * Whe the event took place, namely within a time frame.
             */
            op?: 'date_within';
            /**
             * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
             */
            value?: string;
          }
      >;
      /**
       * Segment match type.
       */
      match?: 'any' | 'all';
      /**
       * The prebuilt segment id, if a prebuilt segment has been designated for this campaign.
       */
      prebuilt_segment_id?: string;
      /**
       * The id for an existing saved segment.
       */
      saved_segment_id?: number;
    };
    /**
     * A description of the [segment](https://mailchimp.com/help/save-and-manage-segments/) used for the campaign. Formatted as a string marked up with HTML.
     */
    readonly segment_text?: string;
  };
  /**
   * For sent campaigns, a summary of opens and clicks.
   */
  report_summary?: {
    /**
     * The number of unique clicks divided by the total number of successful deliveries.
     */
    readonly click_rate?: number;
    /**
     * The total number of clicks for an campaign.
     */
    readonly clicks?: number;
    /**
     * E-Commerce stats for a campaign.
     */
    ecommerce?: {
      /**
       * The total orders for a campaign.
       */
      readonly total_orders?: number;
      /**
       * The total revenue for a campaign. Calculated as the sum of all order totals minus shipping and tax totals.
       */
      readonly total_revenue?: number;
      /**
       * The total spent for a campaign. Calculated as the sum of all order totals with no deductions.
       */
      readonly total_spent?: number;
    };
    /**
     * The number of unique opens divided by the total number of successful deliveries.
     */
    readonly open_rate?: number;
    /**
     * The total number of opens for a campaign.
     */
    readonly opens?: number;
    /**
     * The number of unique clicks.
     */
    readonly subscriber_clicks?: number;
    /**
     * The number of unique opens.
     */
    readonly unique_opens?: number;
  };
  /**
   * Determines if the campaign qualifies to be resent to non-openers.
   */
  readonly resendable?: boolean;
  /**
   * [RSS](https://mailchimp.com/help/share-your-blog-posts-with-mailchimp/) options for a campaign.
   */
  rss_opts?: {
    /**
     * Whether to add CSS to images in the RSS feed to constrain their width in campaigns.
     */
    constrain_rss_img?: boolean;
    /**
     * The URL for the RSS feed.
     */
    feed_url: string;
    /**
     * The frequency of the RSS Campaign.
     */
    frequency: 'daily' | 'weekly' | 'monthly';
    /**
     * The date the campaign was last sent.
     */
    readonly last_sent?: string;
    /**
     * The schedule for sending the RSS Campaign.
     */
    schedule?: {
      /**
       * The days of the week to send a daily RSS Campaign.
       */
      daily_send?: {
        /**
         * Sends the daily RSS Campaign on Fridays.
         */
        friday?: boolean;
        /**
         * Sends the daily RSS Campaign on Mondays.
         */
        monday?: boolean;
        /**
         * Sends the daily RSS Campaign on Saturdays.
         */
        saturday?: boolean;
        /**
         * Sends the daily RSS Campaign on Sundays.
         */
        sunday?: boolean;
        /**
         * Sends the daily RSS Campaign on Thursdays.
         */
        thursday?: boolean;
        /**
         * Sends the daily RSS Campaign on Tuesdays.
         */
        tuesday?: boolean;
        /**
         * Sends the daily RSS Campaign on Wednesdays.
         */
        wednesday?: boolean;
      };
      /**
       * The hour to send the campaign in local time. Acceptable hours are 0-23. For example, '4' would be 4am in [your account's default time zone](https://mailchimp.com/help/set-account-details/).
       */
      hour?: number;
      /**
       * The day of the month to send a monthly RSS Campaign. Acceptable days are 0-31, where '0' is always the last day of a month. Months with fewer than the selected number of days will not have an RSS campaign sent out that day. For example, RSS Campaigns set to send on the 30th will not go out in February.
       */
      monthly_send_date?: number;
      /**
       * The day of the week to send a weekly RSS Campaign.
       */
      weekly_send_day?: 'sunday' | 'monday' | 'tuesday' | 'wednesday' | 'thursday' | 'friday' | 'saturday';
    };
  };
  /**
   * The date and time a campaign was sent in ISO 8601 format.
   */
  readonly send_time?: string;
  /**
   * The settings for your campaign, including subject, from name, reply-to address, and more.
   */
  settings?: {
    /**
     * Whether Mailchimp [authenticated](https://mailchimp.com/help/about-email-authentication/) the campaign. Defaults to `true`.
     */
    authenticate?: boolean;
    /**
     * An array of [Facebook](https://mailchimp.com/help/connect-or-disconnect-the-facebook-integration/) page ids to auto-post to.
     */
    auto_fb_post?: Array<string>;
    /**
     * Automatically append Mailchimp's [default footer](https://mailchimp.com/help/about-campaign-footers/) to the campaign.
     */
    auto_footer?: boolean;
    /**
     * Automatically tweet a link to the [campaign archive](https://mailchimp.com/help/about-email-campaign-archives-and-pages/) page when the campaign is sent.
     */
    auto_tweet?: boolean;
    /**
     * Whether the campaign uses the drag-and-drop editor.
     */
    readonly drag_and_drop?: boolean;
    /**
     * Allows Facebook comments on the campaign (also force-enables the Campaign Archive toolbar). Defaults to `true`.
     */
    fb_comments?: boolean;
    /**
     * If the campaign is listed in a folder, the id for that folder.
     */
    folder_id?: string;
    /**
     * The 'from' name on the campaign (not an email address).
     */
    from_name?: string;
    /**
     * Automatically inline the CSS included with the campaign content.
     */
    inline_css?: boolean;
    /**
     * The preview text for the campaign.
     */
    preview_text?: string;
    /**
     * The reply-to email address for the campaign.
     */
    reply_to?: string;
    /**
     * The subject line for the campaign.
     */
    subject_line?: string;
    /**
     * The id for the template used in this campaign.
     */
    readonly template_id?: number;
    /**
     * Send this campaign using [Timewarp](https://mailchimp.com/help/use-timewarp/).
     */
    readonly timewarp?: boolean;
    /**
     * The title of the campaign.
     */
    title?: string;
    /**
     * The campaign's custom 'To' name. Typically the first name [audience field](https://mailchimp.com/help/getting-started-with-merge-tags/).
     */
    to_name?: string;
    /**
     * Use Mailchimp Conversation feature to manage replies.
     */
    use_conversation?: boolean;
  };
  /**
   * The preview for the campaign, rendered by social networks like Facebook and Twitter. [Learn more](https://mailchimp.com/help/enable-and-customize-social-cards/).
   */
  social_card?: {
    /**
     * A short summary of the campaign to display.
     */
    description?: string;
    /**
     * The url for the header image for the card.
     */
    image_url?: string;
    /**
     * The title for the card. Typically the subject line of the campaign.
     */
    title?: string;
  };
  /**
   * The current status of the campaign.
   */
  readonly status?: 'save' | 'paused' | 'schedule' | 'sending' | 'sent' | 'canceled' | 'canceling' | 'archived';
  /**
   * The tracking options for a campaign.
   */
  tracking?: {
    /**
     * Deprecated
     */
    capsule?: {
      /**
       * Update contact notes for a campaign based on subscriber email addresses.
       */
      notes?: boolean;
    };
    /**
     * The custom slug for [ClickTale](https://mailchimp.com/help/additional-tracking-options-for-campaigns/) tracking (max of 50 bytes).
     */
    clicktale?: string;
    /**
     * Whether to enable e-commerce tracking.
     */
    ecomm360?: boolean;
    /**
     * Deprecated
     */
    goal_tracking?: boolean;
    /**
     * The custom slug for [Google Analytics](https://mailchimp.com/help/integrate-google-analytics-with-mailchimp/) tracking (max of 50 bytes).
     */
    google_analytics?: string;
    /**
     * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the HTML version of the campaign. Defaults to `true`. Cannot be set to false for variate campaigns.
     */
    html_clicks?: boolean;
    /**
     * Whether to [track opens](https://mailchimp.com/help/about-open-tracking/). Defaults to `true`. Cannot be set to false for variate campaigns.
     */
    opens?: boolean;
    /**
     * Deprecated
     */
    salesforce?: {
      /**
       * Create a campaign in a connected Salesforce account.
       */
      campaign?: boolean;
      /**
       * Update contact notes for a campaign based on subscriber email addresses.
       */
      notes?: boolean;
    };
    /**
     * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the plain-text version of the campaign. Defaults to `true`. Cannot be set to false for variate campaigns.
     */
    text_clicks?: boolean;
  };
  /**
   * There are four types of [campaigns](https://mailchimp.com/help/getting-started-with-campaigns/) you can create in Mailchimp. A/B Split campaigns have been deprecated and variate campaigns should be used instead.
   */
  type: 'regular' | 'plaintext' | 'absplit' | 'rss' | 'variate';
  /**
   * The settings specific to A/B test campaigns.
   */
  variate_settings?: {
    /**
     * Combinations of possible variables used to build emails.
     */
    readonly combinations?: Array<{
      /**
       * The index of `variate_settings.contents` used.
       */
      content_description?: number;
      /**
       * The index of `variate_settings.from_names` used.
       */
      from_name?: number;
      /**
       * Unique ID for the combination.
       */
      id?: string;
      /**
       * The number of recipients for this combination.
       */
      recipients?: number;
      /**
       * The index of `variate_settings.reply_to_addresses` used.
       */
      reply_to?: number;
      /**
       * The index of `variate_settings.send_times` used.
       */
      send_time?: number;
      /**
       * The index of `variate_settings.subject_lines` used.
       */
      subject_line?: number;
    }>;
    /**
     * Descriptions of possible email contents. To set campaign contents, make a PUT request to /campaigns/{campaign_id}/content with the field 'variate_contents'.
     */
    readonly contents?: Array<string>;
    /**
     * The possible from names. The number of from_names provided must match the number of reply_to_addresses. If no from_names are provided, settings.from_name will be used.
     */
    from_names?: Array<string>;
    /**
     * The possible reply-to addresses. The number of reply_to_addresses provided must match the number of from_names. If no reply_to_addresses are provided, settings.reply_to will be used.
     */
    reply_to_addresses?: Array<string>;
    /**
     * The possible send times to test. The times provided should be in the format YYYY-MM-DD HH:MM:SS. If send_times are provided to test, the test_size will be set to 100% and winner_criteria will be ignored.
     */
    send_times?: Array<string>;
    /**
     * The possible subject lines to test. If no subject lines are provided, settings.subject_line will be used.
     */
    subject_lines?: Array<string>;
    /**
     * The percentage of recipients to send the test combinations to, must be a value between 10 and 100.
     */
    test_size?: number;
    /**
     * The number of minutes to wait before choosing the winning campaign. The value of wait_time must be greater than 0 and in whole hours, specified in minutes.
     */
    wait_time?: number;
    /**
     * The combination that performs the best. This may be determined automatically by click rate, open rate, or total revenue -- or you may choose manually based on the reporting data you find the most valuable. For Multivariate Campaigns testing send_time, winner_criteria is ignored. For Multivariate Campaigns with 'manual' as the winner_criteria, the winner must be chosen in the Mailchimp web application.
     */
    winner_criteria: 'opens' | 'clicks' | 'manual' | 'total_revenue';
    /**
     * ID of the campaign that was sent to the remaining recipients based on the winning combination.
     */
    readonly winning_campaign_id?: string;
    /**
     * ID for the winning combination.
     */
    readonly winning_combination_id?: string;
  };
  /**
   * The ID used in the Mailchimp web application. View this campaign in your Mailchimp account at `https://{dc}.admin.mailchimp.com/campaigns/show/?id={web_id}`.
   */
  readonly web_id?: number;
};

export type PostCampaignsIdActionsCreateResendError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostCampaignsIdActionsPauseData = {
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
  };
};

export type PostCampaignsIdActionsPauseResponse = any;

export type PostCampaignsIdActionsPauseError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostCampaignsIdActionsReplicateData = {
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
  };
};

export type PostCampaignsIdActionsReplicateResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * [A/B Testing](https://mailchimp.com/help/about-ab-testing-campaigns/) options for a campaign.
   */
  readonly ab_split_opts?: {
    /**
     * For campaigns split on 'From Name', the name for Group A.
     */
    from_name_a?: string;
    /**
     * For campaigns split on 'From Name', the name for Group B.
     */
    from_name_b?: string;
    /**
     * How we should evaluate a winner. Based on 'opens', 'clicks', or 'manual'.
     */
    pick_winner?: 'opens' | 'clicks' | 'manual';
    /**
     * For campaigns split on 'From Name', the reply-to address for Group A.
     */
    reply_email_a?: string;
    /**
     * For campaigns split on 'From Name', the reply-to address for Group B.
     */
    reply_email_b?: string;
    /**
     * The send time for Group A.
     */
    send_time_a?: string;
    /**
     * The send time for Group B.
     */
    send_time_b?: string;
    /**
     * The send time for the winning version.
     */
    send_time_winner?: string;
    /**
     * The size of the split groups. Campaigns split based on 'schedule' are forced to have a 50/50 split. Valid split integers are between 1-50.
     */
    split_size?: number;
    /**
     * The type of AB split to run.
     */
    split_test?: 'subject' | 'from_name' | 'schedule';
    /**
     * For campaigns split on 'Subject Line', the subject line for Group A.
     */
    subject_a?: string;
    /**
     * For campaigns split on 'Subject Line', the subject line for Group B.
     */
    subject_b?: string;
    /**
     * The amount of time to wait before picking a winner. This cannot be changed after a campaign is sent.
     */
    wait_time?: number;
    /**
     * How unit of time for measuring the winner ('hours' or 'days'). This cannot be changed after a campaign is sent.
     */
    wait_units?: 'hours' | 'days';
  };
  /**
   * The link to the campaign's archive version.
   */
  readonly archive_url?: string;
  /**
   * How the campaign's content is put together ('template', 'drag_and_drop', 'html', 'url').
   */
  readonly content_type?: string;
  /**
   * The date and time the campaign was created in ISO 8601 format.
   */
  readonly create_time?: string;
  /**
   * Updates on campaigns in the process of sending.
   */
  delivery_status?: {
    /**
     * Whether a campaign send can be canceled.
     */
    readonly can_cancel?: boolean;
    /**
     * The total number of emails canceled for this campaign.
     */
    readonly emails_canceled?: number;
    /**
     * The total number of emails confirmed sent for this campaign so far.
     */
    readonly emails_sent?: number;
    /**
     * Whether Campaign Delivery Status is enabled for this account and campaign.
     */
    readonly enabled?: boolean;
    /**
     * The current state of a campaign delivery.
     */
    readonly status?: 'delivering' | 'delivered' | 'canceling' | 'canceled';
  };
  /**
   * The total number of emails sent for this campaign.
   */
  readonly emails_sent?: number;
  /**
   * A string that uniquely identifies this campaign.
   */
  readonly id?: string;
  /**
   * The original link to the campaign's archive version.
   */
  readonly long_archive_url?: string;
  /**
   * Determines if the campaign needs its blocks refreshed by opening the web-based campaign editor. Deprecated and will always return false.
   */
  readonly needs_block_refresh?: boolean;
  /**
   * If this campaign is the child of another campaign, this identifies the parent campaign. For Example, for RSS or Automation children.
   */
  readonly parent_campaign_id?: string;
  /**
   * List settings for the campaign.
   */
  recipients?: {
    /**
     * The unique list id.
     */
    list_id: string;
    /**
     * The name of the list.
     */
    readonly list_name?: string;
    /**
     * Count of the recipients on the associated list. Formatted as an integer.
     */
    readonly recipient_count?: number;
    /**
     * An object representing all segmentation options. This object should contain a `saved_segment_id` to use an existing segment, or you can create a new segment by including both `match` and `conditions` options.
     */
    segment_opts?: {
      /**
       * Segment match conditions. There are multiple possible types, see the [condition types documentation](https://mailchimp.com/developer/marketing/docs/alternative-schemas/#segment-condition-schemas).
       */
      conditions?: Array<
        | {
            condition_type?: 'Aim';
            /**
             * Segment by interaction with a specific campaign.
             */
            field?: 'aim';
            /**
             * The status of the member with regard to their campaign interaction. One of the following: opened, clicked, was sent, didn't open, didn't click, or was not sent.
             */
            op?: 'open' | 'click' | 'sent' | 'noopen' | 'noclick' | 'nosent';
            /**
             * Either the web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
             */
            value?: string;
          }
        | {
            condition_type?: 'Automation';
            /**
             * Segment by interaction with an Automation workflow.
             */
            field: 'automation';
            /**
             * The status of the member with regard to the automation workflow. One of the following: has started the workflow, has completed the workflow, has not started the workflow, or has not completed the workflow.
             */
            op: 'started' | 'completed' | 'not_started' | 'not_completed';
            /**
             * The web id for the automation workflow to segment against.
             */
            value: string;
          }
        | {
            condition_type?: 'CampaignPoll';
            /**
             * Segment by poll activity.
             */
            field: 'poll';
            /**
             * Members have/have not interacted with a specific poll in a Mailchimp email.
             */
            op: 'member' | 'notmember';
            /**
             * The id for the poll.
             */
            value: number;
          }
        | {
            condition_type?: 'Conversation';
            /**
             * Segment by interaction with a campaign via Conversations.
             */
            field: 'conversation';
            /**
             * The status of a member's interaction with a conversation. One of the following: has replied or has not replied.
             */
            op: 'member' | 'notmember';
            /**
             * The web id value for a specific campaign or 'any' to account for subscribers who have/have not interacted with any campaigns.
             */
            value: string;
          }
        | {
            condition_type?: 'Date';
            /**
             * When segmenting on 'date' or 'campaign', the date for the segment formatted as YYYY-MM-DD or the web id for the campaign.
             */
            extra?: string;
            /**
             * The type of date field to segment on: The opt-in time for a signup, the date the subscriber was last updated, or the date of their last ecomm purchase.
             */
            field: 'timestamp_opt' | 'info_changed' | 'ecomm_date';
            /**
             * When the event took place:  Before, after, is a specific date, is not a specific date, is blank, or is not blank.
             */
            op: 'greater' | 'less' | 'is' | 'not' | 'blank' | 'blank_not' | 'within' | 'notwithin';
            /**
             * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
             */
            value: string;
          }
        | {
            condition_type?: 'EmailClient';
            /**
             * Segment by use of a particular email client.
             */
            field: 'email_client';
            /**
             * The operation to determine whether we select clients that match the value, or clients that do not match the value.
             */
            op: 'client_is' | 'client_not';
            /**
             * The name of the email client.
             */
            value: string;
          }
        | {
            condition_type?: 'Language';
            /**
             * Segmenting based off of a subscriber's language.
             */
            field: 'language';
            /**
             * Whether the member's language is or is not set to a specific language.
             */
            op: 'is' | 'not';
            /**
             * A two-letter language identifier.
             */
            value: string;
          }
        | {
            condition_type?: 'MemberRating';
            /**
             * Segment by member rating.
             */
            field: 'rating';
            /**
             * Members who have have a rating that is/not exactly a given number or members who have a rating greater/less than a given number.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * The star rating number to segment against.
             */
            value: number;
          }
        | {
            condition_type: 'SignupSource';
            field: 'source';
            /**
             * Whether the member's signup source was/was not a particular value.
             */
            op: 'source_is' | 'source_not';
            /**
             * The signup source.
             */
            value?: string;
          }
        | {
            condition_type?: 'SurveyMonkey';
            /**
             * Segment by interaction with a SurveyMonkey survey.
             */
            field: 'survey_monkey';
            /**
             * The status of the member with regard to the survey.One of the following: has started the survey, has completed the survey, has not started the survey, or has not completed the survey.
             */
            op: 'started' | 'completed' | 'not_started' | 'not_completed';
            /**
             * The unique ID of the survey monkey survey.
             */
            value: string;
          }
        | {
            condition_type?: 'VIP';
            /**
             * Segment by VIP status.
             */
            field: 'gmonkey';
            /**
             * Whether the member is or is not marked as VIP.
             */
            op: 'member' | 'notmember';
          }
        | {
            condition_type?: 'Interests';
            /**
             * Segmenting based on interest group information. This should start with 'interests-' followed by the grouping id. Ex. 'interests-123'.
             */
            field?: string;
            /**
             * Whether the member is a part of one, all, or none of the groups.
             */
            op?: 'interestcontains' | 'interestcontainsall' | 'interestnotcontains';
            /**
             * An array containing strings, each representing a group id.
             */
            value?: Array<string>;
          }
        | {
            condition_type?: 'EcommCategory';
            /**
             * Segment by purchases in specific items or categories.
             */
            field?: 'ecomm_cat' | 'ecomm_prod';
            /**
             * A member who has purchased from a category/specific item that is/is not a specific name, where the category/item name contains/doesn't contain a specific phrase or string, or a category/item name that starts/ends with a string.
             */
            op?: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends';
            /**
             * The ecommerce category/item information.
             */
            value?: string;
          }
        | {
            condition_type?: 'EcommNumber';
            /**
             * Segment by average spent total, number of orders, total number of products purchased, or average number of products per order.
             */
            field: 'ecomm_spent_avg' | 'ecomm_orders' | 'ecomm_prod_all' | 'ecomm_avg_ord';
            /**
             * Members who have spent exactly, have not spent exactly, spent more, or spent less than the segment value.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * Members who have spent exactly, have not spent exactly, spent more, or spent less than this amount.
             */
            value: number;
          }
        | {
            condition_type?: 'EcommPurchased';
            /**
             * Segment by whether someone has purchased anything.
             */
            field?: 'ecomm_purchased';
            /**
             * Members who have have ('member') or have not ('notmember') purchased.
             */
            op?: 'member' | 'notmember';
          }
        | {
            condition_type?: 'EcommSpent';
            /**
             * Segment by amount spent on a single order or across all orders.
             */
            field?: 'ecomm_spent_one' | 'ecomm_spent_all';
            /**
             * Members who have spent 'more' or 'less' than then specified value.
             */
            op?: 'greater' | 'less';
            /**
             * The total amount a member spent.
             */
            value?: number;
          }
        | {
            condition_type?: 'EcommStore';
            /**
             * Segment by purchases from a specific store.
             */
            field?: 'ecomm_store';
            /**
             * Members who have or have not purchased from a specific store.
             */
            op?: 'is' | 'not';
            /**
             * The store id to segment against.
             */
            value?: string;
          }
        | {
            condition_type?: 'GoalActivity';
            /**
             * Segment by Goal activity.
             */
            field: 'goal';
            /**
             * Whether the website URL is/not exactly, contains/doesn't contain, starts with/ends with a string.
             */
            op: 'is' | 'goal_not' | 'contains' | 'goal_notcontain' | 'starts' | 'ends';
            /**
             * The URL to check Goal activity against.
             */
            value: string;
          }
        | {
            condition_type?: 'GoalTimestamp';
            /**
             * Segment by most recent interaction with a website.
             */
            field: 'goal_last_visited';
            /**
             * Whether the website activity happened after, before, or at a given timestamp.
             */
            op: 'greater' | 'less' | 'is';
            /**
             * The date to check Goal activity against.
             */
            value: string;
          }
        | {
            condition_type?: 'FuzzySegment';
            /**
             * Segment by similar subscribers.
             */
            field: 'fuzzy_segment';
            /**
             * Members who are/are not apart of a 'similar subscribers' segment.
             */
            op: 'fuzzy_is' | 'fuzzy_not';
            /**
             * The id for the 'similar subscribers' segment.
             */
            value: number;
          }
        | {
            condition_type?: 'StaticSegment';
            /**
             * Segment by a given static segment.
             */
            field: 'static_segment';
            /**
             * Members who are/are not apart of a static segment.
             */
            op: 'static_is' | 'static_not';
            /**
             * The id for the static segment.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoCountryState';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are within a specific country or US state.
             */
            op: 'ipgeocountry' | 'ipgeonotcountry' | 'ipgeostate' | 'ipgeonotstate';
            /**
             * The two-letter country code or US state abbreviation.
             */
            value: string;
          }
        | {
            /**
             * The address of the target location.
             */
            addr: string;
            condition_type?: 'IPGeoIn';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * The latitude of the target location.
             */
            lat: string;
            /**
             * The longitude of the target location.
             */
            lng: string;
            /**
             * Segment members who are within a specific geographic region.
             */
            op: 'ipgeoin' | 'ipgeonotin';
            /**
             * The radius of the target location.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoInZip';
            /**
             * The zip code to segment against.
             */
            extra: number;
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are within a specific US zip code.
             */
            op: 'ipgeoinzip';
            /**
             * The radius of the target location.
             */
            value: number;
          }
        | {
            condition_type?: 'IPGeoUnknown';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members for which location information is unknown.
             */
            op: 'ipgeounknown';
          }
        | {
            condition_type?: 'IPGeoZip';
            /**
             * Segmenting subscribers who are within a specific location.
             */
            field: 'ipgeo';
            /**
             * Segment members who are/are not within a specific US zip code.
             */
            op: 'ipgeoiszip' | 'ipgeonotzip';
            /**
             * The 5-digit zip code.
             */
            value: number;
          }
        | {
            condition_type?: 'SocialAge';
            /**
             * Segment by age ranges in Social Profiles data.
             */
            field: 'social_age';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The age range to segment.
             */
            value: '18-24' | '25-34' | '35-54' | '55+';
          }
        | {
            condition_type?: 'SocialGender';
            /**
             * Segment by listed gender in Social Profiles data.
             */
            field: 'social_gender';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The Social Profiles gender to segment.
             */
            value: 'male' | 'female';
          }
        | {
            condition_type?: 'SocialInfluence';
            /**
             * Segment by influence rating in Social Profiles data.
             */
            field: 'social_influence';
            /**
             * Members who have a rating that is/not or greater/less than the rating provided.
             */
            op: 'is' | 'not' | 'greater' | 'less';
            /**
             * The Social Profiles influence rating to segment.
             */
            value: number;
          }
        | {
            condition_type?: 'SocialNetworkMember';
            /**
             * Segment by social network in Social Profiles data.
             */
            field: 'social_network';
            /**
             * Members who are/not on a given social network.
             */
            op: 'member' | 'notmember';
            /**
             * The social network to segment against.
             */
            value:
              | 'twitter'
              | 'facebook'
              | 'linkedin'
              | 'flickr'
              | 'foursquare'
              | 'lastfm'
              | 'myspace'
              | 'quora'
              | 'vimeo'
              | 'yelp'
              | 'youtube';
          }
        | {
            condition_type?: 'SocialNetworkFollow';
            /**
             * Segment by social network in Social Profiles data.
             */
            field: 'social_network';
            /**
             * Members who are/not following a linked account on a given social network.
             */
            op: 'follow' | 'notfollow';
            /**
             * The social network to segment against.
             */
            value: 'twitter_follow';
          }
        | {
            condition_type?: 'AddressMerge';
            /**
             * An address-type merge field to segment.
             */
            field: string;
            /**
             * Whether the member's address merge field contains/does not contain a value or is/is not blank.
             */
            op: 'contains' | 'notcontain' | 'blank' | 'blank_not';
            /**
             * The value to segment a text merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'ZipMerge';
            /**
             * The city or the zip being used to segment against.
             */
            extra: string;
            /**
             * An address or zip-type merge field to segment.
             */
            field: string;
            /**
             * Whether the member's address merge field is within a given distance from a city or zip.
             */
            op: 'geoin';
            /**
             * The distance from the city/zip.
             */
            value: string;
          }
        | {
            condition_type?: 'BirthdayMerge';
            /**
             * A date merge field to segment.
             */
            field: string;
            /**
             * Whether the member's birthday merge information is/is not a certain date or is/is not blank.
             */
            op: 'is' | 'not' | 'blank' | 'blank_not';
            /**
             * A date to segment against (mm/dd).
             */
            value?: string;
          }
        | {
            condition_type?: 'DateMerge';
            /**
             * A date merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not, is greater/less than a value or is/is not blank.
             */
            op: 'is' | 'not' | 'less' | 'blank' | 'blank_not' | 'greater';
            /**
             * A date to segment against.
             */
            value?: string;
          }
        | {
            condition_type?: 'SelectMerge';
            /**
             * A merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not a value or is/is not blank.
             */
            op: 'is' | 'not' | 'blank' | 'blank_not' | 'notcontain' | 'contains';
            /**
             * The value to segment a text merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'TextMerge';
            /**
             * A text or number merge field to segment.
             */
            field: string;
            /**
             * Whether the member's merge information is/is not, contains/does not contain, starts/ends with, or is greater/less than a value
             */
            op:
              | 'is'
              | 'not'
              | 'contains'
              | 'notcontain'
              | 'starts'
              | 'ends'
              | 'greater'
              | 'less'
              | 'blank'
              | 'blank_not';
            /**
             * The value to segment a text or number merge field with.
             */
            value?: string;
          }
        | {
            condition_type?: 'EmailAddress';
            /**
             * Segmenting based off of a subscriber's email address.
             */
            field: 'merge0' | 'EMAIL';
            /**
             * Whether the email address is/not exactly, contains/doesn't contain, starts/ends with a string.
             */
            op: 'is' | 'not' | 'contains' | 'notcontain' | 'starts' | 'ends' | 'greater' | 'less';
            /**
             * The value to compare the email against.
             */
            value?: string;
          }
        | {
            condition_type?: 'PredictedGender';
            /**
             * Segment by predicted gender.
             */
            field: 'predicted_gender';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is' | 'not';
            /**
             * The predicted gender to segment.
             */
            value: 'male' | 'female';
          }
        | {
            condition_type?: 'PredictedAge';
            /**
             * Segment by predicted age.
             */
            field: 'predicted_age_range';
            /**
             * Members who are/not the exact criteria listed.
             */
            op: 'is';
            /**
             * The predicted age to segment.
             */
            value: '18-24' | '25-34' | '35-44' | '45-54' | '55-64' | '65+';
          }
        | {
            condition_type?: 'NewSubscribers';
            /**
             * Segment by when people subscribed.
             */
            field?: 'timestamp_opt';
            /**
             * Whe the event took place, namely within a time frame.
             */
            op?: 'date_within';
            /**
             * What type of data to segment on: a specific date, a specific campaign, or the last campaign sent.
             */
            value?: string;
          }
      >;
      /**
       * Segment match type.
       */
      match?: 'any' | 'all';
      /**
       * The prebuilt segment id, if a prebuilt segment has been designated for this campaign.
       */
      prebuilt_segment_id?: string;
      /**
       * The id for an existing saved segment.
       */
      saved_segment_id?: number;
    };
    /**
     * A description of the [segment](https://mailchimp.com/help/save-and-manage-segments/) used for the campaign. Formatted as a string marked up with HTML.
     */
    readonly segment_text?: string;
  };
  /**
   * For sent campaigns, a summary of opens and clicks.
   */
  report_summary?: {
    /**
     * The number of unique clicks divided by the total number of successful deliveries.
     */
    readonly click_rate?: number;
    /**
     * The total number of clicks for an campaign.
     */
    readonly clicks?: number;
    /**
     * E-Commerce stats for a campaign.
     */
    ecommerce?: {
      /**
       * The total orders for a campaign.
       */
      readonly total_orders?: number;
      /**
       * The total revenue for a campaign. Calculated as the sum of all order totals minus shipping and tax totals.
       */
      readonly total_revenue?: number;
      /**
       * The total spent for a campaign. Calculated as the sum of all order totals with no deductions.
       */
      readonly total_spent?: number;
    };
    /**
     * The number of unique opens divided by the total number of successful deliveries.
     */
    readonly open_rate?: number;
    /**
     * The total number of opens for a campaign.
     */
    readonly opens?: number;
    /**
     * The number of unique clicks.
     */
    readonly subscriber_clicks?: number;
    /**
     * The number of unique opens.
     */
    readonly unique_opens?: number;
  };
  /**
   * Determines if the campaign qualifies to be resent to non-openers.
   */
  readonly resendable?: boolean;
  /**
   * [RSS](https://mailchimp.com/help/share-your-blog-posts-with-mailchimp/) options for a campaign.
   */
  rss_opts?: {
    /**
     * Whether to add CSS to images in the RSS feed to constrain their width in campaigns.
     */
    constrain_rss_img?: boolean;
    /**
     * The URL for the RSS feed.
     */
    feed_url: string;
    /**
     * The frequency of the RSS Campaign.
     */
    frequency: 'daily' | 'weekly' | 'monthly';
    /**
     * The date the campaign was last sent.
     */
    readonly last_sent?: string;
    /**
     * The schedule for sending the RSS Campaign.
     */
    schedule?: {
      /**
       * The days of the week to send a daily RSS Campaign.
       */
      daily_send?: {
        /**
         * Sends the daily RSS Campaign on Fridays.
         */
        friday?: boolean;
        /**
         * Sends the daily RSS Campaign on Mondays.
         */
        monday?: boolean;
        /**
         * Sends the daily RSS Campaign on Saturdays.
         */
        saturday?: boolean;
        /**
         * Sends the daily RSS Campaign on Sundays.
         */
        sunday?: boolean;
        /**
         * Sends the daily RSS Campaign on Thursdays.
         */
        thursday?: boolean;
        /**
         * Sends the daily RSS Campaign on Tuesdays.
         */
        tuesday?: boolean;
        /**
         * Sends the daily RSS Campaign on Wednesdays.
         */
        wednesday?: boolean;
      };
      /**
       * The hour to send the campaign in local time. Acceptable hours are 0-23. For example, '4' would be 4am in [your account's default time zone](https://mailchimp.com/help/set-account-details/).
       */
      hour?: number;
      /**
       * The day of the month to send a monthly RSS Campaign. Acceptable days are 0-31, where '0' is always the last day of a month. Months with fewer than the selected number of days will not have an RSS campaign sent out that day. For example, RSS Campaigns set to send on the 30th will not go out in February.
       */
      monthly_send_date?: number;
      /**
       * The day of the week to send a weekly RSS Campaign.
       */
      weekly_send_day?: 'sunday' | 'monday' | 'tuesday' | 'wednesday' | 'thursday' | 'friday' | 'saturday';
    };
  };
  /**
   * The date and time a campaign was sent in ISO 8601 format.
   */
  readonly send_time?: string;
  /**
   * The settings for your campaign, including subject, from name, reply-to address, and more.
   */
  settings?: {
    /**
     * Whether Mailchimp [authenticated](https://mailchimp.com/help/about-email-authentication/) the campaign. Defaults to `true`.
     */
    authenticate?: boolean;
    /**
     * An array of [Facebook](https://mailchimp.com/help/connect-or-disconnect-the-facebook-integration/) page ids to auto-post to.
     */
    auto_fb_post?: Array<string>;
    /**
     * Automatically append Mailchimp's [default footer](https://mailchimp.com/help/about-campaign-footers/) to the campaign.
     */
    auto_footer?: boolean;
    /**
     * Automatically tweet a link to the [campaign archive](https://mailchimp.com/help/about-email-campaign-archives-and-pages/) page when the campaign is sent.
     */
    auto_tweet?: boolean;
    /**
     * Whether the campaign uses the drag-and-drop editor.
     */
    readonly drag_and_drop?: boolean;
    /**
     * Allows Facebook comments on the campaign (also force-enables the Campaign Archive toolbar). Defaults to `true`.
     */
    fb_comments?: boolean;
    /**
     * If the campaign is listed in a folder, the id for that folder.
     */
    folder_id?: string;
    /**
     * The 'from' name on the campaign (not an email address).
     */
    from_name?: string;
    /**
     * Automatically inline the CSS included with the campaign content.
     */
    inline_css?: boolean;
    /**
     * The preview text for the campaign.
     */
    preview_text?: string;
    /**
     * The reply-to email address for the campaign.
     */
    reply_to?: string;
    /**
     * The subject line for the campaign.
     */
    subject_line?: string;
    /**
     * The id for the template used in this campaign.
     */
    readonly template_id?: number;
    /**
     * Send this campaign using [Timewarp](https://mailchimp.com/help/use-timewarp/).
     */
    readonly timewarp?: boolean;
    /**
     * The title of the campaign.
     */
    title?: string;
    /**
     * The campaign's custom 'To' name. Typically the first name [audience field](https://mailchimp.com/help/getting-started-with-merge-tags/).
     */
    to_name?: string;
    /**
     * Use Mailchimp Conversation feature to manage replies.
     */
    use_conversation?: boolean;
  };
  /**
   * The preview for the campaign, rendered by social networks like Facebook and Twitter. [Learn more](https://mailchimp.com/help/enable-and-customize-social-cards/).
   */
  social_card?: {
    /**
     * A short summary of the campaign to display.
     */
    description?: string;
    /**
     * The url for the header image for the card.
     */
    image_url?: string;
    /**
     * The title for the card. Typically the subject line of the campaign.
     */
    title?: string;
  };
  /**
   * The current status of the campaign.
   */
  readonly status?: 'save' | 'paused' | 'schedule' | 'sending' | 'sent' | 'canceled' | 'canceling' | 'archived';
  /**
   * The tracking options for a campaign.
   */
  tracking?: {
    /**
     * Deprecated
     */
    capsule?: {
      /**
       * Update contact notes for a campaign based on subscriber email addresses.
       */
      notes?: boolean;
    };
    /**
     * The custom slug for [ClickTale](https://mailchimp.com/help/additional-tracking-options-for-campaigns/) tracking (max of 50 bytes).
     */
    clicktale?: string;
    /**
     * Whether to enable e-commerce tracking.
     */
    ecomm360?: boolean;
    /**
     * Deprecated
     */
    goal_tracking?: boolean;
    /**
     * The custom slug for [Google Analytics](https://mailchimp.com/help/integrate-google-analytics-with-mailchimp/) tracking (max of 50 bytes).
     */
    google_analytics?: string;
    /**
     * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the HTML version of the campaign. Defaults to `true`. Cannot be set to false for variate campaigns.
     */
    html_clicks?: boolean;
    /**
     * Whether to [track opens](https://mailchimp.com/help/about-open-tracking/). Defaults to `true`. Cannot be set to false for variate campaigns.
     */
    opens?: boolean;
    /**
     * Deprecated
     */
    salesforce?: {
      /**
       * Create a campaign in a connected Salesforce account.
       */
      campaign?: boolean;
      /**
       * Update contact notes for a campaign based on subscriber email addresses.
       */
      notes?: boolean;
    };
    /**
     * Whether to [track clicks](https://mailchimp.com/help/enable-and-view-click-tracking/) in the plain-text version of the campaign. Defaults to `true`. Cannot be set to false for variate campaigns.
     */
    text_clicks?: boolean;
  };
  /**
   * There are four types of [campaigns](https://mailchimp.com/help/getting-started-with-campaigns/) you can create in Mailchimp. A/B Split campaigns have been deprecated and variate campaigns should be used instead.
   */
  type: 'regular' | 'plaintext' | 'absplit' | 'rss' | 'variate';
  /**
   * The settings specific to A/B test campaigns.
   */
  variate_settings?: {
    /**
     * Combinations of possible variables used to build emails.
     */
    readonly combinations?: Array<{
      /**
       * The index of `variate_settings.contents` used.
       */
      content_description?: number;
      /**
       * The index of `variate_settings.from_names` used.
       */
      from_name?: number;
      /**
       * Unique ID for the combination.
       */
      id?: string;
      /**
       * The number of recipients for this combination.
       */
      recipients?: number;
      /**
       * The index of `variate_settings.reply_to_addresses` used.
       */
      reply_to?: number;
      /**
       * The index of `variate_settings.send_times` used.
       */
      send_time?: number;
      /**
       * The index of `variate_settings.subject_lines` used.
       */
      subject_line?: number;
    }>;
    /**
     * Descriptions of possible email contents. To set campaign contents, make a PUT request to /campaigns/{campaign_id}/content with the field 'variate_contents'.
     */
    readonly contents?: Array<string>;
    /**
     * The possible from names. The number of from_names provided must match the number of reply_to_addresses. If no from_names are provided, settings.from_name will be used.
     */
    from_names?: Array<string>;
    /**
     * The possible reply-to addresses. The number of reply_to_addresses provided must match the number of from_names. If no reply_to_addresses are provided, settings.reply_to will be used.
     */
    reply_to_addresses?: Array<string>;
    /**
     * The possible send times to test. The times provided should be in the format YYYY-MM-DD HH:MM:SS. If send_times are provided to test, the test_size will be set to 100% and winner_criteria will be ignored.
     */
    send_times?: Array<string>;
    /**
     * The possible subject lines to test. If no subject lines are provided, settings.subject_line will be used.
     */
    subject_lines?: Array<string>;
    /**
     * The percentage of recipients to send the test combinations to, must be a value between 10 and 100.
     */
    test_size?: number;
    /**
     * The number of minutes to wait before choosing the winning campaign. The value of wait_time must be greater than 0 and in whole hours, specified in minutes.
     */
    wait_time?: number;
    /**
     * The combination that performs the best. This may be determined automatically by click rate, open rate, or total revenue -- or you may choose manually based on the reporting data you find the most valuable. For Multivariate Campaigns testing send_time, winner_criteria is ignored. For Multivariate Campaigns with 'manual' as the winner_criteria, the winner must be chosen in the Mailchimp web application.
     */
    winner_criteria: 'opens' | 'clicks' | 'manual' | 'total_revenue';
    /**
     * ID of the campaign that was sent to the remaining recipients based on the winning combination.
     */
    readonly winning_campaign_id?: string;
    /**
     * ID for the winning combination.
     */
    readonly winning_combination_id?: string;
  };
  /**
   * The ID used in the Mailchimp web application. View this campaign in your Mailchimp account at `https://{dc}.admin.mailchimp.com/campaigns/show/?id={web_id}`.
   */
  readonly web_id?: number;
};

export type PostCampaignsIdActionsReplicateError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostCampaignsIdActionsResumeData = {
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
  };
};

export type PostCampaignsIdActionsResumeResponse = any;

export type PostCampaignsIdActionsResumeError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostCampaignsIdActionsScheduleData = {
  body: {
    /**
     * Choose whether the campaign should use [Batch Delivery](https://mailchimp.com/help/schedule-batch-delivery/). Cannot be set to `true` for campaigns using [Timewarp](https://mailchimp.com/help/use-timewarp/).
     */
    batch_delivery?: {
      /**
       * The number of batches for the campaign send.
       */
      batch_count: number;
      /**
       * The delay, in minutes, between batches.
       */
      batch_delay: number;
    };
    /**
     * The UTC date and time to schedule the campaign for delivery in ISO 8601 format. Campaigns may only be scheduled to send on the quarter-hour (:00, :15, :30, :45).
     */
    schedule_time: string;
    /**
     * Choose whether the campaign should use [Timewarp](https://mailchimp.com/help/use-timewarp/) when sending. Campaigns scheduled with Timewarp are localized based on the recipients' time zones. For example, a Timewarp campaign with a `schedule_time` of 13:00 will be sent to each recipient at 1:00pm in their local time. Cannot be set to `true` for campaigns using [Batch Delivery](https://mailchimp.com/help/schedule-batch-delivery/).
     */
    timewarp?: boolean;
  };
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
  };
};

export type PostCampaignsIdActionsScheduleResponse = any;

export type PostCampaignsIdActionsScheduleError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostCampaignsIdActionsSendData = {
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
  };
};

export type PostCampaignsIdActionsSendResponse = any;

export type PostCampaignsIdActionsSendError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostCampaignsIdActionsTestData = {
  body: {
    /**
     * Choose the type of test email to send.
     */
    send_type: 'html' | 'plaintext';
    /**
     * An array of email addresses to send the test email to.
     */
    test_emails: Array<string>;
  };
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
  };
};

export type PostCampaignsIdActionsTestResponse = any;

export type PostCampaignsIdActionsTestError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostCampaignsIdActionsUnscheduleData = {
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
  };
};

export type PostCampaignsIdActionsUnscheduleResponse = any;

export type PostCampaignsIdActionsUnscheduleError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetCampaignsIdContentData = {
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetCampaignsIdContentResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The Archive HTML for the campaign.
   */
  archive_html?: string;
  /**
   * The raw HTML for the campaign.
   */
  html?: string;
  /**
   * The plain-text portion of the campaign. If left unspecified, we'll generate this automatically.
   */
  plain_text?: string;
  /**
   * Content options for multivariate campaigns.
   */
  variate_contents?: Array<{
    /**
     * Label used to identify the content option.
     */
    content_label?: string;
    /**
     * The raw HTML for the campaign.
     */
    html?: string;
    /**
     * The plain-text portion of the campaign. If left unspecified, we'll generate this automatically.
     */
    plain_text?: string;
  }>;
};

export type GetCampaignsIdContentError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PutCampaignsIdContentData = {
  body: {
    /**
     * Available when uploading an archive to create campaign content. The archive should include all campaign content and images. [Learn more](https://mailchimp.com/help/import-a-custom-html-template/).
     */
    archive?: {
      /**
       * The base64-encoded representation of the archive file.
       */
      archive_content: string;
      /**
       * The type of encoded file. Defaults to zip.
       */
      archive_type?: 'zip' | 'tar.gz' | 'tar.bz2' | 'tar' | 'tgz' | 'tbz';
    };
    /**
     * The raw HTML for the campaign.
     */
    html?: string;
    /**
     * The plain-text portion of the campaign. If left unspecified, we'll generate this automatically.
     */
    plain_text?: string;
    /**
     * Use this template to generate the HTML content of the campaign
     */
    template?: {
      /**
       * The id of the template to use.
       */
      id: number;
      /**
       * Content for the sections of the template. Each key should be the unique [mc:edit area](https://mailchimp.com/help/create-editable-content-areas-with-mailchimps-template-language/) name from the template.
       */
      sections?: {
        [key: string]: unknown;
      };
    };
    /**
     * When importing a campaign, the URL where the HTML lives.
     */
    url?: string;
    /**
     * Content options for [Multivariate Campaigns](https://mailchimp.com/help/about-multivariate-campaigns/). Each content option must provide HTML content and may optionally provide plain text. For campaigns not testing content, only one object should be provided.
     */
    variate_contents?: Array<{
      /**
       * Available when uploading an archive to create campaign content. The archive should include all campaign content and images. [Learn more](https://mailchimp.com/help/import-a-custom-html-template/).
       */
      archive?: {
        /**
         * The base64-encoded representation of the archive file.
         */
        archive_content: string;
        /**
         * The type of encoded file. Defaults to zip.
         */
        archive_type?: 'zip' | 'tar.gz' | 'tar.bz2' | 'tar' | 'tgz' | 'tbz';
      };
      /**
       * The label used to identify the content option.
       */
      content_label: string;
      /**
       * The raw HTML for the campaign.
       */
      html?: string;
      /**
       * The plain-text portion of the campaign. If left unspecified, we'll generate this automatically.
       */
      plain_text?: string;
      /**
       * Use this template to generate the HTML content for the campaign.
       */
      template?: {
        /**
         * The id of the template to use.
         */
        id: number;
        /**
         * Content for the sections of the template. Each key should be the unique [mc:edit area](https://mailchimp.com/help/create-editable-content-areas-with-mailchimps-template-language/) name from the template.
         */
        sections?: {
          [key: string]: unknown;
        };
      };
      /**
       * When importing a campaign, the URL for the HTML.
       */
      url?: string;
    }>;
  };
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
  };
};

export type PutCampaignsIdContentResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The Archive HTML for the campaign.
   */
  archive_html?: string;
  /**
   * The raw HTML for the campaign.
   */
  html?: string;
  /**
   * The plain-text portion of the campaign. If left unspecified, we'll generate this automatically.
   */
  plain_text?: string;
  /**
   * Content options for multivariate campaigns.
   */
  variate_contents?: Array<{
    /**
     * Label used to identify the content option.
     */
    content_label?: string;
    /**
     * The raw HTML for the campaign.
     */
    html?: string;
    /**
     * The plain-text portion of the campaign. If left unspecified, we'll generate this automatically.
     */
    plain_text?: string;
  }>;
};

export type PutCampaignsIdContentError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetCampaignsIdFeedbackData = {
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetCampaignsIdFeedbackResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The unique id for the campaign.
   */
  readonly campaign_id?: string;
  /**
   * A collection of feedback items for a campaign.
   */
  feedback?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The block id for the editable block that the feedback addresses.
     */
    block_id?: number;
    /**
     * The unique id for the campaign.
     */
    readonly campaign_id?: string;
    /**
     * The date and time the feedback item was created in ISO 8601 format.
     */
    readonly created_at?: string;
    /**
     * The login name of the user who created the feedback.
     */
    readonly created_by?: string;
    /**
     * The individual id for the feedback item.
     */
    readonly feedback_id?: number;
    /**
     * The status of feedback.
     */
    is_complete?: boolean;
    /**
     * The content of the feedback.
     */
    message: string;
    /**
     * If a reply, the id of the parent feedback item.
     */
    readonly parent_id?: number;
    /**
     * The source of the feedback.
     */
    readonly source?: 'api' | 'email' | 'sms' | 'web' | 'ios' | 'android';
    /**
     * The date and time the feedback was last updated in ISO 8601 format.
     */
    readonly updated_at?: string;
  }>;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetCampaignsIdFeedbackError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostCampaignsIdFeedbackData = {
  body: {
    /**
     * The block id for the editable block that the feedback addresses.
     */
    block_id?: number;
    /**
     * The status of feedback.
     */
    is_complete?: boolean;
    /**
     * The content of the feedback.
     */
    message: string;
  };
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
  };
};

export type PostCampaignsIdFeedbackResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The block id for the editable block that the feedback addresses.
   */
  block_id?: number;
  /**
   * The unique id for the campaign.
   */
  readonly campaign_id?: string;
  /**
   * The date and time the feedback item was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * The login name of the user who created the feedback.
   */
  readonly created_by?: string;
  /**
   * The individual id for the feedback item.
   */
  readonly feedback_id?: number;
  /**
   * The status of feedback.
   */
  is_complete?: boolean;
  /**
   * The content of the feedback.
   */
  message?: string;
  /**
   * If a reply, the id of the parent feedback item.
   */
  readonly parent_id?: number;
  /**
   * The source of the feedback.
   */
  readonly source?: 'api' | 'email' | 'sms' | 'web' | 'ios' | 'android';
  /**
   * The date and time the feedback was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
};

export type PostCampaignsIdFeedbackError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type DeleteCampaignsIdFeedbackIdData = {
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
    /**
     * The unique id for the feedback message.
     */
    feedback_id: string;
  };
};

export type DeleteCampaignsIdFeedbackIdResponse = any;

export type DeleteCampaignsIdFeedbackIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetCampaignsIdFeedbackIdData = {
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
    /**
     * The unique id for the feedback message.
     */
    feedback_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetCampaignsIdFeedbackIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The block id for the editable block that the feedback addresses.
   */
  block_id?: number;
  /**
   * The unique id for the campaign.
   */
  readonly campaign_id?: string;
  /**
   * The date and time the feedback item was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * The login name of the user who created the feedback.
   */
  readonly created_by?: string;
  /**
   * The individual id for the feedback item.
   */
  readonly feedback_id?: number;
  /**
   * The status of feedback.
   */
  is_complete?: boolean;
  /**
   * The content of the feedback.
   */
  message?: string;
  /**
   * If a reply, the id of the parent feedback item.
   */
  readonly parent_id?: number;
  /**
   * The source of the feedback.
   */
  readonly source?: 'api' | 'email' | 'sms' | 'web' | 'ios' | 'android';
  /**
   * The date and time the feedback was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
};

export type GetCampaignsIdFeedbackIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PatchCampaignsIdFeedbackIdData = {
  body: {
    /**
     * The block id for the editable block that the feedback addresses.
     */
    block_id?: number;
    /**
     * The status of feedback.
     */
    is_complete?: boolean;
    /**
     * The content of the feedback.
     */
    message?: string;
  };
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
    /**
     * The unique id for the feedback message.
     */
    feedback_id: string;
  };
};

export type PatchCampaignsIdFeedbackIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The block id for the editable block that the feedback addresses.
   */
  block_id?: number;
  /**
   * The unique id for the campaign.
   */
  readonly campaign_id?: string;
  /**
   * The date and time the feedback item was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * The login name of the user who created the feedback.
   */
  readonly created_by?: string;
  /**
   * The individual id for the feedback item.
   */
  readonly feedback_id?: number;
  /**
   * The status of feedback.
   */
  is_complete?: boolean;
  /**
   * The content of the feedback.
   */
  message?: string;
  /**
   * If a reply, the id of the parent feedback item.
   */
  readonly parent_id?: number;
  /**
   * The source of the feedback.
   */
  readonly source?: 'api' | 'email' | 'sms' | 'web' | 'ios' | 'android';
  /**
   * The date and time the feedback was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
};

export type PatchCampaignsIdFeedbackIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetCampaignsIdSendChecklistData = {
  path: {
    /**
     * The unique id for the campaign.
     */
    campaign_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetCampaignsIdSendChecklistResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * Whether the campaign is ready to send.
   */
  is_ready?: boolean;
  /**
   * A list of feedback items to review before sending your campaign.
   */
  items?: Array<{
    /**
     * Details about the specific feedback item.
     */
    details?: string;
    /**
     * The heading for the specific item.
     */
    heading?: string;
    /**
     * The ID for the specific item.
     */
    id?: number;
    /**
     * The item type.
     */
    type?: 'success' | 'warning' | 'error';
  }>;
};

export type GetCampaignsIdSendChecklistError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetConnectedSitesData = {
  query?: {
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
  };
};

export type GetConnectedSitesResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of objects, each representing a connected site.
   */
  sites?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The date and time the connected site was created in ISO 8601 format.
     */
    readonly created_at?: string;
    /**
     * The connected site domain.
     */
    readonly domain?: string;
    /**
     * The unique identifier for the site.
     */
    readonly foreign_id?: string;
    /**
     * The platform of the connected site.
     */
    readonly platform?: string;
    /**
     * The script used to connect your site with Mailchimp.
     */
    readonly site_script?: {
      /**
       * A pre-built script that you can copy-and-paste into your site to integrate it with Mailchimp.
       */
      fragment?: string;
      /**
       * The URL used for any integrations that offer built-in support for connected sites.
       */
      url?: string;
    };
    /**
     * The unique identifier for the ecommerce store that's associated with the connected site (if any). The store_id for a specific connected site can't change.
     */
    readonly store_id?: string;
    /**
     * The date and time the connected site was last updated in ISO 8601 format.
     */
    readonly updated_at?: string;
  }>;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetConnectedSitesError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostConnectedSitesData = {
  body: {
    /**
     * The connected site domain.
     */
    domain: string;
    /**
     * The unique identifier for the site.
     */
    foreign_id: string;
  };
};

export type PostConnectedSitesResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The date and time the connected site was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * The connected site domain.
   */
  readonly domain?: string;
  /**
   * The unique identifier for the site.
   */
  readonly foreign_id?: string;
  /**
   * The platform of the connected site.
   */
  readonly platform?: string;
  /**
   * The script used to connect your site with Mailchimp.
   */
  readonly site_script?: {
    /**
     * A pre-built script that you can copy-and-paste into your site to integrate it with Mailchimp.
     */
    fragment?: string;
    /**
     * The URL used for any integrations that offer built-in support for connected sites.
     */
    url?: string;
  };
  /**
   * The unique identifier for the ecommerce store that's associated with the connected site (if any). The store_id for a specific connected site can't change.
   */
  readonly store_id?: string;
  /**
   * The date and time the connected site was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
};

export type PostConnectedSitesError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type DeleteConnectedSitesIdData = {
  path: {
    /**
     * The unique identifier for the site.
     */
    connected_site_id: string;
  };
};

export type DeleteConnectedSitesIdResponse = any;

export type DeleteConnectedSitesIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetConnectedSitesIdData = {
  path: {
    /**
     * The unique identifier for the site.
     */
    connected_site_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetConnectedSitesIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The date and time the connected site was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * The connected site domain.
   */
  readonly domain?: string;
  /**
   * The unique identifier for the site.
   */
  readonly foreign_id?: string;
  /**
   * The platform of the connected site.
   */
  readonly platform?: string;
  /**
   * The script used to connect your site with Mailchimp.
   */
  readonly site_script?: {
    /**
     * A pre-built script that you can copy-and-paste into your site to integrate it with Mailchimp.
     */
    fragment?: string;
    /**
     * The URL used for any integrations that offer built-in support for connected sites.
     */
    url?: string;
  };
  /**
   * The unique identifier for the ecommerce store that's associated with the connected site (if any). The store_id for a specific connected site can't change.
   */
  readonly store_id?: string;
  /**
   * The date and time the connected site was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
};

export type GetConnectedSitesIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostConnectedSitesIdActionsVerifyScriptInstallationData = {
  path: {
    /**
     * The unique identifier for the site.
     */
    connected_site_id: string;
  };
};

export type PostConnectedSitesIdActionsVerifyScriptInstallationResponse = any;

export type PostConnectedSitesIdActionsVerifyScriptInstallationError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetConversationsData = {
  query?: {
    /**
     * The unique id for the campaign.
     */
    campaign_id?: string;
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Whether the conversation has any unread messages.
     */
    has_unread_messages?: 'true' | 'false';
    /**
     * The unique id for the list.
     */
    list_id?: string;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
  };
};

export type GetConversationsResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * A list of conversations.
   */
  conversations?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The unique identifier of the campaign for this conversation.
     */
    readonly campaign_id?: string;
    /**
     * A label representing the email of the sender of this message.
     */
    readonly from_email?: string;
    /**
     * A label representing the sender of this message.
     */
    readonly from_label?: string;
    /**
     * A string that uniquely identifies this conversation.
     */
    readonly id?: string;
    /**
     * The most recent message in the conversation.
     */
    last_message?: {
      /**
       * A label representing the email of the sender of this message.
       */
      readonly from_email?: string;
      /**
       * A label representing the sender of this message.
       */
      readonly from_label?: string;
      /**
       * The plain-text content of the message.
       */
      readonly message?: string;
      /**
       * Whether this message has been marked as read.
       */
      read?: boolean;
      /**
       * The subject of this message.
       */
      readonly subject?: string;
      /**
       * The date and time the message was either sent or received in ISO 8601 format.
       */
      readonly timestamp?: string;
    };
    /**
     * The unique identifier of the list for this conversation.
     */
    readonly list_id?: string;
    /**
     * The total number of messages in this conversation.
     */
    readonly message_count?: number;
    /**
     * The subject of the message.
     */
    readonly subject?: string;
    /**
     * The number of unread messages in this conversation.
     */
    readonly unread_messages?: number;
  }>;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetConversationsError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetConversationsIdData = {
  path: {
    /**
     * The unique id for the conversation.
     */
    conversation_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetConversationsIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The unique identifier of the campaign for this conversation.
   */
  readonly campaign_id?: string;
  /**
   * A label representing the email of the sender of this message.
   */
  readonly from_email?: string;
  /**
   * A label representing the sender of this message.
   */
  readonly from_label?: string;
  /**
   * A string that uniquely identifies this conversation.
   */
  readonly id?: string;
  /**
   * The most recent message in the conversation.
   */
  last_message?: {
    /**
     * A label representing the email of the sender of this message.
     */
    readonly from_email?: string;
    /**
     * A label representing the sender of this message.
     */
    readonly from_label?: string;
    /**
     * The plain-text content of the message.
     */
    readonly message?: string;
    /**
     * Whether this message has been marked as read.
     */
    read?: boolean;
    /**
     * The subject of this message.
     */
    readonly subject?: string;
    /**
     * The date and time the message was either sent or received in ISO 8601 format.
     */
    readonly timestamp?: string;
  };
  /**
   * The unique identifier of the list for this conversation.
   */
  readonly list_id?: string;
  /**
   * The total number of messages in this conversation.
   */
  readonly message_count?: number;
  /**
   * The subject of the message.
   */
  readonly subject?: string;
  /**
   * The number of unread messages in this conversation.
   */
  readonly unread_messages?: number;
};

export type GetConversationsIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetConversationsIdMessagesData = {
  path: {
    /**
     * The unique id for the conversation.
     */
    conversation_id: string;
  };
  query?: {
    /**
     * Restrict the response to messages created before the set time. Uses ISO 8601 time format: 2015-10-21T15:41:36+00:00.
     */
    before_timestamp?: string;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Whether a conversation message has been marked as read.
     */
    is_read?: 'true' | 'false';
    /**
     * Restrict the response to messages created after the set time. Uses ISO 8601 time format: 2015-10-21T15:41:36+00:00.
     */
    since_timestamp?: string;
  };
};

export type GetConversationsIdMessagesResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * A string that identifies this conversation.
   */
  conversation_id?: string;
  /**
   * An array of objects, each representing a conversation messages resources.
   */
  conversation_messages?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * A string that identifies this message's conversation
     */
    readonly conversation_id?: string;
    /**
     * A label representing the email of the sender of this message
     */
    from_email?: string;
    /**
     * A label representing the sender of this message
     */
    readonly from_label?: string;
    /**
     * A string that uniquely identifies this message
     */
    readonly id?: string;
    /**
     * The list's web ID
     */
    readonly list_id?: number;
    /**
     * The plain-text content of the message
     */
    message?: string;
    /**
     * Whether this message has been marked as read
     */
    read?: boolean;
    /**
     * The subject of this message
     */
    subject?: string;
    /**
     * The date and time the message was either sent or received in ISO 8601 format.
     */
    readonly timestamp?: string;
  }>;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetConversationsIdMessagesError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetConversationsIdMessagesIdData = {
  path: {
    /**
     * The unique id for the conversation.
     */
    conversation_id: string;
    /**
     * The unique id for the conversation message.
     */
    message_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetConversationsIdMessagesIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * A string that identifies this message's conversation
   */
  readonly conversation_id?: string;
  /**
   * A label representing the email of the sender of this message
   */
  from_email?: string;
  /**
   * A label representing the sender of this message
   */
  readonly from_label?: string;
  /**
   * A string that uniquely identifies this message
   */
  readonly id?: string;
  /**
   * The list's web ID
   */
  readonly list_id?: number;
  /**
   * The plain-text content of the message
   */
  message?: string;
  /**
   * Whether this message has been marked as read
   */
  read?: boolean;
  /**
   * The subject of this message
   */
  subject?: string;
  /**
   * The date and time the message was either sent or received in ISO 8601 format.
   */
  readonly timestamp?: string;
};

export type GetConversationsIdMessagesIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostCustomerJourneysJourneysIdStepsIdActionsTriggerData = {
  body: {
    /**
     * The list member's email address.
     */
    email_address: string;
  };
  path: {
    /**
     * The id for the Journey.
     */
    journey_id: number;
    /**
     * The id for the Step.
     */
    step_id: number;
  };
};

export type PostCustomerJourneysJourneysIdStepsIdActionsTriggerResponse = unknown;

export type PostCustomerJourneysJourneysIdStepsIdActionsTriggerError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceOrdersData = {
  query?: {
    /**
     * Restrict results to orders with a specific `campaign_id` value.
     */
    campaign_id?: string;
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * Restrict results to orders made by a specific customer.
     */
    customer_id?: string;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Restrict results to orders that have an outreach attached. For example, an email campaign or Facebook ad.
     */
    has_outreach?: boolean;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
    /**
     * Restrict results to orders with a specific `outreach_id` value.
     */
    outreach_id?: string;
  };
};

export type GetEcommerceOrdersResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of objects, each representing an order resource.
   */
  orders?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The billing address for the order.
     */
    billing_address?: {
      /**
       * The billing address for the order.
       */
      address1?: string;
      /**
       * An additional field for the billing address.
       */
      address2?: string;
      /**
       * The city in the billing address.
       */
      city?: string;
      /**
       * The company associated with the billing address.
       */
      company?: string;
      /**
       * The country in the billing address.
       */
      country?: string;
      /**
       * The two-letter code for the country in the billing address.
       */
      country_code?: string;
      /**
       * The latitude for the billing address location.
       */
      latitude?: number;
      /**
       * The longitude for the billing address location.
       */
      longitude?: number;
      /**
       * The name associated with an order's billing address.
       */
      name?: string;
      /**
       * The phone number for the billing address.
       */
      phone?: string;
      /**
       * The postal or zip code in the billing address.
       */
      postal_code?: string;
      /**
       * The state or normalized province in the billing address.
       */
      province?: string;
      /**
       * The two-letter code for the province or state in the billing address.
       */
      province_code?: string;
    };
    /**
     * A string that uniquely identifies the campaign associated with an order.
     */
    campaign_id?: string;
    /**
     * The date and time the order was cancelled in ISO 8601 format.
     */
    cancelled_at_foreign?: string;
    /**
     * The three-letter ISO 4217 code for the currency that the store accepts.
     */
    currency_code?: string;
    /**
     * Information about a specific customer.
     */
    customer?: {
      /**
       * A list of link types and descriptions for the API schema documents.
       */
      readonly _links?: Array<{
        /**
         * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
         */
        readonly href?: string;
        /**
         * The HTTP method that should be used when accessing the URL defined in 'href'.
         */
        readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
        /**
         * As with an HTML 'rel' attribute, this describes the type of link.
         */
        readonly rel?: string;
        /**
         * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
         */
        readonly schema?: string;
        /**
         * For GETs, this is a URL representing the schema that the response should conform to.
         */
        readonly targetSchema?: string;
      }>;
      /**
       * The customer's address.
       */
      address?: {
        /**
         * The mailing address of the customer.
         */
        address1?: string;
        /**
         * An additional field for the customer's mailing address.
         */
        address2?: string;
        /**
         * The city the customer is located in.
         */
        city?: string;
        /**
         * The customer's country.
         */
        country?: string;
        /**
         * The two-letter code for the customer's country.
         */
        country_code?: string;
        /**
         * The customer's postal or zip code.
         */
        postal_code?: string;
        /**
         * The customer's state name or normalized province.
         */
        province?: string;
        /**
         * The two-letter code for the customer's province or state.
         */
        province_code?: string;
      };
      /**
       * The customer's company.
       */
      company?: string;
      /**
       * The date and time the customer was created in ISO 8601 format.
       */
      readonly created_at?: string;
      /**
       * The customer's email address.
       */
      readonly email_address?: string;
      /**
       * The customer's first name.
       */
      first_name?: string;
      /**
       * A unique identifier for the customer.
       */
      readonly id?: string;
      /**
       * The customer's last name.
       */
      last_name?: string;
      /**
       * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
       */
      opt_in_status?: boolean;
      /**
       * The customer's total order count.
       */
      readonly orders_count?: number;
      /**
       * The total amount the customer has spent.
       */
      readonly total_spent?: number;
      /**
       * The date and time the customer was last updated in ISO 8601 format.
       */
      readonly updated_at?: string;
    };
    /**
     * The total amount of the discounts to be applied to the price of the order.
     */
    discount_total?: number;
    /**
     * The order status. Use this parameter to trigger [Order Notifications](https://mailchimp.com/developer/marketing/docs/e-commerce/#order-notifications).
     */
    financial_status?: string;
    /**
     * The fulfillment status for the order. Use this parameter to trigger [Order Notifications](https://mailchimp.com/developer/marketing/docs/e-commerce/#order-notifications).
     */
    fulfillment_status?: string;
    /**
     * A unique identifier for the order.
     */
    readonly id?: string;
    /**
     * The URL for the page where the buyer landed when entering the shop.
     */
    landing_site?: string;
    /**
     * An array of the order's line items.
     */
    lines?: Array<{
      /**
       * A list of link types and descriptions for the API schema documents.
       */
      readonly _links?: Array<{
        /**
         * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
         */
        readonly href?: string;
        /**
         * The HTTP method that should be used when accessing the URL defined in 'href'.
         */
        readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
        /**
         * As with an HTML 'rel' attribute, this describes the type of link.
         */
        readonly rel?: string;
        /**
         * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
         */
        readonly schema?: string;
        /**
         * For GETs, this is a URL representing the schema that the response should conform to.
         */
        readonly targetSchema?: string;
      }>;
      /**
       * The total discount amount applied to a line item.
       */
      discount?: number;
      /**
       * A unique identifier for an order line item.
       */
      readonly id?: string;
      /**
       * The image URL for a product.
       */
      readonly image_url?: string;
      /**
       * The order line item price.
       */
      price?: number;
      /**
       * A unique identifier for the product associated with an order line item.
       */
      product_id?: string;
      /**
       * The name of the product for an order line item.
       */
      readonly product_title?: string;
      /**
       * A unique identifier for the product variant associated with an order line item.
       */
      product_variant_id?: string;
      /**
       * The name of the product variant for an order line item.
       */
      readonly product_variant_title?: string;
      /**
       * The order line item quantity.
       */
      quantity?: number;
    }>;
    /**
     * The order total associated with an order.
     */
    order_total?: number;
    /**
     * The URL for the order.
     */
    order_url?: string;
    /**
     * The outreach associated with this order. For example, an email campaign or Facebook ad.
     */
    outreach?: {
      /**
       * A unique identifier for the outreach. Can be an email campaign ID.
       */
      id?: string;
      /**
       * The name for the outreach.
       */
      readonly name?: string;
      /**
       * The date and time the Outreach was published in ISO 8601 format.
       */
      readonly published_time?: string;
      /**
       * The type of the outreach.
       */
      readonly type?: string;
    };
    /**
     * The date and time the order was processed in ISO 8601 format.
     */
    processed_at_foreign?: string;
    /**
     * The promo codes applied on the order
     */
    promos?: Array<{
      /**
       * The amount of discount applied on the total price. For example if the total cost was $100 and the customer paid $95.5, amount_discounted will be 4.5 For free shipping set amount_discounted to 0
       */
      amount_discounted?: number;
      /**
       * The Promo Code
       */
      code?: string;
      /**
       * Type of discount. For free shipping set type to fixed
       */
      type?: 'fixed' | 'percentage';
    }>;
    /**
     * The shipping address for the order.
     */
    shipping_address?: {
      /**
       * The shipping address for the order.
       */
      address1?: string;
      /**
       * An additional field for the shipping address.
       */
      address2?: string;
      /**
       * The city in the order's shipping address.
       */
      city?: string;
      /**
       * The company associated with an order's shipping address.
       */
      company?: string;
      /**
       * The country in the order's shipping address.
       */
      country?: string;
      /**
       * The two-letter code for the country in the shipping address.
       */
      country_code?: string;
      /**
       * The latitude for the shipping address location.
       */
      latitude?: number;
      /**
       * The longitude for the shipping address location.
       */
      longitude?: number;
      /**
       * The name associated with an order's shipping address.
       */
      name?: string;
      /**
       * The phone number for the order's shipping address
       */
      phone?: string;
      /**
       * The postal or zip code in the order's shipping address.
       */
      postal_code?: string;
      /**
       * The state or normalized province in the order's shipping address.
       */
      province?: string;
      /**
       * The two-letter code for the province or state the order's shipping address is located in.
       */
      province_code?: string;
    };
    /**
     * The shipping total for the order.
     */
    shipping_total?: number;
    /**
     * The unique identifier for the store.
     */
    readonly store_id?: string;
    /**
     * The tax total associated with an order.
     */
    tax_total?: number;
    /**
     * The tracking carrier associated with the order.
     */
    tracking_carrier?: string;
    /**
     * The Mailchimp tracking code for the order. Uses the 'mc_tc' parameter in E-Commerce tracking URLs.
     */
    tracking_code?: 'prec';
    /**
     * The tracking number associated with the order.
     */
    tracking_number?: string;
    /**
     * The tracking URL associated with the order.
     */
    tracking_url?: string;
    /**
     * The date and time the order was updated in ISO 8601 format.
     */
    updated_at_foreign?: string;
  }>;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetEcommerceOrdersError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresData = {
  query?: {
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
  };
};

export type GetEcommerceStoresResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of objects, each representing a store.
   */
  stores?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The store address.
     */
    address?: {
      /**
       * The store's mailing address.
       */
      address1?: string;
      /**
       * An additional field for the store's mailing address.
       */
      address2?: string;
      /**
       * The city the store is located in.
       */
      city?: string;
      /**
       * The store's country.
       */
      country?: string;
      /**
       * The two-letter code for to the store's country.
       */
      country_code?: string;
      /**
       * The latitude of the store location.
       */
      latitude?: number;
      /**
       * The longitude of the store location.
       */
      longitude?: number;
      /**
       * The store's postal or zip code.
       */
      postal_code?: string;
      /**
       * The store's state name or normalized province.
       */
      province?: string;
      /**
       * The two-letter code for the store's province or state.
       */
      province_code?: string;
    };
    /**
     * Details for the automations attached to this store.
     */
    readonly automations?: {
      /**
       * abandonedBrowse automation details. abandonedBrowse is also known as Product Retargeting Email or Retarget Site Visitors on the web.
       */
      readonly abandoned_browse?: {
        /**
         * Unique ID of automation parent campaign.
         */
        readonly id?: string;
        /**
         * Whether this store supports the abandonedBrowse automation.
         */
        readonly is_supported?: boolean;
        /**
         * Status of the abandonedBrowse automation.
         */
        readonly status?: 'save' | 'sending' | 'paused';
      };
      /**
       * abandonedCart automation details.
       */
      readonly abandoned_cart?: {
        /**
         * Unique ID of automation parent campaign.
         */
        readonly id?: string;
        /**
         * Whether this store supports the abandonedCart automation.
         */
        readonly is_supported?: boolean;
        /**
         * Status of the abandonedCart automation.
         */
        readonly status?: 'save' | 'sending' | 'paused';
      };
    };
    /**
     * The Connected Site associated with the store.
     */
    readonly connected_site?: {
      /**
       * The unique identifier for the connected site.
       */
      readonly site_foreign_id?: string;
      /**
       * The script used to connect your site with Mailchimp.
       */
      readonly site_script?: {
        /**
         * A pre-built script that you can copy-and-paste into your site to integrate it with Mailchimp.
         */
        readonly fragment?: string;
        /**
         * The URL used for any integrations that offer built-in support for connected sites.
         */
        readonly url?: string;
      };
    };
    /**
     * The date and time the store was created in ISO 8601 format.
     */
    readonly created_at?: string;
    /**
     * The three-letter ISO 4217 code for the currency that the store accepts.
     */
    currency_code?: string;
    /**
     * The store domain.  The store domain must be unique within a user account.
     */
    domain?: string;
    /**
     * The email address for the store.
     */
    email_address?: string;
    /**
     * The unique identifier for the store.
     */
    readonly id?: string;
    /**
     * Whether to disable automations because the store is currently [syncing](https://mailchimp.com/developer/marketing/docs/e-commerce/#pausing-store-automations).
     */
    is_syncing?: boolean;
    /**
     * The unique identifier for the list that's associated with the store. The `list_id` for a specific store can't change.
     */
    readonly list_id?: string;
    /**
     * The status of the list connected to the store, namely if it's deleted or disabled.
     */
    readonly list_is_active?: boolean;
    /**
     * The currency format for the store. For example: `$`, `£`, etc.
     */
    money_format?: string;
    /**
     * The name of the store.
     */
    name?: string;
    /**
     * The store phone number.
     */
    phone?: string;
    /**
     * The e-commerce platform of the store.
     */
    platform?: string;
    /**
     * The primary locale for the store. For example: `en`, `de`, etc.
     */
    primary_locale?: string;
    /**
     * The timezone for the store.
     */
    timezone?: string;
    /**
     * The date and time the store was last updated in ISO 8601 format.
     */
    readonly updated_at?: string;
  }>;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetEcommerceStoresError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostEcommerceStoresData = {
  body: {
    /**
     * The store address.
     */
    address?: {
      /**
       * The store's mailing address.
       */
      address1?: string;
      /**
       * An additional field for the store's mailing address.
       */
      address2?: string;
      /**
       * The city the store is located in.
       */
      city?: string;
      /**
       * The store's country.
       */
      country?: string;
      /**
       * The two-letter code for to the store's country.
       */
      country_code?: string;
      /**
       * The latitude of the store location.
       */
      latitude?: number;
      /**
       * The longitude of the store location.
       */
      longitude?: number;
      /**
       * The store's postal or zip code.
       */
      postal_code?: string;
      /**
       * The store's state name or normalized province.
       */
      province?: string;
      /**
       * The two-letter code for the store's province or state.
       */
      province_code?: string;
    };
    /**
     * The three-letter ISO 4217 code for the currency that the store accepts.
     */
    currency_code: string;
    /**
     * The store domain. This parameter is required for Connected Sites and Google Ads.
     */
    domain?: string;
    /**
     * The email address for the store.
     */
    email_address?: string;
    /**
     * The unique identifier for the store.
     */
    id: string;
    /**
     * Whether to disable automations because the store is currently [syncing](https://mailchimp.com/developer/marketing/docs/e-commerce/#pausing-store-automations).
     */
    is_syncing?: boolean;
    /**
     * The unique identifier for the list associated with the store. The `list_id` for a specific store cannot change.
     */
    list_id: string;
    /**
     * The currency format for the store. For example: `$`, `£`, etc.
     */
    money_format?: string;
    /**
     * The name of the store.
     */
    name: string;
    /**
     * The store phone number.
     */
    phone?: string;
    /**
     * The e-commerce platform of the store.
     */
    platform?: string;
    /**
     * The primary locale for the store. For example: `en`, `de`, etc.
     */
    primary_locale?: string;
    /**
     * The timezone for the store.
     */
    timezone?: string;
  };
};

export type PostEcommerceStoresResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The store address.
   */
  address?: {
    /**
     * The store's mailing address.
     */
    address1?: string;
    /**
     * An additional field for the store's mailing address.
     */
    address2?: string;
    /**
     * The city the store is located in.
     */
    city?: string;
    /**
     * The store's country.
     */
    country?: string;
    /**
     * The two-letter code for to the store's country.
     */
    country_code?: string;
    /**
     * The latitude of the store location.
     */
    latitude?: number;
    /**
     * The longitude of the store location.
     */
    longitude?: number;
    /**
     * The store's postal or zip code.
     */
    postal_code?: string;
    /**
     * The store's state name or normalized province.
     */
    province?: string;
    /**
     * The two-letter code for the store's province or state.
     */
    province_code?: string;
  };
  /**
   * Details for the automations attached to this store.
   */
  readonly automations?: {
    /**
     * abandonedBrowse automation details. abandonedBrowse is also known as Product Retargeting Email or Retarget Site Visitors on the web.
     */
    readonly abandoned_browse?: {
      /**
       * Unique ID of automation parent campaign.
       */
      readonly id?: string;
      /**
       * Whether this store supports the abandonedBrowse automation.
       */
      readonly is_supported?: boolean;
      /**
       * Status of the abandonedBrowse automation.
       */
      readonly status?: 'save' | 'sending' | 'paused';
    };
    /**
     * abandonedCart automation details.
     */
    readonly abandoned_cart?: {
      /**
       * Unique ID of automation parent campaign.
       */
      readonly id?: string;
      /**
       * Whether this store supports the abandonedCart automation.
       */
      readonly is_supported?: boolean;
      /**
       * Status of the abandonedCart automation.
       */
      readonly status?: 'save' | 'sending' | 'paused';
    };
  };
  /**
   * The Connected Site associated with the store.
   */
  readonly connected_site?: {
    /**
     * The unique identifier for the connected site.
     */
    readonly site_foreign_id?: string;
    /**
     * The script used to connect your site with Mailchimp.
     */
    readonly site_script?: {
      /**
       * A pre-built script that you can copy-and-paste into your site to integrate it with Mailchimp.
       */
      readonly fragment?: string;
      /**
       * The URL used for any integrations that offer built-in support for connected sites.
       */
      readonly url?: string;
    };
  };
  /**
   * The date and time the store was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * The three-letter ISO 4217 code for the currency that the store accepts.
   */
  currency_code?: string;
  /**
   * The store domain.  The store domain must be unique within a user account.
   */
  domain?: string;
  /**
   * The email address for the store.
   */
  email_address?: string;
  /**
   * The unique identifier for the store.
   */
  readonly id?: string;
  /**
   * Whether to disable automations because the store is currently [syncing](https://mailchimp.com/developer/marketing/docs/e-commerce/#pausing-store-automations).
   */
  is_syncing?: boolean;
  /**
   * The unique identifier for the list that's associated with the store. The `list_id` for a specific store can't change.
   */
  readonly list_id?: string;
  /**
   * The status of the list connected to the store, namely if it's deleted or disabled.
   */
  readonly list_is_active?: boolean;
  /**
   * The currency format for the store. For example: `$`, `£`, etc.
   */
  money_format?: string;
  /**
   * The name of the store.
   */
  name?: string;
  /**
   * The store phone number.
   */
  phone?: string;
  /**
   * The e-commerce platform of the store.
   */
  platform?: string;
  /**
   * The primary locale for the store. For example: `en`, `de`, etc.
   */
  primary_locale?: string;
  /**
   * The timezone for the store.
   */
  timezone?: string;
  /**
   * The date and time the store was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
};

export type PostEcommerceStoresError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type DeleteEcommerceStoresIdData = {
  path: {
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type DeleteEcommerceStoresIdResponse = unknown;

export type DeleteEcommerceStoresIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdData = {
  path: {
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetEcommerceStoresIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The store address.
   */
  address?: {
    /**
     * The store's mailing address.
     */
    address1?: string;
    /**
     * An additional field for the store's mailing address.
     */
    address2?: string;
    /**
     * The city the store is located in.
     */
    city?: string;
    /**
     * The store's country.
     */
    country?: string;
    /**
     * The two-letter code for to the store's country.
     */
    country_code?: string;
    /**
     * The latitude of the store location.
     */
    latitude?: number;
    /**
     * The longitude of the store location.
     */
    longitude?: number;
    /**
     * The store's postal or zip code.
     */
    postal_code?: string;
    /**
     * The store's state name or normalized province.
     */
    province?: string;
    /**
     * The two-letter code for the store's province or state.
     */
    province_code?: string;
  };
  /**
   * Details for the automations attached to this store.
   */
  readonly automations?: {
    /**
     * abandonedBrowse automation details. abandonedBrowse is also known as Product Retargeting Email or Retarget Site Visitors on the web.
     */
    readonly abandoned_browse?: {
      /**
       * Unique ID of automation parent campaign.
       */
      readonly id?: string;
      /**
       * Whether this store supports the abandonedBrowse automation.
       */
      readonly is_supported?: boolean;
      /**
       * Status of the abandonedBrowse automation.
       */
      readonly status?: 'save' | 'sending' | 'paused';
    };
    /**
     * abandonedCart automation details.
     */
    readonly abandoned_cart?: {
      /**
       * Unique ID of automation parent campaign.
       */
      readonly id?: string;
      /**
       * Whether this store supports the abandonedCart automation.
       */
      readonly is_supported?: boolean;
      /**
       * Status of the abandonedCart automation.
       */
      readonly status?: 'save' | 'sending' | 'paused';
    };
  };
  /**
   * The Connected Site associated with the store.
   */
  readonly connected_site?: {
    /**
     * The unique identifier for the connected site.
     */
    readonly site_foreign_id?: string;
    /**
     * The script used to connect your site with Mailchimp.
     */
    readonly site_script?: {
      /**
       * A pre-built script that you can copy-and-paste into your site to integrate it with Mailchimp.
       */
      readonly fragment?: string;
      /**
       * The URL used for any integrations that offer built-in support for connected sites.
       */
      readonly url?: string;
    };
  };
  /**
   * The date and time the store was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * The three-letter ISO 4217 code for the currency that the store accepts.
   */
  currency_code?: string;
  /**
   * The store domain.  The store domain must be unique within a user account.
   */
  domain?: string;
  /**
   * The email address for the store.
   */
  email_address?: string;
  /**
   * The unique identifier for the store.
   */
  readonly id?: string;
  /**
   * Whether to disable automations because the store is currently [syncing](https://mailchimp.com/developer/marketing/docs/e-commerce/#pausing-store-automations).
   */
  is_syncing?: boolean;
  /**
   * The unique identifier for the list that's associated with the store. The `list_id` for a specific store can't change.
   */
  readonly list_id?: string;
  /**
   * The status of the list connected to the store, namely if it's deleted or disabled.
   */
  readonly list_is_active?: boolean;
  /**
   * The currency format for the store. For example: `$`, `£`, etc.
   */
  money_format?: string;
  /**
   * The name of the store.
   */
  name?: string;
  /**
   * The store phone number.
   */
  phone?: string;
  /**
   * The e-commerce platform of the store.
   */
  platform?: string;
  /**
   * The primary locale for the store. For example: `en`, `de`, etc.
   */
  primary_locale?: string;
  /**
   * The timezone for the store.
   */
  timezone?: string;
  /**
   * The date and time the store was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
};

export type GetEcommerceStoresIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PatchEcommerceStoresIdData = {
  body: {
    /**
     * The store address.
     */
    address?: {
      /**
       * The store's mailing address.
       */
      address1?: string;
      /**
       * An additional field for the store's mailing address.
       */
      address2?: string;
      /**
       * The city the store is located in.
       */
      city?: string;
      /**
       * The store's country.
       */
      country?: string;
      /**
       * The two-letter code for to the store's country.
       */
      country_code?: string;
      /**
       * The latitude of the store location.
       */
      latitude?: number;
      /**
       * The longitude of the store location.
       */
      longitude?: number;
      /**
       * The store's postal or zip code.
       */
      postal_code?: string;
      /**
       * The store's state name or normalized province.
       */
      province?: string;
      /**
       * The two-letter code for the store's province or state.
       */
      province_code?: string;
    };
    /**
     * The three-letter ISO 4217 code for the currency that the store accepts.
     */
    currency_code?: string;
    /**
     * The store domain.
     */
    domain?: string;
    /**
     * The email address for the store.
     */
    email_address?: string;
    /**
     * Whether to disable automations because the store is currently [syncing](https://mailchimp.com/developer/marketing/docs/e-commerce/#pausing-store-automations).
     */
    is_syncing?: boolean;
    /**
     * The currency format for the store. For example: `$`, `£`, etc.
     */
    money_format?: string;
    /**
     * The name of the store.
     */
    name?: string;
    /**
     * The store phone number.
     */
    phone?: string;
    /**
     * The e-commerce platform of the store.
     */
    platform?: string;
    /**
     * The primary locale for the store. For example: `en`, `de`, etc.
     */
    primary_locale?: string;
    /**
     * The timezone for the store.
     */
    timezone?: string;
  };
  path: {
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PatchEcommerceStoresIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The store address.
   */
  address?: {
    /**
     * The store's mailing address.
     */
    address1?: string;
    /**
     * An additional field for the store's mailing address.
     */
    address2?: string;
    /**
     * The city the store is located in.
     */
    city?: string;
    /**
     * The store's country.
     */
    country?: string;
    /**
     * The two-letter code for to the store's country.
     */
    country_code?: string;
    /**
     * The latitude of the store location.
     */
    latitude?: number;
    /**
     * The longitude of the store location.
     */
    longitude?: number;
    /**
     * The store's postal or zip code.
     */
    postal_code?: string;
    /**
     * The store's state name or normalized province.
     */
    province?: string;
    /**
     * The two-letter code for the store's province or state.
     */
    province_code?: string;
  };
  /**
   * Details for the automations attached to this store.
   */
  readonly automations?: {
    /**
     * abandonedBrowse automation details. abandonedBrowse is also known as Product Retargeting Email or Retarget Site Visitors on the web.
     */
    readonly abandoned_browse?: {
      /**
       * Unique ID of automation parent campaign.
       */
      readonly id?: string;
      /**
       * Whether this store supports the abandonedBrowse automation.
       */
      readonly is_supported?: boolean;
      /**
       * Status of the abandonedBrowse automation.
       */
      readonly status?: 'save' | 'sending' | 'paused';
    };
    /**
     * abandonedCart automation details.
     */
    readonly abandoned_cart?: {
      /**
       * Unique ID of automation parent campaign.
       */
      readonly id?: string;
      /**
       * Whether this store supports the abandonedCart automation.
       */
      readonly is_supported?: boolean;
      /**
       * Status of the abandonedCart automation.
       */
      readonly status?: 'save' | 'sending' | 'paused';
    };
  };
  /**
   * The Connected Site associated with the store.
   */
  readonly connected_site?: {
    /**
     * The unique identifier for the connected site.
     */
    readonly site_foreign_id?: string;
    /**
     * The script used to connect your site with Mailchimp.
     */
    readonly site_script?: {
      /**
       * A pre-built script that you can copy-and-paste into your site to integrate it with Mailchimp.
       */
      readonly fragment?: string;
      /**
       * The URL used for any integrations that offer built-in support for connected sites.
       */
      readonly url?: string;
    };
  };
  /**
   * The date and time the store was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * The three-letter ISO 4217 code for the currency that the store accepts.
   */
  currency_code?: string;
  /**
   * The store domain.  The store domain must be unique within a user account.
   */
  domain?: string;
  /**
   * The email address for the store.
   */
  email_address?: string;
  /**
   * The unique identifier for the store.
   */
  readonly id?: string;
  /**
   * Whether to disable automations because the store is currently [syncing](https://mailchimp.com/developer/marketing/docs/e-commerce/#pausing-store-automations).
   */
  is_syncing?: boolean;
  /**
   * The unique identifier for the list that's associated with the store. The `list_id` for a specific store can't change.
   */
  readonly list_id?: string;
  /**
   * The status of the list connected to the store, namely if it's deleted or disabled.
   */
  readonly list_is_active?: boolean;
  /**
   * The currency format for the store. For example: `$`, `£`, etc.
   */
  money_format?: string;
  /**
   * The name of the store.
   */
  name?: string;
  /**
   * The store phone number.
   */
  phone?: string;
  /**
   * The e-commerce platform of the store.
   */
  platform?: string;
  /**
   * The primary locale for the store. For example: `en`, `de`, etc.
   */
  primary_locale?: string;
  /**
   * The timezone for the store.
   */
  timezone?: string;
  /**
   * The date and time the store was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
};

export type PatchEcommerceStoresIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdCartsData = {
  path: {
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
  };
};

export type GetEcommerceStoresIdCartsResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of objects, each representing a cart.
   */
  carts?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * A string that uniquely identifies the campaign associated with a cart.
     */
    campaign_id?: string;
    /**
     * The URL for the cart. This parameter is required for [Abandoned Cart](https://mailchimp.com/help/create-an-abandoned-cart-email/) automations.
     */
    checkout_url?: string;
    /**
     * The date and time the cart was created in ISO 8601 format.
     */
    readonly created_at?: string;
    /**
     * The three-letter ISO 4217 code for the currency that the cart uses.
     */
    currency_code?: string;
    /**
     * Information about a specific customer.
     */
    customer?: {
      /**
       * A list of link types and descriptions for the API schema documents.
       */
      readonly _links?: Array<{
        /**
         * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
         */
        readonly href?: string;
        /**
         * The HTTP method that should be used when accessing the URL defined in 'href'.
         */
        readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
        /**
         * As with an HTML 'rel' attribute, this describes the type of link.
         */
        readonly rel?: string;
        /**
         * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
         */
        readonly schema?: string;
        /**
         * For GETs, this is a URL representing the schema that the response should conform to.
         */
        readonly targetSchema?: string;
      }>;
      /**
       * The customer's address.
       */
      address?: {
        /**
         * The mailing address of the customer.
         */
        address1?: string;
        /**
         * An additional field for the customer's mailing address.
         */
        address2?: string;
        /**
         * The city the customer is located in.
         */
        city?: string;
        /**
         * The customer's country.
         */
        country?: string;
        /**
         * The two-letter code for the customer's country.
         */
        country_code?: string;
        /**
         * The customer's postal or zip code.
         */
        postal_code?: string;
        /**
         * The customer's state name or normalized province.
         */
        province?: string;
        /**
         * The two-letter code for the customer's province or state.
         */
        province_code?: string;
      };
      /**
       * The customer's company.
       */
      company?: string;
      /**
       * The date and time the customer was created in ISO 8601 format.
       */
      readonly created_at?: string;
      /**
       * The customer's email address.
       */
      readonly email_address?: string;
      /**
       * The customer's first name.
       */
      first_name?: string;
      /**
       * A unique identifier for the customer.
       */
      readonly id?: string;
      /**
       * The customer's last name.
       */
      last_name?: string;
      /**
       * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
       */
      opt_in_status?: boolean;
      /**
       * The customer's total order count.
       */
      readonly orders_count?: number;
      /**
       * The total amount the customer has spent.
       */
      readonly total_spent?: number;
      /**
       * The date and time the customer was last updated in ISO 8601 format.
       */
      readonly updated_at?: string;
    };
    /**
     * A unique identifier for the cart.
     */
    readonly id?: string;
    /**
     * An array of the cart's line items.
     */
    lines?: Array<{
      /**
       * A list of link types and descriptions for the API schema documents.
       */
      readonly _links?: Array<{
        /**
         * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
         */
        readonly href?: string;
        /**
         * The HTTP method that should be used when accessing the URL defined in 'href'.
         */
        readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
        /**
         * As with an HTML 'rel' attribute, this describes the type of link.
         */
        readonly rel?: string;
        /**
         * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
         */
        readonly schema?: string;
        /**
         * For GETs, this is a URL representing the schema that the response should conform to.
         */
        readonly targetSchema?: string;
      }>;
      /**
       * A unique identifier for the cart line item.
       */
      readonly id?: string;
      /**
       * The price of a cart line item.
       */
      price?: number;
      /**
       * A unique identifier for the product associated with the cart line item.
       */
      product_id?: string;
      /**
       * The name of the product for the cart line item.
       */
      readonly product_title?: string;
      /**
       * A unique identifier for the product variant associated with the cart line item.
       */
      product_variant_id?: string;
      /**
       * The name of the product variant for the cart line item.
       */
      readonly product_variant_title?: string;
      /**
       * The quantity of a cart line item.
       */
      quantity?: number;
    }>;
    /**
     * The order total for the cart.
     */
    order_total?: number;
    /**
     * The total tax for the cart.
     */
    tax_total?: number;
    /**
     * The date and time the cart was last updated in ISO 8601 format.
     */
    readonly updated_at?: string;
  }>;
  /**
   * The store id.
   */
  store_id?: string;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetEcommerceStoresIdCartsError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostEcommerceStoresIdCartsData = {
  body: {
    /**
     * A string that uniquely identifies the campaign for a cart.
     */
    campaign_id?: string;
    /**
     * The URL for the cart. This parameter is required for [Abandoned Cart](https://mailchimp.com/help/create-an-abandoned-cart-email/) automations.
     */
    checkout_url?: string;
    /**
     * The three-letter ISO 4217 code for the currency that the cart uses.
     */
    currency_code: string;
    /**
     * Information about a specific customer. For existing customers include only the `id` parameter in the `customer` object body.
     */
    customer: {
      /**
       * The customer's address.
       */
      address?: {
        /**
         * The mailing address of the customer.
         */
        address1?: string;
        /**
         * An additional field for the customer's mailing address.
         */
        address2?: string;
        /**
         * The city the customer is located in.
         */
        city?: string;
        /**
         * The customer's country.
         */
        country?: string;
        /**
         * The two-letter code for the customer's country.
         */
        country_code?: string;
        /**
         * The customer's postal or zip code.
         */
        postal_code?: string;
        /**
         * The customer's state name or normalized province.
         */
        province?: string;
        /**
         * The two-letter code for the customer's province or state.
         */
        province_code?: string;
      };
      /**
       * The customer's company.
       */
      company?: string;
      /**
       * The customer's email address.
       */
      email_address?: string;
      /**
       * The customer's first name.
       */
      first_name?: string;
      /**
       * A unique identifier for the customer. Limited to 50 characters.
       */
      id: string;
      /**
       * The customer's last name.
       */
      last_name?: string;
      /**
       * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
       */
      opt_in_status?: boolean;
    };
    /**
     * A unique identifier for the cart.
     */
    id: string;
    /**
     * An array of the cart's line items.
     */
    lines: Array<{
      /**
       * A unique identifier for the cart line item.
       */
      id: string;
      /**
       * The price of a cart line item.
       */
      price: number;
      /**
       * A unique identifier for the product associated with the cart line item.
       */
      product_id: string;
      /**
       * A unique identifier for the product variant associated with the cart line item.
       */
      product_variant_id: string;
      /**
       * The quantity of a cart line item.
       */
      quantity: number;
    }>;
    /**
     * The order total for the cart.
     */
    order_total: number;
    /**
     * The total tax for the cart.
     */
    tax_total?: number;
  };
  path: {
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PostEcommerceStoresIdCartsResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * A string that uniquely identifies the campaign associated with a cart.
   */
  campaign_id?: string;
  /**
   * The URL for the cart. This parameter is required for [Abandoned Cart](https://mailchimp.com/help/create-an-abandoned-cart-email/) automations.
   */
  checkout_url?: string;
  /**
   * The date and time the cart was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * The three-letter ISO 4217 code for the currency that the cart uses.
   */
  currency_code?: string;
  /**
   * Information about a specific customer.
   */
  customer?: {
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The customer's address.
     */
    address?: {
      /**
       * The mailing address of the customer.
       */
      address1?: string;
      /**
       * An additional field for the customer's mailing address.
       */
      address2?: string;
      /**
       * The city the customer is located in.
       */
      city?: string;
      /**
       * The customer's country.
       */
      country?: string;
      /**
       * The two-letter code for the customer's country.
       */
      country_code?: string;
      /**
       * The customer's postal or zip code.
       */
      postal_code?: string;
      /**
       * The customer's state name or normalized province.
       */
      province?: string;
      /**
       * The two-letter code for the customer's province or state.
       */
      province_code?: string;
    };
    /**
     * The customer's company.
     */
    company?: string;
    /**
     * The date and time the customer was created in ISO 8601 format.
     */
    readonly created_at?: string;
    /**
     * The customer's email address.
     */
    readonly email_address?: string;
    /**
     * The customer's first name.
     */
    first_name?: string;
    /**
     * A unique identifier for the customer.
     */
    readonly id?: string;
    /**
     * The customer's last name.
     */
    last_name?: string;
    /**
     * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
     */
    opt_in_status?: boolean;
    /**
     * The customer's total order count.
     */
    readonly orders_count?: number;
    /**
     * The total amount the customer has spent.
     */
    readonly total_spent?: number;
    /**
     * The date and time the customer was last updated in ISO 8601 format.
     */
    readonly updated_at?: string;
  };
  /**
   * A unique identifier for the cart.
   */
  readonly id?: string;
  /**
   * An array of the cart's line items.
   */
  lines?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * A unique identifier for the cart line item.
     */
    readonly id?: string;
    /**
     * The price of a cart line item.
     */
    price?: number;
    /**
     * A unique identifier for the product associated with the cart line item.
     */
    product_id?: string;
    /**
     * The name of the product for the cart line item.
     */
    readonly product_title?: string;
    /**
     * A unique identifier for the product variant associated with the cart line item.
     */
    product_variant_id?: string;
    /**
     * The name of the product variant for the cart line item.
     */
    readonly product_variant_title?: string;
    /**
     * The quantity of a cart line item.
     */
    quantity?: number;
  }>;
  /**
   * The order total for the cart.
   */
  order_total?: number;
  /**
   * The total tax for the cart.
   */
  tax_total?: number;
  /**
   * The date and time the cart was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
};

export type PostEcommerceStoresIdCartsError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type DeleteEcommerceStoresIdCartsIdData = {
  path: {
    /**
     * The id for the cart.
     */
    cart_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type DeleteEcommerceStoresIdCartsIdResponse = any;

export type DeleteEcommerceStoresIdCartsIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdCartsIdData = {
  path: {
    /**
     * The id for the cart.
     */
    cart_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetEcommerceStoresIdCartsIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * A string that uniquely identifies the campaign associated with a cart.
   */
  campaign_id?: string;
  /**
   * The URL for the cart. This parameter is required for [Abandoned Cart](https://mailchimp.com/help/create-an-abandoned-cart-email/) automations.
   */
  checkout_url?: string;
  /**
   * The date and time the cart was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * The three-letter ISO 4217 code for the currency that the cart uses.
   */
  currency_code?: string;
  /**
   * Information about a specific customer.
   */
  customer?: {
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The customer's address.
     */
    address?: {
      /**
       * The mailing address of the customer.
       */
      address1?: string;
      /**
       * An additional field for the customer's mailing address.
       */
      address2?: string;
      /**
       * The city the customer is located in.
       */
      city?: string;
      /**
       * The customer's country.
       */
      country?: string;
      /**
       * The two-letter code for the customer's country.
       */
      country_code?: string;
      /**
       * The customer's postal or zip code.
       */
      postal_code?: string;
      /**
       * The customer's state name or normalized province.
       */
      province?: string;
      /**
       * The two-letter code for the customer's province or state.
       */
      province_code?: string;
    };
    /**
     * The customer's company.
     */
    company?: string;
    /**
     * The date and time the customer was created in ISO 8601 format.
     */
    readonly created_at?: string;
    /**
     * The customer's email address.
     */
    readonly email_address?: string;
    /**
     * The customer's first name.
     */
    first_name?: string;
    /**
     * A unique identifier for the customer.
     */
    readonly id?: string;
    /**
     * The customer's last name.
     */
    last_name?: string;
    /**
     * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
     */
    opt_in_status?: boolean;
    /**
     * The customer's total order count.
     */
    readonly orders_count?: number;
    /**
     * The total amount the customer has spent.
     */
    readonly total_spent?: number;
    /**
     * The date and time the customer was last updated in ISO 8601 format.
     */
    readonly updated_at?: string;
  };
  /**
   * A unique identifier for the cart.
   */
  readonly id?: string;
  /**
   * An array of the cart's line items.
   */
  lines?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * A unique identifier for the cart line item.
     */
    readonly id?: string;
    /**
     * The price of a cart line item.
     */
    price?: number;
    /**
     * A unique identifier for the product associated with the cart line item.
     */
    product_id?: string;
    /**
     * The name of the product for the cart line item.
     */
    readonly product_title?: string;
    /**
     * A unique identifier for the product variant associated with the cart line item.
     */
    product_variant_id?: string;
    /**
     * The name of the product variant for the cart line item.
     */
    readonly product_variant_title?: string;
    /**
     * The quantity of a cart line item.
     */
    quantity?: number;
  }>;
  /**
   * The order total for the cart.
   */
  order_total?: number;
  /**
   * The total tax for the cart.
   */
  tax_total?: number;
  /**
   * The date and time the cart was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
};

export type GetEcommerceStoresIdCartsIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PatchEcommerceStoresIdCartsIdData = {
  body: {
    /**
     * A string that uniquely identifies the campaign associated with a cart.
     */
    campaign_id?: string;
    /**
     * The URL for the cart. This parameter is required for [Abandoned Cart](https://mailchimp.com/help/create-an-abandoned-cart-email/) automations.
     */
    checkout_url?: string;
    /**
     * The three-letter ISO 4217 code for the currency that the cart uses.
     */
    currency_code?: string;
    /**
     * Information about a specific customer. Orders for existing customers should include only the `id` parameter in the `customer` object body.
     */
    customer?: {
      /**
       * The customer's address.
       */
      address?: {
        /**
         * The mailing address of the customer.
         */
        address1?: string;
        /**
         * An additional field for the customer's mailing address.
         */
        address2?: string;
        /**
         * The city the customer is located in.
         */
        city?: string;
        /**
         * The customer's country.
         */
        country?: string;
        /**
         * The two-letter code for the customer's country.
         */
        country_code?: string;
        /**
         * The customer's postal or zip code.
         */
        postal_code?: string;
        /**
         * The customer's state name or normalized province.
         */
        province?: string;
        /**
         * The two-letter code for the customer's province or state.
         */
        province_code?: string;
      };
      /**
       * The customer's company.
       */
      company?: string;
      /**
       * The customer's first name.
       */
      first_name?: string;
      /**
       * The customer's last name.
       */
      last_name?: string;
      /**
       * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
       */
      opt_in_status?: boolean;
    };
    /**
     * An array of the cart's line items.
     */
    lines?: Array<{
      /**
       * The price of a cart line item.
       */
      price?: number;
      /**
       * A unique identifier for the product associated with the cart line item.
       */
      product_id?: string;
      /**
       * A unique identifier for the product variant associated with the cart line item.
       */
      product_variant_id?: string;
      /**
       * The quantity of a cart line item.
       */
      quantity?: number;
    }>;
    /**
     * The order total for the cart.
     */
    order_total?: number;
    /**
     * The total tax for the cart.
     */
    tax_total?: number;
  };
  path: {
    /**
     * The id for the cart.
     */
    cart_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PatchEcommerceStoresIdCartsIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * A string that uniquely identifies the campaign associated with a cart.
   */
  campaign_id?: string;
  /**
   * The URL for the cart. This parameter is required for [Abandoned Cart](https://mailchimp.com/help/create-an-abandoned-cart-email/) automations.
   */
  checkout_url?: string;
  /**
   * The date and time the cart was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * The three-letter ISO 4217 code for the currency that the cart uses.
   */
  currency_code?: string;
  /**
   * Information about a specific customer.
   */
  customer?: {
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The customer's address.
     */
    address?: {
      /**
       * The mailing address of the customer.
       */
      address1?: string;
      /**
       * An additional field for the customer's mailing address.
       */
      address2?: string;
      /**
       * The city the customer is located in.
       */
      city?: string;
      /**
       * The customer's country.
       */
      country?: string;
      /**
       * The two-letter code for the customer's country.
       */
      country_code?: string;
      /**
       * The customer's postal or zip code.
       */
      postal_code?: string;
      /**
       * The customer's state name or normalized province.
       */
      province?: string;
      /**
       * The two-letter code for the customer's province or state.
       */
      province_code?: string;
    };
    /**
     * The customer's company.
     */
    company?: string;
    /**
     * The date and time the customer was created in ISO 8601 format.
     */
    readonly created_at?: string;
    /**
     * The customer's email address.
     */
    readonly email_address?: string;
    /**
     * The customer's first name.
     */
    first_name?: string;
    /**
     * A unique identifier for the customer.
     */
    readonly id?: string;
    /**
     * The customer's last name.
     */
    last_name?: string;
    /**
     * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
     */
    opt_in_status?: boolean;
    /**
     * The customer's total order count.
     */
    readonly orders_count?: number;
    /**
     * The total amount the customer has spent.
     */
    readonly total_spent?: number;
    /**
     * The date and time the customer was last updated in ISO 8601 format.
     */
    readonly updated_at?: string;
  };
  /**
   * A unique identifier for the cart.
   */
  readonly id?: string;
  /**
   * An array of the cart's line items.
   */
  lines?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * A unique identifier for the cart line item.
     */
    readonly id?: string;
    /**
     * The price of a cart line item.
     */
    price?: number;
    /**
     * A unique identifier for the product associated with the cart line item.
     */
    product_id?: string;
    /**
     * The name of the product for the cart line item.
     */
    readonly product_title?: string;
    /**
     * A unique identifier for the product variant associated with the cart line item.
     */
    product_variant_id?: string;
    /**
     * The name of the product variant for the cart line item.
     */
    readonly product_variant_title?: string;
    /**
     * The quantity of a cart line item.
     */
    quantity?: number;
  }>;
  /**
   * The order total for the cart.
   */
  order_total?: number;
  /**
   * The total tax for the cart.
   */
  tax_total?: number;
  /**
   * The date and time the cart was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
};

export type PatchEcommerceStoresIdCartsIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdCartsIdLinesData = {
  path: {
    /**
     * The id for the cart.
     */
    cart_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
  };
};

export type GetEcommerceStoresIdCartsIdLinesResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The cart id.
   */
  cart_id?: string;
  /**
   * An array of objects, each representing a cart's line item.
   */
  lines?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * A unique identifier for the cart line item.
     */
    readonly id?: string;
    /**
     * The price of a cart line item.
     */
    price?: number;
    /**
     * A unique identifier for the product associated with the cart line item.
     */
    product_id?: string;
    /**
     * The name of the product for the cart line item.
     */
    readonly product_title?: string;
    /**
     * A unique identifier for the product variant associated with the cart line item.
     */
    product_variant_id?: string;
    /**
     * The name of the product variant for the cart line item.
     */
    readonly product_variant_title?: string;
    /**
     * The quantity of a cart line item.
     */
    quantity?: number;
  }>;
  /**
   * The store id.
   */
  store_id?: string;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetEcommerceStoresIdCartsIdLinesError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostEcommerceStoresIdCartsIdLinesData = {
  body: {
    /**
     * A unique identifier for the cart line item.
     */
    id: string;
    /**
     * The price of a cart line item.
     */
    price: number;
    /**
     * A unique identifier for the product associated with the cart line item.
     */
    product_id: string;
    /**
     * A unique identifier for the product variant associated with the cart line item.
     */
    product_variant_id: string;
    /**
     * The quantity of a cart line item.
     */
    quantity: number;
  };
  path: {
    /**
     * The id for the cart.
     */
    cart_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PostEcommerceStoresIdCartsIdLinesResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * A unique identifier for the cart line item.
   */
  readonly id?: string;
  /**
   * The price of a cart line item.
   */
  price?: number;
  /**
   * A unique identifier for the product associated with the cart line item.
   */
  product_id?: string;
  /**
   * The name of the product for the cart line item.
   */
  readonly product_title?: string;
  /**
   * A unique identifier for the product variant associated with the cart line item.
   */
  product_variant_id?: string;
  /**
   * The name of the product variant for the cart line item.
   */
  readonly product_variant_title?: string;
  /**
   * The quantity of a cart line item.
   */
  quantity?: number;
};

export type PostEcommerceStoresIdCartsIdLinesError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type DeleteEcommerceStoresIdCartsLinesIdData = {
  path: {
    /**
     * The id for the cart.
     */
    cart_id: string;
    /**
     * The id for the line item of a cart.
     */
    line_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type DeleteEcommerceStoresIdCartsLinesIdResponse = any;

export type DeleteEcommerceStoresIdCartsLinesIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdCartsIdLinesIdData = {
  path: {
    /**
     * The id for the cart.
     */
    cart_id: string;
    /**
     * The id for the line item of a cart.
     */
    line_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetEcommerceStoresIdCartsIdLinesIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * A unique identifier for the cart line item.
   */
  readonly id?: string;
  /**
   * The price of a cart line item.
   */
  price?: number;
  /**
   * A unique identifier for the product associated with the cart line item.
   */
  product_id?: string;
  /**
   * The name of the product for the cart line item.
   */
  readonly product_title?: string;
  /**
   * A unique identifier for the product variant associated with the cart line item.
   */
  product_variant_id?: string;
  /**
   * The name of the product variant for the cart line item.
   */
  readonly product_variant_title?: string;
  /**
   * The quantity of a cart line item.
   */
  quantity?: number;
};

export type GetEcommerceStoresIdCartsIdLinesIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PatchEcommerceStoresIdCartsIdLinesIdData = {
  body: {
    /**
     * The price of a cart line item.
     */
    price?: number;
    /**
     * A unique identifier for the product associated with the cart line item.
     */
    product_id?: string;
    /**
     * A unique identifier for the product variant associated with the cart line item.
     */
    product_variant_id?: string;
    /**
     * The quantity of a cart line item.
     */
    quantity?: number;
  };
  path: {
    /**
     * The id for the cart.
     */
    cart_id: string;
    /**
     * The id for the line item of a cart.
     */
    line_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PatchEcommerceStoresIdCartsIdLinesIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * A unique identifier for the cart line item.
   */
  readonly id?: string;
  /**
   * The price of a cart line item.
   */
  price?: number;
  /**
   * A unique identifier for the product associated with the cart line item.
   */
  product_id?: string;
  /**
   * The name of the product for the cart line item.
   */
  readonly product_title?: string;
  /**
   * A unique identifier for the product variant associated with the cart line item.
   */
  product_variant_id?: string;
  /**
   * The name of the product variant for the cart line item.
   */
  readonly product_variant_title?: string;
  /**
   * The quantity of a cart line item.
   */
  quantity?: number;
};

export type PatchEcommerceStoresIdCartsIdLinesIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdCustomersData = {
  path: {
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * Restrict the response to customers with the email address.
     */
    email_address?: string;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
  };
};

export type GetEcommerceStoresIdCustomersResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of objects, each representing a customer of a store.
   */
  customers?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The customer's address.
     */
    address?: {
      /**
       * The mailing address of the customer.
       */
      address1?: string;
      /**
       * An additional field for the customer's mailing address.
       */
      address2?: string;
      /**
       * The city the customer is located in.
       */
      city?: string;
      /**
       * The customer's country.
       */
      country?: string;
      /**
       * The two-letter code for the customer's country.
       */
      country_code?: string;
      /**
       * The customer's postal or zip code.
       */
      postal_code?: string;
      /**
       * The customer's state name or normalized province.
       */
      province?: string;
      /**
       * The two-letter code for the customer's province or state.
       */
      province_code?: string;
    };
    /**
     * The customer's company.
     */
    company?: string;
    /**
     * The date and time the customer was created in ISO 8601 format.
     */
    readonly created_at?: string;
    /**
     * The customer's email address.
     */
    readonly email_address?: string;
    /**
     * The customer's first name.
     */
    first_name?: string;
    /**
     * A unique identifier for the customer.
     */
    readonly id?: string;
    /**
     * The customer's last name.
     */
    last_name?: string;
    /**
     * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
     */
    opt_in_status?: boolean;
    /**
     * The customer's total order count.
     */
    readonly orders_count?: number;
    /**
     * The total amount the customer has spent.
     */
    readonly total_spent?: number;
    /**
     * The date and time the customer was last updated in ISO 8601 format.
     */
    readonly updated_at?: string;
  }>;
  /**
   * The store id.
   */
  store_id?: string;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetEcommerceStoresIdCustomersError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostEcommerceStoresIdCustomersData = {
  body: {
    /**
     * The customer's address.
     */
    address?: {
      /**
       * The mailing address of the customer.
       */
      address1?: string;
      /**
       * An additional field for the customer's mailing address.
       */
      address2?: string;
      /**
       * The city the customer is located in.
       */
      city?: string;
      /**
       * The customer's country.
       */
      country?: string;
      /**
       * The two-letter code for the customer's country.
       */
      country_code?: string;
      /**
       * The customer's postal or zip code.
       */
      postal_code?: string;
      /**
       * The customer's state name or normalized province.
       */
      province?: string;
      /**
       * The two-letter code for the customer's province or state.
       */
      province_code?: string;
    };
    /**
     * The customer's company.
     */
    company?: string;
    /**
     * The customer's email address.
     */
    email_address: string;
    /**
     * The customer's first name.
     */
    first_name?: string;
    /**
     * A unique identifier for the customer. Limited to 50 characters.
     */
    id: string;
    /**
     * The customer's last name.
     */
    last_name?: string;
    /**
     * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
     */
    opt_in_status: boolean;
  };
  path: {
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PostEcommerceStoresIdCustomersResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The customer's address.
   */
  address?: {
    /**
     * The mailing address of the customer.
     */
    address1?: string;
    /**
     * An additional field for the customer's mailing address.
     */
    address2?: string;
    /**
     * The city the customer is located in.
     */
    city?: string;
    /**
     * The customer's country.
     */
    country?: string;
    /**
     * The two-letter code for the customer's country.
     */
    country_code?: string;
    /**
     * The customer's postal or zip code.
     */
    postal_code?: string;
    /**
     * The customer's state name or normalized province.
     */
    province?: string;
    /**
     * The two-letter code for the customer's province or state.
     */
    province_code?: string;
  };
  /**
   * The customer's company.
   */
  company?: string;
  /**
   * The date and time the customer was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * The customer's email address.
   */
  readonly email_address?: string;
  /**
   * The customer's first name.
   */
  first_name?: string;
  /**
   * A unique identifier for the customer.
   */
  readonly id?: string;
  /**
   * The customer's last name.
   */
  last_name?: string;
  /**
   * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
   */
  opt_in_status?: boolean;
  /**
   * The customer's total order count.
   */
  readonly orders_count?: number;
  /**
   * The total amount the customer has spent.
   */
  readonly total_spent?: number;
  /**
   * The date and time the customer was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
};

export type PostEcommerceStoresIdCustomersError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type DeleteEcommerceStoresIdCustomersIdData = {
  path: {
    /**
     * The id for the customer of a store.
     */
    customer_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type DeleteEcommerceStoresIdCustomersIdResponse = any;

export type DeleteEcommerceStoresIdCustomersIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdCustomersIdData = {
  path: {
    /**
     * The id for the customer of a store.
     */
    customer_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetEcommerceStoresIdCustomersIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The customer's address.
   */
  address?: {
    /**
     * The mailing address of the customer.
     */
    address1?: string;
    /**
     * An additional field for the customer's mailing address.
     */
    address2?: string;
    /**
     * The city the customer is located in.
     */
    city?: string;
    /**
     * The customer's country.
     */
    country?: string;
    /**
     * The two-letter code for the customer's country.
     */
    country_code?: string;
    /**
     * The customer's postal or zip code.
     */
    postal_code?: string;
    /**
     * The customer's state name or normalized province.
     */
    province?: string;
    /**
     * The two-letter code for the customer's province or state.
     */
    province_code?: string;
  };
  /**
   * The customer's company.
   */
  company?: string;
  /**
   * The date and time the customer was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * The customer's email address.
   */
  readonly email_address?: string;
  /**
   * The customer's first name.
   */
  first_name?: string;
  /**
   * A unique identifier for the customer.
   */
  readonly id?: string;
  /**
   * The customer's last name.
   */
  last_name?: string;
  /**
   * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
   */
  opt_in_status?: boolean;
  /**
   * The customer's total order count.
   */
  readonly orders_count?: number;
  /**
   * The total amount the customer has spent.
   */
  readonly total_spent?: number;
  /**
   * The date and time the customer was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
};

export type GetEcommerceStoresIdCustomersIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PatchEcommerceStoresIdCustomersIdData = {
  body: {
    /**
     * The customer's address.
     */
    address?: {
      /**
       * The mailing address of the customer.
       */
      address1?: string;
      /**
       * An additional field for the customer's mailing address.
       */
      address2?: string;
      /**
       * The city the customer is located in.
       */
      city?: string;
      /**
       * The customer's country.
       */
      country?: string;
      /**
       * The two-letter code for the customer's country.
       */
      country_code?: string;
      /**
       * The customer's postal or zip code.
       */
      postal_code?: string;
      /**
       * The customer's state name or normalized province.
       */
      province?: string;
      /**
       * The two-letter code for the customer's province or state.
       */
      province_code?: string;
    };
    /**
     * The customer's company.
     */
    company?: string;
    /**
     * The customer's first name.
     */
    first_name?: string;
    /**
     * The customer's last name.
     */
    last_name?: string;
    /**
     * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
     */
    opt_in_status?: boolean;
  };
  path: {
    /**
     * The id for the customer of a store.
     */
    customer_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PatchEcommerceStoresIdCustomersIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The customer's address.
   */
  address?: {
    /**
     * The mailing address of the customer.
     */
    address1?: string;
    /**
     * An additional field for the customer's mailing address.
     */
    address2?: string;
    /**
     * The city the customer is located in.
     */
    city?: string;
    /**
     * The customer's country.
     */
    country?: string;
    /**
     * The two-letter code for the customer's country.
     */
    country_code?: string;
    /**
     * The customer's postal or zip code.
     */
    postal_code?: string;
    /**
     * The customer's state name or normalized province.
     */
    province?: string;
    /**
     * The two-letter code for the customer's province or state.
     */
    province_code?: string;
  };
  /**
   * The customer's company.
   */
  company?: string;
  /**
   * The date and time the customer was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * The customer's email address.
   */
  readonly email_address?: string;
  /**
   * The customer's first name.
   */
  first_name?: string;
  /**
   * A unique identifier for the customer.
   */
  readonly id?: string;
  /**
   * The customer's last name.
   */
  last_name?: string;
  /**
   * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
   */
  opt_in_status?: boolean;
  /**
   * The customer's total order count.
   */
  readonly orders_count?: number;
  /**
   * The total amount the customer has spent.
   */
  readonly total_spent?: number;
  /**
   * The date and time the customer was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
};

export type PatchEcommerceStoresIdCustomersIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PutEcommerceStoresIdCustomersIdData = {
  body: {
    /**
     * The customer's address.
     */
    address?: {
      /**
       * The mailing address of the customer.
       */
      address1?: string;
      /**
       * An additional field for the customer's mailing address.
       */
      address2?: string;
      /**
       * The city the customer is located in.
       */
      city?: string;
      /**
       * The customer's country.
       */
      country?: string;
      /**
       * The two-letter code for the customer's country.
       */
      country_code?: string;
      /**
       * The customer's postal or zip code.
       */
      postal_code?: string;
      /**
       * The customer's state name or normalized province.
       */
      province?: string;
      /**
       * The two-letter code for the customer's province or state.
       */
      province_code?: string;
    };
    /**
     * The customer's company.
     */
    company?: string;
    /**
     * The customer's email address.
     */
    email_address: string;
    /**
     * The customer's first name.
     */
    first_name?: string;
    /**
     * A unique identifier for the customer. Limited to 50 characters.
     */
    id: string;
    /**
     * The customer's last name.
     */
    last_name?: string;
    /**
     * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
     */
    opt_in_status: boolean;
  };
  path: {
    /**
     * The id for the customer of a store.
     */
    customer_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PutEcommerceStoresIdCustomersIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The customer's address.
   */
  address?: {
    /**
     * The mailing address of the customer.
     */
    address1?: string;
    /**
     * An additional field for the customer's mailing address.
     */
    address2?: string;
    /**
     * The city the customer is located in.
     */
    city?: string;
    /**
     * The customer's country.
     */
    country?: string;
    /**
     * The two-letter code for the customer's country.
     */
    country_code?: string;
    /**
     * The customer's postal or zip code.
     */
    postal_code?: string;
    /**
     * The customer's state name or normalized province.
     */
    province?: string;
    /**
     * The two-letter code for the customer's province or state.
     */
    province_code?: string;
  };
  /**
   * The customer's company.
   */
  company?: string;
  /**
   * The date and time the customer was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * The customer's email address.
   */
  readonly email_address?: string;
  /**
   * The customer's first name.
   */
  first_name?: string;
  /**
   * A unique identifier for the customer.
   */
  readonly id?: string;
  /**
   * The customer's last name.
   */
  last_name?: string;
  /**
   * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
   */
  opt_in_status?: boolean;
  /**
   * The customer's total order count.
   */
  readonly orders_count?: number;
  /**
   * The total amount the customer has spent.
   */
  readonly total_spent?: number;
  /**
   * The date and time the customer was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
};

export type PutEcommerceStoresIdCustomersIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdOrdersData = {
  path: {
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * Restrict results to orders with a specific `campaign_id` value.
     */
    campaign_id?: string;
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * Restrict results to orders made by a specific customer.
     */
    customer_id?: string;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Restrict results to orders that have an outreach attached. For example, an email campaign or Facebook ad.
     */
    has_outreach?: boolean;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
    /**
     * Restrict results to orders with a specific `outreach_id` value.
     */
    outreach_id?: string;
  };
};

export type GetEcommerceStoresIdOrdersResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of objects, each representing an order in a store.
   */
  orders?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The billing address for the order.
     */
    billing_address?: {
      /**
       * The billing address for the order.
       */
      address1?: string;
      /**
       * An additional field for the billing address.
       */
      address2?: string;
      /**
       * The city in the billing address.
       */
      city?: string;
      /**
       * The company associated with the billing address.
       */
      company?: string;
      /**
       * The country in the billing address.
       */
      country?: string;
      /**
       * The two-letter code for the country in the billing address.
       */
      country_code?: string;
      /**
       * The latitude for the billing address location.
       */
      latitude?: number;
      /**
       * The longitude for the billing address location.
       */
      longitude?: number;
      /**
       * The name associated with an order's billing address.
       */
      name?: string;
      /**
       * The phone number for the billing address.
       */
      phone?: string;
      /**
       * The postal or zip code in the billing address.
       */
      postal_code?: string;
      /**
       * The state or normalized province in the billing address.
       */
      province?: string;
      /**
       * The two-letter code for the province or state in the billing address.
       */
      province_code?: string;
    };
    /**
     * A string that uniquely identifies the campaign associated with an order.
     */
    campaign_id?: string;
    /**
     * The date and time the order was cancelled in ISO 8601 format.
     */
    cancelled_at_foreign?: string;
    /**
     * The three-letter ISO 4217 code for the currency that the store accepts.
     */
    currency_code?: string;
    /**
     * Information about a specific customer.
     */
    customer?: {
      /**
       * A list of link types and descriptions for the API schema documents.
       */
      readonly _links?: Array<{
        /**
         * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
         */
        readonly href?: string;
        /**
         * The HTTP method that should be used when accessing the URL defined in 'href'.
         */
        readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
        /**
         * As with an HTML 'rel' attribute, this describes the type of link.
         */
        readonly rel?: string;
        /**
         * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
         */
        readonly schema?: string;
        /**
         * For GETs, this is a URL representing the schema that the response should conform to.
         */
        readonly targetSchema?: string;
      }>;
      /**
       * The customer's address.
       */
      address?: {
        /**
         * The mailing address of the customer.
         */
        address1?: string;
        /**
         * An additional field for the customer's mailing address.
         */
        address2?: string;
        /**
         * The city the customer is located in.
         */
        city?: string;
        /**
         * The customer's country.
         */
        country?: string;
        /**
         * The two-letter code for the customer's country.
         */
        country_code?: string;
        /**
         * The customer's postal or zip code.
         */
        postal_code?: string;
        /**
         * The customer's state name or normalized province.
         */
        province?: string;
        /**
         * The two-letter code for the customer's province or state.
         */
        province_code?: string;
      };
      /**
       * The customer's company.
       */
      company?: string;
      /**
       * The date and time the customer was created in ISO 8601 format.
       */
      readonly created_at?: string;
      /**
       * The customer's email address.
       */
      readonly email_address?: string;
      /**
       * The customer's first name.
       */
      first_name?: string;
      /**
       * A unique identifier for the customer.
       */
      readonly id?: string;
      /**
       * The customer's last name.
       */
      last_name?: string;
      /**
       * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
       */
      opt_in_status?: boolean;
      /**
       * The customer's total order count.
       */
      readonly orders_count?: number;
      /**
       * The total amount the customer has spent.
       */
      readonly total_spent?: number;
      /**
       * The date and time the customer was last updated in ISO 8601 format.
       */
      readonly updated_at?: string;
    };
    /**
     * The total amount of the discounts to be applied to the price of the order.
     */
    discount_total?: number;
    /**
     * The order status. Use this parameter to trigger [Order Notifications](https://mailchimp.com/developer/marketing/docs/e-commerce/#order-notifications).
     */
    financial_status?: string;
    /**
     * The fulfillment status for the order. Use this parameter to trigger [Order Notifications](https://mailchimp.com/developer/marketing/docs/e-commerce/#order-notifications).
     */
    fulfillment_status?: string;
    /**
     * A unique identifier for the order.
     */
    readonly id?: string;
    /**
     * The URL for the page where the buyer landed when entering the shop.
     */
    landing_site?: string;
    /**
     * An array of the order's line items.
     */
    lines?: Array<{
      /**
       * A list of link types and descriptions for the API schema documents.
       */
      readonly _links?: Array<{
        /**
         * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
         */
        readonly href?: string;
        /**
         * The HTTP method that should be used when accessing the URL defined in 'href'.
         */
        readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
        /**
         * As with an HTML 'rel' attribute, this describes the type of link.
         */
        readonly rel?: string;
        /**
         * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
         */
        readonly schema?: string;
        /**
         * For GETs, this is a URL representing the schema that the response should conform to.
         */
        readonly targetSchema?: string;
      }>;
      /**
       * The total discount amount applied to a line item.
       */
      discount?: number;
      /**
       * A unique identifier for an order line item.
       */
      readonly id?: string;
      /**
       * The image URL for a product.
       */
      readonly image_url?: string;
      /**
       * The order line item price.
       */
      price?: number;
      /**
       * A unique identifier for the product associated with an order line item.
       */
      product_id?: string;
      /**
       * The name of the product for an order line item.
       */
      readonly product_title?: string;
      /**
       * A unique identifier for the product variant associated with an order line item.
       */
      product_variant_id?: string;
      /**
       * The name of the product variant for an order line item.
       */
      readonly product_variant_title?: string;
      /**
       * The order line item quantity.
       */
      quantity?: number;
    }>;
    /**
     * The order total associated with an order.
     */
    order_total?: number;
    /**
     * The URL for the order.
     */
    order_url?: string;
    /**
     * The outreach associated with this order. For example, an email campaign or Facebook ad.
     */
    outreach?: {
      /**
       * A unique identifier for the outreach. Can be an email campaign ID.
       */
      id?: string;
      /**
       * The name for the outreach.
       */
      readonly name?: string;
      /**
       * The date and time the Outreach was published in ISO 8601 format.
       */
      readonly published_time?: string;
      /**
       * The type of the outreach.
       */
      readonly type?: string;
    };
    /**
     * The date and time the order was processed in ISO 8601 format.
     */
    processed_at_foreign?: string;
    /**
     * The promo codes applied on the order
     */
    promos?: Array<{
      /**
       * The amount of discount applied on the total price. For example if the total cost was $100 and the customer paid $95.5, amount_discounted will be 4.5 For free shipping set amount_discounted to 0
       */
      amount_discounted?: number;
      /**
       * The Promo Code
       */
      code?: string;
      /**
       * Type of discount. For free shipping set type to fixed
       */
      type?: 'fixed' | 'percentage';
    }>;
    /**
     * The shipping address for the order.
     */
    shipping_address?: {
      /**
       * The shipping address for the order.
       */
      address1?: string;
      /**
       * An additional field for the shipping address.
       */
      address2?: string;
      /**
       * The city in the order's shipping address.
       */
      city?: string;
      /**
       * The company associated with an order's shipping address.
       */
      company?: string;
      /**
       * The country in the order's shipping address.
       */
      country?: string;
      /**
       * The two-letter code for the country in the shipping address.
       */
      country_code?: string;
      /**
       * The latitude for the shipping address location.
       */
      latitude?: number;
      /**
       * The longitude for the shipping address location.
       */
      longitude?: number;
      /**
       * The name associated with an order's shipping address.
       */
      name?: string;
      /**
       * The phone number for the order's shipping address
       */
      phone?: string;
      /**
       * The postal or zip code in the order's shipping address.
       */
      postal_code?: string;
      /**
       * The state or normalized province in the order's shipping address.
       */
      province?: string;
      /**
       * The two-letter code for the province or state the order's shipping address is located in.
       */
      province_code?: string;
    };
    /**
     * The shipping total for the order.
     */
    shipping_total?: number;
    /**
     * The unique identifier for the store.
     */
    readonly store_id?: string;
    /**
     * The tax total associated with an order.
     */
    tax_total?: number;
    /**
     * The tracking carrier associated with the order.
     */
    tracking_carrier?: string;
    /**
     * The Mailchimp tracking code for the order. Uses the 'mc_tc' parameter in E-Commerce tracking URLs.
     */
    tracking_code?: 'prec';
    /**
     * The tracking number associated with the order.
     */
    tracking_number?: string;
    /**
     * The tracking URL associated with the order.
     */
    tracking_url?: string;
    /**
     * The date and time the order was updated in ISO 8601 format.
     */
    updated_at_foreign?: string;
  }>;
  /**
   * The unique identifier for the store.
   */
  store_id?: string;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetEcommerceStoresIdOrdersError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostEcommerceStoresIdOrdersData = {
  body: {
    /**
     * The billing address for the order.
     */
    billing_address?: {
      /**
       * The billing address for the order.
       */
      address1?: string;
      /**
       * An additional field for the billing address.
       */
      address2?: string;
      /**
       * The city in the billing address.
       */
      city?: string;
      /**
       * The company associated with the billing address.
       */
      company?: string;
      /**
       * The country in the billing address.
       */
      country?: string;
      /**
       * The two-letter code for the country in the billing address.
       */
      country_code?: string;
      /**
       * The latitude for the billing address location.
       */
      latitude?: number;
      /**
       * The longitude for the billing address location.
       */
      longitude?: number;
      /**
       * The name associated with the billing address.
       */
      name?: string;
      /**
       * The phone number for the billing address
       */
      phone?: string;
      /**
       * The postal or zip code in the billing address.
       */
      postal_code?: string;
      /**
       * The state or normalized province in the billing address.
       */
      province?: string;
      /**
       * The two-letter code for the province in the billing address.
       */
      province_code?: string;
    };
    /**
     * A string that uniquely identifies the campaign for an order.
     */
    campaign_id?: string;
    /**
     * The date and time the order was cancelled in ISO 8601 format. Note: passing a value for this parameter will cancel the order being created.
     */
    cancelled_at_foreign?: string;
    /**
     * The three-letter ISO 4217 code for the currency that the store accepts.
     */
    currency_code: string;
    /**
     * Information about a specific customer. For existing customers include only the `id` parameter in the `customer` object body.
     */
    customer: {
      /**
       * The customer's address.
       */
      address?: {
        /**
         * The mailing address of the customer.
         */
        address1?: string;
        /**
         * An additional field for the customer's mailing address.
         */
        address2?: string;
        /**
         * The city the customer is located in.
         */
        city?: string;
        /**
         * The customer's country.
         */
        country?: string;
        /**
         * The two-letter code for the customer's country.
         */
        country_code?: string;
        /**
         * The customer's postal or zip code.
         */
        postal_code?: string;
        /**
         * The customer's state name or normalized province.
         */
        province?: string;
        /**
         * The two-letter code for the customer's province or state.
         */
        province_code?: string;
      };
      /**
       * The customer's company.
       */
      company?: string;
      /**
       * The customer's email address.
       */
      email_address?: string;
      /**
       * The customer's first name.
       */
      first_name?: string;
      /**
       * A unique identifier for the customer. Limited to 50 characters.
       */
      id: string;
      /**
       * The customer's last name.
       */
      last_name?: string;
      /**
       * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
       */
      opt_in_status?: boolean;
    };
    /**
     * The total amount of the discounts to be applied to the price of the order.
     */
    discount_total?: number;
    /**
     * The order status. Use this parameter to trigger [Order Notifications](https://mailchimp.com/developer/marketing/docs/e-commerce/#order-notifications).
     */
    financial_status?: string;
    /**
     * The fulfillment status for the order. Use this parameter to trigger [Order Notifications](https://mailchimp.com/developer/marketing/docs/e-commerce/#order-notifications).
     */
    fulfillment_status?: string;
    /**
     * A unique identifier for the order.
     */
    id: string;
    /**
     * The URL for the page where the buyer landed when entering the shop.
     */
    landing_site?: string;
    /**
     * An array of the order's line items.
     */
    lines: Array<{
      /**
       * The total discount amount applied to this line item.
       */
      discount?: number;
      /**
       * A unique identifier for the order line item.
       */
      id: string;
      /**
       * The price of an order line item.
       */
      price: number;
      /**
       * A unique identifier for the product associated with the order line item.
       */
      product_id: string;
      /**
       * A unique identifier for the product variant associated with the order line item.
       */
      product_variant_id: string;
      /**
       * The quantity of an order line item.
       */
      quantity: number;
    }>;
    /**
     * The total for the order.
     */
    order_total: number;
    /**
     * The URL for the order.
     */
    order_url?: string;
    /**
     * The outreach associated with this order. For example, an email campaign or Facebook ad.
     */
    outreach?: {
      /**
       * A unique identifier for the outreach. Can be an email campaign ID.
       */
      id?: string;
    };
    /**
     * The date and time the order was processed in ISO 8601 format.
     */
    processed_at_foreign?: string;
    /**
     * The promo codes applied on the order
     */
    promos?: Array<{
      /**
       * The amount of discount applied on the total price. For example if the total cost was $100 and the customer paid $95.5, amount_discounted will be 4.5 For free shipping set amount_discounted to 0
       */
      amount_discounted: number;
      /**
       * The Promo Code
       */
      code: string;
      /**
       * Type of discount. For free shipping set type to fixed
       */
      type: 'fixed' | 'percentage';
    }>;
    /**
     * The shipping address for the order.
     */
    shipping_address?: {
      /**
       * The shipping address for the order.
       */
      address1?: string;
      /**
       * An additional field for the shipping address.
       */
      address2?: string;
      /**
       * The city in the order's shipping address.
       */
      city?: string;
      /**
       * The company associated with the shipping address.
       */
      company?: string;
      /**
       * The country in the shipping address.
       */
      country?: string;
      /**
       * The two-letter code for the country in the shipping address.
       */
      country_code?: string;
      /**
       * The latitude for the shipping address location.
       */
      latitude?: number;
      /**
       * The longitude for the shipping address location.
       */
      longitude?: number;
      /**
       * The name associated with an order's shipping address.
       */
      name?: string;
      /**
       * The phone number for the order's shipping address.
       */
      phone?: string;
      /**
       * The postal or zip code in the shipping address.
       */
      postal_code?: string;
      /**
       * The state or normalized province in the order's shipping address.
       */
      province?: string;
      /**
       * The two-letter code for the province or state in the shipping address.
       */
      province_code?: string;
    };
    /**
     * The shipping total for the order.
     */
    shipping_total?: number;
    /**
     * The tax total for the order.
     */
    tax_total?: number;
    /**
     * The tracking carrier associated with the order.
     */
    tracking_carrier?: string;
    /**
     * The Mailchimp tracking code for the order. Uses the 'mc_tc' parameter in E-Commerce tracking URLs.
     */
    tracking_code?: 'prec';
    /**
     * The tracking number associated with the order.
     */
    tracking_number?: string;
    /**
     * The tracking URL associated with the order.
     */
    tracking_url?: string;
    /**
     * The date and time the order was updated in ISO 8601 format.
     */
    updated_at_foreign?: string;
  };
  path: {
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PostEcommerceStoresIdOrdersResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The billing address for the order.
   */
  billing_address?: {
    /**
     * The billing address for the order.
     */
    address1?: string;
    /**
     * An additional field for the billing address.
     */
    address2?: string;
    /**
     * The city in the billing address.
     */
    city?: string;
    /**
     * The company associated with the billing address.
     */
    company?: string;
    /**
     * The country in the billing address.
     */
    country?: string;
    /**
     * The two-letter code for the country in the billing address.
     */
    country_code?: string;
    /**
     * The latitude for the billing address location.
     */
    latitude?: number;
    /**
     * The longitude for the billing address location.
     */
    longitude?: number;
    /**
     * The name associated with an order's billing address.
     */
    name?: string;
    /**
     * The phone number for the billing address.
     */
    phone?: string;
    /**
     * The postal or zip code in the billing address.
     */
    postal_code?: string;
    /**
     * The state or normalized province in the billing address.
     */
    province?: string;
    /**
     * The two-letter code for the province or state in the billing address.
     */
    province_code?: string;
  };
  /**
   * A string that uniquely identifies the campaign associated with an order.
   */
  campaign_id?: string;
  /**
   * The date and time the order was cancelled in ISO 8601 format.
   */
  cancelled_at_foreign?: string;
  /**
   * The three-letter ISO 4217 code for the currency that the store accepts.
   */
  currency_code?: string;
  /**
   * Information about a specific customer.
   */
  customer?: {
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The customer's address.
     */
    address?: {
      /**
       * The mailing address of the customer.
       */
      address1?: string;
      /**
       * An additional field for the customer's mailing address.
       */
      address2?: string;
      /**
       * The city the customer is located in.
       */
      city?: string;
      /**
       * The customer's country.
       */
      country?: string;
      /**
       * The two-letter code for the customer's country.
       */
      country_code?: string;
      /**
       * The customer's postal or zip code.
       */
      postal_code?: string;
      /**
       * The customer's state name or normalized province.
       */
      province?: string;
      /**
       * The two-letter code for the customer's province or state.
       */
      province_code?: string;
    };
    /**
     * The customer's company.
     */
    company?: string;
    /**
     * The date and time the customer was created in ISO 8601 format.
     */
    readonly created_at?: string;
    /**
     * The customer's email address.
     */
    readonly email_address?: string;
    /**
     * The customer's first name.
     */
    first_name?: string;
    /**
     * A unique identifier for the customer.
     */
    readonly id?: string;
    /**
     * The customer's last name.
     */
    last_name?: string;
    /**
     * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
     */
    opt_in_status?: boolean;
    /**
     * The customer's total order count.
     */
    readonly orders_count?: number;
    /**
     * The total amount the customer has spent.
     */
    readonly total_spent?: number;
    /**
     * The date and time the customer was last updated in ISO 8601 format.
     */
    readonly updated_at?: string;
  };
  /**
   * The total amount of the discounts to be applied to the price of the order.
   */
  discount_total?: number;
  /**
   * The order status. Use this parameter to trigger [Order Notifications](https://mailchimp.com/developer/marketing/docs/e-commerce/#order-notifications).
   */
  financial_status?: string;
  /**
   * The fulfillment status for the order. Use this parameter to trigger [Order Notifications](https://mailchimp.com/developer/marketing/docs/e-commerce/#order-notifications).
   */
  fulfillment_status?: string;
  /**
   * A unique identifier for the order.
   */
  readonly id?: string;
  /**
   * The URL for the page where the buyer landed when entering the shop.
   */
  landing_site?: string;
  /**
   * An array of the order's line items.
   */
  lines?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The total discount amount applied to a line item.
     */
    discount?: number;
    /**
     * A unique identifier for an order line item.
     */
    readonly id?: string;
    /**
     * The image URL for a product.
     */
    readonly image_url?: string;
    /**
     * The order line item price.
     */
    price?: number;
    /**
     * A unique identifier for the product associated with an order line item.
     */
    product_id?: string;
    /**
     * The name of the product for an order line item.
     */
    readonly product_title?: string;
    /**
     * A unique identifier for the product variant associated with an order line item.
     */
    product_variant_id?: string;
    /**
     * The name of the product variant for an order line item.
     */
    readonly product_variant_title?: string;
    /**
     * The order line item quantity.
     */
    quantity?: number;
  }>;
  /**
   * The order total associated with an order.
   */
  order_total?: number;
  /**
   * The URL for the order.
   */
  order_url?: string;
  /**
   * The outreach associated with this order. For example, an email campaign or Facebook ad.
   */
  outreach?: {
    /**
     * A unique identifier for the outreach. Can be an email campaign ID.
     */
    id?: string;
    /**
     * The name for the outreach.
     */
    readonly name?: string;
    /**
     * The date and time the Outreach was published in ISO 8601 format.
     */
    readonly published_time?: string;
    /**
     * The type of the outreach.
     */
    readonly type?: string;
  };
  /**
   * The date and time the order was processed in ISO 8601 format.
   */
  processed_at_foreign?: string;
  /**
   * The promo codes applied on the order
   */
  promos?: Array<{
    /**
     * The amount of discount applied on the total price. For example if the total cost was $100 and the customer paid $95.5, amount_discounted will be 4.5 For free shipping set amount_discounted to 0
     */
    amount_discounted?: number;
    /**
     * The Promo Code
     */
    code?: string;
    /**
     * Type of discount. For free shipping set type to fixed
     */
    type?: 'fixed' | 'percentage';
  }>;
  /**
   * The shipping address for the order.
   */
  shipping_address?: {
    /**
     * The shipping address for the order.
     */
    address1?: string;
    /**
     * An additional field for the shipping address.
     */
    address2?: string;
    /**
     * The city in the order's shipping address.
     */
    city?: string;
    /**
     * The company associated with an order's shipping address.
     */
    company?: string;
    /**
     * The country in the order's shipping address.
     */
    country?: string;
    /**
     * The two-letter code for the country in the shipping address.
     */
    country_code?: string;
    /**
     * The latitude for the shipping address location.
     */
    latitude?: number;
    /**
     * The longitude for the shipping address location.
     */
    longitude?: number;
    /**
     * The name associated with an order's shipping address.
     */
    name?: string;
    /**
     * The phone number for the order's shipping address
     */
    phone?: string;
    /**
     * The postal or zip code in the order's shipping address.
     */
    postal_code?: string;
    /**
     * The state or normalized province in the order's shipping address.
     */
    province?: string;
    /**
     * The two-letter code for the province or state the order's shipping address is located in.
     */
    province_code?: string;
  };
  /**
   * The shipping total for the order.
   */
  shipping_total?: number;
  /**
   * The unique identifier for the store.
   */
  readonly store_id?: string;
  /**
   * The tax total associated with an order.
   */
  tax_total?: number;
  /**
   * The tracking carrier associated with the order.
   */
  tracking_carrier?: string;
  /**
   * The Mailchimp tracking code for the order. Uses the 'mc_tc' parameter in E-Commerce tracking URLs.
   */
  tracking_code?: 'prec';
  /**
   * The tracking number associated with the order.
   */
  tracking_number?: string;
  /**
   * The tracking URL associated with the order.
   */
  tracking_url?: string;
  /**
   * The date and time the order was updated in ISO 8601 format.
   */
  updated_at_foreign?: string;
};

export type PostEcommerceStoresIdOrdersError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type DeleteEcommerceStoresIdOrdersIdData = {
  path: {
    /**
     * The id for the order in a store.
     */
    order_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type DeleteEcommerceStoresIdOrdersIdResponse = any;

export type DeleteEcommerceStoresIdOrdersIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdOrdersIdData = {
  path: {
    /**
     * The id for the order in a store.
     */
    order_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetEcommerceStoresIdOrdersIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The billing address for the order.
   */
  billing_address?: {
    /**
     * The billing address for the order.
     */
    address1?: string;
    /**
     * An additional field for the billing address.
     */
    address2?: string;
    /**
     * The city in the billing address.
     */
    city?: string;
    /**
     * The company associated with the billing address.
     */
    company?: string;
    /**
     * The country in the billing address.
     */
    country?: string;
    /**
     * The two-letter code for the country in the billing address.
     */
    country_code?: string;
    /**
     * The latitude for the billing address location.
     */
    latitude?: number;
    /**
     * The longitude for the billing address location.
     */
    longitude?: number;
    /**
     * The name associated with an order's billing address.
     */
    name?: string;
    /**
     * The phone number for the billing address.
     */
    phone?: string;
    /**
     * The postal or zip code in the billing address.
     */
    postal_code?: string;
    /**
     * The state or normalized province in the billing address.
     */
    province?: string;
    /**
     * The two-letter code for the province or state in the billing address.
     */
    province_code?: string;
  };
  /**
   * A string that uniquely identifies the campaign associated with an order.
   */
  campaign_id?: string;
  /**
   * The date and time the order was cancelled in ISO 8601 format.
   */
  cancelled_at_foreign?: string;
  /**
   * The three-letter ISO 4217 code for the currency that the store accepts.
   */
  currency_code?: string;
  /**
   * Information about a specific customer.
   */
  customer?: {
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The customer's address.
     */
    address?: {
      /**
       * The mailing address of the customer.
       */
      address1?: string;
      /**
       * An additional field for the customer's mailing address.
       */
      address2?: string;
      /**
       * The city the customer is located in.
       */
      city?: string;
      /**
       * The customer's country.
       */
      country?: string;
      /**
       * The two-letter code for the customer's country.
       */
      country_code?: string;
      /**
       * The customer's postal or zip code.
       */
      postal_code?: string;
      /**
       * The customer's state name or normalized province.
       */
      province?: string;
      /**
       * The two-letter code for the customer's province or state.
       */
      province_code?: string;
    };
    /**
     * The customer's company.
     */
    company?: string;
    /**
     * The date and time the customer was created in ISO 8601 format.
     */
    readonly created_at?: string;
    /**
     * The customer's email address.
     */
    readonly email_address?: string;
    /**
     * The customer's first name.
     */
    first_name?: string;
    /**
     * A unique identifier for the customer.
     */
    readonly id?: string;
    /**
     * The customer's last name.
     */
    last_name?: string;
    /**
     * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
     */
    opt_in_status?: boolean;
    /**
     * The customer's total order count.
     */
    readonly orders_count?: number;
    /**
     * The total amount the customer has spent.
     */
    readonly total_spent?: number;
    /**
     * The date and time the customer was last updated in ISO 8601 format.
     */
    readonly updated_at?: string;
  };
  /**
   * The total amount of the discounts to be applied to the price of the order.
   */
  discount_total?: number;
  /**
   * The order status. Use this parameter to trigger [Order Notifications](https://mailchimp.com/developer/marketing/docs/e-commerce/#order-notifications).
   */
  financial_status?: string;
  /**
   * The fulfillment status for the order. Use this parameter to trigger [Order Notifications](https://mailchimp.com/developer/marketing/docs/e-commerce/#order-notifications).
   */
  fulfillment_status?: string;
  /**
   * A unique identifier for the order.
   */
  readonly id?: string;
  /**
   * The URL for the page where the buyer landed when entering the shop.
   */
  landing_site?: string;
  /**
   * An array of the order's line items.
   */
  lines?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The total discount amount applied to a line item.
     */
    discount?: number;
    /**
     * A unique identifier for an order line item.
     */
    readonly id?: string;
    /**
     * The image URL for a product.
     */
    readonly image_url?: string;
    /**
     * The order line item price.
     */
    price?: number;
    /**
     * A unique identifier for the product associated with an order line item.
     */
    product_id?: string;
    /**
     * The name of the product for an order line item.
     */
    readonly product_title?: string;
    /**
     * A unique identifier for the product variant associated with an order line item.
     */
    product_variant_id?: string;
    /**
     * The name of the product variant for an order line item.
     */
    readonly product_variant_title?: string;
    /**
     * The order line item quantity.
     */
    quantity?: number;
  }>;
  /**
   * The order total associated with an order.
   */
  order_total?: number;
  /**
   * The URL for the order.
   */
  order_url?: string;
  /**
   * The outreach associated with this order. For example, an email campaign or Facebook ad.
   */
  outreach?: {
    /**
     * A unique identifier for the outreach. Can be an email campaign ID.
     */
    id?: string;
    /**
     * The name for the outreach.
     */
    readonly name?: string;
    /**
     * The date and time the Outreach was published in ISO 8601 format.
     */
    readonly published_time?: string;
    /**
     * The type of the outreach.
     */
    readonly type?: string;
  };
  /**
   * The date and time the order was processed in ISO 8601 format.
   */
  processed_at_foreign?: string;
  /**
   * The promo codes applied on the order
   */
  promos?: Array<{
    /**
     * The amount of discount applied on the total price. For example if the total cost was $100 and the customer paid $95.5, amount_discounted will be 4.5 For free shipping set amount_discounted to 0
     */
    amount_discounted?: number;
    /**
     * The Promo Code
     */
    code?: string;
    /**
     * Type of discount. For free shipping set type to fixed
     */
    type?: 'fixed' | 'percentage';
  }>;
  /**
   * The shipping address for the order.
   */
  shipping_address?: {
    /**
     * The shipping address for the order.
     */
    address1?: string;
    /**
     * An additional field for the shipping address.
     */
    address2?: string;
    /**
     * The city in the order's shipping address.
     */
    city?: string;
    /**
     * The company associated with an order's shipping address.
     */
    company?: string;
    /**
     * The country in the order's shipping address.
     */
    country?: string;
    /**
     * The two-letter code for the country in the shipping address.
     */
    country_code?: string;
    /**
     * The latitude for the shipping address location.
     */
    latitude?: number;
    /**
     * The longitude for the shipping address location.
     */
    longitude?: number;
    /**
     * The name associated with an order's shipping address.
     */
    name?: string;
    /**
     * The phone number for the order's shipping address
     */
    phone?: string;
    /**
     * The postal or zip code in the order's shipping address.
     */
    postal_code?: string;
    /**
     * The state or normalized province in the order's shipping address.
     */
    province?: string;
    /**
     * The two-letter code for the province or state the order's shipping address is located in.
     */
    province_code?: string;
  };
  /**
   * The shipping total for the order.
   */
  shipping_total?: number;
  /**
   * The unique identifier for the store.
   */
  readonly store_id?: string;
  /**
   * The tax total associated with an order.
   */
  tax_total?: number;
  /**
   * The tracking carrier associated with the order.
   */
  tracking_carrier?: string;
  /**
   * The Mailchimp tracking code for the order. Uses the 'mc_tc' parameter in E-Commerce tracking URLs.
   */
  tracking_code?: 'prec';
  /**
   * The tracking number associated with the order.
   */
  tracking_number?: string;
  /**
   * The tracking URL associated with the order.
   */
  tracking_url?: string;
  /**
   * The date and time the order was updated in ISO 8601 format.
   */
  updated_at_foreign?: string;
};

export type GetEcommerceStoresIdOrdersIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PatchEcommerceStoresIdOrdersIdData = {
  body: {
    /**
     * The billing address for the order.
     */
    billing_address?: {
      /**
       * The billing address for the order.
       */
      address1?: string;
      /**
       * An additional field for the billing address.
       */
      address2?: string;
      /**
       * The city in the billing address.
       */
      city?: string;
      /**
       * The company associated with the billing address.
       */
      company?: string;
      /**
       * The country in the billing address.
       */
      country?: string;
      /**
       * The two-letter code for the country in the billing address.
       */
      country_code?: string;
      /**
       * The latitude for the billing address location.
       */
      latitude?: number;
      /**
       * The longitude for the billing address location.
       */
      longitude?: number;
      /**
       * The name associated with an order's billing address.
       */
      name?: string;
      /**
       * The phone number for the billing address.
       */
      phone?: string;
      /**
       * The postal or zip code in the billing address.
       */
      postal_code?: string;
      /**
       * The state or normalized province in the billing address.
       */
      province?: string;
      /**
       * The two-letter code for the province or state in the billing address.
       */
      province_code?: string;
    };
    /**
     * A string that uniquely identifies the campaign associated with an order.
     */
    campaign_id?: string;
    /**
     * The date and time the order was cancelled in ISO 8601 format. Note: passing a value for this parameter will cancel the order being edited.
     */
    cancelled_at_foreign?: string;
    /**
     * The three-letter ISO 4217 code for the currency that the store accepts.
     */
    currency_code?: string;
    /**
     * Information about a specific customer. Orders for existing customers should include only the `id` parameter in the `customer` object body.
     */
    customer?: {
      /**
       * The customer's address.
       */
      address?: {
        /**
         * The mailing address of the customer.
         */
        address1?: string;
        /**
         * An additional field for the customer's mailing address.
         */
        address2?: string;
        /**
         * The city the customer is located in.
         */
        city?: string;
        /**
         * The customer's country.
         */
        country?: string;
        /**
         * The two-letter code for the customer's country.
         */
        country_code?: string;
        /**
         * The customer's postal or zip code.
         */
        postal_code?: string;
        /**
         * The customer's state name or normalized province.
         */
        province?: string;
        /**
         * The two-letter code for the customer's province or state.
         */
        province_code?: string;
      };
      /**
       * The customer's company.
       */
      company?: string;
      /**
       * The customer's first name.
       */
      first_name?: string;
      /**
       * The customer's last name.
       */
      last_name?: string;
      /**
       * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
       */
      opt_in_status?: boolean;
    };
    /**
     * The total amount of the discounts to be applied to the price of the order.
     */
    discount_total?: number;
    /**
     * The order status. Use this parameter to trigger [Order Notifications](https://mailchimp.com/developer/marketing/docs/e-commerce/#order-notifications).
     */
    financial_status?: string;
    /**
     * The fulfillment status for the order. Use this parameter to trigger [Order Notifications](https://mailchimp.com/developer/marketing/docs/e-commerce/#order-notifications).
     */
    fulfillment_status?: string;
    /**
     * The URL for the page where the buyer landed when entering the shop.
     */
    landing_site?: string;
    /**
     * An array of the order's line items.
     */
    lines?: Array<{
      /**
       * The total discount amount applied to this line item.
       */
      discount?: number;
      /**
       * The price of an order line item.
       */
      price?: number;
      /**
       * A unique identifier for the product associated with the order line item.
       */
      product_id?: string;
      /**
       * A unique identifier for the product variant associated with the order line item.
       */
      product_variant_id?: string;
      /**
       * The quantity of an order line item.
       */
      quantity?: number;
    }>;
    /**
     * The order total associated with an order.
     */
    order_total?: number;
    /**
     * The URL for the order.
     */
    order_url?: string;
    /**
     * The outreach associated with this order. For example, an email campaign or Facebook ad.
     */
    outreach?: {
      /**
       * A unique identifier for the outreach. Can be an email campaign ID.
       */
      id?: string;
    };
    /**
     * The date and time the order was processed in ISO 8601 format.
     */
    processed_at_foreign?: string;
    /**
     * The promo codes applied on the order. Note: Patch will completely replace the value of promos with the new one provided.
     */
    promos?: Array<{
      /**
       * The amount of discount applied on the total price. For example if the total cost was $100 and the customer paid $95.5, amount_discounted will be 4.5 For free shipping set amount_discounted to 0
       */
      amount_discounted: number;
      /**
       * The Promo Code
       */
      code: string;
      /**
       * Type of discount. For free shipping set type to fixed
       */
      type: 'fixed' | 'percentage';
    }>;
    /**
     * The shipping address for the order.
     */
    shipping_address?: {
      /**
       * The shipping address for the order.
       */
      address1?: string;
      /**
       * An additional field for the shipping address.
       */
      address2?: string;
      /**
       * The city in the order's shipping address.
       */
      city?: string;
      /**
       * The company associated with an order's shipping address.
       */
      company?: string;
      /**
       * The country in the order's shipping address.
       */
      country?: string;
      /**
       * The two-letter code for the country in the shipping address.
       */
      country_code?: string;
      /**
       * The latitude for the shipping address location.
       */
      latitude?: number;
      /**
       * The longitude for the shipping address location.
       */
      longitude?: number;
      /**
       * The name associated with an order's shipping address.
       */
      name?: string;
      /**
       * The phone number for the order's shipping address
       */
      phone?: string;
      /**
       * The postal or zip code in the order's shipping address.
       */
      postal_code?: string;
      /**
       * The state or normalized province in the order's shipping address.
       */
      province?: string;
      /**
       * The two-letter code for the province or state the order's shipping address is located in.
       */
      province_code?: string;
    };
    /**
     * The shipping total for the order.
     */
    shipping_total?: number;
    /**
     * The tax total associated with an order.
     */
    tax_total?: number;
    /**
     * The tracking carrier associated with the order.
     */
    tracking_carrier?: string;
    /**
     * The Mailchimp tracking code for the order. Uses the 'mc_tc' parameter in E-Commerce tracking URLs.
     */
    tracking_code?: 'prec';
    /**
     * The tracking number associated with the order.
     */
    tracking_number?: string;
    /**
     * The tracking URL associated with the order.
     */
    tracking_url?: string;
    /**
     * The date and time the order was updated in ISO 8601 format.
     */
    updated_at_foreign?: string;
  };
  path: {
    /**
     * The id for the order in a store.
     */
    order_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PatchEcommerceStoresIdOrdersIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The billing address for the order.
   */
  billing_address?: {
    /**
     * The billing address for the order.
     */
    address1?: string;
    /**
     * An additional field for the billing address.
     */
    address2?: string;
    /**
     * The city in the billing address.
     */
    city?: string;
    /**
     * The company associated with the billing address.
     */
    company?: string;
    /**
     * The country in the billing address.
     */
    country?: string;
    /**
     * The two-letter code for the country in the billing address.
     */
    country_code?: string;
    /**
     * The latitude for the billing address location.
     */
    latitude?: number;
    /**
     * The longitude for the billing address location.
     */
    longitude?: number;
    /**
     * The name associated with an order's billing address.
     */
    name?: string;
    /**
     * The phone number for the billing address.
     */
    phone?: string;
    /**
     * The postal or zip code in the billing address.
     */
    postal_code?: string;
    /**
     * The state or normalized province in the billing address.
     */
    province?: string;
    /**
     * The two-letter code for the province or state in the billing address.
     */
    province_code?: string;
  };
  /**
   * A string that uniquely identifies the campaign associated with an order.
   */
  campaign_id?: string;
  /**
   * The date and time the order was cancelled in ISO 8601 format.
   */
  cancelled_at_foreign?: string;
  /**
   * The three-letter ISO 4217 code for the currency that the store accepts.
   */
  currency_code?: string;
  /**
   * Information about a specific customer.
   */
  customer?: {
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The customer's address.
     */
    address?: {
      /**
       * The mailing address of the customer.
       */
      address1?: string;
      /**
       * An additional field for the customer's mailing address.
       */
      address2?: string;
      /**
       * The city the customer is located in.
       */
      city?: string;
      /**
       * The customer's country.
       */
      country?: string;
      /**
       * The two-letter code for the customer's country.
       */
      country_code?: string;
      /**
       * The customer's postal or zip code.
       */
      postal_code?: string;
      /**
       * The customer's state name or normalized province.
       */
      province?: string;
      /**
       * The two-letter code for the customer's province or state.
       */
      province_code?: string;
    };
    /**
     * The customer's company.
     */
    company?: string;
    /**
     * The date and time the customer was created in ISO 8601 format.
     */
    readonly created_at?: string;
    /**
     * The customer's email address.
     */
    readonly email_address?: string;
    /**
     * The customer's first name.
     */
    first_name?: string;
    /**
     * A unique identifier for the customer.
     */
    readonly id?: string;
    /**
     * The customer's last name.
     */
    last_name?: string;
    /**
     * The customer's opt-in status. This value will never overwrite the opt-in status of a pre-existing Mailchimp list member, but will apply to list members that are added through the e-commerce API endpoints. Customers who don't opt in to your Mailchimp list [will be added as `Transactional` members](https://mailchimp.com/developer/marketing/docs/e-commerce/#customers).
     */
    opt_in_status?: boolean;
    /**
     * The customer's total order count.
     */
    readonly orders_count?: number;
    /**
     * The total amount the customer has spent.
     */
    readonly total_spent?: number;
    /**
     * The date and time the customer was last updated in ISO 8601 format.
     */
    readonly updated_at?: string;
  };
  /**
   * The total amount of the discounts to be applied to the price of the order.
   */
  discount_total?: number;
  /**
   * The order status. Use this parameter to trigger [Order Notifications](https://mailchimp.com/developer/marketing/docs/e-commerce/#order-notifications).
   */
  financial_status?: string;
  /**
   * The fulfillment status for the order. Use this parameter to trigger [Order Notifications](https://mailchimp.com/developer/marketing/docs/e-commerce/#order-notifications).
   */
  fulfillment_status?: string;
  /**
   * A unique identifier for the order.
   */
  readonly id?: string;
  /**
   * The URL for the page where the buyer landed when entering the shop.
   */
  landing_site?: string;
  /**
   * An array of the order's line items.
   */
  lines?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The total discount amount applied to a line item.
     */
    discount?: number;
    /**
     * A unique identifier for an order line item.
     */
    readonly id?: string;
    /**
     * The image URL for a product.
     */
    readonly image_url?: string;
    /**
     * The order line item price.
     */
    price?: number;
    /**
     * A unique identifier for the product associated with an order line item.
     */
    product_id?: string;
    /**
     * The name of the product for an order line item.
     */
    readonly product_title?: string;
    /**
     * A unique identifier for the product variant associated with an order line item.
     */
    product_variant_id?: string;
    /**
     * The name of the product variant for an order line item.
     */
    readonly product_variant_title?: string;
    /**
     * The order line item quantity.
     */
    quantity?: number;
  }>;
  /**
   * The order total associated with an order.
   */
  order_total?: number;
  /**
   * The URL for the order.
   */
  order_url?: string;
  /**
   * The outreach associated with this order. For example, an email campaign or Facebook ad.
   */
  outreach?: {
    /**
     * A unique identifier for the outreach. Can be an email campaign ID.
     */
    id?: string;
    /**
     * The name for the outreach.
     */
    readonly name?: string;
    /**
     * The date and time the Outreach was published in ISO 8601 format.
     */
    readonly published_time?: string;
    /**
     * The type of the outreach.
     */
    readonly type?: string;
  };
  /**
   * The date and time the order was processed in ISO 8601 format.
   */
  processed_at_foreign?: string;
  /**
   * The promo codes applied on the order
   */
  promos?: Array<{
    /**
     * The amount of discount applied on the total price. For example if the total cost was $100 and the customer paid $95.5, amount_discounted will be 4.5 For free shipping set amount_discounted to 0
     */
    amount_discounted?: number;
    /**
     * The Promo Code
     */
    code?: string;
    /**
     * Type of discount. For free shipping set type to fixed
     */
    type?: 'fixed' | 'percentage';
  }>;
  /**
   * The shipping address for the order.
   */
  shipping_address?: {
    /**
     * The shipping address for the order.
     */
    address1?: string;
    /**
     * An additional field for the shipping address.
     */
    address2?: string;
    /**
     * The city in the order's shipping address.
     */
    city?: string;
    /**
     * The company associated with an order's shipping address.
     */
    company?: string;
    /**
     * The country in the order's shipping address.
     */
    country?: string;
    /**
     * The two-letter code for the country in the shipping address.
     */
    country_code?: string;
    /**
     * The latitude for the shipping address location.
     */
    latitude?: number;
    /**
     * The longitude for the shipping address location.
     */
    longitude?: number;
    /**
     * The name associated with an order's shipping address.
     */
    name?: string;
    /**
     * The phone number for the order's shipping address
     */
    phone?: string;
    /**
     * The postal or zip code in the order's shipping address.
     */
    postal_code?: string;
    /**
     * The state or normalized province in the order's shipping address.
     */
    province?: string;
    /**
     * The two-letter code for the province or state the order's shipping address is located in.
     */
    province_code?: string;
  };
  /**
   * The shipping total for the order.
   */
  shipping_total?: number;
  /**
   * The unique identifier for the store.
   */
  readonly store_id?: string;
  /**
   * The tax total associated with an order.
   */
  tax_total?: number;
  /**
   * The tracking carrier associated with the order.
   */
  tracking_carrier?: string;
  /**
   * The Mailchimp tracking code for the order. Uses the 'mc_tc' parameter in E-Commerce tracking URLs.
   */
  tracking_code?: 'prec';
  /**
   * The tracking number associated with the order.
   */
  tracking_number?: string;
  /**
   * The tracking URL associated with the order.
   */
  tracking_url?: string;
  /**
   * The date and time the order was updated in ISO 8601 format.
   */
  updated_at_foreign?: string;
};

export type PatchEcommerceStoresIdOrdersIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdOrdersIdLinesData = {
  path: {
    /**
     * The id for the order in a store.
     */
    order_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
  };
};

export type GetEcommerceStoresIdOrdersIdLinesResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of objects, each representing an order's line item.
   */
  lines?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The total discount amount applied to a line item.
     */
    discount?: number;
    /**
     * A unique identifier for an order line item.
     */
    readonly id?: string;
    /**
     * The image URL for a product.
     */
    readonly image_url?: string;
    /**
     * The order line item price.
     */
    price?: number;
    /**
     * A unique identifier for the product associated with an order line item.
     */
    product_id?: string;
    /**
     * The name of the product for an order line item.
     */
    readonly product_title?: string;
    /**
     * A unique identifier for the product variant associated with an order line item.
     */
    product_variant_id?: string;
    /**
     * The name of the product variant for an order line item.
     */
    readonly product_variant_title?: string;
    /**
     * The order line item quantity.
     */
    quantity?: number;
  }>;
  /**
   * The order id.
   */
  order_id?: string;
  /**
   * The store id.
   */
  store_id?: string;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetEcommerceStoresIdOrdersIdLinesError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostEcommerceStoresIdOrdersIdLinesData = {
  body: {
    /**
     * The total discount amount applied to this line item.
     */
    discount?: number;
    /**
     * A unique identifier for the order line item.
     */
    id: string;
    /**
     * The price of an order line item.
     */
    price: number;
    /**
     * A unique identifier for the product associated with the order line item.
     */
    product_id: string;
    /**
     * A unique identifier for the product variant associated with the order line item.
     */
    product_variant_id: string;
    /**
     * The quantity of an order line item.
     */
    quantity: number;
  };
  path: {
    /**
     * The id for the order in a store.
     */
    order_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PostEcommerceStoresIdOrdersIdLinesResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The total discount amount applied to a line item.
   */
  discount?: number;
  /**
   * A unique identifier for an order line item.
   */
  readonly id?: string;
  /**
   * The image URL for a product.
   */
  readonly image_url?: string;
  /**
   * The order line item price.
   */
  price?: number;
  /**
   * A unique identifier for the product associated with an order line item.
   */
  product_id?: string;
  /**
   * The name of the product for an order line item.
   */
  readonly product_title?: string;
  /**
   * A unique identifier for the product variant associated with an order line item.
   */
  product_variant_id?: string;
  /**
   * The name of the product variant for an order line item.
   */
  readonly product_variant_title?: string;
  /**
   * The order line item quantity.
   */
  quantity?: number;
};

export type PostEcommerceStoresIdOrdersIdLinesError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type DeleteEcommerceStoresIdOrdersIdLinesIdData = {
  path: {
    /**
     * The id for the line item of an order.
     */
    line_id: string;
    /**
     * The id for the order in a store.
     */
    order_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type DeleteEcommerceStoresIdOrdersIdLinesIdResponse = any;

export type DeleteEcommerceStoresIdOrdersIdLinesIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdOrdersIdLinesIdData = {
  path: {
    /**
     * The id for the line item of an order.
     */
    line_id: string;
    /**
     * The id for the order in a store.
     */
    order_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetEcommerceStoresIdOrdersIdLinesIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The total discount amount applied to a line item.
   */
  discount?: number;
  /**
   * A unique identifier for an order line item.
   */
  readonly id?: string;
  /**
   * The image URL for a product.
   */
  readonly image_url?: string;
  /**
   * The order line item price.
   */
  price?: number;
  /**
   * A unique identifier for the product associated with an order line item.
   */
  product_id?: string;
  /**
   * The name of the product for an order line item.
   */
  readonly product_title?: string;
  /**
   * A unique identifier for the product variant associated with an order line item.
   */
  product_variant_id?: string;
  /**
   * The name of the product variant for an order line item.
   */
  readonly product_variant_title?: string;
  /**
   * The order line item quantity.
   */
  quantity?: number;
};

export type GetEcommerceStoresIdOrdersIdLinesIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PatchEcommerceStoresIdOrdersIdLinesIdData = {
  body: {
    /**
     * The total discount amount applied to this line item.
     */
    discount?: number;
    /**
     * The price of an order line item.
     */
    price?: number;
    /**
     * A unique identifier for the product associated with the order line item.
     */
    product_id?: string;
    /**
     * A unique identifier for the product variant associated with the order line item.
     */
    product_variant_id?: string;
    /**
     * The quantity of an order line item.
     */
    quantity?: number;
  };
  path: {
    /**
     * The id for the line item of an order.
     */
    line_id: string;
    /**
     * The id for the order in a store.
     */
    order_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PatchEcommerceStoresIdOrdersIdLinesIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The total discount amount applied to a line item.
   */
  discount?: number;
  /**
   * A unique identifier for an order line item.
   */
  readonly id?: string;
  /**
   * The image URL for a product.
   */
  readonly image_url?: string;
  /**
   * The order line item price.
   */
  price?: number;
  /**
   * A unique identifier for the product associated with an order line item.
   */
  product_id?: string;
  /**
   * The name of the product for an order line item.
   */
  readonly product_title?: string;
  /**
   * A unique identifier for the product variant associated with an order line item.
   */
  product_variant_id?: string;
  /**
   * The name of the product variant for an order line item.
   */
  readonly product_variant_title?: string;
  /**
   * The order line item quantity.
   */
  quantity?: number;
};

export type PatchEcommerceStoresIdOrdersIdLinesIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdProductsData = {
  path: {
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
  };
};

export type GetEcommerceStoresIdProductsResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of objects, each representing a store product.
   */
  products?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The currency code
     */
    readonly currency_code?: string;
    /**
     * The description of a product.
     */
    description?: string;
    /**
     * The handle of a product.
     */
    handle?: string;
    /**
     * A unique identifier for the product.
     */
    readonly id?: string;
    /**
     * The image URL for a product.
     */
    image_url?: string;
    /**
     * An array of the product's images.
     */
    images?: Array<{
      /**
       * A list of link types and descriptions for the API schema documents.
       */
      readonly _links?: Array<{
        /**
         * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
         */
        readonly href?: string;
        /**
         * The HTTP method that should be used when accessing the URL defined in 'href'.
         */
        readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
        /**
         * As with an HTML 'rel' attribute, this describes the type of link.
         */
        readonly rel?: string;
        /**
         * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
         */
        readonly schema?: string;
        /**
         * For GETs, this is a URL representing the schema that the response should conform to.
         */
        readonly targetSchema?: string;
      }>;
      /**
       * A unique identifier for the product image.
       */
      id?: string;
      /**
       * The URL for a product image.
       */
      url?: string;
      /**
       * The list of product variants using the image.
       */
      variant_ids?: Array<string>;
    }>;
    /**
     * The date and time the product was published in ISO 8601 format.
     */
    published_at_foreign?: string;
    /**
     * The title of a product.
     */
    title?: string;
    /**
     * The type of product.
     */
    type?: string;
    /**
     * The URL for a product.
     */
    url?: string;
    /**
     * Returns up to 50 of the product's variants. To retrieve all variants use [Product Variants](https://mailchimp.com/developer/marketing/api/ecommerce-product-variants/).
     */
    variants?: Array<{
      /**
       * A list of link types and descriptions for the API schema documents.
       */
      readonly _links?: Array<{
        /**
         * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
         */
        readonly href?: string;
        /**
         * The HTTP method that should be used when accessing the URL defined in 'href'.
         */
        readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
        /**
         * As with an HTML 'rel' attribute, this describes the type of link.
         */
        readonly rel?: string;
        /**
         * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
         */
        readonly schema?: string;
        /**
         * For GETs, this is a URL representing the schema that the response should conform to.
         */
        readonly targetSchema?: string;
      }>;
      /**
       * The backorders of a product variant.
       */
      backorders?: string;
      /**
       * The date and time the product was created in ISO 8601 format.
       */
      readonly created_at?: string;
      /**
       * A unique identifier for the product variant.
       */
      readonly id?: string;
      /**
       * The image URL for a product variant.
       */
      image_url?: string;
      /**
       * The inventory quantity of a product variant.
       */
      inventory_quantity?: number;
      /**
       * The price of a product variant.
       */
      price?: number;
      /**
       * The stock keeping unit (SKU) of a product variant.
       */
      sku?: string;
      /**
       * The title of a product variant.
       */
      title?: string;
      /**
       * The date and time the product was last updated in ISO 8601 format.
       */
      readonly updated_at?: string;
      /**
       * The URL for a product variant.
       */
      url?: string;
      /**
       * The visibility of a product variant.
       */
      visibility?: string;
    }>;
    /**
     * The vendor for a product.
     */
    vendor?: string;
  }>;
  /**
   * The store id.
   */
  store_id?: string;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetEcommerceStoresIdProductsError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostEcommerceStoresIdProductsData = {
  body: {
    /**
     * The description of a product.
     */
    description?: string;
    /**
     * The handle of a product.
     */
    handle?: string;
    /**
     * A unique identifier for the product.
     */
    id: string;
    /**
     * The image URL for a product.
     */
    image_url?: string;
    /**
     * An array of the product's images.
     */
    images?: Array<{
      /**
       * A unique identifier for the product image.
       */
      id: string;
      /**
       * The URL for a product image.
       */
      url: string;
      /**
       * The list of product variants using the image.
       */
      variant_ids?: Array<string>;
    }>;
    /**
     * The date and time the product was published.
     */
    published_at_foreign?: string;
    /**
     * The title of a product.
     */
    title: string;
    /**
     * The type of product.
     */
    type?: string;
    /**
     * The URL for a product.
     */
    url?: string;
    /**
     * An array of the product's variants. At least one variant is required for each product. A variant can use the same `id` and `title` as the parent product.
     */
    variants: Array<{
      /**
       * The backorders of a product variant.
       */
      backorders?: string;
      /**
       * A unique identifier for the product variant.
       */
      id: string;
      /**
       * The image URL for a product variant.
       */
      image_url?: string;
      /**
       * The inventory quantity of a product variant.
       */
      inventory_quantity?: number;
      /**
       * The price of a product variant.
       */
      price?: number;
      /**
       * The stock keeping unit (SKU) of a product variant.
       */
      sku?: string;
      /**
       * The title of a product variant.
       */
      title: string;
      /**
       * The URL for a product variant.
       */
      url?: string;
      /**
       * The visibility of a product variant.
       */
      visibility?: string;
    }>;
    /**
     * The vendor for a product.
     */
    vendor?: string;
  };
  path: {
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PostEcommerceStoresIdProductsResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The currency code
   */
  readonly currency_code?: string;
  /**
   * The description of a product.
   */
  description?: string;
  /**
   * The handle of a product.
   */
  handle?: string;
  /**
   * A unique identifier for the product.
   */
  readonly id?: string;
  /**
   * The image URL for a product.
   */
  image_url?: string;
  /**
   * An array of the product's images.
   */
  images?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * A unique identifier for the product image.
     */
    id?: string;
    /**
     * The URL for a product image.
     */
    url?: string;
    /**
     * The list of product variants using the image.
     */
    variant_ids?: Array<string>;
  }>;
  /**
   * The date and time the product was published in ISO 8601 format.
   */
  published_at_foreign?: string;
  /**
   * The title of a product.
   */
  title?: string;
  /**
   * The type of product.
   */
  type?: string;
  /**
   * The URL for a product.
   */
  url?: string;
  /**
   * Returns up to 50 of the product's variants. To retrieve all variants use [Product Variants](https://mailchimp.com/developer/marketing/api/ecommerce-product-variants/).
   */
  variants?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The backorders of a product variant.
     */
    backorders?: string;
    /**
     * The date and time the product was created in ISO 8601 format.
     */
    readonly created_at?: string;
    /**
     * A unique identifier for the product variant.
     */
    readonly id?: string;
    /**
     * The image URL for a product variant.
     */
    image_url?: string;
    /**
     * The inventory quantity of a product variant.
     */
    inventory_quantity?: number;
    /**
     * The price of a product variant.
     */
    price?: number;
    /**
     * The stock keeping unit (SKU) of a product variant.
     */
    sku?: string;
    /**
     * The title of a product variant.
     */
    title?: string;
    /**
     * The date and time the product was last updated in ISO 8601 format.
     */
    readonly updated_at?: string;
    /**
     * The URL for a product variant.
     */
    url?: string;
    /**
     * The visibility of a product variant.
     */
    visibility?: string;
  }>;
  /**
   * The vendor for a product.
   */
  vendor?: string;
};

export type PostEcommerceStoresIdProductsError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type DeleteEcommerceStoresIdProductsIdData = {
  path: {
    /**
     * The id for the product of a store.
     */
    product_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type DeleteEcommerceStoresIdProductsIdResponse = any;

export type DeleteEcommerceStoresIdProductsIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdProductsIdData = {
  path: {
    /**
     * The id for the product of a store.
     */
    product_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetEcommerceStoresIdProductsIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The currency code
   */
  readonly currency_code?: string;
  /**
   * The description of a product.
   */
  description?: string;
  /**
   * The handle of a product.
   */
  handle?: string;
  /**
   * A unique identifier for the product.
   */
  readonly id?: string;
  /**
   * The image URL for a product.
   */
  image_url?: string;
  /**
   * An array of the product's images.
   */
  images?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * A unique identifier for the product image.
     */
    id?: string;
    /**
     * The URL for a product image.
     */
    url?: string;
    /**
     * The list of product variants using the image.
     */
    variant_ids?: Array<string>;
  }>;
  /**
   * The date and time the product was published in ISO 8601 format.
   */
  published_at_foreign?: string;
  /**
   * The title of a product.
   */
  title?: string;
  /**
   * The type of product.
   */
  type?: string;
  /**
   * The URL for a product.
   */
  url?: string;
  /**
   * Returns up to 50 of the product's variants. To retrieve all variants use [Product Variants](https://mailchimp.com/developer/marketing/api/ecommerce-product-variants/).
   */
  variants?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The backorders of a product variant.
     */
    backorders?: string;
    /**
     * The date and time the product was created in ISO 8601 format.
     */
    readonly created_at?: string;
    /**
     * A unique identifier for the product variant.
     */
    readonly id?: string;
    /**
     * The image URL for a product variant.
     */
    image_url?: string;
    /**
     * The inventory quantity of a product variant.
     */
    inventory_quantity?: number;
    /**
     * The price of a product variant.
     */
    price?: number;
    /**
     * The stock keeping unit (SKU) of a product variant.
     */
    sku?: string;
    /**
     * The title of a product variant.
     */
    title?: string;
    /**
     * The date and time the product was last updated in ISO 8601 format.
     */
    readonly updated_at?: string;
    /**
     * The URL for a product variant.
     */
    url?: string;
    /**
     * The visibility of a product variant.
     */
    visibility?: string;
  }>;
  /**
   * The vendor for a product.
   */
  vendor?: string;
};

export type GetEcommerceStoresIdProductsIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PatchEcommerceStoresIdProductsIdData = {
  body: {
    /**
     * The description of a product.
     */
    description?: string;
    /**
     * The handle of a product.
     */
    handle?: string;
    /**
     * The image URL for a product.
     */
    image_url?: string;
    /**
     * An array of the product's images.
     */
    images?: Array<{
      /**
       * A unique identifier for the product image.
       */
      id?: string;
      /**
       * The URL for a product image.
       */
      url?: string;
      /**
       * The list of product variants using the image.
       */
      variant_ids?: Array<string>;
    }>;
    /**
     * The date and time the product was published in ISO 8601 format.
     */
    published_at_foreign?: string;
    /**
     * The title of a product.
     */
    title?: string;
    /**
     * The type of product.
     */
    type?: string;
    /**
     * The URL for a product.
     */
    url?: string;
    /**
     * An array of the product's variants. At least one variant is required for each product. A variant can use the same `id` and `title` as the parent product.
     */
    variants?: Array<{
      /**
       * The backorders of a product variant.
       */
      backorders?: string;
      /**
       * The image URL for a product variant.
       */
      image_url?: string;
      /**
       * The inventory quantity of a product variant.
       */
      inventory_quantity?: number;
      /**
       * The price of a product variant.
       */
      price?: number;
      /**
       * The stock keeping unit (SKU) of a product variant.
       */
      sku?: string;
      /**
       * The title of a product variant.
       */
      title?: string;
      /**
       * The URL for a product variant.
       */
      url?: string;
      /**
       * The visibility of a product variant.
       */
      visibility?: string;
    }>;
    /**
     * The vendor for a product.
     */
    vendor?: string;
  };
  path: {
    /**
     * The id for the product of a store.
     */
    product_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PatchEcommerceStoresIdProductsIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The currency code
   */
  readonly currency_code?: string;
  /**
   * The description of a product.
   */
  description?: string;
  /**
   * The handle of a product.
   */
  handle?: string;
  /**
   * A unique identifier for the product.
   */
  readonly id?: string;
  /**
   * The image URL for a product.
   */
  image_url?: string;
  /**
   * An array of the product's images.
   */
  images?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * A unique identifier for the product image.
     */
    id?: string;
    /**
     * The URL for a product image.
     */
    url?: string;
    /**
     * The list of product variants using the image.
     */
    variant_ids?: Array<string>;
  }>;
  /**
   * The date and time the product was published in ISO 8601 format.
   */
  published_at_foreign?: string;
  /**
   * The title of a product.
   */
  title?: string;
  /**
   * The type of product.
   */
  type?: string;
  /**
   * The URL for a product.
   */
  url?: string;
  /**
   * Returns up to 50 of the product's variants. To retrieve all variants use [Product Variants](https://mailchimp.com/developer/marketing/api/ecommerce-product-variants/).
   */
  variants?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The backorders of a product variant.
     */
    backorders?: string;
    /**
     * The date and time the product was created in ISO 8601 format.
     */
    readonly created_at?: string;
    /**
     * A unique identifier for the product variant.
     */
    readonly id?: string;
    /**
     * The image URL for a product variant.
     */
    image_url?: string;
    /**
     * The inventory quantity of a product variant.
     */
    inventory_quantity?: number;
    /**
     * The price of a product variant.
     */
    price?: number;
    /**
     * The stock keeping unit (SKU) of a product variant.
     */
    sku?: string;
    /**
     * The title of a product variant.
     */
    title?: string;
    /**
     * The date and time the product was last updated in ISO 8601 format.
     */
    readonly updated_at?: string;
    /**
     * The URL for a product variant.
     */
    url?: string;
    /**
     * The visibility of a product variant.
     */
    visibility?: string;
  }>;
  /**
   * The vendor for a product.
   */
  vendor?: string;
};

export type PatchEcommerceStoresIdProductsIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdProductsIdImagesData = {
  path: {
    /**
     * The id for the product of a store.
     */
    product_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
  };
};

export type GetEcommerceStoresIdProductsIdImagesResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of objects, each representing a product image resource.
   */
  images?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * A unique identifier for the product image.
     */
    id?: string;
    /**
     * The URL for a product image.
     */
    url?: string;
    /**
     * The list of product variants using the image.
     */
    variant_ids?: Array<string>;
  }>;
  /**
   * The product id.
   */
  product_id?: string;
  /**
   * The store id.
   */
  store_id?: string;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetEcommerceStoresIdProductsIdImagesError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostEcommerceStoresIdProductsIdImagesData = {
  body: {
    /**
     * A unique identifier for the product image.
     */
    id: string;
    /**
     * The URL for a product image.
     */
    url: string;
    /**
     * The list of product variants using the image.
     */
    variant_ids?: Array<string>;
  };
  path: {
    /**
     * The id for the product of a store.
     */
    product_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PostEcommerceStoresIdProductsIdImagesResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * A unique identifier for the product image.
   */
  id?: string;
  /**
   * The URL for a product image.
   */
  url?: string;
  /**
   * The list of product variants using the image.
   */
  variant_ids?: Array<string>;
};

export type PostEcommerceStoresIdProductsIdImagesError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type DeleteEcommerceStoresIdProductsIdImagesIdData = {
  path: {
    /**
     * The id for the product image.
     */
    image_id: string;
    /**
     * The id for the product of a store.
     */
    product_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type DeleteEcommerceStoresIdProductsIdImagesIdResponse = any;

export type DeleteEcommerceStoresIdProductsIdImagesIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdProductsIdImagesIdData = {
  path: {
    /**
     * The id for the product image.
     */
    image_id: string;
    /**
     * The id for the product of a store.
     */
    product_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetEcommerceStoresIdProductsIdImagesIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * A unique identifier for the product image.
   */
  id?: string;
  /**
   * The URL for a product image.
   */
  url?: string;
  /**
   * The list of product variants using the image.
   */
  variant_ids?: Array<string>;
};

export type GetEcommerceStoresIdProductsIdImagesIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PatchEcommerceStoresIdProductsIdImagesIdData = {
  body: {
    /**
     * A unique identifier for the product image.
     */
    id?: string;
    /**
     * The URL for a product image.
     */
    url?: string;
    /**
     * The list of product variants using the image.
     */
    variant_ids?: Array<string>;
  };
  path: {
    /**
     * The id for the product image.
     */
    image_id: string;
    /**
     * The id for the product of a store.
     */
    product_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PatchEcommerceStoresIdProductsIdImagesIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * A unique identifier for the product image.
   */
  id?: string;
  /**
   * The URL for a product image.
   */
  url?: string;
  /**
   * The list of product variants using the image.
   */
  variant_ids?: Array<string>;
};

export type PatchEcommerceStoresIdProductsIdImagesIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdProductsIdVariantsData = {
  path: {
    /**
     * The id for the product of a store.
     */
    product_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
  };
};

export type GetEcommerceStoresIdProductsIdVariantsResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The product id.
   */
  product_id?: string;
  /**
   * The store id.
   */
  store_id?: string;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
  /**
   * An array of objects, each representing a product's variants.
   */
  variants?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The backorders of a product variant.
     */
    backorders?: string;
    /**
     * The date and time the product was created in ISO 8601 format.
     */
    readonly created_at?: string;
    /**
     * A unique identifier for the product variant.
     */
    readonly id?: string;
    /**
     * The image URL for a product variant.
     */
    image_url?: string;
    /**
     * The inventory quantity of a product variant.
     */
    inventory_quantity?: number;
    /**
     * The price of a product variant.
     */
    price?: number;
    /**
     * The stock keeping unit (SKU) of a product variant.
     */
    sku?: string;
    /**
     * The title of a product variant.
     */
    title?: string;
    /**
     * The date and time the product was last updated in ISO 8601 format.
     */
    readonly updated_at?: string;
    /**
     * The URL for a product variant.
     */
    url?: string;
    /**
     * The visibility of a product variant.
     */
    visibility?: string;
  }>;
};

export type GetEcommerceStoresIdProductsIdVariantsError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostEcommerceStoresIdProductsIdVariantsData = {
  body: {
    /**
     * The backorders of a product variant.
     */
    backorders?: string;
    /**
     * A unique identifier for the product variant.
     */
    id: string;
    /**
     * The image URL for a product variant.
     */
    image_url?: string;
    /**
     * The inventory quantity of a product variant.
     */
    inventory_quantity?: number;
    /**
     * The price of a product variant.
     */
    price?: number;
    /**
     * The stock keeping unit (SKU) of a product variant.
     */
    sku?: string;
    /**
     * The title of a product variant.
     */
    title: string;
    /**
     * The URL for a product variant.
     */
    url?: string;
    /**
     * The visibility of a product variant.
     */
    visibility?: string;
  };
  path: {
    /**
     * The id for the product of a store.
     */
    product_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PostEcommerceStoresIdProductsIdVariantsResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The backorders of a product variant.
   */
  backorders?: string;
  /**
   * The date and time the product was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * A unique identifier for the product variant.
   */
  readonly id?: string;
  /**
   * The image URL for a product variant.
   */
  image_url?: string;
  /**
   * The inventory quantity of a product variant.
   */
  inventory_quantity?: number;
  /**
   * The price of a product variant.
   */
  price?: number;
  /**
   * The stock keeping unit (SKU) of a product variant.
   */
  sku?: string;
  /**
   * The title of a product variant.
   */
  title?: string;
  /**
   * The date and time the product was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
  /**
   * The URL for a product variant.
   */
  url?: string;
  /**
   * The visibility of a product variant.
   */
  visibility?: string;
};

export type PostEcommerceStoresIdProductsIdVariantsError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type DeleteEcommerceStoresIdProductsIdVariantsIdData = {
  path: {
    /**
     * The id for the product of a store.
     */
    product_id: string;
    /**
     * The store id.
     */
    store_id: string;
    /**
     * The id for the product variant.
     */
    variant_id: string;
  };
};

export type DeleteEcommerceStoresIdProductsIdVariantsIdResponse = any;

export type DeleteEcommerceStoresIdProductsIdVariantsIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdProductsIdVariantsIdData = {
  path: {
    /**
     * The id for the product of a store.
     */
    product_id: string;
    /**
     * The store id.
     */
    store_id: string;
    /**
     * The id for the product variant.
     */
    variant_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetEcommerceStoresIdProductsIdVariantsIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The backorders of a product variant.
   */
  backorders?: string;
  /**
   * The date and time the product was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * A unique identifier for the product variant.
   */
  readonly id?: string;
  /**
   * The image URL for a product variant.
   */
  image_url?: string;
  /**
   * The inventory quantity of a product variant.
   */
  inventory_quantity?: number;
  /**
   * The price of a product variant.
   */
  price?: number;
  /**
   * The stock keeping unit (SKU) of a product variant.
   */
  sku?: string;
  /**
   * The title of a product variant.
   */
  title?: string;
  /**
   * The date and time the product was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
  /**
   * The URL for a product variant.
   */
  url?: string;
  /**
   * The visibility of a product variant.
   */
  visibility?: string;
};

export type GetEcommerceStoresIdProductsIdVariantsIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PatchEcommerceStoresIdProductsIdVariantsIdData = {
  body: {
    /**
     * The backorders of a product variant.
     */
    backorders?: string;
    /**
     * The image URL for a product variant.
     */
    image_url?: string;
    /**
     * The inventory quantity of a product variant.
     */
    inventory_quantity?: number;
    /**
     * The price of a product variant.
     */
    price?: number;
    /**
     * The stock keeping unit (SKU) of a product variant.
     */
    sku?: string;
    /**
     * The title of a product variant.
     */
    title?: string;
    /**
     * The URL for a product variant.
     */
    url?: string;
    /**
     * The visibility of a product variant.
     */
    visibility?: string;
  };
  path: {
    /**
     * The id for the product of a store.
     */
    product_id: string;
    /**
     * The store id.
     */
    store_id: string;
    /**
     * The id for the product variant.
     */
    variant_id: string;
  };
};

export type PatchEcommerceStoresIdProductsIdVariantsIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The backorders of a product variant.
   */
  backorders?: string;
  /**
   * The date and time the product was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * A unique identifier for the product variant.
   */
  readonly id?: string;
  /**
   * The image URL for a product variant.
   */
  image_url?: string;
  /**
   * The inventory quantity of a product variant.
   */
  inventory_quantity?: number;
  /**
   * The price of a product variant.
   */
  price?: number;
  /**
   * The stock keeping unit (SKU) of a product variant.
   */
  sku?: string;
  /**
   * The title of a product variant.
   */
  title?: string;
  /**
   * The date and time the product was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
  /**
   * The URL for a product variant.
   */
  url?: string;
  /**
   * The visibility of a product variant.
   */
  visibility?: string;
};

export type PatchEcommerceStoresIdProductsIdVariantsIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PutEcommerceStoresIdProductsIdVariantsIdData = {
  body: {
    /**
     * The backorders of a product variant.
     */
    backorders?: string;
    /**
     * A unique identifier for the product variant.
     */
    id: string;
    /**
     * The image URL for a product variant.
     */
    image_url?: string;
    /**
     * The inventory quantity of a product variant.
     */
    inventory_quantity?: number;
    /**
     * The price of a product variant.
     */
    price?: number;
    /**
     * The stock keeping unit (SKU) of a product variant.
     */
    sku?: string;
    /**
     * The title of a product variant.
     */
    title: string;
    /**
     * The URL for a product variant.
     */
    url?: string;
    /**
     * The visibility of a product variant.
     */
    visibility?: string;
  };
  path: {
    /**
     * The id for the product of a store.
     */
    product_id: string;
    /**
     * The store id.
     */
    store_id: string;
    /**
     * The id for the product variant.
     */
    variant_id: string;
  };
};

export type PutEcommerceStoresIdProductsIdVariantsIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The backorders of a product variant.
   */
  backorders?: string;
  /**
   * The date and time the product was created in ISO 8601 format.
   */
  readonly created_at?: string;
  /**
   * A unique identifier for the product variant.
   */
  readonly id?: string;
  /**
   * The image URL for a product variant.
   */
  image_url?: string;
  /**
   * The inventory quantity of a product variant.
   */
  inventory_quantity?: number;
  /**
   * The price of a product variant.
   */
  price?: number;
  /**
   * The stock keeping unit (SKU) of a product variant.
   */
  sku?: string;
  /**
   * The title of a product variant.
   */
  title?: string;
  /**
   * The date and time the product was last updated in ISO 8601 format.
   */
  readonly updated_at?: string;
  /**
   * The URL for a product variant.
   */
  url?: string;
  /**
   * The visibility of a product variant.
   */
  visibility?: string;
};

export type PutEcommerceStoresIdProductsIdVariantsIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdPromorulesData = {
  path: {
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
  };
};

export type GetEcommerceStoresIdPromorulesResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of objects, each representing promo rules defined for a store.
   */
  promo_rules?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The amount of the promo code discount. If 'type' is 'fixed', the amount is treated as a monetary value. If 'type' is 'percentage', amount must be a decimal value between 0.0 and 1.0, inclusive.
     */
    amount?: number;
    /**
     * The date and time the promotion was created in ISO 8601 format.
     */
    created_at_foreign?: string;
    /**
     * The description of a promotion restricted to UTF-8 characters with max length 255.
     */
    description?: string;
    /**
     * Whether the promo rule is currently enabled.
     */
    enabled?: boolean;
    /**
     * The date and time when the promotion ends. Must be after starts_at and in ISO 8601 format.
     */
    ends_at?: string;
    /**
     * A unique identifier for the promo rule. If Ecommerce platform does not support promo rule, use promo code id as promo rule id. Restricted to UTF-8 characters with max length 50.
     */
    readonly id?: string;
    /**
     * The date and time when the promotion is in effect in ISO 8601 format.
     */
    starts_at?: string;
    /**
     * The target that the discount applies to.
     */
    target?: 'per_item' | 'total' | 'shipping';
    /**
     * The title that will show up in promotion campaign. Restricted to UTF-8 characters with max length of 100 bytes.
     */
    title?: string;
    /**
     * Type of discount. For free shipping set type to fixed.
     */
    type?: 'fixed' | 'percentage';
    /**
     * The date and time the promotion was updated in ISO 8601 format.
     */
    updated_at_foreign?: string;
  }>;
  /**
   * The store id.
   */
  store_id?: string;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetEcommerceStoresIdPromorulesError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PostEcommerceStoresIdPromorulesData = {
  body: {
    /**
     * The amount of the promo code discount. If 'type' is 'fixed', the amount is treated as a monetary value. If 'type' is 'percentage', amount must be a decimal value between 0.0 and 1.0, inclusive.
     */
    amount: number;
    /**
     * The date and time the promotion was created in ISO 8601 format.
     */
    created_at_foreign?: string;
    /**
     * The description of a promotion restricted to UTF-8 characters with max length 255.
     */
    description: string;
    /**
     * Whether the promo rule is currently enabled.
     */
    enabled?: boolean;
    /**
     * The date and time when the promotion ends. Must be after starts_at and in ISO 8601 format.
     */
    ends_at?: string;
    /**
     * A unique identifier for the promo rule. If Ecommerce platform does not support promo rule, use promo code id as promo rule id. Restricted to UTF-8 characters with max length 50.
     */
    id: string;
    /**
     * The date and time when the promotion is in effect in ISO 8601 format.
     */
    starts_at?: string;
    /**
     * The target that the discount applies to.
     */
    target: 'per_item' | 'total' | 'shipping';
    /**
     * The title that will show up in promotion campaign. Restricted to UTF-8 characters with max length of 100 bytes.
     */
    title?: string;
    /**
     * Type of discount. For free shipping set type to fixed.
     */
    type: 'fixed' | 'percentage';
    /**
     * The date and time the promotion was updated in ISO 8601 format.
     */
    updated_at_foreign?: string;
  };
  path: {
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PostEcommerceStoresIdPromorulesResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The amount of the promo code discount. If 'type' is 'fixed', the amount is treated as a monetary value. If 'type' is 'percentage', amount must be a decimal value between 0.0 and 1.0, inclusive.
   */
  amount?: number;
  /**
   * The date and time the promotion was created in ISO 8601 format.
   */
  created_at_foreign?: string;
  /**
   * The description of a promotion restricted to UTF-8 characters with max length 255.
   */
  description?: string;
  /**
   * Whether the promo rule is currently enabled.
   */
  enabled?: boolean;
  /**
   * The date and time when the promotion ends. Must be after starts_at and in ISO 8601 format.
   */
  ends_at?: string;
  /**
   * A unique identifier for the promo rule. If Ecommerce platform does not support promo rule, use promo code id as promo rule id. Restricted to UTF-8 characters with max length 50.
   */
  readonly id?: string;
  /**
   * The date and time when the promotion is in effect in ISO 8601 format.
   */
  starts_at?: string;
  /**
   * The target that the discount applies to.
   */
  target?: 'per_item' | 'total' | 'shipping';
  /**
   * The title that will show up in promotion campaign. Restricted to UTF-8 characters with max length of 100 bytes.
   */
  title?: string;
  /**
   * Type of discount. For free shipping set type to fixed.
   */
  type?: 'fixed' | 'percentage';
  /**
   * The date and time the promotion was updated in ISO 8601 format.
   */
  updated_at_foreign?: string;
};

export type PostEcommerceStoresIdPromorulesError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type DeleteEcommerceStoresIdPromorulesIdData = {
  path: {
    /**
     * The id for the promo rule of a store.
     */
    promo_rule_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type DeleteEcommerceStoresIdPromorulesIdResponse = any;

export type DeleteEcommerceStoresIdPromorulesIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdPromorulesIdData = {
  path: {
    /**
     * The id for the promo rule of a store.
     */
    promo_rule_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
  };
};

export type GetEcommerceStoresIdPromorulesIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The amount of the promo code discount. If 'type' is 'fixed', the amount is treated as a monetary value. If 'type' is 'percentage', amount must be a decimal value between 0.0 and 1.0, inclusive.
   */
  amount?: number;
  /**
   * The date and time the promotion was created in ISO 8601 format.
   */
  created_at_foreign?: string;
  /**
   * The description of a promotion restricted to UTF-8 characters with max length 255.
   */
  description?: string;
  /**
   * Whether the promo rule is currently enabled.
   */
  enabled?: boolean;
  /**
   * The date and time when the promotion ends. Must be after starts_at and in ISO 8601 format.
   */
  ends_at?: string;
  /**
   * A unique identifier for the promo rule. If Ecommerce platform does not support promo rule, use promo code id as promo rule id. Restricted to UTF-8 characters with max length 50.
   */
  readonly id?: string;
  /**
   * The date and time when the promotion is in effect in ISO 8601 format.
   */
  starts_at?: string;
  /**
   * The target that the discount applies to.
   */
  target?: 'per_item' | 'total' | 'shipping';
  /**
   * The title that will show up in promotion campaign. Restricted to UTF-8 characters with max length of 100 bytes.
   */
  title?: string;
  /**
   * Type of discount. For free shipping set type to fixed.
   */
  type?: 'fixed' | 'percentage';
  /**
   * The date and time the promotion was updated in ISO 8601 format.
   */
  updated_at_foreign?: string;
};

export type GetEcommerceStoresIdPromorulesIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type PatchEcommerceStoresIdPromorulesIdData = {
  body: {
    /**
     * The amount of the promo code discount. If 'type' is 'fixed', the amount is treated as a monetary value. If 'type' is 'percentage', amount must be a decimal value between 0.0 and 1.0, inclusive.
     */
    amount?: number;
    /**
     * The date and time the promotion was created in ISO 8601 format.
     */
    created_at_foreign?: string;
    /**
     * The description of a promotion restricted to UTF-8 characters with max length 255.
     */
    description?: string;
    /**
     * Whether the promo rule is currently enabled.
     */
    enabled?: boolean;
    /**
     * The date and time when the promotion ends. Must be after starts_at and in ISO 8601 format.
     */
    ends_at?: string;
    /**
     * The date and time when the promotion is in effect in ISO 8601 format.
     */
    starts_at?: string;
    /**
     * The target that the discount applies to.
     */
    target?: 'per_item' | 'total' | 'shipping';
    /**
     * The title that will show up in promotion campaign. Restricted to UTF-8 characters with max length of 100 bytes.
     */
    title?: string;
    /**
     * Type of discount. For free shipping set type to fixed.
     */
    type?: 'fixed' | 'percentage';
    /**
     * The date and time the promotion was updated in ISO 8601 format.
     */
    updated_at_foreign?: string;
  };
  path: {
    /**
     * The id for the promo rule of a store.
     */
    promo_rule_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
};

export type PatchEcommerceStoresIdPromorulesIdResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * The amount of the promo code discount. If 'type' is 'fixed', the amount is treated as a monetary value. If 'type' is 'percentage', amount must be a decimal value between 0.0 and 1.0, inclusive.
   */
  amount?: number;
  /**
   * The date and time the promotion was created in ISO 8601 format.
   */
  created_at_foreign?: string;
  /**
   * The description of a promotion restricted to UTF-8 characters with max length 255.
   */
  description?: string;
  /**
   * Whether the promo rule is currently enabled.
   */
  enabled?: boolean;
  /**
   * The date and time when the promotion ends. Must be after starts_at and in ISO 8601 format.
   */
  ends_at?: string;
  /**
   * A unique identifier for the promo rule. If Ecommerce platform does not support promo rule, use promo code id as promo rule id. Restricted to UTF-8 characters with max length 50.
   */
  readonly id?: string;
  /**
   * The date and time when the promotion is in effect in ISO 8601 format.
   */
  starts_at?: string;
  /**
   * The target that the discount applies to.
   */
  target?: 'per_item' | 'total' | 'shipping';
  /**
   * The title that will show up in promotion campaign. Restricted to UTF-8 characters with max length of 100 bytes.
   */
  title?: string;
  /**
   * Type of discount. For free shipping set type to fixed.
   */
  type?: 'fixed' | 'percentage';
  /**
   * The date and time the promotion was updated in ISO 8601 format.
   */
  updated_at_foreign?: string;
};

export type PatchEcommerceStoresIdPromorulesIdError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem type. When dereferenced, it should provide human-readable documentation for the problem type.
   */
  type: string;
};

export type GetEcommerceStoresIdPromocodesData = {
  path: {
    /**
     * The id for the promo rule of a store.
     */
    promo_rule_id: string;
    /**
     * The store id.
     */
    store_id: string;
  };
  query?: {
    /**
     * The number of records to return. Default value is 10. Maximum value is 1000
     */
    count?: number;
    /**
     * A comma-separated list of fields to exclude. Reference parameters of sub-objects with dot notation.
     */
    exclude_fields?: Array<string>;
    /**
     * A comma-separated list of fields to return. Reference parameters of sub-objects with dot notation.
     */
    fields?: Array<string>;
    /**
     * Used for [pagination](https://mailchimp.com/developer/marketing/docs/methods-parameters/#pagination), this it the number of records from a collection to skip. Default value is 0.
     */
    offset?: number;
  };
};

export type GetEcommerceStoresIdPromocodesResponse = {
  /**
   * A list of link types and descriptions for the API schema documents.
   */
  readonly _links?: Array<{
    /**
     * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
     */
    readonly href?: string;
    /**
     * The HTTP method that should be used when accessing the URL defined in 'href'.
     */
    readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
    /**
     * As with an HTML 'rel' attribute, this describes the type of link.
     */
    readonly rel?: string;
    /**
     * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
     */
    readonly schema?: string;
    /**
     * For GETs, this is a URL representing the schema that the response should conform to.
     */
    readonly targetSchema?: string;
  }>;
  /**
   * An array of objects, each representing promo codes defined for a store.
   */
  promo_codes?: Array<{
    /**
     * A list of link types and descriptions for the API schema documents.
     */
    readonly _links?: Array<{
      /**
       * This property contains a fully-qualified URL that can be called to retrieve the linked resource or perform the linked action.
       */
      readonly href?: string;
      /**
       * The HTTP method that should be used when accessing the URL defined in 'href'.
       */
      readonly method?: 'GET' | 'POST' | 'PUT' | 'PATCH' | 'DELETE' | 'OPTIONS' | 'HEAD';
      /**
       * As with an HTML 'rel' attribute, this describes the type of link.
       */
      readonly rel?: string;
      /**
       * For HTTP methods that can receive bodies (POST and PUT), this is a URL representing the schema that the body should conform to.
       */
      readonly schema?: string;
      /**
       * For GETs, this is a URL representing the schema that the response should conform to.
       */
      readonly targetSchema?: string;
    }>;
    /**
     * The discount code. Restricted to UTF-8 characters with max length 50.
     */
    code?: string;
    /**
     * The date and time the promotion was created in ISO 8601 format.
     */
    created_at_foreign?: string;
    /**
     * Whether the promo code is currently enabled.
     */
    enabled?: boolean;
    /**
     * A unique identifier for the promo Code.
     */
    readonly id?: string;
    /**
     * The url that should be used in the promotion campaign restricted to UTF-8 characters with max length 2000.
     */
    redemption_url?: string;
    /**
     * The date and time the promotion was updated in ISO 8601 format.
     */
    updated_at_foreign?: string;
    /**
     * Number of times promo code has been used.
     */
    usage_count?: number;
  }>;
  /**
   * The store id.
   */
  store_id?: string;
  /**
   * The total number of items matching the query regardless of pagination.
   */
  readonly total_items?: number;
};

export type GetEcommerceStoresIdPromocodesError = {
  /**
   * A human-readable explanation specific to this occurrence of the problem. [Learn more about errors](/developer/guides/get-started-with-mailchimp-api-3/#Errors).
   */
  detail: string;
  /**
   * A string that identifies this specific occurrence of the problem. Please provide this ID when contacting support.
   */
  instance: string;
  /**
   * The HTTP status code (RFC2616, Section 6) generated by the origin server for this occurrence of the problem.
   */
  status: number;
  /**
   * A short, human-readable summary of the problem type. It shouldn't change based on the occurrence of the problem, except for purposes of localization.
   */
  title: string;
  /**
   * An absolute URI that identifies the problem