// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  GetRootData,
  GetRootError,
  GetRootResponse,
  GetAccountExportsData,
  GetAccountExportsError,
  GetAccountExportsResponse,
  PostAccountExportData,
  PostAccountExportError,
  PostAccountExportResponse,
  GetAccountExportIdData,
  GetAccountExportIdError,
  GetAccountExportIdResponse,
  GetActivityFeedChimpChatterData,
  GetActivityFeedChimpChatterError,
  GetActivityFeedChimpChatterResponse,
  GetAuthorizedAppsData,
  GetAuthorizedAppsError,
  GetAuthorizedAppsResponse,
  GetAuthorizedAppsIdData,
  GetAuthorizedAppsIdError,
  GetAuthorizedAppsIdResponse,
  GetAutomationsData,
  GetAutomationsError,
  GetAutomationsResponse,
  PostAutomationsData,
  PostAutomationsError,
  PostAutomationsResponse,
  GetAutomationsIdData,
  GetAutomationsIdError,
  GetAutomationsIdResponse,
  ArchiveAutomationsData,
  ArchiveAutomationsError,
  ArchiveAutomationsResponse,
  PostAutomationsIdActionsPauseAllEmailsData,
  PostAutomationsIdActionsPauseAllEmailsError,
  PostAutomationsIdActionsPauseAllEmailsResponse,
  PostAutomationsIdActionsStartAllEmailsData,
  PostAutomationsIdActionsStartAllEmailsError,
  PostAutomationsIdActionsStartAllEmailsResponse,
  GetAutomationsIdEmailsData,
  GetAutomationsIdEmailsError,
  GetAutomationsIdEmailsResponse,
  DeleteAutomationsIdEmailsIdData,
  DeleteAutomationsIdEmailsIdError,
  DeleteAutomationsIdEmailsIdResponse,
  GetAutomationsIdEmailsIdData,
  GetAutomationsIdEmailsIdError,
  GetAutomationsIdEmailsIdResponse,
  PatchAutomationEmailWorkflowIdData,
  PatchAutomationEmailWorkflowIdError,
  PatchAutomationEmailWorkflowIdResponse,
  PostAutomationsIdEmailsIdActionsPauseData,
  PostAutomationsIdEmailsIdActionsPauseError,
  PostAutomationsIdEmailsIdActionsPauseResponse,
  PostAutomationsIdEmailsIdActionsStartData,
  PostAutomationsIdEmailsIdActionsStartError,
  PostAutomationsIdEmailsIdActionsStartResponse,
  GetAutomationsIdEmailsIdQueueData,
  GetAutomationsIdEmailsIdQueueError,
  GetAutomationsIdEmailsIdQueueResponse,
  PostAutomationsIdEmailsIdQueueData,
  PostAutomationsIdEmailsIdQueueError,
  PostAutomationsIdEmailsIdQueueResponse,
  GetAutomationsIdEmailsIdQueueIdData,
  GetAutomationsIdEmailsIdQueueIdError,
  GetAutomationsIdEmailsIdQueueIdResponse,
  GetAutomationsIdRemovedSubscribersData,
  GetAutomationsIdRemovedSubscribersError,
  GetAutomationsIdRemovedSubscribersResponse,
  PostAutomationsIdRemovedSubscribersData,
  PostAutomationsIdRemovedSubscribersError,
  PostAutomationsIdRemovedSubscribersResponse,
  GetAutomationsIdRemovedSubscribersIdData,
  GetAutomationsIdRemovedSubscribersIdError,
  GetAutomationsIdRemovedSubscribersIdResponse,
  GetBatchWebhooksData,
  GetBatchWebhooksError,
  GetBatchWebhooksResponse,
  PostBatchWebhooksData,
  PostBatchWebhooksError,
  PostBatchWebhooksResponse,
  DeleteBatchWebhookIdData,
  DeleteBatchWebhookIdError,
  DeleteBatchWebhookIdResponse,
  GetBatchWebhookData,
  GetBatchWebhookError,
  GetBatchWebhookResponse,
  PatchBatchWebhooksData,
  PatchBatchWebhooksError,
  PatchBatchWebhooksResponse,
  GetBatchesData,
  GetBatchesError,
  GetBatchesResponse,
  PostBatchesData,
  PostBatchesError,
  PostBatchesResponse,
  DeleteBatchesIdData,
  DeleteBatchesIdError,
  DeleteBatchesIdResponse,
  GetBatchesIdData,
  GetBatchesIdError,
  GetBatchesIdResponse,
  GetCampaignFoldersData,
  GetCampaignFoldersError,
  GetCampaignFoldersResponse,
  PostCampaignFoldersData,
  PostCampaignFoldersError,
  PostCampaignFoldersResponse,
  DeleteCampaignFoldersIdData,
  DeleteCampaignFoldersIdError,
  DeleteCampaignFoldersIdResponse,
  GetCampaignFoldersIdData,
  GetCampaignFoldersIdError,
  GetCampaignFoldersIdResponse,
  PatchCampaignFoldersIdData,
  PatchCampaignFoldersIdError,
  PatchCampaignFoldersIdResponse,
  GetCampaignsData,
  GetCampaignsError,
  GetCampaignsResponse,
  PostCampaignsData,
  PostCampaignsError,
  PostCampaignsResponse,
  DeleteCampaignsIdData,
  DeleteCampaignsIdError,
  DeleteCampaignsIdResponse,
  GetCampaignsIdData,
  GetCampaignsIdError,
  GetCampaignsIdResponse,
  PatchCampaignsIdData,
  PatchCampaignsIdError,
  PatchCampaignsIdResponse,
  PostCampaignsIdActionsCancelSendData,
  PostCampaignsIdActionsCancelSendError,
  PostCampaignsIdActionsCancelSendResponse,
  PostCampaignsIdActionsCreateResendData,
  PostCampaignsIdActionsCreateResendError,
  PostCampaignsIdActionsCreateResendResponse,
  PostCampaignsIdActionsPauseData,
  PostCampaignsIdActionsPauseError,
  PostCampaignsIdActionsPauseResponse,
  PostCampaignsIdActionsReplicateData,
  PostCampaignsIdActionsReplicateError,
  PostCampaignsIdActionsReplicateResponse,
  PostCampaignsIdActionsResumeData,
  PostCampaignsIdActionsResumeError,
  PostCampaignsIdActionsResumeResponse,
  PostCampaignsIdActionsScheduleData,
  PostCampaignsIdActionsScheduleError,
  PostCampaignsIdActionsScheduleResponse,
  PostCampaignsIdActionsSendData,
  PostCampaignsIdActionsSendError,
  PostCampaignsIdActionsSendResponse,
  PostCampaignsIdActionsTestData,
  PostCampaignsIdActionsTestError,
  PostCampaignsIdActionsTestResponse,
  PostCampaignsIdActionsUnscheduleData,
  PostCampaignsIdActionsUnscheduleError,
  PostCampaignsIdActionsUnscheduleResponse,
  GetCampaignsIdContentData,
  GetCampaignsIdContentError,
  GetCampaignsIdContentResponse,
  PutCampaignsIdContentData,
  PutCampaignsIdContentError,
  PutCampaignsIdContentResponse,
  GetCampaignsIdFeedbackData,
  GetCampaignsIdFeedbackError,
  GetCampaignsIdFeedbackResponse,
  PostCampaignsIdFeedbackData,
  PostCampaignsIdFeedbackError,
  PostCampaignsIdFeedbackResponse,
  DeleteCampaignsIdFeedbackIdData,
  DeleteCampaignsIdFeedbackIdError,
  DeleteCampaignsIdFeedbackIdResponse,
  GetCampaignsIdFeedbackIdData,
  GetCampaignsIdFeedbackIdError,
  GetCampaignsIdFeedbackIdResponse,
  PatchCampaignsIdFeedbackIdData,
  PatchCampaignsIdFeedbackIdError,
  PatchCampaignsIdFeedbackIdResponse,
  GetCampaignsIdSendChecklistData,
  GetCampaignsIdSendChecklistError,
  GetCampaignsIdSendChecklistResponse,
  GetConnectedSitesData,
  GetConnectedSitesError,
  GetConnectedSitesResponse,
  PostConnectedSitesData,
  PostConnectedSitesError,
  PostConnectedSitesResponse,
  DeleteConnectedSitesIdData,
  DeleteConnectedSitesIdError,
  DeleteConnectedSitesIdResponse,
  GetConnectedSitesIdData,
  GetConnectedSitesIdError,
  GetConnectedSitesIdResponse,
  PostConnectedSitesIdActionsVerifyScriptInstallationData,
  PostConnectedSitesIdActionsVerifyScriptInstallationError,
  PostConnectedSitesIdActionsVerifyScriptInstallationResponse,
  GetConversationsData,
  GetConversationsError,
  GetConversationsResponse,
  GetConversationsIdData,
  GetConversationsIdError,
  GetConversationsIdResponse,
  GetConversationsIdMessagesData,
  GetConversationsIdMessagesError,
  GetConversationsIdMessagesResponse,
  GetConversationsIdMessagesIdData,
  GetConversationsIdMessagesIdError,
  GetConversationsIdMessagesIdResponse,
  PostCustomerJourneysJourneysIdStepsIdActionsTriggerData,
  PostCustomerJourneysJourneysIdStepsIdActionsTriggerError,
  PostCustomerJourneysJourneysIdStepsIdActionsTriggerResponse,
  GetEcommerceOrdersData,
  GetEcommerceOrdersError,
  GetEcommerceOrdersResponse,
  GetEcommerceStoresData,
  GetEcommerceStoresError,
  GetEcommerceStoresResponse,
  PostEcommerceStoresData,
  PostEcommerceStoresError,
  PostEcommerceStoresResponse,
  DeleteEcommerceStoresIdData,
  DeleteEcommerceStoresIdError,
  DeleteEcommerceStoresIdResponse,
  GetEcommerceStoresIdData,
  GetEcommerceStoresIdError,
  GetEcommerceStoresIdResponse,
  PatchEcommerceStoresIdData,
  PatchEcommerceStoresIdError,
  PatchEcommerceStoresIdResponse,
  GetEcommerceStoresIdCartsData,
  GetEcommerceStoresIdCartsError,
  GetEcommerceStoresIdCartsResponse,
  PostEcommerceStoresIdCartsData,
  PostEcommerceStoresIdCartsError,
  PostEcommerceStoresIdCartsResponse,
  DeleteEcommerceStoresIdCartsIdData,
  DeleteEcommerceStoresIdCartsIdError,
  DeleteEcommerceStoresIdCartsIdResponse,
  GetEcommerceStoresIdCartsIdData,
  GetEcommerceStoresIdCartsIdError,
  GetEcommerceStoresIdCartsIdResponse,
  PatchEcommerceStoresIdCartsIdData,
  PatchEcommerceStoresIdCartsIdError,
  PatchEcommerceStoresIdCartsIdResponse,
  GetEcommerceStoresIdCartsIdLinesData,
  GetEcommerceStoresIdCartsIdLinesError,
  GetEcommerceStoresIdCartsIdLinesResponse,
  PostEcommerceStoresIdCartsIdLinesData,
  PostEcommerceStoresIdCartsIdLinesError,
  PostEcommerceStoresIdCartsIdLinesResponse,
  DeleteEcommerceStoresIdCartsLinesIdData,
  DeleteEcommerceStoresIdCartsLinesIdError,
  DeleteEcommerceStoresIdCartsLinesIdResponse,
  GetEcommerceStoresIdCartsIdLinesIdData,
  GetEcommerceStoresIdCartsIdLinesIdError,
  GetEcommerceStoresIdCartsIdLinesIdResponse,
  PatchEcommerceStoresIdCartsIdLinesIdData,
  PatchEcommerceStoresIdCartsIdLinesIdError,
  PatchEcommerceStoresIdCartsIdLinesIdResponse,
  GetEcommerceStoresIdCustomersData,
  GetEcommerceStoresIdCustomersError,
  GetEcommerceStoresIdCustomersResponse,
  PostEcommerceStoresIdCustomersData,
  PostEcommerceStoresIdCustomersError,
  PostEcommerceStoresIdCustomersResponse,
  DeleteEcommerceStoresIdCustomersIdData,
  DeleteEcommerceStoresIdCustomersIdError,
  DeleteEcommerceStoresIdCustomersIdResponse,
  GetEcommerceStoresIdCustomersIdData,
  GetEcommerceStoresIdCustomersIdError,
  GetEcommerceStoresIdCustomersIdResponse,
  PatchEcommerceStoresIdCustomersIdData,
  PatchEcommerceStoresIdCustomersIdError,
  PatchEcommerceStoresIdCustomersIdResponse,
  PutEcommerceStoresIdCustomersIdData,
  PutEcommerceStoresIdCustomersIdError,
  PutEcommerceStoresIdCustomersIdResponse,
  GetEcommerceStoresIdOrdersData,
  GetEcommerceStoresIdOrdersError,
  GetEcommerceStoresIdOrdersResponse,
  PostEcommerceStoresIdOrdersData,
  PostEcommerceStoresIdOrdersError,
  PostEcommerceStoresIdOrdersResponse,
  DeleteEcommerceStoresIdOrdersIdData,
  DeleteEcommerceStoresIdOrdersIdError,
  DeleteEcommerceStoresIdOrdersIdResponse,
  GetEcommerceStoresIdOrdersIdData,
  GetEcommerceStoresIdOrdersIdError,
  GetEcommerceStoresIdOrdersIdResponse,
  PatchEcommerceStoresIdOrdersIdData,
  PatchEcommerceStoresIdOrdersIdError,
  PatchEcommerceStoresIdOrdersIdResponse,
  GetEcommerceStoresIdOrdersIdLinesData,
  GetEcommerceStoresIdOrdersIdLinesError,
  GetEcommerceStoresIdOrdersIdLinesResponse,
  PostEcommerceStoresIdOrdersIdLinesData,
  PostEcommerceStoresIdOrdersIdLinesError,
  PostEcommerceStoresIdOrdersIdLinesResponse,
  DeleteEcommerceStoresIdOrdersIdLinesIdData,
  DeleteEcommerceStoresIdOrdersIdLinesIdError,
  DeleteEcommerceStoresIdOrdersIdLinesIdResponse,
  GetEcommerceStoresIdOrdersIdLinesIdData,
  GetEcommerceStoresIdOrdersIdLinesIdError,
  GetEcommerceStoresIdOrdersIdLinesIdResponse,
  PatchEcommerceStoresIdOrdersIdLinesIdData,
  PatchEcommerceStoresIdOrdersIdLinesIdError,
  PatchEcommerceStoresIdOrdersIdLinesIdResponse,
  GetEcommerceStoresIdProductsData,
  GetEcommerceStoresIdProductsError,
  GetEcommerceStoresIdProductsResponse,
  PostEcommerceStoresIdProductsData,
  PostEcommerceStoresIdProductsError,
  PostEcommerceStoresIdProductsResponse,
  DeleteEcommerceStoresIdProductsIdData,
  DeleteEcommerceStoresIdProductsIdError,
  DeleteEcommerceStoresIdProductsIdResponse,
  GetEcommerceStoresIdProductsIdData,
  GetEcommerceStoresIdProductsIdError,
  GetEcommerceStoresIdProductsIdResponse,
  PatchEcommerceStoresIdProductsIdData,
  PatchEcommerceStoresIdProductsIdError,
  PatchEcommerceStoresIdProductsIdResponse,
  GetEcommerceStoresIdProductsIdImagesData,
  GetEcommerceStoresIdProductsIdImagesError,
  GetEcommerceStoresIdProductsIdImagesResponse,
  PostEcommerceStoresIdProductsIdImagesData,
  PostEcommerceStoresIdProductsIdImagesError,
  PostEcommerceStoresIdProductsIdImagesResponse,
  DeleteEcommerceStoresIdProductsIdImagesIdData,
  DeleteEcommerceStoresIdProductsIdImagesIdError,
  DeleteEcommerceStoresIdProductsIdImagesIdResponse,
  GetEcommerceStoresIdProductsIdImagesIdData,
  GetEcommerceStoresIdProductsIdImagesIdError,
  GetEcommerceStoresIdProductsIdImagesIdResponse,
  PatchEcommerceStoresIdProductsIdImagesIdData,
  PatchEcommerceStoresIdProductsIdImagesIdError,
  PatchEcommerceStoresIdProductsIdImagesIdResponse,
  GetEcommerceStoresIdProductsIdVariantsData,
  GetEcommerceStoresIdProductsIdVariantsError,
  GetEcommerceStoresIdProductsIdVariantsResponse,
  PostEcommerceStoresIdProductsIdVariantsData,
  PostEcommerceStoresIdProductsIdVariantsError,
  PostEcommerceStoresIdProductsIdVariantsResponse,
  DeleteEcommerceStoresIdProductsIdVariantsIdData,
  DeleteEcommerceStoresIdProductsIdVariantsIdError,
  DeleteEcommerceStoresIdProductsIdVariantsIdResponse,
  GetEcommerceStoresIdProductsIdVariantsIdData,
  GetEcommerceStoresIdProductsIdVariantsIdError,
  GetEcommerceStoresIdProductsIdVariantsIdResponse,
  PatchEcommerceStoresIdProductsIdVariantsIdData,
  PatchEcommerceStoresIdProductsIdVariantsIdError,
  PatchEcommerceStoresIdProductsIdVariantsIdResponse,
  PutEcommerceStoresIdProductsIdVariantsIdData,
  PutEcommerceStoresIdProductsIdVariantsIdError,
  PutEcommerceStoresIdProductsIdVariantsIdResponse,
  GetEcommerceStoresIdPromorulesData,
  GetEcommerceStoresIdPromorulesError,
  GetEcommerceStoresIdPromorulesResponse,
  PostEcommerceStoresIdPromorulesData,
  PostEcommerceStoresIdPromorulesError,
  PostEcommerceStoresIdPromorulesResponse,
  DeleteEcommerceStoresIdPromorulesIdData,
  DeleteEcommerceStoresIdPromorulesIdError,
  DeleteEcommerceStoresIdPromorulesIdResponse,
  GetEcommerceStoresIdPromorulesIdData,
  GetEcommerceStoresIdPromorulesIdError,
  GetEcommerceStoresIdPromorulesIdResponse,
  PatchEcommerceStoresIdPromorulesIdData,
  PatchEcommerceStoresIdPromorulesIdError,
  PatchEcommerceStoresIdPromorulesIdResponse,
  GetEcommerceStoresIdPromocodesData,
  GetEcommerceStoresIdPromocodesError,
  GetEcommerceStoresIdPromocodesResponse,
  PostEcommerceStoresIdPromocodesData,
  PostEcommerceStoresIdPromocodesError,
  PostEcommerceStoresIdPromocodesResponse,
  DeleteEcommerceStoresIdPromocodesIdData,
  DeleteEcommerceStoresIdPromocodesIdError,
  DeleteEcommerceStoresIdPromocodesIdResponse,
  GetEcommerceStoresIdPromocodesIdData,
  GetEcommerceStoresIdPromocodesIdError,
  GetEcommerceStoresIdPromocodesIdResponse,
  PatchEcommerceStoresIdPromocodesIdData,
  PatchEcommerceStoresIdPromocodesIdError,
  PatchEcommerceStoresIdPromocodesIdResponse,
  GetAllFacebookAdsData,
  GetAllFacebookAdsError,
  GetAllFacebookAdsResponse,
  GetFacebookAdsIdData,
  GetFacebookAdsIdError,
  GetFacebookAdsIdResponse,
  GetFileManagerFilesData,
  GetFileManagerFilesError,
  GetFileManagerFilesResponse,
  PostFileManagerFilesData,
  PostFileManagerFilesError,
  PostFileManagerFilesResponse,
  DeleteFileManagerFilesIdData,
  DeleteFileManagerFilesIdError,
  DeleteFileManagerFilesIdResponse,
  GetFileManagerFilesIdData,
  GetFileManagerFilesIdError,
  GetFileManagerFilesIdResponse,
  PatchFileManagerFilesIdData,
  PatchFileManagerFilesIdError,
  PatchFileManagerFilesIdResponse,
  GetFileManagerFoldersData,
  GetFileManagerFoldersError,
  GetFileManagerFoldersResponse,
  PostFileManagerFoldersData,
  PostFileManagerFoldersError,
  PostFileManagerFoldersResponse,
  DeleteFileManagerFoldersIdData,
  DeleteFileManagerFoldersIdError,
  DeleteFileManagerFoldersIdResponse,
  GetFileManagerFoldersIdData,
  GetFileManagerFoldersIdError,
  GetFileManagerFoldersIdResponse,
  PatchFileManagerFoldersIdData,
  PatchFileManagerFoldersIdError,
  PatchFileManagerFoldersIdResponse,
  GetFileManagerFoldersFilesData,
  GetFileManagerFoldersFilesError,
  GetFileManagerFoldersFilesResponse,
  GetAllLandingPagesData,
  GetAllLandingPagesError,
  GetAllLandingPagesResponse,
  PostAllLandingPagesData,
  PostAllLandingPagesError,
  PostAllLandingPagesResponse,
  DeleteLandingPageIdData,
  DeleteLandingPageIdError,
  DeleteLandingPageIdResponse,
  GetLandingPageIdData,
  GetLandingPageIdError,
  GetLandingPageIdResponse,
  PatchLandingPageIdData,
  PatchLandingPageIdError,
  PatchLandingPageIdResponse,
  PostLandingPageIdActionsPublishData,
  PostLandingPageIdActionsPublishError,
  PostLandingPageIdActionsPublishResponse,
  PostLandingPageIdActionsUnpublishData,
  PostLandingPageIdActionsUnpublishError,
  PostLandingPageIdActionsUnpublishResponse,
  GetLandingPageIdContentData,
  GetLandingPageIdContentError,
  GetLandingPageIdContentResponse,
  GetListsData,
  GetListsError,
  GetListsResponse,
  PostListsData,
  PostListsError,
  PostListsResponse,
  DeleteListsIdData,
  DeleteListsIdError,
  DeleteListsIdResponse,
  GetListsIdData,
  GetListsIdError,
  GetListsIdResponse,
  PatchListsIdData,
  PatchListsIdError,
  PatchListsIdResponse,
  PostListsIdData,
  PostListsIdError,
  PostListsIdResponse,
  GetListsIdAbuseReportsData,
  GetListsIdAbuseReportsError,
  GetListsIdAbuseReportsResponse,
  GetListsIdAbuseReportsIdData,
  GetListsIdAbuseReportsIdError,
  GetListsIdAbuseReportsIdResponse,
  GetListsIdActivityData,
  GetListsIdActivityError,
  GetListsIdActivityResponse,
  GetListsIdClientsData,
  GetListsIdClientsError,
  GetListsIdClientsResponse,
  GetListsIdGrowthHistoryData,
  GetListsIdGrowthHistoryError,
  GetListsIdGrowthHistoryResponse,
  GetListsIdGrowthHistoryIdData,
  GetListsIdGrowthHistoryIdError,
  GetListsIdGrowthHistoryIdResponse,
  GetListsIdInterestCategoriesData,
  GetListsIdInterestCategoriesError,
  GetListsIdInterestCategoriesResponse,
  PostListsIdInterestCategoriesData,
  PostListsIdInterestCategoriesError,
  PostListsIdInterestCategoriesResponse,
  DeleteListsIdInterestCategoriesIdData,
  DeleteListsIdInterestCategoriesIdError,
  DeleteListsIdInterestCategoriesIdResponse,
  GetListsIdInterestCategoriesIdData,
  GetListsIdInterestCategoriesIdError,
  GetListsIdInterestCategoriesIdResponse,
  PatchListsIdInterestCategoriesIdData,
  PatchListsIdInterestCategoriesIdError,
  PatchListsIdInterestCategoriesIdResponse,
  GetListsIdInterestCategoriesIdInterestsData,
  GetListsIdInterestCategoriesIdInterestsError,
  GetListsIdInterestCategoriesIdInterestsResponse,
  PostListsIdInterestCategoriesIdInterestsData,
  PostListsIdInterestCategoriesIdInterestsError,
  PostListsIdInterestCategoriesIdInterestsResponse,
  DeleteListsIdInterestCategoriesIdInterestsIdData,
  DeleteListsIdInterestCategoriesIdInterestsIdError,
  DeleteListsIdInterestCategoriesIdInterestsIdResponse,
  GetListsIdInterestCategoriesIdInterestsIdData,
  GetListsIdInterestCategoriesIdInterestsIdError,
  GetListsIdInterestCategoriesIdInterestsIdResponse,
  PatchListsIdInterestCategoriesIdInterestsIdData,
  PatchListsIdInterestCategoriesIdInterestsIdError,
  PatchListsIdInterestCategoriesIdInterestsIdResponse,
  GetListsIdLocationsData,
  GetListsIdLocationsError,
  GetListsIdLocationsResponse,
  GetListsIdMembersData,
  GetListsIdMembersError,
  GetListsIdMembersResponse,
  PostListsIdMembersData,
  PostListsIdMembersError,
  PostListsIdMembersResponse,
  DeleteListsIdMembersIdData,
  DeleteListsIdMembersIdError,
  DeleteListsIdMembersIdResponse,
  GetListsIdMembersIdData,
  GetListsIdMembersIdError,
  GetListsIdMembersIdResponse,
  PatchListsIdMembersIdData,
  PatchListsIdMembersIdError,
  PatchListsIdMembersIdResponse,
  PutListsIdMembersIdData,
  PutListsIdMembersIdError,
  PutListsIdMembersIdResponse,
  PostListsIdMembersHashActionsDeletePermanentData,
  PostListsIdMembersHashActionsDeletePermanentError,
  PostListsIdMembersHashActionsDeletePermanentResponse,
  GetListsIdMembersIdActivityData,
  GetListsIdMembersIdActivityError,
  GetListsIdMembersIdActivityResponse,
  GetListsIdMembersIdActivityFeedData,
  GetListsIdMembersIdActivityFeedError,
  GetListsIdMembersIdActivityFeedResponse,
  GetListsIdMembersIdEventsData,
  GetListsIdMembersIdEventsError,
  GetListsIdMembersIdEventsResponse,
  PostListMemberEventsData,
  PostListMemberEventsError,
  PostListMemberEventsResponse,
  GetListsIdMembersIdGoalsData,
  GetListsIdMembersIdGoalsError,
  GetListsIdMembersIdGoalsResponse,
  GetListsIdMembersIdNotesData,
  GetListsIdMembersIdNotesError,
  GetListsIdMembersIdNotesResponse,
  PostListsIdMembersIdNotesData,
  PostListsIdMembersIdNotesError,
  PostListsIdMembersIdNotesResponse,
  DeleteListsIdMembersIdNotesIdData,
  DeleteListsIdMembersIdNotesIdError,
  DeleteListsIdMembersIdNotesIdResponse,
  GetListsIdMembersIdNotesIdData,
  GetListsIdMembersIdNotesIdError,
  GetListsIdMembersIdNotesIdResponse,
  PatchListsIdMembersIdNotesIdData,
  PatchListsIdMembersIdNotesIdError,
  PatchListsIdMembersIdNotesIdResponse,
  GetListMemberTagsData,
  GetListMemberTagsError,
  GetListMemberTagsResponse,
  PostListMemberTagsData,
  PostListMemberTagsError,
  PostListMemberTagsResponse,
  GetListsIdMergeFieldsData,
  GetListsIdMergeFieldsError,
  GetListsIdMergeFieldsResponse,
  PostListsIdMergeFieldsData,
  PostListsIdMergeFieldsError,
  PostListsIdMergeFieldsResponse,
  DeleteListsIdMergeFieldsIdData,
  DeleteListsIdMergeFieldsIdError,
  DeleteListsIdMergeFieldsIdResponse,
  GetListsIdMergeFieldsIdData,
  GetListsIdMergeFieldsIdError,
  GetListsIdMergeFieldsIdResponse,
  PatchListsIdMergeFieldsIdData,
  PatchListsIdMergeFieldsIdError,
  PatchListsIdMergeFieldsIdResponse,
  PreviewAsegmentData,
  PreviewAsegmentError,
  PreviewAsegmentResponse,
  PostListsIdSegmentsData,
  PostListsIdSegmentsError,
  PostListsIdSegmentsResponse,
  DeleteListsIdSegmentsIdData,
  DeleteListsIdSegmentsIdError,
  DeleteListsIdSegmentsIdResponse,
  GetListsIdSegmentsIdData,
  GetListsIdSegmentsIdError,
  GetListsIdSegmentsIdResponse,
  PatchListsIdSegmentsIdData,
  PatchListsIdSegmentsIdError,
  PatchListsIdSegmentsIdResponse,
  PostListsIdSegmentsIdData,
  PostListsIdSegmentsIdError,
  PostListsIdSegmentsIdResponse,
  GetListsIdSegmentsIdMembersData,
  GetListsIdSegmentsIdMembersError,
  GetListsIdSegmentsIdMembersResponse,
  PostListsIdSegmentsIdMembersData,
  PostListsIdSegmentsIdMembersError,
  PostListsIdSegmentsIdMembersResponse,
  DeleteListsIdSegmentsIdMembersIdData,
  DeleteListsIdSegmentsIdMembersIdError,
  DeleteListsIdSegmentsIdMembersIdResponse,
  GetListsIdSignupFormsData,
  GetListsIdSignupFormsError,
  GetListsIdSignupFormsResponse,
  PostListsIdSignupFormsData,
  PostListsIdSignupFormsError,
  PostListsIdSignupFormsResponse,
  GetListsIdSurveysData,
  GetListsIdSurveysError,
  GetListsIdSurveysResponse,
  GetListsIdSurveysIdData,
  GetListsIdSurveysIdError,
  GetListsIdSurveysIdResponse,
  PostListsIdSurveysIdActionsCreateEmailData,
  PostListsIdSurveysIdActionsCreateEmailError,
  PostListsIdSurveysIdActionsCreateEmailResponse,
  PostListsIdSurveysIdActionsPublishData,
  PostListsIdSurveysIdActionsPublishError,
  PostListsIdSurveysIdActionsPublishResponse,
  PostListsIdSurveysIdActionsUnpublishData,
  PostListsIdSurveysIdActionsUnpublishError,
  PostListsIdSurveysIdActionsUnpublishResponse,
  SearchTagsByNameData,
  SearchTagsByNameError,
  SearchTagsByNameResponse,
  GetListsIdWebhooksData,
  GetListsIdWebhooksError,
  GetListsIdWebhooksResponse,
  PostListsIdWebhooksData,
  PostListsIdWebhooksError,
  PostListsIdWebhooksResponse,
  DeleteListsIdWebhooksIdData,
  DeleteListsIdWebhooksIdError,
  DeleteListsIdWebhooksIdResponse,
  GetListsIdWebhooksIdData,
  GetListsIdWebhooksIdError,
  GetListsIdWebhooksIdResponse,
  PatchListsIdWebhooksIdData,
  PatchListsIdWebhooksIdError,
  PatchListsIdWebhooksIdResponse,
  GetPingError,
  GetPingResponse,
  GetReportingFacebookAdsData,
  GetReportingFacebookAdsError,
  GetReportingFacebookAdsResponse,
  GetReportingFacebookAdsIdData,
  GetReportingFacebookAdsIdError,
  GetReportingFacebookAdsIdResponse,
  GetReportingFacebookAdsIdEcommerceProductActivityData,
  GetReportingFacebookAdsIdEcommerceProductActivityError,
  GetReportingFacebookAdsIdEcommerceProductActivityResponse,
  GetReportingLandingPagesData,
  GetReportingLandingPagesError,
  GetReportingLandingPagesResponse,
  GetReportingLandingPagesIdData,
  GetReportingLandingPagesIdError,
  GetReportingLandingPagesIdResponse,
  GetReportingSurveysData,
  GetReportingSurveysError,
  GetReportingSurveysResponse,
  GetReportingSurveysIdData,
  GetReportingSurveysIdError,
  GetReportingSurveysIdResponse,
  GetReportingSurveysIdQuestionsData,
  GetReportingSurveysIdQuestionsError,
  GetReportingSurveysIdQuestionsResponse,
  GetReportingSurveysIdQuestionsIdData,
  GetReportingSurveysIdQuestionsIdError,
  GetReportingSurveysIdQuestionsIdResponse,
  GetReportingSurveysIdQuestionsIdAnswersData,
  GetReportingSurveysIdQuestionsIdAnswersError,
  GetReportingSurveysIdQuestionsIdAnswersResponse,
  GetReportingSurveysIdResponsesData,
  GetReportingSurveysIdResponsesError,
  GetReportingSurveysIdResponsesResponse,
  GetReportingSurveysIdResponsesIdData,
  GetReportingSurveysIdResponsesIdError,
  GetReportingSurveysIdResponsesIdResponse,
  GetReportsData,
  GetReportsError,
  GetReportsResponse,
  GetReportsIdData,
  GetReportsIdError,
  GetReportsIdResponse,
  GetReportsIdAbuseReportsIdData,
  GetReportsIdAbuseReportsIdError,
  GetReportsIdAbuseReportsIdResponse,
  GetReportsIdAbuseReportsIdIdData,
  GetReportsIdAbuseReportsIdIdError,
  GetReportsIdAbuseReportsIdIdResponse,
  GetReportsIdAdviceData,
  GetReportsIdAdviceError,
  GetReportsIdAdviceResponse,
  GetReportsIdClickDetailsData,
  GetReportsIdClickDetailsError,
  GetReportsIdClickDetailsResponse,
  GetReportsIdClickDetailsIdData,
  GetReportsIdClickDetailsIdError,
  GetReportsIdClickDetailsIdResponse,
  GetReportsIdClickDetailsIdMembersData,
  GetReportsIdClickDetailsIdMembersError,
  GetReportsIdClickDetailsIdMembersResponse,
  GetReportsIdClickDetailsIdMembersIdData,
  GetReportsIdClickDetailsIdMembersIdError,
  GetReportsIdClickDetailsIdMembersIdResponse,
  GetReportsIdDomainPerformanceData,
  GetReportsIdDomainPerformanceError,
  GetReportsIdDomainPerformanceResponse,
  GetReportsIdEcommerceProductActivityData,
  GetReportsIdEcommerceProductActivityError,
  GetReportsIdEcommerceProductActivityResponse,
  GetReportsIdEepurlData,
  GetReportsIdEepurlError,
  GetReportsIdEepurlResponse,
  GetReportsIdEmailActivityData,
  GetReportsIdEmailActivityError,
  GetReportsIdEmailActivityResponse,
  GetReportsIdEmailActivityIdData,
  GetReportsIdEmailActivityIdError,
  GetReportsIdEmailActivityIdResponse,
  GetReportsIdLocationsData,
  GetReportsIdLocationsError,
  GetReportsIdLocationsResponse,
  GetReportsIdOpenDetailsData,
  GetReportsIdOpenDetailsError,
  GetReportsIdOpenDetailsResponse,
  GetReportsIdOpenDetailsIdMembersIdData,
  GetReportsIdOpenDetailsIdMembersIdError,
  GetReportsIdOpenDetailsIdMembersIdResponse,
  GetReportsIdSentToData,
  GetReportsIdSentToError,
  GetReportsIdSentToResponse,
  GetReportsIdSentToIdData,
  GetReportsIdSentToIdError,
  GetReportsIdSentToIdResponse,
  GetReportsIdSubReportsIdData,
  GetReportsIdSubReportsIdError,
  GetReportsIdSubReportsIdResponse,
  GetReportsIdUnsubscribedData,
  GetReportsIdUnsubscribedError,
  GetReportsIdUnsubscribedResponse,
  GetReportsIdUnsubscribedIdData,
  GetReportsIdUnsubscribedIdError,
  GetReportsIdUnsubscribedIdResponse,
  GetSearchCampaignsData,
  GetSearchCampaignsError,
  GetSearchCampaignsResponse,
  GetSearchMembersData,
  GetSearchMembersError,
  GetSearchMembersResponse,
  GetTemplateFoldersData,
  GetTemplateFoldersError,
  GetTemplateFoldersResponse,
  PostTemplateFoldersData,
  PostTemplateFoldersError,
  PostTemplateFoldersResponse,
  DeleteTemplateFoldersIdData,
  DeleteTemplateFoldersIdError,
  DeleteTemplateFoldersIdResponse,
  GetTemplateFoldersIdData,
  GetTemplateFoldersIdError,
  GetTemplateFoldersIdResponse,
  PatchTemplateFoldersIdData,
  PatchTemplateFoldersIdError,
  PatchTemplateFoldersIdResponse,
  GetTemplatesData,
  GetTemplatesError,
  GetTemplatesResponse,
  PostTemplatesData,
  PostTemplatesError,
  PostTemplatesResponse,
  DeleteTemplatesIdData,
  DeleteTemplatesIdError,
  DeleteTemplatesIdResponse,
  GetTemplatesIdData,
  GetTemplatesIdError,
  GetTemplatesIdResponse,
  PatchTemplatesIdData,
  PatchTemplatesIdError,
  PatchTemplatesIdResponse,
  GetTemplatesIdDefaultContentData,
  GetTemplatesIdDefaultContentError,
  GetTemplatesIdDefaultContentResponse,
  GetVerifiedDomainsError,
  GetVerifiedDomainsResponse,
  CreateVerifiedDomainData,
  CreateVerifiedDomainError,
  CreateVerifiedDomainResponse,
  DeleteVerifiedDomainData,
  DeleteVerifiedDomainError,
  DeleteVerifiedDomainResponse,
  GetVerifiedDomainData,
  GetVerifiedDomainError,
  GetVerifiedDomainResponse,
  VerifyDomainData,
  VerifyDomainError,
  VerifyDomainResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * List api root resources
 * Get links to all other resources available in the API.
 */
export const getRoot = <ThrowOnError extends boolean = false>(options?: Options<GetRootData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetRootResponse, GetRootError, ThrowOnError>({
    ...options,
    url: '/',
  });
};

/**
 * List account exports
 * Get a list of account exports for a given account.
 */
export const getAccountExports = <ThrowOnError extends boolean = false>(
  options?: Options<GetAccountExportsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAccountExportsResponse, GetAccountExportsError, ThrowOnError>({
    ...options,
    url: '/account-exports',
  });
};

/**
 * Add export
 * Create a new account export in your Mailchimp account.
 */
export const postAccountExport = <ThrowOnError extends boolean = false>(
  options: Options<PostAccountExportData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostAccountExportResponse, PostAccountExportError, ThrowOnError>({
    ...options,
    url: '/account-exports',
  });
};

/**
 * Get account export info
 * Get information about a specific account export.
 */
export const getAccountExportId = <ThrowOnError extends boolean = false>(
  options: Options<GetAccountExportIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAccountExportIdResponse, GetAccountExportIdError, ThrowOnError>({
    ...options,
    url: '/account-exports/{export_id}',
  });
};

/**
 * Get latest chimp chatter
 * Return the Chimp Chatter for this account ordered by most recent.
 */
export const getActivityFeedChimpChatter = <ThrowOnError extends boolean = false>(
  options?: Options<GetActivityFeedChimpChatterData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetActivityFeedChimpChatterResponse,
    GetActivityFeedChimpChatterError,
    ThrowOnError
  >({
    ...options,
    url: '/activity-feed/chimp-chatter',
  });
};

/**
 * List authorized apps
 * Get a list of an account's registered, connected applications.
 */
export const getAuthorizedApps = <ThrowOnError extends boolean = false>(
  options?: Options<GetAuthorizedAppsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAuthorizedAppsResponse, GetAuthorizedAppsError, ThrowOnError>({
    ...options,
    url: '/authorized-apps',
  });
};

/**
 * Get authorized app info
 * Get information about a specific authorized application.
 */
export const getAuthorizedAppsId = <ThrowOnError extends boolean = false>(
  options: Options<GetAuthorizedAppsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAuthorizedAppsIdResponse, GetAuthorizedAppsIdError, ThrowOnError>({
    ...options,
    url: '/authorized-apps/{app_id}',
  });
};

/**
 * List automations
 * Get a summary of an account's classic automations.
 */
export const getAutomations = <ThrowOnError extends boolean = false>(
  options?: Options<GetAutomationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAutomationsResponse, GetAutomationsError, ThrowOnError>({
    ...options,
    url: '/automations',
  });
};

/**
 * Add automation
 * Create a new classic automation in your Mailchimp account.
 */
export const postAutomations = <ThrowOnError extends boolean = false>(
  options: Options<PostAutomationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostAutomationsResponse, PostAutomationsError, ThrowOnError>({
    ...options,
    url: '/automations',
  });
};

/**
 * Get automation info
 * Get a summary of an individual classic automation workflow's settings and content. The `trigger_settings` object returns information for the first email in the workflow.
 */
export const getAutomationsId = <ThrowOnError extends boolean = false>(
  options: Options<GetAutomationsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAutomationsIdResponse, GetAutomationsIdError, ThrowOnError>({
    ...options,
    url: '/automations/{workflow_id}',
  });
};

/**
 * Archive automation
 * Archiving will permanently end your automation and keep the report data. You’ll be able to replicate your archived automation, but you can’t restart it.
 */
export const archiveAutomations = <ThrowOnError extends boolean = false>(
  options: Options<ArchiveAutomationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ArchiveAutomationsResponse, ArchiveAutomationsError, ThrowOnError>({
    ...options,
    url: '/automations/{workflow_id}/actions/archive',
  });
};

/**
 * Pause automation emails
 * Pause all emails in a specific classic automation workflow.
 */
export const postAutomationsIdActionsPauseAllEmails = <ThrowOnError extends boolean = false>(
  options: Options<PostAutomationsIdActionsPauseAllEmailsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostAutomationsIdActionsPauseAllEmailsResponse,
    PostAutomationsIdActionsPauseAllEmailsError,
    ThrowOnError
  >({
    ...options,
    url: '/automations/{workflow_id}/actions/pause-all-emails',
  });
};

/**
 * Start automation emails
 * Start all emails in a classic automation workflow.
 */
export const postAutomationsIdActionsStartAllEmails = <ThrowOnError extends boolean = false>(
  options: Options<PostAutomationsIdActionsStartAllEmailsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostAutomationsIdActionsStartAllEmailsResponse,
    PostAutomationsIdActionsStartAllEmailsError,
    ThrowOnError
  >({
    ...options,
    url: '/automations/{workflow_id}/actions/start-all-emails',
  });
};

/**
 * List automated emails
 * Get a summary of the emails in a classic automation workflow.
 */
export const getAutomationsIdEmails = <ThrowOnError extends boolean = false>(
  options: Options<GetAutomationsIdEmailsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAutomationsIdEmailsResponse, GetAutomationsIdEmailsError, ThrowOnError>({
    ...options,
    url: '/automations/{workflow_id}/emails',
  });
};

/**
 * Delete workflow email
 * Removes an individual classic automation workflow email. Emails from certain workflow types, including the Abandoned Cart Email (abandonedCart) and Product Retargeting Email (abandonedBrowse) Workflows, cannot be deleted.
 */
export const deleteAutomationsIdEmailsId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteAutomationsIdEmailsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteAutomationsIdEmailsIdResponse,
    DeleteAutomationsIdEmailsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/automations/{workflow_id}/emails/{workflow_email_id}',
  });
};

/**
 * Get workflow email info
 * Get information about an individual classic automation workflow email.
 */
export const getAutomationsIdEmailsId = <ThrowOnError extends boolean = false>(
  options: Options<GetAutomationsIdEmailsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAutomationsIdEmailsIdResponse, GetAutomationsIdEmailsIdError, ThrowOnError>(
    {
      ...options,
      url: '/automations/{workflow_id}/emails/{workflow_email_id}',
    },
  );
};

/**
 * Update workflow email
 * Update settings for a classic automation workflow email.  Only works with workflows of type: abandonedBrowse, abandonedCart, emailFollowup, or singleWelcome.
 */
export const patchAutomationEmailWorkflowId = <ThrowOnError extends boolean = false>(
  options: Options<PatchAutomationEmailWorkflowIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchAutomationEmailWorkflowIdResponse,
    PatchAutomationEmailWorkflowIdError,
    ThrowOnError
  >({
    ...options,
    url: '/automations/{workflow_id}/emails/{workflow_email_id}',
  });
};

/**
 * Pause automated email
 * Pause an automated email.
 */
export const postAutomationsIdEmailsIdActionsPause = <ThrowOnError extends boolean = false>(
  options: Options<PostAutomationsIdEmailsIdActionsPauseData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostAutomationsIdEmailsIdActionsPauseResponse,
    PostAutomationsIdEmailsIdActionsPauseError,
    ThrowOnError
  >({
    ...options,
    url: '/automations/{workflow_id}/emails/{workflow_email_id}/actions/pause',
  });
};

/**
 * Start automated email
 * Start an automated email.
 */
export const postAutomationsIdEmailsIdActionsStart = <ThrowOnError extends boolean = false>(
  options: Options<PostAutomationsIdEmailsIdActionsStartData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostAutomationsIdEmailsIdActionsStartResponse,
    PostAutomationsIdEmailsIdActionsStartError,
    ThrowOnError
  >({
    ...options,
    url: '/automations/{workflow_id}/emails/{workflow_email_id}/actions/start',
  });
};

/**
 * List automated email subscribers
 * Get information about a classic automation email queue.
 */
export const getAutomationsIdEmailsIdQueue = <ThrowOnError extends boolean = false>(
  options: Options<GetAutomationsIdEmailsIdQueueData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetAutomationsIdEmailsIdQueueResponse,
    GetAutomationsIdEmailsIdQueueError,
    ThrowOnError
  >({
    ...options,
    url: '/automations/{workflow_id}/emails/{workflow_email_id}/queue',
  });
};

/**
 * Add subscriber to workflow email
 * Manually add a subscriber to a workflow, bypassing the default trigger settings. You can also use this endpoint to trigger a series of automated emails in an API 3.0 workflow type.
 */
export const postAutomationsIdEmailsIdQueue = <ThrowOnError extends boolean = false>(
  options: Options<PostAutomationsIdEmailsIdQueueData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostAutomationsIdEmailsIdQueueResponse,
    PostAutomationsIdEmailsIdQueueError,
    ThrowOnError
  >({
    ...options,
    url: '/automations/{workflow_id}/emails/{workflow_email_id}/queue',
  });
};

/**
 * Get automated email subscriber
 * Get information about a specific subscriber in a classic automation email queue.
 */
export const getAutomationsIdEmailsIdQueueId = <ThrowOnError extends boolean = false>(
  options: Options<GetAutomationsIdEmailsIdQueueIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetAutomationsIdEmailsIdQueueIdResponse,
    GetAutomationsIdEmailsIdQueueIdError,
    ThrowOnError
  >({
    ...options,
    url: '/automations/{workflow_id}/emails/{workflow_email_id}/queue/{subscriber_hash}',
  });
};

/**
 * List subscribers removed from workflow
 * Get information about subscribers who were removed from a classic automation workflow.
 */
export const getAutomationsIdRemovedSubscribers = <ThrowOnError extends boolean = false>(
  options: Options<GetAutomationsIdRemovedSubscribersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetAutomationsIdRemovedSubscribersResponse,
    GetAutomationsIdRemovedSubscribersError,
    ThrowOnError
  >({
    ...options,
    url: '/automations/{workflow_id}/removed-subscribers',
  });
};

/**
 * Remove subscriber from workflow
 * Remove a subscriber from a specific classic automation workflow. You can remove a subscriber at any point in an automation workflow, regardless of how many emails they've been sent from that workflow. Once they're removed, they can never be added back to the same workflow.
 */
export const postAutomationsIdRemovedSubscribers = <ThrowOnError extends boolean = false>(
  options: Options<PostAutomationsIdRemovedSubscribersData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostAutomationsIdRemovedSubscribersResponse,
    PostAutomationsIdRemovedSubscribersError,
    ThrowOnError
  >({
    ...options,
    url: '/automations/{workflow_id}/removed-subscribers',
  });
};

/**
 * Get subscriber removed from workflow
 * Get information about a specific subscriber who was removed from a classic automation workflow.
 */
export const getAutomationsIdRemovedSubscribersId = <ThrowOnError extends boolean = false>(
  options: Options<GetAutomationsIdRemovedSubscribersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetAutomationsIdRemovedSubscribersIdResponse,
    GetAutomationsIdRemovedSubscribersIdError,
    ThrowOnError
  >({
    ...options,
    url: '/automations/{workflow_id}/removed-subscribers/{subscriber_hash}',
  });
};

/**
 * List batch webhooks
 * Get all webhooks that have been configured for batches.
 */
export const getBatchWebhooks = <ThrowOnError extends boolean = false>(
  options?: Options<GetBatchWebhooksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetBatchWebhooksResponse, GetBatchWebhooksError, ThrowOnError>({
    ...options,
    url: '/batch-webhooks',
  });
};

/**
 * Add batch webhook
 * Configure a webhook that will fire whenever any batch request completes processing.  You may only have a maximum of 20 batch webhooks.
 */
export const postBatchWebhooks = <ThrowOnError extends boolean = false>(
  options: Options<PostBatchWebhooksData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostBatchWebhooksResponse, PostBatchWebhooksError, ThrowOnError>({
    ...options,
    url: '/batch-webhooks',
  });
};

/**
 * Delete batch webhook
 * Remove a batch webhook. Webhooks will no longer be sent to the given URL.
 */
export const deleteBatchWebhookId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteBatchWebhookIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteBatchWebhookIdResponse, DeleteBatchWebhookIdError, ThrowOnError>({
    ...options,
    url: '/batch-webhooks/{batch_webhook_id}',
  });
};

/**
 * Get batch webhook info
 * Get information about a specific batch webhook.
 */
export const getBatchWebhook = <ThrowOnError extends boolean = false>(
  options: Options<GetBatchWebhookData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetBatchWebhookResponse, GetBatchWebhookError, ThrowOnError>({
    ...options,
    url: '/batch-webhooks/{batch_webhook_id}',
  });
};

/**
 * Update batch webhook
 * Update a webhook that will fire whenever any batch request completes processing.
 */
export const patchBatchWebhooks = <ThrowOnError extends boolean = false>(
  options: Options<PatchBatchWebhooksData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchBatchWebhooksResponse, PatchBatchWebhooksError, ThrowOnError>({
    ...options,
    url: '/batch-webhooks/{batch_webhook_id}',
  });
};

/**
 * List batch requests
 * Get a summary of batch requests that have been made.
 */
export const getBatches = <ThrowOnError extends boolean = false>(options?: Options<GetBatchesData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetBatchesResponse, GetBatchesError, ThrowOnError>({
    ...options,
    url: '/batches',
  });
};

/**
 * Start batch operation
 * Begin processing a batch operations request.
 */
export const postBatches = <ThrowOnError extends boolean = false>(options: Options<PostBatchesData, ThrowOnError>) => {
  return (options?.client ?? client).post<PostBatchesResponse, PostBatchesError, ThrowOnError>({
    ...options,
    url: '/batches',
  });
};

/**
 * Delete batch request
 * Stops a batch request from running. Since only one batch request is run at a time, this can be used to cancel a long running request. The results of any completed operations will not be available after this call.
 */
export const deleteBatchesId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteBatchesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteBatchesIdResponse, DeleteBatchesIdError, ThrowOnError>({
    ...options,
    url: '/batches/{batch_id}',
  });
};

/**
 * Get batch operation status
 * Get the status of a batch request.
 */
export const getBatchesId = <ThrowOnError extends boolean = false>(
  options: Options<GetBatchesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetBatchesIdResponse, GetBatchesIdError, ThrowOnError>({
    ...options,
    url: '/batches/{batch_id}',
  });
};

/**
 * List campaign folders
 * Get all folders used to organize campaigns.
 */
export const getCampaignFolders = <ThrowOnError extends boolean = false>(
  options?: Options<GetCampaignFoldersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCampaignFoldersResponse, GetCampaignFoldersError, ThrowOnError>({
    ...options,
    url: '/campaign-folders',
  });
};

/**
 * Add campaign folder
 * Create a new campaign folder.
 */
export const postCampaignFolders = <ThrowOnError extends boolean = false>(
  options: Options<PostCampaignFoldersData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostCampaignFoldersResponse, PostCampaignFoldersError, ThrowOnError>({
    ...options,
    url: '/campaign-folders',
  });
};

/**
 * Delete campaign folder
 * Delete a specific campaign folder, and mark all the campaigns in the folder as 'unfiled'.
 */
export const deleteCampaignFoldersId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteCampaignFoldersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteCampaignFoldersIdResponse,
    DeleteCampaignFoldersIdError,
    ThrowOnError
  >({
    ...options,
    url: '/campaign-folders/{folder_id}',
  });
};

/**
 * Get campaign folder
 * Get information about a specific folder used to organize campaigns.
 */
export const getCampaignFoldersId = <ThrowOnError extends boolean = false>(
  options: Options<GetCampaignFoldersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCampaignFoldersIdResponse, GetCampaignFoldersIdError, ThrowOnError>({
    ...options,
    url: '/campaign-folders/{folder_id}',
  });
};

/**
 * Update campaign folder
 * Update a specific folder used to organize campaigns.
 */
export const patchCampaignFoldersId = <ThrowOnError extends boolean = false>(
  options: Options<PatchCampaignFoldersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchCampaignFoldersIdResponse, PatchCampaignFoldersIdError, ThrowOnError>({
    ...options,
    url: '/campaign-folders/{folder_id}',
  });
};

/**
 * List campaigns
 * Get all campaigns in an account.
 */
export const getCampaigns = <ThrowOnError extends boolean = false>(
  options?: Options<GetCampaignsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCampaignsResponse, GetCampaignsError, ThrowOnError>({
    ...options,
    url: '/campaigns',
  });
};

/**
 * Add campaign
 * Create a new Mailchimp campaign.
 */
export const postCampaigns = <ThrowOnError extends boolean = false>(
  options: Options<PostCampaignsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostCampaignsResponse, PostCampaignsError, ThrowOnError>({
    ...options,
    url: '/campaigns',
  });
};

/**
 * Delete campaign
 * Remove a campaign from your Mailchimp account.
 */
export const deleteCampaignsId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteCampaignsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteCampaignsIdResponse, DeleteCampaignsIdError, ThrowOnError>({
    ...options,
    url: '/campaigns/{campaign_id}',
  });
};

/**
 * Get campaign info
 * Get information about a specific campaign.
 */
export const getCampaignsId = <ThrowOnError extends boolean = false>(
  options: Options<GetCampaignsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCampaignsIdResponse, GetCampaignsIdError, ThrowOnError>({
    ...options,
    url: '/campaigns/{campaign_id}',
  });
};

/**
 * Update campaign settings
 * Update some or all of the settings for a specific campaign.
 */
export const patchCampaignsId = <ThrowOnError extends boolean = false>(
  options: Options<PatchCampaignsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchCampaignsIdResponse, PatchCampaignsIdError, ThrowOnError>({
    ...options,
    url: '/campaigns/{campaign_id}',
  });
};

/**
 * Cancel campaign
 * Cancel a Regular or Plain-Text Campaign after you send, before all of your recipients receive it. This feature is included with Mailchimp Pro.
 */
export const postCampaignsIdActionsCancelSend = <ThrowOnError extends boolean = false>(
  options: Options<PostCampaignsIdActionsCancelSendData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostCampaignsIdActionsCancelSendResponse,
    PostCampaignsIdActionsCancelSendError,
    ThrowOnError
  >({
    ...options,
    url: '/campaigns/{campaign_id}/actions/cancel-send',
  });
};

/**
 * Resend campaign
 * Creates a Resend to Non-Openers version of this campaign. We will also check if this campaign meets the criteria for Resend to Non-Openers campaigns.
 */
export const postCampaignsIdActionsCreateResend = <ThrowOnError extends boolean = false>(
  options: Options<PostCampaignsIdActionsCreateResendData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostCampaignsIdActionsCreateResendResponse,
    PostCampaignsIdActionsCreateResendError,
    ThrowOnError
  >({
    ...options,
    url: '/campaigns/{campaign_id}/actions/create-resend',
  });
};

/**
 * Pause rss campaign
 * Pause an RSS-Driven campaign.
 */
export const postCampaignsIdActionsPause = <ThrowOnError extends boolean = false>(
  options: Options<PostCampaignsIdActionsPauseData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostCampaignsIdActionsPauseResponse,
    PostCampaignsIdActionsPauseError,
    ThrowOnError
  >({
    ...options,
    url: '/campaigns/{campaign_id}/actions/pause',
  });
};

/**
 * Replicate campaign
 * Replicate a campaign in saved or send status.
 */
export const postCampaignsIdActionsReplicate = <ThrowOnError extends boolean = false>(
  options: Options<PostCampaignsIdActionsReplicateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostCampaignsIdActionsReplicateResponse,
    PostCampaignsIdActionsReplicateError,
    ThrowOnError
  >({
    ...options,
    url: '/campaigns/{campaign_id}/actions/replicate',
  });
};

/**
 * Resume rss campaign
 * Resume an RSS-Driven campaign.
 */
export const postCampaignsIdActionsResume = <ThrowOnError extends boolean = false>(
  options: Options<PostCampaignsIdActionsResumeData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostCampaignsIdActionsResumeResponse,
    PostCampaignsIdActionsResumeError,
    ThrowOnError
  >({
    ...options,
    url: '/campaigns/{campaign_id}/actions/resume',
  });
};

/**
 * Schedule campaign
 * Schedule a campaign for delivery. If you're using Multivariate Campaigns to test send times or sending RSS Campaigns, use the send action instead.
 */
export const postCampaignsIdActionsSchedule = <ThrowOnError extends boolean = false>(
  options: Options<PostCampaignsIdActionsScheduleData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostCampaignsIdActionsScheduleResponse,
    PostCampaignsIdActionsScheduleError,
    ThrowOnError
  >({
    ...options,
    url: '/campaigns/{campaign_id}/actions/schedule',
  });
};

/**
 * Send campaign
 * Send a Mailchimp campaign. For RSS Campaigns, the campaign will send according to its schedule. All other campaigns will send immediately.
 */
export const postCampaignsIdActionsSend = <ThrowOnError extends boolean = false>(
  options: Options<PostCampaignsIdActionsSendData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostCampaignsIdActionsSendResponse,
    PostCampaignsIdActionsSendError,
    ThrowOnError
  >({
    ...options,
    url: '/campaigns/{campaign_id}/actions/send',
  });
};

/**
 * Send test email
 * Send a test email.
 */
export const postCampaignsIdActionsTest = <ThrowOnError extends boolean = false>(
  options: Options<PostCampaignsIdActionsTestData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostCampaignsIdActionsTestResponse,
    PostCampaignsIdActionsTestError,
    ThrowOnError
  >({
    ...options,
    url: '/campaigns/{campaign_id}/actions/test',
  });
};

/**
 * Unschedule campaign
 * Unschedule a scheduled campaign that hasn't started sending.
 */
export const postCampaignsIdActionsUnschedule = <ThrowOnError extends boolean = false>(
  options: Options<PostCampaignsIdActionsUnscheduleData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostCampaignsIdActionsUnscheduleResponse,
    PostCampaignsIdActionsUnscheduleError,
    ThrowOnError
  >({
    ...options,
    url: '/campaigns/{campaign_id}/actions/unschedule',
  });
};

/**
 * Get campaign content
 * Get the the HTML and plain-text content for a campaign.
 */
export const getCampaignsIdContent = <ThrowOnError extends boolean = false>(
  options: Options<GetCampaignsIdContentData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCampaignsIdContentResponse, GetCampaignsIdContentError, ThrowOnError>({
    ...options,
    url: '/campaigns/{campaign_id}/content',
  });
};

/**
 * Set campaign content
 * Set the content for a campaign.
 */
export const putCampaignsIdContent = <ThrowOnError extends boolean = false>(
  options: Options<PutCampaignsIdContentData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutCampaignsIdContentResponse, PutCampaignsIdContentError, ThrowOnError>({
    ...options,
    url: '/campaigns/{campaign_id}/content',
  });
};

/**
 * List campaign feedback
 * Get team feedback while you're working together on a Mailchimp campaign.
 */
export const getCampaignsIdFeedback = <ThrowOnError extends boolean = false>(
  options: Options<GetCampaignsIdFeedbackData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCampaignsIdFeedbackResponse, GetCampaignsIdFeedbackError, ThrowOnError>({
    ...options,
    url: '/campaigns/{campaign_id}/feedback',
  });
};

/**
 * Add campaign feedback
 * Add feedback on a specific campaign.
 */
export const postCampaignsIdFeedback = <ThrowOnError extends boolean = false>(
  options: Options<PostCampaignsIdFeedbackData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostCampaignsIdFeedbackResponse, PostCampaignsIdFeedbackError, ThrowOnError>({
    ...options,
    url: '/campaigns/{campaign_id}/feedback',
  });
};

/**
 * Delete campaign feedback message
 * Remove a specific feedback message for a campaign.
 */
export const deleteCampaignsIdFeedbackId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteCampaignsIdFeedbackIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteCampaignsIdFeedbackIdResponse,
    DeleteCampaignsIdFeedbackIdError,
    ThrowOnError
  >({
    ...options,
    url: '/campaigns/{campaign_id}/feedback/{feedback_id}',
  });
};

/**
 * Get campaign feedback message
 * Get a specific feedback message from a campaign.
 */
export const getCampaignsIdFeedbackId = <ThrowOnError extends boolean = false>(
  options: Options<GetCampaignsIdFeedbackIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCampaignsIdFeedbackIdResponse, GetCampaignsIdFeedbackIdError, ThrowOnError>(
    {
      ...options,
      url: '/campaigns/{campaign_id}/feedback/{feedback_id}',
    },
  );
};

/**
 * Update campaign feedback message
 * Update a specific feedback message for a campaign.
 */
export const patchCampaignsIdFeedbackId = <ThrowOnError extends boolean = false>(
  options: Options<PatchCampaignsIdFeedbackIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchCampaignsIdFeedbackIdResponse,
    PatchCampaignsIdFeedbackIdError,
    ThrowOnError
  >({
    ...options,
    url: '/campaigns/{campaign_id}/feedback/{feedback_id}',
  });
};

/**
 * Get campaign send checklist
 * Review the send checklist for a campaign, and resolve any issues before sending.
 */
export const getCampaignsIdSendChecklist = <ThrowOnError extends boolean = false>(
  options: Options<GetCampaignsIdSendChecklistData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetCampaignsIdSendChecklistResponse,
    GetCampaignsIdSendChecklistError,
    ThrowOnError
  >({
    ...options,
    url: '/campaigns/{campaign_id}/send-checklist',
  });
};

/**
 * List connected sites
 * Get all connected sites in an account.
 */
export const getConnectedSites = <ThrowOnError extends boolean = false>(
  options?: Options<GetConnectedSitesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetConnectedSitesResponse, GetConnectedSitesError, ThrowOnError>({
    ...options,
    url: '/connected-sites',
  });
};

/**
 * Add connected site
 * Create a new Mailchimp connected site.
 */
export const postConnectedSites = <ThrowOnError extends boolean = false>(
  options: Options<PostConnectedSitesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostConnectedSitesResponse, PostConnectedSitesError, ThrowOnError>({
    ...options,
    url: '/connected-sites',
  });
};

/**
 * Delete connected site
 * Remove a connected site from your Mailchimp account.
 */
export const deleteConnectedSitesId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteConnectedSitesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteConnectedSitesIdResponse, DeleteConnectedSitesIdError, ThrowOnError>({
    ...options,
    url: '/connected-sites/{connected_site_id}',
  });
};

/**
 * Get connected site
 * Get information about a specific connected site.
 */
export const getConnectedSitesId = <ThrowOnError extends boolean = false>(
  options: Options<GetConnectedSitesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetConnectedSitesIdResponse, GetConnectedSitesIdError, ThrowOnError>({
    ...options,
    url: '/connected-sites/{connected_site_id}',
  });
};

/**
 * Verify connected site script
 * Verify that the connected sites script has been installed, either via the script URL or fragment.
 */
export const postConnectedSitesIdActionsVerifyScriptInstallation = <ThrowOnError extends boolean = false>(
  options: Options<PostConnectedSitesIdActionsVerifyScriptInstallationData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostConnectedSitesIdActionsVerifyScriptInstallationResponse,
    PostConnectedSitesIdActionsVerifyScriptInstallationError,
    ThrowOnError
  >({
    ...options,
    url: '/connected-sites/{connected_site_id}/actions/verify-script-installation',
  });
};

/**
 * @deprecated
 * List conversations
 * Get a list of conversations for the account. Conversations has been deprecated in favor of Inbox and these endpoints don't include Inbox data. Past Conversations are still available via this endpoint, but new campaign replies and other Inbox messages aren’t available using this endpoint.
 */
export const getConversations = <ThrowOnError extends boolean = false>(
  options?: Options<GetConversationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetConversationsResponse, GetConversationsError, ThrowOnError>({
    ...options,
    url: '/conversations',
  });
};

/**
 * @deprecated
 * Get conversation
 * Get details about an individual conversation. Conversations has been deprecated in favor of Inbox and these endpoints don't include Inbox data. Past Conversations are still available via this endpoint, but new campaign replies and other Inbox messages aren’t available using this endpoint.
 */
export const getConversationsId = <ThrowOnError extends boolean = false>(
  options: Options<GetConversationsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetConversationsIdResponse, GetConversationsIdError, ThrowOnError>({
    ...options,
    url: '/conversations/{conversation_id}',
  });
};

/**
 * @deprecated
 * List messages
 * Get messages from a specific conversation. Conversations has been deprecated in favor of Inbox and these endpoints don't include Inbox data. Past Conversations are still available via this endpoint, but new campaign replies and other Inbox messages aren’t available using this endpoint.
 */
export const getConversationsIdMessages = <ThrowOnError extends boolean = false>(
  options: Options<GetConversationsIdMessagesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetConversationsIdMessagesResponse,
    GetConversationsIdMessagesError,
    ThrowOnError
  >({
    ...options,
    url: '/conversations/{conversation_id}/messages',
  });
};

/**
 * @deprecated
 * Get message
 * Get an individual message in a conversation. Conversations has been deprecated in favor of Inbox and these endpoints don't include Inbox data. Past Conversations are still available via this endpoint, but new campaign replies and other Inbox messages aren’t available using this endpoint.
 */
export const getConversationsIdMessagesId = <ThrowOnError extends boolean = false>(
  options: Options<GetConversationsIdMessagesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetConversationsIdMessagesIdResponse,
    GetConversationsIdMessagesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/conversations/{conversation_id}/messages/{message_id}',
  });
};

/**
 * Customer Journeys API trigger for a contact
 * A step trigger in a Customer Journey. To use it, create a starting point or step from the Customer Journey builder in the app using the Customer Journeys API condition. We’ll provide a url during the process that includes the {journey_id} and {step_id}. You’ll then be able to use this endpoint to trigger the condition for the posted contact.
 */
export const postCustomerJourneysJourneysIdStepsIdActionsTrigger = <ThrowOnError extends boolean = false>(
  options: Options<PostCustomerJourneysJourneysIdStepsIdActionsTriggerData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostCustomerJourneysJourneysIdStepsIdActionsTriggerResponse,
    PostCustomerJourneysJourneysIdStepsIdActionsTriggerError,
    ThrowOnError
  >({
    ...options,
    url: '/customer-journeys/journeys/{journey_id}/steps/{step_id}/actions/trigger',
  });
};

/**
 * List account orders
 * Get information about an account's orders.
 */
export const getEcommerceOrders = <ThrowOnError extends boolean = false>(
  options?: Options<GetEcommerceOrdersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetEcommerceOrdersResponse, GetEcommerceOrdersError, ThrowOnError>({
    ...options,
    url: '/ecommerce/orders',
  });
};

/**
 * List stores
 * Get information about all stores in the account.
 */
export const getEcommerceStores = <ThrowOnError extends boolean = false>(
  options?: Options<GetEcommerceStoresData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetEcommerceStoresResponse, GetEcommerceStoresError, ThrowOnError>({
    ...options,
    url: '/ecommerce/stores',
  });
};

/**
 * Add store
 * Add a new store to your Mailchimp account.
 */
export const postEcommerceStores = <ThrowOnError extends boolean = false>(
  options: Options<PostEcommerceStoresData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostEcommerceStoresResponse, PostEcommerceStoresError, ThrowOnError>({
    ...options,
    url: '/ecommerce/stores',
  });
};

/**
 * Delete store
 * Delete a store. Deleting a store will also delete any associated subresources, including Customers, Orders, Products, and Carts.
 */
export const deleteEcommerceStoresId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteEcommerceStoresIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteEcommerceStoresIdResponse,
    DeleteEcommerceStoresIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}',
  });
};

/**
 * Get store info
 * Get information about a specific store.
 */
export const getEcommerceStoresId = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetEcommerceStoresIdResponse, GetEcommerceStoresIdError, ThrowOnError>({
    ...options,
    url: '/ecommerce/stores/{store_id}',
  });
};

/**
 * Update store
 * Update a store.
 */
export const patchEcommerceStoresId = <ThrowOnError extends boolean = false>(
  options: Options<PatchEcommerceStoresIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchEcommerceStoresIdResponse, PatchEcommerceStoresIdError, ThrowOnError>({
    ...options,
    url: '/ecommerce/stores/{store_id}',
  });
};

/**
 * List carts
 * Get information about a store's carts.
 */
export const getEcommerceStoresIdCarts = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdCartsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdCartsResponse,
    GetEcommerceStoresIdCartsError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/carts',
  });
};

/**
 * Add cart
 * Add a new cart to a store.
 */
export const postEcommerceStoresIdCarts = <ThrowOnError extends boolean = false>(
  options: Options<PostEcommerceStoresIdCartsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostEcommerceStoresIdCartsResponse,
    PostEcommerceStoresIdCartsError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/carts',
  });
};

/**
 * Delete cart
 * Delete a cart.
 */
export const deleteEcommerceStoresIdCartsId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteEcommerceStoresIdCartsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteEcommerceStoresIdCartsIdResponse,
    DeleteEcommerceStoresIdCartsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/carts/{cart_id}',
  });
};

/**
 * Get cart info
 * Get information about a specific cart.
 */
export const getEcommerceStoresIdCartsId = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdCartsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdCartsIdResponse,
    GetEcommerceStoresIdCartsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/carts/{cart_id}',
  });
};

/**
 * Update cart
 * Update a specific cart.
 */
export const patchEcommerceStoresIdCartsId = <ThrowOnError extends boolean = false>(
  options: Options<PatchEcommerceStoresIdCartsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchEcommerceStoresIdCartsIdResponse,
    PatchEcommerceStoresIdCartsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/carts/{cart_id}',
  });
};

/**
 * List cart line items
 * Get information about a cart's line items.
 */
export const getEcommerceStoresIdCartsIdLines = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdCartsIdLinesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdCartsIdLinesResponse,
    GetEcommerceStoresIdCartsIdLinesError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/carts/{cart_id}/lines',
  });
};

/**
 * Add cart line item
 * Add a new line item to an existing cart.
 */
export const postEcommerceStoresIdCartsIdLines = <ThrowOnError extends boolean = false>(
  options: Options<PostEcommerceStoresIdCartsIdLinesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostEcommerceStoresIdCartsIdLinesResponse,
    PostEcommerceStoresIdCartsIdLinesError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/carts/{cart_id}/lines',
  });
};

/**
 * Delete cart line item
 * Delete a specific cart line item.
 */
export const deleteEcommerceStoresIdCartsLinesId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteEcommerceStoresIdCartsLinesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteEcommerceStoresIdCartsLinesIdResponse,
    DeleteEcommerceStoresIdCartsLinesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/carts/{cart_id}/lines/{line_id}',
  });
};

/**
 * Get cart line item
 * Get information about a specific cart line item.
 */
export const getEcommerceStoresIdCartsIdLinesId = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdCartsIdLinesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdCartsIdLinesIdResponse,
    GetEcommerceStoresIdCartsIdLinesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/carts/{cart_id}/lines/{line_id}',
  });
};

/**
 * Update cart line item
 * Update a specific cart line item.
 */
export const patchEcommerceStoresIdCartsIdLinesId = <ThrowOnError extends boolean = false>(
  options: Options<PatchEcommerceStoresIdCartsIdLinesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchEcommerceStoresIdCartsIdLinesIdResponse,
    PatchEcommerceStoresIdCartsIdLinesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/carts/{cart_id}/lines/{line_id}',
  });
};

/**
 * List customers
 * Get information about a store's customers.
 */
export const getEcommerceStoresIdCustomers = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdCustomersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdCustomersResponse,
    GetEcommerceStoresIdCustomersError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/customers',
  });
};

/**
 * Add customer
 * Add a new customer to a store.
 */
export const postEcommerceStoresIdCustomers = <ThrowOnError extends boolean = false>(
  options: Options<PostEcommerceStoresIdCustomersData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostEcommerceStoresIdCustomersResponse,
    PostEcommerceStoresIdCustomersError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/customers',
  });
};

/**
 * Delete customer
 * Delete a customer from a store.
 */
export const deleteEcommerceStoresIdCustomersId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteEcommerceStoresIdCustomersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteEcommerceStoresIdCustomersIdResponse,
    DeleteEcommerceStoresIdCustomersIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/customers/{customer_id}',
  });
};

/**
 * Get customer info
 * Get information about a specific customer.
 */
export const getEcommerceStoresIdCustomersId = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdCustomersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdCustomersIdResponse,
    GetEcommerceStoresIdCustomersIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/customers/{customer_id}',
  });
};

/**
 * Update customer
 * Update a customer.
 */
export const patchEcommerceStoresIdCustomersId = <ThrowOnError extends boolean = false>(
  options: Options<PatchEcommerceStoresIdCustomersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchEcommerceStoresIdCustomersIdResponse,
    PatchEcommerceStoresIdCustomersIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/customers/{customer_id}',
  });
};

/**
 * Add or update customer
 * Add or update a customer.
 */
export const putEcommerceStoresIdCustomersId = <ThrowOnError extends boolean = false>(
  options: Options<PutEcommerceStoresIdCustomersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutEcommerceStoresIdCustomersIdResponse,
    PutEcommerceStoresIdCustomersIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/customers/{customer_id}',
  });
};

/**
 * List orders
 * Get information about a store's orders.
 */
export const getEcommerceStoresIdOrders = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdOrdersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdOrdersResponse,
    GetEcommerceStoresIdOrdersError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/orders',
  });
};

/**
 * Add order
 * Add a new order to a store.
 */
export const postEcommerceStoresIdOrders = <ThrowOnError extends boolean = false>(
  options: Options<PostEcommerceStoresIdOrdersData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostEcommerceStoresIdOrdersResponse,
    PostEcommerceStoresIdOrdersError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/orders',
  });
};

/**
 * Delete order
 * Delete an order.
 */
export const deleteEcommerceStoresIdOrdersId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteEcommerceStoresIdOrdersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteEcommerceStoresIdOrdersIdResponse,
    DeleteEcommerceStoresIdOrdersIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/orders/{order_id}',
  });
};

/**
 * Get order info
 * Get information about a specific order.
 */
export const getEcommerceStoresIdOrdersId = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdOrdersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdOrdersIdResponse,
    GetEcommerceStoresIdOrdersIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/orders/{order_id}',
  });
};

/**
 * Update order
 * Update a specific order.
 */
export const patchEcommerceStoresIdOrdersId = <ThrowOnError extends boolean = false>(
  options: Options<PatchEcommerceStoresIdOrdersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchEcommerceStoresIdOrdersIdResponse,
    PatchEcommerceStoresIdOrdersIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/orders/{order_id}',
  });
};

/**
 * List order line items
 * Get information about an order's line items.
 */
export const getEcommerceStoresIdOrdersIdLines = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdOrdersIdLinesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdOrdersIdLinesResponse,
    GetEcommerceStoresIdOrdersIdLinesError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/orders/{order_id}/lines',
  });
};

/**
 * Add order line item
 * Add a new line item to an existing order.
 */
export const postEcommerceStoresIdOrdersIdLines = <ThrowOnError extends boolean = false>(
  options: Options<PostEcommerceStoresIdOrdersIdLinesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostEcommerceStoresIdOrdersIdLinesResponse,
    PostEcommerceStoresIdOrdersIdLinesError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/orders/{order_id}/lines',
  });
};

/**
 * Delete order line item
 * Delete a specific order line item.
 */
export const deleteEcommerceStoresIdOrdersIdLinesId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteEcommerceStoresIdOrdersIdLinesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteEcommerceStoresIdOrdersIdLinesIdResponse,
    DeleteEcommerceStoresIdOrdersIdLinesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/orders/{order_id}/lines/{line_id}',
  });
};

/**
 * Get order line item
 * Get information about a specific order line item.
 */
export const getEcommerceStoresIdOrdersIdLinesId = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdOrdersIdLinesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdOrdersIdLinesIdResponse,
    GetEcommerceStoresIdOrdersIdLinesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/orders/{order_id}/lines/{line_id}',
  });
};

/**
 * Update order line item
 * Update a specific order line item.
 */
export const patchEcommerceStoresIdOrdersIdLinesId = <ThrowOnError extends boolean = false>(
  options: Options<PatchEcommerceStoresIdOrdersIdLinesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchEcommerceStoresIdOrdersIdLinesIdResponse,
    PatchEcommerceStoresIdOrdersIdLinesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/orders/{order_id}/lines/{line_id}',
  });
};

/**
 * List product
 * Get information about a store's products.
 */
export const getEcommerceStoresIdProducts = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdProductsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdProductsResponse,
    GetEcommerceStoresIdProductsError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/products',
  });
};

/**
 * Add product
 * Add a new product to a store.
 */
export const postEcommerceStoresIdProducts = <ThrowOnError extends boolean = false>(
  options: Options<PostEcommerceStoresIdProductsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostEcommerceStoresIdProductsResponse,
    PostEcommerceStoresIdProductsError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/products',
  });
};

/**
 * Delete product
 * Delete a product.
 */
export const deleteEcommerceStoresIdProductsId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteEcommerceStoresIdProductsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteEcommerceStoresIdProductsIdResponse,
    DeleteEcommerceStoresIdProductsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/products/{product_id}',
  });
};

/**
 * Get product info
 * Get information about a specific product.
 */
export const getEcommerceStoresIdProductsId = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdProductsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdProductsIdResponse,
    GetEcommerceStoresIdProductsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/products/{product_id}',
  });
};

/**
 * Update product
 * Update a specific product.
 */
export const patchEcommerceStoresIdProductsId = <ThrowOnError extends boolean = false>(
  options: Options<PatchEcommerceStoresIdProductsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchEcommerceStoresIdProductsIdResponse,
    PatchEcommerceStoresIdProductsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/products/{product_id}',
  });
};

/**
 * List product images
 * Get information about a product's images.
 */
export const getEcommerceStoresIdProductsIdImages = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdProductsIdImagesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdProductsIdImagesResponse,
    GetEcommerceStoresIdProductsIdImagesError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/products/{product_id}/images',
  });
};

/**
 * Add product image
 * Add a new image to the product.
 */
export const postEcommerceStoresIdProductsIdImages = <ThrowOnError extends boolean = false>(
  options: Options<PostEcommerceStoresIdProductsIdImagesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostEcommerceStoresIdProductsIdImagesResponse,
    PostEcommerceStoresIdProductsIdImagesError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/products/{product_id}/images',
  });
};

/**
 * Delete product image
 * Delete a product image.
 */
export const deleteEcommerceStoresIdProductsIdImagesId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteEcommerceStoresIdProductsIdImagesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteEcommerceStoresIdProductsIdImagesIdResponse,
    DeleteEcommerceStoresIdProductsIdImagesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/products/{product_id}/images/{image_id}',
  });
};

/**
 * Get product image info
 * Get information about a specific product image.
 */
export const getEcommerceStoresIdProductsIdImagesId = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdProductsIdImagesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdProductsIdImagesIdResponse,
    GetEcommerceStoresIdProductsIdImagesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/products/{product_id}/images/{image_id}',
  });
};

/**
 * Update product image
 * Update a product image.
 */
export const patchEcommerceStoresIdProductsIdImagesId = <ThrowOnError extends boolean = false>(
  options: Options<PatchEcommerceStoresIdProductsIdImagesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchEcommerceStoresIdProductsIdImagesIdResponse,
    PatchEcommerceStoresIdProductsIdImagesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/products/{product_id}/images/{image_id}',
  });
};

/**
 * List product variants
 * Get information about a product's variants.
 */
export const getEcommerceStoresIdProductsIdVariants = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdProductsIdVariantsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdProductsIdVariantsResponse,
    GetEcommerceStoresIdProductsIdVariantsError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/products/{product_id}/variants',
  });
};

/**
 * Add product variant
 * Add a new variant to the product.
 */
export const postEcommerceStoresIdProductsIdVariants = <ThrowOnError extends boolean = false>(
  options: Options<PostEcommerceStoresIdProductsIdVariantsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostEcommerceStoresIdProductsIdVariantsResponse,
    PostEcommerceStoresIdProductsIdVariantsError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/products/{product_id}/variants',
  });
};

/**
 * Delete product variant
 * Delete a product variant.
 */
export const deleteEcommerceStoresIdProductsIdVariantsId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteEcommerceStoresIdProductsIdVariantsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteEcommerceStoresIdProductsIdVariantsIdResponse,
    DeleteEcommerceStoresIdProductsIdVariantsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/products/{product_id}/variants/{variant_id}',
  });
};

/**
 * Get product variant info
 * Get information about a specific product variant.
 */
export const getEcommerceStoresIdProductsIdVariantsId = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdProductsIdVariantsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdProductsIdVariantsIdResponse,
    GetEcommerceStoresIdProductsIdVariantsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/products/{product_id}/variants/{variant_id}',
  });
};

/**
 * Update product variant
 * Update a product variant.
 */
export const patchEcommerceStoresIdProductsIdVariantsId = <ThrowOnError extends boolean = false>(
  options: Options<PatchEcommerceStoresIdProductsIdVariantsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchEcommerceStoresIdProductsIdVariantsIdResponse,
    PatchEcommerceStoresIdProductsIdVariantsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/products/{product_id}/variants/{variant_id}',
  });
};

/**
 * Add or update product variant
 * Add or update a product variant.
 */
export const putEcommerceStoresIdProductsIdVariantsId = <ThrowOnError extends boolean = false>(
  options: Options<PutEcommerceStoresIdProductsIdVariantsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutEcommerceStoresIdProductsIdVariantsIdResponse,
    PutEcommerceStoresIdProductsIdVariantsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/products/{product_id}/variants/{variant_id}',
  });
};

/**
 * List promo rules
 * Get information about a store's promo rules.
 */
export const getEcommerceStoresIdPromorules = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdPromorulesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdPromorulesResponse,
    GetEcommerceStoresIdPromorulesError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/promo-rules',
  });
};

/**
 * Add promo rule
 * Add a new promo rule to a store.
 */
export const postEcommerceStoresIdPromorules = <ThrowOnError extends boolean = false>(
  options: Options<PostEcommerceStoresIdPromorulesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostEcommerceStoresIdPromorulesResponse,
    PostEcommerceStoresIdPromorulesError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/promo-rules',
  });
};

/**
 * Delete promo rule
 * Delete a promo rule from a store.
 */
export const deleteEcommerceStoresIdPromorulesId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteEcommerceStoresIdPromorulesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteEcommerceStoresIdPromorulesIdResponse,
    DeleteEcommerceStoresIdPromorulesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/promo-rules/{promo_rule_id}',
  });
};

/**
 * Get promo rule
 * Get information about a specific promo rule.
 */
export const getEcommerceStoresIdPromorulesId = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdPromorulesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdPromorulesIdResponse,
    GetEcommerceStoresIdPromorulesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/promo-rules/{promo_rule_id}',
  });
};

/**
 * Update promo rule
 * Update a promo rule.
 */
export const patchEcommerceStoresIdPromorulesId = <ThrowOnError extends boolean = false>(
  options: Options<PatchEcommerceStoresIdPromorulesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchEcommerceStoresIdPromorulesIdResponse,
    PatchEcommerceStoresIdPromorulesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/promo-rules/{promo_rule_id}',
  });
};

/**
 * List promo codes
 * Get information about a store's promo codes.
 */
export const getEcommerceStoresIdPromocodes = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdPromocodesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdPromocodesResponse,
    GetEcommerceStoresIdPromocodesError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/promo-rules/{promo_rule_id}/promo-codes',
  });
};

/**
 * Add promo code
 * Add a new promo code to a store.
 */
export const postEcommerceStoresIdPromocodes = <ThrowOnError extends boolean = false>(
  options: Options<PostEcommerceStoresIdPromocodesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostEcommerceStoresIdPromocodesResponse,
    PostEcommerceStoresIdPromocodesError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/promo-rules/{promo_rule_id}/promo-codes',
  });
};

/**
 * Delete promo code
 * Delete a promo code from a store.
 */
export const deleteEcommerceStoresIdPromocodesId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteEcommerceStoresIdPromocodesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteEcommerceStoresIdPromocodesIdResponse,
    DeleteEcommerceStoresIdPromocodesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/promo-rules/{promo_rule_id}/promo-codes/{promo_code_id}',
  });
};

/**
 * Get promo code
 * Get information about a specific promo code.
 */
export const getEcommerceStoresIdPromocodesId = <ThrowOnError extends boolean = false>(
  options: Options<GetEcommerceStoresIdPromocodesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetEcommerceStoresIdPromocodesIdResponse,
    GetEcommerceStoresIdPromocodesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/promo-rules/{promo_rule_id}/promo-codes/{promo_code_id}',
  });
};

/**
 * Update promo code
 * Update a promo code.
 */
export const patchEcommerceStoresIdPromocodesId = <ThrowOnError extends boolean = false>(
  options: Options<PatchEcommerceStoresIdPromocodesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchEcommerceStoresIdPromocodesIdResponse,
    PatchEcommerceStoresIdPromocodesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/ecommerce/stores/{store_id}/promo-rules/{promo_rule_id}/promo-codes/{promo_code_id}',
  });
};

/**
 * List facebook ads
 * Get list of Facebook ads.
 */
export const getAllFacebookAds = <ThrowOnError extends boolean = false>(
  options?: Options<GetAllFacebookAdsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAllFacebookAdsResponse, GetAllFacebookAdsError, ThrowOnError>({
    ...options,
    url: '/facebook-ads',
  });
};

/**
 * Get facebook ad info
 * Get details of a Facebook ad.
 */
export const getFacebookAdsId = <ThrowOnError extends boolean = false>(
  options: Options<GetFacebookAdsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetFacebookAdsIdResponse, GetFacebookAdsIdError, ThrowOnError>({
    ...options,
    url: '/facebook-ads/{outreach_id}',
  });
};

/**
 * List stored files
 * Get a list of available images and files stored in the File Manager for the account.
 */
export const getFileManagerFiles = <ThrowOnError extends boolean = false>(
  options?: Options<GetFileManagerFilesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetFileManagerFilesResponse, GetFileManagerFilesError, ThrowOnError>({
    ...options,
    url: '/file-manager/files',
  });
};

/**
 * Add file
 * Upload a new image or file to the File Manager.
 */
export const postFileManagerFiles = <ThrowOnError extends boolean = false>(
  options: Options<PostFileManagerFilesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostFileManagerFilesResponse, PostFileManagerFilesError, ThrowOnError>({
    ...options,
    url: '/file-manager/files',
  });
};

/**
 * Delete file
 * Remove a specific file from the File Manager.
 */
export const deleteFileManagerFilesId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteFileManagerFilesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteFileManagerFilesIdResponse,
    DeleteFileManagerFilesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/file-manager/files/{file_id}',
  });
};

/**
 * Get file
 * Get information about a specific file in the File Manager.
 */
export const getFileManagerFilesId = <ThrowOnError extends boolean = false>(
  options: Options<GetFileManagerFilesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetFileManagerFilesIdResponse, GetFileManagerFilesIdError, ThrowOnError>({
    ...options,
    url: '/file-manager/files/{file_id}',
  });
};

/**
 * Update file
 * Update a file in the File Manager.
 */
export const patchFileManagerFilesId = <ThrowOnError extends boolean = false>(
  options: Options<PatchFileManagerFilesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchFileManagerFilesIdResponse, PatchFileManagerFilesIdError, ThrowOnError>(
    {
      ...options,
      url: '/file-manager/files/{file_id}',
    },
  );
};

/**
 * List folders
 * Get a list of all folders in the File Manager.
 */
export const getFileManagerFolders = <ThrowOnError extends boolean = false>(
  options?: Options<GetFileManagerFoldersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetFileManagerFoldersResponse, GetFileManagerFoldersError, ThrowOnError>({
    ...options,
    url: '/file-manager/folders',
  });
};

/**
 * Add folder
 * Create a new folder in the File Manager.
 */
export const postFileManagerFolders = <ThrowOnError extends boolean = false>(
  options: Options<PostFileManagerFoldersData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostFileManagerFoldersResponse, PostFileManagerFoldersError, ThrowOnError>({
    ...options,
    url: '/file-manager/folders',
  });
};

/**
 * Delete folder
 * Delete a specific folder in the File Manager.
 */
export const deleteFileManagerFoldersId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteFileManagerFoldersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteFileManagerFoldersIdResponse,
    DeleteFileManagerFoldersIdError,
    ThrowOnError
  >({
    ...options,
    url: '/file-manager/folders/{folder_id}',
  });
};

/**
 * Get folder
 * Get information about a specific folder in the File Manager.
 */
export const getFileManagerFoldersId = <ThrowOnError extends boolean = false>(
  options: Options<GetFileManagerFoldersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetFileManagerFoldersIdResponse, GetFileManagerFoldersIdError, ThrowOnError>({
    ...options,
    url: '/file-manager/folders/{folder_id}',
  });
};

/**
 * Update folder
 * Update a specific File Manager folder.
 */
export const patchFileManagerFoldersId = <ThrowOnError extends boolean = false>(
  options: Options<PatchFileManagerFoldersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchFileManagerFoldersIdResponse,
    PatchFileManagerFoldersIdError,
    ThrowOnError
  >({
    ...options,
    url: '/file-manager/folders/{folder_id}',
  });
};

/**
 * List stored files
 * Get a list of available images and files stored in this folder.
 */
export const getFileManagerFoldersFiles = <ThrowOnError extends boolean = false>(
  options: Options<GetFileManagerFoldersFilesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetFileManagerFoldersFilesResponse,
    GetFileManagerFoldersFilesError,
    ThrowOnError
  >({
    ...options,
    url: '/file-manager/folders/{folder_id}/files',
  });
};

/**
 * List landing pages
 * Get all landing pages.
 */
export const getAllLandingPages = <ThrowOnError extends boolean = false>(
  options?: Options<GetAllLandingPagesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetAllLandingPagesResponse, GetAllLandingPagesError, ThrowOnError>({
    ...options,
    url: '/landing-pages',
  });
};

/**
 * Add landing page
 * Create a new Mailchimp landing page.
 */
export const postAllLandingPages = <ThrowOnError extends boolean = false>(
  options: Options<PostAllLandingPagesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostAllLandingPagesResponse, PostAllLandingPagesError, ThrowOnError>({
    ...options,
    url: '/landing-pages',
  });
};

/**
 * Delete landing page
 * Delete a landing page.
 */
export const deleteLandingPageId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteLandingPageIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteLandingPageIdResponse, DeleteLandingPageIdError, ThrowOnError>({
    ...options,
    url: '/landing-pages/{page_id}',
  });
};

/**
 * Get landing page info
 * Get information about a specific page.
 */
export const getLandingPageId = <ThrowOnError extends boolean = false>(
  options: Options<GetLandingPageIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetLandingPageIdResponse, GetLandingPageIdError, ThrowOnError>({
    ...options,
    url: '/landing-pages/{page_id}',
  });
};

/**
 * Update landing page
 * Update a landing page.
 */
export const patchLandingPageId = <ThrowOnError extends boolean = false>(
  options: Options<PatchLandingPageIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchLandingPageIdResponse, PatchLandingPageIdError, ThrowOnError>({
    ...options,
    url: '/landing-pages/{page_id}',
  });
};

/**
 * Publish landing page
 * Publish a landing page that is in draft, unpublished, or has been previously published and edited.
 */
export const postLandingPageIdActionsPublish = <ThrowOnError extends boolean = false>(
  options: Options<PostLandingPageIdActionsPublishData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostLandingPageIdActionsPublishResponse,
    PostLandingPageIdActionsPublishError,
    ThrowOnError
  >({
    ...options,
    url: '/landing-pages/{page_id}/actions/publish',
  });
};

/**
 * Unpublish landing page
 * Unpublish a landing page that is in draft or has been published.
 */
export const postLandingPageIdActionsUnpublish = <ThrowOnError extends boolean = false>(
  options: Options<PostLandingPageIdActionsUnpublishData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostLandingPageIdActionsUnpublishResponse,
    PostLandingPageIdActionsUnpublishError,
    ThrowOnError
  >({
    ...options,
    url: '/landing-pages/{page_id}/actions/unpublish',
  });
};

/**
 * Get landing page content
 * Get the the HTML for your landing page.
 */
export const getLandingPageIdContent = <ThrowOnError extends boolean = false>(
  options: Options<GetLandingPageIdContentData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetLandingPageIdContentResponse, GetLandingPageIdContentError, ThrowOnError>({
    ...options,
    url: '/landing-pages/{page_id}/content',
  });
};

/**
 * Get lists info
 * Get information about all lists in the account.
 */
export const getLists = <ThrowOnError extends boolean = false>(options?: Options<GetListsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetListsResponse, GetListsError, ThrowOnError>({
    ...options,
    url: '/lists',
  });
};

/**
 * Add list
 * Create a new list in your Mailchimp account.
 */
export const postLists = <ThrowOnError extends boolean = false>(options: Options<PostListsData, ThrowOnError>) => {
  return (options?.client ?? client).post<PostListsResponse, PostListsError, ThrowOnError>({
    ...options,
    url: '/lists',
  });
};

/**
 * Delete list
 * Delete a list from your Mailchimp account. If you delete a list, you'll lose the list history—including subscriber activity, unsubscribes, complaints, and bounces. You’ll also lose subscribers’ email addresses, unless you exported and backed up your list.
 */
export const deleteListsId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteListsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteListsIdResponse, DeleteListsIdError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}',
  });
};

/**
 * Get list info
 * Get information about a specific list in your Mailchimp account. Results include list members who have signed up but haven't confirmed their subscription yet and unsubscribed or cleaned.
 */
export const getListsId = <ThrowOnError extends boolean = false>(options: Options<GetListsIdData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetListsIdResponse, GetListsIdError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}',
  });
};

/**
 * Update lists
 * Update the settings for a specific list.
 */
export const patchListsId = <ThrowOnError extends boolean = false>(
  options: Options<PatchListsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchListsIdResponse, PatchListsIdError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}',
  });
};

/**
 * Batch subscribe or unsubscribe
 * Batch subscribe or unsubscribe list members.
 */
export const postListsId = <ThrowOnError extends boolean = false>(options: Options<PostListsIdData, ThrowOnError>) => {
  return (options?.client ?? client).post<PostListsIdResponse, PostListsIdError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}',
  });
};

/**
 * List abuse reports
 * Get all abuse reports for a specific list.
 */
export const getListsIdAbuseReports = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdAbuseReportsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListsIdAbuseReportsResponse, GetListsIdAbuseReportsError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/abuse-reports',
  });
};

/**
 * Get abuse report
 * Get details about a specific abuse report.
 */
export const getListsIdAbuseReportsId = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdAbuseReportsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListsIdAbuseReportsIdResponse, GetListsIdAbuseReportsIdError, ThrowOnError>(
    {
      ...options,
      url: '/lists/{list_id}/abuse-reports/{report_id}',
    },
  );
};

/**
 * List recent activity
 * Get up to the previous 180 days of daily detailed aggregated activity stats for a list, not including Automation activity.
 */
export const getListsIdActivity = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdActivityData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListsIdActivityResponse, GetListsIdActivityError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/activity',
  });
};

/**
 * List top email clients
 * Get a list of the top email clients based on user-agent strings.
 */
export const getListsIdClients = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdClientsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListsIdClientsResponse, GetListsIdClientsError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/clients',
  });
};

/**
 * List growth history data
 * Get a month-by-month summary of a specific list's growth activity.
 */
export const getListsIdGrowthHistory = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdGrowthHistoryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListsIdGrowthHistoryResponse, GetListsIdGrowthHistoryError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/growth-history',
  });
};

/**
 * Get growth history by month
 * Get a summary of a specific list's growth activity for a specific month and year.
 */
export const getListsIdGrowthHistoryId = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdGrowthHistoryIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetListsIdGrowthHistoryIdResponse,
    GetListsIdGrowthHistoryIdError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/growth-history/{month}',
  });
};

/**
 * List interest categories
 * Get information about a list's interest categories.
 */
export const getListsIdInterestCategories = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdInterestCategoriesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetListsIdInterestCategoriesResponse,
    GetListsIdInterestCategoriesError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/interest-categories',
  });
};

/**
 * Add interest category
 * Create a new interest category.
 */
export const postListsIdInterestCategories = <ThrowOnError extends boolean = false>(
  options: Options<PostListsIdInterestCategoriesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostListsIdInterestCategoriesResponse,
    PostListsIdInterestCategoriesError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/interest-categories',
  });
};

/**
 * Delete interest category
 * Delete a specific interest category.
 */
export const deleteListsIdInterestCategoriesId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteListsIdInterestCategoriesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteListsIdInterestCategoriesIdResponse,
    DeleteListsIdInterestCategoriesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/interest-categories/{interest_category_id}',
  });
};

/**
 * Get interest category info
 * Get information about a specific interest category.
 */
export const getListsIdInterestCategoriesId = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdInterestCategoriesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetListsIdInterestCategoriesIdResponse,
    GetListsIdInterestCategoriesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/interest-categories/{interest_category_id}',
  });
};

/**
 * Update interest category
 * Update a specific interest category.
 */
export const patchListsIdInterestCategoriesId = <ThrowOnError extends boolean = false>(
  options: Options<PatchListsIdInterestCategoriesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchListsIdInterestCategoriesIdResponse,
    PatchListsIdInterestCategoriesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/interest-categories/{interest_category_id}',
  });
};

/**
 * List interests in category
 * Get a list of this category's interests.
 */
export const getListsIdInterestCategoriesIdInterests = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdInterestCategoriesIdInterestsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetListsIdInterestCategoriesIdInterestsResponse,
    GetListsIdInterestCategoriesIdInterestsError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/interest-categories/{interest_category_id}/interests',
  });
};

/**
 * Add interest in category
 * Create a new interest or 'group name' for a specific category.
 */
export const postListsIdInterestCategoriesIdInterests = <ThrowOnError extends boolean = false>(
  options: Options<PostListsIdInterestCategoriesIdInterestsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostListsIdInterestCategoriesIdInterestsResponse,
    PostListsIdInterestCategoriesIdInterestsError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/interest-categories/{interest_category_id}/interests',
  });
};

/**
 * Delete interest in category
 * Delete interests or group names in a specific category.
 */
export const deleteListsIdInterestCategoriesIdInterestsId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteListsIdInterestCategoriesIdInterestsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteListsIdInterestCategoriesIdInterestsIdResponse,
    DeleteListsIdInterestCategoriesIdInterestsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/interest-categories/{interest_category_id}/interests/{interest_id}',
  });
};

/**
 * Get interest in category
 * Get interests or 'group names' for a specific category.
 */
export const getListsIdInterestCategoriesIdInterestsId = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdInterestCategoriesIdInterestsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetListsIdInterestCategoriesIdInterestsIdResponse,
    GetListsIdInterestCategoriesIdInterestsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/interest-categories/{interest_category_id}/interests/{interest_id}',
  });
};

/**
 * Update interest in category
 * Update interests or 'group names' for a specific category.
 */
export const patchListsIdInterestCategoriesIdInterestsId = <ThrowOnError extends boolean = false>(
  options: Options<PatchListsIdInterestCategoriesIdInterestsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchListsIdInterestCategoriesIdInterestsIdResponse,
    PatchListsIdInterestCategoriesIdInterestsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/interest-categories/{interest_category_id}/interests/{interest_id}',
  });
};

/**
 * List locations
 * Get the locations (countries) that the list's subscribers have been tagged to based on geocoding their IP address.
 */
export const getListsIdLocations = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdLocationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListsIdLocationsResponse, GetListsIdLocationsError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/locations',
  });
};

/**
 * List members info
 * Get information about members in a specific Mailchimp list.
 */
export const getListsIdMembers = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListsIdMembersResponse, GetListsIdMembersError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/members',
  });
};

/**
 * Add member to list
 * Add a new member to the list.
 */
export const postListsIdMembers = <ThrowOnError extends boolean = false>(
  options: Options<PostListsIdMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostListsIdMembersResponse, PostListsIdMembersError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/members',
  });
};

/**
 * Archive list member
 * Archive a list member. To permanently delete, use the delete-permanent action.
 */
export const deleteListsIdMembersId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteListsIdMembersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteListsIdMembersIdResponse, DeleteListsIdMembersIdError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/members/{subscriber_hash}',
  });
};

/**
 * Get member info
 * Get information about a specific list member, including a currently subscribed, unsubscribed, or bounced member.
 */
export const getListsIdMembersId = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdMembersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListsIdMembersIdResponse, GetListsIdMembersIdError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/members/{subscriber_hash}',
  });
};

/**
 * Update list member
 * Update information for a specific list member.
 */
export const patchListsIdMembersId = <ThrowOnError extends boolean = false>(
  options: Options<PatchListsIdMembersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchListsIdMembersIdResponse, PatchListsIdMembersIdError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/members/{subscriber_hash}',
  });
};

/**
 * Add or update list member
 * Add or update a list member.
 */
export const putListsIdMembersId = <ThrowOnError extends boolean = false>(
  options: Options<PutListsIdMembersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutListsIdMembersIdResponse, PutListsIdMembersIdError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/members/{subscriber_hash}',
  });
};

/**
 * Delete list member
 * Delete all personally identifiable information related to a list member, and remove them from a list. This will make it impossible to re-import the list member.
 */
export const postListsIdMembersHashActionsDeletePermanent = <ThrowOnError extends boolean = false>(
  options: Options<PostListsIdMembersHashActionsDeletePermanentData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostListsIdMembersHashActionsDeletePermanentResponse,
    PostListsIdMembersHashActionsDeletePermanentError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/members/{subscriber_hash}/actions/delete-permanent',
  });
};

/**
 * View recent activity 50
 * Get the last 50 events of a member's activity on a specific list, including opens, clicks, and unsubscribes.
 */
export const getListsIdMembersIdActivity = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdMembersIdActivityData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetListsIdMembersIdActivityResponse,
    GetListsIdMembersIdActivityError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/members/{subscriber_hash}/activity',
  });
};

/**
 * View recent activity
 * Get a member's activity on a specific list, including opens, clicks, and unsubscribes.
 */
export const getListsIdMembersIdActivityFeed = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdMembersIdActivityFeedData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetListsIdMembersIdActivityFeedResponse,
    GetListsIdMembersIdActivityFeedError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/members/{subscriber_hash}/activity-feed',
  });
};

/**
 * List member events
 * Get events for a contact.
 */
export const getListsIdMembersIdEvents = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdMembersIdEventsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetListsIdMembersIdEventsResponse,
    GetListsIdMembersIdEventsError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/members/{subscriber_hash}/events',
  });
};

/**
 * Add event
 * Add an event for a list member.
 */
export const postListMemberEvents = <ThrowOnError extends boolean = false>(
  options: Options<PostListMemberEventsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostListMemberEventsResponse, PostListMemberEventsError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/members/{subscriber_hash}/events',
  });
};

/**
 * List member goal events
 * Get the last 50 Goal events for a member on a specific list.
 */
export const getListsIdMembersIdGoals = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdMembersIdGoalsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListsIdMembersIdGoalsResponse, GetListsIdMembersIdGoalsError, ThrowOnError>(
    {
      ...options,
      url: '/lists/{list_id}/members/{subscriber_hash}/goals',
    },
  );
};

/**
 * List recent member notes
 * Get recent notes for a specific list member.
 */
export const getListsIdMembersIdNotes = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdMembersIdNotesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListsIdMembersIdNotesResponse, GetListsIdMembersIdNotesError, ThrowOnError>(
    {
      ...options,
      url: '/lists/{list_id}/members/{subscriber_hash}/notes',
    },
  );
};

/**
 * Add member note
 * Add a new note for a specific subscriber.
 */
export const postListsIdMembersIdNotes = <ThrowOnError extends boolean = false>(
  options: Options<PostListsIdMembersIdNotesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostListsIdMembersIdNotesResponse,
    PostListsIdMembersIdNotesError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/members/{subscriber_hash}/notes',
  });
};

/**
 * Delete note
 * Delete a specific note for a specific list member.
 */
export const deleteListsIdMembersIdNotesId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteListsIdMembersIdNotesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteListsIdMembersIdNotesIdResponse,
    DeleteListsIdMembersIdNotesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/members/{subscriber_hash}/notes/{note_id}',
  });
};

/**
 * Get member note
 * Get a specific note for a specific list member.
 */
export const getListsIdMembersIdNotesId = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdMembersIdNotesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetListsIdMembersIdNotesIdResponse,
    GetListsIdMembersIdNotesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/members/{subscriber_hash}/notes/{note_id}',
  });
};

/**
 * Update note
 * Update a specific note for a specific list member.
 */
export const patchListsIdMembersIdNotesId = <ThrowOnError extends boolean = false>(
  options: Options<PatchListsIdMembersIdNotesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchListsIdMembersIdNotesIdResponse,
    PatchListsIdMembersIdNotesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/members/{subscriber_hash}/notes/{note_id}',
  });
};

/**
 * List member tags
 * Get the tags on a list member.
 */
export const getListMemberTags = <ThrowOnError extends boolean = false>(
  options: Options<GetListMemberTagsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListMemberTagsResponse, GetListMemberTagsError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/members/{subscriber_hash}/tags',
  });
};

/**
 * Add or remove member tags
 * Add or remove tags from a list member. If a tag that does not exist is passed in and set as 'active', a new tag will be created.
 */
export const postListMemberTags = <ThrowOnError extends boolean = false>(
  options: Options<PostListMemberTagsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostListMemberTagsResponse, PostListMemberTagsError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/members/{subscriber_hash}/tags',
  });
};

/**
 * List merge fields
 * Get a list of all merge fields for an audience.
 */
export const getListsIdMergeFields = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdMergeFieldsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListsIdMergeFieldsResponse, GetListsIdMergeFieldsError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/merge-fields',
  });
};

/**
 * Add merge field
 * Add a new merge field for a specific audience.
 */
export const postListsIdMergeFields = <ThrowOnError extends boolean = false>(
  options: Options<PostListsIdMergeFieldsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostListsIdMergeFieldsResponse, PostListsIdMergeFieldsError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/merge-fields',
  });
};

/**
 * Delete merge field
 * Delete a specific merge field.
 */
export const deleteListsIdMergeFieldsId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteListsIdMergeFieldsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteListsIdMergeFieldsIdResponse,
    DeleteListsIdMergeFieldsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/merge-fields/{merge_id}',
  });
};

/**
 * Get merge field
 * Get information about a specific merge field.
 */
export const getListsIdMergeFieldsId = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdMergeFieldsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListsIdMergeFieldsIdResponse, GetListsIdMergeFieldsIdError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/merge-fields/{merge_id}',
  });
};

/**
 * Update merge field
 * Update a specific merge field.
 */
export const patchListsIdMergeFieldsId = <ThrowOnError extends boolean = false>(
  options: Options<PatchListsIdMergeFieldsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    PatchListsIdMergeFieldsIdResponse,
    PatchListsIdMergeFieldsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/merge-fields/{merge_id}',
  });
};

/**
 * List segments
 * Get information about all available segments for a specific list.
 */
export const previewAsegment = <ThrowOnError extends boolean = false>(
  options: Options<PreviewAsegmentData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<PreviewAsegmentResponse, PreviewAsegmentError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/segments',
  });
};

/**
 * Add segment
 * Create a new segment in a specific list.
 */
export const postListsIdSegments = <ThrowOnError extends boolean = false>(
  options: Options<PostListsIdSegmentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostListsIdSegmentsResponse, PostListsIdSegmentsError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/segments',
  });
};

/**
 * Delete segment
 * Delete a specific segment in a list.
 */
export const deleteListsIdSegmentsId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteListsIdSegmentsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteListsIdSegmentsIdResponse,
    DeleteListsIdSegmentsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/segments/{segment_id}',
  });
};

/**
 * Get segment info
 * Get information about a specific segment.
 */
export const getListsIdSegmentsId = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdSegmentsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListsIdSegmentsIdResponse, GetListsIdSegmentsIdError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/segments/{segment_id}',
  });
};

/**
 * Update segment
 * Update a specific segment in a list.
 */
export const patchListsIdSegmentsId = <ThrowOnError extends boolean = false>(
  options: Options<PatchListsIdSegmentsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchListsIdSegmentsIdResponse, PatchListsIdSegmentsIdError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/segments/{segment_id}',
  });
};

/**
 * Batch add or remove members
 * Batch add/remove list members to static segment
 */
export const postListsIdSegmentsId = <ThrowOnError extends boolean = false>(
  options: Options<PostListsIdSegmentsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostListsIdSegmentsIdResponse, PostListsIdSegmentsIdError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/segments/{segment_id}',
  });
};

/**
 * List members in segment
 * Get information about members in a saved segment.
 */
export const getListsIdSegmentsIdMembers = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdSegmentsIdMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetListsIdSegmentsIdMembersResponse,
    GetListsIdSegmentsIdMembersError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/segments/{segment_id}/members',
  });
};

/**
 * Add member to segment
 * Add a member to a static segment.
 */
export const postListsIdSegmentsIdMembers = <ThrowOnError extends boolean = false>(
  options: Options<PostListsIdSegmentsIdMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostListsIdSegmentsIdMembersResponse,
    PostListsIdSegmentsIdMembersError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/segments/{segment_id}/members',
  });
};

/**
 * Remove list member from segment
 * Remove a member from the specified static segment.
 */
export const deleteListsIdSegmentsIdMembersId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteListsIdSegmentsIdMembersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteListsIdSegmentsIdMembersIdResponse,
    DeleteListsIdSegmentsIdMembersIdError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/segments/{segment_id}/members/{subscriber_hash}',
  });
};

/**
 * List signup forms
 * Get signup forms for a specific list.
 */
export const getListsIdSignupForms = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdSignupFormsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListsIdSignupFormsResponse, GetListsIdSignupFormsError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/signup-forms',
  });
};

/**
 * Customize signup form
 * Customize a list's default signup form.
 */
export const postListsIdSignupForms = <ThrowOnError extends boolean = false>(
  options: Options<PostListsIdSignupFormsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostListsIdSignupFormsResponse, PostListsIdSignupFormsError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/signup-forms',
  });
};

/**
 * Get information about all surveys for a list
 * Get information about all available surveys for a specific list.
 */
export const getListsIdSurveys = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdSurveysData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListsIdSurveysResponse, GetListsIdSurveysError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/surveys',
  });
};

/**
 * Get survey
 * Get details about a specific survey.
 */
export const getListsIdSurveysId = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdSurveysIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListsIdSurveysIdResponse, GetListsIdSurveysIdError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/surveys/{survey_id}',
  });
};

/**
 * Create a Survey Campaign
 * Utilize the List ID and Survey ID to generate a Campaign that links to your survey.
 */
export const postListsIdSurveysIdActionsCreateEmail = <ThrowOnError extends boolean = false>(
  options: Options<PostListsIdSurveysIdActionsCreateEmailData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostListsIdSurveysIdActionsCreateEmailResponse,
    PostListsIdSurveysIdActionsCreateEmailError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/surveys/{survey_id}/actions/create-email',
  });
};

/**
 * Publish a Survey
 * Publish a survey that is in draft, unpublished, or has been previously published and edited.
 */
export const postListsIdSurveysIdActionsPublish = <ThrowOnError extends boolean = false>(
  options: Options<PostListsIdSurveysIdActionsPublishData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostListsIdSurveysIdActionsPublishResponse,
    PostListsIdSurveysIdActionsPublishError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/surveys/{survey_id}/actions/publish',
  });
};

/**
 * Unpublish a Survey
 * Unpublish a survey that has been published.
 */
export const postListsIdSurveysIdActionsUnpublish = <ThrowOnError extends boolean = false>(
  options: Options<PostListsIdSurveysIdActionsUnpublishData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostListsIdSurveysIdActionsUnpublishResponse,
    PostListsIdSurveysIdActionsUnpublishError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/surveys/{survey_id}/actions/unpublish',
  });
};

/**
 * Search for tags on a list by name.
 * Search for tags on a list by name. If no name is provided, will return all tags on the list.
 */
export const searchTagsByName = <ThrowOnError extends boolean = false>(
  options: Options<SearchTagsByNameData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<SearchTagsByNameResponse, SearchTagsByNameError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/tag-search',
  });
};

/**
 * List webhooks
 * Get information about all webhooks for a specific list.
 */
export const getListsIdWebhooks = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdWebhooksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListsIdWebhooksResponse, GetListsIdWebhooksError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/webhooks',
  });
};

/**
 * Add webhook
 * Create a new webhook for a specific list.
 */
export const postListsIdWebhooks = <ThrowOnError extends boolean = false>(
  options: Options<PostListsIdWebhooksData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostListsIdWebhooksResponse, PostListsIdWebhooksError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/webhooks',
  });
};

/**
 * Delete webhook
 * Delete a specific webhook in a list.
 */
export const deleteListsIdWebhooksId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteListsIdWebhooksIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteListsIdWebhooksIdResponse,
    DeleteListsIdWebhooksIdError,
    ThrowOnError
  >({
    ...options,
    url: '/lists/{list_id}/webhooks/{webhook_id}',
  });
};

/**
 * Get webhook info
 * Get information about a specific webhook.
 */
export const getListsIdWebhooksId = <ThrowOnError extends boolean = false>(
  options: Options<GetListsIdWebhooksIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetListsIdWebhooksIdResponse, GetListsIdWebhooksIdError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/webhooks/{webhook_id}',
  });
};

/**
 * Update webhook
 * Update the settings for an existing webhook.
 */
export const patchListsIdWebhooksId = <ThrowOnError extends boolean = false>(
  options: Options<PatchListsIdWebhooksIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchListsIdWebhooksIdResponse, PatchListsIdWebhooksIdError, ThrowOnError>({
    ...options,
    url: '/lists/{list_id}/webhooks/{webhook_id}',
  });
};

/**
 * Ping
 * A health check for the API that won't return any account-specific information.
 */
export const getPing = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetPingResponse, GetPingError, ThrowOnError>({
    ...options,
    url: '/ping',
  });
};

/**
 * List facebook ads reports
 * Get reports of Facebook ads.
 */
export const getReportingFacebookAds = <ThrowOnError extends boolean = false>(
  options?: Options<GetReportingFacebookAdsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportingFacebookAdsResponse, GetReportingFacebookAdsError, ThrowOnError>({
    ...options,
    url: '/reporting/facebook-ads',
  });
};

/**
 * Get facebook ad report
 * Get report of a Facebook ad.
 */
export const getReportingFacebookAdsId = <ThrowOnError extends boolean = false>(
  options: Options<GetReportingFacebookAdsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportingFacebookAdsIdResponse,
    GetReportingFacebookAdsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/reporting/facebook-ads/{outreach_id}',
  });
};

/**
 * List facebook ecommerce report
 * Get breakdown of product activity for an outreach.
 */
export const getReportingFacebookAdsIdEcommerceProductActivity = <ThrowOnError extends boolean = false>(
  options: Options<GetReportingFacebookAdsIdEcommerceProductActivityData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportingFacebookAdsIdEcommerceProductActivityResponse,
    GetReportingFacebookAdsIdEcommerceProductActivityError,
    ThrowOnError
  >({
    ...options,
    url: '/reporting/facebook-ads/{outreach_id}/ecommerce-product-activity',
  });
};

/**
 * List landing pages reports
 * Get reports of landing pages.
 */
export const getReportingLandingPages = <ThrowOnError extends boolean = false>(
  options?: Options<GetReportingLandingPagesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportingLandingPagesResponse, GetReportingLandingPagesError, ThrowOnError>(
    {
      ...options,
      url: '/reporting/landing-pages',
    },
  );
};

/**
 * Get landing page report
 * Get report of a landing page.
 */
export const getReportingLandingPagesId = <ThrowOnError extends boolean = false>(
  options: Options<GetReportingLandingPagesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportingLandingPagesIdResponse,
    GetReportingLandingPagesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/reporting/landing-pages/{outreach_id}',
  });
};

/**
 * List survey reports
 * Get reports for surveys.
 */
export const getReportingSurveys = <ThrowOnError extends boolean = false>(
  options?: Options<GetReportingSurveysData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportingSurveysResponse, GetReportingSurveysError, ThrowOnError>({
    ...options,
    url: '/reporting/surveys',
  });
};

/**
 * Get survey report
 * Get report for a survey.
 */
export const getReportingSurveysId = <ThrowOnError extends boolean = false>(
  options: Options<GetReportingSurveysIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportingSurveysIdResponse, GetReportingSurveysIdError, ThrowOnError>({
    ...options,
    url: '/reporting/surveys/{outreach_id}',
  });
};

/**
 * List survey question reports
 * Get reports for survey questions.
 */
export const getReportingSurveysIdQuestions = <ThrowOnError extends boolean = false>(
  options: Options<GetReportingSurveysIdQuestionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportingSurveysIdQuestionsResponse,
    GetReportingSurveysIdQuestionsError,
    ThrowOnError
  >({
    ...options,
    url: '/reporting/surveys/{outreach_id}/questions',
  });
};

/**
 * Get survey question report
 * Get report for a survey question.
 */
export const getReportingSurveysIdQuestionsId = <ThrowOnError extends boolean = false>(
  options: Options<GetReportingSurveysIdQuestionsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportingSurveysIdQuestionsIdResponse,
    GetReportingSurveysIdQuestionsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/reporting/surveys/{outreach_id}/questions/{question_id}',
  });
};

/**
 * List answers for question
 * Get answers for a survey question.
 */
export const getReportingSurveysIdQuestionsIdAnswers = <ThrowOnError extends boolean = false>(
  options: Options<GetReportingSurveysIdQuestionsIdAnswersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportingSurveysIdQuestionsIdAnswersResponse,
    GetReportingSurveysIdQuestionsIdAnswersError,
    ThrowOnError
  >({
    ...options,
    url: '/reporting/surveys/{outreach_id}/questions/{question_id}/answers',
  });
};

/**
 * List survey responses
 * Get responses to a survey.
 */
export const getReportingSurveysIdResponses = <ThrowOnError extends boolean = false>(
  options: Options<GetReportingSurveysIdResponsesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportingSurveysIdResponsesResponse,
    GetReportingSurveysIdResponsesError,
    ThrowOnError
  >({
    ...options,
    url: '/reporting/surveys/{outreach_id}/responses',
  });
};

/**
 * Get survey response
 * Get a single survey response.
 */
export const getReportingSurveysIdResponsesId = <ThrowOnError extends boolean = false>(
  options: Options<GetReportingSurveysIdResponsesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportingSurveysIdResponsesIdResponse,
    GetReportingSurveysIdResponsesIdError,
    ThrowOnError
  >({
    ...options,
    url: '/reporting/surveys/{outreach_id}/responses/{response_id}',
  });
};

/**
 * List campaign reports
 * Get campaign reports.
 */
export const getReports = <ThrowOnError extends boolean = false>(options?: Options<GetReportsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetReportsResponse, GetReportsError, ThrowOnError>({
    ...options,
    url: '/reports',
  });
};

/**
 * Get campaign report
 * Get report details for a specific sent campaign.
 */
export const getReportsId = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportsIdResponse, GetReportsIdError, ThrowOnError>({
    ...options,
    url: '/reports/{campaign_id}',
  });
};

/**
 * List abuse reports
 * Get a list of abuse complaints for a specific campaign.
 */
export const getReportsIdAbuseReportsId = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdAbuseReportsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportsIdAbuseReportsIdResponse,
    GetReportsIdAbuseReportsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/reports/{campaign_id}/abuse-reports',
  });
};

/**
 * Get abuse report
 * Get information about a specific abuse report for a campaign.
 */
export const getReportsIdAbuseReportsIdId = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdAbuseReportsIdIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportsIdAbuseReportsIdIdResponse,
    GetReportsIdAbuseReportsIdIdError,
    ThrowOnError
  >({
    ...options,
    url: '/reports/{campaign_id}/abuse-reports/{report_id}',
  });
};

/**
 * List campaign feedback
 * Get feedback based on a campaign's statistics. Advice feedback is based on campaign stats like opens, clicks, unsubscribes, bounces, and more.
 */
export const getReportsIdAdvice = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdAdviceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportsIdAdviceResponse, GetReportsIdAdviceError, ThrowOnError>({
    ...options,
    url: '/reports/{campaign_id}/advice',
  });
};

/**
 * List campaign details
 * Get information about clicks on specific links in your Mailchimp campaigns.
 */
export const getReportsIdClickDetails = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdClickDetailsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportsIdClickDetailsResponse, GetReportsIdClickDetailsError, ThrowOnError>(
    {
      ...options,
      url: '/reports/{campaign_id}/click-details',
    },
  );
};

/**
 * Get campaign link details
 * Get click details for a specific link in a campaign.
 */
export const getReportsIdClickDetailsId = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdClickDetailsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportsIdClickDetailsIdResponse,
    GetReportsIdClickDetailsIdError,
    ThrowOnError
  >({
    ...options,
    url: '/reports/{campaign_id}/click-details/{link_id}',
  });
};

/**
 * List clicked link subscribers
 * Get information about list members who clicked on a specific link in a campaign.
 */
export const getReportsIdClickDetailsIdMembers = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdClickDetailsIdMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportsIdClickDetailsIdMembersResponse,
    GetReportsIdClickDetailsIdMembersError,
    ThrowOnError
  >({
    ...options,
    url: '/reports/{campaign_id}/click-details/{link_id}/members',
  });
};

/**
 * Get clicked link subscriber
 * Get information about a specific subscriber who clicked a link in a specific campaign.
 */
export const getReportsIdClickDetailsIdMembersId = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdClickDetailsIdMembersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportsIdClickDetailsIdMembersIdResponse,
    GetReportsIdClickDetailsIdMembersIdError,
    ThrowOnError
  >({
    ...options,
    url: '/reports/{campaign_id}/click-details/{link_id}/members/{subscriber_hash}',
  });
};

/**
 * List domain performance stats
 * Get statistics for the top-performing email domains in a campaign.
 */
export const getReportsIdDomainPerformance = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdDomainPerformanceData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportsIdDomainPerformanceResponse,
    GetReportsIdDomainPerformanceError,
    ThrowOnError
  >({
    ...options,
    url: '/reports/{campaign_id}/domain-performance',
  });
};

/**
 * List campaign product activity
 * Get breakdown of product activity for a campaign
 */
export const getReportsIdEcommerceProductActivity = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdEcommerceProductActivityData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportsIdEcommerceProductActivityResponse,
    GetReportsIdEcommerceProductActivityError,
    ThrowOnError
  >({
    ...options,
    url: '/reports/{campaign_id}/ecommerce-product-activity',
  });
};

/**
 * List EepURL activity
 * Get a summary of social activity for the campaign, tracked by EepURL.
 */
export const getReportsIdEepurl = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdEepurlData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportsIdEepurlResponse, GetReportsIdEepurlError, ThrowOnError>({
    ...options,
    url: '/reports/{campaign_id}/eepurl',
  });
};

/**
 * List email activity
 * Get a list of member's subscriber activity in a specific campaign.
 */
export const getReportsIdEmailActivity = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdEmailActivityData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportsIdEmailActivityResponse,
    GetReportsIdEmailActivityError,
    ThrowOnError
  >({
    ...options,
    url: '/reports/{campaign_id}/email-activity',
  });
};

/**
 * Get subscriber email activity
 * Get a specific list member's activity in a campaign including opens, clicks, and bounces.
 */
export const getReportsIdEmailActivityId = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdEmailActivityIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportsIdEmailActivityIdResponse,
    GetReportsIdEmailActivityIdError,
    ThrowOnError
  >({
    ...options,
    url: '/reports/{campaign_id}/email-activity/{subscriber_hash}',
  });
};

/**
 * List top open activities
 * Get top open locations for a specific campaign.
 */
export const getReportsIdLocations = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdLocationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportsIdLocationsResponse, GetReportsIdLocationsError, ThrowOnError>({
    ...options,
    url: '/reports/{campaign_id}/locations',
  });
};

/**
 * List campaign open details
 * Get detailed information about any campaign emails that were opened by a list member.
 */
export const getReportsIdOpenDetails = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdOpenDetailsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportsIdOpenDetailsResponse, GetReportsIdOpenDetailsError, ThrowOnError>({
    ...options,
    url: '/reports/{campaign_id}/open-details',
  });
};

/**
 * Get opened campaign subscriber
 * Get information about a specific subscriber who opened a campaign.
 */
export const getReportsIdOpenDetailsIdMembersId = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdOpenDetailsIdMembersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportsIdOpenDetailsIdMembersIdResponse,
    GetReportsIdOpenDetailsIdMembersIdError,
    ThrowOnError
  >({
    ...options,
    url: '/reports/{campaign_id}/open-details/{subscriber_hash}',
  });
};

/**
 * List campaign recipients
 * Get information about campaign recipients.
 */
export const getReportsIdSentTo = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdSentToData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportsIdSentToResponse, GetReportsIdSentToError, ThrowOnError>({
    ...options,
    url: '/reports/{campaign_id}/sent-to',
  });
};

/**
 * Get campaign recipient info
 * Get information about a specific campaign recipient.
 */
export const getReportsIdSentToId = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdSentToIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportsIdSentToIdResponse, GetReportsIdSentToIdError, ThrowOnError>({
    ...options,
    url: '/reports/{campaign_id}/sent-to/{subscriber_hash}',
  });
};

/**
 * List child campaign reports
 * Get a list of reports with child campaigns for a specific parent campaign.
 */
export const getReportsIdSubReportsId = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdSubReportsIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportsIdSubReportsIdResponse, GetReportsIdSubReportsIdError, ThrowOnError>(
    {
      ...options,
      url: '/reports/{campaign_id}/sub-reports',
    },
  );
};

/**
 * List unsubscribed members
 * Get information about members who have unsubscribed from a specific campaign.
 */
export const getReportsIdUnsubscribed = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdUnsubscribedData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetReportsIdUnsubscribedResponse, GetReportsIdUnsubscribedError, ThrowOnError>(
    {
      ...options,
      url: '/reports/{campaign_id}/unsubscribed',
    },
  );
};

/**
 * Get unsubscribed member
 * Get information about a specific list member who unsubscribed from a campaign.
 */
export const getReportsIdUnsubscribedId = <ThrowOnError extends boolean = false>(
  options: Options<GetReportsIdUnsubscribedIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetReportsIdUnsubscribedIdResponse,
    GetReportsIdUnsubscribedIdError,
    ThrowOnError
  >({
    ...options,
    url: '/reports/{campaign_id}/unsubscribed/{subscriber_hash}',
  });
};

/**
 * Search campaigns
 * Search all campaigns for the specified query terms.
 */
export const getSearchCampaigns = <ThrowOnError extends boolean = false>(
  options: Options<GetSearchCampaignsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetSearchCampaignsResponse, GetSearchCampaignsError, ThrowOnError>({
    ...options,
    url: '/search-campaigns',
  });
};

/**
 * Search members
 * Search for list members. This search can be restricted to a specific list, or can be used to search across all lists in an account.
 */
export const getSearchMembers = <ThrowOnError extends boolean = false>(
  options: Options<GetSearchMembersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetSearchMembersResponse, GetSearchMembersError, ThrowOnError>({
    ...options,
    url: '/search-members',
  });
};

/**
 * List template folders
 * Get all folders used to organize templates.
 */
export const getTemplateFolders = <ThrowOnError extends boolean = false>(
  options?: Options<GetTemplateFoldersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTemplateFoldersResponse, GetTemplateFoldersError, ThrowOnError>({
    ...options,
    url: '/template-folders',
  });
};

/**
 * Add template folder
 * Create a new template folder.
 */
export const postTemplateFolders = <ThrowOnError extends boolean = false>(
  options: Options<PostTemplateFoldersData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostTemplateFoldersResponse, PostTemplateFoldersError, ThrowOnError>({
    ...options,
    url: '/template-folders',
  });
};

/**
 * Delete template folder
 * Delete a specific template folder, and mark all the templates in the folder as 'unfiled'.
 */
export const deleteTemplateFoldersId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteTemplateFoldersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteTemplateFoldersIdResponse,
    DeleteTemplateFoldersIdError,
    ThrowOnError
  >({
    ...options,
    url: '/template-folders/{folder_id}',
  });
};

/**
 * Get template folder
 * Get information about a specific folder used to organize templates.
 */
export const getTemplateFoldersId = <ThrowOnError extends boolean = false>(
  options: Options<GetTemplateFoldersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTemplateFoldersIdResponse, GetTemplateFoldersIdError, ThrowOnError>({
    ...options,
    url: '/template-folders/{folder_id}',
  });
};

/**
 * Update template folder
 * Update a specific folder used to organize templates.
 */
export const patchTemplateFoldersId = <ThrowOnError extends boolean = false>(
  options: Options<PatchTemplateFoldersIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchTemplateFoldersIdResponse, PatchTemplateFoldersIdError, ThrowOnError>({
    ...options,
    url: '/template-folders/{folder_id}',
  });
};

/**
 * List templates
 * Get a list of an account's available templates.
 */
export const getTemplates = <ThrowOnError extends boolean = false>(
  options?: Options<GetTemplatesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTemplatesResponse, GetTemplatesError, ThrowOnError>({
    ...options,
    url: '/templates',
  });
};

/**
 * Add template
 * Create a new template for the account. Only Classic templates are supported.
 */
export const postTemplates = <ThrowOnError extends boolean = false>(
  options: Options<PostTemplatesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostTemplatesResponse, PostTemplatesError, ThrowOnError>({
    ...options,
    url: '/templates',
  });
};

/**
 * Delete template
 * Delete a specific template.
 */
export const deleteTemplatesId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteTemplatesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteTemplatesIdResponse, DeleteTemplatesIdError, ThrowOnError>({
    ...options,
    url: '/templates/{template_id}',
  });
};

/**
 * Get template info
 * Get information about a specific template.
 */
export const getTemplatesId = <ThrowOnError extends boolean = false>(
  options: Options<GetTemplatesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTemplatesIdResponse, GetTemplatesIdError, ThrowOnError>({
    ...options,
    url: '/templates/{template_id}',
  });
};

/**
 * Update template
 * Update the name, HTML, or `folder_id` of an existing template.
 */
export const patchTemplatesId = <ThrowOnError extends boolean = false>(
  options: Options<PatchTemplatesIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<PatchTemplatesIdResponse, PatchTemplatesIdError, ThrowOnError>({
    ...options,
    url: '/templates/{template_id}',
  });
};

/**
 * View default content
 * Get the sections that you can edit in a template, including each section's default content.
 */
export const getTemplatesIdDefaultContent = <ThrowOnError extends boolean = false>(
  options: Options<GetTemplatesIdDefaultContentData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetTemplatesIdDefaultContentResponse,
    GetTemplatesIdDefaultContentError,
    ThrowOnError
  >({
    ...options,
    url: '/templates/{template_id}/default-content',
  });
};

/**
 * List sending domains
 * Get all of the sending domains on the account.
 */
export const getVerifiedDomains = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetVerifiedDomainsResponse, GetVerifiedDomainsError, ThrowOnError>({
    ...options,
    url: '/verified-domains',
  });
};

/**
 * Add domain to account
 * Add a domain to the account.
 */
export const createVerifiedDomain = <ThrowOnError extends boolean = false>(
  options: Options<CreateVerifiedDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateVerifiedDomainResponse, CreateVerifiedDomainError, ThrowOnError>({
    ...options,
    url: '/verified-domains',
  });
};

/**
 * Delete domain
 * Delete a verified domain from the account.
 */
export const deleteVerifiedDomain = <ThrowOnError extends boolean = false>(
  options: Options<DeleteVerifiedDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteVerifiedDomainResponse, DeleteVerifiedDomainError, ThrowOnError>({
    ...options,
    url: '/verified-domains/{domain_name}',
  });
};

/**
 * Get domain info
 * Get the details for a single domain on the account.
 */
export const getVerifiedDomain = <ThrowOnError extends boolean = false>(
  options: Options<GetVerifiedDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetVerifiedDomainResponse, GetVerifiedDomainError, ThrowOnError>({
    ...options,
    url: '/verified-domains/{domain_name}',
  });
};

/**
 * Verify domain
 * Verify a domain for sending.
 */
export const verifyDomain = <ThrowOnError extends boolean = false>(
  options: Options<VerifyDomainData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<VerifyDomainResponse, VerifyDomainError, ThrowOnError>({
    ...options,
    url: '/verified-domains/{domain_name}/actions/verify',
  });
};
