// Generated by ts-to-zod
import { z } from 'zod';

export const postingSchema = z.record(z.union([z.union([z.unknown(), z.string(), z.number()]), z.undefined()])).and(
  z.object({
    id: z.string(),
    text: z.string(),
    createdAt: z.number(),
    updatedAt: z.number(),
    user: z.string(),
    owner: z.string(),
    hiringManager: z.string(),
    confidentiality: z.union([z.literal('non-confidential'), z.literal('confidential')]),
    categories: z.object({
      team: z.string(),
      department: z.string(),
      location: z.string(),
      allLocations: z.array(z.string()),
      commitment: z.string(),
      level: z.string(),
    }),
    content: z.object({
      description: z.string(),
      descriptionHtml: z.string(),
      lists: z.array(
        z.object({
          text: z.string(),
          content: z.string(),
        }),
      ),
      closing: z.string(),
      closingHtml: z.string(),
    }),
    country: z.string(),
    tags: z.array(z.string()),
    state: z.literal('published'),
    distributionChannels: z.array(z.union([z.literal('internal'), z.literal('public')])),
    reqCode: z.string(),
    requisitionCodes: z.array(z.string()),
    salaryDescription: z.string(),
    salaryDescriptionHtml: z.string(),
    salaryRange: z.object({
      max: z.number(),
      min: z.number(),
      currency: z.string(),
      interval: z.literal('per-year-salary'),
    }),
    urls: z.object({
      list: z.string(),
      show: z.string(),
      apply: z.string(),
    }),
    workplaceType: z.literal('remote'),
  }),
);

export const confidentialitySchema = z.union([z.literal('non-confidential'), z.literal('confidential')]);

export const stateSchema = z.literal('published');

export const intervalSchema = z.literal('per-year-salary');

export const workplaceTypeSchema = z.literal('remote');

export const opportunitySchema = z.object({
  id: z.string(),
  name: z.string(),
  headline: z.string(),
  contact: z.string(),
  emails: z.array(z.string()),
  phones: z.array(
    z.object({
      value: z.string(),
    }),
  ),
  confidentiality: z.string(),
  location: z.string(),
  links: z.array(z.string()),
  createdAt: z.number(),
  updatedAt: z.number(),
  lastInteractionAt: z.number(),
  lastAdvancedAt: z.number(),
  snoozedUntil: z.number().nullable(),
  archivedAt: z.number().nullable(),
  archiveReason: z.string().nullable(),
  stage: z.string(),
  stageChanges: z.array(
    z.object({
      toStageId: z.string(),
      toStageIndex: z.number(),
      userId: z.string(),
      updatedAt: z.number(),
    }),
  ),
  owner: z.string(),
  tags: z.array(z.string()),
  sources: z.array(z.string()),
  origin: z.string(),
  sourcedBy: z.string(),
  applications: z.array(z.string()),
  resume: z.null().optional(),
  followers: z.array(z.string()),
  urls: z.object({
    list: z.string(),
    show: z.string(),
  }),
  dataProtection: z.object({
    store: z.object({
      allowed: z.boolean(),
      expiresAt: z.number().nullable(),
    }),
    contact: z.object({
      allowed: z.boolean(),
      expiresAt: z.number().nullable(),
    }),
  }),
  isAnonymized: z.boolean(),
});

export const offerSchema = z.record(z.union([z.union([z.unknown(), z.string(), z.number()]), z.undefined()])).and(
  z.object({
    id: z.string(),
    createdAt: z.number(),
    status: z.union([
      z.literal('draft'),
      z.literal('approval-sent'),
      z.literal('approved'),
      z.literal('sent'),
      z.literal('sent-manually'),
      z.literal('opened'),
      z.literal('denied'),
      z.literal('signed'),
    ]),
    creator: z.string(),
    fields: z.array(
      z.object({
        text: z.string(),
        identifier: z.string(),
        value: z.union([z.string(), z.number()]),
      }),
    ),
    sentDocument: z
      .object({
        fileName: z.string(),
        uploadedAt: z.number(),
        downloadUrl: z.string(),
      })
      .nullable(),
    signedDocument: z
      .object({
        fileName: z.string(),
        uploadedAt: z.number(),
        downloadUrl: z.string(),
      })
      .nullable(),
  }),
);

export const statusSchema = z.union([
  z.literal('draft'),
  z.literal('approval-sent'),
  z.literal('approved'),
  z.literal('sent'),
  z.literal('sent-manually'),
  z.literal('opened'),
  z.literal('denied'),
  z.literal('signed'),
]);

export const contactSchema = z.object({
  id: z.string(),
  name: z.string(),
  headline: z.string(),
  isAnonymized: z.boolean(),
  location: z.object({
    name: z.string(),
  }),
  emails: z.array(z.string()),
  phones: z.array(
    z.object({
      value: z.string(),
    }),
  ),
});

export const tagSchema = z.object({
  text: z.string(),
  count: z.number(),
});

export const getPostingDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getPostingResponseSchema = z.object({
  data: postingSchema,
});

export const getPostingErrorSchema = z.unknown();

export const getPostingsDataSchema = z.object({
  query: z
    .object({
      committment: z.string().optional(),
      confidentiality: z.string().optional(),
      department: z.string().optional(),
      distributionChannel: z.string().optional(),
      expand: z
        .union([z.literal('user'), z.literal('owner'), z.literal('hiringManager'), z.literal('followers')])
        .optional(),
      group: z.string().optional(),
      include: z.union([z.literal('content'), z.literal('followers')]).optional(),
      level: z.string().optional(),
      limit: z.number().optional(),
      location: z.string().optional(),
      offset: z.string().optional(),
      state: z.string().optional(),
      tag: z.string().optional(),
      team: z.string().optional(),
      updated_at_end: z.number().optional(),
      updated_at_start: z.number().optional(),
    })
    .optional(),
});

export const getPostingsResponseSchema = z.object({
  data: z.array(postingSchema),
  hasNext: z.boolean().optional(),
  next: z.string().optional(),
});

export const getPostingsErrorSchema = z.unknown();

export const getOpportunityDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getOpportunityResponseSchema = z.object({
  data: opportunitySchema,
});

export const getOpportunityErrorSchema = z.unknown();

export const getOffersDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getOffersResponseSchema = z.object({
  data: offerSchema,
});

export const getOffersErrorSchema = z.unknown();

export const getOpportunitiesDataSchema = z.object({
  query: z
    .object({
      advanced_at_end: z.number().optional(),
      advanced_at_start: z.number().optional(),
      archive_reason_id: z.string().optional(),
      archived: z.boolean().optional(),
      archived_at_end: z.number().optional(),
      archived_at_start: z.number().optional(),
      archived_posting_id: z.string().optional(),
      confidentiality: z.string().optional(),
      contact_id: z.string().optional(),
      created_at_end: z.number().optional(),
      created_at_start: z.number().optional(),
      email: z.string().optional(),
      expand: z
        .union([
          z.literal('applications'),
          z.literal('stage'),
          z.literal('owner'),
          z.literal('followers'),
          z.literal('sourcedBy'),
          z.literal('contact'),
        ])
        .optional(),
      include: z.literal('followers').optional(),
      limit: z.number().optional(),
      offset: z.string().optional(),
      origin: z.string().optional(),
      posting_id: z.string().optional(),
      snoozed: z.boolean().optional(),
      source: z.string().optional(),
      stage_id: z.string().optional(),
      tag: z.string().optional(),
      updated_at_end: z.number().optional(),
      updated_at_start: z.number().optional(),
    })
    .optional(),
});

export const getOpportunitiesResponseSchema = z.object({
  data: z.array(opportunitySchema),
  hasNext: z.boolean().optional(),
  next: z.string().optional(),
});

export const getOpportunitiesErrorSchema = z.unknown();

export const getContactsDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getContactsResponseSchema = z.object({
  data: contactSchema,
});

export const getContactsErrorSchema = z.unknown();

export const getTagsDataSchema = z.object({
  query: z
    .object({
      limit: z.number().optional(),
      offset: z.string().optional(),
    })
    .optional(),
});

export const getTagsResponseSchema = z.object({
  data: z.array(tagSchema),
  hasNext: z.boolean().optional(),
  next: z.string().optional(),
});

export const getTagsErrorSchema = z.unknown();

export const listStagesDataSchema = z.unknown();

export const listStagesResponseSchema = z.object({
  data: z.array(
    z.object({
      id: z.string(),
      text: z.string(),
    }),
  ),
  hasNext: z.boolean().optional(),
  next: z.string().optional(),
});

export const listStagesErrorSchema = z.unknown();

export const listArchiveReasonsDataSchema = z.unknown();

export const listArchiveReasonsResponseSchema = z.object({
  data: z.array(
    z.object({
      id: z.string(),
      text: z.string(),
      status: z.union([z.literal('active'), z.literal('inactive')]),
      type: z.union([z.literal('non-hired'), z.literal('hired')]),
    }),
  ),
  hasNext: z.boolean().optional(),
  next: z.string().optional(),
});

export const listArchiveReasonsErrorSchema = z.unknown();
