// This file is auto-generated by @hey-api/openapi-ts

export type posting = {
  id: string;
  text: string;
  createdAt: number;
  updatedAt: number;
  user: string;
  owner: string;
  hiringManager: string;
  confidentiality: 'non-confidential' | 'confidential';
  categories: {
    team: string;
    department: string;
    location: string;
    allLocations: Array<string>;
    commitment: string;
    level: string;
  };
  content: {
    description: string;
    descriptionHtml: string;
    lists: Array<{
      text: string;
      content: string;
    }>;
    closing: string;
    closingHtml: string;
  };
  country: string;
  tags: Array<string>;
  state: 'published';
  distributionChannels: Array<'internal' | 'public'>;
  reqCode: string;
  requisitionCodes: Array<string>;
  salaryDescription: string;
  salaryDescriptionHtml: string;
  salaryRange: {
    max: number;
    min: number;
    currency: string;
    interval: 'per-year-salary';
  };
  urls: {
    list: string;
    show: string;
    apply: string;
  };
  workplaceType: 'remote';
  [key: string]: (unknown | string | number) | undefined;
};

export type confidentiality = 'non-confidential' | 'confidential';

export type state = 'published';

export type interval = 'per-year-salary';

export type workplaceType = 'remote';

/**
 *
 * "Candidates" are individuals who have been added to your Lever account as potential fits for your open job positions. "Opportunities" represent each of an individual’s unique candidacies or journeys through your pipeline for a given job position, meaning a single Candidate can be associated with multiple Opportunities. A “Contact” is a unique individual who may or may not have multiple candidacies or Opportunities.
 *
 * Candidates enter your pipeline for a new Opportunity by:
 *
 * Applying to a posting on your jobs site,
 * Being added by an external recruiting agency,
 * Being referred by an employee,
 * Being manually added by a Lever user, or
 * Being sourced from an online profile.
 * Each Opportunity can have their own notes, feedback, interview schedules, and additional forms. An opportunity may be “confidential” if it is moving through your pipeline for a job posting that has been created as confidential. Opportunities exit your pipeline by being archived for one of two reasons: (1) The candidate was rejected for the opportunity, or (2) The candidate was hired for the opportunity.
 *
 * A "Contact" is an object that our application uses internally to identify an individual person and their personal or contact information, even though they may have multiple opportunities. From this API, the "Contact" is exposed via the contact field, which returns the unique ID for a Contact across your account. Contact information will be shared and consistent across an individual person's opportunities, and will continue to be aggregated onto individual opportunities in the responses to all GET and POST requests to /opportunities.
 *
 * @see https://hire.sandbox.lever.co/developer/documentation#opportunities
 *
 *
 * WARNING: The Candidates (/candidates) endpoints were deprecated as of 2020. Though they are maintained for backwards compatibility, going forward please see Opportunities endpoints to find the contacts for each job opportunity.
 *
 */
export type opportunity = {
  id: string;
  name: string;
  headline: string;
  contact: string;
  emails: Array<string>;
  phones: Array<{
    value: string;
  }>;
  confidentiality: string;
  location: string;
  links: Array<string>;
  createdAt: number;
  updatedAt: number;
  lastInteractionAt: number;
  lastAdvancedAt: number;
  snoozedUntil: number | null;
  archivedAt: number | null;
  archiveReason: string | null;
  stage: string;
  stageChanges: Array<{
    toStageId: string;
    toStageIndex: number;
    userId: string;
    updatedAt: number;
  }>;
  owner: string;
  tags: Array<string>;
  sources: Array<string>;
  origin: string;
  sourcedBy: string;
  applications: Array<string>;
  resume?: null;
  followers: Array<string>;
  urls: {
    list: string;
    show: string;
  };
  dataProtection: {
    store: {
      allowed: boolean;
      expiresAt: number | null;
    };
    contact: {
      allowed: boolean;
      expiresAt: number | null;
    };
  };
  isAnonymized: boolean;
};

export type offer = {
  id: string;
  createdAt: number;
  status: 'draft' | 'approval-sent' | 'approved' | 'sent' | 'sent-manually' | 'opened' | 'denied' | 'signed';
  creator: string;
  fields: Array<{
    text: string;
    identifier: string;
    value: string | number;
  }>;
  sentDocument: {
    fileName: string;
    uploadedAt: number;
    downloadUrl: string;
  } | null;
  signedDocument: {
    fileName: string;
    uploadedAt: number;
    downloadUrl: string;
  } | null;
  [key: string]: (unknown | string | number) | undefined;
};

export type status = 'draft' | 'approval-sent' | 'approved' | 'sent' | 'sent-manually' | 'opened' | 'denied' | 'signed';

export type contact = {
  id: string;
  name: string;
  headline: string;
  isAnonymized: boolean;
  location: {
    name: string;
  };
  emails: Array<string>;
  phones: Array<{
    value: string;
  }>;
};

export type tag = {
  text: string;
  count: number;
};

export type GetPostingData = {
  path: {
    /**
     * The ID of the posting to retrieve
     */
    id: string;
  };
};

export type GetPostingResponse = {
  data: posting;
};

export type GetPostingError = unknown;

export type GetPostingsData = {
  query?: {
    /**
     * Filter postings by work type (e.g. full-time, internship). Since tags are case-sensitive, Full-time will not match full-time. Multiple work types can be specified and results will include a union of result sets (i.e. postings of either work type).
     */
    committment?: string;
    /**
     * Filter postings by confidentiality. If unspecified, defaults to non-confidential. To get both confidential and non-confidential postings you must specify all. Learn more about confidential data in the API.
     */
    confidentiality?: string;
    /**
     * Filter postings by department name. Since tags are case-sensitive, Legal will not match legal. Multiple departments can be specified and results will include a union of result sets (i.e. postings for either department).
     */
    department?: string;
    /**
     * Filter published postings by whether they appear on the public job site, internal job site, or both. To retrieve all published postings, you must specify both public and internal
     */
    distributionChannel?: string;
    /**
     * Expand user IDs into full objects in response
     */
    expand?: 'user' | 'owner' | 'hiringManager' | 'followers';
    /**
     * Posting results can be grouped by one of four categories: location, team, department, and commitment.
     */
    group?: string;
    /**
     * Include posting content or followers in list results
     */
    include?: 'content' | 'followers';
    /**
     * Deprecated but currently maintained for backward compatibility. Filter postings by level (e.g. junior, senior, manager). Since tags are case-sensitive, Manager will not match manager. Multiple levels can be specified and results will include a union of result sets (i.e. postings of either level).
     */
    level?: string;
    /**
     * A limit on the number of objects to be returned. The limit can range between 1 and 100 items. If no limit is specified, the default for that endpoint is used.
     */
    limit?: number;
    /**
     * Filter postings by location. Tags are case-sensitive, San Francisco will not match san francisco. Multiple locations can be specified and results will include a union of result sets (i.e. postings for either location).
     */
    location?: string;
    /**
     * An offset token specifying the next page of results to return. A paginated list response will include a next attribute that includes an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will fetch the first page of results. You can only pass in an offset that was returned to you via a previously paginated request.
     */
    offset?: string;
    /**
     * Filter postings by state. Valid states are published, internal, closed, draft, pending and rejected.
     */
    state?: string;
    /**
     * Filter postings by tag. Tags are case-sensitive, so Engineering will not match engineering. Multiple tags can be specified and results will include a union of result sets (i.e. postings that have either tag). To specify multiple tags, include the tag parameter multiple times (e.g ?tag=engineering&tag=product)
     */
    tag?: string;
    /**
     * Filter postings by team name (e.g. Engineering, Sales, Marketing). Since tags are case-sensitive, Sales will not match sales. Multiple teams can be specified and results will include a union of result sets (i.e. postings for either team). If your company uses departments, the same team name may occur across multiple departments.
     */
    team?: string;
    /**
     * Filter postings by the timestamp they were last updated. If only updated_at_start is specified, all postings updated from that timestamp (inclusive) to the present will be included. If only updated_at_end is specified, all postings updated before that timestamp (inclusive) are included. Both the updated_at_start and updated_at_end can be specified simultaneously, and results will be all postings updated within the provided timestamps (inclusive) will be returned.
     */
    updated_at_end?: number;
    /**
     * Filter postings by the timestamp they were last updated. If only updated_at_start is specified, all postings updated from that timestamp (inclusive) to the present will be included. If only updated_at_end is specified, all postings updated before that timestamp (inclusive) are included. Both the updated_at_start and updated_at_end can be specified simultaneously, and results will be all postings updated within the provided timestamps (inclusive) will be returned.
     */
    updated_at_start?: number;
  };
};

export type GetPostingsResponse = {
  data: Array<posting>;
  hasNext?: boolean;
  next?: string;
};

export type GetPostingsError = unknown;

export type GetOpportunityData = {
  path: {
    /**
     * The ID of the opportunity to retrieve
     */
    id: string;
  };
};

export type GetOpportunityResponse = {
  data: opportunity;
};

export type GetOpportunityError = unknown;

export type GetOffersData = {
  path: {
    /**
     * The ID of the opportunity to retrieve offers for
     */
    id: string;
  };
};

export type GetOffersResponse = {
  data: offer;
};

export type GetOffersError = unknown;

export type GetOpportunitiesData = {
  query?: {
    /**
     * Filter Opportunities by the timestamp they were advanced to their current stage. If only advanced_at_start is specified, all Opportunities advanced from that timestamp (inclusive) to the present will be included. If only advanced_at_end is specified, all Opportunities advanced before that timestamp (inclusive) are included.
     */
    advanced_at_end?: number;
    /**
     * Filter Opportunities by the timestamp they were advanced to their current stage. If only advanced_at_start is specified, all Opportunities advanced from that timestamp (inclusive) to the present will be included. If only advanced_at_end is specified, all Opportunities advanced before that timestamp (inclusive) are included.
     */
    advanced_at_start?: number;
    /**
     * Filter Opportunities by archive reason. Results will include Opportunities that have been archived with the specified reason. Multiple archive reasons can be specified and results will include a union of result sets (i.e. Opportunities that have been archived for either reason).
     */
    archive_reason_id?: string;
    /**
     * Filter Opportunities by archive status. If unspecified, results include both archived and unarchived Opportunities. If true, results only include archived Opportunities. If false, results only include active Opportunities.
     */
    archived?: boolean;
    /**
     * Filter Opportunities by the timestamp they were archived. If only archived_at_start is specified, all Opportunities archived from that timestamp (inclusive) to the present will be included. If only archived_at_end is specified, all Opportunities archived before that timestamp (inclusive) are included.
     */
    archived_at_end?: number;
    /**
     * Filter Opportunities by the timestamp they were archived. If only archived_at_start is specified, all Opportunities archived from that timestamp (inclusive) to the present will be included. If only archived_at_end is specified, all Opportunities archived before that timestamp (inclusive) are included.
     */
    archived_at_start?: number;
    /**
     * Filter Opportunities by postings for which they have been archived. Results will include opportunities for candidates that applied to the specified posting and then the application was archived. Multiple postings can be specified and results will include a union of result sets (i.e. Opportunities that were applied to either posting).
     */
    archived_posting_id?: string;
    /**
     * Filter opportunities by confidentiality. If unspecified, defaults to non-confidential. To get both confidential and non-confidential opportunities you must specify all. Learn more about confidential data in the API.
     */
    confidentiality?: string;
    /**
     * Filter Opportunities by contact. Results will include the Opportunities that match the specified contact. Multiple contacts can be specified and results will include a union of result sets (i.e. Opportunities that match each of the contacts).
     */
    contact_id?: string;
    /**
     * Filter Opportunities by the timestamp they were created. If only created_at_start is specified, all Opportunities created from that timestamp (inclusive) to the present will be included. If only created_at_end is specified, all Opportunities created before that timestamp (inclusive) are included.
     */
    created_at_end?: number;
    /**
     * Filter Opportunities by the timestamp they were created. If only created_at_start is specified, all Opportunities created from that timestamp (inclusive) to the present will be included. If only created_at_end is specified, all Opportunities created before that timestamp (inclusive) are included.
     */
    created_at_start?: number;
    /**
     * Filter Opportunities by an email address. Results will include Opportunities for Contacts that contain the canonicalized email address.
     */
    email?: string;
    /**
     * Expand application, stage, contact, or user IDs into full objects in response
     */
    expand?: 'applications' | 'stage' | 'owner' | 'followers' | 'sourcedBy' | 'contact';
    /**
     * Include Opportunity followers in list results
     */
    include?: 'followers';
    /**
     * A limit on the number of objects to be returned. The limit can range between 1 and 100 items. If no limit is specified, the default for that endpoint is used.
     */
    limit?: number;
    /**
     * An offset token specifying the next page of results to return. A paginated list response will include a next attribute that includes an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will fetch the first page of results. You can only pass in an offset that was returned to you via a previously paginated request.
     */
    offset?: string;
    /**
     * Filter Opportunities by origin. Results will include Opportunities that contain the specified origin. Multiple origins can be specified and results will include a union of result sets (i.e. Opportunities from either origin).
     */
    origin?: string;
    /**
     * Filter Opportunities by posting. Results will include Opportunities that are applied to the specified posting. Multiple postings can be specified and results will include a union of result sets (i.e. Opportunities that are applied to either posting).
     */
    posting_id?: string;
    /**
     * Filter Opportunities by snoozed status. If unspecified, results include both snoozed and unsnoozed Opportunities. If true, results only include snoozed Opportunities. If false, results only include unsnoozed Opportunities.
     */
    snoozed?: boolean;
    /**
     * Filter Opportunities by source. Results will include Opportunities that contain the specified source tag. Multiple sources can be specified and results will include a union of result sets (i.e. Opportunities from either source).
     */
    source?: string;
    /**
     * Filter Opportunities by current stage. Results will include Opportunities that are currently in the specified stage. Multiple stages can be specified and results will include a union of result sets (i.e. Opportunities that are in either stage).
     */
    stage_id?: string;
    /**
     * Filter Opportunities by tag (case sensitive). Results will include Opportunities that contain the specified tag. Multiple tags can be specified and results will include a union of result sets (i.e. Opportunities that have either tag).
     */
    tag?: string;
    /**
     * Filter Opportunities by the timestamp they were last updated. If only updated_at_start is specified, all Opportunities updated from that timestamp (inclusive) to the present will be included. If only updated_at_end is specified, all Opportunities updated before that timestamp (inclusive) are included.
     */
    updated_at_end?: number;
    /**
     * Filter Opportunities by the timestamp they were last updated. If only updated_at_start is specified, all Opportunities updated from that timestamp (inclusive) to the present will be included. If only updated_at_end is specified, all Opportunities updated before that timestamp (inclusive) are included.
     */
    updated_at_start?: number;
  };
};

export type GetOpportunitiesResponse = {
  data: Array<opportunity>;
  hasNext?: boolean;
  next?: string;
};

export type GetOpportunitiesError = unknown;

export type GetContactsData = {
  path: {
    /**
     * The ID of the contact to retrieve
     */
    id: string;
  };
};

export type GetContactsResponse = {
  data: contact;
};

export type GetContactsError = unknown;

export type GetTagsData = {
  query?: {
    /**
     * A limit on the number of objects to be returned. The limit can range between 1 and 100 items. If no limit is specified, the default for that endpoint is used.
     */
    limit?: number;
    /**
     * An offset token specifying the next page of results to return. A paginated list response will include a next attribute that includes an offset token, which can be used as an input parameter to the next request. If an offset is not passed in, the API will fetch the first page of results. You can only pass in an offset that was returned to you via a previously paginated request.
     */
    offset?: string;
  };
};

export type GetTagsResponse = {
  data: Array<tag>;
  hasNext?: boolean;
  next?: string;
};

export type GetTagsError = unknown;

export type ListStagesData = unknown;

export type ListStagesResponse = {
  data: Array<{
    id: string;
    text: string;
  }>;
  hasNext?: boolean;
  next?: string;
};

export type ListStagesError = unknown;

export type ListArchiveReasonsData = unknown;

export type ListArchiveReasonsResponse = {
  data: Array<{
    id: string;
    text: string;
    status: 'active' | 'inactive';
    type: 'non-hired' | 'hired';
  }>;
  hasNext?: boolean;
  next?: string;
};

export type ListArchiveReasonsError = unknown;
