// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  GetPostingData,
  GetPostingError,
  GetPostingResponse,
  GetPostingsData,
  GetPostingsError,
  GetPostingsResponse,
  GetOpportunityData,
  GetOpportunityError,
  GetOpportunityResponse,
  GetOffersData,
  GetOffersError,
  GetOffersResponse,
  GetOpportunitiesData,
  GetOpportunitiesError,
  GetOpportunitiesResponse,
  GetContactsData,
  GetContactsError,
  GetContactsResponse,
  GetTagsData,
  GetTagsError,
  GetTagsResponse,
  ListStagesData,
  ListStagesError,
  ListStagesResponse,
  ListArchiveReasonsData,
  ListArchiveReasonsError,
  ListArchiveReasonsResponse,
} from './types.gen';

export const client = createClient(createConfig());

export const getPosting = <ThrowOnError extends boolean = false>(options: Options<GetPostingData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetPostingResponse, GetPostingError, ThrowOnError>({
    ...options,
    url: '/postings/{id}',
  });
};

export const getPostings = <ThrowOnError extends boolean = false>(options?: Options<GetPostingsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetPostingsResponse, GetPostingsError, ThrowOnError>({
    ...options,
    url: '/postings',
  });
};

export const getOpportunity = <ThrowOnError extends boolean = false>(
  options: Options<GetOpportunityData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetOpportunityResponse, GetOpportunityError, ThrowOnError>({
    ...options,
    url: '/opportunities/{id}',
  });
};

export const getOffers = <ThrowOnError extends boolean = false>(options: Options<GetOffersData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetOffersResponse, GetOffersError, ThrowOnError>({
    ...options,
    url: '/opportunities/{id}/offers',
  });
};

export const getOpportunities = <ThrowOnError extends boolean = false>(
  options?: Options<GetOpportunitiesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetOpportunitiesResponse, GetOpportunitiesError, ThrowOnError>({
    ...options,
    url: '/opportunities',
  });
};

export const getContacts = <ThrowOnError extends boolean = false>(options: Options<GetContactsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetContactsResponse, GetContactsError, ThrowOnError>({
    ...options,
    url: '/contacts/{id}',
  });
};

export const getTags = <ThrowOnError extends boolean = false>(options?: Options<GetTagsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetTagsResponse, GetTagsError, ThrowOnError>({
    ...options,
    url: '/tags',
  });
};

export const listStages = <ThrowOnError extends boolean = false>(options?: Options<ListStagesData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListStagesResponse, ListStagesError, ThrowOnError>({
    ...options,
    url: '/stages',
  });
};

export const listArchiveReasons = <ThrowOnError extends boolean = false>(
  options?: Options<ListArchiveReasonsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListArchiveReasonsResponse, ListArchiveReasonsError, ThrowOnError>({
    ...options,
    url: '/archive_reasons',
  });
};
