// @ts-nocheck
export type openapi = {
  components: {
    schemas: {
      ActorInputBean: {
        additionalProperties: false;
        properties: {
          group: {
            description: 'The name of the group to add as a default actor. This parameter cannot be used with the `groupId` parameter. As a group\'s name can change,use of `groupId` is recommended. This parameter accepts a comma-separated list. For example, `"group":["project-admin", "jira-developers"]`.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          groupId: {
            description: 'The ID of the group to add as a default actor. This parameter cannot be used with the `group` parameter This parameter accepts a comma-separated list. For example, `"groupId":["77f6ab39-e755-4570-a6ae-2d7a8df0bcb8", "0c011f85-69ed-49c4-a801-3b18d0f771bc"]`.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          user: {
            description: 'The account IDs of the users to add as default actors. This parameter accepts a comma-separated list. For example, `"user":["5b10a2844c20165700ede21g", "5b109f2e9729b51b54dc274d"]`.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      ActorsMap: {
        additionalProperties: false;
        properties: {
          group: {
            description: "The name of the group to add. This parameter cannot be used with the `groupId` parameter. As a group's name can change, use of `groupId` is recommended.";
            items: {
              type: 'string';
            };
            type: 'array';
          };
          groupId: {
            description: 'The ID of the group to add. This parameter cannot be used with the `group` parameter.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          user: {
            description: 'The user account ID of the user to add.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      AddFieldBean: {
        additionalProperties: false;
        properties: {
          fieldId: {
            description: 'The ID of the field to add.';
            type: 'string';
          };
        };
        required: ['fieldId'];
        type: 'object';
      };
      AddGroupBean: {
        additionalProperties: true;
        properties: {
          name: {
            description: 'The name of the group.';
            type: 'string';
          };
        };
        required: ['name'];
        type: 'object';
      };
      AddNotificationsDetails: {
        additionalProperties: true;
        description: 'Details of notifications which should be added to the notification scheme.';
        properties: {
          notificationSchemeEvents: {
            description: 'The list of notifications which should be added to the notification scheme.';
            items: {
              $ref: '#/components/schemas/NotificationSchemeEventDetails';
            };
            type: 'array';
            writeOnly: true;
          };
        };
        required: ['notificationSchemeEvents'];
        type: 'object';
      };
      AddSecuritySchemeLevelsRequestBean: {
        additionalProperties: false;
        properties: {
          levels: {
            description: 'The list of scheme levels which should be added to the security scheme.';
            items: {
              $ref: '#/components/schemas/SecuritySchemeLevelBean';
            };
            type: 'array';
            writeOnly: true;
          };
        };
        type: 'object';
      };
      AnnouncementBannerConfiguration: {
        additionalProperties: false;
        description: 'Announcement banner configuration.';
        properties: {
          hashId: {
            description: 'Hash of the banner data. The client detects updates by comparing hash IDs.';
            readOnly: true;
            type: 'string';
          };
          isDismissible: {
            description: 'Flag indicating if the announcement banner can be dismissed by the user.';
            readOnly: true;
            type: 'boolean';
          };
          isEnabled: {
            description: 'Flag indicating if the announcement banner is enabled or not.';
            readOnly: true;
            type: 'boolean';
          };
          message: {
            description: 'The text on the announcement banner.';
            readOnly: true;
            type: 'string';
          };
          visibility: {
            description: 'Visibility of the announcement banner.';
            enum: ['PUBLIC', 'PRIVATE'];
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      AnnouncementBannerConfigurationUpdate: {
        additionalProperties: false;
        description: 'Configuration of the announcement banner.';
        properties: {
          isDismissible: {
            description: 'Flag indicating if the announcement banner can be dismissed by the user.';
            type: 'boolean';
          };
          isEnabled: {
            description: 'Flag indicating if the announcement banner is enabled or not.';
            type: 'boolean';
          };
          message: {
            description: 'The text on the announcement banner.';
            type: 'string';
          };
          visibility: {
            description: 'Visibility of the announcement banner. Can be public or private.';
            type: 'string';
          };
        };
        type: 'object';
        writeOnly: true;
      };
      AppWorkflowTransitionRule: {
        additionalProperties: false;
        description: 'A workflow transition rule.';
        properties: {
          configuration: {
            $ref: '#/components/schemas/RuleConfiguration';
          };
          id: {
            description: 'The ID of the transition rule.';
            type: 'string';
          };
          key: {
            description: 'The key of the rule, as defined in the Connect or the Forge app descriptor.';
            readOnly: true;
            type: 'string';
          };
          transition: {
            allOf: [
              {
                $ref: '#/components/schemas/WorkflowTransition';
              },
            ];
            readOnly: true;
          };
        };
        required: ['configuration', 'id', 'key'];
        type: 'object';
      };
      Application: {
        additionalProperties: true;
        description: 'The application the linked item is in.';
        properties: {
          name: {
            description: 'The name of the application. Used in conjunction with the (remote) object icon title to display a tooltip for the link\'s icon. The tooltip takes the format "\\[application name\\] icon title". Blank items are excluded from the tooltip title. If both items are blank, the icon tooltop displays as "Web Link". Grouping and sorting of links may place links without an application name last.';
            type: 'string';
          };
          type: {
            description: 'The name-spaced type of the application, used by registered rendering apps.';
            type: 'string';
          };
        };
        type: 'object';
      };
      ApplicationProperty: {
        additionalProperties: false;
        description: 'Details of an application property.';
        properties: {
          allowedValues: {
            description: 'The allowed values, if applicable.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          defaultValue: {
            description: 'The default value of the application property.';
            type: 'string';
          };
          desc: {
            description: 'The description of the application property.';
            type: 'string';
          };
          example: {
            type: 'string';
          };
          id: {
            description: 'The ID of the application property. The ID and key are the same.';
            type: 'string';
          };
          key: {
            description: 'The key of the application property. The ID and key are the same.';
            type: 'string';
          };
          name: {
            description: 'The name of the application property.';
            type: 'string';
          };
          type: {
            description: 'The data type of the application property.';
            type: 'string';
          };
          value: {
            description: 'The new value.';
            type: 'string';
          };
        };
        type: 'object';
      };
      ApplicationRole: {
        additionalProperties: false;
        description: 'Details of an application role.';
        properties: {
          defaultGroups: {
            description: "The groups that are granted default access for this application role. As a group's name can change, use of `defaultGroupsDetails` is recommended to identify a groups.";
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          defaultGroupsDetails: {
            description: 'The groups that are granted default access for this application role.';
            items: {
              $ref: '#/components/schemas/GroupName';
            };
            type: 'array';
          };
          defined: {
            description: 'Deprecated.';
            type: 'boolean';
          };
          groupDetails: {
            description: 'The groups associated with the application role.';
            items: {
              $ref: '#/components/schemas/GroupName';
            };
            type: 'array';
          };
          groups: {
            description: "The groups associated with the application role. As a group's name can change, use of `groupDetails` is recommended to identify a groups.";
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          hasUnlimitedSeats: {
            type: 'boolean';
          };
          key: {
            description: 'The key of the application role.';
            type: 'string';
          };
          name: {
            description: 'The display name of the application role.';
            type: 'string';
          };
          numberOfSeats: {
            description: 'The maximum count of users on your license.';
            format: 'int32';
            type: 'integer';
          };
          platform: {
            description: 'Indicates if the application role belongs to Jira platform (`jira-core`).';
            type: 'boolean';
          };
          remainingSeats: {
            description: 'The count of users remaining on your license.';
            format: 'int32';
            type: 'integer';
          };
          selectedByDefault: {
            description: 'Determines whether this application role should be selected by default on user creation.';
            type: 'boolean';
          };
          userCount: {
            description: 'The number of users counting against your license.';
            format: 'int32';
            type: 'integer';
          };
          userCountDescription: {
            description: 'The [type of users](https://confluence.atlassian.com/x/lRW3Ng) being counted against your license.';
            type: 'string';
          };
        };
        type: 'object';
      };
      ApprovalConfiguration: {
        additionalProperties: false;
        description: 'The approval configuration of a status within a workflow. Applies only to Jira Service Management approvals.';
        nullable: true;
        properties: {
          active: {
            description: 'Whether the approval configuration is active.';
            enum: ['true', 'false'];
            type: 'string';
          };
          conditionType: {
            description: 'How the required approval count is calculated. It may be configured to require a specific number of approvals, or approval by a percentage of approvers. If the approvers source field is Approver groups, you can configure how many approvals per group are required for the request to be approved. The number will be the same across all groups.';
            enum: ['number', 'percent', 'numberPerPrincipal'];
            type: 'string';
          };
          conditionValue: {
            description: 'The number or percentage of approvals required for a request to be approved. If `conditionType` is `number`, the value must be 20 or less. If `conditionType` is `percent`, the value must be 100 or less.';
            type: 'string';
          };
          exclude: {
            description: 'A list of roles that should be excluded as possible approvers.';
            enum: ['assignee', 'reporter'];
            items: {
              description: 'A list of roles that should be excluded as possible approvers.';
              enum: ['assignee', 'reporter'];
              nullable: true;
              type: 'string';
            };
            nullable: true;
            type: 'array';
          };
          fieldId: {
            description: 'The custom field ID of the "Approvers" or "Approver Groups" field.';
            type: 'string';
          };
          prePopulatedFieldId: {
            description: 'The custom field ID of the field used to pre-populate the Approver field. Only supports the "Affected Services" field.';
            nullable: true;
            type: 'string';
          };
          transitionApproved: {
            description: 'The numeric ID of the transition to be executed if the request is approved.';
            type: 'string';
          };
          transitionRejected: {
            description: 'The numeric ID of the transition to be executed if the request is declined.';
            type: 'string';
          };
        };
        required: ['active', 'conditionType', 'conditionValue', 'fieldId', 'transitionApproved', 'transitionRejected'];
        type: 'object';
      };
      ArchiveIssueAsyncRequest: {
        additionalProperties: false;
        properties: {
          jql: {
            type: 'string';
          };
        };
        type: 'object';
      };
      ArchivedIssuesFilterRequest: {
        additionalProperties: true;
        description: 'Details of a filter for exporting archived issues.';
        properties: {
          archivedBy: {
            description: 'List archived issues archived by a specified account ID.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          archivedDateRange: {
            $ref: '#/components/schemas/DateRangeFilterRequest';
          };
          issueTypes: {
            description: 'List archived issues with a specified issue type ID.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          projects: {
            description: 'List archived issues with a specified project key.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          reporters: {
            description: 'List archived issues where the reporter is a specified account ID.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      AssociateFieldConfigurationsWithIssueTypesRequest: {
        additionalProperties: false;
        description: 'Details of a field configuration to issue type mappings.';
        properties: {
          mappings: {
            description: 'Field configuration to issue type mappings.';
            items: {
              $ref: '#/components/schemas/FieldConfigurationToIssueTypeMapping';
            };
            type: 'array';
            uniqueItems: true;
            writeOnly: true;
          };
        };
        required: ['mappings'];
        type: 'object';
      };
      AssociateSecuritySchemeWithProjectDetails: {
        additionalProperties: false;
        description: 'Issue security scheme, project, and remapping details.';
        properties: {
          oldToNewSecurityLevelMappings: {
            description: 'The list of scheme levels which should be remapped to new levels of the issue security scheme.';
            items: {
              $ref: '#/components/schemas/OldToNewSecurityLevelMappingsBean';
            };
            type: 'array';
            writeOnly: true;
          };
          projectId: {
            description: 'The ID of the project.';
            type: 'string';
            writeOnly: true;
          };
          schemeId: {
            description: 'The ID of the issue security scheme. Providing null will clear the association with the issue security scheme.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['projectId', 'schemeId'];
        type: 'object';
      };
      AssociatedItemBean: {
        additionalProperties: false;
        description: 'Details of an item associated with the changed record.';
        properties: {
          id: {
            description: 'The ID of the associated record.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The name of the associated record.';
            readOnly: true;
            type: 'string';
          };
          parentId: {
            description: 'The ID of the associated parent record.';
            readOnly: true;
            type: 'string';
          };
          parentName: {
            description: 'The name of the associated parent record.';
            readOnly: true;
            type: 'string';
          };
          typeName: {
            description: 'The type of the associated record.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      Attachment: {
        additionalProperties: true;
        description: 'Details about an attachment.';
        properties: {
          author: {
            allOf: [
              {
                $ref: '#/components/schemas/UserDetails';
              },
            ];
            description: 'Details of the user who added the attachment.';
            readOnly: true;
          };
          content: {
            description: 'The content of the attachment.';
            readOnly: true;
            type: 'string';
          };
          created: {
            description: 'The datetime the attachment was created.';
            format: 'date-time';
            readOnly: true;
            type: 'string';
          };
          filename: {
            description: 'The file name of the attachment.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the attachment.';
            readOnly: true;
            type: 'string';
          };
          mimeType: {
            description: 'The MIME type of the attachment.';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the attachment details response.';
            readOnly: true;
            type: 'string';
          };
          size: {
            description: 'The size of the attachment.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          thumbnail: {
            description: 'The URL of a thumbnail representing the attachment.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      AttachmentArchive: {
        additionalProperties: false;
        properties: {
          entries: {
            items: {
              $ref: '#/components/schemas/AttachmentArchiveEntry';
            };
            type: 'array';
          };
          moreAvailable: {
            type: 'boolean';
          };
          totalEntryCount: {
            format: 'int32';
            type: 'integer';
          };
          totalNumberOfEntriesAvailable: {
            format: 'int32';
            type: 'integer';
          };
        };
        type: 'object';
      };
      AttachmentArchiveEntry: {
        additionalProperties: false;
        properties: {
          abbreviatedName: {
            type: 'string';
          };
          entryIndex: {
            format: 'int64';
            type: 'integer';
          };
          mediaType: {
            type: 'string';
          };
          name: {
            type: 'string';
          };
          size: {
            format: 'int64';
            type: 'integer';
          };
        };
        type: 'object';
      };
      AttachmentArchiveImpl: {
        additionalProperties: false;
        properties: {
          entries: {
            description: 'The list of the items included in the archive.';
            items: {
              $ref: '#/components/schemas/AttachmentArchiveEntry';
            };
            type: 'array';
          };
          totalEntryCount: {
            description: 'The number of items in the archive.';
            format: 'int32';
            type: 'integer';
          };
        };
        type: 'object';
      };
      AttachmentArchiveItemReadable: {
        additionalProperties: false;
        description: 'Metadata for an item in an attachment archive.';
        properties: {
          index: {
            description: 'The position of the item within the archive.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          label: {
            description: 'The label for the archive item.';
            readOnly: true;
            type: 'string';
          };
          mediaType: {
            description: 'The MIME type of the archive item.';
            readOnly: true;
            type: 'string';
          };
          path: {
            description: 'The path of the archive item.';
            readOnly: true;
            type: 'string';
          };
          size: {
            description: 'The size of the archive item.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      AttachmentArchiveMetadataReadable: {
        additionalProperties: false;
        description: 'Metadata for an archive (for example a zip) and its contents.';
        properties: {
          entries: {
            description: 'The list of the items included in the archive.';
            items: {
              $ref: '#/components/schemas/AttachmentArchiveItemReadable';
            };
            readOnly: true;
            type: 'array';
          };
          id: {
            description: 'The ID of the attachment.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          mediaType: {
            description: 'The MIME type of the attachment.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The name of the archive file.';
            readOnly: true;
            type: 'string';
          };
          totalEntryCount: {
            description: 'The number of items included in the archive.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
        };
        type: 'object';
      };
      AttachmentMetadata: {
        additionalProperties: false;
        description: 'Metadata for an issue attachment.';
        properties: {
          author: {
            allOf: [
              {
                $ref: '#/components/schemas/User';
              },
            ];
            description: 'Details of the user who attached the file.';
            readOnly: true;
          };
          content: {
            description: 'The URL of the attachment.';
            readOnly: true;
            type: 'string';
          };
          created: {
            description: 'The datetime the attachment was created.';
            format: 'date-time';
            readOnly: true;
            type: 'string';
          };
          filename: {
            description: 'The name of the attachment file.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the attachment.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          mimeType: {
            description: 'The MIME type of the attachment.';
            readOnly: true;
            type: 'string';
          };
          properties: {
            additionalProperties: {
              readOnly: true;
            };
            description: 'Additional properties of the attachment.';
            readOnly: true;
            type: 'object';
          };
          self: {
            description: 'The URL of the attachment metadata details.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          size: {
            description: 'The size of the attachment.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          thumbnail: {
            description: 'The URL of a thumbnail representing the attachment.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
        xml: {
          name: 'attachment';
        };
      };
      AttachmentSettings: {
        additionalProperties: false;
        description: "Details of the instance's attachment settings.";
        properties: {
          enabled: {
            description: 'Whether the ability to add attachments is enabled.';
            readOnly: true;
            type: 'boolean';
          };
          uploadLimit: {
            description: 'The maximum size of attachments permitted, in bytes.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
        };
        type: 'object';
      };
      AuditRecordBean: {
        additionalProperties: false;
        description: 'An audit record.';
        properties: {
          associatedItems: {
            description: 'The list of items associated with the changed record.';
            items: {
              $ref: '#/components/schemas/AssociatedItemBean';
            };
            readOnly: true;
            type: 'array';
          };
          authorKey: {
            description: 'Deprecated, use `authorAccountId` instead. The key of the user who created the audit record.';
            readOnly: true;
            type: 'string';
          };
          category: {
            description: 'The category of the audit record. For a list of these categories, see the help article [Auditing in Jira applications](https://confluence.atlassian.com/x/noXKM).';
            readOnly: true;
            type: 'string';
          };
          changedValues: {
            description: 'The list of values changed in the record event.';
            items: {
              $ref: '#/components/schemas/ChangedValueBean';
            };
            readOnly: true;
            type: 'array';
          };
          created: {
            description: 'The date and time on which the audit record was created.';
            format: 'date-time';
            readOnly: true;
            type: 'string';
          };
          description: {
            description: 'The description of the audit record.';
            readOnly: true;
            type: 'string';
          };
          eventSource: {
            description: 'The event the audit record originated from.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the audit record.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          objectItem: {
            $ref: '#/components/schemas/AssociatedItemBean';
          };
          remoteAddress: {
            description: 'The URL of the computer where the creation of the audit record was initiated.';
            readOnly: true;
            type: 'string';
          };
          summary: {
            description: 'The summary of the audit record.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      AuditRecords: {
        additionalProperties: false;
        description: 'Container for a list of audit records.';
        properties: {
          limit: {
            description: 'The requested or default limit on the number of audit items to be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          offset: {
            description: 'The number of audit items skipped before the first item in this list.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          records: {
            description: 'The list of audit items.';
            items: {
              $ref: '#/components/schemas/AuditRecordBean';
            };
            readOnly: true;
            type: 'array';
          };
          total: {
            description: 'The total number of audit items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
        };
        type: 'object';
      };
      AutoCompleteSuggestion: {
        additionalProperties: false;
        description: 'A field auto-complete suggestion.';
        properties: {
          displayName: {
            description: 'The display name of a suggested item. If `fieldValue` or `predicateValue` are provided, the matching text is highlighted with the HTML bold tag.';
            type: 'string';
          };
          value: {
            description: 'The value of a suggested item.';
            type: 'string';
          };
        };
        type: 'object';
      };
      AutoCompleteSuggestions: {
        additionalProperties: false;
        description: 'The results from a JQL query.';
        properties: {
          results: {
            description: 'The list of suggested item.';
            items: {
              $ref: '#/components/schemas/AutoCompleteSuggestion';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      AvailableDashboardGadget: {
        additionalProperties: false;
        description: 'The details of the available dashboard gadget.';
        properties: {
          moduleKey: {
            description: 'The module key of the gadget type.';
            readOnly: true;
            type: 'string';
          };
          title: {
            description: 'The title of the gadget.';
            readOnly: true;
            type: 'string';
          };
          uri: {
            description: 'The URI of the gadget type.';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['title'];
        type: 'object';
      };
      AvailableDashboardGadgetsResponse: {
        additionalProperties: false;
        description: 'The list of available gadgets.';
        properties: {
          gadgets: {
            description: 'The list of available gadgets.';
            items: {
              $ref: '#/components/schemas/AvailableDashboardGadget';
            };
            readOnly: true;
            type: 'array';
          };
        };
        required: ['gadgets'];
        type: 'object';
      };
      AvailableWorkflowConnectRule: {
        additionalProperties: false;
        description: 'The Connect provided ecosystem rules available.';
        properties: {
          addonKey: {
            description: 'The add-on providing the rule.';
            type: 'string';
          };
          createUrl: {
            description: 'The URL creation path segment defined in the Connect module.';
            type: 'string';
          };
          description: {
            description: 'The rule description.';
            type: 'string';
          };
          editUrl: {
            description: 'The URL edit path segment defined in the Connect module.';
            type: 'string';
          };
          moduleKey: {
            description: 'The module providing the rule.';
            type: 'string';
          };
          name: {
            description: 'The rule name.';
            type: 'string';
          };
          ruleKey: {
            description: 'The rule key.';
            type: 'string';
          };
          ruleType: {
            description: 'The rule type.';
            enum: ['Condition', 'Validator', 'Function', 'Screen'];
            type: 'string';
          };
          viewUrl: {
            description: 'The URL view path segment defined in the Connect module.';
            type: 'string';
          };
        };
        type: 'object';
      };
      AvailableWorkflowForgeRule: {
        additionalProperties: false;
        description: 'The Forge provided ecosystem rules available.';
        properties: {
          description: {
            description: 'The rule description.';
            type: 'string';
          };
          id: {
            description: 'The unique ARI of the forge rule type.';
            type: 'string';
          };
          name: {
            description: 'The rule name.';
            type: 'string';
          };
          ruleKey: {
            description: 'The rule key.';
            type: 'string';
          };
          ruleType: {
            description: 'The rule type.';
            enum: ['Condition', 'Validator', 'Function', 'Screen'];
            type: 'string';
          };
        };
        type: 'object';
      };
      AvailableWorkflowSystemRule: {
        additionalProperties: false;
        description: 'The Atlassian provided system rules available.';
        properties: {
          description: {
            description: 'The rule description.';
            type: 'string';
          };
          incompatibleRuleKeys: {
            description: 'List of rules that conflict with this one.';
            items: {
              description: 'List of rules that conflict with this one.';
              type: 'string';
            };
            type: 'array';
          };
          isAvailableForInitialTransition: {
            description: 'Whether the rule can be added added to an initial transition.';
            type: 'boolean';
          };
          isVisible: {
            description: 'Whether the rule is visible.';
            type: 'boolean';
          };
          name: {
            description: 'The rule name.';
            type: 'string';
          };
          ruleKey: {
            description: 'The rule key.';
            type: 'string';
          };
          ruleType: {
            description: 'The rule type.';
            enum: ['Condition', 'Validator', 'Function', 'Screen'];
            type: 'string';
          };
        };
        required: [
          'description',
          'incompatibleRuleKeys',
          'isAvailableForInitialTransition',
          'isVisible',
          'name',
          'ruleKey',
          'ruleType',
        ];
        type: 'object';
      };
      AvailableWorkflowTriggerTypes: {
        additionalProperties: false;
        description: 'The list of available trigger types.';
        properties: {
          description: {
            description: 'The description of the trigger rule.';
            type: 'string';
          };
          name: {
            description: 'The name of the trigger rule.';
            type: 'string';
          };
          type: {
            description: 'The type identifier of trigger rule.';
            type: 'string';
          };
        };
        type: 'object';
      };
      AvailableWorkflowTriggers: {
        additionalProperties: false;
        description: 'The trigger rules available.';
        properties: {
          availableTypes: {
            description: 'The list of available trigger types.';
            items: {
              $ref: '#/components/schemas/AvailableWorkflowTriggerTypes';
            };
            type: 'array';
          };
          ruleKey: {
            description: 'The rule key of the rule.';
            type: 'string';
          };
        };
        required: ['availableTypes', 'ruleKey'];
        type: 'object';
      };
      Avatar: {
        additionalProperties: true;
        description: 'Details of an avatar.';
        properties: {
          fileName: {
            description: 'The file name of the avatar icon. Returned for system avatars.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the avatar.';
            type: 'string';
          };
          isDeletable: {
            description: 'Whether the avatar can be deleted.';
            readOnly: true;
            type: 'boolean';
          };
          isSelected: {
            description: "Whether the avatar is used in Jira. For example, shown as a project's avatar.";
            readOnly: true;
            type: 'boolean';
          };
          isSystemAvatar: {
            description: 'Whether the avatar is a system avatar.';
            readOnly: true;
            type: 'boolean';
          };
          owner: {
            description: 'The owner of the avatar. For a system avatar the owner is null (and nothing is returned). For non-system avatars this is the appropriate identifier, such as the ID for a project or the account ID for a user.';
            readOnly: true;
            type: 'string';
          };
          urls: {
            additionalProperties: {
              format: 'uri';
              readOnly: true;
              type: 'string';
            };
            description: 'The list of avatar icon URLs.';
            readOnly: true;
            type: 'object';
          };
        };
        required: ['id'];
        type: 'object';
      };
      AvatarUrlsBean: {
        additionalProperties: false;
        properties: {
          '16x16': {
            description: "The URL of the item's 16x16 pixel avatar.";
            format: 'uri';
            type: 'string';
          };
          '24x24': {
            description: "The URL of the item's 24x24 pixel avatar.";
            format: 'uri';
            type: 'string';
          };
          '32x32': {
            description: "The URL of the item's 32x32 pixel avatar.";
            format: 'uri';
            type: 'string';
          };
          '48x48': {
            description: "The URL of the item's 48x48 pixel avatar.";
            format: 'uri';
            type: 'string';
          };
        };
        type: 'object';
      };
      Avatars: {
        additionalProperties: false;
        description: 'Details about system and custom avatars.';
        properties: {
          custom: {
            description: 'Custom avatars list.';
            items: {
              $ref: '#/components/schemas/Avatar';
            };
            readOnly: true;
            type: 'array';
          };
          system: {
            description: 'System avatars list.';
            items: {
              $ref: '#/components/schemas/Avatar';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      BulkChangeOwnerDetails: {
        additionalProperties: false;
        description: 'Details for changing owners of shareable entities';
        properties: {
          autofixName: {
            description: "Whether the name is fixed automatically if it's duplicated after changing owner.";
            type: 'boolean';
          };
          newOwner: {
            description: 'The account id of the new owner.';
            type: 'string';
          };
        };
        required: ['autofixName', 'newOwner'];
        type: 'object';
      };
      BulkCustomFieldOptionCreateRequest: {
        additionalProperties: false;
        description: 'Details of the options to create for a custom field.';
        properties: {
          options: {
            description: 'Details of options to create.';
            items: {
              $ref: '#/components/schemas/CustomFieldOptionCreate';
            };
            type: 'array';
          };
        };
        type: 'object';
        writeOnly: true;
      };
      BulkCustomFieldOptionUpdateRequest: {
        additionalProperties: false;
        description: 'Details of the options to update for a custom field.';
        properties: {
          options: {
            description: 'Details of the options to update.';
            items: {
              $ref: '#/components/schemas/CustomFieldOptionUpdate';
            };
            type: 'array';
          };
        };
        type: 'object';
        writeOnly: true;
      };
      BulkEditActionError: {
        additionalProperties: false;
        description: 'Errors of bulk edit action.';
        properties: {
          errorMessages: {
            description: 'The error messages.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          errors: {
            additionalProperties: {
              type: 'string';
            };
            description: 'The errors.';
            type: 'object';
          };
        };
        required: ['errorMessages', 'errors'];
        type: 'object';
      };
      BulkEditGetFields: {
        additionalProperties: false;
        description: 'Bulk Edit Get Fields Response.';
        properties: {
          endingBefore: {
            description: 'The end cursor for use in pagination.';
            readOnly: true;
            type: 'string';
          };
          fields: {
            description: 'List of all the fields';
            items: {
              $ref: '#/components/schemas/IssueBulkEditField';
            };
            readOnly: true;
            type: 'array';
          };
          startingAfter: {
            description: 'The start cursor for use in pagination.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      BulkEditShareableEntityRequest: {
        additionalProperties: false;
        description: 'Details of a request to bulk edit shareable entity.';
        properties: {
          action: {
            description: 'Allowed action for bulk edit shareable entity';
            enum: ['changeOwner', 'changePermission', 'addPermission', 'removePermission'];
            type: 'string';
          };
          changeOwnerDetails: {
            allOf: [
              {
                $ref: '#/components/schemas/BulkChangeOwnerDetails';
              },
            ];
            description: 'The details of change owner action.';
          };
          entityIds: {
            description: 'The id list of shareable entities to be changed.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
          extendAdminPermissions: {
            description: 'Whether the actions are executed by users with Administer Jira global permission.';
            type: 'boolean';
          };
          permissionDetails: {
            allOf: [
              {
                $ref: '#/components/schemas/PermissionDetails';
              },
            ];
            description: 'The permission details to be changed.';
          };
        };
        required: ['action', 'entityIds'];
        type: 'object';
      };
      BulkEditShareableEntityResponse: {
        additionalProperties: false;
        description: 'Details of a request to bulk edit shareable entity.';
        properties: {
          action: {
            description: 'Allowed action for bulk edit shareable entity';
            enum: ['changeOwner', 'changePermission', 'addPermission', 'removePermission'];
            type: 'string';
          };
          entityErrors: {
            additionalProperties: {
              $ref: '#/components/schemas/BulkEditActionError';
            };
            description: 'The mapping dashboard id to errors if any.';
            type: 'object';
          };
        };
        required: ['action'];
        type: 'object';
      };
      BulkFetchIssueRequestBean: {
        additionalProperties: false;
        properties: {
          expand: {
            description: 'Use [expand](em>#expansion) to include additional information about issues in the response. Note that, unlike the majority of instances where `expand` is specified, `expand` is defined as a list of values. The expand options are:\n\n *  `renderedFields` Returns field values rendered in HTML format.\n *  `names` Returns the display name of each field.\n *  `schema` Returns the schema describing a field type.\n *  `changelog` Returns a list of recent updates to an issue, sorted by date, starting from the most recent.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          fields: {
            description: 'A list of fields to return for each issue, use it to retrieve a subset of fields. This parameter accepts a comma-separated list. Expand options include:\n\n *  `*all` Returns all fields.\n *  `*navigable` Returns navigable fields.\n *  Any issue field, prefixed with a minus to exclude.\n\nThe default is `*navigable`.\n\nExamples:\n\n *  `summary,comment` Returns the summary and comments fields only.\n *  `-description` Returns all navigable (default) fields except description.\n *  `*all,-comment` Returns all fields except comments.\n\nMultiple `fields` parameters can be included in a request.\n\nNote: All navigable fields are returned by default. This differs from [GET issue](#api-rest-api-3-issue-issueIdOrKey-get) where the default is all fields.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          fieldsByKeys: {
            description: 'Reference fields by their key (rather than ID). The default is `false`.';
            type: 'boolean';
          };
          issueIdsOrKeys: {
            description: 'An array of issue IDs or issue keys to fetch. You can mix issue IDs and keys in the same query.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          properties: {
            description: 'A list of issue property keys of issue properties to be included in the results. A maximum of 5 issue property keys can be specified.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
        };
        required: ['issueIdsOrKeys'];
        type: 'object';
      };
      BulkIssueIsWatching: {
        additionalProperties: false;
        description: 'A container for the watch status of a list of issues.';
        properties: {
          issuesIsWatching: {
            additionalProperties: {
              readOnly: true;
              type: 'boolean';
            };
            description: 'The map of issue ID to boolean watch status.';
            readOnly: true;
            type: 'object';
          };
        };
        type: 'object';
      };
      BulkIssuePropertyUpdateRequest: {
        additionalProperties: false;
        description: 'Bulk issue property update request details.';
        properties: {
          expression: {
            description: 'EXPERIMENTAL. The Jira expression to calculate the value of the property. The value of the expression must be an object that can be converted to JSON, such as a number, boolean, string, list, or map. The context variables available to the expression are `issue` and `user`. Issues for which the expression returns a value whose JSON representation is longer than 32768 characters are ignored.';
            type: 'string';
          };
          filter: {
            allOf: [
              {
                $ref: '#/components/schemas/IssueFilterForBulkPropertySet';
              },
            ];
            description: 'The bulk operation filter.';
          };
          value: {
            description: 'The value of the property. The value must be a [valid](https://tools.ietf.org/html/rfc4627), non-empty JSON blob. The maximum length is 32768 characters.';
          };
        };
        type: 'object';
      };
      BulkIssueResults: {
        additionalProperties: false;
        description: 'The list of requested issues & fields.';
        properties: {
          issueErrors: {
            description: "When Jira can't return an issue enumerated in a request due to a retriable error or payload constraint, we'll return the respective issue ID with a corresponding error message. This list is empty when there are no errors Issues which aren't found or that the user doesn't have permission to view won't be returned in this list.";
            items: {
              $ref: '#/components/schemas/IssueError';
            };
            readOnly: true;
            type: 'array';
          };
          issues: {
            description: 'The list of issues.';
            items: {
              $ref: '#/components/schemas/IssueBean';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
        xml: {
          name: 'issue';
        };
      };
      BulkOperationErrorResponse: {
        additionalProperties: false;
        properties: {
          errors: {
            items: {
              $ref: '#/components/schemas/ErrorMessage';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      BulkOperationErrorResult: {
        additionalProperties: false;
        properties: {
          elementErrors: {
            $ref: '#/components/schemas/ErrorCollection';
          };
          failedElementNumber: {
            format: 'int32';
            type: 'integer';
          };
          status: {
            format: 'int32';
            type: 'integer';
          };
        };
        type: 'object';
      };
      BulkOperationProgress: {
        additionalProperties: false;
        properties: {
          created: {
            description: 'A timestamp of when the task was submitted.';
            format: 'date-time';
            type: 'string';
          };
          failedAccessibleIssues: {
            additionalProperties: {
              items: {
                type: 'string';
              };
              type: 'array';
            };
            description: 'Map of issue IDs for which the operation failed and that the user has permission to view, to their one or more reasons for failure. These reasons are open-ended text descriptions of the error and are not selected from a predefined list of standard reasons.';
            type: 'object';
          };
          invalidOrInaccessibleIssueCount: {
            description: "The number of issues that are either invalid or issues that the user doesn't have permission to view, regardless of the success or failure of the operation.";
            format: 'int32';
            type: 'integer';
          };
          processedAccessibleIssues: {
            description: 'List of issue IDs for which the operation was successful and that the user has permission to view.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
          };
          progressPercent: {
            description: 'Progress of the task as a percentage.';
            format: 'int64';
            type: 'integer';
          };
          started: {
            description: 'A timestamp of when the task was started.';
            format: 'date-time';
            type: 'string';
          };
          status: {
            description: 'The status of the task.';
            enum: ['ENQUEUED', 'RUNNING', 'COMPLETE', 'FAILED', 'CANCEL_REQUESTED', 'CANCELLED', 'DEAD'];
            type: 'string';
          };
          submittedBy: {
            $ref: '#/components/schemas/User';
          };
          taskId: {
            description: 'The ID of the task.';
            readOnly: true;
            type: 'string';
          };
          totalIssueCount: {
            description: 'The number of issues that the bulk operation was attempted on.';
            format: 'int32';
            type: 'integer';
          };
          updated: {
            description: 'A timestamp of when the task progress was last updated.';
            format: 'date-time';
            type: 'string';
          };
        };
        type: 'object';
      };
      BulkPermissionGrants: {
        additionalProperties: false;
        description: 'Details of global and project permissions granted to the user.';
        properties: {
          globalPermissions: {
            description: 'List of permissions granted to the user.';
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          projectPermissions: {
            description: 'List of project permissions and the projects and issues those permissions provide access to.';
            items: {
              $ref: '#/components/schemas/BulkProjectPermissionGrants';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        required: ['globalPermissions', 'projectPermissions'];
        type: 'object';
      };
      BulkPermissionsRequestBean: {
        additionalProperties: false;
        description: 'Details of global permissions to look up and project permissions with associated projects and issues to look up.';
        properties: {
          accountId: {
            description: 'The account ID of a user.';
            type: 'string';
          };
          globalPermissions: {
            description: 'Global permissions to look up.';
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          projectPermissions: {
            description: 'Project permissions with associated projects and issues to look up.';
            items: {
              $ref: '#/components/schemas/BulkProjectPermissions';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        type: 'object';
      };
      BulkProjectPermissionGrants: {
        additionalProperties: false;
        description: 'List of project permissions and the projects and issues those permissions grant access to.';
        properties: {
          issues: {
            description: 'IDs of the issues the user has the permission for.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
          permission: {
            description: 'A project permission,';
            type: 'string';
          };
          projects: {
            description: 'IDs of the projects the user has the permission for.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        required: ['issues', 'permission', 'projects'];
        type: 'object';
      };
      BulkProjectPermissions: {
        additionalProperties: false;
        description: 'Details of project permissions and associated issues and projects to look up.';
        properties: {
          issues: {
            description: 'List of issue IDs.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
          permissions: {
            description: 'List of project permissions.';
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          projects: {
            description: 'List of project IDs.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        required: ['permissions'];
        type: 'object';
      };
      ChangeDetails: {
        additionalProperties: false;
        description: 'A change item.';
        properties: {
          field: {
            description: 'The name of the field changed.';
            readOnly: true;
            type: 'string';
          };
          fieldId: {
            description: 'The ID of the field changed.';
            readOnly: true;
            type: 'string';
          };
          fieldtype: {
            description: 'The type of the field changed.';
            readOnly: true;
            type: 'string';
          };
          from: {
            description: 'The details of the original value.';
            readOnly: true;
            type: 'string';
          };
          fromString: {
            description: 'The details of the original value as a string.';
            readOnly: true;
            type: 'string';
          };
          to: {
            description: 'The details of the new value.';
            readOnly: true;
            type: 'string';
          };
          toString: {
            description: 'The details of the new value as a string.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      ChangeFilterOwner: {
        additionalProperties: false;
        description: 'The account ID of the new owner.';
        properties: {
          accountId: {
            description: 'The account ID of the new owner.';
            type: 'string';
          };
        };
        required: ['accountId'];
        type: 'object';
        writeOnly: true;
      };
      ChangedValueBean: {
        additionalProperties: false;
        description: 'Details of names changed in the record event.';
        properties: {
          changedFrom: {
            description: 'The value of the field before the change.';
            readOnly: true;
            type: 'string';
          };
          changedTo: {
            description: 'The value of the field after the change.';
            readOnly: true;
            type: 'string';
          };
          fieldName: {
            description: 'The name of the field changed.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      ChangedWorklog: {
        additionalProperties: false;
        description: 'Details of a changed worklog.';
        properties: {
          properties: {
            description: 'Details of properties associated with the change.';
            items: {
              $ref: '#/components/schemas/EntityProperty';
            };
            readOnly: true;
            type: 'array';
          };
          updatedTime: {
            description: 'The datetime of the change.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          worklogId: {
            description: 'The ID of the worklog.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
        };
        type: 'object';
      };
      ChangedWorklogs: {
        additionalProperties: false;
        description: 'List of changed worklogs.';
        properties: {
          lastPage: {
            type: 'boolean';
          };
          nextPage: {
            description: 'The URL of the next list of changed worklogs.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of this changed worklogs list.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          since: {
            description: 'The datetime of the first worklog item in the list.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          until: {
            description: 'The datetime of the last worklog item in the list.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'Changed worklog list.';
            items: {
              $ref: '#/components/schemas/ChangedWorklog';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      Changelog: {
        additionalProperties: false;
        description: 'A log of changes made to issue fields. Changelogs related to workflow associations are currently being deprecated.';
        properties: {
          author: {
            allOf: [
              {
                $ref: '#/components/schemas/UserDetails';
              },
            ];
            description: 'The user who made the change.';
            readOnly: true;
          };
          created: {
            description: 'The date on which the change took place.';
            format: 'date-time';
            readOnly: true;
            type: 'string';
          };
          historyMetadata: {
            allOf: [
              {
                $ref: '#/components/schemas/HistoryMetadata';
              },
            ];
            description: 'The history metadata associated with the changed.';
            readOnly: true;
          };
          id: {
            description: 'The ID of the changelog.';
            readOnly: true;
            type: 'string';
          };
          items: {
            description: 'The list of items changed.';
            items: {
              $ref: '#/components/schemas/ChangeDetails';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      ColumnItem: {
        additionalProperties: false;
        description: 'Details of an issue navigator column item.';
        properties: {
          label: {
            description: 'The issue navigator column label.';
            type: 'string';
          };
          value: {
            description: 'The issue navigator column value.';
            type: 'string';
          };
        };
        type: 'object';
      };
      ColumnRequestBody: {
        additionalProperties: false;
        properties: {
          columns: {
            items: {
              type: 'string';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      Comment: {
        additionalProperties: true;
        description: 'A comment.';
        properties: {
          author: {
            allOf: [
              {
                $ref: '#/components/schemas/UserDetails';
              },
            ];
            description: 'The ID of the user who created the comment.';
            readOnly: true;
          };
          body: {
            description: 'The comment text in [Atlassian Document Format](https://developer.atlassian.com/cloud/jira/platform/apis/document/structure/).';
          };
          created: {
            description: 'The date and time at which the comment was created.';
            format: 'date-time';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the comment.';
            readOnly: true;
            type: 'string';
          };
          jsdAuthorCanSeeRequest: {
            description: 'Whether the comment was added from an email sent by a person who is not part of the issue. See [Allow external emails to be added as comments on issues](https://support.atlassian.com/jira-service-management-cloud/docs/allow-external-emails-to-be-added-as-comments-on-issues/)for information on setting up this feature.';
            readOnly: true;
            type: 'boolean';
          };
          jsdPublic: {
            description: "Whether the comment is visible in Jira Service Desk. Defaults to true when comments are created in the Jira Cloud Platform. This includes when the site doesn't use Jira Service Desk or the project isn't a Jira Service Desk project and, therefore, there is no Jira Service Desk for the issue to be visible on. To create a comment with its visibility in Jira Service Desk set to false, use the Jira Service Desk REST API [Create request comment](https://developer.atlassian.com/cloud/jira/service-desk/rest/#api-rest-servicedeskapi-request-issueIdOrKey-comment-post) operation.";
            readOnly: true;
            type: 'boolean';
          };
          properties: {
            description: 'A list of comment properties. Optional on create and update.';
            items: {
              $ref: '#/components/schemas/EntityProperty';
            };
            type: 'array';
          };
          renderedBody: {
            description: 'The rendered version of the comment.';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the comment.';
            readOnly: true;
            type: 'string';
          };
          updateAuthor: {
            allOf: [
              {
                $ref: '#/components/schemas/UserDetails';
              },
            ];
            description: 'The ID of the user who updated the comment last.';
            readOnly: true;
          };
          updated: {
            description: 'The date and time at which the comment was updated last.';
            format: 'date-time';
            readOnly: true;
            type: 'string';
          };
          visibility: {
            allOf: [
              {
                $ref: '#/components/schemas/Visibility';
              },
            ];
            description: 'The group or role to which this comment is visible. Optional on create and update.';
          };
        };
        type: 'object';
      };
      ComponentIssuesCount: {
        additionalProperties: false;
        description: 'Count of issues assigned to a component.';
        properties: {
          issueCount: {
            description: 'The count of issues assigned to a component.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          self: {
            description: 'The URL for this count of issues for a component.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
        xml: {
          name: 'component';
        };
      };
      ComponentJsonBean: {
        additionalProperties: true;
        properties: {
          ari: {
            type: 'string';
          };
          description: {
            type: 'string';
          };
          id: {
            type: 'string';
          };
          metadata: {
            additionalProperties: {
              type: 'string';
            };
            type: 'object';
          };
          name: {
            type: 'string';
          };
          self: {
            type: 'string';
          };
        };
        type: 'object';
      };
      ComponentWithIssueCount: {
        additionalProperties: false;
        description: 'Details about a component with a count of the issues it contains.';
        properties: {
          assignee: {
            allOf: [
              {
                $ref: '#/components/schemas/User';
              },
            ];
            description: 'The details of the user associated with `assigneeType`, if any. See `realAssignee` for details of the user assigned to issues created with this component.';
          };
          assigneeType: {
            description: 'The nominal user type used to determine the assignee for issues created with this component. See `realAssigneeType` for details on how the type of the user, and hence the user, assigned to issues is determined. Takes the following values:\n\n *  `PROJECT_LEAD` the assignee to any issues created with this component is nominally the lead for the project the component is in.\n *  `COMPONENT_LEAD` the assignee to any issues created with this component is nominally the lead for the component.\n *  `UNASSIGNED` an assignee is not set for issues created with this component.\n *  `PROJECT_DEFAULT` the assignee to any issues created with this component is nominally the default assignee for the project that the component is in.';
            enum: ['PROJECT_DEFAULT', 'COMPONENT_LEAD', 'PROJECT_LEAD', 'UNASSIGNED'];
            readOnly: true;
            type: 'string';
          };
          description: {
            description: 'The description for the component.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The unique identifier for the component.';
            readOnly: true;
            type: 'string';
          };
          isAssigneeTypeValid: {
            description: 'Whether a user is associated with `assigneeType`. For example, if the `assigneeType` is set to `COMPONENT_LEAD` but the component lead is not set, then `false` is returned.';
            readOnly: true;
            type: 'boolean';
          };
          issueCount: {
            description: 'Count of issues for the component.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          lead: {
            allOf: [
              {
                $ref: '#/components/schemas/User';
              },
            ];
            description: "The user details for the component's lead user.";
          };
          name: {
            description: 'The name for the component.';
            readOnly: true;
            type: 'string';
          };
          project: {
            description: 'The key of the project to which the component is assigned.';
            readOnly: true;
            type: 'string';
          };
          projectId: {
            description: 'Not used.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          realAssignee: {
            allOf: [
              {
                $ref: '#/components/schemas/User';
              },
            ];
            description: 'The user assigned to issues created with this component, when `assigneeType` does not identify a valid assignee.';
          };
          realAssigneeType: {
            description: 'The type of the assignee that is assigned to issues created with this component, when an assignee cannot be set from the `assigneeType`. For example, `assigneeType` is set to `COMPONENT_LEAD` but no component lead is set. This property is set to one of the following values:\n\n *  `PROJECT_LEAD` when `assigneeType` is `PROJECT_LEAD` and the project lead has permission to be assigned issues in the project that the component is in.\n *  `COMPONENT_LEAD` when `assignee`Type is `COMPONENT_LEAD` and the component lead has permission to be assigned issues in the project that the component is in.\n *  `UNASSIGNED` when `assigneeType` is `UNASSIGNED` and Jira is configured to allow unassigned issues.\n *  `PROJECT_DEFAULT` when none of the preceding cases are true.';
            enum: ['PROJECT_DEFAULT', 'COMPONENT_LEAD', 'PROJECT_LEAD', 'UNASSIGNED'];
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL for this count of the issues contained in the component.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      CompoundClause: {
        description: 'A JQL query clause that consists of nested clauses. For example, `(labels in (urgent, blocker) OR lastCommentedBy = currentUser()). Note that, where nesting is not defined, the parser nests JQL clauses based on the operator precedence. For example, "A OR B AND C" is parsed as "(A OR B) AND C". See Setting the precedence of operators for more information about precedence in JQL queries.`';
        properties: {
          clauses: {
            description: 'The list of nested clauses.';
            items: {
              $ref: '#/components/schemas/JqlQueryClause';
            };
            type: 'array';
          };
          operator: {
            description: 'The operator between the clauses.';
            enum: ['and', 'or', 'not'];
            type: 'string';
          };
        };
        required: ['clauses', 'operator'];
        type: 'object';
      };
      ConditionGroupConfiguration: {
        additionalProperties: false;
        description: 'The conditions group associated with the transition.';
        nullable: true;
        properties: {
          conditionGroups: {
            description: 'The nested conditions of the condition group.';
            items: {
              $ref: '#/components/schemas/ConditionGroupConfiguration';
            };
            type: 'array';
          };
          conditions: {
            description: 'The rules for this condition.';
            items: {
              $ref: '#/components/schemas/WorkflowRuleConfiguration';
            };
            type: 'array';
          };
          operation: {
            description: 'Determines how the conditions in the group are evaluated. Accepts either `ANY` or `ALL`. If `ANY` is used, at least one condition in the group must be true for the group to evaluate to true. If `ALL` is used, all conditions in the group must be true for the group to evaluate to true.';
            enum: ['ANY', 'ALL'];
            type: 'string';
          };
        };
        type: 'object';
      };
      ConditionGroupUpdate: {
        additionalProperties: false;
        description: 'The conditions group associated with the transition.';
        nullable: true;
        properties: {
          conditionGroups: {
            description: 'The nested conditions of the condition group.';
            items: {
              $ref: '#/components/schemas/ConditionGroupUpdate';
            };
            type: 'array';
          };
          conditions: {
            description: 'The rules for this condition.';
            items: {
              $ref: '#/components/schemas/WorkflowRuleConfiguration';
            };
            type: 'array';
          };
          operation: {
            description: 'Determines how the conditions in the group are evaluated. Accepts either `ANY` or `ALL`. If `ANY` is used, at least one condition in the group must be true for the group to evaluate to true. If `ALL` is used, all conditions in the group must be true for the group to evaluate to true.';
            enum: ['ANY', 'ALL'];
            type: 'string';
          };
        };
        required: ['operation'];
        type: 'object';
      };
      Configuration: {
        additionalProperties: false;
        description: 'Details about the configuration of Jira.';
        properties: {
          attachmentsEnabled: {
            description: 'Whether the ability to add attachments to issues is enabled.';
            readOnly: true;
            type: 'boolean';
          };
          issueLinkingEnabled: {
            description: 'Whether the ability to link issues is enabled.';
            readOnly: true;
            type: 'boolean';
          };
          subTasksEnabled: {
            description: 'Whether the ability to create subtasks for issues is enabled.';
            readOnly: true;
            type: 'boolean';
          };
          timeTrackingConfiguration: {
            allOf: [
              {
                $ref: '#/components/schemas/TimeTrackingConfiguration';
              },
            ];
            description: 'The configuration of time tracking.';
            readOnly: true;
          };
          timeTrackingEnabled: {
            description: 'Whether the ability to track time is enabled. This property is deprecated.';
            readOnly: true;
            type: 'boolean';
          };
          unassignedIssuesAllowed: {
            description: 'Whether the ability to create unassigned issues is enabled. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.';
            readOnly: true;
            type: 'boolean';
          };
          votingEnabled: {
            description: 'Whether the ability for users to vote on issues is enabled. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.';
            readOnly: true;
            type: 'boolean';
          };
          watchingEnabled: {
            description: 'Whether the ability for users to watch issues is enabled. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.';
            readOnly: true;
            type: 'boolean';
          };
        };
        type: 'object';
      };
      ConnectCustomFieldValue: {
        description: 'A list of custom field details.';
        properties: {
          _type: {
            description: 'The type of custom field.';
            enum: [
              'StringIssueField',
              'NumberIssueField',
              'RichTextIssueField',
              'SingleSelectIssueField',
              'MultiSelectIssueField',
              'TextIssueField',
            ];
            type: 'string';
            writeOnly: true;
          };
          fieldID: {
            description: 'The custom field ID.';
            type: 'integer';
            writeOnly: true;
          };
          issueID: {
            description: 'The issue ID.';
            type: 'integer';
            writeOnly: true;
          };
          number: {
            description: 'The value of number type custom field when `_type` is `NumberIssueField`.';
            type: 'number';
          };
          optionID: {
            description: 'The value of single select and multiselect custom field type when `_type` is `SingleSelectIssueField` or `MultiSelectIssueField`.';
            type: 'string';
          };
          richText: {
            description: 'The value of richText type custom field when `_type` is `RichTextIssueField`.';
            type: 'string';
          };
          string: {
            description: 'The value of string type custom field when `_type` is `StringIssueField`.';
            type: 'string';
          };
          text: {
            description: 'The value of of text custom field type when `_type` is `TextIssueField`.';
            type: 'string';
          };
        };
        required: ['_type', 'fieldID', 'issueID'];
        type: 'object';
        writeOnly: true;
      };
      ConnectCustomFieldValues: {
        additionalProperties: false;
        description: 'Details of updates for a custom field.';
        properties: {
          updateValueList: {
            description: 'The list of custom field update details.';
            items: {
              $ref: '#/components/schemas/ConnectCustomFieldValue';
            };
            type: 'array';
          };
        };
        type: 'object';
        writeOnly: true;
      };
      ConnectModule: {
        description: 'A [Connect module](https://developer.atlassian.com/cloud/jira/platform/about-jira-modules/) in the same format as in the\n[app descriptor](https://developer.atlassian.com/cloud/jira/platform/app-descriptor/).';
        example: {
          description: {
            value: 'field with team';
          };
          type: 'single_select';
          extractions: [
            {
              path: 'category';
              type: 'text';
              name: 'categoryName';
            },
          ];
          name: {
            value: 'Team';
          };
          key: 'team-field';
        };
        type: 'object';
      };
      ConnectModules: {
        example: {
          jiraEntityProperties: [
            {
              keyConfigurations: [
                {
                  extractions: [
                    {
                      objectName: 'extension';
                      type: 'text';
                      alias: 'attachmentExtension';
                    },
                  ];
                  propertyKey: 'attachment';
                },
              ];
              entityType: 'issue';
              name: {
                value: 'Attachment Index Document';
              };
              key: 'dynamic-attachment-entity-property';
            },
          ];
          jiraIssueFields: [
            {
              description: {
                value: 'A dynamically added single-select field';
              };
              type: 'single_select';
              extractions: [
                {
                  path: 'category';
                  type: 'text';
                  name: 'categoryName';
                },
              ];
              name: {
                value: 'Dynamic single select';
              };
              key: 'dynamic-select-field';
            },
          ];
        };
        properties: {
          modules: {
            description: 'A list of app modules in the same format as the `modules` property in the\n[app descriptor](https://developer.atlassian.com/cloud/jira/platform/app-descriptor/).';
            items: {
              $ref: '#/components/schemas/ConnectModule';
            };
            type: 'array';
          };
        };
        required: ['modules'];
        type: 'object';
      };
      ConnectWorkflowTransitionRule: {
        description: 'A workflow transition rule.';
        properties: {
          configuration: {
            $ref: '#/components/schemas/RuleConfiguration';
          };
          id: {
            description: 'The ID of the transition rule.';
            example: '123';
            type: 'string';
          };
          key: {
            description: 'The key of the rule, as defined in the Connect app descriptor.';
            example: 'WorkflowKey';
            type: 'string';
          };
          transition: {
            $ref: '#/components/schemas/WorkflowTransition';
          };
        };
        required: ['configuration', 'id', 'key'];
        type: 'object';
      };
      ContainerForProjectFeatures: {
        additionalProperties: false;
        description: 'The list of features on a project.';
        properties: {
          features: {
            description: 'The project features.';
            items: {
              $ref: '#/components/schemas/ProjectFeature';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      ContainerForRegisteredWebhooks: {
        additionalProperties: false;
        description: 'Container for a list of registered webhooks. Webhook details are returned in the same order as the request.';
        properties: {
          webhookRegistrationResult: {
            description: 'A list of registered webhooks.';
            items: {
              $ref: '#/components/schemas/RegisteredWebhook';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      ContainerForWebhookIDs: {
        additionalProperties: false;
        description: 'Container for a list of webhook IDs.';
        properties: {
          webhookIds: {
            description: 'A list of webhook IDs.';
            items: {
              description: 'A list of webhook IDs.';
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
          };
        };
        required: ['webhookIds'];
        type: 'object';
      };
      ContainerOfWorkflowSchemeAssociations: {
        additionalProperties: false;
        description: 'A container for a list of workflow schemes together with the projects they are associated with.';
        properties: {
          values: {
            description: 'A list of workflow schemes together with projects they are associated with.';
            items: {
              $ref: '#/components/schemas/WorkflowSchemeAssociations';
            };
            type: 'array';
          };
        };
        required: ['values'];
        type: 'object';
      };
      Context: {
        additionalProperties: false;
        description: 'A context.';
        properties: {
          id: {
            description: 'The ID of the context.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          name: {
            description: 'The name of the context.';
            readOnly: true;
            type: 'string';
          };
          scope: {
            allOf: [
              {
                $ref: '#/components/schemas/Scope';
              },
            ];
            description: 'The scope of the context.';
          };
        };
        type: 'object';
      };
      ContextForProjectAndIssueType: {
        additionalProperties: false;
        description: 'The project and issue type mapping with a matching custom field context.';
        properties: {
          contextId: {
            description: 'The ID of the custom field context.';
            type: 'string';
          };
          issueTypeId: {
            description: 'The ID of the issue type.';
            type: 'string';
          };
          projectId: {
            description: 'The ID of the project.';
            type: 'string';
          };
        };
        required: ['contextId', 'issueTypeId', 'projectId'];
        type: 'object';
      };
      ContextualConfiguration: {
        additionalProperties: false;
        description: 'Details of the contextual configuration for a custom field.';
        properties: {
          configuration: {
            description: 'The field configuration.';
          };
          fieldContextId: {
            description: 'The ID of the field context the configuration is associated with.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the configuration.';
            type: 'string';
          };
          schema: {
            description: 'The field value schema.';
          };
        };
        required: ['fieldContextId', 'id'];
        type: 'object';
      };
      ConvertedJQLQueries: {
        additionalProperties: false;
        description: 'The converted JQL queries.';
        properties: {
          queriesWithUnknownUsers: {
            description: 'List of queries containing user information that could not be mapped to an existing user';
            items: {
              $ref: '#/components/schemas/JQLQueryWithUnknownUsers';
            };
            type: 'array';
          };
          queryStrings: {
            description: 'The list of converted query strings with account IDs in place of user identifiers.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      CreateCustomFieldContext: {
        additionalProperties: false;
        description: 'The details of a created custom field context.';
        properties: {
          description: {
            description: 'The description of the context.';
            type: 'string';
          };
          id: {
            description: 'The ID of the context.';
            readOnly: true;
            type: 'string';
          };
          issueTypeIds: {
            description: 'The list of issue types IDs for the context. If the list is empty, the context refers to all issue types.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          name: {
            description: 'The name of the context.';
            type: 'string';
          };
          projectIds: {
            description: 'The list of project IDs associated with the context. If the list is empty, the context is global.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
        };
        required: ['name'];
        type: 'object';
      };
      CreateIssueSecuritySchemeDetails: {
        additionalProperties: true;
        description: "Issue security scheme and it's details";
        properties: {
          description: {
            description: 'The description of the issue security scheme.';
            maxLength: 255;
            type: 'string';
            writeOnly: true;
          };
          levels: {
            description: 'The list of scheme levels which should be added to the security scheme.';
            items: {
              $ref: '#/components/schemas/SecuritySchemeLevelBean';
            };
            type: 'array';
            writeOnly: true;
          };
          name: {
            description: 'The name of the issue security scheme. Must be unique (case-insensitive).';
            maxLength: 60;
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['name'];
        type: 'object';
      };
      CreateNotificationSchemeDetails: {
        additionalProperties: true;
        description: 'Details of an notification scheme.';
        properties: {
          description: {
            description: 'The description of the notification scheme.';
            maxLength: 4000;
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the notification scheme. Must be unique (case-insensitive).';
            maxLength: 255;
            type: 'string';
            writeOnly: true;
          };
          notificationSchemeEvents: {
            description: 'The list of notifications which should be added to the notification scheme.';
            items: {
              $ref: '#/components/schemas/NotificationSchemeEventDetails';
            };
            type: 'array';
            writeOnly: true;
          };
        };
        required: ['name'];
        type: 'object';
      };
      CreatePriorityDetails: {
        additionalProperties: true;
        description: 'Details of an issue priority.';
        properties: {
          avatarId: {
            description: 'The ID for the avatar for the priority. Either the iconUrl or avatarId must be defined, but not both. This parameter is nullable and will become mandatory once the iconUrl parameter is deprecated.';
            format: 'int64';
            type: 'integer';
            writeOnly: true;
          };
          description: {
            description: 'The description of the priority.';
            maxLength: 255;
            nullable: true;
            type: 'string';
            writeOnly: true;
          };
          iconUrl: {
            description: 'The URL of an icon for the priority. Accepted protocols are HTTP and HTTPS. Built in icons can also be used. Either the iconUrl or avatarId must be defined, but not both.';
            enum: [
              '/images/icons/priorities/blocker.png',
              '/images/icons/priorities/critical.png',
              '/images/icons/priorities/high.png',
              '/images/icons/priorities/highest.png',
              '/images/icons/priorities/low.png',
              '/images/icons/priorities/lowest.png',
              '/images/icons/priorities/major.png',
              '/images/icons/priorities/medium.png',
              '/images/icons/priorities/minor.png',
              '/images/icons/priorities/trivial.png',
              '/images/icons/priorities/blocker_new.png',
              '/images/icons/priorities/critical_new.png',
              '/images/icons/priorities/high_new.png',
              '/images/icons/priorities/highest_new.png',
              '/images/icons/priorities/low_new.png',
              '/images/icons/priorities/lowest_new.png',
              '/images/icons/priorities/major_new.png',
              '/images/icons/priorities/medium_new.png',
              '/images/icons/priorities/minor_new.png',
              '/images/icons/priorities/trivial_new.png',
            ];
            maxLength: 255;
            nullable: true;
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the priority. Must be unique.';
            maxLength: 60;
            type: 'string';
            writeOnly: true;
          };
          statusColor: {
            description: 'The status color of the priority in 3-digit or 6-digit hexadecimal format.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['name', 'statusColor'];
        type: 'object';
      };
      CreatePrioritySchemeDetails: {
        additionalProperties: false;
        description: 'Details of a new priority scheme';
        properties: {
          defaultPriorityId: {
            description: 'The ID of the default priority for the priority scheme.';
            format: 'int64';
            type: 'integer';
            writeOnly: true;
          };
          description: {
            description: 'The description of the priority scheme.';
            maxLength: 4000;
            type: 'string';
            writeOnly: true;
          };
          mappings: {
            allOf: [
              {
                $ref: '#/components/schemas/PriorityMapping';
              },
            ];
            description: 'Mappings of issue priorities for issues being migrated in and out of this priority scheme.';
          };
          name: {
            description: 'The name of the priority scheme. Must be unique.';
            maxLength: 255;
            type: 'string';
            writeOnly: true;
          };
          priorityIds: {
            description: 'The IDs of priorities in the scheme.';
            items: {
              format: 'int64';
              maxLength: 300;
              minLength: 1;
              type: 'integer';
              writeOnly: true;
            };
            maxLength: 300;
            minLength: 1;
            type: 'array';
            writeOnly: true;
          };
          projectIds: {
            description: 'The IDs of projects that will use the priority scheme.';
            items: {
              format: 'int64';
              type: 'integer';
              writeOnly: true;
            };
            type: 'array';
            uniqueItems: true;
            writeOnly: true;
          };
        };
        required: ['defaultPriorityId', 'name', 'priorityIds'];
        type: 'object';
      };
      CreateProjectDetails: {
        additionalProperties: false;
        description: 'Details about the project.';
        properties: {
          assigneeType: {
            description: 'The default assignee when creating issues for this project.';
            enum: ['PROJECT_LEAD', 'UNASSIGNED'];
            type: 'string';
          };
          avatarId: {
            description: "An integer value for the project's avatar.";
            format: 'int64';
            type: 'integer';
          };
          categoryId: {
            description: "The ID of the project's category. A complete list of category IDs is found using the [Get all project categories](#api-rest-api-3-projectCategory-get) operation.";
            format: 'int64';
            type: 'integer';
          };
          description: {
            description: 'A brief description of the project.';
            type: 'string';
          };
          fieldConfigurationScheme: {
            description: 'The ID of the field configuration scheme for the project. Use the [Get all field configuration schemes](#api-rest-api-3-fieldconfigurationscheme-get) operation to get a list of field configuration scheme IDs. If you specify the field configuration scheme you cannot specify the project template key.';
            format: 'int64';
            type: 'integer';
          };
          issueSecurityScheme: {
            description: 'The ID of the issue security scheme for the project, which enables you to control who can and cannot view issues. Use the [Get issue security schemes](#api-rest-api-3-issuesecurityschemes-get) resource to get all issue security scheme IDs.';
            format: 'int64';
            type: 'integer';
          };
          issueTypeScheme: {
            description: 'The ID of the issue type scheme for the project. Use the [Get all issue type schemes](#api-rest-api-3-issuetypescheme-get) operation to get a list of issue type scheme IDs. If you specify the issue type scheme you cannot specify the project template key.';
            format: 'int64';
            type: 'integer';
          };
          issueTypeScreenScheme: {
            description: 'The ID of the issue type screen scheme for the project. Use the [Get all issue type screen schemes](#api-rest-api-3-issuetypescreenscheme-get) operation to get a list of issue type screen scheme IDs. If you specify the issue type screen scheme you cannot specify the project template key.';
            format: 'int64';
            type: 'integer';
          };
          key: {
            description: 'Project keys must be unique and start with an uppercase letter followed by one or more uppercase alphanumeric characters. The maximum length is 10 characters.';
            type: 'string';
          };
          lead: {
            description: 'This parameter is deprecated because of privacy changes. Use `leadAccountId` instead. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details. The user name of the project lead. Either `lead` or `leadAccountId` must be set when creating a project. Cannot be provided with `leadAccountId`.';
            type: 'string';
          };
          leadAccountId: {
            description: 'The account ID of the project lead. Either `lead` or `leadAccountId` must be set when creating a project. Cannot be provided with `lead`.';
            maxLength: 128;
            type: 'string';
          };
          name: {
            description: 'The name of the project.';
            type: 'string';
          };
          notificationScheme: {
            description: 'The ID of the notification scheme for the project. Use the [Get notification schemes](#api-rest-api-3-notificationscheme-get) resource to get a list of notification scheme IDs.';
            format: 'int64';
            type: 'integer';
          };
          permissionScheme: {
            description: 'The ID of the permission scheme for the project. Use the [Get all permission schemes](#api-rest-api-3-permissionscheme-get) resource to see a list of all permission scheme IDs.';
            format: 'int64';
            type: 'integer';
          };
          projectTemplateKey: {
            description: 'A predefined configuration for a project. The type of the `projectTemplateKey` must match with the type of the `projectTypeKey`.';
            enum: [
              'com.pyxis.greenhopper.jira:gh-simplified-agility-kanban',
              'com.pyxis.greenhopper.jira:gh-simplified-agility-scrum',
              'com.pyxis.greenhopper.jira:gh-simplified-basic',
              'com.pyxis.greenhopper.jira:gh-simplified-kanban-classic',
              'com.pyxis.greenhopper.jira:gh-simplified-scrum-classic',
              'com.pyxis.greenhopper.jira:gh-cross-team-template',
              'com.pyxis.greenhopper.jira:gh-cross-team-planning-template',
              'com.atlassian.servicedesk:simplified-it-service-management',
              'com.atlassian.servicedesk:simplified-it-service-management-basic',
              'com.atlassian.servicedesk:simplified-general-service-desk',
              'com.atlassian.servicedesk:simplified-general-service-desk-it',
              'com.atlassian.servicedesk:simplified-general-service-desk-business',
              'com.atlassian.servicedesk:simplified-internal-service-desk',
              'com.atlassian.servicedesk:simplified-external-service-desk',
              'com.atlassian.servicedesk:simplified-hr-service-desk',
              'com.atlassian.servicedesk:simplified-facilities-service-desk',
              'com.atlassian.servicedesk:simplified-legal-service-desk',
              'com.atlassian.servicedesk:simplified-marketing-service-desk',
              'com.atlassian.servicedesk:simplified-finance-service-desk',
              'com.atlassian.servicedesk:simplified-analytics-service-desk',
              'com.atlassian.servicedesk:simplified-design-service-desk',
              'com.atlassian.servicedesk:simplified-sales-service-desk',
              'com.atlassian.servicedesk:simplified-halp-service-desk',
              'com.atlassian.servicedesk:simplified-blank-project-it',
              'com.atlassian.servicedesk:simplified-blank-project-business',
              'com.atlassian.servicedesk:next-gen-it-service-desk',
              'com.atlassian.servicedesk:next-gen-hr-service-desk',
              'com.atlassian.servicedesk:next-gen-legal-service-desk',
              'com.atlassian.servicedesk:next-gen-marketing-service-desk',
              'com.atlassian.servicedesk:next-gen-facilities-service-desk',
              'com.atlassian.servicedesk:next-gen-general-service-desk',
              'com.atlassian.servicedesk:next-gen-general-it-service-desk',
              'com.atlassian.servicedesk:next-gen-general-business-service-desk',
              'com.atlassian.servicedesk:next-gen-analytics-service-desk',
              'com.atlassian.servicedesk:next-gen-finance-service-desk',
              'com.atlassian.servicedesk:next-gen-design-service-desk',
              'com.atlassian.servicedesk:next-gen-sales-service-desk',
              'com.atlassian.jira-core-project-templates:jira-core-simplified-content-management',
              'com.atlassian.jira-core-project-templates:jira-core-simplified-document-approval',
              'com.atlassian.jira-core-project-templates:jira-core-simplified-lead-tracking',
              'com.atlassian.jira-core-project-templates:jira-core-simplified-process-control',
              'com.atlassian.jira-core-project-templates:jira-core-simplified-procurement',
              'com.atlassian.jira-core-project-templates:jira-core-simplified-project-management',
              'com.atlassian.jira-core-project-templates:jira-core-simplified-recruitment',
              'com.atlassian.jira-core-project-templates:jira-core-simplified-task-',
            ];
            type: 'string';
          };
          projectTypeKey: {
            description: "The [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes), which defines the application-specific feature set. If you don't specify the project template you have to specify the project type.";
            enum: ['software', 'service_desk', 'business'];
            type: 'string';
          };
          url: {
            description: 'A link to information about this project, such as project documentation';
            type: 'string';
          };
          workflowScheme: {
            description: 'The ID of the workflow scheme for the project. Use the [Get all workflow schemes](#api-rest-api-3-workflowscheme-get) operation to get a list of workflow scheme IDs. If you specify the workflow scheme you cannot specify the project template key.';
            format: 'int64';
            type: 'integer';
          };
        };
        required: ['key', 'name'];
        type: 'object';
      };
      CreateResolutionDetails: {
        additionalProperties: true;
        description: 'Details of an issue resolution.';
        properties: {
          description: {
            description: 'The description of the resolution.';
            maxLength: 255;
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the resolution. Must be unique (case-insensitive).';
            maxLength: 60;
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['name'];
        type: 'object';
      };
      CreateUiModificationDetails: {
        additionalProperties: false;
        description: 'The details of a UI modification.';
        properties: {
          contexts: {
            description: 'List of contexts of the UI modification. The maximum number of contexts is 1000.';
            items: {
              $ref: '#/components/schemas/UiModificationContextDetails';
            };
            type: 'array';
            writeOnly: true;
          };
          data: {
            description: 'The data of the UI modification. The maximum size of the data is 50000 characters.';
            type: 'string';
            writeOnly: true;
          };
          description: {
            description: 'The description of the UI modification. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the UI modification. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['name'];
        type: 'object';
      };
      CreateUpdateRoleRequestBean: {
        additionalProperties: false;
        properties: {
          description: {
            description: 'A description of the project role. Required when fully updating a project role. Optional when creating or partially updating a project role.';
            type: 'string';
          };
          name: {
            description: 'The name of the project role. Must be unique. Cannot begin or end with whitespace. The maximum length is 255 characters. Required when creating a project role. Optional when partially updating a project role.';
            type: 'string';
          };
        };
        type: 'object';
      };
      CreateWorkflowCondition: {
        additionalProperties: false;
        description: 'A workflow transition condition.';
        properties: {
          conditions: {
            description: 'The list of workflow conditions.';
            items: {
              $ref: '#/components/schemas/CreateWorkflowCondition';
            };
            type: 'array';
          };
          configuration: {
            additionalProperties: {
              description: 'EXPERIMENTAL. The configuration of the transition rule.';
            };
            description: 'EXPERIMENTAL. The configuration of the transition rule.';
            type: 'object';
          };
          operator: {
            description: 'The compound condition operator.';
            enum: ['AND', 'OR'];
            type: 'string';
          };
          type: {
            description: 'The type of the transition rule.';
            type: 'string';
          };
        };
        type: 'object';
      };
      CreateWorkflowDetails: {
        additionalProperties: false;
        description: 'The details of a workflow.';
        properties: {
          description: {
            description: 'The description of the workflow. The maximum length is 1000 characters.';
            type: 'string';
          };
          name: {
            description: 'The name of the workflow. The name must be unique. The maximum length is 255 characters. Characters can be separated by a whitespace but the name cannot start or end with a whitespace.';
            type: 'string';
          };
          statuses: {
            description: 'The statuses of the workflow. Any status that does not include a transition is added to the workflow without a transition.';
            items: {
              $ref: '#/components/schemas/CreateWorkflowStatusDetails';
            };
            type: 'array';
            uniqueItems: true;
          };
          transitions: {
            description: "The transitions of the workflow. For the request to be valid, these transitions must:\n\n *  include one *initial* transition.\n *  not use the same name for a *global* and *directed* transition.\n *  have a unique name for each *global* transition.\n *  have a unique 'to' status for each *global* transition.\n *  have unique names for each transition from a status.\n *  not have a 'from' status on *initial* and *global* transitions.\n *  have a 'from' status on *directed* transitions.\n\nAll the transition statuses must be included in `statuses`.";
            items: {
              $ref: '#/components/schemas/CreateWorkflowTransitionDetails';
            };
            type: 'array';
          };
        };
        required: ['name', 'statuses', 'transitions'];
        type: 'object';
        writeOnly: true;
      };
      CreateWorkflowStatusDetails: {
        additionalProperties: false;
        description: 'The details of a transition status.';
        properties: {
          id: {
            description: 'The ID of the status.';
            type: 'string';
          };
          properties: {
            additionalProperties: {
              type: 'string';
            };
            description: 'The properties of the status.';
            type: 'object';
          };
        };
        required: ['id'];
        type: 'object';
        writeOnly: true;
      };
      CreateWorkflowTransitionDetails: {
        additionalProperties: false;
        description: 'The details of a workflow transition.';
        properties: {
          description: {
            description: 'The description of the transition. The maximum length is 1000 characters.';
            type: 'string';
          };
          from: {
            description: 'The statuses the transition can start from.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          name: {
            description: 'The name of the transition. The maximum length is 60 characters.';
            type: 'string';
          };
          properties: {
            additionalProperties: {
              type: 'string';
            };
            description: 'The properties of the transition.';
            type: 'object';
          };
          rules: {
            allOf: [
              {
                $ref: '#/components/schemas/CreateWorkflowTransitionRulesDetails';
              },
            ];
            description: 'The rules of the transition.';
          };
          screen: {
            allOf: [
              {
                $ref: '#/components/schemas/CreateWorkflowTransitionScreenDetails';
              },
            ];
            description: 'The screen of the transition.';
          };
          to: {
            description: 'The status the transition goes to.';
            type: 'string';
          };
          type: {
            description: 'The type of the transition.';
            enum: ['global', 'initial', 'directed'];
            type: 'string';
          };
        };
        required: ['name', 'to', 'type'];
        type: 'object';
        writeOnly: true;
      };
      CreateWorkflowTransitionRule: {
        additionalProperties: false;
        description: 'A workflow transition rule.';
        properties: {
          configuration: {
            additionalProperties: {
              description: 'EXPERIMENTAL. The configuration of the transition rule.';
            };
            description: 'EXPERIMENTAL. The configuration of the transition rule.';
            type: 'object';
          };
          type: {
            description: 'The type of the transition rule.';
            type: 'string';
          };
        };
        required: ['type'];
        type: 'object';
      };
      CreateWorkflowTransitionRulesDetails: {
        additionalProperties: false;
        description: 'The details of a workflow transition rules.';
        properties: {
          conditions: {
            allOf: [
              {
                $ref: '#/components/schemas/CreateWorkflowCondition';
              },
            ];
            description: 'The workflow conditions.';
          };
          postFunctions: {
            description: 'The workflow post functions.\n\n**Note:** The default post functions are always added to the *initial* transition, as in:\n\n    "postFunctions": [\n        {\n            "type": "IssueCreateFunction"\n        },\n        {\n            "type": "IssueReindexFunction"\n        },\n        {\n            "type": "FireIssueEventFunction",\n            "configuration": {\n                "event": {\n                    "id": "1",\n                    "name": "issue_created"\n                }\n            }\n        }\n    ]\n\n**Note:** The default post functions are always added to the *global* and *directed* transitions, as in:\n\n    "postFunctions": [\n        {\n            "type": "UpdateIssueStatusFunction"\n        },\n        {\n            "type": "CreateCommentFunction"\n        },\n        {\n            "type": "GenerateChangeHistoryFunction"\n        },\n        {\n            "type": "IssueReindexFunction"\n        },\n        {\n            "type": "FireIssueEventFunction",\n            "configuration": {\n                "event": {\n                    "id": "13",\n                    "name": "issue_generic"\n                }\n            }\n        }\n    ]';
            items: {
              $ref: '#/components/schemas/CreateWorkflowTransitionRule';
            };
            type: 'array';
          };
          validators: {
            description: 'The workflow validators.\n\n**Note:** The default permission validator is always added to the *initial* transition, as in:\n\n    "validators": [\n        {\n            "type": "PermissionValidator",\n            "configuration": {\n                "permissionKey": "CREATE_ISSUES"\n            }\n        }\n    ]';
            items: {
              $ref: '#/components/schemas/CreateWorkflowTransitionRule';
            };
            type: 'array';
          };
        };
        type: 'object';
        writeOnly: true;
      };
      CreateWorkflowTransitionScreenDetails: {
        additionalProperties: false;
        description: 'The details of a transition screen.';
        properties: {
          id: {
            description: 'The ID of the screen.';
            type: 'string';
          };
        };
        required: ['id'];
        type: 'object';
        writeOnly: true;
      };
      CreatedIssue: {
        additionalProperties: false;
        description: 'Details about a created issue or subtask.';
        properties: {
          id: {
            description: 'The ID of the created issue or subtask.';
            readOnly: true;
            type: 'string';
          };
          key: {
            description: 'The key of the created issue or subtask.';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the created issue or subtask.';
            readOnly: true;
            type: 'string';
          };
          transition: {
            allOf: [
              {
                $ref: '#/components/schemas/NestedResponse';
              },
            ];
            description: 'The response code and messages related to any requested transition.';
            readOnly: true;
          };
          watchers: {
            allOf: [
              {
                $ref: '#/components/schemas/NestedResponse';
              },
            ];
            description: 'The response code and messages related to any requested watchers.';
            readOnly: true;
          };
        };
        type: 'object';
      };
      CreatedIssues: {
        additionalProperties: false;
        description: 'Details about the issues created and the errors for requests that failed.';
        properties: {
          errors: {
            description: 'Error details for failed issue creation requests.';
            items: {
              $ref: '#/components/schemas/BulkOperationErrorResult';
            };
            readOnly: true;
            type: 'array';
          };
          issues: {
            description: 'Details of the issues created.';
            items: {
              $ref: '#/components/schemas/CreatedIssue';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      CustomContextVariable: {
        additionalProperties: false;
        discriminator: {
          mapping: {
            issue: '#/components/schemas/IssueContextVariable';
            json: '#/components/schemas/JsonContextVariable';
            user: '#/components/schemas/UserContextVariable';
          };
          propertyName: 'type';
        };
        oneOf: [
          {
            $ref: '#/components/schemas/UserContextVariable';
          },
          {
            $ref: '#/components/schemas/IssueContextVariable';
          },
          {
            $ref: '#/components/schemas/JsonContextVariable';
          },
        ];
        properties: {
          type: {
            description: 'Type of custom context variable.';
            type: 'string';
          };
        };
        required: ['type'];
        type: 'object';
      };
      CustomFieldConfigurations: {
        additionalProperties: false;
        description: 'Details of configurations for a custom field.';
        properties: {
          configurations: {
            description: 'The list of custom field configuration details.';
            items: {
              $ref: '#/components/schemas/ContextualConfiguration';
            };
            maxItems: 1000;
            minItems: 1;
            type: 'array';
            uniqueItems: true;
          };
        };
        required: ['configurations'];
        type: 'object';
        writeOnly: true;
      };
      CustomFieldContext: {
        additionalProperties: false;
        description: 'The details of a custom field context.';
        properties: {
          description: {
            description: 'The description of the context.';
            type: 'string';
          };
          id: {
            description: 'The ID of the context.';
            type: 'string';
          };
          isAnyIssueType: {
            description: 'Whether the context apply to all issue types.';
            type: 'boolean';
          };
          isGlobalContext: {
            description: 'Whether the context is global.';
            type: 'boolean';
          };
          name: {
            description: 'The name of the context.';
            type: 'string';
          };
        };
        required: ['description', 'id', 'isAnyIssueType', 'isGlobalContext', 'name'];
        type: 'object';
      };
      CustomFieldContextDefaultValue: {
        additionalProperties: false;
        discriminator: {
          mapping: {
            datepicker: '#/components/schemas/CustomFieldContextDefaultValueDate';
            datetimepicker: '#/components/schemas/CustomFieldContextDefaultValueDateTime';
            float: '#/components/schemas/CustomFieldContextDefaultValueFloat';
            'forge.datetime': '#/components/schemas/CustomFieldContextDefaultValueForgeDateTimeField';
            'forge.group': '#/components/schemas/CustomFieldContextDefaultValueForgeGroupField';
            'forge.group.list': '#/components/schemas/CustomFieldContextDefaultValueForgeMultiGroupField';
            'forge.number': '#/components/schemas/CustomFieldContextDefaultValueForgeNumberField';
            'forge.object': '#/components/schemas/CustomFieldContextDefaultValueForgeObjectField';
            'forge.string': '#/components/schemas/CustomFieldContextDefaultValueForgeStringField';
            'forge.string.list': '#/components/schemas/CustomFieldContextDefaultValueForgeMultiStringField';
            'forge.user': '#/components/schemas/CustomFieldContextDefaultValueForgeUserField';
            'forge.user.list': '#/components/schemas/CustomFieldContextDefaultValueForgeMultiUserField';
            'grouppicker.multiple': '#/components/schemas/CustomFieldContextDefaultValueMultipleGroupPicker';
            'grouppicker.single': '#/components/schemas/CustomFieldContextDefaultValueSingleGroupPicker';
            labels: '#/components/schemas/CustomFieldContextDefaultValueLabels';
            'multi.user.select': '#/components/schemas/CustomFieldContextDefaultValueMultiUserPicker';
            'option.cascading': '#/components/schemas/CustomFieldContextDefaultValueCascadingOption';
            'option.multiple': '#/components/schemas/CustomFieldContextDefaultValueMultipleOption';
            'option.single': '#/components/schemas/CustomFieldContextDefaultValueSingleOption';
            project: '#/components/schemas/CustomFieldContextDefaultValueProject';
            readonly: '#/components/schemas/CustomFieldContextDefaultValueReadOnly';
            'single.user.select': '#/components/schemas/CustomFieldContextSingleUserPickerDefaults';
            textarea: '#/components/schemas/CustomFieldContextDefaultValueTextArea';
            textfield: '#/components/schemas/CustomFieldContextDefaultValueTextField';
            url: '#/components/schemas/CustomFieldContextDefaultValueURL';
            'version.multiple': '#/components/schemas/CustomFieldContextDefaultValueMultipleVersionPicker';
            'version.single': '#/components/schemas/CustomFieldContextDefaultValueSingleVersionPicker';
          };
          propertyName: 'type';
        };
        oneOf: [
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueCascadingOption';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueMultipleOption';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueSingleOption';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextSingleUserPickerDefaults';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueMultiUserPicker';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueSingleGroupPicker';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueMultipleGroupPicker';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueDate';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueDateTime';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueURL';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueProject';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueFloat';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueLabels';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueTextField';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueTextArea';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueReadOnly';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueSingleVersionPicker';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueMultipleVersionPicker';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueForgeStringField';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueForgeMultiStringField';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueForgeObjectField';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueForgeDateTimeField';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueForgeGroupField';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueForgeMultiGroupField';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueForgeNumberField';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueForgeUserField';
          },
          {
            $ref: '#/components/schemas/CustomFieldContextDefaultValueForgeMultiUserField';
          },
        ];
        type: 'object';
      };
      CustomFieldContextDefaultValueCascadingOption: {
        description: 'The default value for a cascading select custom field.';
        properties: {
          cascadingOptionId: {
            description: 'The ID of the default cascading option.';
            type: 'string';
          };
          contextId: {
            description: 'The ID of the context.';
            type: 'string';
          };
          optionId: {
            description: 'The ID of the default option.';
            type: 'string';
          };
          type: {
            type: 'string';
          };
        };
        required: ['contextId', 'optionId', 'type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueDate: {
        description: 'The default value for a Date custom field.';
        properties: {
          date: {
            description: 'The default date in ISO format. Ignored if `useCurrent` is true.';
            type: 'string';
          };
          type: {
            type: 'string';
          };
          useCurrent: {
            default: false;
            description: 'Whether to use the current date.';
            type: 'boolean';
          };
        };
        required: ['type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueDateTime: {
        description: 'The default value for a date time custom field.';
        properties: {
          dateTime: {
            description: 'The default date-time in ISO format. Ignored if `useCurrent` is true.';
            type: 'string';
          };
          type: {
            type: 'string';
          };
          useCurrent: {
            default: false;
            description: 'Whether to use the current date.';
            type: 'boolean';
          };
        };
        required: ['type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueFloat: {
        description: 'Default value for a float (number) custom field.';
        properties: {
          number: {
            description: 'The default floating-point number.';
            format: 'double';
            type: 'number';
          };
          type: {
            type: 'string';
          };
        };
        required: ['number', 'type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueForgeDateTimeField: {
        description: 'The default value for a Forge date time custom field.';
        properties: {
          contextId: {
            description: 'The ID of the context.';
            type: 'string';
          };
          dateTime: {
            description: 'The default date-time in ISO format. Ignored if `useCurrent` is true.';
            type: 'string';
          };
          type: {
            type: 'string';
          };
          useCurrent: {
            default: false;
            description: 'Whether to use the current date.';
            type: 'boolean';
          };
        };
        required: ['contextId', 'type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueForgeGroupField: {
        description: 'The default value for a Forge group custom field.';
        properties: {
          contextId: {
            description: 'The ID of the context.';
            type: 'string';
          };
          groupId: {
            description: 'The ID of the the default group.';
            type: 'string';
          };
          type: {
            type: 'string';
          };
        };
        required: ['contextId', 'groupId', 'type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueForgeMultiGroupField: {
        description: 'The default value for a Forge collection of groups custom field.';
        properties: {
          contextId: {
            description: 'The ID of the context.';
            type: 'string';
          };
          groupIds: {
            description: 'The IDs of the default groups.';
            items: {
              description: 'The IDs of the default groups.';
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          type: {
            type: 'string';
          };
        };
        required: ['contextId', 'groupIds', 'type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueForgeMultiStringField: {
        description: 'The default text for a Forge collection of strings custom field.';
        properties: {
          type: {
            type: 'string';
          };
          values: {
            description: 'List of string values. The maximum length for a value is 254 characters.';
            items: {
              description: 'List of string values. The maximum length for a value is 254 characters.';
              type: 'string';
            };
            type: 'array';
          };
        };
        required: ['type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueForgeMultiUserField: {
        description: 'Defaults for a Forge collection of users custom field.';
        properties: {
          accountIds: {
            description: 'The IDs of the default users.';
            items: {
              description: 'The IDs of the default users.';
              type: 'string';
            };
            type: 'array';
          };
          contextId: {
            description: 'The ID of the context.';
            type: 'string';
          };
          type: {
            type: 'string';
          };
        };
        required: ['accountIds', 'contextId', 'type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueForgeNumberField: {
        description: 'Default value for a Forge number custom field.';
        properties: {
          contextId: {
            description: 'The ID of the context.';
            type: 'string';
          };
          number: {
            description: 'The default floating-point number.';
            format: 'double';
            type: 'number';
          };
          type: {
            type: 'string';
          };
        };
        required: ['contextId', 'number', 'type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueForgeObjectField: {
        description: 'The default value for a Forge object custom field.';
        properties: {
          object: {
            description: 'The default JSON object.';
            type: 'object';
          };
          type: {
            type: 'string';
          };
        };
        required: ['type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueForgeStringField: {
        description: 'The default text for a Forge string custom field.';
        properties: {
          contextId: {
            description: 'The ID of the context.';
            type: 'string';
          };
          text: {
            description: 'The default text. The maximum length is 254 characters.';
            type: 'string';
          };
          type: {
            type: 'string';
          };
        };
        required: ['contextId', 'type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueForgeUserField: {
        description: 'Defaults for a Forge user custom field.';
        properties: {
          accountId: {
            description: 'The ID of the default user.';
            type: 'string';
          };
          contextId: {
            description: 'The ID of the context.';
            type: 'string';
          };
          type: {
            type: 'string';
          };
          userFilter: {
            $ref: '#/components/schemas/UserFilter';
          };
        };
        required: ['accountId', 'contextId', 'type', 'userFilter'];
        type: 'object';
      };
      CustomFieldContextDefaultValueLabels: {
        description: 'Default value for a labels custom field.';
        properties: {
          labels: {
            description: 'The default labels value.';
            items: {
              description: 'The default labels value.';
              type: 'string';
            };
            type: 'array';
          };
          type: {
            type: 'string';
          };
        };
        required: ['labels', 'type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueMultiUserPicker: {
        description: 'The default value for a User Picker (multiple) custom field.';
        properties: {
          accountIds: {
            description: 'The IDs of the default users.';
            items: {
              description: 'The IDs of the default users.';
              type: 'string';
            };
            type: 'array';
          };
          contextId: {
            description: 'The ID of the context.';
            type: 'string';
          };
          type: {
            type: 'string';
          };
        };
        required: ['accountIds', 'contextId', 'type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueMultipleGroupPicker: {
        description: 'The default value for a multiple group picker custom field.';
        properties: {
          contextId: {
            description: 'The ID of the context.';
            type: 'string';
          };
          groupIds: {
            description: 'The IDs of the default groups.';
            items: {
              description: 'The IDs of the default groups.';
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          type: {
            type: 'string';
          };
        };
        required: ['contextId', 'groupIds', 'type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueMultipleOption: {
        description: 'The default value for a multi-select custom field.';
        properties: {
          contextId: {
            description: 'The ID of the context.';
            type: 'string';
          };
          optionIds: {
            description: 'The list of IDs of the default options.';
            items: {
              description: 'The list of IDs of the default options.';
              type: 'string';
            };
            type: 'array';
          };
          type: {
            type: 'string';
          };
        };
        required: ['contextId', 'optionIds', 'type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueMultipleVersionPicker: {
        description: 'The default value for a multiple version picker custom field.';
        properties: {
          type: {
            type: 'string';
          };
          versionIds: {
            description: 'The IDs of the default versions.';
            items: {
              description: 'The IDs of the default versions.';
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          versionOrder: {
            description: 'The order the pickable versions are displayed in. If not provided, the released-first order is used. Available version orders are `"releasedFirst"` and `"unreleasedFirst"`.';
            type: 'string';
          };
        };
        required: ['type', 'versionIds'];
        type: 'object';
      };
      CustomFieldContextDefaultValueProject: {
        description: 'The default value for a project custom field.';
        properties: {
          contextId: {
            description: 'The ID of the context.';
            type: 'string';
          };
          projectId: {
            description: 'The ID of the default project.';
            type: 'string';
          };
          type: {
            type: 'string';
          };
        };
        required: ['contextId', 'projectId', 'type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueReadOnly: {
        description: 'The default text for a read only custom field.';
        properties: {
          text: {
            description: 'The default text. The maximum length is 255 characters.';
            type: 'string';
          };
          type: {
            type: 'string';
          };
        };
        required: ['type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueSingleGroupPicker: {
        description: 'The default value for a group picker custom field.';
        properties: {
          contextId: {
            description: 'The ID of the context.';
            type: 'string';
          };
          groupId: {
            description: 'The ID of the the default group.';
            type: 'string';
          };
          type: {
            type: 'string';
          };
        };
        required: ['contextId', 'groupId', 'type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueSingleOption: {
        description: 'The default value for a single select custom field.';
        properties: {
          contextId: {
            description: 'The ID of the context.';
            type: 'string';
          };
          optionId: {
            description: 'The ID of the default option.';
            type: 'string';
          };
          type: {
            type: 'string';
          };
        };
        required: ['contextId', 'optionId', 'type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueSingleVersionPicker: {
        description: 'The default value for a version picker custom field.';
        properties: {
          type: {
            type: 'string';
          };
          versionId: {
            description: 'The ID of the default version.';
            type: 'string';
          };
          versionOrder: {
            description: 'The order the pickable versions are displayed in. If not provided, the released-first order is used. Available version orders are `"releasedFirst"` and `"unreleasedFirst"`.';
            type: 'string';
          };
        };
        required: ['type', 'versionId'];
        type: 'object';
      };
      CustomFieldContextDefaultValueTextArea: {
        description: 'The default text for a text area custom field.';
        properties: {
          text: {
            description: 'The default text. The maximum length is 32767 characters.';
            type: 'string';
          };
          type: {
            type: 'string';
          };
        };
        required: ['type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueTextField: {
        description: 'The default text for a text custom field.';
        properties: {
          text: {
            description: 'The default text. The maximum length is 254 characters.';
            type: 'string';
          };
          type: {
            type: 'string';
          };
        };
        required: ['type'];
        type: 'object';
      };
      CustomFieldContextDefaultValueURL: {
        description: 'The default value for a URL custom field.';
        properties: {
          contextId: {
            description: 'The ID of the context.';
            type: 'string';
          };
          type: {
            type: 'string';
          };
          url: {
            description: 'The default URL.';
            type: 'string';
          };
        };
        required: ['contextId', 'type', 'url'];
        type: 'object';
      };
      CustomFieldContextDefaultValueUpdate: {
        additionalProperties: false;
        description: 'Default values to update.';
        properties: {
          defaultValues: {
            items: {
              $ref: '#/components/schemas/CustomFieldContextDefaultValue';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      CustomFieldContextOption: {
        additionalProperties: false;
        description: 'Details of the custom field options for a context.';
        properties: {
          disabled: {
            description: 'Whether the option is disabled.';
            type: 'boolean';
          };
          id: {
            description: 'The ID of the custom field option.';
            type: 'string';
          };
          optionId: {
            description: 'For cascading options, the ID of the custom field option containing the cascading option.';
            type: 'string';
          };
          value: {
            description: 'The value of the custom field option.';
            type: 'string';
          };
        };
        required: ['disabled', 'id', 'value'];
        type: 'object';
      };
      CustomFieldContextProjectMapping: {
        additionalProperties: false;
        description: 'Details of a context to project association.';
        properties: {
          contextId: {
            description: 'The ID of the context.';
            readOnly: true;
            type: 'string';
          };
          isGlobalContext: {
            description: 'Whether context is global.';
            readOnly: true;
            type: 'boolean';
          };
          projectId: {
            description: 'The ID of the project.';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['contextId'];
        type: 'object';
      };
      CustomFieldContextSingleUserPickerDefaults: {
        description: 'Defaults for a User Picker (single) custom field.';
        properties: {
          accountId: {
            description: 'The ID of the default user.';
            type: 'string';
          };
          contextId: {
            description: 'The ID of the context.';
            type: 'string';
          };
          type: {
            type: 'string';
          };
          userFilter: {
            $ref: '#/components/schemas/UserFilter';
          };
        };
        required: ['accountId', 'contextId', 'type', 'userFilter'];
        type: 'object';
      };
      CustomFieldContextUpdateDetails: {
        additionalProperties: false;
        description: 'Details of a custom field context.';
        properties: {
          description: {
            description: 'The description of the custom field context. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the custom field context. The name must be unique. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
        };
        type: 'object';
      };
      CustomFieldCreatedContextOptionsList: {
        additionalProperties: false;
        description: 'A list of custom field options for a context.';
        properties: {
          options: {
            description: 'The created custom field options.';
            items: {
              $ref: '#/components/schemas/CustomFieldContextOption';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      CustomFieldDefinitionJsonBean: {
        additionalProperties: false;
        properties: {
          description: {
            description: 'The description of the custom field, which is displayed in Jira.';
            type: 'string';
          };
          name: {
            description: 'The name of the custom field, which is displayed in Jira. This is not the unique identifier.';
            type: 'string';
          };
          searcherKey: {
            description: "The searcher defines the way the field is searched in Jira. For example, *com.atlassian.jira.plugin.system.customfieldtypes:grouppickersearcher*.  \nThe search UI (basic search and JQL search) will display different operations and values for the field, based on the field searcher. You must specify a searcher that is valid for the field type, as listed below (abbreviated values shown):\n\n *  `cascadingselect`: `cascadingselectsearcher`\n *  `datepicker`: `daterange`\n *  `datetime`: `datetimerange`\n *  `float`: `exactnumber` or `numberrange`\n *  `grouppicker`: `grouppickersearcher`\n *  `importid`: `exactnumber` or `numberrange`\n *  `labels`: `labelsearcher`\n *  `multicheckboxes`: `multiselectsearcher`\n *  `multigrouppicker`: `multiselectsearcher`\n *  `multiselect`: `multiselectsearcher`\n *  `multiuserpicker`: `userpickergroupsearcher`\n *  `multiversion`: `versionsearcher`\n *  `project`: `projectsearcher`\n *  `radiobuttons`: `multiselectsearcher`\n *  `readonlyfield`: `textsearcher`\n *  `select`: `multiselectsearcher`\n *  `textarea`: `textsearcher`\n *  `textfield`: `textsearcher`\n *  `url`: `exacttextsearcher`\n *  `userpicker`: `userpickergroupsearcher`\n *  `version`: `versionsearcher`\n\nIf no searcher is provided, the field isn't searchable. However, [Forge custom fields](https://developer.atlassian.com/platform/forge/manifest-reference/modules/#jira-custom-field-type--beta-) have a searcher set automatically, so are always searchable.";
            enum: [
              'com.atlassian.jira.plugin.system.customfieldtypes:cascadingselectsearcher',
              'com.atlassian.jira.plugin.system.customfieldtypes:daterange',
              'com.atlassian.jira.plugin.system.customfieldtypes:datetimerange',
              'com.atlassian.jira.plugin.system.customfieldtypes:exactnumber',
              'com.atlassian.jira.plugin.system.customfieldtypes:exacttextsearcher',
              'com.atlassian.jira.plugin.system.customfieldtypes:grouppickersearcher',
              'com.atlassian.jira.plugin.system.customfieldtypes:labelsearcher',
              'com.atlassian.jira.plugin.system.customfieldtypes:multiselectsearcher',
              'com.atlassian.jira.plugin.system.customfieldtypes:numberrange',
              'com.atlassian.jira.plugin.system.customfieldtypes:projectsearcher',
              'com.atlassian.jira.plugin.system.customfieldtypes:textsearcher',
              'com.atlassian.jira.plugin.system.customfieldtypes:userpickergroupsearcher',
              'com.atlassian.jira.plugin.system.customfieldtypes:versionsearcher',
            ];
            type: 'string';
          };
          type: {
            description: 'The type of the custom field. These built-in custom field types are available:\n\n *  `cascadingselect`: Enables values to be selected from two levels of select lists (value: `com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect`)\n *  `datepicker`: Stores a date using a picker control (value: `com.atlassian.jira.plugin.system.customfieldtypes:datepicker`)\n *  `datetime`: Stores a date with a time component (value: `com.atlassian.jira.plugin.system.customfieldtypes:datetime`)\n *  `float`: Stores and validates a numeric (floating point) input (value: `com.atlassian.jira.plugin.system.customfieldtypes:float`)\n *  `grouppicker`: Stores a user group using a picker control (value: `com.atlassian.jira.plugin.system.customfieldtypes:grouppicker`)\n *  `importid`: A read-only field that stores the ID the issue had in the system it was imported from (value: `com.atlassian.jira.plugin.system.customfieldtypes:importid`)\n *  `labels`: Stores labels (value: `com.atlassian.jira.plugin.system.customfieldtypes:labels`)\n *  `multicheckboxes`: Stores multiple values using checkboxes (value: ``)\n *  `multigrouppicker`: Stores multiple user groups using a picker control (value: ``)\n *  `multiselect`: Stores multiple values using a select list (value: `com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes`)\n *  `multiuserpicker`: Stores multiple users using a picker control (value: `com.atlassian.jira.plugin.system.customfieldtypes:multigrouppicker`)\n *  `multiversion`: Stores multiple versions from the versions available in a project using a picker control (value: `com.atlassian.jira.plugin.system.customfieldtypes:multiversion`)\n *  `project`: Stores a project from a list of projects that the user is permitted to view (value: `com.atlassian.jira.plugin.system.customfieldtypes:project`)\n *  `radiobuttons`: Stores a value using radio buttons (value: `com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons`)\n *  `readonlyfield`: Stores a read-only text value, which can only be populated via the API (value: `com.atlassian.jira.plugin.system.customfieldtypes:readonlyfield`)\n *  `select`: Stores a value from a configurable list of options (value: `com.atlassian.jira.plugin.system.customfieldtypes:select`)\n *  `textarea`: Stores a long text string using a multiline text area (value: `com.atlassian.jira.plugin.system.customfieldtypes:textarea`)\n *  `textfield`: Stores a text string using a single-line text box (value: `com.atlassian.jira.plugin.system.customfieldtypes:textfield`)\n *  `url`: Stores a URL (value: `com.atlassian.jira.plugin.system.customfieldtypes:url`)\n *  `userpicker`: Stores a user using a picker control (value: `com.atlassian.jira.plugin.system.customfieldtypes:userpicker`)\n *  `version`: Stores a version using a picker control (value: `com.atlassian.jira.plugin.system.customfieldtypes:version`)\n\nTo create a field based on a [Forge custom field type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/#jira-custom-field-type--beta-), use the ID of the Forge custom field type as the value. For example, `ari:cloud:ecosystem::extension/e62f20a2-4b61-4dbe-bfb9-9a88b5e3ac84/548c5df1-24aa-4f7c-bbbb-3038d947cb05/static/my-cf-type-key`.';
            type: 'string';
          };
        };
        required: ['name', 'type'];
        type: 'object';
      };
      CustomFieldOption: {
        additionalProperties: false;
        description: 'Details of a custom option for a field.';
        properties: {
          self: {
            description: 'The URL of these custom field option details.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          value: {
            description: 'The value of the custom field option.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
        xml: {
          name: 'customFieldOption';
        };
      };
      CustomFieldOptionCreate: {
        additionalProperties: false;
        description: 'Details of a custom field option to create.';
        properties: {
          disabled: {
            description: 'Whether the option is disabled.';
            type: 'boolean';
          };
          optionId: {
            description: 'For cascading options, the ID of the custom field object containing the cascading option.';
            type: 'string';
          };
          value: {
            description: 'The value of the custom field option.';
            type: 'string';
          };
        };
        required: ['value'];
        type: 'object';
      };
      CustomFieldOptionUpdate: {
        additionalProperties: false;
        description: 'Details of a custom field option for a context.';
        properties: {
          disabled: {
            description: 'Whether the option is disabled.';
            type: 'boolean';
          };
          id: {
            description: 'The ID of the custom field option.';
            type: 'string';
          };
          value: {
            description: 'The value of the custom field option.';
            type: 'string';
          };
        };
        required: ['id'];
        type: 'object';
      };
      CustomFieldReplacement: {
        additionalProperties: false;
        description: 'Details about the replacement for a deleted version.';
        properties: {
          customFieldId: {
            description: 'The ID of the custom field in which to replace the version number.';
            format: 'int64';
            type: 'integer';
          };
          moveTo: {
            description: 'The version number to use as a replacement for the deleted version.';
            format: 'int64';
            type: 'integer';
          };
        };
        type: 'object';
      };
      CustomFieldUpdatedContextOptionsList: {
        additionalProperties: false;
        description: 'A list of custom field options for a context.';
        properties: {
          options: {
            description: 'The updated custom field options.';
            items: {
              $ref: '#/components/schemas/CustomFieldOptionUpdate';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      CustomFieldValueUpdate: {
        additionalProperties: false;
        description: 'A list of issue IDs and the value to update a custom field to.';
        properties: {
          issueIds: {
            description: 'The list of issue IDs.';
            items: {
              format: 'int64';
              type: 'integer';
              writeOnly: true;
            };
            type: 'array';
            writeOnly: true;
          };
          value: {
            description: 'The value for the custom field. The value must be compatible with the [custom field type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field/#data-types) as follows:\n\n *  `string` the value must be a string.\n *  `number` the value must be a number.\n *  `datetime` the value must be a string that represents a date in the ISO format or the simplified extended ISO format. For example, `"2023-01-18T12:00:00-03:00"` or `"2023-01-18T12:00:00.000Z"`. However, the milliseconds part is ignored.\n *  `user` the value must be an object that contains the `accountId` field.\n *  `group` the value must be an object that contains the group `name` or `groupId` field. Because group names can change, we recommend using `groupId`.\n\nA list of appropriate values must be provided if the field is of the `list` [collection type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field/#collection-types).';
          };
        };
        required: ['issueIds', 'value'];
        type: 'object';
        writeOnly: true;
      };
      CustomFieldValueUpdateDetails: {
        additionalProperties: false;
        description: 'Details of updates for a custom field.';
        properties: {
          updates: {
            description: 'The list of custom field update details.';
            items: {
              $ref: '#/components/schemas/CustomFieldValueUpdate';
            };
            type: 'array';
          };
        };
        type: 'object';
        writeOnly: true;
      };
      Dashboard: {
        additionalProperties: false;
        description: 'Details of a dashboard.';
        properties: {
          automaticRefreshMs: {
            description: 'The automatic refresh interval for the dashboard in milliseconds.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          description: {
            type: 'string';
          };
          editPermissions: {
            description: 'The details of any edit share permissions for the dashboard.';
            items: {
              $ref: '#/components/schemas/SharePermission';
            };
            readOnly: true;
            type: 'array';
          };
          id: {
            description: 'The ID of the dashboard.';
            readOnly: true;
            type: 'string';
          };
          isFavourite: {
            description: 'Whether the dashboard is selected as a favorite by the user.';
            readOnly: true;
            type: 'boolean';
          };
          isWritable: {
            description: 'Whether the current user has permission to edit the dashboard.';
            readOnly: true;
            type: 'boolean';
          };
          name: {
            description: 'The name of the dashboard.';
            readOnly: true;
            type: 'string';
          };
          owner: {
            allOf: [
              {
                $ref: '#/components/schemas/UserBean';
              },
            ];
            description: 'The owner of the dashboard.';
            readOnly: true;
          };
          popularity: {
            description: 'The number of users who have this dashboard as a favorite.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          rank: {
            description: 'The rank of this dashboard.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          self: {
            description: 'The URL of these dashboard details.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          sharePermissions: {
            description: 'The details of any view share permissions for the dashboard.';
            items: {
              $ref: '#/components/schemas/SharePermission';
            };
            readOnly: true;
            type: 'array';
          };
          systemDashboard: {
            description: 'Whether the current dashboard is system dashboard.';
            readOnly: true;
            type: 'boolean';
          };
          view: {
            description: 'The URL of the dashboard.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      DashboardDetails: {
        additionalProperties: false;
        description: 'Details of a dashboard.';
        properties: {
          description: {
            description: 'The description of the dashboard.';
            type: 'string';
          };
          editPermissions: {
            description: 'The edit permissions for the dashboard.';
            items: {
              $ref: '#/components/schemas/SharePermission';
            };
            type: 'array';
          };
          name: {
            description: 'The name of the dashboard.';
            type: 'string';
          };
          sharePermissions: {
            description: 'The share permissions for the dashboard.';
            items: {
              $ref: '#/components/schemas/SharePermission';
            };
            type: 'array';
          };
        };
        required: ['editPermissions', 'name', 'sharePermissions'];
        type: 'object';
      };
      DashboardGadget: {
        additionalProperties: false;
        description: 'Details of a gadget.';
        properties: {
          color: {
            description: 'The color of the gadget. Should be one of `blue`, `red`, `yellow`, `green`, `cyan`, `purple`, `gray`, or `white`.';
            enum: ['blue', 'red', 'yellow', 'green', 'cyan', 'purple', 'gray', 'white'];
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the gadget instance.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          moduleKey: {
            description: 'The module key of the gadget type.';
            readOnly: true;
            type: 'string';
          };
          position: {
            allOf: [
              {
                $ref: '#/components/schemas/DashboardGadgetPosition';
              },
            ];
            description: 'The position of the gadget.';
            readOnly: true;
          };
          title: {
            description: 'The title of the gadget.';
            readOnly: true;
            type: 'string';
          };
          uri: {
            description: 'The URI of the gadget type.';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['color', 'id', 'position', 'title'];
        type: 'object';
      };
      DashboardGadgetPosition: {
        additionalProperties: false;
        description: 'Details of a gadget position.';
        properties: {
          'The column position of the gadget.': {
            format: 'int32';
            type: 'integer';
          };
          'The row position of the gadget.': {
            format: 'int32';
            type: 'integer';
          };
        };
        required: ['The column position of the gadget.', 'The row position of the gadget.'];
        type: 'object';
        writeOnly: true;
      };
      DashboardGadgetResponse: {
        additionalProperties: false;
        description: 'The list of gadgets on the dashboard.';
        properties: {
          gadgets: {
            description: 'The list of gadgets.';
            items: {
              $ref: '#/components/schemas/DashboardGadget';
            };
            readOnly: true;
            type: 'array';
          };
        };
        required: ['gadgets'];
        type: 'object';
      };
      DashboardGadgetSettings: {
        additionalProperties: false;
        description: 'Details of the settings for a dashboard gadget.';
        properties: {
          color: {
            description: 'The color of the gadget. Should be one of `blue`, `red`, `yellow`, `green`, `cyan`, `purple`, `gray`, or `white`.';
            type: 'string';
            writeOnly: true;
          };
          ignoreUriAndModuleKeyValidation: {
            description: "Whether to ignore the validation of module key and URI. For example, when a gadget is created that is a part of an application that isn't installed.";
            type: 'boolean';
            writeOnly: true;
          };
          moduleKey: {
            description: "The module key of the gadget type. Can't be provided with `uri`.";
            type: 'string';
            writeOnly: true;
          };
          position: {
            allOf: [
              {
                $ref: '#/components/schemas/DashboardGadgetPosition';
              },
            ];
            description: 'The position of the gadget. When the gadget is placed into the position, other gadgets in the same column are moved down to accommodate it.';
          };
          title: {
            description: 'The title of the gadget.';
            type: 'string';
            writeOnly: true;
          };
          uri: {
            description: "The URI of the gadget type. Can't be provided with `moduleKey`.";
            type: 'string';
            writeOnly: true;
          };
        };
        type: 'object';
      };
      DashboardGadgetUpdateRequest: {
        additionalProperties: false;
        description: 'The details of the gadget to update.';
        properties: {
          color: {
            description: 'The color of the gadget. Should be one of `blue`, `red`, `yellow`, `green`, `cyan`, `purple`, `gray`, or `white`.';
            type: 'string';
            writeOnly: true;
          };
          position: {
            allOf: [
              {
                $ref: '#/components/schemas/DashboardGadgetPosition';
              },
            ];
            description: 'The position of the gadget.';
          };
          title: {
            description: 'The title of the gadget.';
            type: 'string';
            writeOnly: true;
          };
        };
        type: 'object';
      };
      DataClassificationLevelsBean: {
        additionalProperties: false;
        description: 'The data classification.';
        properties: {
          classifications: {
            description: 'The data classifications.';
            items: {
              $ref: '#/components/schemas/DataClassificationTagBean';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      DataClassificationTagBean: {
        additionalProperties: false;
        description: 'The data classification.';
        properties: {
          color: {
            description: 'The color of the data classification object.';
            type: 'string';
          };
          description: {
            description: 'The description of the data classification object.';
            type: 'string';
          };
          guideline: {
            description: 'The guideline of the data classification object.';
            type: 'string';
          };
          id: {
            description: 'The ID of the data classification object.';
            type: 'string';
          };
          name: {
            description: 'The name of the data classification object.';
            type: 'string';
          };
          rank: {
            description: 'The rank of the data classification object.';
            format: 'int32';
            type: 'integer';
          };
          status: {
            description: 'The status of the data classification object.';
            type: 'string';
          };
        };
        required: ['id', 'status'];
        type: 'object';
      };
      DateRangeFilterRequest: {
        additionalProperties: false;
        description: 'List issues archived within a specified date range.';
        properties: {
          dateAfter: {
            description: 'List issues archived after a specified date, passed in the YYYY-MM-DD format.';
            type: 'string';
          };
          dateBefore: {
            description: 'List issues archived before a specified date provided in the YYYY-MM-DD format.';
            type: 'string';
          };
        };
        required: ['dateAfter', 'dateBefore'];
        type: 'object';
      };
      DefaultLevelValue: {
        additionalProperties: true;
        description: 'Details of scheme and new default level.';
        maxLength: 1000;
        properties: {
          defaultLevelId: {
            description: 'The ID of the issue security level to set as default for the specified scheme. Providing null will reset the default level.';
            type: 'string';
            writeOnly: true;
          };
          issueSecuritySchemeId: {
            description: 'The ID of the issue security scheme to set default level for.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['defaultLevelId', 'issueSecuritySchemeId'];
        type: 'object';
        writeOnly: true;
      };
      DefaultShareScope: {
        additionalProperties: false;
        description: 'Details of the scope of the default sharing for new filters and dashboards.';
        properties: {
          scope: {
            description: 'The scope of the default sharing for new filters and dashboards:\n\n *  `AUTHENTICATED` Shared with all logged-in users.\n *  `GLOBAL` Shared with all logged-in users. This shows as `AUTHENTICATED` in the response.\n *  `PRIVATE` Not shared with any users.';
            enum: ['GLOBAL', 'AUTHENTICATED', 'PRIVATE'];
            type: 'string';
          };
        };
        required: ['scope'];
        type: 'object';
        xml: {
          name: 'defaultShareScope';
        };
      };
      DefaultWorkflow: {
        additionalProperties: false;
        description: 'Details about the default workflow.';
        properties: {
          updateDraftIfNeeded: {
            description: 'Whether a draft workflow scheme is created or updated when updating an active workflow scheme. The draft is updated with the new default workflow. Defaults to `false`.';
            type: 'boolean';
          };
          workflow: {
            description: 'The name of the workflow to set as the default workflow.';
            type: 'string';
          };
        };
        required: ['workflow'];
        type: 'object';
      };
      DeleteAndReplaceVersionBean: {
        additionalProperties: false;
        properties: {
          customFieldReplacementList: {
            description: 'An array of custom field IDs (`customFieldId`) and version IDs (`moveTo`) to update when the fields contain the deleted version.';
            items: {
              $ref: '#/components/schemas/CustomFieldReplacement';
            };
            type: 'array';
          };
          moveAffectedIssuesTo: {
            description: 'The ID of the version to update `affectedVersion` to when the field contains the deleted version.';
            format: 'int64';
            type: 'integer';
          };
          moveFixIssuesTo: {
            description: 'The ID of the version to update `fixVersion` to when the field contains the deleted version.';
            format: 'int64';
            type: 'integer';
          };
        };
        type: 'object';
      };
      DeprecatedWorkflow: {
        additionalProperties: false;
        description: 'Details about a workflow.';
        properties: {
          default: {
            type: 'boolean';
          };
          description: {
            description: 'The description of the workflow.';
            readOnly: true;
            type: 'string';
          };
          lastModifiedDate: {
            description: 'The datetime the workflow was last modified.';
            readOnly: true;
            type: 'string';
          };
          lastModifiedUser: {
            description: 'This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.';
            readOnly: true;
            type: 'string';
          };
          lastModifiedUserAccountId: {
            description: 'The account ID of the user that last modified the workflow.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The name of the workflow.';
            readOnly: true;
            type: 'string';
          };
          scope: {
            allOf: [
              {
                $ref: '#/components/schemas/Scope';
              },
            ];
            description: 'The scope where this workflow applies';
            readOnly: true;
          };
          steps: {
            description: 'The number of steps included in the workflow.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
        };
        type: 'object';
      };
      DetailedErrorCollection: {
        additionalProperties: false;
        properties: {
          details: {
            additionalProperties: {};
            description: 'Map of objects representing additional details for an error';
            type: 'object';
          };
          errorMessages: {
            description: 'The list of error messages produced by this operation. For example, "input parameter \'key\' must be provided"';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          errors: {
            additionalProperties: {
              type: 'string';
            };
            description: 'The list of errors by parameter returned by the operation. For example,"projectKey": "Project keys must start with an uppercase letter, followed by one or more uppercase alphanumeric characters."';
            type: 'object';
          };
        };
        type: 'object';
      };
      DocumentVersion: {
        additionalProperties: false;
        description: 'The current version details of this workflow scheme.';
        properties: {
          id: {
            description: 'The version UUID.';
            type: 'string';
          };
          versionNumber: {
            description: 'The version number.';
            format: 'int64';
            type: 'integer';
          };
        };
        required: ['id', 'versionNumber'];
        type: 'object';
      };
      EntityProperty: {
        additionalProperties: false;
        description: 'An entity property, for more information see [Entity properties](https://developer.atlassian.com/cloud/jira/platform/jira-entity-properties/).';
        properties: {
          key: {
            description: 'The key of the property. Required on create and update.';
            type: 'string';
          };
          value: {
            description: 'The value of the property. Required on create and update.';
          };
        };
        type: 'object';
      };
      EntityPropertyDetails: {
        properties: {
          entityId: {
            description: 'The entity property ID.';
            example: 123;
            type: 'number';
          };
          key: {
            description: 'The entity property key.';
            example: 'mykey';
            type: 'string';
          };
          value: {
            description: 'The new value of the entity property.';
            example: 'newValue';
            type: 'string';
          };
        };
        required: ['entityId', 'key', 'value'];
        type: 'object';
      };
      Error: {
        additionalProperties: false;
        properties: {
          count: {
            format: 'int64';
            type: 'integer';
          };
          issueIdsOrKeys: {
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          message: {
            type: 'string';
          };
        };
        type: 'object';
      };
      ErrorCollection: {
        additionalProperties: false;
        description: 'Error messages from an operation.';
        properties: {
          errorMessages: {
            description: 'The list of error messages produced by this operation. For example, "input parameter \'key\' must be provided"';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          errors: {
            additionalProperties: {
              type: 'string';
            };
            description: 'The list of errors by parameter returned by the operation. For example,"projectKey": "Project keys must start with an uppercase letter, followed by one or more uppercase alphanumeric characters."';
            type: 'object';
          };
          status: {
            format: 'int32';
            type: 'integer';
          };
        };
        type: 'object';
      };
      ErrorCollections: {
        additionalProperties: false;
        type: 'object';
      };
      ErrorMessage: {
        additionalProperties: false;
        properties: {
          message: {
            type: 'string';
          };
        };
        type: 'object';
      };
      Errors: {
        additionalProperties: false;
        properties: {
          issueIsSubtask: {
            $ref: '#/components/schemas/Error';
          };
          issuesInArchivedProjects: {
            $ref: '#/components/schemas/Error';
          };
          issuesInUnlicensedProjects: {
            $ref: '#/components/schemas/Error';
          };
          issuesNotFound: {
            $ref: '#/components/schemas/Error';
          };
          userDoesNotHavePermission: {
            $ref: '#/components/schemas/Error';
          };
        };
        type: 'object';
      };
      EventNotification: {
        additionalProperties: false;
        description: 'Details about a notification associated with an event.';
        properties: {
          emailAddress: {
            description: 'The email address.';
            type: 'string';
          };
          expand: {
            description: 'Expand options that include additional event notification details in the response.';
            type: 'string';
          };
          field: {
            allOf: [
              {
                $ref: '#/components/schemas/FieldDetails';
              },
            ];
            description: 'The custom user or group field.';
          };
          group: {
            allOf: [
              {
                $ref: '#/components/schemas/GroupName';
              },
            ];
            description: 'The specified group.';
          };
          id: {
            description: 'The ID of the notification.';
            format: 'int64';
            type: 'integer';
          };
          notificationType: {
            description: 'Identifies the recipients of the notification.';
            enum: [
              'CurrentAssignee',
              'Reporter',
              'CurrentUser',
              'ProjectLead',
              'ComponentLead',
              'User',
              'Group',
              'ProjectRole',
              'EmailAddress',
              'AllWatchers',
              'UserCustomField',
              'GroupCustomField',
            ];
            type: 'string';
          };
          parameter: {
            description: "As a group's name can change, use of `recipient` is recommended. The identifier associated with the `notificationType` value that defines the receiver of the notification, where the receiver isn't implied by `notificationType` value. So, when `notificationType` is:\n\n *  `User` The `parameter` is the user account ID.\n *  `Group` The `parameter` is the group name.\n *  `ProjectRole` The `parameter` is the project role ID.\n *  `UserCustomField` The `parameter` is the ID of the custom field.\n *  `GroupCustomField` The `parameter` is the ID of the custom field.";
            type: 'string';
          };
          projectRole: {
            allOf: [
              {
                $ref: '#/components/schemas/ProjectRole';
              },
            ];
            description: 'The specified project role.';
          };
          recipient: {
            description: "The identifier associated with the `notificationType` value that defines the receiver of the notification, where the receiver isn't implied by the `notificationType` value. So, when `notificationType` is:\n\n *  `User`, `recipient` is the user account ID.\n *  `Group`, `recipient` is the group ID.\n *  `ProjectRole`, `recipient` is the project role ID.\n *  `UserCustomField`, `recipient` is the ID of the custom field.\n *  `GroupCustomField`, `recipient` is the ID of the custom field.";
            type: 'string';
          };
          user: {
            allOf: [
              {
                $ref: '#/components/schemas/UserDetails';
              },
            ];
            description: 'The specified user.';
          };
        };
        type: 'object';
      };
      ExpandPrioritySchemeBean: {
        additionalProperties: false;
        description: 'A priority scheme with less fields to be used in for an API expand response.';
        properties: {
          id: {
            description: 'The ID of the priority scheme.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The name of the priority scheme.';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the priority scheme.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      ExpandPrioritySchemePage: {
        additionalProperties: true;
        properties: {
          maxResults: {
            format: 'int32';
            type: 'integer';
          };
          startAt: {
            format: 'int64';
            type: 'integer';
          };
          total: {
            format: 'int64';
            type: 'integer';
          };
        };
        type: 'object';
      };
      ExportArchivedIssuesTaskProgressResponse: {
        additionalProperties: false;
        description: 'The response for status request for a running/completed export task.';
        properties: {
          fileUrl: {
            type: 'string';
          };
          payload: {
            type: 'string';
          };
          progress: {
            format: 'int64';
            type: 'integer';
          };
          status: {
            type: 'string';
          };
          submittedTime: {
            format: 'date-time';
            type: 'string';
          };
          taskId: {
            type: 'string';
          };
        };
        type: 'object';
      };
      FailedWebhook: {
        additionalProperties: false;
        description: 'Details about a failed webhook.';
        properties: {
          body: {
            description: 'The webhook body.';
            type: 'string';
          };
          failureTime: {
            description: 'The time the webhook was added to the list of failed webhooks (that is, the time of the last failed retry).';
            format: 'int64';
            type: 'integer';
          };
          id: {
            description: 'The webhook ID, as sent in the `X-Atlassian-Webhook-Identifier` header with the webhook.';
            type: 'string';
          };
          url: {
            description: 'The original webhook destination.';
            type: 'string';
          };
        };
        required: ['failureTime', 'id', 'url'];
        type: 'object';
      };
      FailedWebhooks: {
        additionalProperties: false;
        description: 'A page of failed webhooks.';
        properties: {
          maxResults: {
            description: 'The maximum number of items on the page. If the list of values is shorter than this number, then there are no more pages.';
            format: 'int32';
            type: 'integer';
          };
          next: {
            description: 'The URL to the next page of results. Present only if the request returned at least one result.The next page may be empty at the time of receiving the response, but new failed webhooks may appear in time. You can save the URL to the next page and query for new results periodically (for example, every hour).';
            format: 'uri';
            type: 'string';
          };
          values: {
            description: 'The list of webhooks.';
            items: {
              $ref: '#/components/schemas/FailedWebhook';
            };
            type: 'array';
          };
        };
        required: ['maxResults', 'values'];
        type: 'object';
      };
      Field: {
        additionalProperties: false;
        description: 'Details of a field.';
        properties: {
          contextsCount: {
            description: 'Number of contexts where the field is used.';
            format: 'int64';
            type: 'integer';
          };
          description: {
            description: 'The description of the field.';
            type: 'string';
          };
          id: {
            description: 'The ID of the field.';
            type: 'string';
          };
          isLocked: {
            description: 'Whether the field is locked.';
            type: 'boolean';
          };
          isUnscreenable: {
            description: 'Whether the field is shown on screen or not.';
            type: 'boolean';
          };
          key: {
            description: 'The key of the field.';
            type: 'string';
          };
          lastUsed: {
            $ref: '#/components/schemas/FieldLastUsed';
          };
          name: {
            description: 'The name of the field.';
            type: 'string';
          };
          projectsCount: {
            description: 'Number of projects where the field is used.';
            format: 'int64';
            type: 'integer';
          };
          schema: {
            $ref: '#/components/schemas/JsonTypeBean';
          };
          screensCount: {
            description: 'Number of screens where the field is used.';
            format: 'int64';
            type: 'integer';
          };
          searcherKey: {
            description: 'The searcher key of the field. Returned for custom fields.';
            type: 'string';
          };
          stableId: {
            description: 'The stable ID of the field.';
            type: 'string';
          };
        };
        required: ['id', 'name', 'schema'];
        type: 'object';
      };
      FieldChangedClause: {
        description: 'A clause that asserts whether a field was changed. For example, `status CHANGED AFTER startOfMonth(-1M)`.See [CHANGED](https://confluence.atlassian.com/x/dgiiLQ#Advancedsearching-operatorsreference-CHANGEDCHANGED) for more information about the CHANGED operator.';
        properties: {
          field: {
            $ref: '#/components/schemas/JqlQueryField';
          };
          operator: {
            description: 'The operator applied to the field.';
            enum: ['changed'];
            type: 'string';
          };
          predicates: {
            description: 'The list of time predicates.';
            items: {
              $ref: '#/components/schemas/JqlQueryClauseTimePredicate';
            };
            type: 'array';
          };
        };
        required: ['field', 'operator', 'predicates'];
        type: 'object';
      };
      FieldConfiguration: {
        additionalProperties: false;
        description: 'Details of a field configuration.';
        properties: {
          description: {
            description: 'The description of the field configuration.';
            type: 'string';
          };
          id: {
            description: 'The ID of the field configuration.';
            format: 'int64';
            type: 'integer';
          };
          isDefault: {
            description: 'Whether the field configuration is the default.';
            type: 'boolean';
          };
          name: {
            description: 'The name of the field configuration.';
            type: 'string';
          };
        };
        required: ['description', 'id', 'name'];
        type: 'object';
      };
      FieldConfigurationDetails: {
        additionalProperties: false;
        description: 'Details of a field configuration.';
        properties: {
          description: {
            description: 'The description of the field configuration.';
            maxLength: 255;
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the field configuration. Must be unique.';
            maxLength: 255;
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['name'];
        type: 'object';
      };
      FieldConfigurationIssueTypeItem: {
        additionalProperties: false;
        description: 'The field configuration for an issue type.';
        properties: {
          fieldConfigurationId: {
            description: 'The ID of the field configuration.';
            type: 'string';
          };
          fieldConfigurationSchemeId: {
            description: 'The ID of the field configuration scheme.';
            type: 'string';
          };
          issueTypeId: {
            description: 'The ID of the issue type or *default*. When set to *default* this field configuration issue type item applies to all issue types without a field configuration.';
            type: 'string';
          };
        };
        required: ['fieldConfigurationId', 'fieldConfigurationSchemeId', 'issueTypeId'];
        type: 'object';
      };
      FieldConfigurationItem: {
        additionalProperties: false;
        description: 'A field within a field configuration.';
        properties: {
          description: {
            description: 'The description of the field within the field configuration.';
            type: 'string';
          };
          id: {
            description: 'The ID of the field within the field configuration.';
            type: 'string';
          };
          isHidden: {
            description: 'Whether the field is hidden in the field configuration.';
            type: 'boolean';
          };
          isRequired: {
            description: 'Whether the field is required in the field configuration.';
            type: 'boolean';
          };
          renderer: {
            description: 'The renderer type for the field within the field configuration.';
            type: 'string';
          };
        };
        required: ['id'];
        type: 'object';
      };
      FieldConfigurationItemsDetails: {
        additionalProperties: false;
        description: 'Details of field configuration items.';
        properties: {
          fieldConfigurationItems: {
            description: 'Details of fields in a field configuration.';
            items: {
              $ref: '#/components/schemas/FieldConfigurationItem';
            };
            type: 'array';
            writeOnly: true;
          };
        };
        required: ['fieldConfigurationItems'];
        type: 'object';
      };
      FieldConfigurationScheme: {
        additionalProperties: false;
        description: 'Details of a field configuration scheme.';
        properties: {
          description: {
            description: 'The description of the field configuration scheme.';
            type: 'string';
          };
          id: {
            description: 'The ID of the field configuration scheme.';
            type: 'string';
          };
          name: {
            description: 'The name of the field configuration scheme.';
            type: 'string';
          };
        };
        required: ['id', 'name'];
        type: 'object';
      };
      FieldConfigurationSchemeProjectAssociation: {
        additionalProperties: false;
        description: 'Associated field configuration scheme and project.';
        properties: {
          fieldConfigurationSchemeId: {
            description: 'The ID of the field configuration scheme. If the field configuration scheme ID is `null`, the operation assigns the default field configuration scheme.';
            type: 'string';
            writeOnly: true;
          };
          projectId: {
            description: 'The ID of the project.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['projectId'];
        type: 'object';
      };
      FieldConfigurationSchemeProjects: {
        additionalProperties: false;
        description: 'Project list with assigned field configuration schema.';
        properties: {
          fieldConfigurationScheme: {
            $ref: '#/components/schemas/FieldConfigurationScheme';
          };
          projectIds: {
            description: 'The IDs of projects using the field configuration scheme.';
            items: {
              description: 'The IDs of projects using the field configuration scheme.';
              type: 'string';
            };
            type: 'array';
          };
        };
        required: ['projectIds'];
        type: 'object';
      };
      FieldConfigurationToIssueTypeMapping: {
        additionalProperties: false;
        description: 'The field configuration to issue type mapping.';
        properties: {
          fieldConfigurationId: {
            description: 'The ID of the field configuration.';
            type: 'string';
            writeOnly: true;
          };
          issueTypeId: {
            description: 'The ID of the issue type or *default*. When set to *default* this field configuration issue type item applies to all issue types without a field configuration. An issue type can be included only once in a request.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['fieldConfigurationId', 'issueTypeId'];
        type: 'object';
        writeOnly: true;
      };
      FieldCreateMetadata: {
        additionalProperties: false;
        description: 'The metadata describing an issue field for createmeta.';
        properties: {
          allowedValues: {
            description: 'The list of values allowed in the field.';
            items: {
              readOnly: true;
            };
            readOnly: true;
            type: 'array';
          };
          autoCompleteUrl: {
            description: 'The URL that can be used to automatically complete the field.';
            readOnly: true;
            type: 'string';
          };
          configuration: {
            additionalProperties: {
              readOnly: true;
            };
            description: 'The configuration properties.';
            readOnly: true;
            type: 'object';
          };
          defaultValue: {
            description: 'The default value of the field.';
            readOnly: true;
          };
          fieldId: {
            description: 'The field id.';
            readOnly: true;
            type: 'string';
          };
          hasDefaultValue: {
            description: 'Whether the field has a default value.';
            readOnly: true;
            type: 'boolean';
          };
          key: {
            description: 'The key of the field.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The name of the field.';
            readOnly: true;
            type: 'string';
          };
          operations: {
            description: 'The list of operations that can be performed on the field.';
            items: {
              readOnly: true;
              type: 'string';
            };
            readOnly: true;
            type: 'array';
          };
          required: {
            description: 'Whether the field is required.';
            readOnly: true;
            type: 'boolean';
          };
          schema: {
            allOf: [
              {
                $ref: '#/components/schemas/JsonTypeBean';
              },
            ];
            description: 'The data type of the field.';
            readOnly: true;
          };
        };
        required: ['fieldId', 'key', 'name', 'operations', 'required', 'schema'];
        type: 'object';
        xml: {
          name: 'availableField';
        };
      };
      FieldDetails: {
        additionalProperties: false;
        description: 'Details about a field.';
        properties: {
          clauseNames: {
            description: 'The names that can be used to reference the field in an advanced search. For more information, see [Advanced searching - fields reference](https://confluence.atlassian.com/x/gwORLQ).';
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          custom: {
            description: 'Whether the field is a custom field.';
            type: 'boolean';
          };
          id: {
            description: 'The ID of the field.';
            type: 'string';
          };
          key: {
            description: 'The key of the field.';
            type: 'string';
          };
          name: {
            description: 'The name of the field.';
            type: 'string';
          };
          navigable: {
            description: 'Whether the field can be used as a column on the issue navigator.';
            type: 'boolean';
          };
          orderable: {
            description: 'Whether the content of the field can be used to order lists.';
            type: 'boolean';
          };
          schema: {
            allOf: [
              {
                $ref: '#/components/schemas/JsonTypeBean';
              },
            ];
            description: 'The data schema for the field.';
          };
          scope: {
            allOf: [
              {
                $ref: '#/components/schemas/Scope';
              },
            ];
            description: 'The scope of the field.';
          };
          searchable: {
            description: 'Whether the content of the field can be searched.';
            type: 'boolean';
          };
        };
        type: 'object';
        xml: {
          name: 'field';
        };
      };
      FieldLastUsed: {
        additionalProperties: false;
        description: 'Information about the most recent use of a field.';
        properties: {
          type: {
            description: 'Last used value type:\n\n *  *TRACKED*: field is tracked and a last used date is available.\n *  *NOT\\_TRACKED*: field is not tracked, last used date is not available.\n *  *NO\\_INFORMATION*: field is tracked, but no last used date is available.';
            enum: ['TRACKED', 'NOT_TRACKED', 'NO_INFORMATION'];
            type: 'string';
          };
          value: {
            description: 'The date when the value of the field last changed.';
            format: 'date-time';
            type: 'string';
          };
        };
        type: 'object';
      };
      FieldMetadata: {
        additionalProperties: false;
        description: 'The metadata describing an issue field.';
        properties: {
          allowedValues: {
            description: 'The list of values allowed in the field.';
            items: {
              readOnly: true;
            };
            readOnly: true;
            type: 'array';
          };
          autoCompleteUrl: {
            description: 'The URL that can be used to automatically complete the field.';
            readOnly: true;
            type: 'string';
          };
          configuration: {
            additionalProperties: {
              readOnly: true;
            };
            description: 'The configuration properties.';
            readOnly: true;
            type: 'object';
          };
          defaultValue: {
            description: 'The default value of the field.';
            readOnly: true;
          };
          hasDefaultValue: {
            description: 'Whether the field has a default value.';
            readOnly: true;
            type: 'boolean';
          };
          key: {
            description: 'The key of the field.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The name of the field.';
            readOnly: true;
            type: 'string';
          };
          operations: {
            description: 'The list of operations that can be performed on the field.';
            items: {
              readOnly: true;
              type: 'string';
            };
            readOnly: true;
            type: 'array';
          };
          required: {
            description: 'Whether the field is required.';
            readOnly: true;
            type: 'boolean';
          };
          schema: {
            allOf: [
              {
                $ref: '#/components/schemas/JsonTypeBean';
              },
            ];
            description: 'The data type of the field.';
            readOnly: true;
          };
        };
        required: ['key', 'name', 'operations', 'required', 'schema'];
        type: 'object';
        xml: {
          name: 'availableField';
        };
      };
      FieldReferenceData: {
        additionalProperties: false;
        description: 'Details of a field that can be used in advanced searches.';
        properties: {
          auto: {
            description: 'Whether the field provide auto-complete suggestions.';
            enum: ['true', 'false'];
            type: 'string';
          };
          cfid: {
            description: 'If the item is a custom field, the ID of the custom field.';
            type: 'string';
          };
          deprecated: {
            description: 'Whether this field has been deprecated.';
            enum: ['true', 'false'];
            type: 'string';
          };
          deprecatedSearcherKey: {
            description: 'The searcher key of the field, only passed when the field is deprecated.';
            type: 'string';
          };
          displayName: {
            description: 'The display name contains the following:\n\n *  for system fields, the field name. For example, `Summary`.\n *  for collapsed custom fields, the field name followed by a hyphen and then the field name and field type. For example, `Component - Component[Dropdown]`.\n *  for other custom fields, the field name followed by a hyphen and then the custom field ID. For example, `Component - cf[10061]`.';
            type: 'string';
          };
          operators: {
            description: 'The valid search operators for the field.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          orderable: {
            description: "Whether the field can be used in a query's `ORDER BY` clause.";
            enum: ['true', 'false'];
            type: 'string';
          };
          searchable: {
            description: 'Whether the content of this field can be searched.';
            enum: ['true', 'false'];
            type: 'string';
          };
          types: {
            description: 'The data types of items in the field.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          value: {
            description: 'The field identifier.';
            type: 'string';
          };
        };
        type: 'object';
      };
      FieldUpdateOperation: {
        additionalProperties: false;
        description: 'Details of an operation to perform on a field.';
        properties: {
          add: {
            description: 'The value to add to the field.';
            example: 'triaged';
          };
          copy: {
            description: 'The field value to copy from another issue.';
            example: {
              issuelinks: {
                sourceIssues: [
                  {
                    key: 'FP-5';
                  },
                ];
              };
            };
          };
          edit: {
            description: 'The value to edit in the field.';
            example: {
              originalEstimate: '1w 1d';
              remainingEstimate: '4d';
            };
          };
          remove: {
            description: 'The value to removed from the field.';
            example: 'blocker';
          };
          set: {
            description: 'The value to set in the field.';
            example: 'A new summary';
          };
        };
        type: 'object';
      };
      FieldValueClause: {
        description: 'A clause that asserts the current value of a field. For example, `summary ~ test`.';
        properties: {
          field: {
            $ref: '#/components/schemas/JqlQueryField';
          };
          operand: {
            $ref: '#/components/schemas/JqlQueryClauseOperand';
          };
          operator: {
            description: 'The operator between the field and operand.';
            enum: ['=', '!=', '>', '<', '>=', '<=', 'in', 'not in', '~', '~=', 'is', 'is not'];
            type: 'string';
          };
        };
        required: ['field', 'operand', 'operator'];
        type: 'object';
      };
      FieldWasClause: {
        description: 'A clause that asserts a previous value of a field. For example, `status WAS "Resolved" BY currentUser() BEFORE "2019/02/02"`. See [WAS](https://confluence.atlassian.com/x/dgiiLQ#Advancedsearching-operatorsreference-WASWAS) for more information about the WAS operator.';
        properties: {
          field: {
            $ref: '#/components/schemas/JqlQueryField';
          };
          operand: {
            $ref: '#/components/schemas/JqlQueryClauseOperand';
          };
          operator: {
            description: 'The operator between the field and operand.';
            enum: ['was', 'was in', 'was not in', 'was not'];
            type: 'string';
          };
          predicates: {
            description: 'The list of time predicates.';
            items: {
              $ref: '#/components/schemas/JqlQueryClauseTimePredicate';
            };
            type: 'array';
          };
        };
        required: ['field', 'operand', 'operator', 'predicates'];
        type: 'object';
      };
      Fields: {
        additionalProperties: false;
        description: 'Key fields from the linked issue.';
        properties: {
          assignee: {
            allOf: [
              {
                $ref: '#/components/schemas/UserDetails';
              },
            ];
            description: 'The assignee of the linked issue.';
            readOnly: true;
          };
          issueType: {
            allOf: [
              {
                $ref: '#/components/schemas/IssueTypeDetails';
              },
            ];
            description: 'The type of the linked issue.';
            readOnly: true;
          };
          issuetype: {
            description: 'The type of the linked issue.';
            $ref: '#/components/schemas/IssueTypeDetails';
          };
          priority: {
            allOf: [
              {
                $ref: '#/components/schemas/Priority';
              },
            ];
            description: 'The priority of the linked issue.';
            readOnly: true;
          };
          status: {
            allOf: [
              {
                $ref: '#/components/schemas/StatusDetails';
              },
            ];
            description: 'The status of the linked issue.';
            readOnly: true;
          };
          summary: {
            description: 'The summary description of the linked issue.';
            readOnly: true;
            type: 'string';
          };
          timetracking: {
            allOf: [
              {
                $ref: '#/components/schemas/TimeTrackingDetails';
              },
            ];
            description: 'The time tracking of the linked issue.';
            readOnly: true;
          };
        };
        type: 'object';
      };
      Filter: {
        additionalProperties: false;
        description: 'Details about a filter.';
        properties: {
          approximateLastUsed: {
            description: "\\[Experimental\\] Approximate last used time. Returns the date and time when the filter was last used. Returns `null` if the filter hasn't been used after tracking was enabled. For performance reasons, timestamps aren't updated in real time and therefore may not be exactly accurate.";
            format: 'date-time';
            readOnly: true;
            type: 'string';
          };
          description: {
            description: 'A description of the filter.';
            type: 'string';
          };
          editPermissions: {
            description: 'The groups and projects that can edit the filter.';
            items: {
              $ref: '#/components/schemas/SharePermission';
            };
            type: 'array';
          };
          favourite: {
            description: 'Whether the filter is selected as a favorite.';
            type: 'boolean';
          };
          favouritedCount: {
            description: 'The count of how many users have selected this filter as a favorite, including the filter owner.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          id: {
            description: 'The unique identifier for the filter.';
            readOnly: true;
            type: 'string';
          };
          jql: {
            description: 'The JQL query for the filter. For example, *project = SSP AND issuetype = Bug*.';
            type: 'string';
          };
          name: {
            description: 'The name of the filter. Must be unique.';
            type: 'string';
          };
          owner: {
            allOf: [
              {
                $ref: '#/components/schemas/User';
              },
            ];
            description: 'The user who owns the filter. This is defaulted to the creator of the filter, however Jira administrators can change the owner of a shared filter in the admin settings.';
            readOnly: true;
          };
          searchUrl: {
            description: "A URL to view the filter results in Jira, using the [Search for issues using JQL](#api-rest-api-3-filter-search-get) operation with the filter's JQL string to return the filter results. For example, *https://your-domain.atlassian.net/rest/api/3/search?jql=project+%3D+SSP+AND+issuetype+%3D+Bug*.";
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the filter.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          sharePermissions: {
            description: 'The groups and projects that the filter is shared with.';
            items: {
              $ref: '#/components/schemas/SharePermission';
            };
            type: 'array';
          };
          sharedUsers: {
            allOf: [
              {
                $ref: '#/components/schemas/UserList';
              },
            ];
            description: 'A paginated list of the users that the filter is shared with. This includes users that are members of the groups or can browse the projects that the filter is shared with.';
            readOnly: true;
          };
          subscriptions: {
            allOf: [
              {
                $ref: '#/components/schemas/FilterSubscriptionsList';
              },
            ];
            description: 'A paginated list of the users that are subscribed to the filter.';
            readOnly: true;
          };
          viewUrl: {
            description: 'A URL to view the filter results in Jira, using the ID of the filter. For example, *https://your-domain.atlassian.net/issues/?filter=10100*.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['name'];
        type: 'object';
        xml: {
          name: 'filter';
        };
      };
      FilterDetails: {
        additionalProperties: false;
        description: 'Details of a filter.';
        properties: {
          approximateLastUsed: {
            description: "\\[Experimental\\] Approximate last used time. Returns the date and time when the filter was last used. Returns `null` if the filter hasn't been used after tracking was enabled. For performance reasons, timestamps aren't updated in real time and therefore may not be exactly accurate.";
            format: 'date-time';
            readOnly: true;
            type: 'string';
          };
          description: {
            description: 'The description of the filter.';
            type: 'string';
          };
          editPermissions: {
            description: 'The groups and projects that can edit the filter. This can be specified when updating a filter, but not when creating a filter.';
            items: {
              $ref: '#/components/schemas/SharePermission';
            };
            type: 'array';
          };
          expand: {
            description: 'Expand options that include additional filter details in the response.';
            readOnly: true;
            type: 'string';
            xml: {
              attribute: true;
            };
          };
          favourite: {
            description: 'Whether the filter is selected as a favorite by any users, not including the filter owner.';
            readOnly: true;
            type: 'boolean';
          };
          favouritedCount: {
            description: 'The count of how many users have selected this filter as a favorite, including the filter owner.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          id: {
            description: 'The unique identifier for the filter.';
            readOnly: true;
            type: 'string';
          };
          jql: {
            description: 'The JQL query for the filter. For example, *project = SSP AND issuetype = Bug*.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The name of the filter.';
            type: 'string';
          };
          owner: {
            allOf: [
              {
                $ref: '#/components/schemas/User';
              },
            ];
            description: 'The user who owns the filter. Defaults to the creator of the filter, however, Jira administrators can change the owner of a shared filter in the admin settings.';
            readOnly: true;
          };
          searchUrl: {
            description: "A URL to view the filter results in Jira, using the [Search for issues using JQL](#api-rest-api-3-filter-search-get) operation with the filter's JQL string to return the filter results. For example, *https://your-domain.atlassian.net/rest/api/3/search?jql=project+%3D+SSP+AND+issuetype+%3D+Bug*.";
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the filter.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          sharePermissions: {
            description: 'The groups and projects that the filter is shared with. This can be specified when updating a filter, but not when creating a filter.';
            items: {
              $ref: '#/components/schemas/SharePermission';
            };
            type: 'array';
          };
          subscriptions: {
            description: 'The users that are subscribed to the filter.';
            items: {
              $ref: '#/components/schemas/FilterSubscription';
            };
            readOnly: true;
            type: 'array';
          };
          viewUrl: {
            description: 'A URL to view the filter results in Jira, using the ID of the filter. For example, *https://your-domain.atlassian.net/issues/?filter=10100*.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['name'];
        type: 'object';
      };
      FilterSubscription: {
        additionalProperties: false;
        description: 'Details of a user or group subscribing to a filter.';
        properties: {
          group: {
            allOf: [
              {
                $ref: '#/components/schemas/GroupName';
              },
            ];
            description: 'The group subscribing to filter.';
            readOnly: true;
          };
          id: {
            description: 'The ID of the filter subscription.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          user: {
            allOf: [
              {
                $ref: '#/components/schemas/User';
              },
            ];
            description: 'The user subscribing to filter.';
            readOnly: true;
          };
        };
        type: 'object';
      };
      FilterSubscriptionsList: {
        additionalProperties: false;
        description: 'A paginated list of subscriptions to a filter.';
        properties: {
          'end-index': {
            description: 'The index of the last item returned on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
            xml: {
              attribute: true;
              name: 'end-index';
            };
          };
          items: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/FilterSubscription';
            };
            readOnly: true;
            type: 'array';
          };
          'max-results': {
            description: 'The maximum number of results that could be on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
            xml: {
              attribute: true;
              name: 'max-results';
            };
          };
          size: {
            description: 'The number of items on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
            xml: {
              attribute: true;
            };
          };
          'start-index': {
            description: 'The index of the first item returned on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
            xml: {
              attribute: true;
              name: 'start-index';
            };
          };
        };
        type: 'object';
      };
      FoundGroup: {
        additionalProperties: false;
        description: 'A group found in a search.';
        properties: {
          groupId: {
            description: 'The ID of the group, which uniquely identifies the group across all Atlassian products. For example, *952d12c3-5b5b-4d04-bb32-44d383afc4b2*.';
            type: 'string';
          };
          html: {
            description: 'The group name with the matched query string highlighted with the HTML bold tag.';
            type: 'string';
          };
          labels: {
            items: {
              $ref: '#/components/schemas/GroupLabel';
            };
            type: 'array';
          };
          name: {
            description: 'The name of the group. The name of a group is mutable, to reliably identify a group use ``groupId`.`';
            type: 'string';
          };
        };
        type: 'object';
        xml: {
          name: 'group';
        };
      };
      FoundGroups: {
        additionalProperties: false;
        description: 'The list of groups found in a search, including header text (Showing X of Y matching groups) and total of matched groups.';
        properties: {
          groups: {
            items: {
              $ref: '#/components/schemas/FoundGroup';
            };
            type: 'array';
          };
          header: {
            description: 'Header text indicating the number of groups in the response and the total number of groups found in the search.';
            type: 'string';
          };
          total: {
            description: 'The total number of groups found in the search.';
            format: 'int32';
            type: 'integer';
          };
        };
        type: 'object';
        xml: {
          name: 'groupsuggestions';
        };
      };
      FoundUsers: {
        additionalProperties: false;
        description: 'The list of users found in a search, including header text (Showing X of Y matching users) and total of matched users.';
        properties: {
          header: {
            description: 'Header text indicating the number of users in the response and the total number of users found in the search.';
            type: 'string';
          };
          total: {
            description: 'The total number of users found in the search.';
            format: 'int32';
            type: 'integer';
          };
          users: {
            items: {
              $ref: '#/components/schemas/UserPickerUser';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      FoundUsersAndGroups: {
        additionalProperties: false;
        description: 'List of users and groups found in a search.';
        properties: {
          groups: {
            $ref: '#/components/schemas/FoundGroups';
          };
          users: {
            $ref: '#/components/schemas/FoundUsers';
          };
        };
        type: 'object';
      };
      FunctionOperand: {
        description: 'An operand that is a function. See [Advanced searching - functions reference](https://confluence.atlassian.com/x/dwiiLQ) for more information about JQL functions.';
        properties: {
          arguments: {
            description: 'The list of function arguments.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          encodedOperand: {
            description: 'Encoded operand, which can be used directly in a JQL query.';
            type: 'string';
          };
          function: {
            description: 'The name of the function.';
            type: 'string';
          };
        };
        required: ['arguments', 'function'];
        type: 'object';
      };
      FunctionReferenceData: {
        additionalProperties: false;
        description: 'Details of functions that can be used in advanced searches.';
        properties: {
          displayName: {
            description: 'The display name of the function.';
            type: 'string';
          };
          isList: {
            description: 'Whether the function can take a list of arguments.';
            enum: ['true', 'false'];
            type: 'string';
          };
          supportsListAndSingleValueOperators: {
            description: 'Whether the function supports both single and list value operators.';
            enum: ['true', 'false'];
            type: 'string';
          };
          types: {
            description: 'The data types returned by the function.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          value: {
            description: 'The function identifier.';
            type: 'string';
          };
        };
        type: 'object';
      };
      GlobalScopeBean: {
        additionalProperties: false;
        properties: {
          attributes: {
            description: "Defines the behavior of the option in the global context.If notSelectable is set, the option cannot be set as the field's value. This is useful for archiving an option that has previously been selected but shouldn't be used anymore.If defaultValue is set, the option is selected by default.";
            items: {
              enum: ['notSelectable', 'defaultValue'];
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        type: 'object';
      };
      Group: {
        additionalProperties: false;
        properties: {
          expand: {
            description: 'Expand options that include additional group details in the response.';
            readOnly: true;
            type: 'string';
            xml: {
              attribute: true;
            };
          };
          groupId: {
            description: 'The ID of the group, which uniquely identifies the group across all Atlassian products. For example, *952d12c3-5b5b-4d04-bb32-44d383afc4b2*.';
            nullable: true;
            type: 'string';
          };
          name: {
            description: 'The name of group.';
            type: 'string';
          };
          self: {
            description: 'The URL for these group details.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          users: {
            allOf: [
              {
                $ref: '#/components/schemas/PagedListUserDetailsApplicationUser';
              },
            ];
            description: 'A paginated list of the users that are members of the group. A maximum of 50 users is returned in the list, to access additional users append `[start-index:end-index]` to the expand request. For example, to access the next 50 users, use`?expand=users[51:100]`.';
            readOnly: true;
          };
        };
        type: 'object';
      };
      GroupDetails: {
        additionalProperties: false;
        description: 'Details about a group.';
        properties: {
          groupId: {
            description: 'The ID of the group, which uniquely identifies the group across all Atlassian products. For example, *952d12c3-5b5b-4d04-bb32-44d383afc4b2*.';
            nullable: true;
            type: 'string';
          };
          name: {
            description: 'The name of the group.';
            type: 'string';
          };
        };
        type: 'object';
      };
      GroupLabel: {
        additionalProperties: false;
        description: 'A group label.';
        properties: {
          text: {
            description: 'The group label name.';
            type: 'string';
          };
          title: {
            description: 'The title of the group label.';
            type: 'string';
          };
          type: {
            description: 'The type of the group label.';
            enum: ['ADMIN', 'SINGLE', 'MULTIPLE'];
            type: 'string';
          };
        };
        type: 'object';
        xml: {
          name: 'grouplabel';
        };
      };
      GroupName: {
        additionalProperties: false;
        description: 'Details about a group.';
        properties: {
          groupId: {
            description: 'The ID of the group, which uniquely identifies the group across all Atlassian products. For example, *952d12c3-5b5b-4d04-bb32-44d383afc4b2*.';
            nullable: true;
            type: 'string';
          };
          name: {
            description: 'The name of group.';
            type: 'string';
          };
          self: {
            description: 'The URL for these group details.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      HealthCheckResult: {
        additionalProperties: false;
        description: 'Jira instance health check results. Deprecated and no longer returned.';
        properties: {
          description: {
            description: 'The description of the Jira health check item.';
            type: 'string';
          };
          name: {
            description: 'The name of the Jira health check item.';
            type: 'string';
          };
          passed: {
            description: 'Whether the Jira health check item passed or failed.';
            type: 'boolean';
          };
        };
        type: 'object';
      };
      Hierarchy: {
        additionalProperties: false;
        description: 'The project issue type hierarchy.';
        properties: {
          baseLevelId: {
            description: 'The ID of the base level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).';
            format: 'int64';
            type: 'integer';
          };
          levels: {
            description: 'Details about the hierarchy level.';
            items: {
              $ref: '#/components/schemas/SimplifiedHierarchyLevel';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
        xml: {
          name: 'hierarchy';
        };
      };
      HistoryMetadata: {
        additionalProperties: true;
        description: 'Details of issue history metadata.';
        properties: {
          activityDescription: {
            description: 'The activity described in the history record.';
            type: 'string';
          };
          activityDescriptionKey: {
            description: 'The key of the activity described in the history record.';
            type: 'string';
          };
          actor: {
            allOf: [
              {
                $ref: '#/components/schemas/HistoryMetadataParticipant';
              },
            ];
            description: 'Details of the user whose action created the history record.';
          };
          cause: {
            allOf: [
              {
                $ref: '#/components/schemas/HistoryMetadataParticipant';
              },
            ];
            description: 'Details of the cause that triggered the creation the history record.';
          };
          description: {
            description: 'The description of the history record.';
            type: 'string';
          };
          descriptionKey: {
            description: 'The description key of the history record.';
            type: 'string';
          };
          emailDescription: {
            description: 'The description of the email address associated the history record.';
            type: 'string';
          };
          emailDescriptionKey: {
            description: 'The description key of the email address associated the history record.';
            type: 'string';
          };
          extraData: {
            additionalProperties: {
              type: 'string';
            };
            description: 'Additional arbitrary information about the history record.';
            type: 'object';
          };
          generator: {
            allOf: [
              {
                $ref: '#/components/schemas/HistoryMetadataParticipant';
              },
            ];
            description: 'Details of the system that generated the history record.';
          };
          type: {
            description: 'The type of the history record.';
            type: 'string';
          };
        };
        type: 'object';
      };
      HistoryMetadataParticipant: {
        additionalProperties: true;
        description: 'Details of user or system associated with a issue history metadata item.';
        properties: {
          avatarUrl: {
            description: 'The URL to an avatar for the user or system associated with a history record.';
            type: 'string';
          };
          displayName: {
            description: 'The display name of the user or system associated with a history record.';
            type: 'string';
          };
          displayNameKey: {
            description: 'The key of the display name of the user or system associated with a history record.';
            type: 'string';
          };
          id: {
            description: 'The ID of the user or system associated with a history record.';
            type: 'string';
          };
          type: {
            description: 'The type of the user or system associated with a history record.';
            type: 'string';
          };
          url: {
            description: 'The URL of the user or system associated with a history record.';
            type: 'string';
          };
        };
        type: 'object';
      };
      Icon: {
        additionalProperties: true;
        description: 'An icon. If no icon is defined:\n\n *  for a status icon, no status icon displays in Jira.\n *  for the remote object icon, the default link icon displays in Jira.';
        properties: {
          link: {
            description: 'The URL of the tooltip, used only for a status icon. If not set, the status icon in Jira is not clickable.';
            type: 'string';
          };
          title: {
            description: 'The title of the icon. This is used as follows:\n\n *  For a status icon it is used as a tooltip on the icon. If not set, the status icon doesn\'t display a tooltip in Jira.\n *  For the remote object icon it is used in conjunction with the application name to display a tooltip for the link\'s icon. The tooltip takes the format "\\[application name\\] icon title". Blank itemsare excluded from the tooltip title. If both items are blank, the icon tooltop displays as "Web Link".';
            type: 'string';
          };
          url16x16: {
            description: 'The URL of an icon that displays at 16x16 pixel in Jira.';
            type: 'string';
          };
        };
        type: 'object';
      };
      IconBean: {
        additionalProperties: false;
        description: 'An icon.';
        properties: {
          link: {
            description: 'The URL of the tooltip, used only for a status icon.';
            type: 'string';
          };
          title: {
            description: 'The title of the icon, for use as a tooltip on the icon.';
            type: 'string';
          };
          url16x16: {
            description: 'The URL of a 16x16 pixel icon.';
            type: 'string';
          };
        };
        type: 'object';
        xml: {
          name: 'icon';
        };
      };
      IdBean: {
        additionalProperties: false;
        properties: {
          id: {
            description: 'The ID of the permission scheme to associate with the project. Use the [Get all permission schemes](#api-rest-api-3-permissionscheme-get) resource to get a list of permission scheme IDs.';
            format: 'int64';
            type: 'integer';
          };
        };
        required: ['id'];
        type: 'object';
      };
      IdOrKeyBean: {
        additionalProperties: false;
        properties: {
          id: {
            description: 'The ID of the referenced item.';
            format: 'int64';
            type: 'integer';
          };
          key: {
            description: 'The key of the referenced item.';
            type: 'string';
          };
        };
        type: 'object';
      };
      IdSearchRequestBean: {
        additionalProperties: false;
        properties: {
          jql: {
            description: 'A [JQL](https://confluence.atlassian.com/x/egORLQ) expression. Order by clauses are not allowed.';
            type: 'string';
          };
          maxResults: {
            default: 1000;
            description: 'The maximum number of items to return per page.';
            format: 'int32';
            type: 'integer';
          };
          nextPageToken: {
            description: 'The continuation token to fetch the next page. This token is provided by the response of this endpoint.';
            type: 'string';
          };
        };
        type: 'object';
      };
      IdSearchResults: {
        additionalProperties: false;
        description: 'Result of your JQL search. Returns a list of issue IDs and a token to fetch the next page if one exists.';
        properties: {
          issueIds: {
            description: 'The list of issue IDs found by the search.';
            items: {
              format: 'int64';
              readOnly: true;
              type: 'integer';
            };
            readOnly: true;
            type: 'array';
          };
          nextPageToken: {
            description: 'Continuation token to fetch the next page. If this result represents the last or the only page this token will be null.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      IncludedFields: {
        additionalProperties: false;
        properties: {
          actuallyIncluded: {
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          excluded: {
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          included: {
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        type: 'object';
      };
      InputStreamSource: {
        additionalProperties: false;
        properties: {
          inputStream: {
            type: 'object';
          };
        };
        type: 'object';
      };
      IssueArchivalSyncRequest: {
        additionalProperties: false;
        description: 'List of Issue Ids Or Keys that are to be archived or unarchived';
        properties: {
          issueIdsOrKeys: {
            items: {
              type: 'string';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      IssueArchivalSyncResponse: {
        additionalProperties: false;
        description: 'Number of archived/unarchived issues and list of errors that occurred during the action, if any.';
        properties: {
          errors: {
            $ref: '#/components/schemas/Errors';
          };
          numberOfIssuesUpdated: {
            format: 'int64';
            type: 'integer';
          };
        };
        type: 'object';
      };
      IssueBean: {
        additionalProperties: false;
        description: 'Details about an issue.';
        properties: {
          changelog: {
            allOf: [
              {
                $ref: '#/components/schemas/PageOfChangelogs';
              },
            ];
            description: 'Details of changelogs associated with the issue.';
            readOnly: true;
          };
          editmeta: {
            allOf: [
              {
                $ref: '#/components/schemas/IssueUpdateMetadata';
              },
            ];
            description: 'The metadata for the fields on the issue that can be amended.';
            readOnly: true;
          };
          expand: {
            description: 'Expand options that include additional issue details in the response.';
            readOnly: true;
            type: 'string';
            xml: {
              attribute: true;
            };
          };
          fields: {
            additionalProperties: {};
            type: 'object';
          };
          fieldsToInclude: {
            $ref: '#/components/schemas/IncludedFields';
          };
          id: {
            description: 'The ID of the issue.';
            readOnly: true;
            type: 'string';
          };
          key: {
            description: 'The key of the issue.';
            readOnly: true;
            type: 'string';
          };
          names: {
            additionalProperties: {
              readOnly: true;
              type: 'string';
            };
            description: 'The ID and name of each field present on the issue.';
            readOnly: true;
            type: 'object';
          };
          operations: {
            allOf: [
              {
                $ref: '#/components/schemas/Operations';
              },
            ];
            description: 'The operations that can be performed on the issue.';
            readOnly: true;
          };
          properties: {
            additionalProperties: {
              readOnly: true;
            };
            description: 'Details of the issue properties identified in the request.';
            readOnly: true;
            type: 'object';
          };
          renderedFields: {
            additionalProperties: {
              readOnly: true;
            };
            description: 'The rendered value of each field present on the issue.';
            readOnly: true;
            type: 'object';
          };
          schema: {
            additionalProperties: {
              $ref: '#/components/schemas/JsonTypeBean';
            };
            description: 'The schema describing each field present on the issue.';
            readOnly: true;
            type: 'object';
          };
          self: {
            description: 'The URL of the issue details.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          transitions: {
            description: 'The transitions that can be performed on the issue.';
            items: {
              $ref: '#/components/schemas/IssueTransition';
            };
            readOnly: true;
            type: 'array';
          };
          versionedRepresentations: {
            additionalProperties: {
              additionalProperties: {
                readOnly: true;
              };
              readOnly: true;
              type: 'object';
            };
            description: 'The versions of each field on the issue.';
            readOnly: true;
            type: 'object';
          };
        };
        type: 'object';
        xml: {
          name: 'issue';
        };
      };
      IssueBulkEditField: {
        additionalProperties: false;
        properties: {
          description: {
            description: 'Description of the field.';
            type: 'string';
          };
          fieldOptions: {
            description: 'A list of options related to the field, applicable in contexts where multiple selections are allowed.';
            items: {
              $ref: '#/components/schemas/IssueBulkOperationsFieldOption';
            };
            type: 'array';
          };
          id: {
            description: 'The unique ID of the field.';
            type: 'string';
          };
          isRequired: {
            description: 'Indicates whether the field is mandatory for the operation.';
            type: 'boolean';
          };
          multiSelectFieldOptions: {
            description: 'Specifies supported actions (like add, replace, remove) on multi-select fields via an enum.';
            items: {
              enum: ['ADD', 'REMOVE', 'REPLACE', 'REMOVE_ALL'];
              type: 'string';
            };
            type: 'array';
          };
          name: {
            description: 'The display name of the field.';
            type: 'string';
          };
          searchUrl: {
            description: 'A URL to fetch additional data for the field';
            type: 'string';
          };
          type: {
            description: 'The type of the field.';
            type: 'string';
          };
          unavailableMessage: {
            description: 'A message indicating why the field is unavailable for editing.';
            type: 'string';
          };
        };
        type: 'object';
      };
      IssueBulkEditPayload: {
        additionalProperties: false;
        description: 'Issue Bulk Edit Payload';
        properties: {
          editedFieldsInput: {
            allOf: [
              {
                $ref: '#/components/schemas/JiraIssueFields';
              },
            ];
            description: 'An object that defines the values to be updated in specified fields of an issue. The structure and content of this parameter vary depending on the type of field being edited. Although the order is not significant, ensure that field IDs align with those in selectedActions.';
          };
          selectedActions: {
            description: 'List of all the field IDs that are to be bulk edited. Each field ID in this list corresponds to a specific attribute of an issue that is set to be modified in the bulk edit operation. The relevant field ID can be obtained by calling the Bulk Edit Get Fields REST API (documentation available on this page itself).';
            items: {
              type: 'string';
              writeOnly: true;
            };
            type: 'array';
            writeOnly: true;
          };
          selectedIssueIdsOrKeys: {
            description: 'List of issue IDs or keys which are to be bulk edited. These IDs or keys can be from different projects and issue types.';
            items: {
              type: 'string';
              writeOnly: true;
            };
            type: 'array';
            writeOnly: true;
          };
          sendBulkNotification: {
            default: true;
            description: 'A boolean value that indicates whether to send a bulk change notification when the issues are being edited.\n\nIf `true`, dispatches a bulk notification email to users about the updates.';
            nullable: true;
            type: 'boolean';
            writeOnly: true;
          };
        };
        required: ['editedFieldsInput', 'selectedActions', 'selectedIssueIdsOrKeys'];
        type: 'object';
      };
      IssueBulkMovePayload: {
        additionalProperties: false;
        description: 'Issue Bulk Move Payload';
        properties: {
          sendBulkNotification: {
            default: true;
            description: 'A boolean value that indicates whether to send a bulk change notification when the issues are being moved.\n\nIf `true`, dispatches a bulk notification email to users about the updates.';
            nullable: true;
            type: 'boolean';
            writeOnly: true;
          };
          targetToSourcesMapping: {
            additionalProperties: {
              $ref: '#/components/schemas/targetToSourcesMapping';
            };
            description: "An object representing the mapping of issues and data related to destination entities, like fields and statuses, that are required during a bulk move.\n\nThe key is a string that is created by concatenating the following three entities in order, separated by commas. The format is `<project ID or key>,<issueType ID>,<parent ID or key>`. It should be unique across mappings provided in the payload. If you provide multiple mappings for the same key, only one will be processed. However, the operation won't fail, so the error may be hard to track down.\n\n *  ***Destination project*** (Required): ID or key of the project to which the issues are being moved.\n *  ***Destination issueType*** (Required): ID of the issueType to which the issues are being moved.\n *  ***Destination parent ID or key*** (Optional): ID or key of the issue which will become the parent of the issues being moved. Only required when the destination issueType is a subtask.";
            type: 'object';
          };
        };
        required: ['targetToMultipleSourceMapping'];
        type: 'object';
      };
      IssueBulkOperationsFieldOption: {
        additionalProperties: false;
        type: 'object';
      };
      IssueChangelogIds: {
        additionalProperties: false;
        description: 'A list of changelog IDs.';
        properties: {
          changelogIds: {
            description: 'The list of changelog IDs.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        required: ['changelogIds'];
        type: 'object';
      };
      IssueCommentListRequestBean: {
        additionalProperties: false;
        properties: {
          ids: {
            description: 'The list of comment IDs. A maximum of 1000 IDs can be specified.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        required: ['ids'];
        type: 'object';
      };
      IssueContextVariable: {
        description: 'An [issue](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#issue) specified by ID or key. All the fields of the issue object are available in the Jira expression.';
        properties: {
          id: {
            description: 'The issue ID.';
            format: 'int64';
            type: 'integer';
          };
          key: {
            description: 'The issue key.';
            type: 'string';
          };
          type: {
            description: 'Type of custom context variable.';
            type: 'string';
          };
        };
        required: ['type'];
        type: 'object';
      };
      IssueCreateMetadata: {
        additionalProperties: false;
        description: 'The wrapper for the issue creation metadata for a list of projects.';
        properties: {
          expand: {
            description: 'Expand options that include additional project details in the response.';
            readOnly: true;
            type: 'string';
            xml: {
              attribute: true;
            };
          };
          projects: {
            description: 'List of projects and their issue creation metadata.';
            items: {
              $ref: '#/components/schemas/ProjectIssueCreateMetadata';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      IssueEntityProperties: {
        additionalProperties: false;
        description: 'Lists of issues and entity properties. See [Entity properties](https://developer.atlassian.com/cloud/jira/platform/jira-entity-properties/) for more information.';
        properties: {
          entitiesIds: {
            description: 'A list of entity property IDs.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            maxItems: 10000;
            minItems: 1;
            type: 'array';
            uniqueItems: true;
          };
          properties: {
            additionalProperties: {
              $ref: '#/components/schemas/JsonNode';
            };
            description: 'A list of entity property keys and values.';
            maxProperties: 10;
            minProperties: 1;
            type: 'object';
          };
        };
        type: 'object';
      };
      IssueEntityPropertiesForMultiUpdate: {
        additionalProperties: false;
        description: 'An issue ID with entity property values. See [Entity properties](https://developer.atlassian.com/cloud/jira/platform/jira-entity-properties/) for more information.';
        maxProperties: 100;
        minProperties: 1;
        properties: {
          issueID: {
            description: 'The ID of the issue.';
            format: 'int64';
            type: 'integer';
          };
          properties: {
            additionalProperties: {
              $ref: '#/components/schemas/JsonNode';
            };
            description: 'Entity properties to set on the issue. The maximum length of an issue property value is 32768 characters.';
            maxProperties: 10;
            minProperties: 1;
            type: 'object';
          };
        };
        type: 'object';
      };
      IssueError: {
        additionalProperties: false;
        description: 'Describes the error that occurred when retrieving data for a particular issue.';
        properties: {
          errorMessage: {
            description: 'The error that occurred when fetching this issue.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the issue.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      IssueEvent: {
        additionalProperties: false;
        description: 'Details about an issue event.';
        properties: {
          id: {
            description: 'The ID of the event.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          name: {
            description: 'The name of the event.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      IssueFieldOption: {
        additionalProperties: false;
        description: 'Details of the options for a select list issue field.';
        properties: {
          config: {
            $ref: '#/components/schemas/IssueFieldOptionConfiguration';
          };
          id: {
            description: "The unique identifier for the option. This is only unique within the select field's set of options.";
            format: 'int64';
            type: 'integer';
          };
          properties: {
            additionalProperties: {};
            description: 'The properties of the object, as arbitrary key-value pairs. These properties can be searched using JQL, if the extractions (see [Issue Field Option Property Index](https://developer.atlassian.com/cloud/jira/platform/modules/issue-field-option-property-index/)) are defined in the descriptor for the issue field module.';
            type: 'object';
          };
          value: {
            description: "The option's name, which is displayed in Jira.";
            type: 'string';
          };
        };
        required: ['id', 'value'];
        type: 'object';
      };
      IssueFieldOptionConfiguration: {
        additionalProperties: false;
        description: 'Details of the projects the option is available in.';
        properties: {
          attributes: {
            description: 'DEPRECATED';
            items: {
              enum: ['notSelectable', 'defaultValue'];
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          scope: {
            allOf: [
              {
                $ref: '#/components/schemas/IssueFieldOptionScopeBean';
              },
            ];
            description: 'Defines the projects that the option is available in. If the scope is not defined, then the option is available in all projects.';
          };
        };
        type: 'object';
      };
      IssueFieldOptionCreateBean: {
        additionalProperties: true;
        properties: {
          config: {
            $ref: '#/components/schemas/IssueFieldOptionConfiguration';
          };
          properties: {
            additionalProperties: {};
            description: 'The properties of the option as arbitrary key-value pairs. These properties can be searched using JQL, if the extractions (see https://developer.atlassian.com/cloud/jira/platform/modules/issue-field-option-property-index/) are defined in the descriptor for the issue field module.';
            type: 'object';
          };
          value: {
            description: "The option's name, which is displayed in Jira.";
            type: 'string';
          };
        };
        required: ['value'];
        type: 'object';
      };
      IssueFieldOptionScopeBean: {
        additionalProperties: false;
        properties: {
          global: {
            allOf: [
              {
                $ref: '#/components/schemas/GlobalScopeBean';
              },
            ];
            description: 'Defines the behavior of the option within the global context. If this property is set, even if set to an empty object, then the option is available in all projects.';
          };
          projects: {
            description: 'DEPRECATED';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
          projects2: {
            description: 'Defines the projects in which the option is available and the behavior of the option within each project. Specify one object per project. The behavior of the option in a project context overrides the behavior in the global context.';
            items: {
              $ref: '#/components/schemas/ProjectScopeBean';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        type: 'object';
      };
      IssueFilterForBulkPropertyDelete: {
        additionalProperties: false;
        description: 'Bulk operation filter details.';
        properties: {
          currentValue: {
            description: 'The value of properties to perform the bulk operation on.';
          };
          entityIds: {
            description: 'List of issues to perform the bulk delete operation on.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        type: 'object';
      };
      IssueFilterForBulkPropertySet: {
        additionalProperties: false;
        description: 'Bulk operation filter details.';
        properties: {
          currentValue: {
            description: 'The value of properties to perform the bulk operation on.';
          };
          entityIds: {
            description: 'List of issues to perform the bulk operation on.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
          hasProperty: {
            description: 'Whether the bulk operation occurs only when the property is present on or absent from an issue.';
            type: 'boolean';
          };
        };
        type: 'object';
      };
      IssueLimitReportRequest: {
        additionalProperties: false;
        properties: {
          issuesApproachingLimitParams: {
            additionalProperties: {
              format: 'int32';
              type: 'integer';
            };
            description: 'A list of fields and their respective approaching limit threshold. Required for querying issues approaching limits. Optional for querying issues breaching limits. Accepted fields are: `comment`, `worklog`, `attachment`, `remoteIssueLinks`, and `issuelinks`. Example: `{"issuesApproachingLimitParams": {"comment": 4500, "attachment": 1800}}`';
            type: 'object';
          };
        };
        type: 'object';
      };
      IssueLimitReportResponseBean: {
        additionalProperties: false;
        properties: {
          issuesApproachingLimit: {
            additionalProperties: {
              additionalProperties: {
                format: 'int64';
                type: 'integer';
              };
              type: 'object';
            };
            description: 'A list of ids of issues approaching the limit and their field count';
            type: 'object';
          };
          issuesBreachingLimit: {
            additionalProperties: {
              additionalProperties: {
                format: 'int64';
                type: 'integer';
              };
              type: 'object';
            };
            description: 'A list of ids of issues breaching the limit and their field count';
            type: 'object';
          };
          limits: {
            additionalProperties: {
              format: 'int32';
              type: 'integer';
            };
            description: 'The fields and their defined limits';
            type: 'object';
          };
        };
        type: 'object';
      };
      IssueLink: {
        additionalProperties: false;
        description: 'Details of a link between issues.';
        properties: {
          id: {
            description: 'The ID of the issue link.';
            readOnly: true;
            type: 'string';
          };
          inwardIssue: {
            allOf: [
              {
                $ref: '#/components/schemas/LinkedIssue';
              },
            ];
            description: 'Provides details about the linked issue. If presenting this link in a user interface, use the `inward` field of the issue link type to label the link.';
          };
          outwardIssue: {
            allOf: [
              {
                $ref: '#/components/schemas/LinkedIssue';
              },
            ];
            description: 'Provides details about the linked issue. If presenting this link in a user interface, use the `outward` field of the issue link type to label the link.';
          };
          self: {
            description: 'The URL of the issue link.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          type: {
            allOf: [
              {
                $ref: '#/components/schemas/IssueLinkType';
              },
            ];
            description: 'The type of link between the issues.';
          };
        };
        required: ['inwardIssue', 'outwardIssue', 'type'];
        type: 'object';
        xml: {
          name: 'issueLinks';
        };
      };
      IssueLinkType: {
        additionalProperties: false;
        description: 'This object is used as follows:\n\n *  In the [ issueLink](#api-rest-api-3-issueLink-post) resource it defines and reports on the type of link between the issues. Find a list of issue link types with [Get issue link types](#api-rest-api-3-issueLinkType-get).\n *  In the [ issueLinkType](#api-rest-api-3-issueLinkType-post) resource it defines and reports on issue link types.';
        properties: {
          id: {
            description: "The ID of the issue link type and is used as follows:\n\n *  In the [ issueLink](#api-rest-api-3-issueLink-post) resource it is the type of issue link. Required on create when `name` isn't provided. Otherwise, read only.\n *  In the [ issueLinkType](#api-rest-api-3-issueLinkType-post) resource it is read only.";
            type: 'string';
          };
          inward: {
            description: 'The description of the issue link type inward link and is used as follows:\n\n *  In the [ issueLink](#api-rest-api-3-issueLink-post) resource it is read only.\n *  In the [ issueLinkType](#api-rest-api-3-issueLinkType-post) resource it is required on create and optional on update. Otherwise, read only.';
            type: 'string';
          };
          name: {
            description: "The name of the issue link type and is used as follows:\n\n *  In the [ issueLink](#api-rest-api-3-issueLink-post) resource it is the type of issue link. Required on create when `id` isn't provided. Otherwise, read only.\n *  In the [ issueLinkType](#api-rest-api-3-issueLinkType-post) resource it is required on create and optional on update. Otherwise, read only.";
            type: 'string';
          };
          outward: {
            description: 'The description of the issue link type outward link and is used as follows:\n\n *  In the [ issueLink](#api-rest-api-3-issueLink-post) resource it is read only.\n *  In the [ issueLinkType](#api-rest-api-3-issueLinkType-post) resource it is required on create and optional on update. Otherwise, read only.';
            type: 'string';
          };
          self: {
            description: 'The URL of the issue link type. Read only.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      IssueLinkTypes: {
        additionalProperties: false;
        description: 'A list of issue link type beans.';
        properties: {
          issueLinkTypes: {
            description: 'The issue link type bean.';
            items: {
              $ref: '#/components/schemas/IssueLinkType';
            };
            readOnly: true;
            type: 'array';
            xml: {
              name: 'issueLinkTypes';
            };
          };
        };
        type: 'object';
        xml: {
          name: 'issueLinkTypes';
        };
      };
      IssueList: {
        additionalProperties: false;
        description: 'A list of issue IDs.';
        properties: {
          issueIds: {
            description: 'The list of issue IDs.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
        };
        required: ['issueIds'];
        type: 'object';
      };
      IssueMatches: {
        additionalProperties: false;
        description: 'A list of matched issues or errors for each JQL query, in the order the JQL queries were passed.';
        properties: {
          matches: {
            items: {
              $ref: '#/components/schemas/IssueMatchesForJQL';
            };
            type: 'array';
          };
        };
        required: ['matches'];
        type: 'object';
      };
      IssueMatchesForJQL: {
        additionalProperties: false;
        description: 'A list of the issues matched to a JQL query or details of errors encountered during matching.';
        properties: {
          errors: {
            description: 'A list of errors.';
            items: {
              description: 'A list of errors.';
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          matchedIssues: {
            description: 'A list of issue IDs.';
            items: {
              description: 'A list of issue IDs.';
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        required: ['errors', 'matchedIssues'];
        type: 'object';
      };
      IssuePickerSuggestions: {
        additionalProperties: false;
        description: 'A list of issues suggested for use in auto-completion.';
        properties: {
          sections: {
            description: 'A list of issues for an issue type suggested for use in auto-completion.';
            items: {
              $ref: '#/components/schemas/IssuePickerSuggestionsIssueType';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      IssuePickerSuggestionsIssueType: {
        additionalProperties: false;
        description: 'A type of issue suggested for use in auto-completion.';
        properties: {
          id: {
            description: 'The ID of the type of issues suggested for use in auto-completion.';
            readOnly: true;
            type: 'string';
          };
          issues: {
            description: 'A list of issues suggested for use in auto-completion.';
            items: {
              $ref: '#/components/schemas/SuggestedIssue';
            };
            readOnly: true;
            type: 'array';
          };
          label: {
            description: 'The label of the type of issues suggested for use in auto-completion.';
            readOnly: true;
            type: 'string';
          };
          msg: {
            description: 'If no issue suggestions are found, returns a message indicating no suggestions were found,';
            readOnly: true;
            type: 'string';
          };
          sub: {
            description: 'If issue suggestions are found, returns a message indicating the number of issues suggestions found and returned.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      IssueSecurityLevelMember: {
        additionalProperties: false;
        description: 'Issue security level member.';
        properties: {
          holder: {
            allOf: [
              {
                $ref: '#/components/schemas/PermissionHolder';
              },
            ];
            description: 'The user or group being granted the permission. It consists of a `type` and a type-dependent `parameter`. See [Holder object](../api-group-permission-schemes/#holder-object) in *Get all permission schemes* for more information.';
          };
          id: {
            description: 'The ID of the issue security level member.';
            format: 'int64';
            type: 'integer';
          };
          issueSecurityLevelId: {
            description: 'The ID of the issue security level.';
            format: 'int64';
            type: 'integer';
          };
          managed: {
            type: 'boolean';
            writeOnly: true;
          };
        };
        required: ['holder', 'id', 'issueSecurityLevelId'];
        type: 'object';
      };
      IssueSecuritySchemeToProjectMapping: {
        additionalProperties: true;
        description: 'Details about an project using security scheme mapping.';
        properties: {
          issueSecuritySchemeId: {
            readOnly: true;
            type: 'string';
          };
          projectId: {
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      IssueTransition: {
        additionalProperties: true;
        description: 'Details of an issue transition.';
        properties: {
          expand: {
            description: 'Expand options that include additional transition details in the response.';
            readOnly: true;
            type: 'string';
          };
          fields: {
            additionalProperties: {
              $ref: '#/components/schemas/FieldMetadata';
            };
            description: 'Details of the fields associated with the issue transition screen. Use this information to populate `fields` and `update` in a transition request.';
            readOnly: true;
            type: 'object';
          };
          hasScreen: {
            description: 'Whether there is a screen associated with the issue transition.';
            readOnly: true;
            type: 'boolean';
          };
          id: {
            description: 'The ID of the issue transition. Required when specifying a transition to undertake.';
            type: 'string';
          };
          isAvailable: {
            description: 'Whether the transition is available to be performed.';
            readOnly: true;
            type: 'boolean';
          };
          isConditional: {
            description: 'Whether the issue has to meet criteria before the issue transition is applied.';
            readOnly: true;
            type: 'boolean';
          };
          isGlobal: {
            description: 'Whether the issue transition is global, that is, the transition is applied to issues regardless of their status.';
            readOnly: true;
            type: 'boolean';
          };
          isInitial: {
            description: 'Whether this is the initial issue transition for the workflow.';
            readOnly: true;
            type: 'boolean';
          };
          looped: {
            type: 'boolean';
          };
          name: {
            description: 'The name of the issue transition.';
            readOnly: true;
            type: 'string';
          };
          to: {
            allOf: [
              {
                $ref: '#/components/schemas/StatusDetails';
              },
            ];
            description: 'Details of the issue status after the transition.';
            readOnly: true;
          };
        };
        type: 'object';
      };
      IssueTypeCreateBean: {
        additionalProperties: false;
        properties: {
          description: {
            description: 'The description of the issue type.';
            type: 'string';
          };
          hierarchyLevel: {
            description: 'The hierarchy level of the issue type. Use:\n\n *  `-1` for Subtask.\n *  `0` for Base.\n\nDefaults to `0`.';
            format: 'int32';
            type: 'integer';
          };
          name: {
            description: 'The unique name for the issue type. The maximum length is 60 characters.';
            type: 'string';
          };
          type: {
            description: 'Deprecated. Use `hierarchyLevel` instead. See the [deprecation notice](https://community.developer.atlassian.com/t/deprecation-of-the-epic-link-parent-link-and-other-related-fields-in-rest-apis-and-webhooks/54048) for details.\n\nWhether the issue type is `subtype` or `standard`. Defaults to `standard`.';
            enum: ['subtask', 'standard'];
            type: 'string';
          };
        };
        required: ['name'];
        type: 'object';
      };
      IssueTypeDetails: {
        additionalProperties: false;
        description: 'Details about an issue type.';
        properties: {
          avatarId: {
            description: "The ID of the issue type's avatar.";
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          description: {
            description: 'The description of the issue type.';
            readOnly: true;
            type: 'string';
          };
          entityId: {
            description: 'Unique ID for next-gen projects.';
            format: 'uuid';
            readOnly: true;
            type: 'string';
          };
          hierarchyLevel: {
            description: 'Hierarchy level of the issue type.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          iconUrl: {
            description: "The URL of the issue type's avatar.";
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the issue type.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The name of the issue type.';
            readOnly: true;
            type: 'string';
          };
          scope: {
            allOf: [
              {
                $ref: '#/components/schemas/Scope';
              },
            ];
            description: 'Details of the next-gen projects the issue type is available in.';
            readOnly: true;
          };
          self: {
            description: 'The URL of these issue type details.';
            readOnly: true;
            type: 'string';
          };
          subtask: {
            description: 'Whether this issue type is used to create subtasks.';
            readOnly: true;
            type: 'boolean';
          };
        };
        type: 'object';
      };
      IssueTypeIds: {
        additionalProperties: false;
        description: 'The list of issue type IDs.';
        properties: {
          issueTypeIds: {
            description: 'The list of issue type IDs.';
            items: {
              type: 'string';
              writeOnly: true;
            };
            type: 'array';
            writeOnly: true;
          };
        };
        required: ['issueTypeIds'];
        type: 'object';
      };
      IssueTypeIdsToRemove: {
        additionalProperties: false;
        description: 'The list of issue type IDs to be removed from the field configuration scheme.';
        properties: {
          issueTypeIds: {
            description: 'The list of issue type IDs. Must contain unique values not longer than 255 characters and not be empty. Maximum of 100 IDs.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
        };
        required: ['issueTypeIds'];
        type: 'object';
      };
      IssueTypeInfo: {
        additionalProperties: false;
        description: 'Details of an issue type.';
        properties: {
          avatarId: {
            description: 'The avatar of the issue type.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          id: {
            description: 'The ID of the issue type.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          name: {
            description: 'The name of the issue type.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      IssueTypeIssueCreateMetadata: {
        additionalProperties: false;
        description: 'Details of the issue creation metadata for an issue type.';
        properties: {
          avatarId: {
            description: "The ID of the issue type's avatar.";
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          description: {
            description: 'The description of the issue type.';
            readOnly: true;
            type: 'string';
          };
          entityId: {
            description: 'Unique ID for next-gen projects.';
            format: 'uuid';
            readOnly: true;
            type: 'string';
          };
          expand: {
            description: 'Expand options that include additional issue type metadata details in the response.';
            readOnly: true;
            type: 'string';
            xml: {
              attribute: true;
            };
          };
          fields: {
            additionalProperties: {
              $ref: '#/components/schemas/FieldMetadata';
            };
            description: 'List of the fields available when creating an issue for the issue type.';
            readOnly: true;
            type: 'object';
          };
          hierarchyLevel: {
            description: 'Hierarchy level of the issue type.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          iconUrl: {
            description: "The URL of the issue type's avatar.";
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the issue type.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The name of the issue type.';
            readOnly: true;
            type: 'string';
          };
          scope: {
            allOf: [
              {
                $ref: '#/components/schemas/Scope';
              },
            ];
            description: 'Details of the next-gen projects the issue type is available in.';
            readOnly: true;
          };
          self: {
            description: 'The URL of these issue type details.';
            readOnly: true;
            type: 'string';
          };
          subtask: {
            description: 'Whether this issue type is used to create subtasks.';
            readOnly: true;
            type: 'boolean';
          };
        };
        type: 'object';
      };
      IssueTypeScheme: {
        additionalProperties: false;
        description: 'Details of an issue type scheme.';
        properties: {
          defaultIssueTypeId: {
            description: 'The ID of the default issue type of the issue type scheme.';
            type: 'string';
          };
          description: {
            description: 'The description of the issue type scheme.';
            type: 'string';
          };
          id: {
            description: 'The ID of the issue type scheme.';
            type: 'string';
          };
          isDefault: {
            description: 'Whether the issue type scheme is the default.';
            type: 'boolean';
          };
          name: {
            description: 'The name of the issue type scheme.';
            type: 'string';
          };
        };
        required: ['id', 'name'];
        type: 'object';
      };
      IssueTypeSchemeDetails: {
        additionalProperties: false;
        description: 'Details of an issue type scheme and its associated issue types.';
        properties: {
          defaultIssueTypeId: {
            description: 'The ID of the default issue type of the issue type scheme. This ID must be included in `issueTypeIds`.';
            type: 'string';
            writeOnly: true;
          };
          description: {
            description: 'The description of the issue type scheme. The maximum length is 4000 characters.';
            type: 'string';
            writeOnly: true;
          };
          issueTypeIds: {
            description: 'The list of issue types IDs of the issue type scheme. At least one standard issue type ID is required.';
            items: {
              type: 'string';
              writeOnly: true;
            };
            type: 'array';
            writeOnly: true;
          };
          name: {
            description: 'The name of the issue type scheme. The name must be unique. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['issueTypeIds', 'name'];
        type: 'object';
      };
      IssueTypeSchemeID: {
        additionalProperties: false;
        description: 'The ID of an issue type scheme.';
        properties: {
          issueTypeSchemeId: {
            description: 'The ID of the issue type scheme.';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['issueTypeSchemeId'];
        type: 'object';
      };
      IssueTypeSchemeMapping: {
        additionalProperties: false;
        description: 'Issue type scheme item.';
        properties: {
          issueTypeId: {
            description: 'The ID of the issue type.';
            type: 'string';
          };
          issueTypeSchemeId: {
            description: 'The ID of the issue type scheme.';
            type: 'string';
          };
        };
        required: ['issueTypeId', 'issueTypeSchemeId'];
        type: 'object';
      };
      IssueTypeSchemeProjectAssociation: {
        additionalProperties: false;
        description: 'Details of the association between an issue type scheme and project.';
        properties: {
          issueTypeSchemeId: {
            description: 'The ID of the issue type scheme.';
            type: 'string';
            writeOnly: true;
          };
          projectId: {
            description: 'The ID of the project.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['issueTypeSchemeId', 'projectId'];
        type: 'object';
      };
      IssueTypeSchemeProjects: {
        additionalProperties: false;
        description: 'Issue type scheme with a list of the projects that use it.';
        properties: {
          issueTypeScheme: {
            allOf: [
              {
                $ref: '#/components/schemas/IssueTypeScheme';
              },
            ];
            description: 'Details of an issue type scheme.';
          };
          projectIds: {
            description: 'The IDs of the projects using the issue type scheme.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
        };
        required: ['issueTypeScheme', 'projectIds'];
        type: 'object';
      };
      IssueTypeSchemeUpdateDetails: {
        additionalProperties: false;
        description: 'Details of the name, description, and default issue type for an issue type scheme.';
        properties: {
          defaultIssueTypeId: {
            description: 'The ID of the default issue type of the issue type scheme.';
            type: 'string';
            writeOnly: true;
          };
          description: {
            description: 'The description of the issue type scheme. The maximum length is 4000 characters.';
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the issue type scheme. The name must be unique. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
        };
        type: 'object';
      };
      IssueTypeScreenScheme: {
        additionalProperties: false;
        description: 'Details of an issue type screen scheme.';
        properties: {
          description: {
            description: 'The description of the issue type screen scheme.';
            type: 'string';
          };
          id: {
            description: 'The ID of the issue type screen scheme.';
            type: 'string';
          };
          name: {
            description: 'The name of the issue type screen scheme.';
            type: 'string';
          };
        };
        required: ['id', 'name'];
        type: 'object';
      };
      IssueTypeScreenSchemeDetails: {
        additionalProperties: false;
        description: 'The details of an issue type screen scheme.';
        properties: {
          description: {
            description: 'The description of the issue type screen scheme. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
          issueTypeMappings: {
            description: 'The IDs of the screen schemes for the issue type IDs and *default*. A *default* entry is required to create an issue type screen scheme, it defines the mapping for all issue types without a screen scheme.';
            items: {
              $ref: '#/components/schemas/IssueTypeScreenSchemeMapping';
            };
            type: 'array';
            writeOnly: true;
          };
          name: {
            description: 'The name of the issue type screen scheme. The name must be unique. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['issueTypeMappings', 'name'];
        type: 'object';
      };
      IssueTypeScreenSchemeId: {
        additionalProperties: false;
        description: 'The ID of an issue type screen scheme.';
        properties: {
          id: {
            description: 'The ID of the issue type screen scheme.';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['id'];
        type: 'object';
      };
      IssueTypeScreenSchemeItem: {
        additionalProperties: false;
        description: 'The screen scheme for an issue type.';
        properties: {
          issueTypeId: {
            description: "The ID of the issue type or *default*. Only issue types used in classic projects are accepted. When creating an issue screen scheme, an entry for *default* must be provided and defines the mapping for all issue types without a screen scheme. Otherwise, a *default* entry can't be provided.";
            type: 'string';
          };
          issueTypeScreenSchemeId: {
            description: 'The ID of the issue type screen scheme.';
            type: 'string';
          };
          screenSchemeId: {
            description: 'The ID of the screen scheme.';
            type: 'string';
          };
        };
        required: ['issueTypeId', 'issueTypeScreenSchemeId', 'screenSchemeId'];
        type: 'object';
      };
      IssueTypeScreenSchemeMapping: {
        additionalProperties: false;
        description: 'The IDs of the screen schemes for the issue type IDs.';
        properties: {
          issueTypeId: {
            description: 'The ID of the issue type or *default*. Only issue types used in classic projects are accepted. An entry for *default* must be provided and defines the mapping for all issue types without a screen scheme.';
            type: 'string';
            writeOnly: true;
          };
          screenSchemeId: {
            description: 'The ID of the screen scheme. Only screen schemes used in classic projects are accepted.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['issueTypeId', 'screenSchemeId'];
        type: 'object';
        writeOnly: true;
      };
      IssueTypeScreenSchemeMappingDetails: {
        additionalProperties: false;
        description: 'A list of issue type screen scheme mappings.';
        properties: {
          issueTypeMappings: {
            description: 'The list of issue type to screen scheme mappings. A *default* entry cannot be specified because a default entry is added when an issue type screen scheme is created.';
            items: {
              $ref: '#/components/schemas/IssueTypeScreenSchemeMapping';
            };
            type: 'array';
            writeOnly: true;
          };
        };
        required: ['issueTypeMappings'];
        type: 'object';
      };
      IssueTypeScreenSchemeProjectAssociation: {
        additionalProperties: false;
        description: 'Associated issue type screen scheme and project.';
        properties: {
          issueTypeScreenSchemeId: {
            description: 'The ID of the issue type screen scheme.';
            type: 'string';
            writeOnly: true;
          };
          projectId: {
            description: 'The ID of the project.';
            type: 'string';
            writeOnly: true;
          };
        };
        type: 'object';
      };
      IssueTypeScreenSchemeUpdateDetails: {
        additionalProperties: false;
        description: 'Details of an issue type screen scheme.';
        properties: {
          description: {
            description: 'The description of the issue type screen scheme. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the issue type screen scheme. The name must be unique. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
        };
        type: 'object';
      };
      IssueTypeScreenSchemesProjects: {
        additionalProperties: false;
        description: 'Issue type screen scheme with a list of the projects that use it.';
        properties: {
          issueTypeScreenScheme: {
            allOf: [
              {
                $ref: '#/components/schemas/IssueTypeScreenScheme';
              },
            ];
            description: 'Details of an issue type screen scheme.';
          };
          projectIds: {
            description: 'The IDs of the projects using the issue type screen scheme.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
        };
        required: ['issueTypeScreenScheme', 'projectIds'];
        type: 'object';
      };
      IssueTypeToContextMapping: {
        additionalProperties: false;
        description: 'Mapping of an issue type to a context.';
        properties: {
          contextId: {
            description: 'The ID of the context.';
            type: 'string';
          };
          isAnyIssueType: {
            description: 'Whether the context is mapped to any issue type.';
            type: 'boolean';
          };
          issueTypeId: {
            description: 'The ID of the issue type.';
            type: 'string';
          };
        };
        required: ['contextId'];
        type: 'object';
      };
      IssueTypeUpdateBean: {
        additionalProperties: false;
        properties: {
          avatarId: {
            description: 'The ID of an issue type avatar.';
            format: 'int64';
            type: 'integer';
          };
          description: {
            description: 'The description of the issue type.';
            type: 'string';
          };
          name: {
            description: 'The unique name for the issue type. The maximum length is 60 characters.';
            type: 'string';
          };
        };
        type: 'object';
      };
      IssueTypeWithStatus: {
        additionalProperties: false;
        description: 'Status details for an issue type.';
        properties: {
          id: {
            description: 'The ID of the issue type.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The name of the issue type.';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: "The URL of the issue type's status details.";
            readOnly: true;
            type: 'string';
          };
          statuses: {
            description: 'List of status details for the issue type.';
            items: {
              $ref: '#/components/schemas/StatusDetails';
            };
            readOnly: true;
            type: 'array';
          };
          subtask: {
            description: 'Whether this issue type represents subtasks.';
            readOnly: true;
            type: 'boolean';
          };
        };
        required: ['id', 'name', 'self', 'statuses', 'subtask'];
        type: 'object';
      };
      IssueTypeWorkflowMapping: {
        additionalProperties: false;
        description: 'Details about the mapping between an issue type and a workflow.';
        properties: {
          issueType: {
            description: 'The ID of the issue type. Not required if updating the issue type-workflow mapping.';
            type: 'string';
          };
          updateDraftIfNeeded: {
            description: 'Set to true to create or update the draft of a workflow scheme and update the mapping in the draft, when the workflow scheme cannot be edited. Defaults to `false`. Only applicable when updating the workflow-issue types mapping.';
            type: 'boolean';
          };
          workflow: {
            description: 'The name of the workflow.';
            type: 'string';
          };
        };
        type: 'object';
      };
      IssueTypesWorkflowMapping: {
        additionalProperties: false;
        description: 'Details about the mapping between issue types and a workflow.';
        properties: {
          defaultMapping: {
            description: 'Whether the workflow is the default workflow for the workflow scheme.';
            type: 'boolean';
          };
          issueTypes: {
            description: 'The list of issue type IDs.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          updateDraftIfNeeded: {
            description: 'Whether a draft workflow scheme is created or updated when updating an active workflow scheme. The draft is updated with the new workflow-issue types mapping. Defaults to `false`.';
            type: 'boolean';
          };
          workflow: {
            description: 'The name of the workflow. Optional if updating the workflow-issue types mapping.';
            type: 'string';
          };
        };
        type: 'object';
      };
      IssueUpdateDetails: {
        additionalProperties: true;
        description: 'Details of an issue update request.';
        properties: {
          fields: {
            additionalProperties: {};
            description: 'List of issue screen fields to update, specifying the sub-field to update and its value for each field. This field provides a straightforward option when setting a sub-field. When multiple sub-fields or other operations are required, use `update`. Fields included in here cannot be included in `update`.';
            type: 'object';
          };
          historyMetadata: {
            allOf: [
              {
                $ref: '#/components/schemas/HistoryMetadata';
              },
            ];
            description: 'Additional issue history details.';
          };
          properties: {
            description: 'Details of issue properties to be add or update.';
            items: {
              $ref: '#/components/schemas/EntityProperty';
            };
            type: 'array';
          };
          transition: {
            allOf: [
              {
                $ref: '#/components/schemas/IssueTransition';
              },
            ];
            description: 'Details of a transition. Required when performing a transition, optional when creating or editing an issue.';
          };
          update: {
            additionalProperties: {
              items: {
                $ref: '#/components/schemas/FieldUpdateOperation';
              };
              type: 'array';
            };
            description: 'A Map containing the field field name and a list of operations to perform on the issue screen field. Note that fields included in here cannot be included in `fields`.';
            type: 'object';
          };
        };
        type: 'object';
      };
      IssueUpdateMetadata: {
        description: 'A list of editable field details.';
        properties: {
          fields: {
            additionalProperties: {
              $ref: '#/components/schemas/FieldMetadata';
            };
            readOnly: true;
            type: 'object';
          };
        };
        type: 'object';
      };
      IssuesAndJQLQueries: {
        additionalProperties: false;
        description: 'List of issues and JQL queries.';
        properties: {
          issueIds: {
            description: 'A list of issue IDs.';
            items: {
              description: 'A list of issue IDs.';
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
          jqls: {
            description: 'A list of JQL queries.';
            items: {
              description: 'A list of JQL queries.';
              type: 'string';
            };
            type: 'array';
          };
        };
        required: ['issueIds', 'jqls'];
        type: 'object';
      };
      IssuesJqlMetaDataBean: {
        additionalProperties: false;
        description: 'The description of the page of issues loaded by the provided JQL query.';
        properties: {
          count: {
            description: 'The number of issues that were loaded in this evaluation.';
            format: 'int32';
            type: 'integer';
          };
          maxResults: {
            description: 'The maximum number of issues that could be loaded in this evaluation.';
            format: 'int32';
            type: 'integer';
          };
          startAt: {
            description: 'The index of the first issue.';
            format: 'int64';
            type: 'integer';
          };
          totalCount: {
            description: 'The total number of issues the JQL returned.';
            format: 'int64';
            type: 'integer';
          };
          validationWarnings: {
            description: 'Any warnings related to the JQL query. Present only if the validation mode was set to `warn`.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
        };
        required: ['count', 'maxResults', 'startAt', 'totalCount'];
        type: 'object';
      };
      IssuesMetaBean: {
        additionalProperties: false;
        description: 'Meta data describing the `issues` context variable.';
        properties: {
          jql: {
            $ref: '#/components/schemas/IssuesJqlMetaDataBean';
          };
        };
        type: 'object';
      };
      IssuesUpdateBean: {
        additionalProperties: true;
        properties: {
          issueUpdates: {
            items: {
              $ref: '#/components/schemas/IssueUpdateDetails';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      JExpEvaluateIssuesJqlMetaDataBean: {
        additionalProperties: false;
        description: 'The description of the page of issues loaded by the provided JQL query.This bean will be replacing IssuesJqlMetaDataBean bean as part of new `evaluate` endpoint';
        properties: {
          nextPageToken: {
            description: 'Next Page token for the next page of issues.';
            type: 'string';
          };
        };
        required: ['nextPageToken'];
        type: 'object';
      };
      JExpEvaluateIssuesMetaBean: {
        additionalProperties: false;
        description: 'Meta data describing the `issues` context variable.This bean will be replacing IssuesMetaBean bean as part of new `evaluate` endpoint';
        properties: {
          jql: {
            $ref: '#/components/schemas/JExpEvaluateIssuesJqlMetaDataBean';
          };
        };
        type: 'object';
      };
      JExpEvaluateJiraExpressionResultBean: {
        additionalProperties: false;
        description: 'The result of evaluating a Jira expression.This bean will be replacing `JiraExpressionResultBean` bean as part of new evaluate endpoint';
        properties: {
          meta: {
            allOf: [
              {
                $ref: '#/components/schemas/JExpEvaluateMetaDataBean';
              },
            ];
            description: 'Contains various characteristics of the performed expression evaluation.';
          };
          value: {
            description: "The value of the evaluated expression. It may be a primitive JSON value or a Jira REST API object. (Some expressions do not produce any meaningful results—for example, an expression that returns a lambda function—if that's the case a simple string representation is returned. These string representations should not be relied upon and may change without notice.)";
          };
        };
        required: ['value'];
        type: 'object';
      };
      JExpEvaluateMetaDataBean: {
        additionalProperties: false;
        description: 'Contains information about the expression evaluation. This bean will be replacing `JiraExpressionEvaluationMetaDataBean` bean as part of new `evaluate` endpoint';
        properties: {
          complexity: {
            allOf: [
              {
                $ref: '#/components/schemas/JiraExpressionsComplexityBean';
              },
            ];
            description: 'Contains information about the expression complexity. For example, the number of steps it took to evaluate the expression.';
          };
          issues: {
            allOf: [
              {
                $ref: '#/components/schemas/JExpEvaluateIssuesMetaBean';
              },
            ];
            description: 'Contains information about the `issues` variable in the context. For example, is the issues were loaded with JQL, information about the page will be included here.';
          };
        };
        type: 'object';
      };
      JQLCountRequestBean: {
        additionalProperties: false;
        properties: {
          jql: {
            description: 'A [JQL](https://confluence.atlassian.com/x/egORLQ) expression. For performance reasons, this field requires a bounded query. A bounded query is a query with a search restriction.';
            type: 'string';
          };
        };
        type: 'object';
      };
      JQLCountResultsBean: {
        additionalProperties: false;
        properties: {
          count: {
            description: 'Number of issues matching JQL query.';
            format: 'int64';
            type: 'integer';
          };
        };
        type: 'object';
      };
      JQLPersonalDataMigrationRequest: {
        additionalProperties: false;
        description: 'The JQL queries to be converted.';
        properties: {
          queryStrings: {
            description: 'A list of queries with user identifiers. Maximum of 100 queries.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      JQLQueryWithUnknownUsers: {
        additionalProperties: false;
        description: 'JQL queries that contained users that could not be found';
        properties: {
          convertedQuery: {
            description: "The converted query, with accountIDs instead of user identifiers, or 'unknown' for users that could not be found";
            type: 'string';
          };
          originalQuery: {
            description: 'The original query, for reference';
            type: 'string';
          };
        };
        type: 'object';
      };
      JQLReferenceData: {
        additionalProperties: false;
        description: 'Lists of JQL reference data.';
        properties: {
          jqlReservedWords: {
            description: 'List of JQL query reserved words.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          visibleFieldNames: {
            description: 'List of fields usable in JQL queries.';
            items: {
              $ref: '#/components/schemas/FieldReferenceData';
            };
            type: 'array';
          };
          visibleFunctionNames: {
            description: 'List of functions usable in JQL queries.';
            items: {
              $ref: '#/components/schemas/FunctionReferenceData';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      JexpEvaluateCtxIssues: {
        additionalProperties: false;
        description: 'The JQL specifying the issues available in the evaluated Jira expression under the `issues` context variable. This bean will be replacing `JexpIssues` bean as part of new `evaluate` endpoint';
        properties: {
          jql: {
            allOf: [
              {
                $ref: '#/components/schemas/JexpEvaluateCtxJqlIssues';
              },
            ];
            description: 'The JQL query that specifies the set of issues available in the Jira expression.';
          };
        };
        type: 'object';
      };
      JexpEvaluateCtxJqlIssues: {
        additionalProperties: false;
        description: 'The JQL specifying the issues available in the evaluated Jira expression under the `issues` context variable. Not all issues returned by the JQL query are loaded, only those described by the `nextPageToken` and `maxResults` properties. This bean will be replacing JexpJqlIssues bean as part of new `evaluate` endpoint';
        properties: {
          maxResults: {
            description: 'The maximum number of issues to return from the JQL query. max results value considered may be lower than the number specific here.';
            format: 'int32';
            type: 'integer';
          };
          nextPageToken: {
            description: 'The token for a page to fetch that is not the first page. The first page has a `nextPageToken` of `null`. Use the `nextPageToken` to fetch the next page of issues.';
            type: 'string';
          };
          query: {
            description: 'The JQL query, required to be bounded.';
            type: 'string';
          };
        };
        type: 'object';
      };
      JexpIssues: {
        additionalProperties: false;
        description: 'The JQL specifying the issues available in the evaluated Jira expression under the `issues` context variable.';
        properties: {
          jql: {
            allOf: [
              {
                $ref: '#/components/schemas/JexpJqlIssues';
              },
            ];
            description: 'The JQL query that specifies the set of issues available in the Jira expression.';
          };
        };
        type: 'object';
      };
      JexpJqlIssues: {
        additionalProperties: false;
        description: 'The JQL specifying the issues available in the evaluated Jira expression under the `issues` context variable. Not all issues returned by the JQL query are loaded, only those described by the `startAt` and `maxResults` properties. To determine whether it is necessary to iterate to ensure all the issues returned by the JQL query are evaluated, inspect `meta.issues.jql.count` in the response.';
        properties: {
          maxResults: {
            description: 'The maximum number of issues to return from the JQL query. Inspect `meta.issues.jql.maxResults` in the response to ensure the maximum value has not been exceeded.';
            format: 'int32';
            type: 'integer';
          };
          query: {
            description: 'The JQL query.';
            type: 'string';
          };
          startAt: {
            description: 'The index of the first issue to return from the JQL query.';
            format: 'int64';
            type: 'integer';
          };
          validation: {
            default: 'strict';
            description: 'Determines how to validate the JQL query and treat the validation results.';
            enum: ['strict', 'warn', 'none'];
            type: 'string';
          };
        };
        type: 'object';
      };
      JiraCascadingSelectField: {
        additionalProperties: false;
        properties: {
          childOptionValue: {
            $ref: '#/components/schemas/JiraSelectedOptionField';
          };
          fieldId: {
            type: 'string';
          };
          parentOptionValue: {
            $ref: '#/components/schemas/JiraSelectedOptionField';
          };
        };
        required: ['fieldId', 'parentOptionValue'];
        type: 'object';
      };
      JiraColorField: {
        additionalProperties: false;
        properties: {
          color: {
            $ref: '#/components/schemas/JiraColorInput';
          };
          fieldId: {
            type: 'string';
          };
        };
        required: ['color', 'fieldId'];
        type: 'object';
      };
      JiraColorInput: {
        additionalProperties: false;
        properties: {
          name: {
            type: 'string';
          };
        };
        required: ['name'];
        type: 'object';
      };
      JiraComponentField: {
        additionalProperties: false;
        properties: {
          componentId: {
            format: 'int64';
            type: 'integer';
          };
        };
        required: ['componentId'];
        type: 'object';
      };
      JiraDateField: {
        additionalProperties: false;
        properties: {
          date: {
            $ref: '#/components/schemas/JiraDateInput';
          };
          fieldId: {
            type: 'string';
          };
        };
        required: ['fieldId'];
        type: 'object';
      };
      JiraDateInput: {
        additionalProperties: false;
        properties: {
          formattedDate: {
            type: 'string';
          };
        };
        required: ['formattedDate'];
        type: 'object';
      };
      JiraDateTimeField: {
        additionalProperties: false;
        properties: {
          dateTime: {
            $ref: '#/components/schemas/JiraDateTimeInput';
          };
          fieldId: {
            type: 'string';
          };
        };
        required: ['dateTime', 'fieldId'];
        type: 'object';
      };
      JiraDateTimeInput: {
        additionalProperties: false;
        properties: {
          formattedDateTime: {
            type: 'string';
          };
        };
        required: ['formattedDateTime'];
        type: 'object';
      };
      JiraDurationField: {
        additionalProperties: false;
        properties: {
          originalEstimateField: {
            type: 'string';
          };
        };
        required: ['originalEstimateField'];
        type: 'object';
      };
      JiraExpressionAnalysis: {
        additionalProperties: false;
        description: 'Details about the analysed Jira expression.';
        properties: {
          complexity: {
            $ref: '#/components/schemas/JiraExpressionComplexity';
          };
          errors: {
            description: 'A list of validation errors. Not included if the expression is valid.';
            items: {
              $ref: '#/components/schemas/JiraExpressionValidationError';
            };
            type: 'array';
          };
          expression: {
            description: 'The analysed expression.';
            type: 'string';
          };
          type: {
            description: 'EXPERIMENTAL. The inferred type of the expression.';
            type: 'string';
          };
          valid: {
            description: 'Whether the expression is valid and the interpreter will evaluate it. Note that the expression may fail at runtime (for example, if it executes too many expensive operations).';
            type: 'boolean';
          };
        };
        required: ['expression', 'valid'];
        type: 'object';
      };
      JiraExpressionComplexity: {
        additionalProperties: false;
        description: 'Details about the complexity of the analysed Jira expression.';
        properties: {
          expensiveOperations: {
            description: 'Information that can be used to determine how many [expensive operations](https://developer.atlassian.com/cloud/jira/platform/jira-expressions/#expensive-operations) the evaluation of the expression will perform. This information may be a formula or number. For example:\n\n *  `issues.map(i => i.comments)` performs as many expensive operations as there are issues on the issues list. So this parameter returns `N`, where `N` is the size of issue list.\n *  `new Issue(10010).comments` gets comments for one issue, so its complexity is `2` (`1` to retrieve issue 10010 from the database plus `1` to get its comments).';
            type: 'string';
          };
          variables: {
            additionalProperties: {
              description: 'Variables used in the formula, mapped to the parts of the expression they refer to.';
              type: 'string';
            };
            description: 'Variables used in the formula, mapped to the parts of the expression they refer to.';
            type: 'object';
          };
        };
        required: ['expensiveOperations'];
        type: 'object';
      };
      JiraExpressionEvalContextBean: {
        additionalProperties: false;
        properties: {
          board: {
            description: 'The ID of the board that is available under the `board` variable when evaluating the expression.';
            format: 'int64';
            type: 'integer';
          };
          custom: {
            description: 'Custom context variables and their types. These variable types are available for use in a custom context:\n\n *  `user`: A [user](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#user) specified as an Atlassian account ID.\n *  `issue`: An [issue](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#issue) specified by ID or key. All the fields of the issue object are available in the Jira expression.\n *  `json`: A JSON object containing custom content.\n *  `list`: A JSON list of `user`, `issue`, or `json` variable types.';
            items: {
              $ref: '#/components/schemas/CustomContextVariable';
            };
            type: 'array';
          };
          customerRequest: {
            description: 'The ID of the customer request that is available under the `customerRequest` variable when evaluating the expression. This is the same as the ID of the underlying Jira issue, but the customer request context variable will have a different type.';
            format: 'int64';
            type: 'integer';
          };
          issue: {
            allOf: [
              {
                $ref: '#/components/schemas/IdOrKeyBean';
              },
            ];
            description: 'The issue that is available under the `issue` variable when evaluating the expression.';
          };
          issues: {
            allOf: [
              {
                $ref: '#/components/schemas/JexpIssues';
              },
            ];
            description: 'The collection of issues that is available under the `issues` variable when evaluating the expression.';
          };
          project: {
            allOf: [
              {
                $ref: '#/components/schemas/IdOrKeyBean';
              },
            ];
            description: 'The project that is available under the `project` variable when evaluating the expression.';
          };
          serviceDesk: {
            description: 'The ID of the service desk that is available under the `serviceDesk` variable when evaluating the expression.';
            format: 'int64';
            type: 'integer';
          };
          sprint: {
            description: 'The ID of the sprint that is available under the `sprint` variable when evaluating the expression.';
            format: 'int64';
            type: 'integer';
          };
        };
        type: 'object';
      };
      JiraExpressionEvalRequestBean: {
        additionalProperties: false;
        properties: {
          context: {
            allOf: [
              {
                $ref: '#/components/schemas/JiraExpressionEvalContextBean';
              },
            ];
            description: 'The context in which the Jira expression is evaluated.';
          };
          expression: {
            description: 'The Jira expression to evaluate.';
            example: '{ key: issue.key, type: issue.issueType.name, links: issue.links.map(link => link.linkedIssue.id) }';
            type: 'string';
          };
        };
        required: ['expression'];
        type: 'object';
      };
      JiraExpressionEvaluateContextBean: {
        additionalProperties: false;
        properties: {
          board: {
            description: 'The ID of the board that is available under the `board` variable when evaluating the expression.';
            format: 'int64';
            type: 'integer';
          };
          custom: {
            description: 'Custom context variables and their types. These variable types are available for use in a custom context:\n\n *  `user`: A [user](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#user) specified as an Atlassian account ID.\n *  `issue`: An [issue](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#issue) specified by ID or key. All the fields of the issue object are available in the Jira expression.\n *  `json`: A JSON object containing custom content.\n *  `list`: A JSON list of `user`, `issue`, or `json` variable types.';
            items: {
              $ref: '#/components/schemas/CustomContextVariable';
            };
            type: 'array';
          };
          customerRequest: {
            description: 'The ID of the customer request that is available under the `customerRequest` variable when evaluating the expression. This is the same as the ID of the underlying Jira issue, but the customer request context variable will have a different type.';
            format: 'int64';
            type: 'integer';
          };
          issue: {
            allOf: [
              {
                $ref: '#/components/schemas/IdOrKeyBean';
              },
            ];
            description: 'The issue that is available under the `issue` variable when evaluating the expression.';
          };
          issues: {
            allOf: [
              {
                $ref: '#/components/schemas/JexpEvaluateCtxIssues';
              },
            ];
            description: 'The collection of issues that is available under the `issues` variable when evaluating the expression.';
          };
          project: {
            allOf: [
              {
                $ref: '#/components/schemas/IdOrKeyBean';
              },
            ];
            description: 'The project that is available under the `project` variable when evaluating the expression.';
          };
          serviceDesk: {
            description: 'The ID of the service desk that is available under the `serviceDesk` variable when evaluating the expression.';
            format: 'int64';
            type: 'integer';
          };
          sprint: {
            description: 'The ID of the sprint that is available under the `sprint` variable when evaluating the expression.';
            format: 'int64';
            type: 'integer';
          };
        };
        type: 'object';
      };
      JiraExpressionEvaluateRequestBean: {
        additionalProperties: false;
        description: 'The request to evaluate a Jira expression. This bean will be replacing `JiraExpressionEvaluateRequest` as part of new `evaluate` endpoint';
        properties: {
          context: {
            allOf: [
              {
                $ref: '#/components/schemas/JiraExpressionEvaluateContextBean';
              },
            ];
            description: 'The context in which the Jira expression is evaluated.';
          };
          expression: {
            description: 'The Jira expression to evaluate.';
            example: '{ key: issue.key, type: issue.issueType.name, links: issue.links.map(link => link.linkedIssue.id) }';
            type: 'string';
          };
        };
        required: ['expression'];
        type: 'object';
      };
      JiraExpressionEvaluationMetaDataBean: {
        additionalProperties: false;
        properties: {
          complexity: {
            allOf: [
              {
                $ref: '#/components/schemas/JiraExpressionsComplexityBean';
              },
            ];
            description: 'Contains information about the expression complexity. For example, the number of steps it took to evaluate the expression.';
          };
          issues: {
            allOf: [
              {
                $ref: '#/components/schemas/IssuesMetaBean';
              },
            ];
            description: 'Contains information about the `issues` variable in the context. For example, is the issues were loaded with JQL, information about the page will be included here.';
          };
        };
        type: 'object';
      };
      JiraExpressionForAnalysis: {
        additionalProperties: false;
        description: 'Details of Jira expressions for analysis.';
        properties: {
          contextVariables: {
            additionalProperties: {
              description: 'Context variables and their types. The type checker assumes that <a href="https://developer.atlassian.com/cloud/jira/platform/jira-expressions/#context-variables">common context variables</a>, such as <code>issue</code> or <code>project</code>, are available in context and sets their type. Use this property to override the default types or provide details of new variables.';
              type: 'string';
            };
            description: 'Context variables and their types. The type checker assumes that [common context variables](https://developer.atlassian.com/cloud/jira/platform/jira-expressions/#context-variables), such as `issue` or `project`, are available in context and sets their type. Use this property to override the default types or provide details of new variables.';
            type: 'object';
          };
          expressions: {
            description: 'The list of Jira expressions to analyse.';
            example: "issues.map(issue => issue.properties['property_key'])";
            items: {
              description: 'The list of Jira expressions to analyse.';
              example: "issues.map(issue => issue.properties['property_key'])";
              type: 'string';
            };
            type: 'array';
          };
        };
        required: ['expressions'];
        type: 'object';
      };
      JiraExpressionResult: {
        additionalProperties: false;
        description: 'The result of evaluating a Jira expression.';
        properties: {
          meta: {
            allOf: [
              {
                $ref: '#/components/schemas/JiraExpressionEvaluationMetaDataBean';
              },
            ];
            description: 'Contains various characteristics of the performed expression evaluation.';
          };
          value: {
            description: "The value of the evaluated expression. It may be a primitive JSON value or a Jira REST API object. (Some expressions do not produce any meaningful results—for example, an expression that returns a lambda function—if that's the case a simple string representation is returned. These string representations should not be relied upon and may change without notice.)";
          };
        };
        required: ['value'];
        type: 'object';
      };
      JiraExpressionValidationError: {
        additionalProperties: false;
        description: 'Details about syntax and type errors. The error details apply to the entire expression, unless the object includes:\n\n *  `line` and `column`\n *  `expression`';
        properties: {
          column: {
            description: 'The text column in which the error occurred.';
            format: 'int32';
            type: 'integer';
          };
          expression: {
            description: 'The part of the expression in which the error occurred.';
            type: 'string';
          };
          line: {
            description: 'The text line in which the error occurred.';
            format: 'int32';
            type: 'integer';
          };
          message: {
            description: 'Details about the error.';
            example: '!, -, typeof, (, IDENTIFIER, null, true, false, NUMBER, STRING, TEMPLATE_LITERAL, new, [ or { expected, > encountered.';
            type: 'string';
          };
          type: {
            description: 'The error type.';
            enum: ['syntax', 'type', 'other'];
            type: 'string';
          };
        };
        required: ['message', 'type'];
        type: 'object';
      };
      JiraExpressionsAnalysis: {
        additionalProperties: false;
        description: 'Details about the analysed Jira expression.';
        properties: {
          results: {
            description: 'The results of Jira expressions analysis.';
            items: {
              $ref: '#/components/schemas/JiraExpressionAnalysis';
            };
            type: 'array';
          };
        };
        required: ['results'];
        type: 'object';
      };
      JiraExpressionsComplexityBean: {
        additionalProperties: false;
        properties: {
          beans: {
            allOf: [
              {
                $ref: '#/components/schemas/JiraExpressionsComplexityValueBean';
              },
            ];
            description: 'The number of Jira REST API beans returned in the response.';
          };
          expensiveOperations: {
            allOf: [
              {
                $ref: '#/components/schemas/JiraExpressionsComplexityValueBean';
              },
            ];
            description: 'The number of expensive operations executed while evaluating the expression. Expensive operations are those that load additional data, such as entity properties, comments, or custom fields.';
          };
          primitiveValues: {
            allOf: [
              {
                $ref: '#/components/schemas/JiraExpressionsComplexityValueBean';
              },
            ];
            description: 'The number of primitive values returned in the response.';
          };
          steps: {
            allOf: [
              {
                $ref: '#/components/schemas/JiraExpressionsComplexityValueBean';
              },
            ];
            description: 'The number of steps it took to evaluate the expression, where a step is a high-level operation performed by the expression. A step is an operation such as arithmetic, accessing a property, accessing a context variable, or calling a function.';
          };
        };
        required: ['beans', 'expensiveOperations', 'primitiveValues', 'steps'];
        type: 'object';
      };
      JiraExpressionsComplexityValueBean: {
        additionalProperties: false;
        properties: {
          limit: {
            description: 'The maximum allowed complexity. The evaluation will fail if this value is exceeded.';
            format: 'int32';
            type: 'integer';
          };
          value: {
            description: 'The complexity value of the current expression.';
            format: 'int32';
            type: 'integer';
          };
        };
        required: ['limit', 'value'];
        type: 'object';
      };
      JiraGroupInput: {
        additionalProperties: false;
        properties: {
          groupName: {
            type: 'string';
          };
        };
        required: ['groupName'];
        type: 'object';
      };
      JiraIssueFields: {
        additionalProperties: false;
        properties: {
          cascadingSelectFields: {
            description: "Add or clear a cascading select field:\n\n *  To add, specify `optionId` for both parent and child.\n *  To clear the child, set its `optionId` to null.\n *  To clear both, set the parent's `optionId` to null.";
            items: {
              $ref: '#/components/schemas/JiraCascadingSelectField';
            };
            type: 'array';
          };
          clearableNumberFields: {
            description: 'Add or clear a number field:\n\n *  To add, specify a numeric `value`.\n *  To clear, set `value` to `null`.';
            items: {
              $ref: '#/components/schemas/JiraNumberField';
            };
            type: 'array';
          };
          colorFields: {
            description: 'Add or clear a color field:\n\n *  To add, specify the color `name`. Available colors are: `purple`, `blue`, `green`, `teal`, `yellow`, `orange`, `grey`, `dark purple`, `dark blue`, `dark green`, `dark teal`, `dark yellow`, `dark orange`, `dark grey`.\n *  To clear, set the color `name` to an empty string.';
            items: {
              $ref: '#/components/schemas/JiraColorField';
            };
            type: 'array';
          };
          datePickerFields: {
            description: 'Add or clear a date picker field:\n\n *  To add, specify the date in `d/mmm/yy` format or ISO format `dd-mm-yyyy`.\n *  To clear, set `formattedDate` to an empty string.';
            items: {
              $ref: '#/components/schemas/JiraDateField';
            };
            type: 'array';
          };
          dateTimePickerFields: {
            description: 'Add or clear the planned start date and time:\n\n *  To add, specify the date and time in ISO format for `formattedDateTime`.\n *  To clear, provide an empty string for `formattedDateTime`.';
            items: {
              $ref: '#/components/schemas/JiraDateTimeField';
            };
            type: 'array';
          };
          issueType: {
            allOf: [
              {
                $ref: '#/components/schemas/JiraIssueTypeField';
              },
            ];
            description: 'Set the issue type field by providing an `issueTypeId`.';
          };
          labelsFields: {
            description: 'Edit a labels field:\n\n *  Options include `ADD`, `REPLACE`, `REMOVE`, or `REMOVE_ALL` for bulk edits.\n *  To clear labels, use the `REMOVE_ALL` option with an empty `labels` array.';
            items: {
              $ref: '#/components/schemas/JiraLabelsField';
            };
            type: 'array';
          };
          multipleGroupPickerFields: {
            description: 'Add or clear a multi-group picker field:\n\n *  To add groups, provide an array of groups with `groupName`s.\n *  To clear all groups, use an empty `groups` array.';
            items: {
              $ref: '#/components/schemas/JiraMultipleGroupPickerField';
            };
            type: 'array';
          };
          multipleSelectClearableUserPickerFields: {
            description: 'Assign or unassign multiple users to/from a field:\n\n *  To assign, provide an array of user `accountId`s.\n *  To clear, set `users` to `null`.';
            items: {
              $ref: '#/components/schemas/JiraMultipleSelectUserPickerField';
            };
            type: 'array';
          };
          multipleSelectFields: {
            description: 'Add or clear a multi-select field:\n\n *  To add, provide an array of options with `optionId`s.\n *  To clear, use an empty `options` array.';
            items: {
              $ref: '#/components/schemas/JiraMultipleSelectField';
            };
            type: 'array';
          };
          multipleVersionPickerFields: {
            description: 'Edit a multi-version picker field like Fix Versions/Affects Versions:\n\n *  Options include `ADD`, `REPLACE`, `REMOVE`, or `REMOVE_ALL` for bulk edits.\n *  To clear the field, use the `REMOVE_ALL` option with an empty `versions` array.';
            items: {
              $ref: '#/components/schemas/JiraMultipleVersionPickerField';
            };
            type: 'array';
          };
          multiselectComponents: {
            allOf: [
              {
                $ref: '#/components/schemas/JiraMultiSelectComponentField';
              },
            ];
            description: 'Edit a multi select components field:\n\n *  Options include `ADD`, `REPLACE`, `REMOVE`, or `REMOVE_ALL` for bulk edits.\n *  To clear, use the `REMOVE_ALL` option with an empty `components` array.';
          };
          originalEstimateField: {
            allOf: [
              {
                $ref: '#/components/schemas/JiraDurationField';
              },
            ];
            description: 'Edit the original estimate field.';
          };
          priority: {
            allOf: [
              {
                $ref: '#/components/schemas/JiraPriorityField';
              },
            ];
            description: 'Set the priority of an issue by specifying a `priorityId`.';
          };
          richTextFields: {
            description: 'Add or clear a rich text field:\n\n *  To add, provide `adfValue`. Note that rich text fields only support ADF values.\n *  To clear, use an empty `richText` object.\n\nFor ADF format details, refer to: [Atlassian Document Format](https://developer.atlassian.com/cloud/jira/platform/apis/document/structure).';
            items: {
              $ref: '#/components/schemas/JiraRichTextField';
            };
            type: 'array';
          };
          singleGroupPickerFields: {
            description: 'Add or clear a single group picker field:\n\n *  To add, specify the group with `groupName`.\n *  To clear, set `groupName` to an empty string.';
            items: {
              $ref: '#/components/schemas/JiraSingleGroupPickerField';
            };
            type: 'array';
          };
          singleLineTextFields: {
            description: 'Add or clear a single line text field:\n\n *  To add, provide the `text` value.\n *  To clear, set `text` to an empty string.';
            items: {
              $ref: '#/components/schemas/JiraSingleLineTextField';
            };
            type: 'array';
          };
          singleSelectClearableUserPickerFields: {
            description: "Edit assignment for single select user picker fields like Assignee/Reporter:\n\n *  To assign an issue, specify the user's `accountId`.\n *  To unassign an issue, set `user` to `null`.\n *  For automatic assignment, set `accountId` to `-1`.";
            items: {
              $ref: '#/components/schemas/JiraSingleSelectUserPickerField';
            };
            type: 'array';
          };
          singleSelectFields: {
            description: 'Add or clear a single select field:\n\n *  To add, specify the option with an `optionId`.\n *  To clear, pass an option with `optionId` as `-1`.';
            items: {
              $ref: '#/components/schemas/JiraSingleSelectField';
            };
            type: 'array';
          };
          singleVersionPickerFields: {
            description: 'Add or clear a single version picker field:\n\n *  To add, specify the version with a `versionId`.\n *  To clear, set `versionId` to `-1`.';
            items: {
              $ref: '#/components/schemas/JiraSingleVersionPickerField';
            };
            type: 'array';
          };
          timeTrackingField: {
            allOf: [
              {
                $ref: '#/components/schemas/JiraTimeTrackingField';
              },
            ];
            description: 'Edit the time tracking field.';
          };
          urlFields: {
            description: 'Add or clear a URL field:\n\n *  To add, provide the `url` with the desired URL value.\n *  To clear, set `url` to an empty string.';
            items: {
              $ref: '#/components/schemas/JiraUrlField';
            };
            type: 'array';
          };
        };
        type: 'object';
        writeOnly: true;
      };
      JiraIssueTypeField: {
        additionalProperties: false;
        properties: {
          issueTypeId: {
            type: 'string';
          };
        };
        required: ['issueTypeId'];
        type: 'object';
      };
      JiraLabelsField: {
        additionalProperties: false;
        properties: {
          bulkEditMultiSelectFieldOption: {
            enum: ['ADD', 'REMOVE', 'REPLACE', 'REMOVE_ALL'];
            type: 'string';
          };
          fieldId: {
            type: 'string';
          };
          labels: {
            items: {
              $ref: '#/components/schemas/JiraLabelsInput';
            };
            type: 'array';
          };
        };
        required: ['bulkEditMultiSelectFieldOption', 'fieldId', 'labels'];
        type: 'object';
      };
      JiraLabelsInput: {
        additionalProperties: false;
        properties: {
          name: {
            type: 'string';
          };
        };
        required: ['name'];
        type: 'object';
      };
      JiraMultiSelectComponentField: {
        additionalProperties: false;
        properties: {
          bulkEditMultiSelectFieldOption: {
            enum: ['ADD', 'REMOVE', 'REPLACE', 'REMOVE_ALL'];
            type: 'string';
          };
          components: {
            items: {
              $ref: '#/components/schemas/JiraComponentField';
            };
            type: 'array';
          };
          fieldId: {
            type: 'string';
          };
        };
        required: ['bulkEditMultiSelectFieldOption', 'components', 'fieldId'];
        type: 'object';
      };
      JiraMultipleGroupPickerField: {
        additionalProperties: false;
        properties: {
          fieldId: {
            type: 'string';
          };
          groups: {
            items: {
              $ref: '#/components/schemas/JiraGroupInput';
            };
            type: 'array';
          };
        };
        required: ['fieldId', 'groups'];
        type: 'object';
      };
      JiraMultipleSelectField: {
        additionalProperties: false;
        properties: {
          fieldId: {
            type: 'string';
          };
          options: {
            items: {
              $ref: '#/components/schemas/JiraSelectedOptionField';
            };
            type: 'array';
          };
        };
        required: ['fieldId', 'options'];
        type: 'object';
      };
      JiraMultipleSelectUserPickerField: {
        additionalProperties: false;
        properties: {
          fieldId: {
            type: 'string';
          };
          users: {
            items: {
              $ref: '#/components/schemas/JiraUserField';
            };
            type: 'array';
          };
        };
        required: ['fieldId'];
        type: 'object';
      };
      JiraMultipleVersionPickerField: {
        additionalProperties: false;
        properties: {
          bulkEditMultiSelectFieldOption: {
            enum: ['ADD', 'REMOVE', 'REPLACE', 'REMOVE_ALL'];
            type: 'string';
          };
          fieldId: {
            type: 'string';
          };
          versions: {
            items: {
              $ref: '#/components/schemas/JiraVersionField';
            };
            type: 'array';
          };
        };
        required: ['bulkEditMultiSelectFieldOption', 'fieldId', 'versions'];
        type: 'object';
      };
      JiraNumberField: {
        additionalProperties: false;
        properties: {
          fieldId: {
            type: 'string';
          };
          value: {
            format: 'double';
            type: 'number';
          };
        };
        required: ['fieldId'];
        type: 'object';
      };
      JiraPriorityField: {
        additionalProperties: false;
        properties: {
          priorityId: {
            type: 'string';
          };
        };
        required: ['priorityId'];
        type: 'object';
      };
      JiraRichTextField: {
        additionalProperties: false;
        properties: {
          fieldId: {
            type: 'string';
          };
          richText: {
            $ref: '#/components/schemas/JiraRichTextInput';
          };
        };
        required: ['fieldId', 'richText'];
        type: 'object';
      };
      JiraRichTextInput: {
        additionalProperties: false;
        properties: {
          adfValue: {
            additionalProperties: {};
            type: 'object';
          };
        };
        type: 'object';
      };
      JiraSelectedOptionField: {
        additionalProperties: false;
        properties: {
          optionId: {
            format: 'int64';
            type: 'integer';
          };
        };
        type: 'object';
      };
      JiraSingleGroupPickerField: {
        additionalProperties: false;
        properties: {
          fieldId: {
            type: 'string';
          };
          group: {
            $ref: '#/components/schemas/JiraGroupInput';
          };
        };
        required: ['fieldId', 'group'];
        type: 'object';
      };
      JiraSingleLineTextField: {
        additionalProperties: false;
        properties: {
          fieldId: {
            type: 'string';
          };
          text: {
            type: 'string';
          };
        };
        required: ['fieldId', 'text'];
        type: 'object';
      };
      JiraSingleSelectField: {
        additionalProperties: false;
        description: 'Add or clear a single select field:\n\n *  To add, specify the option with an `optionId`.\n *  To clear, pass an option with `optionId` as `-1`.';
        properties: {
          fieldId: {
            type: 'string';
          };
          option: {
            $ref: '#/components/schemas/JiraSelectedOptionField';
          };
        };
        required: ['fieldId', 'option'];
        type: 'object';
      };
      JiraSingleSelectUserPickerField: {
        additionalProperties: false;
        properties: {
          fieldId: {
            type: 'string';
          };
          user: {
            $ref: '#/components/schemas/JiraUserField';
          };
        };
        required: ['fieldId'];
        type: 'object';
      };
      JiraSingleVersionPickerField: {
        additionalProperties: false;
        properties: {
          fieldId: {
            type: 'string';
          };
          version: {
            $ref: '#/components/schemas/JiraVersionField';
          };
        };
        required: ['fieldId', 'version'];
        type: 'object';
      };
      JiraStatus: {
        additionalProperties: false;
        description: 'Details of a status.';
        properties: {
          description: {
            description: 'The description of the status.';
            type: 'string';
          };
          id: {
            description: 'The ID of the status.';
            type: 'string';
          };
          name: {
            description: 'The name of the status.';
            type: 'string';
          };
          scope: {
            $ref: '#/components/schemas/StatusScope';
          };
          statusCategory: {
            description: 'The category of the status.';
            enum: ['TODO', 'IN_PROGRESS', 'DONE'];
            type: 'string';
          };
          usages: {
            description: 'Projects and issue types where the status is used. Only available if the `usages` expand is requested.';
            items: {
              $ref: '#/components/schemas/ProjectIssueTypes';
            };
            type: 'array';
            uniqueItems: true;
          };
          workflowUsages: {
            description: 'The workflows that use this status. Only available if the `workflowUsages` expand is requested.';
            items: {
              $ref: '#/components/schemas/WorkflowUsages';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        type: 'object';
      };
      JiraTimeTrackingField: {
        additionalProperties: false;
        properties: {
          timeRemaining: {
            type: 'string';
          };
        };
        required: ['timeRemaining'];
        type: 'object';
      };
      JiraUrlField: {
        additionalProperties: false;
        properties: {
          fieldId: {
            type: 'string';
          };
          url: {
            type: 'string';
          };
        };
        required: ['fieldId', 'url'];
        type: 'object';
      };
      JiraUserField: {
        additionalProperties: false;
        properties: {
          accountId: {
            type: 'string';
          };
        };
        required: ['accountId'];
        type: 'object';
      };
      JiraVersionField: {
        additionalProperties: false;
        properties: {
          versionId: {
            type: 'string';
          };
        };
        type: 'object';
      };
      JiraWorkflow: {
        additionalProperties: false;
        description: 'Details of a workflow.';
        properties: {
          description: {
            description: 'The description of the workflow.';
            type: 'string';
          };
          id: {
            description: 'The ID of the workflow.';
            type: 'string';
          };
          isEditable: {
            description: 'Indicates if the workflow can be edited.';
            type: 'boolean';
          };
          name: {
            description: 'The name of the workflow.';
            type: 'string';
          };
          scope: {
            $ref: '#/components/schemas/WorkflowScope';
          };
          startPointLayout: {
            $ref: '#/components/schemas/WorkflowLayout';
          };
          statuses: {
            description: 'The statuses referenced in this workflow.';
            items: {
              $ref: '#/components/schemas/WorkflowReferenceStatus';
            };
            type: 'array';
            uniqueItems: true;
          };
          taskId: {
            description: 'If there is a current [asynchronous task](#async-operations) operation for this workflow.';
            nullable: true;
            type: 'string';
          };
          transitions: {
            description: 'The transitions of the workflow. Note that a transition can have either the deprecated `to`/`from` fields or the `toStatusReference`/`links` fields, but never both nor a combination.';
            items: {
              $ref: '#/components/schemas/WorkflowTransitions';
            };
            type: 'array';
            uniqueItems: true;
          };
          usages: {
            description: 'Use the optional `workflows.usages` expand to get additional information about the projects and issue types associated with the requested workflows.';
            items: {
              $ref: '#/components/schemas/ProjectIssueTypes';
            };
            type: 'array';
            uniqueItems: true;
          };
          version: {
            $ref: '#/components/schemas/DocumentVersion';
          };
        };
        type: 'object';
      };
      JiraWorkflowStatus: {
        additionalProperties: false;
        description: 'Details of a status.';
        properties: {
          description: {
            description: 'The description of the status.';
            type: 'string';
          };
          id: {
            description: 'The ID of the status.';
            type: 'string';
          };
          name: {
            description: 'The name of the status.';
            type: 'string';
          };
          scope: {
            $ref: '#/components/schemas/WorkflowScope';
          };
          statusCategory: {
            description: 'The category of the status.';
            enum: ['TODO', 'IN_PROGRESS', 'DONE'];
            type: 'string';
          };
          statusReference: {
            description: 'The reference of the status.';
            type: 'string';
          };
          usages: {
            description: 'The `statuses.usages` expand is an optional parameter that can be used when reading and updating statuses in Jira. It provides additional information about the projects and issue types associated with the requested statuses.';
            items: {
              $ref: '#/components/schemas/ProjectIssueTypes';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        type: 'object';
      };
      JqlFunctionPrecomputationBean: {
        additionalProperties: false;
        description: 'Jql function precomputation.';
        properties: {
          arguments: {
            description: 'The list of arguments function was invoked with.';
            items: {
              readOnly: true;
              type: 'string';
            };
            readOnly: true;
            type: 'array';
          };
          created: {
            description: 'The timestamp of the precomputation creation.';
            format: 'date-time';
            readOnly: true;
            type: 'string';
          };
          error: {
            description: 'The error message to be displayed to the user.';
            readOnly: true;
            type: 'string';
          };
          field: {
            description: 'The field the function was executed against.';
            readOnly: true;
            type: 'string';
          };
          functionKey: {
            description: 'The function key.';
            readOnly: true;
            type: 'string';
          };
          functionName: {
            description: 'The name of the function.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The id of the precomputation.';
            readOnly: true;
            type: 'string';
          };
          operator: {
            description: 'The operator in context of which function was executed.';
            readOnly: true;
            type: 'string';
          };
          updated: {
            description: 'The timestamp of the precomputation last update.';
            format: 'date-time';
            readOnly: true;
            type: 'string';
          };
          used: {
            description: 'The timestamp of the precomputation last usage.';
            format: 'date-time';
            readOnly: true;
            type: 'string';
          };
          value: {
            description: 'The JQL fragment stored as the precomputation.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      JqlFunctionPrecomputationUpdateBean: {
        additionalProperties: false;
        description: 'Precomputation id and its new value.';
        properties: {
          error: {
            description: 'The error message to be displayed to the user if the given function clause is no longer valid during recalculation of the precomputation.';
            type: 'string';
            writeOnly: true;
          };
          id: {
            description: 'The id of the precomputation to update.';
            type: 'string';
            writeOnly: true;
          };
          value: {
            description: 'The new value of the precomputation.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['id'];
        type: 'object';
        writeOnly: true;
      };
      JqlFunctionPrecomputationUpdateRequestBean: {
        additionalProperties: false;
        description: 'List of pairs (id and value) for precomputation updates.';
        properties: {
          values: {
            items: {
              $ref: '#/components/schemas/JqlFunctionPrecomputationUpdateBean';
            };
            type: 'array';
          };
        };
        type: 'object';
        writeOnly: true;
      };
      JqlQueriesToParse: {
        additionalProperties: false;
        description: 'A list of JQL queries to parse.';
        properties: {
          queries: {
            description: 'A list of queries to parse.';
            items: {
              minLength: 1;
              type: 'string';
            };
            minLength: 1;
            type: 'array';
          };
        };
        required: ['queries'];
        type: 'object';
        writeOnly: true;
      };
      JqlQueriesToSanitize: {
        additionalProperties: false;
        description: 'The list of JQL queries to sanitize for the given account IDs.';
        properties: {
          queries: {
            description: 'The list of JQL queries to sanitize. Must contain unique values. Maximum of 20 queries.';
            items: {
              $ref: '#/components/schemas/JqlQueryToSanitize';
            };
            type: 'array';
          };
        };
        required: ['queries'];
        type: 'object';
        writeOnly: true;
      };
      JqlQuery: {
        additionalProperties: false;
        description: 'A parsed JQL query.';
        properties: {
          orderBy: {
            $ref: '#/components/schemas/JqlQueryOrderByClause';
          };
          where: {
            $ref: '#/components/schemas/JqlQueryClause';
          };
        };
        type: 'object';
      };
      JqlQueryClause: {
        additionalProperties: false;
        anyOf: [
          {
            $ref: '#/components/schemas/CompoundClause';
          },
          {
            $ref: '#/components/schemas/FieldValueClause';
          },
          {
            $ref: '#/components/schemas/FieldWasClause';
          },
          {
            $ref: '#/components/schemas/FieldChangedClause';
          },
        ];
        description: 'A JQL query clause.';
        type: 'object';
      };
      JqlQueryClauseOperand: {
        anyOf: [
          {
            $ref: '#/components/schemas/ListOperand';
          },
          {
            $ref: '#/components/schemas/ValueOperand';
          },
          {
            $ref: '#/components/schemas/FunctionOperand';
          },
          {
            $ref: '#/components/schemas/KeywordOperand';
          },
        ];
        description: 'Details of an operand in a JQL clause.';
        type: 'object';
      };
      JqlQueryClauseTimePredicate: {
        description: 'A time predicate for a temporal JQL clause.';
        properties: {
          operand: {
            $ref: '#/components/schemas/JqlQueryClauseOperand';
          };
          operator: {
            description: 'The operator between the field and the operand.';
            enum: ['before', 'after', 'from', 'to', 'on', 'during', 'by'];
            type: 'string';
          };
        };
        required: ['operand', 'operator'];
        type: 'object';
      };
      JqlQueryField: {
        additionalProperties: false;
        description: 'A field used in a JQL query. See [Advanced searching - fields reference](https://confluence.atlassian.com/x/dAiiLQ) for more information about fields in JQL queries.';
        properties: {
          encodedName: {
            description: 'The encoded name of the field, which can be used directly in a JQL query.';
            type: 'string';
          };
          name: {
            description: 'The name of the field.';
            type: 'string';
          };
          property: {
            description: 'When the field refers to a value in an entity property, details of the entity property value.';
            items: {
              $ref: '#/components/schemas/JqlQueryFieldEntityProperty';
            };
            type: 'array';
          };
        };
        required: ['name'];
        type: 'object';
      };
      JqlQueryFieldEntityProperty: {
        description: 'Details of an entity property.';
        properties: {
          entity: {
            description: 'The object on which the property is set.';
            example: 'issue';
            type: 'string';
          };
          key: {
            description: 'The key of the property.';
            example: 'stats';
            type: 'string';
          };
          path: {
            description: 'The path in the property value to query.';
            example: 'comments.count';
            type: 'string';
          };
          type: {
            description: 'The type of the property value extraction. Not available if the extraction for the property is not registered on the instance with the [Entity property](https://developer.atlassian.com/cloud/jira/platform/modules/entity-property/) module.';
            enum: ['number', 'string', 'text', 'date', 'user'];
            example: 'number';
            type: 'string';
          };
        };
        required: ['entity', 'key', 'path'];
        type: 'object';
      };
      JqlQueryOrderByClause: {
        additionalProperties: false;
        description: 'Details of the order-by JQL clause.';
        properties: {
          fields: {
            description: 'The list of order-by clause fields and their ordering directives.';
            items: {
              $ref: '#/components/schemas/JqlQueryOrderByClauseElement';
            };
            type: 'array';
          };
        };
        required: ['fields'];
        type: 'object';
      };
      JqlQueryOrderByClauseElement: {
        additionalProperties: false;
        description: 'An element of the order-by JQL clause.';
        properties: {
          direction: {
            description: 'The direction in which to order the results.';
            enum: ['asc', 'desc'];
            type: 'string';
          };
          field: {
            $ref: '#/components/schemas/JqlQueryField';
          };
        };
        required: ['field'];
        type: 'object';
      };
      JqlQueryToSanitize: {
        additionalProperties: false;
        description: 'The JQL query to sanitize for the account ID. If the account ID is null, sanitizing is performed for an anonymous user.';
        properties: {
          accountId: {
            description: 'The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.';
            maxLength: 128;
            nullable: true;
            type: 'string';
          };
          query: {
            description: 'The query to sanitize.';
            type: 'string';
          };
        };
        required: ['query'];
        type: 'object';
        writeOnly: true;
      };
      JqlQueryUnitaryOperand: {
        anyOf: [
          {
            $ref: '#/components/schemas/ValueOperand';
          },
          {
            $ref: '#/components/schemas/FunctionOperand';
          },
          {
            $ref: '#/components/schemas/KeywordOperand';
          },
        ];
        description: 'An operand that can be part of a list operand.';
        type: 'object';
      };
      JsonContextVariable: {
        description: 'A JSON object with custom content.';
        properties: {
          type: {
            description: 'Type of custom context variable.';
            type: 'string';
          };
          value: {
            description: 'A JSON object containing custom content.';
            type: 'object';
          };
        };
        required: ['type'];
        type: 'object';
      };
      JsonNode: {
        additionalProperties: false;
        maxProperties: 10;
        minProperties: 1;
        properties: {
          array: {
            type: 'boolean';
          };
          bigDecimal: {
            type: 'boolean';
          };
          bigInteger: {
            type: 'boolean';
          };
          bigIntegerValue: {
            type: 'integer';
          };
          binary: {
            type: 'boolean';
          };
          binaryValue: {
            items: {
              format: 'byte';
              type: 'string';
            };
            type: 'array';
          };
          boolean: {
            type: 'boolean';
          };
          booleanValue: {
            type: 'boolean';
          };
          containerNode: {
            type: 'boolean';
          };
          decimalValue: {
            type: 'number';
          };
          double: {
            type: 'boolean';
          };
          doubleValue: {
            format: 'double';
            type: 'number';
          };
          elements: {
            type: 'object';
          };
          fieldNames: {
            type: 'object';
          };
          fields: {
            type: 'object';
          };
          floatingPointNumber: {
            type: 'boolean';
          };
          int: {
            type: 'boolean';
          };
          intValue: {
            format: 'int32';
            type: 'integer';
          };
          integralNumber: {
            type: 'boolean';
          };
          long: {
            type: 'boolean';
          };
          longValue: {
            format: 'int64';
            type: 'integer';
          };
          missingNode: {
            type: 'boolean';
          };
          null: {
            type: 'boolean';
          };
          number: {
            type: 'boolean';
          };
          numberType: {
            enum: ['INT', 'LONG', 'BIG_INTEGER', 'FLOAT', 'DOUBLE', 'BIG_DECIMAL'];
            type: 'string';
          };
          numberValue: {
            type: 'number';
          };
          object: {
            type: 'boolean';
          };
          pojo: {
            type: 'boolean';
          };
          textValue: {
            type: 'string';
          };
          textual: {
            type: 'boolean';
          };
          valueAsBoolean: {
            type: 'boolean';
          };
          valueAsDouble: {
            format: 'double';
            type: 'number';
          };
          valueAsInt: {
            format: 'int32';
            type: 'integer';
          };
          valueAsLong: {
            format: 'int64';
            type: 'integer';
          };
          valueAsText: {
            type: 'string';
          };
          valueNode: {
            type: 'boolean';
          };
        };
        type: 'object';
      };
      JsonTypeBean: {
        additionalProperties: false;
        description: 'The schema of a field.';
        properties: {
          configuration: {
            additionalProperties: {
              readOnly: true;
            };
            description: 'If the field is a custom field, the configuration of the field.';
            readOnly: true;
            type: 'object';
          };
          custom: {
            description: 'If the field is a custom field, the URI of the field.';
            readOnly: true;
            type: 'string';
          };
          customId: {
            description: 'If the field is a custom field, the custom ID of the field.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          items: {
            description: 'When the data type is an array, the name of the field items within the array.';
            readOnly: true;
            type: 'string';
          };
          system: {
            description: 'If the field is a system field, the name of the field.';
            readOnly: true;
            type: 'string';
          };
          type: {
            description: 'The data type of the field.';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['type'];
        type: 'object';
      };
      KeywordOperand: {
        description: 'An operand that is a JQL keyword. See [Advanced searching - keywords reference](https://confluence.atlassian.com/jiracorecloud/advanced-searching-keywords-reference-765593717.html#Advancedsearching-keywordsreference-EMPTYEMPTY) for more information about operand keywords.';
        properties: {
          keyword: {
            description: 'The keyword that is the operand value.';
            enum: ['empty'];
            type: 'string';
          };
        };
        required: ['keyword'];
        type: 'object';
      };
      LegacyJackson1ListAttachment: {
        items: {
          $ref: '#/components/schemas/Attachment';
        };
        type: 'array';
      };
      LegacyJackson1ListColumnItem: {
        items: {
          $ref: '#/components/schemas/ColumnItem';
        };
        type: 'array';
      };
      LegacyJackson1ListIssueEvent: {
        items: {
          $ref: '#/components/schemas/IssueEvent';
        };
        type: 'array';
      };
      LegacyJackson1ListIssueTypeWithStatus: {
        items: {
          $ref: '#/components/schemas/IssueTypeWithStatus';
        };
        type: 'array';
      };
      LegacyJackson1ListProject: {
        items: {
          $ref: '#/components/schemas/Project';
        };
        type: 'array';
      };
      LegacyJackson1ListProjectComponent: {
        items: {
          $ref: '#/components/schemas/ProjectComponent';
        };
        type: 'array';
      };
      LegacyJackson1ListProjectRoleDetails: {
        items: {
          $ref: '#/components/schemas/ProjectRoleDetails';
        };
        type: 'array';
      };
      LegacyJackson1ListProjectType: {
        items: {
          $ref: '#/components/schemas/ProjectType';
        };
        type: 'array';
      };
      LegacyJackson1ListUserMigrationBean: {
        items: {
          $ref: '#/components/schemas/UserMigrationBean';
        };
        type: 'array';
      };
      LegacyJackson1ListVersion: {
        items: {
          $ref: '#/components/schemas/Version';
        };
        type: 'array';
      };
      LegacyJackson1ListWorklog: {
        items: {
          $ref: '#/components/schemas/Worklog';
        };
        type: 'array';
      };
      License: {
        additionalProperties: false;
        description: 'Details about a license for the Jira instance.';
        properties: {
          applications: {
            description: 'The applications under this license.';
            items: {
              $ref: '#/components/schemas/LicensedApplication';
            };
            readOnly: true;
            type: 'array';
          };
        };
        required: ['applications'];
        type: 'object';
      };
      LicenseMetric: {
        additionalProperties: false;
        description: 'A metric that provides insight into the active licence details';
        properties: {
          key: {
            description: 'The key of a specific license metric.';
            type: 'string';
          };
          value: {
            description: 'The calculated value of a licence metric linked to the key. An example licence metric is the approximate number of user accounts.';
            type: 'string';
          };
        };
        type: 'object';
      };
      LicensedApplication: {
        additionalProperties: false;
        description: 'Details about a licensed Jira application.';
        properties: {
          id: {
            description: 'The ID of the application.';
            readOnly: true;
            type: 'string';
          };
          plan: {
            description: 'The licensing plan.';
            enum: ['UNLICENSED', 'FREE', 'PAID'];
            readOnly: true;
            type: 'string';
          };
        };
        required: ['id', 'plan'];
        type: 'object';
      };
      LinkGroup: {
        additionalProperties: false;
        description: 'Details a link group, which defines issue operations.';
        properties: {
          groups: {
            items: {
              $ref: '#/components/schemas/LinkGroup';
            };
            type: 'array';
          };
          header: {
            $ref: '#/components/schemas/SimpleLink';
          };
          id: {
            type: 'string';
          };
          links: {
            items: {
              $ref: '#/components/schemas/SimpleLink';
            };
            type: 'array';
          };
          styleClass: {
            type: 'string';
          };
          weight: {
            format: 'int32';
            type: 'integer';
          };
        };
        type: 'object';
      };
      LinkIssueRequestJsonBean: {
        additionalProperties: false;
        properties: {
          comment: {
            $ref: '#/components/schemas/Comment';
          };
          inwardIssue: {
            $ref: '#/components/schemas/LinkedIssue';
          };
          outwardIssue: {
            $ref: '#/components/schemas/LinkedIssue';
          };
          type: {
            $ref: '#/components/schemas/IssueLinkType';
          };
        };
        required: ['inwardIssue', 'outwardIssue', 'type'];
        type: 'object';
      };
      LinkedIssue: {
        additionalProperties: false;
        description: 'The ID or key of a linked issue.';
        properties: {
          fields: {
            allOf: [
              {
                $ref: '#/components/schemas/Fields';
              },
            ];
            description: 'The fields associated with the issue.';
            readOnly: true;
          };
          id: {
            description: "The ID of an issue. Required if `key` isn't provided.";
            type: 'string';
          };
          key: {
            description: "The key of an issue. Required if `id` isn't provided.";
            type: 'string';
          };
          self: {
            description: 'The URL of the issue.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      ListOperand: {
        description: 'An operand that is a list of values.';
        properties: {
          encodedOperand: {
            description: 'Encoded operand, which can be used directly in a JQL query.';
            type: 'string';
          };
          values: {
            description: 'The list of operand values.';
            items: {
              $ref: '#/components/schemas/JqlQueryUnitaryOperand';
            };
            minLength: 1;
            type: 'array';
          };
        };
        required: ['values'];
        type: 'object';
      };
      ListWrapperCallbackApplicationRole: {
        additionalProperties: false;
        type: 'object';
      };
      ListWrapperCallbackGroupName: {
        additionalProperties: false;
        type: 'object';
      };
      Locale: {
        additionalProperties: false;
        description: 'Details of a locale.';
        properties: {
          locale: {
            description: 'The locale code. The Java the locale format is used: a two character language code (ISO 639), an underscore, and two letter country code (ISO 3166). For example, en\\_US represents a locale of English (United States). Required on create.';
            type: 'string';
          };
        };
        type: 'object';
      };
      MandatoryFieldValue: {
        description: 'List of string of inputs';
        properties: {
          retain: {
            default: true;
            description: 'If `true`, will try to retain original non-null issue field values on move.';
            nullable: true;
            type: 'boolean';
            writeOnly: true;
          };
          type: {
            default: 'raw';
            description: 'Will treat as `MandatoryFieldValue` if type is `raw` or `empty`';
            enum: ['adf', 'raw'];
            nullable: true;
            type: 'string';
            writeOnly: true;
          };
          value: {
            description: 'Value for each field. Provide a `list of strings` for non-ADF fields.';
            items: {
              description: 'Value for each field. Provide a <code>list of strings</code> for non-ADF fields.';
              type: 'string';
              writeOnly: true;
            };
            type: 'array';
            writeOnly: true;
          };
        };
        required: ['value'];
        type: 'object';
      };
      MandatoryFieldValueForADF: {
        description: 'An object notation input';
        properties: {
          retain: {
            default: true;
            description: 'If `true`, will try to retain original non-null issue field values on move.';
            nullable: true;
            type: 'boolean';
            writeOnly: true;
          };
          type: {
            default: 'raw';
            description: 'Will treat as `MandatoryFieldValueForADF` if type is `adf`';
            enum: ['adf', 'raw'];
            type: 'string';
            writeOnly: true;
          };
          value: {
            description: 'Value for each field. Accepts Atlassian Document Format (ADF) for rich text fields like `description`, `environments`. For ADF format details, refer to: [Atlassian Document Format](https://developer.atlassian.com/cloud/jira/platform/apis/document/structure)';
            type: 'object';
            writeOnly: true;
          };
        };
        required: ['type', 'value'];
        type: 'object';
      };
      MappingsByIssueTypeOverride: {
        additionalProperties: false;
        description: "Overrides, for the selected issue types, any status mappings provided in `statusMappingsByWorkflows`. Status mappings are required when the new workflow for an issue type doesn't contain all statuses that the old workflow has. Status mappings can be provided by a combination of `statusMappingsByWorkflows` and `statusMappingsByIssueTypeOverride`.";
        properties: {
          issueTypeId: {
            description: 'The ID of the issue type for this mapping.';
            type: 'string';
          };
          statusMappings: {
            description: 'The list of status mappings.';
            items: {
              $ref: '#/components/schemas/WorkflowAssociationStatusMapping';
            };
            type: 'array';
          };
        };
        required: ['issueTypeId', 'statusMappings'];
        type: 'object';
      };
      MappingsByWorkflow: {
        additionalProperties: false;
        description: "The status mappings by workflows. Status mappings are required when the new workflow for an issue type doesn't contain all statuses that the old workflow has. Status mappings can be provided by a combination of `statusMappingsByWorkflows` and `statusMappingsByIssueTypeOverride`.";
        properties: {
          newWorkflowId: {
            description: 'The ID of the new workflow.';
            type: 'string';
          };
          oldWorkflowId: {
            description: 'The ID of the old workflow.';
            type: 'string';
          };
          statusMappings: {
            description: 'The list of status mappings.';
            items: {
              $ref: '#/components/schemas/WorkflowAssociationStatusMapping';
            };
            type: 'array';
          };
        };
        required: ['newWorkflowId', 'oldWorkflowId', 'statusMappings'];
        type: 'object';
      };
      MoveFieldBean: {
        additionalProperties: false;
        properties: {
          after: {
            description: "The ID of the screen tab field after which to place the moved screen tab field. Required if `position` isn't provided.";
            format: 'uri';
            type: 'string';
          };
          position: {
            description: "The named position to which the screen tab field should be moved. Required if `after` isn't provided.";
            enum: ['Earlier', 'Later', 'First', 'Last'];
            type: 'string';
          };
        };
        type: 'object';
      };
      MultiIssueEntityProperties: {
        additionalProperties: false;
        description: 'A list of issues and their respective properties to set or update. See [Entity properties](https://developer.atlassian.com/cloud/jira/platform/jira-entity-properties/) for more information.';
        properties: {
          issues: {
            description: 'A list of issue IDs and their respective properties.';
            items: {
              $ref: '#/components/schemas/IssueEntityPropertiesForMultiUpdate';
            };
            maxProperties: 100;
            minProperties: 1;
            type: 'array';
          };
        };
        type: 'object';
      };
      MultipartFile: {
        additionalProperties: false;
        properties: {
          bytes: {
            items: {
              format: 'byte';
              type: 'string';
            };
            type: 'array';
          };
          contentType: {
            type: 'string';
          };
          empty: {
            type: 'boolean';
          };
          inputStream: {
            type: 'object';
          };
          name: {
            type: 'string';
          };
          originalFilename: {
            type: 'string';
          };
          resource: {
            $ref: '#/components/schemas/Resource';
          };
          size: {
            format: 'int64';
            type: 'integer';
          };
        };
        type: 'object';
      };
      MultipleCustomFieldValuesUpdate: {
        additionalProperties: false;
        description: 'A custom field and its new value with a list of issue to update.';
        properties: {
          customField: {
            description: 'The ID or key of the custom field. For example, `customfield_10010`.';
            type: 'string';
            writeOnly: true;
          };
          issueIds: {
            description: 'The list of issue IDs.';
            items: {
              format: 'int64';
              type: 'integer';
              writeOnly: true;
            };
            type: 'array';
            writeOnly: true;
          };
          value: {
            description: 'The value for the custom field. The value must be compatible with the [custom field type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field/#data-types) as follows:\n\n *  `string` the value must be a string.\n *  `number` the value must be a number.\n *  `datetime` the value must be a string that represents a date in the ISO format or the simplified extended ISO format. For example, `"2023-01-18T12:00:00-03:00"` or `"2023-01-18T12:00:00.000Z"`. However, the milliseconds part is ignored.\n *  `user` the value must be an object that contains the `accountId` field.\n *  `group` the value must be an object that contains the group `name` or `groupId` field. Because group names can change, we recommend using `groupId`.\n\nA list of appropriate values must be provided if the field is of the `list` [collection type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field/#collection-types).';
          };
        };
        required: ['customField', 'issueIds', 'value'];
        type: 'object';
        writeOnly: true;
      };
      MultipleCustomFieldValuesUpdateDetails: {
        additionalProperties: false;
        description: 'List of updates for a custom fields.';
        properties: {
          updates: {
            items: {
              $ref: '#/components/schemas/MultipleCustomFieldValuesUpdate';
            };
            type: 'array';
          };
        };
        type: 'object';
        writeOnly: true;
      };
      NestedResponse: {
        additionalProperties: false;
        properties: {
          errorCollection: {
            $ref: '#/components/schemas/ErrorCollection';
          };
          status: {
            format: 'int32';
            type: 'integer';
          };
          warningCollection: {
            $ref: '#/components/schemas/WarningCollection';
          };
        };
        type: 'object';
      };
      NewUserDetails: {
        additionalProperties: true;
        description: 'The user details.';
        properties: {
          applicationKeys: {
            description: 'Deprecated, do not use.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          displayName: {
            description: 'This property is no longer available. If the user has an Atlassian account, their display name is not changed. If the user does not have an Atlassian account, they are sent an email asking them set up an account.';
            type: 'string';
          };
          emailAddress: {
            description: 'The email address for the user.';
            type: 'string';
          };
          key: {
            description: 'This property is no longer available. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.';
            type: 'string';
          };
          name: {
            description: 'This property is no longer available. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.';
            type: 'string';
          };
          password: {
            description: 'This property is no longer available. If the user has an Atlassian account, their password is not changed. If the user does not have an Atlassian account, they are sent an email asking them set up an account.';
            type: 'string';
          };
          products: {
            description: 'Products the new user has access to. Valid products are: jira-core, jira-servicedesk, jira-product-discovery, jira-software. To create a user without product access, set this field to be an empty array.';
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          self: {
            description: 'The URL of the user.';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['emailAddress', 'products'];
        type: 'object';
      };
      Notification: {
        additionalProperties: true;
        description: 'Details about a notification.';
        properties: {
          htmlBody: {
            description: 'The HTML body of the email notification for the issue.';
            type: 'string';
          };
          restrict: {
            allOf: [
              {
                $ref: '#/components/schemas/NotificationRecipientsRestrictions';
              },
            ];
            description: 'Restricts the notifications to users with the specified permissions.';
          };
          subject: {
            description: 'The subject of the email notification for the issue. If this is not specified, then the subject is set to the issue key and summary.';
            type: 'string';
          };
          textBody: {
            description: 'The plain text body of the email notification for the issue.';
            type: 'string';
          };
          to: {
            allOf: [
              {
                $ref: '#/components/schemas/NotificationRecipients';
              },
            ];
            description: 'The recipients of the email notification for the issue.';
          };
        };
        type: 'object';
      };
      NotificationEvent: {
        additionalProperties: false;
        description: 'Details about a notification event.';
        properties: {
          description: {
            description: 'The description of the event.';
            type: 'string';
          };
          id: {
            description: 'The ID of the event. The event can be a [Jira system event](https://confluence.atlassian.com/x/8YdKLg#Creatinganotificationscheme-eventsEvents) or a [custom event](https://confluence.atlassian.com/x/AIlKLg).';
            format: 'int64';
            type: 'integer';
          };
          name: {
            description: 'The name of the event.';
            type: 'string';
          };
          templateEvent: {
            allOf: [
              {
                $ref: '#/components/schemas/NotificationEvent';
              },
            ];
            description: 'The template of the event. Only custom events configured by Jira administrators have template.';
          };
        };
        type: 'object';
      };
      NotificationRecipients: {
        additionalProperties: true;
        description: 'Details of the users and groups to receive the notification.';
        properties: {
          assignee: {
            description: "Whether the notification should be sent to the issue's assignees.";
            type: 'boolean';
          };
          groupIds: {
            description: 'List of groupIds to receive the notification.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          groups: {
            description: 'List of groups to receive the notification.';
            items: {
              $ref: '#/components/schemas/GroupName';
            };
            type: 'array';
          };
          reporter: {
            description: "Whether the notification should be sent to the issue's reporter.";
            type: 'boolean';
          };
          users: {
            description: 'List of users to receive the notification.';
            items: {
              $ref: '#/components/schemas/UserDetails';
            };
            type: 'array';
          };
          voters: {
            description: "Whether the notification should be sent to the issue's voters.";
            type: 'boolean';
          };
          watchers: {
            description: "Whether the notification should be sent to the issue's watchers.";
            type: 'boolean';
          };
        };
        type: 'object';
      };
      NotificationRecipientsRestrictions: {
        additionalProperties: false;
        description: 'Details of the group membership or permissions needed to receive the notification.';
        properties: {
          groupIds: {
            description: 'List of groupId memberships required to receive the notification.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          groups: {
            description: 'List of group memberships required to receive the notification.';
            items: {
              $ref: '#/components/schemas/GroupName';
            };
            type: 'array';
          };
          permissions: {
            description: 'List of permissions required to receive the notification.';
            items: {
              $ref: '#/components/schemas/RestrictedPermission';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      NotificationScheme: {
        additionalProperties: false;
        description: 'Details about a notification scheme.';
        properties: {
          description: {
            description: 'The description of the notification scheme.';
            type: 'string';
          };
          expand: {
            description: 'Expand options that include additional notification scheme details in the response.';
            type: 'string';
          };
          id: {
            description: 'The ID of the notification scheme.';
            format: 'int64';
            type: 'integer';
          };
          name: {
            description: 'The name of the notification scheme.';
            type: 'string';
          };
          notificationSchemeEvents: {
            description: 'The notification events and associated recipients.';
            items: {
              $ref: '#/components/schemas/NotificationSchemeEvent';
            };
            type: 'array';
          };
          projects: {
            description: 'The list of project IDs associated with the notification scheme.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
          };
          scope: {
            allOf: [
              {
                $ref: '#/components/schemas/Scope';
              },
            ];
            description: 'The scope of the notification scheme.';
          };
          self: {
            type: 'string';
          };
        };
        type: 'object';
      };
      NotificationSchemeAndProjectMappingJsonBean: {
        additionalProperties: false;
        properties: {
          notificationSchemeId: {
            type: 'string';
          };
          projectId: {
            type: 'string';
          };
        };
        type: 'object';
      };
      NotificationSchemeEvent: {
        additionalProperties: false;
        description: 'Details about a notification scheme event.';
        properties: {
          event: {
            $ref: '#/components/schemas/NotificationEvent';
          };
          notifications: {
            items: {
              $ref: '#/components/schemas/EventNotification';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      NotificationSchemeEventDetails: {
        additionalProperties: true;
        description: 'Details of a notification scheme event.';
        properties: {
          event: {
            allOf: [
              {
                $ref: '#/components/schemas/NotificationSchemeEventTypeId';
              },
            ];
            description: 'The ID of the event.';
          };
          notifications: {
            description: 'The list of notifications mapped to a specified event.';
            items: {
              $ref: '#/components/schemas/NotificationSchemeNotificationDetails';
            };
            maxLength: 255;
            type: 'array';
            writeOnly: true;
          };
        };
        required: ['event', 'notifications'];
        type: 'object';
        writeOnly: true;
      };
      NotificationSchemeEventTypeId: {
        additionalProperties: true;
        description: 'The ID of an event that is being mapped to notifications.';
        properties: {
          id: {
            description: 'The ID of the notification scheme event.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['id'];
        type: 'object';
        writeOnly: true;
      };
      NotificationSchemeId: {
        additionalProperties: true;
        description: 'The ID of a notification scheme.';
        properties: {
          id: {
            description: 'The ID of a notification scheme.';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['id'];
        type: 'object';
      };
      NotificationSchemeNotificationDetails: {
        additionalProperties: true;
        description: 'Details of a notification within a notification scheme.';
        maxLength: 255;
        properties: {
          notificationType: {
            description: 'The notification type, e.g `CurrentAssignee`, `Group`, `EmailAddress`.';
            type: 'string';
            writeOnly: true;
          };
          parameter: {
            description: 'The value corresponding to the specified notification type.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['notificationType'];
        type: 'object';
        writeOnly: true;
      };
      OldToNewSecurityLevelMappingsBean: {
        additionalProperties: false;
        properties: {
          newLevelId: {
            description: 'The new issue security level ID. Providing null will clear the assigned old level from issues.';
            type: 'string';
            writeOnly: true;
          };
          oldLevelId: {
            description: 'The old issue security level ID. Providing null will remap all issues without any assigned levels.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['newLevelId', 'oldLevelId'];
        type: 'object';
        writeOnly: true;
      };
      OperationMessage: {
        additionalProperties: false;
        example: {
          message: 'An example message.';
          statusCode: 200;
        };
        properties: {
          message: {
            description: 'The human-readable message that describes the result.';
            type: 'string';
          };
          statusCode: {
            description: 'The status code of the response.';
            type: 'integer';
          };
        };
        required: ['message', 'statusCode'];
        type: 'object';
      };
      Operations: {
        additionalProperties: true;
        description: 'Details of the operations that can be performed on the issue.';
        properties: {
          linkGroups: {
            description: 'Details of the link groups defining issue operations.';
            items: {
              $ref: '#/components/schemas/LinkGroup';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      OrderOfCustomFieldOptions: {
        additionalProperties: false;
        description: 'An ordered list of custom field option IDs and information on where to move them.';
        properties: {
          after: {
            description: "The ID of the custom field option or cascading option to place the moved options after. Required if `position` isn't provided.";
            type: 'string';
            writeOnly: true;
          };
          customFieldOptionIds: {
            description: 'A list of IDs of custom field options to move. The order of the custom field option IDs in the list is the order they are given after the move. The list must contain custom field options or cascading options, but not both.';
            items: {
              type: 'string';
              writeOnly: true;
            };
            type: 'array';
            writeOnly: true;
          };
          position: {
            description: "The position the custom field options should be moved to. Required if `after` isn't provided.";
            enum: ['First', 'Last'];
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['customFieldOptionIds'];
        type: 'object';
      };
      OrderOfIssueTypes: {
        additionalProperties: false;
        description: 'An ordered list of issue type IDs and information about where to move them.';
        properties: {
          after: {
            description: "The ID of the issue type to place the moved issue types after. Required if `position` isn't provided.";
            type: 'string';
            writeOnly: true;
          };
          issueTypeIds: {
            description: 'A list of the issue type IDs to move. The order of the issue type IDs in the list is the order they are given after the move.';
            items: {
              type: 'string';
              writeOnly: true;
            };
            type: 'array';
            writeOnly: true;
          };
          position: {
            description: "The position the issue types should be moved to. Required if `after` isn't provided.";
            enum: ['First', 'Last'];
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['issueTypeIds'];
        type: 'object';
      };
      PageBean2ComponentJsonBean: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/ComponentJsonBean';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanChangelog: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/Changelog';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanComment: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/Comment';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanComponentWithIssueCount: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/ComponentWithIssueCount';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanContext: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/Context';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanContextForProjectAndIssueType: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/ContextForProjectAndIssueType';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanContextualConfiguration: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/ContextualConfiguration';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanCustomFieldContext: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/CustomFieldContext';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanCustomFieldContextDefaultValue: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/CustomFieldContextDefaultValue';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanCustomFieldContextOption: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/CustomFieldContextOption';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanCustomFieldContextProjectMapping: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/CustomFieldContextProjectMapping';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanDashboard: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/Dashboard';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanField: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/Field';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanFieldConfigurationDetails: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/FieldConfigurationDetails';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanFieldConfigurationIssueTypeItem: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/FieldConfigurationIssueTypeItem';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanFieldConfigurationItem: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/FieldConfigurationItem';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanFieldConfigurationScheme: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/FieldConfigurationScheme';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanFieldConfigurationSchemeProjects: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/FieldConfigurationSchemeProjects';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanFilterDetails: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/FilterDetails';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanGroupDetails: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/GroupDetails';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanIssueFieldOption: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/IssueFieldOption';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanIssueSecurityLevelMember: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/IssueSecurityLevelMember';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanIssueSecuritySchemeToProjectMapping: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/IssueSecuritySchemeToProjectMapping';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanIssueTypeScheme: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/IssueTypeScheme';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanIssueTypeSchemeMapping: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/IssueTypeSchemeMapping';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanIssueTypeSchemeProjects: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/IssueTypeSchemeProjects';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanIssueTypeScreenScheme: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/IssueTypeScreenScheme';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanIssueTypeScreenSchemeItem: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/IssueTypeScreenSchemeItem';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanIssueTypeScreenSchemesProjects: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/IssueTypeScreenSchemesProjects';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanIssueTypeToContextMapping: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/IssueTypeToContextMapping';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanJqlFunctionPrecomputationBean: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/JqlFunctionPrecomputationBean';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanNotificationScheme: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/NotificationScheme';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanNotificationSchemeAndProjectMappingJsonBean: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/NotificationSchemeAndProjectMappingJsonBean';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanPriority: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/Priority';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanPrioritySchemeWithPaginatedPrioritiesAndProjects: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/PrioritySchemeWithPaginatedPrioritiesAndProjects';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanPriorityWithSequence: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/PriorityWithSequence';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanProject: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/Project';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanProjectDetails: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/ProjectDetails';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanResolutionJsonBean: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/ResolutionJsonBean';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanScreen: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/Screen';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanScreenScheme: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/ScreenScheme';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanScreenWithTab: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/ScreenWithTab';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanSecurityLevel: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/SecurityLevel';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanSecurityLevelMember: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/SecurityLevelMember';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanSecuritySchemeWithProjects: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/SecuritySchemeWithProjects';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanString: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              readOnly: true;
              type: 'string';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanUiModificationDetails: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/UiModificationDetails';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanUser: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/User';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanUserDetails: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/UserDetails';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanUserKey: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/UserKey';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanVersion: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/Version';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanWebhook: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/Webhook';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanWorkflow: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/Workflow';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanWorkflowScheme: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/WorkflowScheme';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageBeanWorkflowTransitionRules: {
        additionalProperties: false;
        description: 'A page of items.';
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            readOnly: true;
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          nextPage: {
            description: 'If there is another page of results, the URL of the next page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the page.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/WorkflowTransitionRules';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PageOfChangelogs: {
        additionalProperties: false;
        description: 'A page of changelogs.';
        properties: {
          histories: {
            description: 'The list of changelogs.';
            items: {
              $ref: '#/components/schemas/Changelog';
            };
            readOnly: true;
            type: 'array';
          };
          maxResults: {
            description: 'The maximum number of results that could be on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          startAt: {
            description: 'The index of the first item returned on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of results on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
        };
        type: 'object';
      };
      PageOfComments: {
        additionalProperties: true;
        description: 'A page of comments.';
        properties: {
          comments: {
            description: 'The list of comments.';
            items: {
              $ref: '#/components/schemas/Comment';
            };
            readOnly: true;
            type: 'array';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of items returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
        };
        type: 'object';
      };
      PageOfCreateMetaIssueTypeWithField: {
        additionalProperties: true;
        description: 'A page of CreateMetaIssueType with Field.';
        properties: {
          fields: {
            description: 'The collection of FieldCreateMetaBeans.';
            items: {
              $ref: '#/components/schemas/FieldCreateMetadata';
            };
            readOnly: true;
            type: 'array';
          };
          maxResults: {
            description: 'The maximum number of items to return per page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          results: {
            items: {
              $ref: '#/components/schemas/FieldCreateMetadata';
            };
            type: 'array';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The total number of items in all pages.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
        };
        type: 'object';
      };
      PageOfCreateMetaIssueTypes: {
        additionalProperties: true;
        description: 'A page of CreateMetaIssueTypes.';
        properties: {
          createMetaIssueType: {
            items: {
              $ref: '#/components/schemas/IssueTypeIssueCreateMetadata';
            };
            type: 'array';
            writeOnly: true;
          };
          issueTypes: {
            description: 'The list of CreateMetaIssueType.';
            items: {
              $ref: '#/components/schemas/IssueTypeIssueCreateMetadata';
            };
            readOnly: true;
            type: 'array';
          };
          maxResults: {
            description: 'The maximum number of items to return per page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          startAt: {
            description: 'The index of the first item returned.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The total number of items in all pages.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
        };
        type: 'object';
      };
      PageOfDashboards: {
        additionalProperties: false;
        description: 'A page containing dashboard details.';
        properties: {
          dashboards: {
            description: 'List of dashboards.';
            items: {
              $ref: '#/components/schemas/Dashboard';
            };
            readOnly: true;
            type: 'array';
          };
          maxResults: {
            description: 'The maximum number of results that could be on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          next: {
            description: 'The URL of the next page of results, if any.';
            readOnly: true;
            type: 'string';
          };
          prev: {
            description: 'The URL of the previous page of results, if any.';
            readOnly: true;
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of results on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
        };
        type: 'object';
      };
      PageOfStatuses: {
        additionalProperties: false;
        properties: {
          isLast: {
            description: 'Whether this is the last page.';
            type: 'boolean';
          };
          maxResults: {
            description: 'The maximum number of items that could be returned.';
            format: 'int32';
            type: 'integer';
          };
          nextPage: {
            description: 'The URL of the next page of results, if any.';
            type: 'string';
          };
          self: {
            description: 'The URL of this page.';
            type: 'string';
          };
          startAt: {
            description: 'The index of the first item returned on the page.';
            format: 'int64';
            type: 'integer';
          };
          total: {
            description: 'Number of items that satisfy the search.';
            format: 'int64';
            type: 'integer';
          };
          values: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/JiraStatus';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      PageOfWorklogs: {
        additionalProperties: true;
        description: 'Paginated list of worklog details';
        properties: {
          maxResults: {
            description: 'The maximum number of results that could be on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          startAt: {
            description: 'The index of the first item returned on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of results on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          worklogs: {
            description: 'List of worklogs.';
            items: {
              $ref: '#/components/schemas/Worklog';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PagedListUserDetailsApplicationUser: {
        additionalProperties: false;
        description: 'A paged list. To access additional details append `[start-index:end-index]` to the expand request. For example, `?expand=sharedUsers[10:40]` returns a list starting at item 10 and finishing at item 40.';
        properties: {
          'end-index': {
            description: 'The index of the last item returned on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
            xml: {
              attribute: true;
              name: 'end-index';
            };
          };
          items: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/UserDetails';
            };
            readOnly: true;
            type: 'array';
          };
          'max-results': {
            description: 'The maximum number of results that could be on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
            xml: {
              attribute: true;
              name: 'max-results';
            };
          };
          size: {
            description: 'The number of items on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
            xml: {
              attribute: true;
            };
          };
          'start-index': {
            description: 'The index of the first item returned on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
            xml: {
              attribute: true;
              name: 'start-index';
            };
          };
        };
        type: 'object';
      };
      PaginatedResponseComment: {
        additionalProperties: false;
        properties: {
          maxResults: {
            format: 'int32';
            type: 'integer';
          };
          results: {
            items: {
              $ref: '#/components/schemas/Comment';
            };
            type: 'array';
          };
          startAt: {
            format: 'int64';
            type: 'integer';
          };
          total: {
            format: 'int64';
            type: 'integer';
          };
        };
        type: 'object';
      };
      PaginatedResponseFieldCreateMetadata: {
        additionalProperties: false;
        properties: {
          maxResults: {
            format: 'int32';
            type: 'integer';
          };
          results: {
            items: {
              $ref: '#/components/schemas/FieldCreateMetadata';
            };
            type: 'array';
          };
          startAt: {
            format: 'int64';
            type: 'integer';
          };
          total: {
            format: 'int64';
            type: 'integer';
          };
        };
        type: 'object';
      };
      PaginatedResponseIssueTypeIssueCreateMetadata: {
        additionalProperties: false;
        properties: {
          maxResults: {
            format: 'int32';
            type: 'integer';
          };
          results: {
            items: {
              $ref: '#/components/schemas/IssueTypeIssueCreateMetadata';
            };
            type: 'array';
          };
          startAt: {
            format: 'int64';
            type: 'integer';
          };
          total: {
            format: 'int64';
            type: 'integer';
          };
        };
        type: 'object';
      };
      ParsedJqlQueries: {
        additionalProperties: false;
        description: 'A list of parsed JQL queries.';
        properties: {
          queries: {
            description: 'A list of parsed JQL queries.';
            items: {
              $ref: '#/components/schemas/ParsedJqlQuery';
            };
            minLength: 1;
            type: 'array';
          };
        };
        required: ['queries'];
        type: 'object';
      };
      ParsedJqlQuery: {
        additionalProperties: false;
        description: 'Details of a parsed JQL query.';
        minLength: 1;
        properties: {
          errors: {
            description: 'The list of syntax or validation errors.';
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          query: {
            description: 'The JQL query that was parsed and validated.';
            type: 'string';
          };
          structure: {
            allOf: [
              {
                $ref: '#/components/schemas/JqlQuery';
              },
            ];
            description: 'The syntax tree of the query. Empty if the query was invalid.';
          };
        };
        required: ['query'];
        type: 'object';
      };
      PermissionDetails: {
        additionalProperties: false;
        description: 'Details for permissions of shareable entities';
        properties: {
          editPermissions: {
            description: 'The edit permissions for the shareable entities.';
            items: {
              $ref: '#/components/schemas/SharePermission';
            };
            type: 'array';
          };
          sharePermissions: {
            description: 'The share permissions for the shareable entities.';
            items: {
              $ref: '#/components/schemas/SharePermission';
            };
            type: 'array';
          };
        };
        required: ['editPermissions', 'sharePermissions'];
        type: 'object';
      };
      PermissionGrant: {
        additionalProperties: true;
        description: 'Details about a permission granted to a user or group.';
        properties: {
          holder: {
            allOf: [
              {
                $ref: '#/components/schemas/PermissionHolder';
              },
            ];
            description: 'The user or group being granted the permission. It consists of a `type`, a type-dependent `parameter` and a type-dependent `value`. See [Holder object](../api-group-permission-schemes/#holder-object) in *Get all permission schemes* for more information.';
          };
          id: {
            description: 'The ID of the permission granted details.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          permission: {
            description: 'The permission to grant. This permission can be one of the built-in permissions or a custom permission added by an app. See [Built-in permissions](../api-group-permission-schemes/#built-in-permissions) in *Get all permission schemes* for more information about the built-in permissions. See the [project permission](https://developer.atlassian.com/cloud/jira/platform/modules/project-permission/) and [global permission](https://developer.atlassian.com/cloud/jira/platform/modules/global-permission/) module documentation for more information about custom permissions.';
            type: 'string';
          };
          self: {
            description: 'The URL of the permission granted details.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      PermissionGrants: {
        additionalProperties: false;
        description: 'List of permission grants.';
        properties: {
          expand: {
            description: 'Expand options that include additional permission grant details in the response.';
            readOnly: true;
            type: 'string';
          };
          permissions: {
            description: 'Permission grants list.';
            items: {
              $ref: '#/components/schemas/PermissionGrant';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PermissionHolder: {
        additionalProperties: false;
        description: 'Details of a user, group, field, or project role that holds a permission. See [Holder object](../api-group-permission-schemes/#holder-object) in *Get all permission schemes* for more information.';
        properties: {
          expand: {
            description: 'Expand options that include additional permission holder details in the response.';
            readOnly: true;
            type: 'string';
          };
          parameter: {
            description: "As a group's name can change, use of `value` is recommended. The identifier associated withthe `type` value that defines the holder of the permission.";
            type: 'string';
          };
          type: {
            description: 'The type of permission holder.';
            type: 'string';
          };
          value: {
            description: 'The identifier associated with the `type` value that defines the holder of the permission.';
            type: 'string';
          };
        };
        required: ['type'];
        type: 'object';
      };
      PermissionScheme: {
        additionalProperties: true;
        description: 'Details of a permission scheme.';
        properties: {
          description: {
            description: 'A description for the permission scheme.';
            type: 'string';
          };
          expand: {
            description: 'The expand options available for the permission scheme.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the permission scheme.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          name: {
            description: 'The name of the permission scheme. Must be unique.';
            type: 'string';
          };
          permissions: {
            description: 'The permission scheme to create or update. See [About permission schemes and grants](../api-group-permission-schemes/#about-permission-schemes-and-grants) for more information.';
            items: {
              $ref: '#/components/schemas/PermissionGrant';
            };
            type: 'array';
          };
          scope: {
            allOf: [
              {
                $ref: '#/components/schemas/Scope';
              },
            ];
            description: 'The scope of the permission scheme.';
          };
          self: {
            description: 'The URL of the permission scheme.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['name'];
        type: 'object';
      };
      PermissionSchemes: {
        additionalProperties: false;
        description: 'List of all permission schemes.';
        properties: {
          permissionSchemes: {
            description: 'Permission schemes list.';
            items: {
              $ref: '#/components/schemas/PermissionScheme';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      Permissions: {
        additionalProperties: false;
        description: 'Details about permissions.';
        properties: {
          permissions: {
            additionalProperties: {
              $ref: '#/components/schemas/UserPermission';
            };
            description: 'List of permissions.';
            readOnly: true;
            type: 'object';
          };
        };
        type: 'object';
      };
      PermissionsKeysBean: {
        additionalProperties: false;
        properties: {
          permissions: {
            description: 'A list of permission keys.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
        };
        required: ['permissions'];
        type: 'object';
      };
      PermittedProjects: {
        additionalProperties: false;
        description: 'A list of projects in which a user is granted permissions.';
        properties: {
          projects: {
            description: 'A list of projects.';
            items: {
              $ref: '#/components/schemas/ProjectIdentifierBean';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      Priority: {
        additionalProperties: true;
        description: 'An issue priority.';
        properties: {
          avatarId: {
            description: 'The avatarId of the avatar for the issue priority. This parameter is nullable and when set, this avatar references the universal avatar APIs.';
            format: 'int64';
            type: 'integer';
          };
          description: {
            description: 'The description of the issue priority.';
            type: 'string';
          };
          iconUrl: {
            description: 'The URL of the icon for the issue priority.';
            type: 'string';
          };
          id: {
            description: 'The ID of the issue priority.';
            type: 'string';
          };
          isDefault: {
            description: 'Whether this priority is the default.';
            type: 'boolean';
          };
          name: {
            description: 'The name of the issue priority.';
            type: 'string';
          };
          schemes: {
            allOf: [
              {
                $ref: '#/components/schemas/ExpandPrioritySchemePage';
              },
            ];
            description: 'Priority schemes associated with the issue priority.';
          };
          self: {
            description: 'The URL of the issue priority.';
            type: 'string';
          };
          statusColor: {
            description: 'The color used to indicate the issue priority.';
            type: 'string';
          };
        };
        type: 'object';
      };
      PriorityId: {
        additionalProperties: true;
        description: 'The ID of an issue priority.';
        properties: {
          id: {
            description: 'The ID of the issue priority.';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['id'];
        type: 'object';
      };
      PriorityMapping: {
        additionalProperties: false;
        description: 'Mapping of issue priorities for changes in priority schemes.';
        properties: {
          in: {
            additionalProperties: {
              format: 'int64';
              type: 'integer';
              writeOnly: true;
            };
            description: 'The mapping of priorities for issues being migrated **into** this priority scheme. Key is the old priority ID, value is the new priority ID (must exist in this priority scheme).';
            type: 'object';
            writeOnly: true;
          };
          out: {
            additionalProperties: {
              format: 'int64';
              type: 'integer';
              writeOnly: true;
            };
            description: 'The mapping of priorities for issues being migrated **out of** this priority scheme. Key is the old priority ID (must exist in this priority scheme), value is the new priority ID (must exist in the default priority scheme). Required for updating an existing priority scheme. Not used when creating a new priority scheme.';
            type: 'object';
            writeOnly: true;
          };
        };
        type: 'object';
        writeOnly: true;
      };
      PrioritySchemeChangesWithMappings: {
        additionalProperties: false;
        properties: {
          ids: {
            description: 'Affected entity ids.';
            items: {
              format: 'int64';
              type: 'integer';
              writeOnly: true;
            };
            type: 'array';
            writeOnly: true;
          };
          mappings: {
            description: 'Instructions to migrate issues.';
            items: {
              $ref: '#/components/schemas/PriorityMapping';
            };
            type: 'array';
            writeOnly: true;
          };
        };
        required: ['ids'];
        type: 'object';
        writeOnly: true;
      };
      PrioritySchemeChangesWithoutMappings: {
        additionalProperties: false;
        properties: {
          ids: {
            description: 'Affected entity ids.';
            items: {
              format: 'int64';
              type: 'integer';
              writeOnly: true;
            };
            type: 'array';
            writeOnly: true;
          };
        };
        required: ['ids'];
        type: 'object';
        writeOnly: true;
      };
      PrioritySchemeId: {
        additionalProperties: false;
        description: 'The ID of a priority scheme.';
        properties: {
          id: {
            description: 'The ID of the priority scheme.';
            readOnly: true;
            type: 'string';
          };
          task: {
            allOf: [
              {
                $ref: '#/components/schemas/TaskProgressBeanJsonNode';
              },
            ];
            description: 'The in-progress issue migration task.';
            readOnly: true;
          };
        };
        type: 'object';
      };
      PrioritySchemeWithPaginatedPrioritiesAndProjects: {
        additionalProperties: true;
        description: 'A priority scheme with paginated priorities and projects.';
        properties: {
          default: {
            type: 'boolean';
          };
          defaultPriorityId: {
            description: 'The ID of the default issue priority.';
            type: 'string';
          };
          description: {
            description: 'The description of the priority scheme';
            type: 'string';
          };
          id: {
            description: 'The ID of the priority scheme.';
            type: 'string';
          };
          isDefault: {
            type: 'boolean';
            writeOnly: true;
          };
          name: {
            description: 'The name of the priority scheme';
            type: 'string';
          };
          priorities: {
            allOf: [
              {
                $ref: '#/components/schemas/PageBeanPriorityWithSequence';
              },
            ];
            description: 'The paginated list of priorities.';
          };
          projects: {
            allOf: [
              {
                $ref: '#/components/schemas/PageBeanProjectDetails';
              },
            ];
            description: 'The paginated list of projects.';
          };
          self: {
            description: 'The URL of the priority scheme.';
            type: 'string';
          };
        };
        required: ['id', 'name'];
        type: 'object';
      };
      PriorityWithSequence: {
        additionalProperties: false;
        description: 'An issue priority with sequence information.';
        properties: {
          description: {
            description: 'The description of the issue priority.';
            type: 'string';
          };
          iconUrl: {
            description: 'The URL of the icon for the issue priority.';
            type: 'string';
          };
          id: {
            description: 'The ID of the issue priority.';
            type: 'string';
          };
          isDefault: {
            description: 'Whether this priority is the default.';
            type: 'boolean';
          };
          name: {
            description: 'The name of the issue priority.';
            type: 'string';
          };
          self: {
            description: 'The URL of the issue priority.';
            type: 'string';
          };
          sequence: {
            description: 'The sequence of the issue priority.';
            type: 'string';
          };
          statusColor: {
            description: 'The color used to indicate the issue priority.';
            type: 'string';
          };
        };
        type: 'object';
      };
      Project: {
        additionalProperties: false;
        description: 'Details about a project.';
        properties: {
          archived: {
            description: 'Whether the project is archived.';
            readOnly: true;
            type: 'boolean';
          };
          archivedBy: {
            allOf: [
              {
                $ref: '#/components/schemas/User';
              },
            ];
            description: 'The user who archived the project.';
            readOnly: true;
          };
          archivedDate: {
            description: 'The date when the project was archived.';
            format: 'date-time';
            readOnly: true;
            type: 'string';
          };
          assigneeType: {
            description: 'The default assignee when creating issues for this project.';
            enum: ['PROJECT_LEAD', 'UNASSIGNED'];
            readOnly: true;
            type: 'string';
          };
          avatarUrls: {
            allOf: [
              {
                $ref: '#/components/schemas/AvatarUrlsBean';
              },
            ];
            description: "The URLs of the project's avatars.";
            readOnly: true;
          };
          components: {
            description: 'List of the components contained in the project.';
            items: {
              $ref: '#/components/schemas/ProjectComponent';
            };
            readOnly: true;
            type: 'array';
          };
          deleted: {
            description: 'Whether the project is marked as deleted.';
            readOnly: true;
            type: 'boolean';
          };
          deletedBy: {
            allOf: [
              {
                $ref: '#/components/schemas/User';
              },
            ];
            description: 'The user who marked the project as deleted.';
            readOnly: true;
          };
          deletedDate: {
            description: 'The date when the project was marked as deleted.';
            format: 'date-time';
            readOnly: true;
            type: 'string';
          };
          description: {
            description: 'A brief description of the project.';
            readOnly: true;
            type: 'string';
          };
          email: {
            description: 'An email address associated with the project.';
            type: 'string';
          };
          expand: {
            description: 'Expand options that include additional project details in the response.';
            readOnly: true;
            type: 'string';
            xml: {
              attribute: true;
            };
          };
          favourite: {
            description: 'Whether the project is selected as a favorite.';
            type: 'boolean';
          };
          id: {
            description: 'The ID of the project.';
            type: 'string';
          };
          insight: {
            allOf: [
              {
                $ref: '#/components/schemas/ProjectInsight';
              },
            ];
            description: 'Insights about the project.';
            readOnly: true;
          };
          isPrivate: {
            description: "Whether the project is private from the user's perspective. This means the user can't see the project or any associated issues.";
            readOnly: true;
            type: 'boolean';
          };
          issueTypeHierarchy: {
            allOf: [
              {
                $ref: '#/components/schemas/Hierarchy';
              },
            ];
            description: 'The issue type hierarchy for the project.';
            readOnly: true;
          };
          issueTypes: {
            description: 'List of the issue types available in the project.';
            items: {
              $ref: '#/components/schemas/IssueTypeDetails';
            };
            readOnly: true;
            type: 'array';
          };
          key: {
            description: 'The key of the project.';
            readOnly: true;
            type: 'string';
          };
          landingPageInfo: {
            allOf: [
              {
                $ref: '#/components/schemas/ProjectLandingPageInfo';
              },
            ];
            description: 'The project landing page info.';
            readOnly: true;
          };
          lead: {
            allOf: [
              {
                $ref: '#/components/schemas/User';
              },
            ];
            description: 'The username of the project lead.';
            readOnly: true;
          };
          name: {
            description: 'The name of the project.';
            readOnly: true;
            type: 'string';
          };
          permissions: {
            allOf: [
              {
                $ref: '#/components/schemas/ProjectPermissions';
              },
            ];
            description: 'User permissions on the project';
            readOnly: true;
          };
          projectCategory: {
            allOf: [
              {
                $ref: '#/components/schemas/ProjectCategory';
              },
            ];
            description: 'The category the project belongs to.';
            readOnly: true;
          };
          projectTypeKey: {
            description: 'The [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes) of the project.';
            enum: ['software', 'service_desk', 'business'];
            readOnly: true;
            type: 'string';
          };
          properties: {
            additionalProperties: {
              readOnly: true;
            };
            description: 'Map of project properties';
            readOnly: true;
            type: 'object';
          };
          retentionTillDate: {
            description: 'The date when the project is deleted permanently.';
            format: 'date-time';
            readOnly: true;
            type: 'string';
          };
          roles: {
            additionalProperties: {
              format: 'uri';
              readOnly: true;
              type: 'string';
            };
            description: 'The name and self URL for each role defined in the project. For more information, see [Create project role](#api-rest-api-3-role-post).';
            readOnly: true;
            type: 'object';
          };
          self: {
            description: 'The URL of the project details.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          simplified: {
            description: 'Whether the project is simplified.';
            readOnly: true;
            type: 'boolean';
          };
          style: {
            description: 'The type of the project.';
            enum: ['classic', 'next-gen'];
            readOnly: true;
            type: 'string';
          };
          url: {
            description: 'A link to information about this project, such as project documentation.';
            readOnly: true;
            type: 'string';
          };
          uuid: {
            description: 'Unique ID for next-gen projects.';
            format: 'uuid';
            readOnly: true;
            type: 'string';
          };
          versions: {
            description: 'The versions defined in the project. For more information, see [Create version](#api-rest-api-3-version-post).';
            items: {
              $ref: '#/components/schemas/Version';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
        xml: {
          name: 'project';
        };
      };
      ProjectAndIssueTypePair: {
        additionalProperties: false;
        description: 'A project and issueType ID pair that identifies a status mapping.';
        properties: {
          issueTypeId: {
            description: 'The ID of the issue type.';
            type: 'string';
          };
          projectId: {
            description: 'The ID of the project.';
            type: 'string';
          };
        };
        required: ['issueTypeId', 'projectId'];
        type: 'object';
      };
      ProjectAvatars: {
        additionalProperties: false;
        description: 'List of project avatars.';
        properties: {
          custom: {
            description: 'List of avatars added to Jira. These avatars may be deleted.';
            items: {
              $ref: '#/components/schemas/Avatar';
            };
            readOnly: true;
            type: 'array';
          };
          system: {
            description: 'List of avatars included with Jira. These avatars cannot be deleted.';
            items: {
              $ref: '#/components/schemas/Avatar';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      ProjectCategory: {
        additionalProperties: false;
        description: 'A project category.';
        properties: {
          description: {
            description: 'The description of the project category.';
            type: 'string';
          };
          id: {
            description: 'The ID of the project category.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The name of the project category. Required on create, optional on update.';
            type: 'string';
          };
          self: {
            description: 'The URL of the project category.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      ProjectComponent: {
        additionalProperties: false;
        description: 'Details about a project component.';
        properties: {
          ari: {
            description: "Compass component's ID. Can't be updated. Not required for creating a Project Component.";
            readOnly: true;
            type: 'string';
          };
          assignee: {
            allOf: [
              {
                $ref: '#/components/schemas/User';
              },
            ];
            description: 'The details of the user associated with `assigneeType`, if any. See `realAssignee` for details of the user assigned to issues created with this component.';
            readOnly: true;
          };
          assigneeType: {
            description: 'The nominal user type used to determine the assignee for issues created with this component. See `realAssigneeType` for details on how the type of the user, and hence the user, assigned to issues is determined. Can take the following values:\n\n *  `PROJECT_LEAD` the assignee to any issues created with this component is nominally the lead for the project the component is in.\n *  `COMPONENT_LEAD` the assignee to any issues created with this component is nominally the lead for the component.\n *  `UNASSIGNED` an assignee is not set for issues created with this component.\n *  `PROJECT_DEFAULT` the assignee to any issues created with this component is nominally the default assignee for the project that the component is in.\n\nDefault value: `PROJECT_DEFAULT`.  \nOptional when creating or updating a component.';
            enum: ['PROJECT_DEFAULT', 'COMPONENT_LEAD', 'PROJECT_LEAD', 'UNASSIGNED'];
            type: 'string';
          };
          description: {
            description: 'The description for the component. Optional when creating or updating a component.';
            type: 'string';
          };
          id: {
            description: 'The unique identifier for the component.';
            readOnly: true;
            type: 'string';
          };
          isAssigneeTypeValid: {
            description: 'Whether a user is associated with `assigneeType`. For example, if the `assigneeType` is set to `COMPONENT_LEAD` but the component lead is not set, then `false` is returned.';
            readOnly: true;
            type: 'boolean';
          };
          lead: {
            allOf: [
              {
                $ref: '#/components/schemas/User';
              },
            ];
            description: "The user details for the component's lead user.";
            readOnly: true;
          };
          leadAccountId: {
            description: "The accountId of the component's lead user. The accountId uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.";
            maxLength: 128;
            type: 'string';
            writeOnly: true;
          };
          leadUserName: {
            description: 'This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.';
            type: 'string';
          };
          metadata: {
            additionalProperties: {
              readOnly: true;
              type: 'string';
            };
            description: "Compass component's metadata. Can't be updated. Not required for creating a Project Component.";
            readOnly: true;
            type: 'object';
          };
          name: {
            description: 'The unique name for the component in the project. Required when creating a component. Optional when updating a component. The maximum length is 255 characters.';
            type: 'string';
          };
          project: {
            description: "The key of the project the component is assigned to. Required when creating a component. Can't be updated.";
            type: 'string';
          };
          projectId: {
            description: 'The ID of the project the component is assigned to.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          realAssignee: {
            allOf: [
              {
                $ref: '#/components/schemas/User';
              },
            ];
            description: 'The user assigned to issues created with this component, when `assigneeType` does not identify a valid assignee.';
            readOnly: true;
          };
          realAssigneeType: {
            description: 'The type of the assignee that is assigned to issues created with this component, when an assignee cannot be set from the `assigneeType`. For example, `assigneeType` is set to `COMPONENT_LEAD` but no component lead is set. This property is set to one of the following values:\n\n *  `PROJECT_LEAD` when `assigneeType` is `PROJECT_LEAD` and the project lead has permission to be assigned issues in the project that the component is in.\n *  `COMPONENT_LEAD` when `assignee`Type is `COMPONENT_LEAD` and the component lead has permission to be assigned issues in the project that the component is in.\n *  `UNASSIGNED` when `assigneeType` is `UNASSIGNED` and Jira is configured to allow unassigned issues.\n *  `PROJECT_DEFAULT` when none of the preceding cases are true.';
            enum: ['PROJECT_DEFAULT', 'COMPONENT_LEAD', 'PROJECT_LEAD', 'UNASSIGNED'];
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the component.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
        xml: {
          name: 'component';
        };
      };
      ProjectDataPolicies: {
        additionalProperties: false;
        description: 'Details about data policies for a list of projects.';
        properties: {
          projectDataPolicies: {
            description: 'List of projects with data policies.';
            items: {
              $ref: '#/components/schemas/ProjectWithDataPolicy';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      ProjectDataPolicy: {
        additionalProperties: false;
        description: 'Details about data policy.';
        properties: {
          anyContentBlocked: {
            description: 'Whether the project contains any content inaccessible to the requesting application.';
            readOnly: true;
            type: 'boolean';
          };
        };
        type: 'object';
      };
      ProjectDetails: {
        additionalProperties: false;
        description: 'Details about a project.';
        properties: {
          avatarUrls: {
            allOf: [
              {
                $ref: '#/components/schemas/AvatarUrlsBean';
              },
            ];
            description: "The URLs of the project's avatars.";
            readOnly: true;
          };
          id: {
            description: 'The ID of the project.';
            type: 'string';
          };
          key: {
            description: 'The key of the project.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The name of the project.';
            readOnly: true;
            type: 'string';
          };
          projectCategory: {
            allOf: [
              {
                $ref: '#/components/schemas/UpdatedProjectCategory';
              },
            ];
            description: 'The category the project belongs to.';
            readOnly: true;
          };
          projectTypeKey: {
            description: 'The [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes) of the project.';
            enum: ['software', 'service_desk', 'business'];
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the project details.';
            readOnly: true;
            type: 'string';
          };
          simplified: {
            description: 'Whether or not the project is simplified.';
            readOnly: true;
            type: 'boolean';
          };
        };
        type: 'object';
      };
      ProjectEmailAddress: {
        additionalProperties: false;
        description: "A project's sender email address.";
        properties: {
          emailAddress: {
            description: 'The email address.';
            type: 'string';
          };
          emailAddressStatus: {
            description: 'When using a custom domain, the status of the email address.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      ProjectFeature: {
        additionalProperties: false;
        description: 'Details of a project feature.';
        properties: {
          feature: {
            description: 'The key of the feature.';
            type: 'string';
          };
          imageUri: {
            description: 'URI for the image representing the feature.';
            type: 'string';
          };
          localisedDescription: {
            description: 'Localized display description for the feature.';
            type: 'string';
          };
          localisedName: {
            description: 'Localized display name for the feature.';
            type: 'string';
          };
          prerequisites: {
            description: 'List of keys of the features required to enable the feature.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          projectId: {
            description: 'The ID of the project.';
            format: 'int64';
            type: 'integer';
          };
          state: {
            description: 'The state of the feature. When updating the state of a feature, only ENABLED and DISABLED are supported. Responses can contain all values';
            enum: ['ENABLED', 'DISABLED', 'COMING_SOON'];
            type: 'string';
          };
          toggleLocked: {
            description: 'Whether the state of the feature can be updated.';
            type: 'boolean';
          };
        };
        type: 'object';
      };
      ProjectFeatureState: {
        additionalProperties: false;
        description: 'Details of the feature state.';
        properties: {
          state: {
            description: 'The feature state.';
            enum: ['ENABLED', 'DISABLED', 'COMING_SOON'];
            type: 'string';
          };
        };
        type: 'object';
      };
      ProjectId: {
        additionalProperties: false;
        description: 'Project ID details.';
        nullable: true;
        properties: {
          id: {
            description: 'The ID of the project.';
            type: 'string';
          };
        };
        required: ['id'];
        type: 'object';
      };
      ProjectIdentifierBean: {
        additionalProperties: false;
        description: 'The identifiers for a project.';
        properties: {
          id: {
            description: 'The ID of the project.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          key: {
            description: 'The key of the project.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      ProjectIdentifiers: {
        additionalProperties: false;
        description: 'Identifiers for a project.';
        properties: {
          id: {
            description: 'The ID of the created project.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          key: {
            description: 'The key of the created project.';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the created project.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['id', 'key', 'self'];
        type: 'object';
      };
      ProjectIds: {
        additionalProperties: false;
        description: 'A list of project IDs.';
        properties: {
          projectIds: {
            description: 'The IDs of projects.';
            items: {
              type: 'string';
              writeOnly: true;
            };
            type: 'array';
            writeOnly: true;
          };
        };
        required: ['projectIds'];
        type: 'object';
      };
      ProjectInsight: {
        additionalProperties: false;
        description: 'Additional details about a project.';
        properties: {
          lastIssueUpdateTime: {
            description: 'The last issue update time.';
            format: 'date-time';
            readOnly: true;
            type: 'string';
          };
          totalIssueCount: {
            description: 'Total issue count.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
        };
        type: 'object';
      };
      ProjectIssueCreateMetadata: {
        additionalProperties: false;
        description: 'Details of the issue creation metadata for a project.';
        properties: {
          avatarUrls: {
            allOf: [
              {
                $ref: '#/components/schemas/AvatarUrlsBean';
              },
            ];
            description: "List of the project's avatars, returning the avatar size and associated URL.";
            readOnly: true;
          };
          expand: {
            description: 'Expand options that include additional project issue create metadata details in the response.';
            readOnly: true;
            type: 'string';
            xml: {
              attribute: true;
            };
          };
          id: {
            description: 'The ID of the project.';
            readOnly: true;
            type: 'string';
          };
          issuetypes: {
            description: 'List of the issue types supported by the project.';
            items: {
              $ref: '#/components/schemas/IssueTypeIssueCreateMetadata';
            };
            readOnly: true;
            type: 'array';
          };
          key: {
            description: 'The key of the project.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The name of the project.';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the project.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      ProjectIssueSecurityLevels: {
        additionalProperties: false;
        description: 'List of issue level security items in a project.';
        properties: {
          levels: {
            description: 'Issue level security items list.';
            items: {
              $ref: '#/components/schemas/SecurityLevel';
            };
            readOnly: true;
            type: 'array';
          };
        };
        required: ['levels'];
        type: 'object';
      };
      ProjectIssueTypeHierarchy: {
        additionalProperties: false;
        description: 'The hierarchy of issue types within a project.';
        properties: {
          hierarchy: {
            description: 'Details of an issue type hierarchy level.';
            items: {
              $ref: '#/components/schemas/ProjectIssueTypesHierarchyLevel';
            };
            readOnly: true;
            type: 'array';
          };
          projectId: {
            description: 'The ID of the project.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
        };
        type: 'object';
      };
      ProjectIssueTypeMapping: {
        additionalProperties: false;
        description: 'The project and issue type mapping.';
        properties: {
          issueTypeId: {
            description: 'The ID of the issue type.';
            type: 'string';
            writeOnly: true;
          };
          projectId: {
            description: 'The ID of the project.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['issueTypeId', 'projectId'];
        type: 'object';
        writeOnly: true;
      };
      ProjectIssueTypeMappings: {
        additionalProperties: false;
        description: 'The project and issue type mappings.';
        properties: {
          mappings: {
            description: 'The project and issue type mappings.';
            items: {
              $ref: '#/components/schemas/ProjectIssueTypeMapping';
            };
            type: 'array';
            writeOnly: true;
          };
        };
        required: ['mappings'];
        type: 'object';
      };
      ProjectIssueTypes: {
        additionalProperties: false;
        description: 'Use the optional `workflows.usages` expand to get additional information about the projects and issue types associated with the requested workflows.';
        properties: {
          issueTypes: {
            description: 'IDs of the issue types';
            items: {
              description: 'IDs of the issue types';
              nullable: true;
              type: 'string';
            };
            nullable: true;
            type: 'array';
            uniqueItems: true;
          };
          project: {
            $ref: '#/components/schemas/ProjectId';
          };
        };
        type: 'object';
      };
      ProjectIssueTypesHierarchyLevel: {
        additionalProperties: false;
        description: 'Details of an issue type hierarchy level.';
        properties: {
          entityId: {
            description: 'The ID of the issue type hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).';
            format: 'uuid';
            readOnly: true;
            type: 'string';
          };
          issueTypes: {
            description: 'The list of issue types in the hierarchy level.';
            items: {
              $ref: '#/components/schemas/IssueTypeInfo';
            };
            readOnly: true;
            type: 'array';
          };
          level: {
            description: 'The level of the issue type hierarchy level.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          name: {
            description: 'The name of the issue type hierarchy level.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      ProjectLandingPageInfo: {
        additionalProperties: false;
        properties: {
          attributes: {
            additionalProperties: {
              type: 'string';
            };
            type: 'object';
          };
          boardId: {
            format: 'int64';
            type: 'integer';
          };
          boardName: {
            type: 'string';
          };
          projectKey: {
            type: 'string';
          };
          projectType: {
            type: 'string';
          };
          queueCategory: {
            type: 'string';
          };
          queueId: {
            format: 'int64';
            type: 'integer';
          };
          queueName: {
            type: 'string';
          };
          simpleBoard: {
            type: 'boolean';
          };
          simplified: {
            type: 'boolean';
          };
          url: {
            type: 'string';
          };
        };
        type: 'object';
      };
      ProjectPermissions: {
        additionalProperties: false;
        description: 'Permissions which a user has on a project.';
        properties: {
          canEdit: {
            description: 'Whether the logged user can edit the project.';
            readOnly: true;
            type: 'boolean';
          };
        };
        type: 'object';
      };
      ProjectRole: {
        additionalProperties: false;
        description: 'Details about the roles in a project.';
        properties: {
          actors: {
            description: 'The list of users who act in this role.';
            items: {
              $ref: '#/components/schemas/RoleActor';
            };
            readOnly: true;
            type: 'array';
          };
          admin: {
            description: 'Whether this role is the admin role for the project.';
            readOnly: true;
            type: 'boolean';
          };
          currentUserRole: {
            description: 'Whether the calling user is part of this role.';
            type: 'boolean';
          };
          default: {
            description: 'Whether this role is the default role for the project';
            readOnly: true;
            type: 'boolean';
          };
          description: {
            description: 'The description of the project role.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the project role.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          name: {
            description: 'The name of the project role.';
            type: 'string';
          };
          roleConfigurable: {
            description: 'Whether the roles are configurable for this project.';
            readOnly: true;
            type: 'boolean';
          };
          scope: {
            allOf: [
              {
                $ref: '#/components/schemas/Scope';
              },
            ];
            description: 'The scope of the role. Indicated for roles associated with [next-gen projects](https://confluence.atlassian.com/x/loMyO).';
            readOnly: true;
          };
          self: {
            description: 'The URL the project role details.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          translatedName: {
            description: 'The translated name of the project role.';
            type: 'string';
          };
        };
        type: 'object';
      };
      ProjectRoleActorsUpdateBean: {
        additionalProperties: false;
        properties: {
          categorisedActors: {
            additionalProperties: {
              items: {
                type: 'string';
              };
              type: 'array';
            };
            description: 'The actors to add to the project role.\n\nAdd groups using:\n\n *  `atlassian-group-role-actor` and a list of group names.\n *  `atlassian-group-role-actor-id` and a list of group IDs.\n\nAs a group\'s name can change, use of `atlassian-group-role-actor-id` is recommended. For example, `"atlassian-group-role-actor-id":["eef79f81-0b89-4fca-a736-4be531a10869","77f6ab39-e755-4570-a6ae-2d7a8df0bcb8"]`.\n\nAdd users using `atlassian-user-role-actor` and a list of account IDs. For example, `"atlassian-user-role-actor":["12345678-9abc-def1-2345-6789abcdef12", "abcdef12-3456-789a-bcde-f123456789ab"]`.';
            type: 'object';
          };
          id: {
            description: 'The ID of the project role. Use [Get all project roles](#api-rest-api-3-role-get) to get a list of project role IDs.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
        };
        type: 'object';
        xml: {
          name: 'actor';
        };
      };
      ProjectRoleDetails: {
        additionalProperties: false;
        description: 'Details about a project role.';
        properties: {
          admin: {
            description: 'Whether this role is the admin role for the project.';
            readOnly: true;
            type: 'boolean';
          };
          default: {
            description: 'Whether this role is the default role for the project.';
            readOnly: true;
            type: 'boolean';
          };
          description: {
            description: 'The description of the project role.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the project role.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          name: {
            description: 'The name of the project role.';
            type: 'string';
          };
          roleConfigurable: {
            description: 'Whether the roles are configurable for this project.';
            readOnly: true;
            type: 'boolean';
          };
          scope: {
            allOf: [
              {
                $ref: '#/components/schemas/Scope';
              },
            ];
            description: 'The scope of the role. Indicated for roles associated with [next-gen projects](https://confluence.atlassian.com/x/loMyO).';
            readOnly: true;
          };
          self: {
            description: 'The URL the project role details.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          translatedName: {
            description: 'The translated name of the project role.';
            type: 'string';
          };
        };
        type: 'object';
      };
      ProjectRoleGroup: {
        additionalProperties: false;
        description: 'Details of the group associated with the role.';
        properties: {
          displayName: {
            description: 'The display name of the group.';
            type: 'string';
          };
          groupId: {
            description: 'The ID of the group.';
            type: 'string';
          };
          name: {
            description: "The name of the group. As a group's name can change, use of `groupId` is recommended to identify the group.";
            type: 'string';
          };
        };
        type: 'object';
      };
      ProjectRoleUser: {
        additionalProperties: false;
        description: 'Details of the user associated with the role.';
        properties: {
          accountId: {
            description: 'The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*. Returns *unknown* if the record is deleted and corrupted, for example, as the result of a server import.';
            maxLength: 128;
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      ProjectScopeBean: {
        additionalProperties: false;
        properties: {
          attributes: {
            description: "Defines the behavior of the option in the project.If notSelectable is set, the option cannot be set as the field's value. This is useful for archiving an option that has previously been selected but shouldn't be used anymore.If defaultValue is set, the option is selected by default.";
            items: {
              enum: ['notSelectable', 'defaultValue'];
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          id: {
            description: "The ID of the project that the option's behavior applies to.";
            format: 'int64';
            type: 'integer';
          };
        };
        type: 'object';
      };
      ProjectType: {
        additionalProperties: false;
        description: 'Details about a project type.';
        properties: {
          color: {
            description: 'The color of the project type.';
            readOnly: true;
            type: 'string';
          };
          descriptionI18nKey: {
            description: "The key of the project type's description.";
            readOnly: true;
            type: 'string';
          };
          formattedKey: {
            description: 'The formatted key of the project type.';
            readOnly: true;
            type: 'string';
          };
          icon: {
            description: 'The icon of the project type.';
            readOnly: true;
            type: 'string';
          };
          key: {
            description: 'The key of the project type.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      ProjectWithDataPolicy: {
        additionalProperties: false;
        description: 'Details about data policies for a project.';
        properties: {
          dataPolicy: {
            allOf: [
              {
                $ref: '#/components/schemas/ProjectDataPolicy';
              },
            ];
            description: 'Data policy.';
            readOnly: true;
          };
          id: {
            description: 'The project ID.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
        };
        type: 'object';
      };
      PropertyKey: {
        additionalProperties: false;
        description: 'Property key details.';
        properties: {
          key: {
            description: 'The key of the property.';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the property.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      PropertyKeys: {
        additionalProperties: false;
        description: 'List of property keys.';
        properties: {
          keys: {
            description: 'Property key details.';
            items: {
              $ref: '#/components/schemas/PropertyKey';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      PublishDraftWorkflowScheme: {
        additionalProperties: false;
        description: 'Details about the status mappings for publishing a draft workflow scheme.';
        properties: {
          statusMappings: {
            description: 'Mappings of statuses to new statuses for issue types.';
            items: {
              $ref: '#/components/schemas/StatusMapping';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        type: 'object';
      };
      PublishedWorkflowId: {
        additionalProperties: false;
        description: 'Properties that identify a published workflow.';
        properties: {
          entityId: {
            description: 'The entity ID of the workflow.';
            type: 'string';
          };
          name: {
            description: 'The name of the workflow.';
            type: 'string';
          };
        };
        required: ['name'];
        type: 'object';
      };
      RegisteredWebhook: {
        additionalProperties: false;
        description: "ID of a registered webhook or error messages explaining why a webhook wasn't registered.";
        properties: {
          createdWebhookId: {
            description: 'The ID of the webhook. Returned if the webhook is created.';
            format: 'int64';
            type: 'integer';
          };
          errors: {
            description: 'Error messages specifying why the webhook creation failed.';
            items: {
              description: 'Error messages specifying why the webhook creation failed.';
              type: 'string';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      RemoteIssueLink: {
        additionalProperties: false;
        description: 'Details of an issue remote link.';
        properties: {
          application: {
            allOf: [
              {
                $ref: '#/components/schemas/Application';
              },
            ];
            description: 'Details of the remote application the linked item is in.';
          };
          globalId: {
            description: 'The global ID of the link, such as the ID of the item on the remote system.';
            type: 'string';
          };
          id: {
            description: 'The ID of the link.';
            format: 'int64';
            type: 'integer';
          };
          object: {
            allOf: [
              {
                $ref: '#/components/schemas/RemoteObject';
              },
            ];
            description: 'Details of the item linked to.';
          };
          relationship: {
            description: 'Description of the relationship between the issue and the linked item.';
            type: 'string';
          };
          self: {
            description: 'The URL of the link.';
            format: 'uri';
            type: 'string';
          };
        };
        type: 'object';
      };
      RemoteIssueLinkIdentifies: {
        additionalProperties: false;
        description: 'Details of the identifiers for a created or updated remote issue link.';
        properties: {
          id: {
            description: 'The ID of the remote issue link, such as the ID of the item on the remote system.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
            xml: {
              attribute: true;
            };
          };
          self: {
            description: 'The URL of the remote issue link.';
            readOnly: true;
            type: 'string';
            xml: {
              attribute: true;
            };
          };
        };
        type: 'object';
      };
      RemoteIssueLinkRequest: {
        additionalProperties: true;
        description: 'Details of a remote issue link.';
        properties: {
          application: {
            allOf: [
              {
                $ref: '#/components/schemas/Application';
              },
            ];
            description: 'Details of the remote application the linked item is in. For example, trello.';
          };
          globalId: {
            description: "An identifier for the remote item in the remote system. For example, the global ID for a remote item in Confluence would consist of the app ID and page ID, like this: `appId=456&pageId=123`.\n\nSetting this field enables the remote issue link details to be updated or deleted using remote system and item details as the record identifier, rather than using the record's Jira ID.\n\nThe maximum length is 255 characters.";
            type: 'string';
          };
          object: {
            allOf: [
              {
                $ref: '#/components/schemas/RemoteObject';
              },
            ];
            description: 'Details of the item linked to.';
          };
          relationship: {
            description: 'Description of the relationship between the issue and the linked item. If not set, the relationship description "links to" is used in Jira.';
            type: 'string';
          };
        };
        required: ['object'];
        type: 'object';
      };
      RemoteObject: {
        additionalProperties: true;
        description: 'The linked item.';
        properties: {
          icon: {
            allOf: [
              {
                $ref: '#/components/schemas/Icon';
              },
            ];
            description: 'Details of the icon for the item. If no icon is defined, the default link icon is used in Jira.';
          };
          status: {
            allOf: [
              {
                $ref: '#/components/schemas/Status';
              },
            ];
            description: 'The status of the item.';
          };
          summary: {
            description: 'The summary details of the item.';
            type: 'string';
          };
          title: {
            description: 'The title of the item.';
            type: 'string';
          };
          url: {
            description: 'The URL of the item.';
            type: 'string';
          };
        };
        required: ['title', 'url'];
        type: 'object';
      };
      RemoveOptionFromIssuesResult: {
        additionalProperties: false;
        properties: {
          errors: {
            allOf: [
              {
                $ref: '#/components/schemas/SimpleErrorCollection';
              },
            ];
            description: 'A collection of errors related to unchanged issues. The collection size is limited, which means not all errors may be returned.';
          };
          modifiedIssues: {
            description: 'The IDs of the modified issues.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
          };
          unmodifiedIssues: {
            description: 'The IDs of the unchanged issues, those issues where errors prevent modification.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      ReorderIssuePriorities: {
        additionalProperties: false;
        description: 'Change the order of issue priorities.';
        properties: {
          after: {
            description: "The ID of the priority. Required if `position` isn't provided.";
            type: 'string';
            writeOnly: true;
          };
          ids: {
            description: 'The list of issue IDs to be reordered. Cannot contain duplicates nor after ID.';
            items: {
              type: 'string';
              writeOnly: true;
            };
            type: 'array';
            writeOnly: true;
          };
          position: {
            description: "The position for issue priorities to be moved to. Required if `after` isn't provided.";
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['ids'];
        type: 'object';
      };
      ReorderIssueResolutionsRequest: {
        additionalProperties: false;
        description: 'Change the order of issue resolutions.';
        properties: {
          after: {
            description: "The ID of the resolution. Required if `position` isn't provided.";
            type: 'string';
            writeOnly: true;
          };
          ids: {
            description: 'The list of resolution IDs to be reordered. Cannot contain duplicates nor after ID.';
            items: {
              type: 'string';
              writeOnly: true;
            };
            type: 'array';
            writeOnly: true;
          };
          position: {
            description: "The position for issue resolutions to be moved to. Required if `after` isn't provided.";
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['ids'];
        type: 'object';
      };
      RequiredMappingByIssueType: {
        additionalProperties: false;
        description: 'The list of required status mappings by issue type.';
        properties: {
          issueTypeId: {
            description: 'The ID of the issue type.';
            type: 'string';
          };
          statusIds: {
            description: 'The status IDs requiring mapping.';
            items: {
              description: 'The status IDs requiring mapping.';
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        type: 'object';
      };
      RequiredMappingByWorkflows: {
        additionalProperties: false;
        description: 'The list of required status mappings by workflow.';
        properties: {
          sourceWorkflowId: {
            description: 'The ID of the source workflow.';
            type: 'string';
          };
          statusIds: {
            description: 'The status IDs requiring mapping.';
            items: {
              description: 'The status IDs requiring mapping.';
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          targetWorkflowId: {
            description: 'The ID of the target workflow.';
            type: 'string';
          };
        };
        type: 'object';
      };
      Resolution: {
        additionalProperties: false;
        description: 'Details of an issue resolution.';
        properties: {
          description: {
            description: 'The description of the issue resolution.';
            type: 'string';
          };
          id: {
            description: 'The ID of the issue resolution.';
            type: 'string';
          };
          name: {
            description: 'The name of the issue resolution.';
            type: 'string';
          };
          self: {
            description: 'The URL of the issue resolution.';
            format: 'uri';
            type: 'string';
          };
        };
        type: 'object';
        xml: {
          name: 'resolution';
        };
      };
      ResolutionId: {
        additionalProperties: true;
        description: 'The ID of an issue resolution.';
        properties: {
          id: {
            description: 'The ID of the issue resolution.';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['id'];
        type: 'object';
      };
      ResolutionJsonBean: {
        additionalProperties: false;
        properties: {
          default: {
            type: 'boolean';
          };
          description: {
            type: 'string';
          };
          iconUrl: {
            type: 'string';
          };
          id: {
            type: 'string';
          };
          name: {
            type: 'string';
          };
          self: {
            type: 'string';
          };
        };
        type: 'object';
      };
      Resource: {
        additionalProperties: false;
        properties: {
          description: {
            type: 'string';
          };
          file: {
            format: 'binary';
            type: 'string';
          };
          filename: {
            type: 'string';
          };
          inputStream: {
            type: 'object';
          };
          open: {
            type: 'boolean';
          };
          readable: {
            type: 'boolean';
          };
          uri: {
            format: 'uri';
            type: 'string';
          };
          url: {
            format: 'url';
            type: 'string';
          };
        };
        type: 'object';
      };
      RestrictedPermission: {
        additionalProperties: true;
        description: 'Details of the permission.';
        properties: {
          id: {
            description: 'The ID of the permission. Either `id` or `key` must be specified. Use [Get all permissions](#api-rest-api-3-permissions-get) to get the list of permissions.';
            type: 'string';
          };
          key: {
            description: 'The key of the permission. Either `id` or `key` must be specified. Use [Get all permissions](#api-rest-api-3-permissions-get) to get the list of permissions.';
            type: 'string';
          };
        };
        type: 'object';
      };
      RichText: {
        properties: {
          empty: {
            type: 'boolean';
          };
          emptyAdf: {
            type: 'boolean';
          };
          finalised: {
            type: 'boolean';
          };
          valueSet: {
            type: 'boolean';
          };
        };
        type: 'object';
      };
      RoleActor: {
        additionalProperties: false;
        description: 'Details about a user assigned to a project role.';
        properties: {
          actorGroup: {
            allOf: [
              {
                $ref: '#/components/schemas/ProjectRoleGroup';
              },
            ];
            readOnly: true;
          };
          actorUser: {
            allOf: [
              {
                $ref: '#/components/schemas/ProjectRoleUser';
              },
            ];
            readOnly: true;
          };
          avatarUrl: {
            description: 'The avatar of the role actor.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          displayName: {
            description: "The display name of the role actor. For users, depending on the user’s privacy setting, this may return an alternative value for the user's name.";
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the role actor.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          name: {
            description: 'This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.';
            readOnly: true;
            type: 'string';
          };
          type: {
            description: 'The type of role actor.';
            enum: ['atlassian-group-role-actor', 'atlassian-user-role-actor'];
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
        xml: {
          name: 'projectRoleActor';
        };
      };
      RuleConfiguration: {
        additionalProperties: false;
        description: 'A rule configuration.';
        properties: {
          disabled: {
            default: false;
            description: 'Whether the rule is disabled.';
            type: 'boolean';
          };
          tag: {
            description: 'A tag used to filter rules in [Get workflow transition rule configurations](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflow-transition-rules/#api-rest-api-3-workflow-rule-config-get).';
            maxLength: 255;
            type: 'string';
          };
          value: {
            description: 'Configuration of the rule, as it is stored by the Connect or the Forge app on the rule configuration page.';
            type: 'string';
          };
        };
        required: ['value'];
        type: 'object';
      };
      SanitizedJqlQueries: {
        additionalProperties: false;
        description: 'The sanitized JQL queries for the given account IDs.';
        properties: {
          queries: {
            description: 'The list of sanitized JQL queries.';
            items: {
              $ref: '#/components/schemas/SanitizedJqlQuery';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      SanitizedJqlQuery: {
        additionalProperties: false;
        description: 'Details of the sanitized JQL query.';
        properties: {
          accountId: {
            description: 'The account ID of the user for whom sanitization was performed.';
            maxLength: 128;
            nullable: true;
            type: 'string';
          };
          errors: {
            allOf: [
              {
                $ref: '#/components/schemas/ErrorCollection';
              },
            ];
            description: 'The list of errors.';
          };
          initialQuery: {
            description: 'The initial query.';
            type: 'string';
          };
          sanitizedQuery: {
            description: 'The sanitized query, if there were no errors.';
            nullable: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      Scope: {
        additionalProperties: true;
        description: 'The projects the item is associated with. Indicated for items associated with [next-gen projects](https://confluence.atlassian.com/x/loMyO).';
        properties: {
          project: {
            allOf: [
              {
                $ref: '#/components/schemas/ProjectDetails';
              },
            ];
            description: 'The project the item has scope in.';
            readOnly: true;
          };
          type: {
            description: 'The type of scope.';
            enum: ['PROJECT', 'TEMPLATE'];
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      Screen: {
        additionalProperties: false;
        description: 'A screen.';
        properties: {
          description: {
            description: 'The description of the screen.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the screen.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          name: {
            description: 'The name of the screen.';
            readOnly: true;
            type: 'string';
          };
          scope: {
            allOf: [
              {
                $ref: '#/components/schemas/Scope';
              },
            ];
            description: 'The scope of the screen.';
          };
        };
        type: 'object';
      };
      ScreenDetails: {
        additionalProperties: false;
        description: 'Details of a screen.';
        properties: {
          description: {
            description: 'The description of the screen. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the screen. The name must be unique. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['name'];
        type: 'object';
      };
      ScreenScheme: {
        additionalProperties: false;
        description: 'A screen scheme.';
        properties: {
          description: {
            description: 'The description of the screen scheme.';
            type: 'string';
          };
          id: {
            description: 'The ID of the screen scheme.';
            format: 'int64';
            type: 'integer';
          };
          issueTypeScreenSchemes: {
            allOf: [
              {
                $ref: '#/components/schemas/PageBeanIssueTypeScreenScheme';
              },
            ];
            description: 'Details of the issue type screen schemes associated with the screen scheme.';
          };
          name: {
            description: 'The name of the screen scheme.';
            type: 'string';
          };
          screens: {
            allOf: [
              {
                $ref: '#/components/schemas/ScreenTypes';
              },
            ];
            description: 'The IDs of the screens for the screen types of the screen scheme.';
          };
        };
        type: 'object';
      };
      ScreenSchemeDetails: {
        additionalProperties: false;
        description: 'Details of a screen scheme.';
        properties: {
          description: {
            description: 'The description of the screen scheme. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the screen scheme. The name must be unique. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
          screens: {
            allOf: [
              {
                $ref: '#/components/schemas/ScreenTypes';
              },
            ];
            description: 'The IDs of the screens for the screen types of the screen scheme. Only screens used in classic projects are accepted.';
          };
        };
        required: ['name', 'screens'];
        type: 'object';
      };
      ScreenSchemeId: {
        additionalProperties: false;
        description: 'The ID of a screen scheme.';
        properties: {
          id: {
            description: 'The ID of the screen scheme.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
        };
        required: ['id'];
        type: 'object';
      };
      ScreenTypes: {
        additionalProperties: false;
        description: 'The IDs of the screens for the screen types of the screen scheme.';
        properties: {
          create: {
            description: 'The ID of the create screen.';
            format: 'int64';
            type: 'integer';
          };
          default: {
            description: 'The ID of the default screen. Required when creating a screen scheme.';
            format: 'int64';
            type: 'integer';
          };
          edit: {
            description: 'The ID of the edit screen.';
            format: 'int64';
            type: 'integer';
          };
          view: {
            description: 'The ID of the view screen.';
            format: 'int64';
            type: 'integer';
          };
        };
        required: ['default'];
        type: 'object';
        writeOnly: true;
      };
      ScreenWithTab: {
        additionalProperties: false;
        description: 'A screen with tab details.';
        properties: {
          description: {
            description: 'The description of the screen.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the screen.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          name: {
            description: 'The name of the screen.';
            readOnly: true;
            type: 'string';
          };
          scope: {
            allOf: [
              {
                $ref: '#/components/schemas/Scope';
              },
            ];
            description: 'The scope of the screen.';
          };
          tab: {
            allOf: [
              {
                $ref: '#/components/schemas/ScreenableTab';
              },
            ];
            description: 'The tab for the screen.';
          };
        };
        type: 'object';
      };
      ScreenableField: {
        additionalProperties: false;
        description: 'A screen tab field.';
        properties: {
          id: {
            description: 'The ID of the screen tab field.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The name of the screen tab field. Required on create and update. The maximum length is 255 characters.';
            type: 'string';
          };
        };
        type: 'object';
      };
      ScreenableTab: {
        additionalProperties: false;
        description: 'A screen tab.';
        properties: {
          id: {
            description: 'The ID of the screen tab.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          name: {
            description: 'The name of the screen tab. The maximum length is 255 characters.';
            type: 'string';
          };
        };
        required: ['name'];
        type: 'object';
      };
      SearchAndReconcileRequestBean: {
        additionalProperties: false;
        properties: {
          expand: {
            description: 'Use [expand](em>#expansion) to include additional information about issues in the response. Note that, unlike the majority of instances where `expand` is specified, `expand` is defined as a list of values. The expand options are:\n\n *  `renderedFields` Returns field values rendered in HTML format.\n *  `names` Returns the display name of each field.\n *  `schema` Returns the schema describing a field type.\n *  `changelog` Returns a list of recent updates to an issue, sorted by date, starting from the most recent.';
            type: 'string';
          };
          fields: {
            description: 'A list of fields to return for each issue. Use it to retrieve a subset of fields. This parameter accepts a comma-separated list. Expand options include:\n\n *  `*all` Returns all fields.\n *  `*navigable` Returns navigable fields.\n *  `id` Returns only issue IDs.\n *  Any issue field, prefixed with a dash to exclude.\n\nThe default is `id`.\n\nExamples:\n\n *  `summary,comment` Returns the summary and comments fields only.\n *  `*all,-comment` Returns all fields except comments.\n\nMultiple `fields` parameters can be included in a request.\n\nNote: By default, this resource returns IDs only. This differs from [GET issue](#api-rest-api-3-issue-issueIdOrKey-get) where the default is all fields.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          fieldsByKeys: {
            description: 'Reference fields by their key (rather than ID). The default is `false`.';
            type: 'boolean';
          };
          jql: {
            description: 'A [JQL](https://confluence.atlassian.com/x/egORLQ) expression. For performance reasons, this field requires a bounded query. A bounded query is a query with a search restriction.\n\n *  Example of an unbounded query: `order by key desc`.\n *  Example of a bounded query: `assignee = currentUser() order by key`.';
            type: 'string';
          };
          maxResults: {
            default: 50;
            description: 'The maximum number of items to return. Depending on search criteria, real number of items returned may be smaller.';
            format: 'int32';
            type: 'integer';
          };
          nextPageToken: {
            description: 'The continuation token to fetch the next page. This token is provided by the response of this endpoint.';
            type: 'string';
          };
          properties: {
            description: 'A list of up to 5 issue properties to include in the results. This parameter accepts a comma-separated list.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          reconcileIssues: {
            description: 'Strong consistency issue ids to be reconciled with search results. Accepts max 50 ids. All issues must exist.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      SearchAndReconcileResults: {
        additionalProperties: false;
        description: 'The result of a JQL search with issues reconsilation.';
        properties: {
          issues: {
            description: 'The list of issues found by the search or reconsiliation.';
            items: {
              $ref: '#/components/schemas/IssueBean';
            };
            readOnly: true;
            type: 'array';
          };
          names: {
            additionalProperties: {
              readOnly: true;
              type: 'string';
            };
            description: 'The ID and name of each field in the search results.';
            readOnly: true;
            type: 'object';
          };
          nextPageToken: {
            description: 'Continuation token to fetch the next page. If this result represents the last or the only page this token will be null. This token will expire in 7 days.';
            readOnly: true;
            type: 'string';
          };
          schema: {
            additionalProperties: {
              $ref: '#/components/schemas/JsonTypeBean';
            };
            description: 'The schema describing the field types in the search results.';
            readOnly: true;
            type: 'object';
          };
        };
        type: 'object';
      };
      SearchAutoCompleteFilter: {
        additionalProperties: false;
        description: 'Details of how to filter and list search auto complete information.';
        properties: {
          includeCollapsedFields: {
            default: false;
            description: 'Include collapsed fields for fields that have non-unique names.';
            type: 'boolean';
          };
          projectIds: {
            description: 'List of project IDs used to filter the visible field details returned.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      SearchRequestBean: {
        additionalProperties: false;
        properties: {
          expand: {
            description: "Use [expand](em>#expansion) to include additional information about issues in the response. Note that, unlike the majority of instances where `expand` is specified, `expand` is defined as a list of values. The expand options are:\n\n *  `renderedFields` Returns field values rendered in HTML format.\n *  `names` Returns the display name of each field.\n *  `schema` Returns the schema describing a field type.\n *  `transitions` Returns all possible transitions for the issue.\n *  `operations` Returns all possible operations for the issue.\n *  `editmeta` Returns information about how each field can be edited.\n *  `changelog` Returns a list of recent updates to an issue, sorted by date, starting from the most recent.\n *  `versionedRepresentations` Instead of `fields`, returns `versionedRepresentations` a JSON array containing each version of a field's value, with the highest numbered item representing the most recent version.";
            items: {
              type: 'string';
            };
            type: 'array';
          };
          fields: {
            description: 'A list of fields to return for each issue, use it to retrieve a subset of fields. This parameter accepts a comma-separated list. Expand options include:\n\n *  `*all` Returns all fields.\n *  `*navigable` Returns navigable fields.\n *  Any issue field, prefixed with a minus to exclude.\n\nThe default is `*navigable`.\n\nExamples:\n\n *  `summary,comment` Returns the summary and comments fields only.\n *  `-description` Returns all navigable (default) fields except description.\n *  `*all,-comment` Returns all fields except comments.\n\nMultiple `fields` parameters can be included in a request.\n\nNote: All navigable fields are returned by default. This differs from [GET issue](#api-rest-api-3-issue-issueIdOrKey-get) where the default is all fields.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          fieldsByKeys: {
            description: 'Reference fields by their key (rather than ID). The default is `false`.';
            type: 'boolean';
          };
          jql: {
            description: 'A [JQL](https://confluence.atlassian.com/x/egORLQ) expression.';
            type: 'string';
          };
          maxResults: {
            default: 50;
            description: 'The maximum number of items to return per page.';
            format: 'int32';
            type: 'integer';
          };
          properties: {
            description: 'A list of up to 5 issue properties to include in the results. This parameter accepts a comma-separated list.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          startAt: {
            description: 'The index of the first item to return in the page of results (page offset). The base index is `0`.';
            format: 'int32';
            type: 'integer';
          };
          validateQuery: {
            description: 'Determines how to validate the JQL query and treat the validation results. Supported values:\n\n *  `strict` Returns a 400 response code if any errors are found, along with a list of all errors (and warnings).\n *  `warn` Returns all errors as warnings.\n *  `none` No validation is performed.\n *  `true` *Deprecated* A legacy synonym for `strict`.\n *  `false` *Deprecated* A legacy synonym for `warn`.\n\nThe default is `strict`.\n\nNote: If the JQL is not correctly formed a 400 response code is returned, regardless of the `validateQuery` value.';
            enum: ['strict', 'warn', 'none', 'true', 'false'];
            type: 'string';
          };
        };
        type: 'object';
      };
      SearchResults: {
        additionalProperties: false;
        description: 'The result of a JQL search.';
        properties: {
          expand: {
            description: 'Expand options that include additional search result details in the response.';
            readOnly: true;
            type: 'string';
          };
          issues: {
            description: 'The list of issues found by the search.';
            items: {
              $ref: '#/components/schemas/IssueBean';
            };
            readOnly: true;
            type: 'array';
          };
          maxResults: {
            description: 'The maximum number of results that could be on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          names: {
            additionalProperties: {
              readOnly: true;
              type: 'string';
            };
            description: 'The ID and name of each field in the search results.';
            readOnly: true;
            type: 'object';
          };
          schema: {
            additionalProperties: {
              $ref: '#/components/schemas/JsonTypeBean';
            };
            description: 'The schema describing the field types in the search results.';
            readOnly: true;
            type: 'object';
          };
          startAt: {
            description: 'The index of the first item returned on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          total: {
            description: 'The number of results on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          warningMessages: {
            description: 'Any warnings related to the JQL query.';
            items: {
              readOnly: true;
              type: 'string';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      SecurityLevel: {
        additionalProperties: false;
        description: 'Details of an issue level security item.';
        properties: {
          description: {
            description: 'The description of the issue level security item.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the issue level security item.';
            readOnly: true;
            type: 'string';
          };
          isDefault: {
            description: 'Whether the issue level security item is the default.';
            readOnly: true;
            type: 'boolean';
          };
          issueSecuritySchemeId: {
            description: 'The ID of the issue level security scheme.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The name of the issue level security item.';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the issue level security item.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      SecurityLevelMember: {
        additionalProperties: true;
        description: 'Issue security level member.';
        properties: {
          holder: {
            allOf: [
              {
                $ref: '#/components/schemas/PermissionHolder';
              },
            ];
            description: 'The user or group being granted the permission. It consists of a `type` and a type-dependent `parameter`. See [Holder object](../api-group-permission-schemes/#holder-object) in *Get all permission schemes* for more information.';
            readOnly: true;
          };
          id: {
            description: 'The ID of the issue security level member.';
            readOnly: true;
            type: 'string';
          };
          issueSecurityLevelId: {
            description: 'The ID of the issue security level.';
            readOnly: true;
            type: 'string';
          };
          issueSecuritySchemeId: {
            description: 'The ID of the issue security scheme.';
            readOnly: true;
            type: 'string';
          };
          managed: {
            type: 'boolean';
            writeOnly: true;
          };
        };
        required: ['holder', 'id', 'issueSecurityLevelId', 'issueSecuritySchemeId'];
        type: 'object';
      };
      SecurityScheme: {
        additionalProperties: false;
        description: 'Details about a security scheme.';
        properties: {
          defaultSecurityLevelId: {
            description: 'The ID of the default security level.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          description: {
            description: 'The description of the issue security scheme.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the issue security scheme.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          levels: {
            items: {
              $ref: '#/components/schemas/SecurityLevel';
            };
            type: 'array';
          };
          name: {
            description: 'The name of the issue security scheme.';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the issue security scheme.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      SecuritySchemeId: {
        additionalProperties: true;
        description: 'The ID of the issue security scheme.';
        properties: {
          id: {
            description: 'The ID of the issue security scheme.';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['id'];
        type: 'object';
      };
      SecuritySchemeLevelBean: {
        additionalProperties: false;
        properties: {
          description: {
            description: 'The description of the issue security scheme level.';
            maxLength: 4000;
            type: 'string';
            writeOnly: true;
          };
          isDefault: {
            description: 'Specifies whether the level is the default level. False by default.';
            type: 'boolean';
            writeOnly: true;
          };
          members: {
            description: 'The list of level members which should be added to the issue security scheme level.';
            items: {
              $ref: '#/components/schemas/SecuritySchemeLevelMemberBean';
            };
            type: 'array';
            writeOnly: true;
          };
          name: {
            description: 'The name of the issue security scheme level. Must be unique.';
            maxLength: 255;
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['name'];
        type: 'object';
        writeOnly: true;
      };
      SecuritySchemeLevelMemberBean: {
        additionalProperties: false;
        properties: {
          parameter: {
            description: 'The value corresponding to the specified member type.';
            type: 'string';
            writeOnly: true;
          };
          type: {
            description: 'The issue security level member type, e.g `reporter`, `group`, `user`.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['type'];
        type: 'object';
        writeOnly: true;
      };
      SecuritySchemeMembersRequest: {
        additionalProperties: false;
        description: 'Details of issue security scheme level new members.';
        properties: {
          members: {
            description: 'The list of level members which should be added to the issue security scheme level.';
            items: {
              $ref: '#/components/schemas/SecuritySchemeLevelMemberBean';
            };
            type: 'array';
            writeOnly: true;
          };
        };
        required: ['securitySchemeLevelMembers'];
        type: 'object';
      };
      SecuritySchemeWithProjects: {
        additionalProperties: true;
        description: 'Details about an issue security scheme.';
        properties: {
          defaultLevel: {
            description: 'The default level ID of the issue security scheme.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          description: {
            description: 'The description of the issue security scheme.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the issue security scheme.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          name: {
            description: 'The name of the issue security scheme.';
            readOnly: true;
            type: 'string';
          };
          projectIds: {
            description: 'The list of project IDs associated with the issue security scheme.';
            items: {
              format: 'int64';
              readOnly: true;
              type: 'integer';
            };
            readOnly: true;
            type: 'array';
            uniqueItems: true;
          };
          self: {
            description: 'The URL of the issue security scheme.';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['id', 'name', 'self'];
        type: 'object';
      };
      SecuritySchemes: {
        additionalProperties: false;
        description: 'List of security schemes.';
        properties: {
          issueSecuritySchemes: {
            description: 'List of security schemes.';
            items: {
              $ref: '#/components/schemas/SecurityScheme';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      ServerInformation: {
        additionalProperties: false;
        description: 'Details about the Jira instance.';
        properties: {
          baseUrl: {
            description: 'The base URL of the Jira instance.';
            type: 'string';
          };
          buildDate: {
            description: 'The timestamp when the Jira version was built.';
            format: 'date-time';
            type: 'string';
          };
          buildNumber: {
            description: 'The build number of the Jira version.';
            format: 'int32';
            type: 'integer';
          };
          deploymentType: {
            description: 'The type of server deployment. This is always returned as *Cloud*.';
            type: 'string';
          };
          displayUrl: {
            description: 'The display URL of the Jira instance.';
            type: 'string';
          };
          displayUrlConfluence: {
            description: 'The display URL of Confluence.';
            type: 'string';
          };
          displayUrlServicedeskHelpCenter: {
            description: 'The display URL of the Servicedesk Help Center.';
            type: 'string';
          };
          healthChecks: {
            description: 'Jira instance health check results. Deprecated and no longer returned.';
            items: {
              $ref: '#/components/schemas/HealthCheckResult';
            };
            type: 'array';
          };
          scmInfo: {
            description: 'The unique identifier of the Jira version.';
            type: 'string';
          };
          serverTime: {
            description: 'The time in Jira when this request was responded to.';
            format: 'date-time';
            type: 'string';
          };
          serverTimeZone: {
            description: 'The default timezone of the Jira server. In a format known as Olson Time Zones, IANA Time Zones or TZ Database Time Zones.';
            properties: {
              displayName: {
                type: 'string';
              };
              dstsavings: {
                format: 'int32';
                type: 'integer';
              };
              id: {
                type: 'string';
              };
              rawOffset: {
                format: 'int32';
                type: 'integer';
              };
            };
            type: 'object';
          };
          serverTitle: {
            description: 'The name of the Jira instance.';
            type: 'string';
          };
          version: {
            description: 'The version of Jira.';
            type: 'string';
          };
          versionNumbers: {
            description: 'The major, minor, and revision version numbers of the Jira version.';
            items: {
              format: 'int32';
              type: 'integer';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      ServiceManagementNavigationInfo: {
        properties: {
          queueCategory: {
            type: 'string';
          };
          queueId: {
            format: 'int64';
            type: 'integer';
          };
          queueName: {
            type: 'string';
          };
        };
        type: 'object';
      };
      ServiceRegistry: {
        properties: {
          description: {
            description: 'service description';
            nullable: true;
            type: 'string';
          };
          id: {
            description: 'service ID';
            format: 'uuid';
            type: 'string';
          };
          name: {
            description: 'service name';
            type: 'string';
          };
          organizationId: {
            description: 'organization ID';
            type: 'string';
          };
          revision: {
            description: 'service revision';
            type: 'string';
          };
          serviceTier: {
            $ref: '#/components/schemas/ServiceRegistryTier';
          };
        };
        type: 'object';
      };
      ServiceRegistryTier: {
        properties: {
          description: {
            description: 'tier description';
            nullable: true;
            type: 'string';
          };
          id: {
            description: 'tier ID';
            format: 'uuid';
            type: 'string';
          };
          level: {
            description: 'tier level';
            type: 'integer';
          };
          name: {
            description: 'tier name';
            nullable: true;
            type: 'string';
          };
          nameKey: {
            description: 'name key of the tier';
            example: 'service-registry.tier1.name';
            type: 'string';
          };
        };
        type: 'object';
      };
      SetDefaultLevelsRequest: {
        additionalProperties: true;
        description: 'Details of new default levels.';
        properties: {
          defaultValues: {
            description: 'List of objects with issue security scheme ID and new default level ID.';
            items: {
              $ref: '#/components/schemas/DefaultLevelValue';
            };
            maxLength: 1000;
            type: 'array';
            writeOnly: true;
          };
        };
        required: ['defaultValues'];
        type: 'object';
      };
      SetDefaultPriorityRequest: {
        additionalProperties: false;
        description: 'The new default issue priority.';
        properties: {
          id: {
            description: 'The ID of the new default issue priority. Must be an existing ID or null. Setting this to null erases the default priority setting.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['id'];
        type: 'object';
      };
      SetDefaultResolutionRequest: {
        additionalProperties: false;
        description: 'The new default issue resolution.';
        properties: {
          id: {
            description: 'The ID of the new default issue resolution. Must be an existing ID or null. Setting this to null erases the default resolution setting.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['id'];
        type: 'object';
      };
      SharePermission: {
        additionalProperties: false;
        description: 'Details of a share permission for the filter.';
        properties: {
          group: {
            allOf: [
              {
                $ref: '#/components/schemas/GroupName';
              },
            ];
            description: "The group that the filter is shared with. For a request, specify the `groupId` or `name` property for the group. As a group's name can change, use of `groupId` is recommended.";
          };
          id: {
            description: 'The unique identifier of the share permission.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          project: {
            allOf: [
              {
                $ref: '#/components/schemas/Project';
              },
            ];
            description: 'The project that the filter is shared with. This is similar to the project object returned by [Get project](#api-rest-api-3-project-projectIdOrKey-get) but it contains a subset of the properties, which are: `self`, `id`, `key`, `assigneeType`, `name`, `roles`, `avatarUrls`, `projectType`, `simplified`.  \nFor a request, specify the `id` for the project.';
          };
          role: {
            allOf: [
              {
                $ref: '#/components/schemas/ProjectRole';
              },
            ];
            description: 'The project role that the filter is shared with.  \nFor a request, specify the `id` for the role. You must also specify the `project` object and `id` for the project that the role is in.';
          };
          type: {
            description: 'The type of share permission:\n\n *  `user` Shared with a user.\n *  `group` Shared with a group. If set in a request, then specify `sharePermission.group` as well.\n *  `project` Shared with a project. If set in a request, then specify `sharePermission.project` as well.\n *  `projectRole` Share with a project role in a project. This value is not returned in responses. It is used in requests, where it needs to be specify with `projectId` and `projectRoleId`.\n *  `global` Shared globally. If set in a request, no other `sharePermission` properties need to be specified.\n *  `loggedin` Shared with all logged-in users. Note: This value is set in a request by specifying `authenticated` as the `type`.\n *  `project-unknown` Shared with a project that the user does not have access to. Cannot be set in a request.';
            enum: ['user', 'group', 'project', 'projectRole', 'global', 'loggedin', 'authenticated', 'project-unknown'];
            type: 'string';
          };
          user: {
            allOf: [
              {
                $ref: '#/components/schemas/UserBean';
              },
            ];
            description: 'The user account ID that the filter is shared with. For a request, specify the `accountId` property for the user.';
          };
        };
        required: ['type'];
        type: 'object';
      };
      SharePermissionInputBean: {
        additionalProperties: false;
        properties: {
          accountId: {
            description: 'The user account ID that the filter is shared with. For a request, specify the `accountId` property for the user.';
            type: 'string';
          };
          groupId: {
            description: 'The ID of the group, which uniquely identifies the group across all Atlassian products.For example, *952d12c3-5b5b-4d04-bb32-44d383afc4b2*. Cannot be provided with `groupname`.';
            type: 'string';
          };
          groupname: {
            description: 'The name of the group to share the filter with. Set `type` to `group`. Please note that the name of a group is mutable, to reliably identify a group use `groupId`.';
            type: 'string';
          };
          projectId: {
            description: 'The ID of the project to share the filter with. Set `type` to `project`.';
            type: 'string';
          };
          projectRoleId: {
            description: 'The ID of the project role to share the filter with. Set `type` to `projectRole` and the `projectId` for the project that the role is in.';
            type: 'string';
          };
          rights: {
            description: 'The rights for the share permission.';
            format: 'int32';
            type: 'integer';
          };
          type: {
            description: 'The type of the share permission.Specify the type as follows:\n\n *  `user` Share with a user.\n *  `group` Share with a group. Specify `groupname` as well.\n *  `project` Share with a project. Specify `projectId` as well.\n *  `projectRole` Share with a project role in a project. Specify `projectId` and `projectRoleId` as well.\n *  `global` Share globally, including anonymous users. If set, this type overrides all existing share permissions and must be deleted before any non-global share permissions is set.\n *  `authenticated` Share with all logged-in users. This shows as `loggedin` in the response. If set, this type overrides all existing share permissions and must be deleted before any non-global share permissions is set.';
            enum: ['user', 'project', 'group', 'projectRole', 'global', 'authenticated'];
            type: 'string';
          };
        };
        required: ['type'];
        type: 'object';
      };
      SimpleApplicationPropertyBean: {
        additionalProperties: false;
        properties: {
          id: {
            description: 'The ID of the application property.';
            type: 'string';
          };
          value: {
            description: 'The new value.';
            type: 'string';
          };
        };
        type: 'object';
        xml: {
          name: 'applicationProperty';
        };
      };
      SimpleErrorCollection: {
        additionalProperties: false;
        properties: {
          errorMessages: {
            description: 'The list of error messages produced by this operation. For example, "input parameter \'key\' must be provided"';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          errors: {
            additionalProperties: {
              type: 'string';
            };
            description: 'The list of errors by parameter returned by the operation. For example,"projectKey": "Project keys must start with an uppercase letter, followed by one or more uppercase alphanumeric characters."';
            type: 'object';
          };
          httpStatusCode: {
            format: 'int32';
            type: 'integer';
          };
        };
        type: 'object';
      };
      SimpleLink: {
        additionalProperties: false;
        description: 'Details about the operations available in this version.';
        properties: {
          href: {
            type: 'string';
          };
          iconClass: {
            type: 'string';
          };
          id: {
            type: 'string';
          };
          label: {
            type: 'string';
          };
          styleClass: {
            type: 'string';
          };
          title: {
            type: 'string';
          };
          weight: {
            format: 'int32';
            type: 'integer';
          };
        };
        type: 'object';
        xml: {
          name: 'link';
        };
      };
      SimpleListWrapperApplicationRole: {
        additionalProperties: false;
        properties: {
          callback: {
            $ref: '#/components/schemas/ListWrapperCallbackApplicationRole';
          };
          items: {
            items: {
              $ref: '#/components/schemas/ApplicationRole';
            };
            type: 'array';
          };
          'max-results': {
            format: 'int32';
            type: 'integer';
            xml: {
              attribute: true;
              name: 'max-results';
            };
          };
          pagingCallback: {
            $ref: '#/components/schemas/ListWrapperCallbackApplicationRole';
          };
          size: {
            format: 'int32';
            type: 'integer';
            xml: {
              attribute: true;
            };
          };
        };
        type: 'object';
        xml: {
          name: 'list';
        };
      };
      SimpleListWrapperGroupName: {
        additionalProperties: false;
        properties: {
          callback: {
            $ref: '#/components/schemas/ListWrapperCallbackGroupName';
          };
          items: {
            items: {
              $ref: '#/components/schemas/GroupName';
            };
            type: 'array';
          };
          'max-results': {
            format: 'int32';
            type: 'integer';
            xml: {
              attribute: true;
              name: 'max-results';
            };
          };
          pagingCallback: {
            $ref: '#/components/schemas/ListWrapperCallbackGroupName';
          };
          size: {
            format: 'int32';
            type: 'integer';
            xml: {
              attribute: true;
            };
          };
        };
        type: 'object';
        xml: {
          name: 'list';
        };
      };
      SimpleUsage: {
        additionalProperties: false;
        description: 'Represents a usage of an entity by a project ID and related issue type IDs.';
        properties: {
          issueTypeIds: {
            description: 'The issue type IDs for the usage.';
            items: {
              description: 'The issue type IDs for the usage.';
              type: 'string';
            };
            type: 'array';
          };
          projectId: {
            description: 'The project ID for the usage.';
            type: 'string';
          };
        };
        required: ['issueTypeIds', 'projectId'];
        type: 'object';
      };
      SimplifiedHierarchyLevel: {
        additionalProperties: false;
        properties: {
          aboveLevelId: {
            description: 'The ID of the level above this one in the hierarchy. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).';
            format: 'int64';
            type: 'integer';
          };
          belowLevelId: {
            description: 'The ID of the level below this one in the hierarchy. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).';
            format: 'int64';
            type: 'integer';
          };
          externalUuid: {
            description: 'The external UUID of the hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).';
            format: 'uuid';
            type: 'string';
          };
          hierarchyLevelNumber: {
            format: 'int32';
            type: 'integer';
          };
          id: {
            description: 'The ID of the hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).';
            format: 'int64';
            type: 'integer';
          };
          issueTypeIds: {
            description: 'The issue types available in this hierarchy level.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
          };
          level: {
            description: 'The level of this item in the hierarchy.';
            format: 'int32';
            type: 'integer';
          };
          name: {
            description: 'The name of this hierarchy level.';
            type: 'string';
          };
          projectConfigurationId: {
            description: 'The ID of the project configuration. This property is deprecated, see [Change oticen: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).';
            format: 'int64';
            type: 'integer';
          };
        };
        type: 'object';
      };
      SoftwareNavigationInfo: {
        properties: {
          boardId: {
            format: 'int64';
            type: 'integer';
          };
          boardName: {
            type: 'string';
          };
          simpleBoard: {
            type: 'boolean';
          };
          totalBoardsInProject: {
            format: 'int64';
            type: 'integer';
          };
        };
        type: 'object';
      };
      Status: {
        additionalProperties: true;
        description: 'The status of the item.';
        properties: {
          icon: {
            allOf: [
              {
                $ref: '#/components/schemas/Icon';
              },
            ];
            description: 'Details of the icon representing the status. If not provided, no status icon displays in Jira.';
          };
          resolved: {
            description: 'Whether the item is resolved. If set to "true", the link to the issue is displayed in a strikethrough font, otherwise the link displays in normal font.';
            type: 'boolean';
          };
        };
        type: 'object';
      };
      StatusCategory: {
        additionalProperties: true;
        description: 'A status category.';
        properties: {
          colorName: {
            description: 'The name of the color used to represent the status category.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the status category.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          key: {
            description: 'The key of the status category.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The name of the status category.';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the status category.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      StatusCreate: {
        additionalProperties: false;
        description: 'Details of the status being created.';
        properties: {
          description: {
            description: 'The description of the status.';
            type: 'string';
          };
          name: {
            description: 'The name of the status.';
            maxLength: 255;
            type: 'string';
          };
          statusCategory: {
            description: 'The category of the status.';
            enum: ['TODO', 'IN_PROGRESS', 'DONE'];
            type: 'string';
          };
        };
        required: ['name', 'statusCategory'];
        type: 'object';
      };
      StatusCreateRequest: {
        additionalProperties: false;
        description: 'Details of the statuses being created and their scope.';
        properties: {
          scope: {
            $ref: '#/components/schemas/StatusScope';
          };
          statuses: {
            description: 'Details of the statuses being created.';
            items: {
              $ref: '#/components/schemas/StatusCreate';
            };
            type: 'array';
          };
        };
        required: ['scope', 'statuses'];
        type: 'object';
      };
      StatusDetails: {
        additionalProperties: true;
        description: 'A status.';
        properties: {
          description: {
            description: 'The description of the status.';
            readOnly: true;
            type: 'string';
          };
          iconUrl: {
            description: 'The URL of the icon used to represent the status.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the status.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The name of the status.';
            readOnly: true;
            type: 'string';
          };
          scope: {
            allOf: [
              {
                $ref: '#/components/schemas/Scope';
              },
            ];
            description: 'The scope of the field.';
            readOnly: true;
          };
          self: {
            description: 'The URL of the status.';
            readOnly: true;
            type: 'string';
          };
          statusCategory: {
            allOf: [
              {
                $ref: '#/components/schemas/StatusCategory';
              },
            ];
            description: 'The category assigned to the status.';
            readOnly: true;
          };
        };
        type: 'object';
      };
      StatusLayoutUpdate: {
        additionalProperties: true;
        description: 'The statuses associated with this workflow.';
        properties: {
          approvalConfiguration: {
            $ref: '#/components/schemas/ApprovalConfiguration';
          };
          layout: {
            $ref: '#/components/schemas/WorkflowLayout';
          };
          properties: {
            additionalProperties: {
              description: 'The properties for this status layout.';
              type: 'string';
            };
            description: 'The properties for this status layout.';
            type: 'object';
          };
          statusReference: {
            description: 'A unique ID which the status will use to refer to this layout configuration.';
            type: 'string';
          };
        };
        required: ['properties', 'statusReference'];
        type: 'object';
      };
      StatusMapping: {
        additionalProperties: false;
        description: 'Details about the mapping from a status to a new status for an issue type.';
        properties: {
          issueTypeId: {
            description: 'The ID of the issue type.';
            type: 'string';
          };
          newStatusId: {
            description: 'The ID of the new status.';
            type: 'string';
          };
          statusId: {
            description: 'The ID of the status.';
            type: 'string';
          };
        };
        required: ['issueTypeId', 'newStatusId', 'statusId'];
        type: 'object';
      };
      StatusMappingDTO: {
        additionalProperties: true;
        description: 'The mapping of old to new status ID for a specific project and issue type.';
        properties: {
          issueTypeId: {
            description: 'The issue type for the status mapping.';
            type: 'string';
          };
          projectId: {
            description: 'The project for the status mapping.';
            type: 'string';
          };
          statusMigrations: {
            description: 'The list of old and new status ID mappings for the specified project and issue type.';
            items: {
              $ref: '#/components/schemas/StatusMigration';
            };
            type: 'array';
          };
        };
        required: ['issueTypeId', 'projectId', 'statusMigrations'];
        type: 'object';
      };
      StatusMetadata: {
        additionalProperties: false;
        description: 'The details of the statuses in the associated workflows.';
        properties: {
          category: {
            description: 'The category of the status.';
            enum: ['TODO', 'IN_PROGRESS', 'DONE'];
            type: 'string';
          };
          id: {
            description: 'The ID of the status.';
            type: 'string';
          };
          name: {
            description: 'The name of the status.';
            type: 'string';
          };
        };
        type: 'object';
      };
      StatusMigration: {
        additionalProperties: true;
        description: 'The mapping of old to new status ID.';
        properties: {
          newStatusReference: {
            description: 'The new status ID.';
            type: 'string';
          };
          oldStatusReference: {
            description: 'The old status ID.';
            type: 'string';
          };
        };
        required: ['newStatusReference', 'oldStatusReference'];
        type: 'object';
      };
      StatusReferenceAndPort: {
        additionalProperties: false;
        deprecated: true;
        description: 'The status reference and port that a transition is connected to.';
        nullable: true;
        properties: {
          port: {
            description: 'The port this transition uses to connect to this status.';
            format: 'int32';
            type: 'integer';
          };
          statusReference: {
            description: 'The reference of this status.';
            type: 'string';
          };
        };
        required: ['statusReference'];
        type: 'object';
      };
      StatusScope: {
        additionalProperties: false;
        description: 'The scope of the status.';
        properties: {
          project: {
            $ref: '#/components/schemas/ProjectId';
          };
          type: {
            description: 'The scope of the status. `GLOBAL` for company-managed projects and `PROJECT` for team-managed projects.';
            enum: ['PROJECT', 'GLOBAL'];
            type: 'string';
          };
        };
        required: ['type'];
        type: 'object';
      };
      StatusUpdate: {
        additionalProperties: true;
        description: 'Details of the status being updated.';
        properties: {
          description: {
            description: 'The description of the status.';
            type: 'string';
          };
          id: {
            description: 'The ID of the status.';
            type: 'string';
          };
          name: {
            description: 'The name of the status.';
            type: 'string';
          };
          statusCategory: {
            description: 'The category of the status.';
            enum: ['TODO', 'IN_PROGRESS', 'DONE'];
            type: 'string';
          };
        };
        required: ['id', 'name', 'statusCategory'];
        type: 'object';
      };
      StatusUpdateRequest: {
        additionalProperties: false;
        description: 'The list of statuses that will be updated.';
        properties: {
          statuses: {
            description: 'The list of statuses that will be updated.';
            items: {
              $ref: '#/components/schemas/StatusUpdate';
            };
            type: 'array';
          };
        };
        required: ['statuses'];
        type: 'object';
      };
      StatusesPerWorkflow: {
        additionalProperties: false;
        description: 'The statuses associated with each workflow.';
        properties: {
          initialStatusId: {
            description: 'The ID of the initial status for the workflow.';
            type: 'string';
          };
          statuses: {
            description: 'The status IDs associated with the workflow.';
            items: {
              description: 'The status IDs associated with the workflow.';
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          workflowId: {
            description: 'The ID of the workflow.';
            type: 'string';
          };
        };
        type: 'object';
      };
      StreamingResponseBody: {
        additionalProperties: false;
        type: 'object';
      };
      StringList: {
        additionalProperties: false;
        type: 'object';
      };
      SubmittedBulkOperation: {
        additionalProperties: false;
        properties: {
          taskId: {
            type: 'string';
          };
        };
        type: 'object';
      };
      SuggestedIssue: {
        additionalProperties: false;
        description: 'An issue suggested for use in the issue picker auto-completion.';
        properties: {
          id: {
            description: 'The ID of the issue.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          img: {
            description: "The URL of the issue type's avatar.";
            readOnly: true;
            type: 'string';
          };
          key: {
            description: 'The key of the issue.';
            readOnly: true;
            type: 'string';
          };
          keyHtml: {
            description: 'The key of the issue in HTML format.';
            readOnly: true;
            type: 'string';
          };
          summary: {
            description: 'The phrase containing the query string in HTML format, with the string highlighted with HTML bold tags.';
            readOnly: true;
            type: 'string';
          };
          summaryText: {
            description: 'The phrase containing the query string, as plain text.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      SuggestedMappingsForPrioritiesRequestBean: {
        additionalProperties: false;
        description: "Details of changes to a priority scheme's priorities that require suggested priority mappings.";
        properties: {
          add: {
            description: 'The ids of priorities being removed from the scheme.';
            items: {
              format: 'int64';
              type: 'integer';
              writeOnly: true;
            };
            type: 'array';
            writeOnly: true;
          };
          remove: {
            description: 'The ids of priorities being removed from the scheme.';
            items: {
              format: 'int64';
              type: 'integer';
              writeOnly: true;
            };
            type: 'array';
            writeOnly: true;
          };
        };
        type: 'object';
        writeOnly: true;
      };
      SuggestedMappingsForProjectsRequestBean: {
        additionalProperties: false;
        description: "Details of changes to a priority scheme's projects that require suggested priority mappings.";
        properties: {
          add: {
            description: 'The ids of projects being added to the scheme.';
            items: {
              format: 'int64';
              type: 'integer';
              writeOnly: true;
            };
            type: 'array';
            writeOnly: true;
          };
        };
        type: 'object';
        writeOnly: true;
      };
      SuggestedMappingsRequestBean: {
        additionalProperties: false;
        description: 'Details of changes to a priority scheme that require suggested priority mappings.';
        properties: {
          maxResults: {
            description: 'The maximum number of results that could be on the page.';
            format: 'int32';
            type: 'integer';
            writeOnly: true;
          };
          priorities: {
            allOf: [
              {
                $ref: '#/components/schemas/SuggestedMappingsForPrioritiesRequestBean';
              },
            ];
            description: 'The priority changes in the scheme.';
          };
          projects: {
            allOf: [
              {
                $ref: '#/components/schemas/SuggestedMappingsForProjectsRequestBean';
              },
            ];
            description: 'The project changes in the scheme.';
          };
          schemeId: {
            description: 'The id of the priority scheme.';
            format: 'int64';
            type: 'integer';
            writeOnly: true;
          };
          startAt: {
            description: 'The index of the first item returned on the page.';
            format: 'int64';
            type: 'integer';
            writeOnly: true;
          };
        };
        type: 'object';
      };
      SystemAvatars: {
        additionalProperties: false;
        description: 'List of system avatars.';
        properties: {
          system: {
            description: 'A list of avatar details.';
            items: {
              $ref: '#/components/schemas/Avatar';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      TaskProgressBeanJsonNode: {
        additionalProperties: false;
        description: 'Details about a task.';
        properties: {
          description: {
            description: 'The description of the task.';
            type: 'string';
          };
          elapsedRuntime: {
            description: 'The execution time of the task, in milliseconds.';
            format: 'int64';
            type: 'integer';
          };
          finished: {
            description: 'A timestamp recording when the task was finished.';
            format: 'int64';
            type: 'integer';
          };
          id: {
            description: 'The ID of the task.';
            type: 'string';
          };
          lastUpdate: {
            description: 'A timestamp recording when the task progress was last updated.';
            format: 'int64';
            type: 'integer';
          };
          message: {
            description: 'Information about the progress of the task.';
            type: 'string';
          };
          progress: {
            description: 'The progress of the task, as a percentage complete.';
            format: 'int64';
            type: 'integer';
          };
          result: {
            allOf: [
              {
                $ref: '#/components/schemas/JsonNode';
              },
            ];
            description: 'The result of the task execution.';
          };
          self: {
            description: 'The URL of the task.';
            format: 'uri';
            type: 'string';
          };
          started: {
            description: 'A timestamp recording when the task was started.';
            format: 'int64';
            type: 'integer';
          };
          status: {
            description: 'The status of the task.';
            enum: ['ENQUEUED', 'RUNNING', 'COMPLETE', 'FAILED', 'CANCEL_REQUESTED', 'CANCELLED', 'DEAD'];
            type: 'string';
          };
          submitted: {
            description: 'A timestamp recording when the task was submitted.';
            format: 'int64';
            type: 'integer';
          };
          submittedBy: {
            description: 'The ID of the user who submitted the task.';
            format: 'int64';
            type: 'integer';
          };
        };
        required: ['elapsedRuntime', 'id', 'lastUpdate', 'progress', 'self', 'status', 'submitted', 'submittedBy'];
        type: 'object';
      };
      TaskProgressBeanObject: {
        additionalProperties: false;
        description: 'Details about a task.';
        properties: {
          description: {
            description: 'The description of the task.';
            type: 'string';
          };
          elapsedRuntime: {
            description: 'The execution time of the task, in milliseconds.';
            format: 'int64';
            type: 'integer';
          };
          finished: {
            description: 'A timestamp recording when the task was finished.';
            format: 'int64';
            type: 'integer';
          };
          id: {
            description: 'The ID of the task.';
            type: 'string';
          };
          lastUpdate: {
            description: 'A timestamp recording when the task progress was last updated.';
            format: 'int64';
            type: 'integer';
          };
          message: {
            description: 'Information about the progress of the task.';
            type: 'string';
          };
          progress: {
            description: 'The progress of the task, as a percentage complete.';
            format: 'int64';
            type: 'integer';
          };
          result: {
            description: 'The result of the task execution.';
          };
          self: {
            description: 'The URL of the task.';
            format: 'uri';
            type: 'string';
          };
          started: {
            description: 'A timestamp recording when the task was started.';
            format: 'int64';
            type: 'integer';
          };
          status: {
            description: 'The status of the task.';
            enum: ['ENQUEUED', 'RUNNING', 'COMPLETE', 'FAILED', 'CANCEL_REQUESTED', 'CANCELLED', 'DEAD'];
            type: 'string';
          };
          submitted: {
            description: 'A timestamp recording when the task was submitted.';
            format: 'int64';
            type: 'integer';
          };
          submittedBy: {
            description: 'The ID of the user who submitted the task.';
            format: 'int64';
            type: 'integer';
          };
        };
        required: ['elapsedRuntime', 'id', 'lastUpdate', 'progress', 'self', 'status', 'submitted', 'submittedBy'];
        type: 'object';
      };
      TaskProgressBeanRemoveOptionFromIssuesResult: {
        additionalProperties: false;
        description: 'Details about a task.';
        properties: {
          description: {
            description: 'The description of the task.';
            type: 'string';
          };
          elapsedRuntime: {
            description: 'The execution time of the task, in milliseconds.';
            format: 'int64';
            type: 'integer';
          };
          finished: {
            description: 'A timestamp recording when the task was finished.';
            format: 'int64';
            type: 'integer';
          };
          id: {
            description: 'The ID of the task.';
            type: 'string';
          };
          lastUpdate: {
            description: 'A timestamp recording when the task progress was last updated.';
            format: 'int64';
            type: 'integer';
          };
          message: {
            description: 'Information about the progress of the task.';
            type: 'string';
          };
          progress: {
            description: 'The progress of the task, as a percentage complete.';
            format: 'int64';
            type: 'integer';
          };
          result: {
            allOf: [
              {
                $ref: '#/components/schemas/RemoveOptionFromIssuesResult';
              },
            ];
            description: 'The result of the task execution.';
          };
          self: {
            description: 'The URL of the task.';
            format: 'uri';
            type: 'string';
          };
          started: {
            description: 'A timestamp recording when the task was started.';
            format: 'int64';
            type: 'integer';
          };
          status: {
            description: 'The status of the task.';
            enum: ['ENQUEUED', 'RUNNING', 'COMPLETE', 'FAILED', 'CANCEL_REQUESTED', 'CANCELLED', 'DEAD'];
            type: 'string';
          };
          submitted: {
            description: 'A timestamp recording when the task was submitted.';
            format: 'int64';
            type: 'integer';
          };
          submittedBy: {
            description: 'The ID of the user who submitted the task.';
            format: 'int64';
            type: 'integer';
          };
        };
        required: ['elapsedRuntime', 'id', 'lastUpdate', 'progress', 'self', 'status', 'submitted', 'submittedBy'];
        type: 'object';
      };
      TimeTrackingConfiguration: {
        additionalProperties: false;
        description: 'Details of the time tracking configuration.';
        properties: {
          defaultUnit: {
            description: 'The default unit of time applied to logged time.';
            enum: ['minute', 'hour', 'day', 'week'];
            type: 'string';
          };
          timeFormat: {
            description: "The format that will appear on an issue's *Time Spent* field.";
            enum: ['pretty', 'days', 'hours'];
            type: 'string';
          };
          workingDaysPerWeek: {
            description: 'The number of days in a working week.';
            format: 'double';
            type: 'number';
          };
          workingHoursPerDay: {
            description: 'The number of hours in a working day.';
            format: 'double';
            type: 'number';
          };
        };
        required: ['defaultUnit', 'timeFormat', 'workingDaysPerWeek', 'workingHoursPerDay'];
        type: 'object';
      };
      TimeTrackingDetails: {
        additionalProperties: false;
        description: 'Time tracking details.';
        properties: {
          originalEstimate: {
            description: 'The original estimate of time needed for this issue in readable format.';
            readOnly: true;
            type: 'string';
          };
          originalEstimateSeconds: {
            description: 'The original estimate of time needed for this issue in seconds.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          remainingEstimate: {
            description: 'The remaining estimate of time needed for this issue in readable format.';
            readOnly: true;
            type: 'string';
          };
          remainingEstimateSeconds: {
            description: 'The remaining estimate of time needed for this issue in seconds.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          timeSpent: {
            description: 'Time worked on this issue in readable format.';
            readOnly: true;
            type: 'string';
          };
          timeSpentSeconds: {
            description: 'Time worked on this issue in seconds.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
        };
        type: 'object';
      };
      TimeTrackingProvider: {
        additionalProperties: false;
        description: 'Details about the time tracking provider.';
        properties: {
          key: {
            description: 'The key for the time tracking provider. For example, *JIRA*.';
            type: 'string';
          };
          name: {
            description: 'The name of the time tracking provider. For example, *JIRA provided time tracking*.';
            type: 'string';
          };
          url: {
            description: 'The URL of the configuration page for the time tracking provider app. For example, */example/config/url*. This property is only returned if the `adminPageKey` property is set in the module descriptor of the time tracking provider app.';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['key'];
        type: 'object';
      };
      Transition: {
        additionalProperties: false;
        description: 'Details of a workflow transition.';
        properties: {
          description: {
            description: 'The description of the transition.';
            type: 'string';
          };
          from: {
            description: 'The statuses the transition can start from.';
            items: {
              description: 'The statuses the transition can start from.';
              type: 'string';
            };
            type: 'array';
          };
          id: {
            description: 'The ID of the transition.';
            type: 'string';
          };
          name: {
            description: 'The name of the transition.';
            type: 'string';
          };
          properties: {
            additionalProperties: {
              description: 'The properties of the transition.';
            };
            description: 'The properties of the transition.';
            type: 'object';
          };
          rules: {
            $ref: '#/components/schemas/WorkflowRules';
          };
          screen: {
            $ref: '#/components/schemas/TransitionScreenDetails';
          };
          to: {
            description: 'The status the transition goes to.';
            type: 'string';
          };
          type: {
            description: 'The type of the transition.';
            enum: ['global', 'initial', 'directed'];
            type: 'string';
          };
        };
        required: ['description', 'from', 'id', 'name', 'to', 'type'];
        type: 'object';
      };
      TransitionScreenDetails: {
        additionalProperties: false;
        description: 'The details of a transition screen.';
        properties: {
          id: {
            description: 'The ID of the screen.';
            type: 'string';
          };
          name: {
            description: 'The name of the screen.';
            type: 'string';
          };
        };
        required: ['id'];
        type: 'object';
      };
      TransitionUpdateDTO: {
        additionalProperties: true;
        description: 'The transition update data. Note that a transition can have either the deprecated `to`/`from` fields or the `toStatusReference`/`links` fields, but never both nor a combination.';
        properties: {
          actions: {
            description: 'The post-functions of the transition.';
            items: {
              $ref: '#/components/schemas/WorkflowRuleConfiguration';
            };
            type: 'array';
          };
          conditions: {
            $ref: '#/components/schemas/ConditionGroupUpdate';
          };
          customIssueEventId: {
            description: 'The custom event ID of the transition.';
            type: 'string';
          };
          description: {
            description: 'The description of the transition.';
            type: 'string';
          };
          from: {
            deprecated: true;
            description: 'The statuses and ports that the transition can start from. This field is deprecated - use `toStatusReference`/`links` instead.';
            items: {
              $ref: '#/components/schemas/StatusReferenceAndPort';
            };
            type: 'array';
          };
          id: {
            description: 'The ID of the transition.';
            type: 'string';
          };
          links: {
            description: 'The statuses the transition can start from, and the mapping of ports between the statuses.';
            items: {
              $ref: '#/components/schemas/WorkflowTransitionLinks';
            };
            type: 'array';
          };
          name: {
            description: 'The name of the transition.';
            type: 'string';
          };
          properties: {
            additionalProperties: {
              description: 'The properties of the transition.';
              type: 'string';
            };
            description: 'The properties of the transition.';
            type: 'object';
          };
          to: {
            $ref: '#/components/schemas/StatusReferenceAndPort';
          };
          toStatusReference: {
            description: 'The status the transition goes to.';
            type: 'string';
          };
          transitionScreen: {
            $ref: '#/components/schemas/WorkflowRuleConfiguration';
          };
          triggers: {
            description: 'The triggers of the transition.';
            items: {
              $ref: '#/components/schemas/WorkflowTrigger';
            };
            type: 'array';
          };
          type: {
            description: 'The transition type.';
            enum: ['INITIAL', 'GLOBAL', 'DIRECTED'];
            type: 'string';
          };
          validators: {
            description: 'The validators of the transition.';
            items: {
              $ref: '#/components/schemas/WorkflowRuleConfiguration';
            };
            type: 'array';
          };
        };
        required: ['id', 'name', 'type'];
        type: 'object';
      };
      Transitions: {
        additionalProperties: false;
        description: 'List of issue transitions.';
        properties: {
          expand: {
            description: 'Expand options that include additional transitions details in the response.';
            readOnly: true;
            type: 'string';
            xml: {
              attribute: true;
            };
          };
          transitions: {
            description: 'List of issue transitions.';
            items: {
              $ref: '#/components/schemas/IssueTransition';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      UiModificationContextDetails: {
        additionalProperties: false;
        description: "The details of a UI modification's context, which define where to activate the UI modification.";
        properties: {
          id: {
            description: 'The ID of the UI modification context.';
            readOnly: true;
            type: 'string';
          };
          isAvailable: {
            description: 'Whether a context is available. For example, when a project is deleted the context becomes unavailable.';
            readOnly: true;
            type: 'boolean';
          };
          issueTypeId: {
            description: 'The issue type ID of the context. Null is treated as a wildcard, meaning the UI modification will be applied to all issue types. Each UI modification context can have a maximum of one wildcard.';
            type: 'string';
          };
          projectId: {
            description: 'The project ID of the context. Null is treated as a wildcard, meaning the UI modification will be applied to all projects. Each UI modification context can have a maximum of one wildcard.';
            type: 'string';
          };
          viewType: {
            description: 'The view type of the context. Only `GIC`(Global Issue Create) and `IssueView` are supported. Null is treated as a wildcard, meaning the UI modification will be applied to all view types. Each UI modification context can have a maximum of one wildcard.';
            enum: ['GIC', 'IssueView'];
            type: 'string';
          };
        };
        type: 'object';
        writeOnly: true;
      };
      UiModificationDetails: {
        additionalProperties: false;
        description: 'The details of a UI modification.';
        properties: {
          contexts: {
            description: 'List of contexts of the UI modification. The maximum number of contexts is 1000.';
            items: {
              $ref: '#/components/schemas/UiModificationContextDetails';
            };
            readOnly: true;
            type: 'array';
          };
          data: {
            description: 'The data of the UI modification. The maximum size of the data is 50000 characters.';
            readOnly: true;
            type: 'string';
          };
          description: {
            description: 'The description of the UI modification. The maximum length is 255 characters.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the UI modification.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The name of the UI modification. The maximum length is 255 characters.';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the UI modification.';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['id', 'name', 'self'];
        type: 'object';
      };
      UiModificationIdentifiers: {
        additionalProperties: false;
        description: 'Identifiers for a UI modification.';
        properties: {
          id: {
            description: 'The ID of the UI modification.';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the UI modification.';
            readOnly: true;
            type: 'string';
          };
        };
        required: ['id', 'self'];
        type: 'object';
      };
      UnrestrictedUserEmail: {
        additionalProperties: true;
        properties: {
          accountId: {
            description: 'The accountId of the user';
            type: 'string';
          };
          email: {
            description: 'The email of the user';
            type: 'string';
          };
        };
        type: 'object';
      };
      UpdateCustomFieldDetails: {
        additionalProperties: false;
        description: 'Details of a custom field.';
        properties: {
          description: {
            description: 'The description of the custom field. The maximum length is 40000 characters.';
            type: 'string';
          };
          name: {
            description: "The name of the custom field. It doesn't have to be unique. The maximum length is 255 characters.";
            type: 'string';
          };
          searcherKey: {
            description: 'The searcher that defines the way the field is searched in Jira. It can be set to `null`, otherwise you must specify the valid searcher for the field type, as listed below (abbreviated values shown):\n\n *  `cascadingselect`: `cascadingselectsearcher`\n *  `datepicker`: `daterange`\n *  `datetime`: `datetimerange`\n *  `float`: `exactnumber` or `numberrange`\n *  `grouppicker`: `grouppickersearcher`\n *  `importid`: `exactnumber` or `numberrange`\n *  `labels`: `labelsearcher`\n *  `multicheckboxes`: `multiselectsearcher`\n *  `multigrouppicker`: `multiselectsearcher`\n *  `multiselect`: `multiselectsearcher`\n *  `multiuserpicker`: `userpickergroupsearcher`\n *  `multiversion`: `versionsearcher`\n *  `project`: `projectsearcher`\n *  `radiobuttons`: `multiselectsearcher`\n *  `readonlyfield`: `textsearcher`\n *  `select`: `multiselectsearcher`\n *  `textarea`: `textsearcher`\n *  `textfield`: `textsearcher`\n *  `url`: `exacttextsearcher`\n *  `userpicker`: `userpickergroupsearcher`\n *  `version`: `versionsearcher`';
            enum: [
              'com.atlassian.jira.plugin.system.customfieldtypes:cascadingselectsearcher',
              'com.atlassian.jira.plugin.system.customfieldtypes:daterange',
              'com.atlassian.jira.plugin.system.customfieldtypes:datetimerange',
              'com.atlassian.jira.plugin.system.customfieldtypes:exactnumber',
              'com.atlassian.jira.plugin.system.customfieldtypes:exacttextsearcher',
              'com.atlassian.jira.plugin.system.customfieldtypes:grouppickersearcher',
              'com.atlassian.jira.plugin.system.customfieldtypes:labelsearcher',
              'com.atlassian.jira.plugin.system.customfieldtypes:multiselectsearcher',
              'com.atlassian.jira.plugin.system.customfieldtypes:numberrange',
              'com.atlassian.jira.plugin.system.customfieldtypes:projectsearcher',
              'com.atlassian.jira.plugin.system.customfieldtypes:textsearcher',
              'com.atlassian.jira.plugin.system.customfieldtypes:userpickergroupsearcher',
              'com.atlassian.jira.plugin.system.customfieldtypes:versionsearcher',
            ];
            type: 'string';
          };
        };
        type: 'object';
        writeOnly: true;
      };
      UpdateDefaultProjectClassificationBean: {
        additionalProperties: false;
        description: 'The request for updating the default project classification level.';
        properties: {
          id: {
            description: 'The ID of the project classification.';
            type: 'string';
          };
        };
        required: ['id'];
        type: 'object';
      };
      UpdateDefaultScreenScheme: {
        additionalProperties: false;
        description: 'The ID of a screen scheme.';
        properties: {
          screenSchemeId: {
            description: 'The ID of the screen scheme.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['screenSchemeId'];
        type: 'object';
      };
      UpdateFieldConfigurationSchemeDetails: {
        additionalProperties: false;
        description: 'The details of the field configuration scheme.';
        properties: {
          description: {
            description: 'The description of the field configuration scheme.';
            maxLength: 1024;
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the field configuration scheme. The name must be unique.';
            maxLength: 255;
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['name'];
        type: 'object';
      };
      UpdateIssueSecurityLevelDetails: {
        additionalProperties: true;
        description: 'Details of issue security scheme level.';
        properties: {
          description: {
            description: 'The description of the issue security scheme level.';
            maxLength: 255;
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the issue security scheme level. Must be unique.';
            maxLength: 60;
            type: 'string';
            writeOnly: true;
          };
        };
        type: 'object';
      };
      UpdateIssueSecuritySchemeRequestBean: {
        additionalProperties: false;
        properties: {
          description: {
            description: 'The description of the security scheme scheme.';
            maxLength: 255;
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the security scheme scheme. Must be unique.';
            maxLength: 60;
            type: 'string';
            writeOnly: true;
          };
        };
        type: 'object';
      };
      UpdateNotificationSchemeDetails: {
        additionalProperties: true;
        description: 'Details of a notification scheme.';
        properties: {
          description: {
            description: 'The description of the notification scheme.';
            maxLength: 4000;
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the notification scheme. Must be unique.';
            maxLength: 255;
            type: 'string';
            writeOnly: true;
          };
        };
        type: 'object';
      };
      UpdatePrioritiesInSchemeRequestBean: {
        additionalProperties: true;
        description: 'Update priorities in a scheme';
        properties: {
          add: {
            allOf: [
              {
                $ref: '#/components/schemas/PrioritySchemeChangesWithoutMappings';
              },
            ];
            description: 'Priorities to add to a scheme';
          };
          remove: {
            allOf: [
              {
                $ref: '#/components/schemas/PrioritySchemeChangesWithMappings';
              },
            ];
            description: 'Priorities to remove from a scheme';
          };
        };
        type: 'object';
        writeOnly: true;
      };
      UpdatePriorityDetails: {
        additionalProperties: true;
        description: 'Details of an issue priority.';
        properties: {
          avatarId: {
            description: 'The ID for the avatar for the priority. This parameter is nullable and both iconUrl and avatarId cannot be defined.';
            format: 'int64';
            type: 'integer';
            writeOnly: true;
          };
          description: {
            description: 'The description of the priority.';
            maxLength: 255;
            nullable: true;
            type: 'string';
            writeOnly: true;
          };
          iconUrl: {
            description: 'The URL of an icon for the priority. Accepted protocols are HTTP and HTTPS. Built in icons can also be used. Both iconUrl and avatarId cannot be defined.';
            enum: [
              '/images/icons/priorities/blocker.png',
              '/images/icons/priorities/critical.png',
              '/images/icons/priorities/high.png',
              '/images/icons/priorities/highest.png',
              '/images/icons/priorities/low.png',
              '/images/icons/priorities/lowest.png',
              '/images/icons/priorities/major.png',
              '/images/icons/priorities/medium.png',
              '/images/icons/priorities/minor.png',
              '/images/icons/priorities/trivial.png',
              '/images/icons/priorities/blocker_new.png',
              '/images/icons/priorities/critical_new.png',
              '/images/icons/priorities/high_new.png',
              '/images/icons/priorities/highest_new.png',
              '/images/icons/priorities/low_new.png',
              '/images/icons/priorities/lowest_new.png',
              '/images/icons/priorities/major_new.png',
              '/images/icons/priorities/medium_new.png',
              '/images/icons/priorities/minor_new.png',
              '/images/icons/priorities/trivial_new.png',
            ];
            maxLength: 255;
            nullable: true;
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the priority. Must be unique.';
            maxLength: 60;
            nullable: true;
            type: 'string';
            writeOnly: true;
          };
          statusColor: {
            description: 'The status color of the priority in 3-digit or 6-digit hexadecimal format.';
            nullable: true;
            type: 'string';
            writeOnly: true;
          };
        };
        type: 'object';
      };
      UpdatePrioritySchemeRequestBean: {
        additionalProperties: false;
        description: 'Details of a priority scheme.';
        properties: {
          defaultPriorityId: {
            description: 'The default priority of the scheme.';
            format: 'int64';
            type: 'integer';
            writeOnly: true;
          };
          description: {
            description: 'The description of the priority scheme.';
            maxLength: 4000;
            type: 'string';
            writeOnly: true;
          };
          mappings: {
            allOf: [
              {
                $ref: '#/components/schemas/PriorityMapping';
              },
            ];
            description: 'Instructions to migrate issues.';
          };
          name: {
            description: 'The name of the priority scheme. Must be unique.';
            maxLength: 255;
            type: 'string';
            writeOnly: true;
          };
          priorities: {
            allOf: [
              {
                $ref: '#/components/schemas/UpdatePrioritiesInSchemeRequestBean';
              },
            ];
            description: 'The priorities in the scheme.';
          };
          projects: {
            allOf: [
              {
                $ref: '#/components/schemas/UpdateProjectsInSchemeRequestBean';
              },
            ];
            description: 'The projects in the scheme.';
          };
        };
        type: 'object';
      };
      UpdatePrioritySchemeResponseBean: {
        additionalProperties: true;
        description: 'Details of the updated priority scheme.';
        properties: {
          priorityScheme: {
            $ref: '#/components/schemas/PrioritySchemeWithPaginatedPrioritiesAndProjects';
          };
          task: {
            allOf: [
              {
                $ref: '#/components/schemas/TaskProgressBeanJsonNode';
              },
            ];
            description: 'The in-progress issue migration task.';
            readOnly: true;
          };
        };
        type: 'object';
      };
      UpdateProjectDetails: {
        additionalProperties: false;
        description: 'Details about the project.';
        properties: {
          assigneeType: {
            description: 'The default assignee when creating issues for this project.';
            enum: ['PROJECT_LEAD', 'UNASSIGNED'];
            type: 'string';
          };
          avatarId: {
            description: "An integer value for the project's avatar.";
            format: 'int64';
            type: 'integer';
          };
          categoryId: {
            description: "The ID of the project's category. A complete list of category IDs is found using the [Get all project categories](#api-rest-api-3-projectCategory-get) operation. To remove the project category from the project, set the value to `-1.`";
            format: 'int64';
            type: 'integer';
          };
          description: {
            description: 'A brief description of the project.';
            type: 'string';
          };
          issueSecurityScheme: {
            description: 'The ID of the issue security scheme for the project, which enables you to control who can and cannot view issues. Use the [Get issue security schemes](#api-rest-api-3-issuesecurityschemes-get) resource to get all issue security scheme IDs.';
            format: 'int64';
            type: 'integer';
          };
          key: {
            description: 'Project keys must be unique and start with an uppercase letter followed by one or more uppercase alphanumeric characters. The maximum length is 10 characters.';
            type: 'string';
          };
          lead: {
            description: 'This parameter is deprecated because of privacy changes. Use `leadAccountId` instead. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details. The user name of the project lead. Cannot be provided with `leadAccountId`.';
            type: 'string';
          };
          leadAccountId: {
            description: 'The account ID of the project lead. Cannot be provided with `lead`.';
            maxLength: 128;
            type: 'string';
          };
          name: {
            description: 'The name of the project.';
            type: 'string';
          };
          notificationScheme: {
            description: 'The ID of the notification scheme for the project. Use the [Get notification schemes](#api-rest-api-3-notificationscheme-get) resource to get a list of notification scheme IDs.';
            format: 'int64';
            type: 'integer';
          };
          permissionScheme: {
            description: 'The ID of the permission scheme for the project. Use the [Get all permission schemes](#api-rest-api-3-permissionscheme-get) resource to see a list of all permission scheme IDs.';
            format: 'int64';
            type: 'integer';
          };
          url: {
            description: 'A link to information about this project, such as project documentation';
            type: 'string';
          };
        };
        type: 'object';
      };
      UpdateProjectsInSchemeRequestBean: {
        additionalProperties: true;
        description: 'Update projects in a scheme';
        properties: {
          add: {
            allOf: [
              {
                $ref: '#/components/schemas/PrioritySchemeChangesWithoutMappings';
              },
            ];
            description: 'Projects to add to a scheme';
          };
          remove: {
            allOf: [
              {
                $ref: '#/components/schemas/PrioritySchemeChangesWithoutMappings';
              },
            ];
            description: 'Projects to remove from a scheme';
          };
        };
        type: 'object';
        writeOnly: true;
      };
      UpdateResolutionDetails: {
        additionalProperties: true;
        description: 'Details of an issue resolution.';
        properties: {
          description: {
            description: 'The description of the resolution.';
            maxLength: 255;
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the resolution. Must be unique.';
            maxLength: 60;
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['name'];
        type: 'object';
      };
      UpdateScreenDetails: {
        additionalProperties: false;
        description: 'Details of a screen.';
        properties: {
          description: {
            description: 'The description of the screen. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the screen. The name must be unique. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
        };
        type: 'object';
      };
      UpdateScreenSchemeDetails: {
        additionalProperties: false;
        description: 'Details of a screen scheme.';
        properties: {
          description: {
            description: 'The description of the screen scheme. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the screen scheme. The name must be unique. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
          screens: {
            allOf: [
              {
                $ref: '#/components/schemas/UpdateScreenTypes';
              },
            ];
            description: 'The IDs of the screens for the screen types of the screen scheme. Only screens used in classic projects are accepted.';
          };
        };
        type: 'object';
      };
      UpdateScreenTypes: {
        additionalProperties: false;
        description: 'The IDs of the screens for the screen types of the screen scheme.';
        properties: {
          create: {
            description: 'The ID of the create screen. To remove the screen association, pass a null.';
            type: 'string';
            writeOnly: true;
          };
          default: {
            description: 'The ID of the default screen. When specified, must include a screen ID as a default screen is required.';
            type: 'string';
            writeOnly: true;
          };
          edit: {
            description: 'The ID of the edit screen. To remove the screen association, pass a null.';
            type: 'string';
            writeOnly: true;
          };
          view: {
            description: 'The ID of the view screen. To remove the screen association, pass a null.';
            type: 'string';
            writeOnly: true;
          };
        };
        type: 'object';
        writeOnly: true;
      };
      UpdateUiModificationDetails: {
        additionalProperties: false;
        description: 'The details of a UI modification.';
        properties: {
          contexts: {
            description: 'List of contexts of the UI modification. The maximum number of contexts is 1000. If provided, replaces all existing contexts.';
            items: {
              $ref: '#/components/schemas/UiModificationContextDetails';
            };
            type: 'array';
            writeOnly: true;
          };
          data: {
            description: 'The data of the UI modification. The maximum size of the data is 50000 characters.';
            type: 'string';
            writeOnly: true;
          };
          description: {
            description: 'The description of the UI modification. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
          name: {
            description: 'The name of the UI modification. The maximum length is 255 characters.';
            type: 'string';
            writeOnly: true;
          };
        };
        type: 'object';
      };
      UpdateUserToGroupBean: {
        additionalProperties: true;
        properties: {
          accountId: {
            description: 'The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.';
            maxLength: 128;
            type: 'string';
          };
          name: {
            description: 'This property is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.';
            type: 'string';
          };
        };
        type: 'object';
      };
      UpdatedProjectCategory: {
        additionalProperties: false;
        description: 'A project category.';
        properties: {
          description: {
            description: 'The name of the project category.';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the project category.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'The description of the project category.';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the project category.';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      User: {
        additionalProperties: false;
        description: "A user with details as permitted by the user's Atlassian Account privacy settings. However, be aware of these exceptions:\n\n *  User record deleted from Atlassian: This occurs as the result of a right to be forgotten request. In this case, `displayName` provides an indication and other parameters have default values or are blank (for example, email is blank).\n *  User record corrupted: This occurs as a results of events such as a server import and can only happen to deleted users. In this case, `accountId` returns *unknown* and all other parameters have fallback values.\n *  User record unavailable: This usually occurs due to an internal service outage. In this case, all parameters have fallback values.";
        properties: {
          accountId: {
            description: 'The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*. Required in requests.';
            maxLength: 128;
            type: 'string';
          };
          accountType: {
            description: 'The user account type. Can take the following values:\n\n *  `atlassian` regular Atlassian user account\n *  `app` system account used for Connect applications and OAuth to represent external systems\n *  `customer` Jira Service Desk account representing an external service desk';
            enum: ['atlassian', 'app', 'customer', 'unknown'];
            readOnly: true;
            type: 'string';
          };
          active: {
            description: 'Whether the user is active.';
            readOnly: true;
            type: 'boolean';
          };
          applicationRoles: {
            allOf: [
              {
                $ref: '#/components/schemas/SimpleListWrapperApplicationRole';
              },
            ];
            description: 'The application roles the user is assigned to.';
            readOnly: true;
          };
          avatarUrls: {
            allOf: [
              {
                $ref: '#/components/schemas/AvatarUrlsBean';
              },
            ];
            description: 'The avatars of the user.';
            readOnly: true;
          };
          displayName: {
            description: 'The display name of the user. Depending on the user’s privacy setting, this may return an alternative value.';
            readOnly: true;
            type: 'string';
          };
          emailAddress: {
            description: 'The email address of the user. Depending on the user’s privacy setting, this may be returned as null.';
            readOnly: true;
            type: 'string';
          };
          expand: {
            description: 'Expand options that include additional user details in the response.';
            readOnly: true;
            type: 'string';
            xml: {
              attribute: true;
            };
          };
          groups: {
            allOf: [
              {
                $ref: '#/components/schemas/SimpleListWrapperGroupName';
              },
            ];
            description: 'The groups that the user belongs to.';
            readOnly: true;
          };
          key: {
            description: 'This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.';
            type: 'string';
          };
          locale: {
            description: 'The locale of the user. Depending on the user’s privacy setting, this may be returned as null.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.';
            type: 'string';
          };
          self: {
            description: 'The URL of the user.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          timeZone: {
            description: "The time zone specified in the user's profile. Depending on the user’s privacy setting, this may be returned as null.";
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
        xml: {
          name: 'user';
        };
      };
      UserBean: {
        additionalProperties: false;
        properties: {
          accountId: {
            description: 'The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.';
            maxLength: 128;
            type: 'string';
          };
          active: {
            description: 'Whether the user is active.';
            type: 'boolean';
          };
          avatarUrls: {
            allOf: [
              {
                $ref: '#/components/schemas/UserBeanAvatarUrls';
              },
            ];
            description: 'The avatars of the user.';
          };
          displayName: {
            description: 'The display name of the user. Depending on the user’s privacy setting, this may return an alternative value.';
            type: 'string';
          };
          key: {
            description: 'This property is deprecated in favor of `accountId` because of privacy changes. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.  \nThe key of the user.';
            type: 'string';
          };
          name: {
            description: 'This property is deprecated in favor of `accountId` because of privacy changes. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.  \nThe username of the user.';
            type: 'string';
          };
          self: {
            description: 'The URL of the user.';
            format: 'uri';
            type: 'string';
          };
        };
        type: 'object';
      };
      UserBeanAvatarUrls: {
        additionalProperties: false;
        properties: {
          '16x16': {
            description: "The URL of the user's 16x16 pixel avatar.";
            format: 'uri';
            type: 'string';
          };
          '24x24': {
            description: "The URL of the user's 24x24 pixel avatar.";
            format: 'uri';
            type: 'string';
          };
          '32x32': {
            description: "The URL of the user's 32x32 pixel avatar.";
            format: 'uri';
            type: 'string';
          };
          '48x48': {
            description: "The URL of the user's 48x48 pixel avatar.";
            format: 'uri';
            type: 'string';
          };
        };
        type: 'object';
      };
      UserColumnRequestBody: {
        additionalProperties: false;
        properties: {
          columns: {
            items: {
              type: 'string';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      UserContextVariable: {
        description: 'A [user](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#user) specified as an Atlassian account ID.';
        properties: {
          accountId: {
            description: 'The account ID of the user.';
            type: 'string';
          };
          type: {
            description: 'Type of custom context variable.';
            type: 'string';
          };
        };
        required: ['accountId', 'type'];
        type: 'object';
      };
      UserDetails: {
        additionalProperties: false;
        description: "User details permitted by the user's Atlassian Account privacy settings. However, be aware of these exceptions:\n\n *  User record deleted from Atlassian: This occurs as the result of a right to be forgotten request. In this case, `displayName` provides an indication and other parameters have default values or are blank (for example, email is blank).\n *  User record corrupted: This occurs as a results of events such as a server import and can only happen to deleted users. In this case, `accountId` returns *unknown* and all other parameters have fallback values.\n *  User record unavailable: This usually occurs due to an internal service outage. In this case, all parameters have fallback values.";
        properties: {
          accountId: {
            description: 'The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.';
            maxLength: 128;
            type: 'string';
          };
          accountType: {
            description: "The type of account represented by this user. This will be one of 'atlassian' (normal users), 'app' (application user) or 'customer' (Jira Service Desk customer user)";
            readOnly: true;
            type: 'string';
          };
          active: {
            description: 'Whether the user is active.';
            readOnly: true;
            type: 'boolean';
          };
          avatarUrls: {
            allOf: [
              {
                $ref: '#/components/schemas/AvatarUrlsBean';
              },
            ];
            description: 'The avatars of the user.';
            readOnly: true;
          };
          displayName: {
            description: 'The display name of the user. Depending on the user’s privacy settings, this may return an alternative value.';
            readOnly: true;
            type: 'string';
          };
          emailAddress: {
            description: 'The email address of the user. Depending on the user’s privacy settings, this may be returned as null.';
            readOnly: true;
            type: 'string';
          };
          key: {
            description: 'This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.';
            readOnly: true;
            type: 'string';
          };
          name: {
            description: 'This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.';
            readOnly: true;
            type: 'string';
          };
          self: {
            description: 'The URL of the user.';
            readOnly: true;
            type: 'string';
          };
          timeZone: {
            description: "The time zone specified in the user's profile. Depending on the user’s privacy settings, this may be returned as null.";
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      UserFilter: {
        description: 'Filter for a User Picker (single) custom field.';
        properties: {
          enabled: {
            description: 'Whether the filter is enabled.';
            type: 'boolean';
          };
          groups: {
            description: 'User groups autocomplete suggestion users must belong to. If not provided, the default values are used. A maximum of 10 groups can be provided.';
            items: {
              description: 'User groups autocomplete suggestion users must belong to. If not provided, the default values are used. A maximum of 10 groups can be provided.';
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          roleIds: {
            description: 'Roles that autocomplete suggestion users must belong to. If not provided, the default values are used. A maximum of 10 roles can be provided.';
            items: {
              description: 'Roles that autocomplete suggestion users must belong to. If not provided, the default values are used. A maximum of 10 roles can be provided.';
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        required: ['enabled'];
        type: 'object';
      };
      UserKey: {
        additionalProperties: false;
        description: 'List of user account IDs.';
        properties: {
          accountId: {
            description: 'The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*. Returns *unknown* if the record is deleted and corrupted, for example, as the result of a server import.';
            maxLength: 128;
            type: 'string';
          };
          key: {
            description: 'This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.';
            type: 'string';
          };
        };
        type: 'object';
      };
      UserList: {
        additionalProperties: false;
        description: 'A paginated list of users sharing the filter. This includes users that are members of the groups or can browse the projects that the filter is shared with.';
        properties: {
          'end-index': {
            description: 'The index of the last item returned on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
            xml: {
              attribute: true;
              name: 'end-index';
            };
          };
          items: {
            description: 'The list of items.';
            items: {
              $ref: '#/components/schemas/User';
            };
            readOnly: true;
            type: 'array';
          };
          'max-results': {
            description: 'The maximum number of results that could be on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
            xml: {
              attribute: true;
              name: 'max-results';
            };
          };
          size: {
            description: 'The number of items on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
            xml: {
              attribute: true;
            };
          };
          'start-index': {
            description: 'The index of the first item returned on the page.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
            xml: {
              attribute: true;
              name: 'start-index';
            };
          };
        };
        type: 'object';
      };
      UserMigrationBean: {
        additionalProperties: false;
        properties: {
          accountId: {
            type: 'string';
          };
          key: {
            type: 'string';
          };
          username: {
            type: 'string';
          };
        };
        type: 'object';
      };
      UserPermission: {
        additionalProperties: true;
        description: 'Details of a permission and its availability to a user.';
        properties: {
          deprecatedKey: {
            description: 'Indicate whether the permission key is deprecated. Note that deprecated keys cannot be used in the `permissions parameter of Get my permissions. Deprecated keys are not returned by Get all permissions.`';
            type: 'boolean';
          };
          description: {
            description: 'The description of the permission.';
            type: 'string';
          };
          havePermission: {
            description: 'Whether the permission is available to the user in the queried context.';
            type: 'boolean';
          };
          id: {
            description: 'The ID of the permission. Either `id` or `key` must be specified. Use [Get all permissions](#api-rest-api-3-permissions-get) to get the list of permissions.';
            type: 'string';
          };
          key: {
            description: 'The key of the permission. Either `id` or `key` must be specified. Use [Get all permissions](#api-rest-api-3-permissions-get) to get the list of permissions.';
            type: 'string';
          };
          name: {
            description: 'The name of the permission.';
            type: 'string';
          };
          type: {
            description: 'The type of the permission.';
            enum: ['GLOBAL', 'PROJECT'];
            type: 'string';
          };
        };
        type: 'object';
      };
      UserPickerUser: {
        additionalProperties: false;
        description: 'A user found in a search.';
        properties: {
          accountId: {
            description: 'The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.';
            type: 'string';
          };
          avatarUrl: {
            description: 'The avatar URL of the user.';
            format: 'uri';
            type: 'string';
          };
          displayName: {
            description: 'The display name of the user. Depending on the user’s privacy setting, this may be returned as null.';
            type: 'string';
          };
          html: {
            description: 'The display name, email address, and key of the user with the matched query string highlighted with the HTML bold tag.';
            type: 'string';
          };
          key: {
            description: 'This property is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.';
            type: 'string';
          };
          name: {
            description: 'This property is no longer available . See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.';
            type: 'string';
          };
        };
        type: 'object';
      };
      ValidationOptionsForCreate: {
        additionalProperties: false;
        description: 'The level of validation to return from the API. If no values are provided, the default would return `WARNING` and `ERROR` level validation results.';
        properties: {
          levels: {
            items: {
              enum: ['WARNING', 'ERROR'];
              type: 'string';
            };
            maxItems: 2;
            type: 'array';
          };
        };
        type: 'object';
      };
      ValidationOptionsForUpdate: {
        additionalProperties: false;
        description: 'The level of validation to return from the API. If no values are provided, the default would return `WARNING` and `ERROR` level validation results.';
        properties: {
          levels: {
            items: {
              enum: ['WARNING', 'ERROR'];
              type: 'string';
            };
            maxItems: 2;
            type: 'array';
          };
        };
        type: 'object';
      };
      ValueOperand: {
        description: 'An operand that is a user-provided value.';
        properties: {
          encodedValue: {
            description: 'Encoded value, which can be used directly in a JQL query.';
            type: 'string';
          };
          value: {
            description: 'The operand value.';
            type: 'string';
          };
        };
        required: ['value'];
        type: 'object';
      };
      Version: {
        additionalProperties: false;
        description: 'Details about a project version.';
        properties: {
          approvers: {
            description: 'If the expand option `approvers` is used, returns a list containing the approvers for this version.';
            items: {
              $ref: '#/components/schemas/VersionApprover';
            };
            readOnly: true;
            type: 'array';
          };
          archived: {
            description: 'Indicates that the version is archived. Optional when creating or updating a version.';
            type: 'boolean';
          };
          description: {
            description: 'The description of the version. Optional when creating or updating a version. The maximum size is 16,384 bytes.';
            type: 'string';
          };
          driver: {
            description: 'If the expand option `driver` is used, returns the Atlassian account ID of the driver.';
            readOnly: true;
            type: 'string';
          };
          expand: {
            description: 'Use [expand](em>#expansion) to include additional information about version in the response. This parameter accepts a comma-separated list. Expand options include:\n\n *  `operations` Returns the list of operations available for this version.\n *  `issuesstatus` Returns the count of issues in this version for each of the status categories *to do*, *in progress*, *done*, and *unmapped*. The *unmapped* property contains a count of issues with a status other than *to do*, *in progress*, and *done*.\n *  `driver` Returns the Atlassian account ID of the version driver.\n *  `approvers` Returns a list containing approvers for this version.\n\nOptional for create and update.';
            type: 'string';
            xml: {
              attribute: true;
            };
          };
          id: {
            description: 'The ID of the version.';
            readOnly: true;
            type: 'string';
          };
          issuesStatusForFixVersion: {
            allOf: [
              {
                $ref: '#/components/schemas/VersionIssuesStatus';
              },
            ];
            description: 'If the expand option `issuesstatus` is used, returns the count of issues in this version for each of the status categories *to do*, *in progress*, *done*, and *unmapped*. The *unmapped* property contains a count of issues with a status other than *to do*, *in progress*, and *done*.';
            readOnly: true;
          };
          moveUnfixedIssuesTo: {
            description: 'The URL of the self link to the version to which all unfixed issues are moved when a version is released. Not applicable when creating a version. Optional when updating a version.';
            format: 'uri';
            type: 'string';
          };
          name: {
            description: 'The unique name of the version. Required when creating a version. Optional when updating a version. The maximum length is 255 characters.';
            type: 'string';
          };
          operations: {
            description: 'If the expand option `operations` is used, returns the list of operations available for this version.';
            items: {
              $ref: '#/components/schemas/SimpleLink';
            };
            readOnly: true;
            type: 'array';
          };
          overdue: {
            description: 'Indicates that the version is overdue.';
            readOnly: true;
            type: 'boolean';
          };
          project: {
            description: 'Deprecated. Use `projectId`.';
            type: 'string';
          };
          projectId: {
            description: 'The ID of the project to which this version is attached. Required when creating a version. Not applicable when updating a version.';
            format: 'int64';
            type: 'integer';
          };
          releaseDate: {
            description: 'The release date of the version. Expressed in ISO 8601 format (yyyy-mm-dd). Optional when creating or updating a version.';
            format: 'date';
            type: 'string';
          };
          released: {
            description: 'Indicates that the version is released. If the version is released a request to release again is ignored. Not applicable when creating a version. Optional when updating a version.';
            type: 'boolean';
          };
          self: {
            description: 'The URL of the version.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          startDate: {
            description: 'The start date of the version. Expressed in ISO 8601 format (yyyy-mm-dd). Optional when creating or updating a version.';
            format: 'date';
            type: 'string';
          };
          userReleaseDate: {
            description: "The date on which work on this version is expected to finish, expressed in the instance's *Day/Month/Year Format* date format.";
            readOnly: true;
            type: 'string';
          };
          userStartDate: {
            description: "The date on which work on this version is expected to start, expressed in the instance's *Day/Month/Year Format* date format.";
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
        xml: {
          name: 'version';
        };
      };
      VersionApprover: {
        additionalProperties: true;
        description: 'Contains details about a version approver.';
        properties: {
          accountId: {
            description: 'The Atlassian account ID of the approver.';
            readOnly: true;
            type: 'string';
          };
          declineReason: {
            description: 'A description of why the user is declining the approval.';
            readOnly: true;
            type: 'string';
          };
          description: {
            description: 'A description of what the user is approving within the specified version.';
            readOnly: true;
            type: 'string';
          };
          status: {
            description: 'The status of the approval, which can be *PENDING*, *APPROVED*, or *DECLINED*';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
      };
      VersionIssueCounts: {
        additionalProperties: false;
        description: 'Various counts of issues within a version.';
        properties: {
          customFieldUsage: {
            description: 'List of custom fields using the version.';
            items: {
              $ref: '#/components/schemas/VersionUsageInCustomField';
            };
            readOnly: true;
            type: 'array';
          };
          issueCountWithCustomFieldsShowingVersion: {
            description: 'Count of issues where a version custom field is set to the version.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          issuesAffectedCount: {
            description: 'Count of issues where the `affectedVersion` is set to the version.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          issuesFixedCount: {
            description: 'Count of issues where the `fixVersion` is set to the version.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          self: {
            description: 'The URL of these count details.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
        xml: {
          name: 'version';
        };
      };
      VersionIssuesStatus: {
        additionalProperties: true;
        description: 'Counts of the number of issues in various statuses.';
        properties: {
          done: {
            description: 'Count of issues with status *done*.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          inProgress: {
            description: 'Count of issues with status *in progress*.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          toDo: {
            description: 'Count of issues with status *to do*.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          unmapped: {
            description: 'Count of issues with a status other than *to do*, *in progress*, and *done*.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
        };
        type: 'object';
      };
      VersionMoveBean: {
        additionalProperties: false;
        properties: {
          after: {
            description: 'The URL (self link) of the version after which to place the moved version. Cannot be used with `position`.';
            format: 'uri';
            type: 'string';
          };
          position: {
            description: 'An absolute position in which to place the moved version. Cannot be used with `after`.';
            enum: ['Earlier', 'Later', 'First', 'Last'];
            type: 'string';
          };
        };
        type: 'object';
        xml: {
          name: 'version';
        };
      };
      VersionRelatedWork: {
        additionalProperties: false;
        description: 'Associated related work to a version';
        properties: {
          category: {
            description: 'The category of the related work';
            type: 'string';
          };
          issueId: {
            description: 'The ID of the issue associated with the related work (if there is one). Cannot be updated via the Rest API.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          relatedWorkId: {
            description: 'The id of the related work. For the native release note related work item, this will be null, and Rest API does not support updating it.';
            readOnly: true;
            type: 'string';
          };
          title: {
            description: 'The title of the related work';
            type: 'string';
          };
          url: {
            description: 'The URL of the related work. Will be null for the native release note related work item, but is otherwise required.';
            format: 'uri';
            type: 'string';
          };
        };
        required: ['category'];
        type: 'object';
      };
      VersionUnresolvedIssuesCount: {
        additionalProperties: false;
        description: "Count of a version's unresolved issues.";
        properties: {
          issuesCount: {
            description: 'Count of issues.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          issuesUnresolvedCount: {
            description: 'Count of unresolved issues.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          self: {
            description: 'The URL of these count details.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
        };
        type: 'object';
        xml: {
          name: 'version';
        };
      };
      VersionUsageInCustomField: {
        additionalProperties: false;
        description: 'List of custom fields using the version.';
        properties: {
          customFieldId: {
            description: 'The ID of the custom field.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          fieldName: {
            description: 'The name of the custom field.';
            readOnly: true;
            type: 'string';
          };
          issueCountWithVersionInCustomField: {
            description: 'Count of the issues where the custom field contains the version.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
        };
        type: 'object';
      };
      Visibility: {
        additionalProperties: true;
        description: 'The group or role to which this item is visible.';
        properties: {
          identifier: {
            description: 'The ID of the group or the name of the role that visibility of this item is restricted to.';
            nullable: true;
            type: 'string';
          };
          type: {
            description: 'Whether visibility of this item is restricted to a group or role.';
            enum: ['group', 'role'];
            type: 'string';
          };
          value: {
            description: 'The name of the group or role that visibility of this item is restricted to. Please note that the name of a group is mutable, to reliably identify a group use `identifier`.';
            type: 'string';
          };
        };
        type: 'object';
      };
      Votes: {
        additionalProperties: false;
        description: 'The details of votes on an issue.';
        properties: {
          hasVoted: {
            description: 'Whether the user making this request has voted on the issue.';
            readOnly: true;
            type: 'boolean';
          };
          self: {
            description: 'The URL of these issue vote details.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          voters: {
            description: "List of the users who have voted on this issue. An empty list is returned when the calling user doesn't have the *View voters and watchers* project permission.";
            items: {
              $ref: '#/components/schemas/User';
            };
            readOnly: true;
            type: 'array';
          };
          votes: {
            description: 'The number of votes on the issue.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
        };
        type: 'object';
      };
      WarningCollection: {
        additionalProperties: false;
        properties: {
          warnings: {
            items: {
              type: 'string';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      Watchers: {
        additionalProperties: false;
        description: 'The details of watchers on an issue.';
        properties: {
          isWatching: {
            description: 'Whether the calling user is watching this issue.';
            readOnly: true;
            type: 'boolean';
          };
          self: {
            description: 'The URL of these issue watcher details.';
            readOnly: true;
            type: 'string';
          };
          watchCount: {
            description: 'The number of users watching this issue.';
            format: 'int32';
            readOnly: true;
            type: 'integer';
          };
          watchers: {
            description: 'Details of the users watching this issue.';
            items: {
              $ref: '#/components/schemas/UserDetails';
            };
            readOnly: true;
            type: 'array';
          };
        };
        type: 'object';
        xml: {
          name: 'watchers';
        };
      };
      Webhook: {
        additionalProperties: false;
        description: 'A webhook.';
        properties: {
          events: {
            description: 'The Jira events that trigger the webhook.';
            items: {
              enum: [
                'jira:issue_created',
                'jira:issue_updated',
                'jira:issue_deleted',
                'comment_created',
                'comment_updated',
                'comment_deleted',
                'issue_property_set',
                'issue_property_deleted',
              ];
              type: 'string';
            };
            type: 'array';
          };
          expirationDate: {
            description: 'The date after which the webhook is no longer sent. Use [Extend webhook life](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-webhooks/#api-rest-api-3-webhook-refresh-put) to extend the date.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          fieldIdsFilter: {
            description: 'A list of field IDs. When the issue changelog contains any of the fields, the webhook `jira:issue_updated` is sent. If this parameter is not present, the app is notified about all field updates.';
            items: {
              description: 'A list of field IDs. When the issue changelog contains any of the fields, the webhook <code>jira:issue_updated</code> is sent. If this parameter is not present, the app is notified about all field updates.';
              type: 'string';
            };
            type: 'array';
          };
          id: {
            description: 'The ID of the webhook.';
            format: 'int64';
            type: 'integer';
          };
          issuePropertyKeysFilter: {
            description: 'A list of issue property keys. A change of those issue properties triggers the `issue_property_set` or `issue_property_deleted` webhooks. If this parameter is not present, the app is notified about all issue property updates.';
            items: {
              description: 'A list of issue property keys. A change of those issue properties triggers the <code>issue_property_set</code> or <code>issue_property_deleted</code> webhooks. If this parameter is not present, the app is notified about all issue property updates.';
              type: 'string';
            };
            type: 'array';
          };
          jqlFilter: {
            description: 'The JQL filter that specifies which issues the webhook is sent for.';
            type: 'string';
          };
        };
        required: ['events', 'id', 'jqlFilter'];
        type: 'object';
      };
      WebhookDetails: {
        additionalProperties: false;
        description: 'A list of webhooks.';
        properties: {
          events: {
            description: 'The Jira events that trigger the webhook.';
            items: {
              enum: [
                'jira:issue_created',
                'jira:issue_updated',
                'jira:issue_deleted',
                'comment_created',
                'comment_updated',
                'comment_deleted',
                'issue_property_set',
                'issue_property_deleted',
              ];
              type: 'string';
            };
            type: 'array';
          };
          fieldIdsFilter: {
            description: 'A list of field IDs. When the issue changelog contains any of the fields, the webhook `jira:issue_updated` is sent. If this parameter is not present, the app is notified about all field updates.';
            items: {
              description: 'A list of field IDs. When the issue changelog contains any of the fields, the webhook <code>jira:issue_updated</code> is sent. If this parameter is not present, the app is notified about all field updates.';
              type: 'string';
            };
            type: 'array';
          };
          issuePropertyKeysFilter: {
            description: 'A list of issue property keys. A change of those issue properties triggers the `issue_property_set` or `issue_property_deleted` webhooks. If this parameter is not present, the app is notified about all issue property updates.';
            items: {
              description: 'A list of issue property keys. A change of those issue properties triggers the <code>issue_property_set</code> or <code>issue_property_deleted</code> webhooks. If this parameter is not present, the app is notified about all issue property updates.';
              type: 'string';
            };
            type: 'array';
          };
          jqlFilter: {
            description: 'The JQL filter that specifies which issues the webhook is sent for. Only a subset of JQL can be used. The supported elements are:\n\n *  Fields: `issueKey`, `project`, `issuetype`, `status`, `assignee`, `reporter`, `issue.property`, and `cf[id]`. For custom fields (`cf[id]`), only the epic label custom field is supported.".\n *  Operators: `=`, `!=`, `IN`, and `NOT IN`.';
            type: 'string';
          };
        };
        required: ['events', 'jqlFilter'];
        type: 'object';
      };
      WebhookRegistrationDetails: {
        additionalProperties: false;
        description: 'Details of webhooks to register.';
        properties: {
          url: {
            description: 'The URL that specifies where to send the webhooks. This URL must use the same base URL as the Connect app. Only a single URL per app is allowed to be registered.';
            type: 'string';
          };
          webhooks: {
            description: 'A list of webhooks.';
            items: {
              $ref: '#/components/schemas/WebhookDetails';
            };
            type: 'array';
          };
        };
        required: ['url', 'webhooks'];
        type: 'object';
      };
      WebhooksExpirationDate: {
        additionalProperties: false;
        description: 'The date the refreshed webhooks expire.';
        properties: {
          expirationDate: {
            description: 'The expiration date of all the refreshed webhooks.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
        };
        required: ['expirationDate'];
        type: 'object';
      };
      WorkManagementNavigationInfo: {
        properties: {
          boardName: {
            type: 'string';
          };
        };
        type: 'object';
      };
      Workflow: {
        additionalProperties: false;
        description: 'Details about a workflow.';
        properties: {
          created: {
            description: 'The creation date of the workflow.';
            format: 'date-time';
            type: 'string';
          };
          description: {
            description: 'The description of the workflow.';
            type: 'string';
          };
          hasDraftWorkflow: {
            description: 'Whether the workflow has a draft version.';
            type: 'boolean';
          };
          id: {
            $ref: '#/components/schemas/PublishedWorkflowId';
          };
          isDefault: {
            description: 'Whether this is the default workflow.';
            type: 'boolean';
          };
          operations: {
            $ref: '#/components/schemas/WorkflowOperations';
          };
          projects: {
            description: 'The projects the workflow is assigned to, through workflow schemes.';
            items: {
              $ref: '#/components/schemas/ProjectDetails';
            };
            type: 'array';
          };
          schemes: {
            description: 'The workflow schemes the workflow is assigned to.';
            items: {
              $ref: '#/components/schemas/WorkflowSchemeIdName';
            };
            type: 'array';
          };
          statuses: {
            description: 'The statuses of the workflow.';
            items: {
              $ref: '#/components/schemas/WorkflowStatus';
            };
            type: 'array';
          };
          transitions: {
            description: 'The transitions of the workflow.';
            items: {
              $ref: '#/components/schemas/Transition';
            };
            type: 'array';
          };
          updated: {
            description: 'The last edited date of the workflow.';
            format: 'date-time';
            type: 'string';
          };
        };
        required: ['description', 'id'];
        type: 'object';
      };
      WorkflowAssociationStatusMapping: {
        additionalProperties: false;
        description: 'The list of status mappings.';
        properties: {
          newStatusId: {
            description: 'The ID of the status in the new workflow.';
            type: 'string';
          };
          oldStatusId: {
            description: "The ID of the status in the old workflow that isn't present in the new workflow.";
            type: 'string';
          };
        };
        required: ['newStatusId', 'oldStatusId'];
        type: 'object';
      };
      WorkflowCapabilities: {
        additionalProperties: false;
        properties: {
          connectRules: {
            description: 'The Connect provided ecosystem rules available.';
            items: {
              $ref: '#/components/schemas/AvailableWorkflowConnectRule';
            };
            type: 'array';
          };
          editorScope: {
            description: 'The scope of the workflow capabilities. `GLOBAL` for company-managed projects and `PROJECT` for team-managed projects.';
            enum: ['PROJECT', 'GLOBAL'];
            type: 'string';
          };
          forgeRules: {
            description: 'The Forge provided ecosystem rules available.';
            items: {
              $ref: '#/components/schemas/AvailableWorkflowForgeRule';
            };
            type: 'array';
          };
          projectTypes: {
            description: 'The types of projects that this capability set is available for.';
            items: {
              enum: ['software', 'service_desk', 'product_discovery', 'business', 'unknown'];
              type: 'string';
            };
            type: 'array';
          };
          systemRules: {
            description: 'The Atlassian provided system rules available.';
            items: {
              $ref: '#/components/schemas/AvailableWorkflowSystemRule';
            };
            type: 'array';
          };
          triggerRules: {
            description: 'The trigger rules available.';
            items: {
              $ref: '#/components/schemas/AvailableWorkflowTriggers';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      WorkflowCompoundCondition: {
        description: 'A compound workflow transition rule condition. This object returns `nodeType` as `compound`.';
        properties: {
          conditions: {
            description: 'The list of workflow conditions.';
            items: {
              $ref: '#/components/schemas/WorkflowCondition';
            };
            type: 'array';
          };
          nodeType: {
            type: 'string';
          };
          operator: {
            description: 'The compound condition operator.';
            enum: ['AND', 'OR'];
            type: 'string';
          };
        };
        required: ['conditions', 'nodeType', 'operator'];
        type: 'object';
      };
      WorkflowCondition: {
        additionalProperties: false;
        description: 'The workflow transition rule conditions tree.';
        discriminator: {
          mapping: {
            compound: '#/components/schemas/WorkflowCompoundCondition';
            simple: '#/components/schemas/WorkflowSimpleCondition';
          };
          propertyName: 'nodeType';
        };
        oneOf: [
          {
            $ref: '#/components/schemas/WorkflowSimpleCondition';
          },
          {
            $ref: '#/components/schemas/WorkflowCompoundCondition';
          },
        ];
        type: 'object';
      };
      WorkflowCreate: {
        additionalProperties: false;
        description: 'The details of the workflows to create.';
        maximum: 20;
        properties: {
          description: {
            description: 'The description of the workflow to create.';
            type: 'string';
          };
          name: {
            description: 'The name of the workflow to create.';
            type: 'string';
          };
          startPointLayout: {
            $ref: '#/components/schemas/WorkflowLayout';
          };
          statuses: {
            description: 'The statuses associated with this workflow.';
            items: {
              $ref: '#/components/schemas/StatusLayoutUpdate';
            };
            type: 'array';
          };
          transitions: {
            description: 'The transitions of this workflow.';
            items: {
              $ref: '#/components/schemas/TransitionUpdateDTO';
            };
            type: 'array';
          };
        };
        required: ['name', 'statuses', 'transitions'];
        type: 'object';
      };
      WorkflowCreateRequest: {
        additionalProperties: false;
        description: 'The create workflows payload.';
        properties: {
          scope: {
            $ref: '#/components/schemas/WorkflowScope';
          };
          statuses: {
            description: 'The statuses to associate with the workflows.';
            items: {
              $ref: '#/components/schemas/WorkflowStatusUpdate';
            };
            maximum: 1000;
            type: 'array';
          };
          workflows: {
            description: 'The details of the workflows to create.';
            items: {
              $ref: '#/components/schemas/WorkflowCreate';
            };
            maximum: 20;
            type: 'array';
          };
        };
        required: ['scope', 'statuses', 'workflows'];
        type: 'object';
      };
      WorkflowCreateResponse: {
        additionalProperties: false;
        description: 'Details of the created workflows and statuses.';
        properties: {
          statuses: {
            description: 'List of created statuses.';
            items: {
              $ref: '#/components/schemas/JiraWorkflowStatus';
            };
            type: 'array';
            uniqueItems: true;
          };
          workflows: {
            description: 'List of created workflows.';
            items: {
              $ref: '#/components/schemas/JiraWorkflow';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        type: 'object';
      };
      WorkflowCreateValidateRequest: {
        additionalProperties: false;
        properties: {
          payload: {
            $ref: '#/components/schemas/WorkflowCreateRequest';
          };
          validationOptions: {
            $ref: '#/components/schemas/ValidationOptionsForCreate';
          };
        };
        required: ['payload'];
        type: 'object';
      };
      WorkflowElementReference: {
        additionalProperties: false;
        description: 'A reference to the location of the error. This will be null if the error does not refer to a specific element.';
        properties: {
          propertyKey: {
            description: 'A property key.';
            type: 'string';
          };
          ruleId: {
            description: 'A rule ID.';
            type: 'string';
          };
          statusMappingReference: {
            $ref: '#/components/schemas/ProjectAndIssueTypePair';
          };
          statusReference: {
            description: 'A status reference.';
            type: 'string';
          };
          transitionId: {
            description: 'A transition ID.';
            type: 'string';
          };
        };
        type: 'object';
      };
      WorkflowIDs: {
        additionalProperties: false;
        description: 'The classic workflow identifiers.';
        properties: {
          entityId: {
            description: 'The entity ID of the workflow.';
            type: 'string';
          };
          name: {
            description: 'The name of the workflow.';
            type: 'string';
          };
        };
        required: ['name'];
        type: 'object';
      };
      WorkflowId: {
        additionalProperties: false;
        description: 'Properties that identify a workflow.';
        properties: {
          draft: {
            description: 'Whether the workflow is in the draft state.';
            type: 'boolean';
          };
          name: {
            description: 'The name of the workflow.';
            type: 'string';
          };
        };
        required: ['draft', 'name'];
        type: 'object';
      };
      WorkflowLayout: {
        additionalProperties: false;
        description: 'The starting point for the statuses in the workflow.';
        nullable: true;
        properties: {
          x: {
            description: 'The x axis location.';
            format: 'double';
            type: 'number';
          };
          y: {
            description: 'The y axis location.';
            format: 'double';
            type: 'number';
          };
        };
        type: 'object';
      };
      WorkflowMetadataAndIssueTypeRestModel: {
        additionalProperties: false;
        description: 'The workflow metadata and issue type IDs which use this workflow.';
        properties: {
          issueTypeIds: {
            description: 'The list of issue type IDs for the mapping.';
            items: {
              description: 'The list of issue type IDs for the mapping.';
              type: 'string';
            };
            type: 'array';
          };
          workflow: {
            $ref: '#/components/schemas/WorkflowMetadataRestModel';
          };
        };
        required: ['issueTypeIds', 'workflow'];
        type: 'object';
      };
      WorkflowMetadataRestModel: {
        additionalProperties: false;
        description: 'Workflow metadata and usage detail.';
        properties: {
          description: {
            description: 'The description of the workflow.';
            type: 'string';
          };
          id: {
            description: 'The ID of the workflow.';
            type: 'string';
          };
          name: {
            description: 'The name of the workflow.';
            type: 'string';
          };
          usage: {
            description: 'Use the optional `workflows.usages` expand to get additional information about the projects and issue types associated with the workflows in the workflow scheme.';
            items: {
              $ref: '#/components/schemas/SimpleUsage';
            };
            type: 'array';
          };
          version: {
            $ref: '#/components/schemas/DocumentVersion';
          };
        };
        required: ['description', 'id', 'name', 'usage', 'version'];
        type: 'object';
      };
      WorkflowOperations: {
        additionalProperties: false;
        description: 'Operations allowed on a workflow';
        properties: {
          canDelete: {
            description: 'Whether the workflow can be deleted.';
            type: 'boolean';
          };
          canEdit: {
            description: 'Whether the workflow can be updated.';
            type: 'boolean';
          };
        };
        required: ['canDelete', 'canEdit'];
        type: 'object';
      };
      WorkflowReadRequest: {
        additionalProperties: false;
        properties: {
          projectAndIssueTypes: {
            description: 'The list of projects and issue types to query.';
            items: {
              $ref: '#/components/schemas/ProjectAndIssueTypePair';
            };
            type: 'array';
          };
          workflowIds: {
            description: 'The list of workflow IDs to query.';
            items: {
              description: 'The list of workflow IDs to query.';
              type: 'string';
            };
            type: 'array';
          };
          workflowNames: {
            description: 'The list of workflow names to query.';
            items: {
              description: 'The list of workflow names to query.';
              type: 'string';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      WorkflowReadResponse: {
        additionalProperties: false;
        description: 'Details of workflows and related statuses.';
        properties: {
          statuses: {
            description: 'List of statuses.';
            items: {
              $ref: '#/components/schemas/JiraWorkflowStatus';
            };
            type: 'array';
            uniqueItems: true;
          };
          workflows: {
            description: 'List of workflows.';
            items: {
              $ref: '#/components/schemas/JiraWorkflow';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        type: 'object';
      };
      WorkflowReferenceStatus: {
        additionalProperties: false;
        description: 'The statuses referenced in the workflow.';
        properties: {
          approvalConfiguration: {
            $ref: '#/components/schemas/ApprovalConfiguration';
          };
          deprecated: {
            description: 'Indicates if the status is deprecated.';
            type: 'boolean';
          };
          layout: {
            $ref: '#/components/schemas/WorkflowStatusLayout';
          };
          properties: {
            additionalProperties: {
              description: 'The properties associated with the status.';
              type: 'string';
            };
            description: 'The properties associated with the status.';
            type: 'object';
          };
          statusReference: {
            description: 'The reference of the status.';
            type: 'string';
          };
        };
        type: 'object';
      };
      WorkflowRuleConfiguration: {
        additionalProperties: false;
        description: 'The configuration of the rule.';
        nullable: true;
        properties: {
          id: {
            description: 'The ID of the rule.';
            nullable: true;
            type: 'string';
          };
          parameters: {
            additionalProperties: {
              description: 'The parameters related to the rule.';
              type: 'string';
            };
            description: 'The parameters related to the rule.';
            type: 'object';
          };
          ruleKey: {
            description: 'The rule key of the rule.';
            type: 'string';
          };
        };
        required: ['ruleKey'];
        type: 'object';
      };
      WorkflowRules: {
        additionalProperties: false;
        description: 'A collection of transition rules.';
        properties: {
          conditionsTree: {
            $ref: '#/components/schemas/WorkflowCondition';
          };
          postFunctions: {
            description: 'The workflow post functions.';
            items: {
              $ref: '#/components/schemas/WorkflowTransitionRule';
            };
            type: 'array';
          };
          validators: {
            description: 'The workflow validators.';
            items: {
              $ref: '#/components/schemas/WorkflowTransitionRule';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      WorkflowRulesSearch: {
        description: 'Details of the workflow and its transition rules.';
        properties: {
          expand: {
            description: 'Use expand to include additional information in the response. This parameter accepts `transition` which, for each rule, returns information about the transition the rule is assigned to.';
            example: 'transition';
            type: 'string';
          };
          ruleIds: {
            description: 'The list of workflow rule IDs.';
            items: {
              description: 'Workflow rule ID.';
              example: '55d44f1d-c859-42e5-9c27-2c5ec3f340b1';
              format: 'uuid';
              type: 'string';
            };
            maxItems: 10;
            minItems: 1;
            type: 'array';
          };
          workflowEntityId: {
            description: 'The workflow ID.';
            example: 'a498d711-685d-428d-8c3e-bc03bb450ea7';
            format: 'uuid';
            type: 'string';
          };
        };
        required: ['ruleIds', 'workflowEntityId'];
        type: 'object';
      };
      WorkflowRulesSearchDetails: {
        description: 'Details of workflow transition rules.';
        properties: {
          invalidRules: {
            description: 'List of workflow rule IDs that do not belong to the workflow or can not be found.';
            items: {
              description: 'Workflow rule ID.';
              example: '55d44f1d-c859-42e5-9c27-2c5ec3f340b1';
              format: 'uuid';
              type: 'string';
            };
            type: 'array';
          };
          validRules: {
            description: 'List of valid workflow transition rules.';
            items: {
              $ref: '#/components/schemas/WorkflowTransitionRules';
            };
            type: 'array';
          };
          workflowEntityId: {
            description: 'The workflow ID.';
            example: 'a498d711-685d-428d-8c3e-bc03bb450ea7';
            format: 'uuid';
            type: 'string';
          };
        };
        type: 'object';
      };
      WorkflowScheme: {
        additionalProperties: false;
        description: 'Details about a workflow scheme.';
        properties: {
          defaultWorkflow: {
            description: 'The name of the default workflow for the workflow scheme. The default workflow has *All Unassigned Issue Types* assigned to it in Jira. If `defaultWorkflow` is not specified when creating a workflow scheme, it is set to *Jira Workflow (jira)*.';
            type: 'string';
          };
          description: {
            description: 'The description of the workflow scheme.';
            type: 'string';
          };
          draft: {
            description: 'Whether the workflow scheme is a draft or not.';
            readOnly: true;
            type: 'boolean';
          };
          id: {
            description: 'The ID of the workflow scheme.';
            format: 'int64';
            readOnly: true;
            type: 'integer';
          };
          issueTypeMappings: {
            additionalProperties: {
              type: 'string';
            };
            description: 'The issue type to workflow mappings, where each mapping is an issue type ID and workflow name pair. Note that an issue type can only be mapped to one workflow in a workflow scheme.';
            type: 'object';
          };
          issueTypes: {
            additionalProperties: {
              $ref: '#/components/schemas/IssueTypeDetails';
            };
            description: 'The issue types available in Jira.';
            readOnly: true;
            type: 'object';
          };
          lastModified: {
            description: 'The date-time that the draft workflow scheme was last modified. A modification is a change to the issue type-project mappings only. This property does not apply to non-draft workflows.';
            readOnly: true;
            type: 'string';
          };
          lastModifiedUser: {
            allOf: [
              {
                $ref: '#/components/schemas/User';
              },
            ];
            description: 'The user that last modified the draft workflow scheme. A modification is a change to the issue type-project mappings only. This property does not apply to non-draft workflows.';
            readOnly: true;
          };
          name: {
            description: 'The name of the workflow scheme. The name must be unique. The maximum length is 255 characters. Required when creating a workflow scheme.';
            type: 'string';
          };
          originalDefaultWorkflow: {
            description: 'For draft workflow schemes, this property is the name of the default workflow for the original workflow scheme. The default workflow has *All Unassigned Issue Types* assigned to it in Jira.';
            readOnly: true;
            type: 'string';
          };
          originalIssueTypeMappings: {
            additionalProperties: {
              readOnly: true;
              type: 'string';
            };
            description: 'For draft workflow schemes, this property is the issue type to workflow mappings for the original workflow scheme, where each mapping is an issue type ID and workflow name pair. Note that an issue type can only be mapped to one workflow in a workflow scheme.';
            readOnly: true;
            type: 'object';
          };
          self: {
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          updateDraftIfNeeded: {
            description: 'Whether to create or update a draft workflow scheme when updating an active workflow scheme. An active workflow scheme is a workflow scheme that is used by at least one project. The following examples show how this property works:\n\n *  Update an active workflow scheme with `updateDraftIfNeeded` set to `true`: If a draft workflow scheme exists, it is updated. Otherwise, a draft workflow scheme is created.\n *  Update an active workflow scheme with `updateDraftIfNeeded` set to `false`: An error is returned, as active workflow schemes cannot be updated.\n *  Update an inactive workflow scheme with `updateDraftIfNeeded` set to `true`: The workflow scheme is updated, as inactive workflow schemes do not require drafts to update.\n\nDefaults to `false`.';
            type: 'boolean';
          };
        };
        type: 'object';
      };
      WorkflowSchemeAssociation: {
        additionalProperties: false;
        description: 'The explicit association between issue types and a workflow in a workflow scheme.';
        properties: {
          issueTypeIds: {
            description: 'The issue types assigned to the workflow.';
            items: {
              description: 'The issue types assigned to the workflow.';
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          workflowId: {
            description: 'The ID of the workflow.';
            type: 'string';
          };
        };
        required: ['issueTypeIds', 'workflowId'];
        type: 'object';
      };
      WorkflowSchemeAssociations: {
        additionalProperties: false;
        description: 'A workflow scheme along with a list of projects that use it.';
        properties: {
          projectIds: {
            description: 'The list of projects that use the workflow scheme.';
            items: {
              type: 'string';
            };
            type: 'array';
          };
          workflowScheme: {
            allOf: [
              {
                $ref: '#/components/schemas/WorkflowScheme';
              },
            ];
            description: 'The workflow scheme.';
          };
        };
        required: ['projectIds', 'workflowScheme'];
        type: 'object';
      };
      WorkflowSchemeIdName: {
        additionalProperties: false;
        description: 'The ID and the name of the workflow scheme.';
        properties: {
          id: {
            description: 'The ID of the workflow scheme.';
            type: 'string';
          };
          name: {
            description: 'The name of the workflow scheme.';
            type: 'string';
          };
        };
        required: ['id', 'name'];
        type: 'object';
      };
      WorkflowSchemeProjectAssociation: {
        additionalProperties: false;
        description: 'An associated workflow scheme and project.';
        properties: {
          projectId: {
            description: 'The ID of the project.';
            type: 'string';
          };
          workflowSchemeId: {
            description: 'The ID of the workflow scheme. If the workflow scheme ID is `null`, the operation assigns the default workflow scheme.';
            type: 'string';
          };
        };
        required: ['projectId'];
        type: 'object';
      };
      WorkflowSchemeReadRequest: {
        additionalProperties: false;
        description: 'The workflow scheme read request body.';
        properties: {
          projectIds: {
            description: 'The list of project IDs to query.';
            items: {
              description: 'The list of project IDs to query.';
              nullable: true;
              type: 'string';
            };
            nullable: true;
            type: 'array';
          };
          workflowSchemeIds: {
            description: 'The list of workflow scheme IDs to query.';
            items: {
              description: 'The list of workflow scheme IDs to query.';
              nullable: true;
              type: 'string';
            };
            nullable: true;
            type: 'array';
          };
        };
        type: 'object';
      };
      WorkflowSchemeReadResponse: {
        additionalProperties: false;
        properties: {
          defaultWorkflow: {
            $ref: '#/components/schemas/WorkflowMetadataRestModel';
          };
          description: {
            description: 'The description of the workflow scheme.';
            nullable: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the workflow scheme.';
            type: 'string';
          };
          name: {
            description: 'The name of the workflow scheme.';
            type: 'string';
          };
          projectIdsUsingScheme: {
            description: 'The IDs of projects using the workflow scheme.';
            items: {
              description: 'The IDs of projects using the workflow scheme.';
              type: 'string';
            };
            type: 'array';
          };
          scope: {
            $ref: '#/components/schemas/WorkflowScope';
          };
          taskId: {
            description: "Indicates if there's an [asynchronous task](#async-operations) for this workflow scheme.";
            nullable: true;
            type: 'string';
          };
          version: {
            $ref: '#/components/schemas/DocumentVersion';
          };
          workflowsForIssueTypes: {
            description: 'Mappings from workflows to issue types.';
            items: {
              $ref: '#/components/schemas/WorkflowMetadataAndIssueTypeRestModel';
            };
            type: 'array';
          };
        };
        required: ['id', 'name', 'projectIdsUsingScheme', 'scope', 'version', 'workflowsForIssueTypes'];
        type: 'object';
      };
      WorkflowSchemeUpdateRequest: {
        additionalProperties: true;
        description: 'The update workflow scheme payload.';
        properties: {
          defaultWorkflowId: {
            description: "The ID of the workflow for issue types without having a mapping defined in this workflow scheme. Only used in global-scoped workflow schemes. If the `defaultWorkflowId` isn't specified, this is set to *Jira Workflow (jira)*.";
            type: 'string';
          };
          description: {
            description: 'The new description for this workflow scheme.';
            type: 'string';
          };
          id: {
            description: 'The ID of this workflow scheme.';
            type: 'string';
          };
          name: {
            description: 'The new name for this workflow scheme.';
            type: 'string';
          };
          statusMappingsByIssueTypeOverride: {
            description: "Overrides, for the selected issue types, any status mappings provided in `statusMappingsByWorkflows`. Status mappings are required when the new workflow for an issue type doesn't contain all statuses that the old workflow has. Status mappings can be provided by a combination of `statusMappingsByWorkflows` and `statusMappingsByIssueTypeOverride`.";
            items: {
              $ref: '#/components/schemas/MappingsByIssueTypeOverride';
            };
            type: 'array';
          };
          statusMappingsByWorkflows: {
            description: "The status mappings by workflows. Status mappings are required when the new workflow for an issue type doesn't contain all statuses that the old workflow has. Status mappings can be provided by a combination of `statusMappingsByWorkflows` and `statusMappingsByIssueTypeOverride`.";
            items: {
              $ref: '#/components/schemas/MappingsByWorkflow';
            };
            type: 'array';
          };
          version: {
            $ref: '#/components/schemas/DocumentVersion';
          };
          workflowsForIssueTypes: {
            description: 'Mappings from workflows to issue types.';
            items: {
              $ref: '#/components/schemas/WorkflowSchemeAssociation';
            };
            type: 'array';
          };
        };
        required: ['description', 'id', 'name', 'version'];
        type: 'object';
      };
      WorkflowSchemeUpdateRequiredMappingsRequest: {
        additionalProperties: false;
        description: 'The request payload to get the required mappings for updating a workflow scheme.';
        properties: {
          defaultWorkflowId: {
            description: "The ID of the new default workflow for this workflow scheme. Only used in global-scoped workflow schemes. If it isn't specified, is set to *Jira Workflow (jira)*.";
            nullable: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the workflow scheme.';
            type: 'string';
          };
          workflowsForIssueTypes: {
            description: 'The new workflow to issue type mappings for this workflow scheme.';
            items: {
              $ref: '#/components/schemas/WorkflowSchemeAssociation';
            };
            type: 'array';
          };
        };
        required: ['id', 'workflowsForIssueTypes'];
        type: 'object';
      };
      WorkflowSchemeUpdateRequiredMappingsResponse: {
        additionalProperties: false;
        properties: {
          statusMappingsByIssueTypes: {
            description: 'The list of required status mappings by issue type.';
            items: {
              $ref: '#/components/schemas/RequiredMappingByIssueType';
            };
            type: 'array';
            uniqueItems: true;
          };
          statusMappingsByWorkflows: {
            description: 'The list of required status mappings by workflow.';
            items: {
              $ref: '#/components/schemas/RequiredMappingByWorkflows';
            };
            type: 'array';
            uniqueItems: true;
          };
          statuses: {
            description: 'The details of the statuses in the associated workflows.';
            items: {
              $ref: '#/components/schemas/StatusMetadata';
            };
            type: 'array';
            uniqueItems: true;
          };
          statusesPerWorkflow: {
            description: 'The statuses associated with each workflow.';
            items: {
              $ref: '#/components/schemas/StatusesPerWorkflow';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        type: 'object';
      };
      WorkflowScope: {
        additionalProperties: false;
        description: 'The scope of the workflow.';
        properties: {
          project: {
            $ref: '#/components/schemas/ProjectId';
          };
          type: {
            description: 'The scope of the workflow. `GLOBAL` for company-managed projects and `PROJECT` for team-managed projects.';
            enum: ['PROJECT', 'GLOBAL'];
            type: 'string';
          };
        };
        required: ['type'];
        type: 'object';
      };
      WorkflowSimpleCondition: {
        description: 'A workflow transition rule condition. This object returns `nodeType` as `simple`.';
        properties: {
          configuration: {
            description: 'EXPERIMENTAL. The configuration of the transition rule.';
            type: 'object';
          };
          nodeType: {
            type: 'string';
          };
          type: {
            description: 'The type of the transition rule.';
            type: 'string';
          };
        };
        required: ['nodeType', 'type'];
        type: 'object';
      };
      WorkflowStatus: {
        additionalProperties: false;
        description: 'Details of a workflow status.';
        properties: {
          id: {
            description: 'The ID of the issue status.';
            type: 'string';
          };
          name: {
            description: 'The name of the status in the workflow.';
            type: 'string';
          };
          properties: {
            additionalProperties: {
              description: 'Additional properties that modify the behavior of issues in this status. Supports the properties <code>jira.issue.editable</code> and <code>issueEditable</code> (deprecated) that indicate whether issues are editable.';
            };
            description: 'Additional properties that modify the behavior of issues in this status. Supports the properties `jira.issue.editable` and `issueEditable` (deprecated) that indicate whether issues are editable.';
            type: 'object';
          };
        };
        required: ['id', 'name'];
        type: 'object';
      };
      WorkflowStatusAndPort: {
        additionalProperties: false;
        deprecated: true;
        description: 'The status reference and port that a transition is connected to.';
        nullable: true;
        properties: {
          port: {
            description: 'The port the transition is connected to this status.';
            format: 'int32';
            nullable: true;
            type: 'integer';
          };
          statusReference: {
            description: 'The reference of this status.';
            type: 'string';
          };
        };
        type: 'object';
      };
      WorkflowStatusLayout: {
        additionalProperties: false;
        description: 'The x and y location of the status in the workflow.';
        nullable: true;
        properties: {
          x: {
            description: 'The x axis location.';
            format: 'double';
            nullable: true;
            type: 'number';
          };
          y: {
            description: 'The y axis location.';
            format: 'double';
            nullable: true;
            type: 'number';
          };
        };
        type: 'object';
      };
      WorkflowStatusUpdate: {
        additionalProperties: true;
        description: 'Details of the status being updated.';
        maximum: 1000;
        properties: {
          description: {
            description: 'The description of the status.';
            type: 'string';
          };
          id: {
            description: 'The ID of the status.';
            type: 'string';
          };
          name: {
            description: 'The name of the status.';
            type: 'string';
          };
          statusCategory: {
            description: 'The category of the status.';
            enum: ['TODO', 'IN_PROGRESS', 'DONE'];
            type: 'string';
          };
          statusReference: {
            description: 'The reference of the status.';
            type: 'string';
          };
        };
        required: ['name', 'statusCategory', 'statusReference'];
        type: 'object';
      };
      WorkflowTransition: {
        additionalProperties: false;
        description: 'A workflow transition.';
        properties: {
          id: {
            description: 'The transition ID.';
            format: 'int32';
            type: 'integer';
          };
          name: {
            description: 'The transition name.';
            type: 'string';
          };
        };
        required: ['id', 'name'];
        type: 'object';
      };
      WorkflowTransitionLinks: {
        additionalProperties: false;
        description: 'The statuses the transition can start from, and the mapping of ports between the statuses.';
        nullable: true;
        properties: {
          fromPort: {
            description: 'The port that the transition starts from.';
            format: 'int32';
            nullable: true;
            type: 'integer';
          };
          fromStatusReference: {
            description: 'The status that the transition starts from.';
            nullable: true;
            type: 'string';
          };
          toPort: {
            description: 'The port that the transition goes to.';
            format: 'int32';
            nullable: true;
            type: 'integer';
          };
        };
        type: 'object';
      };
      WorkflowTransitionProperty: {
        additionalProperties: true;
        description: 'Details about the server Jira is running on.';
        properties: {
          id: {
            description: 'The ID of the transition property.';
            readOnly: true;
            type: 'string';
          };
          key: {
            description: 'The key of the transition property. Also known as the name of the transition property.';
            readOnly: true;
            type: 'string';
          };
          value: {
            description: 'The value of the transition property.';
            type: 'string';
          };
        };
        required: ['value'];
        type: 'object';
      };
      WorkflowTransitionRule: {
        additionalProperties: false;
        description: 'A workflow transition rule.';
        properties: {
          configuration: {
            description: 'EXPERIMENTAL. The configuration of the transition rule.';
          };
          type: {
            description: 'The type of the transition rule.';
            type: 'string';
          };
        };
        required: ['type'];
        type: 'object';
      };
      WorkflowTransitionRules: {
        additionalProperties: false;
        description: 'A workflow with transition rules.';
        properties: {
          conditions: {
            description: 'The list of conditions within the workflow.';
            items: {
              $ref: '#/components/schemas/AppWorkflowTransitionRule';
            };
            type: 'array';
          };
          postFunctions: {
            description: 'The list of post functions within the workflow.';
            items: {
              $ref: '#/components/schemas/AppWorkflowTransitionRule';
            };
            type: 'array';
          };
          validators: {
            description: 'The list of validators within the workflow.';
            items: {
              $ref: '#/components/schemas/AppWorkflowTransitionRule';
            };
            type: 'array';
          };
          workflowId: {
            $ref: '#/components/schemas/WorkflowId';
          };
        };
        required: ['workflowId'];
        type: 'object';
      };
      WorkflowTransitionRulesDetails: {
        additionalProperties: false;
        description: 'Details about a workflow configuration update request.';
        properties: {
          workflowId: {
            $ref: '#/components/schemas/WorkflowId';
          };
          workflowRuleIds: {
            description: 'The list of connect workflow rule IDs.';
            items: {
              description: 'The list of connect workflow rule IDs.';
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        required: ['workflowId', 'workflowRuleIds'];
        type: 'object';
      };
      WorkflowTransitionRulesUpdate: {
        additionalProperties: false;
        description: 'Details about a workflow configuration update request.';
        properties: {
          workflows: {
            description: 'The list of workflows with transition rules to update.';
            items: {
              $ref: '#/components/schemas/WorkflowTransitionRules';
            };
            type: 'array';
          };
        };
        required: ['workflows'];
        type: 'object';
      };
      WorkflowTransitionRulesUpdateErrorDetails: {
        additionalProperties: false;
        description: 'Details of any errors encountered while updating workflow transition rules for a workflow.';
        properties: {
          ruleUpdateErrors: {
            additionalProperties: {
              description: "A list of transition rule update errors, indexed by the transition rule ID. Any transition rule that appears here wasn't updated.";
              items: {
                description: "A list of transition rule update errors, indexed by the transition rule ID. Any transition rule that appears here wasn't updated.";
                type: 'string';
              };
              type: 'array';
              uniqueItems: true;
            };
            description: "A list of transition rule update errors, indexed by the transition rule ID. Any transition rule that appears here wasn't updated.";
            type: 'object';
          };
          updateErrors: {
            description: 'The list of errors that specify why the workflow update failed. The workflow was not updated if the list contains any entries.';
            items: {
              description: 'An error specifying why the workflow update failed.';
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          workflowId: {
            $ref: '#/components/schemas/WorkflowId';
          };
        };
        required: ['ruleUpdateErrors', 'updateErrors', 'workflowId'];
        type: 'object';
      };
      WorkflowTransitionRulesUpdateErrors: {
        additionalProperties: false;
        description: 'Details of any errors encountered while updating workflow transition rules.';
        properties: {
          updateResults: {
            description: 'A list of workflows.';
            items: {
              $ref: '#/components/schemas/WorkflowTransitionRulesUpdateErrorDetails';
            };
            type: 'array';
          };
        };
        required: ['updateResults'];
        type: 'object';
      };
      WorkflowTransitions: {
        additionalProperties: false;
        description: 'The transitions of the workflow. Note that a transition can have either the deprecated `to`/`from` fields or the `toStatusReference`/`links` fields, but never both nor a combination.';
        properties: {
          actions: {
            description: 'The post-functions of the transition.';
            items: {
              $ref: '#/components/schemas/WorkflowRuleConfiguration';
            };
            type: 'array';
          };
          conditions: {
            $ref: '#/components/schemas/ConditionGroupConfiguration';
          };
          customIssueEventId: {
            description: 'The custom event ID of the transition.';
            nullable: true;
            type: 'string';
          };
          description: {
            description: 'The description of the transition.';
            type: 'string';
          };
          from: {
            deprecated: true;
            description: 'The statuses and ports that the transition can start from. This field is deprecated - use `toStatusReference`/`links` instead.';
            items: {
              $ref: '#/components/schemas/WorkflowStatusAndPort';
            };
            type: 'array';
          };
          id: {
            description: 'The ID of the transition.';
            type: 'string';
          };
          links: {
            description: 'The statuses the transition can start from, and the mapping of ports between the statuses.';
            items: {
              $ref: '#/components/schemas/WorkflowTransitionLinks';
            };
            type: 'array';
          };
          name: {
            description: 'The name of the transition.';
            type: 'string';
          };
          properties: {
            additionalProperties: {
              description: 'The properties of the transition.';
              type: 'string';
            };
            description: 'The properties of the transition.';
            type: 'object';
          };
          to: {
            $ref: '#/components/schemas/WorkflowStatusAndPort';
          };
          toStatusReference: {
            description: 'The status the transition goes to.';
            type: 'string';
          };
          transitionScreen: {
            $ref: '#/components/schemas/WorkflowRuleConfiguration';
          };
          triggers: {
            description: 'The triggers of the transition.';
            items: {
              $ref: '#/components/schemas/WorkflowTrigger';
            };
            type: 'array';
          };
          type: {
            description: 'The transition type.';
            enum: ['INITIAL', 'GLOBAL', 'DIRECTED'];
            type: 'string';
          };
          validators: {
            description: 'The validators of the transition.';
            items: {
              $ref: '#/components/schemas/WorkflowRuleConfiguration';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      WorkflowTrigger: {
        additionalProperties: false;
        description: 'The trigger configuration associated with a workflow.';
        properties: {
          id: {
            description: 'The ID of the trigger.';
            type: 'string';
          };
          parameters: {
            additionalProperties: {
              description: 'The parameters of the trigger.';
              type: 'string';
            };
            description: 'The parameters of the trigger.';
            type: 'object';
          };
          ruleKey: {
            description: 'The rule key of the trigger.';
            type: 'string';
          };
        };
        required: ['parameters', 'ruleKey'];
        type: 'object';
      };
      WorkflowUpdate: {
        additionalProperties: true;
        description: 'The details of the workflows to update.';
        maximum: 20;
        properties: {
          defaultStatusMappings: {
            description: 'The mapping of old to new status ID.';
            items: {
              $ref: '#/components/schemas/StatusMigration';
            };
            type: 'array';
          };
          description: {
            description: 'The new description for this workflow.';
            type: 'string';
          };
          id: {
            description: 'The ID of this workflow.';
            type: 'string';
          };
          startPointLayout: {
            $ref: '#/components/schemas/WorkflowLayout';
          };
          statusMappings: {
            description: 'The mapping of old to new status ID for a specific project and issue type.';
            items: {
              $ref: '#/components/schemas/StatusMappingDTO';
            };
            type: 'array';
          };
          statuses: {
            description: 'The statuses associated with this workflow.';
            items: {
              $ref: '#/components/schemas/StatusLayoutUpdate';
            };
            type: 'array';
          };
          transitions: {
            description: 'The transitions of this workflow.';
            items: {
              $ref: '#/components/schemas/TransitionUpdateDTO';
            };
            type: 'array';
          };
          version: {
            $ref: '#/components/schemas/DocumentVersion';
          };
        };
        required: ['id', 'statuses', 'transitions', 'version'];
        type: 'object';
      };
      WorkflowUpdateRequest: {
        additionalProperties: false;
        description: 'The update workflows payload.';
        properties: {
          statuses: {
            description: 'The statuses to associate with the workflows.';
            items: {
              $ref: '#/components/schemas/WorkflowStatusUpdate';
            };
            maximum: 1000;
            type: 'array';
          };
          workflows: {
            description: 'The details of the workflows to update.';
            items: {
              $ref: '#/components/schemas/WorkflowUpdate';
            };
            maximum: 20;
            type: 'array';
          };
        };
        required: ['statuses', 'workflows'];
        type: 'object';
      };
      WorkflowUpdateResponse: {
        additionalProperties: false;
        properties: {
          statuses: {
            description: 'List of updated statuses.';
            items: {
              $ref: '#/components/schemas/JiraWorkflowStatus';
            };
            type: 'array';
            uniqueItems: true;
          };
          taskId: {
            description: 'If there is a [asynchronous task](#async-operations) operation, as a result of this update.';
            nullable: true;
            type: 'string';
          };
          workflows: {
            description: 'List of updated workflows.';
            items: {
              $ref: '#/components/schemas/JiraWorkflow';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        type: 'object';
      };
      WorkflowUpdateValidateRequestBean: {
        additionalProperties: false;
        properties: {
          payload: {
            $ref: '#/components/schemas/WorkflowUpdateRequest';
          };
          validationOptions: {
            $ref: '#/components/schemas/ValidationOptionsForUpdate';
          };
        };
        required: ['payload'];
        type: 'object';
      };
      WorkflowUsages: {
        additionalProperties: false;
        description: 'The workflows that use this status. Only available if the `workflowUsages` expand is requested.';
        properties: {
          workflowId: {
            description: 'Workflow ID.';
            type: 'string';
          };
          workflowName: {
            description: 'Workflow name.';
            type: 'string';
          };
        };
        type: 'object';
      };
      WorkflowValidationError: {
        additionalProperties: false;
        description: 'The details about a workflow validation error.';
        properties: {
          code: {
            description: 'An error code.';
            type: 'string';
          };
          elementReference: {
            $ref: '#/components/schemas/WorkflowElementReference';
          };
          level: {
            description: 'The validation error level.';
            enum: ['WARNING', 'ERROR'];
            type: 'string';
          };
          message: {
            description: 'An error message.';
            type: 'string';
          };
          type: {
            description: 'The type of element the error or warning references.';
            enum: [
              'RULE',
              'STATUS',
              'STATUS_LAYOUT',
              'STATUS_PROPERTY',
              'WORKFLOW',
              'TRANSITION',
              'TRANSITION_PROPERTY',
              'SCOPE',
              'STATUS_MAPPING',
              'TRIGGER',
            ];
            type: 'string';
          };
        };
        type: 'object';
      };
      WorkflowValidationErrorList: {
        additionalProperties: false;
        properties: {
          errors: {
            description: 'The list of validation errors.';
            items: {
              $ref: '#/components/schemas/WorkflowValidationError';
            };
            type: 'array';
          };
        };
        type: 'object';
      };
      WorkflowsWithTransitionRulesDetails: {
        additionalProperties: false;
        description: 'Details of workflows and their transition rules to delete.';
        properties: {
          workflows: {
            description: 'The list of workflows with transition rules to delete.';
            items: {
              $ref: '#/components/schemas/WorkflowTransitionRulesDetails';
            };
            type: 'array';
          };
        };
        required: ['workflows'];
        type: 'object';
      };
      Worklog: {
        additionalProperties: true;
        description: 'Details of a worklog.';
        properties: {
          author: {
            allOf: [
              {
                $ref: '#/components/schemas/UserDetails';
              },
            ];
            description: 'Details of the user who created the worklog.';
            readOnly: true;
          };
          comment: {
            description: 'A comment about the worklog in [Atlassian Document Format](https://developer.atlassian.com/cloud/jira/platform/apis/document/structure/). Optional when creating or updating a worklog.';
          };
          created: {
            description: 'The datetime on which the worklog was created.';
            format: 'date-time';
            readOnly: true;
            type: 'string';
          };
          id: {
            description: 'The ID of the worklog record.';
            readOnly: true;
            type: 'string';
          };
          issueId: {
            description: 'The ID of the issue this worklog is for.';
            readOnly: true;
            type: 'string';
          };
          properties: {
            description: 'Details of properties for the worklog. Optional when creating or updating a worklog.';
            items: {
              $ref: '#/components/schemas/EntityProperty';
            };
            type: 'array';
          };
          self: {
            description: 'The URL of the worklog item.';
            format: 'uri';
            readOnly: true;
            type: 'string';
          };
          started: {
            description: 'The datetime on which the worklog effort was started. Required when creating a worklog. Optional when updating a worklog.';
            format: 'date-time';
            type: 'string';
          };
          timeSpent: {
            description: "The time spent working on the issue as days (\\#d), hours (\\#h), or minutes (\\#m or \\#). Required when creating a worklog if `timeSpentSeconds` isn't provided. Optional when updating a worklog. Cannot be provided if `timeSpentSecond` is provided.";
            type: 'string';
          };
          timeSpentSeconds: {
            description: "The time in seconds spent working on the issue. Required when creating a worklog if `timeSpent` isn't provided. Optional when updating a worklog. Cannot be provided if `timeSpent` is provided.";
            format: 'int64';
            type: 'integer';
          };
          updateAuthor: {
            allOf: [
              {
                $ref: '#/components/schemas/UserDetails';
              },
            ];
            description: 'Details of the user who last updated the worklog.';
            readOnly: true;
          };
          updated: {
            description: 'The datetime on which the worklog was last updated.';
            format: 'date-time';
            readOnly: true;
            type: 'string';
          };
          visibility: {
            allOf: [
              {
                $ref: '#/components/schemas/Visibility';
              },
            ];
            description: 'Details about any restrictions in the visibility of the worklog. Optional when creating or updating a worklog.';
          };
        };
        type: 'object';
        xml: {
          name: 'worklog';
        };
      };
      WorklogIdsRequestBean: {
        additionalProperties: false;
        properties: {
          ids: {
            description: 'A list of worklog IDs.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        };
        required: ['ids'];
        type: 'object';
      };
      WorklogsMoveRequestBean: {
        additionalProperties: false;
        properties: {
          ids: {
            description: 'A list of worklog IDs.';
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
          issueIdOrKey: {
            description: 'The issue id or key of the destination issue';
            type: 'string';
          };
        };
        type: 'object';
      };
      WorkspaceDataPolicy: {
        additionalProperties: false;
        description: 'Details about data policy.';
        properties: {
          anyContentBlocked: {
            description: 'Whether the workspace contains any content inaccessible to the requesting application.';
            readOnly: true;
            type: 'boolean';
          };
        };
        type: 'object';
      };
      fields: {
        additionalProperties: false;
        anyOf: [
          {
            $ref: '#/components/schemas/MandatoryFieldValue';
          },
          {
            $ref: '#/components/schemas/MandatoryFieldValueForADF';
          },
        ];
        description: 'Can contain multiple field values of following types depending on `type` key';
        discriminator: {
          mapping: {
            mandatoryField: '#/components/schemas/MandatoryFieldValue';
            mandatoryFieldForADF: '#/components/schemas/MandatoryFieldValueForADF';
          };
          propertyName: 'type';
        };
        properties: {
          retain: {
            default: true;
            description: 'If `true`, will try to retain original non-null issue field values on move.';
            nullable: true;
            type: 'boolean';
            writeOnly: true;
          };
          type: {
            enum: ['adf', 'raw'];
            type: 'string';
          };
          value: {
            type: 'object';
          };
        };
        type: 'object';
        writeOnly: true;
      };
      targetClassification: {
        additionalProperties: false;
        description: 'Classification mapping for classifications in source issues to respective target classification.';
        nullable: true;
        properties: {
          classifications: {
            additionalProperties: {
              items: {
                type: 'string';
                writeOnly: true;
              };
              type: 'array';
              writeOnly: true;
            };
            description: 'An object with the key as the ID of the target classification and value with the list of the IDs of the current source classifications.';
            type: 'object';
            writeOnly: true;
          };
          issueType: {
            description: 'ID of the source issueType to which issues present in `issueIdOrKeys` belongs.';
            type: 'string';
            writeOnly: true;
          };
          projectKeyOrId: {
            description: 'ID or key of the source project to which issues present in `issueIdOrKeys` belongs.';
            type: 'string';
            writeOnly: true;
          };
        };
        required: ['classifications'];
        type: 'object';
        writeOnly: true;
      };
      targetMandatoryFields: {
        additionalProperties: false;
        description: 'Field mapping for mandatory fields in target';
        nullable: true;
        properties: {
          fields: {
            additionalProperties: {
              $ref: '#/components/schemas/fields';
            };
            description: 'Contains the value of mandatory fields';
            type: 'object';
            writeOnly: true;
          };
        };
        required: ['fields'];
        type: 'object';
        writeOnly: true;
      };
      targetStatus: {
        additionalProperties: false;
        description: 'Status mapping for statuses in source workflow to respective target status in target workflow.';
        nullable: true;
        properties: {
          statuses: {
            additionalProperties: {
              items: {
                type: 'string';
                writeOnly: true;
              };
              type: 'array';
              writeOnly: true;
            };
            description: 'An object with the key as the ID of the target status and value with the list of the IDs of the current source statuses.';
            type: 'object';
            writeOnly: true;
          };
        };
        required: ['statuses'];
        type: 'object';
        writeOnly: true;
      };
      targetToSourcesMapping: {
        additionalProperties: false;
        description: 'An object representing the mapping of issues and data related to destination entities, like fields and statuses, that are required during a bulk move.';
        properties: {
          inferClassificationDefaults: {
            description: "If `true`, when issues are moved into this target group, they will adopt the target project's default classification, if they don't have a classification already. If they do have a classification, it will be kept the same even after the move. Leave `targetClassification` empty when using this.\n\nIf `false`, you must provide a `targetClassification` mapping for each classification associated with the selected issues.\n\n[Benefit from data classification](https://support.atlassian.com/security-and-access-policies/docs/what-is-data-classification/)";
            type: 'boolean';
            writeOnly: true;
          };
          inferFieldDefaults: {
            description: "If `true`, values from the source issues will be retained for the mandatory fields in the field configuration of the destination project. The `targetMandatoryFields` property shouldn't be defined.\n\nIf `false`, the user is required to set values for mandatory fields present in the field configuration of the destination project. Provide input by defining the `targetMandatoryFields` property";
            type: 'boolean';
            writeOnly: true;
          };
          inferStatusDefaults: {
            description: 'If `true`, the statuses of issues being moved in this target group that are not present in the target workflow will be changed to the default status of the target workflow (see below). Leave `targetStatus` empty when using this.\n\nIf `false`, you must provide a `targetStatus` for each status not present in the target workflow.\n\nThe default status in a workflow is referred to as the "initial status". Each workflow has its own unique initial status. When an issue is created, it is automatically assigned to this initial status. Read more about configuring initial statuses: [Configure the initial status | Atlassian Support.](https://support.atlassian.com/jira-cloud-administration/docs/configure-the-initial-status/)';
            type: 'boolean';
            writeOnly: true;
          };
          inferSubtaskTypeDefault: {
            description: 'When an issue is moved, its subtasks (if there are any) need to be moved with it. `inferSubtaskTypeDefault` helps with moving the subtasks by picking a random subtask type in the target project.\n\nIf `true`, subtasks will automatically move to the same project as their parent.\n\nWhen they move:\n\n *  Their `issueType` will be set to the default for subtasks in the target project.\n *  Values for mandatory fields will be retained from the source issues\n *  Specifying separate mapping for implicit subtasks won’t be allowed.\n\nIf `false`, you must manually move the subtasks. They will retain the parent which they had in the current project after being moved.';
            type: 'boolean';
            writeOnly: true;
          };
          issueIdsOrKeys: {
            description: 'List of issue IDs or keys to be moved. These issues must be from the same project, have the same issue type, and be from the same parent (if they’re subtasks).';
            items: {
              type: 'string';
              writeOnly: true;
            };
            type: 'array';
            writeOnly: true;
          };
          targetClassification: {
            description: 'List of the objects containing classifications in the source issues and their new values which need to be set during the bulk move operation.\n\n *  **You should only define this property when `inferClassificationDefaults` is `false`.**\n *  **In order to provide mapping for issues which don\'t have a classification, use `"-1"`.**';
            items: {
              $ref: '#/components/schemas/targetClassification';
            };
            nullable: true;
            type: 'array';
            writeOnly: true;
          };
          targetMandatoryFields: {
            description: 'List of objects containing mandatory fields in the target field configuration and new values that need to be set during the bulk move operation.\n\nThe new values will only be applied if the field is mandatory in the target project and at least one issue from the source has that field empty, or if the field context is different in the target project (e.g. project-scoped version fields).\n\n**You should only define this property when `inferFieldDefaults` is `false`.**';
            items: {
              $ref: '#/components/schemas/targetMandatoryFields';
            };
            nullable: true;
            type: 'array';
            writeOnly: true;
          };
          targetStatus: {
            description: 'List of the objects containing statuses in the source workflow and their new values which need to be set during the bulk move operation.\n\nThe new values will only be applied if the source status is invalid for the target project and issue type.\n\n**You should only define this property when `inferStatusDefaults` is `false`.**';
            items: {
              $ref: '#/components/schemas/targetStatus';
            };
            nullable: true;
            type: 'array';
            writeOnly: true;
          };
        };
        required: [
          'inferClassificationDefaults',
          'inferFieldDefaults',
          'inferStatusDefaults',
          'inferSubtaskTypeDefault',
          'issueIdOrKeys',
        ];
        type: 'object';
      };
    };
    securitySchemes: {
      OAuth2: {
        description: 'OAuth2 scopes for Jira';
        flows: {
          authorizationCode: {
            authorizationUrl: 'https://auth.atlassian.com/authorize';
            scopes: {
              'delete:async-task:jira': 'Delete asynchronous task.';
              'delete:attachment:jira': 'Delete issue attachments.';
              'delete:avatar:jira': 'Delete system and custom avatars.';
              'delete:comment.property:jira': 'Delete issue comment properties.';
              'delete:comment:jira': 'Delete issue comments.';
              'delete:dashboard.property:jira': 'Delete dashboard properties.';
              'delete:dashboard:jira': 'Delete dashboards.';
              'delete:field-configuration-scheme:jira': 'Delete field configuration schemes.';
              'delete:field-configuration:jira': 'Delete field configurations.';
              'delete:field.option:jira': 'Delete field options.';
              'delete:field:jira': 'Delete fields.';
              'delete:filter.column:jira': 'Delete filter columns.';
              'delete:filter:jira': 'Delete filters.';
              'delete:group:jira': 'Delete user groups.';
              'delete:issue-link-type:jira': 'Delete issue link types.';
              'delete:issue-link:jira': 'Delete issue links.';
              'delete:issue-type-scheme:jira': 'Delete issue type schemes.';
              'delete:issue-type-screen-scheme:jira': 'Delete issue type screen schemes.';
              'delete:issue-type.property:jira': 'Delete issue type properties.';
              'delete:issue-type:jira': 'Delete issue types.';
              'delete:issue-worklog.property:jira': 'Delete issue worklog properties.';
              'delete:issue-worklog:jira': 'Delete issue worklogs.';
              'delete:issue.property:jira': 'Delete issue properties.';
              'delete:issue.remote-link:jira': 'Delete issue remote links.';
              'delete:issue:jira': 'Delete issues.';
              'delete:permission-scheme:jira': 'Delete permission schemes.';
              'delete:permission:jira': 'Delete permissions.';
              'delete:project-category:jira': 'Delete project categories.';
              'delete:project-role:jira': 'Delete project roles.';
              'delete:project-version:jira': 'Delete project versions.';
              'delete:project.avatar:jira': 'Delete project avatars.';
              'delete:project.component:jira': 'Delete project components.';
              'delete:project.property:jira': 'Delete project properties.';
              'delete:project:jira': 'Delete projects and their details, such as issue types, project lead, and avatars.';
              'delete:screen-scheme:jira': 'Delete screen schemes.';
              'delete:screen-tab:jira': 'Delete screen tabs.';
              'delete:screen:jira': 'Delete screens.';
              'delete:screenable-field:jira': 'Delete screenable fields.';
              'delete:user-configuration:jira': 'Delete user configurations.';
              'delete:user.property:jira': 'Delete user properties.';
              'delete:webhook:jira': 'Delete webhooks.';
              'delete:workflow-scheme:jira': 'Delete workflow schemes.';
              'delete:workflow.property:jira': 'Delete workflow properties.';
              'delete:workflow:jira': 'Delete workflows.';
              'manage:jira-configuration': 'Configure Jira settings that require the Jira administrators permission, for example, create projects and custom fields, view workflows, manage issue link types.';
              'manage:jira-project': 'Create and edit project settings and create new project-level objects, for example, versions, components.';
              'manage:jira-webhook': 'Manage Jira webhooks. Enables an OAuth app to register and unregister dynamic webhooks in Jira. It also provides for fetching of registered webhooks.';
              'read:app-data:jira': 'Read app data.';
              'read:application-role:jira': 'View application roles.';
              'read:attachment:jira': 'View issue attachments.';
              'read:audit-log:jira': 'View audit logs.';
              'read:avatar:jira': 'View system and custom avatars.';
              'read:comment.property:jira': 'View issue comment properties.';
              'read:comment:jira': 'View issue comments.';
              'read:custom-field-contextual-configuration:jira': 'Read custom field contextual configurations.';
              'read:dashboard.property:jira': 'View dashboard properties.';
              'read:dashboard:jira': 'View dashboards.';
              'read:email-address:jira': 'View email addresses of all users regardless of the user’s profile visibility settings.';
              'read:field-configuration-scheme:jira': 'View field configuration schemes.';
              'read:field-configuration:jira': 'Read field configurations.';
              'read:field.default-value:jira': 'View field default values.';
              'read:field.option:jira': 'View field options.';
              'read:field.options:jira': 'Read field options.';
              'read:field:jira': 'View fields.';
              'read:filter.column:jira': 'View filter columns.';
              'read:filter.default-share-scope:jira': 'View filter default share scopes.';
              'read:filter:jira': 'View filters.';
              'read:group:jira': 'View user groups.';
              'read:instance-configuration:jira': 'View instance configurations.';
              'read:issue-details:jira': 'View issue details.';
              'read:issue-event:jira': 'Read issue events.';
              'read:issue-field-values:jira': 'View issue field valueses.';
              'read:issue-link-type:jira': 'View issue link types.';
              'read:issue-link:jira': 'View issue links.';
              'read:issue-meta:jira': 'View issue meta.';
              'read:issue-security-level:jira': 'View issue security levels.';
              'read:issue-security-scheme:jira': 'View issue security schemes.';
              'read:issue-status:jira': 'View issue statuses.';
              'read:issue-type-hierarchy:jira': 'Read issue type hierarchies.';
              'read:issue-type-scheme:jira': 'View issue type schemes.';
              'read:issue-type-screen-scheme:jira': 'View issue type screen schemes.';
              'read:issue-type.property:jira': 'View issue type properties.';
              'read:issue-type:jira': 'View issue types.';
              'read:issue-worklog.property:jira': 'View issue worklog properties.';
              'read:issue-worklog:jira': 'View issue worklogs.';
              'read:issue.changelog:jira': 'View issue changelogs.';
              'read:issue.property:jira': 'View issue properties.';
              'read:issue.remote-link:jira': 'View issue remote links.';
              'read:issue.time-tracking:jira': 'View issue time trackings.';
              'read:issue.transition:jira': 'View issue transitions.';
              'read:issue.vote:jira': 'View issue votes.';
              'read:issue.votes:jira': 'View issue voteses.';
              'read:issue.watcher:jira': 'View issue watchers.';
              'read:issue:jira': 'View issues.';
              'read:jira-expressions:jira': 'View jira expressions.';
              'read:jira-user': 'View user information in Jira that you have access to, including usernames, email addresses, and avatars.';
              'read:jira-work': 'Read project and issue data. Search for issues and objects associated with issues (such as attachments and worklogs).';
              'read:jql:jira': 'View JQL.';
              'read:label:jira': 'View labels.';
              'read:license:jira': 'View licenses.';
              'read:notification-scheme:jira': 'View notification schemes.';
              'read:permission-scheme:jira': 'View permission schemes.';
              'read:permission:jira': 'View permissions.';
              'read:priority:jira': 'View priorities.';
              'read:project-category:jira': 'View project categories.';
              'read:project-role:jira': 'View project roles.';
              'read:project-type:jira': 'View project types.';
              'read:project-version:jira': 'View project versions.';
              'read:project.avatar:jira': 'Read project avatars.';
              'read:project.component:jira': 'View project components.';
              'read:project.email:jira': 'View project emails.';
              'read:project.feature:jira': 'Read project features.';
              'read:project.property:jira': 'View project properties.';
              'read:project:jira': 'View projects.';
              'read:resolution:jira': 'View resolutions.';
              'read:role:jira': 'View roles.';
              'read:screen-field:jira': 'View screen fields.';
              'read:screen-scheme:jira': 'View screen schemes.';
              'read:screen-tab:jira': 'View screen tabs.';
              'read:screen:jira': 'View screens.';
              'read:screenable-field:jira': 'View screenable fields.';
              'read:status:jira': 'View statuses.';
              'read:user-configuration:jira': 'View user configurations.';
              'read:user.columns:jira': 'View user columnses.';
              'read:user.property:jira': 'View user properties.';
              'read:user:jira': 'View users.';
              'read:webhook:jira': 'View webhooks.';
              'read:workflow-scheme:jira': 'View workflow schemes.';
              'read:workflow.property:jira': 'View workflow properties.';
              'read:workflow:jira': 'View workflows.';
              'send:notification:jira': 'Send notifications.';
              'validate:jql:jira': 'Validate JQL.';
              'write:app-data:jira': 'Write app data.';
              'write:attachment:jira': 'Create and update issue attachments.';
              'write:avatar:jira': 'Create and update system and custom avatars.';
              'write:comment.property:jira': 'Create and update issue comment properties.';
              'write:comment:jira': 'Create and update issue comments.';
              'write:custom-field-contextual-configuration:jira': 'Save custom field contextual configurations.';
              'write:dashboard.property:jira': 'Create and update dashboard properties.';
              'write:dashboard:jira': 'Create and update dashboards.';
              'write:field-configuration-scheme:jira': 'Create and update field configuration schemes.';
              'write:field-configuration:jira': 'Save field configurations.';
              'write:field.default-value:jira': 'Create and update field default values.';
              'write:field.option:jira': 'Create and update field options.';
              'write:field:jira': 'Create and update fields.';
              'write:filter.column:jira': 'Create and update filter columns.';
              'write:filter.default-share-scope:jira': 'Create and update filter default share scopes.';
              'write:filter:jira': 'Create and update filters.';
              'write:group:jira': 'Create and update user groups.';
              'write:instance-configuration:jira': 'Create and update instance configurations.';
              'write:issue-link-type:jira': 'Create and update issue link types.';
              'write:issue-link:jira': 'Create and update issue links.';
              'write:issue-type-scheme:jira': 'Create and update issue type schemes.';
              'write:issue-type-screen-scheme:jira': 'Create and update issue type screen schemes.';
              'write:issue-type.property:jira': 'Create and update issue type properties.';
              'write:issue-type:jira': 'Create and update issue types.';
              'write:issue-worklog.property:jira': 'Create and update issue worklog properties.';
              'write:issue-worklog:jira': 'Create and update issue worklogs.';
              'write:issue.property:jira': 'Create and update issue properties.';
              'write:issue.remote-link:jira': 'Create and update issue remote links.';
              'write:issue.time-tracking:jira': 'Create and update issue time trackings.';
              'write:issue.vote:jira': 'Create and update issue votes.';
              'write:issue.watcher:jira': 'Create and update issue watchers.';
              'write:issue:jira': 'Create and update issues.';
              'write:jira-work': 'Create and edit issues in Jira, post comments, create worklogs, and delete issues.';
              'write:permission-scheme:jira': 'Create and update permission schemes.';
              'write:permission:jira': 'Create and update permissions.';
              'write:project-category:jira': 'Create and update project categories.';
              'write:project-role:jira': 'Create and update project roles.';
              'write:project-version:jira': 'Create and update project versions.';
              'write:project.avatar:jira': 'Create and update project avatars.';
              'write:project.component:jira': 'Create and update project components.';
              'write:project.email:jira': 'Create and update project emails.';
              'write:project.feature:jira': 'Save project features.';
              'write:project.property:jira': 'Create and update project properties.';
              'write:project:jira': 'Create and update projects.';
              'write:screen-scheme:jira': 'Create and update screen schemes.';
              'write:screen-tab:jira': 'Create and update screen tabs.';
              'write:screen:jira': 'Create and update screens.';
              'write:screenable-field:jira': 'Create and update screenable fields.';
              'write:user-configuration:jira': 'Create and update user configurations.';
              'write:user.property:jira': 'Create and update user properties.';
              'write:webhook:jira': 'Create and update webhooks.';
              'write:workflow-scheme:jira': 'Create and update workflow schemes.';
              'write:workflow.property:jira': 'Create and update workflow properties.';
              'write:workflow:jira': 'Create and update workflows.';
            };
            tokenUrl: 'https://auth.atlassian.com/oauth/token';
          };
        };
        type: 'oauth2';
      };
      basicAuth: {
        description: 'You can access this resource via basic auth.';
        scheme: 'basic';
        type: 'http';
      };
    };
  };
  externalDocs: {
    description: 'Find out more about Atlassian products and services.';
    url: 'http://www.atlassian.com';
  };
  openapi: '3.0.1';
  paths: {
    '/rest/api/3/announcementBanner': {
      get: {
        deprecated: false;
        description: 'Returns the current announcement banner configuration.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
        operationId: 'getBanner';
        parameters: [];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"hashId":"9HN2FJK9DM8BHRWERVW3RRTGDJ4G4D5C","isDismissible":false,"isEnabled":true,"message":"This is a public, enabled, non-dismissible banner, set using the API","visibility":"public"}';
                schema: {
                  $ref: '#/components/schemas/AnnouncementBannerConfiguration';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            content: {
              'application/json': {
                example: '"Only admins can read banner configuration."';
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the user does not have the necessary permission.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['manage:jira-configuration'];
          },
        ];
        summary: 'Get announcement banner configuration';
        tags: ['Announcement banner'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
      };
      put: {
        deprecated: false;
        description: 'Updates the announcement banner configuration.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
        operationId: 'setBanner';
        parameters: [];
        requestBody: {
          content: {
            'application/json': {
              example: {
                isDismissible: false;
                isEnabled: true;
                message: 'This is a public, enabled, non-dismissible banner, set using the API';
                visibility: 'public';
              };
              schema: {
                $ref: '#/components/schemas/AnnouncementBannerConfigurationUpdate';
              };
            };
          };
          required: true;
        };
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            content: {
              'application/json': {
                example: '"Banner message cannot be null."';
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if an invalid parameter is passed.';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            content: {
              'application/json': {
                example: '"Only admins can update banner configuration."';
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the user does not have the necessary permission.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['manage:jira-configuration'];
          },
        ];
        summary: 'Update announcement banner configuration';
        tags: ['Announcement banner'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
      };
    };
    '/rest/api/3/app/field/value': {
      post: {
        deprecated: false;
        description: "Updates the value of one or more custom fields on one or more issues. Combinations of custom field and issue should be unique within the request.\n\nApps can only perform this operation on [custom fields](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field/) and [custom field types](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field-type/) declared in their own manifests.\n\n**[Permissions](#permissions) required:** Only the app that owns the custom field or custom field type can update its values with this operation.\n\nThe new `write:app-data:jira` OAuth scope is 100% optional now, and not using it won't break your app. However, we recommend adding it to your app's scope list because we will eventually make it mandatory.";
        operationId: 'updateMultipleCustomFieldValues';
        parameters: [
          {
            description: 'Whether to generate a changelog for this update.';
            in: 'query';
            name: 'generateChangelog';
            schema: {
              default: true;
              type: 'boolean';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              example: {
                updates: [
                  {
                    customField: 'customfield_10010';
                    issueIds: [10010, 10011];
                    value: 'new value';
                  },
                  {
                    customField: 'customfield_10011';
                    issueIds: [10010];
                    value: 1000;
                  },
                ];
              };
              schema: {
                $ref: '#/components/schemas/MultipleCustomFieldValuesUpdateDetails';
              };
            };
          };
          required: true;
        };
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            description: 'Returned if the request is invalid.';
          };
          '403': {
            description: 'Returned if the request is not authenticated as the app that provided all the fields.';
          };
          '404': {
            description: 'Returned if any field is not found.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: [];
          },
        ];
        summary: 'Update custom fields';
        tags: ['Issue custom field values (apps)'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': false;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: [];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['write:app-data:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/app/field/{fieldIdOrKey}/context/configuration': {
      get: {
        deprecated: false;
        description: 'Returns a [paginated](#pagination) list of configurations for a custom field of a [type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field-type/) created by a [Forge app](https://developer.atlassian.com/platform/forge/).\n\nThe result can be filtered by one of these criteria:\n\n *  `id`.\n *  `fieldContextId`.\n *  `issueId`.\n *  `projectKeyOrId` and `issueTypeId`.\n\nOtherwise, all configurations are returned.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg). Jira permissions are not required for the Forge app that provided the custom field type.';
        operationId: 'getCustomFieldConfiguration';
        parameters: [
          {
            description: 'The ID or key of the custom field, for example `customfield_10000`.';
            in: 'path';
            name: 'fieldIdOrKey';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: "The list of configuration IDs. To include multiple configurations, separate IDs with an ampersand: `id=10000&id=10001`. Can't be provided with `fieldContextId`, `issueId`, `projectKeyOrId`, or `issueTypeId`.";
            in: 'query';
            name: 'id';
            schema: {
              items: {
                format: 'int64';
                type: 'integer';
              };
              type: 'array';
              uniqueItems: true;
            };
          },
          {
            description: "The list of field context IDs. To include multiple field contexts, separate IDs with an ampersand: `fieldContextId=10000&fieldContextId=10001`. Can't be provided with `id`, `issueId`, `projectKeyOrId`, or `issueTypeId`.";
            in: 'query';
            name: 'fieldContextId';
            schema: {
              items: {
                format: 'int64';
                type: 'integer';
              };
              type: 'array';
              uniqueItems: true;
            };
          },
          {
            description: "The ID of the issue to filter results by. If the issue doesn't exist, an empty list is returned. Can't be provided with `projectKeyOrId`, or `issueTypeId`.";
            in: 'query';
            name: 'issueId';
            schema: {
              format: 'int64';
              type: 'integer';
            };
          },
          {
            description: "The ID or key of the project to filter results by. Must be provided with `issueTypeId`. Can't be provided with `issueId`.";
            in: 'query';
            name: 'projectKeyOrId';
            schema: {
              type: 'string';
            };
          },
          {
            description: "The ID of the issue type to filter results by. Must be provided with `projectKeyOrId`. Can't be provided with `issueId`.";
            in: 'query';
            name: 'issueTypeId';
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The index of the first item to return in a page of results (page offset).';
            in: 'query';
            name: 'startAt';
            schema: {
              default: 0;
              format: 'int64';
              type: 'integer';
            };
          },
          {
            description: 'The maximum number of items to return per page.';
            in: 'query';
            name: 'maxResults';
            schema: {
              default: 100;
              format: 'int32';
              type: 'integer';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"isLast":true,"maxResults":1000,"startAt":0,"total":2,"values":[{"id":"10000","fieldContextId":"10010"},{"id":"10001","fieldContextId":"10011","configuration":{"minValue":0,"maxValue":10000},"schema":{"properties":{"amount":{"type":"number"},"currency":{"type":"string"}},"required":["amount","currency"]}}]}';
                schema: {
                  $ref: '#/components/schemas/PageBeanContextualConfiguration';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            description: 'Returned if the request is invalid.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'Returned if the user is not a Jira admin or the request is not authenticated as from the app that provided the field.';
          };
          '404': {
            description: 'Returned if the custom field is not found.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['manage:jira-configuration'];
          },
        ];
        summary: 'Get custom field configurations';
        tags: ['Issue custom field configuration (apps)'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': false;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['manage:jira-configuration'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:custom-field-contextual-configuration:jira'];
            state: 'Beta';
          },
        ];
      };
      put: {
        deprecated: false;
        description: 'Update the configuration for contexts of a custom field of a [type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field-type/) created by a [Forge app](https://developer.atlassian.com/platform/forge/).\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg). Jira permissions are not required for the Forge app that created the custom field type.';
        operationId: 'updateCustomFieldConfiguration';
        parameters: [
          {
            description: 'The ID or key of the custom field, for example `customfield_10000`.';
            in: 'path';
            name: 'fieldIdOrKey';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              example: {
                configurations: [
                  {
                    id: '10000';
                  },
                  {
                    configuration: {
                      maxValue: 10000;
                      minValue: 0;
                    };
                    id: '10001';
                    schema: {
                      properties: {
                        amount: {
                          type: 'number';
                        };
                        currency: {
                          type: 'string';
                        };
                      };
                      required: ['amount', 'currency'];
                    };
                  },
                ];
              };
              schema: {
                $ref: '#/components/schemas/CustomFieldConfigurations';
              };
            };
          };
          required: true;
        };
        responses: {
          '200': {
            content: {
              'application/json': {
                schema: {};
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            description: 'Returned if the request is invalid.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'Returned if the user is not a Jira admin or the request is not authenticated as from the app that provided the field.';
          };
          '404': {
            description: 'Returned if the custom field is not found.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['manage:jira-configuration'];
          },
        ];
        summary: 'Update custom field configurations';
        tags: ['Issue custom field configuration (apps)'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['manage:jira-configuration'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['write:custom-field-contextual-configuration:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/app/field/{fieldIdOrKey}/value': {
      put: {
        deprecated: false;
        description: "Updates the value of a custom field on one or more issues.\n\nApps can only perform this operation on [custom fields](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field/) and [custom field types](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field-type/) declared in their own manifests.\n\n**[Permissions](#permissions) required:** Only the app that owns the custom field or custom field type can update its values with this operation.\n\nThe new `write:app-data:jira` OAuth scope is 100% optional now, and not using it won't break your app. However, we recommend adding it to your app's scope list because we will eventually make it mandatory.";
        operationId: 'updateCustomFieldValue';
        parameters: [
          {
            description: 'The ID or key of the custom field. For example, `customfield_10010`.';
            in: 'path';
            name: 'fieldIdOrKey';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Whether to generate a changelog for this update.';
            in: 'query';
            name: 'generateChangelog';
            schema: {
              default: true;
              type: 'boolean';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              example: {
                updates: [
                  {
                    issueIds: [10010];
                    value: 'new value';
                  },
                ];
              };
              schema: {
                $ref: '#/components/schemas/CustomFieldValueUpdateDetails';
              };
            };
          };
          required: true;
        };
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            description: 'Returned if the request is invalid.';
          };
          '403': {
            description: 'Returned if the request is not authenticated as the app that provided the field.';
          };
          '404': {
            description: 'Returned if the field is not found.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: [];
          },
        ];
        summary: 'Update custom field value';
        tags: ['Issue custom field values (apps)'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': false;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: [];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['write:app-data:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/application-properties': {
      get: {
        deprecated: false;
        description: 'Returns all application properties or an application property.\n\nIf you specify a value for the `key` parameter, then an application property is returned as an object (not in an array). Otherwise, an array of all editable application properties is returned. See [Set application property](#api-rest-api-3-application-properties-id-put) for descriptions of editable properties.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
        operationId: 'getApplicationProperty';
        parameters: [
          {
            description: 'The key of the application property.';
            in: 'query';
            name: 'key';
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The permission level of all items being returned in the list.';
            in: 'query';
            name: 'permissionLevel';
            schema: {
              type: 'string';
            };
          },
          {
            description: "When a `key` isn't provided, this filters the list of results by the application property `key` using a regular expression. For example, using `jira.lf.*` will return all application properties with keys that start with *jira.lf.*.";
            in: 'query';
            name: 'keyFilter';
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '[{"defaultValue":"","desc":"Jira home directory","id":"jira.home","key":"jira.home","name":"jira.home","type":"string","value":"/var/jira/jira-home"},{"defaultValue":"CLONE -","id":"jira.clone.prefix","key":"jira.clone.prefix","name":"The prefix added to the Summary field of cloned issues","type":"string","value":"CLONE -"}]';
                schema: {
                  items: {
                    $ref: '#/components/schemas/ApplicationProperty';
                  };
                  type: 'array';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '404': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the application property is not found or the user does not have permission to view it.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['manage:jira-configuration'];
          },
        ];
        summary: 'Get application property';
        tags: ['Jira settings'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['manage:jira-configuration'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:instance-configuration:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/application-properties/advanced-settings': {
      get: {
        deprecated: false;
        description: 'Returns the application properties that are accessible on the *Advanced Settings* page. To navigate to the *Advanced Settings* page in Jira, choose the Jira icon > **Jira settings** > **System**, **General Configuration** and then click **Advanced Settings** (in the upper right).\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
        operationId: 'getAdvancedSettings';
        parameters: [];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '[{"defaultValue":"","desc":"Jira home directory","id":"jira.home","key":"jira.home","name":"jira.home","type":"string","value":"/var/jira/jira-home"},{"defaultValue":"CLONE -","id":"jira.clone.prefix","key":"jira.clone.prefix","name":"The prefix added to the Summary field of cloned issues","type":"string","value":"CLONE -"}]';
                schema: {
                  items: {
                    $ref: '#/components/schemas/ApplicationProperty';
                  };
                  type: 'array';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'Returned if the user is not an administrator.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['manage:jira-configuration'];
          },
        ];
        summary: 'Get advanced settings';
        tags: ['Jira settings'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['manage:jira-configuration'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:instance-configuration:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/application-properties/{id}': {
      put: {
        deprecated: false;
        description: 'Changes the value of an application property. For example, you can change the value of the `jira.clone.prefix` from its default value of *CLONE -* to *Clone -* if you prefer sentence case capitalization. Editable properties are described below along with their default values.\n\n#### Advanced settings ####\n\nThe advanced settings below are also accessible in [Jira](https://confluence.atlassian.com/x/vYXKM).\n\n| Key | Description | Default value |  \n| -- | -- | -- |  \n| `jira.clone.prefix` | The string of text prefixed to the title of a cloned issue. | `CLONE -` |  \n| `jira.date.picker.java.format` | The date format for the Java (server-side) generated dates. This must be the same as the `jira.date.picker.javascript.format` format setting. | `d/MMM/yy` |  \n| `jira.date.picker.javascript.format` | The date format for the JavaScript (client-side) generated dates. This must be the same as the `jira.date.picker.java.format` format setting. | `%e/%b/%y` |  \n| `jira.date.time.picker.java.format` | The date format for the Java (server-side) generated date times. This must be the same as the `jira.date.time.picker.javascript.format` format setting. | `dd/MMM/yy h:mm a` |  \n| `jira.date.time.picker.javascript.format` | The date format for the JavaScript (client-side) generated date times. This must be the same as the `jira.date.time.picker.java.format` format setting. | `%e/%b/%y %I:%M %p` |  \n| `jira.issue.actions.order` | The default order of actions (such as *Comments* or *Change history*) displayed on the issue view. | `asc` |  \n| `jira.view.issue.links.sort.order` | The sort order of the list of issue links on the issue view. | `type, status, priority` |  \n| `jira.comment.collapsing.minimum.hidden` | The minimum number of comments required for comment collapsing to occur. A value of `0` disables comment collapsing. | `4` |  \n| `jira.newsletter.tip.delay.days` | The number of days before a prompt to sign up to the Jira Insiders newsletter is shown. A value of `-1` disables this feature. | `7` |  \n\n\n#### Look and feel ####\n\nThe settings listed below adjust the [look and feel](https://confluence.atlassian.com/x/VwCLLg).\n\n| Key | Description | Default value |  \n| -- | -- | -- |  \n| `jira.lf.date.time` | The [ time format](https://docs.oracle.com/javase/6/docs/api/index.html?java/text/SimpleDateFormat.html). | `h:mm a` |  \n| `jira.lf.date.day` | The [ day format](https://docs.oracle.com/javase/6/docs/api/index.html?java/text/SimpleDateFormat.html). | `EEEE h:mm a` |  \n| `jira.lf.date.complete` | The [ date and time format](https://docs.oracle.com/javase/6/docs/api/index.html?java/text/SimpleDateFormat.html). | `dd/MMM/yy h:mm a` |  \n| `jira.lf.date.dmy` | The [ date format](https://docs.oracle.com/javase/6/docs/api/index.html?java/text/SimpleDateFormat.html). | `dd/MMM/yy` |  \n| `jira.date.time.picker.use.iso8061` | When enabled, sets Monday as the first day of the week in the date picker, as specified by the ISO8601 standard. | `false` |  \n| `jira.lf.logo.url` | The URL of the logo image file. | `/images/icon-jira-logo.png` |  \n| `jira.lf.logo.show.application.title` | Controls the visibility of the application title on the sidebar. | `false` |  \n| `jira.lf.favicon.url` | The URL of the favicon. | `/favicon.ico` |  \n| `jira.lf.favicon.hires.url` | The URL of the high-resolution favicon. | `/images/64jira.png` |  \n| `jira.lf.navigation.bgcolour` | The background color of the sidebar. | `#0747A6` |  \n| `jira.lf.navigation.highlightcolour` | The color of the text and logo of the sidebar. | `#DEEBFF` |  \n| `jira.lf.hero.button.base.bg.colour` | The background color of the hero button. | `#3b7fc4` |  \n| `jira.title` | The text for the application title. The application title can also be set in *General settings*. | `Jira` |  \n| `jira.option.globalsharing` | Whether filters and dashboards can be shared with anyone signed into Jira. | `true` |  \n| `xflow.product.suggestions.enabled` | Whether to expose product suggestions for other Atlassian products within Jira. | `true` |  \n\n\n#### Other settings ####\n\n| Key | Description | Default value |  \n| -- | -- | -- |  \n| `jira.issuenav.criteria.autoupdate` | Whether instant updates to search criteria is active. | `true` |  \n\n\n*Note: Be careful when changing [application properties and advanced settings](https://confluence.atlassian.com/x/vYXKM).*\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
        operationId: 'setApplicationProperty';
        parameters: [
          {
            description: 'The key of the application property to update.';
            in: 'path';
            name: 'id';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              example: {
                id: 'jira.home';
                value: '/var/jira/jira-home';
              };
              schema: {
                $ref: '#/components/schemas/SimpleApplicationPropertyBean';
              };
            };
          };
          required: true;
        };
        responses: {
          '200': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ApplicationProperty';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: "Returned if the data type of the `value` does not match the application property's data type. For example, a string is provided instead of an integer.";
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the user does not have permission to edit the property.';
          };
          '404': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the property is not found or the user does not have permission to view it.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['manage:jira-configuration'];
          },
        ];
        summary: 'Set application property';
        tags: ['Jira settings'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['manage:jira-configuration'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['write:instance-configuration:jira', 'read:instance-configuration:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/applicationrole': {
      get: {
        deprecated: false;
        description: 'Returns all application roles. In Jira, application roles are managed using the [Application access configuration](https://confluence.atlassian.com/x/3YxjL) page.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
        operationId: 'getAllApplicationRoles';
        parameters: [];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '[{"defaultGroups":["jira-software-users"],"defaultGroupsDetails":[{"groupId":"276f955c-63d7-42c8-9520-92d01dca0625","name":"jira-software-users","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=276f955c-63d7-42c8-9520-92d01dca0625"}],"defined":false,"groupDetails":[{"groupId":"42c8955c-63d7-42c8-9520-63d7aca0625","name":"jira-testers","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=42c8955c-63d7-42c8-9520-63d7aca0625"},{"groupId":"276f955c-63d7-42c8-9520-92d01dca0625","name":"jira-software-users","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=276f955c-63d7-42c8-9520-92d01dca0625"}],"groups":["jira-software-users","jira-testers"],"hasUnlimitedSeats":false,"key":"jira-software","name":"Jira Software","numberOfSeats":10,"platform":false,"remainingSeats":5,"selectedByDefault":false,"userCount":5,"userCountDescription":"5 developers"},{"defaultGroups":["jira-core-users"],"defaultGroupsDetails":[{"groupId":"92d01dca0625-42c8-42c8-9520-276f955c","name":"jira-core-users","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=92d01dca0625-42c8-42c8-9520-276f955c"}],"defined":false,"groupDetails":[{"groupId":"92d01dca0625-42c8-42c8-9520-276f955c","name":"jira-core-users","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=92d01dca0625-42c8-42c8-9520-276f955c"}],"groups":["jira-core-users"],"hasUnlimitedSeats":false,"key":"jira-core","name":"Jira Core","numberOfSeats":1,"platform":true,"remainingSeats":1,"selectedByDefault":false,"userCount":0,"userCountDescription":"0 users"}]';
                schema: {
                  items: {
                    $ref: '#/components/schemas/ApplicationRole';
                  };
                  type: 'array';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'Returned if the user is not an administrator.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
        ];
        summary: 'Get all application roles';
        tags: ['Application roles'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
      };
    };
    '/rest/api/3/applicationrole/{key}': {
      get: {
        deprecated: false;
        description: 'Returns an application role.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
        operationId: 'getApplicationRole';
        parameters: [
          {
            description: 'The key of the application role. Use the [Get all application roles](#api-rest-api-3-applicationrole-get) operation to get the key for each application role.';
            in: 'path';
            name: 'key';
            required: true;
            schema: {
              example: 'jira-software';
              type: 'string';
            };
            'x-showInExample': 'true';
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"defaultGroups":["jira-software-users"],"defaultGroupsDetails":[{"groupId":"276f955c-63d7-42c8-9520-92d01dca0625","name":"jira-software-users","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=276f955c-63d7-42c8-9520-92d01dca0625"}],"defined":false,"groupDetails":[{"groupId":"42c8955c-63d7-42c8-9520-63d7aca0625","name":"jira-testers","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=42c8955c-63d7-42c8-9520-63d7aca0625"},{"groupId":"276f955c-63d7-42c8-9520-92d01dca0625","name":"jira-software-users","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=276f955c-63d7-42c8-9520-92d01dca0625"}],"groups":["jira-software-users","jira-testers"],"hasUnlimitedSeats":false,"key":"jira-software","name":"Jira Software","numberOfSeats":10,"platform":false,"remainingSeats":5,"selectedByDefault":false,"userCount":5,"userCountDescription":"5 developers"}';
                schema: {
                  $ref: '#/components/schemas/ApplicationRole';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'Returned if the user is not an administrator.';
          };
          '404': {
            description: 'Returned if the role is not found.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
        ];
        summary: 'Get application role';
        tags: ['Application roles'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
      };
    };
    '/rest/api/3/attachment/content/{id}': {
      get: {
        deprecated: false;
        description: 'Returns the contents of an attachment. A `Range` header can be set to define a range of bytes within the attachment to download. See the [HTTP Range header standard](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Range) for details.\n\nTo return a thumbnail of the attachment, use [Get attachment thumbnail](#api-rest-api-3-attachment-thumbnail-id-get).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** For the issue containing the attachment:\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
        operationId: 'getAttachmentContent';
        parameters: [
          {
            description: 'The ID of the attachment.';
            in: 'path';
            name: 'id';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Whether a redirect is provided for the attachment download. Clients that do not automatically follow redirects can set this to `false` to avoid making multiple requests to download the attachment.';
            in: 'query';
            name: 'redirect';
            schema: {
              default: true;
              type: 'boolean';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                schema: {
                  items: {};
                  type: 'array';
                };
              };
            };
            description: 'Returned if the request is successful when `redirect` is set to `false`.';
          };
          '206': {
            description: 'Returned if the request is successful when a `Range` header is provided and `redirect` is set to `false`.';
          };
          '303': {
            description: 'Returned if the request is successful. See the `Location` header for the download URL.';
          };
          '400': {
            description: 'Returned if the range supplied in the `Range` header is malformed.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect.';
          };
          '403': {
            description: 'The user does not have the necessary permission.';
          };
          '404': {
            description: 'Returned if:\n\n *  the attachment is not found.\n *  attachments are disabled in the Jira settings.';
          };
          '416': {
            description: 'Returned if the server is unable to satisfy the range of bytes provided.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Get attachment content';
        tags: ['Issue attachments'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': false;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:attachment:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/attachment/meta': {
      get: {
        deprecated: false;
        description: 'Returns the attachment settings, that is, whether attachments are enabled and the maximum attachment size allowed.\n\nNote that there are also [project permissions](https://confluence.atlassian.com/x/yodKLg) that restrict whether users can create and delete attachments.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** None.';
        operationId: 'getAttachmentMeta';
        parameters: [];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"enabled":true,"uploadLimit":1000000}';
                schema: {
                  $ref: '#/components/schemas/AttachmentSettings';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Get Jira attachment settings';
        tags: ['Issue attachments'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:instance-configuration:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/attachment/thumbnail/{id}': {
      get: {
        deprecated: false;
        description: 'Returns the thumbnail of an attachment.\n\nTo return the attachment contents, use [Get attachment content](#api-rest-api-3-attachment-content-id-get).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** For the issue containing the attachment:\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
        operationId: 'getAttachmentThumbnail';
        parameters: [
          {
            description: 'The ID of the attachment.';
            in: 'path';
            name: 'id';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Whether a redirect is provided for the attachment download. Clients that do not automatically follow redirects can set this to `false` to avoid making multiple requests to download the attachment.';
            in: 'query';
            name: 'redirect';
            schema: {
              default: true;
              type: 'boolean';
            };
          },
          {
            description: 'Whether a default thumbnail is returned when the requested thumbnail is not found.';
            in: 'query';
            name: 'fallbackToDefault';
            schema: {
              default: true;
              type: 'boolean';
            };
          },
          {
            description: 'The maximum width to scale the thumbnail to.';
            in: 'query';
            name: 'width';
            schema: {
              format: 'int32';
              type: 'integer';
            };
          },
          {
            description: 'The maximum height to scale the thumbnail to.';
            in: 'query';
            name: 'height';
            schema: {
              format: 'int32';
              type: 'integer';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                schema: {
                  items: {};
                  type: 'array';
                };
              };
            };
            description: 'Returned if the request is successful when `redirect` is set to `false`.';
          };
          '303': {
            description: 'Returned if the request is successful. See the `Location` header for the download URL.';
          };
          '400': {
            description: 'Returned if the request is invalid.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect.';
          };
          '403': {
            description: 'The user does not have the necessary permission.';
          };
          '404': {
            description: 'Returned if:\n\n *  the attachment is not found.\n *  attachments are disabled in the Jira settings.\n *  `fallbackToDefault` is `false` and the request thumbnail cannot be downloaded.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Get attachment thumbnail';
        tags: ['Issue attachments'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': false;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:attachment:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/attachment/{id}': {
      delete: {
        deprecated: false;
        description: 'Deletes an attachment from an issue.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** For the project holding the issue containing the attachment:\n\n *  *Delete own attachments* [project permission](https://confluence.atlassian.com/x/yodKLg) to delete an attachment created by the calling user.\n *  *Delete all attachments* [project permission](https://confluence.atlassian.com/x/yodKLg) to delete an attachment created by any user.';
        operationId: 'removeAttachment';
        parameters: [
          {
            description: 'The ID of the attachment.';
            in: 'path';
            name: 'id';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '204': {
            description: 'Returned if the request is successful.';
          };
          '403': {
            description: 'Returned if the user does not have the necessary permission.';
          };
          '404': {
            description: 'Returned if:\n\n *  the attachment is not found.\n *  attachments are disabled in the Jira settings.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['write:jira-work'];
          },
          {},
        ];
        summary: 'Delete attachment';
        tags: ['Issue attachments'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': false;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['write:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['delete:attachment:jira'];
            state: 'Beta';
          },
        ];
      };
      get: {
        deprecated: false;
        description: 'Returns the metadata for an attachment. Note that the attachment itself is not returned.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
        operationId: 'getAttachment';
        parameters: [
          {
            description: 'The ID of the attachment.';
            in: 'path';
            name: 'id';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"author":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"content":"https://your-domain.atlassian.net/jira/rest/api/3/attachment/content/10000","created":"2022-10-06T07:32:47.000+0000","filename":"picture.jpg","id":10000,"mimeType":"image/jpeg","self":"https://your-domain.atlassian.net/rest/api/3/attachments/10000","size":23123,"thumbnail":"https://your-domain.atlassian.net/jira/rest/api/3/attachment/thumbnail/10000"}';
                schema: {
                  $ref: '#/components/schemas/AttachmentMetadata';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'Returned if the user does not have the necessary permission.';
          };
          '404': {
            description: 'Returned if:\n\n *  the attachment is not found.\n *  attachments are disabled in the Jira settings.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Get attachment metadata';
        tags: ['Issue attachments'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': false;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: [
              'read:attachment:jira',
              'read:user:jira',
              'read:application-role:jira',
              'read:avatar:jira',
              'read:group:jira',
            ];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/attachment/{id}/expand/human': {
      get: {
        deprecated: false;
        description: "Returns the metadata for the contents of an attachment, if it is an archive, and metadata for the attachment itself. For example, if the attachment is a ZIP archive, then information about the files in the archive is returned and metadata for the ZIP archive. Currently, only the ZIP archive format is supported.\n\nUse this operation to retrieve data that is presented to the user, as this operation returns the metadata for the attachment itself, such as the attachment's ID and name. Otherwise, use [ Get contents metadata for an expanded attachment](#api-rest-api-3-attachment-id-expand-raw-get), which only returns the metadata for the attachment's contents.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** For the issue containing the attachment:\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.";
        operationId: 'expandAttachmentForHumans';
        parameters: [
          {
            description: 'The ID of the attachment.';
            in: 'path';
            name: 'id';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"entries":[{"index":0,"label":"MG00N067.JPG","mediaType":"image/jpeg","path":"MG00N067.JPG","size":"119 kB"},{"index":1,"label":"Allegro from Duet in C Major.mp3","mediaType":"audio/mpeg","path":"Allegro from Duet in C Major.mp3","size":"1.36 MB"},{"index":2,"label":"long/path/thanks/to/.../reach/the/leaf.txt","mediaType":"text/plain","path":"long/path/thanks/to/lots/of/subdirectories/inside/making/it/quite/hard/to/reach/the/leaf.txt","size":"0.0 k"}],"id":7237823,"mediaType":"application/zip","name":"images.zip","totalEntryCount":39}';
                schema: {
                  $ref: '#/components/schemas/AttachmentArchiveMetadataReadable';
                };
              };
            };
            description: 'Returned if the request is successful. If an empty list is returned in the response, the attachment is empty, corrupt, or not an archive.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'The user does not have the necessary permission.';
          };
          '404': {
            description: 'Returned if:\n\n *  the attachment is not found.\n *  attachments are disabled in the Jira settings.';
          };
          '409': {
            description: 'Returned if the attachment is an archive, but not a supported archive format.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Get all metadata for an expanded attachment';
        tags: ['Issue attachments'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': false;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:attachment:jira'];
            state: 'Beta';
          },
        ];
        'x-experimental': true;
      };
    };
    '/rest/api/3/attachment/{id}/expand/raw': {
      get: {
        deprecated: false;
        description: "Returns the metadata for the contents of an attachment, if it is an archive. For example, if the attachment is a ZIP archive, then information about the files in the archive is returned. Currently, only the ZIP archive format is supported.\n\nUse this operation if you are processing the data without presenting it to the user, as this operation only returns the metadata for the contents of the attachment. Otherwise, to retrieve data to present to the user, use [ Get all metadata for an expanded attachment](#api-rest-api-3-attachment-id-expand-human-get) which also returns the metadata for the attachment itself, such as the attachment's ID and name.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** For the issue containing the attachment:\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.";
        operationId: 'expandAttachmentForMachines';
        parameters: [
          {
            description: 'The ID of the attachment.';
            in: 'path';
            name: 'id';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"entries":[{"entryIndex":0,"mediaType":"audio/mpeg","name":"Allegro from Duet in C Major.mp3","size":1430174},{"entryIndex":1,"mediaType":"text/rtf","name":"lrm.rtf","size":331}],"totalEntryCount":24}';
                schema: {
                  $ref: '#/components/schemas/AttachmentArchiveImpl';
                };
              };
            };
            description: 'Returned if the request is successful. If an empty list is returned in the response, the attachment is empty, corrupt, or not an archive.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'The user does not have the necessary permission.';
          };
          '404': {
            description: 'Returned if:\n\n *  the attachment is not found.\n *  attachments are disabled in the Jira settings.';
          };
          '409': {
            description: 'Returned if the attachment is an archive, but not a supported archive format.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Get contents metadata for an expanded attachment';
        tags: ['Issue attachments'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': false;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:attachment:jira'];
            state: 'Beta';
          },
        ];
        'x-experimental': true;
      };
    };
    '/rest/api/3/auditing/record': {
      get: {
        deprecated: false;
        description: 'Returns a list of audit records. The list can be filtered to include items:\n\n *  where each item in `filter` has at least one match in any of these fields:\n    \n     *  `summary`\n     *  `category`\n     *  `eventSource`\n     *  `objectItem.name` If the object is a user, account ID is available to filter.\n     *  `objectItem.parentName`\n     *  `objectItem.typeName`\n     *  `changedValues.changedFrom`\n     *  `changedValues.changedTo`\n     *  `remoteAddress`\n    \n    For example, if `filter` contains *man ed*, an audit record containing `summary": "User added to group"` and `"category": "group management"` is returned.\n *  created on or after a date and time.\n *  created or or before a date and time.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
        operationId: 'getAuditRecords';
        parameters: [
          {
            description: 'The number of records to skip before returning the first result.';
            in: 'query';
            name: 'offset';
            schema: {
              default: 0;
              format: 'int32';
              type: 'integer';
            };
          },
          {
            description: 'The maximum number of results to return.';
            in: 'query';
            name: 'limit';
            schema: {
              default: 1000;
              format: 'int32';
              type: 'integer';
            };
          },
          {
            description: 'The strings to match with audit field content, space separated.';
            in: 'query';
            name: 'filter';
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The date and time on or after which returned audit records must have been created. If `to` is provided `from` must be before `to` or no audit records are returned.';
            in: 'query';
            name: 'from';
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The date and time on or before which returned audit results must have been created. If `from` is provided `to` must be after `from` or no audit records are returned.';
            in: 'query';
            name: 'to';
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"limit":1000,"offset":0,"records":[{"associatedItems":[{"id":"jira-software-users","name":"jira-software-users","parentId":"1","parentName":"Jira Internal Directory","typeName":"GROUP"}],"authorAccountId":"5ab8f18d741e9c2c7e9d4538","authorKey":"administrator","category":"user management","changedValues":[{"changedFrom":"user@atlassian.com","changedTo":"newuser@atlassian.com","fieldName":"email"}],"created":"2014-03-19T18:45:42.967+0000","description":"Optional description","eventSource":"Jira Connect Plugin","id":1,"objectItem":{"id":"user","name":"user","parentId":"1","parentName":"Jira Internal Directory","typeName":"USER"},"remoteAddress":"192.168.1.1","summary":"User created"}],"total":1}';
                schema: {
                  $ref: '#/components/schemas/AuditRecords';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if:\n\n *  the user does not have the required permissions.\n *  all Jira products are on free plans. Audit logs are available when at least one Jira product is on a paid plan.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['manage:jira-configuration'];
          },
        ];
        summary: 'Get audit records';
        tags: ['Audit records'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['manage:jira-configuration'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:audit-log:jira', 'read:user:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/avatar/{type}/system': {
      get: {
        deprecated: false;
        description: 'Returns a list of system avatar details by owner type, where the owner types are issue type, project, user or priority.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** None.';
        operationId: 'getAllSystemAvatars';
        parameters: [
          {
            description: 'The avatar type.';
            in: 'path';
            name: 'type';
            required: true;
            schema: {
              enum: ['issuetype', 'project', 'user', 'priority'];
              example: 'project';
              type: 'string';
            };
            'x-showInExample': 'true';
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"system":[{"id":"1000","isDeletable":false,"isSelected":false,"isSystemAvatar":true,"urls":{"16x16":"/secure/useravatar?size=xsmall&avatarId=10040&avatarType=project","24x24":"/secure/useravatar?size=small&avatarId=10040&avatarType=project","32x32":"/secure/useravatar?size=medium&avatarId=10040&avatarType=project","48x48":"/secure/useravatar?avatarId=10040&avatarType=project"}}]}';
                schema: {
                  $ref: '#/components/schemas/SystemAvatars';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '500': {
            description: 'Returned if an error occurs while retrieving the list of avatars.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['manage:jira-configuration'];
          },
          {},
        ];
        summary: 'Get system avatars by type';
        tags: ['Avatars'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['manage:jira-configuration'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:avatar:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/bulk/issues/fields': {
      get: {
        deprecated: false;
        description: 'Use this API to get a list of fields visible to the user to perform bulk edit operations. You can pass single or multiple issues in the query to get eligible editable fields. This API uses pagination to return responses, delivering 50 fields at a time.\n\n**[Permissions](#permissions) required:**\n\n *  Global bulk change [permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-global-permissions/).\n *  Browse [project permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-project-permissions/) in all projects that contain the selected issues.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  Depending on the field, any field-specific permissions required to edit it.';
        operationId: 'getBulkEditableFields';
        parameters: [
          {
            description: 'The IDs or keys of the issues to get editable fields from.';
            in: 'query';
            name: 'issueIdsOrKeys';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: '(Optional)The text to search for in the editable fields.';
            in: 'query';
            name: 'searchText';
            schema: {
              type: 'string';
            };
          },
          {
            description: '(Optional)The end cursor for use in pagination.';
            in: 'query';
            name: 'endingBefore';
            schema: {
              type: 'string';
            };
          },
          {
            description: '(Optional)The start cursor for use in pagination.';
            in: 'query';
            name: 'startingAfter';
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"fields":[{"id":"assignee","isRequired":false,"name":"Assignee","searchUrl":"https://your-domain.atlassian.net/rest/api/3/user/assignable/multiProjectSearch?projectKeys=KAN&query=","type":"assignee"},{"id":"components","isRequired":false,"multiSelectFieldOptions":["ADD","REMOVE","REPLACE","REMOVE_ALL"],"name":"Components","type":"components","unavailableMessage":"{0}NOTE{1}: The project of the selected issue(s) does not have any components."},{"fieldOptions":[{"description":"This problem will block progress.","id":"1","priority":"Highest"},{"description":"Has the potential to affect progress.","id":"2","priority":"Lowest"},{"description":"Trivial problem with little or no impact on progress.","id":"3","priority":"Medium"}],"id":"priority","isRequired":false,"name":"Priority","type":"priority"}]}';
                schema: {
                  $ref: '#/components/schemas/BulkEditGetFields';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/BulkOperationErrorResponse';
                };
              };
            };
            description: 'Returned if the request is not valid.';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/BulkOperationErrorResponse';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/BulkOperationErrorResponse';
                };
              };
            };
            description: 'Returned if the user does not have the necessary permission.';
          };
          '404': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/BulkOperationErrorResponse';
                };
              };
            };
            description: 'Returned if no editable fields are found for the provided issue IDs.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
        ];
        summary: 'Get bulk editable fields';
        tags: ['Issue bulk operations'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:issue:jira'];
            state: 'Beta';
          },
        ];
      };
      post: {
        deprecated: false;
        description: 'Use this API to submit a bulk edit request and simultaneously edit multiple issues. There are limits applied to the number of issues and fields that can be edited. A single request can accommodate a maximum of 1000 issues (including subtasks) and 200 fields.\n\n**[Permissions](#permissions) required:**\n\n *  Global bulk change [permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-global-permissions/).\n *  Browse [project permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-project-permissions/) in all projects that contain the selected issues.\n *  Edit [issues permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-project-permissions/) in all projects that contain the selected issues.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
        operationId: 'submitBulkEdit';
        parameters: [];
        requestBody: {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/IssueBulkEditPayload';
              };
            };
          };
          description: 'The request body containing the issues to be edited and the new field values.';
          required: true;
        };
        responses: {
          '201': {
            content: {
              'application/json': {
                example: '{"taskId":"10641"}';
                schema: {
                  $ref: '#/components/schemas/SubmittedBulkOperation';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            content: {
              'application/json': {
                example: '{"errors":[{"message":"The following editedFieldInput values are not listed as selectedActions : issuetype"}]}';
                schema: {
                  $ref: '#/components/schemas/BulkOperationErrorResponse';
                };
              };
            };
            description: 'Returned if the request is invalid.';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/BulkOperationErrorResponse';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['write:jira-work'];
          },
        ];
        summary: 'Bulk edit issues';
        tags: ['Issue bulk operations'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['write:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['write:issue:jira', 'read:issue:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/bulk/issues/move': {
      post: {
        deprecated: false;
        description: "Use this API to submit a bulk issue move request. You can move multiple issues, but they must all be moved to and from a single project, issue type, and parent. You can't move more than 1000 issues (including subtasks) at once.\n\n#### Scenarios: ####\n\nThis is an early version of the API and it doesn't have full feature parity with the Bulk Move UI experience.\n\n *  Moving issue of type A to issue of type B in the same project or a different project: `SUPPORTED`\n *  Moving multiple issues of type A in one project to multiple issues of type B in the same project or a different project: **`SUPPORTED`**\n *  Moving a standard parent issue of type A with its multiple subtask issue types in one project to standard issue of type B and multiple subtask issue types in the same project or a different project: `SUPPORTED`\n *  Moving an epic issue with its child issues to a different project without losing their relation: `NOT SUPPORTED`  \n    (Workaround: Move them individually and stitch the relationship back with the Bulk Edit API)\n\n#### Limits applied to bulk issue moves: ####\n\nWhen using the bulk move, keep in mind that there are limits on the number of issues and fields you can include.\n\n *  You can move up to 1,000 issues in a single operation, including any subtasks.\n *  All issues must originate from the same project and share the same issue type and parent.\n *  The total combined number of fields across all issues must not exceed 1,500,000. For example, if each issue includes 15,000 fields, then the maximum number of issues that can be moved is 100.\n\n**[Permissions](#permissions) required:**\n\n *  Global bulk change [permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-global-permissions/).\n *  Move [issues permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-project-permissions/) in source projects.\n *  Create [issues permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-project-permissions/) in destination projects.\n *  Browse [project permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-project-permissions/) in destination projects, if moving subtasks only.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.";
        operationId: 'submitBulkMove';
        parameters: [];
        requestBody: {
          content: {
            'application/json': {
              example: {
                sendBulkNotification: true;
                targetToSourcesMapping: {
                  'PROJECT-KEY,10001': {
                    inferClassificationDefaults: false;
                    inferFieldDefaults: false;
                    inferStatusDefaults: false;
                    inferSubtaskTypeDefault: true;
                    issueIdsOrKeys: ['ISSUE-1'];
                    targetClassification: [
                      {
                        classifications: {
                          '5bfa70f7-4af1-44f5-9e12-1ce185f15a38': ['bd58e74c-c31b-41a7-ba69-9673ebd9dae9', '-1'];
                        };
                      },
                    ];
                    targetMandatoryFields: [
                      {
                        fields: {
                          customfield_10000: {
                            retain: false;
                            type: 'raw';
                            value: ['value-1', 'value-2'];
                          };
                          description: {
                            retain: true;
                            type: 'adf';
                            value: {
                              content: [
                                {
                                  content: [
                                    {
                                      text: 'New description value';
                                      type: 'text';
                                    },
                                  ];
                                  type: 'paragraph';
                                },
                              ];
                              type: 'doc';
                              version: 1;
                            };
                          };
                          fixVersions: {
                            retain: false;
                            type: 'raw';
                            value: ['10009'];
                          };
                          labels: {
                            retain: false;
                            type: 'raw';
                            value: ['label-1', 'label-2'];
                          };
                        };
                      },
                    ];
                    targetStatus: [
                      {
                        statuses: {
                          '10001': ['10002', '10003'];
                        };
                      },
                    ];
                  };
                };
              };
              schema: {
                $ref: '#/components/schemas/IssueBulkMovePayload';
              };
            };
          };
          required: true;
        };
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"taskId":"10641"}';
                schema: {
                  $ref: '#/components/schemas/SubmittedBulkOperation';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            content: {
              'application/json': {
                example: '{"errors":[{"message":"Some of the issues in the issueIdsOrKeys are not valid"}]}';
                schema: {
                  $ref: '#/components/schemas/BulkOperationErrorResponse';
                };
              };
            };
            description: 'Returned if the request is invalid.';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/BulkOperationErrorResponse';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['write:jira-work'];
          },
        ];
        summary: 'Bulk move issues';
        tags: ['Issue bulk operations'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['write:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['write:issue:jira', 'read:issue:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/bulk/queue/{taskId}': {
      get: {
        deprecated: false;
        description: 'Use this to get the progress state for the specified bulk operation `taskId`.\n\n**[Permissions](#permissions) required:**\n\n *  Global bulk change [permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-global-permissions/).\n *  Administer Jira [global permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-global-permissions/), or be the creator of the task.\n\nIf the task is running, this resource will return:\n\n    {"taskId":"10779","status":"RUNNING","progressPercent":65,"submittedBy":{"accountId":"5b10a2844c20165700ede21g"},"created":1690180055963,"started":1690180056206,"updated":169018005829}\n\nIf the task has completed, then this resource will return:\n\n    {"processedAccessibleIssues":[10001,10002],"created":1709189449954,"progressPercent":100,"started":1709189450154,"status":"COMPLETE","submittedBy":{"accountId":"5b10a2844c20165700ede21g"},"invalidOrInaccessibleIssueCount":0,"taskId":"10000","totalIssueCount":2,"updated":1709189450354}\n\n**Note:** You can view task progress for up to 14 days from creation.';
        operationId: 'getBulkOperationProgress';
        parameters: [
          {
            description: 'The ID of the task.';
            in: 'path';
            name: 'taskId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"created":1704110400000,"invalidOrInaccessibleIssueCount":0,"processedAccessibleIssues":[10001,10002],"progressPercent":100,"started":1704110460000,"status":"COMPLETE","submittedBy":{"accountId":"5b10a2844c20165700ede21g"},"taskId":"10000","totalIssueCount":2,"updated":1704110520000}';
                schema: {
                  $ref: '#/components/schemas/BulkOperationProgress';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            content: {
              'application/json': {
                example: '{"errorMessages":["The task associated with this taskId is not a bulk operation task"],"errors":{},"httpStatusCode":{"empty":false,"present":true}}';
                schema: {
                  $ref: '#/components/schemas/BulkOperationErrorResponse';
                };
              };
            };
            description: 'Returned if the request is invalid.';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/BulkOperationErrorResponse';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
        ];
        summary: 'Get bulk issue operation progress';
        tags: ['Issue bulk operations'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:issue:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/classification-levels': {
      get: {
        deprecated: false;
        description: 'Returns all classification levels.\n\n**[Permissions](#permissions) required:** None.';
        operationId: 'getAllUserDataClassificationLevels';
        parameters: [
          {
            description: 'Optional set of statuses to filter by.';
            in: 'query';
            name: 'status';
            schema: {
              items: {
                default: '';
                description: 'The status of the project classification.';
                enum: ['PUBLISHED', 'ARCHIVED', 'DRAFT'];
                type: 'string';
              };
              type: 'array';
              uniqueItems: true;
            };
          },
          {
            description: 'Ordering of the results by a given field. If not provided, values will not be sorted.';
            in: 'query';
            name: 'orderBy';
            schema: {
              enum: ['rank', '-rank', '+rank'];
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"classifications":[{"id":"ari:cloud:platform::classification-tag/5bfa70f7-4af1-44f5-9e12-1ce185f15a38","status":"published","name":"Restricted","rank":1,"description":"Data we hold that would be very damaging and would cause loss of trust with customers and present legal risk to Atlassian and/or customers if mishandled","guideline":"Access to data must be restricted to only individuals who need access in order to perform their job duties.","color":"RED"},{"id":"ari:cloud:platform::classification-tag/bd58e74c-c31b-41a7-ba69-9673ebd9dae9","status":"archived","name":"Protected","rank":2,"description":"Data we hold that could cause loss of trust with customers or present legal risk to Atlassian if mishandled","guideline":"Access to systems or APIs mapping data to other identifiers must be carefully controlled.","color":"ORANGE"},{"id":"ari:cloud:platform::classification-tag/a82d653e-1035-4aa2-b9de-4265511fd487","status":"published","name":"Confidential","rank":3,"description":"Data we hold that would likely be damaging and could cause loss of trust with our customers if mishandled","guideline":"Data should be encrypted at rest and in transit.","color":"BLUE"},{"id":"ari:cloud:platform::classification-tag/a82d653e-1035-4aa2-b9de-4265511fd487","status":"published","name":"system-tag"}]}';
                schema: {
                  $ref: '#/components/schemas/DataClassificationLevelsBean';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
        ];
        summary: 'Get all classification levels';
        tags: ['Classification levels'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:project:jira'];
            state: 'Beta';
          },
        ];
        'x-experimental': true;
      };
    };
    '/rest/api/3/comment/list': {
      post: {
        deprecated: false;
        description: 'Returns a [paginated](#pagination) list of comments specified by a list of comment IDs.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** Comments are returned where the user:\n\n *  has *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project containing the comment.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  If the comment has visibility restrictions, belongs to the group or has the role visibility is restricted to.';
        operationId: 'getCommentsByIds';
        parameters: [
          {
            description: "Use [expand](#expansion) to include additional information about comments in the response. This parameter accepts a comma-separated list. Expand options include:\n\n *  `renderedBody` Returns the comment body rendered in HTML.\n *  `properties` Returns the comment's properties.";
            in: 'query';
            name: 'expand';
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              example: {
                ids: [1, 2, 5, 10];
              };
              schema: {
                $ref: '#/components/schemas/IssueCommentListRequestBean';
              };
            };
          };
          description: 'The list of comment IDs.';
          required: true;
        };
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"isLast":true,"maxResults":1048576,"startAt":0,"total":1,"values":[{"author":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"body":{"type":"doc","version":1,"content":[{"type":"paragraph","content":[{"type":"text","text":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque eget venenatis elit. Duis eu justo eget augue iaculis fermentum. Sed semper quam laoreet nisi egestas at posuere augue semper."}]}]},"created":"2021-01-17T12:34:00.000+0000","id":"10000","self":"https://your-domain.atlassian.net/rest/api/3/issue/10010/comment/10000","updateAuthor":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"updated":"2021-01-18T23:45:00.000+0000","visibility":{"identifier":"Administrators","type":"role","value":"Administrators"}}]}';
                schema: {
                  $ref: '#/components/schemas/PageBeanComment';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            description: 'Returned if the request contains more than 1000 IDs or is empty.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Get comments by IDs';
        tags: ['Issue comments'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': false;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: [
              'delete:comment.property:jira',
              'read:avatar:jira',
              'read:comment:jira',
              'read:group:jira',
              'read:project-role:jira',
              'read:user:jira',
              'read:comment.property:jira',
              'read:project:jira',
            ];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/comment/{commentId}/properties': {
      get: {
        deprecated: false;
        description: 'Returns the keys of all the properties of a comment.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  If the comment has visibility restrictions, belongs to the group or has the role visibility is restricted to.';
        operationId: 'getCommentPropertyKeys';
        parameters: [
          {
            description: 'The ID of the comment.';
            in: 'path';
            name: 'commentId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"keys":[{"key":"issue.support","self":"https://your-domain.atlassian.net/rest/api/3/issue/EX-2/properties/issue.support"}]}';
                schema: {
                  $ref: '#/components/schemas/PropertyKeys';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            description: 'Returned if the comment ID is invalid.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'Returned if the user does not have the necessary permission.';
          };
          '404': {
            description: 'Returned if the comment is not found.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Get comment property keys';
        tags: ['Issue comment properties'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': false;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:comment.property:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/comment/{commentId}/properties/{propertyKey}': {
      delete: {
        deprecated: false;
        description: 'Deletes a comment property.\n\n**[Permissions](#permissions) required:** either of:\n\n *  *Edit All Comments* [project permission](https://confluence.atlassian.com/x/yodKLg) to delete a property from any comment.\n *  *Edit Own Comments* [project permission](https://confluence.atlassian.com/x/yodKLg) to delete a property from a comment created by the user.\n\nAlso, when the visibility of a comment is restricted to a role or group the user must be a member of that role or group.';
        operationId: 'deleteCommentProperty';
        parameters: [
          {
            description: 'The ID of the comment.';
            in: 'path';
            name: 'commentId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The key of the property.';
            in: 'path';
            name: 'propertyKey';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '204': {
            description: 'Returned if the request is successful.';
          };
          '400': {
            description: 'Returned if the request is invalid.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'Returned if the user does not have the necessary permission.';
          };
          '404': {
            description: "Returned if the comment or the property is not found or the user has the necessary project permissions but isn't a member of the role or group visibility of the comment is restricted to.";
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['write:jira-work'];
          },
          {},
        ];
        summary: 'Delete comment property';
        tags: ['Issue comment properties'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': false;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['write:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['delete:comment.property:jira'];
            state: 'Beta';
          },
        ];
      };
      get: {
        deprecated: false;
        description: 'Returns the value of a comment property.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  If the comment has visibility restrictions, belongs to the group or has the role visibility is restricted to.';
        operationId: 'getCommentProperty';
        parameters: [
          {
            description: 'The ID of the comment.';
            in: 'path';
            name: 'commentId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The key of the property.';
            in: 'path';
            name: 'propertyKey';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"key":"issue.support","value":{"system.conversation.id":"b1bf38be-5e94-4b40-a3b8-9278735ee1e6","system.support.time":"1m"}}';
                schema: {
                  $ref: '#/components/schemas/EntityProperty';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            description: 'Returned if the request is invalid.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'Returned if the user does not have the necessary permission.';
          };
          '404': {
            description: 'Returned if the comment or the property is not found.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Get comment property';
        tags: ['Issue comment properties'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': false;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:comment.property:jira'];
            state: 'Beta';
          },
        ];
      };
      put: {
        deprecated: false;
        description: 'Creates or updates the value of a property for a comment. Use this resource to store custom data against a comment.\n\nThe value of the request body must be a [valid](http://tools.ietf.org/html/rfc4627), non-empty JSON blob. The maximum length is 32768 characters.\n\n**[Permissions](#permissions) required:** either of:\n\n *  *Edit All Comments* [project permission](https://confluence.atlassian.com/x/yodKLg) to create or update the value of a property on any comment.\n *  *Edit Own Comments* [project permission](https://confluence.atlassian.com/x/yodKLg) to create or update the value of a property on a comment created by the user.\n\nAlso, when the visibility of a comment is restricted to a role or group the user must be a member of that role or group.';
        operationId: 'setCommentProperty';
        parameters: [
          {
            description: 'The ID of the comment.';
            in: 'path';
            name: 'commentId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The key of the property. The maximum length is 255 characters.';
            in: 'path';
            name: 'propertyKey';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'The value of the property. The value has to be a valid, non-empty [JSON](https://tools.ietf.org/html/rfc4627) value. The maximum length of the property value is 32768 bytes.';
          required: true;
        };
        responses: {
          '200': {
            content: {
              'application/json': {
                schema: {};
              };
            };
            description: 'Returned if the comment property is updated.';
          };
          '201': {
            content: {
              'application/json': {
                schema: {};
              };
            };
            description: 'Returned if the comment property is created.';
          };
          '400': {
            description: 'Returned if the request is invalid.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'Returned if the user does not have the necessary permission.';
          };
          '404': {
            description: 'Returned if the comment is not found.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['write:jira-work'];
          },
          {},
        ];
        summary: 'Set comment property';
        tags: ['Issue comment properties'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': false;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['write:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['write:comment.property:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/component': {
      get: {
        deprecated: false;
        description: 'Returns a [paginated](#pagination) list of all components in a project, including global (Compass) components when applicable.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Browse Projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project.';
        operationId: 'findComponentsForProjects';
        parameters: [
          {
            description: 'The project IDs and/or project keys (case sensitive).';
            in: 'query';
            name: 'projectIdsOrKeys';
            schema: {
              items: {
                type: 'string';
              };
              type: 'array';
            };
          },
          {
            description: 'The index of the first item to return in a page of results (page offset).';
            in: 'query';
            name: 'startAt';
            schema: {
              default: 0;
              format: 'int64';
              type: 'integer';
            };
          },
          {
            description: 'The maximum number of items to return per page.';
            in: 'query';
            name: 'maxResults';
            schema: {
              default: 50;
              format: 'int32';
              type: 'integer';
            };
          },
          {
            description: '[Order](#ordering) the results by a field:\n\n *  `description` Sorts by the component description.\n *  `name` Sorts by component name.';
            in: 'query';
            name: 'orderBy';
            schema: {
              enum: ['description', '-description', '+description', 'name', '-name', '+name'];
              type: 'string';
            };
          },
          {
            description: 'Filter the results using a literal string. Components with a matching `name` or `description` are returned (case insensitive).';
            in: 'query';
            name: 'query';
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: ' com.atlassian.jira.issue.fields.rest.json.beans.ComponentJsonBean#PAGED_EXAMPLE} }';
                schema: {
                  $ref: '#/components/schemas/PageBean2ComponentJsonBean';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '404': {
            description: 'Returned if the project is not found or the user does not have permission to view it.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Find components for projects';
        tags: ['Project components'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: [
              'read:project:jira',
              'read:project.component:jira',
              'read:user:jira',
              'read:application-role:jira',
              'read:avatar:jira',
              'read:group:jira',
            ];
            state: 'Beta';
          },
        ];
      };
      post: {
        deprecated: false;
        description: 'Creates a component. Use components to provide containers for issues within a project. Use components to provide containers for issues within a project.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Administer projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project in which the component is created or *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
        operationId: 'createComponent';
        parameters: [];
        requestBody: {
          content: {
            'application/json': {
              example: {
                assigneeType: 'PROJECT_LEAD';
                description: 'This is a Jira component';
                isAssigneeTypeValid: false;
                leadAccountId: '5b10a2844c20165700ede21g';
                name: 'Component 1';
                project: 'HSP';
              };
              schema: {
                $ref: '#/components/schemas/ProjectComponent';
              };
            };
          };
          required: true;
        };
        responses: {
          '201': {
            content: {
              'application/json': {
                example: '{"ari":"ari:cloud:compass:fdb3fdec-4e70-be56-11ee-0242ac120002:component/fdb3fdec-4e70-11ee-be56-0242ac120002/fdb3fdec-11ee-4e70-be56-0242ac120002","assignee":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"assigneeType":"PROJECT_LEAD","description":"This is a Jira component","id":"10000","isAssigneeTypeValid":false,"lead":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"metadata":{"icon":"https://www.example.com/icon.png"},"name":"Component 1","project":"HSP","projectId":10000,"realAssignee":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"realAssigneeType":"PROJECT_LEAD","self":"https://your-domain.atlassian.net/rest/api/3/component/10000"}';
                schema: {
                  $ref: '#/components/schemas/ProjectComponent';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            description: 'Returned if:\n\n *  the user is not found.\n *  `name` is not provided.\n *  `name` is over 255 characters in length.\n *  `projectId` is not provided.\n *  `assigneeType` is an invalid value.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'Returned if the user does not have permission to manage the project containing the component or does not have permission to administer Jira.';
          };
          '404': {
            description: 'Returned if the project is not found or the user does not have permission to browse the project containing the component.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['manage:jira-project'];
          },
          {},
        ];
        summary: 'Create component';
        tags: ['Project components'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['manage:jira-project'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: [
              'read:project:jira',
              'read:user:jira',
              'write:project.component:jira',
              'read:application-role:jira',
              'read:avatar:jira',
              'read:group:jira',
              'read:project.component:jira',
            ];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/component/{id}': {
      delete: {
        deprecated: false;
        description: 'Deletes a component.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Administer projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project containing the component or *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
        operationId: 'deleteComponent';
        parameters: [
          {
            description: 'The ID of the component.';
            in: 'path';
            name: 'id';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The ID of the component to replace the deleted component. If this value is null no replacement is made.';
            in: 'query';
            name: 'moveIssuesTo';
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '204': {
            description: 'Returned if the request is successful.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'Returned if the user does not have permission to manage the project containing the component or does not have permission to administer Jira.';
          };
          '404': {
            description: 'Returned if:\n\n *  the component is not found.\n *  the replacement component is not found.\n *  the user does not have permission to browse the project containing the component.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['manage:jira-project'];
          },
          {},
        ];
        summary: 'Delete component';
        tags: ['Project components'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['manage:jira-project'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['delete:project.component:jira'];
            state: 'Beta';
          },
        ];
      };
      get: {
        deprecated: false;
        description: 'Returns a component.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for project containing the component.';
        operationId: 'getComponent';
        parameters: [
          {
            description: 'The ID of the component.';
            in: 'path';
            name: 'id';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"ari":"ari:cloud:compass:fdb3fdec-4e70-be56-11ee-0242ac120002:component/fdb3fdec-4e70-11ee-be56-0242ac120002/fdb3fdec-11ee-4e70-be56-0242ac120002","assignee":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"assigneeType":"PROJECT_LEAD","description":"This is a Jira component","id":"10000","isAssigneeTypeValid":false,"lead":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"metadata":{"icon":"https://www.example.com/icon.png"},"name":"Component 1","project":"HSP","projectId":10000,"realAssignee":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"realAssigneeType":"PROJECT_LEAD","self":"https://your-domain.atlassian.net/rest/api/3/component/10000"}';
                schema: {
                  $ref: '#/components/schemas/ProjectComponent';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '404': {
            description: 'Returned if the component is not found or the user does not have permission to browse the project containing the component.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Get component';
        tags: ['Project components'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: [
              'read:project:jira',
              'read:project.component:jira',
              'read:user:jira',
              'read:application-role:jira',
              'read:avatar:jira',
              'read:group:jira',
            ];
            state: 'Beta';
          },
        ];
      };
      put: {
        deprecated: false;
        description: 'Updates a component. Any fields included in the request are overwritten. If `leadAccountId` is an empty string ("") the component lead is removed.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Administer projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project containing the component or *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
        operationId: 'updateComponent';
        parameters: [
          {
            description: 'The ID of the component.';
            in: 'path';
            name: 'id';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              example: {
                assigneeType: 'PROJECT_LEAD';
                description: 'This is a Jira component';
                isAssigneeTypeValid: false;
                leadAccountId: '5b10a2844c20165700ede21g';
                name: 'Component 1';
              };
              schema: {
                $ref: '#/components/schemas/ProjectComponent';
              };
            };
          };
          required: true;
        };
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"ari":"ari:cloud:compass:fdb3fdec-4e70-be56-11ee-0242ac120002:component/fdb3fdec-4e70-11ee-be56-0242ac120002/fdb3fdec-11ee-4e70-be56-0242ac120002","assignee":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"assigneeType":"PROJECT_LEAD","description":"This is a Jira component","id":"10000","isAssigneeTypeValid":false,"lead":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"metadata":{"icon":"https://www.example.com/icon.png"},"name":"Component 1","project":"HSP","projectId":10000,"realAssignee":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"realAssigneeType":"PROJECT_LEAD","self":"https://your-domain.atlassian.net/rest/api/3/component/10000"}';
                schema: {
                  $ref: '#/components/schemas/ProjectComponent';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            description: 'Returned if:\n\n *  the user is not found.\n *  `assigneeType` is an invalid value.\n *  `name` is over 255 characters in length.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'Returned if the user does not have permission to manage the project containing the component or does not have permission to administer Jira.';
          };
          '404': {
            description: 'Returned if the component is not found or the user does not have permission to browse the project containing the component.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['manage:jira-project'];
          },
          {},
        ];
        summary: 'Update component';
        tags: ['Project components'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['manage:jira-project'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: [
              'read:project:jira',
              'read:user:jira',
              'write:project.component:jira',
              'read:application-role:jira',
              'read:avatar:jira',
              'read:group:jira',
              'read:project.component:jira',
            ];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/component/{id}/relatedIssueCounts': {
      get: {
        deprecated: false;
        description: 'Returns the counts of issues assigned to the component.\n\nThis operation can be accessed anonymously.\n\n**Deprecation notice:** The required OAuth 2.0 scopes will be updated on June 15, 2024.\n\n *  **Classic**: `read:jira-work`\n *  **Granular**: `read:field:jira`, `read:project.component:jira`\n\n**[Permissions](#permissions) required:** None.';
        operationId: 'getComponentRelatedIssues';
        parameters: [
          {
            description: 'The ID of the component.';
            in: 'path';
            name: 'id';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"issueCount":23,"self":"https://your-domain.atlassian.net/rest/api/3/component/10000"}';
                schema: {
                  $ref: '#/components/schemas/ComponentIssuesCount';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '404': {
            description: 'Returned if the component is not found.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Get component issues count';
        tags: ['Project components'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: [];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/configuration': {
      get: {
        deprecated: false;
        description: 'Returns the [global settings](https://confluence.atlassian.com/x/qYXKM) in Jira. These settings determine whether optional features (for example, subtasks, time tracking, and others) are enabled. If time tracking is enabled, this operation also returns the time tracking configuration.\n\n**[Permissions](#permissions) required:** Permission to access Jira.';
        operationId: 'getConfiguration';
        parameters: [];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"attachmentsEnabled":true,"issueLinkingEnabled":true,"subTasksEnabled":false,"timeTrackingConfiguration":{"defaultUnit":"day","timeFormat":"pretty","workingDaysPerWeek":5.0,"workingHoursPerDay":8.0},"timeTrackingEnabled":true,"unassignedIssuesAllowed":false,"votingEnabled":true,"watchingEnabled":true}';
                schema: {
                  $ref: '#/components/schemas/Configuration';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-user'];
          },
        ];
        summary: 'Get global settings';
        tags: ['Jira settings'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-user'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:instance-configuration:jira', 'read:issue.time-tracking:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/configuration/timetracking': {
      get: {
        deprecated: false;
        description: 'Returns the time tracking provider that is currently selected. Note that if time tracking is disabled, then a successful but empty response is returned.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
        operationId: 'getSelectedTimeTrackingImplementation';
        parameters: [];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"key":"Jira","name":"JIRA provided time tracking","url":"/example/config/url"}';
                schema: {
                  $ref: '#/components/schemas/TimeTrackingProvider';
                };
              };
            };
            description: 'Returned if the request is successful and time tracking is enabled.';
          };
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
            };
            description: 'Returned if the request is successful but time tracking is disabled.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'Returned if the user does not have the necessary permission.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['manage:jira-configuration'];
          },
        ];
        summary: 'Get selected time tracking provider';
        tags: ['Time tracking'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['manage:jira-configuration'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:issue.time-tracking:jira'];
            state: 'Beta';
          },
        ];
      };
      put: {
        deprecated: false;
        description: 'Selects a time tracking provider.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
        operationId: 'selectTimeTrackingImplementation';
        parameters: [];
        requestBody: {
          content: {
            'application/json': {
              example: {
                key: 'Jira';
              };
              schema: {
                $ref: '#/components/schemas/TimeTrackingProvider';
              };
            };
          };
          required: true;
        };
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            description: 'Returned if the time tracking provider is not found.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'Returned if the user does not have the necessary permission.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['manage:jira-configuration'];
          },
        ];
        summary: 'Select time tracking provider';
        tags: ['Time tracking'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['manage:jira-configuration'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['write:issue.time-tracking:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/configuration/timetracking/list': {
      get: {
        deprecated: false;
        description: 'Returns all time tracking providers. By default, Jira only has one time tracking provider: *JIRA provided time tracking*. However, you can install other time tracking providers via apps from the Atlassian Marketplace. For more information on time tracking providers, see the documentation for the [ Time Tracking Provider](https://developer.atlassian.com/cloud/jira/platform/modules/time-tracking-provider/) module.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
        operationId: 'getAvailableTimeTrackingImplementations';
        parameters: [];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '[{"key":"Jira","name":"JIRA provided time tracking","url":"/example/config/url"}]';
                schema: {
                  items: {
                    $ref: '#/components/schemas/TimeTrackingProvider';
                  };
                  type: 'array';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'Returned if the user does not have the necessary permission.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['manage:jira-configuration'];
          },
        ];
        summary: 'Get all time tracking providers';
        tags: ['Time tracking'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['manage:jira-configuration'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:issue.time-tracking:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/configuration/timetracking/options': {
      get: {
        deprecated: false;
        description: 'Returns the time tracking settings. This includes settings such as the time format, default time unit, and others. For more information, see [Configuring time tracking](https://confluence.atlassian.com/x/qoXKM).\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
        operationId: 'getSharedTimeTrackingConfiguration';
        parameters: [];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"defaultUnit":"hour","timeFormat":"pretty","workingDaysPerWeek":5.5,"workingHoursPerDay":7.6}';
                schema: {
                  $ref: '#/components/schemas/TimeTrackingConfiguration';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'Returned if the user does not have the necessary permission.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['manage:jira-configuration'];
          },
        ];
        summary: 'Get time tracking settings';
        tags: ['Time tracking'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['manage:jira-configuration'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:issue.time-tracking:jira'];
            state: 'Beta';
          },
        ];
      };
      put: {
        deprecated: false;
        description: 'Sets the time tracking settings.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
        operationId: 'setSharedTimeTrackingConfiguration';
        parameters: [];
        requestBody: {
          content: {
            'application/json': {
              example: {
                defaultUnit: 'hour';
                timeFormat: 'pretty';
                workingDaysPerWeek: 5.5;
                workingHoursPerDay: 7.6;
              };
              schema: {
                $ref: '#/components/schemas/TimeTrackingConfiguration';
              };
            };
          };
          required: true;
        };
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"defaultUnit":"hour","timeFormat":"pretty","workingDaysPerWeek":5.5,"workingHoursPerDay":7.6}';
                schema: {
                  $ref: '#/components/schemas/TimeTrackingConfiguration';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            description: 'Returned if the request object is invalid.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            description: 'Returned if the user does not have the necessary permission.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['manage:jira-configuration'];
          },
        ];
        summary: 'Set time tracking settings';
        tags: ['Time tracking'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['manage:jira-configuration'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['write:issue.time-tracking:jira', 'read:issue.time-tracking:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/customFieldOption/{id}': {
      get: {
        deprecated: false;
        description: 'Returns a custom field option. For example, an option in a select list.\n\nNote that this operation **only works for issue field select list options created in Jira or using operations from the [Issue custom field options](#api-group-Issue-custom-field-options) resource**, it cannot be used with issue field select list options created by Connect apps.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** The custom field option is returned as follows:\n\n *  if the user has the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).\n *  if the user has the *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for at least one project the custom field is used in, and the field is visible in at least one layout the user has permission to view.';
        operationId: 'getCustomFieldOption';
        parameters: [
          {
            description: 'The ID of the custom field option.';
            in: 'path';
            name: 'id';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"self":"https://your-domain.atlassian.net/rest/api/3/customFieldOption/10000","value":"To Do"}';
                schema: {
                  $ref: '#/components/schemas/CustomFieldOption';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '404': {
            description: 'Returned if:\n\n *  the custom field option is not found.\n *  the user does not have permission to view the custom field.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Get custom field option';
        tags: ['Issue custom field options'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:field:jira', 'read:field.option:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/dashboard': {
      get: {
        deprecated: false;
        description: 'Returns a list of dashboards owned by or shared with the user. The list may be filtered to include only favorite or owned dashboards.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** None.';
        operationId: 'getAllDashboards';
        parameters: [
          {
            description: 'The filter applied to the list of dashboards. Valid values are:\n\n *  `favourite` Returns dashboards the user has marked as favorite.\n *  `my` Returns dashboards owned by the user.';
            in: 'query';
            name: 'filter';
            schema: {
              enum: ['my', 'favourite'];
              type: 'string';
            };
          },
          {
            description: 'The index of the first item to return in a page of results (page offset).';
            in: 'query';
            name: 'startAt';
            schema: {
              default: 0;
              format: 'int32';
              type: 'integer';
            };
          },
          {
            description: 'The maximum number of items to return per page.';
            in: 'query';
            name: 'maxResults';
            schema: {
              default: 20;
              format: 'int32';
              type: 'integer';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"dashboards":[{"id":"10000","isFavourite":false,"name":"System Dashboard","popularity":1,"self":"https://your-domain.atlassian.net/rest/api/3/dashboard/10000","sharePermissions":[{"type":"global"}],"view":"https://your-domain.atlassian.net/secure/Dashboard.jspa?selectPageId=10000"},{"id":"20000","isFavourite":true,"name":"Build Engineering","owner":{"key":"Mia","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g","name":"mia","displayName":"Mia Krystof","avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"}},"popularity":1,"self":"https://your-domain.atlassian.net/rest/api/3/dashboard/20000","sharePermissions":[{"group":{"name":"administrators","self":"https://your-domain.atlassian.net/rest/api/3/group?groupname=administrators"},"id":10105,"type":"group"}],"view":"https://your-domain.atlassian.net/secure/Dashboard.jspa?selectPageId=20000"}],"maxResults":10,"next":"https://your-domain.atlassian.net/rest/api/3/dashboard?startAt=10","prev":"https://your-domain.atlassian.net/rest/api/3/dashboard?startAt=0","startAt":10,"total":143}';
                schema: {
                  $ref: '#/components/schemas/PageOfDashboards';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the request is invalid.';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Get all dashboards';
        tags: ['Dashboards'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: [
              'read:dashboard:jira',
              'read:group:jira',
              'read:project:jira',
              'read:project-role:jira',
              'read:user:jira',
              'read:application-role:jira',
              'read:avatar:jira',
              'read:issue-type-hierarchy:jira',
              'read:issue-type:jira',
              'read:project-category:jira',
              'read:project-version:jira',
              'read:project.component:jira',
            ];
            state: 'Beta';
          },
        ];
      };
      post: {
        deprecated: false;
        description: 'Creates a dashboard.\n\n**[Permissions](#permissions) required:** None.';
        operationId: 'createDashboard';
        parameters: [
          {
            description: 'Whether admin level permissions are used. It should only be true if the user has *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg)';
            in: 'query';
            name: 'extendAdminPermissions';
            schema: {
              default: false;
              type: 'boolean';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              example: {
                description: 'A dashboard to help auditors identify sample of issues to check.';
                editPermissions: [];
                name: 'Auditors dashboard';
                sharePermissions: [
                  {
                    type: 'global';
                  },
                ];
              };
              schema: {
                $ref: '#/components/schemas/DashboardDetails';
              };
            };
          };
          description: 'Dashboard details.';
          required: true;
        };
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"id":"10000","isFavourite":false,"name":"System Dashboard","popularity":1,"self":"https://your-domain.atlassian.net/rest/api/3/dashboard/10000","sharePermissions":[{"type":"global"}],"view":"https://your-domain.atlassian.net/secure/Dashboard.jspa?selectPageId=10000"}';
                schema: {
                  $ref: '#/components/schemas/Dashboard';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the request is not valid.';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['write:jira-work'];
          },
          {},
        ];
        summary: 'Create dashboard';
        tags: ['Dashboards'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['write:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: [
              'read:dashboard:jira',
              'read:group:jira',
              'read:project:jira',
              'read:project-role:jira',
              'read:user:jira',
              'write:dashboard:jira',
              'read:application-role:jira',
              'read:avatar:jira',
              'read:issue-type-hierarchy:jira',
              'read:issue-type:jira',
              'read:project-category:jira',
              'read:project-version:jira',
              'read:project.component:jira',
            ];
            state: 'Beta';
          },
        ];
        'x-experimental': true;
      };
    };
    '/rest/api/3/dashboard/bulk/edit': {
      put: {
        deprecated: false;
        description: 'Bulk edit dashboards. Maximum number of dashboards to be edited at the same time is 100.\n\n**[Permissions](#permissions) required:** None\n\nThe dashboards to be updated must be owned by the user, or the user must be an administrator.';
        operationId: 'bulkEditDashboards';
        parameters: [];
        requestBody: {
          content: {
            'application/json': {
              example: {
                action: 'changePermission';
                entityIds: [10001, 10002];
                extendAdminPermissions: true;
                permissionDetails: {
                  editPermissions: [
                    {
                      group: {
                        groupId: '276f955c-63d7-42c8-9520-92d01dca0625';
                        name: 'jira-administrators';
                        self: 'https://your-domain.atlassian.net/rest/api/~ver~/group?groupId=276f955c-63d7-42c8-9520-92d01dca0625';
                      };
                      id: 10010;
                      type: 'group';
                    },
                  ];
                  sharePermissions: [
                    {
                      id: 10000;
                      type: 'global';
                    },
                  ];
                };
              };
              schema: {
                $ref: '#/components/schemas/BulkEditShareableEntityRequest';
              };
            };
          };
          description: 'The details of dashboards being updated in bulk.';
          required: true;
        };
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"action":"changePermission","entityErrors":{"10002":{"errorMessages":["Only owner or editors of the dashboard can change permissions."],"errors":{}}}}';
                schema: {
                  $ref: '#/components/schemas/BulkEditShareableEntityResponse';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the request is not valid.';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['write:jira-work'];
          },
        ];
        summary: 'Bulk edit dashboards';
        tags: ['Dashboards'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['write:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: [
              'read:dashboard:jira',
              'read:group:jira',
              'read:project:jira',
              'read:project-role:jira',
              'read:user:jira',
              'write:dashboard:jira',
              'read:application-role:jira',
              'read:avatar:jira',
              'read:issue-type-hierarchy:jira',
              'read:issue-type:jira',
              'read:project-category:jira',
              'read:project-version:jira',
              'read:project.component:jira',
            ];
            state: 'Beta';
          },
        ];
        'x-experimental': true;
      };
    };
    '/rest/api/3/dashboard/gadgets': {
      get: {
        deprecated: false;
        description: 'Gets a list of all available gadgets that can be added to all dashboards.\n\n**[Permissions](#permissions) required:** None.';
        operationId: 'getAllAvailableDashboardGadgets';
        parameters: [];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"gadgets":[{"moduleKey":"com.atlassian.plugins.atlassian-connect-plugin:com.atlassian.connect.node.sample-addon__sample-dashboard-item","title":"Issue statistics"},{"uri":"rest/gadgets/1.0/g/com.atlassian.streams.streams-jira-plugin:activitystream-gadget/gadgets/activitystream-gadget.xml","title":"Activity Stream"}]}';
                schema: {
                  $ref: '#/components/schemas/AvailableDashboardGadgetsResponse';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: '400 response';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
        ];
        summary: 'Get available gadgets';
        tags: ['Dashboards'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:dashboard:jira'];
            state: 'Beta';
          },
        ];
        'x-experimental': true;
      };
    };
    '/rest/api/3/dashboard/search': {
      get: {
        deprecated: false;
        description: 'Returns a [paginated](#pagination) list of dashboards. This operation is similar to [Get dashboards](#api-rest-api-3-dashboard-get) except that the results can be refined to include dashboards that have specific attributes. For example, dashboards with a particular name. When multiple attributes are specified only filters matching all attributes are returned.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** The following dashboards that match the query parameters are returned:\n\n *  Dashboards owned by the user. Not returned for anonymous users.\n *  Dashboards shared with a group that the user is a member of. Not returned for anonymous users.\n *  Dashboards shared with a private project that the user can browse. Not returned for anonymous users.\n *  Dashboards shared with a public project.\n *  Dashboards shared with the public.';
        operationId: 'getDashboardsPaginated';
        parameters: [
          {
            description: 'String used to perform a case-insensitive partial match with `name`.';
            in: 'query';
            name: 'dashboardName';
            schema: {
              type: 'string';
            };
          },
          {
            description: 'User account ID used to return dashboards with the matching `owner.accountId`. This parameter cannot be used with the `owner` parameter.';
            in: 'query';
            name: 'accountId';
            schema: {
              maxLength: 128;
              type: 'string';
            };
          },
          {
            description: 'This parameter is deprecated because of privacy changes. Use `accountId` instead. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details. User name used to return dashboards with the matching `owner.name`. This parameter cannot be used with the `accountId` parameter.';
            in: 'query';
            name: 'owner';
            schema: {
              type: 'string';
            };
          },
          {
            description: "As a group's name can change, use of `groupId` is recommended. Group name used to return dashboards that are shared with a group that matches `sharePermissions.group.name`. This parameter cannot be used with the `groupId` parameter.";
            in: 'query';
            name: 'groupname';
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Group ID used to return dashboards that are shared with a group that matches `sharePermissions.group.groupId`. This parameter cannot be used with the `groupname` parameter.';
            in: 'query';
            name: 'groupId';
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Project ID used to returns dashboards that are shared with a project that matches `sharePermissions.project.id`.';
            in: 'query';
            name: 'projectId';
            schema: {
              format: 'int64';
              type: 'integer';
            };
          },
          {
            description: '[Order](#ordering) the results by a field:\n\n *  `description` Sorts by dashboard description. Note that this sort works independently of whether the expand to display the description field is in use.\n *  `favourite_count` Sorts by dashboard popularity.\n *  `id` Sorts by dashboard ID.\n *  `is_favourite` Sorts by whether the dashboard is marked as a favorite.\n *  `name` Sorts by dashboard name.\n *  `owner` Sorts by dashboard owner name.';
            in: 'query';
            name: 'orderBy';
            schema: {
              default: 'name';
              enum: [
                'description',
                '-description',
                '+description',
                'favorite_count',
                '-favorite_count',
                '+favorite_count',
                'id',
                '-id',
                '+id',
                'is_favorite',
                '-is_favorite',
                '+is_favorite',
                'name',
                '-name',
                '+name',
                'owner',
                '-owner',
                '+owner',
              ];
              type: 'string';
            };
          },
          {
            description: 'The index of the first item to return in a page of results (page offset).';
            in: 'query';
            name: 'startAt';
            schema: {
              default: 0;
              format: 'int64';
              type: 'integer';
            };
          },
          {
            description: 'The maximum number of items to return per page.';
            in: 'query';
            name: 'maxResults';
            schema: {
              default: 50;
              format: 'int32';
              type: 'integer';
            };
          },
          {
            description: 'The status to filter by. It may be active, archived or deleted.';
            in: 'query';
            name: 'status';
            schema: {
              default: 'active';
              enum: ['active', 'archived', 'deleted'];
              type: 'string';
            };
          },
          {
            description: 'Use [expand](#expansion) to include additional information about dashboard in the response. This parameter accepts a comma-separated list. Expand options include:\n\n *  `description` Returns the description of the dashboard.\n *  `owner` Returns the owner of the dashboard.\n *  `viewUrl` Returns the URL that is used to view the dashboard.\n *  `favourite` Returns `isFavourite`, an indicator of whether the user has set the dashboard as a favorite.\n *  `favouritedCount` Returns `popularity`, a count of how many users have set this dashboard as a favorite.\n *  `sharePermissions` Returns details of the share permissions defined for the dashboard.\n *  `editPermissions` Returns details of the edit permissions defined for the dashboard.\n *  `isWritable` Returns whether the current user has permission to edit the dashboard.';
            in: 'query';
            name: 'expand';
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"isLast":true,"maxResults":100,"self":"https://your-domain.atlassian.net/rest/api/3/dashboard/search?expand=owner&maxResults=50&startAt=0","startAt":0,"total":2,"values":[{"description":"Testing program","id":"1","isFavourite":true,"name":"Testing","owner":{"self":"https://your-domain.atlassian.net/user?accountId=5b10a2844c20165700ede21g","displayName":"Mia","active":true,"accountId":"5b10a2844c20165700ede21g","avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"}},"popularity":1,"self":"https://your-domain.atlassian.net/rest/api/3/dashboard/1","sharePermissions":[{"type":"global"}],"view":"https://your-domain.atlassian.net/Dashboard.jspa?selectPageId=1"},{"description":"Quantum initiative","id":"2","isFavourite":false,"name":"Quantum ","owner":{"self":"https://your-domain.atlassian.net/user?accountId=5b10a2844c20165700ede21g","displayName":"Mia","active":true,"accountId":"5b10a2844c20165700ede21g","avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"}},"popularity":0,"self":"https://your-domain.atlassian.net/rest/api/3/dashboard/2","sharePermissions":[{"type":"loggedin"}],"view":"https://your-domain.atlassian.net/Dashboard.jspa?selectPageId=2"}]}';
                schema: {
                  $ref: '#/components/schemas/PageBeanDashboard';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if:\n\n *  `orderBy` is invalid.\n *  `expand` includes an invalid value.\n *  `accountId` and `owner` are provided.\n *  `groupname` and `groupId` are provided.';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: '401 response';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Search for dashboards';
        tags: ['Dashboards'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: [
              'read:dashboard:jira',
              'read:group:jira',
              'read:project:jira',
              'read:project-role:jira',
              'read:user:jira',
              'read:application-role:jira',
              'read:avatar:jira',
              'read:issue-type-hierarchy:jira',
              'read:issue-type:jira',
              'read:project-category:jira',
              'read:project-version:jira',
              'read:project.component:jira',
            ];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/dashboard/{dashboardId}/gadget': {
      get: {
        deprecated: false;
        description: 'Returns a list of dashboard gadgets on a dashboard.\n\nThis operation returns:\n\n *  Gadgets from a list of IDs, when `id` is set.\n *  Gadgets with a module key, when `moduleKey` is set.\n *  Gadgets from a list of URIs, when `uri` is set.\n *  All gadgets, when no other parameters are set.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** None.';
        operationId: 'getAllGadgets';
        parameters: [
          {
            description: 'The ID of the dashboard.';
            in: 'path';
            name: 'dashboardId';
            required: true;
            schema: {
              format: 'int64';
              type: 'integer';
            };
          },
          {
            description: 'The list of gadgets module keys. To include multiple module keys, separate module keys with ampersand: `moduleKey=key:one&moduleKey=key:two`.';
            in: 'query';
            name: 'moduleKey';
            schema: {
              items: {
                default: '';
                type: 'string';
              };
              type: 'array';
            };
          },
          {
            description: 'The list of gadgets URIs. To include multiple URIs, separate URIs with ampersand: `uri=/rest/example/uri/1&uri=/rest/example/uri/2`.';
            in: 'query';
            name: 'uri';
            schema: {
              items: {
                default: '';
                type: 'string';
              };
              type: 'array';
            };
          },
          {
            description: 'The list of gadgets IDs. To include multiple IDs, separate IDs with ampersand: `gadgetId=10000&gadgetId=10001`.';
            in: 'query';
            name: 'gadgetId';
            schema: {
              items: {
                format: 'int64';
                type: 'integer';
              };
              type: 'array';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"gadgets":[{"id":10001,"moduleKey":"com.atlassian.plugins.atlassian-connect-plugin:com.atlassian.connect.node.sample-addon__sample-dashboard-item","color":"blue","position":{"row":0,"column":0},"title":"Issue statistics"},{"id":10002,"moduleKey":"com.atlassian.plugins.atlassian-connect-plugin:com.atlassian.connect.node.sample-addon__sample-dashboard-graph","color":"red","position":{"row":1,"column":0},"title":"Activity stream"},{"id":10003,"moduleKey":"com.atlassian.plugins.atlassian-connect-plugin:com.atlassian.connect.node.sample-addon__sample-dashboard-item","color":"yellow","position":{"row":0,"column":1},"title":"Bubble chart"}]}';
                schema: {
                  $ref: '#/components/schemas/DashboardGadgetResponse';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect.';
          };
          '404': {
            content: {
              'application/json': {
                example: '{"errorMessages":["The dashboard you requested either does not exist or you don\'t have the required permissions to perform this action."],"errors":{}}';
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the dashboard is not found.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Get gadgets';
        tags: ['Dashboards'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:dashboard:jira'];
            state: 'Beta';
          },
        ];
        'x-experimental': true;
      };
      post: {
        deprecated: false;
        description: 'Adds a gadget to a dashboard.\n\n**[Permissions](#permissions) required:** None.';
        operationId: 'addGadget';
        parameters: [
          {
            description: 'The ID of the dashboard.';
            in: 'path';
            name: 'dashboardId';
            required: true;
            schema: {
              format: 'int64';
              type: 'integer';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              example: {
                color: 'blue';
                ignoreUriAndModuleKeyValidation: false;
                moduleKey: 'com.atlassian.plugins.atlassian-connect-plugin:com.atlassian.connect.node.sample-addon__sample-dashboard-item';
                position: {
                  column: 1;
                  row: 0;
                };
                title: 'Issue statistics';
              };
              schema: {
                $ref: '#/components/schemas/DashboardGadgetSettings';
              };
            };
          };
          required: true;
        };
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"color":"blue","id":10001,"moduleKey":"com.atlassian.plugins.atlassian-connect-plugin:com.atlassian.connect.node.sample-addon__sample-dashboard-item","position":{"column":1,"row":0},"title":"Issue statistics"}';
                schema: {
                  $ref: '#/components/schemas/DashboardGadget';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            content: {
              'application/json': {
                example: '{"errorMessages":["Cannot add another gadget. The maximum number of gadgets the dashboard can hold has been reached."],"errors":{}}';
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the request is invalid.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '404': {
            content: {
              'application/json': {
                example: '{"errorMessages":["The dashboard you requested either does not exist or you don\'t have the required permissions to perform this action."],"errors":{}}';
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the dashboard is not found.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['write:jira-work', 'read:jira-work'];
          },
        ];
        summary: 'Add gadget to dashboard';
        tags: ['Dashboards'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['write:jira-work', 'read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['write:dashboard:jira', 'read:dashboard:jira'];
            state: 'Beta';
          },
        ];
        'x-experimental': true;
      };
    };
    '/rest/api/3/dashboard/{dashboardId}/gadget/{gadgetId}': {
      delete: {
        deprecated: false;
        description: 'Removes a dashboard gadget from a dashboard.\n\nWhen a gadget is removed from a dashboard, other gadgets in the same column are moved up to fill the emptied position.\n\n**[Permissions](#permissions) required:** None.';
        operationId: 'removeGadget';
        parameters: [
          {
            description: 'The ID of the dashboard.';
            in: 'path';
            name: 'dashboardId';
            required: true;
            schema: {
              format: 'int64';
              type: 'integer';
            };
          },
          {
            description: 'The ID of the gadget.';
            in: 'path';
            name: 'gadgetId';
            required: true;
            schema: {
              format: 'int64';
              type: 'integer';
            };
          },
        ];
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '404': {
            content: {
              'application/json': {
                example: '{"errorMessages":["The dashboard gadget was not found."],"errors":{}}';
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the gadget or the dashboard is not found.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['write:jira-work'];
          },
        ];
        summary: 'Remove gadget from dashboard';
        tags: ['Dashboards'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['write:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['write:dashboard:jira'];
            state: 'Beta';
          },
        ];
        'x-experimental': true;
      };
      put: {
        deprecated: false;
        description: 'Changes the title, position, and color of the gadget on a dashboard.\n\n**[Permissions](#permissions) required:** None.';
        operationId: 'updateGadget';
        parameters: [
          {
            description: 'The ID of the dashboard.';
            in: 'path';
            name: 'dashboardId';
            required: true;
            schema: {
              format: 'int64';
              type: 'integer';
            };
          },
          {
            description: 'The ID of the gadget.';
            in: 'path';
            name: 'gadgetId';
            required: true;
            schema: {
              format: 'int64';
              type: 'integer';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              example: {
                color: 'red';
                position: {
                  column: 1;
                  row: 1;
                };
                title: 'My new gadget title';
              };
              schema: {
                $ref: '#/components/schemas/DashboardGadgetUpdateRequest';
              };
            };
          };
          required: true;
        };
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            content: {
              'application/json': {
                example: '{"errorMessages":["The gadget cannot be placed in the selected row. The selected row does not exist on the dashboard."],"errors":{}}';
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the request is invalid.';
          };
          '401': {
            description: 'Returned if the authentication credentials are incorrect.';
          };
          '404': {
            content: {
              'application/json': {
                example: '{"errorMessages":["The dashboard you requested either does not exist or you don\'t have the required permissions to perform this action."],"errors":{}}';
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the gadget or the dashboard is not found.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['write:jira-work'];
          },
        ];
        summary: 'Update gadget on dashboard';
        tags: ['Dashboards'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['write:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['write:dashboard:jira'];
            state: 'Beta';
          },
        ];
        'x-experimental': true;
      };
    };
    '/rest/api/3/dashboard/{dashboardId}/items/{itemId}/properties': {
      get: {
        deprecated: false;
        description: 'Returns the keys of all properties for a dashboard item.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** The user must be the owner of the dashboard or have the dashboard shared with them. Note, users with the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) are considered owners of the System dashboard. The System dashboard is considered to be shared with all other users, and is accessible to anonymous users when Jira\\\\u2019s anonymous access is permitted.';
        operationId: 'getDashboardItemPropertyKeys';
        parameters: [
          {
            description: 'The ID of the dashboard.';
            in: 'path';
            name: 'dashboardId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The ID of the dashboard item.';
            in: 'path';
            name: 'itemId';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"keys":[{"key":"issue.support","self":"https://your-domain.atlassian.net/rest/api/3/issue/EX-2/properties/issue.support"}]}';
                schema: {
                  $ref: '#/components/schemas/PropertyKeys';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '404': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the dashboard or dashboard item is not found, or the dashboard is not owned by or shared with the user.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Get dashboard item property keys';
        tags: ['Dashboards'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:dashboard.property:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/dashboard/{dashboardId}/items/{itemId}/properties/{propertyKey}': {
      delete: {
        deprecated: false;
        description: 'Deletes a dashboard item property.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** The user must be the owner of the dashboard. Note, users with the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) are considered owners of the System dashboard.';
        operationId: 'deleteDashboardItemProperty';
        parameters: [
          {
            description: 'The ID of the dashboard.';
            in: 'path';
            name: 'dashboardId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The ID of the dashboard item.';
            in: 'path';
            name: 'itemId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The key of the dashboard item property.';
            in: 'path';
            name: 'propertyKey';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '204': {
            content: {
              'application/json': {
                schema: {};
              };
            };
            description: 'Returned if the dashboard item property is deleted.';
          };
          '400': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the dashboard or dashboard item ID is invalid.';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the user is not the owner of the dashboard.';
          };
          '404': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the dashboard item is not found or the dashboard is not shared with the user.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['write:jira-work'];
          },
          {},
        ];
        summary: 'Delete dashboard item property';
        tags: ['Dashboards'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['write:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['delete:dashboard.property:jira'];
            state: 'Beta';
          },
        ];
      };
      get: {
        deprecated: false;
        description: "Returns the key and value of a dashboard item property.\n\nA dashboard item enables an app to add user-specific information to a user dashboard. Dashboard items are exposed to users as gadgets that users can add to their dashboards. For more information on how users do this, see [Adding and customizing gadgets](https://confluence.atlassian.com/x/7AeiLQ).\n\nWhen an app creates a dashboard item it registers a callback to receive the dashboard item ID. The callback fires whenever the item is rendered or, where the item is configurable, the user edits the item. The app then uses this resource to store the item's content or configuration details. For more information on working with dashboard items, see [ Building a dashboard item for a JIRA Connect add-on](https://developer.atlassian.com/server/jira/platform/guide-building-a-dashboard-item-for-a-jira-connect-add-on-33746254/) and the [Dashboard Item](https://developer.atlassian.com/cloud/jira/platform/modules/dashboard-item/) documentation.\n\nThere is no resource to set or get dashboard items.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** The user must be the owner of the dashboard or have the dashboard shared with them. Note, users with the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) are considered owners of the System dashboard. The System dashboard is considered to be shared with all other users, and is accessible to anonymous users when Jira\\\\u2019s anonymous access is permitted.";
        operationId: 'getDashboardItemProperty';
        parameters: [
          {
            description: 'The ID of the dashboard.';
            in: 'path';
            name: 'dashboardId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The ID of the dashboard item.';
            in: 'path';
            name: 'itemId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The key of the dashboard item property.';
            in: 'path';
            name: 'propertyKey';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"key":"issue.support","value":{"system.conversation.id":"b1bf38be-5e94-4b40-a3b8-9278735ee1e6","system.support.time":"1m"}}';
                schema: {
                  $ref: '#/components/schemas/EntityProperty';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '404': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the dashboard, the dashboard item, or dashboard item property is not found, or the dashboard is not owned by or shared with the user.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Get dashboard item property';
        tags: ['Dashboards'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['read:dashboard.property:jira'];
            state: 'Beta';
          },
        ];
      };
      put: {
        deprecated: false;
        description: "Sets the value of a dashboard item property. Use this resource in apps to store custom data against a dashboard item.\n\nA dashboard item enables an app to add user-specific information to a user dashboard. Dashboard items are exposed to users as gadgets that users can add to their dashboards. For more information on how users do this, see [Adding and customizing gadgets](https://confluence.atlassian.com/x/7AeiLQ).\n\nWhen an app creates a dashboard item it registers a callback to receive the dashboard item ID. The callback fires whenever the item is rendered or, where the item is configurable, the user edits the item. The app then uses this resource to store the item's content or configuration details. For more information on working with dashboard items, see [ Building a dashboard item for a JIRA Connect add-on](https://developer.atlassian.com/server/jira/platform/guide-building-a-dashboard-item-for-a-jira-connect-add-on-33746254/) and the [Dashboard Item](https://developer.atlassian.com/cloud/jira/platform/modules/dashboard-item/) documentation.\n\nThere is no resource to set or get dashboard items.\n\nThe value of the request body must be a [valid](http://tools.ietf.org/html/rfc4627), non-empty JSON blob. The maximum length is 32768 characters.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** The user must be the owner of the dashboard. Note, users with the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) are considered owners of the System dashboard.";
        operationId: 'setDashboardItemProperty';
        parameters: [
          {
            description: 'The ID of the dashboard.';
            in: 'path';
            name: 'dashboardId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The ID of the dashboard item.';
            in: 'path';
            name: 'itemId';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'The key of the dashboard item property. The maximum length is 255 characters. For dashboard items with a spec URI and no complete module key, if the provided propertyKey is equal to "config", the request body\'s JSON must be an object with all keys and values as strings.';
            in: 'path';
            name: 'propertyKey';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              example: {
                number: 5;
                string: 'string-value';
              };
              schema: {};
            };
          };
          description: 'The value of the property. The value has to be a valid, non-empty [JSON](https://tools.ietf.org/html/rfc4627) value. The maximum length of the property value is 32768 bytes.';
          required: true;
        };
        responses: {
          '200': {
            content: {
              'application/json': {
                schema: {};
              };
            };
            description: 'Returned if the dashboard item property is updated.';
          };
          '201': {
            content: {
              'application/json': {
                schema: {};
              };
            };
            description: 'Returned if the dashboard item property is created.';
          };
          '400': {
            content: {
              'application/json': {
                example: '{"errorMessages":["The JSON data provided for the property has too many levels. It must be an object with all keys and values as strings."],"errors":{}}';
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if:\n\n *  Request is invalid\n *  Or if all of these conditions are met in the request:\n    \n     *  The dashboard item has a spec URI and no complete module key\n     *  The value of propertyKey is equal to "config"\n     *  The request body contains a JSON object whose keys and values are not strings.';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '403': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the user is not the owner of the dashboard.';
          };
          '404': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the dashboard item is not found or the dashboard is not shared with the user.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['write:jira-work'];
          },
          {},
        ];
        summary: 'Set dashboard item property';
        tags: ['Dashboards'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['write:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['write:dashboard.property:jira'];
            state: 'Beta';
          },
        ];
      };
    };
    '/rest/api/3/dashboard/{id}': {
      delete: {
        deprecated: false;
        description: 'Deletes a dashboard.\n\n**[Permissions](#permissions) required:** None\n\nThe dashboard to be deleted must be owned by the user.';
        operationId: 'deleteDashboard';
        parameters: [
          {
            description: 'The ID of the dashboard.';
            in: 'path';
            name: 'id';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '204': {
            description: 'Returned if the dashboard is deleted.';
          };
          '400': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: '400 response';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['write:jira-work'];
          },
          {},
        ];
        summary: 'Delete dashboard';
        tags: ['Dashboards'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['write:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: ['delete:dashboard:jira'];
            state: 'Beta';
          },
        ];
        'x-experimental': true;
      };
      get: {
        deprecated: false;
        description: 'Returns a dashboard.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** None.\n\nHowever, to get a dashboard, the dashboard must be shared with the user or the user must own it. Note, users with the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) are considered owners of the System dashboard. The System dashboard is considered to be shared with all other users.';
        operationId: 'getDashboard';
        parameters: [
          {
            description: 'The ID of the dashboard.';
            in: 'path';
            name: 'id';
            required: true;
            schema: {
              type: 'string';
            };
          },
        ];
        responses: {
          '200': {
            content: {
              'application/json': {
                example: '{"id":"10000","isFavourite":false,"name":"System Dashboard","popularity":1,"self":"https://your-domain.atlassian.net/rest/api/3/dashboard/10000","sharePermissions":[{"type":"global"}],"view":"https://your-domain.atlassian.net/secure/Dashboard.jspa?selectPageId=10000"}';
                schema: {
                  $ref: '#/components/schemas/Dashboard';
                };
              };
            };
            description: 'Returned if the request is successful.';
          };
          '400': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: '400 response';
          };
          '401': {
            content: {
              'application/json': {
                schema: {
                  $ref: '#/components/schemas/ErrorCollection';
                };
              };
            };
            description: 'Returned if the authentication credentials are incorrect or missing.';
          };
          '404': {
            description: 'Returned if the dashboard is not found or the dashboard is not owned by or shared with the user.';
          };
        };
        security: [
          {
            basicAuth: [];
          },
          {
            OAuth2: ['read:jira-work'];
          },
          {},
        ];
        summary: 'Get dashboard';
        tags: ['Dashboards'];
        'x-atlassian-data-security-policy': [
          {
            'app-access-rule-exempt': true;
          },
        ];
        'x-atlassian-oauth2-scopes': [
          {
            scheme: 'OAuth2';
            scopes: ['read:jira-work'];
            state: 'Current';
          },
          {
            scheme: 'OAuth2';
            scopes: [
              'read:dashboard:jira',
              'read:group:jira',
              'read:project:jira',
              'read:project-role:jira',
              'read:user:jira',
              'read:application-role:jira',
              'read:avatar:jira',
              'read:issue-type-hierarchy:jira',
              'read:issue-type:jira',
              'read:project-category:jira',
              'read:project-version:jira',
              'read:project.component:jira',
            ];
            state: 'Beta';
          },
        ];
      };
      put: {
        deprecated: false;
        description: 'Updates a dashboard, replacing all the dashboard details with those provided.\n\n**[Permissions](#permissions) required:** None\n\nThe dashboard to be updated must be owned by the user.';
        operationId: 'updateDashboard';
        parameters: [
          {
            description: 'The ID of the dashboard to update.';
            in: 'path';
            name: 'id';
            required: true;
            schema: {
              type: 'string';
            };
          },
          {
            description: 'Whether admin level permissions are used. It should only be true if the user has *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg)';
            in: 'query';
            name: 'extendAdminPermissions';
            schema: {
              default: false;
              type: 'boolean';
            };
          },
        ];
        requestBody: {
          content: {
            'application/json': {
              example