// @ts-nocheck
export type TPaths = {
  '/rest/api/3/announcementBanner': {
    get: {
      deprecated: false;
      description: 'Returns the current announcement banner configuration.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getBanner';
      parameters: [];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"hashId":"9HN2FJK9DM8BHRWERVW3RRTGDJ4G4D5C","isDismissible":false,"isEnabled":true,"message":"This is a public, enabled, non-dismissible banner, set using the API","visibility":"public"}';
              schema: {
                $ref: '#/components/schemas/AnnouncementBannerConfiguration';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '"Only admins can read banner configuration."';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the user does not have the necessary permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get announcement banner configuration';
      tags: ['Announcement banner'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Updates the announcement banner configuration.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'setBanner';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              isDismissible: false;
              isEnabled: true;
              message: 'This is a public, enabled, non-dismissible banner, set using the API';
              visibility: 'public';
            };
            schema: {
              $ref: '#/components/schemas/AnnouncementBannerConfigurationUpdate';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '"Banner message cannot be null."';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if an invalid parameter is passed.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '"Only admins can update banner configuration."';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the user does not have the necessary permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Update announcement banner configuration';
      tags: ['Announcement banner'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
    };
  };
  '/rest/api/3/app/field/value': {
    post: {
      deprecated: false;
      description: "Updates the value of one or more custom fields on one or more issues. Combinations of custom field and issue should be unique within the request.\n\nApps can only perform this operation on [custom fields](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field/) and [custom field types](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field-type/) declared in their own manifests.\n\n**[Permissions](#permissions) required:** Only the app that owns the custom field or custom field type can update its values with this operation.\n\nThe new `write:app-data:jira` OAuth scope is 100% optional now, and not using it won't break your app. However, we recommend adding it to your app's scope list because we will eventually make it mandatory.";
      operationId: 'updateMultipleCustomFieldValues';
      parameters: [
        {
          description: 'Whether to generate a changelog for this update.';
          in: 'query';
          name: 'generateChangelog';
          schema: {
            default: true;
            type: 'boolean';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              updates: [
                {
                  customField: 'customfield_10010';
                  issueIds: [10010, 10011];
                  value: 'new value';
                },
                {
                  customField: 'customfield_10011';
                  issueIds: [10010];
                  value: 1000;
                },
              ];
            };
            schema: {
              $ref: '#/components/schemas/MultipleCustomFieldValuesUpdateDetails';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is invalid.';
        };
        '403': {
          description: 'Returned if the request is not authenticated as the app that provided all the fields.';
        };
        '404': {
          description: 'Returned if any field is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: [];
        },
      ];
      summary: 'Update custom fields';
      tags: ['Issue custom field values (apps)'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: [];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:app-data:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/app/field/{fieldIdOrKey}/context/configuration': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of configurations for a custom field of a [type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field-type/) created by a [Forge app](https://developer.atlassian.com/platform/forge/).\n\nThe result can be filtered by one of these criteria:\n\n *  `id`.\n *  `fieldContextId`.\n *  `issueId`.\n *  `projectKeyOrId` and `issueTypeId`.\n\nOtherwise, all configurations are returned.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg). Jira permissions are not required for the Forge app that provided the custom field type.';
      operationId: 'getCustomFieldConfiguration';
      parameters: [
        {
          description: 'The ID or key of the custom field, for example `customfield_10000`.';
          in: 'path';
          name: 'fieldIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The list of configuration IDs. To include multiple configurations, separate IDs with an ampersand: `id=10000&id=10001`. Can't be provided with `fieldContextId`, `issueId`, `projectKeyOrId`, or `issueTypeId`.";
          in: 'query';
          name: 'id';
          schema: {
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: "The list of field context IDs. To include multiple field contexts, separate IDs with an ampersand: `fieldContextId=10000&fieldContextId=10001`. Can't be provided with `id`, `issueId`, `projectKeyOrId`, or `issueTypeId`.";
          in: 'query';
          name: 'fieldContextId';
          schema: {
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: "The ID of the issue to filter results by. If the issue doesn't exist, an empty list is returned. Can't be provided with `projectKeyOrId`, or `issueTypeId`.";
          in: 'query';
          name: 'issueId';
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: "The ID or key of the project to filter results by. Must be provided with `issueTypeId`. Can't be provided with `issueId`.";
          in: 'query';
          name: 'projectKeyOrId';
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the issue type to filter results by. Must be provided with `projectKeyOrId`. Can't be provided with `issueId`.";
          in: 'query';
          name: 'issueTypeId';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 100;
            format: 'int32';
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":1000,"startAt":0,"total":2,"values":[{"id":"10000","fieldContextId":"10010"},{"id":"10001","fieldContextId":"10011","configuration":{"minValue":0,"maxValue":10000},"schema":{"properties":{"amount":{"type":"number"},"currency":{"type":"string"}},"required":["amount","currency"]}}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanContextualConfiguration';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user is not a Jira admin or the request is not authenticated as from the app that provided the field.';
        };
        '404': {
          description: 'Returned if the custom field is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get custom field configurations';
      tags: ['Issue custom field configuration (apps)'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:custom-field-contextual-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Update the configuration for contexts of a custom field of a [type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field-type/) created by a [Forge app](https://developer.atlassian.com/platform/forge/).\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg). Jira permissions are not required for the Forge app that created the custom field type.';
      operationId: 'updateCustomFieldConfiguration';
      parameters: [
        {
          description: 'The ID or key of the custom field, for example `customfield_10000`.';
          in: 'path';
          name: 'fieldIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              configurations: [
                {
                  id: '10000';
                },
                {
                  configuration: {
                    maxValue: 10000;
                    minValue: 0;
                  };
                  id: '10001';
                  schema: {
                    properties: {
                      amount: {
                        type: 'number';
                      };
                      currency: {
                        type: 'string';
                      };
                    };
                    required: ['amount', 'currency'];
                  };
                },
              ];
            };
            schema: {
              $ref: '#/components/schemas/CustomFieldConfigurations';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user is not a Jira admin or the request is not authenticated as from the app that provided the field.';
        };
        '404': {
          description: 'Returned if the custom field is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Update custom field configurations';
      tags: ['Issue custom field configuration (apps)'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:custom-field-contextual-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/app/field/{fieldIdOrKey}/value': {
    put: {
      deprecated: false;
      description: "Updates the value of a custom field on one or more issues.\n\nApps can only perform this operation on [custom fields](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field/) and [custom field types](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field-type/) declared in their own manifests.\n\n**[Permissions](#permissions) required:** Only the app that owns the custom field or custom field type can update its values with this operation.\n\nThe new `write:app-data:jira` OAuth scope is 100% optional now, and not using it won't break your app. However, we recommend adding it to your app's scope list because we will eventually make it mandatory.";
      operationId: 'updateCustomFieldValue';
      parameters: [
        {
          description: 'The ID or key of the custom field. For example, `customfield_10010`.';
          in: 'path';
          name: 'fieldIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Whether to generate a changelog for this update.';
          in: 'query';
          name: 'generateChangelog';
          schema: {
            default: true;
            type: 'boolean';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              updates: [
                {
                  issueIds: [10010];
                  value: 'new value';
                },
              ];
            };
            schema: {
              $ref: '#/components/schemas/CustomFieldValueUpdateDetails';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is invalid.';
        };
        '403': {
          description: 'Returned if the request is not authenticated as the app that provided the field.';
        };
        '404': {
          description: 'Returned if the field is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: [];
        },
      ];
      summary: 'Update custom field value';
      tags: ['Issue custom field values (apps)'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: [];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:app-data:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/application-properties': {
    get: {
      deprecated: false;
      description: 'Returns all application properties or an application property.\n\nIf you specify a value for the `key` parameter, then an application property is returned as an object (not in an array). Otherwise, an array of all editable application properties is returned. See [Set application property](#api-rest-api-3-application-properties-id-put) for descriptions of editable properties.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getApplicationProperty';
      parameters: [
        {
          description: 'The key of the application property.';
          in: 'query';
          name: 'key';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The permission level of all items being returned in the list.';
          in: 'query';
          name: 'permissionLevel';
          schema: {
            type: 'string';
          };
        },
        {
          description: "When a `key` isn't provided, this filters the list of results by the application property `key` using a regular expression. For example, using `jira.lf.*` will return all application properties with keys that start with *jira.lf.*.";
          in: 'query';
          name: 'keyFilter';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '[{"defaultValue":"","desc":"Jira home directory","id":"jira.home","key":"jira.home","name":"jira.home","type":"string","value":"/var/jira/jira-home"},{"defaultValue":"CLONE -","id":"jira.clone.prefix","key":"jira.clone.prefix","name":"The prefix added to the Summary field of cloned issues","type":"string","value":"CLONE -"}]';
              schema: {
                items: {
                  $ref: '#/components/schemas/ApplicationProperty';
                };
                type: 'array';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the application property is not found or the user does not have permission to view it.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get application property';
      tags: ['Jira settings'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:instance-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/application-properties/advanced-settings': {
    get: {
      deprecated: false;
      description: 'Returns the application properties that are accessible on the *Advanced Settings* page. To navigate to the *Advanced Settings* page in Jira, choose the Jira icon > **Jira settings** > **System**, **General Configuration** and then click **Advanced Settings** (in the upper right).\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getAdvancedSettings';
      parameters: [];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '[{"defaultValue":"","desc":"Jira home directory","id":"jira.home","key":"jira.home","name":"jira.home","type":"string","value":"/var/jira/jira-home"},{"defaultValue":"CLONE -","id":"jira.clone.prefix","key":"jira.clone.prefix","name":"The prefix added to the Summary field of cloned issues","type":"string","value":"CLONE -"}]';
              schema: {
                items: {
                  $ref: '#/components/schemas/ApplicationProperty';
                };
                type: 'array';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user is not an administrator.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get advanced settings';
      tags: ['Jira settings'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:instance-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/application-properties/{id}': {
    put: {
      deprecated: false;
      description: 'Changes the value of an application property. For example, you can change the value of the `jira.clone.prefix` from its default value of *CLONE -* to *Clone -* if you prefer sentence case capitalization. Editable properties are described below along with their default values.\n\n#### Advanced settings ####\n\nThe advanced settings below are also accessible in [Jira](https://confluence.atlassian.com/x/vYXKM).\n\n| Key | Description | Default value |  \n| -- | -- | -- |  \n| `jira.clone.prefix` | The string of text prefixed to the title of a cloned issue. | `CLONE -` |  \n| `jira.date.picker.java.format` | The date format for the Java (server-side) generated dates. This must be the same as the `jira.date.picker.javascript.format` format setting. | `d/MMM/yy` |  \n| `jira.date.picker.javascript.format` | The date format for the JavaScript (client-side) generated dates. This must be the same as the `jira.date.picker.java.format` format setting. | `%e/%b/%y` |  \n| `jira.date.time.picker.java.format` | The date format for the Java (server-side) generated date times. This must be the same as the `jira.date.time.picker.javascript.format` format setting. | `dd/MMM/yy h:mm a` |  \n| `jira.date.time.picker.javascript.format` | The date format for the JavaScript (client-side) generated date times. This must be the same as the `jira.date.time.picker.java.format` format setting. | `%e/%b/%y %I:%M %p` |  \n| `jira.issue.actions.order` | The default order of actions (such as *Comments* or *Change history*) displayed on the issue view. | `asc` |  \n| `jira.view.issue.links.sort.order` | The sort order of the list of issue links on the issue view. | `type, status, priority` |  \n| `jira.comment.collapsing.minimum.hidden` | The minimum number of comments required for comment collapsing to occur. A value of `0` disables comment collapsing. | `4` |  \n| `jira.newsletter.tip.delay.days` | The number of days before a prompt to sign up to the Jira Insiders newsletter is shown. A value of `-1` disables this feature. | `7` |  \n\n\n#### Look and feel ####\n\nThe settings listed below adjust the [look and feel](https://confluence.atlassian.com/x/VwCLLg).\n\n| Key | Description | Default value |  \n| -- | -- | -- |  \n| `jira.lf.date.time` | The [ time format](https://docs.oracle.com/javase/6/docs/api/index.html?java/text/SimpleDateFormat.html). | `h:mm a` |  \n| `jira.lf.date.day` | The [ day format](https://docs.oracle.com/javase/6/docs/api/index.html?java/text/SimpleDateFormat.html). | `EEEE h:mm a` |  \n| `jira.lf.date.complete` | The [ date and time format](https://docs.oracle.com/javase/6/docs/api/index.html?java/text/SimpleDateFormat.html). | `dd/MMM/yy h:mm a` |  \n| `jira.lf.date.dmy` | The [ date format](https://docs.oracle.com/javase/6/docs/api/index.html?java/text/SimpleDateFormat.html). | `dd/MMM/yy` |  \n| `jira.date.time.picker.use.iso8061` | When enabled, sets Monday as the first day of the week in the date picker, as specified by the ISO8601 standard. | `false` |  \n| `jira.lf.logo.url` | The URL of the logo image file. | `/images/icon-jira-logo.png` |  \n| `jira.lf.logo.show.application.title` | Controls the visibility of the application title on the sidebar. | `false` |  \n| `jira.lf.favicon.url` | The URL of the favicon. | `/favicon.ico` |  \n| `jira.lf.favicon.hires.url` | The URL of the high-resolution favicon. | `/images/64jira.png` |  \n| `jira.lf.navigation.bgcolour` | The background color of the sidebar. | `#0747A6` |  \n| `jira.lf.navigation.highlightcolour` | The color of the text and logo of the sidebar. | `#DEEBFF` |  \n| `jira.lf.hero.button.base.bg.colour` | The background color of the hero button. | `#3b7fc4` |  \n| `jira.title` | The text for the application title. The application title can also be set in *General settings*. | `Jira` |  \n| `jira.option.globalsharing` | Whether filters and dashboards can be shared with anyone signed into Jira. | `true` |  \n| `xflow.product.suggestions.enabled` | Whether to expose product suggestions for other Atlassian products within Jira. | `true` |  \n\n\n#### Other settings ####\n\n| Key | Description | Default value |  \n| -- | -- | -- |  \n| `jira.issuenav.criteria.autoupdate` | Whether instant updates to search criteria is active. | `true` |  \n\n\n*Note: Be careful when changing [application properties and advanced settings](https://confluence.atlassian.com/x/vYXKM).*\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'setApplicationProperty';
      parameters: [
        {
          description: 'The key of the application property to update.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              id: 'jira.home';
              value: '/var/jira/jira-home';
            };
            schema: {
              $ref: '#/components/schemas/SimpleApplicationPropertyBean';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ApplicationProperty';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the data type of the `value` does not match the application property's data type. For example, a string is provided instead of an integer.";
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the user does not have permission to edit the property.';
        };
        '404': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the property is not found or the user does not have permission to view it.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Set application property';
      tags: ['Jira settings'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:instance-configuration:jira', 'read:instance-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/applicationrole': {
    get: {
      deprecated: false;
      description: 'Returns all application roles. In Jira, application roles are managed using the [Application access configuration](https://confluence.atlassian.com/x/3YxjL) page.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getAllApplicationRoles';
      parameters: [];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '[{"defaultGroups":["jira-software-users"],"defaultGroupsDetails":[{"groupId":"276f955c-63d7-42c8-9520-92d01dca0625","name":"jira-software-users","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=276f955c-63d7-42c8-9520-92d01dca0625"}],"defined":false,"groupDetails":[{"groupId":"42c8955c-63d7-42c8-9520-63d7aca0625","name":"jira-testers","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=42c8955c-63d7-42c8-9520-63d7aca0625"},{"groupId":"276f955c-63d7-42c8-9520-92d01dca0625","name":"jira-software-users","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=276f955c-63d7-42c8-9520-92d01dca0625"}],"groups":["jira-software-users","jira-testers"],"hasUnlimitedSeats":false,"key":"jira-software","name":"Jira Software","numberOfSeats":10,"platform":false,"remainingSeats":5,"selectedByDefault":false,"userCount":5,"userCountDescription":"5 developers"},{"defaultGroups":["jira-core-users"],"defaultGroupsDetails":[{"groupId":"92d01dca0625-42c8-42c8-9520-276f955c","name":"jira-core-users","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=92d01dca0625-42c8-42c8-9520-276f955c"}],"defined":false,"groupDetails":[{"groupId":"92d01dca0625-42c8-42c8-9520-276f955c","name":"jira-core-users","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=92d01dca0625-42c8-42c8-9520-276f955c"}],"groups":["jira-core-users"],"hasUnlimitedSeats":false,"key":"jira-core","name":"Jira Core","numberOfSeats":1,"platform":true,"remainingSeats":1,"selectedByDefault":false,"userCount":0,"userCountDescription":"0 users"}]';
              schema: {
                items: {
                  $ref: '#/components/schemas/ApplicationRole';
                };
                type: 'array';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user is not an administrator.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
      ];
      summary: 'Get all application roles';
      tags: ['Application roles'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
    };
  };
  '/rest/api/3/applicationrole/{key}': {
    get: {
      deprecated: false;
      description: 'Returns an application role.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getApplicationRole';
      parameters: [
        {
          description: 'The key of the application role. Use the [Get all application roles](#api-rest-api-3-applicationrole-get) operation to get the key for each application role.';
          in: 'path';
          name: 'key';
          required: true;
          schema: {
            example: 'jira-software';
            type: 'string';
          };
          'x-showInExample': 'true';
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"defaultGroups":["jira-software-users"],"defaultGroupsDetails":[{"groupId":"276f955c-63d7-42c8-9520-92d01dca0625","name":"jira-software-users","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=276f955c-63d7-42c8-9520-92d01dca0625"}],"defined":false,"groupDetails":[{"groupId":"42c8955c-63d7-42c8-9520-63d7aca0625","name":"jira-testers","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=42c8955c-63d7-42c8-9520-63d7aca0625"},{"groupId":"276f955c-63d7-42c8-9520-92d01dca0625","name":"jira-software-users","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=276f955c-63d7-42c8-9520-92d01dca0625"}],"groups":["jira-software-users","jira-testers"],"hasUnlimitedSeats":false,"key":"jira-software","name":"Jira Software","numberOfSeats":10,"platform":false,"remainingSeats":5,"selectedByDefault":false,"userCount":5,"userCountDescription":"5 developers"}';
              schema: {
                $ref: '#/components/schemas/ApplicationRole';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user is not an administrator.';
        };
        '404': {
          description: 'Returned if the role is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
      ];
      summary: 'Get application role';
      tags: ['Application roles'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
    };
  };
  '/rest/api/3/attachment/content/{id}': {
    get: {
      deprecated: false;
      description: 'Returns the contents of an attachment. A `Range` header can be set to define a range of bytes within the attachment to download. See the [HTTP Range header standard](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Range) for details.\n\nTo return a thumbnail of the attachment, use [Get attachment thumbnail](#api-rest-api-3-attachment-thumbnail-id-get).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** For the issue containing the attachment:\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'getAttachmentContent';
      parameters: [
        {
          description: 'The ID of the attachment.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Whether a redirect is provided for the attachment download. Clients that do not automatically follow redirects can set this to `false` to avoid making multiple requests to download the attachment.';
          in: 'query';
          name: 'redirect';
          schema: {
            default: true;
            type: 'boolean';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              schema: {
                items: {};
                type: 'array';
              };
            };
          };
          description: 'Returned if the request is successful when `redirect` is set to `false`.';
        };
        '206': {
          description: 'Returned if the request is successful when a `Range` header is provided and `redirect` is set to `false`.';
        };
        '303': {
          description: 'Returned if the request is successful. See the `Location` header for the download URL.';
        };
        '400': {
          description: 'Returned if the range supplied in the `Range` header is malformed.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect.';
        };
        '403': {
          description: 'The user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if:\n\n *  the attachment is not found.\n *  attachments are disabled in the Jira settings.';
        };
        '416': {
          description: 'Returned if the server is unable to satisfy the range of bytes provided.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get attachment content';
      tags: ['Issue attachments'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:attachment:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/attachment/meta': {
    get: {
      deprecated: false;
      description: 'Returns the attachment settings, that is, whether attachments are enabled and the maximum attachment size allowed.\n\nNote that there are also [project permissions](https://confluence.atlassian.com/x/yodKLg) that restrict whether users can create and delete attachments.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** None.';
      operationId: 'getAttachmentMeta';
      parameters: [];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"enabled":true,"uploadLimit":1000000}';
              schema: {
                $ref: '#/components/schemas/AttachmentSettings';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get Jira attachment settings';
      tags: ['Issue attachments'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:instance-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/attachment/thumbnail/{id}': {
    get: {
      deprecated: false;
      description: 'Returns the thumbnail of an attachment.\n\nTo return the attachment contents, use [Get attachment content](#api-rest-api-3-attachment-content-id-get).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** For the issue containing the attachment:\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'getAttachmentThumbnail';
      parameters: [
        {
          description: 'The ID of the attachment.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Whether a redirect is provided for the attachment download. Clients that do not automatically follow redirects can set this to `false` to avoid making multiple requests to download the attachment.';
          in: 'query';
          name: 'redirect';
          schema: {
            default: true;
            type: 'boolean';
          };
        },
        {
          description: 'Whether a default thumbnail is returned when the requested thumbnail is not found.';
          in: 'query';
          name: 'fallbackToDefault';
          schema: {
            default: true;
            type: 'boolean';
          };
        },
        {
          description: 'The maximum width to scale the thumbnail to.';
          in: 'query';
          name: 'width';
          schema: {
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The maximum height to scale the thumbnail to.';
          in: 'query';
          name: 'height';
          schema: {
            format: 'int32';
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              schema: {
                items: {};
                type: 'array';
              };
            };
          };
          description: 'Returned if the request is successful when `redirect` is set to `false`.';
        };
        '303': {
          description: 'Returned if the request is successful. See the `Location` header for the download URL.';
        };
        '400': {
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect.';
        };
        '403': {
          description: 'The user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if:\n\n *  the attachment is not found.\n *  attachments are disabled in the Jira settings.\n *  `fallbackToDefault` is `false` and the request thumbnail cannot be downloaded.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get attachment thumbnail';
      tags: ['Issue attachments'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:attachment:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/attachment/{id}': {
    delete: {
      deprecated: false;
      description: 'Deletes an attachment from an issue.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** For the project holding the issue containing the attachment:\n\n *  *Delete own attachments* [project permission](https://confluence.atlassian.com/x/yodKLg) to delete an attachment created by the calling user.\n *  *Delete all attachments* [project permission](https://confluence.atlassian.com/x/yodKLg) to delete an attachment created by any user.';
      operationId: 'removeAttachment';
      parameters: [
        {
          description: 'The ID of the attachment.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the request is successful.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if:\n\n *  the attachment is not found.\n *  attachments are disabled in the Jira settings.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Delete attachment';
      tags: ['Issue attachments'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:attachment:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: 'Returns the metadata for an attachment. Note that the attachment itself is not returned.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'getAttachment';
      parameters: [
        {
          description: 'The ID of the attachment.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"author":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"content":"https://your-domain.atlassian.net/jira/rest/api/3/attachment/content/10000","created":"2022-10-06T07:32:47.000+0000","filename":"picture.jpg","id":10000,"mimeType":"image/jpeg","self":"https://your-domain.atlassian.net/rest/api/3/attachments/10000","size":23123,"thumbnail":"https://your-domain.atlassian.net/jira/rest/api/3/attachment/thumbnail/10000"}';
              schema: {
                $ref: '#/components/schemas/AttachmentMetadata';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if:\n\n *  the attachment is not found.\n *  attachments are disabled in the Jira settings.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get attachment metadata';
      tags: ['Issue attachments'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:attachment:jira',
            'read:user:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:group:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/attachment/{id}/expand/human': {
    get: {
      deprecated: false;
      description: "Returns the metadata for the contents of an attachment, if it is an archive, and metadata for the attachment itself. For example, if the attachment is a ZIP archive, then information about the files in the archive is returned and metadata for the ZIP archive. Currently, only the ZIP archive format is supported.\n\nUse this operation to retrieve data that is presented to the user, as this operation returns the metadata for the attachment itself, such as the attachment's ID and name. Otherwise, use [ Get contents metadata for an expanded attachment](#api-rest-api-3-attachment-id-expand-raw-get), which only returns the metadata for the attachment's contents.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** For the issue containing the attachment:\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.";
      operationId: 'expandAttachmentForHumans';
      parameters: [
        {
          description: 'The ID of the attachment.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"entries":[{"index":0,"label":"MG00N067.JPG","mediaType":"image/jpeg","path":"MG00N067.JPG","size":"119 kB"},{"index":1,"label":"Allegro from Duet in C Major.mp3","mediaType":"audio/mpeg","path":"Allegro from Duet in C Major.mp3","size":"1.36 MB"},{"index":2,"label":"long/path/thanks/to/.../reach/the/leaf.txt","mediaType":"text/plain","path":"long/path/thanks/to/lots/of/subdirectories/inside/making/it/quite/hard/to/reach/the/leaf.txt","size":"0.0 k"}],"id":7237823,"mediaType":"application/zip","name":"images.zip","totalEntryCount":39}';
              schema: {
                $ref: '#/components/schemas/AttachmentArchiveMetadataReadable';
              };
            };
          };
          description: 'Returned if the request is successful. If an empty list is returned in the response, the attachment is empty, corrupt, or not an archive.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'The user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if:\n\n *  the attachment is not found.\n *  attachments are disabled in the Jira settings.';
        };
        '409': {
          description: 'Returned if the attachment is an archive, but not a supported archive format.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get all metadata for an expanded attachment';
      tags: ['Issue attachments'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:attachment:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/attachment/{id}/expand/raw': {
    get: {
      deprecated: false;
      description: "Returns the metadata for the contents of an attachment, if it is an archive. For example, if the attachment is a ZIP archive, then information about the files in the archive is returned. Currently, only the ZIP archive format is supported.\n\nUse this operation if you are processing the data without presenting it to the user, as this operation only returns the metadata for the contents of the attachment. Otherwise, to retrieve data to present to the user, use [ Get all metadata for an expanded attachment](#api-rest-api-3-attachment-id-expand-human-get) which also returns the metadata for the attachment itself, such as the attachment's ID and name.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** For the issue containing the attachment:\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.";
      operationId: 'expandAttachmentForMachines';
      parameters: [
        {
          description: 'The ID of the attachment.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"entries":[{"entryIndex":0,"mediaType":"audio/mpeg","name":"Allegro from Duet in C Major.mp3","size":1430174},{"entryIndex":1,"mediaType":"text/rtf","name":"lrm.rtf","size":331}],"totalEntryCount":24}';
              schema: {
                $ref: '#/components/schemas/AttachmentArchiveImpl';
              };
            };
          };
          description: 'Returned if the request is successful. If an empty list is returned in the response, the attachment is empty, corrupt, or not an archive.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'The user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if:\n\n *  the attachment is not found.\n *  attachments are disabled in the Jira settings.';
        };
        '409': {
          description: 'Returned if the attachment is an archive, but not a supported archive format.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get contents metadata for an expanded attachment';
      tags: ['Issue attachments'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:attachment:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/auditing/record': {
    get: {
      deprecated: false;
      description: 'Returns a list of audit records. The list can be filtered to include items:\n\n *  where each item in `filter` has at least one match in any of these fields:\n    \n     *  `summary`\n     *  `category`\n     *  `eventSource`\n     *  `objectItem.name` If the object is a user, account ID is available to filter.\n     *  `objectItem.parentName`\n     *  `objectItem.typeName`\n     *  `changedValues.changedFrom`\n     *  `changedValues.changedTo`\n     *  `remoteAddress`\n    \n    For example, if `filter` contains *man ed*, an audit record containing `summary": "User added to group"` and `"category": "group management"` is returned.\n *  created on or after a date and time.\n *  created or or before a date and time.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getAuditRecords';
      parameters: [
        {
          description: 'The number of records to skip before returning the first result.';
          in: 'query';
          name: 'offset';
          schema: {
            default: 0;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of results to return.';
          in: 'query';
          name: 'limit';
          schema: {
            default: 1000;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The strings to match with audit field content, space separated.';
          in: 'query';
          name: 'filter';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The date and time on or after which returned audit records must have been created. If `to` is provided `from` must be before `to` or no audit records are returned.';
          in: 'query';
          name: 'from';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The date and time on or before which returned audit results must have been created. If `from` is provided `to` must be after `from` or no audit records are returned.';
          in: 'query';
          name: 'to';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"limit":1000,"offset":0,"records":[{"associatedItems":[{"id":"jira-software-users","name":"jira-software-users","parentId":"1","parentName":"Jira Internal Directory","typeName":"GROUP"}],"authorAccountId":"5ab8f18d741e9c2c7e9d4538","authorKey":"administrator","category":"user management","changedValues":[{"changedFrom":"user@atlassian.com","changedTo":"newuser@atlassian.com","fieldName":"email"}],"created":"2014-03-19T18:45:42.967+0000","description":"Optional description","eventSource":"Jira Connect Plugin","id":1,"objectItem":{"id":"user","name":"user","parentId":"1","parentName":"Jira Internal Directory","typeName":"USER"},"remoteAddress":"192.168.1.1","summary":"User created"}],"total":1}';
              schema: {
                $ref: '#/components/schemas/AuditRecords';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if:\n\n *  the user does not have the required permissions.\n *  all Jira products are on free plans. Audit logs are available when at least one Jira product is on a paid plan.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get audit records';
      tags: ['Audit records'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:audit-log:jira', 'read:user:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/avatar/{type}/system': {
    get: {
      deprecated: false;
      description: 'Returns a list of system avatar details by owner type, where the owner types are issue type, project, user or priority.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** None.';
      operationId: 'getAllSystemAvatars';
      parameters: [
        {
          description: 'The avatar type.';
          in: 'path';
          name: 'type';
          required: true;
          schema: {
            enum: ['issuetype', 'project', 'user', 'priority'];
            example: 'project';
            type: 'string';
          };
          'x-showInExample': 'true';
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"system":[{"id":"1000","isDeletable":false,"isSelected":false,"isSystemAvatar":true,"urls":{"16x16":"/secure/useravatar?size=xsmall&avatarId=10040&avatarType=project","24x24":"/secure/useravatar?size=small&avatarId=10040&avatarType=project","32x32":"/secure/useravatar?size=medium&avatarId=10040&avatarType=project","48x48":"/secure/useravatar?avatarId=10040&avatarType=project"}}]}';
              schema: {
                $ref: '#/components/schemas/SystemAvatars';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '500': {
          description: 'Returned if an error occurs while retrieving the list of avatars.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
        {},
      ];
      summary: 'Get system avatars by type';
      tags: ['Avatars'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:avatar:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/bulk/issues/fields': {
    get: {
      deprecated: false;
      description: 'Use this API to get a list of fields visible to the user to perform bulk edit operations. You can pass single or multiple issues in the query to get eligible editable fields. This API uses pagination to return responses, delivering 50 fields at a time.\n\n**[Permissions](#permissions) required:**\n\n *  Global bulk change [permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-global-permissions/).\n *  Browse [project permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-project-permissions/) in all projects that contain the selected issues.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  Depending on the field, any field-specific permissions required to edit it.';
      operationId: 'getBulkEditableFields';
      parameters: [
        {
          description: 'The IDs or keys of the issues to get editable fields from.';
          in: 'query';
          name: 'issueIdsOrKeys';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '(Optional)The text to search for in the editable fields.';
          in: 'query';
          name: 'searchText';
          schema: {
            type: 'string';
          };
        },
        {
          description: '(Optional)The end cursor for use in pagination.';
          in: 'query';
          name: 'endingBefore';
          schema: {
            type: 'string';
          };
        },
        {
          description: '(Optional)The start cursor for use in pagination.';
          in: 'query';
          name: 'startingAfter';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"fields":[{"id":"assignee","isRequired":false,"name":"Assignee","searchUrl":"https://your-domain.atlassian.net/rest/api/3/user/assignable/multiProjectSearch?projectKeys=KAN&query=","type":"assignee"},{"id":"components","isRequired":false,"multiSelectFieldOptions":["ADD","REMOVE","REPLACE","REMOVE_ALL"],"name":"Components","type":"components","unavailableMessage":"{0}NOTE{1}: The project of the selected issue(s) does not have any components."},{"fieldOptions":[{"description":"This problem will block progress.","id":"1","priority":"Highest"},{"description":"Has the potential to affect progress.","id":"2","priority":"Lowest"},{"description":"Trivial problem with little or no impact on progress.","id":"3","priority":"Medium"}],"id":"priority","isRequired":false,"name":"Priority","type":"priority"}]}';
              schema: {
                $ref: '#/components/schemas/BulkEditGetFields';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/BulkOperationErrorResponse';
              };
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/BulkOperationErrorResponse';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/BulkOperationErrorResponse';
              };
            };
          };
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/BulkOperationErrorResponse';
              };
            };
          };
          description: 'Returned if no editable fields are found for the provided issue IDs.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
      ];
      summary: 'Get bulk editable fields';
      tags: ['Issue bulk operations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue:jira'];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Use this API to submit a bulk edit request and simultaneously edit multiple issues. There are limits applied to the number of issues and fields that can be edited. A single request can accommodate a maximum of 1000 issues (including subtasks) and 200 fields.\n\n**[Permissions](#permissions) required:**\n\n *  Global bulk change [permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-global-permissions/).\n *  Browse [project permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-project-permissions/) in all projects that contain the selected issues.\n *  Edit [issues permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-project-permissions/) in all projects that contain the selected issues.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'submitBulkEdit';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/IssueBulkEditPayload';
            };
          };
        };
        description: 'The request body containing the issues to be edited and the new field values.';
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              example: '{"taskId":"10641"}';
              schema: {
                $ref: '#/components/schemas/SubmittedBulkOperation';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errors":[{"message":"The following editedFieldInput values are not listed as selectedActions : issuetype"}]}';
              schema: {
                $ref: '#/components/schemas/BulkOperationErrorResponse';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/BulkOperationErrorResponse';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
      ];
      summary: 'Bulk edit issues';
      tags: ['Issue bulk operations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue:jira', 'read:issue:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/bulk/issues/move': {
    post: {
      deprecated: false;
      description: "Use this API to submit a bulk issue move request. You can move multiple issues, but they must all be moved to and from a single project, issue type, and parent. You can't move more than 1000 issues (including subtasks) at once.\n\n#### Scenarios: ####\n\nThis is an early version of the API and it doesn't have full feature parity with the Bulk Move UI experience.\n\n *  Moving issue of type A to issue of type B in the same project or a different project: `SUPPORTED`\n *  Moving multiple issues of type A in one project to multiple issues of type B in the same project or a different project: **`SUPPORTED`**\n *  Moving a standard parent issue of type A with its multiple subtask issue types in one project to standard issue of type B and multiple subtask issue types in the same project or a different project: `SUPPORTED`\n *  Moving an epic issue with its child issues to a different project without losing their relation: `NOT SUPPORTED`  \n    (Workaround: Move them individually and stitch the relationship back with the Bulk Edit API)\n\n#### Limits applied to bulk issue moves: ####\n\nWhen using the bulk move, keep in mind that there are limits on the number of issues and fields you can include.\n\n *  You can move up to 1,000 issues in a single operation, including any subtasks.\n *  All issues must originate from the same project and share the same issue type and parent.\n *  The total combined number of fields across all issues must not exceed 1,500,000. For example, if each issue includes 15,000 fields, then the maximum number of issues that can be moved is 100.\n\n**[Permissions](#permissions) required:**\n\n *  Global bulk change [permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-global-permissions/).\n *  Move [issues permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-project-permissions/) in source projects.\n *  Create [issues permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-project-permissions/) in destination projects.\n *  Browse [project permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-project-permissions/) in destination projects, if moving subtasks only.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.";
      operationId: 'submitBulkMove';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              sendBulkNotification: true;
              targetToSourcesMapping: {
                'PROJECT-KEY,10001': {
                  inferClassificationDefaults: false;
                  inferFieldDefaults: false;
                  inferStatusDefaults: false;
                  inferSubtaskTypeDefault: true;
                  issueIdsOrKeys: ['ISSUE-1'];
                  targetClassification: [
                    {
                      classifications: {
                        '5bfa70f7-4af1-44f5-9e12-1ce185f15a38': ['bd58e74c-c31b-41a7-ba69-9673ebd9dae9', '-1'];
                      };
                    },
                  ];
                  targetMandatoryFields: [
                    {
                      fields: {
                        customfield_10000: {
                          retain: false;
                          type: 'raw';
                          value: ['value-1', 'value-2'];
                        };
                        description: {
                          retain: true;
                          type: 'adf';
                          value: {
                            content: [
                              {
                                content: [
                                  {
                                    text: 'New description value';
                                    type: 'text';
                                  },
                                ];
                                type: 'paragraph';
                              },
                            ];
                            type: 'doc';
                            version: 1;
                          };
                        };
                        fixVersions: {
                          retain: false;
                          type: 'raw';
                          value: ['10009'];
                        };
                        labels: {
                          retain: false;
                          type: 'raw';
                          value: ['label-1', 'label-2'];
                        };
                      };
                    },
                  ];
                  targetStatus: [
                    {
                      statuses: {
                        '10001': ['10002', '10003'];
                      };
                    },
                  ];
                };
              };
            };
            schema: {
              $ref: '#/components/schemas/IssueBulkMovePayload';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"taskId":"10641"}';
              schema: {
                $ref: '#/components/schemas/SubmittedBulkOperation';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errors":[{"message":"Some of the issues in the issueIdsOrKeys are not valid"}]}';
              schema: {
                $ref: '#/components/schemas/BulkOperationErrorResponse';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/BulkOperationErrorResponse';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
      ];
      summary: 'Bulk move issues';
      tags: ['Issue bulk operations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue:jira', 'read:issue:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/bulk/queue/{taskId}': {
    get: {
      deprecated: false;
      description: 'Use this to get the progress state for the specified bulk operation `taskId`.\n\n**[Permissions](#permissions) required:**\n\n *  Global bulk change [permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-global-permissions/).\n *  Administer Jira [global permission](https://support.atlassian.com/jira-cloud-administration/docs/manage-global-permissions/), or be the creator of the task.\n\nIf the task is running, this resource will return:\n\n    {"taskId":"10779","status":"RUNNING","progressPercent":65,"submittedBy":{"accountId":"5b10a2844c20165700ede21g"},"created":1690180055963,"started":1690180056206,"updated":169018005829}\n\nIf the task has completed, then this resource will return:\n\n    {"processedAccessibleIssues":[10001,10002],"created":1709189449954,"progressPercent":100,"started":1709189450154,"status":"COMPLETE","submittedBy":{"accountId":"5b10a2844c20165700ede21g"},"invalidOrInaccessibleIssueCount":0,"taskId":"10000","totalIssueCount":2,"updated":1709189450354}\n\n**Note:** You can view task progress for up to 14 days from creation.';
      operationId: 'getBulkOperationProgress';
      parameters: [
        {
          description: 'The ID of the task.';
          in: 'path';
          name: 'taskId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"created":1704110400000,"invalidOrInaccessibleIssueCount":0,"processedAccessibleIssues":[10001,10002],"progressPercent":100,"started":1704110460000,"status":"COMPLETE","submittedBy":{"accountId":"5b10a2844c20165700ede21g"},"taskId":"10000","totalIssueCount":2,"updated":1704110520000}';
              schema: {
                $ref: '#/components/schemas/BulkOperationProgress';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The task associated with this taskId is not a bulk operation task"],"errors":{},"httpStatusCode":{"empty":false,"present":true}}';
              schema: {
                $ref: '#/components/schemas/BulkOperationErrorResponse';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/BulkOperationErrorResponse';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
      ];
      summary: 'Get bulk issue operation progress';
      tags: ['Issue bulk operations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/classification-levels': {
    get: {
      deprecated: false;
      description: 'Returns all classification levels.\n\n**[Permissions](#permissions) required:** None.';
      operationId: 'getAllUserDataClassificationLevels';
      parameters: [
        {
          description: 'Optional set of statuses to filter by.';
          in: 'query';
          name: 'status';
          schema: {
            items: {
              default: '';
              description: 'The status of the project classification.';
              enum: ['PUBLISHED', 'ARCHIVED', 'DRAFT'];
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: 'Ordering of the results by a given field. If not provided, values will not be sorted.';
          in: 'query';
          name: 'orderBy';
          schema: {
            enum: ['rank', '-rank', '+rank'];
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"classifications":[{"id":"ari:cloud:platform::classification-tag/5bfa70f7-4af1-44f5-9e12-1ce185f15a38","status":"published","name":"Restricted","rank":1,"description":"Data we hold that would be very damaging and would cause loss of trust with customers and present legal risk to Atlassian and/or customers if mishandled","guideline":"Access to data must be restricted to only individuals who need access in order to perform their job duties.","color":"RED"},{"id":"ari:cloud:platform::classification-tag/bd58e74c-c31b-41a7-ba69-9673ebd9dae9","status":"archived","name":"Protected","rank":2,"description":"Data we hold that could cause loss of trust with customers or present legal risk to Atlassian if mishandled","guideline":"Access to systems or APIs mapping data to other identifiers must be carefully controlled.","color":"ORANGE"},{"id":"ari:cloud:platform::classification-tag/a82d653e-1035-4aa2-b9de-4265511fd487","status":"published","name":"Confidential","rank":3,"description":"Data we hold that would likely be damaging and could cause loss of trust with our customers if mishandled","guideline":"Data should be encrypted at rest and in transit.","color":"BLUE"},{"id":"ari:cloud:platform::classification-tag/a82d653e-1035-4aa2-b9de-4265511fd487","status":"published","name":"system-tag"}]}';
              schema: {
                $ref: '#/components/schemas/DataClassificationLevelsBean';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
      ];
      summary: 'Get all classification levels';
      tags: ['Classification levels'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:project:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/comment/list': {
    post: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of comments specified by a list of comment IDs.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** Comments are returned where the user:\n\n *  has *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project containing the comment.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  If the comment has visibility restrictions, belongs to the group or has the role visibility is restricted to.';
      operationId: 'getCommentsByIds';
      parameters: [
        {
          description: "Use [expand](#expansion) to include additional information about comments in the response. This parameter accepts a comma-separated list. Expand options include:\n\n *  `renderedBody` Returns the comment body rendered in HTML.\n *  `properties` Returns the comment's properties.";
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              ids: [1, 2, 5, 10];
            };
            schema: {
              $ref: '#/components/schemas/IssueCommentListRequestBean';
            };
          };
        };
        description: 'The list of comment IDs.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":1048576,"startAt":0,"total":1,"values":[{"author":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"body":{"type":"doc","version":1,"content":[{"type":"paragraph","content":[{"type":"text","text":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque eget venenatis elit. Duis eu justo eget augue iaculis fermentum. Sed semper quam laoreet nisi egestas at posuere augue semper."}]}]},"created":"2021-01-17T12:34:00.000+0000","id":"10000","self":"https://your-domain.atlassian.net/rest/api/3/issue/10010/comment/10000","updateAuthor":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"updated":"2021-01-18T23:45:00.000+0000","visibility":{"identifier":"Administrators","type":"role","value":"Administrators"}}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanComment';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request contains more than 1000 IDs or is empty.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get comments by IDs';
      tags: ['Issue comments'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'delete:comment.property:jira',
            'read:avatar:jira',
            'read:comment:jira',
            'read:group:jira',
            'read:project-role:jira',
            'read:user:jira',
            'read:comment.property:jira',
            'read:project:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/comment/{commentId}/properties': {
    get: {
      deprecated: false;
      description: 'Returns the keys of all the properties of a comment.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  If the comment has visibility restrictions, belongs to the group or has the role visibility is restricted to.';
      operationId: 'getCommentPropertyKeys';
      parameters: [
        {
          description: 'The ID of the comment.';
          in: 'path';
          name: 'commentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"keys":[{"key":"issue.support","self":"https://your-domain.atlassian.net/rest/api/3/issue/EX-2/properties/issue.support"}]}';
              schema: {
                $ref: '#/components/schemas/PropertyKeys';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the comment ID is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if the comment is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get comment property keys';
      tags: ['Issue comment properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:comment.property:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/comment/{commentId}/properties/{propertyKey}': {
    delete: {
      deprecated: false;
      description: 'Deletes a comment property.\n\n**[Permissions](#permissions) required:** either of:\n\n *  *Edit All Comments* [project permission](https://confluence.atlassian.com/x/yodKLg) to delete a property from any comment.\n *  *Edit Own Comments* [project permission](https://confluence.atlassian.com/x/yodKLg) to delete a property from a comment created by the user.\n\nAlso, when the visibility of a comment is restricted to a role or group the user must be a member of that role or group.';
      operationId: 'deleteCommentProperty';
      parameters: [
        {
          description: 'The ID of the comment.';
          in: 'path';
          name: 'commentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The key of the property.';
          in: 'path';
          name: 'propertyKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: "Returned if the comment or the property is not found or the user has the necessary project permissions but isn't a member of the role or group visibility of the comment is restricted to.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Delete comment property';
      tags: ['Issue comment properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:comment.property:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: 'Returns the value of a comment property.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  If the comment has visibility restrictions, belongs to the group or has the role visibility is restricted to.';
      operationId: 'getCommentProperty';
      parameters: [
        {
          description: 'The ID of the comment.';
          in: 'path';
          name: 'commentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The key of the property.';
          in: 'path';
          name: 'propertyKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"key":"issue.support","value":{"system.conversation.id":"b1bf38be-5e94-4b40-a3b8-9278735ee1e6","system.support.time":"1m"}}';
              schema: {
                $ref: '#/components/schemas/EntityProperty';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if the comment or the property is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get comment property';
      tags: ['Issue comment properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:comment.property:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Creates or updates the value of a property for a comment. Use this resource to store custom data against a comment.\n\nThe value of the request body must be a [valid](http://tools.ietf.org/html/rfc4627), non-empty JSON blob. The maximum length is 32768 characters.\n\n**[Permissions](#permissions) required:** either of:\n\n *  *Edit All Comments* [project permission](https://confluence.atlassian.com/x/yodKLg) to create or update the value of a property on any comment.\n *  *Edit Own Comments* [project permission](https://confluence.atlassian.com/x/yodKLg) to create or update the value of a property on a comment created by the user.\n\nAlso, when the visibility of a comment is restricted to a role or group the user must be a member of that role or group.';
      operationId: 'setCommentProperty';
      parameters: [
        {
          description: 'The ID of the comment.';
          in: 'path';
          name: 'commentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The key of the property. The maximum length is 255 characters.';
          in: 'path';
          name: 'propertyKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {};
          };
        };
        description: 'The value of the property. The value has to be a valid, non-empty [JSON](https://tools.ietf.org/html/rfc4627) value. The maximum length of the property value is 32768 bytes.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the comment property is updated.';
        };
        '201': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the comment property is created.';
        };
        '400': {
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if the comment is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Set comment property';
      tags: ['Issue comment properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:comment.property:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/component': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of all components in a project, including global (Compass) components when applicable.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Browse Projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project.';
      operationId: 'findComponentsForProjects';
      parameters: [
        {
          description: 'The project IDs and/or project keys (case sensitive).';
          in: 'query';
          name: 'projectIdsOrKeys';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: '[Order](#ordering) the results by a field:\n\n *  `description` Sorts by the component description.\n *  `name` Sorts by component name.';
          in: 'query';
          name: 'orderBy';
          schema: {
            enum: ['description', '-description', '+description', 'name', '-name', '+name'];
            type: 'string';
          };
        },
        {
          description: 'Filter the results using a literal string. Components with a matching `name` or `description` are returned (case insensitive).';
          in: 'query';
          name: 'query';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: ' com.atlassian.jira.issue.fields.rest.json.beans.ComponentJsonBean#PAGED_EXAMPLE} }';
              schema: {
                $ref: '#/components/schemas/PageBean2ComponentJsonBean';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if the project is not found or the user does not have permission to view it.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Find components for projects';
      tags: ['Project components'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:project:jira',
            'read:project.component:jira',
            'read:user:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:group:jira',
          ];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Creates a component. Use components to provide containers for issues within a project. Use components to provide containers for issues within a project.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Administer projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project in which the component is created or *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'createComponent';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              assigneeType: 'PROJECT_LEAD';
              description: 'This is a Jira component';
              isAssigneeTypeValid: false;
              leadAccountId: '5b10a2844c20165700ede21g';
              name: 'Component 1';
              project: 'HSP';
            };
            schema: {
              $ref: '#/components/schemas/ProjectComponent';
            };
          };
        };
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              example: '{"ari":"ari:cloud:compass:fdb3fdec-4e70-be56-11ee-0242ac120002:component/fdb3fdec-4e70-11ee-be56-0242ac120002/fdb3fdec-11ee-4e70-be56-0242ac120002","assignee":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"assigneeType":"PROJECT_LEAD","description":"This is a Jira component","id":"10000","isAssigneeTypeValid":false,"lead":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"metadata":{"icon":"https://www.example.com/icon.png"},"name":"Component 1","project":"HSP","projectId":10000,"realAssignee":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"realAssigneeType":"PROJECT_LEAD","self":"https://your-domain.atlassian.net/rest/api/3/component/10000"}';
              schema: {
                $ref: '#/components/schemas/ProjectComponent';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if:\n\n *  the user is not found.\n *  `name` is not provided.\n *  `name` is over 255 characters in length.\n *  `projectId` is not provided.\n *  `assigneeType` is an invalid value.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have permission to manage the project containing the component or does not have permission to administer Jira.';
        };
        '404': {
          description: 'Returned if the project is not found or the user does not have permission to browse the project containing the component.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-project'];
        },
        {},
      ];
      summary: 'Create component';
      tags: ['Project components'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-project'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:project:jira',
            'read:user:jira',
            'write:project.component:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:group:jira',
            'read:project.component:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/component/{id}': {
    delete: {
      deprecated: false;
      description: 'Deletes a component.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Administer projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project containing the component or *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'deleteComponent';
      parameters: [
        {
          description: 'The ID of the component.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the component to replace the deleted component. If this value is null no replacement is made.';
          in: 'query';
          name: 'moveIssuesTo';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have permission to manage the project containing the component or does not have permission to administer Jira.';
        };
        '404': {
          description: 'Returned if:\n\n *  the component is not found.\n *  the replacement component is not found.\n *  the user does not have permission to browse the project containing the component.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-project'];
        },
        {},
      ];
      summary: 'Delete component';
      tags: ['Project components'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-project'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:project.component:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: 'Returns a component.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for project containing the component.';
      operationId: 'getComponent';
      parameters: [
        {
          description: 'The ID of the component.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"ari":"ari:cloud:compass:fdb3fdec-4e70-be56-11ee-0242ac120002:component/fdb3fdec-4e70-11ee-be56-0242ac120002/fdb3fdec-11ee-4e70-be56-0242ac120002","assignee":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"assigneeType":"PROJECT_LEAD","description":"This is a Jira component","id":"10000","isAssigneeTypeValid":false,"lead":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"metadata":{"icon":"https://www.example.com/icon.png"},"name":"Component 1","project":"HSP","projectId":10000,"realAssignee":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"realAssigneeType":"PROJECT_LEAD","self":"https://your-domain.atlassian.net/rest/api/3/component/10000"}';
              schema: {
                $ref: '#/components/schemas/ProjectComponent';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if the component is not found or the user does not have permission to browse the project containing the component.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get component';
      tags: ['Project components'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:project:jira',
            'read:project.component:jira',
            'read:user:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:group:jira',
          ];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Updates a component. Any fields included in the request are overwritten. If `leadAccountId` is an empty string ("") the component lead is removed.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Administer projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project containing the component or *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'updateComponent';
      parameters: [
        {
          description: 'The ID of the component.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              assigneeType: 'PROJECT_LEAD';
              description: 'This is a Jira component';
              isAssigneeTypeValid: false;
              leadAccountId: '5b10a2844c20165700ede21g';
              name: 'Component 1';
            };
            schema: {
              $ref: '#/components/schemas/ProjectComponent';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"ari":"ari:cloud:compass:fdb3fdec-4e70-be56-11ee-0242ac120002:component/fdb3fdec-4e70-11ee-be56-0242ac120002/fdb3fdec-11ee-4e70-be56-0242ac120002","assignee":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"assigneeType":"PROJECT_LEAD","description":"This is a Jira component","id":"10000","isAssigneeTypeValid":false,"lead":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"metadata":{"icon":"https://www.example.com/icon.png"},"name":"Component 1","project":"HSP","projectId":10000,"realAssignee":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"realAssigneeType":"PROJECT_LEAD","self":"https://your-domain.atlassian.net/rest/api/3/component/10000"}';
              schema: {
                $ref: '#/components/schemas/ProjectComponent';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if:\n\n *  the user is not found.\n *  `assigneeType` is an invalid value.\n *  `name` is over 255 characters in length.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have permission to manage the project containing the component or does not have permission to administer Jira.';
        };
        '404': {
          description: 'Returned if the component is not found or the user does not have permission to browse the project containing the component.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-project'];
        },
        {},
      ];
      summary: 'Update component';
      tags: ['Project components'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-project'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:project:jira',
            'read:user:jira',
            'write:project.component:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:group:jira',
            'read:project.component:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/component/{id}/relatedIssueCounts': {
    get: {
      deprecated: false;
      description: 'Returns the counts of issues assigned to the component.\n\nThis operation can be accessed anonymously.\n\n**Deprecation notice:** The required OAuth 2.0 scopes will be updated on June 15, 2024.\n\n *  **Classic**: `read:jira-work`\n *  **Granular**: `read:field:jira`, `read:project.component:jira`\n\n**[Permissions](#permissions) required:** None.';
      operationId: 'getComponentRelatedIssues';
      parameters: [
        {
          description: 'The ID of the component.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"issueCount":23,"self":"https://your-domain.atlassian.net/rest/api/3/component/10000"}';
              schema: {
                $ref: '#/components/schemas/ComponentIssuesCount';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if the component is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get component issues count';
      tags: ['Project components'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/configuration': {
    get: {
      deprecated: false;
      description: 'Returns the [global settings](https://confluence.atlassian.com/x/qYXKM) in Jira. These settings determine whether optional features (for example, subtasks, time tracking, and others) are enabled. If time tracking is enabled, this operation also returns the time tracking configuration.\n\n**[Permissions](#permissions) required:** Permission to access Jira.';
      operationId: 'getConfiguration';
      parameters: [];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"attachmentsEnabled":true,"issueLinkingEnabled":true,"subTasksEnabled":false,"timeTrackingConfiguration":{"defaultUnit":"day","timeFormat":"pretty","workingDaysPerWeek":5.0,"workingHoursPerDay":8.0},"timeTrackingEnabled":true,"unassignedIssuesAllowed":false,"votingEnabled":true,"watchingEnabled":true}';
              schema: {
                $ref: '#/components/schemas/Configuration';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-user'];
        },
      ];
      summary: 'Get global settings';
      tags: ['Jira settings'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-user'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:instance-configuration:jira', 'read:issue.time-tracking:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/configuration/timetracking': {
    get: {
      deprecated: false;
      description: 'Returns the time tracking provider that is currently selected. Note that if time tracking is disabled, then a successful but empty response is returned.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getSelectedTimeTrackingImplementation';
      parameters: [];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"key":"Jira","name":"JIRA provided time tracking","url":"/example/config/url"}';
              schema: {
                $ref: '#/components/schemas/TimeTrackingProvider';
              };
            };
          };
          description: 'Returned if the request is successful and time tracking is enabled.';
        };
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful but time tracking is disabled.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get selected time tracking provider';
      tags: ['Time tracking'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue.time-tracking:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Selects a time tracking provider.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'selectTimeTrackingImplementation';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              key: 'Jira';
            };
            schema: {
              $ref: '#/components/schemas/TimeTrackingProvider';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the time tracking provider is not found.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Select time tracking provider';
      tags: ['Time tracking'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue.time-tracking:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/configuration/timetracking/list': {
    get: {
      deprecated: false;
      description: 'Returns all time tracking providers. By default, Jira only has one time tracking provider: *JIRA provided time tracking*. However, you can install other time tracking providers via apps from the Atlassian Marketplace. For more information on time tracking providers, see the documentation for the [ Time Tracking Provider](https://developer.atlassian.com/cloud/jira/platform/modules/time-tracking-provider/) module.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getAvailableTimeTrackingImplementations';
      parameters: [];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '[{"key":"Jira","name":"JIRA provided time tracking","url":"/example/config/url"}]';
              schema: {
                items: {
                  $ref: '#/components/schemas/TimeTrackingProvider';
                };
                type: 'array';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get all time tracking providers';
      tags: ['Time tracking'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue.time-tracking:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/configuration/timetracking/options': {
    get: {
      deprecated: false;
      description: 'Returns the time tracking settings. This includes settings such as the time format, default time unit, and others. For more information, see [Configuring time tracking](https://confluence.atlassian.com/x/qoXKM).\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getSharedTimeTrackingConfiguration';
      parameters: [];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"defaultUnit":"hour","timeFormat":"pretty","workingDaysPerWeek":5.5,"workingHoursPerDay":7.6}';
              schema: {
                $ref: '#/components/schemas/TimeTrackingConfiguration';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get time tracking settings';
      tags: ['Time tracking'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue.time-tracking:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Sets the time tracking settings.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'setSharedTimeTrackingConfiguration';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              defaultUnit: 'hour';
              timeFormat: 'pretty';
              workingDaysPerWeek: 5.5;
              workingHoursPerDay: 7.6;
            };
            schema: {
              $ref: '#/components/schemas/TimeTrackingConfiguration';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"defaultUnit":"hour","timeFormat":"pretty","workingDaysPerWeek":5.5,"workingHoursPerDay":7.6}';
              schema: {
                $ref: '#/components/schemas/TimeTrackingConfiguration';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request object is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Set time tracking settings';
      tags: ['Time tracking'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue.time-tracking:jira', 'read:issue.time-tracking:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/customFieldOption/{id}': {
    get: {
      deprecated: false;
      description: 'Returns a custom field option. For example, an option in a select list.\n\nNote that this operation **only works for issue field select list options created in Jira or using operations from the [Issue custom field options](#api-group-Issue-custom-field-options) resource**, it cannot be used with issue field select list options created by Connect apps.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** The custom field option is returned as follows:\n\n *  if the user has the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).\n *  if the user has the *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for at least one project the custom field is used in, and the field is visible in at least one layout the user has permission to view.';
      operationId: 'getCustomFieldOption';
      parameters: [
        {
          description: 'The ID of the custom field option.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"self":"https://your-domain.atlassian.net/rest/api/3/customFieldOption/10000","value":"To Do"}';
              schema: {
                $ref: '#/components/schemas/CustomFieldOption';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if:\n\n *  the custom field option is not found.\n *  the user does not have permission to view the custom field.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get custom field option';
      tags: ['Issue custom field options'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field:jira', 'read:field.option:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/dashboard': {
    get: {
      deprecated: false;
      description: 'Returns a list of dashboards owned by or shared with the user. The list may be filtered to include only favorite or owned dashboards.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** None.';
      operationId: 'getAllDashboards';
      parameters: [
        {
          description: 'The filter applied to the list of dashboards. Valid values are:\n\n *  `favourite` Returns dashboards the user has marked as favorite.\n *  `my` Returns dashboards owned by the user.';
          in: 'query';
          name: 'filter';
          schema: {
            enum: ['my', 'favourite'];
            type: 'string';
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 20;
            format: 'int32';
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"dashboards":[{"id":"10000","isFavourite":false,"name":"System Dashboard","popularity":1,"self":"https://your-domain.atlassian.net/rest/api/3/dashboard/10000","sharePermissions":[{"type":"global"}],"view":"https://your-domain.atlassian.net/secure/Dashboard.jspa?selectPageId=10000"},{"id":"20000","isFavourite":true,"name":"Build Engineering","owner":{"key":"Mia","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g","name":"mia","displayName":"Mia Krystof","avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"}},"popularity":1,"self":"https://your-domain.atlassian.net/rest/api/3/dashboard/20000","sharePermissions":[{"group":{"name":"administrators","self":"https://your-domain.atlassian.net/rest/api/3/group?groupname=administrators"},"id":10105,"type":"group"}],"view":"https://your-domain.atlassian.net/secure/Dashboard.jspa?selectPageId=20000"}],"maxResults":10,"next":"https://your-domain.atlassian.net/rest/api/3/dashboard?startAt=10","prev":"https://your-domain.atlassian.net/rest/api/3/dashboard?startAt=0","startAt":10,"total":143}';
              schema: {
                $ref: '#/components/schemas/PageOfDashboards';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get all dashboards';
      tags: ['Dashboards'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:dashboard:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:issue-type-hierarchy:jira',
            'read:issue-type:jira',
            'read:project-category:jira',
            'read:project-version:jira',
            'read:project.component:jira',
          ];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Creates a dashboard.\n\n**[Permissions](#permissions) required:** None.';
      operationId: 'createDashboard';
      parameters: [
        {
          description: 'Whether admin level permissions are used. It should only be true if the user has *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg)';
          in: 'query';
          name: 'extendAdminPermissions';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              description: 'A dashboard to help auditors identify sample of issues to check.';
              editPermissions: [];
              name: 'Auditors dashboard';
              sharePermissions: [
                {
                  type: 'global';
                },
              ];
            };
            schema: {
              $ref: '#/components/schemas/DashboardDetails';
            };
          };
        };
        description: 'Dashboard details.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"id":"10000","isFavourite":false,"name":"System Dashboard","popularity":1,"self":"https://your-domain.atlassian.net/rest/api/3/dashboard/10000","sharePermissions":[{"type":"global"}],"view":"https://your-domain.atlassian.net/secure/Dashboard.jspa?selectPageId=10000"}';
              schema: {
                $ref: '#/components/schemas/Dashboard';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Create dashboard';
      tags: ['Dashboards'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:dashboard:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'write:dashboard:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:issue-type-hierarchy:jira',
            'read:issue-type:jira',
            'read:project-category:jira',
            'read:project-version:jira',
            'read:project.component:jira',
          ];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/dashboard/bulk/edit': {
    put: {
      deprecated: false;
      description: 'Bulk edit dashboards. Maximum number of dashboards to be edited at the same time is 100.\n\n**[Permissions](#permissions) required:** None\n\nThe dashboards to be updated must be owned by the user, or the user must be an administrator.';
      operationId: 'bulkEditDashboards';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              action: 'changePermission';
              entityIds: [10001, 10002];
              extendAdminPermissions: true;
              permissionDetails: {
                editPermissions: [
                  {
                    group: {
                      groupId: '276f955c-63d7-42c8-9520-92d01dca0625';
                      name: 'jira-administrators';
                      self: 'https://your-domain.atlassian.net/rest/api/~ver~/group?groupId=276f955c-63d7-42c8-9520-92d01dca0625';
                    };
                    id: 10010;
                    type: 'group';
                  },
                ];
                sharePermissions: [
                  {
                    id: 10000;
                    type: 'global';
                  },
                ];
              };
            };
            schema: {
              $ref: '#/components/schemas/BulkEditShareableEntityRequest';
            };
          };
        };
        description: 'The details of dashboards being updated in bulk.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"action":"changePermission","entityErrors":{"10002":{"errorMessages":["Only owner or editors of the dashboard can change permissions."],"errors":{}}}}';
              schema: {
                $ref: '#/components/schemas/BulkEditShareableEntityResponse';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
      ];
      summary: 'Bulk edit dashboards';
      tags: ['Dashboards'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:dashboard:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'write:dashboard:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:issue-type-hierarchy:jira',
            'read:issue-type:jira',
            'read:project-category:jira',
            'read:project-version:jira',
            'read:project.component:jira',
          ];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/dashboard/gadgets': {
    get: {
      deprecated: false;
      description: 'Gets a list of all available gadgets that can be added to all dashboards.\n\n**[Permissions](#permissions) required:** None.';
      operationId: 'getAllAvailableDashboardGadgets';
      parameters: [];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"gadgets":[{"moduleKey":"com.atlassian.plugins.atlassian-connect-plugin:com.atlassian.connect.node.sample-addon__sample-dashboard-item","title":"Issue statistics"},{"uri":"rest/gadgets/1.0/g/com.atlassian.streams.streams-jira-plugin:activitystream-gadget/gadgets/activitystream-gadget.xml","title":"Activity Stream"}]}';
              schema: {
                $ref: '#/components/schemas/AvailableDashboardGadgetsResponse';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: '400 response';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
      ];
      summary: 'Get available gadgets';
      tags: ['Dashboards'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:dashboard:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/dashboard/search': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of dashboards. This operation is similar to [Get dashboards](#api-rest-api-3-dashboard-get) except that the results can be refined to include dashboards that have specific attributes. For example, dashboards with a particular name. When multiple attributes are specified only filters matching all attributes are returned.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** The following dashboards that match the query parameters are returned:\n\n *  Dashboards owned by the user. Not returned for anonymous users.\n *  Dashboards shared with a group that the user is a member of. Not returned for anonymous users.\n *  Dashboards shared with a private project that the user can browse. Not returned for anonymous users.\n *  Dashboards shared with a public project.\n *  Dashboards shared with the public.';
      operationId: 'getDashboardsPaginated';
      parameters: [
        {
          description: 'String used to perform a case-insensitive partial match with `name`.';
          in: 'query';
          name: 'dashboardName';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'User account ID used to return dashboards with the matching `owner.accountId`. This parameter cannot be used with the `owner` parameter.';
          in: 'query';
          name: 'accountId';
          schema: {
            maxLength: 128;
            type: 'string';
          };
        },
        {
          description: 'This parameter is deprecated because of privacy changes. Use `accountId` instead. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details. User name used to return dashboards with the matching `owner.name`. This parameter cannot be used with the `accountId` parameter.';
          in: 'query';
          name: 'owner';
          schema: {
            type: 'string';
          };
        },
        {
          description: "As a group's name can change, use of `groupId` is recommended. Group name used to return dashboards that are shared with a group that matches `sharePermissions.group.name`. This parameter cannot be used with the `groupId` parameter.";
          in: 'query';
          name: 'groupname';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Group ID used to return dashboards that are shared with a group that matches `sharePermissions.group.groupId`. This parameter cannot be used with the `groupname` parameter.';
          in: 'query';
          name: 'groupId';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Project ID used to returns dashboards that are shared with a project that matches `sharePermissions.project.id`.';
          in: 'query';
          name: 'projectId';
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: '[Order](#ordering) the results by a field:\n\n *  `description` Sorts by dashboard description. Note that this sort works independently of whether the expand to display the description field is in use.\n *  `favourite_count` Sorts by dashboard popularity.\n *  `id` Sorts by dashboard ID.\n *  `is_favourite` Sorts by whether the dashboard is marked as a favorite.\n *  `name` Sorts by dashboard name.\n *  `owner` Sorts by dashboard owner name.';
          in: 'query';
          name: 'orderBy';
          schema: {
            default: 'name';
            enum: [
              'description',
              '-description',
              '+description',
              'favorite_count',
              '-favorite_count',
              '+favorite_count',
              'id',
              '-id',
              '+id',
              'is_favorite',
              '-is_favorite',
              '+is_favorite',
              'name',
              '-name',
              '+name',
              'owner',
              '-owner',
              '+owner',
            ];
            type: 'string';
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The status to filter by. It may be active, archived or deleted.';
          in: 'query';
          name: 'status';
          schema: {
            default: 'active';
            enum: ['active', 'archived', 'deleted'];
            type: 'string';
          };
        },
        {
          description: 'Use [expand](#expansion) to include additional information about dashboard in the response. This parameter accepts a comma-separated list. Expand options include:\n\n *  `description` Returns the description of the dashboard.\n *  `owner` Returns the owner of the dashboard.\n *  `viewUrl` Returns the URL that is used to view the dashboard.\n *  `favourite` Returns `isFavourite`, an indicator of whether the user has set the dashboard as a favorite.\n *  `favouritedCount` Returns `popularity`, a count of how many users have set this dashboard as a favorite.\n *  `sharePermissions` Returns details of the share permissions defined for the dashboard.\n *  `editPermissions` Returns details of the edit permissions defined for the dashboard.\n *  `isWritable` Returns whether the current user has permission to edit the dashboard.';
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":100,"self":"https://your-domain.atlassian.net/rest/api/3/dashboard/search?expand=owner&maxResults=50&startAt=0","startAt":0,"total":2,"values":[{"description":"Testing program","id":"1","isFavourite":true,"name":"Testing","owner":{"self":"https://your-domain.atlassian.net/user?accountId=5b10a2844c20165700ede21g","displayName":"Mia","active":true,"accountId":"5b10a2844c20165700ede21g","avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"}},"popularity":1,"self":"https://your-domain.atlassian.net/rest/api/3/dashboard/1","sharePermissions":[{"type":"global"}],"view":"https://your-domain.atlassian.net/Dashboard.jspa?selectPageId=1"},{"description":"Quantum initiative","id":"2","isFavourite":false,"name":"Quantum ","owner":{"self":"https://your-domain.atlassian.net/user?accountId=5b10a2844c20165700ede21g","displayName":"Mia","active":true,"accountId":"5b10a2844c20165700ede21g","avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"}},"popularity":0,"self":"https://your-domain.atlassian.net/rest/api/3/dashboard/2","sharePermissions":[{"type":"loggedin"}],"view":"https://your-domain.atlassian.net/Dashboard.jspa?selectPageId=2"}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanDashboard';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if:\n\n *  `orderBy` is invalid.\n *  `expand` includes an invalid value.\n *  `accountId` and `owner` are provided.\n *  `groupname` and `groupId` are provided.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: '401 response';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Search for dashboards';
      tags: ['Dashboards'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:dashboard:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:issue-type-hierarchy:jira',
            'read:issue-type:jira',
            'read:project-category:jira',
            'read:project-version:jira',
            'read:project.component:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/dashboard/{dashboardId}/gadget': {
    get: {
      deprecated: false;
      description: 'Returns a list of dashboard gadgets on a dashboard.\n\nThis operation returns:\n\n *  Gadgets from a list of IDs, when `id` is set.\n *  Gadgets with a module key, when `moduleKey` is set.\n *  Gadgets from a list of URIs, when `uri` is set.\n *  All gadgets, when no other parameters are set.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** None.';
      operationId: 'getAllGadgets';
      parameters: [
        {
          description: 'The ID of the dashboard.';
          in: 'path';
          name: 'dashboardId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The list of gadgets module keys. To include multiple module keys, separate module keys with ampersand: `moduleKey=key:one&moduleKey=key:two`.';
          in: 'query';
          name: 'moduleKey';
          schema: {
            items: {
              default: '';
              type: 'string';
            };
            type: 'array';
          };
        },
        {
          description: 'The list of gadgets URIs. To include multiple URIs, separate URIs with ampersand: `uri=/rest/example/uri/1&uri=/rest/example/uri/2`.';
          in: 'query';
          name: 'uri';
          schema: {
            items: {
              default: '';
              type: 'string';
            };
            type: 'array';
          };
        },
        {
          description: 'The list of gadgets IDs. To include multiple IDs, separate IDs with ampersand: `gadgetId=10000&gadgetId=10001`.';
          in: 'query';
          name: 'gadgetId';
          schema: {
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"gadgets":[{"id":10001,"moduleKey":"com.atlassian.plugins.atlassian-connect-plugin:com.atlassian.connect.node.sample-addon__sample-dashboard-item","color":"blue","position":{"row":0,"column":0},"title":"Issue statistics"},{"id":10002,"moduleKey":"com.atlassian.plugins.atlassian-connect-plugin:com.atlassian.connect.node.sample-addon__sample-dashboard-graph","color":"red","position":{"row":1,"column":0},"title":"Activity stream"},{"id":10003,"moduleKey":"com.atlassian.plugins.atlassian-connect-plugin:com.atlassian.connect.node.sample-addon__sample-dashboard-item","color":"yellow","position":{"row":0,"column":1},"title":"Bubble chart"}]}';
              schema: {
                $ref: '#/components/schemas/DashboardGadgetResponse';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The dashboard you requested either does not exist or you don\'t have the required permissions to perform this action."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the dashboard is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get gadgets';
      tags: ['Dashboards'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:dashboard:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
    post: {
      deprecated: false;
      description: 'Adds a gadget to a dashboard.\n\n**[Permissions](#permissions) required:** None.';
      operationId: 'addGadget';
      parameters: [
        {
          description: 'The ID of the dashboard.';
          in: 'path';
          name: 'dashboardId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              color: 'blue';
              ignoreUriAndModuleKeyValidation: false;
              moduleKey: 'com.atlassian.plugins.atlassian-connect-plugin:com.atlassian.connect.node.sample-addon__sample-dashboard-item';
              position: {
                column: 1;
                row: 0;
              };
              title: 'Issue statistics';
            };
            schema: {
              $ref: '#/components/schemas/DashboardGadgetSettings';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"color":"blue","id":10001,"moduleKey":"com.atlassian.plugins.atlassian-connect-plugin:com.atlassian.connect.node.sample-addon__sample-dashboard-item","position":{"column":1,"row":0},"title":"Issue statistics"}';
              schema: {
                $ref: '#/components/schemas/DashboardGadget';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Cannot add another gadget. The maximum number of gadgets the dashboard can hold has been reached."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The dashboard you requested either does not exist or you don\'t have the required permissions to perform this action."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the dashboard is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work', 'read:jira-work'];
        },
      ];
      summary: 'Add gadget to dashboard';
      tags: ['Dashboards'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work', 'read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:dashboard:jira', 'read:dashboard:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/dashboard/{dashboardId}/gadget/{gadgetId}': {
    delete: {
      deprecated: false;
      description: 'Removes a dashboard gadget from a dashboard.\n\nWhen a gadget is removed from a dashboard, other gadgets in the same column are moved up to fill the emptied position.\n\n**[Permissions](#permissions) required:** None.';
      operationId: 'removeGadget';
      parameters: [
        {
          description: 'The ID of the dashboard.';
          in: 'path';
          name: 'dashboardId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The ID of the gadget.';
          in: 'path';
          name: 'gadgetId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The dashboard gadget was not found."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the gadget or the dashboard is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
      ];
      summary: 'Remove gadget from dashboard';
      tags: ['Dashboards'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:dashboard:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
    put: {
      deprecated: false;
      description: 'Changes the title, position, and color of the gadget on a dashboard.\n\n**[Permissions](#permissions) required:** None.';
      operationId: 'updateGadget';
      parameters: [
        {
          description: 'The ID of the dashboard.';
          in: 'path';
          name: 'dashboardId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The ID of the gadget.';
          in: 'path';
          name: 'gadgetId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              color: 'red';
              position: {
                column: 1;
                row: 1;
              };
              title: 'My new gadget title';
            };
            schema: {
              $ref: '#/components/schemas/DashboardGadgetUpdateRequest';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The gadget cannot be placed in the selected row. The selected row does not exist on the dashboard."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The dashboard you requested either does not exist or you don\'t have the required permissions to perform this action."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the gadget or the dashboard is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
      ];
      summary: 'Update gadget on dashboard';
      tags: ['Dashboards'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:dashboard:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/dashboard/{dashboardId}/items/{itemId}/properties': {
    get: {
      deprecated: false;
      description: 'Returns the keys of all properties for a dashboard item.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** The user must be the owner of the dashboard or have the dashboard shared with them. Note, users with the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) are considered owners of the System dashboard. The System dashboard is considered to be shared with all other users, and is accessible to anonymous users when Jira\\\\u2019s anonymous access is permitted.';
      operationId: 'getDashboardItemPropertyKeys';
      parameters: [
        {
          description: 'The ID of the dashboard.';
          in: 'path';
          name: 'dashboardId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the dashboard item.';
          in: 'path';
          name: 'itemId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"keys":[{"key":"issue.support","self":"https://your-domain.atlassian.net/rest/api/3/issue/EX-2/properties/issue.support"}]}';
              schema: {
                $ref: '#/components/schemas/PropertyKeys';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the dashboard or dashboard item is not found, or the dashboard is not owned by or shared with the user.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get dashboard item property keys';
      tags: ['Dashboards'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:dashboard.property:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/dashboard/{dashboardId}/items/{itemId}/properties/{propertyKey}': {
    delete: {
      deprecated: false;
      description: 'Deletes a dashboard item property.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** The user must be the owner of the dashboard. Note, users with the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) are considered owners of the System dashboard.';
      operationId: 'deleteDashboardItemProperty';
      parameters: [
        {
          description: 'The ID of the dashboard.';
          in: 'path';
          name: 'dashboardId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the dashboard item.';
          in: 'path';
          name: 'itemId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The key of the dashboard item property.';
          in: 'path';
          name: 'propertyKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the dashboard item property is deleted.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the dashboard or dashboard item ID is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the user is not the owner of the dashboard.';
        };
        '404': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the dashboard item is not found or the dashboard is not shared with the user.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Delete dashboard item property';
      tags: ['Dashboards'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:dashboard.property:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: "Returns the key and value of a dashboard item property.\n\nA dashboard item enables an app to add user-specific information to a user dashboard. Dashboard items are exposed to users as gadgets that users can add to their dashboards. For more information on how users do this, see [Adding and customizing gadgets](https://confluence.atlassian.com/x/7AeiLQ).\n\nWhen an app creates a dashboard item it registers a callback to receive the dashboard item ID. The callback fires whenever the item is rendered or, where the item is configurable, the user edits the item. The app then uses this resource to store the item's content or configuration details. For more information on working with dashboard items, see [ Building a dashboard item for a JIRA Connect add-on](https://developer.atlassian.com/server/jira/platform/guide-building-a-dashboard-item-for-a-jira-connect-add-on-33746254/) and the [Dashboard Item](https://developer.atlassian.com/cloud/jira/platform/modules/dashboard-item/) documentation.\n\nThere is no resource to set or get dashboard items.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** The user must be the owner of the dashboard or have the dashboard shared with them. Note, users with the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) are considered owners of the System dashboard. The System dashboard is considered to be shared with all other users, and is accessible to anonymous users when Jira\\\\u2019s anonymous access is permitted.";
      operationId: 'getDashboardItemProperty';
      parameters: [
        {
          description: 'The ID of the dashboard.';
          in: 'path';
          name: 'dashboardId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the dashboard item.';
          in: 'path';
          name: 'itemId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The key of the dashboard item property.';
          in: 'path';
          name: 'propertyKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"key":"issue.support","value":{"system.conversation.id":"b1bf38be-5e94-4b40-a3b8-9278735ee1e6","system.support.time":"1m"}}';
              schema: {
                $ref: '#/components/schemas/EntityProperty';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the dashboard, the dashboard item, or dashboard item property is not found, or the dashboard is not owned by or shared with the user.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get dashboard item property';
      tags: ['Dashboards'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:dashboard.property:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: "Sets the value of a dashboard item property. Use this resource in apps to store custom data against a dashboard item.\n\nA dashboard item enables an app to add user-specific information to a user dashboard. Dashboard items are exposed to users as gadgets that users can add to their dashboards. For more information on how users do this, see [Adding and customizing gadgets](https://confluence.atlassian.com/x/7AeiLQ).\n\nWhen an app creates a dashboard item it registers a callback to receive the dashboard item ID. The callback fires whenever the item is rendered or, where the item is configurable, the user edits the item. The app then uses this resource to store the item's content or configuration details. For more information on working with dashboard items, see [ Building a dashboard item for a JIRA Connect add-on](https://developer.atlassian.com/server/jira/platform/guide-building-a-dashboard-item-for-a-jira-connect-add-on-33746254/) and the [Dashboard Item](https://developer.atlassian.com/cloud/jira/platform/modules/dashboard-item/) documentation.\n\nThere is no resource to set or get dashboard items.\n\nThe value of the request body must be a [valid](http://tools.ietf.org/html/rfc4627), non-empty JSON blob. The maximum length is 32768 characters.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** The user must be the owner of the dashboard. Note, users with the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) are considered owners of the System dashboard.";
      operationId: 'setDashboardItemProperty';
      parameters: [
        {
          description: 'The ID of the dashboard.';
          in: 'path';
          name: 'dashboardId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the dashboard item.';
          in: 'path';
          name: 'itemId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The key of the dashboard item property. The maximum length is 255 characters. For dashboard items with a spec URI and no complete module key, if the provided propertyKey is equal to "config", the request body\'s JSON must be an object with all keys and values as strings.';
          in: 'path';
          name: 'propertyKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              number: 5;
              string: 'string-value';
            };
            schema: {};
          };
        };
        description: 'The value of the property. The value has to be a valid, non-empty [JSON](https://tools.ietf.org/html/rfc4627) value. The maximum length of the property value is 32768 bytes.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the dashboard item property is updated.';
        };
        '201': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the dashboard item property is created.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The JSON data provided for the property has too many levels. It must be an object with all keys and values as strings."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if:\n\n *  Request is invalid\n *  Or if all of these conditions are met in the request:\n    \n     *  The dashboard item has a spec URI and no complete module key\n     *  The value of propertyKey is equal to "config"\n     *  The request body contains a JSON object whose keys and values are not strings.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the user is not the owner of the dashboard.';
        };
        '404': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the dashboard item is not found or the dashboard is not shared with the user.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Set dashboard item property';
      tags: ['Dashboards'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:dashboard.property:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/dashboard/{id}': {
    delete: {
      deprecated: false;
      description: 'Deletes a dashboard.\n\n**[Permissions](#permissions) required:** None\n\nThe dashboard to be deleted must be owned by the user.';
      operationId: 'deleteDashboard';
      parameters: [
        {
          description: 'The ID of the dashboard.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the dashboard is deleted.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: '400 response';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Delete dashboard';
      tags: ['Dashboards'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:dashboard:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
    get: {
      deprecated: false;
      description: 'Returns a dashboard.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** None.\n\nHowever, to get a dashboard, the dashboard must be shared with the user or the user must own it. Note, users with the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) are considered owners of the System dashboard. The System dashboard is considered to be shared with all other users.';
      operationId: 'getDashboard';
      parameters: [
        {
          description: 'The ID of the dashboard.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"id":"10000","isFavourite":false,"name":"System Dashboard","popularity":1,"self":"https://your-domain.atlassian.net/rest/api/3/dashboard/10000","sharePermissions":[{"type":"global"}],"view":"https://your-domain.atlassian.net/secure/Dashboard.jspa?selectPageId=10000"}';
              schema: {
                $ref: '#/components/schemas/Dashboard';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: '400 response';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if the dashboard is not found or the dashboard is not owned by or shared with the user.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get dashboard';
      tags: ['Dashboards'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:dashboard:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:issue-type-hierarchy:jira',
            'read:issue-type:jira',
            'read:project-category:jira',
            'read:project-version:jira',
            'read:project.component:jira',
          ];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Updates a dashboard, replacing all the dashboard details with those provided.\n\n**[Permissions](#permissions) required:** None\n\nThe dashboard to be updated must be owned by the user.';
      operationId: 'updateDashboard';
      parameters: [
        {
          description: 'The ID of the dashboard to update.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Whether admin level permissions are used. It should only be true if the user has *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg)';
          in: 'query';
          name: 'extendAdminPermissions';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              description: 'A dashboard to help auditors identify sample of issues to check.';
              editPermissions: [];
              name: 'Auditors dashboard';
              sharePermissions: [
                {
                  type: 'global';
                },
              ];
            };
            schema: {
              $ref: '#/components/schemas/DashboardDetails';
            };
          };
        };
        description: 'Replacement dashboard details.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"id":"10000","isFavourite":false,"name":"System Dashboard","popularity":1,"self":"https://your-domain.atlassian.net/rest/api/3/dashboard/10000","sharePermissions":[{"type":"global"}],"view":"https://your-domain.atlassian.net/secure/Dashboard.jspa?selectPageId=10000"}';
              schema: {
                $ref: '#/components/schemas/Dashboard';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the dashboard is not found or the dashboard is not owned by the user.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Update dashboard';
      tags: ['Dashboards'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:dashboard:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'write:dashboard:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:issue-type-hierarchy:jira',
            'read:issue-type:jira',
            'read:project-category:jira',
            'read:project-version:jira',
            'read:project.component:jira',
          ];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/dashboard/{id}/copy': {
    post: {
      deprecated: false;
      description: 'Copies a dashboard. Any values provided in the `dashboard` parameter replace those in the copied dashboard.\n\n**[Permissions](#permissions) required:** None\n\nThe dashboard to be copied must be owned by or shared with the user.';
      operationId: 'copyDashboard';
      parameters: [
        {
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Whether admin level permissions are used. It should only be true if the user has *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg)';
          in: 'query';
          name: 'extendAdminPermissions';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              description: 'A dashboard to help auditors identify sample of issues to check.';
              editPermissions: [];
              name: 'Auditors dashboard';
              sharePermissions: [
                {
                  type: 'global';
                },
              ];
            };
            schema: {
              $ref: '#/components/schemas/DashboardDetails';
            };
          };
        };
        description: 'Dashboard details.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"id":"10000","isFavourite":false,"name":"System Dashboard","popularity":1,"self":"https://your-domain.atlassian.net/rest/api/3/dashboard/10000","sharePermissions":[{"type":"global"}],"view":"https://your-domain.atlassian.net/secure/Dashboard.jspa?selectPageId=10000"}';
              schema: {
                $ref: '#/components/schemas/Dashboard';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the dashboard is not found or the dashboard is not owned by or shared with the user.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Copy dashboard';
      tags: ['Dashboards'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:dashboard:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'write:dashboard:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:issue-type-hierarchy:jira',
            'read:issue-type:jira',
            'read:project-category:jira',
            'read:project-version:jira',
            'read:project.component:jira',
          ];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/data-policy': {
    get: {
      deprecated: false;
      description: 'Returns data policy for the workspace.';
      operationId: 'getPolicy';
      parameters: [];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"anyContentBlocked":false}';
              schema: {
                $ref: '#/components/schemas/WorkspaceDataPolicy';
              };
            };
          };
          description: 'Returned if the request is successful';
        };
        '401': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only apps can access this resource."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":[""],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the client is not authorized to make the request.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
      ];
      summary: 'Get data policy for the workspace';
      tags: ['App data policies'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
    };
  };
  '/rest/api/3/data-policy/project': {
    get: {
      deprecated: false;
      description: 'Returns data policies for the projects specified in the request.';
      operationId: 'getPolicies';
      parameters: [
        {
          description: 'A list of project identifiers. This parameter accepts a comma-separated list.';
          in: 'query';
          name: 'ids';
          schema: {
            description: 'A list of up to 50 project identifiers. This parameter accepts a comma-separated list.';
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"projectDataPolicies":[{"dataPolicy":{"anyContentBlocked":false},"id":1000},{"dataPolicy":{"anyContentBlocked":true},"id":1001}]}';
              schema: {
                $ref: '#/components/schemas/ProjectDataPolicies';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Invalid request: some projects are not available or do not exist."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is not valid or includes invalid or not-permitted project identifiers.';
        };
        '401': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only apps can access this resource."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":[""],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the client is not authorized to make the request.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
      ];
      summary: 'Get data policy for projects';
      tags: ['App data policies'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
    };
  };
  '/rest/api/3/events': {
    get: {
      deprecated: false;
      description: 'Returns all issue events.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getEvents';
      parameters: [];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '[{"id":1,"name":"Issue Created"},{"id":2,"name":"Issue Updated"}]';
              schema: {
                items: {
                  $ref: '#/components/schemas/IssueEvent';
                };
                type: 'array';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have permission to complete this request.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get events';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-event:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/expression/analyse': {
    post: {
      deprecated: false;
      description: 'Analyses and validates Jira expressions.\n\nAs an experimental feature, this operation can also attempt to type-check the expressions.\n\nLearn more about Jira expressions in the [documentation](https://developer.atlassian.com/cloud/jira/platform/jira-expressions/).\n\n**[Permissions](#permissions) required**: None.';
      operationId: 'analyseExpression';
      parameters: [
        {
          description: "The check to perform:\n\n *  `syntax` Each expression's syntax is checked to ensure the expression can be parsed. Also, syntactic limits are validated. For example, the expression's length.\n *  `type` EXPERIMENTAL. Each expression is type checked and the final type of the expression inferred. Any type errors that would result in the expression failure at runtime are reported. For example, accessing properties that don't exist or passing the wrong number of arguments to functions. Also performs the syntax check.\n *  `complexity` EXPERIMENTAL. Determines the formulae for how many [expensive operations](https://developer.atlassian.com/cloud/jira/platform/jira-expressions/#expensive-operations) each expression may execute.";
          in: 'query';
          name: 'check';
          schema: {
            default: 'syntax';
            enum: ['syntax', 'type', 'complexity'];
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              contextVariables: {
                listOfStrings: 'List<String>';
                record: '{ a: Number, b: String }';
                value: 'User';
              };
              expressions: ["issues.map(issue => issue.properties['property_key'])"];
            };
            schema: {
              $ref: '#/components/schemas/JiraExpressionForAnalysis';
            };
          };
        };
        description: 'The Jira expressions to analyse.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"results":[{"expression":"analysed expression","errors":[{"line":1,"column":4,"message":"!, -, typeof, (, IDENTIFIER, null, true, false, NUMBER, STRING, TEMPLATE_LITERAL, new, [ or { expected, > encountered.","type":"syntax"},{"message":"Jira expression is too long (1040), limit: 1000 characters","type":"other"},{"message":"Jira expression has too many nodes (150), limit: 100 leaves","type":"other"}],"valid":false},{"expression":"issues.map(i => {idAndKey: [i.id, i.key], summary: i.summary, comments: i.comments})","valid":true,"type":"List<{idAndKey: [Number, String], summary: String, comments: List<Comment>}>","complexity":{"expensiveOperations":"N","variables":{"N":"issues"}}},{"expression":"issues.map(i => i.id > \'0\')","errors":[{"expression":"i.id > 0","message":"Can\'t compare Number to String.","type":"type"}],"valid":false,"type":"TypeError"}]}';
              schema: {
                $ref: '#/components/schemas/JiraExpressionsAnalysis';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: '400 response';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: '404 response';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work', 'read:jira-user'];
        },
        {},
      ];
      summary: 'Analyse Jira expression';
      tags: ['Jira expressions'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work', 'read:jira-user'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field:jira', 'read:jira-expressions:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/expression/eval': {
    post: {
      deprecated: false;
      description: 'Evaluates a Jira expression and returns its value.\n\nThis resource can be used to test Jira expressions that you plan to use elsewhere, or to fetch data in a flexible way. Consult the [Jira expressions documentation](https://developer.atlassian.com/cloud/jira/platform/jira-expressions/) for more details.\n\n#### Context variables ####\n\nThe following context variables are available to Jira expressions evaluated by this resource. Their presence depends on various factors; usually you need to manually request them in the context object sent in the payload, but some of them are added automatically under certain conditions.\n\n *  `user` ([User](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#user)): The current user. Always available and equal to `null` if the request is anonymous.\n *  `app` ([App](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#app)): The [Connect app](https://developer.atlassian.com/cloud/jira/platform/index/#connect-apps) that made the request. Available only for authenticated requests made by Connect Apps (read more here: [Authentication for Connect apps](https://developer.atlassian.com/cloud/jira/platform/security-for-connect-apps/)).\n *  `issue` ([Issue](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#issue)): The current issue. Available only when the issue is provided in the request context object.\n *  `issues` ([List](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#list) of [Issues](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#issue)): A collection of issues matching a JQL query. Available only when JQL is provided in the request context object.\n *  `project` ([Project](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#project)): The current project. Available only when the project is provided in the request context object.\n *  `sprint` ([Sprint](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#sprint)): The current sprint. Available only when the sprint is provided in the request context object.\n *  `board` ([Board](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#board)): The current board. Available only when the board is provided in the request context object.\n *  `serviceDesk` ([ServiceDesk](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#servicedesk)): The current service desk. Available only when the service desk is provided in the request context object.\n *  `customerRequest` ([CustomerRequest](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#customerrequest)): The current customer request. Available only when the customer request is provided in the request context object.\n\nAlso, custom context variables can be passed in the request with their types. Those variables can be accessed by key in the Jira expression. These variable types are available for use in a custom context:\n\n *  `user`: A [user](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#user) specified as an Atlassian account ID.\n *  `issue`: An [issue](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#issue) specified by ID or key. All the fields of the issue object are available in the Jira expression.\n *  `json`: A JSON object containing custom content.\n *  `list`: A JSON list of `user`, `issue`, or `json` variable types.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required**: None. However, an expression may return different results for different users depending on their permissions. For example, different users may see different comments on the same issue.  \nPermission to access Jira Software is required to access Jira Software context variables (`board` and `sprint`) or fields (for example, `issue.sprint`).';
      operationId: 'evaluateJiraExpression';
      parameters: [
        {
          description: 'Use [expand](#expansion) to include additional information in the response. This parameter accepts `meta.complexity` that returns information about the expression complexity. For example, the number of expensive operations used by the expression and how close the expression is to reaching the [complexity limit](https://developer.atlassian.com/cloud/jira/platform/jira-expressions/#restrictions). Useful when designing and debugging your expressions.';
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              context: {
                board: 10100;
                custom: {
                  config: {
                    type: 'json';
                    value: {
                      userId: '10002';
                    };
                  };
                  issuesList: [
                    {
                      key: 'ACJIRA-1471';
                      type: 'issue';
                    },
                    {
                      id: 100001;
                      type: 'issue';
                    },
                  ];
                  myUser: {
                    accountId: '100001';
                    type: 'user';
                  };
                  nullField: {
                    type: 'json';
                  };
                };
                customerRequest: 1450;
                issue: {
                  key: 'ACJIRA-1470';
                };
                issues: {
                  jql: {
                    maxResults: 100;
                    query: 'project = HSP';
                    startAt: 0;
                    validation: 'strict';
                  };
                };
                project: {
                  key: 'ACJIRA';
                };
                serviceDesk: 10023;
                sprint: 10001;
              };
              expression: '{ key: issue.key, type: issue.issueType.name, links: issue.links.map(link => link.linkedIssue.id), listCustomVariable: issuesList.includes(issue), customVariables: myUser.accountId == config.userId}';
            };
            schema: {
              $ref: '#/components/schemas/JiraExpressionEvalRequestBean';
            };
          };
        };
        description: 'The Jira expression and the evaluation context.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"value":"The expression\'s result. This value can be any JSON, not necessarily a String","meta":{"complexity":{"steps":{"value":1,"limit":10000},"expensiveOperations":{"value":3,"limit":10},"beans":{"value":0,"limit":1000},"primitiveValues":{"value":1,"limit":10000}},"issues":{"jql":{"startAt":0,"maxResults":1000,"count":140,"totalCount":140,"validationWarnings":["There is a problem with the JQL query."]}}}}';
              schema: {
                $ref: '#/components/schemas/JiraExpressionResult';
              };
            };
          };
          description: 'Returned if the evaluation results in a value. The result is a JSON primitive value, list, or object.';
        };
        '400': {
          content: {
            'application/json': {
              example: "{\"errorMessages\":[\"Evaluation failed: \\\"issue['a' + 'b']\\\" - Unrecognized property of `issue`: \\\"ab\\\" ('a' + 'b'). Available properties of type 'Issue' are: 'assignee', 'comments', 'description', 'id', 'issueType', 'key', 'priority', 'project', 'properties', 'reporter', 'status', 'summary'\"],\"errors\":{}}";
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if:\n\n *  the request is invalid, that is:\n    \n     *  invalid data is provided, such as a request including issue ID and key.\n     *  the expression is invalid and can not be parsed.\n *  evaluation fails at runtime. This may happen for various reasons. For example, accessing a property on a null object (such as the expression `issue.id` where `issue` is `null`). In this case an error message is provided.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Issue does not exist or you do not have permission to see it."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if any object provided in the request context is not found or the user does not have permission to view it.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work', 'read:jira-user'];
        },
        {},
      ];
      summary: 'Evaluate Jira expression';
      tags: ['Jira expressions'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work', 'read:jira-user'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-expressions:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/expression/evaluate': {
    post: {
      deprecated: false;
      description: "Evaluates a Jira expression and returns its value. The difference between this and `eval` is that this endpoint uses the enhanced search API when evaluating JQL queries. This API is eventually consistent, unlike the strongly consistent `eval` API. This allows for better performance and scalability. In addition, this API's response for JQL evaluation is based on a scrolling view (backed by a `nextPageToken`) instead of a paginated view (backed by `startAt` and `totalCount`).\n\nThis resource can be used to test Jira expressions that you plan to use elsewhere, or to fetch data in a flexible way. Consult the [Jira expressions documentation](https://developer.atlassian.com/cloud/jira/platform/jira-expressions/) for more details.\n\n#### Context variables ####\n\nThe following context variables are available to Jira expressions evaluated by this resource. Their presence depends on various factors; usually you need to manually request them in the context object sent in the payload, but some of them are added automatically under certain conditions.\n\n *  `user` ([User](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#user)): The current user. Always available and equal to `null` if the request is anonymous.\n *  `app` ([App](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#app)): The [Connect app](https://developer.atlassian.com/cloud/jira/platform/index/#connect-apps) that made the request. Available only for authenticated requests made by Connect apps (read more here: [Authentication for Connect apps](https://developer.atlassian.com/cloud/jira/platform/security-for-connect-apps/)).\n *  `issue` ([Issue](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#issue)): The current issue. Available only when the issue is provided in the request context object.\n *  `issues` ([List](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#list) of [Issues](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#issue)): A collection of issues matching a JQL query. Available only when JQL is provided in the request context object.\n *  `project` ([Project](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#project)): The current project. Available only when the project is provided in the request context object.\n *  `sprint` ([Sprint](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#sprint)): The current sprint. Available only when the sprint is provided in the request context object.\n *  `board` ([Board](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#board)): The current board. Available only when the board is provided in the request context object.\n *  `serviceDesk` ([ServiceDesk](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#servicedesk)): The current service desk. Available only when the service desk is provided in the request context object.\n *  `customerRequest` ([CustomerRequest](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#customerrequest)): The current customer request. Available only when the customer request is provided in the request context object.\n\nIn addition, you can pass custom context variables along with their types. You can then access them from the Jira expression by key. You can use the following variables in a custom context:\n\n *  `user`: A [user](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#user) specified as an Atlassian account ID.\n *  `issue`: An [issue](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#issue) specified by ID or key. All the fields of the issue object are available in the Jira expression.\n *  `json`: A JSON object containing custom content.\n *  `list`: A JSON list of `user`, `issue`, or `json` variable types.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required**: None. However, an expression may return different results for different users depending on their permissions. For example, different users may see different comments on the same issue.  \nPermission to access Jira Software is required to access Jira Software context variables (`board` and `sprint`) or fields (for example, `issue.sprint`).";
      operationId: 'evaluateJSISJiraExpression';
      parameters: [
        {
          description: 'Use [expand](#expansion) to include additional information in the response. This parameter accepts `meta.complexity` that returns information about the expression complexity. For example, the number of expensive operations used by the expression and how close the expression is to reaching the [complexity limit](https://developer.atlassian.com/cloud/jira/platform/jira-expressions/#restrictions). Useful when designing and debugging your expressions.';
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              context: {
                board: 10100;
                custom: {
                  config: {
                    type: 'json';
                    value: {
                      userId: '10002';
                    };
                  };
                  issuesList: [
                    {
                      key: 'ACJIRA-1471';
                      type: 'issue';
                    },
                    {
                      id: 100001;
                      type: 'issue';
                    },
                  ];
                  myUser: {
                    accountId: '100001';
                    type: 'user';
                  };
                  nullField: {
                    type: 'json';
                  };
                };
                customerRequest: 1450;
                issue: {
                  key: 'ACJIRA-1470';
                };
                issues: {
                  jql: {
                    maxResults: 100;
                    nextPageToken: 'EgQIlMIC';
                    query: 'project = HSP';
                  };
                };
                project: {
                  key: 'ACJIRA';
                };
                serviceDesk: 10023;
                sprint: 10001;
              };
              expression: '{ key: issue.key, type: issue.issueType.name, links: issue.links.map(link => link.linkedIssue.id), listCustomVariable: issuesList.includes(issue), customVariables: myUser.accountId == config.userId}';
            };
            schema: {
              $ref: '#/components/schemas/JiraExpressionEvaluateRequestBean';
            };
          };
        };
        description: 'The Jira expression and the evaluation context.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"value":"The expression\'s result. This value can be any JSON, not necessarily a String","meta":{"complexity":{"steps":{"value":1,"limit":10000},"expensiveOperations":{"value":3,"limit":10},"beans":{"value":0,"limit":1000},"primitiveValues":{"value":1,"limit":10000}},"issues":{"jql":{"nextPageToken":"EgQIlMIC"}}}}';
              schema: {
                $ref: '#/components/schemas/JExpEvaluateJiraExpressionResultBean';
              };
            };
          };
          description: 'Returned if the evaluation results in a value. The result is a JSON primitive value, list, or object.';
        };
        '400': {
          content: {
            'application/json': {
              example: "{\"errorMessages\":[\"Evaluation failed: \\\"issue['a' + 'b']\\\" - Unrecognized property of `issue`: \\\"ab\\\" ('a' + 'b'). Available properties of type 'Issue' are: 'assignee', 'comments', 'description', 'id', 'issueType', 'key', 'priority', 'project', 'properties', 'reporter', 'status', 'summary'\"],\"errors\":{}}";
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if:\n\n *  the request is invalid, that is:\n    \n     *  invalid data is provided, such as a request including issue ID and key.\n     *  the expression is invalid and can not be parsed.\n *  evaluation fails at runtime. This may happen for various reasons. For example, accessing a property on a null object (such as the expression `issue.id` where `issue` is `null`). In this case an error message is provided.\n *  If jql is unbounded or empty.\n *  If nextPageToken is invalid';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Issue does not exist or you do not have permission to see it."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if any object provided in the request context is not found or the user does not have permission to view it.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work', 'read:jira-user'];
        },
        {},
      ];
      summary: 'Evaluate Jira expression using enhanced search API';
      tags: ['Jira expressions'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work', 'read:jira-user'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-expressions:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/field': {
    get: {
      deprecated: false;
      description: 'Returns system and custom issue fields according to the following rules:\n\n *  Fields that cannot be added to the issue navigator are always returned.\n *  Fields that cannot be placed on an issue screen are always returned.\n *  Fields that depend on global Jira settings are only returned if the setting is enabled. That is, timetracking fields, subtasks, votes, and watches.\n *  For all other fields, this operation only returns the fields that the user has permission to view (that is, the field is used in at least one project that the user has *Browse Projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for.)\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** None.';
      operationId: 'getFields';
      parameters: [];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '[{"clauseNames":["description"],"custom":false,"id":"description","name":"Description","navigable":true,"orderable":true,"schema":{"system":"description","type":"string"},"searchable":true},{"clauseNames":["summary"],"custom":false,"id":"summary","key":"summary","name":"Summary","navigable":true,"orderable":true,"schema":{"system":"summary","type":"string"},"searchable":true}]';
              schema: {
                items: {
                  $ref: '#/components/schemas/FieldDetails';
                };
                type: 'array';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get fields';
      tags: ['Issue fields'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:field:jira',
            'read:avatar:jira',
            'read:project-category:jira',
            'read:project:jira',
            'read:field-configuration:jira',
          ];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Creates a custom field.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'createCustomField';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              description: 'Custom field for picking groups';
              name: 'New custom field';
              searcherKey: 'com.atlassian.jira.plugin.system.customfieldtypes:grouppickersearcher';
              type: 'com.atlassian.jira.plugin.system.customfieldtypes:grouppicker';
            };
            schema: {
              $ref: '#/components/schemas/CustomFieldDefinitionJsonBean';
            };
          };
        };
        description: 'Definition of the custom field to be created';
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              example: '{"clauseNames":["cf[10101]","New custom field"],"custom":true,"id":"customfield_10101","key":"customfield_10101","name":"New custom field","navigable":true,"orderable":true,"schema":{"custom":"com.atlassian.jira.plugin.system.customfieldtypes:project","customId":10101,"type":"project"},"searchable":true,"untranslatedName":"New custom field"}';
              schema: {
                $ref: '#/components/schemas/FieldDetails';
              };
            };
          };
          description: 'Returned if the custom field is created.';
        };
        '400': {
          description: 'Returned if:\n\n *  the user does not have permission to create custom fields.\n *  any of the request object properties have invalid or missing values.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
        {},
      ];
      summary: 'Create custom field';
      tags: ['Issue fields'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'write:field:jira',
            'read:avatar:jira',
            'read:field:jira',
            'read:project-category:jira',
            'read:project:jira',
            'read:field-configuration:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/search': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of fields for Classic Jira projects. The list can include:\n\n *  all fields\n *  specific fields, by defining `id`\n *  fields that contain a string in the field name or description, by defining `query`\n *  specific fields that contain a string in the field name or description, by defining `id` and `query`\n\nOnly custom fields can be queried, `type` must be set to `custom`.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getFieldsPaginated';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The type of fields to search.';
          in: 'query';
          name: 'type';
          schema: {
            items: {
              default: '';
              enum: ['custom', 'system'];
              type: 'string';
            };
            type: 'array';
          };
        },
        {
          description: 'The IDs of the custom fields to return or, where `query` is specified, filter.';
          in: 'query';
          name: 'id';
          schema: {
            items: {
              default: '';
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: 'String used to perform a case-insensitive partial match with field names or descriptions.';
          in: 'query';
          name: 'query';
          schema: {
            type: 'string';
          };
        },
        {
          description: '[Order](#ordering) the results by a field:\n\n *  `contextsCount` sorts by the number of contexts related to a field\n *  `lastUsed` sorts by the date when the value of the field last changed\n *  `name` sorts by the field name\n *  `screensCount` sorts by the number of screens related to a field';
          in: 'query';
          name: 'orderBy';
          schema: {
            enum: [
              'contextsCount',
              '-contextsCount',
              '+contextsCount',
              'lastUsed',
              '-lastUsed',
              '+lastUsed',
              'name',
              '-name',
              '+name',
              'screensCount',
              '-screensCount',
              '+screensCount',
              'projectsCount',
              '-projectsCount',
              '+projectsCount',
            ];
            type: 'string';
          };
        },
        {
          description: 'Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:\n\n *  `key` returns the key for each field\n *  `stableId` returns the stableId for each field\n *  `lastUsed` returns the date when the value of the field last changed\n *  `screensCount` returns the number of screens related to a field\n *  `contextsCount` returns the number of contexts related to a field\n *  `isLocked` returns information about whether the field is [locked](https://confluence.atlassian.com/x/ZSN7Og)\n *  `searcherKey` returns the searcher key for each custom field';
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":false,"maxResults":50,"startAt":0,"total":2,"values":[{"id":"customfield_10000","name":"Approvers","schema":{"custom":"com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker","customId":10000,"items":"user","type":"array"},"description":"Contains users needed for approval. This custom field was created by Jira Service Desk.","key":"customfield_10000","stableId":"sfid:approvers","isLocked":true,"searcherKey":"com.atlassian.jira.plugin.system.customfieldtypes:userpickergroupsearcher","screensCount":2,"contextsCount":2,"lastUsed":{"type":"TRACKED","value":"2021-01-28T07:37:40.000+0000"}},{"id":"customfield_10001","name":"Change reason","schema":{"custom":"com.atlassian.jira.plugin.system.customfieldtypes:select","customId":10001,"type":"option"},"description":"Choose the reason for the change request","key":"customfield_10001","stableId":"sfid:change-reason","isLocked":false,"searcherKey":"com.atlassian.jira.plugin.system.customfieldtypes:multiselectsearcher","screensCount":2,"contextsCount":2,"projectsCount":2,"lastUsed":{"type":"NOT_TRACKED"}}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanField';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only custom fields can be queried."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access fields."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the user does not have the necessary permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
      ];
      summary: 'Get fields paginated';
      tags: ['Issue fields'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field:jira', 'read:field-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/search/trashed': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of fields in the trash. The list may be restricted to fields whose field name or description partially match a string.\n\nOnly custom fields can be queried, `type` must be set to `custom`.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getTrashedFieldsPaginated';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          in: 'query';
          name: 'id';
          schema: {
            items: {
              default: '';
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: 'String used to perform a case-insensitive partial match with field names or descriptions.';
          in: 'query';
          name: 'query';
          schema: {
            type: 'string';
          };
        },
        {
          in: 'query';
          name: 'expand';
          schema: {
            enum: [
              'name',
              '-name',
              '+name',
              'trashDate',
              '-trashDate',
              '+trashDate',
              'plannedDeletionDate',
              '-plannedDeletionDate',
              '+plannedDeletionDate',
              'projectsCount',
              '-projectsCount',
              '+projectsCount',
            ];
            type: 'string';
          };
        },
        {
          description: '[Order](#ordering) the results by a field:\n\n *  `name` sorts by the field name\n *  `trashDate` sorts by the date the field was moved to the trash\n *  `plannedDeletionDate` sorts by the planned deletion date';
          in: 'query';
          name: 'orderBy';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":false,"maxResults":50,"startAt":0,"total":1,"values":[{"id":"customfield_10000","name":"Approvers","schema":{"custom":"com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker","customId":10003,"type":"array"},"description":"Contains users needed for approval. This custom field was created by Jira Service Desk.","key":"customfield_10003","trashedDate":"2022-10-06T07:32:47.000+0000","trashedBy":{"accountId":"5b10a2844c20165700ede21g","active":true,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","emailAddress":"mia@example.com","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g","timeZone":"Australia/Sydney"},"plannedDeletionDate":"2022-10-24T07:32:47.000+0000"}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanField';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only custom fields can be queried."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access fields."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the user does not have the necessary permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
      ];
      summary: 'Get fields in trash paginated';
      tags: ['Issue fields'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field:jira', 'read:field-configuration:jira', 'read:user:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldId}': {
    put: {
      deprecated: false;
      description: 'Updates a custom field.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'updateCustomField';
      parameters: [
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              description: 'Select the manager and the corresponding employee.';
              name: 'Managers and employees list';
              searcherKey: 'com.atlassian.jira.plugin.system.customfieldtypes:cascadingselectsearcher';
            };
            schema: {
              $ref: '#/components/schemas/UpdateCustomFieldDetails';
            };
          };
        };
        description: 'The custom field update details.';
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["searcherKey is invalid for the field type."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can edit custom fields."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The custom field was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the custom field is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Update custom field';
      tags: ['Issue fields'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldId}/context': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of [ contexts](https://confluence.atlassian.com/adminjiracloud/what-are-custom-field-contexts-991923859.html) for a custom field. Contexts can be returned as follows:\n\n *  With no other parameters set, all contexts.\n *  By defining `id` only, all contexts from the list of IDs.\n *  By defining `isAnyIssueType`, limit the list of contexts returned to either those that apply to all issue types (true) or those that apply to only a subset of issue types (false)\n *  By defining `isGlobalContext`, limit the list of contexts return to either those that apply to all projects (global contexts) (true) or those that apply to only a subset of projects (false).\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getContextsForField';
      parameters: [
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Whether to return contexts that apply to all issue types.';
          in: 'query';
          name: 'isAnyIssueType';
          schema: {
            type: 'boolean';
          };
        },
        {
          description: 'Whether to return contexts that apply to all projects.';
          in: 'query';
          name: 'isGlobalContext';
          schema: {
            type: 'boolean';
          };
        },
        {
          description: 'The list of context IDs. To include multiple contexts, separate IDs with ampersand: `contextId=10000&contextId=10001`.';
          in: 'query';
          name: 'contextId';
          schema: {
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":100,"startAt":0,"total":2,"values":[{"id":"10025","name":"Bug fields context","description":"A context used to define the custom field options for bugs.","isGlobalContext":true,"isAnyIssueType":false},{"id":"10026","name":"Task fields context","description":"A context used to define the custom field options for tasks.","isGlobalContext":false,"isAnyIssueType":false}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanCustomFieldContext';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access custom field contexts."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The custom field was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the custom field was not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get custom field contexts';
      tags: ['Issue custom field contexts'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field:jira', 'read:custom-field-contextual-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Creates a custom field context.\n\nIf `projectIds` is empty, a global context is created. A global context is one that applies to all project. If `issueTypeIds` is empty, the context applies to all issue types.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'createCustomFieldContext';
      parameters: [
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              description: 'A context used to define the custom field options for bugs.';
              issueTypeIds: ['10010'];
              name: 'Bug fields context';
              projectIds: [];
            };
            schema: {
              $ref: '#/components/schemas/CreateCustomFieldContext';
            };
          };
        };
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              example: '{"id":"10025","name":"Bug fields context","description":"A context used to define the custom field options for bugs.","projectIds":[],"issueTypeIds":["10010"]}';
              schema: {
                $ref: '#/components/schemas/CreateCustomFieldContext';
              };
            };
          };
          description: 'Returned if the custom field context is created.';
        };
        '400': {
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if the field, project, or issue type is not found.';
        };
        '409': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Sub-tasks are disabled in Jira. At least one of the issue types is a sub-task."],"errors":{}}';
            };
          };
          description: 'Returned if the issue type is a sub-task, but sub-tasks are disabled in Jira settings.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Create custom field context';
      tags: ['Issue custom field contexts'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field:jira', 'write:field:jira', 'read:custom-field-contextual-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldId}/context/defaultValue': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of defaults for a custom field. The results can be filtered by `contextId`, otherwise all values are returned. If no defaults are set for a context, nothing is returned.  \nThe returned object depends on type of the custom field:\n\n *  `CustomFieldContextDefaultValueDate` (type `datepicker`) for date fields.\n *  `CustomFieldContextDefaultValueDateTime` (type `datetimepicker`) for date-time fields.\n *  `CustomFieldContextDefaultValueSingleOption` (type `option.single`) for single choice select lists and radio buttons.\n *  `CustomFieldContextDefaultValueMultipleOption` (type `option.multiple`) for multiple choice select lists and checkboxes.\n *  `CustomFieldContextDefaultValueCascadingOption` (type `option.cascading`) for cascading select lists.\n *  `CustomFieldContextSingleUserPickerDefaults` (type `single.user.select`) for single users.\n *  `CustomFieldContextDefaultValueMultiUserPicker` (type `multi.user.select`) for user lists.\n *  `CustomFieldContextDefaultValueSingleGroupPicker` (type `grouppicker.single`) for single choice group pickers.\n *  `CustomFieldContextDefaultValueMultipleGroupPicker` (type `grouppicker.multiple`) for multiple choice group pickers.\n *  `CustomFieldContextDefaultValueURL` (type `url`) for URLs.\n *  `CustomFieldContextDefaultValueProject` (type `project`) for project pickers.\n *  `CustomFieldContextDefaultValueFloat` (type `float`) for floats (floating-point numbers).\n *  `CustomFieldContextDefaultValueLabels` (type `labels`) for labels.\n *  `CustomFieldContextDefaultValueTextField` (type `textfield`) for text fields.\n *  `CustomFieldContextDefaultValueTextArea` (type `textarea`) for text area fields.\n *  `CustomFieldContextDefaultValueReadOnly` (type `readonly`) for read only (text) fields.\n *  `CustomFieldContextDefaultValueMultipleVersion` (type `version.multiple`) for single choice version pickers.\n *  `CustomFieldContextDefaultValueSingleVersion` (type `version.single`) for multiple choice version pickers.\n\nForge custom fields [types](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field-type/#data-types) are also supported, returning:\n\n *  `CustomFieldContextDefaultValueForgeStringFieldBean` (type `forge.string`) for Forge string fields.\n *  `CustomFieldContextDefaultValueForgeMultiStringFieldBean` (type `forge.string.list`) for Forge string collection fields.\n *  `CustomFieldContextDefaultValueForgeObjectFieldBean` (type `forge.object`) for Forge object fields.\n *  `CustomFieldContextDefaultValueForgeDateTimeFieldBean` (type `forge.datetime`) for Forge date-time fields.\n *  `CustomFieldContextDefaultValueForgeGroupFieldBean` (type `forge.group`) for Forge group fields.\n *  `CustomFieldContextDefaultValueForgeMultiGroupFieldBean` (type `forge.group.list`) for Forge group collection fields.\n *  `CustomFieldContextDefaultValueForgeNumberFieldBean` (type `forge.number`) for Forge number fields.\n *  `CustomFieldContextDefaultValueForgeUserFieldBean` (type `forge.user`) for Forge user fields.\n *  `CustomFieldContextDefaultValueForgeMultiUserFieldBean` (type `forge.user.list`) for Forge user collection fields.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getDefaultValues';
      parameters: [
        {
          description: 'The ID of the custom field, for example `customfield\\_10000`.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The IDs of the contexts.';
          in: 'query';
          name: 'contextId';
          schema: {
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":50,"startAt":0,"total":3,"values":[{"contextId":"10100","optionId":"10001"},{"contextId":"10101","optionId":"10003"},{"contextId":"10103"}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanCustomFieldContextDefaultValue';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access custom field contexts."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The custom field was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the custom field is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get custom field contexts default values';
      tags: ['Issue custom field contexts'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field.default-value:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Sets default for contexts of a custom field. Default are defined using these objects:\n\n *  `CustomFieldContextDefaultValueDate` (type `datepicker`) for date fields.\n *  `CustomFieldContextDefaultValueDateTime` (type `datetimepicker`) for date-time fields.\n *  `CustomFieldContextDefaultValueSingleOption` (type `option.single`) for single choice select lists and radio buttons.\n *  `CustomFieldContextDefaultValueMultipleOption` (type `option.multiple`) for multiple choice select lists and checkboxes.\n *  `CustomFieldContextDefaultValueCascadingOption` (type `option.cascading`) for cascading select lists.\n *  `CustomFieldContextSingleUserPickerDefaults` (type `single.user.select`) for single users.\n *  `CustomFieldContextDefaultValueMultiUserPicker` (type `multi.user.select`) for user lists.\n *  `CustomFieldContextDefaultValueSingleGroupPicker` (type `grouppicker.single`) for single choice group pickers.\n *  `CustomFieldContextDefaultValueMultipleGroupPicker` (type `grouppicker.multiple`) for multiple choice group pickers.\n *  `CustomFieldContextDefaultValueURL` (type `url`) for URLs.\n *  `CustomFieldContextDefaultValueProject` (type `project`) for project pickers.\n *  `CustomFieldContextDefaultValueFloat` (type `float`) for floats (floating-point numbers).\n *  `CustomFieldContextDefaultValueLabels` (type `labels`) for labels.\n *  `CustomFieldContextDefaultValueTextField` (type `textfield`) for text fields.\n *  `CustomFieldContextDefaultValueTextArea` (type `textarea`) for text area fields.\n *  `CustomFieldContextDefaultValueReadOnly` (type `readonly`) for read only (text) fields.\n *  `CustomFieldContextDefaultValueMultipleVersion` (type `version.multiple`) for single choice version pickers.\n *  `CustomFieldContextDefaultValueSingleVersion` (type `version.single`) for multiple choice version pickers.\n\nForge custom fields [types](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field-type/#data-types) are also supported, returning:\n\n *  `CustomFieldContextDefaultValueForgeStringFieldBean` (type `forge.string`) for Forge string fields.\n *  `CustomFieldContextDefaultValueForgeMultiStringFieldBean` (type `forge.string.list`) for Forge string collection fields.\n *  `CustomFieldContextDefaultValueForgeObjectFieldBean` (type `forge.object`) for Forge object fields.\n *  `CustomFieldContextDefaultValueForgeDateTimeFieldBean` (type `forge.datetime`) for Forge date-time fields.\n *  `CustomFieldContextDefaultValueForgeGroupFieldBean` (type `forge.group`) for Forge group fields.\n *  `CustomFieldContextDefaultValueForgeMultiGroupFieldBean` (type `forge.group.list`) for Forge group collection fields.\n *  `CustomFieldContextDefaultValueForgeNumberFieldBean` (type `forge.number`) for Forge number fields.\n *  `CustomFieldContextDefaultValueForgeUserFieldBean` (type `forge.user`) for Forge user fields.\n *  `CustomFieldContextDefaultValueForgeMultiUserFieldBean` (type `forge.user.list`) for Forge user collection fields.\n\nOnly one type of default object can be included in a request. To remove a default for a context, set the default parameter to `null`.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'setDefaultValues';
      parameters: [
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              defaultValues: [
                {
                  contextId: '10100';
                  optionId: '10001';
                  type: 'option.single';
                },
                {
                  contextId: '10101';
                  optionId: '10003';
                  type: 'option.single';
                },
                {
                  contextId: '10103';
                  optionId: '10005';
                  type: 'option.single';
                },
              ];
            };
            schema: {
              $ref: '#/components/schemas/CustomFieldContextDefaultValueUpdate';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if operation is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["All default values in the request must have the same type."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access custom field contexts."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The context was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the custom field, a context, an option, or a cascading option is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Set custom field contexts default values';
      tags: ['Issue custom field contexts'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field.default-value:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldId}/context/issuetypemapping': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of context to issue type mappings for a custom field. Mappings are returned for all contexts or a list of contexts. Mappings are ordered first by context ID and then by issue type ID.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getIssueTypeMappingsForContexts';
      parameters: [
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the context. To include multiple contexts, provide an ampersand-separated list. For example, `contextId=10001&contextId=10002`.';
          in: 'query';
          name: 'contextId';
          schema: {
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":100,"startAt":0,"total":3,"values":[{"contextId":"10001","issueTypeId":"10010"},{"contextId":"10001","issueTypeId":"10011"},{"contextId":"10002","isAnyIssueType":true}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanIssueTypeToContextMapping';
              };
            };
          };
          description: 'Returned if operation is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access custom field contexts."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get issue types for custom field context';
      tags: ['Issue custom field contexts'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldId}/context/mapping': {
    post: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of project and issue type mappings and, for each mapping, the ID of a [custom field context](https://confluence.atlassian.com/x/k44fOw) that applies to the project and issue type.\n\nIf there is no custom field context assigned to the project then, if present, the custom field context that applies to all projects is returned if it also applies to the issue type or all issue types. If a custom field context is not found, the returned custom field context ID is `null`.\n\nDuplicate project and issue type mappings cannot be provided in the request.\n\nThe order of the returned values is the same as provided in the request.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getCustomFieldContextsForProjectsAndIssueTypes';
      parameters: [
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              mappings: [
                {
                  issueTypeId: '10000';
                  projectId: '10000';
                },
                {
                  issueTypeId: '10001';
                  projectId: '10000';
                },
                {
                  issueTypeId: '10002';
                  projectId: '10001';
                },
              ];
            };
            schema: {
              $ref: '#/components/schemas/ProjectIssueTypeMappings';
            };
          };
        };
        description: 'The list of project and issue type mappings.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":50,"startAt":0,"total":3,"values":[{"projectId":"10000","issueTypeId":"10000","contextId":"10000"},{"projectId":"10000","issueTypeId":"10001","contextId":null},{"projectId":"10001","issueTypeId":"10002","contextId":"10003"}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanContextForProjectAndIssueType';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Duplicate project and issue type mappings cannot be provided."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access custom field contexts."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["These projects were not found: 10005."],"errors":{}}';
            };
          };
          description: 'Returned if the custom field, project, or issue type is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get custom field contexts for projects and issue types';
      tags: ['Issue custom field contexts'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldId}/context/projectmapping': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of context to project mappings for a custom field. The result can be filtered by `contextId`. Otherwise, all mappings are returned. Invalid IDs are ignored.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getProjectContextMapping';
      parameters: [
        {
          description: 'The ID of the custom field, for example `customfield\\_10000`.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The list of context IDs. To include multiple context, separate IDs with ampersand: `contextId=10000&contextId=10001`.';
          in: 'query';
          name: 'contextId';
          schema: {
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":100,"startAt":0,"total":2,"values":[{"contextId":"10025","projectId":"10001"},{"contextId":"10026","isGlobalContext":true}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanCustomFieldContextProjectMapping';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access custom field contexts."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The custom field was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the custom field is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get project mappings for custom field context';
      tags: ['Issue custom field contexts'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldId}/context/{contextId}': {
    delete: {
      deprecated: false;
      description: 'Deletes a [ custom field context](https://confluence.atlassian.com/adminjiracloud/what-are-custom-field-contexts-991923859.html).\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'deleteCustomFieldContext';
      parameters: [
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the context.';
          in: 'path';
          name: 'contextId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the context is deleted.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The contextId has to be provided."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access custom field contexts."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The context was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the custom field or the context is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Delete custom field context';
      tags: ['Issue custom field contexts'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:field:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Updates a [ custom field context](https://confluence.atlassian.com/adminjiracloud/what-are-custom-field-contexts-991923859.html).\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'updateCustomFieldContext';
      parameters: [
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the context.';
          in: 'path';
          name: 'contextId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              description: 'A context used to define the custom field options for bugs.';
              name: 'Bug fields context';
            };
            schema: {
              $ref: '#/components/schemas/CustomFieldContextUpdateDetails';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the context is updated.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The contextId has to be provided."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access custom field contexts."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The context was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the custom field or the context is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Update custom field context';
      tags: ['Issue custom field contexts'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldId}/context/{contextId}/issuetype': {
    put: {
      deprecated: false;
      description: 'Adds issue types to a custom field context, appending the issue types to the issue types list.\n\nA custom field context without any issue types applies to all issue types. Adding issue types to such a custom field context would result in it applying to only the listed issue types.\n\nIf any of the issue types exists in the custom field context, the operation fails and no issue types are added.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'addIssueTypesToContext';
      parameters: [
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the context.';
          in: 'path';
          name: 'contextId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              issueTypeIds: ['10001', '10005', '10006'];
            };
            schema: {
              $ref: '#/components/schemas/IssueTypeIds';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if operation is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["These issue types are already associated with the context: 10001."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access custom field contexts."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The context was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the custom field, context, or one or more issue types are not found.';
        };
        '409': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Sub-tasks are disabled in Jira. At least one of the issue types is a sub-task."],"errors":{}}';
            };
          };
          description: 'Returned if the issue type is a sub-task, but sub-tasks are disabled in Jira settings.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Add issue types to context';
      tags: ['Issue custom field contexts'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldId}/context/{contextId}/issuetype/remove': {
    post: {
      deprecated: false;
      description: 'Removes issue types from a custom field context.\n\nA custom field context without any issue types applies to all issue types.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'removeIssueTypesFromContext';
      parameters: [
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the context.';
          in: 'path';
          name: 'contextId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              issueTypeIds: ['10001', '10005', '10006'];
            };
            schema: {
              $ref: '#/components/schemas/IssueTypeIds';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if operation is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["These issue types are not associated with the context: 10002."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access custom field contexts."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The context was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the custom field, context, or one or more issue types are not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Remove issue types from context';
      tags: ['Issue custom field contexts'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldId}/context/{contextId}/option': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of all custom field option for a context. Options are returned first then cascading options, in the order they display in Jira.\n\nThis operation works for custom field options created in Jira or the operations from this resource. **To work with issue field select list options created for Connect apps use the [Issue custom field options (apps)](#api-group-issue-custom-field-options--apps-) operations.**\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getOptionsForContext';
      parameters: [
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the context.';
          in: 'path';
          name: 'contextId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The ID of the option.';
          in: 'query';
          name: 'optionId';
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'Whether only options are returned.';
          in: 'query';
          name: 'onlyOptions';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 100;
            format: 'int32';
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":100,"startAt":0,"total":4,"values":[{"id":"10001","value":"New York"},{"id":"10002","value":"Boston","disabled":true},{"id":"10004","value":"Denver"},{"id":"10003","value":"Brooklyn","optionId":"10001"}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanCustomFieldContextOption';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The custom field doesn\'t support options."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can manage custom field options."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The custom field was not found."],"errors":{}}';
            };
          };
          description: "Returned if the custom field is not found or the context doesn't match the custom field.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get custom field options (context)';
      tags: ['Issue custom field options'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field.option:jira'];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Creates options and, where the custom select field is of the type Select List (cascading), cascading options for a custom select field. The options are added to a context of the field.\n\nThe maximum number of options that can be created per request is 1000 and each field can have a maximum of 10000 options.\n\nThis operation works for custom field options created in Jira or the operations from this resource. **To work with issue field select list options created for Connect apps use the [Issue custom field options (apps)](#api-group-issue-custom-field-options--apps-) operations.**\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'createCustomFieldOption';
      parameters: [
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the context.';
          in: 'path';
          name: 'contextId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              options: [
                {
                  disabled: false;
                  value: 'Scranton';
                },
                {
                  disabled: true;
                  optionId: '10000';
                  value: 'Manhattan';
                },
                {
                  disabled: false;
                  value: 'The Electric City';
                },
              ];
            };
            schema: {
              $ref: '#/components/schemas/BulkCustomFieldOptionCreateRequest';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"options":[{"disabled":false,"id":"10001","value":"Scranton"},{"disabled":true,"id":"10002","optionId":"10000","value":"Manhattan"},{"disabled":false,"id":"10003","value":"The Electric City"}]}';
              schema: {
                $ref: '#/components/schemas/CustomFieldCreatedContextOptionsList';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The custom field doesn\'t support options."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can manage custom field options."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The custom field was not found."],"errors":{}}';
            };
          };
          description: "Returned if the custom field is not found or the context doesn't match the custom field.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Create custom field options (context)';
      tags: ['Issue custom field options'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field.option:jira', 'write:field.option:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: "Updates the options of a custom field.\n\nIf any of the options are not found, no options are updated. Options where the values in the request match the current values aren't updated and aren't reported in the response.\n\nNote that this operation **only works for issue field select list options created in Jira or using operations from the [Issue custom field options](#api-group-Issue-custom-field-options) resource**, it cannot be used with issue field select list options created by Connect apps.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).";
      operationId: 'updateCustomFieldOption';
      parameters: [
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the context.';
          in: 'path';
          name: 'contextId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              options: [
                {
                  disabled: false;
                  id: '10001';
                  value: 'Scranton';
                },
                {
                  disabled: true;
                  id: '10002';
                  value: 'Manhattan';
                },
                {
                  disabled: false;
                  id: '10003';
                  value: 'The Electric City';
                },
              ];
            };
            schema: {
              $ref: '#/components/schemas/BulkCustomFieldOptionUpdateRequest';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"options":[{"disabled":false,"id":"10001","value":"Scranton"},{"disabled":true,"id":"10002","value":"Manhattan"},{"disabled":false,"id":"10003","value":"The Electric City"}]}';
              schema: {
                $ref: '#/components/schemas/CustomFieldUpdatedContextOptionsList';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The custom field doesn\'t support options."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can manage custom field options."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The custom field was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the field, context, or one or more options is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Update custom field options (context)';
      tags: ['Issue custom field options'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field.option:jira', 'write:field.option:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldId}/context/{contextId}/option/move': {
    put: {
      deprecated: false;
      description: 'Changes the order of custom field options or cascading options in a context.\n\nThis operation works for custom field options created in Jira or the operations from this resource. **To work with issue field select list options created for Connect apps use the [Issue custom field options (apps)](#api-group-issue-custom-field-options--apps-) operations.**\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'reorderCustomFieldOptions';
      parameters: [
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the context.';
          in: 'path';
          name: 'contextId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              customFieldOptionIds: ['10001', '10002'];
              position: 'First';
            };
            schema: {
              $ref: '#/components/schemas/OrderOfCustomFieldOptions';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if options are reordered.';
        };
        '400': {
          content: {
            'application/json': {
              example: "{\"errorMessages\":[\"'after' and 'position' were provided. Only 'after' or 'position' can be specified.\"],\"errors\":{}}";
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can manage custom field options."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The custom field was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the field, the context, or one or more of the options is not found..';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Reorder custom field options (context)';
      tags: ['Issue custom field options'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field.option:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldId}/context/{contextId}/option/{optionId}': {
    delete: {
      deprecated: false;
      description: 'Deletes a custom field option.\n\nOptions with cascading options cannot be deleted without deleting the cascading options first.\n\nThis operation works for custom field options created in Jira or the operations from this resource. **To work with issue field select list options created for Connect apps use the [Issue custom field options (apps)](#api-group-issue-custom-field-options--apps-) operations.**\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'deleteCustomFieldOption';
      parameters: [
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the context from which an option should be deleted.';
          in: 'path';
          name: 'contextId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The ID of the option to delete.';
          in: 'path';
          name: 'optionId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the option is deleted.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The custom field doesn\'t support options."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can manage custom field options."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The custom field was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the field, the context, or the option is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Delete custom field options (context)';
      tags: ['Issue custom field options'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:field.option:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldId}/context/{contextId}/option/{optionId}/issue': {
    delete: {
      deprecated: false;
      description: 'Replaces the options of a custom field.\n\nNote that this operation **only works for issue field select list options created in Jira or using operations from the [Issue custom field options](#api-group-Issue-custom-field-options) resource**, it cannot be used with issue field select list options created by Connect or Forge apps.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'replaceCustomFieldOption';
      parameters: [
        {
          description: 'The ID of the option that will replace the currently selected option.';
          in: 'query';
          name: 'replaceWith';
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'A JQL query that specifies the issues to be updated. For example, *project=10000*.';
          in: 'query';
          name: 'jql';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the option to be deselected.';
          in: 'path';
          name: 'optionId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The ID of the context.';
          in: 'path';
          name: 'contextId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      responses: {
        '303': {
          content: {
            'application/json': {
              example: '{"self":"https://your-domain.atlassian.net/rest/api/3/task/1","id":"1","description":"Remove option 1 from issues matched by \'*\', and replace with option 3","status":"COMPLETE","result":{"errors":{"errorMessages":["Option 2 cannot be set on issue MKY-5 as it is not in the correct scope"],"errors":{},"httpStatusCode":{"empty":false,"present":true}},"modifiedIssues":[10001,10010],"unmodifiedIssues":[10005]},"elapsedRuntime":42}';
              schema: {
                $ref: '#/components/schemas/TaskProgressBeanRemoveOptionFromIssuesResult';
              };
            };
          };
          description: 'Returned if the long-running task to deselect the option is started.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Connect and Forge app users with Administer Jira global permission can override screen security."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if the field is not found or does not support options, or the options to be replaced are not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Replace custom field options';
      tags: ['Issue custom field options'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field.option:jira', 'write:field.option:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldId}/context/{contextId}/project': {
    put: {
      deprecated: false;
      description: 'Assigns a custom field context to projects.\n\nIf any project in the request is assigned to any context of the custom field, the operation fails.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'assignProjectsToCustomFieldContext';
      parameters: [
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the context.';
          in: 'path';
          name: 'contextId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              projectIds: ['10001', '10005', '10006'];
            };
            schema: {
              $ref: '#/components/schemas/ProjectIds';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if operation is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The projectIds must not contain duplicates."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access custom field contexts."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The context was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the custom field, context, or project is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Assign custom field context to projects';
      tags: ['Issue custom field contexts'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldId}/context/{contextId}/project/remove': {
    post: {
      deprecated: false;
      description: 'Removes a custom field context from projects.\n\nA custom field context without any projects applies to all projects. Removing all projects from a custom field context would result in it applying to all projects.\n\nIf any project in the request is not assigned to the context, or the operation would result in two global contexts for the field, the operation fails.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'removeCustomFieldContextFromProjects';
      parameters: [
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the context.';
          in: 'path';
          name: 'contextId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              projectIds: ['10001', '10005', '10006'];
            };
            schema: {
              $ref: '#/components/schemas/ProjectIds';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the custom field context is removed from the projects.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The projectIds must not contain duplicates."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access custom field contexts."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The context was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the custom field, context, or one or more projects are not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Remove custom field context from projects';
      tags: ['Issue custom field contexts'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldId}/contexts': {
    get: {
      deprecated: true;
      description: 'Returns a [paginated](#pagination) list of the contexts a field is used in. Deprecated, use [ Get custom field contexts](#api-rest-api-3-field-fieldId-context-get).\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getContextsForFieldDeprecated';
      parameters: [
        {
          description: 'The ID of the field to return contexts for.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 20;
            format: 'int32';
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":false,"maxResults":1,"startAt":0,"total":5,"values":[{"id":10001,"name":"Default Context"}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanContext';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-project'];
        },
        {},
      ];
      summary: 'Get contexts for a field';
      tags: ['Issue fields'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-project'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field:jira', 'read:avatar:jira', 'read:project-category:jira', 'read:project:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldId}/screens': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of the screens a field is used in.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getScreensForField';
      parameters: [
        {
          description: 'The ID of the field to return screens for.';
          in: 'path';
          name: 'fieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 100;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'Use [expand](#expansion) to include additional information about screens in the response. This parameter accepts `tab` which returns details about the screen tabs the field is used in.';
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":false,"maxResults":1,"startAt":0,"total":5,"values":[{"id":10001,"name":"Default Screen","description":"Provides for the update of all system fields.","tab":{"id":10000,"name":"Fields Tab"}}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanScreenWithTab';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-project'];
        },
        {},
      ];
      summary: 'Get screens for a field';
      tags: ['Screens'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-project'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:screen:jira',
            'read:avatar:jira',
            'read:project-category:jira',
            'read:project:jira',
            'read:screen-tab:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldKey}/option': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of all the options of a select list issue field. A select list issue field is a type of [issue field](https://developer.atlassian.com/cloud/jira/platform/modules/issue-field/) that enables a user to select a value from a list of options.\n\nNote that this operation **only works for issue field select list options added by Connect apps**, it cannot be used with issue field select list options created in Jira or using operations from the [Issue custom field options](#api-group-Issue-custom-field-options) resource.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg). Jira permissions are not required for the app providing the field.';
      operationId: 'getAllIssueFieldOptions';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The field key is specified in the following format: **$(app-key)\\_\\_$(field-key)**. For example, *example-add-on\\_\\_example-issue-field*. To determine the `fieldKey` value, do one of the following:\n\n *  open the app\'s plugin descriptor, then **app-key** is the key at the top and **field-key** is the key in the `jiraIssueFields` module. **app-key** can also be found in the app listing in the Atlassian Universal Plugin Manager.\n *  run [Get fields](#api-rest-api-3-field-get) and in the field details the value is returned in `key`. For example, `"key": "teams-add-on__team-issue-field"`';
          in: 'path';
          name: 'fieldKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":false,"maxResults":1,"nextPage":"https://your-domain.atlassian.net/rest/api/3/field/fieldKey/option?startAt=1&maxResults=1","self":"https://your-domain.atlassian.net/rest/api/3/field/fieldKey/option?startAt=0&maxResults=1","startAt":0,"total":10,"values":[{"id":1,"value":"Team 1","properties":{"leader":{"name":"Leader Name","email":"lname@example.com"},"members":42,"description":"The team\'s description","founded":"2016-06-06"},"config":{"scope":{"projects":[],"projects2":[{"id":1001,"attributes":["notSelectable"]},{"id":1002,"attributes":["notSelectable"]}],"global":{}},"attributes":[]}}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanIssueFieldOption';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the field is not found or does not support options.';
        };
        '403': {
          description: 'Returned if the request is not authenticated as a Jira administrator or the app that provided the field.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get all issue field options';
      tags: ['Issue custom field options (apps)'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field.option:jira'];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Creates an option for a select list issue field.\n\nNote that this operation **only works for issue field select list options added by Connect apps**, it cannot be used with issue field select list options created in Jira or using operations from the [Issue custom field options](#api-group-Issue-custom-field-options) resource.\n\nEach field can have a maximum of 10000 options, and each option can have a maximum of 10000 scopes.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg). Jira permissions are not required for the app providing the field.';
      operationId: 'createIssueFieldOption';
      parameters: [
        {
          description: 'The field key is specified in the following format: **$(app-key)\\_\\_$(field-key)**. For example, *example-add-on\\_\\_example-issue-field*. To determine the `fieldKey` value, do one of the following:\n\n *  open the app\'s plugin descriptor, then **app-key** is the key at the top and **field-key** is the key in the `jiraIssueFields` module. **app-key** can also be found in the app listing in the Atlassian Universal Plugin Manager.\n *  run [Get fields](#api-rest-api-3-field-get) and in the field details the value is returned in `key`. For example, `"key": "teams-add-on__team-issue-field"`';
          in: 'path';
          name: 'fieldKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              config: {
                attributes: [];
                scope: {
                  global: {};
                  projects: [];
                  projects2: [
                    {
                      attributes: ['notSelectable'];
                      id: 1001;
                    },
                    {
                      attributes: ['notSelectable'];
                      id: 1002;
                    },
                  ];
                };
              };
              properties: {
                description: "The team's description";
                founded: '2016-06-06';
                leader: {
                  email: 'lname@example.com';
                  name: 'Leader Name';
                };
                members: 42;
              };
              value: 'Team 1';
            };
            schema: {
              $ref: '#/components/schemas/IssueFieldOptionCreateBean';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"id":1,"value":"Team 1","properties":{"leader":{"name":"Leader Name","email":"lname@example.com"},"members":42,"description":"The team\'s description","founded":"2016-06-06"},"config":{"scope":{"projects":[],"projects2":[{"id":1001,"attributes":["notSelectable"]},{"id":1002,"attributes":["notSelectable"]}],"global":{}},"attributes":[]}}';
              schema: {
                $ref: '#/components/schemas/IssueFieldOption';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the option is invalid.';
        };
        '403': {
          description: 'Returned if the request is not authenticated as a Jira administrator or the app that provided the field.';
        };
        '404': {
          description: 'Returned if the field is not found or does not support options.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Create issue field option';
      tags: ['Issue custom field options (apps)'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field.option:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldKey}/option/suggestions/edit': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of options for a select list issue field that can be viewed and selected by the user.\n\nNote that this operation **only works for issue field select list options added by Connect apps**, it cannot be used with issue field select list options created in Jira or using operations from the [Issue custom field options](#api-group-Issue-custom-field-options) resource.\n\n**[Permissions](#permissions) required:** Permission to access Jira.';
      operationId: 'getSelectableIssueFieldOptions';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'Filters the results to options that are only available in the specified project.';
          in: 'query';
          name: 'projectId';
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The field key is specified in the following format: **$(app-key)\\_\\_$(field-key)**. For example, *example-add-on\\_\\_example-issue-field*. To determine the `fieldKey` value, do one of the following:\n\n *  open the app\'s plugin descriptor, then **app-key** is the key at the top and **field-key** is the key in the `jiraIssueFields` module. **app-key** can also be found in the app listing in the Atlassian Universal Plugin Manager.\n *  run [Get fields](#api-rest-api-3-field-get) and in the field details the value is returned in `key`. For example, `"key": "teams-add-on__team-issue-field"`';
          in: 'path';
          name: 'fieldKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":false,"maxResults":1,"nextPage":"https://your-domain.atlassian.net/rest/api/3/field/fieldKey/option/suggestions?startAt=1&maxResults=1","self":"https://your-domain.atlassian.net/rest/api/3/field/fieldKey/option/suggestions?startAt=0&maxResults=1","startAt":0,"total":10,"values":[{"id":1,"value":"Team 1","properties":{"leader":{"name":"Leader Name","email":"lname@example.com"},"members":42,"description":"The team\'s description","founded":"2016-06-06"}}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanIssueFieldOption';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if the field is not found or does not support options.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
      ];
      summary: 'Get selectable issue field options';
      tags: ['Issue custom field options (apps)'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field.option:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldKey}/option/suggestions/search': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of options for a select list issue field that can be viewed by the user.\n\nNote that this operation **only works for issue field select list options added by Connect apps**, it cannot be used with issue field select list options created in Jira or using operations from the [Issue custom field options](#api-group-Issue-custom-field-options) resource.\n\n**[Permissions](#permissions) required:** Permission to access Jira.';
      operationId: 'getVisibleIssueFieldOptions';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'Filters the results to options that are only available in the specified project.';
          in: 'query';
          name: 'projectId';
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The field key is specified in the following format: **$(app-key)\\_\\_$(field-key)**. For example, *example-add-on\\_\\_example-issue-field*. To determine the `fieldKey` value, do one of the following:\n\n *  open the app\'s plugin descriptor, then **app-key** is the key at the top and **field-key** is the key in the `jiraIssueFields` module. **app-key** can also be found in the app listing in the Atlassian Universal Plugin Manager.\n *  run [Get fields](#api-rest-api-3-field-get) and in the field details the value is returned in `key`. For example, `"key": "teams-add-on__team-issue-field"`';
          in: 'path';
          name: 'fieldKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":false,"maxResults":1,"nextPage":"https://your-domain.atlassian.net/rest/api/3/field/fieldKey/option/suggestions?startAt=1&maxResults=1","self":"https://your-domain.atlassian.net/rest/api/3/field/fieldKey/option/suggestions?startAt=0&maxResults=1","startAt":0,"total":10,"values":[{"id":1,"value":"Team 1","properties":{"leader":{"name":"Leader Name","email":"lname@example.com"},"members":42,"description":"The team\'s description","founded":"2016-06-06"}}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanIssueFieldOption';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if the field is not found or does not support options.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
      ];
      summary: 'Get visible issue field options';
      tags: ['Issue custom field options (apps)'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field.option:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldKey}/option/{optionId}': {
    delete: {
      deprecated: false;
      description: 'Deletes an option from a select list issue field.\n\nNote that this operation **only works for issue field select list options added by Connect apps**, it cannot be used with issue field select list options created in Jira or using operations from the [Issue custom field options](#api-group-Issue-custom-field-options) resource.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg). Jira permissions are not required for the app providing the field.';
      operationId: 'deleteIssueFieldOption';
      parameters: [
        {
          description: 'The field key is specified in the following format: **$(app-key)\\_\\_$(field-key)**. For example, *example-add-on\\_\\_example-issue-field*. To determine the `fieldKey` value, do one of the following:\n\n *  open the app\'s plugin descriptor, then **app-key** is the key at the top and **field-key** is the key in the `jiraIssueFields` module. **app-key** can also be found in the app listing in the Atlassian Universal Plugin Manager.\n *  run [Get fields](#api-rest-api-3-field-get) and in the field details the value is returned in `key`. For example, `"key": "teams-add-on__team-issue-field"`';
          in: 'path';
          name: 'fieldKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the option to be deleted.';
          in: 'path';
          name: 'optionId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the field option is deleted.';
        };
        '403': {
          description: 'Returned if the request is not authenticated as a Jira administrator or the app that provided the field.';
        };
        '404': {
          description: 'Returned if the field or option is not found.';
        };
        '409': {
          description: 'Returned if the option is selected for the field in any issue.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Delete issue field option';
      tags: ['Issue custom field options (apps)'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:field.option:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: 'Returns an option from a select list issue field.\n\nNote that this operation **only works for issue field select list options added by Connect apps**, it cannot be used with issue field select list options created in Jira or using operations from the [Issue custom field options](#api-group-Issue-custom-field-options) resource.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg). Jira permissions are not required for the app providing the field.';
      operationId: 'getIssueFieldOption';
      parameters: [
        {
          description: 'The field key is specified in the following format: **$(app-key)\\_\\_$(field-key)**. For example, *example-add-on\\_\\_example-issue-field*. To determine the `fieldKey` value, do one of the following:\n\n *  open the app\'s plugin descriptor, then **app-key** is the key at the top and **field-key** is the key in the `jiraIssueFields` module. **app-key** can also be found in the app listing in the Atlassian Universal Plugin Manager.\n *  run [Get fields](#api-rest-api-3-field-get) and in the field details the value is returned in `key`. For example, `"key": "teams-add-on__team-issue-field"`';
          in: 'path';
          name: 'fieldKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the option to be returned.';
          in: 'path';
          name: 'optionId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"id":1,"value":"Team 1","properties":{"leader":{"name":"Leader Name","email":"lname@example.com"},"members":42,"description":"The team\'s description","founded":"2016-06-06"},"config":{"scope":{"projects":[],"projects2":[{"id":1001,"attributes":["notSelectable"]},{"id":1002,"attributes":["notSelectable"]}],"global":{}},"attributes":[]}}';
              schema: {
                $ref: '#/components/schemas/IssueFieldOption';
              };
            };
          };
          description: 'Returned if the requested option is returned.';
        };
        '400': {
          description: 'Returned if the field is not found or does not support options.';
        };
        '403': {
          description: 'Returned if the request is not authenticated as a Jira administrator or the app that provided the field.';
        };
        '404': {
          description: 'Returned if the option is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get issue field option';
      tags: ['Issue custom field options (apps)'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field.option:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Updates or creates an option for a select list issue field. This operation requires that the option ID is provided when creating an option, therefore, the option ID needs to be specified as a path and body parameter. The option ID provided in the path and body must be identical.\n\nNote that this operation **only works for issue field select list options added by Connect apps**, it cannot be used with issue field select list options created in Jira or using operations from the [Issue custom field options](#api-group-Issue-custom-field-options) resource.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg). Jira permissions are not required for the app providing the field.';
      operationId: 'updateIssueFieldOption';
      parameters: [
        {
          description: 'The field key is specified in the following format: **$(app-key)\\_\\_$(field-key)**. For example, *example-add-on\\_\\_example-issue-field*. To determine the `fieldKey` value, do one of the following:\n\n *  open the app\'s plugin descriptor, then **app-key** is the key at the top and **field-key** is the key in the `jiraIssueFields` module. **app-key** can also be found in the app listing in the Atlassian Universal Plugin Manager.\n *  run [Get fields](#api-rest-api-3-field-get) and in the field details the value is returned in `key`. For example, `"key": "teams-add-on__team-issue-field"`';
          in: 'path';
          name: 'fieldKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the option to be updated.';
          in: 'path';
          name: 'optionId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              config: {
                attributes: [];
                scope: {
                  global: {};
                  projects: [];
                  projects2: [
                    {
                      attributes: ['notSelectable'];
                      id: 1001;
                    },
                    {
                      attributes: ['notSelectable'];
                      id: 1002;
                    },
                  ];
                };
              };
              id: 1;
              properties: {
                description: "The team's description";
                founded: '2016-06-06';
                leader: {
                  email: 'lname@example.com';
                  name: 'Leader Name';
                };
                members: 42;
              };
              value: 'Team 1';
            };
            schema: {
              $ref: '#/components/schemas/IssueFieldOption';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"id":1,"value":"Team 1","properties":{"leader":{"name":"Leader Name","email":"lname@example.com"},"members":42,"description":"The team\'s description","founded":"2016-06-06"},"config":{"scope":{"projects":[],"projects2":[{"id":1001,"attributes":["notSelectable"]},{"id":1002,"attributes":["notSelectable"]}],"global":{}},"attributes":[]}}';
              schema: {
                $ref: '#/components/schemas/IssueFieldOption';
              };
            };
          };
          description: 'Returned if the option is updated or created.';
        };
        '400': {
          description: 'Returned if the option is invalid, or the *ID* in the request object does not match the *optionId* parameter.';
        };
        '403': {
          description: 'Returned if the request is not authenticated as a Jira administrator or the app that provided the field.';
        };
        '404': {
          description: 'Returned if field is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Update issue field option';
      tags: ['Issue custom field options (apps)'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field.option:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{fieldKey}/option/{optionId}/issue': {
    delete: {
      deprecated: false;
      description: 'Deselects an issue-field select-list option from all issues where it is selected. A different option can be selected to replace the deselected option. The update can also be limited to a smaller set of issues by using a JQL query.\n\nConnect and Forge app users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) can override the screen security configuration using `overrideScreenSecurity` and `overrideEditableFlag`.\n\nThis is an [asynchronous operation](#async). The response object contains a link to the long-running task.\n\nNote that this operation **only works for issue field select list options added by Connect apps**, it cannot be used with issue field select list options created in Jira or using operations from the [Issue custom field options](#api-group-Issue-custom-field-options) resource.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg). Jira permissions are not required for the app providing the field.';
      operationId: 'replaceIssueFieldOption';
      parameters: [
        {
          description: 'The ID of the option that will replace the currently selected option.';
          in: 'query';
          name: 'replaceWith';
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'A JQL query that specifies the issues to be updated. For example, *project=10000*.';
          in: 'query';
          name: 'jql';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Whether screen security is overridden to enable hidden fields to be edited. Available to Connect and Forge app users with admin permission.';
          in: 'query';
          name: 'overrideScreenSecurity';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
        {
          description: 'Whether screen security is overridden to enable uneditable fields to be edited. Available to Connect and Forge app users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
          in: 'query';
          name: 'overrideEditableFlag';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
        {
          description: 'The field key is specified in the following format: **$(app-key)\\_\\_$(field-key)**. For example, *example-add-on\\_\\_example-issue-field*. To determine the `fieldKey` value, do one of the following:\n\n *  open the app\'s plugin descriptor, then **app-key** is the key at the top and **field-key** is the key in the `jiraIssueFields` module. **app-key** can also be found in the app listing in the Atlassian Universal Plugin Manager.\n *  run [Get fields](#api-rest-api-3-field-get) and in the field details the value is returned in `key`. For example, `"key": "teams-add-on__team-issue-field"`';
          in: 'path';
          name: 'fieldKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the option to be deselected.';
          in: 'path';
          name: 'optionId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      responses: {
        '303': {
          content: {
            'application/json': {
              example: '{"self":"https://your-domain.atlassian.net/rest/api/3/task/1","id":"1","description":"Remove option 1 from issues matched by \'*\', and replace with option 3","status":"COMPLETE","result":{"errors":{"errorMessages":["Option 2 cannot be set on issue MKY-5 as it is not in the correct scope"],"errors":{},"httpStatusCode":{"empty":false,"present":true}},"modifiedIssues":[10001,10010],"unmodifiedIssues":[10005]},"elapsedRuntime":42}';
              schema: {
                $ref: '#/components/schemas/TaskProgressBeanRemoveOptionFromIssuesResult';
              };
            };
          };
          description: 'Returned if the long-running task to deselect the option is started.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Connect and Forge app users with Administer Jira global permission can override screen security."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if the field is not found or does not support options, or the options to be replaced are not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Replace issue field option';
      tags: ['Issue custom field options (apps)'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field.option:jira', 'delete:field.option:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{id}': {
    delete: {
      deprecated: false;
      description: 'Deletes a custom field. The custom field is deleted whether it is in the trash or not. See [Edit or delete a custom field](https://confluence.atlassian.com/x/Z44fOw) for more information on trashing and deleting custom fields.\n\nThis operation is [asynchronous](#async). Follow the `location` link in the response to determine the status of the task and use [Get task](#api-rest-api-3-task-taskId-get) to obtain subsequent updates.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'deleteCustomField';
      parameters: [
        {
          description: 'The ID of a custom field.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '303': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/TaskProgressBeanObject';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if any of these are true:\n\n *  The custom field is locked.\n *  The custom field is used in a issue security scheme or a permission scheme.\n *  The custom field ID format is incorrect.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the custom field is not found.';
        };
        '409': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if a task to delete the custom field is running.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Delete custom field';
      tags: ['Issue fields'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:field:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{id}/restore': {
    post: {
      deprecated: false;
      description: 'Restores a custom field from trash. See [Edit or delete a custom field](https://confluence.atlassian.com/x/Z44fOw) for more information on trashing and deleting custom fields.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'restoreCustomField';
      parameters: [
        {
          description: 'The ID of a custom field.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the custom field is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Restore custom field from trash';
      tags: ['Issue fields'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/field/{id}/trash': {
    post: {
      deprecated: false;
      description: 'Moves a custom field to trash. See [Edit or delete a custom field](https://confluence.atlassian.com/x/Z44fOw) for more information on trashing and deleting custom fields.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'trashCustomField';
      parameters: [
        {
          description: 'The ID of a custom field.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the custom field is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Move custom field to trash';
      tags: ['Issue fields'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:field:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/fieldconfiguration': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of field configurations. The list can be for all field configurations or a subset determined by any combination of these criteria:\n\n *  a list of field configuration item IDs.\n *  whether the field configuration is a default.\n *  whether the field configuration name or description contains a query string.\n\nOnly field configurations used in company-managed (classic) projects are returned.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getAllFieldConfigurations';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The list of field configuration IDs. To include multiple IDs, provide an ampersand-separated list. For example, `id=10000&id=10001`.';
          in: 'query';
          name: 'id';
          schema: {
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: 'If *true* returns default field configurations only.';
          in: 'query';
          name: 'isDefault';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
        {
          description: 'The query string used to match against field configuration names and descriptions.';
          in: 'query';
          name: 'query';
          schema: {
            default: '';
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":50,"startAt":0,"total":2,"values":[{"id":10000,"name":"Default Field Configuration","description":"The default field configuration description","isDefault":true},{"id":10001,"name":"My Field Configuration","description":"My field configuration description"}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanFieldConfigurationDetails';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get all field configurations';
      tags: ['Issue field configurations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Creates a field configuration. The field configuration is created with the same field properties as the default configuration, with all the fields being optional.\n\nThis operation can only create configurations for use in company-managed (classic) projects.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'createFieldConfiguration';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              description: 'My field configuration description';
              name: 'My Field Configuration';
            };
            schema: {
              $ref: '#/components/schemas/FieldConfigurationDetails';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"description":"My field configuration description","id":10001,"name":"My Field Configuration"}';
              schema: {
                $ref: '#/components/schemas/FieldConfiguration';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Create field configuration';
      tags: ['Issue field configurations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field-configuration:jira', 'write:field-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/fieldconfiguration/{id}': {
    delete: {
      deprecated: false;
      description: 'Deletes a field configuration.\n\nThis operation can only delete configurations used in company-managed (classic) projects.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'deleteFieldConfiguration';
      parameters: [
        {
          description: 'The ID of the field configuration.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if the field configuration is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Delete field configuration';
      tags: ['Issue field configurations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:field-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Updates a field configuration. The name and the description provided in the request override the existing values.\n\nThis operation can only update configurations used in company-managed (classic) projects.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'updateFieldConfiguration';
      parameters: [
        {
          description: 'The ID of the field configuration.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              description: 'A brand new description';
              name: 'My Modified Field Configuration';
            };
            schema: {
              $ref: '#/components/schemas/FieldConfigurationDetails';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if the field configuration is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Update field configuration';
      tags: ['Issue field configurations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/fieldconfiguration/{id}/fields': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of all fields for a configuration.\n\nOnly the fields from configurations used in company-managed (classic) projects are returned.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getFieldConfigurationItems';
      parameters: [
        {
          description: 'The ID of the field configuration.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":50,"startAt":0,"total":2,"values":[{"description":"For example operating system, software platform and/or hardware specifications (include as appropriate for the issue).","id":"environment","isHidden":false,"isRequired":false},{"id":"description","isHidden":false,"isRequired":false}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanFieldConfigurationItem';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if the field configuration is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get field configuration items';
      tags: ['Issue field configurations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Updates fields in a field configuration. The properties of the field configuration fields provided override the existing values.\n\nThis operation can only update field configurations used in company-managed (classic) projects.\n\nThe operation can set the renderer for text fields to the default text renderer (`text-renderer`) or wiki style renderer (`wiki-renderer`). However, the renderer cannot be updated for fields using the autocomplete renderer (`autocomplete-renderer`).\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'updateFieldConfigurationItems';
      parameters: [
        {
          description: 'The ID of the field configuration.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              fieldConfigurationItems: [
                {
                  description: 'The new description of this item.';
                  id: 'customfield_10012';
                  isHidden: false;
                },
                {
                  id: 'customfield_10011';
                  isRequired: true;
                },
                {
                  description: 'Another new description.';
                  id: 'customfield_10010';
                  isHidden: false;
                  isRequired: false;
                  renderer: 'wiki-renderer';
                },
              ];
            };
            schema: {
              $ref: '#/components/schemas/FieldConfigurationItemsDetails';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if the field configuration is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Update field configuration items';
      tags: ['Issue field configurations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/fieldconfigurationscheme': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of field configuration schemes.\n\nOnly field configuration schemes used in classic projects are returned.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getAllFieldConfigurationSchemes';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The list of field configuration scheme IDs. To include multiple IDs, provide an ampersand-separated list. For example, `id=10000&id=10001`.';
          in: 'query';
          name: 'id';
          schema: {
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":10,"startAt":0,"total":3,"values":[{"id":"10000","name":"Field Configuration Scheme for Bugs","description":"This field configuration scheme is for bugs only."},{"id":"10001","name":"Field Configuration Scheme for software related projects","description":"We can use this one for software projects."},{"id":"10002","name":"Field Configuration Scheme for Epics","description":"Use this one for Epic issue type."}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanFieldConfigurationScheme';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permissions.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get all field configuration schemes';
      tags: ['Issue field configurations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field-configuration-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Creates a field configuration scheme.\n\nThis operation can only create field configuration schemes used in company-managed (classic) projects.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'createFieldConfigurationScheme';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              description: 'We can use this one for software projects.';
              name: 'Field Configuration Scheme for software related projects';
            };
            schema: {
              $ref: '#/components/schemas/UpdateFieldConfigurationSchemeDetails';
            };
          };
        };
        description: 'The details of the field configuration scheme.';
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              example: '{"description":"We can use this one for software projects.","id":"10002","name":"Field Configuration Scheme for software related projects"}';
              schema: {
                $ref: '#/components/schemas/FieldConfigurationScheme';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["A field configuration scheme is using this name."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access field configurations."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the necessary permissions.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Create field configuration scheme';
      tags: ['Issue field configurations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field-configuration-scheme:jira', 'read:field-configuration-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/fieldconfigurationscheme/mapping': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of field configuration issue type items.\n\nOnly items used in classic projects are returned.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getFieldConfigurationSchemeMappings';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The list of field configuration scheme IDs. To include multiple field configuration schemes separate IDs with ampersand: `fieldConfigurationSchemeId=10000&fieldConfigurationSchemeId=10001`.';
          in: 'query';
          name: 'fieldConfigurationSchemeId';
          schema: {
            items: {
              example: 10020;
              format: 'int64';
              type: 'integer';
            };
            maxItems: 50;
            minItems: 1;
            type: 'array';
            uniqueItems: true;
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":100,"startAt":0,"total":5,"values":[{"fieldConfigurationSchemeId":"10020","issueTypeId":"10000","fieldConfigurationId":"10010"},{"fieldConfigurationSchemeId":"10020","issueTypeId":"10001","fieldConfigurationId":"10010"},{"fieldConfigurationSchemeId":"10021","issueTypeId":"10002","fieldConfigurationId":"10000"},{"fieldConfigurationSchemeId":"10022","issueTypeId":"default","fieldConfigurationId":"10011"},{"fieldConfigurationSchemeId":"10023","issueTypeId":"default","fieldConfigurationId":"10000"}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanFieldConfigurationIssueTypeItem';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if no field configuration schemes are found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get field configuration issue type items';
      tags: ['Issue field configurations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field-configuration-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/fieldconfigurationscheme/project': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of field configuration schemes and, for each scheme, a list of the projects that use it.\n\nThe list is sorted by field configuration scheme ID. The first item contains the list of project IDs assigned to the default field configuration scheme.\n\nOnly field configuration schemes used in classic projects are returned.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getFieldConfigurationSchemeProjectMapping';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The list of project IDs. To include multiple projects, separate IDs with ampersand: `projectId=10000&projectId=10001`.';
          in: 'query';
          name: 'projectId';
          required: true;
          schema: {
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":50,"startAt":0,"total":5,"values":[{"projectIds":["10","11"]},{"fieldConfigurationScheme":{"id":"10002","name":"Field Configuration Scheme for software related projects","description":"We can use this one for software projects."},"projectIds":["12","13","14"]}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanFieldConfigurationSchemeProjects';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get field configuration schemes for projects';
      tags: ['Issue field configurations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field-configuration-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Assigns a field configuration scheme to a project. If the field configuration scheme ID is `null`, the operation assigns the default field configuration scheme.\n\nField configuration schemes can only be assigned to classic projects.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'assignFieldConfigurationSchemeToProject';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              fieldConfigurationSchemeId: '10000';
              projectId: '10000';
            };
            schema: {
              $ref: '#/components/schemas/FieldConfigurationSchemeProjectAssociation';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only classic projects can have field configuration schemes assigned."],"errors":{}}';
            };
          };
          description: 'Returned if the project is not a classic project.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access field configurations."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the necessary permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The project was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the project is missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Assign field configuration scheme to project';
      tags: ['Issue field configurations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field-configuration-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/fieldconfigurationscheme/{id}': {
    delete: {
      deprecated: false;
      description: 'Deletes a field configuration scheme.\n\nThis operation can only delete field configuration schemes used in company-managed (classic) projects.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'deleteFieldConfigurationScheme';
      parameters: [
        {
          description: 'The ID of the field configuration scheme.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if the field configuration scheme is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Delete field configuration scheme';
      tags: ['Issue field configurations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:field-configuration-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Updates a field configuration scheme.\n\nThis operation can only update field configuration schemes used in company-managed (classic) projects.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'updateFieldConfigurationScheme';
      parameters: [
        {
          description: 'The ID of the field configuration scheme.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              description: 'We can use this one for software projects.';
              name: 'Field Configuration Scheme for software related projects';
            };
            schema: {
              $ref: '#/components/schemas/UpdateFieldConfigurationSchemeDetails';
            };
          };
        };
        description: 'The details of the field configuration scheme.';
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["A field configuration scheme is using this name."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access field configurations."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the necessary permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The field configuration scheme was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the field configuration scheme is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Update field configuration scheme';
      tags: ['Issue field configurations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field-configuration-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/fieldconfigurationscheme/{id}/mapping': {
    put: {
      deprecated: false;
      description: 'Assigns issue types to field configurations on field configuration scheme.\n\nThis operation can only modify field configuration schemes used in company-managed (classic) projects.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'setFieldConfigurationSchemeMapping';
      parameters: [
        {
          description: 'The ID of the field configuration scheme.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              mappings: [
                {
                  fieldConfigurationId: '10000';
                  issueTypeId: 'default';
                },
                {
                  fieldConfigurationId: '10002';
                  issueTypeId: '10001';
                },
                {
                  fieldConfigurationId: '10001';
                  issueTypeId: '10002';
                },
              ];
            };
            schema: {
              $ref: '#/components/schemas/AssociateFieldConfigurationsWithIssueTypesRequest';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if the field configuration scheme, the field configuration, or the issue type is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Assign issue types to field configurations';
      tags: ['Issue field configurations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field-configuration-scheme:jira', 'read:field-configuration-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/fieldconfigurationscheme/{id}/mapping/delete': {
    post: {
      deprecated: false;
      description: 'Removes issue types from the field configuration scheme.\n\nThis operation can only modify field configuration schemes used in company-managed (classic) projects.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'removeIssueTypesFromGlobalFieldConfigurationScheme';
      parameters: [
        {
          description: 'The ID of the field configuration scheme.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              issueTypeIds: ['10000', '10001', '10002'];
            };
            schema: {
              $ref: '#/components/schemas/IssueTypeIdsToRemove';
            };
          };
        };
        description: 'The issue type IDs to remove.';
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The issueTypeIds must not contain duplicates."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access field configurations."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The field configuration scheme was not found."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the field configuration scheme or the issue types are not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Remove issue types from field configuration scheme';
      tags: ['Issue field configurations'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:field-configuration-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/filter': {
    post: {
      deprecated: false;
      description: 'Creates a filter. The filter is shared according to the [default share scope](#api-rest-api-3-filter-post). The filter is not selected as a favorite.\n\n**[Permissions](#permissions) required:** Permission to access Jira.';
      operationId: 'createFilter';
      parameters: [
        {
          description: "Use [expand](#expansion) to include additional information about filter in the response. This parameter accepts a comma-separated list. Expand options include:\n\n *  `sharedUsers` Returns the users that the filter is shared with. This includes users that can browse projects that the filter is shared with. If you don't specify `sharedUsers`, then the `sharedUsers` object is returned but it doesn't list any users. The list of users returned is limited to 1000, to access additional users append `[start-index:end-index]` to the expand request. For example, to access the next 1000 users, use `?expand=sharedUsers[1001:2000]`.\n *  `subscriptions` Returns the users that are subscribed to the filter. If you don't specify `subscriptions`, the `subscriptions` object is returned but it doesn't list any subscriptions. The list of subscriptions returned is limited to 1000, to access additional subscriptions append `[start-index:end-index]` to the expand request. For example, to access the next 1000 subscriptions, use `?expand=subscriptions[1001:2000]`.";
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'EXPERIMENTAL: Whether share permissions are overridden to enable filters with any share permissions to be created. Available to users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
          in: 'query';
          name: 'overrideSharePermissions';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              description: 'Lists all open bugs';
              jql: 'type = Bug and resolution is empty';
              name: 'All Open Bugs';
            };
            schema: {
              $ref: '#/components/schemas/Filter';
            };
          };
        };
        description: 'The filter to create.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"approximateLastUsed":null,"description":"Lists all open bugs","favourite":true,"favouritedCount":0,"id":"10000","jql":"type = Bug and resolution is empty","name":"All Open Bugs","owner":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"searchUrl":"https://your-domain.atlassian.net/rest/api/3/search?jql=type%20%3D%20Bug%20and%20resolutino%20is%20empty","self":"https://your-domain.atlassian.net/rest/api/3/filter/10000","sharePermissions":[],"subscriptions":{"end-index":0,"items":[],"max-results":0,"size":0,"start-index":0},"viewUrl":"https://your-domain.atlassian.net/issues/?filter=10000"}';
              schema: {
                $ref: '#/components/schemas/Filter';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request object is invalid. For example, the `name` is not unique or the project ID is not specified for a project role share permission.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Create filter';
      tags: ['Filters'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:filter:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'write:filter:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:issue-type-hierarchy:jira',
            'read:issue-type:jira',
            'read:project-category:jira',
            'read:project-version:jira',
            'read:project.component:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/filter/defaultShareScope': {
    get: {
      deprecated: false;
      description: 'Returns the default sharing settings for new filters and dashboards for a user.\n\n**[Permissions](#permissions) required:** Permission to access Jira.';
      operationId: 'getDefaultShareScope';
      parameters: [];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"scope":"GLOBAL"}';
              schema: {
                $ref: '#/components/schemas/DefaultShareScope';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get default share scope';
      tags: ['Filter sharing'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:filter.default-share-scope:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Sets the default sharing for new filters and dashboards for a user.\n\n**[Permissions](#permissions) required:** Permission to access Jira.';
      operationId: 'setDefaultShareScope';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              scope: 'GLOBAL';
            };
            schema: {
              $ref: '#/components/schemas/DefaultShareScope';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"scope":"GLOBAL"}';
              schema: {
                $ref: '#/components/schemas/DefaultShareScope';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if an invalid scope is set.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Set default share scope';
      tags: ['Filter sharing'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:filter.default-share-scope:jira', 'read:filter.default-share-scope:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/filter/favourite': {
    get: {
      deprecated: false;
      description: 'Returns the visible favorite filters of the user.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** A favorite filter is only visible to the user where the filter is:\n\n *  owned by the user.\n *  shared with a group that the user is a member of.\n *  shared with a private project that the user has *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for.\n *  shared with a public project.\n *  shared with the public.\n\nFor example, if the user favorites a public filter that is subsequently made private that filter is not returned by this operation.';
      operationId: 'getFavouriteFilters';
      parameters: [
        {
          description: "Use [expand](#expansion) to include additional information about filter in the response. This parameter accepts a comma-separated list. Expand options include:\n\n *  `sharedUsers` Returns the users that the filter is shared with. This includes users that can browse projects that the filter is shared with. If you don't specify `sharedUsers`, then the `sharedUsers` object is returned but it doesn't list any users. The list of users returned is limited to 1000, to access additional users append `[start-index:end-index]` to the expand request. For example, to access the next 1000 users, use `?expand=sharedUsers[1001:2000]`.\n *  `subscriptions` Returns the users that are subscribed to the filter. If you don't specify `subscriptions`, the `subscriptions` object is returned but it doesn't list any subscriptions. The list of subscriptions returned is limited to 1000, to access additional subscriptions append `[start-index:end-index]` to the expand request. For example, to access the next 1000 subscriptions, use `?expand=subscriptions[1001:2000]`.";
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '[{"approximateLastUsed":"2023-03-01T13:15:00.000+0000","description":"Lists all open bugs","favourite":true,"favouritedCount":0,"id":"10000","jql":"type = Bug and resolution is empty","name":"All Open Bugs","owner":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"searchUrl":"https://your-domain.atlassian.net/rest/api/3/search?jql=type%20%3D%20Bug%20and%20resolutino%20is%20empty","self":"https://your-domain.atlassian.net/rest/api/3/filter/10000","sharePermissions":[],"subscriptions":{"end-index":0,"items":[],"max-results":0,"size":0,"start-index":0},"viewUrl":"https://your-domain.atlassian.net/issues/?filter=10000"},{"approximateLastUsed":null,"description":"Issues assigned to me","favourite":true,"favouritedCount":0,"id":"10010","jql":"assignee = currentUser() and resolution is empty","name":"My issues","owner":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"searchUrl":"https://your-domain.atlassian.net/rest/api/3/search?jql=assignee+in+%28currentUser%28%29%29+and+resolution+is+empty","self":"https://your-domain.atlassian.net/rest/api/3/filter/10010","sharePermissions":[{"id":10000,"type":"global"},{"id":10010,"project":{"avatarUrls":{"16x16":"https://your-domain.atlassian.net/secure/projectavatar?size=xsmall&pid=10000","24x24":"https://your-domain.atlassian.net/secure/projectavatar?size=small&pid=10000","32x32":"https://your-domain.atlassian.net/secure/projectavatar?size=medium&pid=10000","48x48":"https://your-domain.atlassian.net/secure/projectavatar?size=large&pid=10000"},"id":"10000","insight":{"lastIssueUpdateTime":"2021-04-22T05:37:05.000+0000","totalIssueCount":100},"key":"EX","name":"Example","projectCategory":{"description":"First Project Category","id":"10000","name":"FIRST","self":"https://your-domain.atlassian.net/rest/api/3/projectCategory/10000"},"self":"https://your-domain.atlassian.net/rest/api/3/project/EX","simplified":false,"style":"classic"},"type":"project"}],"subscriptions":{"end-index":0,"items":[],"max-results":0,"size":0,"start-index":0},"viewUrl":"https://your-domain.atlassian.net/issues/?filter=10010"}]';
              schema: {
                items: {
                  $ref: '#/components/schemas/Filter';
                };
                type: 'array';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get favorite filters';
      tags: ['Filters'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:filter:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'read:jql:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:issue-type-hierarchy:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/filter/my': {
    get: {
      deprecated: false;
      description: "Returns the filters owned by the user. If `includeFavourites` is `true`, the user's visible favorite filters are also returned.\n\n**[Permissions](#permissions) required:** Permission to access Jira, however, a favorite filters is only visible to the user where the filter is:\n\n *  owned by the user.\n *  shared with a group that the user is a member of.\n *  shared with a private project that the user has *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for.\n *  shared with a public project.\n *  shared with the public.\n\nFor example, if the user favorites a public filter that is subsequently made private that filter is not returned by this operation.";
      operationId: 'getMyFilters';
      parameters: [
        {
          description: "Use [expand](#expansion) to include additional information about filter in the response. This parameter accepts a comma-separated list. Expand options include:\n\n *  `sharedUsers` Returns the users that the filter is shared with. This includes users that can browse projects that the filter is shared with. If you don't specify `sharedUsers`, then the `sharedUsers` object is returned but it doesn't list any users. The list of users returned is limited to 1000, to access additional users append `[start-index:end-index]` to the expand request. For example, to access the next 1000 users, use `?expand=sharedUsers[1001:2000]`.\n *  `subscriptions` Returns the users that are subscribed to the filter. If you don't specify `subscriptions`, the `subscriptions` object is returned but it doesn't list any subscriptions. The list of subscriptions returned is limited to 1000, to access additional subscriptions append `[start-index:end-index]` to the expand request. For example, to access the next 1000 subscriptions, use `?expand=subscriptions[1001:2000]`.";
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
        {
          description: "Include the user's favorite filters in the response.";
          in: 'query';
          name: 'includeFavourites';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '[{"approximateLastUsed":"2023-03-01T13:15:00.000+0000","description":"Lists all open bugs","favourite":true,"favouritedCount":0,"id":"10000","jql":"type = Bug and resolution is empty","name":"All Open Bugs","owner":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"searchUrl":"https://your-domain.atlassian.net/rest/api/3/search?jql=type%20%3D%20Bug%20and%20resolutino%20is%20empty","self":"https://your-domain.atlassian.net/rest/api/3/filter/10000","sharePermissions":[],"subscriptions":{"end-index":0,"items":[],"max-results":0,"size":0,"start-index":0},"viewUrl":"https://your-domain.atlassian.net/issues/?filter=10000"},{"approximateLastUsed":null,"description":"Issues assigned to me","favourite":true,"favouritedCount":0,"id":"10010","jql":"assignee = currentUser() and resolution is empty","name":"My issues","owner":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"searchUrl":"https://your-domain.atlassian.net/rest/api/3/search?jql=assignee+in+%28currentUser%28%29%29+and+resolution+is+empty","self":"https://your-domain.atlassian.net/rest/api/3/filter/10010","sharePermissions":[{"id":10000,"type":"global"},{"id":10010,"project":{"avatarUrls":{"16x16":"https://your-domain.atlassian.net/secure/projectavatar?size=xsmall&pid=10000","24x24":"https://your-domain.atlassian.net/secure/projectavatar?size=small&pid=10000","32x32":"https://your-domain.atlassian.net/secure/projectavatar?size=medium&pid=10000","48x48":"https://your-domain.atlassian.net/secure/projectavatar?size=large&pid=10000"},"id":"10000","insight":{"lastIssueUpdateTime":"2021-04-22T05:37:05.000+0000","totalIssueCount":100},"key":"EX","name":"Example","projectCategory":{"description":"First Project Category","id":"10000","name":"FIRST","self":"https://your-domain.atlassian.net/rest/api/3/projectCategory/10000"},"self":"https://your-domain.atlassian.net/rest/api/3/project/EX","simplified":false,"style":"classic"},"type":"project"}],"subscriptions":{"end-index":0,"items":[],"max-results":0,"size":0,"start-index":0},"viewUrl":"https://your-domain.atlassian.net/issues/?filter=10010"}]';
              schema: {
                items: {
                  $ref: '#/components/schemas/Filter';
                };
                type: 'array';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get my filters';
      tags: ['Filters'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:filter:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'read:jql:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:issue-type-hierarchy:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/filter/search': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of filters. Use this operation to get:\n\n *  specific filters, by defining `id` only.\n *  filters that match all of the specified attributes. For example, all filters for a user with a particular word in their name. When multiple attributes are specified only filters matching all attributes are returned.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** None, however, only the following filters that match the query parameters are returned:\n\n *  filters owned by the user.\n *  filters shared with a group that the user is a member of.\n *  filters shared with a private project that the user has *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for.\n *  filters shared with a public project.\n *  filters shared with the public.';
      operationId: 'getFiltersPaginated';
      parameters: [
        {
          description: 'String used to perform a case-insensitive partial match with `name`.';
          in: 'query';
          name: 'filterName';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'User account ID used to return filters with the matching `owner.accountId`. This parameter cannot be used with `owner`.';
          in: 'query';
          name: 'accountId';
          schema: {
            maxLength: 128;
            minLength: 0;
            type: 'string';
          };
        },
        {
          description: 'This parameter is deprecated because of privacy changes. Use `accountId` instead. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details. User name used to return filters with the matching `owner.name`. This parameter cannot be used with `accountId`.';
          in: 'query';
          name: 'owner';
          schema: {
            type: 'string';
          };
        },
        {
          description: "As a group's name can change, use of `groupId` is recommended to identify a group. Group name used to returns filters that are shared with a group that matches `sharePermissions.group.groupname`. This parameter cannot be used with the `groupId` parameter.";
          in: 'query';
          name: 'groupname';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Group ID used to returns filters that are shared with a group that matches `sharePermissions.group.groupId`. This parameter cannot be used with the `groupname` parameter.';
          in: 'query';
          name: 'groupId';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Project ID used to returns filters that are shared with a project that matches `sharePermissions.project.id`.';
          in: 'query';
          name: 'projectId';
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The list of filter IDs. To include multiple IDs, provide an ampersand-separated list. For example, `id=10000&id=10001`. Do not exceed 200 filter IDs.';
          in: 'query';
          name: 'id';
          schema: {
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: '[Order](#ordering) the results by a field:\n\n *  `description` Sorts by filter description. Note that this sorting works independently of whether the expand to display the description field is in use.\n *  `favourite_count` Sorts by the count of how many users have this filter as a favorite.\n *  `is_favourite` Sorts by whether the filter is marked as a favorite.\n *  `id` Sorts by filter ID.\n *  `name` Sorts by filter name.\n *  `owner` Sorts by the ID of the filter owner.\n *  `is_shared` Sorts by whether the filter is shared.';
          in: 'query';
          name: 'orderBy';
          schema: {
            default: 'name';
            enum: [
              'description',
              '-description',
              '+description',
              'favourite_count',
              '-favourite_count',
              '+favourite_count',
              'id',
              '-id',
              '+id',
              'is_favourite',
              '-is_favourite',
              '+is_favourite',
              'name',
              '-name',
              '+name',
              'owner',
              '-owner',
              '+owner',
              'is_shared',
              '-is_shared',
              '+is_shared',
            ];
            type: 'string';
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: "Use [expand](#expansion) to include additional information about filter in the response. This parameter accepts a comma-separated list. Expand options include:\n\n *  `description` Returns the description of the filter.\n *  `favourite` Returns an indicator of whether the user has set the filter as a favorite.\n *  `favouritedCount` Returns a count of how many users have set this filter as a favorite.\n *  `jql` Returns the JQL query that the filter uses.\n *  `owner` Returns the owner of the filter.\n *  `searchUrl` Returns a URL to perform the filter's JQL query.\n *  `sharePermissions` Returns the share permissions defined for the filter.\n *  `editPermissions` Returns the edit permissions defined for the filter.\n *  `isWritable` Returns whether the current user has permission to edit the filter.\n *  `approximateLastUsed` \\[Experimental\\] Returns the approximate date and time when the filter was last evaluated.\n *  `subscriptions` Returns the users that are subscribed to the filter.\n *  `viewUrl` Returns a URL to view the filter.";
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'EXPERIMENTAL: Whether share permissions are overridden to enable filters with any share permissions to be returned. Available to users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
          in: 'query';
          name: 'overrideSharePermissions';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":100,"self":"https://your-domain.atlassian.net/rest/api/3/filter/search?accountId=&maxResults=50&filterName=&orderBy=name&startAt=0&expand=description,owner,jql,searchUrl,viewUrl,favourite,favouritedCount,sharePermissions,editPermissions,isWritable,subscriptions,approximateLastUsed","startAt":0,"total":2,"values":[{"approximateLastUsed":"2023-03-01T13:15:00.000+0000","description":"Lists all open bugs","editPermissions":[],"expand":"description,owner,jql,searchUrl,viewUrl,favourite,favouritedCount,sharePermissions,editPermissions,isWritable,approximateLastUsed,subscriptions","favourite":false,"favouritedCount":0,"id":"10000","jql":"type = Bug and resolution is empty","name":"All Open Bugs","owner":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"searchUrl":"https://your-domain.atlassian.net/rest/api/3/search?jql=type%20%3D%20Bug%20and%20resolutino%20is%20empty","self":"https://your-domain.atlassian.net/rest/api/3/filter/10000","sharePermissions":[],"subscriptions":[],"viewUrl":"https://your-domain.atlassian.net/issues/?filter=10000"},{"approximateLastUsed":null,"description":"Issues assigned to me","editPermissions":[{"id":10010,"project":{"avatarUrls":{"16x16":"https://your-domain.atlassian.net/secure/projectavatar?size=xsmall&pid=10002","24x24":"https://your-domain.atlassian.net/secure/projectavatar?size=small&pid=10002","32x32":"https://your-domain.atlassian.net/secure/projectavatar?size=medium&pid=10002","48x48":"https://your-domain.atlassian.net/secure/projectavatar?size=large&pid=10002"},"deleted":true,"deletedBy":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"deletedDate":"2022-11-11T13:35:29.000+0000","id":"10002","insight":{"lastIssueUpdateTime":"2021-04-22T05:37:05.000+0000","totalIssueCount":100},"key":"MKY","name":"Example","projectCategory":{"description":"First Project Category","id":"10000","name":"FIRST","self":"https://your-domain.atlassian.net/rest/api/3/projectCategory/10000"},"retentionTillDate":"2023-01-10T13:35:29.000+0000","self":"https://your-domain.atlassian.net/rest/api/3/project/MKY","simplified":false,"style":"classic"},"role":{"self":"https://your-domain.atlassian.net/rest/api/3/project/MKY/role/10360","name":"Developers","id":10360,"description":"A project role that represents developers in a project","actors":[{"actorGroup":{"name":"jira-developers","displayName":"jira-developers","groupId":"952d12c3-5b5b-4d04-bb32-44d383afc4b2"},"displayName":"jira-developers","id":10240,"name":"jira-developers","type":"atlassian-group-role-actor"},{"actorUser":{"accountId":"5b10a2844c20165700ede21g"},"displayName":"Mia Krystof","id":10241,"type":"atlassian-user-role-actor"}],"scope":{"project":{"id":"10000","key":"KEY","name":"Next Gen Project"},"type":"PROJECT"}},"type":"project"},{"group":{"groupId":"276f955c-63d7-42c8-9520-92d01dca0625","name":"jira-administrators","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=276f955c-63d7-42c8-9520-92d01dca0625"},"id":10010,"type":"group"}],"expand":"description,owner,jql,searchUrl,viewUrl,favourite,favouritedCount,sharePermissions,editPermissions,isWritable,approximateLastUsed,subscriptions","favourite":true,"favouritedCount":123,"id":"10010","jql":"assignee = currentUser() and resolution is empty","name":"My issues","owner":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"searchUrl":"https://your-domain.atlassian.net/rest/api/3/search?jql=assignee+in+%28currentUser%28%29%29+and+resolution+is+empty","self":"https://your-domain.atlassian.net/rest/api/3/filter/10010","sharePermissions":[{"id":10000,"type":"global"},{"id":10010,"project":{"avatarUrls":{"16x16":"https://your-domain.atlassian.net/secure/projectavatar?size=xsmall&pid=10000","24x24":"https://your-domain.atlassian.net/secure/projectavatar?size=small&pid=10000","32x32":"https://your-domain.atlassian.net/secure/projectavatar?size=medium&pid=10000","48x48":"https://your-domain.atlassian.net/secure/projectavatar?size=large&pid=10000"},"id":"10000","insight":{"lastIssueUpdateTime":"2021-04-22T05:37:05.000+0000","totalIssueCount":100},"key":"EX","name":"Example","projectCategory":{"description":"First Project Category","id":"10000","name":"FIRST","self":"https://your-domain.atlassian.net/rest/api/3/projectCategory/10000"},"self":"https://your-domain.atlassian.net/rest/api/3/project/EX","simplified":false,"style":"classic"},"type":"project"}],"subscriptions":[{"id":1,"user":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":true,"applicationRoles":{"items":[],"size":1},"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","emailAddress":"mia@example.com","groups":{"items":[],"size":3},"key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g","timeZone":"Australia/Sydney"}}],"viewUrl":"https://your-domain.atlassian.net/issues/?filter=10010"}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanFilterDetails';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if:\n\n *  `owner` and `accountId` are provided.\n *  `expand` includes an invalid value.\n *  `orderBy` is invalid.\n *  `id` identifies more than 200 filter IDs.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Search for filters';
      tags: ['Filters'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:filter:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'read:jql:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:issue-type-hierarchy:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/filter/{id}': {
    delete: {
      deprecated: false;
      description: 'Delete a filter.\n\n**[Permissions](#permissions) required:** Permission to access Jira, however filters can only be deleted by the creator of the filter or a user with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'deleteFilter';
      parameters: [
        {
          description: 'The ID of the filter to delete.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the filter is not found.';
        };
        '401': {
          description: 'Returned if the user does not have permission to delete the filter.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Delete filter';
      tags: ['Filters'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:filter:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: 'Returns a filter.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** None, however, the filter is only returned where it is:\n\n *  owned by the user.\n *  shared with a group that the user is a member of.\n *  shared with a private project that the user has *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for.\n *  shared with a public project.\n *  shared with the public.';
      operationId: 'getFilter';
      parameters: [
        {
          description: 'The ID of the filter to return.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: "Use [expand](#expansion) to include additional information about filter in the response. This parameter accepts a comma-separated list. Expand options include:\n\n *  `sharedUsers` Returns the users that the filter is shared with. This includes users that can browse projects that the filter is shared with. If you don't specify `sharedUsers`, then the `sharedUsers` object is returned but it doesn't list any users. The list of users returned is limited to 1000, to access additional users append `[start-index:end-index]` to the expand request. For example, to access the next 1000 users, use `?expand=sharedUsers[1001:2000]`.\n *  `subscriptions` Returns the users that are subscribed to the filter. If you don't specify `subscriptions`, the `subscriptions` object is returned but it doesn't list any subscriptions. The list of subscriptions returned is limited to 1000, to access additional subscriptions append `[start-index:end-index]` to the expand request. For example, to access the next 1000 subscriptions, use `?expand=subscriptions[1001:2000]`.";
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'EXPERIMENTAL: Whether share permissions are overridden to enable filters with any share permissions to be returned. Available to users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
          in: 'query';
          name: 'overrideSharePermissions';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"approximateLastUsed":"2023-03-01T13:15:00.000+0000","description":"Lists all open bugs","favourite":true,"favouritedCount":0,"id":"10000","jql":"type = Bug and resolution is empty","name":"All Open Bugs","owner":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"searchUrl":"https://your-domain.atlassian.net/rest/api/3/search?jql=type%20%3D%20Bug%20and%20resolutino%20is%20empty","self":"https://your-domain.atlassian.net/rest/api/3/filter/10000","sharePermissions":[],"subscriptions":{"end-index":0,"items":[],"max-results":0,"size":0,"start-index":0},"viewUrl":"https://your-domain.atlassian.net/issues/?filter=10000"}';
              schema: {
                $ref: '#/components/schemas/Filter';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the filter is not found or the user does not have permission to view it.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get filter';
      tags: ['Filters'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:filter:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'read:jql:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:issue-type-hierarchy:jira',
          ];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: "Updates a filter. Use this operation to update a filter's name, description, JQL, or sharing.\n\n**[Permissions](#permissions) required:** Permission to access Jira, however the user must own the filter.";
      operationId: 'updateFilter';
      parameters: [
        {
          description: 'The ID of the filter to update.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: "Use [expand](#expansion) to include additional information about filter in the response. This parameter accepts a comma-separated list. Expand options include:\n\n *  `sharedUsers` Returns the users that the filter is shared with. This includes users that can browse projects that the filter is shared with. If you don't specify `sharedUsers`, then the `sharedUsers` object is returned but it doesn't list any users. The list of users returned is limited to 1000, to access additional users append `[start-index:end-index]` to the expand request. For example, to access the next 1000 users, use `?expand=sharedUsers[1001:2000]`.\n *  `subscriptions` Returns the users that are subscribed to the filter. If you don't specify `subscriptions`, the `subscriptions` object is returned but it doesn't list any subscriptions. The list of subscriptions returned is limited to 1000, to access additional subscriptions append `[start-index:end-index]` to the expand request. For example, to access the next 1000 subscriptions, use `?expand=subscriptions[1001:2000]`.";
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'EXPERIMENTAL: Whether share permissions are overridden to enable the addition of any share permissions to filters. Available to users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
          in: 'query';
          name: 'overrideSharePermissions';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              description: 'Lists all open bugs';
              jql: 'type = Bug and resolution is empty';
              name: 'All Open Bugs';
            };
            schema: {
              $ref: '#/components/schemas/Filter';
            };
          };
        };
        description: 'The filter to update.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"approximateLastUsed":"2023-03-01T13:15:00.000+0000","description":"Lists all open bugs","favourite":true,"favouritedCount":0,"id":"10000","jql":"type = Bug and resolution is empty","name":"All Open Bugs","owner":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"searchUrl":"https://your-domain.atlassian.net/rest/api/3/search?jql=type%20%3D%20Bug%20and%20resolutino%20is%20empty","self":"https://your-domain.atlassian.net/rest/api/3/filter/10000","sharePermissions":[],"subscriptions":{"end-index":0,"items":[],"max-results":0,"size":0,"start-index":0},"viewUrl":"https://your-domain.atlassian.net/issues/?filter=10000"}';
              schema: {
                $ref: '#/components/schemas/Filter';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request object is invalid. For example, the `name` is not unique or the project ID is not specified for a project role share permission.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Update filter';
      tags: ['Filters'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'write:filter:jira',
            'read:filter:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'read:jql:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:issue-type-hierarchy:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/filter/{id}/columns': {
    delete: {
      deprecated: false;
      description: "Reset the user's column configuration for the filter to the default.\n\n**[Permissions](#permissions) required:** Permission to access Jira, however, columns are only reset for:\n\n *  filters owned by the user.\n *  filters shared with a group that the user is a member of.\n *  filters shared with a private project that the user has *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for.\n *  filters shared with a public project.\n *  filters shared with the public.";
      operationId: 'resetColumns';
      parameters: [
        {
          description: 'The ID of the filter.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if:\n\n *  the filter is not found.\n *  the user does not have permission to view the filter.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Reset columns';
      tags: ['Filters'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['delete:filter.column:jira'];
          state: 'Beta';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
      ];
    };
    get: {
      deprecated: false;
      description: "Returns the columns configured for a filter. The column configuration is used when the filter's results are viewed in *List View* with the *Columns* set to *Filter*.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** None, however, column details are only returned for:\n\n *  filters owned by the user.\n *  filters shared with a group that the user is a member of.\n *  filters shared with a private project that the user has *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for.\n *  filters shared with a public project.\n *  filters shared with the public.";
      operationId: 'getColumns';
      parameters: [
        {
          description: 'The ID of the filter.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '[{"label":"Key","value":"issuekey"},{"label":"Summary","value":"summary"}]';
              schema: {
                items: {
                  $ref: '#/components/schemas/ColumnItem';
                };
                type: 'array';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the user does not have permission to view the filter.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if a column configuration is not set for the filter.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get columns';
      tags: ['Filters'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:filter.column:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Sets the columns for a filter. Only navigable fields can be set as columns. Use [Get fields](#api-rest-api-3-field-get) to get the list fields in Jira. A navigable field has `navigable` set to `true`.\n\nThe parameters for this resource are expressed as HTML form data. For example, in curl:\n\n`curl -X PUT -d columns=summary -d columns=description https://your-domain.atlassian.net/rest/api/3/filter/10000/columns`\n\n**[Permissions](#permissions) required:** Permission to access Jira, however, columns are only set for:\n\n *  filters owned by the user.\n *  filters shared with a group that the user is a member of.\n *  filters shared with a private project that the user has *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for.\n *  filters shared with a public project.\n *  filters shared with the public.';
      operationId: 'setColumns';
      parameters: [
        {
          description: 'The ID of the filter.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          '*/*': {
            schema: {
              $ref: '#/components/schemas/ColumnRequestBody';
            };
          };
          'application/json': {
            schema: {
              $ref: '#/components/schemas/ColumnRequestBody';
            };
          };
          'multipart/form-data': {
            schema: {
              $ref: '#/components/schemas/ColumnRequestBody';
            };
          };
        };
        description: 'The IDs of the fields to set as columns. In the form data, specify each field as `columns=id`, where `id` is the *id* of a field (as seen in the response for [Get fields](#api-rest-api-<ver>-field-get)). For example, `columns=summary`.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if:\n\n *  a non-navigable field is set as a column.\n *  the user does not have permission to view the filter.';
        };
        '403': {
          description: 'Returned if the requesting user is not an owner of the filter.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Set columns';
      tags: ['Filters'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:filter.column:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/filter/{id}/favourite': {
    delete: {
      deprecated: false;
      description: "Removes a filter as a favorite for the user. Note that this operation only removes filters visible to the user from the user's favorites list. For example, if the user favorites a public filter that is subsequently made private (and is therefore no longer visible on their favorites list) they cannot remove it from their favorites list.\n\n**[Permissions](#permissions) required:** Permission to access Jira.";
      operationId: 'deleteFavouriteForFilter';
      parameters: [
        {
          description: 'The ID of the filter.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: "Use [expand](#expansion) to include additional information about filter in the response. This parameter accepts a comma-separated list. Expand options include:\n\n *  `sharedUsers` Returns the users that the filter is shared with. This includes users that can browse projects that the filter is shared with. If you don't specify `sharedUsers`, then the `sharedUsers` object is returned but it doesn't list any users. The list of users returned is limited to 1000, to access additional users append `[start-index:end-index]` to the expand request. For example, to access the next 1000 users, use `?expand=sharedUsers[1001:2000]`.\n *  `subscriptions` Returns the users that are subscribed to the filter. If you don't specify `subscriptions`, the `subscriptions` object is returned but it doesn't list any subscriptions. The list of subscriptions returned is limited to 1000, to access additional subscriptions append `[start-index:end-index]` to the expand request. For example, to access the next 1000 subscriptions, use `?expand=subscriptions[1001:2000]`.";
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"approximateLastUsed":"2023-03-01T13:15:00.000+0000","description":"Lists all open bugs","favourite":true,"favouritedCount":0,"id":"10000","jql":"type = Bug and resolution is empty","name":"All Open Bugs","owner":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"searchUrl":"https://your-domain.atlassian.net/rest/api/3/search?jql=type%20%3D%20Bug%20and%20resolutino%20is%20empty","self":"https://your-domain.atlassian.net/rest/api/3/filter/10000","sharePermissions":[],"subscriptions":{"end-index":0,"items":[],"max-results":0,"size":0,"start-index":0},"viewUrl":"https://your-domain.atlassian.net/issues/?filter=10000"}';
              schema: {
                $ref: '#/components/schemas/Filter';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if:\n\n *  the filter is not found.\n *  the user does not have permission to view the filter.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Remove filter as favorite';
      tags: ['Filters'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'write:filter:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:filter:jira',
            'read:group:jira',
            'read:issue-type-hierarchy:jira',
            'read:issue-type:jira',
            'read:project-category:jira',
            'read:project-role:jira',
            'read:project-version:jira',
            'read:project.component:jira',
            'read:project:jira',
            'read:user:jira',
          ];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Add a filter as a favorite for the user.\n\n**[Permissions](#permissions) required:** Permission to access Jira, however, the user can only favorite:\n\n *  filters owned by the user.\n *  filters shared with a group that the user is a member of.\n *  filters shared with a private project that the user has *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for.\n *  filters shared with a public project.\n *  filters shared with the public.';
      operationId: 'setFavouriteForFilter';
      parameters: [
        {
          description: 'The ID of the filter.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: "Use [expand](#expansion) to include additional information about filter in the response. This parameter accepts a comma-separated list. Expand options include:\n\n *  `sharedUsers` Returns the users that the filter is shared with. This includes users that can browse projects that the filter is shared with. If you don't specify `sharedUsers`, then the `sharedUsers` object is returned but it doesn't list any users. The list of users returned is limited to 1000, to access additional users append `[start-index:end-index]` to the expand request. For example, to access the next 1000 users, use `?expand=sharedUsers[1001:2000]`.\n *  `subscriptions` Returns the users that are subscribed to the filter. If you don't specify `subscriptions`, the `subscriptions` object is returned but it doesn't list any subscriptions. The list of subscriptions returned is limited to 1000, to access additional subscriptions append `[start-index:end-index]` to the expand request. For example, to access the next 1000 subscriptions, use `?expand=subscriptions[1001:2000]`.";
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"approximateLastUsed":"2023-03-01T13:15:00.000+0000","description":"Lists all open bugs","favourite":true,"favouritedCount":0,"id":"10000","jql":"type = Bug and resolution is empty","name":"All Open Bugs","owner":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"searchUrl":"https://your-domain.atlassian.net/rest/api/3/search?jql=type%20%3D%20Bug%20and%20resolutino%20is%20empty","self":"https://your-domain.atlassian.net/rest/api/3/filter/10000","sharePermissions":[],"subscriptions":{"end-index":0,"items":[],"max-results":0,"size":0,"start-index":0},"viewUrl":"https://your-domain.atlassian.net/issues/?filter=10000"}';
              schema: {
                $ref: '#/components/schemas/Filter';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if:\n\n *  the filter is not found.\n *  the user does not have permission to favorite the filter.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Add filter as favorite';
      tags: ['Filters'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:filter:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'write:filter:jira',
            'read:jql:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:issue-type-hierarchy:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/filter/{id}/owner': {
    put: {
      deprecated: false;
      description: 'Changes the owner of the filter.\n\n**[Permissions](#permissions) required:** Permission to access Jira. However, the user must own the filter or have the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'changeFilterOwner';
      parameters: [
        {
          description: 'The ID of the filter to update.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              accountId: '0000-0000-0000-0000';
            };
            schema: {
              $ref: '#/components/schemas/ChangeFilterOwner';
            };
          };
        };
        description: 'The account ID of the new owner of the filter.';
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned when:\n\n *  The new owner of the filter owns a filter with the same name.\n *  An attempt is made to change owner of the default filter.';
        };
        '403': {
          description: 'Returned if the requesting user is not an owner of the filter or does not have *Administer Jira* global permission.';
        };
        '404': {
          description: 'Returned if the filter or the new owner of the filter is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Change filter owner';
      tags: ['Filters'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:filter:jira', 'write:filter:jira'];
          state: 'Beta';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/filter/{id}/permission': {
    get: {
      deprecated: false;
      description: 'Returns the share permissions for a filter. A filter can be shared with groups, projects, all logged-in users, or the public. Sharing with all logged-in users or the public is known as a global share permission.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** None, however, share permissions are only returned for:\n\n *  filters owned by the user.\n *  filters shared with a group that the user is a member of.\n *  filters shared with a private project that the user has *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for.\n *  filters shared with a public project.\n *  filters shared with the public.';
      operationId: 'getSharePermissions';
      parameters: [
        {
          description: 'The ID of the filter.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '[{"id":10000,"type":"global"},{"id":10010,"project":{"avatarUrls":{"16x16":"https://your-domain.atlassian.net/secure/projectavatar?size=xsmall&pid=10000","24x24":"https://your-domain.atlassian.net/secure/projectavatar?size=small&pid=10000","32x32":"https://your-domain.atlassian.net/secure/projectavatar?size=medium&pid=10000","48x48":"https://your-domain.atlassian.net/secure/projectavatar?size=large&pid=10000"},"id":"10000","insight":{"lastIssueUpdateTime":"2021-04-22T05:37:05.000+0000","totalIssueCount":100},"key":"EX","name":"Example","projectCategory":{"description":"First Project Category","id":"10000","name":"FIRST","self":"https://your-domain.atlassian.net/rest/api/3/projectCategory/10000"},"self":"https://your-domain.atlassian.net/rest/api/3/project/EX","simplified":false,"style":"classic"},"type":"project"},{"id":10010,"project":{"avatarUrls":{"16x16":"https://your-domain.atlassian.net/secure/projectavatar?size=xsmall&pid=10002","24x24":"https://your-domain.atlassian.net/secure/projectavatar?size=small&pid=10002","32x32":"https://your-domain.atlassian.net/secure/projectavatar?size=medium&pid=10002","48x48":"https://your-domain.atlassian.net/secure/projectavatar?size=large&pid=10002"},"deleted":true,"deletedBy":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"deletedDate":"2022-11-11T13:35:29.000+0000","id":"10002","insight":{"lastIssueUpdateTime":"2021-04-22T05:37:05.000+0000","totalIssueCount":100},"key":"MKY","name":"Example","projectCategory":{"description":"First Project Category","id":"10000","name":"FIRST","self":"https://your-domain.atlassian.net/rest/api/3/projectCategory/10000"},"retentionTillDate":"2023-01-10T13:35:29.000+0000","self":"https://your-domain.atlassian.net/rest/api/3/project/MKY","simplified":false,"style":"classic"},"role":{"self":"https://your-domain.atlassian.net/rest/api/3/project/MKY/role/10360","name":"Developers","id":10360,"description":"A project role that represents developers in a project","actors":[{"actorGroup":{"name":"jira-developers","displayName":"jira-developers","groupId":"952d12c3-5b5b-4d04-bb32-44d383afc4b2"},"displayName":"jira-developers","id":10240,"name":"jira-developers","type":"atlassian-group-role-actor"},{"actorUser":{"accountId":"5b10a2844c20165700ede21g"},"displayName":"Mia Krystof","id":10241,"type":"atlassian-user-role-actor"}],"scope":{"project":{"id":"10000","key":"KEY","name":"Next Gen Project"},"type":"PROJECT"}},"type":"project"},{"group":{"groupId":"276f955c-63d7-42c8-9520-92d01dca0625","name":"jira-administrators","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=276f955c-63d7-42c8-9520-92d01dca0625"},"id":10010,"type":"group"}]';
              schema: {
                items: {
                  $ref: '#/components/schemas/SharePermission';
                };
                type: 'array';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if:\n\n *  the filter is not found.\n *  the user does not have permission to view the filter.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get share permissions';
      tags: ['Filter sharing'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:filter:jira',
            'read:group:jira',
            'read:project:jira',
            'read:user:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:issue-type-hierarchy:jira',
            'read:issue-type:jira',
            'read:project-category:jira',
            'read:project-role:jira',
            'read:project-version:jira',
            'read:project.component:jira',
          ];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Add a share permissions to a filter. If you add a global share permission (one for all logged-in users or the public) it will overwrite all share permissions for the filter.\n\nBe aware that this operation uses different objects for updating share permissions compared to [Update filter](#api-rest-api-3-filter-id-put).\n\n**[Permissions](#permissions) required:** *Share dashboards and filters* [global permission](https://confluence.atlassian.com/x/x4dKLg) and the user must own the filter.';
      operationId: 'addSharePermission';
      parameters: [
        {
          description: 'The ID of the filter.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              groupname: 'jira-administrators';
              rights: 1;
              type: 'group';
            };
            schema: {
              $ref: '#/components/schemas/SharePermissionInputBean';
            };
          };
        };
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              example: '[{"id":10000,"type":"global"},{"id":10010,"project":{"avatarUrls":{"16x16":"https://your-domain.atlassian.net/secure/projectavatar?size=xsmall&pid=10000","24x24":"https://your-domain.atlassian.net/secure/projectavatar?size=small&pid=10000","32x32":"https://your-domain.atlassian.net/secure/projectavatar?size=medium&pid=10000","48x48":"https://your-domain.atlassian.net/secure/projectavatar?size=large&pid=10000"},"id":"10000","insight":{"lastIssueUpdateTime":"2021-04-22T05:37:05.000+0000","totalIssueCount":100},"key":"EX","name":"Example","projectCategory":{"description":"First Project Category","id":"10000","name":"FIRST","self":"https://your-domain.atlassian.net/rest/api/3/projectCategory/10000"},"self":"https://your-domain.atlassian.net/rest/api/3/project/EX","simplified":false,"style":"classic"},"type":"project"},{"id":10010,"project":{"avatarUrls":{"16x16":"https://your-domain.atlassian.net/secure/projectavatar?size=xsmall&pid=10002","24x24":"https://your-domain.atlassian.net/secure/projectavatar?size=small&pid=10002","32x32":"https://your-domain.atlassian.net/secure/projectavatar?size=medium&pid=10002","48x48":"https://your-domain.atlassian.net/secure/projectavatar?size=large&pid=10002"},"deleted":true,"deletedBy":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"deletedDate":"2022-11-11T13:35:29.000+0000","id":"10002","insight":{"lastIssueUpdateTime":"2021-04-22T05:37:05.000+0000","totalIssueCount":100},"key":"MKY","name":"Example","projectCategory":{"description":"First Project Category","id":"10000","name":"FIRST","self":"https://your-domain.atlassian.net/rest/api/3/projectCategory/10000"},"retentionTillDate":"2023-01-10T13:35:29.000+0000","self":"https://your-domain.atlassian.net/rest/api/3/project/MKY","simplified":false,"style":"classic"},"role":{"self":"https://your-domain.atlassian.net/rest/api/3/project/MKY/role/10360","name":"Developers","id":10360,"description":"A project role that represents developers in a project","actors":[{"actorGroup":{"name":"jira-developers","displayName":"jira-developers","groupId":"952d12c3-5b5b-4d04-bb32-44d383afc4b2"},"displayName":"jira-developers","id":10240,"name":"jira-developers","type":"atlassian-group-role-actor"},{"actorUser":{"accountId":"5b10a2844c20165700ede21g"},"displayName":"Mia Krystof","id":10241,"type":"atlassian-user-role-actor"}],"scope":{"project":{"id":"10000","key":"KEY","name":"Next Gen Project"},"type":"PROJECT"}},"type":"project"},{"group":{"groupId":"276f955c-63d7-42c8-9520-92d01dca0625","name":"jira-administrators","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=276f955c-63d7-42c8-9520-92d01dca0625"},"id":10010,"type":"group"}]';
              schema: {
                items: {
                  $ref: '#/components/schemas/SharePermission';
                };
                type: 'array';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if:\n\n *  the request object is invalid. For example, it contains an invalid type, the ID does not match the type, or the project or group is not found.\n *  the user does not own the filter.\n *  the user does not have the required permissions.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if:\n\n *  the filter is not found.\n *  the user does not have permission to view the filter.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Add share permission';
      tags: ['Filter sharing'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'write:filter:jira',
            'read:filter:jira',
            'read:group:jira',
            'read:project:jira',
            'read:user:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:issue-type-hierarchy:jira',
            'read:issue-type:jira',
            'read:project-category:jira',
            'read:project-role:jira',
            'read:project-version:jira',
            'read:project.component:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/filter/{id}/permission/{permissionId}': {
    delete: {
      deprecated: false;
      description: 'Deletes a share permission from a filter.\n\n**[Permissions](#permissions) required:** Permission to access Jira and the user must own the filter.';
      operationId: 'deleteSharePermission';
      parameters: [
        {
          description: 'The ID of the filter.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The ID of the share permission.';
          in: 'path';
          name: 'permissionId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if:\n\n *  the filter is not found.\n *  the user does not own the filter.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Delete share permission';
      tags: ['Filter sharing'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:filter:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: 'Returns a share permission for a filter. A filter can be shared with groups, projects, all logged-in users, or the public. Sharing with all logged-in users or the public is known as a global share permission.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** None, however, a share permission is only returned for:\n\n *  filters owned by the user.\n *  filters shared with a group that the user is a member of.\n *  filters shared with a private project that the user has *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for.\n *  filters shared with a public project.\n *  filters shared with the public.';
      operationId: 'getSharePermission';
      parameters: [
        {
          description: 'The ID of the filter.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The ID of the share permission.';
          in: 'path';
          name: 'permissionId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"id":10000,"type":"global"}';
              schema: {
                $ref: '#/components/schemas/SharePermission';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if:\n\n *  the filter is not found.\n *  the permission is not found.\n *  the user does not have permission to view the filter.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get share permission';
      tags: ['Filter sharing'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:filter:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:issue-type-hierarchy:jira',
            'read:issue-type:jira',
            'read:project-category:jira',
            'read:project-version:jira',
            'read:project.component:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/group': {
    delete: {
      deprecated: false;
      description: 'Deletes a group.\n\n**[Permissions](#permissions) required:** Site administration (that is, member of the *site-admin* strategic [group](https://confluence.atlassian.com/x/24xjL)).';
      operationId: 'removeGroup';
      parameters: [
        {
          in: 'query';
          name: 'groupname';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the group. This parameter cannot be used with the `groupname` parameter.';
          in: 'query';
          name: 'groupId';
          schema: {
            type: 'string';
          };
          'x-showInExample': 'true';
        },
        {
          description: "As a group's name can change, use of `swapGroupId` is recommended to identify a group.  \nThe group to transfer restrictions to. Only comments and worklogs are transferred. If restrictions are not transferred, comments and worklogs are inaccessible after the deletion. This parameter cannot be used with the `swapGroupId` parameter.";
          in: 'query';
          name: 'swapGroup';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the group to transfer restrictions to. Only comments and worklogs are transferred. If restrictions are not transferred, comments and worklogs are inaccessible after the deletion. This parameter cannot be used with the `swapGroup` parameter.';
          in: 'query';
          name: 'swapGroupId';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the group name is not specified.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing from the request.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if the group is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Remove group';
      tags: ['Groups'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:group:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: true;
      description: 'This operation is deprecated, use [`group/member`](#api-rest-api-3-group-member-get).\n\nReturns all users in a group.\n\n**[Permissions](#permissions) required:** either of:\n\n *  *Browse users and groups* [global permission](https://confluence.atlassian.com/x/x4dKLg).\n *  *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getGroup';
      parameters: [
        {
          description: "As a group's name can change, use of `groupId` is recommended to identify a group.  \nThe name of the group. This parameter cannot be used with the `groupId` parameter.";
          in: 'query';
          name: 'groupname';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the group. This parameter cannot be used with the `groupName` parameter.';
          in: 'query';
          name: 'groupId';
          schema: {
            type: 'string';
          };
          'x-showInExample': 'true';
        },
        {
          description: 'List of fields to expand.';
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/Group';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the group name is not specified.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the calling user does not have the Administer Jira global permission.';
        };
        '404': {
          description: 'Returned if the group is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-user'];
        },
      ];
      summary: 'Get group';
      tags: ['Groups'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-user'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:group:jira', 'read:user:jira', 'read:avatar:jira'];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Creates a group.\n\n**[Permissions](#permissions) required:** Site administration (that is, member of the *site-admin* [group](https://confluence.atlassian.com/x/24xjL)).';
      operationId: 'createGroup';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              name: 'power-users';
            };
            schema: {
              $ref: '#/components/schemas/AddGroupBean';
            };
          };
        };
        description: 'The name of the group.';
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              example: '{"expand":"users","groupId":"276f955c-63d7-42c8-9520-92d01dca0625","name":"power-users","self":"https://your-domain.atlassian.net/rest/api/3/group?groupId=276f955c-63d7-42c8-9520-92d01dca0625","users":{"end-index":0,"items":[{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"}],"max-results":50,"size":1,"start-index":0}}';
              schema: {
                $ref: '#/components/schemas/Group';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if group name is not specified or the group name is in use.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Create group';
      tags: ['Groups'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:group:jira', 'read:user:jira', 'write:group:jira', 'read:avatar:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/group/bulk': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of groups.\n\n**[Permissions](#permissions) required:** *Browse users and groups* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'bulkGetGroups';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The ID of a group. To specify multiple IDs, pass multiple `groupId` parameters. For example, `groupId=5b10a2844c20165700ede21g&groupId=5b10ac8d82e05b22cc7d4ef5`.';
          in: 'query';
          name: 'groupId';
          schema: {
            example: '3571b9a7-348f-414a-9087-8e1ea03a7df8';
            items: {
              default: '';
              example: '3571b9a7-348f-414a-9087-8e1ea03a7df8';
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
          'x-showInExample': 'true';
        },
        {
          description: 'The name of a group. To specify multiple names, pass multiple `groupName` parameters. For example, `groupName=administrators&groupName=jira-software-users`.';
          in: 'query';
          name: 'groupName';
          schema: {
            items: {
              default: '';
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: "The access level of a group. Valid values: 'site-admin', 'admin', 'user'.";
          in: 'query';
          name: 'accessType';
          schema: {
            type: 'string';
          };
        },
        {
          description: "The application key of the product user groups to search for. Valid values: 'jira-servicedesk', 'jira-software', 'jira-product-discovery', 'jira-core'.";
          in: 'query';
          name: 'applicationKey';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":10,"startAt":0,"total":2,"values":[{"groupId":"276f955c-63d7-42c8-9520-92d01dca0625","name":"jdog-developers"},{"groupId":"6e87dc72-4f1f-421f-9382-2fee8b652487","name":"juvenal-bot"}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanGroupDetails';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Browse users and groups permission is required to view groups."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the necessary permission.';
        };
        '500': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Couldn\'t retrieve groups with the site-admin accessType."],"errors":{}}';
            };
          };
          description: "Returned if the group with the given access level can't be retrieved.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-user'];
        },
      ];
      summary: 'Bulk get groups';
      tags: ['Groups'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-user'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:group:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/group/member': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of all users in a group.\n\nNote that users are ordered by username, however the username is not returned in the results due to privacy reasons.\n\n**[Permissions](#permissions) required:** either of:\n\n *  *Browse users and groups* [global permission](https://confluence.atlassian.com/x/x4dKLg).\n *  *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getUsersFromGroup';
      parameters: [
        {
          description: "As a group's name can change, use of `groupId` is recommended to identify a group.  \nThe name of the group. This parameter cannot be used with the `groupId` parameter.";
          in: 'query';
          name: 'groupname';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the group. This parameter cannot be used with the `groupName` parameter.';
          in: 'query';
          name: 'groupId';
          schema: {
            type: 'string';
          };
          'x-showInExample': 'true';
        },
        {
          description: 'Include inactive users.';
          in: 'query';
          name: 'includeInactiveUsers';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":false,"maxResults":2,"nextPage":"https://your-domain.atlassian.net/rest/api/3/group/member?groupId=276f955c-63d7-42c8-9520-92d01dca0625&includeInactiveUsers=false&startAt=4&maxResults=2","self":"https://your-domain.atlassian.net/rest/api/3/group/member?groupId=276f955c-63d7-42c8-9520-92d01dca0625&includeInactiveUsers=false&startAt=2&maxResults=2","startAt":3,"total":5,"values":[{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":true,"avatarUrls":{},"displayName":"Mia","emailAddress":"mia@example.com","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g","timeZone":"Australia/Sydney"},{"accountId":"5b10a0effa615349cb016cd8","accountType":"atlassian","active":false,"avatarUrls":{},"displayName":"Will","emailAddress":"will@example.com","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a0effa615349cb016cd8","timeZone":"Australia/Sydney"}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanUserDetails';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the group name is not specified.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the calling user does not have the Administer Jira global permission.';
        };
        '404': {
          description: 'Returned if the group is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get users from group';
      tags: ['Groups'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:group:jira', 'read:user:jira', 'read:avatar:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/group/user': {
    delete: {
      deprecated: false;
      description: 'Removes a user from a group.\n\n**[Permissions](#permissions) required:** Site administration (that is, member of the *site-admin* [group](https://confluence.atlassian.com/x/24xjL)).';
      operationId: 'removeUserFromGroup';
      parameters: [
        {
          description: "As a group's name can change, use of `groupId` is recommended to identify a group.  \nThe name of the group. This parameter cannot be used with the `groupId` parameter.";
          in: 'query';
          name: 'groupname';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the group. This parameter cannot be used with the `groupName` parameter.';
          in: 'query';
          name: 'groupId';
          schema: {
            type: 'string';
          };
          'x-showInExample': 'true';
        },
        {
          description: 'This parameter is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.';
          in: 'query';
          name: 'username';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.';
          in: 'query';
          name: 'accountId';
          required: true;
          schema: {
            example: '5b10ac8d82e05b22cc7d4ef5';
            maxLength: 128;
            type: 'string';
          };
          'x-showInExample': 'true';
        },
      ];
      responses: {
        '200': {
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if:\n\n *  `groupName` is missing.\n *  `accountId` is missing.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing from the request.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if the group or user are not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Remove user from group';
      tags: ['Groups'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:group:jira'];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Adds a user to a group.\n\n**[Permissions](#permissions) required:** Site administration (that is, member of the *site-admin* [group](https://confluence.atlassian.com/x/24xjL)).';
      operationId: 'addUserToGroup';
      parameters: [
        {
          description: "As a group's name can change, use of `groupId` is recommended to identify a group.  \nThe name of the group. This parameter cannot be used with the `groupId` parameter.";
          in: 'query';
          name: 'groupname';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the group. This parameter cannot be used with the `groupName` parameter.';
          in: 'query';
          name: 'groupId';
          schema: {
            type: 'string';
          };
          'x-showInExample': 'true';
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              accountId: '5b10ac8d82e05b22cc7d4ef5';
            };
            schema: {
              $ref: '#/components/schemas/UpdateUserToGroupBean';
            };
          };
        };
        description: 'The user to add to the group.';
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/Group';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if:\n\n *  `groupname` is not provided.\n *  `accountId` is missing.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing from the request.';
        };
        '403': {
          description: 'Returned if the calling user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if the group or user are not found.';
        };
        '429': {
          description: 'Returned if rate limiting is being enforced.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Add user to group';
      tags: ['Groups'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:group:jira', 'read:avatar:jira', 'read:group:jira', 'read:user:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/groups/picker': {
    get: {
      deprecated: false;
      description: 'Returns a list of groups whose names contain a query string. A list of group names can be provided to exclude groups from the results.\n\nThe primary use case for this resource is to populate a group picker suggestions list. To this end, the returned object includes the `html` field where the matched query term is highlighted in the group name with the HTML strong tag. Also, the groups list is wrapped in a response object that contains a header for use in the picker, specifically *Showing X of Y matching groups*.\n\nThe list returns with the groups sorted. If no groups match the list criteria, an empty list is returned.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg). Anonymous calls and calls by users without the required permission return an empty list.\n\n*Browse users and groups* [global permission](https://confluence.atlassian.com/x/x4dKLg). Without this permission, calls where query is not an exact match to an existing group will return an empty list.';
      operationId: 'findGroups';
      parameters: [
        {
          description: 'This parameter is deprecated, setting it does not affect the results. To find groups containing a particular user, use [Get user groups](#api-rest-api-3-user-groups-get).';
          in: 'query';
          name: 'accountId';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The string to find in group names.';
          in: 'query';
          name: 'query';
          schema: {
            example: 'query';
            type: 'string';
          };
        },
        {
          description: "As a group's name can change, use of `excludeGroupIds` is recommended to identify a group.  \nA group to exclude from the result. To exclude multiple groups, provide an ampersand-separated list. For example, `exclude=group1&exclude=group2`. This parameter cannot be used with the `excludeGroupIds` parameter.";
          in: 'query';
          name: 'exclude';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
          };
        },
        {
          description: 'A group ID to exclude from the result. To exclude multiple groups, provide an ampersand-separated list. For example, `excludeId=group1-id&excludeId=group2-id`. This parameter cannot be used with the `excludeGroups` parameter.';
          in: 'query';
          name: 'excludeId';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
          };
        },
        {
          description: 'The maximum number of groups to return. The maximum number of groups that can be returned is limited by the system property `jira.ajax.autocomplete.limit`.';
          in: 'query';
          name: 'maxResults';
          schema: {
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'Whether the search for groups should be case insensitive.';
          in: 'query';
          name: 'caseInsensitive';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
        {
          description: 'This parameter is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.';
          in: 'query';
          name: 'userName';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"groups":[{"groupId":"276f955c-63d7-42c8-9520-92d01dca0625","html":"<b>j</b>dog-developers","name":"jdog-developers"},{"groupId":"6e87dc72-4f1f-421f-9382-2fee8b652487","html":"<b>j</b>uvenal-bot","name":"juvenal-bot"}],"header":"Showing 20 of 25 matching groups","total":25}';
              schema: {
                $ref: '#/components/schemas/FoundGroups';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-user'];
        },
        {},
      ];
      summary: 'Find groups';
      tags: ['Groups'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-user'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:group:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/groupuserpicker': {
    get: {
      deprecated: false;
      description: 'Returns a list of users and groups matching a string. The string is used:\n\n *  for users, to find a case-insensitive match with display name and e-mail address. Note that if a user has hidden their email address in their user profile, partial matches of the email address will not find the user. An exact match is required.\n *  for groups, to find a case-sensitive match with group name.\n\nFor example, if the string *tin* is used, records with the display name *Tina*, email address *sarah@tinplatetraining.com*, and the group *accounting* would be returned.\n\nOptionally, the search can be refined to:\n\n *  the projects and issue types associated with a custom field, such as a user picker. The search can then be further refined to return only users and groups that have permission to view specific:\n    \n     *  projects.\n     *  issue types.\n    \n    If multiple projects or issue types are specified, they must be a subset of those enabled for the custom field or no results are returned. For example, if a field is enabled for projects A, B, and C then the search could be limited to projects B and C. However, if the search is limited to projects B and D, nothing is returned.\n *  not return Connect app users and groups.\n *  return groups that have a case-insensitive match with the query.\n\nThe primary use case for this resource is to populate a picker field suggestion list with users or groups. To this end, the returned object includes an `html` field for each list. This field highlights the matched query term in the item name with the HTML strong tag. Also, each list is wrapped in a response object that contains a header for use in a picker, specifically *Showing X of Y matching groups*.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Browse users and groups* [global permission](https://confluence.atlassian.com/x/yodKLg).';
      operationId: 'findUsersAndGroups';
      parameters: [
        {
          description: 'The search string.';
          in: 'query';
          name: 'query';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of items to return in each list.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'Whether the user avatar should be returned. If an invalid value is provided, the default value is used.';
          in: 'query';
          name: 'showAvatar';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
        {
          description: 'The custom field ID of the field this request is for.';
          in: 'query';
          name: 'fieldId';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of a project that returned users and groups must have permission to view. To include multiple projects, provide an ampersand-separated list. For example, `projectId=10000&projectId=10001`. This parameter is only used when `fieldId` is present.';
          in: 'query';
          name: 'projectId';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
          };
        },
        {
          description: 'The ID of an issue type that returned users and groups must have permission to view. To include multiple issue types, provide an ampersand-separated list. For example, `issueTypeId=10000&issueTypeId=10001`. Special values, such as `-1` (all standard issue types) and `-2` (all subtask issue types), are supported. This parameter is only used when `fieldId` is present.';
          in: 'query';
          name: 'issueTypeId';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
          };
        },
        {
          description: 'The size of the avatar to return. If an invalid value is provided, the default value is used.';
          in: 'query';
          name: 'avatarSize';
          schema: {
            default: 'xsmall';
            enum: [
              'xsmall',
              'xsmall@2x',
              'xsmall@3x',
              'small',
              'small@2x',
              'small@3x',
              'medium',
              'medium@2x',
              'medium@3x',
              'large',
              'large@2x',
              'large@3x',
              'xlarge',
              'xlarge@2x',
              'xlarge@3x',
              'xxlarge',
              'xxlarge@2x',
              'xxlarge@3x',
              'xxxlarge',
              'xxxlarge@2x',
              'xxxlarge@3x',
            ];
            type: 'string';
          };
        },
        {
          description: 'Whether the search for groups should be case insensitive.';
          in: 'query';
          name: 'caseInsensitive';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
        {
          description: 'Whether Connect app users and groups should be excluded from the search results. If an invalid value is provided, the default value is used.';
          in: 'query';
          name: 'excludeConnectAddons';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"groups":{"groups":[{"groupId":"276f955c-63d7-42c8-9520-92d01dca0625","html":"<b>j</b>dog-developers","name":"jdog-developers"},{"groupId":"6e87dc72-4f1f-421f-9382-2fee8b652487","html":"<b>j</b>uvenal-bot","name":"juvenal-bot"}],"header":"Showing 20 of 25 matching groups","total":25},"users":{"header":"Showing 20 of 25 matching groups","total":25,"users":[{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","avatarUrl":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","displayName":"Mia Krystof","html":"<strong>Mi</strong>a Krystof - <strong>mi</strong>a@example.com (<strong>mi</strong>a)","key":"mia","name":"mia"}]}}';
              schema: {
                $ref: '#/components/schemas/FoundUsersAndGroups';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the query parameter is not provided.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '429': {
          description: "Returned if the rate limit is exceeded. User search endpoints share a collective rate limit for the tenant, in addition to Jira's normal rate limiting you may receive a rate limit for user search. Please respect the Retry-After header.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Find users and groups';
      tags: ['Group and user picker'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:group:jira', 'read:user:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/instance/license': {
    get: {
      deprecated: false;
      description: 'Returns licensing information about the Jira instance.\n\n**[Permissions](#permissions) required:** None.';
      operationId: 'getLicense';
      parameters: [];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"applications":[{"id":"jira-core","plan":"PAID"},{"id":"jira-product-discovery","plan":"FREE"},{"id":"jira-servicedesk","plan":"FREE"},{"id":"jira-software","plan":"PAID"}]}';
              schema: {
                $ref: '#/components/schemas/License';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get license';
      tags: ['License metrics'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:license:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issue': {
    post: {
      deprecated: false;
      description: "Creates an issue or, where the option to create subtasks is enabled in Jira, a subtask. A transition may be applied, to move the issue or subtask to a workflow step other than the default start step, and issue properties set.\n\nThe content of the issue or subtask is defined using `update` and `fields`. The fields that can be set in the issue or subtask are determined using the [ Get create issue metadata](#api-rest-api-3-issue-createmeta-get). These are the same fields that appear on the issue's create screen. Note that the `description`, `environment`, and any `textarea` type custom fields (multi-line text fields) take Atlassian Document Format content. Single line custom fields (`textfield`) accept a string and don't handle Atlassian Document Format content.\n\nCreating a subtask differs from creating an issue as follows:\n\n *  `issueType` must be set to a subtask issue type (use [ Get create issue metadata](#api-rest-api-3-issue-createmeta-get) to find subtask issue types).\n *  `parent` must contain the ID or key of the parent issue.\n\nIn a next-gen project any issue may be made a child providing that the parent and child are members of the same project.\n\n**[Permissions](#permissions) required:** *Browse projects* and *Create issues* [project permissions](https://confluence.atlassian.com/x/yodKLg) for the project in which the issue or subtask is created.";
      operationId: 'createIssue';
      parameters: [
        {
          description: "Whether the project in which the issue is created is added to the user's **Recently viewed** project list, as shown under **Projects** in Jira. When provided, the issue type and request type are added to the user's history for a project. These values are then used to provide defaults on the issue create screen.";
          in: 'query';
          name: 'updateHistory';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              fields: {
                assignee: {
                  id: '5b109f2e9729b51b54dc274d';
                };
                components: [
                  {
                    id: '10000';
                  },
                ];
                customfield_10000: '09/Jun/19';
                customfield_20000: '06/Jul/19 3:25 PM';
                customfield_30000: ['10000', '10002'];
                customfield_40000: {
                  content: [
                    {
                      content: [
                        {
                          text: 'Occurs on all orders';
                          type: 'text';
                        },
                      ];
                      type: 'paragraph';
                    },
                  ];
                  type: 'doc';
                  version: 1;
                };
                customfield_50000: {
                  content: [
                    {
                      content: [
                        {
                          text: 'Could impact day-to-day work.';
                          type: 'text';
                        },
                      ];
                      type: 'paragraph';
                    },
                  ];
                  type: 'doc';
                  version: 1;
                };
                customfield_60000: 'jira-software-users';
                customfield_70000: ['jira-administrators', 'jira-software-users'];
                customfield_80000: {
                  value: 'red';
                };
                description: {
                  content: [
                    {
                      content: [
                        {
                          text: 'Order entry fails when selecting supplier.';
                          type: 'text';
                        },
                      ];
                      type: 'paragraph';
                    },
                  ];
                  type: 'doc';
                  version: 1;
                };
                duedate: '2019-05-11';
                environment: {
                  content: [
                    {
                      content: [
                        {
                          text: 'UAT';
                          type: 'text';
                        },
                      ];
                      type: 'paragraph';
                    },
                  ];
                  type: 'doc';
                  version: 1;
                };
                fixVersions: [
                  {
                    id: '10001';
                  },
                ];
                issuetype: {
                  id: '10000';
                };
                labels: ['bugfix', 'blitz_test'];
                parent: {
                  key: 'PROJ-123';
                };
                priority: {
                  id: '20000';
                };
                project: {
                  id: '10000';
                };
                reporter: {
                  id: '5b10a2844c20165700ede21g';
                };
                security: {
                  id: '10000';
                };
                summary: 'Main order flow broken';
                timetracking: {
                  originalEstimate: '10';
                  remainingEstimate: '5';
                };
                versions: [
                  {
                    id: '10000';
                  },
                ];
              };
              update: {};
            };
            schema: {
              $ref: '#/components/schemas/IssueUpdateDetails';
            };
          };
        };
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              example: '{"id":"10000","key":"ED-24","self":"https://your-domain.atlassian.net/rest/api/3/issue/10000","transition":{"status":200,"errorCollection":{"errorMessages":[],"errors":{}}}}';
              schema: {
                $ref: '#/components/schemas/CreatedIssue';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Field \'priority\' is required"],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request:\n\n *  is missing required fields.\n *  contains invalid field values.\n *  contains fields that cannot be set for the issue type.\n *  is by a user who does not have the necessary permission.\n *  is to create a subtype in a project different that of the parent issue.\n *  is for a subtask when the option to create subtasks is disabled.\n *  is invalid for any other reason.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the user does not have the necessary permission.';
        };
        '422': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if a configuration problem prevents the creation of the issue.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Create issue';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'write:issue:jira',
            'write:comment:jira',
            'write:comment.property:jira',
            'write:attachment:jira',
            'read:issue:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/archive': {
    post: {
      deprecated: false;
      description: "Enables admins to archive up to 100,000 issues in a single request using JQL, returning the URL to check the status of the submitted request.\n\nYou can use the [get task](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-tasks/#api-rest-api-3-task-taskid-get) and [cancel task](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-tasks/#api-rest-api-3-task-taskid-cancel-post) APIs to manage the request.\n\n**Note that:**\n\n *  you can't archive subtasks directly, only through their parent issues\n *  you can only archive issues from software, service management, and business projects\n\n**[Permissions](#permissions) required:** Jira admin or site admin: [global permission](https://confluence.atlassian.com/x/x4dKLg)\n\n**License required:** Premium or Enterprise\n\n**Signed-in users only:** This API can't be accessed anonymously.\n\n**Rate limiting:** Only a single request per jira instance can be active at any given time.\n\n  \n";
      operationId: 'archiveIssuesAsync';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              jql: 'project = FOO AND updated < -2y';
            };
            schema: {
              $ref: '#/components/schemas/ArchiveIssueAsyncRequest';
            };
          };
        };
        description: 'A JQL query specifying the issues to archive. Note that subtasks can only be archived through their parent issues.';
        required: true;
      };
      responses: {
        '202': {
          content: {
            'application/json': {
              example: '"https://your-domain.atlassian.net/rest/api/3/task/1010"';
              schema: {
                type: 'string';
              };
            };
          };
          description: 'Returns the URL to check the status of the submitted request.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Invalid JQL. Bad request."],"errors":{}}';
            };
          };
          description: 'Returned if no issues were archived due to a bad request, for example an invalid JQL query.';
        };
        '401': {
          content: {
            'application/json': {
              example: '{"errorMessages":["User is not logged in."],"errors":{}}';
            };
          };
          description: 'Returned if no issues were archived because the provided authentication credentials are either missing or invalid.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Archiving issues is only available for premium editions of Jira."],"errors":{}}';
            };
          };
          description: 'Returned if no issues were archived because the user lacks the required Jira admin or site admin permissions.';
        };
        '412': {
          content: {
            'application/json': {
              example: '{"errorMessages":["An issue archival task is already running with ID 1010. To start a new one, cancel the task or wait for it to finish."],"errors":{}}';
            };
          };
          description: 'Returned if a request to archive issue(s) is already running.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Archive issue(s) by JQL';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
    put: {
      deprecated: false;
      description: "Enables admins to archive up to 1000 issues in a single request using issue ID/key, returning details of the issue(s) archived in the process and the errors encountered, if any.\n\n**Note that:**\n\n *  you can't archive subtasks directly, only through their parent issues\n *  you can only archive issues from software, service management, and business projects\n\n**[Permissions](#permissions) required:** Jira admin or site admin: [global permission](https://confluence.atlassian.com/x/x4dKLg)\n\n**License required:** Premium or Enterprise\n\n**Signed-in users only:** This API can't be accessed anonymously.\n\n  \n";
      operationId: 'archiveIssues';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              issueIdsOrKeys: ['PR-1', '1001', 'PROJECT-2'];
            };
            schema: {
              $ref: '#/components/schemas/IssueArchivalSyncRequest';
            };
          };
        };
        description: 'Contains a list of issue keys or IDs to be archived.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"errors":{"issueIsSubtask":{"count":3,"issueIdsOrKeys":["ST-1","ST-2","ST-3"],"message":"Issue is subtask."},"issuesInArchivedProjects":{"count":2,"issueIdsOrKeys":["AR-1","AR-2"],"message":"Issue exists in archived project."},"issuesInUnlicensedProjects":{"count":3,"issueIdsOrKeys":["UL-1","UL-2","UL-3"],"message":"Issues with these IDs are in unlicensed projects."},"issuesNotFound":{"count":3,"issueIdsOrKeys":["PR-1","PR-2","PR-3"],"message":"Issue not found."}},"numberOfIssuesUpdated":10}';
              schema: {
                $ref: '#/components/schemas/IssueArchivalSyncResponse';
              };
            };
          };
          description: 'Returned if there is at least one valid issue to archive in the request. The return message will include the count of archived issues and subtasks, as well as error details for issues which failed to get archived.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["No valid issue to archive or unarchive. Bad request."],"errors":{}}';
            };
          };
          description: "Returned if none of the issues in the request can be archived. Possible reasons:\n\n *  the issues weren't found\n *  the issues are subtasks\n *  the issues belong to unlicensed projects\n *  the issues belong to archived projects";
        };
        '401': {
          content: {
            'application/json': {
              example: '{"errorMessages":["User is not logged in."],"errors":{}}';
            };
          };
          description: 'Returned if no issues were archived because the provided authentication credentials are either missing or invalid.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only admins can archive or unarchive issues. Access denied."],"errors":{}}';
            };
          };
          description: 'Returned if no issues were archived because the user lacks the required Jira admin or site admin permissions.';
        };
        '412': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The number of issues to archive or unarchive exceeds the hard limit of 1000. Precondition failed."],"errors":{}}';
            };
          };
          description: 'Returned if one or more issues were successfully archived, but the operation was incomplete because the number of issue IDs or keys provided exceeds 1000.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Archive issue(s) by issue ID/key';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issue/bulk': {
    post: {
      deprecated: false;
      description: "Creates upto **50** issues and, where the option to create subtasks is enabled in Jira, subtasks. Transitions may be applied, to move the issues or subtasks to a workflow step other than the default start step, and issue properties set.\n\nThe content of each issue or subtask is defined using `update` and `fields`. The fields that can be set in the issue or subtask are determined using the [ Get create issue metadata](#api-rest-api-3-issue-createmeta-get). These are the same fields that appear on the issues' create screens. Note that the `description`, `environment`, and any `textarea` type custom fields (multi-line text fields) take Atlassian Document Format content. Single line custom fields (`textfield`) accept a string and don't handle Atlassian Document Format content.\n\nCreating a subtask differs from creating an issue as follows:\n\n *  `issueType` must be set to a subtask issue type (use [ Get create issue metadata](#api-rest-api-3-issue-createmeta-get) to find subtask issue types).\n *  `parent` the must contain the ID or key of the parent issue.\n\n**[Permissions](#permissions) required:** *Browse projects* and *Create issues* [project permissions](https://confluence.atlassian.com/x/yodKLg) for the project in which each issue or subtask is created.";
      operationId: 'createIssues';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              issueUpdates: [
                {
                  fields: {
                    assignee: {
                      id: '5b109f2e9729b51b54dc274d';
                    };
                    components: [
                      {
                        id: '10000';
                      },
                    ];
                    customfield_10000: '09/Jun/19';
                    customfield_20000: '06/Jul/19 3:25 PM';
                    customfield_30000: ['10000', '10002'];
                    customfield_40000: {
                      content: [
                        {
                          content: [
                            {
                              text: 'Occurs on all orders';
                              type: 'text';
                            },
                          ];
                          type: 'paragraph';
                        },
                      ];
                      type: 'doc';
                      version: 1;
                    };
                    customfield_50000: {
                      content: [
                        {
                          content: [
                            {
                              text: 'Could impact day-to-day work.';
                              type: 'text';
                            },
                          ];
                          type: 'paragraph';
                        },
                      ];
                      type: 'doc';
                      version: 1;
                    };
                    customfield_60000: 'jira-software-users';
                    customfield_70000: ['jira-administrators', 'jira-software-users'];
                    customfield_80000: {
                      value: 'red';
                    };
                    description: {
                      content: [
                        {
                          content: [
                            {
                              text: 'Order entry fails when selecting supplier.';
                              type: 'text';
                            },
                          ];
                          type: 'paragraph';
                        },
                      ];
                      type: 'doc';
                      version: 1;
                    };
                    duedate: '2011-03-11';
                    environment: {
                      content: [
                        {
                          content: [
                            {
                              text: 'UAT';
                              type: 'text';
                            },
                          ];
                          type: 'paragraph';
                        },
                      ];
                      type: 'doc';
                      version: 1;
                    };
                    fixVersions: [
                      {
                        id: '10001';
                      },
                    ];
                    issuetype: {
                      id: '10000';
                    };
                    labels: ['bugfix', 'blitz_test'];
                    priority: {
                      id: '20000';
                    };
                    project: {
                      id: '10000';
                    };
                    reporter: {
                      id: '5b10a2844c20165700ede21g';
                    };
                    security: {
                      id: '10000';
                    };
                    summary: 'Main order flow broken';
                    timetracking: {
                      originalEstimate: '10';
                      remainingEstimate: '5';
                    };
                    versions: [
                      {
                        id: '10000';
                      },
                    ];
                  };
                  update: {
                    worklog: [
                      {
                        add: {
                          started: '2019-07-05T11:05:00.000+0000';
                          timeSpent: '60m';
                        };
                      },
                    ];
                  };
                },
                {
                  fields: {
                    assignee: {
                      id: '5b109f2e9729b51b54dc274d';
                    };
                    components: [
                      {
                        id: '10000';
                      },
                    ];
                    customfield_10000: '09/Jun/19';
                    customfield_20000: '06/Jul/19 3:25 PM';
                    customfield_30000: ['10000', '10002'];
                    customfield_40000: {
                      content: [
                        {
                          content: [
                            {
                              text: 'Occurs on all orders';
                              type: 'text';
                            },
                          ];
                          type: 'paragraph';
                        },
                      ];
                      type: 'doc';
                      version: 1;
                    };
                    customfield_50000: {
                      content: [
                        {
                          content: [
                            {
                              text: 'Could impact day-to-day work.';
                              type: 'text';
                            },
                          ];
                          type: 'paragraph';
                        },
                      ];
                      type: 'doc';
                      version: 1;
                    };
                    customfield_60000: 'jira-software-users';
                    customfield_70000: ['jira-administrators', 'jira-software-users'];
                    customfield_80000: {
                      value: 'red';
                    };
                    description: {
                      content: [
                        {
                          content: [
                            {
                              text: 'Order remains pending after approved.';
                              type: 'text';
                            },
                          ];
                          type: 'paragraph';
                        },
                      ];
                      type: 'doc';
                      version: 1;
                    };
                    duedate: '2019-04-16';
                    environment: {
                      content: [
                        {
                          content: [
                            {
                              text: 'UAT';
                              type: 'text';
                            },
                          ];
                          type: 'paragraph';
                        },
                      ];
                      type: 'doc';
                      version: 1;
                    };
                    fixVersions: [
                      {
                        id: '10001';
                      },
                    ];
                    issuetype: {
                      id: '10000';
                    };
                    labels: ['new_release'];
                    priority: {
                      id: '20000';
                    };
                    project: {
                      id: '1000';
                    };
                    reporter: {
                      id: '5b10a2844c20165700ede21g';
                    };
                    security: {
                      id: '10000';
                    };
                    summary: 'Order stuck in pending';
                    timetracking: {
                      originalEstimate: '15';
                      remainingEstimate: '5';
                    };
                    versions: [
                      {
                        id: '10000';
                      },
                    ];
                  };
                  update: {};
                },
              ];
            };
            schema: {
              $ref: '#/components/schemas/IssuesUpdateBean';
            };
          };
        };
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              example: '{"issues":[{"id":"10000","key":"ED-24","self":"https://your-domain.atlassian.net/rest/api/3/issue/10000","transition":{"status":200,"errorCollection":{"errorMessages":[],"errors":{}}}},{"id":"10001","key":"ED-25","self":"https://your-domain.atlassian.net/rest/api/3/issue/10001"}],"errors":[]}';
              schema: {
                $ref: '#/components/schemas/CreatedIssues';
              };
            };
          };
          description: 'Returned if any of the issue or subtask creation requests were successful. A request may be unsuccessful when it:\n\n *  is missing required fields.\n *  contains invalid field values.\n *  contains fields that cannot be set for the issue type.\n *  is by a user who does not have the necessary permission.\n *  is to create a subtype in a project different that of the parent issue.\n *  is for a subtask when the option to create subtasks is disabled.\n *  is invalid for any other reason.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"issues":[],"errors":[{"elementErrors":{"errorMessages":[],"errors":{"issuetype":"The issue type selected is invalid.","project":"Sub-tasks must be created in the same project as the parent."}},"failedElementNumber":0,"status":400},{"elementErrors":{"errorMessages":[],"errors":{"issuetype":"The issue type selected is invalid.","project":"Sub-tasks must be created in the same project as the parent."}},"failedElementNumber":1,"status":400}]}';
              schema: {
                $ref: '#/components/schemas/CreatedIssues';
              };
            };
          };
          description: 'Returned if all requests are invalid. Requests may be unsuccessful when they:\n\n *  are missing required fields.\n *  contain invalid field values.\n *  contain fields that cannot be set for the issue type.\n *  are by a user who does not have the necessary permission.\n *  are to create a subtype in a project different that of the parent issue.\n *  is for a subtask when the option to create subtasks is disabled.\n *  are invalid for any other reason.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Bulk create issue';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'write:issue:jira',
            'write:comment:jira',
            'write:comment.property:jira',
            'write:attachment:jira',
            'read:issue:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/bulkfetch': {
    post: {
      deprecated: false;
      description: "Returns the details for a set of requested issues. You can request up to 100 issues.\n\nEach issue is identified by its ID or key, however, if the identifier doesn't match an issue, a case-insensitive search and check for moved issues is performed. If a matching issue is found its details are returned, a 302 or other redirect is **not** returned.\n\nIssues will be returned in ascending `id` order. If there are errors, Jira will return a list of issues which couldn't be fetched along with error messages.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** Issues are included in the response where the user has:\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.";
      operationId: 'bulkFetchIssues';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              expand: ['names'];
              fields: ['summary', 'project', 'assignee'];
              fieldsByKeys: false;
              issueIdsOrKeys: ['EX-1', 'EX-2', '10005'];
              properties: [];
            };
            schema: {
              $ref: '#/components/schemas/BulkFetchIssueRequestBean';
            };
          };
        };
        description: 'A JSON object containing the information about which issues and fields to fetch.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"expand":"schema,names","issueErrors":[],"issues":[{"expand":"","fields":{"summary":"My first example issue","project":{"avatarUrls":{"16x16":"https://your-domain.atlassian.net/secure/projectavatar?size=xsmall&pid=10000","24x24":"https://your-domain.atlassian.net/secure/projectavatar?size=small&pid=10000","32x32":"https://your-domain.atlassian.net/secure/projectavatar?size=medium&pid=10000","48x48":"https://your-domain.atlassian.net/secure/projectavatar?size=large&pid=10000"},"id":"10000","insight":{"lastIssueUpdateTime":"2021-04-22T05:37:05.000+0000","totalIssueCount":100},"key":"EX","name":"Example","projectCategory":{"description":"First Project Category","id":"10000","name":"FIRST","self":"https://your-domain.atlassian.net/rest/api/3/projectCategory/10000"},"self":"https://your-domain.atlassian.net/rest/api/3/project/EX","simplified":false,"style":"classic"},"assignee":{"accountId":"5b10a2844c20165700ede21g","active":true,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","emailAddress":"mia@example.com","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g","timeZone":"Australia/Sydney"}},"id":"10002","key":"EX-1","self":"https://your-domain.atlassian.net/rest/api/3/issue/10002"},{"expand":"","fields":{"summary":"My second example issue","project":{"avatarUrls":{"16x16":"https://your-domain.atlassian.net/secure/projectavatar?size=xsmall&pid=10001","24x24":"https://your-domain.atlassian.net/secure/projectavatar?size=small&pid=10001","32x32":"https://your-domain.atlassian.net/secure/projectavatar?size=medium&pid=10001","48x48":"https://your-domain.atlassian.net/secure/projectavatar?size=large&pid=10001"},"id":"10001","insight":{"lastIssueUpdateTime":"2021-04-22T05:37:05.000+0000","totalIssueCount":100},"key":"ABC","name":"Alphabetical","projectCategory":{"description":"First Project Category","id":"10000","name":"FIRST","self":"https://your-domain.atlassian.net/rest/api/3/projectCategory/10000"},"self":"https://your-domain.atlassian.net/rest/api/3/project/ABC","simplified":false,"style":"classic"},"assignee":{"accountId":"5b10a2844c20165700ede21g","active":true,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","emailAddress":"mia@example.com","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g","timeZone":"Australia/Sydney"}},"id":"10005","key":"EX-2","self":"https://your-domain.atlassian.net/rest/api/3/issue/10003"},{"expand":"","fields":{"summary":"My fourth example issue","project":{"avatarUrls":{"16x16":"https://your-domain.atlassian.net/secure/projectavatar?size=xsmall&pid=10002","24x24":"https://your-domain.atlassian.net/secure/projectavatar?size=small&pid=10002","32x32":"https://your-domain.atlassian.net/secure/projectavatar?size=medium&pid=10002","48x48":"https://your-domain.atlassian.net/secure/projectavatar?size=large&pid=10002"},"deleted":true,"deletedBy":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"deletedDate":"2022-11-11T13:35:29.000+0000","id":"10002","insight":{"lastIssueUpdateTime":"2021-04-22T05:37:05.000+0000","totalIssueCount":100},"key":"MKY","name":"Example","projectCategory":{"description":"First Project Category","id":"10000","name":"FIRST","self":"https://your-domain.atlassian.net/rest/api/3/projectCategory/10000"},"retentionTillDate":"2023-01-10T13:35:29.000+0000","self":"https://your-domain.atlassian.net/rest/api/3/project/MKY","simplified":false,"style":"classic"},"assignee":{"accountId":"5b10a2844c20165700ede21g","active":true,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","emailAddress":"mia@example.com","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g","timeZone":"Australia/Sydney"}},"id":"10005","key":"EX-4","self":"https://your-domain.atlassian.net/rest/api/3/issue/10005"}]}';
              schema: {
                $ref: '#/components/schemas/BulkIssueResults';
              };
            };
          };
          description: 'Returned if the request is successful. A response may contain both successful issues and issue errors.';
        };
        '400': {
          description: 'Returned if no issue IDs/keys were present, or more than 100 issue IDs/keys were requested.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Bulk fetch issues';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:issue-meta:jira',
            'read:issue-security-level:jira',
            'read:issue.vote:jira',
            'read:issue.changelog:jira',
            'read:avatar:jira',
            'read:issue:jira',
            'read:status:jira',
            'read:user:jira',
            'read:field-configuration:jira',
          ];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issue/createmeta': {
    get: {
      deprecated: true;
      description: 'Returns details of projects, issue types within projects, and, when requested, the create screen fields for each issue type for the user. Use the information to populate the requests in [ Create issue](#api-rest-api-3-issue-post) and [Create issues](#api-rest-api-3-issue-bulk-post).\n\nDeprecated, see [Create Issue Meta Endpoint Deprecation Notice](https://developer.atlassian.com/cloud/jira/platform/changelog/#CHANGE-1304).\n\nThe request can be restricted to specific projects or issue types using the query parameters. The response will contain information for the valid projects, issue types, or project and issue type combinations requested. Note that invalid project, issue type, or project and issue type combinations do not generate errors.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Create issues* [project permission](https://confluence.atlassian.com/x/yodKLg) in the requested projects.';
      operationId: 'getCreateIssueMeta';
      parameters: [
        {
          description: 'List of project IDs. This parameter accepts a comma-separated list. Multiple project IDs can also be provided using an ampersand-separated list. For example, `projectIds=10000,10001&projectIds=10020,10021`. This parameter may be provided with `projectKeys`.';
          in: 'query';
          name: 'projectIds';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
          };
        },
        {
          description: 'List of project keys. This parameter accepts a comma-separated list. Multiple project keys can also be provided using an ampersand-separated list. For example, `projectKeys=proj1,proj2&projectKeys=proj3`. This parameter may be provided with `projectIds`.';
          in: 'query';
          name: 'projectKeys';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
          };
        },
        {
          description: 'List of issue type IDs. This parameter accepts a comma-separated list. Multiple issue type IDs can also be provided using an ampersand-separated list. For example, `issuetypeIds=10000,10001&issuetypeIds=10020,10021`. This parameter may be provided with `issuetypeNames`.';
          in: 'query';
          name: 'issuetypeIds';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
          };
        },
        {
          description: 'List of issue type names. This parameter accepts a comma-separated list. Multiple issue type names can also be provided using an ampersand-separated list. For example, `issuetypeNames=name1,name2&issuetypeNames=name3`. This parameter may be provided with `issuetypeIds`.';
          in: 'query';
          name: 'issuetypeNames';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
          };
        },
        {
          description: 'Use [expand](#expansion) to include additional information about issue metadata in the response. This parameter accepts `projects.issuetypes.fields`, which returns information about the fields in the issue creation screen for each issue type. Fields hidden from the screen are not returned. Use the information to populate the `fields` and `update` fields in [Create issue](#api-rest-api-3-issue-post) and [Create issues](#api-rest-api-3-issue-bulk-post).';
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"projects":[{"avatarUrls":{"16x16":"https://your-domain.atlassian.net/secure/projectavatar?size=xsmall&pid=10000&avatarId=10011","24x24":"https://your-domain.atlassian.net/secure/projectavatar?size=small&pid=10000&avatarId=10011","32x32":"https://your-domain.atlassian.net/secure/projectavatar?size=medium&pid=10000&avatarId=10011","48x48":"https://your-domain.atlassian.net/secure/projectavatar?pid=10000&avatarId=10011"},"id":"10000","issuetypes":[{"description":"An error in the code","fields":{"issuetype":{"allowedValues":["set"],"autoCompleteUrl":"issuetype","hasDefaultValue":false,"key":"issuetype","name":"Issue Type","required":true}},"iconUrl":"https://your-domain.atlassian.net/images/icons/issuetypes/bug.png","id":"1","name":"Bug","self":"https://your-domain.atlassian.net/rest/api/3/issueType/1","subtask":false}],"key":"ED","name":"Edison Project","self":"https://your-domain.atlassian.net/rest/api/3/project/ED"}]}';
              schema: {
                $ref: '#/components/schemas/IssueCreateMetadata';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get create issue metadata';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-meta:jira', 'read:avatar:jira', 'read:field-configuration:jira'];
          state: 'Beta';
        },
      ];
      'x-changes': [
        {
          announced: '2023-12-11';
          details: 'https://developer.atlassian.com/cloud/jira/platform/changelog/#CHANGE-1304';
          effective: '2024-06-03';
          type: 'removed';
        },
      ];
    };
  };
  '/rest/api/3/issue/createmeta/{projectIdOrKey}/issuetypes': {
    get: {
      deprecated: false;
      description: 'Returns a page of issue type metadata for a specified project. Use the information to populate the requests in [ Create issue](#api-rest-api-3-issue-post) and [Create issues](#api-rest-api-3-issue-bulk-post).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Create issues* [project permission](https://confluence.atlassian.com/x/yodKLg) in the requested projects.';
      operationId: 'getCreateIssueMetaIssueTypes';
      parameters: [
        {
          description: 'The ID or key of the project.';
          in: 'path';
          name: 'projectIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            maximum: 200;
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"issueTypes":[{"description":"An error in the code","iconUrl":"https://your-domain.atlassian.net/images/icons/issuetypes/bug.png","id":"1","name":"Bug","self":"https://your-domain.atlassian.net/rest/api/3/issueType/1","subtask":false}],"maxResults":1,"startAt":0,"total":1}';
              schema: {
                $ref: '#/components/schemas/PageOfCreateMetaIssueTypes';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Parameter \'maxResults\' must not exceed the limit \'200\'"],"errors":{},"httpStatusCode":{"empty":false,"present":true}}';
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get create metadata issue types for a project';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-meta:jira', 'read:avatar:jira', 'read:field-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/createmeta/{projectIdOrKey}/issuetypes/{issueTypeId}': {
    get: {
      deprecated: false;
      description: 'Returns a page of field metadata for a specified project and issuetype id. Use the information to populate the requests in [ Create issue](#api-rest-api-3-issue-post) and [Create issues](#api-rest-api-3-issue-bulk-post).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Create issues* [project permission](https://confluence.atlassian.com/x/yodKLg) in the requested projects.';
      operationId: 'getCreateIssueMetaIssueTypeId';
      parameters: [
        {
          description: 'The ID or key of the project.';
          in: 'path';
          name: 'projectIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The issuetype ID.';
          in: 'path';
          name: 'issueTypeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            maximum: 200;
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"fields":[{"fieldId":"assignee","hasDefaultValue":false,"key":"assignee","name":"Assignee","operations":["set"],"required":true}],"maxResults":1,"startAt":0,"total":1}';
              schema: {
                $ref: '#/components/schemas/PageOfCreateMetaIssueTypeWithField';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Parameter \'maxResults\' must not exceed the limit \'200\'"],"errors":{},"httpStatusCode":{"empty":false,"present":true}}';
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get create field metadata for a project and issue type id';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-meta:jira', 'read:avatar:jira', 'read:field-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/limit/report': {
    get: {
      deprecated: false;
      description: 'Returns all issues breaching and approaching per-issue limits.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) is required for the project the issues are in. Results may be incomplete otherwise\n *  *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getIssueLimitReport';
      parameters: [
        {
          description: 'Return issue keys instead of issue ids in the response.\n\nUsage: Add `?isReturningKeys=true` to the end of the path to request issue keys.';
          in: 'query';
          name: 'isReturningKeys';
          schema: {
            default: false;
            type: 'boolean';
          };
          'x-showInExample': 'true';
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/IssueLimitReportRequest';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"issuesApproachingLimit":{"attachment":{"15070L":1822,"15111L":1999},"comment":{"10000L":4997,"15073L":4999,"15110L":5000},"remoteIssueLinks":{"15107L":2000},"worklog":{"15101L":10342}},"issuesBreachingLimit":{"attachment":{"15057L":2005,"15116L":2065,"15117L":3005},"comment":{"15055L":5202},"issuelinks":{"15058L":2120},"remoteIssueLinks":{"15059L":2094},"worklog":{"15056L":10085,"15169L":120864}},"limits":{"attachment":2000,"comment":5000,"issuelinks":2000,"remoteIssueLinks":2000,"worklog":10000}}';
              schema: {
                $ref: '#/components/schemas/IssueLimitReportResponseBean';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is invalid. Other possible reasons:\n\n *  the field queried is not supported\n *  the threshold is not within the supported range';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have permission to complete this request.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
      ];
      summary: 'Get issue limit report';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:project:jira', 'read:issue:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issue/picker': {
    get: {
      deprecated: false;
      description: "Returns lists of issues matching a query string. Use this resource to provide auto-completion suggestions when the user is looking for an issue using a word or string.\n\nThis operation returns two lists:\n\n *  `History Search` which includes issues from the user's history of created, edited, or viewed issues that contain the string in the `query` parameter.\n *  `Current Search` which includes issues that match the JQL expression in `currentJQL` and contain the string in the `query` parameter.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** None.";
      operationId: 'getIssuePickerResource';
      parameters: [
        {
          description: 'A string to match against text fields in the issue such as title, description, or comments.';
          in: 'query';
          name: 'query';
          schema: {
            example: 'query';
            type: 'string';
          };
          'x-showInExample': 'true';
        },
        {
          description: 'A JQL query defining a list of issues to search for the query term. Note that `username` and `userkey` cannot be used as search terms for this parameter, due to privacy reasons. Use `accountId` instead.';
          in: 'query';
          name: 'currentJQL';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The key of an issue to exclude from search results. For example, the issue the user is viewing when they perform this query.';
          in: 'query';
          name: 'currentIssueKey';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of a project that suggested issues must belong to.';
          in: 'query';
          name: 'currentProjectId';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Indicate whether to include subtasks in the suggestions list.';
          in: 'query';
          name: 'showSubTasks';
          schema: {
            type: 'boolean';
          };
        },
        {
          description: 'When `currentIssueKey` is a subtask, whether to include the parent issue in the suggestions if it matches the query.';
          in: 'query';
          name: 'showSubTaskParent';
          schema: {
            type: 'boolean';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/IssuePickerSuggestions';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get issue picker suggestions';
      tags: ['Issue search'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-details:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/properties': {
    post: {
      deprecated: false;
      description: 'Sets or updates a list of entity property values on issues. A list of up to 10 entity properties can be specified along with up to 10,000 issues on which to set or update that list of entity properties.\n\nThe value of the request body must be a [valid](http://tools.ietf.org/html/rfc4627), non-empty JSON. The maximum length of single issue property value is 32768 characters. This operation can be accessed anonymously.\n\nThis operation is:\n\n *  transactional, either all properties are updated in all eligible issues or, when errors occur, no properties are updated.\n *  [asynchronous](#async). Follow the `location` link in the response to determine the status of the task and use [Get task](#api-rest-api-3-task-taskId-get) to obtain subsequent updates.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* and *Edit issues* [project permissions](https://confluence.atlassian.com/x/yodKLg) for the project containing the issue.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'bulkSetIssuesPropertiesList';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/IssueEntityProperties';
            };
          };
        };
        description: 'Issue properties to be set or updated with values.';
        required: true;
      };
      responses: {
        '303': {
          description: 'Returned if the operation is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Return if the request is invalid or the user does not have the necessary permission.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
      ];
      summary: 'Bulk set issues properties by list';
      tags: ['Issue properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue.property:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/properties/multi': {
    post: {
      deprecated: false;
      description: 'Sets or updates entity property values on issues. Up to 10 entity properties can be specified for each issue and up to 100 issues included in the request.\n\nThe value of the request body must be a [valid](http://tools.ietf.org/html/rfc4627), non-empty JSON.\n\nThis operation is:\n\n *  [asynchronous](#async). Follow the `location` link in the response to determine the status of the task and use [Get task](#api-rest-api-3-task-taskId-get) to obtain subsequent updates.\n *  non-transactional. Updating some entities may fail. Such information will available in the task result.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* and *Edit issues* [project permissions](https://confluence.atlassian.com/x/yodKLg) for the project containing the issue.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'bulkSetIssuePropertiesByIssue';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              issues: [
                {
                  issueID: 1000;
                  properties: {
                    myProperty: {
                      owner: 'admin';
                      weight: 100;
                    };
                  };
                },
                {
                  issueID: 1001;
                  properties: {
                    myOtherProperty: {
                      cost: 150;
                      transportation: 'car';
                    };
                  };
                },
              ];
            };
            schema: {
              $ref: '#/components/schemas/MultiIssueEntityProperties';
            };
          };
        };
        description: 'Details of the issue properties to be set or updated. Note that if an issue is not found, it is ignored.';
        required: true;
      };
      responses: {
        '303': {
          description: 'Returned if the operation is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Return if the request is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect.';
        };
        '403': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Return if the user does not have the necessary permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
      ];
      summary: 'Bulk set issue properties by issue';
      tags: ['Issue properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue.property:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/properties/{propertyKey}': {
    delete: {
      deprecated: false;
      description: 'Deletes a property value from multiple issues. The issues to be updated can be specified by filter criteria.\n\nThe criteria the filter used to identify eligible issues are:\n\n *  `entityIds` Only issues from this list are eligible.\n *  `currentValue` Only issues with the property set to this value are eligible.\n\nIf both criteria is specified, they are joined with the logical *AND*: only issues that satisfy both criteria are considered eligible.\n\nIf no filter criteria are specified, all the issues visible to the user and where the user has the EDIT\\_ISSUES permission for the issue are considered eligible.\n\nThis operation is:\n\n *  transactional, either the property is deleted from all eligible issues or, when errors occur, no properties are deleted.\n *  [asynchronous](#async). Follow the `location` link in the response to determine the status of the task and use [Get task](#api-rest-api-3-task-taskId-get) to obtain subsequent updates.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [ project permission](https://confluence.atlassian.com/x/yodKLg) for each project containing issues.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  *Edit issues* [project permission](https://confluence.atlassian.com/x/yodKLg) for each issue.';
      operationId: 'bulkDeleteIssueProperty';
      parameters: [
        {
          description: 'The key of the property.';
          in: 'path';
          name: 'propertyKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              currentValue: 'deprecated value';
              entityIds: [10100, 100010];
            };
            schema: {
              $ref: '#/components/schemas/IssueFilterForBulkPropertyDelete';
            };
          };
        };
        required: true;
      };
      responses: {
        '303': {
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
      ];
      summary: 'Bulk delete issue property';
      tags: ['Issue properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:issue.property:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Sets a property value on multiple issues.\n\nThe value set can be a constant or determined by a [Jira expression](https://developer.atlassian.com/cloud/jira/platform/jira-expressions/). Expressions must be computable with constant complexity when applied to a set of issues. Expressions must also comply with the [restrictions](https://developer.atlassian.com/cloud/jira/platform/jira-expressions/#restrictions) that apply to all Jira expressions.\n\nThe issues to be updated can be specified by a filter.\n\nThe filter identifies issues eligible for update using these criteria:\n\n *  `entityIds` Only issues from this list are eligible.\n *  `currentValue` Only issues with the property set to this value are eligible.\n *  `hasProperty`:\n    \n     *  If *true*, only issues with the property are eligible.\n     *  If *false*, only issues without the property are eligible.\n\nIf more than one criteria is specified, they are joined with the logical *AND*: only issues that satisfy all criteria are eligible.\n\nIf an invalid combination of criteria is provided, an error is returned. For example, specifying a `currentValue` and `hasProperty` as *false* would not match any issues (because without the property the property cannot have a value).\n\nThe filter is optional. Without the filter all the issues visible to the user and where the user has the EDIT\\_ISSUES permission for the issue are considered eligible.\n\nThis operation is:\n\n *  transactional, either all eligible issues are updated or, when errors occur, none are updated.\n *  [asynchronous](#async). Follow the `location` link in the response to determine the status of the task and use [Get task](#api-rest-api-3-task-taskId-get) to obtain subsequent updates.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for each project containing issues.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  *Edit issues* [project permission](https://confluence.atlassian.com/x/yodKLg) for each issue.';
      operationId: 'bulkSetIssueProperty';
      parameters: [
        {
          description: 'The key of the property. The maximum length is 255 characters.';
          in: 'path';
          name: 'propertyKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              filter: {
                currentValue: {
                  owner: 'admin';
                  weight: 50;
                };
                entityIds: [10100, 100010];
                hasProperty: true;
              };
              value: {
                owner: 'admin';
                weight: 100;
              };
            };
            schema: {
              $ref: '#/components/schemas/BulkIssuePropertyUpdateRequest';
            };
          };
        };
        required: true;
      };
      responses: {
        '303': {
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
      ];
      summary: 'Bulk set issue property';
      tags: ['Issue properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-expressions:jira', 'write:issue.property:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/unarchive': {
    put: {
      deprecated: false;
      description: "Enables admins to unarchive up to 1000 issues in a single request using issue ID/key, returning details of the issue(s) unarchived in the process and the errors encountered, if any.\n\n**Note that:**\n\n *  you can't unarchive subtasks directly, only through their parent issues\n *  you can only unarchive issues from software, service management, and business projects\n\n**[Permissions](#permissions) required:** Jira admin or site admin: [global permission](https://confluence.atlassian.com/x/x4dKLg)\n\n**License required:** Premium or Enterprise\n\n**Signed-in users only:** This API can't be accessed anonymously.\n\n  \n";
      operationId: 'unarchiveIssues';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              issueIdsOrKeys: ['PR-1', '1001', 'PROJECT-2'];
            };
            schema: {
              $ref: '#/components/schemas/IssueArchivalSyncRequest';
            };
          };
        };
        description: 'Contains a list of issue keys or IDs to be unarchived.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"errors":{"issueIsSubtask":{"count":3,"issueIdsOrKeys":["ST-1","ST-2","ST-3"],"message":"Issue is subtask."},"issuesInArchivedProjects":{"count":2,"issueIdsOrKeys":["AR-1","AR-2"],"message":"Issue exists in archived project."},"issuesNotFound":{"count":3,"issueIdsOrKeys":["PR-1","PR-2","PR-3"],"message":"Issue not found."}},"numberOfIssuesUpdated":10}';
              schema: {
                $ref: '#/components/schemas/IssueArchivalSyncResponse';
              };
            };
          };
          description: 'Returned if there is at least one valid issue to unarchive in the request. It will return the count of unarchived issues, which also includes the count of the subtasks unarchived, and it will show the detailed errors for those issues which are not unarchived.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["No valid issue to archive or unarchive. Bad request."],"errors":{}}';
            };
          };
          description: "Returned if none of the issues in the request are eligible to be unarchived. Possible reasons:\n\n *  the issues weren't found\n *  the issues are subtasks\n *  the issues belong to archived projects";
        };
        '401': {
          content: {
            'application/json': {
              example: '{"errorMessages":["User is not logged in."],"errors":{}}';
            };
          };
          description: 'Returned if no issues were unarchived because the provided authentication credentials are either missing or invalid.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only admins can archive or unarchive issues. Access denied."],"errors":{}}';
            };
          };
          description: 'Returned if no issues were unarchived because the user lacks the required Jira admin or site admin permissions.';
        };
        '412': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The number of issues to archive or unarchive exceeds the hard limit of 1000. Precondition failed."],"errors":{}}';
            };
          };
          description: 'Returned if one or more issues were successfully unarchived, but the operation was incomplete because the number of issue IDs or keys provided exceeds 1000.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Unarchive issue(s) by issue keys/ID';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issue/watching': {
    post: {
      deprecated: false;
      description: 'Returns, for the user, details of the watched status of issues from a list. If an issue ID is invalid, the returned watched status is `false`.\n\nThis operation requires the **Allow users to watch issues** option to be *ON*. This option is set in General configuration for Jira. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'getIsWatchingIssueBulk';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              issueIds: ['10001', '10002', '10005'];
            };
            schema: {
              $ref: '#/components/schemas/IssueList';
            };
          };
        };
        description: 'A list of issue IDs.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"issuesIsWatching":{"10001":true,"10002":false,"10005":true}}';
              schema: {
                $ref: '#/components/schemas/BulkIssueIsWatching';
              };
            };
          };
          description: 'Returned if the request is successful';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get is watching issue bulk';
      tags: ['Issue watchers'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue.watcher:jira', 'read:user:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}': {
    delete: {
      deprecated: false;
      description: "Deletes an issue.\n\nAn issue cannot be deleted if it has one or more subtasks. To delete an issue with subtasks, set `deleteSubtasks`. This causes the issue's subtasks to be deleted with the issue.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* and *Delete issues* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project containing the issue.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.";
      operationId: 'deleteIssue';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "Whether the issue's subtasks are deleted when the issue is deleted.";
          in: 'query';
          name: 'deleteSubtasks';
          schema: {
            default: 'false';
            enum: ['true', 'false'];
            type: 'string';
          };
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the issue has subtasks and `deleteSubtasks` is not set to *true*.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect.';
        };
        '403': {
          description: 'Returned if the user does not have permission to delete the issue.';
        };
        '404': {
          description: 'Returned if the issue is not found or the user does not have permission to view the issue.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Delete issue';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:issue:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: "Returns the details for an issue.\n\nThe issue is identified by its ID or key, however, if the identifier doesn't match an issue, a case-insensitive search and check for moved issues is performed. If a matching issue is found its details are returned, a 302 or other redirect is **not** returned. The issue key returned in the response is the key of the issue found.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.";
      operationId: 'getIssue';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A list of fields to return for the issue. This parameter accepts a comma-separated list. Use it to retrieve a subset of fields. Allowed values:\n\n *  `*all` Returns all fields.\n *  `*navigable` Returns navigable fields.\n *  Any issue field, prefixed with a minus to exclude.\n\nExamples:\n\n *  `summary,comment` Returns only the summary and comments fields.\n *  `-description` Returns all (default) fields except description.\n *  `*navigable,-comment` Returns all navigable fields except comment.\n\nThis parameter may be specified multiple times. For example, `fields=field1,field2& fields=field3`.\n\nNote: All fields are returned by default. This differs from [Search for issues using JQL (GET)](#api-rest-api-3-search-get) and [Search for issues using JQL (POST)](#api-rest-api-3-search-post) where the default is all navigable fields.';
          in: 'query';
          name: 'fields';
          schema: {
            items: {
              default: '*all';
              type: 'string';
            };
            type: 'array';
          };
        },
        {
          description: "Whether fields in `fields` are referenced by keys rather than IDs. This parameter is useful where fields have been added by a connect app and a field's key may differ from its ID.";
          in: 'query';
          name: 'fieldsByKeys';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
        {
          description: "Use [expand](#expansion) to include additional information about the issues in the response. This parameter accepts a comma-separated list. Expand options include:\n\n *  `renderedFields` Returns field values rendered in HTML format.\n *  `names` Returns the display name of each field.\n *  `schema` Returns the schema describing a field type.\n *  `transitions` Returns all possible transitions for the issue.\n *  `editmeta` Returns information about how each field can be edited.\n *  `changelog` Returns a list of recent updates to an issue, sorted by date, starting from the most recent.\n *  `versionedRepresentations` Returns a JSON array for each version of a field's value, with the highest number representing the most recent version. Note: When included in the request, the `fields` parameter is ignored.";
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A list of issue properties to return for the issue. This parameter accepts a comma-separated list. Allowed values:\n\n *  `*all` Returns all issue properties.\n *  Any issue property key, prefixed with a minus to exclude.\n\nExamples:\n\n *  `*all` Returns all properties.\n *  `*all,-prop1` Returns all properties except `prop1`.\n *  `prop1,prop2` Returns `prop1` and `prop2` properties.\n\nThis parameter may be specified multiple times. For example, `properties=prop1,prop2& properties=prop3`.';
          in: 'query';
          name: 'properties';
          schema: {
            items: {
              default: 'null';
              type: 'string';
            };
            type: 'array';
          };
        },
        {
          description: "Whether the project in which the issue is created is added to the user's **Recently viewed** project list, as shown under **Projects** in Jira. This also populates the [JQL issues search](#api-rest-api-3-search-get) `lastViewed` field.";
          in: 'query';
          name: 'updateHistory';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
        {
          description: 'Whether to fail the request quickly in case of an error while loading fields for an issue. For `failFast=true`, if one field fails, the entire operation fails. For `failFast=false`, the operation will continue even if a field fails. It will return a valid response, but without values for the failed field(s).';
          in: 'query';
          name: 'failFast';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"fields":{"watcher":{"isWatching":false,"self":"https://your-domain.atlassian.net/rest/api/3/issue/EX-1/watchers","watchCount":1},"attachment":[{"author":{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"content":"https://your-domain.atlassian.net/jira/rest/api/3/attachment/content/10000","created":"2022-10-06T07:32:47.000+0000","filename":"picture.jpg","id":10000,"mimeType":"image/jpeg","self":"https://your-domain.atlassian.net/rest/api/3/attachments/10000","size":23123,"thumbnail":"https://your-domain.atlassian.net/jira/rest/api/3/attachment/thumbnail/10000"}],"sub-tasks":[{"id":"10000","outwardIssue":{"fields":{"status":{"iconUrl":"https://your-domain.atlassian.net/images/icons/statuses/open.png","name":"Open"}},"id":"10003","key":"ED-2","self":"https://your-domain.atlassian.net/rest/api/3/issue/ED-2"},"type":{"id":"10000","inward":"Parent","name":"","outward":"Sub-task"}}],"description":{"type":"doc","version":1,"content":[{"type":"paragraph","content":[{"type":"text","text":"Main order flow broken"}]}]},"project":{"avatarUrls":{"16x16":"https://your-domain.atlassian.net/secure/projectavatar?size=xsmall&pid=10000","24x24":"https://your-domain.atlassian.net/secure/projectavatar?size=small&pid=10000","32x32":"https://your-domain.atlassian.net/secure/projectavatar?size=medium&pid=10000","48x48":"https://your-domain.atlassian.net/secure/projectavatar?size=large&pid=10000"},"id":"10000","insight":{"lastIssueUpdateTime":"2021-04-22T05:37:05.000+0000","totalIssueCount":100},"key":"EX","name":"Example","projectCategory":{"description":"First Project Category","id":"10000","name":"FIRST","self":"https://your-domain.atlassian.net/rest/api/3/projectCategory/10000"},"self":"https://your-domain.atlassian.net/rest/api/3/project/EX","simplified":false,"style":"classic"},"comment":[{"author":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"body":{"type":"doc","version":1,"content":[{"type":"paragraph","content":[{"type":"text","text":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque eget venenatis elit. Duis eu justo eget augue iaculis fermentum. Sed semper quam laoreet nisi egestas at posuere augue semper."}]}]},"created":"2021-01-17T12:34:00.000+0000","id":"10000","self":"https://your-domain.atlassian.net/rest/api/3/issue/10010/comment/10000","updateAuthor":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"updated":"2021-01-18T23:45:00.000+0000","visibility":{"identifier":"Administrators","type":"role","value":"Administrators"}}],"issuelinks":[{"id":"10001","outwardIssue":{"fields":{"status":{"iconUrl":"https://your-domain.atlassian.net/images/icons/statuses/open.png","name":"Open"}},"id":"10004L","key":"PR-2","self":"https://your-domain.atlassian.net/rest/api/3/issue/PR-2"},"type":{"id":"10000","inward":"depends on","name":"Dependent","outward":"is depended by"}},{"id":"10002","inwardIssue":{"fields":{"status":{"iconUrl":"https://your-domain.atlassian.net/images/icons/statuses/open.png","name":"Open"}},"id":"10004","key":"PR-3","self":"https://your-domain.atlassian.net/rest/api/3/issue/PR-3"},"type":{"id":"10000","inward":"depends on","name":"Dependent","outward":"is depended by"}}],"worklog":[{"author":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"comment":{"type":"doc","version":1,"content":[{"type":"paragraph","content":[{"type":"text","text":"I did some work here."}]}]},"id":"100028","issueId":"10002","self":"https://your-domain.atlassian.net/rest/api/3/issue/10010/worklog/10000","started":"2021-01-17T12:34:00.000+0000","timeSpent":"3h 20m","timeSpentSeconds":12000,"updateAuthor":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"updated":"2021-01-18T23:45:00.000+0000","visibility":{"identifier":"276f955c-63d7-42c8-9520-92d01dca0625","type":"group","value":"jira-developers"}}],"updated":1,"timetracking":{"originalEstimate":"10m","originalEstimateSeconds":600,"remainingEstimate":"3m","remainingEstimateSeconds":200,"timeSpent":"6m","timeSpentSeconds":400}},"id":"10002","key":"ED-1","self":"https://your-domain.atlassian.net/rest/api/3/issue/10002"}';
              schema: {
                $ref: '#/components/schemas/IssueBean';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if the issue is not found or the user does not have permission to view it.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get issue';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:issue-meta:jira',
            'read:issue-security-level:jira',
            'read:issue.vote:jira',
            'read:issue.changelog:jira',
            'read:avatar:jira',
            'read:issue:jira',
            'read:status:jira',
            'read:user:jira',
            'read:field-configuration:jira',
          ];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: "Edits an issue. Issue properties may be updated as part of the edit. Please note that issue transition will be ignored as it is not supported yet.\n\nThe edits to the issue's fields are defined using `update` and `fields`. The fields that can be edited are determined using [ Get edit issue metadata](#api-rest-api-3-issue-issueIdOrKey-editmeta-get).\n\nThe parent field may be set by key or ID. For standard issue types, the parent may be removed by setting `update.parent.set.none` to *true*. Note that the `description`, `environment`, and any `textarea` type custom fields (multi-line text fields) take Atlassian Document Format content. Single line custom fields (`textfield`) accept a string and don't handle Atlassian Document Format content.\n\nConnect apps having an app user with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg), and Forge apps acting on behalf of users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg), can override the screen security configuration using `overrideScreenSecurity` and `overrideEditableFlag`.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* and *Edit issues* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.";
      operationId: 'editIssue';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "Whether a notification email about the issue update is sent to all watchers. To disable the notification, administer Jira or administer project permissions are required. If the user doesn't have the necessary permission the request is ignored.";
          in: 'query';
          name: 'notifyUsers';
          schema: {
            default: true;
            type: 'boolean';
          };
        },
        {
          description: 'Whether screen security is overridden to enable hidden fields to be edited. Available to Connect app users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) and Forge apps acting on behalf of users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
          in: 'query';
          name: 'overrideScreenSecurity';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
        {
          description: 'Whether screen security is overridden to enable uneditable fields to be edited. Available to Connect app users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) and Forge apps acting on behalf of users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
          in: 'query';
          name: 'overrideEditableFlag';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
        {
          description: 'Whether the response should contain the issue with fields edited in this request. The returned issue will have the same format as in the [Get issue API](#api-rest-api-3-issue-issueidorkey-get).';
          in: 'query';
          name: 'returnIssue';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
        {
          description: 'The Get issue API expand parameter to use in the response if the `returnIssue` parameter is `true`.';
          in: 'query';
          name: 'expand';
          schema: {
            default: '';
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              fields: {
                customfield_10000: {
                  content: [
                    {
                      content: [
                        {
                          text: 'Investigation underway';
                          type: 'text';
                        },
                      ];
                      type: 'paragraph';
                    },
                  ];
                  type: 'doc';
                  version: 1;
                };
                customfield_10010: 1;
                summary: 'Completed orders still displaying in pending';
              };
              historyMetadata: {
                activityDescription: 'Complete order processing';
                actor: {
                  avatarUrl: 'http://mysystem/avatar/tony.jpg';
                  displayName: 'Tony';
                  id: 'tony';
                  type: 'mysystem-user';
                  url: 'http://mysystem/users/tony';
                };
                cause: {
                  id: 'myevent';
                  type: 'mysystem-event';
                };
                description: 'From the order testing process';
                extraData: {
                  Iteration: '10a';
                  Step: '4';
                };
                generator: {
                  id: 'mysystem-1';
                  type: 'mysystem-application';
                };
                type: 'myplugin:type';
              };
              properties: [
                {
                  key: 'key1';
                  value: 'Order number 10784';
                },
                {
                  key: 'key2';
                  value: 'Order number 10923';
                },
              ];
              update: {
                components: [
                  {
                    set: '';
                  },
                ];
                labels: [
                  {
                    add: 'triaged';
                  },
                  {
                    remove: 'blocker';
                  },
                ];
                summary: [
                  {
                    set: 'Bug in business logic';
                  },
                ];
                timetracking: [
                  {
                    edit: {
                      originalEstimate: '1w 1d';
                      remainingEstimate: '4d';
                    };
                  },
                ];
              };
            };
            schema: {
              $ref: '#/components/schemas/IssueUpdateDetails';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful and the `returnIssue` parameter is `true`';
        };
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: "Returned if:\n\n *  the request body is missing.\n *  the user does not have the necessary permission to edit one or more fields.\n *  the request includes one or more fields that are not found or are not associated with the issue's edit screen.\n *  the request includes an invalid transition.";
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: "Returned if the user uses `overrideScreenSecurity` or `overrideEditableFlag` but doesn't have the necessary permission.";
        };
        '404': {
          description: 'Returned if the issue is not found or the user does not have permission to view it.';
        };
        '409': {
          description: 'Returned if the issue could not be updated due to a conflicting update.';
        };
        '422': {
          description: 'Returned if a configuration problem prevents the issue being updated.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Edit issue';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/assignee': {
    put: {
      deprecated: false;
      description: 'Assigns an issue to a user. Use this operation when the calling user does not have the *Edit Issues* permission but has the *Assign issue* permission for the project that the issue is in.\n\nIf `name` or `accountId` is set to:\n\n *  `"-1"`, the issue is assigned to the default assignee for the project.\n *  `null`, the issue is set to unassigned.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse Projects* and *Assign Issues* [ project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'assignIssue';
      parameters: [
        {
          description: 'The ID or key of the issue to be assigned.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              accountId: '5b10ac8d82e05b22cc7d4ef5';
            };
            schema: {
              $ref: '#/components/schemas/User';
            };
          };
        };
        description: 'The request object with the user that the issue is assigned to.';
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if:\n\n *  the user is not found.\n *  `name`, `key`, or `accountId` is missing.\n *  more than one of `name`, `key`, and `accountId` are provided.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if the issue is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Assign issue';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/attachments': {
    post: {
      deprecated: false;
      description: "Adds one or more attachments to an issue. Attachments are posted as multipart/form-data ([RFC 1867](https://www.ietf.org/rfc/rfc1867.txt)).\n\nNote that:\n\n *  The request must have a `X-Atlassian-Token: no-check` header, if not it is blocked. See [Special headers](#special-request-headers) for more information.\n *  The name of the multipart/form-data parameter that contains the attachments must be `file`.\n\nThe following examples upload a file called *myfile.txt* to the issue *TEST-123*:\n\n#### curl ####\n\n    curl --location --request POST 'https://your-domain.atlassian.net/rest/api/3/issue/TEST-123/attachments'\n     -u 'email@example.com:<api_token>'\n     -H 'X-Atlassian-Token: no-check'\n     --form 'file=@\"myfile.txt\"'\n\n#### Node.js ####\n\n    // This code sample uses the 'node-fetch' and 'form-data' libraries:\n     // https://www.npmjs.com/package/node-fetch\n     // https://www.npmjs.com/package/form-data\n     const fetch = require('node-fetch');\n     const FormData = require('form-data');\n     const fs = require('fs');\n    \n     const filePath = 'myfile.txt';\n     const form = new FormData();\n     const stats = fs.statSync(filePath);\n     const fileSizeInBytes = stats.size;\n     const fileStream = fs.createReadStream(filePath);\n    \n     form.append('file', fileStream, {knownLength: fileSizeInBytes});\n    \n     fetch('https://your-domain.atlassian.net/rest/api/3/issue/TEST-123/attachments', {\n         method: 'POST',\n         body: form,\n         headers: {\n             'Authorization': `Basic ${Buffer.from(\n                 'email@example.com:'\n             ).toString('base64')}`,\n             'Accept': 'application/json',\n             'X-Atlassian-Token': 'no-check'\n         }\n     })\n         .then(response => {\n             console.log(\n                 `Response: ${response.status} ${response.statusText}`\n             );\n             return response.text();\n         })\n         .then(text => console.log(text))\n         .catch(err => console.error(err));\n\n#### Java ####\n\n    // This code sample uses the  'Unirest' library:\n     // http://unirest.io/java.html\n     HttpResponse response = Unirest.post(\"https://your-domain.atlassian.net/rest/api/2/issue/{issueIdOrKey}/attachments\")\n             .basicAuth(\"email@example.com\", \"\")\n             .header(\"Accept\", \"application/json\")\n             .header(\"X-Atlassian-Token\", \"no-check\")\n             .field(\"file\", new File(\"myfile.txt\"))\n             .asJson();\n    \n             System.out.println(response.getBody());\n\n#### Python ####\n\n    # This code sample uses the 'requests' library:\n     # http://docs.python-requests.org\n     import requests\n     from requests.auth import HTTPBasicAuth\n     import json\n    \n     url = \"https://your-domain.atlassian.net/rest/api/2/issue/{issueIdOrKey}/attachments\"\n    \n     auth = HTTPBasicAuth(\"email@example.com\", \"\")\n    \n     headers = {\n        \"Accept\": \"application/json\",\n        \"X-Atlassian-Token\": \"no-check\"\n     }\n    \n     response = requests.request(\n        \"POST\",\n        url,\n        headers = headers,\n        auth = auth,\n        files = {\n             \"file\": (\"myfile.txt\", open(\"myfile.txt\",\"rb\"), \"application-type\")\n        }\n     )\n    \n     print(json.dumps(json.loads(response.text), sort_keys=True, indent=4, separators=(\",\", \": \")))\n\n#### PHP ####\n\n    // This code sample uses the 'Unirest' library:\n     // http://unirest.io/php.html\n     Unirest\\Request::auth('email@example.com', '');\n    \n     $headers = array(\n       'Accept' => 'application/json',\n       'X-Atlassian-Token' => 'no-check'\n     );\n    \n     $parameters = array(\n       'file' => File::add('myfile.txt')\n     );\n    \n     $response = Unirest\\Request::post(\n       'https://your-domain.atlassian.net/rest/api/2/issue/{issueIdOrKey}/attachments',\n       $headers,\n       $parameters\n     );\n    \n     var_dump($response)\n\n#### Forge ####\n\n    // This sample uses Atlassian Forge and the `form-data` library.\n     // https://developer.atlassian.com/platform/forge/\n     // https://www.npmjs.com/package/form-data\n     import api from \"@forge/api\";\n     import FormData from \"form-data\";\n    \n     const form = new FormData();\n     form.append('file', fileStream, {knownLength: fileSizeInBytes});\n    \n     const response = await api.asApp().requestJira('/rest/api/2/issue/{issueIdOrKey}/attachments', {\n         method: 'POST',\n         body: form,\n         headers: {\n             'Accept': 'application/json',\n             'X-Atlassian-Token': 'no-check'\n         }\n     });\n    \n     console.log(`Response: ${response.status} ${response.statusText}`);\n     console.log(await response.json());\n\nTip: Use a client library. Many client libraries have classes for handling multipart POST operations. For example, in Java, the Apache HTTP Components library provides a [MultiPartEntity](http://hc.apache.org/httpcomponents-client-ga/httpmime/apidocs/org/apache/http/entity/mime/MultipartEntity.html) class for multipart POST operations.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** \n\n *  *Browse Projects* and *Create attachments* [ project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.";
      operationId: 'addAttachment';
      parameters: [
        {
          description: 'The ID or key of the issue that attachments are added to.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'multipart/form-data': {
            schema: {
              items: {
                $ref: '#/components/schemas/MultipartFile';
              };
              type: 'array';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '[{"author":{"accountId":"5b10a2844c20165700ede21g","active":true,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","emailAddress":"mia@example.com","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g","timeZone":"Australia/Sydney"},"content":"https://your-domain.atlassian.net/rest/api/3/attachment/content/10000","created":1651316514000,"filename":"picture.jpg","id":"10001","mimeType":"image/jpeg","self":"https://your-domain.atlassian.net/rest/api/3/attachments/10000","size":23123,"thumbnail":"https://your-domain.atlassian.net/rest/api/3/attachment/thumbnail/10000"},{"author":{"accountId":"5b10a2844c20165700ede21g","active":true,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","emailAddress":"mia@example.com","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g","timeZone":"Australia/Sydney"},"content":"https://your-domain.atlassian.net/rest/api/3/attachment/content/10001","created":1658898511000,"filename":"dbeuglog.txt","mimeType":"text/plain","self":"https://your-domain.atlassian.net/rest/api/3/attachments/10001","size":2460}]';
              schema: {
                items: {
                  $ref: '#/components/schemas/Attachment';
                };
                type: 'array';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if any of the following is true:\n\n *  the issue is not found.\n *  the user does not have permission to view the issue.';
        };
        '413': {
          description: 'Returned if any of the following is true:\n\n *  the attachments exceed the maximum attachment size for issues.\n *  more than 60 files are requested to be uploaded.\n *  the per-issue limit for attachments has been breached.\n\nSee [Configuring file attachments](https://confluence.atlassian.com/x/wIXKM) for details.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Add attachment';
      tags: ['Issue attachments'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:user:jira', 'write:attachment:jira', 'read:attachment:jira', 'read:avatar:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/changelog': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of all changelogs for an issue sorted by date, starting from the oldest.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'getChangeLogs';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 100;
            format: 'int32';
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":false,"maxResults":2,"nextPage":"https://your-domain.atlassian.net/rest/api/3/issue/TT-1/changelog?&startAt=4&maxResults=2","self":"https://your-domain.atlassian.net/rest/api/3/issue/TT-1/changelog?startAt=2&maxResults=2","startAt":2,"total":5,"values":[{"author":{"accountId":"5b10a2844c20165700ede21g","active":true,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","emailAddress":"mia@example.com","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g","timeZone":"Australia/Sydney"},"created":"1970-01-18T06:27:50.429+0000","id":"10001","items":[{"field":"fields","fieldtype":"jira","fieldId":"fieldId","from":null,"fromString":"","to":null,"toString":"label-1"}]},{"author":{"accountId":"5b10a2844c20165700ede21g","active":true,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","emailAddress":"mia@example.com","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g","timeZone":"Australia/Sydney"},"created":"1970-01-18T06:27:51.429+0000","id":"10002","items":[{"field":"fields","fieldtype":"jira","fieldId":"fieldId","from":null,"fromString":"label-1","to":null,"toString":"label-1 label-2"}]}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanChangelog';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '404': {
          description: 'Returned if the issue is not found or the user does not have permission to view it.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get changelogs';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-meta:jira', 'read:avatar:jira', 'read:issue.changelog:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/changelog/list': {
    post: {
      deprecated: false;
      description: 'Returns changelogs for an issue specified by a list of changelog IDs.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'getChangeLogsByIds';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              changelogIds: [10001, 10002];
            };
            schema: {
              $ref: '#/components/schemas/IssueChangelogIds';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"histories":[{"author":{"accountId":"5b10a2844c20165700ede21g","active":true,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","emailAddress":"mia@example.com","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g","timeZone":"Australia/Sydney"},"created":"1970-01-18T06:27:50.429+0000","id":"10001","items":[{"field":"fields","fieldtype":"jira","fieldId":"fieldId","from":null,"fromString":"","to":null,"toString":"label-1"}]},{"author":{"accountId":"5b10a2844c20165700ede21g","active":true,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","emailAddress":"mia@example.com","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g","timeZone":"Australia/Sydney"},"created":"1970-01-18T06:27:51.429+0000","id":"10002","items":[{"field":"fields","fieldtype":"jira","fieldId":"fieldId","from":null,"fromString":"label-1","to":null,"toString":"label-1 label-2"}]}],"maxResults":2,"startAt":0,"total":2}';
              schema: {
                $ref: '#/components/schemas/PageOfChangelogs';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '404': {
          description: 'Returned if the issue is not found or the user does not have the necessary permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get changelogs by IDs';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-meta:jira', 'read:avatar:jira', 'read:issue.changelog:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/comment': {
    get: {
      deprecated: false;
      description: 'Returns all comments for an issue.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** Comments are included in the response where the user has:\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project containing the comment.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  If the comment has visibility restrictions, belongs to the group or has the role visibility is role visibility is restricted to.';
      operationId: 'getComments';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 5000;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: '[Order](#ordering) the results by a field. Accepts *created* to sort comments by their created date.';
          in: 'query';
          name: 'orderBy';
          schema: {
            enum: ['created', '-created', '+created'];
            type: 'string';
          };
        },
        {
          description: 'Use [expand](#expansion) to include additional information about comments in the response. This parameter accepts `renderedBody`, which returns the comment body rendered in HTML.';
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"comments":[{"author":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"body":{"type":"doc","version":1,"content":[{"type":"paragraph","content":[{"type":"text","text":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque eget venenatis elit. Duis eu justo eget augue iaculis fermentum. Sed semper quam laoreet nisi egestas at posuere augue semper."}]}]},"created":"2021-01-17T12:34:00.000+0000","id":"10000","self":"https://your-domain.atlassian.net/rest/api/3/issue/10010/comment/10000","updateAuthor":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"updated":"2021-01-18T23:45:00.000+0000","visibility":{"identifier":"Administrators","type":"role","value":"Administrators"}}],"maxResults":1,"startAt":0,"total":1}';
              schema: {
                $ref: '#/components/schemas/PageOfComments';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if `orderBy` is set to a value other than *created*.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if the issue is not found or the user does not have permission to view it.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get comments';
      tags: ['Issue comments'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:comment:jira',
            'read:comment.property:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'read:avatar:jira',
          ];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Adds a comment to an issue.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* and *Add comments* [ project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue containing the comment is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'addComment';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Use [expand](#expansion) to include additional information about comments in the response. This parameter accepts `renderedBody`, which returns the comment body rendered in HTML.';
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              body: {
                content: [
                  {
                    content: [
                      {
                        text: 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque eget venenatis elit. Duis eu justo eget augue iaculis fermentum. Sed semper quam laoreet nisi egestas at posuere augue semper.';
                        type: 'text';
                      },
                    ];
                    type: 'paragraph';
                  },
                ];
                type: 'doc';
                version: 1;
              };
              visibility: {
                identifier: 'Administrators';
                type: 'role';
                value: 'Administrators';
              };
            };
            schema: {
              $ref: '#/components/schemas/Comment';
            };
          };
        };
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              example: '{"author":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"body":{"type":"doc","version":1,"content":[{"type":"paragraph","content":[{"type":"text","text":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque eget venenatis elit. Duis eu justo eget augue iaculis fermentum. Sed semper quam laoreet nisi egestas at posuere augue semper."}]}]},"created":"2021-01-17T12:34:00.000+0000","id":"10000","self":"https://your-domain.atlassian.net/rest/api/3/issue/10010/comment/10000","updateAuthor":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"updated":"2021-01-18T23:45:00.000+0000","visibility":{"identifier":"Administrators","type":"role","value":"Administrators"}}';
              schema: {
                $ref: '#/components/schemas/Comment';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect.';
        };
        '404': {
          description: 'Returned if the issue is not found or the user does not have permission to view it.';
        };
        '413': {
          description: 'Returned if the per-issue limit has been breached for one of the following fields:\n\n *  comments\n *  attachments';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Add comment';
      tags: ['Issue comments'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:comment:jira',
            'read:comment.property:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'write:comment:jira',
            'read:avatar:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/comment/{id}': {
    delete: {
      deprecated: false;
      description: 'Deletes a comment.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue containing the comment is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  *Delete all comments*[ project permission](https://confluence.atlassian.com/x/yodKLg) to delete any comment or *Delete own comments* to delete comment created by the user,\n *  If the comment has visibility restrictions, the user belongs to the group or has the role visibility is restricted to.';
      operationId: 'deleteComment';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the comment.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the user does not have permission to delete the comment.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if the issue or comment is not found or the user does not have permission to view the issue or comment.';
        };
        '405': {
          description: 'Returned if an anonymous call is made to the operation.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Delete comment';
      tags: ['Issue comments'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:comment:jira', 'delete:comment.property:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: 'Returns a comment.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project containing the comment.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  If the comment has visibility restrictions, the user belongs to the group or has the role visibility is restricted to.';
      operationId: 'getComment';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the comment.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Use [expand](#expansion) to include additional information about comments in the response. This parameter accepts `renderedBody`, which returns the comment body rendered in HTML.';
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"author":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"body":{"type":"doc","version":1,"content":[{"type":"paragraph","content":[{"type":"text","text":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque eget venenatis elit. Duis eu justo eget augue iaculis fermentum. Sed semper quam laoreet nisi egestas at posuere augue semper."}]}]},"created":"2021-01-17T12:34:00.000+0000","id":"10000","self":"https://your-domain.atlassian.net/rest/api/3/issue/10010/comment/10000","updateAuthor":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"updated":"2021-01-18T23:45:00.000+0000","visibility":{"identifier":"Administrators","type":"role","value":"Administrators"}}';
              schema: {
                $ref: '#/components/schemas/Comment';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if the issue or comment is not found or the user does not have permission to view the issue or comment.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get comment';
      tags: ['Issue comments'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:comment:jira',
            'read:comment.property:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'read:avatar:jira',
          ];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Updates a comment.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue containing the comment is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  *Edit all comments*[ project permission](https://confluence.atlassian.com/x/yodKLg) to update any comment or *Edit own comments* to update comment created by the user.\n *  If the comment has visibility restrictions, the user belongs to the group or has the role visibility is restricted to.';
      operationId: 'updateComment';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the comment.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Whether users are notified when a comment is updated.';
          in: 'query';
          name: 'notifyUsers';
          schema: {
            default: true;
            type: 'boolean';
          };
        },
        {
          description: 'Whether screen security is overridden to enable uneditable fields to be edited. Available to Connect app users with the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) and Forge apps acting on behalf of users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
          in: 'query';
          name: 'overrideEditableFlag';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
        {
          description: 'Use [expand](#expansion) to include additional information about comments in the response. This parameter accepts `renderedBody`, which returns the comment body rendered in HTML.';
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              body: {
                content: [
                  {
                    content: [
                      {
                        text: 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque eget venenatis elit. Duis eu justo eget augue iaculis fermentum. Sed semper quam laoreet nisi egestas at posuere augue semper.';
                        type: 'text';
                      },
                    ];
                    type: 'paragraph';
                  },
                ];
                type: 'doc';
                version: 1;
              };
              visibility: {
                identifier: 'Administrators';
                type: 'role';
                value: 'Administrators';
              };
            };
            schema: {
              $ref: '#/components/schemas/Comment';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"author":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"body":{"type":"doc","version":1,"content":[{"type":"paragraph","content":[{"type":"text","text":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Pellentesque eget venenatis elit. Duis eu justo eget augue iaculis fermentum. Sed semper quam laoreet nisi egestas at posuere augue semper."}]}]},"created":"2021-01-17T12:34:00.000+0000","id":"10000","self":"https://your-domain.atlassian.net/rest/api/3/issue/10010/comment/10000","updateAuthor":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"updated":"2021-01-18T23:45:00.000+0000","visibility":{"identifier":"Administrators","type":"role","value":"Administrators"}}';
              schema: {
                $ref: '#/components/schemas/Comment';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the user does not have permission to edit the comment or the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if the issue or comment is not found or the user does not have permission to view the issue or comment.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Update comment';
      tags: ['Issue comments'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:comment:jira',
            'read:comment.property:jira',
            'read:group:jira',
            'read:project:jira',
            'read:project-role:jira',
            'read:user:jira',
            'write:comment:jira',
            'read:avatar:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/editmeta': {
    get: {
      deprecated: false;
      description: 'Returns the edit screen fields for an issue that are visible to and editable by the user. Use the information to populate the requests in [Edit issue](#api-rest-api-3-issue-issueIdOrKey-put).\n\nThis endpoint will check for these conditions:\n\n1.  Field is available on a field screen - through screen, screen scheme, issue type screen scheme, and issue type scheme configuration. `overrideScreenSecurity=true` skips this condition.\n2.  Field is visible in the [field configuration](https://support.atlassian.com/jira-cloud-administration/docs/change-a-field-configuration/). `overrideScreenSecurity=true` skips this condition.\n3.  Field is shown on the issue: each field has different conditions here. For example: Attachment field only shows if attachments are enabled. Assignee only shows if user has permissions to assign the issue.\n4.  If a field is custom then it must have valid custom field context, applicable for its project and issue type. All system fields are assumed to have context in all projects and all issue types.\n5.  Issue has a project, issue type, and status defined.\n6.  Issue is assigned to a valid workflow, and the current status has assigned a workflow step. `overrideEditableFlag=true` skips this condition.\n7.  The current workflow step is editable. This is true by default, but [can be disabled by setting](https://support.atlassian.com/jira-cloud-administration/docs/use-workflow-properties/) the `jira.issue.editable` property to `false`. `overrideEditableFlag=true` skips this condition.\n8.  User has [Edit issues permission](https://support.atlassian.com/jira-cloud-administration/docs/permissions-for-company-managed-projects/).\n9.  Workflow permissions allow editing a field. This is true by default but [can be modified](https://support.atlassian.com/jira-cloud-administration/docs/use-workflow-properties/) using `jira.permission.*` workflow properties.\n\nFields hidden using [Issue layout settings page](https://support.atlassian.com/jira-software-cloud/docs/configure-field-layout-in-the-issue-view/) remain editable.\n\nConnect apps having an app user with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg), and Forge apps acting on behalf of users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg), can return additional details using:\n\n *  `overrideScreenSecurity` When this flag is `true`, then this endpoint skips checking if fields are available through screens, and field configuration (conditions 1. and 2. from the list above).\n *  `overrideEditableFlag` When this flag is `true`, then this endpoint skips checking if workflow is present and if the current step is editable (conditions 6. and 7. from the list above).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n\nNote: For any fields to be editable the user must have the *Edit issues* [project permission](https://confluence.atlassian.com/x/yodKLg) for the issue.';
      operationId: 'getEditIssueMeta';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Whether hidden fields are returned. Available to Connect app users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) and Forge apps acting on behalf of users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
          in: 'query';
          name: 'overrideScreenSecurity';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
        {
          description: 'Whether non-editable fields are returned. Available to Connect app users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) and Forge apps acting on behalf of users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
          in: 'query';
          name: 'overrideEditableFlag';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"fields":{"summary":{"allowedValues":["red","blue"],"defaultValue":"red","hasDefaultValue":false,"key":"field_key","name":"My Multi Select","operations":["set","add"],"required":false,"schema":{"custom":"com.atlassian.jira.plugin.system.customfieldtypes:multiselect","customId":10001,"items":"option","type":"array"}}}}';
              schema: {
                $ref: '#/components/schemas/IssueUpdateMetadata';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: "Returned if the user uses an override parameter but doesn't have permission to do so.";
        };
        '404': {
          description: 'Returned if the issue is not found or the user does not have permission to view it.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get edit issue metadata';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-meta:jira', 'read:field-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/notify': {
    post: {
      deprecated: false;
      description: 'Creates an email notification for an issue and adds it to the mail queue.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse Projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'notify';
      parameters: [
        {
          description: 'ID or key of the issue that the notification is sent for.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              htmlBody: 'The <strong>latest</strong> test results for this ticket are now available.';
              restrict: {
                groupIds: [];
                groups: [
                  {
                    name: 'notification-group';
                  },
                ];
                permissions: [
                  {
                    key: 'BROWSE';
                  },
                ];
              };
              subject: 'Latest test results';
              textBody: 'The latest test results for this ticket are now available.';
              to: {
                assignee: false;
                groupIds: [];
                groups: [
                  {
                    name: 'notification-group';
                  },
                ];
                reporter: false;
                users: [
                  {
                    accountId: '5b10a2844c20165700ede21g';
                    active: false;
                  },
                ];
                voters: true;
                watchers: true;
              };
            };
            schema: {
              $ref: '#/components/schemas/Notification';
            };
          };
        };
        description: 'The request object for the notification and recipients.';
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the email is queued for sending.';
        };
        '400': {
          description: 'Returned if:\n\n *  the recipient is the same as the calling user.\n *  the recipient is invalid. For example, the recipient is set to the assignee, but the issue is unassigned.\n *  the request is invalid. For example, required fields are missing or have invalid values.';
        };
        '403': {
          description: 'Returned if:\n\n *  outgoing emails are disabled.\n *  no SMTP server is configured.';
        };
        '404': {
          description: 'Returned if the issue is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Send notification for issue';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['send:notification:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/properties': {
    get: {
      deprecated: false;
      description: "Returns the URLs and keys of an issue's properties.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** Property details are only returned where the user has:\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project containing the issue.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.";
      operationId: 'getIssuePropertyKeys';
      parameters: [
        {
          description: 'The key or ID of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"keys":[{"key":"issue.support","self":"https://your-domain.atlassian.net/rest/api/3/issue/EX-2/properties/issue.support"}]}';
              schema: {
                $ref: '#/components/schemas/PropertyKeys';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '404': {
          description: 'Returned if the issue is not found or the user does not have permissions to view the issue.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get issue property keys';
      tags: ['Issue properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue.property:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/properties/{propertyKey}': {
    delete: {
      deprecated: false;
      description: "Deletes an issue's property.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* and *Edit issues* [project permissions](https://confluence.atlassian.com/x/yodKLg) for the project containing the issue.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.";
      operationId: 'deleteIssueProperty';
      parameters: [
        {
          description: 'The key or ID of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The key of the property.';
          in: 'path';
          name: 'propertyKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if the issue or property is not found, or the user does not have permission to edit the issue.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Delete issue property';
      tags: ['Issue properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:issue.property:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: "Returns the key and value of an issue's property.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project containing the issue.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.";
      operationId: 'getIssueProperty';
      parameters: [
        {
          description: 'The key or ID of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The key of the property.';
          in: 'path';
          name: 'propertyKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"key":"issue.support","value":{"system.conversation.id":"b1bf38be-5e94-4b40-a3b8-9278735ee1e6","system.support.time":"1m"}}';
              schema: {
                $ref: '#/components/schemas/EntityProperty';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if the issue or property is not found or the user does not have permission to see the issue.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get issue property';
      tags: ['Issue properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue.property:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: "Sets the value of an issue's property. Use this resource to store custom data against an issue.\n\nThe value of the request body must be a [valid](http://tools.ietf.org/html/rfc4627), non-empty JSON blob. The maximum length is 32768 characters.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* and *Edit issues* [project permissions](https://confluence.atlassian.com/x/yodKLg) for the project containing the issue.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.";
      operationId: 'setIssueProperty';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The key of the issue property. The maximum length is 255 characters.';
          in: 'path';
          name: 'propertyKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {};
          };
        };
        description: 'The value of the property. The value has to be a valid, non-empty [JSON](https://tools.ietf.org/html/rfc4627) value. The maximum length of the property value is 32768 bytes.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the issue property is updated.';
        };
        '201': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the issue property is created.';
        };
        '400': {
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have permission to edit the issue.';
        };
        '404': {
          description: 'Returned if the issue is not found or the user does not have permission to view the issue.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Set issue property';
      tags: ['Issue properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue.property:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/remotelink': {
    delete: {
      deprecated: false;
      description: "Deletes the remote issue link from the issue using the link's global ID. Where the global ID includes reserved URL characters these must be escaped in the request. For example, pass `system=http://www.mycompany.com/support&id=1` as `system%3Dhttp%3A%2F%2Fwww.mycompany.com%2Fsupport%26id%3D1`.\n\nThis operation requires [issue linking to be active](https://confluence.atlassian.com/x/yoXKM).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* and *Link issues* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is implemented, issue-level security permission to view the issue.";
      operationId: 'deleteRemoteIssueLinkByGlobalId';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            example: '10000';
            type: 'string';
          };
          'x-showInExample': 'true';
        },
        {
          description: 'The global ID of a remote issue link.';
          in: 'query';
          name: 'globalId';
          required: true;
          schema: {
            example: 'system=http://www.mycompany.com/support&id=1';
            type: 'string';
          };
          'x-showInExample': 'true';
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: "Returned if a global ID isn't provided.";
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have permission to link issues.';
        };
        '404': {
          description: 'Returned if the issue or remote issue link is not found or the user does not have permission to view the issue.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Delete remote issue link by global ID';
      tags: ['Issue remote links'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:issue.remote-link:jira', 'write:issue:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: 'Returns the remote issue links for an issue. When a remote issue link global ID is provided the record with that global ID is returned, otherwise all remote issue links are returned. Where a global ID includes reserved URL characters these must be escaped in the request. For example, pass `system=http://www.mycompany.com/support&id=1` as `system%3Dhttp%3A%2F%2Fwww.mycompany.com%2Fsupport%26id%3D1`.\n\nThis operation requires [issue linking to be active](https://confluence.atlassian.com/x/yoXKM).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'getRemoteIssueLinks';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            example: '10000';
            type: 'string';
          };
          'x-showInExample': 'true';
        },
        {
          description: 'The global ID of the remote issue link.';
          in: 'query';
          name: 'globalId';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '[{"application":{"name":"My Acme Tracker","type":"com.acme.tracker"},"globalId":"system=http://www.mycompany.com/support&id=1","id":10000,"object":{"icon":{"title":"Support Ticket","url16x16":"http://www.mycompany.com/support/ticket.png"},"status":{"icon":{"link":"http://www.mycompany.com/support?id=1&details=closed","title":"Case Closed","url16x16":"http://www.mycompany.com/support/resolved.png"},"resolved":true},"summary":"Customer support issue","title":"TSTSUP-111","url":"http://www.mycompany.com/support?id=1"},"relationship":"causes","self":"https://your-domain.atlassian.net/rest/api/issue/MKY-1/remotelink/10000"},{"application":{"name":"My Acme Tester","type":"com.acme.tester"},"globalId":"system=http://www.anothercompany.com/tester&id=1234","id":10001,"object":{"icon":{"title":"Test Case","url16x16":"http://www.anothercompany.com/tester/images/testcase.gif"},"status":{"icon":{"link":"http://www.anothercompany.com/tester/person?accountId=5b10a2844c20165700ede21g","title":"Tested by Mia Krystof","url16x16":"http://www.anothercompany.com/tester/images/person/mia.gif"},"resolved":false},"summary":"Test that the submit button saves the item","title":"Test Case #1234","url":"http://www.anothercompany.com/tester/testcase/1234"},"relationship":"is tested by","self":"https://your-domain.atlassian.net/rest/api/issue/MKY-1/remotelink/10001"}]';
              schema: {
                $ref: '#/components/schemas/RemoteIssueLink';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if issue linking is disabled.';
        };
        '404': {
          description: 'Returned if the issue or remote issue link is not found or the user does not have permission to view the issue.';
        };
        '413': {
          description: 'Returned if the per-issue limit for remote links has been breached.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get remote issue links';
      tags: ['Issue remote links'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue.remote-link:jira', 'read:status:jira'];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Creates or updates a remote issue link for an issue.\n\nIf a `globalId` is provided and a remote issue link with that global ID is found it is updated. Any fields without values in the request are set to null. Otherwise, the remote issue link is created.\n\nThis operation requires [issue linking to be active](https://confluence.atlassian.com/x/yoXKM).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* and *Link issues* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'createOrUpdateRemoteIssueLink';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              application: {
                name: 'My Acme Tracker';
                type: 'com.acme.tracker';
              };
              globalId: 'system=http://www.mycompany.com/support&id=1';
              object: {
                icon: {
                  title: 'Support Ticket';
                  url16x16: 'http://www.mycompany.com/support/ticket.png';
                };
                status: {
                  icon: {
                    link: 'http://www.mycompany.com/support?id=1&details=closed';
                    title: 'Case Closed';
                    url16x16: 'http://www.mycompany.com/support/resolved.png';
                  };
                  resolved: true;
                };
                summary: 'Customer support issue';
                title: 'TSTSUP-111';
                url: 'http://www.mycompany.com/support?id=1';
              };
              relationship: 'causes';
            };
            schema: {
              $ref: '#/components/schemas/RemoteIssueLinkRequest';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"id":10000,"self":"https://your-domain.atlassian.net/rest/api/issue/MKY-1/remotelink/10000"}';
              schema: {
                $ref: '#/components/schemas/RemoteIssueLinkIdentifies';
              };
            };
          };
          description: 'Returned if the remote issue link is updated.';
        };
        '201': {
          content: {
            'application/json': {
              example: '{"id":10000,"self":"https://your-domain.atlassian.net/rest/api/issue/MKY-1/remotelink/10000"}';
              schema: {
                $ref: '#/components/schemas/RemoteIssueLinkIdentifies';
              };
            };
          };
          description: 'Returned if the remote issue link is created.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":[],"errors":{"title":"\'title\' is required."}}';
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have permission to link issues.';
        };
        '404': {
          description: 'Returned if the issue is not found or the user does not have permission to view the issue.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Create or update remote issue link';
      tags: ['Issue remote links'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue:jira', 'write:issue.remote-link:jira', 'read:issue.remote-link:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/remotelink/{linkId}': {
    delete: {
      deprecated: false;
      description: 'Deletes a remote issue link from an issue.\n\nThis operation requires [issue linking to be active](https://confluence.atlassian.com/x/yoXKM).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects*, *Edit issues*, and *Link issues* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'deleteRemoteIssueLinkById';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            example: '10000';
            type: 'string';
          };
          'x-showInExample': 'true';
        },
        {
          description: 'The ID of a remote issue link.';
          in: 'path';
          name: 'linkId';
          required: true;
          schema: {
            example: '10000';
            type: 'string';
          };
          'x-showInExample': 'true';
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the link ID is invalid or the remote issue link does not belong to the issue.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have permission to link issues.';
        };
        '404': {
          description: 'Returned if the issue or remote issue link is not found or the user does not have permission to view the issue.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Delete remote issue link by ID';
      tags: ['Issue remote links'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:issue.remote-link:jira', 'write:issue:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: 'Returns a remote issue link for an issue.\n\nThis operation requires [issue linking to be active](https://confluence.atlassian.com/x/yoXKM).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'getRemoteIssueLinkById';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the remote issue link.';
          in: 'path';
          name: 'linkId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"application":{"name":"My Acme Tracker","type":"com.acme.tracker"},"globalId":"system=http://www.mycompany.com/support&id=1","id":10000,"object":{"icon":{"title":"Support Ticket","url16x16":"http://www.mycompany.com/support/ticket.png"},"status":{"icon":{"link":"http://www.mycompany.com/support?id=1&details=closed","title":"Case Closed","url16x16":"http://www.mycompany.com/support/resolved.png"},"resolved":true},"summary":"Customer support issue","title":"TSTSUP-111","url":"http://www.mycompany.com/support?id=1"},"relationship":"causes","self":"https://your-domain.atlassian.net/rest/api/issue/MKY-1/remotelink/10000"}';
              schema: {
                $ref: '#/components/schemas/RemoteIssueLink';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the link ID is invalid or the remote issue link does not belong to the issue.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if issue linking is disabled.';
        };
        '404': {
          description: 'Returned if the issue or remote issue link is not found or the user does not have permission to view the issue.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get remote issue link by ID';
      tags: ['Issue remote links'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue.remote-link:jira', 'read:status:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Updates a remote issue link for an issue.\n\nNote: Fields without values in the request are set to null.\n\nThis operation requires [issue linking to be active](https://confluence.atlassian.com/x/yoXKM).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* and *Link issues* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'updateRemoteIssueLink';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            example: '10000';
            type: 'string';
          };
          'x-showInExample': 'true';
        },
        {
          description: 'The ID of the remote issue link.';
          in: 'path';
          name: 'linkId';
          required: true;
          schema: {
            example: '10000';
            type: 'string';
          };
          'x-showInExample': 'true';
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              application: {
                name: 'My Acme Tracker';
                type: 'com.acme.tracker';
              };
              globalId: 'system=http://www.mycompany.com/support&id=1';
              object: {
                icon: {
                  title: 'Support Ticket';
                  url16x16: 'http://www.mycompany.com/support/ticket.png';
                };
                status: {
                  icon: {
                    link: 'http://www.mycompany.com/support?id=1&details=closed';
                    title: 'Case Closed';
                    url16x16: 'http://www.mycompany.com/support/resolved.png';
                  };
                  resolved: true;
                };
                summary: 'Customer support issue';
                title: 'TSTSUP-111';
                url: 'http://www.mycompany.com/support?id=1';
              };
              relationship: 'causes';
            };
            schema: {
              $ref: '#/components/schemas/RemoteIssueLinkRequest';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":[],"errors":{"title":"\'title\' is required."}}';
            };
          };
          description: 'Returned if:\n\n *  the link ID is invalid.\n *  the remote issue link does not belong to the issue.\n *  the request body is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have permission to link issues.';
        };
        '404': {
          description: 'Returned if the issue or remote issue link is not found or the user does not have permission to view the issue.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Update remote issue link by ID';
      tags: ['Issue remote links'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue:jira', 'write:issue.remote-link:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/transitions': {
    get: {
      deprecated: false;
      description: "Returns either all transitions or a transition that can be performed by the user on an issue, based on the issue's status.\n\nNote, if a request is made for a transition that does not exist or cannot be performed on the issue, given its status, the response will return any empty transitions list.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required: A list or transition is returned only when the user has:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n\nHowever, if the user does not have the *Transition issues* [ project permission](https://confluence.atlassian.com/x/yodKLg) the response will not list any transitions.";
      operationId: 'getTransitions';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Use [expand](#expansion) to include additional information about transitions in the response. This parameter accepts `transitions.fields`, which returns information about the fields in the transition screen for each transition. Fields hidden from the screen are not returned. Use this information to populate the `fields` and `update` fields in [Transition issue](#api-rest-api-3-issue-issueIdOrKey-transitions-post).';
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the transition.';
          in: 'query';
          name: 'transitionId';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Whether transitions with the condition *Hide From User Condition* are included in the response.';
          in: 'query';
          name: 'skipRemoteOnlyCondition';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
        {
          description: 'Whether details of transitions that fail a condition are included in the response';
          in: 'query';
          name: 'includeUnavailableTransitions';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
        {
          description: 'Whether the transitions are sorted by ops-bar sequence value first then category order (Todo, In Progress, Done) or only by ops-bar sequence value.';
          in: 'query';
          name: 'sortByOpsBarAndStatus';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"transitions":[{"fields":{"summary":{"allowedValues":["red","blue"],"defaultValue":"red","hasDefaultValue":false,"key":"field_key","name":"My Multi Select","operations":["set","add"],"required":false,"schema":{"custom":"com.atlassian.jira.plugin.system.customfieldtypes:multiselect","customId":10001,"items":"option","type":"array"}}},"hasScreen":false,"id":"2","isAvailable":true,"isConditional":false,"isGlobal":false,"isInitial":false,"name":"Close Issue","to":{"description":"The issue is currently being worked on.","iconUrl":"https://your-domain.atlassian.net/images/icons/progress.gif","id":"10000","name":"In Progress","self":"https://your-domain.atlassian.net/rest/api/3/status/10000","statusCategory":{"colorName":"yellow","id":1,"key":"in-flight","name":"In Progress","self":"https://your-domain.atlassian.net/rest/api/3/statuscategory/1"}}},{"fields":{"summary":{"allowedValues":["red","blue"],"defaultValue":"red","hasDefaultValue":false,"key":"field_key","name":"My Multi Select","operations":["set","add"],"required":false,"schema":{"custom":"com.atlassian.jira.plugin.system.customfieldtypes:multiselect","customId":10001,"items":"option","type":"array"}},"colour":{"allowedValues":["red","blue"],"defaultValue":"red","hasDefaultValue":false,"key":"field_key","name":"My Multi Select","operations":["set","add"],"required":false,"schema":{"custom":"com.atlassian.jira.plugin.system.customfieldtypes:multiselect","customId":10001,"items":"option","type":"array"}}},"hasScreen":true,"id":"711","name":"QA Review","to":{"description":"The issue is closed.","iconUrl":"https://your-domain.atlassian.net/images/icons/closed.gif","id":"5","name":"Closed","self":"https://your-domain.atlassian.net/rest/api/3/status/5","statusCategory":{"colorName":"green","id":9,"key":"completed","self":"https://your-domain.atlassian.net/rest/api/3/statuscategory/9"}}}]}';
              schema: {
                $ref: '#/components/schemas/Transitions';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if the issue is not found or the user does not have permission to view it.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get transitions';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue.transition:jira', 'read:status:jira', 'read:field-configuration:jira'];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Performs an issue transition and, if the transition has a screen, updates the fields from the transition screen.\n\nsortByCategory To update the fields on the transition screen, specify the fields in the `fields` or `update` parameters in the request body. Get details about the fields using [ Get transitions](#api-rest-api-3-issue-issueIdOrKey-transitions-get) with the `transitions.fields` expand.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* and *Transition issues* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'doTransition';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              fields: {
                assignee: {
                  name: 'bob';
                };
                resolution: {
                  name: 'Fixed';
                };
              };
              historyMetadata: {
                activityDescription: 'Complete order processing';
                actor: {
                  avatarUrl: 'http://mysystem/avatar/tony.jpg';
                  displayName: 'Tony';
                  id: 'tony';
                  type: 'mysystem-user';
                  url: 'http://mysystem/users/tony';
                };
                cause: {
                  id: 'myevent';
                  type: 'mysystem-event';
                };
                description: 'From the order testing process';
                extraData: {
                  Iteration: '10a';
                  Step: '4';
                };
                generator: {
                  id: 'mysystem-1';
                  type: 'mysystem-application';
                };
                type: 'myplugin:type';
              };
              transition: {
                id: '5';
              };
              update: {
                comment: [
                  {
                    add: {
                      body: {
                        content: [
                          {
                            content: [
                              {
                                text: 'Bug has been fixed';
                                type: 'text';
                              },
                            ];
                            type: 'paragraph';
                          },
                        ];
                        type: 'doc';
                        version: 1;
                      };
                    };
                  },
                ];
              };
            };
            schema: {
              $ref: '#/components/schemas/IssueUpdateDetails';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: "Returned if:\n\n *  no transition is specified.\n *  the user does not have permission to transition the issue.\n *  a field that isn't included on the transition screen is defined in `fields` or `update`.\n *  a field is specified in both `fields` and `update`.\n *  the request is invalid for any other reason.";
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if the issue is not found or the user does not have permission to view it.';
        };
        '409': {
          description: 'Returned if the issue could not be updated due to a conflicting update.';
        };
        '413': {
          description: 'Returned if a per-issue limit has been breached for one of the following fields:\n\n *  comments\n *  worklogs\n *  attachments\n *  issue links\n *  remote issue links';
        };
        '422': {
          description: 'Returned if a configuration problem prevents the creation of the issue.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Transition issue';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue:jira', 'write:issue.property:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/votes': {
    delete: {
      deprecated: false;
      description: "Deletes a user's vote from an issue. This is the equivalent of the user clicking *Unvote* on an issue in Jira.\n\nThis operation requires the **Allow users to vote on issues** option to be *ON*. This option is set in General configuration for Jira. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.";
      operationId: 'removeVote';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if:\n\n *  voting is disabled.\n *  the user has not voted on the issue.\n *  the issue is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Delete vote';
      tags: ['Issue votes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue.vote:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: 'Returns details about the votes on an issue.\n\nThis operation requires the **Allow users to vote on issues** option to be *ON*. This option is set in General configuration for Jira. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is ini\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n\nNote that users with the necessary permissions for this operation but without the *View voters and watchers* project permissions are not returned details in the `voters` field.';
      operationId: 'getVotes';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"hasVoted":true,"self":"https://your-domain.atlassian.net/rest/api/issue/MKY-1/votes","voters":[{"accountId":"5b10a2844c20165700ede21g","accountType":"atlassian","active":false,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","key":"","name":"","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"}],"votes":24}';
              schema: {
                $ref: '#/components/schemas/Votes';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if:\n\n *  voting is disabled.\n *  the user does not have permission to view the issue.\n *  the issue is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get votes';
      tags: ['Issue votes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:issue.vote:jira',
            'read:user:jira',
            'read:application-role:jira',
            'read:avatar:jira',
            'read:group:jira',
          ];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: "Adds the user's vote to an issue. This is the equivalent of the user clicking *Vote* on an issue in Jira.\n\nThis operation requires the **Allow users to vote on issues** option to be *ON*. This option is set in General configuration for Jira. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.";
      operationId: 'addVote';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if:\n\n *  voting is disabled.\n *  the issue is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Add vote';
      tags: ['Issue votes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue.vote:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/watchers': {
    delete: {
      deprecated: false;
      description: 'Deletes a user as a watcher of an issue.\n\nThis operation requires the **Allow users to watch issues** option to be *ON*. This option is set in General configuration for Jira. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  To remove users other than themselves from the watchlist, *Manage watcher list* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.';
      operationId: 'removeWatcher';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'This parameter is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.';
          in: 'query';
          name: 'username';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*. Required.';
          in: 'query';
          name: 'accountId';
          schema: {
            example: '5b10ac8d82e05b22cc7d4ef5';
            maxLength: 128;
            type: 'string';
          };
          'x-showInExample': 'true';
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if `accountId` is not supplied.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the permission to manage the watcher list.';
        };
        '404': {
          description: 'Returned if the issue or the user is not found or the user does not have permission to view the issue.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Delete watcher';
      tags: ['Issue watchers'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue.watcher:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: 'Returns the watchers for an issue.\n\nThis operation requires the **Allow users to watch issues** option to be *ON*. This option is set in General configuration for Jira. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is ini\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  To see details of users on the watchlist other than themselves, *View voters and watchers* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.';
      operationId: 'getIssueWatchers';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isWatching":false,"self":"https://your-domain.atlassian.net/rest/api/3/issue/EX-1/watchers","watchCount":1,"watchers":[{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"}]}';
              schema: {
                $ref: '#/components/schemas/Watchers';
              };
            };
          };
          description: 'Returned if the request is successful';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if the issue is not found or the user does not have permission to view it.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get issue watchers';
      tags: ['Issue watchers'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue.watcher:jira', 'read:user:jira', 'read:avatar:jira'];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Adds a user as a watcher of an issue by passing the account ID of the user. For example, `"5b10ac8d82e05b22cc7d4ef5"`. If no user is specified the calling user is added.\n\nThis operation requires the **Allow users to watch issues** option to be *ON*. This option is set in General configuration for Jira. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  To add users other than themselves to the watchlist, *Manage watcher list* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.';
      operationId: 'addWatcher';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              type: 'string';
            };
          };
        };
        description: 'The account ID of the user. Note that username cannot be used due to privacy changes.';
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the permission to manage the watcher list.';
        };
        '404': {
          description: 'Returned if the issue or the user is not found or the user does not have permission to view the issue.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Add watcher';
      tags: ['Issue watchers'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue.watcher:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/worklog': {
    delete: {
      deprecated: false;
      description: "Deletes a list of worklogs from an issue. This is an experimental API with limitations:\n\n *  You can't delete more than 5000 worklogs at once.\n *  No notifications will be sent for deleted worklogs.\n\nTime tracking must be enabled in Jira, otherwise this operation returns an error. For more information, see [Configuring time tracking](https://confluence.atlassian.com/x/qoXKM).\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project containing the issue.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  *Delete all worklogs*[ project permission](https://confluence.atlassian.com/x/yodKLg) to delete any worklog.\n *  If any worklog has visibility restrictions, belongs to the group or has the role visibility is restricted to.";
      operationId: 'bulkDeleteWorklogs';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "Defines how to update the issue's time estimate, the options are:\n\n *  `leave` Leaves the estimate unchanged.\n *  `auto` Reduces the estimate by the aggregate value of `timeSpent` across all worklogs being deleted.";
          in: 'query';
          name: 'adjustEstimate';
          schema: {
            default: 'auto';
            enum: ['leave', 'auto'];
            type: 'string';
          };
        },
        {
          description: 'Whether the work log entries should be removed to the issue even if the issue is not editable, because jira.issue.editable set to false or missing. For example, the issue is closed. Connect and Forge app users with admin permission can use this flag.';
          in: 'query';
          name: 'overrideEditableFlag';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              ids: [1, 2, 5, 10];
            };
            schema: {
              $ref: '#/components/schemas/WorklogIdsRequestBean';
            };
          };
        };
        description: 'A JSON object containing a list of worklog IDs.';
        required: true;
      };
      responses: {
        '200': {
          description: 'Returned if the bulk deletion request was partially successful, with a message indicating partial success.';
        };
        '204': {
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if:\n\n *  `request` is not provided or is invalid\n *  the user does not have permission to delete the worklogs\n *  the number of worklogs being deleted exceeds the limit';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect.';
        };
        '404': {
          description: 'Returned if:\n\n *  the issue is not found or user does not have permission to view the issue\n *  at least one of the worklogs is not associated with the provided issue\n *  time tracking is disabled';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Bulk delete worklogs';
      tags: ['Issue worklogs'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'delete:issue-worklog:jira',
            'delete:issue-worklog.property:jira',
            'write:issue.time-tracking:jira',
            'read:group:jira',
            'read:issue-worklog:jira',
            'read:project-role:jira',
            'read:user:jira',
            'read:issue-worklog.property:jira',
          ];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
    get: {
      deprecated: false;
      description: 'Returns worklogs for an issue (ordered by created time), starting from the oldest worklog or from the worklog started on or after a date and time.\n\nTime tracking must be enabled in Jira, otherwise this operation returns an error. For more information, see [Configuring time tracking](https://confluence.atlassian.com/x/qoXKM).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** Workloads are only returned where the user has:\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  If the worklog has visibility restrictions, belongs to the group or has the role visibility is restricted to.';
      operationId: 'getIssueWorklog';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 5000;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The worklog start date and time, as a UNIX timestamp in milliseconds, after which worklogs are returned.';
          in: 'query';
          name: 'startedAfter';
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The worklog start date and time, as a UNIX timestamp in milliseconds, before which worklogs are returned.';
          in: 'query';
          name: 'startedBefore';
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'Use [expand](#expansion) to include additional information about worklogs in the response. This parameter accepts`properties`, which returns worklog properties.';
          in: 'query';
          name: 'expand';
          schema: {
            default: '';
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"maxResults":1,"startAt":0,"total":1,"worklogs":[{"author":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"comment":{"type":"doc","version":1,"content":[{"type":"paragraph","content":[{"type":"text","text":"I did some work here."}]}]},"id":"100028","issueId":"10002","self":"https://your-domain.atlassian.net/rest/api/3/issue/10010/worklog/10000","started":"2021-01-17T12:34:00.000+0000","timeSpent":"3h 20m","timeSpentSeconds":12000,"updateAuthor":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"updated":"2021-01-18T23:45:00.000+0000","visibility":{"identifier":"276f955c-63d7-42c8-9520-92d01dca0625","type":"group","value":"jira-developers"}}]}';
              schema: {
                $ref: '#/components/schemas/PageOfWorklogs';
              };
            };
          };
          description: 'Returned if the request is successful';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if:\n\n *  the issue is not found or the user does not have permission to view the issue.\n *  `startAt` or `maxResults` has non-numeric values.\n *  time tracking is disabled.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get issue worklogs';
      tags: ['Issue worklogs'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:group:jira',
            'read:issue-worklog:jira',
            'read:issue-worklog.property:jira',
            'read:project-role:jira',
            'read:user:jira',
            'read:avatar:jira',
          ];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Adds a worklog to an issue.\n\nTime tracking must be enabled in Jira, otherwise this operation returns an error. For more information, see [Configuring time tracking](https://confluence.atlassian.com/x/qoXKM).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* and *Work on issues* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.';
      operationId: 'addWorklog';
      parameters: [
        {
          description: 'The ID or key the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Whether users watching the issue are notified by email.';
          in: 'query';
          name: 'notifyUsers';
          schema: {
            default: true;
            type: 'boolean';
          };
        },
        {
          description: "Defines how to update the issue's time estimate, the options are:\n\n *  `new` Sets the estimate to a specific value, defined in `newEstimate`.\n *  `leave` Leaves the estimate unchanged.\n *  `manual` Reduces the estimate by amount specified in `reduceBy`.\n *  `auto` Reduces the estimate by the value of `timeSpent` in the worklog.";
          in: 'query';
          name: 'adjustEstimate';
          schema: {
            default: 'auto';
            enum: ['new', 'leave', 'manual', 'auto'];
            type: 'string';
          };
        },
        {
          description: "The value to set as the issue's remaining time estimate, as days (\\#d), hours (\\#h), or minutes (\\#m or \\#). For example, *2d*. Required when `adjustEstimate` is `new`.";
          in: 'query';
          name: 'newEstimate';
          schema: {
            type: 'string';
          };
        },
        {
          description: "The amount to reduce the issue's remaining estimate by, as days (\\#d), hours (\\#h), or minutes (\\#m). For example, *2d*. Required when `adjustEstimate` is `manual`.";
          in: 'query';
          name: 'reduceBy';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Use [expand](#expansion) to include additional information about work logs in the response. This parameter accepts `properties`, which returns worklog properties.';
          in: 'query';
          name: 'expand';
          schema: {
            default: '';
            type: 'string';
          };
        },
        {
          description: 'Whether the worklog entry should be added to the issue even if the issue is not editable, because jira.issue.editable set to false or missing. For example, the issue is closed. Connect and Forge app users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) can use this flag.';
          in: 'query';
          name: 'overrideEditableFlag';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              comment: {
                content: [
                  {
                    content: [
                      {
                        text: 'I did some work here.';
                        type: 'text';
                      },
                    ];
                    type: 'paragraph';
                  },
                ];
                type: 'doc';
                version: 1;
              };
              started: '2021-01-17T12:34:00.000+0000';
              timeSpentSeconds: 12000;
              visibility: {
                identifier: '276f955c-63d7-42c8-9520-92d01dca0625';
                type: 'group';
              };
            };
            schema: {
              $ref: '#/components/schemas/Worklog';
            };
          };
        };
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/Worklog';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if:\n\n *  `adjustEstimate` is set to `new` but `newEstimate` is not provided or is invalid.\n *  `adjustEstimate` is set to `manual` but `reduceBy` is not provided or is invalid.\n *  the user does not have permission to add the worklog.\n *  the request JSON is malformed.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect.';
        };
        '404': {
          description: 'Returned if the issue is not found or the user does not have permission to view it.';
        };
        '413': {
          description: 'Returned if the per-issue limit has been breached for one of the following fields:\n\n *  worklogs\n *  attachments';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Add worklog';
      tags: ['Issue worklogs'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'write:issue-worklog:jira',
            'write:issue-worklog.property:jira',
            'read:avatar:jira',
            'read:group:jira',
            'read:issue-worklog:jira',
            'read:project-role:jira',
            'read:user:jira',
            'read:issue-worklog.property:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/worklog/move': {
    post: {
      deprecated: false;
      description: "Moves a list of worklogs from one issue to another. This is an experimental API with several limitations:\n\n *  You can't move more than 5000 worklogs at once.\n *  You can't move worklogs containing an attachment.\n *  You can't move worklogs restricted by project roles.\n *  No notifications will be sent for moved worklogs.\n *  No webhooks or events will be sent for moved worklogs.\n *  No issue history will be recorded for moved worklogs.\n *  Time tracking will not be updated for the source and destination issues.\n\nTime tracking must be enabled in Jira, otherwise this operation returns an error. For more information, see [Configuring time tracking](https://confluence.atlassian.com/x/qoXKM).\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the projects containing the source and destination issues.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  *Delete all worklogs*[ and *Edit all worklogs*](https://confluence.atlassian.com/x/yodKLg)[project permission](https://confluence.atlassian.com/x/yodKLg)\n *  If the worklog has visibility restrictions, belongs to the group or has the role visibility is restricted to.";
      operationId: 'bulkMoveWorklogs';
      parameters: [
        {
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Whether the work log entry should be added to the issue even if the issue is not editable, because jira.issue.editable set to false or missing. For example, the issue is closed. Connect and Forge app users with admin permission can use this flag.';
          in: 'query';
          name: 'overrideEditableFlag';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              ids: [1, 2, 5, 10];
              issueIdOrKey: 'ABC-1234';
            };
            schema: {
              $ref: '#/components/schemas/WorklogsMoveRequestBean';
            };
          };
        };
        description: 'A JSON object containing a list of worklog IDs and the ID or key of the destination issue.';
        required: true;
      };
      responses: {
        '200': {
          description: 'Returned if the request is partially successful.';
        };
        '204': {
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if:\n\n *  `request` is not provided or is invalid\n *  the user does not have permission to move the worklogs\n *  the number of worklogs being moved exceeds the limit\n *  the total size of worklogs being moved is too large\n *  any worklog contains attachments';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect.';
        };
        '404': {
          description: 'Returned if:\n\n *  the issue is not found or the user does not have permission to view the issue\n *  at least one of the worklogs is not associated with the provided issue\n *  time tracking is disabled';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Bulk move worklogs';
      tags: ['Issue worklogs'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:issue-worklog:jira',
            'write:issue-worklog:jira',
            'delete:issue-worklog:jira',
            'read:issue-worklog.property:jira',
            'write:issue-worklog.property:jira',
            'delete:issue-worklog.property:jira',
            'write:issue.time-tracking:jira',
            'read:group:jira',
            'read:project-role:jira',
            'read:user:jira',
          ];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/worklog/{id}': {
    delete: {
      deprecated: false;
      description: 'Deletes a worklog from an issue.\n\nTime tracking must be enabled in Jira, otherwise this operation returns an error. For more information, see [Configuring time tracking](https://confluence.atlassian.com/x/qoXKM).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  *Delete all worklogs*[ project permission](https://confluence.atlassian.com/x/yodKLg) to delete any worklog or *Delete own worklogs* to delete worklogs created by the user,\n *  If the worklog has visibility restrictions, belongs to the group or has the role visibility is restricted to.';
      operationId: 'deleteWorklog';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the worklog.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Whether users watching the issue are notified by email.';
          in: 'query';
          name: 'notifyUsers';
          schema: {
            default: true;
            type: 'boolean';
          };
        },
        {
          description: "Defines how to update the issue's time estimate, the options are:\n\n *  `new` Sets the estimate to a specific value, defined in `newEstimate`.\n *  `leave` Leaves the estimate unchanged.\n *  `manual` Increases the estimate by amount specified in `increaseBy`.\n *  `auto` Reduces the estimate by the value of `timeSpent` in the worklog.";
          in: 'query';
          name: 'adjustEstimate';
          schema: {
            default: 'auto';
            enum: ['new', 'leave', 'manual', 'auto'];
            type: 'string';
          };
        },
        {
          description: "The value to set as the issue's remaining time estimate, as days (\\#d), hours (\\#h), or minutes (\\#m or \\#). For example, *2d*. Required when `adjustEstimate` is `new`.";
          in: 'query';
          name: 'newEstimate';
          schema: {
            type: 'string';
          };
        },
        {
          description: "The amount to increase the issue's remaining estimate by, as days (\\#d), hours (\\#h), or minutes (\\#m or \\#). For example, *2d*. Required when `adjustEstimate` is `manual`.";
          in: 'query';
          name: 'increaseBy';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Whether the work log entry should be added to the issue even if the issue is not editable, because jira.issue.editable set to false or missing. For example, the issue is closed. Connect and Forge app users with admin permission can use this flag.';
          in: 'query';
          name: 'overrideEditableFlag';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if:\n\n *  `adjustEstimate` is set to `new` but `newEstimate` is not provided or is invalid.\n *  `adjustEstimate` is set to `manual` but `reduceBy` is not provided or is invalid.\n *  the user does not have permission to delete the worklog.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect.';
        };
        '404': {
          description: 'Returned if:\n\n *  the issue is not found or user does not have permission to view the issue.\n *  the worklog is not found or the user does not have permission to view it.\n *  time tracking is disabled.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Delete worklog';
      tags: ['Issue worklogs'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:issue-worklog:jira', 'delete:issue-worklog.property:jira', 'write:issue.time-tracking:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: 'Returns a worklog.\n\nTime tracking must be enabled in Jira, otherwise this operation returns an error. For more information, see [Configuring time tracking](https://confluence.atlassian.com/x/qoXKM).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  If the worklog has visibility restrictions, belongs to the group or has the role visibility is restricted to.';
      operationId: 'getWorklog';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the worklog.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Use [expand](#expansion) to include additional information about work logs in the response. This parameter accepts\n\n`properties`, which returns worklog properties.';
          in: 'query';
          name: 'expand';
          schema: {
            default: '';
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"author":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"comment":{"type":"doc","version":1,"content":[{"type":"paragraph","content":[{"type":"text","text":"I did some work here."}]}]},"id":"100028","issueId":"10002","self":"https://your-domain.atlassian.net/rest/api/3/issue/10010/worklog/10000","started":"2021-01-17T12:34:00.000+0000","timeSpent":"3h 20m","timeSpentSeconds":12000,"updateAuthor":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"updated":"2021-01-18T23:45:00.000+0000","visibility":{"identifier":"276f955c-63d7-42c8-9520-92d01dca0625","type":"group","value":"jira-developers"}}';
              schema: {
                $ref: '#/components/schemas/Worklog';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect.';
        };
        '404': {
          description: 'Returned if:\n\n *  the issue is not found or the user does not have permission to view it.\n *  the worklog is not found or the user does not have permission to view it.\n *  time tracking is disabled.\n\n.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get worklog';
      tags: ['Issue worklogs'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:comment:jira',
            'read:group:jira',
            'read:issue-worklog:jira',
            'read:issue-worklog.property:jira',
            'read:project-role:jira',
            'read:user:jira',
            'read:avatar:jira',
          ];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Updates a worklog.\n\nTime tracking must be enabled in Jira, otherwise this operation returns an error. For more information, see [Configuring time tracking](https://confluence.atlassian.com/x/qoXKM).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  *Edit all worklogs*[ project permission](https://confluence.atlassian.com/x/yodKLg) to update any worklog or *Edit own worklogs* to update worklogs created by the user.\n *  If the worklog has visibility restrictions, belongs to the group or has the role visibility is restricted to.';
      operationId: 'updateWorklog';
      parameters: [
        {
          description: 'The ID or key the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the worklog.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Whether users watching the issue are notified by email.';
          in: 'query';
          name: 'notifyUsers';
          schema: {
            default: true;
            type: 'boolean';
          };
        },
        {
          description: "Defines how to update the issue's time estimate, the options are:\n\n *  `new` Sets the estimate to a specific value, defined in `newEstimate`.\n *  `leave` Leaves the estimate unchanged.\n *  `auto` Updates the estimate by the difference between the original and updated value of `timeSpent` or `timeSpentSeconds`.";
          in: 'query';
          name: 'adjustEstimate';
          schema: {
            default: 'auto';
            enum: ['new', 'leave', 'manual', 'auto'];
            type: 'string';
          };
        },
        {
          description: "The value to set as the issue's remaining time estimate, as days (\\#d), hours (\\#h), or minutes (\\#m or \\#). For example, *2d*. Required when `adjustEstimate` is `new`.";
          in: 'query';
          name: 'newEstimate';
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Use [expand](#expansion) to include additional information about worklogs in the response. This parameter accepts `properties`, which returns worklog properties.';
          in: 'query';
          name: 'expand';
          schema: {
            default: '';
            type: 'string';
          };
        },
        {
          description: 'Whether the worklog should be added to the issue even if the issue is not editable. For example, because the issue is closed. Connect and Forge app users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) can use this flag.';
          in: 'query';
          name: 'overrideEditableFlag';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              comment: {
                content: [
                  {
                    content: [
                      {
                        text: 'I did some work here.';
                        type: 'text';
                      },
                    ];
                    type: 'paragraph';
                  },
                ];
                type: 'doc';
                version: 1;
              };
              started: '2021-01-17T12:34:00.000+0000';
              timeSpentSeconds: 12000;
              visibility: {
                identifier: '276f955c-63d7-42c8-9520-92d01dca0625';
                type: 'group';
              };
            };
            schema: {
              $ref: '#/components/schemas/Worklog';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"author":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"comment":{"type":"doc","version":1,"content":[{"type":"paragraph","content":[{"type":"text","text":"I did some work here."}]}]},"id":"100028","issueId":"10002","self":"https://your-domain.atlassian.net/rest/api/3/issue/10010/worklog/10000","started":"2021-01-17T12:34:00.000+0000","timeSpent":"3h 20m","timeSpentSeconds":12000,"updateAuthor":{"accountId":"5b10a2844c20165700ede21g","active":false,"displayName":"Mia Krystof","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g"},"updated":"2021-01-18T23:45:00.000+0000","visibility":{"identifier":"276f955c-63d7-42c8-9520-92d01dca0625","type":"group","value":"jira-developers"}}';
              schema: {
                $ref: '#/components/schemas/Worklog';
              };
            };
          };
          description: 'Returned if the request is successful';
        };
        '400': {
          description: 'Returned if:\n\n *  `adjustEstimate` is set to `new` but `newEstimate` is not provided or is invalid.\n *  the user does not have permission to update the worklog.\n *  the request JSON is malformed.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect.';
        };
        '404': {
          description: 'Returned if:\n\n *  the issue is not found or user does not have permission to view the issue.\n *  the worklog is not found or the user does not have permission to view it.\n *  time tracking is disabled.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Update worklog';
      tags: ['Issue worklogs'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:comment:jira',
            'read:group:jira',
            'read:issue-worklog:jira',
            'read:issue-worklog.property:jira',
            'read:project-role:jira',
            'read:user:jira',
            'write:comment:jira',
            'write:issue-worklog:jira',
            'write:issue-worklog.property:jira',
            'read:avatar:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/worklog/{worklogId}/properties': {
    get: {
      deprecated: false;
      description: 'Returns the keys of all properties for a worklog.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  If the worklog has visibility restrictions, belongs to the group or has the role visibility is restricted to.';
      operationId: 'getWorklogPropertyKeys';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the worklog.';
          in: 'path';
          name: 'worklogId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"keys":[{"key":"issue.support","self":"https://your-domain.atlassian.net/rest/api/3/issue/EX-2/properties/issue.support"}]}';
              schema: {
                $ref: '#/components/schemas/PropertyKeys';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the worklog ID is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if:\n\n *  the issue or worklog is not found.\n *  the user does not have permission to view the issue or worklog.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get worklog property keys';
      tags: ['Issue worklog properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-worklog.property:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issue/{issueIdOrKey}/worklog/{worklogId}/properties/{propertyKey}': {
    delete: {
      deprecated: false;
      description: 'Deletes a worklog property.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  If the worklog has visibility restrictions, belongs to the group or has the role visibility is restricted to.';
      operationId: 'deleteWorklogProperty';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the worklog.';
          in: 'path';
          name: 'worklogId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The key of the property.';
          in: 'path';
          name: 'propertyKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the worklog property is removed.';
        };
        '400': {
          description: 'Returned if the worklog key or id is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have permission to edit the worklog.';
        };
        '404': {
          description: 'Returned if:\n\n *  the issue, worklog, or property is not found.\n *  the user does not have permission to view the issue or worklog.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Delete worklog property';
      tags: ['Issue worklog properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:issue-worklog.property:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: 'Returns the value of a worklog property.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  If the worklog has visibility restrictions, belongs to the group or has the role visibility is restricted to.';
      operationId: 'getWorklogProperty';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the worklog.';
          in: 'path';
          name: 'worklogId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The key of the property.';
          in: 'path';
          name: 'propertyKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"key":"issue.support","value":{"system.conversation.id":"b1bf38be-5e94-4b40-a3b8-9278735ee1e6","system.support.time":"1m"}}';
              schema: {
                $ref: '#/components/schemas/EntityProperty';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the worklog ID is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if:\n\n *  the issue, worklog, or property is not found.\n *  the user does not have permission to view the issue or worklog.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get worklog property';
      tags: ['Issue worklog properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-worklog.property:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Sets the value of a worklog property. Use this operation to store custom data against the worklog.\n\nThe value of the request body must be a [valid](http://tools.ietf.org/html/rfc4627), non-empty JSON blob. The maximum length is 32768 characters.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project that the issue is in.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  *Edit all worklogs*[ project permission](https://confluence.atlassian.com/x/yodKLg) to update any worklog or *Edit own worklogs* to update worklogs created by the user.\n *  If the worklog has visibility restrictions, belongs to the group or has the role visibility is restricted to.';
      operationId: 'setWorklogProperty';
      parameters: [
        {
          description: 'The ID or key of the issue.';
          in: 'path';
          name: 'issueIdOrKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the worklog.';
          in: 'path';
          name: 'worklogId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The key of the issue property. The maximum length is 255 characters.';
          in: 'path';
          name: 'propertyKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {};
          };
        };
        description: 'The value of the property. The value has to be a valid, non-empty [JSON](https://tools.ietf.org/html/rfc4627) value. The maximum length of the property value is 32768 bytes.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the worklog property is updated.';
        };
        '201': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the worklog property is created.';
        };
        '400': {
          description: 'Returned if the worklog ID is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have permission to edit the worklog.';
        };
        '404': {
          description: 'Returned if:\n\n *  the issue or worklog is not found.\n *  the user does not have permission to view the issue or worklog.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Set worklog property';
      tags: ['Issue worklog properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue-worklog.property:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issueLink': {
    post: {
      deprecated: false;
      description: 'Creates a link between two issues. Use this operation to indicate a relationship between two issues and optionally add a comment to the from (outward) issue. To use this resource the site must have [Issue Linking](https://confluence.atlassian.com/x/yoXKM) enabled.\n\nThis resource returns nothing on the creation of an issue link. To obtain the ID of the issue link, use `https://your-domain.atlassian.net/rest/api/3/issue/[linked issue key]?fields=issuelinks`.\n\nIf the link request duplicates a link, the response indicates that the issue link was created. If the request included a comment, the comment is added.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse project* [project permission](https://confluence.atlassian.com/x/yodKLg) for all the projects containing the issues to be linked,\n *  *Link issues* [project permission](https://confluence.atlassian.com/x/yodKLg) on the project containing the from (outward) issue,\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, issue-level security permission to view the issue.\n *  If the comment has visibility restrictions, belongs to the group or has the role visibility is restricted to.';
      operationId: 'linkIssues';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              comment: {
                body: {
                  content: [
                    {
                      content: [
                        {
                          text: 'Linked related issue!';
                          type: 'text';
                        },
                      ];
                      type: 'paragraph';
                    },
                  ];
                  type: 'doc';
                  version: 1;
                };
                visibility: {
                  identifier: '276f955c-63d7-42c8-9520-92d01dca0625';
                  type: 'group';
                  value: 'jira-software-users';
                };
              };
              inwardIssue: {
                key: 'HSP-1';
              };
              outwardIssue: {
                key: 'MKY-1';
              };
              type: {
                name: 'Duplicate';
              };
            };
            schema: {
              $ref: '#/components/schemas/LinkIssueRequestJsonBean';
            };
          };
        };
        description: 'The issue link request.';
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: "Returned if the comment is not created. The response contains an error message indicating why the comment wasn't created. The issue link is also not created.";
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: "Returned if:\n\n *  issue linking is disabled.\n *  the user cannot view one or both of the issues. For example, the user doesn't have *Browse project* project permission for a project containing one of the issues.\n *  the user does not have *link issues* project permission.\n *  either of the link issues are not found.\n *  the issue link type is not found.";
        };
        '413': {
          description: 'Returned if the per-issue limit for issue links has been breached.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Create issue link';
      tags: ['Issue links'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:comment:jira', 'write:issue:jira', 'write:issue-link:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issueLink/{linkId}': {
    delete: {
      deprecated: false;
      description: 'Deletes an issue link.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  Browse project [project permission](https://confluence.atlassian.com/x/yodKLg) for all the projects containing the issues in the link.\n *  *Link issues* [project permission](https://confluence.atlassian.com/x/yodKLg) for at least one of the projects containing issues in the link.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, permission to view both of the issues.';
      operationId: 'deleteIssueLink';
      parameters: [
        {
          description: 'The ID of the issue link.';
          in: 'path';
          name: 'linkId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: '200 response';
        };
        '204': {
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the issue link ID is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: "Returned if:\n\n *  issue linking is disabled.\n *  the issue link is not found.\n *  the user doesn't have the required permissions.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['write:jira-work'];
        },
        {},
      ];
      summary: 'Delete issue link';
      tags: ['Issue links'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['write:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:issue-link:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: 'Returns an issue link.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Browse project* [project permission](https://confluence.atlassian.com/x/yodKLg) for all the projects containing the linked issues.\n *  If [issue-level security](https://confluence.atlassian.com/x/J4lKLg) is configured, permission to view both of the issues.';
      operationId: 'getIssueLink';
      parameters: [
        {
          description: 'The ID of the issue link.';
          in: 'path';
          name: 'linkId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"id":"10001","inwardIssue":{"fields":{"issuetype":{"avatarId":10002,"description":"A problem with the software.","entityId":"9d7dd6f7-e8b6-4247-954b-7b2c9b2a5ba2","hierarchyLevel":0,"iconUrl":"https://your-domain.atlassian.net/secure/viewavatar?size=xsmall&avatarId=10316&avatarType=issuetype\\",","id":"1","name":"Bug","scope":{"project":{"id":"10000"},"type":"PROJECT"},"self":"https://your-domain.atlassian.net/rest/api/3/issueType/1","subtask":false},"priority":{"description":"Very little impact.","iconUrl":"https://your-domain.atlassian.net/images/icons/priorities/trivial.png","id":"2","name":"Trivial","self":"https://your-domain.atlassian.net/rest/api/3/priority/5","statusColor":"#cfcfcf"},"status":{"description":"The issue is closed.","iconUrl":"https://your-domain.atlassian.net/images/icons/closed.gif","id":"5","name":"Closed","self":"https://your-domain.atlassian.net/rest/api/3/status/5","statusCategory":{"colorName":"green","id":9,"key":"completed","self":"https://your-domain.atlassian.net/rest/api/3/statuscategory/9"}}},"id":"10004","key":"PR-3","self":"https://your-domain.atlassian.net/rest/api/3/issue/PR-3"},"outwardIssue":{"fields":{"issuetype":{"avatarId":1,"description":"A task that needs to be done.","hierarchyLevel":0,"iconUrl":"https://your-domain.atlassian.net/secure/viewavatar?size=xsmall&avatarId=10299&avatarType=issuetype\\",","id":"3","name":"Task","self":"https://your-domain.atlassian.net/rest/api/3/issueType/3","subtask":false},"priority":{"description":"Major loss of function.","iconUrl":"https://your-domain.atlassian.net/images/icons/priorities/major.png","id":"1","name":"Major","self":"https://your-domain.atlassian.net/rest/api/3/priority/3","statusColor":"#009900"},"status":{"description":"The issue is currently being worked on.","iconUrl":"https://your-domain.atlassian.net/images/icons/progress.gif","id":"10000","name":"In Progress","self":"https://your-domain.atlassian.net/rest/api/3/status/10000","statusCategory":{"colorName":"yellow","id":1,"key":"in-flight","name":"In Progress","self":"https://your-domain.atlassian.net/rest/api/3/statuscategory/1"}}},"id":"10004L","key":"PR-2","self":"https://your-domain.atlassian.net/rest/api/3/issue/PR-2"},"type":{"id":"1000","inward":"Duplicated by","name":"Duplicate","outward":"Duplicates","self":"https://your-domain.atlassian.net/rest/api/3/issueLinkType/1000"}}';
              schema: {
                $ref: '#/components/schemas/IssueLink';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the issue link ID is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: "Returned if:\n\n *  issue linking is disabled.\n *  the issue link is not found.\n *  the user doesn't have the required permissions.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get issue link';
      tags: ['Issue links'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'read:field:jira',
            'read:issue-link-type:jira',
            'read:issue:jira',
            'read:issue-type:jira',
            'read:priority:jira',
            'read:status:jira',
            'read:avatar:jira',
            'read:issue.time-tracking:jira',
            'read:project-category:jira',
            'read:project:jira',
            'read:user:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issueLinkType': {
    get: {
      deprecated: false;
      description: 'Returns a list of all issue link types.\n\nTo use this operation, the site must have [issue linking](https://confluence.atlassian.com/x/yoXKM) enabled.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for a project in the site.';
      operationId: 'getIssueLinkTypes';
      parameters: [];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"issueLinkTypes":[{"id":"1000","inward":"Duplicated by","name":"Duplicate","outward":"Duplicates","self":"https://your-domain.atlassian.net/rest/api/3/issueLinkType/1000"},{"id":"1010","inward":"Blocked by","name":"Blocks","outward":"Blocks","self":"https://your-domain.atlassian.net/rest/api/3/issueLinkType/1010"}]}';
              schema: {
                $ref: '#/components/schemas/IssueLinkTypes';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if issue linking is disabled.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get issue link types';
      tags: ['Issue link types'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-link-type:jira'];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: "Creates an issue link type. Use this operation to create descriptions of the reasons why issues are linked. The issue link type consists of a name and descriptions for a link's inward and outward relationships.\n\nTo use this operation, the site must have [issue linking](https://confluence.atlassian.com/x/yoXKM) enabled.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).";
      operationId: 'createIssueLinkType';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              inward: 'Duplicated by';
              name: 'Duplicate';
              outward: 'Duplicates';
            };
            schema: {
              $ref: '#/components/schemas/IssueLinkType';
            };
          };
        };
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              example: '{"id":"1000","inward":"Duplicated by","name":"Duplicate","outward":"Duplicates","self":"https://your-domain.atlassian.net/rest/api/3/issueLinkType/1000"}';
              schema: {
                $ref: '#/components/schemas/IssueLinkType';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if:\n\n *  issue linking is disabled.\n *  the issue link type name is in use.\n *  the user does not have the required permissions.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
        {},
      ];
      summary: 'Create issue link type';
      tags: ['Issue link types'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue-link-type:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issueLinkType/{issueLinkTypeId}': {
    delete: {
      deprecated: false;
      description: 'Deletes an issue link type.\n\nTo use this operation, the site must have [issue linking](https://confluence.atlassian.com/x/yoXKM) enabled.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'deleteIssueLinkType';
      parameters: [
        {
          description: 'The ID of the issue link type.';
          in: 'path';
          name: 'issueLinkTypeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the issue link type ID is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if:\n\n *  issue linking is disabled.\n *  the issue link type is not found.\n *  the user does not have the required permissions.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
        {},
      ];
      summary: 'Delete issue link type';
      tags: ['Issue link types'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:issue-link-type:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: 'Returns an issue link type.\n\nTo use this operation, the site must have [issue linking](https://confluence.atlassian.com/x/yoXKM) enabled.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for a project in the site.';
      operationId: 'getIssueLinkType';
      parameters: [
        {
          description: 'The ID of the issue link type.';
          in: 'path';
          name: 'issueLinkTypeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"id":"1000","inward":"Duplicated by","name":"Duplicate","outward":"Duplicates","self":"https://your-domain.atlassian.net/rest/api/3/issueLinkType/1000"}';
              schema: {
                $ref: '#/components/schemas/IssueLinkType';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the issue link type ID is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if:\n\n *  issue linking is disabled.\n *  the issue link type is not found.\n *  the user does not have the required permissions.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get issue link type';
      tags: ['Issue link types'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-link-type:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Updates an issue link type.\n\nTo use this operation, the site must have [issue linking](https://confluence.atlassian.com/x/yoXKM) enabled.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'updateIssueLinkType';
      parameters: [
        {
          description: 'The ID of the issue link type.';
          in: 'path';
          name: 'issueLinkTypeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              inward: 'Duplicated by';
              name: 'Duplicate';
              outward: 'Duplicates';
            };
            schema: {
              $ref: '#/components/schemas/IssueLinkType';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"id":"1000","inward":"Duplicated by","name":"Duplicate","outward":"Duplicates","self":"https://your-domain.atlassian.net/rest/api/3/issueLinkType/1000"}';
              schema: {
                $ref: '#/components/schemas/IssueLinkType';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the issue link type ID or the request body are invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if:\n\n *  issue linking is disabled.\n *  the issue link type is not found.\n *  the user does not have the required permissions.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
        {},
      ];
      summary: 'Update issue link type';
      tags: ['Issue link types'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-link-type:jira', 'write:issue-link-type:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issues/archive/export': {
    put: {
      deprecated: false;
      description: "Enables admins to retrieve details of all archived issues. Upon a successful request, the admin who submitted it will receive an email with a link to download a CSV file with the issue details.\n\nNote that this API only exports the values of system fields and archival-specific fields (`ArchivedBy` and `ArchivedDate`). Custom fields aren't supported.\n\n**[Permissions](#permissions) required:** Jira admin or site admin: [global permission](https://confluence.atlassian.com/x/x4dKLg)\n\n**License required:** Premium or Enterprise\n\n**Signed-in users only:** This API can't be accessed anonymously.\n\n**Rate limiting:** Only a single request can be active at any given time.\n\n  \n";
      operationId: 'exportArchivedIssues';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              archivedBy: ['uuid-rep-001', 'uuid-rep-002'];
              archivedDate: {
                dateAfter: '2023-01-01';
                dateBefore: '2023-01-12';
              };
              archivedDateRange: {
                dateAfter: '2023-01-01';
                dateBefore: '2023-01-12';
              };
              issueTypes: ['10001', '10002'];
              projects: ['FOO', 'BAR'];
              reporters: ['uuid-rep-001', 'uuid-rep-002'];
            };
            schema: {
              $ref: '#/components/schemas/ArchivedIssuesFilterRequest';
            };
          };
        };
        description: "You can filter the issues in your request by the `projects`, `archivedBy`, `archivedDate`, `issueTypes`, and `reporters` fields. All filters are optional. If you don't provide any filters, you'll get a list of up to one million archived issues.";
        required: true;
      };
      responses: {
        '202': {
          content: {
            'application/json': {
              example: '{"payload":"{projects=[FOO, BAR], reporters=[uuid-rep-001, uuid-rep-002], issueTypes=[10001, 10002], archivedDate={dateAfterInstant=2023-01-01, dateBeforeInstant=2023-01-12}, archivedBy=[uuid-rep-001, uuid-rep-002]}","progress":0,"status":"ENQUEUED","submittedTime":1623230887000,"taskId":"10990"}';
              schema: {
                $ref: '#/components/schemas/ExportArchivedIssuesTaskProgressResponse';
              };
            };
          };
          description: 'Returns the details of your export task. You can use the [get task](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-tasks/#api-rest-api-3-task-taskid-get) API to view the progress of your request.';
        };
        '400': {
          content: {
            'application/json': {
              example: '["Your filter contains invalid values {errorMessage}"]';
            };
          };
          description: 'Returned when:\n\n *  The request is invalid, or the filters provided are incorrect\n *  You requested too many issues for export. The limit is one million issues per request';
        };
        '401': {
          content: {
            'application/json': {
              example: '{"errorMessages":["User is not logged in."],"errors":{}}';
            };
          };
          description: 'Returned if no issues were unarchived because the provided authentication credentials are either missing or invalid.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["User is not an admin."],"errors":{}}';
            };
          };
          description: 'Returned if no issues were unarchived because the user lacks the required Jira admin or site admin permissions.';
        };
        '412': {
          content: {
            'application/json': {
              example: '{"errorMessages":["An issue archival task is already running with ID 1010. To start a new one, cancel the task or wait for it to finish."],"errors":{}}';
            };
          };
          description: 'Returned if a request to export archived issues is already running.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
      ];
      summary: 'Export archived issue(s)';
      tags: ['Issues'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': false;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issuesecurityschemes': {
    get: {
      deprecated: false;
      description: 'Returns all [issue security schemes](https://confluence.atlassian.com/x/J4lKLg).\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getIssueSecuritySchemes';
      parameters: [];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"issueSecuritySchemes":[{"defaultSecurityLevelId":10021,"description":"Description for the default issue security scheme","id":10000,"name":"Default Issue Security Scheme","self":"https://your-domain.atlassian.net/rest/api/3/issuesecurityschemes/10000"}]}';
              schema: {
                $ref: '#/components/schemas/SecuritySchemes';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect.';
        };
        '403': {
          description: 'Returned if the user does not have permission to administer issue security schemes.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-project'];
        },
      ];
      summary: 'Get issue security schemes';
      tags: ['Issue security schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-project'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-security-level:jira', 'read:issue-security-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: "Creates a security scheme with security scheme levels and levels' members. You can create up to 100 security scheme levels and security scheme levels' members per request.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).";
      operationId: 'createIssueSecurityScheme';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              description: 'Newly created issue security scheme';
              levels: [
                {
                  description: 'Newly created level';
                  isDefault: true;
                  members: [
                    {
                      parameter: 'administrators';
                      type: 'group';
                    },
                  ];
                  name: 'New level';
                },
              ];
              name: 'New security scheme';
            };
            schema: {
              $ref: '#/components/schemas/CreateIssueSecuritySchemeDetails';
            };
          };
        };
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              example: '{"id":"10001"}';
              schema: {
                $ref: '#/components/schemas/SecuritySchemeId';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The length of the description must not exceed 4,000 characters."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["You are not authorized to perform this action. Administrator privileges are required."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the user doesn't have the necessary permission.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Create issue security scheme';
      tags: ['Issue security schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issuesecurityschemes/level': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of issue security levels.\n\nOnly issue security levels in the context of classic projects are returned.\n\nFiltering using IDs is inclusive: if you specify both security scheme IDs and level IDs, the result will include both specified issue security levels and all issue security levels from the specified schemes.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getSecurityLevels';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: '0';
            type: 'string';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: '50';
            type: 'string';
          };
        },
        {
          description: 'The list of issue security scheme level IDs. To include multiple issue security levels, separate IDs with an ampersand: `id=10000&id=10001`.';
          in: 'query';
          name: 'id';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: 'The list of issue security scheme IDs. To include multiple issue security schemes, separate IDs with an ampersand: `schemeId=10000&schemeId=10001`.';
          in: 'query';
          name: 'schemeId';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: 'When set to true, returns multiple default levels for each security scheme containing a default. If you provide scheme and level IDs not associated with the default, returns an empty page. The default value is false.';
          in: 'query';
          name: 'onlyDefault';
          schema: {
            default: false;
            type: 'boolean';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":50,"startAt":0,"total":1,"values":[{"description":"Only the reporter and internal staff can see this issue.","id":"10021","isDefault":true,"issueSecuritySchemeId":"10001","name":"Reporter Only","self":"https://your-domain.atlassian.net/rest/api/3/issuesecurityscheme/level?id=10021"}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanSecurityLevel';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["-1000 is not a valid value. id must be zero or a positive integer."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["You are not authorized to perform this action. Administrator privileges are required."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the user doesn't have the necessary permission.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get issue security levels';
      tags: ['Issue security schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-security-level:jira', 'read:issue-security-scheme:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issuesecurityschemes/level/default': {
    put: {
      deprecated: false;
      description: 'Sets default issue security levels for schemes.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'setDefaultLevels';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              defaultValues: [
                {
                  defaultLevelId: '20000';
                  issueSecuritySchemeId: '10000';
                },
                {
                  defaultLevelId: '30000';
                  issueSecuritySchemeId: '12000';
                },
              ];
            };
            schema: {
              $ref: '#/components/schemas/SetDefaultLevelsRequest';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["some-wrong-string is not a valid value. The issue security scheme ID must be a positive integer."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["You are not authorized to perform this action. Administrator privileges are required."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the user doesn't have the necessary permission.";
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Issue security scheme with ID 10000 not found."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the issue resolution isn't found.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Set default issue security levels';
      tags: ['Issue security schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issuesecurityschemes/level/member': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of issue security level members.\n\nOnly issue security level members in the context of classic projects are returned.\n\nFiltering using parameters is inclusive: if you specify both security scheme IDs and level IDs, the result will include all issue security level members from the specified schemes and levels.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getSecurityLevelMembers';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: '0';
            type: 'string';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: '50';
            type: 'string';
          };
        },
        {
          description: 'The list of issue security level member IDs. To include multiple issue security level members separate IDs with an ampersand: `id=10000&id=10001`.';
          in: 'query';
          name: 'id';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: 'The list of issue security scheme IDs. To include multiple issue security schemes separate IDs with an ampersand: `schemeId=10000&schemeId=10001`.';
          in: 'query';
          name: 'schemeId';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: 'The list of issue security level IDs. To include multiple issue security levels separate IDs with an ampersand: `levelId=10000&levelId=10001`.';
          in: 'query';
          name: 'levelId';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: 'Use expand to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:\n\n *  `all` Returns all expandable information\n *  `field` Returns information about the custom field granted the permission\n *  `group` Returns information about the group that is granted the permission\n *  `projectRole` Returns information about the project role granted the permission\n *  `user` Returns information about the user who is granted the permission';
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":100,"startAt":0,"total":3,"values":[{"id":"10000","issueSecurityLevelId":"20010","issueSecuritySchemeId":"10010","holder":{"expand":"group","type":"group"}}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanSecurityLevelMember';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["You are not authorized to perform this action. Administrator privileges are required."],"errors":{}}';
            };
          };
          description: "Returned if the user doesn't have the necessary permission.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get issue security level members';
      tags: ['Issue security schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-security-level:jira', 'read:issue-security-scheme:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issuesecurityschemes/project': {
    get: {
      deprecated: false;
      description: "Returns a [paginated](#pagination) mapping of projects that are using security schemes. You can provide either one or multiple security scheme IDs or project IDs to filter by. If you don't provide any, this will return a list of all mappings. Only issue security schemes in the context of classic projects are supported. **[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).";
      operationId: 'searchProjectsUsingSecuritySchemes';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: '0';
            type: 'string';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: '50';
            type: 'string';
          };
        },
        {
          description: 'The list of security scheme IDs to be filtered out.';
          in: 'query';
          name: 'issueSecuritySchemeId';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: 'The list of project IDs to be filtered out.';
          in: 'query';
          name: 'projectId';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"issueSecuritySchemeId":"10000","projectId":"10000"}';
              schema: {
                $ref: '#/components/schemas/PageBeanIssueSecuritySchemeToProjectMapping';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the search criteria is invalid.If you specify the project ID parameter';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the user doesn't have the necessary permission.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get projects using issue security schemes';
      tags: ['Issue security schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-experimental': true;
    };
    put: {
      deprecated: false;
      description: 'Associates an issue security scheme with a project and remaps security levels of issues to the new levels, if provided.\n\nThis operation is [asynchronous](#async). Follow the `location` link in the response to determine the status of the task and use [Get task](#api-rest-api-3-task-taskId-get) to obtain subsequent updates.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'associateSchemesToProjects';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              oldToNewSecurityLevelMappings: [
                {
                  newLevelId: '30001';
                  oldLevelId: '30000';
                },
              ];
              projectId: '10000';
              schemeId: '20000';
            };
            schema: {
              $ref: '#/components/schemas/AssociateSecuritySchemeWithProjectDetails';
            };
          };
        };
        required: true;
      };
      responses: {
        '303': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/TaskProgressBeanObject';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["some-wrong-string is not a valid value. The issue security scheme ID must be a positive integer."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["You are not authorized to perform this action. Administrator privileges are required."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the user doesn't have the necessary permission.";
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Issue security scheme with ID 10000 not found."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the security scheme isn't found.";
        };
        '409': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if a task to remove the issue security level is already running.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Associate security scheme to project';
      tags: ['Issue security schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issuesecurityschemes/search': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of issue security schemes.  \nIf you specify the project ID parameter, the result will contain issue security schemes and related project IDs you filter by. Use \\{@link IssueSecuritySchemeResource\\#searchProjectsUsingSecuritySchemes(String, String, Set, Set)\\} to obtain all projects related to scheme.\n\nOnly issue security schemes in the context of classic projects are returned.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'searchSecuritySchemes';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: '0';
            type: 'string';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: '50';
            type: 'string';
          };
        },
        {
          description: 'The list of issue security scheme IDs. To include multiple issue security scheme IDs, separate IDs with an ampersand: `id=10000&id=10001`.';
          in: 'query';
          name: 'id';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: 'The list of project IDs. To include multiple project IDs, separate IDs with an ampersand: `projectId=10000&projectId=10001`.';
          in: 'query';
          name: 'projectId';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"id":10000,"self":"https://your-domain.atlassian.net/rest/api/3/issuesecurityscheme/10000","name":"Default scheme","description":"Default scheme description","defaultLevel":10001,"projectIds":[10002]}';
              schema: {
                $ref: '#/components/schemas/PageBeanSecuritySchemeWithProjects';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["-1000 is not a valid value. id must be zero or a positive integer."],"errors":{}}';
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["You are not authorized to perform this action. Administrator privileges are required."],"errors":{}}';
            };
          };
          description: "Returned if the user doesn't have the necessary permission.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Search issue security schemes';
      tags: ['Issue security schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-security-level:jira', 'read:issue-security-scheme:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issuesecurityschemes/{id}': {
    get: {
      deprecated: false;
      description: 'Returns an issue security scheme along with its security levels.\n\n**[Permissions](#permissions) required:**\n\n *  *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).\n *  *Administer Projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for a project that uses the requested issue security scheme.';
      operationId: 'getIssueSecurityScheme';
      parameters: [
        {
          description: 'The ID of the issue security scheme. Use the [Get issue security schemes](#api-rest-api-3-issuesecurityschemes-get) operation to get a list of issue security scheme IDs.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"defaultSecurityLevelId":10021,"description":"Description for the default issue security scheme","id":10000,"levels":[{"description":"Only the reporter and internal staff can see this issue.","id":"10021","name":"Reporter Only","self":"https://your-domain.atlassian.net/rest/api/3/securitylevel/10021"}],"name":"Default Issue Security Scheme","self":"https://your-domain.atlassian.net/rest/api/3/issuesecurityschemes/10000"}';
              schema: {
                $ref: '#/components/schemas/SecurityScheme';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the administrator permission and the scheme is not used in any project where the user has administrative permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-project'];
        },
      ];
      summary: 'Get issue security scheme';
      tags: ['Issue security schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-project'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-security-level:jira', 'read:issue-security-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Updates the issue security scheme.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'updateIssueSecurityScheme';
      parameters: [
        {
          description: 'The ID of the issue security scheme.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              description: 'My issue security scheme description';
              name: 'My issue security scheme name';
            };
            schema: {
              $ref: '#/components/schemas/UpdateIssueSecuritySchemeRequestBean';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The length of the description must not exceed 4,000 characters."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["You are not authorized to perform this action. Administrator privileges are required."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the user doesn't have the necessary permission.";
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Issue security scheme with ID 10000 not found."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the issue security scheme isn't found.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Update issue security scheme';
      tags: ['Issue security schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issuesecurityschemes/{issueSecuritySchemeId}/members': {
    get: {
      deprecated: false;
      description: 'Returns issue security level members.\n\nOnly issue security level members in context of classic projects are returned.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getIssueSecurityLevelMembers';
      parameters: [
        {
          description: 'The ID of the issue security scheme. Use the [Get issue security schemes](#api-rest-api-3-issuesecurityschemes-get) operation to get a list of issue security scheme IDs.';
          in: 'path';
          name: 'issueSecuritySchemeId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The list of issue security level IDs. To include multiple issue security levels separate IDs with ampersand: `issueSecurityLevelId=10000&issueSecurityLevelId=10001`.';
          in: 'query';
          name: 'issueSecurityLevelId';
          schema: {
            items: {
              type: 'string';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: 'Use expand to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:\n\n *  `all` Returns all expandable information.\n *  `field` Returns information about the custom field granted the permission.\n *  `group` Returns information about the group that is granted the permission.\n *  `projectRole` Returns information about the project role granted the permission.\n *  `user` Returns information about the user who is granted the permission.';
          in: 'query';
          name: 'expand';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":100,"startAt":0,"total":3,"values":[{"id":10000,"issueSecurityLevelId":10020,"holder":{"expand":"user","type":"user","user":{"accountId":"5b10a2844c20165700ede21g","active":true,"avatarUrls":{"16x16":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=16&s=16","24x24":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=24&s=24","32x32":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=32&s=32","48x48":"https://avatar-management--avatars.server-location.prod.public.atl-paas.net/initials/MK-5.png?size=48&s=48"},"displayName":"Mia Krystof","emailAddress":"mia@example.com","self":"https://your-domain.atlassian.net/rest/api/3/user?accountId=5b10a2844c20165700ede21g","timeZone":"Australia/Sydney"}}},{"id":10001,"issueSecurityLevelId":10020,"holder":{"expand":"group","parameter":"jira-core-users","type":"group","value":"9c559b11-6c5d-4f96-992c-a746cabab28b"}},{"id":10002,"issueSecurityLevelId":10021,"holder":{"type":"assignee"}}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanIssueSecurityLevelMember';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if no issue security level members are found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get issue security level members by issue security scheme';
      tags: ['Issue security level'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:field:jira', 'read:issue-security-level:jira', 'read:project-role:jira', 'read:user:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuesecurityschemes/{schemeId}': {
    delete: {
      deprecated: false;
      description: 'Deletes an issue security scheme.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'deleteSecurityScheme';
      parameters: [
        {
          description: 'The ID of the issue security scheme.';
          in: 'path';
          name: 'schemeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '"You can\'t delete an issue security scheme if any projects are associated with it."';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["You are not authorized to perform this action. Administrator privileges are required."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the user doesn't have the necessary permission.";
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Issue security scheme with ID 10000 not found."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the issue security scheme isn't found.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Delete issue security scheme';
      tags: ['Issue security schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issuesecurityschemes/{schemeId}/level': {
    put: {
      deprecated: false;
      description: "Adds levels and levels' members to the issue security scheme. You can add up to 100 levels per request.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).";
      operationId: 'addSecurityLevel';
      parameters: [
        {
          description: 'The ID of the issue security scheme.';
          in: 'path';
          name: 'schemeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              levels: [
                {
                  description: 'First Level Description';
                  isDefault: true;
                  members: [
                    {
                      type: 'reporter';
                    },
                    {
                      parameter: 'jira-administrators';
                      type: 'group';
                    },
                  ];
                  name: 'First Level';
                },
              ];
            };
            schema: {
              $ref: '#/components/schemas/AddSecuritySchemeLevelsRequestBean';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["some-wrong-string is not a valid value. The issue security scheme ID must be a positive integer."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["You are not authorized to perform this action. Administrator privileges are required."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the user doesn't have the necessary permission.";
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Issue security scheme with ID 10000 not found."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the security scheme isn't found.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Add issue security levels';
      tags: ['Issue security schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issuesecurityschemes/{schemeId}/level/{levelId}': {
    delete: {
      deprecated: false;
      description: 'Deletes an issue security level.\n\nThis operation is [asynchronous](#async). Follow the `location` link in the response to determine the status of the task and use [Get task](#api-rest-api-3-task-taskId-get) to obtain subsequent updates.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'removeLevel';
      parameters: [
        {
          description: 'The ID of the issue security scheme.';
          in: 'path';
          name: 'schemeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the issue security level to remove.';
          in: 'path';
          name: 'levelId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the issue security level that will replace the currently selected level.';
          in: 'query';
          name: 'replaceWith';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '303': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/TaskProgressBeanObject';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '"You can\'t delete an issue security scheme if any projects are associated with it."';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the request isn't valid.";
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["You are not authorized to perform this action. Administrator privileges are required."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the user doesn't have the necessary permission.";
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Issue security scheme with ID 10000 not found."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the issue security level isn't found.";
        };
        '409': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if a task to remove the issue security level is already running.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Remove issue security level';
      tags: ['Issue security schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-experimental': true;
    };
    put: {
      deprecated: false;
      description: 'Updates the issue security level.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'updateSecurityLevel';
      parameters: [
        {
          description: 'The ID of the issue security scheme level belongs to.';
          in: 'path';
          name: 'schemeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the issue security level to update.';
          in: 'path';
          name: 'levelId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              description: 'New level description';
              name: 'New level name';
            };
            schema: {
              $ref: '#/components/schemas/UpdateIssueSecurityLevelDetails';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The length of the description must not exceed 4,000 characters."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the request isn't valid.";
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["You are not authorized to perform this action. Administrator privileges are required."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the user doesn't have the necessary permission.";
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Issue security scheme with ID 10000 not found."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the issue security level isn't found.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Update issue security level';
      tags: ['Issue security schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issuesecurityschemes/{schemeId}/level/{levelId}/member': {
    put: {
      deprecated: false;
      description: 'Adds members to the issue security level. You can add up to 100 members per request.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'addSecurityLevelMembers';
      parameters: [
        {
          description: 'The ID of the issue security scheme.';
          in: 'path';
          name: 'schemeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the issue security level.';
          in: 'path';
          name: 'levelId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              members: [
                {
                  type: 'reporter';
                },
                {
                  parameter: 'jira-administrators';
                  type: 'group';
                },
              ];
            };
            schema: {
              $ref: '#/components/schemas/SecuritySchemeMembersRequest';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["some-wrong-string is not a valid value. The issue security scheme ID must be a positive integer."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["You are not authorized to perform this action. Administrator privileges are required."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the user doesn't have the necessary permission.";
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Issue security scheme with ID 10000 not found."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the security scheme isn't found.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Add issue security level members';
      tags: ['Issue security schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issuesecurityschemes/{schemeId}/level/{levelId}/member/{memberId}': {
    delete: {
      deprecated: false;
      description: 'Removes an issue security level member from an issue security scheme.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'removeMemberFromSecurityLevel';
      parameters: [
        {
          description: 'The ID of the issue security scheme.';
          in: 'path';
          name: 'schemeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the issue security level.';
          in: 'path';
          name: 'levelId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the issue security level member to be removed.';
          in: 'path';
          name: 'memberId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the request is invalid.';
        };
        '401': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["You are not authorized to perform this action. Administrator privileges are required."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the user doesn't have the necessary permission.";
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Issue security scheme with ID 10000 not found."],"errors":{}}';
              schema: {
                $ref: '#/components/schemas/ErrorCollection';
              };
            };
          };
          description: "Returned if the security scheme isn't found.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Remove member from issue security level';
      tags: ['Issue security schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issuetype': {
    get: {
      deprecated: false;
      description: 'Returns all issue types.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** Issue types are only returned as follows:\n\n *  if the user has the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg), all issue types are returned.\n *  if the user has the *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for one or more projects, the issue types associated with the projects the user has permission to browse are returned.';
      operationId: 'getIssueAllTypes';
      parameters: [];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '[{"avatarId":1,"description":"A task that needs to be done.","hierarchyLevel":0,"iconUrl":"https://your-domain.atlassian.net/secure/viewavatar?size=xsmall&avatarId=10299&avatarType=issuetype\\",","id":"3","name":"Task","self":"https://your-domain.atlassian.net/rest/api/3/issueType/3","subtask":false},{"avatarId":10002,"description":"A problem with the software.","entityId":"9d7dd6f7-e8b6-4247-954b-7b2c9b2a5ba2","hierarchyLevel":0,"iconUrl":"https://your-domain.atlassian.net/secure/viewavatar?size=xsmall&avatarId=10316&avatarType=issuetype\\",","id":"1","name":"Bug","scope":{"project":{"id":"10000"},"type":"PROJECT"},"self":"https://your-domain.atlassian.net/rest/api/3/issueType/1","subtask":false}]';
              schema: {
                items: {
                  $ref: '#/components/schemas/IssueTypeDetails';
                };
                type: 'array';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get all issue types for user';
      tags: ['Issue types'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-type:jira', 'read:avatar:jira', 'read:project-category:jira', 'read:project:jira'];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Creates an issue type and adds it to the default issue type scheme.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'createIssueType';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              description: 'description';
              name: 'name';
              type: 'standard';
            };
            schema: {
              $ref: '#/components/schemas/IssueTypeCreateBean';
            };
          };
        };
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/IssueTypeDetails';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is invalid because:\n\n *  no content is sent.\n *  the issue type name exceeds 60 characters.\n *  a subtask issue type is requested on an instance where subtasks are disabled.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '409': {
          description: 'Returned if the issue type name is in use.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
        {},
      ];
      summary: 'Create issue type';
      tags: ['Issue types'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'write:issue-type:jira',
            'read:avatar:jira',
            'read:issue-type:jira',
            'read:project-category:jira',
            'read:project:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetype/project': {
    get: {
      deprecated: false;
      description: 'Returns issue types for a project.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) in the relevant project or *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getIssueTypesForProject';
      parameters: [
        {
          description: 'The ID of the project.';
          in: 'query';
          name: 'projectId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The level of the issue type to filter by. Use:\n\n *  `-1` for Subtask.\n *  `0` for Base.\n *  `1` for Epic.';
          in: 'query';
          name: 'level';
          schema: {
            format: 'int32';
            type: 'integer';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '[{"avatarId":10002,"description":"A problem with the software.","entityId":"9d7dd6f7-e8b6-4247-954b-7b2c9b2a5ba2","hierarchyLevel":0,"iconUrl":"https://your-domain.atlassian.net/secure/viewavatar?size=xsmall&avatarId=10316&avatarType=issuetype\\",","id":"1","name":"Bug","scope":{"project":{"id":"10000"},"type":"PROJECT"},"self":"https://your-domain.atlassian.net/rest/api/3/issueType/1","subtask":false},{"avatarId":1,"description":"A task that needs to be done.","hierarchyLevel":0,"iconUrl":"https://your-domain.atlassian.net/secure/viewavatar?size=xsmall&avatarId=10299&avatarType=issuetype\\",","id":"3","name":"Task","scope":{"project":{"id":"10000"},"type":"PROJECT"},"self":"https://your-domain.atlassian.net/rest/api/3/issueType/3","subtask":false}]';
              schema: {
                items: {
                  $ref: '#/components/schemas/IssueTypeDetails';
                };
                type: 'array';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if:\n\n *  the project is not found.\n *  the user does not have the necessary permission.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get issue types for project';
      tags: ['Issue types'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-type:jira', 'read:avatar:jira', 'read:project-category:jira', 'read:project:jira'];
          state: 'Beta';
        },
      ];
      'x-experimental': true;
    };
  };
  '/rest/api/3/issuetype/{id}': {
    delete: {
      deprecated: false;
      description: 'Deletes the issue type. If the issue type is in use, all uses are updated with the alternative issue type (`alternativeIssueTypeId`). A list of alternative issue types are obtained from the [Get alternative issue types](#api-rest-api-3-issuetype-id-alternatives-get) resource.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'deleteIssueType';
      parameters: [
        {
          description: 'The ID of the issue type.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the replacement issue type.';
          in: 'query';
          name: 'alternativeIssueTypeId';
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if any issues cannot be updated with the alternative issue type.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if:\n\n *  the issue type is in use and an alternative issue type is not specified.\n *  the issue type or alternative issue type is not found.';
        };
        '409': {
          description: 'Returned if the issue type is in use and:\n\n *  also specified as the alternative issue type.\n *  is a *standard* issue type and the alternative issue type is a *subtask*.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
        {},
      ];
      summary: 'Delete issue type';
      tags: ['Issue types'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:issue-type:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: 'Returns an issue type.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) in a project the issue type is associated with or *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getIssueType';
      parameters: [
        {
          description: 'The ID of the issue type.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"avatarId":1,"description":"A task that needs to be done.","hierarchyLevel":0,"iconUrl":"https://your-domain.atlassian.net/secure/viewavatar?size=xsmall&avatarId=10299&avatarType=issuetype\\",","id":"3","name":"Task","self":"https://your-domain.atlassian.net/rest/api/3/issueType/3","subtask":false}';
              schema: {
                $ref: '#/components/schemas/IssueTypeDetails';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the issue type ID is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if:\n\n *  the issue type is not found.\n *  the user does not have the required permissions.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get issue type';
      tags: ['Issue types'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-type:jira', 'read:avatar:jira', 'read:project-category:jira', 'read:project:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Updates the issue type.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'updateIssueType';
      parameters: [
        {
          description: 'The ID of the issue type.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              avatarId: 1;
              description: 'description';
              name: 'name';
            };
            schema: {
              $ref: '#/components/schemas/IssueTypeUpdateBean';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              schema: {
                $ref: '#/components/schemas/IssueTypeDetails';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is invalid because:\n\n *  no content is sent.\n *  the issue type name exceeds 60 characters.\n *  the avatar is not associated with this issue type.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if the issue type is not found.';
        };
        '409': {
          description: 'Returned if the issue type name is in use.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
        {},
      ];
      summary: 'Update issue type';
      tags: ['Issue types'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: [
            'write:issue-type:jira',
            'read:avatar:jira',
            'read:issue-type:jira',
            'read:project-category:jira',
            'read:project:jira',
          ];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetype/{id}/alternatives': {
    get: {
      deprecated: false;
      description: 'Returns a list of issue types that can be used to replace the issue type. The alternative issue types are those assigned to the same workflow scheme, field configuration scheme, and screen scheme.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:** None.';
      operationId: 'getAlternativeIssueTypes';
      parameters: [
        {
          description: 'The ID of the issue type.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '[{"avatarId":1,"description":"A task that needs to be done.","hierarchyLevel":0,"iconUrl":"https://your-domain.atlassian.net/secure/viewavatar?size=xsmall&avatarId=10299&avatarType=issuetype\\",","id":"3","name":"Task","self":"https://your-domain.atlassian.net/rest/api/3/issueType/3","subtask":false},{"avatarId":10002,"description":"A problem with the software.","entityId":"9d7dd6f7-e8b6-4247-954b-7b2c9b2a5ba2","hierarchyLevel":0,"iconUrl":"https://your-domain.atlassian.net/secure/viewavatar?size=xsmall&avatarId=10316&avatarType=issuetype\\",","id":"1","name":"Bug","scope":{"project":{"id":"10000"},"type":"PROJECT"},"self":"https://your-domain.atlassian.net/rest/api/3/issueType/1","subtask":false}]';
              schema: {
                items: {
                  $ref: '#/components/schemas/IssueTypeDetails';
                };
                type: 'array';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if:\n\n *  the issue type is not found.\n *  the user does not have the required permissions.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get alternative issue types';
      tags: ['Issue types'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-type:jira', 'read:project-category:jira', 'read:project:jira', 'read:avatar:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetype/{id}/avatar2': {
    post: {
      deprecated: false;
      description: "Loads an avatar for the issue type.\n\nSpecify the avatar's local file location in the body of the request. Also, include the following headers:\n\n *  `X-Atlassian-Token: no-check` To prevent XSRF protection blocking the request, for more information see [Special Headers](#special-request-headers).\n *  `Content-Type: image/image type` Valid image types are JPEG, GIF, or PNG.\n\nFor example:  \n`curl --request POST \\ --user email@example.com:<api_token> \\ --header 'X-Atlassian-Token: no-check' \\ --header 'Content-Type: image/< image_type>' \\ --data-binary \"<@/path/to/file/with/your/avatar>\" \\ --url 'https://your-domain.atlassian.net/rest/api/3/issuetype/{issueTypeId}'This`\n\nThe avatar is cropped to a square. If no crop parameters are specified, the square originates at the top left of the image. The length of the square's sides is set to the smaller of the height or width of the image.\n\nThe cropped image is then used to create avatars of 16x16, 24x24, 32x32, and 48x48 in size.\n\nAfter creating the avatar, use [ Update issue type](#api-rest-api-3-issuetype-id-put) to set it as the issue type's displayed avatar.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).";
      operationId: 'createIssueTypeAvatar';
      parameters: [
        {
          description: 'The ID of the issue type.';
          in: 'path';
          name: 'id';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The X coordinate of the top-left corner of the crop region.';
          in: 'query';
          name: 'x';
          schema: {
            default: 0;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The Y coordinate of the top-left corner of the crop region.';
          in: 'query';
          name: 'y';
          schema: {
            default: 0;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The length of each side of the crop region.';
          in: 'query';
          name: 'size';
          required: true;
          schema: {
            format: 'int32';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          '*/*': {
            schema: {};
          };
        };
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              example: '{"id":"1010","isDeletable":true,"isSelected":false,"isSystemAvatar":false}';
              schema: {
                $ref: '#/components/schemas/Avatar';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: "Returned if:\n\n *  an image isn't included in the request.\n *  the image type is unsupported.\n *  the crop parameters extend the crop area beyond the edge of the image.\n *  `cropSize` is missing.\n *  the issue type ID is invalid.";
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if the issue type is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
        {},
      ];
      summary: 'Load issue type avatar';
      tags: ['Issue types'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:avatar:jira', 'write:issue-type:jira', 'read:avatar:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetype/{issueTypeId}/properties': {
    get: {
      deprecated: false;
      description: 'Returns all the [issue type property](https://developer.atlassian.com/cloud/jira/platform/storing-data-without-a-database/#a-id-jira-entity-properties-a-jira-entity-properties) keys of the issue type.\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) to get the property keys of any issue type.\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) to get the property keys of any issue types associated with the projects the user has permission to browse.';
      operationId: 'getIssueTypePropertyKeys';
      parameters: [
        {
          description: 'The ID of the issue type.';
          in: 'path';
          name: 'issueTypeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"keys":[{"key":"issue.support","self":"https://your-domain.atlassian.net/rest/api/3/issue/EX-2/properties/issue.support"}]}';
              schema: {
                $ref: '#/components/schemas/PropertyKeys';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the issue type ID is invalid.';
        };
        '404': {
          description: 'Returned if:\n\n *  the issue type is not found.\n *  the user does not have the required permissions.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get issue type property keys';
      tags: ['Issue type properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-type.property:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetype/{issueTypeId}/properties/{propertyKey}': {
    delete: {
      deprecated: false;
      description: 'Deletes the [issue type property](https://developer.atlassian.com/cloud/jira/platform/storing-data-without-a-database/#a-id-jira-entity-properties-a-jira-entity-properties).\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'deleteIssueTypeProperty';
      parameters: [
        {
          description: 'The ID of the issue type.';
          in: 'path';
          name: 'issueTypeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The key of the property. Use [Get issue type property keys](#api-rest-api-3-issuetype-issueTypeId-properties-get) to get a list of all issue type property keys.';
          in: 'path';
          name: 'propertyKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '204': {
          description: 'Returned if the issue type property is deleted.';
        };
        '400': {
          description: 'Returned if the issue type ID is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the necessary permission.';
        };
        '404': {
          description: 'Returned if the issue type or property is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
        {},
      ];
      summary: 'Delete issue type property';
      tags: ['Issue type properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:issue-type.property:jira'];
          state: 'Beta';
        },
      ];
    };
    get: {
      deprecated: false;
      description: 'Returns the key and value of the [issue type property](https://developer.atlassian.com/cloud/jira/platform/storing-data-without-a-database/#a-id-jira-entity-properties-a-jira-entity-properties).\n\nThis operation can be accessed anonymously.\n\n**[Permissions](#permissions) required:**\n\n *  *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) to get the details of any issue type.\n *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) to get the details of any issue types associated with the projects the user has permission to browse.';
      operationId: 'getIssueTypeProperty';
      parameters: [
        {
          description: 'The ID of the issue type.';
          in: 'path';
          name: 'issueTypeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The key of the property. Use [Get issue type property keys](#api-rest-api-3-issuetype-issueTypeId-properties-get) to get a list of all issue type property keys.';
          in: 'path';
          name: 'propertyKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"key":"issue.support","value":{"system.conversation.id":"b1bf38be-5e94-4b40-a3b8-9278735ee1e6","system.support.time":"1m"}}';
              schema: {
                $ref: '#/components/schemas/EntityProperty';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the issue type ID is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '404': {
          description: 'Returned if the issue type or property is not found or the user does not have the required permissions.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['read:jira-work'];
        },
        {},
      ];
      summary: 'Get issue type property';
      tags: ['Issue type properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['read:jira-work'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-type.property:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Creates or updates the value of the [issue type property](https://developer.atlassian.com/cloud/jira/platform/storing-data-without-a-database/#a-id-jira-entity-properties-a-jira-entity-properties). Use this resource to store and update data against an issue type.\n\nThe value of the request body must be a [valid](http://tools.ietf.org/html/rfc4627), non-empty JSON blob. The maximum length is 32768 characters.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'setIssueTypeProperty';
      parameters: [
        {
          description: 'The ID of the issue type.';
          in: 'path';
          name: 'issueTypeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The key of the issue type property. The maximum length is 255 characters.';
          in: 'path';
          name: 'propertyKey';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              number: 5;
              string: 'string-value';
            };
            schema: {};
          };
        };
        description: 'The value of the property. The value has to be a valid, non-empty [JSON](https://tools.ietf.org/html/rfc4627) value. The maximum length of the property value is 32768 bytes.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the issue type property is updated.';
        };
        '201': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the issue type property is created.';
        };
        '400': {
          description: 'Returned if:\n\n *  the issue type ID is invalid.\n *  a property value is not provided.\n *  the property value JSON content is invalid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have permission to modify the issue type.';
        };
        '404': {
          description: 'Returned if:\n\n *  the issue type is not found.\n *  the user does not have the permission view the issue type.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
        {},
      ];
      summary: 'Set issue type property';
      tags: ['Issue type properties'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue-type.property:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetypescheme': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of issue type schemes.\n\nOnly issue type schemes used in classic projects are returned.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getAllIssueTypeSchemes';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The list of issue type schemes IDs. To include multiple IDs, provide an ampersand-separated list. For example, `id=10000&id=10001`.';
          in: 'query';
          name: 'id';
          schema: {
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: '[Order](#ordering) the results by a field:\n\n *  `name` Sorts by issue type scheme name.\n *  `id` Sorts by issue type scheme ID.';
          in: 'query';
          name: 'orderBy';
          schema: {
            default: 'id';
            enum: ['name', '-name', '+name', 'id', '-id', '+id'];
            type: 'string';
          };
        },
        {
          description: 'Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:\n\n *  `projects` For each issue type schemes, returns information about the projects the issue type scheme is assigned to.\n *  `issueTypes` For each issue type schemes, returns information about the issueTypes the issue type scheme have.';
          in: 'query';
          name: 'expand';
          schema: {
            default: '';
            type: 'string';
          };
        },
        {
          description: 'String used to perform a case-insensitive partial match with issue type scheme name.';
          in: 'query';
          name: 'queryString';
          schema: {
            default: '';
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":100,"startAt":0,"total":3,"values":[{"id":"10000","name":"Default Issue Type Scheme","description":"Default issue type scheme is the list of global issue types. All newly created issue types will automatically be added to this scheme.","defaultIssueTypeId":"10003","isDefault":true},{"id":"10001","name":"SUP: Kanban Issue Type Scheme","description":"A collection of issue types suited to use in a kanban style project.","projects":{"isLast":true,"maxResults":100,"startAt":0,"total":1,"values":[{"avatarUrls":{"16x16":"secure/projectavatar?size=xsmall&pid=10000","24x24":"secure/projectavatar?size=small&pid=10000","32x32":"secure/projectavatar?size=medium&pid=10000","48x48":"secure/projectavatar?size=large&pid=10000"},"id":"10000","key":"EX","name":"Example","projectCategory":{"description":"Project category description","id":"10000","name":"A project category"},"projectTypeKey":"ProjectTypeKey{key=\'software\'}","self":"project/EX","simplified":false}]}},{"id":"10002","name":"HR: Scrum issue type scheme","description":"","defaultIssueTypeId":"10004","issueTypes":{"isLast":true,"maxResults":100,"startAt":0,"total":1,"values":[{"description":"Improvement Issue Type","hierarchyLevel":-1,"iconUrl":"www.example.com","id":"1000L","name":"Improvements","subtask":true}]}}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanIssueTypeScheme';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the required permissions.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get all issue type schemes';
      tags: ['Issue type schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-type-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Creates an issue type scheme.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'createIssueTypeScheme';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              defaultIssueTypeId: '10002';
              description: 'A collection of issue types suited to use in a kanban style project.';
              issueTypeIds: ['10001', '10002', '10003'];
              name: 'Kanban Issue Type Scheme';
            };
            schema: {
              $ref: '#/components/schemas/IssueTypeSchemeDetails';
            };
          };
        };
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              example: '{"issueTypeSchemeId":"10010"}';
              schema: {
                $ref: '#/components/schemas/IssueTypeSchemeID';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The default issue type ID has to be present in issue type IDs list."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access issue type schemes."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '409': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The name is used by another scheme."],"errors":{}}';
            };
          };
          description: 'Returned if the scheme name is used by another scheme.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Create issue type scheme';
      tags: ['Issue type schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue-type-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetypescheme/mapping': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of issue type scheme items.\n\nOnly issue type scheme items used in classic projects are returned.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getIssueTypeSchemesMapping';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The list of issue type scheme IDs. To include multiple IDs, provide an ampersand-separated list. For example, `issueTypeSchemeId=10000&issueTypeSchemeId=10001`.';
          in: 'query';
          name: 'issueTypeSchemeId';
          schema: {
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":100,"startAt":0,"total":4,"values":[{"issueTypeSchemeId":"10000","issueTypeId":"10000"},{"issueTypeSchemeId":"10000","issueTypeId":"10001"},{"issueTypeSchemeId":"10000","issueTypeId":"10002"},{"issueTypeSchemeId":"10001","issueTypeId":"10000"}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanIssueTypeSchemeMapping';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the required permissions.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get issue type scheme items';
      tags: ['Issue type schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-type-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetypescheme/project': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of issue type schemes and, for each issue type scheme, a list of the projects that use it.\n\nOnly issue type schemes used in classic projects are returned.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getIssueTypeSchemeForProjects';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The list of project IDs. To include multiple project IDs, provide an ampersand-separated list. For example, `projectId=10000&projectId=10001`.';
          in: 'query';
          name: 'projectId';
          required: true;
          schema: {
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":100,"startAt":0,"total":3,"values":[{"issueTypeScheme":{"id":"10000","name":"Default Issue Type Scheme","description":"Default issue type scheme is the list of global issue types. All newly created issue types will automatically be added to this scheme.","defaultIssueTypeId":"10003","isDefault":true},"projectIds":["10000","10001"]},{"issueTypeScheme":{"id":"10001","name":"SUP: Kanban Issue Type Scheme","description":"A collection of issue types suited to use in a kanban style project."},"projectIds":["10002"]},{"issueTypeScheme":{"id":"10002","name":"HR: Scrum issue type scheme","description":"","defaultIssueTypeId":"10004","issueTypes":{"isLast":true,"maxResults":100,"startAt":0,"total":1,"values":[{"description":"Improvement Issue Type","hierarchyLevel":-1,"iconUrl":"www.example.com","id":"1000L","name":"Improvements","subtask":true}]}},"projectIds":["10003","10004","10005"]}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanIssueTypeSchemeProjects';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the required permissions.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get issue type schemes for projects';
      tags: ['Issue type schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-type-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Assigns an issue type scheme to a project.\n\nIf any issues in the project are assigned issue types not present in the new scheme, the operation will fail. To complete the assignment those issues must be updated to use issue types in the new scheme.\n\nIssue type schemes can only be assigned to classic projects.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'assignIssueTypeSchemeToProject';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              issueTypeSchemeId: '10000';
              projectId: '10000';
            };
            schema: {
              $ref: '#/components/schemas/IssueTypeSchemeProjectAssociation';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["This issue type scheme can\'t be assigned to the project. This is because some issues in this project use issue types not present in the scheme. Before assigning the scheme to the project, update the issue types on these issues: 7"],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access issue type schemes."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The issue type scheme was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the issue type scheme or the project is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Assign issue type scheme to project';
      tags: ['Issue type schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue-type-scheme:jira', 'write:project:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetypescheme/{issueTypeSchemeId}': {
    delete: {
      deprecated: false;
      description: 'Deletes an issue type scheme.\n\nOnly issue type schemes used in classic projects can be deleted.\n\nAny projects assigned to the scheme are reassigned to the default issue type scheme.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'deleteIssueTypeScheme';
      parameters: [
        {
          description: 'The ID of the issue type scheme.';
          in: 'path';
          name: 'issueTypeSchemeId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the issue type scheme is deleted.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The default issue type scheme can\'t be removed."],"errors":{}}';
            };
          };
          description: 'Returned if the request is to delete the default issue type scheme.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access issue type schemes."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The issue type scheme was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the issue type scheme is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Delete issue type scheme';
      tags: ['Issue type schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:issue-type-scheme:jira', 'write:project:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Updates an issue type scheme.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'updateIssueTypeScheme';
      parameters: [
        {
          description: 'The ID of the issue type scheme.';
          in: 'path';
          name: 'issueTypeSchemeId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              defaultIssueTypeId: '10002';
              description: 'A collection of issue types suited to use in a kanban style project.';
              name: 'Kanban Issue Type Scheme';
            };
            schema: {
              $ref: '#/components/schemas/IssueTypeSchemeUpdateDetails';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The default issue type has to be one of the issue types of the scheme."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access issue type schemes."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The issue type scheme was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the issue type scheme is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Update issue type scheme';
      tags: ['Issue type schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue-type-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetypescheme/{issueTypeSchemeId}/issuetype': {
    put: {
      deprecated: false;
      description: 'Adds issue types to an issue type scheme.\n\nThe added issue types are appended to the issue types list.\n\nIf any of the issue types exist in the issue type scheme, the operation fails and no issue types are added.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'addIssueTypesToIssueTypeScheme';
      parameters: [
        {
          description: 'The ID of the issue type scheme.';
          in: 'path';
          name: 'issueTypeSchemeId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              issueTypeIds: ['10000', '10002', '10003'];
            };
            schema: {
              $ref: '#/components/schemas/IssueTypeIds';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["These issue types were not added because they are already present in the issue type scheme: 10002, 10003"],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access issue type schemes."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["These issue types were not found: 10000, 10002"],"errors":{}}';
            };
          };
          description: 'Returned if the issue type or the issue type scheme is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Add issue types to issue type scheme';
      tags: ['Issue type schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue-type-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetypescheme/{issueTypeSchemeId}/issuetype/move': {
    put: {
      deprecated: false;
      description: 'Changes the order of issue types in an issue type scheme.\n\nThe request body parameters must meet the following requirements:\n\n *  all of the issue types must belong to the issue type scheme.\n *  either `after` or `position` must be provided.\n *  the issue type in `after` must not be in the issue type list.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'reorderIssueTypesInIssueTypeScheme';
      parameters: [
        {
          description: 'The ID of the issue type scheme.';
          in: 'path';
          name: 'issueTypeSchemeId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              after: '10008';
              issueTypeIds: ['10001', '10004', '10002'];
            };
            schema: {
              $ref: '#/components/schemas/OrderOfIssueTypes';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The issue type scheme does not include some of the specified issue types. Issue type IDs missing from the scheme are:  10007, 10008"],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access issue type schemes."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The issue type scheme was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the issue type scheme is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Change order of issue types';
      tags: ['Issue type schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue-type-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetypescheme/{issueTypeSchemeId}/issuetype/{issueTypeId}': {
    delete: {
      deprecated: false;
      description: 'Removes an issue type from an issue type scheme.\n\nThis operation cannot remove:\n\n *  any issue type used by issues.\n *  any issue types from the default issue type scheme.\n *  the last standard issue type from an issue type scheme.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'removeIssueTypeFromIssueTypeScheme';
      parameters: [
        {
          description: 'The ID of the issue type scheme.';
          in: 'path';
          name: 'issueTypeSchemeId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The ID of the issue type.';
          in: 'path';
          name: 'issueTypeId';
          required: true;
          schema: {
            format: 'int64';
            type: 'integer';
          };
        },
      ];
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Can\'t remove the last standard issue type from the issue type scheme."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access issue type schemes."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The issue type was not found in the issue type scheme."],"errors":{}}';
            };
          };
          description: 'Returned if the issue type scheme is missing or the issue type is not found in the issue type scheme.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Remove issue type from issue type scheme';
      tags: ['Issue type schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue-type-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetypescreenscheme': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of issue type screen schemes.\n\nOnly issue type screen schemes used in classic projects are returned.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getIssueTypeScreenSchemes';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The list of issue type screen scheme IDs. To include multiple IDs, provide an ampersand-separated list. For example, `id=10000&id=10001`.';
          in: 'query';
          name: 'id';
          schema: {
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
        {
          description: 'String used to perform a case-insensitive partial match with issue type screen scheme name.';
          in: 'query';
          name: 'queryString';
          schema: {
            default: '';
            type: 'string';
          };
        },
        {
          description: '[Order](#ordering) the results by a field:\n\n *  `name` Sorts by issue type screen scheme name.\n *  `id` Sorts by issue type screen scheme ID.';
          in: 'query';
          name: 'orderBy';
          schema: {
            default: 'id';
            enum: ['name', '-name', '+name', 'id', '-id', '+id'];
            type: 'string';
          };
        },
        {
          description: 'Use [expand](#expansion) to include additional information in the response. This parameter accepts `projects` that, for each issue type screen schemes, returns information about the projects the issue type screen scheme is assigned to.';
          in: 'query';
          name: 'expand';
          schema: {
            default: '';
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":100,"startAt":0,"total":2,"values":[{"id":"1","name":"Default Issue Type Screen Scheme","description":"The default issue type screen scheme"},{"id":"10000","name":"Office issue type screen scheme","description":"Managing office projects","projects":{"isLast":true,"maxResults":100,"startAt":0,"total":1,"values":[{"avatarUrls":{"16x16":"secure/projectavatar?size=xsmall&pid=10000","24x24":"secure/projectavatar?size=small&pid=10000","32x32":"secure/projectavatar?size=medium&pid=10000","48x48":"secure/projectavatar?size=large&pid=10000"},"id":"10000","key":"EX","name":"Example","projectCategory":{"description":"Project category description","id":"10000","name":"A project category"},"projectTypeKey":"ProjectTypeKey{key=\'software\'}","self":"project/EX","simplified":false}]}}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanIssueTypeScreenScheme';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the required permissions.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get issue type screen schemes';
      tags: ['Issue type screen schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-type-screen-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
    post: {
      deprecated: false;
      description: 'Creates an issue type screen scheme.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'createIssueTypeScreenScheme';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              issueTypeMappings: [
                {
                  issueTypeId: 'default';
                  screenSchemeId: '10001';
                },
                {
                  issueTypeId: '10001';
                  screenSchemeId: '10002';
                },
                {
                  issueTypeId: '10002';
                  screenSchemeId: '10002';
                },
              ];
              name: 'Scrum issue type screen scheme';
            };
            schema: {
              $ref: '#/components/schemas/IssueTypeScreenSchemeDetails';
            };
          };
        };
        description: 'An issue type screen scheme bean.';
        required: true;
      };
      responses: {
        '201': {
          content: {
            'application/json': {
              example: '{"id":"10001"}';
              schema: {
                $ref: '#/components/schemas/IssueTypeScreenSchemeId';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["One or more issue type IDs are repeated, an issue type ID can only be specified once."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access issue type screen schemes."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["One or more issue type IDs were not found."],"errors":{}}';
            };
          };
          description: 'Returned if the issue type or screen scheme is not found.';
        };
        '409': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Sub-tasks are disabled in Jira. At least one of the issue types is a sub-task."],"errors":{}}';
            };
          };
          description: 'Returned if the issue type is a sub-task, but sub-tasks are disabled in Jira settings.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Create issue type screen scheme';
      tags: ['Issue type screen schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue-type-screen-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetypescreenscheme/mapping': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of issue type screen scheme items.\n\nOnly issue type screen schemes used in classic projects are returned.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getIssueTypeScreenSchemeMappings';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The list of issue type screen scheme IDs. To include multiple issue type screen schemes, separate IDs with ampersand: `issueTypeScreenSchemeId=10000&issueTypeScreenSchemeId=10001`.';
          in: 'query';
          name: 'issueTypeScreenSchemeId';
          schema: {
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":100,"startAt":0,"total":4,"values":[{"issueTypeId":"10000","issueTypeScreenSchemeId":"10020","screenSchemeId":"10010"},{"issueTypeId":"10001","issueTypeScreenSchemeId":"10021","screenSchemeId":"10010"},{"issueTypeId":"10002","issueTypeScreenSchemeId":"10022","screenSchemeId":"10010"},{"issueTypeId":"default","issueTypeScreenSchemeId":"10023","screenSchemeId":"10011"}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanIssueTypeScreenSchemeItem';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the required permissions.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get issue type screen scheme items';
      tags: ['Issue type screen schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-type-screen-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetypescreenscheme/project': {
    get: {
      deprecated: false;
      description: 'Returns a [paginated](#pagination) list of issue type screen schemes and, for each issue type screen scheme, a list of the projects that use it.\n\nOnly issue type screen schemes used in classic projects are returned.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'getIssueTypeScreenSchemeProjectAssociations';
      parameters: [
        {
          description: 'The index of the first item to return in a page of results (page offset).';
          in: 'query';
          name: 'startAt';
          schema: {
            default: 0;
            format: 'int64';
            type: 'integer';
          };
        },
        {
          description: 'The maximum number of items to return per page.';
          in: 'query';
          name: 'maxResults';
          schema: {
            default: 50;
            format: 'int32';
            type: 'integer';
          };
        },
        {
          description: 'The list of project IDs. To include multiple projects, separate IDs with ampersand: `projectId=10000&projectId=10001`.';
          in: 'query';
          name: 'projectId';
          required: true;
          schema: {
            items: {
              format: 'int64';
              type: 'integer';
            };
            type: 'array';
            uniqueItems: true;
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/json': {
              example: '{"isLast":true,"maxResults":100,"startAt":0,"total":1,"values":[{"issueTypeScreenScheme":{"id":"1","name":"Default Issue Type Screen Scheme","description":"The default issue type screen scheme"},"projectIds":["10000","10001"]}]}';
              schema: {
                $ref: '#/components/schemas/PageBeanIssueTypeScreenSchemesProjects';
              };
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the required permissions.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Get issue type screen schemes for projects';
      tags: ['Issue type screen schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['read:issue-type-screen-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Assigns an issue type screen scheme to a project.\n\nIssue type screen schemes can only be assigned to classic projects.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'assignIssueTypeScreenSchemeToProject';
      parameters: [];
      requestBody: {
        content: {
          'application/json': {
            example: {
              issueTypeScreenSchemeId: '10001';
              projectId: '10002';
            };
            schema: {
              $ref: '#/components/schemas/IssueTypeScreenSchemeProjectAssociation';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only classic projects can have issue type screen schemes assigned."],"errors":{}}';
            };
          };
          description: 'Returned if:\n\n *  project is not found.\n *  issue type screen scheme is not found.\n *  the project is not a classic project.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access issue type screen schemes."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The issue type screen scheme was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the issue type screen scheme or the project are missing.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Assign issue type screen scheme to project';
      tags: ['Issue type screen schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue-type-screen-scheme:jira', 'write:project:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetypescreenscheme/{issueTypeScreenSchemeId}': {
    delete: {
      deprecated: false;
      description: 'Deletes an issue type screen scheme.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'deleteIssueTypeScreenScheme';
      parameters: [
        {
          description: 'The ID of the issue type screen scheme.';
          in: 'path';
          name: 'issueTypeScreenSchemeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the issue type screen scheme is deleted.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The issue type screen scheme cannot be deleted because it is assigned to one or more projects."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The issue type screen scheme was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the issue type screen scheme is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Delete issue type screen scheme';
      tags: ['Issue type screen schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['delete:issue-type-screen-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
    put: {
      deprecated: false;
      description: 'Updates an issue type screen scheme.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'updateIssueTypeScreenScheme';
      parameters: [
        {
          description: 'The ID of the issue type screen scheme.';
          in: 'path';
          name: 'issueTypeScreenSchemeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              description: 'Screens for scrum issue types.';
              name: 'Scrum scheme';
            };
            schema: {
              $ref: '#/components/schemas/IssueTypeScreenSchemeUpdateDetails';
            };
          };
        };
        description: 'The issue type screen scheme update details.';
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The issue type screen scheme name is in use."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access issue type screen schemes."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The issue type screen scheme was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the issue type screen scheme is not found.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Update issue type screen scheme';
      tags: ['Issue type screen schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue-type-screen-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetypescreenscheme/{issueTypeScreenSchemeId}/mapping': {
    put: {
      deprecated: false;
      description: 'Appends issue type to screen scheme mappings to an issue type screen scheme.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'appendMappingsForIssueTypeScreenScheme';
      parameters: [
        {
          description: 'The ID of the issue type screen scheme.';
          in: 'path';
          name: 'issueTypeScreenSchemeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              issueTypeMappings: [
                {
                  issueTypeId: '10000';
                  screenSchemeId: '10001';
                },
                {
                  issueTypeId: '10001';
                  screenSchemeId: '10002';
                },
                {
                  issueTypeId: '10002';
                  screenSchemeId: '10002';
                },
              ];
            };
            schema: {
              $ref: '#/components/schemas/IssueTypeScreenSchemeMappingDetails';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["A default mapping cannot be added."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The issue type screen scheme was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the issue type screen scheme, issue type, or screen scheme is not found.';
        };
        '409': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Sub-tasks are disabled in Jira. At least one of the issue types is a sub-task."],"errors":{}}';
            };
          };
          description: 'Returned if the issue type is a sub-task, but sub-tasks are disabled in Jira settings.';
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Append mappings to issue type screen scheme';
      tags: ['Issue type screen schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue-type-screen-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetypescreenscheme/{issueTypeScreenSchemeId}/mapping/default': {
    put: {
      deprecated: false;
      description: 'Updates the default screen scheme of an issue type screen scheme. The default screen scheme is used for all unmapped issue types.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'updateDefaultScreenScheme';
      parameters: [
        {
          description: 'The ID of the issue type screen scheme.';
          in: 'path';
          name: 'issueTypeScreenSchemeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              screenSchemeId: '10010';
            };
            schema: {
              $ref: '#/components/schemas/UpdateDefaultScreenScheme';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the request is successful.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The screenSchemeId has to be provided."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access issue type screen schemes."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The issue type screen scheme was not found."],"errors":{}}';
            };
          };
          description: "Returned if the issue type screen scheme or the screen scheme is not found, or the screen scheme isn't used in classic projects.";
        };
      };
      security: [
        {
          basicAuth: [];
        },
        {
          OAuth2: ['manage:jira-configuration'];
        },
      ];
      summary: 'Update issue type screen scheme default screen scheme';
      tags: ['Issue type screen schemes'];
      'x-atlassian-data-security-policy': [
        {
          'app-access-rule-exempt': true;
        },
      ];
      'x-atlassian-oauth2-scopes': [
        {
          scheme: 'OAuth2';
          scopes: ['manage:jira-configuration'];
          state: 'Current';
        },
        {
          scheme: 'OAuth2';
          scopes: ['write:issue-type-screen-scheme:jira'];
          state: 'Beta';
        },
      ];
    };
  };
  '/rest/api/3/issuetypescreenscheme/{issueTypeScreenSchemeId}/mapping/remove': {
    post: {
      deprecated: false;
      description: 'Removes issue type to screen scheme mappings from an issue type screen scheme.\n\n**[Permissions](#permissions) required:** *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).';
      operationId: 'removeMappingsFromIssueTypeScreenScheme';
      parameters: [
        {
          description: 'The ID of the issue type screen scheme.';
          in: 'path';
          name: 'issueTypeScreenSchemeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            example: {
              issueTypeIds: ['10000', '10001', '10004'];
            };
            schema: {
              $ref: '#/components/schemas/IssueTypeIds';
            };
          };
        };
        required: true;
      };
      responses: {
        '204': {
          content: {
            'application/json': {
              schema: {};
            };
          };
          description: 'Returned if the screen scheme mappings are removed from the issue type screen scheme.';
        };
        '400': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The issueTypeIds must not contain duplicates."],"errors":{}}';
            };
          };
          description: 'Returned if the request is not valid.';
        };
        '401': {
          description: 'Returned if the authentication credentials are incorrect or missing.';
        };
        '403': {
          content: {
            'application/json': {
              example: '{"errorMessages":["Only Jira administrators can access issue type screen schemes."],"errors":{}}';
            };
          };
          description: 'Returned if the user does not have the required permissions.';
        };
        '404': {
          content: {
            'application/json': {
              example: '{"errorMessages":["The issue type screen scheme was not found."],"errors":{}}';
            };
          };
          description: 'Returned if the issue type screen scheme or one or more issue type mappings are not found.';
        };
      };
      security: [
