// Generated by ts-to-zod
import { z } from 'zod';

import {
  type ConditionGroupUpdate,
  type CreateWorkflowCondition,
  type NotificationEvent,
  type LinkGroup,
  type ConditionGroupConfiguration,
  type CompoundClause,
  type JqlQueryClause,
  type JqlQuery,
  type PageBeanWorkflow,
  type Workflow,
  type ParsedJqlQueries,
  type ParsedJqlQuery,
  type Transition,
  type WorkflowRules,
  type WorkflowCompoundCondition,
  type WorkflowCondition,
  type ParseJqlQueriesResponse,
  type GetWorkflowsPaginatedResponse,
} from './types.gen';

export const actorInputBeanSchema = z.object({
  group: z.array(z.string()).optional(),
  groupId: z.array(z.string()).optional(),
  user: z.array(z.string()).optional(),
});

export const actorsMapSchema = z.object({
  group: z.array(z.string()).optional(),
  groupId: z.array(z.string()).optional(),
  user: z.array(z.string()).optional(),
});

export const addFieldBeanSchema = z.object({
  fieldId: z.string(),
});

export const addGroupBeanSchema = z.object({
  name: z.string(),
});

export const announcementBannerConfigurationSchema = z.object({
  hashId: z.string().optional(),
  isDismissible: z.boolean().optional(),
  isEnabled: z.boolean().optional(),
  message: z.string().optional(),
  visibility: z.union([z.literal('PUBLIC'), z.literal('PRIVATE')]).optional(),
});

export const visibilitySchema = z.object({
  identifier: z.string().optional().nullable(),
  type: z.union([z.literal('group'), z.literal('role')]).optional(),
  value: z.string().optional(),
});

export const announcementBannerConfigurationUpdateSchema = z.object({
  isDismissible: z.boolean().optional(),
  isEnabled: z.boolean().optional(),
  message: z.string().optional(),
  visibility: z.string().optional(),
});

export const ruleConfigurationSchema = z.object({
  disabled: z.boolean().optional(),
  tag: z.string().optional(),
  value: z.string(),
});

export const workflowTransitionSchema = z.object({
  id: z.number(),
  name: z.string(),
});

export const applicationSchema = z.object({
  name: z.string().optional(),
  type: z.string().optional(),
});

export const applicationPropertySchema = z.object({
  allowedValues: z.array(z.string()).optional(),
  defaultValue: z.string().optional(),
  desc: z.string().optional(),
  example: z.string().optional(),
  id: z.string().optional(),
  key: z.string().optional(),
  name: z.string().optional(),
  type: z.string().optional(),
  value: z.string().optional(),
});

export const groupNameSchema = z.object({
  groupId: z.string().optional().nullable(),
  name: z.string().optional(),
  self: z.string().optional(),
});

export const approvalConfigurationSchema = z
  .object({
    active: z.union([z.literal('true'), z.literal('false')]),
    conditionType: z.union([z.literal('number'), z.literal('percent'), z.literal('numberPerPrincipal')]),
    conditionValue: z.string(),
    exclude: z
      .union([z.literal('assignee'), z.literal('reporter')])
      .optional()
      .nullable(),
    fieldId: z.string(),
    prePopulatedFieldId: z.string().optional().nullable(),
    transitionApproved: z.string(),
    transitionRejected: z.string(),
  })
  .nullable();

export const activeSchema = z.union([z.literal('true'), z.literal('false')]);

export const conditionTypeSchema = z.union([
  z.literal('number'),
  z.literal('percent'),
  z.literal('numberPerPrincipal'),
]);

export const excludeSchema = z.union([z.literal('assignee'), z.literal('reporter')]);

export const archiveIssueAsyncRequestSchema = z.object({
  jql: z.string().optional(),
});

export const dateRangeFilterRequestSchema = z.object({
  dateAfter: z.string(),
  dateBefore: z.string(),
});

export const fieldConfigurationToIssueTypeMappingSchema = z.object({
  fieldConfigurationId: z.string(),
  issueTypeId: z.string(),
});

export const oldToNewSecurityLevelMappingsBeanSchema = z.object({
  newLevelId: z.string(),
  oldLevelId: z.string(),
});

export const associatedItemBeanSchema = z.object({
  id: z.string().optional(),
  name: z.string().optional(),
  parentId: z.string().optional(),
  parentName: z.string().optional(),
  typeName: z.string().optional(),
});

export const attachmentArchiveEntrySchema = z.object({
  abbreviatedName: z.string().optional(),
  entryIndex: z.number().optional(),
  mediaType: z.string().optional(),
  name: z.string().optional(),
  size: z.number().optional(),
});

export const attachmentArchiveImplSchema = z.object({
  entries: z.array(attachmentArchiveEntrySchema).optional(),
  totalEntryCount: z.number().optional(),
});

export const attachmentArchiveItemReadableSchema = z.object({
  index: z.number().optional(),
  label: z.string().optional(),
  mediaType: z.string().optional(),
  path: z.string().optional(),
  size: z.string().optional(),
});

export const attachmentArchiveMetadataReadableSchema = z.object({
  entries: z.array(attachmentArchiveItemReadableSchema).optional(),
  id: z.number().optional(),
  mediaType: z.string().optional(),
  name: z.string().optional(),
  totalEntryCount: z.number().optional(),
});

export const attachmentSettingsSchema = z.object({
  enabled: z.boolean().optional(),
  uploadLimit: z.number().optional(),
});

export const changedValueBeanSchema = z.object({
  changedFrom: z.string().optional(),
  changedTo: z.string().optional(),
  fieldName: z.string().optional(),
});

export const auditRecordBeanSchema = z.object({
  associatedItems: z.array(associatedItemBeanSchema).optional(),
  authorKey: z.string().optional(),
  category: z.string().optional(),
  changedValues: z.array(changedValueBeanSchema).optional(),
  created: z.string().optional(),
  description: z.string().optional(),
  eventSource: z.string().optional(),
  id: z.number().optional(),
  objectItem: associatedItemBeanSchema.optional(),
  remoteAddress: z.string().optional(),
  summary: z.string().optional(),
});

export const autoCompleteSuggestionSchema = z.object({
  displayName: z.string().optional(),
  value: z.string().optional(),
});

export const autoCompleteSuggestionsSchema = z.object({
  results: z.array(autoCompleteSuggestionSchema).optional(),
});

export const availableDashboardGadgetSchema = z.object({
  moduleKey: z.string().optional(),
  title: z.string(),
  uri: z.string().optional(),
});

export const availableDashboardGadgetsResponseSchema = z.object({
  gadgets: z.array(availableDashboardGadgetSchema),
});

export const availableWorkflowConnectRuleSchema = z.object({
  addonKey: z.string().optional(),
  createUrl: z.string().optional(),
  description: z.string().optional(),
  editUrl: z.string().optional(),
  moduleKey: z.string().optional(),
  name: z.string().optional(),
  ruleKey: z.string().optional(),
  ruleType: z
    .union([z.literal('Condition'), z.literal('Validator'), z.literal('Function'), z.literal('Screen')])
    .optional(),
  viewUrl: z.string().optional(),
});

export const ruleTypeSchema = z.union([
  z.literal('Condition'),
  z.literal('Validator'),
  z.literal('Function'),
  z.literal('Screen'),
]);

export const availableWorkflowForgeRuleSchema = z.object({
  description: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  ruleKey: z.string().optional(),
  ruleType: z
    .union([z.literal('Condition'), z.literal('Validator'), z.literal('Function'), z.literal('Screen')])
    .optional(),
});

export const availableWorkflowSystemRuleSchema = z.object({
  description: z.string(),
  incompatibleRuleKeys: z.array(z.string()),
  isAvailableForInitialTransition: z.boolean(),
  isVisible: z.boolean(),
  name: z.string(),
  ruleKey: z.string(),
  ruleType: z.union([z.literal('Condition'), z.literal('Validator'), z.literal('Function'), z.literal('Screen')]),
});

export const availableWorkflowTriggerTypesSchema = z.object({
  description: z.string().optional(),
  name: z.string().optional(),
  type: z.string().optional(),
});

export const availableWorkflowTriggersSchema = z.object({
  availableTypes: z.array(availableWorkflowTriggerTypesSchema),
  ruleKey: z.string(),
});

export const avatarSchema = z.object({
  fileName: z.string().optional(),
  id: z.string(),
  isDeletable: z.boolean().optional(),
  isSelected: z.boolean().optional(),
  isSystemAvatar: z.boolean().optional(),
  owner: z.string().optional(),
  urls: z.record(z.string()).optional(),
});

export const avatarUrlsBeanSchema = z.object({
  '16x16': z.string().optional(),
  '24x24': z.string().optional(),
  '32x32': z.string().optional(),
  '48x48': z.string().optional(),
});

export const avatarsSchema = z.object({
  custom: z.array(avatarSchema).optional(),
  system: z.array(avatarSchema).optional(),
});

export const bulkChangeOwnerDetailsSchema = z.object({
  autofixName: z.boolean(),
  newOwner: z.string(),
});

export const bulkContextualConfigurationSchema = z.object({
  configuration: z.string().optional(),
  customFieldId: z.string(),
  fieldContextId: z.string(),
  id: z.string(),
  schema: z.string().optional(),
});

export const customFieldOptionCreateSchema = z.object({
  disabled: z.boolean().optional(),
  optionId: z.string().optional(),
  value: z.string(),
});

export const customFieldOptionUpdateSchema = z.object({
  disabled: z.boolean().optional(),
  id: z.string(),
  value: z.string().optional(),
});

export const bulkEditActionErrorSchema = z.object({
  errorMessages: z.array(z.string()),
  errors: z.record(z.string()),
});

export const actionSchema = z.union([
  z.literal('changeOwner'),
  z.literal('changePermission'),
  z.literal('addPermission'),
  z.literal('removePermission'),
]);

export const bulkEditShareableEntityResponseSchema = z.object({
  action: z.union([
    z.literal('changeOwner'),
    z.literal('changePermission'),
    z.literal('addPermission'),
    z.literal('removePermission'),
  ]),
  entityErrors: z.record(bulkEditActionErrorSchema).optional(),
});

export const bulkFetchIssueRequestBeanSchema = z.object({
  expand: z.array(z.string()).optional(),
  fields: z.array(z.string()).optional(),
  fieldsByKeys: z.boolean().optional(),
  issueIdsOrKeys: z.array(z.string()),
  properties: z.array(z.string()).optional(),
});

export const bulkIssueIsWatchingSchema = z.object({
  issuesIsWatching: z.record(z.boolean()).optional(),
});

export const issueFilterForBulkPropertySetSchema = z.object({
  currentValue: z.string().optional(),
  entityIds: z.array(z.number()).optional(),
  hasProperty: z.boolean().optional(),
});

export const issueErrorSchema = z.object({
  errorMessage: z.string().optional(),
  id: z.string().optional(),
});

export const errorMessageSchema = z.object({
  message: z.string().optional(),
});

export const errorCollectionSchema = z.object({
  errorMessages: z.array(z.string()).optional(),
  errors: z.record(z.string()).optional(),
  status: z.number().optional(),
});

export const iconSchema = z.object({
  link: z.string().optional(),
  title: z.string().optional(),
  url16x16: z.string().optional(),
});

export const statusSchema = z.object({
  icon: iconSchema.optional(),
  resolved: z.boolean().optional(),
});

export const bulkProjectPermissionGrantsSchema = z.object({
  issues: z.array(z.number()),
  permission: z.string(),
  projects: z.array(z.number()),
});

export const bulkProjectPermissionsSchema = z.object({
  issues: z.array(z.number()).optional(),
  permissions: z.array(z.string()),
  projects: z.array(z.number()).optional(),
});

export const changeDetailsSchema = z.object({
  field: z.string().optional(),
  fieldId: z.string().optional(),
  fieldtype: z.string().optional(),
  from: z.string().optional(),
  fromString: z.string().optional(),
  to: z.string().optional(),
  toString: z.string().optional(),
});

export const changeFilterOwnerSchema = z.object({
  accountId: z.string(),
});

export const entityPropertySchema = z.object({
  key: z.string().optional(),
  value: z.string().optional(),
});

export const changedWorklogSchema = z.object({
  properties: z.array(entityPropertySchema).optional(),
  updatedTime: z.number().optional(),
  worklogId: z.number().optional(),
});

export const userDetailsSchema = z.object({
  accountId: z.string().optional(),
  accountType: z.string().optional(),
  active: z.boolean().optional(),
  avatarUrls: avatarUrlsBeanSchema.optional(),
  displayName: z.string().optional(),
  emailAddress: z.string().optional(),
  key: z.string().optional(),
  name: z.string().optional(),
  self: z.string().optional(),
  timeZone: z.string().optional(),
});

export const columnItemSchema = z.object({
  label: z.string().optional(),
  value: z.string().optional(),
});

export const columnRequestBodySchema = z.object({
  columns: z.array(z.string()).optional(),
});

export const commentSchema = z.object({
  author: userDetailsSchema.optional(),
  body: z.string().optional(),
  created: z.string().optional(),
  id: z.string().optional(),
  jsdAuthorCanSeeRequest: z.boolean().optional(),
  jsdPublic: z.boolean().optional(),
  properties: z.array(entityPropertySchema).optional(),
  renderedBody: z.string().optional(),
  self: z.string().optional(),
  updateAuthor: userDetailsSchema.optional(),
  updated: z.string().optional(),
  visibility: visibilitySchema.optional(),
});

export const componentIssuesCountSchema = z.object({
  issueCount: z.number().optional(),
  self: z.string().optional(),
});

export const componentJsonBeanSchema = z.object({
  ari: z.string().optional(),
  description: z.string().optional(),
  id: z.string().optional(),
  metadata: z.record(z.string()).optional(),
  name: z.string().optional(),
  self: z.string().optional(),
});

export const assigneeTypeSchema = z.union([
  z.literal('PROJECT_DEFAULT'),
  z.literal('COMPONENT_LEAD'),
  z.literal('PROJECT_LEAD'),
  z.literal('UNASSIGNED'),
]);

export const realAssigneeTypeSchema = z.union([
  z.literal('PROJECT_DEFAULT'),
  z.literal('COMPONENT_LEAD'),
  z.literal('PROJECT_LEAD'),
  z.literal('UNASSIGNED'),
]);

export const operatorSchema = z.union([z.literal('and'), z.literal('or'), z.literal('not')]);

export const workflowRuleConfigurationSchema = z
  .object({
    id: z.string().optional().nullable(),
    parameters: z.record(z.string()).optional(),
    ruleKey: z.string(),
  })
  .nullable();

export const operationSchema = z.union([z.literal('ANY'), z.literal('ALL')]);

export const conditionGroupUpdateSchema: z.ZodSchema<ConditionGroupUpdate> = z.lazy(() =>
  z
    .object({
      conditionGroups: z.array(conditionGroupUpdateSchema).optional(),
      conditions: z.array(workflowRuleConfigurationSchema).optional(),
      operation: z.union([z.literal('ANY'), z.literal('ALL')]),
    })
    .nullable(),
);

export const timeTrackingConfigurationSchema = z.object({
  defaultUnit: z.union([z.literal('minute'), z.literal('hour'), z.literal('day'), z.literal('week')]),
  timeFormat: z.union([z.literal('pretty'), z.literal('days'), z.literal('hours')]),
  workingDaysPerWeek: z.number(),
  workingHoursPerDay: z.number(),
});

export const configurationsListParametersSchema = z.object({
  fieldIdsOrKeys: z.array(z.string()),
});

export const connectCustomFieldValueSchema = z.object({
  _type: z.union([
    z.literal('StringIssueField'),
    z.literal('NumberIssueField'),
    z.literal('RichTextIssueField'),
    z.literal('SingleSelectIssueField'),
    z.literal('MultiSelectIssueField'),
    z.literal('TextIssueField'),
  ]),
  fieldID: z.number(),
  issueID: z.number(),
  number: z.number().optional(),
  optionID: z.string().optional(),
  richText: z.string().optional(),
  string: z.string().optional(),
  text: z.string().optional(),
});

export const typeSchema = z.union([z.literal('global'), z.literal('initial'), z.literal('directed')]);

export const connectCustomFieldValuesSchema = z.object({
  updateValueList: z.array(connectCustomFieldValueSchema).optional(),
});

export const connectModuleSchema = z.record(z.string());

export const connectModulesSchema = z.object({
  modules: z.array(connectModuleSchema),
});

export const connectWorkflowTransitionRuleSchema = z.object({
  configuration: ruleConfigurationSchema,
  id: z.string(),
  key: z.string(),
  transition: workflowTransitionSchema.optional(),
});

export const projectFeatureSchema = z.object({
  feature: z.string().optional(),
  imageUri: z.string().optional(),
  localisedDescription: z.string().optional(),
  localisedName: z.string().optional(),
  prerequisites: z.array(z.string()).optional(),
  projectId: z.number().optional(),
  state: z.union([z.literal('ENABLED'), z.literal('DISABLED'), z.literal('COMING_SOON')]).optional(),
  toggleLocked: z.boolean().optional(),
});

export const registeredWebhookSchema = z.object({
  createdWebhookId: z.number().optional(),
  errors: z.array(z.string()).optional(),
});

export const containerForWebhookIDsSchema = z.object({
  webhookIds: z.array(z.number()),
});

export const contextForProjectAndIssueTypeSchema = z.object({
  contextId: z.string(),
  issueTypeId: z.string(),
  projectId: z.string(),
});

export const contextualConfigurationSchema = z.object({
  configuration: z.string().optional(),
  fieldContextId: z.string(),
  id: z.string(),
  schema: z.string().optional(),
});

export const jQLQueryWithUnknownUsersSchema = z.object({
  convertedQuery: z.string().optional(),
  originalQuery: z.string().optional(),
});

export const createCustomFieldContextSchema = z.object({
  description: z.string().optional(),
  id: z.string().optional(),
  issueTypeIds: z.array(z.string()).optional(),
  name: z.string(),
  projectIds: z.array(z.string()).optional(),
});

export const createPriorityDetailsSchema = z.object({
  avatarId: z.number().optional(),
  description: z.string().optional().nullable(),
  iconUrl: z
    .union([
      z.literal('/images/icons/priorities/blocker.png'),
      z.literal('/images/icons/priorities/critical.png'),
      z.literal('/images/icons/priorities/high.png'),
      z.literal('/images/icons/priorities/highest.png'),
      z.literal('/images/icons/priorities/low.png'),
      z.literal('/images/icons/priorities/lowest.png'),
      z.literal('/images/icons/priorities/major.png'),
      z.literal('/images/icons/priorities/medium.png'),
      z.literal('/images/icons/priorities/minor.png'),
      z.literal('/images/icons/priorities/trivial.png'),
      z.literal('/images/icons/priorities/blocker_new.png'),
      z.literal('/images/icons/priorities/critical_new.png'),
      z.literal('/images/icons/priorities/high_new.png'),
      z.literal('/images/icons/priorities/highest_new.png'),
      z.literal('/images/icons/priorities/low_new.png'),
      z.literal('/images/icons/priorities/lowest_new.png'),
      z.literal('/images/icons/priorities/major_new.png'),
      z.literal('/images/icons/priorities/medium_new.png'),
      z.literal('/images/icons/priorities/minor_new.png'),
      z.literal('/images/icons/priorities/trivial_new.png'),
    ])
    .optional()
    .nullable(),
  name: z.string(),
  statusColor: z.string(),
});

export const iconUrlSchema = z.union([
  z.literal('/images/icons/priorities/blocker.png'),
  z.literal('/images/icons/priorities/critical.png'),
  z.literal('/images/icons/priorities/high.png'),
  z.literal('/images/icons/priorities/highest.png'),
  z.literal('/images/icons/priorities/low.png'),
  z.literal('/images/icons/priorities/lowest.png'),
  z.literal('/images/icons/priorities/major.png'),
  z.literal('/images/icons/priorities/medium.png'),
  z.literal('/images/icons/priorities/minor.png'),
  z.literal('/images/icons/priorities/trivial.png'),
  z.literal('/images/icons/priorities/blocker_new.png'),
  z.literal('/images/icons/priorities/critical_new.png'),
  z.literal('/images/icons/priorities/high_new.png'),
  z.literal('/images/icons/priorities/highest_new.png'),
  z.literal('/images/icons/priorities/low_new.png'),
  z.literal('/images/icons/priorities/lowest_new.png'),
  z.literal('/images/icons/priorities/major_new.png'),
  z.literal('/images/icons/priorities/medium_new.png'),
  z.literal('/images/icons/priorities/minor_new.png'),
  z.literal('/images/icons/priorities/trivial_new.png'),
]);

export const priorityMappingSchema = z.object({
  in: z.record(z.number()).optional(),
  out: z.record(z.number()).optional(),
});

export const createProjectDetailsSchema = z.object({
  assigneeType: z.union([z.literal('PROJECT_LEAD'), z.literal('UNASSIGNED')]).optional(),
  avatarId: z.number().optional(),
  categoryId: z.number().optional(),
  description: z.string().optional(),
  fieldConfigurationScheme: z.number().optional(),
  issueSecurityScheme: z.number().optional(),
  issueTypeScheme: z.number().optional(),
  issueTypeScreenScheme: z.number().optional(),
  key: z.string(),
  lead: z.string().optional(),
  leadAccountId: z.string().optional(),
  name: z.string(),
  notificationScheme: z.number().optional(),
  permissionScheme: z.number().optional(),
  projectTemplateKey: z
    .union([
      z.literal('com.pyxis.greenhopper.jira:gh-simplified-agility-kanban'),
      z.literal('com.pyxis.greenhopper.jira:gh-simplified-agility-scrum'),
      z.literal('com.pyxis.greenhopper.jira:gh-simplified-basic'),
      z.literal('com.pyxis.greenhopper.jira:gh-simplified-kanban-classic'),
      z.literal('com.pyxis.greenhopper.jira:gh-simplified-scrum-classic'),
      z.literal('com.pyxis.greenhopper.jira:gh-cross-team-template'),
      z.literal('com.pyxis.greenhopper.jira:gh-cross-team-planning-template'),
      z.literal('com.atlassian.servicedesk:simplified-it-service-management'),
      z.literal('com.atlassian.servicedesk:simplified-it-service-management-basic'),
      z.literal('com.atlassian.servicedesk:simplified-general-service-desk'),
      z.literal('com.atlassian.servicedesk:simplified-general-service-desk-it'),
      z.literal('com.atlassian.servicedesk:simplified-general-service-desk-business'),
      z.literal('com.atlassian.servicedesk:simplified-internal-service-desk'),
      z.literal('com.atlassian.servicedesk:simplified-external-service-desk'),
      z.literal('com.atlassian.servicedesk:simplified-hr-service-desk'),
      z.literal('com.atlassian.servicedesk:simplified-facilities-service-desk'),
      z.literal('com.atlassian.servicedesk:simplified-legal-service-desk'),
      z.literal('com.atlassian.servicedesk:simplified-marketing-service-desk'),
      z.literal('com.atlassian.servicedesk:simplified-finance-service-desk'),
      z.literal('com.atlassian.servicedesk:simplified-analytics-service-desk'),
      z.literal('com.atlassian.servicedesk:simplified-design-service-desk'),
      z.literal('com.atlassian.servicedesk:simplified-sales-service-desk'),
      z.literal('com.atlassian.servicedesk:simplified-halp-service-desk'),
      z.literal('com.atlassian.servicedesk:simplified-blank-project-it'),
      z.literal('com.atlassian.servicedesk:simplified-blank-project-business'),
      z.literal('com.atlassian.servicedesk:next-gen-it-service-desk'),
      z.literal('com.atlassian.servicedesk:next-gen-hr-service-desk'),
      z.literal('com.atlassian.servicedesk:next-gen-legal-service-desk'),
      z.literal('com.atlassian.servicedesk:next-gen-marketing-service-desk'),
      z.literal('com.atlassian.servicedesk:next-gen-facilities-service-desk'),
      z.literal('com.atlassian.servicedesk:next-gen-general-service-desk'),
      z.literal('com.atlassian.servicedesk:next-gen-general-it-service-desk'),
      z.literal('com.atlassian.servicedesk:next-gen-general-business-service-desk'),
      z.literal('com.atlassian.servicedesk:next-gen-analytics-service-desk'),
      z.literal('com.atlassian.servicedesk:next-gen-finance-service-desk'),
      z.literal('com.atlassian.servicedesk:next-gen-design-service-desk'),
      z.literal('com.atlassian.servicedesk:next-gen-sales-service-desk'),
      z.literal('com.atlassian.jira-core-project-templates:jira-core-simplified-content-management'),
      z.literal('com.atlassian.jira-core-project-templates:jira-core-simplified-document-approval'),
      z.literal('com.atlassian.jira-core-project-templates:jira-core-simplified-lead-tracking'),
      z.literal('com.atlassian.jira-core-project-templates:jira-core-simplified-process-control'),
      z.literal('com.atlassian.jira-core-project-templates:jira-core-simplified-procurement'),
      z.literal('com.atlassian.jira-core-project-templates:jira-core-simplified-project-management'),
      z.literal('com.atlassian.jira-core-project-templates:jira-core-simplified-recruitment'),
      z.literal('com.atlassian.jira-core-project-templates:jira-core-simplified-task-'),
    ])
    .optional(),
  projectTypeKey: z.union([z.literal('software'), z.literal('service_desk'), z.literal('business')]).optional(),
  url: z.string().optional(),
  workflowScheme: z.number().optional(),
});

export const assigneeType2Schema = z.union([z.literal('PROJECT_LEAD'), z.literal('UNASSIGNED')]);

export const projectTemplateKeySchema = z.union([
  z.literal('com.pyxis.greenhopper.jira:gh-simplified-agility-kanban'),
  z.literal('com.pyxis.greenhopper.jira:gh-simplified-agility-scrum'),
  z.literal('com.pyxis.greenhopper.jira:gh-simplified-basic'),
  z.literal('com.pyxis.greenhopper.jira:gh-simplified-kanban-classic'),
  z.literal('com.pyxis.greenhopper.jira:gh-simplified-scrum-classic'),
  z.literal('com.pyxis.greenhopper.jira:gh-cross-team-template'),
  z.literal('com.pyxis.greenhopper.jira:gh-cross-team-planning-template'),
  z.literal('com.atlassian.servicedesk:simplified-it-service-management'),
  z.literal('com.atlassian.servicedesk:simplified-it-service-management-basic'),
  z.literal('com.atlassian.servicedesk:simplified-general-service-desk'),
  z.literal('com.atlassian.servicedesk:simplified-general-service-desk-it'),
  z.literal('com.atlassian.servicedesk:simplified-general-service-desk-business'),
  z.literal('com.atlassian.servicedesk:simplified-internal-service-desk'),
  z.literal('com.atlassian.servicedesk:simplified-external-service-desk'),
  z.literal('com.atlassian.servicedesk:simplified-hr-service-desk'),
  z.literal('com.atlassian.servicedesk:simplified-facilities-service-desk'),
  z.literal('com.atlassian.servicedesk:simplified-legal-service-desk'),
  z.literal('com.atlassian.servicedesk:simplified-marketing-service-desk'),
  z.literal('com.atlassian.servicedesk:simplified-finance-service-desk'),
  z.literal('com.atlassian.servicedesk:simplified-analytics-service-desk'),
  z.literal('com.atlassian.servicedesk:simplified-design-service-desk'),
  z.literal('com.atlassian.servicedesk:simplified-sales-service-desk'),
  z.literal('com.atlassian.servicedesk:simplified-halp-service-desk'),
  z.literal('com.atlassian.servicedesk:simplified-blank-project-it'),
  z.literal('com.atlassian.servicedesk:simplified-blank-project-business'),
  z.literal('com.atlassian.servicedesk:next-gen-it-service-desk'),
  z.literal('com.atlassian.servicedesk:next-gen-hr-service-desk'),
  z.literal('com.atlassian.servicedesk:next-gen-legal-service-desk'),
  z.literal('com.atlassian.servicedesk:next-gen-marketing-service-desk'),
  z.literal('com.atlassian.servicedesk:next-gen-facilities-service-desk'),
  z.literal('com.atlassian.servicedesk:next-gen-general-service-desk'),
  z.literal('com.atlassian.servicedesk:next-gen-general-it-service-desk'),
  z.literal('com.atlassian.servicedesk:next-gen-general-business-service-desk'),
  z.literal('com.atlassian.servicedesk:next-gen-analytics-service-desk'),
  z.literal('com.atlassian.servicedesk:next-gen-finance-service-desk'),
  z.literal('com.atlassian.servicedesk:next-gen-design-service-desk'),
  z.literal('com.atlassian.servicedesk:next-gen-sales-service-desk'),
  z.literal('com.atlassian.jira-core-project-templates:jira-core-simplified-content-management'),
  z.literal('com.atlassian.jira-core-project-templates:jira-core-simplified-document-approval'),
  z.literal('com.atlassian.jira-core-project-templates:jira-core-simplified-lead-tracking'),
  z.literal('com.atlassian.jira-core-project-templates:jira-core-simplified-process-control'),
  z.literal('com.atlassian.jira-core-project-templates:jira-core-simplified-procurement'),
  z.literal('com.atlassian.jira-core-project-templates:jira-core-simplified-project-management'),
  z.literal('com.atlassian.jira-core-project-templates:jira-core-simplified-recruitment'),
  z.literal('com.atlassian.jira-core-project-templates:jira-core-simplified-task-'),
]);

export const projectTypeKeySchema = z.union([z.literal('software'), z.literal('service_desk'), z.literal('business')]);

export const createResolutionDetailsSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
});

export const uiModificationContextDetailsSchema = z.object({
  id: z.string().optional(),
  isAvailable: z.boolean().optional(),
  issueTypeId: z.string().optional(),
  projectId: z.string().optional(),
  viewType: z.union([z.literal('GIC'), z.literal('IssueView'), z.literal('IssueTransition')]).optional(),
});

export const createUpdateRoleRequestBeanSchema = z.object({
  description: z.string().optional(),
  name: z.string().optional(),
});

export const createWorkflowConditionSchema: z.ZodSchema<CreateWorkflowCondition> = z.lazy(() =>
  z.object({
    conditions: z.array(createWorkflowConditionSchema).optional(),
    configuration: z.record(z.string()).optional(),
    operator: z.union([z.literal('AND'), z.literal('OR')]).optional(),
    type: z.string().optional(),
  }),
);

export const operator2Schema = z.union([z.literal('AND'), z.literal('OR')]);

export const createWorkflowStatusDetailsSchema = z.object({
  id: z.string(),
  properties: z.record(z.string()).optional(),
});

export const createWorkflowTransitionScreenDetailsSchema = z.object({
  id: z.string(),
});

export const createWorkflowTransitionRuleSchema = z.object({
  configuration: z.record(z.string()).optional(),
  type: z.string(),
});

export const createWorkflowTransitionRulesDetailsSchema = z.object({
  conditions: createWorkflowConditionSchema.optional(),
  postFunctions: z.array(createWorkflowTransitionRuleSchema).optional(),
  validators: z.array(createWorkflowTransitionRuleSchema).optional(),
});

export const bulkOperationErrorResultSchema = z.object({
  elementErrors: errorCollectionSchema.optional(),
  failedElementNumber: z.number().optional(),
  status: z.number().optional(),
});

export const userContextVariableSchema = z.object({
  accountId: z.string(),
  type: z.literal('user'),
});

export const issueContextVariableSchema = z.object({
  id: z.number().optional(),
  key: z.string().optional(),
  type: z.literal('issue'),
});

export const jsonContextVariableSchema = z.object({
  type: z.literal('json'),
  value: z.record(z.string()).optional(),
});

export const customFieldConfigurationsSchema = z.object({
  configurations: z.array(contextualConfigurationSchema),
});

export const customFieldContextSchema = z.object({
  description: z.string(),
  id: z.string(),
  isAnyIssueType: z.boolean(),
  isGlobalContext: z.boolean(),
  name: z.string(),
});

export const customFieldContextDefaultValueCascadingOptionSchema = z.object({
  cascadingOptionId: z.string().optional(),
  contextId: z.string(),
  optionId: z.string(),
  type: z.literal('option.cascading'),
});

export const customFieldContextDefaultValueMultipleOptionSchema = z.object({
  contextId: z.string(),
  optionIds: z.array(z.string()),
  type: z.literal('option.multiple'),
});

export const customFieldContextDefaultValueSingleOptionSchema = z.object({
  contextId: z.string(),
  optionId: z.string(),
  type: z.literal('option.single'),
});

export const customFieldContextDefaultValueMultiUserPickerSchema = z.object({
  accountIds: z.array(z.string()),
  contextId: z.string(),
  type: z.literal('multi.user.select'),
});

export const customFieldContextDefaultValueSingleGroupPickerSchema = z.object({
  contextId: z.string(),
  groupId: z.string(),
  type: z.literal('grouppicker.single'),
});

export const customFieldContextDefaultValueMultipleGroupPickerSchema = z.object({
  contextId: z.string(),
  groupIds: z.array(z.string()),
  type: z.literal('grouppicker.multiple'),
});

export const customFieldContextDefaultValueDateSchema = z.object({
  date: z.string().optional(),
  type: z.literal('datepicker'),
  useCurrent: z.boolean().optional(),
});

export const customFieldContextDefaultValueDateTimeSchema = z.object({
  dateTime: z.string().optional(),
  type: z.literal('datetimepicker'),
  useCurrent: z.boolean().optional(),
});

export const customFieldContextDefaultValueURLSchema = z.object({
  contextId: z.string(),
  type: z.literal('url'),
  url: z.string(),
});

export const customFieldContextDefaultValueProjectSchema = z.object({
  contextId: z.string(),
  projectId: z.string(),
  type: z.literal('project'),
});

export const customFieldContextDefaultValueFloatSchema = z.object({
  number: z.number(),
  type: z.literal('float'),
});

export const customFieldContextDefaultValueLabelsSchema = z.object({
  labels: z.array(z.string()),
  type: z.literal('labels'),
});

export const customFieldContextDefaultValueTextFieldSchema = z.object({
  text: z.string().optional(),
  type: z.literal('textfield'),
});

export const customFieldContextDefaultValueTextAreaSchema = z.object({
  text: z.string().optional(),
  type: z.literal('textarea'),
});

export const customFieldContextDefaultValueReadOnlySchema = z.object({
  text: z.string().optional(),
  type: z.literal('readonly'),
});

export const customFieldContextDefaultValueSingleVersionPickerSchema = z.object({
  type: z.literal('version.single'),
  versionId: z.string(),
  versionOrder: z.string().optional(),
});

export const customFieldContextDefaultValueMultipleVersionPickerSchema = z.object({
  type: z.literal('version.multiple'),
  versionIds: z.array(z.string()),
  versionOrder: z.string().optional(),
});

export const customFieldContextDefaultValueForgeStringFieldSchema = z.object({
  contextId: z.string(),
  text: z.string().optional(),
  type: z.literal('forge.string'),
});

export const customFieldContextDefaultValueForgeMultiStringFieldSchema = z.object({
  type: z.literal('forge.string.list'),
  values: z.array(z.string()).optional(),
});

export const customFieldContextDefaultValueForgeObjectFieldSchema = z.object({
  object: z.record(z.string()).optional(),
  type: z.literal('forge.object'),
});

export const customFieldContextDefaultValueForgeDateTimeFieldSchema = z.object({
  contextId: z.string(),
  dateTime: z.string().optional(),
  type: z.literal('forge.datetime'),
  useCurrent: z.boolean().optional(),
});

export const customFieldContextDefaultValueForgeGroupFieldSchema = z.object({
  contextId: z.string(),
  groupId: z.string(),
  type: z.literal('forge.group'),
});

export const customFieldContextDefaultValueForgeMultiGroupFieldSchema = z.object({
  contextId: z.string(),
  groupIds: z.array(z.string()),
  type: z.literal('forge.group.list'),
});

export const customFieldContextDefaultValueForgeNumberFieldSchema = z.object({
  contextId: z.string(),
  number: z.number(),
  type: z.literal('forge.number'),
});

export const customFieldContextDefaultValueForgeMultiUserFieldSchema = z.object({
  accountIds: z.array(z.string()),
  contextId: z.string(),
  type: z.literal('forge.user.list'),
});

export const userFilterSchema = z.object({
  enabled: z.boolean(),
  groups: z.array(z.string()).optional(),
  roleIds: z.array(z.number()).optional(),
});

export const customFieldContextOptionSchema = z.object({
  disabled: z.boolean(),
  id: z.string(),
  optionId: z.string().optional(),
  value: z.string(),
});

export const customFieldContextProjectMappingSchema = z.object({
  contextId: z.string(),
  isGlobalContext: z.boolean().optional(),
  projectId: z.string().optional(),
});

export const customFieldContextSingleUserPickerDefaultsSchema = z.object({
  accountId: z.string(),
  contextId: z.string(),
  type: z.literal('single.user.select'),
  userFilter: userFilterSchema,
});

export const customFieldContextUpdateDetailsSchema = z.object({
  description: z.string().optional(),
  name: z.string().optional(),
});

export const customFieldCreatedContextOptionsListSchema = z.object({
  options: z.array(customFieldContextOptionSchema).optional(),
});

export const customFieldDefinitionJsonBeanSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
  searcherKey: z
    .union([
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:cascadingselectsearcher'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:daterange'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:datetimerange'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:exactnumber'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:exacttextsearcher'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:grouppickersearcher'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:labelsearcher'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:multiselectsearcher'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:numberrange'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:projectsearcher'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:textsearcher'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:userpickergroupsearcher'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:versionsearcher'),
    ])
    .optional(),
  type: z.string(),
});

export const searcherKeySchema = z.union([
  z.literal('com.atlassian.jira.plugin.system.customfieldtypes:cascadingselectsearcher'),
  z.literal('com.atlassian.jira.plugin.system.customfieldtypes:daterange'),
  z.literal('com.atlassian.jira.plugin.system.customfieldtypes:datetimerange'),
  z.literal('com.atlassian.jira.plugin.system.customfieldtypes:exactnumber'),
  z.literal('com.atlassian.jira.plugin.system.customfieldtypes:exacttextsearcher'),
  z.literal('com.atlassian.jira.plugin.system.customfieldtypes:grouppickersearcher'),
  z.literal('com.atlassian.jira.plugin.system.customfieldtypes:labelsearcher'),
  z.literal('com.atlassian.jira.plugin.system.customfieldtypes:multiselectsearcher'),
  z.literal('com.atlassian.jira.plugin.system.customfieldtypes:numberrange'),
  z.literal('com.atlassian.jira.plugin.system.customfieldtypes:projectsearcher'),
  z.literal('com.atlassian.jira.plugin.system.customfieldtypes:textsearcher'),
  z.literal('com.atlassian.jira.plugin.system.customfieldtypes:userpickergroupsearcher'),
  z.literal('com.atlassian.jira.plugin.system.customfieldtypes:versionsearcher'),
]);

export const customFieldOptionSchema = z.object({
  self: z.string().optional(),
  value: z.string().optional(),
});

export const customFieldReplacementSchema = z.object({
  customFieldId: z.number().optional(),
  moveTo: z.number().optional(),
});

export const customFieldUpdatedContextOptionsListSchema = z.object({
  options: z.array(customFieldOptionUpdateSchema).optional(),
});

export const customFieldValueUpdateSchema = z.object({
  issueIds: z.array(z.number()),
  value: z.string().optional(),
});

export const customFieldValueUpdateDetailsSchema = z.object({
  updates: z.array(customFieldValueUpdateSchema).optional(),
});

export const dashboardGadgetPositionSchema = z.object({
  'The column position of the gadget.': z.number(),
  'The row position of the gadget.': z.number(),
});

export const colorSchema = z.union([
  z.literal('blue'),
  z.literal('red'),
  z.literal('yellow'),
  z.literal('green'),
  z.literal('cyan'),
  z.literal('purple'),
  z.literal('gray'),
  z.literal('white'),
]);

export const dashboardGadgetSchema = z.object({
  color: z.union([
    z.literal('blue'),
    z.literal('red'),
    z.literal('yellow'),
    z.literal('green'),
    z.literal('cyan'),
    z.literal('purple'),
    z.literal('gray'),
    z.literal('white'),
  ]),
  id: z.number(),
  moduleKey: z.string().optional(),
  position: dashboardGadgetPositionSchema,
  title: z.string(),
  uri: z.string().optional(),
});

export const dashboardGadgetSettingsSchema = z.object({
  color: z.string().optional(),
  ignoreUriAndModuleKeyValidation: z.boolean().optional(),
  moduleKey: z.string().optional(),
  position: dashboardGadgetPositionSchema.optional(),
  title: z.string().optional(),
  uri: z.string().optional(),
});

export const dashboardGadgetUpdateRequestSchema = z.object({
  color: z.string().optional(),
  position: dashboardGadgetPositionSchema.optional(),
  title: z.string().optional(),
});

export const dataClassificationTagBeanSchema = z.object({
  color: z.string().optional(),
  description: z.string().optional(),
  guideline: z.string().optional(),
  id: z.string(),
  name: z.string().optional(),
  rank: z.number().optional(),
  status: z.string(),
});

export const defaultLevelValueSchema = z.object({
  defaultLevelId: z.string(),
  issueSecuritySchemeId: z.string(),
});

export const defaultShareScopeSchema = z.object({
  scope: z.union([z.literal('GLOBAL'), z.literal('AUTHENTICATED'), z.literal('PRIVATE')]),
});

export const updatedProjectCategorySchema = z.object({
  description: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  self: z.string().optional(),
});

export const projectDetailsSchema = z.object({
  avatarUrls: avatarUrlsBeanSchema.optional(),
  id: z.string().optional(),
  key: z.string().optional(),
  name: z.string().optional(),
  projectCategory: updatedProjectCategorySchema.optional(),
  projectTypeKey: z.union([z.literal('software'), z.literal('service_desk'), z.literal('business')]).optional(),
  self: z.string().optional(),
  simplified: z.boolean().optional(),
});

export const scopeSchema = z.object({
  project: projectDetailsSchema.optional(),
  type: z.union([z.literal('PROJECT'), z.literal('TEMPLATE')]).optional(),
});

export const defaultWorkflowSchema = z.object({
  updateDraftIfNeeded: z.boolean().optional(),
  workflow: z.string(),
});

export const deleteAndReplaceVersionBeanSchema = z.object({
  customFieldReplacementList: z.array(customFieldReplacementSchema).optional(),
  moveAffectedIssuesTo: z.number().optional(),
  moveFixIssuesTo: z.number().optional(),
});

export const deprecatedWorkflowSchema = z.object({
  default: z.boolean().optional(),
  description: z.string().optional(),
  lastModifiedDate: z.string().optional(),
  lastModifiedUser: z.string().optional(),
  lastModifiedUserAccountId: z.string().optional(),
  name: z.string().optional(),
  scope: scopeSchema.optional(),
  steps: z.number().optional(),
});

export const detailedErrorCollectionSchema = z.object({
  details: z.record(z.string()).optional(),
  errorMessages: z.array(z.string()).optional(),
  errors: z.record(z.string()).optional(),
});

export const documentVersionSchema = z.object({
  id: z.string(),
  versionNumber: z.number(),
});

export const entityPropertyDetailsSchema = z.object({
  entityId: z.number(),
  key: z.string(),
  value: z.string(),
});

export const errorSchema = z.object({
  count: z.number().optional(),
  issueIdsOrKeys: z.array(z.string()).optional(),
  message: z.string().optional(),
});

export const errorCollectionsSchema = z.record(z.string());

export const errorsSchema = z.object({
  issueIsSubtask: errorSchema.optional(),
  issuesInArchivedProjects: errorSchema.optional(),
  issuesInUnlicensedProjects: errorSchema.optional(),
  issuesNotFound: errorSchema.optional(),
  userDoesNotHavePermission: errorSchema.optional(),
});

export const notificationTypeSchema = z.union([
  z.literal('CurrentAssignee'),
  z.literal('Reporter'),
  z.literal('CurrentUser'),
  z.literal('ProjectLead'),
  z.literal('ComponentLead'),
  z.literal('User'),
  z.literal('Group'),
  z.literal('ProjectRole'),
  z.literal('EmailAddress'),
  z.literal('AllWatchers'),
  z.literal('UserCustomField'),
  z.literal('GroupCustomField'),
]);

export const expandPrioritySchemeBeanSchema = z.object({
  id: z.string().optional(),
  name: z.string().optional(),
  self: z.string().optional(),
});

export const expandPrioritySchemePageSchema = z.object({
  maxResults: z.number().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
});

export const exportArchivedIssuesTaskProgressResponseSchema = z.object({
  fileUrl: z.string().optional(),
  payload: z.string().optional(),
  progress: z.number().optional(),
  status: z.string().optional(),
  submittedTime: z.string().optional(),
  taskId: z.string().optional(),
});

export const failedWebhookSchema = z.object({
  body: z.string().optional(),
  failureTime: z.number(),
  id: z.string(),
  url: z.string(),
});

export const failedWebhooksSchema = z.object({
  maxResults: z.number(),
  next: z.string().optional(),
  values: z.array(failedWebhookSchema),
});

export const fieldLastUsedSchema = z.object({
  type: z.union([z.literal('TRACKED'), z.literal('NOT_TRACKED'), z.literal('NO_INFORMATION')]).optional(),
  value: z.string().optional(),
});

export const jsonTypeBeanSchema = z.object({
  configuration: z.record(z.string()).optional(),
  custom: z.string().optional(),
  customId: z.number().optional(),
  items: z.string().optional(),
  system: z.string().optional(),
  type: z.string(),
});

export const operator3Schema = z.literal('changed');

export const fieldConfigurationSchema = z.object({
  description: z.string(),
  id: z.number(),
  isDefault: z.boolean().optional(),
  name: z.string(),
});

export const fieldConfigurationDetailsSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
});

export const fieldConfigurationIssueTypeItemSchema = z.object({
  fieldConfigurationId: z.string(),
  fieldConfigurationSchemeId: z.string(),
  issueTypeId: z.string(),
});

export const fieldConfigurationItemSchema = z.object({
  description: z.string().optional(),
  id: z.string(),
  isHidden: z.boolean().optional(),
  isRequired: z.boolean().optional(),
  renderer: z.string().optional(),
});

export const fieldConfigurationItemsDetailsSchema = z.object({
  fieldConfigurationItems: z.array(fieldConfigurationItemSchema),
});

export const fieldConfigurationSchemeSchema = z.object({
  description: z.string().optional(),
  id: z.string(),
  name: z.string(),
});

export const fieldConfigurationSchemeProjectAssociationSchema = z.object({
  fieldConfigurationSchemeId: z.string().optional(),
  projectId: z.string(),
});

export const fieldConfigurationSchemeProjectsSchema = z.object({
  fieldConfigurationScheme: fieldConfigurationSchemeSchema.optional(),
  projectIds: z.array(z.string()),
});

export const fieldCreateMetadataSchema = z.object({
  allowedValues: z.array(z.unknown()).optional(),
  autoCompleteUrl: z.string().optional(),
  configuration: z.record(z.string()).optional(),
  defaultValue: z.string().optional(),
  fieldId: z.string(),
  hasDefaultValue: z.boolean().optional(),
  key: z.string(),
  name: z.string(),
  operations: z.array(z.string()),
  required: z.boolean(),
  schema: jsonTypeBeanSchema,
});

export const fieldDetailsSchema = z.object({
  clauseNames: z.array(z.string()).optional(),
  custom: z.boolean().optional(),
  id: z.string().optional(),
  key: z.string().optional(),
  name: z.string().optional(),
  navigable: z.boolean().optional(),
  orderable: z.boolean().optional(),
  schema: jsonTypeBeanSchema.optional(),
  scope: scopeSchema.optional(),
  searchable: z.boolean().optional(),
});

export const type2Schema = z.union([z.literal('TRACKED'), z.literal('NOT_TRACKED'), z.literal('NO_INFORMATION')]);

export const fieldMetadataSchema = z.object({
  allowedValues: z.array(z.unknown()).optional(),
  autoCompleteUrl: z.string().optional(),
  configuration: z.record(z.string()).optional(),
  defaultValue: z.string().optional(),
  hasDefaultValue: z.boolean().optional(),
  key: z.string(),
  name: z.string(),
  operations: z.array(z.string()),
  required: z.boolean(),
  schema: jsonTypeBeanSchema,
});

export const fieldReferenceDataSchema = z.object({
  auto: z.union([z.literal('true'), z.literal('false')]).optional(),
  cfid: z.string().optional(),
  deprecated: z.union([z.literal('true'), z.literal('false')]).optional(),
  deprecatedSearcherKey: z.string().optional(),
  displayName: z.string().optional(),
  operators: z.array(z.string()).optional(),
  orderable: z.union([z.literal('true'), z.literal('false')]).optional(),
  searchable: z.union([z.literal('true'), z.literal('false')]).optional(),
  types: z.array(z.string()).optional(),
  value: z.string().optional(),
});

export const autoSchema = z.union([z.literal('true'), z.literal('false')]);

export const deprecatedSchema = z.union([z.literal('true'), z.literal('false')]);

export const orderableSchema = z.union([z.literal('true'), z.literal('false')]);

export const searchableSchema = z.union([z.literal('true'), z.literal('false')]);

export const fieldUpdateOperationSchema = z.object({
  add: z.string().optional(),
  copy: z.string().optional(),
  edit: z.string().optional(),
  remove: z.string().optional(),
  set: z.string().optional(),
});

export const operator4Schema = z.union([
  z.literal('='),
  z.literal('!='),
  z.literal('>'),
  z.literal('<'),
  z.literal('>='),
  z.literal('<='),
  z.literal('in'),
  z.literal('not in'),
  z.literal('~'),
  z.literal('~='),
  z.literal('is'),
  z.literal('is not'),
]);

export const operator5Schema = z.union([
  z.literal('was'),
  z.literal('was in'),
  z.literal('was not in'),
  z.literal('was not'),
]);

export const issueTypeDetailsSchema = z.object({
  avatarId: z.number().optional(),
  description: z.string().optional(),
  entityId: z.string().optional(),
  hierarchyLevel: z.number().optional(),
  iconUrl: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  scope: scopeSchema.optional(),
  self: z.string().optional(),
  subtask: z.boolean().optional(),
});

export const prioritySchema = z.object({
  avatarId: z.number().optional(),
  description: z.string().optional(),
  iconUrl: z.string().optional(),
  id: z.string().optional(),
  isDefault: z.boolean().optional(),
  name: z.string().optional(),
  schemes: expandPrioritySchemePageSchema.optional(),
  self: z.string().optional(),
  statusColor: z.string().optional(),
});

export const timeTrackingDetailsSchema = z.object({
  originalEstimate: z.string().optional(),
  originalEstimateSeconds: z.number().optional(),
  remainingEstimate: z.string().optional(),
  remainingEstimateSeconds: z.number().optional(),
  timeSpent: z.string().optional(),
  timeSpentSeconds: z.number().optional(),
});

export const groupLabelSchema = z.object({
  text: z.string().optional(),
  title: z.string().optional(),
  type: z.union([z.literal('ADMIN'), z.literal('SINGLE'), z.literal('MULTIPLE')]).optional(),
});

export const foundGroupSchema = z.object({
  groupId: z.string().optional(),
  html: z.string().optional(),
  labels: z.array(groupLabelSchema).optional(),
  name: z.string().optional(),
});

export const userPickerUserSchema = z.object({
  accountId: z.string().optional(),
  avatarUrl: z.string().optional(),
  displayName: z.string().optional(),
  html: z.string().optional(),
  key: z.string().optional(),
  name: z.string().optional(),
});

export const foundGroupsSchema = z.object({
  groups: z.array(foundGroupSchema).optional(),
  header: z.string().optional(),
  total: z.number().optional(),
});

export const foundUsersSchema = z.object({
  header: z.string().optional(),
  total: z.number().optional(),
  users: z.array(userPickerUserSchema).optional(),
});

export const functionOperandSchema = z.object({
  arguments: z.array(z.string()),
  encodedOperand: z.string().optional(),
  function: z.string(),
});

export const functionReferenceDataSchema = z.object({
  displayName: z.string().optional(),
  isList: z.union([z.literal('true'), z.literal('false')]).optional(),
  supportsListAndSingleValueOperators: z.union([z.literal('true'), z.literal('false')]).optional(),
  types: z.array(z.string()).optional(),
  value: z.string().optional(),
});

export const isListSchema = z.union([z.literal('true'), z.literal('false')]);

export const supportsListAndSingleValueOperatorsSchema = z.union([z.literal('true'), z.literal('false')]);

export const globalScopeBeanSchema = z.object({
  attributes: z.array(z.union([z.literal('notSelectable'), z.literal('defaultValue')])).optional(),
});

export const pagedListUserDetailsApplicationUserSchema = z.object({
  'end-index': z.number().optional(),
  items: z.array(userDetailsSchema).optional(),
  'max-results': z.number().optional(),
  size: z.number().optional(),
  'start-index': z.number().optional(),
});

export const groupDetailsSchema = z.object({
  groupId: z.string().optional().nullable(),
  name: z.string().optional(),
});

export const type3Schema = z.union([z.literal('ADMIN'), z.literal('SINGLE'), z.literal('MULTIPLE')]);

export const healthCheckResultSchema = z.object({
  description: z.string().optional(),
  name: z.string().optional(),
  passed: z.boolean().optional(),
});

export const simplifiedHierarchyLevelSchema = z.object({
  aboveLevelId: z.number().optional(),
  belowLevelId: z.number().optional(),
  externalUuid: z.string().optional(),
  hierarchyLevelNumber: z.number().optional(),
  id: z.number().optional(),
  issueTypeIds: z.array(z.number()).optional(),
  level: z.number().optional(),
  name: z.string().optional(),
  projectConfigurationId: z.number().optional(),
});

export const historyMetadataParticipantSchema = z.object({
  avatarUrl: z.string().optional(),
  displayName: z.string().optional(),
  displayNameKey: z.string().optional(),
  id: z.string().optional(),
  type: z.string().optional(),
  url: z.string().optional(),
});

export const iconBeanSchema = z.object({
  link: z.string().optional(),
  title: z.string().optional(),
  url16x16: z.string().optional(),
});

export const idBeanSchema = z.object({
  id: z.number(),
});

export const idOrKeyBeanSchema = z.object({
  id: z.number().optional(),
  key: z.string().optional(),
});

export const idSearchRequestBeanSchema = z.object({
  jql: z.string().optional(),
  maxResults: z.number().optional(),
  nextPageToken: z.string().optional(),
});

export const idSearchResultsSchema = z.object({
  issueIds: z.array(z.number()).optional(),
  nextPageToken: z.string().optional(),
});

export const includedFieldsSchema = z.object({
  actuallyIncluded: z.array(z.string()).optional(),
  excluded: z.array(z.string()).optional(),
  included: z.array(z.string()).optional(),
});

export const inputStreamSourceSchema = z.object({
  inputStream: z.record(z.string()).optional(),
});

export const issueArchivalSyncRequestSchema = z.object({
  issueIdsOrKeys: z.array(z.string()).optional(),
});

export const issueArchivalSyncResponseSchema = z.object({
  errors: errorsSchema.optional(),
  numberOfIssuesUpdated: z.number().optional(),
});

export const issueUpdateMetadataSchema = z.object({
  fields: z.record(fieldMetadataSchema).optional(),
});

export const issueBulkOperationsFieldOptionSchema = z.record(z.string());

export const issueChangelogIdsSchema = z.object({
  changelogIds: z.array(z.number()),
});

export const issueCommentListRequestBeanSchema = z.object({
  ids: z.array(z.number()),
});

export const issueEventSchema = z.object({
  id: z.number().optional(),
  name: z.string().optional(),
});

export const projectScopeBeanSchema = z.object({
  attributes: z.array(z.union([z.literal('notSelectable'), z.literal('defaultValue')])).optional(),
  id: z.number().optional(),
});

export const issueFilterForBulkPropertyDeleteSchema = z.object({
  currentValue: z.string().optional(),
  entityIds: z.array(z.number()).optional(),
});

export const issueLimitReportRequestSchema = z.object({
  issuesApproachingLimitParams: z.record(z.number()).optional(),
});

export const issueLimitReportResponseBeanSchema = z.object({
  issuesApproachingLimit: z.record(z.record(z.number())).optional(),
  issuesBreachingLimit: z.record(z.record(z.number())).optional(),
  limits: z.record(z.number()).optional(),
});

export const issueLinkTypeSchema = z.object({
  id: z.string().optional(),
  inward: z.string().optional(),
  name: z.string().optional(),
  outward: z.string().optional(),
  self: z.string().optional(),
});

export const issueLinkTypesSchema = z.object({
  issueLinkTypes: z.array(issueLinkTypeSchema).optional(),
});

export const issueListSchema = z.object({
  issueIds: z.array(z.string()),
});

export const issueMatchesForJQLSchema = z.object({
  errors: z.array(z.string()),
  matchedIssues: z.array(z.number()),
});

export const suggestedIssueSchema = z.object({
  id: z.number().optional(),
  img: z.string().optional(),
  key: z.string().optional(),
  keyHtml: z.string().optional(),
  summary: z.string().optional(),
  summaryText: z.string().optional(),
});

export const permissionHolderSchema = z.object({
  expand: z.string().optional(),
  parameter: z.string().optional(),
  type: z.string(),
  value: z.string().optional(),
});

export const issueSecuritySchemeToProjectMappingSchema = z.object({
  issueSecuritySchemeId: z.string().optional(),
  projectId: z.string().optional(),
});

export const issueTypeCreateBeanSchema = z.object({
  description: z.string().optional(),
  hierarchyLevel: z.number().optional(),
  name: z.string(),
  type: z.union([z.literal('subtask'), z.literal('standard')]).optional(),
});

export const type4Schema = z.union([z.literal('subtask'), z.literal('standard')]);

export const issueTypeIdsSchema = z.object({
  issueTypeIds: z.array(z.string()),
});

export const issueTypeIdsToRemoveSchema = z.object({
  issueTypeIds: z.array(z.string()),
});

export const issueTypeInfoSchema = z.object({
  avatarId: z.number().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
});

export const issueTypeIssueCreateMetadataSchema = z.object({
  avatarId: z.number().optional(),
  description: z.string().optional(),
  entityId: z.string().optional(),
  expand: z.string().optional(),
  fields: z.record(fieldMetadataSchema).optional(),
  hierarchyLevel: z.number().optional(),
  iconUrl: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  scope: scopeSchema.optional(),
  self: z.string().optional(),
  subtask: z.boolean().optional(),
});

export const issueTypeSchemeSchema = z.object({
  defaultIssueTypeId: z.string().optional(),
  description: z.string().optional(),
  id: z.string(),
  isDefault: z.boolean().optional(),
  name: z.string(),
});

export const issueTypeSchemeDetailsSchema = z.object({
  defaultIssueTypeId: z.string().optional(),
  description: z.string().optional(),
  issueTypeIds: z.array(z.string()),
  name: z.string(),
});

export const issueTypeSchemeIDSchema = z.object({
  issueTypeSchemeId: z.string(),
});

export const issueTypeSchemeMappingSchema = z.object({
  issueTypeId: z.string(),
  issueTypeSchemeId: z.string(),
});

export const issueTypeSchemeProjectAssociationSchema = z.object({
  issueTypeSchemeId: z.string(),
  projectId: z.string(),
});

export const issueTypeSchemeProjectsSchema = z.object({
  issueTypeScheme: issueTypeSchemeSchema,
  projectIds: z.array(z.string()),
});

export const issueTypeSchemeUpdateDetailsSchema = z.object({
  defaultIssueTypeId: z.string().optional(),
  description: z.string().optional(),
  name: z.string().optional(),
});

export const issueTypeScreenSchemeSchema = z.object({
  description: z.string().optional(),
  id: z.string(),
  name: z.string(),
});

export const issueTypeScreenSchemeMappingSchema = z.object({
  issueTypeId: z.string(),
  screenSchemeId: z.string(),
});

export const issueTypeScreenSchemeIdSchema = z.object({
  id: z.string(),
});

export const issueTypeScreenSchemeItemSchema = z.object({
  issueTypeId: z.string(),
  issueTypeScreenSchemeId: z.string(),
  screenSchemeId: z.string(),
});

export const issueTypeScreenSchemeMappingDetailsSchema = z.object({
  issueTypeMappings: z.array(issueTypeScreenSchemeMappingSchema),
});

export const issueTypeScreenSchemeProjectAssociationSchema = z.object({
  issueTypeScreenSchemeId: z.string().optional(),
  projectId: z.string().optional(),
});

export const issueTypeScreenSchemeUpdateDetailsSchema = z.object({
  description: z.string().optional(),
  name: z.string().optional(),
});

export const issueTypeScreenSchemesProjectsSchema = z.object({
  issueTypeScreenScheme: issueTypeScreenSchemeSchema,
  projectIds: z.array(z.string()),
});

export const issueTypeToContextMappingSchema = z.object({
  contextId: z.string(),
  isAnyIssueType: z.boolean().optional(),
  issueTypeId: z.string().optional(),
});

export const issueTypeUpdateBeanSchema = z.object({
  avatarId: z.number().optional(),
  description: z.string().optional(),
  name: z.string().optional(),
});

export const issueTypeWorkflowMappingSchema = z.object({
  issueType: z.string().optional(),
  updateDraftIfNeeded: z.boolean().optional(),
  workflow: z.string().optional(),
});

export const issueTypesWorkflowMappingSchema = z.object({
  defaultMapping: z.boolean().optional(),
  issueTypes: z.array(z.string()).optional(),
  updateDraftIfNeeded: z.boolean().optional(),
  workflow: z.string().optional(),
});

export const historyMetadataSchema = z.object({
  activityDescription: z.string().optional(),
  activityDescriptionKey: z.string().optional(),
  actor: historyMetadataParticipantSchema.optional(),
  cause: historyMetadataParticipantSchema.optional(),
  description: z.string().optional(),
  descriptionKey: z.string().optional(),
  emailDescription: z.string().optional(),
  emailDescriptionKey: z.string().optional(),
  extraData: z.record(z.string()).optional(),
  generator: historyMetadataParticipantSchema.optional(),
  type: z.string().optional(),
});

export const issuesAndJQLQueriesSchema = z.object({
  issueIds: z.array(z.number()),
  jqls: z.array(z.string()),
});

export const issuesJqlMetaDataBeanSchema = z.object({
  count: z.number(),
  maxResults: z.number(),
  startAt: z.number(),
  totalCount: z.number(),
  validationWarnings: z.array(z.string()).optional(),
});

export const issuesMetaBeanSchema = z.object({
  jql: issuesJqlMetaDataBeanSchema.optional(),
});

export const jExpEvaluateIssuesJqlMetaDataBeanSchema = z.object({
  nextPageToken: z.string(),
});

export const jExpEvaluateIssuesMetaBeanSchema = z.object({
  jql: jExpEvaluateIssuesJqlMetaDataBeanSchema.optional(),
});

export const jQLCountRequestBeanSchema = z.object({
  jql: z.string().optional(),
});

export const jQLCountResultsBeanSchema = z.object({
  count: z.number().optional(),
});

export const jQLPersonalDataMigrationRequestSchema = z.object({
  queryStrings: z.array(z.string()).optional(),
});

export const jQLReferenceDataSchema = z.object({
  jqlReservedWords: z.array(z.string()).optional(),
  visibleFieldNames: z.array(fieldReferenceDataSchema).optional(),
  visibleFunctionNames: z.array(functionReferenceDataSchema).optional(),
});

export const jexpEvaluateCtxJqlIssuesSchema = z.object({
  maxResults: z.number().optional(),
  nextPageToken: z.string().optional(),
  query: z.string().optional(),
});

export const jexpJqlIssuesSchema = z.object({
  maxResults: z.number().optional(),
  query: z.string().optional(),
  startAt: z.number().optional(),
  validation: z.union([z.literal('strict'), z.literal('warn'), z.literal('none')]).optional(),
});

export const validationSchema = z.union([z.literal('strict'), z.literal('warn'), z.literal('none')]);

export const jiraSelectedOptionFieldSchema = z.object({
  optionId: z.number().optional(),
});

export const jiraColorInputSchema = z.object({
  name: z.string(),
});

export const jiraComponentFieldSchema = z.object({
  componentId: z.number(),
});

export const jiraDateInputSchema = z.object({
  formattedDate: z.string(),
});

export const jiraDateTimeInputSchema = z.object({
  formattedDateTime: z.string(),
});

export const jiraDurationFieldSchema = z.object({
  originalEstimateField: z.string(),
});

export const jiraExpressionComplexitySchema = z.object({
  expensiveOperations: z.string(),
  variables: z.record(z.string()).optional(),
});

export const jiraExpressionValidationErrorSchema = z.object({
  column: z.number().optional(),
  expression: z.string().optional(),
  line: z.number().optional(),
  message: z.string(),
  type: z.union([z.literal('syntax'), z.literal('type'), z.literal('other')]),
});

export const customContextVariableSchema = z
  .union([userContextVariableSchema, issueContextVariableSchema, jsonContextVariableSchema])
  .and(
    z.object({
      type: z.string(),
    }),
  );

export const jexpIssuesSchema = z.object({
  jql: jexpJqlIssuesSchema.optional(),
});

export const jiraExpressionEvalContextBeanSchema = z.object({
  board: z.number().optional(),
  custom: z.array(customContextVariableSchema).optional(),
  customerRequest: z.number().optional(),
  issue: idOrKeyBeanSchema.optional(),
  issues: jexpIssuesSchema.optional(),
  project: idOrKeyBeanSchema.optional(),
  serviceDesk: z.number().optional(),
  sprint: z.number().optional(),
});

export const jexpEvaluateCtxIssuesSchema = z.object({
  jql: jexpEvaluateCtxJqlIssuesSchema.optional(),
});

export const jiraExpressionEvaluateContextBeanSchema = z.object({
  board: z.number().optional(),
  custom: z.array(customContextVariableSchema).optional(),
  customerRequest: z.number().optional(),
  issue: idOrKeyBeanSchema.optional(),
  issues: jexpEvaluateCtxIssuesSchema.optional(),
  project: idOrKeyBeanSchema.optional(),
  serviceDesk: z.number().optional(),
  sprint: z.number().optional(),
});

export const jiraExpressionForAnalysisSchema = z.object({
  contextVariables: z.record(z.string()).optional(),
  expressions: z.array(z.string()),
});

export const type5Schema = z.union([z.literal('syntax'), z.literal('type'), z.literal('other')]);

export const jiraExpressionAnalysisSchema = z.object({
  complexity: jiraExpressionComplexitySchema.optional(),
  errors: z.array(jiraExpressionValidationErrorSchema).optional(),
  expression: z.string(),
  type: z.string().optional(),
  valid: z.boolean(),
});

export const jiraExpressionsComplexityValueBeanSchema = z.object({
  limit: z.number(),
  value: z.number(),
});

export const jiraGroupInputSchema = z.object({
  groupName: z.string(),
});

export const jiraCascadingSelectFieldSchema = z.object({
  childOptionValue: jiraSelectedOptionFieldSchema.optional(),
  fieldId: z.string(),
  parentOptionValue: jiraSelectedOptionFieldSchema,
});

export const jiraNumberFieldSchema = z.object({
  fieldId: z.string(),
  value: z.number().optional(),
});

export const jiraColorFieldSchema = z.object({
  color: jiraColorInputSchema,
  fieldId: z.string(),
});

export const jiraDateFieldSchema = z.object({
  date: jiraDateInputSchema.optional(),
  fieldId: z.string(),
});

export const jiraDateTimeFieldSchema = z.object({
  dateTime: jiraDateTimeInputSchema,
  fieldId: z.string(),
});

export const jiraIssueTypeFieldSchema = z.object({
  issueTypeId: z.string(),
});

export const jiraMultipleGroupPickerFieldSchema = z.object({
  fieldId: z.string(),
  groups: z.array(jiraGroupInputSchema),
});

export const jiraMultipleSelectFieldSchema = z.object({
  fieldId: z.string(),
  options: z.array(jiraSelectedOptionFieldSchema),
});

export const jiraMultiSelectComponentFieldSchema = z.object({
  bulkEditMultiSelectFieldOption: z.union([
    z.literal('ADD'),
    z.literal('REMOVE'),
    z.literal('REPLACE'),
    z.literal('REMOVE_ALL'),
  ]),
  components: z.array(jiraComponentFieldSchema),
  fieldId: z.string(),
});

export const jiraPriorityFieldSchema = z.object({
  priorityId: z.string(),
});

export const jiraSingleGroupPickerFieldSchema = z.object({
  fieldId: z.string(),
  group: jiraGroupInputSchema,
});

export const jiraSingleLineTextFieldSchema = z.object({
  fieldId: z.string(),
  text: z.string(),
});

export const jiraSingleSelectFieldSchema = z.object({
  fieldId: z.string(),
  option: jiraSelectedOptionFieldSchema,
});

export const jiraTimeTrackingFieldSchema = z.object({
  timeRemaining: z.string(),
});

export const jiraUrlFieldSchema = z.object({
  fieldId: z.string(),
  url: z.string(),
});

export const jiraLabelsInputSchema = z.object({
  name: z.string(),
});

export const bulkEditMultiSelectFieldOptionSchema = z.union([
  z.literal('ADD'),
  z.literal('REMOVE'),
  z.literal('REPLACE'),
  z.literal('REMOVE_ALL'),
]);

export const jiraUserFieldSchema = z.object({
  accountId: z.string(),
});

export const jiraVersionFieldSchema = z.object({
  versionId: z.string().optional(),
});

export const jiraRichTextInputSchema = z.object({
  adfValue: z.record(z.string()).optional(),
});

export const jiraSingleSelectUserPickerFieldSchema = z.object({
  fieldId: z.string(),
  user: jiraUserFieldSchema.optional(),
});

export const jiraSingleVersionPickerFieldSchema = z.object({
  fieldId: z.string(),
  version: jiraVersionFieldSchema,
});

export const workflowUsagesSchema = z.object({
  workflowId: z.string().optional(),
  workflowName: z.string().optional(),
});

export const statusCategorySchema = z.object({
  colorName: z.string().optional(),
  id: z.number().optional(),
  key: z.string().optional(),
  name: z.string().optional(),
  self: z.string().optional(),
});

export const workflowLayoutSchema = z
  .object({
    x: z.number().optional(),
    y: z.number().optional(),
  })
  .nullable();

export const jqlFunctionPrecomputationBeanSchema = z.object({
  arguments: z.array(z.string()).optional(),
  created: z.string().optional(),
  error: z.string().optional(),
  field: z.string().optional(),
  functionKey: z.string().optional(),
  functionName: z.string().optional(),
  id: z.string().optional(),
  operator: z.string().optional(),
  updated: z.string().optional(),
  used: z.string().optional(),
  value: z.string().optional(),
});

export const jqlFunctionPrecomputationUpdateBeanSchema = z.object({
  error: z.string().optional(),
  id: z.string(),
  value: z.string().optional(),
});

export const jqlFunctionPrecomputationUpdateRequestBeanSchema = z.object({
  values: z.array(jqlFunctionPrecomputationUpdateBeanSchema).optional(),
});

export const jqlQueriesToParseSchema = z.object({
  queries: z.array(z.string()),
});

export const jqlQueryToSanitizeSchema = z.object({
  accountId: z.string().optional().nullable(),
  query: z.string(),
});

export const valueOperandSchema = z.object({
  encodedValue: z.string().optional(),
  value: z.string(),
});

export const keywordOperandSchema = z.object({
  keyword: z.literal('empty'),
});

export const operator6Schema = z.union([
  z.literal('before'),
  z.literal('after'),
  z.literal('from'),
  z.literal('to'),
  z.literal('on'),
  z.literal('during'),
  z.literal('by'),
]);

export const jqlQueryFieldEntityPropertySchema = z.object({
  entity: z.string(),
  key: z.string(),
  path: z.string(),
  type: z
    .union([z.literal('number'), z.literal('string'), z.literal('text'), z.literal('date'), z.literal('user')])
    .optional(),
});

export const type6Schema = z.union([
  z.literal('number'),
  z.literal('string'),
  z.literal('text'),
  z.literal('date'),
  z.literal('user'),
]);

export const jqlQueryFieldSchema = z.object({
  encodedName: z.string().optional(),
  name: z.string(),
  property: z.array(jqlQueryFieldEntityPropertySchema).optional(),
});

export const directionSchema = z.union([z.literal('asc'), z.literal('desc')]);

export const jqlQueryUnitaryOperandSchema = z.union([valueOperandSchema, functionOperandSchema, keywordOperandSchema]);

export const jsonNodeSchema = z.object({
  array: z.boolean().optional(),
  bigDecimal: z.boolean().optional(),
  bigInteger: z.boolean().optional(),
  bigIntegerValue: z.number().optional(),
  binary: z.boolean().optional(),
  binaryValue: z.array(z.string()).optional(),
  boolean: z.boolean().optional(),
  booleanValue: z.boolean().optional(),
  containerNode: z.boolean().optional(),
  decimalValue: z.number().optional(),
  double: z.boolean().optional(),
  doubleValue: z.number().optional(),
  elements: z.record(z.string()).optional(),
  fieldNames: z.record(z.string()).optional(),
  fields: z.record(z.string()).optional(),
  floatingPointNumber: z.boolean().optional(),
  int: z.boolean().optional(),
  intValue: z.number().optional(),
  integralNumber: z.boolean().optional(),
  long: z.boolean().optional(),
  longValue: z.number().optional(),
  missingNode: z.boolean().optional(),
  null: z.boolean().optional(),
  number: z.boolean().optional(),
  numberType: z
    .union([
      z.literal('INT'),
      z.literal('LONG'),
      z.literal('BIG_INTEGER'),
      z.literal('FLOAT'),
      z.literal('DOUBLE'),
      z.literal('BIG_DECIMAL'),
    ])
    .optional(),
  numberValue: z.number().optional(),
  object: z.boolean().optional(),
  pojo: z.boolean().optional(),
  textValue: z.string().optional(),
  textual: z.boolean().optional(),
  valueAsBoolean: z.boolean().optional(),
  valueAsDouble: z.number().optional(),
  valueAsInt: z.number().optional(),
  valueAsLong: z.number().optional(),
  valueAsText: z.string().optional(),
  valueNode: z.boolean().optional(),
});

export const numberTypeSchema = z.union([
  z.literal('INT'),
  z.literal('LONG'),
  z.literal('BIG_INTEGER'),
  z.literal('FLOAT'),
  z.literal('DOUBLE'),
  z.literal('BIG_DECIMAL'),
]);

export const keywordSchema = z.literal('empty');

export const attachmentSchema = z.object({
  author: userDetailsSchema.optional(),
  content: z.string().optional(),
  created: z.string().optional(),
  filename: z.string().optional(),
  id: z.string().optional(),
  mimeType: z.string().optional(),
  self: z.string().optional(),
  size: z.number().optional(),
  thumbnail: z.string().optional(),
});

export const legacyJackson1ListColumnItemSchema = z.array(columnItemSchema);

export const legacyJackson1ListIssueEventSchema = z.array(issueEventSchema);

export const projectRoleDetailsSchema = z.object({
  admin: z.boolean().optional(),
  default: z.boolean().optional(),
  description: z.string().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  roleConfigurable: z.boolean().optional(),
  scope: scopeSchema.optional(),
  self: z.string().optional(),
  translatedName: z.string().optional(),
});

export const projectTypeSchema = z.object({
  color: z.string().optional(),
  descriptionI18nKey: z.string().optional(),
  formattedKey: z.string().optional(),
  icon: z.string().optional(),
  key: z.string().optional(),
});

export const userMigrationBeanSchema = z.object({
  accountId: z.string().optional(),
  key: z.string().optional(),
  username: z.string().optional(),
});

export const worklogSchema = z.object({
  author: userDetailsSchema.optional(),
  comment: z.string().optional(),
  created: z.string().optional(),
  id: z.string().optional(),
  issueId: z.string().optional(),
  properties: z.array(entityPropertySchema).optional(),
  self: z.string().optional(),
  started: z.string().optional(),
  timeSpent: z.string().optional(),
  timeSpentSeconds: z.number().optional(),
  updateAuthor: userDetailsSchema.optional(),
  updated: z.string().optional(),
  visibility: visibilitySchema.optional(),
});

export const licensedApplicationSchema = z.object({
  id: z.string(),
  plan: z.union([z.literal('UNLICENSED'), z.literal('FREE'), z.literal('PAID')]),
});

export const licenseMetricSchema = z.object({
  key: z.string().optional(),
  value: z.string().optional(),
});

export const planSchema = z.union([z.literal('UNLICENSED'), z.literal('FREE'), z.literal('PAID')]);

export const simpleLinkSchema = z.object({
  href: z.string().optional(),
  iconClass: z.string().optional(),
  id: z.string().optional(),
  label: z.string().optional(),
  styleClass: z.string().optional(),
  title: z.string().optional(),
  weight: z.number().optional(),
});

export const listOperandSchema = z.object({
  encodedOperand: z.string().optional(),
  values: z.array(jqlQueryUnitaryOperandSchema),
});

export const listWrapperCallbackApplicationRoleSchema = z.record(z.string());

export const listWrapperCallbackGroupNameSchema = z.record(z.string());

export const localeSchema = z.object({
  locale: z.string().optional(),
});

export const mandatoryFieldValueSchema = z.object({
  retain: z.boolean().optional().nullable(),
  type: z.union([z.literal('adf'), z.literal('raw')]),
  value: z.array(z.string()),
});

export const type7Schema = z.union([z.literal('adf'), z.literal('raw')]);

export const mandatoryFieldValueForADFSchema = z.object({
  retain: z.boolean().optional().nullable(),
  type: z.union([z.literal('adf'), z.literal('raw')]),
  value: z.record(z.string()),
});

export const workflowAssociationStatusMappingSchema = z.object({
  newStatusId: z.string(),
  oldStatusId: z.string(),
});

export const mappingsByWorkflowSchema = z.object({
  newWorkflowId: z.string(),
  oldWorkflowId: z.string(),
  statusMappings: z.array(workflowAssociationStatusMappingSchema),
});

export const moveFieldBeanSchema = z.object({
  after: z.string().optional(),
  position: z.union([z.literal('Earlier'), z.literal('Later'), z.literal('First'), z.literal('Last')]).optional(),
});

export const positionSchema = z.union([
  z.literal('Earlier'),
  z.literal('Later'),
  z.literal('First'),
  z.literal('Last'),
]);

export const issueEntityPropertiesForMultiUpdateSchema = z.object({
  issueID: z.number().optional(),
  properties: z.record(jsonNodeSchema).optional(),
});

export const multipleCustomFieldValuesUpdateSchema = z.object({
  customField: z.string(),
  issueIds: z.array(z.number()),
  value: z.string().optional(),
});

export const multipleCustomFieldValuesUpdateDetailsSchema = z.object({
  updates: z.array(multipleCustomFieldValuesUpdateSchema).optional(),
});

export const warningCollectionSchema = z.object({
  warnings: z.array(z.string()).optional(),
});

export const newUserDetailsSchema = z.object({
  applicationKeys: z.array(z.string()).optional(),
  displayName: z.string().optional(),
  emailAddress: z.string(),
  key: z.string().optional(),
  name: z.string().optional(),
  password: z.string().optional(),
  products: z.array(z.string()),
  self: z.string().optional(),
});

export const notificationRecipientsSchema = z.object({
  assignee: z.boolean().optional(),
  groupIds: z.array(z.string()).optional(),
  groups: z.array(groupNameSchema).optional(),
  reporter: z.boolean().optional(),
  users: z.array(userDetailsSchema).optional(),
  voters: z.boolean().optional(),
  watchers: z.boolean().optional(),
});

export const notificationEventSchema: z.ZodSchema<NotificationEvent> = z.lazy(() =>
  z.object({
    description: z.string().optional(),
    id: z.number().optional(),
    name: z.string().optional(),
    templateEvent: notificationEventSchema.optional(),
  }),
);

export const restrictedPermissionSchema = z.object({
  id: z.string().optional(),
  key: z.string().optional(),
});

export const notificationSchemeAndProjectMappingJsonBeanSchema = z.object({
  notificationSchemeId: z.string().optional(),
  projectId: z.string().optional(),
});

export const notificationSchemeEventTypeIdSchema = z.object({
  id: z.string(),
});

export const notificationSchemeNotificationDetailsSchema = z.object({
  notificationType: z.string(),
  parameter: z.string().optional(),
});

export const notificationSchemeIdSchema = z.object({
  id: z.string(),
});

export const operationMessageSchema = z.object({
  message: z.string(),
  statusCode: z.number(),
});

export const linkGroupSchema: z.ZodSchema<LinkGroup> = z.lazy(() =>
  z.object({
    groups: z.array(linkGroupSchema).optional(),
    header: simpleLinkSchema.optional(),
    id: z.string().optional(),
    links: z.array(simpleLinkSchema).optional(),
    styleClass: z.string().optional(),
    weight: z.number().optional(),
  }),
);

export const orderOfCustomFieldOptionsSchema = z.object({
  after: z.string().optional(),
  customFieldOptionIds: z.array(z.string()),
  position: z.union([z.literal('First'), z.literal('Last')]).optional(),
});

export const position2Schema = z.union([z.literal('First'), z.literal('Last')]);

export const orderOfIssueTypesSchema = z.object({
  after: z.string().optional(),
  issueTypeIds: z.array(z.string()),
  position: z.union([z.literal('First'), z.literal('Last')]).optional(),
});

export const pageBean2ComponentJsonBeanSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(componentJsonBeanSchema).optional(),
});

export const pageBeanBulkContextualConfigurationSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(bulkContextualConfigurationSchema).optional(),
});

export const changelogSchema = z.object({
  author: userDetailsSchema.optional(),
  created: z.string().optional(),
  historyMetadata: historyMetadataSchema.optional(),
  id: z.string().optional(),
  items: z.array(changeDetailsSchema).optional(),
});

export const pageBeanCommentSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(commentSchema).optional(),
});

export const contextSchema = z.object({
  id: z.number().optional(),
  name: z.string().optional(),
  scope: scopeSchema.optional(),
});

export const pageBeanContextForProjectAndIssueTypeSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(contextForProjectAndIssueTypeSchema).optional(),
});

export const pageBeanContextualConfigurationSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(contextualConfigurationSchema).optional(),
});

export const pageBeanCustomFieldContextSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(customFieldContextSchema).optional(),
});

export const pageBeanCustomFieldContextOptionSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(customFieldContextOptionSchema).optional(),
});

export const pageBeanCustomFieldContextProjectMappingSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(customFieldContextProjectMappingSchema).optional(),
});

export const fieldSchema = z.object({
  contextsCount: z.number().optional(),
  description: z.string().optional(),
  id: z.string(),
  isLocked: z.boolean().optional(),
  isUnscreenable: z.boolean().optional(),
  key: z.string().optional(),
  lastUsed: fieldLastUsedSchema.optional(),
  name: z.string(),
  projectsCount: z.number().optional(),
  schema: jsonTypeBeanSchema,
  screensCount: z.number().optional(),
  searcherKey: z.string().optional(),
  stableId: z.string().optional(),
});

export const pageBeanFieldConfigurationDetailsSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(fieldConfigurationDetailsSchema).optional(),
});

export const pageBeanFieldConfigurationIssueTypeItemSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(fieldConfigurationIssueTypeItemSchema).optional(),
});

export const pageBeanFieldConfigurationItemSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(fieldConfigurationItemSchema).optional(),
});

export const pageBeanFieldConfigurationSchemeSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(fieldConfigurationSchemeSchema).optional(),
});

export const pageBeanFieldConfigurationSchemeProjectsSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(fieldConfigurationSchemeProjectsSchema).optional(),
});

export const pageBeanGroupDetailsSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(groupDetailsSchema).optional(),
});

export const issueSecurityLevelMemberSchema = z.object({
  holder: permissionHolderSchema,
  id: z.number(),
  issueSecurityLevelId: z.number(),
  managed: z.boolean().optional(),
});

export const pageBeanIssueSecuritySchemeToProjectMappingSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(issueSecuritySchemeToProjectMappingSchema).optional(),
});

export const pageBeanIssueTypeSchemeSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(issueTypeSchemeSchema).optional(),
});

export const pageBeanIssueTypeSchemeMappingSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(issueTypeSchemeMappingSchema).optional(),
});

export const pageBeanIssueTypeSchemeProjectsSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(issueTypeSchemeProjectsSchema).optional(),
});

export const pageBeanIssueTypeScreenSchemeSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(issueTypeScreenSchemeSchema).optional(),
});

export const pageBeanIssueTypeScreenSchemeItemSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(issueTypeScreenSchemeItemSchema).optional(),
});

export const pageBeanIssueTypeScreenSchemesProjectsSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(issueTypeScreenSchemesProjectsSchema).optional(),
});

export const pageBeanIssueTypeToContextMappingSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(issueTypeToContextMappingSchema).optional(),
});

export const pageBeanJqlFunctionPrecomputationBeanSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(jqlFunctionPrecomputationBeanSchema).optional(),
});

export const pageBeanNotificationSchemeAndProjectMappingJsonBeanSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(notificationSchemeAndProjectMappingJsonBeanSchema).optional(),
});

export const pageBeanPrioritySchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(prioritySchema).optional(),
});

export const priorityWithSequenceSchema = z.object({
  description: z.string().optional(),
  iconUrl: z.string().optional(),
  id: z.string().optional(),
  isDefault: z.boolean().optional(),
  name: z.string().optional(),
  self: z.string().optional(),
  sequence: z.string().optional(),
  statusColor: z.string().optional(),
});

export const resolutionJsonBeanSchema = z.object({
  default: z.boolean().optional(),
  description: z.string().optional(),
  iconUrl: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  self: z.string().optional(),
});

export const screenSchema = z.object({
  description: z.string().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  scope: scopeSchema.optional(),
});

export const securityLevelSchema = z.object({
  description: z.string().optional(),
  id: z.string().optional(),
  isDefault: z.boolean().optional(),
  issueSecuritySchemeId: z.string().optional(),
  name: z.string().optional(),
  self: z.string().optional(),
});

export const securityLevelMemberSchema = z.object({
  holder: permissionHolderSchema,
  id: z.string(),
  issueSecurityLevelId: z.string(),
  issueSecuritySchemeId: z.string(),
  managed: z.boolean().optional(),
});

export const securitySchemeWithProjectsSchema = z.object({
  defaultLevel: z.number().optional(),
  description: z.string().optional(),
  id: z.number(),
  name: z.string(),
  projectIds: z.array(z.number()).optional(),
  self: z.string(),
});

export const pageBeanStringSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(z.string()).optional(),
});

export const uiModificationDetailsSchema = z.object({
  contexts: z.array(uiModificationContextDetailsSchema).optional(),
  data: z.string().optional(),
  description: z.string().optional(),
  id: z.string(),
  name: z.string(),
  self: z.string(),
});

export const pageBeanUserDetailsSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(userDetailsSchema).optional(),
});

export const userKeySchema = z.object({
  accountId: z.string().optional(),
  key: z.string().optional(),
});

export const webhookSchema = z.object({
  events: z.array(
    z.union([
      z.literal('jira:issue_created'),
      z.literal('jira:issue_updated'),
      z.literal('jira:issue_deleted'),
      z.literal('comment_created'),
      z.literal('comment_updated'),
      z.literal('comment_deleted'),
      z.literal('issue_property_set'),
      z.literal('issue_property_deleted'),
    ]),
  ),
  expirationDate: z.number().optional(),
  fieldIdsFilter: z.array(z.string()).optional(),
  id: z.number(),
  issuePropertyKeysFilter: z.array(z.string()).optional(),
  jqlFilter: z.string(),
});

export const pageOfChangelogsSchema = z.object({
  histories: z.array(changelogSchema).optional(),
  maxResults: z.number().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
});

export const pageOfCommentsSchema = z.object({
  comments: z.array(commentSchema).optional(),
  maxResults: z.number().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
});

export const pageOfCreateMetaIssueTypeWithFieldSchema = z.object({
  fields: z.array(fieldCreateMetadataSchema).optional(),
  maxResults: z.number().optional(),
  results: z.array(fieldCreateMetadataSchema).optional(),
  startAt: z.number().optional(),
});

export const pageOfCreateMetaIssueTypesSchema = z.object({
  createMetaIssueType: z.array(issueTypeIssueCreateMetadataSchema).optional(),
  issueTypes: z.array(issueTypeIssueCreateMetadataSchema).optional(),
  maxResults: z.number().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
});

export const pageOfWorklogsSchema = z.object({
  maxResults: z.number().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  worklogs: z.array(worklogSchema).optional(),
});

export const paginatedResponseCommentSchema = z.object({
  maxResults: z.number().optional(),
  results: z.array(commentSchema).optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
});

export const paginatedResponseFieldCreateMetadataSchema = z.object({
  maxResults: z.number().optional(),
  results: z.array(fieldCreateMetadataSchema).optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
});

export const paginatedResponseIssueTypeIssueCreateMetadataSchema = z.object({
  maxResults: z.number().optional(),
  results: z.array(issueTypeIssueCreateMetadataSchema).optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
});

export const permissionGrantSchema = z.object({
  holder: permissionHolderSchema.optional(),
  id: z.number().optional(),
  permission: z.string().optional(),
  self: z.string().optional(),
});

export const permissionGrantsSchema = z.object({
  expand: z.string().optional(),
  permissions: z.array(permissionGrantSchema).optional(),
});

export const permissionSchemeSchema = z.object({
  description: z.string().optional(),
  expand: z.string().optional(),
  id: z.number().optional(),
  name: z.string(),
  permissions: z.array(permissionGrantSchema).optional(),
  scope: scopeSchema.optional(),
  self: z.string().optional(),
});

export const permissionSchemesSchema = z.object({
  permissionSchemes: z.array(permissionSchemeSchema).optional(),
});

export const permissionsKeysBeanSchema = z.object({
  permissions: z.array(z.string()),
});

export const projectIdentifierBeanSchema = z.object({
  id: z.number().optional(),
  key: z.string().optional(),
});

export const priorityIdSchema = z.object({
  id: z.string(),
});

export const prioritySchemeChangesWithMappingsSchema = z.object({
  ids: z.array(z.number()),
  mappings: z.array(priorityMappingSchema).optional(),
});

export const prioritySchemeChangesWithoutMappingsSchema = z.object({
  ids: z.array(z.number()),
});

export const taskProgressBeanJsonNodeSchema = z.object({
  description: z.string().optional(),
  elapsedRuntime: z.number(),
  finished: z.number().optional(),
  id: z.string(),
  lastUpdate: z.number(),
  message: z.string().optional(),
  progress: z.number(),
  result: jsonNodeSchema.optional(),
  self: z.string(),
  started: z.number().optional(),
  status: z.union([
    z.literal('ENQUEUED'),
    z.literal('RUNNING'),
    z.literal('COMPLETE'),
    z.literal('FAILED'),
    z.literal('CANCEL_REQUESTED'),
    z.literal('CANCELLED'),
    z.literal('DEAD'),
  ]),
  submitted: z.number(),
  submittedBy: z.number(),
});

export const pageBeanPriorityWithSequenceSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(priorityWithSequenceSchema).optional(),
});

export const projectInsightSchema = z.object({
  lastIssueUpdateTime: z.string().optional(),
  totalIssueCount: z.number().optional(),
});

export const hierarchySchema = z.object({
  baseLevelId: z.number().optional(),
  levels: z.array(simplifiedHierarchyLevelSchema).optional(),
});

export const projectLandingPageInfoSchema = z.object({
  attributes: z.record(z.string()).optional(),
  boardId: z.number().optional(),
  boardName: z.string().optional(),
  projectKey: z.string().optional(),
  projectType: z.string().optional(),
  queueCategory: z.string().optional(),
  queueId: z.number().optional(),
  queueName: z.string().optional(),
  simpleBoard: z.boolean().optional(),
  simplified: z.boolean().optional(),
  url: z.string().optional(),
});

export const projectPermissionsSchema = z.object({
  canEdit: z.boolean().optional(),
});

export const projectCategorySchema = z.object({
  description: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  self: z.string().optional(),
});

export const styleSchema = z.union([z.literal('classic'), z.literal('next-gen')]);

export const projectAndIssueTypePairSchema = z.object({
  issueTypeId: z.string(),
  projectId: z.string(),
});

export const projectAvatarsSchema = z.object({
  custom: z.array(avatarSchema).optional(),
  system: z.array(avatarSchema).optional(),
});

export const projectDataPolicySchema = z.object({
  anyContentBlocked: z.boolean().optional(),
});

export const projectEmailAddressSchema = z.object({
  emailAddress: z.string().optional(),
  emailAddressStatus: z.array(z.string()).optional(),
});

export const stateSchema = z.union([z.literal('ENABLED'), z.literal('DISABLED'), z.literal('COMING_SOON')]);

export const projectFeatureStateSchema = z.object({
  state: z.union([z.literal('ENABLED'), z.literal('DISABLED'), z.literal('COMING_SOON')]).optional(),
});

export const projectIdSchema = z
  .object({
    id: z.string(),
  })
  .nullable();

export const projectIdentifiersSchema = z.object({
  id: z.number(),
  key: z.string(),
  self: z.string(),
});

export const projectIdsSchema = z.object({
  projectIds: z.array(z.string()),
});

export const projectIssueCreateMetadataSchema = z.object({
  avatarUrls: avatarUrlsBeanSchema.optional(),
  expand: z.string().optional(),
  id: z.string().optional(),
  issuetypes: z.array(issueTypeIssueCreateMetadataSchema).optional(),
  key: z.string().optional(),
  name: z.string().optional(),
  self: z.string().optional(),
});

export const projectIssueSecurityLevelsSchema = z.object({
  levels: z.array(securityLevelSchema),
});

export const projectIssueTypesHierarchyLevelSchema = z.object({
  entityId: z.string().optional(),
  issueTypes: z.array(issueTypeInfoSchema).optional(),
  level: z.number().optional(),
  name: z.string().optional(),
});

export const projectIssueTypeMappingSchema = z.object({
  issueTypeId: z.string(),
  projectId: z.string(),
});

export const projectIssueTypeMappingsSchema = z.object({
  mappings: z.array(projectIssueTypeMappingSchema),
});

export const projectIssueTypesSchema = z.object({
  issueTypes: z.array(z.string().nullable()).optional().nullable(),
  project: projectIdSchema.optional(),
});

export const projectRoleActorsUpdateBeanSchema = z.object({
  categorisedActors: z.record(z.array(z.string())).optional(),
  id: z.number().optional(),
});

export const projectRoleGroupSchema = z.object({
  displayName: z.string().optional(),
  groupId: z.string().optional(),
  name: z.string().optional(),
});

export const projectRoleUserSchema = z.object({
  accountId: z.string().optional(),
});

export const projectWithDataPolicySchema = z.object({
  dataPolicy: projectDataPolicySchema.optional(),
  id: z.number().optional(),
});

export const propertyKeySchema = z.object({
  key: z.string().optional(),
  self: z.string().optional(),
});

export const propertyKeysSchema = z.object({
  keys: z.array(propertyKeySchema).optional(),
});

export const statusMappingSchema = z.object({
  issueTypeId: z.string(),
  newStatusId: z.string(),
  statusId: z.string(),
});

export const publishedWorkflowIdSchema = z.object({
  entityId: z.string().optional(),
  name: z.string(),
});

export const remoteObjectSchema = z.object({
  icon: iconSchema.optional(),
  status: statusSchema.optional(),
  summary: z.string().optional(),
  title: z.string(),
  url: z.string(),
});

export const remoteIssueLinkIdentifiesSchema = z.object({
  id: z.number().optional(),
  self: z.string().optional(),
});

export const remoteIssueLinkRequestSchema = z.object({
  application: applicationSchema.optional(),
  globalId: z.string().optional(),
  object: remoteObjectSchema,
  relationship: z.string().optional(),
});

export const simpleErrorCollectionSchema = z.object({
  errorMessages: z.array(z.string()).optional(),
  errors: z.record(z.string()).optional(),
  httpStatusCode: z.number().optional(),
});

export const reorderIssuePrioritiesSchema = z.object({
  after: z.string().optional(),
  ids: z.array(z.string()),
  position: z.string().optional(),
});

export const reorderIssueResolutionsRequestSchema = z.object({
  after: z.string().optional(),
  ids: z.array(z.string()),
  position: z.string().optional(),
});

export const requiredMappingByIssueTypeSchema = z.object({
  issueTypeId: z.string().optional(),
  statusIds: z.array(z.string()).optional(),
});

export const requiredMappingByWorkflowsSchema = z.object({
  sourceWorkflowId: z.string().optional(),
  statusIds: z.array(z.string()).optional(),
  targetWorkflowId: z.string().optional(),
});

export const resolutionSchema = z.object({
  description: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  self: z.string().optional(),
});

export const resolutionIdSchema = z.object({
  id: z.string(),
});

export const richTextSchema = z.object({
  empty: z.boolean().optional(),
  emptyAdf: z.boolean().optional(),
  finalised: z.boolean().optional(),
  valueSet: z.boolean().optional(),
});

export const roleActorSchema = z.object({
  actorGroup: projectRoleGroupSchema.optional(),
  actorUser: projectRoleUserSchema.optional(),
  avatarUrl: z.string().optional(),
  displayName: z.string().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  type: z.union([z.literal('atlassian-group-role-actor'), z.literal('atlassian-user-role-actor')]).optional(),
});

export const type8Schema = z.union([z.literal('atlassian-group-role-actor'), z.literal('atlassian-user-role-actor')]);

export const sanitizedJqlQuerySchema = z.object({
  accountId: z.string().optional().nullable(),
  errors: errorCollectionSchema.optional(),
  initialQuery: z.string().optional(),
  sanitizedQuery: z.string().optional().nullable(),
});

export const type9Schema = z.union([z.literal('PROJECT'), z.literal('TEMPLATE')]);

export const screenDetailsSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
});

export const screenTypesSchema = z.object({
  create: z.number().optional(),
  default: z.number(),
  edit: z.number().optional(),
  view: z.number().optional(),
});

export const screenSchemeDetailsSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
  screens: screenTypesSchema,
});

export const screenSchemeIdSchema = z.object({
  id: z.number(),
});

export const screenableTabSchema = z.object({
  id: z.number().optional(),
  name: z.string(),
});

export const screenableFieldSchema = z.object({
  id: z.string().optional(),
  name: z.string().optional(),
});

export const searchAndReconcileRequestBeanSchema = z.object({
  expand: z.string().optional(),
  fields: z.array(z.string()).optional(),
  fieldsByKeys: z.boolean().optional(),
  jql: z.string().optional(),
  maxResults: z.number().optional(),
  nextPageToken: z.string().optional(),
  properties: z.array(z.string()).optional(),
  reconcileIssues: z.array(z.number()).optional(),
});

export const searchAutoCompleteFilterSchema = z.object({
  includeCollapsedFields: z.boolean().optional(),
  projectIds: z.array(z.number()).optional(),
});

export const searchRequestBeanSchema = z.object({
  expand: z.array(z.string()).optional(),
  fields: z.array(z.string()).optional(),
  fieldsByKeys: z.boolean().optional(),
  jql: z.string().optional(),
  maxResults: z.number().optional(),
  properties: z.array(z.string()).optional(),
  startAt: z.number().optional(),
  validateQuery: z
    .union([z.literal('strict'), z.literal('warn'), z.literal('none'), z.literal('true'), z.literal('false')])
    .optional(),
});

export const validateQuerySchema = z.union([
  z.literal('strict'),
  z.literal('warn'),
  z.literal('none'),
  z.literal('true'),
  z.literal('false'),
]);

export const securitySchemeSchema = z.object({
  defaultSecurityLevelId: z.number().optional(),
  description: z.string().optional(),
  id: z.number().optional(),
  levels: z.array(securityLevelSchema).optional(),
  name: z.string().optional(),
  self: z.string().optional(),
});

export const securitySchemeIdSchema = z.object({
  id: z.string(),
});

export const securitySchemeLevelMemberBeanSchema = z.object({
  parameter: z.string().optional(),
  type: z.string(),
});

export const securitySchemeMembersRequestSchema = z.object({
  members: z.array(securitySchemeLevelMemberBeanSchema).optional(),
});

export const securitySchemesSchema = z.object({
  issueSecuritySchemes: z.array(securitySchemeSchema).optional(),
});

export const serverInformationSchema = z.object({
  baseUrl: z.string().optional(),
  buildDate: z.string().optional(),
  buildNumber: z.number().optional(),
  deploymentType: z.string().optional(),
  displayUrl: z.string().optional(),
  displayUrlConfluence: z.string().optional(),
  displayUrlServicedeskHelpCenter: z.string().optional(),
  healthChecks: z.array(healthCheckResultSchema).optional(),
  scmInfo: z.string().optional(),
  serverTime: z.string().optional(),
  serverTimeZone: z
    .object({
      displayName: z.string().optional(),
      dstsavings: z.number().optional(),
      id: z.string().optional(),
      rawOffset: z.number().optional(),
    })
    .optional(),
  serverTitle: z.string().optional(),
  version: z.string().optional(),
  versionNumbers: z.array(z.number()).optional(),
});

export const serviceManagementNavigationInfoSchema = z.object({
  queueCategory: z.string().optional(),
  queueId: z.number().optional(),
  queueName: z.string().optional(),
});

export const serviceRegistryTierSchema = z.object({
  description: z.string().optional().nullable(),
  id: z.string().optional(),
  level: z.number().optional(),
  name: z.string().optional().nullable(),
  nameKey: z.string().optional(),
});

export const setDefaultLevelsRequestSchema = z.object({
  defaultValues: z.array(defaultLevelValueSchema),
});

export const setDefaultPriorityRequestSchema = z.object({
  id: z.string(),
});

export const setDefaultResolutionRequestSchema = z.object({
  id: z.string(),
});

export const projectRoleSchema = z.object({
  actors: z.array(roleActorSchema).optional(),
  admin: z.boolean().optional(),
  currentUserRole: z.boolean().optional(),
  default: z.boolean().optional(),
  description: z.string().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  roleConfigurable: z.boolean().optional(),
  scope: scopeSchema.optional(),
  self: z.string().optional(),
  translatedName: z.string().optional(),
});

export const type10Schema = z.union([
  z.literal('user'),
  z.literal('group'),
  z.literal('project'),
  z.literal('projectRole'),
  z.literal('global'),
  z.literal('loggedin'),
  z.literal('authenticated'),
  z.literal('project-unknown'),
]);

export const sharePermissionInputBeanSchema = z.object({
  accountId: z.string().optional(),
  groupId: z.string().optional(),
  groupname: z.string().optional(),
  projectId: z.string().optional(),
  projectRoleId: z.string().optional(),
  rights: z.number().optional(),
  type: z.union([
    z.literal('user'),
    z.literal('project'),
    z.literal('group'),
    z.literal('projectRole'),
    z.literal('global'),
    z.literal('authenticated'),
  ]),
});

export const type11Schema = z.union([
  z.literal('user'),
  z.literal('project'),
  z.literal('group'),
  z.literal('projectRole'),
  z.literal('global'),
  z.literal('authenticated'),
]);

export const simpleApplicationPropertyBeanSchema = z.object({
  id: z.string().optional(),
  value: z.string().optional(),
});

export const applicationRoleSchema = z.object({
  defaultGroups: z.array(z.string()).optional(),
  defaultGroupsDetails: z.array(groupNameSchema).optional(),
  defined: z.boolean().optional(),
  groupDetails: z.array(groupNameSchema).optional(),
  groups: z.array(z.string()).optional(),
  hasUnlimitedSeats: z.boolean().optional(),
  key: z.string().optional(),
  name: z.string().optional(),
  numberOfSeats: z.number().optional(),
  platform: z.boolean().optional(),
  remainingSeats: z.number().optional(),
  selectedByDefault: z.boolean().optional(),
  userCount: z.number().optional(),
  userCountDescription: z.string().optional(),
});

export const simpleListWrapperGroupNameSchema = z.object({
  callback: listWrapperCallbackGroupNameSchema.optional(),
  items: z.array(groupNameSchema).optional(),
  'max-results': z.number().optional(),
  pagingCallback: listWrapperCallbackGroupNameSchema.optional(),
  size: z.number().optional(),
});

export const simpleUsageSchema = z.object({
  issueTypeIds: z.array(z.string()),
  projectId: z.string(),
});

export const softwareNavigationInfoSchema = z.object({
  boardId: z.number().optional(),
  boardName: z.string().optional(),
  simpleBoard: z.boolean().optional(),
  totalBoardsInProject: z.number().optional(),
});

export const statusCreateSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
  statusCategory: z.union([z.literal('TODO'), z.literal('IN_PROGRESS'), z.literal('DONE')]),
});

export const statusScopeSchema = z.object({
  project: projectIdSchema.optional(),
  type: z.union([z.literal('PROJECT'), z.literal('GLOBAL')]),
});

export const statusDetailsSchema = z.object({
  description: z.string().optional(),
  iconUrl: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  scope: scopeSchema.optional(),
  self: z.string().optional(),
  statusCategory: statusCategorySchema.optional(),
});

export const statusLayoutUpdateSchema = z.object({
  approvalConfiguration: approvalConfigurationSchema.optional(),
  layout: workflowLayoutSchema.optional(),
  properties: z.record(z.string()),
  statusReference: z.string(),
});

export const statusMigrationSchema = z.object({
  newStatusReference: z.string(),
  oldStatusReference: z.string(),
});

export const statusMetadataSchema = z.object({
  category: z.union([z.literal('TODO'), z.literal('IN_PROGRESS'), z.literal('DONE')]).optional(),
  id: z.string().optional(),
  name: z.string().optional(),
});

export const categorySchema = z.union([z.literal('TODO'), z.literal('IN_PROGRESS'), z.literal('DONE')]);

export const statusReferenceAndPortSchema = z
  .object({
    port: z.number().optional(),
    statusReference: z.string(),
  })
  .nullable();

export const type12Schema = z.union([z.literal('PROJECT'), z.literal('GLOBAL')]);

export const statusUpdateSchema = z.object({
  description: z.string().optional(),
  id: z.string(),
  name: z.string(),
  statusCategory: z.union([z.literal('TODO'), z.literal('IN_PROGRESS'), z.literal('DONE')]),
});

export const statusUpdateRequestSchema = z.object({
  statuses: z.array(statusUpdateSchema),
});

export const statusesPerWorkflowSchema = z.object({
  initialStatusId: z.string().optional(),
  statuses: z.array(z.string()).optional(),
  workflowId: z.string().optional(),
});

export const streamingResponseBodySchema = z.record(z.string());

export const stringListSchema = z.record(z.string());

export const submittedBulkOperationSchema = z.object({
  taskId: z.string().optional(),
});

export const suggestedMappingsForPrioritiesRequestBeanSchema = z.object({
  add: z.array(z.number()).optional(),
  remove: z.array(z.number()).optional(),
});

export const suggestedMappingsForProjectsRequestBeanSchema = z.object({
  add: z.array(z.number()).optional(),
});

export const suggestedMappingsRequestBeanSchema = z.object({
  maxResults: z.number().optional(),
  priorities: suggestedMappingsForPrioritiesRequestBeanSchema.optional(),
  projects: suggestedMappingsForProjectsRequestBeanSchema.optional(),
  schemeId: z.number().optional(),
  startAt: z.number().optional(),
});

export const systemAvatarsSchema = z.object({
  system: z.array(avatarSchema).optional(),
});

export const taskProgressBeanObjectSchema = z.object({
  description: z.string().optional(),
  elapsedRuntime: z.number(),
  finished: z.number().optional(),
  id: z.string(),
  lastUpdate: z.number(),
  message: z.string().optional(),
  progress: z.number(),
  result: z.string().optional(),
  self: z.string(),
  started: z.number().optional(),
  status: z.union([
    z.literal('ENQUEUED'),
    z.literal('RUNNING'),
    z.literal('COMPLETE'),
    z.literal('FAILED'),
    z.literal('CANCEL_REQUESTED'),
    z.literal('CANCELLED'),
    z.literal('DEAD'),
  ]),
  submitted: z.number(),
  submittedBy: z.number(),
});

export const removeOptionFromIssuesResultSchema = z.object({
  errors: simpleErrorCollectionSchema.optional(),
  modifiedIssues: z.array(z.number()).optional(),
  unmodifiedIssues: z.array(z.number()).optional(),
});

export const defaultUnitSchema = z.union([z.literal('minute'), z.literal('hour'), z.literal('day'), z.literal('week')]);

export const timeFormatSchema = z.union([z.literal('pretty'), z.literal('days'), z.literal('hours')]);

export const timeTrackingProviderSchema = z.object({
  key: z.string(),
  name: z.string().optional(),
  url: z.string().optional(),
});

export const transitionScreenDetailsSchema = z.object({
  id: z.string(),
  name: z.string().optional(),
});

export const workflowTransitionLinksSchema = z
  .object({
    fromPort: z.number().optional().nullable(),
    fromStatusReference: z.string().optional().nullable(),
    toPort: z.number().optional().nullable(),
  })
  .nullable();

export const workflowTriggerSchema = z.object({
  id: z.string().optional(),
  parameters: z.record(z.string()),
  ruleKey: z.string(),
});

export const type13Schema = z.union([z.literal('INITIAL'), z.literal('GLOBAL'), z.literal('DIRECTED')]);

export const issueTransitionSchema = z.object({
  expand: z.string().optional(),
  fields: z.record(fieldMetadataSchema).optional(),
  hasScreen: z.boolean().optional(),
  id: z.string().optional(),
  isAvailable: z.boolean().optional(),
  isConditional: z.boolean().optional(),
  isGlobal: z.boolean().optional(),
  isInitial: z.boolean().optional(),
  looped: z.boolean().optional(),
  name: z.string().optional(),
  to: statusDetailsSchema.optional(),
});

export const viewTypeSchema = z.union([z.literal('GIC'), z.literal('IssueView'), z.literal('IssueTransition')]);

export const uiModificationIdentifiersSchema = z.object({
  id: z.string(),
  self: z.string(),
});

export const unrestrictedUserEmailSchema = z.object({
  accountId: z.string().optional(),
  email: z.string().optional(),
});

export const updateCustomFieldDetailsSchema = z.object({
  description: z.string().optional(),
  name: z.string().optional(),
  searcherKey: z
    .union([
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:cascadingselectsearcher'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:daterange'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:datetimerange'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:exactnumber'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:exacttextsearcher'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:grouppickersearcher'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:labelsearcher'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:multiselectsearcher'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:numberrange'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:projectsearcher'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:textsearcher'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:userpickergroupsearcher'),
      z.literal('com.atlassian.jira.plugin.system.customfieldtypes:versionsearcher'),
    ])
    .optional(),
});

export const updateDefaultProjectClassificationBeanSchema = z.object({
  id: z.string(),
});

export const updateDefaultScreenSchemeSchema = z.object({
  screenSchemeId: z.string(),
});

export const updateFieldConfigurationSchemeDetailsSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
});

export const updateIssueSecurityLevelDetailsSchema = z.object({
  description: z.string().optional(),
  name: z.string().optional(),
});

export const updateIssueSecuritySchemeRequestBeanSchema = z.object({
  description: z.string().optional(),
  name: z.string().optional(),
});

export const updateNotificationSchemeDetailsSchema = z.object({
  description: z.string().optional(),
  name: z.string().optional(),
});

export const updatePrioritiesInSchemeRequestBeanSchema = z.object({
  add: prioritySchemeChangesWithoutMappingsSchema.optional(),
  remove: prioritySchemeChangesWithMappingsSchema.optional(),
});

export const updatePriorityDetailsSchema = z.object({
  avatarId: z.number().optional(),
  description: z.string().optional().nullable(),
  iconUrl: z
    .union([
      z.literal('/images/icons/priorities/blocker.png'),
      z.literal('/images/icons/priorities/critical.png'),
      z.literal('/images/icons/priorities/high.png'),
      z.literal('/images/icons/priorities/highest.png'),
      z.literal('/images/icons/priorities/low.png'),
      z.literal('/images/icons/priorities/lowest.png'),
      z.literal('/images/icons/priorities/major.png'),
      z.literal('/images/icons/priorities/medium.png'),
      z.literal('/images/icons/priorities/minor.png'),
      z.literal('/images/icons/priorities/trivial.png'),
      z.literal('/images/icons/priorities/blocker_new.png'),
      z.literal('/images/icons/priorities/critical_new.png'),
      z.literal('/images/icons/priorities/high_new.png'),
      z.literal('/images/icons/priorities/highest_new.png'),
      z.literal('/images/icons/priorities/low_new.png'),
      z.literal('/images/icons/priorities/lowest_new.png'),
      z.literal('/images/icons/priorities/major_new.png'),
      z.literal('/images/icons/priorities/medium_new.png'),
      z.literal('/images/icons/priorities/minor_new.png'),
      z.literal('/images/icons/priorities/trivial_new.png'),
    ])
    .optional()
    .nullable(),
  name: z.string().optional().nullable(),
  statusColor: z.string().optional().nullable(),
});

export const updateProjectsInSchemeRequestBeanSchema = z.object({
  add: prioritySchemeChangesWithoutMappingsSchema.optional(),
  remove: prioritySchemeChangesWithoutMappingsSchema.optional(),
});

export const updateProjectDetailsSchema = z.object({
  assigneeType: z.union([z.literal('PROJECT_LEAD'), z.literal('UNASSIGNED')]).optional(),
  avatarId: z.number().optional(),
  categoryId: z.number().optional(),
  description: z.string().optional(),
  issueSecurityScheme: z.number().optional(),
  key: z.string().optional(),
  lead: z.string().optional(),
  leadAccountId: z.string().optional(),
  name: z.string().optional(),
  notificationScheme: z.number().optional(),
  permissionScheme: z.number().optional(),
  url: z.string().optional(),
});

export const updateResolutionDetailsSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
});

export const updateScreenDetailsSchema = z.object({
  description: z.string().optional(),
  name: z.string().optional(),
});

export const updateScreenTypesSchema = z.object({
  create: z.string().optional(),
  default: z.string().optional(),
  edit: z.string().optional(),
  view: z.string().optional(),
});

export const updateUiModificationDetailsSchema = z.object({
  contexts: z.array(uiModificationContextDetailsSchema).optional(),
  data: z.string().optional(),
  description: z.string().optional(),
  name: z.string().optional(),
});

export const updateUserToGroupBeanSchema = z.object({
  accountId: z.string().optional(),
  name: z.string().optional(),
});

export const simpleListWrapperApplicationRoleSchema = z.object({
  callback: listWrapperCallbackApplicationRoleSchema.optional(),
  items: z.array(applicationRoleSchema).optional(),
  'max-results': z.number().optional(),
  pagingCallback: listWrapperCallbackApplicationRoleSchema.optional(),
  size: z.number().optional(),
});

export const accountTypeSchema = z.union([
  z.literal('atlassian'),
  z.literal('app'),
  z.literal('customer'),
  z.literal('unknown'),
]);

export const userBeanAvatarUrlsSchema = z.object({
  '16x16': z.string().optional(),
  '24x24': z.string().optional(),
  '32x32': z.string().optional(),
  '48x48': z.string().optional(),
});

export const userColumnRequestBodySchema = z.object({
  columns: z.array(z.string()).optional(),
});

export const userSchema = z.object({
  accountId: z.string().optional(),
  accountType: z
    .union([z.literal('atlassian'), z.literal('app'), z.literal('customer'), z.literal('unknown')])
    .optional(),
  active: z.boolean().optional(),
  applicationRoles: simpleListWrapperApplicationRoleSchema.optional(),
  avatarUrls: avatarUrlsBeanSchema.optional(),
  displayName: z.string().optional(),
  emailAddress: z.string().optional(),
  expand: z.string().optional(),
  groups: simpleListWrapperGroupNameSchema.optional(),
  key: z.string().optional(),
  locale: z.string().optional(),
  name: z.string().optional(),
  self: z.string().optional(),
  timeZone: z.string().optional(),
});

export const userPermissionSchema = z.object({
  deprecatedKey: z.boolean().optional(),
  description: z.string().optional(),
  havePermission: z.boolean().optional(),
  id: z.string().optional(),
  key: z.string().optional(),
  name: z.string().optional(),
  type: z.union([z.literal('GLOBAL'), z.literal('PROJECT')]).optional(),
});

export const validationOptionsForCreateSchema = z.object({
  levels: z.array(z.union([z.literal('WARNING'), z.literal('ERROR')])).optional(),
});

export const validationOptionsForUpdateSchema = z.object({
  levels: z.array(z.union([z.literal('WARNING'), z.literal('ERROR')])).optional(),
});

export const versionApproverSchema = z.object({
  accountId: z.string().optional(),
  declineReason: z.string().optional(),
  description: z.string().optional(),
  status: z.string().optional(),
});

export const versionIssuesStatusSchema = z.object({
  done: z.number().optional(),
  inProgress: z.number().optional(),
  toDo: z.number().optional(),
  unmapped: z.number().optional(),
});

export const versionUsageInCustomFieldSchema = z.object({
  customFieldId: z.number().optional(),
  fieldName: z.string().optional(),
  issueCountWithVersionInCustomField: z.number().optional(),
});

export const versionMoveBeanSchema = z.object({
  after: z.string().optional(),
  position: z.union([z.literal('Earlier'), z.literal('Later'), z.literal('First'), z.literal('Last')]).optional(),
});

export const versionRelatedWorkSchema = z.object({
  category: z.string(),
  issueId: z.number().optional(),
  relatedWorkId: z.string().optional(),
  title: z.string().optional(),
  url: z.string().optional(),
});

export const versionUnresolvedIssuesCountSchema = z.object({
  issuesCount: z.number().optional(),
  issuesUnresolvedCount: z.number().optional(),
  self: z.string().optional(),
});

export const type14Schema = z.union([z.literal('group'), z.literal('role')]);

export const votesSchema = z.object({
  hasVoted: z.boolean().optional(),
  self: z.string().optional(),
  voters: z.array(userSchema).optional(),
  votes: z.number().optional(),
});

export const watchersSchema = z.object({
  isWatching: z.boolean().optional(),
  self: z.string().optional(),
  watchCount: z.number().optional(),
  watchers: z.array(userDetailsSchema).optional(),
});

export const webhookDetailsSchema = z.object({
  events: z.array(
    z.union([
      z.literal('jira:issue_created'),
      z.literal('jira:issue_updated'),
      z.literal('jira:issue_deleted'),
      z.literal('comment_created'),
      z.literal('comment_updated'),
      z.literal('comment_deleted'),
      z.literal('issue_property_set'),
      z.literal('issue_property_deleted'),
    ]),
  ),
  fieldIdsFilter: z.array(z.string()).optional(),
  issuePropertyKeysFilter: z.array(z.string()).optional(),
  jqlFilter: z.string(),
});

export const webhookRegistrationDetailsSchema = z.object({
  url: z.string(),
  webhooks: z.array(webhookDetailsSchema),
});

export const webhooksExpirationDateSchema = z.object({
  expirationDate: z.number(),
});

export const workManagementNavigationInfoSchema = z.object({
  boardName: z.string().optional(),
});

export const workflowOperationsSchema = z.object({
  canDelete: z.boolean(),
  canEdit: z.boolean(),
});

export const workflowSchemeIdNameSchema = z.object({
  id: z.string(),
  name: z.string(),
});

export const workflowStatusSchema = z.object({
  id: z.string(),
  name: z.string(),
  properties: z.record(z.string()).optional(),
});

export const workflowCapabilitiesSchema = z.object({
  connectRules: z.array(availableWorkflowConnectRuleSchema).optional(),
  editorScope: z.union([z.literal('PROJECT'), z.literal('GLOBAL')]).optional(),
  forgeRules: z.array(availableWorkflowForgeRuleSchema).optional(),
  projectTypes: z
    .array(
      z.union([
        z.literal('software'),
        z.literal('service_desk'),
        z.literal('product_discovery'),
        z.literal('business'),
        z.literal('unknown'),
      ]),
    )
    .optional(),
  systemRules: z.array(availableWorkflowSystemRuleSchema).optional(),
  triggerRules: z.array(availableWorkflowTriggersSchema).optional(),
});

export const editorScopeSchema = z.union([z.literal('PROJECT'), z.literal('GLOBAL')]);

export const workflowSimpleConditionSchema = z.object({
  configuration: z.record(z.string()).optional(),
  nodeType: z.literal('simple'),
  type: z.string(),
});

export const transitionUpdateDTOSchema = z.object({
  actions: z.array(workflowRuleConfigurationSchema).optional(),
  conditions: conditionGroupUpdateSchema.optional(),
  customIssueEventId: z.string().optional(),
  description: z.string().optional(),
  from: z.array(statusReferenceAndPortSchema).optional(),
  id: z.string(),
  links: z.array(workflowTransitionLinksSchema).optional(),
  name: z.string(),
  properties: z.record(z.string()).optional(),
  to: statusReferenceAndPortSchema.optional(),
  toStatusReference: z.string().optional(),
  transitionScreen: workflowRuleConfigurationSchema.optional(),
  triggers: z.array(workflowTriggerSchema).optional(),
  type: z.union([z.literal('INITIAL'), z.literal('GLOBAL'), z.literal('DIRECTED')]),
  validators: z.array(workflowRuleConfigurationSchema).optional(),
});

export const workflowScopeSchema = z.object({
  project: projectIdSchema.optional(),
  type: z.union([z.literal('PROJECT'), z.literal('GLOBAL')]),
});

export const workflowStatusUpdateSchema = z.object({
  description: z.string().optional(),
  id: z.string().optional(),
  name: z.string(),
  statusCategory: z.union([z.literal('TODO'), z.literal('IN_PROGRESS'), z.literal('DONE')]),
  statusReference: z.string(),
});

export const workflowCreateSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
  startPointLayout: workflowLayoutSchema.optional(),
  statuses: z.array(statusLayoutUpdateSchema),
  transitions: z.array(transitionUpdateDTOSchema),
});

export const jiraWorkflowStatusSchema = z.object({
  description: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  scope: workflowScopeSchema.optional(),
  statusCategory: z.union([z.literal('TODO'), z.literal('IN_PROGRESS'), z.literal('DONE')]).optional(),
  statusReference: z.string().optional(),
  usages: z.array(projectIssueTypesSchema).optional(),
});

export const workflowCreateRequestSchema = z.object({
  scope: workflowScopeSchema,
  statuses: z.array(workflowStatusUpdateSchema),
  workflows: z.array(workflowCreateSchema),
});

export const workflowElementReferenceSchema = z.object({
  propertyKey: z.string().optional(),
  ruleId: z.string().optional(),
  statusMappingReference: projectAndIssueTypePairSchema.optional(),
  statusReference: z.string().optional(),
  transitionId: z.string().optional(),
});

export const workflowIDsSchema = z.object({
  entityId: z.string().optional(),
  name: z.string(),
});

export const workflowIdSchema = z.object({
  draft: z.boolean(),
  name: z.string(),
});

export const workflowMetadataRestModelSchema = z.object({
  description: z.string(),
  id: z.string(),
  name: z.string(),
  usage: z.array(simpleUsageSchema),
  version: documentVersionSchema,
});

export const workflowReadRequestSchema = z.object({
  projectAndIssueTypes: z.array(projectAndIssueTypePairSchema).optional(),
  workflowIds: z.array(z.string()).optional(),
  workflowNames: z.array(z.string()).optional(),
});

export const workflowStatusLayoutSchema = z
  .object({
    x: z.number().optional().nullable(),
    y: z.number().optional().nullable(),
  })
  .nullable();

export const workflowTransitionRuleSchema = z.object({
  configuration: z.string().optional(),
  type: z.string(),
});

export const workflowRulesSearchSchema = z.object({
  expand: z.string().optional(),
  ruleIds: z.array(z.string()),
  workflowEntityId: z.string(),
});

export const workflowSchemeSchema = z.object({
  defaultWorkflow: z.string().optional(),
  description: z.string().optional(),
  draft: z.boolean().optional(),
  id: z.number().optional(),
  issueTypeMappings: z.record(z.string()).optional(),
  issueTypes: z.record(issueTypeDetailsSchema).optional(),
  lastModified: z.string().optional(),
  lastModifiedUser: userSchema.optional(),
  name: z.string().optional(),
  originalDefaultWorkflow: z.string().optional(),
  originalIssueTypeMappings: z.record(z.string()).optional(),
  self: z.string().optional(),
  updateDraftIfNeeded: z.boolean().optional(),
});

export const workflowSchemeAssociationSchema = z.object({
  issueTypeIds: z.array(z.string()),
  workflowId: z.string(),
});

export const workflowSchemeAssociationsSchema = z.object({
  projectIds: z.array(z.string()),
  workflowScheme: workflowSchemeSchema,
});

export const workflowSchemeProjectAssociationSchema = z.object({
  projectId: z.string(),
  workflowSchemeId: z.string().optional(),
});

export const workflowSchemeReadRequestSchema = z.object({
  projectIds: z.array(z.string().nullable()).optional().nullable(),
  workflowSchemeIds: z.array(z.string().nullable()).optional().nullable(),
});

export const workflowMetadataAndIssueTypeRestModelSchema = z.object({
  issueTypeIds: z.array(z.string()),
  workflow: workflowMetadataRestModelSchema,
});

export const mappingsByIssueTypeOverrideSchema = z.object({
  issueTypeId: z.string(),
  statusMappings: z.array(workflowAssociationStatusMappingSchema),
});

export const workflowSchemeUpdateRequiredMappingsRequestSchema = z.object({
  defaultWorkflowId: z.string().optional().nullable(),
  id: z.string(),
  workflowsForIssueTypes: z.array(workflowSchemeAssociationSchema),
});

export const workflowSchemeUpdateRequiredMappingsResponseSchema = z.object({
  statusMappingsByIssueTypes: z.array(requiredMappingByIssueTypeSchema).optional(),
  statusMappingsByWorkflows: z.array(requiredMappingByWorkflowsSchema).optional(),
  statuses: z.array(statusMetadataSchema).optional(),
  statusesPerWorkflow: z.array(statusesPerWorkflowSchema).optional(),
});

export const workflowStatusAndPortSchema = z
  .object({
    port: z.number().optional().nullable(),
    statusReference: z.string().optional(),
  })
  .nullable();

export const workflowTransitionPropertySchema = z.object({
  id: z.string().optional(),
  key: z.string().optional(),
  value: z.string(),
});

export const appWorkflowTransitionRuleSchema = z.object({
  configuration: ruleConfigurationSchema,
  id: z.string(),
  key: z.string(),
  transition: workflowTransitionSchema.optional(),
});

export const workflowTransitionRulesDetailsSchema = z.object({
  workflowId: workflowIdSchema,
  workflowRuleIds: z.array(z.string()),
});

export const workflowTransitionRulesSchema = z.object({
  conditions: z.array(appWorkflowTransitionRuleSchema).optional(),
  postFunctions: z.array(appWorkflowTransitionRuleSchema).optional(),
  validators: z.array(appWorkflowTransitionRuleSchema).optional(),
  workflowId: workflowIdSchema,
});

export const workflowTransitionRulesUpdateErrorDetailsSchema = z.object({
  ruleUpdateErrors: z.record(z.array(z.string())),
  updateErrors: z.array(z.string()),
  workflowId: workflowIdSchema,
});

export const workflowTransitionRulesUpdateErrorsSchema = z.object({
  updateResults: z.array(workflowTransitionRulesUpdateErrorDetailsSchema),
});

export const conditionGroupConfigurationSchema: z.ZodSchema<ConditionGroupConfiguration> = z.lazy(() =>
  z
    .object({
      conditionGroups: z.array(conditionGroupConfigurationSchema).optional(),
      conditions: z.array(workflowRuleConfigurationSchema).optional(),
      operation: z.union([z.literal('ANY'), z.literal('ALL')]).optional(),
    })
    .nullable(),
);

export const statusMappingDTOSchema = z.object({
  issueTypeId: z.string(),
  projectId: z.string(),
  statusMigrations: z.array(statusMigrationSchema),
});

export const workflowUpdateSchema = z.object({
  defaultStatusMappings: z.array(statusMigrationSchema).optional(),
  description: z.string().optional(),
  id: z.string(),
  startPointLayout: workflowLayoutSchema.optional(),
  statusMappings: z.array(statusMappingDTOSchema).optional(),
  statuses: z.array(statusLayoutUpdateSchema),
  transitions: z.array(transitionUpdateDTOSchema),
  version: documentVersionSchema,
});

export const workflowUpdateRequestSchema = z.object({
  statuses: z.array(workflowStatusUpdateSchema),
  workflows: z.array(workflowUpdateSchema),
});

export const workflowValidationErrorSchema = z.object({
  code: z.string().optional(),
  elementReference: workflowElementReferenceSchema.optional(),
  level: z.union([z.literal('WARNING'), z.literal('ERROR')]).optional(),
  message: z.string().optional(),
  type: z
    .union([
      z.literal('RULE'),
      z.literal('STATUS'),
      z.literal('STATUS_LAYOUT'),
      z.literal('STATUS_PROPERTY'),
      z.literal('WORKFLOW'),
      z.literal('TRANSITION'),
      z.literal('TRANSITION_PROPERTY'),
      z.literal('SCOPE'),
      z.literal('STATUS_MAPPING'),
      z.literal('TRIGGER'),
    ])
    .optional(),
});

export const levelSchema = z.union([z.literal('WARNING'), z.literal('ERROR')]);

export const type15Schema = z.union([
  z.literal('RULE'),
  z.literal('STATUS'),
  z.literal('STATUS_LAYOUT'),
  z.literal('STATUS_PROPERTY'),
  z.literal('WORKFLOW'),
  z.literal('TRANSITION'),
  z.literal('TRANSITION_PROPERTY'),
  z.literal('SCOPE'),
  z.literal('STATUS_MAPPING'),
  z.literal('TRIGGER'),
]);

export const workflowValidationErrorListSchema = z.object({
  errors: z.array(workflowValidationErrorSchema).optional(),
});

export const workflowsWithTransitionRulesDetailsSchema = z.object({
  workflows: z.array(workflowTransitionRulesDetailsSchema),
});

export const worklogIdsRequestBeanSchema = z.object({
  ids: z.array(z.number()),
});

export const worklogsMoveRequestBeanSchema = z.object({
  ids: z.array(z.number()).optional(),
  issueIdOrKey: z.string().optional(),
});

export const workspaceDataPolicySchema = z.object({
  anyContentBlocked: z.boolean().optional(),
});

export const fieldsSchema = z.union([
  mandatoryFieldValueSchema,
  mandatoryFieldValueForADFSchema,
  z.object({
    retain: z.boolean().optional().nullable(),
    type: z.union([z.literal('adf'), z.literal('raw')]),
    value: z.record(z.string()).optional(),
  }),
]);

export const targetClassificationSchema = z
  .object({
    classifications: z.record(z.array(z.string())),
    issueType: z.string().optional(),
    projectKeyOrId: z.string().optional(),
  })
  .nullable();

export const targetMandatoryFieldsSchema = z
  .object({
    fields: z.record(fieldsSchema),
  })
  .nullable();

export const targetStatusSchema = z
  .object({
    statuses: z.record(z.array(z.string())),
  })
  .nullable();

export const targetToSourcesMappingSchema = z.object({
  inferClassificationDefaults: z.boolean(),
  inferFieldDefaults: z.boolean(),
  inferStatusDefaults: z.boolean(),
  inferSubtaskTypeDefault: z.boolean(),
  issueIdsOrKeys: z.array(z.string()).optional(),
  targetClassification: z.array(targetClassificationSchema).optional().nullable(),
  targetMandatoryFields: z.array(targetMandatoryFieldsSchema).optional().nullable(),
  targetStatus: z.array(targetStatusSchema).optional().nullable(),
});

export const getBannerResponseSchema = announcementBannerConfigurationSchema;

export const getBannerErrorSchema = errorCollectionSchema;

export const setBannerDataSchema = z.object({
  body: announcementBannerConfigurationUpdateSchema,
});

export const setBannerResponseSchema = z.unknown();

export const setBannerErrorSchema = errorCollectionSchema;

export const getCustomFieldsConfigurationsDataSchema = z.object({
  body: configurationsListParametersSchema,
  query: z
    .object({
      fieldContextId: z.array(z.number()).optional(),
      id: z.array(z.number()).optional(),
      issueId: z.number().optional(),
      issueTypeId: z.string().optional(),
      maxResults: z.number().optional(),
      projectKeyOrId: z.string().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getCustomFieldsConfigurationsResponseSchema = pageBeanBulkContextualConfigurationSchema;

export const getCustomFieldsConfigurationsErrorSchema = z.unknown();

export const updateMultipleCustomFieldValuesDataSchema = z.object({
  body: multipleCustomFieldValuesUpdateDetailsSchema,
  query: z
    .object({
      generateChangelog: z.boolean().optional(),
    })
    .optional(),
});

export const updateMultipleCustomFieldValuesResponseSchema = z.unknown();

export const updateMultipleCustomFieldValuesErrorSchema = z.unknown();

export const getCustomFieldConfigurationDataSchema = z.object({
  path: z.object({
    fieldIdOrKey: z.string(),
  }),
  query: z
    .object({
      fieldContextId: z.array(z.number()).optional(),
      id: z.array(z.number()).optional(),
      issueId: z.number().optional(),
      issueTypeId: z.string().optional(),
      maxResults: z.number().optional(),
      projectKeyOrId: z.string().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getCustomFieldConfigurationResponseSchema = pageBeanContextualConfigurationSchema;

export const getCustomFieldConfigurationErrorSchema = z.unknown();

export const updateCustomFieldConfigurationDataSchema = z.object({
  body: customFieldConfigurationsSchema,
  path: z.object({
    fieldIdOrKey: z.string(),
  }),
});

export const updateCustomFieldConfigurationResponseSchema = z.unknown();

export const updateCustomFieldConfigurationErrorSchema = z.unknown();

export const updateCustomFieldValueDataSchema = z.object({
  body: customFieldValueUpdateDetailsSchema,
  path: z.object({
    fieldIdOrKey: z.string(),
  }),
  query: z
    .object({
      generateChangelog: z.boolean().optional(),
    })
    .optional(),
});

export const updateCustomFieldValueResponseSchema = z.unknown();

export const updateCustomFieldValueErrorSchema = z.unknown();

export const getApplicationPropertyDataSchema = z.object({
  query: z
    .object({
      key: z.string().optional(),
      keyFilter: z.string().optional(),
      permissionLevel: z.string().optional(),
    })
    .optional(),
});

export const getApplicationPropertyResponseSchema = z.array(applicationPropertySchema);

export const getApplicationPropertyErrorSchema = errorCollectionSchema;

export const getAdvancedSettingsResponseSchema = z.array(applicationPropertySchema);

export const getAdvancedSettingsErrorSchema = z.unknown();

export const setApplicationPropertyDataSchema = z.object({
  body: simpleApplicationPropertyBeanSchema,
  path: z.object({
    id: z.string(),
  }),
});

export const setApplicationPropertyResponseSchema = applicationPropertySchema;

export const setApplicationPropertyErrorSchema = errorCollectionSchema;

export const getAllApplicationRolesResponseSchema = z.array(applicationRoleSchema);

export const getAllApplicationRolesErrorSchema = z.unknown();

export const getApplicationRoleDataSchema = z.object({
  path: z.object({
    key: z.string(),
  }),
});

export const getApplicationRoleResponseSchema = applicationRoleSchema;

export const getApplicationRoleErrorSchema = z.unknown();

export const getAttachmentContentDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      redirect: z.boolean().optional(),
    })
    .optional(),
});

export const getAttachmentContentResponseSchema = z.union([z.array(z.unknown()), z.unknown()]);

export const getAttachmentContentErrorSchema = z.unknown();

export const getAttachmentMetaResponseSchema = attachmentSettingsSchema;

export const getAttachmentMetaErrorSchema = z.unknown();

export const getAttachmentThumbnailDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      fallbackToDefault: z.boolean().optional(),
      height: z.number().optional(),
      redirect: z.boolean().optional(),
      width: z.number().optional(),
    })
    .optional(),
});

export const getAttachmentThumbnailResponseSchema = z.array(z.unknown());

export const getAttachmentThumbnailErrorSchema = z.unknown();

export const removeAttachmentDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const removeAttachmentResponseSchema = z.any();

export const removeAttachmentErrorSchema = z.unknown();

export const getAttachmentDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const attachmentMetadataSchema = z.object({
  author: userSchema.optional(),
  content: z.string().optional(),
  created: z.string().optional(),
  filename: z.string().optional(),
  id: z.number().optional(),
  mimeType: z.string().optional(),
  properties: z.record(z.string()).optional(),
  self: z.string().optional(),
  size: z.number().optional(),
  thumbnail: z.string().optional(),
});

export const getAttachmentErrorSchema = z.unknown();

export const expandAttachmentForHumansDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const expandAttachmentForHumansResponseSchema = attachmentArchiveMetadataReadableSchema;

export const expandAttachmentForHumansErrorSchema = z.unknown();

export const expandAttachmentForMachinesDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const expandAttachmentForMachinesResponseSchema = attachmentArchiveImplSchema;

export const expandAttachmentForMachinesErrorSchema = z.unknown();

export const getAuditRecordsDataSchema = z.object({
  query: z
    .object({
      filter: z.string().optional(),
      from: z.string().optional(),
      limit: z.number().optional(),
      offset: z.number().optional(),
      to: z.string().optional(),
    })
    .optional(),
});

export const auditRecordsSchema = z.object({
  limit: z.number().optional(),
  offset: z.number().optional(),
  records: z.array(auditRecordBeanSchema).optional(),
  total: z.number().optional(),
});

export const getAuditRecordsErrorSchema = errorCollectionSchema;

export const getAllSystemAvatarsDataSchema = z.object({
  path: z.object({
    type: z.union([z.literal('issuetype'), z.literal('project'), z.literal('user'), z.literal('priority')]),
  }),
});

export const getAllSystemAvatarsResponseSchema = systemAvatarsSchema;

export const getAllSystemAvatarsErrorSchema = z.unknown();

export const getBulkEditableFieldsDataSchema = z.object({
  query: z.object({
    endingBefore: z.string().optional(),
    issueIdsOrKeys: z.string(),
    searchText: z.string().optional(),
    startingAfter: z.string().optional(),
  }),
});

export const bulkOperationErrorResponseSchema = z.object({
  errors: z.array(errorMessageSchema).optional(),
});

export const submitBulkEditResponseSchema = submittedBulkOperationSchema;

export const submitBulkEditErrorSchema = bulkOperationErrorResponseSchema;

export const issueBulkMovePayloadSchema = z.object({
  sendBulkNotification: z.boolean().optional().nullable(),
  targetToSourcesMapping: z.record(targetToSourcesMappingSchema).optional(),
});

export const submitBulkMoveResponseSchema = submittedBulkOperationSchema;

export const submitBulkMoveErrorSchema = bulkOperationErrorResponseSchema;

export const getBulkOperationProgressDataSchema = z.object({
  path: z.object({
    taskId: z.string(),
  }),
});

export const bulkOperationProgressSchema = z.object({
  created: z.string().optional(),
  failedAccessibleIssues: z.record(z.array(z.string())).optional(),
  invalidOrInaccessibleIssueCount: z.number().optional(),
  processedAccessibleIssues: z.array(z.number()).optional(),
  progressPercent: z.number().optional(),
  started: z.string().optional(),
  status: z
    .union([
      z.literal('ENQUEUED'),
      z.literal('RUNNING'),
      z.literal('COMPLETE'),
      z.literal('FAILED'),
      z.literal('CANCEL_REQUESTED'),
      z.literal('CANCELLED'),
      z.literal('DEAD'),
    ])
    .optional(),
  submittedBy: userSchema.optional(),
  taskId: z.string().optional(),
  totalIssueCount: z.number().optional(),
  updated: z.string().optional(),
});

export const getBulkOperationProgressErrorSchema = bulkOperationErrorResponseSchema;

export const getAllUserDataClassificationLevelsDataSchema = z.object({
  query: z
    .object({
      orderBy: z.union([z.literal('rank'), z.literal('-rank'), z.literal('+rank')]).optional(),
      status: z.array(z.union([z.literal('PUBLISHED'), z.literal('ARCHIVED'), z.literal('DRAFT')])).optional(),
    })
    .optional(),
});

export const dataClassificationLevelsBeanSchema = z.object({
  classifications: z.array(dataClassificationTagBeanSchema).optional(),
});

export const getAllUserDataClassificationLevelsErrorSchema = z.unknown();

export const getCommentsByIdsDataSchema = z.object({
  body: issueCommentListRequestBeanSchema,
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const getCommentsByIdsResponseSchema = pageBeanCommentSchema;

export const getCommentsByIdsErrorSchema = z.unknown();

export const getCommentPropertyKeysDataSchema = z.object({
  path: z.object({
    commentId: z.string(),
  }),
});

export const getCommentPropertyKeysResponseSchema = propertyKeysSchema;

export const getCommentPropertyKeysErrorSchema = z.unknown();

export const deleteCommentPropertyDataSchema = z.object({
  path: z.object({
    commentId: z.string(),
    propertyKey: z.string(),
  }),
});

export const deleteCommentPropertyResponseSchema = z.any();

export const deleteCommentPropertyErrorSchema = z.unknown();

export const getCommentPropertyDataSchema = z.object({
  path: z.object({
    commentId: z.string(),
    propertyKey: z.string(),
  }),
});

export const getCommentPropertyResponseSchema = entityPropertySchema;

export const getCommentPropertyErrorSchema = z.unknown();

export const setCommentPropertyDataSchema = z.object({
  body: z.string().optional(),
  path: z.object({
    commentId: z.string(),
    propertyKey: z.string(),
  }),
});

export const setCommentPropertyResponseSchema = z.unknown();

export const setCommentPropertyErrorSchema = z.unknown();

export const findComponentsForProjectsDataSchema = z.object({
  query: z
    .object({
      maxResults: z.number().optional(),
      orderBy: z
        .union([
          z.literal('description'),
          z.literal('-description'),
          z.literal('+description'),
          z.literal('name'),
          z.literal('-name'),
          z.literal('+name'),
        ])
        .optional(),
      projectIdsOrKeys: z.array(z.string()).optional(),
      query: z.string().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const findComponentsForProjectsResponseSchema = pageBean2ComponentJsonBeanSchema;

export const findComponentsForProjectsErrorSchema = z.unknown();

export const projectComponentSchema = z.object({
  ari: z.string().optional(),
  assignee: userSchema.optional(),
  assigneeType: z
    .union([
      z.literal('PROJECT_DEFAULT'),
      z.literal('COMPONENT_LEAD'),
      z.literal('PROJECT_LEAD'),
      z.literal('UNASSIGNED'),
    ])
    .optional(),
  description: z.string().optional(),
  id: z.string().optional(),
  isAssigneeTypeValid: z.boolean().optional(),
  lead: userSchema.optional(),
  leadAccountId: z.string().optional(),
  leadUserName: z.string().optional(),
  metadata: z.record(z.string()).optional(),
  name: z.string().optional(),
  project: z.string().optional(),
  projectId: z.number().optional(),
  realAssignee: userSchema.optional(),
  realAssigneeType: z
    .union([
      z.literal('PROJECT_DEFAULT'),
      z.literal('COMPONENT_LEAD'),
      z.literal('PROJECT_LEAD'),
      z.literal('UNASSIGNED'),
    ])
    .optional(),
  self: z.string().optional(),
});

export const createComponentResponseSchema = projectComponentSchema;

export const createComponentErrorSchema = z.unknown();

export const deleteComponentDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      moveIssuesTo: z.string().optional(),
    })
    .optional(),
});

export const deleteComponentResponseSchema = z.any();

export const deleteComponentErrorSchema = z.unknown();

export const getComponentDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getComponentResponseSchema = projectComponentSchema;

export const getComponentErrorSchema = z.unknown();

export const updateComponentDataSchema = z.object({
  body: projectComponentSchema,
  path: z.object({
    id: z.string(),
  }),
});

export const updateComponentResponseSchema = projectComponentSchema;

export const updateComponentErrorSchema = z.unknown();

export const getComponentRelatedIssuesDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getComponentRelatedIssuesResponseSchema = componentIssuesCountSchema;

export const getComponentRelatedIssuesErrorSchema = z.unknown();

export const configurationSchema = z.object({
  attachmentsEnabled: z.boolean().optional(),
  issueLinkingEnabled: z.boolean().optional(),
  subTasksEnabled: z.boolean().optional(),
  timeTrackingConfiguration: timeTrackingConfigurationSchema.optional(),
  timeTrackingEnabled: z.boolean().optional(),
  unassignedIssuesAllowed: z.boolean().optional(),
  votingEnabled: z.boolean().optional(),
  watchingEnabled: z.boolean().optional(),
});

export const getConfigurationErrorSchema = z.unknown();

export const getSelectedTimeTrackingImplementationResponseSchema = z.union([timeTrackingProviderSchema, z.unknown()]);

export const getSelectedTimeTrackingImplementationErrorSchema = z.unknown();

export const selectTimeTrackingImplementationDataSchema = z.object({
  body: timeTrackingProviderSchema,
});

export const selectTimeTrackingImplementationResponseSchema = z.unknown();

export const selectTimeTrackingImplementationErrorSchema = z.unknown();

export const getAvailableTimeTrackingImplementationsResponseSchema = z.array(timeTrackingProviderSchema);

export const getAvailableTimeTrackingImplementationsErrorSchema = z.unknown();

export const getSharedTimeTrackingConfigurationResponseSchema = timeTrackingConfigurationSchema;

export const getSharedTimeTrackingConfigurationErrorSchema = z.unknown();

export const setSharedTimeTrackingConfigurationDataSchema = z.object({
  body: timeTrackingConfigurationSchema,
});

export const setSharedTimeTrackingConfigurationResponseSchema = timeTrackingConfigurationSchema;

export const setSharedTimeTrackingConfigurationErrorSchema = z.unknown();

export const getCustomFieldOptionDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getCustomFieldOptionResponseSchema = customFieldOptionSchema;

export const getCustomFieldOptionErrorSchema = z.unknown();

export const getAllDashboardsDataSchema = z.object({
  query: z
    .object({
      filter: z.union([z.literal('my'), z.literal('favourite')]).optional(),
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getAllDashboardsErrorSchema = errorCollectionSchema;

export const createDashboardErrorSchema = errorCollectionSchema;

export const bulkEditDashboardsResponseSchema = bulkEditShareableEntityResponseSchema;

export const bulkEditDashboardsErrorSchema = errorCollectionSchema;

export const getAllAvailableDashboardGadgetsResponseSchema = availableDashboardGadgetsResponseSchema;

export const getAllAvailableDashboardGadgetsErrorSchema = errorCollectionSchema;

export const getDashboardsPaginatedDataSchema = z.object({
  query: z
    .object({
      accountId: z.string().optional(),
      dashboardName: z.string().optional(),
      expand: z.string().optional(),
      groupId: z.string().optional(),
      groupname: z.string().optional(),
      maxResults: z.number().optional(),
      orderBy: z
        .union([
          z.literal('description'),
          z.literal('-description'),
          z.literal('+description'),
          z.literal('favorite_count'),
          z.literal('-favorite_count'),
          z.literal('+favorite_count'),
          z.literal('id'),
          z.literal('-id'),
          z.literal('+id'),
          z.literal('is_favorite'),
          z.literal('-is_favorite'),
          z.literal('+is_favorite'),
          z.literal('name'),
          z.literal('-name'),
          z.literal('+name'),
          z.literal('owner'),
          z.literal('-owner'),
          z.literal('+owner'),
        ])
        .optional(),
      owner: z.string().optional(),
      projectId: z.number().optional(),
      startAt: z.number().optional(),
      status: z.union([z.literal('active'), z.literal('archived'), z.literal('deleted')]).optional(),
    })
    .optional(),
});

export const getDashboardsPaginatedErrorSchema = errorCollectionSchema;

export const getAllGadgetsDataSchema = z.object({
  path: z.object({
    dashboardId: z.number(),
  }),
  query: z
    .object({
      gadgetId: z.array(z.number()).optional(),
      moduleKey: z.array(z.string()).optional(),
      uri: z.array(z.string()).optional(),
    })
    .optional(),
});

export const dashboardGadgetResponseSchema = z.object({
  gadgets: z.array(dashboardGadgetSchema),
});

export const getAllGadgetsErrorSchema = z.union([z.unknown(), errorCollectionSchema]);

export const addGadgetDataSchema = z.object({
  body: dashboardGadgetSettingsSchema,
  path: z.object({
    dashboardId: z.number(),
  }),
});

export const addGadgetResponseSchema = dashboardGadgetSchema;

export const addGadgetErrorSchema = z.union([errorCollectionSchema, z.unknown()]);

export const removeGadgetDataSchema = z.object({
  path: z.object({
    dashboardId: z.number(),
    gadgetId: z.number(),
  }),
});

export const removeGadgetResponseSchema = z.unknown();

export const removeGadgetErrorSchema = z.union([z.unknown(), errorCollectionSchema]);

export const updateGadgetDataSchema = z.object({
  body: dashboardGadgetUpdateRequestSchema,
  path: z.object({
    dashboardId: z.number(),
    gadgetId: z.number(),
  }),
});

export const updateGadgetResponseSchema = z.unknown();

export const updateGadgetErrorSchema = z.union([errorCollectionSchema, z.unknown()]);

export const getDashboardItemPropertyKeysDataSchema = z.object({
  path: z.object({
    dashboardId: z.string(),
    itemId: z.string(),
  }),
});

export const getDashboardItemPropertyKeysResponseSchema = propertyKeysSchema;

export const getDashboardItemPropertyKeysErrorSchema = errorCollectionSchema;

export const deleteDashboardItemPropertyDataSchema = z.object({
  path: z.object({
    dashboardId: z.string(),
    itemId: z.string(),
    propertyKey: z.string(),
  }),
});

export const deleteDashboardItemPropertyResponseSchema = z.unknown();

export const deleteDashboardItemPropertyErrorSchema = errorCollectionSchema;

export const getDashboardItemPropertyDataSchema = z.object({
  path: z.object({
    dashboardId: z.string(),
    itemId: z.string(),
    propertyKey: z.string(),
  }),
});

export const getDashboardItemPropertyResponseSchema = entityPropertySchema;

export const getDashboardItemPropertyErrorSchema = errorCollectionSchema;

export const setDashboardItemPropertyDataSchema = z.object({
  body: z.string().optional(),
  path: z.object({
    dashboardId: z.string(),
    itemId: z.string(),
    propertyKey: z.string(),
  }),
});

export const setDashboardItemPropertyResponseSchema = z.unknown();

export const setDashboardItemPropertyErrorSchema = errorCollectionSchema;

export const deleteDashboardDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const deleteDashboardResponseSchema = z.any();

export const deleteDashboardErrorSchema = errorCollectionSchema;

export const getDashboardDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getDashboardErrorSchema = z.union([errorCollectionSchema, z.unknown()]);

export const updateDashboardErrorSchema = errorCollectionSchema;

export const copyDashboardErrorSchema = errorCollectionSchema;

export const getPolicyResponseSchema = workspaceDataPolicySchema;

export const getPolicyErrorSchema = errorCollectionSchema;

export const getPoliciesDataSchema = z.object({
  query: z
    .object({
      ids: z.string().optional(),
    })
    .optional(),
});

export const projectDataPoliciesSchema = z.object({
  projectDataPolicies: z.array(projectWithDataPolicySchema).optional(),
});

export const getPoliciesErrorSchema = errorCollectionSchema;

export const getEventsResponseSchema = z.array(issueEventSchema);

export const getEventsErrorSchema = z.unknown();

export const analyseExpressionDataSchema = z.object({
  body: jiraExpressionForAnalysisSchema,
  query: z
    .object({
      check: z.union([z.literal('syntax'), z.literal('type'), z.literal('complexity')]).optional(),
    })
    .optional(),
});

export const jiraExpressionsAnalysisSchema = z.object({
  results: z.array(jiraExpressionAnalysisSchema),
});

export const analyseExpressionErrorSchema = z.union([errorCollectionSchema, z.unknown()]);

export const jiraExpressionEvalRequestBeanSchema = z.object({
  context: jiraExpressionEvalContextBeanSchema.optional(),
  expression: z.string(),
});

export const evaluateJiraExpressionErrorSchema = z.union([errorCollectionSchema, z.unknown()]);

export const jiraExpressionEvaluateRequestBeanSchema = z.object({
  context: jiraExpressionEvaluateContextBeanSchema.optional(),
  expression: z.string(),
});

export const evaluateJsisJiraExpressionErrorSchema = z.union([errorCollectionSchema, z.unknown()]);

export const getFieldsResponseSchema = z.array(fieldDetailsSchema);

export const getFieldsErrorSchema = z.unknown();

export const createCustomFieldDataSchema = z.object({
  body: customFieldDefinitionJsonBeanSchema,
});

export const createCustomFieldResponseSchema = fieldDetailsSchema;

export const createCustomFieldErrorSchema = z.unknown();

export const getFieldsPaginatedDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
      id: z.array(z.string()).optional(),
      maxResults: z.number().optional(),
      orderBy: z
        .union([
          z.literal('contextsCount'),
          z.literal('-contextsCount'),
          z.literal('+contextsCount'),
          z.literal('lastUsed'),
          z.literal('-lastUsed'),
          z.literal('+lastUsed'),
          z.literal('name'),
          z.literal('-name'),
          z.literal('+name'),
          z.literal('screensCount'),
          z.literal('-screensCount'),
          z.literal('+screensCount'),
          z.literal('projectsCount'),
          z.literal('-projectsCount'),
          z.literal('+projectsCount'),
        ])
        .optional(),
      query: z.string().optional(),
      startAt: z.number().optional(),
      type: z.array(z.union([z.literal('custom'), z.literal('system')])).optional(),
    })
    .optional(),
});

export const pageBeanFieldSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(fieldSchema).optional(),
});

export const getFieldsPaginatedErrorSchema = z.union([errorCollectionSchema, z.unknown()]);

export const getTrashedFieldsPaginatedDataSchema = z.object({
  query: z
    .object({
      expand: z
        .union([
          z.literal('name'),
          z.literal('-name'),
          z.literal('+name'),
          z.literal('trashDate'),
          z.literal('-trashDate'),
          z.literal('+trashDate'),
          z.literal('plannedDeletionDate'),
          z.literal('-plannedDeletionDate'),
          z.literal('+plannedDeletionDate'),
          z.literal('projectsCount'),
          z.literal('-projectsCount'),
          z.literal('+projectsCount'),
        ])
        .optional(),
      id: z.array(z.string()).optional(),
      maxResults: z.number().optional(),
      orderBy: z.string().optional(),
      query: z.string().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getTrashedFieldsPaginatedResponseSchema = pageBeanFieldSchema;

export const getTrashedFieldsPaginatedErrorSchema = z.union([errorCollectionSchema, z.unknown()]);

export const updateCustomFieldDataSchema = z.object({
  body: updateCustomFieldDetailsSchema,
  path: z.object({
    fieldId: z.string(),
  }),
});

export const updateCustomFieldResponseSchema = z.unknown();

export const updateCustomFieldErrorSchema = z.unknown();

export const getContextsForFieldDataSchema = z.object({
  path: z.object({
    fieldId: z.string(),
  }),
  query: z
    .object({
      contextId: z.array(z.number()).optional(),
      isAnyIssueType: z.boolean().optional(),
      isGlobalContext: z.boolean().optional(),
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getContextsForFieldResponseSchema = pageBeanCustomFieldContextSchema;

export const getContextsForFieldErrorSchema = z.unknown();

export const createCustomFieldContextDataSchema = z.object({
  body: createCustomFieldContextSchema,
  path: z.object({
    fieldId: z.string(),
  }),
});

export const createCustomFieldContextResponseSchema = createCustomFieldContextSchema;

export const createCustomFieldContextErrorSchema = z.unknown();

export const getDefaultValuesDataSchema = z.object({
  path: z.object({
    fieldId: z.string(),
  }),
  query: z
    .object({
      contextId: z.array(z.number()).optional(),
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getDefaultValuesErrorSchema = z.unknown();

export const setDefaultValuesResponseSchema = z.unknown();

export const setDefaultValuesErrorSchema = z.unknown();

export const getIssueTypeMappingsForContextsDataSchema = z.object({
  path: z.object({
    fieldId: z.string(),
  }),
  query: z
    .object({
      contextId: z.array(z.number()).optional(),
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getIssueTypeMappingsForContextsResponseSchema = pageBeanIssueTypeToContextMappingSchema;

export const getIssueTypeMappingsForContextsErrorSchema = z.unknown();

export const getCustomFieldContextsForProjectsAndIssueTypesDataSchema = z.object({
  body: projectIssueTypeMappingsSchema,
  path: z.object({
    fieldId: z.string(),
  }),
  query: z
    .object({
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getCustomFieldContextsForProjectsAndIssueTypesResponseSchema = pageBeanContextForProjectAndIssueTypeSchema;

export const getCustomFieldContextsForProjectsAndIssueTypesErrorSchema = z.unknown();

export const getProjectContextMappingDataSchema = z.object({
  path: z.object({
    fieldId: z.string(),
  }),
  query: z
    .object({
      contextId: z.array(z.number()).optional(),
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getProjectContextMappingResponseSchema = pageBeanCustomFieldContextProjectMappingSchema;

export const getProjectContextMappingErrorSchema = z.unknown();

export const deleteCustomFieldContextDataSchema = z.object({
  path: z.object({
    contextId: z.number(),
    fieldId: z.string(),
  }),
});

export const deleteCustomFieldContextResponseSchema = z.unknown();

export const deleteCustomFieldContextErrorSchema = z.unknown();

export const updateCustomFieldContextDataSchema = z.object({
  body: customFieldContextUpdateDetailsSchema,
  path: z.object({
    contextId: z.number(),
    fieldId: z.string(),
  }),
});

export const updateCustomFieldContextResponseSchema = z.unknown();

export const updateCustomFieldContextErrorSchema = z.unknown();

export const addIssueTypesToContextDataSchema = z.object({
  body: issueTypeIdsSchema,
  path: z.object({
    contextId: z.number(),
    fieldId: z.string(),
  }),
});

export const addIssueTypesToContextResponseSchema = z.unknown();

export const addIssueTypesToContextErrorSchema = z.unknown();

export const removeIssueTypesFromContextDataSchema = z.object({
  body: issueTypeIdsSchema,
  path: z.object({
    contextId: z.number(),
    fieldId: z.string(),
  }),
});

export const removeIssueTypesFromContextResponseSchema = z.unknown();

export const removeIssueTypesFromContextErrorSchema = z.unknown();

export const getOptionsForContextDataSchema = z.object({
  path: z.object({
    contextId: z.number(),
    fieldId: z.string(),
  }),
  query: z
    .object({
      maxResults: z.number().optional(),
      onlyOptions: z.boolean().optional(),
      optionId: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getOptionsForContextResponseSchema = pageBeanCustomFieldContextOptionSchema;

export const getOptionsForContextErrorSchema = z.unknown();

export const bulkCustomFieldOptionCreateRequestSchema = z.object({
  options: z.array(customFieldOptionCreateSchema).optional(),
});

export const createCustomFieldOptionResponseSchema = customFieldCreatedContextOptionsListSchema;

export const createCustomFieldOptionErrorSchema = z.unknown();

export const bulkCustomFieldOptionUpdateRequestSchema = z.object({
  options: z.array(customFieldOptionUpdateSchema).optional(),
});

export const updateCustomFieldOptionResponseSchema = customFieldUpdatedContextOptionsListSchema;

export const updateCustomFieldOptionErrorSchema = z.unknown();

export const reorderCustomFieldOptionsDataSchema = z.object({
  body: orderOfCustomFieldOptionsSchema,
  path: z.object({
    contextId: z.number(),
    fieldId: z.string(),
  }),
});

export const reorderCustomFieldOptionsResponseSchema = z.unknown();

export const reorderCustomFieldOptionsErrorSchema = z.unknown();

export const deleteCustomFieldOptionDataSchema = z.object({
  path: z.object({
    contextId: z.number(),
    fieldId: z.string(),
    optionId: z.number(),
  }),
});

export const deleteCustomFieldOptionResponseSchema = z.any();

export const deleteCustomFieldOptionErrorSchema = z.unknown();

export const replaceCustomFieldOptionDataSchema = z.object({
  path: z.object({
    contextId: z.number(),
    fieldId: z.string(),
    optionId: z.number(),
  }),
  query: z
    .object({
      jql: z.string().optional(),
      replaceWith: z.number().optional(),
    })
    .optional(),
});

export const assignProjectsToCustomFieldContextDataSchema = z.object({
  body: projectIdsSchema,
  path: z.object({
    contextId: z.number(),
    fieldId: z.string(),
  }),
});

export const assignProjectsToCustomFieldContextResponseSchema = z.unknown();

export const assignProjectsToCustomFieldContextErrorSchema = z.unknown();

export const removeCustomFieldContextFromProjectsDataSchema = z.object({
  body: projectIdsSchema,
  path: z.object({
    contextId: z.number(),
    fieldId: z.string(),
  }),
});

export const removeCustomFieldContextFromProjectsResponseSchema = z.unknown();

export const removeCustomFieldContextFromProjectsErrorSchema = z.unknown();

export const getContextsForFieldDeprecatedDataSchema = z.object({
  path: z.object({
    fieldId: z.string(),
  }),
  query: z
    .object({
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const pageBeanContextSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(contextSchema).optional(),
});

export const getContextsForFieldDeprecatedErrorSchema = z.unknown();

export const getScreensForFieldDataSchema = z.object({
  path: z.object({
    fieldId: z.string(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getScreensForFieldErrorSchema = z.unknown();

export const getAllIssueFieldOptionsDataSchema = z.object({
  path: z.object({
    fieldKey: z.string(),
  }),
  query: z
    .object({
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getAllIssueFieldOptionsErrorSchema = z.unknown();

export const createIssueFieldOptionErrorSchema = z.unknown();

export const getSelectableIssueFieldOptionsDataSchema = z.object({
  path: z.object({
    fieldKey: z.string(),
  }),
  query: z
    .object({
      maxResults: z.number().optional(),
      projectId: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getSelectableIssueFieldOptionsErrorSchema = z.unknown();

export const getVisibleIssueFieldOptionsDataSchema = z.object({
  path: z.object({
    fieldKey: z.string(),
  }),
  query: z
    .object({
      maxResults: z.number().optional(),
      projectId: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getVisibleIssueFieldOptionsErrorSchema = z.unknown();

export const deleteIssueFieldOptionDataSchema = z.object({
  path: z.object({
    fieldKey: z.string(),
    optionId: z.number(),
  }),
});

export const deleteIssueFieldOptionResponseSchema = z.unknown();

export const deleteIssueFieldOptionErrorSchema = z.unknown();

export const getIssueFieldOptionDataSchema = z.object({
  path: z.object({
    fieldKey: z.string(),
    optionId: z.number(),
  }),
});

export const getIssueFieldOptionErrorSchema = z.unknown();

export const updateIssueFieldOptionErrorSchema = z.unknown();

export const replaceIssueFieldOptionDataSchema = z.object({
  path: z.object({
    fieldKey: z.string(),
    optionId: z.number(),
  }),
  query: z
    .object({
      jql: z.string().optional(),
      overrideEditableFlag: z.boolean().optional(),
      overrideScreenSecurity: z.boolean().optional(),
      replaceWith: z.number().optional(),
    })
    .optional(),
});

export const deleteCustomFieldDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const restoreCustomFieldDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const restoreCustomFieldResponseSchema = z.unknown();

export const restoreCustomFieldErrorSchema = errorCollectionSchema;

export const trashCustomFieldDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const trashCustomFieldResponseSchema = z.unknown();

export const trashCustomFieldErrorSchema = errorCollectionSchema;

export const getAllFieldConfigurationsDataSchema = z.object({
  query: z
    .object({
      id: z.array(z.number()).optional(),
      isDefault: z.boolean().optional(),
      maxResults: z.number().optional(),
      query: z.string().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getAllFieldConfigurationsResponseSchema = pageBeanFieldConfigurationDetailsSchema;

export const getAllFieldConfigurationsErrorSchema = z.unknown();

export const createFieldConfigurationDataSchema = z.object({
  body: fieldConfigurationDetailsSchema,
});

export const createFieldConfigurationResponseSchema = fieldConfigurationSchema;

export const createFieldConfigurationErrorSchema = z.unknown();

export const deleteFieldConfigurationDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const deleteFieldConfigurationResponseSchema = z.unknown();

export const deleteFieldConfigurationErrorSchema = z.unknown();

export const updateFieldConfigurationDataSchema = z.object({
  body: fieldConfigurationDetailsSchema,
  path: z.object({
    id: z.number(),
  }),
});

export const updateFieldConfigurationResponseSchema = z.unknown();

export const updateFieldConfigurationErrorSchema = z.unknown();

export const getFieldConfigurationItemsDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
  query: z
    .object({
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getFieldConfigurationItemsResponseSchema = pageBeanFieldConfigurationItemSchema;

export const getFieldConfigurationItemsErrorSchema = z.unknown();

export const updateFieldConfigurationItemsDataSchema = z.object({
  body: fieldConfigurationItemsDetailsSchema,
  path: z.object({
    id: z.number(),
  }),
});

export const updateFieldConfigurationItemsResponseSchema = z.unknown();

export const updateFieldConfigurationItemsErrorSchema = z.unknown();

export const getAllFieldConfigurationSchemesDataSchema = z.object({
  query: z
    .object({
      id: z.array(z.number()).optional(),
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getAllFieldConfigurationSchemesResponseSchema = pageBeanFieldConfigurationSchemeSchema;

export const getAllFieldConfigurationSchemesErrorSchema = z.unknown();

export const createFieldConfigurationSchemeDataSchema = z.object({
  body: updateFieldConfigurationSchemeDetailsSchema,
});

export const createFieldConfigurationSchemeResponseSchema = fieldConfigurationSchemeSchema;

export const createFieldConfigurationSchemeErrorSchema = z.unknown();

export const getFieldConfigurationSchemeMappingsDataSchema = z.object({
  query: z
    .object({
      fieldConfigurationSchemeId: z.array(z.number()).optional(),
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getFieldConfigurationSchemeMappingsResponseSchema = pageBeanFieldConfigurationIssueTypeItemSchema;

export const getFieldConfigurationSchemeMappingsErrorSchema = z.unknown();

export const getFieldConfigurationSchemeProjectMappingDataSchema = z.object({
  query: z.object({
    maxResults: z.number().optional(),
    projectId: z.array(z.number()),
    startAt: z.number().optional(),
  }),
});

export const getFieldConfigurationSchemeProjectMappingResponseSchema = pageBeanFieldConfigurationSchemeProjectsSchema;

export const getFieldConfigurationSchemeProjectMappingErrorSchema = z.unknown();

export const assignFieldConfigurationSchemeToProjectDataSchema = z.object({
  body: fieldConfigurationSchemeProjectAssociationSchema,
});

export const assignFieldConfigurationSchemeToProjectResponseSchema = z.unknown();

export const assignFieldConfigurationSchemeToProjectErrorSchema = z.unknown();

export const deleteFieldConfigurationSchemeDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const deleteFieldConfigurationSchemeResponseSchema = z.unknown();

export const deleteFieldConfigurationSchemeErrorSchema = z.unknown();

export const updateFieldConfigurationSchemeDataSchema = z.object({
  body: updateFieldConfigurationSchemeDetailsSchema,
  path: z.object({
    id: z.number(),
  }),
});

export const updateFieldConfigurationSchemeResponseSchema = z.unknown();

export const updateFieldConfigurationSchemeErrorSchema = z.unknown();

export const associateFieldConfigurationsWithIssueTypesRequestSchema = z.object({
  mappings: z.array(fieldConfigurationToIssueTypeMappingSchema),
});

export const setFieldConfigurationSchemeMappingResponseSchema = z.unknown();

export const setFieldConfigurationSchemeMappingErrorSchema = z.unknown();

export const removeIssueTypesFromGlobalFieldConfigurationSchemeDataSchema = z.object({
  body: issueTypeIdsToRemoveSchema,
  path: z.object({
    id: z.number(),
  }),
});

export const removeIssueTypesFromGlobalFieldConfigurationSchemeResponseSchema = z.unknown();

export const removeIssueTypesFromGlobalFieldConfigurationSchemeErrorSchema = errorCollectionSchema;

export const createFilterErrorSchema = z.unknown();

export const getDefaultShareScopeResponseSchema = defaultShareScopeSchema;

export const getDefaultShareScopeErrorSchema = z.unknown();

export const setDefaultShareScopeDataSchema = z.object({
  body: defaultShareScopeSchema,
});

export const setDefaultShareScopeResponseSchema = defaultShareScopeSchema;

export const setDefaultShareScopeErrorSchema = z.unknown();

export const getFavouriteFiltersDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const getFavouriteFiltersErrorSchema = z.unknown();

export const getMyFiltersDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
      includeFavourites: z.boolean().optional(),
    })
    .optional(),
});

export const getMyFiltersErrorSchema = z.unknown();

export const getFiltersPaginatedDataSchema = z.object({
  query: z
    .object({
      accountId: z.string().optional(),
      expand: z.string().optional(),
      filterName: z.string().optional(),
      groupId: z.string().optional(),
      groupname: z.string().optional(),
      id: z.array(z.number()).optional(),
      maxResults: z.number().optional(),
      orderBy: z
        .union([
          z.literal('description'),
          z.literal('-description'),
          z.literal('+description'),
          z.literal('favourite_count'),
          z.literal('-favourite_count'),
          z.literal('+favourite_count'),
          z.literal('id'),
          z.literal('-id'),
          z.literal('+id'),
          z.literal('is_favourite'),
          z.literal('-is_favourite'),
          z.literal('+is_favourite'),
          z.literal('name'),
          z.literal('-name'),
          z.literal('+name'),
          z.literal('owner'),
          z.literal('-owner'),
          z.literal('+owner'),
          z.literal('is_shared'),
          z.literal('-is_shared'),
          z.literal('+is_shared'),
        ])
        .optional(),
      overrideSharePermissions: z.boolean().optional(),
      owner: z.string().optional(),
      projectId: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getFiltersPaginatedErrorSchema = z.union([errorCollectionSchema, z.unknown()]);

export const deleteFilterDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const deleteFilterResponseSchema = z.any();

export const deleteFilterErrorSchema = z.unknown();

export const getFilterDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
      overrideSharePermissions: z.boolean().optional(),
    })
    .optional(),
});

export const getFilterErrorSchema = z.unknown();

export const updateFilterErrorSchema = z.unknown();

export const resetColumnsDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const resetColumnsResponseSchema = z.any();

export const resetColumnsErrorSchema = z.unknown();

export const getColumnsDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const getColumnsResponseSchema = z.array(columnItemSchema);

export const getColumnsErrorSchema = z.unknown();

export const setColumnsDataSchema = z.object({
  body: columnRequestBodySchema,
  path: z.object({
    id: z.number(),
  }),
});

export const setColumnsResponseSchema = z.unknown();

export const setColumnsErrorSchema = z.unknown();

export const deleteFavouriteForFilterDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const deleteFavouriteForFilterErrorSchema = z.unknown();

export const setFavouriteForFilterDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const setFavouriteForFilterErrorSchema = z.unknown();

export const changeFilterOwnerDataSchema = z.object({
  body: changeFilterOwnerSchema,
  path: z.object({
    id: z.number(),
  }),
});

export const changeFilterOwnerResponseSchema = z.unknown();

export const changeFilterOwnerErrorSchema = z.unknown();

export const getSharePermissionsDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const getSharePermissionsErrorSchema = z.unknown();

export const addSharePermissionDataSchema = z.object({
  body: sharePermissionInputBeanSchema,
  path: z.object({
    id: z.number(),
  }),
});

export const addSharePermissionErrorSchema = z.unknown();

export const deleteSharePermissionDataSchema = z.object({
  path: z.object({
    id: z.number(),
    permissionId: z.number(),
  }),
});

export const deleteSharePermissionResponseSchema = z.any();

export const deleteSharePermissionErrorSchema = z.unknown();

export const getSharePermissionDataSchema = z.object({
  path: z.object({
    id: z.number(),
    permissionId: z.number(),
  }),
});

export const getSharePermissionErrorSchema = z.unknown();

export const removeGroupDataSchema = z.object({
  query: z
    .object({
      groupId: z.string().optional(),
      groupname: z.string().optional(),
      swapGroup: z.string().optional(),
      swapGroupId: z.string().optional(),
    })
    .optional(),
});

export const removeGroupResponseSchema = z.unknown();

export const removeGroupErrorSchema = z.unknown();

export const getGroupDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
      groupId: z.string().optional(),
      groupname: z.string().optional(),
    })
    .optional(),
});

export const groupSchema = z.object({
  expand: z.string().optional(),
  groupId: z.string().optional().nullable(),
  name: z.string().optional(),
  self: z.string().optional(),
  users: pagedListUserDetailsApplicationUserSchema.optional(),
});

export const getGroupErrorSchema = z.unknown();

export const createGroupDataSchema = z.object({
  body: addGroupBeanSchema,
});

export const createGroupResponseSchema = groupSchema;

export const createGroupErrorSchema = z.unknown();

export const bulkGetGroupsDataSchema = z.object({
  query: z
    .object({
      accessType: z.string().optional(),
      applicationKey: z.string().optional(),
      groupId: z.array(z.string()).optional(),
      groupName: z.array(z.string()).optional(),
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const bulkGetGroupsResponseSchema = pageBeanGroupDetailsSchema;

export const bulkGetGroupsErrorSchema = z.unknown();

export const getUsersFromGroupDataSchema = z.object({
  query: z
    .object({
      groupId: z.string().optional(),
      groupname: z.string().optional(),
      includeInactiveUsers: z.boolean().optional(),
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getUsersFromGroupResponseSchema = pageBeanUserDetailsSchema;

export const getUsersFromGroupErrorSchema = z.unknown();

export const removeUserFromGroupDataSchema = z.object({
  query: z.object({
    accountId: z.string(),
    groupId: z.string().optional(),
    groupname: z.string().optional(),
    username: z.string().optional(),
  }),
});

export const removeUserFromGroupResponseSchema = z.unknown();

export const removeUserFromGroupErrorSchema = z.unknown();

export const addUserToGroupDataSchema = z.object({
  body: updateUserToGroupBeanSchema,
  query: z
    .object({
      groupId: z.string().optional(),
      groupname: z.string().optional(),
    })
    .optional(),
});

export const addUserToGroupResponseSchema = groupSchema;

export const addUserToGroupErrorSchema = z.unknown();

export const findGroupsDataSchema = z.object({
  query: z
    .object({
      accountId: z.string().optional(),
      caseInsensitive: z.boolean().optional(),
      exclude: z.array(z.string()).optional(),
      excludeId: z.array(z.string()).optional(),
      maxResults: z.number().optional(),
      query: z.string().optional(),
      userName: z.string().optional(),
    })
    .optional(),
});

export const findGroupsResponseSchema = foundGroupsSchema;

export const findGroupsErrorSchema = z.unknown();

export const findUsersAndGroupsDataSchema = z.object({
  query: z.object({
    avatarSize: z
      .union([
        z.literal('xsmall'),
        z.literal('xsmall@2x'),
        z.literal('xsmall@3x'),
        z.literal('small'),
        z.literal('small@2x'),
        z.literal('small@3x'),
        z.literal('medium'),
        z.literal('medium@2x'),
        z.literal('medium@3x'),
        z.literal('large'),
        z.literal('large@2x'),
        z.literal('large@3x'),
        z.literal('xlarge'),
        z.literal('xlarge@2x'),
        z.literal('xlarge@3x'),
        z.literal('xxlarge'),
        z.literal('xxlarge@2x'),
        z.literal('xxlarge@3x'),
        z.literal('xxxlarge'),
        z.literal('xxxlarge@2x'),
        z.literal('xxxlarge@3x'),
      ])
      .optional(),
    caseInsensitive: z.boolean().optional(),
    excludeConnectAddons: z.boolean().optional(),
    fieldId: z.string().optional(),
    issueTypeId: z.array(z.string()).optional(),
    maxResults: z.number().optional(),
    projectId: z.array(z.string()).optional(),
    query: z.string(),
    showAvatar: z.boolean().optional(),
  }),
});

export const foundUsersAndGroupsSchema = z.object({
  groups: foundGroupsSchema.optional(),
  users: foundUsersSchema.optional(),
});

export const findUsersAndGroupsErrorSchema = z.unknown();

export const licenseSchema = z.object({
  applications: z.array(licensedApplicationSchema),
});

export const getLicenseErrorSchema = z.unknown();

export const issueUpdateDetailsSchema = z.object({
  fields: z.record(z.string()).optional(),
  historyMetadata: historyMetadataSchema.optional(),
  properties: z.array(entityPropertySchema).optional(),
  transition: issueTransitionSchema.optional(),
  update: z.record(z.array(fieldUpdateOperationSchema)).optional(),
});

export const createIssueErrorSchema = errorCollectionSchema;

export const archiveIssuesAsyncDataSchema = z.object({
  body: archiveIssueAsyncRequestSchema,
});

export const archiveIssuesAsyncResponseSchema = z.string();

export const archiveIssuesAsyncErrorSchema = z.unknown();

export const archiveIssuesDataSchema = z.object({
  body: issueArchivalSyncRequestSchema,
});

export const archiveIssuesResponseSchema = issueArchivalSyncResponseSchema;

export const archiveIssuesErrorSchema = z.unknown();

export const issuesUpdateBeanSchema = z.object({
  issueUpdates: z.array(issueUpdateDetailsSchema).optional(),
});

export const bulkFetchIssuesDataSchema = z.object({
  body: bulkFetchIssueRequestBeanSchema,
});

export const bulkFetchIssuesErrorSchema = z.unknown();

export const getCreateIssueMetaDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
      issuetypeIds: z.array(z.string()).optional(),
      issuetypeNames: z.array(z.string()).optional(),
      projectIds: z.array(z.string()).optional(),
      projectKeys: z.array(z.string()).optional(),
    })
    .optional(),
});

export const issueCreateMetadataSchema = z.object({
  expand: z.string().optional(),
  projects: z.array(projectIssueCreateMetadataSchema).optional(),
});

export const getCreateIssueMetaErrorSchema = z.unknown();

export const getCreateIssueMetaIssueTypesDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
  }),
  query: z
    .object({
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getCreateIssueMetaIssueTypesResponseSchema = pageOfCreateMetaIssueTypesSchema;

export const getCreateIssueMetaIssueTypesErrorSchema = z.unknown();

export const getCreateIssueMetaIssueTypeIdDataSchema = z.object({
  path: z.object({
    issueTypeId: z.string(),
    projectIdOrKey: z.string(),
  }),
  query: z
    .object({
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getCreateIssueMetaIssueTypeIdResponseSchema = pageOfCreateMetaIssueTypeWithFieldSchema;

export const getCreateIssueMetaIssueTypeIdErrorSchema = z.unknown();

export const getIssueLimitReportDataSchema = z.object({
  body: issueLimitReportRequestSchema,
  query: z
    .object({
      isReturningKeys: z.boolean().optional(),
    })
    .optional(),
});

export const getIssueLimitReportResponseSchema = issueLimitReportResponseBeanSchema;

export const getIssueLimitReportErrorSchema = z.unknown();

export const getIssuePickerResourceDataSchema = z.object({
  query: z
    .object({
      currentIssueKey: z.string().optional(),
      currentJQL: z.string().optional(),
      currentProjectId: z.string().optional(),
      query: z.string().optional(),
      showSubTaskParent: z.boolean().optional(),
      showSubTasks: z.boolean().optional(),
    })
    .optional(),
});

export const getIssuePickerResourceErrorSchema = z.unknown();

export const issueEntityPropertiesSchema = z.object({
  entitiesIds: z.array(z.number()).optional(),
  properties: z.record(jsonNodeSchema).optional(),
});

export const multiIssueEntityPropertiesSchema = z.object({
  issues: z.array(issueEntityPropertiesForMultiUpdateSchema).optional(),
});

export const bulkDeleteIssuePropertyDataSchema = z.object({
  body: issueFilterForBulkPropertyDeleteSchema,
  path: z.object({
    propertyKey: z.string(),
  }),
});

export const bulkIssuePropertyUpdateRequestSchema = z.object({
  expression: z.string().optional(),
  filter: issueFilterForBulkPropertySetSchema.optional(),
  value: z.string().optional(),
});

export const unarchiveIssuesDataSchema = z.object({
  body: issueArchivalSyncRequestSchema,
});

export const unarchiveIssuesResponseSchema = issueArchivalSyncResponseSchema;

export const unarchiveIssuesErrorSchema = z.unknown();

export const getIsWatchingIssueBulkDataSchema = z.object({
  body: issueListSchema,
});

export const getIsWatchingIssueBulkResponseSchema = bulkIssueIsWatchingSchema;

export const getIsWatchingIssueBulkErrorSchema = z.unknown();

export const deleteIssueDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      deleteSubtasks: z.union([z.literal('true'), z.literal('false')]).optional(),
    })
    .optional(),
});

export const deleteIssueResponseSchema = z.any();

export const deleteIssueErrorSchema = z.unknown();

export const getIssueDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
      failFast: z.boolean().optional(),
      fields: z.array(z.string()).optional(),
      fieldsByKeys: z.boolean().optional(),
      properties: z.array(z.string()).optional(),
      updateHistory: z.boolean().optional(),
    })
    .optional(),
});

export const getIssueErrorSchema = z.unknown();

export const editIssueDataSchema = z.object({
  body: issueUpdateDetailsSchema,
  path: z.object({
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
      notifyUsers: z.boolean().optional(),
      overrideEditableFlag: z.boolean().optional(),
      overrideScreenSecurity: z.boolean().optional(),
      returnIssue: z.boolean().optional(),
    })
    .optional(),
});

export const editIssueResponseSchema = z.unknown();

export const editIssueErrorSchema = z.unknown();

export const assignIssueDataSchema = z.object({
  body: userSchema,
  path: z.object({
    issueIdOrKey: z.string(),
  }),
});

export const assignIssueResponseSchema = z.unknown();

export const assignIssueErrorSchema = z.unknown();

export const addAttachmentResponseSchema = z.array(attachmentSchema);

export const addAttachmentErrorSchema = z.unknown();

export const getChangeLogsDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const pageBeanChangelogSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(changelogSchema).optional(),
});

export const getChangeLogsErrorSchema = z.unknown();

export const getChangeLogsByIdsDataSchema = z.object({
  body: issueChangelogIdsSchema,
  path: z.object({
    issueIdOrKey: z.string(),
  }),
});

export const getChangeLogsByIdsResponseSchema = pageOfChangelogsSchema;

export const getChangeLogsByIdsErrorSchema = z.unknown();

export const getCommentsDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
      maxResults: z.number().optional(),
      orderBy: z.union([z.literal('created'), z.literal('-created'), z.literal('+created')]).optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getCommentsResponseSchema = pageOfCommentsSchema;

export const getCommentsErrorSchema = z.unknown();

export const addCommentDataSchema = z.object({
  body: commentSchema,
  path: z.object({
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const addCommentResponseSchema = commentSchema;

export const addCommentErrorSchema = z.unknown();

export const deleteCommentDataSchema = z.object({
  path: z.object({
    id: z.string(),
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      parentId: z.string().optional(),
    })
    .optional(),
});

export const deleteCommentResponseSchema = z.any();

export const deleteCommentErrorSchema = z.unknown();

export const getCommentDataSchema = z.object({
  path: z.object({
    id: z.string(),
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const getCommentResponseSchema = commentSchema;

export const getCommentErrorSchema = z.unknown();

export const updateCommentDataSchema = z.object({
  body: commentSchema,
  path: z.object({
    id: z.string(),
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
      notifyUsers: z.boolean().optional(),
      overrideEditableFlag: z.boolean().optional(),
    })
    .optional(),
});

export const updateCommentResponseSchema = commentSchema;

export const updateCommentErrorSchema = z.unknown();

export const getEditIssueMetaDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      overrideEditableFlag: z.boolean().optional(),
      overrideScreenSecurity: z.boolean().optional(),
    })
    .optional(),
});

export const getEditIssueMetaResponseSchema = issueUpdateMetadataSchema;

export const getEditIssueMetaErrorSchema = z.unknown();

export const notifyResponseSchema = z.unknown();

export const notifyErrorSchema = z.unknown();

export const getIssuePropertyKeysDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
  }),
});

export const getIssuePropertyKeysResponseSchema = propertyKeysSchema;

export const getIssuePropertyKeysErrorSchema = z.unknown();

export const deleteIssuePropertyDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
    propertyKey: z.string(),
  }),
});

export const deleteIssuePropertyResponseSchema = z.any();

export const deleteIssuePropertyErrorSchema = z.unknown();

export const getIssuePropertyDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
    propertyKey: z.string(),
  }),
});

export const getIssuePropertyResponseSchema = entityPropertySchema;

export const getIssuePropertyErrorSchema = z.unknown();

export const setIssuePropertyDataSchema = z.object({
  body: z.string().optional(),
  path: z.object({
    issueIdOrKey: z.string(),
    propertyKey: z.string(),
  }),
});

export const setIssuePropertyResponseSchema = z.unknown();

export const setIssuePropertyErrorSchema = z.unknown();

export const deleteRemoteIssueLinkByGlobalIdDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
  }),
  query: z.object({
    globalId: z.string(),
  }),
});

export const deleteRemoteIssueLinkByGlobalIdResponseSchema = z.any();

export const deleteRemoteIssueLinkByGlobalIdErrorSchema = z.unknown();

export const getRemoteIssueLinksDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      globalId: z.string().optional(),
    })
    .optional(),
});

export const remoteIssueLinkSchema = z.object({
  application: applicationSchema.optional(),
  globalId: z.string().optional(),
  id: z.number().optional(),
  object: remoteObjectSchema.optional(),
  relationship: z.string().optional(),
  self: z.string().optional(),
});

export const getRemoteIssueLinksErrorSchema = z.unknown();

export const createOrUpdateRemoteIssueLinkDataSchema = z.object({
  body: remoteIssueLinkRequestSchema,
  path: z.object({
    issueIdOrKey: z.string(),
  }),
});

export const createOrUpdateRemoteIssueLinkResponseSchema = remoteIssueLinkIdentifiesSchema;

export const createOrUpdateRemoteIssueLinkErrorSchema = z.unknown();

export const deleteRemoteIssueLinkByIdDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
    linkId: z.string(),
  }),
});

export const deleteRemoteIssueLinkByIdResponseSchema = z.any();

export const deleteRemoteIssueLinkByIdErrorSchema = z.unknown();

export const getRemoteIssueLinkByIdDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
    linkId: z.string(),
  }),
});

export const getRemoteIssueLinkByIdResponseSchema = remoteIssueLinkSchema;

export const getRemoteIssueLinkByIdErrorSchema = z.unknown();

export const updateRemoteIssueLinkDataSchema = z.object({
  body: remoteIssueLinkRequestSchema,
  path: z.object({
    issueIdOrKey: z.string(),
    linkId: z.string(),
  }),
});

export const updateRemoteIssueLinkResponseSchema = z.unknown();

export const updateRemoteIssueLinkErrorSchema = z.unknown();

export const getTransitionsDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
      includeUnavailableTransitions: z.boolean().optional(),
      skipRemoteOnlyCondition: z.boolean().optional(),
      sortByOpsBarAndStatus: z.boolean().optional(),
      transitionId: z.string().optional(),
    })
    .optional(),
});

export const transitionsSchema = z.object({
  expand: z.string().optional(),
  transitions: z.array(issueTransitionSchema).optional(),
});

export const getTransitionsErrorSchema = z.unknown();

export const doTransitionDataSchema = z.object({
  body: issueUpdateDetailsSchema,
  path: z.object({
    issueIdOrKey: z.string(),
  }),
});

export const doTransitionResponseSchema = z.unknown();

export const doTransitionErrorSchema = z.unknown();

export const removeVoteDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
  }),
});

export const removeVoteResponseSchema = z.any();

export const removeVoteErrorSchema = z.unknown();

export const getVotesDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
  }),
});

export const getVotesResponseSchema = votesSchema;

export const getVotesErrorSchema = z.unknown();

export const addVoteDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
  }),
});

export const addVoteResponseSchema = z.unknown();

export const addVoteErrorSchema = z.unknown();

export const removeWatcherDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      accountId: z.string().optional(),
      username: z.string().optional(),
    })
    .optional(),
});

export const removeWatcherResponseSchema = z.any();

export const removeWatcherErrorSchema = z.unknown();

export const getIssueWatchersDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
  }),
});

export const getIssueWatchersResponseSchema = watchersSchema;

export const getIssueWatchersErrorSchema = z.unknown();

export const addWatcherDataSchema = z.object({
  body: z.string(),
  path: z.object({
    issueIdOrKey: z.string(),
  }),
});

export const addWatcherResponseSchema = z.unknown();

export const addWatcherErrorSchema = z.unknown();

export const bulkDeleteWorklogsDataSchema = z.object({
  body: worklogIdsRequestBeanSchema,
  path: z.object({
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      adjustEstimate: z.union([z.literal('leave'), z.literal('auto')]).optional(),
      overrideEditableFlag: z.boolean().optional(),
    })
    .optional(),
});

export const bulkDeleteWorklogsResponseSchema = z.union([z.unknown(), z.any()]);

export const bulkDeleteWorklogsErrorSchema = z.unknown();

export const getIssueWorklogDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
      startedAfter: z.number().optional(),
      startedBefore: z.number().optional(),
    })
    .optional(),
});

export const getIssueWorklogResponseSchema = pageOfWorklogsSchema;

export const getIssueWorklogErrorSchema = z.unknown();

export const addWorklogDataSchema = z.object({
  body: worklogSchema,
  path: z.object({
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      adjustEstimate: z
        .union([z.literal('new'), z.literal('leave'), z.literal('manual'), z.literal('auto')])
        .optional(),
      expand: z.string().optional(),
      newEstimate: z.string().optional(),
      notifyUsers: z.boolean().optional(),
      overrideEditableFlag: z.boolean().optional(),
      reduceBy: z.string().optional(),
    })
    .optional(),
});

export const addWorklogResponseSchema = worklogSchema;

export const addWorklogErrorSchema = z.unknown();

export const bulkMoveWorklogsDataSchema = z.object({
  body: worklogsMoveRequestBeanSchema,
  path: z.object({
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      adjustEstimate: z.union([z.literal('leave'), z.literal('auto')]).optional(),
      overrideEditableFlag: z.boolean().optional(),
    })
    .optional(),
});

export const bulkMoveWorklogsResponseSchema = z.union([z.unknown(), z.any()]);

export const bulkMoveWorklogsErrorSchema = z.unknown();

export const deleteWorklogDataSchema = z.object({
  path: z.object({
    id: z.string(),
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      adjustEstimate: z
        .union([z.literal('new'), z.literal('leave'), z.literal('manual'), z.literal('auto')])
        .optional(),
      increaseBy: z.string().optional(),
      newEstimate: z.string().optional(),
      notifyUsers: z.boolean().optional(),
      overrideEditableFlag: z.boolean().optional(),
    })
    .optional(),
});

export const deleteWorklogResponseSchema = z.any();

export const deleteWorklogErrorSchema = z.unknown();

export const getWorklogDataSchema = z.object({
  path: z.object({
    id: z.string(),
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const getWorklogResponseSchema = worklogSchema;

export const getWorklogErrorSchema = z.unknown();

export const updateWorklogDataSchema = z.object({
  body: worklogSchema,
  path: z.object({
    id: z.string(),
    issueIdOrKey: z.string(),
  }),
  query: z
    .object({
      adjustEstimate: z
        .union([z.literal('new'), z.literal('leave'), z.literal('manual'), z.literal('auto')])
        .optional(),
      expand: z.string().optional(),
      newEstimate: z.string().optional(),
      notifyUsers: z.boolean().optional(),
      overrideEditableFlag: z.boolean().optional(),
    })
    .optional(),
});

export const updateWorklogResponseSchema = worklogSchema;

export const updateWorklogErrorSchema = z.unknown();

export const getWorklogPropertyKeysDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
    worklogId: z.string(),
  }),
});

export const getWorklogPropertyKeysResponseSchema = propertyKeysSchema;

export const getWorklogPropertyKeysErrorSchema = z.unknown();

export const deleteWorklogPropertyDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
    propertyKey: z.string(),
    worklogId: z.string(),
  }),
});

export const deleteWorklogPropertyResponseSchema = z.any();

export const deleteWorklogPropertyErrorSchema = z.unknown();

export const getWorklogPropertyDataSchema = z.object({
  path: z.object({
    issueIdOrKey: z.string(),
    propertyKey: z.string(),
    worklogId: z.string(),
  }),
});

export const getWorklogPropertyResponseSchema = entityPropertySchema;

export const getWorklogPropertyErrorSchema = z.unknown();

export const setWorklogPropertyDataSchema = z.object({
  body: z.string().optional(),
  path: z.object({
    issueIdOrKey: z.string(),
    propertyKey: z.string(),
    worklogId: z.string(),
  }),
});

export const setWorklogPropertyResponseSchema = z.unknown();

export const setWorklogPropertyErrorSchema = z.unknown();

export const linkIssuesResponseSchema = z.unknown();

export const linkIssuesErrorSchema = z.unknown();

export const deleteIssueLinkDataSchema = z.object({
  path: z.object({
    linkId: z.string(),
  }),
});

export const deleteIssueLinkResponseSchema = z.union([z.unknown(), z.any()]);

export const deleteIssueLinkErrorSchema = z.unknown();

export const getIssueLinkDataSchema = z.object({
  path: z.object({
    linkId: z.string(),
  }),
});

export const getIssueLinkErrorSchema = z.unknown();

export const getIssueLinkTypesResponseSchema = issueLinkTypesSchema;

export const getIssueLinkTypesErrorSchema = z.unknown();

export const createIssueLinkTypeDataSchema = z.object({
  body: issueLinkTypeSchema,
});

export const createIssueLinkTypeResponseSchema = issueLinkTypeSchema;

export const createIssueLinkTypeErrorSchema = z.unknown();

export const deleteIssueLinkTypeDataSchema = z.object({
  path: z.object({
    issueLinkTypeId: z.string(),
  }),
});

export const deleteIssueLinkTypeResponseSchema = z.any();

export const deleteIssueLinkTypeErrorSchema = z.unknown();

export const getIssueLinkTypeDataSchema = z.object({
  path: z.object({
    issueLinkTypeId: z.string(),
  }),
});

export const getIssueLinkTypeResponseSchema = issueLinkTypeSchema;

export const getIssueLinkTypeErrorSchema = z.unknown();

export const updateIssueLinkTypeDataSchema = z.object({
  body: issueLinkTypeSchema,
  path: z.object({
    issueLinkTypeId: z.string(),
  }),
});

export const updateIssueLinkTypeResponseSchema = issueLinkTypeSchema;

export const updateIssueLinkTypeErrorSchema = z.unknown();

export const archivedIssuesFilterRequestSchema = z.object({
  archivedBy: z.array(z.string()).optional(),
  archivedDateRange: dateRangeFilterRequestSchema.optional(),
  issueTypes: z.array(z.string()).optional(),
  projects: z.array(z.string()).optional(),
  reporters: z.array(z.string()).optional(),
});

export const exportArchivedIssuesResponseSchema = exportArchivedIssuesTaskProgressResponseSchema;

export const exportArchivedIssuesErrorSchema = z.unknown();

export const getIssueSecuritySchemesResponseSchema = securitySchemesSchema;

export const getIssueSecuritySchemesErrorSchema = z.unknown();

export const createIssueSecuritySchemeResponseSchema = securitySchemeIdSchema;

export const createIssueSecuritySchemeErrorSchema = errorCollectionSchema;

export const getSecurityLevelsDataSchema = z.object({
  query: z
    .object({
      id: z.array(z.string()).optional(),
      maxResults: z.string().optional(),
      onlyDefault: z.boolean().optional(),
      schemeId: z.array(z.string()).optional(),
      startAt: z.string().optional(),
    })
    .optional(),
});

export const pageBeanSecurityLevelSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(securityLevelSchema).optional(),
});

export const getSecurityLevelsErrorSchema = errorCollectionSchema;

export const setDefaultLevelsDataSchema = z.object({
  body: setDefaultLevelsRequestSchema,
});

export const setDefaultLevelsResponseSchema = z.unknown();

export const setDefaultLevelsErrorSchema = errorCollectionSchema;

export const getSecurityLevelMembersDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
      id: z.array(z.string()).optional(),
      levelId: z.array(z.string()).optional(),
      maxResults: z.string().optional(),
      schemeId: z.array(z.string()).optional(),
      startAt: z.string().optional(),
    })
    .optional(),
});

export const pageBeanSecurityLevelMemberSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(securityLevelMemberSchema).optional(),
});

export const getSecurityLevelMembersErrorSchema = z.unknown();

export const searchProjectsUsingSecuritySchemesDataSchema = z.object({
  query: z
    .object({
      issueSecuritySchemeId: z.array(z.string()).optional(),
      maxResults: z.string().optional(),
      projectId: z.array(z.string()).optional(),
      startAt: z.string().optional(),
    })
    .optional(),
});

export const searchProjectsUsingSecuritySchemesResponseSchema = pageBeanIssueSecuritySchemeToProjectMappingSchema;

export const searchProjectsUsingSecuritySchemesErrorSchema = errorCollectionSchema;

export const associateSecuritySchemeWithProjectDetailsSchema = z.object({
  oldToNewSecurityLevelMappings: z.array(oldToNewSecurityLevelMappingsBeanSchema).optional(),
  projectId: z.string(),
  schemeId: z.string(),
});

export const searchSecuritySchemesDataSchema = z.object({
  query: z
    .object({
      id: z.array(z.string()).optional(),
      maxResults: z.string().optional(),
      projectId: z.array(z.string()).optional(),
      startAt: z.string().optional(),
    })
    .optional(),
});

export const pageBeanSecuritySchemeWithProjectsSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(securitySchemeWithProjectsSchema).optional(),
});

export const searchSecuritySchemesErrorSchema = z.unknown();

export const getIssueSecuritySchemeDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const getIssueSecuritySchemeResponseSchema = securitySchemeSchema;

export const getIssueSecuritySchemeErrorSchema = z.unknown();

export const updateIssueSecuritySchemeDataSchema = z.object({
  body: updateIssueSecuritySchemeRequestBeanSchema,
  path: z.object({
    id: z.string(),
  }),
});

export const updateIssueSecuritySchemeResponseSchema = z.unknown();

export const updateIssueSecuritySchemeErrorSchema = errorCollectionSchema;

export const getIssueSecurityLevelMembersDataSchema = z.object({
  path: z.object({
    issueSecuritySchemeId: z.number(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
      issueSecurityLevelId: z.array(z.string()).optional(),
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const pageBeanIssueSecurityLevelMemberSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(issueSecurityLevelMemberSchema).optional(),
});

export const getIssueSecurityLevelMembersErrorSchema = z.unknown();

export const deleteSecuritySchemeDataSchema = z.object({
  path: z.object({
    schemeId: z.string(),
  }),
});

export const deleteSecuritySchemeResponseSchema = z.unknown();

export const deleteSecuritySchemeErrorSchema = errorCollectionSchema;

export const addSecurityLevelResponseSchema = z.unknown();

export const addSecurityLevelErrorSchema = errorCollectionSchema;

export const removeLevelDataSchema = z.object({
  path: z.object({
    levelId: z.string(),
    schemeId: z.string(),
  }),
  query: z
    .object({
      replaceWith: z.string().optional(),
    })
    .optional(),
});

export const updateSecurityLevelDataSchema = z.object({
  body: updateIssueSecurityLevelDetailsSchema,
  path: z.object({
    levelId: z.string(),
    schemeId: z.string(),
  }),
});

export const updateSecurityLevelResponseSchema = z.unknown();

export const updateSecurityLevelErrorSchema = errorCollectionSchema;

export const addSecurityLevelMembersDataSchema = z.object({
  body: securitySchemeMembersRequestSchema,
  path: z.object({
    levelId: z.string(),
    schemeId: z.string(),
  }),
});

export const addSecurityLevelMembersResponseSchema = z.unknown();

export const addSecurityLevelMembersErrorSchema = errorCollectionSchema;

export const removeMemberFromSecurityLevelDataSchema = z.object({
  path: z.object({
    levelId: z.string(),
    memberId: z.string(),
    schemeId: z.string(),
  }),
});

export const removeMemberFromSecurityLevelResponseSchema = z.unknown();

export const removeMemberFromSecurityLevelErrorSchema = errorCollectionSchema;

export const getIssueAllTypesResponseSchema = z.array(issueTypeDetailsSchema);

export const getIssueAllTypesErrorSchema = z.unknown();

export const createIssueTypeDataSchema = z.object({
  body: issueTypeCreateBeanSchema,
});

export const createIssueTypeResponseSchema = issueTypeDetailsSchema;

export const createIssueTypeErrorSchema = z.unknown();

export const getIssueTypesForProjectDataSchema = z.object({
  query: z.object({
    level: z.number().optional(),
    projectId: z.number(),
  }),
});

export const getIssueTypesForProjectResponseSchema = z.array(issueTypeDetailsSchema);

export const getIssueTypesForProjectErrorSchema = z.unknown();

export const deleteIssueTypeDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      alternativeIssueTypeId: z.string().optional(),
    })
    .optional(),
});

export const deleteIssueTypeResponseSchema = z.any();

export const deleteIssueTypeErrorSchema = z.unknown();

export const getIssueTypeDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getIssueTypeResponseSchema = issueTypeDetailsSchema;

export const getIssueTypeErrorSchema = z.unknown();

export const updateIssueTypeDataSchema = z.object({
  body: issueTypeUpdateBeanSchema,
  path: z.object({
    id: z.string(),
  }),
});

export const updateIssueTypeResponseSchema = issueTypeDetailsSchema;

export const updateIssueTypeErrorSchema = z.unknown();

export const getAlternativeIssueTypesDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getAlternativeIssueTypesResponseSchema = z.array(issueTypeDetailsSchema);

export const getAlternativeIssueTypesErrorSchema = z.unknown();

export const createIssueTypeAvatarDataSchema = z.object({
  body: z.string().optional(),
  path: z.object({
    id: z.string(),
  }),
  query: z.object({
    size: z.number(),
    x: z.number().optional(),
    y: z.number().optional(),
  }),
});

export const createIssueTypeAvatarResponseSchema = avatarSchema;

export const createIssueTypeAvatarErrorSchema = z.unknown();

export const getIssueTypePropertyKeysDataSchema = z.object({
  path: z.object({
    issueTypeId: z.string(),
  }),
});

export const getIssueTypePropertyKeysResponseSchema = propertyKeysSchema;

export const getIssueTypePropertyKeysErrorSchema = z.unknown();

export const deleteIssueTypePropertyDataSchema = z.object({
  path: z.object({
    issueTypeId: z.string(),
    propertyKey: z.string(),
  }),
});

export const deleteIssueTypePropertyResponseSchema = z.any();

export const deleteIssueTypePropertyErrorSchema = z.unknown();

export const getIssueTypePropertyDataSchema = z.object({
  path: z.object({
    issueTypeId: z.string(),
    propertyKey: z.string(),
  }),
});

export const getIssueTypePropertyResponseSchema = entityPropertySchema;

export const getIssueTypePropertyErrorSchema = z.unknown();

export const setIssueTypePropertyDataSchema = z.object({
  body: z.string().optional(),
  path: z.object({
    issueTypeId: z.string(),
    propertyKey: z.string(),
  }),
});

export const setIssueTypePropertyResponseSchema = z.unknown();

export const setIssueTypePropertyErrorSchema = z.unknown();

export const getAllIssueTypeSchemesDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
      id: z.array(z.number()).optional(),
      maxResults: z.number().optional(),
      orderBy: z
        .union([
          z.literal('name'),
          z.literal('-name'),
          z.literal('+name'),
          z.literal('id'),
          z.literal('-id'),
          z.literal('+id'),
        ])
        .optional(),
      queryString: z.string().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getAllIssueTypeSchemesResponseSchema = pageBeanIssueTypeSchemeSchema;

export const getAllIssueTypeSchemesErrorSchema = z.unknown();

export const createIssueTypeSchemeDataSchema = z.object({
  body: issueTypeSchemeDetailsSchema,
});

export const createIssueTypeSchemeResponseSchema = issueTypeSchemeIDSchema;

export const createIssueTypeSchemeErrorSchema = z.unknown();

export const getIssueTypeSchemesMappingDataSchema = z.object({
  query: z
    .object({
      issueTypeSchemeId: z.array(z.number()).optional(),
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getIssueTypeSchemesMappingResponseSchema = pageBeanIssueTypeSchemeMappingSchema;

export const getIssueTypeSchemesMappingErrorSchema = z.unknown();

export const getIssueTypeSchemeForProjectsDataSchema = z.object({
  query: z.object({
    maxResults: z.number().optional(),
    projectId: z.array(z.number()),
    startAt: z.number().optional(),
  }),
});

export const getIssueTypeSchemeForProjectsResponseSchema = pageBeanIssueTypeSchemeProjectsSchema;

export const getIssueTypeSchemeForProjectsErrorSchema = z.unknown();

export const assignIssueTypeSchemeToProjectDataSchema = z.object({
  body: issueTypeSchemeProjectAssociationSchema,
});

export const assignIssueTypeSchemeToProjectResponseSchema = z.unknown();

export const assignIssueTypeSchemeToProjectErrorSchema = z.unknown();

export const deleteIssueTypeSchemeDataSchema = z.object({
  path: z.object({
    issueTypeSchemeId: z.number(),
  }),
});

export const deleteIssueTypeSchemeResponseSchema = z.unknown();

export const deleteIssueTypeSchemeErrorSchema = z.unknown();

export const updateIssueTypeSchemeDataSchema = z.object({
  body: issueTypeSchemeUpdateDetailsSchema,
  path: z.object({
    issueTypeSchemeId: z.number(),
  }),
});

export const updateIssueTypeSchemeResponseSchema = z.unknown();

export const updateIssueTypeSchemeErrorSchema = z.unknown();

export const addIssueTypesToIssueTypeSchemeDataSchema = z.object({
  body: issueTypeIdsSchema,
  path: z.object({
    issueTypeSchemeId: z.number(),
  }),
});

export const addIssueTypesToIssueTypeSchemeResponseSchema = z.unknown();

export const addIssueTypesToIssueTypeSchemeErrorSchema = z.unknown();

export const reorderIssueTypesInIssueTypeSchemeDataSchema = z.object({
  body: orderOfIssueTypesSchema,
  path: z.object({
    issueTypeSchemeId: z.number(),
  }),
});

export const reorderIssueTypesInIssueTypeSchemeResponseSchema = z.unknown();

export const reorderIssueTypesInIssueTypeSchemeErrorSchema = z.unknown();

export const removeIssueTypeFromIssueTypeSchemeDataSchema = z.object({
  path: z.object({
    issueTypeId: z.number(),
    issueTypeSchemeId: z.number(),
  }),
});

export const removeIssueTypeFromIssueTypeSchemeResponseSchema = z.unknown();

export const removeIssueTypeFromIssueTypeSchemeErrorSchema = z.unknown();

export const getIssueTypeScreenSchemesDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
      id: z.array(z.number()).optional(),
      maxResults: z.number().optional(),
      orderBy: z
        .union([
          z.literal('name'),
          z.literal('-name'),
          z.literal('+name'),
          z.literal('id'),
          z.literal('-id'),
          z.literal('+id'),
        ])
        .optional(),
      queryString: z.string().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getIssueTypeScreenSchemesResponseSchema = pageBeanIssueTypeScreenSchemeSchema;

export const getIssueTypeScreenSchemesErrorSchema = z.unknown();

export const issueTypeScreenSchemeDetailsSchema = z.object({
  description: z.string().optional(),
  issueTypeMappings: z.array(issueTypeScreenSchemeMappingSchema),
  name: z.string(),
});

export const createIssueTypeScreenSchemeResponseSchema = issueTypeScreenSchemeIdSchema;

export const createIssueTypeScreenSchemeErrorSchema = z.unknown();

export const getIssueTypeScreenSchemeMappingsDataSchema = z.object({
  query: z
    .object({
      issueTypeScreenSchemeId: z.array(z.number()).optional(),
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getIssueTypeScreenSchemeMappingsResponseSchema = pageBeanIssueTypeScreenSchemeItemSchema;

export const getIssueTypeScreenSchemeMappingsErrorSchema = z.unknown();

export const getIssueTypeScreenSchemeProjectAssociationsDataSchema = z.object({
  query: z.object({
    maxResults: z.number().optional(),
    projectId: z.array(z.number()),
    startAt: z.number().optional(),
  }),
});

export const getIssueTypeScreenSchemeProjectAssociationsResponseSchema = pageBeanIssueTypeScreenSchemesProjectsSchema;

export const getIssueTypeScreenSchemeProjectAssociationsErrorSchema = z.unknown();

export const assignIssueTypeScreenSchemeToProjectDataSchema = z.object({
  body: issueTypeScreenSchemeProjectAssociationSchema,
});

export const assignIssueTypeScreenSchemeToProjectResponseSchema = z.unknown();

export const assignIssueTypeScreenSchemeToProjectErrorSchema = z.unknown();

export const deleteIssueTypeScreenSchemeDataSchema = z.object({
  path: z.object({
    issueTypeScreenSchemeId: z.string(),
  }),
});

export const deleteIssueTypeScreenSchemeResponseSchema = z.unknown();

export const deleteIssueTypeScreenSchemeErrorSchema = z.unknown();

export const updateIssueTypeScreenSchemeDataSchema = z.object({
  body: issueTypeScreenSchemeUpdateDetailsSchema,
  path: z.object({
    issueTypeScreenSchemeId: z.string(),
  }),
});

export const updateIssueTypeScreenSchemeResponseSchema = z.unknown();

export const updateIssueTypeScreenSchemeErrorSchema = z.unknown();

export const appendMappingsForIssueTypeScreenSchemeDataSchema = z.object({
  body: issueTypeScreenSchemeMappingDetailsSchema,
  path: z.object({
    issueTypeScreenSchemeId: z.string(),
  }),
});

export const appendMappingsForIssueTypeScreenSchemeResponseSchema = z.unknown();

export const appendMappingsForIssueTypeScreenSchemeErrorSchema = z.unknown();

export const updateDefaultScreenSchemeDataSchema = z.object({
  body: updateDefaultScreenSchemeSchema,
  path: z.object({
    issueTypeScreenSchemeId: z.string(),
  }),
});

export const updateDefaultScreenSchemeResponseSchema = z.unknown();

export const updateDefaultScreenSchemeErrorSchema = z.unknown();

export const removeMappingsFromIssueTypeScreenSchemeDataSchema = z.object({
  body: issueTypeIdsSchema,
  path: z.object({
    issueTypeScreenSchemeId: z.string(),
  }),
});

export const removeMappingsFromIssueTypeScreenSchemeResponseSchema = z.unknown();

export const removeMappingsFromIssueTypeScreenSchemeErrorSchema = z.unknown();

export const getProjectsForIssueTypeScreenSchemeDataSchema = z.object({
  path: z.object({
    issueTypeScreenSchemeId: z.number(),
  }),
  query: z
    .object({
      maxResults: z.number().optional(),
      query: z.string().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const pageBeanProjectDetailsSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(projectDetailsSchema).optional(),
});

export const getProjectsForIssueTypeScreenSchemeErrorSchema = z.unknown();

export const getAutoCompleteResponseSchema = jQLReferenceDataSchema;

export const getAutoCompleteErrorSchema = z.unknown();

export const getAutoCompletePostDataSchema = z.object({
  body: searchAutoCompleteFilterSchema,
});

export const getAutoCompletePostResponseSchema = jQLReferenceDataSchema;

export const getAutoCompletePostErrorSchema = z.unknown();

export const getFieldAutoCompleteForQueryStringDataSchema = z.object({
  query: z
    .object({
      fieldName: z.string().optional(),
      fieldValue: z.string().optional(),
      predicateName: z.string().optional(),
      predicateValue: z.string().optional(),
    })
    .optional(),
});

export const getFieldAutoCompleteForQueryStringResponseSchema = autoCompleteSuggestionsSchema;

export const getFieldAutoCompleteForQueryStringErrorSchema = z.unknown();

export const getPrecomputationsDataSchema = z.object({
  query: z
    .object({
      functionKey: z.array(z.string()).optional(),
      maxResults: z.number().optional(),
      orderBy: z.string().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getPrecomputationsResponseSchema = pageBeanJqlFunctionPrecomputationBeanSchema;

export const getPrecomputationsErrorSchema = z.unknown();

export const updatePrecomputationsDataSchema = z.object({
  body: jqlFunctionPrecomputationUpdateRequestBeanSchema,
});

export const updatePrecomputationsResponseSchema = z.unknown();

export const updatePrecomputationsErrorSchema = z.unknown();

export const matchIssuesDataSchema = z.object({
  body: issuesAndJQLQueriesSchema,
});

export const issueMatchesSchema = z.object({
  matches: z.array(issueMatchesForJQLSchema),
});

export const matchIssuesErrorSchema = z.unknown();

export const parseJqlQueriesDataSchema = z.object({
  body: jqlQueriesToParseSchema,
  query: z.object({
    validation: z.union([z.literal('strict'), z.literal('warn'), z.literal('none')]),
  }),
});

export const parseJqlQueriesErrorSchema = z.union([errorCollectionSchema, z.unknown()]);

export const migrateQueriesDataSchema = z.object({
  body: jQLPersonalDataMigrationRequestSchema,
});

export const convertedJQLQueriesSchema = z.object({
  queriesWithUnknownUsers: z.array(jQLQueryWithUnknownUsersSchema).optional(),
  queryStrings: z.array(z.string()).optional(),
});

export const migrateQueriesErrorSchema = z.string();

export const jqlQueriesToSanitizeSchema = z.object({
  queries: z.array(jqlQueryToSanitizeSchema),
});

export const sanitizedJqlQueriesSchema = z.object({
  queries: z.array(sanitizedJqlQuerySchema).optional(),
});

export const sanitiseJqlQueriesErrorSchema = errorCollectionSchema;

export const getAllLabelsDataSchema = z.object({
  query: z
    .object({
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getAllLabelsResponseSchema = pageBeanStringSchema;

export const getAllLabelsErrorSchema = z.unknown();

export const getApproximateLicenseCountResponseSchema = licenseMetricSchema;

export const getApproximateLicenseCountErrorSchema = errorCollectionsSchema;

export const getApproximateApplicationLicenseCountDataSchema = z.object({
  path: z.object({
    applicationKey: z.union([
      z.literal('jira-core'),
      z.literal('jira-product-discovery'),
      z.literal('jira-software'),
      z.literal('jira-servicedesk'),
    ]),
  }),
});

export const getApproximateApplicationLicenseCountResponseSchema = licenseMetricSchema;

export const getApproximateApplicationLicenseCountErrorSchema = errorCollectionSchema;

export const getMyPermissionsDataSchema = z.object({
  query: z
    .object({
      commentId: z.string().optional(),
      issueId: z.string().optional(),
      issueKey: z.string().optional(),
      permissions: z.string().optional(),
      projectConfigurationUuid: z.string().optional(),
      projectId: z.string().optional(),
      projectKey: z.string().optional(),
      projectUuid: z.string().optional(),
    })
    .optional(),
});

export const permissionsSchema = z.object({
  permissions: z.record(userPermissionSchema).optional(),
});

export const getMyPermissionsErrorSchema = errorCollectionSchema;

export const removePreferenceDataSchema = z.object({
  query: z.object({
    key: z.string(),
  }),
});

export const removePreferenceResponseSchema = z.any();

export const removePreferenceErrorSchema = z.unknown();

export const getPreferenceDataSchema = z.object({
  query: z.object({
    key: z.string(),
  }),
});

export const getPreferenceResponseSchema = z.string();

export const getPreferenceErrorSchema = z.unknown();

export const setPreferenceDataSchema = z.object({
  body: z.string(),
  query: z.object({
    key: z.string(),
  }),
});

export const setPreferenceResponseSchema = z.unknown();

export const setPreferenceErrorSchema = z.unknown();

export const deleteLocaleResponseSchema = z.unknown();

export const deleteLocaleErrorSchema = z.unknown();

export const getLocaleResponseSchema = localeSchema;

export const getLocaleErrorSchema = z.unknown();

export const setLocaleDataSchema = z.object({
  body: localeSchema,
});

export const setLocaleResponseSchema = z.unknown();

export const setLocaleErrorSchema = z.unknown();

export const getCurrentUserDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const getCurrentUserResponseSchema = userSchema;

export const getCurrentUserErrorSchema = z.unknown();

export const getNotificationSchemesDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
      id: z.array(z.string()).optional(),
      maxResults: z.string().optional(),
      onlyDefault: z.boolean().optional(),
      projectId: z.array(z.string()).optional(),
      startAt: z.string().optional(),
    })
    .optional(),
});

export const getNotificationSchemesErrorSchema = z.unknown();

export const createNotificationSchemeResponseSchema = notificationSchemeIdSchema;

export const createNotificationSchemeErrorSchema = errorCollectionSchema;

export const getNotificationSchemeToProjectMappingsDataSchema = z.object({
  query: z
    .object({
      maxResults: z.string().optional(),
      notificationSchemeId: z.array(z.string()).optional(),
      projectId: z.array(z.string()).optional(),
      startAt: z.string().optional(),
    })
    .optional(),
});

export const getNotificationSchemeToProjectMappingsResponseSchema =
  pageBeanNotificationSchemeAndProjectMappingJsonBeanSchema;

export const getNotificationSchemeToProjectMappingsErrorSchema = errorCollectionSchema;

export const getNotificationSchemeDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const getNotificationSchemeErrorSchema = z.unknown();

export const updateNotificationSchemeDataSchema = z.object({
  body: updateNotificationSchemeDetailsSchema,
  path: z.object({
    id: z.string(),
  }),
});

export const updateNotificationSchemeResponseSchema = z.unknown();

export const updateNotificationSchemeErrorSchema = errorCollectionSchema;

export const addNotificationsResponseSchema = z.unknown();

export const addNotificationsErrorSchema = errorCollectionSchema;

export const deleteNotificationSchemeDataSchema = z.object({
  path: z.object({
    notificationSchemeId: z.string(),
  }),
});

export const deleteNotificationSchemeResponseSchema = z.unknown();

export const deleteNotificationSchemeErrorSchema = errorCollectionSchema;

export const removeNotificationFromNotificationSchemeDataSchema = z.object({
  path: z.object({
    notificationId: z.string(),
    notificationSchemeId: z.string(),
  }),
});

export const removeNotificationFromNotificationSchemeResponseSchema = z.unknown();

export const removeNotificationFromNotificationSchemeErrorSchema = errorCollectionSchema;

export const getAllPermissionsResponseSchema = permissionsSchema;

export const getAllPermissionsErrorSchema = z.unknown();

export const bulkPermissionsRequestBeanSchema = z.object({
  accountId: z.string().optional(),
  globalPermissions: z.array(z.string()).optional(),
  projectPermissions: z.array(bulkProjectPermissionsSchema).optional(),
});

export const bulkPermissionGrantsSchema = z.object({
  globalPermissions: z.array(z.string()),
  projectPermissions: z.array(bulkProjectPermissionGrantsSchema),
});

export const getBulkPermissionsErrorSchema = errorCollectionSchema;

export const getPermittedProjectsDataSchema = z.object({
  body: permissionsKeysBeanSchema,
});

export const permittedProjectsSchema = z.object({
  projects: z.array(projectIdentifierBeanSchema).optional(),
});

export const getPermittedProjectsErrorSchema = z.unknown();

export const getAllPermissionSchemesDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const getAllPermissionSchemesResponseSchema = permissionSchemesSchema;

export const getAllPermissionSchemesErrorSchema = z.unknown();

export const createPermissionSchemeDataSchema = z.object({
  body: permissionSchemeSchema,
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const createPermissionSchemeResponseSchema = permissionSchemeSchema;

export const createPermissionSchemeErrorSchema = z.unknown();

export const deletePermissionSchemeDataSchema = z.object({
  path: z.object({
    schemeId: z.number(),
  }),
});

export const deletePermissionSchemeResponseSchema = z.any();

export const deletePermissionSchemeErrorSchema = z.unknown();

export const getPermissionSchemeDataSchema = z.object({
  path: z.object({
    schemeId: z.number(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const getPermissionSchemeResponseSchema = permissionSchemeSchema;

export const getPermissionSchemeErrorSchema = z.unknown();

export const updatePermissionSchemeDataSchema = z.object({
  body: permissionSchemeSchema,
  path: z.object({
    schemeId: z.number(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const updatePermissionSchemeResponseSchema = permissionSchemeSchema;

export const updatePermissionSchemeErrorSchema = z.unknown();

export const getPermissionSchemeGrantsDataSchema = z.object({
  path: z.object({
    schemeId: z.number(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const getPermissionSchemeGrantsResponseSchema = permissionGrantsSchema;

export const getPermissionSchemeGrantsErrorSchema = z.unknown();

export const createPermissionGrantDataSchema = z.object({
  body: permissionGrantSchema,
  path: z.object({
    schemeId: z.number(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const createPermissionGrantResponseSchema = permissionGrantSchema;

export const createPermissionGrantErrorSchema = z.unknown();

export const deletePermissionSchemeEntityDataSchema = z.object({
  path: z.object({
    permissionId: z.number(),
    schemeId: z.number(),
  }),
});

export const deletePermissionSchemeEntityResponseSchema = z.any();

export const deletePermissionSchemeEntityErrorSchema = z.unknown();

export const getPermissionSchemeGrantDataSchema = z.object({
  path: z.object({
    permissionId: z.number(),
    schemeId: z.number(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const getPermissionSchemeGrantResponseSchema = permissionGrantSchema;

export const getPermissionSchemeGrantErrorSchema = z.unknown();

export const getPrioritiesResponseSchema = z.array(prioritySchema);

export const getPrioritiesErrorSchema = z.unknown();

export const createPriorityDataSchema = z.object({
  body: createPriorityDetailsSchema,
});

export const createPriorityResponseSchema = priorityIdSchema;

export const createPriorityErrorSchema = errorCollectionSchema;

export const setDefaultPriorityDataSchema = z.object({
  body: setDefaultPriorityRequestSchema,
});

export const setDefaultPriorityResponseSchema = z.unknown();

export const setDefaultPriorityErrorSchema = errorCollectionSchema;

export const movePrioritiesDataSchema = z.object({
  body: reorderIssuePrioritiesSchema,
});

export const movePrioritiesResponseSchema = z.unknown();

export const movePrioritiesErrorSchema = errorCollectionSchema;

export const searchPrioritiesDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
      id: z.array(z.string()).optional(),
      maxResults: z.string().optional(),
      onlyDefault: z.boolean().optional(),
      priorityName: z.string().optional(),
      projectId: z.array(z.string()).optional(),
      startAt: z.string().optional(),
    })
    .optional(),
});

export const searchPrioritiesResponseSchema = pageBeanPrioritySchema;

export const searchPrioritiesErrorSchema = errorCollectionSchema;

export const deletePriorityDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getPriorityDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getPriorityResponseSchema = prioritySchema;

export const getPriorityErrorSchema = z.unknown();

export const updatePriorityDataSchema = z.object({
  body: updatePriorityDetailsSchema,
  path: z.object({
    id: z.string(),
  }),
});

export const updatePriorityResponseSchema = z.unknown();

export const updatePriorityErrorSchema = errorCollectionSchema;

export const getPrioritySchemesDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
      maxResults: z.string().optional(),
      onlyDefault: z.boolean().optional(),
      orderBy: z.union([z.literal('name'), z.literal('+name'), z.literal('-name')]).optional(),
      priorityId: z.array(z.number()).optional(),
      schemeId: z.array(z.number()).optional(),
      schemeName: z.string().optional(),
      startAt: z.string().optional(),
    })
    .optional(),
});

export const getPrioritySchemesErrorSchema = z.unknown();

export const createPrioritySchemeDetailsSchema = z.object({
  defaultPriorityId: z.number(),
  description: z.string().optional(),
  mappings: priorityMappingSchema.optional(),
  name: z.string(),
  priorityIds: z.array(z.number()),
  projectIds: z.array(z.number()).optional(),
});

export const prioritySchemeIdSchema = z.object({
  id: z.string().optional(),
  task: taskProgressBeanJsonNodeSchema.optional(),
});

export const createPrioritySchemeErrorSchema = z.unknown();

export const suggestedPrioritiesForMappingsDataSchema = z.object({
  body: suggestedMappingsRequestBeanSchema,
});

export const suggestedPrioritiesForMappingsResponseSchema = pageBeanPriorityWithSequenceSchema;

export const suggestedPrioritiesForMappingsErrorSchema = z.unknown();

export const getAvailablePrioritiesByPrioritySchemeDataSchema = z.object({
  query: z.object({
    exclude: z.array(z.string()).optional(),
    maxResults: z.string().optional(),
    query: z.string().optional(),
    schemeId: z.string(),
    startAt: z.string().optional(),
  }),
});

export const getAvailablePrioritiesByPrioritySchemeResponseSchema = pageBeanPriorityWithSequenceSchema;

export const getAvailablePrioritiesByPrioritySchemeErrorSchema = z.unknown();

export const deletePrioritySchemeDataSchema = z.object({
  path: z.object({
    schemeId: z.number(),
  }),
});

export const deletePrioritySchemeResponseSchema = z.unknown();

export const deletePrioritySchemeErrorSchema = z.unknown();

export const updatePrioritySchemeRequestBeanSchema = z.object({
  defaultPriorityId: z.number().optional(),
  description: z.string().optional(),
  mappings: priorityMappingSchema.optional(),
  name: z.string().optional(),
  priorities: updatePrioritiesInSchemeRequestBeanSchema.optional(),
  projects: updateProjectsInSchemeRequestBeanSchema.optional(),
});

export const updatePrioritySchemeErrorSchema = z.unknown();

export const getPrioritiesByPrioritySchemeDataSchema = z.object({
  path: z.object({
    schemeId: z.string(),
  }),
  query: z
    .object({
      maxResults: z.string().optional(),
      startAt: z.string().optional(),
    })
    .optional(),
});

export const getPrioritiesByPrioritySchemeResponseSchema = pageBeanPriorityWithSequenceSchema;

export const getPrioritiesByPrioritySchemeErrorSchema = z.unknown();

export const getProjectsByPrioritySchemeDataSchema = z.object({
  path: z.object({
    schemeId: z.string(),
  }),
  query: z
    .object({
      maxResults: z.string().optional(),
      projectId: z.array(z.number()).optional(),
      query: z.string().optional(),
      startAt: z.string().optional(),
    })
    .optional(),
});

export const getProjectsByPrioritySchemeErrorSchema = z.unknown();

export const getAllProjectsDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
      properties: z.array(z.string()).optional(),
      recent: z.number().optional(),
    })
    .optional(),
});

export const getAllProjectsErrorSchema = z.unknown();

export const createProjectDataSchema = z.object({
  body: createProjectDetailsSchema,
});

export const createProjectResponseSchema = projectIdentifiersSchema;

export const createProjectErrorSchema = z.unknown();

export const getRecentDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
      properties: z.array(stringListSchema).optional(),
    })
    .optional(),
});

export const getRecentErrorSchema = z.unknown();

export const searchProjectsDataSchema = z.object({
  query: z
    .object({
      action: z.union([z.literal('view'), z.literal('browse'), z.literal('edit'), z.literal('create')]).optional(),
      categoryId: z.number().optional(),
      expand: z.string().optional(),
      id: z.array(z.number()).optional(),
      keys: z.array(z.string()).optional(),
      maxResults: z.number().optional(),
      orderBy: z
        .union([
          z.literal('category'),
          z.literal('-category'),
          z.literal('+category'),
          z.literal('key'),
          z.literal('-key'),
          z.literal('+key'),
          z.literal('name'),
          z.literal('-name'),
          z.literal('+name'),
          z.literal('owner'),
          z.literal('-owner'),
          z.literal('+owner'),
          z.literal('issueCount'),
          z.literal('-issueCount'),
          z.literal('+issueCount'),
          z.literal('lastIssueUpdatedDate'),
          z.literal('-lastIssueUpdatedDate'),
          z.literal('+lastIssueUpdatedDate'),
          z.literal('archivedDate'),
          z.literal('+archivedDate'),
          z.literal('-archivedDate'),
          z.literal('deletedDate'),
          z.literal('+deletedDate'),
          z.literal('-deletedDate'),
        ])
        .optional(),
      properties: z.array(stringListSchema).optional(),
      propertyQuery: z.string().optional(),
      query: z.string().optional(),
      startAt: z.number().optional(),
      status: z.array(z.union([z.literal('live'), z.literal('archived'), z.literal('deleted')])).optional(),
      typeKey: z.string().optional(),
    })
    .optional(),
});

export const searchProjectsErrorSchema = z.unknown();

export const getAllProjectTypesResponseSchema = z.array(projectTypeSchema);

export const getAllProjectTypesErrorSchema = z.unknown();

export const getAllAccessibleProjectTypesResponseSchema = z.array(projectTypeSchema);

export const getAllAccessibleProjectTypesErrorSchema = z.unknown();

export const getProjectTypeByKeyDataSchema = z.object({
  path: z.object({
    projectTypeKey: z.union([
      z.literal('software'),
      z.literal('service_desk'),
      z.literal('business'),
      z.literal('product_discovery'),
    ]),
  }),
});

export const getProjectTypeByKeyResponseSchema = projectTypeSchema;

export const getProjectTypeByKeyErrorSchema = z.unknown();

export const getAccessibleProjectTypeByKeyDataSchema = z.object({
  path: z.object({
    projectTypeKey: z.union([
      z.literal('software'),
      z.literal('service_desk'),
      z.literal('business'),
      z.literal('product_discovery'),
    ]),
  }),
});

export const getAccessibleProjectTypeByKeyResponseSchema = projectTypeSchema;

export const getAccessibleProjectTypeByKeyErrorSchema = z.unknown();

export const deleteProjectDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
  }),
  query: z
    .object({
      enableUndo: z.boolean().optional(),
    })
    .optional(),
});

export const deleteProjectResponseSchema = z.any();

export const deleteProjectErrorSchema = z.unknown();

export const getProjectDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
      properties: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getProjectErrorSchema = z.unknown();

export const updateProjectDataSchema = z.object({
  body: updateProjectDetailsSchema,
  path: z.object({
    projectIdOrKey: z.string(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const updateProjectErrorSchema = z.unknown();

export const archiveProjectDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
  }),
});

export const archiveProjectResponseSchema = z.unknown();

export const archiveProjectErrorSchema = z.unknown();

export const updateProjectAvatarDataSchema = z.object({
  body: avatarSchema,
  path: z.object({
    projectIdOrKey: z.string(),
  }),
});

export const updateProjectAvatarResponseSchema = z.unknown();

export const updateProjectAvatarErrorSchema = z.unknown();

export const deleteProjectAvatarDataSchema = z.object({
  path: z.object({
    id: z.number(),
    projectIdOrKey: z.string(),
  }),
});

export const deleteProjectAvatarResponseSchema = z.any();

export const deleteProjectAvatarErrorSchema = z.unknown();

export const createProjectAvatarDataSchema = z.object({
  body: z.string().optional(),
  path: z.object({
    projectIdOrKey: z.string(),
  }),
  query: z
    .object({
      size: z.number().optional(),
      x: z.number().optional(),
      y: z.number().optional(),
    })
    .optional(),
});

export const createProjectAvatarResponseSchema = avatarSchema;

export const createProjectAvatarErrorSchema = z.unknown();

export const getAllProjectAvatarsDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
  }),
});

export const getAllProjectAvatarsResponseSchema = projectAvatarsSchema;

export const getAllProjectAvatarsErrorSchema = z.unknown();

export const removeDefaultProjectClassificationDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
  }),
});

export const removeDefaultProjectClassificationResponseSchema = z.unknown();

export const removeDefaultProjectClassificationErrorSchema = z.unknown();

export const getDefaultProjectClassificationDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
  }),
});

export const getDefaultProjectClassificationResponseSchema = z.unknown();

export const getDefaultProjectClassificationErrorSchema = z.unknown();

export const updateDefaultProjectClassificationDataSchema = z.object({
  body: updateDefaultProjectClassificationBeanSchema,
  path: z.object({
    projectIdOrKey: z.string(),
  }),
});

export const updateDefaultProjectClassificationResponseSchema = z.unknown();

export const updateDefaultProjectClassificationErrorSchema = z.unknown();

export const getProjectComponentsPaginatedDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
  }),
  query: z
    .object({
      componentSource: z.union([z.literal('jira'), z.literal('compass'), z.literal('auto')]).optional(),
      maxResults: z.number().optional(),
      orderBy: z
        .union([
          z.literal('description'),
          z.literal('-description'),
          z.literal('+description'),
          z.literal('issueCount'),
          z.literal('-issueCount'),
          z.literal('+issueCount'),
          z.literal('lead'),
          z.literal('-lead'),
          z.literal('+lead'),
          z.literal('name'),
          z.literal('-name'),
          z.literal('+name'),
        ])
        .optional(),
      query: z.string().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getProjectComponentsPaginatedErrorSchema = z.unknown();

export const getProjectComponentsDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
  }),
  query: z
    .object({
      componentSource: z.union([z.literal('jira'), z.literal('compass'), z.literal('auto')]).optional(),
    })
    .optional(),
});

export const getProjectComponentsResponseSchema = z.array(projectComponentSchema);

export const getProjectComponentsErrorSchema = z.unknown();

export const deleteProjectAsynchronouslyDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
  }),
});

export const getFeaturesForProjectDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
  }),
});

export const containerForProjectFeaturesSchema = z.object({
  features: z.array(projectFeatureSchema).optional(),
});

export const getFeaturesForProjectErrorSchema = z.unknown();

export const toggleFeatureForProjectDataSchema = z.object({
  body: projectFeatureStateSchema,
  path: z.object({
    featureKey: z.string(),
    projectIdOrKey: z.string(),
  }),
});

export const toggleFeatureForProjectResponseSchema = containerForProjectFeaturesSchema;

export const toggleFeatureForProjectErrorSchema = z.unknown();

export const getProjectPropertyKeysDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
  }),
});

export const getProjectPropertyKeysResponseSchema = propertyKeysSchema;

export const getProjectPropertyKeysErrorSchema = z.unknown();

export const deleteProjectPropertyDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
    propertyKey: z.string(),
  }),
});

export const deleteProjectPropertyResponseSchema = z.any();

export const deleteProjectPropertyErrorSchema = z.unknown();

export const getProjectPropertyDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
    propertyKey: z.string(),
  }),
});

export const getProjectPropertyResponseSchema = entityPropertySchema;

export const getProjectPropertyErrorSchema = z.unknown();

export const setProjectPropertyDataSchema = z.object({
  body: z.string().optional(),
  path: z.object({
    projectIdOrKey: z.string(),
    propertyKey: z.string(),
  }),
});

export const setProjectPropertyResponseSchema = z.unknown();

export const setProjectPropertyErrorSchema = z.unknown();

export const restoreDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
  }),
});

export const restoreErrorSchema = z.unknown();

export const getProjectRolesDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
  }),
});

export const getProjectRolesResponseSchema = z.record(z.string());

export const getProjectRolesErrorSchema = z.unknown();

export const deleteActorDataSchema = z.object({
  path: z.object({
    id: z.number(),
    projectIdOrKey: z.string(),
  }),
  query: z
    .object({
      group: z.string().optional(),
      groupId: z.string().optional(),
      user: z.string().optional(),
    })
    .optional(),
});

export const deleteActorResponseSchema = z.any();

export const deleteActorErrorSchema = z.unknown();

export const getProjectRoleDataSchema = z.object({
  path: z.object({
    id: z.number(),
    projectIdOrKey: z.string(),
  }),
  query: z
    .object({
      excludeInactiveUsers: z.boolean().optional(),
    })
    .optional(),
});

export const getProjectRoleResponseSchema = projectRoleSchema;

export const getProjectRoleErrorSchema = z.unknown();

export const addActorUsersDataSchema = z.object({
  body: actorsMapSchema,
  path: z.object({
    id: z.number(),
    projectIdOrKey: z.string(),
  }),
});

export const addActorUsersResponseSchema = projectRoleSchema;

export const addActorUsersErrorSchema = z.unknown();

export const setActorsDataSchema = z.object({
  body: projectRoleActorsUpdateBeanSchema,
  path: z.object({
    id: z.number(),
    projectIdOrKey: z.string(),
  }),
});

export const setActorsResponseSchema = projectRoleSchema;

export const setActorsErrorSchema = z.unknown();

export const getProjectRoleDetailsDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
  }),
  query: z
    .object({
      currentMember: z.boolean().optional(),
      excludeConnectAddons: z.boolean().optional(),
    })
    .optional(),
});

export const getProjectRoleDetailsResponseSchema = z.array(projectRoleDetailsSchema);

export const getProjectRoleDetailsErrorSchema = z.unknown();

export const getAllStatusesDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
  }),
});

export const issueTypeWithStatusSchema = z.object({
  id: z.string(),
  name: z.string(),
  self: z.string(),
  statuses: z.array(statusDetailsSchema),
  subtask: z.boolean(),
});

export const getAllStatusesErrorSchema = z.unknown();

export const getProjectVersionsPaginatedDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
      maxResults: z.number().optional(),
      orderBy: z
        .union([
          z.literal('description'),
          z.literal('-description'),
          z.literal('+description'),
          z.literal('name'),
          z.literal('-name'),
          z.literal('+name'),
          z.literal('releaseDate'),
          z.literal('-releaseDate'),
          z.literal('+releaseDate'),
          z.literal('sequence'),
          z.literal('-sequence'),
          z.literal('+sequence'),
          z.literal('startDate'),
          z.literal('-startDate'),
          z.literal('+startDate'),
        ])
        .optional(),
      query: z.string().optional(),
      startAt: z.number().optional(),
      status: z.string().optional(),
    })
    .optional(),
});

export const getProjectVersionsPaginatedErrorSchema = z.unknown();

export const getProjectVersionsDataSchema = z.object({
  path: z.object({
    projectIdOrKey: z.string(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const versionSchema = z.object({
  approvers: z.array(versionApproverSchema).optional(),
  archived: z.boolean().optional(),
  description: z.string().optional(),
  driver: z.string().optional(),
  expand: z.string().optional(),
  id: z.string().optional(),
  issuesStatusForFixVersion: versionIssuesStatusSchema.optional(),
  moveUnfixedIssuesTo: z.string().optional(),
  name: z.string().optional(),
  operations: z.array(simpleLinkSchema).optional(),
  overdue: z.boolean().optional(),
  project: z.string().optional(),
  projectId: z.number().optional(),
  releaseDate: z.string().optional(),
  released: z.boolean().optional(),
  self: z.string().optional(),
  startDate: z.string().optional(),
  userReleaseDate: z.string().optional(),
  userStartDate: z.string().optional(),
});

export const getProjectVersionsErrorSchema = z.unknown();

export const getProjectEmailDataSchema = z.object({
  path: z.object({
    projectId: z.number(),
  }),
});

export const getProjectEmailResponseSchema = projectEmailAddressSchema;

export const getProjectEmailErrorSchema = z.unknown();

export const updateProjectEmailDataSchema = z.object({
  body: projectEmailAddressSchema,
  path: z.object({
    projectId: z.number(),
  }),
});

export const updateProjectEmailResponseSchema = z.unknown();

export const updateProjectEmailErrorSchema = z.unknown();

export const getHierarchyDataSchema = z.object({
  path: z.object({
    projectId: z.number(),
  }),
});

export const projectIssueTypeHierarchySchema = z.object({
  hierarchy: z.array(projectIssueTypesHierarchyLevelSchema).optional(),
  projectId: z.number().optional(),
});

export const getHierarchyErrorSchema = z.unknown();

export const getProjectIssueSecuritySchemeDataSchema = z.object({
  path: z.object({
    projectKeyOrId: z.string(),
  }),
});

export const getProjectIssueSecuritySchemeResponseSchema = securitySchemeSchema;

export const getProjectIssueSecuritySchemeErrorSchema = z.unknown();

export const getNotificationSchemeForProjectDataSchema = z.object({
  path: z.object({
    projectKeyOrId: z.string(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const getNotificationSchemeForProjectErrorSchema = z.unknown();

export const getAssignedPermissionSchemeDataSchema = z.object({
  path: z.object({
    projectKeyOrId: z.string(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const getAssignedPermissionSchemeResponseSchema = permissionSchemeSchema;

export const getAssignedPermissionSchemeErrorSchema = z.unknown();

export const assignPermissionSchemeDataSchema = z.object({
  body: idBeanSchema,
  path: z.object({
    projectKeyOrId: z.string(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const assignPermissionSchemeResponseSchema = permissionSchemeSchema;

export const assignPermissionSchemeErrorSchema = z.unknown();

export const getSecurityLevelsForProjectDataSchema = z.object({
  path: z.object({
    projectKeyOrId: z.string(),
  }),
});

export const getSecurityLevelsForProjectResponseSchema = projectIssueSecurityLevelsSchema;

export const getSecurityLevelsForProjectErrorSchema = z.unknown();

export const getAllProjectCategoriesResponseSchema = z.array(projectCategorySchema);

export const getAllProjectCategoriesErrorSchema = z.unknown();

export const createProjectCategoryDataSchema = z.object({
  body: projectCategorySchema,
});

export const createProjectCategoryResponseSchema = projectCategorySchema;

export const createProjectCategoryErrorSchema = z.unknown();

export const removeProjectCategoryDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const removeProjectCategoryResponseSchema = z.any();

export const removeProjectCategoryErrorSchema = z.unknown();

export const getProjectCategoryByIdDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const getProjectCategoryByIdResponseSchema = projectCategorySchema;

export const getProjectCategoryByIdErrorSchema = z.unknown();

export const updateProjectCategoryDataSchema = z.object({
  body: projectCategorySchema,
  path: z.object({
    id: z.number(),
  }),
});

export const updateProjectCategoryResponseSchema = updatedProjectCategorySchema;

export const updateProjectCategoryErrorSchema = z.unknown();

export const validateProjectKeyDataSchema = z.object({
  query: z
    .object({
      key: z.string().optional(),
    })
    .optional(),
});

export const validateProjectKeyResponseSchema = errorCollectionSchema;

export const validateProjectKeyErrorSchema = z.unknown();

export const getValidProjectKeyDataSchema = z.object({
  query: z
    .object({
      key: z.string().optional(),
    })
    .optional(),
});

export const getValidProjectKeyResponseSchema = z.string();

export const getValidProjectKeyErrorSchema = z.unknown();

export const getValidProjectNameDataSchema = z.object({
  query: z.object({
    name: z.string(),
  }),
});

export const getValidProjectNameResponseSchema = z.string();

export const getValidProjectNameErrorSchema = z.unknown();

export const getResolutionsResponseSchema = z.array(resolutionSchema);

export const getResolutionsErrorSchema = z.unknown();

export const createResolutionDataSchema = z.object({
  body: createResolutionDetailsSchema,
});

export const createResolutionResponseSchema = resolutionIdSchema;

export const createResolutionErrorSchema = errorCollectionSchema;

export const setDefaultResolutionDataSchema = z.object({
  body: setDefaultResolutionRequestSchema,
});

export const setDefaultResolutionResponseSchema = z.unknown();

export const setDefaultResolutionErrorSchema = errorCollectionSchema;

export const moveResolutionsDataSchema = z.object({
  body: reorderIssueResolutionsRequestSchema,
});

export const moveResolutionsResponseSchema = z.unknown();

export const moveResolutionsErrorSchema = errorCollectionSchema;

export const searchResolutionsDataSchema = z.object({
  query: z
    .object({
      id: z.array(z.string()).optional(),
      maxResults: z.string().optional(),
      onlyDefault: z.boolean().optional(),
      startAt: z.string().optional(),
    })
    .optional(),
});

export const pageBeanResolutionJsonBeanSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(resolutionJsonBeanSchema).optional(),
});

export const searchResolutionsErrorSchema = errorCollectionSchema;

export const deleteResolutionDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z.object({
    replaceWith: z.string(),
  }),
});

export const getResolutionDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getResolutionResponseSchema = resolutionSchema;

export const getResolutionErrorSchema = z.unknown();

export const updateResolutionDataSchema = z.object({
  body: updateResolutionDetailsSchema,
  path: z.object({
    id: z.string(),
  }),
});

export const updateResolutionResponseSchema = z.unknown();

export const updateResolutionErrorSchema = errorCollectionSchema;

export const getAllProjectRolesResponseSchema = z.array(projectRoleSchema);

export const getAllProjectRolesErrorSchema = z.unknown();

export const createProjectRoleDataSchema = z.object({
  body: createUpdateRoleRequestBeanSchema,
});

export const createProjectRoleResponseSchema = projectRoleSchema;

export const createProjectRoleErrorSchema = z.unknown();

export const deleteProjectRoleDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
  query: z
    .object({
      swap: z.number().optional(),
    })
    .optional(),
});

export const deleteProjectRoleResponseSchema = z.any();

export const deleteProjectRoleErrorSchema = z.unknown();

export const getProjectRoleByIdDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const getProjectRoleByIdResponseSchema = projectRoleSchema;

export const getProjectRoleByIdErrorSchema = z.unknown();

export const partialUpdateProjectRoleDataSchema = z.object({
  body: createUpdateRoleRequestBeanSchema,
  path: z.object({
    id: z.number(),
  }),
});

export const partialUpdateProjectRoleResponseSchema = projectRoleSchema;

export const partialUpdateProjectRoleErrorSchema = z.unknown();

export const fullyUpdateProjectRoleDataSchema = z.object({
  body: createUpdateRoleRequestBeanSchema,
  path: z.object({
    id: z.number(),
  }),
});

export const fullyUpdateProjectRoleResponseSchema = projectRoleSchema;

export const fullyUpdateProjectRoleErrorSchema = z.unknown();

export const deleteProjectRoleActorsFromRoleDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
  query: z
    .object({
      group: z.string().optional(),
      groupId: z.string().optional(),
      user: z.string().optional(),
    })
    .optional(),
});

export const deleteProjectRoleActorsFromRoleResponseSchema = projectRoleSchema;

export const deleteProjectRoleActorsFromRoleErrorSchema = z.unknown();

export const getProjectRoleActorsForRoleDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const getProjectRoleActorsForRoleResponseSchema = projectRoleSchema;

export const getProjectRoleActorsForRoleErrorSchema = z.unknown();

export const addProjectRoleActorsToRoleDataSchema = z.object({
  body: actorInputBeanSchema,
  path: z.object({
    id: z.number(),
  }),
});

export const addProjectRoleActorsToRoleResponseSchema = projectRoleSchema;

export const addProjectRoleActorsToRoleErrorSchema = z.unknown();

export const getScreensDataSchema = z.object({
  query: z
    .object({
      id: z.array(z.number()).optional(),
      maxResults: z.number().optional(),
      orderBy: z
        .union([
          z.literal('name'),
          z.literal('-name'),
          z.literal('+name'),
          z.literal('id'),
          z.literal('-id'),
          z.literal('+id'),
        ])
        .optional(),
      queryString: z.string().optional(),
      scope: z.array(z.union([z.literal('GLOBAL'), z.literal('TEMPLATE'), z.literal('PROJECT')])).optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const pageBeanScreenSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(screenSchema).optional(),
});

export const getScreensErrorSchema = z.unknown();

export const createScreenDataSchema = z.object({
  body: screenDetailsSchema,
});

export const createScreenResponseSchema = screenSchema;

export const createScreenErrorSchema = z.unknown();

export const addFieldToDefaultScreenDataSchema = z.object({
  path: z.object({
    fieldId: z.string(),
  }),
});

export const addFieldToDefaultScreenResponseSchema = z.unknown();

export const addFieldToDefaultScreenErrorSchema = z.unknown();

export const getBulkScreenTabsDataSchema = z.object({
  query: z
    .object({
      maxResult: z.number().optional(),
      screenId: z.array(z.number()).optional(),
      startAt: z.number().optional(),
      tabId: z.array(z.number()).optional(),
    })
    .optional(),
});

export const getBulkScreenTabsResponseSchema = z.unknown();

export const getBulkScreenTabsErrorSchema = z.unknown();

export const deleteScreenDataSchema = z.object({
  path: z.object({
    screenId: z.number(),
  }),
});

export const deleteScreenResponseSchema = z.any();

export const deleteScreenErrorSchema = z.unknown();

export const updateScreenDataSchema = z.object({
  body: updateScreenDetailsSchema,
  path: z.object({
    screenId: z.number(),
  }),
});

export const updateScreenResponseSchema = screenSchema;

export const updateScreenErrorSchema = z.unknown();

export const getAvailableScreenFieldsDataSchema = z.object({
  path: z.object({
    screenId: z.number(),
  }),
});

export const getAvailableScreenFieldsResponseSchema = z.array(screenableFieldSchema);

export const getAvailableScreenFieldsErrorSchema = z.unknown();

export const getAllScreenTabsDataSchema = z.object({
  path: z.object({
    screenId: z.number(),
  }),
  query: z
    .object({
      projectKey: z.string().optional(),
    })
    .optional(),
});

export const getAllScreenTabsResponseSchema = z.array(screenableTabSchema);

export const getAllScreenTabsErrorSchema = z.unknown();

export const addScreenTabDataSchema = z.object({
  body: screenableTabSchema,
  path: z.object({
    screenId: z.number(),
  }),
});

export const addScreenTabResponseSchema = screenableTabSchema;

export const addScreenTabErrorSchema = z.unknown();

export const deleteScreenTabDataSchema = z.object({
  path: z.object({
    screenId: z.number(),
    tabId: z.number(),
  }),
});

export const deleteScreenTabResponseSchema = z.any();

export const deleteScreenTabErrorSchema = z.unknown();

export const renameScreenTabDataSchema = z.object({
  body: screenableTabSchema,
  path: z.object({
    screenId: z.number(),
    tabId: z.number(),
  }),
});

export const renameScreenTabResponseSchema = screenableTabSchema;

export const renameScreenTabErrorSchema = z.unknown();

export const getAllScreenTabFieldsDataSchema = z.object({
  path: z.object({
    screenId: z.number(),
    tabId: z.number(),
  }),
  query: z
    .object({
      projectKey: z.string().optional(),
    })
    .optional(),
});

export const getAllScreenTabFieldsResponseSchema = z.array(screenableFieldSchema);

export const getAllScreenTabFieldsErrorSchema = z.unknown();

export const addScreenTabFieldDataSchema = z.object({
  body: addFieldBeanSchema,
  path: z.object({
    screenId: z.number(),
    tabId: z.number(),
  }),
});

export const addScreenTabFieldResponseSchema = screenableFieldSchema;

export const addScreenTabFieldErrorSchema = z.unknown();

export const removeScreenTabFieldDataSchema = z.object({
  path: z.object({
    id: z.string(),
    screenId: z.number(),
    tabId: z.number(),
  }),
});

export const removeScreenTabFieldResponseSchema = z.any();

export const removeScreenTabFieldErrorSchema = z.unknown();

export const moveScreenTabFieldDataSchema = z.object({
  body: moveFieldBeanSchema,
  path: z.object({
    id: z.string(),
    screenId: z.number(),
    tabId: z.number(),
  }),
});

export const moveScreenTabFieldResponseSchema = z.unknown();

export const moveScreenTabFieldErrorSchema = z.unknown();

export const moveScreenTabDataSchema = z.object({
  path: z.object({
    pos: z.number(),
    screenId: z.number(),
    tabId: z.number(),
  }),
});

export const moveScreenTabResponseSchema = z.unknown();

export const moveScreenTabErrorSchema = z.unknown();

export const getScreenSchemesDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
      id: z.array(z.number()).optional(),
      maxResults: z.number().optional(),
      orderBy: z
        .union([
          z.literal('name'),
          z.literal('-name'),
          z.literal('+name'),
          z.literal('id'),
          z.literal('-id'),
          z.literal('+id'),
        ])
        .optional(),
      queryString: z.string().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getScreenSchemesErrorSchema = z.unknown();

export const createScreenSchemeDataSchema = z.object({
  body: screenSchemeDetailsSchema,
});

export const createScreenSchemeResponseSchema = screenSchemeIdSchema;

export const createScreenSchemeErrorSchema = z.unknown();

export const deleteScreenSchemeDataSchema = z.object({
  path: z.object({
    screenSchemeId: z.string(),
  }),
});

export const deleteScreenSchemeResponseSchema = z.any();

export const deleteScreenSchemeErrorSchema = z.unknown();

export const updateScreenSchemeDetailsSchema = z.object({
  description: z.string().optional(),
  name: z.string().optional(),
  screens: updateScreenTypesSchema.optional(),
});

export const updateScreenSchemeResponseSchema = z.unknown();

export const updateScreenSchemeErrorSchema = z.unknown();

export const searchForIssuesUsingJqlDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
      failFast: z.boolean().optional(),
      fields: z.array(z.string()).optional(),
      fieldsByKeys: z.boolean().optional(),
      jql: z.string().optional(),
      maxResults: z.number().optional(),
      properties: z.array(z.string()).optional(),
      startAt: z.number().optional(),
      validateQuery: z
        .union([z.literal('strict'), z.literal('warn'), z.literal('none'), z.literal('true'), z.literal('false')])
        .optional(),
    })
    .optional(),
});

export const searchForIssuesUsingJqlErrorSchema = z.unknown();

export const searchForIssuesUsingJqlPostDataSchema = z.object({
  body: searchRequestBeanSchema,
});

export const searchForIssuesUsingJqlPostErrorSchema = z.unknown();

export const countIssuesDataSchema = z.object({
  body: jQLCountRequestBeanSchema,
});

export const countIssuesResponseSchema = jQLCountResultsBeanSchema;

export const countIssuesErrorSchema = z.unknown();

export const searchForIssuesIdsDataSchema = z.object({
  body: idSearchRequestBeanSchema,
});

export const searchForIssuesIdsResponseSchema = idSearchResultsSchema;

export const searchForIssuesIdsErrorSchema = z.unknown();

export const searchAndReconsileIssuesUsingJqlDataSchema = z.object({
  body: searchAndReconcileRequestBeanSchema,
});

export const searchAndReconsileIssuesUsingJqlErrorSchema = z.unknown();

export const searchAndReconsileIssuesUsingJqlPostDataSchema = z.object({
  body: searchAndReconcileRequestBeanSchema,
});

export const searchAndReconsileIssuesUsingJqlPostErrorSchema = z.unknown();

export const getIssueSecurityLevelDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getIssueSecurityLevelResponseSchema = securityLevelSchema;

export const getIssueSecurityLevelErrorSchema = z.unknown();

export const getServerInfoResponseSchema = serverInformationSchema;

export const getServerInfoErrorSchema = z.unknown();

export const getIssueNavigatorDefaultColumnsResponseSchema = z.array(columnItemSchema);

export const getIssueNavigatorDefaultColumnsErrorSchema = errorCollectionSchema;

export const setIssueNavigatorDefaultColumnsDataSchema = z.object({
  body: columnRequestBodySchema,
});

export const setIssueNavigatorDefaultColumnsResponseSchema = z.unknown();

export const setIssueNavigatorDefaultColumnsErrorSchema = z.unknown();

export const getStatusesResponseSchema = z.array(statusDetailsSchema);

export const getStatusesErrorSchema = z.unknown();

export const getStatusDataSchema = z.object({
  path: z.object({
    idOrName: z.string(),
  }),
});

export const getStatusResponseSchema = statusDetailsSchema;

export const getStatusErrorSchema = z.unknown();

export const getStatusCategoriesResponseSchema = z.array(statusCategorySchema);

export const getStatusCategoriesErrorSchema = z.unknown();

export const getStatusCategoryDataSchema = z.object({
  path: z.object({
    idOrKey: z.string(),
  }),
});

export const getStatusCategoryResponseSchema = statusCategorySchema;

export const getStatusCategoryErrorSchema = z.unknown();

export const deleteStatusesByIdDataSchema = z.object({
  query: z.object({
    id: z.array(z.string()),
  }),
});

export const deleteStatusesByIdResponseSchema = z.unknown();

export const deleteStatusesByIdErrorSchema = z.unknown();

export const getStatusesByIdDataSchema = z.object({
  query: z.object({
    expand: z.string().optional(),
    id: z.array(z.string()),
  }),
});

export const jiraStatusSchema = z.object({
  description: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  scope: statusScopeSchema.optional(),
  statusCategory: z.union([z.literal('TODO'), z.literal('IN_PROGRESS'), z.literal('DONE')]).optional(),
  usages: z.array(projectIssueTypesSchema).optional(),
  workflowUsages: z.array(workflowUsagesSchema).optional(),
});

export const getStatusesByIdErrorSchema = z.unknown();

export const statusCreateRequestSchema = z.object({
  scope: statusScopeSchema,
  statuses: z.array(statusCreateSchema),
});

export const createStatusesResponseSchema = z.array(jiraStatusSchema);

export const createStatusesErrorSchema = z.unknown();

export const updateStatusesDataSchema = z.object({
  body: statusUpdateRequestSchema,
});

export const updateStatusesResponseSchema = z.unknown();

export const updateStatusesErrorSchema = z.unknown();

export const searchDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
      maxResults: z.number().optional(),
      projectId: z.string().optional(),
      searchString: z.string().optional(),
      startAt: z.number().optional(),
      statusCategory: z.string().optional(),
    })
    .optional(),
});

export const pageOfStatusesSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(jiraStatusSchema).optional(),
});

export const searchErrorSchema = z.unknown();

export const getTaskDataSchema = z.object({
  path: z.object({
    taskId: z.string(),
  }),
});

export const getTaskResponseSchema = taskProgressBeanObjectSchema;

export const getTaskErrorSchema = z.unknown();

export const cancelTaskDataSchema = z.object({
  path: z.object({
    taskId: z.string(),
  }),
});

export const cancelTaskResponseSchema = z.unknown();

export const cancelTaskErrorSchema = z.array(z.string());

export const getUiModificationsDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const pageBeanUiModificationDetailsSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(uiModificationDetailsSchema).optional(),
});

export const getUiModificationsErrorSchema = z.unknown();

export const createUiModificationDetailsSchema = z.object({
  contexts: z.array(uiModificationContextDetailsSchema).optional(),
  data: z.string().optional(),
  description: z.string().optional(),
  name: z.string(),
});

export const createUiModificationResponseSchema = uiModificationIdentifiersSchema;

export const createUiModificationErrorSchema = z.union([z.unknown(), detailedErrorCollectionSchema]);

export const deleteUiModificationDataSchema = z.object({
  path: z.object({
    uiModificationId: z.string(),
  }),
});

export const deleteUiModificationResponseSchema = z.unknown();

export const deleteUiModificationErrorSchema = z.unknown();

export const updateUiModificationDataSchema = z.object({
  body: updateUiModificationDetailsSchema,
  path: z.object({
    uiModificationId: z.string(),
  }),
});

export const updateUiModificationResponseSchema = z.unknown();

export const updateUiModificationErrorSchema = z.union([z.unknown(), detailedErrorCollectionSchema]);

export const getAvatarsDataSchema = z.object({
  path: z.object({
    entityId: z.string(),
    type: z.union([z.literal('project'), z.literal('issuetype'), z.literal('priority')]),
  }),
});

export const getAvatarsResponseSchema = avatarsSchema;

export const getAvatarsErrorSchema = z.unknown();

export const storeAvatarDataSchema = z.object({
  body: z.string().optional(),
  path: z.object({
    entityId: z.string(),
    type: z.union([z.literal('project'), z.literal('issuetype'), z.literal('priority')]),
  }),
  query: z.object({
    size: z.number(),
    x: z.number().optional(),
    y: z.number().optional(),
  }),
});

export const storeAvatarResponseSchema = avatarSchema;

export const storeAvatarErrorSchema = z.unknown();

export const deleteAvatarDataSchema = z.object({
  path: z.object({
    id: z.number(),
    owningObjectId: z.string(),
    type: z.union([z.literal('project'), z.literal('issuetype'), z.literal('priority')]),
  }),
});

export const deleteAvatarResponseSchema = z.any();

export const deleteAvatarErrorSchema = z.unknown();

export const getAvatarImageByTypeDataSchema = z.object({
  path: z.object({
    type: z.union([z.literal('issuetype'), z.literal('project'), z.literal('priority')]),
  }),
  query: z
    .object({
      format: z.union([z.literal('png'), z.literal('svg')]).optional(),
      size: z
        .union([z.literal('xsmall'), z.literal('small'), z.literal('medium'), z.literal('large'), z.literal('xlarge')])
        .optional(),
    })
    .optional(),
});

export const getAvatarImageByTypeResponseSchema = streamingResponseBodySchema;

export const getAvatarImageByTypeErrorSchema = errorCollectionSchema;

export const getAvatarImageByIdDataSchema = z.object({
  path: z.object({
    id: z.number(),
    type: z.union([z.literal('issuetype'), z.literal('project'), z.literal('priority')]),
  }),
  query: z
    .object({
      format: z.union([z.literal('png'), z.literal('svg')]).optional(),
      size: z
        .union([z.literal('xsmall'), z.literal('small'), z.literal('medium'), z.literal('large'), z.literal('xlarge')])
        .optional(),
    })
    .optional(),
});

export const getAvatarImageByIdResponseSchema = streamingResponseBodySchema;

export const getAvatarImageByIdErrorSchema = errorCollectionSchema;

export const getAvatarImageByOwnerDataSchema = z.object({
  path: z.object({
    entityId: z.string(),
    type: z.union([z.literal('issuetype'), z.literal('project'), z.literal('priority')]),
  }),
  query: z
    .object({
      format: z.union([z.literal('png'), z.literal('svg')]).optional(),
      size: z
        .union([z.literal('xsmall'), z.literal('small'), z.literal('medium'), z.literal('large'), z.literal('xlarge')])
        .optional(),
    })
    .optional(),
});

export const getAvatarImageByOwnerResponseSchema = streamingResponseBodySchema;

export const getAvatarImageByOwnerErrorSchema = errorCollectionSchema;

export const removeUserDataSchema = z.object({
  query: z.object({
    accountId: z.string(),
    key: z.string().optional(),
    username: z.string().optional(),
  }),
});

export const removeUserResponseSchema = z.any();

export const removeUserErrorSchema = z.unknown();

export const getUserDataSchema = z.object({
  query: z
    .object({
      accountId: z.string().optional(),
      expand: z.string().optional(),
      key: z.string().optional(),
      username: z.string().optional(),
    })
    .optional(),
});

export const getUserResponseSchema = userSchema;

export const getUserErrorSchema = z.unknown();

export const createUserDataSchema = z.object({
  body: newUserDetailsSchema,
});

export const createUserResponseSchema = userSchema;

export const createUserErrorSchema = z.unknown();

export const findBulkAssignableUsersDataSchema = z.object({
  query: z.object({
    accountId: z.string().optional(),
    maxResults: z.number().optional(),
    projectKeys: z.string(),
    query: z.string().optional(),
    startAt: z.number().optional(),
    username: z.string().optional(),
  }),
});

export const findBulkAssignableUsersResponseSchema = z.array(userSchema);

export const findBulkAssignableUsersErrorSchema = z.unknown();

export const findAssignableUsersDataSchema = z.object({
  query: z
    .object({
      accountId: z.string().optional(),
      actionDescriptorId: z.number().optional(),
      issueKey: z.string().optional(),
      maxResults: z.number().optional(),
      project: z.string().optional(),
      query: z.string().optional(),
      recommend: z.boolean().optional(),
      sessionId: z.string().optional(),
      startAt: z.number().optional(),
      username: z.string().optional(),
    })
    .optional(),
});

export const findAssignableUsersResponseSchema = z.array(userSchema);

export const findAssignableUsersErrorSchema = z.unknown();

export const bulkGetUsersDataSchema = z.object({
  query: z.object({
    accountId: z.array(z.string()),
    key: z.array(z.string()).optional(),
    maxResults: z.number().optional(),
    startAt: z.number().optional(),
    username: z.array(z.string()).optional(),
  }),
});

export const pageBeanUserSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(userSchema).optional(),
});

export const bulkGetUsersErrorSchema = z.unknown();

export const bulkGetUsersMigrationDataSchema = z.object({
  query: z
    .object({
      key: z.array(z.string()).optional(),
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
      username: z.array(z.string()).optional(),
    })
    .optional(),
});

export const bulkGetUsersMigrationResponseSchema = z.array(userMigrationBeanSchema);

export const bulkGetUsersMigrationErrorSchema = z.unknown();

export const resetUserColumnsDataSchema = z.object({
  query: z
    .object({
      accountId: z.string().optional(),
      username: z.string().optional(),
    })
    .optional(),
});

export const resetUserColumnsResponseSchema = z.any();

export const resetUserColumnsErrorSchema = z.unknown();

export const getUserDefaultColumnsDataSchema = z.object({
  query: z
    .object({
      accountId: z.string().optional(),
      username: z.string().optional(),
    })
    .optional(),
});

export const getUserDefaultColumnsResponseSchema = z.array(columnItemSchema);

export const getUserDefaultColumnsErrorSchema = z.unknown();

export const setUserColumnsDataSchema = z.object({
  body: userColumnRequestBodySchema,
  query: z
    .object({
      accountId: z.string().optional(),
    })
    .optional(),
});

export const setUserColumnsResponseSchema = z.unknown();

export const setUserColumnsErrorSchema = z.unknown();

export const getUserEmailDataSchema = z.object({
  query: z.object({
    accountId: z.string(),
  }),
});

export const getUserEmailResponseSchema = unrestrictedUserEmailSchema;

export const getUserEmailErrorSchema = z.unknown();

export const getUserEmailBulkDataSchema = z.object({
  query: z.object({
    accountId: z.array(z.string()),
  }),
});

export const getUserEmailBulkResponseSchema = unrestrictedUserEmailSchema;

export const getUserEmailBulkErrorSchema = z.unknown();

export const getUserGroupsDataSchema = z.object({
  query: z.object({
    accountId: z.string(),
    key: z.string().optional(),
    username: z.string().optional(),
  }),
});

export const getUserGroupsResponseSchema = z.array(groupNameSchema);

export const getUserGroupsErrorSchema = z.unknown();

export const findUsersWithAllPermissionsDataSchema = z.object({
  query: z.object({
    accountId: z.string().optional(),
    issueKey: z.string().optional(),
    maxResults: z.number().optional(),
    permissions: z.string(),
    projectKey: z.string().optional(),
    query: z.string().optional(),
    startAt: z.number().optional(),
    username: z.string().optional(),
  }),
});

export const findUsersWithAllPermissionsResponseSchema = z.array(userSchema);

export const findUsersWithAllPermissionsErrorSchema = z.unknown();

export const findUsersForPickerDataSchema = z.object({
  query: z.object({
    avatarSize: z.string().optional(),
    exclude: z.array(z.string()).optional(),
    excludeAccountIds: z.array(z.string()).optional(),
    excludeConnectUsers: z.boolean().optional(),
    maxResults: z.number().optional(),
    query: z.string(),
    showAvatar: z.boolean().optional(),
  }),
});

export const findUsersForPickerResponseSchema = foundUsersSchema;

export const findUsersForPickerErrorSchema = z.unknown();

export const getUserPropertyKeysDataSchema = z.object({
  query: z
    .object({
      accountId: z.string().optional(),
      userKey: z.string().optional(),
      username: z.string().optional(),
    })
    .optional(),
});

export const getUserPropertyKeysResponseSchema = propertyKeysSchema;

export const getUserPropertyKeysErrorSchema = z.unknown();

export const deleteUserPropertyDataSchema = z.object({
  path: z.object({
    propertyKey: z.string(),
  }),
  query: z
    .object({
      accountId: z.string().optional(),
      userKey: z.string().optional(),
      username: z.string().optional(),
    })
    .optional(),
});

export const deleteUserPropertyResponseSchema = z.any();

export const deleteUserPropertyErrorSchema = z.unknown();

export const getUserPropertyDataSchema = z.object({
  path: z.object({
    propertyKey: z.string(),
  }),
  query: z
    .object({
      accountId: z.string().optional(),
      userKey: z.string().optional(),
      username: z.string().optional(),
    })
    .optional(),
});

export const getUserPropertyResponseSchema = entityPropertySchema;

export const getUserPropertyErrorSchema = z.unknown();

export const setUserPropertyDataSchema = z.object({
  body: z.string().optional(),
  path: z.object({
    propertyKey: z.string(),
  }),
  query: z
    .object({
      accountId: z.string().optional(),
      userKey: z.string().optional(),
      username: z.string().optional(),
    })
    .optional(),
});

export const setUserPropertyResponseSchema = z.unknown();

export const setUserPropertyErrorSchema = z.unknown();

export const findUsersDataSchema = z.object({
  query: z
    .object({
      accountId: z.string().optional(),
      maxResults: z.number().optional(),
      property: z.string().optional(),
      query: z.string().optional(),
      startAt: z.number().optional(),
      username: z.string().optional(),
    })
    .optional(),
});

export const findUsersResponseSchema = z.array(userSchema);

export const findUsersErrorSchema = z.unknown();

export const findUsersByQueryDataSchema = z.object({
  query: z.object({
    maxResults: z.number().optional(),
    query: z.string(),
    startAt: z.number().optional(),
  }),
});

export const findUsersByQueryResponseSchema = pageBeanUserSchema;

export const findUsersByQueryErrorSchema = errorCollectionSchema;

export const findUserKeysByQueryDataSchema = z.object({
  query: z.object({
    maxResult: z.number().optional(),
    query: z.string(),
    startAt: z.number().optional(),
  }),
});

export const pageBeanUserKeySchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(userKeySchema).optional(),
});

export const findUserKeysByQueryErrorSchema = errorCollectionSchema;

export const findUsersWithBrowsePermissionDataSchema = z.object({
  query: z
    .object({
      accountId: z.string().optional(),
      issueKey: z.string().optional(),
      maxResults: z.number().optional(),
      projectKey: z.string().optional(),
      query: z.string().optional(),
      startAt: z.number().optional(),
      username: z.string().optional(),
    })
    .optional(),
});

export const findUsersWithBrowsePermissionResponseSchema = z.array(userSchema);

export const findUsersWithBrowsePermissionErrorSchema = z.unknown();

export const getAllUsersDefaultDataSchema = z.object({
  query: z
    .object({
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getAllUsersDefaultResponseSchema = z.array(userSchema);

export const getAllUsersDefaultErrorSchema = z.unknown();

export const getAllUsersDataSchema = z.object({
  query: z
    .object({
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const getAllUsersResponseSchema = z.array(userSchema);

export const getAllUsersErrorSchema = z.unknown();

export const createVersionDataSchema = z.object({
  body: versionSchema,
});

export const createVersionResponseSchema = versionSchema;

export const createVersionErrorSchema = z.unknown();

export const deleteVersionDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      moveAffectedIssuesTo: z.string().optional(),
      moveFixIssuesTo: z.string().optional(),
    })
    .optional(),
});

export const deleteVersionResponseSchema = z.any();

export const deleteVersionErrorSchema = z.unknown();

export const getVersionDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const getVersionResponseSchema = versionSchema;

export const getVersionErrorSchema = z.unknown();

export const updateVersionDataSchema = z.object({
  body: versionSchema,
  path: z.object({
    id: z.string(),
  }),
});

export const updateVersionResponseSchema = versionSchema;

export const updateVersionErrorSchema = z.unknown();

export const mergeVersionsDataSchema = z.object({
  path: z.object({
    id: z.string(),
    moveIssuesTo: z.string(),
  }),
});

export const mergeVersionsResponseSchema = z.unknown();

export const mergeVersionsErrorSchema = z.unknown();

export const moveVersionDataSchema = z.object({
  body: versionMoveBeanSchema,
  path: z.object({
    id: z.string(),
  }),
});

export const moveVersionResponseSchema = versionSchema;

export const moveVersionErrorSchema = z.unknown();

export const getVersionRelatedIssuesDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const versionIssueCountsSchema = z.object({
  customFieldUsage: z.array(versionUsageInCustomFieldSchema).optional(),
  issueCountWithCustomFieldsShowingVersion: z.number().optional(),
  issuesAffectedCount: z.number().optional(),
  issuesFixedCount: z.number().optional(),
  self: z.string().optional(),
});

export const getVersionRelatedIssuesErrorSchema = z.unknown();

export const getRelatedWorkDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getRelatedWorkResponseSchema = z.array(versionRelatedWorkSchema);

export const getRelatedWorkErrorSchema = z.unknown();

export const createRelatedWorkDataSchema = z.object({
  body: versionRelatedWorkSchema,
  path: z.object({
    id: z.string(),
  }),
});

export const createRelatedWorkResponseSchema = versionRelatedWorkSchema;

export const createRelatedWorkErrorSchema = z.unknown();

export const updateRelatedWorkDataSchema = z.object({
  body: versionRelatedWorkSchema,
  path: z.object({
    id: z.string(),
  }),
});

export const updateRelatedWorkResponseSchema = versionRelatedWorkSchema;

export const updateRelatedWorkErrorSchema = z.unknown();

export const deleteAndReplaceVersionDataSchema = z.object({
  body: deleteAndReplaceVersionBeanSchema,
  path: z.object({
    id: z.string(),
  }),
});

export const deleteAndReplaceVersionResponseSchema = z.unknown();

export const deleteAndReplaceVersionErrorSchema = z.unknown();

export const getVersionUnresolvedIssuesDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getVersionUnresolvedIssuesResponseSchema = versionUnresolvedIssuesCountSchema;

export const getVersionUnresolvedIssuesErrorSchema = z.unknown();

export const deleteRelatedWorkDataSchema = z.object({
  path: z.object({
    relatedWorkId: z.string(),
    versionId: z.string(),
  }),
});

export const deleteRelatedWorkResponseSchema = z.any();

export const deleteRelatedWorkErrorSchema = z.unknown();

export const deleteWebhookByIdDataSchema = z.object({
  body: containerForWebhookIDsSchema,
});

export const deleteWebhookByIdResponseSchema = z.unknown();

export const deleteWebhookByIdErrorSchema = errorCollectionSchema;

export const getDynamicWebhooksForAppDataSchema = z.object({
  query: z
    .object({
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const pageBeanWebhookSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(webhookSchema).optional(),
});

export const getDynamicWebhooksForAppErrorSchema = errorCollectionSchema;

export const registerDynamicWebhooksDataSchema = z.object({
  body: webhookRegistrationDetailsSchema,
});

export const containerForRegisteredWebhooksSchema = z.object({
  webhookRegistrationResult: z.array(registeredWebhookSchema).optional(),
});

export const registerDynamicWebhooksErrorSchema = errorCollectionSchema;

export const getFailedWebhooksDataSchema = z.object({
  query: z
    .object({
      after: z.number().optional(),
      maxResults: z.number().optional(),
    })
    .optional(),
});

export const getFailedWebhooksResponseSchema = failedWebhooksSchema;

export const getFailedWebhooksErrorSchema = errorCollectionSchema;

export const refreshWebhooksDataSchema = z.object({
  body: containerForWebhookIDsSchema,
});

export const refreshWebhooksResponseSchema = webhooksExpirationDateSchema;

export const refreshWebhooksErrorSchema = errorCollectionSchema;

export const getAllWorkflowsDataSchema = z.object({
  query: z
    .object({
      workflowName: z.string().optional(),
    })
    .optional(),
});

export const getAllWorkflowsResponseSchema = z.array(deprecatedWorkflowSchema);

export const getAllWorkflowsErrorSchema = z.unknown();

export const createWorkflowResponseSchema = workflowIDsSchema;

export const createWorkflowErrorSchema = z.unknown();

export const getWorkflowTransitionRuleConfigurationsDataSchema = z.object({
  query: z.object({
    draft: z.boolean().optional(),
    expand: z.string().optional(),
    keys: z.array(z.string()).optional(),
    maxResults: z.number().optional(),
    startAt: z.number().optional(),
    types: z.array(z.union([z.literal('postfunction'), z.literal('condition'), z.literal('validator')])),
    withTags: z.array(z.string()).optional(),
    workflowNames: z.array(z.string()).optional(),
  }),
});

export const pageBeanWorkflowTransitionRulesSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(workflowTransitionRulesSchema).optional(),
});

export const getWorkflowTransitionRuleConfigurationsErrorSchema = z.union([errorCollectionSchema, z.unknown()]);

export const workflowTransitionRulesUpdateSchema = z.object({
  workflows: z.array(workflowTransitionRulesSchema),
});

export const updateWorkflowTransitionRuleConfigurationsResponseSchema = workflowTransitionRulesUpdateErrorsSchema;

export const updateWorkflowTransitionRuleConfigurationsErrorSchema = z.union([errorCollectionSchema, z.unknown()]);

export const deleteWorkflowTransitionRuleConfigurationsDataSchema = z.object({
  body: workflowsWithTransitionRulesDetailsSchema,
});

export const deleteWorkflowTransitionRuleConfigurationsResponseSchema = workflowTransitionRulesUpdateErrorsSchema;

export const deleteWorkflowTransitionRuleConfigurationsErrorSchema = errorCollectionSchema;

export const getWorkflowsPaginatedDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
      isActive: z.boolean().optional(),
      maxResults: z.number().optional(),
      orderBy: z
        .union([
          z.literal('name'),
          z.literal('-name'),
          z.literal('+name'),
          z.literal('created'),
          z.literal('-created'),
          z.literal('+created'),
          z.literal('updated'),
          z.literal('+updated'),
          z.literal('-updated'),
        ])
        .optional(),
      queryString: z.string().optional(),
      startAt: z.number().optional(),
      workflowName: z.array(z.string()).optional(),
    })
    .optional(),
});

export const getWorkflowsPaginatedErrorSchema = z.union([z.unknown(), errorCollectionSchema]);

export const deleteWorkflowTransitionPropertyDataSchema = z.object({
  path: z.object({
    transitionId: z.number(),
  }),
  query: z.object({
    key: z.string(),
    workflowMode: z.union([z.literal('live'), z.literal('draft')]).optional(),
    workflowName: z.string(),
  }),
});

export const deleteWorkflowTransitionPropertyResponseSchema = z.unknown();

export const deleteWorkflowTransitionPropertyErrorSchema = z.unknown();

export const getWorkflowTransitionPropertiesDataSchema = z.object({
  path: z.object({
    transitionId: z.number(),
  }),
  query: z.object({
    includeReservedKeys: z.boolean().optional(),
    key: z.string().optional(),
    workflowMode: z.union([z.literal('live'), z.literal('draft')]).optional(),
    workflowName: z.string(),
  }),
});

export const getWorkflowTransitionPropertiesResponseSchema = workflowTransitionPropertySchema;

export const getWorkflowTransitionPropertiesErrorSchema = z.unknown();

export const createWorkflowTransitionPropertyDataSchema = z.object({
  body: workflowTransitionPropertySchema,
  path: z.object({
    transitionId: z.number(),
  }),
  query: z.object({
    key: z.string(),
    workflowMode: z.union([z.literal('live'), z.literal('draft')]).optional(),
    workflowName: z.string(),
  }),
});

export const createWorkflowTransitionPropertyResponseSchema = workflowTransitionPropertySchema;

export const createWorkflowTransitionPropertyErrorSchema = z.unknown();

export const updateWorkflowTransitionPropertyDataSchema = z.object({
  body: workflowTransitionPropertySchema,
  path: z.object({
    transitionId: z.number(),
  }),
  query: z.object({
    key: z.string(),
    workflowMode: z.union([z.literal('live'), z.literal('draft')]).optional(),
    workflowName: z.string(),
  }),
});

export const updateWorkflowTransitionPropertyResponseSchema = workflowTransitionPropertySchema;

export const updateWorkflowTransitionPropertyErrorSchema = z.unknown();

export const deleteInactiveWorkflowDataSchema = z.object({
  path: z.object({
    entityId: z.string(),
  }),
});

export const deleteInactiveWorkflowResponseSchema = z.any();

export const deleteInactiveWorkflowErrorSchema = z.unknown();

export const readWorkflowsDataSchema = z.object({
  body: workflowReadRequestSchema,
  query: z
    .object({
      expand: z.string().optional(),
      useApprovalConfiguration: z.boolean().optional(),
      useTransitionLinksFormat: z.boolean().optional(),
    })
    .optional(),
});

export const readWorkflowsErrorSchema = z.unknown();

export const workflowCapabilitiesDataSchema = z.object({
  query: z
    .object({
      issueTypeId: z.string().optional(),
      projectId: z.string().optional(),
      workflowId: z.string().optional(),
    })
    .optional(),
});

export const workflowCapabilitiesResponseSchema = workflowCapabilitiesSchema;

export const workflowCapabilitiesErrorSchema = z.unknown();

export const createWorkflowsDataSchema = z.object({
  body: workflowCreateRequestSchema,
});

export const createWorkflowsErrorSchema = z.unknown();

export const workflowCreateValidateRequestSchema = z.object({
  payload: workflowCreateRequestSchema,
  validationOptions: validationOptionsForCreateSchema.optional(),
});

export const validateCreateWorkflowsResponseSchema = workflowValidationErrorListSchema;

export const validateCreateWorkflowsErrorSchema = z.unknown();

export const updateWorkflowsDataSchema = z.object({
  body: workflowUpdateRequestSchema,
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const updateWorkflowsErrorSchema = z.unknown();

export const workflowUpdateValidateRequestBeanSchema = z.object({
  payload: workflowUpdateRequestSchema,
  validationOptions: validationOptionsForUpdateSchema.optional(),
});

export const validateUpdateWorkflowsResponseSchema = workflowValidationErrorListSchema;

export const validateUpdateWorkflowsErrorSchema = z.unknown();

export const getAllWorkflowSchemesDataSchema = z.object({
  query: z
    .object({
      maxResults: z.number().optional(),
      startAt: z.number().optional(),
    })
    .optional(),
});

export const pageBeanWorkflowSchemeSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(workflowSchemeSchema).optional(),
});

export const getAllWorkflowSchemesErrorSchema = z.unknown();

export const createWorkflowSchemeDataSchema = z.object({
  body: workflowSchemeSchema,
});

export const createWorkflowSchemeResponseSchema = workflowSchemeSchema;

export const createWorkflowSchemeErrorSchema = z.unknown();

export const getWorkflowSchemeProjectAssociationsDataSchema = z.object({
  query: z.object({
    projectId: z.array(z.number()),
  }),
});

export const containerOfWorkflowSchemeAssociationsSchema = z.object({
  values: z.array(workflowSchemeAssociationsSchema),
});

export const getWorkflowSchemeProjectAssociationsErrorSchema = z.unknown();

export const assignSchemeToProjectDataSchema = z.object({
  body: workflowSchemeProjectAssociationSchema,
});

export const assignSchemeToProjectResponseSchema = z.unknown();

export const assignSchemeToProjectErrorSchema = z.unknown();

export const readWorkflowSchemesDataSchema = z.object({
  body: workflowSchemeReadRequestSchema,
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const workflowSchemeReadResponseSchema = z.object({
  defaultWorkflow: workflowMetadataRestModelSchema.optional(),
  description: z.string().optional().nullable(),
  id: z.string(),
  name: z.string(),
  projectIdsUsingScheme: z.array(z.string()),
  scope: workflowScopeSchema,
  taskId: z.string().optional().nullable(),
  version: documentVersionSchema,
  workflowsForIssueTypes: z.array(workflowMetadataAndIssueTypeRestModelSchema),
});

export const readWorkflowSchemesErrorSchema = z.unknown();

export const workflowSchemeUpdateRequestSchema = z.object({
  defaultWorkflowId: z.string().optional(),
  description: z.string(),
  id: z.string(),
  name: z.string(),
  statusMappingsByIssueTypeOverride: z.array(mappingsByIssueTypeOverrideSchema).optional(),
  statusMappingsByWorkflows: z.array(mappingsByWorkflowSchema).optional(),
  version: documentVersionSchema,
  workflowsForIssueTypes: z.array(workflowSchemeAssociationSchema).optional(),
});

export const updateSchemesResponseSchema = z.unknown();

export const updateSchemesErrorSchema = z.union([taskProgressBeanObjectSchema, z.unknown()]);

export const updateWorkflowSchemeMappingsDataSchema = z.object({
  body: workflowSchemeUpdateRequiredMappingsRequestSchema,
});

export const updateWorkflowSchemeMappingsResponseSchema = workflowSchemeUpdateRequiredMappingsResponseSchema;

export const updateWorkflowSchemeMappingsErrorSchema = z.unknown();

export const deleteWorkflowSchemeDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const deleteWorkflowSchemeResponseSchema = z.unknown();

export const deleteWorkflowSchemeErrorSchema = z.unknown();

export const getWorkflowSchemeDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
  query: z
    .object({
      returnDraftIfExists: z.boolean().optional(),
    })
    .optional(),
});

export const getWorkflowSchemeResponseSchema = workflowSchemeSchema;

export const getWorkflowSchemeErrorSchema = z.unknown();

export const updateWorkflowSchemeDataSchema = z.object({
  body: workflowSchemeSchema,
  path: z.object({
    id: z.number(),
  }),
});

export const updateWorkflowSchemeResponseSchema = workflowSchemeSchema;

export const updateWorkflowSchemeErrorSchema = z.unknown();

export const createWorkflowSchemeDraftFromParentDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const createWorkflowSchemeDraftFromParentResponseSchema = workflowSchemeSchema;

export const createWorkflowSchemeDraftFromParentErrorSchema = z.unknown();

export const deleteDefaultWorkflowDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
  query: z
    .object({
      updateDraftIfNeeded: z.boolean().optional(),
    })
    .optional(),
});

export const deleteDefaultWorkflowResponseSchema = workflowSchemeSchema;

export const deleteDefaultWorkflowErrorSchema = z.unknown();

export const getDefaultWorkflowDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
  query: z
    .object({
      returnDraftIfExists: z.boolean().optional(),
    })
    .optional(),
});

export const getDefaultWorkflowResponseSchema = defaultWorkflowSchema;

export const getDefaultWorkflowErrorSchema = z.unknown();

export const updateDefaultWorkflowDataSchema = z.object({
  body: defaultWorkflowSchema,
  path: z.object({
    id: z.number(),
  }),
});

export const updateDefaultWorkflowResponseSchema = workflowSchemeSchema;

export const updateDefaultWorkflowErrorSchema = z.unknown();

export const deleteWorkflowSchemeDraftDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const deleteWorkflowSchemeDraftResponseSchema = z.any();

export const deleteWorkflowSchemeDraftErrorSchema = z.unknown();

export const getWorkflowSchemeDraftDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const getWorkflowSchemeDraftResponseSchema = workflowSchemeSchema;

export const getWorkflowSchemeDraftErrorSchema = z.unknown();

export const updateWorkflowSchemeDraftDataSchema = z.object({
  body: workflowSchemeSchema,
  path: z.object({
    id: z.number(),
  }),
});

export const updateWorkflowSchemeDraftResponseSchema = workflowSchemeSchema;

export const updateWorkflowSchemeDraftErrorSchema = z.unknown();

export const deleteDraftDefaultWorkflowDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const deleteDraftDefaultWorkflowResponseSchema = workflowSchemeSchema;

export const deleteDraftDefaultWorkflowErrorSchema = z.unknown();

export const getDraftDefaultWorkflowDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
});

export const getDraftDefaultWorkflowResponseSchema = defaultWorkflowSchema;

export const getDraftDefaultWorkflowErrorSchema = z.unknown();

export const updateDraftDefaultWorkflowDataSchema = z.object({
  body: defaultWorkflowSchema,
  path: z.object({
    id: z.number(),
  }),
});

export const updateDraftDefaultWorkflowResponseSchema = workflowSchemeSchema;

export const updateDraftDefaultWorkflowErrorSchema = z.unknown();

export const deleteWorkflowSchemeDraftIssueTypeDataSchema = z.object({
  path: z.object({
    id: z.number(),
    issueType: z.string(),
  }),
});

export const deleteWorkflowSchemeDraftIssueTypeResponseSchema = workflowSchemeSchema;

export const deleteWorkflowSchemeDraftIssueTypeErrorSchema = z.unknown();

export const getWorkflowSchemeDraftIssueTypeDataSchema = z.object({
  path: z.object({
    id: z.number(),
    issueType: z.string(),
  }),
});

export const getWorkflowSchemeDraftIssueTypeResponseSchema = issueTypeWorkflowMappingSchema;

export const getWorkflowSchemeDraftIssueTypeErrorSchema = z.unknown();

export const setWorkflowSchemeDraftIssueTypeDataSchema = z.object({
  body: issueTypeWorkflowMappingSchema,
  path: z.object({
    id: z.number(),
    issueType: z.string(),
  }),
});

export const setWorkflowSchemeDraftIssueTypeResponseSchema = workflowSchemeSchema;

export const setWorkflowSchemeDraftIssueTypeErrorSchema = z.unknown();

export const publishDraftWorkflowSchemeSchema = z.object({
  statusMappings: z.array(statusMappingSchema).optional(),
});

export const publishDraftWorkflowSchemeResponseSchema = z.any();

export const publishDraftWorkflowSchemeErrorSchema = z.union([taskProgressBeanObjectSchema, z.unknown()]);

export const deleteDraftWorkflowMappingDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
  query: z.object({
    workflowName: z.string(),
  }),
});

export const deleteDraftWorkflowMappingResponseSchema = z.unknown();

export const deleteDraftWorkflowMappingErrorSchema = z.unknown();

export const getDraftWorkflowDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
  query: z
    .object({
      workflowName: z.string().optional(),
    })
    .optional(),
});

export const getDraftWorkflowResponseSchema = issueTypesWorkflowMappingSchema;

export const getDraftWorkflowErrorSchema = z.unknown();

export const updateDraftWorkflowMappingDataSchema = z.object({
  body: issueTypesWorkflowMappingSchema,
  path: z.object({
    id: z.number(),
  }),
  query: z.object({
    workflowName: z.string(),
  }),
});

export const updateDraftWorkflowMappingResponseSchema = workflowSchemeSchema;

export const updateDraftWorkflowMappingErrorSchema = z.unknown();

export const deleteWorkflowSchemeIssueTypeDataSchema = z.object({
  path: z.object({
    id: z.number(),
    issueType: z.string(),
  }),
  query: z
    .object({
      updateDraftIfNeeded: z.boolean().optional(),
    })
    .optional(),
});

export const deleteWorkflowSchemeIssueTypeResponseSchema = workflowSchemeSchema;

export const deleteWorkflowSchemeIssueTypeErrorSchema = z.unknown();

export const getWorkflowSchemeIssueTypeDataSchema = z.object({
  path: z.object({
    id: z.number(),
    issueType: z.string(),
  }),
  query: z
    .object({
      returnDraftIfExists: z.boolean().optional(),
    })
    .optional(),
});

export const getWorkflowSchemeIssueTypeResponseSchema = issueTypeWorkflowMappingSchema;

export const getWorkflowSchemeIssueTypeErrorSchema = z.unknown();

export const setWorkflowSchemeIssueTypeDataSchema = z.object({
  body: issueTypeWorkflowMappingSchema,
  path: z.object({
    id: z.number(),
    issueType: z.string(),
  }),
});

export const setWorkflowSchemeIssueTypeResponseSchema = workflowSchemeSchema;

export const setWorkflowSchemeIssueTypeErrorSchema = z.unknown();

export const deleteWorkflowMappingDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
  query: z.object({
    updateDraftIfNeeded: z.boolean().optional(),
    workflowName: z.string(),
  }),
});

export const deleteWorkflowMappingResponseSchema = z.unknown();

export const deleteWorkflowMappingErrorSchema = z.unknown();

export const getWorkflowDataSchema = z.object({
  path: z.object({
    id: z.number(),
  }),
  query: z
    .object({
      returnDraftIfExists: z.boolean().optional(),
      workflowName: z.string().optional(),
    })
    .optional(),
});

export const getWorkflowResponseSchema = issueTypesWorkflowMappingSchema;

export const getWorkflowErrorSchema = z.unknown();

export const updateWorkflowMappingDataSchema = z.object({
  body: issueTypesWorkflowMappingSchema,
  path: z.object({
    id: z.number(),
  }),
  query: z.object({
    workflowName: z.string(),
  }),
});

export const updateWorkflowMappingResponseSchema = workflowSchemeSchema;

export const updateWorkflowMappingErrorSchema = z.unknown();

export const getIdsOfWorklogsDeletedSinceDataSchema = z.object({
  query: z
    .object({
      since: z.number().optional(),
    })
    .optional(),
});

export const changedWorklogsSchema = z.object({
  lastPage: z.boolean().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  since: z.number().optional(),
  until: z.number().optional(),
  values: z.array(changedWorklogSchema).optional(),
});

export const getIdsOfWorklogsDeletedSinceErrorSchema = z.unknown();

export const getWorklogsForIdsDataSchema = z.object({
  body: worklogIdsRequestBeanSchema,
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const getWorklogsForIdsResponseSchema = z.array(worklogSchema);

export const getWorklogsForIdsErrorSchema = z.unknown();

export const getIdsOfWorklogsModifiedSinceDataSchema = z.object({
  query: z
    .object({
      expand: z.string().optional(),
      since: z.number().optional(),
    })
    .optional(),
});

export const getIdsOfWorklogsModifiedSinceResponseSchema = changedWorklogsSchema;

export const getIdsOfWorklogsModifiedSinceErrorSchema = z.unknown();

export const addonPropertiesResourceGetAddonPropertiesGetDataSchema = z.object({
  path: z.object({
    addonKey: z.string(),
  }),
});

export const addonPropertiesResourceGetAddonPropertiesGetResponseSchema = propertyKeysSchema;

export const addonPropertiesResourceGetAddonPropertiesGetErrorSchema = operationMessageSchema;

export const addonPropertiesResourceDeleteAddonPropertyDeleteDataSchema = z.object({
  path: z.object({
    addonKey: z.string(),
    propertyKey: z.string(),
  }),
});

export const addonPropertiesResourceDeleteAddonPropertyDeleteResponseSchema = z.any();

export const addonPropertiesResourceDeleteAddonPropertyDeleteErrorSchema = operationMessageSchema;

export const addonPropertiesResourceGetAddonPropertyGetDataSchema = z.object({
  path: z.object({
    addonKey: z.string(),
    propertyKey: z.string(),
  }),
});

export const addonPropertiesResourceGetAddonPropertyGetResponseSchema = entityPropertySchema;

export const addonPropertiesResourceGetAddonPropertyGetErrorSchema = operationMessageSchema;

export const addonPropertiesResourcePutAddonPropertyPutDataSchema = z.object({
  body: z.string().optional(),
  path: z.object({
    addonKey: z.string(),
    propertyKey: z.string(),
  }),
});

export const addonPropertiesResourcePutAddonPropertyPutResponseSchema = operationMessageSchema;

export const addonPropertiesResourcePutAddonPropertyPutErrorSchema = operationMessageSchema;

export const dynamicModulesResourceRemoveModulesDeleteDataSchema = z.object({
  query: z
    .object({
      moduleKey: z.array(z.string()).optional(),
    })
    .optional(),
});

export const dynamicModulesResourceRemoveModulesDeleteResponseSchema = z.any();

export const dynamicModulesResourceRemoveModulesDeleteErrorSchema = errorMessageSchema;

export const dynamicModulesResourceGetModulesGetResponseSchema = connectModulesSchema;

export const dynamicModulesResourceGetModulesGetErrorSchema = errorMessageSchema;

export const dynamicModulesResourceRegisterModulesPostDataSchema = z.object({
  body: connectModulesSchema,
});

export const dynamicModulesResourceRegisterModulesPostResponseSchema = z.unknown();

export const dynamicModulesResourceRegisterModulesPostErrorSchema = errorMessageSchema;

export const appIssueFieldValueUpdateResourceUpdateIssueFieldsPutDataSchema = z.object({
  body: connectCustomFieldValuesSchema,
  headers: z.object({
    'Atlassian-Transfer-Id': z.string(),
  }),
});

export const appIssueFieldValueUpdateResourceUpdateIssueFieldsPutResponseSchema = z.unknown();

export const appIssueFieldValueUpdateResourceUpdateIssueFieldsPutErrorSchema = z.unknown();

export const migrationResourceUpdateEntityPropertiesValuePutDataSchema = z.object({
  body: z.array(entityPropertyDetailsSchema),
  headers: z.object({
    'Atlassian-Transfer-Id': z.string(),
  }),
  path: z.object({
    entityType: z.union([
      z.literal('IssueProperty'),
      z.literal('CommentProperty'),
      z.literal('DashboardItemProperty'),
      z.literal('IssueTypeProperty'),
      z.literal('ProjectProperty'),
      z.literal('UserProperty'),
      z.literal('WorklogProperty'),
      z.literal('BoardProperty'),
      z.literal('SprintProperty'),
    ]),
  }),
});

export const migrationResourceUpdateEntityPropertiesValuePutResponseSchema = z.unknown();

export const migrationResourceUpdateEntityPropertiesValuePutErrorSchema = z.unknown();

export const migrationResourceWorkflowRuleSearchPostDataSchema = z.object({
  body: workflowRulesSearchSchema,
  headers: z.object({
    'Atlassian-Transfer-Id': z.string(),
  }),
});

export const workflowRulesSearchDetailsSchema = z.object({
  invalidRules: z.array(z.string()).optional(),
  validRules: z.array(workflowTransitionRulesSchema).optional(),
  workflowEntityId: z.string().optional(),
});

export const migrationResourceWorkflowRuleSearchPostErrorSchema = z.unknown();

export const serviceRegistryResourceServicesGetDataSchema = z.object({
  query: z.object({
    serviceIds: z.array(z.string()),
  }),
});

export const serviceRegistrySchema = z.object({
  description: z.string().optional().nullable(),
  id: z.string().optional(),
  name: z.string().optional(),
  organizationId: z.string().optional(),
  revision: z.string().optional(),
  serviceTier: serviceRegistryTierSchema.optional(),
});

export const serviceRegistryResourceServicesGetErrorSchema = z.unknown();

export const deleteForgeAppPropertyDataSchema = z.object({
  path: z.object({
    propertyKey: z.string(),
  }),
});

export const deleteForgeAppPropertyResponseSchema = z.any();

export const deleteForgeAppPropertyErrorSchema = z.union([operationMessageSchema, z.unknown()]);

export const putForgeAppPropertyDataSchema = z.object({
  body: z.string().optional(),
  path: z.object({
    propertyKey: z.string(),
  }),
});

export const putForgeAppPropertyResponseSchema = operationMessageSchema;

export const putForgeAppPropertyErrorSchema = z.union([operationMessageSchema, z.unknown()]);

export const notificationSchemeEventDetailsSchema = z.object({
  event: notificationSchemeEventTypeIdSchema,
  notifications: z.array(notificationSchemeNotificationDetailsSchema),
});

export const securitySchemeLevelBeanSchema = z.object({
  description: z.string().optional(),
  isDefault: z.boolean().optional(),
  members: z.array(securitySchemeLevelMemberBeanSchema).optional(),
  name: z.string(),
});

export const attachmentArchiveSchema = z.object({
  entries: z.array(attachmentArchiveEntrySchema).optional(),
  moreAvailable: z.boolean().optional(),
  totalEntryCount: z.number().optional(),
  totalNumberOfEntriesAvailable: z.number().optional(),
});

export const issueBulkEditFieldSchema = z.object({
  description: z.string().optional(),
  fieldOptions: z.array(issueBulkOperationsFieldOptionSchema).optional(),
  id: z.string().optional(),
  isRequired: z.boolean().optional(),
  multiSelectFieldOptions: z
    .array(z.union([z.literal('ADD'), z.literal('REMOVE'), z.literal('REPLACE'), z.literal('REMOVE_ALL')]))
    .optional(),
  name: z.string().optional(),
  searchUrl: z.string().optional(),
  type: z.string().optional(),
  unavailableMessage: z.string().optional(),
});

export const componentWithIssueCountSchema = z.object({
  assignee: userSchema.optional(),
  assigneeType: z
    .union([
      z.literal('PROJECT_DEFAULT'),
      z.literal('COMPONENT_LEAD'),
      z.literal('PROJECT_LEAD'),
      z.literal('UNASSIGNED'),
    ])
    .optional(),
  description: z.string().optional(),
  id: z.string().optional(),
  isAssigneeTypeValid: z.boolean().optional(),
  issueCount: z.number().optional(),
  lead: userSchema.optional(),
  name: z.string().optional(),
  project: z.string().optional(),
  projectId: z.number().optional(),
  realAssignee: userSchema.optional(),
  realAssigneeType: z
    .union([
      z.literal('PROJECT_DEFAULT'),
      z.literal('COMPONENT_LEAD'),
      z.literal('PROJECT_LEAD'),
      z.literal('UNASSIGNED'),
    ])
    .optional(),
  self: z.string().optional(),
});

export const createIssueSecuritySchemeDetailsSchema = z.object({
  description: z.string().optional(),
  levels: z.array(securitySchemeLevelBeanSchema).optional(),
  name: z.string(),
});

export const createNotificationSchemeDetailsSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
  notificationSchemeEvents: z.array(notificationSchemeEventDetailsSchema).optional(),
});

export const createWorkflowTransitionDetailsSchema = z.object({
  description: z.string().optional(),
  from: z.array(z.string()).optional(),
  name: z.string(),
  properties: z.record(z.string()).optional(),
  rules: createWorkflowTransitionRulesDetailsSchema.optional(),
  screen: createWorkflowTransitionScreenDetailsSchema.optional(),
  to: z.string(),
  type: z.union([z.literal('global'), z.literal('initial'), z.literal('directed')]),
});

export const nestedResponseSchema = z.object({
  errorCollection: errorCollectionSchema.optional(),
  status: z.number().optional(),
  warningCollection: warningCollectionSchema.optional(),
});

export const createdIssueSchema = z.object({
  id: z.string().optional(),
  key: z.string().optional(),
  self: z.string().optional(),
  transition: nestedResponseSchema.optional(),
  watchers: nestedResponseSchema.optional(),
});

export const customFieldContextDefaultValueForgeUserFieldSchema = z.object({
  accountId: z.string(),
  contextId: z.string(),
  type: z.literal('forge.user'),
  userFilter: userFilterSchema,
});

export const customFieldContextDefaultValueSchema = z.union([
  customFieldContextDefaultValueCascadingOptionSchema,
  customFieldContextDefaultValueMultipleOptionSchema,
  customFieldContextDefaultValueSingleOptionSchema,
  customFieldContextSingleUserPickerDefaultsSchema,
  customFieldContextDefaultValueMultiUserPickerSchema,
  customFieldContextDefaultValueSingleGroupPickerSchema,
  customFieldContextDefaultValueMultipleGroupPickerSchema,
  customFieldContextDefaultValueDateSchema,
  customFieldContextDefaultValueDateTimeSchema,
  customFieldContextDefaultValueURLSchema,
  customFieldContextDefaultValueProjectSchema,
  customFieldContextDefaultValueFloatSchema,
  customFieldContextDefaultValueLabelsSchema,
  customFieldContextDefaultValueTextFieldSchema,
  customFieldContextDefaultValueTextAreaSchema,
  customFieldContextDefaultValueReadOnlySchema,
  customFieldContextDefaultValueSingleVersionPickerSchema,
  customFieldContextDefaultValueMultipleVersionPickerSchema,
  customFieldContextDefaultValueForgeStringFieldSchema,
  customFieldContextDefaultValueForgeMultiStringFieldSchema,
  customFieldContextDefaultValueForgeObjectFieldSchema,
  customFieldContextDefaultValueForgeDateTimeFieldSchema,
  customFieldContextDefaultValueForgeGroupFieldSchema,
  customFieldContextDefaultValueForgeMultiGroupFieldSchema,
  customFieldContextDefaultValueForgeNumberFieldSchema,
  customFieldContextDefaultValueForgeUserFieldSchema,
  customFieldContextDefaultValueForgeMultiUserFieldSchema,
]);

export const userBeanSchema = z.object({
  accountId: z.string().optional(),
  active: z.boolean().optional(),
  avatarUrls: userBeanAvatarUrlsSchema.optional(),
  displayName: z.string().optional(),
  key: z.string().optional(),
  name: z.string().optional(),
  self: z.string().optional(),
});

export const eventNotificationSchema = z.object({
  emailAddress: z.string().optional(),
  expand: z.string().optional(),
  field: fieldDetailsSchema.optional(),
  group: groupNameSchema.optional(),
  id: z.number().optional(),
  notificationType: z
    .union([
      z.literal('CurrentAssignee'),
      z.literal('Reporter'),
      z.literal('CurrentUser'),
      z.literal('ProjectLead'),
      z.literal('ComponentLead'),
      z.literal('User'),
      z.literal('Group'),
      z.literal('ProjectRole'),
      z.literal('EmailAddress'),
      z.literal('AllWatchers'),
      z.literal('UserCustomField'),
      z.literal('GroupCustomField'),
    ])
    .optional(),
  parameter: z.string().optional(),
  projectRole: projectRoleSchema.optional(),
  recipient: z.string().optional(),
  user: userDetailsSchema.optional(),
});

export const jqlQueryClauseOperandSchema = z.union([
  listOperandSchema,
  valueOperandSchema,
  functionOperandSchema,
  keywordOperandSchema,
]);

export const jqlQueryClauseTimePredicateSchema = z.object({
  operand: jqlQueryClauseOperandSchema,
  operator: z.union([
    z.literal('before'),
    z.literal('after'),
    z.literal('from'),
    z.literal('to'),
    z.literal('on'),
    z.literal('during'),
    z.literal('by'),
  ]),
});

export const linkedIssueFieldSchema = z.object({
  assignee: userDetailsSchema.optional(),
  issueType: issueTypeDetailsSchema.optional(),
  issuetype: issueTypeDetailsSchema.optional(),
  priority: prioritySchema.optional(),
  status: statusDetailsSchema.optional(),
  summary: z.string().optional(),
  timetracking: timeTrackingDetailsSchema.optional(),
});

export const userListSchema = z.object({
  'end-index': z.number().optional(),
  items: z.array(userSchema).optional(),
  'max-results': z.number().optional(),
  size: z.number().optional(),
  'start-index': z.number().optional(),
});

export const filterSubscriptionSchema = z.object({
  group: groupNameSchema.optional(),
  id: z.number().optional(),
  user: userSchema.optional(),
});

export const filterSubscriptionsListSchema = z.object({
  'end-index': z.number().optional(),
  items: z.array(filterSubscriptionSchema).optional(),
  'max-results': z.number().optional(),
  size: z.number().optional(),
  'start-index': z.number().optional(),
});

export const operationsSchema = z.object({
  linkGroups: z.array(linkGroupSchema).optional(),
});

export const issueFieldOptionScopeBeanSchema = z.object({
  global: globalScopeBeanSchema.optional(),
  projects: z.array(z.number()).optional(),
  projects2: z.array(projectScopeBeanSchema).optional(),
});

export const issueFieldOptionConfigurationSchema = z.object({
  attributes: z.array(z.union([z.literal('notSelectable'), z.literal('defaultValue')])).optional(),
  scope: issueFieldOptionScopeBeanSchema.optional(),
});

export const linkedIssueSchema = z.object({
  fields: linkedIssueFieldSchema.optional(),
  id: z.string().optional(),
  key: z.string().optional(),
  self: z.string().optional(),
});

export const issuePickerSuggestionsIssueTypeSchema = z.object({
  id: z.string().optional(),
  issues: z.array(suggestedIssueSchema).optional(),
  label: z.string().optional(),
  msg: z.string().optional(),
  sub: z.string().optional(),
});

export const jiraExpressionsComplexityBeanSchema = z.object({
  beans: jiraExpressionsComplexityValueBeanSchema,
  expensiveOperations: jiraExpressionsComplexityValueBeanSchema,
  primitiveValues: jiraExpressionsComplexityValueBeanSchema,
  steps: jiraExpressionsComplexityValueBeanSchema,
});

export const jiraExpressionEvaluationMetaDataBeanSchema = z.object({
  complexity: jiraExpressionsComplexityBeanSchema.optional(),
  issues: issuesMetaBeanSchema.optional(),
});

export const jiraExpressionResultSchema = z.object({
  meta: jiraExpressionEvaluationMetaDataBeanSchema.optional(),
  value: z.string().optional(),
});

export const jiraLabelsFieldSchema = z.object({
  bulkEditMultiSelectFieldOption: z.union([
    z.literal('ADD'),
    z.literal('REMOVE'),
    z.literal('REPLACE'),
    z.literal('REMOVE_ALL'),
  ]),
  fieldId: z.string(),
  labels: z.array(jiraLabelsInputSchema),
});

export const jiraMultipleSelectUserPickerFieldSchema = z.object({
  fieldId: z.string(),
  users: z.array(jiraUserFieldSchema).optional(),
});

export const jiraMultipleVersionPickerFieldSchema = z.object({
  bulkEditMultiSelectFieldOption: z.union([
    z.literal('ADD'),
    z.literal('REMOVE'),
    z.literal('REPLACE'),
    z.literal('REMOVE_ALL'),
  ]),
  fieldId: z.string(),
  versions: z.array(jiraVersionFieldSchema),
});

export const jiraRichTextFieldSchema = z.object({
  fieldId: z.string(),
  richText: jiraRichTextInputSchema,
});

export const workflowReferenceStatusSchema = z.object({
  approvalConfiguration: approvalConfigurationSchema.optional(),
  deprecated: z.boolean().optional(),
  layout: workflowStatusLayoutSchema.optional(),
  properties: z.record(z.string()).optional(),
  statusReference: z.string().optional(),
});

export const workflowTransitionsSchema = z.object({
  actions: z.array(workflowRuleConfigurationSchema).optional(),
  conditions: conditionGroupConfigurationSchema.optional(),
  customIssueEventId: z.string().optional().nullable(),
  description: z.string().optional(),
  from: z.array(workflowStatusAndPortSchema).optional(),
  id: z.string().optional(),
  links: z.array(workflowTransitionLinksSchema).optional(),
  name: z.string().optional(),
  properties: z.record(z.string()).optional(),
  to: workflowStatusAndPortSchema.optional(),
  toStatusReference: z.string().optional(),
  transitionScreen: workflowRuleConfigurationSchema.optional(),
  triggers: z.array(workflowTriggerSchema).optional(),
  type: z.union([z.literal('INITIAL'), z.literal('GLOBAL'), z.literal('DIRECTED')]).optional(),
  validators: z.array(workflowRuleConfigurationSchema).optional(),
});

export const fieldValueClauseSchema = z.object({
  field: jqlQueryFieldSchema,
  operand: jqlQueryClauseOperandSchema,
  operator: z.union([
    z.literal('='),
    z.literal('!='),
    z.literal('>'),
    z.literal('<'),
    z.literal('>='),
    z.literal('<='),
    z.literal('in'),
    z.literal('not in'),
    z.literal('~'),
    z.literal('~='),
    z.literal('is'),
    z.literal('is not'),
  ]),
});

export const fieldWasClauseSchema = z.object({
  field: jqlQueryFieldSchema,
  operand: jqlQueryClauseOperandSchema,
  operator: z.union([z.literal('was'), z.literal('was in'), z.literal('was not in'), z.literal('was not')]),
  predicates: z.array(jqlQueryClauseTimePredicateSchema),
});

export const fieldChangedClauseSchema = z.object({
  field: jqlQueryFieldSchema,
  operator: z.literal('changed'),
  predicates: z.array(jqlQueryClauseTimePredicateSchema),
});

export const jqlQueryOrderByClauseElementSchema = z.object({
  direction: z.union([z.literal('asc'), z.literal('desc')]).optional(),
  field: jqlQueryFieldSchema,
});

export const legacyJackson1ListAttachmentSchema = z.array(attachmentSchema);

export const legacyJackson1ListIssueTypeWithStatusSchema = z.array(issueTypeWithStatusSchema);

export const projectSchema = z.object({
  archived: z.boolean().optional(),
  archivedBy: userSchema.optional(),
  archivedDate: z.string().optional(),
  assigneeType: z.union([z.literal('PROJECT_LEAD'), z.literal('UNASSIGNED')]).optional(),
  avatarUrls: avatarUrlsBeanSchema.optional(),
  components: z.array(projectComponentSchema).optional(),
  deleted: z.boolean().optional(),
  deletedBy: userSchema.optional(),
  deletedDate: z.string().optional(),
  description: z.string().optional(),
  email: z.string().optional(),
  expand: z.string().optional(),
  favourite: z.boolean().optional(),
  id: z.string().optional(),
  insight: projectInsightSchema.optional(),
  isPrivate: z.boolean().optional(),
  issueTypeHierarchy: hierarchySchema.optional(),
  issueTypes: z.array(issueTypeDetailsSchema).optional(),
  key: z.string().optional(),
  landingPageInfo: projectLandingPageInfoSchema.optional(),
  lead: userSchema.optional(),
  name: z.string().optional(),
  permissions: projectPermissionsSchema.optional(),
  projectCategory: projectCategorySchema.optional(),
  projectTypeKey: z.union([z.literal('software'), z.literal('service_desk'), z.literal('business')]).optional(),
  properties: z.record(z.string()).optional(),
  retentionTillDate: z.string().optional(),
  roles: z.record(z.string()).optional(),
  self: z.string().optional(),
  simplified: z.boolean().optional(),
  style: z.union([z.literal('classic'), z.literal('next-gen')]).optional(),
  url: z.string().optional(),
  uuid: z.string().optional(),
  versions: z.array(versionSchema).optional(),
});

export const legacyJackson1ListProjectComponentSchema = z.array(projectComponentSchema);

export const legacyJackson1ListProjectRoleDetailsSchema = z.array(projectRoleDetailsSchema);

export const legacyJackson1ListProjectTypeSchema = z.array(projectTypeSchema);

export const legacyJackson1ListUserMigrationBeanSchema = z.array(userMigrationBeanSchema);

export const legacyJackson1ListVersionSchema = z.array(versionSchema);

export const legacyJackson1ListWorklogSchema = z.array(worklogSchema);

export const linkIssueRequestJsonBeanSchema = z.object({
  comment: commentSchema.optional(),
  inwardIssue: linkedIssueSchema,
  outwardIssue: linkedIssueSchema,
  type: issueLinkTypeSchema,
});

export const notificationRecipientsRestrictionsSchema = z.object({
  groupIds: z.array(z.string()).optional(),
  groups: z.array(groupNameSchema).optional(),
  permissions: z.array(restrictedPermissionSchema).optional(),
});

export const notificationSchemeEventSchema = z.object({
  event: notificationEventSchema.optional(),
  notifications: z.array(eventNotificationSchema).optional(),
});

export const pageBeanComponentWithIssueCountSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(componentWithIssueCountSchema).optional(),
});

export const pageBeanCustomFieldContextDefaultValueSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(customFieldContextDefaultValueSchema).optional(),
});

export const issueFieldOptionSchema = z.object({
  config: issueFieldOptionConfigurationSchema.optional(),
  id: z.number(),
  properties: z.record(z.string()).optional(),
  value: z.string(),
});

export const notificationSchemeSchema = z.object({
  description: z.string().optional(),
  expand: z.string().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  notificationSchemeEvents: z.array(notificationSchemeEventSchema).optional(),
  projects: z.array(z.number()).optional(),
  scope: scopeSchema.optional(),
  self: z.string().optional(),
});

export const prioritySchemeWithPaginatedPrioritiesAndProjectsSchema = z.object({
  default: z.boolean().optional(),
  defaultPriorityId: z.string().optional(),
  description: z.string().optional(),
  id: z.string(),
  isDefault: z.boolean().optional(),
  name: z.string(),
  priorities: pageBeanPriorityWithSequenceSchema.optional(),
  projects: pageBeanProjectDetailsSchema.optional(),
  self: z.string().optional(),
});

export const pageBeanProjectSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(projectSchema).optional(),
});

export const screenSchemeSchema = z.object({
  description: z.string().optional(),
  id: z.number().optional(),
  issueTypeScreenSchemes: pageBeanIssueTypeScreenSchemeSchema.optional(),
  name: z.string().optional(),
  screens: screenTypesSchema.optional(),
});

export const screenWithTabSchema = z.object({
  description: z.string().optional(),
  id: z.number().optional(),
  name: z.string().optional(),
  scope: scopeSchema.optional(),
  tab: screenableTabSchema.optional(),
});

export const pageBeanVersionSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(versionSchema).optional(),
});

export const sharePermissionSchema = z.object({
  group: groupNameSchema.optional(),
  id: z.number().optional(),
  project: projectSchema.optional(),
  role: projectRoleSchema.optional(),
  type: z.union([
    z.literal('user'),
    z.literal('group'),
    z.literal('project'),
    z.literal('projectRole'),
    z.literal('global'),
    z.literal('loggedin'),
    z.literal('authenticated'),
    z.literal('project-unknown'),
  ]),
  user: userBeanSchema.optional(),
});

export const issueBeanSchema = z.object({
  changelog: pageOfChangelogsSchema.optional(),
  editmeta: issueUpdateMetadataSchema.optional(),
  expand: z.string().optional(),
  fields: z.record(z.string()).optional(),
  fieldsToInclude: includedFieldsSchema.optional(),
  id: z.string().optional(),
  key: z.string().optional(),
  names: z.record(z.string()).optional(),
  operations: operationsSchema.optional(),
  properties: z.record(z.string()).optional(),
  renderedFields: z.record(z.string()).optional(),
  schema: z.record(jsonTypeBeanSchema).optional(),
  self: z.string().optional(),
  transitions: z.array(issueTransitionSchema).optional(),
  versionedRepresentations: z.record(z.record(z.string())).optional(),
});

export const searchResultsSchema = z.object({
  expand: z.string().optional(),
  issues: z.array(issueBeanSchema).optional(),
  maxResults: z.number().optional(),
  names: z.record(z.string()).optional(),
  schema: z.record(jsonTypeBeanSchema).optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  warningMessages: z.array(z.string()).optional(),
});

export const taskProgressBeanRemoveOptionFromIssuesResultSchema = z.object({
  description: z.string().optional(),
  elapsedRuntime: z.number(),
  finished: z.number().optional(),
  id: z.string(),
  lastUpdate: z.number(),
  message: z.string().optional(),
  progress: z.number(),
  result: removeOptionFromIssuesResultSchema.optional(),
  self: z.string(),
  started: z.number().optional(),
  status: z.union([
    z.literal('ENQUEUED'),
    z.literal('RUNNING'),
    z.literal('COMPLETE'),
    z.literal('FAILED'),
    z.literal('CANCEL_REQUESTED'),
    z.literal('CANCELLED'),
    z.literal('DEAD'),
  ]),
  submitted: z.number(),
  submittedBy: z.number(),
});

export const updatePrioritySchemeResponseBeanSchema = z.object({
  priorityScheme: prioritySchemeWithPaginatedPrioritiesAndProjectsSchema.optional(),
  task: taskProgressBeanJsonNodeSchema.optional(),
});

export const jiraWorkflowSchema = z.object({
  description: z.string().optional(),
  id: z.string().optional(),
  isEditable: z.boolean().optional(),
  name: z.string().optional(),
  scope: workflowScopeSchema.optional(),
  startPointLayout: workflowLayoutSchema.optional(),
  statuses: z.array(workflowReferenceStatusSchema).optional(),
  taskId: z.string().optional().nullable(),
  transitions: z.array(workflowTransitionsSchema).optional(),
  usages: z.array(projectIssueTypesSchema).optional(),
  version: documentVersionSchema.optional(),
});

export const workflowReadResponseSchema = z.object({
  statuses: z.array(jiraWorkflowStatusSchema).optional(),
  workflows: z.array(jiraWorkflowSchema).optional(),
});

export const workflowUpdateResponseSchema = z.object({
  statuses: z.array(jiraWorkflowStatusSchema).optional(),
  taskId: z.string().optional().nullable(),
  workflows: z.array(jiraWorkflowSchema).optional(),
});

export const getAttachmentResponseSchema = attachmentMetadataSchema;

export const getAuditRecordsResponseSchema = auditRecordsSchema;

export const bulkEditGetFieldsSchema = z.object({
  endingBefore: z.string().optional(),
  fields: z.array(issueBulkEditFieldSchema).optional(),
  startingAfter: z.string().optional(),
});

export const getBulkEditableFieldsErrorSchema = bulkOperationErrorResponseSchema;

export const submitBulkMoveDataSchema = z.object({
  body: issueBulkMovePayloadSchema,
});

export const getBulkOperationProgressResponseSchema = bulkOperationProgressSchema;

export const getAllUserDataClassificationLevelsResponseSchema = dataClassificationLevelsBeanSchema;

export const createComponentDataSchema = z.object({
  body: projectComponentSchema,
});

export const getConfigurationResponseSchema = configurationSchema;

export const dashboardDetailsSchema = z.object({
  description: z.string().optional(),
  editPermissions: z.array(sharePermissionSchema),
  name: z.string(),
  sharePermissions: z.array(sharePermissionSchema),
});

export const dashboardSchema = z.object({
  automaticRefreshMs: z.number().optional(),
  description: z.string().optional(),
  editPermissions: z.array(sharePermissionSchema).optional(),
  id: z.string().optional(),
  isFavourite: z.boolean().optional(),
  isWritable: z.boolean().optional(),
  name: z.string().optional(),
  owner: userBeanSchema.optional(),
  popularity: z.number().optional(),
  rank: z.number().optional(),
  self: z.string().optional(),
  sharePermissions: z.array(sharePermissionSchema).optional(),
  systemDashboard: z.boolean().optional(),
  view: z.string().optional(),
});

export const pageBeanDashboardSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(dashboardSchema).optional(),
});

export const getAllGadgetsResponseSchema = dashboardGadgetResponseSchema;

export const getDashboardResponseSchema = dashboardSchema;

export const updateDashboardDataSchema = z.object({
  body: dashboardDetailsSchema,
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      extendAdminPermissions: z.boolean().optional(),
    })
    .optional(),
});

export const updateDashboardResponseSchema = dashboardSchema;

export const copyDashboardDataSchema = z.object({
  body: dashboardDetailsSchema,
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      extendAdminPermissions: z.boolean().optional(),
    })
    .optional(),
});

export const copyDashboardResponseSchema = dashboardSchema;

export const getPoliciesResponseSchema = projectDataPoliciesSchema;

export const analyseExpressionResponseSchema = jiraExpressionsAnalysisSchema;

export const evaluateJiraExpressionDataSchema = z.object({
  body: jiraExpressionEvalRequestBeanSchema,
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const evaluateJiraExpressionResponseSchema = jiraExpressionResultSchema;

export const evaluateJsisJiraExpressionDataSchema = z.object({
  body: jiraExpressionEvaluateRequestBeanSchema,
  query: z
    .object({
      expand: z.string().optional(),
    })
    .optional(),
});

export const getFieldsPaginatedResponseSchema = pageBeanFieldSchema;

export const getDefaultValuesResponseSchema = pageBeanCustomFieldContextDefaultValueSchema;

export const customFieldContextDefaultValueUpdateSchema = z.object({
  defaultValues: z.array(customFieldContextDefaultValueSchema).optional(),
});

export const createCustomFieldOptionDataSchema = z.object({
  body: bulkCustomFieldOptionCreateRequestSchema,
  path: z.object({
    contextId: z.number(),
    fieldId: z.string(),
  }),
});

export const updateCustomFieldOptionDataSchema = z.object({
  body: bulkCustomFieldOptionUpdateRequestSchema,
  path: z.object({
    contextId: z.number(),
    fieldId: z.string(),
  }),
});

export const getContextsForFieldDeprecatedResponseSchema = pageBeanContextSchema;

export const pageBeanScreenWithTabSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(screenWithTabSchema).optional(),
});

export const pageBeanIssueFieldOptionSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(issueFieldOptionSchema).optional(),
});

export const issueFieldOptionCreateBeanSchema = z.object({
  config: issueFieldOptionConfigurationSchema.optional(),
  properties: z.record(z.string()).optional(),
  value: z.string(),
});

export const createIssueFieldOptionResponseSchema = issueFieldOptionSchema;

export const getSelectableIssueFieldOptionsResponseSchema = pageBeanIssueFieldOptionSchema;

export const getVisibleIssueFieldOptionsResponseSchema = pageBeanIssueFieldOptionSchema;

export const getIssueFieldOptionResponseSchema = issueFieldOptionSchema;

export const updateIssueFieldOptionDataSchema = z.object({
  body: issueFieldOptionSchema,
  path: z.object({
    fieldKey: z.string(),
    optionId: z.number(),
  }),
});

export const updateIssueFieldOptionResponseSchema = issueFieldOptionSchema;

export const setFieldConfigurationSchemeMappingDataSchema = z.object({
  body: associateFieldConfigurationsWithIssueTypesRequestSchema,
  path: z.object({
    id: z.number(),
  }),
});

export const filterSchema = z.object({
  approximateLastUsed: z.string().optional(),
  description: z.string().optional(),
  editPermissions: z.array(sharePermissionSchema).optional(),
  favourite: z.boolean().optional(),
  favouritedCount: z.number().optional(),
  id: z.string().optional(),
  jql: z.string().optional(),
  name: z.string(),
  owner: userSchema.optional(),
  searchUrl: z.string().optional(),
  self: z.string().optional(),
  sharePermissions: z.array(sharePermissionSchema).optional(),
  sharedUsers: userListSchema.optional(),
  subscriptions: filterSubscriptionsListSchema.optional(),
  viewUrl: z.string().optional(),
});

export const createFilterResponseSchema = filterSchema;

export const getFavouriteFiltersResponseSchema = z.array(filterSchema);

export const getMyFiltersResponseSchema = z.array(filterSchema);

export const getFilterResponseSchema = filterSchema;

export const updateFilterDataSchema = z.object({
  body: filterSchema,
  path: z.object({
    id: z.number(),
  }),
  query: z
    .object({
      expand: z.string().optional(),
      overrideSharePermissions: z.boolean().optional(),
    })
    .optional(),
});

export const updateFilterResponseSchema = filterSchema;

export const deleteFavouriteForFilterResponseSchema = filterSchema;

export const setFavouriteForFilterResponseSchema = filterSchema;

export const getSharePermissionsResponseSchema = z.array(sharePermissionSchema);

export const addSharePermissionResponseSchema = z.array(sharePermissionSchema);

export const getSharePermissionResponseSchema = sharePermissionSchema;

export const getGroupResponseSchema = groupSchema;

export const findUsersAndGroupsResponseSchema = foundUsersAndGroupsSchema;

export const getLicenseResponseSchema = licenseSchema;

export const createIssueDataSchema = z.object({
  body: issueUpdateDetailsSchema,
  query: z
    .object({
      updateHistory: z.boolean().optional(),
    })
    .optional(),
});

export const createIssueResponseSchema = createdIssueSchema;

export const createIssuesDataSchema = z.object({
  body: issuesUpdateBeanSchema,
});

export const createdIssuesSchema = z.object({
  errors: z.array(bulkOperationErrorResultSchema).optional(),
  issues: z.array(createdIssueSchema).optional(),
});

export const createIssuesErrorSchema = z.union([createdIssuesSchema, z.unknown()]);

export const bulkIssueResultsSchema = z.object({
  issueErrors: z.array(issueErrorSchema).optional(),
  issues: z.array(issueBeanSchema).optional(),
});

export const getCreateIssueMetaResponseSchema = issueCreateMetadataSchema;

export const issuePickerSuggestionsSchema = z.object({
  sections: z.array(issuePickerSuggestionsIssueTypeSchema).optional(),
});

export const bulkSetIssuesPropertiesListDataSchema = z.object({
  body: issueEntityPropertiesSchema,
});

export const bulkSetIssuePropertiesByIssueDataSchema = z.object({
  body: multiIssueEntityPropertiesSchema,
});

export const bulkSetIssuePropertyDataSchema = z.object({
  body: bulkIssuePropertyUpdateRequestSchema,
  path: z.object({
    propertyKey: z.string(),
  }),
});

export const getIssueResponseSchema = issueBeanSchema;

export const getChangeLogsResponseSchema = pageBeanChangelogSchema;

export const notificationSchema = z.object({
  htmlBody: z.string().optional(),
  restrict: notificationRecipientsRestrictionsSchema.optional(),
  subject: z.string().optional(),
  textBody: z.string().optional(),
  to: notificationRecipientsSchema.optional(),
});

export const getRemoteIssueLinksResponseSchema = remoteIssueLinkSchema;

export const getTransitionsResponseSchema = transitionsSchema;

export const linkIssuesDataSchema = z.object({
  body: linkIssueRequestJsonBeanSchema,
});

export const issueLinkSchema = z.object({
  id: z.string().optional(),
  inwardIssue: linkedIssueSchema,
  outwardIssue: linkedIssueSchema,
  self: z.string().optional(),
  type: issueLinkTypeSchema,
});

export const exportArchivedIssuesDataSchema = z.object({
  body: archivedIssuesFilterRequestSchema,
});

export const createIssueSecuritySchemeDataSchema = z.object({
  body: createIssueSecuritySchemeDetailsSchema,
});

export const getSecurityLevelsResponseSchema = pageBeanSecurityLevelSchema;

export const getSecurityLevelMembersResponseSchema = pageBeanSecurityLevelMemberSchema;

export const associateSchemesToProjectsDataSchema = z.object({
  body: associateSecuritySchemeWithProjectDetailsSchema,
});

export const searchSecuritySchemesResponseSchema = pageBeanSecuritySchemeWithProjectsSchema;

export const getIssueSecurityLevelMembersResponseSchema = pageBeanIssueSecurityLevelMemberSchema;

export const addSecuritySchemeLevelsRequestBeanSchema = z.object({
  levels: z.array(securitySchemeLevelBeanSchema).optional(),
});

export const createIssueTypeScreenSchemeDataSchema = z.object({
  body: issueTypeScreenSchemeDetailsSchema,
});

export const getProjectsForIssueTypeScreenSchemeResponseSchema = pageBeanProjectDetailsSchema;

export const matchIssuesResponseSchema = issueMatchesSchema;

export const migrateQueriesResponseSchema = convertedJQLQueriesSchema;

export const sanitiseJqlQueriesDataSchema = z.object({
  body: jqlQueriesToSanitizeSchema,
});

export const sanitiseJqlQueriesResponseSchema = sanitizedJqlQueriesSchema;

export const getMyPermissionsResponseSchema = permissionsSchema;

export const pageBeanNotificationSchemeSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(notificationSchemeSchema).optional(),
});

export const createNotificationSchemeDataSchema = z.object({
  body: createNotificationSchemeDetailsSchema,
});

export const getNotificationSchemeResponseSchema = notificationSchemeSchema;

export const addNotificationsDetailsSchema = z.object({
  notificationSchemeEvents: z.array(notificationSchemeEventDetailsSchema),
});

export const getBulkPermissionsDataSchema = z.object({
  body: bulkPermissionsRequestBeanSchema,
});

export const getBulkPermissionsResponseSchema = bulkPermissionGrantsSchema;

export const getPermittedProjectsResponseSchema = permittedProjectsSchema;

export const pageBeanPrioritySchemeWithPaginatedPrioritiesAndProjectsSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(prioritySchemeWithPaginatedPrioritiesAndProjectsSchema).optional(),
});

export const createPrioritySchemeDataSchema = z.object({
  body: createPrioritySchemeDetailsSchema,
});

export const createPrioritySchemeResponseSchema = prioritySchemeIdSchema;

export const updatePrioritySchemeDataSchema = z.object({
  body: updatePrioritySchemeRequestBeanSchema,
  path: z.object({
    schemeId: z.number(),
  }),
});

export const updatePrioritySchemeResponseSchema = updatePrioritySchemeResponseBeanSchema;

export const getProjectsByPrioritySchemeResponseSchema = pageBeanProjectSchema;

export const getAllProjectsResponseSchema = z.array(projectSchema);

export const getRecentResponseSchema = z.array(projectSchema);

export const searchProjectsResponseSchema = pageBeanProjectSchema;

export const getProjectResponseSchema = projectSchema;

export const updateProjectResponseSchema = projectSchema;

export const getProjectComponentsPaginatedResponseSchema = pageBeanComponentWithIssueCountSchema;

export const getFeaturesForProjectResponseSchema = containerForProjectFeaturesSchema;

export const restoreResponseSchema = projectSchema;

export const getAllStatusesResponseSchema = z.array(issueTypeWithStatusSchema);

export const getProjectVersionsPaginatedResponseSchema = pageBeanVersionSchema;

export const getProjectVersionsResponseSchema = z.array(versionSchema);

export const getHierarchyResponseSchema = projectIssueTypeHierarchySchema;

export const getNotificationSchemeForProjectResponseSchema = notificationSchemeSchema;

export const searchResolutionsResponseSchema = pageBeanResolutionJsonBeanSchema;

export const getScreensResponseSchema = pageBeanScreenSchema;

export const pageBeanScreenSchemeSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(screenSchemeSchema).optional(),
});

export const updateScreenSchemeDataSchema = z.object({
  body: updateScreenSchemeDetailsSchema,
  path: z.object({
    screenSchemeId: z.string(),
  }),
});

export const searchForIssuesUsingJqlResponseSchema = searchResultsSchema;

export const searchForIssuesUsingJqlPostResponseSchema = searchResultsSchema;

export const searchAndReconcileResultsSchema = z.object({
  issues: z.array(issueBeanSchema).optional(),
  names: z.record(z.string()).optional(),
  nextPageToken: z.string().optional(),
  schema: z.record(jsonTypeBeanSchema).optional(),
});

export const searchAndReconsileIssuesUsingJqlPostResponseSchema = searchAndReconcileResultsSchema;

export const getStatusesByIdResponseSchema = z.array(jiraStatusSchema);

export const createStatusesDataSchema = z.object({
  body: statusCreateRequestSchema,
});

export const searchResponseSchema = pageOfStatusesSchema;

export const getUiModificationsResponseSchema = pageBeanUiModificationDetailsSchema;

export const createUiModificationDataSchema = z.object({
  body: createUiModificationDetailsSchema,
});

export const bulkGetUsersResponseSchema = pageBeanUserSchema;

export const findUserKeysByQueryResponseSchema = pageBeanUserKeySchema;

export const getVersionRelatedIssuesResponseSchema = versionIssueCountsSchema;

export const getDynamicWebhooksForAppResponseSchema = pageBeanWebhookSchema;

export const registerDynamicWebhooksResponseSchema = containerForRegisteredWebhooksSchema;

export const createWorkflowDetailsSchema = z.object({
  description: z.string().optional(),
  name: z.string(),
  statuses: z.array(createWorkflowStatusDetailsSchema),
  transitions: z.array(createWorkflowTransitionDetailsSchema),
});

export const getWorkflowTransitionRuleConfigurationsResponseSchema = pageBeanWorkflowTransitionRulesSchema;

export const updateWorkflowTransitionRuleConfigurationsDataSchema = z.object({
  body: workflowTransitionRulesUpdateSchema,
});

export const readWorkflowsResponseSchema = workflowReadResponseSchema;

export const workflowCreateResponseSchema = z.object({
  statuses: z.array(jiraWorkflowStatusSchema).optional(),
  workflows: z.array(jiraWorkflowSchema).optional(),
});

export const validateCreateWorkflowsDataSchema = z.object({
  body: workflowCreateValidateRequestSchema,
});

export const updateWorkflowsResponseSchema = workflowUpdateResponseSchema;

export const validateUpdateWorkflowsDataSchema = z.object({
  body: workflowUpdateValidateRequestBeanSchema,
});

export const getAllWorkflowSchemesResponseSchema = pageBeanWorkflowSchemeSchema;

export const getWorkflowSchemeProjectAssociationsResponseSchema = containerOfWorkflowSchemeAssociationsSchema;

export const readWorkflowSchemesResponseSchema = z.array(workflowSchemeReadResponseSchema);

export const updateSchemesDataSchema = z.object({
  body: workflowSchemeUpdateRequestSchema,
});

export const publishDraftWorkflowSchemeDataSchema = z.object({
  body: publishDraftWorkflowSchemeSchema,
  path: z.object({
    id: z.number(),
  }),
  query: z
    .object({
      validateOnly: z.boolean().optional(),
    })
    .optional(),
});

export const getIdsOfWorklogsDeletedSinceResponseSchema = changedWorklogsSchema;

export const migrationResourceWorkflowRuleSearchPostResponseSchema = workflowRulesSearchDetailsSchema;

export const serviceRegistryResourceServicesGetResponseSchema = z.array(serviceRegistrySchema);

export const permissionDetailsSchema = z.object({
  editPermissions: z.array(sharePermissionSchema),
  sharePermissions: z.array(sharePermissionSchema),
});

export const filterDetailsSchema = z.object({
  approximateLastUsed: z.string().optional(),
  description: z.string().optional(),
  editPermissions: z.array(sharePermissionSchema).optional(),
  expand: z.string().optional(),
  favourite: z.boolean().optional(),
  favouritedCount: z.number().optional(),
  id: z.string().optional(),
  jql: z.string().optional(),
  name: z.string(),
  owner: userSchema.optional(),
  searchUrl: z.string().optional(),
  self: z.string().optional(),
  sharePermissions: z.array(sharePermissionSchema).optional(),
  subscriptions: z.array(filterSubscriptionSchema).optional(),
  viewUrl: z.string().optional(),
});

export const jiraIssueFieldsSchema = z.object({
  cascadingSelectFields: z.array(jiraCascadingSelectFieldSchema).optional(),
  clearableNumberFields: z.array(jiraNumberFieldSchema).optional(),
  colorFields: z.array(jiraColorFieldSchema).optional(),
  datePickerFields: z.array(jiraDateFieldSchema).optional(),
  dateTimePickerFields: z.array(jiraDateTimeFieldSchema).optional(),
  issueType: jiraIssueTypeFieldSchema.optional(),
  labelsFields: z.array(jiraLabelsFieldSchema).optional(),
  multipleGroupPickerFields: z.array(jiraMultipleGroupPickerFieldSchema).optional(),
  multipleSelectClearableUserPickerFields: z.array(jiraMultipleSelectUserPickerFieldSchema).optional(),
  multipleSelectFields: z.array(jiraMultipleSelectFieldSchema).optional(),
  multipleVersionPickerFields: z.array(jiraMultipleVersionPickerFieldSchema).optional(),
  multiselectComponents: jiraMultiSelectComponentFieldSchema.optional(),
  originalEstimateField: jiraDurationFieldSchema.optional(),
  priority: jiraPriorityFieldSchema.optional(),
  richTextFields: z.array(jiraRichTextFieldSchema).optional(),
  singleGroupPickerFields: z.array(jiraSingleGroupPickerFieldSchema).optional(),
  singleLineTextFields: z.array(jiraSingleLineTextFieldSchema).optional(),
  singleSelectClearableUserPickerFields: z.array(jiraSingleSelectUserPickerFieldSchema).optional(),
  singleSelectFields: z.array(jiraSingleSelectFieldSchema).optional(),
  singleVersionPickerFields: z.array(jiraSingleVersionPickerFieldSchema).optional(),
  timeTrackingField: jiraTimeTrackingFieldSchema.optional(),
  urlFields: z.array(jiraUrlFieldSchema).optional(),
});

export const jExpEvaluateMetaDataBeanSchema = z.object({
  complexity: jiraExpressionsComplexityBeanSchema.optional(),
  issues: jExpEvaluateIssuesMetaBeanSchema.optional(),
});

export const jqlQueryOrderByClauseSchema = z.object({
  fields: z.array(jqlQueryOrderByClauseElementSchema),
});

export const legacyJackson1ListProjectSchema = z.array(projectSchema);

export const pageBeanFilterDetailsSchema = z.object({
  isLast: z.boolean().optional(),
  maxResults: z.number().optional(),
  nextPage: z.string().optional(),
  self: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
  values: z.array(filterDetailsSchema).optional(),
});

export const pageOfDashboardsSchema = z.object({
  dashboards: z.array(dashboardSchema).optional(),
  maxResults: z.number().optional(),
  next: z.string().optional(),
  prev: z.string().optional(),
  startAt: z.number().optional(),
  total: z.number().optional(),
});

export const getBulkEditableFieldsResponseSchema = bulkEditGetFieldsSchema;

export const issueBulkEditPayloadSchema = z.object({
  editedFieldsInput: jiraIssueFieldsSchema,
  selectedActions: z.array(z.string()),
  selectedIssueIdsOrKeys: z.array(z.string()),
  sendBulkNotification: z.boolean().optional().nullable(),
});

export const getAllDashboardsResponseSchema = pageOfDashboardsSchema;

export const createDashboardDataSchema = z.object({
  body: dashboardDetailsSchema,
  query: z
    .object({
      extendAdminPermissions: z.boolean().optional(),
    })
    .optional(),
});

export const createDashboardResponseSchema = dashboardSchema;

export const bulkEditShareableEntityRequestSchema = z.object({
  action: z.union([
    z.literal('changeOwner'),
    z.literal('changePermission'),
    z.literal('addPermission'),
    z.literal('removePermission'),
  ]),
  changeOwnerDetails: bulkChangeOwnerDetailsSchema.optional(),
  entityIds: z.array(z.number()),
  extendAdminPermissions: z.boolean().optional(),
  permissionDetails: permissionDetailsSchema.optional(),
});

export const getDashboardsPaginatedResponseSchema = pageBeanDashboardSchema;

export const jExpEvaluateJiraExpressionResultBeanSchema = z.object({
  meta: jExpEvaluateMetaDataBeanSchema.optional(),
  value: z.string().optional(),
});

export const setDefaultValuesDataSchema = z.object({
  body: customFieldContextDefaultValueUpdateSchema,
  path: z.object({
    fieldId: z.string(),
  }),
});

export const getScreensForFieldResponseSchema = pageBeanScreenWithTabSchema;

export const getAllIssueFieldOptionsResponseSchema = pageBeanIssueFieldOptionSchema;

export const createIssueFieldOptionDataSchema = z.object({
  body: issueFieldOptionCreateBeanSchema,
  path: z.object({
    fieldKey: z.string(),
  }),
});

export const createFilterDataSchema = z.object({
  body: filterSchema,
  query: z
    .object({
      expand: z.string().optional(),
      overrideSharePermissions: z.boolean().optional(),
    })
    .optional(),
});

export const getFiltersPaginatedResponseSchema = pageBeanFilterDetailsSchema;

export const createIssuesResponseSchema = createdIssuesSchema;

export const bulkFetchIssuesResponseSchema = bulkIssueResultsSchema;

export const getIssuePickerResourceResponseSchema = issuePickerSuggestionsSchema;

export const notifyDataSchema = z.object({
  body: notificationSchema,
  path: z.object({
    issueIdOrKey: z.string(),
  }),
});

export const getIssueLinkResponseSchema = issueLinkSchema;

export const addSecurityLevelDataSchema = z.object({
  body: addSecuritySchemeLevelsRequestBeanSchema,
  path: z.object({
    schemeId: z.string(),
  }),
});

export const getNotificationSchemesResponseSchema = pageBeanNotificationSchemeSchema;

export const addNotificationsDataSchema = z.object({
  body: addNotificationsDetailsSchema,
  path: z.object({
    id: z.string(),
  }),
});

export const getPrioritySchemesResponseSchema = pageBeanPrioritySchemeWithPaginatedPrioritiesAndProjectsSchema;

export const getScreenSchemesResponseSchema = pageBeanScreenSchemeSchema;

export const searchAndReconsileIssuesUsingJqlResponseSchema = searchAndReconcileResultsSchema;

export const createWorkflowDataSchema = z.object({
  body: createWorkflowDetailsSchema,
});

export const createWorkflowsResponseSchema = workflowCreateResponseSchema;

export const submitBulkEditDataSchema = z.object({
  body: issueBulkEditPayloadSchema,
});

export const bulkEditDashboardsDataSchema = z.object({
  body: bulkEditShareableEntityRequestSchema,
});

export const evaluateJsisJiraExpressionResponseSchema = jExpEvaluateJiraExpressionResultBeanSchema;

export const compoundClauseSchema: z.ZodSchema<CompoundClause> = z.lazy(() =>
  z.object({
    clauses: z.array(jqlQueryClauseSchema),
    operator: z.union([z.literal('and'), z.literal('or'), z.literal('not')]),
  }),
);

export const jqlQueryClauseSchema: z.ZodSchema<JqlQueryClause> = z.lazy(() =>
  z.union([compoundClauseSchema, fieldValueClauseSchema, fieldWasClauseSchema, fieldChangedClauseSchema]),
);

export const jqlQuerySchema: z.ZodSchema<JqlQuery> = z.lazy(() =>
  z.object({
    orderBy: jqlQueryOrderByClauseSchema.optional(),
    where: jqlQueryClauseSchema.optional(),
  }),
);

export const pageBeanWorkflowSchema: z.ZodSchema<PageBeanWorkflow> = z.lazy(() =>
  z.object({
    isLast: z.boolean().optional(),
    maxResults: z.number().optional(),
    nextPage: z.string().optional(),
    self: z.string().optional(),
    startAt: z.number().optional(),
    total: z.number().optional(),
    values: z.array(workflowSchema).optional(),
  }),
);

export const workflowSchema: z.ZodSchema<Workflow> = z.lazy(() =>
  z.object({
    created: z.string().optional(),
    description: z.string(),
    hasDraftWorkflow: z.boolean().optional(),
    id: publishedWorkflowIdSchema,
    isDefault: z.boolean().optional(),
    operations: workflowOperationsSchema.optional(),
    projects: z.array(projectDetailsSchema).optional(),
    schemes: z.array(workflowSchemeIdNameSchema).optional(),
    statuses: z.array(workflowStatusSchema).optional(),
    transitions: z.array(transitionSchema).optional(),
    updated: z.string().optional(),
  }),
);

export const parsedJqlQueriesSchema: z.ZodSchema<ParsedJqlQueries> = z.lazy(() =>
  z.object({
    queries: z.array(parsedJqlQuerySchema),
  }),
);

export const parsedJqlQuerySchema: z.ZodSchema<ParsedJqlQuery> = z.lazy(() =>
  z.object({
    errors: z.array(z.string()).optional(),
    query: z.string(),
    structure: jqlQuerySchema.optional(),
  }),
);

export const transitionSchema: z.ZodSchema<Transition> = z.lazy(() =>
  z.object({
    description: z.string(),
    from: z.array(z.string()),
    id: z.string(),
    name: z.string(),
    properties: z.record(z.string()).optional(),
    rules: workflowRulesSchema.optional(),
    screen: transitionScreenDetailsSchema.optional(),
    to: z.string(),
    type: z.union([z.literal('global'), z.literal('initial'), z.literal('directed')]),
  }),
);

export const workflowRulesSchema: z.ZodSchema<WorkflowRules> = z.lazy(() =>
  z.object({
    conditionsTree: workflowConditionSchema.optional(),
    postFunctions: z.array(workflowTransitionRuleSchema).optional(),
    validators: z.array(workflowTransitionRuleSchema).optional(),
  }),
);

export const workflowCompoundConditionSchema: z.ZodSchema<WorkflowCompoundCondition> = z.lazy(() =>
  z.object({
    conditions: z.array(workflowConditionSchema),
    nodeType: z.literal('compound'),
    operator: z.union([z.literal('AND'), z.literal('OR')]),
  }),
);

export const workflowConditionSchema: z.ZodSchema<WorkflowCondition> = z.lazy(() =>
  z.union([workflowSimpleConditionSchema, workflowCompoundConditionSchema]),
);

export const parseJqlQueriesResponseSchema: z.ZodSchema<ParseJqlQueriesResponse> = z.lazy(() => parsedJqlQueriesSchema);

export const getWorkflowsPaginatedResponseSchema: z.ZodSchema<GetWorkflowsPaginatedResponse> = z.lazy(
  () => pageBeanWorkflowSchema,
);
