// This file is auto-generated by @hey-api/openapi-ts

export type ActorInputBean = {
  /**
   * The name of the group to add as a default actor. This parameter cannot be used with the `groupId` parameter. As a group's name can change,use of `groupId` is recommended. This parameter accepts a comma-separated list. For example, `"group":["project-admin", "jira-developers"]`.
   */
  group?: Array<string>;
  /**
   * The ID of the group to add as a default actor. This parameter cannot be used with the `group` parameter This parameter accepts a comma-separated list. For example, `"groupId":["77f6ab39-e755-4570-a6ae-2d7a8df0bcb8", "0c011f85-69ed-49c4-a801-3b18d0f771bc"]`.
   */
  groupId?: Array<string>;
  /**
   * The account IDs of the users to add as default actors. This parameter accepts a comma-separated list. For example, `"user":["5b10a2844c20165700ede21g", "5b109f2e9729b51b54dc274d"]`.
   */
  user?: Array<string>;
};

export type ActorsMap = {
  /**
   * The name of the group to add. This parameter cannot be used with the `groupId` parameter. As a group's name can change, use of `groupId` is recommended.
   */
  group?: Array<string>;
  /**
   * The ID of the group to add. This parameter cannot be used with the `group` parameter.
   */
  groupId?: Array<string>;
  /**
   * The user account ID of the user to add.
   */
  user?: Array<string>;
};

export type AddFieldBean = {
  /**
   * The ID of the field to add.
   */
  fieldId: string;
};

export type AddGroupBean = {
  /**
   * The name of the group.
   */
  name: string;
};

/**
 * Details of notifications which should be added to the notification scheme.
 */
export type AddNotificationsDetails = {
  /**
   * The list of notifications which should be added to the notification scheme.
   */
  notificationSchemeEvents: Array<NotificationSchemeEventDetails>;
};

export type AddSecuritySchemeLevelsRequestBean = {
  /**
   * The list of scheme levels which should be added to the security scheme.
   */
  levels?: Array<SecuritySchemeLevelBean>;
};

/**
 * Announcement banner configuration.
 */
export type AnnouncementBannerConfiguration = {
  /**
   * Hash of the banner data. The client detects updates by comparing hash IDs.
   */
  readonly hashId?: string;
  /**
   * Flag indicating if the announcement banner can be dismissed by the user.
   */
  readonly isDismissible?: boolean;
  /**
   * Flag indicating if the announcement banner is enabled or not.
   */
  readonly isEnabled?: boolean;
  /**
   * The text on the announcement banner.
   */
  readonly message?: string;
  /**
   * Visibility of the announcement banner.
   */
  readonly visibility?: 'PUBLIC' | 'PRIVATE';
};

/**
 * Visibility of the announcement banner.
 */
export type visibility = 'PUBLIC' | 'PRIVATE';

/**
 * Configuration of the announcement banner.
 */
export type AnnouncementBannerConfigurationUpdate = {
  /**
   * Flag indicating if the announcement banner can be dismissed by the user.
   */
  isDismissible?: boolean;
  /**
   * Flag indicating if the announcement banner is enabled or not.
   */
  isEnabled?: boolean;
  /**
   * The text on the announcement banner.
   */
  message?: string;
  /**
   * Visibility of the announcement banner. Can be public or private.
   */
  visibility?: string;
};

/**
 * A workflow transition rule.
 */
export type AppWorkflowTransitionRule = {
  configuration: RuleConfiguration;
  /**
   * The ID of the transition rule.
   */
  id: string;
  /**
   * The key of the rule, as defined in the Connect or the Forge app descriptor.
   */
  readonly key: string;
  readonly transition?: WorkflowTransition;
};

/**
 * The application the linked item is in.
 */
export type Application = {
  /**
   * The name of the application. Used in conjunction with the (remote) object icon title to display a tooltip for the link's icon. The tooltip takes the format "\[application name\] icon title". Blank items are excluded from the tooltip title. If both items are blank, the icon tooltop displays as "Web Link". Grouping and sorting of links may place links without an application name last.
   */
  name?: string;
  /**
   * The name-spaced type of the application, used by registered rendering apps.
   */
  type?: string;
};

/**
 * Details of an application property.
 */
export type ApplicationProperty = {
  /**
   * The allowed values, if applicable.
   */
  allowedValues?: Array<string>;
  /**
   * The default value of the application property.
   */
  defaultValue?: string;
  /**
   * The description of the application property.
   */
  desc?: string;
  example?: string;
  /**
   * The ID of the application property. The ID and key are the same.
   */
  id?: string;
  /**
   * The key of the application property. The ID and key are the same.
   */
  key?: string;
  /**
   * The name of the application property.
   */
  name?: string;
  /**
   * The data type of the application property.
   */
  type?: string;
  /**
   * The new value.
   */
  value?: string;
};

/**
 * Details of an application role.
 */
export type ApplicationRole = {
  /**
   * The groups that are granted default access for this application role. As a group's name can change, use of `defaultGroupsDetails` is recommended to identify a groups.
   */
  defaultGroups?: Array<string>;
  /**
   * The groups that are granted default access for this application role.
   */
  defaultGroupsDetails?: Array<GroupName>;
  /**
   * Deprecated.
   */
  defined?: boolean;
  /**
   * The groups associated with the application role.
   */
  groupDetails?: Array<GroupName>;
  /**
   * The groups associated with the application role. As a group's name can change, use of `groupDetails` is recommended to identify a groups.
   */
  groups?: Array<string>;
  hasUnlimitedSeats?: boolean;
  /**
   * The key of the application role.
   */
  key?: string;
  /**
   * The display name of the application role.
   */
  name?: string;
  /**
   * The maximum count of users on your license.
   */
  numberOfSeats?: number;
  /**
   * Indicates if the application role belongs to Jira platform (`jira-core`).
   */
  platform?: boolean;
  /**
   * The count of users remaining on your license.
   */
  remainingSeats?: number;
  /**
   * Determines whether this application role should be selected by default on user creation.
   */
  selectedByDefault?: boolean;
  /**
   * The number of users counting against your license.
   */
  userCount?: number;
  /**
   * The [type of users](https://confluence.atlassian.com/x/lRW3Ng) being counted against your license.
   */
  userCountDescription?: string;
};

/**
 * The approval configuration of a status within a workflow. Applies only to Jira Service Management approvals.
 */
export type ApprovalConfiguration = {
  /**
   * Whether the approval configuration is active.
   */
  active: 'true' | 'false';
  /**
   * How the required approval count is calculated. It may be configured to require a specific number of approvals, or approval by a percentage of approvers. If the approvers source field is Approver groups, you can configure how many approvals per group are required for the request to be approved. The number will be the same across all groups.
   */
  conditionType: 'number' | 'percent' | 'numberPerPrincipal';
  /**
   * The number or percentage of approvals required for a request to be approved. If `conditionType` is `number`, the value must be 20 or less. If `conditionType` is `percent`, the value must be 100 or less.
   */
  conditionValue: string;
  /**
   * A list of roles that should be excluded as possible approvers.
   */
  exclude?: ('assignee' | 'reporter') | null;
  /**
   * The custom field ID of the "Approvers" or "Approver Groups" field.
   */
  fieldId: string;
  /**
   * The custom field ID of the field used to pre-populate the Approver field. Only supports the "Affected Services" field.
   */
  prePopulatedFieldId?: string | null;
  /**
   * The numeric ID of the transition to be executed if the request is approved.
   */
  transitionApproved: string;
  /**
   * The numeric ID of the transition to be executed if the request is declined.
   */
  transitionRejected: string;
} | null;

/**
 * Whether the approval configuration is active.
 */
export type active = 'true' | 'false';

/**
 * How the required approval count is calculated. It may be configured to require a specific number of approvals, or approval by a percentage of approvers. If the approvers source field is Approver groups, you can configure how many approvals per group are required for the request to be approved. The number will be the same across all groups.
 */
export type conditionType = 'number' | 'percent' | 'numberPerPrincipal';

/**
 * A list of roles that should be excluded as possible approvers.
 */
export type exclude = 'assignee' | 'reporter';

export type ArchiveIssueAsyncRequest = {
  jql?: string;
};

/**
 * Details of a filter for exporting archived issues.
 */
export type ArchivedIssuesFilterRequest = {
  /**
   * List archived issues archived by a specified account ID.
   */
  archivedBy?: Array<string>;
  archivedDateRange?: DateRangeFilterRequest;
  /**
   * List archived issues with a specified issue type ID.
   */
  issueTypes?: Array<string>;
  /**
   * List archived issues with a specified project key.
   */
  projects?: Array<string>;
  /**
   * List archived issues where the reporter is a specified account ID.
   */
  reporters?: Array<string>;
};

/**
 * Details of a field configuration to issue type mappings.
 */
export type AssociateFieldConfigurationsWithIssueTypesRequest = {
  /**
   * Field configuration to issue type mappings.
   */
  mappings: Array<FieldConfigurationToIssueTypeMapping>;
};

/**
 * Issue security scheme, project, and remapping details.
 */
export type AssociateSecuritySchemeWithProjectDetails = {
  /**
   * The list of scheme levels which should be remapped to new levels of the issue security scheme.
   */
  oldToNewSecurityLevelMappings?: Array<OldToNewSecurityLevelMappingsBean>;
  /**
   * The ID of the project.
   */
  projectId: string;
  /**
   * The ID of the issue security scheme. Providing null will clear the association with the issue security scheme.
   */
  schemeId: string;
};

/**
 * Details of an item associated with the changed record.
 */
export type AssociatedItemBean = {
  /**
   * The ID of the associated record.
   */
  readonly id?: string;
  /**
   * The name of the associated record.
   */
  readonly name?: string;
  /**
   * The ID of the associated parent record.
   */
  readonly parentId?: string;
  /**
   * The name of the associated parent record.
   */
  readonly parentName?: string;
  /**
   * The type of the associated record.
   */
  readonly typeName?: string;
};

/**
 * Details about an attachment.
 */
export type Attachment = {
  /**
   * Details of the user who added the attachment.
   */
  readonly author?: UserDetails;
  /**
   * The content of the attachment.
   */
  readonly content?: string;
  /**
   * The datetime the attachment was created.
   */
  readonly created?: string;
  /**
   * The file name of the attachment.
   */
  readonly filename?: string;
  /**
   * The ID of the attachment.
   */
  readonly id?: string;
  /**
   * The MIME type of the attachment.
   */
  readonly mimeType?: string;
  /**
   * The URL of the attachment details response.
   */
  readonly self?: string;
  /**
   * The size of the attachment.
   */
  readonly size?: number;
  /**
   * The URL of a thumbnail representing the attachment.
   */
  readonly thumbnail?: string;
};

export type AttachmentArchive = {
  entries?: Array<AttachmentArchiveEntry>;
  moreAvailable?: boolean;
  totalEntryCount?: number;
  totalNumberOfEntriesAvailable?: number;
};

export type AttachmentArchiveEntry = {
  abbreviatedName?: string;
  entryIndex?: number;
  mediaType?: string;
  name?: string;
  size?: number;
};

export type AttachmentArchiveImpl = {
  /**
   * The list of the items included in the archive.
   */
  entries?: Array<AttachmentArchiveEntry>;
  /**
   * The number of items in the archive.
   */
  totalEntryCount?: number;
};

/**
 * Metadata for an item in an attachment archive.
 */
export type AttachmentArchiveItemReadable = {
  /**
   * The position of the item within the archive.
   */
  readonly index?: number;
  /**
   * The label for the archive item.
   */
  readonly label?: string;
  /**
   * The MIME type of the archive item.
   */
  readonly mediaType?: string;
  /**
   * The path of the archive item.
   */
  readonly path?: string;
  /**
   * The size of the archive item.
   */
  readonly size?: string;
};

/**
 * Metadata for an archive (for example a zip) and its contents.
 */
export type AttachmentArchiveMetadataReadable = {
  /**
   * The list of the items included in the archive.
   */
  readonly entries?: Array<AttachmentArchiveItemReadable>;
  /**
   * The ID of the attachment.
   */
  readonly id?: number;
  /**
   * The MIME type of the attachment.
   */
  readonly mediaType?: string;
  /**
   * The name of the archive file.
   */
  readonly name?: string;
  /**
   * The number of items included in the archive.
   */
  readonly totalEntryCount?: number;
};

/**
 * Metadata for an issue attachment.
 */
export type AttachmentMetadata = {
  /**
   * Details of the user who attached the file.
   */
  readonly author?: User;
  /**
   * The URL of the attachment.
   */
  readonly content?: string;
  /**
   * The datetime the attachment was created.
   */
  readonly created?: string;
  /**
   * The name of the attachment file.
   */
  readonly filename?: string;
  /**
   * The ID of the attachment.
   */
  readonly id?: number;
  /**
   * The MIME type of the attachment.
   */
  readonly mimeType?: string;
  /**
   * Additional properties of the attachment.
   */
  readonly properties?: {
    [key: string]: string;
  };
  /**
   * The URL of the attachment metadata details.
   */
  readonly self?: string;
  /**
   * The size of the attachment.
   */
  readonly size?: number;
  /**
   * The URL of a thumbnail representing the attachment.
   */
  readonly thumbnail?: string;
};

/**
 * Details of the instance's attachment settings.
 */
export type AttachmentSettings = {
  /**
   * Whether the ability to add attachments is enabled.
   */
  readonly enabled?: boolean;
  /**
   * The maximum size of attachments permitted, in bytes.
   */
  readonly uploadLimit?: number;
};

/**
 * An audit record.
 */
export type AuditRecordBean = {
  /**
   * The list of items associated with the changed record.
   */
  readonly associatedItems?: Array<AssociatedItemBean>;
  /**
   * Deprecated, use `authorAccountId` instead. The key of the user who created the audit record.
   */
  readonly authorKey?: string;
  /**
   * The category of the audit record. For a list of these categories, see the help article [Auditing in Jira applications](https://confluence.atlassian.com/x/noXKM).
   */
  readonly category?: string;
  /**
   * The list of values changed in the record event.
   */
  readonly changedValues?: Array<ChangedValueBean>;
  /**
   * The date and time on which the audit record was created.
   */
  readonly created?: string;
  /**
   * The description of the audit record.
   */
  readonly description?: string;
  /**
   * The event the audit record originated from.
   */
  readonly eventSource?: string;
  /**
   * The ID of the audit record.
   */
  readonly id?: number;
  objectItem?: AssociatedItemBean;
  /**
   * The URL of the computer where the creation of the audit record was initiated.
   */
  readonly remoteAddress?: string;
  /**
   * The summary of the audit record.
   */
  readonly summary?: string;
};

/**
 * Container for a list of audit records.
 */
export type AuditRecords = {
  /**
   * The requested or default limit on the number of audit items to be returned.
   */
  readonly limit?: number;
  /**
   * The number of audit items skipped before the first item in this list.
   */
  readonly offset?: number;
  /**
   * The list of audit items.
   */
  readonly records?: Array<AuditRecordBean>;
  /**
   * The total number of audit items returned.
   */
  readonly total?: number;
};

/**
 * A field auto-complete suggestion.
 */
export type AutoCompleteSuggestion = {
  /**
   * The display name of a suggested item. If `fieldValue` or `predicateValue` are provided, the matching text is highlighted with the HTML bold tag.
   */
  displayName?: string;
  /**
   * The value of a suggested item.
   */
  value?: string;
};

/**
 * The results from a JQL query.
 */
export type AutoCompleteSuggestions = {
  /**
   * The list of suggested item.
   */
  results?: Array<AutoCompleteSuggestion>;
};

/**
 * The details of the available dashboard gadget.
 */
export type AvailableDashboardGadget = {
  /**
   * The module key of the gadget type.
   */
  readonly moduleKey?: string;
  /**
   * The title of the gadget.
   */
  readonly title: string;
  /**
   * The URI of the gadget type.
   */
  readonly uri?: string;
};

/**
 * The list of available gadgets.
 */
export type AvailableDashboardGadgetsResponse = {
  /**
   * The list of available gadgets.
   */
  readonly gadgets: Array<AvailableDashboardGadget>;
};

/**
 * The Connect provided ecosystem rules available.
 */
export type AvailableWorkflowConnectRule = {
  /**
   * The add-on providing the rule.
   */
  addonKey?: string;
  /**
   * The URL creation path segment defined in the Connect module.
   */
  createUrl?: string;
  /**
   * The rule description.
   */
  description?: string;
  /**
   * The URL edit path segment defined in the Connect module.
   */
  editUrl?: string;
  /**
   * The module providing the rule.
   */
  moduleKey?: string;
  /**
   * The rule name.
   */
  name?: string;
  /**
   * The rule key.
   */
  ruleKey?: string;
  /**
   * The rule type.
   */
  ruleType?: 'Condition' | 'Validator' | 'Function' | 'Screen';
  /**
   * The URL view path segment defined in the Connect module.
   */
  viewUrl?: string;
};

/**
 * The rule type.
 */
export type ruleType = 'Condition' | 'Validator' | 'Function' | 'Screen';

/**
 * The Forge provided ecosystem rules available.
 */
export type AvailableWorkflowForgeRule = {
  /**
   * The rule description.
   */
  description?: string;
  /**
   * The unique ARI of the forge rule type.
   */
  id?: string;
  /**
   * The rule name.
   */
  name?: string;
  /**
   * The rule key.
   */
  ruleKey?: string;
  /**
   * The rule type.
   */
  ruleType?: 'Condition' | 'Validator' | 'Function' | 'Screen';
};

/**
 * The Atlassian provided system rules available.
 */
export type AvailableWorkflowSystemRule = {
  /**
   * The rule description.
   */
  description: string;
  /**
   * List of rules that conflict with this one.
   */
  incompatibleRuleKeys: Array<string>;
  /**
   * Whether the rule can be added added to an initial transition.
   */
  isAvailableForInitialTransition: boolean;
  /**
   * Whether the rule is visible.
   */
  isVisible: boolean;
  /**
   * The rule name.
   */
  name: string;
  /**
   * The rule key.
   */
  ruleKey: string;
  /**
   * The rule type.
   */
  ruleType: 'Condition' | 'Validator' | 'Function' | 'Screen';
};

/**
 * The list of available trigger types.
 */
export type AvailableWorkflowTriggerTypes = {
  /**
   * The description of the trigger rule.
   */
  description?: string;
  /**
   * The name of the trigger rule.
   */
  name?: string;
  /**
   * The type identifier of trigger rule.
   */
  type?: string;
};

/**
 * The trigger rules available.
 */
export type AvailableWorkflowTriggers = {
  /**
   * The list of available trigger types.
   */
  availableTypes: Array<AvailableWorkflowTriggerTypes>;
  /**
   * The rule key of the rule.
   */
  ruleKey: string;
};

/**
 * Details of an avatar.
 */
export type Avatar = {
  /**
   * The file name of the avatar icon. Returned for system avatars.
   */
  readonly fileName?: string;
  /**
   * The ID of the avatar.
   */
  id: string;
  /**
   * Whether the avatar can be deleted.
   */
  readonly isDeletable?: boolean;
  /**
   * Whether the avatar is used in Jira. For example, shown as a project's avatar.
   */
  readonly isSelected?: boolean;
  /**
   * Whether the avatar is a system avatar.
   */
  readonly isSystemAvatar?: boolean;
  /**
   * The owner of the avatar. For a system avatar the owner is null (and nothing is returned). For non-system avatars this is the appropriate identifier, such as the ID for a project or the account ID for a user.
   */
  readonly owner?: string;
  /**
   * The list of avatar icon URLs.
   */
  readonly urls?: {
    [key: string]: string;
  };
};

export type AvatarUrlsBean = {
  /**
   * The URL of the item's 16x16 pixel avatar.
   */
  '16x16'?: string;
  /**
   * The URL of the item's 24x24 pixel avatar.
   */
  '24x24'?: string;
  /**
   * The URL of the item's 32x32 pixel avatar.
   */
  '32x32'?: string;
  /**
   * The URL of the item's 48x48 pixel avatar.
   */
  '48x48'?: string;
};

/**
 * Details about system and custom avatars.
 */
export type Avatars = {
  /**
   * Custom avatars list.
   */
  readonly custom?: Array<Avatar>;
  /**
   * System avatars list.
   */
  readonly system?: Array<Avatar>;
};

/**
 * Details for changing owners of shareable entities
 */
export type BulkChangeOwnerDetails = {
  /**
   * Whether the name is fixed automatically if it's duplicated after changing owner.
   */
  autofixName: boolean;
  /**
   * The account id of the new owner.
   */
  newOwner: string;
};

/**
 * Details of the contextual configuration for a custom field.
 */
export type BulkContextualConfiguration = {
  /**
   * The field configuration.
   */
  configuration?: string;
  /**
   * The ID of the custom field.
   */
  customFieldId: string;
  /**
   * The ID of the field context the configuration is associated with.
   */
  readonly fieldContextId: string;
  /**
   * The ID of the configuration.
   */
  id: string;
  /**
   * The field value schema.
   */
  schema?: string;
};

/**
 * Details of the options to create for a custom field.
 */
export type BulkCustomFieldOptionCreateRequest = {
  /**
   * Details of options to create.
   */
  options?: Array<CustomFieldOptionCreate>;
};

/**
 * Details of the options to update for a custom field.
 */
export type BulkCustomFieldOptionUpdateRequest = {
  /**
   * Details of the options to update.
   */
  options?: Array<CustomFieldOptionUpdate>;
};

/**
 * Errors of bulk edit action.
 */
export type BulkEditActionError = {
  /**
   * The error messages.
   */
  errorMessages: Array<string>;
  /**
   * The errors.
   */
  errors: {
    [key: string]: string;
  };
};

/**
 * Bulk Edit Get Fields Response.
 */
export type BulkEditGetFields = {
  /**
   * The end cursor for use in pagination.
   */
  readonly endingBefore?: string;
  /**
   * List of all the fields
   */
  readonly fields?: Array<IssueBulkEditField>;
  /**
   * The start cursor for use in pagination.
   */
  readonly startingAfter?: string;
};

/**
 * Details of a request to bulk edit shareable entity.
 */
export type BulkEditShareableEntityRequest = {
  /**
   * Allowed action for bulk edit shareable entity
   */
  action: 'changeOwner' | 'changePermission' | 'addPermission' | 'removePermission';
  /**
   * The details of change owner action.
   */
  changeOwnerDetails?: BulkChangeOwnerDetails;
  /**
   * The id list of shareable entities to be changed.
   */
  entityIds: Array<number>;
  /**
   * Whether the actions are executed by users with Administer Jira global permission.
   */
  extendAdminPermissions?: boolean;
  /**
   * The permission details to be changed.
   */
  permissionDetails?: PermissionDetails;
};

/**
 * Allowed action for bulk edit shareable entity
 */
export type action = 'changeOwner' | 'changePermission' | 'addPermission' | 'removePermission';

/**
 * Details of a request to bulk edit shareable entity.
 */
export type BulkEditShareableEntityResponse = {
  /**
   * Allowed action for bulk edit shareable entity
   */
  action: 'changeOwner' | 'changePermission' | 'addPermission' | 'removePermission';
  /**
   * The mapping dashboard id to errors if any.
   */
  entityErrors?: {
    [key: string]: BulkEditActionError;
  };
};

export type BulkFetchIssueRequestBean = {
  /**
   * Use [expand](em>#expansion) to include additional information about issues in the response. Note that, unlike the majority of instances where `expand` is specified, `expand` is defined as a list of values. The expand options are:
   *
   * *  `renderedFields` Returns field values rendered in HTML format.
   * *  `names` Returns the display name of each field.
   * *  `schema` Returns the schema describing a field type.
   * *  `changelog` Returns a list of recent updates to an issue, sorted by date, starting from the most recent.
   */
  expand?: Array<string>;
  /**
   * A list of fields to return for each issue, use it to retrieve a subset of fields. This parameter accepts a comma-separated list. Expand options include:
   *
   * *  `*all` Returns all fields.
   * *  `*navigable` Returns navigable fields.
   * *  Any issue field, prefixed with a minus to exclude.
   *
   * The default is `*navigable`.
   *
   * Examples:
   *
   * *  `summary,comment` Returns the summary and comments fields only.
   * *  `-description` Returns all navigable (default) fields except description.
   * *  `*all,-comment` Returns all fields except comments.
   *
   * Multiple `fields` parameters can be included in a request.
   *
   * Note: All navigable fields are returned by default. This differs from [GET issue](#api-rest-api-3-issue-issueIdOrKey-get) where the default is all fields.
   */
  fields?: Array<string>;
  /**
   * Reference fields by their key (rather than ID). The default is `false`.
   */
  fieldsByKeys?: boolean;
  /**
   * An array of issue IDs or issue keys to fetch. You can mix issue IDs and keys in the same query.
   */
  issueIdsOrKeys: Array<string>;
  /**
   * A list of issue property keys of issue properties to be included in the results. A maximum of 5 issue property keys can be specified.
   */
  properties?: Array<string>;
};

/**
 * A container for the watch status of a list of issues.
 */
export type BulkIssueIsWatching = {
  /**
   * The map of issue ID to boolean watch status.
   */
  readonly issuesIsWatching?: {
    [key: string]: boolean;
  };
};

/**
 * Bulk issue property update request details.
 */
export type BulkIssuePropertyUpdateRequest = {
  /**
   * EXPERIMENTAL. The Jira expression to calculate the value of the property. The value of the expression must be an object that can be converted to JSON, such as a number, boolean, string, list, or map. The context variables available to the expression are `issue` and `user`. Issues for which the expression returns a value whose JSON representation is longer than 32768 characters are ignored.
   */
  expression?: string;
  /**
   * The bulk operation filter.
   */
  filter?: IssueFilterForBulkPropertySet;
  /**
   * The value of the property. The value must be a [valid](https://tools.ietf.org/html/rfc4627), non-empty JSON blob. The maximum length is 32768 characters.
   */
  value?: string;
};

/**
 * The list of requested issues & fields.
 */
export type BulkIssueResults = {
  /**
   * When Jira can't return an issue enumerated in a request due to a retriable error or payload constraint, we'll return the respective issue ID with a corresponding error message. This list is empty when there are no errors Issues which aren't found or that the user doesn't have permission to view won't be returned in this list.
   */
  readonly issueErrors?: Array<IssueError>;
  /**
   * The list of issues.
   */
  readonly issues?: Array<IssueBean>;
};

export type BulkOperationErrorResponse = {
  errors?: Array<ErrorMessage>;
};

export type BulkOperationErrorResult = {
  elementErrors?: ErrorCollection;
  failedElementNumber?: number;
  status?: number;
};

export type BulkOperationProgress = {
  /**
   * A timestamp of when the task was submitted.
   */
  created?: string;
  /**
   * Map of issue IDs for which the operation failed and that the user has permission to view, to their one or more reasons for failure. These reasons are open-ended text descriptions of the error and are not selected from a predefined list of standard reasons.
   */
  failedAccessibleIssues?: {
    [key: string]: Array<string>;
  };
  /**
   * The number of issues that are either invalid or issues that the user doesn't have permission to view, regardless of the success or failure of the operation.
   */
  invalidOrInaccessibleIssueCount?: number;
  /**
   * List of issue IDs for which the operation was successful and that the user has permission to view.
   */
  processedAccessibleIssues?: Array<number>;
  /**
   * Progress of the task as a percentage.
   */
  progressPercent?: number;
  /**
   * A timestamp of when the task was started.
   */
  started?: string;
  /**
   * The status of the task.
   */
  status?: 'ENQUEUED' | 'RUNNING' | 'COMPLETE' | 'FAILED' | 'CANCEL_REQUESTED' | 'CANCELLED' | 'DEAD';
  submittedBy?: User;
  /**
   * The ID of the task.
   */
  readonly taskId?: string;
  /**
   * The number of issues that the bulk operation was attempted on.
   */
  totalIssueCount?: number;
  /**
   * A timestamp of when the task progress was last updated.
   */
  updated?: string;
};

/**
 * The status of the task.
 */
export type status = 'ENQUEUED' | 'RUNNING' | 'COMPLETE' | 'FAILED' | 'CANCEL_REQUESTED' | 'CANCELLED' | 'DEAD';

/**
 * Details of global and project permissions granted to the user.
 */
export type BulkPermissionGrants = {
  /**
   * List of permissions granted to the user.
   */
  globalPermissions: Array<string>;
  /**
   * List of project permissions and the projects and issues those permissions provide access to.
   */
  projectPermissions: Array<BulkProjectPermissionGrants>;
};

/**
 * Details of global permissions to look up and project permissions with associated projects and issues to look up.
 */
export type BulkPermissionsRequestBean = {
  /**
   * The account ID of a user.
   */
  accountId?: string;
  /**
   * Global permissions to look up.
   */
  globalPermissions?: Array<string>;
  /**
   * Project permissions with associated projects and issues to look up.
   */
  projectPermissions?: Array<BulkProjectPermissions>;
};

/**
 * List of project permissions and the projects and issues those permissions grant access to.
 */
export type BulkProjectPermissionGrants = {
  /**
   * IDs of the issues the user has the permission for.
   */
  issues: Array<number>;
  /**
   * A project permission,
   */
  permission: string;
  /**
   * IDs of the projects the user has the permission for.
   */
  projects: Array<number>;
};

/**
 * Details of project permissions and associated issues and projects to look up.
 */
export type BulkProjectPermissions = {
  /**
   * List of issue IDs.
   */
  issues?: Array<number>;
  /**
   * List of project permissions.
   */
  permissions: Array<string>;
  /**
   * List of project IDs.
   */
  projects?: Array<number>;
};

/**
 * A change item.
 */
export type ChangeDetails = {
  /**
   * The name of the field changed.
   */
  readonly field?: string;
  /**
   * The ID of the field changed.
   */
  readonly fieldId?: string;
  /**
   * The type of the field changed.
   */
  readonly fieldtype?: string;
  /**
   * The details of the original value.
   */
  readonly from?: string;
  /**
   * The details of the original value as a string.
   */
  readonly fromString?: string;
  /**
   * The details of the new value.
   */
  readonly to?: string;
  /**
   * The details of the new value as a string.
   */
  readonly toString?: string;
};

/**
 * The account ID of the new owner.
 */
export type ChangeFilterOwner = {
  /**
   * The account ID of the new owner.
   */
  accountId: string;
};

/**
 * Details of names changed in the record event.
 */
export type ChangedValueBean = {
  /**
   * The value of the field before the change.
   */
  readonly changedFrom?: string;
  /**
   * The value of the field after the change.
   */
  readonly changedTo?: string;
  /**
   * The name of the field changed.
   */
  readonly fieldName?: string;
};

/**
 * Details of a changed worklog.
 */
export type ChangedWorklog = {
  /**
   * Details of properties associated with the change.
   */
  readonly properties?: Array<EntityProperty>;
  /**
   * The datetime of the change.
   */
  readonly updatedTime?: number;
  /**
   * The ID of the worklog.
   */
  readonly worklogId?: number;
};

/**
 * List of changed worklogs.
 */
export type ChangedWorklogs = {
  lastPage?: boolean;
  /**
   * The URL of the next list of changed worklogs.
   */
  readonly nextPage?: string;
  /**
   * The URL of this changed worklogs list.
   */
  readonly self?: string;
  /**
   * The datetime of the first worklog item in the list.
   */
  readonly since?: number;
  /**
   * The datetime of the last worklog item in the list.
   */
  readonly until?: number;
  /**
   * Changed worklog list.
   */
  readonly values?: Array<ChangedWorklog>;
};

/**
 * A log of changes made to issue fields. Changelogs related to workflow associations are currently being deprecated.
 */
export type Changelog = {
  /**
   * The user who made the change.
   */
  readonly author?: UserDetails;
  /**
   * The date on which the change took place.
   */
  readonly created?: string;
  /**
   * The history metadata associated with the changed.
   */
  readonly historyMetadata?: HistoryMetadata;
  /**
   * The ID of the changelog.
   */
  readonly id?: string;
  /**
   * The list of items changed.
   */
  readonly items?: Array<ChangeDetails>;
};

/**
 * Details of an issue navigator column item.
 */
export type ColumnItem = {
  /**
   * The issue navigator column label.
   */
  label?: string;
  /**
   * The issue navigator column value.
   */
  value?: string;
};

export type ColumnRequestBody = {
  columns?: Array<string>;
};

/**
 * A comment.
 */
export type Comment = {
  /**
   * The ID of the user who created the comment.
   */
  readonly author?: UserDetails;
  /**
   * The comment text in [Atlassian Document Format](https://developer.atlassian.com/cloud/jira/platform/apis/document/structure/).
   */
  body?: string;
  /**
   * The date and time at which the comment was created.
   */
  readonly created?: string;
  /**
   * The ID of the comment.
   */
  readonly id?: string;
  /**
   * Whether the comment was added from an email sent by a person who is not part of the issue. See [Allow external emails to be added as comments on issues](https://support.atlassian.com/jira-service-management-cloud/docs/allow-external-emails-to-be-added-as-comments-on-issues/)for information on setting up this feature.
   */
  readonly jsdAuthorCanSeeRequest?: boolean;
  /**
   * Whether the comment is visible in Jira Service Desk. Defaults to true when comments are created in the Jira Cloud Platform. This includes when the site doesn't use Jira Service Desk or the project isn't a Jira Service Desk project and, therefore, there is no Jira Service Desk for the issue to be visible on. To create a comment with its visibility in Jira Service Desk set to false, use the Jira Service Desk REST API [Create request comment](https://developer.atlassian.com/cloud/jira/service-desk/rest/#api-rest-servicedeskapi-request-issueIdOrKey-comment-post) operation.
   */
  readonly jsdPublic?: boolean;
  /**
   * A list of comment properties. Optional on create and update.
   */
  properties?: Array<EntityProperty>;
  /**
   * The rendered version of the comment.
   */
  readonly renderedBody?: string;
  /**
   * The URL of the comment.
   */
  readonly self?: string;
  /**
   * The ID of the user who updated the comment last.
   */
  readonly updateAuthor?: UserDetails;
  /**
   * The date and time at which the comment was updated last.
   */
  readonly updated?: string;
  /**
   * The group or role to which this comment is visible. Optional on create and update.
   */
  visibility?: Visibility;
};

/**
 * Count of issues assigned to a component.
 */
export type ComponentIssuesCount = {
  /**
   * The count of issues assigned to a component.
   */
  readonly issueCount?: number;
  /**
   * The URL for this count of issues for a component.
   */
  readonly self?: string;
};

export type ComponentJsonBean = {
  ari?: string;
  description?: string;
  id?: string;
  metadata?: {
    [key: string]: string;
  };
  name?: string;
  self?: string;
};

/**
 * Details about a component with a count of the issues it contains.
 */
export type ComponentWithIssueCount = {
  /**
   * The details of the user associated with `assigneeType`, if any. See `realAssignee` for details of the user assigned to issues created with this component.
   */
  assignee?: User;
  /**
   * The nominal user type used to determine the assignee for issues created with this component. See `realAssigneeType` for details on how the type of the user, and hence the user, assigned to issues is determined. Takes the following values:
   *
   * *  `PROJECT_LEAD` the assignee to any issues created with this component is nominally the lead for the project the component is in.
   * *  `COMPONENT_LEAD` the assignee to any issues created with this component is nominally the lead for the component.
   * *  `UNASSIGNED` an assignee is not set for issues created with this component.
   * *  `PROJECT_DEFAULT` the assignee to any issues created with this component is nominally the default assignee for the project that the component is in.
   */
  readonly assigneeType?: 'PROJECT_DEFAULT' | 'COMPONENT_LEAD' | 'PROJECT_LEAD' | 'UNASSIGNED';
  /**
   * The description for the component.
   */
  readonly description?: string;
  /**
   * The unique identifier for the component.
   */
  readonly id?: string;
  /**
   * Whether a user is associated with `assigneeType`. For example, if the `assigneeType` is set to `COMPONENT_LEAD` but the component lead is not set, then `false` is returned.
   */
  readonly isAssigneeTypeValid?: boolean;
  /**
   * Count of issues for the component.
   */
  readonly issueCount?: number;
  /**
   * The user details for the component's lead user.
   */
  lead?: User;
  /**
   * The name for the component.
   */
  readonly name?: string;
  /**
   * The key of the project to which the component is assigned.
   */
  readonly project?: string;
  /**
   * Not used.
   */
  readonly projectId?: number;
  /**
   * The user assigned to issues created with this component, when `assigneeType` does not identify a valid assignee.
   */
  realAssignee?: User;
  /**
   * The type of the assignee that is assigned to issues created with this component, when an assignee cannot be set from the `assigneeType`. For example, `assigneeType` is set to `COMPONENT_LEAD` but no component lead is set. This property is set to one of the following values:
   *
   * *  `PROJECT_LEAD` when `assigneeType` is `PROJECT_LEAD` and the project lead has permission to be assigned issues in the project that the component is in.
   * *  `COMPONENT_LEAD` when `assignee`Type is `COMPONENT_LEAD` and the component lead has permission to be assigned issues in the project that the component is in.
   * *  `UNASSIGNED` when `assigneeType` is `UNASSIGNED` and Jira is configured to allow unassigned issues.
   * *  `PROJECT_DEFAULT` when none of the preceding cases are true.
   */
  readonly realAssigneeType?: 'PROJECT_DEFAULT' | 'COMPONENT_LEAD' | 'PROJECT_LEAD' | 'UNASSIGNED';
  /**
   * The URL for this count of the issues contained in the component.
   */
  readonly self?: string;
};

/**
 * The nominal user type used to determine the assignee for issues created with this component. See `realAssigneeType` for details on how the type of the user, and hence the user, assigned to issues is determined. Takes the following values:
 *
 * *  `PROJECT_LEAD` the assignee to any issues created with this component is nominally the lead for the project the component is in.
 * *  `COMPONENT_LEAD` the assignee to any issues created with this component is nominally the lead for the component.
 * *  `UNASSIGNED` an assignee is not set for issues created with this component.
 * *  `PROJECT_DEFAULT` the assignee to any issues created with this component is nominally the default assignee for the project that the component is in.
 */
export type assigneeType = 'PROJECT_DEFAULT' | 'COMPONENT_LEAD' | 'PROJECT_LEAD' | 'UNASSIGNED';

/**
 * The type of the assignee that is assigned to issues created with this component, when an assignee cannot be set from the `assigneeType`. For example, `assigneeType` is set to `COMPONENT_LEAD` but no component lead is set. This property is set to one of the following values:
 *
 * *  `PROJECT_LEAD` when `assigneeType` is `PROJECT_LEAD` and the project lead has permission to be assigned issues in the project that the component is in.
 * *  `COMPONENT_LEAD` when `assignee`Type is `COMPONENT_LEAD` and the component lead has permission to be assigned issues in the project that the component is in.
 * *  `UNASSIGNED` when `assigneeType` is `UNASSIGNED` and Jira is configured to allow unassigned issues.
 * *  `PROJECT_DEFAULT` when none of the preceding cases are true.
 */
export type realAssigneeType = 'PROJECT_DEFAULT' | 'COMPONENT_LEAD' | 'PROJECT_LEAD' | 'UNASSIGNED';

/**
 * A JQL query clause that consists of nested clauses. For example, `(labels in (urgent, blocker) OR lastCommentedBy = currentUser()). Note that, where nesting is not defined, the parser nests JQL clauses based on the operator precedence. For example, "A OR B AND C" is parsed as "(A OR B) AND C". See Setting the precedence of operators for more information about precedence in JQL queries.`
 */
export type CompoundClause = {
  /**
   * The list of nested clauses.
   */
  clauses: Array<JqlQueryClause>;
  /**
   * The operator between the clauses.
   */
  operator: 'and' | 'or' | 'not';
};

/**
 * The operator between the clauses.
 */
export type operator = 'and' | 'or' | 'not';

/**
 * The conditions group associated with the transition.
 */
export type ConditionGroupConfiguration = {
  /**
   * The nested conditions of the condition group.
   */
  conditionGroups?: Array<ConditionGroupConfiguration>;
  /**
   * The rules for this condition.
   */
  conditions?: Array<WorkflowRuleConfiguration>;
  /**
   * Determines how the conditions in the group are evaluated. Accepts either `ANY` or `ALL`. If `ANY` is used, at least one condition in the group must be true for the group to evaluate to true. If `ALL` is used, all conditions in the group must be true for the group to evaluate to true.
   */
  operation?: 'ANY' | 'ALL';
} | null;

/**
 * Determines how the conditions in the group are evaluated. Accepts either `ANY` or `ALL`. If `ANY` is used, at least one condition in the group must be true for the group to evaluate to true. If `ALL` is used, all conditions in the group must be true for the group to evaluate to true.
 */
export type operation = 'ANY' | 'ALL';

/**
 * The conditions group associated with the transition.
 */
export type ConditionGroupUpdate = {
  /**
   * The nested conditions of the condition group.
   */
  conditionGroups?: Array<ConditionGroupUpdate>;
  /**
   * The rules for this condition.
   */
  conditions?: Array<WorkflowRuleConfiguration>;
  /**
   * Determines how the conditions in the group are evaluated. Accepts either `ANY` or `ALL`. If `ANY` is used, at least one condition in the group must be true for the group to evaluate to true. If `ALL` is used, all conditions in the group must be true for the group to evaluate to true.
   */
  operation: 'ANY' | 'ALL';
} | null;

/**
 * Details about the configuration of Jira.
 */
export type Configuration = {
  /**
   * Whether the ability to add attachments to issues is enabled.
   */
  readonly attachmentsEnabled?: boolean;
  /**
   * Whether the ability to link issues is enabled.
   */
  readonly issueLinkingEnabled?: boolean;
  /**
   * Whether the ability to create subtasks for issues is enabled.
   */
  readonly subTasksEnabled?: boolean;
  /**
   * The configuration of time tracking.
   */
  readonly timeTrackingConfiguration?: TimeTrackingConfiguration;
  /**
   * Whether the ability to track time is enabled. This property is deprecated.
   */
  readonly timeTrackingEnabled?: boolean;
  /**
   * Whether the ability to create unassigned issues is enabled. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.
   */
  readonly unassignedIssuesAllowed?: boolean;
  /**
   * Whether the ability for users to vote on issues is enabled. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.
   */
  readonly votingEnabled?: boolean;
  /**
   * Whether the ability for users to watch issues is enabled. See [Configuring Jira application options](https://confluence.atlassian.com/x/uYXKM) for details.
   */
  readonly watchingEnabled?: boolean;
};

/**
 * List of custom fields identifiers which will be used to filter configurations
 */
export type ConfigurationsListParameters = {
  /**
   * List of IDs or keys of the custom fields. It can be a mix of IDs and keys in the same query.
   */
  fieldIdsOrKeys: Array<string>;
};

/**
 * A list of custom field details.
 */
export type ConnectCustomFieldValue = {
  /**
   * The type of custom field.
   */
  _type:
    | 'StringIssueField'
    | 'NumberIssueField'
    | 'RichTextIssueField'
    | 'SingleSelectIssueField'
    | 'MultiSelectIssueField'
    | 'TextIssueField';
  /**
   * The custom field ID.
   */
  fieldID: number;
  /**
   * The issue ID.
   */
  issueID: number;
  /**
   * The value of number type custom field when `_type` is `NumberIssueField`.
   */
  number?: number;
  /**
   * The value of single select and multiselect custom field type when `_type` is `SingleSelectIssueField` or `MultiSelectIssueField`.
   */
  optionID?: string;
  /**
   * The value of richText type custom field when `_type` is `RichTextIssueField`.
   */
  richText?: string;
  /**
   * The value of string type custom field when `_type` is `StringIssueField`.
   */
  string?: string;
  /**
   * The value of of text custom field type when `_type` is `TextIssueField`.
   */
  text?: string;
};

/**
 * The type of custom field.
 */
export type _type =
  | 'StringIssueField'
  | 'NumberIssueField'
  | 'RichTextIssueField'
  | 'SingleSelectIssueField'
  | 'MultiSelectIssueField'
  | 'TextIssueField';

/**
 * Details of updates for a custom field.
 */
export type ConnectCustomFieldValues = {
  /**
   * The list of custom field update details.
   */
  updateValueList?: Array<ConnectCustomFieldValue>;
};

/**
 * A [Connect module](https://developer.atlassian.com/cloud/jira/platform/about-jira-modules/) in the same format as in the
 * [app descriptor](https://developer.atlassian.com/cloud/jira/platform/app-descriptor/).
 */
export type ConnectModule = {
  [key: string]: string;
};

export type ConnectModules = {
  /**
   * A list of app modules in the same format as the `modules` property in the
   * [app descriptor](https://developer.atlassian.com/cloud/jira/platform/app-descriptor/).
   */
  modules: Array<ConnectModule>;
};

/**
 * A workflow transition rule.
 */
export type ConnectWorkflowTransitionRule = {
  configuration: RuleConfiguration;
  /**
   * The ID of the transition rule.
   */
  id: string;
  /**
   * The key of the rule, as defined in the Connect app descriptor.
   */
  key: string;
  transition?: WorkflowTransition;
};

/**
 * The list of features on a project.
 */
export type ContainerForProjectFeatures = {
  /**
   * The project features.
   */
  features?: Array<ProjectFeature>;
};

/**
 * Container for a list of registered webhooks. Webhook details are returned in the same order as the request.
 */
export type ContainerForRegisteredWebhooks = {
  /**
   * A list of registered webhooks.
   */
  webhookRegistrationResult?: Array<RegisteredWebhook>;
};

/**
 * Container for a list of webhook IDs.
 */
export type ContainerForWebhookIDs = {
  /**
   * A list of webhook IDs.
   */
  webhookIds: Array<number>;
};

/**
 * A container for a list of workflow schemes together with the projects they are associated with.
 */
export type ContainerOfWorkflowSchemeAssociations = {
  /**
   * A list of workflow schemes together with projects they are associated with.
   */
  values: Array<WorkflowSchemeAssociations>;
};

/**
 * A context.
 */
export type Context = {
  /**
   * The ID of the context.
   */
  readonly id?: number;
  /**
   * The name of the context.
   */
  readonly name?: string;
  /**
   * The scope of the context.
   */
  scope?: Scope;
};

/**
 * The project and issue type mapping with a matching custom field context.
 */
export type ContextForProjectAndIssueType = {
  /**
   * The ID of the custom field context.
   */
  contextId: string;
  /**
   * The ID of the issue type.
   */
  issueTypeId: string;
  /**
   * The ID of the project.
   */
  projectId: string;
};

/**
 * Details of the contextual configuration for a custom field.
 */
export type ContextualConfiguration = {
  /**
   * The field configuration.
   */
  configuration?: string;
  /**
   * The ID of the field context the configuration is associated with.
   */
  readonly fieldContextId: string;
  /**
   * The ID of the configuration.
   */
  id: string;
  /**
   * The field value schema.
   */
  schema?: string;
};

/**
 * The converted JQL queries.
 */
export type ConvertedJQLQueries = {
  /**
   * List of queries containing user information that could not be mapped to an existing user
   */
  queriesWithUnknownUsers?: Array<JQLQueryWithUnknownUsers>;
  /**
   * The list of converted query strings with account IDs in place of user identifiers.
   */
  queryStrings?: Array<string>;
};

/**
 * The details of a created custom field context.
 */
export type CreateCustomFieldContext = {
  /**
   * The description of the context.
   */
  description?: string;
  /**
   * The ID of the context.
   */
  readonly id?: string;
  /**
   * The list of issue types IDs for the context. If the list is empty, the context refers to all issue types.
   */
  issueTypeIds?: Array<string>;
  /**
   * The name of the context.
   */
  name: string;
  /**
   * The list of project IDs associated with the context. If the list is empty, the context is global.
   */
  projectIds?: Array<string>;
};

/**
 * Issue security scheme and it's details
 */
export type CreateIssueSecuritySchemeDetails = {
  /**
   * The description of the issue security scheme.
   */
  description?: string;
  /**
   * The list of scheme levels which should be added to the security scheme.
   */
  levels?: Array<SecuritySchemeLevelBean>;
  /**
   * The name of the issue security scheme. Must be unique (case-insensitive).
   */
  name: string;
};

/**
 * Details of an notification scheme.
 */
export type CreateNotificationSchemeDetails = {
  /**
   * The description of the notification scheme.
   */
  description?: string;
  /**
   * The name of the notification scheme. Must be unique (case-insensitive).
   */
  name: string;
  /**
   * The list of notifications which should be added to the notification scheme.
   */
  notificationSchemeEvents?: Array<NotificationSchemeEventDetails>;
};

/**
 * Details of an issue priority.
 */
export type CreatePriorityDetails = {
  /**
   * The ID for the avatar for the priority. Either the iconUrl or avatarId must be defined, but not both. This parameter is nullable and will become mandatory once the iconUrl parameter is deprecated.
   */
  avatarId?: number;
  /**
   * The description of the priority.
   */
  description?: string | null;
  /**
   * The URL of an icon for the priority. Accepted protocols are HTTP and HTTPS. Built in icons can also be used. Either the iconUrl or avatarId must be defined, but not both.
   */
  iconUrl?:
    | (
        | '/images/icons/priorities/blocker.png'
        | '/images/icons/priorities/critical.png'
        | '/images/icons/priorities/high.png'
        | '/images/icons/priorities/highest.png'
        | '/images/icons/priorities/low.png'
        | '/images/icons/priorities/lowest.png'
        | '/images/icons/priorities/major.png'
        | '/images/icons/priorities/medium.png'
        | '/images/icons/priorities/minor.png'
        | '/images/icons/priorities/trivial.png'
        | '/images/icons/priorities/blocker_new.png'
        | '/images/icons/priorities/critical_new.png'
        | '/images/icons/priorities/high_new.png'
        | '/images/icons/priorities/highest_new.png'
        | '/images/icons/priorities/low_new.png'
        | '/images/icons/priorities/lowest_new.png'
        | '/images/icons/priorities/major_new.png'
        | '/images/icons/priorities/medium_new.png'
        | '/images/icons/priorities/minor_new.png'
        | '/images/icons/priorities/trivial_new.png'
      )
    | null;
  /**
   * The name of the priority. Must be unique.
   */
  name: string;
  /**
   * The status color of the priority in 3-digit or 6-digit hexadecimal format.
   */
  statusColor: string;
};

/**
 * The URL of an icon for the priority. Accepted protocols are HTTP and HTTPS. Built in icons can also be used. Either the iconUrl or avatarId must be defined, but not both.
 */
export type iconUrl =
  | '/images/icons/priorities/blocker.png'
  | '/images/icons/priorities/critical.png'
  | '/images/icons/priorities/high.png'
  | '/images/icons/priorities/highest.png'
  | '/images/icons/priorities/low.png'
  | '/images/icons/priorities/lowest.png'
  | '/images/icons/priorities/major.png'
  | '/images/icons/priorities/medium.png'
  | '/images/icons/priorities/minor.png'
  | '/images/icons/priorities/trivial.png'
  | '/images/icons/priorities/blocker_new.png'
  | '/images/icons/priorities/critical_new.png'
  | '/images/icons/priorities/high_new.png'
  | '/images/icons/priorities/highest_new.png'
  | '/images/icons/priorities/low_new.png'
  | '/images/icons/priorities/lowest_new.png'
  | '/images/icons/priorities/major_new.png'
  | '/images/icons/priorities/medium_new.png'
  | '/images/icons/priorities/minor_new.png'
  | '/images/icons/priorities/trivial_new.png';

/**
 * Details of a new priority scheme
 */
export type CreatePrioritySchemeDetails = {
  /**
   * The ID of the default priority for the priority scheme.
   */
  defaultPriorityId: number;
  /**
   * The description of the priority scheme.
   */
  description?: string;
  /**
   * Mappings of issue priorities for issues being migrated in and out of this priority scheme.
   */
  mappings?: PriorityMapping;
  /**
   * The name of the priority scheme. Must be unique.
   */
  name: string;
  /**
   * The IDs of priorities in the scheme.
   */
  priorityIds: Array<number>;
  /**
   * The IDs of projects that will use the priority scheme.
   */
  projectIds?: Array<number>;
};

/**
 * Details about the project.
 */
export type CreateProjectDetails = {
  /**
   * The default assignee when creating issues for this project.
   */
  assigneeType?: 'PROJECT_LEAD' | 'UNASSIGNED';
  /**
   * An integer value for the project's avatar.
   */
  avatarId?: number;
  /**
   * The ID of the project's category. A complete list of category IDs is found using the [Get all project categories](#api-rest-api-3-projectCategory-get) operation.
   */
  categoryId?: number;
  /**
   * A brief description of the project.
   */
  description?: string;
  /**
   * The ID of the field configuration scheme for the project. Use the [Get all field configuration schemes](#api-rest-api-3-fieldconfigurationscheme-get) operation to get a list of field configuration scheme IDs. If you specify the field configuration scheme you cannot specify the project template key.
   */
  fieldConfigurationScheme?: number;
  /**
   * The ID of the issue security scheme for the project, which enables you to control who can and cannot view issues. Use the [Get issue security schemes](#api-rest-api-3-issuesecurityschemes-get) resource to get all issue security scheme IDs.
   */
  issueSecurityScheme?: number;
  /**
   * The ID of the issue type scheme for the project. Use the [Get all issue type schemes](#api-rest-api-3-issuetypescheme-get) operation to get a list of issue type scheme IDs. If you specify the issue type scheme you cannot specify the project template key.
   */
  issueTypeScheme?: number;
  /**
   * The ID of the issue type screen scheme for the project. Use the [Get all issue type screen schemes](#api-rest-api-3-issuetypescreenscheme-get) operation to get a list of issue type screen scheme IDs. If you specify the issue type screen scheme you cannot specify the project template key.
   */
  issueTypeScreenScheme?: number;
  /**
   * Project keys must be unique and start with an uppercase letter followed by one or more uppercase alphanumeric characters. The maximum length is 10 characters.
   */
  key: string;
  /**
   * This parameter is deprecated because of privacy changes. Use `leadAccountId` instead. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details. The user name of the project lead. Either `lead` or `leadAccountId` must be set when creating a project. Cannot be provided with `leadAccountId`.
   */
  lead?: string;
  /**
   * The account ID of the project lead. Either `lead` or `leadAccountId` must be set when creating a project. Cannot be provided with `lead`.
   */
  leadAccountId?: string;
  /**
   * The name of the project.
   */
  name: string;
  /**
   * The ID of the notification scheme for the project. Use the [Get notification schemes](#api-rest-api-3-notificationscheme-get) resource to get a list of notification scheme IDs.
   */
  notificationScheme?: number;
  /**
   * The ID of the permission scheme for the project. Use the [Get all permission schemes](#api-rest-api-3-permissionscheme-get) resource to see a list of all permission scheme IDs.
   */
  permissionScheme?: number;
  /**
   * A predefined configuration for a project. The type of the `projectTemplateKey` must match with the type of the `projectTypeKey`.
   */
  projectTemplateKey?:
    | 'com.pyxis.greenhopper.jira:gh-simplified-agility-kanban'
    | 'com.pyxis.greenhopper.jira:gh-simplified-agility-scrum'
    | 'com.pyxis.greenhopper.jira:gh-simplified-basic'
    | 'com.pyxis.greenhopper.jira:gh-simplified-kanban-classic'
    | 'com.pyxis.greenhopper.jira:gh-simplified-scrum-classic'
    | 'com.pyxis.greenhopper.jira:gh-cross-team-template'
    | 'com.pyxis.greenhopper.jira:gh-cross-team-planning-template'
    | 'com.atlassian.servicedesk:simplified-it-service-management'
    | 'com.atlassian.servicedesk:simplified-it-service-management-basic'
    | 'com.atlassian.servicedesk:simplified-general-service-desk'
    | 'com.atlassian.servicedesk:simplified-general-service-desk-it'
    | 'com.atlassian.servicedesk:simplified-general-service-desk-business'
    | 'com.atlassian.servicedesk:simplified-internal-service-desk'
    | 'com.atlassian.servicedesk:simplified-external-service-desk'
    | 'com.atlassian.servicedesk:simplified-hr-service-desk'
    | 'com.atlassian.servicedesk:simplified-facilities-service-desk'
    | 'com.atlassian.servicedesk:simplified-legal-service-desk'
    | 'com.atlassian.servicedesk:simplified-marketing-service-desk'
    | 'com.atlassian.servicedesk:simplified-finance-service-desk'
    | 'com.atlassian.servicedesk:simplified-analytics-service-desk'
    | 'com.atlassian.servicedesk:simplified-design-service-desk'
    | 'com.atlassian.servicedesk:simplified-sales-service-desk'
    | 'com.atlassian.servicedesk:simplified-halp-service-desk'
    | 'com.atlassian.servicedesk:simplified-blank-project-it'
    | 'com.atlassian.servicedesk:simplified-blank-project-business'
    | 'com.atlassian.servicedesk:next-gen-it-service-desk'
    | 'com.atlassian.servicedesk:next-gen-hr-service-desk'
    | 'com.atlassian.servicedesk:next-gen-legal-service-desk'
    | 'com.atlassian.servicedesk:next-gen-marketing-service-desk'
    | 'com.atlassian.servicedesk:next-gen-facilities-service-desk'
    | 'com.atlassian.servicedesk:next-gen-general-service-desk'
    | 'com.atlassian.servicedesk:next-gen-general-it-service-desk'
    | 'com.atlassian.servicedesk:next-gen-general-business-service-desk'
    | 'com.atlassian.servicedesk:next-gen-analytics-service-desk'
    | 'com.atlassian.servicedesk:next-gen-finance-service-desk'
    | 'com.atlassian.servicedesk:next-gen-design-service-desk'
    | 'com.atlassian.servicedesk:next-gen-sales-service-desk'
    | 'com.atlassian.jira-core-project-templates:jira-core-simplified-content-management'
    | 'com.atlassian.jira-core-project-templates:jira-core-simplified-document-approval'
    | 'com.atlassian.jira-core-project-templates:jira-core-simplified-lead-tracking'
    | 'com.atlassian.jira-core-project-templates:jira-core-simplified-process-control'
    | 'com.atlassian.jira-core-project-templates:jira-core-simplified-procurement'
    | 'com.atlassian.jira-core-project-templates:jira-core-simplified-project-management'
    | 'com.atlassian.jira-core-project-templates:jira-core-simplified-recruitment'
    | 'com.atlassian.jira-core-project-templates:jira-core-simplified-task-';
  /**
   * The [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes), which defines the application-specific feature set. If you don't specify the project template you have to specify the project type.
   */
  projectTypeKey?: 'software' | 'service_desk' | 'business';
  /**
   * A link to information about this project, such as project documentation
   */
  url?: string;
  /**
   * The ID of the workflow scheme for the project. Use the [Get all workflow schemes](#api-rest-api-3-workflowscheme-get) operation to get a list of workflow scheme IDs. If you specify the workflow scheme you cannot specify the project template key.
   */
  workflowScheme?: number;
};

/**
 * The default assignee when creating issues for this project.
 */
export type assigneeType2 = 'PROJECT_LEAD' | 'UNASSIGNED';

/**
 * A predefined configuration for a project. The type of the `projectTemplateKey` must match with the type of the `projectTypeKey`.
 */
export type projectTemplateKey =
  | 'com.pyxis.greenhopper.jira:gh-simplified-agility-kanban'
  | 'com.pyxis.greenhopper.jira:gh-simplified-agility-scrum'
  | 'com.pyxis.greenhopper.jira:gh-simplified-basic'
  | 'com.pyxis.greenhopper.jira:gh-simplified-kanban-classic'
  | 'com.pyxis.greenhopper.jira:gh-simplified-scrum-classic'
  | 'com.pyxis.greenhopper.jira:gh-cross-team-template'
  | 'com.pyxis.greenhopper.jira:gh-cross-team-planning-template'
  | 'com.atlassian.servicedesk:simplified-it-service-management'
  | 'com.atlassian.servicedesk:simplified-it-service-management-basic'
  | 'com.atlassian.servicedesk:simplified-general-service-desk'
  | 'com.atlassian.servicedesk:simplified-general-service-desk-it'
  | 'com.atlassian.servicedesk:simplified-general-service-desk-business'
  | 'com.atlassian.servicedesk:simplified-internal-service-desk'
  | 'com.atlassian.servicedesk:simplified-external-service-desk'
  | 'com.atlassian.servicedesk:simplified-hr-service-desk'
  | 'com.atlassian.servicedesk:simplified-facilities-service-desk'
  | 'com.atlassian.servicedesk:simplified-legal-service-desk'
  | 'com.atlassian.servicedesk:simplified-marketing-service-desk'
  | 'com.atlassian.servicedesk:simplified-finance-service-desk'
  | 'com.atlassian.servicedesk:simplified-analytics-service-desk'
  | 'com.atlassian.servicedesk:simplified-design-service-desk'
  | 'com.atlassian.servicedesk:simplified-sales-service-desk'
  | 'com.atlassian.servicedesk:simplified-halp-service-desk'
  | 'com.atlassian.servicedesk:simplified-blank-project-it'
  | 'com.atlassian.servicedesk:simplified-blank-project-business'
  | 'com.atlassian.servicedesk:next-gen-it-service-desk'
  | 'com.atlassian.servicedesk:next-gen-hr-service-desk'
  | 'com.atlassian.servicedesk:next-gen-legal-service-desk'
  | 'com.atlassian.servicedesk:next-gen-marketing-service-desk'
  | 'com.atlassian.servicedesk:next-gen-facilities-service-desk'
  | 'com.atlassian.servicedesk:next-gen-general-service-desk'
  | 'com.atlassian.servicedesk:next-gen-general-it-service-desk'
  | 'com.atlassian.servicedesk:next-gen-general-business-service-desk'
  | 'com.atlassian.servicedesk:next-gen-analytics-service-desk'
  | 'com.atlassian.servicedesk:next-gen-finance-service-desk'
  | 'com.atlassian.servicedesk:next-gen-design-service-desk'
  | 'com.atlassian.servicedesk:next-gen-sales-service-desk'
  | 'com.atlassian.jira-core-project-templates:jira-core-simplified-content-management'
  | 'com.atlassian.jira-core-project-templates:jira-core-simplified-document-approval'
  | 'com.atlassian.jira-core-project-templates:jira-core-simplified-lead-tracking'
  | 'com.atlassian.jira-core-project-templates:jira-core-simplified-process-control'
  | 'com.atlassian.jira-core-project-templates:jira-core-simplified-procurement'
  | 'com.atlassian.jira-core-project-templates:jira-core-simplified-project-management'
  | 'com.atlassian.jira-core-project-templates:jira-core-simplified-recruitment'
  | 'com.atlassian.jira-core-project-templates:jira-core-simplified-task-';

/**
 * The [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes), which defines the application-specific feature set. If you don't specify the project template you have to specify the project type.
 */
export type projectTypeKey = 'software' | 'service_desk' | 'business';

/**
 * Details of an issue resolution.
 */
export type CreateResolutionDetails = {
  /**
   * The description of the resolution.
   */
  description?: string;
  /**
   * The name of the resolution. Must be unique (case-insensitive).
   */
  name: string;
};

/**
 * The details of a UI modification.
 */
export type CreateUiModificationDetails = {
  /**
   * List of contexts of the UI modification. The maximum number of contexts is 1000.
   */
  contexts?: Array<UiModificationContextDetails>;
  /**
   * The data of the UI modification. The maximum size of the data is 50000 characters.
   */
  data?: string;
  /**
   * The description of the UI modification. The maximum length is 255 characters.
   */
  description?: string;
  /**
   * The name of the UI modification. The maximum length is 255 characters.
   */
  name: string;
};

export type CreateUpdateRoleRequestBean = {
  /**
   * A description of the project role. Required when fully updating a project role. Optional when creating or partially updating a project role.
   */
  description?: string;
  /**
   * The name of the project role. Must be unique. Cannot begin or end with whitespace. The maximum length is 255 characters. Required when creating a project role. Optional when partially updating a project role.
   */
  name?: string;
};

/**
 * A workflow transition condition.
 */
export type CreateWorkflowCondition = {
  /**
   * The list of workflow conditions.
   */
  conditions?: Array<CreateWorkflowCondition>;
  /**
   * EXPERIMENTAL. The configuration of the transition rule.
   */
  configuration?: {
    [key: string]: string;
  };
  /**
   * The compound condition operator.
   */
  operator?: 'AND' | 'OR';
  /**
   * The type of the transition rule.
   */
  type?: string;
};

/**
 * The compound condition operator.
 */
export type operator2 = 'AND' | 'OR';

/**
 * The details of a workflow.
 */
export type CreateWorkflowDetails = {
  /**
   * The description of the workflow. The maximum length is 1000 characters.
   */
  description?: string;
  /**
   * The name of the workflow. The name must be unique. The maximum length is 255 characters. Characters can be separated by a whitespace but the name cannot start or end with a whitespace.
   */
  name: string;
  /**
   * The statuses of the workflow. Any status that does not include a transition is added to the workflow without a transition.
   */
  statuses: Array<CreateWorkflowStatusDetails>;
  /**
   * The transitions of the workflow. For the request to be valid, these transitions must:
   *
   * *  include one *initial* transition.
   * *  not use the same name for a *global* and *directed* transition.
   * *  have a unique name for each *global* transition.
   * *  have a unique 'to' status for each *global* transition.
   * *  have unique names for each transition from a status.
   * *  not have a 'from' status on *initial* and *global* transitions.
   * *  have a 'from' status on *directed* transitions.
   *
   * All the transition statuses must be included in `statuses`.
   */
  transitions: Array<CreateWorkflowTransitionDetails>;
};

/**
 * The details of a transition status.
 */
export type CreateWorkflowStatusDetails = {
  /**
   * The ID of the status.
   */
  id: string;
  /**
   * The properties of the status.
   */
  properties?: {
    [key: string]: string;
  };
};

/**
 * The details of a workflow transition.
 */
export type CreateWorkflowTransitionDetails = {
  /**
   * The description of the transition. The maximum length is 1000 characters.
   */
  description?: string;
  /**
   * The statuses the transition can start from.
   */
  from?: Array<string>;
  /**
   * The name of the transition. The maximum length is 60 characters.
   */
  name: string;
  /**
   * The properties of the transition.
   */
  properties?: {
    [key: string]: string;
  };
  /**
   * The rules of the transition.
   */
  rules?: CreateWorkflowTransitionRulesDetails;
  /**
   * The screen of the transition.
   */
  screen?: CreateWorkflowTransitionScreenDetails;
  /**
   * The status the transition goes to.
   */
  to: string;
  /**
   * The type of the transition.
   */
  type: 'global' | 'initial' | 'directed';
};

/**
 * The type of the transition.
 */
export type type = 'global' | 'initial' | 'directed';

/**
 * A workflow transition rule.
 */
export type CreateWorkflowTransitionRule = {
  /**
   * EXPERIMENTAL. The configuration of the transition rule.
   */
  configuration?: {
    [key: string]: string;
  };
  /**
   * The type of the transition rule.
   */
  type: string;
};

/**
 * The details of a workflow transition rules.
 */
export type CreateWorkflowTransitionRulesDetails = {
  /**
   * The workflow conditions.
   */
  conditions?: CreateWorkflowCondition;
  /**
   * The workflow post functions.
   *
   * **Note:** The default post functions are always added to the *initial* transition, as in:
   *
   * "postFunctions": [
   * {
   * "type": "IssueCreateFunction"
   * },
   * {
   * "type": "IssueReindexFunction"
   * },
   * {
   * "type": "FireIssueEventFunction",
   * "configuration": {
   * "event": {
   * "id": "1",
   * "name": "issue_created"
   * }
   * }
   * }
   * ]
   *
   * **Note:** The default post functions are always added to the *global* and *directed* transitions, as in:
   *
   * "postFunctions": [
   * {
   * "type": "UpdateIssueStatusFunction"
   * },
   * {
   * "type": "CreateCommentFunction"
   * },
   * {
   * "type": "GenerateChangeHistoryFunction"
   * },
   * {
   * "type": "IssueReindexFunction"
   * },
   * {
   * "type": "FireIssueEventFunction",
   * "configuration": {
   * "event": {
   * "id": "13",
   * "name": "issue_generic"
   * }
   * }
   * }
   * ]
   */
  postFunctions?: Array<CreateWorkflowTransitionRule>;
  /**
   * The workflow validators.
   *
   * **Note:** The default permission validator is always added to the *initial* transition, as in:
   *
   * "validators": [
   * {
   * "type": "PermissionValidator",
   * "configuration": {
   * "permissionKey": "CREATE_ISSUES"
   * }
   * }
   * ]
   */
  validators?: Array<CreateWorkflowTransitionRule>;
};

/**
 * The details of a transition screen.
 */
export type CreateWorkflowTransitionScreenDetails = {
  /**
   * The ID of the screen.
   */
  id: string;
};

/**
 * Details about a created issue or subtask.
 */
export type CreatedIssue = {
  /**
   * The ID of the created issue or subtask.
   */
  readonly id?: string;
  /**
   * The key of the created issue or subtask.
   */
  readonly key?: string;
  /**
   * The URL of the created issue or subtask.
   */
  readonly self?: string;
  /**
   * The response code and messages related to any requested transition.
   */
  readonly transition?: NestedResponse;
  /**
   * The response code and messages related to any requested watchers.
   */
  readonly watchers?: NestedResponse;
};

/**
 * Details about the issues created and the errors for requests that failed.
 */
export type CreatedIssues = {
  /**
   * Error details for failed issue creation requests.
   */
  readonly errors?: Array<BulkOperationErrorResult>;
  /**
   * Details of the issues created.
   */
  readonly issues?: Array<CreatedIssue>;
};

export type CustomContextVariable = (UserContextVariable | IssueContextVariable | JsonContextVariable) & {
  /**
   * Type of custom context variable.
   */
  type: string;
};

/**
 * Details of configurations for a custom field.
 */
export type CustomFieldConfigurations = {
  /**
   * The list of custom field configuration details.
   */
  configurations: Array<ContextualConfiguration>;
};

/**
 * The details of a custom field context.
 */
export type CustomFieldContext = {
  /**
   * The description of the context.
   */
  description: string;
  /**
   * The ID of the context.
   */
  id: string;
  /**
   * Whether the context apply to all issue types.
   */
  isAnyIssueType: boolean;
  /**
   * Whether the context is global.
   */
  isGlobalContext: boolean;
  /**
   * The name of the context.
   */
  name: string;
};

export type CustomFieldContextDefaultValue =
  | CustomFieldContextDefaultValueCascadingOption
  | CustomFieldContextDefaultValueMultipleOption
  | CustomFieldContextDefaultValueSingleOption
  | CustomFieldContextSingleUserPickerDefaults
  | CustomFieldContextDefaultValueMultiUserPicker
  | CustomFieldContextDefaultValueSingleGroupPicker
  | CustomFieldContextDefaultValueMultipleGroupPicker
  | CustomFieldContextDefaultValueDate
  | CustomFieldContextDefaultValueDateTime
  | CustomFieldContextDefaultValueURL
  | CustomFieldContextDefaultValueProject
  | CustomFieldContextDefaultValueFloat
  | CustomFieldContextDefaultValueLabels
  | CustomFieldContextDefaultValueTextField
  | CustomFieldContextDefaultValueTextArea
  | CustomFieldContextDefaultValueReadOnly
  | CustomFieldContextDefaultValueSingleVersionPicker
  | CustomFieldContextDefaultValueMultipleVersionPicker
  | CustomFieldContextDefaultValueForgeStringField
  | CustomFieldContextDefaultValueForgeMultiStringField
  | CustomFieldContextDefaultValueForgeObjectField
  | CustomFieldContextDefaultValueForgeDateTimeField
  | CustomFieldContextDefaultValueForgeGroupField
  | CustomFieldContextDefaultValueForgeMultiGroupField
  | CustomFieldContextDefaultValueForgeNumberField
  | CustomFieldContextDefaultValueForgeUserField
  | CustomFieldContextDefaultValueForgeMultiUserField;

/**
 * The default value for a cascading select custom field.
 */
export type CustomFieldContextDefaultValueCascadingOption = {
  /**
   * The ID of the default cascading option.
   */
  cascadingOptionId?: string;
  /**
   * The ID of the context.
   */
  contextId: string;
  /**
   * The ID of the default option.
   */
  optionId: string;
  type: 'option.cascading';
};

/**
 * The default value for a Date custom field.
 */
export type CustomFieldContextDefaultValueDate = {
  /**
   * The default date in ISO format. Ignored if `useCurrent` is true.
   */
  date?: string;
  type: 'datepicker';
  /**
   * Whether to use the current date.
   */
  useCurrent?: boolean;
};

/**
 * The default value for a date time custom field.
 */
export type CustomFieldContextDefaultValueDateTime = {
  /**
   * The default date-time in ISO format. Ignored if `useCurrent` is true.
   */
  dateTime?: string;
  type: 'datetimepicker';
  /**
   * Whether to use the current date.
   */
  useCurrent?: boolean;
};

/**
 * Default value for a float (number) custom field.
 */
export type CustomFieldContextDefaultValueFloat = {
  /**
   * The default floating-point number.
   */
  number: number;
  type: 'float';
};

/**
 * The default value for a Forge date time custom field.
 */
export type CustomFieldContextDefaultValueForgeDateTimeField = {
  /**
   * The ID of the context.
   */
  contextId: string;
  /**
   * The default date-time in ISO format. Ignored if `useCurrent` is true.
   */
  dateTime?: string;
  type: 'forge.datetime';
  /**
   * Whether to use the current date.
   */
  useCurrent?: boolean;
};

/**
 * The default value for a Forge group custom field.
 */
export type CustomFieldContextDefaultValueForgeGroupField = {
  /**
   * The ID of the context.
   */
  contextId: string;
  /**
   * The ID of the the default group.
   */
  groupId: string;
  type: 'forge.group';
};

/**
 * The default value for a Forge collection of groups custom field.
 */
export type CustomFieldContextDefaultValueForgeMultiGroupField = {
  /**
   * The ID of the context.
   */
  contextId: string;
  /**
   * The IDs of the default groups.
   */
  groupIds: Array<string>;
  type: 'forge.group.list';
};

/**
 * The default text for a Forge collection of strings custom field.
 */
export type CustomFieldContextDefaultValueForgeMultiStringField = {
  type: 'forge.string.list';
  /**
   * List of string values. The maximum length for a value is 254 characters.
   */
  values?: Array<string>;
};

/**
 * Defaults for a Forge collection of users custom field.
 */
export type CustomFieldContextDefaultValueForgeMultiUserField = {
  /**
   * The IDs of the default users.
   */
  accountIds: Array<string>;
  /**
   * The ID of the context.
   */
  contextId: string;
  type: 'forge.user.list';
};

/**
 * Default value for a Forge number custom field.
 */
export type CustomFieldContextDefaultValueForgeNumberField = {
  /**
   * The ID of the context.
   */
  contextId: string;
  /**
   * The default floating-point number.
   */
  number: number;
  type: 'forge.number';
};

/**
 * The default value for a Forge object custom field.
 */
export type CustomFieldContextDefaultValueForgeObjectField = {
  /**
   * The default JSON object.
   */
  object?: {
    [key: string]: string;
  };
  type: 'forge.object';
};

/**
 * The default text for a Forge string custom field.
 */
export type CustomFieldContextDefaultValueForgeStringField = {
  /**
   * The ID of the context.
   */
  contextId: string;
  /**
   * The default text. The maximum length is 254 characters.
   */
  text?: string;
  type: 'forge.string';
};

/**
 * Defaults for a Forge user custom field.
 */
export type CustomFieldContextDefaultValueForgeUserField = {
  /**
   * The ID of the default user.
   */
  accountId: string;
  /**
   * The ID of the context.
   */
  contextId: string;
  type: 'forge.user';
  userFilter: UserFilter;
};

/**
 * Default value for a labels custom field.
 */
export type CustomFieldContextDefaultValueLabels = {
  /**
   * The default labels value.
   */
  labels: Array<string>;
  type: 'labels';
};

/**
 * The default value for a User Picker (multiple) custom field.
 */
export type CustomFieldContextDefaultValueMultiUserPicker = {
  /**
   * The IDs of the default users.
   */
  accountIds: Array<string>;
  /**
   * The ID of the context.
   */
  contextId: string;
  type: 'multi.user.select';
};

/**
 * The default value for a multiple group picker custom field.
 */
export type CustomFieldContextDefaultValueMultipleGroupPicker = {
  /**
   * The ID of the context.
   */
  contextId: string;
  /**
   * The IDs of the default groups.
   */
  groupIds: Array<string>;
  type: 'grouppicker.multiple';
};

/**
 * The default value for a multi-select custom field.
 */
export type CustomFieldContextDefaultValueMultipleOption = {
  /**
   * The ID of the context.
   */
  contextId: string;
  /**
   * The list of IDs of the default options.
   */
  optionIds: Array<string>;
  type: 'option.multiple';
};

/**
 * The default value for a multiple version picker custom field.
 */
export type CustomFieldContextDefaultValueMultipleVersionPicker = {
  type: 'version.multiple';
  /**
   * The IDs of the default versions.
   */
  versionIds: Array<string>;
  /**
   * The order the pickable versions are displayed in. If not provided, the released-first order is used. Available version orders are `"releasedFirst"` and `"unreleasedFirst"`.
   */
  versionOrder?: string;
};

/**
 * The default value for a project custom field.
 */
export type CustomFieldContextDefaultValueProject = {
  /**
   * The ID of the context.
   */
  contextId: string;
  /**
   * The ID of the default project.
   */
  projectId: string;
  type: 'project';
};

/**
 * The default text for a read only custom field.
 */
export type CustomFieldContextDefaultValueReadOnly = {
  /**
   * The default text. The maximum length is 255 characters.
   */
  text?: string;
  type: 'readonly';
};

/**
 * The default value for a group picker custom field.
 */
export type CustomFieldContextDefaultValueSingleGroupPicker = {
  /**
   * The ID of the context.
   */
  contextId: string;
  /**
   * The ID of the the default group.
   */
  groupId: string;
  type: 'grouppicker.single';
};

/**
 * The default value for a single select custom field.
 */
export type CustomFieldContextDefaultValueSingleOption = {
  /**
   * The ID of the context.
   */
  contextId: string;
  /**
   * The ID of the default option.
   */
  optionId: string;
  type: 'option.single';
};

/**
 * The default value for a version picker custom field.
 */
export type CustomFieldContextDefaultValueSingleVersionPicker = {
  type: 'version.single';
  /**
   * The ID of the default version.
   */
  versionId: string;
  /**
   * The order the pickable versions are displayed in. If not provided, the released-first order is used. Available version orders are `"releasedFirst"` and `"unreleasedFirst"`.
   */
  versionOrder?: string;
};

/**
 * The default text for a text area custom field.
 */
export type CustomFieldContextDefaultValueTextArea = {
  /**
   * The default text. The maximum length is 32767 characters.
   */
  text?: string;
  type: 'textarea';
};

/**
 * The default text for a text custom field.
 */
export type CustomFieldContextDefaultValueTextField = {
  /**
   * The default text. The maximum length is 254 characters.
   */
  text?: string;
  type: 'textfield';
};

/**
 * The default value for a URL custom field.
 */
export type CustomFieldContextDefaultValueURL = {
  /**
   * The ID of the context.
   */
  contextId: string;
  type: 'url';
  /**
   * The default URL.
   */
  url: string;
};

/**
 * Default values to update.
 */
export type CustomFieldContextDefaultValueUpdate = {
  defaultValues?: Array<CustomFieldContextDefaultValue>;
};

/**
 * Details of the custom field options for a context.
 */
export type CustomFieldContextOption = {
  /**
   * Whether the option is disabled.
   */
  disabled: boolean;
  /**
   * The ID of the custom field option.
   */
  id: string;
  /**
   * For cascading options, the ID of the custom field option containing the cascading option.
   */
  optionId?: string;
  /**
   * The value of the custom field option.
   */
  value: string;
};

/**
 * Details of a context to project association.
 */
export type CustomFieldContextProjectMapping = {
  /**
   * The ID of the context.
   */
  readonly contextId: string;
  /**
   * Whether context is global.
   */
  readonly isGlobalContext?: boolean;
  /**
   * The ID of the project.
   */
  readonly projectId?: string;
};

/**
 * Defaults for a User Picker (single) custom field.
 */
export type CustomFieldContextSingleUserPickerDefaults = {
  /**
   * The ID of the default user.
   */
  accountId: string;
  /**
   * The ID of the context.
   */
  contextId: string;
  type: 'single.user.select';
  userFilter: UserFilter;
};

/**
 * Details of a custom field context.
 */
export type CustomFieldContextUpdateDetails = {
  /**
   * The description of the custom field context. The maximum length is 255 characters.
   */
  description?: string;
  /**
   * The name of the custom field context. The name must be unique. The maximum length is 255 characters.
   */
  name?: string;
};

/**
 * A list of custom field options for a context.
 */
export type CustomFieldCreatedContextOptionsList = {
  /**
   * The created custom field options.
   */
  options?: Array<CustomFieldContextOption>;
};

export type CustomFieldDefinitionJsonBean = {
  /**
   * The description of the custom field, which is displayed in Jira.
   */
  description?: string;
  /**
   * The name of the custom field, which is displayed in Jira. This is not the unique identifier.
   */
  name: string;
  /**
   * The searcher defines the way the field is searched in Jira. For example, *com.atlassian.jira.plugin.system.customfieldtypes:grouppickersearcher*.
   * The search UI (basic search and JQL search) will display different operations and values for the field, based on the field searcher. You must specify a searcher that is valid for the field type, as listed below (abbreviated values shown):
   *
   * *  `cascadingselect`: `cascadingselectsearcher`
   * *  `datepicker`: `daterange`
   * *  `datetime`: `datetimerange`
   * *  `float`: `exactnumber` or `numberrange`
   * *  `grouppicker`: `grouppickersearcher`
   * *  `importid`: `exactnumber` or `numberrange`
   * *  `labels`: `labelsearcher`
   * *  `multicheckboxes`: `multiselectsearcher`
   * *  `multigrouppicker`: `multiselectsearcher`
   * *  `multiselect`: `multiselectsearcher`
   * *  `multiuserpicker`: `userpickergroupsearcher`
   * *  `multiversion`: `versionsearcher`
   * *  `project`: `projectsearcher`
   * *  `radiobuttons`: `multiselectsearcher`
   * *  `readonlyfield`: `textsearcher`
   * *  `select`: `multiselectsearcher`
   * *  `textarea`: `textsearcher`
   * *  `textfield`: `textsearcher`
   * *  `url`: `exacttextsearcher`
   * *  `userpicker`: `userpickergroupsearcher`
   * *  `version`: `versionsearcher`
   *
   * If no searcher is provided, the field isn't searchable. However, [Forge custom fields](https://developer.atlassian.com/platform/forge/manifest-reference/modules/#jira-custom-field-type--beta-) have a searcher set automatically, so are always searchable.
   */
  searcherKey?:
    | 'com.atlassian.jira.plugin.system.customfieldtypes:cascadingselectsearcher'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:daterange'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:datetimerange'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:exactnumber'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:exacttextsearcher'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:grouppickersearcher'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:labelsearcher'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:multiselectsearcher'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:numberrange'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:projectsearcher'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:textsearcher'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:userpickergroupsearcher'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:versionsearcher';
  /**
   * The type of the custom field. These built-in custom field types are available:
   *
   * *  `cascadingselect`: Enables values to be selected from two levels of select lists (value: `com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect`)
   * *  `datepicker`: Stores a date using a picker control (value: `com.atlassian.jira.plugin.system.customfieldtypes:datepicker`)
   * *  `datetime`: Stores a date with a time component (value: `com.atlassian.jira.plugin.system.customfieldtypes:datetime`)
   * *  `float`: Stores and validates a numeric (floating point) input (value: `com.atlassian.jira.plugin.system.customfieldtypes:float`)
   * *  `grouppicker`: Stores a user group using a picker control (value: `com.atlassian.jira.plugin.system.customfieldtypes:grouppicker`)
   * *  `importid`: A read-only field that stores the ID the issue had in the system it was imported from (value: `com.atlassian.jira.plugin.system.customfieldtypes:importid`)
   * *  `labels`: Stores labels (value: `com.atlassian.jira.plugin.system.customfieldtypes:labels`)
   * *  `multicheckboxes`: Stores multiple values using checkboxes (value: ``)
   * *  `multigrouppicker`: Stores multiple user groups using a picker control (value: ``)
   * *  `multiselect`: Stores multiple values using a select list (value: `com.atlassian.jira.plugin.system.customfieldtypes:multicheckboxes`)
   * *  `multiuserpicker`: Stores multiple users using a picker control (value: `com.atlassian.jira.plugin.system.customfieldtypes:multigrouppicker`)
   * *  `multiversion`: Stores multiple versions from the versions available in a project using a picker control (value: `com.atlassian.jira.plugin.system.customfieldtypes:multiversion`)
   * *  `project`: Stores a project from a list of projects that the user is permitted to view (value: `com.atlassian.jira.plugin.system.customfieldtypes:project`)
   * *  `radiobuttons`: Stores a value using radio buttons (value: `com.atlassian.jira.plugin.system.customfieldtypes:radiobuttons`)
   * *  `readonlyfield`: Stores a read-only text value, which can only be populated via the API (value: `com.atlassian.jira.plugin.system.customfieldtypes:readonlyfield`)
   * *  `select`: Stores a value from a configurable list of options (value: `com.atlassian.jira.plugin.system.customfieldtypes:select`)
   * *  `textarea`: Stores a long text string using a multiline text area (value: `com.atlassian.jira.plugin.system.customfieldtypes:textarea`)
   * *  `textfield`: Stores a text string using a single-line text box (value: `com.atlassian.jira.plugin.system.customfieldtypes:textfield`)
   * *  `url`: Stores a URL (value: `com.atlassian.jira.plugin.system.customfieldtypes:url`)
   * *  `userpicker`: Stores a user using a picker control (value: `com.atlassian.jira.plugin.system.customfieldtypes:userpicker`)
   * *  `version`: Stores a version using a picker control (value: `com.atlassian.jira.plugin.system.customfieldtypes:version`)
   *
   * To create a field based on a [Forge custom field type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/#jira-custom-field-type--beta-), use the ID of the Forge custom field type as the value. For example, `ari:cloud:ecosystem::extension/e62f20a2-4b61-4dbe-bfb9-9a88b5e3ac84/548c5df1-24aa-4f7c-bbbb-3038d947cb05/static/my-cf-type-key`.
   */
  type: string;
};

/**
 * The searcher defines the way the field is searched in Jira. For example, *com.atlassian.jira.plugin.system.customfieldtypes:grouppickersearcher*.
 * The search UI (basic search and JQL search) will display different operations and values for the field, based on the field searcher. You must specify a searcher that is valid for the field type, as listed below (abbreviated values shown):
 *
 * *  `cascadingselect`: `cascadingselectsearcher`
 * *  `datepicker`: `daterange`
 * *  `datetime`: `datetimerange`
 * *  `float`: `exactnumber` or `numberrange`
 * *  `grouppicker`: `grouppickersearcher`
 * *  `importid`: `exactnumber` or `numberrange`
 * *  `labels`: `labelsearcher`
 * *  `multicheckboxes`: `multiselectsearcher`
 * *  `multigrouppicker`: `multiselectsearcher`
 * *  `multiselect`: `multiselectsearcher`
 * *  `multiuserpicker`: `userpickergroupsearcher`
 * *  `multiversion`: `versionsearcher`
 * *  `project`: `projectsearcher`
 * *  `radiobuttons`: `multiselectsearcher`
 * *  `readonlyfield`: `textsearcher`
 * *  `select`: `multiselectsearcher`
 * *  `textarea`: `textsearcher`
 * *  `textfield`: `textsearcher`
 * *  `url`: `exacttextsearcher`
 * *  `userpicker`: `userpickergroupsearcher`
 * *  `version`: `versionsearcher`
 *
 * If no searcher is provided, the field isn't searchable. However, [Forge custom fields](https://developer.atlassian.com/platform/forge/manifest-reference/modules/#jira-custom-field-type--beta-) have a searcher set automatically, so are always searchable.
 */
export type searcherKey =
  | 'com.atlassian.jira.plugin.system.customfieldtypes:cascadingselectsearcher'
  | 'com.atlassian.jira.plugin.system.customfieldtypes:daterange'
  | 'com.atlassian.jira.plugin.system.customfieldtypes:datetimerange'
  | 'com.atlassian.jira.plugin.system.customfieldtypes:exactnumber'
  | 'com.atlassian.jira.plugin.system.customfieldtypes:exacttextsearcher'
  | 'com.atlassian.jira.plugin.system.customfieldtypes:grouppickersearcher'
  | 'com.atlassian.jira.plugin.system.customfieldtypes:labelsearcher'
  | 'com.atlassian.jira.plugin.system.customfieldtypes:multiselectsearcher'
  | 'com.atlassian.jira.plugin.system.customfieldtypes:numberrange'
  | 'com.atlassian.jira.plugin.system.customfieldtypes:projectsearcher'
  | 'com.atlassian.jira.plugin.system.customfieldtypes:textsearcher'
  | 'com.atlassian.jira.plugin.system.customfieldtypes:userpickergroupsearcher'
  | 'com.atlassian.jira.plugin.system.customfieldtypes:versionsearcher';

/**
 * Details of a custom option for a field.
 */
export type CustomFieldOption = {
  /**
   * The URL of these custom field option details.
   */
  readonly self?: string;
  /**
   * The value of the custom field option.
   */
  readonly value?: string;
};

/**
 * Details of a custom field option to create.
 */
export type CustomFieldOptionCreate = {
  /**
   * Whether the option is disabled.
   */
  disabled?: boolean;
  /**
   * For cascading options, the ID of the custom field object containing the cascading option.
   */
  optionId?: string;
  /**
   * The value of the custom field option.
   */
  value: string;
};

/**
 * Details of a custom field option for a context.
 */
export type CustomFieldOptionUpdate = {
  /**
   * Whether the option is disabled.
   */
  disabled?: boolean;
  /**
   * The ID of the custom field option.
   */
  id: string;
  /**
   * The value of the custom field option.
   */
  value?: string;
};

/**
 * Details about the replacement for a deleted version.
 */
export type CustomFieldReplacement = {
  /**
   * The ID of the custom field in which to replace the version number.
   */
  customFieldId?: number;
  /**
   * The version number to use as a replacement for the deleted version.
   */
  moveTo?: number;
};

/**
 * A list of custom field options for a context.
 */
export type CustomFieldUpdatedContextOptionsList = {
  /**
   * The updated custom field options.
   */
  options?: Array<CustomFieldOptionUpdate>;
};

/**
 * A list of issue IDs and the value to update a custom field to.
 */
export type CustomFieldValueUpdate = {
  /**
   * The list of issue IDs.
   */
  issueIds: Array<number>;
  /**
   * The value for the custom field. The value must be compatible with the [custom field type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field/#data-types) as follows:
   *
   * *  `string` the value must be a string.
   * *  `number` the value must be a number.
   * *  `datetime` the value must be a string that represents a date in the ISO format or the simplified extended ISO format. For example, `"2023-01-18T12:00:00-03:00"` or `"2023-01-18T12:00:00.000Z"`. However, the milliseconds part is ignored.
   * *  `user` the value must be an object that contains the `accountId` field.
   * *  `group` the value must be an object that contains the group `name` or `groupId` field. Because group names can change, we recommend using `groupId`.
   *
   * A list of appropriate values must be provided if the field is of the `list` [collection type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field/#collection-types).
   */
  value?: string;
};

/**
 * Details of updates for a custom field.
 */
export type CustomFieldValueUpdateDetails = {
  /**
   * The list of custom field update details.
   */
  updates?: Array<CustomFieldValueUpdate>;
};

/**
 * Details of a dashboard.
 */
export type Dashboard = {
  /**
   * The automatic refresh interval for the dashboard in milliseconds.
   */
  readonly automaticRefreshMs?: number;
  description?: string;
  /**
   * The details of any edit share permissions for the dashboard.
   */
  readonly editPermissions?: Array<SharePermission>;
  /**
   * The ID of the dashboard.
   */
  readonly id?: string;
  /**
   * Whether the dashboard is selected as a favorite by the user.
   */
  readonly isFavourite?: boolean;
  /**
   * Whether the current user has permission to edit the dashboard.
   */
  readonly isWritable?: boolean;
  /**
   * The name of the dashboard.
   */
  readonly name?: string;
  /**
   * The owner of the dashboard.
   */
  readonly owner?: UserBean;
  /**
   * The number of users who have this dashboard as a favorite.
   */
  readonly popularity?: number;
  /**
   * The rank of this dashboard.
   */
  readonly rank?: number;
  /**
   * The URL of these dashboard details.
   */
  readonly self?: string;
  /**
   * The details of any view share permissions for the dashboard.
   */
  readonly sharePermissions?: Array<SharePermission>;
  /**
   * Whether the current dashboard is system dashboard.
   */
  readonly systemDashboard?: boolean;
  /**
   * The URL of the dashboard.
   */
  readonly view?: string;
};

/**
 * Details of a dashboard.
 */
export type DashboardDetails = {
  /**
   * The description of the dashboard.
   */
  description?: string;
  /**
   * The edit permissions for the dashboard.
   */
  editPermissions: Array<SharePermission>;
  /**
   * The name of the dashboard.
   */
  name: string;
  /**
   * The share permissions for the dashboard.
   */
  sharePermissions: Array<SharePermission>;
};

/**
 * Details of a gadget.
 */
export type DashboardGadget = {
  /**
   * The color of the gadget. Should be one of `blue`, `red`, `yellow`, `green`, `cyan`, `purple`, `gray`, or `white`.
   */
  readonly color: 'blue' | 'red' | 'yellow' | 'green' | 'cyan' | 'purple' | 'gray' | 'white';
  /**
   * The ID of the gadget instance.
   */
  readonly id: number;
  /**
   * The module key of the gadget type.
   */
  readonly moduleKey?: string;
  /**
   * The position of the gadget.
   */
  readonly position: DashboardGadgetPosition;
  /**
   * The title of the gadget.
   */
  readonly title: string;
  /**
   * The URI of the gadget type.
   */
  readonly uri?: string;
};

/**
 * The color of the gadget. Should be one of `blue`, `red`, `yellow`, `green`, `cyan`, `purple`, `gray`, or `white`.
 */
export type color = 'blue' | 'red' | 'yellow' | 'green' | 'cyan' | 'purple' | 'gray' | 'white';

/**
 * Details of a gadget position.
 */
export type DashboardGadgetPosition = {
  'The column position of the gadget.': number;
  'The row position of the gadget.': number;
};

/**
 * The list of gadgets on the dashboard.
 */
export type DashboardGadgetResponse = {
  /**
   * The list of gadgets.
   */
  readonly gadgets: Array<DashboardGadget>;
};

/**
 * Details of the settings for a dashboard gadget.
 */
export type DashboardGadgetSettings = {
  /**
   * The color of the gadget. Should be one of `blue`, `red`, `yellow`, `green`, `cyan`, `purple`, `gray`, or `white`.
   */
  color?: string;
  /**
   * Whether to ignore the validation of module key and URI. For example, when a gadget is created that is a part of an application that isn't installed.
   */
  ignoreUriAndModuleKeyValidation?: boolean;
  /**
   * The module key of the gadget type. Can't be provided with `uri`.
   */
  moduleKey?: string;
  /**
   * The position of the gadget. When the gadget is placed into the position, other gadgets in the same column are moved down to accommodate it.
   */
  position?: DashboardGadgetPosition;
  /**
   * The title of the gadget.
   */
  title?: string;
  /**
   * The URI of the gadget type. Can't be provided with `moduleKey`.
   */
  uri?: string;
};

/**
 * The details of the gadget to update.
 */
export type DashboardGadgetUpdateRequest = {
  /**
   * The color of the gadget. Should be one of `blue`, `red`, `yellow`, `green`, `cyan`, `purple`, `gray`, or `white`.
   */
  color?: string;
  /**
   * The position of the gadget.
   */
  position?: DashboardGadgetPosition;
  /**
   * The title of the gadget.
   */
  title?: string;
};

/**
 * The data classification.
 */
export type DataClassificationLevelsBean = {
  /**
   * The data classifications.
   */
  classifications?: Array<DataClassificationTagBean>;
};

/**
 * The data classification.
 */
export type DataClassificationTagBean = {
  /**
   * The color of the data classification object.
   */
  color?: string;
  /**
   * The description of the data classification object.
   */
  description?: string;
  /**
   * The guideline of the data classification object.
   */
  guideline?: string;
  /**
   * The ID of the data classification object.
   */
  id: string;
  /**
   * The name of the data classification object.
   */
  name?: string;
  /**
   * The rank of the data classification object.
   */
  rank?: number;
  /**
   * The status of the data classification object.
   */
  status: string;
};

/**
 * List issues archived within a specified date range.
 */
export type DateRangeFilterRequest = {
  /**
   * List issues archived after a specified date, passed in the YYYY-MM-DD format.
   */
  dateAfter: string;
  /**
   * List issues archived before a specified date provided in the YYYY-MM-DD format.
   */
  dateBefore: string;
};

/**
 * Details of scheme and new default level.
 */
export type DefaultLevelValue = {
  /**
   * The ID of the issue security level to set as default for the specified scheme. Providing null will reset the default level.
   */
  defaultLevelId: string;
  /**
   * The ID of the issue security scheme to set default level for.
   */
  issueSecuritySchemeId: string;
};

/**
 * Details of the scope of the default sharing for new filters and dashboards.
 */
export type DefaultShareScope = {
  /**
   * The scope of the default sharing for new filters and dashboards:
   *
   * *  `AUTHENTICATED` Shared with all logged-in users.
   * *  `GLOBAL` Shared with all logged-in users. This shows as `AUTHENTICATED` in the response.
   * *  `PRIVATE` Not shared with any users.
   */
  scope: 'GLOBAL' | 'AUTHENTICATED' | 'PRIVATE';
};

/**
 * The scope of the default sharing for new filters and dashboards:
 *
 * *  `AUTHENTICATED` Shared with all logged-in users.
 * *  `GLOBAL` Shared with all logged-in users. This shows as `AUTHENTICATED` in the response.
 * *  `PRIVATE` Not shared with any users.
 */
export type scope = 'GLOBAL' | 'AUTHENTICATED' | 'PRIVATE';

/**
 * Details about the default workflow.
 */
export type DefaultWorkflow = {
  /**
   * Whether a draft workflow scheme is created or updated when updating an active workflow scheme. The draft is updated with the new default workflow. Defaults to `false`.
   */
  updateDraftIfNeeded?: boolean;
  /**
   * The name of the workflow to set as the default workflow.
   */
  workflow: string;
};

export type DeleteAndReplaceVersionBean = {
  /**
   * An array of custom field IDs (`customFieldId`) and version IDs (`moveTo`) to update when the fields contain the deleted version.
   */
  customFieldReplacementList?: Array<CustomFieldReplacement>;
  /**
   * The ID of the version to update `affectedVersion` to when the field contains the deleted version.
   */
  moveAffectedIssuesTo?: number;
  /**
   * The ID of the version to update `fixVersion` to when the field contains the deleted version.
   */
  moveFixIssuesTo?: number;
};

/**
 * Details about a workflow.
 */
export type DeprecatedWorkflow = {
  default?: boolean;
  /**
   * The description of the workflow.
   */
  readonly description?: string;
  /**
   * The datetime the workflow was last modified.
   */
  readonly lastModifiedDate?: string;
  /**
   * This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
   */
  readonly lastModifiedUser?: string;
  /**
   * The account ID of the user that last modified the workflow.
   */
  readonly lastModifiedUserAccountId?: string;
  /**
   * The name of the workflow.
   */
  readonly name?: string;
  /**
   * The scope where this workflow applies
   */
  readonly scope?: Scope;
  /**
   * The number of steps included in the workflow.
   */
  readonly steps?: number;
};

export type DetailedErrorCollection = {
  /**
   * Map of objects representing additional details for an error
   */
  details?: {
    [key: string]: string;
  };
  /**
   * The list of error messages produced by this operation. For example, "input parameter 'key' must be provided"
   */
  errorMessages?: Array<string>;
  /**
   * The list of errors by parameter returned by the operation. For example,"projectKey": "Project keys must start with an uppercase letter, followed by one or more uppercase alphanumeric characters."
   */
  errors?: {
    [key: string]: string;
  };
};

/**
 * The current version details of this workflow scheme.
 */
export type DocumentVersion = {
  /**
   * The version UUID.
   */
  id: string;
  /**
   * The version number.
   */
  versionNumber: number;
};

/**
 * An entity property, for more information see [Entity properties](https://developer.atlassian.com/cloud/jira/platform/jira-entity-properties/).
 */
export type EntityProperty = {
  /**
   * The key of the property. Required on create and update.
   */
  key?: string;
  /**
   * The value of the property. Required on create and update.
   */
  value?: string;
};

export type EntityPropertyDetails = {
  /**
   * The entity property ID.
   */
  entityId: number;
  /**
   * The entity property key.
   */
  key: string;
  /**
   * The new value of the entity property.
   */
  value: string;
};

export type Error = {
  count?: number;
  issueIdsOrKeys?: Array<string>;
  message?: string;
};

/**
 * Error messages from an operation.
 */
export type ErrorCollection = {
  /**
   * The list of error messages produced by this operation. For example, "input parameter 'key' must be provided"
   */
  errorMessages?: Array<string>;
  /**
   * The list of errors by parameter returned by the operation. For example,"projectKey": "Project keys must start with an uppercase letter, followed by one or more uppercase alphanumeric characters."
   */
  errors?: {
    [key: string]: string;
  };
  status?: number;
};

export type ErrorCollections = {
  [key: string]: string;
};

export type ErrorMessage = {
  message?: string;
};

export type Errors = {
  issueIsSubtask?: Error;
  issuesInArchivedProjects?: Error;
  issuesInUnlicensedProjects?: Error;
  issuesNotFound?: Error;
  userDoesNotHavePermission?: Error;
};

/**
 * Details about a notification associated with an event.
 */
export type EventNotification = {
  /**
   * The email address.
   */
  emailAddress?: string;
  /**
   * Expand options that include additional event notification details in the response.
   */
  expand?: string;
  /**
   * The custom user or group field.
   */
  field?: FieldDetails;
  /**
   * The specified group.
   */
  group?: GroupName;
  /**
   * The ID of the notification.
   */
  id?: number;
  /**
   * Identifies the recipients of the notification.
   */
  notificationType?:
    | 'CurrentAssignee'
    | 'Reporter'
    | 'CurrentUser'
    | 'ProjectLead'
    | 'ComponentLead'
    | 'User'
    | 'Group'
    | 'ProjectRole'
    | 'EmailAddress'
    | 'AllWatchers'
    | 'UserCustomField'
    | 'GroupCustomField';
  /**
   * As a group's name can change, use of `recipient` is recommended. The identifier associated with the `notificationType` value that defines the receiver of the notification, where the receiver isn't implied by `notificationType` value. So, when `notificationType` is:
   *
   * *  `User` The `parameter` is the user account ID.
   * *  `Group` The `parameter` is the group name.
   * *  `ProjectRole` The `parameter` is the project role ID.
   * *  `UserCustomField` The `parameter` is the ID of the custom field.
   * *  `GroupCustomField` The `parameter` is the ID of the custom field.
   */
  parameter?: string;
  /**
   * The specified project role.
   */
  projectRole?: ProjectRole;
  /**
   * The identifier associated with the `notificationType` value that defines the receiver of the notification, where the receiver isn't implied by the `notificationType` value. So, when `notificationType` is:
   *
   * *  `User`, `recipient` is the user account ID.
   * *  `Group`, `recipient` is the group ID.
   * *  `ProjectRole`, `recipient` is the project role ID.
   * *  `UserCustomField`, `recipient` is the ID of the custom field.
   * *  `GroupCustomField`, `recipient` is the ID of the custom field.
   */
  recipient?: string;
  /**
   * The specified user.
   */
  user?: UserDetails;
};

/**
 * Identifies the recipients of the notification.
 */
export type notificationType =
  | 'CurrentAssignee'
  | 'Reporter'
  | 'CurrentUser'
  | 'ProjectLead'
  | 'ComponentLead'
  | 'User'
  | 'Group'
  | 'ProjectRole'
  | 'EmailAddress'
  | 'AllWatchers'
  | 'UserCustomField'
  | 'GroupCustomField';

/**
 * A priority scheme with less fields to be used in for an API expand response.
 */
export type ExpandPrioritySchemeBean = {
  /**
   * The ID of the priority scheme.
   */
  readonly id?: string;
  /**
   * The name of the priority scheme.
   */
  readonly name?: string;
  /**
   * The URL of the priority scheme.
   */
  readonly self?: string;
};

export type ExpandPrioritySchemePage = {
  maxResults?: number;
  startAt?: number;
  total?: number;
};

/**
 * The response for status request for a running/completed export task.
 */
export type ExportArchivedIssuesTaskProgressResponse = {
  fileUrl?: string;
  payload?: string;
  progress?: number;
  status?: string;
  submittedTime?: string;
  taskId?: string;
};

/**
 * Details about a failed webhook.
 */
export type FailedWebhook = {
  /**
   * The webhook body.
   */
  body?: string;
  /**
   * The time the webhook was added to the list of failed webhooks (that is, the time of the last failed retry).
   */
  failureTime: number;
  /**
   * The webhook ID, as sent in the `X-Atlassian-Webhook-Identifier` header with the webhook.
   */
  id: string;
  /**
   * The original webhook destination.
   */
  url: string;
};

/**
 * A page of failed webhooks.
 */
export type FailedWebhooks = {
  /**
   * The maximum number of items on the page. If the list of values is shorter than this number, then there are no more pages.
   */
  maxResults: number;
  /**
   * The URL to the next page of results. Present only if the request returned at least one result.The next page may be empty at the time of receiving the response, but new failed webhooks may appear in time. You can save the URL to the next page and query for new results periodically (for example, every hour).
   */
  next?: string;
  /**
   * The list of webhooks.
   */
  values: Array<FailedWebhook>;
};

/**
 * Details of a field.
 */
export type Field = {
  /**
   * Number of contexts where the field is used.
   */
  contextsCount?: number;
  /**
   * The description of the field.
   */
  description?: string;
  /**
   * The ID of the field.
   */
  id: string;
  /**
   * Whether the field is locked.
   */
  isLocked?: boolean;
  /**
   * Whether the field is shown on screen or not.
   */
  isUnscreenable?: boolean;
  /**
   * The key of the field.
   */
  key?: string;
  lastUsed?: FieldLastUsed;
  /**
   * The name of the field.
   */
  name: string;
  /**
   * Number of projects where the field is used.
   */
  projectsCount?: number;
  schema: JsonTypeBean;
  /**
   * Number of screens where the field is used.
   */
  screensCount?: number;
  /**
   * The searcher key of the field. Returned for custom fields.
   */
  searcherKey?: string;
  /**
   * The stable ID of the field.
   */
  stableId?: string;
};

/**
 * A clause that asserts whether a field was changed. For example, `status CHANGED AFTER startOfMonth(-1M)`.See [CHANGED](https://confluence.atlassian.com/x/dgiiLQ#Advancedsearching-operatorsreference-CHANGEDCHANGED) for more information about the CHANGED operator.
 */
export type FieldChangedClause = {
  field: JqlQueryField;
  /**
   * The operator applied to the field.
   */
  operator: 'changed';
  /**
   * The list of time predicates.
   */
  predicates: Array<JqlQueryClauseTimePredicate>;
};

/**
 * The operator applied to the field.
 */
export type operator3 = 'changed';

/**
 * Details of a field configuration.
 */
export type FieldConfiguration = {
  /**
   * The description of the field configuration.
   */
  description: string;
  /**
   * The ID of the field configuration.
   */
  id: number;
  /**
   * Whether the field configuration is the default.
   */
  isDefault?: boolean;
  /**
   * The name of the field configuration.
   */
  name: string;
};

/**
 * Details of a field configuration.
 */
export type FieldConfigurationDetails = {
  /**
   * The description of the field configuration.
   */
  description?: string;
  /**
   * The name of the field configuration. Must be unique.
   */
  name: string;
};

/**
 * The field configuration for an issue type.
 */
export type FieldConfigurationIssueTypeItem = {
  /**
   * The ID of the field configuration.
   */
  fieldConfigurationId: string;
  /**
   * The ID of the field configuration scheme.
   */
  fieldConfigurationSchemeId: string;
  /**
   * The ID of the issue type or *default*. When set to *default* this field configuration issue type item applies to all issue types without a field configuration.
   */
  issueTypeId: string;
};

/**
 * A field within a field configuration.
 */
export type FieldConfigurationItem = {
  /**
   * The description of the field within the field configuration.
   */
  description?: string;
  /**
   * The ID of the field within the field configuration.
   */
  id: string;
  /**
   * Whether the field is hidden in the field configuration.
   */
  isHidden?: boolean;
  /**
   * Whether the field is required in the field configuration.
   */
  isRequired?: boolean;
  /**
   * The renderer type for the field within the field configuration.
   */
  renderer?: string;
};

/**
 * Details of field configuration items.
 */
export type FieldConfigurationItemsDetails = {
  /**
   * Details of fields in a field configuration.
   */
  fieldConfigurationItems: Array<FieldConfigurationItem>;
};

/**
 * Details of a field configuration scheme.
 */
export type FieldConfigurationScheme = {
  /**
   * The description of the field configuration scheme.
   */
  description?: string;
  /**
   * The ID of the field configuration scheme.
   */
  id: string;
  /**
   * The name of the field configuration scheme.
   */
  name: string;
};

/**
 * Associated field configuration scheme and project.
 */
export type FieldConfigurationSchemeProjectAssociation = {
  /**
   * The ID of the field configuration scheme. If the field configuration scheme ID is `null`, the operation assigns the default field configuration scheme.
   */
  fieldConfigurationSchemeId?: string;
  /**
   * The ID of the project.
   */
  projectId: string;
};

/**
 * Project list with assigned field configuration schema.
 */
export type FieldConfigurationSchemeProjects = {
  fieldConfigurationScheme?: FieldConfigurationScheme;
  /**
   * The IDs of projects using the field configuration scheme.
   */
  projectIds: Array<string>;
};

/**
 * The field configuration to issue type mapping.
 */
export type FieldConfigurationToIssueTypeMapping = {
  /**
   * The ID of the field configuration.
   */
  fieldConfigurationId: string;
  /**
   * The ID of the issue type or *default*. When set to *default* this field configuration issue type item applies to all issue types without a field configuration. An issue type can be included only once in a request.
   */
  issueTypeId: string;
};

/**
 * The metadata describing an issue field for createmeta.
 */
export type FieldCreateMetadata = {
  /**
   * The list of values allowed in the field.
   */
  readonly allowedValues?: Array<unknown>;
  /**
   * The URL that can be used to automatically complete the field.
   */
  readonly autoCompleteUrl?: string;
  /**
   * The configuration properties.
   */
  readonly configuration?: {
    [key: string]: string;
  };
  /**
   * The default value of the field.
   */
  readonly defaultValue?: string;
  /**
   * The field id.
   */
  readonly fieldId: string;
  /**
   * Whether the field has a default value.
   */
  readonly hasDefaultValue?: boolean;
  /**
   * The key of the field.
   */
  readonly key: string;
  /**
   * The name of the field.
   */
  readonly name: string;
  /**
   * The list of operations that can be performed on the field.
   */
  readonly operations: Array<string>;
  /**
   * Whether the field is required.
   */
  readonly required: boolean;
  /**
   * The data type of the field.
   */
  readonly schema: JsonTypeBean;
};

/**
 * Details about a field.
 */
export type FieldDetails = {
  /**
   * The names that can be used to reference the field in an advanced search. For more information, see [Advanced searching - fields reference](https://confluence.atlassian.com/x/gwORLQ).
   */
  clauseNames?: Array<string>;
  /**
   * Whether the field is a custom field.
   */
  custom?: boolean;
  /**
   * The ID of the field.
   */
  id?: string;
  /**
   * The key of the field.
   */
  key?: string;
  /**
   * The name of the field.
   */
  name?: string;
  /**
   * Whether the field can be used as a column on the issue navigator.
   */
  navigable?: boolean;
  /**
   * Whether the content of the field can be used to order lists.
   */
  orderable?: boolean;
  /**
   * The data schema for the field.
   */
  schema?: JsonTypeBean;
  /**
   * The scope of the field.
   */
  scope?: Scope;
  /**
   * Whether the content of the field can be searched.
   */
  searchable?: boolean;
};

/**
 * Information about the most recent use of a field.
 */
export type FieldLastUsed = {
  /**
   * Last used value type:
   *
   * *  *TRACKED*: field is tracked and a last used date is available.
   * *  *NOT\_TRACKED*: field is not tracked, last used date is not available.
   * *  *NO\_INFORMATION*: field is tracked, but no last used date is available.
   */
  type?: 'TRACKED' | 'NOT_TRACKED' | 'NO_INFORMATION';
  /**
   * The date when the value of the field last changed.
   */
  value?: string;
};

/**
 * Last used value type:
 *
 * *  *TRACKED*: field is tracked and a last used date is available.
 * *  *NOT\_TRACKED*: field is not tracked, last used date is not available.
 * *  *NO\_INFORMATION*: field is tracked, but no last used date is available.
 */
export type type2 = 'TRACKED' | 'NOT_TRACKED' | 'NO_INFORMATION';

/**
 * The metadata describing an issue field.
 */
export type FieldMetadata = {
  /**
   * The list of values allowed in the field.
   */
  readonly allowedValues?: Array<unknown>;
  /**
   * The URL that can be used to automatically complete the field.
   */
  readonly autoCompleteUrl?: string;
  /**
   * The configuration properties.
   */
  readonly configuration?: {
    [key: string]: string;
  };
  /**
   * The default value of the field.
   */
  readonly defaultValue?: string;
  /**
   * Whether the field has a default value.
   */
  readonly hasDefaultValue?: boolean;
  /**
   * The key of the field.
   */
  readonly key: string;
  /**
   * The name of the field.
   */
  readonly name: string;
  /**
   * The list of operations that can be performed on the field.
   */
  readonly operations: Array<string>;
  /**
   * Whether the field is required.
   */
  readonly required: boolean;
  /**
   * The data type of the field.
   */
  readonly schema: JsonTypeBean;
};

/**
 * Details of a field that can be used in advanced searches.
 */
export type FieldReferenceData = {
  /**
   * Whether the field provide auto-complete suggestions.
   */
  auto?: 'true' | 'false';
  /**
   * If the item is a custom field, the ID of the custom field.
   */
  cfid?: string;
  /**
   * Whether this field has been deprecated.
   */
  deprecated?: 'true' | 'false';
  /**
   * The searcher key of the field, only passed when the field is deprecated.
   */
  deprecatedSearcherKey?: string;
  /**
   * The display name contains the following:
   *
   * *  for system fields, the field name. For example, `Summary`.
   * *  for collapsed custom fields, the field name followed by a hyphen and then the field name and field type. For example, `Component - Component[Dropdown]`.
   * *  for other custom fields, the field name followed by a hyphen and then the custom field ID. For example, `Component - cf[10061]`.
   */
  displayName?: string;
  /**
   * The valid search operators for the field.
   */
  operators?: Array<string>;
  /**
   * Whether the field can be used in a query's `ORDER BY` clause.
   */
  orderable?: 'true' | 'false';
  /**
   * Whether the content of this field can be searched.
   */
  searchable?: 'true' | 'false';
  /**
   * The data types of items in the field.
   */
  types?: Array<string>;
  /**
   * The field identifier.
   */
  value?: string;
};

/**
 * Whether the field provide auto-complete suggestions.
 */
export type auto = 'true' | 'false';

/**
 * Whether this field has been deprecated.
 */
export type deprecated = 'true' | 'false';

/**
 * Whether the field can be used in a query's `ORDER BY` clause.
 */
export type orderable = 'true' | 'false';

/**
 * Whether the content of this field can be searched.
 */
export type searchable = 'true' | 'false';

/**
 * Details of an operation to perform on a field.
 */
export type FieldUpdateOperation = {
  /**
   * The value to add to the field.
   */
  add?: string;
  /**
   * The field value to copy from another issue.
   */
  copy?: string;
  /**
   * The value to edit in the field.
   */
  edit?: string;
  /**
   * The value to removed from the field.
   */
  remove?: string;
  /**
   * The value to set in the field.
   */
  set?: string;
};

/**
 * A clause that asserts the current value of a field. For example, `summary ~ test`.
 */
export type FieldValueClause = {
  field: JqlQueryField;
  operand: JqlQueryClauseOperand;
  /**
   * The operator between the field and operand.
   */
  operator: '=' | '!=' | '>' | '<' | '>=' | '<=' | 'in' | 'not in' | '~' | '~=' | 'is' | 'is not';
};

/**
 * The operator between the field and operand.
 */
export type operator4 = '=' | '!=' | '>' | '<' | '>=' | '<=' | 'in' | 'not in' | '~' | '~=' | 'is' | 'is not';

/**
 * A clause that asserts a previous value of a field. For example, `status WAS "Resolved" BY currentUser() BEFORE "2019/02/02"`. See [WAS](https://confluence.atlassian.com/x/dgiiLQ#Advancedsearching-operatorsreference-WASWAS) for more information about the WAS operator.
 */
export type FieldWasClause = {
  field: JqlQueryField;
  operand: JqlQueryClauseOperand;
  /**
   * The operator between the field and operand.
   */
  operator: 'was' | 'was in' | 'was not in' | 'was not';
  /**
   * The list of time predicates.
   */
  predicates: Array<JqlQueryClauseTimePredicate>;
};

/**
 * The operator between the field and operand.
 */
export type operator5 = 'was' | 'was in' | 'was not in' | 'was not';

/**
 * Key fields from the linked issue.
 */
export type LinkedIssueField = {
  /**
   * The assignee of the linked issue.
   */
  readonly assignee?: UserDetails;
  /**
   * The type of the linked issue.
   */
  readonly issueType?: IssueTypeDetails;
  /**
   * The type of the linked issue.
   */
  issuetype?: IssueTypeDetails;
  /**
   * The priority of the linked issue.
   */
  readonly priority?: Priority;
  /**
   * The status of the linked issue.
   */
  readonly status?: StatusDetails;
  /**
   * The summary description of the linked issue.
   */
  readonly summary?: string;
  /**
   * The time tracking of the linked issue.
   */
  readonly timetracking?: TimeTrackingDetails;
};

/**
 * Details about a filter.
 */
export type Filter = {
  /**
   * \[Experimental\] Approximate last used time. Returns the date and time when the filter was last used. Returns `null` if the filter hasn't been used after tracking was enabled. For performance reasons, timestamps aren't updated in real time and therefore may not be exactly accurate.
   */
  readonly approximateLastUsed?: string;
  /**
   * A description of the filter.
   */
  description?: string;
  /**
   * The groups and projects that can edit the filter.
   */
  editPermissions?: Array<SharePermission>;
  /**
   * Whether the filter is selected as a favorite.
   */
  favourite?: boolean;
  /**
   * The count of how many users have selected this filter as a favorite, including the filter owner.
   */
  readonly favouritedCount?: number;
  /**
   * The unique identifier for the filter.
   */
  readonly id?: string;
  /**
   * The JQL query for the filter. For example, *project = SSP AND issuetype = Bug*.
   */
  jql?: string;
  /**
   * The name of the filter. Must be unique.
   */
  name: string;
  /**
   * The user who owns the filter. This is defaulted to the creator of the filter, however Jira administrators can change the owner of a shared filter in the admin settings.
   */
  readonly owner?: User;
  /**
   * A URL to view the filter results in Jira, using the [Search for issues using JQL](#api-rest-api-3-filter-search-get) operation with the filter's JQL string to return the filter results. For example, *https://your-domain.atlassian.net/rest/api/3/search?jql=project+%3D+SSP+AND+issuetype+%3D+Bug*.
   */
  readonly searchUrl?: string;
  /**
   * The URL of the filter.
   */
  readonly self?: string;
  /**
   * The groups and projects that the filter is shared with.
   */
  sharePermissions?: Array<SharePermission>;
  /**
   * A paginated list of the users that the filter is shared with. This includes users that are members of the groups or can browse the projects that the filter is shared with.
   */
  readonly sharedUsers?: UserList;
  /**
   * A paginated list of the users that are subscribed to the filter.
   */
  readonly subscriptions?: FilterSubscriptionsList;
  /**
   * A URL to view the filter results in Jira, using the ID of the filter. For example, *https://your-domain.atlassian.net/issues/?filter=10100*.
   */
  readonly viewUrl?: string;
};

/**
 * Details of a filter.
 */
export type FilterDetails = {
  /**
   * \[Experimental\] Approximate last used time. Returns the date and time when the filter was last used. Returns `null` if the filter hasn't been used after tracking was enabled. For performance reasons, timestamps aren't updated in real time and therefore may not be exactly accurate.
   */
  readonly approximateLastUsed?: string;
  /**
   * The description of the filter.
   */
  description?: string;
  /**
   * The groups and projects that can edit the filter. This can be specified when updating a filter, but not when creating a filter.
   */
  editPermissions?: Array<SharePermission>;
  /**
   * Expand options that include additional filter details in the response.
   */
  readonly expand?: string;
  /**
   * Whether the filter is selected as a favorite by any users, not including the filter owner.
   */
  readonly favourite?: boolean;
  /**
   * The count of how many users have selected this filter as a favorite, including the filter owner.
   */
  readonly favouritedCount?: number;
  /**
   * The unique identifier for the filter.
   */
  readonly id?: string;
  /**
   * The JQL query for the filter. For example, *project = SSP AND issuetype = Bug*.
   */
  readonly jql?: string;
  /**
   * The name of the filter.
   */
  name: string;
  /**
   * The user who owns the filter. Defaults to the creator of the filter, however, Jira administrators can change the owner of a shared filter in the admin settings.
   */
  readonly owner?: User;
  /**
   * A URL to view the filter results in Jira, using the [Search for issues using JQL](#api-rest-api-3-filter-search-get) operation with the filter's JQL string to return the filter results. For example, *https://your-domain.atlassian.net/rest/api/3/search?jql=project+%3D+SSP+AND+issuetype+%3D+Bug*.
   */
  readonly searchUrl?: string;
  /**
   * The URL of the filter.
   */
  readonly self?: string;
  /**
   * The groups and projects that the filter is shared with. This can be specified when updating a filter, but not when creating a filter.
   */
  sharePermissions?: Array<SharePermission>;
  /**
   * The users that are subscribed to the filter.
   */
  readonly subscriptions?: Array<FilterSubscription>;
  /**
   * A URL to view the filter results in Jira, using the ID of the filter. For example, *https://your-domain.atlassian.net/issues/?filter=10100*.
   */
  readonly viewUrl?: string;
};

/**
 * Details of a user or group subscribing to a filter.
 */
export type FilterSubscription = {
  /**
   * The group subscribing to filter.
   */
  readonly group?: GroupName;
  /**
   * The ID of the filter subscription.
   */
  readonly id?: number;
  /**
   * The user subscribing to filter.
   */
  readonly user?: User;
};

/**
 * A paginated list of subscriptions to a filter.
 */
export type FilterSubscriptionsList = {
  /**
   * The index of the last item returned on the page.
   */
  readonly 'end-index'?: number;
  /**
   * The list of items.
   */
  readonly items?: Array<FilterSubscription>;
  /**
   * The maximum number of results that could be on the page.
   */
  readonly 'max-results'?: number;
  /**
   * The number of items on the page.
   */
  readonly size?: number;
  /**
   * The index of the first item returned on the page.
   */
  readonly 'start-index'?: number;
};

/**
 * A group found in a search.
 */
export type FoundGroup = {
  /**
   * The ID of the group, which uniquely identifies the group across all Atlassian products. For example, *952d12c3-5b5b-4d04-bb32-44d383afc4b2*.
   */
  groupId?: string;
  /**
   * The group name with the matched query string highlighted with the HTML bold tag.
   */
  html?: string;
  labels?: Array<GroupLabel>;
  /**
   * The name of the group. The name of a group is mutable, to reliably identify a group use ``groupId`.`
   */
  name?: string;
};

/**
 * The list of groups found in a search, including header text (Showing X of Y matching groups) and total of matched groups.
 */
export type FoundGroups = {
  groups?: Array<FoundGroup>;
  /**
   * Header text indicating the number of groups in the response and the total number of groups found in the search.
   */
  header?: string;
  /**
   * The total number of groups found in the search.
   */
  total?: number;
};

/**
 * The list of users found in a search, including header text (Showing X of Y matching users) and total of matched users.
 */
export type FoundUsers = {
  /**
   * Header text indicating the number of users in the response and the total number of users found in the search.
   */
  header?: string;
  /**
   * The total number of users found in the search.
   */
  total?: number;
  users?: Array<UserPickerUser>;
};

/**
 * List of users and groups found in a search.
 */
export type FoundUsersAndGroups = {
  groups?: FoundGroups;
  users?: FoundUsers;
};

/**
 * An operand that is a function. See [Advanced searching - functions reference](https://confluence.atlassian.com/x/dwiiLQ) for more information about JQL functions.
 */
export type FunctionOperand = {
  /**
   * The list of function arguments.
   */
  arguments: Array<string>;
  /**
   * Encoded operand, which can be used directly in a JQL query.
   */
  encodedOperand?: string;
  /**
   * The name of the function.
   */
  function: string;
};

/**
 * Details of functions that can be used in advanced searches.
 */
export type FunctionReferenceData = {
  /**
   * The display name of the function.
   */
  displayName?: string;
  /**
   * Whether the function can take a list of arguments.
   */
  isList?: 'true' | 'false';
  /**
   * Whether the function supports both single and list value operators.
   */
  supportsListAndSingleValueOperators?: 'true' | 'false';
  /**
   * The data types returned by the function.
   */
  types?: Array<string>;
  /**
   * The function identifier.
   */
  value?: string;
};

/**
 * Whether the function can take a list of arguments.
 */
export type isList = 'true' | 'false';

/**
 * Whether the function supports both single and list value operators.
 */
export type supportsListAndSingleValueOperators = 'true' | 'false';

export type GlobalScopeBean = {
  /**
   * Defines the behavior of the option in the global context.If notSelectable is set, the option cannot be set as the field's value. This is useful for archiving an option that has previously been selected but shouldn't be used anymore.If defaultValue is set, the option is selected by default.
   */
  attributes?: Array<'notSelectable' | 'defaultValue'>;
};

export type Group = {
  /**
   * Expand options that include additional group details in the response.
   */
  readonly expand?: string;
  /**
   * The ID of the group, which uniquely identifies the group across all Atlassian products. For example, *952d12c3-5b5b-4d04-bb32-44d383afc4b2*.
   */
  groupId?: string | null;
  /**
   * The name of group.
   */
  name?: string;
  /**
   * The URL for these group details.
   */
  readonly self?: string;
  /**
   * A paginated list of the users that are members of the group. A maximum of 50 users is returned in the list, to access additional users append `[start-index:end-index]` to the expand request. For example, to access the next 50 users, use`?expand=users[51:100]`.
   */
  readonly users?: PagedListUserDetailsApplicationUser;
};

/**
 * Details about a group.
 */
export type GroupDetails = {
  /**
   * The ID of the group, which uniquely identifies the group across all Atlassian products. For example, *952d12c3-5b5b-4d04-bb32-44d383afc4b2*.
   */
  groupId?: string | null;
  /**
   * The name of the group.
   */
  name?: string;
};

/**
 * A group label.
 */
export type GroupLabel = {
  /**
   * The group label name.
   */
  text?: string;
  /**
   * The title of the group label.
   */
  title?: string;
  /**
   * The type of the group label.
   */
  type?: 'ADMIN' | 'SINGLE' | 'MULTIPLE';
};

/**
 * The type of the group label.
 */
export type type3 = 'ADMIN' | 'SINGLE' | 'MULTIPLE';

/**
 * Details about a group.
 */
export type GroupName = {
  /**
   * The ID of the group, which uniquely identifies the group across all Atlassian products. For example, *952d12c3-5b5b-4d04-bb32-44d383afc4b2*.
   */
  groupId?: string | null;
  /**
   * The name of group.
   */
  name?: string;
  /**
   * The URL for these group details.
   */
  readonly self?: string;
};

/**
 * Jira instance health check results. Deprecated and no longer returned.
 */
export type HealthCheckResult = {
  /**
   * The description of the Jira health check item.
   */
  description?: string;
  /**
   * The name of the Jira health check item.
   */
  name?: string;
  /**
   * Whether the Jira health check item passed or failed.
   */
  passed?: boolean;
};

/**
 * The project issue type hierarchy.
 */
export type Hierarchy = {
  /**
   * The ID of the base level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   */
  baseLevelId?: number;
  /**
   * Details about the hierarchy level.
   */
  readonly levels?: Array<SimplifiedHierarchyLevel>;
};

/**
 * Details of issue history metadata.
 */
export type HistoryMetadata = {
  /**
   * The activity described in the history record.
   */
  activityDescription?: string;
  /**
   * The key of the activity described in the history record.
   */
  activityDescriptionKey?: string;
  /**
   * Details of the user whose action created the history record.
   */
  actor?: HistoryMetadataParticipant;
  /**
   * Details of the cause that triggered the creation the history record.
   */
  cause?: HistoryMetadataParticipant;
  /**
   * The description of the history record.
   */
  description?: string;
  /**
   * The description key of the history record.
   */
  descriptionKey?: string;
  /**
   * The description of the email address associated the history record.
   */
  emailDescription?: string;
  /**
   * The description key of the email address associated the history record.
   */
  emailDescriptionKey?: string;
  /**
   * Additional arbitrary information about the history record.
   */
  extraData?: {
    [key: string]: string;
  };
  /**
   * Details of the system that generated the history record.
   */
  generator?: HistoryMetadataParticipant;
  /**
   * The type of the history record.
   */
  type?: string;
};

/**
 * Details of user or system associated with a issue history metadata item.
 */
export type HistoryMetadataParticipant = {
  /**
   * The URL to an avatar for the user or system associated with a history record.
   */
  avatarUrl?: string;
  /**
   * The display name of the user or system associated with a history record.
   */
  displayName?: string;
  /**
   * The key of the display name of the user or system associated with a history record.
   */
  displayNameKey?: string;
  /**
   * The ID of the user or system associated with a history record.
   */
  id?: string;
  /**
   * The type of the user or system associated with a history record.
   */
  type?: string;
  /**
   * The URL of the user or system associated with a history record.
   */
  url?: string;
};

/**
 * An icon. If no icon is defined:
 *
 * *  for a status icon, no status icon displays in Jira.
 * *  for the remote object icon, the default link icon displays in Jira.
 */
export type Icon = {
  /**
   * The URL of the tooltip, used only for a status icon. If not set, the status icon in Jira is not clickable.
   */
  link?: string;
  /**
   * The title of the icon. This is used as follows:
   *
   * *  For a status icon it is used as a tooltip on the icon. If not set, the status icon doesn't display a tooltip in Jira.
   * *  For the remote object icon it is used in conjunction with the application name to display a tooltip for the link's icon. The tooltip takes the format "\[application name\] icon title". Blank itemsare excluded from the tooltip title. If both items are blank, the icon tooltop displays as "Web Link".
   */
  title?: string;
  /**
   * The URL of an icon that displays at 16x16 pixel in Jira.
   */
  url16x16?: string;
};

/**
 * An icon.
 */
export type IconBean = {
  /**
   * The URL of the tooltip, used only for a status icon.
   */
  link?: string;
  /**
   * The title of the icon, for use as a tooltip on the icon.
   */
  title?: string;
  /**
   * The URL of a 16x16 pixel icon.
   */
  url16x16?: string;
};

export type IdBean = {
  /**
   * The ID of the permission scheme to associate with the project. Use the [Get all permission schemes](#api-rest-api-3-permissionscheme-get) resource to get a list of permission scheme IDs.
   */
  id: number;
};

export type IdOrKeyBean = {
  /**
   * The ID of the referenced item.
   */
  id?: number;
  /**
   * The key of the referenced item.
   */
  key?: string;
};

export type IdSearchRequestBean = {
  /**
   * A [JQL](https://confluence.atlassian.com/x/egORLQ) expression. Order by clauses are not allowed.
   */
  jql?: string;
  /**
   * The maximum number of items to return per page.
   */
  maxResults?: number;
  /**
   * The continuation token to fetch the next page. This token is provided by the response of this endpoint.
   */
  nextPageToken?: string;
};

/**
 * Result of your JQL search. Returns a list of issue IDs and a token to fetch the next page if one exists.
 */
export type IdSearchResults = {
  /**
   * The list of issue IDs found by the search.
   */
  readonly issueIds?: Array<number>;
  /**
   * Continuation token to fetch the next page. If this result represents the last or the only page this token will be null.
   */
  readonly nextPageToken?: string;
};

export type IncludedFields = {
  actuallyIncluded?: Array<string>;
  excluded?: Array<string>;
  included?: Array<string>;
};

export type InputStreamSource = {
  inputStream?: {
    [key: string]: string;
  };
};

/**
 * List of Issue Ids Or Keys that are to be archived or unarchived
 */
export type IssueArchivalSyncRequest = {
  issueIdsOrKeys?: Array<string>;
};

/**
 * Number of archived/unarchived issues and list of errors that occurred during the action, if any.
 */
export type IssueArchivalSyncResponse = {
  errors?: Errors;
  numberOfIssuesUpdated?: number;
};

/**
 * Details about an issue.
 */
export type IssueBean = {
  /**
   * Details of changelogs associated with the issue.
   */
  readonly changelog?: PageOfChangelogs;
  /**
   * The metadata for the fields on the issue that can be amended.
   */
  readonly editmeta?: IssueUpdateMetadata;
  /**
   * Expand options that include additional issue details in the response.
   */
  readonly expand?: string;
  fields?: {
    [key: string]: string;
  };
  fieldsToInclude?: IncludedFields;
  /**
   * The ID of the issue.
   */
  readonly id?: string;
  /**
   * The key of the issue.
   */
  readonly key?: string;
  /**
   * The ID and name of each field present on the issue.
   */
  readonly names?: {
    [key: string]: string;
  };
  /**
   * The operations that can be performed on the issue.
   */
  readonly operations?: Operations;
  /**
   * Details of the issue properties identified in the request.
   */
  readonly properties?: {
    [key: string]: string;
  };
  /**
   * The rendered value of each field present on the issue.
   */
  readonly renderedFields?: {
    [key: string]: string;
  };
  /**
   * The schema describing each field present on the issue.
   */
  readonly schema?: {
    [key: string]: JsonTypeBean;
  };
  /**
   * The URL of the issue details.
   */
  readonly self?: string;
  /**
   * The transitions that can be performed on the issue.
   */
  readonly transitions?: Array<IssueTransition>;
  /**
   * The versions of each field on the issue.
   */
  readonly versionedRepresentations?: {
    [key: string]: {
      [key: string]: string;
    };
  };
};

export type IssueBulkEditField = {
  /**
   * Description of the field.
   */
  description?: string;
  /**
   * A list of options related to the field, applicable in contexts where multiple selections are allowed.
   */
  fieldOptions?: Array<IssueBulkOperationsFieldOption>;
  /**
   * The unique ID of the field.
   */
  id?: string;
  /**
   * Indicates whether the field is mandatory for the operation.
   */
  isRequired?: boolean;
  /**
   * Specifies supported actions (like add, replace, remove) on multi-select fields via an enum.
   */
  multiSelectFieldOptions?: Array<'ADD' | 'REMOVE' | 'REPLACE' | 'REMOVE_ALL'>;
  /**
   * The display name of the field.
   */
  name?: string;
  /**
   * A URL to fetch additional data for the field
   */
  searchUrl?: string;
  /**
   * The type of the field.
   */
  type?: string;
  /**
   * A message indicating why the field is unavailable for editing.
   */
  unavailableMessage?: string;
};

/**
 * Issue Bulk Edit Payload
 */
export type IssueBulkEditPayload = {
  /**
   * An object that defines the values to be updated in specified fields of an issue. The structure and content of this parameter vary depending on the type of field being edited. Although the order is not significant, ensure that field IDs align with those in selectedActions.
   */
  editedFieldsInput: JiraIssueFields;
  /**
   * List of all the field IDs that are to be bulk edited. Each field ID in this list corresponds to a specific attribute of an issue that is set to be modified in the bulk edit operation. The relevant field ID can be obtained by calling the Bulk Edit Get Fields REST API (documentation available on this page itself).
   */
  selectedActions: Array<string>;
  /**
   * List of issue IDs or keys which are to be bulk edited. These IDs or keys can be from different projects and issue types.
   */
  selectedIssueIdsOrKeys: Array<string>;
  /**
   * A boolean value that indicates whether to send a bulk change notification when the issues are being edited.
   *
   * If `true`, dispatches a bulk notification email to users about the updates.
   */
  sendBulkNotification?: boolean | null;
};

/**
 * Issue Bulk Move Payload
 */
export type IssueBulkMovePayload = {
  /**
   * A boolean value that indicates whether to send a bulk change notification when the issues are being moved.
   *
   * If `true`, dispatches a bulk notification email to users about the updates.
   */
  sendBulkNotification?: boolean | null;
  /**
   * An object representing the mapping of issues and data related to destination entities, like fields and statuses, that are required during a bulk move.
   *
   * The key is a string that is created by concatenating the following three entities in order, separated by commas. The format is `<project ID or key>,<issueType ID>,<parent ID or key>`. It should be unique across mappings provided in the payload. If you provide multiple mappings for the same key, only one will be processed. However, the operation won't fail, so the error may be hard to track down.
   *
   * *  ***Destination project*** (Required): ID or key of the project to which the issues are being moved.
   * *  ***Destination issueType*** (Required): ID of the issueType to which the issues are being moved.
   * *  ***Destination parent ID or key*** (Optional): ID or key of the issue which will become the parent of the issues being moved. Only required when the destination issueType is a subtask.
   */
  targetToSourcesMapping?: {
    [key: string]: targetToSourcesMapping;
  };
};

export type IssueBulkOperationsFieldOption = {
  [key: string]: string;
};

/**
 * A list of changelog IDs.
 */
export type IssueChangelogIds = {
  /**
   * The list of changelog IDs.
   */
  changelogIds: Array<number>;
};

export type IssueCommentListRequestBean = {
  /**
   * The list of comment IDs. A maximum of 1000 IDs can be specified.
   */
  ids: Array<number>;
};

/**
 * An [issue](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#issue) specified by ID or key. All the fields of the issue object are available in the Jira expression.
 */
export type IssueContextVariable = {
  /**
   * The issue ID.
   */
  id?: number;
  /**
   * The issue key.
   */
  key?: string;
  /**
   * Type of custom context variable.
   */
  type: 'issue';
};

/**
 * The wrapper for the issue creation metadata for a list of projects.
 */
export type IssueCreateMetadata = {
  /**
   * Expand options that include additional project details in the response.
   */
  readonly expand?: string;
  /**
   * List of projects and their issue creation metadata.
   */
  readonly projects?: Array<ProjectIssueCreateMetadata>;
};

/**
 * Lists of issues and entity properties. See [Entity properties](https://developer.atlassian.com/cloud/jira/platform/jira-entity-properties/) for more information.
 */
export type IssueEntityProperties = {
  /**
   * A list of entity property IDs.
   */
  entitiesIds?: Array<number>;
  /**
   * A list of entity property keys and values.
   */
  properties?: {
    [key: string]: JsonNode;
  };
};

/**
 * An issue ID with entity property values. See [Entity properties](https://developer.atlassian.com/cloud/jira/platform/jira-entity-properties/) for more information.
 */
export type IssueEntityPropertiesForMultiUpdate = {
  /**
   * The ID of the issue.
   */
  issueID?: number;
  /**
   * Entity properties to set on the issue. The maximum length of an issue property value is 32768 characters.
   */
  properties?: {
    [key: string]: JsonNode;
  };
};

/**
 * Describes the error that occurred when retrieving data for a particular issue.
 */
export type IssueError = {
  /**
   * The error that occurred when fetching this issue.
   */
  readonly errorMessage?: string;
  /**
   * The ID of the issue.
   */
  readonly id?: string;
};

/**
 * Details about an issue event.
 */
export type IssueEvent = {
  /**
   * The ID of the event.
   */
  readonly id?: number;
  /**
   * The name of the event.
   */
  readonly name?: string;
};

/**
 * Details of the options for a select list issue field.
 */
export type IssueFieldOption = {
  config?: IssueFieldOptionConfiguration;
  /**
   * The unique identifier for the option. This is only unique within the select field's set of options.
   */
  id: number;
  /**
   * The properties of the object, as arbitrary key-value pairs. These properties can be searched using JQL, if the extractions (see [Issue Field Option Property Index](https://developer.atlassian.com/cloud/jira/platform/modules/issue-field-option-property-index/)) are defined in the descriptor for the issue field module.
   */
  properties?: {
    [key: string]: string;
  };
  /**
   * The option's name, which is displayed in Jira.
   */
  value: string;
};

/**
 * Details of the projects the option is available in.
 */
export type IssueFieldOptionConfiguration = {
  /**
   * DEPRECATED
   */
  attributes?: Array<'notSelectable' | 'defaultValue'>;
  /**
   * Defines the projects that the option is available in. If the scope is not defined, then the option is available in all projects.
   */
  scope?: IssueFieldOptionScopeBean;
};

export type IssueFieldOptionCreateBean = {
  config?: IssueFieldOptionConfiguration;
  /**
   * The properties of the option as arbitrary key-value pairs. These properties can be searched using JQL, if the extractions (see https://developer.atlassian.com/cloud/jira/platform/modules/issue-field-option-property-index/) are defined in the descriptor for the issue field module.
   */
  properties?: {
    [key: string]: string;
  };
  /**
   * The option's name, which is displayed in Jira.
   */
  value: string;
};

export type IssueFieldOptionScopeBean = {
  /**
   * Defines the behavior of the option within the global context. If this property is set, even if set to an empty object, then the option is available in all projects.
   */
  global?: GlobalScopeBean;
  /**
   * DEPRECATED
   */
  projects?: Array<number>;
  /**
   * Defines the projects in which the option is available and the behavior of the option within each project. Specify one object per project. The behavior of the option in a project context overrides the behavior in the global context.
   */
  projects2?: Array<ProjectScopeBean>;
};

/**
 * Bulk operation filter details.
 */
export type IssueFilterForBulkPropertyDelete = {
  /**
   * The value of properties to perform the bulk operation on.
   */
  currentValue?: string;
  /**
   * List of issues to perform the bulk delete operation on.
   */
  entityIds?: Array<number>;
};

/**
 * Bulk operation filter details.
 */
export type IssueFilterForBulkPropertySet = {
  /**
   * The value of properties to perform the bulk operation on.
   */
  currentValue?: string;
  /**
   * List of issues to perform the bulk operation on.
   */
  entityIds?: Array<number>;
  /**
   * Whether the bulk operation occurs only when the property is present on or absent from an issue.
   */
  hasProperty?: boolean;
};

export type IssueLimitReportRequest = {
  /**
   * A list of fields and their respective approaching limit threshold. Required for querying issues approaching limits. Optional for querying issues breaching limits. Accepted fields are: `comment`, `worklog`, `attachment`, `remoteIssueLinks`, and `issuelinks`. Example: `{"issuesApproachingLimitParams": {"comment": 4500, "attachment": 1800}}`
   */
  issuesApproachingLimitParams?: {
    [key: string]: number;
  };
};

export type IssueLimitReportResponseBean = {
  /**
   * A list of ids of issues approaching the limit and their field count
   */
  issuesApproachingLimit?: {
    [key: string]: {
      [key: string]: number;
    };
  };
  /**
   * A list of ids of issues breaching the limit and their field count
   */
  issuesBreachingLimit?: {
    [key: string]: {
      [key: string]: number;
    };
  };
  /**
   * The fields and their defined limits
   */
  limits?: {
    [key: string]: number;
  };
};

/**
 * Details of a link between issues.
 */
export type IssueLink = {
  /**
   * The ID of the issue link.
   */
  readonly id?: string;
  /**
   * Provides details about the linked issue. If presenting this link in a user interface, use the `inward` field of the issue link type to label the link.
   */
  inwardIssue: LinkedIssue;
  /**
   * Provides details about the linked issue. If presenting this link in a user interface, use the `outward` field of the issue link type to label the link.
   */
  outwardIssue: LinkedIssue;
  /**
   * The URL of the issue link.
   */
  readonly self?: string;
  /**
   * The type of link between the issues.
   */
  type: IssueLinkType;
};

/**
 * This object is used as follows:
 *
 * *  In the [ issueLink](#api-rest-api-3-issueLink-post) resource it defines and reports on the type of link between the issues. Find a list of issue link types with [Get issue link types](#api-rest-api-3-issueLinkType-get).
 * *  In the [ issueLinkType](#api-rest-api-3-issueLinkType-post) resource it defines and reports on issue link types.
 */
export type IssueLinkType = {
  /**
   * The ID of the issue link type and is used as follows:
   *
   * *  In the [ issueLink](#api-rest-api-3-issueLink-post) resource it is the type of issue link. Required on create when `name` isn't provided. Otherwise, read only.
   * *  In the [ issueLinkType](#api-rest-api-3-issueLinkType-post) resource it is read only.
   */
  id?: string;
  /**
   * The description of the issue link type inward link and is used as follows:
   *
   * *  In the [ issueLink](#api-rest-api-3-issueLink-post) resource it is read only.
   * *  In the [ issueLinkType](#api-rest-api-3-issueLinkType-post) resource it is required on create and optional on update. Otherwise, read only.
   */
  inward?: string;
  /**
   * The name of the issue link type and is used as follows:
   *
   * *  In the [ issueLink](#api-rest-api-3-issueLink-post) resource it is the type of issue link. Required on create when `id` isn't provided. Otherwise, read only.
   * *  In the [ issueLinkType](#api-rest-api-3-issueLinkType-post) resource it is required on create and optional on update. Otherwise, read only.
   */
  name?: string;
  /**
   * The description of the issue link type outward link and is used as follows:
   *
   * *  In the [ issueLink](#api-rest-api-3-issueLink-post) resource it is read only.
   * *  In the [ issueLinkType](#api-rest-api-3-issueLinkType-post) resource it is required on create and optional on update. Otherwise, read only.
   */
  outward?: string;
  /**
   * The URL of the issue link type. Read only.
   */
  readonly self?: string;
};

/**
 * A list of issue link type beans.
 */
export type IssueLinkTypes = {
  /**
   * The issue link type bean.
   */
  readonly issueLinkTypes?: Array<IssueLinkType>;
};

/**
 * A list of issue IDs.
 */
export type IssueList = {
  /**
   * The list of issue IDs.
   */
  issueIds: Array<string>;
};

/**
 * A list of matched issues or errors for each JQL query, in the order the JQL queries were passed.
 */
export type IssueMatches = {
  matches: Array<IssueMatchesForJQL>;
};

/**
 * A list of the issues matched to a JQL query or details of errors encountered during matching.
 */
export type IssueMatchesForJQL = {
  /**
   * A list of errors.
   */
  errors: Array<string>;
  /**
   * A list of issue IDs.
   */
  matchedIssues: Array<number>;
};

/**
 * A list of issues suggested for use in auto-completion.
 */
export type IssuePickerSuggestions = {
  /**
   * A list of issues for an issue type suggested for use in auto-completion.
   */
  readonly sections?: Array<IssuePickerSuggestionsIssueType>;
};

/**
 * A type of issue suggested for use in auto-completion.
 */
export type IssuePickerSuggestionsIssueType = {
  /**
   * The ID of the type of issues suggested for use in auto-completion.
   */
  readonly id?: string;
  /**
   * A list of issues suggested for use in auto-completion.
   */
  readonly issues?: Array<SuggestedIssue>;
  /**
   * The label of the type of issues suggested for use in auto-completion.
   */
  readonly label?: string;
  /**
   * If no issue suggestions are found, returns a message indicating no suggestions were found,
   */
  readonly msg?: string;
  /**
   * If issue suggestions are found, returns a message indicating the number of issues suggestions found and returned.
   */
  readonly sub?: string;
};

/**
 * Issue security level member.
 */
export type IssueSecurityLevelMember = {
  /**
   * The user or group being granted the permission. It consists of a `type` and a type-dependent `parameter`. See [Holder object](../api-group-permission-schemes/#holder-object) in *Get all permission schemes* for more information.
   */
  holder: PermissionHolder;
  /**
   * The ID of the issue security level member.
   */
  id: number;
  /**
   * The ID of the issue security level.
   */
  issueSecurityLevelId: number;
  managed?: boolean;
};

/**
 * Details about an project using security scheme mapping.
 */
export type IssueSecuritySchemeToProjectMapping = {
  readonly issueSecuritySchemeId?: string;
  readonly projectId?: string;
};

/**
 * Details of an issue transition.
 */
export type IssueTransition = {
  /**
   * Expand options that include additional transition details in the response.
   */
  readonly expand?: string;
  /**
   * Details of the fields associated with the issue transition screen. Use this information to populate `fields` and `update` in a transition request.
   */
  readonly fields?: {
    [key: string]: FieldMetadata;
  };
  /**
   * Whether there is a screen associated with the issue transition.
   */
  readonly hasScreen?: boolean;
  /**
   * The ID of the issue transition. Required when specifying a transition to undertake.
   */
  id?: string;
  /**
   * Whether the transition is available to be performed.
   */
  readonly isAvailable?: boolean;
  /**
   * Whether the issue has to meet criteria before the issue transition is applied.
   */
  readonly isConditional?: boolean;
  /**
   * Whether the issue transition is global, that is, the transition is applied to issues regardless of their status.
   */
  readonly isGlobal?: boolean;
  /**
   * Whether this is the initial issue transition for the workflow.
   */
  readonly isInitial?: boolean;
  looped?: boolean;
  /**
   * The name of the issue transition.
   */
  readonly name?: string;
  /**
   * Details of the issue status after the transition.
   */
  readonly to?: StatusDetails;
};

export type IssueTypeCreateBean = {
  /**
   * The description of the issue type.
   */
  description?: string;
  /**
   * The hierarchy level of the issue type. Use:
   *
   * *  `-1` for Subtask.
   * *  `0` for Base.
   *
   * Defaults to `0`.
   */
  hierarchyLevel?: number;
  /**
   * The unique name for the issue type. The maximum length is 60 characters.
   */
  name: string;
  /**
   * Deprecated. Use `hierarchyLevel` instead. See the [deprecation notice](https://community.developer.atlassian.com/t/deprecation-of-the-epic-link-parent-link-and-other-related-fields-in-rest-apis-and-webhooks/54048) for details.
   *
   * Whether the issue type is `subtype` or `standard`. Defaults to `standard`.
   */
  type?: 'subtask' | 'standard';
};

/**
 * Deprecated. Use `hierarchyLevel` instead. See the [deprecation notice](https://community.developer.atlassian.com/t/deprecation-of-the-epic-link-parent-link-and-other-related-fields-in-rest-apis-and-webhooks/54048) for details.
 *
 * Whether the issue type is `subtype` or `standard`. Defaults to `standard`.
 */
export type type4 = 'subtask' | 'standard';

/**
 * Details about an issue type.
 */
export type IssueTypeDetails = {
  /**
   * The ID of the issue type's avatar.
   */
  readonly avatarId?: number;
  /**
   * The description of the issue type.
   */
  readonly description?: string;
  /**
   * Unique ID for next-gen projects.
   */
  readonly entityId?: string;
  /**
   * Hierarchy level of the issue type.
   */
  readonly hierarchyLevel?: number;
  /**
   * The URL of the issue type's avatar.
   */
  readonly iconUrl?: string;
  /**
   * The ID of the issue type.
   */
  readonly id?: string;
  /**
   * The name of the issue type.
   */
  readonly name?: string;
  /**
   * Details of the next-gen projects the issue type is available in.
   */
  readonly scope?: Scope;
  /**
   * The URL of these issue type details.
   */
  readonly self?: string;
  /**
   * Whether this issue type is used to create subtasks.
   */
  readonly subtask?: boolean;
};

/**
 * The list of issue type IDs.
 */
export type IssueTypeIds = {
  /**
   * The list of issue type IDs.
   */
  issueTypeIds: Array<string>;
};

/**
 * The list of issue type IDs to be removed from the field configuration scheme.
 */
export type IssueTypeIdsToRemove = {
  /**
   * The list of issue type IDs. Must contain unique values not longer than 255 characters and not be empty. Maximum of 100 IDs.
   */
  issueTypeIds: Array<string>;
};

/**
 * Details of an issue type.
 */
export type IssueTypeInfo = {
  /**
   * The avatar of the issue type.
   */
  readonly avatarId?: number;
  /**
   * The ID of the issue type.
   */
  readonly id?: number;
  /**
   * The name of the issue type.
   */
  readonly name?: string;
};

/**
 * Details of the issue creation metadata for an issue type.
 */
export type IssueTypeIssueCreateMetadata = {
  /**
   * The ID of the issue type's avatar.
   */
  readonly avatarId?: number;
  /**
   * The description of the issue type.
   */
  readonly description?: string;
  /**
   * Unique ID for next-gen projects.
   */
  readonly entityId?: string;
  /**
   * Expand options that include additional issue type metadata details in the response.
   */
  readonly expand?: string;
  /**
   * List of the fields available when creating an issue for the issue type.
   */
  readonly fields?: {
    [key: string]: FieldMetadata;
  };
  /**
   * Hierarchy level of the issue type.
   */
  readonly hierarchyLevel?: number;
  /**
   * The URL of the issue type's avatar.
   */
  readonly iconUrl?: string;
  /**
   * The ID of the issue type.
   */
  readonly id?: string;
  /**
   * The name of the issue type.
   */
  readonly name?: string;
  /**
   * Details of the next-gen projects the issue type is available in.
   */
  readonly scope?: Scope;
  /**
   * The URL of these issue type details.
   */
  readonly self?: string;
  /**
   * Whether this issue type is used to create subtasks.
   */
  readonly subtask?: boolean;
};

/**
 * Details of an issue type scheme.
 */
export type IssueTypeScheme = {
  /**
   * The ID of the default issue type of the issue type scheme.
   */
  defaultIssueTypeId?: string;
  /**
   * The description of the issue type scheme.
   */
  description?: string;
  /**
   * The ID of the issue type scheme.
   */
  id: string;
  /**
   * Whether the issue type scheme is the default.
   */
  isDefault?: boolean;
  /**
   * The name of the issue type scheme.
   */
  name: string;
};

/**
 * Details of an issue type scheme and its associated issue types.
 */
export type IssueTypeSchemeDetails = {
  /**
   * The ID of the default issue type of the issue type scheme. This ID must be included in `issueTypeIds`.
   */
  defaultIssueTypeId?: string;
  /**
   * The description of the issue type scheme. The maximum length is 4000 characters.
   */
  description?: string;
  /**
   * The list of issue types IDs of the issue type scheme. At least one standard issue type ID is required.
   */
  issueTypeIds: Array<string>;
  /**
   * The name of the issue type scheme. The name must be unique. The maximum length is 255 characters.
   */
  name: string;
};

/**
 * The ID of an issue type scheme.
 */
export type IssueTypeSchemeID = {
  /**
   * The ID of the issue type scheme.
   */
  readonly issueTypeSchemeId: string;
};

/**
 * Issue type scheme item.
 */
export type IssueTypeSchemeMapping = {
  /**
   * The ID of the issue type.
   */
  issueTypeId: string;
  /**
   * The ID of the issue type scheme.
   */
  issueTypeSchemeId: string;
};

/**
 * Details of the association between an issue type scheme and project.
 */
export type IssueTypeSchemeProjectAssociation = {
  /**
   * The ID of the issue type scheme.
   */
  issueTypeSchemeId: string;
  /**
   * The ID of the project.
   */
  projectId: string;
};

/**
 * Issue type scheme with a list of the projects that use it.
 */
export type IssueTypeSchemeProjects = {
  /**
   * Details of an issue type scheme.
   */
  issueTypeScheme: IssueTypeScheme;
  /**
   * The IDs of the projects using the issue type scheme.
   */
  projectIds: Array<string>;
};

/**
 * Details of the name, description, and default issue type for an issue type scheme.
 */
export type IssueTypeSchemeUpdateDetails = {
  /**
   * The ID of the default issue type of the issue type scheme.
   */
  defaultIssueTypeId?: string;
  /**
   * The description of the issue type scheme. The maximum length is 4000 characters.
   */
  description?: string;
  /**
   * The name of the issue type scheme. The name must be unique. The maximum length is 255 characters.
   */
  name?: string;
};

/**
 * Details of an issue type screen scheme.
 */
export type IssueTypeScreenScheme = {
  /**
   * The description of the issue type screen scheme.
   */
  description?: string;
  /**
   * The ID of the issue type screen scheme.
   */
  id: string;
  /**
   * The name of the issue type screen scheme.
   */
  name: string;
};

/**
 * The details of an issue type screen scheme.
 */
export type IssueTypeScreenSchemeDetails = {
  /**
   * The description of the issue type screen scheme. The maximum length is 255 characters.
   */
  description?: string;
  /**
   * The IDs of the screen schemes for the issue type IDs and *default*. A *default* entry is required to create an issue type screen scheme, it defines the mapping for all issue types without a screen scheme.
   */
  issueTypeMappings: Array<IssueTypeScreenSchemeMapping>;
  /**
   * The name of the issue type screen scheme. The name must be unique. The maximum length is 255 characters.
   */
  name: string;
};

/**
 * The ID of an issue type screen scheme.
 */
export type IssueTypeScreenSchemeId = {
  /**
   * The ID of the issue type screen scheme.
   */
  readonly id: string;
};

/**
 * The screen scheme for an issue type.
 */
export type IssueTypeScreenSchemeItem = {
  /**
   * The ID of the issue type or *default*. Only issue types used in classic projects are accepted. When creating an issue screen scheme, an entry for *default* must be provided and defines the mapping for all issue types without a screen scheme. Otherwise, a *default* entry can't be provided.
   */
  issueTypeId: string;
  /**
   * The ID of the issue type screen scheme.
   */
  issueTypeScreenSchemeId: string;
  /**
   * The ID of the screen scheme.
   */
  screenSchemeId: string;
};

/**
 * The IDs of the screen schemes for the issue type IDs.
 */
export type IssueTypeScreenSchemeMapping = {
  /**
   * The ID of the issue type or *default*. Only issue types used in classic projects are accepted. An entry for *default* must be provided and defines the mapping for all issue types without a screen scheme.
   */
  issueTypeId: string;
  /**
   * The ID of the screen scheme. Only screen schemes used in classic projects are accepted.
   */
  screenSchemeId: string;
};

/**
 * A list of issue type screen scheme mappings.
 */
export type IssueTypeScreenSchemeMappingDetails = {
  /**
   * The list of issue type to screen scheme mappings. A *default* entry cannot be specified because a default entry is added when an issue type screen scheme is created.
   */
  issueTypeMappings: Array<IssueTypeScreenSchemeMapping>;
};

/**
 * Associated issue type screen scheme and project.
 */
export type IssueTypeScreenSchemeProjectAssociation = {
  /**
   * The ID of the issue type screen scheme.
   */
  issueTypeScreenSchemeId?: string;
  /**
   * The ID of the project.
   */
  projectId?: string;
};

/**
 * Details of an issue type screen scheme.
 */
export type IssueTypeScreenSchemeUpdateDetails = {
  /**
   * The description of the issue type screen scheme. The maximum length is 255 characters.
   */
  description?: string;
  /**
   * The name of the issue type screen scheme. The name must be unique. The maximum length is 255 characters.
   */
  name?: string;
};

/**
 * Issue type screen scheme with a list of the projects that use it.
 */
export type IssueTypeScreenSchemesProjects = {
  /**
   * Details of an issue type screen scheme.
   */
  issueTypeScreenScheme: IssueTypeScreenScheme;
  /**
   * The IDs of the projects using the issue type screen scheme.
   */
  projectIds: Array<string>;
};

/**
 * Mapping of an issue type to a context.
 */
export type IssueTypeToContextMapping = {
  /**
   * The ID of the context.
   */
  contextId: string;
  /**
   * Whether the context is mapped to any issue type.
   */
  isAnyIssueType?: boolean;
  /**
   * The ID of the issue type.
   */
  issueTypeId?: string;
};

export type IssueTypeUpdateBean = {
  /**
   * The ID of an issue type avatar.
   */
  avatarId?: number;
  /**
   * The description of the issue type.
   */
  description?: string;
  /**
   * The unique name for the issue type. The maximum length is 60 characters.
   */
  name?: string;
};

/**
 * Status details for an issue type.
 */
export type IssueTypeWithStatus = {
  /**
   * The ID of the issue type.
   */
  readonly id: string;
  /**
   * The name of the issue type.
   */
  readonly name: string;
  /**
   * The URL of the issue type's status details.
   */
  readonly self: string;
  /**
   * List of status details for the issue type.
   */
  readonly statuses: Array<StatusDetails>;
  /**
   * Whether this issue type represents subtasks.
   */
  readonly subtask: boolean;
};

/**
 * Details about the mapping between an issue type and a workflow.
 */
export type IssueTypeWorkflowMapping = {
  /**
   * The ID of the issue type. Not required if updating the issue type-workflow mapping.
   */
  issueType?: string;
  /**
   * Set to true to create or update the draft of a workflow scheme and update the mapping in the draft, when the workflow scheme cannot be edited. Defaults to `false`. Only applicable when updating the workflow-issue types mapping.
   */
  updateDraftIfNeeded?: boolean;
  /**
   * The name of the workflow.
   */
  workflow?: string;
};

/**
 * Details about the mapping between issue types and a workflow.
 */
export type IssueTypesWorkflowMapping = {
  /**
   * Whether the workflow is the default workflow for the workflow scheme.
   */
  defaultMapping?: boolean;
  /**
   * The list of issue type IDs.
   */
  issueTypes?: Array<string>;
  /**
   * Whether a draft workflow scheme is created or updated when updating an active workflow scheme. The draft is updated with the new workflow-issue types mapping. Defaults to `false`.
   */
  updateDraftIfNeeded?: boolean;
  /**
   * The name of the workflow. Optional if updating the workflow-issue types mapping.
   */
  workflow?: string;
};

/**
 * Details of an issue update request.
 */
export type IssueUpdateDetails = {
  /**
   * List of issue screen fields to update, specifying the sub-field to update and its value for each field. This field provides a straightforward option when setting a sub-field. When multiple sub-fields or other operations are required, use `update`. Fields included in here cannot be included in `update`.
   */
  fields?: {
    [key: string]: string;
  };
  /**
   * Additional issue history details.
   */
  historyMetadata?: HistoryMetadata;
  /**
   * Details of issue properties to be add or update.
   */
  properties?: Array<EntityProperty>;
  /**
   * Details of a transition. Required when performing a transition, optional when creating or editing an issue.
   */
  transition?: IssueTransition;
  /**
   * A Map containing the field field name and a list of operations to perform on the issue screen field. Note that fields included in here cannot be included in `fields`.
   */
  update?: {
    [key: string]: Array<FieldUpdateOperation>;
  };
};

/**
 * A list of editable field details.
 */
export type IssueUpdateMetadata = {
  readonly fields?: {
    [key: string]: FieldMetadata;
  };
};

/**
 * List of issues and JQL queries.
 */
export type IssuesAndJQLQueries = {
  /**
   * A list of issue IDs.
   */
  issueIds: Array<number>;
  /**
   * A list of JQL queries.
   */
  jqls: Array<string>;
};

/**
 * The description of the page of issues loaded by the provided JQL query.
 */
export type IssuesJqlMetaDataBean = {
  /**
   * The number of issues that were loaded in this evaluation.
   */
  count: number;
  /**
   * The maximum number of issues that could be loaded in this evaluation.
   */
  maxResults: number;
  /**
   * The index of the first issue.
   */
  startAt: number;
  /**
   * The total number of issues the JQL returned.
   */
  totalCount: number;
  /**
   * Any warnings related to the JQL query. Present only if the validation mode was set to `warn`.
   */
  validationWarnings?: Array<string>;
};

/**
 * Meta data describing the `issues` context variable.
 */
export type IssuesMetaBean = {
  jql?: IssuesJqlMetaDataBean;
};

export type IssuesUpdateBean = {
  issueUpdates?: Array<IssueUpdateDetails>;
};

/**
 * The description of the page of issues loaded by the provided JQL query.This bean will be replacing IssuesJqlMetaDataBean bean as part of new `evaluate` endpoint
 */
export type JExpEvaluateIssuesJqlMetaDataBean = {
  /**
   * Next Page token for the next page of issues.
   */
  nextPageToken: string;
};

/**
 * Meta data describing the `issues` context variable.This bean will be replacing IssuesMetaBean bean as part of new `evaluate` endpoint
 */
export type JExpEvaluateIssuesMetaBean = {
  jql?: JExpEvaluateIssuesJqlMetaDataBean;
};

/**
 * The result of evaluating a Jira expression.This bean will be replacing `JiraExpressionResultBean` bean as part of new evaluate endpoint
 */
export type JExpEvaluateJiraExpressionResultBean = {
  /**
   * Contains various characteristics of the performed expression evaluation.
   */
  meta?: JExpEvaluateMetaDataBean;
  /**
   * The value of the evaluated expression. It may be a primitive JSON value or a Jira REST API object. (Some expressions do not produce any meaningful results—for example, an expression that returns a lambda function—if that's the case a simple string representation is returned. These string representations should not be relied upon and may change without notice.)
   */
  value?: string;
};

/**
 * Contains information about the expression evaluation. This bean will be replacing `JiraExpressionEvaluationMetaDataBean` bean as part of new `evaluate` endpoint
 */
export type JExpEvaluateMetaDataBean = {
  /**
   * Contains information about the expression complexity. For example, the number of steps it took to evaluate the expression.
   */
  complexity?: JiraExpressionsComplexityBean;
  /**
   * Contains information about the `issues` variable in the context. For example, is the issues were loaded with JQL, information about the page will be included here.
   */
  issues?: JExpEvaluateIssuesMetaBean;
};

export type JQLCountRequestBean = {
  /**
   * A [JQL](https://confluence.atlassian.com/x/egORLQ) expression. For performance reasons, this field requires a bounded query. A bounded query is a query with a search restriction.
   */
  jql?: string;
};

export type JQLCountResultsBean = {
  /**
   * Number of issues matching JQL query.
   */
  count?: number;
};

/**
 * The JQL queries to be converted.
 */
export type JQLPersonalDataMigrationRequest = {
  /**
   * A list of queries with user identifiers. Maximum of 100 queries.
   */
  queryStrings?: Array<string>;
};

/**
 * JQL queries that contained users that could not be found
 */
export type JQLQueryWithUnknownUsers = {
  /**
   * The converted query, with accountIDs instead of user identifiers, or 'unknown' for users that could not be found
   */
  convertedQuery?: string;
  /**
   * The original query, for reference
   */
  originalQuery?: string;
};

/**
 * Lists of JQL reference data.
 */
export type JQLReferenceData = {
  /**
   * List of JQL query reserved words.
   */
  jqlReservedWords?: Array<string>;
  /**
   * List of fields usable in JQL queries.
   */
  visibleFieldNames?: Array<FieldReferenceData>;
  /**
   * List of functions usable in JQL queries.
   */
  visibleFunctionNames?: Array<FunctionReferenceData>;
};

/**
 * The JQL specifying the issues available in the evaluated Jira expression under the `issues` context variable. This bean will be replacing `JexpIssues` bean as part of new `evaluate` endpoint
 */
export type JexpEvaluateCtxIssues = {
  /**
   * The JQL query that specifies the set of issues available in the Jira expression.
   */
  jql?: JexpEvaluateCtxJqlIssues;
};

/**
 * The JQL specifying the issues available in the evaluated Jira expression under the `issues` context variable. Not all issues returned by the JQL query are loaded, only those described by the `nextPageToken` and `maxResults` properties. This bean will be replacing JexpJqlIssues bean as part of new `evaluate` endpoint
 */
export type JexpEvaluateCtxJqlIssues = {
  /**
   * The maximum number of issues to return from the JQL query. max results value considered may be lower than the number specific here.
   */
  maxResults?: number;
  /**
   * The token for a page to fetch that is not the first page. The first page has a `nextPageToken` of `null`. Use the `nextPageToken` to fetch the next page of issues.
   */
  nextPageToken?: string;
  /**
   * The JQL query, required to be bounded.
   */
  query?: string;
};

/**
 * The JQL specifying the issues available in the evaluated Jira expression under the `issues` context variable.
 */
export type JexpIssues = {
  /**
   * The JQL query that specifies the set of issues available in the Jira expression.
   */
  jql?: JexpJqlIssues;
};

/**
 * The JQL specifying the issues available in the evaluated Jira expression under the `issues` context variable. Not all issues returned by the JQL query are loaded, only those described by the `startAt` and `maxResults` properties. To determine whether it is necessary to iterate to ensure all the issues returned by the JQL query are evaluated, inspect `meta.issues.jql.count` in the response.
 */
export type JexpJqlIssues = {
  /**
   * The maximum number of issues to return from the JQL query. Inspect `meta.issues.jql.maxResults` in the response to ensure the maximum value has not been exceeded.
   */
  maxResults?: number;
  /**
   * The JQL query.
   */
  query?: string;
  /**
   * The index of the first issue to return from the JQL query.
   */
  startAt?: number;
  /**
   * Determines how to validate the JQL query and treat the validation results.
   */
  validation?: 'strict' | 'warn' | 'none';
};

/**
 * Determines how to validate the JQL query and treat the validation results.
 */
export type validation = 'strict' | 'warn' | 'none';

export type JiraCascadingSelectField = {
  childOptionValue?: JiraSelectedOptionField;
  fieldId: string;
  parentOptionValue: JiraSelectedOptionField;
};

export type JiraColorField = {
  color: JiraColorInput;
  fieldId: string;
};

export type JiraColorInput = {
  name: string;
};

export type JiraComponentField = {
  componentId: number;
};

export type JiraDateField = {
  date?: JiraDateInput;
  fieldId: string;
};

export type JiraDateInput = {
  formattedDate: string;
};

export type JiraDateTimeField = {
  dateTime: JiraDateTimeInput;
  fieldId: string;
};

export type JiraDateTimeInput = {
  formattedDateTime: string;
};

export type JiraDurationField = {
  originalEstimateField: string;
};

/**
 * Details about the analysed Jira expression.
 */
export type JiraExpressionAnalysis = {
  complexity?: JiraExpressionComplexity;
  /**
   * A list of validation errors. Not included if the expression is valid.
   */
  errors?: Array<JiraExpressionValidationError>;
  /**
   * The analysed expression.
   */
  expression: string;
  /**
   * EXPERIMENTAL. The inferred type of the expression.
   */
  type?: string;
  /**
   * Whether the expression is valid and the interpreter will evaluate it. Note that the expression may fail at runtime (for example, if it executes too many expensive operations).
   */
  valid: boolean;
};

/**
 * Details about the complexity of the analysed Jira expression.
 */
export type JiraExpressionComplexity = {
  /**
   * Information that can be used to determine how many [expensive operations](https://developer.atlassian.com/cloud/jira/platform/jira-expressions/#expensive-operations) the evaluation of the expression will perform. This information may be a formula or number. For example:
   *
   * *  `issues.map(i => i.comments)` performs as many expensive operations as there are issues on the issues list. So this parameter returns `N`, where `N` is the size of issue list.
   * *  `new Issue(10010).comments` gets comments for one issue, so its complexity is `2` (`1` to retrieve issue 10010 from the database plus `1` to get its comments).
   */
  expensiveOperations: string;
  /**
   * Variables used in the formula, mapped to the parts of the expression they refer to.
   */
  variables?: {
    [key: string]: string;
  };
};

export type JiraExpressionEvalContextBean = {
  /**
   * The ID of the board that is available under the `board` variable when evaluating the expression.
   */
  board?: number;
  /**
   * Custom context variables and their types. These variable types are available for use in a custom context:
   *
   * *  `user`: A [user](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#user) specified as an Atlassian account ID.
   * *  `issue`: An [issue](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#issue) specified by ID or key. All the fields of the issue object are available in the Jira expression.
   * *  `json`: A JSON object containing custom content.
   * *  `list`: A JSON list of `user`, `issue`, or `json` variable types.
   */
  custom?: Array<CustomContextVariable>;
  /**
   * The ID of the customer request that is available under the `customerRequest` variable when evaluating the expression. This is the same as the ID of the underlying Jira issue, but the customer request context variable will have a different type.
   */
  customerRequest?: number;
  /**
   * The issue that is available under the `issue` variable when evaluating the expression.
   */
  issue?: IdOrKeyBean;
  /**
   * The collection of issues that is available under the `issues` variable when evaluating the expression.
   */
  issues?: JexpIssues;
  /**
   * The project that is available under the `project` variable when evaluating the expression.
   */
  project?: IdOrKeyBean;
  /**
   * The ID of the service desk that is available under the `serviceDesk` variable when evaluating the expression.
   */
  serviceDesk?: number;
  /**
   * The ID of the sprint that is available under the `sprint` variable when evaluating the expression.
   */
  sprint?: number;
};

export type JiraExpressionEvalRequestBean = {
  /**
   * The context in which the Jira expression is evaluated.
   */
  context?: JiraExpressionEvalContextBean;
  /**
   * The Jira expression to evaluate.
   */
  expression: string;
};

export type JiraExpressionEvaluateContextBean = {
  /**
   * The ID of the board that is available under the `board` variable when evaluating the expression.
   */
  board?: number;
  /**
   * Custom context variables and their types. These variable types are available for use in a custom context:
   *
   * *  `user`: A [user](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#user) specified as an Atlassian account ID.
   * *  `issue`: An [issue](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#issue) specified by ID or key. All the fields of the issue object are available in the Jira expression.
   * *  `json`: A JSON object containing custom content.
   * *  `list`: A JSON list of `user`, `issue`, or `json` variable types.
   */
  custom?: Array<CustomContextVariable>;
  /**
   * The ID of the customer request that is available under the `customerRequest` variable when evaluating the expression. This is the same as the ID of the underlying Jira issue, but the customer request context variable will have a different type.
   */
  customerRequest?: number;
  /**
   * The issue that is available under the `issue` variable when evaluating the expression.
   */
  issue?: IdOrKeyBean;
  /**
   * The collection of issues that is available under the `issues` variable when evaluating the expression.
   */
  issues?: JexpEvaluateCtxIssues;
  /**
   * The project that is available under the `project` variable when evaluating the expression.
   */
  project?: IdOrKeyBean;
  /**
   * The ID of the service desk that is available under the `serviceDesk` variable when evaluating the expression.
   */
  serviceDesk?: number;
  /**
   * The ID of the sprint that is available under the `sprint` variable when evaluating the expression.
   */
  sprint?: number;
};

/**
 * The request to evaluate a Jira expression. This bean will be replacing `JiraExpressionEvaluateRequest` as part of new `evaluate` endpoint
 */
export type JiraExpressionEvaluateRequestBean = {
  /**
   * The context in which the Jira expression is evaluated.
   */
  context?: JiraExpressionEvaluateContextBean;
  /**
   * The Jira expression to evaluate.
   */
  expression: string;
};

export type JiraExpressionEvaluationMetaDataBean = {
  /**
   * Contains information about the expression complexity. For example, the number of steps it took to evaluate the expression.
   */
  complexity?: JiraExpressionsComplexityBean;
  /**
   * Contains information about the `issues` variable in the context. For example, is the issues were loaded with JQL, information about the page will be included here.
   */
  issues?: IssuesMetaBean;
};

/**
 * Details of Jira expressions for analysis.
 */
export type JiraExpressionForAnalysis = {
  /**
   * Context variables and their types. The type checker assumes that [common context variables](https://developer.atlassian.com/cloud/jira/platform/jira-expressions/#context-variables), such as `issue` or `project`, are available in context and sets their type. Use this property to override the default types or provide details of new variables.
   */
  contextVariables?: {
    [key: string]: string;
  };
  /**
   * The list of Jira expressions to analyse.
   */
  expressions: Array<string>;
};

/**
 * The result of evaluating a Jira expression.
 */
export type JiraExpressionResult = {
  /**
   * Contains various characteristics of the performed expression evaluation.
   */
  meta?: JiraExpressionEvaluationMetaDataBean;
  /**
   * The value of the evaluated expression. It may be a primitive JSON value or a Jira REST API object. (Some expressions do not produce any meaningful results—for example, an expression that returns a lambda function—if that's the case a simple string representation is returned. These string representations should not be relied upon and may change without notice.)
   */
  value?: string;
};

/**
 * Details about syntax and type errors. The error details apply to the entire expression, unless the object includes:
 *
 * *  `line` and `column`
 * *  `expression`
 */
export type JiraExpressionValidationError = {
  /**
   * The text column in which the error occurred.
   */
  column?: number;
  /**
   * The part of the expression in which the error occurred.
   */
  expression?: string;
  /**
   * The text line in which the error occurred.
   */
  line?: number;
  /**
   * Details about the error.
   */
  message: string;
  /**
   * The error type.
   */
  type: 'syntax' | 'type' | 'other';
};

/**
 * The error type.
 */
export type type5 = 'syntax' | 'type' | 'other';

/**
 * Details about the analysed Jira expression.
 */
export type JiraExpressionsAnalysis = {
  /**
   * The results of Jira expressions analysis.
   */
  results: Array<JiraExpressionAnalysis>;
};

export type JiraExpressionsComplexityBean = {
  /**
   * The number of Jira REST API beans returned in the response.
   */
  beans: JiraExpressionsComplexityValueBean;
  /**
   * The number of expensive operations executed while evaluating the expression. Expensive operations are those that load additional data, such as entity properties, comments, or custom fields.
   */
  expensiveOperations: JiraExpressionsComplexityValueBean;
  /**
   * The number of primitive values returned in the response.
   */
  primitiveValues: JiraExpressionsComplexityValueBean;
  /**
   * The number of steps it took to evaluate the expression, where a step is a high-level operation performed by the expression. A step is an operation such as arithmetic, accessing a property, accessing a context variable, or calling a function.
   */
  steps: JiraExpressionsComplexityValueBean;
};

export type JiraExpressionsComplexityValueBean = {
  /**
   * The maximum allowed complexity. The evaluation will fail if this value is exceeded.
   */
  limit: number;
  /**
   * The complexity value of the current expression.
   */
  value: number;
};

export type JiraGroupInput = {
  groupName: string;
};

export type JiraIssueFields = {
  /**
   * Add or clear a cascading select field:
   *
   * *  To add, specify `optionId` for both parent and child.
   * *  To clear the child, set its `optionId` to null.
   * *  To clear both, set the parent's `optionId` to null.
   */
  cascadingSelectFields?: Array<JiraCascadingSelectField>;
  /**
   * Add or clear a number field:
   *
   * *  To add, specify a numeric `value`.
   * *  To clear, set `value` to `null`.
   */
  clearableNumberFields?: Array<JiraNumberField>;
  /**
   * Add or clear a color field:
   *
   * *  To add, specify the color `name`. Available colors are: `purple`, `blue`, `green`, `teal`, `yellow`, `orange`, `grey`, `dark purple`, `dark blue`, `dark green`, `dark teal`, `dark yellow`, `dark orange`, `dark grey`.
   * *  To clear, set the color `name` to an empty string.
   */
  colorFields?: Array<JiraColorField>;
  /**
   * Add or clear a date picker field:
   *
   * *  To add, specify the date in `d/mmm/yy` format or ISO format `dd-mm-yyyy`.
   * *  To clear, set `formattedDate` to an empty string.
   */
  datePickerFields?: Array<JiraDateField>;
  /**
   * Add or clear the planned start date and time:
   *
   * *  To add, specify the date and time in ISO format for `formattedDateTime`.
   * *  To clear, provide an empty string for `formattedDateTime`.
   */
  dateTimePickerFields?: Array<JiraDateTimeField>;
  /**
   * Set the issue type field by providing an `issueTypeId`.
   */
  issueType?: JiraIssueTypeField;
  /**
   * Edit a labels field:
   *
   * *  Options include `ADD`, `REPLACE`, `REMOVE`, or `REMOVE_ALL` for bulk edits.
   * *  To clear labels, use the `REMOVE_ALL` option with an empty `labels` array.
   */
  labelsFields?: Array<JiraLabelsField>;
  /**
   * Add or clear a multi-group picker field:
   *
   * *  To add groups, provide an array of groups with `groupName`s.
   * *  To clear all groups, use an empty `groups` array.
   */
  multipleGroupPickerFields?: Array<JiraMultipleGroupPickerField>;
  /**
   * Assign or unassign multiple users to/from a field:
   *
   * *  To assign, provide an array of user `accountId`s.
   * *  To clear, set `users` to `null`.
   */
  multipleSelectClearableUserPickerFields?: Array<JiraMultipleSelectUserPickerField>;
  /**
   * Add or clear a multi-select field:
   *
   * *  To add, provide an array of options with `optionId`s.
   * *  To clear, use an empty `options` array.
   */
  multipleSelectFields?: Array<JiraMultipleSelectField>;
  /**
   * Edit a multi-version picker field like Fix Versions/Affects Versions:
   *
   * *  Options include `ADD`, `REPLACE`, `REMOVE`, or `REMOVE_ALL` for bulk edits.
   * *  To clear the field, use the `REMOVE_ALL` option with an empty `versions` array.
   */
  multipleVersionPickerFields?: Array<JiraMultipleVersionPickerField>;
  /**
   * Edit a multi select components field:
   *
   * *  Options include `ADD`, `REPLACE`, `REMOVE`, or `REMOVE_ALL` for bulk edits.
   * *  To clear, use the `REMOVE_ALL` option with an empty `components` array.
   */
  multiselectComponents?: JiraMultiSelectComponentField;
  /**
   * Edit the original estimate field.
   */
  originalEstimateField?: JiraDurationField;
  /**
   * Set the priority of an issue by specifying a `priorityId`.
   */
  priority?: JiraPriorityField;
  /**
   * Add or clear a rich text field:
   *
   * *  To add, provide `adfValue`. Note that rich text fields only support ADF values.
   * *  To clear, use an empty `richText` object.
   *
   * For ADF format details, refer to: [Atlassian Document Format](https://developer.atlassian.com/cloud/jira/platform/apis/document/structure).
   */
  richTextFields?: Array<JiraRichTextField>;
  /**
   * Add or clear a single group picker field:
   *
   * *  To add, specify the group with `groupName`.
   * *  To clear, set `groupName` to an empty string.
   */
  singleGroupPickerFields?: Array<JiraSingleGroupPickerField>;
  /**
   * Add or clear a single line text field:
   *
   * *  To add, provide the `text` value.
   * *  To clear, set `text` to an empty string.
   */
  singleLineTextFields?: Array<JiraSingleLineTextField>;
  /**
   * Edit assignment for single select user picker fields like Assignee/Reporter:
   *
   * *  To assign an issue, specify the user's `accountId`.
   * *  To unassign an issue, set `user` to `null`.
   * *  For automatic assignment, set `accountId` to `-1`.
   */
  singleSelectClearableUserPickerFields?: Array<JiraSingleSelectUserPickerField>;
  /**
   * Add or clear a single select field:
   *
   * *  To add, specify the option with an `optionId`.
   * *  To clear, pass an option with `optionId` as `-1`.
   */
  singleSelectFields?: Array<JiraSingleSelectField>;
  /**
   * Add or clear a single version picker field:
   *
   * *  To add, specify the version with a `versionId`.
   * *  To clear, set `versionId` to `-1`.
   */
  singleVersionPickerFields?: Array<JiraSingleVersionPickerField>;
  /**
   * Edit the time tracking field.
   */
  timeTrackingField?: JiraTimeTrackingField;
  /**
   * Add or clear a URL field:
   *
   * *  To add, provide the `url` with the desired URL value.
   * *  To clear, set `url` to an empty string.
   */
  urlFields?: Array<JiraUrlField>;
};

export type JiraIssueTypeField = {
  issueTypeId: string;
};

export type JiraLabelsField = {
  bulkEditMultiSelectFieldOption: 'ADD' | 'REMOVE' | 'REPLACE' | 'REMOVE_ALL';
  fieldId: string;
  labels: Array<JiraLabelsInput>;
};

export type bulkEditMultiSelectFieldOption = 'ADD' | 'REMOVE' | 'REPLACE' | 'REMOVE_ALL';

export type JiraLabelsInput = {
  name: string;
};

export type JiraMultiSelectComponentField = {
  bulkEditMultiSelectFieldOption: 'ADD' | 'REMOVE' | 'REPLACE' | 'REMOVE_ALL';
  components: Array<JiraComponentField>;
  fieldId: string;
};

export type JiraMultipleGroupPickerField = {
  fieldId: string;
  groups: Array<JiraGroupInput>;
};

export type JiraMultipleSelectField = {
  fieldId: string;
  options: Array<JiraSelectedOptionField>;
};

export type JiraMultipleSelectUserPickerField = {
  fieldId: string;
  users?: Array<JiraUserField>;
};

export type JiraMultipleVersionPickerField = {
  bulkEditMultiSelectFieldOption: 'ADD' | 'REMOVE' | 'REPLACE' | 'REMOVE_ALL';
  fieldId: string;
  versions: Array<JiraVersionField>;
};

export type JiraNumberField = {
  fieldId: string;
  value?: number;
};

export type JiraPriorityField = {
  priorityId: string;
};

export type JiraRichTextField = {
  fieldId: string;
  richText: JiraRichTextInput;
};

export type JiraRichTextInput = {
  adfValue?: {
    [key: string]: string;
  };
};

export type JiraSelectedOptionField = {
  optionId?: number;
};

export type JiraSingleGroupPickerField = {
  fieldId: string;
  group: JiraGroupInput;
};

export type JiraSingleLineTextField = {
  fieldId: string;
  text: string;
};

/**
 * Add or clear a single select field:
 *
 * *  To add, specify the option with an `optionId`.
 * *  To clear, pass an option with `optionId` as `-1`.
 */
export type JiraSingleSelectField = {
  fieldId: string;
  option: JiraSelectedOptionField;
};

export type JiraSingleSelectUserPickerField = {
  fieldId: string;
  user?: JiraUserField;
};

export type JiraSingleVersionPickerField = {
  fieldId: string;
  version: JiraVersionField;
};

/**
 * Details of a status.
 */
export type JiraStatus = {
  /**
   * The description of the status.
   */
  description?: string;
  /**
   * The ID of the status.
   */
  id?: string;
  /**
   * The name of the status.
   */
  name?: string;
  scope?: StatusScope;
  /**
   * The category of the status.
   */
  statusCategory?: 'TODO' | 'IN_PROGRESS' | 'DONE';
  /**
   * Projects and issue types where the status is used. Only available if the `usages` expand is requested.
   */
  usages?: Array<ProjectIssueTypes>;
  /**
   * The workflows that use this status. Only available if the `workflowUsages` expand is requested.
   */
  workflowUsages?: Array<WorkflowUsages>;
};

/**
 * The category of the status.
 */
export type statusCategory = 'TODO' | 'IN_PROGRESS' | 'DONE';

export type JiraTimeTrackingField = {
  timeRemaining: string;
};

export type JiraUrlField = {
  fieldId: string;
  url: string;
};

export type JiraUserField = {
  accountId: string;
};

export type JiraVersionField = {
  versionId?: string;
};

/**
 * Details of a workflow.
 */
export type JiraWorkflow = {
  /**
   * The description of the workflow.
   */
  description?: string;
  /**
   * The ID of the workflow.
   */
  id?: string;
  /**
   * Indicates if the workflow can be edited.
   */
  isEditable?: boolean;
  /**
   * The name of the workflow.
   */
  name?: string;
  scope?: WorkflowScope;
  startPointLayout?: WorkflowLayout;
  /**
   * The statuses referenced in this workflow.
   */
  statuses?: Array<WorkflowReferenceStatus>;
  /**
   * If there is a current [asynchronous task](#async-operations) operation for this workflow.
   */
  taskId?: string | null;
  /**
   * The transitions of the workflow. Note that a transition can have either the deprecated `to`/`from` fields or the `toStatusReference`/`links` fields, but never both nor a combination.
   */
  transitions?: Array<WorkflowTransitions>;
  /**
   * Use the optional `workflows.usages` expand to get additional information about the projects and issue types associated with the requested workflows.
   */
  usages?: Array<ProjectIssueTypes>;
  version?: DocumentVersion;
};

/**
 * Details of a status.
 */
export type JiraWorkflowStatus = {
  /**
   * The description of the status.
   */
  description?: string;
  /**
   * The ID of the status.
   */
  id?: string;
  /**
   * The name of the status.
   */
  name?: string;
  scope?: WorkflowScope;
  /**
   * The category of the status.
   */
  statusCategory?: 'TODO' | 'IN_PROGRESS' | 'DONE';
  /**
   * The reference of the status.
   */
  statusReference?: string;
  /**
   * The `statuses.usages` expand is an optional parameter that can be used when reading and updating statuses in Jira. It provides additional information about the projects and issue types associated with the requested statuses.
   */
  usages?: Array<ProjectIssueTypes>;
};

/**
 * Jql function precomputation.
 */
export type JqlFunctionPrecomputationBean = {
  /**
   * The list of arguments function was invoked with.
   */
  readonly arguments?: Array<string>;
  /**
   * The timestamp of the precomputation creation.
   */
  readonly created?: string;
  /**
   * The error message to be displayed to the user.
   */
  readonly error?: string;
  /**
   * The field the function was executed against.
   */
  readonly field?: string;
  /**
   * The function key.
   */
  readonly functionKey?: string;
  /**
   * The name of the function.
   */
  readonly functionName?: string;
  /**
   * The id of the precomputation.
   */
  readonly id?: string;
  /**
   * The operator in context of which function was executed.
   */
  readonly operator?: string;
  /**
   * The timestamp of the precomputation last update.
   */
  readonly updated?: string;
  /**
   * The timestamp of the precomputation last usage.
   */
  readonly used?: string;
  /**
   * The JQL fragment stored as the precomputation.
   */
  readonly value?: string;
};

/**
 * Precomputation id and its new value.
 */
export type JqlFunctionPrecomputationUpdateBean = {
  /**
   * The error message to be displayed to the user if the given function clause is no longer valid during recalculation of the precomputation.
   */
  error?: string;
  /**
   * The id of the precomputation to update.
   */
  id: string;
  /**
   * The new value of the precomputation.
   */
  value?: string;
};

/**
 * List of pairs (id and value) for precomputation updates.
 */
export type JqlFunctionPrecomputationUpdateRequestBean = {
  values?: Array<JqlFunctionPrecomputationUpdateBean>;
};

/**
 * A list of JQL queries to parse.
 */
export type JqlQueriesToParse = {
  /**
   * A list of queries to parse.
   */
  queries: Array<string>;
};

/**
 * The list of JQL queries to sanitize for the given account IDs.
 */
export type JqlQueriesToSanitize = {
  /**
   * The list of JQL queries to sanitize. Must contain unique values. Maximum of 20 queries.
   */
  queries: Array<JqlQueryToSanitize>;
};

/**
 * A parsed JQL query.
 */
export type JqlQuery = {
  orderBy?: JqlQueryOrderByClause;
  where?: JqlQueryClause;
};

/**
 * A JQL query clause.
 */
export type JqlQueryClause = CompoundClause | FieldValueClause | FieldWasClause | FieldChangedClause;

/**
 * Details of an operand in a JQL clause.
 */
export type JqlQueryClauseOperand = ListOperand | ValueOperand | FunctionOperand | KeywordOperand;

/**
 * A time predicate for a temporal JQL clause.
 */
export type JqlQueryClauseTimePredicate = {
  operand: JqlQueryClauseOperand;
  /**
   * The operator between the field and the operand.
   */
  operator: 'before' | 'after' | 'from' | 'to' | 'on' | 'during' | 'by';
};

/**
 * The operator between the field and the operand.
 */
export type operator6 = 'before' | 'after' | 'from' | 'to' | 'on' | 'during' | 'by';

/**
 * A field used in a JQL query. See [Advanced searching - fields reference](https://confluence.atlassian.com/x/dAiiLQ) for more information about fields in JQL queries.
 */
export type JqlQueryField = {
  /**
   * The encoded name of the field, which can be used directly in a JQL query.
   */
  encodedName?: string;
  /**
   * The name of the field.
   */
  name: string;
  /**
   * When the field refers to a value in an entity property, details of the entity property value.
   */
  property?: Array<JqlQueryFieldEntityProperty>;
};

/**
 * Details of an entity property.
 */
export type JqlQueryFieldEntityProperty = {
  /**
   * The object on which the property is set.
   */
  entity: string;
  /**
   * The key of the property.
   */
  key: string;
  /**
   * The path in the property value to query.
   */
  path: string;
  /**
   * The type of the property value extraction. Not available if the extraction for the property is not registered on the instance with the [Entity property](https://developer.atlassian.com/cloud/jira/platform/modules/entity-property/) module.
   */
  type?: 'number' | 'string' | 'text' | 'date' | 'user';
};

/**
 * The type of the property value extraction. Not available if the extraction for the property is not registered on the instance with the [Entity property](https://developer.atlassian.com/cloud/jira/platform/modules/entity-property/) module.
 */
export type type6 = 'number' | 'string' | 'text' | 'date' | 'user';

/**
 * Details of the order-by JQL clause.
 */
export type JqlQueryOrderByClause = {
  /**
   * The list of order-by clause fields and their ordering directives.
   */
  fields: Array<JqlQueryOrderByClauseElement>;
};

/**
 * An element of the order-by JQL clause.
 */
export type JqlQueryOrderByClauseElement = {
  /**
   * The direction in which to order the results.
   */
  direction?: 'asc' | 'desc';
  field: JqlQueryField;
};

/**
 * The direction in which to order the results.
 */
export type direction = 'asc' | 'desc';

/**
 * The JQL query to sanitize for the account ID. If the account ID is null, sanitizing is performed for an anonymous user.
 */
export type JqlQueryToSanitize = {
  /**
   * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.
   */
  accountId?: string | null;
  /**
   * The query to sanitize.
   */
  query: string;
};

/**
 * An operand that can be part of a list operand.
 */
export type JqlQueryUnitaryOperand = ValueOperand | FunctionOperand | KeywordOperand;

/**
 * A JSON object with custom content.
 */
export type JsonContextVariable = {
  /**
   * Type of custom context variable.
   */
  type: 'json';
  /**
   * A JSON object containing custom content.
   */
  value?: {
    [key: string]: string;
  };
};

export type JsonNode = {
  array?: boolean;
  bigDecimal?: boolean;
  bigInteger?: boolean;
  bigIntegerValue?: number;
  binary?: boolean;
  binaryValue?: Array<string>;
  boolean?: boolean;
  booleanValue?: boolean;
  containerNode?: boolean;
  decimalValue?: number;
  double?: boolean;
  doubleValue?: number;
  elements?: {
    [key: string]: string;
  };
  fieldNames?: {
    [key: string]: string;
  };
  fields?: {
    [key: string]: string;
  };
  floatingPointNumber?: boolean;
  int?: boolean;
  intValue?: number;
  integralNumber?: boolean;
  long?: boolean;
  longValue?: number;
  missingNode?: boolean;
  null?: boolean;
  number?: boolean;
  numberType?: 'INT' | 'LONG' | 'BIG_INTEGER' | 'FLOAT' | 'DOUBLE' | 'BIG_DECIMAL';
  numberValue?: number;
  object?: boolean;
  pojo?: boolean;
  textValue?: string;
  textual?: boolean;
  valueAsBoolean?: boolean;
  valueAsDouble?: number;
  valueAsInt?: number;
  valueAsLong?: number;
  valueAsText?: string;
  valueNode?: boolean;
};

export type numberType = 'INT' | 'LONG' | 'BIG_INTEGER' | 'FLOAT' | 'DOUBLE' | 'BIG_DECIMAL';

/**
 * The schema of a field.
 */
export type JsonTypeBean = {
  /**
   * If the field is a custom field, the configuration of the field.
   */
  readonly configuration?: {
    [key: string]: string;
  };
  /**
   * If the field is a custom field, the URI of the field.
   */
  readonly custom?: string;
  /**
   * If the field is a custom field, the custom ID of the field.
   */
  readonly customId?: number;
  /**
   * When the data type is an array, the name of the field items within the array.
   */
  readonly items?: string;
  /**
   * If the field is a system field, the name of the field.
   */
  readonly system?: string;
  /**
   * The data type of the field.
   */
  readonly type: string;
};

/**
 * An operand that is a JQL keyword. See [Advanced searching - keywords reference](https://confluence.atlassian.com/jiracorecloud/advanced-searching-keywords-reference-765593717.html#Advancedsearching-keywordsreference-EMPTYEMPTY) for more information about operand keywords.
 */
export type KeywordOperand = {
  /**
   * The keyword that is the operand value.
   */
  keyword: 'empty';
};

/**
 * The keyword that is the operand value.
 */
export type keyword = 'empty';

export type LegacyJackson1ListAttachment = Array<Attachment>;

export type LegacyJackson1ListColumnItem = Array<ColumnItem>;

export type LegacyJackson1ListIssueEvent = Array<IssueEvent>;

export type LegacyJackson1ListIssueTypeWithStatus = Array<IssueTypeWithStatus>;

export type LegacyJackson1ListProject = Array<Project>;

export type LegacyJackson1ListProjectComponent = Array<ProjectComponent>;

export type LegacyJackson1ListProjectRoleDetails = Array<ProjectRoleDetails>;

export type LegacyJackson1ListProjectType = Array<ProjectType>;

export type LegacyJackson1ListUserMigrationBean = Array<UserMigrationBean>;

export type LegacyJackson1ListVersion = Array<Version>;

export type LegacyJackson1ListWorklog = Array<Worklog>;

/**
 * Details about a license for the Jira instance.
 */
export type License = {
  /**
   * The applications under this license.
   */
  readonly applications: Array<LicensedApplication>;
};

/**
 * A metric that provides insight into the active licence details
 */
export type LicenseMetric = {
  /**
   * The key of a specific license metric.
   */
  key?: string;
  /**
   * The calculated value of a licence metric linked to the key. An example licence metric is the approximate number of user accounts.
   */
  value?: string;
};

/**
 * Details about a licensed Jira application.
 */
export type LicensedApplication = {
  /**
   * The ID of the application.
   */
  readonly id: string;
  /**
   * The licensing plan.
   */
  readonly plan: 'UNLICENSED' | 'FREE' | 'PAID';
};

/**
 * The licensing plan.
 */
export type plan = 'UNLICENSED' | 'FREE' | 'PAID';

/**
 * Details a link group, which defines issue operations.
 */
export type LinkGroup = {
  groups?: Array<LinkGroup>;
  header?: SimpleLink;
  id?: string;
  links?: Array<SimpleLink>;
  styleClass?: string;
  weight?: number;
};

export type LinkIssueRequestJsonBean = {
  comment?: Comment;
  inwardIssue: LinkedIssue;
  outwardIssue: LinkedIssue;
  type: IssueLinkType;
};

/**
 * The ID or key of a linked issue.
 */
export type LinkedIssue = {
  /**
   * The fields associated with the issue.
   */
  readonly fields?: LinkedIssueField;
  /**
   * The ID of an issue. Required if `key` isn't provided.
   */
  id?: string;
  /**
   * The key of an issue. Required if `id` isn't provided.
   */
  key?: string;
  /**
   * The URL of the issue.
   */
  readonly self?: string;
};

/**
 * An operand that is a list of values.
 */
export type ListOperand = {
  /**
   * Encoded operand, which can be used directly in a JQL query.
   */
  encodedOperand?: string;
  /**
   * The list of operand values.
   */
  values: Array<JqlQueryUnitaryOperand>;
};

export type ListWrapperCallbackApplicationRole = {
  [key: string]: string;
};

export type ListWrapperCallbackGroupName = {
  [key: string]: string;
};

/**
 * Details of a locale.
 */
export type Locale = {
  /**
   * The locale code. The Java the locale format is used: a two character language code (ISO 639), an underscore, and two letter country code (ISO 3166). For example, en\_US represents a locale of English (United States). Required on create.
   */
  locale?: string;
};

/**
 * List of string of inputs
 */
export type MandatoryFieldValue = {
  /**
   * If `true`, will try to retain original non-null issue field values on move.
   */
  retain?: boolean | null;
  /**
   * Will treat as `MandatoryFieldValue` if type is `raw` or `empty`
   */
  type: 'adf' | 'raw';
  /**
   * Value for each field. Provide a `list of strings` for non-ADF fields.
   */
  value: Array<string>;
};

/**
 * Will treat as `MandatoryFieldValue` if type is `raw` or `empty`
 */
export type type7 = 'adf' | 'raw';

/**
 * An object notation input
 */
export type MandatoryFieldValueForADF = {
  /**
   * If `true`, will try to retain original non-null issue field values on move.
   */
  retain?: boolean | null;
  /**
   * Will treat as `MandatoryFieldValueForADF` if type is `adf`
   */
  type: 'adf' | 'raw';
  /**
   * Value for each field. Accepts Atlassian Document Format (ADF) for rich text fields like `description`, `environments`. For ADF format details, refer to: [Atlassian Document Format](https://developer.atlassian.com/cloud/jira/platform/apis/document/structure)
   */
  value: {
    [key: string]: string;
  };
};

/**
 * Overrides, for the selected issue types, any status mappings provided in `statusMappingsByWorkflows`. Status mappings are required when the new workflow for an issue type doesn't contain all statuses that the old workflow has. Status mappings can be provided by a combination of `statusMappingsByWorkflows` and `statusMappingsByIssueTypeOverride`.
 */
export type MappingsByIssueTypeOverride = {
  /**
   * The ID of the issue type for this mapping.
   */
  issueTypeId: string;
  /**
   * The list of status mappings.
   */
  statusMappings: Array<WorkflowAssociationStatusMapping>;
};

/**
 * The status mappings by workflows. Status mappings are required when the new workflow for an issue type doesn't contain all statuses that the old workflow has. Status mappings can be provided by a combination of `statusMappingsByWorkflows` and `statusMappingsByIssueTypeOverride`.
 */
export type MappingsByWorkflow = {
  /**
   * The ID of the new workflow.
   */
  newWorkflowId: string;
  /**
   * The ID of the old workflow.
   */
  oldWorkflowId: string;
  /**
   * The list of status mappings.
   */
  statusMappings: Array<WorkflowAssociationStatusMapping>;
};

export type MoveFieldBean = {
  /**
   * The ID of the screen tab field after which to place the moved screen tab field. Required if `position` isn't provided.
   */
  after?: string;
  /**
   * The named position to which the screen tab field should be moved. Required if `after` isn't provided.
   */
  position?: 'Earlier' | 'Later' | 'First' | 'Last';
};

/**
 * The named position to which the screen tab field should be moved. Required if `after` isn't provided.
 */
export type position = 'Earlier' | 'Later' | 'First' | 'Last';

/**
 * A list of issues and their respective properties to set or update. See [Entity properties](https://developer.atlassian.com/cloud/jira/platform/jira-entity-properties/) for more information.
 */
export type MultiIssueEntityProperties = {
  /**
   * A list of issue IDs and their respective properties.
   */
  issues?: Array<IssueEntityPropertiesForMultiUpdate>;
};

export type MultipartFile = {
  bytes?: Array<string>;
  contentType?: string;
  empty?: boolean;
  inputStream?: {
    [key: string]: string;
  };
  name?: string;
  originalFilename?: string;
  resource?: Resource;
  size?: number;
};

/**
 * A custom field and its new value with a list of issue to update.
 */
export type MultipleCustomFieldValuesUpdate = {
  /**
   * The ID or key of the custom field. For example, `customfield_10010`.
   */
  customField: string;
  /**
   * The list of issue IDs.
   */
  issueIds: Array<number>;
  /**
   * The value for the custom field. The value must be compatible with the [custom field type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field/#data-types) as follows:
   *
   * *  `string` the value must be a string.
   * *  `number` the value must be a number.
   * *  `datetime` the value must be a string that represents a date in the ISO format or the simplified extended ISO format. For example, `"2023-01-18T12:00:00-03:00"` or `"2023-01-18T12:00:00.000Z"`. However, the milliseconds part is ignored.
   * *  `user` the value must be an object that contains the `accountId` field.
   * *  `group` the value must be an object that contains the group `name` or `groupId` field. Because group names can change, we recommend using `groupId`.
   *
   * A list of appropriate values must be provided if the field is of the `list` [collection type](https://developer.atlassian.com/platform/forge/manifest-reference/modules/jira-custom-field/#collection-types).
   */
  value?: string;
};

/**
 * List of updates for a custom fields.
 */
export type MultipleCustomFieldValuesUpdateDetails = {
  updates?: Array<MultipleCustomFieldValuesUpdate>;
};

export type NestedResponse = {
  errorCollection?: ErrorCollection;
  status?: number;
  warningCollection?: WarningCollection;
};

/**
 * The user details.
 */
export type NewUserDetails = {
  /**
   * Deprecated, do not use.
   */
  applicationKeys?: Array<string>;
  /**
   * This property is no longer available. If the user has an Atlassian account, their display name is not changed. If the user does not have an Atlassian account, they are sent an email asking them set up an account.
   */
  displayName?: string;
  /**
   * The email address for the user.
   */
  emailAddress: string;
  /**
   * This property is no longer available. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
   */
  key?: string;
  /**
   * This property is no longer available. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
   */
  name?: string;
  /**
   * This property is no longer available. If the user has an Atlassian account, their password is not changed. If the user does not have an Atlassian account, they are sent an email asking them set up an account.
   */
  password?: string;
  /**
   * Products the new user has access to. Valid products are: jira-core, jira-servicedesk, jira-product-discovery, jira-software. To create a user without product access, set this field to be an empty array.
   */
  products: Array<string>;
  /**
   * The URL of the user.
   */
  readonly self?: string;
};

/**
 * Details about a notification.
 */
export type Notification = {
  /**
   * The HTML body of the email notification for the issue.
   */
  htmlBody?: string;
  /**
   * Restricts the notifications to users with the specified permissions.
   */
  restrict?: NotificationRecipientsRestrictions;
  /**
   * The subject of the email notification for the issue. If this is not specified, then the subject is set to the issue key and summary.
   */
  subject?: string;
  /**
   * The plain text body of the email notification for the issue.
   */
  textBody?: string;
  /**
   * The recipients of the email notification for the issue.
   */
  to?: NotificationRecipients;
};

/**
 * Details about a notification event.
 */
export type NotificationEvent = {
  /**
   * The description of the event.
   */
  description?: string;
  /**
   * The ID of the event. The event can be a [Jira system event](https://confluence.atlassian.com/x/8YdKLg#Creatinganotificationscheme-eventsEvents) or a [custom event](https://confluence.atlassian.com/x/AIlKLg).
   */
  id?: number;
  /**
   * The name of the event.
   */
  name?: string;
  /**
   * The template of the event. Only custom events configured by Jira administrators have template.
   */
  templateEvent?: NotificationEvent;
};

/**
 * Details of the users and groups to receive the notification.
 */
export type NotificationRecipients = {
  /**
   * Whether the notification should be sent to the issue's assignees.
   */
  assignee?: boolean;
  /**
   * List of groupIds to receive the notification.
   */
  groupIds?: Array<string>;
  /**
   * List of groups to receive the notification.
   */
  groups?: Array<GroupName>;
  /**
   * Whether the notification should be sent to the issue's reporter.
   */
  reporter?: boolean;
  /**
   * List of users to receive the notification.
   */
  users?: Array<UserDetails>;
  /**
   * Whether the notification should be sent to the issue's voters.
   */
  voters?: boolean;
  /**
   * Whether the notification should be sent to the issue's watchers.
   */
  watchers?: boolean;
};

/**
 * Details of the group membership or permissions needed to receive the notification.
 */
export type NotificationRecipientsRestrictions = {
  /**
   * List of groupId memberships required to receive the notification.
   */
  groupIds?: Array<string>;
  /**
   * List of group memberships required to receive the notification.
   */
  groups?: Array<GroupName>;
  /**
   * List of permissions required to receive the notification.
   */
  permissions?: Array<RestrictedPermission>;
};

/**
 * Details about a notification scheme.
 */
export type NotificationScheme = {
  /**
   * The description of the notification scheme.
   */
  description?: string;
  /**
   * Expand options that include additional notification scheme details in the response.
   */
  expand?: string;
  /**
   * The ID of the notification scheme.
   */
  id?: number;
  /**
   * The name of the notification scheme.
   */
  name?: string;
  /**
   * The notification events and associated recipients.
   */
  notificationSchemeEvents?: Array<NotificationSchemeEvent>;
  /**
   * The list of project IDs associated with the notification scheme.
   */
  projects?: Array<number>;
  /**
   * The scope of the notification scheme.
   */
  scope?: Scope;
  self?: string;
};

export type NotificationSchemeAndProjectMappingJsonBean = {
  notificationSchemeId?: string;
  projectId?: string;
};

/**
 * Details about a notification scheme event.
 */
export type NotificationSchemeEvent = {
  event?: NotificationEvent;
  notifications?: Array<EventNotification>;
};

/**
 * Details of a notification scheme event.
 */
export type NotificationSchemeEventDetails = {
  /**
   * The ID of the event.
   */
  event: NotificationSchemeEventTypeId;
  /**
   * The list of notifications mapped to a specified event.
   */
  notifications: Array<NotificationSchemeNotificationDetails>;
};

/**
 * The ID of an event that is being mapped to notifications.
 */
export type NotificationSchemeEventTypeId = {
  /**
   * The ID of the notification scheme event.
   */
  id: string;
};

/**
 * The ID of a notification scheme.
 */
export type NotificationSchemeId = {
  /**
   * The ID of a notification scheme.
   */
  readonly id: string;
};

/**
 * Details of a notification within a notification scheme.
 */
export type NotificationSchemeNotificationDetails = {
  /**
   * The notification type, e.g `CurrentAssignee`, `Group`, `EmailAddress`.
   */
  notificationType: string;
  /**
   * The value corresponding to the specified notification type.
   */
  parameter?: string;
};

export type OldToNewSecurityLevelMappingsBean = {
  /**
   * The new issue security level ID. Providing null will clear the assigned old level from issues.
   */
  newLevelId: string;
  /**
   * The old issue security level ID. Providing null will remap all issues without any assigned levels.
   */
  oldLevelId: string;
};

export type OperationMessage = {
  /**
   * The human-readable message that describes the result.
   */
  message: string;
  /**
   * The status code of the response.
   */
  statusCode: number;
};

/**
 * Details of the operations that can be performed on the issue.
 */
export type Operations = {
  /**
   * Details of the link groups defining issue operations.
   */
  readonly linkGroups?: Array<LinkGroup>;
};

/**
 * An ordered list of custom field option IDs and information on where to move them.
 */
export type OrderOfCustomFieldOptions = {
  /**
   * The ID of the custom field option or cascading option to place the moved options after. Required if `position` isn't provided.
   */
  after?: string;
  /**
   * A list of IDs of custom field options to move. The order of the custom field option IDs in the list is the order they are given after the move. The list must contain custom field options or cascading options, but not both.
   */
  customFieldOptionIds: Array<string>;
  /**
   * The position the custom field options should be moved to. Required if `after` isn't provided.
   */
  position?: 'First' | 'Last';
};

/**
 * The position the custom field options should be moved to. Required if `after` isn't provided.
 */
export type position2 = 'First' | 'Last';

/**
 * An ordered list of issue type IDs and information about where to move them.
 */
export type OrderOfIssueTypes = {
  /**
   * The ID of the issue type to place the moved issue types after. Required if `position` isn't provided.
   */
  after?: string;
  /**
   * A list of the issue type IDs to move. The order of the issue type IDs in the list is the order they are given after the move.
   */
  issueTypeIds: Array<string>;
  /**
   * The position the issue types should be moved to. Required if `after` isn't provided.
   */
  position?: 'First' | 'Last';
};

/**
 * A page of items.
 */
export type PageBean2ComponentJsonBean = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<ComponentJsonBean>;
};

/**
 * A page of items.
 */
export type PageBeanBulkContextualConfiguration = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<BulkContextualConfiguration>;
};

/**
 * A page of items.
 */
export type PageBeanChangelog = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<Changelog>;
};

/**
 * A page of items.
 */
export type PageBeanComment = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<Comment>;
};

/**
 * A page of items.
 */
export type PageBeanComponentWithIssueCount = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<ComponentWithIssueCount>;
};

/**
 * A page of items.
 */
export type PageBeanContext = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<Context>;
};

/**
 * A page of items.
 */
export type PageBeanContextForProjectAndIssueType = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<ContextForProjectAndIssueType>;
};

/**
 * A page of items.
 */
export type PageBeanContextualConfiguration = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<ContextualConfiguration>;
};

/**
 * A page of items.
 */
export type PageBeanCustomFieldContext = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<CustomFieldContext>;
};

/**
 * A page of items.
 */
export type PageBeanCustomFieldContextDefaultValue = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<CustomFieldContextDefaultValue>;
};

/**
 * A page of items.
 */
export type PageBeanCustomFieldContextOption = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<CustomFieldContextOption>;
};

/**
 * A page of items.
 */
export type PageBeanCustomFieldContextProjectMapping = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<CustomFieldContextProjectMapping>;
};

/**
 * A page of items.
 */
export type PageBeanDashboard = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<Dashboard>;
};

/**
 * A page of items.
 */
export type PageBeanField = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<Field>;
};

/**
 * A page of items.
 */
export type PageBeanFieldConfigurationDetails = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<FieldConfigurationDetails>;
};

/**
 * A page of items.
 */
export type PageBeanFieldConfigurationIssueTypeItem = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<FieldConfigurationIssueTypeItem>;
};

/**
 * A page of items.
 */
export type PageBeanFieldConfigurationItem = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<FieldConfigurationItem>;
};

/**
 * A page of items.
 */
export type PageBeanFieldConfigurationScheme = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<FieldConfigurationScheme>;
};

/**
 * A page of items.
 */
export type PageBeanFieldConfigurationSchemeProjects = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<FieldConfigurationSchemeProjects>;
};

/**
 * A page of items.
 */
export type PageBeanFilterDetails = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<FilterDetails>;
};

/**
 * A page of items.
 */
export type PageBeanGroupDetails = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<GroupDetails>;
};

/**
 * A page of items.
 */
export type PageBeanIssueFieldOption = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<IssueFieldOption>;
};

/**
 * A page of items.
 */
export type PageBeanIssueSecurityLevelMember = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<IssueSecurityLevelMember>;
};

/**
 * A page of items.
 */
export type PageBeanIssueSecuritySchemeToProjectMapping = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<IssueSecuritySchemeToProjectMapping>;
};

/**
 * A page of items.
 */
export type PageBeanIssueTypeScheme = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<IssueTypeScheme>;
};

/**
 * A page of items.
 */
export type PageBeanIssueTypeSchemeMapping = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<IssueTypeSchemeMapping>;
};

/**
 * A page of items.
 */
export type PageBeanIssueTypeSchemeProjects = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<IssueTypeSchemeProjects>;
};

/**
 * A page of items.
 */
export type PageBeanIssueTypeScreenScheme = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<IssueTypeScreenScheme>;
};

/**
 * A page of items.
 */
export type PageBeanIssueTypeScreenSchemeItem = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<IssueTypeScreenSchemeItem>;
};

/**
 * A page of items.
 */
export type PageBeanIssueTypeScreenSchemesProjects = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<IssueTypeScreenSchemesProjects>;
};

/**
 * A page of items.
 */
export type PageBeanIssueTypeToContextMapping = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<IssueTypeToContextMapping>;
};

/**
 * A page of items.
 */
export type PageBeanJqlFunctionPrecomputationBean = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<JqlFunctionPrecomputationBean>;
};

/**
 * A page of items.
 */
export type PageBeanNotificationScheme = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<NotificationScheme>;
};

/**
 * A page of items.
 */
export type PageBeanNotificationSchemeAndProjectMappingJsonBean = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<NotificationSchemeAndProjectMappingJsonBean>;
};

/**
 * A page of items.
 */
export type PageBeanPriority = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<Priority>;
};

/**
 * A page of items.
 */
export type PageBeanPrioritySchemeWithPaginatedPrioritiesAndProjects = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<PrioritySchemeWithPaginatedPrioritiesAndProjects>;
};

/**
 * A page of items.
 */
export type PageBeanPriorityWithSequence = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<PriorityWithSequence>;
};

/**
 * A page of items.
 */
export type PageBeanProject = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<Project>;
};

/**
 * A page of items.
 */
export type PageBeanProjectDetails = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<ProjectDetails>;
};

/**
 * A page of items.
 */
export type PageBeanResolutionJsonBean = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<ResolutionJsonBean>;
};

/**
 * A page of items.
 */
export type PageBeanScreen = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<Screen>;
};

/**
 * A page of items.
 */
export type PageBeanScreenScheme = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<ScreenScheme>;
};

/**
 * A page of items.
 */
export type PageBeanScreenWithTab = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<ScreenWithTab>;
};

/**
 * A page of items.
 */
export type PageBeanSecurityLevel = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<SecurityLevel>;
};

/**
 * A page of items.
 */
export type PageBeanSecurityLevelMember = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<SecurityLevelMember>;
};

/**
 * A page of items.
 */
export type PageBeanSecuritySchemeWithProjects = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<SecuritySchemeWithProjects>;
};

/**
 * A page of items.
 */
export type PageBeanString = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<string>;
};

/**
 * A page of items.
 */
export type PageBeanUiModificationDetails = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<UiModificationDetails>;
};

/**
 * A page of items.
 */
export type PageBeanUser = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<User>;
};

/**
 * A page of items.
 */
export type PageBeanUserDetails = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<UserDetails>;
};

/**
 * A page of items.
 */
export type PageBeanUserKey = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<UserKey>;
};

/**
 * A page of items.
 */
export type PageBeanVersion = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<Version>;
};

/**
 * A page of items.
 */
export type PageBeanWebhook = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<Webhook>;
};

/**
 * A page of items.
 */
export type PageBeanWorkflow = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<Workflow>;
};

/**
 * A page of items.
 */
export type PageBeanWorkflowScheme = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<WorkflowScheme>;
};

/**
 * A page of items.
 */
export type PageBeanWorkflowTransitionRules = {
  /**
   * Whether this is the last page.
   */
  readonly isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * If there is another page of results, the URL of the next page.
   */
  readonly nextPage?: string;
  /**
   * The URL of the page.
   */
  readonly self?: string;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
  /**
   * The list of items.
   */
  readonly values?: Array<WorkflowTransitionRules>;
};

/**
 * A page of changelogs.
 */
export type PageOfChangelogs = {
  /**
   * The list of changelogs.
   */
  readonly histories?: Array<Changelog>;
  /**
   * The maximum number of results that could be on the page.
   */
  readonly maxResults?: number;
  /**
   * The index of the first item returned on the page.
   */
  readonly startAt?: number;
  /**
   * The number of results on the page.
   */
  readonly total?: number;
};

/**
 * A page of comments.
 */
export type PageOfComments = {
  /**
   * The list of comments.
   */
  readonly comments?: Array<Comment>;
  /**
   * The maximum number of items that could be returned.
   */
  readonly maxResults?: number;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The number of items returned.
   */
  readonly total?: number;
};

/**
 * A page of CreateMetaIssueType with Field.
 */
export type PageOfCreateMetaIssueTypeWithField = {
  /**
   * The collection of FieldCreateMetaBeans.
   */
  readonly fields?: Array<FieldCreateMetadata>;
  /**
   * The maximum number of items to return per page.
   */
  readonly maxResults?: number;
  results?: Array<FieldCreateMetadata>;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The total number of items in all pages.
   */
};

/**
 * A page of CreateMetaIssueTypes.
 */
export type PageOfCreateMetaIssueTypes = {
  createMetaIssueType?: Array<IssueTypeIssueCreateMetadata>;
  /**
   * The list of CreateMetaIssueType.
   */
  readonly issueTypes?: Array<IssueTypeIssueCreateMetadata>;
  /**
   * The maximum number of items to return per page.
   */
  readonly maxResults?: number;
  /**
   * The index of the first item returned.
   */
  readonly startAt?: number;
  /**
   * The total number of items in all pages.
   */
  readonly total?: number;
};

/**
 * A page containing dashboard details.
 */
export type PageOfDashboards = {
  /**
   * List of dashboards.
   */
  readonly dashboards?: Array<Dashboard>;
  /**
   * The maximum number of results that could be on the page.
   */
  readonly maxResults?: number;
  /**
   * The URL of the next page of results, if any.
   */
  readonly next?: string;
  /**
   * The URL of the previous page of results, if any.
   */
  readonly prev?: string;
  /**
   * The index of the first item returned on the page.
   */
  readonly startAt?: number;
  /**
   * The number of results on the page.
   */
  readonly total?: number;
};

export type PageOfStatuses = {
  /**
   * Whether this is the last page.
   */
  isLast?: boolean;
  /**
   * The maximum number of items that could be returned.
   */
  maxResults?: number;
  /**
   * The URL of the next page of results, if any.
   */
  nextPage?: string;
  /**
   * The URL of this page.
   */
  self?: string;
  /**
   * The index of the first item returned on the page.
   */
  startAt?: number;
  /**
   * Number of items that satisfy the search.
   */
  total?: number;
  /**
   * The list of items.
   */
  values?: Array<JiraStatus>;
};

/**
 * Paginated list of worklog details
 */
export type PageOfWorklogs = {
  /**
   * The maximum number of results that could be on the page.
   */
  readonly maxResults?: number;
  /**
   * The index of the first item returned on the page.
   */
  readonly startAt?: number;
  /**
   * The number of results on the page.
   */
  readonly total?: number;
  /**
   * List of worklogs.
   */
  readonly worklogs?: Array<Worklog>;
};

/**
 * A paged list. To access additional details append `[start-index:end-index]` to the expand request. For example, `?expand=sharedUsers[10:40]` returns a list starting at item 10 and finishing at item 40.
 */
export type PagedListUserDetailsApplicationUser = {
  /**
   * The index of the last item returned on the page.
   */
  readonly 'end-index'?: number;
  /**
   * The list of items.
   */
  readonly items?: Array<UserDetails>;
  /**
   * The maximum number of results that could be on the page.
   */
  readonly 'max-results'?: number;
  /**
   * The number of items on the page.
   */
  readonly size?: number;
  /**
   * The index of the first item returned on the page.
   */
  readonly 'start-index'?: number;
};

export type PaginatedResponseComment = {
  maxResults?: number;
  results?: Array<Comment>;
  startAt?: number;
  total?: number;
};

export type PaginatedResponseFieldCreateMetadata = {
  maxResults?: number;
  results?: Array<FieldCreateMetadata>;
  startAt?: number;
  total?: number;
};

export type PaginatedResponseIssueTypeIssueCreateMetadata = {
  maxResults?: number;
  results?: Array<IssueTypeIssueCreateMetadata>;
  startAt?: number;
  total?: number;
};

/**
 * A list of parsed JQL queries.
 */
export type ParsedJqlQueries = {
  /**
   * A list of parsed JQL queries.
   */
  queries: Array<ParsedJqlQuery>;
};

/**
 * Details of a parsed JQL query.
 */
export type ParsedJqlQuery = {
  /**
   * The list of syntax or validation errors.
   */
  errors?: Array<string>;
  /**
   * The JQL query that was parsed and validated.
   */
  query: string;
  /**
   * The syntax tree of the query. Empty if the query was invalid.
   */
  structure?: JqlQuery;
};

/**
 * Details for permissions of shareable entities
 */
export type PermissionDetails = {
  /**
   * The edit permissions for the shareable entities.
   */
  editPermissions: Array<SharePermission>;
  /**
   * The share permissions for the shareable entities.
   */
  sharePermissions: Array<SharePermission>;
};

/**
 * Details about a permission granted to a user or group.
 */
export type PermissionGrant = {
  /**
   * The user or group being granted the permission. It consists of a `type`, a type-dependent `parameter` and a type-dependent `value`. See [Holder object](../api-group-permission-schemes/#holder-object) in *Get all permission schemes* for more information.
   */
  holder?: PermissionHolder;
  /**
   * The ID of the permission granted details.
   */
  readonly id?: number;
  /**
   * The permission to grant. This permission can be one of the built-in permissions or a custom permission added by an app. See [Built-in permissions](../api-group-permission-schemes/#built-in-permissions) in *Get all permission schemes* for more information about the built-in permissions. See the [project permission](https://developer.atlassian.com/cloud/jira/platform/modules/project-permission/) and [global permission](https://developer.atlassian.com/cloud/jira/platform/modules/global-permission/) module documentation for more information about custom permissions.
   */
  permission?: string;
  /**
   * The URL of the permission granted details.
   */
  readonly self?: string;
};

/**
 * List of permission grants.
 */
export type PermissionGrants = {
  /**
   * Expand options that include additional permission grant details in the response.
   */
  readonly expand?: string;
  /**
   * Permission grants list.
   */
  readonly permissions?: Array<PermissionGrant>;
};

/**
 * Details of a user, group, field, or project role that holds a permission. See [Holder object](../api-group-permission-schemes/#holder-object) in *Get all permission schemes* for more information.
 */
export type PermissionHolder = {
  /**
   * Expand options that include additional permission holder details in the response.
   */
  readonly expand?: string;
  /**
   * As a group's name can change, use of `value` is recommended. The identifier associated withthe `type` value that defines the holder of the permission.
   */
  parameter?: string;
  /**
   * The type of permission holder.
   */
  type: string;
  /**
   * The identifier associated with the `type` value that defines the holder of the permission.
   */
  value?: string;
};

/**
 * Details of a permission scheme.
 */
export type PermissionScheme = {
  /**
   * A description for the permission scheme.
   */
  description?: string;
  /**
   * The expand options available for the permission scheme.
   */
  readonly expand?: string;
  /**
   * The ID of the permission scheme.
   */
  readonly id?: number;
  /**
   * The name of the permission scheme. Must be unique.
   */
  name: string;
  /**
   * The permission scheme to create or update. See [About permission schemes and grants](../api-group-permission-schemes/#about-permission-schemes-and-grants) for more information.
   */
  permissions?: Array<PermissionGrant>;
  /**
   * The scope of the permission scheme.
   */
  scope?: Scope;
  /**
   * The URL of the permission scheme.
   */
  readonly self?: string;
};

/**
 * List of all permission schemes.
 */
export type PermissionSchemes = {
  /**
   * Permission schemes list.
   */
  readonly permissionSchemes?: Array<PermissionScheme>;
};

/**
 * Details about permissions.
 */
export type Permissions = {
  /**
   * List of permissions.
   */
  readonly permissions?: {
    [key: string]: UserPermission;
  };
};

export type PermissionsKeysBean = {
  /**
   * A list of permission keys.
   */
  permissions: Array<string>;
};

/**
 * A list of projects in which a user is granted permissions.
 */
export type PermittedProjects = {
  /**
   * A list of projects.
   */
  readonly projects?: Array<ProjectIdentifierBean>;
};

/**
 * An issue priority.
 */
export type Priority = {
  /**
   * The avatarId of the avatar for the issue priority. This parameter is nullable and when set, this avatar references the universal avatar APIs.
   */
  avatarId?: number;
  /**
   * The description of the issue priority.
   */
  description?: string;
  /**
   * The URL of the icon for the issue priority.
   */
  iconUrl?: string;
  /**
   * The ID of the issue priority.
   */
  id?: string;
  /**
   * Whether this priority is the default.
   */
  isDefault?: boolean;
  /**
   * The name of the issue priority.
   */
  name?: string;
  /**
   * Priority schemes associated with the issue priority.
   */
  schemes?: ExpandPrioritySchemePage;
  /**
   * The URL of the issue priority.
   */
  self?: string;
  /**
   * The color used to indicate the issue priority.
   */
  statusColor?: string;
};

/**
 * The ID of an issue priority.
 */
export type PriorityId = {
  /**
   * The ID of the issue priority.
   */
  readonly id: string;
};

/**
 * Mapping of issue priorities for changes in priority schemes.
 */
export type PriorityMapping = {
  /**
   * The mapping of priorities for issues being migrated **into** this priority scheme. Key is the old priority ID, value is the new priority ID (must exist in this priority scheme).
   */
  in?: {
    [key: string]: number;
  };
  /**
   * The mapping of priorities for issues being migrated **out of** this priority scheme. Key is the old priority ID (must exist in this priority scheme), value is the new priority ID (must exist in the default priority scheme). Required for updating an existing priority scheme. Not used when creating a new priority scheme.
   */
  out?: {
    [key: string]: number;
  };
};

export type PrioritySchemeChangesWithMappings = {
  /**
   * Affected entity ids.
   */
  ids: Array<number>;
  /**
   * Instructions to migrate issues.
   */
  mappings?: Array<PriorityMapping>;
};

export type PrioritySchemeChangesWithoutMappings = {
  /**
   * Affected entity ids.
   */
  ids: Array<number>;
};

/**
 * The ID of a priority scheme.
 */
export type PrioritySchemeId = {
  /**
   * The ID of the priority scheme.
   */
  readonly id?: string;
  /**
   * The in-progress issue migration task.
   */
  readonly task?: TaskProgressBeanJsonNode;
};

/**
 * A priority scheme with paginated priorities and projects.
 */
export type PrioritySchemeWithPaginatedPrioritiesAndProjects = {
  default?: boolean;
  /**
   * The ID of the default issue priority.
   */
  defaultPriorityId?: string;
  /**
   * The description of the priority scheme
   */
  description?: string;
  /**
   * The ID of the priority scheme.
   */
  id: string;
  isDefault?: boolean;
  /**
   * The name of the priority scheme
   */
  name: string;
  /**
   * The paginated list of priorities.
   */
  priorities?: PageBeanPriorityWithSequence;
  /**
   * The paginated list of projects.
   */
  projects?: PageBeanProjectDetails;
  /**
   * The URL of the priority scheme.
   */
  self?: string;
};

/**
 * An issue priority with sequence information.
 */
export type PriorityWithSequence = {
  /**
   * The description of the issue priority.
   */
  description?: string;
  /**
   * The URL of the icon for the issue priority.
   */
  iconUrl?: string;
  /**
   * The ID of the issue priority.
   */
  id?: string;
  /**
   * Whether this priority is the default.
   */
  isDefault?: boolean;
  /**
   * The name of the issue priority.
   */
  name?: string;
  /**
   * The URL of the issue priority.
   */
  self?: string;
  /**
   * The sequence of the issue priority.
   */
  sequence?: string;
  /**
   * The color used to indicate the issue priority.
   */
  statusColor?: string;
};

/**
 * Details about a project.
 */
export type Project = {
  /**
   * Whether the project is archived.
   */
  readonly archived?: boolean;
  /**
   * The user who archived the project.
   */
  readonly archivedBy?: User;
  /**
   * The date when the project was archived.
   */
  readonly archivedDate?: string;
  /**
   * The default assignee when creating issues for this project.
   */
  readonly assigneeType?: 'PROJECT_LEAD' | 'UNASSIGNED';
  /**
   * The URLs of the project's avatars.
   */
  readonly avatarUrls?: AvatarUrlsBean;
  /**
   * List of the components contained in the project.
   */
  readonly components?: Array<ProjectComponent>;
  /**
   * Whether the project is marked as deleted.
   */
  readonly deleted?: boolean;
  /**
   * The user who marked the project as deleted.
   */
  readonly deletedBy?: User;
  /**
   * The date when the project was marked as deleted.
   */
  readonly deletedDate?: string;
  /**
   * A brief description of the project.
   */
  readonly description?: string;
  /**
   * An email address associated with the project.
   */
  email?: string;
  /**
   * Expand options that include additional project details in the response.
   */
  readonly expand?: string;
  /**
   * Whether the project is selected as a favorite.
   */
  favourite?: boolean;
  /**
   * The ID of the project.
   */
  id?: string;
  /**
   * Insights about the project.
   */
  readonly insight?: ProjectInsight;
  /**
   * Whether the project is private from the user's perspective. This means the user can't see the project or any associated issues.
   */
  readonly isPrivate?: boolean;
  /**
   * The issue type hierarchy for the project.
   */
  readonly issueTypeHierarchy?: Hierarchy;
  /**
   * List of the issue types available in the project.
   */
  readonly issueTypes?: Array<IssueTypeDetails>;
  /**
   * The key of the project.
   */
  readonly key?: string;
  /**
   * The project landing page info.
   */
  readonly landingPageInfo?: ProjectLandingPageInfo;
  /**
   * The username of the project lead.
   */
  readonly lead?: User;
  /**
   * The name of the project.
   */
  readonly name?: string;
  /**
   * User permissions on the project
   */
  readonly permissions?: ProjectPermissions;
  /**
   * The category the project belongs to.
   */
  readonly projectCategory?: ProjectCategory;
  /**
   * The [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes) of the project.
   */
  readonly projectTypeKey?: 'software' | 'service_desk' | 'business';
  /**
   * Map of project properties
   */
  readonly properties?: {
    [key: string]: string;
  };
  /**
   * The date when the project is deleted permanently.
   */
  readonly retentionTillDate?: string;
  /**
   * The name and self URL for each role defined in the project. For more information, see [Create project role](#api-rest-api-3-role-post).
   */
  readonly roles?: {
    [key: string]: string;
  };
  /**
   * The URL of the project details.
   */
  readonly self?: string;
  /**
   * Whether the project is simplified.
   */
  readonly simplified?: boolean;
  /**
   * The type of the project.
   */
  readonly style?: 'classic' | 'next-gen';
  /**
   * A link to information about this project, such as project documentation.
   */
  readonly url?: string;
  /**
   * Unique ID for next-gen projects.
   */
  readonly uuid?: string;
  /**
   * The versions defined in the project. For more information, see [Create version](#api-rest-api-3-version-post).
   */
  readonly versions?: Array<Version>;
};

/**
 * The type of the project.
 */
export type style = 'classic' | 'next-gen';

/**
 * A project and issueType ID pair that identifies a status mapping.
 */
export type ProjectAndIssueTypePair = {
  /**
   * The ID of the issue type.
   */
  issueTypeId: string;
  /**
   * The ID of the project.
   */
  projectId: string;
};

/**
 * List of project avatars.
 */
export type ProjectAvatars = {
  /**
   * List of avatars added to Jira. These avatars may be deleted.
   */
  readonly custom?: Array<Avatar>;
  /**
   * List of avatars included with Jira. These avatars cannot be deleted.
   */
  readonly system?: Array<Avatar>;
};

/**
 * A project category.
 */
export type ProjectCategory = {
  /**
   * The description of the project category.
   */
  description?: string;
  /**
   * The ID of the project category.
   */
  readonly id?: string;
  /**
   * The name of the project category. Required on create, optional on update.
   */
  name?: string;
  /**
   * The URL of the project category.
   */
  readonly self?: string;
};

/**
 * Details about a project component.
 */
export type ProjectComponent = {
  /**
   * Compass component's ID. Can't be updated. Not required for creating a Project Component.
   */
  readonly ari?: string;
  /**
   * The details of the user associated with `assigneeType`, if any. See `realAssignee` for details of the user assigned to issues created with this component.
   */
  readonly assignee?: User;
  /**
   * The nominal user type used to determine the assignee for issues created with this component. See `realAssigneeType` for details on how the type of the user, and hence the user, assigned to issues is determined. Can take the following values:
   *
   * *  `PROJECT_LEAD` the assignee to any issues created with this component is nominally the lead for the project the component is in.
   * *  `COMPONENT_LEAD` the assignee to any issues created with this component is nominally the lead for the component.
   * *  `UNASSIGNED` an assignee is not set for issues created with this component.
   * *  `PROJECT_DEFAULT` the assignee to any issues created with this component is nominally the default assignee for the project that the component is in.
   *
   * Default value: `PROJECT_DEFAULT`.
   * Optional when creating or updating a component.
   */
  assigneeType?: 'PROJECT_DEFAULT' | 'COMPONENT_LEAD' | 'PROJECT_LEAD' | 'UNASSIGNED';
  /**
   * The description for the component. Optional when creating or updating a component.
   */
  description?: string;
  /**
   * The unique identifier for the component.
   */
  readonly id?: string;
  /**
   * Whether a user is associated with `assigneeType`. For example, if the `assigneeType` is set to `COMPONENT_LEAD` but the component lead is not set, then `false` is returned.
   */
  readonly isAssigneeTypeValid?: boolean;
  /**
   * The user details for the component's lead user.
   */
  readonly lead?: User;
  /**
   * The accountId of the component's lead user. The accountId uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.
   */
  leadAccountId?: string;
  /**
   * This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
   */
  leadUserName?: string;
  /**
   * Compass component's metadata. Can't be updated. Not required for creating a Project Component.
   */
  readonly metadata?: {
    [key: string]: string;
  };
  /**
   * The unique name for the component in the project. Required when creating a component. Optional when updating a component. The maximum length is 255 characters.
   */
  name?: string;
  /**
   * The key of the project the component is assigned to. Required when creating a component. Can't be updated.
   */
  project?: string;
  /**
   * The ID of the project the component is assigned to.
   */
  readonly projectId?: number;
  /**
   * The user assigned to issues created with this component, when `assigneeType` does not identify a valid assignee.
   */
  readonly realAssignee?: User;
  /**
   * The type of the assignee that is assigned to issues created with this component, when an assignee cannot be set from the `assigneeType`. For example, `assigneeType` is set to `COMPONENT_LEAD` but no component lead is set. This property is set to one of the following values:
   *
   * *  `PROJECT_LEAD` when `assigneeType` is `PROJECT_LEAD` and the project lead has permission to be assigned issues in the project that the component is in.
   * *  `COMPONENT_LEAD` when `assignee`Type is `COMPONENT_LEAD` and the component lead has permission to be assigned issues in the project that the component is in.
   * *  `UNASSIGNED` when `assigneeType` is `UNASSIGNED` and Jira is configured to allow unassigned issues.
   * *  `PROJECT_DEFAULT` when none of the preceding cases are true.
   */
  readonly realAssigneeType?: 'PROJECT_DEFAULT' | 'COMPONENT_LEAD' | 'PROJECT_LEAD' | 'UNASSIGNED';
  /**
   * The URL of the component.
   */
  readonly self?: string;
};

/**
 * Details about data policies for a list of projects.
 */
export type ProjectDataPolicies = {
  /**
   * List of projects with data policies.
   */
  readonly projectDataPolicies?: Array<ProjectWithDataPolicy>;
};

/**
 * Details about data policy.
 */
export type ProjectDataPolicy = {
  /**
   * Whether the project contains any content inaccessible to the requesting application.
   */
  readonly anyContentBlocked?: boolean;
};

/**
 * Details about a project.
 */
export type ProjectDetails = {
  /**
   * The URLs of the project's avatars.
   */
  readonly avatarUrls?: AvatarUrlsBean;
  /**
   * The ID of the project.
   */
  id?: string;
  /**
   * The key of the project.
   */
  readonly key?: string;
  /**
   * The name of the project.
   */
  readonly name?: string;
  /**
   * The category the project belongs to.
   */
  readonly projectCategory?: UpdatedProjectCategory;
  /**
   * The [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes) of the project.
   */
  readonly projectTypeKey?: 'software' | 'service_desk' | 'business';
  /**
   * The URL of the project details.
   */
  readonly self?: string;
  /**
   * Whether or not the project is simplified.
   */
  readonly simplified?: boolean;
};

/**
 * A project's sender email address.
 */
export type ProjectEmailAddress = {
  /**
   * The email address.
   */
  emailAddress?: string;
  /**
   * When using a custom domain, the status of the email address.
   */
  emailAddressStatus?: Array<string>;
};

/**
 * Details of a project feature.
 */
export type ProjectFeature = {
  /**
   * The key of the feature.
   */
  feature?: string;
  /**
   * URI for the image representing the feature.
   */
  imageUri?: string;
  /**
   * Localized display description for the feature.
   */
  localisedDescription?: string;
  /**
   * Localized display name for the feature.
   */
  localisedName?: string;
  /**
   * List of keys of the features required to enable the feature.
   */
  prerequisites?: Array<string>;
  /**
   * The ID of the project.
   */
  projectId?: number;
  /**
   * The state of the feature. When updating the state of a feature, only ENABLED and DISABLED are supported. Responses can contain all values
   */
  state?: 'ENABLED' | 'DISABLED' | 'COMING_SOON';
  /**
   * Whether the state of the feature can be updated.
   */
  toggleLocked?: boolean;
};

/**
 * The state of the feature. When updating the state of a feature, only ENABLED and DISABLED are supported. Responses can contain all values
 */
export type state = 'ENABLED' | 'DISABLED' | 'COMING_SOON';

/**
 * Details of the feature state.
 */
export type ProjectFeatureState = {
  /**
   * The feature state.
   */
  state?: 'ENABLED' | 'DISABLED' | 'COMING_SOON';
};

/**
 * Project ID details.
 */
export type ProjectId = {
  /**
   * The ID of the project.
   */
  id: string;
} | null;

/**
 * The identifiers for a project.
 */
export type ProjectIdentifierBean = {
  /**
   * The ID of the project.
   */
  readonly id?: number;
  /**
   * The key of the project.
   */
  readonly key?: string;
};

/**
 * Identifiers for a project.
 */
export type ProjectIdentifiers = {
  /**
   * The ID of the created project.
   */
  readonly id: number;
  /**
   * The key of the created project.
   */
  readonly key: string;
  /**
   * The URL of the created project.
   */
  readonly self: string;
};

/**
 * A list of project IDs.
 */
export type ProjectIds = {
  /**
   * The IDs of projects.
   */
  projectIds: Array<string>;
};

/**
 * Additional details about a project.
 */
export type ProjectInsight = {
  /**
   * The last issue update time.
   */
  readonly lastIssueUpdateTime?: string;
  /**
   * Total issue count.
   */
  readonly totalIssueCount?: number;
};

/**
 * Details of the issue creation metadata for a project.
 */
export type ProjectIssueCreateMetadata = {
  /**
   * List of the project's avatars, returning the avatar size and associated URL.
   */
  readonly avatarUrls?: AvatarUrlsBean;
  /**
   * Expand options that include additional project issue create metadata details in the response.
   */
  readonly expand?: string;
  /**
   * The ID of the project.
   */
  readonly id?: string;
  /**
   * List of the issue types supported by the project.
   */
  readonly issuetypes?: Array<IssueTypeIssueCreateMetadata>;
  /**
   * The key of the project.
   */
  readonly key?: string;
  /**
   * The name of the project.
   */
  readonly name?: string;
  /**
   * The URL of the project.
   */
  readonly self?: string;
};

/**
 * List of issue level security items in a project.
 */
export type ProjectIssueSecurityLevels = {
  /**
   * Issue level security items list.
   */
  readonly levels: Array<SecurityLevel>;
};

/**
 * The hierarchy of issue types within a project.
 */
export type ProjectIssueTypeHierarchy = {
  /**
   * Details of an issue type hierarchy level.
   */
  readonly hierarchy?: Array<ProjectIssueTypesHierarchyLevel>;
  /**
   * The ID of the project.
   */
  readonly projectId?: number;
};

/**
 * The project and issue type mapping.
 */
export type ProjectIssueTypeMapping = {
  /**
   * The ID of the issue type.
   */
  issueTypeId: string;
  /**
   * The ID of the project.
   */
  projectId: string;
};

/**
 * The project and issue type mappings.
 */
export type ProjectIssueTypeMappings = {
  /**
   * The project and issue type mappings.
   */
  mappings: Array<ProjectIssueTypeMapping>;
};

/**
 * Use the optional `workflows.usages` expand to get additional information about the projects and issue types associated with the requested workflows.
 */
export type ProjectIssueTypes = {
  /**
   * IDs of the issue types
   */
  issueTypes?: Array<string | null> | null;
  project?: ProjectId;
};

/**
 * Details of an issue type hierarchy level.
 */
export type ProjectIssueTypesHierarchyLevel = {
  /**
   * The ID of the issue type hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   */
  readonly entityId?: string;
  /**
   * The list of issue types in the hierarchy level.
   */
  readonly issueTypes?: Array<IssueTypeInfo>;
  /**
   * The level of the issue type hierarchy level.
   */
  readonly level?: number;
  /**
   * The name of the issue type hierarchy level.
   */
  readonly name?: string;
};

export type ProjectLandingPageInfo = {
  attributes?: {
    [key: string]: string;
  };
  boardId?: number;
  boardName?: string;
  projectKey?: string;
  projectType?: string;
  queueCategory?: string;
  queueId?: number;
  queueName?: string;
  simpleBoard?: boolean;
  simplified?: boolean;
  url?: string;
};

/**
 * Permissions which a user has on a project.
 */
export type ProjectPermissions = {
  /**
   * Whether the logged user can edit the project.
   */
  readonly canEdit?: boolean;
};

/**
 * Details about the roles in a project.
 */
export type ProjectRole = {
  /**
   * The list of users who act in this role.
   */
  readonly actors?: Array<RoleActor>;
  /**
   * Whether this role is the admin role for the project.
   */
  readonly admin?: boolean;
  /**
   * Whether the calling user is part of this role.
   */
  currentUserRole?: boolean;
  /**
   * Whether this role is the default role for the project
   */
  readonly default?: boolean;
  /**
   * The description of the project role.
   */
  readonly description?: string;
  /**
   * The ID of the project role.
   */
  readonly id?: number;
  /**
   * The name of the project role.
   */
  name?: string;
  /**
   * Whether the roles are configurable for this project.
   */
  readonly roleConfigurable?: boolean;
  /**
   * The scope of the role. Indicated for roles associated with [next-gen projects](https://confluence.atlassian.com/x/loMyO).
   */
  readonly scope?: Scope;
  /**
   * The URL the project role details.
   */
  readonly self?: string;
  /**
   * The translated name of the project role.
   */
  translatedName?: string;
};

export type ProjectRoleActorsUpdateBean = {
  /**
   * The actors to add to the project role.
   *
   * Add groups using:
   *
   * *  `atlassian-group-role-actor` and a list of group names.
   * *  `atlassian-group-role-actor-id` and a list of group IDs.
   *
   * As a group's name can change, use of `atlassian-group-role-actor-id` is recommended. For example, `"atlassian-group-role-actor-id":["eef79f81-0b89-4fca-a736-4be531a10869","77f6ab39-e755-4570-a6ae-2d7a8df0bcb8"]`.
   *
   * Add users using `atlassian-user-role-actor` and a list of account IDs. For example, `"atlassian-user-role-actor":["12345678-9abc-def1-2345-6789abcdef12", "abcdef12-3456-789a-bcde-f123456789ab"]`.
   */
  categorisedActors?: {
    [key: string]: Array<string>;
  };
  /**
   * The ID of the project role. Use [Get all project roles](#api-rest-api-3-role-get) to get a list of project role IDs.
   */
  readonly id?: number;
};

/**
 * Details about a project role.
 */
export type ProjectRoleDetails = {
  /**
   * Whether this role is the admin role for the project.
   */
  readonly admin?: boolean;
  /**
   * Whether this role is the default role for the project.
   */
  readonly default?: boolean;
  /**
   * The description of the project role.
   */
  readonly description?: string;
  /**
   * The ID of the project role.
   */
  readonly id?: number;
  /**
   * The name of the project role.
   */
  name?: string;
  /**
   * Whether the roles are configurable for this project.
   */
  readonly roleConfigurable?: boolean;
  /**
   * The scope of the role. Indicated for roles associated with [next-gen projects](https://confluence.atlassian.com/x/loMyO).
   */
  readonly scope?: Scope;
  /**
   * The URL the project role details.
   */
  readonly self?: string;
  /**
   * The translated name of the project role.
   */
  translatedName?: string;
};

/**
 * Details of the group associated with the role.
 */
export type ProjectRoleGroup = {
  /**
   * The display name of the group.
   */
  displayName?: string;
  /**
   * The ID of the group.
   */
  groupId?: string;
  /**
   * The name of the group. As a group's name can change, use of `groupId` is recommended to identify the group.
   */
  name?: string;
};

/**
 * Details of the user associated with the role.
 */
export type ProjectRoleUser = {
  /**
   * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*. Returns *unknown* if the record is deleted and corrupted, for example, as the result of a server import.
   */
  readonly accountId?: string;
};

export type ProjectScopeBean = {
  /**
   * Defines the behavior of the option in the project.If notSelectable is set, the option cannot be set as the field's value. This is useful for archiving an option that has previously been selected but shouldn't be used anymore.If defaultValue is set, the option is selected by default.
   */
  attributes?: Array<'notSelectable' | 'defaultValue'>;
  /**
   * The ID of the project that the option's behavior applies to.
   */
  id?: number;
};

/**
 * Details about a project type.
 */
export type ProjectType = {
  /**
   * The color of the project type.
   */
  readonly color?: string;
  /**
   * The key of the project type's description.
   */
  readonly descriptionI18nKey?: string;
  /**
   * The formatted key of the project type.
   */
  readonly formattedKey?: string;
  /**
   * The icon of the project type.
   */
  readonly icon?: string;
  /**
   * The key of the project type.
   */
  readonly key?: string;
};

/**
 * Details about data policies for a project.
 */
export type ProjectWithDataPolicy = {
  /**
   * Data policy.
   */
  readonly dataPolicy?: ProjectDataPolicy;
  /**
   * The project ID.
   */
  readonly id?: number;
};

/**
 * Property key details.
 */
export type PropertyKey = {
  /**
   * The key of the property.
   */
  readonly key?: string;
  /**
   * The URL of the property.
   */
  readonly self?: string;
};

/**
 * List of property keys.
 */
export type PropertyKeys = {
  /**
   * Property key details.
   */
  readonly keys?: Array<PropertyKey>;
};

/**
 * Details about the status mappings for publishing a draft workflow scheme.
 */
export type PublishDraftWorkflowScheme = {
  /**
   * Mappings of statuses to new statuses for issue types.
   */
  statusMappings?: Array<StatusMapping>;
};

/**
 * Properties that identify a published workflow.
 */
export type PublishedWorkflowId = {
  /**
   * The entity ID of the workflow.
   */
  entityId?: string;
  /**
   * The name of the workflow.
   */
  name: string;
};

/**
 * ID of a registered webhook or error messages explaining why a webhook wasn't registered.
 */
export type RegisteredWebhook = {
  /**
   * The ID of the webhook. Returned if the webhook is created.
   */
  createdWebhookId?: number;
  /**
   * Error messages specifying why the webhook creation failed.
   */
  errors?: Array<string>;
};

/**
 * Details of an issue remote link.
 */
export type RemoteIssueLink = {
  /**
   * Details of the remote application the linked item is in.
   */
  application?: Application;
  /**
   * The global ID of the link, such as the ID of the item on the remote system.
   */
  globalId?: string;
  /**
   * The ID of the link.
   */
  id?: number;
  /**
   * Details of the item linked to.
   */
  object?: RemoteObject;
  /**
   * Description of the relationship between the issue and the linked item.
   */
  relationship?: string;
  /**
   * The URL of the link.
   */
  self?: string;
};

/**
 * Details of the identifiers for a created or updated remote issue link.
 */
export type RemoteIssueLinkIdentifies = {
  /**
   * The ID of the remote issue link, such as the ID of the item on the remote system.
   */
  readonly id?: number;
  /**
   * The URL of the remote issue link.
   */
  readonly self?: string;
};

/**
 * Details of a remote issue link.
 */
export type RemoteIssueLinkRequest = {
  /**
   * Details of the remote application the linked item is in. For example, trello.
   */
  application?: Application;
  /**
   * An identifier for the remote item in the remote system. For example, the global ID for a remote item in Confluence would consist of the app ID and page ID, like this: `appId=456&pageId=123`.
   *
   * Setting this field enables the remote issue link details to be updated or deleted using remote system and item details as the record identifier, rather than using the record's Jira ID.
   *
   * The maximum length is 255 characters.
   */
  globalId?: string;
  /**
   * Details of the item linked to.
   */
  object: RemoteObject;
  /**
   * Description of the relationship between the issue and the linked item. If not set, the relationship description "links to" is used in Jira.
   */
  relationship?: string;
};

/**
 * The linked item.
 */
export type RemoteObject = {
  /**
   * Details of the icon for the item. If no icon is defined, the default link icon is used in Jira.
   */
  icon?: Icon;
  /**
   * The status of the item.
   */
  status?: Status;
  /**
   * The summary details of the item.
   */
  summary?: string;
  /**
   * The title of the item.
   */
  title: string;
  /**
   * The URL of the item.
   */
  url: string;
};

export type RemoveOptionFromIssuesResult = {
  /**
   * A collection of errors related to unchanged issues. The collection size is limited, which means not all errors may be returned.
   */
  errors?: SimpleErrorCollection;
  /**
   * The IDs of the modified issues.
   */
  modifiedIssues?: Array<number>;
  /**
   * The IDs of the unchanged issues, those issues where errors prevent modification.
   */
  unmodifiedIssues?: Array<number>;
};

/**
 * Change the order of issue priorities.
 */
export type ReorderIssuePriorities = {
  /**
   * The ID of the priority. Required if `position` isn't provided.
   */
  after?: string;
  /**
   * The list of issue IDs to be reordered. Cannot contain duplicates nor after ID.
   */
  ids: Array<string>;
  /**
   * The position for issue priorities to be moved to. Required if `after` isn't provided.
   */
  position?: string;
};

/**
 * Change the order of issue resolutions.
 */
export type ReorderIssueResolutionsRequest = {
  /**
   * The ID of the resolution. Required if `position` isn't provided.
   */
  after?: string;
  /**
   * The list of resolution IDs to be reordered. Cannot contain duplicates nor after ID.
   */
  ids: Array<string>;
  /**
   * The position for issue resolutions to be moved to. Required if `after` isn't provided.
   */
  position?: string;
};

/**
 * The list of required status mappings by issue type.
 */
export type RequiredMappingByIssueType = {
  /**
   * The ID of the issue type.
   */
  issueTypeId?: string;
  /**
   * The status IDs requiring mapping.
   */
  statusIds?: Array<string>;
};

/**
 * The list of required status mappings by workflow.
 */
export type RequiredMappingByWorkflows = {
  /**
   * The ID of the source workflow.
   */
  sourceWorkflowId?: string;
  /**
   * The status IDs requiring mapping.
   */
  statusIds?: Array<string>;
  /**
   * The ID of the target workflow.
   */
  targetWorkflowId?: string;
};

/**
 * Details of an issue resolution.
 */
export type Resolution = {
  /**
   * The description of the issue resolution.
   */
  description?: string;
  /**
   * The ID of the issue resolution.
   */
  id?: string;
  /**
   * The name of the issue resolution.
   */
  name?: string;
  /**
   * The URL of the issue resolution.
   */
  self?: string;
};

/**
 * The ID of an issue resolution.
 */
export type ResolutionId = {
  /**
   * The ID of the issue resolution.
   */
  readonly id: string;
};

export type ResolutionJsonBean = {
  default?: boolean;
  description?: string;
  iconUrl?: string;
  id?: string;
  name?: string;
  self?: string;
};

export type Resource = {
  description?: string;
  file?: Blob | File;
  filename?: string;
  inputStream?: {
    [key: string]: string;
  };
  open?: boolean;
  readable?: boolean;
  uri?: string;
  url?: string;
};

/**
 * Details of the permission.
 */
export type RestrictedPermission = {
  /**
   * The ID of the permission. Either `id` or `key` must be specified. Use [Get all permissions](#api-rest-api-3-permissions-get) to get the list of permissions.
   */
  id?: string;
  /**
   * The key of the permission. Either `id` or `key` must be specified. Use [Get all permissions](#api-rest-api-3-permissions-get) to get the list of permissions.
   */
  key?: string;
};

export type RichText = {
  empty?: boolean;
  emptyAdf?: boolean;
  finalised?: boolean;
  valueSet?: boolean;
};

/**
 * Details about a user assigned to a project role.
 */
export type RoleActor = {
  readonly actorGroup?: ProjectRoleGroup;
  readonly actorUser?: ProjectRoleUser;
  /**
   * The avatar of the role actor.
   */
  readonly avatarUrl?: string;
  /**
   * The display name of the role actor. For users, depending on the user’s privacy setting, this may return an alternative value for the user's name.
   */
  readonly displayName?: string;
  /**
   * The ID of the role actor.
   */
  readonly id?: number;
  /**
   * This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
   */
  readonly name?: string;
  /**
   * The type of role actor.
   */
  readonly type?: 'atlassian-group-role-actor' | 'atlassian-user-role-actor';
};

/**
 * The type of role actor.
 */
export type type8 = 'atlassian-group-role-actor' | 'atlassian-user-role-actor';

/**
 * A rule configuration.
 */
export type RuleConfiguration = {
  /**
   * Whether the rule is disabled.
   */
  disabled?: boolean;
  /**
   * A tag used to filter rules in [Get workflow transition rule configurations](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-workflow-transition-rules/#api-rest-api-3-workflow-rule-config-get).
   */
  tag?: string;
  /**
   * Configuration of the rule, as it is stored by the Connect or the Forge app on the rule configuration page.
   */
  value: string;
};

/**
 * The sanitized JQL queries for the given account IDs.
 */
export type SanitizedJqlQueries = {
  /**
   * The list of sanitized JQL queries.
   */
  queries?: Array<SanitizedJqlQuery>;
};

/**
 * Details of the sanitized JQL query.
 */
export type SanitizedJqlQuery = {
  /**
   * The account ID of the user for whom sanitization was performed.
   */
  accountId?: string | null;
  /**
   * The list of errors.
   */
  errors?: ErrorCollection;
  /**
   * The initial query.
   */
  initialQuery?: string;
  /**
   * The sanitized query, if there were no errors.
   */
  sanitizedQuery?: string | null;
};

/**
 * The projects the item is associated with. Indicated for items associated with [next-gen projects](https://confluence.atlassian.com/x/loMyO).
 */
export type Scope = {
  /**
   * The project the item has scope in.
   */
  readonly project?: ProjectDetails;
  /**
   * The type of scope.
   */
  readonly type?: 'PROJECT' | 'TEMPLATE';
};

/**
 * The type of scope.
 */
export type type9 = 'PROJECT' | 'TEMPLATE';

/**
 * A screen.
 */
export type Screen = {
  /**
   * The description of the screen.
   */
  readonly description?: string;
  /**
   * The ID of the screen.
   */
  readonly id?: number;
  /**
   * The name of the screen.
   */
  readonly name?: string;
  /**
   * The scope of the screen.
   */
  scope?: Scope;
};

/**
 * Details of a screen.
 */
export type ScreenDetails = {
  /**
   * The description of the screen. The maximum length is 255 characters.
   */
  description?: string;
  /**
   * The name of the screen. The name must be unique. The maximum length is 255 characters.
   */
  name: string;
};

/**
 * A screen scheme.
 */
export type ScreenScheme = {
  /**
   * The description of the screen scheme.
   */
  description?: string;
  /**
   * The ID of the screen scheme.
   */
  id?: number;
  /**
   * Details of the issue type screen schemes associated with the screen scheme.
   */
  issueTypeScreenSchemes?: PageBeanIssueTypeScreenScheme;
  /**
   * The name of the screen scheme.
   */
  name?: string;
  /**
   * The IDs of the screens for the screen types of the screen scheme.
   */
  screens?: ScreenTypes;
};

/**
 * Details of a screen scheme.
 */
export type ScreenSchemeDetails = {
  /**
   * The description of the screen scheme. The maximum length is 255 characters.
   */
  description?: string;
  /**
   * The name of the screen scheme. The name must be unique. The maximum length is 255 characters.
   */
  name: string;
  /**
   * The IDs of the screens for the screen types of the screen scheme. Only screens used in classic projects are accepted.
   */
  screens: ScreenTypes;
};

/**
 * The ID of a screen scheme.
 */
export type ScreenSchemeId = {
  /**
   * The ID of the screen scheme.
   */
  readonly id: number;
};

/**
 * The IDs of the screens for the screen types of the screen scheme.
 */
export type ScreenTypes = {
  /**
   * The ID of the create screen.
   */
  create?: number;
  /**
   * The ID of the default screen. Required when creating a screen scheme.
   */
  default: number;
  /**
   * The ID of the edit screen.
   */
  edit?: number;
  /**
   * The ID of the view screen.
   */
  view?: number;
};

/**
 * A screen with tab details.
 */
export type ScreenWithTab = {
  /**
   * The description of the screen.
   */
  readonly description?: string;
  /**
   * The ID of the screen.
   */
  readonly id?: number;
  /**
   * The name of the screen.
   */
  readonly name?: string;
  /**
   * The scope of the screen.
   */
  scope?: Scope;
  /**
   * The tab for the screen.
   */
  tab?: ScreenableTab;
};

/**
 * A screen tab field.
 */
export type ScreenableField = {
  /**
   * The ID of the screen tab field.
   */
  readonly id?: string;
  /**
   * The name of the screen tab field. Required on create and update. The maximum length is 255 characters.
   */
  name?: string;
};

/**
 * A screen tab.
 */
export type ScreenableTab = {
  /**
   * The ID of the screen tab.
   */
  readonly id?: number;
  /**
   * The name of the screen tab. The maximum length is 255 characters.
   */
  name: string;
};

export type SearchAndReconcileRequestBean = {
  /**
   * Use [expand](em>#expansion) to include additional information about issues in the response. Note that, unlike the majority of instances where `expand` is specified, `expand` is defined as a list of values. The expand options are:
   *
   * *  `renderedFields` Returns field values rendered in HTML format.
   * *  `names` Returns the display name of each field.
   * *  `schema` Returns the schema describing a field type.
   * *  `changelog` Returns a list of recent updates to an issue, sorted by date, starting from the most recent.
   */
  expand?: string;
  /**
   * A list of fields to return for each issue. Use it to retrieve a subset of fields. This parameter accepts a comma-separated list. Expand options include:
   *
   * *  `*all` Returns all fields.
   * *  `*navigable` Returns navigable fields.
   * *  `id` Returns only issue IDs.
   * *  Any issue field, prefixed with a dash to exclude.
   *
   * The default is `id`.
   *
   * Examples:
   *
   * *  `summary,comment` Returns the summary and comments fields only.
   * *  `*all,-comment` Returns all fields except comments.
   *
   * Multiple `fields` parameters can be included in a request.
   *
   * Note: By default, this resource returns IDs only. This differs from [GET issue](#api-rest-api-3-issue-issueIdOrKey-get) where the default is all fields.
   */
  fields?: Array<string>;
  /**
   * Reference fields by their key (rather than ID). The default is `false`.
   */
  fieldsByKeys?: boolean;
  /**
   * A [JQL](https://confluence.atlassian.com/x/egORLQ) expression. For performance reasons, this field requires a bounded query. A bounded query is a query with a search restriction.
   *
   * *  Example of an unbounded query: `order by key desc`.
   * *  Example of a bounded query: `assignee = currentUser() order by key`.
   */
  jql?: string;
  /**
   * The maximum number of items to return. Depending on search criteria, real number of items returned may be smaller.
   */
  maxResults?: number;
  /**
   * The continuation token to fetch the next page. This token is provided by the response of this endpoint.
   */
  nextPageToken?: string;
  /**
   * A list of up to 5 issue properties to include in the results. This parameter accepts a comma-separated list.
   */
  properties?: Array<string>;
  /**
   * Strong consistency issue ids to be reconciled with search results. Accepts max 50 ids. All issues must exist.
   */
  reconcileIssues?: Array<number>;
};

/**
 * The result of a JQL search with issues reconsilation.
 */
export type SearchAndReconcileResults = {
  /**
   * The list of issues found by the search or reconsiliation.
   */
  readonly issues?: Array<IssueBean>;
  /**
   * The ID and name of each field in the search results.
   */
  readonly names?: {
    [key: string]: string;
  };
  /**
   * Continuation token to fetch the next page. If this result represents the last or the only page this token will be null. This token will expire in 7 days.
   */
  readonly nextPageToken?: string;
  /**
   * The schema describing the field types in the search results.
   */
  readonly schema?: {
    [key: string]: JsonTypeBean;
  };
};

/**
 * Details of how to filter and list search auto complete information.
 */
export type SearchAutoCompleteFilter = {
  /**
   * Include collapsed fields for fields that have non-unique names.
   */
  includeCollapsedFields?: boolean;
  /**
   * List of project IDs used to filter the visible field details returned.
   */
  projectIds?: Array<number>;
};

export type SearchRequestBean = {
  /**
   * Use [expand](em>#expansion) to include additional information about issues in the response. Note that, unlike the majority of instances where `expand` is specified, `expand` is defined as a list of values. The expand options are:
   *
   * *  `renderedFields` Returns field values rendered in HTML format.
   * *  `names` Returns the display name of each field.
   * *  `schema` Returns the schema describing a field type.
   * *  `transitions` Returns all possible transitions for the issue.
   * *  `operations` Returns all possible operations for the issue.
   * *  `editmeta` Returns information about how each field can be edited.
   * *  `changelog` Returns a list of recent updates to an issue, sorted by date, starting from the most recent.
   * *  `versionedRepresentations` Instead of `fields`, returns `versionedRepresentations` a JSON array containing each version of a field's value, with the highest numbered item representing the most recent version.
   */
  expand?: Array<string>;
  /**
   * A list of fields to return for each issue, use it to retrieve a subset of fields. This parameter accepts a comma-separated list. Expand options include:
   *
   * *  `*all` Returns all fields.
   * *  `*navigable` Returns navigable fields.
   * *  Any issue field, prefixed with a minus to exclude.
   *
   * The default is `*navigable`.
   *
   * Examples:
   *
   * *  `summary,comment` Returns the summary and comments fields only.
   * *  `-description` Returns all navigable (default) fields except description.
   * *  `*all,-comment` Returns all fields except comments.
   *
   * Multiple `fields` parameters can be included in a request.
   *
   * Note: All navigable fields are returned by default. This differs from [GET issue](#api-rest-api-3-issue-issueIdOrKey-get) where the default is all fields.
   */
  fields?: Array<string>;
  /**
   * Reference fields by their key (rather than ID). The default is `false`.
   */
  fieldsByKeys?: boolean;
  /**
   * A [JQL](https://confluence.atlassian.com/x/egORLQ) expression.
   */
  jql?: string;
  /**
   * The maximum number of items to return per page.
   */
  maxResults?: number;
  /**
   * A list of up to 5 issue properties to include in the results. This parameter accepts a comma-separated list.
   */
  properties?: Array<string>;
  /**
   * The index of the first item to return in the page of results (page offset). The base index is `0`.
   */
  startAt?: number;
  /**
   * Determines how to validate the JQL query and treat the validation results. Supported values:
   *
   * *  `strict` Returns a 400 response code if any errors are found, along with a list of all errors (and warnings).
   * *  `warn` Returns all errors as warnings.
   * *  `none` No validation is performed.
   * *  `true` *Deprecated* A legacy synonym for `strict`.
   * *  `false` *Deprecated* A legacy synonym for `warn`.
   *
   * The default is `strict`.
   *
   * Note: If the JQL is not correctly formed a 400 response code is returned, regardless of the `validateQuery` value.
   */
  validateQuery?: 'strict' | 'warn' | 'none' | 'true' | 'false';
};

/**
 * Determines how to validate the JQL query and treat the validation results. Supported values:
 *
 * *  `strict` Returns a 400 response code if any errors are found, along with a list of all errors (and warnings).
 * *  `warn` Returns all errors as warnings.
 * *  `none` No validation is performed.
 * *  `true` *Deprecated* A legacy synonym for `strict`.
 * *  `false` *Deprecated* A legacy synonym for `warn`.
 *
 * The default is `strict`.
 *
 * Note: If the JQL is not correctly formed a 400 response code is returned, regardless of the `validateQuery` value.
 */
export type validateQuery = 'strict' | 'warn' | 'none' | 'true' | 'false';

/**
 * The result of a JQL search.
 */
export type SearchResults = {
  /**
   * Expand options that include additional search result details in the response.
   */
  readonly expand?: string;
  /**
   * The list of issues found by the search.
   */
  readonly issues?: Array<IssueBean>;
  /**
   * The maximum number of results that could be on the page.
   */
  readonly maxResults?: number;
  /**
   * The ID and name of each field in the search results.
   */
  readonly names?: {
    [key: string]: string;
  };
  /**
   * The schema describing the field types in the search results.
   */
  readonly schema?: {
    [key: string]: JsonTypeBean;
  };
  /**
   * The index of the first item returned on the page.
   */
  readonly startAt?: number;
  /**
   * The number of results on the page.
   */
  readonly total?: number;
  /**
   * Any warnings related to the JQL query.
   */
  readonly warningMessages?: Array<string>;
};

/**
 * Details of an issue level security item.
 */
export type SecurityLevel = {
  /**
   * The description of the issue level security item.
   */
  readonly description?: string;
  /**
   * The ID of the issue level security item.
   */
  readonly id?: string;
  /**
   * Whether the issue level security item is the default.
   */
  readonly isDefault?: boolean;
  /**
   * The ID of the issue level security scheme.
   */
  readonly issueSecuritySchemeId?: string;
  /**
   * The name of the issue level security item.
   */
  readonly name?: string;
  /**
   * The URL of the issue level security item.
   */
  readonly self?: string;
};

/**
 * Issue security level member.
 */
export type SecurityLevelMember = {
  /**
   * The user or group being granted the permission. It consists of a `type` and a type-dependent `parameter`. See [Holder object](../api-group-permission-schemes/#holder-object) in *Get all permission schemes* for more information.
   */
  readonly holder: PermissionHolder;
  /**
   * The ID of the issue security level member.
   */
  readonly id: string;
  /**
   * The ID of the issue security level.
   */
  readonly issueSecurityLevelId: string;
  /**
   * The ID of the issue security scheme.
   */
  readonly issueSecuritySchemeId: string;
  managed?: boolean;
};

/**
 * Details about a security scheme.
 */
export type SecurityScheme = {
  /**
   * The ID of the default security level.
   */
  readonly defaultSecurityLevelId?: number;
  /**
   * The description of the issue security scheme.
   */
  readonly description?: string;
  /**
   * The ID of the issue security scheme.
   */
  readonly id?: number;
  levels?: Array<SecurityLevel>;
  /**
   * The name of the issue security scheme.
   */
  readonly name?: string;
  /**
   * The URL of the issue security scheme.
   */
  readonly self?: string;
};

/**
 * The ID of the issue security scheme.
 */
export type SecuritySchemeId = {
  /**
   * The ID of the issue security scheme.
   */
  readonly id: string;
};

export type SecuritySchemeLevelBean = {
  /**
   * The description of the issue security scheme level.
   */
  description?: string;
  /**
   * Specifies whether the level is the default level. False by default.
   */
  isDefault?: boolean;
  /**
   * The list of level members which should be added to the issue security scheme level.
   */
  members?: Array<SecuritySchemeLevelMemberBean>;
  /**
   * The name of the issue security scheme level. Must be unique.
   */
  name: string;
};

export type SecuritySchemeLevelMemberBean = {
  /**
   * The value corresponding to the specified member type.
   */
  parameter?: string;
  /**
   * The issue security level member type, e.g `reporter`, `group`, `user`.
   */
  type: string;
};

/**
 * Details of issue security scheme level new members.
 */
export type SecuritySchemeMembersRequest = {
  /**
   * The list of level members which should be added to the issue security scheme level.
   */
  members?: Array<SecuritySchemeLevelMemberBean>;
};

/**
 * Details about an issue security scheme.
 */
export type SecuritySchemeWithProjects = {
  /**
   * The default level ID of the issue security scheme.
   */
  readonly defaultLevel?: number;
  /**
   * The description of the issue security scheme.
   */
  readonly description?: string;
  /**
   * The ID of the issue security scheme.
   */
  readonly id: number;
  /**
   * The name of the issue security scheme.
   */
  readonly name: string;
  /**
   * The list of project IDs associated with the issue security scheme.
   */
  readonly projectIds?: Array<number>;
  /**
   * The URL of the issue security scheme.
   */
  readonly self: string;
};

/**
 * List of security schemes.
 */
export type SecuritySchemes = {
  /**
   * List of security schemes.
   */
  readonly issueSecuritySchemes?: Array<SecurityScheme>;
};

/**
 * Details about the Jira instance.
 */
export type ServerInformation = {
  /**
   * The base URL of the Jira instance.
   */
  baseUrl?: string;
  /**
   * The timestamp when the Jira version was built.
   */
  buildDate?: string;
  /**
   * The build number of the Jira version.
   */
  buildNumber?: number;
  /**
   * The type of server deployment. This is always returned as *Cloud*.
   */
  deploymentType?: string;
  /**
   * The display URL of the Jira instance.
   */
  displayUrl?: string;
  /**
   * The display URL of Confluence.
   */
  displayUrlConfluence?: string;
  /**
   * The display URL of the Servicedesk Help Center.
   */
  displayUrlServicedeskHelpCenter?: string;
  /**
   * Jira instance health check results. Deprecated and no longer returned.
   */
  healthChecks?: Array<HealthCheckResult>;
  /**
   * The unique identifier of the Jira version.
   */
  scmInfo?: string;
  /**
   * The time in Jira when this request was responded to.
   */
  serverTime?: string;
  /**
   * The default timezone of the Jira server. In a format known as Olson Time Zones, IANA Time Zones or TZ Database Time Zones.
   */
  serverTimeZone?: {
    displayName?: string;
    dstsavings?: number;
    id?: string;
    rawOffset?: number;
  };
  /**
   * The name of the Jira instance.
   */
  serverTitle?: string;
  /**
   * The version of Jira.
   */
  version?: string;
  /**
   * The major, minor, and revision version numbers of the Jira version.
   */
  versionNumbers?: Array<number>;
};

export type ServiceManagementNavigationInfo = {
  queueCategory?: string;
  queueId?: number;
  queueName?: string;
};

export type ServiceRegistry = {
  /**
   * service description
   */
  description?: string | null;
  /**
   * service ID
   */
  id?: string;
  /**
   * service name
   */
  name?: string;
  /**
   * organization ID
   */
  organizationId?: string;
  /**
   * service revision
   */
  revision?: string;
  serviceTier?: ServiceRegistryTier;
};

export type ServiceRegistryTier = {
  /**
   * tier description
   */
  description?: string | null;
  /**
   * tier ID
   */
  id?: string;
  /**
   * tier level
   */
  level?: number;
  /**
   * tier name
   */
  name?: string | null;
  /**
   * name key of the tier
   */
  nameKey?: string;
};

/**
 * Details of new default levels.
 */
export type SetDefaultLevelsRequest = {
  /**
   * List of objects with issue security scheme ID and new default level ID.
   */
  defaultValues: Array<DefaultLevelValue>;
};

/**
 * The new default issue priority.
 */
export type SetDefaultPriorityRequest = {
  /**
   * The ID of the new default issue priority. Must be an existing ID or null. Setting this to null erases the default priority setting.
   */
  id: string;
};

/**
 * The new default issue resolution.
 */
export type SetDefaultResolutionRequest = {
  /**
   * The ID of the new default issue resolution. Must be an existing ID or null. Setting this to null erases the default resolution setting.
   */
  id: string;
};

/**
 * Details of a share permission for the filter.
 */
export type SharePermission = {
  /**
   * The group that the filter is shared with. For a request, specify the `groupId` or `name` property for the group. As a group's name can change, use of `groupId` is recommended.
   */
  group?: GroupName;
  /**
   * The unique identifier of the share permission.
   */
  readonly id?: number;
  /**
   * The project that the filter is shared with. This is similar to the project object returned by [Get project](#api-rest-api-3-project-projectIdOrKey-get) but it contains a subset of the properties, which are: `self`, `id`, `key`, `assigneeType`, `name`, `roles`, `avatarUrls`, `projectType`, `simplified`.
   * For a request, specify the `id` for the project.
   */
  project?: Project;
  /**
   * The project role that the filter is shared with.
   * For a request, specify the `id` for the role. You must also specify the `project` object and `id` for the project that the role is in.
   */
  role?: ProjectRole;
  /**
   * The type of share permission:
   *
   * *  `user` Shared with a user.
   * *  `group` Shared with a group. If set in a request, then specify `sharePermission.group` as well.
   * *  `project` Shared with a project. If set in a request, then specify `sharePermission.project` as well.
   * *  `projectRole` Share with a project role in a project. This value is not returned in responses. It is used in requests, where it needs to be specify with `projectId` and `projectRoleId`.
   * *  `global` Shared globally. If set in a request, no other `sharePermission` properties need to be specified.
   * *  `loggedin` Shared with all logged-in users. Note: This value is set in a request by specifying `authenticated` as the `type`.
   * *  `project-unknown` Shared with a project that the user does not have access to. Cannot be set in a request.
   */
  type: 'user' | 'group' | 'project' | 'projectRole' | 'global' | 'loggedin' | 'authenticated' | 'project-unknown';
  /**
   * The user account ID that the filter is shared with. For a request, specify the `accountId` property for the user.
   */
  user?: UserBean;
};

/**
 * The type of share permission:
 *
 * *  `user` Shared with a user.
 * *  `group` Shared with a group. If set in a request, then specify `sharePermission.group` as well.
 * *  `project` Shared with a project. If set in a request, then specify `sharePermission.project` as well.
 * *  `projectRole` Share with a project role in a project. This value is not returned in responses. It is used in requests, where it needs to be specify with `projectId` and `projectRoleId`.
 * *  `global` Shared globally. If set in a request, no other `sharePermission` properties need to be specified.
 * *  `loggedin` Shared with all logged-in users. Note: This value is set in a request by specifying `authenticated` as the `type`.
 * *  `project-unknown` Shared with a project that the user does not have access to. Cannot be set in a request.
 */
export type type10 =
  | 'user'
  | 'group'
  | 'project'
  | 'projectRole'
  | 'global'
  | 'loggedin'
  | 'authenticated'
  | 'project-unknown';

export type SharePermissionInputBean = {
  /**
   * The user account ID that the filter is shared with. For a request, specify the `accountId` property for the user.
   */
  accountId?: string;
  /**
   * The ID of the group, which uniquely identifies the group across all Atlassian products.For example, *952d12c3-5b5b-4d04-bb32-44d383afc4b2*. Cannot be provided with `groupname`.
   */
  groupId?: string;
  /**
   * The name of the group to share the filter with. Set `type` to `group`. Please note that the name of a group is mutable, to reliably identify a group use `groupId`.
   */
  groupname?: string;
  /**
   * The ID of the project to share the filter with. Set `type` to `project`.
   */
  projectId?: string;
  /**
   * The ID of the project role to share the filter with. Set `type` to `projectRole` and the `projectId` for the project that the role is in.
   */
  projectRoleId?: string;
  /**
   * The rights for the share permission.
   */
  rights?: number;
  /**
   * The type of the share permission.Specify the type as follows:
   *
   * *  `user` Share with a user.
   * *  `group` Share with a group. Specify `groupname` as well.
   * *  `project` Share with a project. Specify `projectId` as well.
   * *  `projectRole` Share with a project role in a project. Specify `projectId` and `projectRoleId` as well.
   * *  `global` Share globally, including anonymous users. If set, this type overrides all existing share permissions and must be deleted before any non-global share permissions is set.
   * *  `authenticated` Share with all logged-in users. This shows as `loggedin` in the response. If set, this type overrides all existing share permissions and must be deleted before any non-global share permissions is set.
   */
  type: 'user' | 'project' | 'group' | 'projectRole' | 'global' | 'authenticated';
};

/**
 * The type of the share permission.Specify the type as follows:
 *
 * *  `user` Share with a user.
 * *  `group` Share with a group. Specify `groupname` as well.
 * *  `project` Share with a project. Specify `projectId` as well.
 * *  `projectRole` Share with a project role in a project. Specify `projectId` and `projectRoleId` as well.
 * *  `global` Share globally, including anonymous users. If set, this type overrides all existing share permissions and must be deleted before any non-global share permissions is set.
 * *  `authenticated` Share with all logged-in users. This shows as `loggedin` in the response. If set, this type overrides all existing share permissions and must be deleted before any non-global share permissions is set.
 */
export type type11 = 'user' | 'project' | 'group' | 'projectRole' | 'global' | 'authenticated';

export type SimpleApplicationPropertyBean = {
  /**
   * The ID of the application property.
   */
  id?: string;
  /**
   * The new value.
   */
  value?: string;
};

export type SimpleErrorCollection = {
  /**
   * The list of error messages produced by this operation. For example, "input parameter 'key' must be provided"
   */
  errorMessages?: Array<string>;
  /**
   * The list of errors by parameter returned by the operation. For example,"projectKey": "Project keys must start with an uppercase letter, followed by one or more uppercase alphanumeric characters."
   */
  errors?: {
    [key: string]: string;
  };
  httpStatusCode?: number;
};

/**
 * Details about the operations available in this version.
 */
export type SimpleLink = {
  href?: string;
  iconClass?: string;
  id?: string;
  label?: string;
  styleClass?: string;
  title?: string;
  weight?: number;
};

export type SimpleListWrapperApplicationRole = {
  callback?: ListWrapperCallbackApplicationRole;
  items?: Array<ApplicationRole>;
  'max-results'?: number;
  pagingCallback?: ListWrapperCallbackApplicationRole;
  size?: number;
};

export type SimpleListWrapperGroupName = {
  callback?: ListWrapperCallbackGroupName;
  items?: Array<GroupName>;
  'max-results'?: number;
  pagingCallback?: ListWrapperCallbackGroupName;
  size?: number;
};

/**
 * Represents a usage of an entity by a project ID and related issue type IDs.
 */
export type SimpleUsage = {
  /**
   * The issue type IDs for the usage.
   */
  issueTypeIds: Array<string>;
  /**
   * The project ID for the usage.
   */
  projectId: string;
};

export type SimplifiedHierarchyLevel = {
  /**
   * The ID of the level above this one in the hierarchy. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   */
  aboveLevelId?: number;
  /**
   * The ID of the level below this one in the hierarchy. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   */
  belowLevelId?: number;
  /**
   * The external UUID of the hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   */
  externalUuid?: string;
  hierarchyLevelNumber?: number;
  /**
   * The ID of the hierarchy level. This property is deprecated, see [Change notice: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   */
  id?: number;
  /**
   * The issue types available in this hierarchy level.
   */
  issueTypeIds?: Array<number>;
  /**
   * The level of this item in the hierarchy.
   */
  level?: number;
  /**
   * The name of this hierarchy level.
   */
  name?: string;
  /**
   * The ID of the project configuration. This property is deprecated, see [Change oticen: Removing hierarchy level IDs from next-gen APIs](https://developer.atlassian.com/cloud/jira/platform/change-notice-removing-hierarchy-level-ids-from-next-gen-apis/).
   */
  projectConfigurationId?: number;
};

export type SoftwareNavigationInfo = {
  boardId?: number;
  boardName?: string;
  simpleBoard?: boolean;
  totalBoardsInProject?: number;
};

/**
 * The status of the item.
 */
export type Status = {
  /**
   * Details of the icon representing the status. If not provided, no status icon displays in Jira.
   */
  icon?: Icon;
  /**
   * Whether the item is resolved. If set to "true", the link to the issue is displayed in a strikethrough font, otherwise the link displays in normal font.
   */
  resolved?: boolean;
};

/**
 * A status category.
 */
export type StatusCategory = {
  /**
   * The name of the color used to represent the status category.
   */
  readonly colorName?: string;
  /**
   * The ID of the status category.
   */
  readonly id?: number;
  /**
   * The key of the status category.
   */
  readonly key?: string;
  /**
   * The name of the status category.
   */
  readonly name?: string;
  /**
   * The URL of the status category.
   */
  readonly self?: string;
};

/**
 * Details of the status being created.
 */
export type StatusCreate = {
  /**
   * The description of the status.
   */
  description?: string;
  /**
   * The name of the status.
   */
  name: string;
  /**
   * The category of the status.
   */
  statusCategory: 'TODO' | 'IN_PROGRESS' | 'DONE';
};

/**
 * Details of the statuses being created and their scope.
 */
export type StatusCreateRequest = {
  scope: StatusScope;
  /**
   * Details of the statuses being created.
   */
  statuses: Array<StatusCreate>;
};

/**
 * A status.
 */
export type StatusDetails = {
  /**
   * The description of the status.
   */
  readonly description?: string;
  /**
   * The URL of the icon used to represent the status.
   */
  readonly iconUrl?: string;
  /**
   * The ID of the status.
   */
  readonly id?: string;
  /**
   * The name of the status.
   */
  readonly name?: string;
  /**
   * The scope of the field.
   */
  readonly scope?: Scope;
  /**
   * The URL of the status.
   */
  readonly self?: string;
  /**
   * The category assigned to the status.
   */
  readonly statusCategory?: StatusCategory;
};

/**
 * The statuses associated with this workflow.
 */
export type StatusLayoutUpdate = {
  approvalConfiguration?: ApprovalConfiguration;
  layout?: WorkflowLayout;
  /**
   * The properties for this status layout.
   */
  properties: {
    [key: string]: string;
  };
  /**
   * A unique ID which the status will use to refer to this layout configuration.
   */
  statusReference: string;
};

/**
 * Details about the mapping from a status to a new status for an issue type.
 */
export type StatusMapping = {
  /**
   * The ID of the issue type.
   */
  issueTypeId: string;
  /**
   * The ID of the new status.
   */
  newStatusId: string;
  /**
   * The ID of the status.
   */
  statusId: string;
};

/**
 * The mapping of old to new status ID for a specific project and issue type.
 */
export type StatusMappingDTO = {
  /**
   * The issue type for the status mapping.
   */
  issueTypeId: string;
  /**
   * The project for the status mapping.
   */
  projectId: string;
  /**
   * The list of old and new status ID mappings for the specified project and issue type.
   */
  statusMigrations: Array<StatusMigration>;
};

/**
 * The details of the statuses in the associated workflows.
 */
export type StatusMetadata = {
  /**
   * The category of the status.
   */
  category?: 'TODO' | 'IN_PROGRESS' | 'DONE';
  /**
   * The ID of the status.
   */
  id?: string;
  /**
   * The name of the status.
   */
  name?: string;
};

/**
 * The category of the status.
 */
export type category = 'TODO' | 'IN_PROGRESS' | 'DONE';

/**
 * The mapping of old to new status ID.
 */
export type StatusMigration = {
  /**
   * The new status ID.
   */
  newStatusReference: string;
  /**
   * The old status ID.
   */
  oldStatusReference: string;
};

/**
 * The status reference and port that a transition is connected to.
 * @deprecated
 */
export type StatusReferenceAndPort = {
  /**
   * The port this transition uses to connect to this status.
   */
  port?: number;
  /**
   * The reference of this status.
   */
  statusReference: string;
} | null;

/**
 * The scope of the status.
 */
export type StatusScope = {
  project?: ProjectId;
  /**
   * The scope of the status. `GLOBAL` for company-managed projects and `PROJECT` for team-managed projects.
   */
  type: 'PROJECT' | 'GLOBAL';
};

/**
 * The scope of the status. `GLOBAL` for company-managed projects and `PROJECT` for team-managed projects.
 */
export type type12 = 'PROJECT' | 'GLOBAL';

/**
 * Details of the status being updated.
 */
export type StatusUpdate = {
  /**
   * The description of the status.
   */
  description?: string;
  /**
   * The ID of the status.
   */
  id: string;
  /**
   * The name of the status.
   */
  name: string;
  /**
   * The category of the status.
   */
  statusCategory: 'TODO' | 'IN_PROGRESS' | 'DONE';
};

/**
 * The list of statuses that will be updated.
 */
export type StatusUpdateRequest = {
  /**
   * The list of statuses that will be updated.
   */
  statuses: Array<StatusUpdate>;
};

/**
 * The statuses associated with each workflow.
 */
export type StatusesPerWorkflow = {
  /**
   * The ID of the initial status for the workflow.
   */
  initialStatusId?: string;
  /**
   * The status IDs associated with the workflow.
   */
  statuses?: Array<string>;
  /**
   * The ID of the workflow.
   */
  workflowId?: string;
};

export type StreamingResponseBody = {
  [key: string]: string;
};

export type StringList = {
  [key: string]: string;
};

export type SubmittedBulkOperation = {
  taskId?: string;
};

/**
 * An issue suggested for use in the issue picker auto-completion.
 */
export type SuggestedIssue = {
  /**
   * The ID of the issue.
   */
  readonly id?: number;
  /**
   * The URL of the issue type's avatar.
   */
  readonly img?: string;
  /**
   * The key of the issue.
   */
  readonly key?: string;
  /**
   * The key of the issue in HTML format.
   */
  readonly keyHtml?: string;
  /**
   * The phrase containing the query string in HTML format, with the string highlighted with HTML bold tags.
   */
  readonly summary?: string;
  /**
   * The phrase containing the query string, as plain text.
   */
  readonly summaryText?: string;
};

/**
 * Details of changes to a priority scheme's priorities that require suggested priority mappings.
 */
export type SuggestedMappingsForPrioritiesRequestBean = {
  /**
   * The ids of priorities being removed from the scheme.
   */
  add?: Array<number>;
  /**
   * The ids of priorities being removed from the scheme.
   */
  remove?: Array<number>;
};

/**
 * Details of changes to a priority scheme's projects that require suggested priority mappings.
 */
export type SuggestedMappingsForProjectsRequestBean = {
  /**
   * The ids of projects being added to the scheme.
   */
  add?: Array<number>;
};

/**
 * Details of changes to a priority scheme that require suggested priority mappings.
 */
export type SuggestedMappingsRequestBean = {
  /**
   * The maximum number of results that could be on the page.
   */
  maxResults?: number;
  /**
   * The priority changes in the scheme.
   */
  priorities?: SuggestedMappingsForPrioritiesRequestBean;
  /**
   * The project changes in the scheme.
   */
  projects?: SuggestedMappingsForProjectsRequestBean;
  /**
   * The id of the priority scheme.
   */
  schemeId?: number;
  /**
   * The index of the first item returned on the page.
   */
  startAt?: number;
};

/**
 * List of system avatars.
 */
export type SystemAvatars = {
  /**
   * A list of avatar details.
   */
  readonly system?: Array<Avatar>;
};

/**
 * Details about a task.
 */
export type TaskProgressBeanJsonNode = {
  /**
   * The description of the task.
   */
  description?: string;
  /**
   * The execution time of the task, in milliseconds.
   */
  elapsedRuntime: number;
  /**
   * A timestamp recording when the task was finished.
   */
  finished?: number;
  /**
   * The ID of the task.
   */
  id: string;
  /**
   * A timestamp recording when the task progress was last updated.
   */
  lastUpdate: number;
  /**
   * Information about the progress of the task.
   */
  message?: string;
  /**
   * The progress of the task, as a percentage complete.
   */
  progress: number;
  /**
   * The result of the task execution.
   */
  result?: JsonNode;
  /**
   * The URL of the task.
   */
  self: string;
  /**
   * A timestamp recording when the task was started.
   */
  started?: number;
  /**
   * The status of the task.
   */
  status: 'ENQUEUED' | 'RUNNING' | 'COMPLETE' | 'FAILED' | 'CANCEL_REQUESTED' | 'CANCELLED' | 'DEAD';
  /**
   * A timestamp recording when the task was submitted.
   */
  submitted: number;
  /**
   * The ID of the user who submitted the task.
   */
  submittedBy: number;
};

/**
 * Details about a task.
 */
export type TaskProgressBeanObject = {
  /**
   * The description of the task.
   */
  description?: string;
  /**
   * The execution time of the task, in milliseconds.
   */
  elapsedRuntime: number;
  /**
   * A timestamp recording when the task was finished.
   */
  finished?: number;
  /**
   * The ID of the task.
   */
  id: string;
  /**
   * A timestamp recording when the task progress was last updated.
   */
  lastUpdate: number;
  /**
   * Information about the progress of the task.
   */
  message?: string;
  /**
   * The progress of the task, as a percentage complete.
   */
  progress: number;
  /**
   * The result of the task execution.
   */
  result?: string;
  /**
   * The URL of the task.
   */
  self: string;
  /**
   * A timestamp recording when the task was started.
   */
  started?: number;
  /**
   * The status of the task.
   */
  status: 'ENQUEUED' | 'RUNNING' | 'COMPLETE' | 'FAILED' | 'CANCEL_REQUESTED' | 'CANCELLED' | 'DEAD';
  /**
   * A timestamp recording when the task was submitted.
   */
  submitted: number;
  /**
   * The ID of the user who submitted the task.
   */
  submittedBy: number;
};

/**
 * Details about a task.
 */
export type TaskProgressBeanRemoveOptionFromIssuesResult = {
  /**
   * The description of the task.
   */
  description?: string;
  /**
   * The execution time of the task, in milliseconds.
   */
  elapsedRuntime: number;
  /**
   * A timestamp recording when the task was finished.
   */
  finished?: number;
  /**
   * The ID of the task.
   */
  id: string;
  /**
   * A timestamp recording when the task progress was last updated.
   */
  lastUpdate: number;
  /**
   * Information about the progress of the task.
   */
  message?: string;
  /**
   * The progress of the task, as a percentage complete.
   */
  progress: number;
  /**
   * The result of the task execution.
   */
  result?: RemoveOptionFromIssuesResult;
  /**
   * The URL of the task.
   */
  self: string;
  /**
   * A timestamp recording when the task was started.
   */
  started?: number;
  /**
   * The status of the task.
   */
  status: 'ENQUEUED' | 'RUNNING' | 'COMPLETE' | 'FAILED' | 'CANCEL_REQUESTED' | 'CANCELLED' | 'DEAD';
  /**
   * A timestamp recording when the task was submitted.
   */
  submitted: number;
  /**
   * The ID of the user who submitted the task.
   */
  submittedBy: number;
};

/**
 * Details of the time tracking configuration.
 */
export type TimeTrackingConfiguration = {
  /**
   * The default unit of time applied to logged time.
   */
  defaultUnit: 'minute' | 'hour' | 'day' | 'week';
  /**
   * The format that will appear on an issue's *Time Spent* field.
   */
  timeFormat: 'pretty' | 'days' | 'hours';
  /**
   * The number of days in a working week.
   */
  workingDaysPerWeek: number;
  /**
   * The number of hours in a working day.
   */
  workingHoursPerDay: number;
};

/**
 * The default unit of time applied to logged time.
 */
export type defaultUnit = 'minute' | 'hour' | 'day' | 'week';

/**
 * The format that will appear on an issue's *Time Spent* field.
 */
export type timeFormat = 'pretty' | 'days' | 'hours';

/**
 * Time tracking details.
 */
export type TimeTrackingDetails = {
  /**
   * The original estimate of time needed for this issue in readable format.
   */
  readonly originalEstimate?: string;
  /**
   * The original estimate of time needed for this issue in seconds.
   */
  readonly originalEstimateSeconds?: number;
  /**
   * The remaining estimate of time needed for this issue in readable format.
   */
  readonly remainingEstimate?: string;
  /**
   * The remaining estimate of time needed for this issue in seconds.
   */
  readonly remainingEstimateSeconds?: number;
  /**
   * Time worked on this issue in readable format.
   */
  readonly timeSpent?: string;
  /**
   * Time worked on this issue in seconds.
   */
  readonly timeSpentSeconds?: number;
};

/**
 * Details about the time tracking provider.
 */
export type TimeTrackingProvider = {
  /**
   * The key for the time tracking provider. For example, *JIRA*.
   */
  key: string;
  /**
   * The name of the time tracking provider. For example, *JIRA provided time tracking*.
   */
  name?: string;
  /**
   * The URL of the configuration page for the time tracking provider app. For example, *example/config/url*. This property is only returned if the `adminPageKey` property is set in the module descriptor of the time tracking provider app.
   */
  readonly url?: string;
};

/**
 * Details of a workflow transition.
 */
export type Transition = {
  /**
   * The description of the transition.
   */
  description: string;
  /**
   * The statuses the transition can start from.
   */
  from: Array<string>;
  /**
   * The ID of the transition.
   */
  id: string;
  /**
   * The name of the transition.
   */
  name: string;
  /**
   * The properties of the transition.
   */
  properties?: {
    [key: string]: string;
  };
  rules?: WorkflowRules;
  screen?: TransitionScreenDetails;
  /**
   * The status the transition goes to.
   */
  to: string;
  /**
   * The type of the transition.
   */
  type: 'global' | 'initial' | 'directed';
};

/**
 * The details of a transition screen.
 */
export type TransitionScreenDetails = {
  /**
   * The ID of the screen.
   */
  id: string;
  /**
   * The name of the screen.
   */
  name?: string;
};

/**
 * The transition update data. Note that a transition can have either the deprecated `to`/`from` fields or the `toStatusReference`/`links` fields, but never both nor a combination.
 */
export type TransitionUpdateDTO = {
  /**
   * The post-functions of the transition.
   */
  actions?: Array<WorkflowRuleConfiguration>;
  conditions?: ConditionGroupUpdate;
  /**
   * The custom event ID of the transition.
   */
  customIssueEventId?: string;
  /**
   * The description of the transition.
   */
  description?: string;
  /**
   * The statuses and ports that the transition can start from. This field is deprecated - use `toStatusReference`/`links` instead.
   * @deprecated
   */
  from?: Array<StatusReferenceAndPort>;
  /**
   * The ID of the transition.
   */
  id: string;
  /**
   * The statuses the transition can start from, and the mapping of ports between the statuses.
   */
  links?: Array<WorkflowTransitionLinks>;
  /**
   * The name of the transition.
   */
  name: string;
  /**
   * The properties of the transition.
   */
  properties?: {
    [key: string]: string;
  };
  to?: StatusReferenceAndPort;
  /**
   * The status the transition goes to.
   */
  toStatusReference?: string;
  transitionScreen?: WorkflowRuleConfiguration;
  /**
   * The triggers of the transition.
   */
  triggers?: Array<WorkflowTrigger>;
  /**
   * The transition type.
   */
  type: 'INITIAL' | 'GLOBAL' | 'DIRECTED';
  /**
   * The validators of the transition.
   */
  validators?: Array<WorkflowRuleConfiguration>;
};

/**
 * The transition type.
 */
export type type13 = 'INITIAL' | 'GLOBAL' | 'DIRECTED';

/**
 * List of issue transitions.
 */
export type Transitions = {
  /**
   * Expand options that include additional transitions details in the response.
   */
  readonly expand?: string;
  /**
   * List of issue transitions.
   */
  readonly transitions?: Array<IssueTransition>;
};

/**
 * The details of a UI modification's context, which define where to activate the UI modification.
 */
export type UiModificationContextDetails = {
  /**
   * The ID of the UI modification context.
   */
  readonly id?: string;
  /**
   * Whether a context is available. For example, when a project is deleted the context becomes unavailable.
   */
  readonly isAvailable?: boolean;
  /**
   * The issue type ID of the context. Null is treated as a wildcard, meaning the UI modification will be applied to all issue types. Each UI modification context can have a maximum of one wildcard.
   */
  issueTypeId?: string;
  /**
   * The project ID of the context. Null is treated as a wildcard, meaning the UI modification will be applied to all projects. Each UI modification context can have a maximum of one wildcard.
   */
  projectId?: string;
  /**
   * The view type of the context. Only `GIC`(Global Issue Create), `IssueView` and `IssueTransition` are supported. Null is treated as a wildcard, meaning the UI modification will be applied to all view types. Each UI modification context can have a maximum of one wildcard.
   */
  viewType?: 'GIC' | 'IssueView' | 'IssueTransition';
};

/**
 * The view type of the context. Only `GIC`(Global Issue Create), `IssueView` and `IssueTransition` are supported. Null is treated as a wildcard, meaning the UI modification will be applied to all view types. Each UI modification context can have a maximum of one wildcard.
 */
export type viewType = 'GIC' | 'IssueView' | 'IssueTransition';

/**
 * The details of a UI modification.
 */
export type UiModificationDetails = {
  /**
   * List of contexts of the UI modification. The maximum number of contexts is 1000.
   */
  readonly contexts?: Array<UiModificationContextDetails>;
  /**
   * The data of the UI modification. The maximum size of the data is 50000 characters.
   */
  readonly data?: string;
  /**
   * The description of the UI modification. The maximum length is 255 characters.
   */
  readonly description?: string;
  /**
   * The ID of the UI modification.
   */
  readonly id: string;
  /**
   * The name of the UI modification. The maximum length is 255 characters.
   */
  readonly name: string;
  /**
   * The URL of the UI modification.
   */
  readonly self: string;
};

/**
 * Identifiers for a UI modification.
 */
export type UiModificationIdentifiers = {
  /**
   * The ID of the UI modification.
   */
  readonly id: string;
  /**
   * The URL of the UI modification.
   */
  readonly self: string;
};

export type UnrestrictedUserEmail = {
  /**
   * The accountId of the user
   */
  accountId?: string;
  /**
   * The email of the user
   */
  email?: string;
};

/**
 * Details of a custom field.
 */
export type UpdateCustomFieldDetails = {
  /**
   * The description of the custom field. The maximum length is 40000 characters.
   */
  description?: string;
  /**
   * The name of the custom field. It doesn't have to be unique. The maximum length is 255 characters.
   */
  name?: string;
  /**
   * The searcher that defines the way the field is searched in Jira. It can be set to `null`, otherwise you must specify the valid searcher for the field type, as listed below (abbreviated values shown):
   *
   * *  `cascadingselect`: `cascadingselectsearcher`
   * *  `datepicker`: `daterange`
   * *  `datetime`: `datetimerange`
   * *  `float`: `exactnumber` or `numberrange`
   * *  `grouppicker`: `grouppickersearcher`
   * *  `importid`: `exactnumber` or `numberrange`
   * *  `labels`: `labelsearcher`
   * *  `multicheckboxes`: `multiselectsearcher`
   * *  `multigrouppicker`: `multiselectsearcher`
   * *  `multiselect`: `multiselectsearcher`
   * *  `multiuserpicker`: `userpickergroupsearcher`
   * *  `multiversion`: `versionsearcher`
   * *  `project`: `projectsearcher`
   * *  `radiobuttons`: `multiselectsearcher`
   * *  `readonlyfield`: `textsearcher`
   * *  `select`: `multiselectsearcher`
   * *  `textarea`: `textsearcher`
   * *  `textfield`: `textsearcher`
   * *  `url`: `exacttextsearcher`
   * *  `userpicker`: `userpickergroupsearcher`
   * *  `version`: `versionsearcher`
   */
  searcherKey?:
    | 'com.atlassian.jira.plugin.system.customfieldtypes:cascadingselectsearcher'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:daterange'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:datetimerange'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:exactnumber'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:exacttextsearcher'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:grouppickersearcher'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:labelsearcher'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:multiselectsearcher'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:numberrange'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:projectsearcher'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:textsearcher'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:userpickergroupsearcher'
    | 'com.atlassian.jira.plugin.system.customfieldtypes:versionsearcher';
};

/**
 * The request for updating the default project classification level.
 */
export type UpdateDefaultProjectClassificationBean = {
  /**
   * The ID of the project classification.
   */
  id: string;
};

/**
 * The ID of a screen scheme.
 */
export type UpdateDefaultScreenScheme = {
  /**
   * The ID of the screen scheme.
   */
  screenSchemeId: string;
};

/**
 * The details of the field configuration scheme.
 */
export type UpdateFieldConfigurationSchemeDetails = {
  /**
   * The description of the field configuration scheme.
   */
  description?: string;
  /**
   * The name of the field configuration scheme. The name must be unique.
   */
  name: string;
};

/**
 * Details of issue security scheme level.
 */
export type UpdateIssueSecurityLevelDetails = {
  /**
   * The description of the issue security scheme level.
   */
  description?: string;
  /**
   * The name of the issue security scheme level. Must be unique.
   */
  name?: string;
};

export type UpdateIssueSecuritySchemeRequestBean = {
  /**
   * The description of the security scheme scheme.
   */
  description?: string;
  /**
   * The name of the security scheme scheme. Must be unique.
   */
  name?: string;
};

/**
 * Details of a notification scheme.
 */
export type UpdateNotificationSchemeDetails = {
  /**
   * The description of the notification scheme.
   */
  description?: string;
  /**
   * The name of the notification scheme. Must be unique.
   */
  name?: string;
};

/**
 * Update priorities in a scheme
 */
export type UpdatePrioritiesInSchemeRequestBean = {
  /**
   * Priorities to add to a scheme
   */
  add?: PrioritySchemeChangesWithoutMappings;
  /**
   * Priorities to remove from a scheme
   */
  remove?: PrioritySchemeChangesWithMappings;
};

/**
 * Details of an issue priority.
 */
export type UpdatePriorityDetails = {
  /**
   * The ID for the avatar for the priority. This parameter is nullable and both iconUrl and avatarId cannot be defined.
   */
  avatarId?: number;
  /**
   * The description of the priority.
   */
  description?: string | null;
  /**
   * The URL of an icon for the priority. Accepted protocols are HTTP and HTTPS. Built in icons can also be used. Both iconUrl and avatarId cannot be defined.
   */
  iconUrl?:
    | (
        | '/images/icons/priorities/blocker.png'
        | '/images/icons/priorities/critical.png'
        | '/images/icons/priorities/high.png'
        | '/images/icons/priorities/highest.png'
        | '/images/icons/priorities/low.png'
        | '/images/icons/priorities/lowest.png'
        | '/images/icons/priorities/major.png'
        | '/images/icons/priorities/medium.png'
        | '/images/icons/priorities/minor.png'
        | '/images/icons/priorities/trivial.png'
        | '/images/icons/priorities/blocker_new.png'
        | '/images/icons/priorities/critical_new.png'
        | '/images/icons/priorities/high_new.png'
        | '/images/icons/priorities/highest_new.png'
        | '/images/icons/priorities/low_new.png'
        | '/images/icons/priorities/lowest_new.png'
        | '/images/icons/priorities/major_new.png'
        | '/images/icons/priorities/medium_new.png'
        | '/images/icons/priorities/minor_new.png'
        | '/images/icons/priorities/trivial_new.png'
      )
    | null;
  /**
   * The name of the priority. Must be unique.
   */
  name?: string | null;
  /**
   * The status color of the priority in 3-digit or 6-digit hexadecimal format.
   */
  statusColor?: string | null;
};

/**
 * Details of a priority scheme.
 */
export type UpdatePrioritySchemeRequestBean = {
  /**
   * The default priority of the scheme.
   */
  defaultPriorityId?: number;
  /**
   * The description of the priority scheme.
   */
  description?: string;
  /**
   * Instructions to migrate issues.
   */
  mappings?: PriorityMapping;
  /**
   * The name of the priority scheme. Must be unique.
   */
  name?: string;
  /**
   * The priorities in the scheme.
   */
  priorities?: UpdatePrioritiesInSchemeRequestBean;
  /**
   * The projects in the scheme.
   */
  projects?: UpdateProjectsInSchemeRequestBean;
};

/**
 * Details of the updated priority scheme.
 */
export type UpdatePrioritySchemeResponseBean = {
  priorityScheme?: PrioritySchemeWithPaginatedPrioritiesAndProjects;
  /**
   * The in-progress issue migration task.
   */
  readonly task?: TaskProgressBeanJsonNode;
};

/**
 * Details about the project.
 */
export type UpdateProjectDetails = {
  /**
   * The default assignee when creating issues for this project.
   */
  assigneeType?: 'PROJECT_LEAD' | 'UNASSIGNED';
  /**
   * An integer value for the project's avatar.
   */
  avatarId?: number;
  /**
   * The ID of the project's category. A complete list of category IDs is found using the [Get all project categories](#api-rest-api-3-projectCategory-get) operation. To remove the project category from the project, set the value to `-1.`
   */
  categoryId?: number;
  /**
   * A brief description of the project.
   */
  description?: string;
  /**
   * The ID of the issue security scheme for the project, which enables you to control who can and cannot view issues. Use the [Get issue security schemes](#api-rest-api-3-issuesecurityschemes-get) resource to get all issue security scheme IDs.
   */
  issueSecurityScheme?: number;
  /**
   * Project keys must be unique and start with an uppercase letter followed by one or more uppercase alphanumeric characters. The maximum length is 10 characters.
   */
  key?: string;
  /**
   * This parameter is deprecated because of privacy changes. Use `leadAccountId` instead. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details. The user name of the project lead. Cannot be provided with `leadAccountId`.
   */
  lead?: string;
  /**
   * The account ID of the project lead. Cannot be provided with `lead`.
   */
  leadAccountId?: string;
  /**
   * The name of the project.
   */
  name?: string;
  /**
   * The ID of the notification scheme for the project. Use the [Get notification schemes](#api-rest-api-3-notificationscheme-get) resource to get a list of notification scheme IDs.
   */
  notificationScheme?: number;
  /**
   * The ID of the permission scheme for the project. Use the [Get all permission schemes](#api-rest-api-3-permissionscheme-get) resource to see a list of all permission scheme IDs.
   */
  permissionScheme?: number;
  /**
   * A link to information about this project, such as project documentation
   */
  url?: string;
};

/**
 * Update projects in a scheme
 */
export type UpdateProjectsInSchemeRequestBean = {
  /**
   * Projects to add to a scheme
   */
  add?: PrioritySchemeChangesWithoutMappings;
  /**
   * Projects to remove from a scheme
   */
  remove?: PrioritySchemeChangesWithoutMappings;
};

/**
 * Details of an issue resolution.
 */
export type UpdateResolutionDetails = {
  /**
   * The description of the resolution.
   */
  description?: string;
  /**
   * The name of the resolution. Must be unique.
   */
  name: string;
};

/**
 * Details of a screen.
 */
export type UpdateScreenDetails = {
  /**
   * The description of the screen. The maximum length is 255 characters.
   */
  description?: string;
  /**
   * The name of the screen. The name must be unique. The maximum length is 255 characters.
   */
  name?: string;
};

/**
 * Details of a screen scheme.
 */
export type UpdateScreenSchemeDetails = {
  /**
   * The description of the screen scheme. The maximum length is 255 characters.
   */
  description?: string;
  /**
   * The name of the screen scheme. The name must be unique. The maximum length is 255 characters.
   */
  name?: string;
  /**
   * The IDs of the screens for the screen types of the screen scheme. Only screens used in classic projects are accepted.
   */
  screens?: UpdateScreenTypes;
};

/**
 * The IDs of the screens for the screen types of the screen scheme.
 */
export type UpdateScreenTypes = {
  /**
   * The ID of the create screen. To remove the screen association, pass a null.
   */
  create?: string;
  /**
   * The ID of the default screen. When specified, must include a screen ID as a default screen is required.
   */
  default?: string;
  /**
   * The ID of the edit screen. To remove the screen association, pass a null.
   */
  edit?: string;
  /**
   * The ID of the view screen. To remove the screen association, pass a null.
   */
  view?: string;
};

/**
 * The details of a UI modification.
 */
export type UpdateUiModificationDetails = {
  /**
   * List of contexts of the UI modification. The maximum number of contexts is 1000. If provided, replaces all existing contexts.
   */
  contexts?: Array<UiModificationContextDetails>;
  /**
   * The data of the UI modification. The maximum size of the data is 50000 characters.
   */
  data?: string;
  /**
   * The description of the UI modification. The maximum length is 255 characters.
   */
  description?: string;
  /**
   * The name of the UI modification. The maximum length is 255 characters.
   */
  name?: string;
};

export type UpdateUserToGroupBean = {
  /**
   * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.
   */
  accountId?: string;
  /**
   * This property is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
   */
  name?: string;
};

/**
 * A project category.
 */
export type UpdatedProjectCategory = {
  /**
   * The name of the project category.
   */
  readonly description?: string;
  /**
   * The ID of the project category.
   */
  readonly id?: string;
  /**
   * The description of the project category.
   */
  readonly name?: string;
  /**
   * The URL of the project category.
   */
  readonly self?: string;
};

/**
 * A user with details as permitted by the user's Atlassian Account privacy settings. However, be aware of these exceptions:
 *
 * *  User record deleted from Atlassian: This occurs as the result of a right to be forgotten request. In this case, `displayName` provides an indication and other parameters have default values or are blank (for example, email is blank).
 * *  User record corrupted: This occurs as a results of events such as a server import and can only happen to deleted users. In this case, `accountId` returns *unknown* and all other parameters have fallback values.
 * *  User record unavailable: This usually occurs due to an internal service outage. In this case, all parameters have fallback values.
 */
export type User = {
  /**
   * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*. Required in requests.
   */
  accountId?: string;
  /**
   * The user account type. Can take the following values:
   *
   * *  `atlassian` regular Atlassian user account
   * *  `app` system account used for Connect applications and OAuth to represent external systems
   * *  `customer` Jira Service Desk account representing an external service desk
   */
  readonly accountType?: 'atlassian' | 'app' | 'customer' | 'unknown';
  /**
   * Whether the user is active.
   */
  readonly active?: boolean;
  /**
   * The application roles the user is assigned to.
   */
  readonly applicationRoles?: SimpleListWrapperApplicationRole;
  /**
   * The avatars of the user.
   */
  readonly avatarUrls?: AvatarUrlsBean;
  /**
   * The display name of the user. Depending on the user’s privacy setting, this may return an alternative value.
   */
  readonly displayName?: string;
  /**
   * The email address of the user. Depending on the user’s privacy setting, this may be returned as null.
   */
  readonly emailAddress?: string;
  /**
   * Expand options that include additional user details in the response.
   */
  readonly expand?: string;
  /**
   * The groups that the user belongs to.
   */
  readonly groups?: SimpleListWrapperGroupName;
  /**
   * This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
   */
  key?: string;
  /**
   * The locale of the user. Depending on the user’s privacy setting, this may be returned as null.
   */
  readonly locale?: string;
  /**
   * This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
   */
  name?: string;
  /**
   * The URL of the user.
   */
  readonly self?: string;
  /**
   * The time zone specified in the user's profile. Depending on the user’s privacy setting, this may be returned as null.
   */
  readonly timeZone?: string;
};

/**
 * The user account type. Can take the following values:
 *
 * *  `atlassian` regular Atlassian user account
 * *  `app` system account used for Connect applications and OAuth to represent external systems
 * *  `customer` Jira Service Desk account representing an external service desk
 */
export type accountType = 'atlassian' | 'app' | 'customer' | 'unknown';

export type UserBean = {
  /**
   * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.
   */
  accountId?: string;
  /**
   * Whether the user is active.
   */
  active?: boolean;
  /**
   * The avatars of the user.
   */
  avatarUrls?: UserBeanAvatarUrls;
  /**
   * The display name of the user. Depending on the user’s privacy setting, this may return an alternative value.
   */
  displayName?: string;
  /**
   * This property is deprecated in favor of `accountId` because of privacy changes. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
   * The key of the user.
   */
  key?: string;
  /**
   * This property is deprecated in favor of `accountId` because of privacy changes. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
   * The username of the user.
   */
  name?: string;
  /**
   * The URL of the user.
   */
  self?: string;
};

export type UserBeanAvatarUrls = {
  /**
   * The URL of the user's 16x16 pixel avatar.
   */
  '16x16'?: string;
  /**
   * The URL of the user's 24x24 pixel avatar.
   */
  '24x24'?: string;
  /**
   * The URL of the user's 32x32 pixel avatar.
   */
  '32x32'?: string;
  /**
   * The URL of the user's 48x48 pixel avatar.
   */
  '48x48'?: string;
};

export type UserColumnRequestBody = {
  columns?: Array<string>;
};

/**
 * A [user](https://developer.atlassian.com/cloud/jira/platform/jira-expressions-type-reference#user) specified as an Atlassian account ID.
 */
export type UserContextVariable = {
  /**
   * The account ID of the user.
   */
  accountId: string;
  /**
   * Type of custom context variable.
   */
  type: 'user';
};

/**
 * User details permitted by the user's Atlassian Account privacy settings. However, be aware of these exceptions:
 *
 * *  User record deleted from Atlassian: This occurs as the result of a right to be forgotten request. In this case, `displayName` provides an indication and other parameters have default values or are blank (for example, email is blank).
 * *  User record corrupted: This occurs as a results of events such as a server import and can only happen to deleted users. In this case, `accountId` returns *unknown* and all other parameters have fallback values.
 * *  User record unavailable: This usually occurs due to an internal service outage. In this case, all parameters have fallback values.
 */
export type UserDetails = {
  /**
   * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.
   */
  accountId?: string;
  /**
   * The type of account represented by this user. This will be one of 'atlassian' (normal users), 'app' (application user) or 'customer' (Jira Service Desk customer user)
   */
  readonly accountType?: string;
  /**
   * Whether the user is active.
   */
  readonly active?: boolean;
  /**
   * The avatars of the user.
   */
  readonly avatarUrls?: AvatarUrlsBean;
  /**
   * The display name of the user. Depending on the user’s privacy settings, this may return an alternative value.
   */
  readonly displayName?: string;
  /**
   * The email address of the user. Depending on the user’s privacy settings, this may be returned as null.
   */
  readonly emailAddress?: string;
  /**
   * This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
   */
  readonly key?: string;
  /**
   * This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
   */
  readonly name?: string;
  /**
   * The URL of the user.
   */
  readonly self?: string;
  /**
   * The time zone specified in the user's profile. Depending on the user’s privacy settings, this may be returned as null.
   */
  readonly timeZone?: string;
};

/**
 * Filter for a User Picker (single) custom field.
 */
export type UserFilter = {
  /**
   * Whether the filter is enabled.
   */
  enabled: boolean;
  /**
   * User groups autocomplete suggestion users must belong to. If not provided, the default values are used. A maximum of 10 groups can be provided.
   */
  groups?: Array<string>;
  /**
   * Roles that autocomplete suggestion users must belong to. If not provided, the default values are used. A maximum of 10 roles can be provided.
   */
  roleIds?: Array<number>;
};

/**
 * List of user account IDs.
 */
export type UserKey = {
  /**
   * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*. Returns *unknown* if the record is deleted and corrupted, for example, as the result of a server import.
   */
  accountId?: string;
  /**
   * This property is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
   */
  key?: string;
};

/**
 * A paginated list of users sharing the filter. This includes users that are members of the groups or can browse the projects that the filter is shared with.
 */
export type UserList = {
  /**
   * The index of the last item returned on the page.
   */
  readonly 'end-index'?: number;
  /**
   * The list of items.
   */
  readonly items?: Array<User>;
  /**
   * The maximum number of results that could be on the page.
   */
  readonly 'max-results'?: number;
  /**
   * The number of items on the page.
   */
  readonly size?: number;
  /**
   * The index of the first item returned on the page.
   */
  readonly 'start-index'?: number;
};

export type UserMigrationBean = {
  accountId?: string;
  key?: string;
  username?: string;
};

/**
 * Details of a permission and its availability to a user.
 */
export type UserPermission = {
  /**
   * Indicate whether the permission key is deprecated. Note that deprecated keys cannot be used in the `permissions parameter of Get my permissions. Deprecated keys are not returned by Get all permissions.`
   */
  deprecatedKey?: boolean;
  /**
   * The description of the permission.
   */
  description?: string;
  /**
   * Whether the permission is available to the user in the queried context.
   */
  havePermission?: boolean;
  /**
   * The ID of the permission. Either `id` or `key` must be specified. Use [Get all permissions](#api-rest-api-3-permissions-get) to get the list of permissions.
   */
  id?: string;
  /**
   * The key of the permission. Either `id` or `key` must be specified. Use [Get all permissions](#api-rest-api-3-permissions-get) to get the list of permissions.
   */
  key?: string;
  /**
   * The name of the permission.
   */
  name?: string;
  /**
   * The type of the permission.
   */
  type?: 'GLOBAL' | 'PROJECT';
};

/**
 * A user found in a search.
 */
export type UserPickerUser = {
  /**
   * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.
   */
  accountId?: string;
  /**
   * The avatar URL of the user.
   */
  avatarUrl?: string;
  /**
   * The display name of the user. Depending on the user’s privacy setting, this may be returned as null.
   */
  displayName?: string;
  /**
   * The display name, email address, and key of the user with the matched query string highlighted with the HTML bold tag.
   */
  html?: string;
  /**
   * This property is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
   */
  key?: string;
  /**
   * This property is no longer available . See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
   */
  name?: string;
};

/**
 * The level of validation to return from the API. If no values are provided, the default would return `WARNING` and `ERROR` level validation results.
 */
export type ValidationOptionsForCreate = {
  levels?: Array<'WARNING' | 'ERROR'>;
};

/**
 * The level of validation to return from the API. If no values are provided, the default would return `WARNING` and `ERROR` level validation results.
 */
export type ValidationOptionsForUpdate = {
  levels?: Array<'WARNING' | 'ERROR'>;
};

/**
 * An operand that is a user-provided value.
 */
export type ValueOperand = {
  /**
   * Encoded value, which can be used directly in a JQL query.
   */
  encodedValue?: string;
  /**
   * The operand value.
   */
  value: string;
};

/**
 * Details about a project version.
 */
export type Version = {
  /**
   * If the expand option `approvers` is used, returns a list containing the approvers for this version.
   */
  readonly approvers?: Array<VersionApprover>;
  /**
   * Indicates that the version is archived. Optional when creating or updating a version.
   */
  archived?: boolean;
  /**
   * The description of the version. Optional when creating or updating a version. The maximum size is 16,384 bytes.
   */
  description?: string;
  /**
   * If the expand option `driver` is used, returns the Atlassian account ID of the driver.
   */
  readonly driver?: string;
  /**
   * Use [expand](em>#expansion) to include additional information about version in the response. This parameter accepts a comma-separated list. Expand options include:
   *
   * *  `operations` Returns the list of operations available for this version.
   * *  `issuesstatus` Returns the count of issues in this version for each of the status categories *to do*, *in progress*, *done*, and *unmapped*. The *unmapped* property contains a count of issues with a status other than *to do*, *in progress*, and *done*.
   * *  `driver` Returns the Atlassian account ID of the version driver.
   * *  `approvers` Returns a list containing approvers for this version.
   *
   * Optional for create and update.
   */
  expand?: string;
  /**
   * The ID of the version.
   */
  readonly id?: string;
  /**
   * If the expand option `issuesstatus` is used, returns the count of issues in this version for each of the status categories *to do*, *in progress*, *done*, and *unmapped*. The *unmapped* property contains a count of issues with a status other than *to do*, *in progress*, and *done*.
   */
  readonly issuesStatusForFixVersion?: VersionIssuesStatus;
  /**
   * The URL of the self link to the version to which all unfixed issues are moved when a version is released. Not applicable when creating a version. Optional when updating a version.
   */
  moveUnfixedIssuesTo?: string;
  /**
   * The unique name of the version. Required when creating a version. Optional when updating a version. The maximum length is 255 characters.
   */
  name?: string;
  /**
   * If the expand option `operations` is used, returns the list of operations available for this version.
   */
  readonly operations?: Array<SimpleLink>;
  /**
   * Indicates that the version is overdue.
   */
  readonly overdue?: boolean;
  /**
   * Deprecated. Use `projectId`.
   */
  project?: string;
  /**
   * The ID of the project to which this version is attached. Required when creating a version. Not applicable when updating a version.
   */
  projectId?: number;
  /**
   * The release date of the version. Expressed in ISO 8601 format (yyyy-mm-dd). Optional when creating or updating a version.
   */
  releaseDate?: string;
  /**
   * Indicates that the version is released. If the version is released a request to release again is ignored. Not applicable when creating a version. Optional when updating a version.
   */
  released?: boolean;
  /**
   * The URL of the version.
   */
  readonly self?: string;
  /**
   * The start date of the version. Expressed in ISO 8601 format (yyyy-mm-dd). Optional when creating or updating a version.
   */
  startDate?: string;
  /**
   * The date on which work on this version is expected to finish, expressed in the instance's *Day/Month/Year Format* date format.
   */
  readonly userReleaseDate?: string;
  /**
   * The date on which work on this version is expected to start, expressed in the instance's *Day/Month/Year Format* date format.
   */
  readonly userStartDate?: string;
};

/**
 * Contains details about a version approver.
 */
export type VersionApprover = {
  /**
   * The Atlassian account ID of the approver.
   */
  readonly accountId?: string;
  /**
   * A description of why the user is declining the approval.
   */
  readonly declineReason?: string;
  /**
   * A description of what the user is approving within the specified version.
   */
  readonly description?: string;
  /**
   * The status of the approval, which can be *PENDING*, *APPROVED*, or *DECLINED*
   */
  readonly status?: string;
};

/**
 * Various counts of issues within a version.
 */
export type VersionIssueCounts = {
  /**
   * List of custom fields using the version.
   */
  readonly customFieldUsage?: Array<VersionUsageInCustomField>;
  /**
   * Count of issues where a version custom field is set to the version.
   */
  readonly issueCountWithCustomFieldsShowingVersion?: number;
  /**
   * Count of issues where the `affectedVersion` is set to the version.
   */
  readonly issuesAffectedCount?: number;
  /**
   * Count of issues where the `fixVersion` is set to the version.
   */
  readonly issuesFixedCount?: number;
  /**
   * The URL of these count details.
   */
  readonly self?: string;
};

/**
 * Counts of the number of issues in various statuses.
 */
export type VersionIssuesStatus = {
  /**
   * Count of issues with status *done*.
   */
  readonly done?: number;
  /**
   * Count of issues with status *in progress*.
   */
  readonly inProgress?: number;
  /**
   * Count of issues with status *to do*.
   */
  readonly toDo?: number;
  /**
   * Count of issues with a status other than *to do*, *in progress*, and *done*.
   */
  readonly unmapped?: number;
};

export type VersionMoveBean = {
  /**
   * The URL (self link) of the version after which to place the moved version. Cannot be used with `position`.
   */
  after?: string;
  /**
   * An absolute position in which to place the moved version. Cannot be used with `after`.
   */
  position?: 'Earlier' | 'Later' | 'First' | 'Last';
};

/**
 * Associated related work to a version
 */
export type VersionRelatedWork = {
  /**
   * The category of the related work
   */
  category: string;
  /**
   * The ID of the issue associated with the related work (if there is one). Cannot be updated via the Rest API.
   */
  readonly issueId?: number;
  /**
   * The id of the related work. For the native release note related work item, this will be null, and Rest API does not support updating it.
   */
  readonly relatedWorkId?: string;
  /**
   * The title of the related work
   */
  title?: string;
  /**
   * The URL of the related work. Will be null for the native release note related work item, but is otherwise required.
   */
  url?: string;
};

/**
 * Count of a version's unresolved issues.
 */
export type VersionUnresolvedIssuesCount = {
  /**
   * Count of issues.
   */
  readonly issuesCount?: number;
  /**
   * Count of unresolved issues.
   */
  readonly issuesUnresolvedCount?: number;
  /**
   * The URL of these count details.
   */
  readonly self?: string;
};

/**
 * List of custom fields using the version.
 */
export type VersionUsageInCustomField = {
  /**
   * The ID of the custom field.
   */
  readonly customFieldId?: number;
  /**
   * The name of the custom field.
   */
  readonly fieldName?: string;
  /**
   * Count of the issues where the custom field contains the version.
   */
  readonly issueCountWithVersionInCustomField?: number;
};

/**
 * The group or role to which this item is visible.
 */
export type Visibility = {
  /**
   * The ID of the group or the name of the role that visibility of this item is restricted to.
   */
  identifier?: string | null;
  /**
   * Whether visibility of this item is restricted to a group or role.
   */
  type?: 'group' | 'role';
  /**
   * The name of the group or role that visibility of this item is restricted to. Please note that the name of a group is mutable, to reliably identify a group use `identifier`.
   */
  value?: string;
};

/**
 * Whether visibility of this item is restricted to a group or role.
 */
export type type14 = 'group' | 'role';

/**
 * The details of votes on an issue.
 */
export type Votes = {
  /**
   * Whether the user making this request has voted on the issue.
   */
  readonly hasVoted?: boolean;
  /**
   * The URL of these issue vote details.
   */
  readonly self?: string;
  /**
   * List of the users who have voted on this issue. An empty list is returned when the calling user doesn't have the *View voters and watchers* project permission.
   */
  readonly voters?: Array<User>;
  /**
   * The number of votes on the issue.
   */
  readonly votes?: number;
};

export type WarningCollection = {
  warnings?: Array<string>;
};

/**
 * The details of watchers on an issue.
 */
export type Watchers = {
  /**
   * Whether the calling user is watching this issue.
   */
  readonly isWatching?: boolean;
  /**
   * The URL of these issue watcher details.
   */
  readonly self?: string;
  /**
   * The number of users watching this issue.
   */
  readonly watchCount?: number;
  /**
   * Details of the users watching this issue.
   */
  readonly watchers?: Array<UserDetails>;
};

/**
 * A webhook.
 */
export type Webhook = {
  /**
   * The Jira events that trigger the webhook.
   */
  events: Array<
    | 'jira:issue_created'
    | 'jira:issue_updated'
    | 'jira:issue_deleted'
    | 'comment_created'
    | 'comment_updated'
    | 'comment_deleted'
    | 'issue_property_set'
    | 'issue_property_deleted'
  >;
  /**
   * The date after which the webhook is no longer sent. Use [Extend webhook life](https://developer.atlassian.com/cloud/jira/platform/rest/v3/api-group-webhooks/#api-rest-api-3-webhook-refresh-put) to extend the date.
   */
  readonly expirationDate?: number;
  /**
   * A list of field IDs. When the issue changelog contains any of the fields, the webhook `jira:issue_updated` is sent. If this parameter is not present, the app is notified about all field updates.
   */
  fieldIdsFilter?: Array<string>;
  /**
   * The ID of the webhook.
   */
  id: number;
  /**
   * A list of issue property keys. A change of those issue properties triggers the `issue_property_set` or `issue_property_deleted` webhooks. If this parameter is not present, the app is notified about all issue property updates.
   */
  issuePropertyKeysFilter?: Array<string>;
  /**
   * The JQL filter that specifies which issues the webhook is sent for.
   */
  jqlFilter: string;
};

/**
 * A list of webhooks.
 */
export type WebhookDetails = {
  /**
   * The Jira events that trigger the webhook.
   */
  events: Array<
    | 'jira:issue_created'
    | 'jira:issue_updated'
    | 'jira:issue_deleted'
    | 'comment_created'
    | 'comment_updated'
    | 'comment_deleted'
    | 'issue_property_set'
    | 'issue_property_deleted'
  >;
  /**
   * A list of field IDs. When the issue changelog contains any of the fields, the webhook `jira:issue_updated` is sent. If this parameter is not present, the app is notified about all field updates.
   */
  fieldIdsFilter?: Array<string>;
  /**
   * A list of issue property keys. A change of those issue properties triggers the `issue_property_set` or `issue_property_deleted` webhooks. If this parameter is not present, the app is notified about all issue property updates.
   */
  issuePropertyKeysFilter?: Array<string>;
  /**
   * The JQL filter that specifies which issues the webhook is sent for. Only a subset of JQL can be used. The supported elements are:
   *
   * *  Fields: `issueKey`, `project`, `issuetype`, `status`, `assignee`, `reporter`, `issue.property`, and `cf[id]`. For custom fields (`cf[id]`), only the epic label custom field is supported.".
   * *  Operators: `=`, `!=`, `IN`, and `NOT IN`.
   */
  jqlFilter: string;
};

/**
 * Details of webhooks to register.
 */
export type WebhookRegistrationDetails = {
  /**
   * The URL that specifies where to send the webhooks. This URL must use the same base URL as the Connect app. Only a single URL per app is allowed to be registered.
   */
  url: string;
  /**
   * A list of webhooks.
   */
  webhooks: Array<WebhookDetails>;
};

/**
 * The date the refreshed webhooks expire.
 */
export type WebhooksExpirationDate = {
  /**
   * The expiration date of all the refreshed webhooks.
   */
  readonly expirationDate: number;
};

export type WorkManagementNavigationInfo = {
  boardName?: string;
};

/**
 * Details about a workflow.
 */
export type Workflow = {
  /**
   * The creation date of the workflow.
   */
  created?: string;
  /**
   * The description of the workflow.
   */
  description: string;
  /**
   * Whether the workflow has a draft version.
   */
  hasDraftWorkflow?: boolean;
  id: PublishedWorkflowId;
  /**
   * Whether this is the default workflow.
   */
  isDefault?: boolean;
  operations?: WorkflowOperations;
  /**
   * The projects the workflow is assigned to, through workflow schemes.
   */
  projects?: Array<ProjectDetails>;
  /**
   * The workflow schemes the workflow is assigned to.
   */
  schemes?: Array<WorkflowSchemeIdName>;
  /**
   * The statuses of the workflow.
   */
  statuses?: Array<WorkflowStatus>;
  /**
   * The transitions of the workflow.
   */
  transitions?: Array<Transition>;
  /**
   * The last edited date of the workflow.
   */
  updated?: string;
};

/**
 * The list of status mappings.
 */
export type WorkflowAssociationStatusMapping = {
  /**
   * The ID of the status in the new workflow.
   */
  newStatusId: string;
  /**
   * The ID of the status in the old workflow that isn't present in the new workflow.
   */
  oldStatusId: string;
};

export type WorkflowCapabilities = {
  /**
   * The Connect provided ecosystem rules available.
   */
  connectRules?: Array<AvailableWorkflowConnectRule>;
  /**
   * The scope of the workflow capabilities. `GLOBAL` for company-managed projects and `PROJECT` for team-managed projects.
   */
  editorScope?: 'PROJECT' | 'GLOBAL';
  /**
   * The Forge provided ecosystem rules available.
   */
  forgeRules?: Array<AvailableWorkflowForgeRule>;
  /**
   * The types of projects that this capability set is available for.
   */
  projectTypes?: Array<'software' | 'service_desk' | 'product_discovery' | 'business' | 'unknown'>;
  /**
   * The Atlassian provided system rules available.
   */
  systemRules?: Array<AvailableWorkflowSystemRule>;
  /**
   * The trigger rules available.
   */
  triggerRules?: Array<AvailableWorkflowTriggers>;
};

/**
 * The scope of the workflow capabilities. `GLOBAL` for company-managed projects and `PROJECT` for team-managed projects.
 */
export type editorScope = 'PROJECT' | 'GLOBAL';

/**
 * A compound workflow transition rule condition. This object returns `nodeType` as `compound`.
 */
export type WorkflowCompoundCondition = {
  /**
   * The list of workflow conditions.
   */
  conditions: Array<WorkflowCondition>;
  nodeType: 'compound';
  /**
   * The compound condition operator.
   */
  operator: 'AND' | 'OR';
};

/**
 * The workflow transition rule conditions tree.
 */
export type WorkflowCondition = WorkflowSimpleCondition | WorkflowCompoundCondition;

/**
 * The details of the workflows to create.
 */
export type WorkflowCreate = {
  /**
   * The description of the workflow to create.
   */
  description?: string;
  /**
   * The name of the workflow to create.
   */
  name: string;
  startPointLayout?: WorkflowLayout;
  /**
   * The statuses associated with this workflow.
   */
  statuses: Array<StatusLayoutUpdate>;
  /**
   * The transitions of this workflow.
   */
  transitions: Array<TransitionUpdateDTO>;
};

/**
 * The create workflows payload.
 */
export type WorkflowCreateRequest = {
  scope: WorkflowScope;
  /**
   * The statuses to associate with the workflows.
   */
  statuses: Array<WorkflowStatusUpdate>;
  /**
   * The details of the workflows to create.
   */
  workflows: Array<WorkflowCreate>;
};

/**
 * Details of the created workflows and statuses.
 */
export type WorkflowCreateResponse = {
  /**
   * List of created statuses.
   */
  statuses?: Array<JiraWorkflowStatus>;
  /**
   * List of created workflows.
   */
  workflows?: Array<JiraWorkflow>;
};

export type WorkflowCreateValidateRequest = {
  payload: WorkflowCreateRequest;
  validationOptions?: ValidationOptionsForCreate;
};

/**
 * A reference to the location of the error. This will be null if the error does not refer to a specific element.
 */
export type WorkflowElementReference = {
  /**
   * A property key.
   */
  propertyKey?: string;
  /**
   * A rule ID.
   */
  ruleId?: string;
  statusMappingReference?: ProjectAndIssueTypePair;
  /**
   * A status reference.
   */
  statusReference?: string;
  /**
   * A transition ID.
   */
  transitionId?: string;
};

/**
 * The classic workflow identifiers.
 */
export type WorkflowIDs = {
  /**
   * The entity ID of the workflow.
   */
  entityId?: string;
  /**
   * The name of the workflow.
   */
  name: string;
};

/**
 * Properties that identify a workflow.
 */
export type WorkflowId = {
  /**
   * Whether the workflow is in the draft state.
   */
  draft: boolean;
  /**
   * The name of the workflow.
   */
  name: string;
};

/**
 * The starting point for the statuses in the workflow.
 */
export type WorkflowLayout = {
  /**
   * The x axis location.
   */
  x?: number;
  /**
   * The y axis location.
   */
  y?: number;
} | null;

/**
 * The workflow metadata and issue type IDs which use this workflow.
 */
export type WorkflowMetadataAndIssueTypeRestModel = {
  /**
   * The list of issue type IDs for the mapping.
   */
  issueTypeIds: Array<string>;
  workflow: WorkflowMetadataRestModel;
};

/**
 * Workflow metadata and usage detail.
 */
export type WorkflowMetadataRestModel = {
  /**
   * The description of the workflow.
   */
  description: string;
  /**
   * The ID of the workflow.
   */
  id: string;
  /**
   * The name of the workflow.
   */
  name: string;
  /**
   * Use the optional `workflows.usages` expand to get additional information about the projects and issue types associated with the workflows in the workflow scheme.
   */
  usage: Array<SimpleUsage>;
  version: DocumentVersion;
};

/**
 * Operations allowed on a workflow
 */
export type WorkflowOperations = {
  /**
   * Whether the workflow can be deleted.
   */
  canDelete: boolean;
  /**
   * Whether the workflow can be updated.
   */
  canEdit: boolean;
};

export type WorkflowReadRequest = {
  /**
   * The list of projects and issue types to query.
   */
  projectAndIssueTypes?: Array<ProjectAndIssueTypePair>;
  /**
   * The list of workflow IDs to query.
   */
  workflowIds?: Array<string>;
  /**
   * The list of workflow names to query.
   */
  workflowNames?: Array<string>;
};

/**
 * Details of workflows and related statuses.
 */
export type WorkflowReadResponse = {
  /**
   * List of statuses.
   */
  statuses?: Array<JiraWorkflowStatus>;
  /**
   * List of workflows.
   */
  workflows?: Array<JiraWorkflow>;
};

/**
 * The statuses referenced in the workflow.
 */
export type WorkflowReferenceStatus = {
  approvalConfiguration?: ApprovalConfiguration;
  /**
   * Indicates if the status is deprecated.
   */
  deprecated?: boolean;
  layout?: WorkflowStatusLayout;
  /**
   * The properties associated with the status.
   */
  properties?: {
    [key: string]: string;
  };
  /**
   * The reference of the status.
   */
  statusReference?: string;
};

/**
 * The configuration of the rule.
 */
export type WorkflowRuleConfiguration = {
  /**
   * The ID of the rule.
   */
  id?: string | null;
  /**
   * The parameters related to the rule.
   */
  parameters?: {
    [key: string]: string;
  };
  /**
   * The rule key of the rule.
   */
  ruleKey: string;
} | null;

/**
 * A collection of transition rules.
 */
export type WorkflowRules = {
  conditionsTree?: WorkflowCondition;
  /**
   * The workflow post functions.
   */
  postFunctions?: Array<WorkflowTransitionRule>;
  /**
   * The workflow validators.
   */
  validators?: Array<WorkflowTransitionRule>;
};

/**
 * Details of the workflow and its transition rules.
 */
export type WorkflowRulesSearch = {
  /**
   * Use expand to include additional information in the response. This parameter accepts `transition` which, for each rule, returns information about the transition the rule is assigned to.
   */
  expand?: string;
  /**
   * The list of workflow rule IDs.
   */
  ruleIds: Array<string>;
  /**
   * The workflow ID.
   */
  workflowEntityId: string;
};

/**
 * Details of workflow transition rules.
 */
export type WorkflowRulesSearchDetails = {
  /**
   * List of workflow rule IDs that do not belong to the workflow or can not be found.
   */
  invalidRules?: Array<string>;
  /**
   * List of valid workflow transition rules.
   */
  validRules?: Array<WorkflowTransitionRules>;
  /**
   * The workflow ID.
   */
  workflowEntityId?: string;
};

/**
 * Details about a workflow scheme.
 */
export type WorkflowScheme = {
  /**
   * The name of the default workflow for the workflow scheme. The default workflow has *All Unassigned Issue Types* assigned to it in Jira. If `defaultWorkflow` is not specified when creating a workflow scheme, it is set to *Jira Workflow (jira)*.
   */
  defaultWorkflow?: string;
  /**
   * The description of the workflow scheme.
   */
  description?: string;
  /**
   * Whether the workflow scheme is a draft or not.
   */
  readonly draft?: boolean;
  /**
   * The ID of the workflow scheme.
   */
  readonly id?: number;
  /**
   * The issue type to workflow mappings, where each mapping is an issue type ID and workflow name pair. Note that an issue type can only be mapped to one workflow in a workflow scheme.
   */
  issueTypeMappings?: {
    [key: string]: string;
  };
  /**
   * The issue types available in Jira.
   */
  readonly issueTypes?: {
    [key: string]: IssueTypeDetails;
  };
  /**
   * The date-time that the draft workflow scheme was last modified. A modification is a change to the issue type-project mappings only. This property does not apply to non-draft workflows.
   */
  readonly lastModified?: string;
  /**
   * The user that last modified the draft workflow scheme. A modification is a change to the issue type-project mappings only. This property does not apply to non-draft workflows.
   */
  readonly lastModifiedUser?: User;
  /**
   * The name of the workflow scheme. The name must be unique. The maximum length is 255 characters. Required when creating a workflow scheme.
   */
  name?: string;
  /**
   * For draft workflow schemes, this property is the name of the default workflow for the original workflow scheme. The default workflow has *All Unassigned Issue Types* assigned to it in Jira.
   */
  readonly originalDefaultWorkflow?: string;
  /**
   * For draft workflow schemes, this property is the issue type to workflow mappings for the original workflow scheme, where each mapping is an issue type ID and workflow name pair. Note that an issue type can only be mapped to one workflow in a workflow scheme.
   */
  readonly originalIssueTypeMappings?: {
    [key: string]: string;
  };
  readonly self?: string;
  /**
   * Whether to create or update a draft workflow scheme when updating an active workflow scheme. An active workflow scheme is a workflow scheme that is used by at least one project. The following examples show how this property works:
   *
   * *  Update an active workflow scheme with `updateDraftIfNeeded` set to `true`: If a draft workflow scheme exists, it is updated. Otherwise, a draft workflow scheme is created.
   * *  Update an active workflow scheme with `updateDraftIfNeeded` set to `false`: An error is returned, as active workflow schemes cannot be updated.
   * *  Update an inactive workflow scheme with `updateDraftIfNeeded` set to `true`: The workflow scheme is updated, as inactive workflow schemes do not require drafts to update.
   *
   * Defaults to `false`.
   */
  updateDraftIfNeeded?: boolean;
};

/**
 * The explicit association between issue types and a workflow in a workflow scheme.
 */
export type WorkflowSchemeAssociation = {
  /**
   * The issue types assigned to the workflow.
   */
  issueTypeIds: Array<string>;
  /**
   * The ID of the workflow.
   */
  workflowId: string;
};

/**
 * A workflow scheme along with a list of projects that use it.
 */
export type WorkflowSchemeAssociations = {
  /**
   * The list of projects that use the workflow scheme.
   */
  projectIds: Array<string>;
  /**
   * The workflow scheme.
   */
  workflowScheme: WorkflowScheme;
};

/**
 * The ID and the name of the workflow scheme.
 */
export type WorkflowSchemeIdName = {
  /**
   * The ID of the workflow scheme.
   */
  id: string;
  /**
   * The name of the workflow scheme.
   */
  name: string;
};

/**
 * An associated workflow scheme and project.
 */
export type WorkflowSchemeProjectAssociation = {
  /**
   * The ID of the project.
   */
  projectId: string;
  /**
   * The ID of the workflow scheme. If the workflow scheme ID is `null`, the operation assigns the default workflow scheme.
   */
  workflowSchemeId?: string;
};

/**
 * The workflow scheme read request body.
 */
export type WorkflowSchemeReadRequest = {
  /**
   * The list of project IDs to query.
   */
  projectIds?: Array<string | null> | null;
  /**
   * The list of workflow scheme IDs to query.
   */
  workflowSchemeIds?: Array<string | null> | null;
};

export type WorkflowSchemeReadResponse = {
  defaultWorkflow?: WorkflowMetadataRestModel;
  /**
   * The description of the workflow scheme.
   */
  description?: string | null;
  /**
   * The ID of the workflow scheme.
   */
  id: string;
  /**
   * The name of the workflow scheme.
   */
  name: string;
  /**
   * The IDs of projects using the workflow scheme.
   */
  projectIdsUsingScheme: Array<string>;
  scope: WorkflowScope;
  /**
   * Indicates if there's an [asynchronous task](#async-operations) for this workflow scheme.
   */
  taskId?: string | null;
  version: DocumentVersion;
  /**
   * Mappings from workflows to issue types.
   */
  workflowsForIssueTypes: Array<WorkflowMetadataAndIssueTypeRestModel>;
};

/**
 * The update workflow scheme payload.
 */
export type WorkflowSchemeUpdateRequest = {
  /**
   * The ID of the workflow for issue types without having a mapping defined in this workflow scheme. Only used in global-scoped workflow schemes. If the `defaultWorkflowId` isn't specified, this is set to *Jira Workflow (jira)*.
   */
  defaultWorkflowId?: string;
  /**
   * The new description for this workflow scheme.
   */
  description: string;
  /**
   * The ID of this workflow scheme.
   */
  id: string;
  /**
   * The new name for this workflow scheme.
   */
  name: string;
  /**
   * Overrides, for the selected issue types, any status mappings provided in `statusMappingsByWorkflows`. Status mappings are required when the new workflow for an issue type doesn't contain all statuses that the old workflow has. Status mappings can be provided by a combination of `statusMappingsByWorkflows` and `statusMappingsByIssueTypeOverride`.
   */
  statusMappingsByIssueTypeOverride?: Array<MappingsByIssueTypeOverride>;
  /**
   * The status mappings by workflows. Status mappings are required when the new workflow for an issue type doesn't contain all statuses that the old workflow has. Status mappings can be provided by a combination of `statusMappingsByWorkflows` and `statusMappingsByIssueTypeOverride`.
   */
  statusMappingsByWorkflows?: Array<MappingsByWorkflow>;
  version: DocumentVersion;
  /**
   * Mappings from workflows to issue types.
   */
  workflowsForIssueTypes?: Array<WorkflowSchemeAssociation>;
};

/**
 * The request payload to get the required mappings for updating a workflow scheme.
 */
export type WorkflowSchemeUpdateRequiredMappingsRequest = {
  /**
   * The ID of the new default workflow for this workflow scheme. Only used in global-scoped workflow schemes. If it isn't specified, is set to *Jira Workflow (jira)*.
   */
  defaultWorkflowId?: string | null;
  /**
   * The ID of the workflow scheme.
   */
  id: string;
  /**
   * The new workflow to issue type mappings for this workflow scheme.
   */
  workflowsForIssueTypes: Array<WorkflowSchemeAssociation>;
};

export type WorkflowSchemeUpdateRequiredMappingsResponse = {
  /**
   * The list of required status mappings by issue type.
   */
  statusMappingsByIssueTypes?: Array<RequiredMappingByIssueType>;
  /**
   * The list of required status mappings by workflow.
   */
  statusMappingsByWorkflows?: Array<RequiredMappingByWorkflows>;
  /**
   * The details of the statuses in the associated workflows.
   */
  statuses?: Array<StatusMetadata>;
  /**
   * The statuses associated with each workflow.
   */
  statusesPerWorkflow?: Array<StatusesPerWorkflow>;
};

/**
 * The scope of the workflow.
 */
export type WorkflowScope = {
  project?: ProjectId;
  /**
   * The scope of the workflow. `GLOBAL` for company-managed projects and `PROJECT` for team-managed projects.
   */
  type: 'PROJECT' | 'GLOBAL';
};

/**
 * A workflow transition rule condition. This object returns `nodeType` as `simple`.
 */
export type WorkflowSimpleCondition = {
  /**
   * EXPERIMENTAL. The configuration of the transition rule.
   */
  configuration?: {
    [key: string]: string;
  };
  nodeType: 'simple';
  /**
   * The type of the transition rule.
   */
  type: string;
};

/**
 * Details of a workflow status.
 */
export type WorkflowStatus = {
  /**
   * The ID of the issue status.
   */
  id: string;
  /**
   * The name of the status in the workflow.
   */
  name: string;
  /**
   * Additional properties that modify the behavior of issues in this status. Supports the properties `jira.issue.editable` and `issueEditable` (deprecated) that indicate whether issues are editable.
   */
  properties?: {
    [key: string]: string;
  };
};

/**
 * The status reference and port that a transition is connected to.
 * @deprecated
 */
export type WorkflowStatusAndPort = {
  /**
   * The port the transition is connected to this status.
   */
  port?: number | null;
  /**
   * The reference of this status.
   */
  statusReference?: string;
} | null;

/**
 * The x and y location of the status in the workflow.
 */
export type WorkflowStatusLayout = {
  /**
   * The x axis location.
   */
  x?: number | null;
  /**
   * The y axis location.
   */
  y?: number | null;
} | null;

/**
 * Details of the status being updated.
 */
export type WorkflowStatusUpdate = {
  /**
   * The description of the status.
   */
  description?: string;
  /**
   * The ID of the status.
   */
  id?: string;
  /**
   * The name of the status.
   */
  name: string;
  /**
   * The category of the status.
   */
  statusCategory: 'TODO' | 'IN_PROGRESS' | 'DONE';
  /**
   * The reference of the status.
   */
  statusReference: string;
};

/**
 * A workflow transition.
 */
export type WorkflowTransition = {
  /**
   * The transition ID.
   */
  id: number;
  /**
   * The transition name.
   */
  name: string;
};

/**
 * The statuses the transition can start from, and the mapping of ports between the statuses.
 */
export type WorkflowTransitionLinks = {
  /**
   * The port that the transition starts from.
   */
  fromPort?: number | null;
  /**
   * The status that the transition starts from.
   */
  fromStatusReference?: string | null;
  /**
   * The port that the transition goes to.
   */
  toPort?: number | null;
} | null;

/**
 * Details about the server Jira is running on.
 */
export type WorkflowTransitionProperty = {
  /**
   * The ID of the transition property.
   */
  readonly id?: string;
  /**
   * The key of the transition property. Also known as the name of the transition property.
   */
  readonly key?: string;
  /**
   * The value of the transition property.
   */
  value: string;
};

/**
 * A workflow transition rule.
 */
export type WorkflowTransitionRule = {
  /**
   * EXPERIMENTAL. The configuration of the transition rule.
   */
  configuration?: string;
  /**
   * The type of the transition rule.
   */
  type: string;
};

/**
 * A workflow with transition rules.
 */
export type WorkflowTransitionRules = {
  /**
   * The list of conditions within the workflow.
   */
  conditions?: Array<AppWorkflowTransitionRule>;
  /**
   * The list of post functions within the workflow.
   */
  postFunctions?: Array<AppWorkflowTransitionRule>;
  /**
   * The list of validators within the workflow.
   */
  validators?: Array<AppWorkflowTransitionRule>;
  workflowId: WorkflowId;
};

/**
 * Details about a workflow configuration update request.
 */
export type WorkflowTransitionRulesDetails = {
  workflowId: WorkflowId;
  /**
   * The list of connect workflow rule IDs.
   */
  workflowRuleIds: Array<string>;
};

/**
 * Details about a workflow configuration update request.
 */
export type WorkflowTransitionRulesUpdate = {
  /**
   * The list of workflows with transition rules to update.
   */
  workflows: Array<WorkflowTransitionRules>;
};

/**
 * Details of any errors encountered while updating workflow transition rules for a workflow.
 */
export type WorkflowTransitionRulesUpdateErrorDetails = {
  /**
   * A list of transition rule update errors, indexed by the transition rule ID. Any transition rule that appears here wasn't updated.
   */
  ruleUpdateErrors: {
    [key: string]: Array<string>;
  };
  /**
   * The list of errors that specify why the workflow update failed. The workflow was not updated if the list contains any entries.
   */
  updateErrors: Array<string>;
  workflowId: WorkflowId;
};

/**
 * Details of any errors encountered while updating workflow transition rules.
 */
export type WorkflowTransitionRulesUpdateErrors = {
  /**
   * A list of workflows.
   */
  updateResults: Array<WorkflowTransitionRulesUpdateErrorDetails>;
};

/**
 * The transitions of the workflow. Note that a transition can have either the deprecated `to`/`from` fields or the `toStatusReference`/`links` fields, but never both nor a combination.
 */
export type WorkflowTransitions = {
  /**
   * The post-functions of the transition.
   */
  actions?: Array<WorkflowRuleConfiguration>;
  conditions?: ConditionGroupConfiguration;
  /**
   * The custom event ID of the transition.
   */
  customIssueEventId?: string | null;
  /**
   * The description of the transition.
   */
  description?: string;
  /**
   * The statuses and ports that the transition can start from. This field is deprecated - use `toStatusReference`/`links` instead.
   * @deprecated
   */
  from?: Array<WorkflowStatusAndPort>;
  /**
   * The ID of the transition.
   */
  id?: string;
  /**
   * The statuses the transition can start from, and the mapping of ports between the statuses.
   */
  links?: Array<WorkflowTransitionLinks>;
  /**
   * The name of the transition.
   */
  name?: string;
  /**
   * The properties of the transition.
   */
  properties?: {
    [key: string]: string;
  };
  to?: WorkflowStatusAndPort;
  /**
   * The status the transition goes to.
   */
  toStatusReference?: string;
  transitionScreen?: WorkflowRuleConfiguration;
  /**
   * The triggers of the transition.
   */
  triggers?: Array<WorkflowTrigger>;
  /**
   * The transition type.
   */
  type?: 'INITIAL' | 'GLOBAL' | 'DIRECTED';
  /**
   * The validators of the transition.
   */
  validators?: Array<WorkflowRuleConfiguration>;
};

/**
 * The trigger configuration associated with a workflow.
 */
export type WorkflowTrigger = {
  /**
   * The ID of the trigger.
   */
  id?: string;
  /**
   * The parameters of the trigger.
   */
  parameters: {
    [key: string]: string;
  };
  /**
   * The rule key of the trigger.
   */
  ruleKey: string;
};

/**
 * The details of the workflows to update.
 */
export type WorkflowUpdate = {
  /**
   * The mapping of old to new status ID.
   */
  defaultStatusMappings?: Array<StatusMigration>;
  /**
   * The new description for this workflow.
   */
  description?: string;
  /**
   * The ID of this workflow.
   */
  id: string;
  startPointLayout?: WorkflowLayout;
  /**
   * The mapping of old to new status ID for a specific project and issue type.
   */
  statusMappings?: Array<StatusMappingDTO>;
  /**
   * The statuses associated with this workflow.
   */
  statuses: Array<StatusLayoutUpdate>;
  /**
   * The transitions of this workflow.
   */
  transitions: Array<TransitionUpdateDTO>;
  version: DocumentVersion;
};

/**
 * The update workflows payload.
 */
export type WorkflowUpdateRequest = {
  /**
   * The statuses to associate with the workflows.
   */
  statuses: Array<WorkflowStatusUpdate>;
  /**
   * The details of the workflows to update.
   */
  workflows: Array<WorkflowUpdate>;
};

export type WorkflowUpdateResponse = {
  /**
   * List of updated statuses.
   */
  statuses?: Array<JiraWorkflowStatus>;
  /**
   * If there is a [asynchronous task](#async-operations) operation, as a result of this update.
   */
  taskId?: string | null;
  /**
   * List of updated workflows.
   */
  workflows?: Array<JiraWorkflow>;
};

export type WorkflowUpdateValidateRequestBean = {
  payload: WorkflowUpdateRequest;
  validationOptions?: ValidationOptionsForUpdate;
};

/**
 * The workflows that use this status. Only available if the `workflowUsages` expand is requested.
 */
export type WorkflowUsages = {
  /**
   * Workflow ID.
   */
  workflowId?: string;
  /**
   * Workflow name.
   */
  workflowName?: string;
};

/**
 * The details about a workflow validation error.
 */
export type WorkflowValidationError = {
  /**
   * An error code.
   */
  code?: string;
  elementReference?: WorkflowElementReference;
  /**
   * The validation error level.
   */
  level?: 'WARNING' | 'ERROR';
  /**
   * An error message.
   */
  message?: string;
  /**
   * The type of element the error or warning references.
   */
  type?:
    | 'RULE'
    | 'STATUS'
    | 'STATUS_LAYOUT'
    | 'STATUS_PROPERTY'
    | 'WORKFLOW'
    | 'TRANSITION'
    | 'TRANSITION_PROPERTY'
    | 'SCOPE'
    | 'STATUS_MAPPING'
    | 'TRIGGER';
};

/**
 * The validation error level.
 */
export type level = 'WARNING' | 'ERROR';

/**
 * The type of element the error or warning references.
 */
export type type15 =
  | 'RULE'
  | 'STATUS'
  | 'STATUS_LAYOUT'
  | 'STATUS_PROPERTY'
  | 'WORKFLOW'
  | 'TRANSITION'
  | 'TRANSITION_PROPERTY'
  | 'SCOPE'
  | 'STATUS_MAPPING'
  | 'TRIGGER';

export type WorkflowValidationErrorList = {
  /**
   * The list of validation errors.
   */
  errors?: Array<WorkflowValidationError>;
};

/**
 * Details of workflows and their transition rules to delete.
 */
export type WorkflowsWithTransitionRulesDetails = {
  /**
   * The list of workflows with transition rules to delete.
   */
  workflows: Array<WorkflowTransitionRulesDetails>;
};

/**
 * Details of a worklog.
 */
export type Worklog = {
  /**
   * Details of the user who created the worklog.
   */
  readonly author?: UserDetails;
  /**
   * A comment about the worklog in [Atlassian Document Format](https://developer.atlassian.com/cloud/jira/platform/apis/document/structure/). Optional when creating or updating a worklog.
   */
  comment?: string;
  /**
   * The datetime on which the worklog was created.
   */
  readonly created?: string;
  /**
   * The ID of the worklog record.
   */
  readonly id?: string;
  /**
   * The ID of the issue this worklog is for.
   */
  readonly issueId?: string;
  /**
   * Details of properties for the worklog. Optional when creating or updating a worklog.
   */
  properties?: Array<EntityProperty>;
  /**
   * The URL of the worklog item.
   */
  readonly self?: string;
  /**
   * The datetime on which the worklog effort was started. Required when creating a worklog. Optional when updating a worklog.
   */
  started?: string;
  /**
   * The time spent working on the issue as days (\#d), hours (\#h), or minutes (\#m or \#). Required when creating a worklog if `timeSpentSeconds` isn't provided. Optional when updating a worklog. Cannot be provided if `timeSpentSecond` is provided.
   */
  timeSpent?: string;
  /**
   * The time in seconds spent working on the issue. Required when creating a worklog if `timeSpent` isn't provided. Optional when updating a worklog. Cannot be provided if `timeSpent` is provided.
   */
  timeSpentSeconds?: number;
  /**
   * Details of the user who last updated the worklog.
   */
  readonly updateAuthor?: UserDetails;
  /**
   * The datetime on which the worklog was last updated.
   */
  readonly updated?: string;
  /**
   * Details about any restrictions in the visibility of the worklog. Optional when creating or updating a worklog.
   */
  visibility?: Visibility;
};

export type WorklogIdsRequestBean = {
  /**
   * A list of worklog IDs.
   */
  ids: Array<number>;
};

export type WorklogsMoveRequestBean = {
  /**
   * A list of worklog IDs.
   */
  ids?: Array<number>;
  /**
   * The issue id or key of the destination issue
   */
  issueIdOrKey?: string;
};

/**
 * Details about data policy.
 */
export type WorkspaceDataPolicy = {
  /**
   * Whether the workspace contains any content inaccessible to the requesting application.
   */
  readonly anyContentBlocked?: boolean;
};

/**
 * Can contain multiple field values of following types depending on `type` key
 */
export type fields =
  | MandatoryFieldValue
  | MandatoryFieldValueForADF
  | {
      /**
       * If `true`, will try to retain original non-null issue field values on move.
       */
      retain?: boolean | null;
      type: 'adf' | 'raw';
      value?: {
        [key: string]: string;
      };
    };

/**
 * Classification mapping for classifications in source issues to respective target classification.
 */
export type targetClassification = {
  /**
   * An object with the key as the ID of the target classification and value with the list of the IDs of the current source classifications.
   */
  classifications: {
    [key: string]: Array<string>;
  };
  /**
   * ID of the source issueType to which issues present in `issueIdOrKeys` belongs.
   */
  issueType?: string;
  /**
   * ID or key of the source project to which issues present in `issueIdOrKeys` belongs.
   */
  projectKeyOrId?: string;
} | null;

/**
 * Field mapping for mandatory fields in target
 */
export type targetMandatoryFields = {
  /**
   * Contains the value of mandatory fields
   */
  fields: {
    [key: string]: fields;
  };
} | null;

/**
 * Status mapping for statuses in source workflow to respective target status in target workflow.
 */
export type targetStatus = {
  /**
   * An object with the key as the ID of the target status and value with the list of the IDs of the current source statuses.
   */
  statuses: {
    [key: string]: Array<string>;
  };
} | null;

/**
 * An object representing the mapping of issues and data related to destination entities, like fields and statuses, that are required during a bulk move.
 */
export type targetToSourcesMapping = {
  /**
   * If `true`, when issues are moved into this target group, they will adopt the target project's default classification, if they don't have a classification already. If they do have a classification, it will be kept the same even after the move. Leave `targetClassification` empty when using this.
   *
   * If `false`, you must provide a `targetClassification` mapping for each classification associated with the selected issues.
   *
   * [Benefit from data classification](https://support.atlassian.com/security-and-access-policies/docs/what-is-data-classification/)
   */
  inferClassificationDefaults: boolean;
  /**
   * If `true`, values from the source issues will be retained for the mandatory fields in the field configuration of the destination project. The `targetMandatoryFields` property shouldn't be defined.
   *
   * If `false`, the user is required to set values for mandatory fields present in the field configuration of the destination project. Provide input by defining the `targetMandatoryFields` property
   */
  inferFieldDefaults: boolean;
  /**
   * If `true`, the statuses of issues being moved in this target group that are not present in the target workflow will be changed to the default status of the target workflow (see below). Leave `targetStatus` empty when using this.
   *
   * If `false`, you must provide a `targetStatus` for each status not present in the target workflow.
   *
   * The default status in a workflow is referred to as the "initial status". Each workflow has its own unique initial status. When an issue is created, it is automatically assigned to this initial status. Read more about configuring initial statuses: [Configure the initial status | Atlassian Support.](https://support.atlassian.com/jira-cloud-administration/docs/configure-the-initial-status/)
   */
  inferStatusDefaults: boolean;
  /**
   * When an issue is moved, its subtasks (if there are any) need to be moved with it. `inferSubtaskTypeDefault` helps with moving the subtasks by picking a random subtask type in the target project.
   *
   * If `true`, subtasks will automatically move to the same project as their parent.
   *
   * When they move:
   *
   * *  Their `issueType` will be set to the default for subtasks in the target project.
   * *  Values for mandatory fields will be retained from the source issues
   * *  Specifying separate mapping for implicit subtasks won’t be allowed.
   *
   * If `false`, you must manually move the subtasks. They will retain the parent which they had in the current project after being moved.
   */
  inferSubtaskTypeDefault: boolean;
  /**
   * List of issue IDs or keys to be moved. These issues must be from the same project, have the same issue type, and be from the same parent (if they’re subtasks).
   */
  issueIdsOrKeys?: Array<string>;
  /**
   * List of the objects containing classifications in the source issues and their new values which need to be set during the bulk move operation.
   *
   * *  **You should only define this property when `inferClassificationDefaults` is `false`.**
   * *  **In order to provide mapping for issues which don't have a classification, use `"-1"`.**
   */
  targetClassification?: Array<targetClassification> | null;
  /**
   * List of objects containing mandatory fields in the target field configuration and new values that need to be set during the bulk move operation.
   *
   * The new values will only be applied if the field is mandatory in the target project and at least one issue from the source has that field empty, or if the field context is different in the target project (e.g. project-scoped version fields).
   *
   * **You should only define this property when `inferFieldDefaults` is `false`.**
   */
  targetMandatoryFields?: Array<targetMandatoryFields> | null;
  /**
   * List of the objects containing statuses in the source workflow and their new values which need to be set during the bulk move operation.
   *
   * The new values will only be applied if the source status is invalid for the target project and issue type.
   *
   * **You should only define this property when `inferStatusDefaults` is `false`.**
   */
  targetStatus?: Array<targetStatus> | null;
};

export type GetBannerResponse = AnnouncementBannerConfiguration;

export type GetBannerError = ErrorCollection;

export type SetBannerData = {
  body: AnnouncementBannerConfigurationUpdate;
};

export type SetBannerResponse = unknown;

export type SetBannerError = ErrorCollection;

export type GetCustomFieldsConfigurationsData = {
  body: ConfigurationsListParameters;
  query?: {
    /**
     * The list of field context IDs. To include multiple field contexts, separate IDs with an ampersand: `fieldContextId=10000&fieldContextId=10001`. Can't be provided with `id`, `issueId`, `projectKeyOrId`, or `issueTypeId`.
     */
    fieldContextId?: Array<number>;
    /**
     * The list of configuration IDs. To include multiple configurations, separate IDs with an ampersand: `id=10000&id=10001`. Can't be provided with `fieldContextId`, `issueId`, `projectKeyOrId`, or `issueTypeId`.
     */
    id?: Array<number>;
    /**
     * The ID of the issue to filter results by. If the issue doesn't exist, an empty list is returned. Can't be provided with `projectKeyOrId`, or `issueTypeId`.
     */
    issueId?: number;
    /**
     * The ID of the issue type to filter results by. Must be provided with `projectKeyOrId`. Can't be provided with `issueId`.
     */
    issueTypeId?: string;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The ID or key of the project to filter results by. Must be provided with `issueTypeId`. Can't be provided with `issueId`.
     */
    projectKeyOrId?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetCustomFieldsConfigurationsResponse = PageBeanBulkContextualConfiguration;

export type GetCustomFieldsConfigurationsError = unknown;

export type UpdateMultipleCustomFieldValuesData = {
  body: MultipleCustomFieldValuesUpdateDetails;
  query?: {
    /**
     * Whether to generate a changelog for this update.
     */
    generateChangelog?: boolean;
  };
};

export type UpdateMultipleCustomFieldValuesResponse = unknown;

export type UpdateMultipleCustomFieldValuesError = unknown;

export type GetCustomFieldConfigurationData = {
  path: {
    /**
     * The ID or key of the custom field, for example `customfield_10000`.
     */
    fieldIdOrKey: string;
  };
  query?: {
    /**
     * The list of field context IDs. To include multiple field contexts, separate IDs with an ampersand: `fieldContextId=10000&fieldContextId=10001`. Can't be provided with `id`, `issueId`, `projectKeyOrId`, or `issueTypeId`.
     */
    fieldContextId?: Array<number>;
    /**
     * The list of configuration IDs. To include multiple configurations, separate IDs with an ampersand: `id=10000&id=10001`. Can't be provided with `fieldContextId`, `issueId`, `projectKeyOrId`, or `issueTypeId`.
     */
    id?: Array<number>;
    /**
     * The ID of the issue to filter results by. If the issue doesn't exist, an empty list is returned. Can't be provided with `projectKeyOrId`, or `issueTypeId`.
     */
    issueId?: number;
    /**
     * The ID of the issue type to filter results by. Must be provided with `projectKeyOrId`. Can't be provided with `issueId`.
     */
    issueTypeId?: string;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The ID or key of the project to filter results by. Must be provided with `issueTypeId`. Can't be provided with `issueId`.
     */
    projectKeyOrId?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetCustomFieldConfigurationResponse = PageBeanContextualConfiguration;

export type GetCustomFieldConfigurationError = unknown;

export type UpdateCustomFieldConfigurationData = {
  body: CustomFieldConfigurations;
  path: {
    /**
     * The ID or key of the custom field, for example `customfield_10000`.
     */
    fieldIdOrKey: string;
  };
};

export type UpdateCustomFieldConfigurationResponse = unknown;

export type UpdateCustomFieldConfigurationError = unknown;

export type UpdateCustomFieldValueData = {
  body: CustomFieldValueUpdateDetails;
  path: {
    /**
     * The ID or key of the custom field. For example, `customfield_10010`.
     */
    fieldIdOrKey: string;
  };
  query?: {
    /**
     * Whether to generate a changelog for this update.
     */
    generateChangelog?: boolean;
  };
};

export type UpdateCustomFieldValueResponse = unknown;

export type UpdateCustomFieldValueError = unknown;

export type GetApplicationPropertyData = {
  query?: {
    /**
     * The key of the application property.
     */
    key?: string;
    /**
     * When a `key` isn't provided, this filters the list of results by the application property `key` using a regular expression. For example, using `jira.lf.*` will return all application properties with keys that start with *jira.lf.*.
     */
    keyFilter?: string;
    /**
     * The permission level of all items being returned in the list.
     */
    permissionLevel?: string;
  };
};

export type GetApplicationPropertyResponse = Array<ApplicationProperty>;

export type GetApplicationPropertyError = ErrorCollection;

export type GetAdvancedSettingsResponse = Array<ApplicationProperty>;

export type GetAdvancedSettingsError = unknown;

export type SetApplicationPropertyData = {
  body: SimpleApplicationPropertyBean;
  path: {
    /**
     * The key of the application property to update.
     */
    id: string;
  };
};

export type SetApplicationPropertyResponse = ApplicationProperty;

export type SetApplicationPropertyError = ErrorCollection;

export type GetAllApplicationRolesResponse = Array<ApplicationRole>;

export type GetAllApplicationRolesError = unknown;

export type GetApplicationRoleData = {
  path: {
    /**
     * The key of the application role. Use the [Get all application roles](#api-rest-api-3-applicationrole-get) operation to get the key for each application role.
     */
    key: string;
  };
};

export type GetApplicationRoleResponse = ApplicationRole;

export type GetApplicationRoleError = unknown;

export type GetAttachmentContentData = {
  path: {
    /**
     * The ID of the attachment.
     */
    id: string;
  };
  query?: {
    /**
     * Whether a redirect is provided for the attachment download. Clients that do not automatically follow redirects can set this to `false` to aany making multiple requests to download the attachment.
     */
    redirect?: boolean;
  };
};

export type GetAttachmentContentResponse = Array<unknown> | unknown;

export type GetAttachmentContentError = unknown;

export type GetAttachmentMetaResponse = AttachmentSettings;

export type GetAttachmentMetaError = unknown;

export type GetAttachmentThumbnailData = {
  path: {
    /**
     * The ID of the attachment.
     */
    id: string;
  };
  query?: {
    /**
     * Whether a default thumbnail is returned when the requested thumbnail is not found.
     */
    fallbackToDefault?: boolean;
    /**
     * The maximum height to scale the thumbnail to.
     */
    height?: number;
    /**
     * Whether a redirect is provided for the attachment download. Clients that do not automatically follow redirects can set this to `false` to aany making multiple requests to download the attachment.
     */
    redirect?: boolean;
    /**
     * The maximum width to scale the thumbnail to.
     */
    width?: number;
  };
};

export type GetAttachmentThumbnailResponse = Array<unknown>;

export type GetAttachmentThumbnailError = unknown;

export type RemoveAttachmentData = {
  path: {
    /**
     * The ID of the attachment.
     */
    id: string;
  };
};

export type RemoveAttachmentResponse = any;

export type RemoveAttachmentError = unknown;

export type GetAttachmentData = {
  path: {
    /**
     * The ID of the attachment.
     */
    id: string;
  };
};

export type GetAttachmentResponse = AttachmentMetadata;

export type GetAttachmentError = unknown;

export type ExpandAttachmentForHumansData = {
  path: {
    /**
     * The ID of the attachment.
     */
    id: string;
  };
};

export type ExpandAttachmentForHumansResponse = AttachmentArchiveMetadataReadable;

export type ExpandAttachmentForHumansError = unknown;

export type ExpandAttachmentForMachinesData = {
  path: {
    /**
     * The ID of the attachment.
     */
    id: string;
  };
};

export type ExpandAttachmentForMachinesResponse = AttachmentArchiveImpl;

export type ExpandAttachmentForMachinesError = unknown;

export type GetAuditRecordsData = {
  query?: {
    /**
     * The strings to match with audit field content, space separated.
     */
    filter?: string;
    /**
     * The date and time on or after which returned audit records must have been created. If `to` is provided `from` must be before `to` or no audit records are returned.
     */
    from?: string;
    /**
     * The maximum number of results to return.
     */
    limit?: number;
    /**
     * The number of records to skip before returning the first result.
     */
    offset?: number;
    /**
     * The date and time on or before which returned audit results must have been created. If `from` is provided `to` must be after `from` or no audit records are returned.
     */
    to?: string;
  };
};

export type GetAuditRecordsResponse = AuditRecords;

export type GetAuditRecordsError = ErrorCollection;

export type GetAllSystemAvatarsData = {
  path: {
    /**
     * The avatar type.
     */
    type: 'issuetype' | 'project' | 'user' | 'priority';
  };
};

export type GetAllSystemAvatarsResponse = SystemAvatars;

export type GetAllSystemAvatarsError = unknown;

export type GetBulkEditableFieldsData = {
  query: {
    /**
     * (Optional)The end cursor for use in pagination.
     */
    endingBefore?: string;
    /**
     * The IDs or keys of the issues to get editable fields from.
     */
    issueIdsOrKeys: string;
    /**
     * (Optional)The text to search for in the editable fields.
     */
    searchText?: string;
    /**
     * (Optional)The start cursor for use in pagination.
     */
    startingAfter?: string;
  };
};

export type GetBulkEditableFieldsResponse = BulkEditGetFields;

export type GetBulkEditableFieldsError = BulkOperationErrorResponse;

export type SubmitBulkEditData = {
  /**
   * The request body containing the issues to be edited and the new field values.
   */
  body: IssueBulkEditPayload;
};

export type SubmitBulkEditResponse = SubmittedBulkOperation;

export type SubmitBulkEditError = BulkOperationErrorResponse;

export type SubmitBulkMoveData = {
  body: IssueBulkMovePayload;
};

export type SubmitBulkMoveResponse = SubmittedBulkOperation;

export type SubmitBulkMoveError = BulkOperationErrorResponse;

export type GetBulkOperationProgressData = {
  path: {
    /**
     * The ID of the task.
     */
    taskId: string;
  };
};

export type GetBulkOperationProgressResponse = BulkOperationProgress;

export type GetBulkOperationProgressError = BulkOperationErrorResponse;

export type GetAllUserDataClassificationLevelsData = {
  query?: {
    /**
     * Ordering of the results by a given field. If not provided, values will not be sorted.
     */
    orderBy?: 'rank' | '-rank' | '+rank';
    /**
     * Optional set of statuses to filter by.
     */
    status?: Array<'PUBLISHED' | 'ARCHIVED' | 'DRAFT'>;
  };
};

export type GetAllUserDataClassificationLevelsResponse = DataClassificationLevelsBean;

export type GetAllUserDataClassificationLevelsError = unknown;

export type GetCommentsByIdsData = {
  /**
   * The list of comment IDs.
   */
  body: IssueCommentListRequestBean;
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about comments in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `renderedBody` Returns the comment body rendered in HTML.
     * *  `properties` Returns the comment's properties.
     */
    expand?: string;
  };
};

export type GetCommentsByIdsResponse = PageBeanComment;

export type GetCommentsByIdsError = unknown;

export type GetCommentPropertyKeysData = {
  path: {
    /**
     * The ID of the comment.
     */
    commentId: string;
  };
};

export type GetCommentPropertyKeysResponse = PropertyKeys;

export type GetCommentPropertyKeysError = unknown;

export type DeleteCommentPropertyData = {
  path: {
    /**
     * The ID of the comment.
     */
    commentId: string;
    /**
     * The key of the property.
     */
    propertyKey: string;
  };
};

export type DeleteCommentPropertyResponse = any;

export type DeleteCommentPropertyError = unknown;

export type GetCommentPropertyData = {
  path: {
    /**
     * The ID of the comment.
     */
    commentId: string;
    /**
     * The key of the property.
     */
    propertyKey: string;
  };
};

export type GetCommentPropertyResponse = EntityProperty;

export type GetCommentPropertyError = unknown;

export type SetCommentPropertyData = {
  /**
   * The value of the property. The value has to be a valid, non-empty [JSON](https://tools.ietf.org/html/rfc4627) value. The maximum length of the property value is 32768 bytes.
   */
  body?: string;
  path: {
    /**
     * The ID of the comment.
     */
    commentId: string;
    /**
     * The key of the property. The maximum length is 255 characters.
     */
    propertyKey: string;
  };
};

export type SetCommentPropertyResponse = unknown;

export type SetCommentPropertyError = unknown;

export type FindComponentsForProjectsData = {
  query?: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * [Order](#ordering) the results by a field:
     *
     * *  `description` Sorts by the component description.
     * *  `name` Sorts by component name.
     */
    orderBy?: 'description' | '-description' | '+description' | 'name' | '-name' | '+name';
    /**
     * The project IDs and/or project keys (case sensitive).
     */
    projectIdsOrKeys?: Array<string>;
    /**
     * Filter the results using a literal string. Components with a matching `name` or `description` are returned (case insensitive).
     */
    query?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type FindComponentsForProjectsResponse = PageBean2ComponentJsonBean;

export type FindComponentsForProjectsError = unknown;

export type CreateComponentData = {
  body: ProjectComponent;
};

export type CreateComponentResponse = ProjectComponent;

export type CreateComponentError = unknown;

export type DeleteComponentData = {
  path: {
    /**
     * The ID of the component.
     */
    id: string;
  };
  query?: {
    /**
     * The ID of the component to replace the deleted component. If this value is null no replacement is made.
     */
    moveIssuesTo?: string;
  };
};

export type DeleteComponentResponse = any;

export type DeleteComponentError = unknown;

export type GetComponentData = {
  path: {
    /**
     * The ID of the component.
     */
    id: string;
  };
};

export type GetComponentResponse = ProjectComponent;

export type GetComponentError = unknown;

export type UpdateComponentData = {
  body: ProjectComponent;
  path: {
    /**
     * The ID of the component.
     */
    id: string;
  };
};

export type UpdateComponentResponse = ProjectComponent;

export type UpdateComponentError = unknown;

export type GetComponentRelatedIssuesData = {
  path: {
    /**
     * The ID of the component.
     */
    id: string;
  };
};

export type GetComponentRelatedIssuesResponse = ComponentIssuesCount;

export type GetComponentRelatedIssuesError = unknown;

export type GetConfigurationResponse = Configuration;

export type GetConfigurationError = unknown;

export type GetSelectedTimeTrackingImplementationResponse = TimeTrackingProvider | unknown;

export type GetSelectedTimeTrackingImplementationError = unknown;

export type SelectTimeTrackingImplementationData = {
  body: TimeTrackingProvider;
};

export type SelectTimeTrackingImplementationResponse = unknown;

export type SelectTimeTrackingImplementationError = unknown;

export type GetAvailableTimeTrackingImplementationsResponse = Array<TimeTrackingProvider>;

export type GetAvailableTimeTrackingImplementationsError = unknown;

export type GetSharedTimeTrackingConfigurationResponse = TimeTrackingConfiguration;

export type GetSharedTimeTrackingConfigurationError = unknown;

export type SetSharedTimeTrackingConfigurationData = {
  body: TimeTrackingConfiguration;
};

export type SetSharedTimeTrackingConfigurationResponse = TimeTrackingConfiguration;

export type SetSharedTimeTrackingConfigurationError = unknown;

export type GetCustomFieldOptionData = {
  path: {
    /**
     * The ID of the custom field option.
     */
    id: string;
  };
};

export type GetCustomFieldOptionResponse = CustomFieldOption;

export type GetCustomFieldOptionError = unknown;

export type GetAllDashboardsData = {
  query?: {
    /**
     * The filter applied to the list of dashboards. Valid values are:
     *
     * *  `favourite` Returns dashboards the user has marked as favorite.
     * *  `my` Returns dashboards owned by the user.
     */
    filter?: 'my' | 'favourite';
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetAllDashboardsResponse = PageOfDashboards;

export type GetAllDashboardsError = ErrorCollection;

export type CreateDashboardData = {
  /**
   * Dashboard details.
   */
  body: DashboardDetails;
  query?: {
    /**
     * Whether admin level permissions are used. It should only be true if the user has *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg)
     */
    extendAdminPermissions?: boolean;
  };
};

export type CreateDashboardResponse = Dashboard;

export type CreateDashboardError = ErrorCollection;

export type BulkEditDashboardsData = {
  /**
   * The details of dashboards being updated in bulk.
   */
  body: BulkEditShareableEntityRequest;
};

export type BulkEditDashboardsResponse = BulkEditShareableEntityResponse;

export type BulkEditDashboardsError = ErrorCollection;

export type GetAllAvailableDashboardGadgetsResponse = AvailableDashboardGadgetsResponse;

export type GetAllAvailableDashboardGadgetsError = ErrorCollection;

export type GetDashboardsPaginatedData = {
  query?: {
    /**
     * User account ID used to return dashboards with the matching `owner.accountId`. This parameter cannot be used with the `owner` parameter.
     */
    accountId?: string;
    /**
     * String used to perform a case-insensitive partial match with `name`.
     */
    dashboardName?: string;
    /**
     * Use [expand](#expansion) to include additional information about dashboard in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `description` Returns the description of the dashboard.
     * *  `owner` Returns the owner of the dashboard.
     * *  `viewUrl` Returns the URL that is used to view the dashboard.
     * *  `favourite` Returns `isFavourite`, an indicator of whether the user has set the dashboard as a favorite.
     * *  `favouritedCount` Returns `popularity`, a count of how many users have set this dashboard as a favorite.
     * *  `sharePermissions` Returns details of the share permissions defined for the dashboard.
     * *  `editPermissions` Returns details of the edit permissions defined for the dashboard.
     * *  `isWritable` Returns whether the current user has permission to edit the dashboard.
     */
    expand?: string;
    /**
     * Group ID used to return dashboards that are shared with a group that matches `sharePermissions.group.groupId`. This parameter cannot be used with the `groupname` parameter.
     */
    groupId?: string;
    /**
     * As a group's name can change, use of `groupId` is recommended. Group name used to return dashboards that are shared with a group that matches `sharePermissions.group.name`. This parameter cannot be used with the `groupId` parameter.
     */
    groupname?: string;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * [Order](#ordering) the results by a field:
     *
     * *  `description` Sorts by dashboard description. Note that this sort works independently of whether the expand to display the description field is in use.
     * *  `favourite_count` Sorts by dashboard popularity.
     * *  `id` Sorts by dashboard ID.
     * *  `is_favourite` Sorts by whether the dashboard is marked as a favorite.
     * *  `name` Sorts by dashboard name.
     * *  `owner` Sorts by dashboard owner name.
     */
    orderBy?:
      | 'description'
      | '-description'
      | '+description'
      | 'favorite_count'
      | '-favorite_count'
      | '+favorite_count'
      | 'id'
      | '-id'
      | '+id'
      | 'is_favorite'
      | '-is_favorite'
      | '+is_favorite'
      | 'name'
      | '-name'
      | '+name'
      | 'owner'
      | '-owner'
      | '+owner';
    /**
     * This parameter is deprecated because of privacy changes. Use `accountId` instead. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details. User name used to return dashboards with the matching `owner.name`. This parameter cannot be used with the `accountId` parameter.
     */
    owner?: string;
    /**
     * Project ID used to returns dashboards that are shared with a project that matches `sharePermissions.project.id`.
     */
    projectId?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
    /**
     * The status to filter by. It may be active, archived or deleted.
     */
    status?: 'active' | 'archived' | 'deleted';
  };
};

export type GetDashboardsPaginatedResponse = PageBeanDashboard;

export type GetDashboardsPaginatedError = ErrorCollection;

export type GetAllGadgetsData = {
  path: {
    /**
     * The ID of the dashboard.
     */
    dashboardId: number;
  };
  query?: {
    /**
     * The list of gadgets IDs. To include multiple IDs, separate IDs with ampersand: `gadgetId=10000&gadgetId=10001`.
     */
    gadgetId?: Array<number>;
    /**
     * The list of gadgets module keys. To include multiple module keys, separate module keys with ampersand: `moduleKey=key:one&moduleKey=key:two`.
     */
    moduleKey?: Array<string>;
    /**
     * The list of gadgets URIs. To include multiple URIs, separate URIs with ampersand: `uri=/rest/example/uri/1&uri=/rest/example/uri/2`.
     */
    uri?: Array<string>;
  };
};

export type GetAllGadgetsResponse = DashboardGadgetResponse;

export type GetAllGadgetsError = unknown | ErrorCollection;

export type AddGadgetData = {
  body: DashboardGadgetSettings;
  path: {
    /**
     * The ID of the dashboard.
     */
    dashboardId: number;
  };
};

export type AddGadgetResponse = DashboardGadget;

export type AddGadgetError = ErrorCollection | unknown;

export type RemoveGadgetData = {
  path: {
    /**
     * The ID of the dashboard.
     */
    dashboardId: number;
    /**
     * The ID of the gadget.
     */
    gadgetId: number;
  };
};

export type RemoveGadgetResponse = unknown;

export type RemoveGadgetError = unknown | ErrorCollection;

export type UpdateGadgetData = {
  body: DashboardGadgetUpdateRequest;
  path: {
    /**
     * The ID of the dashboard.
     */
    dashboardId: number;
    /**
     * The ID of the gadget.
     */
    gadgetId: number;
  };
};

export type UpdateGadgetResponse = unknown;

export type UpdateGadgetError = ErrorCollection | unknown;

export type GetDashboardItemPropertyKeysData = {
  path: {
    /**
     * The ID of the dashboard.
     */
    dashboardId: string;
    /**
     * The ID of the dashboard item.
     */
    itemId: string;
  };
};

export type GetDashboardItemPropertyKeysResponse = PropertyKeys;

export type GetDashboardItemPropertyKeysError = ErrorCollection;

export type DeleteDashboardItemPropertyData = {
  path: {
    /**
     * The ID of the dashboard.
     */
    dashboardId: string;
    /**
     * The ID of the dashboard item.
     */
    itemId: string;
    /**
     * The key of the dashboard item property.
     */
    propertyKey: string;
  };
};

export type DeleteDashboardItemPropertyResponse = unknown;

export type DeleteDashboardItemPropertyError = ErrorCollection;

export type GetDashboardItemPropertyData = {
  path: {
    /**
     * The ID of the dashboard.
     */
    dashboardId: string;
    /**
     * The ID of the dashboard item.
     */
    itemId: string;
    /**
     * The key of the dashboard item property.
     */
    propertyKey: string;
  };
};

export type GetDashboardItemPropertyResponse = EntityProperty;

export type GetDashboardItemPropertyError = ErrorCollection;

export type SetDashboardItemPropertyData = {
  /**
   * The value of the property. The value has to be a valid, non-empty [JSON](https://tools.ietf.org/html/rfc4627) value. The maximum length of the property value is 32768 bytes.
   */
  body?: string;
  path: {
    /**
     * The ID of the dashboard.
     */
    dashboardId: string;
    /**
     * The ID of the dashboard item.
     */
    itemId: string;
    /**
     * The key of the dashboard item property. The maximum length is 255 characters. For dashboard items with a spec URI and no complete module key, if the provided propertyKey is equal to "config", the request body's JSON must be an object with all keys and values as strings.
     */
    propertyKey: string;
  };
};

export type SetDashboardItemPropertyResponse = unknown;

export type SetDashboardItemPropertyError = ErrorCollection;

export type DeleteDashboardData = {
  path: {
    /**
     * The ID of the dashboard.
     */
    id: string;
  };
};

export type DeleteDashboardResponse = any;

export type DeleteDashboardError = ErrorCollection;

export type GetDashboardData = {
  path: {
    /**
     * The ID of the dashboard.
     */
    id: string;
  };
};

export type GetDashboardResponse = Dashboard;

export type GetDashboardError = ErrorCollection | unknown;

export type UpdateDashboardData = {
  /**
   * Replacement dashboard details.
   */
  body: DashboardDetails;
  path: {
    /**
     * The ID of the dashboard to update.
     */
    id: string;
  };
  query?: {
    /**
     * Whether admin level permissions are used. It should only be true if the user has *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg)
     */
    extendAdminPermissions?: boolean;
  };
};

export type UpdateDashboardResponse = Dashboard;

export type UpdateDashboardError = ErrorCollection;

export type CopyDashboardData = {
  /**
   * Dashboard details.
   */
  body: DashboardDetails;
  path: {
    id: string;
  };
  query?: {
    /**
     * Whether admin level permissions are used. It should only be true if the user has *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg)
     */
    extendAdminPermissions?: boolean;
  };
};

export type CopyDashboardResponse = Dashboard;

export type CopyDashboardError = ErrorCollection;

export type GetPolicyResponse = WorkspaceDataPolicy;

export type GetPolicyError = ErrorCollection;

export type GetPoliciesData = {
  query?: {
    /**
     * A list of project identifiers. This parameter accepts a comma-separated list.
     */
    ids?: string;
  };
};

export type GetPoliciesResponse = ProjectDataPolicies;

export type GetPoliciesError = ErrorCollection;

export type GetEventsResponse = Array<IssueEvent>;

export type GetEventsError = unknown;

export type AnalyseExpressionData = {
  /**
   * The Jira expressions to analyse.
   */
  body: JiraExpressionForAnalysis;
  query?: {
    /**
     * The check to perform:
     *
     * *  `syntax` Each expression's syntax is checked to ensure the expression can be parsed. Also, syntactic limits are validated. For example, the expression's length.
     * *  `type` EXPERIMENTAL. Each expression is type checked and the final type of the expression inferred. Any type errors that would result in the expression failure at runtime are reported. For example, accessing properties that don't exist or passing the wrong number of arguments to functions. Also performs the syntax check.
     * *  `complexity` EXPERIMENTAL. Determines the formulae for how many [expensive operations](https://developer.atlassian.com/cloud/jira/platform/jira-expressions/#expensive-operations) each expression may execute.
     */
    check?: 'syntax' | 'type' | 'complexity';
  };
};

export type AnalyseExpressionResponse = JiraExpressionsAnalysis;

export type AnalyseExpressionError = ErrorCollection | unknown;

export type EvaluateJiraExpressionData = {
  /**
   * The Jira expression and the evaluation context.
   */
  body: JiraExpressionEvalRequestBean;
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts `meta.complexity` that returns information about the expression complexity. For example, the number of expensive operations used by the expression and how close the expression is to reaching the [complexity limit](https://developer.atlassian.com/cloud/jira/platform/jira-expressions/#restrictions). Useful when designing and debugging your expressions.
     */
    expand?: string;
  };
};

export type EvaluateJiraExpressionResponse = JiraExpressionResult;

export type EvaluateJiraExpressionError = ErrorCollection | unknown;

export type EvaluateJsisJiraExpressionData = {
  /**
   * The Jira expression and the evaluation context.
   */
  body: JiraExpressionEvaluateRequestBean;
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts `meta.complexity` that returns information about the expression complexity. For example, the number of expensive operations used by the expression and how close the expression is to reaching the [complexity limit](https://developer.atlassian.com/cloud/jira/platform/jira-expressions/#restrictions). Useful when designing and debugging your expressions.
     */
    expand?: string;
  };
};

export type EvaluateJsisJiraExpressionResponse = JExpEvaluateJiraExpressionResultBean;

export type EvaluateJsisJiraExpressionError = ErrorCollection | unknown;

export type GetFieldsResponse = Array<FieldDetails>;

export type GetFieldsError = unknown;

export type CreateCustomFieldData = {
  /**
   * Definition of the custom field to be created
   */
  body: CustomFieldDefinitionJsonBean;
};

export type CreateCustomFieldResponse = FieldDetails;

export type CreateCustomFieldError = unknown;

export type GetFieldsPaginatedData = {
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `key` returns the key for each field
     * *  `stableId` returns the stableId for each field
     * *  `lastUsed` returns the date when the value of the field last changed
     * *  `screensCount` returns the number of screens related to a field
     * *  `contextsCount` returns the number of contexts related to a field
     * *  `isLocked` returns information about whether the field is [locked](https://confluence.atlassian.com/x/ZSN7Og)
     * *  `searcherKey` returns the searcher key for each custom field
     */
    expand?: string;
    /**
     * The IDs of the custom fields to return or, where `query` is specified, filter.
     */
    id?: Array<string>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * [Order](#ordering) the results by a field:
     *
     * *  `contextsCount` sorts by the number of contexts related to a field
     * *  `lastUsed` sorts by the date when the value of the field last changed
     * *  `name` sorts by the field name
     * *  `screensCount` sorts by the number of screens related to a field
     */
    orderBy?:
      | 'contextsCount'
      | '-contextsCount'
      | '+contextsCount'
      | 'lastUsed'
      | '-lastUsed'
      | '+lastUsed'
      | 'name'
      | '-name'
      | '+name'
      | 'screensCount'
      | '-screensCount'
      | '+screensCount'
      | 'projectsCount'
      | '-projectsCount'
      | '+projectsCount';
    /**
     * String used to perform a case-insensitive partial match with field names or descriptions.
     */
    query?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
    /**
     * The type of fields to search.
     */
    type?: Array<'custom' | 'system'>;
  };
};

export type GetFieldsPaginatedResponse = PageBeanField;

export type GetFieldsPaginatedError = ErrorCollection | unknown;

export type GetTrashedFieldsPaginatedData = {
  query?: {
    expand?:
      | 'name'
      | '-name'
      | '+name'
      | 'trashDate'
      | '-trashDate'
      | '+trashDate'
      | 'plannedDeletionDate'
      | '-plannedDeletionDate'
      | '+plannedDeletionDate'
      | 'projectsCount'
      | '-projectsCount'
      | '+projectsCount';
    id?: Array<string>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * [Order](#ordering) the results by a field:
     *
     * *  `name` sorts by the field name
     * *  `trashDate` sorts by the date the field was moved to the trash
     * *  `plannedDeletionDate` sorts by the planned deletion date
     */
    orderBy?: string;
    /**
     * String used to perform a case-insensitive partial match with field names or descriptions.
     */
    query?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetTrashedFieldsPaginatedResponse = PageBeanField;

export type GetTrashedFieldsPaginatedError = ErrorCollection | unknown;

export type UpdateCustomFieldData = {
  /**
   * The custom field update details.
   */
  body: UpdateCustomFieldDetails;
  path: {
    /**
     * The ID of the custom field.
     */
    fieldId: string;
  };
};

export type UpdateCustomFieldResponse = unknown;

export type UpdateCustomFieldError = unknown;

export type GetContextsForFieldData = {
  path: {
    /**
     * The ID of the custom field.
     */
    fieldId: string;
  };
  query?: {
    /**
     * The list of context IDs. To include multiple contexts, separate IDs with ampersand: `contextId=10000&contextId=10001`.
     */
    contextId?: Array<number>;
    /**
     * Whether to return contexts that apply to all issue types.
     */
    isAnyIssueType?: boolean;
    /**
     * Whether to return contexts that apply to all projects.
     */
    isGlobalContext?: boolean;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetContextsForFieldResponse = PageBeanCustomFieldContext;

export type GetContextsForFieldError = unknown;

export type CreateCustomFieldContextData = {
  body: CreateCustomFieldContext;
  path: {
    /**
     * The ID of the custom field.
     */
    fieldId: string;
  };
};

export type CreateCustomFieldContextResponse = CreateCustomFieldContext;

export type CreateCustomFieldContextError = unknown;

export type GetDefaultValuesData = {
  path: {
    /**
     * The ID of the custom field, for example `customfield\_10000`.
     */
    fieldId: string;
  };
  query?: {
    /**
     * The IDs of the contexts.
     */
    contextId?: Array<number>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetDefaultValuesResponse = PageBeanCustomFieldContextDefaultValue;

export type GetDefaultValuesError = unknown;

export type SetDefaultValuesData = {
  body: CustomFieldContextDefaultValueUpdate;
  path: {
    /**
     * The ID of the custom field.
     */
    fieldId: string;
  };
};

export type SetDefaultValuesResponse = unknown;

export type SetDefaultValuesError = unknown;

export type GetIssueTypeMappingsForContextsData = {
  path: {
    /**
     * The ID of the custom field.
     */
    fieldId: string;
  };
  query?: {
    /**
     * The ID of the context. To include multiple contexts, provide an ampersand-separated list. For example, `contextId=10001&contextId=10002`.
     */
    contextId?: Array<number>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetIssueTypeMappingsForContextsResponse = PageBeanIssueTypeToContextMapping;

export type GetIssueTypeMappingsForContextsError = unknown;

export type GetCustomFieldContextsForProjectsAndIssueTypesData = {
  /**
   * The list of project and issue type mappings.
   */
  body: ProjectIssueTypeMappings;
  path: {
    /**
     * The ID of the custom field.
     */
    fieldId: string;
  };
  query?: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetCustomFieldContextsForProjectsAndIssueTypesResponse = PageBeanContextForProjectAndIssueType;

export type GetCustomFieldContextsForProjectsAndIssueTypesError = unknown;

export type GetProjectContextMappingData = {
  path: {
    /**
     * The ID of the custom field, for example `customfield\_10000`.
     */
    fieldId: string;
  };
  query?: {
    /**
     * The list of context IDs. To include multiple context, separate IDs with ampersand: `contextId=10000&contextId=10001`.
     */
    contextId?: Array<number>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetProjectContextMappingResponse = PageBeanCustomFieldContextProjectMapping;

export type GetProjectContextMappingError = unknown;

export type DeleteCustomFieldContextData = {
  path: {
    /**
     * The ID of the context.
     */
    contextId: number;
    /**
     * The ID of the custom field.
     */
    fieldId: string;
  };
};

export type DeleteCustomFieldContextResponse = unknown;

export type DeleteCustomFieldContextError = unknown;

export type UpdateCustomFieldContextData = {
  body: CustomFieldContextUpdateDetails;
  path: {
    /**
     * The ID of the context.
     */
    contextId: number;
    /**
     * The ID of the custom field.
     */
    fieldId: string;
  };
};

export type UpdateCustomFieldContextResponse = unknown;

export type UpdateCustomFieldContextError = unknown;

export type AddIssueTypesToContextData = {
  body: IssueTypeIds;
  path: {
    /**
     * The ID of the context.
     */
    contextId: number;
    /**
     * The ID of the custom field.
     */
    fieldId: string;
  };
};

export type AddIssueTypesToContextResponse = unknown;

export type AddIssueTypesToContextError = unknown;

export type RemoveIssueTypesFromContextData = {
  body: IssueTypeIds;
  path: {
    /**
     * The ID of the context.
     */
    contextId: number;
    /**
     * The ID of the custom field.
     */
    fieldId: string;
  };
};

export type RemoveIssueTypesFromContextResponse = unknown;

export type RemoveIssueTypesFromContextError = unknown;

export type GetOptionsForContextData = {
  path: {
    /**
     * The ID of the context.
     */
    contextId: number;
    /**
     * The ID of the custom field.
     */
    fieldId: string;
  };
  query?: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * Whether only options are returned.
     */
    onlyOptions?: boolean;
    /**
     * The ID of the option.
     */
    optionId?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetOptionsForContextResponse = PageBeanCustomFieldContextOption;

export type GetOptionsForContextError = unknown;

export type CreateCustomFieldOptionData = {
  body: BulkCustomFieldOptionCreateRequest;
  path: {
    /**
     * The ID of the context.
     */
    contextId: number;
    /**
     * The ID of the custom field.
     */
    fieldId: string;
  };
};

export type CreateCustomFieldOptionResponse = CustomFieldCreatedContextOptionsList;

export type CreateCustomFieldOptionError = unknown;

export type UpdateCustomFieldOptionData = {
  body: BulkCustomFieldOptionUpdateRequest;
  path: {
    /**
     * The ID of the context.
     */
    contextId: number;
    /**
     * The ID of the custom field.
     */
    fieldId: string;
  };
};

export type UpdateCustomFieldOptionResponse = CustomFieldUpdatedContextOptionsList;

export type UpdateCustomFieldOptionError = unknown;

export type ReorderCustomFieldOptionsData = {
  body: OrderOfCustomFieldOptions;
  path: {
    /**
     * The ID of the context.
     */
    contextId: number;
    /**
     * The ID of the custom field.
     */
    fieldId: string;
  };
};

export type ReorderCustomFieldOptionsResponse = unknown;

export type ReorderCustomFieldOptionsError = unknown;

export type DeleteCustomFieldOptionData = {
  path: {
    /**
     * The ID of the context from which an option should be deleted.
     */
    contextId: number;
    /**
     * The ID of the custom field.
     */
    fieldId: string;
    /**
     * The ID of the option to delete.
     */
    optionId: number;
  };
};

export type DeleteCustomFieldOptionResponse = any;

export type DeleteCustomFieldOptionError = unknown;

export type ReplaceCustomFieldOptionData = {
  path: {
    /**
     * The ID of the context.
     */
    contextId: number;
    /**
     * The ID of the custom field.
     */
    fieldId: string;
    /**
     * The ID of the option to be deselected.
     */
    optionId: number;
  };
  query?: {
    /**
     * A JQL query that specifies the issues to be updated. For example, *project=10000*.
     */
    jql?: string;
    /**
     * The ID of the option that will replace the currently selected option.
     */
    replaceWith?: number;
  };
};

export type AssignProjectsToCustomFieldContextData = {
  body: ProjectIds;
  path: {
    /**
     * The ID of the context.
     */
    contextId: number;
    /**
     * The ID of the custom field.
     */
    fieldId: string;
  };
};

export type AssignProjectsToCustomFieldContextResponse = unknown;

export type AssignProjectsToCustomFieldContextError = unknown;

export type RemoveCustomFieldContextFromProjectsData = {
  body: ProjectIds;
  path: {
    /**
     * The ID of the context.
     */
    contextId: number;
    /**
     * The ID of the custom field.
     */
    fieldId: string;
  };
};

export type RemoveCustomFieldContextFromProjectsResponse = unknown;

export type RemoveCustomFieldContextFromProjectsError = unknown;

export type GetContextsForFieldDeprecatedData = {
  path: {
    /**
     * The ID of the field to return contexts for.
     */
    fieldId: string;
  };
  query?: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetContextsForFieldDeprecatedResponse = PageBeanContext;

export type GetContextsForFieldDeprecatedError = unknown;

export type GetScreensForFieldData = {
  path: {
    /**
     * The ID of the field to return screens for.
     */
    fieldId: string;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about screens in the response. This parameter accepts `tab` which returns details about the screen tabs the field is used in.
     */
    expand?: string;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetScreensForFieldResponse = PageBeanScreenWithTab;

export type GetScreensForFieldError = unknown;

export type GetAllIssueFieldOptionsData = {
  path: {
    /**
     * The field key is specified in the following format: **$(app-key)\_\_$(field-key)**. For example, *example-add-on\_\_example-issue-field*. To determine the `fieldKey` value, do one of the following:
     *
     * *  open the app's plugin descriptor, then **app-key** is the key at the top and **field-key** is the key in the `jiraIssueFields` module. **app-key** can also be found in the app listing in the Atlassian Universal Plugin Manager.
     * *  run [Get fields](#api-rest-api-3-field-get) and in the field details the value is returned in `key`. For example, `"key": "teams-add-on__team-issue-field"`
     */
    fieldKey: string;
  };
  query?: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetAllIssueFieldOptionsResponse = PageBeanIssueFieldOption;

export type GetAllIssueFieldOptionsError = unknown;

export type CreateIssueFieldOptionData = {
  body: IssueFieldOptionCreateBean;
  path: {
    /**
     * The field key is specified in the following format: **$(app-key)\_\_$(field-key)**. For example, *example-add-on\_\_example-issue-field*. To determine the `fieldKey` value, do one of the following:
     *
     * *  open the app's plugin descriptor, then **app-key** is the key at the top and **field-key** is the key in the `jiraIssueFields` module. **app-key** can also be found in the app listing in the Atlassian Universal Plugin Manager.
     * *  run [Get fields](#api-rest-api-3-field-get) and in the field details the value is returned in `key`. For example, `"key": "teams-add-on__team-issue-field"`
     */
    fieldKey: string;
  };
};

export type CreateIssueFieldOptionResponse = IssueFieldOption;

export type CreateIssueFieldOptionError = unknown;

export type GetSelectableIssueFieldOptionsData = {
  path: {
    /**
     * The field key is specified in the following format: **$(app-key)\_\_$(field-key)**. For example, *example-add-on\_\_example-issue-field*. To determine the `fieldKey` value, do one of the following:
     *
     * *  open the app's plugin descriptor, then **app-key** is the key at the top and **field-key** is the key in the `jiraIssueFields` module. **app-key** can also be found in the app listing in the Atlassian Universal Plugin Manager.
     * *  run [Get fields](#api-rest-api-3-field-get) and in the field details the value is returned in `key`. For example, `"key": "teams-add-on__team-issue-field"`
     */
    fieldKey: string;
  };
  query?: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * Filters the results to options that are only available in the specified project.
     */
    projectId?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetSelectableIssueFieldOptionsResponse = PageBeanIssueFieldOption;

export type GetSelectableIssueFieldOptionsError = unknown;

export type GetVisibleIssueFieldOptionsData = {
  path: {
    /**
     * The field key is specified in the following format: **$(app-key)\_\_$(field-key)**. For example, *example-add-on\_\_example-issue-field*. To determine the `fieldKey` value, do one of the following:
     *
     * *  open the app's plugin descriptor, then **app-key** is the key at the top and **field-key** is the key in the `jiraIssueFields` module. **app-key** can also be found in the app listing in the Atlassian Universal Plugin Manager.
     * *  run [Get fields](#api-rest-api-3-field-get) and in the field details the value is returned in `key`. For example, `"key": "teams-add-on__team-issue-field"`
     */
    fieldKey: string;
  };
  query?: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * Filters the results to options that are only available in the specified project.
     */
    projectId?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetVisibleIssueFieldOptionsResponse = PageBeanIssueFieldOption;

export type GetVisibleIssueFieldOptionsError = unknown;

export type DeleteIssueFieldOptionData = {
  path: {
    /**
     * The field key is specified in the following format: **$(app-key)\_\_$(field-key)**. For example, *example-add-on\_\_example-issue-field*. To determine the `fieldKey` value, do one of the following:
     *
     * *  open the app's plugin descriptor, then **app-key** is the key at the top and **field-key** is the key in the `jiraIssueFields` module. **app-key** can also be found in the app listing in the Atlassian Universal Plugin Manager.
     * *  run [Get fields](#api-rest-api-3-field-get) and in the field details the value is returned in `key`. For example, `"key": "teams-add-on__team-issue-field"`
     */
    fieldKey: string;
    /**
     * The ID of the option to be deleted.
     */
    optionId: number;
  };
};

export type DeleteIssueFieldOptionResponse = unknown;

export type DeleteIssueFieldOptionError = unknown;

export type GetIssueFieldOptionData = {
  path: {
    /**
     * The field key is specified in the following format: **$(app-key)\_\_$(field-key)**. For example, *example-add-on\_\_example-issue-field*. To determine the `fieldKey` value, do one of the following:
     *
     * *  open the app's plugin descriptor, then **app-key** is the key at the top and **field-key** is the key in the `jiraIssueFields` module. **app-key** can also be found in the app listing in the Atlassian Universal Plugin Manager.
     * *  run [Get fields](#api-rest-api-3-field-get) and in the field details the value is returned in `key`. For example, `"key": "teams-add-on__team-issue-field"`
     */
    fieldKey: string;
    /**
     * The ID of the option to be returned.
     */
    optionId: number;
  };
};

export type GetIssueFieldOptionResponse = IssueFieldOption;

export type GetIssueFieldOptionError = unknown;

export type UpdateIssueFieldOptionData = {
  body: IssueFieldOption;
  path: {
    /**
     * The field key is specified in the following format: **$(app-key)\_\_$(field-key)**. For example, *example-add-on\_\_example-issue-field*. To determine the `fieldKey` value, do one of the following:
     *
     * *  open the app's plugin descriptor, then **app-key** is the key at the top and **field-key** is the key in the `jiraIssueFields` module. **app-key** can also be found in the app listing in the Atlassian Universal Plugin Manager.
     * *  run [Get fields](#api-rest-api-3-field-get) and in the field details the value is returned in `key`. For example, `"key": "teams-add-on__team-issue-field"`
     */
    fieldKey: string;
    /**
     * The ID of the option to be updated.
     */
    optionId: number;
  };
};

export type UpdateIssueFieldOptionResponse = IssueFieldOption;

export type UpdateIssueFieldOptionError = unknown;

export type ReplaceIssueFieldOptionData = {
  path: {
    /**
     * The field key is specified in the following format: **$(app-key)\_\_$(field-key)**. For example, *example-add-on\_\_example-issue-field*. To determine the `fieldKey` value, do one of the following:
     *
     * *  open the app's plugin descriptor, then **app-key** is the key at the top and **field-key** is the key in the `jiraIssueFields` module. **app-key** can also be found in the app listing in the Atlassian Universal Plugin Manager.
     * *  run [Get fields](#api-rest-api-3-field-get) and in the field details the value is returned in `key`. For example, `"key": "teams-add-on__team-issue-field"`
     */
    fieldKey: string;
    /**
     * The ID of the option to be deselected.
     */
    optionId: number;
  };
  query?: {
    /**
     * A JQL query that specifies the issues to be updated. For example, *project=10000*.
     */
    jql?: string;
    /**
     * Whether screen security is overridden to enable uneditable fields to be edited. Available to Connect and Forge app users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     */
    overrideEditableFlag?: boolean;
    /**
     * Whether screen security is overridden to enable hidden fields to be edited. Available to Connect and Forge app users with admin permission.
     */
    overrideScreenSecurity?: boolean;
    /**
     * The ID of the option that will replace the currently selected option.
     */
    replaceWith?: number;
  };
};

export type DeleteCustomFieldData = {
  path: {
    /**
     * The ID of a custom field.
     */
    id: string;
  };
};

export type RestoreCustomFieldData = {
  path: {
    /**
     * The ID of a custom field.
     */
    id: string;
  };
};

export type RestoreCustomFieldResponse = unknown;

export type RestoreCustomFieldError = ErrorCollection;

export type TrashCustomFieldData = {
  path: {
    /**
     * The ID of a custom field.
     */
    id: string;
  };
};

export type TrashCustomFieldResponse = unknown;

export type TrashCustomFieldError = ErrorCollection;

export type GetAllFieldConfigurationsData = {
  query?: {
    /**
     * The list of field configuration IDs. To include multiple IDs, provide an ampersand-separated list. For example, `id=10000&id=10001`.
     */
    id?: Array<number>;
    /**
     * If *true* returns default field configurations only.
     */
    isDefault?: boolean;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The query string used to match against field configuration names and descriptions.
     */
    query?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetAllFieldConfigurationsResponse = PageBeanFieldConfigurationDetails;

export type GetAllFieldConfigurationsError = unknown;

export type CreateFieldConfigurationData = {
  body: FieldConfigurationDetails;
};

export type CreateFieldConfigurationResponse = FieldConfiguration;

export type CreateFieldConfigurationError = unknown;

export type DeleteFieldConfigurationData = {
  path: {
    /**
     * The ID of the field configuration.
     */
    id: number;
  };
};

export type DeleteFieldConfigurationResponse = unknown;

export type DeleteFieldConfigurationError = unknown;

export type UpdateFieldConfigurationData = {
  body: FieldConfigurationDetails;
  path: {
    /**
     * The ID of the field configuration.
     */
    id: number;
  };
};

export type UpdateFieldConfigurationResponse = unknown;

export type UpdateFieldConfigurationError = unknown;

export type GetFieldConfigurationItemsData = {
  path: {
    /**
     * The ID of the field configuration.
     */
    id: number;
  };
  query?: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetFieldConfigurationItemsResponse = PageBeanFieldConfigurationItem;

export type GetFieldConfigurationItemsError = unknown;

export type UpdateFieldConfigurationItemsData = {
  body: FieldConfigurationItemsDetails;
  path: {
    /**
     * The ID of the field configuration.
     */
    id: number;
  };
};

export type UpdateFieldConfigurationItemsResponse = unknown;

export type UpdateFieldConfigurationItemsError = unknown;

export type GetAllFieldConfigurationSchemesData = {
  query?: {
    /**
     * The list of field configuration scheme IDs. To include multiple IDs, provide an ampersand-separated list. For example, `id=10000&id=10001`.
     */
    id?: Array<number>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetAllFieldConfigurationSchemesResponse = PageBeanFieldConfigurationScheme;

export type GetAllFieldConfigurationSchemesError = unknown;

export type CreateFieldConfigurationSchemeData = {
  /**
   * The details of the field configuration scheme.
   */
  body: UpdateFieldConfigurationSchemeDetails;
};

export type CreateFieldConfigurationSchemeResponse = FieldConfigurationScheme;

export type CreateFieldConfigurationSchemeError = unknown;

export type GetFieldConfigurationSchemeMappingsData = {
  query?: {
    /**
     * The list of field configuration scheme IDs. To include multiple field configuration schemes separate IDs with ampersand: `fieldConfigurationSchemeId=10000&fieldConfigurationSchemeId=10001`.
     */
    fieldConfigurationSchemeId?: Array<number>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetFieldConfigurationSchemeMappingsResponse = PageBeanFieldConfigurationIssueTypeItem;

export type GetFieldConfigurationSchemeMappingsError = unknown;

export type GetFieldConfigurationSchemeProjectMappingData = {
  query: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The list of project IDs. To include multiple projects, separate IDs with ampersand: `projectId=10000&projectId=10001`.
     */
    projectId: Array<number>;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetFieldConfigurationSchemeProjectMappingResponse = PageBeanFieldConfigurationSchemeProjects;

export type GetFieldConfigurationSchemeProjectMappingError = unknown;

export type AssignFieldConfigurationSchemeToProjectData = {
  body: FieldConfigurationSchemeProjectAssociation;
};

export type AssignFieldConfigurationSchemeToProjectResponse = unknown;

export type AssignFieldConfigurationSchemeToProjectError = unknown;

export type DeleteFieldConfigurationSchemeData = {
  path: {
    /**
     * The ID of the field configuration scheme.
     */
    id: number;
  };
};

export type DeleteFieldConfigurationSchemeResponse = unknown;

export type DeleteFieldConfigurationSchemeError = unknown;

export type UpdateFieldConfigurationSchemeData = {
  /**
   * The details of the field configuration scheme.
   */
  body: UpdateFieldConfigurationSchemeDetails;
  path: {
    /**
     * The ID of the field configuration scheme.
     */
    id: number;
  };
};

export type UpdateFieldConfigurationSchemeResponse = unknown;

export type UpdateFieldConfigurationSchemeError = unknown;

export type SetFieldConfigurationSchemeMappingData = {
  body: AssociateFieldConfigurationsWithIssueTypesRequest;
  path: {
    /**
     * The ID of the field configuration scheme.
     */
    id: number;
  };
};

export type SetFieldConfigurationSchemeMappingResponse = unknown;

export type SetFieldConfigurationSchemeMappingError = unknown;

export type RemoveIssueTypesFromGlobalFieldConfigurationSchemeData = {
  /**
   * The issue type IDs to remove.
   */
  body: IssueTypeIdsToRemove;
  path: {
    /**
     * The ID of the field configuration scheme.
     */
    id: number;
  };
};

export type RemoveIssueTypesFromGlobalFieldConfigurationSchemeResponse = unknown;

export type RemoveIssueTypesFromGlobalFieldConfigurationSchemeError = ErrorCollection;

export type CreateFilterData = {
  /**
   * The filter to create.
   */
  body: Filter;
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about filter in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `sharedUsers` Returns the users that the filter is shared with. This includes users that can browse projects that the filter is shared with. If you don't specify `sharedUsers`, then the `sharedUsers` object is returned but it doesn't list any users. The list of users returned is limited to 1000, to access additional users append `[start-index:end-index]` to the expand request. For example, to access the next 1000 users, use `?expand=sharedUsers[1001:2000]`.
     * *  `subscriptions` Returns the users that are subscribed to the filter. If you don't specify `subscriptions`, the `subscriptions` object is returned but it doesn't list any subscriptions. The list of subscriptions returned is limited to 1000, to access additional subscriptions append `[start-index:end-index]` to the expand request. For example, to access the next 1000 subscriptions, use `?expand=subscriptions[1001:2000]`.
     */
    expand?: string;
    /**
     * EXPERIMENTAL: Whether share permissions are overridden to enable filters with any share permissions to be created. Available to users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     */
    overrideSharePermissions?: boolean;
  };
};

export type CreateFilterResponse = Filter;

export type CreateFilterError = unknown;

export type GetDefaultShareScopeResponse = DefaultShareScope;

export type GetDefaultShareScopeError = unknown;

export type SetDefaultShareScopeData = {
  body: DefaultShareScope;
};

export type SetDefaultShareScopeResponse = DefaultShareScope;

export type SetDefaultShareScopeError = unknown;

export type GetFavouriteFiltersData = {
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about filter in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `sharedUsers` Returns the users that the filter is shared with. This includes users that can browse projects that the filter is shared with. If you don't specify `sharedUsers`, then the `sharedUsers` object is returned but it doesn't list any users. The list of users returned is limited to 1000, to access additional users append `[start-index:end-index]` to the expand request. For example, to access the next 1000 users, use `?expand=sharedUsers[1001:2000]`.
     * *  `subscriptions` Returns the users that are subscribed to the filter. If you don't specify `subscriptions`, the `subscriptions` object is returned but it doesn't list any subscriptions. The list of subscriptions returned is limited to 1000, to access additional subscriptions append `[start-index:end-index]` to the expand request. For example, to access the next 1000 subscriptions, use `?expand=subscriptions[1001:2000]`.
     */
    expand?: string;
  };
};

export type GetFavouriteFiltersResponse = Array<Filter>;

export type GetFavouriteFiltersError = unknown;

export type GetMyFiltersData = {
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about filter in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `sharedUsers` Returns the users that the filter is shared with. This includes users that can browse projects that the filter is shared with. If you don't specify `sharedUsers`, then the `sharedUsers` object is returned but it doesn't list any users. The list of users returned is limited to 1000, to access additional users append `[start-index:end-index]` to the expand request. For example, to access the next 1000 users, use `?expand=sharedUsers[1001:2000]`.
     * *  `subscriptions` Returns the users that are subscribed to the filter. If you don't specify `subscriptions`, the `subscriptions` object is returned but it doesn't list any subscriptions. The list of subscriptions returned is limited to 1000, to access additional subscriptions append `[start-index:end-index]` to the expand request. For example, to access the next 1000 subscriptions, use `?expand=subscriptions[1001:2000]`.
     */
    expand?: string;
    /**
     * Include the user's favorite filters in the response.
     */
    includeFavourites?: boolean;
  };
};

export type GetMyFiltersResponse = Array<Filter>;

export type GetMyFiltersError = unknown;

export type GetFiltersPaginatedData = {
  query?: {
    /**
     * User account ID used to return filters with the matching `owner.accountId`. This parameter cannot be used with `owner`.
     */
    accountId?: string;
    /**
     * Use [expand](#expansion) to include additional information about filter in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `description` Returns the description of the filter.
     * *  `favourite` Returns an indicator of whether the user has set the filter as a favorite.
     * *  `favouritedCount` Returns a count of how many users have set this filter as a favorite.
     * *  `jql` Returns the JQL query that the filter uses.
     * *  `owner` Returns the owner of the filter.
     * *  `searchUrl` Returns a URL to perform the filter's JQL query.
     * *  `sharePermissions` Returns the share permissions defined for the filter.
     * *  `editPermissions` Returns the edit permissions defined for the filter.
     * *  `isWritable` Returns whether the current user has permission to edit the filter.
     * *  `approximateLastUsed` \[Experimental\] Returns the approximate date and time when the filter was last evaluated.
     * *  `subscriptions` Returns the users that are subscribed to the filter.
     * *  `viewUrl` Returns a URL to view the filter.
     */
    expand?: string;
    /**
     * String used to perform a case-insensitive partial match with `name`.
     */
    filterName?: string;
    /**
     * Group ID used to returns filters that are shared with a group that matches `sharePermissions.group.groupId`. This parameter cannot be used with the `groupname` parameter.
     */
    groupId?: string;
    /**
     * As a group's name can change, use of `groupId` is recommended to identify a group. Group name used to returns filters that are shared with a group that matches `sharePermissions.group.groupname`. This parameter cannot be used with the `groupId` parameter.
     */
    groupname?: string;
    /**
     * The list of filter IDs. To include multiple IDs, provide an ampersand-separated list. For example, `id=10000&id=10001`. Do not exceed 200 filter IDs.
     */
    id?: Array<number>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * [Order](#ordering) the results by a field:
     *
     * *  `description` Sorts by filter description. Note that this sorting works independently of whether the expand to display the description field is in use.
     * *  `favourite_count` Sorts by the count of how many users have this filter as a favorite.
     * *  `is_favourite` Sorts by whether the filter is marked as a favorite.
     * *  `id` Sorts by filter ID.
     * *  `name` Sorts by filter name.
     * *  `owner` Sorts by the ID of the filter owner.
     * *  `is_shared` Sorts by whether the filter is shared.
     */
    orderBy?:
      | 'description'
      | '-description'
      | '+description'
      | 'favourite_count'
      | '-favourite_count'
      | '+favourite_count'
      | 'id'
      | '-id'
      | '+id'
      | 'is_favourite'
      | '-is_favourite'
      | '+is_favourite'
      | 'name'
      | '-name'
      | '+name'
      | 'owner'
      | '-owner'
      | '+owner'
      | 'is_shared'
      | '-is_shared'
      | '+is_shared';
    /**
     * EXPERIMENTAL: Whether share permissions are overridden to enable filters with any share permissions to be returned. Available to users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     */
    overrideSharePermissions?: boolean;
    /**
     * This parameter is deprecated because of privacy changes. Use `accountId` instead. See the [migration guide](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details. User name used to return filters with the matching `owner.name`. This parameter cannot be used with `accountId`.
     */
    owner?: string;
    /**
     * Project ID used to returns filters that are shared with a project that matches `sharePermissions.project.id`.
     */
    projectId?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetFiltersPaginatedResponse = PageBeanFilterDetails;

export type GetFiltersPaginatedError = ErrorCollection | unknown;

export type DeleteFilterData = {
  path: {
    /**
     * The ID of the filter to delete.
     */
    id: number;
  };
};

export type DeleteFilterResponse = any;

export type DeleteFilterError = unknown;

export type GetFilterData = {
  path: {
    /**
     * The ID of the filter to return.
     */
    id: number;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about filter in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `sharedUsers` Returns the users that the filter is shared with. This includes users that can browse projects that the filter is shared with. If you don't specify `sharedUsers`, then the `sharedUsers` object is returned but it doesn't list any users. The list of users returned is limited to 1000, to access additional users append `[start-index:end-index]` to the expand request. For example, to access the next 1000 users, use `?expand=sharedUsers[1001:2000]`.
     * *  `subscriptions` Returns the users that are subscribed to the filter. If you don't specify `subscriptions`, the `subscriptions` object is returned but it doesn't list any subscriptions. The list of subscriptions returned is limited to 1000, to access additional subscriptions append `[start-index:end-index]` to the expand request. For example, to access the next 1000 subscriptions, use `?expand=subscriptions[1001:2000]`.
     */
    expand?: string;
    /**
     * EXPERIMENTAL: Whether share permissions are overridden to enable filters with any share permissions to be returned. Available to users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     */
    overrideSharePermissions?: boolean;
  };
};

export type GetFilterResponse = Filter;

export type GetFilterError = unknown;

export type UpdateFilterData = {
  /**
   * The filter to update.
   */
  body: Filter;
  path: {
    /**
     * The ID of the filter to update.
     */
    id: number;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about filter in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `sharedUsers` Returns the users that the filter is shared with. This includes users that can browse projects that the filter is shared with. If you don't specify `sharedUsers`, then the `sharedUsers` object is returned but it doesn't list any users. The list of users returned is limited to 1000, to access additional users append `[start-index:end-index]` to the expand request. For example, to access the next 1000 users, use `?expand=sharedUsers[1001:2000]`.
     * *  `subscriptions` Returns the users that are subscribed to the filter. If you don't specify `subscriptions`, the `subscriptions` object is returned but it doesn't list any subscriptions. The list of subscriptions returned is limited to 1000, to access additional subscriptions append `[start-index:end-index]` to the expand request. For example, to access the next 1000 subscriptions, use `?expand=subscriptions[1001:2000]`.
     */
    expand?: string;
    /**
     * EXPERIMENTAL: Whether share permissions are overridden to enable the addition of any share permissions to filters. Available to users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     */
    overrideSharePermissions?: boolean;
  };
};

export type UpdateFilterResponse = Filter;

export type UpdateFilterError = unknown;

export type ResetColumnsData = {
  path: {
    /**
     * The ID of the filter.
     */
    id: number;
  };
};

export type ResetColumnsResponse = any;

export type ResetColumnsError = unknown;

export type GetColumnsData = {
  path: {
    /**
     * The ID of the filter.
     */
    id: number;
  };
};

export type GetColumnsResponse = Array<ColumnItem>;

export type GetColumnsError = unknown;

export type SetColumnsData = {
  /**
   * The IDs of the fields to set as columns. In the form data, specify each field as `columns=id`, where `id` is the *id* of a field (as seen in the response for [Get fields](#api-rest-api-<ver>-field-get)). For example, `columns=summary`.
   */
  body: ColumnRequestBody;
  path: {
    /**
     * The ID of the filter.
     */
    id: number;
  };
};

export type SetColumnsResponse = unknown;

export type SetColumnsError = unknown;

export type DeleteFavouriteForFilterData = {
  path: {
    /**
     * The ID of the filter.
     */
    id: number;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about filter in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `sharedUsers` Returns the users that the filter is shared with. This includes users that can browse projects that the filter is shared with. If you don't specify `sharedUsers`, then the `sharedUsers` object is returned but it doesn't list any users. The list of users returned is limited to 1000, to access additional users append `[start-index:end-index]` to the expand request. For example, to access the next 1000 users, use `?expand=sharedUsers[1001:2000]`.
     * *  `subscriptions` Returns the users that are subscribed to the filter. If you don't specify `subscriptions`, the `subscriptions` object is returned but it doesn't list any subscriptions. The list of subscriptions returned is limited to 1000, to access additional subscriptions append `[start-index:end-index]` to the expand request. For example, to access the next 1000 subscriptions, use `?expand=subscriptions[1001:2000]`.
     */
    expand?: string;
  };
};

export type DeleteFavouriteForFilterResponse = Filter;

export type DeleteFavouriteForFilterError = unknown;

export type SetFavouriteForFilterData = {
  path: {
    /**
     * The ID of the filter.
     */
    id: number;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about filter in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `sharedUsers` Returns the users that the filter is shared with. This includes users that can browse projects that the filter is shared with. If you don't specify `sharedUsers`, then the `sharedUsers` object is returned but it doesn't list any users. The list of users returned is limited to 1000, to access additional users append `[start-index:end-index]` to the expand request. For example, to access the next 1000 users, use `?expand=sharedUsers[1001:2000]`.
     * *  `subscriptions` Returns the users that are subscribed to the filter. If you don't specify `subscriptions`, the `subscriptions` object is returned but it doesn't list any subscriptions. The list of subscriptions returned is limited to 1000, to access additional subscriptions append `[start-index:end-index]` to the expand request. For example, to access the next 1000 subscriptions, use `?expand=subscriptions[1001:2000]`.
     */
    expand?: string;
  };
};

export type SetFavouriteForFilterResponse = Filter;

export type SetFavouriteForFilterError = unknown;

export type ChangeFilterOwnerData = {
  /**
   * The account ID of the new owner of the filter.
   */
  body: ChangeFilterOwner;
  path: {
    /**
     * The ID of the filter to update.
     */
    id: number;
  };
};

export type ChangeFilterOwnerResponse = unknown;

export type ChangeFilterOwnerError = unknown;

export type GetSharePermissionsData = {
  path: {
    /**
     * The ID of the filter.
     */
    id: number;
  };
};

export type GetSharePermissionsResponse = Array<SharePermission>;

export type GetSharePermissionsError = unknown;

export type AddSharePermissionData = {
  body: SharePermissionInputBean;
  path: {
    /**
     * The ID of the filter.
     */
    id: number;
  };
};

export type AddSharePermissionResponse = Array<SharePermission>;

export type AddSharePermissionError = unknown;

export type DeleteSharePermissionData = {
  path: {
    /**
     * The ID of the filter.
     */
    id: number;
    /**
     * The ID of the share permission.
     */
    permissionId: number;
  };
};

export type DeleteSharePermissionResponse = any;

export type DeleteSharePermissionError = unknown;

export type GetSharePermissionData = {
  path: {
    /**
     * The ID of the filter.
     */
    id: number;
    /**
     * The ID of the share permission.
     */
    permissionId: number;
  };
};

export type GetSharePermissionResponse = SharePermission;

export type GetSharePermissionError = unknown;

export type RemoveGroupData = {
  query?: {
    /**
     * The ID of the group. This parameter cannot be used with the `groupname` parameter.
     */
    groupId?: string;
    groupname?: string;
    /**
     * As a group's name can change, use of `swapGroupId` is recommended to identify a group.
     * The group to transfer restrictions to. Only comments and worklogs are transferred. If restrictions are not transferred, comments and worklogs are inaccessible after the deletion. This parameter cannot be used with the `swapGroupId` parameter.
     */
    swapGroup?: string;
    /**
     * The ID of the group to transfer restrictions to. Only comments and worklogs are transferred. If restrictions are not transferred, comments and worklogs are inaccessible after the deletion. This parameter cannot be used with the `swapGroup` parameter.
     */
    swapGroupId?: string;
  };
};

export type RemoveGroupResponse = unknown;

export type RemoveGroupError = unknown;

export type GetGroupData = {
  query?: {
    /**
     * List of fields to expand.
     */
    expand?: string;
    /**
     * The ID of the group. This parameter cannot be used with the `groupName` parameter.
     */
    groupId?: string;
    /**
     * As a group's name can change, use of `groupId` is recommended to identify a group.
     * The name of the group. This parameter cannot be used with the `groupId` parameter.
     */
    groupname?: string;
  };
};

export type GetGroupResponse = Group;

export type GetGroupError = unknown;

export type CreateGroupData = {
  /**
   * The name of the group.
   */
  body: AddGroupBean;
};

export type CreateGroupResponse = Group;

export type CreateGroupError = unknown;

export type BulkGetGroupsData = {
  query?: {
    /**
     * The access level of a group. Valid values: 'site-admin', 'admin', 'user'.
     */
    accessType?: string;
    /**
     * The application key of the product user groups to search for. Valid values: 'jira-servicedesk', 'jira-software', 'jira-product-discovery', 'jira-core'.
     */
    applicationKey?: string;
    /**
     * The ID of a group. To specify multiple IDs, pass multiple `groupId` parameters. For example, `groupId=5b10a2844c20165700ede21g&groupId=5b10ac8d82e05b22cc7d4ef5`.
     */
    groupId?: Array<string>;
    /**
     * The name of a group. To specify multiple names, pass multiple `groupName` parameters. For example, `groupName=administrators&groupName=jira-software-users`.
     */
    groupName?: Array<string>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type BulkGetGroupsResponse = PageBeanGroupDetails;

export type BulkGetGroupsError = unknown;

export type GetUsersFromGroupData = {
  query?: {
    /**
     * The ID of the group. This parameter cannot be used with the `groupName` parameter.
     */
    groupId?: string;
    /**
     * As a group's name can change, use of `groupId` is recommended to identify a group.
     * The name of the group. This parameter cannot be used with the `groupId` parameter.
     */
    groupname?: string;
    /**
     * Include inactive users.
     */
    includeInactiveUsers?: boolean;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetUsersFromGroupResponse = PageBeanUserDetails;

export type GetUsersFromGroupError = unknown;

export type RemoveUserFromGroupData = {
  query: {
    /**
     * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.
     */
    accountId: string;
    /**
     * The ID of the group. This parameter cannot be used with the `groupName` parameter.
     */
    groupId?: string;
    /**
     * As a group's name can change, use of `groupId` is recommended to identify a group.
     * The name of the group. This parameter cannot be used with the `groupId` parameter.
     */
    groupname?: string;
    /**
     * This parameter is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    username?: string;
  };
};

export type RemoveUserFromGroupResponse = unknown;

export type RemoveUserFromGroupError = unknown;

export type AddUserToGroupData = {
  /**
   * The user to add to the group.
   */
  body: UpdateUserToGroupBean;
  query?: {
    /**
     * The ID of the group. This parameter cannot be used with the `groupName` parameter.
     */
    groupId?: string;
    /**
     * As a group's name can change, use of `groupId` is recommended to identify a group.
     * The name of the group. This parameter cannot be used with the `groupId` parameter.
     */
    groupname?: string;
  };
};

export type AddUserToGroupResponse = Group;

export type AddUserToGroupError = unknown;

export type FindGroupsData = {
  query?: {
    /**
     * This parameter is deprecated, setting it does not affect the results. To find groups containing a particular user, use [Get user groups](#api-rest-api-3-user-groups-get).
     */
    accountId?: string;
    /**
     * Whether the search for groups should be case insensitive.
     */
    caseInsensitive?: boolean;
    /**
     * As a group's name can change, use of `excludeGroupIds` is recommended to identify a group.
     * A group to exclude from the result. To exclude multiple groups, provide an ampersand-separated list. For example, `exclude=group1&exclude=group2`. This parameter cannot be used with the `excludeGroupIds` parameter.
     */
    exclude?: Array<string>;
    /**
     * A group ID to exclude from the result. To exclude multiple groups, provide an ampersand-separated list. For example, `excludeId=group1-id&excludeId=group2-id`. This parameter cannot be used with the `excludeGroups` parameter.
     */
    excludeId?: Array<string>;
    /**
     * The maximum number of groups to return. The maximum number of groups that can be returned is limited by the system property `jira.ajax.autocomplete.limit`.
     */
    maxResults?: number;
    /**
     * The string to find in group names.
     */
    query?: string;
    /**
     * This parameter is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    userName?: string;
  };
};

export type FindGroupsResponse = FoundGroups;

export type FindGroupsError = unknown;

export type FindUsersAndGroupsData = {
  query: {
    /**
     * The size of the avatar to return. If an invalid value is provided, the default value is used.
     */
    avatarSize?:
      | 'xsmall'
      | 'xsmall@2x'
      | 'xsmall@3x'
      | 'small'
      | 'small@2x'
      | 'small@3x'
      | 'medium'
      | 'medium@2x'
      | 'medium@3x'
      | 'large'
      | 'large@2x'
      | 'large@3x'
      | 'xlarge'
      | 'xlarge@2x'
      | 'xlarge@3x'
      | 'xxlarge'
      | 'xxlarge@2x'
      | 'xxlarge@3x'
      | 'xxxlarge'
      | 'xxxlarge@2x'
      | 'xxxlarge@3x';
    /**
     * Whether the search for groups should be case insensitive.
     */
    caseInsensitive?: boolean;
    /**
     * Whether Connect app users and groups should be excluded from the search results. If an invalid value is provided, the default value is used.
     */
    excludeConnectAddons?: boolean;
    /**
     * The custom field ID of the field this request is for.
     */
    fieldId?: string;
    /**
     * The ID of an issue type that returned users and groups must have permission to view. To include multiple issue types, provide an ampersand-separated list. For example, `issueTypeId=10000&issueTypeId=10001`. Special values, such as `-1` (all standard issue types) and `-2` (all subtask issue types), are supported. This parameter is only used when `fieldId` is present.
     */
    issueTypeId?: Array<string>;
    /**
     * The maximum number of items to return in each list.
     */
    maxResults?: number;
    /**
     * The ID of a project that returned users and groups must have permission to view. To include multiple projects, provide an ampersand-separated list. For example, `projectId=10000&projectId=10001`. This parameter is only used when `fieldId` is present.
     */
    projectId?: Array<string>;
    /**
     * The search string.
     */
    query: string;
    /**
     * Whether the user avatar should be returned. If an invalid value is provided, the default value is used.
     */
    showAvatar?: boolean;
  };
};

export type FindUsersAndGroupsResponse = FoundUsersAndGroups;

export type FindUsersAndGroupsError = unknown;

export type GetLicenseResponse = License;

export type GetLicenseError = unknown;

export type CreateIssueData = {
  body: IssueUpdateDetails;
  query?: {
    /**
     * Whether the project in which the issue is created is added to the user's **Recently viewed** project list, as shown under **Projects** in Jira. When provided, the issue type and request type are added to the user's history for a project. These values are then used to provide defaults on the issue create screen.
     */
    updateHistory?: boolean;
  };
};

export type CreateIssueResponse = CreatedIssue;

export type CreateIssueError = ErrorCollection;

export type ArchiveIssuesAsyncData = {
  /**
   * A JQL query specifying the issues to archive. Note that subtasks can only be archived through their parent issues.
   */
  body: ArchiveIssueAsyncRequest;
};

export type ArchiveIssuesAsyncResponse = string;

export type ArchiveIssuesAsyncError = unknown;

export type ArchiveIssuesData = {
  /**
   * Contains a list of issue keys or IDs to be archived.
   */
  body: IssueArchivalSyncRequest;
};

export type ArchiveIssuesResponse = IssueArchivalSyncResponse;

export type ArchiveIssuesError = unknown;

export type CreateIssuesData = {
  body: IssuesUpdateBean;
};

export type CreateIssuesResponse = CreatedIssues;

export type CreateIssuesError = CreatedIssues | unknown;

export type BulkFetchIssuesData = {
  /**
   * A JSON object containing the information about which issues and fields to fetch.
   */
  body: BulkFetchIssueRequestBean;
};

export type BulkFetchIssuesResponse = BulkIssueResults;

export type BulkFetchIssuesError = unknown;

export type GetCreateIssueMetaData = {
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about issue metadata in the response. This parameter accepts `projects.issuetypes.fields`, which returns information about the fields in the issue creation screen for each issue type. Fields hidden from the screen are not returned. Use the information to populate the `fields` and `update` fields in [Create issue](#api-rest-api-3-issue-post) and [Create issues](#api-rest-api-3-issue-bulk-post).
     */
    expand?: string;
    /**
     * List of issue type IDs. This parameter accepts a comma-separated list. Multiple issue type IDs can also be provided using an ampersand-separated list. For example, `issuetypeIds=10000,10001&issuetypeIds=10020,10021`. This parameter may be provided with `issuetypeNames`.
     */
    issuetypeIds?: Array<string>;
    /**
     * List of issue type names. This parameter accepts a comma-separated list. Multiple issue type names can also be provided using an ampersand-separated list. For example, `issuetypeNames=name1,name2&issuetypeNames=name3`. This parameter may be provided with `issuetypeIds`.
     */
    issuetypeNames?: Array<string>;
    /**
     * List of project IDs. This parameter accepts a comma-separated list. Multiple project IDs can also be provided using an ampersand-separated list. For example, `projectIds=10000,10001&projectIds=10020,10021`. This parameter may be provided with `projectKeys`.
     */
    projectIds?: Array<string>;
    /**
     * List of project keys. This parameter accepts a comma-separated list. Multiple project keys can also be provided using an ampersand-separated list. For example, `projectKeys=proj1,proj2&projectKeys=proj3`. This parameter may be provided with `projectIds`.
     */
    projectKeys?: Array<string>;
  };
};

export type GetCreateIssueMetaResponse = IssueCreateMetadata;

export type GetCreateIssueMetaError = unknown;

export type GetCreateIssueMetaIssueTypesData = {
  path: {
    /**
     * The ID or key of the project.
     */
    projectIdOrKey: string;
  };
  query?: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetCreateIssueMetaIssueTypesResponse = PageOfCreateMetaIssueTypes;

export type GetCreateIssueMetaIssueTypesError = unknown;

export type GetCreateIssueMetaIssueTypeIdData = {
  path: {
    /**
     * The issuetype ID.
     */
    issueTypeId: string;
    /**
     * The ID or key of the project.
     */
    projectIdOrKey: string;
  };
  query?: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetCreateIssueMetaIssueTypeIdResponse = PageOfCreateMetaIssueTypeWithField;

export type GetCreateIssueMetaIssueTypeIdError = unknown;

export type GetIssueLimitReportData = {
  body: IssueLimitReportRequest;
  query?: {
    /**
     * Return issue keys instead of issue ids in the response.
     *
     * Usage: Add `?isReturningKeys=true` to the end of the path to request issue keys.
     */
    isReturningKeys?: boolean;
  };
};

export type GetIssueLimitReportResponse = IssueLimitReportResponseBean;

export type GetIssueLimitReportError = unknown;

export type GetIssuePickerResourceData = {
  query?: {
    /**
     * The key of an issue to exclude from search results. For example, the issue the user is viewing when they perform this query.
     */
    currentIssueKey?: string;
    /**
     * A JQL query defining a list of issues to search for the query term. Note that `username` and `userkey` cannot be used as search terms for this parameter, due to privacy reasons. Use `accountId` instead.
     */
    currentJQL?: string;
    /**
     * The ID of a project that suggested issues must belong to.
     */
    currentProjectId?: string;
    /**
     * A string to match against text fields in the issue such as title, description, or comments.
     */
    query?: string;
    /**
     * When `currentIssueKey` is a subtask, whether to include the parent issue in the suggestions if it matches the query.
     */
    showSubTaskParent?: boolean;
    /**
     * Indicate whether to include subtasks in the suggestions list.
     */
    showSubTasks?: boolean;
  };
};

export type GetIssuePickerResourceResponse = IssuePickerSuggestions;

export type GetIssuePickerResourceError = unknown;

export type BulkSetIssuesPropertiesListData = {
  /**
   * Issue properties to be set or updated with values.
   */
  body: IssueEntityProperties;
};

export type BulkSetIssuePropertiesByIssueData = {
  /**
   * Details of the issue properties to be set or updated. Note that if an issue is not found, it is ignored.
   */
  body: MultiIssueEntityProperties;
};

export type BulkDeleteIssuePropertyData = {
  body: IssueFilterForBulkPropertyDelete;
  path: {
    /**
     * The key of the property.
     */
    propertyKey: string;
  };
};

export type BulkSetIssuePropertyData = {
  body: BulkIssuePropertyUpdateRequest;
  path: {
    /**
     * The key of the property. The maximum length is 255 characters.
     */
    propertyKey: string;
  };
};

export type UnarchiveIssuesData = {
  /**
   * Contains a list of issue keys or IDs to be unarchived.
   */
  body: IssueArchivalSyncRequest;
};

export type UnarchiveIssuesResponse = IssueArchivalSyncResponse;

export type UnarchiveIssuesError = unknown;

export type GetIsWatchingIssueBulkData = {
  /**
   * A list of issue IDs.
   */
  body: IssueList;
};

export type GetIsWatchingIssueBulkResponse = BulkIssueIsWatching;

export type GetIsWatchingIssueBulkError = unknown;

export type DeleteIssueData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    /**
     * Whether the issue's subtasks are deleted when the issue is deleted.
     */
    deleteSubtasks?: 'true' | 'false';
  };
};

export type DeleteIssueResponse = any;

export type DeleteIssueError = unknown;

export type GetIssueData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about the issues in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `renderedFields` Returns field values rendered in HTML format.
     * *  `names` Returns the display name of each field.
     * *  `schema` Returns the schema describing a field type.
     * *  `transitions` Returns all possible transitions for the issue.
     * *  `editmeta` Returns information about how each field can be edited.
     * *  `changelog` Returns a list of recent updates to an issue, sorted by date, starting from the most recent.
     * *  `versionedRepresentations` Returns a JSON array for each version of a field's value, with the highest number representing the most recent version. Note: When included in the request, the `fields` parameter is ignored.
     */
    expand?: string;
    /**
     * Whether to fail the request quickly in case of an error while loading fields for an issue. For `failFast=true`, if one field fails, the entire operation fails. For `failFast=false`, the operation will continue even if a field fails. It will return a valid response, but without values for the failed field(s).
     */
    failFast?: boolean;
    /**
     * A list of fields to return for the issue. This parameter accepts a comma-separated list. Use it to retrieve a subset of fields. Allowed values:
     *
     * *  `*all` Returns all fields.
     * *  `*navigable` Returns navigable fields.
     * *  Any issue field, prefixed with a minus to exclude.
     *
     * Examples:
     *
     * *  `summary,comment` Returns only the summary and comments fields.
     * *  `-description` Returns all (default) fields except description.
     * *  `*navigable,-comment` Returns all navigable fields except comment.
     *
     * This parameter may be specified multiple times. For example, `fields=field1,field2& fields=field3`.
     *
     * Note: All fields are returned by default. This differs from [Search for issues using JQL (GET)](#api-rest-api-3-search-get) and [Search for issues using JQL (POST)](#api-rest-api-3-search-post) where the default is all navigable fields.
     */
    fields?: Array<string>;
    /**
     * Whether fields in `fields` are referenced by keys rather than IDs. This parameter is useful where fields have been added by a connect app and a field's key may differ from its ID.
     */
    fieldsByKeys?: boolean;
    /**
     * A list of issue properties to return for the issue. This parameter accepts a comma-separated list. Allowed values:
     *
     * *  `*all` Returns all issue properties.
     * *  Any issue property key, prefixed with a minus to exclude.
     *
     * Examples:
     *
     * *  `*all` Returns all properties.
     * *  `*all,-prop1` Returns all properties except `prop1`.
     * *  `prop1,prop2` Returns `prop1` and `prop2` properties.
     *
     * This parameter may be specified multiple times. For example, `properties=prop1,prop2& properties=prop3`.
     */
    properties?: Array<string>;
    /**
     * Whether the project in which the issue is created is added to the user's **Recently viewed** project list, as shown under **Projects** in Jira. This also populates the [JQL issues search](#api-rest-api-3-search-get) `lastViewed` field.
     */
    updateHistory?: boolean;
  };
};

export type GetIssueResponse = IssueBean;

export type GetIssueError = unknown;

export type EditIssueData = {
  body: IssueUpdateDetails;
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    /**
     * The Get issue API expand parameter to use in the response if the `returnIssue` parameter is `true`.
     */
    expand?: string;
    /**
     * Whether a notification email about the issue update is sent to all watchers. To disable the notification, administer Jira or administer project permissions are required. If the user doesn't have the necessary permission the request is ignored.
     */
    notifyUsers?: boolean;
    /**
     * Whether screen security is overridden to enable uneditable fields to be edited. Available to Connect app users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) and Forge apps acting on behalf of users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     */
    overrideEditableFlag?: boolean;
    /**
     * Whether screen security is overridden to enable hidden fields to be edited. Available to Connect app users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) and Forge apps acting on behalf of users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     */
    overrideScreenSecurity?: boolean;
    /**
     * Whether the response should contain the issue with fields edited in this request. The returned issue will have the same format as in the [Get issue API](#api-rest-api-3-issue-issueidorkey-get).
     */
    returnIssue?: boolean;
  };
};

export type EditIssueResponse = unknown;

export type EditIssueError = unknown;

export type AssignIssueData = {
  /**
   * The request object with the user that the issue is assigned to.
   */
  body: User;
  path: {
    /**
     * The ID or key of the issue to be assigned.
     */
    issueIdOrKey: string;
  };
};

export type AssignIssueResponse = unknown;

export type AssignIssueError = unknown;

export type AddAttachmentData = {
  body: Array<MultipartFile>;
  path: {
    /**
     * The ID or key of the issue that attachments are added to.
     */
    issueIdOrKey: string;
  };
};

export type AddAttachmentResponse = Array<Attachment>;

export type AddAttachmentError = unknown;

export type GetChangeLogsData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetChangeLogsResponse = PageBeanChangelog;

export type GetChangeLogsError = unknown;

export type GetChangeLogsByIdsData = {
  body: IssueChangelogIds;
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
};

export type GetChangeLogsByIdsResponse = PageOfChangelogs;

export type GetChangeLogsByIdsError = unknown;

export type GetCommentsData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about comments in the response. This parameter accepts `renderedBody`, which returns the comment body rendered in HTML.
     */
    expand?: string;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * [Order](#ordering) the results by a field. Accepts *created* to sort comments by their created date.
     */
    orderBy?: 'created' | '-created' | '+created';
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetCommentsResponse = PageOfComments;

export type GetCommentsError = unknown;

export type AddCommentData = {
  body: Comment;
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about comments in the response. This parameter accepts `renderedBody`, which returns the comment body rendered in HTML.
     */
    expand?: string;
  };
};

export type AddCommentResponse = Comment;

export type AddCommentError = unknown;

export type DeleteCommentData = {
  path: {
    /**
     * The ID of the comment.
     */
    id: string;
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    parentId?: string;
  };
};

export type DeleteCommentResponse = any;

export type DeleteCommentError = unknown;

export type GetCommentData = {
  path: {
    /**
     * The ID of the comment.
     */
    id: string;
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about comments in the response. This parameter accepts `renderedBody`, which returns the comment body rendered in HTML.
     */
    expand?: string;
  };
};

export type GetCommentResponse = Comment;

export type GetCommentError = unknown;

export type UpdateCommentData = {
  body: Comment;
  path: {
    /**
     * The ID of the comment.
     */
    id: string;
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about comments in the response. This parameter accepts `renderedBody`, which returns the comment body rendered in HTML.
     */
    expand?: string;
    /**
     * Whether users are notified when a comment is updated.
     */
    notifyUsers?: boolean;
    /**
     * Whether screen security is overridden to enable uneditable fields to be edited. Available to Connect app users with the *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) and Forge apps acting on behalf of users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     */
    overrideEditableFlag?: boolean;
  };
};

export type UpdateCommentResponse = Comment;

export type UpdateCommentError = unknown;

export type GetEditIssueMetaData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    /**
     * Whether non-editable fields are returned. Available to Connect app users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) and Forge apps acting on behalf of users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     */
    overrideEditableFlag?: boolean;
    /**
     * Whether hidden fields are returned. Available to Connect app users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) and Forge apps acting on behalf of users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     */
    overrideScreenSecurity?: boolean;
  };
};

export type GetEditIssueMetaResponse = IssueUpdateMetadata;

export type GetEditIssueMetaError = unknown;

export type NotifyData = {
  /**
   * The request object for the notification and recipients.
   */
  body: Notification;
  path: {
    /**
     * ID or key of the issue that the notification is sent for.
     */
    issueIdOrKey: string;
  };
};

export type NotifyResponse = unknown;

export type NotifyError = unknown;

export type GetIssuePropertyKeysData = {
  path: {
    /**
     * The key or ID of the issue.
     */
    issueIdOrKey: string;
  };
};

export type GetIssuePropertyKeysResponse = PropertyKeys;

export type GetIssuePropertyKeysError = unknown;

export type DeleteIssuePropertyData = {
  path: {
    /**
     * The key or ID of the issue.
     */
    issueIdOrKey: string;
    /**
     * The key of the property.
     */
    propertyKey: string;
  };
};

export type DeleteIssuePropertyResponse = any;

export type DeleteIssuePropertyError = unknown;

export type GetIssuePropertyData = {
  path: {
    /**
     * The key or ID of the issue.
     */
    issueIdOrKey: string;
    /**
     * The key of the property.
     */
    propertyKey: string;
  };
};

export type GetIssuePropertyResponse = EntityProperty;

export type GetIssuePropertyError = unknown;

export type SetIssuePropertyData = {
  /**
   * The value of the property. The value has to be a valid, non-empty [JSON](https://tools.ietf.org/html/rfc4627) value. The maximum length of the property value is 32768 bytes.
   */
  body?: string;
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
    /**
     * The key of the issue property. The maximum length is 255 characters.
     */
    propertyKey: string;
  };
};

export type SetIssuePropertyResponse = unknown;

export type SetIssuePropertyError = unknown;

export type DeleteRemoteIssueLinkByGlobalIdData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
  query: {
    /**
     * The global ID of a remote issue link.
     */
    globalId: string;
  };
};

export type DeleteRemoteIssueLinkByGlobalIdResponse = any;

export type DeleteRemoteIssueLinkByGlobalIdError = unknown;

export type GetRemoteIssueLinksData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    /**
     * The global ID of the remote issue link.
     */
    globalId?: string;
  };
};

export type GetRemoteIssueLinksResponse = RemoteIssueLink;

export type GetRemoteIssueLinksError = unknown;

export type CreateOrUpdateRemoteIssueLinkData = {
  body: RemoteIssueLinkRequest;
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
};

export type CreateOrUpdateRemoteIssueLinkResponse = RemoteIssueLinkIdentifies;

export type CreateOrUpdateRemoteIssueLinkError = unknown;

export type DeleteRemoteIssueLinkByIdData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
    /**
     * The ID of a remote issue link.
     */
    linkId: string;
  };
};

export type DeleteRemoteIssueLinkByIdResponse = any;

export type DeleteRemoteIssueLinkByIdError = unknown;

export type GetRemoteIssueLinkByIdData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
    /**
     * The ID of the remote issue link.
     */
    linkId: string;
  };
};

export type GetRemoteIssueLinkByIdResponse = RemoteIssueLink;

export type GetRemoteIssueLinkByIdError = unknown;

export type UpdateRemoteIssueLinkData = {
  body: RemoteIssueLinkRequest;
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
    /**
     * The ID of the remote issue link.
     */
    linkId: string;
  };
};

export type UpdateRemoteIssueLinkResponse = unknown;

export type UpdateRemoteIssueLinkError = unknown;

export type GetTransitionsData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about transitions in the response. This parameter accepts `transitions.fields`, which returns information about the fields in the transition screen for each transition. Fields hidden from the screen are not returned. Use this information to populate the `fields` and `update` fields in [Transition issue](#api-rest-api-3-issue-issueIdOrKey-transitions-post).
     */
    expand?: string;
    /**
     * Whether details of transitions that fail a condition are included in the response
     */
    includeUnavailableTransitions?: boolean;
    /**
     * Whether transitions with the condition *Hide From User Condition* are included in the response.
     */
    skipRemoteOnlyCondition?: boolean;
    /**
     * Whether the transitions are sorted by ops-bar sequence value first then category order (Todo, In Progress, Done) or only by ops-bar sequence value.
     */
    sortByOpsBarAndStatus?: boolean;
    /**
     * The ID of the transition.
     */
    transitionId?: string;
  };
};

export type GetTransitionsResponse = Transitions;

export type GetTransitionsError = unknown;

export type DoTransitionData = {
  body: IssueUpdateDetails;
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
};

export type DoTransitionResponse = unknown;

export type DoTransitionError = unknown;

export type RemoveVoteData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
};

export type RemoveVoteResponse = any;

export type RemoveVoteError = unknown;

export type GetVotesData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
};

export type GetVotesResponse = Votes;

export type GetVotesError = unknown;

export type AddVoteData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
};

export type AddVoteResponse = unknown;

export type AddVoteError = unknown;

export type RemoveWatcherData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    /**
     * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*. Required.
     */
    accountId?: string;
    /**
     * This parameter is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    username?: string;
  };
};

export type RemoveWatcherResponse = any;

export type RemoveWatcherError = unknown;

export type GetIssueWatchersData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
};

export type GetIssueWatchersResponse = Watchers;

export type GetIssueWatchersError = unknown;

export type AddWatcherData = {
  /**
   * The account ID of the user. Note that username cannot be used due to privacy changes.
   */
  body: string;
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
};

export type AddWatcherResponse = unknown;

export type AddWatcherError = unknown;

export type BulkDeleteWorklogsData = {
  /**
   * A JSON object containing a list of worklog IDs.
   */
  body: WorklogIdsRequestBean;
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    /**
     * Defines how to update the issue's time estimate, the options are:
     *
     * *  `leave` Leaves the estimate unchanged.
     * *  `auto` Reduces the estimate by the aggregate value of `timeSpent` across all worklogs being deleted.
     */
    adjustEstimate?: 'leave' | 'auto';
    /**
     * Whether the work log entries should be removed to the issue even if the issue is not editable, because jira.issue.editable set to false or missing. For example, the issue is closed. Connect and Forge app users with admin permission can use this flag.
     */
    overrideEditableFlag?: boolean;
  };
};

export type BulkDeleteWorklogsResponse = unknown | any;

export type BulkDeleteWorklogsError = unknown;

export type GetIssueWorklogData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about worklogs in the response. This parameter accepts`properties`, which returns worklog properties.
     */
    expand?: string;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
    /**
     * The worklog start date and time, as a UNIX timestamp in milliseconds, after which worklogs are returned.
     */
    startedAfter?: number;
    /**
     * The worklog start date and time, as a UNIX timestamp in milliseconds, before which worklogs are returned.
     */
    startedBefore?: number;
  };
};

export type GetIssueWorklogResponse = PageOfWorklogs;

export type GetIssueWorklogError = unknown;

export type AddWorklogData = {
  body: Worklog;
  path: {
    /**
     * The ID or key the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    /**
     * Defines how to update the issue's time estimate, the options are:
     *
     * *  `new` Sets the estimate to a specific value, defined in `newEstimate`.
     * *  `leave` Leaves the estimate unchanged.
     * *  `manual` Reduces the estimate by amount specified in `reduceBy`.
     * *  `auto` Reduces the estimate by the value of `timeSpent` in the worklog.
     */
    adjustEstimate?: 'new' | 'leave' | 'manual' | 'auto';
    /**
     * Use [expand](#expansion) to include additional information about work logs in the response. This parameter accepts `properties`, which returns worklog properties.
     */
    expand?: string;
    /**
     * The value to set as the issue's remaining time estimate, as days (\#d), hours (\#h), or minutes (\#m or \#). For example, *2d*. Required when `adjustEstimate` is `new`.
     */
    newEstimate?: string;
    /**
     * Whether users watching the issue are notified by email.
     */
    notifyUsers?: boolean;
    /**
     * Whether the worklog entry should be added to the issue even if the issue is not editable, because jira.issue.editable set to false or missing. For example, the issue is closed. Connect and Forge app users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) can use this flag.
     */
    overrideEditableFlag?: boolean;
    /**
     * The amount to reduce the issue's remaining estimate by, as days (\#d), hours (\#h), or minutes (\#m). For example, *2d*. Required when `adjustEstimate` is `manual`.
     */
    reduceBy?: string;
  };
};

export type AddWorklogResponse = Worklog;

export type AddWorklogError = unknown;

export type BulkMoveWorklogsData = {
  /**
   * A JSON object containing a list of worklog IDs and the ID or key of the destination issue.
   */
  body: WorklogsMoveRequestBean;
  path: {
    issueIdOrKey: string;
  };
  query?: {
    /**
     * Defines how to update the issues' time estimate, the options are:
     *
     * *  `leave` Leaves the estimate unchanged.
     * *  `auto` Reduces the estimate by the aggregate value of `timeSpent` across all worklogs being moved in the source issue, and increases it in the destination issue.
     */
    adjustEstimate?: 'leave' | 'auto';
    /**
     * Whether the work log entry should be moved to and from the issues even if the issues are not editable, because jira.issue.editable set to false or missing. For example, the issue is closed. Connect and Forge app users with admin permission can use this flag.
     */
    overrideEditableFlag?: boolean;
  };
};

export type BulkMoveWorklogsResponse = unknown | any;

export type BulkMoveWorklogsError = unknown;

export type DeleteWorklogData = {
  path: {
    /**
     * The ID of the worklog.
     */
    id: string;
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    /**
     * Defines how to update the issue's time estimate, the options are:
     *
     * *  `new` Sets the estimate to a specific value, defined in `newEstimate`.
     * *  `leave` Leaves the estimate unchanged.
     * *  `manual` Increases the estimate by amount specified in `increaseBy`.
     * *  `auto` Reduces the estimate by the value of `timeSpent` in the worklog.
     */
    adjustEstimate?: 'new' | 'leave' | 'manual' | 'auto';
    /**
     * The amount to increase the issue's remaining estimate by, as days (\#d), hours (\#h), or minutes (\#m or \#). For example, *2d*. Required when `adjustEstimate` is `manual`.
     */
    increaseBy?: string;
    /**
     * The value to set as the issue's remaining time estimate, as days (\#d), hours (\#h), or minutes (\#m or \#). For example, *2d*. Required when `adjustEstimate` is `new`.
     */
    newEstimate?: string;
    /**
     * Whether users watching the issue are notified by email.
     */
    notifyUsers?: boolean;
    /**
     * Whether the work log entry should be added to the issue even if the issue is not editable, because jira.issue.editable set to false or missing. For example, the issue is closed. Connect and Forge app users with admin permission can use this flag.
     */
    overrideEditableFlag?: boolean;
  };
};

export type DeleteWorklogResponse = any;

export type DeleteWorklogError = unknown;

export type GetWorklogData = {
  path: {
    /**
     * The ID of the worklog.
     */
    id: string;
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about work logs in the response. This parameter accepts
     *
     * `properties`, which returns worklog properties.
     */
    expand?: string;
  };
};

export type GetWorklogResponse = Worklog;

export type GetWorklogError = unknown;

export type UpdateWorklogData = {
  body: Worklog;
  path: {
    /**
     * The ID of the worklog.
     */
    id: string;
    /**
     * The ID or key the issue.
     */
    issueIdOrKey: string;
  };
  query?: {
    /**
     * Defines how to update the issue's time estimate, the options are:
     *
     * *  `new` Sets the estimate to a specific value, defined in `newEstimate`.
     * *  `leave` Leaves the estimate unchanged.
     * *  `auto` Updates the estimate by the difference between the original and updated value of `timeSpent` or `timeSpentSeconds`.
     */
    adjustEstimate?: 'new' | 'leave' | 'manual' | 'auto';
    /**
     * Use [expand](#expansion) to include additional information about worklogs in the response. This parameter accepts `properties`, which returns worklog properties.
     */
    expand?: string;
    /**
     * The value to set as the issue's remaining time estimate, as days (\#d), hours (\#h), or minutes (\#m or \#). For example, *2d*. Required when `adjustEstimate` is `new`.
     */
    newEstimate?: string;
    /**
     * Whether users watching the issue are notified by email.
     */
    notifyUsers?: boolean;
    /**
     * Whether the worklog should be added to the issue even if the issue is not editable. For example, because the issue is closed. Connect and Forge app users with *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg) can use this flag.
     */
    overrideEditableFlag?: boolean;
  };
};

export type UpdateWorklogResponse = Worklog;

export type UpdateWorklogError = unknown;

export type GetWorklogPropertyKeysData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
    /**
     * The ID of the worklog.
     */
    worklogId: string;
  };
};

export type GetWorklogPropertyKeysResponse = PropertyKeys;

export type GetWorklogPropertyKeysError = unknown;

export type DeleteWorklogPropertyData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
    /**
     * The key of the property.
     */
    propertyKey: string;
    /**
     * The ID of the worklog.
     */
    worklogId: string;
  };
};

export type DeleteWorklogPropertyResponse = any;

export type DeleteWorklogPropertyError = unknown;

export type GetWorklogPropertyData = {
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
    /**
     * The key of the property.
     */
    propertyKey: string;
    /**
     * The ID of the worklog.
     */
    worklogId: string;
  };
};

export type GetWorklogPropertyResponse = EntityProperty;

export type GetWorklogPropertyError = unknown;

export type SetWorklogPropertyData = {
  /**
   * The value of the property. The value has to be a valid, non-empty [JSON](https://tools.ietf.org/html/rfc4627) value. The maximum length of the property value is 32768 bytes.
   */
  body?: string;
  path: {
    /**
     * The ID or key of the issue.
     */
    issueIdOrKey: string;
    /**
     * The key of the issue property. The maximum length is 255 characters.
     */
    propertyKey: string;
    /**
     * The ID of the worklog.
     */
    worklogId: string;
  };
};

export type SetWorklogPropertyResponse = unknown;

export type SetWorklogPropertyError = unknown;

export type LinkIssuesData = {
  /**
   * The issue link request.
   */
  body: LinkIssueRequestJsonBean;
};

export type LinkIssuesResponse = unknown;

export type LinkIssuesError = unknown;

export type DeleteIssueLinkData = {
  path: {
    /**
     * The ID of the issue link.
     */
    linkId: string;
  };
};

export type DeleteIssueLinkResponse = unknown | any;

export type DeleteIssueLinkError = unknown;

export type GetIssueLinkData = {
  path: {
    /**
     * The ID of the issue link.
     */
    linkId: string;
  };
};

export type GetIssueLinkResponse = IssueLink;

export type GetIssueLinkError = unknown;

export type GetIssueLinkTypesResponse = IssueLinkTypes;

export type GetIssueLinkTypesError = unknown;

export type CreateIssueLinkTypeData = {
  body: IssueLinkType;
};

export type CreateIssueLinkTypeResponse = IssueLinkType;

export type CreateIssueLinkTypeError = unknown;

export type DeleteIssueLinkTypeData = {
  path: {
    /**
     * The ID of the issue link type.
     */
    issueLinkTypeId: string;
  };
};

export type DeleteIssueLinkTypeResponse = any;

export type DeleteIssueLinkTypeError = unknown;

export type GetIssueLinkTypeData = {
  path: {
    /**
     * The ID of the issue link type.
     */
    issueLinkTypeId: string;
  };
};

export type GetIssueLinkTypeResponse = IssueLinkType;

export type GetIssueLinkTypeError = unknown;

export type UpdateIssueLinkTypeData = {
  body: IssueLinkType;
  path: {
    /**
     * The ID of the issue link type.
     */
    issueLinkTypeId: string;
  };
};

export type UpdateIssueLinkTypeResponse = IssueLinkType;

export type UpdateIssueLinkTypeError = unknown;

export type ExportArchivedIssuesData = {
  /**
   * You can filter the issues in your request by the `projects`, `archivedBy`, `archivedDate`, `issueTypes`, and `reporters` fields. All filters are optional. If you don't provide any filters, you'll get a list of up to one million archived issues.
   */
  body: ArchivedIssuesFilterRequest;
};

export type ExportArchivedIssuesResponse = ExportArchivedIssuesTaskProgressResponse;

export type ExportArchivedIssuesError = unknown;

export type GetIssueSecuritySchemesResponse = SecuritySchemes;

export type GetIssueSecuritySchemesError = unknown;

export type CreateIssueSecuritySchemeData = {
  body: CreateIssueSecuritySchemeDetails;
};

export type CreateIssueSecuritySchemeResponse = SecuritySchemeId;

export type CreateIssueSecuritySchemeError = ErrorCollection;

export type GetSecurityLevelsData = {
  query?: {
    /**
     * The list of issue security scheme level IDs. To include multiple issue security levels, separate IDs with an ampersand: `id=10000&id=10001`.
     */
    id?: Array<string>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: string;
    /**
     * When set to true, returns multiple default levels for each security scheme containing a default. If you provide scheme and level IDs not associated with the default, returns an empty page. The default value is false.
     */
    onlyDefault?: boolean;
    /**
     * The list of issue security scheme IDs. To include multiple issue security schemes, separate IDs with an ampersand: `schemeId=10000&schemeId=10001`.
     */
    schemeId?: Array<string>;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: string;
  };
};

export type GetSecurityLevelsResponse = PageBeanSecurityLevel;

export type GetSecurityLevelsError = ErrorCollection;

export type SetDefaultLevelsData = {
  body: SetDefaultLevelsRequest;
};

export type SetDefaultLevelsResponse = unknown;

export type SetDefaultLevelsError = ErrorCollection;

export type GetSecurityLevelMembersData = {
  query?: {
    /**
     * Use expand to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `all` Returns all expandable information
     * *  `field` Returns information about the custom field granted the permission
     * *  `group` Returns information about the group that is granted the permission
     * *  `projectRole` Returns information about the project role granted the permission
     * *  `user` Returns information about the user who is granted the permission
     */
    expand?: string;
    /**
     * The list of issue security level member IDs. To include multiple issue security level members separate IDs with an ampersand: `id=10000&id=10001`.
     */
    id?: Array<string>;
    /**
     * The list of issue security level IDs. To include multiple issue security levels separate IDs with an ampersand: `levelId=10000&levelId=10001`.
     */
    levelId?: Array<string>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: string;
    /**
     * The list of issue security scheme IDs. To include multiple issue security schemes separate IDs with an ampersand: `schemeId=10000&schemeId=10001`.
     */
    schemeId?: Array<string>;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: string;
  };
};

export type GetSecurityLevelMembersResponse = PageBeanSecurityLevelMember;

export type GetSecurityLevelMembersError = unknown;

export type SearchProjectsUsingSecuritySchemesData = {
  query?: {
    /**
     * The list of security scheme IDs to be filtered out.
     */
    issueSecuritySchemeId?: Array<string>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: string;
    /**
     * The list of project IDs to be filtered out.
     */
    projectId?: Array<string>;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: string;
  };
};

export type SearchProjectsUsingSecuritySchemesResponse = PageBeanIssueSecuritySchemeToProjectMapping;

export type SearchProjectsUsingSecuritySchemesError = ErrorCollection;

export type AssociateSchemesToProjectsData = {
  body: AssociateSecuritySchemeWithProjectDetails;
};

export type SearchSecuritySchemesData = {
  query?: {
    /**
     * The list of issue security scheme IDs. To include multiple issue security scheme IDs, separate IDs with an ampersand: `id=10000&id=10001`.
     */
    id?: Array<string>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: string;
    /**
     * The list of project IDs. To include multiple project IDs, separate IDs with an ampersand: `projectId=10000&projectId=10001`.
     */
    projectId?: Array<string>;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: string;
  };
};

export type SearchSecuritySchemesResponse = PageBeanSecuritySchemeWithProjects;

export type SearchSecuritySchemesError = unknown;

export type GetIssueSecuritySchemeData = {
  path: {
    /**
     * The ID of the issue security scheme. Use the [Get issue security schemes](#api-rest-api-3-issuesecurityschemes-get) operation to get a list of issue security scheme IDs.
     */
    id: number;
  };
};

export type GetIssueSecuritySchemeResponse = SecurityScheme;

export type GetIssueSecuritySchemeError = unknown;

export type UpdateIssueSecuritySchemeData = {
  body: UpdateIssueSecuritySchemeRequestBean;
  path: {
    /**
     * The ID of the issue security scheme.
     */
    id: string;
  };
};

export type UpdateIssueSecuritySchemeResponse = unknown;

export type UpdateIssueSecuritySchemeError = ErrorCollection;

export type GetIssueSecurityLevelMembersData = {
  path: {
    /**
     * The ID of the issue security scheme. Use the [Get issue security schemes](#api-rest-api-3-issuesecurityschemes-get) operation to get a list of issue security scheme IDs.
     */
    issueSecuritySchemeId: number;
  };
  query?: {
    /**
     * Use expand to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `all` Returns all expandable information.
     * *  `field` Returns information about the custom field granted the permission.
     * *  `group` Returns information about the group that is granted the permission.
     * *  `projectRole` Returns information about the project role granted the permission.
     * *  `user` Returns information about the user who is granted the permission.
     */
    expand?: string;
    /**
     * The list of issue security level IDs. To include multiple issue security levels separate IDs with ampersand: `issueSecurityLevelId=10000&issueSecurityLevelId=10001`.
     */
    issueSecurityLevelId?: Array<string>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetIssueSecurityLevelMembersResponse = PageBeanIssueSecurityLevelMember;

export type GetIssueSecurityLevelMembersError = unknown;

export type DeleteSecuritySchemeData = {
  path: {
    /**
     * The ID of the issue security scheme.
     */
    schemeId: string;
  };
};

export type DeleteSecuritySchemeResponse = unknown;

export type DeleteSecuritySchemeError = ErrorCollection;

export type AddSecurityLevelData = {
  body: AddSecuritySchemeLevelsRequestBean;
  path: {
    /**
     * The ID of the issue security scheme.
     */
    schemeId: string;
  };
};

export type AddSecurityLevelResponse = unknown;

export type AddSecurityLevelError = ErrorCollection;

export type RemoveLevelData = {
  path: {
    /**
     * The ID of the issue security level to remove.
     */
    levelId: string;
    /**
     * The ID of the issue security scheme.
     */
    schemeId: string;
  };
  query?: {
    /**
     * The ID of the issue security level that will replace the currently selected level.
     */
    replaceWith?: string;
  };
};

export type UpdateSecurityLevelData = {
  body: UpdateIssueSecurityLevelDetails;
  path: {
    /**
     * The ID of the issue security level to update.
     */
    levelId: string;
    /**
     * The ID of the issue security scheme level belongs to.
     */
    schemeId: string;
  };
};

export type UpdateSecurityLevelResponse = unknown;

export type UpdateSecurityLevelError = ErrorCollection;

export type AddSecurityLevelMembersData = {
  body: SecuritySchemeMembersRequest;
  path: {
    /**
     * The ID of the issue security level.
     */
    levelId: string;
    /**
     * The ID of the issue security scheme.
     */
    schemeId: string;
  };
};

export type AddSecurityLevelMembersResponse = unknown;

export type AddSecurityLevelMembersError = ErrorCollection;

export type RemoveMemberFromSecurityLevelData = {
  path: {
    /**
     * The ID of the issue security level.
     */
    levelId: string;
    /**
     * The ID of the issue security level member to be removed.
     */
    memberId: string;
    /**
     * The ID of the issue security scheme.
     */
    schemeId: string;
  };
};

export type RemoveMemberFromSecurityLevelResponse = unknown;

export type RemoveMemberFromSecurityLevelError = ErrorCollection;

export type GetIssueAllTypesResponse = Array<IssueTypeDetails>;

export type GetIssueAllTypesError = unknown;

export type CreateIssueTypeData = {
  body: IssueTypeCreateBean;
};

export type CreateIssueTypeResponse = IssueTypeDetails;

export type CreateIssueTypeError = unknown;

export type GetIssueTypesForProjectData = {
  query: {
    /**
     * The level of the issue type to filter by. Use:
     *
     * *  `-1` for Subtask.
     * *  `0` for Base.
     * *  `1` for Epic.
     */
    level?: number;
    /**
     * The ID of the project.
     */
    projectId: number;
  };
};

export type GetIssueTypesForProjectResponse = Array<IssueTypeDetails>;

export type GetIssueTypesForProjectError = unknown;

export type DeleteIssueTypeData = {
  path: {
    /**
     * The ID of the issue type.
     */
    id: string;
  };
  query?: {
    /**
     * The ID of the replacement issue type.
     */
    alternativeIssueTypeId?: string;
  };
};

export type DeleteIssueTypeResponse = any;

export type DeleteIssueTypeError = unknown;

export type GetIssueTypeData = {
  path: {
    /**
     * The ID of the issue type.
     */
    id: string;
  };
};

export type GetIssueTypeResponse = IssueTypeDetails;

export type GetIssueTypeError = unknown;

export type UpdateIssueTypeData = {
  body: IssueTypeUpdateBean;
  path: {
    /**
     * The ID of the issue type.
     */
    id: string;
  };
};

export type UpdateIssueTypeResponse = IssueTypeDetails;

export type UpdateIssueTypeError = unknown;

export type GetAlternativeIssueTypesData = {
  path: {
    /**
     * The ID of the issue type.
     */
    id: string;
  };
};

export type GetAlternativeIssueTypesResponse = Array<IssueTypeDetails>;

export type GetAlternativeIssueTypesError = unknown;

export type CreateIssueTypeAvatarData = {
  body?: string;
  path: {
    /**
     * The ID of the issue type.
     */
    id: string;
  };
  query: {
    /**
     * The length of each side of the crop region.
     */
    size: number;
    /**
     * The X coordinate of the top-left corner of the crop region.
     */
    x?: number;
    /**
     * The Y coordinate of the top-left corner of the crop region.
     */
    y?: number;
  };
};

export type CreateIssueTypeAvatarResponse = Avatar;

export type CreateIssueTypeAvatarError = unknown;

export type GetIssueTypePropertyKeysData = {
  path: {
    /**
     * The ID of the issue type.
     */
    issueTypeId: string;
  };
};

export type GetIssueTypePropertyKeysResponse = PropertyKeys;

export type GetIssueTypePropertyKeysError = unknown;

export type DeleteIssueTypePropertyData = {
  path: {
    /**
     * The ID of the issue type.
     */
    issueTypeId: string;
    /**
     * The key of the property. Use [Get issue type property keys](#api-rest-api-3-issuetype-issueTypeId-properties-get) to get a list of all issue type property keys.
     */
    propertyKey: string;
  };
};

export type DeleteIssueTypePropertyResponse = any;

export type DeleteIssueTypePropertyError = unknown;

export type GetIssueTypePropertyData = {
  path: {
    /**
     * The ID of the issue type.
     */
    issueTypeId: string;
    /**
     * The key of the property. Use [Get issue type property keys](#api-rest-api-3-issuetype-issueTypeId-properties-get) to get a list of all issue type property keys.
     */
    propertyKey: string;
  };
};

export type GetIssueTypePropertyResponse = EntityProperty;

export type GetIssueTypePropertyError = unknown;

export type SetIssueTypePropertyData = {
  /**
   * The value of the property. The value has to be a valid, non-empty [JSON](https://tools.ietf.org/html/rfc4627) value. The maximum length of the property value is 32768 bytes.
   */
  body?: string;
  path: {
    /**
     * The ID of the issue type.
     */
    issueTypeId: string;
    /**
     * The key of the issue type property. The maximum length is 255 characters.
     */
    propertyKey: string;
  };
};

export type SetIssueTypePropertyResponse = unknown;

export type SetIssueTypePropertyError = unknown;

export type GetAllIssueTypeSchemesData = {
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `projects` For each issue type schemes, returns information about the projects the issue type scheme is assigned to.
     * *  `issueTypes` For each issue type schemes, returns information about the issueTypes the issue type scheme have.
     */
    expand?: string;
    /**
     * The list of issue type schemes IDs. To include multiple IDs, provide an ampersand-separated list. For example, `id=10000&id=10001`.
     */
    id?: Array<number>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * [Order](#ordering) the results by a field:
     *
     * *  `name` Sorts by issue type scheme name.
     * *  `id` Sorts by issue type scheme ID.
     */
    orderBy?: 'name' | '-name' | '+name' | 'id' | '-id' | '+id';
    /**
     * String used to perform a case-insensitive partial match with issue type scheme name.
     */
    queryString?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetAllIssueTypeSchemesResponse = PageBeanIssueTypeScheme;

export type GetAllIssueTypeSchemesError = unknown;

export type CreateIssueTypeSchemeData = {
  body: IssueTypeSchemeDetails;
};

export type CreateIssueTypeSchemeResponse = IssueTypeSchemeID;

export type CreateIssueTypeSchemeError = unknown;

export type GetIssueTypeSchemesMappingData = {
  query?: {
    /**
     * The list of issue type scheme IDs. To include multiple IDs, provide an ampersand-separated list. For example, `issueTypeSchemeId=10000&issueTypeSchemeId=10001`.
     */
    issueTypeSchemeId?: Array<number>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetIssueTypeSchemesMappingResponse = PageBeanIssueTypeSchemeMapping;

export type GetIssueTypeSchemesMappingError = unknown;

export type GetIssueTypeSchemeForProjectsData = {
  query: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The list of project IDs. To include multiple project IDs, provide an ampersand-separated list. For example, `projectId=10000&projectId=10001`.
     */
    projectId: Array<number>;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetIssueTypeSchemeForProjectsResponse = PageBeanIssueTypeSchemeProjects;

export type GetIssueTypeSchemeForProjectsError = unknown;

export type AssignIssueTypeSchemeToProjectData = {
  body: IssueTypeSchemeProjectAssociation;
};

export type AssignIssueTypeSchemeToProjectResponse = unknown;

export type AssignIssueTypeSchemeToProjectError = unknown;

export type DeleteIssueTypeSchemeData = {
  path: {
    /**
     * The ID of the issue type scheme.
     */
    issueTypeSchemeId: number;
  };
};

export type DeleteIssueTypeSchemeResponse = unknown;

export type DeleteIssueTypeSchemeError = unknown;

export type UpdateIssueTypeSchemeData = {
  body: IssueTypeSchemeUpdateDetails;
  path: {
    /**
     * The ID of the issue type scheme.
     */
    issueTypeSchemeId: number;
  };
};

export type UpdateIssueTypeSchemeResponse = unknown;

export type UpdateIssueTypeSchemeError = unknown;

export type AddIssueTypesToIssueTypeSchemeData = {
  body: IssueTypeIds;
  path: {
    /**
     * The ID of the issue type scheme.
     */
    issueTypeSchemeId: number;
  };
};

export type AddIssueTypesToIssueTypeSchemeResponse = unknown;

export type AddIssueTypesToIssueTypeSchemeError = unknown;

export type ReorderIssueTypesInIssueTypeSchemeData = {
  body: OrderOfIssueTypes;
  path: {
    /**
     * The ID of the issue type scheme.
     */
    issueTypeSchemeId: number;
  };
};

export type ReorderIssueTypesInIssueTypeSchemeResponse = unknown;

export type ReorderIssueTypesInIssueTypeSchemeError = unknown;

export type RemoveIssueTypeFromIssueTypeSchemeData = {
  path: {
    /**
     * The ID of the issue type.
     */
    issueTypeId: number;
    /**
     * The ID of the issue type scheme.
     */
    issueTypeSchemeId: number;
  };
};

export type RemoveIssueTypeFromIssueTypeSchemeResponse = unknown;

export type RemoveIssueTypeFromIssueTypeSchemeError = unknown;

export type GetIssueTypeScreenSchemesData = {
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts `projects` that, for each issue type screen schemes, returns information about the projects the issue type screen scheme is assigned to.
     */
    expand?: string;
    /**
     * The list of issue type screen scheme IDs. To include multiple IDs, provide an ampersand-separated list. For example, `id=10000&id=10001`.
     */
    id?: Array<number>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * [Order](#ordering) the results by a field:
     *
     * *  `name` Sorts by issue type screen scheme name.
     * *  `id` Sorts by issue type screen scheme ID.
     */
    orderBy?: 'name' | '-name' | '+name' | 'id' | '-id' | '+id';
    /**
     * String used to perform a case-insensitive partial match with issue type screen scheme name.
     */
    queryString?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetIssueTypeScreenSchemesResponse = PageBeanIssueTypeScreenScheme;

export type GetIssueTypeScreenSchemesError = unknown;

export type CreateIssueTypeScreenSchemeData = {
  /**
   * An issue type screen scheme bean.
   */
  body: IssueTypeScreenSchemeDetails;
};

export type CreateIssueTypeScreenSchemeResponse = IssueTypeScreenSchemeId;

export type CreateIssueTypeScreenSchemeError = unknown;

export type GetIssueTypeScreenSchemeMappingsData = {
  query?: {
    /**
     * The list of issue type screen scheme IDs. To include multiple issue type screen schemes, separate IDs with ampersand: `issueTypeScreenSchemeId=10000&issueTypeScreenSchemeId=10001`.
     */
    issueTypeScreenSchemeId?: Array<number>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetIssueTypeScreenSchemeMappingsResponse = PageBeanIssueTypeScreenSchemeItem;

export type GetIssueTypeScreenSchemeMappingsError = unknown;

export type GetIssueTypeScreenSchemeProjectAssociationsData = {
  query: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The list of project IDs. To include multiple projects, separate IDs with ampersand: `projectId=10000&projectId=10001`.
     */
    projectId: Array<number>;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetIssueTypeScreenSchemeProjectAssociationsResponse = PageBeanIssueTypeScreenSchemesProjects;

export type GetIssueTypeScreenSchemeProjectAssociationsError = unknown;

export type AssignIssueTypeScreenSchemeToProjectData = {
  body: IssueTypeScreenSchemeProjectAssociation;
};

export type AssignIssueTypeScreenSchemeToProjectResponse = unknown;

export type AssignIssueTypeScreenSchemeToProjectError = unknown;

export type DeleteIssueTypeScreenSchemeData = {
  path: {
    /**
     * The ID of the issue type screen scheme.
     */
    issueTypeScreenSchemeId: string;
  };
};

export type DeleteIssueTypeScreenSchemeResponse = unknown;

export type DeleteIssueTypeScreenSchemeError = unknown;

export type UpdateIssueTypeScreenSchemeData = {
  /**
   * The issue type screen scheme update details.
   */
  body: IssueTypeScreenSchemeUpdateDetails;
  path: {
    /**
     * The ID of the issue type screen scheme.
     */
    issueTypeScreenSchemeId: string;
  };
};

export type UpdateIssueTypeScreenSchemeResponse = unknown;

export type UpdateIssueTypeScreenSchemeError = unknown;

export type AppendMappingsForIssueTypeScreenSchemeData = {
  body: IssueTypeScreenSchemeMappingDetails;
  path: {
    /**
     * The ID of the issue type screen scheme.
     */
    issueTypeScreenSchemeId: string;
  };
};

export type AppendMappingsForIssueTypeScreenSchemeResponse = unknown;

export type AppendMappingsForIssueTypeScreenSchemeError = unknown;

export type UpdateDefaultScreenSchemeData = {
  body: UpdateDefaultScreenScheme;
  path: {
    /**
     * The ID of the issue type screen scheme.
     */
    issueTypeScreenSchemeId: string;
  };
};

export type UpdateDefaultScreenSchemeResponse = unknown;

export type UpdateDefaultScreenSchemeError = unknown;

export type RemoveMappingsFromIssueTypeScreenSchemeData = {
  body: IssueTypeIds;
  path: {
    /**
     * The ID of the issue type screen scheme.
     */
    issueTypeScreenSchemeId: string;
  };
};

export type RemoveMappingsFromIssueTypeScreenSchemeResponse = unknown;

export type RemoveMappingsFromIssueTypeScreenSchemeError = unknown;

export type GetProjectsForIssueTypeScreenSchemeData = {
  path: {
    /**
     * The ID of the issue type screen scheme.
     */
    issueTypeScreenSchemeId: number;
  };
  query?: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    query?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetProjectsForIssueTypeScreenSchemeResponse = PageBeanProjectDetails;

export type GetProjectsForIssueTypeScreenSchemeError = unknown;

export type GetAutoCompleteResponse = JQLReferenceData;

export type GetAutoCompleteError = unknown;

export type GetAutoCompletePostData = {
  body: SearchAutoCompleteFilter;
};

export type GetAutoCompletePostResponse = JQLReferenceData;

export type GetAutoCompletePostError = unknown;

export type GetFieldAutoCompleteForQueryStringData = {
  query?: {
    /**
     * The name of the field.
     */
    fieldName?: string;
    /**
     * The partial field item name entered by the user.
     */
    fieldValue?: string;
    /**
     * The name of the [ CHANGED operator predicate](https://confluence.atlassian.com/x/hQORLQ#Advancedsearching-operatorsreference-CHANGEDCHANGED) for which the suggestions are generated. The valid predicate operators are *by*, *from*, and *to*.
     */
    predicateName?: string;
    /**
     * The partial predicate item name entered by the user.
     */
    predicateValue?: string;
  };
};

export type GetFieldAutoCompleteForQueryStringResponse = AutoCompleteSuggestions;

export type GetFieldAutoCompleteForQueryStringError = unknown;

export type GetPrecomputationsData = {
  query?: {
    /**
     * The function key in format:
     *
     * *  Forge: `ari:cloud:ecosystem::extension/[App ID]/[Environment ID]/static/[Function key from manifest]`
     * *  Connect: `[App key]__[Module key]`
     */
    functionKey?: Array<string>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * [Order](#ordering) the results by a field:
     *
     * *  `functionKey` Sorts by the functionKey.
     * *  `used` Sorts by the used timestamp.
     * *  `created` Sorts by the created timestamp.
     * *  `updated` Sorts by the updated timestamp.
     */
    orderBy?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetPrecomputationsResponse = PageBeanJqlFunctionPrecomputationBean;

export type GetPrecomputationsError = unknown;

export type UpdatePrecomputationsData = {
  body: JqlFunctionPrecomputationUpdateRequestBean;
};

export type UpdatePrecomputationsResponse = unknown;

export type UpdatePrecomputationsError = unknown;

export type MatchIssuesData = {
  body: IssuesAndJQLQueries;
};

export type MatchIssuesResponse = IssueMatches;

export type MatchIssuesError = unknown;

export type ParseJqlQueriesData = {
  body: JqlQueriesToParse;
  query: {
    /**
     * How to validate the JQL query and treat the validation results. Validation options include:
     *
     * *  `strict` Returns all errors. If validation fails, the query structure is not returned.
     * *  `warn` Returns all errors. If validation fails but the JQL query is correctly formed, the query structure is returned.
     * *  `none` No validation is performed. If JQL query is correctly formed, the query structure is returned.
     */
    validation: 'strict' | 'warn' | 'none';
  };
};

export type ParseJqlQueriesResponse = ParsedJqlQueries;

export type ParseJqlQueriesError = ErrorCollection | unknown;

export type MigrateQueriesData = {
  body: JQLPersonalDataMigrationRequest;
};

export type MigrateQueriesResponse = ConvertedJQLQueries;

export type MigrateQueriesError = string;

export type SanitiseJqlQueriesData = {
  body: JqlQueriesToSanitize;
};

export type SanitiseJqlQueriesResponse = SanitizedJqlQueries;

export type SanitiseJqlQueriesError = ErrorCollection;

export type GetAllLabelsData = {
  query?: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetAllLabelsResponse = PageBeanString;

export type GetAllLabelsError = unknown;

export type GetApproximateLicenseCountResponse = LicenseMetric;

export type GetApproximateLicenseCountError = ErrorCollections;

export type GetApproximateApplicationLicenseCountData = {
  path: {
    /**
     * The ID of the application, represents a specific version of Jira.
     */
    applicationKey: 'jira-core' | 'jira-product-discovery' | 'jira-software' | 'jira-servicedesk';
  };
};

export type GetApproximateApplicationLicenseCountResponse = LicenseMetric;

export type GetApproximateApplicationLicenseCountError = ErrorCollection;

export type GetMyPermissionsData = {
  query?: {
    /**
     * The ID of the comment.
     */
    commentId?: string;
    /**
     * The ID of the issue.
     */
    issueId?: string;
    /**
     * The key of the issue. Ignored if `issueId` is provided.
     */
    issueKey?: string;
    /**
     * A list of permission keys. (Required) This parameter accepts a comma-separated list. To get the list of available permissions, use [Get all permissions](#api-rest-api-3-permissions-get).
     */
    permissions?: string;
    projectConfigurationUuid?: string;
    /**
     * The ID of project.
     */
    projectId?: string;
    /**
     * The key of project. Ignored if `projectId` is provided.
     */
    projectKey?: string;
    projectUuid?: string;
  };
};

export type GetMyPermissionsResponse = Permissions;

export type GetMyPermissionsError = ErrorCollection;

export type RemovePreferenceData = {
  query: {
    /**
     * The key of the preference.
     */
    key: string;
  };
};

export type RemovePreferenceResponse = any;

export type RemovePreferenceError = unknown;

export type GetPreferenceData = {
  query: {
    /**
     * The key of the preference.
     */
    key: string;
  };
};

export type GetPreferenceResponse = string;

export type GetPreferenceError = unknown;

export type SetPreferenceData = {
  /**
   * The value of the preference as a plain text string. The maximum length is 255 characters.
   */
  body: string;
  query: {
    /**
     * The key of the preference. The maximum length is 255 characters.
     */
    key: string;
  };
};

export type SetPreferenceResponse = unknown;

export type SetPreferenceError = unknown;

export type DeleteLocaleResponse = unknown;

export type DeleteLocaleError = unknown;

export type GetLocaleResponse = Locale;

export type GetLocaleError = unknown;

export type SetLocaleData = {
  /**
   * The locale defined in a LocaleBean.
   */
  body: Locale;
};

export type SetLocaleResponse = unknown;

export type SetLocaleError = unknown;

export type GetCurrentUserData = {
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about user in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `groups` Returns all groups, including nested groups, the user belongs to.
     * *  `applicationRoles` Returns the application roles the user is assigned to.
     */
    expand?: string;
  };
};

export type GetCurrentUserResponse = User;

export type GetCurrentUserError = unknown;

export type GetNotificationSchemesData = {
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `all` Returns all expandable information
     * *  `field` Returns information about any custom fields assigned to receive an event
     * *  `group` Returns information about any groups assigned to receive an event
     * *  `notificationSchemeEvents` Returns a list of event associations. This list is returned for all expandable information
     * *  `projectRole` Returns information about any project roles assigned to receive an event
     * *  `user` Returns information about any users assigned to receive an event
     */
    expand?: string;
    /**
     * The list of notification schemes IDs to be filtered by
     */
    id?: Array<string>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: string;
    /**
     * When set to true, returns only the default notification scheme. If you provide project IDs not associated with the default, returns an empty page. The default value is false.
     */
    onlyDefault?: boolean;
    /**
     * The list of projects IDs to be filtered by
     */
    projectId?: Array<string>;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: string;
  };
};

export type GetNotificationSchemesResponse = PageBeanNotificationScheme;

export type GetNotificationSchemesError = unknown;

export type CreateNotificationSchemeData = {
  body: CreateNotificationSchemeDetails;
};

export type CreateNotificationSchemeResponse = NotificationSchemeId;

export type CreateNotificationSchemeError = ErrorCollection;

export type GetNotificationSchemeToProjectMappingsData = {
  query?: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: string;
    /**
     * The list of notifications scheme IDs to be filtered out
     */
    notificationSchemeId?: Array<string>;
    /**
     * The list of project IDs to be filtered out
     */
    projectId?: Array<string>;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: string;
  };
};

export type GetNotificationSchemeToProjectMappingsResponse = PageBeanNotificationSchemeAndProjectMappingJsonBean;

export type GetNotificationSchemeToProjectMappingsError = ErrorCollection;

export type GetNotificationSchemeData = {
  path: {
    /**
     * The ID of the notification scheme. Use [Get notification schemes paginated](#api-rest-api-3-notificationscheme-get) to get a list of notification scheme IDs.
     */
    id: number;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `all` Returns all expandable information
     * *  `field` Returns information about any custom fields assigned to receive an event
     * *  `group` Returns information about any groups assigned to receive an event
     * *  `notificationSchemeEvents` Returns a list of event associations. This list is returned for all expandable information
     * *  `projectRole` Returns information about any project roles assigned to receive an event
     * *  `user` Returns information about any users assigned to receive an event
     */
    expand?: string;
  };
};

export type GetNotificationSchemeResponse = NotificationScheme;

export type GetNotificationSchemeError = unknown;

export type UpdateNotificationSchemeData = {
  body: UpdateNotificationSchemeDetails;
  path: {
    /**
     * The ID of the notification scheme.
     */
    id: string;
  };
};

export type UpdateNotificationSchemeResponse = unknown;

export type UpdateNotificationSchemeError = ErrorCollection;

export type AddNotificationsData = {
  body: AddNotificationsDetails;
  path: {
    /**
     * The ID of the notification scheme.
     */
    id: string;
  };
};

export type AddNotificationsResponse = unknown;

export type AddNotificationsError = ErrorCollection;

export type DeleteNotificationSchemeData = {
  path: {
    /**
     * The ID of the notification scheme.
     */
    notificationSchemeId: string;
  };
};

export type DeleteNotificationSchemeResponse = unknown;

export type DeleteNotificationSchemeError = ErrorCollection;

export type RemoveNotificationFromNotificationSchemeData = {
  path: {
    /**
     * The ID of the notification.
     */
    notificationId: string;
    /**
     * The ID of the notification scheme.
     */
    notificationSchemeId: string;
  };
};

export type RemoveNotificationFromNotificationSchemeResponse = unknown;

export type RemoveNotificationFromNotificationSchemeError = ErrorCollection;

export type GetAllPermissionsResponse = Permissions;

export type GetAllPermissionsError = unknown;

export type GetBulkPermissionsData = {
  /**
   * Details of the permissions to check.
   */
  body: BulkPermissionsRequestBean;
};

export type GetBulkPermissionsResponse = BulkPermissionGrants;

export type GetBulkPermissionsError = ErrorCollection;

export type GetPermittedProjectsData = {
  body: PermissionsKeysBean;
};

export type GetPermittedProjectsResponse = PermittedProjects;

export type GetPermittedProjectsError = unknown;

export type GetAllPermissionSchemesData = {
  query?: {
    /**
     * Use expand to include additional information in the response. This parameter accepts a comma-separated list. Note that permissions are included when you specify any value. Expand options include:
     *
     * *  `all` Returns all expandable information.
     * *  `field` Returns information about the custom field granted the permission.
     * *  `group` Returns information about the group that is granted the permission.
     * *  `permissions` Returns all permission grants for each permission scheme.
     * *  `projectRole` Returns information about the project role granted the permission.
     * *  `user` Returns information about the user who is granted the permission.
     */
    expand?: string;
  };
};

export type GetAllPermissionSchemesResponse = PermissionSchemes;

export type GetAllPermissionSchemesError = unknown;

export type CreatePermissionSchemeData = {
  /**
   * The permission scheme to create.
   */
  body: PermissionScheme;
  query?: {
    /**
     * Use expand to include additional information in the response. This parameter accepts a comma-separated list. Note that permissions are always included when you specify any value. Expand options include:
     *
     * *  `all` Returns all expandable information.
     * *  `field` Returns information about the custom field granted the permission.
     * *  `group` Returns information about the group that is granted the permission.
     * *  `permissions` Returns all permission grants for each permission scheme.
     * *  `projectRole` Returns information about the project role granted the permission.
     * *  `user` Returns information about the user who is granted the permission.
     */
    expand?: string;
  };
};

export type CreatePermissionSchemeResponse = PermissionScheme;

export type CreatePermissionSchemeError = unknown;

export type DeletePermissionSchemeData = {
  path: {
    /**
     * The ID of the permission scheme being deleted.
     */
    schemeId: number;
  };
};

export type DeletePermissionSchemeResponse = any;

export type DeletePermissionSchemeError = unknown;

export type GetPermissionSchemeData = {
  path: {
    /**
     * The ID of the permission scheme to return.
     */
    schemeId: number;
  };
  query?: {
    /**
     * Use expand to include additional information in the response. This parameter accepts a comma-separated list. Note that permissions are included when you specify any value. Expand options include:
     *
     * *  `all` Returns all expandable information.
     * *  `field` Returns information about the custom field granted the permission.
     * *  `group` Returns information about the group that is granted the permission.
     * *  `permissions` Returns all permission grants for each permission scheme.
     * *  `projectRole` Returns information about the project role granted the permission.
     * *  `user` Returns information about the user who is granted the permission.
     */
    expand?: string;
  };
};

export type GetPermissionSchemeResponse = PermissionScheme;

export type GetPermissionSchemeError = unknown;

export type UpdatePermissionSchemeData = {
  body: PermissionScheme;
  path: {
    /**
     * The ID of the permission scheme to update.
     */
    schemeId: number;
  };
  query?: {
    /**
     * Use expand to include additional information in the response. This parameter accepts a comma-separated list. Note that permissions are always included when you specify any value. Expand options include:
     *
     * *  `all` Returns all expandable information.
     * *  `field` Returns information about the custom field granted the permission.
     * *  `group` Returns information about the group that is granted the permission.
     * *  `permissions` Returns all permission grants for each permission scheme.
     * *  `projectRole` Returns information about the project role granted the permission.
     * *  `user` Returns information about the user who is granted the permission.
     */
    expand?: string;
  };
};

export type UpdatePermissionSchemeResponse = PermissionScheme;

export type UpdatePermissionSchemeError = unknown;

export type GetPermissionSchemeGrantsData = {
  path: {
    /**
     * The ID of the permission scheme.
     */
    schemeId: number;
  };
  query?: {
    /**
     * Use expand to include additional information in the response. This parameter accepts a comma-separated list. Note that permissions are always included when you specify any value. Expand options include:
     *
     * *  `permissions` Returns all permission grants for each permission scheme.
     * *  `user` Returns information about the user who is granted the permission.
     * *  `group` Returns information about the group that is granted the permission.
     * *  `projectRole` Returns information about the project role granted the permission.
     * *  `field` Returns information about the custom field granted the permission.
     * *  `all` Returns all expandable information.
     */
    expand?: string;
  };
};

export type GetPermissionSchemeGrantsResponse = PermissionGrants;

export type GetPermissionSchemeGrantsError = unknown;

export type CreatePermissionGrantData = {
  /**
   * The permission grant to create.
   */
  body: PermissionGrant;
  path: {
    /**
     * The ID of the permission scheme in which to create a new permission grant.
     */
    schemeId: number;
  };
  query?: {
    /**
     * Use expand to include additional information in the response. This parameter accepts a comma-separated list. Note that permissions are always included when you specify any value. Expand options include:
     *
     * *  `permissions` Returns all permission grants for each permission scheme.
     * *  `user` Returns information about the user who is granted the permission.
     * *  `group` Returns information about the group that is granted the permission.
     * *  `projectRole` Returns information about the project role granted the permission.
     * *  `field` Returns information about the custom field granted the permission.
     * *  `all` Returns all expandable information.
     */
    expand?: string;
  };
};

export type CreatePermissionGrantResponse = PermissionGrant;

export type CreatePermissionGrantError = unknown;

export type DeletePermissionSchemeEntityData = {
  path: {
    /**
     * The ID of the permission grant to delete.
     */
    permissionId: number;
    /**
     * The ID of the permission scheme to delete the permission grant from.
     */
    schemeId: number;
  };
};

export type DeletePermissionSchemeEntityResponse = any;

export type DeletePermissionSchemeEntityError = unknown;

export type GetPermissionSchemeGrantData = {
  path: {
    /**
     * The ID of the permission grant.
     */
    permissionId: number;
    /**
     * The ID of the permission scheme.
     */
    schemeId: number;
  };
  query?: {
    /**
     * Use expand to include additional information in the response. This parameter accepts a comma-separated list. Note that permissions are always included when you specify any value. Expand options include:
     *
     * *  `all` Returns all expandable information.
     * *  `field` Returns information about the custom field granted the permission.
     * *  `group` Returns information about the group that is granted the permission.
     * *  `permissions` Returns all permission grants for each permission scheme.
     * *  `projectRole` Returns information about the project role granted the permission.
     * *  `user` Returns information about the user who is granted the permission.
     */
    expand?: string;
  };
};

export type GetPermissionSchemeGrantResponse = PermissionGrant;

export type GetPermissionSchemeGrantError = unknown;

export type GetPrioritiesResponse = Array<Priority>;

export type GetPrioritiesError = unknown;

export type CreatePriorityData = {
  body: CreatePriorityDetails;
};

export type CreatePriorityResponse = PriorityId;

export type CreatePriorityError = ErrorCollection;

export type SetDefaultPriorityData = {
  body: SetDefaultPriorityRequest;
};

export type SetDefaultPriorityResponse = unknown;

export type SetDefaultPriorityError = ErrorCollection;

export type MovePrioritiesData = {
  body: ReorderIssuePriorities;
};

export type MovePrioritiesResponse = unknown;

export type MovePrioritiesError = ErrorCollection;

export type SearchPrioritiesData = {
  query?: {
    /**
     * Use `schemes` to return the associated priority schemes for each priority. Limited to returning first 15 priority schemes per priority.
     */
    expand?: string;
    /**
     * The list of priority IDs. To include multiple IDs, provide an ampersand-separated list. For example, `id=2&id=3`.
     */
    id?: Array<string>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: string;
    /**
     * Whether only the default priority is returned.
     */
    onlyDefault?: boolean;
    /**
     * The name of priority to search for.
     */
    priorityName?: string;
    /**
     * The list of projects IDs. To include multiple IDs, provide an ampersand-separated list. For example, `projectId=10010&projectId=10111`.
     */
    projectId?: Array<string>;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: string;
  };
};

export type SearchPrioritiesResponse = PageBeanPriority;

export type SearchPrioritiesError = ErrorCollection;

export type DeletePriorityData = {
  path: {
    /**
     * The ID of the issue priority.
     */
    id: string;
  };
};

export type GetPriorityData = {
  path: {
    /**
     * The ID of the issue priority.
     */
    id: string;
  };
};

export type GetPriorityResponse = Priority;

export type GetPriorityError = unknown;

export type UpdatePriorityData = {
  body: UpdatePriorityDetails;
  path: {
    /**
     * The ID of the issue priority.
     */
    id: string;
  };
};

export type UpdatePriorityResponse = unknown;

export type UpdatePriorityError = ErrorCollection;

export type GetPrioritySchemesData = {
  query?: {
    /**
     * A comma separated list of additional information to return. "priorities" will return priorities associated with the priority scheme. "projects" will return projects associated with the priority scheme. `expand=priorities,projects`.
     */
    expand?: string;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: string;
    /**
     * Whether only the default priority is returned.
     */
    onlyDefault?: boolean;
    /**
     * The ordering to return the priority schemes by.
     */
    orderBy?: 'name' | '+name' | '-name';
    /**
     * A set of priority IDs to filter by. To include multiple IDs, provide an ampersand-separated list. For example, `priorityId=10000&priorityId=10001`.
     */
    priorityId?: Array<number>;
    /**
     * A set of priority scheme IDs. To include multiple IDs, provide an ampersand-separated list. For example, `schemeId=10000&schemeId=10001`.
     */
    schemeId?: Array<number>;
    /**
     * The name of scheme to search for.
     */
    schemeName?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: string;
  };
};

export type GetPrioritySchemesResponse = PageBeanPrioritySchemeWithPaginatedPrioritiesAndProjects;

export type GetPrioritySchemesError = unknown;

export type CreatePrioritySchemeData = {
  body: CreatePrioritySchemeDetails;
};

export type CreatePrioritySchemeResponse = PrioritySchemeId;

export type CreatePrioritySchemeError = unknown;

export type SuggestedPrioritiesForMappingsData = {
  body: SuggestedMappingsRequestBean;
};

export type SuggestedPrioritiesForMappingsResponse = PageBeanPriorityWithSequence;

export type SuggestedPrioritiesForMappingsError = unknown;

export type GetAvailablePrioritiesByPrioritySchemeData = {
  query: {
    /**
     * A list of priority IDs to exclude from the results.
     */
    exclude?: Array<string>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: string;
    /**
     * The string to query priorities on by name.
     */
    query?: string;
    /**
     * The priority scheme ID.
     */
    schemeId: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: string;
  };
};

export type GetAvailablePrioritiesByPrioritySchemeResponse = PageBeanPriorityWithSequence;

export type GetAvailablePrioritiesByPrioritySchemeError = unknown;

export type DeletePrioritySchemeData = {
  path: {
    /**
     * The priority scheme ID.
     */
    schemeId: number;
  };
};

export type DeletePrioritySchemeResponse = unknown;

export type DeletePrioritySchemeError = unknown;

export type UpdatePrioritySchemeData = {
  body: UpdatePrioritySchemeRequestBean;
  path: {
    /**
     * The ID of the priority scheme.
     */
    schemeId: number;
  };
};

export type UpdatePrioritySchemeResponse = UpdatePrioritySchemeResponseBean;

export type UpdatePrioritySchemeError = unknown;

export type GetPrioritiesByPrioritySchemeData = {
  path: {
    /**
     * The priority scheme ID.
     */
    schemeId: string;
  };
  query?: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: string;
  };
};

export type GetPrioritiesByPrioritySchemeResponse = PageBeanPriorityWithSequence;

export type GetPrioritiesByPrioritySchemeError = unknown;

export type GetProjectsByPrioritySchemeData = {
  path: {
    /**
     * The priority scheme ID.
     */
    schemeId: string;
  };
  query?: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: string;
    /**
     * The project IDs to filter by. For example, `projectId=10000&projectId=10001`.
     */
    projectId?: Array<number>;
    /**
     * The string to query projects on by name.
     */
    query?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: string;
  };
};

export type GetProjectsByPrioritySchemeResponse = PageBeanProject;

export type GetProjectsByPrioritySchemeError = unknown;

export type GetAllProjectsData = {
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expanded options include:
     *
     * *  `description` Returns the project description.
     * *  `issueTypes` Returns all issue types associated with the project.
     * *  `lead` Returns information about the project lead.
     * *  `projectKeys` Returns all project keys associated with the project.
     */
    expand?: string;
    /**
     * A list of project properties to return for the project. This parameter accepts a comma-separated list.
     */
    properties?: Array<string>;
    /**
     * Returns the user's most recently accessed projects. You may specify the number of results to return up to a maximum of 20. If access is anonymous, then the recently accessed projects are based on the current HTTP session.
     */
    recent?: number;
  };
};

export type GetAllProjectsResponse = Array<Project>;

export type GetAllProjectsError = unknown;

export type CreateProjectData = {
  /**
   * The JSON representation of the project being created.
   */
  body: CreateProjectDetails;
};

export type CreateProjectResponse = ProjectIdentifiers;

export type CreateProjectError = unknown;

export type GetRecentData = {
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expanded options include:
     *
     * *  `description` Returns the project description.
     * *  `projectKeys` Returns all project keys associated with a project.
     * *  `lead` Returns information about the project lead.
     * *  `issueTypes` Returns all issue types associated with the project.
     * *  `url` Returns the URL associated with the project.
     * *  `permissions` Returns the permissions associated with the project.
     * *  `insight` EXPERIMENTAL. Returns the insight details of total issue count and last issue update time for the project.
     * *  `*` Returns the project with all available expand options.
     */
    expand?: string;
    /**
     * EXPERIMENTAL. A list of project properties to return for the project. This parameter accepts a comma-separated list. Invalid property names are ignored.
     */
    properties?: Array<StringList>;
  };
};

export type GetRecentResponse = Array<Project>;

export type GetRecentError = unknown;

export type SearchProjectsData = {
  query?: {
    /**
     * Filter results by projects for which the user can:
     *
     * *  `view` the project, meaning that they have one of the following permissions:
     *
     * *  *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project.
     * *  *Administer projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project.
     * *  *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * *  `browse` the project, meaning that they have the *Browse projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project.
     * *  `edit` the project, meaning that they have one of the following permissions:
     *
     * *  *Administer projects* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project.
     * *  *Administer Jira* [global permission](https://confluence.atlassian.com/x/x4dKLg).
     * *  `create` the project, meaning that they have the *Create issues* [project permission](https://confluence.atlassian.com/x/yodKLg) for the project in which the issue is created.
     */
    action?: 'view' | 'browse' | 'edit' | 'create';
    /**
     * The ID of the project's category. A complete list of category IDs is found using the [Get all project categories](#api-rest-api-3-projectCategory-get) operation.
     */
    categoryId?: number;
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expanded options include:
     *
     * *  `description` Returns the project description.
     * *  `projectKeys` Returns all project keys associated with a project.
     * *  `lead` Returns information about the project lead.
     * *  `issueTypes` Returns all issue types associated with the project.
     * *  `url` Returns the URL associated with the project.
     * *  `insight` EXPERIMENTAL. Returns the insight details of total issue count and last issue update time for the project.
     */
    expand?: string;
    /**
     * The project IDs to filter the results by. To include multiple IDs, provide an ampersand-separated list. For example, `id=10000&id=10001`. Up to 50 project IDs can be provided.
     */
    id?: Array<number>;
    /**
     * The project keys to filter the results by. To include multiple keys, provide an ampersand-separated list. For example, `keys=PA&keys=PB`. Up to 50 project keys can be provided.
     */
    keys?: Array<string>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * [Order](#ordering) the results by a field.
     *
     * *  `category` Sorts by project category. A complete list of category IDs is found using [Get all project categories](#api-rest-api-3-projectCategory-get).
     * *  `issueCount` Sorts by the total number of issues in each project.
     * *  `key` Sorts by project key.
     * *  `lastIssueUpdatedTime` Sorts by the last issue update time.
     * *  `name` Sorts by project name.
     * *  `owner` Sorts by project lead.
     * *  `archivedDate` EXPERIMENTAL. Sorts by project archived date.
     * *  `deletedDate` EXPERIMENTAL. Sorts by project deleted date.
     */
    orderBy?:
      | 'category'
      | '-category'
      | '+category'
      | 'key'
      | '-key'
      | '+key'
      | 'name'
      | '-name'
      | '+name'
      | 'owner'
      | '-owner'
      | '+owner'
      | 'issueCount'
      | '-issueCount'
      | '+issueCount'
      | 'lastIssueUpdatedDate'
      | '-lastIssueUpdatedDate'
      | '+lastIssueUpdatedDate'
      | 'archivedDate'
      | '+archivedDate'
      | '-archivedDate'
      | 'deletedDate'
      | '+deletedDate'
      | '-deletedDate';
    /**
     * EXPERIMENTAL. A list of project properties to return for the project. This parameter accepts a comma-separated list.
     */
    properties?: Array<StringList>;
    /**
     * EXPERIMENTAL. A query string used to search properties. The query string cannot be specified using a JSON object. For example, to search for the value of `nested` from `{"something":{"nested":1,"other":2}}` use `[thepropertykey].something.nested=1`. Note that the propertyQuery key is enclosed in square brackets to enable searching where the propertyQuery key includes dot (.) or equals (=) characters. Note that `thepropertykey` is only returned when included in `properties`.
     */
    propertyQuery?: string;
    /**
     * Filter the results using a literal string. Projects with a matching `key` or `name` are returned (case insensitive).
     */
    query?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
    /**
     * EXPERIMENTAL. Filter results by project status:
     *
     * *  `live` Search live projects.
     * *  `archived` Search archived projects.
     * *  `deleted` Search deleted projects, those in the recycle bin.
     */
    status?: Array<'live' | 'archived' | 'deleted'>;
    /**
     * Orders results by the [project type](https://confluence.atlassian.com/x/GwiiLQ#Jiraapplicationsoverview-Productfeaturesandprojecttypes). This parameter accepts a comma-separated list. Valid values are `business`, `service_desk`, and `software`.
     */
    typeKey?: string;
  };
};

export type SearchProjectsResponse = PageBeanProject;

export type SearchProjectsError = unknown;

export type GetAllProjectTypesResponse = Array<ProjectType>;

export type GetAllProjectTypesError = unknown;

export type GetAllAccessibleProjectTypesResponse = Array<ProjectType>;

export type GetAllAccessibleProjectTypesError = unknown;

export type GetProjectTypeByKeyData = {
  path: {
    /**
     * The key of the project type.
     */
    projectTypeKey: 'software' | 'service_desk' | 'business' | 'product_discovery';
  };
};

export type GetProjectTypeByKeyResponse = ProjectType;

export type GetProjectTypeByKeyError = unknown;

export type GetAccessibleProjectTypeByKeyData = {
  path: {
    /**
     * The key of the project type.
     */
    projectTypeKey: 'software' | 'service_desk' | 'business' | 'product_discovery';
  };
};

export type GetAccessibleProjectTypeByKeyResponse = ProjectType;

export type GetAccessibleProjectTypeByKeyError = unknown;

export type DeleteProjectData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
  };
  query?: {
    /**
     * Whether this project is placed in the Jira recycle bin where it will be available for restoration.
     */
    enableUndo?: boolean;
  };
};

export type DeleteProjectResponse = any;

export type DeleteProjectError = unknown;

export type GetProjectData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Note that the project description, issue types, and project lead are included in all responses by default. Expand options include:
     *
     * *  `description` The project description.
     * *  `issueTypes` The issue types associated with the project.
     * *  `lead` The project lead.
     * *  `projectKeys` All project keys associated with the project.
     * *  `issueTypeHierarchy` The project issue type hierarchy.
     */
    expand?: string;
    /**
     * A list of project properties to return for the project. This parameter accepts a comma-separated list.
     */
    properties?: Array<string>;
  };
};

export type GetProjectResponse = Project;

export type GetProjectError = unknown;

export type UpdateProjectData = {
  /**
   * The project details to be updated.
   */
  body: UpdateProjectDetails;
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Note that the project description, issue types, and project lead are included in all responses by default. Expand options include:
     *
     * *  `description` The project description.
     * *  `issueTypes` The issue types associated with the project.
     * *  `lead` The project lead.
     * *  `projectKeys` All project keys associated with the project.
     */
    expand?: string;
  };
};

export type UpdateProjectResponse = Project;

export type UpdateProjectError = unknown;

export type ArchiveProjectData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
  };
};

export type ArchiveProjectResponse = unknown;

export type ArchiveProjectError = unknown;

export type UpdateProjectAvatarData = {
  body: Avatar;
  path: {
    /**
     * The ID or (case-sensitive) key of the project.
     */
    projectIdOrKey: string;
  };
};

export type UpdateProjectAvatarResponse = unknown;

export type UpdateProjectAvatarError = unknown;

export type DeleteProjectAvatarData = {
  path: {
    /**
     * The ID of the avatar.
     */
    id: number;
    /**
     * The project ID or (case-sensitive) key.
     */
    projectIdOrKey: string;
  };
};

export type DeleteProjectAvatarResponse = any;

export type DeleteProjectAvatarError = unknown;

export type CreateProjectAvatarData = {
  body?: string;
  path: {
    /**
     * The ID or (case-sensitive) key of the project.
     */
    projectIdOrKey: string;
  };
  query?: {
    /**
     * The length of each side of the crop region.
     */
    size?: number;
    /**
     * The X coordinate of the top-left corner of the crop region.
     */
    x?: number;
    /**
     * The Y coordinate of the top-left corner of the crop region.
     */
    y?: number;
  };
};

export type CreateProjectAvatarResponse = Avatar;

export type CreateProjectAvatarError = unknown;

export type GetAllProjectAvatarsData = {
  path: {
    /**
     * The ID or (case-sensitive) key of the project.
     */
    projectIdOrKey: string;
  };
};

export type GetAllProjectAvatarsResponse = ProjectAvatars;

export type GetAllProjectAvatarsError = unknown;

export type RemoveDefaultProjectClassificationData = {
  path: {
    /**
     * The project ID or project key (case-sensitive).
     */
    projectIdOrKey: string;
  };
};

export type RemoveDefaultProjectClassificationResponse = unknown;

export type RemoveDefaultProjectClassificationError = unknown;

export type GetDefaultProjectClassificationData = {
  path: {
    /**
     * The project ID or project key (case-sensitive).
     */
    projectIdOrKey: string;
  };
};

export type GetDefaultProjectClassificationResponse = unknown;

export type GetDefaultProjectClassificationError = unknown;

export type UpdateDefaultProjectClassificationData = {
  body: UpdateDefaultProjectClassificationBean;
  path: {
    /**
     * The project ID or project key (case-sensitive).
     */
    projectIdOrKey: string;
  };
};

export type UpdateDefaultProjectClassificationResponse = unknown;

export type UpdateDefaultProjectClassificationError = unknown;

export type GetProjectComponentsPaginatedData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
  };
  query?: {
    /**
     * The source of the components to return. Can be `jira` (default), `compass` or `auto`. When `auto` is specified, the API will return connected Compass components if the project is opted into Compass, otherwise it will return Jira components. Defaults to `jira`.
     */
    componentSource?: 'jira' | 'compass' | 'auto';
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * [Order](#ordering) the results by a field:
     *
     * *  `description` Sorts by the component description.
     * *  `issueCount` Sorts by the count of issues associated with the component.
     * *  `lead` Sorts by the user key of the component's project lead.
     * *  `name` Sorts by component name.
     */
    orderBy?:
      | 'description'
      | '-description'
      | '+description'
      | 'issueCount'
      | '-issueCount'
      | '+issueCount'
      | 'lead'
      | '-lead'
      | '+lead'
      | 'name'
      | '-name'
      | '+name';
    /**
     * Filter the results using a literal string. Components with a matching `name` or `description` are returned (case insensitive).
     */
    query?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetProjectComponentsPaginatedResponse = PageBeanComponentWithIssueCount;

export type GetProjectComponentsPaginatedError = unknown;

export type GetProjectComponentsData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
  };
  query?: {
    /**
     * The source of the components to return. Can be `jira` (default), `compass` or `auto`. When `auto` is specified, the API will return connected Compass components if the project is opted into Compass, otherwise it will return Jira components. Defaults to `jira`.
     */
    componentSource?: 'jira' | 'compass' | 'auto';
  };
};

export type GetProjectComponentsResponse = Array<ProjectComponent>;

export type GetProjectComponentsError = unknown;

export type DeleteProjectAsynchronouslyData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
  };
};

export type GetFeaturesForProjectData = {
  path: {
    /**
     * The ID or (case-sensitive) key of the project.
     */
    projectIdOrKey: string;
  };
};

export type GetFeaturesForProjectResponse = ContainerForProjectFeatures;

export type GetFeaturesForProjectError = unknown;

export type ToggleFeatureForProjectData = {
  /**
   * Details of the feature state change.
   */
  body: ProjectFeatureState;
  path: {
    /**
     * The key of the feature.
     */
    featureKey: string;
    /**
     * The ID or (case-sensitive) key of the project.
     */
    projectIdOrKey: string;
  };
};

export type ToggleFeatureForProjectResponse = ContainerForProjectFeatures;

export type ToggleFeatureForProjectError = unknown;

export type GetProjectPropertyKeysData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
  };
};

export type GetProjectPropertyKeysResponse = PropertyKeys;

export type GetProjectPropertyKeysError = unknown;

export type DeleteProjectPropertyData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
    /**
     * The project property key. Use [Get project property keys](#api-rest-api-3-project-projectIdOrKey-properties-get) to get a list of all project property keys.
     */
    propertyKey: string;
  };
};

export type DeleteProjectPropertyResponse = any;

export type DeleteProjectPropertyError = unknown;

export type GetProjectPropertyData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
    /**
     * The project property key. Use [Get project property keys](#api-rest-api-3-project-projectIdOrKey-properties-get) to get a list of all project property keys.
     */
    propertyKey: string;
  };
};

export type GetProjectPropertyResponse = EntityProperty;

export type GetProjectPropertyError = unknown;

export type SetProjectPropertyData = {
  /**
   * The value of the property. The value has to be a valid, non-empty [JSON](https://tools.ietf.org/html/rfc4627) value. The maximum length of the property value is 32768 bytes.
   */
  body?: string;
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
    /**
     * The key of the project property. The maximum length is 255 characters.
     */
    propertyKey: string;
  };
};

export type SetProjectPropertyResponse = unknown;

export type SetProjectPropertyError = unknown;

export type RestoreData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
  };
};

export type RestoreResponse = Project;

export type RestoreError = unknown;

export type GetProjectRolesData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
  };
};

export type GetProjectRolesResponse = {
  [key: string]: string;
};

export type GetProjectRolesError = unknown;

export type DeleteActorData = {
  path: {
    /**
     * The ID of the project role. Use [Get all project roles](#api-rest-api-3-role-get) to get a list of project role IDs.
     */
    id: number;
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
  };
  query?: {
    /**
     * The name of the group to remove from the project role. This parameter cannot be used with the `groupId` parameter. As a group's name can change, use of `groupId` is recommended.
     */
    group?: string;
    /**
     * The ID of the group to remove from the project role. This parameter cannot be used with the `group` parameter.
     */
    groupId?: string;
    /**
     * The user account ID of the user to remove from the project role.
     */
    user?: string;
  };
};

export type DeleteActorResponse = any;

export type DeleteActorError = unknown;

export type GetProjectRoleData = {
  path: {
    /**
     * The ID of the project role. Use [Get all project roles](#api-rest-api-3-role-get) to get a list of project role IDs.
     */
    id: number;
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
  };
  query?: {
    /**
     * Exclude inactive users.
     */
    excludeInactiveUsers?: boolean;
  };
};

export type GetProjectRoleResponse = ProjectRole;

export type GetProjectRoleError = unknown;

export type AddActorUsersData = {
  /**
   * The groups or users to associate with the project role for this project. Provide the user account ID, group name, or group ID. As a group's name can change, use of group ID is recommended.
   */
  body: ActorsMap;
  path: {
    /**
     * The ID of the project role. Use [Get all project roles](#api-rest-api-3-role-get) to get a list of project role IDs.
     */
    id: number;
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
  };
};

export type AddActorUsersResponse = ProjectRole;

export type AddActorUsersError = unknown;

export type SetActorsData = {
  /**
   * The groups or users to associate with the project role for this project. Provide the user account ID, group name, or group ID. As a group's name can change, use of group ID is recommended.
   */
  body: ProjectRoleActorsUpdateBean;
  path: {
    /**
     * The ID of the project role. Use [Get all project roles](#api-rest-api-3-role-get) to get a list of project role IDs.
     */
    id: number;
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
  };
};

export type SetActorsResponse = ProjectRole;

export type SetActorsError = unknown;

export type GetProjectRoleDetailsData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
  };
  query?: {
    /**
     * Whether the roles should be filtered to include only those the user is assigned to.
     */
    currentMember?: boolean;
    excludeConnectAddons?: boolean;
  };
};

export type GetProjectRoleDetailsResponse = Array<ProjectRoleDetails>;

export type GetProjectRoleDetailsError = unknown;

export type GetAllStatusesData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
  };
};

export type GetAllStatusesResponse = Array<IssueTypeWithStatus>;

export type GetAllStatusesError = unknown;

export type GetProjectVersionsPaginatedData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `issuesstatus` Returns the number of issues in each status category for each version.
     * *  `operations` Returns actions that can be performed on the specified version.
     * *  `driver` Returns the Atlassian account ID of the version driver.
     * *  `approvers` Returns a list containing the approvers for this version.
     */
    expand?: string;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * [Order](#ordering) the results by a field:
     *
     * *  `description` Sorts by version description.
     * *  `name` Sorts by version name.
     * *  `releaseDate` Sorts by release date, starting with the oldest date. Versions with no release date are listed last.
     * *  `sequence` Sorts by the order of appearance in the user interface.
     * *  `startDate` Sorts by start date, starting with the oldest date. Versions with no start date are listed last.
     */
    orderBy?:
      | 'description'
      | '-description'
      | '+description'
      | 'name'
      | '-name'
      | '+name'
      | 'releaseDate'
      | '-releaseDate'
      | '+releaseDate'
      | 'sequence'
      | '-sequence'
      | '+sequence'
      | 'startDate'
      | '-startDate'
      | '+startDate';
    /**
     * Filter the results using a literal string. Versions with matching `name` or `description` are returned (case insensitive).
     */
    query?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
    /**
     * A list of status values used to filter the results by version status. This parameter accepts a comma-separated list. The status values are `released`, `unreleased`, and `archived`.
     */
    status?: string;
  };
};

export type GetProjectVersionsPaginatedResponse = PageBeanVersion;

export type GetProjectVersionsPaginatedError = unknown;

export type GetProjectVersionsData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectIdOrKey: string;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts `operations`, which returns actions that can be performed on the version.
     */
    expand?: string;
  };
};

export type GetProjectVersionsResponse = Array<Version>;

export type GetProjectVersionsError = unknown;

export type GetProjectEmailData = {
  path: {
    /**
     * The project ID.
     */
    projectId: number;
  };
};

export type GetProjectEmailResponse = ProjectEmailAddress;

export type GetProjectEmailError = unknown;

export type UpdateProjectEmailData = {
  /**
   * The project's sender email address to be set.
   */
  body: ProjectEmailAddress;
  path: {
    /**
     * The project ID.
     */
    projectId: number;
  };
};

export type UpdateProjectEmailResponse = unknown;

export type UpdateProjectEmailError = unknown;

export type GetHierarchyData = {
  path: {
    /**
     * The ID of the project.
     */
    projectId: number;
  };
};

export type GetHierarchyResponse = ProjectIssueTypeHierarchy;

export type GetHierarchyError = unknown;

export type GetProjectIssueSecuritySchemeData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectKeyOrId: string;
  };
};

export type GetProjectIssueSecuritySchemeResponse = SecurityScheme;

export type GetProjectIssueSecuritySchemeError = unknown;

export type GetNotificationSchemeForProjectData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectKeyOrId: string;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `all` Returns all expandable information
     * *  `field` Returns information about any custom fields assigned to receive an event
     * *  `group` Returns information about any groups assigned to receive an event
     * *  `notificationSchemeEvents` Returns a list of event associations. This list is returned for all expandable information
     * *  `projectRole` Returns information about any project roles assigned to receive an event
     * *  `user` Returns information about any users assigned to receive an event
     */
    expand?: string;
  };
};

export type GetNotificationSchemeForProjectResponse = NotificationScheme;

export type GetNotificationSchemeForProjectError = unknown;

export type GetAssignedPermissionSchemeData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectKeyOrId: string;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Note that permissions are included when you specify any value. Expand options include:
     *
     * *  `all` Returns all expandable information.
     * *  `field` Returns information about the custom field granted the permission.
     * *  `group` Returns information about the group that is granted the permission.
     * *  `permissions` Returns all permission grants for each permission scheme.
     * *  `projectRole` Returns information about the project role granted the permission.
     * *  `user` Returns information about the user who is granted the permission.
     */
    expand?: string;
  };
};

export type GetAssignedPermissionSchemeResponse = PermissionScheme;

export type GetAssignedPermissionSchemeError = unknown;

export type AssignPermissionSchemeData = {
  body: IdBean;
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectKeyOrId: string;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Note that permissions are included when you specify any value. Expand options include:
     *
     * *  `all` Returns all expandable information.
     * *  `field` Returns information about the custom field granted the permission.
     * *  `group` Returns information about the group that is granted the permission.
     * *  `permissions` Returns all permission grants for each permission scheme.
     * *  `projectRole` Returns information about the project role granted the permission.
     * *  `user` Returns information about the user who is granted the permission.
     */
    expand?: string;
  };
};

export type AssignPermissionSchemeResponse = PermissionScheme;

export type AssignPermissionSchemeError = unknown;

export type GetSecurityLevelsForProjectData = {
  path: {
    /**
     * The project ID or project key (case sensitive).
     */
    projectKeyOrId: string;
  };
};

export type GetSecurityLevelsForProjectResponse = ProjectIssueSecurityLevels;

export type GetSecurityLevelsForProjectError = unknown;

export type GetAllProjectCategoriesResponse = Array<ProjectCategory>;

export type GetAllProjectCategoriesError = unknown;

export type CreateProjectCategoryData = {
  body: ProjectCategory;
};

export type CreateProjectCategoryResponse = ProjectCategory;

export type CreateProjectCategoryError = unknown;

export type RemoveProjectCategoryData = {
  path: {
    /**
     * ID of the project category to delete.
     */
    id: number;
  };
};

export type RemoveProjectCategoryResponse = any;

export type RemoveProjectCategoryError = unknown;

export type GetProjectCategoryByIdData = {
  path: {
    /**
     * The ID of the project category.
     */
    id: number;
  };
};

export type GetProjectCategoryByIdResponse = ProjectCategory;

export type GetProjectCategoryByIdError = unknown;

export type UpdateProjectCategoryData = {
  body: ProjectCategory;
  path: {
    id: number;
  };
};

export type UpdateProjectCategoryResponse = UpdatedProjectCategory;

export type UpdateProjectCategoryError = unknown;

export type ValidateProjectKeyData = {
  query?: {
    /**
     * The project key.
     */
    key?: string;
  };
};

export type ValidateProjectKeyResponse = ErrorCollection;

export type ValidateProjectKeyError = unknown;

export type GetValidProjectKeyData = {
  query?: {
    /**
     * The project key.
     */
    key?: string;
  };
};

export type GetValidProjectKeyResponse = string;

export type GetValidProjectKeyError = unknown;

export type GetValidProjectNameData = {
  query: {
    /**
     * The project name.
     */
    name: string;
  };
};

export type GetValidProjectNameResponse = string;

export type GetValidProjectNameError = unknown;

export type GetResolutionsResponse = Array<Resolution>;

export type GetResolutionsError = unknown;

export type CreateResolutionData = {
  body: CreateResolutionDetails;
};

export type CreateResolutionResponse = ResolutionId;

export type CreateResolutionError = ErrorCollection;

export type SetDefaultResolutionData = {
  body: SetDefaultResolutionRequest;
};

export type SetDefaultResolutionResponse = unknown;

export type SetDefaultResolutionError = ErrorCollection;

export type MoveResolutionsData = {
  body: ReorderIssueResolutionsRequest;
};

export type MoveResolutionsResponse = unknown;

export type MoveResolutionsError = ErrorCollection;

export type SearchResolutionsData = {
  query?: {
    /**
     * The list of resolutions IDs to be filtered out
     */
    id?: Array<string>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: string;
    /**
     * When set to true, return default only, when IDs provided, if none of them is default, return empty page. Default value is false
     */
    onlyDefault?: boolean;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: string;
  };
};

export type SearchResolutionsResponse = PageBeanResolutionJsonBean;

export type SearchResolutionsError = ErrorCollection;

export type DeleteResolutionData = {
  path: {
    /**
     * The ID of the issue resolution.
     */
    id: string;
  };
  query: {
    /**
     * The ID of the issue resolution that will replace the currently selected resolution.
     */
    replaceWith: string;
  };
};

export type GetResolutionData = {
  path: {
    /**
     * The ID of the issue resolution value.
     */
    id: string;
  };
};

export type GetResolutionResponse = Resolution;

export type GetResolutionError = unknown;

export type UpdateResolutionData = {
  body: UpdateResolutionDetails;
  path: {
    /**
     * The ID of the issue resolution.
     */
    id: string;
  };
};

export type UpdateResolutionResponse = unknown;

export type UpdateResolutionError = ErrorCollection;

export type GetAllProjectRolesResponse = Array<ProjectRole>;

export type GetAllProjectRolesError = unknown;

export type CreateProjectRoleData = {
  body: CreateUpdateRoleRequestBean;
};

export type CreateProjectRoleResponse = ProjectRole;

export type CreateProjectRoleError = unknown;

export type DeleteProjectRoleData = {
  path: {
    /**
     * The ID of the project role to delete. Use [Get all project roles](#api-rest-api-3-role-get) to get a list of project role IDs.
     */
    id: number;
  };
  query?: {
    /**
     * The ID of the project role that will replace the one being deleted.
     */
    swap?: number;
  };
};

export type DeleteProjectRoleResponse = any;

export type DeleteProjectRoleError = unknown;

export type GetProjectRoleByIdData = {
  path: {
    /**
     * The ID of the project role. Use [Get all project roles](#api-rest-api-3-role-get) to get a list of project role IDs.
     */
    id: number;
  };
};

export type GetProjectRoleByIdResponse = ProjectRole;

export type GetProjectRoleByIdError = unknown;

export type PartialUpdateProjectRoleData = {
  body: CreateUpdateRoleRequestBean;
  path: {
    /**
     * The ID of the project role. Use [Get all project roles](#api-rest-api-3-role-get) to get a list of project role IDs.
     */
    id: number;
  };
};

export type PartialUpdateProjectRoleResponse = ProjectRole;

export type PartialUpdateProjectRoleError = unknown;

export type FullyUpdateProjectRoleData = {
  body: CreateUpdateRoleRequestBean;
  path: {
    /**
     * The ID of the project role. Use [Get all project roles](#api-rest-api-3-role-get) to get a list of project role IDs.
     */
    id: number;
  };
};

export type FullyUpdateProjectRoleResponse = ProjectRole;

export type FullyUpdateProjectRoleError = unknown;

export type DeleteProjectRoleActorsFromRoleData = {
  path: {
    /**
     * The ID of the project role. Use [Get all project roles](#api-rest-api-3-role-get) to get a list of project role IDs.
     */
    id: number;
  };
  query?: {
    /**
     * The group name of the group to be removed as a default actor.This parameter cannot be used with the `groupId` parameter. As a group's name can change, use of `groupId` is recommended.
     */
    group?: string;
    /**
     * The group ID of the group to be removed as a default actor. This parameter cannot be used with the `group` parameter.
     */
    groupId?: string;
    /**
     * The user account ID of the user to remove as a default actor.
     */
    user?: string;
  };
};

export type DeleteProjectRoleActorsFromRoleResponse = ProjectRole;

export type DeleteProjectRoleActorsFromRoleError = unknown;

export type GetProjectRoleActorsForRoleData = {
  path: {
    /**
     * The ID of the project role. Use [Get all project roles](#api-rest-api-3-role-get) to get a list of project role IDs.
     */
    id: number;
  };
};

export type GetProjectRoleActorsForRoleResponse = ProjectRole;

export type GetProjectRoleActorsForRoleError = unknown;

export type AddProjectRoleActorsToRoleData = {
  body: ActorInputBean;
  path: {
    /**
     * The ID of the project role. Use [Get all project roles](#api-rest-api-3-role-get) to get a list of project role IDs.
     */
    id: number;
  };
};

export type AddProjectRoleActorsToRoleResponse = ProjectRole;

export type AddProjectRoleActorsToRoleError = unknown;

export type GetScreensData = {
  query?: {
    /**
     * The list of screen IDs. To include multiple IDs, provide an ampersand-separated list. For example, `id=10000&id=10001`.
     */
    id?: Array<number>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * [Order](#ordering) the results by a field:
     *
     * *  `id` Sorts by screen ID.
     * *  `name` Sorts by screen name.
     */
    orderBy?: 'name' | '-name' | '+name' | 'id' | '-id' | '+id';
    /**
     * String used to perform a case-insensitive partial match with screen name.
     */
    queryString?: string;
    /**
     * The scope filter string. To filter by multiple scope, provide an ampersand-separated list. For example, `scope=GLOBAL&scope=PROJECT`.
     */
    scope?: Array<'GLOBAL' | 'TEMPLATE' | 'PROJECT'>;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetScreensResponse = PageBeanScreen;

export type GetScreensError = unknown;

export type CreateScreenData = {
  body: ScreenDetails;
};

export type CreateScreenResponse = Screen;

export type CreateScreenError = unknown;

export type AddFieldToDefaultScreenData = {
  path: {
    /**
     * The ID of the field.
     */
    fieldId: string;
  };
};

export type AddFieldToDefaultScreenResponse = unknown;

export type AddFieldToDefaultScreenError = unknown;

export type GetBulkScreenTabsData = {
  query?: {
    /**
     * The maximum number of items to return per page. The maximum number is 100,
     */
    maxResult?: number;
    /**
     * The list of screen IDs. To include multiple screen IDs, provide an ampersand-separated list. For example, `screenId=10000&screenId=10001`.
     */
    screenId?: Array<number>;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
    /**
     * The list of tab IDs. To include multiple tab IDs, provide an ampersand-separated list. For example, `tabId=10000&tabId=10001`.
     */
    tabId?: Array<number>;
  };
};

export type GetBulkScreenTabsResponse = unknown;

export type GetBulkScreenTabsError = unknown;

export type DeleteScreenData = {
  path: {
    /**
     * The ID of the screen.
     */
    screenId: number;
  };
};

export type DeleteScreenResponse = any;

export type DeleteScreenError = unknown;

export type UpdateScreenData = {
  body: UpdateScreenDetails;
  path: {
    /**
     * The ID of the screen.
     */
    screenId: number;
  };
};

export type UpdateScreenResponse = Screen;

export type UpdateScreenError = unknown;

export type GetAvailableScreenFieldsData = {
  path: {
    /**
     * The ID of the screen.
     */
    screenId: number;
  };
};

export type GetAvailableScreenFieldsResponse = Array<ScreenableField>;

export type GetAvailableScreenFieldsError = unknown;

export type GetAllScreenTabsData = {
  path: {
    /**
     * The ID of the screen.
     */
    screenId: number;
  };
  query?: {
    /**
     * The key of the project.
     */
    projectKey?: string;
  };
};

export type GetAllScreenTabsResponse = Array<ScreenableTab>;

export type GetAllScreenTabsError = unknown;

export type AddScreenTabData = {
  body: ScreenableTab;
  path: {
    /**
     * The ID of the screen.
     */
    screenId: number;
  };
};

export type AddScreenTabResponse = ScreenableTab;

export type AddScreenTabError = unknown;

export type DeleteScreenTabData = {
  path: {
    /**
     * The ID of the screen.
     */
    screenId: number;
    /**
     * The ID of the screen tab.
     */
    tabId: number;
  };
};

export type DeleteScreenTabResponse = any;

export type DeleteScreenTabError = unknown;

export type RenameScreenTabData = {
  body: ScreenableTab;
  path: {
    /**
     * The ID of the screen.
     */
    screenId: number;
    /**
     * The ID of the screen tab.
     */
    tabId: number;
  };
};

export type RenameScreenTabResponse = ScreenableTab;

export type RenameScreenTabError = unknown;

export type GetAllScreenTabFieldsData = {
  path: {
    /**
     * The ID of the screen.
     */
    screenId: number;
    /**
     * The ID of the screen tab.
     */
    tabId: number;
  };
  query?: {
    /**
     * The key of the project.
     */
    projectKey?: string;
  };
};

export type GetAllScreenTabFieldsResponse = Array<ScreenableField>;

export type GetAllScreenTabFieldsError = unknown;

export type AddScreenTabFieldData = {
  body: AddFieldBean;
  path: {
    /**
     * The ID of the screen.
     */
    screenId: number;
    /**
     * The ID of the screen tab.
     */
    tabId: number;
  };
};

export type AddScreenTabFieldResponse = ScreenableField;

export type AddScreenTabFieldError = unknown;

export type RemoveScreenTabFieldData = {
  path: {
    /**
     * The ID of the field.
     */
    id: string;
    /**
     * The ID of the screen.
     */
    screenId: number;
    /**
     * The ID of the screen tab.
     */
    tabId: number;
  };
};

export type RemoveScreenTabFieldResponse = any;

export type RemoveScreenTabFieldError = unknown;

export type MoveScreenTabFieldData = {
  body: MoveFieldBean;
  path: {
    /**
     * The ID of the field.
     */
    id: string;
    /**
     * The ID of the screen.
     */
    screenId: number;
    /**
     * The ID of the screen tab.
     */
    tabId: number;
  };
};

export type MoveScreenTabFieldResponse = unknown;

export type MoveScreenTabFieldError = unknown;

export type MoveScreenTabData = {
  path: {
    /**
     * The position of tab. The base index is 0.
     */
    pos: number;
    /**
     * The ID of the screen.
     */
    screenId: number;
    /**
     * The ID of the screen tab.
     */
    tabId: number;
  };
};

export type MoveScreenTabResponse = unknown;

export type MoveScreenTabError = unknown;

export type GetScreenSchemesData = {
  query?: {
    /**
     * Use [expand](#expansion) include additional information in the response. This parameter accepts `issueTypeScreenSchemes` that, for each screen schemes, returns information about the issue type screen scheme the screen scheme is assigned to.
     */
    expand?: string;
    /**
     * The list of screen scheme IDs. To include multiple IDs, provide an ampersand-separated list. For example, `id=10000&id=10001`.
     */
    id?: Array<number>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * [Order](#ordering) the results by a field:
     *
     * *  `id` Sorts by screen scheme ID.
     * *  `name` Sorts by screen scheme name.
     */
    orderBy?: 'name' | '-name' | '+name' | 'id' | '-id' | '+id';
    /**
     * String used to perform a case-insensitive partial match with screen scheme name.
     */
    queryString?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetScreenSchemesResponse = PageBeanScreenScheme;

export type GetScreenSchemesError = unknown;

export type CreateScreenSchemeData = {
  body: ScreenSchemeDetails;
};

export type CreateScreenSchemeResponse = ScreenSchemeId;

export type CreateScreenSchemeError = unknown;

export type DeleteScreenSchemeData = {
  path: {
    /**
     * The ID of the screen scheme.
     */
    screenSchemeId: string;
  };
};

export type DeleteScreenSchemeResponse = any;

export type DeleteScreenSchemeError = unknown;

export type UpdateScreenSchemeData = {
  /**
   * The screen scheme update details.
   */
  body: UpdateScreenSchemeDetails;
  path: {
    /**
     * The ID of the screen scheme.
     */
    screenSchemeId: string;
  };
};

export type UpdateScreenSchemeResponse = unknown;

export type UpdateScreenSchemeError = unknown;

export type SearchForIssuesUsingJqlData = {
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about issues in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `renderedFields` Returns field values rendered in HTML format.
     * *  `names` Returns the display name of each field.
     * *  `schema` Returns the schema describing a field type.
     * *  `transitions` Returns all possible transitions for the issue.
     * *  `operations` Returns all possible operations for the issue.
     * *  `editmeta` Returns information about how each field can be edited.
     * *  `changelog` Returns a list of recent updates to an issue, sorted by date, starting from the most recent.
     * *  `versionedRepresentations` Instead of `fields`, returns `versionedRepresentations` a JSON array containing each version of a field's value, with the highest numbered item representing the most recent version.
     */
    expand?: string;
    /**
     * Whether to fail the request quickly in case of an error while loading fields for an issue. For `failFast=true`, if one field fails, the entire operation fails. For `failFast=false`, the operation will continue even if a field fails. It will return a valid response, but without values for the failed field(s).
     */
    failFast?: boolean;
    /**
     * A list of fields to return for each issue, use it to retrieve a subset of fields. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `*all` Returns all fields.
     * *  `*navigable` Returns navigable fields.
     * *  Any issue field, prefixed with a minus to exclude.
     *
     * Examples:
     *
     * *  `summary,comment` Returns only the summary and comments fields.
     * *  `-description` Returns all navigable (default) fields except description.
     * *  `*all,-comment` Returns all fields except comments.
     *
     * This parameter may be specified multiple times. For example, `fields=field1,field2&fields=field3`.
     *
     * Note: All navigable fields are returned by default. This differs from [GET issue](#api-rest-api-3-issue-issueIdOrKey-get) where the default is all fields.
     */
    fields?: Array<string>;
    /**
     * Reference fields by their key (rather than ID).
     */
    fieldsByKeys?: boolean;
    /**
     * The [JQL](https://confluence.atlassian.com/x/egORLQ) that defines the search. Note:
     *
     * *  If no JQL expression is provided, all issues are returned.
     * *  `username` and `userkey` cannot be used as search terms due to privacy reasons. Use `accountId` instead.
     * *  If a user has hidden their email address in their user profile, partial matches of the email address will not find the user. An exact match is required.
     */
    jql?: string;
    /**
     * The maximum number of items to return per page. To manage page size, Jira may return fewer items per page where a large number of fields are requested. The greatest number of items returned per page is achieved when requesting `id` or `key` only.
     */
    maxResults?: number;
    /**
     * A list of issue property keys for issue properties to include in the results. This parameter accepts a comma-separated list. Multiple properties can also be provided using an ampersand separated list. For example, `properties=prop1,prop2&properties=prop3`. A maximum of 5 issue property keys can be specified.
     */
    properties?: Array<string>;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
    /**
     * Determines how to validate the JQL query and treat the validation results. Supported values are:
     *
     * *  `strict` Returns a 400 response code if any errors are found, along with a list of all errors (and warnings).
     * *  `warn` Returns all errors as warnings.
     * *  `none` No validation is performed.
     * *  `true` *Deprecated* A legacy synonym for `strict`.
     * *  `false` *Deprecated* A legacy synonym for `warn`.
     *
     * Note: If the JQL is not correctly formed a 400 response code is returned, regardless of the `validateQuery` value.
     */
    validateQuery?: 'strict' | 'warn' | 'none' | 'true' | 'false';
  };
};

export type SearchForIssuesUsingJqlResponse = SearchResults;

export type SearchForIssuesUsingJqlError = unknown;

export type SearchForIssuesUsingJqlPostData = {
  /**
   * A JSON object containing the search request.
   */
  body: SearchRequestBean;
};

export type SearchForIssuesUsingJqlPostResponse = SearchResults;

export type SearchForIssuesUsingJqlPostError = unknown;

export type CountIssuesData = {
  /**
   * A JSON object containing the search request.
   */
  body: JQLCountRequestBean;
};

export type CountIssuesResponse = JQLCountResultsBean;

export type CountIssuesError = unknown;

export type SearchForIssuesIdsData = {
  /**
   * A JSON object containing the search request.
   */
  body: IdSearchRequestBean;
};

export type SearchForIssuesIdsResponse = IdSearchResults;

export type SearchForIssuesIdsError = unknown;

export type SearchAndReconsileIssuesUsingJqlData = {
  body: SearchAndReconcileRequestBean;
};

export type SearchAndReconsileIssuesUsingJqlResponse = SearchAndReconcileResults;

export type SearchAndReconsileIssuesUsingJqlError = unknown;

export type SearchAndReconsileIssuesUsingJqlPostData = {
  body: SearchAndReconcileRequestBean;
};

export type SearchAndReconsileIssuesUsingJqlPostResponse = SearchAndReconcileResults;

export type SearchAndReconsileIssuesUsingJqlPostError = unknown;

export type GetIssueSecurityLevelData = {
  path: {
    /**
     * The ID of the issue security level.
     */
    id: string;
  };
};

export type GetIssueSecurityLevelResponse = SecurityLevel;

export type GetIssueSecurityLevelError = unknown;

export type GetServerInfoResponse = ServerInformation;

export type GetServerInfoError = unknown;

export type GetIssueNavigatorDefaultColumnsResponse = Array<ColumnItem>;

export type GetIssueNavigatorDefaultColumnsError = ErrorCollection;

export type SetIssueNavigatorDefaultColumnsData = {
  /**
   * A navigable field value.
   */
  body: ColumnRequestBody;
};

export type SetIssueNavigatorDefaultColumnsResponse = unknown;

export type SetIssueNavigatorDefaultColumnsError = unknown;

export type GetStatusesResponse = Array<StatusDetails>;

export type GetStatusesError = unknown;

export type GetStatusData = {
  path: {
    /**
     * The ID or name of the status.
     */
    idOrName: string;
  };
};

export type GetStatusResponse = StatusDetails;

export type GetStatusError = unknown;

export type GetStatusCategoriesResponse = Array<StatusCategory>;

export type GetStatusCategoriesError = unknown;

export type GetStatusCategoryData = {
  path: {
    /**
     * The ID or key of the status category.
     */
    idOrKey: string;
  };
};

export type GetStatusCategoryResponse = StatusCategory;

export type GetStatusCategoryError = unknown;

export type DeleteStatusesByIdData = {
  query: {
    /**
     * The list of status IDs. To include multiple IDs, provide an ampersand-separated list. For example, id=10000&id=10001.
     *
     * Min items `1`, Max items `50`
     */
    id: Array<string>;
  };
};

export type DeleteStatusesByIdResponse = unknown;

export type DeleteStatusesByIdError = unknown;

export type GetStatusesByIdData = {
  query: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `usages` Returns the project and issue types that use the status in their workflow.
     * *  `workflowUsages` Returns the workflows that use the status.
     */
    expand?: string;
    /**
     * The list of status IDs. To include multiple IDs, provide an ampersand-separated list. For example, id=10000&id=10001.
     *
     * Min items `1`, Max items `50`
     */
    id: Array<string>;
  };
};

export type GetStatusesByIdResponse = Array<JiraStatus>;

export type GetStatusesByIdError = unknown;

export type CreateStatusesData = {
  /**
   * Details of the statuses being created and their scope.
   */
  body: StatusCreateRequest;
};

export type CreateStatusesResponse = Array<JiraStatus>;

export type CreateStatusesError = unknown;

export type UpdateStatusesData = {
  /**
   * The list of statuses that will be updated.
   */
  body: StatusUpdateRequest;
};

export type UpdateStatusesResponse = unknown;

export type UpdateStatusesError = unknown;

export type SearchData = {
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `usages` Returns the project and issue types that use the status in their workflow.
     * *  `workflowUsages` Returns the workflows that use the status.
     */
    expand?: string;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The project the status is part of or null for global statuses.
     */
    projectId?: string;
    /**
     * Term to match status names against or null to search for all statuses in the search scope.
     */
    searchString?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
    /**
     * Category of the status to filter by. The supported values are: `TODO`, `IN_PROGRESS`, and `DONE`.
     */
    statusCategory?: string;
  };
};

export type SearchResponse = PageOfStatuses;

export type SearchError = unknown;

export type GetTaskData = {
  path: {
    /**
     * The ID of the task.
     */
    taskId: string;
  };
};

export type GetTaskResponse = TaskProgressBeanObject;

export type GetTaskError = unknown;

export type CancelTaskData = {
  path: {
    /**
     * The ID of the task.
     */
    taskId: string;
  };
};

export type CancelTaskResponse = unknown;

export type CancelTaskError = Array<string>;

export type GetUiModificationsData = {
  query?: {
    /**
     * Use expand to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `data` Returns UI modification data.
     * *  `contexts` Returns UI modification contexts.
     */
    expand?: string;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetUiModificationsResponse = PageBeanUiModificationDetails;

export type GetUiModificationsError = unknown;

export type CreateUiModificationData = {
  /**
   * Details of the UI modification.
   */
  body: CreateUiModificationDetails;
};

export type CreateUiModificationResponse = UiModificationIdentifiers;

export type CreateUiModificationError = unknown | DetailedErrorCollection;

export type DeleteUiModificationData = {
  path: {
    /**
     * The ID of the UI modification.
     */
    uiModificationId: string;
  };
};

export type DeleteUiModificationResponse = unknown;

export type DeleteUiModificationError = unknown;

export type UpdateUiModificationData = {
  /**
   * Details of the UI modification.
   */
  body: UpdateUiModificationDetails;
  path: {
    /**
     * The ID of the UI modification.
     */
    uiModificationId: string;
  };
};

export type UpdateUiModificationResponse = unknown;

export type UpdateUiModificationError = unknown | DetailedErrorCollection;

export type GetAvatarsData = {
  path: {
    /**
     * The ID of the item the avatar is associated with.
     */
    entityId: string;
    /**
     * The avatar type.
     */
    type: 'project' | 'issuetype' | 'priority';
  };
};

export type GetAvatarsResponse = Avatars;

export type GetAvatarsError = unknown;

export type StoreAvatarData = {
  body?: string;
  path: {
    /**
     * The ID of the item the avatar is associated with.
     */
    entityId: string;
    /**
     * The avatar type.
     */
    type: 'project' | 'issuetype' | 'priority';
  };
  query: {
    /**
     * The length of each side of the crop region.
     */
    size: number;
    /**
     * The X coordinate of the top-left corner of the crop region.
     */
    x?: number;
    /**
     * The Y coordinate of the top-left corner of the crop region.
     */
    y?: number;
  };
};

export type StoreAvatarResponse = Avatar;

export type StoreAvatarError = unknown;

export type DeleteAvatarData = {
  path: {
    /**
     * The ID of the avatar.
     */
    id: number;
    /**
     * The ID of the item the avatar is associated with.
     */
    owningObjectId: string;
    /**
     * The avatar type.
     */
    type: 'project' | 'issuetype' | 'priority';
  };
};

export type DeleteAvatarResponse = any;

export type DeleteAvatarError = unknown;

export type GetAvatarImageByTypeData = {
  path: {
    /**
     * The icon type of the avatar.
     */
    type: 'issuetype' | 'project' | 'priority';
  };
  query?: {
    /**
     * The format to return the avatar image in. If not provided the original content format is returned.
     */
    format?: 'png' | 'svg';
    /**
     * The size of the avatar image. If not provided the default size is returned.
     */
    size?: 'xsmall' | 'small' | 'medium' | 'large' | 'xlarge';
  };
};

export type GetAvatarImageByTypeResponse = StreamingResponseBody;

export type GetAvatarImageByTypeError = ErrorCollection;

export type GetAvatarImageByIdData = {
  path: {
    /**
     * The ID of the avatar.
     */
    id: number;
    /**
     * The icon type of the avatar.
     */
    type: 'issuetype' | 'project' | 'priority';
  };
  query?: {
    /**
     * The format to return the avatar image in. If not provided the original content format is returned.
     */
    format?: 'png' | 'svg';
    /**
     * The size of the avatar image. If not provided the default size is returned.
     */
    size?: 'xsmall' | 'small' | 'medium' | 'large' | 'xlarge';
  };
};

export type GetAvatarImageByIdResponse = StreamingResponseBody;

export type GetAvatarImageByIdError = ErrorCollection;

export type GetAvatarImageByOwnerData = {
  path: {
    /**
     * The ID of the project or issue type the avatar belongs to.
     */
    entityId: string;
    /**
     * The icon type of the avatar.
     */
    type: 'issuetype' | 'project' | 'priority';
  };
  query?: {
    /**
     * The format to return the avatar image in. If not provided the original content format is returned.
     */
    format?: 'png' | 'svg';
    /**
     * The size of the avatar image. If not provided the default size is returned.
     */
    size?: 'xsmall' | 'small' | 'medium' | 'large' | 'xlarge';
  };
};

export type GetAvatarImageByOwnerResponse = StreamingResponseBody;

export type GetAvatarImageByOwnerError = ErrorCollection;

export type RemoveUserData = {
  query: {
    /**
     * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.
     */
    accountId: string;
    /**
     * This parameter is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    key?: string;
    /**
     * This parameter is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    username?: string;
  };
};

export type RemoveUserResponse = any;

export type RemoveUserError = unknown;

export type GetUserData = {
  query?: {
    /**
     * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*. Required.
     */
    accountId?: string;
    /**
     * Use [expand](#expansion) to include additional information about users in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `groups` includes all groups and nested groups to which the user belongs.
     * *  `applicationRoles` includes details of all the applications to which the user has access.
     */
    expand?: string;
    /**
     * This parameter is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide) for details.
     */
    key?: string;
    /**
     * This parameter is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide) for details.
     */
    username?: string;
  };
};

export type GetUserResponse = User;

export type GetUserError = unknown;

export type CreateUserData = {
  /**
   * Details about the user to be created.
   */
  body: NewUserDetails;
};

export type CreateUserResponse = User;

export type CreateUserError = unknown;

export type FindBulkAssignableUsersData = {
  query: {
    /**
     * A query string that is matched exactly against user `accountId`. Required, unless `query` is specified.
     */
    accountId?: string;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * A list of project keys (case sensitive). This parameter accepts a comma-separated list.
     */
    projectKeys: string;
    /**
     * A query string that is matched against user attributes, such as `displayName` and `emailAddress`, to find relevant users. The string can match the prefix of the attribute's value. For example, *query=john* matches a user with a `displayName` of *John Smith* and a user with an `emailAddress` of *johnson@example.com*. Required, unless `accountId` is specified.
     */
    query?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
    /**
     * This parameter is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    username?: string;
  };
};

export type FindBulkAssignableUsersResponse = Array<User>;

export type FindBulkAssignableUsersError = unknown;

export type FindAssignableUsersData = {
  query?: {
    /**
     * A query string that is matched exactly against user `accountId`. Required, unless `query` is specified.
     */
    accountId?: string;
    /**
     * The ID of the transition.
     */
    actionDescriptorId?: number;
    /**
     * The key of the issue. Required, unless `project` is specified.
     */
    issueKey?: string;
    /**
     * The maximum number of items to return. This operation may return less than the maximum number of items even if more are available. The operation fetches users up to the maximum and then, from the fetched users, returns only the users that can be assigned to the issue.
     */
    maxResults?: number;
    /**
     * The project ID or project key (case sensitive). Required, unless `issueKey` is specified.
     */
    project?: string;
    /**
     * A query string that is matched against user attributes, such as `displayName`, and `emailAddress`, to find relevant users. The string can match the prefix of the attribute's value. For example, *query=john* matches a user with a `displayName` of *John Smith* and a user with an `emailAddress` of *johnson@example.com*. Required, unless `username` or `accountId` is specified.
     */
    query?: string;
    recommend?: boolean;
    /**
     * The sessionId of this request. SessionId is the same until the assignee is set.
     */
    sessionId?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
    /**
     * This parameter is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    username?: string;
  };
};

export type FindAssignableUsersResponse = Array<User>;

export type FindAssignableUsersError = unknown;

export type BulkGetUsersData = {
  query: {
    /**
     * The account ID of a user. To specify multiple users, pass multiple `accountId` parameters. For example, `accountId=5b10a2844c20165700ede21g&accountId=5b10ac8d82e05b22cc7d4ef5`.
     */
    accountId: Array<string>;
    /**
     * This parameter is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    key?: Array<string>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
    /**
     * This parameter is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    username?: Array<string>;
  };
};

export type BulkGetUsersResponse = PageBeanUser;

export type BulkGetUsersError = unknown;

export type BulkGetUsersMigrationData = {
  query?: {
    /**
     * Key of a user. To specify multiple users, pass multiple copies of this parameter. For example, `key=fred&key=barney`. Required if `username` isn't provided. Cannot be provided if `username` is present.
     */
    key?: Array<string>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
    /**
     * Username of a user. To specify multiple users, pass multiple copies of this parameter. For example, `username=fred&username=barney`. Required if `key` isn't provided. Cannot be provided if `key` is present.
     */
    username?: Array<string>;
  };
};

export type BulkGetUsersMigrationResponse = Array<UserMigrationBean>;

export type BulkGetUsersMigrationError = unknown;

export type ResetUserColumnsData = {
  query?: {
    /**
     * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.
     */
    accountId?: string;
    /**
     * This parameter is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    username?: string;
  };
};

export type ResetUserColumnsResponse = any;

export type ResetUserColumnsError = unknown;

export type GetUserDefaultColumnsData = {
  query?: {
    /**
     * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.
     */
    accountId?: string;
    /**
     * This parameter is no longer available See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    username?: string;
  };
};

export type GetUserDefaultColumnsResponse = Array<ColumnItem>;

export type GetUserDefaultColumnsError = unknown;

export type SetUserColumnsData = {
  /**
   * The ID of a column to set. To set multiple columns, send multiple `columns` parameters.
   */
  body: UserColumnRequestBody;
  query?: {
    /**
     * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.
     */
    accountId?: string;
  };
};

export type SetUserColumnsResponse = unknown;

export type SetUserColumnsError = unknown;

export type GetUserEmailData = {
  query: {
    /**
     * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, `5b10ac8d82e05b22cc7d4ef5`.
     */
    accountId: string;
  };
};

export type GetUserEmailResponse = UnrestrictedUserEmail;

export type GetUserEmailError = unknown;

export type GetUserEmailBulkData = {
  query: {
    /**
     * The account IDs of the users for which emails are required. An `accountId` is an identifier that uniquely identifies the user across all Atlassian products. For example, `5b10ac8d82e05b22cc7d4ef5`. Note, this should be treated as an opaque identifier (that is, do not assume any structure in the value).
     */
    accountId: Array<string>;
  };
};

export type GetUserEmailBulkResponse = UnrestrictedUserEmail;

export type GetUserEmailBulkError = unknown;

export type GetUserGroupsData = {
  query: {
    /**
     * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.
     */
    accountId: string;
    /**
     * This parameter is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    key?: string;
    /**
     * This parameter is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    username?: string;
  };
};

export type GetUserGroupsResponse = Array<GroupName>;

export type GetUserGroupsError = unknown;

export type FindUsersWithAllPermissionsData = {
  query: {
    /**
     * A query string that is matched exactly against user `accountId`. Required, unless `query` is specified.
     */
    accountId?: string;
    /**
     * The issue key for the issue.
     */
    issueKey?: string;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * A comma separated list of permissions. Permissions can be specified as any:
     *
     * *  permission returned by [Get all permissions](#api-rest-api-3-permissions-get).
     * *  custom project permission added by Connect apps.
     * *  (deprecated) one of the following:
     *
     * *  ASSIGNABLE\_USER
     * *  ASSIGN\_ISSUE
     * *  ATTACHMENT\_DELETE\_ALL
     * *  ATTACHMENT\_DELETE\_OWN
     * *  BROWSE
     * *  CLOSE\_ISSUE
     * *  COMMENT\_DELETE\_ALL
     * *  COMMENT\_DELETE\_OWN
     * *  COMMENT\_EDIT\_ALL
     * *  COMMENT\_EDIT\_OWN
     * *  COMMENT\_ISSUE
     * *  CREATE\_ATTACHMENT
     * *  CREATE\_ISSUE
     * *  DELETE\_ISSUE
     * *  EDIT\_ISSUE
     * *  LINK\_ISSUE
     * *  MANAGE\_WATCHER\_LIST
     * *  MODIFY\_REPORTER
     * *  MOVE\_ISSUE
     * *  PROJECT\_ADMIN
     * *  RESOLVE\_ISSUE
     * *  SCHEDULE\_ISSUE
     * *  SET\_ISSUE\_SECURITY
     * *  TRANSITION\_ISSUE
     * *  VIEW\_VERSION\_CONTROL
     * *  VIEW\_VOTERS\_AND\_WATCHERS
     * *  VIEW\_WORKFLOW\_READONLY
     * *  WORKLOG\_DELETE\_ALL
     * *  WORKLOG\_DELETE\_OWN
     * *  WORKLOG\_EDIT\_ALL
     * *  WORKLOG\_EDIT\_OWN
     * *  WORK\_ISSUE
     */
    permissions: string;
    /**
     * The project key for the project (case sensitive).
     */
    projectKey?: string;
    /**
     * A query string that is matched against user attributes, such as `displayName` and `emailAddress`, to find relevant users. The string can match the prefix of the attribute's value. For example, *query=john* matches a user with a `displayName` of *John Smith* and a user with an `emailAddress` of *johnson@example.com*. Required, unless `accountId` is specified.
     */
    query?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
    /**
     * This parameter is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    username?: string;
  };
};

export type FindUsersWithAllPermissionsResponse = Array<User>;

export type FindUsersWithAllPermissionsError = unknown;

export type FindUsersForPickerData = {
  query: {
    avatarSize?: string;
    /**
     * This parameter is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    exclude?: Array<string>;
    /**
     * A list of account IDs to exclude from the search results. This parameter accepts a comma-separated list. Multiple account IDs can also be provided using an ampersand-separated list. For example, `excludeAccountIds=5b10a2844c20165700ede21g,5b10a0effa615349cb016cd8&excludeAccountIds=5b10ac8d82e05b22cc7d4ef5`. Cannot be provided with `exclude`.
     */
    excludeAccountIds?: Array<string>;
    excludeConnectUsers?: boolean;
    /**
     * The maximum number of items to return. The total number of matched users is returned in `total`.
     */
    maxResults?: number;
    /**
     * A query string that is matched against user attributes, such as `displayName`, and `emailAddress`, to find relevant users. The string can match the prefix of the attribute's value. For example, *query=john* matches a user with a `displayName` of *John Smith* and a user with an `emailAddress` of *johnson@example.com*.
     */
    query: string;
    /**
     * Include the URI to the user's avatar.
     */
    showAvatar?: boolean;
  };
};

export type FindUsersForPickerResponse = FoundUsers;

export type FindUsersForPickerError = unknown;

export type GetUserPropertyKeysData = {
  query?: {
    /**
     * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.
     */
    accountId?: string;
    /**
     * This parameter is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    userKey?: string;
    /**
     * This parameter is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    username?: string;
  };
};

export type GetUserPropertyKeysResponse = PropertyKeys;

export type GetUserPropertyKeysError = unknown;

export type DeleteUserPropertyData = {
  path: {
    /**
     * The key of the user's property.
     */
    propertyKey: string;
  };
  query?: {
    /**
     * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.
     */
    accountId?: string;
    /**
     * This parameter is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    userKey?: string;
    /**
     * This parameter is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    username?: string;
  };
};

export type DeleteUserPropertyResponse = any;

export type DeleteUserPropertyError = unknown;

export type GetUserPropertyData = {
  path: {
    /**
     * The key of the user's property.
     */
    propertyKey: string;
  };
  query?: {
    /**
     * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.
     */
    accountId?: string;
    /**
     * This parameter is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    userKey?: string;
    /**
     * This parameter is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    username?: string;
  };
};

export type GetUserPropertyResponse = EntityProperty;

export type GetUserPropertyError = unknown;

export type SetUserPropertyData = {
  /**
   * The value of the property. The value has to be a valid, non-empty [JSON](https://tools.ietf.org/html/rfc4627) value. The maximum length of the property value is 32768 bytes.
   */
  body?: string;
  path: {
    /**
     * The key of the user's property. The maximum length is 255 characters.
     */
    propertyKey: string;
  };
  query?: {
    /**
     * The account ID of the user, which uniquely identifies the user across all Atlassian products. For example, *5b10ac8d82e05b22cc7d4ef5*.
     */
    accountId?: string;
    /**
     * This parameter is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    userKey?: string;
    /**
     * This parameter is no longer available and will be removed from the documentation soon. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    username?: string;
  };
};

export type SetUserPropertyResponse = unknown;

export type SetUserPropertyError = unknown;

export type FindUsersData = {
  query?: {
    /**
     * A query string that is matched exactly against a user `accountId`. Required, unless `query` or `property` is specified.
     */
    accountId?: string;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * A query string used to search properties. Property keys are specified by path, so property keys containing dot (.) or equals (=) characters cannot be used. The query string cannot be specified using a JSON object. Example: To search for the value of `nested` from `{"something":{"nested":1,"other":2}}` use `thepropertykey.something.nested=1`. Required, unless `accountId` or `query` is specified.
     */
    property?: string;
    /**
     * A query string that is matched against user attributes ( `displayName`, and `emailAddress`) to find relevant users. The string can match the prefix of the attribute's value. For example, *query=john* matches a user with a `displayName` of *John Smith* and a user with an `emailAddress` of *johnson@example.com*. Required, unless `accountId` or `property` is specified.
     */
    query?: string;
    /**
     * The index of the first item to return in a page of filtered results (page offset).
     */
    startAt?: number;
    username?: string;
  };
};

export type FindUsersResponse = Array<User>;

export type FindUsersError = unknown;

export type FindUsersByQueryData = {
  query: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The search query.
     */
    query: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type FindUsersByQueryResponse = PageBeanUser;

export type FindUsersByQueryError = ErrorCollection;

export type FindUserKeysByQueryData = {
  query: {
    /**
     * The maximum number of items to return per page.
     */
    maxResult?: number;
    /**
     * The search query.
     */
    query: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type FindUserKeysByQueryResponse = PageBeanUserKey;

export type FindUserKeysByQueryError = ErrorCollection;

export type FindUsersWithBrowsePermissionData = {
  query?: {
    /**
     * A query string that is matched exactly against user `accountId`. Required, unless `query` is specified.
     */
    accountId?: string;
    /**
     * The issue key for the issue. Required, unless `projectKey` is specified.
     */
    issueKey?: string;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The project key for the project (case sensitive). Required, unless `issueKey` is specified.
     */
    projectKey?: string;
    /**
     * A query string that is matched against user attributes, such as `displayName` and `emailAddress`, to find relevant users. The string can match the prefix of the attribute's value. For example, *query=john* matches a user with a `displayName` of *John Smith* and a user with an `emailAddress` of *johnson@example.com*. Required, unless `accountId` is specified.
     */
    query?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
    /**
     * This parameter is no longer available. See the [deprecation notice](https://developer.atlassian.com/cloud/jira/platform/deprecation-notice-user-privacy-api-migration-guide/) for details.
     */
    username?: string;
  };
};

export type FindUsersWithBrowsePermissionResponse = Array<User>;

export type FindUsersWithBrowsePermissionError = unknown;

export type GetAllUsersDefaultData = {
  query?: {
    /**
     * The maximum number of items to return.
     */
    maxResults?: number;
    /**
     * The index of the first item to return.
     */
    startAt?: number;
  };
};

export type GetAllUsersDefaultResponse = Array<User>;

export type GetAllUsersDefaultError = unknown;

export type GetAllUsersData = {
  query?: {
    /**
     * The maximum number of items to return.
     */
    maxResults?: number;
    /**
     * The index of the first item to return.
     */
    startAt?: number;
  };
};

export type GetAllUsersResponse = Array<User>;

export type GetAllUsersError = unknown;

export type CreateVersionData = {
  body: Version;
};

export type CreateVersionResponse = Version;

export type CreateVersionError = unknown;

export type DeleteVersionData = {
  path: {
    /**
     * The ID of the version.
     */
    id: string;
  };
  query?: {
    /**
     * The ID of the version to update `affectedVersion` to when the field contains the deleted version. The replacement version must be in the same project as the version being deleted and cannot be the version being deleted.
     */
    moveAffectedIssuesTo?: string;
    /**
     * The ID of the version to update `fixVersion` to when the field contains the deleted version. The replacement version must be in the same project as the version being deleted and cannot be the version being deleted.
     */
    moveFixIssuesTo?: string;
  };
};

export type DeleteVersionResponse = any;

export type DeleteVersionError = unknown;

export type GetVersionData = {
  path: {
    /**
     * The ID of the version.
     */
    id: string;
  };
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about version in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `operations` Returns the list of operations available for this version.
     * *  `issuesstatus` Returns the count of issues in this version for each of the status categories *to do*, *in progress*, *done*, and *unmapped*. The *unmapped* property represents the number of issues with a status other than *to do*, *in progress*, and *done*.
     * *  `driver` Returns the Atlassian account ID of the version driver.
     * *  `approvers` Returns a list containing the Atlassian account IDs of approvers for this version.
     */
    expand?: string;
  };
};

export type GetVersionResponse = Version;

export type GetVersionError = unknown;

export type UpdateVersionData = {
  body: Version;
  path: {
    /**
     * The ID of the version.
     */
    id: string;
  };
};

export type UpdateVersionResponse = Version;

export type UpdateVersionError = unknown;

export type MergeVersionsData = {
  path: {
    /**
     * The ID of the version to delete.
     */
    id: string;
    /**
     * The ID of the version to merge into.
     */
    moveIssuesTo: string;
  };
};

export type MergeVersionsResponse = unknown;

export type MergeVersionsError = unknown;

export type MoveVersionData = {
  body: VersionMoveBean;
  path: {
    /**
     * The ID of the version to be moved.
     */
    id: string;
  };
};

export type MoveVersionResponse = Version;

export type MoveVersionError = unknown;

export type GetVersionRelatedIssuesData = {
  path: {
    /**
     * The ID of the version.
     */
    id: string;
  };
};

export type GetVersionRelatedIssuesResponse = VersionIssueCounts;

export type GetVersionRelatedIssuesError = unknown;

export type GetRelatedWorkData = {
  path: {
    /**
     * The ID of the version.
     */
    id: string;
  };
};

export type GetRelatedWorkResponse = Array<VersionRelatedWork>;

export type GetRelatedWorkError = unknown;

export type CreateRelatedWorkData = {
  body: VersionRelatedWork;
  path: {
    id: string;
  };
};

export type CreateRelatedWorkResponse = VersionRelatedWork;

export type CreateRelatedWorkError = unknown;

export type UpdateRelatedWorkData = {
  body: VersionRelatedWork;
  path: {
    /**
     * The ID of the version to update the related work on. For the related work id, pass it to the input JSON.
     */
    id: string;
  };
};

export type UpdateRelatedWorkResponse = VersionRelatedWork;

export type UpdateRelatedWorkError = unknown;

export type DeleteAndReplaceVersionData = {
  body: DeleteAndReplaceVersionBean;
  path: {
    /**
     * The ID of the version.
     */
    id: string;
  };
};

export type DeleteAndReplaceVersionResponse = unknown;

export type DeleteAndReplaceVersionError = unknown;

export type GetVersionUnresolvedIssuesData = {
  path: {
    /**
     * The ID of the version.
     */
    id: string;
  };
};

export type GetVersionUnresolvedIssuesResponse = VersionUnresolvedIssuesCount;

export type GetVersionUnresolvedIssuesError = unknown;

export type DeleteRelatedWorkData = {
  path: {
    /**
     * The ID of the related work to delete.
     */
    relatedWorkId: string;
    /**
     * The ID of the version that the target related work belongs to.
     */
    versionId: string;
  };
};

export type DeleteRelatedWorkResponse = any;

export type DeleteRelatedWorkError = unknown;

export type DeleteWebhookByIdData = {
  body: ContainerForWebhookIDs;
};

export type DeleteWebhookByIdResponse = unknown;

export type DeleteWebhookByIdError = ErrorCollection;

export type GetDynamicWebhooksForAppData = {
  query?: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetDynamicWebhooksForAppResponse = PageBeanWebhook;

export type GetDynamicWebhooksForAppError = ErrorCollection;

export type RegisterDynamicWebhooksData = {
  body: WebhookRegistrationDetails;
};

export type RegisterDynamicWebhooksResponse = ContainerForRegisteredWebhooks;

export type RegisterDynamicWebhooksError = ErrorCollection;

export type GetFailedWebhooksData = {
  query?: {
    /**
     * The time after which any webhook failure must have occurred for the record to be returned, expressed as milliseconds since the UNIX epoch.
     */
    after?: number;
    /**
     * The maximum number of webhooks to return per page. If obeying the maxResults directive would result in records with the same failure time being split across pages, the directive is ignored and all records with the same failure time included on the page.
     */
    maxResults?: number;
  };
};

export type GetFailedWebhooksResponse = FailedWebhooks;

export type GetFailedWebhooksError = ErrorCollection;

export type RefreshWebhooksData = {
  body: ContainerForWebhookIDs;
};

export type RefreshWebhooksResponse = WebhooksExpirationDate;

export type RefreshWebhooksError = ErrorCollection;

export type GetAllWorkflowsData = {
  query?: {
    /**
     * The name of the workflow to be returned. Only one workflow can be specified.
     */
    workflowName?: string;
  };
};

export type GetAllWorkflowsResponse = Array<DeprecatedWorkflow>;

export type GetAllWorkflowsError = unknown;

export type CreateWorkflowData = {
  /**
   * The workflow details.
   */
  body: CreateWorkflowDetails;
};

export type CreateWorkflowResponse = WorkflowIDs;

export type CreateWorkflowError = unknown;

export type GetWorkflowTransitionRuleConfigurationsData = {
  query: {
    /**
     * Whether draft or published workflows are returned. If not provided, both workflow types are returned.
     */
    draft?: boolean;
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts `transition`, which, for each rule, returns information about the transition the rule is assigned to.
     */
    expand?: string;
    /**
     * The transition rule class keys, as defined in the Connect or the Forge app descriptor, of the transition rules to return.
     */
    keys?: Array<string>;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
    /**
     * The types of the transition rules to return.
     */
    types: Array<'postfunction' | 'condition' | 'validator'>;
    /**
     * The list of `tags` to filter by.
     */
    withTags?: Array<string>;
    /**
     * The list of workflow names to filter by.
     */
    workflowNames?: Array<string>;
  };
};

export type GetWorkflowTransitionRuleConfigurationsResponse = PageBeanWorkflowTransitionRules;

export type GetWorkflowTransitionRuleConfigurationsError = ErrorCollection | unknown;

export type UpdateWorkflowTransitionRuleConfigurationsData = {
  body: WorkflowTransitionRulesUpdate;
};

export type UpdateWorkflowTransitionRuleConfigurationsResponse = WorkflowTransitionRulesUpdateErrors;

export type UpdateWorkflowTransitionRuleConfigurationsError = ErrorCollection | unknown;

export type DeleteWorkflowTransitionRuleConfigurationsData = {
  body: WorkflowsWithTransitionRulesDetails;
};

export type DeleteWorkflowTransitionRuleConfigurationsResponse = WorkflowTransitionRulesUpdateErrors;

export type DeleteWorkflowTransitionRuleConfigurationsError = ErrorCollection;

export type GetWorkflowsPaginatedData = {
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `transitions` For each workflow, returns information about the transitions inside the workflow.
     * *  `transitions.rules` For each workflow transition, returns information about its rules. Transitions are included automatically if this expand is requested.
     * *  `transitions.properties` For each workflow transition, returns information about its properties. Transitions are included automatically if this expand is requested.
     * *  `statuses` For each workflow, returns information about the statuses inside the workflow.
     * *  `statuses.properties` For each workflow status, returns information about its properties. Statuses are included automatically if this expand is requested.
     * *  `default` For each workflow, returns information about whether this is the default workflow.
     * *  `schemes` For each workflow, returns information about the workflow schemes the workflow is assigned to.
     * *  `projects` For each workflow, returns information about the projects the workflow is assigned to, through workflow schemes.
     * *  `hasDraftWorkflow` For each workflow, returns information about whether the workflow has a draft version.
     * *  `operations` For each workflow, returns information about the actions that can be undertaken on the workflow.
     */
    expand?: string;
    /**
     * Filters active and inactive workflows.
     */
    isActive?: boolean;
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * [Order](#ordering) the results by a field:
     *
     * *  `name` Sorts by workflow name.
     * *  `created` Sorts by create time.
     * *  `updated` Sorts by update time.
     */
    orderBy?: 'name' | '-name' | '+name' | 'created' | '-created' | '+created' | 'updated' | '+updated' | '-updated';
    /**
     * String used to perform a case-insensitive partial match with workflow name.
     */
    queryString?: string;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
    /**
     * The name of a workflow to return. To include multiple workflows, provide an ampersand-separated list. For example, `workflowName=name1&workflowName=name2`.
     */
    workflowName?: Array<string>;
  };
};

export type GetWorkflowsPaginatedResponse = PageBeanWorkflow;

export type GetWorkflowsPaginatedError = unknown | ErrorCollection;

export type DeleteWorkflowTransitionPropertyData = {
  path: {
    /**
     * The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition.
     */
    transitionId: number;
  };
  query: {
    /**
     * The name of the transition property to delete, also known as the name of the property.
     */
    key: string;
    /**
     * The workflow status. Set to `live` for inactive workflows or `draft` for draft workflows. Active workflows cannot be edited.
     */
    workflowMode?: 'live' | 'draft';
    /**
     * The name of the workflow that the transition belongs to.
     */
    workflowName: string;
  };
};

export type DeleteWorkflowTransitionPropertyResponse = unknown;

export type DeleteWorkflowTransitionPropertyError = unknown;

export type GetWorkflowTransitionPropertiesData = {
  path: {
    /**
     * The ID of the transition. To get the ID, view the workflow in text mode in the Jira administration console. The ID is shown next to the transition.
     */
    transitionId: number;
  };
  query: {
    /**
     * Some properties with keys that have the *jira.* prefix are reserved, which means they are not editable. To include these properties in the results, set this parameter to *true*.
     */
    includeReservedKeys?: boolean;
    /**
     * The key of the property being returned, also known as the name of the property. If this parameter is not specified, all properties on the transition are returned.
     */
    key?: string;
    /**
     * The workflow status. Set to *live* for active and inactive workflows, or *draft* for draft workflows.
     */
    workflowMode?: 'live' | 'draft';
    /**
     * The name of the workflow that the transition belongs to.
     */
    workflowName: string;
  };
};

export type GetWorkflowTransitionPropertiesResponse = WorkflowTransitionProperty;

export type GetWorkflowTransitionPropertiesError = unknown;

export type CreateWorkflowTransitionPropertyData = {
  body: WorkflowTransitionProperty;
  path: {
    /**
     * The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition.
     */
    transitionId: number;
  };
  query: {
    /**
     * The key of the property being added, also known as the name of the property. Set this to the same value as the `key` defined in the request body.
     */
    key: string;
    /**
     * The workflow status. Set to *live* for inactive workflows or *draft* for draft workflows. Active workflows cannot be edited.
     */
    workflowMode?: 'live' | 'draft';
    /**
     * The name of the workflow that the transition belongs to.
     */
    workflowName: string;
  };
};

export type CreateWorkflowTransitionPropertyResponse = WorkflowTransitionProperty;

export type CreateWorkflowTransitionPropertyError = unknown;

export type UpdateWorkflowTransitionPropertyData = {
  body: WorkflowTransitionProperty;
  path: {
    /**
     * The ID of the transition. To get the ID, view the workflow in text mode in the Jira admin settings. The ID is shown next to the transition.
     */
    transitionId: number;
  };
  query: {
    /**
     * The key of the property being updated, also known as the name of the property. Set this to the same value as the `key` defined in the request body.
     */
    key: string;
    /**
     * The workflow status. Set to `live` for inactive workflows or `draft` for draft workflows. Active workflows cannot be edited.
     */
    workflowMode?: 'live' | 'draft';
    /**
     * The name of the workflow that the transition belongs to.
     */
    workflowName: string;
  };
};

export type UpdateWorkflowTransitionPropertyResponse = WorkflowTransitionProperty;

export type UpdateWorkflowTransitionPropertyError = unknown;

export type DeleteInactiveWorkflowData = {
  path: {
    /**
     * The entity ID of the workflow.
     */
    entityId: string;
  };
};

export type DeleteInactiveWorkflowResponse = any;

export type DeleteInactiveWorkflowError = unknown;

export type ReadWorkflowsData = {
  body: WorkflowReadRequest;
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `workflows.usages` Returns the project and issue types that each workflow is associated with.
     * *  `statuses.usages` Returns the project and issue types that each status is associated with.
     */
    expand?: string;
    /**
     * Return the new field `approvalConfiguration` instead of the deprecated status properties for approval configuration.
     */
    useApprovalConfiguration?: boolean;
    /**
     * Return the new fields (`toStatusReference`/`links`) instead of the deprecated fields (`to`/`from`) for workflow transition port mappings.
     */
    useTransitionLinksFormat?: boolean;
  };
};

export type ReadWorkflowsResponse = WorkflowReadResponse;

export type ReadWorkflowsError = unknown;

export type WorkflowCapabilitiesData = {
  query?: {
    issueTypeId?: string;
    projectId?: string;
    workflowId?: string;
  };
};

export type WorkflowCapabilitiesResponse = WorkflowCapabilities;

export type WorkflowCapabilitiesError = unknown;

export type CreateWorkflowsData = {
  body: WorkflowCreateRequest;
};

export type CreateWorkflowsResponse = WorkflowCreateResponse;

export type CreateWorkflowsError = unknown;

export type ValidateCreateWorkflowsData = {
  body: WorkflowCreateValidateRequest;
};

export type ValidateCreateWorkflowsResponse = WorkflowValidationErrorList;

export type ValidateCreateWorkflowsError = unknown;

export type UpdateWorkflowsData = {
  body: WorkflowUpdateRequest;
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `workflows.usages` Returns the project and issue types that each workflow is associated with.
     * *  `statuses.usages` Returns the project and issue types that each status is associated with.
     */
    expand?: string;
  };
};

export type UpdateWorkflowsResponse = WorkflowUpdateResponse;

export type UpdateWorkflowsError = unknown;

export type ValidateUpdateWorkflowsData = {
  body: WorkflowUpdateValidateRequestBean;
};

export type ValidateUpdateWorkflowsResponse = WorkflowValidationErrorList;

export type ValidateUpdateWorkflowsError = unknown;

export type GetAllWorkflowSchemesData = {
  query?: {
    /**
     * The maximum number of items to return per page.
     */
    maxResults?: number;
    /**
     * The index of the first item to return in a page of results (page offset).
     */
    startAt?: number;
  };
};

export type GetAllWorkflowSchemesResponse = PageBeanWorkflowScheme;

export type GetAllWorkflowSchemesError = unknown;

export type CreateWorkflowSchemeData = {
  body: WorkflowScheme;
};

export type CreateWorkflowSchemeResponse = WorkflowScheme;

export type CreateWorkflowSchemeError = unknown;

export type GetWorkflowSchemeProjectAssociationsData = {
  query: {
    /**
     * The ID of a project to return the workflow schemes for. To include multiple projects, provide an ampersand-Jim: oneseparated list. For example, `projectId=10000&projectId=10001`.
     */
    projectId: Array<number>;
  };
};

export type GetWorkflowSchemeProjectAssociationsResponse = ContainerOfWorkflowSchemeAssociations;

export type GetWorkflowSchemeProjectAssociationsError = unknown;

export type AssignSchemeToProjectData = {
  body: WorkflowSchemeProjectAssociation;
};

export type AssignSchemeToProjectResponse = unknown;

export type AssignSchemeToProjectError = unknown;

export type ReadWorkflowSchemesData = {
  body: WorkflowSchemeReadRequest;
  query?: {
    /**
     * Use [expand](#expansion) to include additional information in the response. This parameter accepts a comma-separated list. Expand options include:
     *
     * *  `workflows.usages` Returns the project and issue types that each workflow in the workflow scheme is associated with.
     */
    expand?: string;
  };
};

export type ReadWorkflowSchemesResponse = Array<WorkflowSchemeReadResponse>;

export type ReadWorkflowSchemesError = unknown;

export type UpdateSchemesData = {
  body: WorkflowSchemeUpdateRequest;
};

export type UpdateSchemesResponse = unknown;

export type UpdateSchemesError = TaskProgressBeanObject | unknown;

export type UpdateWorkflowSchemeMappingsData = {
  body: WorkflowSchemeUpdateRequiredMappingsRequest;
};

export type UpdateWorkflowSchemeMappingsResponse = WorkflowSchemeUpdateRequiredMappingsResponse;

export type UpdateWorkflowSchemeMappingsError = unknown;

export type DeleteWorkflowSchemeData = {
  path: {
    /**
     * The ID of the workflow scheme. Find this ID by editing the desired workflow scheme in Jira. The ID is shown in the URL as `schemeId`. For example, *schemeId=10301*.
     */
    id: number;
  };
};

export type DeleteWorkflowSchemeResponse = unknown;

export type DeleteWorkflowSchemeError = unknown;

export type GetWorkflowSchemeData = {
  path: {
    /**
     * The ID of the workflow scheme. Find this ID by editing the desired workflow scheme in Jira. The ID is shown in the URL as `schemeId`. For example, *schemeId=10301*.
     */
    id: number;
  };
  query?: {
    /**
     * Returns the workflow scheme's draft rather than scheme itself, if set to true. If the workflow scheme does not have a draft, then the workflow scheme is returned.
     */
    returnDraftIfExists?: boolean;
  };
};

export type GetWorkflowSchemeResponse = WorkflowScheme;

export type GetWorkflowSchemeError = unknown;

export type UpdateWorkflowSchemeData = {
  body: WorkflowScheme;
  path: {
    /**
     * The ID of the workflow scheme. Find this ID by editing the desired workflow scheme in Jira. The ID is shown in the URL as `schemeId`. For example, *schemeId=10301*.
     */
    id: number;
  };
};

export type UpdateWorkflowSchemeResponse = WorkflowScheme;

export type UpdateWorkflowSchemeError = unknown;

export type CreateWorkflowSchemeDraftFromParentData = {
  path: {
    /**
     * The ID of the active workflow scheme that the draft is created from.
     */
    id: number;
  };
};

export type CreateWorkflowSchemeDraftFromParentResponse = WorkflowScheme;

export type CreateWorkflowSchemeDraftFromParentError = unknown;

export type DeleteDefaultWorkflowData = {
  path: {
    /**
     * The ID of the workflow scheme.
     */
    id: number;
  };
  query?: {
    /**
     * Set to true to create or update the draft of a workflow scheme and delete the mapping from the draft, when the workflow scheme cannot be edited. Defaults to `false`.
     */
    updateDraftIfNeeded?: boolean;
  };
};

export type DeleteDefaultWorkflowResponse = WorkflowScheme;

export type DeleteDefaultWorkflowError = unknown;

export type GetDefaultWorkflowData = {
  path: {
    /**
     * The ID of the workflow scheme.
     */
    id: number;
  };
  query?: {
    /**
     * Set to `true` to return the default workflow for the workflow scheme's draft rather than scheme itself. If the workflow scheme does not have a draft, then the default workflow for the workflow scheme is returned.
     */
    returnDraftIfExists?: boolean;
  };
};

export type GetDefaultWorkflowResponse = DefaultWorkflow;

export type GetDefaultWorkflowError = unknown;

export type UpdateDefaultWorkflowData = {
  /**
   * The new default workflow.
   */
  body: DefaultWorkflow;
  path: {
    /**
     * The ID of the workflow scheme.
     */
    id: number;
  };
};

export type UpdateDefaultWorkflowResponse = WorkflowScheme;

export type UpdateDefaultWorkflowError = unknown;

export type DeleteWorkflowSchemeDraftData = {
  path: {
    /**
     * The ID of the active workflow scheme that the draft was created from.
     */
    id: number;
  };
};

export type DeleteWorkflowSchemeDraftResponse = any;

export type DeleteWorkflowSchemeDraftError = unknown;

export type GetWorkflowSchemeDraftData = {
  path: {
    /**
     * The ID of the active workflow scheme that the draft was created from.
     */
    id: number;
  };
};

export type GetWorkflowSchemeDraftResponse = WorkflowScheme;

export type GetWorkflowSchemeDraftError = unknown;

export type UpdateWorkflowSchemeDraftData = {
  body: WorkflowScheme;
  path: {
    /**
     * The ID of the active workflow scheme that the draft was created from.
     */
    id: number;
  };
};

export type UpdateWorkflowSchemeDraftResponse = WorkflowScheme;

export type UpdateWorkflowSchemeDraftError = unknown;

export type DeleteDraftDefaultWorkflowData = {
  path: {
    /**
     * The ID of the workflow scheme that the draft belongs to.
     */
    id: number;
  };
};

export type DeleteDraftDefaultWorkflowResponse = WorkflowScheme;

export type DeleteDraftDefaultWorkflowError = unknown;

export type GetDraftDefaultWorkflowData = {
  path: {
    /**
     * The ID of the workflow scheme that the draft belongs to.
     */
    id: number;
  };
};

export type GetDraftDefaultWorkflowResponse = DefaultWorkflow;

export type GetDraftDefaultWorkflowError = unknown;

export type UpdateDraftDefaultWorkflowData = {
  /**
   * The object for the new default workflow.
   */
  body: DefaultWorkflow;
  path: {
    /**
     * The ID of the workflow scheme that the draft belongs to.
     */
    id: number;
  };
};

export type UpdateDraftDefaultWorkflowResponse = WorkflowScheme;

export type UpdateDraftDefaultWorkflowError = unknown;

export type DeleteWorkflowSchemeDraftIssueTypeData = {
  path: {
    /**
     * The ID of the workflow scheme that the draft belongs to.
     */
    id: number;
    /**
     * The ID of the issue type.
     */
    issueType: string;
  };
};

export type DeleteWorkflowSchemeDraftIssueTypeResponse = WorkflowScheme;

export type DeleteWorkflowSchemeDraftIssueTypeError = unknown;

export type GetWorkflowSchemeDraftIssueTypeData = {
  path: {
    /**
     * The ID of the workflow scheme that the draft belongs to.
     */
    id: number;
    /**
     * The ID of the issue type.
     */
    issueType: string;
  };
};

export type GetWorkflowSchemeDraftIssueTypeResponse = IssueTypeWorkflowMapping;

export type GetWorkflowSchemeDraftIssueTypeError = unknown;

export type SetWorkflowSchemeDraftIssueTypeData = {
  /**
   * The issue type-project mapping.
   */
  body: IssueTypeWorkflowMapping;
  path: {
    /**
     * The ID of the workflow scheme that the draft belongs to.
     */
    id: number;
    /**
     * The ID of the issue type.
     */
    issueType: string;
  };
};

export type SetWorkflowSchemeDraftIssueTypeResponse = WorkflowScheme;

export type SetWorkflowSchemeDraftIssueTypeError = unknown;

export type PublishDraftWorkflowSchemeData = {
  /**
   * Details of the status mappings.
   */
  body: PublishDraftWorkflowScheme;
  path: {
    /**
     * The ID of the workflow scheme that the draft belongs to.
     */
    id: number;
  };
  query?: {
    /**
     * Whether the request only performs a validation.
     */
    validateOnly?: boolean;
  };
};

export type PublishDraftWorkflowSchemeResponse = any;

export type PublishDraftWorkflowSchemeError = TaskProgressBeanObject | unknown;

export type DeleteDraftWorkflowMappingData = {
  path: {
    /**
     * The ID of the workflow scheme that the draft belongs to.
     */
    id: number;
  };
  query: {
    /**
     * The name of the workflow.
     */
    workflowName: string;
  };
};

export type DeleteDraftWorkflowMappingResponse = unknown;

export type DeleteDraftWorkflowMappingError = unknown;

export type GetDraftWorkflowData = {
  path: {
    /**
     * The ID of the workflow scheme that the draft belongs to.
     */
    id: number;
  };
  query?: {
    /**
     * The name of a workflow in the scheme. Limits the results to the workflow-issue type mapping for the specified workflow.
     */
    workflowName?: string;
  };
};

export type GetDraftWorkflowResponse = IssueTypesWorkflowMapping;

export type GetDraftWorkflowError = unknown;

export type UpdateDraftWorkflowMappingData = {
  body: IssueTypesWorkflowMapping;
  path: {
    /**
     * The ID of the workflow scheme that the draft belongs to.
     */
    id: number;
  };
  query: {
    /**
     * The name of the workflow.
     */
    workflowName: string;
  };
};

export type UpdateDraftWorkflowMappingResponse = WorkflowScheme;

export type UpdateDraftWorkflowMappingError = unknown;

export type DeleteWorkflowSchemeIssueTypeData = {
  path: {
    /**
     * The ID of the workflow scheme.
     */
    id: number;
    /**
     * The ID of the issue type.
     */
    issueType: string;
  };
  query?: {
    /**
     * Set to true to create or update the draft of a workflow scheme and update the mapping in the draft, when the workflow scheme cannot be edited. Defaults to `false`.
     */
    updateDraftIfNeeded?: boolean;
  };
};

export type DeleteWorkflowSchemeIssueTypeResponse = WorkflowScheme;

export type DeleteWorkflowSchemeIssueTypeError = unknown;

export type GetWorkflowSchemeIssueTypeData = {
  path: {
    /**
     * The ID of the workflow scheme.
     */
    id: number;
    /**
     * The ID of the issue type.
     */
    issueType: string;
  };
  query?: {
    /**
     * Returns the mapping from the workflow scheme's draft rather than the workflow scheme, if set to true. If no draft exists, the mapping from the workflow scheme is returned.
     */
    returnDraftIfExists?: boolean;
  };
};

export type GetWorkflowSchemeIssueTypeResponse = IssueTypeWorkflowMapping;

export type GetWorkflowSchemeIssueTypeError = unknown;

export type SetWorkflowSchemeIssueTypeData = {
  /**
   * The issue type-project mapping.
   */
  body: IssueTypeWorkflowMapping;
  path: {
    /**
     * The ID of the workflow scheme.
     */
    id: number;
    /**
     * The ID of the issue type.
     */
    issueType: string;
  };
};

export type SetWorkflowSchemeIssueTypeResponse = WorkflowScheme;

export type SetWorkflowSchemeIssueTypeError = unknown;

export type DeleteWorkflowMappingData = {
  path: {
    /**
     * The ID of the workflow scheme.
     */
    id: number;
  };
  query: {
    /**
     * Set to true to create or update the draft of a workflow scheme and delete the mapping from the draft, when the workflow scheme cannot be edited. Defaults to `false`.
     */
    updateDraftIfNeeded?: boolean;
    /**
     * The name of the workflow.
     */
    workflowName: string;
  };
};

export type DeleteWorkflowMappingResponse = unknown;

export type DeleteWorkflowMappingError = unknown;

export type GetWorkflowData = {
  path: {
    /**
     * The ID of the workflow scheme.
     */
    id: number;
  };
  query?: {
    /**
     * Returns the mapping from the workflow scheme's draft rather than the workflow scheme, if set to true. If no draft exists, the mapping from the workflow scheme is returned.
     */
    returnDraftIfExists?: boolean;
    /**
     * The name of a workflow in the scheme. Limits the results to the workflow-issue type mapping for the specified workflow.
     */
    workflowName?: string;
  };
};

export type GetWorkflowResponse = IssueTypesWorkflowMapping;

export type GetWorkflowError = unknown;

export type UpdateWorkflowMappingData = {
  body: IssueTypesWorkflowMapping;
  path: {
    /**
     * The ID of the workflow scheme.
     */
    id: number;
  };
  query: {
    /**
     * The name of the workflow.
     */
    workflowName: string;
  };
};

export type UpdateWorkflowMappingResponse = WorkflowScheme;

export type UpdateWorkflowMappingError = unknown;

export type GetIdsOfWorklogsDeletedSinceData = {
  query?: {
    /**
     * The date and time, as a UNIX timestamp in milliseconds, after which deleted worklogs are returned.
     */
    since?: number;
  };
};

export type GetIdsOfWorklogsDeletedSinceResponse = ChangedWorklogs;

export type GetIdsOfWorklogsDeletedSinceError = unknown;

export type GetWorklogsForIdsData = {
  /**
   * A JSON object containing a list of worklog IDs.
   */
  body: WorklogIdsRequestBean;
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about worklogs in the response. This parameter accepts `properties` that returns the properties of each worklog.
     */
    expand?: string;
  };
};

export type GetWorklogsForIdsResponse = Array<Worklog>;

export type GetWorklogsForIdsError = unknown;

export type GetIdsOfWorklogsModifiedSinceData = {
  query?: {
    /**
     * Use [expand](#expansion) to include additional information about worklogs in the response. This parameter accepts `properties` that returns the properties of each worklog.
     */
    expand?: string;
    /**
     * The date and time, as a UNIX timestamp in milliseconds, after which updated worklogs are returned.
     */
    since?: number;
  };
};

export type GetIdsOfWorklogsModifiedSinceResponse = ChangedWorklogs;

export type GetIdsOfWorklogsModifiedSinceError = unknown;

export type AddonPropertiesResourceGetAddonPropertiesGetData = {
  path: {
    /**
     * The key of the app, as defined in its descriptor.
     */
    addonKey: string;
  };
};

export type AddonPropertiesResourceGetAddonPropertiesGetResponse = PropertyKeys;

export type AddonPropertiesResourceGetAddonPropertiesGetError = OperationMessage;

export type AddonPropertiesResourceDeleteAddonPropertyDeleteData = {
  path: {
    /**
     * The key of the app, as defined in its descriptor.
     */
    addonKey: string;
    /**
     * The key of the property.
     */
    propertyKey: string;
  };
};

export type AddonPropertiesResourceDeleteAddonPropertyDeleteResponse = any;

export type AddonPropertiesResourceDeleteAddonPropertyDeleteError = OperationMessage;

export type AddonPropertiesResourceGetAddonPropertyGetData = {
  path: {
    /**
     * The key of the app, as defined in its descriptor.
     */
    addonKey: string;
    /**
     * The key of the property.
     */
    propertyKey: string;
  };
};

export type AddonPropertiesResourceGetAddonPropertyGetResponse = EntityProperty;

export type AddonPropertiesResourceGetAddonPropertyGetError = OperationMessage;

export type AddonPropertiesResourcePutAddonPropertyPutData = {
  body?: string;
  path: {
    /**
     * The key of the app, as defined in its descriptor.
     */
    addonKey: string;
    /**
     * The key of the property.
     */
    propertyKey: string;
  };
};

export type AddonPropertiesResourcePutAddonPropertyPutResponse = OperationMessage;

export type AddonPropertiesResourcePutAddonPropertyPutError = OperationMessage;

export type DynamicModulesResourceRemoveModulesDeleteData = {
  query?: {
    /**
     * The key of the module to remove. To include multiple module keys, provide multiple copies of this parameter.
     * For example, `moduleKey=dynamic-attachment-entity-property&moduleKey=dynamic-select-field`.
     * Nonexistent keys are ignored.
     */
    moduleKey?: Array<string>;
  };
};

export type DynamicModulesResourceRemoveModulesDeleteResponse = any;

export type DynamicModulesResourceRemoveModulesDeleteError = ErrorMessage;

export type DynamicModulesResourceGetModulesGetResponse = ConnectModules;

export type DynamicModulesResourceGetModulesGetError = ErrorMessage;

export type DynamicModulesResourceRegisterModulesPostData = {
  body: ConnectModules;
};

export type DynamicModulesResourceRegisterModulesPostResponse = unknown;

export type DynamicModulesResourceRegisterModulesPostError = ErrorMessage;

export type AppIssueFieldValueUpdateResourceUpdateIssueFieldsPutData = {
  body: ConnectCustomFieldValues;
  headers: {
    /**
     * The ID of the transfer.
     */
    'Atlassian-Transfer-Id': string;
  };
};

export type AppIssueFieldValueUpdateResourceUpdateIssueFieldsPutResponse = unknown;

export type AppIssueFieldValueUpdateResourceUpdateIssueFieldsPutError = unknown;

export type MigrationResourceUpdateEntityPropertiesValuePutData = {
  body: Array<EntityPropertyDetails>;
  headers: {
    /**
     * The app migration transfer ID.
     */
    'Atlassian-Transfer-Id': string;
  };
  path: {
    /**
     * The type indicating the object that contains the entity properties.
     */
    entityType:
      | 'IssueProperty'
      | 'CommentProperty'
      | 'DashboardItemProperty'
      | 'IssueTypeProperty'
      | 'ProjectProperty'
      | 'UserProperty'
      | 'WorklogProperty'
      | 'BoardProperty'
      | 'SprintProperty';
  };
};

export type MigrationResourceUpdateEntityPropertiesValuePutResponse = unknown;

export type MigrationResourceUpdateEntityPropertiesValuePutError = unknown;

export type MigrationResourceWorkflowRuleSearchPostData = {
  body: WorkflowRulesSearch;
  headers: {
    /**
     * The app migration transfer ID.
     */
    'Atlassian-Transfer-Id': string;
  };
};

export type MigrationResourceWorkflowRuleSearchPostResponse = WorkflowRulesSearchDetails;

export type MigrationResourceWorkflowRuleSearchPostError = unknown;

export type ServiceRegistryResourceServicesGetData = {
  query: {
    /**
     * The ID of the services (the strings starting with "b:" need to be decoded in Base64).
     */
    serviceIds: Array<string>;
  };
};

export type ServiceRegistryResourceServicesGetResponse = Array<ServiceRegistry>;

export type ServiceRegistryResourceServicesGetError = unknown;

export type DeleteForgeAppPropertyData = {
  path: {
    /**
     * The key of the property.
     */
    propertyKey: string;
  };
};

export type DeleteForgeAppPropertyResponse = any;

export type DeleteForgeAppPropertyError = OperationMessage | unknown;

export type PutForgeAppPropertyData = {
  body?: string;
  path: {
    /**
     * The key of the property.
     */
    propertyKey: string;
  };
};

export type PutForgeAppPropertyResponse = OperationMessage;

export type PutForgeAppPropertyError = OperationMessage | unknown;
