// Generated by ts-to-zod
import { z } from 'zod';

import { type multiple_filter_search_request } from './types.gen';

export const activityLogMetadataSchema = z
  .object({
    sign_in_method: z.string().optional().nullable(),
    external_id: z.string().optional().nullable(),
    away_mode: z.boolean().optional().nullable(),
    away_status_reason: z.string().optional().nullable(),
    reassign_conversations: z.boolean().optional().nullable(),
    source: z.string().optional().nullable(),
    auto_changed: z.string().optional().nullable(),
    update_by: z.number().optional().nullable(),
    update_by_name: z.string().optional().nullable(),
  })
  .nullable();

export const activityTypeSchema = z.union([
  z.literal('admin_assignment_limit_change'),
  z.literal('admin_away_mode_change'),
  z.literal('admin_deletion'),
  z.literal('admin_deprovisioned'),
  z.literal('admin_impersonation_end'),
  z.literal('admin_impersonation_start'),
  z.literal('admin_invite_change'),
  z.literal('admin_invite_creation'),
  z.literal('admin_invite_deletion'),
  z.literal('admin_login_failure'),
  z.literal('admin_login_success'),
  z.literal('admin_logout'),
  z.literal('admin_password_reset_request'),
  z.literal('admin_password_reset_success'),
  z.literal('admin_permission_change'),
  z.literal('admin_provisioned'),
  z.literal('admin_two_factor_auth_change'),
  z.literal('admin_unauthorized_sign_in_method'),
  z.literal('app_admin_join'),
  z.literal('app_authentication_method_change'),
  z.literal('app_data_deletion'),
  z.literal('app_data_export'),
  z.literal('app_google_sso_domain_change'),
  z.literal('app_identity_verification_change'),
  z.literal('app_name_change'),
  z.literal('app_outbound_address_change'),
  z.literal('app_package_installation'),
  z.literal('app_package_token_regeneration'),
  z.literal('app_package_uninstallation'),
  z.literal('app_team_creation'),
  z.literal('app_team_deletion'),
  z.literal('app_team_membership_modification'),
  z.literal('app_timezone_change'),
  z.literal('app_webhook_creation'),
  z.literal('app_webhook_deletion'),
  z.literal('articles_in_messenger_enabled_change'),
  z.literal('bulk_delete'),
  z.literal('bulk_export'),
  z.literal('campaign_deletion'),
  z.literal('campaign_state_change'),
  z.literal('conversation_part_deletion'),
  z.literal('conversation_topic_change'),
  z.literal('conversation_topic_creation'),
  z.literal('conversation_topic_deletion'),
  z.literal('help_center_settings_change'),
  z.literal('inbound_conversations_change'),
  z.literal('inbox_access_change'),
  z.literal('message_deletion'),
  z.literal('message_state_change'),
  z.literal('messenger_look_and_feel_change'),
  z.literal('messenger_search_required_change'),
  z.literal('messenger_spaces_change'),
  z.literal('office_hours_change'),
  z.literal('role_change'),
  z.literal('role_creation'),
  z.literal('role_deletion'),
  z.literal('ruleset_activation_title_preview'),
  z.literal('ruleset_creation'),
  z.literal('ruleset_deletion'),
  z.literal('search_browse_enabled_change'),
  z.literal('search_browse_required_change'),
  z.literal('seat_change'),
  z.literal('seat_revoke'),
  z.literal('security_settings_change'),
  z.literal('temporary_expectation_change'),
  z.literal('upfront_email_collection_change'),
  z.literal('welcome_message_change'),
]);

export const activityLogSchema = z
  .object({
    id: z.string().optional(),
    performed_by: z
      .object({
        type: z.string().optional(),
        id: z.string().optional(),
        email: z.string().optional(),
        ip: z.string().optional(),
      })
      .optional(),
    metadata: activityLogMetadataSchema.optional(),
    created_at: z.number().optional(),
    activity_type: z
      .union([
        z.literal('admin_assignment_limit_change'),
        z.literal('admin_away_mode_change'),
        z.literal('admin_deletion'),
        z.literal('admin_deprovisioned'),
        z.literal('admin_impersonation_end'),
        z.literal('admin_impersonation_start'),
        z.literal('admin_invite_change'),
        z.literal('admin_invite_creation'),
        z.literal('admin_invite_deletion'),
        z.literal('admin_login_failure'),
        z.literal('admin_login_success'),
        z.literal('admin_logout'),
        z.literal('admin_password_reset_request'),
        z.literal('admin_password_reset_success'),
        z.literal('admin_permission_change'),
        z.literal('admin_provisioned'),
        z.literal('admin_two_factor_auth_change'),
        z.literal('admin_unauthorized_sign_in_method'),
        z.literal('app_admin_join'),
        z.literal('app_authentication_method_change'),
        z.literal('app_data_deletion'),
        z.literal('app_data_export'),
        z.literal('app_google_sso_domain_change'),
        z.literal('app_identity_verification_change'),
        z.literal('app_name_change'),
        z.literal('app_outbound_address_change'),
        z.literal('app_package_installation'),
        z.literal('app_package_token_regeneration'),
        z.literal('app_package_uninstallation'),
        z.literal('app_team_creation'),
        z.literal('app_team_deletion'),
        z.literal('app_team_membership_modification'),
        z.literal('app_timezone_change'),
        z.literal('app_webhook_creation'),
        z.literal('app_webhook_deletion'),
        z.literal('articles_in_messenger_enabled_change'),
        z.literal('bulk_delete'),
        z.literal('bulk_export'),
        z.literal('campaign_deletion'),
        z.literal('campaign_state_change'),
        z.literal('conversation_part_deletion'),
        z.literal('conversation_topic_change'),
        z.literal('conversation_topic_creation'),
        z.literal('conversation_topic_deletion'),
        z.literal('help_center_settings_change'),
        z.literal('inbound_conversations_change'),
        z.literal('inbox_access_change'),
        z.literal('message_deletion'),
        z.literal('message_state_change'),
        z.literal('messenger_look_and_feel_change'),
        z.literal('messenger_search_required_change'),
        z.literal('messenger_spaces_change'),
        z.literal('office_hours_change'),
        z.literal('role_change'),
        z.literal('role_creation'),
        z.literal('role_deletion'),
        z.literal('ruleset_activation_title_preview'),
        z.literal('ruleset_creation'),
        z.literal('ruleset_deletion'),
        z.literal('search_browse_enabled_change'),
        z.literal('search_browse_required_change'),
        z.literal('seat_change'),
        z.literal('seat_revoke'),
        z.literal('security_settings_change'),
        z.literal('temporary_expectation_change'),
        z.literal('upfront_email_collection_change'),
        z.literal('welcome_message_change'),
      ])
      .optional(),
    activity_description: z.string().optional(),
  })
  .nullable();

export const addressableListSchema = z.object({
  type: z.string().optional(),
  id: z.string().optional(),
  url: z.string().optional(),
});

export const teamPriorityLevelSchema = z
  .object({
    primary_team_ids: z.array(z.number()).optional().nullable(),
    secondary_team_ids: z.array(z.number()).optional().nullable(),
  })
  .nullable();

export const adminSchema = z
  .object({
    type: z.string().optional(),
    id: z.string().optional(),
    name: z.string().optional(),
    email: z.string().optional(),
    job_title: z.string().optional(),
    away_mode_enabled: z.boolean().optional(),
    away_mode_reassign: z.boolean().optional(),
    has_inbox_seat: z.boolean().optional(),
    team_ids: z.array(z.number()).optional(),
    avatar: z.string().optional().nullable(),
    team_priority_level: teamPriorityLevelSchema.optional(),
  })
  .nullable();

export const adminPriorityLevelSchema = z
  .object({
    primary_admin_ids: z.array(z.number()).optional().nullable(),
    secondary_admin_ids: z.array(z.number()).optional().nullable(),
  })
  .nullable();

export const conversationAttachmentFilesSchema = z.object({
  content_type: z.string().optional(),
  data: z.string().optional(),
  name: z.string().optional(),
});

export const messageTypeSchema = z.union([z.literal('comment'), z.literal('note')]);

export const typeSchema = z.literal('admin');

export const appSchema = z
  .object({
    type: z.string().optional(),
    id_code: z.string().optional(),
    name: z.string().optional(),
    region: z.string().optional(),
    timezone: z.string().optional(),
    created_at: z.number().optional(),
    identity_verification: z.boolean().optional(),
  })
  .nullable();

export const articleStatisticsSchema = z
  .object({
    type: z.literal('article_statistics').optional(),
    views: z.number().optional(),
    conversions: z.number().optional(),
    reactions: z.number().optional(),
    happy_reaction_percentage: z.number().optional(),
    neutral_reaction_percentage: z.number().optional(),
    sad_reaction_percentage: z.number().optional(),
  })
  .nullable();

export const articleContentSchema = z
  .object({
    type: z.literal('article_content').optional().nullable(),
    title: z.string().optional(),
    description: z.string().optional(),
    body: z.string().optional(),
    author_id: z.number().optional(),
    state: z.union([z.literal('published'), z.literal('draft')]).optional(),
    created_at: z.number().optional(),
    updated_at: z.number().optional(),
    url: z.string().optional(),
  })
  .nullable();

export const type2Schema = z.literal('article_content');

export const stateSchema = z.union([z.literal('published'), z.literal('draft')]);

export const type3Schema = z.literal('list');

export const articleTranslatedContentSchema = z
  .object({
    type: z.literal('article_translated_content').optional().nullable(),
    ar: articleContentSchema.optional(),
    bg: articleContentSchema.optional(),
    bs: articleContentSchema.optional(),
    ca: articleContentSchema.optional(),
    cs: articleContentSchema.optional(),
    da: articleContentSchema.optional(),
    de: articleContentSchema.optional(),
    el: articleContentSchema.optional(),
    en: articleContentSchema.optional(),
    es: articleContentSchema.optional(),
    et: articleContentSchema.optional(),
    fi: articleContentSchema.optional(),
    fr: articleContentSchema.optional(),
    he: articleContentSchema.optional(),
    hr: articleContentSchema.optional(),
    hu: articleContentSchema.optional(),
    id: articleContentSchema.optional(),
    it: articleContentSchema.optional(),
    ja: articleContentSchema.optional(),
    ko: articleContentSchema.optional(),
    lt: articleContentSchema.optional(),
    lv: articleContentSchema.optional(),
    mn: articleContentSchema.optional(),
    nb: articleContentSchema.optional(),
    nl: articleContentSchema.optional(),
    pl: articleContentSchema.optional(),
    pt: articleContentSchema.optional(),
    ro: articleContentSchema.optional(),
    ru: articleContentSchema.optional(),
    sl: articleContentSchema.optional(),
    sr: articleContentSchema.optional(),
    sv: articleContentSchema.optional(),
    tr: articleContentSchema.optional(),
    vi: articleContentSchema.optional(),
    'pt-BR': articleContentSchema.optional(),
    'zh-CN': articleContentSchema.optional(),
    'zh-TW': articleContentSchema.optional(),
  })
  .nullable();

export const type4Schema = z.literal('article');

export const type5Schema = z.literal('article_statistics');

export const type6Schema = z.literal('article_translated_content');

export const assignConversationRequestSchema = z.object({
  message_type: z.literal('assignment'),
  type: z.union([z.literal('admin'), z.literal('team')]),
  admin_id: z.string(),
  assignee_id: z.string(),
  body: z.string().optional(),
});

export const messageType2Schema = z.literal('assignment');

export const type7Schema = z.union([z.literal('admin'), z.literal('team')]);

export const customerRequestSchema = z
  .union([
    z.object({
      intercom_user_id: z.string(),
    }),
    z.object({
      user_id: z.string(),
    }),
    z.object({
      email: z.string(),
    }),
  ])
  .nullable();

export const closeConversationRequestSchema = z.object({
  message_type: z.literal('close'),
  type: z.literal('admin'),
  admin_id: z.string(),
  body: z.string().optional(),
});

export const messageType3Schema = z.literal('close');

export const type8Schema = z.literal('collection');

export const segmentSchema = z.object({
  type: z.literal('segment').optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  created_at: z.number().optional(),
  updated_at: z.number().optional(),
  person_type: z.union([z.literal('contact'), z.literal('user')]).optional(),
  count: z.number().optional().nullable(),
});

export const type9Schema = z.literal('company');

export const companyAttachedSegmentsSchema = z.object({
  type: z.literal('list').optional(),
  data: z.array(segmentSchema).optional(),
});

export const companySchema = z.object({
  type: z.literal('company').optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  app_id: z.string().optional(),
  plan: z
    .object({
      type: z.string().optional(),
      id: z.string().optional(),
      name: z.string().optional(),
    })
    .optional(),
  company_id: z.string().optional(),
  remote_created_at: z.number().optional(),
  created_at: z.number().optional(),
  updated_at: z.number().optional(),
  last_request_at: z.number().optional(),
  size: z.number().optional(),
  website: z.string().optional(),
  industry: z.string().optional(),
  monthly_spend: z.number().optional(),
  session_count: z.number().optional(),
  user_count: z.number().optional(),
  custom_attributes: z.record(z.string()).optional(),
  tags: z
    .object({
      type: z.literal('tag.list').optional(),
      tags: z.array(z.unknown()).optional(),
    })
    .optional(),
  segments: z
    .object({
      type: z.literal('segment.list').optional(),
      segments: z.array(segmentSchema).optional(),
    })
    .optional(),
});

export const contactTagsSchema = z
  .object({
    data: z.array(addressableListSchema).optional(),
    url: z.string().optional(),
    total_count: z.number().optional(),
    has_more: z.boolean().optional(),
  })
  .nullable();

export const contactNotesSchema = z.object({
  data: z.array(addressableListSchema).optional(),
  url: z.string().optional(),
  total_count: z.number().optional(),
  has_more: z.boolean().optional(),
});

export const contactCompaniesSchema = z.object({
  url: z.string().optional(),
  total_count: z.number().optional(),
  has_more: z.boolean().optional(),
});

export const contactLocationSchema = z.object({
  type: z.string().optional().nullable(),
  country: z.string().optional().nullable(),
  region: z.string().optional().nullable(),
  city: z.string().optional().nullable(),
});

export const contactArchivedSchema = z.object({
  type: z.literal('contact').optional(),
  id: z.string().optional(),
  external_id: z.string().optional().nullable(),
  archived: z.boolean().optional(),
});

export const type10Schema = z.literal('contact');

export const pagesLinkSchema = z.object({
  type: z.literal('pages').optional(),
  page: z.number().optional(),
  next: z.string().optional().nullable(),
  per_page: z.number().optional(),
  total_pages: z.number().optional(),
});

export const contactDeletedSchema = z.object({
  type: z.literal('contact').optional(),
  id: z.string().optional(),
  external_id: z.string().optional().nullable(),
  deleted: z.boolean().optional(),
});

export const contactReferenceSchema = z.object({
  type: z.literal('contact').optional(),
  id: z.string().optional(),
  external_id: z.string().optional().nullable(),
});

export const contactReplyBaseRequestSchema = z.object({
  message_type: z.literal('comment'),
  type: z.literal('user'),
  body: z.string(),
  attachment_urls: z.array(z.string()).optional(),
});

export const messageType4Schema = z.literal('comment');

export const type11Schema = z.literal('user');

export const contactReplyIntercomUserIdRequestSchema = contactReplyBaseRequestSchema.and(
  z.object({
    intercom_user_id: z.string(),
    attachment_files: z.array(conversationAttachmentFilesSchema).optional(),
  }),
);

export const contactReplyEmailRequestSchema = contactReplyBaseRequestSchema.and(
  z.object({
    email: z.string(),
    attachment_files: z.array(conversationAttachmentFilesSchema).optional(),
  }),
);

export const contactReplyUserIdRequestSchema = contactReplyBaseRequestSchema.and(
  z.object({
    user_id: z.string(),
    attachment_files: z.array(conversationAttachmentFilesSchema).optional(),
  }),
);

export const contactReplyTicketEmailRequestSchema = contactReplyBaseRequestSchema.and(
  z.object({
    email: z.string(),
  }),
);

export const contactReplyTicketIntercomUserIdRequestSchema = contactReplyBaseRequestSchema.and(
  z.object({
    intercom_user_id: z.string(),
  }),
);

export const contactReplyTicketUserIdRequestSchema = contactReplyBaseRequestSchema.and(
  z.object({
    user_id: z.string(),
  }),
);

export const contactSegmentsSchema = z.object({
  type: z.literal('list').optional(),
  data: z.array(segmentSchema).optional(),
});

export const socialProfileSchema = z.object({
  type: z.string().optional(),
  name: z.string().optional(),
  url: z.string().optional(),
});

export const contactSubscriptionTypesSchema = z.object({
  data: z.array(addressableListSchema).optional(),
  url: z.string().optional(),
  total_count: z.number().optional(),
  has_more: z.boolean().optional(),
});

export const contactUnarchivedSchema = z.object({
  type: z.literal('contact').optional(),
  id: z.string().optional(),
  external_id: z.string().optional().nullable(),
  archived: z.boolean().optional(),
});

export const conversationContactsSchema = z.object({
  type: z.literal('contact.list').optional(),
  contacts: z.array(contactReferenceSchema).optional(),
});

export const conversationFirstContactReplySchema = z
  .object({
    created_at: z.number().optional(),
    type: z.string().optional(),
    url: z.string().optional().nullable(),
  })
  .nullable();

export const slaAppliedSchema = z
  .object({
    type: z.string().optional(),
    sla_name: z.string().optional(),
    sla_status: z
      .union([z.literal('hit'), z.literal('missed'), z.literal('cancelled'), z.literal('active')])
      .optional(),
  })
  .nullable();

export const conversationStatisticsSchema = z
  .object({
    type: z.string().optional(),
    time_to_assignment: z.number().optional(),
    time_to_admin_reply: z.number().optional(),
    time_to_first_close: z.number().optional(),
    time_to_last_close: z.number().optional(),
    median_time_to_reply: z.number().optional(),
    first_contact_reply_at: z.number().optional(),
    first_assignment_at: z.number().optional(),
    first_admin_reply_at: z.number().optional(),
    first_close_at: z.number().optional(),
    last_assignment_at: z.number().optional(),
    last_assignment_admin_reply_at: z.number().optional(),
    last_contact_reply_at: z.number().optional(),
    last_admin_reply_at: z.number().optional(),
    last_close_at: z.number().optional(),
    last_closed_by_id: z.string().optional(),
    count_reopens: z.number().optional(),
    count_assignments: z.number().optional(),
    count_conversation_parts: z.number().optional(),
  })
  .nullable();

export const state2Schema = z.union([z.literal('open'), z.literal('closed'), z.literal('snoozed')]);

export const prioritySchema = z.union([z.literal('priority'), z.literal('not_priority')]);

export const type12Schema = z.literal('contact.list');

export const type13Schema = z.literal('conversation.list');

export const referenceSchema = z.object({
  type: z.string().optional(),
  id: z.string().optional().nullable(),
});

export const conversationPartAuthorSchema = z.object({
  type: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  email: z.string().optional(),
});

export const partAttachmentSchema = z.object({
  type: z.string().optional(),
  name: z.string().optional(),
  url: z.string().optional(),
  content_type: z.string().optional(),
  filesize: z.number().optional(),
  width: z.number().optional(),
  height: z.number().optional(),
});

export const conversationPartSchema = z.object({
  type: z.string().optional(),
  id: z.string().optional(),
  part_type: z.string().optional(),
  body: z.string().optional().nullable(),
  created_at: z.number().optional(),
  updated_at: z.number().optional(),
  notified_at: z.number().optional(),
  assigned_to: referenceSchema.optional().nullable(),
  author: conversationPartAuthorSchema.optional(),
  attachments: z.array(partAttachmentSchema).optional(),
  external_id: z.string().optional().nullable(),
  redacted: z.boolean().optional(),
});

export const type14Schema = z.literal('conversation_part.list');

export const conversationRatingSchema = z
  .object({
    rating: z.number().optional(),
    remark: z.string().optional(),
    created_at: z.number().optional(),
    contact: contactReferenceSchema.optional(),
    teammate: referenceSchema.optional(),
  })
  .nullable();

export const conversationSourceSchema = z.object({
  type: z.string().optional(),
  id: z.string().optional(),
  delivered_as: z.string().optional(),
  subject: z.string().optional(),
  body: z.string().optional(),
  author: conversationPartAuthorSchema.optional(),
  attachments: z.array(partAttachmentSchema).optional(),
  url: z.string().optional().nullable(),
  redacted: z.boolean().optional(),
});

export const conversationTeammatesSchema = z
  .object({
    type: z.string().optional(),
    teammates: z.array(referenceSchema).optional(),
  })
  .nullable();

export const convertVisitorRequestSchema = z.object({
  type: z.string(),
  user: z.object({
    id: z.string().optional(),
    user_id: z.string().optional(),
    email: z.string().optional(),
  }),
  visitor: z.object({
    id: z.string().optional(),
    user_id: z.string().optional(),
    email: z.string().optional(),
  }),
});

export const createArticleRequestSchema = z
  .object({
    title: z.string(),
    description: z.string().optional(),
    body: z.string().optional(),
    author_id: z.number(),
    state: z.union([z.literal('published'), z.literal('draft')]).optional(),
    parent_id: z.number().optional(),
    parent_type: z.string().optional(),
    translated_content: articleTranslatedContentSchema.optional(),
  })
  .nullable();

export const createContactRequestSchema = z.object({
  role: z.string().optional(),
  external_id: z.string().optional(),
  email: z.string().optional(),
  phone: z.string().optional().nullable(),
  name: z.string().optional().nullable(),
  avatar: z.string().optional().nullable(),
  signed_up_at: z.number().optional().nullable(),
  last_seen_at: z.number().optional().nullable(),
  owner_id: z.number().optional().nullable(),
  unsubscribed_from_emails: z.boolean().optional().nullable(),
  custom_attributes: z.record(z.unknown()).optional().nullable(),
});

export const createConversationRequestSchema = z.object({
  from: z.object({
    type: z.union([z.literal('lead'), z.literal('user'), z.literal('contact')]),
    id: z.string(),
  }),
  body: z.string(),
});

export const type15Schema = z.union([z.literal('lead'), z.literal('user'), z.literal('contact')]);

export const createDataAttributeRequestSchema = z.object({
  name: z.string(),
  model: z.union([z.literal('contact'), z.literal('company')]),
  data_type: z.union([
    z.literal('string'),
    z.literal('integer'),
    z.literal('float'),
    z.literal('boolean'),
    z.literal('datetime'),
    z.literal('date'),
  ]),
  description: z.string().optional(),
  options: z.array(z.string()).optional(),
  messenger_writable: z.boolean().optional(),
});

export const modelSchema = z.union([z.literal('contact'), z.literal('company')]);

export const dataTypeSchema = z.union([
  z.literal('string'),
  z.literal('integer'),
  z.literal('float'),
  z.literal('boolean'),
  z.literal('datetime'),
  z.literal('date'),
]);

export const createDataEventRequestSchema = z.object({
  event_name: z.string().optional(),
  created_at: z.number().optional(),
  user_id: z.string().optional(),
  id: z.string().optional(),
  email: z.string().optional(),
  metadata: z.record(z.string()).optional(),
});

export const createDataEventSummariesRequestSchema = z.object({
  user_id: z.string().optional(),
  event_summaries: z
    .object({
      event_name: z.string().optional(),
      count: z.number().optional(),
      first: z.number().optional(),
      last: z.number().optional(),
    })
    .optional(),
});

export const createDataExportsRequestSchema = z.object({
  created_at_after: z.number(),
  created_at_before: z.number(),
});

export const createMessageRequestSchema = z
  .object({
    message_type: z.union([z.literal('in_app'), z.literal('email')]).optional(),
    subject: z.string().optional(),
    body: z.string().optional(),
    template: z.string().optional(),
    from: z
      .object({
        type: z.literal('admin'),
        id: z.number(),
      })
      .optional(),
    to: z
      .object({
        type: z.union([z.literal('user'), z.literal('lead')]),
        id: z.string(),
      })
      .optional(),
    create_conversation_without_contact_reply: z.boolean().optional(),
  })
  .nullable();

export const messageType5Schema = z.union([z.literal('in_app'), z.literal('email')]);

export const createOrUpdateCompanyRequestSchema = z
  .object({
    name: z.string().optional(),
    company_id: z.string().optional(),
    plan: z.string().optional(),
    size: z.number().optional(),
    website: z.string().optional(),
    industry: z.string().optional(),
    custom_attributes: z.record(z.string()).optional(),
    remote_created_at: z.number().optional(),
    monthly_spend: z.number().optional(),
  })
  .nullable();

export const createOrUpdateTagRequestSchema = z.object({
  name: z.string(),
  id: z.string().optional(),
});

export const createTicketReplyRequestSchema = z.object({
  body: z.string(),
  message_type: z.string().optional(),
  admin_id: z.string(),
});

export const ticketRequestCustomAttributesSchema = z.record(
  z.union([z.string(), z.number(), z.boolean(), z.array(z.unknown())]).nullable(),
);

export const createTicketTypeAttributeRequestSchema = z.object({
  name: z.string(),
  description: z.string(),
  data_type: z.union([
    z.literal('string'),
    z.literal('list'),
    z.literal('integer'),
    z.literal('decimal'),
    z.literal('boolean'),
    z.literal('datetime'),
    z.literal('files'),
  ]),
  required_to_create: z.boolean().optional(),
  required_to_create_for_contacts: z.boolean().optional(),
  visible_on_create: z.boolean().optional(),
  visible_to_contacts: z.boolean().optional(),
  multiline: z.boolean().optional(),
  list_items: z.string().optional(),
  allow_multiple_values: z.boolean().optional(),
});

export const dataType2Schema = z.union([
  z.literal('string'),
  z.literal('list'),
  z.literal('integer'),
  z.literal('decimal'),
  z.literal('boolean'),
  z.literal('datetime'),
  z.literal('files'),
]);

export const createTicketTypeRequestSchema = z
  .object({
    name: z.string(),
    description: z.string().optional(),
    icon: z.string().optional(),
    is_internal: z.boolean().optional(),
  })
  .nullable();

export const startingAfterPagingSchema = z
  .object({
    per_page: z.number().optional(),
    starting_after: z.string().optional().nullable(),
  })
  .nullable();

export const type16Schema = z.literal('pages');

export const customObjectInstanceSchema = z
  .object({
    id: z.string().optional(),
    external_id: z.string().optional(),
    type: z.string().optional(),
    custom_attributes: z.record(z.string()).optional(),
  })
  .nullable();

export const dataAttributeSchema = z.object({
  type: z.literal('data_attribute').optional(),
  id: z.number().optional(),
  model: z.union([z.literal('contact'), z.literal('company')]).optional(),
  name: z.string().optional(),
  full_name: z.string().optional(),
  label: z.string().optional(),
  description: z.string().optional(),
  data_type: z
    .union([z.literal('string'), z.literal('integer'), z.literal('float'), z.literal('boolean'), z.literal('date')])
    .optional(),
  options: z.array(z.string()).optional(),
  api_writable: z.boolean().optional(),
  messenger_writable: z.boolean().optional(),
  ui_writable: z.boolean().optional(),
  custom: z.boolean().optional(),
  archived: z.boolean().optional(),
  created_at: z.number().optional(),
  updated_at: z.number().optional(),
  admin_id: z.string().optional(),
});

export const type17Schema = z.literal('data_attribute');

export const dataType3Schema = z.union([
  z.literal('string'),
  z.literal('integer'),
  z.literal('float'),
  z.literal('boolean'),
  z.literal('date'),
]);

export const dataAttributeListSchema = z.object({
  type: z.literal('list').optional(),
  data: z.array(dataAttributeSchema).optional(),
});

export const dataEventSchema = z.object({
  type: z.literal('event').optional(),
  event_name: z.string(),
  created_at: z.number(),
  user_id: z.string().optional(),
  id: z.string().optional(),
  intercom_user_id: z.string().optional(),
  email: z.string().optional(),
  metadata: z.record(z.string()).optional(),
});

export const type18Schema = z.literal('event');

export const dataEventListSchema = z.object({
  type: z.literal('event.list').optional(),
  events: z.array(dataEventSchema).optional(),
  pages: z
    .object({
      next: z.string().optional(),
      since: z.string().optional(),
    })
    .optional(),
});

export const type19Schema = z.literal('event.list');

export const dataEventSummaryItemSchema = z
  .object({
    name: z.string().optional(),
    first: z.string().optional(),
    last: z.string().optional(),
    count: z.number().optional(),
    description: z.string().optional(),
  })
  .nullable();

export const type20Schema = z.literal('event.summary');

export const dataExportSchema = z.object({
  job_identfier: z.string().optional(),
  status: z
    .union([
      z.literal('pending'),
      z.literal('in_progress'),
      z.literal('failed'),
      z.literal('completed'),
      z.literal('no_data'),
      z.literal('canceled'),
    ])
    .optional(),
  download_expires_at: z.string().optional(),
  download_url: z.string().optional(),
});

export const statusSchema = z.union([
  z.literal('pending'),
  z.literal('in_progress'),
  z.literal('failed'),
  z.literal('completed'),
  z.literal('no_data'),
  z.literal('canceled'),
]);

export const dataExportCsvSchema = z.object({
  user_id: z.string().optional(),
  user_external_id: z.string().optional(),
  company_id: z.string().optional(),
  email: z.string().optional(),
  name: z.string().optional(),
  ruleset_id: z.string().optional(),
  content_id: z.string().optional(),
  content_type: z.string().optional(),
  content_title: z.string().optional(),
  ruleset_version_id: z.string().optional(),
  receipt_id: z.string().optional(),
  received_at: z.number().optional(),
  series_id: z.string().optional(),
  series_title: z.string().optional(),
  node_id: z.string().optional(),
  first_reply: z.number().optional(),
  first_completion: z.number().optional(),
  first_series_completion: z.number().optional(),
  first_series_disengagement: z.number().optional(),
  first_series_exit: z.number().optional(),
  first_goal_success: z.number().optional(),
  first_open: z.number().optional(),
  first_click: z.number().optional(),
  first_dismisall: z.number().optional(),
  first_unsubscribe: z.number().optional(),
  first_hard_bounce: z.number().optional(),
});

export const deletedArticleObjectSchema = z.object({
  id: z.string().optional(),
  object: z.literal('article').optional(),
  deleted: z.boolean().optional(),
});

export const intercomObjectSchema = z.literal('article');

export const deletedCollectionObjectSchema = z.object({
  id: z.string().optional(),
  object: z.literal('collection').optional(),
  deleted: z.boolean().optional(),
});

export const object2Schema = z.literal('collection');

export const deletedCompanyObjectSchema = z.object({
  id: z.string().optional(),
  object: z.literal('company').optional(),
  deleted: z.boolean().optional(),
});

export const object3Schema = z.literal('company');

export const deletedObjectSchema = z.object({
  id: z.string().optional(),
  object: z.literal('news-item').optional(),
  deleted: z.boolean().optional(),
});

export const object4Schema = z.literal('news-item');

export const deletedSectionObjectSchema = z.object({
  id: z.string().optional(),
  object: z.literal('section').optional(),
  deleted: z.boolean().optional(),
});

export const object5Schema = z.literal('section');

export const detachContactFromConversationRequestSchema = z.object({
  admin_id: z.string(),
});

export const errorSchema = z.object({
  type: z.string(),
  request_id: z.string().optional().nullable(),
  errors: z.array(
    z.object({
      code: z.string(),
      message: z.string().optional().nullable(),
      field: z.string().optional().nullable(),
    }),
  ),
});

export const fileAttributeSchema = z.object({
  type: z.string().optional(),
  name: z.string().optional(),
  url: z.string().optional(),
  content_type: z.string().optional(),
  filesize: z.number().optional(),
  width: z.number().optional(),
  height: z.number().optional(),
});

export const groupContentSchema = z
  .object({
    type: z.literal('group_content').optional().nullable(),
    name: z.string().optional(),
    description: z.string().optional(),
  })
  .nullable();

export const type21Schema = z.literal('group_content');

export const groupTranslatedContentSchema = z
  .object({
    type: z.literal('group_translated_content').optional().nullable(),
    ar: groupContentSchema.optional(),
    bg: groupContentSchema.optional(),
    bs: groupContentSchema.optional(),
    ca: groupContentSchema.optional(),
    cs: groupContentSchema.optional(),
    da: groupContentSchema.optional(),
    de: groupContentSchema.optional(),
    el: groupContentSchema.optional(),
    en: groupContentSchema.optional(),
    es: groupContentSchema.optional(),
    et: groupContentSchema.optional(),
    fi: groupContentSchema.optional(),
    fr: groupContentSchema.optional(),
    he: groupContentSchema.optional(),
    hr: groupContentSchema.optional(),
    hu: groupContentSchema.optional(),
    id: groupContentSchema.optional(),
    it: groupContentSchema.optional(),
    ja: groupContentSchema.optional(),
    ko: groupContentSchema.optional(),
    lt: groupContentSchema.optional(),
    lv: groupContentSchema.optional(),
    mn: groupContentSchema.optional(),
    nb: groupContentSchema.optional(),
    nl: groupContentSchema.optional(),
    pl: groupContentSchema.optional(),
    pt: groupContentSchema.optional(),
    ro: groupContentSchema.optional(),
    ru: groupContentSchema.optional(),
    sl: groupContentSchema.optional(),
    sr: groupContentSchema.optional(),
    sv: groupContentSchema.optional(),
    tr: groupContentSchema.optional(),
    vi: groupContentSchema.optional(),
    'pt-BR': groupContentSchema.optional(),
    'zh-CN': groupContentSchema.optional(),
    'zh-TW': groupContentSchema.optional(),
  })
  .nullable();

export const type22Schema = z.literal('group_translated_content');

export const helpCenterSchema = z.object({
  id: z.string().optional(),
  workspace_id: z.string().optional(),
  created_at: z.number().optional(),
  updated_at: z.number().optional(),
  identifier: z.string().optional(),
  website_turned_on: z.boolean().optional(),
  display_name: z.string().optional(),
});

export const helpCenterListSchema = z.object({
  type: z.literal('list').optional(),
  data: z.array(helpCenterSchema).optional(),
});

export const intercomVersionSchema = z.union([
  z.literal('1.0'),
  z.literal('1.1'),
  z.literal('1.2'),
  z.literal('1.3'),
  z.literal('1.4'),
  z.literal('2.0'),
  z.literal('2.1'),
  z.literal('2.2'),
  z.literal('2.3'),
  z.literal('2.4'),
  z.literal('2.5'),
  z.literal('2.6'),
  z.literal('2.7'),
  z.literal('2.8'),
  z.literal('2.9'),
  z.literal('2.10'),
  z.literal('2.11'),
  z.literal('Unstable'),
]);

export const mergeContactsRequestSchema = z.object({
  from: z.string().optional(),
  into: z.string().optional(),
});

export const messageSchema = z.object({
  type: z.string(),
  id: z.string(),
  created_at: z.number(),
  subject: z.string().optional(),
  body: z.string(),
  message_type: z.union([z.literal('email'), z.literal('inapp'), z.literal('facebook'), z.literal('twitter')]),
  conversation_id: z.string().optional(),
});

export const messageType6Schema = z.union([
  z.literal('email'),
  z.literal('inapp'),
  z.literal('facebook'),
  z.literal('twitter'),
]);

export const singleFilterSearchRequestSchema = z.object({
  field: z.string().optional(),
  operator: z
    .union([
      z.literal('='),
      z.literal('!='),
      z.literal('IN'),
      z.literal('NIN'),
      z.literal('<'),
      z.literal('>'),
      z.literal('~'),
      z.literal('!~'),
      z.literal('^'),
      z.literal('$'),
    ])
    .optional(),
  value: z.string().optional(),
});

export const operatorSchema = z.union([z.literal('AND'), z.literal('OR')]);

export const newsfeedAssignmentSchema = z.object({
  newsfeed_id: z.number().optional(),
  published_at: z.number().optional(),
});

export const type23Schema = z.literal('news-item');

export const state3Schema = z.union([z.literal('draft'), z.literal('live')]);

export const newsItemRequestSchema = z.object({
  title: z.string(),
  body: z.string().optional(),
  sender_id: z.number(),
  state: z.union([z.literal('draft'), z.literal('live')]).optional(),
  deliver_silently: z.boolean().optional(),
  labels: z.array(z.string()).optional(),
  reactions: z.array(z.string().nullable()).optional(),
  newsfeed_assignments: z.array(newsfeedAssignmentSchema).optional(),
});

export const newsfeedSchema = z.object({
  id: z.string().optional(),
  type: z.literal('newsfeed').optional(),
  name: z.string().optional(),
  created_at: z.number().optional(),
  updated_at: z.number().optional(),
});

export const type24Schema = z.literal('newsfeed');

export const noteSchema = z.object({
  type: z.string().optional(),
  id: z.string().optional(),
  created_at: z.number().optional(),
  contact: z
    .object({
      type: z.string().optional(),
      id: z.string().optional(),
    })
    .optional()
    .nullable(),
  author: adminSchema.optional(),
  body: z.string().optional(),
});

export const cursorPagesSchema = z
  .object({
    type: z.literal('pages').optional(),
    page: z.number().optional(),
    next: startingAfterPagingSchema.optional(),
    per_page: z.number().optional(),
    total_pages: z.number().optional(),
  })
  .nullable();

export const openConversationRequestSchema = z.object({
  message_type: z.literal('open'),
  admin_id: z.string(),
});

export const messageType7Schema = z.literal('open');

export const newsItemSchema = z.object({
  type: z.literal('news-item').optional(),
  id: z.string().optional(),
  workspace_id: z.string().optional(),
  title: z.string().optional(),
  body: z.string().optional(),
  sender_id: z.number().optional(),
  state: z.union([z.literal('draft'), z.literal('live')]).optional(),
  newsfeed_assignments: z.array(newsfeedAssignmentSchema).optional(),
  labels: z.array(z.string().nullable()).optional(),
  cover_image_url: z.string().optional().nullable(),
  reactions: z.array(z.string().nullable()).optional(),
  deliver_silently: z.boolean().optional(),
  created_at: z.number().optional(),
  updated_at: z.number().optional(),
});

export const type25Schema = z.union([z.literal('list'), z.literal('conversation.list')]);

export const phoneSwitchSchema = z
  .object({
    type: z.literal('phone_call_redirect').optional(),
    phone: z.string().optional(),
  })
  .nullable();

export const type26Schema = z.literal('phone_call_redirect');

export const redactConversationRequestSchema = z.union([
  z.object({
    type: z.literal('conversation_part'),
    conversation_id: z.string(),
    conversation_part_id: z.string(),
  }),
  z.object({
    type: z.literal('source'),
    conversation_id: z.string(),
    source_id: z.string(),
  }),
]);

export const type27Schema = z.literal('conversation_part');

export const contactReplyConversationRequestSchema = z.union([
  contactReplyIntercomUserIdRequestSchema,
  contactReplyEmailRequestSchema,
  contactReplyUserIdRequestSchema,
]);

export const adminReplyConversationRequestSchema = z.object({
  message_type: z.union([z.literal('comment'), z.literal('note')]),
  type: z.literal('admin'),
  body: z.string().optional(),
  admin_id: z.string(),
  created_at: z.number().optional(),
  attachment_urls: z.array(z.string()).optional(),
  attachment_files: z.array(conversationAttachmentFilesSchema).optional(),
});

export const multipleFilterSearchRequestSchema: z.ZodSchema<multiple_filter_search_request> = z.lazy(() =>
  z.object({
    operator: z.union([z.literal('AND'), z.literal('OR')]).optional(),
    value: z.union([z.array(multipleFilterSearchRequestSchema), z.array(singleFilterSearchRequestSchema)]).optional(),
  }),
);

export const sectionSchema = z.object({
  type: z.literal('section').optional(),
  id: z.string().optional(),
  workspace_id: z.string().optional(),
  name: z.string().optional(),
  created_at: z.number().optional(),
  updated_at: z.number().optional(),
  url: z.string().optional().nullable(),
  icon: z.string().optional().nullable(),
  order: z.number().optional(),
  parent_id: z.union([z.number(), z.string()]).optional(),
  default_locale: z.string().optional(),
  translated_content: groupTranslatedContentSchema.optional().nullable(),
});

export const type28Schema = z.literal('section');

export const sectionListSchema = z.object({
  type: z.literal('list').optional(),
  pages: cursorPagesSchema.optional(),
  total_count: z.number().optional(),
  data: z.array(sectionSchema).optional(),
});

export const type29Schema = z.literal('segment');

export const personTypeSchema = z.union([z.literal('contact'), z.literal('user')]);

export const segmentListSchema = z.object({
  type: z.literal('segment.list').optional(),
  segments: z.array(segmentSchema).optional(),
  pages: z.record(z.unknown()).optional(),
});

export const type30Schema = z.literal('segment.list');

export const operator2Schema = z.union([
  z.literal('='),
  z.literal('!='),
  z.literal('IN'),
  z.literal('NIN'),
  z.literal('<'),
  z.literal('>'),
  z.literal('~'),
  z.literal('!~'),
  z.literal('^'),
  z.literal('$'),
]);

export const slaStatusSchema = z.union([
  z.literal('hit'),
  z.literal('missed'),
  z.literal('cancelled'),
  z.literal('active'),
]);

export const snoozeConversationRequestSchema = z.object({
  message_type: z.literal('snoozed'),
  admin_id: z.string(),
  snoozed_until: z.number(),
});

export const messageType8Schema = z.literal('snoozed');

export const translationSchema = z.object({
  name: z.string().optional(),
  description: z.string().optional(),
  locale: z.string().optional(),
});

export const state4Schema = z.union([z.literal('live'), z.literal('draft'), z.literal('archived')]);

export const consentTypeSchema = z.union([z.literal('opt_out'), z.literal('opt_in')]);

export const subscriptionTypeSchema = z.object({
  type: z.string().optional(),
  id: z.string().optional(),
  state: z.union([z.literal('live'), z.literal('draft'), z.literal('archived')]).optional(),
  default_translation: translationSchema.optional(),
  translations: z.array(translationSchema).optional(),
  consent_type: z.union([z.literal('opt_out'), z.literal('opt_in')]).optional(),
  content_types: z.array(z.union([z.literal('email'), z.literal('sms_message')])).optional(),
});

export const tagSchema = z.object({
  type: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  applied_at: z.number().optional(),
  applied_by: referenceSchema.optional(),
});

export const tagCompanyRequestSchema = z.object({
  name: z.string(),
  companies: z.array(
    z.object({
      id: z.string().optional(),
      company_id: z.string().optional(),
    }),
  ),
});

export const tagListSchema = z.object({
  type: z.literal('list').optional(),
  data: z.array(tagSchema).optional(),
});

export const tagMultipleUsersRequestSchema = z.object({
  name: z.string(),
  users: z.array(
    z.object({
      id: z.string().optional(),
    }),
  ),
});

export const tagsSchema = z.object({
  type: z.literal('tag.list').optional(),
  tags: z.array(tagSchema).optional(),
});

export const type31Schema = z.literal('tag.list');

export const teamSchema = z.object({
  type: z.string().optional(),
  id: z.string().optional(),
  name: z.string().optional(),
  admin_ids: z.array(z.number()).optional(),
  admin_priority_level: adminPriorityLevelSchema.optional(),
});

export const teamListSchema = z.object({
  type: z.literal('team.list').optional(),
  teams: z.array(teamSchema).optional(),
});

export const type32Schema = z.literal('team.list');

export const ticketCustomAttributesSchema = z.record(
  z.union([z.string(), z.number(), z.boolean(), z.array(z.unknown()), fileAttributeSchema]).nullable(),
);

export const ticketContactsSchema = z.object({
  type: z.literal('contact.list').optional(),
  contacts: z.array(contactReferenceSchema).optional(),
});

export const type33Schema = z.literal('ticket');

export const ticketStateSchema = z.union([
  z.literal('submitted'),
  z.literal('in_progress'),
  z.literal('waiting_on_customer'),
  z.literal('resolved'),
]);

export const ticketPartAuthorSchema = z.object({
  type: z.union([z.literal('admin'), z.literal('bot'), z.literal('team')]).optional(),
  id: z.string().optional(),
  name: z.string().optional().nullable(),
  email: z.string().optional(),
});

export const type34Schema = z.literal('ticket_part');

export const partTypeSchema = z.literal('note');

export const ticketPartSchema = z.object({
  type: z.string().optional(),
  id: z.string().optional(),
  part_type: z.string().optional(),
  body: z.string().optional().nullable(),
  previous_ticket_state: z
    .union([z.literal('submitted'), z.literal('in_progress'), z.literal('waiting_on_customer'), z.literal('resolved')])
    .optional(),
  ticket_state: z
    .union([z.literal('submitted'), z.literal('in_progress'), z.literal('waiting_on_customer'), z.literal('resolved')])
    .optional(),
  created_at: z.number().optional(),
  updated_at: z.number().optional(),
  assigned_to: referenceSchema.optional().nullable(),
  author: ticketPartAuthorSchema.optional(),
  attachments: z.array(partAttachmentSchema).optional(),
  external_id: z.string().optional().nullable(),
  redacted: z.boolean().optional(),
});

export const previousTicketStateSchema = z.union([
  z.literal('submitted'),
  z.literal('in_progress'),
  z.literal('waiting_on_customer'),
  z.literal('resolved'),
]);

export const type35Schema = z.union([z.literal('admin'), z.literal('bot'), z.literal('team')]);

export const ticketPartsSchema = z.object({
  type: z.literal('ticket_part.list').optional(),
  ticket_parts: z.array(ticketPartSchema).optional(),
  total_count: z.number().optional(),
});

export const type36Schema = z.literal('ticket_part.list');

export const ticketTypeAttributeSchema = z
  .object({
    type: z.string().optional(),
    id: z.string().optional(),
    workspace_id: z.string().optional(),
    name: z.string().optional(),
    description: z.string().optional(),
    data_type: z.string().optional(),
    input_options: z.record(z.unknown()).optional(),
    order: z.number().optional(),
    required_to_create: z.boolean().optional(),
    required_to_create_for_contacts: z.boolean().optional(),
    visible_on_create: z.boolean().optional(),
    visible_to_contacts: z.boolean().optional(),
    default: z.boolean().optional(),
    ticket_type_id: z.number().optional(),
    archived: z.boolean().optional(),
    created_at: z.number().optional(),
    updated_at: z.number().optional(),
  })
  .nullable();

export const ticketTypeAttributeListSchema = z.object({
  type: z.string().optional(),
  ticket_type_attributes: z.array(ticketTypeAttributeSchema).optional(),
});

export const ticketTypeSchema = z
  .object({
    type: z.string().optional(),
    id: z.string().optional(),
    name: z.string().optional(),
    description: z.string().optional(),
    icon: z.string().optional(),
    workspace_id: z.string().optional(),
    ticket_type_attributes: ticketTypeAttributeListSchema.optional(),
    archived: z.boolean().optional(),
    created_at: z.number().optional(),
    updated_at: z.number().optional(),
  })
  .nullable();

export const untagCompanyRequestSchema = z.object({
  name: z.string(),
  companies: z.array(
    z.object({
      id: z.string().optional(),
      company_id: z.string().optional(),
      untag: z.boolean().optional(),
    }),
  ),
});

export const updateArticleRequestSchema = z
  .object({
    title: z.string().optional(),
    description: z.string().optional(),
    body: z.string().optional(),
    author_id: z.number().optional(),
    state: z.union([z.literal('published'), z.literal('draft')]).optional(),
    parent_id: z.string().optional(),
    parent_type: z.string().optional(),
    translated_content: articleTranslatedContentSchema.optional(),
  })
  .nullable();

export const updateCollectionRequestSchema = z.object({
  name: z.string().optional(),
  description: z.string().optional(),
  translated_content: groupTranslatedContentSchema.optional().nullable(),
});

export const updateContactRequestSchema = z.object({
  role: z.string().optional(),
  external_id: z.string().optional(),
  email: z.string().optional(),
  phone: z.string().optional().nullable(),
  name: z.string().optional().nullable(),
  avatar: z.string().optional().nullable(),
  signed_up_at: z.number().optional().nullable(),
  last_seen_at: z.number().optional().nullable(),
  owner_id: z.number().optional().nullable(),
  unsubscribed_from_emails: z.boolean().optional().nullable(),
  custom_attributes: z.record(z.unknown()).optional().nullable(),
});

export const customAttributesSchema = z.record(z.union([z.string(), customObjectInstanceSchema]));

export const updateDataAttributeRequestSchema = z.object({
  archived: z.boolean().optional(),
  description: z.string().optional(),
  options: z.array(z.string()).optional(),
  messenger_writable: z.boolean().optional(),
});

export const updateSectionRequestSchema = z.object({
  name: z.string().optional(),
  parent_id: z.number().optional(),
  translated_content: groupTranslatedContentSchema.optional().nullable(),
});

export const updateTicketRequestSchema = z.object({
  ticket_attributes: z.record(z.unknown()).optional(),
  state: z.union([z.literal('in_progress'), z.literal('waiting_on_customer'), z.literal('resolved')]).optional(),
  is_shared: z.boolean().optional(),
  assignment: z
    .object({
      admin_id: z.string().optional(),
      assignee_id: z.string().optional(),
    })
    .optional(),
});

export const state5Schema = z.union([
  z.literal('in_progress'),
  z.literal('waiting_on_customer'),
  z.literal('resolved'),
]);

export const updateTicketTypeAttributeRequestSchema = z.object({
  name: z.string().optional(),
  description: z.string().optional(),
  required_to_create: z.boolean().optional(),
  required_to_create_for_contacts: z.boolean().optional(),
  visible_on_create: z.boolean().optional(),
  visible_to_contacts: z.boolean().optional(),
  multiline: z.boolean().optional(),
  list_items: z.string().optional(),
  allow_multiple_values: z.boolean().optional(),
  archived: z.boolean().optional(),
});

export const updateTicketTypeRequestSchema = z
  .object({
    name: z.string().optional(),
    description: z.string().optional(),
    icon: z.string().optional(),
    archived: z.boolean().optional(),
    is_internal: z.boolean().optional(),
  })
  .nullable();

export const updateVisitorRequestSchema = z.object({
  id: z.string().optional(),
  user_id: z.string().optional(),
  name: z.string().optional(),
  custom_attributes: z.record(z.string()).optional(),
});

export const visitorSchema = z
  .object({
    type: z.string().optional(),
    id: z.string().optional(),
    user_id: z.string().optional(),
    anonymous: z.boolean().optional(),
    email: z.string().optional(),
    phone: z.string().optional().nullable(),
    name: z.string().optional().nullable(),
    pseudonym: z.string().optional().nullable(),
    avatar: z
      .object({
        type: z.string().optional(),
        image_url: z.string().optional().nullable(),
      })
      .optional(),
    app_id: z.string().optional(),
    companies: z
      .object({
        type: z.literal('company.list').optional(),
        companies: z.array(companySchema).optional(),
      })
      .optional(),
    location_data: z
      .object({
        type: z.string().optional(),
        city_name: z.string().optional(),
        continent_code: z.string().optional(),
        country_code: z.string().optional(),
        country_name: z.string().optional(),
        postal_code: z.string().optional(),
        region_name: z.string().optional(),
        timezone: z.string().optional(),
      })
      .optional(),
    las_request_at: z.number().optional(),
    created_at: z.number().optional(),
    remote_created_at: z.number().optional(),
    signed_up_at: z.number().optional(),
    updated_at: z.number().optional(),
    session_count: z.number().optional(),
    social_profiles: z
      .object({
        type: z.literal('social_profile.list').optional(),
        social_profiles: z.array(z.string()).optional(),
      })
      .optional(),
    owner_id: z.string().optional().nullable(),
    unsubscribed_from_emails: z.boolean().optional(),
    marked_email_as_spam: z.boolean().optional(),
    has_hard_bounced: z.boolean().optional(),
    tags: z
      .object({
        type: z.literal('tag.list').optional(),
        tags: z
          .array(
            z.object({
              type: z.literal('tag').optional(),
              id: z.string().optional(),
              name: z.string().optional(),
            }),
          )
          .optional(),
      })
      .optional(),
    segments: z
      .object({
        type: z.literal('segment.list').optional(),
        segments: z.array(z.string()).optional(),
      })
      .optional(),
    custom_attributes: z.record(z.string()).optional(),
    referrer: z.string().optional().nullable(),
    utm_campaign: z.string().optional().nullable(),
    utm_content: z.string().optional().nullable(),
    utm_medium: z.string().optional().nullable(),
    utm_source: z.string().optional().nullable(),
    utm_term: z.string().optional().nullable(),
    do_not_track: z.boolean().optional().nullable(),
  })
  .nullable();

export const type37Schema = z.literal('company.list');

export const visitorDeletedObjectSchema = z.object({
  id: z.string().optional(),
  type: z.literal('visitor').optional(),
  user_id: z.string().optional(),
});

export const type38Schema = z.literal('visitor');

export const identifyAdminDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const adminWithAppSchema = z
  .object({
    type: z.string().optional(),
    id: z.string().optional(),
    name: z.string().optional(),
    email: z.string().optional(),
    job_title: z.string().optional(),
    away_mode_enabled: z.boolean().optional(),
    away_mode_reassign: z.boolean().optional(),
    has_inbox_seat: z.boolean().optional(),
    team_ids: z.array(z.number()).optional(),
    avatar: z
      .object({
        type: z.string().optional(),
        image_url: z.string().optional().nullable(),
      })
      .optional(),
    email_verified: z.boolean().optional().nullable(),
    app: appSchema.optional().nullable(),
  })
  .nullable();

export const identifyAdminErrorSchema = z.unknown();

export const setAwayAdminDataSchema = z.object({
  body: z
    .object({
      away_mode_enabled: z.boolean(),
      away_mode_reassign: z.boolean(),
    })
    .optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const setAwayAdminResponseSchema = adminSchema;

export const setAwayAdminErrorSchema = errorSchema;

export const listActivityLogsDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  query: z.object({
    created_at_after: z.string(),
    created_at_before: z.string().optional(),
  }),
});

export const activityLogListSchema = z.object({
  type: z.string().optional(),
  pages: cursorPagesSchema.optional(),
  activity_logs: z.array(activityLogSchema).optional(),
});

export const listActivityLogsErrorSchema = errorSchema;

export const listAdminsDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const adminListSchema = z.object({
  type: z.string().optional(),
  admins: z.array(adminSchema).optional(),
});

export const listAdminsErrorSchema = errorSchema;

export const retrieveAdminDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const retrieveAdminResponseSchema = adminSchema;

export const retrieveAdminErrorSchema = errorSchema;

export const listArticlesDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const listArticlesErrorSchema = errorSchema;

export const createArticleDataSchema = z.object({
  body: createArticleRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const createArticleErrorSchema = errorSchema;

export const retrieveArticleDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const retrieveArticleErrorSchema = errorSchema;

export const updateArticleDataSchema = z.object({
  body: updateArticleRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const updateArticleErrorSchema = errorSchema;

export const deleteArticleDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const deleteArticleResponseSchema = deletedArticleObjectSchema;

export const deleteArticleErrorSchema = errorSchema;

export const listAllCollectionsDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const listAllCollectionsErrorSchema = errorSchema;

export const createCollectionRequestSchema = z.object({
  name: z.string(),
  description: z.string().optional(),
  translated_content: groupTranslatedContentSchema.optional().nullable(),
  help_center_id: z.number().optional().nullable(),
});

export const collectionSchema = z.object({
  id: z.string().optional(),
  workspace_id: z.string().optional(),
  name: z.string().optional(),
  description: z.string().optional().nullable(),
  created_at: z.number().optional(),
  updated_at: z.number().optional(),
  url: z.string().optional().nullable(),
  icon: z.string().optional().nullable(),
  order: z.number().optional(),
  default_locale: z.string().optional(),
  translated_content: groupTranslatedContentSchema.optional().nullable(),
  help_center_id: z.number().optional().nullable(),
  type: z.literal('collection').optional(),
});

export const createCollectionErrorSchema = errorSchema;

export const retrieveCollectionDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const retrieveCollectionResponseSchema = collectionSchema;

export const retrieveCollectionErrorSchema = errorSchema;

export const updateCollectionDataSchema = z.object({
  body: updateCollectionRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const updateCollectionResponseSchema = collectionSchema;

export const updateCollectionErrorSchema = errorSchema;

export const deleteCollectionDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const deleteCollectionResponseSchema = deletedCollectionObjectSchema;

export const deleteCollectionErrorSchema = errorSchema;

export const retrieveHelpCenterDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const retrieveHelpCenterResponseSchema = helpCenterSchema;

export const retrieveHelpCenterErrorSchema = errorSchema;

export const listHelpCentersDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const listHelpCentersResponseSchema = helpCenterListSchema;

export const listHelpCentersErrorSchema = errorSchema;

export const listAllSectionsDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const listAllSectionsResponseSchema = sectionListSchema;

export const listAllSectionsErrorSchema = errorSchema;

export const createSectionRequestSchema = z.object({
  name: z.string(),
  parent_id: z.number(),
  translated_content: groupTranslatedContentSchema.optional().nullable(),
});

export const createSectionResponseSchema = sectionSchema;

export const createSectionErrorSchema = errorSchema;

export const retrieveSectionDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const retrieveSectionResponseSchema = sectionSchema;

export const retrieveSectionErrorSchema = errorSchema;

export const updateSectionDataSchema = z.object({
  body: updateSectionRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const updateSectionResponseSchema = sectionSchema;

export const updateSectionErrorSchema = errorSchema;

export const deleteSectionDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const deleteSectionResponseSchema = deletedSectionObjectSchema;

export const deleteSectionErrorSchema = errorSchema;

export const createOrUpdateCompanyDataSchema = z.object({
  body: createOrUpdateCompanyRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const createOrUpdateCompanyResponseSchema = companySchema;

export const createOrUpdateCompanyErrorSchema = errorSchema;

export const retrieveCompanyDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  query: z
    .object({
      company_id: z.string().optional(),
      name: z.string().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      segment_id: z.string().optional(),
      tag_id: z.string().optional(),
    })
    .optional(),
});

export const companyListSchema = z.object({
  type: z.literal('list').optional(),
  pages: cursorPagesSchema.optional(),
  total_count: z.number().optional(),
  data: z.array(companySchema).optional(),
});

export const retrieveCompanyErrorSchema = errorSchema;

export const retrieveAcompanyByIdDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const retrieveAcompanyByIdResponseSchema = companySchema;

export const retrieveAcompanyByIdErrorSchema = errorSchema;

export const updateCompanyDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const updateCompanyResponseSchema = companySchema;

export const updateCompanyErrorSchema = errorSchema;

export const deleteCompanyDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const deleteCompanyResponseSchema = deletedCompanyObjectSchema;

export const deleteCompanyErrorSchema = errorSchema;

export const listAttachedContactsDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const listAttachedContactsErrorSchema = errorSchema;

export const listAttachedSegmentsForCompaniesDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const listAttachedSegmentsForCompaniesResponseSchema = companyAttachedSegmentsSchema;

export const listAttachedSegmentsForCompaniesErrorSchema = errorSchema;

export const listAllCompaniesDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  query: z
    .object({
      order: z.string().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
    })
    .optional(),
});

export const listAllCompaniesResponseSchema = companyListSchema;

export const listAllCompaniesErrorSchema = errorSchema;

export const scrollOverAllCompaniesDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  query: z
    .object({
      scroll_param: z.string().optional(),
    })
    .optional(),
});

export const companyScrollSchema = z
  .object({
    type: z.literal('list').optional(),
    data: z.array(companySchema).optional(),
    pages: cursorPagesSchema.optional(),
    total_count: z.number().optional().nullable(),
    scroll_param: z.string().optional(),
  })
  .nullable();

export const scrollOverAllCompaniesErrorSchema = errorSchema;

export const attachContactToAcompanyDataSchema = z.object({
  body: z
    .object({
      id: z.string(),
    })
    .optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const attachContactToAcompanyResponseSchema = companySchema;

export const attachContactToAcompanyErrorSchema = errorSchema;

export const listCompaniesForAcontactDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const contactAttachedCompaniesSchema = z.object({
  type: z.literal('list').optional(),
  companies: z.array(companySchema).optional(),
  total_count: z.number().optional(),
  pages: pagesLinkSchema.optional(),
});

export const listCompaniesForAcontactErrorSchema = errorSchema;

export const detachContactFromAcompanyDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    contact_id: z.string(),
    id: z.string(),
  }),
});

export const detachContactFromAcompanyResponseSchema = companySchema;

export const detachContactFromAcompanyErrorSchema = errorSchema;

export const listNotesDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const noteListSchema = z.object({
  type: z.string().optional(),
  data: z.array(noteSchema).optional(),
  total_count: z.number().optional(),
  pages: cursorPagesSchema.optional(),
});

export const listNotesErrorSchema = errorSchema;

export const createNoteDataSchema = z.object({
  body: z
    .object({
      body: z.string(),
      contact_id: z.string().optional(),
      admin_id: z.string().optional(),
    })
    .optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const createNoteResponseSchema = noteSchema;

export const createNoteErrorSchema = errorSchema;

export const listSegmentsForAcontactDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    contact_id: z.string(),
  }),
});

export const listSegmentsForAcontactResponseSchema = contactSegmentsSchema;

export const listSegmentsForAcontactErrorSchema = errorSchema;

export const listSubscriptionsForAcontactDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    contact_id: z.string(),
  }),
});

export const subscriptionTypeListSchema = z.object({
  type: z.literal('list').optional(),
  data: z.array(subscriptionTypeSchema).optional(),
});

export const listSubscriptionsForAcontactErrorSchema = errorSchema;

export const attachSubscriptionTypeToContactDataSchema = z.object({
  body: z
    .object({
      id: z.string(),
      consent_type: z.string(),
    })
    .optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    contact_id: z.string(),
  }),
});

export const attachSubscriptionTypeToContactResponseSchema = subscriptionTypeSchema;

export const attachSubscriptionTypeToContactErrorSchema = errorSchema;

export const detachSubscriptionTypeToContactDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    contact_id: z.string(),
    id: z.string(),
  }),
});

export const detachSubscriptionTypeToContactResponseSchema = subscriptionTypeSchema;

export const detachSubscriptionTypeToContactErrorSchema = errorSchema;

export const listTagsForAcontactDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    contact_id: z.string(),
  }),
});

export const listTagsForAcontactResponseSchema = tagListSchema;

export const listTagsForAcontactErrorSchema = errorSchema;

export const attachTagToContactDataSchema = z.object({
  body: z
    .object({
      id: z.string(),
    })
    .optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    contact_id: z.string(),
  }),
});

export const attachTagToContactResponseSchema = tagSchema;

export const attachTagToContactErrorSchema = errorSchema;

export const detachTagFromContactDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    contact_id: z.string(),
    id: z.string(),
  }),
});

export const detachTagFromContactResponseSchema = tagSchema;

export const detachTagFromContactErrorSchema = errorSchema;

export const updateContactDataSchema = z.object({
  body: updateContactRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const updateContactErrorSchema = errorSchema;

export const showContactDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const showContactErrorSchema = errorSchema;

export const deleteContactDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const deleteContactResponseSchema = contactDeletedSchema;

export const deleteContactErrorSchema = errorSchema;

export const mergeContactDataSchema = z.object({
  body: mergeContactsRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const mergeContactErrorSchema = errorSchema;

export const searchRequestSchema = z.object({
  query: z.union([singleFilterSearchRequestSchema, multipleFilterSearchRequestSchema]),
  pagination: startingAfterPagingSchema.optional(),
});

export const searchContactsErrorSchema = errorSchema;

export const listContactsDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const listContactsErrorSchema = errorSchema;

export const createContactDataSchema = z.object({
  body: createContactRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const createContactErrorSchema = errorSchema;

export const archiveContactDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const archiveContactResponseSchema = contactArchivedSchema;

export const archiveContactErrorSchema = z.unknown();

export const unarchiveContactDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const unarchiveContactResponseSchema = contactUnarchivedSchema;

export const unarchiveContactErrorSchema = z.unknown();

export const attachTagToConversationDataSchema = z.object({
  body: z
    .object({
      id: z.string(),
      admin_id: z.string(),
    })
    .optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    conversation_id: z.string(),
  }),
});

export const attachTagToConversationResponseSchema = tagSchema;

export const attachTagToConversationErrorSchema = errorSchema;

export const detachTagFromConversationDataSchema = z.object({
  body: z
    .object({
      admin_id: z.string(),
    })
    .optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    conversation_id: z.string(),
    id: z.string(),
  }),
});

export const detachTagFromConversationResponseSchema = tagSchema;

export const detachTagFromConversationErrorSchema = errorSchema;

export const listConversationsDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  query: z
    .object({
      per_page: z.number().optional(),
      starting_after: z.string().optional(),
    })
    .optional(),
});

export const paginatedResponseSchema = z.object({
  type: z.union([z.literal('list'), z.literal('conversation.list')]).optional(),
  pages: cursorPagesSchema.optional(),
  total_count: z.number().optional(),
  data: z.array(z.union([newsItemSchema, newsfeedSchema])).optional(),
});

export const listConversationsErrorSchema = errorSchema;

export const createConversationDataSchema = z.object({
  body: createConversationRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const createConversationResponseSchema = messageSchema;

export const createConversationErrorSchema = errorSchema;

export const retrieveConversationDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
  query: z
    .object({
      display_as: z.string().optional(),
    })
    .optional(),
});

export const retrieveConversationErrorSchema = errorSchema;

export const updateConversationRequestSchema = z.object({
  read: z.boolean().optional(),
  custom_attributes: customAttributesSchema.optional(),
});

export const updateConversationErrorSchema = errorSchema;

export const searchConversationsDataSchema = z.object({
  body: searchRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const searchConversationsErrorSchema = z.unknown();

export const replyConversationRequestSchema = z.union([
  contactReplyConversationRequestSchema,
  adminReplyConversationRequestSchema,
]);

export const replyConversationErrorSchema = errorSchema;

export const manageConversationDataSchema = z.object({
  body: z
    .union([
      closeConversationRequestSchema,
      snoozeConversationRequestSchema,
      openConversationRequestSchema,
      assignConversationRequestSchema,
    ])
    .optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const manageConversationErrorSchema = errorSchema;

export const autoAssignConversationDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const autoAssignConversationErrorSchema = errorSchema;

export const attachContactToConversationRequestSchema = z.object({
  admin_id: z.string().optional(),
  customer: z
    .union([
      z.object({
        intercom_user_id: z.string(),
        customer: customerRequestSchema.optional(),
      }),
      z.object({
        user_id: z.string(),
        customer: customerRequestSchema.optional(),
      }),
      z.object({
        email: z.string(),
        customer: customerRequestSchema.optional(),
      }),
    ])
    .optional(),
});

export const attachContactToConversationErrorSchema = errorSchema;

export const detachContactFromConversationDataSchema = z.object({
  body: detachContactFromConversationRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    contact_id: z.string(),
    conversation_id: z.string(),
  }),
});

export const detachContactFromConversationErrorSchema = errorSchema;

export const redactConversationDataSchema = z.object({
  body: redactConversationRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const redactConversationErrorSchema = errorSchema;

export const lisDataAttributesDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  query: z
    .object({
      include_archived: z.boolean().optional(),
      model: z.union([z.literal('contact'), z.literal('company'), z.literal('conversation')]).optional(),
    })
    .optional(),
});

export const lisDataAttributesResponseSchema = dataAttributeListSchema;

export const lisDataAttributesErrorSchema = errorSchema;

export const createDataAttributeDataSchema = z.object({
  body: createDataAttributeRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const createDataAttributeResponseSchema = dataAttributeSchema;

export const createDataAttributeErrorSchema = errorSchema;

export const updateDataAttributeDataSchema = z.object({
  body: updateDataAttributeRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const updateDataAttributeResponseSchema = dataAttributeSchema;

export const updateDataAttributeErrorSchema = errorSchema;

export const createDataEventDataSchema = z.object({
  body: createDataEventRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const createDataEventResponseSchema = z.unknown();

export const createDataEventErrorSchema = errorSchema;

export const lisDataEventsDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  query: z.object({
    filter: z.union([
      z.object({
        user_id: z.string(),
      }),
      z.object({
        intercom_user_id: z.string(),
      }),
      z.object({
        email: z.string(),
      }),
    ]),
    summary: z.boolean().optional(),
    type: z.string(),
  }),
});

export const dataEventSummarySchema = z.object({
  type: z.literal('event.summary').optional(),
  email: z.string().optional(),
  intercom_user_id: z.string().optional(),
  user_id: z.string().optional(),
  events: z.array(dataEventSummaryItemSchema).optional(),
});

export const lisDataEventsErrorSchema = errorSchema;

export const dataEventSummariesDataSchema = z.object({
  body: createDataEventSummariesRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const dataEventSummariesResponseSchema = z.unknown();

export const dataEventSummariesErrorSchema = errorSchema;

export const createDataExportDataSchema = z.object({
  body: createDataExportsRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const createDataExportResponseSchema = dataExportSchema;

export const createDataExportErrorSchema = z.unknown();

export const getDataExportDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    job_identifier: z.string(),
  }),
});

export const getDataExportResponseSchema = dataExportSchema;

export const getDataExportErrorSchema = z.unknown();

export const cancelDataExportDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    job_identifier: z.string(),
  }),
});

export const cancelDataExportResponseSchema = dataExportSchema;

export const cancelDataExportErrorSchema = z.unknown();

export const downloadDataExportDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    job_identifier: z.string(),
  }),
});

export const downloadDataExportResponseSchema = z.unknown();

export const downloadDataExportErrorSchema = z.unknown();

export const createMessageDataSchema = z.object({
  body: createMessageRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const createMessageResponseSchema = messageSchema;

export const createMessageErrorSchema = errorSchema;

export const listNewsItemsDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const listNewsItemsResponseSchema = paginatedResponseSchema;

export const listNewsItemsErrorSchema = errorSchema;

export const createNewsItemDataSchema = z.object({
  body: newsItemRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const createNewsItemResponseSchema = newsItemSchema;

export const createNewsItemErrorSchema = errorSchema;

export const retrieveNewsItemDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const retrieveNewsItemResponseSchema = newsItemSchema;

export const retrieveNewsItemErrorSchema = errorSchema;

export const updateNewsItemDataSchema = z.object({
  body: newsItemRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const updateNewsItemResponseSchema = newsItemSchema;

export const updateNewsItemErrorSchema = errorSchema;

export const deleteNewsItemDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const deleteNewsItemResponseSchema = deletedObjectSchema;

export const deleteNewsItemErrorSchema = errorSchema;

export const listLiveNewsfeedItemsDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const listLiveNewsfeedItemsResponseSchema = paginatedResponseSchema;

export const listLiveNewsfeedItemsErrorSchema = errorSchema;

export const listNewsfeedsDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const listNewsfeedsResponseSchema = paginatedResponseSchema;

export const listNewsfeedsErrorSchema = errorSchema;

export const retrieveNewsfeedDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const retrieveNewsfeedResponseSchema = newsfeedSchema;

export const retrieveNewsfeedErrorSchema = errorSchema;

export const retrieveNoteDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
});

export const retrieveNoteResponseSchema = noteSchema;

export const retrieveNoteErrorSchema = errorSchema;

export const listSegmentsDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  query: z
    .object({
      include_count: z.boolean().optional(),
    })
    .optional(),
});

export const listSegmentsResponseSchema = segmentListSchema;

export const listSegmentsErrorSchema = errorSchema;

export const retrieveSegmentDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const retrieveSegmentResponseSchema = segmentSchema;

export const retrieveSegmentErrorSchema = errorSchema;

export const listSubscriptionTypesDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const listSubscriptionTypesResponseSchema = subscriptionTypeListSchema;

export const listSubscriptionTypesErrorSchema = errorSchema;

export const createPhoneSwitchRequestSchema = z
  .object({
    phone: z.string(),
    custom_attributes: customAttributesSchema.optional(),
  })
  .nullable();

export const createPhoneSwitchResponseSchema = phoneSwitchSchema;

export const createPhoneSwitchErrorSchema = z.union([z.unknown(), errorSchema]);

export const listTagsDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const listTagsResponseSchema = tagListSchema;

export const listTagsErrorSchema = errorSchema;

export const createTagDataSchema = z.object({
  body: z
    .union([
      createOrUpdateTagRequestSchema,
      tagCompanyRequestSchema,
      untagCompanyRequestSchema,
      tagMultipleUsersRequestSchema,
    ])
    .optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const createTagResponseSchema = tagSchema;

export const createTagErrorSchema = errorSchema;

export const findTagDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const findTagResponseSchema = tagSchema;

export const findTagErrorSchema = errorSchema;

export const deleteTagDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const deleteTagResponseSchema = z.unknown();

export const deleteTagErrorSchema = errorSchema;

export const listTeamsDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const listTeamsResponseSchema = teamListSchema;

export const listTeamsErrorSchema = errorSchema;

export const retrieveTeamDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const retrieveTeamResponseSchema = teamSchema;

export const retrieveTeamErrorSchema = errorSchema;

export const createTicketTypeAttributeDataSchema = z.object({
  body: createTicketTypeAttributeRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    ticket_type_id: z.string(),
  }),
});

export const createTicketTypeAttributeResponseSchema = ticketTypeAttributeSchema;

export const createTicketTypeAttributeErrorSchema = errorSchema;

export const updateTicketTypeAttributeDataSchema = z.object({
  body: updateTicketTypeAttributeRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
    ticket_type_id: z.string(),
  }),
});

export const updateTicketTypeAttributeResponseSchema = ticketTypeAttributeSchema;

export const updateTicketTypeAttributeErrorSchema = errorSchema;

export const listTicketTypesDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const ticketTypeListSchema = z.object({
  type: z.string().optional(),
  ticket_types: z.array(ticketTypeSchema).optional(),
});

export const listTicketTypesErrorSchema = errorSchema;

export const createTicketTypeDataSchema = z.object({
  body: createTicketTypeRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const createTicketTypeResponseSchema = ticketTypeSchema;

export const createTicketTypeErrorSchema = errorSchema;

export const getTicketTypeDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const getTicketTypeResponseSchema = ticketTypeSchema;

export const getTicketTypeErrorSchema = errorSchema;

export const updateTicketTypeDataSchema = z.object({
  body: updateTicketTypeRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const updateTicketTypeResponseSchema = ticketTypeSchema;

export const updateTicketTypeErrorSchema = errorSchema;

export const replyTicketDataSchema = z.object({
  body: createTicketReplyRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const ticketNoteSchema = z.object({
  type: z.literal('ticket_part').optional(),
  id: z.string().optional(),
  part_type: z.literal('note').optional(),
  body: z.string().optional().nullable(),
  created_at: z.number().optional(),
  updated_at: z.number().optional(),
  author: ticketPartAuthorSchema.optional(),
  attachments: z.array(partAttachmentSchema).optional(),
  redacted: z.boolean().optional(),
});

export const replyTicketErrorSchema = errorSchema;

export const createTicketRequestSchema = z.object({
  ticket_type_id: z.string(),
  contacts: z.array(
    z.union([
      z.object({
        id: z.string(),
      }),
      z.object({
        external_id: z.string(),
      }),
      z.object({
        email: z.string(),
      }),
    ]),
  ),
  company_id: z.string().optional(),
  ticket_attributes: ticketRequestCustomAttributesSchema.optional(),
});

export const ticketSchema = z
  .object({
    type: z.literal('ticket').optional(),
    id: z.string().optional(),
    ticket_id: z.string().optional(),
    ticket_attributes: ticketCustomAttributesSchema.optional(),
    ticket_state: z
      .union([
        z.literal('submitted'),
        z.literal('in_progress'),
        z.literal('waiting_on_customer'),
        z.literal('resolved'),
      ])
      .optional(),
    ticket_state_internal_label: z.string().optional(),
    ticket_state_external_label: z.string().optional(),
    ticket_type: ticketTypeSchema.optional(),
    contacts: ticketContactsSchema.optional(),
    admin_assignee_id: z.string().optional(),
    team_assignee_id: z.string().optional(),
    created_at: z.number().optional(),
    updated_at: z.number().optional(),
    ticket_parts: ticketPartsSchema.optional(),
    is_shared: z.boolean().optional(),
  })
  .nullable();

export const createTicketErrorSchema = errorSchema;

export const updateTicketDataSchema = z.object({
  body: updateTicketRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const updateTicketResponseSchema = ticketSchema;

export const updateTicketErrorSchema = z.union([errorSchema, z.unknown()]);

export const getTicketDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const getTicketResponseSchema = ticketSchema;

export const getTicketErrorSchema = errorSchema;

export const updateVisitorDataSchema = z.object({
  body: updateVisitorRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const updateVisitorResponseSchema = visitorSchema;

export const updateVisitorErrorSchema = errorSchema;

export const retrieveVisitorWithUserIdDataSchema = z.object({
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  query: z.object({
    user_id: z.string(),
  }),
});

export const retrieveVisitorWithUserIdResponseSchema = visitorSchema;

export const retrieveVisitorWithUserIdErrorSchema = errorSchema;

export const convertVisitorDataSchema = z.object({
  body: convertVisitorRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const convertVisitorErrorSchema = errorSchema;

export const articleListItemSchema = z.object({
  type: z.literal('article').optional(),
  id: z.string().optional(),
  workspace_id: z.string().optional(),
  title: z.string().optional(),
  description: z.string().optional().nullable(),
  body: z.string().optional().nullable(),
  author_id: z.number().optional(),
  state: z.union([z.literal('published'), z.literal('draft')]).optional(),
  created_at: z.number().optional(),
  updated_at: z.number().optional(),
  url: z.string().optional().nullable(),
  parent_id: z.number().optional().nullable(),
  parent_ids: z.array(z.number()).optional(),
  parent_type: z.string().optional().nullable(),
  default_locale: z.string().optional(),
  translated_content: articleTranslatedContentSchema.optional().nullable(),
});

export const articleListSchema = z.object({
  type: z.literal('list').optional(),
  pages: cursorPagesSchema.optional(),
  total_count: z.number().optional(),
  data: z.array(articleListItemSchema).optional(),
});

export const collectionListSchema = z.object({
  type: z.literal('list').optional(),
  pages: cursorPagesSchema.optional(),
  total_count: z.number().optional(),
  data: z.array(collectionSchema).optional(),
});

export const contactSocialProfilesSchema = z.object({
  data: z.array(socialProfileSchema).optional(),
});

export const contactSchema = z.object({
  type: z.string().optional(),
  id: z.string().optional(),
  external_id: z.string().optional().nullable(),
  workspace_id: z.string().optional(),
  role: z.string().optional(),
  email: z.string().optional(),
  email_domain: z.string().optional(),
  phone: z.string().optional().nullable(),
  formatted_phone: z.string().optional().nullable(),
  name: z.string().optional().nullable(),
  owner_id: z.number().optional().nullable(),
  has_hard_bounced: z.boolean().optional(),
  marked_email_as_spam: z.boolean().optional(),
  unsubscribed_from_emails: z.boolean().optional(),
  created_at: z.number().optional(),
  updated_at: z.number().optional(),
  signed_up_at: z.number().optional().nullable(),
  last_seen_at: z.number().optional().nullable(),
  last_replied_at: z.number().optional().nullable(),
  last_contacted_at: z.number().optional().nullable(),
  last_email_opened_at: z.number().optional().nullable(),
  last_email_clicked_at: z.number().optional().nullable(),
  language_override: z.string().optional().nullable(),
  browser: z.string().optional().nullable(),
  browser_version: z.string().optional().nullable(),
  browser_language: z.string().optional().nullable(),
  os: z.string().optional().nullable(),
  android_app_name: z.string().optional().nullable(),
  android_app_version: z.string().optional().nullable(),
  android_device: z.string().optional().nullable(),
  android_os_version: z.string().optional().nullable(),
  android_sdk_version: z.string().optional().nullable(),
  android_last_seen_at: z.number().optional().nullable(),
  ios_app_name: z.string().optional().nullable(),
  ios_app_version: z.string().optional().nullable(),
  ios_device: z.string().optional().nullable(),
  ios_os_version: z.string().optional().nullable(),
  ios_sdk_version: z.string().optional().nullable(),
  ios_last_seen_at: z.number().optional().nullable(),
  custom_attributes: z.record(z.unknown()).optional(),
  avatar: z
    .object({
      type: z.string().optional(),
      image_url: z.string().optional().nullable(),
    })
    .optional()
    .nullable(),
  tags: contactTagsSchema.optional(),
  notes: contactNotesSchema.optional(),
  companies: contactCompaniesSchema.optional(),
  location: contactLocationSchema.optional(),
  social_profiles: contactSocialProfilesSchema.optional(),
});

export const conversationPartsSchema = z.object({
  type: z.literal('conversation_part.list').optional(),
  conversation_parts: z.array(conversationPartSchema).optional(),
  total_count: z.number().optional(),
});

export const conversationSchema = z.object({
  type: z.string().optional(),
  id: z.string().optional(),
  title: z.string().optional().nullable(),
  created_at: z.number().optional(),
  updated_at: z.number().optional(),
  waiting_since: z.number().optional().nullable(),
  snoozed_until: z.number().optional().nullable(),
  open: z.boolean().optional(),
  state: z.union([z.literal('open'), z.literal('closed'), z.literal('snoozed')]).optional(),
  read: z.boolean().optional(),
  priority: z.union([z.literal('priority'), z.literal('not_priority')]).optional(),
  admin_assignee_id: z.number().optional().nullable(),
  team_assignee_id: z.string().optional().nullable(),
  tags: tagsSchema.optional(),
  conversation_rating: conversationRatingSchema.optional(),
  source: conversationSourceSchema.optional(),
  contacts: conversationContactsSchema.optional(),
  teammates: conversationTeammatesSchema.optional(),
  custom_attributes: customAttributesSchema.optional(),
  first_contact_reply: conversationFirstContactReplySchema.optional(),
  sla_applied: slaAppliedSchema.optional(),
  statistics: conversationStatisticsSchema.optional(),
  conversation_parts: conversationPartsSchema.optional(),
});

export const identifyAdminResponseSchema = adminWithAppSchema;

export const listActivityLogsResponseSchema = activityLogListSchema;

export const listAdminsResponseSchema = adminListSchema;

export const listArticlesResponseSchema = articleListSchema;

export const articleSchema = articleListItemSchema.and(
  z.object({
    statistics: articleStatisticsSchema.optional().nullable(),
  }),
);

export const retrieveArticleResponseSchema = articleSchema;

export const updateArticleResponseSchema = articleSchema;

export const listAllCollectionsResponseSchema = collectionListSchema;

export const createCollectionDataSchema = z.object({
  body: createCollectionRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const createCollectionResponseSchema = collectionSchema;

export const createSectionDataSchema = z.object({
  body: createSectionRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const retrieveCompanyResponseSchema = companyListSchema;

export const companyAttachedContactsSchema = z.object({
  type: z.literal('list').optional(),
  data: z.array(contactSchema).optional(),
  total_count: z.number().optional(),
  pages: cursorPagesSchema.optional(),
});

export const scrollOverAllCompaniesResponseSchema = companyScrollSchema;

export const listCompaniesForAcontactResponseSchema = contactAttachedCompaniesSchema;

export const listNotesResponseSchema = noteListSchema;

export const listSubscriptionsForAcontactResponseSchema = subscriptionTypeListSchema;

export const updateContactResponseSchema = contactSchema;

export const showContactResponseSchema = contactSchema;

export const mergeContactResponseSchema = contactSchema;

export const searchContactsDataSchema = z.object({
  body: searchRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const contactListSchema = z.object({
  type: z.literal('list').optional(),
  data: z.array(contactSchema).optional(),
  total_count: z.number().optional(),
  pages: cursorPagesSchema.optional(),
});

export const listContactsResponseSchema = contactListSchema;

export const createContactResponseSchema = contactSchema;

export const listConversationsResponseSchema = paginatedResponseSchema;

export const retrieveConversationResponseSchema = conversationSchema;

export const updateConversationDataSchema = z.object({
  body: updateConversationRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.number(),
  }),
  query: z
    .object({
      display_as: z.string().optional(),
    })
    .optional(),
});

export const updateConversationResponseSchema = conversationSchema;

export const conversationListSchema = z.object({
  type: z.literal('conversation.list').optional(),
  conversations: z.array(conversationSchema).optional(),
  total_count: z.number().optional(),
  pages: cursorPagesSchema.optional(),
});

export const replyConversationDataSchema = z.object({
  body: replyConversationRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const replyConversationResponseSchema = conversationSchema;

export const manageConversationResponseSchema = conversationSchema;

export const autoAssignConversationResponseSchema = conversationSchema;

export const attachContactToConversationDataSchema = z.object({
  body: attachContactToConversationRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
  path: z.object({
    id: z.string(),
  }),
});

export const attachContactToConversationResponseSchema = conversationSchema;

export const detachContactFromConversationResponseSchema = conversationSchema;

export const redactConversationResponseSchema = conversationSchema;

export const lisDataEventsResponseSchema = dataEventSummarySchema;

export const createPhoneSwitchDataSchema = z.object({
  body: createPhoneSwitchRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const listTicketTypesResponseSchema = ticketTypeListSchema;

export const replyTicketResponseSchema = ticketNoteSchema;

export const createTicketDataSchema = z.object({
  body: createTicketRequestSchema.optional(),
  headers: z
    .object({
      'Intercom-Version': intercomVersionSchema.optional(),
    })
    .optional(),
});

export const createTicketResponseSchema = ticketSchema;

export const convertVisitorResponseSchema = contactSchema;

export const createArticleResponseSchema = articleSchema;

export const listAttachedContactsResponseSchema = companyAttachedContactsSchema;

export const searchContactsResponseSchema = contactListSchema;

export const searchConversationsResponseSchema = conversationListSchema;
