// This file is auto-generated by @hey-api/openapi-ts

/**
 * Activities performed by Admins.
 */
export type activity_log = {
  /**
   * The id representing the activity.
   */
  id?: string;
  /**
   * Details about the Admin involved in the activity.
   */
  performed_by?: {
    /**
     * String representing the object's type. Always has the value `admin`.
     */
    type?: string;
    /**
     * The id representing the admin.
     */
    id?: string;
    /**
     * The email of the admin.
     */
    email?: string;
    /**
     * The IP address of the admin.
     */
    ip?: string;
  };
  metadata?: activity_log_metadata;
  /**
   * The time the activity was created.
   */
  created_at?: number;
  activity_type?:
    | 'admin_assignment_limit_change'
    | 'admin_away_mode_change'
    | 'admin_deletion'
    | 'admin_deprovisioned'
    | 'admin_impersonation_end'
    | 'admin_impersonation_start'
    | 'admin_invite_change'
    | 'admin_invite_creation'
    | 'admin_invite_deletion'
    | 'admin_login_failure'
    | 'admin_login_success'
    | 'admin_logout'
    | 'admin_password_reset_request'
    | 'admin_password_reset_success'
    | 'admin_permission_change'
    | 'admin_provisioned'
    | 'admin_two_factor_auth_change'
    | 'admin_unauthorized_sign_in_method'
    | 'app_admin_join'
    | 'app_authentication_method_change'
    | 'app_data_deletion'
    | 'app_data_export'
    | 'app_google_sso_domain_change'
    | 'app_identity_verification_change'
    | 'app_name_change'
    | 'app_outbound_address_change'
    | 'app_package_installation'
    | 'app_package_token_regeneration'
    | 'app_package_uninstallation'
    | 'app_team_creation'
    | 'app_team_deletion'
    | 'app_team_membership_modification'
    | 'app_timezone_change'
    | 'app_webhook_creation'
    | 'app_webhook_deletion'
    | 'articles_in_messenger_enabled_change'
    | 'bulk_delete'
    | 'bulk_export'
    | 'campaign_deletion'
    | 'campaign_state_change'
    | 'conversation_part_deletion'
    | 'conversation_topic_change'
    | 'conversation_topic_creation'
    | 'conversation_topic_deletion'
    | 'help_center_settings_change'
    | 'inbound_conversations_change'
    | 'inbox_access_change'
    | 'message_deletion'
    | 'message_state_change'
    | 'messenger_look_and_feel_change'
    | 'messenger_search_required_change'
    | 'messenger_spaces_change'
    | 'office_hours_change'
    | 'role_change'
    | 'role_creation'
    | 'role_deletion'
    | 'ruleset_activation_title_preview'
    | 'ruleset_creation'
    | 'ruleset_deletion'
    | 'search_browse_enabled_change'
    | 'search_browse_required_change'
    | 'seat_change'
    | 'seat_revoke'
    | 'security_settings_change'
    | 'temporary_expectation_change'
    | 'upfront_email_collection_change'
    | 'welcome_message_change';
  /**
   * A sentence or two describing the activity.
   */
  activity_description?: string;
} | null;

export type activity_type =
  | 'admin_assignment_limit_change'
  | 'admin_away_mode_change'
  | 'admin_deletion'
  | 'admin_deprovisioned'
  | 'admin_impersonation_end'
  | 'admin_impersonation_start'
  | 'admin_invite_change'
  | 'admin_invite_creation'
  | 'admin_invite_deletion'
  | 'admin_login_failure'
  | 'admin_login_success'
  | 'admin_logout'
  | 'admin_password_reset_request'
  | 'admin_password_reset_success'
  | 'admin_permission_change'
  | 'admin_provisioned'
  | 'admin_two_factor_auth_change'
  | 'admin_unauthorized_sign_in_method'
  | 'app_admin_join'
  | 'app_authentication_method_change'
  | 'app_data_deletion'
  | 'app_data_export'
  | 'app_google_sso_domain_change'
  | 'app_identity_verification_change'
  | 'app_name_change'
  | 'app_outbound_address_change'
  | 'app_package_installation'
  | 'app_package_token_regeneration'
  | 'app_package_uninstallation'
  | 'app_team_creation'
  | 'app_team_deletion'
  | 'app_team_membership_modification'
  | 'app_timezone_change'
  | 'app_webhook_creation'
  | 'app_webhook_deletion'
  | 'articles_in_messenger_enabled_change'
  | 'bulk_delete'
  | 'bulk_export'
  | 'campaign_deletion'
  | 'campaign_state_change'
  | 'conversation_part_deletion'
  | 'conversation_topic_change'
  | 'conversation_topic_creation'
  | 'conversation_topic_deletion'
  | 'help_center_settings_change'
  | 'inbound_conversations_change'
  | 'inbox_access_change'
  | 'message_deletion'
  | 'message_state_change'
  | 'messenger_look_and_feel_change'
  | 'messenger_search_required_change'
  | 'messenger_spaces_change'
  | 'office_hours_change'
  | 'role_change'
  | 'role_creation'
  | 'role_deletion'
  | 'ruleset_activation_title_preview'
  | 'ruleset_creation'
  | 'ruleset_deletion'
  | 'search_browse_enabled_change'
  | 'search_browse_required_change'
  | 'seat_change'
  | 'seat_revoke'
  | 'security_settings_change'
  | 'temporary_expectation_change'
  | 'upfront_email_collection_change'
  | 'welcome_message_change';

/**
 * A paginated list of activity logs.
 */
export type activity_log_list = {
  /**
   * String representing the object's type. Always has the value `activity_log.list`.
   */
  type?: string;
  pages?: cursor_pages;
  /**
   * An array of activity logs
   */
  activity_logs?: Array<activity_log>;
};

/**
 * Additional data provided about Admin activity.
 */
export type activity_log_metadata = {
  /**
   * The way the admin signed in.
   */
  sign_in_method?: string | null;
  /**
   * The unique identifier for the contact which is provided by the Client.
   */
  external_id?: string | null;
  /**
   * The away mode status which is set to true when away and false when returned.
   */
  away_mode?: boolean | null;
  /**
   * The reason the Admin is away.
   */
  away_status_reason?: string | null;
  /**
   * Indicates if conversations should be reassigned while an Admin is away.
   */
  reassign_conversations?: boolean | null;
  /**
   * The action that initiated the status change.
   */
  source?: string | null;
  /**
   * Indicates if the status was changed automatically or manually.
   */
  auto_changed?: string | null;
  /**
   * The ID of the Admin who initiated the activity.
   */
  update_by?: number | null;
  /**
   * The name of the Admin who initiated the activity.
   */
  update_by_name?: string | null;
} | null;

/**
 * A list used to access other resources from a parent model.
 */
export type addressable_list = {
  /**
   * The addressable object type
   */
  type?: string;
  /**
   * The id of the addressable object
   */
  id?: string;
  /**
   * Url to get more company resources for this contact
   */
  url?: string;
};

/**
 * Admins are teammate accounts that have access to a workspace.
 */
export type admin = {
  /**
   * String representing the object's type. Always has the value `admin`.
   */
  type?: string;
  /**
   * The id representing the admin.
   */
  id?: string;
  /**
   * The name of the admin.
   */
  name?: string;
  /**
   * The email of the admin.
   */
  email?: string;
  /**
   * The job title of the admin.
   */
  job_title?: string;
  /**
   * Identifies if this admin is currently set in away mode.
   */
  away_mode_enabled?: boolean;
  /**
   * Identifies if this admin is set to automatically reassign new conversations to the apps default inbox.
   */
  away_mode_reassign?: boolean;
  /**
   * Identifies if this admin has a paid inbox seat to restrict/allow features that require them.
   */
  has_inbox_seat?: boolean;
  /**
   * This object represents the avatar associated with the admin.
   */
  team_ids?: Array<number>;
  /**
   * Image for the associated team or teammate
   */
  avatar?: string | null;
  team_priority_level?: team_priority_level;
} | null;

/**
 * A list of admins associated with a given workspace.
 */
export type admin_list = {
  /**
   * String representing the object's type. Always has the value `admin.list`.
   */
  type?: string;
  /**
   * A list of admins associated with a given workspace.
   */
  admins?: Array<admin>;
};

/**
 * Admin priority levels for the team
 */
export type admin_priority_level = {
  /**
   * The primary admin ids for the team
   */
  primary_admin_ids?: Array<number> | null;
  /**
   * The secondary admin ids for the team
   */
  secondary_admin_ids?: Array<number> | null;
} | null;

/**
 * Payload of the request to reply on behalf of an admin
 */
export type admin_reply_conversation_request = {
  message_type: 'comment' | 'note';
  type: 'admin';
  /**
   * The text body of the reply. Notes accept some HTML formatting. Must be present for comment and note message types.
   */
  body?: string;
  /**
   * The id of the admin who is authoring the comment.
   */
  admin_id: string;
  /**
   * The time the reply was created. If not provided, the current time will be used.
   */
  created_at?: number;
  /**
   * A list of image URLs that will be added as attachments. You can include up to 10 URLs.
   */
  attachment_urls?: Array<string>;
  /**
   * A list of files that will be added as attachments. You can include up to 10 files
   */
  attachment_files?: Array<conversation_attachment_files>;
};

export type message_type = 'comment' | 'note';

export type type = 'admin';

/**
 * Admins are the teammate accounts that have access to a workspace
 */
export type admin_with_app = {
  /**
   * String representing the object's type. Always has the value `admin`.
   */
  type?: string;
  /**
   * The id representing the admin.
   */
  id?: string;
  /**
   * The name of the admin.
   */
  name?: string;
  /**
   * The email of the admin.
   */
  email?: string;
  /**
   * The job title of the admin.
   */
  job_title?: string;
  /**
   * Identifies if this admin is currently set in away mode.
   */
  away_mode_enabled?: boolean;
  /**
   * Identifies if this admin is set to automatically reassign new conversations to the apps default inbox.
   */
  away_mode_reassign?: boolean;
  /**
   * Identifies if this admin has a paid inbox seat to restrict/allow features that require them.
   */
  has_inbox_seat?: boolean;
  /**
   * This is a list of ids of the teams that this admin is part of.
   */
  team_ids?: Array<number>;
  /**
   * This object represents the avatar associated with the admin.
   */
  avatar?: {
    /**
     * This is a string that identifies the type of the object. It will always have the value `avatar`.
     */
    type?: string;
    /**
     * This object represents the avatar associated with the admin.
     */
    image_url?: string | null;
  };
  /**
   * Identifies if this admin's email is verified.
   */
  email_verified?: boolean | null;
  /**
   * App that the admin belongs to.
   */
  app?: app | null;
} | null;

/**
 * App is a workspace on Intercom
 */
export type app = {
  type?: string;
  /**
   * The id of the app.
   */
  id_code?: string;
  /**
   * The name of the app.
   */
  name?: string;
  /**
   * The Intercom region the app is located in.
   */
  region?: string;
  /**
   * The timezone of the region where the app is located.
   */
  timezone?: string;
  /**
   * When the app was created.
   */
  created_at?: number;
  /**
   * Whether or not the app uses identity verification.
   */
  identity_verification?: boolean;
} | null;

/**
 * The Articles API is a central place to gather all information and take actions on your articles. Articles can live within collections and sections, or alternatively they can stand alone.
 */
export type article = article_list_item & {
  statistics?: article_statistics | null;
};

/**
 * The Content of an Article.
 */
export type article_content = {
  /**
   * The type of object - `article_content` .
   */
  type?: 'article_content' | null;
  /**
   * The title of the article.
   */
  title?: string;
  /**
   * The description of the article.
   */
  description?: string;
  /**
   * The body of the article.
   */
  body?: string;
  /**
   * The ID of the author of the article.
   */
  author_id?: number;
  /**
   * Whether the article is `published` or is a `draft` .
   */
  state?: 'published' | 'draft';
  /**
   * The time when the article was created (seconds).
   */
  created_at?: number;
  /**
   * The time when the article was last updated (seconds).
   */
  updated_at?: number;
  /**
   * The URL of the article.
   */
  url?: string;
} | null;

/**
 * The type of object - `article_content` .
 */
export type type2 = 'article_content';

/**
 * Whether the article is `published` or is a `draft` .
 */
export type state = 'published' | 'draft';

/**
 * This will return a list of articles for the App.
 */
export type article_list = {
  /**
   * The type of the object - `list`.
   */
  type?: 'list';
  pages?: cursor_pages;
  /**
   * A count of the total number of articles.
   */
  total_count?: number;
  /**
   * An array of Article objects
   */
  data?: Array<article_list_item>;
};

/**
 * The type of the object - `list`.
 */
export type type3 = 'list';

/**
 * The data returned about your articles when you list them.
 */
export type article_list_item = {
  /**
   * The type of object - `article`.
   */
  type?: 'article';
  /**
   * The unique identifier for the article which is given by Intercom.
   */
  id?: string;
  /**
   * The id of the workspace which the article belongs to.
   */
  workspace_id?: string;
  /**
   * The title of the article. For multilingual articles, this will be the title of the default language's content.
   */
  title?: string;
  /**
   * The description of the article. For multilingual articles, this will be the description of the default language's content.
   */
  description?: string | null;
  /**
   * The body of the article in HTML. For multilingual articles, this will be the body of the default language's content.
   */
  body?: string | null;
  /**
   * The id of the author of the article. For multilingual articles, this will be the id of the author of the default language's content. Must be a teammate on the help center's workspace.
   */
  author_id?: number;
  /**
   * Whether the article is `published` or is a `draft`. For multilingual articles, this will be the state of the default language's content.
   */
  state?: 'published' | 'draft';
  /**
   * The time when the article was created. For multilingual articles, this will be the timestamp of creation of the default language's content in seconds.
   */
  created_at?: number;
  /**
   * The time when the article was last updated. For multilingual articles, this will be the timestamp of last update of the default language's content in seconds.
   */
  updated_at?: number;
  /**
   * The URL of the article. For multilingual articles, this will be the URL of the default language's content.
   */
  url?: string | null;
  /**
   * The id of the article's parent collection or section. An article without this field stands alone.
   */
  parent_id?: number | null;
  /**
   * The ids of the article's parent collections or sections. An article without this field stands alone.
   */
  parent_ids?: Array<number>;
  /**
   * The type of parent, which can either be a `collection` or `section`.
   */
  parent_type?: string | null;
  /**
   * The default locale of the help center. This field is only returned for multilingual help centers.
   */
  default_locale?: string;
  translated_content?: article_translated_content | null;
};

/**
 * The type of object - `article`.
 */
export type type4 = 'article';

/**
 * The statistics of an article.
 */
export type article_statistics = {
  /**
   * The type of object - `article_statistics`.
   */
  type?: 'article_statistics';
  /**
   * The number of total views the article has received.
   */
  views?: number;
  /**
   * The number of conversations started from the article.
   */
  conversions?: number;
  /**
   * The number of total reactions the article has received.
   */
  reactions?: number;
  /**
   * The percentage of happy reactions the article has received against other types of reaction.
   */
  happy_reaction_percentage?: number;
  /**
   * The percentage of neutral reactions the article has received against other types of reaction.
   */
  neutral_reaction_percentage?: number;
  /**
   * The percentage of sad reactions the article has received against other types of reaction.
   */
  sad_reaction_percentage?: number;
} | null;

/**
 * The type of object - `article_statistics`.
 */
export type type5 = 'article_statistics';

/**
 * The Translated Content of an Article. The keys are the locale codes and the values are the translated content of the article.
 */
export type article_translated_content = {
  /**
   * The type of object - article_translated_content.
   */
  type?: 'article_translated_content' | null;
  /**
   * The content of the article in Arabic
   */
  ar?: article_content;
  /**
   * The content of the article in Bulgarian
   */
  bg?: article_content;
  /**
   * The content of the article in Bosnian
   */
  bs?: article_content;
  /**
   * The content of the article in Catalan
   */
  ca?: article_content;
  /**
   * The content of the article in Czech
   */
  cs?: article_content;
  /**
   * The content of the article in Danish
   */
  da?: article_content;
  /**
   * The content of the article in German
   */
  de?: article_content;
  /**
   * The content of the article in Greek
   */
  el?: article_content;
  /**
   * The content of the article in English
   */
  en?: article_content;
  /**
   * The content of the article in Spanish
   */
  es?: article_content;
  /**
   * The content of the article in Estonian
   */
  et?: article_content;
  /**
   * The content of the article in Finnish
   */
  fi?: article_content;
  /**
   * The content of the article in French
   */
  fr?: article_content;
  /**
   * The content of the article in Hebrew
   */
  he?: article_content;
  /**
   * The content of the article in Croatian
   */
  hr?: article_content;
  /**
   * The content of the article in Hungarian
   */
  hu?: article_content;
  /**
   * The content of the article in Indonesian
   */
  id?: article_content;
  /**
   * The content of the article in Italian
   */
  it?: article_content;
  /**
   * The content of the article in Japanese
   */
  ja?: article_content;
  /**
   * The content of the article in Korean
   */
  ko?: article_content;
  /**
   * The content of the article in Lithuanian
   */
  lt?: article_content;
  /**
   * The content of the article in Latvian
   */
  lv?: article_content;
  /**
   * The content of the article in Mongolian
   */
  mn?: article_content;
  /**
   * The content of the article in Norwegian
   */
  nb?: article_content;
  /**
   * The content of the article in Dutch
   */
  nl?: article_content;
  /**
   * The content of the article in Polish
   */
  pl?: article_content;
  /**
   * The content of the article in Portuguese (Portugal)
   */
  pt?: article_content;
  /**
   * The content of the article in Romanian
   */
  ro?: article_content;
  /**
   * The content of the article in Russian
   */
  ru?: article_content;
  /**
   * The content of the article in Slovenian
   */
  sl?: article_content;
  /**
   * The content of the article in Serbian
   */
  sr?: article_content;
  /**
   * The content of the article in Swedish
   */
  sv?: article_content;
  /**
   * The content of the article in Turkish
   */
  tr?: article_content;
  /**
   * The content of the article in Vietnamese
   */
  vi?: article_content;
  /**
   * The content of the article in Portuguese (Brazil)
   */
  'pt-BR'?: article_content;
  /**
   * The content of the article in Chinese (China)
   */
  'zh-CN'?: article_content;
  /**
   * The content of the article in Chinese (Taiwan)
   */
  'zh-TW'?: article_content;
} | null;

/**
 * The type of object - article_translated_content.
 */
export type type6 = 'article_translated_content';

/**
 * Payload of the request to assign a conversation
 */
export type assign_conversation_request = {
  message_type: 'assignment';
  type: 'admin' | 'team';
  /**
   * The id of the admin who is performing the action.
   */
  admin_id: string;
  /**
   * The `id` of the `admin` or `team` which will be assigned the conversation. A conversation can be assigned both an admin and a team.\nSet `0` if you want this assign to no admin or team (ie. Unassigned).
   */
  assignee_id: string;
  /**
   * Optionally you can send a response in the conversation when it is assigned.
   */
  body?: string;
};

export type message_type2 = 'assignment';

export type type7 = 'admin' | 'team';

/**
 * Payload of the request to assign a conversation
 */
export type attach_contact_to_conversation_request = {
  /**
   * The `id` of the admin who is adding the new participant.
   */
  admin_id?: string;
  customer?:
    | {
        /**
         * The identifier for the contact as given by Intercom.
         */
        intercom_user_id: string;
        customer?: customer_request;
      }
    | {
        /**
         * The external_id you have defined for the contact who is being added as a participant.
         */
        user_id: string;
        customer?: customer_request;
      }
    | {
        /**
         * The email you have defined for the contact who is being added as a participant.
         */
        email: string;
        customer?: customer_request;
      };
};

/**
 * Payload of the request to close a conversation
 */
export type close_conversation_request = {
  message_type: 'close';
  type: 'admin';
  /**
   * The id of the admin who is performing the action.
   */
  admin_id: string;
  /**
   * Optionally you can leave a message in the conversation to provide additional context to the user and other teammates.
   */
  body?: string;
};

export type message_type3 = 'close';

/**
 * Collections are top level containers for Articles within the Help Center.
 */
export type collection = {
  /**
   * The unique identifier for the collection which is given by Intercom.
   */
  id?: string;
  /**
   * The id of the workspace which the collection belongs to.
   */
  workspace_id?: string;
  /**
   * The name of the collection. For multilingual collections, this will be the name of the default language's content.
   */
  name?: string;
  /**
   * The description of the collection. For multilingual help centers, this will be the description of the collection for the default language.
   */
  description?: string | null;
  /**
   * The time when the article was created (seconds). For multilingual articles, this will be the timestamp of creation of the default language's content.
   */
  created_at?: number;
  /**
   * The time when the article was last updated (seconds). For multilingual articles, this will be the timestamp of last update of the default language's content.
   */
  updated_at?: number;
  /**
   * The URL of the collection. For multilingual help centers, this will be the URL of the collection for the default language.
   */
  url?: string | null;
  /**
   * The icon of the collection.
   */
  icon?: string | null;
  /**
   * The order of the section in relation to others sections within a collection. Values go from `0` upwards. `0` is the default if there's no order.
   */
  order?: number;
  /**
   * The default locale of the help center. This field is only returned for multilingual help centers.
   */
  default_locale?: string;
  translated_content?: group_translated_content | null;
  /**
   * The id of the help center the collection is in.
   */
  help_center_id?: number | null;
  /**
   * The type of object - `collection`.
   */
  type?: 'collection';
};

/**
 * The type of object - `collection`.
 */
export type type8 = 'collection';

/**
 * This will return a list of Collections for the App.
 */
export type collection_list = {
  /**
   * The type of the object - `list`.
   */
  type?: 'list';
  pages?: cursor_pages;
  /**
   * A count of the total number of collections.
   */
  total_count?: number;
  /**
   * An array of collection objects
   */
  data?: Array<collection>;
};

/**
 * Companies allow you to represent organizations using your product. Each company will have its own description and be associated with contacts. You can fetch, create, update and list companies.
 */
export type company = {
  /**
   * Value is `company`
   */
  type?: 'company';
  /**
   * The Intercom defined id representing the company.
   */
  id?: string;
  /**
   * The name of the company.
   */
  name?: string;
  /**
   * The Intercom defined code of the workspace the company is associated to.
   */
  app_id?: string;
  plan?: {
    /**
     * Value is always "plan"
     */
    type?: string;
    /**
     * The id of the plan
     */
    id?: string;
    /**
     * The name of the plan
     */
    name?: string;
  };
  /**
   * The company id you have defined for the company.
   */
  company_id?: string;
  /**
   * The time the company was created by you.
   */
  remote_created_at?: number;
  /**
   * The time the company was added in Intercom.
   */
  created_at?: number;
  /**
   * The last time the company was updated.
   */
  updated_at?: number;
  /**
   * The time the company last recorded making a request.
   */
  last_request_at?: number;
  /**
   * The number of employees in the company.
   */
  size?: number;
  /**
   * The URL for the company website.
   */
  website?: string;
  /**
   * The industry that the company operates in.
   */
  industry?: string;
  /**
   * How much revenue the company generates for your business.
   */
  monthly_spend?: number;
  /**
   * How many sessions the company has recorded.
   */
  session_count?: number;
  /**
   * The number of users in the company.
   */
  user_count?: number;
  /**
   * The custom attributes you have set on the company.
   */
  custom_attributes?: {
    [key: string]: string;
  };
  /**
   * The list of tags associated with the company
   */
  tags?: {
    /**
     * The type of the object
     */
    type?: 'tag.list';
    tags?: Array<unknown>;
  };
  /**
   * The list of segments associated with the company
   */
  segments?: {
    /**
     * The type of the object
     */
    type?: 'segment.list';
    segments?: Array<segment>;
  };
};

/**
 * Value is `company`
 */
export type type9 = 'company';

/**
 * A list of Contact Objects
 */
export type company_attached_contacts = {
  /**
   * The type of object - `list`
   */
  type?: 'list';
  /**
   * An array containing Contact Objects
   */
  data?: Array<contact>;
  /**
   * The total number of contacts
   */
  total_count?: number;
  pages?: cursor_pages;
};

/**
 * A list of Segment Objects
 */
export type company_attached_segments = {
  /**
   * The type of object - `list`
   */
  type?: 'list';
  /**
   * An array containing Segment Objects
   */
  data?: Array<segment>;
};

/**
 * This will return a list of companies for the App.
 */
export type company_list = {
  /**
   * The type of object - `list`.
   */
  type?: 'list';
  pages?: cursor_pages;
  /**
   * The total number of companies.
   */
  total_count?: number;
  /**
   * An array containing Company Objects.
   */
  data?: Array<company>;
};

/**
 * Companies allow you to represent organizations using your product. Each company will have its own description and be associated with contacts. You can fetch, create, update and list companies.
 */
export type company_scroll = {
  /**
   * The type of object - `list`
   */
  type?: 'list';
  data?: Array<company>;
  pages?: cursor_pages;
  /**
   * The total number of companies
   */
  total_count?: number | null;
  /**
   * The scroll parameter to use in the next request to fetch the next page of results.
   */
  scroll_param?: string;
} | null;

/**
 * Contact are the objects that represent your leads and users in Intercom.
 */
export type contact = {
  /**
   * The type of object.
   */
  type?: string;
  /**
   * The unique identifier for the contact which is given by Intercom.
   */
  id?: string;
  /**
   * The unique identifier for the contact which is provided by the Client.
   */
  external_id?: string | null;
  /**
   * The id of the workspace which the contact belongs to.
   */
  workspace_id?: string;
  /**
   * The role of the contact.
   */
  role?: string;
  /**
   * The contact's email.
   */
  email?: string;
  /**
   * The contact's email domain.
   */
  email_domain?: string;
  /**
   * The contacts phone.
   */
  phone?: string | null;
  /**
   * The contacts phone number normalized to the E164 format
   */
  formatted_phone?: string | null;
  /**
   * The contacts name.
   */
  name?: string | null;
  /**
   * The id of an admin that has been assigned account ownership of the contact.
   */
  owner_id?: number | null;
  /**
   * Whether the contact has had an email sent to them hard bounce.
   */
  has_hard_bounced?: boolean;
  /**
   * Whether the contact has marked an email sent to them as spam.
   */
  marked_email_as_spam?: boolean;
  /**
   * Whether the contact is unsubscribed from emails.
   */
  unsubscribed_from_emails?: boolean;
  /**
   * (UNIX timestamp) The time when the contact was created.
   */
  created_at?: number;
  /**
   * (UNIX timestamp) The time when the contact was last updated.
   */
  updated_at?: number;
  /**
   * (UNIX timestamp) The time specified for when a contact signed up.
   */
  signed_up_at?: number | null;
  /**
   * (UNIX timestamp) The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually).
   */
  last_seen_at?: number | null;
  /**
   * (UNIX timestamp) The time when the contact last messaged in.
   */
  last_replied_at?: number | null;
  /**
   * (UNIX timestamp) The time when the contact was last messaged.
   */
  last_contacted_at?: number | null;
  /**
   * (UNIX timestamp) The time when the contact last opened an email.
   */
  last_email_opened_at?: number | null;
  /**
   * (UNIX timestamp) The time when the contact last clicked a link in an email.
   */
  last_email_clicked_at?: number | null;
  /**
   * A preferred language setting for the contact, used by the Intercom Messenger even if their browser settings change.
   */
  language_override?: string | null;
  /**
   * The name of the browser which the contact is using.
   */
  browser?: string | null;
  /**
   * The version of the browser which the contact is using.
   */
  browser_version?: string | null;
  /**
   * The language set by the browser which the contact is using.
   */
  browser_language?: string | null;
  /**
   * The operating system which the contact is using.
   */
  os?: string | null;
  /**
   * The name of the Android app which the contact is using.
   */
  android_app_name?: string | null;
  /**
   * The version of the Android app which the contact is using.
   */
  android_app_version?: string | null;
  /**
   * The Android device which the contact is using.
   */
  android_device?: string | null;
  /**
   * The version of the Android OS which the contact is using.
   */
  android_os_version?: string | null;
  /**
   * The version of the Android SDK which the contact is using.
   */
  android_sdk_version?: string | null;
  /**
   * (UNIX timestamp) The time when the contact was last seen on an Android device.
   */
  android_last_seen_at?: number | null;
  /**
   * The name of the iOS app which the contact is using.
   */
  ios_app_name?: string | null;
  /**
   * The version of the iOS app which the contact is using.
   */
  ios_app_version?: string | null;
  /**
   * The iOS device which the contact is using.
   */
  ios_device?: string | null;
  /**
   * The version of iOS which the contact is using.
   */
  ios_os_version?: string | null;
  /**
   * The version of the iOS SDK which the contact is using.
   */
  ios_sdk_version?: string | null;
  /**
   * (UNIX timestamp) The last time the contact used the iOS app.
   */
  ios_last_seen_at?: number | null;
  /**
   * The custom attributes which are set for the contact.
   */
  custom_attributes?: {
    [key: string]: unknown;
  };
  avatar?: {
    /**
     * The type of object
     */
    type?: string;
    /**
     * An image URL containing the avatar of a contact.
     */
    image_url?: string | null;
  } | null;
  tags?: contact_tags;
  notes?: contact_notes;
  companies?: contact_companies;
  location?: contact_location;
  social_profiles?: contact_social_profiles;
};

/**
 * archived contact object
 */
export type contact_archived = {
  /**
   * always contact
   */
  type?: 'contact';
  /**
   * The unique identifier for the contact which is given by Intercom.
   */
  id?: string;
  /**
   * The unique identifier for the contact which is provided by the Client.
   */
  external_id?: string | null;
  /**
   * Whether the contact is archived or not.
   */
  archived?: boolean;
};

/**
 * always contact
 */
export type type10 = 'contact';

/**
 * A list of Company Objects
 */
export type contact_attached_companies = {
  /**
   * The type of object
   */
  type?: 'list';
  /**
   * An array containing Company Objects
   */
  companies?: Array<company>;
  /**
   * The total number of companies associated to this contact
   */
  total_count?: number;
  pages?: pages_link;
};

/**
 * An object containing companies meta data about the companies that a contact has. Up to 10 will be displayed here. Use the url to get more.
 */
export type contact_companies = {
  /**
   * Url to get more company resources for this contact
   */
  url?: string;
  /**
   * Int representing the total number of companyies attached to this contact
   */
  total_count?: number;
  /**
   * Whether there's more Addressable Objects to be viewed. If true, use the url to view all
   */
  has_more?: boolean;
};

/**
 * deleted contact object
 */
export type contact_deleted = {
  /**
   * always contact
   */
  type?: 'contact';
  /**
   * The unique identifier for the contact which is given by Intercom.
   */
  id?: string;
  /**
   * The unique identifier for the contact which is provided by the Client.
   */
  external_id?: string | null;
  /**
   * Whether the contact is deleted or not.
   */
  deleted?: boolean;
};

/**
 * Contacts are your users in Intercom.
 */
export type contact_list = {
  /**
   * Always list
   */
  type?: 'list';
  /**
   * The list of contact objects
   */
  data?: Array<contact>;
  /**
   * A count of the total number of objects.
   */
  total_count?: number;
  pages?: cursor_pages;
};

/**
 * An object containing location meta data about a Intercom contact.
 */
export type contact_location = {
  /**
   * Always location
   */
  type?: string | null;
  /**
   * The country that the contact is located in
   */
  country?: string | null;
  /**
   * The overal region that the contact is located in
   */
  region?: string | null;
  /**
   * The city that the contact is located in
   */
  city?: string | null;
};

/**
 * An object containing notes meta data about the notes that a contact has. Up to 10 will be displayed here. Use the url to get more.
 */
export type contact_notes = {
  /**
   * This object represents the notes attached to a contact.
   */
  data?: Array<addressable_list>;
  /**
   * Url to get more company resources for this contact
   */
  url?: string;
  /**
   * Int representing the total number of companyies attached to this contact
   */
  total_count?: number;
  /**
   * Whether there's more Addressable Objects to be viewed. If true, use the url to view all
   */
  has_more?: boolean;
};

/**
 * reference to contact object
 */
export type contact_reference = {
  /**
   * always contact
   */
  type?: 'contact';
  /**
   * The unique identifier for the contact which is given by Intercom.
   */
  id?: string;
  /**
   * The unique identifier for the contact which is provided by the Client.
   */
  external_id?: string | null;
};

export type contact_reply_base_request = {
  message_type: 'comment';
  type: 'user';
  /**
   * The text body of the comment.
   */
  body: string;
  /**
   * A list of image URLs that will be added as attachments. You can include up to 10 URLs.
   */
  attachment_urls?: Array<string>;
};

export type message_type4 = 'comment';

export type type11 = 'user';

export type contact_reply_conversation_request =
  | contact_reply_intercom_user_id_request
  | contact_reply_email_request
  | contact_reply_user_id_request;

/**
 * Payload of the request to reply on behalf of a contact using their `email`
 */
export type contact_reply_email_request = contact_reply_base_request & {
  /**
   * The email you have defined for the user.
   */
  email: string;
  /**
   * A list of files that will be added as attachments.
   */
  attachment_files?: Array<conversation_attachment_files>;
};

/**
 * Payload of the request to reply on behalf of a contact using their `intercom_user_id`
 */
export type contact_reply_intercom_user_id_request = contact_reply_base_request & {
  /**
   * The identifier for the contact as given by Intercom.
   */
  intercom_user_id: string;
  /**
   * A list of files that will be added as attachments.
   */
  attachment_files?: Array<conversation_attachment_files>;
};

/**
 * Payload of the request to reply on behalf of a contact using their `email`
 */
export type contact_reply_ticket_email_request = contact_reply_base_request & {
  /**
   * The email you have defined for the user.
   */
  email: string;
};

/**
 * Payload of the request to reply on behalf of a contact using their `intercom_user_id`
 */
export type contact_reply_ticket_intercom_user_id_request = contact_reply_base_request & {
  /**
   * The identifier for the contact as given by Intercom.
   */
  intercom_user_id: string;
};

/**
 * Payload of the request to reply on behalf of a contact using their `user_id`
 */
export type contact_reply_ticket_user_id_request = contact_reply_base_request & {
  /**
   * The external_id you have defined for the contact.
   */
  user_id: string;
};

/**
 * Payload of the request to reply on behalf of a contact using their `user_id`
 */
export type contact_reply_user_id_request = contact_reply_base_request & {
  /**
   * The external_id you have defined for the contact.
   */
  user_id: string;
  /**
   * A list of files that will be added as attachments. You can include up to 10 files.
   */
  attachment_files?: Array<conversation_attachment_files>;
};

/**
 * A list of segments objects attached to a specific contact.
 */
export type contact_segments = {
  /**
   * The type of the object
   */
  type?: 'list';
  /**
   * Segment objects associated with the contact.
   */
  data?: Array<segment>;
};

/**
 * An object containing social profiles that a contact has.
 */
export type contact_social_profiles = {
  /**
   * A list of social profiles objects associated with the contact.
   */
  data?: Array<social_profile>;
};

/**
 * An object containing Subscription Types meta data about the SubscriptionTypes that a contact has.
 */
export type contact_subscription_types = {
  /**
   * This object represents the subscriptions attached to a contact.
   */
  data?: Array<addressable_list>;
  /**
   * Url to get more subscription type resources for this contact
   */
  url?: string;
  /**
   * Int representing the total number of subscription types attached to this contact
   */
  total_count?: number;
  /**
   * Whether there's more Addressable Objects to be viewed. If true, use the url to view all
   */
  has_more?: boolean;
};

/**
 * An object containing tags meta data about the tags that a contact has. Up to 10 will be displayed here. Use the url to get more.
 */
export type contact_tags = {
  /**
   * This object represents the tags attached to a contact.
   */
  data?: Array<addressable_list>;
  /**
   * url to get more tag resources for this contact
   */
  url?: string;
  /**
   * Int representing the total number of tags attached to this contact
   */
  total_count?: number;
  /**
   * Whether there's more Addressable Objects to be viewed. If true, use the url to view all
   */
  has_more?: boolean;
} | null;

/**
 * unarchived contact object
 */
export type contact_unarchived = {
  /**
   * always contact
   */
  type?: 'contact';
  /**
   * The unique identifier for the contact which is given by Intercom.
   */
  id?: string;
  /**
   * The unique identifier for the contact which is provided by the Client.
   */
  external_id?: string | null;
  /**
   * Whether the contact is archived or not.
   */
  archived?: boolean;
};

/**
 * Conversations are how you can communicate with users in Intercom. They are created when a contact replies to an outbound message, or when one admin directly sends a message to a single contact.
 */
export type conversation = {
  /**
   * Always conversation.
   */
  type?: string;
  /**
   * The id representing the conversation.
   */
  id?: string;
  /**
   * The title given to the conversation.
   */
  title?: string | null;
  /**
   * The time the conversation was created.
   */
  created_at?: number;
  /**
   * The last time the conversation was updated.
   */
  updated_at?: number;
  /**
   * The last time a Contact responded to an Admin. In other words, the time a customer started waiting for a response. Set to null if last reply is from an Admin.
   */
  waiting_since?: number | null;
  /**
   * If set this is the time in the future when this conversation will be marked as open. i.e. it will be in a snoozed state until this time. i.e. it will be in a snoozed state until this time.
   */
  snoozed_until?: number | null;
  /**
   * Indicates whether a conversation is open (true) or closed (false).
   */
  open?: boolean;
  /**
   * Can be set to "open", "closed" or "snoozed".
   */
  state?: 'open' | 'closed' | 'snoozed';
  /**
   * Indicates whether a conversation has been read.
   */
  read?: boolean;
  /**
   * If marked as priority, it will return priority or else not_priority.
   */
  priority?: 'priority' | 'not_priority';
  /**
   * The id of the admin assigned to the conversation. If it's not assigned to an admin it will return null.
   */
  admin_assignee_id?: number | null;
  /**
   * The id of the team assigned to the conversation. If it's not assigned to a team it will return null.
   */
  team_assignee_id?: string | null;
  tags?: tags;
  conversation_rating?: conversation_rating;
  source?: conversation_source;
  contacts?: conversation_contacts;
  teammates?: conversation_teammates;
  custom_attributes?: custom_attributes;
  first_contact_reply?: conversation_first_contact_reply;
  sla_applied?: sla_applied;
  statistics?: conversation_statistics;
  conversation_parts?: conversation_parts;
};

/**
 * Can be set to "open", "closed" or "snoozed".
 */
export type state2 = 'open' | 'closed' | 'snoozed';

/**
 * If marked as priority, it will return priority or else not_priority.
 */
export type priority = 'priority' | 'not_priority';

/**
 * Properties of the attachment files in a conversation part
 */
export type conversation_attachment_files = {
  /**
   * The content type of the file
   */
  content_type?: string;
  /**
   * The base64 encoded file data.
   */
  data?: string;
  /**
   * The name of the file.
   */
  name?: string;
};

/**
 * The list of contacts (users or leads) involved in this conversation. This will only contain one customer unless more were added via the group conversation feature.
 */
export type conversation_contacts = {
  type?: 'contact.list';
  /**
   * The list of contacts (users or leads) involved in this conversation. This will only contain one customer unless more were added via the group conversation feature.
   */
  contacts?: Array<contact_reference>;
};

export type type12 = 'contact.list';

/**
 * An object containing information on the first users message. For a contact initiated message this will represent the users original message.
 */
export type conversation_first_contact_reply = {
  created_at?: number;
  type?: string;
  url?: string | null;
} | null;

/**
 * Conversations are how you can communicate with users in Intercom. They are created when a contact replies to an outbound message, or when one admin directly sends a message to a single contact.
 */
export type conversation_list = {
  /**
   * Always conversation.list
   */
  type?: 'conversation.list';
  /**
   * The list of conversation objects
   */
  conversations?: Array<conversation>;
  /**
   * A count of the total number of objects.
   */
  total_count?: number;
  pages?: cursor_pages;
};

/**
 * Always conversation.list
 */
export type type13 = 'conversation.list';

/**
 * A Conversation Part represents a message in the conversation.
 */
export type conversation_part = {
  /**
   * Always conversation_part
   */
  type?: string;
  /**
   * The id representing the conversation part.
   */
  id?: string;
  /**
   * The type of conversation part.
   */
  part_type?: string;
  /**
   * The message body, which may contain HTML. For Twitter, this will show a generic message regarding why the body is obscured.
   */
  body?: string | null;
  /**
   * The time the conversation part was created.
   */
  created_at?: number;
  /**
   * The last time the conversation part was updated.
   */
  updated_at?: number;
  /**
   * The time the user was notified with the conversation part.
   */
  notified_at?: number;
  /**
   * The id of the admin that was assigned the conversation by this conversation_part (null if there has been no change in assignment.)
   */
  assigned_to?: reference | null;
  author?: conversation_part_author;
  /**
   * A list of attachments for the part.
   */
  attachments?: Array<part_attachment>;
  /**
   * The external id of the conversation part
   */
  external_id?: string | null;
  /**
   * Whether or not the conversation part has been redacted.
   */
  redacted?: boolean;
};

/**
 * The object who initiated the conversation, which can be a Contact, Admin or Team. Bots and campaigns send messages on behalf of Admins or Teams. For Twitter, this will be blank.
 */
export type conversation_part_author = {
  /**
   * The type of the author
   */
  type?: string;
  /**
   * The id of the author
   */
  id?: string;
  /**
   * The name of the author
   */
  name?: string;
  /**
   * The email of the author
   */
  email?: string;
};

/**
 * A list of Conversation Part objects for each part message in the conversation. This is only returned when Retrieving a Conversation, and ignored when Listing all Conversations. There is a limit of 500 parts.
 */
export type conversation_parts = {
  type?: 'conversation_part.list';
  /**
   * A list of Conversation Part objects for each part message in the conversation. This is only returned when Retrieving a Conversation, and ignored when Listing all Conversations. There is a limit of 500 parts.
   */
  conversation_parts?: Array<conversation_part>;
  total_count?: number;
};

export type type14 = 'conversation_part.list';

/**
 * The Conversation Rating object which contains information on the rating and/or remark added by a Contact and the Admin assigned to the conversation.
 */
export type conversation_rating = {
  /**
   * The rating, between 1 and 5, for the conversation.
   */
  rating?: number;
  /**
   * An optional field to add a remark to correspond to the number rating
   */
  remark?: string;
  /**
   * The time the rating was requested in the conversation being rated.
   */
  created_at?: number;
  contact?: contact_reference;
  teammate?: reference;
} | null;

/**
 * The Conversation Part that originated this conversation, which can be Contact, Admin, Campaign, Automated or Operator initiated.
 */
export type conversation_source = {
  /**
   * This includes conversation, email, facebook, instagram, phone_call, phone_switch, push, sms, twitter and whatsapp.
   */
  type?: string;
  /**
   * The id representing the message.
   */
  id?: string;
  /**
   * The conversation's initiation type. Possible values are customer_initiated, campaigns_initiated (legacy campaigns), operator_initiated (Custom bot), automated (Series and other outbounds with dynamic audience message) and admin_initiated (fixed audience message, ticket initiated by an admin, group email).
   */
  delivered_as?: string;
  /**
   * Optional. The message subject. For Twitter, this will show a generic message regarding why the subject is obscured.
   */
  subject?: string;
  /**
   * The message body, which may contain HTML. For Twitter, this will show a generic message regarding why the body is obscured.
   */
  body?: string;
  author?: conversation_part_author;
  /**
   * A list of attachments for the part.
   */
  attachments?: Array<part_attachment>;
  /**
   * The URL where the conversation was started. For Twitter, Email, and Bots, this will be blank.
   */
  url?: string | null;
  /**
   * Whether or not the source message has been redacted. Only applicable for contact initiated messages.
   */
  redacted?: boolean;
};

/**
 * A Statistics object containing all information required for reporting, with timestamps and calculated metrics.
 */
export type conversation_statistics = {
  type?: string;
  /**
   * Duration until last assignment before first admin reply. In seconds.
   */
  time_to_assignment?: number;
  /**
   * Duration until first admin reply. Subtracts out of business hours. In seconds.
   */
  time_to_admin_reply?: number;
  /**
   * Duration until conversation was closed first time. Subtracts out of business hours. In seconds.
   */
  time_to_first_close?: number;
  /**
   * Duration until conversation was closed last time. Subtracts out of business hours. In seconds.
   */
  time_to_last_close?: number;
  /**
   * Median based on all admin replies after a contact reply. Subtracts out of business hours. In seconds.
   */
  median_time_to_reply?: number;
  /**
   * Time of first text conversation part from a contact.
   */
  first_contact_reply_at?: number;
  /**
   * Time of first assignment after first_contact_reply_at.
   */
  first_assignment_at?: number;
  /**
   * Time of first admin reply after first_contact_reply_at.
   */
  first_admin_reply_at?: number;
  /**
   * Time of first close after first_contact_reply_at.
   */
  first_close_at?: number;
  /**
   * Time of last assignment after first_contact_reply_at.
   */
  last_assignment_at?: number;
  /**
   * Time of first admin reply since most recent assignment.
   */
  last_assignment_admin_reply_at?: number;
  /**
   * Time of the last conversation part from a contact.
   */
  last_contact_reply_at?: number;
  /**
   * Time of the last conversation part from an admin.
   */
  last_admin_reply_at?: number;
  /**
   * Time of the last conversation close.
   */
  last_close_at?: number;
  /**
   * The last admin who closed the conversation. Returns a reference to an Admin object.
   */
  last_closed_by_id?: string;
  /**
   * Number of reopens after first_contact_reply_at.
   */
  count_reopens?: number;
  /**
   * Number of assignments after first_contact_reply_at.
   */
  count_assignments?: number;
  /**
   * Total number of conversation parts.
   */
  count_conversation_parts?: number;
} | null;

/**
 * The list of teammates who participated in the conversation (wrote at least one conversation part).
 */
export type conversation_teammates = {
  /**
   * The type of the object - `admin.list`.
   */
  type?: string;
  /**
   * The list of teammates who participated in the conversation (wrote at least one conversation part).
   */
  teammates?: Array<reference>;
} | null;

/**
 * You can merge a Visitor to a Contact of role type lead or user.
 */
export type convert_visitor_request = {
  /**
   * Represents the role of the Contact model. Accepts `lead` or `user`.
   */
  type: string;
  /**
   * The unique identifiers retained after converting or merging.
   */
  user: {
    /**
     * The unique identifier for the contact which is given by Intercom.
     */
    id?: string;
    /**
     * A unique identifier for the contact which is given to Intercom, which will be represented as external_id.
     */
    user_id?: string;
    /**
     * The contact's email, retained by default if one is present.
     */
    email?: string;
  };
  /**
   * The unique identifiers to convert a single Visitor.
   */
  visitor: {
    /**
     * The unique identifier for the contact which is given by Intercom.
     */
    id?: string;
    /**
     * A unique identifier for the contact which is given to Intercom.
     */
    user_id?: string;
    /**
     * The visitor's email.
     */
    email?: string;
  };
};

/**
 * You can create an Article
 */
export type create_article_request = {
  /**
   * The title of the article.For multilingual articles, this will be the title of the default language's content.
   */
  title: string;
  /**
   * The description of the article. For multilingual articles, this will be the description of the default language's content.
   */
  description?: string;
  /**
   * The content of the article. For multilingual articles, this will be the body of the default language's content.
   */
  body?: string;
  /**
   * The id of the author of the article. For multilingual articles, this will be the id of the author of the default language's content. Must be a teammate on the help center's workspace.
   */
  author_id: number;
  /**
   * Whether the article will be `published` or will be a `draft`. Defaults to draft. For multilingual articles, this will be the state of the default language's content.
   */
  state?: 'published' | 'draft';
  /**
   * The id of the article's parent collection or section. An article without this field stands alone.
   */
  parent_id?: number;
  /**
   * The type of parent, which can either be a `collection` or `section`.
   */
  parent_type?: string;
  translated_content?: article_translated_content;
} | null;

/**
 * You can create a collection
 */
export type create_collection_request = {
  /**
   * The name of the collection. For multilingual collections, this will be the name of the default language's content.
   */
  name: string;
  /**
   * The description of the collection. For multilingual collections, this will be the description of the default language's content.
   */
  description?: string;
  translated_content?: group_translated_content | null;
  /**
   * The id of the help center where the collection will be created. If `null` then it will be created in the default help center.
   */
  help_center_id?: number | null;
};

/**
 * Payload to create a contact
 */
export type create_contact_request = {
  /**
   * The role of the contact.
   */
  role?: string;
  /**
   * A unique identifier for the contact which is given to Intercom
   */
  external_id?: string;
  /**
   * The contacts email
   */
  email?: string;
  /**
   * The contacts phone
   */
  phone?: string | null;
  /**
   * The contacts name
   */
  name?: string | null;
  /**
   * An image URL containing the avatar of a contact
   */
  avatar?: string | null;
  /**
   * The time specified for when a contact signed up
   */
  signed_up_at?: number | null;
  /**
   * The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)
   */
  last_seen_at?: number | null;
  /**
   * The id of an admin that has been assigned account ownership of the contact
   */
  owner_id?: number | null;
  /**
   * Whether the contact is unsubscribed from emails
   */
  unsubscribed_from_emails?: boolean | null;
  /**
   * The custom attributes which are set for the contact
   */
  custom_attributes?: {
    [key: string]: unknown;
  } | null;
};

/**
 * Conversations are how you can communicate with users in Intercom. They are created when a contact replies to an outbound message, or when one admin directly sends a message to a single contact.
 */
export type create_conversation_request = {
  from: {
    /**
     * The role associated to the contact - user or lead.
     */
    type: 'lead' | 'user' | 'contact';
    /**
     * The identifier for the contact which is given by Intercom.
     */
    id: string;
  };
  /**
   * The content of the message. HTML is not supported.
   */
  body: string;
};

/**
 * The role associated to the contact - user or lead.
 */
export type type15 = 'lead' | 'user' | 'contact';

export type create_data_attribute_request = {
  /**
   * The name of the data attribute.
   */
  name: string;
  /**
   * The model that the data attribute belongs to.
   */
  model: 'contact' | 'company';
  /**
   * The type of data stored for this attribute.
   */
  data_type: 'string' | 'integer' | 'float' | 'boolean' | 'datetime' | 'date';
  /**
   * The readable description you see in the UI for the attribute.
   */
  description?: string;
  /**
   * To create list attributes. Provide a set of hashes with `value` as the key of the options you want to make. `data_type` must be `string`.
   */
  options?: Array<string>;
  /**
   * Can this attribute be updated by the Messenger
   */
  messenger_writable?: boolean;
};

/**
 * The model that the data attribute belongs to.
 */
export type model = 'contact' | 'company';

/**
 * The type of data stored for this attribute.
 */
export type data_type = 'string' | 'integer' | 'float' | 'boolean' | 'datetime' | 'date';

export type create_data_event_request = {
  /**
   * The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example `updated-plan`.
   */
  event_name?: string;
  /**
   * The time the event occurred as a UTC Unix timestamp
   */
  created_at?: number;
  /**
   * Your identifier for the user.
   */
  user_id?: string;
  /**
   * The unique identifier for the contact (lead or user) which is given by Intercom.
   */
  id?: string;
  /**
   * An email address for your user. An email should only be used where your application uses email to uniquely identify users.
   */
  email?: string;
  /**
   * Optional metadata about the event.
   */
  metadata?: {
    [key: string]: string;
  };
};

/**
 * You can send a list of event summaries for a user. Each event summary should contain the event name, the time the event occurred, and the number of times the event occurred. The event name should be a past tense "verb-noun" combination, to improve readability, for example `updated-plan`.
 */
export type create_data_event_summaries_request = {
  /**
   * Your identifier for the user.
   */
  user_id?: string;
  /**
   * A list of event summaries for the user. Each event summary should contain the event name, the time the event occurred, and the number of times the event occurred. The event name should be a past tense 'verb-noun' combination, to improve readability, for example `updated-plan`.
   */
  event_summaries?: {
    /**
     * The name of the event that occurred. A good event name is typically a past tense 'verb-noun' combination, to improve readability, for example `updated-plan`.
     */
    event_name?: string;
    /**
     * The number of times the event occurred.
     */
    count?: number;
    /**
     * The first time the event was sent
     */
    first?: number;
    /**
     * The last time the event was sent
     */
    last?: number;
  };
};

/**
 * Request for creating a data export
 */
export type create_data_exports_request = {
  /**
   * The start date that you request data for. It must be formatted as a unix timestamp.
   */
  created_at_after: number;
  /**
   * The end date that you request data for. It must be formatted as a unix timestamp.
   */
  created_at_before: number;
};

/**
 * You can create a message
 */
export type create_message_request = {
  /**
   * The kind of message being created. Values: `in_app` or `email`.
   */
  message_type?: 'in_app' | 'email';
  /**
   * The title of the email.
   */
  subject?: string;
  /**
   * The content of the message. HTML and plaintext are supported.
   */
  body?: string;
  /**
   * The style of the outgoing message. Possible values `plain` or `personal`.
   */
  template?: string;
  /**
   * The sender of the message. If not provided, the default sender will be used.
   */
  from?: {
    /**
     * Always `admin`.
     */
    type: 'admin';
    /**
     * The identifier for the admin which is given by Intercom.
     */
    id: number;
  };
  /**
   * The sender of the message. If not provided, the default sender will be used.
   */
  to?: {
    /**
     * The role associated to the contact - `user` or `lead`.
     */
    type: 'user' | 'lead';
    /**
     * The identifier for the contact which is given by Intercom.
     */
    id: string;
  };
  /**
   * Whether a conversation should be opened in the inbox for the message without the contact replying. Defaults to false if not provided.
   */
  create_conversation_without_contact_reply?: boolean;
} | null;

/**
 * The kind of message being created. Values: `in_app` or `email`.
 */
export type message_type5 = 'in_app' | 'email';

/**
 * You can create or update a Company
 */
export type create_or_update_company_request = {
  /**
   * The name of the Company
   */
  name?: string;
  /**
   * The company id you have defined for the company. Can't be updated
   */
  company_id?: string;
  /**
   * The name of the plan you have associated with the company.
   */
  plan?: string;
  /**
   * The number of employees in this company.
   */
  size?: number;
  /**
   * The URL for this company's website. Please note that the value specified here is not validated. Accepts any string.
   */
  website?: string;
  /**
   * The industry that this company operates in.
   */
  industry?: string;
  /**
   * A hash of key/value pairs containing any other data about the company you want Intercom to store.
   */
  custom_attributes?: {
    [key: string]: string;
  };
  /**
   * The time the company was created by you.
   */
  remote_created_at?: number;
  /**
   * How much revenue the company generates for your business. Note that this will truncate floats. i.e. it only allow for whole integers, 155.98 will be truncated to 155. Note that this has an upper limit of 2**31-1 or 2147483647..
   */
  monthly_spend?: number;
} | null;

/**
 * You can create or update an existing tag.
 */
export type create_or_update_tag_request = {
  /**
   * The name of the tag, which will be created if not found, or the new name for the tag if this is an update request. Names are case insensitive.
   */
  name: string;
  /**
   * The id of tag to updates.
   */
  id?: string;
};

/**
 * You can create an phone switch
 */
export type create_phone_switch_request = {
  /**
   * Phone number in E.164 format, that will receive the SMS to continue the conversation in the Messenger.
   */
  phone: string;
  custom_attributes?: custom_attributes;
} | null;

/**
 * You can create a Section
 */
export type create_section_request = {
  /**
   * The name of the collection. For multilingual collections, this will be the name of the default language's content.
   */
  name: string;
  /**
   * The id for the collection this section will be within.
   */
  parent_id: number;
  translated_content?: group_translated_content | null;
};

export type create_ticket_reply_request = {
  /**
   * The message body of the note, which may contain HTML.
   */
  body: string;
  /**
   * The type of the reply. Only `note` is supported at the moment.
   */
  message_type?: string;
  /**
   * The id of the admin who is making the note.
   */
  admin_id: string;
};

/**
 * You can create a Ticket
 */
export type create_ticket_request = {
  /**
   * The ID of the type of ticket you want to create
   */
  ticket_type_id: string;
  /**
   * The list of contacts (users or leads) affected by this ticket. Currently only one is allowed
   */
  contacts: Array<
    | {
        /**
         * The identifier for the contact as given by Intercom.
         */
        id: string;
      }
    | {
        /**
         * The external_id you have defined for the contact who is being added as a participant.
         */
        external_id: string;
      }
    | {
        /**
         * The email you have defined for the contact who is being added as a participant. If a contact with this email does not exist, one will be created.
         */
        email: string;
      }
  >;
  /**
   * The ID of the company that the ticket is associated with. The ID that you set upon company creation.
   */
  company_id?: string;
  ticket_attributes?: ticket_request_custom_attributes;
};

/**
 * You can create a Ticket Type Attribute
 */
export type create_ticket_type_attribute_request = {
  /**
   * The name of the ticket type attribute
   */
  name: string;
  /**
   * The description of the attribute presented to the teammate or contact
   */
  description: string;
  /**
   * The data type of the attribute
   */
  data_type: 'string' | 'list' | 'integer' | 'decimal' | 'boolean' | 'datetime' | 'files';
  /**
   * Whether the attribute is required to be filled in when teammates are creating the ticket in Inbox.
   */
  required_to_create?: boolean;
  /**
   * Whether the attribute is required to be filled in when contacts are creating the ticket in Messenger.
   */
  required_to_create_for_contacts?: boolean;
  /**
   * Whether the attribute is visible to teammates when creating a ticket in Inbox.
   */
  visible_on_create?: boolean;
  /**
   * Whether the attribute is visible to contacts when creating a ticket in Messenger.
   */
  visible_to_contacts?: boolean;
  /**
   * Whether the attribute allows multiple lines of text (only applicable to string attributes)
   */
  multiline?: boolean;
  /**
   * A comma delimited list of items for the attribute value (only applicable to list attributes)
   */
  list_items?: string;
  /**
   * Whether the attribute allows multiple files to be attached to it (only applicable to file attributes)
   */
  allow_multiple_values?: boolean;
};

/**
 * The data type of the attribute
 */
export type data_type2 = 'string' | 'list' | 'integer' | 'decimal' | 'boolean' | 'datetime' | 'files';

/**
 * The request payload for creating a ticket type.
 * You can copy the `icon` property for your ticket type from [Twemoji Cheatsheet](https://twemoji-cheatsheet.vercel.app/)
 *
 */
export type create_ticket_type_request = {
  /**
   * The name of the ticket type.
   */
  name: string;
  /**
   * The description of the ticket type.
   */
  description?: string;
  /**
   * The icon of the ticket type.
   */
  icon?: string;
  /**
   * Whether the tickets associated with this ticket type are intended for internal use only or will be shared with customers. This is currently a limited attribute.
   */
  is_internal?: boolean;
} | null;

/**
 * Cursor-based pagination is a technique used in the Intercom API to navigate through large amounts of data.
 * A "cursor" or pointer is used to keep track of the current position in the result set, allowing the API to return the data in small chunks or "pages" as needed.
 *
 */
export type cursor_pages = {
  /**
   * the type of object `pages`.
   */
  type?: 'pages';
  /**
   * The current page
   */
  page?: number;
  next?: starting_after_paging;
  /**
   * Number of results per page
   */
  per_page?: number;
  /**
   * Total number of pages
   */
  total_pages?: number;
} | null;

/**
 * the type of object `pages`.
 */
export type type16 = 'pages';

/**
 * An object containing the different custom attributes associated to the conversation as key-value pairs. For relationship attributes the value will be a list of custom object instance models.
 */
export type custom_attributes = {
  [key: string]: string | custom_object_instance;
};

/**
 * A Custom Object Instance represents an instance of a custom object type. This allows you to create and set custom attributes to store data about your customers that is not already captured by Intercom. The parent object includes recommended default attributes and you can add your own custom attributes.
 */
export type custom_object_instance = {
  /**
   * The Intercom defined id representing the custom object instance.
   */
  id?: string;
  /**
   * The id you have defined for the custom object instance.
   */
  external_id?: string;
  /**
   * The identifier of the custom object type that defines the structure of the custom object instance.
   */
  type?: string;
  /**
   * The custom attributes you have set on the custom object instance.
   */
  custom_attributes?: {
    [key: string]: string;
  };
} | null;

export type customer_request =
  | (
      | {
          /**
           * The identifier for the contact as given by Intercom.
           */
          intercom_user_id: string;
        }
      | {
          /**
           * The external_id you have defined for the contact who is being added as a participant.
           */
          user_id: string;
        }
      | {
          /**
           * The email you have defined for the contact who is being added as a participant.
           */
          email: string;
        }
    )
  | null;

/**
 * Data Attributes are metadata used to describe your contact, company and conversation models. These include standard and custom attributes. By using the data attributes endpoint, you can get the global list of attributes for your workspace, as well as create and archive custom attributes.
 */
export type data_attribute = {
  /**
   * Value is `data_attribute`.
   */
  type?: 'data_attribute';
  /**
   * The unique identifier for the data attribute which is given by Intercom. Only available for custom attributes.
   */
  id?: number;
  /**
   * Value is `contact` for user/lead attributes and `company` for company attributes.
   */
  model?: 'contact' | 'company';
  /**
   * Name of the attribute.
   */
  name?: string;
  /**
   * Full name of the attribute. Should match the name unless it's a nested attribute. We can split full_name on `.` to access nested user object values.
   */
  full_name?: string;
  /**
   * Readable name of the attribute (i.e. name you see in the UI)
   */
  label?: string;
  /**
   * Readable description of the attribute.
   */
  description?: string;
  /**
   * The data type of the attribute.
   */
  data_type?: 'string' | 'integer' | 'float' | 'boolean' | 'date';
  /**
   * List of predefined options for attribute value.
   */
  options?: Array<string>;
  /**
   * Can this attribute be updated through API
   */
  api_writable?: boolean;
  /**
   * Can this attribute be updated by the Messenger
   */
  messenger_writable?: boolean;
  /**
   * Can this attribute be updated in the UI
   */
  ui_writable?: boolean;
  /**
   * Set to true if this is a CDA
   */
  custom?: boolean;
  /**
   * Is this attribute archived. (Only applicable to CDAs)
   */
  archived?: boolean;
  /**
   * The time the attribute was created as a UTC Unix timestamp
   */
  created_at?: number;
  /**
   * The time the attribute was last updated as a UTC Unix timestamp
   */
  updated_at?: number;
  /**
   * Teammate who created the attribute. Only applicable to CDAs
   */
  admin_id?: string;
};

/**
 * Value is `data_attribute`.
 */
export type type17 = 'data_attribute';

/**
 * The data type of the attribute.
 */
export type data_type3 = 'string' | 'integer' | 'float' | 'boolean' | 'date';

/**
 * A list of all data attributes belonging to a workspace for contacts, companies or conversations.
 */
export type data_attribute_list = {
  /**
   * The type of the object
   */
  type?: 'list';
  /**
   * A list of data attributes
   */
  data?: Array<data_attribute>;
};

/**
 * Data events are used to notify Intercom of changes to your data.
 */
export type data_event = {
  /**
   * The type of the object
   */
  type?: 'event';
  /**
   * The name of the event that occurred. This is presented to your App's admins when filtering and creating segments - a good event name is typically a past tense 'verb-noun' combination, to improve readability, for example `updated-plan`.
   */
  event_name: string;
  /**
   * The time the event occurred as a UTC Unix timestamp
   */
  created_at: number;
  /**
   * Your identifier for the user.
   */
  user_id?: string;
  /**
   * Your identifier for a lead or a user.
   */
  id?: string;
  /**
   * The Intercom identifier for the user.
   */
  intercom_user_id?: string;
  /**
   * An email address for your user. An email should only be used where your application uses email to uniquely identify users.
   */
  email?: string;
  /**
   * Optional metadata about the event.
   */
  metadata?: {
    [key: string]: string;
  };
};

/**
 * The type of the object
 */
export type type18 = 'event';

/**
 * This will return a list of data events for the App.
 */
export type data_event_list = {
  /**
   * The type of the object
   */
  type?: 'event.list';
  /**
   * A list of data events
   */
  events?: Array<data_event>;
  /**
   * Pagination
   */
  pages?: {
    next?: string;
    since?: string;
  };
};

/**
 * The type of the object
 */
export type type19 = 'event.list';

/**
 * This will return a summary of data events for the App.
 */
export type data_event_summary = {
  /**
   * The type of the object
   */
  type?: 'event.summary';
  /**
   * The email address of the user
   */
  email?: string;
  /**
   * The Intercom user ID of the user
   */
  intercom_user_id?: string;
  /**
   * The user ID of the user
   */
  user_id?: string;
  /**
   * A summary of data events
   */
  events?: Array<data_event_summary_item>;
};

/**
 * The type of the object
 */
export type type20 = 'event.summary';

/**
 * This will return a summary of a data event for the App.
 */
export type data_event_summary_item = {
  /**
   * The name of the event
   */
  name?: string;
  /**
   * The first time the event was sent
   */
  first?: string;
  /**
   * The last time the event was sent
   */
  last?: string;
  /**
   * The number of times the event was sent
   */
  count?: number;
  /**
   * The description of the event
   */
  description?: string;
} | null;

/**
 * The data export api is used to view all message sent & viewed in a given timeframe.
 */
export type data_export = {
  /**
   * The identifier for your job.
   */
  job_identfier?: string;
  /**
   * The current state of your job.
   */
  status?: 'pending' | 'in_progress' | 'failed' | 'completed' | 'no_data' | 'canceled';
  /**
   * The time after which you will not be able to access the data.
   */
  download_expires_at?: string;
  /**
   * The location where you can download your data.
   */
  download_url?: string;
};

/**
 * The current state of your job.
 */
export type status = 'pending' | 'in_progress' | 'failed' | 'completed' | 'no_data' | 'canceled';

/**
 * A CSV output file
 */
export type data_export_csv = {
  /**
   * The user_id of the user who was sent the message.
   */
  user_id?: string;
  /**
   * The external_user_id of the user who was sent the message
   */
  user_external_id?: string;
  /**
   * The company ID of the user in relation to the message that was sent. Will return -1 if no company is present.
   */
  company_id?: string;
  /**
   * The users email who was sent the message.
   */
  email?: string;
  /**
   * The full name of the user receiving the message
   */
  name?: string;
  /**
   * The id of the message.
   */
  ruleset_id?: string;
  /**
   * The specific content that was received. In an A/B test each version has its own Content ID.
   */
  content_id?: string;
  /**
   * Email, Chat, Post etc.
   */
  content_type?: string;
  /**
   * The title of the content you see in your Intercom workspace.
   */
  content_title?: string;
  /**
   * As you edit content we record new versions. This ID can help you determine which version of a piece of content that was received.
   */
  ruleset_version_id?: string;
  /**
   * ID for this receipt. Will be included with any related stats in other files to identify this specific delivery of a message.
   */
  receipt_id?: string;
  /**
   * Timestamp for when the receipt was recorded.
   */
  received_at?: number;
  /**
   * The id of the series that this content is part of. Will return -1 if not part of a series.
   */
  series_id?: string;
  /**
   * The title of the series that this content is part of.
   */
  series_title?: string;
  /**
   * The id of the series node that this ruleset is associated with. Each block in a series has a corresponding node_id.
   */
  node_id?: string;
  /**
   * The first time a user replied to this message if the content was able to receive replies.
   */
  first_reply?: number;
  /**
   * The first time a user completed this message if the content was able to be completed e.g. Tours, Surveys.
   */
  first_completion?: number;
  /**
   * The first time the series this message was a part of was completed by the user.
   */
  first_series_completion?: number;
  /**
   * The first time the series this message was a part of was disengaged by the user.
   */
  first_series_disengagement?: number;
  /**
   * The first time the series this message was a part of was exited by the user.
   */
  first_series_exit?: number;
  /**
   * The first time the user met this messages associated goal if one exists.
   */
  first_goal_success?: number;
  /**
   * The first time the user opened this message.
   */
  first_open?: number;
  /**
   * The first time the series the user clicked on a link within this message.
   */
  first_click?: number;
  /**
   * The first time the series the user dismissed this message.
   */
  first_dismisall?: number;
  /**
   * The first time the user unsubscribed from this message.
   */
  first_unsubscribe?: number;
  /**
   * The first time this message hard bounced for this user
   */
  first_hard_bounce?: number;
};

/**
 * Response returned when an object is deleted
 */
export type deleted_article_object = {
  /**
   * The unique identifier for the article which you provided in the URL.
   */
  id?: string;
  /**
   * The type of object which was deleted. - article
   */
  object?: 'article';
  /**
   * Whether the article was deleted successfully or not.
   */
  deleted?: boolean;
};

/**
 * The type of object which was deleted. - article
 */
export type intercomObject = 'article';

/**
 * Response returned when an object is deleted
 */
export type deleted_collection_object = {
  /**
   * The unique identifier for the collection which you provided in the URL.
   */
  id?: string;
  /**
   * The type of object which was deleted. - `collection`
   */
  object?: 'collection';
  /**
   * Whether the collection was deleted successfully or not.
   */
  deleted?: boolean;
};

/**
 * The type of object which was deleted. - `collection`
 */
export type object2 = 'collection';

/**
 * Response returned when an object is deleted
 */
export type deleted_company_object = {
  /**
   * The unique identifier for the company which is given by Intercom.
   */
  id?: string;
  /**
   * The type of object which was deleted. - `company`
   */
  object?: 'company';
  /**
   * Whether the company was deleted successfully or not.
   */
  deleted?: boolean;
};

/**
 * The type of object which was deleted. - `company`
 */
export type object3 = 'company';

/**
 * Response returned when an object is deleted
 */
export type deleted_object = {
  /**
   * The unique identifier for the news item which you provided in the URL.
   */
  id?: string;
  /**
   * The type of object which was deleted - news-item.
   */
  object?: 'news-item';
  /**
   * Whether the news item was deleted successfully or not.
   */
  deleted?: boolean;
};

/**
 * The type of object which was deleted - news-item.
 */
export type object4 = 'news-item';

/**
 * Response returned when an object is deleted
 */
export type deleted_section_object = {
  /**
   * The unique identifier for the section which you provided in the URL.
   */
  id?: string;
  /**
   * The type of object which was deleted. - `section`
   */
  object?: 'section';
  /**
   * Whether the section was deleted successfully or not.
   */
  deleted?: boolean;
};

/**
 * The type of object which was deleted. - `section`
 */
export type object5 = 'section';

export type detach_contact_from_conversation_request = {
  /**
   * The `id` of the admin who is performing the action.
   */
  admin_id: string;
};

/**
 * The API will return an Error List for a failed request, which will contain one or more Error objects.
 */
export type error = {
  /**
   * The type is error.list
   */
  type: string;
  request_id?: string | null;
  /**
   * An array of one or more error objects
   */
  errors: Array<{
    /**
     * A string indicating the kind of error, used to further qualify the HTTP response code
     */
    code: string;
    /**
     * Optional. Human readable description of the error.
     */
    message?: string | null;
    /**
     * Optional. Used to identify a particular field or query parameter that was in error.
     */
    field?: string | null;
  }>;
};

/**
 * The value describing a file upload set for a custom attribute
 */
export type file_attribute = {
  type?: string;
  /**
   * The name of the file
   */
  name?: string;
  /**
   * The url of the file. This is a temporary URL and will expire after 30 minutes.
   */
  url?: string;
  /**
   * The type of file
   */
  content_type?: string;
  /**
   * The size of the file in bytes
   */
  filesize?: number;
  /**
   * The width of the file in pixels, if applicable
   */
  width?: number;
  /**
   * The height of the file in pixels, if applicable
   */
  height?: number;
};

/**
 * The Content of a Group.
 */
export type group_content = {
  /**
   * The type of object - `group_content` .
   */
  type?: 'group_content' | null;
  /**
   * The name of the collection or section.
   */
  name?: string;
  /**
   * The description of the collection. Only available for collections.
   */
  description?: string;
} | null;

/**
 * The type of object - `group_content` .
 */
export type type21 = 'group_content';

/**
 * The Translated Content of an Group. The keys are the locale codes and the values are the translated content of the Group.
 */
export type group_translated_content = {
  /**
   * The type of object - group_translated_content.
   */
  type?: 'group_translated_content' | null;
  /**
   * The content of the group in Arabic
   */
  ar?: group_content;
  /**
   * The content of the group in Bulgarian
   */
  bg?: group_content;
  /**
   * The content of the group in Bosnian
   */
  bs?: group_content;
  /**
   * The content of the group in Catalan
   */
  ca?: group_content;
  /**
   * The content of the group in Czech
   */
  cs?: group_content;
  /**
   * The content of the group in Danish
   */
  da?: group_content;
  /**
   * The content of the group in German
   */
  de?: group_content;
  /**
   * The content of the group in Greek
   */
  el?: group_content;
  /**
   * The content of the group in English
   */
  en?: group_content;
  /**
   * The content of the group in Spanish
   */
  es?: group_content;
  /**
   * The content of the group in Estonian
   */
  et?: group_content;
  /**
   * The content of the group in Finnish
   */
  fi?: group_content;
  /**
   * The content of the group in French
   */
  fr?: group_content;
  /**
   * The content of the group in Hebrew
   */
  he?: group_content;
  /**
   * The content of the group in Croatian
   */
  hr?: group_content;
  /**
   * The content of the group in Hungarian
   */
  hu?: group_content;
  /**
   * The content of the group in Indonesian
   */
  id?: group_content;
  /**
   * The content of the group in Italian
   */
  it?: group_content;
  /**
   * The content of the group in Japanese
   */
  ja?: group_content;
  /**
   * The content of the group in Korean
   */
  ko?: group_content;
  /**
   * The content of the group in Lithuanian
   */
  lt?: group_content;
  /**
   * The content of the group in Latvian
   */
  lv?: group_content;
  /**
   * The content of the group in Mongolian
   */
  mn?: group_content;
  /**
   * The content of the group in Norwegian
   */
  nb?: group_content;
  /**
   * The content of the group in Dutch
   */
  nl?: group_content;
  /**
   * The content of the group in Polish
   */
  pl?: group_content;
  /**
   * The content of the group in Portuguese (Portugal)
   */
  pt?: group_content;
  /**
   * The content of the group in Romanian
   */
  ro?: group_content;
  /**
   * The content of the group in Russian
   */
  ru?: group_content;
  /**
   * The content of the group in Slovenian
   */
  sl?: group_content;
  /**
   * The content of the group in Serbian
   */
  sr?: group_content;
  /**
   * The content of the group in Swedish
   */
  sv?: group_content;
  /**
   * The content of the group in Turkish
   */
  tr?: group_content;
  /**
   * The content of the group in Vietnamese
   */
  vi?: group_content;
  /**
   * The content of the group in Portuguese (Brazil)
   */
  'pt-BR'?: group_content;
  /**
   * The content of the group in Chinese (China)
   */
  'zh-CN'?: group_content;
  /**
   * The content of the group in Chinese (Taiwan)
   */
  'zh-TW'?: group_content;
} | null;

/**
 * The type of object - group_translated_content.
 */
export type type22 = 'group_translated_content';

/**
 * Help Centers contain collections
 */
export type help_center = {
  /**
   * The unique identifier for the Help Center which is given by Intercom.
   */
  id?: string;
  /**
   * The id of the workspace which the Help Center belongs to.
   */
  workspace_id?: string;
  /**
   * The time when the Help Center was created.
   */
  created_at?: number;
  /**
   * The time when the Help Center was last updated.
   */
  updated_at?: number;
  /**
   * The identifier of the Help Center. This is used in the URL of the Help Center.
   */
  identifier?: string;
  /**
   * Whether the Help Center is turned on or not. This is controlled in your Help Center settings.
   */
  website_turned_on?: boolean;
  /**
   * The display name of the Help Center only seen by teammates.
   */
  display_name?: string;
};

/**
 * A list of Help Centers belonging to the App
 */
export type help_center_list = {
  /**
   * The type of the object - `list`.
   */
  type?: 'list';
  /**
   * An array of Help Center objects
   */
  data?: Array<help_center>;
};

/**
 * Intercom API version.</br>By default, it's equal to the version set in the app package.
 */
export type intercom_version =
  | '1.0'
  | '1.1'
  | '1.2'
  | '1.3'
  | '1.4'
  | '2.0'
  | '2.1'
  | '2.2'
  | '2.3'
  | '2.4'
  | '2.5'
  | '2.6'
  | '2.7'
  | '2.8'
  | '2.9'
  | '2.10'
  | '2.11'
  | 'Unstable';

/**
 * Merge contact data.
 */
export type merge_contacts_request = {
  /**
   * The unique identifier for the contact to merge away from. Must be a lead.
   */
  from?: string;
  /**
   * The unique identifier for the contact to merge into. Must be a user.
   */
  into?: string;
};

/**
 * Message are how you reach out to contacts in Intercom. They are created when an admin sends an outbound message to a contact.
 */
export type message = {
  /**
   * The type of the message
   */
  type: string;
  /**
   * The id representing the message.
   */
  id: string;
  /**
   * The time the conversation was created.
   */
  created_at: number;
  /**
   * The subject of the message. Only present if message_type: email.
   */
  subject?: string;
  /**
   * The message body, which may contain HTML.
   */
  body: string;
  /**
   * The type of message that was sent. Can be email, inapp, facebook or twitter.
   */
  message_type: 'email' | 'inapp' | 'facebook' | 'twitter';
  /**
   * The associated conversation_id
   */
  conversation_id?: string;
};

/**
 * The type of message that was sent. Can be email, inapp, facebook or twitter.
 */
export type message_type6 = 'email' | 'inapp' | 'facebook' | 'twitter';

/**
 * Search using Intercoms Search APIs with more than one filter.
 */
export type multiple_filter_search_request = {
  /**
   * An operator to allow boolean inspection between multiple fields.
   */
  operator?: 'AND' | 'OR';
  value?: Array<multiple_filter_search_request> | Array<single_filter_search_request>;
};

/**
 * An operator to allow boolean inspection between multiple fields.
 */
export type operator = 'AND' | 'OR';

/**
 * A News Item is a content type in Intercom enabling you to announce product updates, company news, promotions, events and more with your customers.
 */
export type news_item = {
  /**
   * The type of object.
   */
  type?: 'news-item';
  /**
   * The unique identifier for the news item which is given by Intercom.
   */
  id?: string;
  /**
   * The id of the workspace which the news item belongs to.
   */
  workspace_id?: string;
  /**
   * The title of the news item.
   */
  title?: string;
  /**
   * The news item body, which may contain HTML.
   */
  body?: string;
  /**
   * The id of the sender of the news item. Must be a teammate on the workspace.
   */
  sender_id?: number;
  /**
   * News items will not be visible to your users in the assigned newsfeeds until they are set live.
   */
  state?: 'draft' | 'live';
  /**
   * A list of newsfeed_assignments to assign to the specified newsfeed.
   */
  newsfeed_assignments?: Array<newsfeed_assignment>;
  /**
   * Label names displayed to users to categorize the news item.
   */
  labels?: Array<string | null>;
  /**
   * URL of the image used as cover. Must have .jpg or .png extension.
   */
  cover_image_url?: string | null;
  /**
   * Ordered list of emoji reactions to the news item. When empty, reactions are disabled.
   */
  reactions?: Array<string | null>;
  /**
   * When set to true, the news item will appear in the messenger newsfeed without showing a notification badge.
   */
  deliver_silently?: boolean;
  /**
   * Timestamp for when the news item was created.
   */
  created_at?: number;
  /**
   * Timestamp for when the news item was last updated.
   */
  updated_at?: number;
};

/**
 * The type of object.
 */
export type type23 = 'news-item';

/**
 * News items will not be visible to your users in the assigned newsfeeds until they are set live.
 */
export type state3 = 'draft' | 'live';

/**
 * A News Item is a content type in Intercom enabling you to announce product updates, company news, promotions, events and more with your customers.
 */
export type news_item_request = {
  /**
   * The title of the news item.
   */
  title: string;
  /**
   * The news item body, which may contain HTML.
   */
  body?: string;
  /**
   * The id of the sender of the news item. Must be a teammate on the workspace.
   */
  sender_id: number;
  /**
   * News items will not be visible to your users in the assigned newsfeeds until they are set live.
   */
  state?: 'draft' | 'live';
  /**
   * When set to `true`, the news item will appear in the messenger newsfeed without showing a notification badge.
   */
  deliver_silently?: boolean;
  /**
   * Label names displayed to users to categorize the news item.
   */
  labels?: Array<string>;
  /**
   * Ordered list of emoji reactions to the news item. When empty, reactions are disabled.
   */
  reactions?: Array<string | null>;
  /**
   * A list of newsfeed_assignments to assign to the specified newsfeed.
   */
  newsfeed_assignments?: Array<newsfeed_assignment>;
};

/**
 * A newsfeed is a collection of news items, targeted to a specific audience.
 *
 * Newsfeeds currently cannot be edited through the API, please refer to [this article](https://www.intercom.com/help/en/articles/6362267-getting-started-with-news) to set up your newsfeeds in Intercom.
 *
 */
export type newsfeed = {
  /**
   * The unique identifier for the newsfeed which is given by Intercom.
   */
  id?: string;
  /**
   * The type of object.
   */
  type?: 'newsfeed';
  /**
   * The name of the newsfeed. This name will never be visible to your users.
   */
  name?: string;
  /**
   * Timestamp for when the newsfeed was created.
   */
  created_at?: number;
  /**
   * Timestamp for when the newsfeed was last updated.
   */
  updated_at?: number;
};

/**
 * The type of object.
 */
export type type24 = 'newsfeed';

/**
 * Assigns a news item to a newsfeed.
 */
export type newsfeed_assignment = {
  /**
   * The unique identifier for the newsfeed which is given by Intercom. Publish dates cannot be in the future, to schedule news items use the dedicated feature in app (see this article).
   */
  newsfeed_id?: number;
  /**
   * Publish date of the news item on the newsfeed, use this field if you want to set a publish date in the past (e.g. when importing existing news items). On write, this field will be ignored if the news item state is "draft".
   */
  published_at?: number;
};

/**
 * Notes allow you to annotate and comment on your contacts.
 */
export type note = {
  /**
   * String representing the object's type. Always has the value `note`.
   */
  type?: string;
  /**
   * The id of the note.
   */
  id?: string;
  /**
   * The time the note was created.
   */
  created_at?: number;
  /**
   * Represents the contact that the note was created about.
   */
  contact?: {
    /**
     * String representing the object's type. Always has the value `contact`.
     */
    type?: string;
    /**
     * The id of the contact.
     */
    id?: string;
  } | null;
  /**
   * Optional. Represents the Admin that created the note.
   */
  author?: admin;
  /**
   * The body text of the note.
   */
  body?: string;
};

/**
 * A paginated list of notes associated with a contact.
 */
export type note_list = {
  /**
   * String representing the object's type. Always has the value `list`.
   */
  type?: string;
  /**
   * An array of notes.
   */
  data?: Array<note>;
  /**
   * A count of the total number of notes.
   */
  total_count?: number;
  pages?: cursor_pages;
};

/**
 * Payload of the request to open a conversation
 */
export type open_conversation_request = {
  message_type: 'open';
  /**
   * The id of the admin who is performing the action.
   */
  admin_id: string;
};

export type message_type7 = 'open';

/**
 * The majority of list resources in the API are paginated to allow clients to traverse data over multiple requests.
 *
 * Their responses are likely to contain a pages object that hosts pagination links which a client can use to paginate through the data without having to construct a query. The link relations for the pages field are as follows.
 *
 */
export type pages_link = {
  type?: 'pages';
  page?: number;
  /**
   * A link to the next page of results. A response that does not contain a next link does not have further data to fetch.
   */
  next?: string | null;
  per_page?: number;
  total_pages?: number;
};

/**
 * Paginated Response
 */
export type paginated_response = {
  /**
   * The type of object
   */
  type?: 'list' | 'conversation.list';
  pages?: cursor_pages;
  /**
   * A count of the total number of objects.
   */
  total_count?: number;
  /**
   * An array of Objects
   */
  data?: Array<news_item | newsfeed>;
};

/**
 * The type of object
 */
export type type25 = 'list' | 'conversation.list';

/**
 * The file attached to a part
 */
export type part_attachment = {
  /**
   * The type of attachment
   */
  type?: string;
  /**
   * The name of the attachment
   */
  name?: string;
  /**
   * The URL of the attachment
   */
  url?: string;
  /**
   * The content type of the attachment
   */
  content_type?: string;
  /**
   * The size of the attachment
   */
  filesize?: number;
  /**
   * The width of the attachment
   */
  width?: number;
  /**
   * The height of the attachment
   */
  height?: number;
};

/**
 * Phone Switch Response
 */
export type phone_switch = {
  type?: 'phone_call_redirect';
  /**
   * Phone number in E.164 format, that has received the SMS to continue the conversation in the Messenger.
   */
  phone?: string;
} | null;

export type type26 = 'phone_call_redirect';

export type redact_conversation_request =
  | {
      /**
       * The type of resource being redacted.
       */
      type: 'conversation_part';
      /**
       * The id of the conversation.
       */
      conversation_id: string;
      /**
       * The id of the conversation_part.
       */
      conversation_part_id: string;
    }
  | {
      /**
       * The type of resource being redacted.
       */
      type: 'source';
      /**
       * The id of the conversation.
       */
      conversation_id: string;
      /**
       * The id of the source.
       */
      source_id: string;
    };

/**
 * The type of resource being redacted.
 */
export type type27 = 'conversation_part';

/**
 * reference to another object
 */
export type reference = {
  type?: string;
  id?: string | null;
};

export type reply_conversation_request = contact_reply_conversation_request | admin_reply_conversation_request;

/**
 * Search using Intercoms Search APIs.
 */
export type search_request = {
  query: single_filter_search_request | multiple_filter_search_request;
  pagination?: starting_after_paging;
};

/**
 * Sections are subdivisions of a collection, with a collection potentially having multiple sections.
 */
export type section = {
  /**
   * The type of object - `section`.
   */
  type?: 'section';
  /**
   * The unique identifier for the section which is given by Intercom.
   */
  id?: string;
  /**
   * The id of the workspace which the section belongs to.
   */
  workspace_id?: string;
  /**
   * The name of the section. For multilingual sections, this will be the name of the default language's content.
   */
  name?: string;
  /**
   * The time when the section was created. For multilingual sections, this will be the timestamp of creation of the default language's content.
   */
  created_at?: number;
  /**
   * The time when the section was last updated. For multilingual sections, this will be the timestamp of last update of the default language's content.
   */
  updated_at?: number;
  /**
   * The URL of the section. For multilingual help centers, this will be the URL of the section for the default language.
   */
  url?: string | null;
  /**
   * The icon of the section.
   */
  icon?: string | null;
  /**
   * The order of the section in relation to others sections within a collection. Values go from `0` upwards. `0` is the default if there's no order.
   */
  order?: number;
  /**
   * The id of the parent section.
   */
  parent_id?: number | string;
  /**
   * The default locale of the help center. This field is only returned for multilingual help centers.
   */
  default_locale?: string;
  translated_content?: group_translated_content | null;
};

/**
 * The type of object - `section`.
 */
export type type28 = 'section';

/**
 * This will return a list of Sections for the App.
 */
export type section_list = {
  /**
   * The type of the object - `list`.
   */
  type?: 'list';
  pages?: cursor_pages;
  /**
   * A count of the total number of sections.
   */
  total_count?: number;
  /**
   * An array of section objects
   */
  data?: Array<section>;
};

/**
 * A segment is a group of your contacts defined by the rules that you set.
 */
export type segment = {
  /**
   * The type of object.
   */
  type?: 'segment';
  /**
   * The unique identifier representing the segment.
   */
  id?: string;
  /**
   * The name of the segment.
   */
  name?: string;
  /**
   * The time the segment was created.
   */
  created_at?: number;
  /**
   * The time the segment was updated.
   */
  updated_at?: number;
  /**
   * Type of the contact: contact (lead) or user.
   */
  person_type?: 'contact' | 'user';
  /**
   * The number of items in the user segment. It's returned when `include_count=true` is included in the request.
   */
  count?: number | null;
};

/**
 * The type of object.
 */
export type type29 = 'segment';

/**
 * Type of the contact: contact (lead) or user.
 */
export type person_type = 'contact' | 'user';

/**
 * This will return a list of Segment Objects. The result may also have a pages object if the response is paginated.
 */
export type segment_list = {
  /**
   * The type of the object
   */
  type?: 'segment.list';
  /**
   * A list of Segment objects
   */
  segments?: Array<segment>;
  /**
   * A pagination object, which may be empty, indicating no further pages to fetch.
   */
  pages?: {
    [key: string]: unknown;
  };
};

/**
 * The type of the object
 */
export type type30 = 'segment.list';

/**
 * Search using Intercoms Search APIs with a single filter.
 */
export type single_filter_search_request = {
  /**
   * The accepted field that you want to search on.
   */
  field?: string;
  /**
   * The accepted operators you can use to define how you want to search for the value.
   */
  operator?: '=' | '!=' | 'IN' | 'NIN' | '<' | '>' | '~' | '!~' | '^' | '$';
  /**
   * The value that you want to search on.
   */
  value?: string;
};

/**
 * The accepted operators you can use to define how you want to search for the value.
 */
export type operator2 = '=' | '!=' | 'IN' | 'NIN' | '<' | '>' | '~' | '!~' | '^' | '$';

/**
 * The SLA Applied object contains the details for which SLA has been applied to this conversation.
 * Important: if there are any canceled sla_events for the conversation - meaning an SLA has been manually removed from a conversation, the sla_status will always be returned as null.
 *
 */
export type sla_applied = {
  /**
   * object type
   */
  type?: string;
  /**
   * The name of the SLA as given by the teammate when it was created.
   */
  sla_name?: string;
  /**
   * SLA statuses:
   * - `hit`: If there’s at least one hit event in the underlying sla_events table, and no “missed” or “canceled” events for the conversation.
   * - `missed`: If there are any missed sla_events for the conversation and no canceled events. If there’s even a single missed sla event, the status will always be missed. A missed status is not applied when the SLA expires, only the next time a teammate replies.
   * - `active`: An SLA has been applied to a conversation, but has not yet been fulfilled. SLA status is active only if there are no “hit, “missed”, or “canceled” events.
   */
  sla_status?: 'hit' | 'missed' | 'cancelled' | 'active';
} | null;

/**
 * SLA statuses:
 * - `hit`: If there’s at least one hit event in the underlying sla_events table, and no “missed” or “canceled” events for the conversation.
 * - `missed`: If there are any missed sla_events for the conversation and no canceled events. If there’s even a single missed sla event, the status will always be missed. A missed status is not applied when the SLA expires, only the next time a teammate replies.
 * - `active`: An SLA has been applied to a conversation, but has not yet been fulfilled. SLA status is active only if there are no “hit, “missed”, or “canceled” events.
 */
export type sla_status = 'hit' | 'missed' | 'cancelled' | 'active';

/**
 * Payload of the request to snooze a conversation
 */
export type snooze_conversation_request = {
  message_type: 'snoozed';
  /**
   * The id of the admin who is performing the action.
   */
  admin_id: string;
  /**
   * The time you want the conversation to reopen.
   */
  snoozed_until: number;
};

export type message_type8 = 'snoozed';

/**
 * A Social Profile allows you to label your contacts, companies, and conversations and list them using that Social Profile.
 */
export type social_profile = {
  /**
   * value is "social_profile"
   */
  type?: string;
  /**
   * The name of the Social media profile
   */
  name?: string;
  /**
   * The name of the Social media profile
   */
  url?: string;
};

export type starting_after_paging = {
  /**
   * The number of results to fetch per page.
   */
  per_page?: number;
  /**
   * The cursor to use in the next request to get the next page of results.
   */
  starting_after?: string | null;
} | null;

/**
 * A subscription type lets customers easily opt out of non-essential communications without missing what's important to them.
 */
export type subscription_type = {
  /**
   * The type of the object - subscription
   */
  type?: string;
  /**
   * The unique identifier representing the subscription type.
   */
  id?: string;
  /**
   * The state of the subscription type.
   */
  state?: 'live' | 'draft' | 'archived';
  default_translation?: translation;
  /**
   * An array of translations objects with the localised version of the subscription type in each available locale within your translation settings.
   */
  translations?: Array<translation>;
  /**
   * Describes the type of consent.
   */
  consent_type?: 'opt_out' | 'opt_in';
  /**
   * The message types that this subscription supports - can contain `email` or `sms_message`.
   */
  content_types?: Array<'email' | 'sms_message'>;
};

/**
 * The state of the subscription type.
 */
export type state4 = 'live' | 'draft' | 'archived';

/**
 * Describes the type of consent.
 */
export type consent_type = 'opt_out' | 'opt_in';

/**
 * A list of subscription type objects.
 */
export type subscription_type_list = {
  /**
   * The type of the object
   */
  type?: 'list';
  /**
   * A list of subscription type objects associated with the workspace .
   */
  data?: Array<subscription_type>;
};

/**
 * A tag allows you to label your contacts, companies, and conversations and list them using that tag.
 */
export type tag = {
  /**
   * value is "tag"
   */
  type?: string;
  /**
   * The id of the tag
   */
  id?: string;
  /**
   * The name of the tag
   */
  name?: string;
  /**
   * The time when the tag was applied to the object
   */
  applied_at?: number;
  applied_by?: reference;
};

/**
 * You can tag a single company or a list of companies.
 */
export type tag_company_request = {
  /**
   * The name of the tag, which will be created if not found.
   */
  name: string;
  /**
   * The id or company_id of the company can be passed as input parameters.
   */
  companies: Array<{
    /**
     * The Intercom defined id representing the company.
     */
    id?: string;
    /**
     * The company id you have defined for the company.
     */
    company_id?: string;
  }>;
};

/**
 * A list of tags objects in the workspace.
 */
export type tag_list = {
  /**
   * The type of the object
   */
  type?: 'list';
  /**
   * A list of tags objects associated with the workspace .
   */
  data?: Array<tag>;
};

/**
 * You can tag a list of users.
 */
export type tag_multiple_users_request = {
  /**
   * The name of the tag, which will be created if not found.
   */
  name: string;
  users: Array<{
    /**
     * The Intercom defined id representing the user.
     */
    id?: string;
  }>;
};

/**
 * A list of tags objects associated with a conversation
 */
export type tags = {
  /**
   * The type of the object
   */
  type?: 'tag.list';
  /**
   * A list of tags objects associated with the conversation.
   */
  tags?: Array<tag>;
};

/**
 * The type of the object
 */
export type type31 = 'tag.list';

/**
 * Teams are groups of admins in Intercom.
 */
export type team = {
  /**
   * Value is always "team"
   */
  type?: string;
  /**
   * The id of the team
   */
  id?: string;
  /**
   * The name of the team
   */
  name?: string;
  /**
   * The list of admin IDs that are a part of the team.
   */
  admin_ids?: Array<number>;
  admin_priority_level?: admin_priority_level;
};

/**
 * This will return a list of team objects for the App.
 */
export type team_list = {
  /**
   * The type of the object
   */
  type?: 'team.list';
  /**
   * A list of team objects
   */
  teams?: Array<team>;
};

/**
 * The type of the object
 */
export type type32 = 'team.list';

/**
 * Admin priority levels for teams
 */
export type team_priority_level = {
  /**
   * The primary team ids for the team
   */
  primary_team_ids?: Array<number> | null;
  /**
   * The secondary team ids for the team
   */
  secondary_team_ids?: Array<number> | null;
} | null;

/**
 * Tickets are how you track requests from your users.
 */
export type ticket = {
  /**
   * Always ticket
   */
  type?: 'ticket';
  /**
   * The unique identifier for the ticket which is given by Intercom.
   */
  id?: string;
  /**
   * The ID of the Ticket used in the Intercom Inbox and Messenger. Do not use ticket_id for API queries.
   */
  ticket_id?: string;
  ticket_attributes?: ticket_custom_attributes;
  /**
   * The state the ticket is currenly in
   */
  ticket_state?: 'submitted' | 'in_progress' | 'waiting_on_customer' | 'resolved';
  /**
   * The state the ticket is currently in, in a human readable form - visible in Intercom
   */
  ticket_state_internal_label?: string;
  /**
   * The state the ticket is currently in, in a human readable form - visible to customers, in the messenger, email and tickets portal.
   */
  ticket_state_external_label?: string;
  ticket_type?: ticket_type;
  contacts?: ticket_contacts;
  /**
   * The id representing the admin assigned to the ticket.
   */
  admin_assignee_id?: string;
  /**
   * The id representing the team assigned to the ticket.
   */
  team_assignee_id?: string;
  /**
   * The time the ticket was created as a UTC Unix timestamp.
   */
  created_at?: number;
  /**
   * The last time the ticket was updated as a UTC Unix timestamp.
   */
  updated_at?: number;
  ticket_parts?: ticket_parts;
  /**
   * Whether or not the ticket is shared with the customer.
   */
  is_shared?: boolean;
} | null;

/**
 * Always ticket
 */
export type type33 = 'ticket';

/**
 * The state the ticket is currenly in
 */
export type ticket_state = 'submitted' | 'in_progress' | 'waiting_on_customer' | 'resolved';

/**
 * The list of contacts affected by a ticket.
 */
export type ticket_contacts = {
  /**
   * always contact.list
   */
  type?: 'contact.list';
  /**
   * The list of contacts affected by this ticket.
   */
  contacts?: Array<contact_reference>;
};

/**
 * An object containing the different attributes associated to the ticket as key-value pairs. For the default title and description attributes, the keys are `_default_title_` and `_default_description_`.
 */
export type ticket_custom_attributes = {
  [key: string]: string | null | number | boolean | unknown[] | file_attribute;
};

/**
 * A Ticket Part representing a note in the ticket
 */
export type ticket_note = {
  /**
   * Always ticket_part
   */
  type?: 'ticket_part';
  /**
   * The id representing the note.
   */
  id?: string;
  /**
   * Always note
   */
  part_type?: 'note';
  /**
   * The message body, which may contain HTML.
   */
  body?: string | null;
  /**
   * The time the note was created.
   */
  created_at?: number;
  /**
   * The last time the note was updated.
   */
  updated_at?: number;
  author?: ticket_part_author;
  /**
   * A list of attachments for the part.
   */
  attachments?: Array<part_attachment>;
  /**
   * Whether or not the ticket part has been redacted.
   */
  redacted?: boolean;
};

/**
 * Always ticket_part
 */
export type type34 = 'ticket_part';

/**
 * Always note
 */
export type part_type = 'note';

/**
 * A Ticket Part represents a message in the ticket.
 */
export type ticket_part = {
  /**
   * Always ticket_part
   */
  type?: string;
  /**
   * The id representing the ticket part.
   */
  id?: string;
  /**
   * The type of ticket part.
   */
  part_type?: string;
  /**
   * The message body, which may contain HTML.
   */
  body?: string | null;
  /**
   * The previous state of the ticket.
   */
  previous_ticket_state?: 'submitted' | 'in_progress' | 'waiting_on_customer' | 'resolved';
  /**
   * The state of the ticket.
   */
  ticket_state?: 'submitted' | 'in_progress' | 'waiting_on_customer' | 'resolved';
  /**
   * The time the ticket part was created.
   */
  created_at?: number;
  /**
   * The last time the ticket part was updated.
   */
  updated_at?: number;
  /**
   * The id of the admin that was assigned the ticket by this ticket_part (null if there has been no change in assignment.)
   */
  assigned_to?: reference | null;
  author?: ticket_part_author;
  /**
   * A list of attachments for the part.
   */
  attachments?: Array<part_attachment>;
  /**
   * The external id of the ticket part
   */
  external_id?: string | null;
  /**
   * Whether or not the ticket part has been redacted.
   */
  redacted?: boolean;
};

/**
 * The previous state of the ticket.
 */
export type previous_ticket_state = 'submitted' | 'in_progress' | 'waiting_on_customer' | 'resolved';

/**
 * The author that wrote or triggered the part. Can be a bot, admin, team or user.
 */
export type ticket_part_author = {
  type?: 'admin' | 'bot' | 'team';
  /**
   * The id of the author
   */
  id?: string;
  /**
   * The name of the author
   */
  name?: string | null;
  /**
   * The email of the author
   */
  email?: string;
};

export type type35 = 'admin' | 'bot' | 'team';

/**
 * A list of Ticket Part objects for each note and event in the ticket. There is a limit of 500 parts.
 */
export type ticket_parts = {
  type?: 'ticket_part.list';
  /**
   * A list of Ticket Part objects for each ticket. There is a limit of 500 parts.
   */
  ticket_parts?: Array<ticket_part>;
  total_count?: number;
};

export type type36 = 'ticket_part.list';

/**
 * The attributes set on the ticket. When setting the default title and description attributes, the attribute keys that should be used are `_default_title_` and `_default_description_`. When setting ticket type attributes of the list attribute type, the key should be the attribute name and the value of the attribute should be the list item id, obtainable by [listing the ticket type](ref:get_ticket-types). For example, if the ticket type has an attribute called `priority` of type `list`, the key should be `priority` and the value of the attribute should be the guid of the list item (e.g. `de1825a0-0164-4070-8ca6-13e22462fa7e`).
 */
export type ticket_request_custom_attributes = {
  [key: string]: string | null | number | boolean | unknown[];
};

/**
 * A ticket type, used to define the data fields to be captured in a ticket.
 */
export type ticket_type = {
  /**
   * String representing the object's type. Always has the value `ticket_type`.
   */
  type?: string;
  /**
   * The id representing the ticket type.
   */
  id?: string;
  /**
   * The name of the ticket type
   */
  name?: string;
  /**
   * The description of the ticket type
   */
  description?: string;
  /**
   * The icon of the ticket type
   */
  icon?: string;
  /**
   * The id of the workspace that the ticket type belongs to.
   */
  workspace_id?: string;
  ticket_type_attributes?: ticket_type_attribute_list;
  /**
   * Whether the ticket type is archived or not.
   */
  archived?: boolean;
  /**
   * The date and time the ticket type was created.
   */
  created_at?: number;
  /**
   * The date and time the ticket type was last updated.
   */
  updated_at?: number;
} | null;

/**
 * Ticket type attribute, used to define each data field to be captured in a ticket.
 */
export type ticket_type_attribute = {
  /**
   * String representing the object's type. Always has the value `ticket_type_attribute`.
   */
  type?: string;
  /**
   * The id representing the ticket type attribute.
   */
  id?: string;
  /**
   * The id of the workspace that the ticket type attribute belongs to.
   */
  workspace_id?: string;
  /**
   * The name of the ticket type attribute
   */
  name?: string;
  /**
   * The description of the ticket type attribute
   */
  description?: string;
  /**
   * The type of the data attribute (allowed values: "string list integer decimal boolean datetime files")
   */
  data_type?: string;
  /**
   * Input options for the attribute
   */
  input_options?: {
    [key: string]: unknown;
  };
  /**
   * The order of the attribute against other attributes
   */
  order?: number;
  /**
   * Whether the attribute is required or not for teammates.
   */
  required_to_create?: boolean;
  /**
   * Whether the attribute is required or not for contacts.
   */
  required_to_create_for_contacts?: boolean;
  /**
   * Whether the attribute is visible or not to teammates.
   */
  visible_on_create?: boolean;
  /**
   * Whether the attribute is visible or not to contacts.
   */
  visible_to_contacts?: boolean;
  /**
   * Whether the attribute is built in or not.
   */
  default?: boolean;
  /**
   * The id of the ticket type that the attribute belongs to.
   */
  ticket_type_id?: number;
  /**
   * Whether the ticket type attribute is archived or not.
   */
  archived?: boolean;
  /**
   * The date and time the ticket type attribute was created.
   */
  created_at?: number;
  /**
   * The date and time the ticket type attribute was last updated.
   */
  updated_at?: number;
} | null;

/**
 * A list of attributes associated with a given ticket type.
 */
export type ticket_type_attribute_list = {
  /**
   * String representing the object's type. Always has the value `ticket_type_attributes.list`.
   */
  type?: string;
  /**
   * A list of ticket type attributes associated with a given ticket type.
   */
  ticket_type_attributes?: Array<ticket_type_attribute>;
};

/**
 * A list of ticket types associated with a given workspace.
 */
export type ticket_type_list = {
  /**
   * String representing the object's type. Always has the value `ticket_type.list`.
   */
  type?: string;
  /**
   * A list of ticket_types associated with a given workspace.
   */
  ticket_types?: Array<ticket_type>;
};

/**
 * A translation object contains the localised details of a subscription type.
 */
export type translation = {
  /**
   * The localised name of the subscription type.
   */
  name?: string;
  /**
   * The localised description of the subscription type.
   */
  description?: string;
  /**
   * The two character identifier for the language of the translation object.
   */
  locale?: string;
};

/**
 * You can tag a single company or a list of companies.
 */
export type untag_company_request = {
  /**
   * The name of the tag which will be untagged from the company
   */
  name: string;
  /**
   * The id or company_id of the company can be passed as input parameters.
   */
  companies: Array<{
    /**
     * The Intercom defined id representing the company.
     */
    id?: string;
    /**
     * The company id you have defined for the company.
     */
    company_id?: string;
    /**
     * Always set to true
     */
    untag?: boolean;
  }>;
};

/**
 * You can Update an Article
 */
export type update_article_request = {
  /**
   * The title of the article.For multilingual articles, this will be the title of the default language's content.
   */
  title?: string;
  /**
   * The description of the article. For multilingual articles, this will be the description of the default language's content.
   */
  description?: string;
  /**
   * The content of the article. For multilingual articles, this will be the body of the default language's content.
   */
  body?: string;
  /**
   * The id of the author of the article. For multilingual articles, this will be the id of the author of the default language's content. Must be a teammate on the help center's workspace.
   */
  author_id?: number;
  /**
   * Whether the article will be `published` or will be a `draft`. Defaults to draft. For multilingual articles, this will be the state of the default language's content.
   */
  state?: 'published' | 'draft';
  /**
   * The id of the article's parent collection or section. An article without this field stands alone.
   */
  parent_id?: string;
  /**
   * The type of parent, which can either be a `collection` or `section`.
   */
  parent_type?: string;
  translated_content?: article_translated_content;
} | null;

/**
 * You can update a collection
 */
export type update_collection_request = {
  /**
   * The name of the collection. For multilingual collections, this will be the name of the default language's content.
   */
  name?: string;
  /**
   * The description of the collection. For multilingual collections, this will be the description of the default language's content.
   */
  description?: string;
  translated_content?: group_translated_content | null;
};

/**
 * You can update a contact
 */
export type update_contact_request = {
  /**
   * The role of the contact.
   */
  role?: string;
  /**
   * A unique identifier for the contact which is given to Intercom
   */
  external_id?: string;
  /**
   * The contacts email
   */
  email?: string;
  /**
   * The contacts phone
   */
  phone?: string | null;
  /**
   * The contacts name
   */
  name?: string | null;
  /**
   * An image URL containing the avatar of a contact
   */
  avatar?: string | null;
  /**
   * The time specified for when a contact signed up
   */
  signed_up_at?: number | null;
  /**
   * The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)
   */
  last_seen_at?: number | null;
  /**
   * The id of an admin that has been assigned account ownership of the contact
   */
  owner_id?: number | null;
  /**
   * Whether the contact is unsubscribed from emails
   */
  unsubscribed_from_emails?: boolean | null;
  /**
   * The custom attributes which are set for the contact
   */
  custom_attributes?: {
    [key: string]: unknown;
  } | null;
};

/**
 * Payload of the request to update a conversation
 */
export type update_conversation_request = {
  /**
   * Mark a conversation as read within Intercom.
   */
  read?: boolean;
  custom_attributes?: custom_attributes;
};

export type update_data_attribute_request = {
  /**
   * Whether the attribute is to be archived or not.
   */
  archived?: boolean;
  /**
   * The readable description you see in the UI for the attribute.
   */
  description?: string;
  /**
   * To create list attributes. Provide a set of hashes with `value` as the key of the options you want to make. `data_type` must be `string`.
   */
  options?: Array<string>;
  /**
   * Can this attribute be updated by the Messenger
   */
  messenger_writable?: boolean;
};

/**
 * You can update a Section
 */
export type update_section_request = {
  /**
   * The name of the collection. For multilingual collections, this will be the name of the default language's content.
   */
  name?: string;
  /**
   * The id for the collection this section will be within.
   */
  parent_id?: number;
  translated_content?: group_translated_content | null;
};

/**
 * You can update a Ticket
 */
export type update_ticket_request = {
  /**
   * The attributes set on the ticket.
   */
  ticket_attributes?: {
    [key: string]: unknown;
  };
  /**
   * The state of the ticket.
   */
  state?: 'in_progress' | 'waiting_on_customer' | 'resolved';
  /**
   * Specify whether the ticket is visible to users.
   */
  is_shared?: boolean;
  assignment?: {
    /**
     * The ID of the admin performing the action.
     */
    admin_id?: string;
    /**
     * The ID of the admin or team to which the ticket is assigned. Set this 0 to unassign it.
     */
    assignee_id?: string;
  };
};

/**
 * The state of the ticket.
 */
export type state5 = 'in_progress' | 'waiting_on_customer' | 'resolved';

/**
 * You can update a Ticket Type Attribute
 */
export type update_ticket_type_attribute_request = {
  /**
   * The name of the ticket type attribute
   */
  name?: string;
  /**
   * The description of the attribute presented to the teammate or contact
   */
  description?: string;
  /**
   * Whether the attribute is required to be filled in when teammates are creating the ticket in Inbox.
   */
  required_to_create?: boolean;
  /**
   * Whether the attribute is required to be filled in when contacts are creating the ticket in Messenger.
   */
  required_to_create_for_contacts?: boolean;
  /**
   * Whether the attribute is visible to teammates when creating a ticket in Inbox.
   */
  visible_on_create?: boolean;
  /**
   * Whether the attribute is visible to contacts when creating a ticket in Messenger.
   */
  visible_to_contacts?: boolean;
  /**
   * Whether the attribute allows multiple lines of text (only applicable to string attributes)
   */
  multiline?: boolean;
  /**
   * A comma delimited list of items for the attribute value (only applicable to list attributes)
   */
  list_items?: string;
  /**
   * Whether the attribute allows multiple files to be attached to it (only applicable to file attributes)
   */
  allow_multiple_values?: boolean;
  /**
   * Whether the attribute should be archived and not shown during creation of the ticket (it will still be present on previously created tickets)
   */
  archived?: boolean;
};

/**
 * The request payload for updating a ticket type.
 * You can copy the `icon` property for your ticket type from [Twemoji Cheatsheet](https://twemoji-cheatsheet.vercel.app/)
 *
 */
export type update_ticket_type_request = {
  /**
   * The name of the ticket type.
   */
  name?: string;
  /**
   * The description of the ticket type.
   */
  description?: string;
  /**
   * The icon of the ticket type.
   */
  icon?: string;
  /**
   * The archived status of the ticket type.
   */
  archived?: boolean;
  /**
   * Whether the tickets associated with this ticket type are intended for internal use only or will be shared with customers. This is currently a limited attribute.
   */
  is_internal?: boolean;
} | null;

/**
 * Update an existing visitor.
 */
export type update_visitor_request = {
  /**
   * A unique identified for the visitor which is given by Intercom.
   */
  id?: string;
  /**
   * A unique identified for the visitor which is given by you.
   */
  user_id?: string;
  /**
   * The visitor's name.
   */
  name?: string;
  /**
   * The custom attributes which are set for the visitor.
   */
  custom_attributes?: {
    [key: string]: string;
  };
};

/**
 * Visitors are useful for representing anonymous people that have not yet been identified. They usually represent website visitors. Visitors are not visible in Intercom platform. The Visitors resource provides methods to fetch, update, convert and delete.
 */
export type visitor = {
  /**
   * Value is 'visitor'
   */
  type?: string;
  /**
   * The Intercom defined id representing the Visitor.
   */
  id?: string;
  /**
   * Automatically generated identifier for the Visitor.
   */
  user_id?: string;
  /**
   * Identifies if this visitor is anonymous.
   */
  anonymous?: boolean;
  /**
   * The email of the visitor.
   */
  email?: string;
  /**
   * The phone number of the visitor.
   */
  phone?: string | null;
  /**
   * The name of the visitor.
   */
  name?: string | null;
  /**
   * The pseudonym of the visitor.
   */
  pseudonym?: string | null;
  avatar?: {
    type?: string;
    /**
     * This object represents the avatar associated with the visitor.
     */
    image_url?: string | null;
  };
  /**
   * The id of the app the visitor is associated with.
   */
  app_id?: string;
  companies?: {
    /**
     * The type of the object
     */
    type?: 'company.list';
    companies?: Array<company>;
  };
  location_data?: {
    type?: string;
    /**
     * The city name of the visitor.
     */
    city_name?: string;
    /**
     * The continent code of the visitor.
     */
    continent_code?: string;
    /**
     * The country code of the visitor.
     */
    country_code?: string;
    /**
     * The country name of the visitor.
     */
    country_name?: string;
    /**
     * The postal code of the visitor.
     */
    postal_code?: string;
    /**
     * The region name of the visitor.
     */
    region_name?: string;
    /**
     * The timezone of the visitor.
     */
    timezone?: string;
  };
  /**
   * The time the Lead last recorded making a request.
   */
  las_request_at?: number;
  /**
   * The time the Visitor was added to Intercom.
   */
  created_at?: number;
  /**
   * The time the Visitor was added to Intercom.
   */
  remote_created_at?: number;
  /**
   * The time the Visitor signed up for your product.
   */
  signed_up_at?: number;
  /**
   * The last time the Visitor was updated.
   */
  updated_at?: number;
  /**
   * The number of sessions the Visitor has had.
   */
  session_count?: number;
  social_profiles?: {
    /**
     * The type of the object
     */
    type?: 'social_profile.list';
    social_profiles?: Array<string>;
  };
  /**
   * The id of the admin that owns the Visitor.
   */
  owner_id?: string | null;
  /**
   * Whether the Visitor is unsubscribed from emails.
   */
  unsubscribed_from_emails?: boolean;
  /**
   * Identifies if this visitor has marked an email as spam.
   */
  marked_email_as_spam?: boolean;
  /**
   * Identifies if this visitor has had a hard bounce.
   */
  has_hard_bounced?: boolean;
  tags?: {
    /**
     * The type of the object
     */
    type?: 'tag.list';
    tags?: Array<{
      /**
       * The type of the object
       */
      type?: 'tag';
      /**
       * The id of the tag.
       */
      id?: string;
      /**
       * The name of the tag.
       */
      name?: string;
    }>;
  };
  segments?: {
    /**
     * The type of the object
     */
    type?: 'segment.list';
    segments?: Array<string>;
  };
  /**
   * The custom attributes you have set on the Visitor.
   */
  custom_attributes?: {
    [key: string]: string;
  };
  /**
   * The referer of the visitor.
   */
  referrer?: string | null;
  /**
   * The utm_campaign of the visitor.
   */
  utm_campaign?: string | null;
  /**
   * The utm_content of the visitor.
   */
  utm_content?: string | null;
  /**
   * The utm_medium of the visitor.
   */
  utm_medium?: string | null;
  /**
   * The utm_source of the visitor.
   */
  utm_source?: string | null;
  /**
   * The utm_term of the visitor.
   */
  utm_term?: string | null;
  /**
   * Identifies if this visitor has do not track enabled.
   */
  do_not_track?: boolean | null;
} | null;

/**
 * The type of the object
 */
export type type37 = 'company.list';

/**
 * Response returned when an object is deleted
 */
export type visitor_deleted_object = {
  /**
   * The unique identifier for the visitor which is given by Intercom.
   */
  id?: string;
  /**
   * The type of object which was deleted
   */
  type?: 'visitor';
  /**
   * Automatically generated identifier for the Visitor.
   */
  user_id?: string;
};

/**
 * The type of object which was deleted
 */
export type type38 = 'visitor';

export type IdentifyAdminData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type IdentifyAdminResponse = admin_with_app;

export type IdentifyAdminError = unknown;

export type SetAwayAdminData = {
  body?: {
    /**
     * Set to "true" to change the status of the admin to away.
     */
    away_mode_enabled: boolean;
    /**
     * Set to "true" to assign any new conversation replies to your default inbox.
     */
    away_mode_reassign: boolean;
  };
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier of a given admin
     */
    id: number;
  };
};

export type SetAwayAdminResponse = admin;

export type SetAwayAdminError = error;

export type ListActivityLogsData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  query: {
    /**
     * The start date that you request data for. It must be formatted as a UNIX timestamp.
     */
    created_at_after: string;
    /**
     * The end date that you request data for. It must be formatted as a UNIX timestamp.
     */
    created_at_before?: string;
  };
};

export type ListActivityLogsResponse = activity_log_list;

export type ListActivityLogsError = error;

export type ListAdminsData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type ListAdminsResponse = admin_list;

export type ListAdminsError = error;

export type RetrieveAdminData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier of a given admin
     */
    id: number;
  };
};

export type RetrieveAdminResponse = admin;

export type RetrieveAdminError = error;

export type ListArticlesData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type ListArticlesResponse = article_list;

export type ListArticlesError = error;

export type CreateArticleData = {
  body?: create_article_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type CreateArticleResponse = article;

export type CreateArticleError = error;

export type RetrieveArticleData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the article which is given by Intercom.
     */
    id: number;
  };
};

export type RetrieveArticleResponse = article;

export type RetrieveArticleError = error;

export type UpdateArticleData = {
  body?: update_article_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the article which is given by Intercom.
     */
    id: number;
  };
};

export type UpdateArticleResponse = article;

export type UpdateArticleError = error;

export type DeleteArticleData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the article which is given by Intercom.
     */
    id: number;
  };
};

export type DeleteArticleResponse = deleted_article_object;

export type DeleteArticleError = error;

export type ListAllCollectionsData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type ListAllCollectionsResponse = collection_list;

export type ListAllCollectionsError = error;

export type CreateCollectionData = {
  body?: create_collection_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type CreateCollectionResponse = collection;

export type CreateCollectionError = error;

export type RetrieveCollectionData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the collection which is given by Intercom.
     */
    id: number;
  };
};

export type RetrieveCollectionResponse = collection;

export type RetrieveCollectionError = error;

export type UpdateCollectionData = {
  body?: update_collection_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the collection which is given by Intercom.
     */
    id: number;
  };
};

export type UpdateCollectionResponse = collection;

export type UpdateCollectionError = error;

export type DeleteCollectionData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the collection which is given by Intercom.
     */
    id: number;
  };
};

export type DeleteCollectionResponse = deleted_collection_object;

export type DeleteCollectionError = error;

export type RetrieveHelpCenterData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the collection which is given by Intercom.
     */
    id: number;
  };
};

export type RetrieveHelpCenterResponse = help_center;

export type RetrieveHelpCenterError = error;

export type ListHelpCentersData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type ListHelpCentersResponse = help_center_list;

export type ListHelpCentersError = error;

export type ListAllSectionsData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type ListAllSectionsResponse = section_list;

export type ListAllSectionsError = error;

export type CreateSectionData = {
  body?: create_section_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type CreateSectionResponse = section;

export type CreateSectionError = error;

export type RetrieveSectionData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the section which is given by Intercom.
     */
    id: number;
  };
};

export type RetrieveSectionResponse = section;

export type RetrieveSectionError = error;

export type UpdateSectionData = {
  body?: update_section_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the section which is given by Intercom.
     */
    id: number;
  };
};

export type UpdateSectionResponse = section;

export type UpdateSectionError = error;

export type DeleteSectionData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the section which is given by Intercom.
     */
    id: number;
  };
};

export type DeleteSectionResponse = deleted_section_object;

export type DeleteSectionError = error;

export type CreateOrUpdateCompanyData = {
  body?: create_or_update_company_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type CreateOrUpdateCompanyResponse = company;

export type CreateOrUpdateCompanyError = error;

export type RetrieveCompanyData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  query?: {
    /**
     * The `company_id` of the company to filter by.
     */
    company_id?: string;
    /**
     * The `name` of the company to filter by.
     */
    name?: string;
    /**
     * The page of results to fetch. Defaults to first page
     */
    page?: number;
    /**
     * How many results to display per page. Defaults to 15
     */
    per_page?: number;
    /**
     * The `segment_id` of the company to filter by.
     */
    segment_id?: string;
    /**
     * The `tag_id` of the company to filter by.
     */
    tag_id?: string;
  };
};

export type RetrieveCompanyResponse = company_list;

export type RetrieveCompanyError = error;

export type RetrieveAcompanyByIdData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the company which is given by Intercom
     */
    id: string;
  };
};

export type RetrieveAcompanyByIdResponse = company;

export type RetrieveAcompanyByIdError = error;

export type UpdateCompanyData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the company which is given by Intercom
     */
    id: string;
  };
};

export type UpdateCompanyResponse = company;

export type UpdateCompanyError = error;

export type DeleteCompanyData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the company which is given by Intercom
     */
    id: string;
  };
};

export type DeleteCompanyResponse = deleted_company_object;

export type DeleteCompanyError = error;

export type ListAttachedContactsData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the company which is given by Intercom
     */
    id: string;
  };
};

export type ListAttachedContactsResponse = company_attached_contacts;

export type ListAttachedContactsError = error;

export type ListAttachedSegmentsForCompaniesData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the company which is given by Intercom
     */
    id: string;
  };
};

export type ListAttachedSegmentsForCompaniesResponse = company_attached_segments;

export type ListAttachedSegmentsForCompaniesError = error;

export type ListAllCompaniesData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  query?: {
    /**
     * `asc` or `desc`. Return the companies in ascending or descending order. Defaults to desc
     */
    order?: string;
    /**
     * The page of results to fetch. Defaults to first page
     */
    page?: number;
    /**
     * How many results to return per page. Defaults to 15
     */
    per_page?: number;
  };
};

export type ListAllCompaniesResponse = company_list;

export type ListAllCompaniesError = error;

export type ScrollOverAllCompaniesData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  query?: {
    scroll_param?: string;
  };
};

export type ScrollOverAllCompaniesResponse = company_scroll;

export type ScrollOverAllCompaniesError = error;

export type AttachContactToAcompanyData = {
  body?: {
    /**
     * The unique identifier for the company which is given by Intercom
     */
    id: string;
  };
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the contact which is given by Intercom
     */
    id: string;
  };
};

export type AttachContactToAcompanyResponse = company;

export type AttachContactToAcompanyError = error;

export type ListCompaniesForAcontactData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the contact which is given by Intercom
     */
    id: string;
  };
};

export type ListCompaniesForAcontactResponse = contact_attached_companies;

export type ListCompaniesForAcontactError = error;

export type DetachContactFromAcompanyData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the contact which is given by Intercom
     */
    contact_id: string;
    /**
     * The unique identifier for the company which is given by Intercom
     */
    id: string;
  };
};

export type DetachContactFromAcompanyResponse = company;

export type DetachContactFromAcompanyError = error;

export type ListNotesData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier of a contact.
     */
    id: number;
  };
};

export type ListNotesResponse = note_list;

export type ListNotesError = error;

export type CreateNoteData = {
  body?: {
    /**
     * The text of the note.
     */
    body: string;
    /**
     * The unique identifier of a given contact.
     */
    contact_id?: string;
    /**
     * The unique identifier of a given admin.
     */
    admin_id?: string;
  };
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier of a given contact.
     */
    id: number;
  };
};

export type CreateNoteResponse = note;

export type CreateNoteError = error;

export type ListSegmentsForAcontactData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the contact which is given by Intercom
     */
    contact_id: string;
  };
};

export type ListSegmentsForAcontactResponse = contact_segments;

export type ListSegmentsForAcontactError = error;

export type ListSubscriptionsForAcontactData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the contact which is given by Intercom
     */
    contact_id: string;
  };
};

export type ListSubscriptionsForAcontactResponse = subscription_type_list;

export type ListSubscriptionsForAcontactError = error;

export type AttachSubscriptionTypeToContactData = {
  body?: {
    /**
     * The unique identifier for the subscription which is given by Intercom
     */
    id: string;
    /**
     * The consent_type of a subscription, opt_out or opt_in.
     */
    consent_type: string;
  };
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the contact which is given by Intercom
     */
    contact_id: string;
  };
};

export type AttachSubscriptionTypeToContactResponse = subscription_type;

export type AttachSubscriptionTypeToContactError = error;

export type DetachSubscriptionTypeToContactData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the contact which is given by Intercom
     */
    contact_id: string;
    /**
     * The unique identifier for the subscription type which is given by Intercom
     */
    id: string;
  };
};

export type DetachSubscriptionTypeToContactResponse = subscription_type;

export type DetachSubscriptionTypeToContactError = error;

export type ListTagsForAcontactData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the contact which is given by Intercom
     */
    contact_id: string;
  };
};

export type ListTagsForAcontactResponse = tag_list;

export type ListTagsForAcontactError = error;

export type AttachTagToContactData = {
  body?: {
    /**
     * The unique identifier for the tag which is given by Intercom
     */
    id: string;
  };
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the contact which is given by Intercom
     */
    contact_id: string;
  };
};

export type AttachTagToContactResponse = tag;

export type AttachTagToContactError = error;

export type DetachTagFromContactData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the contact which is given by Intercom
     */
    contact_id: string;
    /**
     * The unique identifier for the tag which is given by Intercom
     */
    id: string;
  };
};

export type DetachTagFromContactResponse = tag;

export type DetachTagFromContactError = error;

export type UpdateContactData = {
  body?: update_contact_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * id
     */
    id: string;
  };
};

export type UpdateContactResponse = contact;

export type UpdateContactError = error;

export type ShowContactData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * id
     */
    id: string;
  };
};

export type ShowContactResponse = contact;

export type ShowContactError = error;

export type DeleteContactData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * id
     */
    id: string;
  };
};

export type DeleteContactResponse = contact_deleted;

export type DeleteContactError = error;

export type MergeContactData = {
  body?: merge_contacts_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type MergeContactResponse = contact;

export type MergeContactError = error;

export type SearchContactsData = {
  body?: search_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type SearchContactsResponse = contact_list;

export type SearchContactsError = error;

export type ListContactsData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type ListContactsResponse = contact_list;

export type ListContactsError = error;

export type CreateContactData = {
  body?: create_contact_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type CreateContactResponse = contact;

export type CreateContactError = error;

export type ArchiveContactData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * id
     */
    id: string;
  };
};

export type ArchiveContactResponse = contact_archived;

export type ArchiveContactError = unknown;

export type UnarchiveContactData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * id
     */
    id: string;
  };
};

export type UnarchiveContactResponse = contact_unarchived;

export type UnarchiveContactError = unknown;

export type AttachTagToConversationData = {
  body?: {
    /**
     * The unique identifier for the tag which is given by Intercom
     */
    id: string;
    /**
     * The unique identifier for the admin which is given by Intercom.
     */
    admin_id: string;
  };
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * conversation_id
     */
    conversation_id: string;
  };
};

export type AttachTagToConversationResponse = tag;

export type AttachTagToConversationError = error;

export type DetachTagFromConversationData = {
  body?: {
    /**
     * The unique identifier for the admin which is given by Intercom.
     */
    admin_id: string;
  };
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * conversation_id
     */
    conversation_id: string;
    /**
     * id
     */
    id: string;
  };
};

export type DetachTagFromConversationResponse = tag;

export type DetachTagFromConversationError = error;

export type ListConversationsData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  query?: {
    /**
     * How many results per page
     */
    per_page?: number;
    /**
     * String used to get the next page of conversations.
     */
    starting_after?: string;
  };
};

export type ListConversationsResponse = paginated_response;

export type ListConversationsError = error;

export type CreateConversationData = {
  body?: create_conversation_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type CreateConversationResponse = message;

export type CreateConversationError = error;

export type RetrieveConversationData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The id of the conversation to target
     */
    id: number;
  };
  query?: {
    /**
     * Set to plaintext to retrieve conversation messages in plain text.
     */
    display_as?: string;
  };
};

export type RetrieveConversationResponse = conversation;

export type RetrieveConversationError = error;

export type UpdateConversationData = {
  body?: update_conversation_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The id of the conversation to target
     */
    id: number;
  };
  query?: {
    /**
     * Set to plaintext to retrieve conversation messages in plain text.
     */
    display_as?: string;
  };
};

export type UpdateConversationResponse = conversation;

export type UpdateConversationError = error;

export type SearchConversationsData = {
  body?: search_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type SearchConversationsResponse = conversation_list;

export type SearchConversationsError = unknown;

export type ReplyConversationData = {
  body?: reply_conversation_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The Intercom provisioned identifier for the conversation or the string "last" to reply to the last part of the conversation
     */
    id: string;
  };
};

export type ReplyConversationResponse = conversation;

export type ReplyConversationError = error;

export type ManageConversationData = {
  body?:
    | close_conversation_request
    | snooze_conversation_request
    | open_conversation_request
    | assign_conversation_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The identifier for the conversation as given by Intercom.
     */
    id: string;
  };
};

export type ManageConversationResponse = conversation;

export type ManageConversationError = error;

export type AutoAssignConversationData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The identifier for the conversation as given by Intercom.
     */
    id: string;
  };
};

export type AutoAssignConversationResponse = conversation;

export type AutoAssignConversationError = error;

export type AttachContactToConversationData = {
  body?: attach_contact_to_conversation_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The identifier for the conversation as given by Intercom.
     */
    id: string;
  };
};

export type AttachContactToConversationResponse = conversation;

export type AttachContactToConversationError = error;

export type DetachContactFromConversationData = {
  body?: detach_contact_from_conversation_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The identifier for the contact as given by Intercom.
     */
    contact_id: string;
    /**
     * The identifier for the conversation as given by Intercom.
     */
    conversation_id: string;
  };
};

export type DetachContactFromConversationResponse = conversation;

export type DetachContactFromConversationError = error;

export type RedactConversationData = {
  body?: redact_conversation_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type RedactConversationResponse = conversation;

export type RedactConversationError = error;

export type LisDataAttributesData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  query?: {
    /**
     * Include archived attributes in the list. By default we return only non archived data attributes.
     */
    include_archived?: boolean;
    /**
     * Specify the data attribute model to return.
     */
    model?: 'contact' | 'company' | 'conversation';
  };
};

export type LisDataAttributesResponse = data_attribute_list;

export type LisDataAttributesError = error;

export type CreateDataAttributeData = {
  body?: create_data_attribute_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type CreateDataAttributeResponse = data_attribute;

export type CreateDataAttributeError = error;

export type UpdateDataAttributeData = {
  body?: update_data_attribute_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The data attribute id
     */
    id: number;
  };
};

export type UpdateDataAttributeResponse = data_attribute;

export type UpdateDataAttributeError = error;

export type CreateDataEventData = {
  body?: create_data_event_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type CreateDataEventResponse = unknown;

export type CreateDataEventError = error;

export type LisDataEventsData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  query: {
    filter:
      | {
          user_id: string;
        }
      | {
          intercom_user_id: string;
        }
      | {
          email: string;
        };
    /**
     * summary flag
     */
    summary?: boolean;
    /**
     * The value must be user
     */
    type: string;
  };
};

export type LisDataEventsResponse = data_event_summary;

export type LisDataEventsError = error;

export type DataEventSummariesData = {
  body?: create_data_event_summaries_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type DataEventSummariesResponse = unknown;

export type DataEventSummariesError = error;

export type CreateDataExportData = {
  body?: create_data_exports_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type CreateDataExportResponse = data_export;

export type CreateDataExportError = unknown;

export type GetDataExportData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * job_identifier
     */
    job_identifier: string;
  };
};

export type GetDataExportResponse = data_export;

export type GetDataExportError = unknown;

export type CancelDataExportData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * job_identifier
     */
    job_identifier: string;
  };
};

export type CancelDataExportResponse = data_export;

export type CancelDataExportError = unknown;

export type DownloadDataExportData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * job_identifier
     */
    job_identifier: string;
  };
};

export type DownloadDataExportResponse = unknown;

export type DownloadDataExportError = unknown;

export type CreateMessageData = {
  body?: create_message_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type CreateMessageResponse = message;

export type CreateMessageError = error;

export type ListNewsItemsData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type ListNewsItemsResponse = paginated_response;

export type ListNewsItemsError = error;

export type CreateNewsItemData = {
  body?: news_item_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type CreateNewsItemResponse = news_item;

export type CreateNewsItemError = error;

export type RetrieveNewsItemData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the news item which is given by Intercom.
     */
    id: number;
  };
};

export type RetrieveNewsItemResponse = news_item;

export type RetrieveNewsItemError = error;

export type UpdateNewsItemData = {
  body?: news_item_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the news item which is given by Intercom.
     */
    id: number;
  };
};

export type UpdateNewsItemResponse = news_item;

export type UpdateNewsItemError = error;

export type DeleteNewsItemData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the news item which is given by Intercom.
     */
    id: number;
  };
};

export type DeleteNewsItemResponse = deleted_object;

export type DeleteNewsItemError = error;

export type ListLiveNewsfeedItemsData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the news feed item which is given by Intercom.
     */
    id: string;
  };
};

export type ListLiveNewsfeedItemsResponse = paginated_response;

export type ListLiveNewsfeedItemsError = error;

export type ListNewsfeedsData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type ListNewsfeedsResponse = paginated_response;

export type ListNewsfeedsError = error;

export type RetrieveNewsfeedData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the news feed item which is given by Intercom.
     */
    id: string;
  };
};

export type RetrieveNewsfeedResponse = newsfeed;

export type RetrieveNewsfeedError = error;

export type RetrieveNoteData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier of a given note
     */
    id: number;
  };
};

export type RetrieveNoteResponse = note;

export type RetrieveNoteError = error;

export type ListSegmentsData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  query?: {
    /**
     * It includes the count of contacts that belong to each segment.
     */
    include_count?: boolean;
  };
};

export type ListSegmentsResponse = segment_list;

export type ListSegmentsError = error;

export type RetrieveSegmentData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identified of a given segment.
     */
    id: string;
  };
};

export type RetrieveSegmentResponse = segment;

export type RetrieveSegmentError = error;

export type ListSubscriptionTypesData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type ListSubscriptionTypesResponse = subscription_type_list;

export type ListSubscriptionTypesError = error;

export type CreatePhoneSwitchData = {
  body?: create_phone_switch_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type CreatePhoneSwitchResponse = phone_switch;

export type CreatePhoneSwitchError = unknown | error;

export type ListTagsData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type ListTagsResponse = tag_list;

export type ListTagsError = error;

export type CreateTagData = {
  body?: create_or_update_tag_request | tag_company_request | untag_company_request | tag_multiple_users_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type CreateTagResponse = tag;

export type CreateTagError = error;

export type FindTagData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier of a given tag
     */
    id: string;
  };
};

export type FindTagResponse = tag;

export type FindTagError = error;

export type DeleteTagData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier of a given tag
     */
    id: string;
  };
};

export type DeleteTagResponse = unknown;

export type DeleteTagError = error;

export type ListTeamsData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type ListTeamsResponse = team_list;

export type ListTeamsError = error;

export type RetrieveTeamData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier of a given team.
     */
    id: string;
  };
};

export type RetrieveTeamResponse = team;

export type RetrieveTeamError = error;

export type CreateTicketTypeAttributeData = {
  body?: create_ticket_type_attribute_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the ticket type which is given by Intercom.
     */
    ticket_type_id: string;
  };
};

export type CreateTicketTypeAttributeResponse = ticket_type_attribute;

export type CreateTicketTypeAttributeError = error;

export type UpdateTicketTypeAttributeData = {
  body?: update_ticket_type_attribute_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the ticket type attribute which is given by Intercom.
     */
    id: string;
    /**
     * The unique identifier for the ticket type which is given by Intercom.
     */
    ticket_type_id: string;
  };
};

export type UpdateTicketTypeAttributeResponse = ticket_type_attribute;

export type UpdateTicketTypeAttributeError = error;

export type ListTicketTypesData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type ListTicketTypesResponse = ticket_type_list;

export type ListTicketTypesError = error;

export type CreateTicketTypeData = {
  body?: create_ticket_type_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type CreateTicketTypeResponse = ticket_type;

export type CreateTicketTypeError = error;

export type GetTicketTypeData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the ticket type which is given by Intercom.
     */
    id: string;
  };
};

export type GetTicketTypeResponse = ticket_type;

export type GetTicketTypeError = error;

export type UpdateTicketTypeData = {
  body?: update_ticket_type_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the ticket type which is given by Intercom.
     */
    id: string;
  };
};

export type UpdateTicketTypeResponse = ticket_type;

export type UpdateTicketTypeError = error;

export type ReplyTicketData = {
  body?: create_ticket_reply_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    id: string;
  };
};

export type ReplyTicketResponse = ticket_note;

export type ReplyTicketError = error;

export type CreateTicketData = {
  body?: create_ticket_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type CreateTicketResponse = ticket;

export type CreateTicketError = error;

export type UpdateTicketData = {
  body?: update_ticket_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the ticket which is given by Intercom
     */
    id: string;
  };
};

export type UpdateTicketResponse = ticket;

export type UpdateTicketError = error | unknown;

export type GetTicketData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  path: {
    /**
     * The unique identifier for the ticket which is given by Intercom.
     */
    id: string;
  };
};

export type GetTicketResponse = ticket;

export type GetTicketError = error;

export type UpdateVisitorData = {
  body?: update_visitor_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type UpdateVisitorResponse = visitor;

export type UpdateVisitorError = error;

export type RetrieveVisitorWithUserIdData = {
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
  query: {
    /**
     * The user_id of the Visitor you want to retrieve.
     */
    user_id: string;
  };
};

export type RetrieveVisitorWithUserIdResponse = visitor;

export type RetrieveVisitorWithUserIdError = error;

export type ConvertVisitorData = {
  body?: convert_visitor_request;
  headers?: {
    'Intercom-Version'?: intercom_version;
  };
};

export type ConvertVisitorResponse = contact;

export type ConvertVisitorError = error;
