// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  IdentifyAdminData,
  IdentifyAdminError,
  IdentifyAdminResponse,
  SetAwayAdminData,
  SetAwayAdminError,
  SetAwayAdminResponse,
  ListActivityLogsData,
  ListActivityLogsError,
  ListActivityLogsResponse,
  ListAdminsData,
  ListAdminsError,
  ListAdminsResponse,
  RetrieveAdminData,
  RetrieveAdminError,
  RetrieveAdminResponse,
  ListArticlesData,
  ListArticlesError,
  ListArticlesResponse,
  CreateArticleData,
  CreateArticleError,
  CreateArticleResponse,
  RetrieveArticleData,
  RetrieveArticleError,
  RetrieveArticleResponse,
  UpdateArticleData,
  UpdateArticleError,
  UpdateArticleResponse,
  DeleteArticleData,
  DeleteArticleError,
  DeleteArticleResponse,
  ListAllCollectionsData,
  ListAllCollectionsError,
  ListAllCollectionsResponse,
  CreateCollectionData,
  CreateCollectionError,
  CreateCollectionResponse,
  RetrieveCollectionData,
  RetrieveCollectionError,
  RetrieveCollectionResponse,
  UpdateCollectionData,
  UpdateCollectionError,
  UpdateCollectionResponse,
  DeleteCollectionData,
  DeleteCollectionError,
  DeleteCollectionResponse,
  RetrieveHelpCenterData,
  RetrieveHelpCenterError,
  RetrieveHelpCenterResponse,
  ListHelpCentersData,
  ListHelpCentersError,
  ListHelpCentersResponse,
  ListAllSectionsData,
  ListAllSectionsError,
  ListAllSectionsResponse,
  CreateSectionData,
  CreateSectionError,
  CreateSectionResponse,
  RetrieveSectionData,
  RetrieveSectionError,
  RetrieveSectionResponse,
  UpdateSectionData,
  UpdateSectionError,
  UpdateSectionResponse,
  DeleteSectionData,
  DeleteSectionError,
  DeleteSectionResponse,
  CreateOrUpdateCompanyData,
  CreateOrUpdateCompanyError,
  CreateOrUpdateCompanyResponse,
  RetrieveCompanyData,
  RetrieveCompanyError,
  RetrieveCompanyResponse,
  RetrieveAcompanyByIdData,
  RetrieveAcompanyByIdError,
  RetrieveAcompanyByIdResponse,
  UpdateCompanyData,
  UpdateCompanyError,
  UpdateCompanyResponse,
  DeleteCompanyData,
  DeleteCompanyError,
  DeleteCompanyResponse,
  ListAttachedContactsData,
  ListAttachedContactsError,
  ListAttachedContactsResponse,
  ListAttachedSegmentsForCompaniesData,
  ListAttachedSegmentsForCompaniesError,
  ListAttachedSegmentsForCompaniesResponse,
  ListAllCompaniesData,
  ListAllCompaniesError,
  ListAllCompaniesResponse,
  ScrollOverAllCompaniesData,
  ScrollOverAllCompaniesError,
  ScrollOverAllCompaniesResponse,
  AttachContactToAcompanyData,
  AttachContactToAcompanyError,
  AttachContactToAcompanyResponse,
  ListCompaniesForAcontactData,
  ListCompaniesForAcontactError,
  ListCompaniesForAcontactResponse,
  DetachContactFromAcompanyData,
  DetachContactFromAcompanyError,
  DetachContactFromAcompanyResponse,
  ListNotesData,
  ListNotesError,
  ListNotesResponse,
  CreateNoteData,
  CreateNoteError,
  CreateNoteResponse,
  ListSegmentsForAcontactData,
  ListSegmentsForAcontactError,
  ListSegmentsForAcontactResponse,
  ListSubscriptionsForAcontactData,
  ListSubscriptionsForAcontactError,
  ListSubscriptionsForAcontactResponse,
  AttachSubscriptionTypeToContactData,
  AttachSubscriptionTypeToContactError,
  AttachSubscriptionTypeToContactResponse,
  DetachSubscriptionTypeToContactData,
  DetachSubscriptionTypeToContactError,
  DetachSubscriptionTypeToContactResponse,
  ListTagsForAcontactData,
  ListTagsForAcontactError,
  ListTagsForAcontactResponse,
  AttachTagToContactData,
  AttachTagToContactError,
  AttachTagToContactResponse,
  DetachTagFromContactData,
  DetachTagFromContactError,
  DetachTagFromContactResponse,
  UpdateContactData,
  UpdateContactError,
  UpdateContactResponse,
  ShowContactData,
  ShowContactError,
  ShowContactResponse,
  DeleteContactData,
  DeleteContactError,
  DeleteContactResponse,
  MergeContactData,
  MergeContactError,
  MergeContactResponse,
  SearchContactsData,
  SearchContactsError,
  SearchContactsResponse,
  ListContactsData,
  ListContactsError,
  ListContactsResponse,
  CreateContactData,
  CreateContactError,
  CreateContactResponse,
  ArchiveContactData,
  ArchiveContactError,
  ArchiveContactResponse,
  UnarchiveContactData,
  UnarchiveContactError,
  UnarchiveContactResponse,
  AttachTagToConversationData,
  AttachTagToConversationError,
  AttachTagToConversationResponse,
  DetachTagFromConversationData,
  DetachTagFromConversationError,
  DetachTagFromConversationResponse,
  ListConversationsData,
  ListConversationsError,
  ListConversationsResponse,
  CreateConversationData,
  CreateConversationError,
  CreateConversationResponse,
  RetrieveConversationData,
  RetrieveConversationError,
  RetrieveConversationResponse,
  UpdateConversationData,
  UpdateConversationError,
  UpdateConversationResponse,
  SearchConversationsData,
  SearchConversationsError,
  SearchConversationsResponse,
  ReplyConversationData,
  ReplyConversationError,
  ReplyConversationResponse,
  ManageConversationData,
  ManageConversationError,
  ManageConversationResponse,
  AutoAssignConversationData,
  AutoAssignConversationError,
  AutoAssignConversationResponse,
  AttachContactToConversationData,
  AttachContactToConversationError,
  AttachContactToConversationResponse,
  DetachContactFromConversationData,
  DetachContactFromConversationError,
  DetachContactFromConversationResponse,
  RedactConversationData,
  RedactConversationError,
  RedactConversationResponse,
  LisDataAttributesData,
  LisDataAttributesError,
  LisDataAttributesResponse,
  CreateDataAttributeData,
  CreateDataAttributeError,
  CreateDataAttributeResponse,
  UpdateDataAttributeData,
  UpdateDataAttributeError,
  UpdateDataAttributeResponse,
  CreateDataEventData,
  CreateDataEventError,
  CreateDataEventResponse,
  LisDataEventsData,
  LisDataEventsError,
  LisDataEventsResponse,
  DataEventSummariesData,
  DataEventSummariesError,
  DataEventSummariesResponse,
  CreateDataExportData,
  CreateDataExportError,
  CreateDataExportResponse,
  GetDataExportData,
  GetDataExportError,
  GetDataExportResponse,
  CancelDataExportData,
  CancelDataExportError,
  CancelDataExportResponse,
  DownloadDataExportData,
  DownloadDataExportError,
  DownloadDataExportResponse,
  CreateMessageData,
  CreateMessageError,
  CreateMessageResponse,
  ListNewsItemsData,
  ListNewsItemsError,
  ListNewsItemsResponse,
  CreateNewsItemData,
  CreateNewsItemError,
  CreateNewsItemResponse,
  RetrieveNewsItemData,
  RetrieveNewsItemError,
  RetrieveNewsItemResponse,
  UpdateNewsItemData,
  UpdateNewsItemError,
  UpdateNewsItemResponse,
  DeleteNewsItemData,
  DeleteNewsItemError,
  DeleteNewsItemResponse,
  ListLiveNewsfeedItemsData,
  ListLiveNewsfeedItemsError,
  ListLiveNewsfeedItemsResponse,
  ListNewsfeedsData,
  ListNewsfeedsError,
  ListNewsfeedsResponse,
  RetrieveNewsfeedData,
  RetrieveNewsfeedError,
  RetrieveNewsfeedResponse,
  RetrieveNoteData,
  RetrieveNoteError,
  RetrieveNoteResponse,
  ListSegmentsData,
  ListSegmentsError,
  ListSegmentsResponse,
  RetrieveSegmentData,
  RetrieveSegmentError,
  RetrieveSegmentResponse,
  ListSubscriptionTypesData,
  ListSubscriptionTypesError,
  ListSubscriptionTypesResponse,
  CreatePhoneSwitchData,
  CreatePhoneSwitchError,
  CreatePhoneSwitchResponse,
  ListTagsData,
  ListTagsError,
  ListTagsResponse,
  CreateTagData,
  CreateTagError,
  CreateTagResponse,
  FindTagData,
  FindTagError,
  FindTagResponse,
  DeleteTagData,
  DeleteTagError,
  DeleteTagResponse,
  ListTeamsData,
  ListTeamsError,
  ListTeamsResponse,
  RetrieveTeamData,
  RetrieveTeamError,
  RetrieveTeamResponse,
  CreateTicketTypeAttributeData,
  CreateTicketTypeAttributeError,
  CreateTicketTypeAttributeResponse,
  UpdateTicketTypeAttributeData,
  UpdateTicketTypeAttributeError,
  UpdateTicketTypeAttributeResponse,
  ListTicketTypesData,
  ListTicketTypesError,
  ListTicketTypesResponse,
  CreateTicketTypeData,
  CreateTicketTypeError,
  CreateTicketTypeResponse,
  GetTicketTypeData,
  GetTicketTypeError,
  GetTicketTypeResponse,
  UpdateTicketTypeData,
  UpdateTicketTypeError,
  UpdateTicketTypeResponse,
  ReplyTicketData,
  ReplyTicketError,
  ReplyTicketResponse,
  CreateTicketData,
  CreateTicketError,
  CreateTicketResponse,
  UpdateTicketData,
  UpdateTicketError,
  UpdateTicketResponse,
  GetTicketData,
  GetTicketError,
  GetTicketResponse,
  UpdateVisitorData,
  UpdateVisitorError,
  UpdateVisitorResponse,
  RetrieveVisitorWithUserIdData,
  RetrieveVisitorWithUserIdError,
  RetrieveVisitorWithUserIdResponse,
  ConvertVisitorData,
  ConvertVisitorError,
  ConvertVisitorResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Identify an admin
 *
 * You can view the currently authorised admin along with the embedded app object (a "workspace" in legacy terminology).
 *
 * > 🚧 Single Sign On
 * >
 * > If you are building a custom "Log in with Intercom" flow for your site, and you call the `/me` endpoint to identify the logged-in user, you should not accept any sign-ins from users with unverified email addresses as it poses a potential impersonation security risk.
 *
 */
export const identifyAdmin = <ThrowOnError extends boolean = false>(
  options?: Options<IdentifyAdminData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<IdentifyAdminResponse, IdentifyAdminError, ThrowOnError>({
    ...options,
    url: '/me',
  });
};

/**
 * Set an admin to away
 * You can set an Admin as away for the Inbox.
 */
export const setAwayAdmin = <ThrowOnError extends boolean = false>(
  options: Options<SetAwayAdminData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<SetAwayAdminResponse, SetAwayAdminError, ThrowOnError>({
    ...options,
    url: '/admins/{id}/away',
  });
};

/**
 * List all activity logs
 * You can get a log of activities by all admins in an app.
 */
export const listActivityLogs = <ThrowOnError extends boolean = false>(
  options: Options<ListActivityLogsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListActivityLogsResponse, ListActivityLogsError, ThrowOnError>({
    ...options,
    url: '/admins/activity_logs',
  });
};

/**
 * List all admins
 * You can fetch a list of admins for a given workspace.
 */
export const listAdmins = <ThrowOnError extends boolean = false>(options?: Options<ListAdminsData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListAdminsResponse, ListAdminsError, ThrowOnError>({
    ...options,
    url: '/admins',
  });
};

/**
 * Retrieve an admin
 * You can retrieve the details of a single admin.
 */
export const retrieveAdmin = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveAdminData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveAdminResponse, RetrieveAdminError, ThrowOnError>({
    ...options,
    url: '/admins/{id}',
  });
};

/**
 * List all articles
 * You can fetch a list of all articles by making a GET request to `https://api.intercom.io/articles`.
 *
 * > 📘 How are the articles sorted and ordered?
 * >
 * > Articles will be returned in descending order on the `updated_at` attribute. This means if you need to iterate through results then we'll show the most recently updated articles first.
 *
 */
export const listArticles = <ThrowOnError extends boolean = false>(
  options?: Options<ListArticlesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListArticlesResponse, ListArticlesError, ThrowOnError>({
    ...options,
    url: '/articles',
  });
};

/**
 * Create an article
 * You can create a new article by making a POST request to `https://api.intercom.io/articles`.
 */
export const createArticle = <ThrowOnError extends boolean = false>(
  options?: Options<CreateArticleData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateArticleResponse, CreateArticleError, ThrowOnError>({
    ...options,
    url: '/articles',
  });
};

/**
 * Retrieve an article
 * You can fetch the details of a single article by making a GET request to `https://api.intercom.io/articles/<id>`.
 */
export const retrieveArticle = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveArticleData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveArticleResponse, RetrieveArticleError, ThrowOnError>({
    ...options,
    url: '/articles/{id}',
  });
};

/**
 * Update an article
 * You can update the details of a single article by making a PUT request to `https://api.intercom.io/articles/<id>`.
 */
export const updateArticle = <ThrowOnError extends boolean = false>(
  options: Options<UpdateArticleData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateArticleResponse, UpdateArticleError, ThrowOnError>({
    ...options,
    url: '/articles/{id}',
  });
};

/**
 * Delete an article
 * You can delete a single article by making a DELETE request to `https://api.intercom.io/articles/<id>`.
 */
export const deleteArticle = <ThrowOnError extends boolean = false>(
  options: Options<DeleteArticleData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteArticleResponse, DeleteArticleError, ThrowOnError>({
    ...options,
    url: '/articles/{id}',
  });
};

/**
 * List all collections
 * You can fetch a list of all collections by making a GET request to `https://api.intercom.io/help_center/collections`.
 *
 * Collections will be returned in descending order on the `updated_at` attribute. This means if you need to iterate through results then we'll show the most recently updated collections first.
 *
 */
export const listAllCollections = <ThrowOnError extends boolean = false>(
  options?: Options<ListAllCollectionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListAllCollectionsResponse, ListAllCollectionsError, ThrowOnError>({
    ...options,
    url: '/help_center/collections',
  });
};

/**
 * Create a collection
 * You can create a new collection by making a POST request to `https://api.intercom.io/help_center/collections.`
 */
export const createCollection = <ThrowOnError extends boolean = false>(
  options?: Options<CreateCollectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateCollectionResponse, CreateCollectionError, ThrowOnError>({
    ...options,
    url: '/help_center/collections',
  });
};

/**
 * Retrieve a collection
 * You can fetch the details of a single collection by making a GET request to `https://api.intercom.io/help_center/collections/<id>`.
 */
export const retrieveCollection = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveCollectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveCollectionResponse, RetrieveCollectionError, ThrowOnError>({
    ...options,
    url: '/help_center/collections/{id}',
  });
};

/**
 * Update a collection
 * You can update the details of a single collection by making a PUT request to `https://api.intercom.io/collections/<id>`.
 */
export const updateCollection = <ThrowOnError extends boolean = false>(
  options: Options<UpdateCollectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateCollectionResponse, UpdateCollectionError, ThrowOnError>({
    ...options,
    url: '/help_center/collections/{id}',
  });
};

/**
 * Delete a collection
 * You can delete a single collection by making a DELETE request to `https://api.intercom.io/collections/<id>`.
 */
export const deleteCollection = <ThrowOnError extends boolean = false>(
  options: Options<DeleteCollectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteCollectionResponse, DeleteCollectionError, ThrowOnError>({
    ...options,
    url: '/help_center/collections/{id}',
  });
};

/**
 * Retrieve a Help Center
 * You can fetch the details of a single Help Center by making a GET request to `https://api.intercom.io/help_center/help_center/<id>`.
 */
export const retrieveHelpCenter = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveHelpCenterData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveHelpCenterResponse, RetrieveHelpCenterError, ThrowOnError>({
    ...options,
    url: '/help_center/help_centers/{id}',
  });
};

/**
 * List all Help Centers
 * You can list all Help Centers by making a GET request to `https://api.intercom.io/help_center/help_centers`.
 */
export const listHelpCenters = <ThrowOnError extends boolean = false>(
  options?: Options<ListHelpCentersData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListHelpCentersResponse, ListHelpCentersError, ThrowOnError>({
    ...options,
    url: '/help_center/help_centers',
  });
};

/**
 * List all sections
 * You can fetch a list of all sections by making a GET request to `https://api.intercom.io/help_center/sections`.
 * > 📘 How are the sections sorted and ordered?
 * >
 * > Sections will be returned in descending order on the `updated_at` attribute. This means if you need to iterate through results then we'll show the most recently updated sections first.
 *
 */
export const listAllSections = <ThrowOnError extends boolean = false>(
  options?: Options<ListAllSectionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListAllSectionsResponse, ListAllSectionsError, ThrowOnError>({
    ...options,
    url: '/help_center/sections',
  });
};

/**
 * Create a section
 * You can create a new section by making a POST request to `https://api.intercom.io/help_center/sections.`
 */
export const createSection = <ThrowOnError extends boolean = false>(
  options?: Options<CreateSectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateSectionResponse, CreateSectionError, ThrowOnError>({
    ...options,
    url: '/help_center/sections',
  });
};

/**
 * Retrieve a section
 * You can fetch the details of a single section by making a GET request to `https://api.intercom.io/help_center/sections/<id>`.
 */
export const retrieveSection = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveSectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveSectionResponse, RetrieveSectionError, ThrowOnError>({
    ...options,
    url: '/help_center/sections/{id}',
  });
};

/**
 * Update a section
 * You can update the details of a single section by making a PUT request to `https://api.intercom.io/sections/<id>`.
 */
export const updateSection = <ThrowOnError extends boolean = false>(
  options: Options<UpdateSectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateSectionResponse, UpdateSectionError, ThrowOnError>({
    ...options,
    url: '/help_center/sections/{id}',
  });
};

/**
 * Delete a section
 * You can delete a single section by making a DELETE request to `https://api.intercom.io/sections/<id>`.
 */
export const deleteSection = <ThrowOnError extends boolean = false>(
  options: Options<DeleteSectionData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteSectionResponse, DeleteSectionError, ThrowOnError>({
    ...options,
    url: '/help_center/sections/{id}',
  });
};

/**
 * Create or Update a company
 * You can create or update a company.
 *
 * Companies will be only visible in Intercom when there is at least one associated user.
 *
 * Companies are looked up via `company_id` in a `POST` request, if not found via `company_id`, the new company will be created, if found, that company will be updated.
 *
 * {% admonition type="attention" name="Using `company_id`" %}
 * You can set a unique `company_id` value when creating a company. However, it is not possible to update `company_id`. Be sure to set a unique value once upon creation of the company.
 * {% /admonition %}
 *
 */
export const createOrUpdateCompany = <ThrowOnError extends boolean = false>(
  options?: Options<CreateOrUpdateCompanyData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateOrUpdateCompanyResponse, CreateOrUpdateCompanyError, ThrowOnError>({
    ...options,
    url: '/companies',
  });
};

/**
 * Retrieve companies
 * You can fetch a single company by passing in `company_id` or `name`.
 *
 * `https://api.intercom.io/companies?name={name}`
 *
 * `https://api.intercom.io/companies?company_id={company_id}`
 *
 * You can fetch all companies and filter by `segment_id` or `tag_id` as a query parameter.
 *
 * `https://api.intercom.io/companies?tag_id={tag_id}`
 *
 * `https://api.intercom.io/companies?segment_id={segment_id}`
 *
 */
export const retrieveCompany = <ThrowOnError extends boolean = false>(
  options?: Options<RetrieveCompanyData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveCompanyResponse, RetrieveCompanyError, ThrowOnError>({
    ...options,
    url: '/companies',
  });
};

/**
 * Retrieve a company by ID
 * You can fetch a single company.
 */
export const retrieveAcompanyById = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveAcompanyByIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveAcompanyByIdResponse, RetrieveAcompanyByIdError, ThrowOnError>({
    ...options,
    url: '/companies/{id}',
  });
};

/**
 * Update a company
 * You can update a single company using the Intercom provisioned `id`.
 *
 * {% admonition type="attention" name="Using `company_id`" %}
 * When updating a company it is not possible to update `company_id`. This can only be set once upon creation of the company.
 * {% /admonition %}
 *
 */
export const updateCompany = <ThrowOnError extends boolean = false>(
  options: Options<UpdateCompanyData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateCompanyResponse, UpdateCompanyError, ThrowOnError>({
    ...options,
    url: '/companies/{id}',
  });
};

/**
 * Delete a company
 * You can delete a single company.
 */
export const deleteCompany = <ThrowOnError extends boolean = false>(
  options: Options<DeleteCompanyData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteCompanyResponse, DeleteCompanyError, ThrowOnError>({
    ...options,
    url: '/companies/{id}',
  });
};

/**
 * List attached contacts
 * You can fetch a list of all contacts that belong to a company.
 */
export const listAttachedContacts = <ThrowOnError extends boolean = false>(
  options: Options<ListAttachedContactsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListAttachedContactsResponse, ListAttachedContactsError, ThrowOnError>({
    ...options,
    url: '/companies/{id}/contacts',
  });
};

/**
 * List attached segments for companies
 * You can fetch a list of all segments that belong to a company.
 */
export const listAttachedSegmentsForCompanies = <ThrowOnError extends boolean = false>(
  options: Options<ListAttachedSegmentsForCompaniesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListAttachedSegmentsForCompaniesResponse,
    ListAttachedSegmentsForCompaniesError,
    ThrowOnError
  >({
    ...options,
    url: '/companies/{id}/segments',
  });
};

/**
 * List all companies
 * You can list companies. The company list is sorted by the `last_request_at` field and by default is ordered descending, most recently requested first.
 *
 * Note that the API does not include companies who have no associated users in list responses.
 *
 * When using the Companies endpoint and the pages object to iterate through the returned companies, there is a limit of 10,000 Companies that can be returned. If you need to list or iterate on more than 10,000 Companies, please use the [Scroll API](https://developers.intercom.com/reference#iterating-over-all-companies).
 * {% admonition type="warning" name="Pagination" %}
 * You can use pagination to limit the number of results returned. The default is `20` results per page.
 * See the [pagination section](https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis) for more details on how to use the `starting_after` param.
 * {% /admonition %}
 *
 */
export const listAllCompanies = <ThrowOnError extends boolean = false>(
  options?: Options<ListAllCompaniesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ListAllCompaniesResponse, ListAllCompaniesError, ThrowOnError>({
    ...options,
    url: '/companies/list',
  });
};

/**
 * Scroll over all companies
 *       The `list all companies` functionality does not work well for huge datasets, and can result in errors and performance problems when paging deeply. The Scroll API provides an efficient mechanism for iterating over all companies in a dataset.
 *
 * - Each app can only have 1 scroll open at a time. You'll get an error message if you try to have more than one open per app.
 * - If the scroll isn't used for 1 minute, it expires and calls with that scroll param will fail
 * - If the end of the scroll is reached, "companies" will be empty and the scroll parameter will expire
 *
 * {% admonition type="info" name="Scroll Parameter" %}
 * You can get the first page of companies by simply sending a GET request to the scroll endpoint.
 * For subsequent requests you will need to use the scroll parameter from the response.
 * {% /admonition %}
 * {% admonition type="danger" name="Scroll network timeouts" %}
 * Since scroll is often used on large datasets network errors such as timeouts can be encountered. When this occurs you will see a HTTP 500 error with the following message:
 * "Request failed due to an internal network error. Please restart the scroll operation."
 * If this happens, you will need to restart your scroll query: It is not possible to continue from a specific point when using scroll.
 * {% /admonition %}
 *
 */
export const scrollOverAllCompanies = <ThrowOnError extends boolean = false>(
  options?: Options<ScrollOverAllCompaniesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ScrollOverAllCompaniesResponse, ScrollOverAllCompaniesError, ThrowOnError>({
    ...options,
    url: '/companies/scroll',
  });
};

/**
 * Attach a Contact to a Company
 * You can attach a company to a single contact.
 */
export const attachContactToAcompany = <ThrowOnError extends boolean = false>(
  options: Options<AttachContactToAcompanyData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AttachContactToAcompanyResponse, AttachContactToAcompanyError, ThrowOnError>({
    ...options,
    url: '/contacts/{id}/companies',
  });
};

/**
 * List attached companies for contact
 * You can fetch a list of companies that are associated to a contact.
 */
export const listCompaniesForAcontact = <ThrowOnError extends boolean = false>(
  options: Options<ListCompaniesForAcontactData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListCompaniesForAcontactResponse, ListCompaniesForAcontactError, ThrowOnError>(
    {
      ...options,
      url: '/contacts/{id}/companies',
    },
  );
};

/**
 * Detach a contact from a company
 * You can detach a company from a single contact.
 */
export const detachContactFromAcompany = <ThrowOnError extends boolean = false>(
  options: Options<DetachContactFromAcompanyData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DetachContactFromAcompanyResponse,
    DetachContactFromAcompanyError,
    ThrowOnError
  >({
    ...options,
    url: '/contacts/{contact_id}/companies/{id}',
  });
};

/**
 * List all notes
 * You can fetch a list of notes that are associated to a contact.
 */
export const listNotes = <ThrowOnError extends boolean = false>(options: Options<ListNotesData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListNotesResponse, ListNotesError, ThrowOnError>({
    ...options,
    url: '/contacts/{id}/notes',
  });
};

/**
 * Create a note
 * You can add a note to a single contact.
 */
export const createNote = <ThrowOnError extends boolean = false>(options: Options<CreateNoteData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateNoteResponse, CreateNoteError, ThrowOnError>({
    ...options,
    url: '/contacts/{id}/notes',
  });
};

/**
 * List attached segments for contact
 * You can fetch a list of segments that are associated to a contact.
 */
export const listSegmentsForAcontact = <ThrowOnError extends boolean = false>(
  options: Options<ListSegmentsForAcontactData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListSegmentsForAcontactResponse, ListSegmentsForAcontactError, ThrowOnError>({
    ...options,
    url: '/contacts/{contact_id}/segments',
  });
};

/**
 * List subscriptions for a contact
 * You can fetch a list of subscription types that are attached to a contact. These can be subscriptions that a user has 'opted-in' to or has 'opted-out' from, depending on the subscription type.
 * This will return a list of Subscription Type objects that the contact is associated with.
 *
 * The data property will show a combined list of:
 *
 * 1.Opt-out subscription types that the user has opted-out from.
 * 2.Opt-in subscription types that the user has opted-in to receiving.
 *
 */
export const listSubscriptionsForAcontact = <ThrowOnError extends boolean = false>(
  options: Options<ListSubscriptionsForAcontactData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    ListSubscriptionsForAcontactResponse,
    ListSubscriptionsForAcontactError,
    ThrowOnError
  >({
    ...options,
    url: '/contacts/{contact_id}/subscriptions',
  });
};

/**
 * Add subscription to a contact
 * You can add a specific subscription to a contact. In Intercom, we have two different subscription types based on user consent - opt-out and opt-in:
 *
 * 1.Attaching a contact to an opt-out subscription type will opt that user out from receiving messages related to that subscription type.
 *
 * 2.Attaching a contact to an opt-in subscription type will opt that user in to receiving messages related to that subscription type.
 *
 * This will return a subscription type model for the subscription type that was added to the contact.
 *
 */
export const attachSubscriptionTypeToContact = <ThrowOnError extends boolean = false>(
  options: Options<AttachSubscriptionTypeToContactData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AttachSubscriptionTypeToContactResponse,
    AttachSubscriptionTypeToContactError,
    ThrowOnError
  >({
    ...options,
    url: '/contacts/{contact_id}/subscriptions',
  });
};

/**
 * Remove subscription from a contact
 * You can remove a specific subscription from a contact. This will return a subscription type model for the subscription type that was removed from the contact.
 */
export const detachSubscriptionTypeToContact = <ThrowOnError extends boolean = false>(
  options: Options<DetachSubscriptionTypeToContactData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DetachSubscriptionTypeToContactResponse,
    DetachSubscriptionTypeToContactError,
    ThrowOnError
  >({
    ...options,
    url: '/contacts/{contact_id}/subscriptions/{id}',
  });
};

/**
 * List tags attached to a contact
 * You can fetch a list of all tags that are attached to a specific contact.
 */
export const listTagsForAcontact = <ThrowOnError extends boolean = false>(
  options: Options<ListTagsForAcontactData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListTagsForAcontactResponse, ListTagsForAcontactError, ThrowOnError>({
    ...options,
    url: '/contacts/{contact_id}/tags',
  });
};

/**
 * Add tag to a contact
 * You can tag a specific contact. This will return a tag object for the tag that was added to the contact.
 */
export const attachTagToContact = <ThrowOnError extends boolean = false>(
  options: Options<AttachTagToContactData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AttachTagToContactResponse, AttachTagToContactError, ThrowOnError>({
    ...options,
    url: '/contacts/{contact_id}/tags',
  });
};

/**
 * Remove tag from a contact
 * You can remove tag from a specific contact. This will return a tag object for the tag that was removed from the contact.
 */
export const detachTagFromContact = <ThrowOnError extends boolean = false>(
  options: Options<DetachTagFromContactData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DetachTagFromContactResponse, DetachTagFromContactError, ThrowOnError>({
    ...options,
    url: '/contacts/{contact_id}/tags/{id}',
  });
};

/**
 * Update a contact
 * You can update an existing contact (ie. user or lead).
 */
export const updateContact = <ThrowOnError extends boolean = false>(
  options: Options<UpdateContactData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateContactResponse, UpdateContactError, ThrowOnError>({
    ...options,
    url: '/contacts/{id}',
  });
};

/**
 * Get a contact
 * You can fetch the details of a single contact.
 */
export const showContact = <ThrowOnError extends boolean = false>(options: Options<ShowContactData, ThrowOnError>) => {
  return (options?.client ?? client).get<ShowContactResponse, ShowContactError, ThrowOnError>({
    ...options,
    url: '/contacts/{id}',
  });
};

/**
 * Delete a contact
 * You can delete a single contact.
 */
export const deleteContact = <ThrowOnError extends boolean = false>(
  options: Options<DeleteContactData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteContactResponse, DeleteContactError, ThrowOnError>({
    ...options,
    url: '/contacts/{id}',
  });
};

/**
 * Merge a lead and a user
 * You can merge a contact with a `role` of `lead` into a contact with a `role` of `user`.
 */
export const mergeContact = <ThrowOnError extends boolean = false>(
  options?: Options<MergeContactData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<MergeContactResponse, MergeContactError, ThrowOnError>({
    ...options,
    url: '/contacts/merge',
  });
};

/**
 * Search contacts
 * You can search for multiple contacts by the value of their attributes in order to fetch exactly who you want.
 *
 * To search for contacts, you need to send a `POST` request to `https://api.intercom.io/contacts/search`.
 *
 * This will accept a query object in the body which will define your filters in order to search for contacts.
 *
 * {% admonition type="warning" name="Optimizing search queries" %}
 * Search queries can be complex, so optimizing them can help the performance of your search.
 * Use the `AND` and `OR` operators to combine multiple filters to get the exact results you need and utilize
 * pagination to limit the number of results returned. The default is `50` results per page.
 * See the [pagination section](https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request) for more details on how to use the `starting_after` param.
 * {% /admonition %}
 * ### Contact Creation Delay
 *
 * If a contact has recently been created, there is a possibility that it will not yet be available when searching. This means that it may not appear in the response. This delay can take a few minutes. If you need to be instantly notified it is recommended to use webhooks and iterate to see if they match your search filters.
 *
 * ### Nesting & Limitations
 *
 * You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
 * There are some limitations to the amount of multiple's there can be:
 * * There's a limit of max 2 nested filters
 * * There's a limit of max 15 filters for each AND or OR group
 *
 * ### Searching for Timestamp Fields
 *
 * All timestamp fields (created_at, updated_at etc.) are indexed as Dates for Contact Search queries; Datetime queries are not currently supported. This means you can only query for timestamp fields by day - not hour, minute or second.
 * For example, if you search for all Contacts with a created_at value greater (>) than 1577869200 (the UNIX timestamp for January 1st, 2020 9:00 AM), that will be interpreted as 1577836800 (January 1st, 2020 12:00 AM). The search results will then include Contacts created from January 2nd, 2020 12:00 AM onwards.
 * If you'd like to get contacts created on January 1st, 2020 you should search with a created_at value equal (=) to 1577836800 (January 1st, 2020 12:00 AM).
 * This behaviour applies only to timestamps used in search queries. The search results will still contain the full UNIX timestamp and be sorted accordingly.
 *
 * ### Accepted Fields
 *
 * Most key listed as part of the Contacts Model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as `created_at` accepts a date, the `value` cannot be a string such as `"foorbar"`).
 *
 * | Field                              | Type                           |
 * | ---------------------------------- | ------------------------------ |
 * | id                                 | String                         |
 * | role                               | String<br>Accepts user or lead |
 * | name                               | String                         |
 * | avatar                             | String                         |
 * | owner_id                           | Integer                        |
 * | email                              | String                         |
 * | email_domain                       | String                         |
 * | phone                              | String                         |
 * | formatted_phone                    | String                         |
 * | external_id                        | String                         |
 * | created_at                         | Date (UNIX Timestamp)          |
 * | signed_up_at                       | Date (UNIX Timestamp)          |
 * | updated_at                         | Date (UNIX Timestamp)          |
 * | last_seen_at                       | Date (UNIX Timestamp)          |
 * | last_contacted_at                  | Date (UNIX Timestamp)          |
 * | last_replied_at                    | Date (UNIX Timestamp)          |
 * | last_email_opened_at               | Date (UNIX Timestamp)          |
 * | last_email_clicked_at              | Date (UNIX Timestamp)          |
 * | language_override                  | String                         |
 * | browser                            | String                         |
 * | browser_language                   | String                         |
 * | os                                 | String                         |
 * | location.country                   | String                         |
 * | location.region                    | String                         |
 * | location.city                      | String                         |
 * | unsubscribed_from_emails           | Boolean                        |
 * | marked_email_as_spam               | Boolean                        |
 * | has_hard_bounced                   | Boolean                        |
 * | ios_last_seen_at                   | Date (UNIX Timestamp)          |
 * | ios_app_version                    | String                         |
 * | ios_device                         | String                         |
 * | ios_app_device                     | String                         |
 * | ios_os_version                     | String                         |
 * | ios_app_name                       | String                         |
 * | ios_sdk_version                    | String                         |
 * | android_last_seen_at               | Date (UNIX Timestamp)          |
 * | android_app_version                | String                         |
 * | android_device                     | String                         |
 * | android_app_name                   | String                         |
 * | andoid_sdk_version                 | String                         |
 * | segment_id                         | String                         |
 * | tag_id                             | String                         |
 * | custom_attributes.{attribute_name} | String                         |
 *
 * ### Accepted Operators
 *
 * {% admonition type="attention" name="Searching based on `created_at`" %}
 * You cannot use the `<=` or `>=` operators to search by `created_at`.
 * {% /admonition %}
 *
 * The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (`"="`). The operator has to be compatible with the field's type (eg. you cannot search with `>` for a given string value as it's only compatible for integer's and dates).
 *
 * | Operator | Valid Types                      | Description                                                      |
 * | :------- | :------------------------------- | :--------------------------------------------------------------- |
 * | =        | All                              | Equals                                                           |
 * | !=       | All                              | Doesn't Equal                                                    |
 * | IN       | All                              | In<br>Shortcut for `OR` queries<br>Values must be in Array       |
 * | NIN      | All                              | Not In<br>Shortcut for `OR !` queries<br>Values must be in Array |
 * | >        | Integer<br>Date (UNIX Timestamp) | Greater than                                                     |
 * | <       | Integer<br>Date (UNIX Timestamp) | Lower than                                                       |
 * | ~        | String                           | Contains                                                         |
 * | !~       | String                           | Doesn't Contain                                                  |
 * | ^        | String                           | Starts With                                                      |
 * | $        | String                           | Ends With                                                        |
 *
 */
export const searchContacts = <ThrowOnError extends boolean = false>(
  options?: Options<SearchContactsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<SearchContactsResponse, SearchContactsError, ThrowOnError>({
    ...options,
    url: '/contacts/search',
  });
};

/**
 * List all contacts
 * You can fetch a list of all contacts (ie. users or leads) in your workspace.
 * {% admonition type="warning" name="Pagination" %}
 * You can use pagination to limit the number of results returned. The default is `50` results per page.
 * See the [pagination section](https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis) for more details on how to use the `starting_after` param.
 * {% /admonition %}
 *
 */
export const listContacts = <ThrowOnError extends boolean = false>(
  options?: Options<ListContactsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListContactsResponse, ListContactsError, ThrowOnError>({
    ...options,
    url: '/contacts',
  });
};

/**
 * Create contact
 * You can create a new contact (ie. user or lead).
 */
export const createContact = <ThrowOnError extends boolean = false>(
  options?: Options<CreateContactData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateContactResponse, CreateContactError, ThrowOnError>({
    ...options,
    url: '/contacts',
  });
};

/**
 * Archive contact
 * You can archive a single contact.
 */
export const archiveContact = <ThrowOnError extends boolean = false>(
  options: Options<ArchiveContactData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ArchiveContactResponse, ArchiveContactError, ThrowOnError>({
    ...options,
    url: '/contacts/{id}/archive',
  });
};

/**
 * Unarchive contact
 * You can unarchive a single contact.
 */
export const unarchiveContact = <ThrowOnError extends boolean = false>(
  options: Options<UnarchiveContactData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<UnarchiveContactResponse, UnarchiveContactError, ThrowOnError>({
    ...options,
    url: '/contacts/{id}/unarchive',
  });
};

/**
 * Add tag to a conversation
 * You can tag a specific conversation. This will return a tag object for the tag that was added to the conversation.
 */
export const attachTagToConversation = <ThrowOnError extends boolean = false>(
  options: Options<AttachTagToConversationData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AttachTagToConversationResponse, AttachTagToConversationError, ThrowOnError>({
    ...options,
    url: '/conversations/{conversation_id}/tags',
  });
};

/**
 * Remove tag from a conversation
 * You can remove tag from a specific conversation. This will return a tag object for the tag that was removed from the conversation.
 */
export const detachTagFromConversation = <ThrowOnError extends boolean = false>(
  options: Options<DetachTagFromConversationData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DetachTagFromConversationResponse,
    DetachTagFromConversationError,
    ThrowOnError
  >({
    ...options,
    url: '/conversations/{conversation_id}/tags/{id}',
  });
};

/**
 * List all conversations
 * You can fetch a list of all conversations.
 *
 * You can optionally request the result page size and the cursor to start after to fetch the result.
 * {% admonition type="warning" name="Pagination" %}
 * You can use pagination to limit the number of results returned. The default is `20` results per page.
 * See the [pagination section](https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis) for more details on how to use the `starting_after` param.
 * {% /admonition %}
 *
 */
export const listConversations = <ThrowOnError extends boolean = false>(
  options?: Options<ListConversationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListConversationsResponse, ListConversationsError, ThrowOnError>({
    ...options,
    url: '/conversations',
  });
};

/**
 * Creates a conversation
 * You can create a conversation that has been initiated by a contact (ie. user or lead).
 * The conversation can be an in-app message only.
 *
 * {% admonition type="info" name="Sending for visitors" %}
 * You can also send a message from a visitor by specifying their `user_id` or `id` value in the `from` field, along with a `type` field value of `contact`.
 * This visitor will be automatically converted to a contact with a lead role once the conversation is created.
 * {% /admonition %}
 *
 * This will return the Message model that has been created.
 *
 *
 */
export const createConversation = <ThrowOnError extends boolean = false>(
  options?: Options<CreateConversationData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateConversationResponse, CreateConversationError, ThrowOnError>({
    ...options,
    url: '/conversations',
  });
};

/**
 * Retrieve a conversation
 *
 * You can fetch the details of a single conversation.
 *
 * This will return a single Conversation model with all its conversation parts.
 *
 * {% admonition type="warning" name="Hard limit of 500 parts" %}
 * The maximum number of conversation parts that can be returned via the API is 500. If you have more than that we will return the 500 most recent conversation parts.
 * {% /admonition %}
 *
 * For AI agent conversation metadata, please note that you need to have the agent enabled in your workspace, which is a [paid feature](https://www.intercom.com/help/en/articles/8205718-fin-resolutions#h_97f8c2e671).
 *
 */
export const retrieveConversation = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveConversationData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveConversationResponse, RetrieveConversationError, ThrowOnError>({
    ...options,
    url: '/conversations/{id}',
  });
};

/**
 * Update a conversation
 *
 * You can update an existing conversation.
 *
 * {% admonition type="info" name="Replying and other actions" %}
 * If you want to reply to a coveration or take an action such as assign, unassign, open, close or snooze, take a look at the reply and manage endpoints.
 * {% /admonition %}
 *
 *
 */
export const updateConversation = <ThrowOnError extends boolean = false>(
  options: Options<UpdateConversationData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateConversationResponse, UpdateConversationError, ThrowOnError>({
    ...options,
    url: '/conversations/{id}',
  });
};

/**
 * Search conversations
 * You can search for multiple conversations by the value of their attributes in order to fetch exactly which ones you want.
 *
 * To search for conversations, you need to send a `POST` request to `https://api.intercom.io/conversations/search`.
 *
 * This will accept a query object in the body which will define your filters in order to search for conversations.
 * {% admonition type="warning" name="Optimizing search queries" %}
 * Search queries can be complex, so optimizing them can help the performance of your search.
 * Use the `AND` and `OR` operators to combine multiple filters to get the exact results you need and utilize
 * pagination to limit the number of results returned. The default is `20` results per page and maximum is `150`.
 * See the [pagination section](https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request) for more details on how to use the `starting_after` param.
 * {% /admonition %}
 *
 * ### Nesting & Limitations
 *
 * You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
 * There are some limitations to the amount of multiple's there can be:
 * - There's a limit of max 2 nested filters
 * - There's a limit of max 15 filters for each AND or OR group
 *
 * ### Accepted Fields
 *
 * Most keys listed as part of the The conversation model is searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as `created_at` accepts a date, the `value` cannot be a string such as `"foorbar"`).
 * The `source.body` field is unique as the search will not be performed against the entire value, but instead against every element of the value separately. For example, when searching for a conversation with a `"I need support"` body - the query should contain a `=` operator with the value `"support"` for such conversation to be returned. A query with a `=` operator and a `"need support"` value will not yield a result.
 *
 * | Field                                     | Type                                                                                                                                                   |
 * | :---------------------------------------- | :----------------------------------------------------------------------------------------------------------------------------------------------------- |
 * | id                                        | String                                                                                                                                                 |
 * | created_at                                | Date (UNIX timestamp)                                                                                                                                  |
 * | updated_at                                | Date (UNIX timestamp)                                                                                                                                  |
 * | source.type                               | String<br>Accepted fields are `conversation`, `email`, `facebook`, `instagram`, `phone_call`, `phone_switch`, `push`, `sms`, `twitter` and `whatsapp`. |
 * | source.id                                 | String                                                                                                                                                 |
 * | source.delivered_as                       | String                                                                                                                                                 |
 * | source.subject                            | String                                                                                                                                                 |
 * | source.body                               | String                                                                                                                                                 |
 * | source.author.id                          | String                                                                                                                                                 |
 * | source.author.type                        | String                                                                                                                                                 |
 * | source.author.name                        | String                                                                                                                                                 |
 * | source.author.email                       | String                                                                                                                                                 |
 * | source.url                                | String                                                                                                                                                 |
 * | contact_ids                               | String                                                                                                                                                 |
 * | teammate_ids                              | String                                                                                                                                                 |
 * | admin_assignee_id                         | String                                                                                                                                                 |
 * | team_assignee_id                          | String                                                                                                                                                 |
 * | channel_initiated                         | String                                                                                                                                                 |
 * | open                                      | Boolean                                                                                                                                                |
 * | read                                      | Boolean                                                                                                                                                |
 * | state                                     | String                                                                                                                                                 |
 * | waiting_since                             | Date (UNIX timestamp)                                                                                                                                  |
 * | snoozed_until                             | Date (UNIX timestamp)                                                                                                                                  |
 * | tag_ids                                   | String                                                                                                                                                 |
 * | priority                                  | String                                                                                                                                                 |
 * | statistics.time_to_assignment             | Integer                                                                                                                                                |
 * | statistics.time_to_admin_reply            | Integer                                                                                                                                                |
 * | statistics.time_to_first_close            | Integer                                                                                                                                                |
 * | statistics.time_to_last_close             | Integer                                                                                                                                                |
 * | statistics.median_time_to_reply           | Integer                                                                                                                                                |
 * | statistics.first_contact_reply_at         | Date (UNIX timestamp)                                                                                                                                  |
 * | statistics.first_assignment_at            | Date (UNIX timestamp)                                                                                                                                  |
 * | statistics.first_admin_reply_at           | Date (UNIX timestamp)                                                                                                                                  |
 * | statistics.first_close_at                 | Date (UNIX timestamp)                                                                                                                                  |
 * | statistics.last_assignment_at             | Date (UNIX timestamp)                                                                                                                                  |
 * | statistics.last_assignment_admin_reply_at | Date (UNIX timestamp)                                                                                                                                  |
 * | statistics.last_contact_reply_at          | Date (UNIX timestamp)                                                                                                                                  |
 * | statistics.last_admin_reply_at            | Date (UNIX timestamp)                                                                                                                                  |
 * | statistics.last_close_at                  | Date (UNIX timestamp)                                                                                                                                  |
 * | statistics.last_closed_by_id              | String                                                                                                                                                 |
 * | statistics.count_reopens                  | Integer                                                                                                                                                |
 * | statistics.count_assignments              | Integer                                                                                                                                                |
 * | statistics.count_conversation_parts       | Integer                                                                                                                                                |
 * | conversation_rating.requested_at          | Date (UNIX timestamp)                                                                                                                                  |
 * | conversation_rating.replied_at            | Date (UNIX timestamp)                                                                                                                                  |
 * | conversation_rating.score                 | Integer                                                                                                                                                |
 * | conversation_rating.remark                | String                                                                                                                                                 |
 * | conversation_rating.contact_id            | String                                                                                                                                                 |
 * | conversation_rating.admin_d               | String                                                                                                                                                 |
 * | ai_agent_participated                     | Boolean                                                                                                                                                |
 * | ai_agent.resolution_state                 | String                                                                                                                                                 |
 * | ai_agent.last_answer_type                 | String                                                                                                                                                 |
 * | ai_agent.rating                           | Integer                                                                                                                                                |
 * | ai_agent.rating_remark                    | String                                                                                                                                                 |
 * | ai_agent.source_type                      | String                                                                                                                                                 |
 * | ai_agent.source_title                     | String                                                                                                                                                 |
 *
 * ### Accepted Operators
 *
 * The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (`"="`). The operator has to be compatible with the field's type  (eg. you cannot search with `>` for a given string value as it's only compatible for integer's and dates).
 *
 * | Operator | Valid Types                    | Description                                                  |
 * | :------- | :----------------------------- | :----------------------------------------------------------- |
 * | =        | All                            | Equals                                                       |
 * | !=       | All                            | Doesn't Equal                                                |
 * | IN       | All                            | In  Shortcut for `OR` queries  Values most be in Array       |
 * | NIN      | All                            | Not In  Shortcut for `OR !` queries  Values must be in Array |
 * | >        | Integer  Date (UNIX Timestamp) | Greater (or equal) than                                      |
 * | <       | Integer  Date (UNIX Timestamp) | Lower (or equal) than                                        |
 * | ~        | String                         | Contains                                                     |
 * | !~       | String                         | Doesn't Contain                                              |
 * | ^        | String                         | Starts With                                                  |
 * | $        | String                         | Ends With                                                    |
 *
 */
export const searchConversations = <ThrowOnError extends boolean = false>(
  options?: Options<SearchConversationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<SearchConversationsResponse, SearchConversationsError, ThrowOnError>({
    ...options,
    url: '/conversations/search',
  });
};

/**
 * Reply to a conversation
 * You can reply to a conversation with a message from an admin or on behalf of a contact, or with a note for admins.
 */
export const replyConversation = <ThrowOnError extends boolean = false>(
  options: Options<ReplyConversationData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ReplyConversationResponse, ReplyConversationError, ThrowOnError>({
    ...options,
    url: '/conversations/{id}/reply',
  });
};

/**
 * Manage a conversation
 * For managing conversations you can:
 * - Close a conversation
 * - Snooze a conversation to reopen on a future date
 * - Open a conversation which is `snoozed` or `closed`
 * - Assign a conversation to an admin and/or team.
 *
 */
export const manageConversation = <ThrowOnError extends boolean = false>(
  options: Options<ManageConversationData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ManageConversationResponse, ManageConversationError, ThrowOnError>({
    ...options,
    url: '/conversations/{id}/parts',
  });
};

/**
 * Run Assignment Rules on a conversation
 * You can let a conversation be automatically assigned following assignment rules.
 * {% admonition type="attention" name="When using workflows" %}
 * It is not possible to use this endpoint with Workflows.
 * {% /admonition %}
 *
 */
export const autoAssignConversation = <ThrowOnError extends boolean = false>(
  options: Options<AutoAssignConversationData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<AutoAssignConversationResponse, AutoAssignConversationError, ThrowOnError>({
    ...options,
    url: '/conversations/{id}/run_assignment_rules',
  });
};

/**
 * Attach a contact to a conversation
 * You can add participants who are contacts to a conversation, on behalf of either another contact or an admin.
 *
 * {% admonition type="attention" name="Contacts without an email" %}
 * If you add a contact via the email parameter and there is no user/lead found on that workspace with he given email, then we will create a new contact with `role` set to `lead`.
 * {% /admonition %}
 *
 *
 */
export const attachContactToConversation = <ThrowOnError extends boolean = false>(
  options: Options<AttachContactToConversationData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AttachContactToConversationResponse,
    AttachContactToConversationError,
    ThrowOnError
  >({
    ...options,
    url: '/conversations/{id}/customers',
  });
};

/**
 * Detach a contact from a group conversation
 * You can add participants who are contacts to a conversation, on behalf of either another contact or an admin.
 *
 * {% admonition type="attention" name="Contacts without an email" %}
 * If you add a contact via the email parameter and there is no user/lead found on that workspace with he given email, then we will create a new contact with `role` set to `lead`.
 * {% /admonition %}
 *
 *
 */
export const detachContactFromConversation = <ThrowOnError extends boolean = false>(
  options: Options<DetachContactFromConversationData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DetachContactFromConversationResponse,
    DetachContactFromConversationError,
    ThrowOnError
  >({
    ...options,
    url: '/conversations/{conversation_id}/customers/{contact_id}',
  });
};

/**
 * Redact a conversation part
 * You can redact a conversation part or the source message of a conversation (as seen in the source object).
 *
 * {% admonition type="info" name="Redacting parts and messages" %}
 * If you are redacting a conversation part, it must have a `body`. If you are redacting a source message, it must have been created by a contact. We will return a `conversation_part_not_redactable` error if these criteria are not met.
 * {% /admonition %}
 *
 *
 */
export const redactConversation = <ThrowOnError extends boolean = false>(
  options?: Options<RedactConversationData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<RedactConversationResponse, RedactConversationError, ThrowOnError>({
    ...options,
    url: '/conversations/redact',
  });
};

/**
 * List all data attributes
 * You can fetch a list of all data attributes belonging to a workspace for contacts, companies or conversations.
 */
export const lisDataAttributes = <ThrowOnError extends boolean = false>(
  options?: Options<LisDataAttributesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<LisDataAttributesResponse, LisDataAttributesError, ThrowOnError>({
    ...options,
    url: '/data_attributes',
  });
};

/**
 * Create a data attribute
 * You can create a data attributes for a `contact` or a `company`.
 */
export const createDataAttribute = <ThrowOnError extends boolean = false>(
  options?: Options<CreateDataAttributeData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateDataAttributeResponse, CreateDataAttributeError, ThrowOnError>({
    ...options,
    url: '/data_attributes',
  });
};

/**
 * Update a data attribute
 *
 * You can update a data attribute.
 *
 * > 🚧 Updating the data type is not possible
 * >
 * > It is currently a dangerous action to execute changing a data attribute's type via the API. You will need to update the type via the UI instead.
 *
 */
export const updateDataAttribute = <ThrowOnError extends boolean = false>(
  options: Options<UpdateDataAttributeData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateDataAttributeResponse, UpdateDataAttributeError, ThrowOnError>({
    ...options,
    url: '/data_attributes/{id}',
  });
};

/**
 * Submit a data event
 *
 * You will need an Access Token that has write permissions to send Events. Once you have a key you can submit events via POST to the Events resource, which is located at https://api.intercom.io/events, or you can send events using one of the client libraries. When working with the HTTP API directly a client should send the event with a `Content-Type` of `application/json`.
 *
 * When using the JavaScript API, [adding the code to your app](http://docs.intercom.io/configuring-Intercom/tracking-user-events-in-your-app) makes the Events API available. Once added, you can submit an event using the `trackEvent` method. This will associate the event with the Lead or currently logged-in user or logged-out visitor/lead and send it to Intercom. The final parameter is a map that can be used to send optional metadata about the event.
 *
 * With the Ruby client you pass a hash describing the event to `Intercom::Event.create`, or call the `track_user` method directly on the current user object (e.g. `user.track_event`).
 *
 * **NB: For the JSON object types, please note that we do not currently support nested JSON structure.**
 *
 * | Type            | Description                                                                                                                                                                                                     | Example                                                                           |
 * | :-------------- | :-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | :-------------------------------------------------------------------------------- |
 * | String          | The value is a JSON String                                                                                                                                                                                      | `"source":"desktop"`                                                              |
 * | Number          | The value is a JSON Number                                                                                                                                                                                      | `"load": 3.67`                                                                    |
 * | Date            | The key ends with the String `_date` and the value is a [Unix timestamp](http://en.wikipedia.org/wiki/Unix_time), assumed to be in the [UTC](http://en.wikipedia.org/wiki/Coordinated_Universal_Time) timezone. | `"contact_date": 1392036272`                                                      |
 * | Link            | The value is a HTTP or HTTPS URI.                                                                                                                                                                               | `"article": "https://example.org/ab1de.html"`                                     |
 * | Rich Link       | The value is a JSON object that contains `url` and `value` keys.                                                                                                                                                | `"article": {"url": "https://example.org/ab1de.html", "value":"the dude abides"}` |
 * | Monetary Amount | The value is a JSON object that contains `amount` and `currency` keys. The `amount` key is a positive integer representing the amount in cents. The price in the example to the right denotes €349.99.          | `"price": {"amount": 34999, "currency": "eur"}`                                   |
 *
 * **Lead Events**
 *
 * When submitting events for Leads, you will need to specify the Lead's `id`.
 *
 * **Metadata behaviour**
 *
 * - We currently limit the number of tracked metadata keys to 10 per event. Once the quota is reached, we ignore any further keys we receive. The first 10 metadata keys are determined by the order in which they are sent in with the event.
 * - It is not possible to change the metadata keys once the event has been sent. A new event will need to be created with the new keys and you can archive the old one.
 * - There might be up to 24 hrs delay when you send a new metadata for an existing event.
 *
 * **Event de-duplication**
 *
 * The API may detect and ignore duplicate events. Each event is uniquely identified as a combination of the following data - the Workspace identifier, the Contact external identifier, the Data Event name and the Data Event created time. As a result, it is **strongly recommended** to send a second granularity Unix timestamp in the `created_at` field.
 *
 * Duplicated events are responded to using the normal `202 Accepted` code - an error is not thrown, however repeat requests will be counted against any rate limit that is in place.
 *
 * ### HTTP API Responses
 *
 * - Successful responses to submitted events return `202 Accepted` with an empty body.
 * - Unauthorised access will be rejected with a `401 Unauthorized` or `403 Forbidden` response code.
 * - Events sent about users that cannot be found will return a `404 Not Found`.
 * - Event lists containing duplicate events will have those duplicates ignored.
 * - Server errors will return a `500` response code and may contain an error message in the body.
 *
 *
 */
export const createDataEvent = <ThrowOnError extends boolean = false>(
  options?: Options<CreateDataEventData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateDataEventResponse, CreateDataEventError, ThrowOnError>({
    ...options,
    url: '/events',
  });
};

/**
 * List all data events
 *
 * > 🚧
 * >
 * > Please note that you can only 'list' events that are less than 90 days old. Event counts and summaries will still include your events older than 90 days but you cannot 'list' these events individually if they are older than 90 days
 *
 * The events belonging to a customer can be listed by sending a GET request to `https://api.intercom.io/events` with a user or lead identifier along with a `type` parameter. The identifier parameter can be one of `user_id`, `email` or `intercom_user_id`. The `type` parameter value must be `user`.
 *
 * - `https://api.intercom.io/events?type=user&user_id={user_id}`
 * - `https://api.intercom.io/events?type=user&email={email}`
 * - `https://api.intercom.io/events?type=user&intercom_user_id={id}` (this call can be used to list leads)
 *
 * The `email` parameter value should be [url encoded](http://en.wikipedia.org/wiki/Percent-encoding) when sending.
 *
 * You can optionally define the result page size as well with the `per_page` parameter.
 *
 */
export const lisDataEvents = <ThrowOnError extends boolean = false>(
  options: Options<LisDataEventsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<LisDataEventsResponse, LisDataEventsError, ThrowOnError>({
    ...options,
    url: '/events',
  });
};

/**
 * Create event summaries
 * Create event summaries for a user. Event summaries are used to track the number of times an event has occurred, the first time it occurred and the last time it occurred.
 *
 *
 */
export const dataEventSummaries = <ThrowOnError extends boolean = false>(
  options?: Options<DataEventSummariesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DataEventSummariesResponse, DataEventSummariesError, ThrowOnError>({
    ...options,
    url: '/events/summaries',
  });
};

/**
 * Create content data export
 * To create your export job, you need to send a `POST` request to the export endpoint `https://api.intercom.io/export/content/data`.
 *
 * The only parameters you need to provide are the range of dates that you want exported.
 *
 * >🚧 Limit of one active job
 * >
 * > You can only have one active job per workspace. You will receive a HTTP status code of 429 with the message Exceeded rate limit of 1 pending message data export jobs if you attempt to create a second concurrent job.
 *
 * >❗️ Updated_at not included
 * >
 * > It should be noted that the timeframe only includes messages sent during the time period and not messages that were only updated during this period. For example, if a message was updated yesterday but sent two days ago, you would need to set the created_at_after date before the message was sent to include that in your retrieval job.
 *
 * >📘 Date ranges are inclusive
 * >
 * > Requesting data for 2018-06-01 until 2018-06-30 will get all data for those days including those specified - e.g. 2018-06-01 00:00:00 until 2018-06-30 23:59:99.
 *
 */
export const createDataExport = <ThrowOnError extends boolean = false>(
  options?: Options<CreateDataExportData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateDataExportResponse, CreateDataExportError, ThrowOnError>({
    ...options,
    url: '/export/content/data',
  });
};

/**
 * Show content data export
 * You can view the status of your job by sending a `GET` request to the URL
 * `https://api.intercom.io/export/content/data/{job_identifier}` - the `{job_identifier}` is the value returned in the response when you first created the export job. More on it can be seen in the Export Job Model.
 *
 * > 🚧 Jobs expire after two days
 * > All jobs that have completed processing (and are thus available to download from the provided URL) will have an expiry limit of two days from when the export ob completed. After this, the data will no longer be available.
 *
 */
export const getDataExport = <ThrowOnError extends boolean = false>(
  options: Options<GetDataExportData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetDataExportResponse, GetDataExportError, ThrowOnError>({
    ...options,
    url: '/export/content/data/{job_identifier}',
  });
};

/**
 * Cancel content data export
 * You can cancel your job
 */
export const cancelDataExport = <ThrowOnError extends boolean = false>(
  options: Options<CancelDataExportData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CancelDataExportResponse, CancelDataExportError, ThrowOnError>({
    ...options,
    url: '/export/cancel/{job_identifier}',
  });
};

/**
 * Download content data export
 * When a job has a status of complete, and thus a filled download_url, you can download your data by hitting that provided URL, formatted like so: https://api.intercom.io/download/content/data/xyz1234.
 *
 * Your exported message data will be streamed continuously back down to you in a gzipped CSV format.
 *
 * > 📘 Octet header required
 * >
 * > You will have to specify the header Accept: `application/octet-stream` when hitting this endpoint.
 *
 */
export const downloadDataExport = <ThrowOnError extends boolean = false>(
  options: Options<DownloadDataExportData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DownloadDataExportResponse, DownloadDataExportError, ThrowOnError>({
    ...options,
    url: '/download/content/data/{job_identifier}',
  });
};

/**
 * Create a message
 * You can create a message that has been initiated by an admin. The conversation can be either an in-app message or an email.
 *
 * > 🚧 Sending for visitors
 * >
 * > There can be a short delay between when a contact is created and when a contact becomes available to be messaged through the API. A 404 Not Found error will be returned in this case.
 *
 * This will return the Message model that has been created.
 *
 * > 🚧 Retrieving Associated Conversations
 * >
 * > As this is a message, there will be no conversation present until the contact responds. Once they do, you will have to search for a contact's conversations with the id of the message.
 *
 */
export const createMessage = <ThrowOnError extends boolean = false>(
  options?: Options<CreateMessageData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateMessageResponse, CreateMessageError, ThrowOnError>({
    ...options,
    url: '/messages',
  });
};

/**
 * List all news items
 * You can fetch a list of all news items
 */
export const listNewsItems = <ThrowOnError extends boolean = false>(
  options?: Options<ListNewsItemsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListNewsItemsResponse, ListNewsItemsError, ThrowOnError>({
    ...options,
    url: '/news/news_items',
  });
};

/**
 * Create a news item
 * You can create a news item
 */
export const createNewsItem = <ThrowOnError extends boolean = false>(
  options?: Options<CreateNewsItemData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateNewsItemResponse, CreateNewsItemError, ThrowOnError>({
    ...options,
    url: '/news/news_items',
  });
};

/**
 * Retrieve a news item
 * You can fetch the details of a single news item.
 */
export const retrieveNewsItem = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveNewsItemData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveNewsItemResponse, RetrieveNewsItemError, ThrowOnError>({
    ...options,
    url: '/news/news_items/{id}',
  });
};

/**
 * Update a news item
 */
export const updateNewsItem = <ThrowOnError extends boolean = false>(
  options: Options<UpdateNewsItemData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateNewsItemResponse, UpdateNewsItemError, ThrowOnError>({
    ...options,
    url: '/news/news_items/{id}',
  });
};

/**
 * Delete a news item
 * You can delete a single news item.
 */
export const deleteNewsItem = <ThrowOnError extends boolean = false>(
  options: Options<DeleteNewsItemData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteNewsItemResponse, DeleteNewsItemError, ThrowOnError>({
    ...options,
    url: '/news/news_items/{id}',
  });
};

/**
 * List all live newsfeed items
 * You can fetch a list of all news items that are live on a given newsfeed
 */
export const listLiveNewsfeedItems = <ThrowOnError extends boolean = false>(
  options: Options<ListLiveNewsfeedItemsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListLiveNewsfeedItemsResponse, ListLiveNewsfeedItemsError, ThrowOnError>({
    ...options,
    url: '/news/newsfeeds/{id}/items',
  });
};

/**
 * List all newsfeeds
 * You can fetch a list of all newsfeeds
 */
export const listNewsfeeds = <ThrowOnError extends boolean = false>(
  options?: Options<ListNewsfeedsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListNewsfeedsResponse, ListNewsfeedsError, ThrowOnError>({
    ...options,
    url: '/news/newsfeeds',
  });
};

/**
 * Retrieve a newsfeed
 * You can fetch the details of a single newsfeed
 */
export const retrieveNewsfeed = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveNewsfeedData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveNewsfeedResponse, RetrieveNewsfeedError, ThrowOnError>({
    ...options,
    url: '/news/newsfeeds/{id}',
  });
};

/**
 * Retrieve a note
 * You can fetch the details of a single note.
 */
export const retrieveNote = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveNoteData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveNoteResponse, RetrieveNoteError, ThrowOnError>({
    ...options,
    url: '/notes/{id}',
  });
};

/**
 * List all segments
 * You can fetch a list of all segments.
 */
export const listSegments = <ThrowOnError extends boolean = false>(
  options?: Options<ListSegmentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListSegmentsResponse, ListSegmentsError, ThrowOnError>({
    ...options,
    url: '/segments',
  });
};

/**
 * Retrieve a segment
 * You can fetch the details of a single segment.
 */
export const retrieveSegment = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveSegmentData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveSegmentResponse, RetrieveSegmentError, ThrowOnError>({
    ...options,
    url: '/segments/{id}',
  });
};

/**
 * List subscription types
 * You can list all subscription types. A list of subscription type objects will be returned.
 */
export const listSubscriptionTypes = <ThrowOnError extends boolean = false>(
  options?: Options<ListSubscriptionTypesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListSubscriptionTypesResponse, ListSubscriptionTypesError, ThrowOnError>({
    ...options,
    url: '/subscription_types',
  });
};

/**
 * Create a phone Switch
 * You can use the API to deflect phone calls to the Intercom Messenger.
 * Calling this endpoint will send an SMS with a link to the Messenger to the phone number specified.
 *
 * If custom attributes are specified, they will be added to the user or lead's custom data attributes.
 *
 */
export const createPhoneSwitch = <ThrowOnError extends boolean = false>(
  options?: Options<CreatePhoneSwitchData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreatePhoneSwitchResponse, CreatePhoneSwitchError, ThrowOnError>({
    ...options,
    url: '/phone_call_redirects',
  });
};

/**
 * List all tags
 * You can fetch a list of all tags for a given workspace.
 *
 *
 */
export const listTags = <ThrowOnError extends boolean = false>(options?: Options<ListTagsData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListTagsResponse, ListTagsError, ThrowOnError>({
    ...options,
    url: '/tags',
  });
};

/**
 * Create or update a tag, Tag or untag companies, Tag contacts
 * You can use this endpoint to perform the following operations:
 *
 * **1. Create a new tag:** You can create a new tag by passing in the tag name as specified in "Create or Update Tag Request Payload" described below.
 *
 * **2. Update an existing tag:** You can update an existing tag by passing the id of the tag as specified in "Create or Update Tag Request Payload" described below.
 *
 * **3. Tag Companies:** You can tag single company or a list of companies. You can tag a company by passing in the tag name and the company details as specified in "Tag Company Request Payload" described below. Also, if the tag doesn't exist then a new one will be created automatically.
 *
 * **4. Untag Companies:** You can untag a single company or a list of companies. You can untag a company by passing in the tag id and the company details as specified in "Untag Company Request Payload" described below.
 *
 * **5. Tag Multiple Users:** You can tag a list of users. You can tag the users by passing in the tag name and the user details as specified in "Tag Users Request Payload" described below.
 *
 * Each operation will return a tag object.
 *
 */
export const createTag = <ThrowOnError extends boolean = false>(options?: Options<CreateTagData, ThrowOnError>) => {
  return (options?.client ?? client).post<CreateTagResponse, CreateTagError, ThrowOnError>({
    ...options,
    url: '/tags',
  });
};

/**
 * Find a specific tag
 * You can fetch the details of tags that are on the workspace by their id.
 * This will return a tag object.
 *
 */
export const findTag = <ThrowOnError extends boolean = false>(options: Options<FindTagData, ThrowOnError>) => {
  return (options?.client ?? client).get<FindTagResponse, FindTagError, ThrowOnError>({
    ...options,
    url: '/tags/{id}',
  });
};

/**
 * Delete tag
 * You can delete the details of tags that are on the workspace by passing in the id.
 */
export const deleteTag = <ThrowOnError extends boolean = false>(options: Options<DeleteTagData, ThrowOnError>) => {
  return (options?.client ?? client).delete<DeleteTagResponse, DeleteTagError, ThrowOnError>({
    ...options,
    url: '/tags/{id}',
  });
};

/**
 * List all teams
 * This will return a list of team objects for the App.
 */
export const listTeams = <ThrowOnError extends boolean = false>(options?: Options<ListTeamsData, ThrowOnError>) => {
  return (options?.client ?? client).get<ListTeamsResponse, ListTeamsError, ThrowOnError>({
    ...options,
    url: '/teams',
  });
};

/**
 * Retrieve a team
 * You can fetch the details of a single team, containing an array of admins that belong to this team.
 */
export const retrieveTeam = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveTeamData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<RetrieveTeamResponse, RetrieveTeamError, ThrowOnError>({
    ...options,
    url: '/teams/{id}',
  });
};

/**
 * Create a new attribute for a ticket type
 * You can create a new attribute for a ticket type.
 */
export const createTicketTypeAttribute = <ThrowOnError extends boolean = false>(
  options: Options<CreateTicketTypeAttributeData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CreateTicketTypeAttributeResponse,
    CreateTicketTypeAttributeError,
    ThrowOnError
  >({
    ...options,
    url: '/ticket_types/{ticket_type_id}/attributes',
  });
};

/**
 * Update an existing attribute for a ticket type
 * You can update an existing attribute for a ticket type.
 */
export const updateTicketTypeAttribute = <ThrowOnError extends boolean = false>(
  options: Options<UpdateTicketTypeAttributeData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    UpdateTicketTypeAttributeResponse,
    UpdateTicketTypeAttributeError,
    ThrowOnError
  >({
    ...options,
    url: '/ticket_types/{ticket_type_id}/attributes/{id}',
  });
};

/**
 * List all ticket types
 * You can get a list of all ticket types for a workspace.
 */
export const listTicketTypes = <ThrowOnError extends boolean = false>(
  options?: Options<ListTicketTypesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<ListTicketTypesResponse, ListTicketTypesError, ThrowOnError>({
    ...options,
    url: '/ticket_types',
  });
};

/**
 * Create a ticket type
 * You can create a new ticket type.
 * > 📘 Creating ticket types.
 * >
 * > Every ticket type will be created with two default attributes: _default_title_ and _default_description_.
 * > For the `icon` propery, use an emoji from [Twemoji Cheatsheet](https://twemoji-cheatsheet.vercel.app/)
 *
 */
export const createTicketType = <ThrowOnError extends boolean = false>(
  options?: Options<CreateTicketTypeData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateTicketTypeResponse, CreateTicketTypeError, ThrowOnError>({
    ...options,
    url: '/ticket_types',
  });
};

/**
 * Retrieve a ticket type
 * You can fetch the details of a single ticket type.
 */
export const getTicketType = <ThrowOnError extends boolean = false>(
  options: Options<GetTicketTypeData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTicketTypeResponse, GetTicketTypeError, ThrowOnError>({
    ...options,
    url: '/ticket_types/{id}',
  });
};

/**
 * Update a ticket type
 *
 * You can update a ticket type.
 *
 * > 📘 Updating a ticket type.
 * >
 * > For the `icon` propery, use an emoji from [Twemoji Cheatsheet](https://twemoji-cheatsheet.vercel.app/)
 *
 */
export const updateTicketType = <ThrowOnError extends boolean = false>(
  options: Options<UpdateTicketTypeData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateTicketTypeResponse, UpdateTicketTypeError, ThrowOnError>({
    ...options,
    url: '/ticket_types/{id}',
  });
};

/**
 * Reply to a ticket
 * You can reply to a ticket with a note from an admin.
 */
export const replyTicket = <ThrowOnError extends boolean = false>(options: Options<ReplyTicketData, ThrowOnError>) => {
  return (options?.client ?? client).post<ReplyTicketResponse, ReplyTicketError, ThrowOnError>({
    ...options,
    url: '/tickets/{id}/reply',
  });
};

/**
 * Create a ticket
 * You can create a new ticket.
 */
export const createTicket = <ThrowOnError extends boolean = false>(
  options?: Options<CreateTicketData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CreateTicketResponse, CreateTicketError, ThrowOnError>({
    ...options,
    url: '/tickets',
  });
};

/**
 * Update a ticket
 * You can update a ticket.
 */
export const updateTicket = <ThrowOnError extends boolean = false>(
  options: Options<UpdateTicketData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateTicketResponse, UpdateTicketError, ThrowOnError>({
    ...options,
    url: '/tickets/{id}',
  });
};

/**
 * Retrieve a ticket
 * You can fetch the details of a single ticket.
 */
export const getTicket = <ThrowOnError extends boolean = false>(options: Options<GetTicketData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetTicketResponse, GetTicketError, ThrowOnError>({
    ...options,
    url: '/tickets/{id}',
  });
};

/**
 * Update a visitor
 * Sending a PUT request to `/visitors` will result in an update of an existing Visitor.
 *
 * **Option 1.** You can update a visitor by passing in the `user_id` of the visitor in the Request body.
 *
 * **Option 2.** You can update a visitor by passing in the `id` of the visitor in the Request body.
 *
 */
export const updateVisitor = <ThrowOnError extends boolean = false>(
  options?: Options<UpdateVisitorData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<UpdateVisitorResponse, UpdateVisitorError, ThrowOnError>({
    ...options,
    url: '/visitors',
  });
};

/**
 * Retrieve a visitor with User ID
 * You can fetch the details of a single visitor.
 */
export const retrieveVisitorWithUserId = <ThrowOnError extends boolean = false>(
  options: Options<RetrieveVisitorWithUserIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    RetrieveVisitorWithUserIdResponse,
    RetrieveVisitorWithUserIdError,
    ThrowOnError
  >({
    ...options,
    url: '/visitors',
  });
};

/**
 * Convert a visitor
 * You can merge a Visitor to a Contact of role type `lead` or `user`.
 *
 * > 📘 What happens upon a visitor being converted?
 * >
 * > If the User exists, then the Visitor will be merged into it, the Visitor deleted and the User returned. If the User does not exist, the Visitor will be converted to a User, with the User identifiers replacing it's Visitor identifiers.
 *
 */
export const convertVisitor = <ThrowOnError extends boolean = false>(
  options?: Options<ConvertVisitorData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<ConvertVisitorResponse, ConvertVisitorError, ThrowOnError>({
    ...options,
    url: '/visitors/convert',
  });
};
