// This file is auto-generated by @hey-api/openapi-ts

export const CaptionDataSchema = {
  properties: {
    created_time: {
      description: 'Caption creation UNIX timestamp',
      type: 'string',
    },
    from: {
      $ref: '#/definitions/UserShortInfo',
      description: 'User who created this caption',
    },
    id: {
      description: 'ID of this caption',
      type: 'string',
    },
    text: {
      description: 'Caption text',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const CommentEntrySchema = {
  properties: {
    created_time: {
      description: 'Comment creation UNIX timestamp',
      type: 'string',
    },
    from: {
      $ref: '#/definitions/UserShortInfo',
      description: 'User who posted this comment',
    },
    id: {
      description: 'ID of this comment',
      type: 'string',
    },
    text: {
      description: 'Text of the comment',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const CommentsCollectionSchema = {
  properties: {
    count: {
      description: 'Nember of comments available, data does not necessary contain all comments',
      type: 'integer',
    },
    data: {
      description:
        'Collection of comment entries; **warning:** deprecated for Apps [created on or after Nov 17, 2015](http://instagram.com/developer/changelog/)',
      items: {
        $ref: '#/definitions/CommentEntry',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const CommentsResponseSchema = {
  properties: {
    data: {
      description: 'Collection of comments',
      items: {
        $ref: '#/definitions/CommentEntry',
      },
      type: 'array',
    },
    meta: {
      $ref: '#/definitions/MetaData',
      description: 'Response meta-data',
    },
  },
  type: 'object',
} as const;

export const CursorPaginationInfoSchema = {
  properties: {
    next_cursor: {
      description: 'The cursor ID of the next page',
      type: 'string',
    },
    next_url: {
      description: 'URL to retrieve next page of entries',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const IdPaginationInfoSchema = {
  properties: {
    next_max_id: {
      description: 'The max ID of the next page',
      type: 'string',
    },
    next_url: {
      description: 'URL to retrieve next page of entries',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const ImageInfoSchema = {
  properties: {
    height: {
      description: 'Image/video height in pixels',
      type: 'integer',
    },
    url: {
      description: 'URL of the image/video resource',
      type: 'string',
    },
    width: {
      description: 'Image/video width in pixels',
      type: 'integer',
    },
  },
  type: 'object',
} as const;

export const ImagesDataSchema = {
  properties: {
    low_resolution: {
      $ref: '#/definitions/ImageInfo',
      description: 'Image in low resolution',
    },
    standard_resolution: {
      $ref: '#/definitions/ImageInfo',
      description: 'Image in standard resolution',
    },
    thumbnail: {
      $ref: '#/definitions/ImageInfo',
      description: 'Thumbnail of the image',
    },
  },
  type: 'object',
} as const;

export const LikesCollectionSchema = {
  properties: {
    count: {
      description: 'Nember of likes available, data does not necessary contain all comments',
      type: 'integer',
    },
    data: {
      description:
        'Collection of users who liked; **warning:** deprecated for Apps [created on or after Nov 17, 2015](http://instagram.com/developer/changelog/)',
      items: {
        $ref: '#/definitions/UserShortInfo',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const LocationInfoSchema = {
  properties: {
    id: {
      description: "ID of this location (in some responses it has a type of 'integer')",
      type: 'string',
    },
    latitude: {
      description: 'Location latitude',
      format: 'double',
      type: 'number',
    },
    longitude: {
      description: 'Location longitude',
      format: 'double',
      type: 'number',
    },
    name: {
      description: 'Location name',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const LocationInfoResponseSchema = {
  properties: {
    data: {
      $ref: '#/definitions/LocationInfo',
      description: 'Location brief information',
    },
    meta: {
      $ref: '#/definitions/MetaData',
      description: 'Response meta-data',
    },
  },
  type: 'object',
} as const;

export const LocationSearchResponseSchema = {
  properties: {
    data: {
      description: 'List of found locations',
      items: {
        $ref: '#/definitions/LocationInfo',
      },
      type: 'array',
    },
    meta: {
      $ref: '#/definitions/MetaData',
      description: 'Response meta-data',
    },
  },
  type: 'object',
} as const;

export const MediaEntrySchema = {
  properties: {
    attribution: {
      description: '??? Unknown ???',
      type: 'string',
    },
    caption: {
      $ref: '#/definitions/CaptionData',
      description: 'Describes caption of this media',
    },
    comments: {
      $ref: '#/definitions/CommentsCollection',
      description: 'Comments of this media entry',
    },
    created_time: {
      description: 'Media creation UNIX timestamp',
      type: 'string',
    },
    filter: {
      description: 'Filter of this media entry',
      type: 'string',
    },
    id: {
      description: 'ID of a media entry',
      type: 'string',
    },
    images: {
      $ref: '#/definitions/ImagesData',
      description: 'Images data in different resolutions',
    },
    likes: {
      $ref: '#/definitions/LikesCollection',
      description: 'Likes of this media entry',
    },
    link: {
      description: 'Fixed URL of this media entry',
      type: 'string',
    },
    location: {
      $ref: '#/definitions/LocationInfo',
      description: 'Location data for this media if available',
    },
    tags: {
      description: 'List of tags assigned to this media',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    type: {
      description: 'Type of this media entry',
      enum: ['image', 'video'],
      type: 'string',
    },
    user: {
      $ref: '#/definitions/UserShortInfo',
      description: 'User who posted this media',
    },
    user_has_liked: {
      description: 'Indicates whether authenticated user has liked this media or not',
      type: 'boolean',
    },
    users_in_photo: {
      description: 'Users located on this media entry',
      items: {
        $ref: '#/definitions/UserInPhoto',
      },
      type: 'array',
    },
    videos: {
      $ref: '#/definitions/VideosData',
      description: "Videos data in different resolutions, applied for 'video' type",
    },
  },
  type: 'object',
} as const;

export const MediaEntryResponseSchema = {
  properties: {
    data: {
      $ref: '#/definitions/MediaEntry',
      description: 'Media resource information',
    },
    meta: {
      $ref: '#/definitions/MetaData',
      description: 'Response meta-data',
    },
  },
  type: 'object',
} as const;

export const MediaListResponseSchema = {
  properties: {
    data: {
      description: 'List of media entries',
      items: {
        $ref: '#/definitions/MediaEntry',
      },
      type: 'array',
    },
    meta: {
      $ref: '#/definitions/MetaData',
      description: 'Response meta-data',
    },
    pagination: {
      $ref: '#/definitions/IdPaginationInfo',
      description: 'Information for pagination',
    },
  },
  type: 'object',
} as const;

export const MediaSearchResponseSchema = {
  properties: {
    data: {
      description: 'Found media entries; some end-points do not return likes informtaion',
      items: {
        $ref: '#/definitions/MediaEntry',
      },
      type: 'array',
    },
    meta: {
      $ref: '#/definitions/MetaData',
      description: 'Response meta-data',
    },
  },
  type: 'object',
} as const;

export const MetaDataSchema = {
  properties: {
    code: {
      description: 'HTTP result code',
      format: 'int32',
      type: 'integer',
    },
  },
  type: 'object',
} as const;

export const PositionSchema = {
  properties: {
    x: {
      description: 'X position (horizontal)',
      format: 'float',
      type: 'number',
    },
    y: {
      description: 'Y position (vertical)',
      format: 'float',
      type: 'number',
    },
  },
  type: 'object',
} as const;

export const RelationshipInfoSchema = {
  properties: {
    incoming_status: {
      description: 'Status of incoming relationship',
      enum: ['none', 'followed_by', 'requested_by'],
      type: 'string',
    },
    outgoing_status: {
      description: 'Status of outgoing relationship',
      enum: ['none', 'follows', 'requested'],
      type: 'string',
    },
    target_user_is_private: {
      description: 'Indicates whether target user is private or not',
      type: 'boolean',
    },
  },
  type: 'object',
} as const;

export const RelationshipPostResponseSchema = {
  properties: {
    data: {
      $ref: '#/definitions/RelationshipStatus',
      description: 'Current relationship status',
    },
    meta: {
      $ref: '#/definitions/MetaData',
      description: 'Response meta-data',
    },
  },
  type: 'object',
} as const;

export const RelationshipResponseSchema = {
  properties: {
    data: {
      $ref: '#/definitions/RelationshipInfo',
      description: 'Relationship information',
    },
    meta: {
      $ref: '#/definitions/MetaData',
      description: 'Response meta-data',
    },
  },
  type: 'object',
} as const;

export const RelationshipStatusSchema = {
  properties: {
    outgoing_status: {
      description: 'Status of outgoing relationship',
      enum: ['none', 'follows', 'requested'],
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const StatusResponseSchema = {
  properties: {
    data: {
      description: "No data - 'null'",
      type: 'string',
    },
    meta: {
      $ref: '#/definitions/MetaData',
      description: 'Response meta-data',
    },
  },
  type: 'object',
} as const;

export const TagInfoSchema = {
  properties: {
    media_count: {
      description: 'Overall number of media entries taged with this name',
      format: 'int64',
      type: 'integer',
    },
    name: {
      description: 'Tag name',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const TagInfoResponseSchema = {
  properties: {
    data: {
      $ref: '#/definitions/TagInfo',
      description: 'Tag brief information',
    },
    meta: {
      $ref: '#/definitions/MetaData',
      description: 'Response meta-data',
    },
  },
  type: 'object',
} as const;

export const TagMediaListResponseSchema = {
  properties: {
    data: {
      description: 'List of media entries with this tag',
      items: {
        $ref: '#/definitions/MediaEntry',
      },
      type: 'array',
    },
    meta: {
      $ref: '#/definitions/MetaData',
      description: 'Response meta-data',
    },
    pagination: {
      $ref: '#/definitions/TagPaginationInfo',
      description: 'Information for pagination',
    },
  },
  type: 'object',
} as const;

export const TagPaginationInfoSchema = {
  properties: {
    deprecation_warning: {
      description: 'The deprication warning, if information is available',
      type: 'string',
    },
    min_tag_id: {
      description: 'The min ID of a tag for the next page',
      type: 'string',
    },
    next_max_id: {
      description: 'Depricated. Use min_tag_id instead',
      type: 'string',
    },
    next_max_tag_id: {
      description: 'The max ID of a tag for the next page',
      type: 'string',
    },
    next_min_id: {
      description: 'Depricated. Use max_tag_id instead',
      type: 'string',
    },
    next_url: {
      description: 'URL to retrieve next page of entries',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const TagSearchResponseSchema = {
  properties: {
    data: {
      description: 'List of found tags with brief statistics',
      items: {
        $ref: '#/definitions/TagInfo',
      },
      type: 'array',
    },
    meta: {
      $ref: '#/definitions/MetaData',
      description: 'Response meta-data',
    },
  },
  type: 'object',
} as const;

export const UserCountsSchema = {
  properties: {
    followed_by: {
      description: 'Number of followers of this user',
      format: 'int32',
      type: 'integer',
    },
    follows: {
      description: 'Number of users followed by this user',
      format: 'int32',
      type: 'integer',
    },
    media: {
      description: 'Number of user media',
      format: 'int32',
      type: 'integer',
    },
  },
  type: 'object',
} as const;

export const UserInPhotoSchema = {
  properties: {
    position: {
      $ref: '#/definitions/Position',
      description: 'Position in photo',
    },
    user: {
      $ref: '#/definitions/UserShortInfo',
      description: 'User who is indicated on the photo',
    },
  },
  type: 'object',
} as const;

export const UserInfoSchema = {
  properties: {
    bio: {
      description: 'User biography',
      type: 'string',
    },
    counts: {
      $ref: '#/definitions/UserCounts',
      description: 'User statistics (counters)',
    },
    full_name: {
      description: 'User full name',
      type: 'string',
    },
    id: {
      description: 'User ID',
      type: 'string',
    },
    profile_picture: {
      description: 'URL to user profile picture',
      type: 'string',
    },
    username: {
      description: 'User name, nickname',
      type: 'string',
    },
    website: {
      description: 'URL to user web-site',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const UserResponseSchema = {
  properties: {
    data: {
      $ref: '#/definitions/UserInfo',
      description: 'User basic information',
    },
    meta: {
      $ref: '#/definitions/MetaData',
      description: 'Response meta-data',
    },
  },
  type: 'object',
} as const;

export const UserShortInfoSchema = {
  properties: {
    full_name: {
      description: 'User full name',
      type: 'string',
    },
    id: {
      description: 'User ID',
      type: 'string',
    },
    profile_picture: {
      description: 'URL to user profile picture',
      type: 'string',
    },
    username: {
      description: 'User name, nickname',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const UsersInfoResponseSchema = {
  properties: {
    data: {
      description: 'User short information entries',
      items: {
        $ref: '#/definitions/UserShortInfo',
      },
      type: 'array',
    },
    meta: {
      $ref: '#/definitions/MetaData',
      description: 'Response meta-data',
    },
  },
  type: 'object',
} as const;

export const UsersPagingResponseSchema = {
  properties: {
    data: {
      description: 'List of user short information entries',
      items: {
        $ref: '#/definitions/UserShortInfo',
      },
      type: 'array',
    },
    meta: {
      $ref: '#/definitions/MetaData',
      description: 'Response meta-data',
    },
    pagination: {
      $ref: '#/definitions/CursorPaginationInfo',
      description: 'Information for pagination',
    },
  },
  type: 'object',
} as const;

export const VideosDataSchema = {
  properties: {
    low_resolution: {
      $ref: '#/definitions/ImageInfo',
      description: 'Video in low resolution',
    },
    standard_resolution: {
      $ref: '#/definitions/ImageInfo',
      description: 'Video in standard resolution',
    },
  },
  type: 'object',
} as const;
