// Generated by ts-to-zod
import { z } from 'zod';

export const paidTimeOffSchema = z.object({
  name: z.string().optional(),
  accrual_unit: z.string().optional(),
  accrual_rate: z.string().optional(),
  accrual_period: z.string().optional(),
  accrual_balance: z.string().optional(),
  maximum_accrual_balance: z.string().optional().nullable(),
  paid_at_termination: z.boolean().optional(),
});

export const terminationSchema = z.object({
  id: z.number().optional(),
  uuid: z.string().optional(),
  version: z.string().optional(),
  employee_id: z.number().optional(),
  employee_uuid: z.number().optional(),
  active: z.boolean().optional(),
  effective_date: z.string().optional(),
  run_termination_payroll: z.boolean().optional(),
});

export const locationSchema = z.object({
  id: z.number().optional(),
  version: z.string().optional(),
  company_id: z.number().optional(),
  employee_id: z.number().optional(),
  phone_number: z.string().optional(),
  street_1: z.string().optional(),
  street_2: z.string().optional().nullable(),
  city: z.string().optional(),
  state: z.string().optional(),
  zip: z.string().optional(),
  country: z.string().optional(),
  active: z.boolean().optional(),
  mailing_address: z.boolean().optional(),
  filing_address: z.boolean().optional(),
});

export const garnishmentSchema = z.object({
  id: z.number().optional(),
  version: z.string().optional(),
  employee_id: z.number().optional(),
  active: z.boolean().optional(),
  amount: z.string().optional(),
  description: z.string().optional(),
  court_ordered: z.boolean().optional(),
  times: z.number().optional().nullable(),
  recurring: z.boolean().optional(),
  annual_maximum: z.string().optional().nullable(),
  pay_period_maximum: z.string().optional().nullable(),
  deduct_as_percentage: z.boolean().optional(),
});

export const currentEmploymentStatusSchema = z.union([
  z.literal('full_time'),
  z.literal('part_time_under_twenty_hours'),
  z.literal('part_time_twenty_plus_hours'),
  z.literal('variable'),
  z.literal('seasonal'),
]);

export const employeeOnboardingStatusSchema = z.object({
  uuid: z.string().optional(),
  onboarding_status: z.string().optional(),
  onboarding_steps: z
    .array(
      z.object({
        title: z.string().optional(),
        id: z.string().optional(),
        required: z.boolean().optional(),
        completed: z.boolean().optional(),
        requirements: z.array(z.string()).optional(),
      }),
    )
    .optional(),
});

export const compensationSchema = z.object({
  id: z.number().optional(),
  version: z.string().optional(),
  job_id: z.number().optional(),
  rate: z.string().optional(),
  payment_unit: z
    .union([z.literal('Hour'), z.literal('Week'), z.literal('Month'), z.literal('Year'), z.literal('Paycheck')])
    .optional(),
  flsa_status: z
    .union([z.literal('Exempt'), z.literal('Salaried Nonexempt'), z.literal('Nonexempt'), z.literal('Owner')])
    .optional(),
  effective_date: z.string().optional(),
});

export const paymentUnitSchema = z.union([
  z.literal('Hour'),
  z.literal('Week'),
  z.literal('Month'),
  z.literal('Year'),
  z.literal('Paycheck'),
]);

export const flsaStatusSchema = z.union([
  z.literal('Exempt'),
  z.literal('Salaried Nonexempt'),
  z.literal('Nonexempt'),
  z.literal('Owner'),
]);

export const formSchema = z.object({
  uuid: z.string().optional(),
  name: z.string().optional(),
  title: z.string().optional(),
  description: z.string().optional(),
  requires_signing: z.boolean().optional(),
});

export const industrySchema = z.object({
  company_uuid: z.string().optional(),
  naics_code: z.string().optional(),
  sic_codes: z.array(z.unknown()).optional(),
  title: z.string().optional(),
});

export const jobSchema = z.object({
  id: z.number().optional(),
  uuid: z.string().optional(),
  version: z.string().optional(),
  employee_id: z.number().optional(),
  employee_uuid: z.string().optional(),
  location_id: z.number().optional(),
  location: z
    .object({
      id: z.number().optional(),
      street_1: z.string().optional(),
      street_2: z.string().optional().nullable(),
      city: z.string().optional(),
      state: z.string().optional(),
      zip: z.string().optional(),
      country: z.string().optional(),
      inactive: z.boolean().optional(),
    })
    .optional(),
  hire_date: z.string().optional(),
  title: z.string().optional().nullable(),
  primary: z.boolean().optional(),
  rate: z.string().optional(),
  payment_unit: z.string().optional(),
  current_compensation_id: z.number().optional(),
  current_compensation_uuid: z.string().optional(),
  compensations: z.array(compensationSchema).optional(),
});

export const adminSchema = z.object({
  uuid: z.string().optional(),
  email: z.string().optional(),
  first_name: z.string().optional(),
  last_name: z.string().optional(),
});

export const companySchema = z.object({
  ein: z.string().optional(),
  entity_type: z
    .union([
      z.literal('C-Corporation'),
      z.literal('S-Corporation'),
      z.literal('Sole proprietor'),
      z.literal('LLC'),
      z.literal('LLP'),
      z.literal('Limited partnership'),
      z.literal('Co-ownership'),
      z.literal('Association'),
      z.literal('Trusteeship'),
      z.literal('General partnership'),
      z.literal('Joint venture'),
      z.literal('Non-Profit'),
    ])
    .optional(),
  tier: z
    .union([
      z.literal('core'),
      z.literal('complete'),
      z.literal('concierge'),
      z.literal('contractor_only'),
      z.literal('basic'),
    ])
    .optional()
    .nullable(),
  is_suspended: z.boolean().optional(),
  company_status: z.union([z.literal('Approved'), z.literal('Not Approved'), z.literal('Suspended')]).optional(),
  id: z.number().optional(),
  uuid: z.string().optional(),
  name: z.string().optional(),
  trade_name: z.string().optional(),
  locations: z.array(locationSchema).optional(),
  compensations: z
    .object({
      hourly: z
        .array(
          z.object({
            name: z.string().optional(),
            multiple: z.number().optional(),
          }),
        )
        .optional(),
      fixed: z
        .array(
          z.object({
            name: z.string().optional(),
          }),
        )
        .optional(),
      paid_time_off: z
        .array(
          z.object({
            name: z.string().optional(),
          }),
        )
        .optional(),
    })
    .optional(),
  primary_signatory: z
    .object({
      first_name: z.string().optional(),
      middle_initial: z.string().optional(),
      last_name: z.string().optional(),
      phone: z.string().optional(),
      email: z.string().optional(),
      home_address: z
        .object({
          street_1: z.string().optional(),
          street_2: z.string().optional().nullable(),
          city: z.string().optional(),
          state: z.string().optional(),
          zip: z.string().optional(),
          country: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  primary_payroll_admin: z
    .object({
      first_name: z.string().optional(),
      last_name: z.string().optional(),
      phone: z.string().optional(),
      email: z.string().optional(),
    })
    .optional(),
});

export const entityTypeSchema = z.union([
  z.literal('C-Corporation'),
  z.literal('S-Corporation'),
  z.literal('Sole proprietor'),
  z.literal('LLC'),
  z.literal('LLP'),
  z.literal('Limited partnership'),
  z.literal('Co-ownership'),
  z.literal('Association'),
  z.literal('Trusteeship'),
  z.literal('General partnership'),
  z.literal('Joint venture'),
  z.literal('Non-Profit'),
]);

export const tierSchema = z.union([
  z.literal('core'),
  z.literal('complete'),
  z.literal('concierge'),
  z.literal('contractor_only'),
  z.literal('basic'),
]);

export const companyStatusSchema = z.union([z.literal('Approved'), z.literal('Not Approved'), z.literal('Suspended')]);

export const companyOnboardingStatusSchema = z.object({
  uuid: z.string().optional(),
  onboarding_completed: z.boolean().optional(),
  onboarding_steps: z
    .array(
      z.object({
        title: z.string().optional(),
        id: z.string().optional(),
        required: z.boolean().optional(),
        completed: z.boolean().optional(),
        requirements: z.array(z.string()).optional(),
      }),
    )
    .optional(),
  '': z.string().optional(),
});

export const paymentConfigsSchema = z.object({
  company_uuid: z.string().optional(),
  partner_uuid: z.string().optional(),
  fast_payment_limit: z.number().optional(),
  payment_speed: z.string().optional(),
});

export const contractorSchema = z.object({
  id: z.number().optional(),
  company_id: z.number().optional(),
  wage_type: z.union([z.literal('Fixed'), z.literal('Hourly')]).optional(),
  is_active: z.boolean().optional(),
  version: z.string().optional(),
  type: z.union([z.literal('Individual'), z.literal('Business')]).optional(),
  first_name: z.string().optional().nullable(),
  last_name: z.string().optional().nullable(),
  middle_initial: z.string().optional().nullable(),
  business_name: z.string().optional().nullable(),
  ein: z.string().optional().nullable(),
  email: z.string().optional().nullable(),
  address: z
    .object({
      street_1: z.string().optional(),
      street_2: z.string().optional().nullable(),
      city: z.string().optional(),
      state: z.string().optional(),
      zip: z.string().optional(),
      country: z.string().optional(),
    })
    .optional(),
  hourly_rate: z.string().optional(),
});

export const wageTypeSchema = z.union([z.literal('Fixed'), z.literal('Hourly')]);

export const typeSchema = z.union([z.literal('Individual'), z.literal('Business')]);

export const contractorPaymentSchema = z.object({
  uuid: z.string().optional(),
  contractor_id: z.number().optional(),
  bonus: z.string().optional(),
  date: z.string().optional(),
  hours: z.string().optional(),
  payment_method: z
    .union([
      z.literal('Direct Deposit'),
      z.literal('Check'),
      z.literal('Historical Payment'),
      z.literal('Correction Payment'),
    ])
    .optional(),
  reimbursement: z.string().optional(),
  hourly_rate: z.string().optional(),
  wage: z.string().optional(),
  wage_type: z.union([z.literal('Hourly'), z.literal('Fixed')]).optional(),
  wage_total: z.string().optional(),
});

export const paymentMethodSchema = z.union([
  z.literal('Direct Deposit'),
  z.literal('Check'),
  z.literal('Historical Payment'),
  z.literal('Correction Payment'),
]);

export const contractorPaymentSummarySchema = z.object({
  total: z
    .object({
      reimbursements: z.string().optional(),
      wages: z.string().optional(),
    })
    .optional(),
  contractor_payments: z
    .array(
      z.object({
        contractor_id: z.number().optional(),
        reimbursement_total: z.string().optional(),
        wage_total: z.string().optional(),
        payments: z.array(contractorPaymentSchema).optional(),
      }),
    )
    .optional(),
});

export const timeOffRequestSchema = z.object({
  id: z.number().optional(),
  status: z.union([z.literal('pending'), z.literal('approved'), z.literal('denied')]).optional(),
  employee_note: z.string().optional(),
  employer_note: z.string().optional(),
  request_type: z.union([z.literal('vacation'), z.literal('sick')]).optional(),
  days: z.record(z.unknown()).optional(),
  employee: z
    .object({
      id: z.string().optional(),
      full_name: z.string().optional(),
    })
    .optional(),
  initiator: z
    .object({
      id: z.string().optional(),
      full_name: z.string().optional(),
    })
    .optional()
    .nullable(),
  approver: z
    .object({
      id: z.string().optional(),
      full_name: z.string().optional(),
    })
    .optional()
    .nullable(),
});

export const statusSchema = z.union([z.literal('pending'), z.literal('approved'), z.literal('denied')]);

export const requestTypeSchema = z.union([z.literal('vacation'), z.literal('sick')]);

export const currentUserSchema = z.object({
  id: z.number().optional(),
  email: z.string().optional(),
  roles: z
    .object({
      payroll_admin: z
        .object({
          companies: z
            .array(
              z.object({
                id: z.number().optional(),
                name: z.string().optional(),
                trade_name: z.string().optional(),
                locations: z.array(locationSchema).optional(),
              }),
            )
            .optional(),
        })
        .optional(),
    })
    .optional(),
});

export const payScheduleSchema = z.object({
  id: z.number().optional(),
  uuid: z.string().optional(),
  frequency: z
    .union([z.literal('Every week'), z.literal('Every other week'), z.literal('Twice per month'), z.literal('Monthly')])
    .optional(),
  anchor_pay_date: z.string().optional(),
  day_1: z.number().optional().nullable(),
  day_2: z.number().optional().nullable(),
  name: z.string().optional().nullable(),
  auto_pilot: z.boolean().optional(),
});

export const frequencySchema = z.union([
  z.literal('Every week'),
  z.literal('Every other week'),
  z.literal('Twice per month'),
  z.literal('Monthly'),
]);

export const companyBankAccountSchema = z.object({
  uuid: z.string().optional(),
  company_uuid: z.string().optional(),
  account_type: z.union([z.literal('Checking'), z.literal('Savings')]).optional(),
  routing_number: z.string().optional(),
  hidden_account_number: z.string().optional(),
  verification_status: z
    .union([z.literal('awaiting_deposits'), z.literal('ready_for_verification'), z.literal('verified')])
    .optional(),
  verification_type: z.union([z.literal('bank_deposits'), z.literal('plaid')]).optional(),
  plaid_status: z.union([z.literal('connected'), z.literal('disconnected')]).optional(),
  last_cached_balance: z.string().optional(),
  balance_fetched_date: z.string().optional(),
});

export const accountTypeSchema = z.union([z.literal('Checking'), z.literal('Savings')]);

export const verificationStatusSchema = z.union([
  z.literal('awaiting_deposits'),
  z.literal('ready_for_verification'),
  z.literal('verified'),
]);

export const verificationTypeSchema = z.union([z.literal('bank_deposits'), z.literal('plaid')]);

export const plaidStatusSchema = z.union([z.literal('connected'), z.literal('disconnected')]);

export const supportedBenefitSchema = z.object({
  id: z.number().optional(),
  name: z.string().optional(),
  description: z.string().optional(),
  pretax: z.boolean().optional(),
  posttax: z.boolean().optional(),
  imputed: z.boolean().optional(),
  healthcare: z.boolean().optional(),
  retirement: z.boolean().optional(),
  yearly_limit: z.boolean().optional(),
});

export const companyBenefitSchema = z.object({
  id: z.number().optional(),
  version: z.string().optional(),
  company_id: z.number().optional(),
  benefit_id: z.number().optional(),
  active: z.boolean().optional(),
  description: z.string().optional(),
  supports_percentage_amounts: z.boolean().optional(),
  responsible_for_employer_taxes: z.boolean().optional(),
  responsible_for_employee_w2: z.boolean().optional(),
});

export const earningTypeSchema = z.object({
  name: z.string().optional(),
  uuid: z.string().optional(),
});

export const employeeBenefitSchema = z.object({
  id: z.number().optional(),
  version: z.string().optional(),
  employee_id: z.number().optional(),
  company_benefit_id: z.number().optional(),
  active: z.boolean().optional(),
  employee_deduction: z.string().optional(),
  deduct_as_percentage: z.boolean().optional(),
  employee_deduction_annual_maximum: z.string().optional().nullable(),
  contribution: z
    .object({
      type: z.string().optional(),
      value: z
        .union([
          z.string(),
          z.object({
            tiers: z
              .array(
                z.object({
                  rate: z.string().optional(),
                  threshold: z.string().optional(),
                  threshold_delta: z.string().optional(),
                }),
              )
              .optional(),
          }),
        ])
        .optional(),
    })
    .optional(),
  elective: z.boolean().optional(),
  company_contribution_annual_maximum: z.string().optional().nullable(),
  limit_option: z.string().optional().nullable(),
  catch_up: z.boolean().optional(),
  coverage_amount: z.string().optional().nullable(),
  deduction_reduces_taxable_income: z
    .union([z.literal('unset'), z.literal('reduces_taxable_income'), z.literal('does_not_reduce_taxable_income')])
    .optional()
    .nullable(),
  coverage_salary_multiplier: z.string().optional(),
  company_contribution: z.string().optional(),
  contribute_as_percentage: z.boolean().optional(),
});

export const deductionReducesTaxableIncomeSchema = z.union([
  z.literal('unset'),
  z.literal('reduces_taxable_income'),
  z.literal('does_not_reduce_taxable_income'),
]);

export const payPeriodSchema = z.object({
  start_date: z.string().optional(),
  end_date: z.string().optional(),
  pay_schedule_id: z.number().optional(),
  pay_schedule_uuid: z.string().optional(),
  eligible_employees: z
    .array(
      z.object({
        id: z.number().optional(),
        job_ids: z.array(z.number()).optional(),
      }),
    )
    .optional(),
  payroll: z
    .object({
      processed: z.boolean().optional(),
      payroll_deadline: z.string().optional(),
    })
    .optional(),
});

export const payrollSchema = z.object({
  version: z.string().optional(),
  payroll_deadline: z.string().optional(),
  check_date: z.string().optional(),
  processed: z.boolean().optional(),
  processed_date: z.string().optional(),
  calculated_at: z.string().optional(),
  payroll_id: z.number().optional(),
  payroll_uuid: z.string().optional(),
  company_id: z.number().optional(),
  company_uuid: z.string().optional(),
  pay_period: z
    .object({
      start_date: z.string().optional(),
      end_date: z.string().optional(),
      pay_schedule_id: z.number().optional(),
      pay_schedule_uuid: z.string().optional(),
    })
    .optional(),
  totals: z
    .object({
      company_debit: z.string().optional(),
      net_pay_debit: z.string().optional(),
      tax_debit: z.string().optional(),
      reimbursement_debit: z.string().optional(),
      child_support_debit: z.string().optional(),
      reimbursements: z.string().optional(),
      net_pay: z.string().optional(),
      gross_pay: z.string().optional(),
      employee_bonuses: z.string().optional(),
      employee_commissions: z.string().optional(),
      employee_cash_tips: z.string().optional(),
      employee_paycheck_tips: z.string().optional(),
      additional_earnings: z.string().optional(),
      owners_draw: z.string().optional(),
      check_amount: z.string().optional(),
      employer_taxes: z.string().optional(),
      employee_taxes: z.string().optional(),
      benefits: z.string().optional(),
      employee_benefits_deductions: z.string().optional(),
      deferred_payroll_taxes: z.string().optional(),
    })
    .optional(),
  employee_compensations: z
    .array(
      z.object({
        employee_id: z.number().optional(),
        employee_uuid: z.string().optional(),
        excluded: z.boolean().optional(),
        gross_pay: z.string().optional().nullable(),
        net_pay: z.string().optional().nullable(),
        payment_method: z
          .union([z.literal('Check'), z.literal('Direct Deposit')])
          .optional()
          .nullable(),
        fixed_compensations: z
          .array(
            z.object({
              name: z.string().optional(),
              amount: z.string().optional(),
              job_id: z.number().optional(),
            }),
          )
          .optional(),
        hourly_compensations: z
          .array(
            z.object({
              name: z.string().optional(),
              hours: z.string().optional(),
              job_id: z.number().optional(),
              compensation_multiplier: z.number().optional(),
            }),
          )
          .optional(),
        paid_time_off: z
          .array(
            z.object({
              name: z.string().optional(),
              hours: z.string().optional(),
            }),
          )
          .optional(),
        benefits: z
          .array(
            z.object({
              name: z.string().optional(),
              employee_deduction: z.string().optional(),
              company_contribution: z.string().optional(),
              imputed: z.boolean().optional(),
            }),
          )
          .optional(),
        deductions: z
          .array(
            z.object({
              name: z.string().optional(),
              amount: z.string().optional(),
            }),
          )
          .optional(),
        taxes: z
          .array(
            z.object({
              name: z.string(),
              employer: z.boolean(),
              amount: z.string(),
            }),
          )
          .optional(),
      }),
    )
    .optional(),
  payment_speed_changed: z
    .object({
      original_check_date: z.string().optional(),
      current_check_date: z.string().optional(),
      original_debit_date: z.number().optional(),
      current_debit_date: z.string().optional(),
      reason: z.string().optional(),
    })
    .optional(),
});

export const customFieldTypeSchema = z.union([
  z.literal('text'),
  z.literal('currency'),
  z.literal('number'),
  z.literal('date'),
  z.literal('radio'),
]);

export const employeeCustomFieldSchema = z.object({
  id: z.string(),
  company_custom_field_id: z.string(),
  name: z.string(),
  type: customFieldTypeSchema,
  description: z.string().optional(),
  value: z.string(),
  selection_options: z.array(z.string()).optional().nullable(),
});

export const companyCustomFieldSchema = z.object({
  id: z.string(),
  name: z.string(),
  type: customFieldTypeSchema,
  description: z.string().optional(),
  selection_options: z.array(z.string()).optional().nullable(),
});

export const signatorySchema = z.object({
  uuid: z.string().optional(),
  first_name: z.string().optional().nullable(),
  last_name: z.string().optional().nullable(),
  title: z.string().optional().nullable(),
  phone: z.string().optional().nullable(),
  email: z.string().optional(),
  birthday: z.string().optional().nullable(),
  is_admin: z.boolean().optional(),
  has_ssn: z.boolean().optional(),
  version: z.string().optional(),
  identity_verification_status: z
    .union([z.literal('Pass'), z.literal('Fail'), z.literal('Skipped')])
    .optional()
    .nullable(),
  home_address: z
    .object({
      street_1: z.string().optional(),
      street_2: z.string().optional(),
      city: z.string().optional(),
      state: z.string().optional(),
      zip: z.string().optional(),
      country: z.string().optional(),
    })
    .optional()
    .nullable(),
});

export const identityVerificationStatusSchema = z.union([z.literal('Pass'), z.literal('Fail'), z.literal('Skipped')]);

export const flowSchema = z.object({
  url: z.string().optional(),
  expires_at: z.string().optional(),
});

export const employeeFederalTaxSchema = z.object({
  version: z.string().optional(),
  filing_status: z.string().optional(),
  extra_withholding: z.string().optional(),
  two_jobs: z.boolean().optional(),
  dependents_amount: z.string().optional(),
  other_income: z.string().optional(),
  deductions: z.string().optional(),
  w4_data_type: z.union([z.literal('pre_2020_w4'), z.literal('rev_2020_w4')]).optional(),
  federal_withholding_allowance: z.string().optional(),
  additional_withholding: z.boolean().optional(),
});

export const w4DataTypeSchema = z.union([z.literal('pre_2020_w4'), z.literal('rev_2020_w4')]);

export const employeeStateTaxInputQuestionFormatSchema = z.object({
  type: z.string(),
  options: z
    .array(
      z.object({
        value: z.string().optional(),
        label: z.string(),
      }),
    )
    .optional(),
});

export const employeeStateTaxAnswerSchema = z.object({
  value: z.string().optional(),
  valid_from: z.string().optional(),
  valid_up_to: z.unknown().optional(),
});

export const federalTaxDetailsSchema = z.object({
  version: z.string().optional(),
  tax_payer_type: z.string().optional(),
  taxable_as_scorp: z.string().optional(),
  filing_form: z.string().optional(),
  has_ein: z.boolean().optional(),
  ein_verified: z.boolean().optional(),
  legal_name: z.string().optional(),
});

export const employeeBankAccountSchema = z.object({
  uuid: z.string().optional(),
  employee_uuid: z.string().optional(),
  account_type: z.union([z.literal('Checking'), z.literal('Savings')]).optional(),
  name: z.string().optional(),
  routing_number: z.string().optional(),
  hidden_account_number: z.string().optional(),
});

export const employeePaymentMethodSchema = z.object({
  version: z.string().optional(),
  type: z.union([z.literal('Direct Deposit'), z.literal('Check')]).optional(),
  split_by: z
    .union([z.literal('Amount'), z.literal('Percentage')])
    .optional()
    .nullable(),
  splits: z
    .array(
      z.object({
        uuid: z.string().optional(),
        name: z.string().optional(),
        hidden_account_number: z.string().optional(),
        priority: z.number().optional(),
        split_amount: z.number().optional().nullable(),
      }),
    )
    .optional()
    .nullable(),
});

export const type2Schema = z.union([z.literal('Direct Deposit'), z.literal('Check')]);

export const splitBySchema = z.union([z.literal('Amount'), z.literal('Percentage')]);

export const parameterpageParamSchema = z.number();

export const parameterperParamSchema = z.number();

export const getV1EmployeesDataSchema = z.object({
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      include: z.array(z.literal('custom_fields')).optional(),
    })
    .optional(),
});

export const employeeSchema = z.object({
  id: z.number().optional(),
  uuid: z.string().optional(),
  first_name: z.string().optional(),
  middle_initial: z.string().optional().nullable(),
  last_name: z.string().optional(),
  email: z.string().optional().nullable(),
  company_id: z.number().optional(),
  company_uuid: z.string().optional(),
  manager_id: z.number().optional().nullable(),
  version: z.string().optional(),
  department: z.string().optional().nullable(),
  terminated: z.boolean().optional(),
  two_percent_shareholder: z.boolean().optional(),
  onboarded: z.boolean().optional(),
  jobs: z.array(jobSchema).optional(),
  eligible_paid_time_off: z.array(paidTimeOffSchema).optional(),
  terminations: z.array(terminationSchema).optional(),
  home_address: locationSchema.optional(),
  garnishments: z.array(garnishmentSchema).optional(),
  custom_fields: z.array(employeeCustomFieldSchema).optional(),
  date_of_birth: z.string().optional().nullable(),
  has_ssn: z.boolean().optional(),
  ssn: z.string().optional(),
  phone: z.string().optional(),
  preferred_first_name: z.string().optional(),
  work_email: z.string().optional().nullable(),
  current_employment_status: z
    .union([
      z.literal('full_time'),
      z.literal('part_time_under_twenty_hours'),
      z.literal('part_time_twenty_plus_hours'),
      z.literal('variable'),
      z.literal('seasonal'),
    ])
    .optional()
    .nullable(),
});

export const getV1EmployeesErrorSchema = z.unknown();

export const putV1EmployeesDataSchema = z.object({
  body: z
    .object({
      version: z.string(),
      first_name: z.string().optional(),
      middle_initial: z.string().optional(),
      last_name: z.string().optional(),
      date_of_birth: z.string().optional(),
      email: z.string().optional(),
      ssn: z.string().optional(),
      two_percent_shareholder: z.boolean().optional(),
    })
    .optional(),
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
});

export const putV1EmployeesResponseSchema = employeeSchema;

export const putV1EmployeesErrorSchema = z.unknown();

export const deleteV1EmployeeDataSchema = z.object({
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
});

export const deleteV1EmployeeResponseSchema = z.any();

export const deleteV1EmployeeErrorSchema = z.unknown();

export const putV1EmployeeFinishOnboardingDataSchema = z.object({
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
});

export const putV1EmployeeFinishOnboardingResponseSchema = employeeSchema;

export const putV1EmployeeFinishOnboardingErrorSchema = z.unknown();

export const getV1CompaniesDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
});

export const getV1CompaniesResponseSchema = companySchema;

export const getV1CompaniesErrorSchema = z.unknown();

export const getV1CompanyOnboardingStatusDataSchema = z.object({
  path: z.object({
    company_uuid: z.string(),
  }),
});

export const getV1CompanyOnboardingStatusResponseSchema = companyOnboardingStatusSchema;

export const getV1CompanyOnboardingStatusErrorSchema = z.unknown();

export const getV1CompanyFinishOnboardingDataSchema = z.object({
  path: z.object({
    company_uuid: z.string(),
  }),
});

export const getV1CompanyFinishOnboardingResponseSchema = companyOnboardingStatusSchema;

export const getV1CompanyFinishOnboardingErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdEmployeesDataSchema = z.object({
  body: z.record(z.unknown()).optional(),
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      include: z.array(z.literal('custom_fields')).optional(),
      page: z.number().optional(),
      per: z.number().optional(),
      terminated: z.boolean().optional(),
    })
    .optional(),
});

export const getV1CompaniesCompanyIdEmployeesResponseSchema = z.array(employeeSchema);

export const getV1CompaniesCompanyIdEmployeesErrorSchema = z.unknown();

export const postV1EmployeesDataSchema = z.object({
  body: z
    .object({
      first_name: z.string().optional(),
      middle_initial: z.string().optional(),
      last_name: z.string().optional(),
      date_of_birth: z.string().optional(),
      email: z.string().optional(),
      ssn: z.string().optional(),
    })
    .optional(),
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
});

export const postV1EmployeesResponseSchema = employeeSchema;

export const postV1EmployeesErrorSchema = z.unknown();

export const getV1JobsJobIdDataSchema = z.object({
  path: z.object({
    job_id_or_uuid: z.string(),
  }),
});

export const getV1JobsJobIdResponseSchema = jobSchema;

export const getV1JobsJobIdErrorSchema = z.unknown();

export const putV1JobsJobIdDataSchema = z.object({
  body: z
    .object({
      version: z.string(),
      title: z.string().optional(),
      location_id: z.number().optional(),
      hire_date: z.string().optional(),
    })
    .optional(),
  path: z.object({
    job_id_or_uuid: z.string(),
  }),
});

export const putV1JobsJobIdResponseSchema = jobSchema;

export const putV1JobsJobIdErrorSchema = z.unknown();

export const deleteV1JobsJobIdDataSchema = z.object({
  path: z.object({
    job_id_or_uuid: z.string(),
  }),
});

export const deleteV1JobsJobIdResponseSchema = z.any();

export const deleteV1JobsJobIdErrorSchema = z.unknown();

export const getV1EmployeesEmployeeIdJobsDataSchema = z.object({
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      page: z.number().optional(),
      per: z.number().optional(),
    })
    .optional(),
});

export const getV1EmployeesEmployeeIdJobsResponseSchema = z.array(jobSchema);

export const getV1EmployeesEmployeeIdJobsErrorSchema = z.unknown();

export const postV1JobsJobIdDataSchema = z.object({
  body: z
    .object({
      title: z.string().optional(),
      location_id: z.number().optional(),
      hire_date: z.string().optional(),
    })
    .optional(),
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
});

export const postV1JobsJobIdResponseSchema = jobSchema;

export const postV1JobsJobIdErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdLocationsDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      page: z.number().optional(),
      per: z.number().optional(),
    })
    .optional(),
});

export const getV1CompaniesCompanyIdLocationsResponseSchema = z.array(locationSchema);

export const getV1CompaniesCompanyIdLocationsErrorSchema = z.unknown();

export const postV1CompaniesCompanyIdLocationsDataSchema = z.object({
  body: z
    .object({
      phone_number: z.string(),
      street_1: z.string(),
      street_2: z.string().optional().nullable(),
      city: z.string(),
      state: z.string(),
      zip: z.string(),
      country: z.string().optional(),
      mailing_address: z.boolean().optional(),
      filing_address: z.boolean().optional(),
    })
    .optional(),
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
});

export const postV1CompaniesCompanyIdLocationsResponseSchema = locationSchema;

export const postV1CompaniesCompanyIdLocationsErrorSchema = z.unknown();

export const getV1LocationsLocationIdDataSchema = z.object({
  path: z.object({
    location_id: z.string(),
  }),
});

export const getV1LocationsLocationIdResponseSchema = locationSchema;

export const getV1LocationsLocationIdErrorSchema = z.unknown();

export const putV1LocationsLocationIdDataSchema = z.object({
  body: z
    .object({
      phone_number: z.string().optional(),
      street_1: z.string().optional(),
      street_2: z.string().optional().nullable(),
      city: z.string().optional(),
      state: z.string().optional(),
      zip: z.string().optional(),
      country: z.string().optional(),
      mailing_address: z.boolean().optional(),
      filing_address: z.boolean().optional(),
    })
    .optional(),
  path: z.object({
    location_id: z.string(),
  }),
});

export const putV1LocationsLocationIdResponseSchema = locationSchema;

export const putV1LocationsLocationIdErrorSchema = z.unknown();

export const getV1ContractorsContractorIdDataSchema = z.object({
  path: z.object({
    contractor_id_or_uuid: z.string(),
  }),
});

export const getV1ContractorsContractorIdResponseSchema = contractorSchema;

export const getV1ContractorsContractorIdErrorSchema = z.unknown();

export const putV1ContractorsContractorIdDataSchema = z.object({
  body: z
    .object({
      version: z.string().optional(),
      start_date: z.string().optional(),
      first_name: z.string().optional(),
      last_name: z.string().optional(),
      middle_initial: z.string().optional(),
      wage_type: z.union([z.literal('Fixed'), z.literal('Hourly')]).optional(),
      hourly_rate: z.string().optional(),
      business_name: z.string().optional(),
      ein: z.string().optional(),
    })
    .optional(),
  path: z.object({
    contractor_id_or_uuid: z.string(),
  }),
});

export const putV1ContractorsContractorIdResponseSchema = contractorSchema;

export const putV1ContractorsContractorIdErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdContractorsDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      page: z.number().optional(),
      per: z.number().optional(),
    })
    .optional(),
});

export const getV1CompaniesCompanyIdContractorsResponseSchema = z.array(contractorSchema);

export const getV1CompaniesCompanyIdContractorsErrorSchema = z.unknown();

export const postV1CompaniesCompanyIdContractorsDataSchema = z.object({
  body: z
    .object({
      type: z.union([z.literal('Individual'), z.literal('Business')]),
      wage_type: z.union([z.literal('Hourly'), z.literal('Fixed')]),
      first_name: z.string().optional(),
      last_name: z.string().optional(),
      start_date: z.string(),
      self_onboarding: z.boolean().optional(),
      email: z.string().optional(),
      middle_initial: z.string().optional(),
      business_name: z.string().optional(),
      ein: z.string().optional(),
    })
    .optional(),
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
});

export const postV1CompaniesCompanyIdContractorsResponseSchema = contractorSchema;

export const postV1CompaniesCompanyIdContractorsErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdContractorPaymentsDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
  query: z.object({
    end_date: z.string(),
    page: z.number().optional(),
    per: z.number().optional(),
    start_date: z.string(),
  }),
});

export const getV1CompaniesCompanyIdContractorPaymentsResponseSchema = contractorPaymentSummarySchema;

export const getV1CompaniesCompanyIdContractorPaymentsErrorSchema = z.unknown();

export const postV1CompaniesCompanyIdContractorPaymentsDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
  query: z.object({
    bonus: z.number().optional(),
    contractor_id: z.number(),
    date: z.string(),
    hours: z.number().optional(),
    reimbursement: z.number().optional(),
    wage: z.number().optional(),
  }),
});

export const postV1CompaniesCompanyIdContractorPaymentsResponseSchema = contractorPaymentSchema;

export const postV1CompaniesCompanyIdContractorPaymentsErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdContractorPaymentContractorPaymentDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
    contractor_payment_id_or_uuid: z.string(),
  }),
});

export const getV1CompaniesCompanyIdContractorPaymentContractorPaymentResponseSchema = contractorPaymentSchema;

export const getV1CompaniesCompanyIdContractorPaymentContractorPaymentErrorSchema = z.unknown();

export const deleteV1CompaniesCompanyIdContractorPaymentContractorPaymentDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
    contractor_payment_id_or_uuid: z.string(),
  }),
});

export const deleteV1CompaniesCompanyIdContractorPaymentContractorPaymentResponseSchema = z.any();

export const deleteV1CompaniesCompanyIdContractorPaymentContractorPaymentErrorSchema = z.unknown();

export const getV1CompensationsCompensationIdDataSchema = z.object({
  path: z.object({
    compensation_id_or_uuid: z.string(),
  }),
});

export const getV1CompensationsCompensationIdResponseSchema = compensationSchema;

export const getV1CompensationsCompensationIdErrorSchema = z.unknown();

export const putV1CompensationsCompensationIdDataSchema = z.object({
  body: z
    .object({
      version: z.string(),
      rate: z.string().optional(),
      payment_unit: z
        .union([z.literal('Hour'), z.literal('Week'), z.literal('Month'), z.literal('Year'), z.literal('Paycheck')])
        .optional(),
      flsa_status: z
        .union([z.literal('Exempt'), z.literal('Salaried Nonexempt'), z.literal('Nonexempt'), z.literal('Owner')])
        .optional(),
    })
    .optional(),
  path: z.object({
    compensation_id_or_uuid: z.string(),
  }),
});

export const putV1CompensationsCompensationIdResponseSchema = compensationSchema;

export const putV1CompensationsCompensationIdErrorSchema = z.unknown();

export const getV1JobsJobIdCompensationsDataSchema = z.object({
  path: z.object({
    job_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      page: z.number().optional(),
      per: z.number().optional(),
    })
    .optional(),
});

export const getV1JobsJobIdCompensationsResponseSchema = z.array(compensationSchema);

export const getV1JobsJobIdCompensationsErrorSchema = z.unknown();

export const postV1JobsJobIdCompensationsDataSchema = z.object({
  body: z
    .object({
      rate: z.string(),
      payment_unit: z.union([
        z.literal('Hour'),
        z.literal('Week'),
        z.literal('Month'),
        z.literal('Year'),
        z.literal('Paycheck'),
      ]),
      flsa_status: z.union([
        z.literal('Exempt'),
        z.literal('Salaried Nonexempt'),
        z.literal('Nonexempt'),
        z.literal('Owner'),
      ]),
      effective_date: z.string().optional(),
    })
    .optional(),
  path: z.object({
    job_id_or_uuid: z.string(),
  }),
});

export const postV1JobsJobIdCompensationsResponseSchema = compensationSchema;

export const postV1JobsJobIdCompensationsErrorSchema = z.unknown();

export const getV1EmployeesEmployeeIdGarnishmentsDataSchema = z.object({
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      page: z.number().optional(),
      per: z.number().optional(),
    })
    .optional(),
});

export const getV1EmployeesEmployeeIdGarnishmentsResponseSchema = z.array(garnishmentSchema);

export const getV1EmployeesEmployeeIdGarnishmentsErrorSchema = z.unknown();

export const postV1EmployeesEmployeeIdGarnishmentsDataSchema = z.object({
  body: z
    .object({
      active: z.boolean().optional(),
      amount: z.string(),
      description: z.string(),
      court_ordered: z.boolean(),
      times: z.number().optional().nullable(),
      recurring: z.boolean().optional(),
      annual_maximum: z.string().optional().nullable(),
      pay_period_maximum: z.string().optional().nullable(),
      deduct_as_percentage: z.boolean().optional(),
    })
    .optional(),
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
});

export const postV1EmployeesEmployeeIdGarnishmentsResponseSchema = garnishmentSchema;

export const postV1EmployeesEmployeeIdGarnishmentsErrorSchema = z.unknown();

export const getV1GarnishmentsGarnishmentIdDataSchema = z.object({
  path: z.object({
    garnishment_id_or_uuid: z.string(),
  }),
});

export const getV1GarnishmentsGarnishmentIdResponseSchema = garnishmentSchema;

export const getV1GarnishmentsGarnishmentIdErrorSchema = z.unknown();

export const putV1GarnishmentsGarnishmentIdDataSchema = z.object({
  body: z
    .object({
      active: z.boolean().optional(),
      amount: z.string().optional(),
      description: z.string().optional(),
      court_ordered: z.boolean().optional(),
      times: z.number().optional().nullable(),
      recurring: z.boolean().optional(),
      annual_maximum: z.string().optional().nullable(),
      pay_period_maximum: z.string().optional().nullable(),
      deduct_as_percentage: z.boolean().optional(),
      version: z.string(),
    })
    .optional(),
  path: z.object({
    garnishment_id_or_uuid: z.string(),
  }),
});

export const putV1GarnishmentsGarnishmentIdResponseSchema = garnishmentSchema;

export const putV1GarnishmentsGarnishmentIdErrorSchema = z.unknown();

export const getV1EmployeesEmployeeIdTerminationsDataSchema = z.object({
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
});

export const getV1EmployeesEmployeeIdTerminationsResponseSchema = z.array(terminationSchema);

export const getV1EmployeesEmployeeIdTerminationsErrorSchema = z.unknown();

export const postV1EmployeesEmployeeIdTerminationsDataSchema = z.object({
  body: z
    .object({
      effective_date: z.string().optional(),
      run_termination_payroll: z.boolean().optional(),
    })
    .optional(),
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
});

export const postV1EmployeesEmployeeIdTerminationsResponseSchema = terminationSchema;

export const postV1EmployeesEmployeeIdTerminationsErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdTimeOffRequestsDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      end_date: z.string().optional(),
      page: z.number().optional(),
      per: z.number().optional(),
      start_date: z.string().optional(),
    })
    .optional(),
});

export const getV1CompaniesCompanyIdTimeOffRequestsResponseSchema = z.array(timeOffRequestSchema);

export const getV1CompaniesCompanyIdTimeOffRequestsErrorSchema = z.unknown();

export const getV1MeResponseSchema = currentUserSchema;

export const getV1MeErrorSchema = z.unknown();

export const getV1TermsOfServiceResponseSchema = z.object({
  latest_terms_accepted: z.boolean().optional(),
});

export const getV1TermsOfServiceErrorSchema = z.unknown();

export const postV1TermsOfServiceResponseSchema = z.object({
  latest_terms_accepted: z.boolean().optional(),
});

export const postV1TermsOfServiceErrorSchema = z.unknown();

export const getV1EmployeesEmployeeIdFederalTaxesDataSchema = z.object({
  path: z.object({
    employee_uuid: z.string(),
  }),
});

export const getV1EmployeesEmployeeIdFederalTaxesResponseSchema = employeeFederalTaxSchema;

export const getV1EmployeesEmployeeIdFederalTaxesErrorSchema = z.unknown();

export const putV1EmployeesEmployeeIdFederalTaxesDataSchema = z.object({
  body: z
    .object({
      version: z.string(),
      filing_status: z.string().optional(),
      extra_withholding: z.string().optional().nullable(),
      two_jobs: z.boolean().optional(),
      dependents_amount: z.string().optional(),
      other_income: z.string().optional(),
      deductions: z.string().optional(),
      w4_data_type: z.string().optional(),
    })
    .optional(),
  path: z.object({
    employee_uuid: z.string(),
  }),
});

export const putV1EmployeesEmployeeIdFederalTaxesResponseSchema = employeeFederalTaxSchema;

export const putV1EmployeesEmployeeIdFederalTaxesErrorSchema = z.unknown();

export const getV1EmployeesEmployeeIdStateTaxesDataSchema = z.object({
  path: z.object({
    employee_uuid: z.string(),
  }),
});

export const getV1EmployeesEmployeeIdStateTaxesErrorSchema = z.unknown();

export const putV1EmployeesEmployeeIdStateTaxesDataSchema = z.object({
  body: z
    .object({
      employee_id: z.string(),
      states: z.array(
        z.object({
          state: z.string(),
          questions: z
            .array(
              z.object({
                key: z.string(),
                answers: z
                  .array(
                    z.object({
                      value: z.string(),
                      valid_from: z.string(),
                      valid_up_to: z.unknown().optional(),
                    }),
                  )
                  .optional(),
              }),
            )
            .optional(),
        }),
      ),
    })
    .optional(),
  path: z.object({
    employee_uuid: z.string(),
  }),
});

export const putV1EmployeesEmployeeIdStateTaxesErrorSchema = z.array(
  z.object({
    state: z.string(),
    questions: z.array(
      z.object({
        key: z.string(),
        answers: z
          .array(
            z.object({
              valid_from: z.string(),
              valid_up_to: z.unknown().optional(),
              errors: z.array(z.string()).optional(),
            }),
          )
          .optional(),
      }),
    ),
  }),
);

export const getV1EmployeesEmployeeIdHomeAddressDataSchema = z.object({
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
});

export const getV1EmployeesEmployeeIdHomeAddressResponseSchema = locationSchema;

export const getV1EmployeesEmployeeIdHomeAddressErrorSchema = z.unknown();

export const putV1EmployeesEmployeeIdHomeAddressDataSchema = z.object({
  body: z
    .object({
      version: z.string(),
      street_1: z.string().optional(),
      street_2: z.string().optional().nullable(),
      city: z.string().optional(),
      state: z.string().optional(),
      zip: z.string().optional(),
    })
    .optional(),
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
});

export const putV1EmployeesEmployeeIdHomeAddressResponseSchema = locationSchema;

export const putV1EmployeesEmployeeIdHomeAddressErrorSchema = z.unknown();

export const getV1CompanyPaymentConfigsDataSchema = z.object({
  path: z.object({
    company_uuid: z.string(),
  }),
});

export const getV1CompanyPaymentConfigsResponseSchema = paymentConfigsSchema;

export const getV1CompanyPaymentConfigsErrorSchema = z.unknown();

export const putV1CompanyPaymentConfigsDataSchema = z.object({
  body: z
    .object({
      fast_payment_limit: z.number(),
      payment_speed: z.union([z.literal('2-day'), z.literal('4-day')]),
    })
    .optional(),
  path: z.object({
    company_uuid: z.string(),
  }),
});

export const putV1CompanyPaymentConfigsResponseSchema = paymentConfigsSchema;

export const putV1CompanyPaymentConfigsErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdPaySchedulesDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      page: z.number().optional(),
      per: z.number().optional(),
    })
    .optional(),
});

export const getV1CompaniesCompanyIdPaySchedulesResponseSchema = z.array(payScheduleSchema);

export const getV1CompaniesCompanyIdPaySchedulesErrorSchema = z.unknown();

export const postV1CompaniesCompanyIdPaySchedulesDataSchema = z.object({
  body: z
    .object({
      frequency: z.union([
        z.literal('Every week'),
        z.literal('Every other week'),
        z.literal('Twice per month'),
        z.literal('Monthly'),
      ]),
      anchor_pay_date: z.string(),
      anchor_end_of_pay_period: z.string(),
      day_1: z.number().optional().nullable(),
      day_2: z.number().optional().nullable(),
    })
    .optional(),
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
});

export const postV1CompaniesCompanyIdPaySchedulesResponseSchema = payScheduleSchema;

export const postV1CompaniesCompanyIdPaySchedulesErrorSchema = z.unknown();

export const getV1CompanyIndustryDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
});

export const getV1CompanyIndustryResponseSchema = industrySchema;

export const getV1CompanyIndustryErrorSchema = z.unknown();

export const putV1CompanyIndustryDataSchema = z.object({
  body: z
    .object({
      title: z.string(),
      naics_code: z.string(),
      sic_codes: z.array(z.string()),
    })
    .optional(),
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
});

export const putV1CompanyIndustryResponseSchema = industrySchema;

export const putV1CompanyIndustryErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdPaySchedulesPayScheduleIdDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
    pay_schedule_id_or_uuid: z.string(),
  }),
});

export const getV1CompaniesCompanyIdPaySchedulesPayScheduleIdResponseSchema = payScheduleSchema;

export const getV1CompaniesCompanyIdPaySchedulesPayScheduleIdErrorSchema = z.unknown();

export const putV1CompaniesCompanyIdPaySchedulesPayScheduleIdDataSchema = z.object({
  body: z
    .object({
      version: z.string(),
      auto_pilot: z.boolean().optional(),
    })
    .optional(),
  path: z.object({
    company_id_or_uuid: z.string(),
    pay_schedule_id_or_uuid: z.string(),
  }),
});

export const putV1CompaniesCompanyIdPaySchedulesPayScheduleIdResponseSchema = payScheduleSchema;

export const putV1CompaniesCompanyIdPaySchedulesPayScheduleIdErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdBankAccountsDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      page: z.number().optional(),
      per: z.number().optional(),
    })
    .optional(),
});

export const getV1CompaniesCompanyIdBankAccountsResponseSchema = z.array(companyBankAccountSchema);

export const getV1CompaniesCompanyIdBankAccountsErrorSchema = z.unknown();

export const postV1CompaniesCompanyIdBankAccountsDataSchema = z.object({
  body: z
    .object({
      routing_number: z.string().optional(),
      account_number: z.string().optional(),
      account_type: z.union([z.literal('Checking'), z.literal('Savings')]).optional(),
    })
    .optional(),
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
});

export const postV1CompaniesCompanyIdBankAccountsResponseSchema = companyBankAccountSchema;

export const postV1CompaniesCompanyIdBankAccountsErrorSchema = z.unknown();

export const putV1CompaniesCompanyIdBankAccountsVerifyDataSchema = z.object({
  body: z
    .object({
      deposit_1: z.number().optional(),
      deposit_2: z.number().optional(),
    })
    .optional(),
  path: z.object({
    bank_account_uuid: z.string(),
    company_id_or_uuid: z.string(),
  }),
});

export const putV1CompaniesCompanyIdBankAccountsVerifyResponseSchema = companyBankAccountSchema;

export const putV1CompaniesCompanyIdBankAccountsVerifyErrorSchema = z.unknown();

export const getV1BenefitsResponseSchema = z.array(supportedBenefitSchema);

export const getV1BenefitsErrorSchema = z.unknown();

export const getV1BenefitsBenefitIdDataSchema = z.object({
  path: z.object({
    benefit_id: z.string(),
  }),
});

export const getV1BenefitsBenefitIdResponseSchema = supportedBenefitSchema;

export const getV1BenefitsBenefitIdErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdCompanyBenefitsDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
});

export const getV1CompaniesCompanyIdCompanyBenefitsResponseSchema = z.array(companyBenefitSchema);

export const getV1CompaniesCompanyIdCompanyBenefitsErrorSchema = z.unknown();

export const postV1CompaniesCompanyIdCompanyBenefitsDataSchema = z.object({
  body: z
    .object({
      benefit_id: z.number(),
      active: z.boolean().optional(),
      description: z.string(),
      responsible_for_employer_taxes: z.boolean().optional(),
      responsible_for_employee_w2: z.boolean().optional(),
    })
    .optional(),
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
});

export const postV1CompaniesCompanyIdCompanyBenefitsResponseSchema = companyBenefitSchema;

export const postV1CompaniesCompanyIdCompanyBenefitsErrorSchema = z.unknown();

export const getV1CompanyBenefitsCompanyBenefitIdDataSchema = z.object({
  path: z.object({
    company_benefit_id: z.string(),
  }),
});

export const getV1CompanyBenefitsCompanyBenefitIdResponseSchema = companyBenefitSchema;

export const getV1CompanyBenefitsCompanyBenefitIdErrorSchema = z.unknown();

export const putV1CompanyBenefitsCompanyBenefitIdDataSchema = z.object({
  body: z
    .object({
      version: z.string(),
      active: z.boolean().optional(),
      description: z.string().optional(),
    })
    .optional(),
  path: z.object({
    company_benefit_id: z.string(),
  }),
});

export const putV1CompanyBenefitsCompanyBenefitIdResponseSchema = companyBenefitSchema;

export const putV1CompanyBenefitsCompanyBenefitIdErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdEarningTypesDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
});

export const getV1CompaniesCompanyIdEarningTypesResponseSchema = z.object({
  default: z.array(earningTypeSchema).optional(),
  custom: z.array(earningTypeSchema).optional(),
});

export const getV1CompaniesCompanyIdEarningTypesErrorSchema = z.unknown();

export const postV1CompaniesCompanyIdEarningTypesDataSchema = z.object({
  body: z
    .object({
      name: z.string(),
    })
    .optional(),
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
});

export const postV1CompaniesCompanyIdEarningTypesResponseSchema = earningTypeSchema;

export const postV1CompaniesCompanyIdEarningTypesErrorSchema = z.unknown();

export const putV1CompaniesCompanyIdEarningTypesEarningTypeUuidDataSchema = z.object({
  body: z
    .object({
      name: z.string().optional(),
    })
    .optional(),
  path: z.object({
    company_id_or_uuid: z.string(),
    earning_type_uuid: z.string(),
  }),
});

export const putV1CompaniesCompanyIdEarningTypesEarningTypeUuidResponseSchema = earningTypeSchema;

export const putV1CompaniesCompanyIdEarningTypesEarningTypeUuidErrorSchema = z.unknown();

export const deleteV1CompaniesCompanyIdEarningTypesEarningTypeUuidDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
    earning_type_uuid: z.string(),
  }),
});

export const deleteV1CompaniesCompanyIdEarningTypesEarningTypeUuidResponseSchema = z.any();

export const deleteV1CompaniesCompanyIdEarningTypesEarningTypeUuidErrorSchema = z.unknown();

export const getV1EmployeesEmployeeIdEmployeeBenefitsDataSchema = z.object({
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      page: z.number().optional(),
      per: z.number().optional(),
    })
    .optional(),
});

export const getV1EmployeesEmployeeIdEmployeeBenefitsResponseSchema = z.array(employeeBenefitSchema);

export const getV1EmployeesEmployeeIdEmployeeBenefitsErrorSchema = z.unknown();

export const postV1EmployeesEmployeeIdEmployeeBenefitsDataSchema = z.object({
  body: z
    .object({
      company_benefit_id: z.number(),
      active: z.boolean().optional(),
      employee_deduction: z.string().optional(),
      deduct_as_percentage: z.boolean().optional(),
      employee_deduction_annual_maximum: z.string().optional().nullable(),
      contribution: z
        .object({
          type: z.union([z.literal('tiered'), z.literal('percentage'), z.literal('amount')]).optional(),
          value: z
            .union([
              z.string(),
              z.array(
                z.object({
                  rate: z.string().optional(),
                  threshold: z.string().optional(),
                }),
              ),
            ])
            .optional(),
        })
        .optional(),
      elective: z.boolean().optional(),
      company_contribution_annual_maximum: z.string().optional().nullable(),
      limit_option: z.string().optional().nullable(),
      catch_up: z.boolean().optional(),
      coverage_amount: z.string().optional().nullable(),
      coverage_salary_multiplier: z.string().optional(),
      deduction_reduces_taxable_income: z
        .union([z.literal('unset'), z.literal('reduces_taxable_income'), z.literal('does_not_reduce_taxable_income')])
        .optional()
        .nullable(),
      company_contribution: z.string().optional(),
      contribute_as_percentage: z.boolean().optional(),
    })
    .optional(),
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
});

export const postV1EmployeesEmployeeIdEmployeeBenefitsResponseSchema = employeeBenefitSchema;

export const postV1EmployeesEmployeeIdEmployeeBenefitsErrorSchema = z.unknown();

export const postEmployeeYtdBenefitAmountsFromDifferentCompanyDataSchema = z.object({
  body: z
    .object({
      benefit_id: z.number(),
      tax_year: z.number(),
      ytd_employee_deduction_amount: z.string(),
      ytd_company_contribution_amount: z.string(),
    })
    .optional(),
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
});

export const postEmployeeYtdBenefitAmountsFromDifferentCompanyResponseSchema = z.any();

export const postEmployeeYtdBenefitAmountsFromDifferentCompanyErrorSchema = z.unknown();

export const getV1EmployeeBenefitsEmployeeBenefitIdDataSchema = z.object({
  path: z.object({
    employee_benefit_id: z.string(),
  }),
});

export const getV1EmployeeBenefitsEmployeeBenefitIdResponseSchema = employeeBenefitSchema;

export const getV1EmployeeBenefitsEmployeeBenefitIdErrorSchema = z.unknown();

export const putV1EmployeeBenefitsEmployeeBenefitIdDataSchema = z.object({
  body: z
    .object({
      version: z.string(),
      active: z.boolean().optional(),
      employee_deduction: z.string().optional(),
      deduct_as_percentage: z.boolean().optional(),
      employee_deduction_annual_maximum: z.string().optional().nullable(),
      contribution: z
        .object({
          type: z.union([z.literal('amount'), z.literal('percentage'), z.literal('tiered')]).optional(),
          value: z
            .union([
              z.string(),
              z.array(
                z.object({
                  rate: z.string().optional(),
                  threshold: z.string().optional(),
                }),
              ),
            ])
            .optional(),
        })
        .optional(),
      elective: z.boolean().optional(),
      company_contribution_annual_maximum: z.string().optional().nullable(),
      limit_option: z.string().optional().nullable(),
      catch_up: z.boolean().optional(),
      coverage_amount: z.string().optional().nullable(),
      deduction_reduces_taxable_income: z
        .union([z.literal('unset'), z.literal('reduces_taxable_income'), z.literal('does_not_reduce_taxable_income')])
        .optional()
        .nullable(),
      coverage_salary_multiplier: z.string().optional(),
      company_contribution: z.string().optional(),
      contribute_as_percentage: z.boolean().optional(),
    })
    .optional(),
  path: z.object({
    employee_benefit_id: z.string(),
  }),
});

export const putV1EmployeeBenefitsEmployeeBenefitIdResponseSchema = employeeBenefitSchema;

export const putV1EmployeeBenefitsEmployeeBenefitIdErrorSchema = z.unknown();

export const deleteV1EmployeeBenefitsEmployeeBenefitIdDataSchema = z.object({
  path: z.object({
    employee_benefit_id: z.string(),
  }),
});

export const deleteV1EmployeeBenefitsEmployeeBenefitIdResponseSchema = z.any();

export const deleteV1EmployeeBenefitsEmployeeBenefitIdErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdPayPeriodsDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      end_date: z.string().optional(),
      start_date: z.string().optional(),
    })
    .optional(),
});

export const getV1CompaniesCompanyIdPayPeriodsResponseSchema = z.array(payPeriodSchema);

export const getV1CompaniesCompanyIdPayPeriodsErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdPayrollsDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      end_date: z.string().optional(),
      include: z.array(z.union([z.literal('benefits'), z.literal('deductions'), z.literal('taxes')])).optional(),
      include_off_cycle: z.boolean().optional(),
      processed: z.boolean().optional(),
      start_date: z.string().optional(),
    })
    .optional(),
});

export const getV1CompaniesCompanyIdPayrollsResponseSchema = z.array(payrollSchema);

export const getV1CompaniesCompanyIdPayrollsErrorSchema = z.unknown();

export const postV1CompaniesCompanyIdPayrollsDataSchema = z.object({
  body: z
    .object({
      off_cycle: z.string(),
      off_cycle_reason: z.union([z.literal('Bonus'), z.literal('Correction')]).optional(),
      start_date: z.string().optional(),
      end_date: z.string().optional(),
      employee_ids: z.array(z.number()).optional(),
      check_date: z.string().optional(),
    })
    .optional(),
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
});

export const postV1CompaniesCompanyIdPayrollsResponseSchema = payrollSchema;

export const postV1CompaniesCompanyIdPayrollsErrorSchema = z.unknown();

export const putV1CompaniesCompanyIdPayrollsDataSchema = z.object({
  body: z
    .object({
      version: z.string(),
      employee_compensations: z.array(
        z.object({
          employee_id: z.number().optional(),
          employee_uuid: z.string().optional(),
          excluded: z.boolean().optional(),
          fixed_compensations: z
            .array(
              z.object({
                name: z.string().optional(),
                amount: z.string().optional(),
                job_id: z.number().optional(),
              }),
            )
            .optional(),
          hourly_compensations: z
            .array(
              z.object({
                name: z.string().optional(),
                hours: z.string().optional(),
                job_id: z.number().optional(),
              }),
            )
            .optional(),
          paid_time_off: z
            .array(
              z.object({
                name: z.string().optional(),
                hours: z.string().optional(),
              }),
            )
            .optional(),
        }),
      ),
    })
    .optional(),
  path: z.object({
    company_id_or_uuid: z.string(),
    payroll_id_or_uuid: z.string(),
  }),
});

export const putV1CompaniesCompanyIdPayrollsResponseSchema = payrollSchema;

export const putV1CompaniesCompanyIdPayrollsErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdPayrollsPayrollIdDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
    payroll_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      include: z.union([z.literal('benefits'), z.literal('deductions'), z.literal('taxes')]).optional(),
      show_calculation: z.string().optional(),
    })
    .optional(),
});

export const getV1CompaniesCompanyIdPayrollsPayrollIdResponseSchema = payrollSchema;

export const getV1CompaniesCompanyIdPayrollsPayrollIdErrorSchema = z.unknown();

export const putV1CompaniesCompanyIdPayrollsPayPeriodStartDatePayPeriodEndDateDataSchema = z.object({
  body: z
    .object({
      version: z.string(),
      employee_compensations: z.array(
        z.object({
          employee_id: z.number().optional(),
          employee_uuid: z.string().optional(),
          excluded: z.boolean().optional(),
          fixed_compensations: z
            .array(
              z.object({
                name: z.string().optional(),
                amount: z.string().optional(),
                job_id: z.number().optional(),
              }),
            )
            .optional(),
          hourly_compensations: z
            .array(
              z.object({
                name: z.string().optional(),
                hours: z.string().optional(),
                job_id: z.number().optional(),
              }),
            )
            .optional(),
          paid_time_off: z
            .array(
              z.object({
                name: z.string().optional(),
                hours: z.string().optional(),
              }),
            )
            .optional(),
        }),
      ),
    })
    .optional(),
  path: z.object({
    company_id_or_uuid: z.string(),
    pay_period_end_date: z.string(),
    pay_period_start_date: z.string(),
  }),
});

export const putV1CompaniesCompanyIdPayrollsPayPeriodStartDatePayPeriodEndDateResponseSchema = payrollSchema;

export const putV1CompaniesCompanyIdPayrollsPayPeriodStartDatePayPeriodEndDateErrorSchema = z.unknown();

export const postV1PartnerManagedCompaniesDataSchema = z.object({
  body: z
    .object({
      user: z.object({
        first_name: z.string(),
        last_name: z.string(),
        email: z.string(),
        phone: z.string().optional(),
      }),
      company: z.object({
        name: z.string(),
        trade_name: z.string().optional(),
        ein: z.string().optional(),
      }),
    })
    .optional(),
});

export const postV1PartnerManagedCompaniesResponseSchema = z.object({
  access_token: z.string().optional(),
  refresh_token: z.string().optional(),
  company_uuid: z.string().optional(),
});

export const postV1PartnerManagedCompaniesErrorSchema = z.unknown();

export const postV1ProvisionDataSchema = z.object({
  body: z
    .object({
      user: z.object({
        first_name: z.string(),
        last_name: z.string(),
        email: z.string(),
        phone: z.string().optional(),
      }),
      company: z.object({
        name: z.string(),
        trade_name: z.string().optional(),
        ein: z.string().optional(),
        states: z.array(z.string()).optional(),
        number_employees: z.number().optional(),
        addresses: z
          .array(
            z.object({
              street_1: z.string().optional(),
              street_2: z.string().optional().nullable(),
              city: z.string().optional(),
              zip: z.string().optional(),
              state: z.string().optional(),
              phone: z.string().optional(),
              is_primary: z.string().optional(),
            }),
          )
          .optional(),
      }),
    })
    .optional(),
});

export const postV1ProvisionResponseSchema = z.object({
  account_claim_url: z.string().optional(),
});

export const postV1ProvisionErrorSchema = z.unknown();

export const getV1EmployeesEmployeeIdCustomFieldsDataSchema = z.object({
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      page: z.number().optional(),
      per: z.number().optional(),
    })
    .optional(),
});

export const getV1EmployeesEmployeeIdCustomFieldsResponseSchema = z.object({
  custom_fields: z.array(employeeCustomFieldSchema).optional(),
});

export const getV1EmployeesEmployeeIdCustomFieldsErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdCustomFieldsDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      page: z.number().optional(),
      per: z.number().optional(),
    })
    .optional(),
});

export const getV1CompaniesCompanyIdCustomFieldsResponseSchema = z.object({
  custom_fields: z.array(companyCustomFieldSchema).optional(),
});

export const getV1CompaniesCompanyIdCustomFieldsErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdTimeOffRequestsTimeOffRequestIdDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
    time_off_request_id: z.string(),
  }),
});

export const getV1CompaniesCompanyIdTimeOffRequestsTimeOffRequestIdResponseSchema = timeOffRequestSchema;

export const getV1CompaniesCompanyIdTimeOffRequestsTimeOffRequestIdErrorSchema = z.unknown();

export const putV1CompaniesCompanyIdPayrollsPayrollIdCalculateDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
    payroll_id_or_uuid: z.string(),
  }),
});

export const putV1CompaniesCompanyIdPayrollsPayrollIdCalculateResponseSchema = z.unknown();

export const putV1CompaniesCompanyIdPayrollsPayrollIdCalculateErrorSchema = z.unknown();

export const putV1CompaniesCompanyIdPayrollsPayrollIdSubmitDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
    payroll_id_or_uuid: z.string(),
  }),
});

export const putV1CompaniesCompanyIdPayrollsPayrollIdSubmitResponseSchema = z.unknown();

export const putV1CompaniesCompanyIdPayrollsPayrollIdSubmitErrorSchema = z.unknown();

export const putApiV1CompaniesCompanyIdPayrollsPayrollIdCancelDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
    payroll_id_or_uuid: z.string(),
  }),
});

export const putApiV1CompaniesCompanyIdPayrollsPayrollIdCancelResponseSchema = payrollSchema;

export const putApiV1CompaniesCompanyIdPayrollsPayrollIdCancelErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdOrUuidPayrollReversalsDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      page: z.number().optional(),
      per: z.number().optional(),
    })
    .optional(),
});

export const getV1CompaniesCompanyIdOrUuidPayrollReversalsResponseSchema = z.object({
  reversed_payroll_id: z.number().optional(),
  reversal_payroll_id: z.number().optional(),
  reason: z.string().optional(),
  approved_at: z.string().optional().nullable(),
  category: z.string().optional(),
  reversed_employee_ids: z.array(z.number()).optional(),
});

export const getV1CompaniesCompanyIdOrUuidPayrollReversalsErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdAdminsDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      page: z.number().optional(),
      per: z.number().optional(),
    })
    .optional(),
});

export const getV1CompaniesCompanyIdAdminsResponseSchema = z.array(adminSchema);

export const getV1CompaniesCompanyIdAdminsErrorSchema = z.unknown();

export const postV1CompaniesCompanyIdAdminsDataSchema = z.object({
  body: z
    .object({
      first_name: z.string(),
      last_name: z.string(),
      email: z.string(),
    })
    .optional(),
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
});

export const postV1CompaniesCompanyIdAdminsResponseSchema = adminSchema;

export const postV1CompaniesCompanyIdAdminsErrorSchema = z.unknown();

export const getV1CompaniesCompanyIdOrUuidFederalTaxDetailsDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
});

export const getV1CompaniesCompanyIdOrUuidFederalTaxDetailsResponseSchema = federalTaxDetailsSchema;

export const getV1CompaniesCompanyIdOrUuidFederalTaxDetailsErrorSchema = z.unknown();

export const putV1CompaniesCompanyIdOrUuidFederalTaxDetailsDataSchema = z.object({
  body: z
    .object({
      legal_name: z.string().optional(),
      ein: z.string().optional(),
      tax_payer_type: z.string().optional(),
      filing_form: z.string().optional(),
      taxable_as_scorp: z.boolean().optional(),
      version: z.string(),
    })
    .optional(),
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
});

export const putV1CompaniesCompanyIdOrUuidFederalTaxDetailsResponseSchema = federalTaxDetailsSchema;

export const putV1CompaniesCompanyIdOrUuidFederalTaxDetailsErrorSchema = z.unknown();

export const getV1EmployeesEmployeeIdBankAccountsDataSchema = z.object({
  body: z.record(z.unknown()).optional(),
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
  query: z
    .object({
      page: z.number().optional(),
      per: z.number().optional(),
    })
    .optional(),
});

export const getV1EmployeesEmployeeIdBankAccountsResponseSchema = z.array(employeeBankAccountSchema);

export const getV1EmployeesEmployeeIdBankAccountsErrorSchema = z.unknown();

export const postV1EmployeesEmployeeIdBankAccountsDataSchema = z.object({
  body: z
    .object({
      name: z.string(),
      routing_number: z.string(),
      account_number: z.string(),
      account_type: z.union([z.literal('Checking'), z.literal('Savings')]),
    })
    .optional(),
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
});

export const postV1EmployeesEmployeeIdBankAccountsResponseSchema = employeeBankAccountSchema;

export const postV1EmployeesEmployeeIdBankAccountsErrorSchema = z.unknown();

export const deleteV1EmployeesEmployeeIdBankAccountsBankAccountIdDataSchema = z.object({
  path: z.object({
    bank_account_uuid: z.string(),
    employee_id_or_uuid: z.string(),
  }),
});

export const deleteV1EmployeesEmployeeIdBankAccountsBankAccountIdResponseSchema = z.any();

export const deleteV1EmployeesEmployeeIdBankAccountsBankAccountIdErrorSchema = z.unknown();

export const getV1EmployeesEmployeeIdPaymentMethodDataSchema = z.object({
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
});

export const getV1EmployeesEmployeeIdPaymentMethodResponseSchema = employeePaymentMethodSchema;

export const getV1EmployeesEmployeeIdPaymentMethodErrorSchema = z.unknown();

export const putV1EmployeesEmployeeIdPaymentMethodDataSchema = z.object({
  body: z
    .object({
      version: z.string(),
      type: z.union([z.literal('Direct Deposit'), z.literal('Check')]),
      split_by: z.union([z.literal('Amount'), z.literal('Percentage')]).optional(),
      splits: z
        .array(
          z.object({
            uuid: z.string().optional(),
            name: z.string().optional(),
            priority: z.number().optional(),
            split_amount: z.number().optional().nullable(),
          }),
        )
        .optional(),
    })
    .optional(),
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
});

export const putV1EmployeesEmployeeIdPaymentMethodResponseSchema = employeePaymentMethodSchema;

export const putV1EmployeesEmployeeIdPaymentMethodErrorSchema = z.unknown();

export const postV1CompanySignatoriesDataSchema = z.object({
  body: z
    .object({
      ssn: z.string(),
      first_name: z.string(),
      middle_initial: z.string().optional(),
      last_name: z.string(),
      email: z.string(),
      title: z.string(),
      phone: z.string().optional(),
      birthday: z.string(),
      home_address: z.object({
        street_1: z.string(),
        street_2: z.string().optional(),
        city: z.string(),
        state: z.string(),
        zip: z.string(),
      }),
    })
    .optional(),
  path: z.object({
    company_uuid: z.string(),
  }),
});

export const postV1CompanySignatoriesResponseSchema = signatorySchema;

export const postV1CompanySignatoriesErrorSchema = z.unknown();

export const getV1CompaniesCompanyUuidSignatoriesDataSchema = z.object({
  path: z.object({
    company_uuid: z.string(),
  }),
});

export const getV1CompaniesCompanyUuidSignatoriesResponseSchema = z.array(signatorySchema);

export const getV1CompaniesCompanyUuidSignatoriesErrorSchema = z.unknown();

export const getV1CompanyFormsDataSchema = z.object({
  path: z.object({
    company_id_or_uuid: z.string(),
  }),
});

export const getV1CompanyFormsResponseSchema = z.array(formSchema);

export const getV1CompanyFormsErrorSchema = z.unknown();

export const getV1CompanyFormDataSchema = z.object({
  path: z.object({
    id_or_uuid: z.string(),
  }),
});

export const getV1CompanyFormResponseSchema = formSchema;

export const getV1CompanyFormErrorSchema = z.unknown();

export const getV1CompanyFormPdfDataSchema = z.object({
  path: z.object({
    id_or_uuid: z.string(),
  }),
});

export const getV1CompanyFormPdfResponseSchema = z.object({
  uuid: z.string().optional(),
  document_url: z.string().optional(),
});

export const getV1CompanyFormPdfErrorSchema = z.unknown();

export const putV1CompanyFormSignDataSchema = z.object({
  body: z
    .object({
      signature_text: z.string(),
      agree: z.boolean(),
      signed_by_ip_address: z.string(),
    })
    .optional(),
  path: z.object({
    id_or_uuid: z.string(),
  }),
});

export const putV1CompanyFormSignResponseSchema = formSchema;

export const putV1CompanyFormSignErrorSchema = z.unknown();

export const getV1EmployeeFormsDataSchema = z.object({
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
});

export const getV1EmployeeFormsResponseSchema = z.array(formSchema);

export const getV1EmployeeFormsErrorSchema = z.unknown();

export const getV1EmployeeFormDataSchema = z.object({
  path: z.object({
    employee_id_or_uuid: z.string(),
    id_or_uuid: z.string(),
  }),
});

export const getV1EmployeeFormResponseSchema = formSchema;

export const getV1EmployeeFormErrorSchema = z.unknown();

export const getV1EmployeeFormPdfDataSchema = z.object({
  path: z.object({
    employee_id_or_uuid: z.string(),
    id_or_uuid: z.string(),
  }),
});

export const getV1EmployeeFormPdfResponseSchema = z.object({
  uuid: z.string().optional(),
  document_url: z.string().optional(),
});

export const getV1EmployeeFormPdfErrorSchema = z.unknown();

export const putV1EmployeeFormSignDataSchema = z.object({
  body: z
    .object({
      signature_text: z.string(),
      agree: z.boolean(),
      signed_by_ip_address: z.string(),
    })
    .optional(),
  path: z.object({
    employee_id_or_uuid: z.string(),
    id_or_uuid: z.string(),
  }),
});

export const putV1EmployeeFormSignResponseSchema = formSchema;

export const putV1EmployeeFormSignErrorSchema = z.unknown();

export const postV1CompanyFlowsDataSchema = z.object({
  body: z
    .object({
      flow_type: z.string(),
      entity_uuid: z.string().optional(),
      entity_type: z.literal('Company').optional(),
    })
    .optional(),
  path: z.object({
    company_uuid: z.string(),
  }),
});

export const postV1CompanyFlowsResponseSchema = flowSchema;

export const postV1CompanyFlowsErrorSchema = z.unknown();

export const getV1PayrollsPayrollUuidEmployeesEmployeeUuidPayStubDataSchema = z.object({
  path: z.object({
    employee_id_or_uuid: z.string(),
    payroll_id_or_uuid: z.string(),
  }),
});

export const getV1PayrollsPayrollUuidEmployeesEmployeeUuidPayStubResponseSchema = z.unknown();

export const getV1PayrollsPayrollUuidEmployeesEmployeeUuidPayStubErrorSchema = z.unknown();

export const postV1CompaniesCompanyUuidSignatoriesInviteDataSchema = z.object({
  body: z
    .object({
      first_name: z.string().optional(),
      last_name: z.string().optional(),
      title: z.string().optional(),
      email: z.string(),
    })
    .optional(),
  path: z.object({
    company_uuid: z.string(),
  }),
});

export const postV1CompaniesCompanyUuidSignatoriesInviteResponseSchema = signatorySchema;

export const postV1CompaniesCompanyUuidSignatoriesInviteErrorSchema = z.unknown();

export const putV1CompaniesCompanyUuidSignatoriesSignatoryUuidDataSchema = z.object({
  body: z
    .object({
      version: z.string().optional(),
      first_name: z.string().optional(),
      middle_initial: z.string().optional(),
      last_name: z.string().optional(),
      title: z.string().optional(),
      phone: z.string().optional(),
      birthday: z.string().optional(),
      ssn: z.string().optional(),
      home_address: z
        .object({
          street_1: z.string().optional(),
          street_2: z.string().optional(),
          city: z.string().optional(),
          state: z.string().optional(),
          zip: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  path: z.object({
    company_uuid: z.string(),
    signatory_uuid: z.string(),
  }),
});

export const putV1CompaniesCompanyUuidSignatoriesSignatoryUuidResponseSchema = signatorySchema;

export const putV1CompaniesCompanyUuidSignatoriesSignatoryUuidErrorSchema = z.unknown();

export const deleteV1CompaniesCompanyUuidSignatoriesSignatoryUuidDataSchema = z.object({
  path: z.object({
    company_uuid: z.string(),
    signatory_uuid: z.string(),
  }),
});

export const deleteV1CompaniesCompanyUuidSignatoriesSignatoryUuidResponseSchema = z.any();

export const deleteV1CompaniesCompanyUuidSignatoriesSignatoryUuidErrorSchema = z.unknown();

export const getV1EmployeesEmployeeIdOrUuidOnboardingStatusDataSchema = z.object({
  path: z.object({
    employee_id_or_uuid: z.string(),
  }),
});

export const getV1EmployeesEmployeeIdOrUuidOnboardingStatusResponseSchema = employeeOnboardingStatusSchema;

export const getV1EmployeesEmployeeIdOrUuidOnboardingStatusErrorSchema = z.unknown();

export const employeeStateTaxQuestionSchema = z.object({
  label: z.string(),
  description: z.string(),
  key: z.string(),
  input_question_format: employeeStateTaxInputQuestionFormatSchema,
  answers: z.array(employeeStateTaxAnswerSchema),
});

export const getV1EmployeesResponseSchema = employeeSchema;

export const employeeStateTaxSchema = z.object({
  employee_uuid: z.string(),
  state: z.string(),
  questions: z.array(employeeStateTaxQuestionSchema),
});

export const putV1EmployeesEmployeeIdStateTaxesResponseSchema = z.array(employeeStateTaxSchema);

export const getV1EmployeesEmployeeIdStateTaxesResponseSchema = z.array(employeeStateTaxSchema);
