// This file is auto-generated by @hey-api/openapi-ts

/**
 * The representation of an employee in Gusto.
 */
export type Employee = {
  /**
   * The ID of the employee in Gusto.
   */
  readonly id?: number;
  /**
   * A unique identifier of the employee in Gusto.
   */
  readonly uuid?: string;
  first_name?: string;
  middle_initial?: string | null;
  last_name?: string;
  /**
   * The email address of the employee. This is provided to support syncing users between our system and yours. You may not use this email address for any other purpose (e.g. marketing).
   */
  email?: string | null;
  /**
   * The ID of the company the employee is employed by.
   */
  readonly company_id?: number;
  /**
   * A unique identifier of the company the employee is employed by.
   */
  readonly company_uuid?: string;
  /**
   * The ID of the employee's manager in Gusto.
   */
  readonly manager_id?: number | null;
  /**
   * The current version of the employee. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for details using this field.
   */
  readonly version?: string;
  /**
   * The employee's department in the company.
   */
  readonly department?: string | null;
  /**
   * Whether the employee is terminated.
   */
  readonly terminated?: boolean;
  /**
   * Whether the employee is a two percent shareholder of the company. This field only applies to companies with an S-Corp entity type.
   */
  two_percent_shareholder?: boolean;
  /**
   * Whether the employee has completed onboarding.
   */
  readonly onboarded?: boolean;
  jobs?: Array<Job>;
  eligible_paid_time_off?: Array<Paid_Time_Off>;
  terminations?: Array<Termination>;
  home_address?: Location;
  garnishments?: Array<Garnishment>;
  /**
   * Custom fields are only included for the employee if the include param has the custom_fields value set
   */
  custom_fields?: Array<Employee_Custom_Field>;
  readonly date_of_birth?: string | null;
  /**
   * Indicates whether the employee has an SSN in Gusto.
   */
  has_ssn?: boolean;
  /**
   * Deprecated. This field always returns an empty string.
   */
  ssn?: string;
  phone?: string;
  preferred_first_name?: string;
  /**
   * The work email address of the employee. This is provided to support syncing users between our system and yours. You may not use this email address for any other purpose (e.g. marketing).
   */
  work_email?: string | null;
  /**
   * The current employment status of the employee. Full-time employees work 30+ hours per week. Part-time employees are split into two groups: those that work 20-29 hours a week, and those that work under 20 hours a week. Variable employees have hours that vary each week. Seasonal employees are hired for 6 months of the year or less.
   */
  readonly current_employment_status?:
    | ('full_time' | 'part_time_under_twenty_hours' | 'part_time_twenty_plus_hours' | 'variable' | 'seasonal')
    | null;
};

/**
 * The current employment status of the employee. Full-time employees work 30+ hours per week. Part-time employees are split into two groups: those that work 20-29 hours a week, and those that work under 20 hours a week. Variable employees have hours that vary each week. Seasonal employees are hired for 6 months of the year or less.
 */
export type current_employment_status =
  | 'full_time'
  | 'part_time_under_twenty_hours'
  | 'part_time_twenty_plus_hours'
  | 'variable'
  | 'seasonal';

/**
 * The representation of an employee's onboarding status.
 *
 * ## onboarding_status
 *
 * ### Admin-facilitated onboarding
 * | onboarding_status | Description |
 * | --- | ----------- |
 * | `admin_onboarding_incomplete` | Admin needs to complete the full employee-onboarding. |
 * | `onboarding_completed` | Employee has been fully onboarded and verified. |
 *
 * ### Employee self-onboarding
 * | onboarding_status | Description |
 * | --- | ----------- |
 * | `admin_onboarding_incomplete` | Admin needs to enter basic information about the employee. |
 * | `self_onboarding_not_invited` | Admin has the intention to invite the employee to self-onboard (e.g., marking a checkbox), but the system has not yet sent the invitation. |
 * | `self_onboarding_invited` | Employee has been sent an invitation to self-onboard. |
 * | `self_onboarding_invited_started` | Employee has started the self-onboarding process. |
 * | `self_onboarding_invited_overdue` | Employee's start date has passed, and employee has still not completed self-onboarding. |
 * | `self_onboarding_awaiting_admin_review` | Admin needs to review employee's entered information and confirm onboarding. |
 * | `onboarding_completed` | Employee has been fully onboarded and verified. |
 *
 * ## onboarding_steps
 *
 * | onboarding_steps | Requirement(s) to be completed |
 * | --- | ----------- |
 * | `personal_details` | Add employee's first name, last name, email, date of birth, social security number |
 * | `compensation_details` | Associate employee to a job & compensation. |
 * | `add_work_address` | Add employee work address. |
 * | `add_home_address` | Add employee home address. |
 * | `federal_tax_setup` | Set up federal tax withholdings. |
 * | `state_tax_setup` | Set up state tax withholdings. |
 * | `direct_deposit_setup` | Set up employee's direct deposit. |
 * | `employee_form_signing` | Employee forms (e.g., W4, direct deposit authorization) are generated & signed. |
 * | `admin_review` | Admin reviews & confirms employee details. |
 */
export type Employee_Onboarding_Status = {
  /**
   * Unique identifier for this employee.
   */
  uuid?: string;
  /**
   * One of the "onboarding_status" enum values.
   */
  onboarding_status?: string;
  /**
   * List of steps required to onboard an employee.
   */
  onboarding_steps?: Array<{
    /**
     * User-friendly description of the onboarding step.
     */
    title?: string;
    /**
     * String identifier for the onboarding step.
     */
    id?: string;
    /**
     * When true, this step has been completed.
     */
    required?: boolean;
    /**
     * When true, this step has been completed.
     */
    completed?: boolean;
    /**
     * A list of onboarding steps required to begin this step.
     */
    requirements?: Array<string>;
  }>;
};

/**
 * The representation of an address in Gusto.
 */
export type Location = {
  /**
   * The unique identifier of the location in Gusto.
   */
  readonly id?: number;
  /**
   * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
   */
  readonly version?: string;
  /**
   * The ID for the company to which the location belongs. Only included if the location belongs to a company.
   */
  readonly company_id?: number;
  /**
   * The ID for the employee to which the location belongs. Only included if the location belongs to an employee.
   */
  readonly employee_id?: number;
  /**
   * The phone number for the location. Required for company locations. Optional for employee locations.
   */
  phone_number?: string;
  street_1?: string;
  street_2?: string | null;
  city?: string;
  state?: string;
  zip?: string;
  country?: string;
  /**
   * The status of the location. Inactive locations have been deleted, but may still have historical data associated with them.
   */
  readonly active?: boolean;
  /**
   * Specifies if the location is the company's mailing address. Only included if the location belongs to a company.
   */
  mailing_address?: boolean;
  /**
   * Specifies if the location is the company's filing address. Only included if the location belongs to a company.
   */
  filing_address?: boolean;
};

/**
 * The representation of paid time off in Gusto.
 */
export type Paid_Time_Off = {
  /**
   * The name of the paid time off type.
   */
  readonly name?: string;
  /**
   * The unit the PTO type is accrued in.
   */
  readonly accrual_unit?: string;
  /**
   * The number of accrual units accrued per accrual period.
   */
  readonly accrual_rate?: string;
  /**
   * The frequency at which the PTO type is accrued.
   */
  readonly accrual_period?: string;
  /**
   * The number of accrual units accrued.
   */
  readonly accrual_balance?: string;
  /**
   * The maximum number of accrual units allowed. A null value signifies no maximum.
   */
  readonly maximum_accrual_balance?: string | null;
  /**
   * Whether the accrual balance is paid to the employee upon termination.
   */
  readonly paid_at_termination?: boolean;
};

/**
 * Garnishments, or employee deductions, are fixed amounts or percentages deducted from an employee’s pay. They can be deducted a specific number of times or on a recurring basis. Garnishments can also have maximum deductions on a yearly or per-pay-period bases. Common uses for garnishments are court-ordered payments for child support or back taxes. Some companies provide loans to their employees that are repaid via garnishments.
 */
export type Garnishment = {
  /**
   * The unique identifier of the garnishment in Gusto.
   */
  readonly id?: number;
  /**
   * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
   */
  readonly version?: string;
  /**
   * The ID of the employee to which this garnishment belongs.
   */
  readonly employee_id?: number;
  /**
   * Whether or not this garnishment is currently active.
   */
  active?: boolean;
  /**
   * The amount of the garnishment. Either a percentage or a fixed dollar amount. Represented as a float, e.g. "8.00".
   */
  amount?: string;
  /**
   * The description of the garnishment.
   */
  description?: string;
  /**
   * Whether the garnishment is court ordered.
   */
  court_ordered?: boolean;
  /**
   * The number of times to apply the garnisment. Ignored if recurring is true.
   */
  times?: number | null;
  /**
   * Whether the garnishment should recur indefinitely.
   */
  recurring?: boolean;
  /**
   * The maximum deduction per annum. A null value indicates no maximum. Represented as a float, e.g. "200.00".
   */
  annual_maximum?: string | null;
  /**
   * The maximum deduction per pay period. A null value indicates no maximum. Represented as a float, e.g. "16.00".
   */
  pay_period_maximum?: string | null;
  /**
   * Whether the amount should be treated as a percentage to be deducted per pay period.
   */
  deduct_as_percentage?: boolean;
};

/**
 * The representation of a termination in Gusto.
 */
export type Termination = {
  /**
   * The unique identifier of the termination in Gusto.
   */
  readonly id?: number;
  /**
   * The UUID of the termination object.
   */
  readonly uuid?: string;
  /**
   * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
   */
  readonly version?: string;
  /**
   * The ID of the employee to which this termination is attached.
   */
  readonly employee_id?: number;
  /**
   * The UUID of the employee to which this termination is attached.
   */
  readonly employee_uuid?: number;
  /**
   * Whether the employee's termination has gone into effect.
   */
  readonly active?: boolean;
  /**
   * The employee's last day of work.
   */
  effective_date?: string;
  /**
   * If true, the employee should recieve their final wages via an offcycle payroll. If false, they should recieve their final wages on their current pay schedule.
   */
  run_termination_payroll?: boolean;
};

/**
 * The representation of compensation in Gusto.
 */
export type Compensation = {
  /**
   * The unique identifier of the compensation in Gusto.
   */
  readonly id?: number;
  /**
   * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
   */
  readonly version?: string;
  /**
   * The ID of the job to which the compensation belongs.
   */
  readonly job_id?: number;
  /**
   * The dollar amount paid per payment unit.
   */
  rate?: string;
  /**
   * The unit accompanying the compensation rate. If the employee is an owner, rate should be 'Paycheck'.
   */
  payment_unit?: 'Hour' | 'Week' | 'Month' | 'Year' | 'Paycheck';
  /**
   * The FLSA status for this compensation. Salaried ('Exempt') employees are paid a fixed salary every pay period. Salaried with overtime ('Salaried Nonexempt') employees are paid a fixed salary every pay period, and receive overtime pay when applicable. Hourly ('Nonexempt') employees are paid for the hours they work, and receive overtime pay when applicable. Owners ('Owner') are employees that own at least twenty percent of the company.
   */
  flsa_status?: 'Exempt' | 'Salaried Nonexempt' | 'Nonexempt' | 'Owner';
  /**
   * The effective date for this compensation. For the first compensation, this defaults to the job's hire date.
   */
  effective_date?: string;
};

/**
 * The unit accompanying the compensation rate. If the employee is an owner, rate should be 'Paycheck'.
 */
export type payment_unit = 'Hour' | 'Week' | 'Month' | 'Year' | 'Paycheck';

/**
 * The FLSA status for this compensation. Salaried ('Exempt') employees are paid a fixed salary every pay period. Salaried with overtime ('Salaried Nonexempt') employees are paid a fixed salary every pay period, and receive overtime pay when applicable. Hourly ('Nonexempt') employees are paid for the hours they work, and receive overtime pay when applicable. Owners ('Owner') are employees that own at least twenty percent of the company.
 */
export type flsa_status = 'Exempt' | 'Salaried Nonexempt' | 'Nonexempt' | 'Owner';

export type Form = {
  /**
   * The UUID of the form
   */
  readonly uuid?: string;
  /**
   * The type identifier of the form
   */
  readonly name?: string;
  /**
   * The title of the form
   */
  readonly title?: string;
  /**
   * The description of the form
   */
  readonly description?: string;
  /**
   * A boolean flag that indicates whether the form needs signing or not. Note that this value will change after the form is signed.
   */
  readonly requires_signing?: boolean;
};

export type Industry = {
  /**
   * Company uuid
   */
  readonly company_uuid?: string;
  /**
   * North American Industry Classification System (NAICS) is used to classify businesses with a six digit number based on the primary type of work the business performs.
   */
  readonly naics_code?: string;
  /**
   * A list of Standard Industrial Classification (SIC) codes, which are four digit number that categorize the industries that companies belong to based on their business activities.
   */
  readonly sic_codes?: unknown[];
  /**
   * Industry title
   */
  readonly title?: string;
};

/**
 * The representation of a job in Gusto.
 */
export type Job = {
  /**
   * The unique identifier of the job in Gusto.
   */
  readonly id?: number;
  /**
   * the UUID of the job
   */
  readonly uuid?: string;
  /**
   * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
   */
  readonly version?: string;
  /**
   * The ID of the employee to which the job belongs.
   */
  readonly employee_id?: number;
  /**
   * The UUID of the employee to which the job belongs.
   */
  readonly employee_uuid?: string;
  /**
   * The ID of the job's work location.
   */
  location_id?: number;
  location?: {
    readonly id?: number;
    readonly street_1?: string;
    readonly street_2?: string | null;
    readonly city?: string;
    readonly state?: string;
    readonly zip?: string;
    readonly country?: string;
    /**
     * Whether the location of the job is active.
     */
    readonly inactive?: boolean;
  };
  /**
   * The date when the employee was hired for the job.
   */
  hire_date?: string;
  /**
   * The title for the job.
   */
  title?: string | null;
  /**
   * Whether this is the employee’s primary job. The value will be set to true unless an existing job exists for the employee.
   */
  readonly primary?: boolean;
  /**
   * The current compensation rate of the job.
   */
  readonly rate?: string;
  /**
   * The payment unit of the current compensation for the job.
   */
  readonly payment_unit?: string;
  /**
   * The ID for the current compensation of the job.
   */
  readonly current_compensation_id?: number;
  /**
   * The UUID of the current compensation of the job.
   */
  readonly current_compensation_uuid?: string;
  readonly compensations?: Array<Compensation>;
};

/**
 * The representation of an admin user in Gusto.
 */
export type Admin = {
  /**
   * The unique id of the admin.
   */
  uuid?: string;
  /**
   * The email of the admin. This is used by the admin to log in to their account.
   */
  email?: string;
  /**
   * The first name of the admin.
   */
  first_name?: string;
  /**
   * The last name of the admin.
   */
  last_name?: string;
};

/**
 * The representation of a company in Gusto.
 */
export type Company = {
  /**
   * The Federal Employer Identification Number of the company.
   */
  readonly ein?: string;
  /**
   * The tax payer type of the company.
   */
  readonly entity_type?:
    | 'C-Corporation'
    | 'S-Corporation'
    | 'Sole proprietor'
    | 'LLC'
    | 'LLP'
    | 'Limited partnership'
    | 'Co-ownership'
    | 'Association'
    | 'Trusteeship'
    | 'General partnership'
    | 'Joint venture'
    | 'Non-Profit';
  /**
   * The Gusto product tier of the company.
   */
  readonly tier?: ('core' | 'complete' | 'concierge' | 'contractor_only' | 'basic') | null;
  /**
   * Whether or not the company is suspended in Gusto. Suspended companies may not run payroll.
   */
  is_suspended?: boolean;
  /**
   * The status of the company in Gusto. "Approved" companies may run payroll with Gusto. "Not Approved" companies may not yet run payroll with Gusto. In order to run payroll, the company may need to complete onboarding or contact support. "Suspended" companies may not run payroll with Gusto. In order to unsuspend their account, the company must contact support.
   */
  readonly company_status?: 'Approved' | 'Not Approved' | 'Suspended';
  /**
   * The unique identifier of the company in Gusto.
   */
  readonly id?: number;
  /**
   * A unique identifier of the company in Gusto.
   */
  readonly uuid?: string;
  /**
   * The name of the company.
   */
  readonly name?: string;
  /**
   * The trade name of the company.
   */
  readonly trade_name?: string;
  /**
   * The locations of the company.
   */
  readonly locations?: Array<Location>;
  /**
   * The available company-wide compensation rates for the company.
   */
  readonly compensations?: {
    /**
     * The available hourly compensation rates for the company.
     */
    readonly hourly?: Array<{
      /**
       * The name of the hourly compensation rate.
       */
      readonly name?: string;
      /**
       * The amount multiplied by the base rate of a job to calculate compensation.
       */
      readonly multiple?: number;
    }>;
    /**
     * The available fixed compensation rates for the company.
     */
    readonly fixed?: Array<{
      /**
       * The name of the fixed compensation.
       */
      name?: string;
    }>;
    /**
     * The available types of paid time off for the company.
     */
    readonly paid_time_off?: Array<{
      /**
       * The name of the paid time off type.
       */
      readonly name?: string;
    }>;
  };
  /**
   * The primary signatory of the company.
   */
  readonly primary_signatory?: {
    readonly first_name?: string;
    readonly middle_initial?: string;
    readonly last_name?: string;
    readonly phone?: string;
    readonly email?: string;
    readonly home_address?: {
      readonly street_1?: string;
      readonly street_2?: string | null;
      readonly city?: string;
      readonly state?: string;
      readonly zip?: string;
      readonly country?: string;
    };
  };
  /**
   * The primary payroll admin of the company.
   */
  primary_payroll_admin?: {
    readonly first_name?: string;
    readonly last_name?: string;
    readonly phone?: string;
    readonly email?: string;
  };
};

/**
 * The tax payer type of the company.
 */
export type entity_type =
  | 'C-Corporation'
  | 'S-Corporation'
  | 'Sole proprietor'
  | 'LLC'
  | 'LLP'
  | 'Limited partnership'
  | 'Co-ownership'
  | 'Association'
  | 'Trusteeship'
  | 'General partnership'
  | 'Joint venture'
  | 'Non-Profit';

/**
 * The Gusto product tier of the company.
 */
export type tier = 'core' | 'complete' | 'concierge' | 'contractor_only' | 'basic';

/**
 * The status of the company in Gusto. "Approved" companies may run payroll with Gusto. "Not Approved" companies may not yet run payroll with Gusto. In order to run payroll, the company may need to complete onboarding or contact support. "Suspended" companies may not run payroll with Gusto. In order to unsuspend their account, the company must contact support.
 */
export type company_status = 'Approved' | 'Not Approved' | 'Suspended';

/**
 * The representation of a company's onboarding status
 */
export type Company_Onboarding_Status = {
  /**
   * the UUID of the company
   */
  uuid?: string;
  /**
   * a boolean flag for the company's onboarding status
   */
  onboarding_completed?: boolean;
  /**
   * a list of company onboarding steps
   */
  onboarding_steps?: Array<{
    /**
     * The display name of the onboarding step
     */
    title?: string;
    /**
     * The string identifier for each onboarding step
     */
    id?: string;
    /**
     * The boolean flag indicating whether the step is required or optional
     */
    required?: boolean;
    /**
     * The boolean flag indicating whether the step is completed or not.
     */
    completed?: boolean;
    /**
     * A list of onboarding step that are required to be completed in order to proceed with the current onboarding step.
     */
    requirements?: Array<string>;
  }>;
  ''?: string;
};

export type Payment_Configs = {
  /**
   * Company uuid
   */
  readonly company_uuid?: string;
  /**
   * Partner uuid
   */
  readonly partner_uuid?: string;
  /**
   * Payment limit only applicable for 2-day payroll
   */
  readonly fast_payment_limit?: number;
  /**
   * Payment speed for 2-day / 4-day
   */
  readonly payment_speed?: string;
};

/**
 * The representation of a contractor (individual or business) in Gusto.
 */
export type Contractor = {
  /**
   * The unique identifier of the contractor in Gusto.
   */
  readonly id?: number;
  /**
   * The ID of the company the contractor is employed by.
   */
  readonly company_id?: number;
  /**
   * The contractor's wage type, either "Fixed" or "Hourly".
   */
  wage_type?: 'Fixed' | 'Hourly';
  /**
   * The status of the contractor with the company.
   */
  readonly is_active?: boolean;
  /**
   * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
   */
  readonly version?: string;
  /**
   * The contractor's type, either "Individual" or "Business".
   */
  type?: 'Individual' | 'Business';
  /**
   * The contractor’s first name. This attribute is required for “Individual” contractors and will be ignored for “Business” contractors.
   */
  first_name?: string | null;
  /**
   * The contractor’s last name. This attribute is required for “Individual” contractors and will be ignored for “Business” contractors.
   */
  last_name?: string | null;
  /**
   * The contractor’s middle initial. This attribute is optional for “Individual” contractors and will be ignored for “Business” contractors.
   */
  middle_initial?: string | null;
  /**
   * The name of the contractor business. This attribute is required for “Business” contractors and will be ignored for “Individual” contractors.
   */
  business_name?: string | null;
  /**
   * The Federal Employer Identification Number of the contractor business. This attribute is optional for “Business” contractors and will be ignored for “Individual” contractors.
   */
  ein?: string | null;
  /**
   * The contractor’s email address. This attribute is optional for “Individual” contractors and will be ignored for “Business” contractors.
   */
  email?: string | null;
  /**
   * The contractor’s home address.
   */
  readonly address?: {
    readonly street_1?: string;
    readonly street_2?: string | null;
    readonly city?: string;
    readonly state?: string;
    readonly zip?: string;
    readonly country?: string;
  };
  /**
   * The contractor’s hourly rate. This attribute is required if the wage_type is “Hourly”.
   */
  hourly_rate?: string;
};

/**
 * The contractor's wage type, either "Fixed" or "Hourly".
 */
export type wage_type = 'Fixed' | 'Hourly';

/**
 * The contractor's type, either "Individual" or "Business".
 */
export type type = 'Individual' | 'Business';

/**
 * The representation of a single contractor payment.
 */
export type Contractor_Payment = {
  /**
   * The unique identifier of the contractor payment in Gusto.
   */
  readonly uuid?: string;
  /**
   * The unique identifier of the contractor in Gusto.
   */
  readonly contractor_id?: number;
  /**
   * The bonus amount in the payment.
   */
  readonly bonus?: string;
  /**
   * The payment date.
   */
  readonly date?: string;
  /**
   * The number of hours worked for the payment.
   */
  readonly hours?: string;
  /**
   * The payment method.
   */
  readonly payment_method?: 'Direct Deposit' | 'Check' | 'Historical Payment' | 'Correction Payment';
  /**
   * The reimbursement amount in the payment.
   */
  readonly reimbursement?: string;
  /**
   * The rate per hour worked for the payment.
   */
  readonly hourly_rate?: string;
  /**
   * The fixed wage of the payment, regardless of hours worked.
   */
  readonly wage?: string;
  /**
   * The wage type for the payment.
   */
  readonly wage_type?: 'Hourly' | 'Fixed';
  /**
   * (hours * hourly_rate) + wage + bonus
   */
  readonly wage_total?: string;
};

/**
 * The payment method.
 */
export type payment_method = 'Direct Deposit' | 'Check' | 'Historical Payment' | 'Correction Payment';

/**
 * The representation of the summary of contractor payments for a given company in a given time period.
 */
export type Contractor_Payment_Summary = {
  /**
   * The wage and reimbursement totals for all contractor payments within a given time period.
   */
  readonly total?: {
    /**
     * The total reimbursements for contractor payments within a given time period.
     */
    readonly reimbursements?: string;
    /**
     * The total wages for contractor payments within a given time period.
     */
    readonly wages?: string;
  };
  /**
   * The individual contractor payments, within a given time period, grouped by contractor.
   */
  readonly contractor_payments?: Array<{
    /**
     * The ID of the contractor.
     */
    readonly contractor_id?: number;
    /**
     * The total remibursements for the contractor within a given time period.
     */
    readonly reimbursement_total?: string;
    /**
     * The total wages for the contractor within a given time period.
     */
    readonly wage_total?: string;
    /**
     * The contractor’s payments within a given time period.
     *
     */
    readonly payments?: Array<Contractor_Payment>;
  }>;
};

/**
 * The representation of a time off request.
 */
export type Time_Off_Request = {
  /**
   * The ID of the time off request.
   */
  readonly id?: number;
  /**
   * The status of the time off request.
   */
  readonly status?: 'pending' | 'approved' | 'denied';
  /**
   * A note about the time off request, from the employee to the employer.
   */
  readonly employee_note?: string;
  /**
   * A note about the time off request, from the employer to the employee.
   */
  readonly employer_note?: string;
  /**
   * The type of time off request.
   */
  readonly request_type?: 'vacation' | 'sick';
  /**
   * An object that represents the days in the time off request. The keys of the object are the dates, formatted as a YYYY-MM-DD string. The values of the object are the number of hours requested off for each day, formatted as a string representation of a numeric decimal to the thousands place.
   */
  readonly days?: {
    [key: string]: unknown;
  };
  readonly employee?: {
    /**
     * The ID of the employee the time off request is for.
     */
    readonly id?: string;
    /**
     * The full name of the employee the time off request is for.
     */
    readonly full_name?: string;
  };
  readonly initiator?: {
    /**
     * The ID of the employee who initiated the time off request.
     */
    readonly id?: string;
    /**
     * The full name of the employee who initiated the time off request.
     */
    readonly full_name?: string;
  } | null;
  /**
   * This value will be null if the request has not been approved.
   */
  readonly approver?: {
    /**
     * The ID of the employee who approved the time off request.
     */
    readonly id?: string;
    /**
     * The full name of the employee who approved the time off request.
     */
    readonly full_name?: string;
  } | null;
};

/**
 * The status of the time off request.
 */
export type status = 'pending' | 'approved' | 'denied';

/**
 * The type of time off request.
 */
export type request_type = 'vacation' | 'sick';

export type Current_User = {
  /**
   * The ID of the current user.
   */
  readonly id?: number;
  /**
   * The email address of the authenticated user.
   */
  readonly email?: string;
  /**
   * An object containing each of the user's permissions.
   */
  readonly roles?: {
    readonly payroll_admin?: {
      /**
       * A lists of companies for which the current user has admin permissions. Users (most notably accountants) can have priviliges with multiple companies.
       */
      readonly companies?: Array<{
        /**
         * The ID of the company.
         */
        readonly id?: number;
        /**
         * The name of the company.
         */
        readonly name?: string;
        /**
         * The trade name of the company.
         */
        readonly trade_name?: string;
        /**
         * A list of the company locations.
         */
        readonly locations?: Array<Location>;
      }>;
    };
  };
};

/**
 * The representation of a pay schedule.
 */
export type Pay_Schedule = {
  /**
   * The identifier of the pay schedule.
   */
  readonly id?: number;
  /**
   * The unique identifier of the pay schedule in Gusto.
   */
  readonly uuid?: string;
  /**
   * The frequency that employees on this pay schedule are paid with Gusto.
   */
  readonly frequency?: 'Every week' | 'Every other week' | 'Twice per month' | 'Monthly';
  /**
   * The first date that employees on this pay schedule are paid with Gusto.
   */
  readonly anchor_pay_date?: string;
  /**
   * An integer between 1 and 31 indicating the first day of the month that employees are paid. This field is only relevant for pay schedules with the “Twice per month” and “Monthly” frequencies. It will be null for pay schedules with other frequencies.
   */
  readonly day_1?: number | null;
  /**
   * An integer between 1 and 31 indicating the second day of the month that employees are paid. This field is the second pay date for pay schedules with the “Twice per month” frequency. It will be null for pay schedules with other frequencies.
   */
  readonly day_2?: number | null;
  /**
   * Hourly when the pay schedule is for hourly employees. Salaried when the pay schedule is for salaried employees. It will be null when the pay schedule is for all employees.
   */
  readonly name?: string | null;
  /**
   * With Autopilot® enabled, payroll will run automatically one day before your payroll deadlines.
   */
  auto_pilot?: boolean;
};

/**
 * The frequency that employees on this pay schedule are paid with Gusto.
 */
export type frequency = 'Every week' | 'Every other week' | 'Twice per month' | 'Monthly';

/**
 * The company bank account
 */
export type Company_Bank_Account = {
  /**
   * UUID of the bank account
   */
  uuid?: string;
  /**
   * UUID of the company
   */
  company_uuid?: string;
  /**
   * Bank account type
   */
  account_type?: 'Checking' | 'Savings';
  /**
   * The bank account's routing number
   */
  routing_number?: string;
  /**
   * Masked bank account number
   */
  hidden_account_number?: string;
  /**
   * The verification status of the bank account.
   *
   * 'awaiting_deposits' means the bank account is just created and money is being transferred.
   * 'ready_for_verification' means the micro-deposits are completed and the verification process can begin by using the verify endpoint.
   * 'verified' means the bank account is verified.
   */
  verification_status?: 'awaiting_deposits' | 'ready_for_verification' | 'verified';
  /**
   * The verification type of the bank account.
   *
   * 'bank_deposits' means the bank account is connected by entering routing and accouting numbers and verifying through micro-deposits.
   * 'plaid' means the bank account is connected through Plaid.
   */
  verification_type?: 'bank_deposits' | 'plaid';
  /**
   * The Plaid connection status of the bank account. Only apply when verification type is Plaid.
   */
  plaid_status?: 'connected' | 'disconnected';
  /**
   * The last fetch balance for the bank account. Please be awared this amount is not reflecting to the most up-to-date balance. Only apply when verification type is Plaid.
   */
  last_cached_balance?: string;
  /**
   * The balance fetch date associate with the last_cached_balance. Only apply when verification type is Plaid.
   */
  balance_fetched_date?: string;
};

/**
 * Bank account type
 */
export type account_type = 'Checking' | 'Savings';

/**
 * The verification status of the bank account.
 *
 * 'awaiting_deposits' means the bank account is just created and money is being transferred.
 * 'ready_for_verification' means the micro-deposits are completed and the verification process can begin by using the verify endpoint.
 * 'verified' means the bank account is verified.
 */
export type verification_status = 'awaiting_deposits' | 'ready_for_verification' | 'verified';

/**
 * The verification type of the bank account.
 *
 * 'bank_deposits' means the bank account is connected by entering routing and accouting numbers and verifying through micro-deposits.
 * 'plaid' means the bank account is connected through Plaid.
 */
export type verification_type = 'bank_deposits' | 'plaid';

/**
 * The Plaid connection status of the bank account. Only apply when verification type is Plaid.
 */
export type plaid_status = 'connected' | 'disconnected';

export type Supported_Benefit = {
  /**
   * The ID of the benefit type in Gusto.
   */
  readonly id?: number;
  /**
   * The name of the benefit.
   */
  readonly name?: string;
  /**
   * The description of the benefit.
   */
  readonly description?: string;
  /**
   * Whether the benefit is deducted before tax calculations, thus reducing one’s taxable income
   */
  readonly pretax?: boolean;
  /**
   * Whether the benefit is deducted after tax calculations.
   */
  readonly posttax?: boolean;
  /**
   * Whether the benefit is considered imputed income.
   */
  readonly imputed?: boolean;
  /**
   * Whether the benefit is healthcare related.
   */
  readonly healthcare?: boolean;
  /**
   * Whether the benefit is associated with retirement planning.
   */
  readonly retirement?: boolean;
  /**
   * Whether the benefit has a government mandated yearly limit.
   */
  readonly yearly_limit?: boolean;
};

/**
 * The representation of a company benefit.
 */
export type Company_Benefit = {
  /**
   * The ID of the company benefit.
   */
  readonly id?: number;
  /**
   * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
   */
  readonly version?: string;
  /**
   * The ID of the company to which the company benefit belongs.
   */
  readonly company_id?: number;
  /**
   * The ID of the benefitt to which the company benefit belongs.
   */
  readonly benefit_id?: number;
  /**
   * Whether this benefit is active for employee participation. Company benefits may only be deactivated if no employees are actively participating.
   */
  active?: boolean;
  /**
   * The description of the company benefit.For example, a company may offer multiple benefits with an ID of 1 (for Medical Insurance). The description would show something more specific like “Kaiser Permanente” or “Blue Cross/ Blue Shield”.
   */
  description?: string;
  /**
   * Whether employee deductions and company contributions can be set as percentages of payroll for an individual employee. This is determined by the type of benefit and is not configurable by the company.
   */
  readonly supports_percentage_amounts?: boolean;
  /**
   * Whether the employer is subject to pay employer taxes when an employee is on leave. Only applicable to third party sick pay benefits.
   */
  responsible_for_employer_taxes?: boolean;
  /**
   * Whether the employer is subject to file W-2 forms for an employee on leave. Only applicable to third party sick pay benefits.
   */
  responsible_for_employee_w2?: boolean;
};

export type Earning_Type = {
  /**
   * The name of the earning type.
   */
  name?: string;
  /**
   * The ID of the earning type.
   */
  readonly uuid?: string;
};

/**
 * The representation of an employee benefit.
 */
export type Employee_Benefit = {
  /**
   * The ID of the employee benefit.
   */
  readonly id?: number;
  /**
   * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
   */
  readonly version?: string;
  /**
   * The ID of the employee to which the benefit belongs.
   */
  readonly employee_id?: number;
  /**
   * The ID of the company to which the benefit belongs.
   */
  readonly company_benefit_id?: number;
  /**
   * Whether the employee benefit is active.
   */
  active?: boolean;
  /**
   * The amount to be deducted, per pay period, from the employee's pay.
   */
  employee_deduction?: string;
  /**
   * Whether the employee deduction amount should be treated as a percentage to be deducted from each payroll.
   */
  deduct_as_percentage?: boolean;
  /**
   * The maximum employee deduction amount per year. A null value signifies no limit.
   */
  employee_deduction_annual_maximum?: string | null;
  /**
   * An object representing the type and value of the company contribution.
   */
  contribution?: {
    /**
     * The company contribution scheme.
     *
     * "amount": The company contributes a fixed amount per payroll. If elective is true, the contribution is matching, dollar-for-dollar.
     *
     * "percentage": The company contributes a percentage of the payroll amount per payroll period. If elective is true, the contribution is matching, dollar-for-dollar.
     *
     * "tiered": The company contribution varies according to the size of the employee deduction.
     */
    type?: string;
    /**
     * For the `amount` and `percentage` contribution types, the value of the corresponding amount or percentage.
     *
     * For the `tiered` contribution type, an array of tiers.
     */
    value?:
      | string
      | {
          tiers?: Array<{
            /**
             * The percentage of employee deduction within this tier the company contribution will match.
             */
            rate?: string;
            /**
             * The percentage threshold at which this tier ends (inclusive).
             *
             * For example, a value of "5" means the company contribution will match employee deductions from the previous tier's threshold up to and including 5% of payroll.
             *
             * If this is the first tier, a value of "5" means the company contribution will match employee deductions from 0% up to and including 5% of payroll.
             */
            threshold?: string;
            /**
             * The step up difference between this tier's threshold and the previous tier's threshold. In the first tier, this is equivalent to threshold.
             */
            threshold_delta?: string;
          }>;
        };
  };
  /**
   * Whether the company contribution is elective (aka matching). For "tiered" contribution types, this is always true.
   */
  elective?: boolean;
  /**
   * The maximum company contribution amount per year. A null value signifies no limit.
   */
  company_contribution_annual_maximum?: string | null;
  /**
   * Some benefits require additional information to determine their limit. For example, for an HSA benefit, the limit option should be either "Family" or "Individual". For a Dependent Care FSA benefit, the limit option should be either "Joint Filing or Single" or "Married and Filing Separately".
   */
  limit_option?: string | null;
  /**
   * Whether the employee should use a benefit’s "catch up" rate. Only Roth 401k and 401k benefits use this value for employees over 50.
   */
  catch_up?: boolean;
  /**
   * The amount that the employee is insured for. Note: company contribution cannot be present if coverage amount is set.
   */
  coverage_amount?: string | null;
  /**
   * Whether the employee deduction reduces taxable income or not. Only valid for Group Term Life benefits. Note: when the value is not "unset", coverage amount and coverage salary multiplier are ignored.
   */
  deduction_reduces_taxable_income?: ('unset' | 'reduces_taxable_income' | 'does_not_reduce_taxable_income') | null;
  /**
   * The coverage amount as a multiple of the employee’s salary. Only applicable for Group Term Life benefits. Note: cannot be set if coverage amount is also set.
   */
  coverage_salary_multiplier?: string;
  /**
   * The amount to be paid, per pay period, by the company. This field will not appear for tiered contribution types.
   * @deprecated
   */
  company_contribution?: string;
  /**
   * Whether the company_contribution value should be treated as a percentage to be added to each payroll. This field will not appear for tiered contribution types.
   * @deprecated
   */
  contribute_as_percentage?: boolean;
};

/**
 * Whether the employee deduction reduces taxable income or not. Only valid for Group Term Life benefits. Note: when the value is not "unset", coverage amount and coverage salary multiplier are ignored.
 */
export type deduction_reduces_taxable_income = 'unset' | 'reduces_taxable_income' | 'does_not_reduce_taxable_income';

/**
 * The representation of a pay period.
 */
export type Pay_Period = {
  /**
   * The start date, inclusive, of the pay period.
   */
  readonly start_date?: string;
  /**
   * The end date, inclusive, of the pay period.
   */
  end_date?: string;
  /**
   * The ID of the pay schedule to which the pay period belongs.
   */
  readonly pay_schedule_id?: number;
  /**
   * A unique identifier of the pay schedule to which the pay period belongs.
   */
  readonly pay_schedule_uuid?: string;
  /**
   * The employees who are (or were) eligible during the pay period.
   */
  readonly eligible_employees?: Array<{
    /**
     * The ID of the employee that is eligible for the pay period.
     */
    readonly id?: number;
    /**
     * The employee's job IDs that are eligible for the pay period.
     */
    readonly job_ids?: Array<number>;
  }>;
  /**
   * Information about the payroll for the pay period.
   */
  readonly payroll?: {
    /**
     * Whether or not the payroll has been successfully processed. Note that processed payrolls cannot be updated. Additionally, a payroll is not guaranteed to be processed just because the payroll deadline has passed. Late payrolls are not uncommon. Conversely, users may choose to run payroll before the payroll deadline.
     */
    readonly processed?: boolean;
    /**
     * The date by which payroll should be run for employees to be paid on time. Payroll data, such as time and attendance data, should be submitted on or before this date.
     */
    readonly payroll_deadline?: string;
  };
};

export type Payroll = {
  /**
   * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for details using this field.
   */
  readonly version?: string;
  /**
   * The deadline for the payroll to be run in order for employees to be paid on time.
   */
  readonly payroll_deadline?: string;
  /**
   * The date on which employees will be paid for the payroll.
   */
  readonly check_date?: string;
  /**
   * Whether or not the payroll has been successfully processed. Note that processed payrolls cannot be updated. Additionally, a payroll is not guaranteed to be processed just because the payroll deadline has passed. Late payrolls are not uncommon. Conversely, users may choose to run payroll before the payroll deadline.
   */
  readonly processed?: boolean;
  /**
   * The date at which the payroll was processed. Null if the payroll isn't processed yet.
   */
  readonly processed_date?: string;
  /**
   * A timestamp of the last valid payroll calculation. Null is there isn't a valid calculation.
   */
  readonly calculated_at?: string;
  /**
   * The ID of the payroll.
   */
  readonly payroll_id?: number;
  /**
   * A unique identifier of the payroll.
   */
  readonly payroll_uuid?: string;
  /**
   * The ID of the company for the payroll.
   */
  readonly company_id?: number;
  /**
   * A unique identifier of the company for the payroll.
   */
  readonly company_uuid?: string;
  readonly pay_period?: {
    /**
     * The start date, inclusive, of the pay period.
     */
    readonly start_date?: string;
    /**
     * The start date, inclusive, of the pay period.
     */
    readonly end_date?: string;
    /**
     * The ID of the pay schedule for the payroll.
     */
    readonly pay_schedule_id?: number;
    /**
     * A unique identifier of the pay schedule for the payroll..
     */
    readonly pay_schedule_uuid?: string;
  };
  /**
   * The subtotals for the payroll.
   */
  readonly totals?: {
    /**
     * The total company debit for the payroll.
     */
    readonly company_debit?: string;
    /**
     * The total company net pay for the payroll.
     */
    net_pay_debit?: string;
    /**
     * The total tax debit for the payroll.
     */
    readonly tax_debit?: string;
    /**
     * The total reimbursement debit for the payroll.
     */
    readonly reimbursement_debit?: string;
    /**
     * The total child support debit for the payroll.
     */
    readonly child_support_debit?: string;
    /**
     * The total reimbursements for the payroll.
     */
    readonly reimbursements?: string;
    /**
     * The net pay amount for the payroll.
     */
    readonly net_pay?: string;
    /**
     * The gross pay amount for the payroll.
     */
    readonly gross_pay?: string;
    /**
     * The total employee bonuses amount for the payroll.
     */
    readonly employee_bonuses?: string;
    /**
     * The total employee commissions amount for the payroll.
     */
    readonly employee_commissions?: string;
    /**
     * The total employee cash tips amount for the payroll.
     */
    readonly employee_cash_tips?: string;
    /**
     * The total employee paycheck tips amount for the payroll.
     */
    readonly employee_paycheck_tips?: string;
    /**
     * The total additional earnings amount for the payroll.
     */
    readonly additional_earnings?: string;
    /**
     * The total owner's draw for the payroll.
     */
    readonly owners_draw?: string;
    /**
     * The total check amount for the payroll.
     */
    readonly check_amount?: string;
    /**
     * The total amount of employer paid taxes for the payroll.
     */
    readonly employer_taxes?: string;
    /**
     * The total amount of employee paid taxes for the payroll.
     */
    readonly employee_taxes?: string;
    /**
     * The total amount of company contributed benefits for the payroll.
     */
    readonly benefits?: string;
    /**
     * The total amount of employee deducted benefits for the payroll.
     */
    readonly employee_benefits_deductions?: string;
    /**
     * The total amount of payroll taxes deferred for the payroll, such as allowed by the CARES act.
     */
    readonly deferred_payroll_taxes?: string;
  };
  employee_compensations?: Array<{
    /**
     * The ID of the employee.
     */
    readonly employee_id?: number;
    /**
     * The UUID of the employee.
     */
    readonly employee_uuid?: string;
    /**
     * This employee will be excluded from payroll calculation and will not be paid for the payroll. Cancelling a payroll would reset all employees' excluded back to false.
     */
    readonly excluded?: boolean;
    /**
     * The employee's gross pay. This value is only available for processed payrolls.
     */
    readonly gross_pay?: string | null;
    /**
     * The employee's net pay. This value is only available for processed payrolls.
     */
    readonly net_pay?: string | null;
    /**
     * The employee's compensation payment method. This value is only available for processed payrolls.
     */
    payment_method?: ('Check' | 'Direct Deposit') | null;
    /**
     * An array of fixed compensations for the employee. Fixed compensations include tips, bonuses, and one time reimbursements. If this payroll has been procesed, only fixed compensations with a value greater than 0.00 are returned. For an unprocess payroll, all active fixed compensations are returned.
     */
    fixed_compensations?: Array<{
      /**
       * The name of the compensation. This also serves as the unique, immutable identifier for this compensation.
       */
      name?: string;
      /**
       * The amount of the compensation for the pay period.
       */
      amount?: string;
      /**
       * The ID of the job for the compensation.
       */
      readonly job_id?: number;
    }>;
    /**
     * An array of hourly compensations for the employee. Hourly compensations include regular, overtime, and double overtime hours. If this payroll has been procesed, only hourly compensations with a value greater than 0.00 are returned. For an unprocess payroll, all active hourly compensations are returned.
     */
    hourly_compensations?: Array<{
      /**
       * The name of the compensation. This also serves as the unique, immutable identifier for this compensation.
       */
      name?: string;
      /**
       * The number of hours to be compensated for this pay period.
       */
      hours?: string;
      /**
       * The ID of the job for the compensation.
       */
      readonly job_id?: number;
      /**
       * The amount multiplied by the base rate to calculate total compensation per hour worked.
       */
      readonly compensation_multiplier?: number;
    }>;
    /**
     * An array of all paid time off the employee is eligible for this pay period.
     */
    paid_time_off?: Array<{
      /**
       * The name of the PTO. This also serves as the unique, immutable identifier for the PTO.
       */
      name?: string;
      /**
       * The hours of this PTO taken during the pay period.
       */
      hours?: string;
    }>;
    /**
     * An array of employee benefits for the pay period. Benefits are only included for processed payroll when the include parameter is present.
     */
    readonly benefits?: Array<{
      readonly name?: string;
      readonly employee_deduction?: string;
      readonly company_contribution?: string;
      imputed?: boolean;
    }>;
    /**
     * An array of employee deductions for the pay period. Deductions are only included for processed payroll when the include parameter is present.
     */
    readonly deductions?: Array<{
      readonly name?: string;
      readonly amount?: string;
    }>;
    /**
     * An array of employer and employee taxes for the pay period. Taxes are only included for processed payroll when the include parameter is present.
     */
    readonly taxes?: Array<{
      name: string;
      employer: boolean;
      amount: string;
    }>;
  }>;
  /**
   * Only applicable when a payroll is moved to four day processing instead of fast ach.
   */
  payment_speed_changed?: {
    /**
     * Original check date when fast ach applies.
     */
    readonly original_check_date?: string;
    /**
     * Current check date.
     */
    readonly current_check_date?: string;
    /**
     * Original debit date when fast ach applies.
     */
    readonly original_debit_date?: number;
    /**
     * Current check date.
     */
    readonly current_debit_date?: string;
    /**
     * The reason why the payroll is moved to four day.
     */
    readonly reason?: string;
  };
};

export type Custom_Field_Type = 'text' | 'currency' | 'number' | 'date' | 'radio';

/**
 * A custom field of an employee
 */
export type Employee_Custom_Field = {
  id: string;
  /**
   * This is the id of the response object from when you get the company custom fields
   */
  company_custom_field_id: string;
  name: string;
  type: Custom_Field_Type;
  description?: string;
  value: string;
  /**
   * An array of options for fields of type radio. Otherwise, null.
   */
  selection_options?: Array<string> | null;
};

/**
 * A custom field on a company
 */
export type Company_Custom_Field = {
  id: string;
  name: string;
  type: Custom_Field_Type;
  description?: string;
  /**
   * An array of options for fields of type radio. Otherwise, null.
   */
  selection_options?: Array<string> | null;
};

/**
 * The representation of a company's signatory
 */
export type Signatory = {
  uuid?: string;
  first_name?: string | null;
  last_name?: string | null;
  title?: string | null;
  phone?: string | null;
  email?: string;
  birthday?: string | null;
  /**
   * Whether or not the signatory is also the payroll admin of the company.
   */
  is_admin?: boolean;
  /**
   * Indicates whether the signatory has an SSN in Gusto.
   */
  has_ssn?: boolean;
  /**
   * The current version of the signatory. See the versioning guide for details using this field.
   */
  version?: string;
  /**
   * |   |   |
   * |---|---|
   * |__Status__| __Description__ |
   * | Pass | Signatory can sign all forms |
   * | Fail | Signatory cannot sign forms |
   * | Skipped | Signatory cannot sign Form 8655 until the form is manually uploaded as wet-signed |
   * | null | Identity verification process has not been completed |
   */
  identity_verification_status?: ('Pass' | 'Fail' | 'Skipped') | null;
  home_address?: {
    street_1?: string;
    street_2?: string;
    city?: string;
    state?: string;
    zip?: string;
    country?: string;
  } | null;
};

/**
 * |   |   |
 * |---|---|
 * |__Status__| __Description__ |
 * | Pass | Signatory can sign all forms |
 * | Fail | Signatory cannot sign forms |
 * | Skipped | Signatory cannot sign Form 8655 until the form is manually uploaded as wet-signed |
 * | null | Identity verification process has not been completed |
 */
export type identity_verification_status = 'Pass' | 'Fail' | 'Skipped';

/**
 * The representation of a flow in Gusto whitelabel UI.
 */
export type Flow = {
  url?: string;
  expires_at?: string;
};

export type Employee_Federal_Tax = {
  /**
   * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for details using this field.
   */
  version?: string;
  /**
   * It determines which tax return form an individual will use and is an important factor in computing taxable income. One of:
   * - Single
   * - Married
   * - Head of Household
   * - Exempt from withholding
   * - Married, but withhold as Single (does not apply to rev_2020_w4 form)
   */
  filing_status?: string;
  /**
   * An employee can request an additional amount to be withheld from each paycheck.
   */
  extra_withholding?: string;
  /**
   * If there are only two jobs (i.e., you and your spouse each have a job, or you have two), you can set it to true.
   */
  two_jobs?: boolean;
  /**
   * A dependent is a person other than the taxpayer or spouse who entitles the taxpayer to claim a dependency exemption.
   */
  dependents_amount?: string;
  /**
   * Other income amount.
   */
  other_income?: string;
  deductions?: string;
  /**
   * The version of w4 form.
   */
  w4_data_type?: 'pre_2020_w4' | 'rev_2020_w4';
  /**
   * *does not apply to rev_2020_w4 form*
   *
   * An exemption from paying a certain amount of income tax.
   */
  federal_withholding_allowance?: string;
  /**
   * *does not apply to rev_2020_w4 form*
   */
  additional_withholding?: boolean;
};

/**
 * The version of w4 form.
 */
export type w4_data_type = 'pre_2020_w4' | 'rev_2020_w4';

export type Employee_State_Tax = {
  /**
   * The employee's uuid
   */
  employee_uuid: string;
  /**
   * Two letter US state abbreviation
   */
  state: string;
  questions: Array<Employee_State_Tax_Question>;
};

export type Employee_State_Tax_Question = {
  /**
   * A short title for the question
   */
  label: string;
  /**
   * An explaination of the question - this may contain inline html formatted links.
   */
  description: string;
  /**
   * A unique identifier of the question (for the given state) - used for updating the answer.
   */
  key: string;
  input_question_format: Employee_State_Tax_Input_Question_Format;
  answers: Array<Employee_State_Tax_Answer>;
};

export type Employee_State_Tax_Answer = {
  /**
   * The answer to the corresponding question - this may be a string, number, boolean, or null.
   */
  value?: string;
  /**
   * The effective date of the answer - currently always “2010-01-01”.
   */
  valid_from?: string;
  /**
   * The effective end date of the answer - currently always null.
   */
  valid_up_to?: unknown;
};

export type Employee_State_Tax_Input_Question_Format = {
  /**
   * Describes the type of question - Text, Number, Select, Currency
   */
  type: string;
  /**
   * For "Select" type questions, the allowed values and display labels.
   */
  options?: Array<{
    /**
     * An allowed value to answer the question
     */
    value?: string;
    /**
     * A display label that corresponds to the answer value
     */
    label: string;
  }>;
};

export type Federal_Tax_Details = {
  /**
   * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for details using this field.
   */
  version?: string;
  /**
   * What type of tax entity the company is. One of:
   * - C-Corporation
   * - S-Corporation
   * - Sole proprietor
   * - LLC
   * - LLP
   * - Limited partnership
   * - Co-ownership
   * - Association
   * - Trusteeship
   * - General partnership
   * - Joint venture
   * - Non-Profit
   */
  tax_payer_type?: string;
  /**
   * Whether the company is taxed as an S-Corporation. Tax payer types that may be taxed as an S-Corporation include:
   * - S-Corporation
   * - C-Corporation
   * - LLC
   */
  taxable_as_scorp?: string;
  /**
   * The form used by the company for federal tax filing. One of:
   * - 941 (Quarterly federal tax return form)
   * - 944 (Annual federal tax return form)
   */
  filing_form?: string;
  /**
   * Whether company's Employer Identification Number (EIN) is present
   */
  has_ein?: boolean;
  /**
   * Whether the EIN was able to be verified as a valid EIN with the IRS.
   */
  ein_verified?: boolean;
  /**
   * The legal name of the company
   */
  legal_name?: string;
};

export type Employee_Bank_Account = {
  /**
   * UUID of the bank account
   */
  uuid?: string;
  /**
   * UUID of the employee
   */
  employee_uuid?: string;
  /**
   * Bank account type
   */
  account_type?: 'Checking' | 'Savings';
  /**
   * Name for the bank account
   */
  name?: string;
  /**
   * The bank account's routing number
   */
  routing_number?: string;
  /**
   * Masked bank account number
   */
  hidden_account_number?: string;
};

export type Employee_Payment_Method = {
  /**
   * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
   */
  version?: string;
  /**
   * The payment method type. If type is Check, then split_by and splits do not need to be populated. If type is Direct Deposit, split_by and splits are required.
   */
  type?: 'Direct Deposit' | 'Check';
  /**
   * Describes how the payment will be split. If split_by is Percentage, then the split amounts must add up to exactly 100. If split_by is Amount, then the last split amount must be nil to capture the remainder.
   */
  split_by?: ('Amount' | 'Percentage') | null;
  splits?: Array<{
    /**
     * The bank account ID
     */
    uuid?: string;
    /**
     * The bank account name
     */
    name?: string;
    /**
     * Masked bank account number
     */
    hidden_account_number?: string;
    /**
     * The order of priority for each payment split, with priority 1 being the first bank account paid. Priority must be unique and sequential.
     */
    priority?: number;
    /**
     * The cents amount allocated for each payment split
     */
    split_amount?: number | null;
  }> | null;
};

/**
 * The payment method type. If type is Check, then split_by and splits do not need to be populated. If type is Direct Deposit, split_by and splits are required.
 */
export type type2 = 'Direct Deposit' | 'Check';

/**
 * Describes how the payment will be split. If split_by is Percentage, then the split amounts must add up to exactly 100. If split_by is Amount, then the last split amount must be nil to capture the remainder.
 */
export type split_by = 'Amount' | 'Percentage';

/**
 * The page that is requested. When unspecified, will load all employees.
 */
export type ParameterpageParam = number;

/**
 * Number of employees per page. When unspecified, will default to 25
 */
export type ParameterperParam = number;

export type GetV1EmployeesData = {
  path: {
    /**
     * The ID or UUID of the employee
     */
    employee_id_or_uuid: string;
  };
  query?: {
    /**
     * Include the requested attribute(s) in each employee response
     */
    include?: Array<'custom_fields'>;
  };
};

export type GetV1EmployeesResponse = Employee;

export type GetV1EmployeesError = unknown;

export type PutV1EmployeesData = {
  /**
   * Update an employee.
   */
  body?: {
    /**
     * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
     */
    version: string;
    first_name?: string;
    middle_initial?: string;
    last_name?: string;
    date_of_birth?: string;
    email?: string;
    ssn?: string;
    /**
     * Whether the employee is a two percent shareholder of the company. This field only applies to companies with an S-Corp entity type.
     */
    two_percent_shareholder?: boolean;
  };
  path: {
    /**
     * The ID or UUID of the employee
     */
    employee_id_or_uuid: string;
  };
};

export type PutV1EmployeesResponse = Employee;

export type PutV1EmployeesError = unknown;

export type DeleteV1EmployeeData = {
  path: {
    /**
     * The ID or UUID of the employee
     */
    employee_id_or_uuid: string;
  };
};

export type DeleteV1EmployeeResponse = any;

export type DeleteV1EmployeeError = unknown;

export type PutV1EmployeeFinishOnboardingData = {
  path: {
    /**
     * The ID or UUID of the employee
     */
    employee_id_or_uuid: string;
  };
};

export type PutV1EmployeeFinishOnboardingResponse = Employee;

export type PutV1EmployeeFinishOnboardingError = unknown;

export type GetV1CompaniesData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
};

export type GetV1CompaniesResponse = Company;

export type GetV1CompaniesError = unknown;

export type GetV1CompanyOnboardingStatusData = {
  path: {
    /**
     * The UUID of the company
     */
    company_uuid: string;
  };
};

export type GetV1CompanyOnboardingStatusResponse = Company_Onboarding_Status;

export type GetV1CompanyOnboardingStatusError = unknown;

export type GetV1CompanyFinishOnboardingData = {
  path: {
    /**
     * The UUID of the company
     */
    company_uuid: string;
  };
};

export type GetV1CompanyFinishOnboardingResponse = Company_Onboarding_Status;

export type GetV1CompanyFinishOnboardingError = unknown;

export type GetV1CompaniesCompanyIdEmployeesData = {
  body?: {
    [key: string]: unknown;
  };
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
  query?: {
    /**
     * Include the requested attribute(s) in each employee response
     */
    include?: Array<'custom_fields'>;
    /**
     * The page that is requested. When unspecified, will load all employees.
     */
    page?: number;
    /**
     * Number of employees per page. When unspecified, will default to 25
     */
    per?: number;
    /**
     * Filters employees by the provided boolean
     */
    terminated?: boolean;
  };
};

export type GetV1CompaniesCompanyIdEmployeesResponse = Array<Employee>;

export type GetV1CompaniesCompanyIdEmployeesError = unknown;

export type PostV1EmployeesData = {
  /**
   * Create an employee.
   */
  body?: {
    first_name?: string;
    middle_initial?: string;
    last_name?: string;
    date_of_birth?: string;
    email?: string;
    ssn?: string;
  };
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
};

export type PostV1EmployeesResponse = Employee;

export type PostV1EmployeesError = unknown;

export type GetV1JobsJobIdData = {
  path: {
    /**
     * The ID or UUID of the job
     */
    job_id_or_uuid: string;
  };
};

export type GetV1JobsJobIdResponse = Job;

export type GetV1JobsJobIdError = unknown;

export type PutV1JobsJobIdData = {
  /**
   * Update a job.
   */
  body?: {
    /**
     * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
     */
    version: string;
    title?: string;
    location_id?: number;
    hire_date?: string;
  };
  path: {
    /**
     * The ID or UUID of the job
     */
    job_id_or_uuid: string;
  };
};

export type PutV1JobsJobIdResponse = Job;

export type PutV1JobsJobIdError = unknown;

export type DeleteV1JobsJobIdData = {
  path: {
    /**
     * The ID or UUID of the job
     */
    job_id_or_uuid: string;
  };
};

export type DeleteV1JobsJobIdResponse = any;

export type DeleteV1JobsJobIdError = unknown;

export type GetV1EmployeesEmployeeIdJobsData = {
  path: {
    /**
     * The employee ID or UUID
     */
    employee_id_or_uuid: string;
  };
  query?: {
    /**
     * The page that is requested. When unspecified, will load all employees.
     */
    page?: number;
    /**
     * Number of employees per page. When unspecified, will default to 25
     */
    per?: number;
  };
};

export type GetV1EmployeesEmployeeIdJobsResponse = Array<Job>;

export type GetV1EmployeesEmployeeIdJobsError = unknown;

export type PostV1JobsJobIdData = {
  /**
   * Create a job.
   */
  body?: {
    title?: string;
    location_id?: number;
    hire_date?: string;
  };
  path: {
    /**
     * The employee ID or UUID
     */
    employee_id_or_uuid: string;
  };
};

export type PostV1JobsJobIdResponse = Job;

export type PostV1JobsJobIdError = unknown;

export type GetV1CompaniesCompanyIdLocationsData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
  query?: {
    /**
     * The page that is requested. When unspecified, will load all employees.
     */
    page?: number;
    /**
     * Number of employees per page. When unspecified, will default to 25
     */
    per?: number;
  };
};

export type GetV1CompaniesCompanyIdLocationsResponse = Array<Location>;

export type GetV1CompaniesCompanyIdLocationsError = unknown;

export type PostV1CompaniesCompanyIdLocationsData = {
  /**
   * Create a company location.
   */
  body?: {
    phone_number: string;
    street_1: string;
    street_2?: string | null;
    city: string;
    state: string;
    zip: string;
    country?: string;
    /**
     * Specify if this location is the company's mailing address.
     */
    mailing_address?: boolean;
    /**
     * Specify if this location is the company's filing address.
     */
    filing_address?: boolean;
  };
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
};

export type PostV1CompaniesCompanyIdLocationsResponse = Location;

export type PostV1CompaniesCompanyIdLocationsError = unknown;

export type GetV1LocationsLocationIdData = {
  path: {
    /**
     * The ID of the location
     */
    location_id: string;
  };
};

export type GetV1LocationsLocationIdResponse = Location;

export type GetV1LocationsLocationIdError = unknown;

export type PutV1LocationsLocationIdData = {
  /**
   * Update a location
   */
  body?: {
    phone_number?: string;
    street_1?: string;
    street_2?: string | null;
    city?: string;
    state?: string;
    zip?: string;
    country?: string;
    /**
     * For a company location, specify if this location is the company's mailing address.
     */
    mailing_address?: boolean;
    /**
     * For a company location, specify if this location is the company's filing address.
     */
    filing_address?: boolean;
  };
  path: {
    /**
     * The ID of the location
     */
    location_id: string;
  };
};

export type PutV1LocationsLocationIdResponse = Location;

export type PutV1LocationsLocationIdError = unknown;

export type GetV1ContractorsContractorIdData = {
  path: {
    /**
     * The ID or UUID of the contractor
     */
    contractor_id_or_uuid: string;
  };
};

export type GetV1ContractorsContractorIdResponse = Contractor;

export type GetV1ContractorsContractorIdError = unknown;

export type PutV1ContractorsContractorIdData = {
  body?: {
    /**
     * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
     */
    version?: string;
    /**
     * The day when the contractor will start working for the company.
     *
     */
    start_date?: string;
    /**
     * The contractor’s first name. This attribute is required for “Individual” contractors and will be ignored for “Business” contractors.
     */
    first_name?: string;
    /**
     * The contractor’s last name. This attribute is required for “Individual” contractors and will be ignored for “Business” contractors.
     */
    last_name?: string;
    /**
     * null	The contractor’s middle initial. This attribute is optional for “Individual” contractors and will be ignored for “Business” contractors.
     */
    middle_initial?: string;
    /**
     * The contractor’s wage type, either “Fixed” or “Hourly”.
     *
     */
    wage_type?: 'Fixed' | 'Hourly';
    /**
     * The contractor’s hourly rate. This attribute is required if the wage_type is “Hourly”.
     */
    hourly_rate?: string;
    /**
     * The name of the contractor business. This attribute is required for “Business” contractors and will be ignored for “Individual” contractors.
     */
    business_name?: string;
    /**
     * The employer identification number of the contractor business. This attribute is optional for “Business” contractors and will be ignored for “Individual” contractors.
     */
    ein?: string;
  };
  path: {
    /**
     * The ID or UUID of the contractor
     */
    contractor_id_or_uuid: string;
  };
};

export type PutV1ContractorsContractorIdResponse = Contractor;

export type PutV1ContractorsContractorIdError = unknown;

export type GetV1CompaniesCompanyIdContractorsData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
  query?: {
    /**
     * The page that is requested. When unspecified, will load all employees.
     */
    page?: number;
    /**
     * Number of employees per page. When unspecified, will default to 25
     */
    per?: number;
  };
};

export type GetV1CompaniesCompanyIdContractorsResponse = Array<Contractor>;

export type GetV1CompaniesCompanyIdContractorsError = unknown;

export type PostV1CompaniesCompanyIdContractorsData = {
  /**
   * Create an individual or business contractor.
   */
  body?: {
    /**
     * The contractor type, either an “Individual” or a “Business”.
     *
     */
    type: 'Individual' | 'Business';
    /**
     * The contractor’s wage type, either “Fixed” or “Hourly”.
     *
     */
    wage_type: 'Hourly' | 'Fixed';
    /**
     * The contractor’s first name. This attribute is required for “Individual” contractors and will be ignored for “Business” contractors.
     */
    first_name?: string;
    /**
     * The contractor’s last_name. This attribute is optional for “Individual” contractors and will be ignored for “Business” contractors.
     */
    last_name?: string;
    /**
     * The day when the contractor will start working for the company.
     */
    start_date: string;
    /**
     * Whether the contractor or the payroll admin will complete onboarding in Gusto. Self-onboarding is recommended so that contractors receive Gusto accounts. If self_onboarding is true, then email is required.
     */
    self_onboarding?: boolean;
    /**
     * The contractor’s email address. This attribute is optional for “Individual” contractors and will be ignored for “Business” contractors.
     */
    email?: string;
    /**
     * The contractor’s middle initial. This attribute is optional for “Individual” contractors and will be ignored for “Business” contractors.
     */
    middle_initial?: string;
    /**
     * The name of the contractor business. This attribute is required for “Business” contractors and will be ignored for “Individual” contractors.
     */
    business_name?: string;
    /**
     * The employer identification number of the contractor business. This attribute is optional for “Business” contractors and will be ignored for “Individual” contractors.
     */
    ein?: string;
  };
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
};

export type PostV1CompaniesCompanyIdContractorsResponse = Contractor;

export type PostV1CompaniesCompanyIdContractorsError = unknown;

export type GetV1CompaniesCompanyIdContractorPaymentsData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
  query: {
    /**
     * The time period for which to retrieve contractor payments
     */
    end_date: string;
    /**
     * The page that is requested. When unspecified, will load all employees.
     */
    page?: number;
    /**
     * Number of employees per page. When unspecified, will default to 25
     */
    per?: number;
    /**
     * The time period for which to retrieve contractor payments
     */
    start_date: string;
  };
};

export type GetV1CompaniesCompanyIdContractorPaymentsResponse = Contractor_Payment_Summary;

export type GetV1CompaniesCompanyIdContractorPaymentsError = unknown;

export type PostV1CompaniesCompanyIdContractorPaymentsData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
  query: {
    /**
     * If the contractor is on an hourly wage, this is the bonus the contractor earned.
     */
    bonus?: number;
    /**
     * The contractor receiving the payment
     */
    contractor_id: number;
    /**
     * The payment date
     */
    date: string;
    /**
     * If the contractor is on an hourly wage, this is the number of hours that the contractor worked for the payment.
     */
    hours?: number;
    /**
     * Reimbursed wages for the contractor .
     */
    reimbursement?: number;
    /**
     * If the contractor is on a fixed wage, this is the fixed wage payment for the contractor, regardless of hours worked.
     */
    wage?: number;
  };
};

export type PostV1CompaniesCompanyIdContractorPaymentsResponse = Contractor_Payment;

export type PostV1CompaniesCompanyIdContractorPaymentsError = unknown;

export type GetV1CompaniesCompanyIdContractorPaymentContractorPaymentData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
    /**
     * The ID or UUID of the contractor payment
     */
    contractor_payment_id_or_uuid: string;
  };
};

export type GetV1CompaniesCompanyIdContractorPaymentContractorPaymentResponse = Contractor_Payment;

export type GetV1CompaniesCompanyIdContractorPaymentContractorPaymentError = unknown;

export type DeleteV1CompaniesCompanyIdContractorPaymentContractorPaymentData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
    /**
     * The ID or UUID of the contractor payment
     */
    contractor_payment_id_or_uuid: string;
  };
};

export type DeleteV1CompaniesCompanyIdContractorPaymentContractorPaymentResponse = any;

export type DeleteV1CompaniesCompanyIdContractorPaymentContractorPaymentError = unknown;

export type GetV1CompensationsCompensationIdData = {
  path: {
    /**
     * The ID or UUID of the compensation
     */
    compensation_id_or_uuid: string;
  };
};

export type GetV1CompensationsCompensationIdResponse = Compensation;

export type GetV1CompensationsCompensationIdError = unknown;

export type PutV1CompensationsCompensationIdData = {
  body?: {
    /**
     * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
     */
    readonly version: string;
    /**
     * The dollar amount paid per payment unit.
     */
    rate?: string;
    /**
     * The unit accompanying the compensation rate. If the employee is an owner, rate should be 'Paycheck'.
     */
    payment_unit?: 'Hour' | 'Week' | 'Month' | 'Year' | 'Paycheck';
    /**
     * The FLSA status for this compensation. Salaried ('Exempt') employees are paid a fixed salary every pay period. Salaried with overtime ('Salaried Nonexempt') employees are paid a fixed salary every pay period, and receive overtime pay when applicable. Hourly ('Nonexempt') employees are paid for the hours they work, and receive overtime pay when applicable. Owners ('Owner') are employees that own at least twenty percent of the company.
     */
    flsa_status?: 'Exempt' | 'Salaried Nonexempt' | 'Nonexempt' | 'Owner';
  };
  path: {
    /**
     * The ID or UUID of the compensation
     */
    compensation_id_or_uuid: string;
  };
};

export type PutV1CompensationsCompensationIdResponse = Compensation;

export type PutV1CompensationsCompensationIdError = unknown;

export type GetV1JobsJobIdCompensationsData = {
  path: {
    /**
     * The ID or UUID of the job to which the compensation belongs
     */
    job_id_or_uuid: string;
  };
  query?: {
    /**
     * The page that is requested. When unspecified, will load all employees.
     */
    page?: number;
    /**
     * Number of employees per page. When unspecified, will default to 25
     */
    per?: number;
  };
};

export type GetV1JobsJobIdCompensationsResponse = Array<Compensation>;

export type GetV1JobsJobIdCompensationsError = unknown;

export type PostV1JobsJobIdCompensationsData = {
  body?: {
    /**
     * The dollar amount paid per payment unit.
     */
    rate: string;
    /**
     * The unit accompanying the compensation rate. If the employee is an owner, rate should be 'Paycheck'.
     */
    payment_unit: 'Hour' | 'Week' | 'Month' | 'Year' | 'Paycheck';
    /**
     * The FLSA status for this compensation. Salaried ('Exempt') employees are paid a fixed salary every pay period. Salaried with overtime ('Salaried Nonexempt') employees are paid a fixed salary every pay period, and receive overtime pay when applicable. Hourly ('Nonexempt') employees are paid for the hours they work, and receive overtime pay when applicable. Owners ('Owner') are employees that own at least twenty percent of the company.
     */
    flsa_status: 'Exempt' | 'Salaried Nonexempt' | 'Nonexempt' | 'Owner';
    /**
     * The effective date for this compensation. For the first compensation, this defaults to the job's hire date.
     */
    effective_date?: string;
  };
  path: {
    /**
     * The ID or UUID of the job to which the compensation belongs
     */
    job_id_or_uuid: string;
  };
};

export type PostV1JobsJobIdCompensationsResponse = Compensation;

export type PostV1JobsJobIdCompensationsError = unknown;

export type GetV1EmployeesEmployeeIdGarnishmentsData = {
  path: {
    /**
     * The ID or UUID of the employee to which the garnishment belongs
     */
    employee_id_or_uuid: string;
  };
  query?: {
    /**
     * The page that is requested. When unspecified, will load all employees.
     */
    page?: number;
    /**
     * Number of employees per page. When unspecified, will default to 25
     */
    per?: number;
  };
};

export type GetV1EmployeesEmployeeIdGarnishmentsResponse = Array<Garnishment>;

export type GetV1EmployeesEmployeeIdGarnishmentsError = unknown;

export type PostV1EmployeesEmployeeIdGarnishmentsData = {
  body?: {
    /**
     * Whether or not this garnishment is currently active.
     */
    active?: boolean;
    /**
     * The amount of the garnishment. Either a percentage or a fixed dollar amount. Represented as a float, e.g. "8.00".
     */
    amount: string;
    /**
     * The description of the garnishment.
     */
    description: string;
    /**
     * Whether the garnishment is court ordered.
     */
    court_ordered: boolean;
    /**
     * The number of times to apply the garnisment. Ignored if recurring is true.
     */
    times?: number | null;
    /**
     * Whether the garnishment should recur indefinitely.
     */
    recurring?: boolean;
    /**
     * The maximum deduction per annum. A null value indicates no maximum. Represented as a float, e.g. "200.00".
     */
    annual_maximum?: string | null;
    /**
     * The maximum deduction per pay period. A null value indicates no maximum. Represented as a float, e.g. "16.00".
     */
    pay_period_maximum?: string | null;
    /**
     * Whether the amount should be treated as a percentage to be deducted per pay period.
     */
    deduct_as_percentage?: boolean;
  };
  path: {
    /**
     * The ID or UUID of the employee to which the garnishment belongs
     */
    employee_id_or_uuid: string;
  };
};

export type PostV1EmployeesEmployeeIdGarnishmentsResponse = Garnishment;

export type PostV1EmployeesEmployeeIdGarnishmentsError = unknown;

export type GetV1GarnishmentsGarnishmentIdData = {
  path: {
    /**
     * The ID or UUID of the garnishment
     */
    garnishment_id_or_uuid: string;
  };
};

export type GetV1GarnishmentsGarnishmentIdResponse = Garnishment;

export type GetV1GarnishmentsGarnishmentIdError = unknown;

export type PutV1GarnishmentsGarnishmentIdData = {
  body?: {
    /**
     * Whether or not this garnishment is currently active.
     */
    active?: boolean;
    /**
     * The amount of the garnishment. Either a percentage or a fixed dollar amount. Represented as a float, e.g. "8.00".
     */
    amount?: string;
    /**
     * The description of the garnishment.
     */
    description?: string;
    /**
     * Whether the garnishment is court ordered.
     */
    court_ordered?: boolean;
    /**
     * The number of times to apply the garnisment. Ignored if recurring is true.
     */
    times?: number | null;
    /**
     * Whether the garnishment should recur indefinitely.
     */
    recurring?: boolean;
    /**
     * The maximum deduction per annum. A null value indicates no maximum. Represented as a float, e.g. "200.00".
     */
    annual_maximum?: string | null;
    /**
     * The maximum deduction per pay period. A null value indicates no maximum. Represented as a float, e.g. "16.00".
     */
    pay_period_maximum?: string | null;
    /**
     * Whether the amount should be treated as a percentage to be deducted per pay period.
     */
    deduct_as_percentage?: boolean;
    /**
     * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
     */
    version: string;
  };
  path: {
    /**
     * The ID or UUID of the garnishment
     */
    garnishment_id_or_uuid: string;
  };
};

export type PutV1GarnishmentsGarnishmentIdResponse = Garnishment;

export type PutV1GarnishmentsGarnishmentIdError = unknown;

export type GetV1EmployeesEmployeeIdTerminationsData = {
  path: {
    /**
     * The ID or UUID of the employee
     */
    employee_id_or_uuid: string;
  };
};

export type GetV1EmployeesEmployeeIdTerminationsResponse = Array<Termination>;

export type GetV1EmployeesEmployeeIdTerminationsError = unknown;

export type PostV1EmployeesEmployeeIdTerminationsData = {
  body?: {
    /**
     * The employee's last day of work.
     */
    effective_date?: string;
    /**
     * If true, the employee should recieve their final wages via an offcycle payroll. If false, they should recieve their final wages on their current pay schedule.
     */
    run_termination_payroll?: boolean;
  };
  path: {
    /**
     * The ID or UUID of the employee
     */
    employee_id_or_uuid: string;
  };
};

export type PostV1EmployeesEmployeeIdTerminationsResponse = Termination;

export type PostV1EmployeesEmployeeIdTerminationsError = unknown;

export type GetV1CompaniesCompanyIdTimeOffRequestsData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
  query?: {
    /**
     * Filter time off requests where the request end date is equal to or after this parameter
     */
    end_date?: string;
    /**
     * The page that is requested. When unspecified, will load all employees.
     */
    page?: number;
    /**
     * Number of employees per page. When unspecified, will default to 25
     */
    per?: number;
    /**
     * Filter time off requests where the request start date is equal to or after this parameter
     */
    start_date?: string;
  };
};

export type GetV1CompaniesCompanyIdTimeOffRequestsResponse = Array<Time_Off_Request>;

export type GetV1CompaniesCompanyIdTimeOffRequestsError = unknown;

export type GetV1MeResponse = Current_User;

export type GetV1MeError = unknown;

export type GetV1TermsOfServiceResponse = {
  /**
   * Whether the latest terms have been accepted by the user.
   */
  latest_terms_accepted?: boolean;
};

export type GetV1TermsOfServiceError = unknown;

export type PostV1TermsOfServiceResponse = {
  /**
   * Whether the latest terms have been accepted by the user.
   */
  latest_terms_accepted?: boolean;
};

export type PostV1TermsOfServiceError = unknown;

export type GetV1EmployeesEmployeeIdFederalTaxesData = {
  path: {
    /**
     * The UUID of the employee
     */
    employee_uuid: string;
  };
};

export type GetV1EmployeesEmployeeIdFederalTaxesResponse = Employee_Federal_Tax;

export type GetV1EmployeesEmployeeIdFederalTaxesError = unknown;

export type PutV1EmployeesEmployeeIdFederalTaxesData = {
  body?: {
    /**
     * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
     */
    version: string;
    filing_status?: string;
    extra_withholding?: string | null;
    two_jobs?: boolean;
    dependents_amount?: string;
    other_income?: string;
    deductions?: string;
    w4_data_type?: string;
  };
  path: {
    /**
     * The UUID of the employee
     */
    employee_uuid: string;
  };
};

export type PutV1EmployeesEmployeeIdFederalTaxesResponse = Employee_Federal_Tax;

export type PutV1EmployeesEmployeeIdFederalTaxesError = unknown;

export type GetV1EmployeesEmployeeIdStateTaxesData = {
  path: {
    /**
     * The UUID of the employee
     */
    employee_uuid: string;
  };
};

export type GetV1EmployeesEmployeeIdStateTaxesResponse = Array<Employee_State_Tax>;

export type GetV1EmployeesEmployeeIdStateTaxesError = unknown;

export type PutV1EmployeesEmployeeIdStateTaxesData = {
  body?: {
    employee_id: string;
    states: Array<{
      state: string;
      questions?: Array<{
        key: string;
        answers?: Array<{
          value: string;
          valid_from: string;
          valid_up_to?: unknown;
        }>;
      }>;
    }>;
  };
  path: {
    /**
     * The UUID of the employee
     */
    employee_uuid: string;
  };
};

export type PutV1EmployeesEmployeeIdStateTaxesResponse = Array<Employee_State_Tax>;

export type PutV1EmployeesEmployeeIdStateTaxesError = Array<{
  state: string;
  questions: Array<{
    key: string;
    answers?: Array<{
      valid_from: string;
      valid_up_to?: unknown;
      errors?: Array<string>;
    }>;
  }>;
}>;

export type GetV1EmployeesEmployeeIdHomeAddressData = {
  path: {
    /**
     * The ID or UUID of the employee
     */
    employee_id_or_uuid: string;
  };
};

export type GetV1EmployeesEmployeeIdHomeAddressResponse = Location;

export type GetV1EmployeesEmployeeIdHomeAddressError = unknown;

export type PutV1EmployeesEmployeeIdHomeAddressData = {
  body?: {
    /**
     * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
     */
    version: string;
    street_1?: string;
    street_2?: string | null;
    city?: string;
    state?: string;
    zip?: string;
  };
  path: {
    /**
     * The ID or UUID of the employee
     */
    employee_id_or_uuid: string;
  };
};

export type PutV1EmployeesEmployeeIdHomeAddressResponse = Location;

export type PutV1EmployeesEmployeeIdHomeAddressError = unknown;

export type GetV1CompanyPaymentConfigsData = {
  path: {
    /**
     * The UUID of the company
     */
    company_uuid: string;
  };
};

export type GetV1CompanyPaymentConfigsResponse = Payment_Configs;

export type GetV1CompanyPaymentConfigsError = unknown;

export type PutV1CompanyPaymentConfigsData = {
  body?: {
    /**
     * Fast payment limit (only applicable to 2-day payroll). This limit is an aggregate of all fast payrolls amount.
     */
    fast_payment_limit: number;
    /**
     * The payment speed
     */
    payment_speed: '2-day' | '4-day';
  };
  path: {
    /**
     * The UUID of the company
     */
    company_uuid: string;
  };
};

export type PutV1CompanyPaymentConfigsResponse = Payment_Configs;

export type PutV1CompanyPaymentConfigsError = unknown;

export type GetV1CompaniesCompanyIdPaySchedulesData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
  query?: {
    /**
     * The page that is requested. When unspecified, will load all employees.
     */
    page?: number;
    /**
     * Number of employees per page. When unspecified, will default to 25
     */
    per?: number;
  };
};

export type GetV1CompaniesCompanyIdPaySchedulesResponse = Array<Pay_Schedule>;

export type GetV1CompaniesCompanyIdPaySchedulesError = unknown;

export type PostV1CompaniesCompanyIdPaySchedulesData = {
  body?: {
    /**
     * The frequency that employees on this pay schedule are paid with Gusto.
     */
    frequency: 'Every week' | 'Every other week' | 'Twice per month' | 'Monthly';
    /**
     * The first date that employees on this pay schedule are paid with Gusto.
     */
    anchor_pay_date: string;
    /**
     * The last date of the first pay period. This can be the same date as the anchor pay date.
     */
    anchor_end_of_pay_period: string;
    /**
     * An integer between 1 and 31 indicating the first day of the month that employees are paid. This field is only relevant for pay schedules with the “Twice per month” and “Monthly” frequencies. It will be null for pay schedules with other frequencies.
     */
    day_1?: number | null;
    /**
     * An integer between 1 and 31 indicating the second day of the month that employees are paid. This field is the second pay date for pay schedules with the “Twice per month” frequency. It will be null for pay schedules with other frequencies.
     */
    day_2?: number | null;
  };
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
};

export type PostV1CompaniesCompanyIdPaySchedulesResponse = Pay_Schedule;

export type PostV1CompaniesCompanyIdPaySchedulesError = unknown;

export type GetV1CompanyIndustryData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
};

export type GetV1CompanyIndustryResponse = Industry;

export type GetV1CompanyIndustryError = unknown;

export type PutV1CompanyIndustryData = {
  body?: {
    /**
     * Industry title
     */
    title: string;
    /**
     * North American Industry Classification System (NAICS) is used to classify businesses with a six digit number based on the primary type of work the business performs
     */
    naics_code: string;
    /**
     * A list of Standard Industrial Classification (SIC) codes, which are four digit number that categorize the industries that companies belong to based on their business activities.
     */
    sic_codes: Array<string>;
  };
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
};

export type PutV1CompanyIndustryResponse = Industry;

export type PutV1CompanyIndustryError = unknown;

export type GetV1CompaniesCompanyIdPaySchedulesPayScheduleIdData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
    /**
     * The ID or UUID of the pay schedule
     */
    pay_schedule_id_or_uuid: string;
  };
};

export type GetV1CompaniesCompanyIdPaySchedulesPayScheduleIdResponse = Pay_Schedule;

export type GetV1CompaniesCompanyIdPaySchedulesPayScheduleIdError = unknown;

export type PutV1CompaniesCompanyIdPaySchedulesPayScheduleIdData = {
  body?: {
    /**
     * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
     */
    version: string;
    /**
     * With Autopilot® enabled, payroll will run automatically one day before your payroll deadlines.
     */
    auto_pilot?: boolean;
  };
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
    /**
     * The ID or UUID of the pay schedule
     */
    pay_schedule_id_or_uuid: string;
  };
};

export type PutV1CompaniesCompanyIdPaySchedulesPayScheduleIdResponse = Pay_Schedule;

export type PutV1CompaniesCompanyIdPaySchedulesPayScheduleIdError = unknown;

export type GetV1CompaniesCompanyIdBankAccountsData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
  query?: {
    /**
     * The page that is requested. When unspecified, will load all employees.
     */
    page?: number;
    /**
     * Number of employees per page. When unspecified, will default to 25
     */
    per?: number;
  };
};

export type GetV1CompaniesCompanyIdBankAccountsResponse = Array<Company_Bank_Account>;

export type GetV1CompaniesCompanyIdBankAccountsError = unknown;

export type PostV1CompaniesCompanyIdBankAccountsData = {
  body?: {
    /**
     * The bank routing number
     */
    routing_number?: string;
    /**
     * The bank account number
     */
    account_number?: string;
    /**
     * The bank account type
     */
    account_type?: 'Checking' | 'Savings';
  };
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
};

export type PostV1CompaniesCompanyIdBankAccountsResponse = Company_Bank_Account;

export type PostV1CompaniesCompanyIdBankAccountsError = unknown;

export type PutV1CompaniesCompanyIdBankAccountsVerifyData = {
  body?: {
    /**
     * The dollar amount of the first micro-deposit
     */
    deposit_1?: number;
    /**
     * The dollar amount of the second micro-deposit
     */
    deposit_2?: number;
  };
  path: {
    /**
     * Bank account UUID
     */
    bank_account_uuid: string;
    /**
     * The ID or UUID of the bank account
     */
    company_id_or_uuid: string;
  };
};

export type PutV1CompaniesCompanyIdBankAccountsVerifyResponse = Company_Bank_Account;

export type PutV1CompaniesCompanyIdBankAccountsVerifyError = unknown;

export type GetV1BenefitsResponse = Array<Supported_Benefit>;

export type GetV1BenefitsError = unknown;

export type GetV1BenefitsBenefitIdData = {
  path: {
    /**
     * The ID of the benefit
     */
    benefit_id: string;
  };
};

export type GetV1BenefitsBenefitIdResponse = Supported_Benefit;

export type GetV1BenefitsBenefitIdError = unknown;

export type GetV1CompaniesCompanyIdCompanyBenefitsData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
};

export type GetV1CompaniesCompanyIdCompanyBenefitsResponse = Array<Company_Benefit>;

export type GetV1CompaniesCompanyIdCompanyBenefitsError = unknown;

export type PostV1CompaniesCompanyIdCompanyBenefitsData = {
  body?: {
    /**
     * The ID of the benefit to which the company benefit belongs.
     */
    benefit_id: number;
    /**
     * Whether this benefit is active for employee participation.
     */
    active?: boolean;
    /**
     * The description of the company benefit.For example, a company may offer multiple benefits with an ID of 1 (for Medical Insurance). The description would show something more specific like “Kaiser Permanente” or “Blue Cross/ Blue Shield”.
     */
    description: string;
    /**
     * Whether the employer is subject to pay employer taxes when an employee is on leave. Only applicable to third party sick pay benefits.
     */
    responsible_for_employer_taxes?: boolean;
    /**
     * Whether the employer is subject to file W-2 forms for an employee on leave. Only applicable to third party sick pay benefits.
     */
    responsible_for_employee_w2?: boolean;
  };
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
};

export type PostV1CompaniesCompanyIdCompanyBenefitsResponse = Company_Benefit;

export type PostV1CompaniesCompanyIdCompanyBenefitsError = unknown;

export type GetV1CompanyBenefitsCompanyBenefitIdData = {
  path: {
    /**
     * The ID of the company benefit
     */
    company_benefit_id: string;
  };
};

export type GetV1CompanyBenefitsCompanyBenefitIdResponse = Company_Benefit;

export type GetV1CompanyBenefitsCompanyBenefitIdError = unknown;

export type PutV1CompanyBenefitsCompanyBenefitIdData = {
  body?: {
    /**
     * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
     */
    readonly version: string;
    /**
     * Whether this benefit is active for employee participation. Company benefits may only be deactivated if no employees are actively participating.
     */
    active?: boolean;
    /**
     * The description of the company benefit.For example, a company may offer multiple benefits with an ID of 1 (for Medical Insurance). The description would show something more specific like “Kaiser Permanente” or “Blue Cross/ Blue Shield”.
     */
    description?: string;
  };
  path: {
    /**
     * The ID of the company benefit
     */
    company_benefit_id: string;
  };
};

export type PutV1CompanyBenefitsCompanyBenefitIdResponse = Company_Benefit;

export type PutV1CompanyBenefitsCompanyBenefitIdError = unknown;

export type GetV1CompaniesCompanyIdEarningTypesData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
};

export type GetV1CompaniesCompanyIdEarningTypesResponse = {
  /**
   * The default earning types for the company.
   */
  default?: Array<Earning_Type>;
  /**
   * The custom earning types for the company.
   */
  custom?: Array<Earning_Type>;
};

export type GetV1CompaniesCompanyIdEarningTypesError = unknown;

export type PostV1CompaniesCompanyIdEarningTypesData = {
  body?: {
    /**
     * The name of the custom earning type.
     */
    name: string;
  };
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
};

export type PostV1CompaniesCompanyIdEarningTypesResponse = Earning_Type;

export type PostV1CompaniesCompanyIdEarningTypesError = unknown;

export type PutV1CompaniesCompanyIdEarningTypesEarningTypeUuidData = {
  body?: {
    /**
     * The name of the custom earning type.
     */
    name?: string;
  };
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
    /**
     * The UUID of the earning type
     */
    earning_type_uuid: string;
  };
};

export type PutV1CompaniesCompanyIdEarningTypesEarningTypeUuidResponse = Earning_Type;

export type PutV1CompaniesCompanyIdEarningTypesEarningTypeUuidError = unknown;

export type DeleteV1CompaniesCompanyIdEarningTypesEarningTypeUuidData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
    /**
     * The UUID of the earning type
     */
    earning_type_uuid: string;
  };
};

export type DeleteV1CompaniesCompanyIdEarningTypesEarningTypeUuidResponse = any;

export type DeleteV1CompaniesCompanyIdEarningTypesEarningTypeUuidError = unknown;

export type GetV1EmployeesEmployeeIdEmployeeBenefitsData = {
  path: {
    /**
     * The ID or UUID of the employee
     */
    employee_id_or_uuid: string;
  };
  query?: {
    /**
     * The page that is requested. When unspecified, will load all employees.
     */
    page?: number;
    /**
     * Number of employees per page. When unspecified, will default to 25
     */
    per?: number;
  };
};

export type GetV1EmployeesEmployeeIdEmployeeBenefitsResponse = Array<Employee_Benefit>;

export type GetV1EmployeesEmployeeIdEmployeeBenefitsError = unknown;

export type PostV1EmployeesEmployeeIdEmployeeBenefitsData = {
  body?: {
    /**
     * The ID of the company to which the benefit belongs.
     */
    readonly company_benefit_id: number;
    /**
     * Whether the employee benefit is active.
     */
    active?: boolean;
    /**
     * The amount to be deducted, per pay period, from the employee's pay.
     */
    employee_deduction?: string;
    /**
     * Whether the employee deduction amount should be treated as a percentage to be deducted from each payroll.
     */
    deduct_as_percentage?: boolean;
    /**
     * The maximum employee deduction amount per year. A null value signifies no limit.
     */
    employee_deduction_annual_maximum?: string | null;
    /**
     * An object representing the company contribution type and value.
     */
    contribution?: {
      /**
       * The company contribution scheme.
       *
       * `amount`: The company contributes a fixed amount per payroll. If elective is true, the contribution is matching, dollar-for-dollar.
       *
       * `percentage`: The company contributes a percentage of the payroll amount per payroll period. If elective is true, the contribution is matching, dollar-for-dollar.
       *
       * `tiered`: The size of the company contribution corresponds to the size of the employee deduction relative to a tiered matching scheme.
       */
      type?: 'tiered' | 'percentage' | 'amount';
      /**
       * For the `amount` and `percentage` contribution types, the value of the corresponding amount or percentage.
       *
       * For the `tiered` contribution type, an array of tiers.
       */
      value?:
        | string
        | Array<{
            /**
             * The percentage of employee deduction within this tier the company contribution will match.
             */
            rate?: string;
            /**
             * The percentage threshold at which this tier ends (inclusive).
             *
             * For example, a value of "5" means the company contribution will match employee deductions from the previous tier's threshold up to and including 5% of payroll.
             *
             * If this is the first tier, a value of "5" means the company contribution will match employee deductions from 0% up to and including 5% of payroll.
             */
            threshold?: string;
          }>;
    };
    /**
     * Whether the company contribution is elective (aka "matching"). For `tiered`, `elective_amount`, and `elective_percentage` contribution types this is ignored and assumed to be `true`.
     */
    elective?: boolean;
    /**
     * The maximum company contribution amount per year. A null value signifies no limit.
     */
    company_contribution_annual_maximum?: string | null;
    /**
     * Some benefits require additional information to determine their limit. For example, for an HSA benefit, the limit option should be either "Family" or "Individual". For a Dependent Care FSA benefit, the limit option should be either "Joint Filing or Single" or "Married and Filing Separately".
     */
    limit_option?: string | null;
    /**
     * Whether the employee should use a benefit’s "catch up" rate. Only Roth 401k and 401k benefits use this value for employees over 50.
     */
    catch_up?: boolean;
    /**
     * The amount that the employee is insured for. Note: company contribution cannot be present if coverage amount is set.
     */
    coverage_amount?: string | null;
    /**
     * The coverage amount as a multiple of the employee’s salary. Only applicable for Group Term Life benefits. Note: cannot be set if coverage amount is also set.
     */
    coverage_salary_multiplier?: string;
    /**
     * Whether the employee deduction reduces taxable income or not. Only valid for Group Term Life benefits. Note: when the value is not "unset", coverage amount and coverage salary multiplier are ignored.
     */
    deduction_reduces_taxable_income?: ('unset' | 'reduces_taxable_income' | 'does_not_reduce_taxable_income') | null;
    /**
     * The amount to be paid, per pay period, by the company.
     * @deprecated
     */
    company_contribution?: string;
    /**
     * Whether the company contribution amount should be treated as a percentage to be deducted from each payroll.
     * @deprecated
     */
    contribute_as_percentage?: boolean;
  };
  path: {
    /**
     * The ID or UUID of the employee
     */
    employee_id_or_uuid: string;
  };
};

export type PostV1EmployeesEmployeeIdEmployeeBenefitsResponse = Employee_Benefit;

export type PostV1EmployeesEmployeeIdEmployeeBenefitsError = unknown;

export type PostEmployeeYtdBenefitAmountsFromDifferentCompanyData = {
  body?: {
    /**
     * The id for the benefit got from the benefits api.
     */
    benefit_id: number;
    /**
     * The tax year for which this amount applies.
     */
    tax_year: number;
    /**
     * The year-to-date employee deduction made outside the current company.
     */
    ytd_employee_deduction_amount: string;
    /**
     * The year-to-date company contribution made outside the current company.
     */
    ytd_company_contribution_amount: string;
  };
  path: {
    /**
     * The ID or UUID of the employee
     */
    employee_id_or_uuid: string;
  };
};

export type PostEmployeeYtdBenefitAmountsFromDifferentCompanyResponse = any;

export type PostEmployeeYtdBenefitAmountsFromDifferentCompanyError = unknown;

export type GetV1EmployeeBenefitsEmployeeBenefitIdData = {
  path: {
    /**
     * The ID of the employee benefit
     */
    employee_benefit_id: string;
  };
};

export type GetV1EmployeeBenefitsEmployeeBenefitIdResponse = Employee_Benefit;

export type GetV1EmployeeBenefitsEmployeeBenefitIdError = unknown;

export type PutV1EmployeeBenefitsEmployeeBenefitIdData = {
  body?: {
    /**
     * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
     */
    readonly version: string;
    /**
     * Whether the employee benefit is active.
     */
    active?: boolean;
    /**
     * The amount to be deducted, per pay period, from the employee's pay.
     */
    employee_deduction?: string;
    /**
     * Whether the employee deduction amount should be treated as a percentage to be deducted from each payroll.
     */
    deduct_as_percentage?: boolean;
    /**
     * The maximum employee deduction amount per year. A null value signifies no limit.
     */
    employee_deduction_annual_maximum?: string | null;
    /**
     * An object representing the type and value of the company contribution.
     */
    contribution?: {
      /**
       * The company contribution scheme.
       *
       * `amount`: The company contributes a fixed amount per payroll. If elective is true, the contribution is matching, dollar-for-dollar.
       *
       * `percentage`: The company contributes a percentage of the payroll amount per payroll period. If elective is true, the contribution is matching, dollar-for-dollar.
       *
       * `tiered`: The size of the company contribution corresponds to the size of the employee deduction relative to a tiered matching scheme.
       */
      type?: 'amount' | 'percentage' | 'tiered';
      /**
       * For the `amount` and `percentage` contribution types, the value of the corresponding amount or percentage.
       *
       * For the `tiered` contribution type, an array of tiers.
       */
      value?:
        | string
        | Array<{
            /**
             * The percentage of employee deduction within this tier the company contribution will match.
             */
            rate?: string;
            /**
             * The percentage threshold at which this tier ends (inclusive).
             *
             * For example, a value of "5" means the company contribution will match employee deductions from the previous tier's threshold up to and including 5% of payroll.
             *
             * If this is the first tier, a value of "5" means the company contribution will match employee deductions from 0% up to and including 5% of payroll.
             */
            threshold?: string;
          }>;
    };
    /**
     * Whether the company contribution is elective (aka "matching"). For `tiered`, `elective_amount`, and `elective_percentage` contribution types this is ignored and assumed to be `true`.
     */
    elective?: boolean;
    /**
     * The maximum company contribution amount per year. A null value signifies no limit.
     */
    company_contribution_annual_maximum?: string | null;
    /**
     * Some benefits require additional information to determine their limit. For example, for an HSA benefit, the limit option should be either "Family" or "Individual". For a Dependent Care FSA benefit, the limit option should be either "Joint Filing or Single" or "Married and Filing Separately".
     */
    limit_option?: string | null;
    /**
     * Whether the employee should use a benefit’s "catch up" rate. Only Roth 401k and 401k benefits use this value for employees over 50.
     */
    catch_up?: boolean;
    /**
     * The amount that the employee is insured for. Note: company contribution cannot be present if coverage amount is set.
     */
    coverage_amount?: string | null;
    /**
     * Whether the employee deduction reduces taxable income or not. Only valid for Group Term Life benefits. Note: when the value is not "unset", coverage amount and coverage salary multiplier are ignored.
     */
    deduction_reduces_taxable_income?: ('unset' | 'reduces_taxable_income' | 'does_not_reduce_taxable_income') | null;
    /**
     * The coverage amount as a multiple of the employee’s salary. Only applicable for Group Term Life benefits. Note: cannot be set if coverage amount is also set.
     */
    coverage_salary_multiplier?: string;
    /**
     * The amount to be paid, per pay period, by the company.
     * @deprecated
     */
    company_contribution?: string;
    /**
     * Whether the company contribution amount should be treated as a percentage to be deducted from each payroll.
     * @deprecated
     */
    contribute_as_percentage?: boolean;
  };
  path: {
    /**
     * The ID of the employee benefit
     */
    employee_benefit_id: string;
  };
};

export type PutV1EmployeeBenefitsEmployeeBenefitIdResponse = Employee_Benefit;

export type PutV1EmployeeBenefitsEmployeeBenefitIdError = unknown;

export type DeleteV1EmployeeBenefitsEmployeeBenefitIdData = {
  path: {
    /**
     * The ID of the employee benefit
     */
    employee_benefit_id: string;
  };
};

export type DeleteV1EmployeeBenefitsEmployeeBenefitIdResponse = any;

export type DeleteV1EmployeeBenefitsEmployeeBenefitIdError = unknown;

export type GetV1CompaniesCompanyIdPayPeriodsData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
  query?: {
    end_date?: string;
    start_date?: string;
  };
};

export type GetV1CompaniesCompanyIdPayPeriodsResponse = Array<Pay_Period>;

export type GetV1CompaniesCompanyIdPayPeriodsError = unknown;

export type GetV1CompaniesCompanyIdPayrollsData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
  query?: {
    /**
     * Return payrolls whose pay period is before the end date
     */
    end_date?: string;
    /**
     * Include the requested attribute in the employee_compensations attribute in the response
     */
    include?: Array<'benefits' | 'deductions' | 'taxes'>;
    /**
     * Whether to include off cycle payrolls in the response
     */
    include_off_cycle?: boolean;
    /**
     * Whether to return processed or unprocessed payrolls
     */
    processed?: boolean;
    /**
     * Return payrolls whose pay period is after the start date
     */
    start_date?: string;
  };
};

export type GetV1CompaniesCompanyIdPayrollsResponse = Array<Payroll>;

export type GetV1CompaniesCompanyIdPayrollsError = unknown;

export type PostV1CompaniesCompanyIdPayrollsData = {
  body?: {
    off_cycle: string;
    off_cycle_reason?: 'Bonus' | 'Correction';
    start_date?: string;
    end_date?: string;
    employee_ids?: Array<number>;
    check_date?: string;
  };
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
};

export type PostV1CompaniesCompanyIdPayrollsResponse = Payroll;

export type PostV1CompaniesCompanyIdPayrollsError = unknown;

export type PutV1CompaniesCompanyIdPayrollsData = {
  body?: {
    /**
     * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for details using this field.
     */
    version: string;
    employee_compensations: Array<{
      /**
       * The ID of the employee. Required unless using employee_uuid.
       */
      employee_id?: number;
      /**
       * The UUID of the employee. Required unless using employee_id.
       */
      employee_uuid?: string;
      /**
       * This employee will be excluded from payroll calculation and will not be paid for the payroll.
       */
      excluded?: boolean;
      fixed_compensations?: Array<{
        /**
         * The name of the compensation. This also serves as the unique, immutable identifier for this compensation.
         */
        name?: string;
        /**
         * The amount of the compensation for the pay period.
         */
        amount?: string;
        /**
         * The ID of the job for the compensation.
         */
        job_id?: number;
      }>;
      hourly_compensations?: Array<{
        /**
         * The name of the compensation. This also serves as the unique, immutable identifier for this compensation.
         */
        name?: string;
        /**
         * The number of hours to be compensated for this pay period.
         */
        hours?: string;
        /**
         * The ID of the job for the compensation.
         */
        job_id?: number;
      }>;
      /**
       * An array of all paid time off the employee is eligible for this pay period.
       */
      paid_time_off?: Array<{
        /**
         * The name of the PTO. This also serves as the unique, immutable identifier for the PTO.
         */
        name?: string;
        /**
         * The hours of this PTO taken during the pay period.
         */
        hours?: string;
      }>;
    }>;
  };
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
    /**
     * The ID or UUID of the payroll
     */
    payroll_id_or_uuid: string;
  };
};

export type PutV1CompaniesCompanyIdPayrollsResponse = Payroll;

export type PutV1CompaniesCompanyIdPayrollsError = unknown;

export type GetV1CompaniesCompanyIdPayrollsPayrollIdData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
    /**
     * The ID or UUID of the payroll
     */
    payroll_id_or_uuid: string;
  };
  query?: {
    /**
     * Include the requested attribute in the employee_compensations attribute in the response
     */
    include?: 'benefits' | 'deductions' | 'taxes';
    /**
     * with `include`, shows the tax, and/or benefit, and/or deduction details for a calculated, unprocessed payroll.
     */
    show_calculation?: string;
  };
};

export type GetV1CompaniesCompanyIdPayrollsPayrollIdResponse = Payroll;

export type GetV1CompaniesCompanyIdPayrollsPayrollIdError = unknown;

export type PutV1CompaniesCompanyIdPayrollsPayPeriodStartDatePayPeriodEndDateData = {
  body?: {
    /**
     * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for details using this field.
     */
    version: string;
    employee_compensations: Array<{
      /**
       * The ID of the employee. Required unless using employee_uuid.
       */
      employee_id?: number;
      /**
       * The UUID of the employee. Required unless using employee_id.
       */
      employee_uuid?: string;
      /**
       * This employee will be excluded from payroll calculation and will not be paid for the payroll.
       */
      excluded?: boolean;
      fixed_compensations?: Array<{
        /**
         * The name of the compensation. This also serves as the unique, immutable identifier for this compensation.
         */
        name?: string;
        /**
         * The amount of the compensation for the pay period.
         */
        amount?: string;
        /**
         * The ID of the job for the compensation.
         */
        job_id?: number;
      }>;
      hourly_compensations?: Array<{
        /**
         * The name of the compensation. This also serves as the unique, immutable identifier for this compensation.
         */
        name?: string;
        /**
         * The number of hours to be compensated for this pay period.
         */
        hours?: string;
        /**
         * The ID of the job for the compensation.
         */
        job_id?: number;
      }>;
      /**
       * An array of all paid time off the employee is eligible for this pay period.
       */
      paid_time_off?: Array<{
        /**
         * The name of the PTO. This also serves as the unique, immutable identifier for the PTO.
         */
        name?: string;
        /**
         * The hours of this PTO taken during the pay period.
         */
        hours?: string;
      }>;
    }>;
  };
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
    /**
     * The end_date of the pay period for the payroll
     */
    pay_period_end_date: string;
    /**
     * The start_date of the pay period for the payroll
     */
    pay_period_start_date: string;
  };
};

export type PutV1CompaniesCompanyIdPayrollsPayPeriodStartDatePayPeriodEndDateResponse = Payroll;

export type PutV1CompaniesCompanyIdPayrollsPayPeriodStartDatePayPeriodEndDateError = unknown;

export type PostV1PartnerManagedCompaniesData = {
  body?: {
    /**
     * Information for the user who will be the primary payroll administrator for the new company.
     */
    user: {
      /**
       * The first name of the user who will be the primary payroll admin.
       */
      first_name: string;
      /**
       * The last name of the user who will be the primary payroll admin.
       */
      last_name: string;
      /**
       * The email of the user who will be the primary payroll admin.
       */
      email: string;
      /**
       * The phone number of the user who will be the primary payroll admin.
       */
      phone?: string;
    };
    company: {
      /**
       * The legal name of the company.
       */
      name: string;
      /**
       * The name of the company.
       */
      trade_name?: string;
      /**
       * The employer identification number (EIN) of the company.
       */
      ein?: string;
    };
  };
};

export type PostV1PartnerManagedCompaniesResponse = {
  /**
   * Access token that can be used for OAuth access to the account. Access tokens expire 2 hours after they are issued.
   */
  readonly access_token?: string;
  /**
   * Refresh token that can be exchanged for a new access token.
   */
  readonly refresh_token?: string;
  /**
   * Gusto’s UUID for the company
   */
  readonly company_uuid?: string;
};

export type PostV1PartnerManagedCompaniesError = unknown;

export type PostV1ProvisionData = {
  body?: {
    /**
     * Information for the user who will be the primary payroll administrator for the new company.
     */
    user: {
      /**
       * The first name of the user who will be the primary payroll admin.
       */
      first_name: string;
      /**
       * The last name of the user who will be the primary payroll admin.
       */
      last_name: string;
      /**
       * The email of the user who will be the primary payroll admin.
       */
      email: string;
      /**
       * The phone number of the user who will be the primary payroll admin.
       */
      phone?: string;
    };
    company: {
      /**
       * The legal name of the company.
       */
      name: string;
      /**
       * The name of the company.
       */
      trade_name?: string;
      /**
       * The employer identification number (EIN) of the company.
       */
      ein?: string;
      /**
       * The states in which the company operates. States should be included by their two letter code, i.e. NY for New York.
       */
      states?: Array<string>;
      /**
       * The number of employees in the company.
       */
      number_employees?: number;
      /**
       * The locations for the company. This includes mailing, work, and filing addresses.
       */
      addresses?: Array<{
        street_1?: string;
        street_2?: string | null;
        city?: string;
        zip?: string;
        state?: string;
        phone?: string;
        /**
         * Whether or not this is a primary address for the company. If set to true, the address will be used as the mailing and filing address for the company and will be added as a work location. If set to false or not included, the address will only be added as a work location for the company. If multiple addresses are included, only one should be marked as primary.
         */
        is_primary?: string;
      }>;
    };
  };
};

export type PostV1ProvisionResponse = {
  /**
   * A URL where the user should be redirected to complete their account setup inside of Gusto.
   */
  readonly account_claim_url?: string;
};

export type PostV1ProvisionError = unknown;

export type GetV1EmployeesEmployeeIdCustomFieldsData = {
  path: {
    /**
     * The ID or UUID of the employee
     */
    employee_id_or_uuid: string;
  };
  query?: {
    /**
     * The page that is requested. When unspecified, will load all employees.
     */
    page?: number;
    /**
     * Number of employees per page. When unspecified, will default to 25
     */
    per?: number;
  };
};

export type GetV1EmployeesEmployeeIdCustomFieldsResponse = {
  custom_fields?: Array<Employee_Custom_Field>;
};

export type GetV1EmployeesEmployeeIdCustomFieldsError = unknown;

export type GetV1CompaniesCompanyIdCustomFieldsData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
  query?: {
    /**
     * The page that is requested. When unspecified, will load all employees.
     */
    page?: number;
    /**
     * Number of employees per page. When unspecified, will default to 25
     */
    per?: number;
  };
};

export type GetV1CompaniesCompanyIdCustomFieldsResponse = {
  custom_fields?: Array<Company_Custom_Field>;
};

export type GetV1CompaniesCompanyIdCustomFieldsError = unknown;

export type GetV1CompaniesCompanyIdTimeOffRequestsTimeOffRequestIdData = {
  path: {
    /**
     * The ID or ID of the company
     */
    company_id_or_uuid: string;
    /**
     * The ID or UUID of the time off request
     */
    time_off_request_id: string;
  };
};

export type GetV1CompaniesCompanyIdTimeOffRequestsTimeOffRequestIdResponse = Time_Off_Request;

export type GetV1CompaniesCompanyIdTimeOffRequestsTimeOffRequestIdError = unknown;

export type PutV1CompaniesCompanyIdPayrollsPayrollIdCalculateData = {
  path: {
    company_id_or_uuid: string;
    payroll_id_or_uuid: string;
  };
};

export type PutV1CompaniesCompanyIdPayrollsPayrollIdCalculateResponse = unknown;

export type PutV1CompaniesCompanyIdPayrollsPayrollIdCalculateError = unknown;

export type PutV1CompaniesCompanyIdPayrollsPayrollIdSubmitData = {
  path: {
    /**
     * Company ID or UUID
     */
    company_id_or_uuid: string;
    /**
     * Payroll ID or UUID
     */
    payroll_id_or_uuid: string;
  };
};

export type PutV1CompaniesCompanyIdPayrollsPayrollIdSubmitResponse = unknown;

export type PutV1CompaniesCompanyIdPayrollsPayrollIdSubmitError = unknown;

export type PutApiV1CompaniesCompanyIdPayrollsPayrollIdCancelData = {
  path: {
    /**
     * Company ID or UUID
     */
    company_id_or_uuid: string;
    /**
     * Payroll ID or UUID
     */
    payroll_id_or_uuid: string;
  };
};

export type PutApiV1CompaniesCompanyIdPayrollsPayrollIdCancelResponse = Payroll;

export type PutApiV1CompaniesCompanyIdPayrollsPayrollIdCancelError = unknown;

export type GetV1CompaniesCompanyIdOrUuidPayrollReversalsData = {
  path: {
    company_id_or_uuid: string;
  };
  query?: {
    /**
     * The page that is requested. When unspecified, will load all employees.
     */
    page?: number;
    /**
     * Number of employees per page. When unspecified, will default to 25
     */
    per?: number;
  };
};

export type GetV1CompaniesCompanyIdOrUuidPayrollReversalsResponse = {
  /**
   * The payroll run being reversed.
   */
  reversed_payroll_id?: number;
  /**
   * The payroll where the reversal was applied.
   */
  reversal_payroll_id?: number;
  /**
   * A reason provided by the admin who created the reversal.
   */
  reason?: string;
  /**
   * Timestamp of when the reversal was approved.
   */
  approved_at?: string | null;
  /**
   * Category chosen by the admin who requested the reversal.
   */
  category?: string;
  /**
   * Array of employee ids affected.
   */
  reversed_employee_ids?: Array<number>;
};

export type GetV1CompaniesCompanyIdOrUuidPayrollReversalsError = unknown;

export type GetV1CompaniesCompanyIdAdminsData = {
  path: {
    /**
     * The ID of the company
     */
    company_id_or_uuid: string;
  };
  query?: {
    /**
     * The page that is requested. When unspecified, will load all employees.
     */
    page?: number;
    /**
     * Number of employees per page. When unspecified, will default to 25
     */
    per?: number;
  };
};

export type GetV1CompaniesCompanyIdAdminsResponse = Array<Admin>;

export type GetV1CompaniesCompanyIdAdminsError = unknown;

export type PostV1CompaniesCompanyIdAdminsData = {
  body?: {
    /**
     * The first name of the admin.
     */
    first_name: string;
    /**
     * The last name of the admin.
     */
    last_name: string;
    /**
     * The email of the admin. This will be used for the admin to log in to their account. If the email matches an existing user, this will create an admin account for them.
     */
    email: string;
  };
  path: {
    /**
     * The ID of the company
     */
    company_id_or_uuid: string;
  };
};

export type PostV1CompaniesCompanyIdAdminsResponse = Admin;

export type PostV1CompaniesCompanyIdAdminsError = unknown;

export type GetV1CompaniesCompanyIdOrUuidFederalTaxDetailsData = {
  path: {
    /**
     * The company id or uuid
     */
    company_id_or_uuid: string;
  };
};

export type GetV1CompaniesCompanyIdOrUuidFederalTaxDetailsResponse = Federal_Tax_Details;

export type GetV1CompaniesCompanyIdOrUuidFederalTaxDetailsError = unknown;

export type PutV1CompaniesCompanyIdOrUuidFederalTaxDetailsData = {
  /**
   * Attributes related to federal tax details that can be updated via this endpoint include:
   */
  body?: {
    /**
     * The legal name of the company
     */
    legal_name?: string;
    /**
     * The EIN of of the company
     */
    ein?: string;
    /**
     * What type of tax entity the company is
     */
    tax_payer_type?: string;
    /**
     * The form used by the company for federal tax filing. One of:
     * - 941 (Quarterly federal tax return)
     * - 944 (Annual federal tax return)
     */
    filing_form?: string;
    /**
     * Whether this company should be taxed as an S-Corporation
     */
    taxable_as_scorp?: boolean;
    /**
     * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for details using this field.
     */
    version: string;
  };
  path: {
    /**
     * The company id or uuid
     */
    company_id_or_uuid: string;
  };
};

export type PutV1CompaniesCompanyIdOrUuidFederalTaxDetailsResponse = Federal_Tax_Details;

export type PutV1CompaniesCompanyIdOrUuidFederalTaxDetailsError = unknown;

export type GetV1EmployeesEmployeeIdBankAccountsData = {
  body?: {
    [key: string]: unknown;
  };
  path: {
    employee_id_or_uuid: string;
  };
  query?: {
    /**
     * The page that is requested. When unspecified, will load all employees.
     */
    page?: number;
    /**
     * Number of employees per page. When unspecified, will default to 25
     */
    per?: number;
  };
};

export type GetV1EmployeesEmployeeIdBankAccountsResponse = Array<Employee_Bank_Account>;

export type GetV1EmployeesEmployeeIdBankAccountsError = unknown;

export type PostV1EmployeesEmployeeIdBankAccountsData = {
  body?: {
    name: string;
    routing_number: string;
    account_number: string;
    account_type: 'Checking' | 'Savings';
  };
  path: {
    employee_id_or_uuid: string;
  };
};

export type PostV1EmployeesEmployeeIdBankAccountsResponse = Employee_Bank_Account;

export type PostV1EmployeesEmployeeIdBankAccountsError = unknown;

export type DeleteV1EmployeesEmployeeIdBankAccountsBankAccountIdData = {
  path: {
    bank_account_uuid: string;
    employee_id_or_uuid: string;
  };
};

export type DeleteV1EmployeesEmployeeIdBankAccountsBankAccountIdResponse = any;

export type DeleteV1EmployeesEmployeeIdBankAccountsBankAccountIdError = unknown;

export type GetV1EmployeesEmployeeIdPaymentMethodData = {
  path: {
    employee_id_or_uuid: string;
  };
};

export type GetV1EmployeesEmployeeIdPaymentMethodResponse = Employee_Payment_Method;

export type GetV1EmployeesEmployeeIdPaymentMethodError = unknown;

export type PutV1EmployeesEmployeeIdPaymentMethodData = {
  body?: {
    /**
     * The current version of the object. See the [versioning guide](https://docs.gusto.com/docs/api/ZG9jOjUyNzM0MTc-versioning) for information on how to use this field.
     */
    version: string;
    /**
     * The payment method type. If type is Check, then split_by and splits do not need to be populated. If type is Direct Deposit, split_by and splits are required.
     */
    type: 'Direct Deposit' | 'Check';
    /**
     * Describes how the payment will be split. If split_by is Percentage, then the split amounts must add up to exactly 100. If split_by is Amount, then the last split amount must be nil to capture the remainder.
     */
    split_by?: 'Amount' | 'Percentage';
    splits?: Array<{
      /**
       * The bank account ID
       *
       */
      uuid?: string;
      /**
       * The bank account name
       */
      name?: string;
      /**
       * The order of priority for each payment split, with priority 1 being the first bank account paid. Priority must be unique and sequential.
       */
      priority?: number;
      /**
       * The cents amount allocated for each payment split
       */
      split_amount?: number | null;
    }>;
  };
  path: {
    employee_id_or_uuid: string;
  };
};

export type PutV1EmployeesEmployeeIdPaymentMethodResponse = Employee_Payment_Method;

export type PutV1EmployeesEmployeeIdPaymentMethodError = unknown;

export type PostV1CompanySignatoriesData = {
  body?: {
    ssn: string;
    first_name: string;
    middle_initial?: string;
    last_name: string;
    email: string;
    title: string;
    phone?: string;
    birthday: string;
    /**
     * The signatory's home address
     */
    home_address: {
      street_1: string;
      street_2?: string;
      city: string;
      state: string;
      zip: string;
    };
  };
  path: {
    /**
     * The UUID of the company
     */
    company_uuid: string;
  };
};

export type PostV1CompanySignatoriesResponse = Signatory;

export type PostV1CompanySignatoriesError = unknown;

export type GetV1CompaniesCompanyUuidSignatoriesData = {
  path: {
    /**
     * The UUID of the company
     */
    company_uuid: string;
  };
};

export type GetV1CompaniesCompanyUuidSignatoriesResponse = Array<Signatory>;

export type GetV1CompaniesCompanyUuidSignatoriesError = unknown;

export type GetV1CompanyFormsData = {
  path: {
    /**
     * The ID or UUID of the company
     */
    company_id_or_uuid: string;
  };
};

export type GetV1CompanyFormsResponse = Array<Form>;

export type GetV1CompanyFormsError = unknown;

export type GetV1CompanyFormData = {
  path: {
    /**
     * The ID or UUID of the form
     */
    id_or_uuid: string;
  };
};

export type GetV1CompanyFormResponse = Form;

export type GetV1CompanyFormError = unknown;

export type GetV1CompanyFormPdfData = {
  path: {
    /**
     * The ID or UUID of the form
     */
    id_or_uuid: string;
  };
};

export type GetV1CompanyFormPdfResponse = {
  /**
   * the UUID of the form
   */
  readonly uuid?: string;
  /**
   * the URL of the form
   */
  readonly document_url?: string;
};

export type GetV1CompanyFormPdfError = unknown;

export type PutV1CompanyFormSignData = {
  body?: {
    /**
     * The signature
     */
    signature_text: string;
    /**
     * whether you agree to sign electronically
     */
    agree: boolean;
    /**
     * The IP address of the signatory who signed the form.
     */
    signed_by_ip_address: string;
  };
  path: {
    /**
     * The ID or UUID of the form
     */
    id_or_uuid: string;
  };
};

export type PutV1CompanyFormSignResponse = Form;

export type PutV1CompanyFormSignError = unknown;

export type GetV1EmployeeFormsData = {
  path: {
    /**
     * The ID or UUID of the employee
     */
    employee_id_or_uuid: string;
  };
};

export type GetV1EmployeeFormsResponse = Array<Form>;

export type GetV1EmployeeFormsError = unknown;

export type GetV1EmployeeFormData = {
  path: {
    /**
     * The ID or UUID of the employee
     */
    employee_id_or_uuid: string;
    /**
     * The ID or UUID of the form
     */
    id_or_uuid: string;
  };
};

export type GetV1EmployeeFormResponse = Form;

export type GetV1EmployeeFormError = unknown;

export type GetV1EmployeeFormPdfData = {
  path: {
    /**
     * The ID or UUID of the employee
     */
    employee_id_or_uuid: string;
    /**
     * The ID or UUID of the form
     */
    id_or_uuid: string;
  };
};

export type GetV1EmployeeFormPdfResponse = {
  /**
   * the UUID of the form
   */
  readonly uuid?: string;
  /**
   * the URL of the form
   */
  readonly document_url?: string;
};

export type GetV1EmployeeFormPdfError = unknown;

export type PutV1EmployeeFormSignData = {
  body?: {
    /**
     * The signature
     */
    signature_text: string;
    /**
     * whether you agree to sign electronically
     */
    agree: boolean;
    /**
     * The IP address of the signatory who signed the form.
     */
    signed_by_ip_address: string;
  };
  path: {
    /**
     * The ID or UUID of the employee
     */
    employee_id_or_uuid: string;
    /**
     * The ID or UUID of the form
     */
    id_or_uuid: string;
  };
};

export type PutV1EmployeeFormSignResponse = Form;

export type PutV1EmployeeFormSignError = unknown;

export type PostV1CompanyFlowsData = {
  body?: {
    /**
     * flow type
     */
    flow_type: string;
    /**
     * UUID of the target entity applicable to the flow. This field is optional for company flows, please refer to the flow_types table above for more details.
     */
    entity_uuid?: string;
    /**
     * the type of target entity applicable to the flow. This field is optional for company flows, please refer to the flow_types table above for more details.
     */
    entity_type?: 'Company';
  };
  path: {
    /**
     * The UUID of the company
     */
    company_uuid: string;
  };
};

export type PostV1CompanyFlowsResponse = Flow;

export type PostV1CompanyFlowsError = unknown;

export type GetV1PayrollsPayrollUuidEmployeesEmployeeUuidPayStubData = {
  path: {
    employee_id_or_uuid: string;
    payroll_id_or_uuid: string;
  };
};

export type GetV1PayrollsPayrollUuidEmployeesEmployeeUuidPayStubResponse = unknown;

export type GetV1PayrollsPayrollUuidEmployeesEmployeeUuidPayStubError = unknown;

export type PostV1CompaniesCompanyUuidSignatoriesInviteData = {
  body?: {
    first_name?: string;
    last_name?: string;
    title?: string;
    email: string;
  };
  path: {
    company_uuid: string;
  };
};

export type PostV1CompaniesCompanyUuidSignatoriesInviteResponse = Signatory;

export type PostV1CompaniesCompanyUuidSignatoriesInviteError = unknown;

export type PutV1CompaniesCompanyUuidSignatoriesSignatoryUuidData = {
  body?: {
    /**
     * The current version of the object. See the versioning guide for information on how to use this field.
     */
    version?: string;
    first_name?: string;
    middle_initial?: string;
    last_name?: string;
    title?: string;
    phone?: string;
    birthday?: string;
    ssn?: string;
    home_address?: {
      street_1?: string;
      street_2?: string;
      city?: string;
      state?: string;
      zip?: string;
    };
  };
  path: {
    /**
     * The UUID of the company
     */
    company_uuid: string;
    /**
     * The UUID of the signatory
     */
    signatory_uuid: string;
  };
};

export type PutV1CompaniesCompanyUuidSignatoriesSignatoryUuidResponse = Signatory;

export type PutV1CompaniesCompanyUuidSignatoriesSignatoryUuidError = unknown;

export type DeleteV1CompaniesCompanyUuidSignatoriesSignatoryUuidData = {
  path: {
    /**
     * The UUID of the company
     */
    company_uuid: string;
    /**
     * The UUID of the signatory
     */
    signatory_uuid: string;
  };
};

export type DeleteV1CompaniesCompanyUuidSignatoriesSignatoryUuidResponse = any;

export type DeleteV1CompaniesCompanyUuidSignatoriesSignatoryUuidError = unknown;

export type GetV1EmployeesEmployeeIdOrUuidOnboardingStatusData = {
  path: {
    /**
     * The UUID of the employee
     */
    employee_id_or_uuid: string;
  };
};

export type GetV1EmployeesEmployeeIdOrUuidOnboardingStatusResponse = Employee_Onboarding_Status;

export type GetV1EmployeesEmployeeIdOrUuidOnboardingStatusError = unknown;
