// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  GetV1EmployeesData,
  GetV1EmployeesError,
  GetV1EmployeesResponse,
  PutV1EmployeesData,
  PutV1EmployeesError,
  PutV1EmployeesResponse,
  DeleteV1EmployeeData,
  DeleteV1EmployeeError,
  DeleteV1EmployeeResponse,
  PutV1EmployeeFinishOnboardingData,
  PutV1EmployeeFinishOnboardingError,
  PutV1EmployeeFinishOnboardingResponse,
  GetV1CompaniesData,
  GetV1CompaniesError,
  GetV1CompaniesResponse,
  GetV1CompanyOnboardingStatusData,
  GetV1CompanyOnboardingStatusError,
  GetV1CompanyOnboardingStatusResponse,
  GetV1CompanyFinishOnboardingData,
  GetV1CompanyFinishOnboardingError,
  GetV1CompanyFinishOnboardingResponse,
  GetV1CompaniesCompanyIdEmployeesData,
  GetV1CompaniesCompanyIdEmployeesError,
  GetV1CompaniesCompanyIdEmployeesResponse,
  PostV1EmployeesData,
  PostV1EmployeesError,
  PostV1EmployeesResponse,
  GetV1JobsJobIdData,
  GetV1JobsJobIdError,
  GetV1JobsJobIdResponse,
  PutV1JobsJobIdData,
  PutV1JobsJobIdError,
  PutV1JobsJobIdResponse,
  DeleteV1JobsJobIdData,
  DeleteV1JobsJobIdError,
  DeleteV1JobsJobIdResponse,
  GetV1EmployeesEmployeeIdJobsData,
  GetV1EmployeesEmployeeIdJobsError,
  GetV1EmployeesEmployeeIdJobsResponse,
  PostV1JobsJobIdData,
  PostV1JobsJobIdError,
  PostV1JobsJobIdResponse,
  GetV1CompaniesCompanyIdLocationsData,
  GetV1CompaniesCompanyIdLocationsError,
  GetV1CompaniesCompanyIdLocationsResponse,
  PostV1CompaniesCompanyIdLocationsData,
  PostV1CompaniesCompanyIdLocationsError,
  PostV1CompaniesCompanyIdLocationsResponse,
  GetV1LocationsLocationIdData,
  GetV1LocationsLocationIdError,
  GetV1LocationsLocationIdResponse,
  PutV1LocationsLocationIdData,
  PutV1LocationsLocationIdError,
  PutV1LocationsLocationIdResponse,
  GetV1ContractorsContractorIdData,
  GetV1ContractorsContractorIdError,
  GetV1ContractorsContractorIdResponse,
  PutV1ContractorsContractorIdData,
  PutV1ContractorsContractorIdError,
  PutV1ContractorsContractorIdResponse,
  GetV1CompaniesCompanyIdContractorsData,
  GetV1CompaniesCompanyIdContractorsError,
  GetV1CompaniesCompanyIdContractorsResponse,
  PostV1CompaniesCompanyIdContractorsData,
  PostV1CompaniesCompanyIdContractorsError,
  PostV1CompaniesCompanyIdContractorsResponse,
  GetV1CompaniesCompanyIdContractorPaymentsData,
  GetV1CompaniesCompanyIdContractorPaymentsError,
  GetV1CompaniesCompanyIdContractorPaymentsResponse,
  PostV1CompaniesCompanyIdContractorPaymentsData,
  PostV1CompaniesCompanyIdContractorPaymentsError,
  PostV1CompaniesCompanyIdContractorPaymentsResponse,
  GetV1CompaniesCompanyIdContractorPaymentContractorPaymentData,
  GetV1CompaniesCompanyIdContractorPaymentContractorPaymentError,
  GetV1CompaniesCompanyIdContractorPaymentContractorPaymentResponse,
  DeleteV1CompaniesCompanyIdContractorPaymentContractorPaymentData,
  DeleteV1CompaniesCompanyIdContractorPaymentContractorPaymentError,
  DeleteV1CompaniesCompanyIdContractorPaymentContractorPaymentResponse,
  GetV1CompensationsCompensationIdData,
  GetV1CompensationsCompensationIdError,
  GetV1CompensationsCompensationIdResponse,
  PutV1CompensationsCompensationIdData,
  PutV1CompensationsCompensationIdError,
  PutV1CompensationsCompensationIdResponse,
  GetV1JobsJobIdCompensationsData,
  GetV1JobsJobIdCompensationsError,
  GetV1JobsJobIdCompensationsResponse,
  PostV1JobsJobIdCompensationsData,
  PostV1JobsJobIdCompensationsError,
  PostV1JobsJobIdCompensationsResponse,
  GetV1EmployeesEmployeeIdGarnishmentsData,
  GetV1EmployeesEmployeeIdGarnishmentsError,
  GetV1EmployeesEmployeeIdGarnishmentsResponse,
  PostV1EmployeesEmployeeIdGarnishmentsData,
  PostV1EmployeesEmployeeIdGarnishmentsError,
  PostV1EmployeesEmployeeIdGarnishmentsResponse,
  GetV1GarnishmentsGarnishmentIdData,
  GetV1GarnishmentsGarnishmentIdError,
  GetV1GarnishmentsGarnishmentIdResponse,
  PutV1GarnishmentsGarnishmentIdData,
  PutV1GarnishmentsGarnishmentIdError,
  PutV1GarnishmentsGarnishmentIdResponse,
  GetV1EmployeesEmployeeIdTerminationsData,
  GetV1EmployeesEmployeeIdTerminationsError,
  GetV1EmployeesEmployeeIdTerminationsResponse,
  PostV1EmployeesEmployeeIdTerminationsData,
  PostV1EmployeesEmployeeIdTerminationsError,
  PostV1EmployeesEmployeeIdTerminationsResponse,
  GetV1CompaniesCompanyIdTimeOffRequestsData,
  GetV1CompaniesCompanyIdTimeOffRequestsError,
  GetV1CompaniesCompanyIdTimeOffRequestsResponse,
  GetV1MeError,
  GetV1MeResponse,
  GetV1TermsOfServiceError,
  GetV1TermsOfServiceResponse,
  PostV1TermsOfServiceError,
  PostV1TermsOfServiceResponse,
  GetV1EmployeesEmployeeIdFederalTaxesData,
  GetV1EmployeesEmployeeIdFederalTaxesError,
  GetV1EmployeesEmployeeIdFederalTaxesResponse,
  PutV1EmployeesEmployeeIdFederalTaxesData,
  PutV1EmployeesEmployeeIdFederalTaxesError,
  PutV1EmployeesEmployeeIdFederalTaxesResponse,
  GetV1EmployeesEmployeeIdStateTaxesData,
  GetV1EmployeesEmployeeIdStateTaxesError,
  GetV1EmployeesEmployeeIdStateTaxesResponse,
  PutV1EmployeesEmployeeIdStateTaxesData,
  PutV1EmployeesEmployeeIdStateTaxesError,
  PutV1EmployeesEmployeeIdStateTaxesResponse,
  GetV1EmployeesEmployeeIdHomeAddressData,
  GetV1EmployeesEmployeeIdHomeAddressError,
  GetV1EmployeesEmployeeIdHomeAddressResponse,
  PutV1EmployeesEmployeeIdHomeAddressData,
  PutV1EmployeesEmployeeIdHomeAddressError,
  PutV1EmployeesEmployeeIdHomeAddressResponse,
  GetV1CompanyPaymentConfigsData,
  GetV1CompanyPaymentConfigsError,
  GetV1CompanyPaymentConfigsResponse,
  PutV1CompanyPaymentConfigsData,
  PutV1CompanyPaymentConfigsError,
  PutV1CompanyPaymentConfigsResponse,
  GetV1CompaniesCompanyIdPaySchedulesData,
  GetV1CompaniesCompanyIdPaySchedulesError,
  GetV1CompaniesCompanyIdPaySchedulesResponse,
  PostV1CompaniesCompanyIdPaySchedulesData,
  PostV1CompaniesCompanyIdPaySchedulesError,
  PostV1CompaniesCompanyIdPaySchedulesResponse,
  GetV1CompanyIndustryData,
  GetV1CompanyIndustryError,
  GetV1CompanyIndustryResponse,
  PutV1CompanyIndustryData,
  PutV1CompanyIndustryError,
  PutV1CompanyIndustryResponse,
  GetV1CompaniesCompanyIdPaySchedulesPayScheduleIdData,
  GetV1CompaniesCompanyIdPaySchedulesPayScheduleIdError,
  GetV1CompaniesCompanyIdPaySchedulesPayScheduleIdResponse,
  PutV1CompaniesCompanyIdPaySchedulesPayScheduleIdData,
  PutV1CompaniesCompanyIdPaySchedulesPayScheduleIdError,
  PutV1CompaniesCompanyIdPaySchedulesPayScheduleIdResponse,
  GetV1CompaniesCompanyIdBankAccountsData,
  GetV1CompaniesCompanyIdBankAccountsError,
  GetV1CompaniesCompanyIdBankAccountsResponse,
  PostV1CompaniesCompanyIdBankAccountsData,
  PostV1CompaniesCompanyIdBankAccountsError,
  PostV1CompaniesCompanyIdBankAccountsResponse,
  PutV1CompaniesCompanyIdBankAccountsVerifyData,
  PutV1CompaniesCompanyIdBankAccountsVerifyError,
  PutV1CompaniesCompanyIdBankAccountsVerifyResponse,
  GetV1BenefitsError,
  GetV1BenefitsResponse,
  GetV1BenefitsBenefitIdData,
  GetV1BenefitsBenefitIdError,
  GetV1BenefitsBenefitIdResponse,
  GetV1CompaniesCompanyIdCompanyBenefitsData,
  GetV1CompaniesCompanyIdCompanyBenefitsError,
  GetV1CompaniesCompanyIdCompanyBenefitsResponse,
  PostV1CompaniesCompanyIdCompanyBenefitsData,
  PostV1CompaniesCompanyIdCompanyBenefitsError,
  PostV1CompaniesCompanyIdCompanyBenefitsResponse,
  GetV1CompanyBenefitsCompanyBenefitIdData,
  GetV1CompanyBenefitsCompanyBenefitIdError,
  GetV1CompanyBenefitsCompanyBenefitIdResponse,
  PutV1CompanyBenefitsCompanyBenefitIdData,
  PutV1CompanyBenefitsCompanyBenefitIdError,
  PutV1CompanyBenefitsCompanyBenefitIdResponse,
  GetV1CompaniesCompanyIdEarningTypesData,
  GetV1CompaniesCompanyIdEarningTypesError,
  GetV1CompaniesCompanyIdEarningTypesResponse,
  PostV1CompaniesCompanyIdEarningTypesData,
  PostV1CompaniesCompanyIdEarningTypesError,
  PostV1CompaniesCompanyIdEarningTypesResponse,
  PutV1CompaniesCompanyIdEarningTypesEarningTypeUuidData,
  PutV1CompaniesCompanyIdEarningTypesEarningTypeUuidError,
  PutV1CompaniesCompanyIdEarningTypesEarningTypeUuidResponse,
  DeleteV1CompaniesCompanyIdEarningTypesEarningTypeUuidData,
  DeleteV1CompaniesCompanyIdEarningTypesEarningTypeUuidError,
  DeleteV1CompaniesCompanyIdEarningTypesEarningTypeUuidResponse,
  GetV1EmployeesEmployeeIdEmployeeBenefitsData,
  GetV1EmployeesEmployeeIdEmployeeBenefitsError,
  GetV1EmployeesEmployeeIdEmployeeBenefitsResponse,
  PostV1EmployeesEmployeeIdEmployeeBenefitsData,
  PostV1EmployeesEmployeeIdEmployeeBenefitsError,
  PostV1EmployeesEmployeeIdEmployeeBenefitsResponse,
  PostEmployeeYtdBenefitAmountsFromDifferentCompanyData,
  PostEmployeeYtdBenefitAmountsFromDifferentCompanyError,
  PostEmployeeYtdBenefitAmountsFromDifferentCompanyResponse,
  GetV1EmployeeBenefitsEmployeeBenefitIdData,
  GetV1EmployeeBenefitsEmployeeBenefitIdError,
  GetV1EmployeeBenefitsEmployeeBenefitIdResponse,
  PutV1EmployeeBenefitsEmployeeBenefitIdData,
  PutV1EmployeeBenefitsEmployeeBenefitIdError,
  PutV1EmployeeBenefitsEmployeeBenefitIdResponse,
  DeleteV1EmployeeBenefitsEmployeeBenefitIdData,
  DeleteV1EmployeeBenefitsEmployeeBenefitIdError,
  DeleteV1EmployeeBenefitsEmployeeBenefitIdResponse,
  GetV1CompaniesCompanyIdPayPeriodsData,
  GetV1CompaniesCompanyIdPayPeriodsError,
  GetV1CompaniesCompanyIdPayPeriodsResponse,
  GetV1CompaniesCompanyIdPayrollsData,
  GetV1CompaniesCompanyIdPayrollsError,
  GetV1CompaniesCompanyIdPayrollsResponse,
  PostV1CompaniesCompanyIdPayrollsData,
  PostV1CompaniesCompanyIdPayrollsError,
  PostV1CompaniesCompanyIdPayrollsResponse,
  PutV1CompaniesCompanyIdPayrollsData,
  PutV1CompaniesCompanyIdPayrollsError,
  PutV1CompaniesCompanyIdPayrollsResponse,
  GetV1CompaniesCompanyIdPayrollsPayrollIdData,
  GetV1CompaniesCompanyIdPayrollsPayrollIdError,
  GetV1CompaniesCompanyIdPayrollsPayrollIdResponse,
  PutV1CompaniesCompanyIdPayrollsPayPeriodStartDatePayPeriodEndDateData,
  PutV1CompaniesCompanyIdPayrollsPayPeriodStartDatePayPeriodEndDateError,
  PutV1CompaniesCompanyIdPayrollsPayPeriodStartDatePayPeriodEndDateResponse,
  PostV1PartnerManagedCompaniesData,
  PostV1PartnerManagedCompaniesError,
  PostV1PartnerManagedCompaniesResponse,
  PostV1ProvisionData,
  PostV1ProvisionError,
  PostV1ProvisionResponse,
  GetV1EmployeesEmployeeIdCustomFieldsData,
  GetV1EmployeesEmployeeIdCustomFieldsError,
  GetV1EmployeesEmployeeIdCustomFieldsResponse,
  GetV1CompaniesCompanyIdCustomFieldsData,
  GetV1CompaniesCompanyIdCustomFieldsError,
  GetV1CompaniesCompanyIdCustomFieldsResponse,
  GetV1CompaniesCompanyIdTimeOffRequestsTimeOffRequestIdData,
  GetV1CompaniesCompanyIdTimeOffRequestsTimeOffRequestIdError,
  GetV1CompaniesCompanyIdTimeOffRequestsTimeOffRequestIdResponse,
  PutV1CompaniesCompanyIdPayrollsPayrollIdCalculateData,
  PutV1CompaniesCompanyIdPayrollsPayrollIdCalculateError,
  PutV1CompaniesCompanyIdPayrollsPayrollIdCalculateResponse,
  PutV1CompaniesCompanyIdPayrollsPayrollIdSubmitData,
  PutV1CompaniesCompanyIdPayrollsPayrollIdSubmitError,
  PutV1CompaniesCompanyIdPayrollsPayrollIdSubmitResponse,
  PutApiV1CompaniesCompanyIdPayrollsPayrollIdCancelData,
  PutApiV1CompaniesCompanyIdPayrollsPayrollIdCancelError,
  PutApiV1CompaniesCompanyIdPayrollsPayrollIdCancelResponse,
  GetV1CompaniesCompanyIdOrUuidPayrollReversalsData,
  GetV1CompaniesCompanyIdOrUuidPayrollReversalsError,
  GetV1CompaniesCompanyIdOrUuidPayrollReversalsResponse,
  GetV1CompaniesCompanyIdAdminsData,
  GetV1CompaniesCompanyIdAdminsError,
  GetV1CompaniesCompanyIdAdminsResponse,
  PostV1CompaniesCompanyIdAdminsData,
  PostV1CompaniesCompanyIdAdminsError,
  PostV1CompaniesCompanyIdAdminsResponse,
  GetV1CompaniesCompanyIdOrUuidFederalTaxDetailsData,
  GetV1CompaniesCompanyIdOrUuidFederalTaxDetailsError,
  GetV1CompaniesCompanyIdOrUuidFederalTaxDetailsResponse,
  PutV1CompaniesCompanyIdOrUuidFederalTaxDetailsData,
  PutV1CompaniesCompanyIdOrUuidFederalTaxDetailsError,
  PutV1CompaniesCompanyIdOrUuidFederalTaxDetailsResponse,
  GetV1EmployeesEmployeeIdBankAccountsData,
  GetV1EmployeesEmployeeIdBankAccountsError,
  GetV1EmployeesEmployeeIdBankAccountsResponse,
  PostV1EmployeesEmployeeIdBankAccountsData,
  PostV1EmployeesEmployeeIdBankAccountsError,
  PostV1EmployeesEmployeeIdBankAccountsResponse,
  DeleteV1EmployeesEmployeeIdBankAccountsBankAccountIdData,
  DeleteV1EmployeesEmployeeIdBankAccountsBankAccountIdError,
  DeleteV1EmployeesEmployeeIdBankAccountsBankAccountIdResponse,
  GetV1EmployeesEmployeeIdPaymentMethodData,
  GetV1EmployeesEmployeeIdPaymentMethodError,
  GetV1EmployeesEmployeeIdPaymentMethodResponse,
  PutV1EmployeesEmployeeIdPaymentMethodData,
  PutV1EmployeesEmployeeIdPaymentMethodError,
  PutV1EmployeesEmployeeIdPaymentMethodResponse,
  PostV1CompanySignatoriesData,
  PostV1CompanySignatoriesError,
  PostV1CompanySignatoriesResponse,
  GetV1CompaniesCompanyUuidSignatoriesData,
  GetV1CompaniesCompanyUuidSignatoriesError,
  GetV1CompaniesCompanyUuidSignatoriesResponse,
  GetV1CompanyFormsData,
  GetV1CompanyFormsError,
  GetV1CompanyFormsResponse,
  GetV1CompanyFormData,
  GetV1CompanyFormError,
  GetV1CompanyFormResponse,
  GetV1CompanyFormPdfData,
  GetV1CompanyFormPdfError,
  GetV1CompanyFormPdfResponse,
  PutV1CompanyFormSignData,
  PutV1CompanyFormSignError,
  PutV1CompanyFormSignResponse,
  GetV1EmployeeFormsData,
  GetV1EmployeeFormsError,
  GetV1EmployeeFormsResponse,
  GetV1EmployeeFormData,
  GetV1EmployeeFormError,
  GetV1EmployeeFormResponse,
  GetV1EmployeeFormPdfData,
  GetV1EmployeeFormPdfError,
  GetV1EmployeeFormPdfResponse,
  PutV1EmployeeFormSignData,
  PutV1EmployeeFormSignError,
  PutV1EmployeeFormSignResponse,
  PostV1CompanyFlowsData,
  PostV1CompanyFlowsError,
  PostV1CompanyFlowsResponse,
  GetV1PayrollsPayrollUuidEmployeesEmployeeUuidPayStubData,
  GetV1PayrollsPayrollUuidEmployeesEmployeeUuidPayStubError,
  GetV1PayrollsPayrollUuidEmployeesEmployeeUuidPayStubResponse,
  PostV1CompaniesCompanyUuidSignatoriesInviteData,
  PostV1CompaniesCompanyUuidSignatoriesInviteError,
  PostV1CompaniesCompanyUuidSignatoriesInviteResponse,
  PutV1CompaniesCompanyUuidSignatoriesSignatoryUuidData,
  PutV1CompaniesCompanyUuidSignatoriesSignatoryUuidError,
  PutV1CompaniesCompanyUuidSignatoriesSignatoryUuidResponse,
  DeleteV1CompaniesCompanyUuidSignatoriesSignatoryUuidData,
  DeleteV1CompaniesCompanyUuidSignatoriesSignatoryUuidError,
  DeleteV1CompaniesCompanyUuidSignatoriesSignatoryUuidResponse,
  GetV1EmployeesEmployeeIdOrUuidOnboardingStatusData,
  GetV1EmployeesEmployeeIdOrUuidOnboardingStatusError,
  GetV1EmployeesEmployeeIdOrUuidOnboardingStatusResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Get an employee
 * Get an employee.
 *
 * `scope: employees.read`
 *
 */
export const getV1Employees = <ThrowOnError extends boolean = false>(
  options: Options<GetV1EmployeesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV1EmployeesResponse, GetV1EmployeesError, ThrowOnError>({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}',
  });
};

/**
 * Update an employee
 * Update an employee.
 *
 * `scope: employees.write`
 */
export const putV1Employees = <ThrowOnError extends boolean = false>(
  options: Options<PutV1EmployeesData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutV1EmployeesResponse, PutV1EmployeesError, ThrowOnError>({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}',
  });
};

/**
 * Delete an onboarding employee
 * Use this endpoint to delete an employee who is in onboarding. Deleting an onboarded employee is not allowed. Please check out the Terminations api if you need to terminate an onboarded employee.
 */
export const deleteV1Employee = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV1EmployeeData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteV1EmployeeResponse, DeleteV1EmployeeError, ThrowOnError>({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}',
  });
};

/**
 * Finish onboarding an employee
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Call this endpoint as the very last step of employee onboarding to complete their onboarding. When successful, the employee's `onboarded` attribute will be updated to true, indicating that they can be included in company's payrolls.
 */
export const putV1EmployeeFinishOnboarding = <ThrowOnError extends boolean = false>(
  options: Options<PutV1EmployeeFinishOnboardingData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1EmployeeFinishOnboardingResponse,
    PutV1EmployeeFinishOnboardingError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/finish_onboarding',
  });
};

/**
 * Get a company
 * Get a company.
 *
 * `scope: companies.read`
 */
export const getV1Companies = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV1CompaniesResponse, GetV1CompaniesError, ThrowOnError>({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}',
  });
};

/**
 * Get the company's onboarding status
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Get company's onboarding status. The data returned helps inform the required onboarding steps and respective completion status.
 */
export const getV1CompanyOnboardingStatus = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompanyOnboardingStatusData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompanyOnboardingStatusResponse,
    GetV1CompanyOnboardingStatusError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_uuid}/onboarding_status',
  });
};

/**
 * Finish company onboarding
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Use this endpoint to finalize company onboarding.
 */
export const getV1CompanyFinishOnboarding = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompanyFinishOnboardingData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    GetV1CompanyFinishOnboardingResponse,
    GetV1CompanyFinishOnboardingError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_uuid}/finish_onboarding',
  });
};

/**
 * Get employees of a company
 * Get all of the employees, onboarding, active and terminated, for a given company.
 *
 * `scope: employees.read`
 */
export const getV1CompaniesCompanyIdEmployees = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdEmployeesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdEmployeesResponse,
    GetV1CompaniesCompanyIdEmployeesError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/employees',
  });
};

/**
 * Create an employee
 * Create an employee.
 *
 * `scope: employees.write`
 */
export const postV1Employees = <ThrowOnError extends boolean = false>(
  options: Options<PostV1EmployeesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostV1EmployeesResponse, PostV1EmployeesError, ThrowOnError>({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/employees',
  });
};

/**
 * Get a job
 * Get a job.
 *
 * `scope: jobs.read`
 */
export const getV1JobsJobId = <ThrowOnError extends boolean = false>(
  options: Options<GetV1JobsJobIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV1JobsJobIdResponse, GetV1JobsJobIdError, ThrowOnError>({
    ...options,
    url: '/v1/jobs/{job_id_or_uuid}',
  });
};

/**
 * Update a job
 * Update a job.
 *
 * `scope: jobs.write`
 */
export const putV1JobsJobId = <ThrowOnError extends boolean = false>(
  options: Options<PutV1JobsJobIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutV1JobsJobIdResponse, PutV1JobsJobIdError, ThrowOnError>({
    ...options,
    url: '/v1/jobs/{job_id_or_uuid}',
  });
};

/**
 * Delete an individual job
 * Deletes a specific job that an employee holds.
 *
 * `scope: jobs.write`
 */
export const deleteV1JobsJobId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV1JobsJobIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteV1JobsJobIdResponse, DeleteV1JobsJobIdError, ThrowOnError>({
    ...options,
    url: '/v1/jobs/{job_id_or_uuid}',
  });
};

/**
 * Get jobs for an employee
 * Get all of the jobs that an employee holds.
 *
 * `scope: jobs.read`
 */
export const getV1EmployeesEmployeeIdJobs = <ThrowOnError extends boolean = false>(
  options: Options<GetV1EmployeesEmployeeIdJobsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1EmployeesEmployeeIdJobsResponse,
    GetV1EmployeesEmployeeIdJobsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/jobs',
  });
};

/**
 * Create a job
 * Create a job.
 *
 * `scope: jobs.write`
 */
export const postV1JobsJobId = <ThrowOnError extends boolean = false>(
  options: Options<PostV1JobsJobIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostV1JobsJobIdResponse, PostV1JobsJobIdError, ThrowOnError>({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/jobs',
  });
};

/**
 * Get company locations
 * Company locations represent all addresses associated with a company. These can be filing addesses, mailing addresses, and/or work locations; one address may serve multiple, or all, purposes.
 *
 * Since all company locations are subsets of locations, retrieving or updating an individual record should be done via the locations endpoints.
 *
 * `scope: companies.read`
 */
export const getV1CompaniesCompanyIdLocations = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdLocationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdLocationsResponse,
    GetV1CompaniesCompanyIdLocationsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/locations',
  });
};

/**
 * Create a company location
 * Company locations represent all addresses associated with a company. These can be filing addesses, mailing addresses, and/or work locations; one address may serve multiple, or all, purposes.
 *
 * Since all company locations are subsets of locations, retrieving or updating an individual record should be done via the locations endpoints.
 *
 * scope: companies.write
 */
export const postV1CompaniesCompanyIdLocations = <ThrowOnError extends boolean = false>(
  options: Options<PostV1CompaniesCompanyIdLocationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV1CompaniesCompanyIdLocationsResponse,
    PostV1CompaniesCompanyIdLocationsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/locations',
  });
};

/**
 * Get a location
 * Get a location.
 *
 * `scope: companies.read`
 */
export const getV1LocationsLocationId = <ThrowOnError extends boolean = false>(
  options: Options<GetV1LocationsLocationIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV1LocationsLocationIdResponse, GetV1LocationsLocationIdError, ThrowOnError>(
    {
      ...options,
      url: '/v1/locations/{location_id}',
    },
  );
};

/**
 * Update a location
 * Update a location.
 *
 * scope: companies.write
 */
export const putV1LocationsLocationId = <ThrowOnError extends boolean = false>(
  options: Options<PutV1LocationsLocationIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutV1LocationsLocationIdResponse, PutV1LocationsLocationIdError, ThrowOnError>(
    {
      ...options,
      url: '/v1/locations/{location_id}',
    },
  );
};

/**
 * Get a contractor
 * Get a contractor.
 *
 * `scope: employees.read`
 */
export const getV1ContractorsContractorId = <ThrowOnError extends boolean = false>(
  options: Options<GetV1ContractorsContractorIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1ContractorsContractorIdResponse,
    GetV1ContractorsContractorIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/contractors/{contractor_id_or_uuid}',
  });
};

/**
 * Update a contractor
 * Update a contractor.
 *
 * `scope: employees.write`
 */
export const putV1ContractorsContractorId = <ThrowOnError extends boolean = false>(
  options: Options<PutV1ContractorsContractorIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1ContractorsContractorIdResponse,
    PutV1ContractorsContractorIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/contractors/{contractor_id_or_uuid}',
  });
};

/**
 * Get contractors of a company
 * Get all contractors, active and inactive, individual and business, for a company.
 *
 * `scope: employees.read`
 */
export const getV1CompaniesCompanyIdContractors = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdContractorsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdContractorsResponse,
    GetV1CompaniesCompanyIdContractorsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/contractors',
  });
};

/**
 * Create a contractor
 * Create an individual or business contractor.
 *
 * `scope: employees.write`
 */
export const postV1CompaniesCompanyIdContractors = <ThrowOnError extends boolean = false>(
  options: Options<PostV1CompaniesCompanyIdContractorsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV1CompaniesCompanyIdContractorsResponse,
    PostV1CompaniesCompanyIdContractorsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/contractors',
  });
};

/**
 * Get contractor payments for a company
 * Returns an object containing individual contractor payments, within a given time period, including totals.
 *
 * `scope: payrolls.read`
 */
export const getV1CompaniesCompanyIdContractorPayments = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdContractorPaymentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdContractorPaymentsResponse,
    GetV1CompaniesCompanyIdContractorPaymentsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/contractor_payments',
  });
};

/**
 * Create a contractor payment
 * Returns an object containing individual contractor payments, within a given time period, including totals.
 *
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 */
export const postV1CompaniesCompanyIdContractorPayments = <ThrowOnError extends boolean = false>(
  options: Options<PostV1CompaniesCompanyIdContractorPaymentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV1CompaniesCompanyIdContractorPaymentsResponse,
    PostV1CompaniesCompanyIdContractorPaymentsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/contractor_payments',
  });
};

/**
 * Get a single contractor payment
 * Returns a single contractor payments
 *
 * `scope: payrolls.read`
 */
export const getV1CompaniesCompanyIdContractorPaymentContractorPayment = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdContractorPaymentContractorPaymentData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdContractorPaymentContractorPaymentResponse,
    GetV1CompaniesCompanyIdContractorPaymentContractorPaymentError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/contractor_payments/{contractor_payment_id_or_uuid}',
  });
};

/**
 * Cancel a contractor payment
 * Cancels and deletes a contractor payment. If the contractor payment has already started processing, the payment cannot be cancelled.
 *
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 */
export const deleteV1CompaniesCompanyIdContractorPaymentContractorPayment = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV1CompaniesCompanyIdContractorPaymentContractorPaymentData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteV1CompaniesCompanyIdContractorPaymentContractorPaymentResponse,
    DeleteV1CompaniesCompanyIdContractorPaymentContractorPaymentError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/contractor_payments/{contractor_payment_id_or_uuid}',
  });
};

/**
 * Get a compensation
 * Compensations contain information on how much is paid out for a job. Jobs may have many compensations, but only one that is active. The current compensation is the one with the most recent `effective_date`.
 *
 * Note: Currently, jobs are arbitrarily limited to a single compensation as multiple compensations per job are not yet available in Gusto. The API is architected as if multiple compensations may exist, so integrations should integrate under the same assumption. The only exception is that creating a compensation with the same `job_id` as another will fail with a relevant error.
 *
 * `scope: jobs.read`
 *
 */
export const getV1CompensationsCompensationId = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompensationsCompensationIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompensationsCompensationIdResponse,
    GetV1CompensationsCompensationIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/compensations/{compensation_id_or_uuid}',
  });
};

/**
 * Update a compensation
 * Compensations contain information on how much is paid out for a job. Jobs may have many compensations, but only one that is active. The current compensation is the one with the most recent `effective_date`.
 *
 * Note: Currently, jobs are arbitrarily limited to a single compensation as multiple compensations per job are not yet available in Gusto. The API is architected as if multiple compensations may exist, so integrations should integrate under the same assumption. The only exception is that creating a compensation with the same `job_id` as another will fail with a relevant error
 *
 * `scope: jobs.write`
 */
export const putV1CompensationsCompensationId = <ThrowOnError extends boolean = false>(
  options: Options<PutV1CompensationsCompensationIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1CompensationsCompensationIdResponse,
    PutV1CompensationsCompensationIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/compensations/{compensation_id_or_uuid}',
  });
};

/**
 * Get compensations for a job
 * Compensations contain information on how much is paid out for a job. Jobs may have many compensations, but only one that is active. The current compensation is the one with the most recent `effective_date`.
 *
 * Note: Currently, jobs are arbitrarily limited to a single compensation as multiple compensations per job are not yet available in Gusto. The API is architected as if multiple compensations may exist, so integrations should integrate under the same assumption. The only exception is that creating a compensation with the same `job_id` as another will fail with a relevant error.
 *
 * Use the `flsa_status` to determine if an employee is elibgle for overtime.
 *
 * `scope: jobs.read`
 */
export const getV1JobsJobIdCompensations = <ThrowOnError extends boolean = false>(
  options: Options<GetV1JobsJobIdCompensationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1JobsJobIdCompensationsResponse,
    GetV1JobsJobIdCompensationsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/jobs/{job_id_or_uuid}/compensations',
  });
};

/**
 * Create a compensation
 * Compensations contain information on how much is paid out for a job. Jobs may have many compensations, but only one that is active. The current compensation is the one with the most recent `effective_date`.
 *
 * Note: Currently, jobs are arbitrarily limited to a single compensation as multiple compensations per job are not yet available in Gusto. The API is architected as if multiple compensations may exist, so integrations should integrate under the same assumption. The only exception is that creating a compensation with the same `job_id` as another will fail with a relevant error
 *
 * `scope: jobs.write`
 */
export const postV1JobsJobIdCompensations = <ThrowOnError extends boolean = false>(
  options: Options<PostV1JobsJobIdCompensationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV1JobsJobIdCompensationsResponse,
    PostV1JobsJobIdCompensationsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/jobs/{job_id_or_uuid}/compensations',
  });
};

/**
 * Get garnishments for an employee
 * Garnishments, or employee deductions, are fixed amounts or percentages deducted from an employee’s pay. They can be deducted a specific number of times or on a recurring basis. Garnishments can also have maximum deductions on a yearly or per-pay-period bases. Common uses for garnishments are court-ordered payments for child support or back taxes. Some companies provide loans to their employees that are repaid via garnishments.
 *
 * `scope: employees.read`
 */
export const getV1EmployeesEmployeeIdGarnishments = <ThrowOnError extends boolean = false>(
  options: Options<GetV1EmployeesEmployeeIdGarnishmentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1EmployeesEmployeeIdGarnishmentsResponse,
    GetV1EmployeesEmployeeIdGarnishmentsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/garnishments',
  });
};

/**
 * Create a garnishment
 * Garnishments, or employee deductions, are fixed amounts or percentages deducted from an employee’s pay. They can be deducted a specific number of times or on a recurring basis. Garnishments can also have maximum deductions on a yearly or per-pay-period bases. Common uses for garnishments are court-ordered payments for child support or back taxes. Some companies provide loans to their employees that are repaid via garnishments.
 *
 * `scope: employees.write`
 */
export const postV1EmployeesEmployeeIdGarnishments = <ThrowOnError extends boolean = false>(
  options: Options<PostV1EmployeesEmployeeIdGarnishmentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV1EmployeesEmployeeIdGarnishmentsResponse,
    PostV1EmployeesEmployeeIdGarnishmentsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/garnishments',
  });
};

/**
 * Get a garnishment
 * Garnishments, or employee deductions, are fixed amounts or percentages deducted from an employee’s pay. They can be deducted a specific number of times or on a recurring basis. Garnishments can also have maximum deductions on a yearly or per-pay-period bases. Common uses for garnishments are court-ordered payments for child support or back taxes. Some companies provide loans to their employees that are repaid via garnishments.
 *
 * `scope: employees.read`
 */
export const getV1GarnishmentsGarnishmentId = <ThrowOnError extends boolean = false>(
  options: Options<GetV1GarnishmentsGarnishmentIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1GarnishmentsGarnishmentIdResponse,
    GetV1GarnishmentsGarnishmentIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/garnishments/{garnishment_id_or_uuid}',
  });
};

/**
 * Update a garnishment
 * Garnishments, or employee deductions, are fixed amounts or percentages deducted from an employee’s pay. They can be deducted a specific number of times or on a recurring basis. Garnishments can also have maximum deductions on a yearly or per-pay-period bases. Common uses for garnishments are court-ordered payments for child support or back taxes. Some companies provide loans to their employees that are repaid via garnishments.
 *
 * `scope: employees.write`
 */
export const putV1GarnishmentsGarnishmentId = <ThrowOnError extends boolean = false>(
  options: Options<PutV1GarnishmentsGarnishmentIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1GarnishmentsGarnishmentIdResponse,
    PutV1GarnishmentsGarnishmentIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/garnishments/{garnishment_id_or_uuid}',
  });
};

/**
 * Get terminations for an employee
 * Terminations are created whenever an employee is scheduled to leave the company. The only things required are an effective date (their last day of work) and whether they should receive their wages in a one-off termination payroll or with the rest of the company.
 *
 * Note that some states require employees to receive their final wages within 24 hours (unless they consent otherwise,) in which case running a one-off payroll may be the only option.
 *
 * `scope: employees.read`
 */
export const getV1EmployeesEmployeeIdTerminations = <ThrowOnError extends boolean = false>(
  options: Options<GetV1EmployeesEmployeeIdTerminationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1EmployeesEmployeeIdTerminationsResponse,
    GetV1EmployeesEmployeeIdTerminationsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/terminations',
  });
};

/**
 * Create an employee termination
 * Terminations are created whenever an employee is scheduled to leave the company. The only things required are an effective date (their last day of work) and whether they should receive their wages in a one-off termination payroll or with the rest of the company.
 *
 * Note that some states require employees to receive their final wages within 24 hours (unless they consent otherwise,) in which case running a one-off payroll may be the only option.
 *
 * `scope: employees.write`
 */
export const postV1EmployeesEmployeeIdTerminations = <ThrowOnError extends boolean = false>(
  options: Options<PostV1EmployeesEmployeeIdTerminationsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV1EmployeesEmployeeIdTerminationsResponse,
    PostV1EmployeesEmployeeIdTerminationsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/terminations',
  });
};

/**
 * Get time off requests for a company
 * Get all time off requests, past and present, for a company.
 *
 * In order to reduce the number of time off requests returned in a single response, or to retrieve time off requests from a time period of interest, you may use the `start_date` and `end_date` parameters.
 *
 * You may provide both or either parameters to scope the returned data. For example:
 *
 * `?start_date='2019-01-01'`
 *
 * Returns all time off requests where the request start date is equal to or after January 1, 2019.
 *
 * `?end_date='2019-01-01'`
 *
 * Returns all time off requests where the request end date is equal to or before January 1, 2019.
 *
 * `?start_date='2019-05-01'&end_date='2019-08-31'`
 *
 * Returns all time off requests where the request start date is equal to or after May 1, 2019 and the request end date is equal to or before August 31, 2019.
 *
 * `scope: time_off_requests.read`
 */
export const getV1CompaniesCompanyIdTimeOffRequests = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdTimeOffRequestsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdTimeOffRequestsResponse,
    GetV1CompaniesCompanyIdTimeOffRequestsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/time_off_requests',
  });
};

/**
 * Get the current user
 * Returns information pertaining to the user associated with the provided access token.
 */
export const getV1Me = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetV1MeResponse, GetV1MeError, ThrowOnError>({
    ...options,
    url: '/v1/me',
  });
};

/**
 * Get the terms of service acceptance
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Returns whether the latest terms of service for Gusto Embedded Payroll has been accepted by the current user.
 */
export const getV1TermsOfService = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetV1TermsOfServiceResponse, GetV1TermsOfServiceError, ThrowOnError>({
    ...options,
    url: '/v1/terms_of_service',
  });
};

/**
 * Accept the latest terms of service
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Accepts the latest terms of service for Gusto Embedded Payroll for the current user.
 */
export const postV1TermsOfService = <ThrowOnError extends boolean = false>(
  options?: Options<unknown, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostV1TermsOfServiceResponse, PostV1TermsOfServiceError, ThrowOnError>({
    ...options,
    url: '/v1/terms_of_service',
  });
};

/**
 * Get an employee's federal taxes
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Get attributes relevant for an employee's federal taxes.
 */
export const getV1EmployeesEmployeeIdFederalTaxes = <ThrowOnError extends boolean = false>(
  options: Options<GetV1EmployeesEmployeeIdFederalTaxesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1EmployeesEmployeeIdFederalTaxesResponse,
    GetV1EmployeesEmployeeIdFederalTaxesError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_uuid}/federal_taxes',
  });
};

/**
 * Update an employee's federal taxes
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Update attributes relevant for an employee's federal taxes.
 */
export const putV1EmployeesEmployeeIdFederalTaxes = <ThrowOnError extends boolean = false>(
  options: Options<PutV1EmployeesEmployeeIdFederalTaxesData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1EmployeesEmployeeIdFederalTaxesResponse,
    PutV1EmployeesEmployeeIdFederalTaxesError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_uuid}/federal_taxes',
  });
};

/**
 * Get an employee's state taxes
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Get attributes relevant for an employee's state taxes.
 *
 * The data required to correctly calculate an employee's state taxes varies by both home and work location. This API returns information about each question that must be answered grouped by state. Mostly commonly, an employee lives and works in the same state and will only have questions for a single state. The response contains metadata about each question, the type of answer expected, and the current answer stored in Gusto for that question.
 *
 * Answers are represented by an array. Today, this array can only be empty or contain exactly one element, but is designed to allow for forward compatibility with effective-dated fields. Until effective dated answers are supported, the `valid_from` and `valid_up_to` must always be `"2010-01-01"` and `null` respectively.
 *
 */
export const getV1EmployeesEmployeeIdStateTaxes = <ThrowOnError extends boolean = false>(
  options: Options<GetV1EmployeesEmployeeIdStateTaxesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1EmployeesEmployeeIdStateTaxesResponse,
    GetV1EmployeesEmployeeIdStateTaxesError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_uuid}/state_taxes',
  });
};

/**
 * Update an employee's state taxes
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Update attributes relevant for an employee's state taxes.
 *
 * As described for the GET endpoint, the answers must be supplied in the effective-dated format, but currently only a single answer will be accepted - `valid_from` and `valid_up_to` must be `"2010-01-01"` and `null` respectively.
 *
 */
export const putV1EmployeesEmployeeIdStateTaxes = <ThrowOnError extends boolean = false>(
  options: Options<PutV1EmployeesEmployeeIdStateTaxesData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1EmployeesEmployeeIdStateTaxesResponse,
    PutV1EmployeesEmployeeIdStateTaxesError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_uuid}/state_taxes',
  });
};

/**
 * Get an employee's home address
 * The home address of an employee is used to determine certain tax information about them. Addresses are geocoded on create and update to ensure validity.
 *
 * `scope: employees.read`
 */
export const getV1EmployeesEmployeeIdHomeAddress = <ThrowOnError extends boolean = false>(
  options: Options<GetV1EmployeesEmployeeIdHomeAddressData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1EmployeesEmployeeIdHomeAddressResponse,
    GetV1EmployeesEmployeeIdHomeAddressError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/home_address',
  });
};

/**
 * Update an employee's home address
 * The home address of an employee is used to determine certain tax information about them. Addresses are geocoded on create and update to ensure validity.
 *
 * `scope: employees.write`
 */
export const putV1EmployeesEmployeeIdHomeAddress = <ThrowOnError extends boolean = false>(
  options: Options<PutV1EmployeesEmployeeIdHomeAddressData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1EmployeesEmployeeIdHomeAddressResponse,
    PutV1EmployeesEmployeeIdHomeAddressError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/home_address',
  });
};

/**
 * Get a company's payment configs
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Get fast payment limit (only applicable for 2-day payroll) and payment speed for the company.
 */
export const getV1CompanyPaymentConfigs = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompanyPaymentConfigsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompanyPaymentConfigsResponse,
    GetV1CompanyPaymentConfigsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_uuid}/payment_configs',
  });
};

/**
 * Update a company's payment configs
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Update fast payment limit (only applicable for 2-day payroll) and payment speed for the company.
 */
export const putV1CompanyPaymentConfigs = <ThrowOnError extends boolean = false>(
  options: Options<PutV1CompanyPaymentConfigsData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1CompanyPaymentConfigsResponse,
    PutV1CompanyPaymentConfigsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_uuid}/payment_configs',
  });
};

/**
 * Get the pay schedules for a company
 * The pay schedule object in Gusto captures the details of when employees work and when they should be paid. A company can have multiple pay schedules.
 *
 * `scope: payrolls.read`
 */
export const getV1CompaniesCompanyIdPaySchedules = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdPaySchedulesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdPaySchedulesResponse,
    GetV1CompaniesCompanyIdPaySchedulesError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/pay_schedules',
  });
};

/**
 * Create a new single pay schedule
 * Creates a new single default pay schedule for the company.
 *
 * This creates one pay schedule during company onboarding and cannot be used if the company has processed a payroll. Creating multiple pay schedules at this time is not supported. To change a pay schedule, the end user will need to login to Gusto to edit their pay schedule.
 *
 * Be sure to **[check state laws](https://www.dol.gov/agencies/whd/state/payday)** to know what schedule is right for your customers.
 *
 * This endpoint is in beta. Please contact developer-gws@gusto.com if you’d like to have more information and use it for production. Note, this may require you to enter a different agreement with Gusto
 */
export const postV1CompaniesCompanyIdPaySchedules = <ThrowOnError extends boolean = false>(
  options: Options<PostV1CompaniesCompanyIdPaySchedulesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV1CompaniesCompanyIdPaySchedulesResponse,
    PostV1CompaniesCompanyIdPaySchedulesError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/pay_schedules',
  });
};

/**
 * Get Company Industry Selection
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Get industry selection for the company.
 */
export const getV1CompanyIndustry = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompanyIndustryData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV1CompanyIndustryResponse, GetV1CompanyIndustryError, ThrowOnError>({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/industry_selection',
  });
};

/**
 * Update a company industry selection
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Update the company industry selection by passing in industry classification codes: [NAICS code](https://www.naics.com), [SICS code](https://siccode.com/) and industry title. Our UI is leveraging [Middesk API](https://docs.middesk.com/reference/introduction) to determine industry classification codes.
 */
export const putV1CompanyIndustry = <ThrowOnError extends boolean = false>(
  options: Options<PutV1CompanyIndustryData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutV1CompanyIndustryResponse, PutV1CompanyIndustryError, ThrowOnError>({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/industry_selection',
  });
};

/**
 * Get a pay schedule
 * The pay schedule object in Gusto captures the details of when employees work and when they should be paid. A company can have multiple pay schedules.
 *
 * `scope: payrolls.read`
 */
export const getV1CompaniesCompanyIdPaySchedulesPayScheduleId = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdPaySchedulesPayScheduleIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdPaySchedulesPayScheduleIdResponse,
    GetV1CompaniesCompanyIdPaySchedulesPayScheduleIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/pay_schedules/{pay_schedule_id_or_uuid}',
  });
};

/**
 * Update a pay schedule
 * Updates a pay schedule.
 *
 * This endpoint is in beta. Please contact developer-gws@gusto.com if you’d like to have more information and use it for production. Note, this may require you to enter a different agreement with Gusto
 */
export const putV1CompaniesCompanyIdPaySchedulesPayScheduleId = <ThrowOnError extends boolean = false>(
  options: Options<PutV1CompaniesCompanyIdPaySchedulesPayScheduleIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1CompaniesCompanyIdPaySchedulesPayScheduleIdResponse,
    PutV1CompaniesCompanyIdPaySchedulesPayScheduleIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/pay_schedules/{pay_schedule_id_or_uuid}',
  });
};

/**
 * Get all company bank accounts
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Returns company bank accounts. Currently we only support a single default bank account per company.
 */
export const getV1CompaniesCompanyIdBankAccounts = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdBankAccountsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdBankAccountsResponse,
    GetV1CompaniesCompanyIdBankAccountsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/bank_accounts',
  });
};

/**
 * Create a company bank account
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * This endpoint creates a new company bank account.
 * If a default bank account exists, the new bank account will replace it as the company's default funding method.
 * Upon being created, two verification deposits are automatically sent to the bank account, and the bank account's verification_status is 'awaiting_deposits'.
 * When the deposits are successfully transferred, the verification_status changes to 'ready_for_verification', at which point the verify endpoint can be used to verify the bank account.
 * After successful verification, the bank account's verification_status is 'verified'.
 */
export const postV1CompaniesCompanyIdBankAccounts = <ThrowOnError extends boolean = false>(
  options: Options<PostV1CompaniesCompanyIdBankAccountsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV1CompaniesCompanyIdBankAccountsResponse,
    PostV1CompaniesCompanyIdBankAccountsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/bank_accounts',
  });
};

/**
 * Verify a company bank account
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Verify a company bank account by confirming the two micro-deposits sent to the bank account. Note that the order of the two deposits specified in request parameters does not matter. There's a maximum of 5 verification attempts, after which we will automatically initiate a new set of micro-deposits and require the bank account to be verified with the new micro-deposits.
 *
 * ### Bank account verification in demo
 *
 * We provide the endpoint `POST '/v1/companies/{company_id_or_uuid}/bank_accounts/{bank_account_uuid}/send_test_deposits'` to facilitate bank account verification in the demo environment. This endpoint simulates the micro-deposits transfer and returns them in the reponse. You can call this endpoint as many times as you wish to retrieve the values of the two micro deposits.
 *
 * ```
 * POST '/v1/companies/89771af8-b964-472e-8064-554dfbcb56d9/bank_accounts/ade55e57-4800-4059-9ecd-fa29cfeb6dd2/send_test_deposits'
 *
 * {
 * "deposit_1": 0.02,
 * "deposit_2": 0.42
 * }
 * ```
 */
export const putV1CompaniesCompanyIdBankAccountsVerify = <ThrowOnError extends boolean = false>(
  options: Options<PutV1CompaniesCompanyIdBankAccountsVerifyData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1CompaniesCompanyIdBankAccountsVerifyResponse,
    PutV1CompaniesCompanyIdBankAccountsVerifyError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/bank_accounts/{bank_account_uuid}/verify',
  });
};

/**
 * Get all benefits supported by Gusto
 * Returns all benefits supported by Gusto.
 *
 * The benefit object in Gusto contains high level information about a particular benefit type and its tax considerations. When companies choose to offer a benefit, they are creating a Company Benefit object associated with a particular benefit.
 *
 * `scope: benefits.read`
 */
export const getV1Benefits = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetV1BenefitsResponse, GetV1BenefitsError, ThrowOnError>({
    ...options,
    url: '/v1/benefits',
  });
};

/**
 * Get a supported benefit by ID
 * Returns a benefit supported by Gusto.
 *
 * The benefit object in Gusto contains high level information about a particular benefit type and its tax considerations. When companies choose to offer a benefit, they are creating a Company Benefit object associated with a particular benefit.
 *
 * `scope: benefits.read`
 */
export const getV1BenefitsBenefitId = <ThrowOnError extends boolean = false>(
  options: Options<GetV1BenefitsBenefitIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV1BenefitsBenefitIdResponse, GetV1BenefitsBenefitIdError, ThrowOnError>({
    ...options,
    url: '/v1/benefits/{benefit_id}',
  });
};

/**
 * Get benefits for a company
 * Company benefits represent the benefits that a company is offering to employees. This ties together a particular supported benefit with the company-specific information for the offering of that benefit.
 *
 * Note that company benefits can be deactivated only when no employees are enrolled.
 *
 * `scope: company_benefits.read`
 */
export const getV1CompaniesCompanyIdCompanyBenefits = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdCompanyBenefitsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdCompanyBenefitsResponse,
    GetV1CompaniesCompanyIdCompanyBenefitsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/company_benefits',
  });
};

/**
 * Create a company benefit
 * Company benefits represent the benefits that a company is offering to employees. This ties together a particular supported benefit with the company-specific information for the offering of that benefit.
 *
 * Note that company benefits can be deactivated only when no employees are enrolled.
 *
 * `scope: company_benefits.write`
 */
export const postV1CompaniesCompanyIdCompanyBenefits = <ThrowOnError extends boolean = false>(
  options: Options<PostV1CompaniesCompanyIdCompanyBenefitsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV1CompaniesCompanyIdCompanyBenefitsResponse,
    PostV1CompaniesCompanyIdCompanyBenefitsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/company_benefits',
  });
};

/**
 * Get a company benefit
 * Company benefits represent the benefits that a company is offering to employees. This ties together a particular supported benefit with the company-specific information for the offering of that benefit.
 *
 * Note that company benefits can be deactivated only when no employees are enrolled.
 *
 * `scope: company_benefits.read`
 */
export const getV1CompanyBenefitsCompanyBenefitId = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompanyBenefitsCompanyBenefitIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompanyBenefitsCompanyBenefitIdResponse,
    GetV1CompanyBenefitsCompanyBenefitIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/company_benefits/{company_benefit_id}',
  });
};

/**
 * Update a company benefit
 * Company benefits represent the benefits that a company is offering to employees. This ties together a particular supported benefit with the company-specific information for the offering of that benefit.
 *
 * Note that company benefits can be deactivated only when no employees are enrolled.
 *
 * `scope: company_benefits:write`
 */
export const putV1CompanyBenefitsCompanyBenefitId = <ThrowOnError extends boolean = false>(
  options: Options<PutV1CompanyBenefitsCompanyBenefitIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1CompanyBenefitsCompanyBenefitIdResponse,
    PutV1CompanyBenefitsCompanyBenefitIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/company_benefits/{company_benefit_id}',
  });
};

/**
 * Get all earning types for a company
 * A payroll item in Gusto is associated to an earning type to name the type of earning described by the payroll item.
 *
 * #### Default Earning Type
 * Certain earning types are special because they have tax considerations. Those earning types are mostly the same for every company depending on its legal structure (LLC, Corporation, etc.)
 *
 * #### Custom Earning Type
 * Custom earning types are all the other earning types added specifically for a company.
 *
 * `scope: payrolls.read`
 */
export const getV1CompaniesCompanyIdEarningTypes = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdEarningTypesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdEarningTypesResponse,
    GetV1CompaniesCompanyIdEarningTypesError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/earning_types',
  });
};

/**
 * Create a custom earning type
 * Create a custom earning type.
 *
 * If an inactive earning type exists with the same name, this will reactivate it instead of creating a new one.
 *
 * `scope: payrolls:write`
 */
export const postV1CompaniesCompanyIdEarningTypes = <ThrowOnError extends boolean = false>(
  options: Options<PostV1CompaniesCompanyIdEarningTypesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV1CompaniesCompanyIdEarningTypesResponse,
    PostV1CompaniesCompanyIdEarningTypesError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/earning_types',
  });
};

/**
 * Update an earning type
 * Update an earning type.
 *
 * `scope: payrolls.write`
 */
export const putV1CompaniesCompanyIdEarningTypesEarningTypeUuid = <ThrowOnError extends boolean = false>(
  options: Options<PutV1CompaniesCompanyIdEarningTypesEarningTypeUuidData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1CompaniesCompanyIdEarningTypesEarningTypeUuidResponse,
    PutV1CompaniesCompanyIdEarningTypesEarningTypeUuidError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/earning_types/{earning_type_uuid}',
  });
};

/**
 * Deactivate an earning type
 * Deactivate an earning type.
 *
 * `scope: payrolls.write`
 */
export const deleteV1CompaniesCompanyIdEarningTypesEarningTypeUuid = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV1CompaniesCompanyIdEarningTypesEarningTypeUuidData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteV1CompaniesCompanyIdEarningTypesEarningTypeUuidResponse,
    DeleteV1CompaniesCompanyIdEarningTypesEarningTypeUuidError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/earning_types/{earning_type_uuid}',
  });
};

/**
 * Get an employee's benefits
 * Employee benefits represent an employee enrolled in a particular company benefit. It includes information specific to that employee’s enrollment.
 *
 * Returns an array of all employee benefits for this employee
 *
 * `scope: employee_benefits.read`
 */
export const getV1EmployeesEmployeeIdEmployeeBenefits = <ThrowOnError extends boolean = false>(
  options: Options<GetV1EmployeesEmployeeIdEmployeeBenefitsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1EmployeesEmployeeIdEmployeeBenefitsResponse,
    GetV1EmployeesEmployeeIdEmployeeBenefitsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/employee_benefits',
  });
};

/**
 * Create an employee benefit
 * Employee benefits represent an employee enrolled in a particular company benefit. It includes information specific to that employee’s enrollment.
 *
 * `scope: employee_benefits.write`
 */
export const postV1EmployeesEmployeeIdEmployeeBenefits = <ThrowOnError extends boolean = false>(
  options: Options<PostV1EmployeesEmployeeIdEmployeeBenefitsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV1EmployeesEmployeeIdEmployeeBenefitsResponse,
    PostV1EmployeesEmployeeIdEmployeeBenefitsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/employee_benefits',
  });
};

/**
 * Year-to-date Benefit Amounts from Different Company
 * Year-to-date benefit amounts from a different company represents the amount of money added to an employees plan during a current year, made outside of the current contribution when they were employed at a different company.
 *
 * `scope: employee_benefits.write`
 */
export const postEmployeeYtdBenefitAmountsFromDifferentCompany = <ThrowOnError extends boolean = false>(
  options: Options<PostEmployeeYtdBenefitAmountsFromDifferentCompanyData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostEmployeeYtdBenefitAmountsFromDifferentCompanyResponse,
    PostEmployeeYtdBenefitAmountsFromDifferentCompanyError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/ytd_benefit_amounts_from_different_company',
  });
};

/**
 * Get an employee benefit
 * Employee benefits represent an employee enrolled in a particular company benefit. It includes information specific to that employee’s enrollment.
 *
 * `scope: employee_benefits.read`
 */
export const getV1EmployeeBenefitsEmployeeBenefitId = <ThrowOnError extends boolean = false>(
  options: Options<GetV1EmployeeBenefitsEmployeeBenefitIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1EmployeeBenefitsEmployeeBenefitIdResponse,
    GetV1EmployeeBenefitsEmployeeBenefitIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employee_benefits/{employee_benefit_id}',
  });
};

/**
 * Update an employee benefit
 * Employee benefits represent an employee enrolled in a particular company benefit. It includes information specific to that employee’s enrollment.
 *
 * `scope: employee_benefits.write`
 */
export const putV1EmployeeBenefitsEmployeeBenefitId = <ThrowOnError extends boolean = false>(
  options: Options<PutV1EmployeeBenefitsEmployeeBenefitIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1EmployeeBenefitsEmployeeBenefitIdResponse,
    PutV1EmployeeBenefitsEmployeeBenefitIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employee_benefits/{employee_benefit_id}',
  });
};

/**
 * Delete an employee benefit
 * Employee benefits represent an employee enrolled in a particular company benefit. It includes information specific to that employee’s enrollment.
 *
 * `scope: employee_benefits.write`
 */
export const deleteV1EmployeeBenefitsEmployeeBenefitId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV1EmployeeBenefitsEmployeeBenefitIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteV1EmployeeBenefitsEmployeeBenefitIdResponse,
    DeleteV1EmployeeBenefitsEmployeeBenefitIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employee_benefits/{employee_benefit_id}',
  });
};

/**
 * Get pay periods for a company
 * Pay periods are the foundation of payroll. Compensation, time & attendance, taxes, and expense reports all rely on when they happened. To begin submitting information for a given payroll, we need to agree on the time period.
 *
 *
 * By default, this endpoint returns every current and past pay period for a company. Since companies can process payroll as often as every week, there can be up to 53 pay periods a year. If a company has been running payroll with Gusto for five years, this endpoint could return up to 265 pay periods. Use the `start_date` and `end_date` parameters to reduce the scope of the response.
 *
 * `scope: payrolls.read`
 */
export const getV1CompaniesCompanyIdPayPeriods = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdPayPeriodsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdPayPeriodsResponse,
    GetV1CompaniesCompanyIdPayPeriodsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/pay_periods',
  });
};

/**
 * Get all payrolls for a company
 * Returns all payrolls, current and past for a company.
 *
 * Notes:
 * * Hour and dollar amounts are returned as string representations of numeric decimals.
 * * Hours are represented to the thousands place; dollar amounts are represented to the cent.
 * * Every eligible compensation is returned for each employee. If no data has yet be inserted for a given field, it defaults to “0.00” (for fixed amounts) or “0.000” (for hours ).
 *
 * `scope: payrolls.read`
 */
export const getV1CompaniesCompanyIdPayrolls = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdPayrollsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdPayrollsResponse,
    GetV1CompaniesCompanyIdPayrollsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/payrolls',
  });
};

/**
 * Create an Off-Cycle Payroll
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Creates a new, unprocessed, off-cycle payroll.
 */
export const postV1CompaniesCompanyIdPayrolls = <ThrowOnError extends boolean = false>(
  options: Options<PostV1CompaniesCompanyIdPayrollsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV1CompaniesCompanyIdPayrollsResponse,
    PostV1CompaniesCompanyIdPayrollsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/payrolls',
  });
};

/**
 * Update a payroll by ID
 * This endpoint allows you to update information for one or more employees for a specific **unprocessed** payroll.
 *
 * `scope: payrolls.write`
 */
export const putV1CompaniesCompanyIdPayrolls = <ThrowOnError extends boolean = false>(
  options: Options<PutV1CompaniesCompanyIdPayrollsData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1CompaniesCompanyIdPayrollsResponse,
    PutV1CompaniesCompanyIdPayrollsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/payrolls/{payroll_id_or_uuid}',
  });
};

/**
 * Get a single payroll
 * Returns a payroll.
 *
 * Notes:
 * * Hour and dollar amounts are returned as string representations of numeric decimals.
 * * Hours are represented to the thousands place; dollar amounts are represented to the cent.
 * * Every eligible compensation is returned for each employee. If no data has yet be inserted for a given field, it defaults to “0.00” (for fixed amounts) or “0.000” (for hours ).
 *
 * `scope: payrolls.read`
 */
export const getV1CompaniesCompanyIdPayrollsPayrollId = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdPayrollsPayrollIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdPayrollsPayrollIdResponse,
    GetV1CompaniesCompanyIdPayrollsPayrollIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/payrolls/{payroll_id_or_uuid}',
  });
};

/**
 * Update a payroll
 * This endpoint allows you to update information for one or more employees for a specific **unprocessed** payroll.
 *
 * The payrolls are identified by their pay periods’ start_date and end_date. Both are required and must correspond with an existing, unprocessed payroll. *If the dates do not match, the entire request will be rejected.* This was an explicit design decision to remove any assumptions around the timespan for data sent.
 *
 * `scope: payrolls.write`
 */
export const putV1CompaniesCompanyIdPayrollsPayPeriodStartDatePayPeriodEndDate = <ThrowOnError extends boolean = false>(
  options: Options<PutV1CompaniesCompanyIdPayrollsPayPeriodStartDatePayPeriodEndDateData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1CompaniesCompanyIdPayrollsPayPeriodStartDatePayPeriodEndDateResponse,
    PutV1CompaniesCompanyIdPayrollsPayPeriodStartDatePayPeriodEndDateError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/payrolls/{pay_period_start_date}/{pay_period_end_date}',
  });
};

/**
 * Create a partner managed company
 * This endpoint is intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * ### Overview
 *
 * The partner managed company API provides a way to create a Gusto company that you can manage. This endpoint behaves similarly to [creating a company](../~1v1~1provision/post) in that it does the following:
 *
 * * Creates a new company in Gusto.
 * * Creates a new user in Gusto.
 * * Makes the new user the primary payroll administrator of the new company.
 *
 * Additionally, on successful creation of the company, this API will do the following:
 * * Creates a link between the partner and the company.
 * * Creates access tokens and refresh tokens that can be used immediately.
 *
 * In the response, you will receive the access token, the refresh token, and the uuid of the created company.
 *
 * ### Authentication
 *
 * Due to the nature of this endpoint, Gusto will provide partners with an API token and will permit partners to use API Token Authentication instead of OAuth to provision Gusto accounts. The API token is included in the authorization HTTP header with the Token scheme, e.g.:
 *
 * ```
 * Content-Type: application/json
 * Authorization: Token bbb286ff1a4fe6b84742b0d49b8d0d65bd0208d27d3d50333591df71
 * ```
 */
export const postV1PartnerManagedCompanies = <ThrowOnError extends boolean = false>(
  options?: Options<PostV1PartnerManagedCompaniesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV1PartnerManagedCompaniesResponse,
    PostV1PartnerManagedCompaniesError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/partner_managed_companies',
  });
};

/**
 * Create a company
 * ### Overview
 *
 * The company provisioning API provides a way to create a Gusto company as part of your integration. When you successfully call the API, the API does the following:
 *
 * * Creates a new company in Gusto.
 * * Creates a new user in Gusto.
 * * Makes the new user the primary payroll administrator of the new company.
 * * Sends a welcome email to the new user.
 *
 * In the response, you will receive an account claim URL. Redirect the user to this URL to complete their account setup inside of Gusto
 *
 * ### Authentication
 *
 * Due to the nature of this endpoint, Gusto will provide partners with an API token and will permit partners to use API Token Authentication instead of OAuth to provision Gusto accounts. The API token is included in the authorization HTTP header with the Token scheme, e.g.:
 *
 * ```
 * Content-Type: application/json
 * Authorization: Token bbb286ff1a4fe6b84742b0d49b8d0d65bd0208d27d3d50333591df71
 * ```
 */
export const postV1Provision = <ThrowOnError extends boolean = false>(
  options?: Options<PostV1ProvisionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostV1ProvisionResponse, PostV1ProvisionError, ThrowOnError>({
    ...options,
    url: '/v1/provision',
  });
};

/**
 * Get an employee's custom fields
 * Returns a list of the employee's custom fields.
 *
 * `scope: employees.read`
 */
export const getV1EmployeesEmployeeIdCustomFields = <ThrowOnError extends boolean = false>(
  options: Options<GetV1EmployeesEmployeeIdCustomFieldsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1EmployeesEmployeeIdCustomFieldsResponse,
    GetV1EmployeesEmployeeIdCustomFieldsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/custom_fields',
  });
};

/**
 * Get the custom fields of a company
 * Returns a list of the custom fields of the company. Useful when you need to know the schema of custom fields for an entire company
 *
 * `scope: companies.read`
 */
export const getV1CompaniesCompanyIdCustomFields = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdCustomFieldsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdCustomFieldsResponse,
    GetV1CompaniesCompanyIdCustomFieldsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/custom_fields',
  });
};

/**
 * Get a specific time off request
 * Details of a single time off request
 *
 * `scope: time_off_requests.read`
 */
export const getV1CompaniesCompanyIdTimeOffRequestsTimeOffRequestId = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdTimeOffRequestsTimeOffRequestIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdTimeOffRequestsTimeOffRequestIdResponse,
    GetV1CompaniesCompanyIdTimeOffRequestsTimeOffRequestIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/time_off_requests/{time_off_request_id}',
  });
};

/**
 * Calculate a Payroll
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Performs calculations for taxes, benefits, and deductions for an unprocessed payroll. The calculated payroll details provide a preview of the actual values that will be used when the payroll is run.
 *
 * This calculation is asynchronous and a sucessful request responds with a 202 HTTP status. To view the details of the calculated payroll, use the GET /v1/companies/{company_id}/payrolls/{payroll_id} endpoint with the *show_calculation=true* and *include=taxes,benefits,deductions* params.
 *
 * If the company is blocked from running payroll due to issues like incomplete setup, missing information or other compliance issues, the response will be 422 Unprocessable Entity with a categorization of the blockers in the form:
 *
 * ```
 * { "errors": { "missing_requirements": ["needs_onboarding", "invalid_signatory"] } }
 * ```
 */
export const putV1CompaniesCompanyIdPayrollsPayrollIdCalculate = <ThrowOnError extends boolean = false>(
  options: Options<PutV1CompaniesCompanyIdPayrollsPayrollIdCalculateData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1CompaniesCompanyIdPayrollsPayrollIdCalculateResponse,
    PutV1CompaniesCompanyIdPayrollsPayrollIdCalculateError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/payrolls/{payroll_id_or_uuid}/calculate',
  });
};

/**
 * Submit Payroll
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Submits an unprocessed payroll to be calculated and run. This submission is asynchronous and a sucessful request responds with a 202 HTTP status. Upon success, transitions the payroll to the `processed` state.
 *
 * If the company is blocked from running payroll due to issues like incomplete setup, missing information or other compliance issues, the response will be 422 Unprocessable Entity with a categorization of the blockers in the form:
 *
 * ```
 * { "errors": { "missing_requirements": ["needs_onboarding", "invalid_signatory"] } }
 * ```
 */
export const putV1CompaniesCompanyIdPayrollsPayrollIdSubmit = <ThrowOnError extends boolean = false>(
  options: Options<PutV1CompaniesCompanyIdPayrollsPayrollIdSubmitData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1CompaniesCompanyIdPayrollsPayrollIdSubmitResponse,
    PutV1CompaniesCompanyIdPayrollsPayrollIdSubmitError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/payrolls/{payroll_id_or_uuid}/submit',
  });
};

/**
 * Cancel a Payroll
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Transitions a `processed` payroll back to the `unprocessed` state. A payroll cannot be canceled once it has entered the `funded` state.
 *
 */
export const putApiV1CompaniesCompanyIdPayrollsPayrollIdCancel = <ThrowOnError extends boolean = false>(
  options: Options<PutApiV1CompaniesCompanyIdPayrollsPayrollIdCancelData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutApiV1CompaniesCompanyIdPayrollsPayrollIdCancelResponse,
    PutApiV1CompaniesCompanyIdPayrollsPayrollIdCancelError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/payrolls/{payroll_id_or_uuid}/cancel',
  });
};

/**
 * Get approved Payroll Reversals
 * Returns all approved Payroll Reversals for a Company.
 *
 * `scope: payrolls.read`
 */
export const getV1CompaniesCompanyIdOrUuidPayrollReversals = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdOrUuidPayrollReversalsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdOrUuidPayrollReversalsResponse,
    GetV1CompaniesCompanyIdOrUuidPayrollReversalsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/payroll_reversals',
  });
};

/**
 * Get all the admins at a company
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Returns a list of all the admins at a company
 */
export const getV1CompaniesCompanyIdAdmins = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdAdminsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdAdminsResponse,
    GetV1CompaniesCompanyIdAdminsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/admins',
  });
};

/**
 * Create an admin for the company.
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Creates a new admin for a company. If the email matches an existing user, this will create an admin account for the current user. Otherwise, this will create a new user.
 */
export const postV1CompaniesCompanyIdAdmins = <ThrowOnError extends boolean = false>(
  options: Options<PostV1CompaniesCompanyIdAdminsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV1CompaniesCompanyIdAdminsResponse,
    PostV1CompaniesCompanyIdAdminsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/admins',
  });
};

/**
 * Get Federal Tax Details
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Fetches attributes relevant for a company's federal taxes.
 */
export const getV1CompaniesCompanyIdOrUuidFederalTaxDetails = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyIdOrUuidFederalTaxDetailsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyIdOrUuidFederalTaxDetailsResponse,
    GetV1CompaniesCompanyIdOrUuidFederalTaxDetailsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/federal_tax_details',
  });
};

/**
 * Update Federal Tax Details
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Updates attributes relevant for a company's federal taxes. This information is required is to onboard a company for use with Gusto Embedded Payroll.
 */
export const putV1CompaniesCompanyIdOrUuidFederalTaxDetails = <ThrowOnError extends boolean = false>(
  options: Options<PutV1CompaniesCompanyIdOrUuidFederalTaxDetailsData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1CompaniesCompanyIdOrUuidFederalTaxDetailsResponse,
    PutV1CompaniesCompanyIdOrUuidFederalTaxDetailsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/federal_tax_details',
  });
};

/**
 * Get all employee bank accounts
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Returns all employee bank accounts.
 */
export const getV1EmployeesEmployeeIdBankAccounts = <ThrowOnError extends boolean = false>(
  options: Options<GetV1EmployeesEmployeeIdBankAccountsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1EmployeesEmployeeIdBankAccountsResponse,
    GetV1EmployeesEmployeeIdBankAccountsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/bank_accounts',
  });
};

/**
 * Create an employee bank account
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Creates an employee bank account. An employee can have multiple bank accounts. Note that creating an employee bank account will also update the employee's payment method.
 */
export const postV1EmployeesEmployeeIdBankAccounts = <ThrowOnError extends boolean = false>(
  options: Options<PostV1EmployeesEmployeeIdBankAccountsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV1EmployeesEmployeeIdBankAccountsResponse,
    PostV1EmployeesEmployeeIdBankAccountsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/bank_accounts',
  });
};

/**
 * Delete an employee bank account
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Deletes an employee bank account. To update an employee's bank account details, delete the bank account first and create a new one.
 */
export const deleteV1EmployeesEmployeeIdBankAccountsBankAccountId = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV1EmployeesEmployeeIdBankAccountsBankAccountIdData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteV1EmployeesEmployeeIdBankAccountsBankAccountIdResponse,
    DeleteV1EmployeesEmployeeIdBankAccountsBankAccountIdError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/bank_accounts/{bank_account_uuid}',
  });
};

/**
 * Get an employee's payment method
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Fetches an employee's payment method. An employee payment method describes how the payment should be split across the employee's associated bank accounts.
 */
export const getV1EmployeesEmployeeIdPaymentMethod = <ThrowOnError extends boolean = false>(
  options: Options<GetV1EmployeesEmployeeIdPaymentMethodData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1EmployeesEmployeeIdPaymentMethodResponse,
    GetV1EmployeesEmployeeIdPaymentMethodError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/payment_method',
  });
};

/**
 * Update an employee's payment method
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Updates an employee's payment method. Note that creating an employee bank account will also update the employee's payment method.
 */
export const putV1EmployeesEmployeeIdPaymentMethod = <ThrowOnError extends boolean = false>(
  options: Options<PutV1EmployeesEmployeeIdPaymentMethodData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1EmployeesEmployeeIdPaymentMethodResponse,
    PutV1EmployeesEmployeeIdPaymentMethodError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/payment_method',
  });
};

/**
 * Create a signatory
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Create a company signatory with complete information. A signatory can legally sign forms once the identity verification process is successful.
 */
export const postV1CompanySignatories = <ThrowOnError extends boolean = false>(
  options: Options<PostV1CompanySignatoriesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV1CompanySignatoriesResponse,
    PostV1CompanySignatoriesError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_uuid}/signatories',
  });
};

/**
 * Get all company signatories
 * This endpoint is in beta and intended for Gusto Embedded Payroll customers. Please apply for early access if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Returns company signatories. Currently we only support a single signatory per company.
 */
export const getV1CompaniesCompanyUuidSignatories = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompaniesCompanyUuidSignatoriesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1CompaniesCompanyUuidSignatoriesResponse,
    GetV1CompaniesCompanyUuidSignatoriesError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_uuid}/signatories',
  });
};

/**
 * Get all company forms
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Get a list of all company's forms
 */
export const getV1CompanyForms = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompanyFormsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV1CompanyFormsResponse, GetV1CompanyFormsError, ThrowOnError>({
    ...options,
    url: '/v1/companies/{company_id_or_uuid}/forms',
  });
};

/**
 * Get a company form
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Get a company form
 */
export const getV1CompanyForm = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompanyFormData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV1CompanyFormResponse, GetV1CompanyFormError, ThrowOnError>({
    ...options,
    url: '/v1/forms/{id_or_uuid}',
  });
};

/**
 * Get a form pdf
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Get the link to the form PDF
 */
export const getV1CompanyFormPdf = <ThrowOnError extends boolean = false>(
  options: Options<GetV1CompanyFormPdfData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV1CompanyFormPdfResponse, GetV1CompanyFormPdfError, ThrowOnError>({
    ...options,
    url: '/v1/forms/{id_or_uuid}/pdf',
  });
};

/**
 * Sign a company form
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Sign a company form
 */
export const putV1CompanyFormSign = <ThrowOnError extends boolean = false>(
  options: Options<PutV1CompanyFormSignData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutV1CompanyFormSignResponse, PutV1CompanyFormSignError, ThrowOnError>({
    ...options,
    url: '/v1/forms/{id_or_uuid}/sign',
  });
};

/**
 * Get all employee forms
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Get a list of all employee's forms
 */
export const getV1EmployeeForms = <ThrowOnError extends boolean = false>(
  options: Options<GetV1EmployeeFormsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV1EmployeeFormsResponse, GetV1EmployeeFormsError, ThrowOnError>({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/forms',
  });
};

/**
 * Get an employee form
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Get an employee form
 */
export const getV1EmployeeForm = <ThrowOnError extends boolean = false>(
  options: Options<GetV1EmployeeFormData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV1EmployeeFormResponse, GetV1EmployeeFormError, ThrowOnError>({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/forms/{id_or_uuid}',
  });
};

/**
 * Get the PDF of an employee's form
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Get the link to the form PDF
 */
export const getV1EmployeeFormPdf = <ThrowOnError extends boolean = false>(
  options: Options<GetV1EmployeeFormPdfData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetV1EmployeeFormPdfResponse, GetV1EmployeeFormPdfError, ThrowOnError>({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/forms/{id_or_uuid}/pdf',
  });
};

/**
 * Sign an employee form
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Sign a company form
 */
export const putV1EmployeeFormSign = <ThrowOnError extends boolean = false>(
  options: Options<PutV1EmployeeFormSignData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutV1EmployeeFormSignResponse, PutV1EmployeeFormSignError, ThrowOnError>({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/forms/{id_or_uuid}/sign',
  });
};

/**
 * Create a flow
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Generate a link to access a pre-built workflow in Gusto whitelabel UI. For security, all generated flows will expire within 1 hour of inactivity. Additionally, flows will be deactivated 24 hours from creation time. We currently support the following flow types
 * |   |   |   |   |
 * |---|---|---|---|
 * |__flow_type__|__entity_type__|__entity_uuid__|__Flow description__|
 * | **company_onboarding** | n/a | n/a | Full company onboarding flow |
 * | **add_addresses** | n/a | n/a | Manage company's work, mailing, and filing addresses |
 * | **federal_tax_setup** | n/a | n/a | Review and update company federal tax details |
 * | **select_industry** | n/a | n/a | Select the company industry |
 * | **add_bank_info** | n/a | n/a | Add bank info manually or via Plaid |
 * | **verify_bank_info** | n/a | n/a | Bank deposits verification |
 * | **add_employees** | n/a | n/a | Manage all employee onboarding |
 * | **state_setup** | n/a | n/a | Review and update company state taxes |
 * | **payroll_schedule** | n/a | n/a | Set company's payroll schedule |
 * | **sign_all_forms** | n/a | n/a | Add signatory and sign company documents |
 * | **employee_form_signing** | 'Employee' | employee's UUID | For employee to review and sign documents |
 */
export const postV1CompanyFlows = <ThrowOnError extends boolean = false>(
  options: Options<PostV1CompanyFlowsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostV1CompanyFlowsResponse, PostV1CompanyFlowsError, ThrowOnError>({
    ...options,
    url: '/v1/companies/{company_uuid}/flows',
  });
};

/**
 * Get an employee pay stub (pdf)
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Get an employee's pay stub for the specified payroll. By default, an application/pdf response will be returned. No other content types are currently supported, but may be supported in the future.
 *
 * scope: `payrolls:run`
 */
export const getV1PayrollsPayrollUuidEmployeesEmployeeUuidPayStub = <ThrowOnError extends boolean = false>(
  options: Options<GetV1PayrollsPayrollUuidEmployeesEmployeeUuidPayStubData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1PayrollsPayrollUuidEmployeesEmployeeUuidPayStubResponse,
    GetV1PayrollsPayrollUuidEmployeesEmployeeUuidPayStubError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/payrolls/{payroll_id_or_uuid}/employees/{employee_id_or_uuid}/pay_stub',
  });
};

/**
 * Invite a signatory
 * This endpoint is in beta and intended for Gusto Embedded Payroll customers. Please apply for early access if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Create a signatory with minimal information. This signatory can be invited to provide more information through the `PUT /v1/companies/{company_uuid}/signatories/{signatory_uuid}` endpoint. This will start the identity verification process and allow the signatory to be verified to sign documents.
 */
export const postV1CompaniesCompanyUuidSignatoriesInvite = <ThrowOnError extends boolean = false>(
  options: Options<PostV1CompaniesCompanyUuidSignatoriesInviteData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    PostV1CompaniesCompanyUuidSignatoriesInviteResponse,
    PostV1CompaniesCompanyUuidSignatoriesInviteError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_uuid}/signatories/invite',
  });
};

/**
 * Update a signatory
 * This endpoint is in beta and intended for Gusto Embedded Payroll customers. Please apply for early access if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Update a signatory that has been either invited or created. If the signatory has been created with minimal information through the `POST /v1/companies/{company_uuid}/signatories/invite` endpoint, then the first update must contain all attributes specified in the request body in order to start the identity verification process.
 */
export const putV1CompaniesCompanyUuidSignatoriesSignatoryUuid = <ThrowOnError extends boolean = false>(
  options: Options<PutV1CompaniesCompanyUuidSignatoriesSignatoryUuidData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    PutV1CompaniesCompanyUuidSignatoriesSignatoryUuidResponse,
    PutV1CompaniesCompanyUuidSignatoriesSignatoryUuidError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_uuid}/signatories/{signatory_uuid}',
  });
};

/**
 * Delete a signatory
 * This endpoint is in beta and intended for Gusto Embedded Payroll customers. Please apply for early access if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 * Delete a company signatory.
 */
export const deleteV1CompaniesCompanyUuidSignatoriesSignatoryUuid = <ThrowOnError extends boolean = false>(
  options: Options<DeleteV1CompaniesCompanyUuidSignatoriesSignatoryUuidData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    DeleteV1CompaniesCompanyUuidSignatoriesSignatoryUuidResponse,
    DeleteV1CompaniesCompanyUuidSignatoriesSignatoryUuidError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/companies/{company_uuid}/signatories/{signatory_uuid}',
  });
};

/**
 * Get the employee's onboarding status (Beta)
 * # Description
 * Retrieves an employee's onboarding status. The data returned helps inform the required onboarding steps and respective completion status.
 *
 * ## Beta Endpoint
 * This endpoint is in beta and intended for **[Gusto Embedded Payroll](https://gusto.com/embedded-payroll)** customers. Please [apply for early access](https://gusto-embedded-payroll.typeform.com/to/iomAQIj3?utm_source=docs) if you’d like to learn more and use it for production. Note, this endpoint will require you to enter a different agreement with Gusto.
 *
 */
export const getV1EmployeesEmployeeIdOrUuidOnboardingStatus = <ThrowOnError extends boolean = false>(
  options: Options<GetV1EmployeesEmployeeIdOrUuidOnboardingStatusData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetV1EmployeesEmployeeIdOrUuidOnboardingStatusResponse,
    GetV1EmployeesEmployeeIdOrUuidOnboardingStatusError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/employees/{employee_id_or_uuid}/onboarding_status',
  });
};
