// Generated by ts-to-zod
import { z } from 'zod';

export const departmentSchema = z.record(z.union([z.union([z.unknown(), z.number(), z.string()]), z.undefined()])).and(
  z.object({
    id: z.number(),
    name: z.string(),
    parent_id: z.string().optional().nullable(),
    parent_department_external_ids: z.string().optional().nullable(),
    child_ids: z.array(z.number()).optional().nullable(),
    child_department_external_ids: z.array(z.number()).optional().nullable(),
    external_id: z.string(),
    children: z.array(z.unknown()),
  }),
);

export const officeSchema = z.object({
  id: z.number(),
  name: z.string(),
  location: z.object({
    name: z.string(),
  }),
  parent_id: z.number(),
  child_ids: z.array(z.number()).optional().nullable(),
  external_id: z.string(),
});

export const openingSchema = z.object({
  id: z.number(),
  opening_id: z.string().nullable(),
  status: z.string(),
  opened_at: z.string(),
  closed_at: z.string(),
  application_id: z.number(),
  close_reason: z
    .object({
      id: z.number(),
      name: z.string(),
    })
    .nullable(),
});

export const hiringTeamSchema = z.object({
  hiring_managers: z.array(
    z.object({
      id: z.number(),
      first_name: z.string(),
      last_name: z.string(),
      name: z.string(),
      employee_id: z.string(),
      responsible: z.boolean().optional().nullable(),
    }),
  ),
  recruiters: z.array(
    z.object({
      id: z.number(),
      first_name: z.string(),
      last_name: z.string(),
      name: z.string(),
      employee_id: z.string(),
      responsible: z.boolean().optional().nullable(),
    }),
  ),
  coordinators: z.array(
    z.object({
      id: z.number(),
      first_name: z.string(),
      last_name: z.string(),
      name: z.string(),
      employee_id: z.string(),
      responsible: z.boolean().optional().nullable(),
    }),
  ),
  sourcers: z.array(
    z.object({
      id: z.number(),
      first_name: z.string(),
      last_name: z.string(),
      name: z.string(),
      employee_id: z.string(),
      responsible: z.boolean().optional().nullable(),
    }),
  ),
});

export const statusSchema = z.union([z.literal('open'), z.literal('closed'), z.literal('draft')]);

export const keyedCustomFieldsSchema = z.object({
  name: z.string(),
  type: z.string(),
  value: z.string(),
});

export const offerSchema = z.object({
  id: z.number(),
  version: z.number(),
  application_id: z.number(),
  job_id: z.number(),
  candidate_id: z.number(),
  opening: openingSchema,
  created_at: z.string(),
  updated_at: z.string(),
  sent_at: z.string(),
  resolved_at: z.string(),
  starts_at: z.string(),
  status: z.string(),
  custom_fields: z.record(z.unknown()),
  keyed_custom_fields: z.record(keyedCustomFieldsSchema),
});

export const attachmentSchema = z.object({
  filename: z.string(),
  url: z.string(),
  type: z.string(),
  created_at: z.string(),
});

export const getDepartmentDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
  query: z
    .object({
      render_as: z
        .union([z.literal('list'), z.literal('tree')])
        .optional()
        .nullable(),
    })
    .optional(),
});

export const getDepartmentResponseSchema = departmentSchema;

export const getDepartmentErrorSchema = z.unknown();

export const getDepartmentsDataSchema = z.object({
  query: z
    .object({
      external_id: z.string().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
      render_as: z
        .union([z.literal('list'), z.literal('tree')])
        .optional()
        .nullable(),
    })
    .optional(),
});

export const getDepartmentsResponseSchema = z.array(departmentSchema);

export const getDepartmentsErrorSchema = z.unknown();

export const getJobDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const jobSchema = z
  .record(
    z.union([
      z.union([
        z.unknown(),
        z.number(),
        z.string(),
        z.boolean(),
        officeSchema,
        openingSchema,
        keyedCustomFieldsSchema,
        hiringTeamSchema,
      ]),
      z.undefined(),
    ]),
  )
  .and(
    z.object({
      id: z.number(),
      name: z.string(),
      requisition_id: z.string(),
      notes: z.string(),
      confidential: z.boolean(),
      status: z.union([z.literal('open'), z.literal('closed'), z.literal('draft')]),
      created_at: z.string(),
      opened_at: z.string(),
      closed_at: z.string(),
      updated_at: z.string(),
      is_template: z.boolean().nullable(),
      copied_from_id: z.number(),
      departments: z.array(departmentSchema.nullable()),
      offices: z.array(officeSchema),
      openings: z.array(openingSchema),
      custom_fields: z.record(z.unknown()),
      keyed_custom_fields: z.record(keyedCustomFieldsSchema),
      hiring_team: hiringTeamSchema,
    }),
  );

export const getJobErrorSchema = z.unknown();

export const getJobsDataSchema = z.object({
  query: z
    .object({
      external_id: z.string().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
    })
    .optional(),
});

export const getJobsResponseSchema = z.array(jobSchema);

export const getJobsErrorSchema = z.unknown();

export const getOfferDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getOfferResponseSchema = offerSchema;

export const getOfferErrorSchema = z.unknown();

export const getOffersDataSchema = z.object({
  query: z
    .object({
      external_id: z.string().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
    })
    .optional(),
});

export const getOffersResponseSchema = z.array(offerSchema);

export const getOffersErrorSchema = z.unknown();

export const getCandidateDataSchema = z.object({
  path: z.object({
    id: z.string(),
  }),
});

export const getCandidateErrorSchema = z.unknown();

export const getCandidatesDataSchema = z.object({
  query: z
    .object({
      external_id: z.string().optional(),
      page: z.number().optional(),
      per_page: z.number().optional(),
    })
    .optional(),
});

export const getCandidatesErrorSchema = z.unknown();

export const applicationSchema = z.object({
  id: z.number(),
  candidate_id: z.number(),
  prospect: z.boolean(),
  applied_at: z.string(),
  rejected_at: z.string().nullable(),
  last_activity_at: z.string(),
  location: z.object({
    address: z.string(),
  }),
  source: z.object({
    id: z.number(),
    public_name: z.string(),
  }),
  credited_to: z.object({
    id: z.number(),
    first_name: z.string(),
    last_name: z.string(),
    name: z.string(),
    employee_id: z.string(),
  }),
  rejection_reason: z.string().nullable(),
  rejection_details: z.string().nullable(),
  jobs: z.array(
    z.object({
      id: z.number(),
      name: z.string(),
    }),
  ),
  job_post_id: z.number(),
  status: z.string(),
  current_stage: z.object({
    id: z.number(),
    name: z.string(),
  }),
  answers: z.array(
    z.object({
      question: z.string(),
      answer: z.string(),
    }),
  ),
  prospective_office: z.string().nullable(),
  prospective_department: z.string().nullable(),
  prospect_detail: z.object({
    prospect_pool: z.string().nullable(),
    prospect_stage: z.string().nullable(),
    prospect_owner: z.string().nullable(),
  }),
  custom_fields: z.object({
    application_custom_test: z.string().nullable(),
  }),
  keyed_custom_fields: z.object({
    application_custom_test: z.object({
      name: z.string(),
      type: z.string(),
      value: z.string(),
    }),
  }),
  attachments: z.array(attachmentSchema),
});

export const getJobResponseSchema = jobSchema;

export const candidateSchema = z
  .record(z.union([z.union([z.unknown(), z.number(), z.string(), z.boolean(), applicationSchema]), z.undefined()]))
  .and(
    z.object({
      id: z.number(),
      first_name: z.string(),
      last_name: z.string(),
      company: z.string(),
      title: z.string(),
      created_at: z.string(),
      updated_at: z.string(),
      last_activity: z.string(),
      is_private: z.boolean(),
      photo_url: z.string().nullable(),
      application_ids: z.array(z.number()),
      can_email: z.boolean(),
      tags: z.array(z.string()),
      attachments: z.array(
        z.object({
          filename: z.string(),
          url: z.string(),
          type: z.string(),
          created_at: z.string(),
        }),
      ),
      phone_numbers: z.array(
        z.object({
          value: z.string(),
          type: z.string().optional().nullable(),
        }),
      ),
      addresses: z.array(
        z.object({
          value: z.string(),
          type: z.string().optional().nullable(),
        }),
      ),
      email_addresses: z.array(
        z.object({
          value: z.string(),
          type: z.string().optional().nullable(),
        }),
      ),
      website_addresses: z.array(
        z.object({
          value: z.string(),
          type: z.string().optional().nullable(),
        }),
      ),
      social_media_addresses: z.array(
        z.object({
          value: z.string(),
          type: z.string().optional().nullable(),
        }),
      ),
      recruiter: z.object({
        id: z.number(),
        first_name: z.string(),
        last_name: z.string(),
        name: z.string(),
        employee_id: z.string(),
        responsible: z.boolean().optional().nullable(),
      }),
      coordinator: z.object({
        id: z.number(),
        first_name: z.string(),
        last_name: z.string(),
        name: z.string(),
        employee_id: z.string(),
        responsible: z.boolean().optional().nullable(),
      }),
      applications: z.array(applicationSchema),
    }),
  );

export const getCandidatesResponseSchema = z.array(candidateSchema);

export const getCandidateResponseSchema = candidateSchema;
