// This file is auto-generated by @hey-api/openapi-ts

export type department = {
  id: number;
  name: string;
  parent_id?: string | null;
  parent_department_external_ids?: string | null;
  child_ids?: Array<number> | null;
  child_department_external_ids?: Array<number> | null;
  external_id: string;
  children: Array<unknown>;
  [key: string]: (unknown | number | string) | undefined;
};

export type job = {
  /**
   * The job’s unique identifier
   */
  id: number;
  name: string;
  /**
   * An arbitrary ID provided by an external source; does not map to another entity within Greenhouse.
   */
  requisition_id: string;
  notes: string;
  /**
   * One of true, false. If the job is confidential or not.
   */
  confidential: boolean;
  status: 'open' | 'closed' | 'draft';
  created_at: string;
  opened_at: string;
  closed_at: string;
  updated_at: string;
  /**
   * Is this job designated as a template used to create other jobs. This may be true, false, or null. Null is an indication this job was created before template job feature.
   */
  is_template: boolean | null;
  /**
   * If this job was copied from another job, this field contains the id of the source job.
   */
  copied_from_id: number;
  departments: Array<department | null>;
  offices: Array<office>;
  openings: Array<opening>;
  custom_fields: {
    [key: string]: unknown;
  };
  keyed_custom_fields: {
    [key: string]: keyedCustomFields;
  };
  hiring_team: hiringTeam;
  [key: string]: (unknown | number | string | boolean | office | opening | keyedCustomFields | hiringTeam) | undefined;
};

export type status = 'open' | 'closed' | 'draft';

export type office = {
  id: number;
  name: string;
  location: {
    name: string;
  };
  parent_id: number;
  child_ids?: Array<number> | null;
  external_id: string;
};

export type opening = {
  id: number;
  opening_id: string | null;
  status: string;
  opened_at: string;
  closed_at: string;
  application_id: number;
  close_reason: {
    id: number;
    name: string;
  } | null;
};

export type keyedCustomFields = {
  name: string;
  type: string;
  value: string;
};

export type hiringTeam = {
  hiring_managers: Array<{
    id: number;
    first_name: string;
    last_name: string;
    name: string;
    employee_id: string;
    responsible?: boolean | null;
  }>;
  recruiters: Array<{
    id: number;
    first_name: string;
    last_name: string;
    name: string;
    employee_id: string;
    responsible?: boolean | null;
  }>;
  coordinators: Array<{
    id: number;
    first_name: string;
    last_name: string;
    name: string;
    employee_id: string;
    responsible?: boolean | null;
  }>;
  sourcers: Array<{
    id: number;
    first_name: string;
    last_name: string;
    name: string;
    employee_id: string;
    responsible?: boolean | null;
  }>;
};

export type offer = {
  id: number;
  version: number;
  application_id: number;
  job_id: number;
  candidate_id: number;
  opening: opening;
  created_at: string;
  updated_at: string;
  sent_at: string;
  resolved_at: string;
  starts_at: string;
  status: string;
  custom_fields: {
    [key: string]: unknown;
  };
  keyed_custom_fields: {
    [key: string]: keyedCustomFields;
  };
};

/**
 *
 * In Greenhouse Recruiting, a candidate is someone who applied for the job and is in the hiring pipeline. A prospect is someone who has not applied for a job but who you want to consider for future opportunities.
 *
 */
export type candidate = {
  id: number;
  first_name: string;
  last_name: string;
  company: string;
  title: string;
  created_at: string;
  updated_at: string;
  last_activity: string;
  is_private: boolean;
  photo_url: string | null;
  application_ids: Array<number>;
  can_email: boolean;
  tags: Array<string>;
  attachments: Array<{
    filename: string;
    url: string;
    type: string;
    created_at: string;
  }>;
  phone_numbers: Array<{
    value: string;
    type?: string | null;
  }>;
  addresses: Array<{
    value: string;
    type?: string | null;
  }>;
  email_addresses: Array<{
    value: string;
    type?: string | null;
  }>;
  website_addresses: Array<{
    value: string;
    type?: string | null;
  }>;
  social_media_addresses: Array<{
    value: string;
    type?: string | null;
  }>;
  recruiter: {
    id: number;
    first_name: string;
    last_name: string;
    name: string;
    employee_id: string;
    responsible?: boolean | null;
  };
  coordinator: {
    id: number;
    first_name: string;
    last_name: string;
    name: string;
    employee_id: string;
    responsible?: boolean | null;
  };
  applications: Array<application>;
  [key: string]: (unknown | number | string | boolean | application) | undefined;
};

export type application = {
  id: number;
  candidate_id: number;
  prospect: boolean;
  applied_at: string;
  rejected_at: null | string;
  last_activity_at: string;
  location: {
    address: string;
  };
  source: {
    id: number;
    public_name: string;
  };
  credited_to: {
    id: number;
    first_name: string;
    last_name: string;
    name: string;
    employee_id: string;
  };
  rejection_reason: null | string;
  rejection_details: null | string;
  jobs: Array<{
    id: number;
    name: string;
  }>;
  job_post_id: number;
  status: string;
  current_stage: {
    id: number;
    name: string;
  };
  answers: Array<{
    question: string;
    answer: string;
  }>;
  prospective_office: null | string;
  prospective_department: null | string;
  prospect_detail: {
    prospect_pool: null | string;
    prospect_stage: null | string;
    prospect_owner: null | string;
  };
  custom_fields: {
    application_custom_test: null | string;
  };
  keyed_custom_fields: {
    application_custom_test: {
      name: string;
      type: string;
      value: string;
    };
  };
  attachments: Array<attachment>;
};

export type attachment = {
  filename: string;
  url: string;
  type: string;
  created_at: string;
};

export type GetDepartmentData = {
  path: {
    /**
     * The ID of the department to retrieve
     */
    id: string;
  };
  query?: {
    /**
     * This parameter defines how to represent the list of departments. The default value is 'list’, which returns a flat list of departments. If this is set to 'tree’, departments are represented in a tree-like structure where they may include sub-departments as children.
     */
    render_as?: ('list' | 'tree') | null;
  };
};

export type GetDepartmentResponse = department;

export type GetDepartmentError = unknown;

export type GetDepartmentsData = {
  query?: {
    /**
     * If supplied, only return department(s) with that external ID.
     */
    external_id?: string;
    /**
     * A cursor for use in pagination. Returns the n-th chunk of per_page objects.
     */
    page?: number;
    /**
     * Return up to this number of objects per response. Must be an integer between 1 and 500. Defaults to 100.
     */
    per_page?: number;
    /**
     * This parameter defines how to represent the list of departments. The default value is 'list’, which returns a flat list of departments. If this is set to 'tree’, departments are represented in a tree-like structure where they may include sub-departments as children.
     */
    render_as?: ('list' | 'tree') | null;
  };
};

export type GetDepartmentsResponse = Array<department>;

export type GetDepartmentsError = unknown;

export type GetJobData = {
  path: {
    /**
     * The ID of the job to retrieve
     */
    id: string;
  };
};

export type GetJobResponse = job;

export type GetJobError = unknown;

export type GetJobsData = {
  query?: {
    /**
     * If supplied, only return department(s) with that external ID.
     */
    external_id?: string;
    /**
     * A cursor for use in pagination. Returns the n-th chunk of per_page objects.
     */
    page?: number;
    /**
     * Return up to this number of objects per response. Must be an integer between 1 and 500. Defaults to 100.
     */
    per_page?: number;
  };
};

export type GetJobsResponse = Array<job>;

export type GetJobsError = unknown;

export type GetOfferData = {
  path: {
    /**
     * The ID of the offer to retrieve
     */
    id: string;
  };
};

export type GetOfferResponse = offer;

export type GetOfferError = unknown;

export type GetOffersData = {
  query?: {
    /**
     * If supplied, only return department(s) with that external ID.
     */
    external_id?: string;
    /**
     * A cursor for use in pagination. Returns the n-th chunk of per_page objects.
     */
    page?: number;
    /**
     * Return up to this number of objects per response. Must be an integer between 1 and 500. Defaults to 100.
     */
    per_page?: number;
  };
};

export type GetOffersResponse = Array<offer>;

export type GetOffersError = unknown;

export type GetCandidateData = {
  path: {
    /**
     * The ID of the candidate to retrieve
     */
    id: string;
  };
};

export type GetCandidateResponse = candidate;

export type GetCandidateError = unknown;

export type GetCandidatesData = {
  query?: {
    /**
     * If supplied, only return department(s) with that external ID.
     */
    external_id?: string;
    /**
     * A cursor for use in pagination. Returns the n-th chunk of per_page objects.
     */
    page?: number;
    /**
     * Return up to this number of objects per response. Must be an integer between 1 and 500. Defaults to 100.
     */
    per_page?: number;
  };
};

export type GetCandidatesResponse = Array<candidate>;

export type GetCandidatesError = unknown;
