// Generated by ts-to-zod
import { z } from 'zod';

export const dataExecutionStatusSchema = z.object({
  errorCode: z
    .union([
      z.literal('DATA_EXECUTION_ERROR_CODE_UNSPECIFIED'),
      z.literal('TIMED_OUT'),
      z.literal('TOO_MANY_ROWS'),
      z.literal('TOO_MANY_COLUMNS'),
      z.literal('TOO_MANY_CELLS'),
      z.literal('ENGINE'),
      z.literal('PARAMETER_INVALID'),
      z.literal('UNSUPPORTED_DATA_TYPE'),
      z.literal('DUPLICATE_COLUMN_NAMES'),
      z.literal('INTERRUPTED'),
      z.literal('CONCURRENT_QUERY'),
      z.literal('OTHER'),
      z.literal('TOO_MANY_CHARS_PER_CELL'),
      z.literal('DATA_NOT_FOUND'),
      z.literal('PERMISSION_DENIED'),
      z.literal('MISSING_COLUMN_ALIAS'),
      z.literal('OBJECT_NOT_FOUND'),
      z.literal('OBJECT_IN_ERROR_STATE'),
      z.literal('OBJECT_SPEC_INVALID'),
    ])
    .optional(),
  errorMessage: z.string().optional(),
  lastRefreshTime: z.string().optional(),
  state: z
    .union([
      z.literal('DATA_EXECUTION_STATE_UNSPECIFIED'),
      z.literal('NOT_STARTED'),
      z.literal('RUNNING'),
      z.literal('SUCCEEDED'),
      z.literal('FAILED'),
    ])
    .optional(),
});

export const dimensionRangeSchema = z.object({
  dimension: z.union([z.literal('DIMENSION_UNSPECIFIED'), z.literal('ROWS'), z.literal('COLUMNS')]).optional(),
  endIndex: z.number().optional(),
  sheetId: z.number().optional(),
  startIndex: z.number().optional(),
});

export const dimensionGroupSchema = z.object({
  collapsed: z.boolean().optional(),
  depth: z.number().optional(),
  range: dimensionRangeSchema.optional(),
});

export const appendDimensionRequestSchema = z.object({
  dimension: z.union([z.literal('DIMENSION_UNSPECIFIED'), z.literal('ROWS'), z.literal('COLUMNS')]).optional(),
  length: z.number().optional(),
  sheetId: z.number().optional(),
});

export const dimensionSchema = z.union([z.literal('DIMENSION_UNSPECIFIED'), z.literal('ROWS'), z.literal('COLUMNS')]);

export const gridRangeSchema = z.object({
  endColumnIndex: z.number().optional(),
  endRowIndex: z.number().optional(),
  sheetId: z.number().optional(),
  startColumnIndex: z.number().optional(),
  startRowIndex: z.number().optional(),
});

export const sourceAndDestinationSchema = z.object({
  dimension: z.union([z.literal('DIMENSION_UNSPECIFIED'), z.literal('ROWS'), z.literal('COLUMNS')]).optional(),
  fillLength: z.number().optional(),
  source: gridRangeSchema.optional(),
});

export const colorSchema = z.object({
  alpha: z.number().optional(),
  blue: z.number().optional(),
  green: z.number().optional(),
  red: z.number().optional(),
});

export const colorStyleSchema = z.object({
  rgbColor: colorSchema.optional(),
  themeColor: z
    .union([
      z.literal('THEME_COLOR_TYPE_UNSPECIFIED'),
      z.literal('TEXT'),
      z.literal('BACKGROUND'),
      z.literal('ACCENT1'),
      z.literal('ACCENT2'),
      z.literal('ACCENT3'),
      z.literal('ACCENT4'),
      z.literal('ACCENT5'),
      z.literal('ACCENT6'),
      z.literal('LINK'),
    ])
    .optional(),
});

export const textPositionSchema = z.object({
  horizontalAlignment: z
    .union([z.literal('HORIZONTAL_ALIGN_UNSPECIFIED'), z.literal('LEFT'), z.literal('CENTER'), z.literal('RIGHT')])
    .optional(),
});

export const comparisonTypeSchema = z.union([
  z.literal('COMPARISON_TYPE_UNDEFINED'),
  z.literal('ABSOLUTE_DIFFERENCE'),
  z.literal('PERCENTAGE_DIFFERENCE'),
]);

export const chartAxisViewWindowOptionsSchema = z.object({
  viewWindowMax: z.number().optional(),
  viewWindowMin: z.number().optional(),
  viewWindowMode: z
    .union([
      z.literal('DEFAULT_VIEW_WINDOW_MODE'),
      z.literal('VIEW_WINDOW_MODE_UNSUPPORTED'),
      z.literal('EXPLICIT'),
      z.literal('PRETTY'),
    ])
    .optional(),
});

export const positionSchema = z.union([
  z.literal('BASIC_CHART_AXIS_POSITION_UNSPECIFIED'),
  z.literal('BOTTOM_AXIS'),
  z.literal('LEFT_AXIS'),
  z.literal('RIGHT_AXIS'),
]);

export const lineStyleSchema = z.object({
  type: z
    .union([
      z.literal('LINE_DASH_TYPE_UNSPECIFIED'),
      z.literal('INVISIBLE'),
      z.literal('CUSTOM'),
      z.literal('SOLID'),
      z.literal('DOTTED'),
      z.literal('MEDIUM_DASHED'),
      z.literal('MEDIUM_DASHED_DOTTED'),
      z.literal('LONG_DASHED'),
      z.literal('LONG_DASHED_DOTTED'),
    ])
    .optional(),
  width: z.number().optional(),
});

export const pointStyleSchema = z.object({
  shape: z
    .union([
      z.literal('POINT_SHAPE_UNSPECIFIED'),
      z.literal('CIRCLE'),
      z.literal('DIAMOND'),
      z.literal('HEXAGON'),
      z.literal('PENTAGON'),
      z.literal('SQUARE'),
      z.literal('STAR'),
      z.literal('TRIANGLE'),
      z.literal('X_MARK'),
    ])
    .optional(),
  size: z.number().optional(),
});

export const basicSeriesDataPointStyleOverrideSchema = z.object({
  color: colorSchema.optional(),
  colorStyle: colorStyleSchema.optional(),
  index: z.number().optional(),
  pointStyle: pointStyleSchema.optional(),
});

export const targetAxisSchema = z.union([
  z.literal('BASIC_CHART_AXIS_POSITION_UNSPECIFIED'),
  z.literal('BOTTOM_AXIS'),
  z.literal('LEFT_AXIS'),
  z.literal('RIGHT_AXIS'),
]);

export const typeSchema = z.union([
  z.literal('BASIC_CHART_TYPE_UNSPECIFIED'),
  z.literal('BAR'),
  z.literal('LINE'),
  z.literal('AREA'),
  z.literal('COLUMN'),
  z.literal('SCATTER'),
  z.literal('COMBO'),
  z.literal('STEPPED_AREA'),
]);

export const chartTypeSchema = z.union([
  z.literal('BASIC_CHART_TYPE_UNSPECIFIED'),
  z.literal('BAR'),
  z.literal('LINE'),
  z.literal('AREA'),
  z.literal('COLUMN'),
  z.literal('SCATTER'),
  z.literal('COMBO'),
  z.literal('STEPPED_AREA'),
]);

export const compareModeSchema = z.union([
  z.literal('BASIC_CHART_COMPARE_MODE_UNSPECIFIED'),
  z.literal('DATUM'),
  z.literal('CATEGORY'),
]);

export const legendPositionSchema = z.union([
  z.literal('BASIC_CHART_LEGEND_POSITION_UNSPECIFIED'),
  z.literal('BOTTOM_LEGEND'),
  z.literal('LEFT_LEGEND'),
  z.literal('RIGHT_LEGEND'),
  z.literal('TOP_LEGEND'),
  z.literal('NO_LEGEND'),
]);

export const stackedTypeSchema = z.union([
  z.literal('BASIC_CHART_STACKED_TYPE_UNSPECIFIED'),
  z.literal('NOT_STACKED'),
  z.literal('STACKED'),
  z.literal('PERCENT_STACKED'),
]);

export const batchClearValuesByDataFilterResponseSchema = z.object({
  clearedRanges: z.array(z.string()).optional(),
  spreadsheetId: z.string().optional(),
});

export const batchClearValuesRequestSchema = z.object({
  ranges: z.array(z.string()).optional(),
});

export const batchClearValuesResponseSchema = z.object({
  clearedRanges: z.array(z.string()).optional(),
  spreadsheetId: z.string().optional(),
});

export const dateTimeRenderOptionSchema = z.union([z.literal('SERIAL_NUMBER'), z.literal('FORMATTED_STRING')]);

export const majorDimensionSchema = z.union([
  z.literal('DIMENSION_UNSPECIFIED'),
  z.literal('ROWS'),
  z.literal('COLUMNS'),
]);

export const valueRenderOptionSchema = z.union([
  z.literal('FORMATTED_VALUE'),
  z.literal('UNFORMATTED_VALUE'),
  z.literal('FORMULA'),
]);

export const valueRangeSchema = z.object({
  majorDimension: z.union([z.literal('DIMENSION_UNSPECIFIED'), z.literal('ROWS'), z.literal('COLUMNS')]).optional(),
  range: z.string().optional(),
  values: z.array(z.array(z.unknown())).optional(),
});

export const responseDateTimeRenderOptionSchema = z.union([z.literal('SERIAL_NUMBER'), z.literal('FORMATTED_STRING')]);

export const responseValueRenderOptionSchema = z.union([
  z.literal('FORMATTED_VALUE'),
  z.literal('UNFORMATTED_VALUE'),
  z.literal('FORMULA'),
]);

export const valueInputOptionSchema = z.union([
  z.literal('INPUT_VALUE_OPTION_UNSPECIFIED'),
  z.literal('RAW'),
  z.literal('USER_ENTERED'),
]);

export const batchUpdateValuesRequestSchema = z.object({
  data: z.array(valueRangeSchema).optional(),
  includeValuesInResponse: z.boolean().optional(),
  responseDateTimeRenderOption: z.union([z.literal('SERIAL_NUMBER'), z.literal('FORMATTED_STRING')]).optional(),
  responseValueRenderOption: z
    .union([z.literal('FORMATTED_VALUE'), z.literal('UNFORMATTED_VALUE'), z.literal('FORMULA')])
    .optional(),
  valueInputOption: z
    .union([z.literal('INPUT_VALUE_OPTION_UNSPECIFIED'), z.literal('RAW'), z.literal('USER_ENTERED')])
    .optional(),
});

export const updateValuesResponseSchema = z.object({
  spreadsheetId: z.string().optional(),
  updatedCells: z.number().optional(),
  updatedColumns: z.number().optional(),
  updatedData: valueRangeSchema.optional(),
  updatedRange: z.string().optional(),
  updatedRows: z.number().optional(),
});

export const bigQueryQuerySpecSchema = z.object({
  rawQuery: z.string().optional(),
});

export const bigQueryTableSpecSchema = z.object({
  datasetId: z.string().optional(),
  tableId: z.string().optional(),
  tableProjectId: z.string().optional(),
});

export const conditionValueSchema = z.object({
  relativeDate: z
    .union([
      z.literal('RELATIVE_DATE_UNSPECIFIED'),
      z.literal('PAST_YEAR'),
      z.literal('PAST_MONTH'),
      z.literal('PAST_WEEK'),
      z.literal('YESTERDAY'),
      z.literal('TODAY'),
      z.literal('TOMORROW'),
    ])
    .optional(),
  userEnteredValue: z.string().optional(),
});

export const type2Schema = z.union([
  z.literal('CONDITION_TYPE_UNSPECIFIED'),
  z.literal('NUMBER_GREATER'),
  z.literal('NUMBER_GREATER_THAN_EQ'),
  z.literal('NUMBER_LESS'),
  z.literal('NUMBER_LESS_THAN_EQ'),
  z.literal('NUMBER_EQ'),
  z.literal('NUMBER_NOT_EQ'),
  z.literal('NUMBER_BETWEEN'),
  z.literal('NUMBER_NOT_BETWEEN'),
  z.literal('TEXT_CONTAINS'),
  z.literal('TEXT_NOT_CONTAINS'),
  z.literal('TEXT_STARTS_WITH'),
  z.literal('TEXT_ENDS_WITH'),
  z.literal('TEXT_EQ'),
  z.literal('TEXT_IS_EMAIL'),
  z.literal('TEXT_IS_URL'),
  z.literal('DATE_EQ'),
  z.literal('DATE_BEFORE'),
  z.literal('DATE_AFTER'),
  z.literal('DATE_ON_OR_BEFORE'),
  z.literal('DATE_ON_OR_AFTER'),
  z.literal('DATE_BETWEEN'),
  z.literal('DATE_NOT_BETWEEN'),
  z.literal('DATE_IS_VALID'),
  z.literal('ONE_OF_RANGE'),
  z.literal('ONE_OF_LIST'),
  z.literal('BLANK'),
  z.literal('NOT_BLANK'),
  z.literal('CUSTOM_FORMULA'),
  z.literal('BOOLEAN'),
  z.literal('TEXT_NOT_EQ'),
  z.literal('DATE_NOT_EQ'),
  z.literal('FILTER_EXPRESSION'),
]);

export const booleanConditionSchema = z.object({
  type: z
    .union([
      z.literal('CONDITION_TYPE_UNSPECIFIED'),
      z.literal('NUMBER_GREATER'),
      z.literal('NUMBER_GREATER_THAN_EQ'),
      z.literal('NUMBER_LESS'),
      z.literal('NUMBER_LESS_THAN_EQ'),
      z.literal('NUMBER_EQ'),
      z.literal('NUMBER_NOT_EQ'),
      z.literal('NUMBER_BETWEEN'),
      z.literal('NUMBER_NOT_BETWEEN'),
      z.literal('TEXT_CONTAINS'),
      z.literal('TEXT_NOT_CONTAINS'),
      z.literal('TEXT_STARTS_WITH'),
      z.literal('TEXT_ENDS_WITH'),
      z.literal('TEXT_EQ'),
      z.literal('TEXT_IS_EMAIL'),
      z.literal('TEXT_IS_URL'),
      z.literal('DATE_EQ'),
      z.literal('DATE_BEFORE'),
      z.literal('DATE_AFTER'),
      z.literal('DATE_ON_OR_BEFORE'),
      z.literal('DATE_ON_OR_AFTER'),
      z.literal('DATE_BETWEEN'),
      z.literal('DATE_NOT_BETWEEN'),
      z.literal('DATE_IS_VALID'),
      z.literal('ONE_OF_RANGE'),
      z.literal('ONE_OF_LIST'),
      z.literal('BLANK'),
      z.literal('NOT_BLANK'),
      z.literal('CUSTOM_FORMULA'),
      z.literal('BOOLEAN'),
      z.literal('TEXT_NOT_EQ'),
      z.literal('DATE_NOT_EQ'),
      z.literal('FILTER_EXPRESSION'),
    ])
    .optional(),
  values: z.array(conditionValueSchema).optional(),
});

export const borderSchema = z.object({
  color: colorSchema.optional(),
  colorStyle: colorStyleSchema.optional(),
  style: z
    .union([
      z.literal('STYLE_UNSPECIFIED'),
      z.literal('DOTTED'),
      z.literal('DASHED'),
      z.literal('SOLID'),
      z.literal('SOLID_MEDIUM'),
      z.literal('SOLID_THICK'),
      z.literal('NONE'),
      z.literal('DOUBLE'),
    ])
    .optional(),
  width: z.number().optional(),
});

export const styleSchema = z.union([
  z.literal('STYLE_UNSPECIFIED'),
  z.literal('DOTTED'),
  z.literal('DASHED'),
  z.literal('SOLID'),
  z.literal('SOLID_MEDIUM'),
  z.literal('SOLID_THICK'),
  z.literal('NONE'),
  z.literal('DOUBLE'),
]);

export const bordersSchema = z.object({
  bottom: borderSchema.optional(),
  left: borderSchema.optional(),
  right: borderSchema.optional(),
  top: borderSchema.optional(),
});

export const legendPosition2Schema = z.union([
  z.literal('BUBBLE_CHART_LEGEND_POSITION_UNSPECIFIED'),
  z.literal('BOTTOM_LEGEND'),
  z.literal('LEFT_LEGEND'),
  z.literal('RIGHT_LEGEND'),
  z.literal('TOP_LEGEND'),
  z.literal('NO_LEGEND'),
  z.literal('INSIDE_LEGEND'),
]);

export const dataSourceFormulaSchema = z.object({
  dataExecutionStatus: dataExecutionStatusSchema.optional(),
  dataSourceId: z.string().optional(),
});

export const dataValidationRuleSchema = z.object({
  condition: booleanConditionSchema.optional(),
  inputMessage: z.string().optional(),
  showCustomUi: z.boolean().optional(),
  strict: z.boolean().optional(),
});

export const numberFormatSchema = z.object({
  pattern: z.string().optional(),
  type: z
    .union([
      z.literal('NUMBER_FORMAT_TYPE_UNSPECIFIED'),
      z.literal('TEXT'),
      z.literal('NUMBER'),
      z.literal('PERCENT'),
      z.literal('CURRENCY'),
      z.literal('DATE'),
      z.literal('TIME'),
      z.literal('DATE_TIME'),
      z.literal('SCIENTIFIC'),
    ])
    .optional(),
});

export const paddingSchema = z.object({
  bottom: z.number().optional(),
  left: z.number().optional(),
  right: z.number().optional(),
  top: z.number().optional(),
});

export const textRotationSchema = z.object({
  angle: z.number().optional(),
  vertical: z.boolean().optional(),
});

export const horizontalAlignmentSchema = z.union([
  z.literal('HORIZONTAL_ALIGN_UNSPECIFIED'),
  z.literal('LEFT'),
  z.literal('CENTER'),
  z.literal('RIGHT'),
]);

export const hyperlinkDisplayTypeSchema = z.union([
  z.literal('HYPERLINK_DISPLAY_TYPE_UNSPECIFIED'),
  z.literal('LINKED'),
  z.literal('PLAIN_TEXT'),
]);

export const textDirectionSchema = z.union([
  z.literal('TEXT_DIRECTION_UNSPECIFIED'),
  z.literal('LEFT_TO_RIGHT'),
  z.literal('RIGHT_TO_LEFT'),
]);

export const verticalAlignmentSchema = z.union([
  z.literal('VERTICAL_ALIGN_UNSPECIFIED'),
  z.literal('TOP'),
  z.literal('MIDDLE'),
  z.literal('BOTTOM'),
]);

export const wrapStrategySchema = z.union([
  z.literal('WRAP_STRATEGY_UNSPECIFIED'),
  z.literal('OVERFLOW_CELL'),
  z.literal('LEGACY_WRAP'),
  z.literal('CLIP'),
  z.literal('WRAP'),
]);

export const viewWindowModeSchema = z.union([
  z.literal('DEFAULT_VIEW_WINDOW_MODE'),
  z.literal('VIEW_WINDOW_MODE_UNSUPPORTED'),
  z.literal('EXPLICIT'),
  z.literal('PRETTY'),
]);

export const chartCustomNumberFormatOptionsSchema = z.object({
  prefix: z.string().optional(),
  suffix: z.string().optional(),
});

export const dataSourceColumnReferenceSchema = z.object({
  name: z.string().optional(),
});

export const chartSourceRangeSchema = z.object({
  sources: z.array(gridRangeSchema).optional(),
});

export const aggregateTypeSchema = z.union([
  z.literal('CHART_AGGREGATE_TYPE_UNSPECIFIED'),
  z.literal('AVERAGE'),
  z.literal('COUNT'),
  z.literal('MAX'),
  z.literal('MEDIAN'),
  z.literal('MIN'),
  z.literal('SUM'),
]);

export const chartDateTimeRuleSchema = z.object({
  type: z
    .union([
      z.literal('CHART_DATE_TIME_RULE_TYPE_UNSPECIFIED'),
      z.literal('SECOND'),
      z.literal('MINUTE'),
      z.literal('HOUR'),
      z.literal('HOUR_MINUTE'),
      z.literal('HOUR_MINUTE_AMPM'),
      z.literal('DAY_OF_WEEK'),
      z.literal('DAY_OF_YEAR'),
      z.literal('DAY_OF_MONTH'),
      z.literal('DAY_MONTH'),
      z.literal('MONTH'),
      z.literal('QUARTER'),
      z.literal('YEAR'),
      z.literal('YEAR_MONTH'),
      z.literal('YEAR_QUARTER'),
      z.literal('YEAR_MONTH_DAY'),
    ])
    .optional(),
});

export const type3Schema = z.union([
  z.literal('CHART_DATE_TIME_RULE_TYPE_UNSPECIFIED'),
  z.literal('SECOND'),
  z.literal('MINUTE'),
  z.literal('HOUR'),
  z.literal('HOUR_MINUTE'),
  z.literal('HOUR_MINUTE_AMPM'),
  z.literal('DAY_OF_WEEK'),
  z.literal('DAY_OF_YEAR'),
  z.literal('DAY_OF_MONTH'),
  z.literal('DAY_MONTH'),
  z.literal('MONTH'),
  z.literal('QUARTER'),
  z.literal('YEAR'),
  z.literal('YEAR_MONTH'),
  z.literal('YEAR_QUARTER'),
  z.literal('YEAR_MONTH_DAY'),
]);

export const chartHistogramRuleSchema = z.object({
  intervalSize: z.number().optional(),
  maxValue: z.number().optional(),
  minValue: z.number().optional(),
});

export const dataSourceChartPropertiesSchema = z.object({
  dataExecutionStatus: dataExecutionStatusSchema.optional(),
  dataSourceId: z.string().optional(),
});

export const sortSpecSchema = z.object({
  backgroundColor: colorSchema.optional(),
  backgroundColorStyle: colorStyleSchema.optional(),
  dataSourceColumnReference: dataSourceColumnReferenceSchema.optional(),
  dimensionIndex: z.number().optional(),
  foregroundColor: colorSchema.optional(),
  foregroundColorStyle: colorStyleSchema.optional(),
  sortOrder: z.union([z.literal('SORT_ORDER_UNSPECIFIED'), z.literal('ASCENDING'), z.literal('DESCENDING')]).optional(),
});

export const hiddenDimensionStrategySchema = z.union([
  z.literal('CHART_HIDDEN_DIMENSION_STRATEGY_UNSPECIFIED'),
  z.literal('SKIP_HIDDEN_ROWS_AND_COLUMNS'),
  z.literal('SKIP_HIDDEN_ROWS'),
  z.literal('SKIP_HIDDEN_COLUMNS'),
  z.literal('SHOW_ALL'),
]);

export const clearBasicFilterRequestSchema = z.object({
  sheetId: z.number().optional(),
});

export const clearValuesRequestSchema = z.record(z.unknown());

export const clearValuesResponseSchema = z.object({
  clearedRange: z.string().optional(),
  spreadsheetId: z.string().optional(),
});

export const themeColorSchema = z.union([
  z.literal('THEME_COLOR_TYPE_UNSPECIFIED'),
  z.literal('TEXT'),
  z.literal('BACKGROUND'),
  z.literal('ACCENT1'),
  z.literal('ACCENT2'),
  z.literal('ACCENT3'),
  z.literal('ACCENT4'),
  z.literal('ACCENT5'),
  z.literal('ACCENT6'),
  z.literal('LINK'),
]);

export const relativeDateSchema = z.union([
  z.literal('RELATIVE_DATE_UNSPECIFIED'),
  z.literal('PAST_YEAR'),
  z.literal('PAST_MONTH'),
  z.literal('PAST_WEEK'),
  z.literal('YESTERDAY'),
  z.literal('TODAY'),
  z.literal('TOMORROW'),
]);

export const copyPasteRequestSchema = z.object({
  destination: gridRangeSchema.optional(),
  pasteOrientation: z.union([z.literal('NORMAL'), z.literal('TRANSPOSE')]).optional(),
  pasteType: z
    .union([
      z.literal('PASTE_NORMAL'),
      z.literal('PASTE_VALUES'),
      z.literal('PASTE_FORMAT'),
      z.literal('PASTE_NO_BORDERS'),
      z.literal('PASTE_FORMULA'),
      z.literal('PASTE_DATA_VALIDATION'),
      z.literal('PASTE_CONDITIONAL_FORMATTING'),
    ])
    .optional(),
  source: gridRangeSchema.optional(),
});

export const pasteOrientationSchema = z.union([z.literal('NORMAL'), z.literal('TRANSPOSE')]);

export const pasteTypeSchema = z.union([
  z.literal('PASTE_NORMAL'),
  z.literal('PASTE_VALUES'),
  z.literal('PASTE_FORMAT'),
  z.literal('PASTE_NO_BORDERS'),
  z.literal('PASTE_FORMULA'),
  z.literal('PASTE_DATA_VALIDATION'),
  z.literal('PASTE_CONDITIONAL_FORMATTING'),
]);

export const copySheetToAnotherSpreadsheetRequestSchema = z.object({
  destinationSpreadsheetId: z.string().optional(),
});

export const gridCoordinateSchema = z.object({
  columnIndex: z.number().optional(),
  rowIndex: z.number().optional(),
  sheetId: z.number().optional(),
});

export const errorCodeSchema = z.union([
  z.literal('DATA_EXECUTION_ERROR_CODE_UNSPECIFIED'),
  z.literal('TIMED_OUT'),
  z.literal('TOO_MANY_ROWS'),
  z.literal('TOO_MANY_COLUMNS'),
  z.literal('TOO_MANY_CELLS'),
  z.literal('ENGINE'),
  z.literal('PARAMETER_INVALID'),
  z.literal('UNSUPPORTED_DATA_TYPE'),
  z.literal('DUPLICATE_COLUMN_NAMES'),
  z.literal('INTERRUPTED'),
  z.literal('CONCURRENT_QUERY'),
  z.literal('OTHER'),
  z.literal('TOO_MANY_CHARS_PER_CELL'),
  z.literal('DATA_NOT_FOUND'),
  z.literal('PERMISSION_DENIED'),
  z.literal('MISSING_COLUMN_ALIAS'),
  z.literal('OBJECT_NOT_FOUND'),
  z.literal('OBJECT_IN_ERROR_STATE'),
  z.literal('OBJECT_SPEC_INVALID'),
]);

export const stateSchema = z.union([
  z.literal('DATA_EXECUTION_STATE_UNSPECIFIED'),
  z.literal('NOT_STARTED'),
  z.literal('RUNNING'),
  z.literal('SUCCEEDED'),
  z.literal('FAILED'),
]);

export const placementSchema = z.union([
  z.literal('DATA_LABEL_PLACEMENT_UNSPECIFIED'),
  z.literal('CENTER'),
  z.literal('LEFT'),
  z.literal('RIGHT'),
  z.literal('ABOVE'),
  z.literal('BELOW'),
  z.literal('INSIDE_END'),
  z.literal('INSIDE_BASE'),
  z.literal('OUTSIDE_END'),
]);

export const type4Schema = z.union([
  z.literal('DATA_LABEL_TYPE_UNSPECIFIED'),
  z.literal('NONE'),
  z.literal('DATA'),
  z.literal('CUSTOM'),
]);

export const dataSourceColumnSchema = z.object({
  formula: z.string().optional(),
  reference: dataSourceColumnReferenceSchema.optional(),
});

export const dataSourceObjectReferenceSchema = z.object({
  chartId: z.number().optional(),
  dataSourceFormulaCell: gridCoordinateSchema.optional(),
  dataSourcePivotTableAnchorCell: gridCoordinateSchema.optional(),
  dataSourceTableAnchorCell: gridCoordinateSchema.optional(),
  sheetId: z.string().optional(),
});

export const dataSourceObjectReferencesSchema = z.object({
  references: z.array(dataSourceObjectReferenceSchema).optional(),
});

export const dataSourceParameterSchema = z.object({
  name: z.string().optional(),
  namedRangeId: z.string().optional(),
  range: gridRangeSchema.optional(),
});

export const timeOfDaySchema = z.object({
  hours: z.number().optional(),
  minutes: z.number().optional(),
  nanos: z.number().optional(),
  seconds: z.number().optional(),
});

export const dataSourceRefreshMonthlyScheduleSchema = z.object({
  daysOfMonth: z.array(z.number()).optional(),
  startTime: timeOfDaySchema.optional(),
});

export const dataSourceRefreshDailyScheduleSchema = z.object({
  startTime: timeOfDaySchema.optional(),
});

export const intervalSchema = z.object({
  endTime: z.string().optional(),
  startTime: z.string().optional(),
});

export const dataSourceRefreshWeeklyScheduleSchema = z.object({
  daysOfWeek: z
    .array(
      z.union([
        z.literal('DAY_OF_WEEK_UNSPECIFIED'),
        z.literal('MONDAY'),
        z.literal('TUESDAY'),
        z.literal('WEDNESDAY'),
        z.literal('THURSDAY'),
        z.literal('FRIDAY'),
        z.literal('SATURDAY'),
        z.literal('SUNDAY'),
      ]),
    )
    .optional(),
  startTime: timeOfDaySchema.optional(),
});

export const refreshScopeSchema = z.union([
  z.literal('DATA_SOURCE_REFRESH_SCOPE_UNSPECIFIED'),
  z.literal('ALL_DATA_SOURCES'),
]);

export const dataSourceSheetDimensionRangeSchema = z.object({
  columnReferences: z.array(dataSourceColumnReferenceSchema).optional(),
  sheetId: z.number().optional(),
});

export const dataSourceSheetPropertiesSchema = z.object({
  columns: z.array(dataSourceColumnSchema).optional(),
  dataExecutionStatus: dataExecutionStatusSchema.optional(),
  dataSourceId: z.string().optional(),
});

export const bigQueryDataSourceSpecSchema = z.object({
  projectId: z.string().optional(),
  querySpec: bigQueryQuerySpecSchema.optional(),
  tableSpec: bigQueryTableSpecSchema.optional(),
});

export const columnSelectionTypeSchema = z.union([
  z.literal('DATA_SOURCE_TABLE_COLUMN_SELECTION_TYPE_UNSPECIFIED'),
  z.literal('SELECTED'),
  z.literal('SYNC_ALL'),
]);

export const dateTimeRuleSchema = z.object({
  type: z
    .union([
      z.literal('DATE_TIME_RULE_TYPE_UNSPECIFIED'),
      z.literal('SECOND'),
      z.literal('MINUTE'),
      z.literal('HOUR'),
      z.literal('HOUR_MINUTE'),
      z.literal('HOUR_MINUTE_AMPM'),
      z.literal('DAY_OF_WEEK'),
      z.literal('DAY_OF_YEAR'),
      z.literal('DAY_OF_MONTH'),
      z.literal('DAY_MONTH'),
      z.literal('MONTH'),
      z.literal('QUARTER'),
      z.literal('YEAR'),
      z.literal('YEAR_MONTH'),
      z.literal('YEAR_QUARTER'),
      z.literal('YEAR_MONTH_DAY'),
    ])
    .optional(),
});

export const type5Schema = z.union([
  z.literal('DATE_TIME_RULE_TYPE_UNSPECIFIED'),
  z.literal('SECOND'),
  z.literal('MINUTE'),
  z.literal('HOUR'),
  z.literal('HOUR_MINUTE'),
  z.literal('HOUR_MINUTE_AMPM'),
  z.literal('DAY_OF_WEEK'),
  z.literal('DAY_OF_YEAR'),
  z.literal('DAY_OF_MONTH'),
  z.literal('DAY_MONTH'),
  z.literal('MONTH'),
  z.literal('QUARTER'),
  z.literal('YEAR'),
  z.literal('YEAR_MONTH'),
  z.literal('YEAR_QUARTER'),
  z.literal('YEAR_MONTH_DAY'),
]);

export const deleteBandingRequestSchema = z.object({
  bandedRangeId: z.number().optional(),
});

export const deleteConditionalFormatRuleRequestSchema = z.object({
  index: z.number().optional(),
  sheetId: z.number().optional(),
});

export const deleteDataSourceRequestSchema = z.object({
  dataSourceId: z.string().optional(),
});

export const deleteDimensionGroupRequestSchema = z.object({
  range: dimensionRangeSchema.optional(),
});

export const deleteDimensionGroupResponseSchema = z.object({
  dimensionGroups: z.array(dimensionGroupSchema).optional(),
});

export const deleteDimensionRequestSchema = z.object({
  range: dimensionRangeSchema.optional(),
});

export const deleteDuplicatesRequestSchema = z.object({
  comparisonColumns: z.array(dimensionRangeSchema).optional(),
  range: gridRangeSchema.optional(),
});

export const deleteDuplicatesResponseSchema = z.object({
  duplicatesRemovedCount: z.number().optional(),
});

export const deleteEmbeddedObjectRequestSchema = z.object({
  objectId: z.number().optional(),
});

export const deleteFilterViewRequestSchema = z.object({
  filterId: z.number().optional(),
});

export const deleteNamedRangeRequestSchema = z.object({
  namedRangeId: z.string().optional(),
});

export const deleteProtectedRangeRequestSchema = z.object({
  protectedRangeId: z.number().optional(),
});

export const deleteRangeRequestSchema = z.object({
  range: gridRangeSchema.optional(),
  shiftDimension: z.union([z.literal('DIMENSION_UNSPECIFIED'), z.literal('ROWS'), z.literal('COLUMNS')]).optional(),
});

export const shiftDimensionSchema = z.union([
  z.literal('DIMENSION_UNSPECIFIED'),
  z.literal('ROWS'),
  z.literal('COLUMNS'),
]);

export const deleteSheetRequestSchema = z.object({
  sheetId: z.number().optional(),
});

export const developerMetadataLocationSchema = z.object({
  dimensionRange: dimensionRangeSchema.optional(),
  locationType: z
    .union([
      z.literal('DEVELOPER_METADATA_LOCATION_TYPE_UNSPECIFIED'),
      z.literal('ROW'),
      z.literal('COLUMN'),
      z.literal('SHEET'),
      z.literal('SPREADSHEET'),
    ])
    .optional(),
  sheetId: z.number().optional(),
  spreadsheet: z.boolean().optional(),
});

export const visibilitySchema = z.union([
  z.literal('DEVELOPER_METADATA_VISIBILITY_UNSPECIFIED'),
  z.literal('DOCUMENT'),
  z.literal('PROJECT'),
]);

export const locationTypeSchema = z.union([
  z.literal('DEVELOPER_METADATA_LOCATION_TYPE_UNSPECIFIED'),
  z.literal('ROW'),
  z.literal('COLUMN'),
  z.literal('SHEET'),
  z.literal('SPREADSHEET'),
]);

export const developerMetadataLookupSchema = z.object({
  locationMatchingStrategy: z
    .union([
      z.literal('DEVELOPER_METADATA_LOCATION_MATCHING_STRATEGY_UNSPECIFIED'),
      z.literal('EXACT_LOCATION'),
      z.literal('INTERSECTING_LOCATION'),
    ])
    .optional(),
  locationType: z
    .union([
      z.literal('DEVELOPER_METADATA_LOCATION_TYPE_UNSPECIFIED'),
      z.literal('ROW'),
      z.literal('COLUMN'),
      z.literal('SHEET'),
      z.literal('SPREADSHEET'),
    ])
    .optional(),
  metadataId: z.number().optional(),
  metadataKey: z.string().optional(),
  metadataLocation: developerMetadataLocationSchema.optional(),
  metadataValue: z.string().optional(),
  visibility: z
    .union([z.literal('DEVELOPER_METADATA_VISIBILITY_UNSPECIFIED'), z.literal('DOCUMENT'), z.literal('PROJECT')])
    .optional(),
});

export const locationMatchingStrategySchema = z.union([
  z.literal('DEVELOPER_METADATA_LOCATION_MATCHING_STRATEGY_UNSPECIFIED'),
  z.literal('EXACT_LOCATION'),
  z.literal('INTERSECTING_LOCATION'),
]);

export const developerMetadataSchema = z.object({
  location: developerMetadataLocationSchema.optional(),
  metadataId: z.number().optional(),
  metadataKey: z.string().optional(),
  metadataValue: z.string().optional(),
  visibility: z
    .union([z.literal('DEVELOPER_METADATA_VISIBILITY_UNSPECIFIED'), z.literal('DOCUMENT'), z.literal('PROJECT')])
    .optional(),
});

export const duplicateFilterViewRequestSchema = z.object({
  filterId: z.number().optional(),
});

export const duplicateSheetRequestSchema = z.object({
  insertSheetIndex: z.number().optional(),
  newSheetId: z.number().optional(),
  newSheetName: z.string().optional(),
  sourceSheetId: z.number().optional(),
});

export const editorsSchema = z.object({
  domainUsersCanEdit: z.boolean().optional(),
  groups: z.array(z.string()).optional(),
  users: z.array(z.string()).optional(),
});

export const embeddedObjectBorderSchema = z.object({
  color: colorSchema.optional(),
  colorStyle: colorStyleSchema.optional(),
});

export const overlayPositionSchema = z.object({
  anchorCell: gridCoordinateSchema.optional(),
  heightPixels: z.number().optional(),
  offsetXPixels: z.number().optional(),
  offsetYPixels: z.number().optional(),
  widthPixels: z.number().optional(),
});

export const errorValueSchema = z.object({
  message: z.string().optional(),
  type: z
    .union([
      z.literal('ERROR_TYPE_UNSPECIFIED'),
      z.literal('ERROR'),
      z.literal('NULL_VALUE'),
      z.literal('DIVIDE_BY_ZERO'),
      z.literal('VALUE'),
      z.literal('REF'),
      z.literal('NAME'),
      z.literal('NUM'),
      z.literal('N_A'),
      z.literal('LOADING'),
    ])
    .optional(),
});

export const type6Schema = z.union([
  z.literal('ERROR_TYPE_UNSPECIFIED'),
  z.literal('ERROR'),
  z.literal('NULL_VALUE'),
  z.literal('DIVIDE_BY_ZERO'),
  z.literal('VALUE'),
  z.literal('REF'),
  z.literal('NAME'),
  z.literal('NUM'),
  z.literal('N_A'),
  z.literal('LOADING'),
]);

export const extendedValueSchema = z.object({
  boolValue: z.boolean().optional(),
  errorValue: errorValueSchema.optional(),
  formulaValue: z.string().optional(),
  numberValue: z.number().optional(),
  stringValue: z.string().optional(),
});

export const filterCriteriaSchema = z.object({
  condition: booleanConditionSchema.optional(),
  hiddenValues: z.array(z.string()).optional(),
  visibleBackgroundColor: colorSchema.optional(),
  visibleBackgroundColorStyle: colorStyleSchema.optional(),
  visibleForegroundColor: colorSchema.optional(),
  visibleForegroundColorStyle: colorStyleSchema.optional(),
});

export const filterSpecSchema = z.object({
  columnIndex: z.number().optional(),
  dataSourceColumnReference: dataSourceColumnReferenceSchema.optional(),
  filterCriteria: filterCriteriaSchema.optional(),
});

export const filterViewSchema = z.object({
  criteria: z.record(filterCriteriaSchema).optional(),
  filterSpecs: z.array(filterSpecSchema).optional(),
  filterViewId: z.number().optional(),
  namedRangeId: z.string().optional(),
  range: gridRangeSchema.optional(),
  sortSpecs: z.array(sortSpecSchema).optional(),
  title: z.string().optional(),
});

export const findReplaceRequestSchema = z.object({
  allSheets: z.boolean().optional(),
  find: z.string().optional(),
  includeFormulas: z.boolean().optional(),
  matchCase: z.boolean().optional(),
  matchEntireCell: z.boolean().optional(),
  range: gridRangeSchema.optional(),
  replacement: z.string().optional(),
  searchByRegex: z.boolean().optional(),
  sheetId: z.number().optional(),
});

export const findReplaceResponseSchema = z.object({
  formulasChanged: z.number().optional(),
  occurrencesChanged: z.number().optional(),
  rowsChanged: z.number().optional(),
  sheetsChanged: z.number().optional(),
  valuesChanged: z.number().optional(),
});

export const dataFilterSchema = z.object({
  a1Range: z.string().optional(),
  developerMetadataLookup: developerMetadataLookupSchema.optional(),
  gridRange: gridRangeSchema.optional(),
});

export const interpolationPointSchema = z.object({
  color: colorSchema.optional(),
  colorStyle: colorStyleSchema.optional(),
  type: z
    .union([
      z.literal('INTERPOLATION_POINT_TYPE_UNSPECIFIED'),
      z.literal('MIN'),
      z.literal('MAX'),
      z.literal('NUMBER'),
      z.literal('PERCENT'),
      z.literal('PERCENTILE'),
    ])
    .optional(),
  value: z.string().optional(),
});

export const dimensionPropertiesSchema = z.object({
  dataSourceColumnReference: dataSourceColumnReferenceSchema.optional(),
  developerMetadata: z.array(developerMetadataSchema).optional(),
  hiddenByFilter: z.boolean().optional(),
  hiddenByUser: z.boolean().optional(),
  pixelSize: z.number().optional(),
});

export const gridPropertiesSchema = z.object({
  columnCount: z.number().optional(),
  columnGroupControlAfter: z.boolean().optional(),
  frozenColumnCount: z.number().optional(),
  frozenRowCount: z.number().optional(),
  hideGridlines: z.boolean().optional(),
  rowCount: z.number().optional(),
  rowGroupControlAfter: z.boolean().optional(),
});

export const legendPosition3Schema = z.union([
  z.literal('HISTOGRAM_CHART_LEGEND_POSITION_UNSPECIFIED'),
  z.literal('BOTTOM_LEGEND'),
  z.literal('LEFT_LEGEND'),
  z.literal('RIGHT_LEGEND'),
  z.literal('TOP_LEGEND'),
  z.literal('NO_LEGEND'),
  z.literal('INSIDE_LEGEND'),
]);

export const histogramRuleSchema = z.object({
  end: z.number().optional(),
  interval: z.number().optional(),
  start: z.number().optional(),
});

export const insertDimensionRequestSchema = z.object({
  inheritFromBefore: z.boolean().optional(),
  range: dimensionRangeSchema.optional(),
});

export const insertRangeRequestSchema = z.object({
  range: gridRangeSchema.optional(),
  shiftDimension: z.union([z.literal('DIMENSION_UNSPECIFIED'), z.literal('ROWS'), z.literal('COLUMNS')]).optional(),
});

export const type7Schema = z.union([
  z.literal('INTERPOLATION_POINT_TYPE_UNSPECIFIED'),
  z.literal('MIN'),
  z.literal('MAX'),
  z.literal('NUMBER'),
  z.literal('PERCENT'),
  z.literal('PERCENTILE'),
]);

export const iterativeCalculationSettingsSchema = z.object({
  convergenceThreshold: z.number().optional(),
  maxIterations: z.number().optional(),
});

export const type8Schema = z.union([
  z.literal('LINE_DASH_TYPE_UNSPECIFIED'),
  z.literal('INVISIBLE'),
  z.literal('CUSTOM'),
  z.literal('SOLID'),
  z.literal('DOTTED'),
  z.literal('MEDIUM_DASHED'),
  z.literal('MEDIUM_DASHED_DOTTED'),
  z.literal('LONG_DASHED'),
  z.literal('LONG_DASHED_DOTTED'),
]);

export const linkSchema = z.object({
  uri: z.string().optional(),
});

export const manualRuleGroupSchema = z.object({
  groupName: extendedValueSchema.optional(),
  items: z.array(extendedValueSchema).optional(),
});

export const matchedDeveloperMetadataSchema = z.object({
  dataFilters: z.array(dataFilterSchema).optional(),
  developerMetadata: developerMetadataSchema.optional(),
});

export const matchedValueRangeSchema = z.object({
  dataFilters: z.array(dataFilterSchema).optional(),
  valueRange: valueRangeSchema.optional(),
});

export const mergeCellsRequestSchema = z.object({
  mergeType: z.union([z.literal('MERGE_ALL'), z.literal('MERGE_COLUMNS'), z.literal('MERGE_ROWS')]).optional(),
  range: gridRangeSchema.optional(),
});

export const mergeTypeSchema = z.union([z.literal('MERGE_ALL'), z.literal('MERGE_COLUMNS'), z.literal('MERGE_ROWS')]);

export const moveDimensionRequestSchema = z.object({
  destinationIndex: z.number().optional(),
  source: dimensionRangeSchema.optional(),
});

export const namedRangeSchema = z.object({
  name: z.string().optional(),
  namedRangeId: z.string().optional(),
  range: gridRangeSchema.optional(),
});

export const type9Schema = z.union([
  z.literal('NUMBER_FORMAT_TYPE_UNSPECIFIED'),
  z.literal('TEXT'),
  z.literal('NUMBER'),
  z.literal('PERCENT'),
  z.literal('CURRENCY'),
  z.literal('DATE'),
  z.literal('TIME'),
  z.literal('DATE_TIME'),
  z.literal('SCIENTIFIC'),
]);

export const nodeSizeSchema = z.union([
  z.literal('ORG_CHART_LABEL_SIZE_UNSPECIFIED'),
  z.literal('SMALL'),
  z.literal('MEDIUM'),
  z.literal('LARGE'),
]);

export const pasteDataRequestSchema = z.object({
  coordinate: gridCoordinateSchema.optional(),
  data: z.string().optional(),
  delimiter: z.string().optional(),
  html: z.boolean().optional(),
  type: z
    .union([
      z.literal('PASTE_NORMAL'),
      z.literal('PASTE_VALUES'),
      z.literal('PASTE_FORMAT'),
      z.literal('PASTE_NO_BORDERS'),
      z.literal('PASTE_FORMULA'),
      z.literal('PASTE_DATA_VALIDATION'),
      z.literal('PASTE_CONDITIONAL_FORMATTING'),
    ])
    .optional(),
});

export const type10Schema = z.union([
  z.literal('PASTE_NORMAL'),
  z.literal('PASTE_VALUES'),
  z.literal('PASTE_FORMAT'),
  z.literal('PASTE_NO_BORDERS'),
  z.literal('PASTE_FORMULA'),
  z.literal('PASTE_DATA_VALIDATION'),
  z.literal('PASTE_CONDITIONAL_FORMATTING'),
]);

export const legendPosition4Schema = z.union([
  z.literal('PIE_CHART_LEGEND_POSITION_UNSPECIFIED'),
  z.literal('BOTTOM_LEGEND'),
  z.literal('LEFT_LEGEND'),
  z.literal('RIGHT_LEGEND'),
  z.literal('TOP_LEGEND'),
  z.literal('NO_LEGEND'),
  z.literal('LABELED_LEGEND'),
]);

export const pivotFilterCriteriaSchema = z.object({
  condition: booleanConditionSchema.optional(),
  visibleByDefault: z.boolean().optional(),
  visibleValues: z.array(z.string()).optional(),
});

export const pivotFilterSpecSchema = z.object({
  columnOffsetIndex: z.number().optional(),
  dataSourceColumnReference: dataSourceColumnReferenceSchema.optional(),
  filterCriteria: pivotFilterCriteriaSchema.optional(),
});

export const pivotGroupLimitSchema = z.object({
  applyOrder: z.number().optional(),
  countLimit: z.number().optional(),
});

export const pivotGroupSortValueBucketSchema = z.object({
  buckets: z.array(extendedValueSchema).optional(),
  valuesIndex: z.number().optional(),
});

export const pivotGroupValueMetadataSchema = z.object({
  collapsed: z.boolean().optional(),
  value: extendedValueSchema.optional(),
});

export const sortOrderSchema = z.union([
  z.literal('SORT_ORDER_UNSPECIFIED'),
  z.literal('ASCENDING'),
  z.literal('DESCENDING'),
]);

export const manualRuleSchema = z.object({
  groups: z.array(manualRuleGroupSchema).optional(),
});

export const pivotValueSchema = z.object({
  calculatedDisplayType: z
    .union([
      z.literal('PIVOT_VALUE_CALCULATED_DISPLAY_TYPE_UNSPECIFIED'),
      z.literal('PERCENT_OF_ROW_TOTAL'),
      z.literal('PERCENT_OF_COLUMN_TOTAL'),
      z.literal('PERCENT_OF_GRAND_TOTAL'),
    ])
    .optional(),
  dataSourceColumnReference: dataSourceColumnReferenceSchema.optional(),
  formula: z.string().optional(),
  name: z.string().optional(),
  sourceColumnOffset: z.number().optional(),
  summarizeFunction: z
    .union([
      z.literal('PIVOT_STANDARD_VALUE_FUNCTION_UNSPECIFIED'),
      z.literal('SUM'),
      z.literal('COUNTA'),
      z.literal('COUNT'),
      z.literal('COUNTUNIQUE'),
      z.literal('AVERAGE'),
      z.literal('MAX'),
      z.literal('MIN'),
      z.literal('MEDIAN'),
      z.literal('PRODUCT'),
      z.literal('STDEV'),
      z.literal('STDEVP'),
      z.literal('VAR'),
      z.literal('VARP'),
      z.literal('CUSTOM'),
    ])
    .optional(),
});

export const valueLayoutSchema = z.union([z.literal('HORIZONTAL'), z.literal('VERTICAL')]);

export const calculatedDisplayTypeSchema = z.union([
  z.literal('PIVOT_VALUE_CALCULATED_DISPLAY_TYPE_UNSPECIFIED'),
  z.literal('PERCENT_OF_ROW_TOTAL'),
  z.literal('PERCENT_OF_COLUMN_TOTAL'),
  z.literal('PERCENT_OF_GRAND_TOTAL'),
]);

export const summarizeFunctionSchema = z.union([
  z.literal('PIVOT_STANDARD_VALUE_FUNCTION_UNSPECIFIED'),
  z.literal('SUM'),
  z.literal('COUNTA'),
  z.literal('COUNT'),
  z.literal('COUNTUNIQUE'),
  z.literal('AVERAGE'),
  z.literal('MAX'),
  z.literal('MIN'),
  z.literal('MEDIAN'),
  z.literal('PRODUCT'),
  z.literal('STDEV'),
  z.literal('STDEVP'),
  z.literal('VAR'),
  z.literal('VARP'),
  z.literal('CUSTOM'),
]);

export const shapeSchema = z.union([
  z.literal('POINT_SHAPE_UNSPECIFIED'),
  z.literal('CIRCLE'),
  z.literal('DIAMOND'),
  z.literal('HEXAGON'),
  z.literal('PENTAGON'),
  z.literal('SQUARE'),
  z.literal('STAR'),
  z.literal('TRIANGLE'),
  z.literal('X_MARK'),
]);

export const protectedRangeSchema = z.object({
  description: z.string().optional(),
  editors: editorsSchema.optional(),
  namedRangeId: z.string().optional(),
  protectedRangeId: z.number().optional(),
  range: gridRangeSchema.optional(),
  requestingUserCanEdit: z.boolean().optional(),
  unprotectedRanges: z.array(gridRangeSchema).optional(),
  warningOnly: z.boolean().optional(),
});

export const randomizeRangeRequestSchema = z.object({
  range: gridRangeSchema.optional(),
});

export const refreshDataSourceObjectExecutionStatusSchema = z.object({
  dataExecutionStatus: dataExecutionStatusSchema.optional(),
  reference: dataSourceObjectReferenceSchema.optional(),
});

export const refreshDataSourceRequestSchema = z.object({
  dataSourceId: z.string().optional(),
  force: z.boolean().optional(),
  isAll: z.boolean().optional(),
  references: dataSourceObjectReferencesSchema.optional(),
});

export const refreshDataSourceResponseSchema = z.object({
  statuses: z.array(refreshDataSourceObjectExecutionStatusSchema).optional(),
});

export const addDimensionGroupRequestSchema = z.object({
  range: dimensionRangeSchema.optional(),
});

export const addFilterViewRequestSchema = z.object({
  filter: filterViewSchema.optional(),
});

export const addNamedRangeRequestSchema = z.object({
  namedRange: namedRangeSchema.optional(),
});

export const addProtectedRangeRequestSchema = z.object({
  protectedRange: protectedRangeSchema.optional(),
});

export const autoFillRequestSchema = z.object({
  range: gridRangeSchema.optional(),
  sourceAndDestination: sourceAndDestinationSchema.optional(),
  useAlternateSeries: z.boolean().optional(),
});

export const autoResizeDimensionsRequestSchema = z.object({
  dataSourceSheetDimensions: dataSourceSheetDimensionRangeSchema.optional(),
  dimensions: dimensionRangeSchema.optional(),
});

export const createDeveloperMetadataRequestSchema = z.object({
  developerMetadata: developerMetadataSchema.optional(),
});

export const cutPasteRequestSchema = z.object({
  destination: gridCoordinateSchema.optional(),
  pasteType: z
    .union([
      z.literal('PASTE_NORMAL'),
      z.literal('PASTE_VALUES'),
      z.literal('PASTE_FORMAT'),
      z.literal('PASTE_NO_BORDERS'),
      z.literal('PASTE_FORMULA'),
      z.literal('PASTE_DATA_VALIDATION'),
      z.literal('PASTE_CONDITIONAL_FORMATTING'),
    ])
    .optional(),
  source: gridRangeSchema.optional(),
});

export const deleteDeveloperMetadataRequestSchema = z.object({
  dataFilter: dataFilterSchema.optional(),
});

export const setDataValidationRequestSchema = z.object({
  range: gridRangeSchema.optional(),
  rule: dataValidationRuleSchema.optional(),
});

export const sortRangeRequestSchema = z.object({
  range: gridRangeSchema.optional(),
  sortSpecs: z.array(sortSpecSchema).optional(),
});

export const textToColumnsRequestSchema = z.object({
  delimiter: z.string().optional(),
  delimiterType: z
    .union([
      z.literal('DELIMITER_TYPE_UNSPECIFIED'),
      z.literal('COMMA'),
      z.literal('SEMICOLON'),
      z.literal('PERIOD'),
      z.literal('SPACE'),
      z.literal('CUSTOM'),
      z.literal('AUTODETECT'),
    ])
    .optional(),
  source: gridRangeSchema.optional(),
});

export const trimWhitespaceRequestSchema = z.object({
  range: gridRangeSchema.optional(),
});

export const unmergeCellsRequestSchema = z.object({
  range: gridRangeSchema.optional(),
});

export const updateBordersRequestSchema = z.object({
  bottom: borderSchema.optional(),
  innerHorizontal: borderSchema.optional(),
  innerVertical: borderSchema.optional(),
  left: borderSchema.optional(),
  range: gridRangeSchema.optional(),
  right: borderSchema.optional(),
  top: borderSchema.optional(),
});

export const updateDeveloperMetadataRequestSchema = z.object({
  dataFilters: z.array(dataFilterSchema).optional(),
  developerMetadata: developerMetadataSchema.optional(),
  fields: z.string().optional(),
});

export const updateDimensionGroupRequestSchema = z.object({
  dimensionGroup: dimensionGroupSchema.optional(),
  fields: z.string().optional(),
});

export const updateDimensionPropertiesRequestSchema = z.object({
  dataSourceSheetRange: dataSourceSheetDimensionRangeSchema.optional(),
  fields: z.string().optional(),
  properties: dimensionPropertiesSchema.optional(),
  range: dimensionRangeSchema.optional(),
});

export const updateEmbeddedObjectBorderRequestSchema = z.object({
  border: embeddedObjectBorderSchema.optional(),
  fields: z.string().optional(),
  objectId: z.number().optional(),
});

export const updateFilterViewRequestSchema = z.object({
  fields: z.string().optional(),
  filter: filterViewSchema.optional(),
});

export const updateNamedRangeRequestSchema = z.object({
  fields: z.string().optional(),
  namedRange: namedRangeSchema.optional(),
});

export const updateProtectedRangeRequestSchema = z.object({
  fields: z.string().optional(),
  protectedRange: protectedRangeSchema.optional(),
});

export const addDimensionGroupResponseSchema = z.object({
  dimensionGroups: z.array(dimensionGroupSchema).optional(),
});

export const addFilterViewResponseSchema = z.object({
  filter: filterViewSchema.optional(),
});

export const addNamedRangeResponseSchema = z.object({
  namedRange: namedRangeSchema.optional(),
});

export const addProtectedRangeResponseSchema = z.object({
  protectedRange: protectedRangeSchema.optional(),
});

export const createDeveloperMetadataResponseSchema = z.object({
  developerMetadata: developerMetadataSchema.optional(),
});

export const deleteDeveloperMetadataResponseSchema = z.object({
  deletedDeveloperMetadata: z.array(developerMetadataSchema).optional(),
});

export const duplicateFilterViewResponseSchema = z.object({
  filter: filterViewSchema.optional(),
});

export const trimWhitespaceResponseSchema = z.object({
  cellsChangedCount: z.number().optional(),
});

export const updateDeveloperMetadataResponseSchema = z.object({
  developerMetadata: z.array(developerMetadataSchema).optional(),
});

export const numberFormatSourceSchema = z.union([
  z.literal('CHART_NUMBER_FORMAT_SOURCE_UNDEFINED'),
  z.literal('FROM_DATA'),
  z.literal('CUSTOM'),
]);

export const searchDeveloperMetadataRequestSchema = z.object({
  dataFilters: z.array(dataFilterSchema).optional(),
});

export const searchDeveloperMetadataResponseSchema = z.object({
  matchedDeveloperMetadata: z.array(matchedDeveloperMetadataSchema).optional(),
});

export const basicFilterSchema = z.object({
  criteria: z.record(filterCriteriaSchema).optional(),
  filterSpecs: z.array(filterSpecSchema).optional(),
  range: gridRangeSchema.optional(),
  sortSpecs: z.array(sortSpecSchema).optional(),
});

export const sheetPropertiesSchema = z.object({
  dataSourceSheetProperties: dataSourceSheetPropertiesSchema.optional(),
  gridProperties: gridPropertiesSchema.optional(),
  hidden: z.boolean().optional(),
  index: z.number().optional(),
  rightToLeft: z.boolean().optional(),
  sheetId: z.number().optional(),
  sheetType: z
    .union([z.literal('SHEET_TYPE_UNSPECIFIED'), z.literal('GRID'), z.literal('OBJECT'), z.literal('DATA_SOURCE')])
    .optional(),
  tabColor: colorSchema.optional(),
  tabColorStyle: colorStyleSchema.optional(),
  title: z.string().optional(),
});

export const sheetTypeSchema = z.union([
  z.literal('SHEET_TYPE_UNSPECIFIED'),
  z.literal('GRID'),
  z.literal('OBJECT'),
  z.literal('DATA_SOURCE'),
]);

export const embeddedObjectPositionSchema = z.object({
  newSheet: z.boolean().optional(),
  overlayPosition: overlayPositionSchema.optional(),
  sheetId: z.number().optional(),
});

export const textFormatSchema = z.object({
  bold: z.boolean().optional(),
  fontFamily: z.string().optional(),
  fontSize: z.number().optional(),
  foregroundColor: colorSchema.optional(),
  foregroundColorStyle: colorStyleSchema.optional(),
  italic: z.boolean().optional(),
  link: linkSchema.optional(),
  strikethrough: z.boolean().optional(),
  underline: z.boolean().optional(),
});

export const dataSourceRefreshScheduleSchema = z.object({
  dailySchedule: dataSourceRefreshDailyScheduleSchema.optional(),
  enabled: z.boolean().optional(),
  monthlySchedule: dataSourceRefreshMonthlyScheduleSchema.optional(),
  nextRun: intervalSchema.optional(),
  refreshScope: z.union([z.literal('DATA_SOURCE_REFRESH_SCOPE_UNSPECIFIED'), z.literal('ALL_DATA_SOURCES')]).optional(),
  weeklySchedule: dataSourceRefreshWeeklyScheduleSchema.optional(),
});

export const cellFormatSchema = z.object({
  backgroundColor: colorSchema.optional(),
  backgroundColorStyle: colorStyleSchema.optional(),
  borders: bordersSchema.optional(),
  horizontalAlignment: z
    .union([z.literal('HORIZONTAL_ALIGN_UNSPECIFIED'), z.literal('LEFT'), z.literal('CENTER'), z.literal('RIGHT')])
    .optional(),
  hyperlinkDisplayType: z
    .union([z.literal('HYPERLINK_DISPLAY_TYPE_UNSPECIFIED'), z.literal('LINKED'), z.literal('PLAIN_TEXT')])
    .optional(),
  numberFormat: numberFormatSchema.optional(),
  padding: paddingSchema.optional(),
  textDirection: z
    .union([z.literal('TEXT_DIRECTION_UNSPECIFIED'), z.literal('LEFT_TO_RIGHT'), z.literal('RIGHT_TO_LEFT')])
    .optional(),
  textFormat: textFormatSchema.optional(),
  textRotation: textRotationSchema.optional(),
  verticalAlignment: z
    .union([z.literal('VERTICAL_ALIGN_UNSPECIFIED'), z.literal('TOP'), z.literal('MIDDLE'), z.literal('BOTTOM')])
    .optional(),
  wrapStrategy: z
    .union([
      z.literal('WRAP_STRATEGY_UNSPECIFIED'),
      z.literal('OVERFLOW_CELL'),
      z.literal('LEGACY_WRAP'),
      z.literal('CLIP'),
      z.literal('WRAP'),
    ])
    .optional(),
});

export const autoRecalcSchema = z.union([
  z.literal('RECALCULATION_INTERVAL_UNSPECIFIED'),
  z.literal('ON_CHANGE'),
  z.literal('MINUTE'),
  z.literal('HOUR'),
]);

export const themeColorPairSchema = z.object({
  color: colorStyleSchema.optional(),
  colorType: z
    .union([
      z.literal('THEME_COLOR_TYPE_UNSPECIFIED'),
      z.literal('TEXT'),
      z.literal('BACKGROUND'),
      z.literal('ACCENT1'),
      z.literal('ACCENT2'),
      z.literal('ACCENT3'),
      z.literal('ACCENT4'),
      z.literal('ACCENT5'),
      z.literal('ACCENT6'),
      z.literal('LINK'),
    ])
    .optional(),
});

export const textFormatRunSchema = z.object({
  format: textFormatSchema.optional(),
  startIndex: z.number().optional(),
});

export const delimiterTypeSchema = z.union([
  z.literal('DELIMITER_TYPE_UNSPECIFIED'),
  z.literal('COMMA'),
  z.literal('SEMICOLON'),
  z.literal('PERIOD'),
  z.literal('SPACE'),
  z.literal('CUSTOM'),
  z.literal('AUTODETECT'),
]);

export const colorTypeSchema = z.union([
  z.literal('THEME_COLOR_TYPE_UNSPECIFIED'),
  z.literal('TEXT'),
  z.literal('BACKGROUND'),
  z.literal('ACCENT1'),
  z.literal('ACCENT2'),
  z.literal('ACCENT3'),
  z.literal('ACCENT4'),
  z.literal('ACCENT5'),
  z.literal('ACCENT6'),
  z.literal('LINK'),
]);

export const treemapChartColorScaleSchema = z.object({
  maxValueColor: colorSchema.optional(),
  maxValueColorStyle: colorStyleSchema.optional(),
  midValueColor: colorSchema.optional(),
  midValueColorStyle: colorStyleSchema.optional(),
  minValueColor: colorSchema.optional(),
  minValueColorStyle: colorStyleSchema.optional(),
  noDataColor: colorSchema.optional(),
  noDataColorStyle: colorStyleSchema.optional(),
});

export const updateEmbeddedObjectPositionRequestSchema = z.object({
  fields: z.string().optional(),
  newPosition: embeddedObjectPositionSchema.optional(),
  objectId: z.number().optional(),
});

export const updateEmbeddedObjectPositionResponseSchema = z.object({
  position: embeddedObjectPositionSchema.optional(),
});

export const updateSheetPropertiesRequestSchema = z.object({
  fields: z.string().optional(),
  properties: sheetPropertiesSchema.optional(),
});

export const slicerSpecSchema = z.object({
  applyToPivotTables: z.boolean().optional(),
  backgroundColor: colorSchema.optional(),
  backgroundColorStyle: colorStyleSchema.optional(),
  columnIndex: z.number().optional(),
  dataRange: gridRangeSchema.optional(),
  filterCriteria: filterCriteriaSchema.optional(),
  horizontalAlignment: z
    .union([z.literal('HORIZONTAL_ALIGN_UNSPECIFIED'), z.literal('LEFT'), z.literal('CENTER'), z.literal('RIGHT')])
    .optional(),
  textFormat: textFormatSchema.optional(),
  title: z.string().optional(),
});

export const updateValuesByDataFilterResponseSchema = z.object({
  dataFilter: dataFilterSchema.optional(),
  updatedCells: z.number().optional(),
  updatedColumns: z.number().optional(),
  updatedData: valueRangeSchema.optional(),
  updatedRange: z.string().optional(),
  updatedRows: z.number().optional(),
});

export const waterfallChartColumnStyleSchema = z.object({
  color: colorSchema.optional(),
  colorStyle: colorStyleSchema.optional(),
  label: z.string().optional(),
});

export const waterfallChartCustomSubtotalSchema = z.object({
  dataIsSubtotal: z.boolean().optional(),
  label: z.string().optional(),
  subtotalIndex: z.number().optional(),
});

export const stackedType2Schema = z.union([
  z.literal('WATERFALL_STACKED_TYPE_UNSPECIFIED'),
  z.literal('STACKED'),
  z.literal('SEQUENTIAL'),
]);

export const parameterXgafvSchema = z.union([z.literal('1'), z.literal('2')]);

export const parameteraccessTokenSchema = z.string();

export const parameteraltSchema = z.union([z.literal('json'), z.literal('media'), z.literal('proto')]);

export const parametercallbackSchema = z.string();

export const parameterfieldsSchema = z.string();

export const parameterkeySchema = z.string();

export const parameteroauthTokenSchema = z.string();

export const parameterprettyPrintSchema = z.boolean();

export const parameterquotaUserSchema = z.string();

export const parameteruploadTypeSchema = z.string();

export const parameteruploadProtocolSchema = z.string();

export const sheetsSpreadsheetsCreateErrorSchema = z.unknown();

export const sheetsSpreadsheetsGetDataSchema = z.object({
  path: z.object({
    spreadsheetId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      includeGridData: z.boolean().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      ranges: z.array(z.string()).optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const sheetsSpreadsheetsGetErrorSchema = z.unknown();

export const sheetsSpreadsheetsDeveloperMetadataGetDataSchema = z.object({
  path: z.object({
    metadataId: z.number(),
    spreadsheetId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const sheetsSpreadsheetsDeveloperMetadataGetResponseSchema = developerMetadataSchema;

export const sheetsSpreadsheetsDeveloperMetadataGetErrorSchema = z.unknown();

export const sheetsSpreadsheetsDeveloperMetadataSearchDataSchema = z.object({
  body: searchDeveloperMetadataRequestSchema.optional(),
  path: z.object({
    spreadsheetId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const sheetsSpreadsheetsDeveloperMetadataSearchResponseSchema = searchDeveloperMetadataResponseSchema;

export const sheetsSpreadsheetsDeveloperMetadataSearchErrorSchema = z.unknown();

export const sheetsSpreadsheetsSheetsCopyToDataSchema = z.object({
  body: copySheetToAnotherSpreadsheetRequestSchema.optional(),
  path: z.object({
    sheetId: z.number(),
    spreadsheetId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const sheetsSpreadsheetsSheetsCopyToResponseSchema = sheetPropertiesSchema;

export const sheetsSpreadsheetsSheetsCopyToErrorSchema = z.unknown();

export const sheetsSpreadsheetsValuesGetDataSchema = z.object({
  path: z.object({
    range: z.string(),
    spreadsheetId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      dateTimeRenderOption: z.union([z.literal('SERIAL_NUMBER'), z.literal('FORMATTED_STRING')]).optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      majorDimension: z.union([z.literal('DIMENSION_UNSPECIFIED'), z.literal('ROWS'), z.literal('COLUMNS')]).optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
      valueRenderOption: z
        .union([z.literal('FORMATTED_VALUE'), z.literal('UNFORMATTED_VALUE'), z.literal('FORMULA')])
        .optional(),
    })
    .optional(),
});

export const sheetsSpreadsheetsValuesGetResponseSchema = valueRangeSchema;

export const sheetsSpreadsheetsValuesGetErrorSchema = z.unknown();

export const sheetsSpreadsheetsValuesUpdateDataSchema = z.object({
  body: valueRangeSchema.optional(),
  path: z.object({
    range: z.string(),
    spreadsheetId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      includeValuesInResponse: z.boolean().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      responseDateTimeRenderOption: z.union([z.literal('SERIAL_NUMBER'), z.literal('FORMATTED_STRING')]).optional(),
      responseValueRenderOption: z
        .union([z.literal('FORMATTED_VALUE'), z.literal('UNFORMATTED_VALUE'), z.literal('FORMULA')])
        .optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
      valueInputOption: z
        .union([z.literal('INPUT_VALUE_OPTION_UNSPECIFIED'), z.literal('RAW'), z.literal('USER_ENTERED')])
        .optional(),
    })
    .optional(),
});

export const sheetsSpreadsheetsValuesUpdateResponseSchema = updateValuesResponseSchema;

export const sheetsSpreadsheetsValuesUpdateErrorSchema = z.unknown();

export const sheetsSpreadsheetsValuesAppendDataSchema = z.object({
  body: valueRangeSchema.optional(),
  path: z.object({
    range: z.string(),
    spreadsheetId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      includeValuesInResponse: z.boolean().optional(),
      insertDataOption: z.union([z.literal('OVERWRITE'), z.literal('INSERT_ROWS')]).optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      responseDateTimeRenderOption: z.union([z.literal('SERIAL_NUMBER'), z.literal('FORMATTED_STRING')]).optional(),
      responseValueRenderOption: z
        .union([z.literal('FORMATTED_VALUE'), z.literal('UNFORMATTED_VALUE'), z.literal('FORMULA')])
        .optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
      valueInputOption: z
        .union([z.literal('INPUT_VALUE_OPTION_UNSPECIFIED'), z.literal('RAW'), z.literal('USER_ENTERED')])
        .optional(),
    })
    .optional(),
});

export const appendValuesResponseSchema = z.object({
  spreadsheetId: z.string().optional(),
  tableRange: z.string().optional(),
  updates: updateValuesResponseSchema.optional(),
});

export const sheetsSpreadsheetsValuesAppendErrorSchema = z.unknown();

export const sheetsSpreadsheetsValuesClearDataSchema = z.object({
  body: clearValuesRequestSchema.optional(),
  path: z.object({
    range: z.string(),
    spreadsheetId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const sheetsSpreadsheetsValuesClearResponseSchema = clearValuesResponseSchema;

export const sheetsSpreadsheetsValuesClearErrorSchema = z.unknown();

export const sheetsSpreadsheetsValuesBatchClearDataSchema = z.object({
  body: batchClearValuesRequestSchema.optional(),
  path: z.object({
    spreadsheetId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const sheetsSpreadsheetsValuesBatchClearResponseSchema = batchClearValuesResponseSchema;

export const sheetsSpreadsheetsValuesBatchClearErrorSchema = z.unknown();

export const batchClearValuesByDataFilterRequestSchema = z.object({
  dataFilters: z.array(dataFilterSchema).optional(),
});

export const sheetsSpreadsheetsValuesBatchClearByDataFilterResponseSchema = batchClearValuesByDataFilterResponseSchema;

export const sheetsSpreadsheetsValuesBatchClearByDataFilterErrorSchema = z.unknown();

export const sheetsSpreadsheetsValuesBatchGetDataSchema = z.object({
  path: z.object({
    spreadsheetId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      dateTimeRenderOption: z.union([z.literal('SERIAL_NUMBER'), z.literal('FORMATTED_STRING')]).optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      majorDimension: z.union([z.literal('DIMENSION_UNSPECIFIED'), z.literal('ROWS'), z.literal('COLUMNS')]).optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      ranges: z.array(z.string()).optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
      valueRenderOption: z
        .union([z.literal('FORMATTED_VALUE'), z.literal('UNFORMATTED_VALUE'), z.literal('FORMULA')])
        .optional(),
    })
    .optional(),
});

export const batchGetValuesResponseSchema = z.object({
  spreadsheetId: z.string().optional(),
  valueRanges: z.array(valueRangeSchema).optional(),
});

export const sheetsSpreadsheetsValuesBatchGetErrorSchema = z.unknown();

export const batchGetValuesByDataFilterRequestSchema = z.object({
  dataFilters: z.array(dataFilterSchema).optional(),
  dateTimeRenderOption: z.union([z.literal('SERIAL_NUMBER'), z.literal('FORMATTED_STRING')]).optional(),
  majorDimension: z.union([z.literal('DIMENSION_UNSPECIFIED'), z.literal('ROWS'), z.literal('COLUMNS')]).optional(),
  valueRenderOption: z
    .union([z.literal('FORMATTED_VALUE'), z.literal('UNFORMATTED_VALUE'), z.literal('FORMULA')])
    .optional(),
});

export const batchGetValuesByDataFilterResponseSchema = z.object({
  spreadsheetId: z.string().optional(),
  valueRanges: z.array(matchedValueRangeSchema).optional(),
});

export const sheetsSpreadsheetsValuesBatchGetByDataFilterErrorSchema = z.unknown();

export const sheetsSpreadsheetsValuesBatchUpdateDataSchema = z.object({
  body: batchUpdateValuesRequestSchema.optional(),
  path: z.object({
    spreadsheetId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const batchUpdateValuesResponseSchema = z.object({
  responses: z.array(updateValuesResponseSchema).optional(),
  spreadsheetId: z.string().optional(),
  totalUpdatedCells: z.number().optional(),
  totalUpdatedColumns: z.number().optional(),
  totalUpdatedRows: z.number().optional(),
  totalUpdatedSheets: z.number().optional(),
});

export const sheetsSpreadsheetsValuesBatchUpdateErrorSchema = z.unknown();

export const batchUpdateValuesByDataFilterResponseSchema = z.object({
  responses: z.array(updateValuesByDataFilterResponseSchema).optional(),
  spreadsheetId: z.string().optional(),
  totalUpdatedCells: z.number().optional(),
  totalUpdatedColumns: z.number().optional(),
  totalUpdatedRows: z.number().optional(),
  totalUpdatedSheets: z.number().optional(),
});

export const sheetsSpreadsheetsValuesBatchUpdateByDataFilterErrorSchema = z.unknown();

export const sheetsSpreadsheetsBatchUpdateErrorSchema = z.unknown();

export const getSpreadsheetByDataFilterRequestSchema = z.object({
  dataFilters: z.array(dataFilterSchema).optional(),
  includeGridData: z.boolean().optional(),
});

export const sheetsSpreadsheetsGetByDataFilterErrorSchema = z.unknown();

export const addSheetRequestSchema = z.object({
  properties: sheetPropertiesSchema.optional(),
});

export const addSheetResponseSchema = z.object({
  properties: sheetPropertiesSchema.optional(),
});

export const slicerSchema = z.object({
  position: embeddedObjectPositionSchema.optional(),
  slicerId: z.number().optional(),
  spec: slicerSpecSchema.optional(),
});

export const addSlicerResponseSchema = z.object({
  slicer: slicerSchema.optional(),
});

export const bandingPropertiesSchema = z.object({
  firstBandColor: colorSchema.optional(),
  firstBandColorStyle: colorStyleSchema.optional(),
  footerColor: colorSchema.optional(),
  footerColorStyle: colorStyleSchema.optional(),
  headerColor: colorSchema.optional(),
  headerColorStyle: colorStyleSchema.optional(),
  secondBandColor: colorSchema.optional(),
  secondBandColorStyle: colorStyleSchema.optional(),
});

export const baselineValueFormatSchema = z.object({
  comparisonType: z
    .union([
      z.literal('COMPARISON_TYPE_UNDEFINED'),
      z.literal('ABSOLUTE_DIFFERENCE'),
      z.literal('PERCENTAGE_DIFFERENCE'),
    ])
    .optional(),
  description: z.string().optional(),
  negativeColor: colorSchema.optional(),
  negativeColorStyle: colorStyleSchema.optional(),
  position: textPositionSchema.optional(),
  positiveColor: colorSchema.optional(),
  positiveColorStyle: colorStyleSchema.optional(),
  textFormat: textFormatSchema.optional(),
});

export const basicChartAxisSchema = z.object({
  format: textFormatSchema.optional(),
  position: z
    .union([
      z.literal('BASIC_CHART_AXIS_POSITION_UNSPECIFIED'),
      z.literal('BOTTOM_AXIS'),
      z.literal('LEFT_AXIS'),
      z.literal('RIGHT_AXIS'),
    ])
    .optional(),
  title: z.string().optional(),
  titleTextPosition: textPositionSchema.optional(),
  viewWindowOptions: chartAxisViewWindowOptionsSchema.optional(),
});

export const dataFilterValueRangeSchema = z.object({
  dataFilter: dataFilterSchema.optional(),
  majorDimension: z.union([z.literal('DIMENSION_UNSPECIFIED'), z.literal('ROWS'), z.literal('COLUMNS')]).optional(),
  values: z.array(z.array(z.unknown())).optional(),
});

export const booleanRuleSchema = z.object({
  condition: booleanConditionSchema.optional(),
  format: cellFormatSchema.optional(),
});

export const dataSourceTableSchema = z.object({
  columnSelectionType: z
    .union([
      z.literal('DATA_SOURCE_TABLE_COLUMN_SELECTION_TYPE_UNSPECIFIED'),
      z.literal('SELECTED'),
      z.literal('SYNC_ALL'),
    ])
    .optional(),
  columns: z.array(dataSourceColumnReferenceSchema).optional(),
  dataExecutionStatus: dataExecutionStatusSchema.optional(),
  dataSourceId: z.string().optional(),
  filterSpecs: z.array(filterSpecSchema).optional(),
  rowLimit: z.number().optional(),
  sortSpecs: z.array(sortSpecSchema).optional(),
});

export const chartGroupRuleSchema = z.object({
  dateTimeRule: chartDateTimeRuleSchema.optional(),
  histogramRule: chartHistogramRuleSchema.optional(),
});

export const gradientRuleSchema = z.object({
  maxpoint: interpolationPointSchema.optional(),
  midpoint: interpolationPointSchema.optional(),
  minpoint: interpolationPointSchema.optional(),
});

export const chartDataSchema = z.object({
  aggregateType: z
    .union([
      z.literal('CHART_AGGREGATE_TYPE_UNSPECIFIED'),
      z.literal('AVERAGE'),
      z.literal('COUNT'),
      z.literal('MAX'),
      z.literal('MEDIAN'),
      z.literal('MIN'),
      z.literal('SUM'),
    ])
    .optional(),
  columnReference: dataSourceColumnReferenceSchema.optional(),
  groupRule: chartGroupRuleSchema.optional(),
  sourceRange: chartSourceRangeSchema.optional(),
});

export const dataSourceSpecSchema = z.object({
  bigQuery: bigQueryDataSourceSpecSchema.optional(),
  parameters: z.array(dataSourceParameterSchema).optional(),
});

export const conditionalFormatRuleSchema = z.object({
  booleanRule: booleanRuleSchema.optional(),
  gradientRule: gradientRuleSchema.optional(),
  ranges: z.array(gridRangeSchema).optional(),
});

export const duplicateSheetResponseSchema = z.object({
  properties: sheetPropertiesSchema.optional(),
});

export const histogramSeriesSchema = z.object({
  barColor: colorSchema.optional(),
  barColorStyle: colorStyleSchema.optional(),
  data: chartDataSchema.optional(),
});

export const keyValueFormatSchema = z.object({
  position: textPositionSchema.optional(),
  textFormat: textFormatSchema.optional(),
});

export const orgChartSpecSchema = z.object({
  labels: chartDataSchema.optional(),
  nodeColor: colorSchema.optional(),
  nodeColorStyle: colorStyleSchema.optional(),
  nodeSize: z
    .union([z.literal('ORG_CHART_LABEL_SIZE_UNSPECIFIED'), z.literal('SMALL'), z.literal('MEDIUM'), z.literal('LARGE')])
    .optional(),
  parentLabels: chartDataSchema.optional(),
  selectedNodeColor: colorSchema.optional(),
  selectedNodeColorStyle: colorStyleSchema.optional(),
  tooltips: chartDataSchema.optional(),
});

export const pieChartSpecSchema = z.object({
  domain: chartDataSchema.optional(),
  legendPosition: z
    .union([
      z.literal('PIE_CHART_LEGEND_POSITION_UNSPECIFIED'),
      z.literal('BOTTOM_LEGEND'),
      z.literal('LEFT_LEGEND'),
      z.literal('RIGHT_LEGEND'),
      z.literal('TOP_LEGEND'),
      z.literal('NO_LEGEND'),
      z.literal('LABELED_LEGEND'),
    ])
    .optional(),
  pieHole: z.number().optional(),
  series: chartDataSchema.optional(),
  threeDimensional: z.boolean().optional(),
});

export const pivotGroupRuleSchema = z.object({
  dateTimeRule: dateTimeRuleSchema.optional(),
  histogramRule: histogramRuleSchema.optional(),
  manualRule: manualRuleSchema.optional(),
});

export const pivotGroupSchema = z.object({
  dataSourceColumnReference: dataSourceColumnReferenceSchema.optional(),
  groupLimit: pivotGroupLimitSchema.optional(),
  groupRule: pivotGroupRuleSchema.optional(),
  label: z.string().optional(),
  repeatHeadings: z.boolean().optional(),
  showTotals: z.boolean().optional(),
  sortOrder: z.union([z.literal('SORT_ORDER_UNSPECIFIED'), z.literal('ASCENDING'), z.literal('DESCENDING')]).optional(),
  sourceColumnOffset: z.number().optional(),
  valueBucket: pivotGroupSortValueBucketSchema.optional(),
  valueMetadata: z.array(pivotGroupValueMetadataSchema).optional(),
});

export const addConditionalFormatRuleRequestSchema = z.object({
  index: z.number().optional(),
  rule: conditionalFormatRuleSchema.optional(),
});

export const addSlicerRequestSchema = z.object({
  slicer: slicerSchema.optional(),
});

export const setBasicFilterRequestSchema = z.object({
  filter: basicFilterSchema.optional(),
});

export const updateConditionalFormatRuleRequestSchema = z.object({
  index: z.number().optional(),
  newIndex: z.number().optional(),
  rule: conditionalFormatRuleSchema.optional(),
  sheetId: z.number().optional(),
});

export const updateSlicerSpecRequestSchema = z.object({
  fields: z.string().optional(),
  slicerId: z.number().optional(),
  spec: slicerSpecSchema.optional(),
});

export const deleteConditionalFormatRuleResponseSchema = z.object({
  rule: conditionalFormatRuleSchema.optional(),
});

export const updateConditionalFormatRuleResponseSchema = z.object({
  newIndex: z.number().optional(),
  newRule: conditionalFormatRuleSchema.optional(),
  oldIndex: z.number().optional(),
  oldRule: conditionalFormatRuleSchema.optional(),
});

export const scorecardChartSpecSchema = z.object({
  aggregateType: z
    .union([
      z.literal('CHART_AGGREGATE_TYPE_UNSPECIFIED'),
      z.literal('AVERAGE'),
      z.literal('COUNT'),
      z.literal('MAX'),
      z.literal('MEDIAN'),
      z.literal('MIN'),
      z.literal('SUM'),
    ])
    .optional(),
  baselineValueData: chartDataSchema.optional(),
  baselineValueFormat: baselineValueFormatSchema.optional(),
  customFormatOptions: chartCustomNumberFormatOptionsSchema.optional(),
  keyValueData: chartDataSchema.optional(),
  keyValueFormat: keyValueFormatSchema.optional(),
  numberFormatSource: z
    .union([z.literal('CHART_NUMBER_FORMAT_SOURCE_UNDEFINED'), z.literal('FROM_DATA'), z.literal('CUSTOM')])
    .optional(),
  scaleFactor: z.number().optional(),
});

export const bandedRangeSchema = z.object({
  bandedRangeId: z.number().optional(),
  columnProperties: bandingPropertiesSchema.optional(),
  range: gridRangeSchema.optional(),
  rowProperties: bandingPropertiesSchema.optional(),
});

export const dataSourceSchema = z.object({
  calculatedColumns: z.array(dataSourceColumnSchema).optional(),
  dataSourceId: z.string().optional(),
  sheetId: z.number().optional(),
  spec: dataSourceSpecSchema.optional(),
});

export const spreadsheetThemeSchema = z.object({
  primaryFontFamily: z.string().optional(),
  themeColors: z.array(themeColorPairSchema).optional(),
});

export const treemapChartSpecSchema = z.object({
  colorData: chartDataSchema.optional(),
  colorScale: treemapChartColorScaleSchema.optional(),
  headerColor: colorSchema.optional(),
  headerColorStyle: colorStyleSchema.optional(),
  hideTooltips: z.boolean().optional(),
  hintedLevels: z.number().optional(),
  labels: chartDataSchema.optional(),
  levels: z.number().optional(),
  maxValue: z.number().optional(),
  minValue: z.number().optional(),
  parentLabels: chartDataSchema.optional(),
  sizeData: chartDataSchema.optional(),
  textFormat: textFormatSchema.optional(),
});

export const updateBandingRequestSchema = z.object({
  bandedRange: bandedRangeSchema.optional(),
  fields: z.string().optional(),
});

export const updateDataSourceRequestSchema = z.object({
  dataSource: dataSourceSchema.optional(),
  fields: z.string().optional(),
});

export const updateDataSourceResponseSchema = z.object({
  dataExecutionStatus: dataExecutionStatusSchema.optional(),
  dataSource: dataSourceSchema.optional(),
});

export const spreadsheetPropertiesSchema = z.object({
  autoRecalc: z
    .union([
      z.literal('RECALCULATION_INTERVAL_UNSPECIFIED'),
      z.literal('ON_CHANGE'),
      z.literal('MINUTE'),
      z.literal('HOUR'),
    ])
    .optional(),
  defaultFormat: cellFormatSchema.optional(),
  iterativeCalculationSettings: iterativeCalculationSettingsSchema.optional(),
  locale: z.string().optional(),
  spreadsheetTheme: spreadsheetThemeSchema.optional(),
  timeZone: z.string().optional(),
  title: z.string().optional(),
});

export const waterfallChartDomainSchema = z.object({
  data: chartDataSchema.optional(),
  reversed: z.boolean().optional(),
});

export const dataLabelSchema = z.object({
  customLabelData: chartDataSchema.optional(),
  placement: z
    .union([
      z.literal('DATA_LABEL_PLACEMENT_UNSPECIFIED'),
      z.literal('CENTER'),
      z.literal('LEFT'),
      z.literal('RIGHT'),
      z.literal('ABOVE'),
      z.literal('BELOW'),
      z.literal('INSIDE_END'),
      z.literal('INSIDE_BASE'),
      z.literal('OUTSIDE_END'),
    ])
    .optional(),
  textFormat: textFormatSchema.optional(),
  type: z
    .union([z.literal('DATA_LABEL_TYPE_UNSPECIFIED'), z.literal('NONE'), z.literal('DATA'), z.literal('CUSTOM')])
    .optional(),
});

export const waterfallChartSeriesSchema = z.object({
  customSubtotals: z.array(waterfallChartCustomSubtotalSchema).optional(),
  data: chartDataSchema.optional(),
  dataLabel: dataLabelSchema.optional(),
  hideTrailingSubtotal: z.boolean().optional(),
  negativeColumnsStyle: waterfallChartColumnStyleSchema.optional(),
  positiveColumnsStyle: waterfallChartColumnStyleSchema.optional(),
  subtotalColumnsStyle: waterfallChartColumnStyleSchema.optional(),
});

export const sheetsSpreadsheetsValuesAppendResponseSchema = appendValuesResponseSchema;

export const sheetsSpreadsheetsValuesBatchClearByDataFilterDataSchema = z.object({
  body: batchClearValuesByDataFilterRequestSchema.optional(),
  path: z.object({
    spreadsheetId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const sheetsSpreadsheetsValuesBatchGetResponseSchema = batchGetValuesResponseSchema;

export const sheetsSpreadsheetsValuesBatchGetByDataFilterDataSchema = z.object({
  body: batchGetValuesByDataFilterRequestSchema.optional(),
  path: z.object({
    spreadsheetId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const sheetsSpreadsheetsValuesBatchGetByDataFilterResponseSchema = batchGetValuesByDataFilterResponseSchema;

export const sheetsSpreadsheetsValuesBatchUpdateResponseSchema = batchUpdateValuesResponseSchema;

export const batchUpdateValuesByDataFilterRequestSchema = z.object({
  data: z.array(dataFilterValueRangeSchema).optional(),
  includeValuesInResponse: z.boolean().optional(),
  responseDateTimeRenderOption: z.union([z.literal('SERIAL_NUMBER'), z.literal('FORMATTED_STRING')]).optional(),
  responseValueRenderOption: z
    .union([z.literal('FORMATTED_VALUE'), z.literal('UNFORMATTED_VALUE'), z.literal('FORMULA')])
    .optional(),
  valueInputOption: z
    .union([z.literal('INPUT_VALUE_OPTION_UNSPECIFIED'), z.literal('RAW'), z.literal('USER_ENTERED')])
    .optional(),
});

export const sheetsSpreadsheetsValuesBatchUpdateByDataFilterResponseSchema =
  batchUpdateValuesByDataFilterResponseSchema;

export const sheetsSpreadsheetsGetByDataFilterDataSchema = z.object({
  body: getSpreadsheetByDataFilterRequestSchema.optional(),
  path: z.object({
    spreadsheetId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const addBandingRequestSchema = z.object({
  bandedRange: bandedRangeSchema.optional(),
});

export const addBandingResponseSchema = z.object({
  bandedRange: bandedRangeSchema.optional(),
});

export const addDataSourceRequestSchema = z.object({
  dataSource: dataSourceSchema.optional(),
});

export const addDataSourceResponseSchema = z.object({
  dataExecutionStatus: dataExecutionStatusSchema.optional(),
  dataSource: dataSourceSchema.optional(),
});

export const basicChartDomainSchema = z.object({
  domain: chartDataSchema.optional(),
  reversed: z.boolean().optional(),
});

export const basicChartSeriesSchema = z.object({
  color: colorSchema.optional(),
  colorStyle: colorStyleSchema.optional(),
  dataLabel: dataLabelSchema.optional(),
  lineStyle: lineStyleSchema.optional(),
  pointStyle: pointStyleSchema.optional(),
  series: chartDataSchema.optional(),
  styleOverrides: z.array(basicSeriesDataPointStyleOverrideSchema).optional(),
  targetAxis: z
    .union([
      z.literal('BASIC_CHART_AXIS_POSITION_UNSPECIFIED'),
      z.literal('BOTTOM_AXIS'),
      z.literal('LEFT_AXIS'),
      z.literal('RIGHT_AXIS'),
    ])
    .optional(),
  type: z
    .union([
      z.literal('BASIC_CHART_TYPE_UNSPECIFIED'),
      z.literal('BAR'),
      z.literal('LINE'),
      z.literal('AREA'),
      z.literal('COLUMN'),
      z.literal('SCATTER'),
      z.literal('COMBO'),
      z.literal('STEPPED_AREA'),
    ])
    .optional(),
});

export const basicChartSpecSchema = z.object({
  axis: z.array(basicChartAxisSchema).optional(),
  chartType: z
    .union([
      z.literal('BASIC_CHART_TYPE_UNSPECIFIED'),
      z.literal('BAR'),
      z.literal('LINE'),
      z.literal('AREA'),
      z.literal('COLUMN'),
      z.literal('SCATTER'),
      z.literal('COMBO'),
      z.literal('STEPPED_AREA'),
    ])
    .optional(),
  compareMode: z
    .union([z.literal('BASIC_CHART_COMPARE_MODE_UNSPECIFIED'), z.literal('DATUM'), z.literal('CATEGORY')])
    .optional(),
  domains: z.array(basicChartDomainSchema).optional(),
  headerCount: z.number().optional(),
  interpolateNulls: z.boolean().optional(),
  legendPosition: z
    .union([
      z.literal('BASIC_CHART_LEGEND_POSITION_UNSPECIFIED'),
      z.literal('BOTTOM_LEGEND'),
      z.literal('LEFT_LEGEND'),
      z.literal('RIGHT_LEGEND'),
      z.literal('TOP_LEGEND'),
      z.literal('NO_LEGEND'),
    ])
    .optional(),
  lineSmoothing: z.boolean().optional(),
  series: z.array(basicChartSeriesSchema).optional(),
  stackedType: z
    .union([
      z.literal('BASIC_CHART_STACKED_TYPE_UNSPECIFIED'),
      z.literal('NOT_STACKED'),
      z.literal('STACKED'),
      z.literal('PERCENT_STACKED'),
    ])
    .optional(),
  threeDimensional: z.boolean().optional(),
  totalDataLabel: dataLabelSchema.optional(),
});

export const bubbleChartSpecSchema = z.object({
  bubbleBorderColor: colorSchema.optional(),
  bubbleBorderColorStyle: colorStyleSchema.optional(),
  bubbleLabels: chartDataSchema.optional(),
  bubbleMaxRadiusSize: z.number().optional(),
  bubbleMinRadiusSize: z.number().optional(),
  bubbleOpacity: z.number().optional(),
  bubbleSizes: chartDataSchema.optional(),
  bubbleTextStyle: textFormatSchema.optional(),
  domain: chartDataSchema.optional(),
  groupIds: chartDataSchema.optional(),
  legendPosition: z
    .union([
      z.literal('BUBBLE_CHART_LEGEND_POSITION_UNSPECIFIED'),
      z.literal('BOTTOM_LEGEND'),
      z.literal('LEFT_LEGEND'),
      z.literal('RIGHT_LEGEND'),
      z.literal('TOP_LEGEND'),
      z.literal('NO_LEGEND'),
      z.literal('INSIDE_LEGEND'),
    ])
    .optional(),
  series: chartDataSchema.optional(),
});

export const candlestickDomainSchema = z.object({
  data: chartDataSchema.optional(),
  reversed: z.boolean().optional(),
});

export const candlestickSeriesSchema = z.object({
  data: chartDataSchema.optional(),
});

export const pivotTableSchema = z.object({
  columns: z.array(pivotGroupSchema).optional(),
  criteria: z.record(pivotFilterCriteriaSchema).optional(),
  dataExecutionStatus: dataExecutionStatusSchema.optional(),
  dataSourceId: z.string().optional(),
  filterSpecs: z.array(pivotFilterSpecSchema).optional(),
  rows: z.array(pivotGroupSchema).optional(),
  source: gridRangeSchema.optional(),
  valueLayout: z.union([z.literal('HORIZONTAL'), z.literal('VERTICAL')]).optional(),
  values: z.array(pivotValueSchema).optional(),
});

export const histogramChartSpecSchema = z.object({
  bucketSize: z.number().optional(),
  legendPosition: z
    .union([
      z.literal('HISTOGRAM_CHART_LEGEND_POSITION_UNSPECIFIED'),
      z.literal('BOTTOM_LEGEND'),
      z.literal('LEFT_LEGEND'),
      z.literal('RIGHT_LEGEND'),
      z.literal('TOP_LEGEND'),
      z.literal('NO_LEGEND'),
      z.literal('INSIDE_LEGEND'),
    ])
    .optional(),
  outlierPercentile: z.number().optional(),
  series: z.array(histogramSeriesSchema).optional(),
  showItemDividers: z.boolean().optional(),
});

export const waterfallChartSpecSchema = z.object({
  connectorLineStyle: lineStyleSchema.optional(),
  domain: waterfallChartDomainSchema.optional(),
  firstValueIsTotal: z.boolean().optional(),
  hideConnectorLines: z.boolean().optional(),
  series: z.array(waterfallChartSeriesSchema).optional(),
  stackedType: z
    .union([z.literal('WATERFALL_STACKED_TYPE_UNSPECIFIED'), z.literal('STACKED'), z.literal('SEQUENTIAL')])
    .optional(),
  totalDataLabel: dataLabelSchema.optional(),
});

export const cellDataSchema = z.object({
  dataSourceFormula: dataSourceFormulaSchema.optional(),
  dataSourceTable: dataSourceTableSchema.optional(),
  dataValidation: dataValidationRuleSchema.optional(),
  effectiveFormat: cellFormatSchema.optional(),
  effectiveValue: extendedValueSchema.optional(),
  formattedValue: z.string().optional(),
  hyperlink: z.string().optional(),
  note: z.string().optional(),
  pivotTable: pivotTableSchema.optional(),
  textFormatRuns: z.array(textFormatRunSchema).optional(),
  userEnteredFormat: cellFormatSchema.optional(),
  userEnteredValue: extendedValueSchema.optional(),
});

export const repeatCellRequestSchema = z.object({
  cell: cellDataSchema.optional(),
  fields: z.string().optional(),
  range: gridRangeSchema.optional(),
});

export const updateSpreadsheetPropertiesRequestSchema = z.object({
  fields: z.string().optional(),
  properties: spreadsheetPropertiesSchema.optional(),
});

export const rowDataSchema = z.object({
  values: z.array(cellDataSchema).optional(),
});

export const gridDataSchema = z.object({
  columnMetadata: z.array(dimensionPropertiesSchema).optional(),
  rowData: z.array(rowDataSchema).optional(),
  rowMetadata: z.array(dimensionPropertiesSchema).optional(),
  startColumn: z.number().optional(),
  startRow: z.number().optional(),
});

export const updateCellsRequestSchema = z.object({
  fields: z.string().optional(),
  range: gridRangeSchema.optional(),
  rows: z.array(rowDataSchema).optional(),
  start: gridCoordinateSchema.optional(),
});

export const sheetsSpreadsheetsValuesBatchUpdateByDataFilterDataSchema = z.object({
  body: batchUpdateValuesByDataFilterRequestSchema.optional(),
  path: z.object({
    spreadsheetId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const appendCellsRequestSchema = z.object({
  fields: z.string().optional(),
  rows: z.array(rowDataSchema).optional(),
  sheetId: z.number().optional(),
});

export const candlestickDataSchema = z.object({
  closeSeries: candlestickSeriesSchema.optional(),
  highSeries: candlestickSeriesSchema.optional(),
  lowSeries: candlestickSeriesSchema.optional(),
  openSeries: candlestickSeriesSchema.optional(),
});

export const candlestickChartSpecSchema = z.object({
  data: z.array(candlestickDataSchema).optional(),
  domain: candlestickDomainSchema.optional(),
});

export const chartSpecSchema = z.object({
  altText: z.string().optional(),
  backgroundColor: colorSchema.optional(),
  backgroundColorStyle: colorStyleSchema.optional(),
  basicChart: basicChartSpecSchema.optional(),
  bubbleChart: bubbleChartSpecSchema.optional(),
  candlestickChart: candlestickChartSpecSchema.optional(),
  dataSourceChartProperties: dataSourceChartPropertiesSchema.optional(),
  filterSpecs: z.array(filterSpecSchema).optional(),
  fontName: z.string().optional(),
  hiddenDimensionStrategy: z
    .union([
      z.literal('CHART_HIDDEN_DIMENSION_STRATEGY_UNSPECIFIED'),
      z.literal('SKIP_HIDDEN_ROWS_AND_COLUMNS'),
      z.literal('SKIP_HIDDEN_ROWS'),
      z.literal('SKIP_HIDDEN_COLUMNS'),
      z.literal('SHOW_ALL'),
    ])
    .optional(),
  histogramChart: histogramChartSpecSchema.optional(),
  maximized: z.boolean().optional(),
  orgChart: orgChartSpecSchema.optional(),
  pieChart: pieChartSpecSchema.optional(),
  scorecardChart: scorecardChartSpecSchema.optional(),
  sortSpecs: z.array(sortSpecSchema).optional(),
  subtitle: z.string().optional(),
  subtitleTextFormat: textFormatSchema.optional(),
  subtitleTextPosition: textPositionSchema.optional(),
  title: z.string().optional(),
  titleTextFormat: textFormatSchema.optional(),
  titleTextPosition: textPositionSchema.optional(),
  treemapChart: treemapChartSpecSchema.optional(),
  waterfallChart: waterfallChartSpecSchema.optional(),
});

export const updateChartSpecRequestSchema = z.object({
  chartId: z.number().optional(),
  spec: chartSpecSchema.optional(),
});

export const embeddedChartSchema = z.object({
  border: embeddedObjectBorderSchema.optional(),
  chartId: z.number().optional(),
  position: embeddedObjectPositionSchema.optional(),
  spec: chartSpecSchema.optional(),
});

export const sheetSchema = z.object({
  bandedRanges: z.array(bandedRangeSchema).optional(),
  basicFilter: basicFilterSchema.optional(),
  charts: z.array(embeddedChartSchema).optional(),
  columnGroups: z.array(dimensionGroupSchema).optional(),
  conditionalFormats: z.array(conditionalFormatRuleSchema).optional(),
  data: z.array(gridDataSchema).optional(),
  developerMetadata: z.array(developerMetadataSchema).optional(),
  filterViews: z.array(filterViewSchema).optional(),
  merges: z.array(gridRangeSchema).optional(),
  properties: sheetPropertiesSchema.optional(),
  protectedRanges: z.array(protectedRangeSchema).optional(),
  rowGroups: z.array(dimensionGroupSchema).optional(),
  slicers: z.array(slicerSchema).optional(),
});

export const spreadsheetSchema = z.object({
  dataSourceSchedules: z.array(dataSourceRefreshScheduleSchema).optional(),
  dataSources: z.array(dataSourceSchema).optional(),
  developerMetadata: z.array(developerMetadataSchema).optional(),
  namedRanges: z.array(namedRangeSchema).optional(),
  properties: spreadsheetPropertiesSchema.optional(),
  sheets: z.array(sheetSchema).optional(),
  spreadsheetId: z.string().optional(),
  spreadsheetUrl: z.string().optional(),
});

export const sheetsSpreadsheetsCreateResponseSchema = spreadsheetSchema;

export const sheetsSpreadsheetsGetResponseSchema = spreadsheetSchema;

export const sheetsSpreadsheetsGetByDataFilterResponseSchema = spreadsheetSchema;

export const addChartRequestSchema = z.object({
  chart: embeddedChartSchema.optional(),
});

export const addChartResponseSchema = z.object({
  chart: embeddedChartSchema.optional(),
});

export const requestSchema = z.object({
  addBanding: addBandingRequestSchema.optional(),
  addChart: addChartRequestSchema.optional(),
  addConditionalFormatRule: addConditionalFormatRuleRequestSchema.optional(),
  addDataSource: addDataSourceRequestSchema.optional(),
  addDimensionGroup: addDimensionGroupRequestSchema.optional(),
  addFilterView: addFilterViewRequestSchema.optional(),
  addNamedRange: addNamedRangeRequestSchema.optional(),
  addProtectedRange: addProtectedRangeRequestSchema.optional(),
  addSheet: addSheetRequestSchema.optional(),
  addSlicer: addSlicerRequestSchema.optional(),
  appendCells: appendCellsRequestSchema.optional(),
  appendDimension: appendDimensionRequestSchema.optional(),
  autoFill: autoFillRequestSchema.optional(),
  autoResizeDimensions: autoResizeDimensionsRequestSchema.optional(),
  clearBasicFilter: clearBasicFilterRequestSchema.optional(),
  copyPaste: copyPasteRequestSchema.optional(),
  createDeveloperMetadata: createDeveloperMetadataRequestSchema.optional(),
  cutPaste: cutPasteRequestSchema.optional(),
  deleteBanding: deleteBandingRequestSchema.optional(),
  deleteConditionalFormatRule: deleteConditionalFormatRuleRequestSchema.optional(),
  deleteDataSource: deleteDataSourceRequestSchema.optional(),
  deleteDeveloperMetadata: deleteDeveloperMetadataRequestSchema.optional(),
  deleteDimension: deleteDimensionRequestSchema.optional(),
  deleteDimensionGroup: deleteDimensionGroupRequestSchema.optional(),
  deleteDuplicates: deleteDuplicatesRequestSchema.optional(),
  deleteEmbeddedObject: deleteEmbeddedObjectRequestSchema.optional(),
  deleteFilterView: deleteFilterViewRequestSchema.optional(),
  deleteNamedRange: deleteNamedRangeRequestSchema.optional(),
  deleteProtectedRange: deleteProtectedRangeRequestSchema.optional(),
  deleteRange: deleteRangeRequestSchema.optional(),
  deleteSheet: deleteSheetRequestSchema.optional(),
  duplicateFilterView: duplicateFilterViewRequestSchema.optional(),
  duplicateSheet: duplicateSheetRequestSchema.optional(),
  findReplace: findReplaceRequestSchema.optional(),
  insertDimension: insertDimensionRequestSchema.optional(),
  insertRange: insertRangeRequestSchema.optional(),
  mergeCells: mergeCellsRequestSchema.optional(),
  moveDimension: moveDimensionRequestSchema.optional(),
  pasteData: pasteDataRequestSchema.optional(),
  randomizeRange: randomizeRangeRequestSchema.optional(),
  refreshDataSource: refreshDataSourceRequestSchema.optional(),
  repeatCell: repeatCellRequestSchema.optional(),
  setBasicFilter: setBasicFilterRequestSchema.optional(),
  setDataValidation: setDataValidationRequestSchema.optional(),
  sortRange: sortRangeRequestSchema.optional(),
  textToColumns: textToColumnsRequestSchema.optional(),
  trimWhitespace: trimWhitespaceRequestSchema.optional(),
  unmergeCells: unmergeCellsRequestSchema.optional(),
  updateBanding: updateBandingRequestSchema.optional(),
  updateBorders: updateBordersRequestSchema.optional(),
  updateCells: updateCellsRequestSchema.optional(),
  updateChartSpec: updateChartSpecRequestSchema.optional(),
  updateConditionalFormatRule: updateConditionalFormatRuleRequestSchema.optional(),
  updateDataSource: updateDataSourceRequestSchema.optional(),
  updateDeveloperMetadata: updateDeveloperMetadataRequestSchema.optional(),
  updateDimensionGroup: updateDimensionGroupRequestSchema.optional(),
  updateDimensionProperties: updateDimensionPropertiesRequestSchema.optional(),
  updateEmbeddedObjectBorder: updateEmbeddedObjectBorderRequestSchema.optional(),
  updateEmbeddedObjectPosition: updateEmbeddedObjectPositionRequestSchema.optional(),
  updateFilterView: updateFilterViewRequestSchema.optional(),
  updateNamedRange: updateNamedRangeRequestSchema.optional(),
  updateProtectedRange: updateProtectedRangeRequestSchema.optional(),
  updateSheetProperties: updateSheetPropertiesRequestSchema.optional(),
  updateSlicerSpec: updateSlicerSpecRequestSchema.optional(),
  updateSpreadsheetProperties: updateSpreadsheetPropertiesRequestSchema.optional(),
});

export const responseSchema = z.object({
  addBanding: addBandingResponseSchema.optional(),
  addChart: addChartResponseSchema.optional(),
  addDataSource: addDataSourceResponseSchema.optional(),
  addDimensionGroup: addDimensionGroupResponseSchema.optional(),
  addFilterView: addFilterViewResponseSchema.optional(),
  addNamedRange: addNamedRangeResponseSchema.optional(),
  addProtectedRange: addProtectedRangeResponseSchema.optional(),
  addSheet: addSheetResponseSchema.optional(),
  addSlicer: addSlicerResponseSchema.optional(),
  createDeveloperMetadata: createDeveloperMetadataResponseSchema.optional(),
  deleteConditionalFormatRule: deleteConditionalFormatRuleResponseSchema.optional(),
  deleteDeveloperMetadata: deleteDeveloperMetadataResponseSchema.optional(),
  deleteDimensionGroup: deleteDimensionGroupResponseSchema.optional(),
  deleteDuplicates: deleteDuplicatesResponseSchema.optional(),
  duplicateFilterView: duplicateFilterViewResponseSchema.optional(),
  duplicateSheet: duplicateSheetResponseSchema.optional(),
  findReplace: findReplaceResponseSchema.optional(),
  refreshDataSource: refreshDataSourceResponseSchema.optional(),
  trimWhitespace: trimWhitespaceResponseSchema.optional(),
  updateConditionalFormatRule: updateConditionalFormatRuleResponseSchema.optional(),
  updateDataSource: updateDataSourceResponseSchema.optional(),
  updateDeveloperMetadata: updateDeveloperMetadataResponseSchema.optional(),
  updateEmbeddedObjectPosition: updateEmbeddedObjectPositionResponseSchema.optional(),
});

export const sheetsSpreadsheetsCreateDataSchema = z.object({
  body: spreadsheetSchema.optional(),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const batchUpdateSpreadsheetRequestSchema = z.object({
  includeSpreadsheetInResponse: z.boolean().optional(),
  requests: z.array(requestSchema).optional(),
  responseIncludeGridData: z.boolean().optional(),
  responseRanges: z.array(z.string()).optional(),
});

export const batchUpdateSpreadsheetResponseSchema = z.object({
  replies: z.array(responseSchema).optional(),
  spreadsheetId: z.string().optional(),
  updatedSpreadsheet: spreadsheetSchema.optional(),
});

export const sheetsSpreadsheetsBatchUpdateDataSchema = z.object({
  body: batchUpdateSpreadsheetRequestSchema.optional(),
  path: z.object({
    spreadsheetId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const sheetsSpreadsheetsBatchUpdateResponseSchema = batchUpdateSpreadsheetResponseSchema;
