// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  SheetsSpreadsheetsCreateData,
  SheetsSpreadsheetsCreateError,
  SheetsSpreadsheetsCreateResponse,
  SheetsSpreadsheetsGetData,
  SheetsSpreadsheetsGetError,
  SheetsSpreadsheetsGetResponse,
  SheetsSpreadsheetsDeveloperMetadataGetData,
  SheetsSpreadsheetsDeveloperMetadataGetError,
  SheetsSpreadsheetsDeveloperMetadataGetResponse,
  SheetsSpreadsheetsDeveloperMetadataSearchData,
  SheetsSpreadsheetsDeveloperMetadataSearchError,
  SheetsSpreadsheetsDeveloperMetadataSearchResponse,
  SheetsSpreadsheetsSheetsCopyToData,
  SheetsSpreadsheetsSheetsCopyToError,
  SheetsSpreadsheetsSheetsCopyToResponse,
  SheetsSpreadsheetsValuesGetData,
  SheetsSpreadsheetsValuesGetError,
  SheetsSpreadsheetsValuesGetResponse,
  SheetsSpreadsheetsValuesUpdateData,
  SheetsSpreadsheetsValuesUpdateError,
  SheetsSpreadsheetsValuesUpdateResponse,
  SheetsSpreadsheetsValuesAppendData,
  SheetsSpreadsheetsValuesAppendError,
  SheetsSpreadsheetsValuesAppendResponse,
  SheetsSpreadsheetsValuesClearData,
  SheetsSpreadsheetsValuesClearError,
  SheetsSpreadsheetsValuesClearResponse,
  SheetsSpreadsheetsValuesBatchClearData,
  SheetsSpreadsheetsValuesBatchClearError,
  SheetsSpreadsheetsValuesBatchClearResponse,
  SheetsSpreadsheetsValuesBatchClearByDataFilterData,
  SheetsSpreadsheetsValuesBatchClearByDataFilterError,
  SheetsSpreadsheetsValuesBatchClearByDataFilterResponse,
  SheetsSpreadsheetsValuesBatchGetData,
  SheetsSpreadsheetsValuesBatchGetError,
  SheetsSpreadsheetsValuesBatchGetResponse,
  SheetsSpreadsheetsValuesBatchGetByDataFilterData,
  SheetsSpreadsheetsValuesBatchGetByDataFilterError,
  SheetsSpreadsheetsValuesBatchGetByDataFilterResponse,
  SheetsSpreadsheetsValuesBatchUpdateData,
  SheetsSpreadsheetsValuesBatchUpdateError,
  SheetsSpreadsheetsValuesBatchUpdateResponse,
  SheetsSpreadsheetsValuesBatchUpdateByDataFilterData,
  SheetsSpreadsheetsValuesBatchUpdateByDataFilterError,
  SheetsSpreadsheetsValuesBatchUpdateByDataFilterResponse,
  SheetsSpreadsheetsBatchUpdateData,
  SheetsSpreadsheetsBatchUpdateError,
  SheetsSpreadsheetsBatchUpdateResponse,
  SheetsSpreadsheetsGetByDataFilterData,
  SheetsSpreadsheetsGetByDataFilterError,
  SheetsSpreadsheetsGetByDataFilterResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Creates a spreadsheet, returning the newly created spreadsheet.
 */
export const sheetsSpreadsheetsCreate = <ThrowOnError extends boolean = false>(
  options?: Options<SheetsSpreadsheetsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SheetsSpreadsheetsCreateResponse,
    SheetsSpreadsheetsCreateError,
    ThrowOnError
  >({
    ...options,
    url: '/v4/spreadsheets',
  });
};

/**
 * Returns the spreadsheet at the given ID. The caller must specify the spreadsheet ID. By default, data within grids is not returned. You can include grid data in one of 2 ways: * Specify a [field mask](https://developers.google.com/sheets/api/guides/field-masks) listing your desired fields using the `fields` URL parameter in HTTP * Set the includeGridData URL parameter to true. If a field mask is set, the `includeGridData` parameter is ignored For large spreadsheets, as a best practice, retrieve only the specific spreadsheet fields that you want. To retrieve only subsets of spreadsheet data, use the ranges URL parameter. Ranges are specified using [A1 notation](/sheets/api/guides/concepts#cell). You can define a single cell (for example, `A1`) or multiple cells (for example, `A1:D5`). You can also get cells from other sheets within the same spreadsheet (for example, `Sheet2!A1:C4`) or retrieve multiple ranges at once (for example, `?ranges=A1:D5&ranges=Sheet2!A1:C4`). Limiting the range returns only the portions of the spreadsheet that intersect the requested ranges.
 */
export const sheetsSpreadsheetsGet = <ThrowOnError extends boolean = false>(
  options: Options<SheetsSpreadsheetsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<SheetsSpreadsheetsGetResponse, SheetsSpreadsheetsGetError, ThrowOnError>({
    ...options,
    url: '/v4/spreadsheets/{spreadsheetId}',
  });
};

/**
 * Returns the developer metadata with the specified ID. The caller must specify the spreadsheet ID and the developer metadata's unique metadataId.
 */
export const sheetsSpreadsheetsDeveloperMetadataGet = <ThrowOnError extends boolean = false>(
  options: Options<SheetsSpreadsheetsDeveloperMetadataGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    SheetsSpreadsheetsDeveloperMetadataGetResponse,
    SheetsSpreadsheetsDeveloperMetadataGetError,
    ThrowOnError
  >({
    ...options,
    url: '/v4/spreadsheets/{spreadsheetId}/developerMetadata/{metadataId}',
  });
};

/**
 * Returns all developer metadata matching the specified DataFilter. If the provided DataFilter represents a DeveloperMetadataLookup object, this will return all DeveloperMetadata entries selected by it. If the DataFilter represents a location in a spreadsheet, this will return all developer metadata associated with locations intersecting that region.
 */
export const sheetsSpreadsheetsDeveloperMetadataSearch = <ThrowOnError extends boolean = false>(
  options: Options<SheetsSpreadsheetsDeveloperMetadataSearchData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SheetsSpreadsheetsDeveloperMetadataSearchResponse,
    SheetsSpreadsheetsDeveloperMetadataSearchError,
    ThrowOnError
  >({
    ...options,
    url: '/v4/spreadsheets/{spreadsheetId}/developerMetadata:search',
  });
};

/**
 * Copies a single sheet from a spreadsheet to another spreadsheet. Returns the properties of the newly created sheet.
 */
export const sheetsSpreadsheetsSheetsCopyTo = <ThrowOnError extends boolean = false>(
  options: Options<SheetsSpreadsheetsSheetsCopyToData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SheetsSpreadsheetsSheetsCopyToResponse,
    SheetsSpreadsheetsSheetsCopyToError,
    ThrowOnError
  >({
    ...options,
    url: '/v4/spreadsheets/{spreadsheetId}/sheets/{sheetId}:copyTo',
  });
};

/**
 * Returns a range of values from a spreadsheet. The caller must specify the spreadsheet ID and a range.
 */
export const sheetsSpreadsheetsValuesGet = <ThrowOnError extends boolean = false>(
  options: Options<SheetsSpreadsheetsValuesGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    SheetsSpreadsheetsValuesGetResponse,
    SheetsSpreadsheetsValuesGetError,
    ThrowOnError
  >({
    ...options,
    url: '/v4/spreadsheets/{spreadsheetId}/values/{range}',
  });
};

/**
 * Sets values in a range of a spreadsheet. The caller must specify the spreadsheet ID, range, and a valueInputOption.
 */
export const sheetsSpreadsheetsValuesUpdate = <ThrowOnError extends boolean = false>(
  options: Options<SheetsSpreadsheetsValuesUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    SheetsSpreadsheetsValuesUpdateResponse,
    SheetsSpreadsheetsValuesUpdateError,
    ThrowOnError
  >({
    ...options,
    url: '/v4/spreadsheets/{spreadsheetId}/values/{range}',
  });
};

/**
 * Appends values to a spreadsheet. The input range is used to search for existing data and find a "table" within that range. Values will be appended to the next row of the table, starting with the first column of the table. See the [guide](/sheets/api/guides/values#appending_values) and [sample code](/sheets/api/samples/writing#append_values) for specific details of how tables are detected and data is appended. The caller must specify the spreadsheet ID, range, and a valueInputOption. The `valueInputOption` only controls how the input data will be added to the sheet (column-wise or row-wise), it does not influence what cell the data starts being written to.
 */
export const sheetsSpreadsheetsValuesAppend = <ThrowOnError extends boolean = false>(
  options: Options<SheetsSpreadsheetsValuesAppendData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SheetsSpreadsheetsValuesAppendResponse,
    SheetsSpreadsheetsValuesAppendError,
    ThrowOnError
  >({
    ...options,
    url: '/v4/spreadsheets/{spreadsheetId}/values/{range}:append',
  });
};

/**
 * Clears values from a spreadsheet. The caller must specify the spreadsheet ID and range. Only values are cleared -- all other properties of the cell (such as formatting, data validation, etc..) are kept.
 */
export const sheetsSpreadsheetsValuesClear = <ThrowOnError extends boolean = false>(
  options: Options<SheetsSpreadsheetsValuesClearData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SheetsSpreadsheetsValuesClearResponse,
    SheetsSpreadsheetsValuesClearError,
    ThrowOnError
  >({
    ...options,
    url: '/v4/spreadsheets/{spreadsheetId}/values/{range}:clear',
  });
};

/**
 * Clears one or more ranges of values from a spreadsheet. The caller must specify the spreadsheet ID and one or more ranges. Only values are cleared -- all other properties of the cell (such as formatting and data validation) are kept.
 */
export const sheetsSpreadsheetsValuesBatchClear = <ThrowOnError extends boolean = false>(
  options: Options<SheetsSpreadsheetsValuesBatchClearData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SheetsSpreadsheetsValuesBatchClearResponse,
    SheetsSpreadsheetsValuesBatchClearError,
    ThrowOnError
  >({
    ...options,
    url: '/v4/spreadsheets/{spreadsheetId}/values:batchClear',
  });
};

/**
 * Clears one or more ranges of values from a spreadsheet. The caller must specify the spreadsheet ID and one or more DataFilters. Ranges matching any of the specified data filters will be cleared. Only values are cleared -- all other properties of the cell (such as formatting, data validation, etc..) are kept.
 */
export const sheetsSpreadsheetsValuesBatchClearByDataFilter = <ThrowOnError extends boolean = false>(
  options: Options<SheetsSpreadsheetsValuesBatchClearByDataFilterData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SheetsSpreadsheetsValuesBatchClearByDataFilterResponse,
    SheetsSpreadsheetsValuesBatchClearByDataFilterError,
    ThrowOnError
  >({
    ...options,
    url: '/v4/spreadsheets/{spreadsheetId}/values:batchClearByDataFilter',
  });
};

/**
 * Returns one or more ranges of values from a spreadsheet. The caller must specify the spreadsheet ID and one or more ranges.
 */
export const sheetsSpreadsheetsValuesBatchGet = <ThrowOnError extends boolean = false>(
  options: Options<SheetsSpreadsheetsValuesBatchGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    SheetsSpreadsheetsValuesBatchGetResponse,
    SheetsSpreadsheetsValuesBatchGetError,
    ThrowOnError
  >({
    ...options,
    url: '/v4/spreadsheets/{spreadsheetId}/values:batchGet',
  });
};

/**
 * Returns one or more ranges of values that match the specified data filters. The caller must specify the spreadsheet ID and one or more DataFilters. Ranges that match any of the data filters in the request will be returned.
 */
export const sheetsSpreadsheetsValuesBatchGetByDataFilter = <ThrowOnError extends boolean = false>(
  options: Options<SheetsSpreadsheetsValuesBatchGetByDataFilterData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SheetsSpreadsheetsValuesBatchGetByDataFilterResponse,
    SheetsSpreadsheetsValuesBatchGetByDataFilterError,
    ThrowOnError
  >({
    ...options,
    url: '/v4/spreadsheets/{spreadsheetId}/values:batchGetByDataFilter',
  });
};

/**
 * Sets values in one or more ranges of a spreadsheet. The caller must specify the spreadsheet ID, a valueInputOption, and one or more ValueRanges.
 */
export const sheetsSpreadsheetsValuesBatchUpdate = <ThrowOnError extends boolean = false>(
  options: Options<SheetsSpreadsheetsValuesBatchUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SheetsSpreadsheetsValuesBatchUpdateResponse,
    SheetsSpreadsheetsValuesBatchUpdateError,
    ThrowOnError
  >({
    ...options,
    url: '/v4/spreadsheets/{spreadsheetId}/values:batchUpdate',
  });
};

/**
 * Sets values in one or more ranges of a spreadsheet. The caller must specify the spreadsheet ID, a valueInputOption, and one or more DataFilterValueRanges.
 */
export const sheetsSpreadsheetsValuesBatchUpdateByDataFilter = <ThrowOnError extends boolean = false>(
  options: Options<SheetsSpreadsheetsValuesBatchUpdateByDataFilterData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SheetsSpreadsheetsValuesBatchUpdateByDataFilterResponse,
    SheetsSpreadsheetsValuesBatchUpdateByDataFilterError,
    ThrowOnError
  >({
    ...options,
    url: '/v4/spreadsheets/{spreadsheetId}/values:batchUpdateByDataFilter',
  });
};

/**
 * Applies one or more updates to the spreadsheet. Each request is validated before being applied. If any request is not valid then the entire request will fail and nothing will be applied. Some requests have replies to give you some information about how they are applied. The replies will mirror the requests. For example, if you applied 4 updates and the 3rd one had a reply, then the response will have 2 empty replies, the actual reply, and another empty reply, in that order. Due to the collaborative nature of spreadsheets, it is not guaranteed that the spreadsheet will reflect exactly your changes after this completes, however it is guaranteed that the updates in the request will be applied together atomically. Your changes may be altered with respect to collaborator changes. If there are no collaborators, the spreadsheet should reflect your changes.
 */
export const sheetsSpreadsheetsBatchUpdate = <ThrowOnError extends boolean = false>(
  options: Options<SheetsSpreadsheetsBatchUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SheetsSpreadsheetsBatchUpdateResponse,
    SheetsSpreadsheetsBatchUpdateError,
    ThrowOnError
  >({
    ...options,
    url: '/v4/spreadsheets/{spreadsheetId}:batchUpdate',
  });
};

/**
 * Returns the spreadsheet at the given ID. The caller must specify the spreadsheet ID. This method differs from GetSpreadsheet in that it allows selecting which subsets of spreadsheet data to return by specifying a dataFilters parameter. Multiple DataFilters can be specified. Specifying one or more data filters returns the portions of the spreadsheet that intersect ranges matched by any of the filters. By default, data within grids is not returned. You can include grid data one of 2 ways: * Specify a [field mask](https://developers.google.com/sheets/api/guides/field-masks) listing your desired fields using the `fields` URL parameter in HTTP * Set the includeGridData parameter to true. If a field mask is set, the `includeGridData` parameter is ignored For large spreadsheets, as a best practice, retrieve only the specific spreadsheet fields that you want.
 */
export const sheetsSpreadsheetsGetByDataFilter = <ThrowOnError extends boolean = false>(
  options: Options<SheetsSpreadsheetsGetByDataFilterData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    SheetsSpreadsheetsGetByDataFilterResponse,
    SheetsSpreadsheetsGetByDataFilterError,
    ThrowOnError
  >({
    ...options,
    url: '/v4/spreadsheets/{spreadsheetId}:getByDataFilter',
  });
};
