// Generated by ts-to-zod
import { z } from 'zod';

import { type MessagePart } from './types.gen';

export const autoForwardingSchema = z.object({
  disposition: z
    .union([
      z.literal('dispositionUnspecified'),
      z.literal('leaveInInbox'),
      z.literal('archive'),
      z.literal('trash'),
      z.literal('markRead'),
    ])
    .optional(),
  emailAddress: z.string().optional(),
  enabled: z.boolean().optional(),
});

export const dispositionSchema = z.union([
  z.literal('dispositionUnspecified'),
  z.literal('leaveInInbox'),
  z.literal('archive'),
  z.literal('trash'),
  z.literal('markRead'),
]);

export const batchDeleteMessagesRequestSchema = z.object({
  ids: z.array(z.string()).optional(),
});

export const batchModifyMessagesRequestSchema = z.object({
  addLabelIds: z.array(z.string()).optional(),
  ids: z.array(z.string()).optional(),
  removeLabelIds: z.array(z.string()).optional(),
});

export const signAndEncryptKeyPairsSchema = z.object({
  encryptionKeyPairId: z.string().optional(),
  signingKeyPairId: z.string().optional(),
});

export const enablementStateSchema = z.union([
  z.literal('stateUnspecified'),
  z.literal('enabled'),
  z.literal('disabled'),
]);

export const hardwareKeyMetadataSchema = z.object({
  description: z.string().optional(),
});

export const kaclsKeyMetadataSchema = z.object({
  kaclsData: z.string().optional(),
  kaclsUri: z.string().optional(),
});

export const delegateSchema = z.object({
  delegateEmail: z.string().optional(),
  verificationStatus: z
    .union([
      z.literal('verificationStatusUnspecified'),
      z.literal('accepted'),
      z.literal('pending'),
      z.literal('rejected'),
      z.literal('expired'),
    ])
    .optional(),
});

export const verificationStatusSchema = z.union([
  z.literal('verificationStatusUnspecified'),
  z.literal('accepted'),
  z.literal('pending'),
  z.literal('rejected'),
  z.literal('expired'),
]);

export const disableCseKeyPairRequestSchema = z.record(z.unknown());

export const enableCseKeyPairRequestSchema = z.record(z.unknown());

export const filterActionSchema = z.object({
  addLabelIds: z.array(z.string()).optional(),
  forward: z.string().optional(),
  removeLabelIds: z.array(z.string()).optional(),
});

export const filterCriteriaSchema = z.object({
  excludeChats: z.boolean().optional(),
  from: z.string().optional(),
  hasAttachment: z.boolean().optional(),
  negatedQuery: z.string().optional(),
  query: z.string().optional(),
  size: z.number().optional(),
  sizeComparison: z.union([z.literal('unspecified'), z.literal('smaller'), z.literal('larger')]).optional(),
  subject: z.string().optional(),
  to: z.string().optional(),
});

export const sizeComparisonSchema = z.union([z.literal('unspecified'), z.literal('smaller'), z.literal('larger')]);

export const forwardingAddressSchema = z.object({
  forwardingEmail: z.string().optional(),
  verificationStatus: z
    .union([z.literal('verificationStatusUnspecified'), z.literal('accepted'), z.literal('pending')])
    .optional(),
});

export const verificationStatus2Schema = z.union([
  z.literal('verificationStatusUnspecified'),
  z.literal('accepted'),
  z.literal('pending'),
]);

export const imapSettingsSchema = z.object({
  autoExpunge: z.boolean().optional(),
  enabled: z.boolean().optional(),
  expungeBehavior: z
    .union([
      z.literal('expungeBehaviorUnspecified'),
      z.literal('archive'),
      z.literal('trash'),
      z.literal('deleteForever'),
    ])
    .optional(),
  maxFolderSize: z.number().optional(),
});

export const expungeBehaviorSchema = z.union([
  z.literal('expungeBehaviorUnspecified'),
  z.literal('archive'),
  z.literal('trash'),
  z.literal('deleteForever'),
]);

export const labelColorSchema = z.object({
  backgroundColor: z.string().optional(),
  textColor: z.string().optional(),
});

export const labelListVisibilitySchema = z.union([
  z.literal('labelShow'),
  z.literal('labelShowIfUnread'),
  z.literal('labelHide'),
]);

export const messageListVisibilitySchema = z.union([z.literal('show'), z.literal('hide')]);

export const typeSchema = z.union([z.literal('system'), z.literal('user')]);

export const languageSettingsSchema = z.object({
  displayLanguage: z.string().optional(),
});

export const cseIdentitySchema = z.object({
  emailAddress: z.string().optional(),
  primaryKeyPairId: z.string().optional(),
  signAndEncryptKeyPairs: signAndEncryptKeyPairsSchema.optional(),
});

export const listDelegatesResponseSchema = z.object({
  delegates: z.array(delegateSchema).optional(),
});

export const filterSchema = z.object({
  action: filterActionSchema.optional(),
  criteria: filterCriteriaSchema.optional(),
  id: z.string().optional(),
});

export const listForwardingAddressesResponseSchema = z.object({
  forwardingAddresses: z.array(forwardingAddressSchema).optional(),
});

export const labelSchema = z.object({
  color: labelColorSchema.optional(),
  id: z.string().optional(),
  labelListVisibility: z
    .union([z.literal('labelShow'), z.literal('labelShowIfUnread'), z.literal('labelHide')])
    .optional(),
  messageListVisibility: z.union([z.literal('show'), z.literal('hide')]).optional(),
  messagesTotal: z.number().optional(),
  messagesUnread: z.number().optional(),
  name: z.string().optional(),
  threadsTotal: z.number().optional(),
  threadsUnread: z.number().optional(),
  type: z.union([z.literal('system'), z.literal('user')]).optional(),
});

export const smimeInfoSchema = z.object({
  encryptedKeyPassword: z.string().optional(),
  expiration: z.string().optional(),
  id: z.string().optional(),
  isDefault: z.boolean().optional(),
  issuerCn: z.string().optional(),
  pem: z.string().optional(),
  pkcs12: z.string().optional(),
});

export const messagePartBodySchema = z.object({
  attachmentId: z.string().optional(),
  data: z.string().optional(),
  size: z.number().optional(),
});

export const messagePartHeaderSchema = z.object({
  name: z.string().optional(),
  value: z.string().optional(),
});

export const messagePartSchema: z.ZodSchema<MessagePart> = z.lazy(() =>
  z.object({
    body: messagePartBodySchema.optional(),
    filename: z.string().optional(),
    headers: z.array(messagePartHeaderSchema).optional(),
    mimeType: z.string().optional(),
    partId: z.string().optional(),
    parts: z.array(messagePartSchema).optional(),
  }),
);

export const modifyMessageRequestSchema = z.object({
  addLabelIds: z.array(z.string()).optional(),
  removeLabelIds: z.array(z.string()).optional(),
});

export const modifyThreadRequestSchema = z.object({
  addLabelIds: z.array(z.string()).optional(),
  removeLabelIds: z.array(z.string()).optional(),
});

export const obliterateCseKeyPairRequestSchema = z.record(z.unknown());

export const popSettingsSchema = z.object({
  accessWindow: z
    .union([z.literal('accessWindowUnspecified'), z.literal('disabled'), z.literal('fromNowOn'), z.literal('allMail')])
    .optional(),
  disposition: z
    .union([
      z.literal('dispositionUnspecified'),
      z.literal('leaveInInbox'),
      z.literal('archive'),
      z.literal('trash'),
      z.literal('markRead'),
    ])
    .optional(),
});

export const accessWindowSchema = z.union([
  z.literal('accessWindowUnspecified'),
  z.literal('disabled'),
  z.literal('fromNowOn'),
  z.literal('allMail'),
]);

export const profileSchema = z.object({
  emailAddress: z.string().optional(),
  historyId: z.string().optional(),
  messagesTotal: z.number().optional(),
  threadsTotal: z.number().optional(),
});

export const smtpMsaSchema = z.object({
  host: z.string().optional(),
  password: z.string().optional(),
  port: z.number().optional(),
  securityMode: z
    .union([z.literal('securityModeUnspecified'), z.literal('none'), z.literal('ssl'), z.literal('starttls')])
    .optional(),
  username: z.string().optional(),
});

export const securityModeSchema = z.union([
  z.literal('securityModeUnspecified'),
  z.literal('none'),
  z.literal('ssl'),
  z.literal('starttls'),
]);

export const messageSchema = z.object({
  historyId: z.string().optional(),
  id: z.string().optional(),
  internalDate: z.string().optional(),
  labelIds: z.array(z.string()).optional(),
  payload: messagePartSchema.optional(),
  raw: z.string().optional(),
  sizeEstimate: z.number().optional(),
  snippet: z.string().optional(),
  threadId: z.string().optional(),
});

export const vacationSettingsSchema = z.object({
  enableAutoReply: z.boolean().optional(),
  endTime: z.string().optional(),
  responseBodyHtml: z.string().optional(),
  responseBodyPlainText: z.string().optional(),
  responseSubject: z.string().optional(),
  restrictToContacts: z.boolean().optional(),
  restrictToDomain: z.boolean().optional(),
  startTime: z.string().optional(),
});

export const watchRequestSchema = z.object({
  labelFilterAction: z.union([z.literal('include'), z.literal('exclude')]).optional(),
  labelFilterBehavior: z.union([z.literal('include'), z.literal('exclude')]).optional(),
  labelIds: z.array(z.string()).optional(),
  topicName: z.string().optional(),
});

export const labelFilterActionSchema = z.union([z.literal('include'), z.literal('exclude')]);

export const labelFilterBehaviorSchema = z.union([z.literal('include'), z.literal('exclude')]);

export const watchResponseSchema = z.object({
  expiration: z.string().optional(),
  historyId: z.string().optional(),
});

export const parameterXgafvSchema = z.union([z.literal('1'), z.literal('2')]);

export const parameteraccessTokenSchema = z.string();

export const parameteraltSchema = z.union([z.literal('json'), z.literal('media'), z.literal('proto')]);

export const parametercallbackSchema = z.string();

export const parameterfieldsSchema = z.string();

export const parameterkeySchema = z.string();

export const parameteroauthTokenSchema = z.string();

export const parameterprettyPrintSchema = z.boolean();

export const parameterquotaUserSchema = z.string();

export const parameteruploadTypeSchema = z.string();

export const parameteruploadProtocolSchema = z.string();

export const gmailUsersDraftsListDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      includeSpamTrash: z.boolean().optional(),
      key: z.string().optional(),
      maxResults: z.number().optional(),
      oauth_token: z.string().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      q: z.string().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersDraftsListErrorSchema = z.unknown();

export const draftSchema = z.object({
  id: z.string().optional(),
  message: messageSchema.optional(),
});

export const gmailUsersDraftsCreateResponseSchema = draftSchema;

export const gmailUsersDraftsCreateErrorSchema = z.unknown();

export const gmailUsersDraftsSendDataSchema = z.object({
  body: draftSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersDraftsSendResponseSchema = messageSchema;

export const gmailUsersDraftsSendErrorSchema = z.unknown();

export const gmailUsersDraftsDeleteDataSchema = z.object({
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersDraftsDeleteResponseSchema = z.unknown();

export const gmailUsersDraftsDeleteErrorSchema = z.unknown();

export const gmailUsersDraftsGetDataSchema = z.object({
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      format: z.union([z.literal('minimal'), z.literal('full'), z.literal('raw'), z.literal('metadata')]).optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersDraftsGetResponseSchema = draftSchema;

export const gmailUsersDraftsGetErrorSchema = z.unknown();

export const gmailUsersDraftsUpdateDataSchema = z.object({
  body: draftSchema.optional(),
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersDraftsUpdateResponseSchema = draftSchema;

export const gmailUsersDraftsUpdateErrorSchema = z.unknown();

export const gmailUsersHistoryListDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      historyTypes: z
        .array(
          z.union([
            z.literal('messageAdded'),
            z.literal('messageDeleted'),
            z.literal('labelAdded'),
            z.literal('labelRemoved'),
          ]),
        )
        .optional(),
      key: z.string().optional(),
      labelId: z.string().optional(),
      maxResults: z.number().optional(),
      oauth_token: z.string().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      startHistoryId: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersHistoryListErrorSchema = z.unknown();

export const gmailUsersLabelsListDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const listLabelsResponseSchema = z.object({
  labels: z.array(labelSchema).optional(),
});

export const gmailUsersLabelsListErrorSchema = z.unknown();

export const gmailUsersLabelsCreateDataSchema = z.object({
  body: labelSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersLabelsCreateResponseSchema = labelSchema;

export const gmailUsersLabelsCreateErrorSchema = z.unknown();

export const gmailUsersLabelsDeleteDataSchema = z.object({
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersLabelsDeleteResponseSchema = z.unknown();

export const gmailUsersLabelsDeleteErrorSchema = z.unknown();

export const gmailUsersLabelsGetDataSchema = z.object({
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersLabelsGetResponseSchema = labelSchema;

export const gmailUsersLabelsGetErrorSchema = z.unknown();

export const gmailUsersLabelsPatchDataSchema = z.object({
  body: labelSchema.optional(),
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersLabelsPatchResponseSchema = labelSchema;

export const gmailUsersLabelsPatchErrorSchema = z.unknown();

export const gmailUsersLabelsUpdateDataSchema = z.object({
  body: labelSchema.optional(),
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersLabelsUpdateResponseSchema = labelSchema;

export const gmailUsersLabelsUpdateErrorSchema = z.unknown();

export const gmailUsersMessagesListDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      includeSpamTrash: z.boolean().optional(),
      key: z.string().optional(),
      labelIds: z.array(z.string()).optional(),
      maxResults: z.number().optional(),
      oauth_token: z.string().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      q: z.string().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const listMessagesResponseSchema = z.object({
  messages: z.array(messageSchema).optional(),
  nextPageToken: z.string().optional(),
  resultSizeEstimate: z.number().optional(),
});

export const gmailUsersMessagesListErrorSchema = z.unknown();

export const gmailUsersMessagesInsertDataSchema = z.object({
  body: messageSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      deleted: z.boolean().optional(),
      fields: z.string().optional(),
      internalDateSource: z.union([z.literal('receivedTime'), z.literal('dateHeader')]).optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersMessagesInsertResponseSchema = messageSchema;

export const gmailUsersMessagesInsertErrorSchema = z.unknown();

export const gmailUsersMessagesBatchDeleteDataSchema = z.object({
  body: batchDeleteMessagesRequestSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersMessagesBatchDeleteResponseSchema = z.unknown();

export const gmailUsersMessagesBatchDeleteErrorSchema = z.unknown();

export const gmailUsersMessagesBatchModifyDataSchema = z.object({
  body: batchModifyMessagesRequestSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersMessagesBatchModifyResponseSchema = z.unknown();

export const gmailUsersMessagesBatchModifyErrorSchema = z.unknown();

export const gmailUsersMessagesImportDataSchema = z.object({
  body: messageSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      deleted: z.boolean().optional(),
      fields: z.string().optional(),
      internalDateSource: z.union([z.literal('receivedTime'), z.literal('dateHeader')]).optional(),
      key: z.string().optional(),
      neverMarkSpam: z.boolean().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      processForCalendar: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersMessagesImportResponseSchema = messageSchema;

export const gmailUsersMessagesImportErrorSchema = z.unknown();

export const gmailUsersMessagesSendDataSchema = z.object({
  body: messageSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersMessagesSendResponseSchema = messageSchema;

export const gmailUsersMessagesSendErrorSchema = z.unknown();

export const gmailUsersMessagesDeleteDataSchema = z.object({
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersMessagesDeleteResponseSchema = z.unknown();

export const gmailUsersMessagesDeleteErrorSchema = z.unknown();

export const gmailUsersMessagesGetDataSchema = z.object({
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      format: z.union([z.literal('minimal'), z.literal('full'), z.literal('raw'), z.literal('metadata')]).optional(),
      key: z.string().optional(),
      metadataHeaders: z.array(z.string()).optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersMessagesGetResponseSchema = messageSchema;

export const gmailUsersMessagesGetErrorSchema = z.unknown();

export const gmailUsersMessagesModifyDataSchema = z.object({
  body: modifyMessageRequestSchema.optional(),
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersMessagesModifyResponseSchema = messageSchema;

export const gmailUsersMessagesModifyErrorSchema = z.unknown();

export const gmailUsersMessagesTrashDataSchema = z.object({
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersMessagesTrashResponseSchema = messageSchema;

export const gmailUsersMessagesTrashErrorSchema = z.unknown();

export const gmailUsersMessagesUntrashDataSchema = z.object({
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersMessagesUntrashResponseSchema = messageSchema;

export const gmailUsersMessagesUntrashErrorSchema = z.unknown();

export const gmailUsersMessagesAttachmentsGetDataSchema = z.object({
  path: z.object({
    id: z.string(),
    messageId: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersMessagesAttachmentsGetResponseSchema = messagePartBodySchema;

export const gmailUsersMessagesAttachmentsGetErrorSchema = z.unknown();

export const gmailUsersGetProfileDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersGetProfileResponseSchema = profileSchema;

export const gmailUsersGetProfileErrorSchema = z.unknown();

export const gmailUsersSettingsGetAutoForwardingDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsGetAutoForwardingResponseSchema = autoForwardingSchema;

export const gmailUsersSettingsGetAutoForwardingErrorSchema = z.unknown();

export const gmailUsersSettingsUpdateAutoForwardingDataSchema = z.object({
  body: autoForwardingSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsUpdateAutoForwardingResponseSchema = autoForwardingSchema;

export const gmailUsersSettingsUpdateAutoForwardingErrorSchema = z.unknown();

export const gmailUsersSettingsCseIdentitiesListDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const listCseIdentitiesResponseSchema = z.object({
  cseIdentities: z.array(cseIdentitySchema).optional(),
  nextPageToken: z.string().optional(),
});

export const gmailUsersSettingsCseIdentitiesListErrorSchema = z.unknown();

export const gmailUsersSettingsCseIdentitiesCreateDataSchema = z.object({
  body: cseIdentitySchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsCseIdentitiesCreateResponseSchema = cseIdentitySchema;

export const gmailUsersSettingsCseIdentitiesCreateErrorSchema = z.unknown();

export const gmailUsersSettingsCseIdentitiesDeleteDataSchema = z.object({
  path: z.object({
    cseEmailAddress: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsCseIdentitiesDeleteResponseSchema = z.unknown();

export const gmailUsersSettingsCseIdentitiesDeleteErrorSchema = z.unknown();

export const gmailUsersSettingsCseIdentitiesGetDataSchema = z.object({
  path: z.object({
    cseEmailAddress: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsCseIdentitiesGetResponseSchema = cseIdentitySchema;

export const gmailUsersSettingsCseIdentitiesGetErrorSchema = z.unknown();

export const gmailUsersSettingsCseIdentitiesPatchDataSchema = z.object({
  body: cseIdentitySchema.optional(),
  path: z.object({
    emailAddress: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsCseIdentitiesPatchResponseSchema = cseIdentitySchema;

export const gmailUsersSettingsCseIdentitiesPatchErrorSchema = z.unknown();

export const gmailUsersSettingsCseKeypairsListDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsCseKeypairsListErrorSchema = z.unknown();

export const gmailUsersSettingsCseKeypairsCreateErrorSchema = z.unknown();

export const gmailUsersSettingsCseKeypairsGetDataSchema = z.object({
  path: z.object({
    keyPairId: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsCseKeypairsGetErrorSchema = z.unknown();

export const gmailUsersSettingsCseKeypairsDisableDataSchema = z.object({
  body: disableCseKeyPairRequestSchema.optional(),
  path: z.object({
    keyPairId: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsCseKeypairsDisableErrorSchema = z.unknown();

export const gmailUsersSettingsCseKeypairsEnableDataSchema = z.object({
  body: enableCseKeyPairRequestSchema.optional(),
  path: z.object({
    keyPairId: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsCseKeypairsEnableErrorSchema = z.unknown();

export const gmailUsersSettingsCseKeypairsObliterateDataSchema = z.object({
  body: obliterateCseKeyPairRequestSchema.optional(),
  path: z.object({
    keyPairId: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsCseKeypairsObliterateResponseSchema = z.unknown();

export const gmailUsersSettingsCseKeypairsObliterateErrorSchema = z.unknown();

export const gmailUsersSettingsDelegatesListDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsDelegatesListResponseSchema = listDelegatesResponseSchema;

export const gmailUsersSettingsDelegatesListErrorSchema = z.unknown();

export const gmailUsersSettingsDelegatesCreateDataSchema = z.object({
  body: delegateSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsDelegatesCreateResponseSchema = delegateSchema;

export const gmailUsersSettingsDelegatesCreateErrorSchema = z.unknown();

export const gmailUsersSettingsDelegatesDeleteDataSchema = z.object({
  path: z.object({
    delegateEmail: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsDelegatesDeleteResponseSchema = z.unknown();

export const gmailUsersSettingsDelegatesDeleteErrorSchema = z.unknown();

export const gmailUsersSettingsDelegatesGetDataSchema = z.object({
  path: z.object({
    delegateEmail: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsDelegatesGetResponseSchema = delegateSchema;

export const gmailUsersSettingsDelegatesGetErrorSchema = z.unknown();

export const gmailUsersSettingsFiltersListDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const listFiltersResponseSchema = z.object({
  filter: z.array(filterSchema).optional(),
});

export const gmailUsersSettingsFiltersListErrorSchema = z.unknown();

export const gmailUsersSettingsFiltersCreateDataSchema = z.object({
  body: filterSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsFiltersCreateResponseSchema = filterSchema;

export const gmailUsersSettingsFiltersCreateErrorSchema = z.unknown();

export const gmailUsersSettingsFiltersDeleteDataSchema = z.object({
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsFiltersDeleteResponseSchema = z.unknown();

export const gmailUsersSettingsFiltersDeleteErrorSchema = z.unknown();

export const gmailUsersSettingsFiltersGetDataSchema = z.object({
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsFiltersGetResponseSchema = filterSchema;

export const gmailUsersSettingsFiltersGetErrorSchema = z.unknown();

export const gmailUsersSettingsForwardingAddressesListDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsForwardingAddressesListResponseSchema = listForwardingAddressesResponseSchema;

export const gmailUsersSettingsForwardingAddressesListErrorSchema = z.unknown();

export const gmailUsersSettingsForwardingAddressesCreateDataSchema = z.object({
  body: forwardingAddressSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsForwardingAddressesCreateResponseSchema = forwardingAddressSchema;

export const gmailUsersSettingsForwardingAddressesCreateErrorSchema = z.unknown();

export const gmailUsersSettingsForwardingAddressesDeleteDataSchema = z.object({
  path: z.object({
    forwardingEmail: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsForwardingAddressesDeleteResponseSchema = z.unknown();

export const gmailUsersSettingsForwardingAddressesDeleteErrorSchema = z.unknown();

export const gmailUsersSettingsForwardingAddressesGetDataSchema = z.object({
  path: z.object({
    forwardingEmail: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsForwardingAddressesGetResponseSchema = forwardingAddressSchema;

export const gmailUsersSettingsForwardingAddressesGetErrorSchema = z.unknown();

export const gmailUsersSettingsGetImapDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsGetImapResponseSchema = imapSettingsSchema;

export const gmailUsersSettingsGetImapErrorSchema = z.unknown();

export const gmailUsersSettingsUpdateImapDataSchema = z.object({
  body: imapSettingsSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsUpdateImapResponseSchema = imapSettingsSchema;

export const gmailUsersSettingsUpdateImapErrorSchema = z.unknown();

export const gmailUsersSettingsGetLanguageDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsGetLanguageResponseSchema = languageSettingsSchema;

export const gmailUsersSettingsGetLanguageErrorSchema = z.unknown();

export const gmailUsersSettingsUpdateLanguageDataSchema = z.object({
  body: languageSettingsSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsUpdateLanguageResponseSchema = languageSettingsSchema;

export const gmailUsersSettingsUpdateLanguageErrorSchema = z.unknown();

export const gmailUsersSettingsGetPopDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsGetPopResponseSchema = popSettingsSchema;

export const gmailUsersSettingsGetPopErrorSchema = z.unknown();

export const gmailUsersSettingsUpdatePopDataSchema = z.object({
  body: popSettingsSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsUpdatePopResponseSchema = popSettingsSchema;

export const gmailUsersSettingsUpdatePopErrorSchema = z.unknown();

export const gmailUsersSettingsSendAsListDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsSendAsListErrorSchema = z.unknown();

export const sendAsSchema = z.object({
  displayName: z.string().optional(),
  isDefault: z.boolean().optional(),
  isPrimary: z.boolean().optional(),
  replyToAddress: z.string().optional(),
  sendAsEmail: z.string().optional(),
  signature: z.string().optional(),
  smtpMsa: smtpMsaSchema.optional(),
  treatAsAlias: z.boolean().optional(),
  verificationStatus: z
    .union([z.literal('verificationStatusUnspecified'), z.literal('accepted'), z.literal('pending')])
    .optional(),
});

export const gmailUsersSettingsSendAsCreateResponseSchema = sendAsSchema;

export const gmailUsersSettingsSendAsCreateErrorSchema = z.unknown();

export const gmailUsersSettingsSendAsDeleteDataSchema = z.object({
  path: z.object({
    sendAsEmail: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsSendAsDeleteResponseSchema = z.unknown();

export const gmailUsersSettingsSendAsDeleteErrorSchema = z.unknown();

export const gmailUsersSettingsSendAsGetDataSchema = z.object({
  path: z.object({
    sendAsEmail: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsSendAsGetResponseSchema = sendAsSchema;

export const gmailUsersSettingsSendAsGetErrorSchema = z.unknown();

export const gmailUsersSettingsSendAsPatchDataSchema = z.object({
  body: sendAsSchema.optional(),
  path: z.object({
    sendAsEmail: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsSendAsPatchResponseSchema = sendAsSchema;

export const gmailUsersSettingsSendAsPatchErrorSchema = z.unknown();

export const gmailUsersSettingsSendAsUpdateDataSchema = z.object({
  body: sendAsSchema.optional(),
  path: z.object({
    sendAsEmail: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsSendAsUpdateResponseSchema = sendAsSchema;

export const gmailUsersSettingsSendAsUpdateErrorSchema = z.unknown();

export const gmailUsersSettingsSendAsSmimeInfoListDataSchema = z.object({
  path: z.object({
    sendAsEmail: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const listSmimeInfoResponseSchema = z.object({
  smimeInfo: z.array(smimeInfoSchema).optional(),
});

export const gmailUsersSettingsSendAsSmimeInfoListErrorSchema = z.unknown();

export const gmailUsersSettingsSendAsSmimeInfoInsertDataSchema = z.object({
  body: smimeInfoSchema.optional(),
  path: z.object({
    sendAsEmail: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsSendAsSmimeInfoInsertResponseSchema = smimeInfoSchema;

export const gmailUsersSettingsSendAsSmimeInfoInsertErrorSchema = z.unknown();

export const gmailUsersSettingsSendAsSmimeInfoDeleteDataSchema = z.object({
  path: z.object({
    id: z.string(),
    sendAsEmail: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsSendAsSmimeInfoDeleteResponseSchema = z.unknown();

export const gmailUsersSettingsSendAsSmimeInfoDeleteErrorSchema = z.unknown();

export const gmailUsersSettingsSendAsSmimeInfoGetDataSchema = z.object({
  path: z.object({
    id: z.string(),
    sendAsEmail: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsSendAsSmimeInfoGetResponseSchema = smimeInfoSchema;

export const gmailUsersSettingsSendAsSmimeInfoGetErrorSchema = z.unknown();

export const gmailUsersSettingsSendAsSmimeInfoSetDefaultDataSchema = z.object({
  path: z.object({
    id: z.string(),
    sendAsEmail: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsSendAsSmimeInfoSetDefaultResponseSchema = z.unknown();

export const gmailUsersSettingsSendAsSmimeInfoSetDefaultErrorSchema = z.unknown();

export const gmailUsersSettingsSendAsVerifyDataSchema = z.object({
  path: z.object({
    sendAsEmail: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsSendAsVerifyResponseSchema = z.unknown();

export const gmailUsersSettingsSendAsVerifyErrorSchema = z.unknown();

export const gmailUsersSettingsGetVacationDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsGetVacationResponseSchema = vacationSettingsSchema;

export const gmailUsersSettingsGetVacationErrorSchema = z.unknown();

export const gmailUsersSettingsUpdateVacationDataSchema = z.object({
  body: vacationSettingsSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsUpdateVacationResponseSchema = vacationSettingsSchema;

export const gmailUsersSettingsUpdateVacationErrorSchema = z.unknown();

export const gmailUsersStopDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersStopResponseSchema = z.unknown();

export const gmailUsersStopErrorSchema = z.unknown();

export const gmailUsersThreadsListDataSchema = z.object({
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      includeSpamTrash: z.boolean().optional(),
      key: z.string().optional(),
      labelIds: z.array(z.string()).optional(),
      maxResults: z.number().optional(),
      oauth_token: z.string().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      q: z.string().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersThreadsListErrorSchema = z.unknown();

export const gmailUsersThreadsDeleteDataSchema = z.object({
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersThreadsDeleteResponseSchema = z.unknown();

export const gmailUsersThreadsDeleteErrorSchema = z.unknown();

export const gmailUsersThreadsGetDataSchema = z.object({
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      format: z.union([z.literal('full'), z.literal('metadata'), z.literal('minimal')]).optional(),
      key: z.string().optional(),
      metadataHeaders: z.array(z.string()).optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const threadSchema = z.object({
  historyId: z.string().optional(),
  id: z.string().optional(),
  messages: z.array(messageSchema).optional(),
  snippet: z.string().optional(),
});

export const gmailUsersThreadsGetErrorSchema = z.unknown();

export const gmailUsersThreadsModifyDataSchema = z.object({
  body: modifyThreadRequestSchema.optional(),
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersThreadsModifyResponseSchema = threadSchema;

export const gmailUsersThreadsModifyErrorSchema = z.unknown();

export const gmailUsersThreadsTrashDataSchema = z.object({
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersThreadsTrashResponseSchema = threadSchema;

export const gmailUsersThreadsTrashErrorSchema = z.unknown();

export const gmailUsersThreadsUntrashDataSchema = z.object({
  path: z.object({
    id: z.string(),
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersThreadsUntrashResponseSchema = threadSchema;

export const gmailUsersThreadsUntrashErrorSchema = z.unknown();

export const gmailUsersWatchDataSchema = z.object({
  body: watchRequestSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersWatchResponseSchema = watchResponseSchema;

export const gmailUsersWatchErrorSchema = z.unknown();

export const csePrivateKeyMetadataSchema = z.object({
  hardwareKeyMetadata: hardwareKeyMetadataSchema.optional(),
  kaclsKeyMetadata: kaclsKeyMetadataSchema.optional(),
  privateKeyMetadataId: z.string().optional(),
});

export const historyLabelAddedSchema = z.object({
  labelIds: z.array(z.string()).optional(),
  message: messageSchema.optional(),
});

export const historyLabelRemovedSchema = z.object({
  labelIds: z.array(z.string()).optional(),
  message: messageSchema.optional(),
});

export const historyMessageAddedSchema = z.object({
  message: messageSchema.optional(),
});

export const historyMessageDeletedSchema = z.object({
  message: messageSchema.optional(),
});

export const cseKeyPairSchema = z.object({
  disableTime: z.string().optional(),
  enablementState: z.union([z.literal('stateUnspecified'), z.literal('enabled'), z.literal('disabled')]).optional(),
  keyPairId: z.string().optional(),
  pem: z.string().optional(),
  pkcs7: z.string().optional(),
  privateKeyMetadata: z.array(csePrivateKeyMetadataSchema).optional(),
  subjectEmailAddresses: z.array(z.string()).optional(),
});

export const listDraftsResponseSchema = z.object({
  drafts: z.array(draftSchema).optional(),
  nextPageToken: z.string().optional(),
  resultSizeEstimate: z.number().optional(),
});

export const historySchema = z.object({
  id: z.string().optional(),
  labelsAdded: z.array(historyLabelAddedSchema).optional(),
  labelsRemoved: z.array(historyLabelRemovedSchema).optional(),
  messages: z.array(messageSchema).optional(),
  messagesAdded: z.array(historyMessageAddedSchema).optional(),
  messagesDeleted: z.array(historyMessageDeletedSchema).optional(),
});

export const listSendAsResponseSchema = z.object({
  sendAs: z.array(sendAsSchema).optional(),
});

export const listThreadsResponseSchema = z.object({
  nextPageToken: z.string().optional(),
  resultSizeEstimate: z.number().optional(),
  threads: z.array(threadSchema).optional(),
});

export const gmailUsersDraftsListResponseSchema = listDraftsResponseSchema;

export const gmailUsersDraftsCreateDataSchema = z.object({
  body: draftSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const listHistoryResponseSchema = z.object({
  history: z.array(historySchema).optional(),
  historyId: z.string().optional(),
  nextPageToken: z.string().optional(),
});

export const gmailUsersLabelsListResponseSchema = listLabelsResponseSchema;

export const gmailUsersMessagesListResponseSchema = listMessagesResponseSchema;

export const gmailUsersSettingsCseIdentitiesListResponseSchema = listCseIdentitiesResponseSchema;

export const listCseKeyPairsResponseSchema = z.object({
  cseKeyPairs: z.array(cseKeyPairSchema).optional(),
  nextPageToken: z.string().optional(),
});

export const gmailUsersSettingsCseKeypairsCreateDataSchema = z.object({
  body: cseKeyPairSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsCseKeypairsCreateResponseSchema = cseKeyPairSchema;

export const gmailUsersSettingsCseKeypairsGetResponseSchema = cseKeyPairSchema;

export const gmailUsersSettingsCseKeypairsDisableResponseSchema = cseKeyPairSchema;

export const gmailUsersSettingsCseKeypairsEnableResponseSchema = cseKeyPairSchema;

export const gmailUsersSettingsFiltersListResponseSchema = listFiltersResponseSchema;

export const gmailUsersSettingsSendAsListResponseSchema = listSendAsResponseSchema;

export const gmailUsersSettingsSendAsCreateDataSchema = z.object({
  body: sendAsSchema.optional(),
  path: z.object({
    userId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const gmailUsersSettingsSendAsSmimeInfoListResponseSchema = listSmimeInfoResponseSchema;

export const gmailUsersThreadsListResponseSchema = listThreadsResponseSchema;

export const gmailUsersThreadsGetResponseSchema = threadSchema;

export const gmailUsersHistoryListResponseSchema = listHistoryResponseSchema;

export const gmailUsersSettingsCseKeypairsListResponseSchema = listCseKeyPairsResponseSchema;
