// This file is auto-generated by @hey-api/openapi-ts

/**
 * Auto-forwarding settings for an account.
 */
export type AutoForwarding = {
  /**
   * The state that a message should be left in after it has been forwarded.
   */
  disposition?: 'dispositionUnspecified' | 'leaveInInbox' | 'archive' | 'trash' | 'markRead';
  /**
   * Email address to which all incoming messages are forwarded. This email address must be a verified member of the forwarding addresses.
   */
  emailAddress?: string;
  /**
   * Whether all incoming mail is automatically forwarded to another address.
   */
  enabled?: boolean;
};

/**
 * The state that a message should be left in after it has been forwarded.
 */
export type disposition = 'dispositionUnspecified' | 'leaveInInbox' | 'archive' | 'trash' | 'markRead';

export type BatchDeleteMessagesRequest = {
  /**
   * The IDs of the messages to delete.
   */
  ids?: Array<string>;
};

export type BatchModifyMessagesRequest = {
  /**
   * A list of label IDs to add to messages.
   */
  addLabelIds?: Array<string>;
  /**
   * The IDs of the messages to modify. There is a limit of 1000 ids per request.
   */
  ids?: Array<string>;
  /**
   * A list of label IDs to remove from messages.
   */
  removeLabelIds?: Array<string>;
};

/**
 * The client-side encryption (CSE) configuration for the email address of an authenticated user. Gmail uses CSE configurations to save drafts of client-side encrypted email messages, and to sign and send encrypted email messages.
 */
export type CseIdentity = {
  /**
   * The email address for the sending identity. The email address must be the primary email address of the authenticated user.
   */
  emailAddress?: string;
  /**
   * If a key pair is associated, the ID of the key pair, CseKeyPair.
   */
  primaryKeyPairId?: string;
  /**
   * The configuration of a CSE identity that uses different key pairs for signing and encryption.
   */
  signAndEncryptKeyPairs?: SignAndEncryptKeyPairs;
};

/**
 * A client-side encryption S/MIME key pair, which is comprised of a public key, its certificate chain, and metadata for its paired private key. Gmail uses the key pair to complete the following tasks: - Sign outgoing client-side encrypted messages. - Save and reopen drafts of client-side encrypted messages. - Save and reopen sent messages. - Decrypt incoming or archived S/MIME messages.
 */
export type CseKeyPair = {
  /**
   * Output only. If a key pair is set to `DISABLED`, the time that the key pair's state changed from `ENABLED` to `DISABLED`. This field is present only when the key pair is in state `DISABLED`.
   */
  readonly disableTime?: string;
  /**
   * Output only. The current state of the key pair.
   */
  readonly enablementState?: 'stateUnspecified' | 'enabled' | 'disabled';
  /**
   * Output only. The immutable ID for the client-side encryption S/MIME key pair.
   */
  readonly keyPairId?: string;
  /**
   * Output only. The public key and its certificate chain, in [PEM](https://en.wikipedia.org/wiki/Privacy-Enhanced_Mail) format.
   */
  readonly pem?: string;
  /**
   * Input only. The public key and its certificate chain. The chain must be in [PKCS#7](https://en.wikipedia.org/wiki/PKCS_7) format and use PEM encoding and ASCII armor.
   */
  pkcs7?: string;
  /**
   * Metadata for instances of this key pair's private key.
   */
  privateKeyMetadata?: Array<CsePrivateKeyMetadata>;
  /**
   * Output only. The email address identities that are specified on the leaf certificate.
   */
  readonly subjectEmailAddresses?: Array<string>;
};

/**
 * Output only. The current state of the key pair.
 */
export type enablementState = 'stateUnspecified' | 'enabled' | 'disabled';

/**
 * Metadata for a private key instance.
 */
export type CsePrivateKeyMetadata = {
  /**
   * Metadata for hardware keys.
   */
  hardwareKeyMetadata?: HardwareKeyMetadata;
  /**
   * Metadata for a private key instance managed by an external key access control list service.
   */
  kaclsKeyMetadata?: KaclsKeyMetadata;
  /**
   * Output only. The immutable ID for the private key metadata instance.
   */
  readonly privateKeyMetadataId?: string;
};

/**
 * Settings for a delegate. Delegates can read, send, and delete messages, as well as view and add contacts, for the delegator's account. See "Set up mail delegation" for more information about delegates.
 */
export type Delegate = {
  /**
   * The email address of the delegate.
   */
  delegateEmail?: string;
  /**
   * Indicates whether this address has been verified and can act as a delegate for the account. Read-only.
   */
  verificationStatus?: 'verificationStatusUnspecified' | 'accepted' | 'pending' | 'rejected' | 'expired';
};

/**
 * Indicates whether this address has been verified and can act as a delegate for the account. Read-only.
 */
export type verificationStatus = 'verificationStatusUnspecified' | 'accepted' | 'pending' | 'rejected' | 'expired';

/**
 * Requests to turn off a client-side encryption key pair.
 */
export type DisableCseKeyPairRequest = {
  [key: string]: unknown;
};

/**
 * A draft email in the user's mailbox.
 */
export type Draft = {
  /**
   * The immutable ID of the draft.
   */
  id?: string;
  /**
   * The message content of the draft.
   */
  message?: Message;
};

/**
 * Requests to turn on a client-side encryption key pair.
 */
export type EnableCseKeyPairRequest = {
  [key: string]: unknown;
};

/**
 * Resource definition for Gmail filters. Filters apply to specific messages instead of an entire email thread.
 */
export type Filter = {
  /**
   * Action that the filter performs.
   */
  action?: FilterAction;
  /**
   * Matching criteria for the filter.
   */
  criteria?: FilterCriteria;
  /**
   * The server assigned ID of the filter.
   */
  id?: string;
};

/**
 * A set of actions to perform on a message.
 */
export type FilterAction = {
  /**
   * List of labels to add to the message.
   */
  addLabelIds?: Array<string>;
  /**
   * Email address that the message should be forwarded to.
   */
  forward?: string;
  /**
   * List of labels to remove from the message.
   */
  removeLabelIds?: Array<string>;
};

/**
 * Message matching criteria.
 */
export type FilterCriteria = {
  /**
   * Whether the response should exclude chats.
   */
  excludeChats?: boolean;
  /**
   * The sender's display name or email address.
   */
  from?: string;
  /**
   * Whether the message has any attachment.
   */
  hasAttachment?: boolean;
  /**
   * Only return messages not matching the specified query. Supports the same query format as the Gmail search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`.
   */
  negatedQuery?: string;
  /**
   * Only return messages matching the specified query. Supports the same query format as the Gmail search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`.
   */
  query?: string;
  /**
   * The size of the entire RFC822 message in bytes, including all headers and attachments.
   */
  size?: number;
  /**
   * How the message size in bytes should be in relation to the size field.
   */
  sizeComparison?: 'unspecified' | 'smaller' | 'larger';
  /**
   * Case-insensitive phrase found in the message's subject. Trailing and leading whitespace are be trimmed and adjacent spaces are collapsed.
   */
  subject?: string;
  /**
   * The recipient's display name or email address. Includes recipients in the "to", "cc", and "bcc" header fields. You can use simply the local part of the email address. For example, "example" and "example@" both match "example@gmail.com". This field is case-insensitive.
   */
  to?: string;
};

/**
 * How the message size in bytes should be in relation to the size field.
 */
export type sizeComparison = 'unspecified' | 'smaller' | 'larger';

/**
 * Settings for a forwarding address.
 */
export type ForwardingAddress = {
  /**
   * An email address to which messages can be forwarded.
   */
  forwardingEmail?: string;
  /**
   * Indicates whether this address has been verified and is usable for forwarding. Read-only.
   */
  verificationStatus?: 'verificationStatusUnspecified' | 'accepted' | 'pending';
};

/**
 * Indicates whether this address has been verified and is usable for forwarding. Read-only.
 */
export type verificationStatus2 = 'verificationStatusUnspecified' | 'accepted' | 'pending';

/**
 * Metadata for hardware keys.
 */
export type HardwareKeyMetadata = {
  /**
   * Description about the hardware key.
   */
  description?: string;
};

/**
 * A record of a change to the user's mailbox. Each history change may affect multiple messages in multiple ways.
 */
export type History = {
  /**
   * The mailbox sequence ID.
   */
  id?: string;
  /**
   * Labels added to messages in this history record.
   */
  labelsAdded?: Array<HistoryLabelAdded>;
  /**
   * Labels removed from messages in this history record.
   */
  labelsRemoved?: Array<HistoryLabelRemoved>;
  /**
   * List of messages changed in this history record. The fields for specific change types, such as `messagesAdded` may duplicate messages in this field. We recommend using the specific change-type fields instead of this.
   */
  messages?: Array<Message>;
  /**
   * Messages added to the mailbox in this history record.
   */
  messagesAdded?: Array<HistoryMessageAdded>;
  /**
   * Messages deleted (not Trashed) from the mailbox in this history record.
   */
  messagesDeleted?: Array<HistoryMessageDeleted>;
};

export type HistoryLabelAdded = {
  /**
   * Label IDs added to the message.
   */
  labelIds?: Array<string>;
  message?: Message;
};

export type HistoryLabelRemoved = {
  /**
   * Label IDs removed from the message.
   */
  labelIds?: Array<string>;
  message?: Message;
};

export type HistoryMessageAdded = {
  message?: Message;
};

export type HistoryMessageDeleted = {
  message?: Message;
};

/**
 * IMAP settings for an account.
 */
export type ImapSettings = {
  /**
   * If this value is true, Gmail will immediately expunge a message when it is marked as deleted in IMAP. Otherwise, Gmail will wait for an update from the client before expunging messages marked as deleted.
   */
  autoExpunge?: boolean;
  /**
   * Whether IMAP is enabled for the account.
   */
  enabled?: boolean;
  /**
   * The action that will be executed on a message when it is marked as deleted and expunged from the last visible IMAP folder.
   */
  expungeBehavior?: 'expungeBehaviorUnspecified' | 'archive' | 'trash' | 'deleteForever';
  /**
   * An optional limit on the number of messages that an IMAP folder may contain. Legal values are 0, 1000, 2000, 5000 or 10000. A value of zero is interpreted to mean that there is no limit.
   */
  maxFolderSize?: number;
};

/**
 * The action that will be executed on a message when it is marked as deleted and expunged from the last visible IMAP folder.
 */
export type expungeBehavior = 'expungeBehaviorUnspecified' | 'archive' | 'trash' | 'deleteForever';

/**
 * Metadata for private keys managed by an external key access control list service. For details about managing key access, see [Google Workspace CSE API Reference](https://developers.google.com/workspace/cse/reference).
 */
export type KaclsKeyMetadata = {
  /**
   * Opaque data generated and used by the key access control list service. Maximum size: 8 KiB.
   */
  kaclsData?: string;
  /**
   * The URI of the key access control list service that manages the private key.
   */
  kaclsUri?: string;
};

/**
 * Labels are used to categorize messages and threads within the user's mailbox. The maximum number of labels supported for a user's mailbox is 10,000.
 */
export type Label = {
  /**
   * The color to assign to the label. Color is only available for labels that have their `type` set to `user`.
   */
  color?: LabelColor;
  /**
   * The immutable ID of the label.
   */
  id?: string;
  /**
   * The visibility of the label in the label list in the Gmail web interface.
   */
  labelListVisibility?: 'labelShow' | 'labelShowIfUnread' | 'labelHide';
  /**
   * The visibility of messages with this label in the message list in the Gmail web interface.
   */
  messageListVisibility?: 'show' | 'hide';
  /**
   * The total number of messages with the label.
   */
  messagesTotal?: number;
  /**
   * The number of unread messages with the label.
   */
  messagesUnread?: number;
  /**
   * The display name of the label.
   */
  name?: string;
  /**
   * The total number of threads with the label.
   */
  threadsTotal?: number;
  /**
   * The number of unread threads with the label.
   */
  threadsUnread?: number;
  /**
   * The owner type for the label. User labels are created by the user and can be modified and deleted by the user and can be applied to any message or thread. System labels are internally created and cannot be added, modified, or deleted. System labels may be able to be applied to or removed from messages and threads under some circumstances but this is not guaranteed. For example, users can apply and remove the `INBOX` and `UNREAD` labels from messages and threads, but cannot apply or remove the `DRAFTS` or `SENT` labels from messages or threads.
   */
  type?: 'system' | 'user';
};

/**
 * The visibility of the label in the label list in the Gmail web interface.
 */
export type labelListVisibility = 'labelShow' | 'labelShowIfUnread' | 'labelHide';

/**
 * The visibility of messages with this label in the message list in the Gmail web interface.
 */
export type messageListVisibility = 'show' | 'hide';

/**
 * The owner type for the label. User labels are created by the user and can be modified and deleted by the user and can be applied to any message or thread. System labels are internally created and cannot be added, modified, or deleted. System labels may be able to be applied to or removed from messages and threads under some circumstances but this is not guaranteed. For example, users can apply and remove the `INBOX` and `UNREAD` labels from messages and threads, but cannot apply or remove the `DRAFTS` or `SENT` labels from messages or threads.
 */
export type type = 'system' | 'user';

export type LabelColor = {
  /**
   * The background color represented as hex string #RRGGBB (ex #000000). This field is required in order to set the color of a label. Only the following predefined set of color values are allowed: \#000000, #434343, #666666, #999999, #cccccc, #efefef, #f3f3f3, #ffffff, \#fb4c2f, #ffad47, #fad165, #16a766, #43d692, #4a86e8, #a479e2, #f691b3, \#f6c5be, #ffe6c7, #fef1d1, #b9e4d0, #c6f3de, #c9daf8, #e4d7f5, #fcdee8, \#efa093, #ffd6a2, #fce8b3, #89d3b2, #a0eac9, #a4c2f4, #d0bcf1, #fbc8d9, \#e66550, #ffbc6b, #fcda83, #44b984, #68dfa9, #6d9eeb, #b694e8, #f7a7c0, \#cc3a21, #eaa041, #f2c960, #149e60, #3dc789, #3c78d8, #8e63ce, #e07798, \#ac2b16, #cf8933, #d5ae49, #0b804b, #2a9c68, #285bac, #653e9b, #b65775, \#822111, #a46a21, #aa8831, #076239, #1a764d, #1c4587, #41236d, #83334c \#464646, #e7e7e7, #0d3472, #b6cff5, #0d3b44, #98d7e4, #3d188e, #e3d7ff, \#711a36, #fbd3e0, #8a1c0a, #f2b2a8, #7a2e0b, #ffc8af, #7a4706, #ffdeb5, \#594c05, #fbe983, #684e07, #fdedc1, #0b4f30, #b3efd3, #04502e, #a2dcc1, \#c2c2c2, #4986e7, #2da2bb, #b99aff, #994a64, #f691b2, #ff7537, #ffad46, \#662e37, #ebdbde, #cca6ac, #094228, #42d692, #16a765
   */
  backgroundColor?: string;
  /**
   * The text color of the label, represented as hex string. This field is required in order to set the color of a label. Only the following predefined set of color values are allowed: \#000000, #434343, #666666, #999999, #cccccc, #efefef, #f3f3f3, #ffffff, \#fb4c2f, #ffad47, #fad165, #16a766, #43d692, #4a86e8, #a479e2, #f691b3, \#f6c5be, #ffe6c7, #fef1d1, #b9e4d0, #c6f3de, #c9daf8, #e4d7f5, #fcdee8, \#efa093, #ffd6a2, #fce8b3, #89d3b2, #a0eac9, #a4c2f4, #d0bcf1, #fbc8d9, \#e66550, #ffbc6b, #fcda83, #44b984, #68dfa9, #6d9eeb, #b694e8, #f7a7c0, \#cc3a21, #eaa041, #f2c960, #149e60, #3dc789, #3c78d8, #8e63ce, #e07798, \#ac2b16, #cf8933, #d5ae49, #0b804b, #2a9c68, #285bac, #653e9b, #b65775, \#822111, #a46a21, #aa8831, #076239, #1a764d, #1c4587, #41236d, #83334c \#464646, #e7e7e7, #0d3472, #b6cff5, #0d3b44, #98d7e4, #3d188e, #e3d7ff, \#711a36, #fbd3e0, #8a1c0a, #f2b2a8, #7a2e0b, #ffc8af, #7a4706, #ffdeb5, \#594c05, #fbe983, #684e07, #fdedc1, #0b4f30, #b3efd3, #04502e, #a2dcc1, \#c2c2c2, #4986e7, #2da2bb, #b99aff, #994a64, #f691b2, #ff7537, #ffad46, \#662e37, #ebdbde, #cca6ac, #094228, #42d692, #16a765
   */
  textColor?: string;
};

/**
 * Language settings for an account. These settings correspond to the "Language settings" feature in the web interface.
 */
export type LanguageSettings = {
  /**
   * The language to display Gmail in, formatted as an RFC 3066 Language Tag (for example `en-GB`, `fr` or `ja` for British English, French, or Japanese respectively). The set of languages supported by Gmail evolves over time, so please refer to the "Language" dropdown in the Gmail settings for all available options, as described in the language settings help article. A table of sample values is also provided in the Managing Language Settings guide Not all Gmail clients can display the same set of languages. In the case that a user's display language is not available for use on a particular client, said client automatically chooses to display in the closest supported variant (or a reasonable default).
   */
  displayLanguage?: string;
};

export type ListCseIdentitiesResponse = {
  /**
   * One page of the list of CSE identities configured for the user.
   */
  cseIdentities?: Array<CseIdentity>;
  /**
   * Pagination token to be passed to a subsequent ListCseIdentities call in order to retrieve the next page of identities. If this value is not returned or is the empty string, then no further pages remain.
   */
  nextPageToken?: string;
};

export type ListCseKeyPairsResponse = {
  /**
   * One page of the list of CSE key pairs installed for the user.
   */
  cseKeyPairs?: Array<CseKeyPair>;
  /**
   * Pagination token to be passed to a subsequent ListCseKeyPairs call in order to retrieve the next page of key pairs. If this value is not returned, then no further pages remain.
   */
  nextPageToken?: string;
};

/**
 * Response for the ListDelegates method.
 */
export type ListDelegatesResponse = {
  /**
   * List of the user's delegates (with any verification status). If an account doesn't have delegates, this field doesn't appear.
   */
  delegates?: Array<Delegate>;
};

export type ListDraftsResponse = {
  /**
   * List of drafts. Note that the `Message` property in each `Draft` resource only contains an `id` and a `threadId`. The messages.get method can fetch additional message details.
   */
  drafts?: Array<Draft>;
  /**
   * Token to retrieve the next page of results in the list.
   */
  nextPageToken?: string;
  /**
   * Estimated total number of results.
   */
  resultSizeEstimate?: number;
};

/**
 * Response for the ListFilters method.
 */
export type ListFiltersResponse = {
  /**
   * List of a user's filters.
   */
  filter?: Array<Filter>;
};

/**
 * Response for the ListForwardingAddresses method.
 */
export type ListForwardingAddressesResponse = {
  /**
   * List of addresses that may be used for forwarding.
   */
  forwardingAddresses?: Array<ForwardingAddress>;
};

export type ListHistoryResponse = {
  /**
   * List of history records. Any `messages` contained in the response will typically only have `id` and `threadId` fields populated.
   */
  history?: Array<History>;
  /**
   * The ID of the mailbox's current history record.
   */
  historyId?: string;
  /**
   * Page token to retrieve the next page of results in the list.
   */
  nextPageToken?: string;
};

export type ListLabelsResponse = {
  /**
   * List of labels. Note that each label resource only contains an `id`, `name`, `messageListVisibility`, `labelListVisibility`, and `type`. The labels.get method can fetch additional label details.
   */
  labels?: Array<Label>;
};

export type ListMessagesResponse = {
  /**
   * List of messages. Note that each message resource contains only an `id` and a `threadId`. Additional message details can be fetched using the messages.get method.
   */
  messages?: Array<Message>;
  /**
   * Token to retrieve the next page of results in the list.
   */
  nextPageToken?: string;
  /**
   * Estimated total number of results.
   */
  resultSizeEstimate?: number;
};

/**
 * Response for the ListSendAs method.
 */
export type ListSendAsResponse = {
  /**
   * List of send-as aliases.
   */
  sendAs?: Array<SendAs>;
};

export type ListSmimeInfoResponse = {
  /**
   * List of SmimeInfo.
   */
  smimeInfo?: Array<SmimeInfo>;
};

export type ListThreadsResponse = {
  /**
   * Page token to retrieve the next page of results in the list.
   */
  nextPageToken?: string;
  /**
   * Estimated total number of results.
   */
  resultSizeEstimate?: number;
  /**
   * List of threads. Note that each thread resource does not contain a list of `messages`. The list of `messages` for a given thread can be fetched using the threads.get method.
   */
  threads?: Array<Thread>;
};

/**
 * An email message.
 */
export type Message = {
  /**
   * The ID of the last history record that modified this message.
   */
  historyId?: string;
  /**
   * The immutable ID of the message.
   */
  id?: string;
  /**
   * The internal message creation timestamp (epoch ms), which determines ordering in the inbox. For normal SMTP-received email, this represents the time the message was originally accepted by Google, which is more reliable than the `Date` header. However, for API-migrated mail, it can be configured by client to be based on the `Date` header.
   */
  internalDate?: string;
  /**
   * List of IDs of labels applied to this message.
   */
  labelIds?: Array<string>;
  /**
   * The parsed email structure in the message parts.
   */
  payload?: MessagePart;
  /**
   * The entire email message in an RFC 2822 formatted and base64url encoded string. Returned in `messages.get` and `drafts.get` responses when the `format=RAW` parameter is supplied.
   */
  raw?: string;
  /**
   * Estimated size in bytes of the message.
   */
  sizeEstimate?: number;
  /**
   * A short part of the message text.
   */
  snippet?: string;
  /**
   * The ID of the thread the message belongs to. To add a message or draft to a thread, the following criteria must be met: 1. The requested `threadId` must be specified on the `Message` or `Draft.Message` you supply with your request. 2. The `References` and `In-Reply-To` headers must be set in compliance with the [RFC 2822](https://tools.ietf.org/html/rfc2822) standard. 3. The `Subject` headers must match.
   */
  threadId?: string;
};

/**
 * A single MIME message part.
 */
export type MessagePart = {
  /**
   * The message part body for this part, which may be empty for container MIME message parts.
   */
  body?: MessagePartBody;
  /**
   * The filename of the attachment. Only present if this message part represents an attachment.
   */
  filename?: string;
  /**
   * List of headers on this message part. For the top-level message part, representing the entire message payload, it will contain the standard RFC 2822 email headers such as `To`, `From`, and `Subject`.
   */
  headers?: Array<MessagePartHeader>;
  /**
   * The MIME type of the message part.
   */
  mimeType?: string;
  /**
   * The immutable ID of the message part.
   */
  partId?: string;
  /**
   * The child MIME message parts of this part. This only applies to container MIME message parts, for example `multipart*`. For non- container MIME message part types, such as `text/plain`, this field is empty. For more information, see RFC 1521.
   */
  parts?: Array<MessagePart>;
};

/**
 * The body of a single MIME message part.
 */
export type MessagePartBody = {
  /**
   * When present, contains the ID of an external attachment that can be retrieved in a separate `messages.attachments.get` request. When not present, the entire content of the message part body is contained in the data field.
   */
  attachmentId?: string;
  /**
   * The body data of a MIME message part as a base64url encoded string. May be empty for MIME container types that have no message body or when the body data is sent as a separate attachment. An attachment ID is present if the body data is contained in a separate attachment.
   */
  data?: string;
  /**
   * Number of bytes for the message part data (encoding notwithstanding).
   */
  size?: number;
};

export type MessagePartHeader = {
  /**
   * The name of the header before the `:` separator. For example, `To`.
   */
  name?: string;
  /**
   * The value of the header after the `:` separator. For example, `someuser@example.com`.
   */
  value?: string;
};

export type ModifyMessageRequest = {
  /**
   * A list of IDs of labels to add to this message. You can add up to 100 labels with each update.
   */
  addLabelIds?: Array<string>;
  /**
   * A list IDs of labels to remove from this message. You can remove up to 100 labels with each update.
   */
  removeLabelIds?: Array<string>;
};

export type ModifyThreadRequest = {
  /**
   * A list of IDs of labels to add to this thread. You can add up to 100 labels with each update.
   */
  addLabelIds?: Array<string>;
  /**
   * A list of IDs of labels to remove from this thread. You can remove up to 100 labels with each update.
   */
  removeLabelIds?: Array<string>;
};

/**
 * Request to obliterate a CSE key pair.
 */
export type ObliterateCseKeyPairRequest = {
  [key: string]: unknown;
};

/**
 * POP settings for an account.
 */
export type PopSettings = {
  /**
   * The range of messages which are accessible via POP.
   */
  accessWindow?: 'accessWindowUnspecified' | 'disabled' | 'fromNowOn' | 'allMail';
  /**
   * The action that will be executed on a message after it has been fetched via POP.
   */
  disposition?: 'dispositionUnspecified' | 'leaveInInbox' | 'archive' | 'trash' | 'markRead';
};

/**
 * The range of messages which are accessible via POP.
 */
export type accessWindow = 'accessWindowUnspecified' | 'disabled' | 'fromNowOn' | 'allMail';

/**
 * Profile for a Gmail user.
 */
export type Profile = {
  /**
   * The user's email address.
   */
  emailAddress?: string;
  /**
   * The ID of the mailbox's current history record.
   */
  historyId?: string;
  /**
   * The total number of messages in the mailbox.
   */
  messagesTotal?: number;
  /**
   * The total number of threads in the mailbox.
   */
  threadsTotal?: number;
};

/**
 * Settings associated with a send-as alias, which can be either the primary login address associated with the account or a custom "from" address. Send-as aliases correspond to the "Send Mail As" feature in the web interface.
 */
export type SendAs = {
  /**
   * A name that appears in the "From:" header for mail sent using this alias. For custom "from" addresses, when this is empty, Gmail will populate the "From:" header with the name that is used for the primary address associated with the account. If the admin has disabled the ability for users to update their name format, requests to update this field for the primary login will silently fail.
   */
  displayName?: string;
  /**
   * Whether this address is selected as the default "From:" address in situations such as composing a new message or sending a vacation auto-reply. Every Gmail account has exactly one default send-as address, so the only legal value that clients may write to this field is `true`. Changing this from `false` to `true` for an address will result in this field becoming `false` for the other previous default address.
   */
  isDefault?: boolean;
  /**
   * Whether this address is the primary address used to login to the account. Every Gmail account has exactly one primary address, and it cannot be deleted from the collection of send-as aliases. This field is read-only.
   */
  isPrimary?: boolean;
  /**
   * An optional email address that is included in a "Reply-To:" header for mail sent using this alias. If this is empty, Gmail will not generate a "Reply-To:" header.
   */
  replyToAddress?: string;
  /**
   * The email address that appears in the "From:" header for mail sent using this alias. This is read-only for all operations except create.
   */
  sendAsEmail?: string;
  /**
   * An optional HTML signature that is included in messages composed with this alias in the Gmail web UI. This signature is added to new emails only.
   */
  signature?: string;
  /**
   * An optional SMTP service that will be used as an outbound relay for mail sent using this alias. If this is empty, outbound mail will be sent directly from Gmail's servers to the destination SMTP service. This setting only applies to custom "from" aliases.
   */
  smtpMsa?: SmtpMsa;
  /**
   * Whether Gmail should treat this address as an alias for the user's primary email address. This setting only applies to custom "from" aliases.
   */
  treatAsAlias?: boolean;
  /**
   * Indicates whether this address has been verified for use as a send-as alias. Read-only. This setting only applies to custom "from" aliases.
   */
  verificationStatus?: 'verificationStatusUnspecified' | 'accepted' | 'pending';
};

/**
 * The configuration of a CSE identity that uses different key pairs for signing and encryption.
 */
export type SignAndEncryptKeyPairs = {
  /**
   * The ID of the CseKeyPair that encrypts signed outgoing mail.
   */
  encryptionKeyPairId?: string;
  /**
   * The ID of the CseKeyPair that signs outgoing mail.
   */
  signingKeyPairId?: string;
};

/**
 * An S/MIME email config.
 */
export type SmimeInfo = {
  /**
   * Encrypted key password, when key is encrypted.
   */
  encryptedKeyPassword?: string;
  /**
   * When the certificate expires (in milliseconds since epoch).
   */
  expiration?: string;
  /**
   * The immutable ID for the SmimeInfo.
   */
  id?: string;
  /**
   * Whether this SmimeInfo is the default one for this user's send-as address.
   */
  isDefault?: boolean;
  /**
   * The S/MIME certificate issuer's common name.
   */
  issuerCn?: string;
  /**
   * PEM formatted X509 concatenated certificate string (standard base64 encoding). Format used for returning key, which includes public key as well as certificate chain (not private key).
   */
  pem?: string;
  /**
   * PKCS#12 format containing a single private/public key pair and certificate chain. This format is only accepted from client for creating a new SmimeInfo and is never returned, because the private key is not intended to be exported. PKCS#12 may be encrypted, in which case encryptedKeyPassword should be set appropriately.
   */
  pkcs12?: string;
};

/**
 * Configuration for communication with an SMTP service.
 */
export type SmtpMsa = {
  /**
   * The hostname of the SMTP service. Required.
   */
  host?: string;
  /**
   * The password that will be used for authentication with the SMTP service. This is a write-only field that can be specified in requests to create or update SendAs settings; it is never populated in responses.
   */
  password?: string;
  /**
   * The port of the SMTP service. Required.
   */
  port?: number;
  /**
   * The protocol that will be used to secure communication with the SMTP service. Required.
   */
  securityMode?: 'securityModeUnspecified' | 'none' | 'ssl' | 'starttls';
  /**
   * The username that will be used for authentication with the SMTP service. This is a write-only field that can be specified in requests to create or update SendAs settings; it is never populated in responses.
   */
  username?: string;
};

/**
 * The protocol that will be used to secure communication with the SMTP service. Required.
 */
export type securityMode = 'securityModeUnspecified' | 'none' | 'ssl' | 'starttls';

/**
 * A collection of messages representing a conversation.
 */
export type Thread = {
  /**
   * The ID of the last history record that modified this thread.
   */
  historyId?: string;
  /**
   * The unique ID of the thread.
   */
  id?: string;
  /**
   * The list of messages in the thread.
   */
  messages?: Array<Message>;
  /**
   * A short part of the message text.
   */
  snippet?: string;
};

/**
 * Vacation auto-reply settings for an account. These settings correspond to the "Vacation responder" feature in the web interface.
 */
export type VacationSettings = {
  /**
   * Flag that controls whether Gmail automatically replies to messages.
   */
  enableAutoReply?: boolean;
  /**
   * An optional end time for sending auto-replies (epoch ms). When this is specified, Gmail will automatically reply only to messages that it receives before the end time. If both `startTime` and `endTime` are specified, `startTime` must precede `endTime`.
   */
  endTime?: string;
  /**
   * Response body in HTML format. Gmail will sanitize the HTML before storing it. If both `response_body_plain_text` and `response_body_html` are specified, `response_body_html` will be used.
   */
  responseBodyHtml?: string;
  /**
   * Response body in plain text format. If both `response_body_plain_text` and `response_body_html` are specified, `response_body_html` will be used.
   */
  responseBodyPlainText?: string;
  /**
   * Optional text to prepend to the subject line in vacation responses. In order to enable auto-replies, either the response subject or the response body must be nonempty.
   */
  responseSubject?: string;
  /**
   * Flag that determines whether responses are sent to recipients who are not in the user's list of contacts.
   */
  restrictToContacts?: boolean;
  /**
   * Flag that determines whether responses are sent to recipients who are outside of the user's domain. This feature is only available for Google Workspace users.
   */
  restrictToDomain?: boolean;
  /**
   * An optional start time for sending auto-replies (epoch ms). When this is specified, Gmail will automatically reply only to messages that it receives after the start time. If both `startTime` and `endTime` are specified, `startTime` must precede `endTime`.
   */
  startTime?: string;
};

/**
 * Set up or update a new push notification watch on this user's mailbox.
 */
export type WatchRequest = {
  /**
   * Filtering behavior of `labelIds list` specified. This field is deprecated because it caused incorrect behavior in some cases; use `label_filter_behavior` instead.
   * @deprecated
   */
  labelFilterAction?: 'include' | 'exclude';
  /**
   * Filtering behavior of `labelIds list` specified. This field replaces `label_filter_action`; if set, `label_filter_action` is ignored.
   */
  labelFilterBehavior?: 'include' | 'exclude';
  /**
   * List of label_ids to restrict notifications about. By default, if unspecified, all changes are pushed out. If specified then dictates which labels are required for a push notification to be generated.
   */
  labelIds?: Array<string>;
  /**
   * A fully qualified Google Cloud Pub/Sub API topic name to publish the events to. This topic name **must** already exist in Cloud Pub/Sub and you **must** have already granted gmail "publish" permission on it. For example, "projects/my-project-identifier/topics/my-topic-name" (using the Cloud Pub/Sub "v1" topic naming format). Note that the "my-project-identifier" portion must exactly match your Google developer project id (the one executing this watch request).
   */
  topicName?: string;
};

/**
 * Filtering behavior of `labelIds list` specified. This field is deprecated because it caused incorrect behavior in some cases; use `label_filter_behavior` instead.
 * @deprecated
 */
export type labelFilterAction = 'include' | 'exclude';

/**
 * Filtering behavior of `labelIds list` specified. This field replaces `label_filter_action`; if set, `label_filter_action` is ignored.
 */
export type labelFilterBehavior = 'include' | 'exclude';

/**
 * Push notification watch response.
 */
export type WatchResponse = {
  /**
   * When Gmail will stop sending notifications for mailbox updates (epoch millis). Call `watch` again before this time to renew the watch.
   */
  expiration?: string;
  /**
   * The ID of the mailbox's current history record.
   */
  historyId?: string;
};

/**
 * V1 error format.
 */
export type Parameter__xgafv = '1' | '2';

/**
 * OAuth access token.
 */
export type Parameteraccess_token = string;

/**
 * Data format for response.
 */
export type Parameteralt = 'json' | 'media' | 'proto';

/**
 * JSONP
 */
export type Parametercallback = string;

/**
 * Selector specifying which fields to include in a partial response.
 */
export type Parameterfields = string;

/**
 * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
 */
export type Parameterkey = string;

/**
 * OAuth 2.0 token for the current user.
 */
export type Parameteroauth_token = string;

/**
 * Returns response with indentations and line breaks.
 */
export type ParameterprettyPrint = boolean;

/**
 * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
 */
export type ParameterquotaUser = string;

/**
 * Legacy upload protocol for media (e.g. "media", "multipart").
 */
export type ParameteruploadType = string;

/**
 * Upload protocol for media (e.g. "raw", "multipart").
 */
export type Parameterupload_protocol = string;

export type GmailUsersDraftsListData = {
  path: {
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * Include drafts from `SPAM` and `TRASH` in the results.
     */
    includeSpamTrash?: boolean;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * Maximum number of drafts to return. This field defaults to 100. The maximum allowed value for this field is 500.
     */
    maxResults?: number;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Page token to retrieve a specific page of results in the list.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Only return draft messages matching the specified query. Supports the same query format as the Gmail search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`.
     */
    q?: string;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersDraftsListResponse = ListDraftsResponse;

export type GmailUsersDraftsListError = unknown;

export type GmailUsersDraftsCreateData = {
  body?: Draft;
  path: {
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersDraftsCreateResponse = Draft;

export type GmailUsersDraftsCreateError = unknown;

export type GmailUsersDraftsSendData = {
  body?: Draft;
  path: {
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersDraftsSendResponse = Message;

export type GmailUsersDraftsSendError = unknown;

export type GmailUsersDraftsDeleteData = {
  path: {
    /**
     * The ID of the draft to delete.
     */
    id: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersDraftsDeleteResponse = unknown;

export type GmailUsersDraftsDeleteError = unknown;

export type GmailUsersDraftsGetData = {
  path: {
    /**
     * The ID of the draft to retrieve.
     */
    id: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * The format to return the draft in.
     */
    format?: 'minimal' | 'full' | 'raw' | 'metadata';
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersDraftsGetResponse = Draft;

export type GmailUsersDraftsGetError = unknown;

export type GmailUsersDraftsUpdateData = {
  body?: Draft;
  path: {
    /**
     * The ID of the draft to update.
     */
    id: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersDraftsUpdateResponse = Draft;

export type GmailUsersDraftsUpdateError = unknown;

export type GmailUsersHistoryListData = {
  path: {
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * History types to be returned by the function
     */
    historyTypes?: Array<'messageAdded' | 'messageDeleted' | 'labelAdded' | 'labelRemoved'>;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * Only return messages with a label matching the ID.
     */
    labelId?: string;
    /**
     * Maximum number of history records to return. This field defaults to 100. The maximum allowed value for this field is 500.
     */
    maxResults?: number;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Page token to retrieve a specific page of results in the list.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Required. Returns history records after the specified `startHistoryId`. The supplied `startHistoryId` should be obtained from the `historyId` of a message, thread, or previous `list` response. History IDs increase chronologically but are not contiguous with random gaps in between valid IDs. Supplying an invalid or out of date `startHistoryId` typically returns an `HTTP 404` error code. A `historyId` is typically valid for at least a week, but in some rare circumstances may be valid for only a few hours. If you receive an `HTTP 404` error response, your application should perform a full sync. If you receive no `nextPageToken` in the response, there are no updates to retrieve and you can store the returned `historyId` for a future request.
     */
    startHistoryId?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersHistoryListResponse = ListHistoryResponse;

export type GmailUsersHistoryListError = unknown;

export type GmailUsersLabelsListData = {
  path: {
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersLabelsListResponse = ListLabelsResponse;

export type GmailUsersLabelsListError = unknown;

export type GmailUsersLabelsCreateData = {
  body?: Label;
  path: {
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersLabelsCreateResponse = Label;

export type GmailUsersLabelsCreateError = unknown;

export type GmailUsersLabelsDeleteData = {
  path: {
    /**
     * The ID of the label to delete.
     */
    id: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersLabelsDeleteResponse = unknown;

export type GmailUsersLabelsDeleteError = unknown;

export type GmailUsersLabelsGetData = {
  path: {
    /**
     * The ID of the label to retrieve.
     */
    id: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersLabelsGetResponse = Label;

export type GmailUsersLabelsGetError = unknown;

export type GmailUsersLabelsPatchData = {
  body?: Label;
  path: {
    /**
     * The ID of the label to update.
     */
    id: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersLabelsPatchResponse = Label;

export type GmailUsersLabelsPatchError = unknown;

export type GmailUsersLabelsUpdateData = {
  body?: Label;
  path: {
    /**
     * The ID of the label to update.
     */
    id: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersLabelsUpdateResponse = Label;

export type GmailUsersLabelsUpdateError = unknown;

export type GmailUsersMessagesListData = {
  path: {
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * Include messages from `SPAM` and `TRASH` in the results.
     */
    includeSpamTrash?: boolean;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * Only return messages with labels that match all of the specified label IDs. Messages in a thread might have labels that other messages in the same thread don't have. To learn more, see [Manage labels on messages and threads](https://developers.google.com/gmail/api/guides/labels#manage_labels_on_messages_threads).
     */
    labelIds?: Array<string>;
    /**
     * Maximum number of messages to return. This field defaults to 100. The maximum allowed value for this field is 500.
     */
    maxResults?: number;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Page token to retrieve a specific page of results in the list.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Only return messages matching the specified query. Supports the same query format as the Gmail search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`. Parameter cannot be used when accessing the api using the gmail.metadata scope.
     */
    q?: string;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersMessagesListResponse = ListMessagesResponse;

export type GmailUsersMessagesListError = unknown;

export type GmailUsersMessagesInsertData = {
  body?: Message;
  path: {
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Mark the email as permanently deleted (not TRASH) and only visible in Google Vault to a Vault administrator. Only used for Google Workspace accounts.
     */
    deleted?: boolean;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * Source for Gmail's internal date of the message.
     */
    internalDateSource?: 'receivedTime' | 'dateHeader';
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersMessagesInsertResponse = Message;

export type GmailUsersMessagesInsertError = unknown;

export type GmailUsersMessagesBatchDeleteData = {
  body?: BatchDeleteMessagesRequest;
  path: {
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersMessagesBatchDeleteResponse = unknown;

export type GmailUsersMessagesBatchDeleteError = unknown;

export type GmailUsersMessagesBatchModifyData = {
  body?: BatchModifyMessagesRequest;
  path: {
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersMessagesBatchModifyResponse = unknown;

export type GmailUsersMessagesBatchModifyError = unknown;

export type GmailUsersMessagesImportData = {
  body?: Message;
  path: {
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Mark the email as permanently deleted (not TRASH) and only visible in Google Vault to a Vault administrator. Only used for Google Workspace accounts.
     */
    deleted?: boolean;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * Source for Gmail's internal date of the message.
     */
    internalDateSource?: 'receivedTime' | 'dateHeader';
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * Ignore the Gmail spam classifier decision and never mark this email as SPAM in the mailbox.
     */
    neverMarkSpam?: boolean;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Process calendar invites in the email and add any extracted meetings to the Google Calendar for this user.
     */
    processForCalendar?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersMessagesImportResponse = Message;

export type GmailUsersMessagesImportError = unknown;

export type GmailUsersMessagesSendData = {
  body?: Message;
  path: {
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersMessagesSendResponse = Message;

export type GmailUsersMessagesSendError = unknown;

export type GmailUsersMessagesDeleteData = {
  path: {
    /**
     * The ID of the message to delete.
     */
    id: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersMessagesDeleteResponse = unknown;

export type GmailUsersMessagesDeleteError = unknown;

export type GmailUsersMessagesGetData = {
  path: {
    /**
     * The ID of the message to retrieve. This ID is usually retrieved using `messages.list`. The ID is also contained in the result when a message is inserted (`messages.insert`) or imported (`messages.import`).
     */
    id: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * The format to return the message in.
     */
    format?: 'minimal' | 'full' | 'raw' | 'metadata';
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * When given and format is `METADATA`, only include headers specified.
     */
    metadataHeaders?: Array<string>;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersMessagesGetResponse = Message;

export type GmailUsersMessagesGetError = unknown;

export type GmailUsersMessagesModifyData = {
  body?: ModifyMessageRequest;
  path: {
    /**
     * The ID of the message to modify.
     */
    id: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersMessagesModifyResponse = Message;

export type GmailUsersMessagesModifyError = unknown;

export type GmailUsersMessagesTrashData = {
  path: {
    /**
     * The ID of the message to Trash.
     */
    id: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersMessagesTrashResponse = Message;

export type GmailUsersMessagesTrashError = unknown;

export type GmailUsersMessagesUntrashData = {
  path: {
    /**
     * The ID of the message to remove from Trash.
     */
    id: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersMessagesUntrashResponse = Message;

export type GmailUsersMessagesUntrashError = unknown;

export type GmailUsersMessagesAttachmentsGetData = {
  path: {
    /**
     * The ID of the attachment.
     */
    id: string;
    /**
     * The ID of the message containing the attachment.
     */
    messageId: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersMessagesAttachmentsGetResponse = MessagePartBody;

export type GmailUsersMessagesAttachmentsGetError = unknown;

export type GmailUsersGetProfileData = {
  path: {
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersGetProfileResponse = Profile;

export type GmailUsersGetProfileError = unknown;

export type GmailUsersSettingsGetAutoForwardingData = {
  path: {
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsGetAutoForwardingResponse = AutoForwarding;

export type GmailUsersSettingsGetAutoForwardingError = unknown;

export type GmailUsersSettingsUpdateAutoForwardingData = {
  body?: AutoForwarding;
  path: {
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsUpdateAutoForwardingResponse = AutoForwarding;

export type GmailUsersSettingsUpdateAutoForwardingError = unknown;

export type GmailUsersSettingsCseIdentitiesListData = {
  path: {
    /**
     * The requester's primary email address. To indicate the authenticated user, you can use the special value `me`.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The number of identities to return. If not provided, the page size will default to 20 entries.
     */
    pageSize?: number;
    /**
     * Pagination token indicating which page of identities to return. If the token is not supplied, then the API will return the first page of results.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsCseIdentitiesListResponse = ListCseIdentitiesResponse;

export type GmailUsersSettingsCseIdentitiesListError = unknown;

export type GmailUsersSettingsCseIdentitiesCreateData = {
  body?: CseIdentity;
  path: {
    /**
     * The requester's primary email address. To indicate the authenticated user, you can use the special value `me`.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsCseIdentitiesCreateResponse = CseIdentity;

export type GmailUsersSettingsCseIdentitiesCreateError = unknown;

export type GmailUsersSettingsCseIdentitiesDeleteData = {
  path: {
    /**
     * The primary email address associated with the client-side encryption identity configuration that's removed.
     */
    cseEmailAddress: string;
    /**
     * The requester's primary email address. To indicate the authenticated user, you can use the special value `me`.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsCseIdentitiesDeleteResponse = unknown;

export type GmailUsersSettingsCseIdentitiesDeleteError = unknown;

export type GmailUsersSettingsCseIdentitiesGetData = {
  path: {
    /**
     * The primary email address associated with the client-side encryption identity configuration that's retrieved.
     */
    cseEmailAddress: string;
    /**
     * The requester's primary email address. To indicate the authenticated user, you can use the special value `me`.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsCseIdentitiesGetResponse = CseIdentity;

export type GmailUsersSettingsCseIdentitiesGetError = unknown;

export type GmailUsersSettingsCseIdentitiesPatchData = {
  body?: CseIdentity;
  path: {
    /**
     * The email address of the client-side encryption identity to update.
     */
    emailAddress: string;
    /**
     * The requester's primary email address. To indicate the authenticated user, you can use the special value `me`.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsCseIdentitiesPatchResponse = CseIdentity;

export type GmailUsersSettingsCseIdentitiesPatchError = unknown;

export type GmailUsersSettingsCseKeypairsListData = {
  path: {
    /**
     * The requester's primary email address. To indicate the authenticated user, you can use the special value `me`.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The number of key pairs to return. If not provided, the page size will default to 20 entries.
     */
    pageSize?: number;
    /**
     * Pagination token indicating which page of key pairs to return. If the token is not supplied, then the API will return the first page of results.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsCseKeypairsListResponse = ListCseKeyPairsResponse;

export type GmailUsersSettingsCseKeypairsListError = unknown;

export type GmailUsersSettingsCseKeypairsCreateData = {
  body?: CseKeyPair;
  path: {
    /**
     * The requester's primary email address. To indicate the authenticated user, you can use the special value `me`.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsCseKeypairsCreateResponse = CseKeyPair;

export type GmailUsersSettingsCseKeypairsCreateError = unknown;

export type GmailUsersSettingsCseKeypairsGetData = {
  path: {
    /**
     * The identifier of the key pair to retrieve.
     */
    keyPairId: string;
    /**
     * The requester's primary email address. To indicate the authenticated user, you can use the special value `me`.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsCseKeypairsGetResponse = CseKeyPair;

export type GmailUsersSettingsCseKeypairsGetError = unknown;

export type GmailUsersSettingsCseKeypairsDisableData = {
  body?: DisableCseKeyPairRequest;
  path: {
    /**
     * The identifier of the key pair to turn off.
     */
    keyPairId: string;
    /**
     * The requester's primary email address. To indicate the authenticated user, you can use the special value `me`.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsCseKeypairsDisableResponse = CseKeyPair;

export type GmailUsersSettingsCseKeypairsDisableError = unknown;

export type GmailUsersSettingsCseKeypairsEnableData = {
  body?: EnableCseKeyPairRequest;
  path: {
    /**
     * The identifier of the key pair to turn on.
     */
    keyPairId: string;
    /**
     * The requester's primary email address. To indicate the authenticated user, you can use the special value `me`.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsCseKeypairsEnableResponse = CseKeyPair;

export type GmailUsersSettingsCseKeypairsEnableError = unknown;

export type GmailUsersSettingsCseKeypairsObliterateData = {
  body?: ObliterateCseKeyPairRequest;
  path: {
    /**
     * The identifier of the key pair to obliterate.
     */
    keyPairId: string;
    /**
     * The requester's primary email address. To indicate the authenticated user, you can use the special value `me`.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsCseKeypairsObliterateResponse = unknown;

export type GmailUsersSettingsCseKeypairsObliterateError = unknown;

export type GmailUsersSettingsDelegatesListData = {
  path: {
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsDelegatesListResponse = ListDelegatesResponse;

export type GmailUsersSettingsDelegatesListError = unknown;

export type GmailUsersSettingsDelegatesCreateData = {
  body?: Delegate;
  path: {
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsDelegatesCreateResponse = Delegate;

export type GmailUsersSettingsDelegatesCreateError = unknown;

export type GmailUsersSettingsDelegatesDeleteData = {
  path: {
    /**
     * The email address of the user to be removed as a delegate.
     */
    delegateEmail: string;
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsDelegatesDeleteResponse = unknown;

export type GmailUsersSettingsDelegatesDeleteError = unknown;

export type GmailUsersSettingsDelegatesGetData = {
  path: {
    /**
     * The email address of the user whose delegate relationship is to be retrieved.
     */
    delegateEmail: string;
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsDelegatesGetResponse = Delegate;

export type GmailUsersSettingsDelegatesGetError = unknown;

export type GmailUsersSettingsFiltersListData = {
  path: {
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsFiltersListResponse = ListFiltersResponse;

export type GmailUsersSettingsFiltersListError = unknown;

export type GmailUsersSettingsFiltersCreateData = {
  body?: Filter;
  path: {
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsFiltersCreateResponse = Filter;

export type GmailUsersSettingsFiltersCreateError = unknown;

export type GmailUsersSettingsFiltersDeleteData = {
  path: {
    /**
     * The ID of the filter to be deleted.
     */
    id: string;
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsFiltersDeleteResponse = unknown;

export type GmailUsersSettingsFiltersDeleteError = unknown;

export type GmailUsersSettingsFiltersGetData = {
  path: {
    /**
     * The ID of the filter to be fetched.
     */
    id: string;
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsFiltersGetResponse = Filter;

export type GmailUsersSettingsFiltersGetError = unknown;

export type GmailUsersSettingsForwardingAddressesListData = {
  path: {
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsForwardingAddressesListResponse = ListForwardingAddressesResponse;

export type GmailUsersSettingsForwardingAddressesListError = unknown;

export type GmailUsersSettingsForwardingAddressesCreateData = {
  body?: ForwardingAddress;
  path: {
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsForwardingAddressesCreateResponse = ForwardingAddress;

export type GmailUsersSettingsForwardingAddressesCreateError = unknown;

export type GmailUsersSettingsForwardingAddressesDeleteData = {
  path: {
    /**
     * The forwarding address to be deleted.
     */
    forwardingEmail: string;
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsForwardingAddressesDeleteResponse = unknown;

export type GmailUsersSettingsForwardingAddressesDeleteError = unknown;

export type GmailUsersSettingsForwardingAddressesGetData = {
  path: {
    /**
     * The forwarding address to be retrieved.
     */
    forwardingEmail: string;
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsForwardingAddressesGetResponse = ForwardingAddress;

export type GmailUsersSettingsForwardingAddressesGetError = unknown;

export type GmailUsersSettingsGetImapData = {
  path: {
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsGetImapResponse = ImapSettings;

export type GmailUsersSettingsGetImapError = unknown;

export type GmailUsersSettingsUpdateImapData = {
  body?: ImapSettings;
  path: {
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsUpdateImapResponse = ImapSettings;

export type GmailUsersSettingsUpdateImapError = unknown;

export type GmailUsersSettingsGetLanguageData = {
  path: {
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsGetLanguageResponse = LanguageSettings;

export type GmailUsersSettingsGetLanguageError = unknown;

export type GmailUsersSettingsUpdateLanguageData = {
  body?: LanguageSettings;
  path: {
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsUpdateLanguageResponse = LanguageSettings;

export type GmailUsersSettingsUpdateLanguageError = unknown;

export type GmailUsersSettingsGetPopData = {
  path: {
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsGetPopResponse = PopSettings;

export type GmailUsersSettingsGetPopError = unknown;

export type GmailUsersSettingsUpdatePopData = {
  body?: PopSettings;
  path: {
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsUpdatePopResponse = PopSettings;

export type GmailUsersSettingsUpdatePopError = unknown;

export type GmailUsersSettingsSendAsListData = {
  path: {
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsSendAsListResponse = ListSendAsResponse;

export type GmailUsersSettingsSendAsListError = unknown;

export type GmailUsersSettingsSendAsCreateData = {
  body?: SendAs;
  path: {
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsSendAsCreateResponse = SendAs;

export type GmailUsersSettingsSendAsCreateError = unknown;

export type GmailUsersSettingsSendAsDeleteData = {
  path: {
    /**
     * The send-as alias to be deleted.
     */
    sendAsEmail: string;
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsSendAsDeleteResponse = unknown;

export type GmailUsersSettingsSendAsDeleteError = unknown;

export type GmailUsersSettingsSendAsGetData = {
  path: {
    /**
     * The send-as alias to be retrieved.
     */
    sendAsEmail: string;
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsSendAsGetResponse = SendAs;

export type GmailUsersSettingsSendAsGetError = unknown;

export type GmailUsersSettingsSendAsPatchData = {
  body?: SendAs;
  path: {
    /**
     * The send-as alias to be updated.
     */
    sendAsEmail: string;
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsSendAsPatchResponse = SendAs;

export type GmailUsersSettingsSendAsPatchError = unknown;

export type GmailUsersSettingsSendAsUpdateData = {
  body?: SendAs;
  path: {
    /**
     * The send-as alias to be updated.
     */
    sendAsEmail: string;
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsSendAsUpdateResponse = SendAs;

export type GmailUsersSettingsSendAsUpdateError = unknown;

export type GmailUsersSettingsSendAsSmimeInfoListData = {
  path: {
    /**
     * The email address that appears in the "From:" header for mail sent using this alias.
     */
    sendAsEmail: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsSendAsSmimeInfoListResponse = ListSmimeInfoResponse;

export type GmailUsersSettingsSendAsSmimeInfoListError = unknown;

export type GmailUsersSettingsSendAsSmimeInfoInsertData = {
  body?: SmimeInfo;
  path: {
    /**
     * The email address that appears in the "From:" header for mail sent using this alias.
     */
    sendAsEmail: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsSendAsSmimeInfoInsertResponse = SmimeInfo;

export type GmailUsersSettingsSendAsSmimeInfoInsertError = unknown;

export type GmailUsersSettingsSendAsSmimeInfoDeleteData = {
  path: {
    /**
     * The immutable ID for the SmimeInfo.
     */
    id: string;
    /**
     * The email address that appears in the "From:" header for mail sent using this alias.
     */
    sendAsEmail: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsSendAsSmimeInfoDeleteResponse = unknown;

export type GmailUsersSettingsSendAsSmimeInfoDeleteError = unknown;

export type GmailUsersSettingsSendAsSmimeInfoGetData = {
  path: {
    /**
     * The immutable ID for the SmimeInfo.
     */
    id: string;
    /**
     * The email address that appears in the "From:" header for mail sent using this alias.
     */
    sendAsEmail: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsSendAsSmimeInfoGetResponse = SmimeInfo;

export type GmailUsersSettingsSendAsSmimeInfoGetError = unknown;

export type GmailUsersSettingsSendAsSmimeInfoSetDefaultData = {
  path: {
    /**
     * The immutable ID for the SmimeInfo.
     */
    id: string;
    /**
     * The email address that appears in the "From:" header for mail sent using this alias.
     */
    sendAsEmail: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsSendAsSmimeInfoSetDefaultResponse = unknown;

export type GmailUsersSettingsSendAsSmimeInfoSetDefaultError = unknown;

export type GmailUsersSettingsSendAsVerifyData = {
  path: {
    /**
     * The send-as alias to be verified.
     */
    sendAsEmail: string;
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsSendAsVerifyResponse = unknown;

export type GmailUsersSettingsSendAsVerifyError = unknown;

export type GmailUsersSettingsGetVacationData = {
  path: {
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsGetVacationResponse = VacationSettings;

export type GmailUsersSettingsGetVacationError = unknown;

export type GmailUsersSettingsUpdateVacationData = {
  body?: VacationSettings;
  path: {
    /**
     * User's email address. The special value "me" can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersSettingsUpdateVacationResponse = VacationSettings;

export type GmailUsersSettingsUpdateVacationError = unknown;

export type GmailUsersStopData = {
  path: {
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersStopResponse = unknown;

export type GmailUsersStopError = unknown;

export type GmailUsersThreadsListData = {
  path: {
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * Include threads from `SPAM` and `TRASH` in the results.
     */
    includeSpamTrash?: boolean;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * Only return threads with labels that match all of the specified label IDs.
     */
    labelIds?: Array<string>;
    /**
     * Maximum number of threads to return. This field defaults to 100. The maximum allowed value for this field is 500.
     */
    maxResults?: number;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Page token to retrieve a specific page of results in the list.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Only return threads matching the specified query. Supports the same query format as the Gmail search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`. Parameter cannot be used when accessing the api using the gmail.metadata scope.
     */
    q?: string;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersThreadsListResponse = ListThreadsResponse;

export type GmailUsersThreadsListError = unknown;

export type GmailUsersThreadsDeleteData = {
  path: {
    /**
     * ID of the Thread to delete.
     */
    id: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersThreadsDeleteResponse = unknown;

export type GmailUsersThreadsDeleteError = unknown;

export type GmailUsersThreadsGetData = {
  path: {
    /**
     * The ID of the thread to retrieve.
     */
    id: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * The format to return the messages in.
     */
    format?: 'full' | 'metadata' | 'minimal';
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * When given and format is METADATA, only include headers specified.
     */
    metadataHeaders?: Array<string>;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersThreadsGetResponse = Thread;

export type GmailUsersThreadsGetError = unknown;

export type GmailUsersThreadsModifyData = {
  body?: ModifyThreadRequest;
  path: {
    /**
     * The ID of the thread to modify.
     */
    id: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersThreadsModifyResponse = Thread;

export type GmailUsersThreadsModifyError = unknown;

export type GmailUsersThreadsTrashData = {
  path: {
    /**
     * The ID of the thread to Trash.
     */
    id: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersThreadsTrashResponse = Thread;

export type GmailUsersThreadsTrashError = unknown;

export type GmailUsersThreadsUntrashData = {
  path: {
    /**
     * The ID of the thread to remove from Trash.
     */
    id: string;
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersThreadsUntrashResponse = Thread;

export type GmailUsersThreadsUntrashError = unknown;

export type GmailUsersWatchData = {
  body?: WatchRequest;
  path: {
    /**
     * The user's email address. The special value `me` can be used to indicate the authenticated user.
     */
    userId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type GmailUsersWatchResponse = WatchResponse;

export type GmailUsersWatchError = unknown;
