// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  GmailUsersDraftsListData,
  GmailUsersDraftsListError,
  GmailUsersDraftsListResponse,
  GmailUsersDraftsCreateData,
  GmailUsersDraftsCreateError,
  GmailUsersDraftsCreateResponse,
  GmailUsersDraftsSendData,
  GmailUsersDraftsSendError,
  GmailUsersDraftsSendResponse,
  GmailUsersDraftsDeleteData,
  GmailUsersDraftsDeleteError,
  GmailUsersDraftsDeleteResponse,
  GmailUsersDraftsGetData,
  GmailUsersDraftsGetError,
  GmailUsersDraftsGetResponse,
  GmailUsersDraftsUpdateData,
  GmailUsersDraftsUpdateError,
  GmailUsersDraftsUpdateResponse,
  GmailUsersHistoryListData,
  GmailUsersHistoryListError,
  GmailUsersHistoryListResponse,
  GmailUsersLabelsListData,
  GmailUsersLabelsListError,
  GmailUsersLabelsListResponse,
  GmailUsersLabelsCreateData,
  GmailUsersLabelsCreateError,
  GmailUsersLabelsCreateResponse,
  GmailUsersLabelsDeleteData,
  GmailUsersLabelsDeleteError,
  GmailUsersLabelsDeleteResponse,
  GmailUsersLabelsGetData,
  GmailUsersLabelsGetError,
  GmailUsersLabelsGetResponse,
  GmailUsersLabelsPatchData,
  GmailUsersLabelsPatchError,
  GmailUsersLabelsPatchResponse,
  GmailUsersLabelsUpdateData,
  GmailUsersLabelsUpdateError,
  GmailUsersLabelsUpdateResponse,
  GmailUsersMessagesListData,
  GmailUsersMessagesListError,
  GmailUsersMessagesListResponse,
  GmailUsersMessagesInsertData,
  GmailUsersMessagesInsertError,
  GmailUsersMessagesInsertResponse,
  GmailUsersMessagesBatchDeleteData,
  GmailUsersMessagesBatchDeleteError,
  GmailUsersMessagesBatchDeleteResponse,
  GmailUsersMessagesBatchModifyData,
  GmailUsersMessagesBatchModifyError,
  GmailUsersMessagesBatchModifyResponse,
  GmailUsersMessagesImportData,
  GmailUsersMessagesImportError,
  GmailUsersMessagesImportResponse,
  GmailUsersMessagesSendData,
  GmailUsersMessagesSendError,
  GmailUsersMessagesSendResponse,
  GmailUsersMessagesDeleteData,
  GmailUsersMessagesDeleteError,
  GmailUsersMessagesDeleteResponse,
  GmailUsersMessagesGetData,
  GmailUsersMessagesGetError,
  GmailUsersMessagesGetResponse,
  GmailUsersMessagesModifyData,
  GmailUsersMessagesModifyError,
  GmailUsersMessagesModifyResponse,
  GmailUsersMessagesTrashData,
  GmailUsersMessagesTrashError,
  GmailUsersMessagesTrashResponse,
  GmailUsersMessagesUntrashData,
  GmailUsersMessagesUntrashError,
  GmailUsersMessagesUntrashResponse,
  GmailUsersMessagesAttachmentsGetData,
  GmailUsersMessagesAttachmentsGetError,
  GmailUsersMessagesAttachmentsGetResponse,
  GmailUsersGetProfileData,
  GmailUsersGetProfileError,
  GmailUsersGetProfileResponse,
  GmailUsersSettingsGetAutoForwardingData,
  GmailUsersSettingsGetAutoForwardingError,
  GmailUsersSettingsGetAutoForwardingResponse,
  GmailUsersSettingsUpdateAutoForwardingData,
  GmailUsersSettingsUpdateAutoForwardingError,
  GmailUsersSettingsUpdateAutoForwardingResponse,
  GmailUsersSettingsCseIdentitiesListData,
  GmailUsersSettingsCseIdentitiesListError,
  GmailUsersSettingsCseIdentitiesListResponse,
  GmailUsersSettingsCseIdentitiesCreateData,
  GmailUsersSettingsCseIdentitiesCreateError,
  GmailUsersSettingsCseIdentitiesCreateResponse,
  GmailUsersSettingsCseIdentitiesDeleteData,
  GmailUsersSettingsCseIdentitiesDeleteError,
  GmailUsersSettingsCseIdentitiesDeleteResponse,
  GmailUsersSettingsCseIdentitiesGetData,
  GmailUsersSettingsCseIdentitiesGetError,
  GmailUsersSettingsCseIdentitiesGetResponse,
  GmailUsersSettingsCseIdentitiesPatchData,
  GmailUsersSettingsCseIdentitiesPatchError,
  GmailUsersSettingsCseIdentitiesPatchResponse,
  GmailUsersSettingsCseKeypairsListData,
  GmailUsersSettingsCseKeypairsListError,
  GmailUsersSettingsCseKeypairsListResponse,
  GmailUsersSettingsCseKeypairsCreateData,
  GmailUsersSettingsCseKeypairsCreateError,
  GmailUsersSettingsCseKeypairsCreateResponse,
  GmailUsersSettingsCseKeypairsGetData,
  GmailUsersSettingsCseKeypairsGetError,
  GmailUsersSettingsCseKeypairsGetResponse,
  GmailUsersSettingsCseKeypairsDisableData,
  GmailUsersSettingsCseKeypairsDisableError,
  GmailUsersSettingsCseKeypairsDisableResponse,
  GmailUsersSettingsCseKeypairsEnableData,
  GmailUsersSettingsCseKeypairsEnableError,
  GmailUsersSettingsCseKeypairsEnableResponse,
  GmailUsersSettingsCseKeypairsObliterateData,
  GmailUsersSettingsCseKeypairsObliterateError,
  GmailUsersSettingsCseKeypairsObliterateResponse,
  GmailUsersSettingsDelegatesListData,
  GmailUsersSettingsDelegatesListError,
  GmailUsersSettingsDelegatesListResponse,
  GmailUsersSettingsDelegatesCreateData,
  GmailUsersSettingsDelegatesCreateError,
  GmailUsersSettingsDelegatesCreateResponse,
  GmailUsersSettingsDelegatesDeleteData,
  GmailUsersSettingsDelegatesDeleteError,
  GmailUsersSettingsDelegatesDeleteResponse,
  GmailUsersSettingsDelegatesGetData,
  GmailUsersSettingsDelegatesGetError,
  GmailUsersSettingsDelegatesGetResponse,
  GmailUsersSettingsFiltersListData,
  GmailUsersSettingsFiltersListError,
  GmailUsersSettingsFiltersListResponse,
  GmailUsersSettingsFiltersCreateData,
  GmailUsersSettingsFiltersCreateError,
  GmailUsersSettingsFiltersCreateResponse,
  GmailUsersSettingsFiltersDeleteData,
  GmailUsersSettingsFiltersDeleteError,
  GmailUsersSettingsFiltersDeleteResponse,
  GmailUsersSettingsFiltersGetData,
  GmailUsersSettingsFiltersGetError,
  GmailUsersSettingsFiltersGetResponse,
  GmailUsersSettingsForwardingAddressesListData,
  GmailUsersSettingsForwardingAddressesListError,
  GmailUsersSettingsForwardingAddressesListResponse,
  GmailUsersSettingsForwardingAddressesCreateData,
  GmailUsersSettingsForwardingAddressesCreateError,
  GmailUsersSettingsForwardingAddressesCreateResponse,
  GmailUsersSettingsForwardingAddressesDeleteData,
  GmailUsersSettingsForwardingAddressesDeleteError,
  GmailUsersSettingsForwardingAddressesDeleteResponse,
  GmailUsersSettingsForwardingAddressesGetData,
  GmailUsersSettingsForwardingAddressesGetError,
  GmailUsersSettingsForwardingAddressesGetResponse,
  GmailUsersSettingsGetImapData,
  GmailUsersSettingsGetImapError,
  GmailUsersSettingsGetImapResponse,
  GmailUsersSettingsUpdateImapData,
  GmailUsersSettingsUpdateImapError,
  GmailUsersSettingsUpdateImapResponse,
  GmailUsersSettingsGetLanguageData,
  GmailUsersSettingsGetLanguageError,
  GmailUsersSettingsGetLanguageResponse,
  GmailUsersSettingsUpdateLanguageData,
  GmailUsersSettingsUpdateLanguageError,
  GmailUsersSettingsUpdateLanguageResponse,
  GmailUsersSettingsGetPopData,
  GmailUsersSettingsGetPopError,
  GmailUsersSettingsGetPopResponse,
  GmailUsersSettingsUpdatePopData,
  GmailUsersSettingsUpdatePopError,
  GmailUsersSettingsUpdatePopResponse,
  GmailUsersSettingsSendAsListData,
  GmailUsersSettingsSendAsListError,
  GmailUsersSettingsSendAsListResponse,
  GmailUsersSettingsSendAsCreateData,
  GmailUsersSettingsSendAsCreateError,
  GmailUsersSettingsSendAsCreateResponse,
  GmailUsersSettingsSendAsDeleteData,
  GmailUsersSettingsSendAsDeleteError,
  GmailUsersSettingsSendAsDeleteResponse,
  GmailUsersSettingsSendAsGetData,
  GmailUsersSettingsSendAsGetError,
  GmailUsersSettingsSendAsGetResponse,
  GmailUsersSettingsSendAsPatchData,
  GmailUsersSettingsSendAsPatchError,
  GmailUsersSettingsSendAsPatchResponse,
  GmailUsersSettingsSendAsUpdateData,
  GmailUsersSettingsSendAsUpdateError,
  GmailUsersSettingsSendAsUpdateResponse,
  GmailUsersSettingsSendAsSmimeInfoListData,
  GmailUsersSettingsSendAsSmimeInfoListError,
  GmailUsersSettingsSendAsSmimeInfoListResponse,
  GmailUsersSettingsSendAsSmimeInfoInsertData,
  GmailUsersSettingsSendAsSmimeInfoInsertError,
  GmailUsersSettingsSendAsSmimeInfoInsertResponse,
  GmailUsersSettingsSendAsSmimeInfoDeleteData,
  GmailUsersSettingsSendAsSmimeInfoDeleteError,
  GmailUsersSettingsSendAsSmimeInfoDeleteResponse,
  GmailUsersSettingsSendAsSmimeInfoGetData,
  GmailUsersSettingsSendAsSmimeInfoGetError,
  GmailUsersSettingsSendAsSmimeInfoGetResponse,
  GmailUsersSettingsSendAsSmimeInfoSetDefaultData,
  GmailUsersSettingsSendAsSmimeInfoSetDefaultError,
  GmailUsersSettingsSendAsSmimeInfoSetDefaultResponse,
  GmailUsersSettingsSendAsVerifyData,
  GmailUsersSettingsSendAsVerifyError,
  GmailUsersSettingsSendAsVerifyResponse,
  GmailUsersSettingsGetVacationData,
  GmailUsersSettingsGetVacationError,
  GmailUsersSettingsGetVacationResponse,
  GmailUsersSettingsUpdateVacationData,
  GmailUsersSettingsUpdateVacationError,
  GmailUsersSettingsUpdateVacationResponse,
  GmailUsersStopData,
  GmailUsersStopError,
  GmailUsersStopResponse,
  GmailUsersThreadsListData,
  GmailUsersThreadsListError,
  GmailUsersThreadsListResponse,
  GmailUsersThreadsDeleteData,
  GmailUsersThreadsDeleteError,
  GmailUsersThreadsDeleteResponse,
  GmailUsersThreadsGetData,
  GmailUsersThreadsGetError,
  GmailUsersThreadsGetResponse,
  GmailUsersThreadsModifyData,
  GmailUsersThreadsModifyError,
  GmailUsersThreadsModifyResponse,
  GmailUsersThreadsTrashData,
  GmailUsersThreadsTrashError,
  GmailUsersThreadsTrashResponse,
  GmailUsersThreadsUntrashData,
  GmailUsersThreadsUntrashError,
  GmailUsersThreadsUntrashResponse,
  GmailUsersWatchData,
  GmailUsersWatchError,
  GmailUsersWatchResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Lists the drafts in the user's mailbox.
 */
export const gmailUsersDraftsList = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersDraftsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GmailUsersDraftsListResponse, GmailUsersDraftsListError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/drafts',
  });
};

/**
 * Creates a new draft with the `DRAFT` label.
 */
export const gmailUsersDraftsCreate = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersDraftsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<GmailUsersDraftsCreateResponse, GmailUsersDraftsCreateError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/drafts',
  });
};

/**
 * Sends the specified, existing draft to the recipients in the `To`, `Cc`, and `Bcc` headers.
 */
export const gmailUsersDraftsSend = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersDraftsSendData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<GmailUsersDraftsSendResponse, GmailUsersDraftsSendError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/drafts/send',
  });
};

/**
 * Immediately and permanently deletes the specified draft. Does not simply trash it.
 */
export const gmailUsersDraftsDelete = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersDraftsDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<GmailUsersDraftsDeleteResponse, GmailUsersDraftsDeleteError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/drafts/{id}',
  });
};

/**
 * Gets the specified draft.
 */
export const gmailUsersDraftsGet = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersDraftsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GmailUsersDraftsGetResponse, GmailUsersDraftsGetError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/drafts/{id}',
  });
};

/**
 * Replaces a draft's content.
 */
export const gmailUsersDraftsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersDraftsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<GmailUsersDraftsUpdateResponse, GmailUsersDraftsUpdateError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/drafts/{id}',
  });
};

/**
 * Lists the history of all changes to the given mailbox. History results are returned in chronological order (increasing `historyId`).
 */
export const gmailUsersHistoryList = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersHistoryListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GmailUsersHistoryListResponse, GmailUsersHistoryListError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/history',
  });
};

/**
 * Lists all labels in the user's mailbox.
 */
export const gmailUsersLabelsList = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersLabelsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GmailUsersLabelsListResponse, GmailUsersLabelsListError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/labels',
  });
};

/**
 * Creates a new label.
 */
export const gmailUsersLabelsCreate = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersLabelsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<GmailUsersLabelsCreateResponse, GmailUsersLabelsCreateError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/labels',
  });
};

/**
 * Immediately and permanently deletes the specified label and removes it from any messages and threads that it is applied to.
 */
export const gmailUsersLabelsDelete = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersLabelsDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<GmailUsersLabelsDeleteResponse, GmailUsersLabelsDeleteError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/labels/{id}',
  });
};

/**
 * Gets the specified label.
 */
export const gmailUsersLabelsGet = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersLabelsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GmailUsersLabelsGetResponse, GmailUsersLabelsGetError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/labels/{id}',
  });
};

/**
 * Patch the specified label.
 */
export const gmailUsersLabelsPatch = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersLabelsPatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<GmailUsersLabelsPatchResponse, GmailUsersLabelsPatchError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/labels/{id}',
  });
};

/**
 * Updates the specified label.
 */
export const gmailUsersLabelsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersLabelsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<GmailUsersLabelsUpdateResponse, GmailUsersLabelsUpdateError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/labels/{id}',
  });
};

/**
 * Lists the messages in the user's mailbox.
 */
export const gmailUsersMessagesList = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersMessagesListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GmailUsersMessagesListResponse, GmailUsersMessagesListError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/messages',
  });
};

/**
 * Directly inserts a message into only this user's mailbox similar to `IMAP APPEND`, bypassing most scanning and classification. Does not send a message.
 */
export const gmailUsersMessagesInsert = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersMessagesInsertData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersMessagesInsertResponse,
    GmailUsersMessagesInsertError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/messages',
  });
};

/**
 * Deletes many messages by message ID. Provides no guarantees that messages were not already deleted or even existed at all.
 */
export const gmailUsersMessagesBatchDelete = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersMessagesBatchDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersMessagesBatchDeleteResponse,
    GmailUsersMessagesBatchDeleteError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/messages/batchDelete',
  });
};

/**
 * Modifies the labels on the specified messages.
 */
export const gmailUsersMessagesBatchModify = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersMessagesBatchModifyData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersMessagesBatchModifyResponse,
    GmailUsersMessagesBatchModifyError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/messages/batchModify',
  });
};

/**
 * Imports a message into only this user's mailbox, with standard email delivery scanning and classification similar to receiving via SMTP. This method doesn't perform SPF checks, so it might not work for some spam messages, such as those attempting to perform domain spoofing. This method does not send a message.
 */
export const gmailUsersMessagesImport = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersMessagesImportData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersMessagesImportResponse,
    GmailUsersMessagesImportError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/messages/import',
  });
};

/**
 * Sends the specified message to the recipients in the `To`, `Cc`, and `Bcc` headers. For example usage, see [Sending email](https://developers.google.com/gmail/api/guides/sending).
 */
export const gmailUsersMessagesSend = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersMessagesSendData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<GmailUsersMessagesSendResponse, GmailUsersMessagesSendError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/messages/send',
  });
};

/**
 * Immediately and permanently deletes the specified message. This operation cannot be undone. Prefer `messages.trash` instead.
 */
export const gmailUsersMessagesDelete = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersMessagesDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    GmailUsersMessagesDeleteResponse,
    GmailUsersMessagesDeleteError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/messages/{id}',
  });
};

/**
 * Gets the specified message.
 */
export const gmailUsersMessagesGet = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersMessagesGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GmailUsersMessagesGetResponse, GmailUsersMessagesGetError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/messages/{id}',
  });
};

/**
 * Modifies the labels on the specified message.
 */
export const gmailUsersMessagesModify = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersMessagesModifyData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersMessagesModifyResponse,
    GmailUsersMessagesModifyError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/messages/{id}/modify',
  });
};

/**
 * Moves the specified message to the trash.
 */
export const gmailUsersMessagesTrash = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersMessagesTrashData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<GmailUsersMessagesTrashResponse, GmailUsersMessagesTrashError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/messages/{id}/trash',
  });
};

/**
 * Removes the specified message from the trash.
 */
export const gmailUsersMessagesUntrash = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersMessagesUntrashData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersMessagesUntrashResponse,
    GmailUsersMessagesUntrashError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/messages/{id}/untrash',
  });
};

/**
 * Gets the specified message attachment.
 */
export const gmailUsersMessagesAttachmentsGet = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersMessagesAttachmentsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersMessagesAttachmentsGetResponse,
    GmailUsersMessagesAttachmentsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/messages/{messageId}/attachments/{id}',
  });
};

/**
 * Gets the current user's Gmail profile.
 */
export const gmailUsersGetProfile = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersGetProfileData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GmailUsersGetProfileResponse, GmailUsersGetProfileError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/profile',
  });
};

/**
 * Gets the auto-forwarding setting for the specified account.
 */
export const gmailUsersSettingsGetAutoForwarding = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsGetAutoForwardingData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersSettingsGetAutoForwardingResponse,
    GmailUsersSettingsGetAutoForwardingError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/autoForwarding',
  });
};

/**
 * Updates the auto-forwarding setting for the specified account. A verified forwarding address must be specified when auto-forwarding is enabled. This method is only available to service account clients that have been delegated domain-wide authority.
 */
export const gmailUsersSettingsUpdateAutoForwarding = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsUpdateAutoForwardingData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    GmailUsersSettingsUpdateAutoForwardingResponse,
    GmailUsersSettingsUpdateAutoForwardingError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/autoForwarding',
  });
};

/**
 * Lists the client-side encrypted identities for an authenticated user.
 */
export const gmailUsersSettingsCseIdentitiesList = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsCseIdentitiesListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersSettingsCseIdentitiesListResponse,
    GmailUsersSettingsCseIdentitiesListError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/cse/identities',
  });
};

/**
 * Creates and configures a client-side encryption identity that's authorized to send mail from the user account. Google publishes the S/MIME certificate to a shared domain-wide directory so that people within a Google Workspace organization can encrypt and send mail to the identity.
 */
export const gmailUsersSettingsCseIdentitiesCreate = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsCseIdentitiesCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersSettingsCseIdentitiesCreateResponse,
    GmailUsersSettingsCseIdentitiesCreateError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/cse/identities',
  });
};

/**
 * Deletes a client-side encryption identity. The authenticated user can no longer use the identity to send encrypted messages. You cannot restore the identity after you delete it. Instead, use the CreateCseIdentity method to create another identity with the same configuration.
 */
export const gmailUsersSettingsCseIdentitiesDelete = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsCseIdentitiesDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    GmailUsersSettingsCseIdentitiesDeleteResponse,
    GmailUsersSettingsCseIdentitiesDeleteError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/cse/identities/{cseEmailAddress}',
  });
};

/**
 * Retrieves a client-side encryption identity configuration.
 */
export const gmailUsersSettingsCseIdentitiesGet = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsCseIdentitiesGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersSettingsCseIdentitiesGetResponse,
    GmailUsersSettingsCseIdentitiesGetError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/cse/identities/{cseEmailAddress}',
  });
};

/**
 * Associates a different key pair with an existing client-side encryption identity. The updated key pair must validate against Google's [S/MIME certificate profiles](https://support.google.com/a/answer/7300887).
 */
export const gmailUsersSettingsCseIdentitiesPatch = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsCseIdentitiesPatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    GmailUsersSettingsCseIdentitiesPatchResponse,
    GmailUsersSettingsCseIdentitiesPatchError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/cse/identities/{emailAddress}',
  });
};

/**
 * Lists client-side encryption key pairs for an authenticated user.
 */
export const gmailUsersSettingsCseKeypairsList = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsCseKeypairsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersSettingsCseKeypairsListResponse,
    GmailUsersSettingsCseKeypairsListError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/cse/keypairs',
  });
};

/**
 * Creates and uploads a client-side encryption S/MIME public key certificate chain and private key metadata for the authenticated user.
 */
export const gmailUsersSettingsCseKeypairsCreate = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsCseKeypairsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersSettingsCseKeypairsCreateResponse,
    GmailUsersSettingsCseKeypairsCreateError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/cse/keypairs',
  });
};

/**
 * Retrieves an existing client-side encryption key pair.
 */
export const gmailUsersSettingsCseKeypairsGet = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsCseKeypairsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersSettingsCseKeypairsGetResponse,
    GmailUsersSettingsCseKeypairsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/cse/keypairs/{keyPairId}',
  });
};

/**
 * Turns off a client-side encryption key pair. The authenticated user can no longer use the key pair to decrypt incoming CSE message texts or sign outgoing CSE mail. To regain access, use the EnableCseKeyPair to turn on the key pair. After 30 days, you can permanently delete the key pair by using the ObliterateCseKeyPair method.
 */
export const gmailUsersSettingsCseKeypairsDisable = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsCseKeypairsDisableData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersSettingsCseKeypairsDisableResponse,
    GmailUsersSettingsCseKeypairsDisableError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/cse/keypairs/{keyPairId}:disable',
  });
};

/**
 * Turns on a client-side encryption key pair that was turned off. The key pair becomes active again for any associated client-side encryption identities.
 */
export const gmailUsersSettingsCseKeypairsEnable = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsCseKeypairsEnableData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersSettingsCseKeypairsEnableResponse,
    GmailUsersSettingsCseKeypairsEnableError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/cse/keypairs/{keyPairId}:enable',
  });
};

/**
 * Deletes a client-side encryption key pair permanently and immediately. You can only permanently delete key pairs that have been turned off for more than 30 days. To turn off a key pair, use the DisableCseKeyPair method. Gmail can't restore or decrypt any messages that were encrypted by an obliterated key. Authenticated users and Google Workspace administrators lose access to reading the encrypted messages.
 */
export const gmailUsersSettingsCseKeypairsObliterate = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsCseKeypairsObliterateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersSettingsCseKeypairsObliterateResponse,
    GmailUsersSettingsCseKeypairsObliterateError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/cse/keypairs/{keyPairId}:obliterate',
  });
};

/**
 * Lists the delegates for the specified account. This method is only available to service account clients that have been delegated domain-wide authority.
 */
export const gmailUsersSettingsDelegatesList = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsDelegatesListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersSettingsDelegatesListResponse,
    GmailUsersSettingsDelegatesListError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/delegates',
  });
};

/**
 * Adds a delegate with its verification status set directly to `accepted`, without sending any verification email. The delegate user must be a member of the same Google Workspace organization as the delegator user. Gmail imposes limitations on the number of delegates and delegators each user in a Google Workspace organization can have. These limits depend on your organization, but in general each user can have up to 25 delegates and up to 10 delegators. Note that a delegate user must be referred to by their primary email address, and not an email alias. Also note that when a new delegate is created, there may be up to a one minute delay before the new delegate is available for use. This method is only available to service account clients that have been delegated domain-wide authority.
 */
export const gmailUsersSettingsDelegatesCreate = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsDelegatesCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersSettingsDelegatesCreateResponse,
    GmailUsersSettingsDelegatesCreateError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/delegates',
  });
};

/**
 * Removes the specified delegate (which can be of any verification status), and revokes any verification that may have been required for using it. Note that a delegate user must be referred to by their primary email address, and not an email alias. This method is only available to service account clients that have been delegated domain-wide authority.
 */
export const gmailUsersSettingsDelegatesDelete = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsDelegatesDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    GmailUsersSettingsDelegatesDeleteResponse,
    GmailUsersSettingsDelegatesDeleteError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/delegates/{delegateEmail}',
  });
};

/**
 * Gets the specified delegate. Note that a delegate user must be referred to by their primary email address, and not an email alias. This method is only available to service account clients that have been delegated domain-wide authority.
 */
export const gmailUsersSettingsDelegatesGet = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsDelegatesGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersSettingsDelegatesGetResponse,
    GmailUsersSettingsDelegatesGetError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/delegates/{delegateEmail}',
  });
};

/**
 * Lists the message filters of a Gmail user.
 */
export const gmailUsersSettingsFiltersList = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsFiltersListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersSettingsFiltersListResponse,
    GmailUsersSettingsFiltersListError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/filters',
  });
};

/**
 * Creates a filter. Note: you can only create a maximum of 1,000 filters.
 */
export const gmailUsersSettingsFiltersCreate = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsFiltersCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersSettingsFiltersCreateResponse,
    GmailUsersSettingsFiltersCreateError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/filters',
  });
};

/**
 * Immediately and permanently deletes the specified filter.
 */
export const gmailUsersSettingsFiltersDelete = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsFiltersDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    GmailUsersSettingsFiltersDeleteResponse,
    GmailUsersSettingsFiltersDeleteError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/filters/{id}',
  });
};

/**
 * Gets a filter.
 */
export const gmailUsersSettingsFiltersGet = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsFiltersGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersSettingsFiltersGetResponse,
    GmailUsersSettingsFiltersGetError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/filters/{id}',
  });
};

/**
 * Lists the forwarding addresses for the specified account.
 */
export const gmailUsersSettingsForwardingAddressesList = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsForwardingAddressesListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersSettingsForwardingAddressesListResponse,
    GmailUsersSettingsForwardingAddressesListError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/forwardingAddresses',
  });
};

/**
 * Creates a forwarding address. If ownership verification is required, a message will be sent to the recipient and the resource's verification status will be set to `pending`; otherwise, the resource will be created with verification status set to `accepted`. This method is only available to service account clients that have been delegated domain-wide authority.
 */
export const gmailUsersSettingsForwardingAddressesCreate = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsForwardingAddressesCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersSettingsForwardingAddressesCreateResponse,
    GmailUsersSettingsForwardingAddressesCreateError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/forwardingAddresses',
  });
};

/**
 * Deletes the specified forwarding address and revokes any verification that may have been required. This method is only available to service account clients that have been delegated domain-wide authority.
 */
export const gmailUsersSettingsForwardingAddressesDelete = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsForwardingAddressesDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    GmailUsersSettingsForwardingAddressesDeleteResponse,
    GmailUsersSettingsForwardingAddressesDeleteError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/forwardingAddresses/{forwardingEmail}',
  });
};

/**
 * Gets the specified forwarding address.
 */
export const gmailUsersSettingsForwardingAddressesGet = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsForwardingAddressesGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersSettingsForwardingAddressesGetResponse,
    GmailUsersSettingsForwardingAddressesGetError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/forwardingAddresses/{forwardingEmail}',
  });
};

/**
 * Gets IMAP settings.
 */
export const gmailUsersSettingsGetImap = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsGetImapData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersSettingsGetImapResponse,
    GmailUsersSettingsGetImapError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/imap',
  });
};

/**
 * Updates IMAP settings.
 */
export const gmailUsersSettingsUpdateImap = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsUpdateImapData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    GmailUsersSettingsUpdateImapResponse,
    GmailUsersSettingsUpdateImapError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/imap',
  });
};

/**
 * Gets language settings.
 */
export const gmailUsersSettingsGetLanguage = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsGetLanguageData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersSettingsGetLanguageResponse,
    GmailUsersSettingsGetLanguageError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/language',
  });
};

/**
 * Updates language settings. If successful, the return object contains the `displayLanguage` that was saved for the user, which may differ from the value passed into the request. This is because the requested `displayLanguage` may not be directly supported by Gmail but have a close variant that is, and so the variant may be chosen and saved instead.
 */
export const gmailUsersSettingsUpdateLanguage = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsUpdateLanguageData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    GmailUsersSettingsUpdateLanguageResponse,
    GmailUsersSettingsUpdateLanguageError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/language',
  });
};

/**
 * Gets POP settings.
 */
export const gmailUsersSettingsGetPop = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsGetPopData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GmailUsersSettingsGetPopResponse, GmailUsersSettingsGetPopError, ThrowOnError>(
    {
      ...options,
      url: '/gmail/v1/users/{userId}/settings/pop',
    },
  );
};

/**
 * Updates POP settings.
 */
export const gmailUsersSettingsUpdatePop = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsUpdatePopData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    GmailUsersSettingsUpdatePopResponse,
    GmailUsersSettingsUpdatePopError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/pop',
  });
};

/**
 * Lists the send-as aliases for the specified account. The result includes the primary send-as address associated with the account as well as any custom "from" aliases.
 */
export const gmailUsersSettingsSendAsList = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsSendAsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersSettingsSendAsListResponse,
    GmailUsersSettingsSendAsListError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/sendAs',
  });
};

/**
 * Creates a custom "from" send-as alias. If an SMTP MSA is specified, Gmail will attempt to connect to the SMTP service to validate the configuration before creating the alias. If ownership verification is required for the alias, a message will be sent to the email address and the resource's verification status will be set to `pending`; otherwise, the resource will be created with verification status set to `accepted`. If a signature is provided, Gmail will sanitize the HTML before saving it with the alias. This method is only available to service account clients that have been delegated domain-wide authority.
 */
export const gmailUsersSettingsSendAsCreate = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsSendAsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersSettingsSendAsCreateResponse,
    GmailUsersSettingsSendAsCreateError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/sendAs',
  });
};

/**
 * Deletes the specified send-as alias. Revokes any verification that may have been required for using it. This method is only available to service account clients that have been delegated domain-wide authority.
 */
export const gmailUsersSettingsSendAsDelete = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsSendAsDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    GmailUsersSettingsSendAsDeleteResponse,
    GmailUsersSettingsSendAsDeleteError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}',
  });
};

/**
 * Gets the specified send-as alias. Fails with an HTTP 404 error if the specified address is not a member of the collection.
 */
export const gmailUsersSettingsSendAsGet = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsSendAsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersSettingsSendAsGetResponse,
    GmailUsersSettingsSendAsGetError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}',
  });
};

/**
 * Patch the specified send-as alias.
 */
export const gmailUsersSettingsSendAsPatch = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsSendAsPatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    GmailUsersSettingsSendAsPatchResponse,
    GmailUsersSettingsSendAsPatchError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}',
  });
};

/**
 * Updates a send-as alias. If a signature is provided, Gmail will sanitize the HTML before saving it with the alias. Addresses other than the primary address for the account can only be updated by service account clients that have been delegated domain-wide authority.
 */
export const gmailUsersSettingsSendAsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsSendAsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    GmailUsersSettingsSendAsUpdateResponse,
    GmailUsersSettingsSendAsUpdateError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}',
  });
};

/**
 * Lists S/MIME configs for the specified send-as alias.
 */
export const gmailUsersSettingsSendAsSmimeInfoList = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsSendAsSmimeInfoListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersSettingsSendAsSmimeInfoListResponse,
    GmailUsersSettingsSendAsSmimeInfoListError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}/smimeInfo',
  });
};

/**
 * Insert (upload) the given S/MIME config for the specified send-as alias. Note that pkcs12 format is required for the key.
 */
export const gmailUsersSettingsSendAsSmimeInfoInsert = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsSendAsSmimeInfoInsertData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersSettingsSendAsSmimeInfoInsertResponse,
    GmailUsersSettingsSendAsSmimeInfoInsertError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}/smimeInfo',
  });
};

/**
 * Deletes the specified S/MIME config for the specified send-as alias.
 */
export const gmailUsersSettingsSendAsSmimeInfoDelete = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsSendAsSmimeInfoDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    GmailUsersSettingsSendAsSmimeInfoDeleteResponse,
    GmailUsersSettingsSendAsSmimeInfoDeleteError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}/smimeInfo/{id}',
  });
};

/**
 * Gets the specified S/MIME config for the specified send-as alias.
 */
export const gmailUsersSettingsSendAsSmimeInfoGet = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsSendAsSmimeInfoGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersSettingsSendAsSmimeInfoGetResponse,
    GmailUsersSettingsSendAsSmimeInfoGetError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}/smimeInfo/{id}',
  });
};

/**
 * Sets the default S/MIME config for the specified send-as alias.
 */
export const gmailUsersSettingsSendAsSmimeInfoSetDefault = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsSendAsSmimeInfoSetDefaultData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersSettingsSendAsSmimeInfoSetDefaultResponse,
    GmailUsersSettingsSendAsSmimeInfoSetDefaultError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}/smimeInfo/{id}/setDefault',
  });
};

/**
 * Sends a verification email to the specified send-as alias address. The verification status must be `pending`. This method is only available to service account clients that have been delegated domain-wide authority.
 */
export const gmailUsersSettingsSendAsVerify = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsSendAsVerifyData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersSettingsSendAsVerifyResponse,
    GmailUsersSettingsSendAsVerifyError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/sendAs/{sendAsEmail}/verify',
  });
};

/**
 * Gets vacation responder settings.
 */
export const gmailUsersSettingsGetVacation = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsGetVacationData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GmailUsersSettingsGetVacationResponse,
    GmailUsersSettingsGetVacationError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/vacation',
  });
};

/**
 * Updates vacation responder settings.
 */
export const gmailUsersSettingsUpdateVacation = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersSettingsUpdateVacationData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    GmailUsersSettingsUpdateVacationResponse,
    GmailUsersSettingsUpdateVacationError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/settings/vacation',
  });
};

/**
 * Stop receiving push notifications for the given user mailbox.
 */
export const gmailUsersStop = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersStopData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<GmailUsersStopResponse, GmailUsersStopError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/stop',
  });
};

/**
 * Lists the threads in the user's mailbox.
 */
export const gmailUsersThreadsList = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersThreadsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GmailUsersThreadsListResponse, GmailUsersThreadsListError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/threads',
  });
};

/**
 * Immediately and permanently deletes the specified thread. Any messages that belong to the thread are also deleted. This operation cannot be undone. Prefer `threads.trash` instead.
 */
export const gmailUsersThreadsDelete = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersThreadsDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    GmailUsersThreadsDeleteResponse,
    GmailUsersThreadsDeleteError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/threads/{id}',
  });
};

/**
 * Gets the specified thread.
 */
export const gmailUsersThreadsGet = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersThreadsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GmailUsersThreadsGetResponse, GmailUsersThreadsGetError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/threads/{id}',
  });
};

/**
 * Modifies the labels applied to the thread. This applies to all messages in the thread.
 */
export const gmailUsersThreadsModify = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersThreadsModifyData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<GmailUsersThreadsModifyResponse, GmailUsersThreadsModifyError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/threads/{id}/modify',
  });
};

/**
 * Moves the specified thread to the trash. Any messages that belong to the thread are also moved to the trash.
 */
export const gmailUsersThreadsTrash = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersThreadsTrashData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<GmailUsersThreadsTrashResponse, GmailUsersThreadsTrashError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/threads/{id}/trash',
  });
};

/**
 * Removes the specified thread from the trash. Any messages that belong to the thread are also removed from the trash.
 */
export const gmailUsersThreadsUntrash = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersThreadsUntrashData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    GmailUsersThreadsUntrashResponse,
    GmailUsersThreadsUntrashError,
    ThrowOnError
  >({
    ...options,
    url: '/gmail/v1/users/{userId}/threads/{id}/untrash',
  });
};

/**
 * Set up or update a push notification watch on the given user mailbox.
 */
export const gmailUsersWatch = <ThrowOnError extends boolean = false>(
  options: Options<GmailUsersWatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<GmailUsersWatchResponse, GmailUsersWatchError, ThrowOnError>({
    ...options,
    url: '/gmail/v1/users/{userId}/watch',
  });
};
