// This file is auto-generated by @hey-api/openapi-ts

export const AutoForwardingSchema = {
  description: 'Auto-forwarding settings for an account.',
  properties: {
    disposition: {
      description: 'The state that a message should be left in after it has been forwarded.',
      enum: ['dispositionUnspecified', 'leaveInInbox', 'archive', 'trash', 'markRead'],
      type: 'string',
    },
    emailAddress: {
      description:
        'Email address to which all incoming messages are forwarded. This email address must be a verified member of the forwarding addresses.',
      type: 'string',
    },
    enabled: {
      description: 'Whether all incoming mail is automatically forwarded to another address.',
      type: 'boolean',
    },
  },
  type: 'object',
} as const;

export const BatchDeleteMessagesRequestSchema = {
  properties: {
    ids: {
      description: 'The IDs of the messages to delete.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const BatchModifyMessagesRequestSchema = {
  properties: {
    addLabelIds: {
      description: 'A list of label IDs to add to messages.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    ids: {
      description: 'The IDs of the messages to modify. There is a limit of 1000 ids per request.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    removeLabelIds: {
      description: 'A list of label IDs to remove from messages.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const CseIdentitySchema = {
  description:
    'The client-side encryption (CSE) configuration for the email address of an authenticated user. Gmail uses CSE configurations to save drafts of client-side encrypted email messages, and to sign and send encrypted email messages.',
  properties: {
    emailAddress: {
      description:
        'The email address for the sending identity. The email address must be the primary email address of the authenticated user.',
      type: 'string',
    },
    primaryKeyPairId: {
      description: 'If a key pair is associated, the ID of the key pair, CseKeyPair.',
      type: 'string',
    },
    signAndEncryptKeyPairs: {
      $ref: '#/components/schemas/SignAndEncryptKeyPairs',
      description: 'The configuration of a CSE identity that uses different key pairs for signing and encryption.',
    },
  },
  type: 'object',
} as const;

export const CseKeyPairSchema = {
  description:
    'A client-side encryption S/MIME key pair, which is comprised of a public key, its certificate chain, and metadata for its paired private key. Gmail uses the key pair to complete the following tasks: - Sign outgoing client-side encrypted messages. - Save and reopen drafts of client-side encrypted messages. - Save and reopen sent messages. - Decrypt incoming or archived S/MIME messages.',
  properties: {
    disableTime: {
      description:
        "Output only. If a key pair is set to `DISABLED`, the time that the key pair's state changed from `ENABLED` to `DISABLED`. This field is present only when the key pair is in state `DISABLED`.",
      format: 'google-datetime',
      readOnly: true,
      type: 'string',
    },
    enablementState: {
      description: 'Output only. The current state of the key pair.',
      enum: ['stateUnspecified', 'enabled', 'disabled'],
      readOnly: true,
      type: 'string',
    },
    keyPairId: {
      description: 'Output only. The immutable ID for the client-side encryption S/MIME key pair.',
      readOnly: true,
      type: 'string',
    },
    pem: {
      description:
        'Output only. The public key and its certificate chain, in [PEM](https://en.wikipedia.org/wiki/Privacy-Enhanced_Mail) format.',
      readOnly: true,
      type: 'string',
    },
    pkcs7: {
      description:
        'Input only. The public key and its certificate chain. The chain must be in [PKCS#7](https://en.wikipedia.org/wiki/PKCS_7) format and use PEM encoding and ASCII armor.',
      type: 'string',
    },
    privateKeyMetadata: {
      description: "Metadata for instances of this key pair's private key.",
      items: {
        $ref: '#/components/schemas/CsePrivateKeyMetadata',
      },
      type: 'array',
    },
    subjectEmailAddresses: {
      description: 'Output only. The email address identities that are specified on the leaf certificate.',
      items: {
        type: 'string',
      },
      readOnly: true,
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const CsePrivateKeyMetadataSchema = {
  description: 'Metadata for a private key instance.',
  properties: {
    hardwareKeyMetadata: {
      $ref: '#/components/schemas/HardwareKeyMetadata',
      description: 'Metadata for hardware keys.',
    },
    kaclsKeyMetadata: {
      $ref: '#/components/schemas/KaclsKeyMetadata',
      description: 'Metadata for a private key instance managed by an external key access control list service.',
    },
    privateKeyMetadataId: {
      description: 'Output only. The immutable ID for the private key metadata instance.',
      readOnly: true,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const DelegateSchema = {
  description: `Settings for a delegate. Delegates can read, send, and delete messages, as well as view and add contacts, for the delegator's account. See "Set up mail delegation" for more information about delegates.`,
  properties: {
    delegateEmail: {
      description: 'The email address of the delegate.',
      type: 'string',
    },
    verificationStatus: {
      description:
        'Indicates whether this address has been verified and can act as a delegate for the account. Read-only.',
      enum: ['verificationStatusUnspecified', 'accepted', 'pending', 'rejected', 'expired'],
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const DisableCseKeyPairRequestSchema = {
  description: 'Requests to turn off a client-side encryption key pair.',
  properties: {},
  type: 'object',
} as const;

export const DraftSchema = {
  description: "A draft email in the user's mailbox.",
  properties: {
    id: {
      description: 'The immutable ID of the draft.',
      type: 'string',
    },
    message: {
      $ref: '#/components/schemas/Message',
      description: 'The message content of the draft.',
    },
  },
  type: 'object',
} as const;

export const EnableCseKeyPairRequestSchema = {
  description: 'Requests to turn on a client-side encryption key pair.',
  properties: {},
  type: 'object',
} as const;

export const FilterSchema = {
  description:
    'Resource definition for Gmail filters. Filters apply to specific messages instead of an entire email thread.',
  properties: {
    action: {
      $ref: '#/components/schemas/FilterAction',
      description: 'Action that the filter performs.',
    },
    criteria: {
      $ref: '#/components/schemas/FilterCriteria',
      description: 'Matching criteria for the filter.',
    },
    id: {
      description: 'The server assigned ID of the filter.',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const FilterActionSchema = {
  description: 'A set of actions to perform on a message.',
  properties: {
    addLabelIds: {
      description: 'List of labels to add to the message.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    forward: {
      description: 'Email address that the message should be forwarded to.',
      type: 'string',
    },
    removeLabelIds: {
      description: 'List of labels to remove from the message.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const FilterCriteriaSchema = {
  description: 'Message matching criteria.',
  properties: {
    excludeChats: {
      description: 'Whether the response should exclude chats.',
      type: 'boolean',
    },
    from: {
      description: "The sender's display name or email address.",
      type: 'string',
    },
    hasAttachment: {
      description: 'Whether the message has any attachment.',
      type: 'boolean',
    },
    negatedQuery: {
      description:
        'Only return messages not matching the specified query. Supports the same query format as the Gmail search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`.',
      type: 'string',
    },
    query: {
      description:
        'Only return messages matching the specified query. Supports the same query format as the Gmail search box. For example, `"from:someuser@example.com rfc822msgid: is:unread"`.',
      type: 'string',
    },
    size: {
      description: 'The size of the entire RFC822 message in bytes, including all headers and attachments.',
      format: 'int32',
      type: 'integer',
    },
    sizeComparison: {
      description: 'How the message size in bytes should be in relation to the size field.',
      enum: ['unspecified', 'smaller', 'larger'],
      type: 'string',
    },
    subject: {
      description:
        "Case-insensitive phrase found in the message's subject. Trailing and leading whitespace are be trimmed and adjacent spaces are collapsed.",
      type: 'string',
    },
    to: {
      description: `The recipient's display name or email address. Includes recipients in the "to", "cc", and "bcc" header fields. You can use simply the local part of the email address. For example, "example" and "example@" both match "example@gmail.com". This field is case-insensitive.`,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const ForwardingAddressSchema = {
  description: 'Settings for a forwarding address.',
  properties: {
    forwardingEmail: {
      description: 'An email address to which messages can be forwarded.',
      type: 'string',
    },
    verificationStatus: {
      description: 'Indicates whether this address has been verified and is usable for forwarding. Read-only.',
      enum: ['verificationStatusUnspecified', 'accepted', 'pending'],
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const HardwareKeyMetadataSchema = {
  description: 'Metadata for hardware keys.',
  properties: {
    description: {
      description: 'Description about the hardware key.',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const HistorySchema = {
  description:
    "A record of a change to the user's mailbox. Each history change may affect multiple messages in multiple ways.",
  properties: {
    id: {
      description: 'The mailbox sequence ID.',
      format: 'uint64',
      type: 'string',
    },
    labelsAdded: {
      description: 'Labels added to messages in this history record.',
      items: {
        $ref: '#/components/schemas/HistoryLabelAdded',
      },
      type: 'array',
    },
    labelsRemoved: {
      description: 'Labels removed from messages in this history record.',
      items: {
        $ref: '#/components/schemas/HistoryLabelRemoved',
      },
      type: 'array',
    },
    messages: {
      description:
        'List of messages changed in this history record. The fields for specific change types, such as `messagesAdded` may duplicate messages in this field. We recommend using the specific change-type fields instead of this.',
      items: {
        $ref: '#/components/schemas/Message',
      },
      type: 'array',
    },
    messagesAdded: {
      description: 'Messages added to the mailbox in this history record.',
      items: {
        $ref: '#/components/schemas/HistoryMessageAdded',
      },
      type: 'array',
    },
    messagesDeleted: {
      description: 'Messages deleted (not Trashed) from the mailbox in this history record.',
      items: {
        $ref: '#/components/schemas/HistoryMessageDeleted',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const HistoryLabelAddedSchema = {
  properties: {
    labelIds: {
      description: 'Label IDs added to the message.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    message: {
      $ref: '#/components/schemas/Message',
    },
  },
  type: 'object',
} as const;

export const HistoryLabelRemovedSchema = {
  properties: {
    labelIds: {
      description: 'Label IDs removed from the message.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    message: {
      $ref: '#/components/schemas/Message',
    },
  },
  type: 'object',
} as const;

export const HistoryMessageAddedSchema = {
  properties: {
    message: {
      $ref: '#/components/schemas/Message',
    },
  },
  type: 'object',
} as const;

export const HistoryMessageDeletedSchema = {
  properties: {
    message: {
      $ref: '#/components/schemas/Message',
    },
  },
  type: 'object',
} as const;

export const ImapSettingsSchema = {
  description: 'IMAP settings for an account.',
  properties: {
    autoExpunge: {
      description:
        'If this value is true, Gmail will immediately expunge a message when it is marked as deleted in IMAP. Otherwise, Gmail will wait for an update from the client before expunging messages marked as deleted.',
      type: 'boolean',
    },
    enabled: {
      description: 'Whether IMAP is enabled for the account.',
      type: 'boolean',
    },
    expungeBehavior: {
      description:
        'The action that will be executed on a message when it is marked as deleted and expunged from the last visible IMAP folder.',
      enum: ['expungeBehaviorUnspecified', 'archive', 'trash', 'deleteForever'],
      type: 'string',
    },
    maxFolderSize: {
      description:
        'An optional limit on the number of messages that an IMAP folder may contain. Legal values are 0, 1000, 2000, 5000 or 10000. A value of zero is interpreted to mean that there is no limit.',
      format: 'int32',
      type: 'integer',
    },
  },
  type: 'object',
} as const;

export const KaclsKeyMetadataSchema = {
  description:
    'Metadata for private keys managed by an external key access control list service. For details about managing key access, see [Google Workspace CSE API Reference](https://developers.google.com/workspace/cse/reference).',
  properties: {
    kaclsData: {
      description: 'Opaque data generated and used by the key access control list service. Maximum size: 8 KiB.',
      type: 'string',
    },
    kaclsUri: {
      description: 'The URI of the key access control list service that manages the private key.',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const LabelSchema = {
  description:
    "Labels are used to categorize messages and threads within the user's mailbox. The maximum number of labels supported for a user's mailbox is 10,000.",
  properties: {
    color: {
      $ref: '#/components/schemas/LabelColor',
      description:
        'The color to assign to the label. Color is only available for labels that have their `type` set to `user`.',
    },
    id: {
      description: 'The immutable ID of the label.',
      type: 'string',
    },
    labelListVisibility: {
      description: 'The visibility of the label in the label list in the Gmail web interface.',
      enum: ['labelShow', 'labelShowIfUnread', 'labelHide'],
      type: 'string',
    },
    messageListVisibility: {
      description: 'The visibility of messages with this label in the message list in the Gmail web interface.',
      enum: ['show', 'hide'],
      type: 'string',
    },
    messagesTotal: {
      description: 'The total number of messages with the label.',
      format: 'int32',
      type: 'integer',
    },
    messagesUnread: {
      description: 'The number of unread messages with the label.',
      format: 'int32',
      type: 'integer',
    },
    name: {
      description: 'The display name of the label.',
      type: 'string',
    },
    threadsTotal: {
      description: 'The total number of threads with the label.',
      format: 'int32',
      type: 'integer',
    },
    threadsUnread: {
      description: 'The number of unread threads with the label.',
      format: 'int32',
      type: 'integer',
    },
    type: {
      description:
        'The owner type for the label. User labels are created by the user and can be modified and deleted by the user and can be applied to any message or thread. System labels are internally created and cannot be added, modified, or deleted. System labels may be able to be applied to or removed from messages and threads under some circumstances but this is not guaranteed. For example, users can apply and remove the `INBOX` and `UNREAD` labels from messages and threads, but cannot apply or remove the `DRAFTS` or `SENT` labels from messages or threads.',
      enum: ['system', 'user'],
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const LabelColorSchema = {
  properties: {
    backgroundColor: {
      description:
        'The background color represented as hex string #RRGGBB (ex #000000). This field is required in order to set the color of a label. Only the following predefined set of color values are allowed: \\#000000, #434343, #666666, #999999, #cccccc, #efefef, #f3f3f3, #ffffff, \\#fb4c2f, #ffad47, #fad165, #16a766, #43d692, #4a86e8, #a479e2, #f691b3, \\#f6c5be, #ffe6c7, #fef1d1, #b9e4d0, #c6f3de, #c9daf8, #e4d7f5, #fcdee8, \\#efa093, #ffd6a2, #fce8b3, #89d3b2, #a0eac9, #a4c2f4, #d0bcf1, #fbc8d9, \\#e66550, #ffbc6b, #fcda83, #44b984, #68dfa9, #6d9eeb, #b694e8, #f7a7c0, \\#cc3a21, #eaa041, #f2c960, #149e60, #3dc789, #3c78d8, #8e63ce, #e07798, \\#ac2b16, #cf8933, #d5ae49, #0b804b, #2a9c68, #285bac, #653e9b, #b65775, \\#822111, #a46a21, #aa8831, #076239, #1a764d, #1c4587, #41236d, #83334c \\#464646, #e7e7e7, #0d3472, #b6cff5, #0d3b44, #98d7e4, #3d188e, #e3d7ff, \\#711a36, #fbd3e0, #8a1c0a, #f2b2a8, #7a2e0b, #ffc8af, #7a4706, #ffdeb5, \\#594c05, #fbe983, #684e07, #fdedc1, #0b4f30, #b3efd3, #04502e, #a2dcc1, \\#c2c2c2, #4986e7, #2da2bb, #b99aff, #994a64, #f691b2, #ff7537, #ffad46, \\#662e37, #ebdbde, #cca6ac, #094228, #42d692, #16a765',
      type: 'string',
    },
    textColor: {
      description:
        'The text color of the label, represented as hex string. This field is required in order to set the color of a label. Only the following predefined set of color values are allowed: \\#000000, #434343, #666666, #999999, #cccccc, #efefef, #f3f3f3, #ffffff, \\#fb4c2f, #ffad47, #fad165, #16a766, #43d692, #4a86e8, #a479e2, #f691b3, \\#f6c5be, #ffe6c7, #fef1d1, #b9e4d0, #c6f3de, #c9daf8, #e4d7f5, #fcdee8, \\#efa093, #ffd6a2, #fce8b3, #89d3b2, #a0eac9, #a4c2f4, #d0bcf1, #fbc8d9, \\#e66550, #ffbc6b, #fcda83, #44b984, #68dfa9, #6d9eeb, #b694e8, #f7a7c0, \\#cc3a21, #eaa041, #f2c960, #149e60, #3dc789, #3c78d8, #8e63ce, #e07798, \\#ac2b16, #cf8933, #d5ae49, #0b804b, #2a9c68, #285bac, #653e9b, #b65775, \\#822111, #a46a21, #aa8831, #076239, #1a764d, #1c4587, #41236d, #83334c \\#464646, #e7e7e7, #0d3472, #b6cff5, #0d3b44, #98d7e4, #3d188e, #e3d7ff, \\#711a36, #fbd3e0, #8a1c0a, #f2b2a8, #7a2e0b, #ffc8af, #7a4706, #ffdeb5, \\#594c05, #fbe983, #684e07, #fdedc1, #0b4f30, #b3efd3, #04502e, #a2dcc1, \\#c2c2c2, #4986e7, #2da2bb, #b99aff, #994a64, #f691b2, #ff7537, #ffad46, \\#662e37, #ebdbde, #cca6ac, #094228, #42d692, #16a765',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const LanguageSettingsSchema = {
  description:
    'Language settings for an account. These settings correspond to the "Language settings" feature in the web interface.',
  properties: {
    displayLanguage: {
      description: `The language to display Gmail in, formatted as an RFC 3066 Language Tag (for example \`en-GB\`, \`fr\` or \`ja\` for British English, French, or Japanese respectively). The set of languages supported by Gmail evolves over time, so please refer to the "Language" dropdown in the Gmail settings for all available options, as described in the language settings help article. A table of sample values is also provided in the Managing Language Settings guide Not all Gmail clients can display the same set of languages. In the case that a user's display language is not available for use on a particular client, said client automatically chooses to display in the closest supported variant (or a reasonable default).`,
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const ListCseIdentitiesResponseSchema = {
  properties: {
    cseIdentities: {
      description: 'One page of the list of CSE identities configured for the user.',
      items: {
        $ref: '#/components/schemas/CseIdentity',
      },
      type: 'array',
    },
    nextPageToken: {
      description:
        'Pagination token to be passed to a subsequent ListCseIdentities call in order to retrieve the next page of identities. If this value is not returned or is the empty string, then no further pages remain.',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const ListCseKeyPairsResponseSchema = {
  properties: {
    cseKeyPairs: {
      description: 'One page of the list of CSE key pairs installed for the user.',
      items: {
        $ref: '#/components/schemas/CseKeyPair',
      },
      type: 'array',
    },
    nextPageToken: {
      description:
        'Pagination token to be passed to a subsequent ListCseKeyPairs call in order to retrieve the next page of key pairs. If this value is not returned, then no further pages remain.',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const ListDelegatesResponseSchema = {
  description: 'Response for the ListDelegates method.',
  properties: {
    delegates: {
      description:
        "List of the user's delegates (with any verification status). If an account doesn't have delegates, this field doesn't appear.",
      items: {
        $ref: '#/components/schemas/Delegate',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const ListDraftsResponseSchema = {
  properties: {
    drafts: {
      description:
        'List of drafts. Note that the `Message` property in each `Draft` resource only contains an `id` and a `threadId`. The messages.get method can fetch additional message details.',
      items: {
        $ref: '#/components/schemas/Draft',
      },
      type: 'array',
    },
    nextPageToken: {
      description: 'Token to retrieve the next page of results in the list.',
      type: 'string',
    },
    resultSizeEstimate: {
      description: 'Estimated total number of results.',
      format: 'uint32',
      type: 'integer',
    },
  },
  type: 'object',
} as const;

export const ListFiltersResponseSchema = {
  description: 'Response for the ListFilters method.',
  properties: {
    filter: {
      description: "List of a user's filters.",
      items: {
        $ref: '#/components/schemas/Filter',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const ListForwardingAddressesResponseSchema = {
  description: 'Response for the ListForwardingAddresses method.',
  properties: {
    forwardingAddresses: {
      description: 'List of addresses that may be used for forwarding.',
      items: {
        $ref: '#/components/schemas/ForwardingAddress',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const ListHistoryResponseSchema = {
  properties: {
    history: {
      description:
        'List of history records. Any `messages` contained in the response will typically only have `id` and `threadId` fields populated.',
      items: {
        $ref: '#/components/schemas/History',
      },
      type: 'array',
    },
    historyId: {
      description: "The ID of the mailbox's current history record.",
      format: 'uint64',
      type: 'string',
    },
    nextPageToken: {
      description: 'Page token to retrieve the next page of results in the list.',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const ListLabelsResponseSchema = {
  properties: {
    labels: {
      description:
        'List of labels. Note that each label resource only contains an `id`, `name`, `messageListVisibility`, `labelListVisibility`, and `type`. The labels.get method can fetch additional label details.',
      items: {
        $ref: '#/components/schemas/Label',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const ListMessagesResponseSchema = {
  properties: {
    messages: {
      description:
        'List of messages. Note that each message resource contains only an `id` and a `threadId`. Additional message details can be fetched using the messages.get method.',
      items: {
        $ref: '#/components/schemas/Message',
      },
      type: 'array',
    },
    nextPageToken: {
      description: 'Token to retrieve the next page of results in the list.',
      type: 'string',
    },
    resultSizeEstimate: {
      description: 'Estimated total number of results.',
      format: 'uint32',
      type: 'integer',
    },
  },
  type: 'object',
} as const;

export const ListSendAsResponseSchema = {
  description: 'Response for the ListSendAs method.',
  properties: {
    sendAs: {
      description: 'List of send-as aliases.',
      items: {
        $ref: '#/components/schemas/SendAs',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const ListSmimeInfoResponseSchema = {
  properties: {
    smimeInfo: {
      description: 'List of SmimeInfo.',
      items: {
        $ref: '#/components/schemas/SmimeInfo',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const ListThreadsResponseSchema = {
  properties: {
    nextPageToken: {
      description: 'Page token to retrieve the next page of results in the list.',
      type: 'string',
    },
    resultSizeEstimate: {
      description: 'Estimated total number of results.',
      format: 'uint32',
      type: 'integer',
    },
    threads: {
      description:
        'List of threads. Note that each thread resource does not contain a list of `messages`. The list of `messages` for a given thread can be fetched using the threads.get method.',
      items: {
        $ref: '#/components/schemas/Thread',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const MessageSchema = {
  description: 'An email message.',
  properties: {
    historyId: {
      description: 'The ID of the last history record that modified this message.',
      format: 'uint64',
      type: 'string',
    },
    id: {
      description: 'The immutable ID of the message.',
      type: 'string',
    },
    internalDate: {
      description:
        'The internal message creation timestamp (epoch ms), which determines ordering in the inbox. For normal SMTP-received email, this represents the time the message was originally accepted by Google, which is more reliable than the `Date` header. However, for API-migrated mail, it can be configured by client to be based on the `Date` header.',
      format: 'int64',
      type: 'string',
    },
    labelIds: {
      description: 'List of IDs of labels applied to this message.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    payload: {
      $ref: '#/components/schemas/MessagePart',
      description: 'The parsed email structure in the message parts.',
    },
    raw: {
      description:
        'The entire email message in an RFC 2822 formatted and base64url encoded string. Returned in `messages.get` and `drafts.get` responses when the `format=RAW` parameter is supplied.',
      format: 'byte',
      type: 'string',
    },
    sizeEstimate: {
      description: 'Estimated size in bytes of the message.',
      format: 'int32',
      type: 'integer',
    },
    snippet: {
      description: 'A short part of the message text.',
      type: 'string',
    },
    threadId: {
      description:
        'The ID of the thread the message belongs to. To add a message or draft to a thread, the following criteria must be met: 1. The requested `threadId` must be specified on the `Message` or `Draft.Message` you supply with your request. 2. The `References` and `In-Reply-To` headers must be set in compliance with the [RFC 2822](https://tools.ietf.org/html/rfc2822) standard. 3. The `Subject` headers must match. ',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const MessagePartSchema = {
  description: 'A single MIME message part.',
  properties: {
    body: {
      $ref: '#/components/schemas/MessagePartBody',
      description: 'The message part body for this part, which may be empty for container MIME message parts.',
    },
    filename: {
      description: 'The filename of the attachment. Only present if this message part represents an attachment.',
      type: 'string',
    },
    headers: {
      description:
        'List of headers on this message part. For the top-level message part, representing the entire message payload, it will contain the standard RFC 2822 email headers such as `To`, `From`, and `Subject`.',
      items: {
        $ref: '#/components/schemas/MessagePartHeader',
      },
      type: 'array',
    },
    mimeType: {
      description: 'The MIME type of the message part.',
      type: 'string',
    },
    partId: {
      description: 'The immutable ID of the message part.',
      type: 'string',
    },
    parts: {
      description:
        'The child MIME message parts of this part. This only applies to container MIME message parts, for example `multipart/*`. For non- container MIME message part types, such as `text/plain`, this field is empty. For more information, see RFC 1521.',
      items: {
        $ref: '#/components/schemas/MessagePart',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const MessagePartBodySchema = {
  description: 'The body of a single MIME message part.',
  properties: {
    attachmentId: {
      description:
        'When present, contains the ID of an external attachment that can be retrieved in a separate `messages.attachments.get` request. When not present, the entire content of the message part body is contained in the data field.',
      type: 'string',
    },
    data: {
      description:
        'The body data of a MIME message part as a base64url encoded string. May be empty for MIME container types that have no message body or when the body data is sent as a separate attachment. An attachment ID is present if the body data is contained in a separate attachment.',
      format: 'byte',
      type: 'string',
    },
    size: {
      description: 'Number of bytes for the message part data (encoding notwithstanding).',
      format: 'int32',
      type: 'integer',
    },
  },
  type: 'object',
} as const;

export const MessagePartHeaderSchema = {
  properties: {
    name: {
      description: 'The name of the header before the `:` separator. For example, `To`.',
      type: 'string',
    },
    value: {
      description: 'The value of the header after the `:` separator. For example, `someuser@example.com`.',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const ModifyMessageRequestSchema = {
  properties: {
    addLabelIds: {
      description: 'A list of IDs of labels to add to this message. You can add up to 100 labels with each update.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    removeLabelIds: {
      description:
        'A list IDs of labels to remove from this message. You can remove up to 100 labels with each update.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const ModifyThreadRequestSchema = {
  properties: {
    addLabelIds: {
      description: 'A list of IDs of labels to add to this thread. You can add up to 100 labels with each update.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    removeLabelIds: {
      description:
        'A list of IDs of labels to remove from this thread. You can remove up to 100 labels with each update.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
  },
  type: 'object',
} as const;

export const ObliterateCseKeyPairRequestSchema = {
  description: 'Request to obliterate a CSE key pair.',
  properties: {},
  type: 'object',
} as const;

export const PopSettingsSchema = {
  description: 'POP settings for an account.',
  properties: {
    accessWindow: {
      description: 'The range of messages which are accessible via POP.',
      enum: ['accessWindowUnspecified', 'disabled', 'fromNowOn', 'allMail'],
      type: 'string',
    },
    disposition: {
      description: 'The action that will be executed on a message after it has been fetched via POP.',
      enum: ['dispositionUnspecified', 'leaveInInbox', 'archive', 'trash', 'markRead'],
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const ProfileSchema = {
  description: 'Profile for a Gmail user.',
  properties: {
    emailAddress: {
      description: "The user's email address.",
      type: 'string',
    },
    historyId: {
      description: "The ID of the mailbox's current history record.",
      format: 'uint64',
      type: 'string',
    },
    messagesTotal: {
      description: 'The total number of messages in the mailbox.',
      format: 'int32',
      type: 'integer',
    },
    threadsTotal: {
      description: 'The total number of threads in the mailbox.',
      format: 'int32',
      type: 'integer',
    },
  },
  type: 'object',
} as const;

export const SendAsSchema = {
  description:
    'Settings associated with a send-as alias, which can be either the primary login address associated with the account or a custom "from" address. Send-as aliases correspond to the "Send Mail As" feature in the web interface.',
  properties: {
    displayName: {
      description:
        'A name that appears in the "From:" header for mail sent using this alias. For custom "from" addresses, when this is empty, Gmail will populate the "From:" header with the name that is used for the primary address associated with the account. If the admin has disabled the ability for users to update their name format, requests to update this field for the primary login will silently fail.',
      type: 'string',
    },
    isDefault: {
      description:
        'Whether this address is selected as the default "From:" address in situations such as composing a new message or sending a vacation auto-reply. Every Gmail account has exactly one default send-as address, so the only legal value that clients may write to this field is `true`. Changing this from `false` to `true` for an address will result in this field becoming `false` for the other previous default address.',
      type: 'boolean',
    },
    isPrimary: {
      description:
        'Whether this address is the primary address used to login to the account. Every Gmail account has exactly one primary address, and it cannot be deleted from the collection of send-as aliases. This field is read-only.',
      type: 'boolean',
    },
    replyToAddress: {
      description:
        'An optional email address that is included in a "Reply-To:" header for mail sent using this alias. If this is empty, Gmail will not generate a "Reply-To:" header.',
      type: 'string',
    },
    sendAsEmail: {
      description:
        'The email address that appears in the "From:" header for mail sent using this alias. This is read-only for all operations except create.',
      type: 'string',
    },
    signature: {
      description:
        'An optional HTML signature that is included in messages composed with this alias in the Gmail web UI. This signature is added to new emails only.',
      type: 'string',
    },
    smtpMsa: {
      $ref: '#/components/schemas/SmtpMsa',
      description: `An optional SMTP service that will be used as an outbound relay for mail sent using this alias. If this is empty, outbound mail will be sent directly from Gmail's servers to the destination SMTP service. This setting only applies to custom "from" aliases.`,
    },
    treatAsAlias: {
      description: `Whether Gmail should treat this address as an alias for the user's primary email address. This setting only applies to custom "from" aliases.`,
      type: 'boolean',
    },
    verificationStatus: {
      description:
        'Indicates whether this address has been verified for use as a send-as alias. Read-only. This setting only applies to custom "from" aliases.',
      enum: ['verificationStatusUnspecified', 'accepted', 'pending'],
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const SignAndEncryptKeyPairsSchema = {
  description: 'The configuration of a CSE identity that uses different key pairs for signing and encryption.',
  properties: {
    encryptionKeyPairId: {
      description: 'The ID of the CseKeyPair that encrypts signed outgoing mail.',
      type: 'string',
    },
    signingKeyPairId: {
      description: 'The ID of the CseKeyPair that signs outgoing mail.',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const SmimeInfoSchema = {
  description: 'An S/MIME email config.',
  properties: {
    encryptedKeyPassword: {
      description: 'Encrypted key password, when key is encrypted.',
      type: 'string',
    },
    expiration: {
      description: 'When the certificate expires (in milliseconds since epoch).',
      format: 'int64',
      type: 'string',
    },
    id: {
      description: 'The immutable ID for the SmimeInfo.',
      type: 'string',
    },
    isDefault: {
      description: "Whether this SmimeInfo is the default one for this user's send-as address.",
      type: 'boolean',
    },
    issuerCn: {
      description: "The S/MIME certificate issuer's common name.",
      type: 'string',
    },
    pem: {
      description:
        'PEM formatted X509 concatenated certificate string (standard base64 encoding). Format used for returning key, which includes public key as well as certificate chain (not private key).',
      type: 'string',
    },
    pkcs12: {
      description:
        'PKCS#12 format containing a single private/public key pair and certificate chain. This format is only accepted from client for creating a new SmimeInfo and is never returned, because the private key is not intended to be exported. PKCS#12 may be encrypted, in which case encryptedKeyPassword should be set appropriately.',
      format: 'byte',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const SmtpMsaSchema = {
  description: 'Configuration for communication with an SMTP service.',
  properties: {
    host: {
      description: 'The hostname of the SMTP service. Required.',
      type: 'string',
    },
    password: {
      description:
        'The password that will be used for authentication with the SMTP service. This is a write-only field that can be specified in requests to create or update SendAs settings; it is never populated in responses.',
      type: 'string',
    },
    port: {
      description: 'The port of the SMTP service. Required.',
      format: 'int32',
      type: 'integer',
    },
    securityMode: {
      description: 'The protocol that will be used to secure communication with the SMTP service. Required.',
      enum: ['securityModeUnspecified', 'none', 'ssl', 'starttls'],
      type: 'string',
    },
    username: {
      description:
        'The username that will be used for authentication with the SMTP service. This is a write-only field that can be specified in requests to create or update SendAs settings; it is never populated in responses.',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const ThreadSchema = {
  description: 'A collection of messages representing a conversation.',
  properties: {
    historyId: {
      description: 'The ID of the last history record that modified this thread.',
      format: 'uint64',
      type: 'string',
    },
    id: {
      description: 'The unique ID of the thread.',
      type: 'string',
    },
    messages: {
      description: 'The list of messages in the thread.',
      items: {
        $ref: '#/components/schemas/Message',
      },
      type: 'array',
    },
    snippet: {
      description: 'A short part of the message text.',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const VacationSettingsSchema = {
  description:
    'Vacation auto-reply settings for an account. These settings correspond to the "Vacation responder" feature in the web interface.',
  properties: {
    enableAutoReply: {
      description: 'Flag that controls whether Gmail automatically replies to messages.',
      type: 'boolean',
    },
    endTime: {
      description:
        'An optional end time for sending auto-replies (epoch ms). When this is specified, Gmail will automatically reply only to messages that it receives before the end time. If both `startTime` and `endTime` are specified, `startTime` must precede `endTime`.',
      format: 'int64',
      type: 'string',
    },
    responseBodyHtml: {
      description:
        'Response body in HTML format. Gmail will sanitize the HTML before storing it. If both `response_body_plain_text` and `response_body_html` are specified, `response_body_html` will be used.',
      type: 'string',
    },
    responseBodyPlainText: {
      description:
        'Response body in plain text format. If both `response_body_plain_text` and `response_body_html` are specified, `response_body_html` will be used.',
      type: 'string',
    },
    responseSubject: {
      description:
        'Optional text to prepend to the subject line in vacation responses. In order to enable auto-replies, either the response subject or the response body must be nonempty.',
      type: 'string',
    },
    restrictToContacts: {
      description:
        "Flag that determines whether responses are sent to recipients who are not in the user's list of contacts.",
      type: 'boolean',
    },
    restrictToDomain: {
      description:
        "Flag that determines whether responses are sent to recipients who are outside of the user's domain. This feature is only available for Google Workspace users.",
      type: 'boolean',
    },
    startTime: {
      description:
        'An optional start time for sending auto-replies (epoch ms). When this is specified, Gmail will automatically reply only to messages that it receives after the start time. If both `startTime` and `endTime` are specified, `startTime` must precede `endTime`.',
      format: 'int64',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const WatchRequestSchema = {
  description: "Set up or update a new push notification watch on this user's mailbox.",
  properties: {
    labelFilterAction: {
      deprecated: true,
      description:
        'Filtering behavior of `labelIds list` specified. This field is deprecated because it caused incorrect behavior in some cases; use `label_filter_behavior` instead.',
      enum: ['include', 'exclude'],
      type: 'string',
    },
    labelFilterBehavior: {
      description:
        'Filtering behavior of `labelIds list` specified. This field replaces `label_filter_action`; if set, `label_filter_action` is ignored.',
      enum: ['include', 'exclude'],
      type: 'string',
    },
    labelIds: {
      description:
        'List of label_ids to restrict notifications about. By default, if unspecified, all changes are pushed out. If specified then dictates which labels are required for a push notification to be generated.',
      items: {
        type: 'string',
      },
      type: 'array',
    },
    topicName: {
      description:
        'A fully qualified Google Cloud Pub/Sub API topic name to publish the events to. This topic name **must** already exist in Cloud Pub/Sub and you **must** have already granted gmail "publish" permission on it. For example, "projects/my-project-identifier/topics/my-topic-name" (using the Cloud Pub/Sub "v1" topic naming format). Note that the "my-project-identifier" portion must exactly match your Google developer project id (the one executing this watch request).',
      type: 'string',
    },
  },
  type: 'object',
} as const;

export const WatchResponseSchema = {
  description: 'Push notification watch response.',
  properties: {
    expiration: {
      description:
        'When Gmail will stop sending notifications for mailbox updates (epoch millis). Call `watch` again before this time to renew the watch.',
      format: 'int64',
      type: 'string',
    },
    historyId: {
      description: "The ID of the mailbox's current history record.",
      format: 'uint64',
      type: 'string',
    },
  },
  type: 'object',
} as const;
