// Generated by ts-to-zod
import { z } from 'zod';

export const userSchema = z.object({
  displayName: z.string().optional(),
  emailAddress: z.string().optional(),
  kind: z.string().optional(),
  me: z.boolean().optional(),
  permissionId: z.string().optional(),
  photoLink: z.string().optional(),
});

export const appIconsSchema = z.object({
  category: z.string().optional(),
  iconUrl: z.string().optional(),
  size: z.number().optional(),
});

export const appSchema = z.object({
  authorized: z.boolean().optional(),
  createInFolderTemplate: z.string().optional(),
  createUrl: z.string().optional(),
  hasDriveWideScope: z.boolean().optional(),
  icons: z.array(appIconsSchema).optional(),
  id: z.string().optional(),
  installed: z.boolean().optional(),
  kind: z.string().optional(),
  longDescription: z.string().optional(),
  name: z.string().optional(),
  objectType: z.string().optional(),
  openUrlTemplate: z.string().optional(),
  primaryFileExtensions: z.array(z.string()).optional(),
  primaryMimeTypes: z.array(z.string()).optional(),
  productId: z.string().optional(),
  productUrl: z.string().optional(),
  secondaryFileExtensions: z.array(z.string()).optional(),
  secondaryMimeTypes: z.array(z.string()).optional(),
  shortDescription: z.string().optional(),
  supportsCreate: z.boolean().optional(),
  supportsImport: z.boolean().optional(),
  supportsMultiOpen: z.boolean().optional(),
  supportsOfflineCreate: z.boolean().optional(),
  useByDefault: z.boolean().optional(),
});

export const driveSchema = z.object({
  backgroundImageFile: z
    .object({
      id: z.string().optional(),
      width: z.number().optional(),
      xCoordinate: z.number().optional(),
      yCoordinate: z.number().optional(),
    })
    .optional(),
  backgroundImageLink: z.string().optional(),
  capabilities: z
    .object({
      canAddChildren: z.boolean().optional(),
      canChangeCopyRequiresWriterPermissionRestriction: z.boolean().optional(),
      canChangeDomainUsersOnlyRestriction: z.boolean().optional(),
      canChangeDriveBackground: z.boolean().optional(),
      canChangeDriveMembersOnlyRestriction: z.boolean().optional(),
      canChangeSharingFoldersRequiresOrganizerPermissionRestriction: z.boolean().optional(),
      canComment: z.boolean().optional(),
      canCopy: z.boolean().optional(),
      canDeleteChildren: z.boolean().optional(),
      canDeleteDrive: z.boolean().optional(),
      canDownload: z.boolean().optional(),
      canEdit: z.boolean().optional(),
      canListChildren: z.boolean().optional(),
      canManageMembers: z.boolean().optional(),
      canReadRevisions: z.boolean().optional(),
      canRename: z.boolean().optional(),
      canRenameDrive: z.boolean().optional(),
      canResetDriveRestrictions: z.boolean().optional(),
      canShare: z.boolean().optional(),
      canTrashChildren: z.boolean().optional(),
    })
    .optional(),
  colorRgb: z.string().optional(),
  createdTime: z.string().optional(),
  hidden: z.boolean().optional(),
  id: z.string().optional(),
  kind: z.string().optional(),
  name: z.string().optional(),
  orgUnitId: z.string().optional(),
  restrictions: z
    .object({
      adminManagedRestrictions: z.boolean().optional(),
      copyRequiresWriterPermission: z.boolean().optional(),
      domainUsersOnly: z.boolean().optional(),
      driveMembersOnly: z.boolean().optional(),
      sharingFoldersRequiresOrganizerPermission: z.boolean().optional(),
    })
    .optional(),
  themeId: z.string().optional(),
});

export const teamDriveSchema = z.object({
  backgroundImageFile: z
    .object({
      id: z.string().optional(),
      width: z.number().optional(),
      xCoordinate: z.number().optional(),
      yCoordinate: z.number().optional(),
    })
    .optional(),
  backgroundImageLink: z.string().optional(),
  capabilities: z
    .object({
      canAddChildren: z.boolean().optional(),
      canChangeCopyRequiresWriterPermissionRestriction: z.boolean().optional(),
      canChangeDomainUsersOnlyRestriction: z.boolean().optional(),
      canChangeSharingFoldersRequiresOrganizerPermissionRestriction: z.boolean().optional(),
      canChangeTeamDriveBackground: z.boolean().optional(),
      canChangeTeamMembersOnlyRestriction: z.boolean().optional(),
      canComment: z.boolean().optional(),
      canCopy: z.boolean().optional(),
      canDeleteChildren: z.boolean().optional(),
      canDeleteTeamDrive: z.boolean().optional(),
      canDownload: z.boolean().optional(),
      canEdit: z.boolean().optional(),
      canListChildren: z.boolean().optional(),
      canManageMembers: z.boolean().optional(),
      canReadRevisions: z.boolean().optional(),
      canRemoveChildren: z.boolean().optional(),
      canRename: z.boolean().optional(),
      canRenameTeamDrive: z.boolean().optional(),
      canResetTeamDriveRestrictions: z.boolean().optional(),
      canShare: z.boolean().optional(),
      canTrashChildren: z.boolean().optional(),
    })
    .optional(),
  colorRgb: z.string().optional(),
  createdTime: z.string().optional(),
  id: z.string().optional(),
  kind: z.string().optional(),
  name: z.string().optional(),
  orgUnitId: z.string().optional(),
  restrictions: z
    .object({
      adminManagedRestrictions: z.boolean().optional(),
      copyRequiresWriterPermission: z.boolean().optional(),
      domainUsersOnly: z.boolean().optional(),
      sharingFoldersRequiresOrganizerPermission: z.boolean().optional(),
      teamMembersOnly: z.boolean().optional(),
    })
    .optional(),
  themeId: z.string().optional(),
});

export const channelSchema = z.object({
  address: z.string().optional(),
  expiration: z.string().optional(),
  id: z.string().optional(),
  kind: z.string().optional(),
  params: z.record(z.string()).optional(),
  payload: z.boolean().optional(),
  resourceId: z.string().optional(),
  resourceUri: z.string().optional(),
  token: z.string().optional(),
  type: z.string().optional(),
});

export const replySchema = z.object({
  action: z.string().optional(),
  author: userSchema.optional(),
  content: z.string().optional(),
  createdTime: z.string().optional(),
  deleted: z.boolean().optional(),
  htmlContent: z.string().optional(),
  id: z.string().optional(),
  kind: z.string().optional(),
  modifiedTime: z.string().optional(),
});

export const commentSchema = z.object({
  anchor: z.string().optional(),
  author: userSchema.optional(),
  content: z.string().optional(),
  createdTime: z.string().optional(),
  deleted: z.boolean().optional(),
  htmlContent: z.string().optional(),
  id: z.string().optional(),
  kind: z.string().optional(),
  modifiedTime: z.string().optional(),
  quotedFileContent: z
    .object({
      mimeType: z.string().optional(),
      value: z.string().optional(),
    })
    .optional(),
  replies: z.array(replySchema).optional(),
  resolved: z.boolean().optional(),
});

export const contentRestrictionSchema = z.object({
  ownerRestricted: z.boolean().optional(),
  readOnly: z.boolean().optional(),
  reason: z.string().optional(),
  restrictingUser: userSchema.optional(),
  restrictionTime: z.string().optional(),
  systemRestricted: z.boolean().optional(),
  type: z.string().optional(),
});

export const driveListSchema = z.object({
  drives: z.array(driveSchema).optional(),
  kind: z.string().optional(),
  nextPageToken: z.string().optional(),
});

export const permissionSchema = z.object({
  allowFileDiscovery: z.boolean().optional(),
  deleted: z.boolean().optional(),
  displayName: z.string().optional(),
  domain: z.string().optional(),
  emailAddress: z.string().optional(),
  expirationTime: z.string().optional(),
  id: z.string().optional(),
  kind: z.string().optional(),
  pendingOwner: z.boolean().optional(),
  permissionDetails: z
    .array(
      z.object({
        inherited: z.boolean().optional(),
        inheritedFrom: z.string().optional(),
        permissionType: z.string().optional(),
        role: z.string().optional(),
      }),
    )
    .optional(),
  photoLink: z.string().optional(),
  role: z.string().optional(),
  teamDrivePermissionDetails: z
    .array(
      z.object({
        inherited: z.boolean().optional(),
        inheritedFrom: z.string().optional(),
        role: z.string().optional(),
        teamDrivePermissionType: z.string().optional(),
      }),
    )
    .optional(),
  type: z.string().optional(),
  view: z.string().optional(),
});

export const generatedIdsSchema = z.object({
  ids: z.array(z.string()).optional(),
  kind: z.string().optional(),
  space: z.string().optional(),
});

export const labelFieldSchema = z.object({
  dateString: z.array(z.string()).optional(),
  id: z.string().optional(),
  integer: z.array(z.string()).optional(),
  kind: z.string().optional(),
  selection: z.array(z.string()).optional(),
  text: z.array(z.string()).optional(),
  user: z.array(userSchema).optional(),
  valueType: z.string().optional(),
});

export const labelFieldModificationSchema = z.object({
  fieldId: z.string().optional(),
  kind: z.string().optional(),
  setDateValues: z.array(z.string()).optional(),
  setIntegerValues: z.array(z.string()).optional(),
  setSelectionValues: z.array(z.string()).optional(),
  setTextValues: z.array(z.string()).optional(),
  setUserValues: z.array(z.string()).optional(),
  unsetValues: z.boolean().optional(),
});

export const labelSchema = z.object({
  fields: z.record(labelFieldSchema).optional(),
  id: z.string().optional(),
  kind: z.string().optional(),
  revisionId: z.string().optional(),
});

export const labelModificationSchema = z.object({
  fieldModifications: z.array(labelFieldModificationSchema).optional(),
  kind: z.string().optional(),
  labelId: z.string().optional(),
  removeLabel: z.boolean().optional(),
});

export const modifyLabelsRequestSchema = z.object({
  kind: z.string().optional(),
  labelModifications: z.array(labelModificationSchema).optional(),
});

export const modifyLabelsResponseSchema = z.object({
  kind: z.string().optional(),
  modifiedLabels: z.array(labelSchema).optional(),
});

export const permissionListSchema = z.object({
  kind: z.string().optional(),
  nextPageToken: z.string().optional(),
  permissions: z.array(permissionSchema).optional(),
});

export const replyListSchema = z.object({
  kind: z.string().optional(),
  nextPageToken: z.string().optional(),
  replies: z.array(replySchema).optional(),
});

export const revisionSchema = z.object({
  exportLinks: z.record(z.string()).optional(),
  id: z.string().optional(),
  keepForever: z.boolean().optional(),
  kind: z.string().optional(),
  lastModifyingUser: userSchema.optional(),
  md5Checksum: z.string().optional(),
  mimeType: z.string().optional(),
  modifiedTime: z.string().optional(),
  originalFilename: z.string().optional(),
  publishAuto: z.boolean().optional(),
  published: z.boolean().optional(),
  publishedLink: z.string().optional(),
  publishedOutsideDomain: z.boolean().optional(),
  size: z.string().optional(),
});

export const revisionListSchema = z.object({
  kind: z.string().optional(),
  nextPageToken: z.string().optional(),
  revisions: z.array(revisionSchema).optional(),
});

export const startPageTokenSchema = z.object({
  kind: z.string().optional(),
  startPageToken: z.string().optional(),
});

export const teamDriveListSchema = z.object({
  kind: z.string().optional(),
  nextPageToken: z.string().optional(),
  teamDrives: z.array(teamDriveSchema).optional(),
});

export const parameterXgafvSchema = z.union([z.literal('1'), z.literal('2')]);

export const parameteraccessTokenSchema = z.string();

export const parameteraltSchema = z.union([z.literal('json'), z.literal('media'), z.literal('proto')]);

export const parametercallbackSchema = z.string();

export const parameterfieldsSchema = z.string();

export const parameterkeySchema = z.string();

export const parameteroauthTokenSchema = z.string();

export const parameterprettyPrintSchema = z.boolean();

export const parameterquotaUserSchema = z.string();

export const parameteruploadTypeSchema = z.string();

export const parameteruploadProtocolSchema = z.string();

export const driveAboutGetDataSchema = z.object({
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const aboutSchema = z.object({
  appInstalled: z.boolean().optional(),
  canCreateDrives: z.boolean().optional(),
  canCreateTeamDrives: z.boolean().optional(),
  driveThemes: z
    .array(
      z.object({
        backgroundImageLink: z.string().optional(),
        colorRgb: z.string().optional(),
        id: z.string().optional(),
      }),
    )
    .optional(),
  exportFormats: z.record(z.array(z.string())).optional(),
  folderColorPalette: z.array(z.string()).optional(),
  importFormats: z.record(z.array(z.string())).optional(),
  kind: z.string().optional(),
  maxImportSizes: z.record(z.string()).optional(),
  maxUploadSize: z.string().optional(),
  storageQuota: z
    .object({
      limit: z.string().optional(),
      usage: z.string().optional(),
      usageInDrive: z.string().optional(),
      usageInDriveTrash: z.string().optional(),
    })
    .optional(),
  teamDriveThemes: z
    .array(
      z.object({
        backgroundImageLink: z.string().optional(),
        colorRgb: z.string().optional(),
        id: z.string().optional(),
      }),
    )
    .optional(),
  user: userSchema.optional(),
});

export const driveAboutGetErrorSchema = z.unknown();

export const driveAppsListDataSchema = z.object({
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      appFilterExtensions: z.string().optional(),
      appFilterMimeTypes: z.string().optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      languageCode: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const appListSchema = z.object({
  defaultAppIds: z.array(z.string()).optional(),
  items: z.array(appSchema).optional(),
  kind: z.string().optional(),
  selfLink: z.string().optional(),
});

export const driveAppsListErrorSchema = z.unknown();

export const driveAppsGetDataSchema = z.object({
  path: z.object({
    appId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveAppsGetResponseSchema = appSchema;

export const driveAppsGetErrorSchema = z.unknown();

export const driveChangesListDataSchema = z.object({
  query: z.object({
    '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
    access_token: z.string().optional(),
    alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
    callback: z.string().optional(),
    driveId: z.string().optional(),
    fields: z.string().optional(),
    includeCorpusRemovals: z.boolean().optional(),
    includeItemsFromAllDrives: z.boolean().optional(),
    includeLabels: z.string().optional(),
    includePermissionsForView: z.string().optional(),
    includeRemoved: z.boolean().optional(),
    includeTeamDriveItems: z.boolean().optional(),
    key: z.string().optional(),
    oauth_token: z.string().optional(),
    pageSize: z.number().optional(),
    pageToken: z.string(),
    prettyPrint: z.boolean().optional(),
    quotaUser: z.string().optional(),
    restrictToMyDrive: z.boolean().optional(),
    spaces: z.string().optional(),
    supportsAllDrives: z.boolean().optional(),
    supportsTeamDrives: z.boolean().optional(),
    teamDriveId: z.string().optional(),
    upload_protocol: z.string().optional(),
    uploadType: z.string().optional(),
  }),
});

export const driveChangesListErrorSchema = z.unknown();

export const driveChangesGetStartPageTokenDataSchema = z.object({
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      driveId: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      supportsAllDrives: z.boolean().optional(),
      supportsTeamDrives: z.boolean().optional(),
      teamDriveId: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveChangesGetStartPageTokenResponseSchema = startPageTokenSchema;

export const driveChangesGetStartPageTokenErrorSchema = z.unknown();

export const driveChangesWatchDataSchema = z.object({
  body: channelSchema.optional(),
  query: z.object({
    '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
    access_token: z.string().optional(),
    alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
    callback: z.string().optional(),
    driveId: z.string().optional(),
    fields: z.string().optional(),
    includeCorpusRemovals: z.boolean().optional(),
    includeItemsFromAllDrives: z.boolean().optional(),
    includeLabels: z.string().optional(),
    includePermissionsForView: z.string().optional(),
    includeRemoved: z.boolean().optional(),
    includeTeamDriveItems: z.boolean().optional(),
    key: z.string().optional(),
    oauth_token: z.string().optional(),
    pageSize: z.number().optional(),
    pageToken: z.string(),
    prettyPrint: z.boolean().optional(),
    quotaUser: z.string().optional(),
    restrictToMyDrive: z.boolean().optional(),
    spaces: z.string().optional(),
    supportsAllDrives: z.boolean().optional(),
    supportsTeamDrives: z.boolean().optional(),
    teamDriveId: z.string().optional(),
    upload_protocol: z.string().optional(),
    uploadType: z.string().optional(),
  }),
});

export const driveChangesWatchResponseSchema = channelSchema;

export const driveChangesWatchErrorSchema = z.unknown();

export const driveChannelsStopDataSchema = z.object({
  body: channelSchema.optional(),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveChannelsStopResponseSchema = z.unknown();

export const driveChannelsStopErrorSchema = z.unknown();

export const driveDrivesListDataSchema = z.object({
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      q: z.string().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
      useDomainAdminAccess: z.boolean().optional(),
    })
    .optional(),
});

export const driveDrivesListResponseSchema = driveListSchema;

export const driveDrivesListErrorSchema = z.unknown();

export const driveDrivesCreateDataSchema = z.object({
  body: driveSchema.optional(),
  query: z.object({
    '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
    access_token: z.string().optional(),
    alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
    callback: z.string().optional(),
    fields: z.string().optional(),
    key: z.string().optional(),
    oauth_token: z.string().optional(),
    prettyPrint: z.boolean().optional(),
    quotaUser: z.string().optional(),
    requestId: z.string(),
    upload_protocol: z.string().optional(),
    uploadType: z.string().optional(),
  }),
});

export const driveDrivesCreateResponseSchema = driveSchema;

export const driveDrivesCreateErrorSchema = z.unknown();

export const driveDrivesDeleteDataSchema = z.object({
  path: z.object({
    driveId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      allowItemDeletion: z.boolean().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
      useDomainAdminAccess: z.boolean().optional(),
    })
    .optional(),
});

export const driveDrivesDeleteResponseSchema = z.unknown();

export const driveDrivesDeleteErrorSchema = z.unknown();

export const driveDrivesGetDataSchema = z.object({
  path: z.object({
    driveId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
      useDomainAdminAccess: z.boolean().optional(),
    })
    .optional(),
});

export const driveDrivesGetResponseSchema = driveSchema;

export const driveDrivesGetErrorSchema = z.unknown();

export const driveDrivesUpdateDataSchema = z.object({
  body: driveSchema.optional(),
  path: z.object({
    driveId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
      useDomainAdminAccess: z.boolean().optional(),
    })
    .optional(),
});

export const driveDrivesUpdateResponseSchema = driveSchema;

export const driveDrivesUpdateErrorSchema = z.unknown();

export const driveDrivesHideDataSchema = z.object({
  path: z.object({
    driveId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveDrivesHideResponseSchema = driveSchema;

export const driveDrivesHideErrorSchema = z.unknown();

export const driveDrivesUnhideDataSchema = z.object({
  path: z.object({
    driveId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveDrivesUnhideResponseSchema = driveSchema;

export const driveDrivesUnhideErrorSchema = z.unknown();

export const driveFilesListDataSchema = z.object({
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      corpora: z.string().optional(),
      corpus: z.union([z.literal('domain'), z.literal('user')]).optional(),
      driveId: z.string().optional(),
      fields: z.string().optional(),
      includeItemsFromAllDrives: z.boolean().optional(),
      includeLabels: z.string().optional(),
      includePermissionsForView: z.string().optional(),
      includeTeamDriveItems: z.boolean().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      orderBy: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      q: z.string().optional(),
      quotaUser: z.string().optional(),
      spaces: z.string().optional(),
      supportsAllDrives: z.boolean().optional(),
      supportsTeamDrives: z.boolean().optional(),
      teamDriveId: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveFilesListErrorSchema = z.unknown();

export const fileSchema = z.object({
  appProperties: z.record(z.string()).optional(),
  capabilities: z
    .object({
      canAcceptOwnership: z.boolean().optional(),
      canAddChildren: z.boolean().optional(),
      canAddFolderFromAnotherDrive: z.boolean().optional(),
      canAddMyDriveParent: z.boolean().optional(),
      canChangeCopyRequiresWriterPermission: z.boolean().optional(),
      canChangeSecurityUpdateEnabled: z.boolean().optional(),
      canChangeViewersCanCopyContent: z.boolean().optional(),
      canComment: z.boolean().optional(),
      canCopy: z.boolean().optional(),
      canDelete: z.boolean().optional(),
      canDeleteChildren: z.boolean().optional(),
      canDownload: z.boolean().optional(),
      canEdit: z.boolean().optional(),
      canListChildren: z.boolean().optional(),
      canModifyContent: z.boolean().optional(),
      canModifyContentRestriction: z.boolean().optional(),
      canModifyEditorContentRestriction: z.boolean().optional(),
      canModifyLabels: z.boolean().optional(),
      canModifyOwnerContentRestriction: z.boolean().optional(),
      canMoveChildrenOutOfDrive: z.boolean().optional(),
      canMoveChildrenOutOfTeamDrive: z.boolean().optional(),
      canMoveChildrenWithinDrive: z.boolean().optional(),
      canMoveChildrenWithinTeamDrive: z.boolean().optional(),
      canMoveItemIntoTeamDrive: z.boolean().optional(),
      canMoveItemOutOfDrive: z.boolean().optional(),
      canMoveItemOutOfTeamDrive: z.boolean().optional(),
      canMoveItemWithinDrive: z.boolean().optional(),
      canMoveItemWithinTeamDrive: z.boolean().optional(),
      canMoveTeamDriveItem: z.boolean().optional(),
      canReadDrive: z.boolean().optional(),
      canReadLabels: z.boolean().optional(),
      canReadRevisions: z.boolean().optional(),
      canReadTeamDrive: z.boolean().optional(),
      canRemoveChildren: z.boolean().optional(),
      canRemoveContentRestriction: z.boolean().optional(),
      canRemoveMyDriveParent: z.boolean().optional(),
      canRename: z.boolean().optional(),
      canShare: z.boolean().optional(),
      canTrash: z.boolean().optional(),
      canTrashChildren: z.boolean().optional(),
      canUntrash: z.boolean().optional(),
    })
    .optional(),
  contentHints: z
    .object({
      indexableText: z.string().optional(),
      thumbnail: z
        .object({
          image: z.string().optional(),
          mimeType: z.string().optional(),
        })
        .optional(),
    })
    .optional(),
  contentRestrictions: z.array(contentRestrictionSchema).optional(),
  copyRequiresWriterPermission: z.boolean().optional(),
  createdTime: z.string().optional(),
  description: z.string().optional(),
  driveId: z.string().optional(),
  explicitlyTrashed: z.boolean().optional(),
  exportLinks: z.record(z.string()).optional(),
  fileExtension: z.string().optional(),
  folderColorRgb: z.string().optional(),
  fullFileExtension: z.string().optional(),
  hasAugmentedPermissions: z.boolean().optional(),
  hasThumbnail: z.boolean().optional(),
  headRevisionId: z.string().optional(),
  iconLink: z.string().optional(),
  id: z.string().optional(),
  imageMediaMetadata: z
    .object({
      aperture: z.number().optional(),
      cameraMake: z.string().optional(),
      cameraModel: z.string().optional(),
      colorSpace: z.string().optional(),
      exposureBias: z.number().optional(),
      exposureMode: z.string().optional(),
      exposureTime: z.number().optional(),
      flashUsed: z.boolean().optional(),
      focalLength: z.number().optional(),
      height: z.number().optional(),
      isoSpeed: z.number().optional(),
      lens: z.string().optional(),
      location: z
        .object({
          altitude: z.number().optional(),
          latitude: z.number().optional(),
          longitude: z.number().optional(),
        })
        .optional(),
      maxApertureValue: z.number().optional(),
      meteringMode: z.string().optional(),
      rotation: z.number().optional(),
      sensor: z.string().optional(),
      subjectDistance: z.number().optional(),
      time: z.string().optional(),
      whiteBalance: z.string().optional(),
      width: z.number().optional(),
    })
    .optional(),
  isAppAuthorized: z.boolean().optional(),
  kind: z.string().optional(),
  labelInfo: z
    .object({
      labels: z.array(labelSchema).optional(),
    })
    .optional(),
  lastModifyingUser: userSchema.optional(),
  linkShareMetadata: z
    .object({
      securityUpdateEligible: z.boolean().optional(),
      securityUpdateEnabled: z.boolean().optional(),
    })
    .optional(),
  md5Checksum: z.string().optional(),
  mimeType: z.string().optional(),
  modifiedByMe: z.boolean().optional(),
  modifiedByMeTime: z.string().optional(),
  modifiedTime: z.string().optional(),
  name: z.string().optional(),
  originalFilename: z.string().optional(),
  ownedByMe: z.boolean().optional(),
  owners: z.array(userSchema).optional(),
  parents: z.array(z.string()).optional(),
  permissionIds: z.array(z.string()).optional(),
  permissions: z.array(permissionSchema).optional(),
  properties: z.record(z.string()).optional(),
  quotaBytesUsed: z.string().optional(),
  resourceKey: z.string().optional(),
  sha1Checksum: z.string().optional(),
  sha256Checksum: z.string().optional(),
  shared: z.boolean().optional(),
  sharedWithMeTime: z.string().optional(),
  sharingUser: userSchema.optional(),
  shortcutDetails: z
    .object({
      targetId: z.string().optional(),
      targetMimeType: z.string().optional(),
      targetResourceKey: z.string().optional(),
    })
    .optional(),
  size: z.string().optional(),
  spaces: z.array(z.string()).optional(),
  starred: z.boolean().optional(),
  teamDriveId: z.string().optional(),
  thumbnailLink: z.string().optional(),
  thumbnailVersion: z.string().optional(),
  trashed: z.boolean().optional(),
  trashedTime: z.string().optional(),
  trashingUser: userSchema.optional(),
  version: z.string().optional(),
  videoMediaMetadata: z
    .object({
      durationMillis: z.string().optional(),
      height: z.number().optional(),
      width: z.number().optional(),
    })
    .optional(),
  viewedByMe: z.boolean().optional(),
  viewedByMeTime: z.string().optional(),
  viewersCanCopyContent: z.boolean().optional(),
  webContentLink: z.string().optional(),
  webViewLink: z.string().optional(),
  writersCanShare: z.boolean().optional(),
});

export const driveFilesCreateResponseSchema = fileSchema;

export const driveFilesCreateErrorSchema = z.unknown();

export const driveFilesGenerateIdsDataSchema = z.object({
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      count: z.number().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      space: z.string().optional(),
      type: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveFilesGenerateIdsResponseSchema = generatedIdsSchema;

export const driveFilesGenerateIdsErrorSchema = z.unknown();

export const driveFilesEmptyTrashDataSchema = z.object({
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      driveId: z.string().optional(),
      enforceSingleParent: z.boolean().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveFilesEmptyTrashResponseSchema = z.unknown();

export const driveFilesEmptyTrashErrorSchema = z.unknown();

export const driveFilesDeleteDataSchema = z.object({
  path: z.object({
    fileId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      enforceSingleParent: z.boolean().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      supportsAllDrives: z.boolean().optional(),
      supportsTeamDrives: z.boolean().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveFilesDeleteResponseSchema = z.unknown();

export const driveFilesDeleteErrorSchema = z.unknown();

export const driveFilesGetDataSchema = z.object({
  path: z.object({
    fileId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      acknowledgeAbuse: z.boolean().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      includeLabels: z.string().optional(),
      includePermissionsForView: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      supportsAllDrives: z.boolean().optional(),
      supportsTeamDrives: z.boolean().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveFilesGetResponseSchema = fileSchema;

export const driveFilesGetErrorSchema = z.unknown();

export const driveFilesUpdateDataSchema = z.object({
  body: fileSchema.optional(),
  path: z.object({
    fileId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      addParents: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      enforceSingleParent: z.boolean().optional(),
      fields: z.string().optional(),
      includeLabels: z.string().optional(),
      includePermissionsForView: z.string().optional(),
      keepRevisionForever: z.boolean().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      ocrLanguage: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      removeParents: z.string().optional(),
      supportsAllDrives: z.boolean().optional(),
      supportsTeamDrives: z.boolean().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
      useContentAsIndexableText: z.boolean().optional(),
    })
    .optional(),
});

export const driveFilesUpdateResponseSchema = fileSchema;

export const driveFilesUpdateErrorSchema = z.unknown();

export const driveCommentsListDataSchema = z.object({
  path: z.object({
    fileId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      includeDeleted: z.boolean().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      startModifiedTime: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const commentListSchema = z.object({
  comments: z.array(commentSchema).optional(),
  kind: z.string().optional(),
  nextPageToken: z.string().optional(),
});

export const driveCommentsListErrorSchema = z.unknown();

export const driveCommentsCreateDataSchema = z.object({
  body: commentSchema.optional(),
  path: z.object({
    fileId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveCommentsCreateResponseSchema = commentSchema;

export const driveCommentsCreateErrorSchema = z.unknown();

export const driveCommentsDeleteDataSchema = z.object({
  path: z.object({
    commentId: z.string(),
    fileId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveCommentsDeleteResponseSchema = z.unknown();

export const driveCommentsDeleteErrorSchema = z.unknown();

export const driveCommentsGetDataSchema = z.object({
  path: z.object({
    commentId: z.string(),
    fileId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      includeDeleted: z.boolean().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveCommentsGetResponseSchema = commentSchema;

export const driveCommentsGetErrorSchema = z.unknown();

export const driveCommentsUpdateDataSchema = z.object({
  body: commentSchema.optional(),
  path: z.object({
    commentId: z.string(),
    fileId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveCommentsUpdateResponseSchema = commentSchema;

export const driveCommentsUpdateErrorSchema = z.unknown();

export const driveRepliesListDataSchema = z.object({
  path: z.object({
    commentId: z.string(),
    fileId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      includeDeleted: z.boolean().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveRepliesListResponseSchema = replyListSchema;

export const driveRepliesListErrorSchema = z.unknown();

export const driveRepliesCreateDataSchema = z.object({
  body: replySchema.optional(),
  path: z.object({
    commentId: z.string(),
    fileId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveRepliesCreateResponseSchema = replySchema;

export const driveRepliesCreateErrorSchema = z.unknown();

export const driveRepliesDeleteDataSchema = z.object({
  path: z.object({
    commentId: z.string(),
    fileId: z.string(),
    replyId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveRepliesDeleteResponseSchema = z.unknown();

export const driveRepliesDeleteErrorSchema = z.unknown();

export const driveRepliesGetDataSchema = z.object({
  path: z.object({
    commentId: z.string(),
    fileId: z.string(),
    replyId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      includeDeleted: z.boolean().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveRepliesGetResponseSchema = replySchema;

export const driveRepliesGetErrorSchema = z.unknown();

export const driveRepliesUpdateDataSchema = z.object({
  body: replySchema.optional(),
  path: z.object({
    commentId: z.string(),
    fileId: z.string(),
    replyId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveRepliesUpdateResponseSchema = replySchema;

export const driveRepliesUpdateErrorSchema = z.unknown();

export const driveFilesCopyDataSchema = z.object({
  body: fileSchema.optional(),
  path: z.object({
    fileId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      enforceSingleParent: z.boolean().optional(),
      fields: z.string().optional(),
      ignoreDefaultVisibility: z.boolean().optional(),
      includeLabels: z.string().optional(),
      includePermissionsForView: z.string().optional(),
      keepRevisionForever: z.boolean().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      ocrLanguage: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      supportsAllDrives: z.boolean().optional(),
      supportsTeamDrives: z.boolean().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveFilesCopyResponseSchema = fileSchema;

export const driveFilesCopyErrorSchema = z.unknown();

export const driveFilesExportDataSchema = z.object({
  path: z.object({
    fileId: z.string(),
  }),
  query: z.object({
    '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
    access_token: z.string().optional(),
    alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
    callback: z.string().optional(),
    fields: z.string().optional(),
    key: z.string().optional(),
    mimeType: z.string(),
    oauth_token: z.string().optional(),
    prettyPrint: z.boolean().optional(),
    quotaUser: z.string().optional(),
    upload_protocol: z.string().optional(),
    uploadType: z.string().optional(),
  }),
});

export const driveFilesExportResponseSchema = z.unknown();

export const driveFilesExportErrorSchema = z.unknown();

export const driveFilesListLabelsDataSchema = z.object({
  path: z.object({
    fileId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      maxResults: z.number().optional(),
      oauth_token: z.string().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const labelListSchema = z.object({
  kind: z.string().optional(),
  labels: z.array(labelSchema).optional(),
  nextPageToken: z.string().optional(),
});

export const driveFilesListLabelsErrorSchema = z.unknown();

export const driveFilesModifyLabelsDataSchema = z.object({
  body: modifyLabelsRequestSchema.optional(),
  path: z.object({
    fileId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveFilesModifyLabelsResponseSchema = modifyLabelsResponseSchema;

export const driveFilesModifyLabelsErrorSchema = z.unknown();

export const drivePermissionsListDataSchema = z.object({
  path: z.object({
    fileId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      includePermissionsForView: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      supportsAllDrives: z.boolean().optional(),
      supportsTeamDrives: z.boolean().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
      useDomainAdminAccess: z.boolean().optional(),
    })
    .optional(),
});

export const drivePermissionsListResponseSchema = permissionListSchema;

export const drivePermissionsListErrorSchema = z.unknown();

export const drivePermissionsCreateDataSchema = z.object({
  body: permissionSchema.optional(),
  path: z.object({
    fileId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      emailMessage: z.string().optional(),
      enforceSingleParent: z.boolean().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      moveToNewOwnersRoot: z.boolean().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      sendNotificationEmail: z.boolean().optional(),
      supportsAllDrives: z.boolean().optional(),
      supportsTeamDrives: z.boolean().optional(),
      transferOwnership: z.boolean().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
      useDomainAdminAccess: z.boolean().optional(),
    })
    .optional(),
});

export const drivePermissionsCreateResponseSchema = permissionSchema;

export const drivePermissionsCreateErrorSchema = z.unknown();

export const drivePermissionsDeleteDataSchema = z.object({
  path: z.object({
    fileId: z.string(),
    permissionId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      supportsAllDrives: z.boolean().optional(),
      supportsTeamDrives: z.boolean().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
      useDomainAdminAccess: z.boolean().optional(),
    })
    .optional(),
});

export const drivePermissionsDeleteResponseSchema = z.unknown();

export const drivePermissionsDeleteErrorSchema = z.unknown();

export const drivePermissionsGetDataSchema = z.object({
  path: z.object({
    fileId: z.string(),
    permissionId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      supportsAllDrives: z.boolean().optional(),
      supportsTeamDrives: z.boolean().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
      useDomainAdminAccess: z.boolean().optional(),
    })
    .optional(),
});

export const drivePermissionsGetResponseSchema = permissionSchema;

export const drivePermissionsGetErrorSchema = z.unknown();

export const drivePermissionsUpdateDataSchema = z.object({
  body: permissionSchema.optional(),
  path: z.object({
    fileId: z.string(),
    permissionId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      removeExpiration: z.boolean().optional(),
      supportsAllDrives: z.boolean().optional(),
      supportsTeamDrives: z.boolean().optional(),
      transferOwnership: z.boolean().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
      useDomainAdminAccess: z.boolean().optional(),
    })
    .optional(),
});

export const drivePermissionsUpdateResponseSchema = permissionSchema;

export const drivePermissionsUpdateErrorSchema = z.unknown();

export const driveRevisionsListDataSchema = z.object({
  path: z.object({
    fileId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveRevisionsListResponseSchema = revisionListSchema;

export const driveRevisionsListErrorSchema = z.unknown();

export const driveRevisionsDeleteDataSchema = z.object({
  path: z.object({
    fileId: z.string(),
    revisionId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveRevisionsDeleteResponseSchema = z.unknown();

export const driveRevisionsDeleteErrorSchema = z.unknown();

export const driveRevisionsGetDataSchema = z.object({
  path: z.object({
    fileId: z.string(),
    revisionId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      acknowledgeAbuse: z.boolean().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveRevisionsGetResponseSchema = revisionSchema;

export const driveRevisionsGetErrorSchema = z.unknown();

export const driveRevisionsUpdateDataSchema = z.object({
  body: revisionSchema.optional(),
  path: z.object({
    fileId: z.string(),
    revisionId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveRevisionsUpdateResponseSchema = revisionSchema;

export const driveRevisionsUpdateErrorSchema = z.unknown();

export const driveFilesWatchDataSchema = z.object({
  body: channelSchema.optional(),
  path: z.object({
    fileId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      acknowledgeAbuse: z.boolean().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      includeLabels: z.string().optional(),
      includePermissionsForView: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      supportsAllDrives: z.boolean().optional(),
      supportsTeamDrives: z.boolean().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveFilesWatchResponseSchema = channelSchema;

export const driveFilesWatchErrorSchema = z.unknown();

export const driveTeamdrivesListDataSchema = z.object({
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      q: z.string().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
      useDomainAdminAccess: z.boolean().optional(),
    })
    .optional(),
});

export const driveTeamdrivesListResponseSchema = teamDriveListSchema;

export const driveTeamdrivesListErrorSchema = z.unknown();

export const driveTeamdrivesCreateDataSchema = z.object({
  body: teamDriveSchema.optional(),
  query: z.object({
    '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
    access_token: z.string().optional(),
    alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
    callback: z.string().optional(),
    fields: z.string().optional(),
    key: z.string().optional(),
    oauth_token: z.string().optional(),
    prettyPrint: z.boolean().optional(),
    quotaUser: z.string().optional(),
    requestId: z.string(),
    upload_protocol: z.string().optional(),
    uploadType: z.string().optional(),
  }),
});

export const driveTeamdrivesCreateResponseSchema = teamDriveSchema;

export const driveTeamdrivesCreateErrorSchema = z.unknown();

export const driveTeamdrivesDeleteDataSchema = z.object({
  path: z.object({
    teamDriveId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const driveTeamdrivesDeleteResponseSchema = z.unknown();

export const driveTeamdrivesDeleteErrorSchema = z.unknown();

export const driveTeamdrivesGetDataSchema = z.object({
  path: z.object({
    teamDriveId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
      useDomainAdminAccess: z.boolean().optional(),
    })
    .optional(),
});

export const driveTeamdrivesGetResponseSchema = teamDriveSchema;

export const driveTeamdrivesGetErrorSchema = z.unknown();

export const driveTeamdrivesUpdateDataSchema = z.object({
  body: teamDriveSchema.optional(),
  path: z.object({
    teamDriveId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
      useDomainAdminAccess: z.boolean().optional(),
    })
    .optional(),
});

export const driveTeamdrivesUpdateResponseSchema = teamDriveSchema;

export const driveTeamdrivesUpdateErrorSchema = z.unknown();

export const changeSchema = z.object({
  changeType: z.string().optional(),
  drive: driveSchema.optional(),
  driveId: z.string().optional(),
  file: fileSchema.optional(),
  fileId: z.string().optional(),
  kind: z.string().optional(),
  removed: z.boolean().optional(),
  teamDrive: teamDriveSchema.optional(),
  teamDriveId: z.string().optional(),
  time: z.string().optional(),
  type: z.string().optional(),
});

export const changeListSchema = z.object({
  changes: z.array(changeSchema).optional(),
  kind: z.string().optional(),
  newStartPageToken: z.string().optional(),
  nextPageToken: z.string().optional(),
});

export const fileListSchema = z.object({
  files: z.array(fileSchema).optional(),
  incompleteSearch: z.boolean().optional(),
  kind: z.string().optional(),
  nextPageToken: z.string().optional(),
});

export const driveAboutGetResponseSchema = aboutSchema;

export const driveAppsListResponseSchema = appListSchema;

export const driveChangesListResponseSchema = changeListSchema;

export const driveFilesListResponseSchema = fileListSchema;

export const driveFilesCreateDataSchema = z.object({
  body: fileSchema.optional(),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      enforceSingleParent: z.boolean().optional(),
      fields: z.string().optional(),
      ignoreDefaultVisibility: z.boolean().optional(),
      includeLabels: z.string().optional(),
      includePermissionsForView: z.string().optional(),
      keepRevisionForever: z.boolean().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      ocrLanguage: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      supportsAllDrives: z.boolean().optional(),
      supportsTeamDrives: z.boolean().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
      useContentAsIndexableText: z.boolean().optional(),
    })
    .optional(),
});

export const driveCommentsListResponseSchema = commentListSchema;

export const driveFilesListLabelsResponseSchema = labelListSchema;
