// This file is auto-generated by @hey-api/openapi-ts

/**
 * Information about the user, the user's Drive, and system capabilities.
 */
export type About = {
  /**
   * Whether the user has installed the requesting app.
   */
  appInstalled?: boolean;
  /**
   * Whether the user can create shared drives.
   */
  canCreateDrives?: boolean;
  /**
   * Deprecated: Use `canCreateDrives` instead.
   * @deprecated
   */
  canCreateTeamDrives?: boolean;
  /**
   * A list of themes that are supported for shared drives.
   */
  driveThemes?: Array<{
    /**
     * A link to this theme's background image.
     */
    backgroundImageLink?: string;
    /**
     * The color of this theme as an RGB hex string.
     */
    colorRgb?: string;
    /**
     * The ID of the theme.
     */
    id?: string;
  }>;
  /**
   * A map of source MIME type to possible targets for all supported exports.
   */
  exportFormats?: {
    [key: string]: Array<string>;
  };
  /**
   * The currently supported folder colors as RGB hex strings.
   */
  folderColorPalette?: Array<string>;
  /**
   * A map of source MIME type to possible targets for all supported imports.
   */
  importFormats?: {
    [key: string]: Array<string>;
  };
  /**
   * Identifies what kind of resource this is. Value: the fixed string `"drive#about"`.
   */
  kind?: string;
  /**
   * A map of maximum import sizes by MIME type, in bytes.
   */
  maxImportSizes?: {
    [key: string]: string;
  };
  /**
   * The maximum upload size in bytes.
   */
  maxUploadSize?: string;
  /**
   * The user's storage quota limits and usage. All fields are measured in bytes.
   */
  storageQuota?: {
    /**
     * The usage limit, if applicable. This will not be present if the user has unlimited storage.
     */
    limit?: string;
    /**
     * The total usage across all services.
     */
    usage?: string;
    /**
     * The usage by all files in Google Drive.
     */
    usageInDrive?: string;
    /**
     * The usage by trashed files in Google Drive.
     */
    usageInDriveTrash?: string;
  };
  /**
   * Deprecated: Use `driveThemes` instead.
   * @deprecated
   */
  teamDriveThemes?: Array<{
    /**
     * Deprecated: Use `driveThemes/backgroundImageLink` instead.
     * @deprecated
     */
    backgroundImageLink?: string;
    /**
     * Deprecated: Use `driveThemes/colorRgb` instead.
     * @deprecated
     */
    colorRgb?: string;
    /**
     * Deprecated: Use `driveThemes/id` instead.
     * @deprecated
     */
    id?: string;
  }>;
  /**
   * The authenticated user.
   */
  user?: User;
};

/**
 * The `apps` resource provides a list of apps that a user has installed, with information about each app's supported MIME types, file extensions, and other details. Some resource methods (such as `apps.get`) require an `appId`. Use the `apps.list` method to retrieve the ID for an installed application.
 */
export type App = {
  /**
   * Whether the app is authorized to access data on the user's Drive.
   */
  authorized?: boolean;
  /**
   * The template URL to create a file with this app in a given folder. The template contains the {folderId} to be replaced by the folder ID house the new file.
   */
  createInFolderTemplate?: string;
  /**
   * The URL to create a file with this app.
   */
  createUrl?: string;
  /**
   * Whether the app has Drive-wide scope. An app with Drive-wide scope can access all files in the user's Drive.
   */
  hasDriveWideScope?: boolean;
  /**
   * The various icons for the app.
   */
  icons?: Array<AppIcons>;
  /**
   * The ID of the app.
   */
  id?: string;
  /**
   * Whether the app is installed.
   */
  installed?: boolean;
  /**
   * Output only. Identifies what kind of resource this is. Value: the fixed string "drive#app".
   */
  kind?: string;
  /**
   * A long description of the app.
   */
  longDescription?: string;
  /**
   * The name of the app.
   */
  name?: string;
  /**
   * The type of object this app creates such as a Chart. If empty, the app name should be used instead.
   */
  objectType?: string;
  /**
   * The template URL for opening files with this app. The template contains {ids} or {exportIds} to be replaced by the actual file IDs. For more information, see Open Files for the full documentation.
   */
  openUrlTemplate?: string;
  /**
   * The list of primary file extensions.
   */
  primaryFileExtensions?: Array<string>;
  /**
   * The list of primary MIME types.
   */
  primaryMimeTypes?: Array<string>;
  /**
   * The ID of the product listing for this app.
   */
  productId?: string;
  /**
   * A link to the product listing for this app.
   */
  productUrl?: string;
  /**
   * The list of secondary file extensions.
   */
  secondaryFileExtensions?: Array<string>;
  /**
   * The list of secondary MIME types.
   */
  secondaryMimeTypes?: Array<string>;
  /**
   * A short description of the app.
   */
  shortDescription?: string;
  /**
   * Whether this app supports creating objects.
   */
  supportsCreate?: boolean;
  /**
   * Whether this app supports importing from Google Docs.
   */
  supportsImport?: boolean;
  /**
   * Whether this app supports opening more than one file.
   */
  supportsMultiOpen?: boolean;
  /**
   * Whether this app supports creating files when offline.
   */
  supportsOfflineCreate?: boolean;
  /**
   * Whether the app is selected as the default handler for the types it supports.
   */
  useByDefault?: boolean;
};

export type AppIcons = {
  /**
   * Category of the icon. Allowed values are: * `application` - The icon for the application. * `document` - The icon for a file associated with the app. * `documentShared` - The icon for a shared file associated with the app.
   */
  category?: string;
  /**
   * URL for the icon.
   */
  iconUrl?: string;
  /**
   * Size of the icon. Represented as the maximum of the width and height.
   */
  size?: number;
};

/**
 * A list of third-party applications which the user has installed or given access to Google Drive.
 */
export type AppList = {
  /**
   * The list of app IDs that the user has specified to use by default. The list is in reverse-priority order (lowest to highest).
   */
  defaultAppIds?: Array<string>;
  /**
   * The list of apps.
   */
  items?: Array<App>;
  /**
   * Output only. Identifies what kind of resource this is. Value: the fixed string "drive#appList".
   */
  kind?: string;
  /**
   * A link back to this list.
   */
  selfLink?: string;
};

/**
 * A change to a file or shared drive.
 */
export type Change = {
  /**
   * The type of the change. Possible values are `file` and `drive`.
   */
  changeType?: string;
  /**
   * The updated state of the shared drive. Present if the changeType is drive, the user is still a member of the shared drive, and the shared drive has not been deleted.
   */
  drive?: Drive;
  /**
   * The ID of the shared drive associated with this change.
   */
  driveId?: string;
  /**
   * The updated state of the file. Present if the type is file and the file has not been removed from this list of changes.
   */
  file?: File;
  /**
   * The ID of the file which has changed.
   */
  fileId?: string;
  /**
   * Identifies what kind of resource this is. Value: the fixed string `"drive#change"`.
   */
  kind?: string;
  /**
   * Whether the file or shared drive has been removed from this list of changes, for example by deletion or loss of access.
   */
  removed?: boolean;
  /**
   * Deprecated: Use `drive` instead.
   * @deprecated
   */
  teamDrive?: TeamDrive;
  /**
   * Deprecated: Use `driveId` instead.
   * @deprecated
   */
  teamDriveId?: string;
  /**
   * The time of this change (RFC 3339 date-time).
   */
  time?: string;
  /**
   * Deprecated: Use `changeType` instead.
   * @deprecated
   */
  type?: string;
};

/**
 * A list of changes for a user.
 */
export type ChangeList = {
  /**
   * The list of changes. If nextPageToken is populated, then this list may be incomplete and an additional page of results should be fetched.
   */
  changes?: Array<Change>;
  /**
   * Identifies what kind of resource this is. Value: the fixed string `"drive#changeList"`.
   */
  kind?: string;
  /**
   * The starting page token for future changes. This will be present only if the end of the current changes list has been reached. The page token doesn't expire.
   */
  newStartPageToken?: string;
  /**
   * The page token for the next page of changes. This will be absent if the end of the changes list has been reached. The page token doesn't expire.
   */
  nextPageToken?: string;
};

/**
 * A notification channel used to watch for resource changes.
 */
export type Channel = {
  /**
   * The address where notifications are delivered for this channel.
   */
  address?: string;
  /**
   * Date and time of notification channel expiration, expressed as a Unix timestamp, in milliseconds. Optional.
   */
  expiration?: string;
  /**
   * A UUID or similar unique string that identifies this channel.
   */
  id?: string;
  /**
   * Identifies this as a notification channel used to watch for changes to a resource, which is `api#channel`.
   */
  kind?: string;
  /**
   * Additional parameters controlling delivery channel behavior. Optional.
   */
  params?: {
    [key: string]: string;
  };
  /**
   * A Boolean value to indicate whether payload is wanted. Optional.
   */
  payload?: boolean;
  /**
   * An opaque ID that identifies the resource being watched on this channel. Stable across different API versions.
   */
  resourceId?: string;
  /**
   * A version-specific identifier for the watched resource.
   */
  resourceUri?: string;
  /**
   * An arbitrary string delivered to the target address with each notification delivered over this channel. Optional.
   */
  token?: string;
  /**
   * The type of delivery mechanism used for this channel. Valid values are "web_hook" or "webhook".
   */
  type?: string;
};

/**
 * A comment on a file. Some resource methods (such as `comments.update`) require a `commentId`. Use the `comments.list` method to retrieve the ID for a comment in a file.
 */
export type Comment = {
  /**
   * A region of the document represented as a JSON string. For details on defining anchor properties, refer to [Manage comments and replies](https://developers.google.com/drive/api/v3/manage-comments).
   */
  anchor?: string;
  /**
   * Output only. The author of the comment. The author's email address and permission ID will not be populated.
   */
  author?: User;
  /**
   * The plain text content of the comment. This field is used for setting the content, while `htmlContent` should be displayed.
   */
  content?: string;
  /**
   * The time at which the comment was created (RFC 3339 date-time).
   */
  createdTime?: string;
  /**
   * Output only. Whether the comment has been deleted. A deleted comment has no content.
   */
  deleted?: boolean;
  /**
   * Output only. The content of the comment with HTML formatting.
   */
  htmlContent?: string;
  /**
   * Output only. The ID of the comment.
   */
  id?: string;
  /**
   * Output only. Identifies what kind of resource this is. Value: the fixed string `"drive#comment"`.
   */
  kind?: string;
  /**
   * The last time the comment or any of its replies was modified (RFC 3339 date-time).
   */
  modifiedTime?: string;
  /**
   * The file content to which the comment refers, typically within the anchor region. For a text file, for example, this would be the text at the location of the comment.
   */
  quotedFileContent?: {
    /**
     * The MIME type of the quoted content.
     */
    mimeType?: string;
    /**
     * The quoted content itself. This is interpreted as plain text if set through the API.
     */
    value?: string;
  };
  /**
   * Output only. The full list of replies to the comment in chronological order.
   */
  replies?: Array<Reply>;
  /**
   * Output only. Whether the comment has been resolved by one of its replies.
   */
  resolved?: boolean;
};

/**
 * A list of comments on a file.
 */
export type CommentList = {
  /**
   * The list of comments. If nextPageToken is populated, then this list may be incomplete and an additional page of results should be fetched.
   */
  comments?: Array<Comment>;
  /**
   * Identifies what kind of resource this is. Value: the fixed string `"drive#commentList"`.
   */
  kind?: string;
  /**
   * The page token for the next page of comments. This will be absent if the end of the comments list has been reached. If the token is rejected for any reason, it should be discarded, and pagination should be restarted from the first page of results. The page token is typically valid for several hours. However, if new items are added or removed, your expected results might differ.
   */
  nextPageToken?: string;
};

/**
 * A restriction for accessing the content of the file.
 */
export type ContentRestriction = {
  /**
   * Whether the content restriction can only be modified or removed by a user who owns the file. For files in shared drives, any user with `organizer` capabilities can modify or remove this content restriction.
   */
  ownerRestricted?: boolean;
  /**
   * Whether the content of the file is read-only. If a file is read-only, a new revision of the file may not be added, comments may not be added or modified, and the title of the file may not be modified.
   */
  readOnly?: boolean;
  /**
   * Reason for why the content of the file is restricted. This is only mutable on requests that also set `readOnly=true`.
   */
  reason?: string;
  /**
   * Output only. The user who set the content restriction. Only populated if `readOnly` is true.
   */
  restrictingUser?: User;
  /**
   * The time at which the content restriction was set (formatted RFC 3339 timestamp). Only populated if readOnly is true.
   */
  restrictionTime?: string;
  /**
   * Output only. Whether the content restriction was applied by the system, for example due to an esignature. Users cannot modify or remove system restricted content restrictions.
   */
  systemRestricted?: boolean;
  /**
   * Output only. The type of the content restriction. Currently the only possible value is `globalContentRestriction`.
   */
  type?: string;
};

/**
 * Representation of a shared drive. Some resource methods (such as `drives.update`) require a `driveId`. Use the `drives.list` method to retrieve the ID for a shared drive.
 */
export type Drive = {
  /**
   * An image file and cropping parameters from which a background image for this shared drive is set. This is a write only field; it can only be set on `drive.drives.update` requests that don't set `themeId`. When specified, all fields of the `backgroundImageFile` must be set.
   */
  backgroundImageFile?: {
    /**
     * The ID of an image file in Google Drive to use for the background image.
     */
    id?: string;
    /**
     * The width of the cropped image in the closed range of 0 to 1. This value represents the width of the cropped image divided by the width of the entire image. The height is computed by applying a width to height aspect ratio of 80 to 9. The resulting image must be at least 1280 pixels wide and 144 pixels high.
     */
    width?: number;
    /**
     * The X coordinate of the upper left corner of the cropping area in the background image. This is a value in the closed range of 0 to 1. This value represents the horizontal distance from the left side of the entire image to the left side of the cropping area divided by the width of the entire image.
     */
    xCoordinate?: number;
    /**
     * The Y coordinate of the upper left corner of the cropping area in the background image. This is a value in the closed range of 0 to 1. This value represents the vertical distance from the top side of the entire image to the top side of the cropping area divided by the height of the entire image.
     */
    yCoordinate?: number;
  };
  /**
   * Output only. A short-lived link to this shared drive's background image.
   */
  backgroundImageLink?: string;
  /**
   * Output only. Capabilities the current user has on this shared drive.
   */
  capabilities?: {
    /**
     * Output only. Whether the current user can add children to folders in this shared drive.
     */
    canAddChildren?: boolean;
    /**
     * Output only. Whether the current user can change the `copyRequiresWriterPermission` restriction of this shared drive.
     */
    canChangeCopyRequiresWriterPermissionRestriction?: boolean;
    /**
     * Output only. Whether the current user can change the `domainUsersOnly` restriction of this shared drive.
     */
    canChangeDomainUsersOnlyRestriction?: boolean;
    /**
     * Output only. Whether the current user can change the background of this shared drive.
     */
    canChangeDriveBackground?: boolean;
    /**
     * Output only. Whether the current user can change the `driveMembersOnly` restriction of this shared drive.
     */
    canChangeDriveMembersOnlyRestriction?: boolean;
    /**
     * Output only. Whether the current user can change the `sharingFoldersRequiresOrganizerPermission` restriction of this shared drive.
     */
    canChangeSharingFoldersRequiresOrganizerPermissionRestriction?: boolean;
    /**
     * Output only. Whether the current user can comment on files in this shared drive.
     */
    canComment?: boolean;
    /**
     * Output only. Whether the current user can copy files in this shared drive.
     */
    canCopy?: boolean;
    /**
     * Output only. Whether the current user can delete children from folders in this shared drive.
     */
    canDeleteChildren?: boolean;
    /**
     * Output only. Whether the current user can delete this shared drive. Attempting to delete the shared drive may still fail if there are untrashed items inside the shared drive.
     */
    canDeleteDrive?: boolean;
    /**
     * Output only. Whether the current user can download files in this shared drive.
     */
    canDownload?: boolean;
    /**
     * Output only. Whether the current user can edit files in this shared drive
     */
    canEdit?: boolean;
    /**
     * Output only. Whether the current user can list the children of folders in this shared drive.
     */
    canListChildren?: boolean;
    /**
     * Output only. Whether the current user can add members to this shared drive or remove them or change their role.
     */
    canManageMembers?: boolean;
    /**
     * Output only. Whether the current user can read the revisions resource of files in this shared drive.
     */
    canReadRevisions?: boolean;
    /**
     * Output only. Whether the current user can rename files or folders in this shared drive.
     */
    canRename?: boolean;
    /**
     * Output only. Whether the current user can rename this shared drive.
     */
    canRenameDrive?: boolean;
    /**
     * Output only. Whether the current user can reset the shared drive restrictions to defaults.
     */
    canResetDriveRestrictions?: boolean;
    /**
     * Output only. Whether the current user can share files or folders in this shared drive.
     */
    canShare?: boolean;
    /**
     * Output only. Whether the current user can trash children from folders in this shared drive.
     */
    canTrashChildren?: boolean;
  };
  /**
   * The color of this shared drive as an RGB hex string. It can only be set on a `drive.drives.update` request that does not set `themeId`.
   */
  colorRgb?: string;
  /**
   * The time at which the shared drive was created (RFC 3339 date-time).
   */
  createdTime?: string;
  /**
   * Whether the shared drive is hidden from default view.
   */
  hidden?: boolean;
  /**
   * Output only. The ID of this shared drive which is also the ID of the top level folder of this shared drive.
   */
  id?: string;
  /**
   * Output only. Identifies what kind of resource this is. Value: the fixed string `"drive#drive"`.
   */
  kind?: string;
  /**
   * The name of this shared drive.
   */
  name?: string;
  /**
   * Output only. The organizational unit of this shared drive. This field is only populated on `drives.list` responses when the `useDomainAdminAccess` parameter is set to `true`.
   */
  orgUnitId?: string;
  /**
   * A set of restrictions that apply to this shared drive or items inside this shared drive. Note that restrictions can't be set when creating a shared drive. To add a restriction, first create a shared drive and then use `drives.update` to add restrictions.
   */
  restrictions?: {
    /**
     * Whether administrative privileges on this shared drive are required to modify restrictions.
     */
    adminManagedRestrictions?: boolean;
    /**
     * Whether the options to copy, print, or download files inside this shared drive, should be disabled for readers and commenters. When this restriction is set to `true`, it will override the similarly named field to `true` for any file inside this shared drive.
     */
    copyRequiresWriterPermission?: boolean;
    /**
     * Whether access to this shared drive and items inside this shared drive is restricted to users of the domain to which this shared drive belongs. This restriction may be overridden by other sharing policies controlled outside of this shared drive.
     */
    domainUsersOnly?: boolean;
    /**
     * Whether access to items inside this shared drive is restricted to its members.
     */
    driveMembersOnly?: boolean;
    /**
     * If true, only users with the organizer role can share folders. If false, users with either the organizer role or the file organizer role can share folders.
     */
    sharingFoldersRequiresOrganizerPermission?: boolean;
  };
  /**
   * The ID of the theme from which the background image and color will be set. The set of possible `driveThemes` can be retrieved from a `drive.about.get` response. When not specified on a `drive.drives.create` request, a random theme is chosen from which the background image and color are set. This is a write-only field; it can only be set on requests that don't set `colorRgb` or `backgroundImageFile`.
   */
  themeId?: string;
};

/**
 * A list of shared drives.
 */
export type DriveList = {
  /**
   * The list of shared drives. If nextPageToken is populated, then this list may be incomplete and an additional page of results should be fetched.
   */
  drives?: Array<Drive>;
  /**
   * Identifies what kind of resource this is. Value: the fixed string `"drive#driveList"`.
   */
  kind?: string;
  /**
   * The page token for the next page of shared drives. This will be absent if the end of the list has been reached. If the token is rejected for any reason, it should be discarded, and pagination should be restarted from the first page of results. The page token is typically valid for several hours. However, if new items are added or removed, your expected results might differ.
   */
  nextPageToken?: string;
};

/**
 * The metadata for a file. Some resource methods (such as `files.update`) require a `fileId`. Use the `files.list` method to retrieve the ID for a file.
 */
export type File = {
  /**
   * A collection of arbitrary key-value pairs which are private to the requesting app.
   * Entries with null values are cleared in update and copy requests. These properties can only be retrieved using an authenticated request. An authenticated request uses an access token obtained with a OAuth 2 client ID. You cannot use an API key to retrieve private properties.
   */
  appProperties?: {
    [key: string]: string;
  };
  /**
   * Output only. Capabilities the current user has on this file. Each capability corresponds to a fine-grained action that a user may take.
   */
  capabilities?: {
    /**
     * Output only. Whether the current user is the pending owner of the file. Not populated for shared drive files.
     */
    canAcceptOwnership?: boolean;
    /**
     * Output only. Whether the current user can add children to this folder. This is always false when the item is not a folder.
     */
    canAddChildren?: boolean;
    /**
     * Output only. Whether the current user can add a folder from another drive (different shared drive or My Drive) to this folder. This is false when the item is not a folder. Only populated for items in shared drives.
     */
    canAddFolderFromAnotherDrive?: boolean;
    /**
     * Output only. Whether the current user can add a parent for the item without removing an existing parent in the same request. Not populated for shared drive files.
     */
    canAddMyDriveParent?: boolean;
    /**
     * Output only. Whether the current user can change the `copyRequiresWriterPermission` restriction of this file.
     */
    canChangeCopyRequiresWriterPermission?: boolean;
    /**
     * Output only. Whether the current user can change the securityUpdateEnabled field on link share metadata.
     */
    canChangeSecurityUpdateEnabled?: boolean;
    /**
     * Deprecated: Output only.
     * @deprecated
     */
    canChangeViewersCanCopyContent?: boolean;
    /**
     * Output only. Whether the current user can comment on this file.
     */
    canComment?: boolean;
    /**
     * Output only. Whether the current user can copy this file. For an item in a shared drive, whether the current user can copy non-folder descendants of this item, or this item itself if it is not a folder.
     */
    canCopy?: boolean;
    /**
     * Output only. Whether the current user can delete this file.
     */
    canDelete?: boolean;
    /**
     * Output only. Whether the current user can delete children of this folder. This is false when the item is not a folder. Only populated for items in shared drives.
     */
    canDeleteChildren?: boolean;
    /**
     * Output only. Whether the current user can download this file.
     */
    canDownload?: boolean;
    /**
     * Output only. Whether the current user can edit this file. Other factors may limit the type of changes a user can make to a file. For example, see `canChangeCopyRequiresWriterPermission` or `canModifyContent`.
     */
    canEdit?: boolean;
    /**
     * Output only. Whether the current user can list the children of this folder. This is always false when the item is not a folder.
     */
    canListChildren?: boolean;
    /**
     * Output only. Whether the current user can modify the content of this file.
     */
    canModifyContent?: boolean;
    /**
     * Deprecated: Output only. Use one of `canModifyEditorContentRestriction`, `canModifyOwnerContentRestriction` or `canRemoveContentRestriction`.
     * @deprecated
     */
    canModifyContentRestriction?: boolean;
    /**
     * Output only. Whether the current user can add or modify content restrictions on the file which are editor restricted.
     */
    canModifyEditorContentRestriction?: boolean;
    /**
     * Output only. Whether the current user can modify the labels on the file.
     */
    canModifyLabels?: boolean;
    /**
     * Output only. Whether the current user can add or modify content restrictions which are owner restricted.
     */
    canModifyOwnerContentRestriction?: boolean;
    /**
     * Output only. Whether the current user can move children of this folder outside of the shared drive. This is false when the item is not a folder. Only populated for items in shared drives.
     */
    canMoveChildrenOutOfDrive?: boolean;
    /**
     * Deprecated: Output only. Use `canMoveChildrenOutOfDrive` instead.
     * @deprecated
     */
    canMoveChildrenOutOfTeamDrive?: boolean;
    /**
     * Output only. Whether the current user can move children of this folder within this drive. This is false when the item is not a folder. Note that a request to move the child may still fail depending on the current user's access to the child and to the destination folder.
     */
    canMoveChildrenWithinDrive?: boolean;
    /**
     * Deprecated: Output only. Use `canMoveChildrenWithinDrive` instead.
     * @deprecated
     */
    canMoveChildrenWithinTeamDrive?: boolean;
    /**
     * Deprecated: Output only. Use `canMoveItemOutOfDrive` instead.
     * @deprecated
     */
    canMoveItemIntoTeamDrive?: boolean;
    /**
     * Output only. Whether the current user can move this item outside of this drive by changing its parent. Note that a request to change the parent of the item may still fail depending on the new parent that is being added.
     */
    canMoveItemOutOfDrive?: boolean;
    /**
     * Deprecated: Output only. Use `canMoveItemOutOfDrive` instead.
     * @deprecated
     */
    canMoveItemOutOfTeamDrive?: boolean;
    /**
     * Output only. Whether the current user can move this item within this drive. Note that a request to change the parent of the item may still fail depending on the new parent that is being added and the parent that is being removed.
     */
    canMoveItemWithinDrive?: boolean;
    /**
     * Deprecated: Output only. Use `canMoveItemWithinDrive` instead.
     * @deprecated
     */
    canMoveItemWithinTeamDrive?: boolean;
    /**
     * Deprecated: Output only. Use `canMoveItemWithinDrive` or `canMoveItemOutOfDrive` instead.
     * @deprecated
     */
    canMoveTeamDriveItem?: boolean;
    /**
     * Output only. Whether the current user can read the shared drive to which this file belongs. Only populated for items in shared drives.
     */
    canReadDrive?: boolean;
    /**
     * Output only. Whether the current user can read the labels on the file.
     */
    canReadLabels?: boolean;
    /**
     * Output only. Whether the current user can read the revisions resource of this file. For a shared drive item, whether revisions of non-folder descendants of this item, or this item itself if it is not a folder, can be read.
     */
    canReadRevisions?: boolean;
    /**
     * Deprecated: Output only. Use `canReadDrive` instead.
     * @deprecated
     */
    canReadTeamDrive?: boolean;
    /**
     * Output only. Whether the current user can remove children from this folder. This is always false when the item is not a folder. For a folder in a shared drive, use `canDeleteChildren` or `canTrashChildren` instead.
     */
    canRemoveChildren?: boolean;
    /**
     * Output only. Whether there is a content restriction on the file that can be removed by the current user.
     */
    canRemoveContentRestriction?: boolean;
    /**
     * Output only. Whether the current user can remove a parent from the item without adding another parent in the same request. Not populated for shared drive files.
     */
    canRemoveMyDriveParent?: boolean;
    /**
     * Output only. Whether the current user can rename this file.
     */
    canRename?: boolean;
    /**
     * Output only. Whether the current user can modify the sharing settings for this file.
     */
    canShare?: boolean;
    /**
     * Output only. Whether the current user can move this file to trash.
     */
    canTrash?: boolean;
    /**
     * Output only. Whether the current user can trash children of this folder. This is false when the item is not a folder. Only populated for items in shared drives.
     */
    canTrashChildren?: boolean;
    /**
     * Output only. Whether the current user can restore this file from trash.
     */
    canUntrash?: boolean;
  };
  /**
   * Additional information about the content of the file. These fields are never populated in responses.
   */
  contentHints?: {
    /**
     * Text to be indexed for the file to improve fullText queries. This is limited to 128KB in length and may contain HTML elements.
     */
    indexableText?: string;
    /**
     * A thumbnail for the file. This will only be used if Google Drive cannot generate a standard thumbnail.
     */
    thumbnail?: {
      /**
       * The thumbnail data encoded with URL-safe Base64 (RFC 4648 section 5).
       */
      image?: string;
      /**
       * The MIME type of the thumbnail.
       */
      mimeType?: string;
    };
  };
  /**
   * Restrictions for accessing the content of the file. Only populated if such a restriction exists.
   */
  contentRestrictions?: Array<ContentRestriction>;
  /**
   * Whether the options to copy, print, or download this file, should be disabled for readers and commenters.
   */
  copyRequiresWriterPermission?: boolean;
  /**
   * The time at which the file was created (RFC 3339 date-time).
   */
  createdTime?: string;
  /**
   * A short description of the file.
   */
  description?: string;
  /**
   * Output only. ID of the shared drive the file resides in. Only populated for items in shared drives.
   */
  driveId?: string;
  /**
   * Output only. Whether the file has been explicitly trashed, as opposed to recursively trashed from a parent folder.
   */
  explicitlyTrashed?: boolean;
  /**
   * Output only. Links for exporting Docs Editors files to specific formats.
   */
  readonly exportLinks?: {
    [key: string]: string;
  };
  /**
   * Output only. The final component of `fullFileExtension`. This is only available for files with binary content in Google Drive.
   */
  fileExtension?: string;
  /**
   * The color for a folder or a shortcut to a folder as an RGB hex string. The supported colors are published in the `folderColorPalette` field of the About resource. If an unsupported color is specified, the closest color in the palette is used instead.
   */
  folderColorRgb?: string;
  /**
   * Output only. The full file extension extracted from the `name` field. May contain multiple concatenated extensions, such as "tar.gz". This is only available for files with binary content in Google Drive. This is automatically updated when the `name` field changes, however it is not cleared if the new name does not contain a valid extension.
   */
  fullFileExtension?: string;
  /**
   * Output only. Whether there are permissions directly on this file. This field is only populated for items in shared drives.
   */
  hasAugmentedPermissions?: boolean;
  /**
   * Output only. Whether this file has a thumbnail. This does not indicate whether the requesting app has access to the thumbnail. To check access, look for the presence of the thumbnailLink field.
   */
  hasThumbnail?: boolean;
  /**
   * Output only. The ID of the file's head revision. This is currently only available for files with binary content in Google Drive.
   */
  headRevisionId?: string;
  /**
   * Output only. A static, unauthenticated link to the file's icon.
   */
  iconLink?: string;
  /**
   * The ID of the file.
   */
  id?: string;
  /**
   * Output only. Additional metadata about image media, if available.
   */
  imageMediaMetadata?: {
    /**
     * Output only. The aperture used to create the photo (f-number).
     */
    aperture?: number;
    /**
     * Output only. The make of the camera used to create the photo.
     */
    cameraMake?: string;
    /**
     * Output only. The model of the camera used to create the photo.
     */
    cameraModel?: string;
    /**
     * Output only. The color space of the photo.
     */
    colorSpace?: string;
    /**
     * Output only. The exposure bias of the photo (APEX value).
     */
    exposureBias?: number;
    /**
     * Output only. The exposure mode used to create the photo.
     */
    exposureMode?: string;
    /**
     * Output only. The length of the exposure, in seconds.
     */
    exposureTime?: number;
    /**
     * Output only. Whether a flash was used to create the photo.
     */
    flashUsed?: boolean;
    /**
     * Output only. The focal length used to create the photo, in millimeters.
     */
    focalLength?: number;
    /**
     * Output only. The height of the image in pixels.
     */
    height?: number;
    /**
     * Output only. The ISO speed used to create the photo.
     */
    isoSpeed?: number;
    /**
     * Output only. The lens used to create the photo.
     */
    lens?: string;
    /**
     * Output only. Geographic location information stored in the image.
     */
    location?: {
      /**
       * Output only. The altitude stored in the image.
       */
      altitude?: number;
      /**
       * Output only. The latitude stored in the image.
       */
      latitude?: number;
      /**
       * Output only. The longitude stored in the image.
       */
      longitude?: number;
    };
    /**
     * Output only. The smallest f-number of the lens at the focal length used to create the photo (APEX value).
     */
    maxApertureValue?: number;
    /**
     * Output only. The metering mode used to create the photo.
     */
    meteringMode?: string;
    /**
     * Output only. The number of clockwise 90 degree rotations applied from the image's original orientation.
     */
    rotation?: number;
    /**
     * Output only. The type of sensor used to create the photo.
     */
    sensor?: string;
    /**
     * Output only. The distance to the subject of the photo, in meters.
     */
    subjectDistance?: number;
    /**
     * Output only. The date and time the photo was taken (EXIF DateTime).
     */
    time?: string;
    /**
     * Output only. The white balance mode used to create the photo.
     */
    whiteBalance?: string;
    /**
     * Output only. The width of the image in pixels.
     */
    width?: number;
  };
  /**
   * Output only. Whether the file was created or opened by the requesting app.
   */
  isAppAuthorized?: boolean;
  /**
   * Output only. Identifies what kind of resource this is. Value: the fixed string `"drive#file"`.
   */
  kind?: string;
  /**
   * Output only. An overview of the labels on the file.
   */
  labelInfo?: {
    /**
     * Output only. The set of labels on the file as requested by the label IDs in the `includeLabels` parameter. By default, no labels are returned.
     */
    labels?: Array<Label>;
  };
  /**
   * Output only. The last user to modify the file.
   */
  lastModifyingUser?: User;
  /**
   * Contains details about the link URLs that clients are using to refer to this item.
   */
  linkShareMetadata?: {
    /**
     * Output only. Whether the file is eligible for security update.
     */
    securityUpdateEligible?: boolean;
    /**
     * Output only. Whether the security update is enabled for this file.
     */
    securityUpdateEnabled?: boolean;
  };
  /**
   * Output only. The MD5 checksum for the content of the file. This is only applicable to files with binary content in Google Drive.
   */
  md5Checksum?: string;
  /**
   * The MIME type of the file. Google Drive attempts to automatically detect an appropriate value from uploaded content, if no value is provided. The value cannot be changed unless a new revision is uploaded. If a file is created with a Google Doc MIME type, the uploaded content is imported, if possible. The supported import formats are published in the About resource.
   */
  mimeType?: string;
  /**
   * Output only. Whether the file has been modified by this user.
   */
  modifiedByMe?: boolean;
  /**
   * The last time the file was modified by the user (RFC 3339 date-time).
   */
  modifiedByMeTime?: string;
  /**
   * he last time the file was modified by anyone (RFC 3339 date-time). Note that setting modifiedTime will also update modifiedByMeTime for the user.
   */
  modifiedTime?: string;
  /**
   * The name of the file. This is not necessarily unique within a folder. Note that for immutable items such as the top level folders of shared drives, My Drive root folder, and Application Data folder the name is constant.
   */
  name?: string;
  /**
   * The original filename of the uploaded content if available, or else the original value of the `name` field. This is only available for files with binary content in Google Drive.
   */
  originalFilename?: string;
  /**
   * Output only. Whether the user owns the file. Not populated for items in shared drives.
   */
  ownedByMe?: boolean;
  /**
   * Output only. The owner of this file. Only certain legacy files may have more than one owner. This field isn't populated for items in shared drives.
   */
  owners?: Array<User>;
  /**
   * The IDs of the parent folders which contain the file. If not specified as part of a create request, the file is placed directly in the user's My Drive folder. If not specified as part of a copy request, the file inherits any discoverable parents of the source file. Update requests must use the `addParents` and `removeParents` parameters to modify the parents list.
   */
  parents?: Array<string>;
  /**
   * Output only. List of permission IDs for users with access to this file.
   */
  permissionIds?: Array<string>;
  /**
   * Output only. The full list of permissions for the file. This is only available if the requesting user can share the file. Not populated for items in shared drives.
   */
  permissions?: Array<Permission>;
  /**
   * A collection of arbitrary key-value pairs which are visible to all apps.
   * Entries with null values are cleared in update and copy requests.
   */
  properties?: {
    [key: string]: string;
  };
  /**
   * Output only. The number of storage quota bytes used by the file. This includes the head revision as well as previous revisions with `keepForever` enabled.
   */
  quotaBytesUsed?: string;
  /**
   * Output only. A key needed to access the item via a shared link.
   */
  resourceKey?: string;
  /**
   * Output only. The SHA1 checksum associated with this file, if available. This field is only populated for files with content stored in Google Drive; it is not populated for Docs Editors or shortcut files.
   */
  sha1Checksum?: string;
  /**
   * Output only. The SHA256 checksum associated with this file, if available. This field is only populated for files with content stored in Google Drive; it is not populated for Docs Editors or shortcut files.
   */
  sha256Checksum?: string;
  /**
   * Output only. Whether the file has been shared. Not populated for items in shared drives.
   */
  shared?: boolean;
  /**
   * The time at which the file was shared with the user, if applicable (RFC 3339 date-time).
   */
  sharedWithMeTime?: string;
  /**
   * Output only. The user who shared the file with the requesting user, if applicable.
   */
  sharingUser?: User;
  /**
   * Shortcut file details. Only populated for shortcut files, which have the mimeType field set to `application/vnd.google-apps.shortcut`.
   */
  shortcutDetails?: {
    /**
     * The ID of the file that this shortcut points to.
     */
    targetId?: string;
    /**
     * Output only. The MIME type of the file that this shortcut points to. The value of this field is a snapshot of the target's MIME type, captured when the shortcut is created.
     */
    targetMimeType?: string;
    /**
     * Output only. The ResourceKey for the target file.
     */
    targetResourceKey?: string;
  };
  /**
   * Output only. Size in bytes of blobs and first party editor files. Won't be populated for files that have no size, like shortcuts and folders.
   */
  size?: string;
  /**
   * Output only. The list of spaces which contain the file. The currently supported values are 'drive', 'appDataFolder' and 'photos'.
   */
  spaces?: Array<string>;
  /**
   * Whether the user has starred the file.
   */
  starred?: boolean;
  /**
   * Deprecated: Output only. Use `driveId` instead.
   * @deprecated
   */
  teamDriveId?: string;
  /**
   * Output only. A short-lived link to the file's thumbnail, if available. Typically lasts on the order of hours. Only populated when the requesting app can access the file's content. If the file isn't shared publicly, the URL returned in `Files.thumbnailLink` must be fetched using a credentialed request.
   */
  thumbnailLink?: string;
  /**
   * Output only. The thumbnail version for use in thumbnail cache invalidation.
   */
  thumbnailVersion?: string;
  /**
   * Whether the file has been trashed, either explicitly or from a trashed parent folder. Only the owner may trash a file, and other users cannot see files in the owner's trash.
   */
  trashed?: boolean;
  /**
   * The time that the item was trashed (RFC 3339 date-time). Only populated for items in shared drives.
   */
  trashedTime?: string;
  /**
   * Output only. If the file has been explicitly trashed, the user who trashed it. Only populated for items in shared drives.
   */
  trashingUser?: User;
  /**
   * Output only. A monotonically increasing version number for the file. This reflects every change made to the file on the server, even those not visible to the user.
   */
  version?: string;
  /**
   * Output only. Additional metadata about video media. This may not be available immediately upon upload.
   */
  videoMediaMetadata?: {
    /**
     * Output only. The duration of the video in milliseconds.
     */
    durationMillis?: string;
    /**
     * Output only. The height of the video in pixels.
     */
    height?: number;
    /**
     * Output only. The width of the video in pixels.
     */
    width?: number;
  };
  /**
   * Output only. Whether the file has been viewed by this user.
   */
  viewedByMe?: boolean;
  /**
   * The last time the file was viewed by the user (RFC 3339 date-time).
   */
  viewedByMeTime?: string;
  /**
   * Deprecated: Use `copyRequiresWriterPermission` instead.
   * @deprecated
   */
  viewersCanCopyContent?: boolean;
  /**
   * Output only. A link for downloading the content of the file in a browser. This is only available for files with binary content in Google Drive.
   */
  webContentLink?: string;
  /**
   * Output only. A link for opening the file in a relevant Google editor or viewer in a browser.
   */
  webViewLink?: string;
  /**
   * Whether users with only `writer` permission can modify the file's permissions. Not populated for items in shared drives.
   */
  writersCanShare?: boolean;
};

/**
 * A list of files.
 */
export type FileList = {
  /**
   * The list of files. If nextPageToken is populated, then this list may be incomplete and an additional page of results should be fetched.
   */
  files?: Array<File>;
  /**
   * Whether the search process was incomplete. If true, then some search results might be missing, since all documents were not searched. This can occur when searching multiple drives with the 'allDrives' corpora, but all corpora couldn't be searched. When this happens, it's suggested that clients narrow their query by choosing a different corpus such as 'user' or 'drive'.
   */
  incompleteSearch?: boolean;
  /**
   * Identifies what kind of resource this is. Value: the fixed string `"drive#fileList"`.
   */
  kind?: string;
  /**
   * The page token for the next page of files. This will be absent if the end of the files list has been reached. If the token is rejected for any reason, it should be discarded, and pagination should be restarted from the first page of results. The page token is typically valid for several hours. However, if new items are added or removed, your expected results might differ.
   */
  nextPageToken?: string;
};

/**
 * A list of generated file IDs which can be provided in create requests.
 */
export type GeneratedIds = {
  /**
   * The IDs generated for the requesting user in the specified space.
   */
  ids?: Array<string>;
  /**
   * Identifies what kind of resource this is. Value: the fixed string `"drive#generatedIds"`.
   */
  kind?: string;
  /**
   * The type of file that can be created with these IDs.
   */
  space?: string;
};

/**
 * Representation of label and label fields.
 */
export type Label = {
  /**
   * A map of the fields on the label, keyed by the field's ID.
   */
  fields?: {
    [key: string]: LabelField;
  };
  /**
   * The ID of the label.
   */
  id?: string;
  /**
   * This is always drive#label
   */
  kind?: string;
  /**
   * The revision ID of the label.
   */
  revisionId?: string;
};

/**
 * Representation of field, which is a typed key-value pair.
 */
export type LabelField = {
  /**
   * Only present if valueType is dateString. RFC 3339 formatted date: YYYY-MM-DD.
   */
  dateString?: Array<string>;
  /**
   * The identifier of this label field.
   */
  id?: string;
  /**
   * Only present if `valueType` is `integer`.
   */
  integer?: Array<string>;
  /**
   * This is always drive#labelField.
   */
  kind?: string;
  /**
   * Only present if `valueType` is `selection`
   */
  selection?: Array<string>;
  /**
   * Only present if `valueType` is `text`.
   */
  text?: Array<string>;
  /**
   * Only present if `valueType` is `user`.
   */
  user?: Array<User>;
  /**
   * The field type. While new values may be supported in the future, the following are currently allowed: * `dateString` * `integer` * `selection` * `text` * `user`
   */
  valueType?: string;
};

/**
 * A modification to a label's field.
 */
export type LabelFieldModification = {
  /**
   * The ID of the field to be modified.
   */
  fieldId?: string;
  /**
   * This is always drive#labelFieldModification.
   */
  kind?: string;
  /**
   * Replaces the value of a dateString Field with these new values. The string must be in the RFC 3339 full-date format: YYYY-MM-DD.
   */
  setDateValues?: Array<string>;
  /**
   * Replaces the value of an `integer` field with these new values.
   */
  setIntegerValues?: Array<string>;
  /**
   * Replaces a `selection` field with these new values.
   */
  setSelectionValues?: Array<string>;
  /**
   * Sets the value of a `text` field.
   */
  setTextValues?: Array<string>;
  /**
   * Replaces a `user` field with these new values. The values must be valid email addresses.
   */
  setUserValues?: Array<string>;
  /**
   * Unsets the values for this field.
   */
  unsetValues?: boolean;
};

/**
 * A list of labels applied to a file.
 */
export type LabelList = {
  /**
   * This is always drive#labelList
   */
  kind?: string;
  /**
   * The list of labels.
   */
  labels?: Array<Label>;
  /**
   * The page token for the next page of labels. This field will be absent if the end of the list has been reached. If the token is rejected for any reason, it should be discarded, and pagination should be restarted from the first page of results. The page token is typically valid for several hours. However, if new items are added or removed, your expected results might differ.
   */
  nextPageToken?: string;
};

/**
 * A modification to a label on a file. A LabelModification can be used to apply a label to a file, update an existing label on a file, or remove a label from a file.
 */
export type LabelModification = {
  /**
   * The list of modifications to this label's fields.
   */
  fieldModifications?: Array<LabelFieldModification>;
  /**
   * This is always drive#labelModification.
   */
  kind?: string;
  /**
   * The ID of the label to modify.
   */
  labelId?: string;
  /**
   * If true, the label will be removed from the file.
   */
  removeLabel?: boolean;
};

/**
 * A request to modify the set of labels on a file. This request may contain many modifications that will either all succeed or all fail atomically.
 */
export type ModifyLabelsRequest = {
  /**
   * This is always drive#modifyLabelsRequest.
   */
  kind?: string;
  /**
   * The list of modifications to apply to the labels on the file.
   */
  labelModifications?: Array<LabelModification>;
};

/**
 * Response to a ModifyLabels request. This contains only those labels which were added or updated by the request.
 */
export type ModifyLabelsResponse = {
  /**
   * This is always drive#modifyLabelsResponse
   */
  kind?: string;
  /**
   * The list of labels which were added or updated by the request.
   */
  modifiedLabels?: Array<Label>;
};

/**
 * A permission for a file. A permission grants a user, group, domain, or the world access to a file or a folder hierarchy. Some resource methods (such as `permissions.update`) require a `permissionId`. Use the `permissions.list` method to retrieve the ID for a file, folder, or shared drive.
 */
export type Permission = {
  /**
   * Whether the permission allows the file to be discovered through search. This is only applicable for permissions of type `domain` or `anyone`.
   */
  allowFileDiscovery?: boolean;
  /**
   * Output only. Whether the account associated with this permission has been deleted. This field only pertains to user and group permissions.
   */
  deleted?: boolean;
  /**
   * Output only. The "pretty" name of the value of the permission. The following is a list of examples for each type of permission: * `user` - User's full name, as defined for their Google account, such as "Joe Smith." * `group` - Name of the Google Group, such as "The Company Administrators." * `domain` - String domain name, such as "thecompany.com." * `anyone` - No `displayName` is present.
   */
  displayName?: string;
  /**
   * The domain to which this permission refers.
   */
  domain?: string;
  /**
   * The email address of the user or group to which this permission refers.
   */
  emailAddress?: string;
  /**
   * The time at which this permission will expire (RFC 3339 date-time). Expiration times have the following restrictions: - They can only be set on user and group permissions - The time must be in the future - The time cannot be more than a year in the future
   */
  expirationTime?: string;
  /**
   * Output only. The ID of this permission. This is a unique identifier for the grantee, and is published in User resources as `permissionId`. IDs should be treated as opaque values.
   */
  id?: string;
  /**
   * Output only. Identifies what kind of resource this is. Value: the fixed string `"drive#permission"`.
   */
  kind?: string;
  /**
   * Whether the account associated with this permission is a pending owner. Only populated for `user` type permissions for files that are not in a shared drive.
   */
  pendingOwner?: boolean;
  /**
   * Output only. Details of whether the permissions on this shared drive item are inherited or directly on this item. This is an output-only field which is present only for shared drive items.
   */
  readonly permissionDetails?: Array<{
    /**
     * Output only. Whether this permission is inherited. This field is always populated. This is an output-only field.
     */
    inherited?: boolean;
    /**
     * Output only. The ID of the item from which this permission is inherited. This is an output-only field.
     */
    inheritedFrom?: string;
    /**
     * Output only. The permission type for this user. While new values may be added in future, the following are currently possible: * `file` * `member`
     */
    permissionType?: string;
    /**
     * Output only. The primary role for this user. While new values may be added in the future, the following are currently possible: * `organizer` * `fileOrganizer` * `writer` * `commenter` * `reader`
     */
    role?: string;
  }>;
  /**
   * Output only. A link to the user's profile photo, if available.
   */
  photoLink?: string;
  /**
   * The role granted by this permission. While new values may be supported in the future, the following are currently allowed: * `owner` * `organizer` * `fileOrganizer` * `writer` * `commenter` * `reader`
   */
  role?: string;
  /**
   * Output only. Deprecated: Output only. Use `permissionDetails` instead.
   * @deprecated
   */
  readonly teamDrivePermissionDetails?: Array<{
    /**
     * Deprecated: Output only. Use `permissionDetails/inherited` instead.
     * @deprecated
     */
    inherited?: boolean;
    /**
     * Deprecated: Output only. Use `permissionDetails/inheritedFrom` instead.
     * @deprecated
     */
    inheritedFrom?: string;
    /**
     * Deprecated: Output only. Use `permissionDetails/role` instead.
     * @deprecated
     */
    role?: string;
    /**
     * Deprecated: Output only. Use `permissionDetails/permissionType` instead.
     * @deprecated
     */
    teamDrivePermissionType?: string;
  }>;
  /**
   * The type of the grantee. Valid values are: * `user` * `group` * `domain` * `anyone` When creating a permission, if `type` is `user` or `group`, you must provide an `emailAddress` for the user or group. When `type` is `domain`, you must provide a `domain`. There isn't extra information required for an `anyone` type.
   */
  type?: string;
  /**
   * Indicates the view for this permission. Only populated for permissions that belong to a view. 'published' is the only supported value.
   */
  view?: string;
};

/**
 * A list of permissions for a file.
 */
export type PermissionList = {
  /**
   * Identifies what kind of resource this is. Value: the fixed string `"drive#permissionList"`.
   */
  kind?: string;
  /**
   * The page token for the next page of permissions. This field will be absent if the end of the permissions list has been reached. If the token is rejected for any reason, it should be discarded, and pagination should be restarted from the first page of results. The page token is typically valid for several hours. However, if new items are added or removed, your expected results might differ.
   */
  nextPageToken?: string;
  /**
   * The list of permissions. If nextPageToken is populated, then this list may be incomplete and an additional page of results should be fetched.
   */
  permissions?: Array<Permission>;
};

/**
 * A reply to a comment on a file. Some resource methods (such as `replies.update`) require a `replyId`. Use the `replies.list` method to retrieve the ID for a reply.
 */
export type Reply = {
  /**
   * The action the reply performed to the parent comment. Valid values are: * `resolve` * `reopen`
   */
  action?: string;
  /**
   * Output only. The author of the reply. The author's email address and permission ID will not be populated.
   */
  author?: User;
  /**
   * The plain text content of the reply. This field is used for setting the content, while `htmlContent` should be displayed. This is required on creates if no `action` is specified.
   */
  content?: string;
  /**
   * The time at which the reply was created (RFC 3339 date-time).
   */
  createdTime?: string;
  /**
   * Output only. Whether the reply has been deleted. A deleted reply has no content.
   */
  deleted?: boolean;
  /**
   * Output only. The content of the reply with HTML formatting.
   */
  htmlContent?: string;
  /**
   * Output only. The ID of the reply.
   */
  id?: string;
  /**
   * Output only. Identifies what kind of resource this is. Value: the fixed string `"drive#reply"`.
   */
  kind?: string;
  /**
   * The last time the reply was modified (RFC 3339 date-time).
   */
  modifiedTime?: string;
};

/**
 * A list of replies to a comment on a file.
 */
export type ReplyList = {
  /**
   * Identifies what kind of resource this is. Value: the fixed string `"drive#replyList"`.
   */
  kind?: string;
  /**
   * The page token for the next page of replies. This will be absent if the end of the replies list has been reached. If the token is rejected for any reason, it should be discarded, and pagination should be restarted from the first page of results. The page token is typically valid for several hours. However, if new items are added or removed, your expected results might differ.
   */
  nextPageToken?: string;
  /**
   * The list of replies. If nextPageToken is populated, then this list may be incomplete and an additional page of results should be fetched.
   */
  replies?: Array<Reply>;
};

/**
 * The metadata for a revision to a file. Some resource methods (such as `revisions.update`) require a `revisionId`. Use the `revisions.list` method to retrieve the ID for a revision.
 */
export type Revision = {
  /**
   * Output only. Links for exporting Docs Editors files to specific formats.
   */
  exportLinks?: {
    [key: string]: string;
  };
  /**
   * Output only. The ID of the revision.
   */
  id?: string;
  /**
   * Whether to keep this revision forever, even if it is no longer the head revision. If not set, the revision will be automatically purged 30 days after newer content is uploaded. This can be set on a maximum of 200 revisions for a file. This field is only applicable to files with binary content in Drive.
   */
  keepForever?: boolean;
  /**
   * Output only. Identifies what kind of resource this is. Value: the fixed string `"drive#revision"`.
   */
  kind?: string;
  /**
   * Output only. The last user to modify this revision.
   */
  lastModifyingUser?: User;
  /**
   * Output only. The MD5 checksum of the revision's content. This is only applicable to files with binary content in Drive.
   */
  md5Checksum?: string;
  /**
   * Output only. The MIME type of the revision.
   */
  mimeType?: string;
  /**
   * The last time the revision was modified (RFC 3339 date-time).
   */
  modifiedTime?: string;
  /**
   * Output only. The original filename used to create this revision. This is only applicable to files with binary content in Drive.
   */
  originalFilename?: string;
  /**
   * Whether subsequent revisions will be automatically republished. This is only applicable to Docs Editors files.
   */
  publishAuto?: boolean;
  /**
   * Whether this revision is published. This is only applicable to Docs Editors files.
   */
  published?: boolean;
  /**
   * Output only. A link to the published revision. This is only populated for Google Sites files.
   */
  publishedLink?: string;
  /**
   * Whether this revision is published outside the domain. This is only applicable to Docs Editors files.
   */
  publishedOutsideDomain?: boolean;
  /**
   * Output only. The size of the revision's content in bytes. This is only applicable to files with binary content in Drive.
   */
  size?: string;
};

/**
 * A list of revisions of a file.
 */
export type RevisionList = {
  /**
   * Identifies what kind of resource this is. Value: the fixed string `"drive#revisionList"`.
   */
  kind?: string;
  /**
   * The page token for the next page of revisions. This will be absent if the end of the revisions list has been reached. If the token is rejected for any reason, it should be discarded, and pagination should be restarted from the first page of results. The page token is typically valid for several hours. However, if new items are added or removed, your expected results might differ.
   */
  nextPageToken?: string;
  /**
   * The list of revisions. If nextPageToken is populated, then this list may be incomplete and an additional page of results should be fetched.
   */
  revisions?: Array<Revision>;
};

export type StartPageToken = {
  /**
   * Identifies what kind of resource this is. Value: the fixed string `"drive#startPageToken"`.
   */
  kind?: string;
  /**
   * The starting page token for listing future changes. The page token doesn't expire.
   */
  startPageToken?: string;
};

/**
 * Deprecated: use the drive collection instead.
 */
export type TeamDrive = {
  /**
   * An image file and cropping parameters from which a background image for this Team Drive is set. This is a write only field; it can only be set on `drive.teamdrives.update` requests that don't set `themeId`. When specified, all fields of the `backgroundImageFile` must be set.
   */
  backgroundImageFile?: {
    /**
     * The ID of an image file in Drive to use for the background image.
     */
    id?: string;
    /**
     * The width of the cropped image in the closed range of 0 to 1. This value represents the width of the cropped image divided by the width of the entire image. The height is computed by applying a width to height aspect ratio of 80 to 9. The resulting image must be at least 1280 pixels wide and 144 pixels high.
     */
    width?: number;
    /**
     * The X coordinate of the upper left corner of the cropping area in the background image. This is a value in the closed range of 0 to 1. This value represents the horizontal distance from the left side of the entire image to the left side of the cropping area divided by the width of the entire image.
     */
    xCoordinate?: number;
    /**
     * The Y coordinate of the upper left corner of the cropping area in the background image. This is a value in the closed range of 0 to 1. This value represents the vertical distance from the top side of the entire image to the top side of the cropping area divided by the height of the entire image.
     */
    yCoordinate?: number;
  };
  /**
   * A short-lived link to this Team Drive's background image.
   */
  backgroundImageLink?: string;
  /**
   * Capabilities the current user has on this Team Drive.
   */
  capabilities?: {
    /**
     * Whether the current user can add children to folders in this Team Drive.
     */
    canAddChildren?: boolean;
    /**
     * Whether the current user can change the `copyRequiresWriterPermission` restriction of this Team Drive.
     */
    canChangeCopyRequiresWriterPermissionRestriction?: boolean;
    /**
     * Whether the current user can change the `domainUsersOnly` restriction of this Team Drive.
     */
    canChangeDomainUsersOnlyRestriction?: boolean;
    /**
     * Whether the current user can change the `sharingFoldersRequiresOrganizerPermission` restriction of this Team Drive.
     */
    canChangeSharingFoldersRequiresOrganizerPermissionRestriction?: boolean;
    /**
     * Whether the current user can change the background of this Team Drive.
     */
    canChangeTeamDriveBackground?: boolean;
    /**
     * Whether the current user can change the `teamMembersOnly` restriction of this Team Drive.
     */
    canChangeTeamMembersOnlyRestriction?: boolean;
    /**
     * Whether the current user can comment on files in this Team Drive.
     */
    canComment?: boolean;
    /**
     * Whether the current user can copy files in this Team Drive.
     */
    canCopy?: boolean;
    /**
     * Whether the current user can delete children from folders in this Team Drive.
     */
    canDeleteChildren?: boolean;
    /**
     * Whether the current user can delete this Team Drive. Attempting to delete the Team Drive may still fail if there are untrashed items inside the Team Drive.
     */
    canDeleteTeamDrive?: boolean;
    /**
     * Whether the current user can download files in this Team Drive.
     */
    canDownload?: boolean;
    /**
     * Whether the current user can edit files in this Team Drive
     */
    canEdit?: boolean;
    /**
     * Whether the current user can list the children of folders in this Team Drive.
     */
    canListChildren?: boolean;
    /**
     * Whether the current user can add members to this Team Drive or remove them or change their role.
     */
    canManageMembers?: boolean;
    /**
     * Whether the current user can read the revisions resource of files in this Team Drive.
     */
    canReadRevisions?: boolean;
    /**
     * Deprecated: Use `canDeleteChildren` or `canTrashChildren` instead.
     * @deprecated
     */
    canRemoveChildren?: boolean;
    /**
     * Whether the current user can rename files or folders in this Team Drive.
     */
    canRename?: boolean;
    /**
     * Whether the current user can rename this Team Drive.
     */
    canRenameTeamDrive?: boolean;
    /**
     * Whether the current user can reset the Team Drive restrictions to defaults.
     */
    canResetTeamDriveRestrictions?: boolean;
    /**
     * Whether the current user can share files or folders in this Team Drive.
     */
    canShare?: boolean;
    /**
     * Whether the current user can trash children from folders in this Team Drive.
     */
    canTrashChildren?: boolean;
  };
  /**
   * The color of this Team Drive as an RGB hex string. It can only be set on a `drive.teamdrives.update` request that does not set `themeId`.
   */
  colorRgb?: string;
  /**
   * The time at which the Team Drive was created (RFC 3339 date-time).
   */
  createdTime?: string;
  /**
   * The ID of this Team Drive which is also the ID of the top level folder of this Team Drive.
   */
  id?: string;
  /**
   * Identifies what kind of resource this is. Value: the fixed string `"drive#teamDrive"`.
   */
  kind?: string;
  /**
   * The name of this Team Drive.
   */
  name?: string;
  /**
   * The organizational unit of this shared drive. This field is only populated on `drives.list` responses when the `useDomainAdminAccess` parameter is set to `true`.
   */
  orgUnitId?: string;
  /**
   * A set of restrictions that apply to this Team Drive or items inside this Team Drive.
   */
  restrictions?: {
    /**
     * Whether administrative privileges on this Team Drive are required to modify restrictions.
     */
    adminManagedRestrictions?: boolean;
    /**
     * Whether the options to copy, print, or download files inside this Team Drive, should be disabled for readers and commenters. When this restriction is set to `true`, it will override the similarly named field to `true` for any file inside this Team Drive.
     */
    copyRequiresWriterPermission?: boolean;
    /**
     * Whether access to this Team Drive and items inside this Team Drive is restricted to users of the domain to which this Team Drive belongs. This restriction may be overridden by other sharing policies controlled outside of this Team Drive.
     */
    domainUsersOnly?: boolean;
    /**
     * If true, only users with the organizer role can share folders. If false, users with either the organizer role or the file organizer role can share folders.
     */
    sharingFoldersRequiresOrganizerPermission?: boolean;
    /**
     * Whether access to items inside this Team Drive is restricted to members of this Team Drive.
     */
    teamMembersOnly?: boolean;
  };
  /**
   * The ID of the theme from which the background image and color will be set. The set of possible `teamDriveThemes` can be retrieved from a `drive.about.get` response. When not specified on a `drive.teamdrives.create` request, a random theme is chosen from which the background image and color are set. This is a write-only field; it can only be set on requests that don't set `colorRgb` or `backgroundImageFile`.
   */
  themeId?: string;
};

/**
 * A list of Team Drives.
 */
export type TeamDriveList = {
  /**
   * Identifies what kind of resource this is. Value: the fixed string `"drive#teamDriveList"`.
   */
  kind?: string;
  /**
   * The page token for the next page of Team Drives. This will be absent if the end of the Team Drives list has been reached. If the token is rejected for any reason, it should be discarded, and pagination should be restarted from the first page of results. The page token is typically valid for several hours. However, if new items are added or removed, your expected results might differ.
   */
  nextPageToken?: string;
  /**
   * The list of Team Drives. If nextPageToken is populated, then this list may be incomplete and an additional page of results should be fetched.
   */
  teamDrives?: Array<TeamDrive>;
};

/**
 * Information about a Drive user.
 */
export type User = {
  /**
   * Output only. A plain text displayable name for this user.
   */
  displayName?: string;
  /**
   * Output only. The email address of the user. This may not be present in certain contexts if the user has not made their email address visible to the requester.
   */
  emailAddress?: string;
  /**
   * Output only. Identifies what kind of resource this is. Value: the fixed string `"drive#user"`.
   */
  kind?: string;
  /**
   * Output only. Whether this user is the requesting user.
   */
  me?: boolean;
  /**
   * Output only. The user's ID as visible in Permission resources.
   */
  permissionId?: string;
  /**
   * Output only. A link to the user's profile photo, if available.
   */
  photoLink?: string;
};

/**
 * V1 error format.
 */
export type Parameter__xgafv = '1' | '2';

/**
 * OAuth access token.
 */
export type Parameteraccess_token = string;

/**
 * Data format for response.
 */
export type Parameteralt = 'json' | 'media' | 'proto';

/**
 * JSONP
 */
export type Parametercallback = string;

/**
 * Selector specifying which fields to include in a partial response.
 */
export type Parameterfields = string;

/**
 * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
 */
export type Parameterkey = string;

/**
 * OAuth 2.0 token for the current user.
 */
export type Parameteroauth_token = string;

/**
 * Returns response with indentations and line breaks.
 */
export type ParameterprettyPrint = boolean;

/**
 * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
 */
export type ParameterquotaUser = string;

/**
 * Legacy upload protocol for media (e.g. "media", "multipart").
 */
export type ParameteruploadType = string;

/**
 * Upload protocol for media (e.g. "raw", "multipart").
 */
export type Parameterupload_protocol = string;

export type DriveAboutGetData = {
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveAboutGetResponse = About;

export type DriveAboutGetError = unknown;

export type DriveAppsListData = {
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * A comma-separated list of file extensions to limit returned results. All results within the given app query scope which can open any of the given file extensions are included in the response. If `appFilterMimeTypes` are provided as well, the result is a union of the two resulting app lists.
     */
    appFilterExtensions?: string;
    /**
     * A comma-separated list of file extensions to limit returned results. All results within the given app query scope which can open any of the given MIME types will be included in the response. If `appFilterExtensions` are provided as well, the result is a union of the two resulting app lists.
     */
    appFilterMimeTypes?: string;
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * A language or locale code, as defined by BCP 47, with some extensions from Unicode's LDML format (http://www.unicode.org/reports/tr35/).
     */
    languageCode?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveAppsListResponse = AppList;

export type DriveAppsListError = unknown;

export type DriveAppsGetData = {
  path: {
    /**
     * The ID of the app.
     */
    appId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveAppsGetResponse = App;

export type DriveAppsGetError = unknown;

export type DriveChangesListData = {
  query: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * The shared drive from which changes will be returned. If specified the change IDs will be reflective of the shared drive; use the combined drive ID and change ID as an identifier.
     */
    driveId?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * Whether changes should include the file resource if the file is still accessible by the user at the time of the request, even when a file was removed from the list of changes and there will be no further change entries for this file.
     */
    includeCorpusRemovals?: boolean;
    /**
     * Whether both My Drive and shared drive items should be included in results.
     */
    includeItemsFromAllDrives?: boolean;
    /**
     * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
     */
    includeLabels?: string;
    /**
     * Specifies which additional view's permissions to include in the response. Only 'published' is supported.
     */
    includePermissionsForView?: string;
    /**
     * Whether to include changes indicating that items have been removed from the list of changes, for example by deletion or loss of access.
     */
    includeRemoved?: boolean;
    /**
     * Deprecated: Use `includeItemsFromAllDrives` instead.
     */
    includeTeamDriveItems?: boolean;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The maximum number of changes to return per page.
     */
    pageSize?: number;
    /**
     * The token for continuing a previous list request on the next page. This should be set to the value of 'nextPageToken' from the previous response or to the response from the getStartPageToken method.
     */
    pageToken: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Whether to restrict the results to changes inside the My Drive hierarchy. This omits changes to files such as those in the Application Data folder or shared files which have not been added to My Drive.
     */
    restrictToMyDrive?: boolean;
    /**
     * A comma-separated list of spaces to query within the corpora. Supported values are 'drive' and 'appDataFolder'.
     */
    spaces?: string;
    /**
     * Whether the requesting application supports both My Drives and shared drives.
     */
    supportsAllDrives?: boolean;
    /**
     * Deprecated: Use `supportsAllDrives` instead.
     */
    supportsTeamDrives?: boolean;
    /**
     * Deprecated: Use `driveId` instead.
     */
    teamDriveId?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveChangesListResponse = ChangeList;

export type DriveChangesListError = unknown;

export type DriveChangesGetStartPageTokenData = {
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * The ID of the shared drive for which the starting pageToken for listing future changes from that shared drive will be returned.
     */
    driveId?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Whether the requesting application supports both My Drives and shared drives.
     */
    supportsAllDrives?: boolean;
    /**
     * Deprecated: Use `supportsAllDrives` instead.
     */
    supportsTeamDrives?: boolean;
    /**
     * Deprecated: Use `driveId` instead.
     */
    teamDriveId?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveChangesGetStartPageTokenResponse = StartPageToken;

export type DriveChangesGetStartPageTokenError = unknown;

export type DriveChangesWatchData = {
  body?: Channel;
  query: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * The shared drive from which changes will be returned. If specified the change IDs will be reflective of the shared drive; use the combined drive ID and change ID as an identifier.
     */
    driveId?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * Whether changes should include the file resource if the file is still accessible by the user at the time of the request, even when a file was removed from the list of changes and there will be no further change entries for this file.
     */
    includeCorpusRemovals?: boolean;
    /**
     * Whether both My Drive and shared drive items should be included in results.
     */
    includeItemsFromAllDrives?: boolean;
    /**
     * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
     */
    includeLabels?: string;
    /**
     * Specifies which additional view's permissions to include in the response. Only 'published' is supported.
     */
    includePermissionsForView?: string;
    /**
     * Whether to include changes indicating that items have been removed from the list of changes, for example by deletion or loss of access.
     */
    includeRemoved?: boolean;
    /**
     * Deprecated: Use `includeItemsFromAllDrives` instead.
     */
    includeTeamDriveItems?: boolean;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The maximum number of changes to return per page.
     */
    pageSize?: number;
    /**
     * The token for continuing a previous list request on the next page. This should be set to the value of 'nextPageToken' from the previous response or to the response from the getStartPageToken method.
     */
    pageToken: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Whether to restrict the results to changes inside the My Drive hierarchy. This omits changes to files such as those in the Application Data folder or shared files which have not been added to My Drive.
     */
    restrictToMyDrive?: boolean;
    /**
     * A comma-separated list of spaces to query within the corpora. Supported values are 'drive' and 'appDataFolder'.
     */
    spaces?: string;
    /**
     * Whether the requesting application supports both My Drives and shared drives.
     */
    supportsAllDrives?: boolean;
    /**
     * Deprecated: Use `supportsAllDrives` instead.
     */
    supportsTeamDrives?: boolean;
    /**
     * Deprecated: Use `driveId` instead.
     */
    teamDriveId?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveChangesWatchResponse = Channel;

export type DriveChangesWatchError = unknown;

export type DriveChannelsStopData = {
  body?: Channel;
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveChannelsStopResponse = unknown;

export type DriveChannelsStopError = unknown;

export type DriveDrivesListData = {
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Maximum number of shared drives to return per page.
     */
    pageSize?: number;
    /**
     * Page token for shared drives.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Query string for searching shared drives.
     */
    q?: string;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
    /**
     * Issue the request as a domain administrator; if set to true, then all shared drives of the domain in which the requester is an administrator are returned.
     */
    useDomainAdminAccess?: boolean;
  };
};

export type DriveDrivesListResponse = DriveList;

export type DriveDrivesListError = unknown;

export type DriveDrivesCreateData = {
  body?: Drive;
  query: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Required. An ID, such as a random UUID, which uniquely identifies this user's request for idempotent creation of a shared drive. A repeated request by the same user and with the same request ID will avoid creating duplicates by attempting to create the same shared drive. If the shared drive already exists a 409 error will be returned.
     */
    requestId: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveDrivesCreateResponse = Drive;

export type DriveDrivesCreateError = unknown;

export type DriveDrivesDeleteData = {
  path: {
    /**
     * The ID of the shared drive.
     */
    driveId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Whether any items inside the shared drive should also be deleted. This option is only supported when `useDomainAdminAccess` is also set to `true`.
     */
    allowItemDeletion?: boolean;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
    /**
     * Issue the request as a domain administrator; if set to true, then the requester will be granted access if they are an administrator of the domain to which the shared drive belongs.
     */
    useDomainAdminAccess?: boolean;
  };
};

export type DriveDrivesDeleteResponse = unknown;

export type DriveDrivesDeleteError = unknown;

export type DriveDrivesGetData = {
  path: {
    /**
     * The ID of the shared drive.
     */
    driveId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
    /**
     * Issue the request as a domain administrator; if set to true, then the requester will be granted access if they are an administrator of the domain to which the shared drive belongs.
     */
    useDomainAdminAccess?: boolean;
  };
};

export type DriveDrivesGetResponse = Drive;

export type DriveDrivesGetError = unknown;

export type DriveDrivesUpdateData = {
  body?: Drive;
  path: {
    /**
     * The ID of the shared drive.
     */
    driveId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
    /**
     * Issue the request as a domain administrator; if set to true, then the requester will be granted access if they are an administrator of the domain to which the shared drive belongs.
     */
    useDomainAdminAccess?: boolean;
  };
};

export type DriveDrivesUpdateResponse = Drive;

export type DriveDrivesUpdateError = unknown;

export type DriveDrivesHideData = {
  path: {
    /**
     * The ID of the shared drive.
     */
    driveId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveDrivesHideResponse = Drive;

export type DriveDrivesHideError = unknown;

export type DriveDrivesUnhideData = {
  path: {
    /**
     * The ID of the shared drive.
     */
    driveId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveDrivesUnhideResponse = Drive;

export type DriveDrivesUnhideError = unknown;

export type DriveFilesListData = {
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Bodies of items (files/documents) to which the query applies. Supported bodies are 'user', 'domain', 'drive', and 'allDrives'. Prefer 'user' or 'drive' to 'allDrives' for efficiency. By default, corpora is set to 'user'. However, this can change depending on the filter set through the 'q' parameter.
     */
    corpora?: string;
    /**
     * Deprecated: The source of files to list. Use 'corpora' instead.
     */
    corpus?: 'domain' | 'user';
    /**
     * ID of the shared drive to search.
     */
    driveId?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * Whether both My Drive and shared drive items should be included in results.
     */
    includeItemsFromAllDrives?: boolean;
    /**
     * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
     */
    includeLabels?: string;
    /**
     * Specifies which additional view's permissions to include in the response. Only 'published' is supported.
     */
    includePermissionsForView?: string;
    /**
     * Deprecated: Use `includeItemsFromAllDrives` instead.
     */
    includeTeamDriveItems?: boolean;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * A comma-separated list of sort keys. Valid keys are 'createdTime', 'folder', 'modifiedByMeTime', 'modifiedTime', 'name', 'name_natural', 'quotaBytesUsed', 'recency', 'sharedWithMeTime', 'starred', and 'viewedByMeTime'. Each key sorts ascending by default, but can be reversed with the 'desc' modifier. Example usage: ?orderBy=folder,modifiedTime desc,name.
     */
    orderBy?: string;
    /**
     * The maximum number of files to return per page. Partial or empty result pages are possible even before the end of the files list has been reached.
     */
    pageSize?: number;
    /**
     * The token for continuing a previous list request on the next page. This should be set to the value of 'nextPageToken' from the previous response.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * A query for filtering the file results. See the "Search for files & folders" guide for supported syntax.
     */
    q?: string;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * A comma-separated list of spaces to query within the corpora. Supported values are 'drive' and 'appDataFolder'.
     */
    spaces?: string;
    /**
     * Whether the requesting application supports both My Drives and shared drives.
     */
    supportsAllDrives?: boolean;
    /**
     * Deprecated: Use `supportsAllDrives` instead.
     */
    supportsTeamDrives?: boolean;
    /**
     * Deprecated: Use `driveId` instead.
     */
    teamDriveId?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveFilesListResponse = FileList;

export type DriveFilesListError = unknown;

export type DriveFilesCreateData = {
  body?: File;
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Deprecated. Creating files in multiple folders is no longer supported.
     */
    enforceSingleParent?: boolean;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * Whether to ignore the domain's default visibility settings for the created file. Domain administrators can choose to make all uploaded files visible to the domain by default; this parameter bypasses that behavior for the request. Permissions are still inherited from parent folders.
     */
    ignoreDefaultVisibility?: boolean;
    /**
     * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
     */
    includeLabels?: string;
    /**
     * Specifies which additional view's permissions to include in the response. Only 'published' is supported.
     */
    includePermissionsForView?: string;
    /**
     * Whether to set the 'keepForever' field in the new head revision. This is only applicable to files with binary content in Google Drive. Only 200 revisions for the file can be kept forever. If the limit is reached, try deleting pinned revisions.
     */
    keepRevisionForever?: boolean;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * A language hint for OCR processing during image import (ISO 639-1 code).
     */
    ocrLanguage?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Whether the requesting application supports both My Drives and shared drives.
     */
    supportsAllDrives?: boolean;
    /**
     * Deprecated: Use `supportsAllDrives` instead.
     */
    supportsTeamDrives?: boolean;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
    /**
     * Whether to use the uploaded content as indexable text.
     */
    useContentAsIndexableText?: boolean;
  };
};

export type DriveFilesCreateResponse = File;

export type DriveFilesCreateError = unknown;

export type DriveFilesGenerateIdsData = {
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * The number of IDs to return.
     */
    count?: number;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * The space in which the IDs can be used to create new files. Supported values are 'drive' and 'appDataFolder'. (Default: 'drive')
     */
    space?: string;
    /**
     * The type of items which the IDs can be used for. Supported values are 'files' and 'shortcuts'. Note that 'shortcuts' are only supported in the `drive` 'space'. (Default: 'files')
     */
    type?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveFilesGenerateIdsResponse = GeneratedIds;

export type DriveFilesGenerateIdsError = unknown;

export type DriveFilesEmptyTrashData = {
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * If set, empties the trash of the provided shared drive.
     */
    driveId?: string;
    /**
     * Deprecated: If an item is not in a shared drive and its last parent is deleted but the item itself is not, the item will be placed under its owner's root.
     */
    enforceSingleParent?: boolean;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveFilesEmptyTrashResponse = unknown;

export type DriveFilesEmptyTrashError = unknown;

export type DriveFilesDeleteData = {
  path: {
    /**
     * The ID of the file.
     */
    fileId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Deprecated: If an item is not in a shared drive and its last parent is deleted but the item itself is not, the item will be placed under its owner's root.
     */
    enforceSingleParent?: boolean;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Whether the requesting application supports both My Drives and shared drives.
     */
    supportsAllDrives?: boolean;
    /**
     * Deprecated: Use `supportsAllDrives` instead.
     */
    supportsTeamDrives?: boolean;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveFilesDeleteResponse = unknown;

export type DriveFilesDeleteError = unknown;

export type DriveFilesGetData = {
  path: {
    /**
     * The ID of the file.
     */
    fileId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Whether the user is acknowledging the risk of downloading known malware or other abusive files. This is only applicable when alt=media.
     */
    acknowledgeAbuse?: boolean;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
     */
    includeLabels?: string;
    /**
     * Specifies which additional view's permissions to include in the response. Only 'published' is supported.
     */
    includePermissionsForView?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Whether the requesting application supports both My Drives and shared drives.
     */
    supportsAllDrives?: boolean;
    /**
     * Deprecated: Use `supportsAllDrives` instead.
     */
    supportsTeamDrives?: boolean;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveFilesGetResponse = File;

export type DriveFilesGetError = unknown;

export type DriveFilesUpdateData = {
  body?: File;
  path: {
    /**
     * The ID of the file.
     */
    fileId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * A comma-separated list of parent IDs to add.
     */
    addParents?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Deprecated: Adding files to multiple folders is no longer supported. Use shortcuts instead.
     */
    enforceSingleParent?: boolean;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
     */
    includeLabels?: string;
    /**
     * Specifies which additional view's permissions to include in the response. Only 'published' is supported.
     */
    includePermissionsForView?: string;
    /**
     * Whether to set the 'keepForever' field in the new head revision. This is only applicable to files with binary content in Google Drive. Only 200 revisions for the file can be kept forever. If the limit is reached, try deleting pinned revisions.
     */
    keepRevisionForever?: boolean;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * A language hint for OCR processing during image import (ISO 639-1 code).
     */
    ocrLanguage?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * A comma-separated list of parent IDs to remove.
     */
    removeParents?: string;
    /**
     * Whether the requesting application supports both My Drives and shared drives.
     */
    supportsAllDrives?: boolean;
    /**
     * Deprecated: Use `supportsAllDrives` instead.
     */
    supportsTeamDrives?: boolean;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
    /**
     * Whether to use the uploaded content as indexable text.
     */
    useContentAsIndexableText?: boolean;
  };
};

export type DriveFilesUpdateResponse = File;

export type DriveFilesUpdateError = unknown;

export type DriveCommentsListData = {
  path: {
    /**
     * The ID of the file.
     */
    fileId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * Whether to include deleted comments. Deleted comments will not include their original content.
     */
    includeDeleted?: boolean;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The maximum number of comments to return per page.
     */
    pageSize?: number;
    /**
     * The token for continuing a previous list request on the next page. This should be set to the value of 'nextPageToken' from the previous response.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * The minimum value of 'modifiedTime' for the result comments (RFC 3339 date-time).
     */
    startModifiedTime?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveCommentsListResponse = CommentList;

export type DriveCommentsListError = unknown;

export type DriveCommentsCreateData = {
  body?: Comment;
  path: {
    /**
     * The ID of the file.
     */
    fileId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveCommentsCreateResponse = Comment;

export type DriveCommentsCreateError = unknown;

export type DriveCommentsDeleteData = {
  path: {
    /**
     * The ID of the comment.
     */
    commentId: string;
    /**
     * The ID of the file.
     */
    fileId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveCommentsDeleteResponse = unknown;

export type DriveCommentsDeleteError = unknown;

export type DriveCommentsGetData = {
  path: {
    /**
     * The ID of the comment.
     */
    commentId: string;
    /**
     * The ID of the file.
     */
    fileId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * Whether to return deleted comments. Deleted comments will not include their original content.
     */
    includeDeleted?: boolean;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveCommentsGetResponse = Comment;

export type DriveCommentsGetError = unknown;

export type DriveCommentsUpdateData = {
  body?: Comment;
  path: {
    /**
     * The ID of the comment.
     */
    commentId: string;
    /**
     * The ID of the file.
     */
    fileId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveCommentsUpdateResponse = Comment;

export type DriveCommentsUpdateError = unknown;

export type DriveRepliesListData = {
  path: {
    /**
     * The ID of the comment.
     */
    commentId: string;
    /**
     * The ID of the file.
     */
    fileId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * Whether to include deleted replies. Deleted replies will not include their original content.
     */
    includeDeleted?: boolean;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The maximum number of replies to return per page.
     */
    pageSize?: number;
    /**
     * The token for continuing a previous list request on the next page. This should be set to the value of 'nextPageToken' from the previous response.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveRepliesListResponse = ReplyList;

export type DriveRepliesListError = unknown;

export type DriveRepliesCreateData = {
  body?: Reply;
  path: {
    /**
     * The ID of the comment.
     */
    commentId: string;
    /**
     * The ID of the file.
     */
    fileId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveRepliesCreateResponse = Reply;

export type DriveRepliesCreateError = unknown;

export type DriveRepliesDeleteData = {
  path: {
    /**
     * The ID of the comment.
     */
    commentId: string;
    /**
     * The ID of the file.
     */
    fileId: string;
    /**
     * The ID of the reply.
     */
    replyId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveRepliesDeleteResponse = unknown;

export type DriveRepliesDeleteError = unknown;

export type DriveRepliesGetData = {
  path: {
    /**
     * The ID of the comment.
     */
    commentId: string;
    /**
     * The ID of the file.
     */
    fileId: string;
    /**
     * The ID of the reply.
     */
    replyId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * Whether to return deleted replies. Deleted replies will not include their original content.
     */
    includeDeleted?: boolean;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveRepliesGetResponse = Reply;

export type DriveRepliesGetError = unknown;

export type DriveRepliesUpdateData = {
  body?: Reply;
  path: {
    /**
     * The ID of the comment.
     */
    commentId: string;
    /**
     * The ID of the file.
     */
    fileId: string;
    /**
     * The ID of the reply.
     */
    replyId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveRepliesUpdateResponse = Reply;

export type DriveRepliesUpdateError = unknown;

export type DriveFilesCopyData = {
  body?: File;
  path: {
    /**
     * The ID of the file.
     */
    fileId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Deprecated. Copying files into multiple folders is no longer supported. Use shortcuts instead.
     */
    enforceSingleParent?: boolean;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * Whether to ignore the domain's default visibility settings for the created file. Domain administrators can choose to make all uploaded files visible to the domain by default; this parameter bypasses that behavior for the request. Permissions are still inherited from parent folders.
     */
    ignoreDefaultVisibility?: boolean;
    /**
     * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
     */
    includeLabels?: string;
    /**
     * Specifies which additional view's permissions to include in the response. Only 'published' is supported.
     */
    includePermissionsForView?: string;
    /**
     * Whether to set the 'keepForever' field in the new head revision. This is only applicable to files with binary content in Google Drive. Only 200 revisions for the file can be kept forever. If the limit is reached, try deleting pinned revisions.
     */
    keepRevisionForever?: boolean;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * A language hint for OCR processing during image import (ISO 639-1 code).
     */
    ocrLanguage?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Whether the requesting application supports both My Drives and shared drives.
     */
    supportsAllDrives?: boolean;
    /**
     * Deprecated: Use `supportsAllDrives` instead.
     */
    supportsTeamDrives?: boolean;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveFilesCopyResponse = File;

export type DriveFilesCopyError = unknown;

export type DriveFilesExportData = {
  path: {
    /**
     * The ID of the file.
     */
    fileId: string;
  };
  query: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * Required. The MIME type of the format requested for this export.
     */
    mimeType: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveFilesExportResponse = unknown;

export type DriveFilesExportError = unknown;

export type DriveFilesListLabelsData = {
  path: {
    /**
     * The ID for the file.
     */
    fileId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * The maximum number of labels to return per page. When not set, defaults to 100.
     */
    maxResults?: number;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The token for continuing a previous list request on the next page. This should be set to the value of 'nextPageToken' from the previous response.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveFilesListLabelsResponse = LabelList;

export type DriveFilesListLabelsError = unknown;

export type DriveFilesModifyLabelsData = {
  body?: ModifyLabelsRequest;
  path: {
    /**
     * The ID of the file to which the labels belong.
     */
    fileId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveFilesModifyLabelsResponse = ModifyLabelsResponse;

export type DriveFilesModifyLabelsError = unknown;

export type DrivePermissionsListData = {
  path: {
    /**
     * The ID of the file or shared drive.
     */
    fileId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * Specifies which additional view's permissions to include in the response. Only 'published' is supported.
     */
    includePermissionsForView?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The maximum number of permissions to return per page. When not set for files in a shared drive, at most 100 results will be returned. When not set for files that are not in a shared drive, the entire list will be returned.
     */
    pageSize?: number;
    /**
     * The token for continuing a previous list request on the next page. This should be set to the value of 'nextPageToken' from the previous response.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Whether the requesting application supports both My Drives and shared drives.
     */
    supportsAllDrives?: boolean;
    /**
     * Deprecated: Use `supportsAllDrives` instead.
     */
    supportsTeamDrives?: boolean;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
    /**
     * Issue the request as a domain administrator; if set to true, then the requester will be granted access if the file ID parameter refers to a shared drive and the requester is an administrator of the domain to which the shared drive belongs.
     */
    useDomainAdminAccess?: boolean;
  };
};

export type DrivePermissionsListResponse = PermissionList;

export type DrivePermissionsListError = unknown;

export type DrivePermissionsCreateData = {
  body?: Permission;
  path: {
    /**
     * The ID of the file or shared drive.
     */
    fileId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * A plain text custom message to include in the notification email.
     */
    emailMessage?: string;
    /**
     * Deprecated: See `moveToNewOwnersRoot` for details.
     */
    enforceSingleParent?: boolean;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * This parameter will only take effect if the item is not in a shared drive and the request is attempting to transfer the ownership of the item. If set to `true`, the item will be moved to the new owner's My Drive root folder and all prior parents removed. If set to `false`, parents are not changed.
     */
    moveToNewOwnersRoot?: boolean;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Whether to send a notification email when sharing to users or groups. This defaults to true for users and groups, and is not allowed for other requests. It must not be disabled for ownership transfers.
     */
    sendNotificationEmail?: boolean;
    /**
     * Whether the requesting application supports both My Drives and shared drives.
     */
    supportsAllDrives?: boolean;
    /**
     * Deprecated: Use `supportsAllDrives` instead.
     */
    supportsTeamDrives?: boolean;
    /**
     * Whether to transfer ownership to the specified user and downgrade the current owner to a writer. This parameter is required as an acknowledgement of the side effect.
     */
    transferOwnership?: boolean;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
    /**
     * Issue the request as a domain administrator; if set to true, then the requester will be granted access if the file ID parameter refers to a shared drive and the requester is an administrator of the domain to which the shared drive belongs.
     */
    useDomainAdminAccess?: boolean;
  };
};

export type DrivePermissionsCreateResponse = Permission;

export type DrivePermissionsCreateError = unknown;

export type DrivePermissionsDeleteData = {
  path: {
    /**
     * The ID of the file or shared drive.
     */
    fileId: string;
    /**
     * The ID of the permission.
     */
    permissionId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Whether the requesting application supports both My Drives and shared drives.
     */
    supportsAllDrives?: boolean;
    /**
     * Deprecated: Use `supportsAllDrives` instead.
     */
    supportsTeamDrives?: boolean;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
    /**
     * Issue the request as a domain administrator; if set to true, then the requester will be granted access if the file ID parameter refers to a shared drive and the requester is an administrator of the domain to which the shared drive belongs.
     */
    useDomainAdminAccess?: boolean;
  };
};

export type DrivePermissionsDeleteResponse = unknown;

export type DrivePermissionsDeleteError = unknown;

export type DrivePermissionsGetData = {
  path: {
    /**
     * The ID of the file.
     */
    fileId: string;
    /**
     * The ID of the permission.
     */
    permissionId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Whether the requesting application supports both My Drives and shared drives.
     */
    supportsAllDrives?: boolean;
    /**
     * Deprecated: Use `supportsAllDrives` instead.
     */
    supportsTeamDrives?: boolean;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
    /**
     * Issue the request as a domain administrator; if set to true, then the requester will be granted access if the file ID parameter refers to a shared drive and the requester is an administrator of the domain to which the shared drive belongs.
     */
    useDomainAdminAccess?: boolean;
  };
};

export type DrivePermissionsGetResponse = Permission;

export type DrivePermissionsGetError = unknown;

export type DrivePermissionsUpdateData = {
  body?: Permission;
  path: {
    /**
     * The ID of the file or shared drive.
     */
    fileId: string;
    /**
     * The ID of the permission.
     */
    permissionId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Whether to remove the expiration date.
     */
    removeExpiration?: boolean;
    /**
     * Whether the requesting application supports both My Drives and shared drives.
     */
    supportsAllDrives?: boolean;
    /**
     * Deprecated: Use `supportsAllDrives` instead.
     */
    supportsTeamDrives?: boolean;
    /**
     * Whether to transfer ownership to the specified user and downgrade the current owner to a writer. This parameter is required as an acknowledgement of the side effect.
     */
    transferOwnership?: boolean;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
    /**
     * Issue the request as a domain administrator; if set to true, then the requester will be granted access if the file ID parameter refers to a shared drive and the requester is an administrator of the domain to which the shared drive belongs.
     */
    useDomainAdminAccess?: boolean;
  };
};

export type DrivePermissionsUpdateResponse = Permission;

export type DrivePermissionsUpdateError = unknown;

export type DriveRevisionsListData = {
  path: {
    /**
     * The ID of the file.
     */
    fileId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The maximum number of revisions to return per page.
     */
    pageSize?: number;
    /**
     * The token for continuing a previous list request on the next page. This should be set to the value of 'nextPageToken' from the previous response.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveRevisionsListResponse = RevisionList;

export type DriveRevisionsListError = unknown;

export type DriveRevisionsDeleteData = {
  path: {
    /**
     * The ID of the file.
     */
    fileId: string;
    /**
     * The ID of the revision.
     */
    revisionId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveRevisionsDeleteResponse = unknown;

export type DriveRevisionsDeleteError = unknown;

export type DriveRevisionsGetData = {
  path: {
    /**
     * The ID of the file.
     */
    fileId: string;
    /**
     * The ID of the revision.
     */
    revisionId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Whether the user is acknowledging the risk of downloading known malware or other abusive files. This is only applicable when alt=media.
     */
    acknowledgeAbuse?: boolean;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveRevisionsGetResponse = Revision;

export type DriveRevisionsGetError = unknown;

export type DriveRevisionsUpdateData = {
  body?: Revision;
  path: {
    /**
     * The ID of the file.
     */
    fileId: string;
    /**
     * The ID of the revision.
     */
    revisionId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveRevisionsUpdateResponse = Revision;

export type DriveRevisionsUpdateError = unknown;

export type DriveFilesWatchData = {
  body?: Channel;
  path: {
    /**
     * The ID of the file.
     */
    fileId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Whether the user is acknowledging the risk of downloading known malware or other abusive files. This is only applicable when alt=media.
     */
    acknowledgeAbuse?: boolean;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * A comma-separated list of IDs of labels to include in the `labelInfo` part of the response.
     */
    includeLabels?: string;
    /**
     * Specifies which additional view's permissions to include in the response. Only 'published' is supported.
     */
    includePermissionsForView?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Whether the requesting application supports both My Drives and shared drives.
     */
    supportsAllDrives?: boolean;
    /**
     * Deprecated: Use `supportsAllDrives` instead.
     */
    supportsTeamDrives?: boolean;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveFilesWatchResponse = Channel;

export type DriveFilesWatchError = unknown;

export type DriveTeamdrivesListData = {
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Maximum number of Team Drives to return.
     */
    pageSize?: number;
    /**
     * Page token for Team Drives.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Query string for searching Team Drives.
     */
    q?: string;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
    /**
     * Issue the request as a domain administrator; if set to true, then all Team Drives of the domain in which the requester is an administrator are returned.
     */
    useDomainAdminAccess?: boolean;
  };
};

export type DriveTeamdrivesListResponse = TeamDriveList;

export type DriveTeamdrivesListError = unknown;

export type DriveTeamdrivesCreateData = {
  body?: TeamDrive;
  query: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Required. An ID, such as a random UUID, which uniquely identifies this user's request for idempotent creation of a Team Drive. A repeated request by the same user and with the same request ID will avoid creating duplicates by attempting to create the same Team Drive. If the Team Drive already exists a 409 error will be returned.
     */
    requestId: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveTeamdrivesCreateResponse = TeamDrive;

export type DriveTeamdrivesCreateError = unknown;

export type DriveTeamdrivesDeleteData = {
  path: {
    /**
     * The ID of the Team Drive
     */
    teamDriveId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type DriveTeamdrivesDeleteResponse = unknown;

export type DriveTeamdrivesDeleteError = unknown;

export type DriveTeamdrivesGetData = {
  path: {
    /**
     * The ID of the Team Drive
     */
    teamDriveId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
    /**
     * Issue the request as a domain administrator; if set to true, then the requester will be granted access if they are an administrator of the domain to which the Team Drive belongs.
     */
    useDomainAdminAccess?: boolean;
  };
};

export type DriveTeamdrivesGetResponse = TeamDrive;

export type DriveTeamdrivesGetError = unknown;

export type DriveTeamdrivesUpdateData = {
  body?: TeamDrive;
  path: {
    /**
     * The ID of the Team Drive
     */
    teamDriveId: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
    /**
     * Issue the request as a domain administrator; if set to true, then the requester will be granted access if they are an administrator of the domain to which the Team Drive belongs.
     */
    useDomainAdminAccess?: boolean;
  };
};

export type DriveTeamdrivesUpdateResponse = TeamDrive;

export type DriveTeamdrivesUpdateError = unknown;
