// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  DriveAboutGetData,
  DriveAboutGetError,
  DriveAboutGetResponse,
  DriveAppsListData,
  DriveAppsListError,
  DriveAppsListResponse,
  DriveAppsGetData,
  DriveAppsGetError,
  DriveAppsGetResponse,
  DriveChangesListData,
  DriveChangesListError,
  DriveChangesListResponse,
  DriveChangesGetStartPageTokenData,
  DriveChangesGetStartPageTokenError,
  DriveChangesGetStartPageTokenResponse,
  DriveChangesWatchData,
  DriveChangesWatchError,
  DriveChangesWatchResponse,
  DriveChannelsStopData,
  DriveChannelsStopError,
  DriveChannelsStopResponse,
  DriveDrivesListData,
  DriveDrivesListError,
  DriveDrivesListResponse,
  DriveDrivesCreateData,
  DriveDrivesCreateError,
  DriveDrivesCreateResponse,
  DriveDrivesDeleteData,
  DriveDrivesDeleteError,
  DriveDrivesDeleteResponse,
  DriveDrivesGetData,
  DriveDrivesGetError,
  DriveDrivesGetResponse,
  DriveDrivesUpdateData,
  DriveDrivesUpdateError,
  DriveDrivesUpdateResponse,
  DriveDrivesHideData,
  DriveDrivesHideError,
  DriveDrivesHideResponse,
  DriveDrivesUnhideData,
  DriveDrivesUnhideError,
  DriveDrivesUnhideResponse,
  DriveFilesListData,
  DriveFilesListError,
  DriveFilesListResponse,
  DriveFilesCreateData,
  DriveFilesCreateError,
  DriveFilesCreateResponse,
  DriveFilesGenerateIdsData,
  DriveFilesGenerateIdsError,
  DriveFilesGenerateIdsResponse,
  DriveFilesEmptyTrashData,
  DriveFilesEmptyTrashError,
  DriveFilesEmptyTrashResponse,
  DriveFilesDeleteData,
  DriveFilesDeleteError,
  DriveFilesDeleteResponse,
  DriveFilesGetData,
  DriveFilesGetError,
  DriveFilesGetResponse,
  DriveFilesUpdateData,
  DriveFilesUpdateError,
  DriveFilesUpdateResponse,
  DriveCommentsListData,
  DriveCommentsListError,
  DriveCommentsListResponse,
  DriveCommentsCreateData,
  DriveCommentsCreateError,
  DriveCommentsCreateResponse,
  DriveCommentsDeleteData,
  DriveCommentsDeleteError,
  DriveCommentsDeleteResponse,
  DriveCommentsGetData,
  DriveCommentsGetError,
  DriveCommentsGetResponse,
  DriveCommentsUpdateData,
  DriveCommentsUpdateError,
  DriveCommentsUpdateResponse,
  DriveRepliesListData,
  DriveRepliesListError,
  DriveRepliesListResponse,
  DriveRepliesCreateData,
  DriveRepliesCreateError,
  DriveRepliesCreateResponse,
  DriveRepliesDeleteData,
  DriveRepliesDeleteError,
  DriveRepliesDeleteResponse,
  DriveRepliesGetData,
  DriveRepliesGetError,
  DriveRepliesGetResponse,
  DriveRepliesUpdateData,
  DriveRepliesUpdateError,
  DriveRepliesUpdateResponse,
  DriveFilesCopyData,
  DriveFilesCopyError,
  DriveFilesCopyResponse,
  DriveFilesExportData,
  DriveFilesExportError,
  DriveFilesExportResponse,
  DriveFilesListLabelsData,
  DriveFilesListLabelsError,
  DriveFilesListLabelsResponse,
  DriveFilesModifyLabelsData,
  DriveFilesModifyLabelsError,
  DriveFilesModifyLabelsResponse,
  DrivePermissionsListData,
  DrivePermissionsListError,
  DrivePermissionsListResponse,
  DrivePermissionsCreateData,
  DrivePermissionsCreateError,
  DrivePermissionsCreateResponse,
  DrivePermissionsDeleteData,
  DrivePermissionsDeleteError,
  DrivePermissionsDeleteResponse,
  DrivePermissionsGetData,
  DrivePermissionsGetError,
  DrivePermissionsGetResponse,
  DrivePermissionsUpdateData,
  DrivePermissionsUpdateError,
  DrivePermissionsUpdateResponse,
  DriveRevisionsListData,
  DriveRevisionsListError,
  DriveRevisionsListResponse,
  DriveRevisionsDeleteData,
  DriveRevisionsDeleteError,
  DriveRevisionsDeleteResponse,
  DriveRevisionsGetData,
  DriveRevisionsGetError,
  DriveRevisionsGetResponse,
  DriveRevisionsUpdateData,
  DriveRevisionsUpdateError,
  DriveRevisionsUpdateResponse,
  DriveFilesWatchData,
  DriveFilesWatchError,
  DriveFilesWatchResponse,
  DriveTeamdrivesListData,
  DriveTeamdrivesListError,
  DriveTeamdrivesListResponse,
  DriveTeamdrivesCreateData,
  DriveTeamdrivesCreateError,
  DriveTeamdrivesCreateResponse,
  DriveTeamdrivesDeleteData,
  DriveTeamdrivesDeleteError,
  DriveTeamdrivesDeleteResponse,
  DriveTeamdrivesGetData,
  DriveTeamdrivesGetError,
  DriveTeamdrivesGetResponse,
  DriveTeamdrivesUpdateData,
  DriveTeamdrivesUpdateError,
  DriveTeamdrivesUpdateResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Gets information about the user, the user's Drive, and system capabilities.
 */
export const driveAboutGet = <ThrowOnError extends boolean = false>(
  options?: Options<DriveAboutGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveAboutGetResponse, DriveAboutGetError, ThrowOnError>({
    ...options,
    url: '/about',
  });
};

/**
 * Lists a user's installed apps.
 */
export const driveAppsList = <ThrowOnError extends boolean = false>(
  options?: Options<DriveAppsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveAppsListResponse, DriveAppsListError, ThrowOnError>({
    ...options,
    url: '/apps',
  });
};

/**
 * Gets a specific app.
 */
export const driveAppsGet = <ThrowOnError extends boolean = false>(
  options: Options<DriveAppsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveAppsGetResponse, DriveAppsGetError, ThrowOnError>({
    ...options,
    url: '/apps/{appId}',
  });
};

/**
 * Lists the changes for a user or shared drive.
 */
export const driveChangesList = <ThrowOnError extends boolean = false>(
  options: Options<DriveChangesListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveChangesListResponse, DriveChangesListError, ThrowOnError>({
    ...options,
    url: '/changes',
  });
};

/**
 * Gets the starting pageToken for listing future changes.
 */
export const driveChangesGetStartPageToken = <ThrowOnError extends boolean = false>(
  options?: Options<DriveChangesGetStartPageTokenData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    DriveChangesGetStartPageTokenResponse,
    DriveChangesGetStartPageTokenError,
    ThrowOnError
  >({
    ...options,
    url: '/changes/startPageToken',
  });
};

/**
 * Subscribes to changes for a user.
 */
export const driveChangesWatch = <ThrowOnError extends boolean = false>(
  options: Options<DriveChangesWatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DriveChangesWatchResponse, DriveChangesWatchError, ThrowOnError>({
    ...options,
    url: '/changes/watch',
  });
};

/**
 * Stops watching resources through this channel.
 */
export const driveChannelsStop = <ThrowOnError extends boolean = false>(
  options?: Options<DriveChannelsStopData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DriveChannelsStopResponse, DriveChannelsStopError, ThrowOnError>({
    ...options,
    url: '/channels/stop',
  });
};

/**
 *  Lists the user's shared drives. This method accepts the `q` parameter, which is a search query combining one or more search terms. For more information, see the [Search for shared drives](/drive/api/guides/search-shareddrives) guide.
 */
export const driveDrivesList = <ThrowOnError extends boolean = false>(
  options?: Options<DriveDrivesListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveDrivesListResponse, DriveDrivesListError, ThrowOnError>({
    ...options,
    url: '/drives',
  });
};

/**
 * Creates a shared drive.
 */
export const driveDrivesCreate = <ThrowOnError extends boolean = false>(
  options: Options<DriveDrivesCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DriveDrivesCreateResponse, DriveDrivesCreateError, ThrowOnError>({
    ...options,
    url: '/drives',
  });
};

/**
 * Permanently deletes a shared drive for which the user is an `organizer`. The shared drive cannot contain any untrashed items.
 */
export const driveDrivesDelete = <ThrowOnError extends boolean = false>(
  options: Options<DriveDrivesDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DriveDrivesDeleteResponse, DriveDrivesDeleteError, ThrowOnError>({
    ...options,
    url: '/drives/{driveId}',
  });
};

/**
 * Gets a shared drive's metadata by ID.
 */
export const driveDrivesGet = <ThrowOnError extends boolean = false>(
  options: Options<DriveDrivesGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveDrivesGetResponse, DriveDrivesGetError, ThrowOnError>({
    ...options,
    url: '/drives/{driveId}',
  });
};

/**
 * Updates the metadate for a shared drive.
 */
export const driveDrivesUpdate = <ThrowOnError extends boolean = false>(
  options: Options<DriveDrivesUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<DriveDrivesUpdateResponse, DriveDrivesUpdateError, ThrowOnError>({
    ...options,
    url: '/drives/{driveId}',
  });
};

/**
 * Hides a shared drive from the default view.
 */
export const driveDrivesHide = <ThrowOnError extends boolean = false>(
  options: Options<DriveDrivesHideData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DriveDrivesHideResponse, DriveDrivesHideError, ThrowOnError>({
    ...options,
    url: '/drives/{driveId}/hide',
  });
};

/**
 * Restores a shared drive to the default view.
 */
export const driveDrivesUnhide = <ThrowOnError extends boolean = false>(
  options: Options<DriveDrivesUnhideData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DriveDrivesUnhideResponse, DriveDrivesUnhideError, ThrowOnError>({
    ...options,
    url: '/drives/{driveId}/unhide',
  });
};

/**
 *  Lists the user's files. This method accepts the `q` parameter, which is a search query combining one or more search terms. For more information, see the [Search for files & folders](/drive/api/guides/search-files) guide. *Note:* This method returns *all* files by default, including trashed files. If you don't want trashed files to appear in the list, use the `trashed=false` query parameter to remove trashed files from the results.
 */
export const driveFilesList = <ThrowOnError extends boolean = false>(
  options?: Options<DriveFilesListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveFilesListResponse, DriveFilesListError, ThrowOnError>({
    ...options,
    url: '/files',
  });
};

/**
 *  Creates a new file. This method supports an *upload* URI and accepts uploaded media with the following characteristics: - *Maximum file size:* 5,120 GB - *Accepted Media MIME types:*`**` Note: Specify a valid MIME type, rather than the literal `**` value. The literal `**` is only used to indicate that any valid MIME type can be uploaded. For more information on uploading files, see [Upload file data](/drive/api/guides/manage-uploads). Apps creating shortcuts with `files.create` must specify the MIME type `application/vnd.google-apps.shortcut`. Apps should specify a file extension in the `name` property when inserting files with the API. For example, an operation to insert a JPEG file should specify something like `"name": "cat.jpg"` in the metadata. Subsequent `GET` requests include the read-only `fileExtension` property populated with the extension originally specified in the `title` property. When a Google Drive user requests to download a file, or when the file is downloaded through the sync client, Drive builds a full filename (with extension) based on the title. In cases where the extension is missing, Drive attempts to determine the extension based on the file's MIME type.
 */
export const driveFilesCreate = <ThrowOnError extends boolean = false>(
  options?: Options<DriveFilesCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DriveFilesCreateResponse, DriveFilesCreateError, ThrowOnError>({
    ...options,
    url: '/files',
  });
};

/**
 * Generates a set of file IDs which can be provided in create or copy requests.
 */
export const driveFilesGenerateIds = <ThrowOnError extends boolean = false>(
  options?: Options<DriveFilesGenerateIdsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveFilesGenerateIdsResponse, DriveFilesGenerateIdsError, ThrowOnError>({
    ...options,
    url: '/files/generateIds',
  });
};

/**
 * Permanently deletes all of the user's trashed files.
 */
export const driveFilesEmptyTrash = <ThrowOnError extends boolean = false>(
  options?: Options<DriveFilesEmptyTrashData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DriveFilesEmptyTrashResponse, DriveFilesEmptyTrashError, ThrowOnError>({
    ...options,
    url: '/files/trash',
  });
};

/**
 * Permanently deletes a file owned by the user without moving it to the trash. If the file belongs to a shared drive, the user must be an `organizer` on the parent folder. If the target is a folder, all descendants owned by the user are also deleted.
 */
export const driveFilesDelete = <ThrowOnError extends boolean = false>(
  options: Options<DriveFilesDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DriveFilesDeleteResponse, DriveFilesDeleteError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}',
  });
};

/**
 *  Gets a file's metadata or content by ID. If you provide the URL parameter `alt=media`, then the response includes the file contents in the response body. Downloading content with `alt=media` only works if the file is stored in Drive. To download Google Docs, Sheets, and Slides use [`files.export`](/drive/api/reference/rest/v3/files/export) instead. For more information, see [Download & export files](/drive/api/guides/manage-downloads).
 */
export const driveFilesGet = <ThrowOnError extends boolean = false>(
  options: Options<DriveFilesGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveFilesGetResponse, DriveFilesGetError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}',
  });
};

/**
 *  Updates a file's metadata and/or content. When calling this method, only populate fields in the request that you want to modify. When updating fields, some fields might be changed automatically, such as `modifiedDate`. This method supports patch semantics. This method supports an *upload* URI and accepts uploaded media with the following characteristics: - *Maximum file size:* 5,120 GB - *Accepted Media MIME types:*`**` Note: Specify a valid MIME type, rather than the literal `**` value. The literal `**` is only used to indicate that any valid MIME type can be uploaded. For more information on uploading files, see [Upload file data](/drive/api/guides/manage-uploads).
 */
export const driveFilesUpdate = <ThrowOnError extends boolean = false>(
  options: Options<DriveFilesUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<DriveFilesUpdateResponse, DriveFilesUpdateError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}',
  });
};

/**
 * Lists a file's comments.
 */
export const driveCommentsList = <ThrowOnError extends boolean = false>(
  options: Options<DriveCommentsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveCommentsListResponse, DriveCommentsListError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/comments',
  });
};

/**
 * Creates a comment on a file.
 */
export const driveCommentsCreate = <ThrowOnError extends boolean = false>(
  options: Options<DriveCommentsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DriveCommentsCreateResponse, DriveCommentsCreateError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/comments',
  });
};

/**
 * Deletes a comment.
 */
export const driveCommentsDelete = <ThrowOnError extends boolean = false>(
  options: Options<DriveCommentsDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DriveCommentsDeleteResponse, DriveCommentsDeleteError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/comments/{commentId}',
  });
};

/**
 * Gets a comment by ID.
 */
export const driveCommentsGet = <ThrowOnError extends boolean = false>(
  options: Options<DriveCommentsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveCommentsGetResponse, DriveCommentsGetError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/comments/{commentId}',
  });
};

/**
 * Updates a comment with patch semantics.
 */
export const driveCommentsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<DriveCommentsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<DriveCommentsUpdateResponse, DriveCommentsUpdateError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/comments/{commentId}',
  });
};

/**
 * Lists a comment's replies.
 */
export const driveRepliesList = <ThrowOnError extends boolean = false>(
  options: Options<DriveRepliesListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveRepliesListResponse, DriveRepliesListError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/comments/{commentId}/replies',
  });
};

/**
 * Creates a reply to a comment.
 */
export const driveRepliesCreate = <ThrowOnError extends boolean = false>(
  options: Options<DriveRepliesCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DriveRepliesCreateResponse, DriveRepliesCreateError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/comments/{commentId}/replies',
  });
};

/**
 * Deletes a reply.
 */
export const driveRepliesDelete = <ThrowOnError extends boolean = false>(
  options: Options<DriveRepliesDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DriveRepliesDeleteResponse, DriveRepliesDeleteError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/comments/{commentId}/replies/{replyId}',
  });
};

/**
 * Gets a reply by ID.
 */
export const driveRepliesGet = <ThrowOnError extends boolean = false>(
  options: Options<DriveRepliesGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveRepliesGetResponse, DriveRepliesGetError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/comments/{commentId}/replies/{replyId}',
  });
};

/**
 * Updates a reply with patch semantics.
 */
export const driveRepliesUpdate = <ThrowOnError extends boolean = false>(
  options: Options<DriveRepliesUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<DriveRepliesUpdateResponse, DriveRepliesUpdateError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/comments/{commentId}/replies/{replyId}',
  });
};

/**
 * Creates a copy of a file and applies any requested updates with patch semantics.
 */
export const driveFilesCopy = <ThrowOnError extends boolean = false>(
  options: Options<DriveFilesCopyData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DriveFilesCopyResponse, DriveFilesCopyError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/copy',
  });
};

/**
 * Exports a Google Workspace document to the requested MIME type and returns exported byte content. Note that the exported content is limited to 10MB.
 */
export const driveFilesExport = <ThrowOnError extends boolean = false>(
  options: Options<DriveFilesExportData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveFilesExportResponse, DriveFilesExportError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/export',
  });
};

/**
 * Lists the labels on a file.
 */
export const driveFilesListLabels = <ThrowOnError extends boolean = false>(
  options: Options<DriveFilesListLabelsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveFilesListLabelsResponse, DriveFilesListLabelsError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/listLabels',
  });
};

/**
 * Modifies the set of labels applied to a file. Returns a list of the labels that were added or modified.
 */
export const driveFilesModifyLabels = <ThrowOnError extends boolean = false>(
  options: Options<DriveFilesModifyLabelsData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DriveFilesModifyLabelsResponse, DriveFilesModifyLabelsError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/modifyLabels',
  });
};

/**
 * Lists a file's or shared drive's permissions.
 */
export const drivePermissionsList = <ThrowOnError extends boolean = false>(
  options: Options<DrivePermissionsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DrivePermissionsListResponse, DrivePermissionsListError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/permissions',
  });
};

/**
 * Creates a permission for a file or shared drive. **Warning:** Concurrent permissions operations on the same file are not supported; only the last update is applied.
 */
export const drivePermissionsCreate = <ThrowOnError extends boolean = false>(
  options: Options<DrivePermissionsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DrivePermissionsCreateResponse, DrivePermissionsCreateError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/permissions',
  });
};

/**
 * Deletes a permission. **Warning:** Concurrent permissions operations on the same file are not supported; only the last update is applied.
 */
export const drivePermissionsDelete = <ThrowOnError extends boolean = false>(
  options: Options<DrivePermissionsDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DrivePermissionsDeleteResponse, DrivePermissionsDeleteError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/permissions/{permissionId}',
  });
};

/**
 * Gets a permission by ID.
 */
export const drivePermissionsGet = <ThrowOnError extends boolean = false>(
  options: Options<DrivePermissionsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DrivePermissionsGetResponse, DrivePermissionsGetError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/permissions/{permissionId}',
  });
};

/**
 * Updates a permission with patch semantics. **Warning:** Concurrent permissions operations on the same file are not supported; only the last update is applied.
 */
export const drivePermissionsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<DrivePermissionsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<DrivePermissionsUpdateResponse, DrivePermissionsUpdateError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/permissions/{permissionId}',
  });
};

/**
 * Lists a file's revisions.
 */
export const driveRevisionsList = <ThrowOnError extends boolean = false>(
  options: Options<DriveRevisionsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveRevisionsListResponse, DriveRevisionsListError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/revisions',
  });
};

/**
 * Permanently deletes a file version. You can only delete revisions for files with binary content in Google Drive, like images or videos. Revisions for other files, like Google Docs or Sheets, and the last remaining file version can't be deleted.
 */
export const driveRevisionsDelete = <ThrowOnError extends boolean = false>(
  options: Options<DriveRevisionsDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DriveRevisionsDeleteResponse, DriveRevisionsDeleteError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/revisions/{revisionId}',
  });
};

/**
 * Gets a revision's metadata or content by ID.
 */
export const driveRevisionsGet = <ThrowOnError extends boolean = false>(
  options: Options<DriveRevisionsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveRevisionsGetResponse, DriveRevisionsGetError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/revisions/{revisionId}',
  });
};

/**
 * Updates a revision with patch semantics.
 */
export const driveRevisionsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<DriveRevisionsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<DriveRevisionsUpdateResponse, DriveRevisionsUpdateError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/revisions/{revisionId}',
  });
};

/**
 * Subscribes to changes to a file.
 */
export const driveFilesWatch = <ThrowOnError extends boolean = false>(
  options: Options<DriveFilesWatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DriveFilesWatchResponse, DriveFilesWatchError, ThrowOnError>({
    ...options,
    url: '/files/{fileId}/watch',
  });
};

/**
 * Deprecated: Use `drives.list` instead.
 */
export const driveTeamdrivesList = <ThrowOnError extends boolean = false>(
  options?: Options<DriveTeamdrivesListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveTeamdrivesListResponse, DriveTeamdrivesListError, ThrowOnError>({
    ...options,
    url: '/teamdrives',
  });
};

/**
 * Deprecated: Use `drives.create` instead.
 */
export const driveTeamdrivesCreate = <ThrowOnError extends boolean = false>(
  options: Options<DriveTeamdrivesCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DriveTeamdrivesCreateResponse, DriveTeamdrivesCreateError, ThrowOnError>({
    ...options,
    url: '/teamdrives',
  });
};

/**
 * Deprecated: Use `drives.delete` instead.
 */
export const driveTeamdrivesDelete = <ThrowOnError extends boolean = false>(
  options: Options<DriveTeamdrivesDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DriveTeamdrivesDeleteResponse, DriveTeamdrivesDeleteError, ThrowOnError>({
    ...options,
    url: '/teamdrives/{teamDriveId}',
  });
};

/**
 * Deprecated: Use `drives.get` instead.
 */
export const driveTeamdrivesGet = <ThrowOnError extends boolean = false>(
  options: Options<DriveTeamdrivesGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DriveTeamdrivesGetResponse, DriveTeamdrivesGetError, ThrowOnError>({
    ...options,
    url: '/teamdrives/{teamDriveId}',
  });
};

/**
 * Deprecated: Use `drives.update` instead.
 */
export const driveTeamdrivesUpdate = <ThrowOnError extends boolean = false>(
  options: Options<DriveTeamdrivesUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<DriveTeamdrivesUpdateResponse, DriveTeamdrivesUpdateError, ThrowOnError>({
    ...options,
    url: '/teamdrives/{teamDriveId}',
  });
};
