// Generated by ts-to-zod
import { z } from 'zod';

import {
  type Body,
  type StructuralElement,
  type Document,
  type Footer,
  type Footnote,
  type Header,
  type Table,
  type TableOfContents,
  type TableRow,
  type TableCell,
  type DocsDocumentsCreateData,
  type DocsDocumentsCreateResponse,
  type DocsDocumentsGetResponse,
} from './types.gen';

export const typeSchema = z.union([z.literal('TYPE_UNSPECIFIED'), z.literal('PAGE_NUMBER'), z.literal('PAGE_COUNT')]);

export const backgroundSuggestionStateSchema = z.object({
  backgroundColorSuggested: z.boolean().optional(),
});

export const writeControlSchema = z.object({
  requiredRevisionId: z.string().optional(),
  targetRevisionId: z.string().optional(),
});

export const textStyleSuggestionStateSchema = z.object({
  backgroundColorSuggested: z.boolean().optional(),
  baselineOffsetSuggested: z.boolean().optional(),
  boldSuggested: z.boolean().optional(),
  fontSizeSuggested: z.boolean().optional(),
  foregroundColorSuggested: z.boolean().optional(),
  italicSuggested: z.boolean().optional(),
  linkSuggested: z.boolean().optional(),
  smallCapsSuggested: z.boolean().optional(),
  strikethroughSuggested: z.boolean().optional(),
  underlineSuggested: z.boolean().optional(),
  weightedFontFamilySuggested: z.boolean().optional(),
});

export const rgbColorSchema = z.object({
  blue: z.number().optional(),
  green: z.number().optional(),
  red: z.number().optional(),
});

export const locationSchema = z.object({
  index: z.number().optional(),
  segmentId: z.string().optional(),
});

export const type2Schema = z.union([z.literal('HEADER_FOOTER_TYPE_UNSPECIFIED'), z.literal('DEFAULT')]);

export const createFooterResponseSchema = z.object({
  footerId: z.string().optional(),
});

export const endOfSegmentLocationSchema = z.object({
  segmentId: z.string().optional(),
});

export const createFootnoteResponseSchema = z.object({
  footnoteId: z.string().optional(),
});

export const createHeaderRequestSchema = z.object({
  sectionBreakLocation: locationSchema.optional(),
  type: z.union([z.literal('HEADER_FOOTER_TYPE_UNSPECIFIED'), z.literal('DEFAULT')]).optional(),
});

export const createHeaderResponseSchema = z.object({
  headerId: z.string().optional(),
});

export const rangeSchema = z.object({
  endIndex: z.number().optional(),
  segmentId: z.string().optional(),
  startIndex: z.number().optional(),
});

export const createNamedRangeResponseSchema = z.object({
  namedRangeId: z.string().optional(),
});

export const createParagraphBulletsRequestSchema = z.object({
  bulletPreset: z
    .union([
      z.literal('BULLET_GLYPH_PRESET_UNSPECIFIED'),
      z.literal('BULLET_DISC_CIRCLE_SQUARE'),
      z.literal('BULLET_DIAMONDX_ARROW3D_SQUARE'),
      z.literal('BULLET_CHECKBOX'),
      z.literal('BULLET_ARROW_DIAMOND_DISC'),
      z.literal('BULLET_STAR_CIRCLE_SQUARE'),
      z.literal('BULLET_ARROW3D_CIRCLE_SQUARE'),
      z.literal('BULLET_LEFTTRIANGLE_DIAMOND_DISC'),
      z.literal('BULLET_DIAMONDX_HOLLOWDIAMOND_SQUARE'),
      z.literal('BULLET_DIAMOND_CIRCLE_SQUARE'),
      z.literal('NUMBERED_DECIMAL_ALPHA_ROMAN'),
      z.literal('NUMBERED_DECIMAL_ALPHA_ROMAN_PARENS'),
      z.literal('NUMBERED_DECIMAL_NESTED'),
      z.literal('NUMBERED_UPPERALPHA_ALPHA_ROMAN'),
      z.literal('NUMBERED_UPPERROMAN_UPPERALPHA_DECIMAL'),
      z.literal('NUMBERED_ZERODECIMAL_ALPHA_ROMAN'),
    ])
    .optional(),
  range: rangeSchema.optional(),
});

export const bulletPresetSchema = z.union([
  z.literal('BULLET_GLYPH_PRESET_UNSPECIFIED'),
  z.literal('BULLET_DISC_CIRCLE_SQUARE'),
  z.literal('BULLET_DIAMONDX_ARROW3D_SQUARE'),
  z.literal('BULLET_CHECKBOX'),
  z.literal('BULLET_ARROW_DIAMOND_DISC'),
  z.literal('BULLET_STAR_CIRCLE_SQUARE'),
  z.literal('BULLET_ARROW3D_CIRCLE_SQUARE'),
  z.literal('BULLET_LEFTTRIANGLE_DIAMOND_DISC'),
  z.literal('BULLET_DIAMONDX_HOLLOWDIAMOND_SQUARE'),
  z.literal('BULLET_DIAMOND_CIRCLE_SQUARE'),
  z.literal('NUMBERED_DECIMAL_ALPHA_ROMAN'),
  z.literal('NUMBERED_DECIMAL_ALPHA_ROMAN_PARENS'),
  z.literal('NUMBERED_DECIMAL_NESTED'),
  z.literal('NUMBERED_UPPERALPHA_ALPHA_ROMAN'),
  z.literal('NUMBERED_UPPERROMAN_UPPERALPHA_DECIMAL'),
  z.literal('NUMBERED_ZERODECIMAL_ALPHA_ROMAN'),
]);

export const cropPropertiesSchema = z.object({
  angle: z.number().optional(),
  offsetBottom: z.number().optional(),
  offsetLeft: z.number().optional(),
  offsetRight: z.number().optional(),
  offsetTop: z.number().optional(),
});

export const cropPropertiesSuggestionStateSchema = z.object({
  angleSuggested: z.boolean().optional(),
  offsetBottomSuggested: z.boolean().optional(),
  offsetLeftSuggested: z.boolean().optional(),
  offsetRightSuggested: z.boolean().optional(),
  offsetTopSuggested: z.boolean().optional(),
});

export const deleteContentRangeRequestSchema = z.object({
  range: rangeSchema.optional(),
});

export const deleteFooterRequestSchema = z.object({
  footerId: z.string().optional(),
});

export const deleteHeaderRequestSchema = z.object({
  headerId: z.string().optional(),
});

export const deleteNamedRangeRequestSchema = z.object({
  name: z.string().optional(),
  namedRangeId: z.string().optional(),
});

export const deleteParagraphBulletsRequestSchema = z.object({
  range: rangeSchema.optional(),
});

export const deletePositionedObjectRequestSchema = z.object({
  objectId: z.string().optional(),
});

export const tableCellLocationSchema = z.object({
  columnIndex: z.number().optional(),
  rowIndex: z.number().optional(),
  tableStartLocation: locationSchema.optional(),
});

export const deleteTableRowRequestSchema = z.object({
  tableCellLocation: tableCellLocationSchema.optional(),
});

export const dimensionSchema = z.object({
  magnitude: z.number().optional(),
  unit: z.union([z.literal('UNIT_UNSPECIFIED'), z.literal('PT')]).optional(),
});

export const unitSchema = z.union([z.literal('UNIT_UNSPECIFIED'), z.literal('PT')]);

export const suggestionsViewModeSchema = z.union([
  z.literal('DEFAULT_FOR_CURRENT_ACCESS'),
  z.literal('SUGGESTIONS_INLINE'),
  z.literal('PREVIEW_SUGGESTIONS_ACCEPTED'),
  z.literal('PREVIEW_WITHOUT_SUGGESTIONS'),
]);

export const sizeSchema = z.object({
  height: dimensionSchema.optional(),
  width: dimensionSchema.optional(),
});

export const sizeSuggestionStateSchema = z.object({
  heightSuggested: z.boolean().optional(),
  widthSuggested: z.boolean().optional(),
});

export const embeddedDrawingPropertiesSchema = z.record(z.unknown());

export const embeddedDrawingPropertiesSuggestionStateSchema = z.record(z.unknown());

export const imagePropertiesSchema = z.object({
  angle: z.number().optional(),
  brightness: z.number().optional(),
  contentUri: z.string().optional(),
  contrast: z.number().optional(),
  cropProperties: cropPropertiesSchema.optional(),
  sourceUri: z.string().optional(),
  transparency: z.number().optional(),
});

export const dashStyleSchema = z.union([
  z.literal('DASH_STYLE_UNSPECIFIED'),
  z.literal('SOLID'),
  z.literal('DOT'),
  z.literal('DASH'),
]);

export const propertyStateSchema = z.union([z.literal('RENDERED'), z.literal('NOT_RENDERED')]);

export const embeddedObjectBorderSuggestionStateSchema = z.object({
  colorSuggested: z.boolean().optional(),
  dashStyleSuggested: z.boolean().optional(),
  propertyStateSuggested: z.boolean().optional(),
  widthSuggested: z.boolean().optional(),
});

export const imagePropertiesSuggestionStateSchema = z.object({
  angleSuggested: z.boolean().optional(),
  brightnessSuggested: z.boolean().optional(),
  contentUriSuggested: z.boolean().optional(),
  contrastSuggested: z.boolean().optional(),
  cropPropertiesSuggestionState: cropPropertiesSuggestionStateSchema.optional(),
  sourceUriSuggested: z.boolean().optional(),
  transparencySuggested: z.boolean().optional(),
});

export const equationSchema = z.object({
  suggestedDeletionIds: z.array(z.string()).optional(),
  suggestedInsertionIds: z.array(z.string()).optional(),
});

export const insertInlineImageRequestSchema = z.object({
  endOfSegmentLocation: endOfSegmentLocationSchema.optional(),
  location: locationSchema.optional(),
  objectSize: sizeSchema.optional(),
  uri: z.string().optional(),
});

export const insertInlineImageResponseSchema = z.object({
  objectId: z.string().optional(),
});

export const insertInlineSheetsChartResponseSchema = z.object({
  objectId: z.string().optional(),
});

export const insertPageBreakRequestSchema = z.object({
  endOfSegmentLocation: endOfSegmentLocationSchema.optional(),
  location: locationSchema.optional(),
});

export const insertSectionBreakRequestSchema = z.object({
  endOfSegmentLocation: endOfSegmentLocationSchema.optional(),
  location: locationSchema.optional(),
  sectionType: z
    .union([z.literal('SECTION_TYPE_UNSPECIFIED'), z.literal('CONTINUOUS'), z.literal('NEXT_PAGE')])
    .optional(),
});

export const sectionTypeSchema = z.union([
  z.literal('SECTION_TYPE_UNSPECIFIED'),
  z.literal('CONTINUOUS'),
  z.literal('NEXT_PAGE'),
]);

export const insertTableColumnRequestSchema = z.object({
  insertRight: z.boolean().optional(),
  tableCellLocation: tableCellLocationSchema.optional(),
});

export const insertTableRequestSchema = z.object({
  columns: z.number().optional(),
  endOfSegmentLocation: endOfSegmentLocationSchema.optional(),
  location: locationSchema.optional(),
  rows: z.number().optional(),
});

export const insertTableRowRequestSchema = z.object({
  insertBelow: z.boolean().optional(),
  tableCellLocation: tableCellLocationSchema.optional(),
});

export const insertTextRequestSchema = z.object({
  endOfSegmentLocation: endOfSegmentLocationSchema.optional(),
  location: locationSchema.optional(),
  text: z.string().optional(),
});

export const linkSchema = z.object({
  bookmarkId: z.string().optional(),
  headingId: z.string().optional(),
  url: z.string().optional(),
});

export const sheetsChartReferenceSchema = z.object({
  chartId: z.number().optional(),
  spreadsheetId: z.string().optional(),
});

export const sheetsChartReferenceSuggestionStateSchema = z.object({
  chartIdSuggested: z.boolean().optional(),
  spreadsheetIdSuggested: z.boolean().optional(),
});

export const nestingLevelSuggestionStateSchema = z.object({
  bulletAlignmentSuggested: z.boolean().optional(),
  glyphFormatSuggested: z.boolean().optional(),
  glyphSymbolSuggested: z.boolean().optional(),
  glyphTypeSuggested: z.boolean().optional(),
  indentFirstLineSuggested: z.boolean().optional(),
  indentStartSuggested: z.boolean().optional(),
  startNumberSuggested: z.boolean().optional(),
  textStyleSuggestionState: textStyleSuggestionStateSchema.optional(),
});

export const tableRangeSchema = z.object({
  columnSpan: z.number().optional(),
  rowSpan: z.number().optional(),
  tableCellLocation: tableCellLocationSchema.optional(),
});

export const namedRangeSchema = z.object({
  name: z.string().optional(),
  namedRangeId: z.string().optional(),
  ranges: z.array(rangeSchema).optional(),
});

export const namedRangesSchema = z.object({
  name: z.string().optional(),
  namedRanges: z.array(namedRangeSchema).optional(),
});

export const namedStyleTypeSchema = z.union([
  z.literal('NAMED_STYLE_TYPE_UNSPECIFIED'),
  z.literal('NORMAL_TEXT'),
  z.literal('TITLE'),
  z.literal('SUBTITLE'),
  z.literal('HEADING_1'),
  z.literal('HEADING_2'),
  z.literal('HEADING_3'),
  z.literal('HEADING_4'),
  z.literal('HEADING_5'),
  z.literal('HEADING_6'),
]);

export const bulletAlignmentSchema = z.union([
  z.literal('BULLET_ALIGNMENT_UNSPECIFIED'),
  z.literal('START'),
  z.literal('CENTER'),
  z.literal('END'),
]);

export const glyphTypeSchema = z.union([
  z.literal('GLYPH_TYPE_UNSPECIFIED'),
  z.literal('NONE'),
  z.literal('DECIMAL'),
  z.literal('ZERO_DECIMAL'),
  z.literal('UPPER_ALPHA'),
  z.literal('ALPHA'),
  z.literal('UPPER_ROMAN'),
  z.literal('ROMAN'),
]);

export const objectReferencesSchema = z.object({
  objectIds: z.array(z.string()).optional(),
});

export const colorSchema = z.object({
  rgbColor: rgbColorSchema.optional(),
});

export const optionalColorSchema = z.object({
  color: colorSchema.optional(),
});

export const paragraphBorderSchema = z.object({
  color: optionalColorSchema.optional(),
  dashStyle: z
    .union([z.literal('DASH_STYLE_UNSPECIFIED'), z.literal('SOLID'), z.literal('DOT'), z.literal('DASH')])
    .optional(),
  padding: dimensionSchema.optional(),
  width: dimensionSchema.optional(),
});

export const shadingSchema = z.object({
  backgroundColor: optionalColorSchema.optional(),
});

export const tabStopSchema = z.object({
  alignment: z
    .union([z.literal('TAB_STOP_ALIGNMENT_UNSPECIFIED'), z.literal('START'), z.literal('CENTER'), z.literal('END')])
    .optional(),
  offset: dimensionSchema.optional(),
});

export const alignmentSchema = z.union([
  z.literal('ALIGNMENT_UNSPECIFIED'),
  z.literal('START'),
  z.literal('CENTER'),
  z.literal('END'),
  z.literal('JUSTIFIED'),
]);

export const directionSchema = z.union([
  z.literal('CONTENT_DIRECTION_UNSPECIFIED'),
  z.literal('LEFT_TO_RIGHT'),
  z.literal('RIGHT_TO_LEFT'),
]);

export const spacingModeSchema = z.union([
  z.literal('SPACING_MODE_UNSPECIFIED'),
  z.literal('NEVER_COLLAPSE'),
  z.literal('COLLAPSE_LISTS'),
]);

export const shadingSuggestionStateSchema = z.object({
  backgroundColorSuggested: z.boolean().optional(),
});

export const personPropertiesSchema = z.object({
  email: z.string().optional(),
  name: z.string().optional(),
});

export const pinTableHeaderRowsRequestSchema = z.object({
  pinnedHeaderRowsCount: z.number().optional(),
  tableStartLocation: locationSchema.optional(),
});

export const positionedObjectPositioningSchema = z.object({
  layout: z
    .union([
      z.literal('POSITIONED_OBJECT_LAYOUT_UNSPECIFIED'),
      z.literal('WRAP_TEXT'),
      z.literal('BREAK_LEFT'),
      z.literal('BREAK_RIGHT'),
      z.literal('BREAK_LEFT_RIGHT'),
      z.literal('IN_FRONT_OF_TEXT'),
      z.literal('BEHIND_TEXT'),
    ])
    .optional(),
  leftOffset: dimensionSchema.optional(),
  topOffset: dimensionSchema.optional(),
});

export const layoutSchema = z.union([
  z.literal('POSITIONED_OBJECT_LAYOUT_UNSPECIFIED'),
  z.literal('WRAP_TEXT'),
  z.literal('BREAK_LEFT'),
  z.literal('BREAK_RIGHT'),
  z.literal('BREAK_LEFT_RIGHT'),
  z.literal('IN_FRONT_OF_TEXT'),
  z.literal('BEHIND_TEXT'),
]);

export const positionedObjectPositioningSuggestionStateSchema = z.object({
  layoutSuggested: z.boolean().optional(),
  leftOffsetSuggested: z.boolean().optional(),
  topOffsetSuggested: z.boolean().optional(),
});

export const substringMatchCriteriaSchema = z.object({
  matchCase: z.boolean().optional(),
  text: z.string().optional(),
});

export const replaceAllTextResponseSchema = z.object({
  occurrencesChanged: z.number().optional(),
});

export const replaceImageRequestSchema = z.object({
  imageObjectId: z.string().optional(),
  imageReplaceMethod: z.union([z.literal('IMAGE_REPLACE_METHOD_UNSPECIFIED'), z.literal('CENTER_CROP')]).optional(),
  uri: z.string().optional(),
});

export const imageReplaceMethodSchema = z.union([
  z.literal('IMAGE_REPLACE_METHOD_UNSPECIFIED'),
  z.literal('CENTER_CROP'),
]);

export const replaceNamedRangeContentRequestSchema = z.object({
  namedRangeId: z.string().optional(),
  namedRangeName: z.string().optional(),
  text: z.string().optional(),
});

export const createFooterRequestSchema = z.object({
  sectionBreakLocation: locationSchema.optional(),
  type: z.union([z.literal('HEADER_FOOTER_TYPE_UNSPECIFIED'), z.literal('DEFAULT')]).optional(),
});

export const createFootnoteRequestSchema = z.object({
  endOfSegmentLocation: endOfSegmentLocationSchema.optional(),
  location: locationSchema.optional(),
});

export const createNamedRangeRequestSchema = z.object({
  name: z.string().optional(),
  range: rangeSchema.optional(),
});

export const deleteTableColumnRequestSchema = z.object({
  tableCellLocation: tableCellLocationSchema.optional(),
});

export const mergeTableCellsRequestSchema = z.object({
  tableRange: tableRangeSchema.optional(),
});

export const replaceAllTextRequestSchema = z.object({
  containsText: substringMatchCriteriaSchema.optional(),
  replaceText: z.string().optional(),
});

export const unmergeTableCellsRequestSchema = z.object({
  tableRange: tableRangeSchema.optional(),
});

export const responseSchema = z.object({
  createFooter: createFooterResponseSchema.optional(),
  createFootnote: createFootnoteResponseSchema.optional(),
  createHeader: createHeaderResponseSchema.optional(),
  createNamedRange: createNamedRangeResponseSchema.optional(),
  insertInlineImage: insertInlineImageResponseSchema.optional(),
  insertInlineSheetsChart: insertInlineSheetsChartResponseSchema.optional(),
  replaceAllText: replaceAllTextResponseSchema.optional(),
});

export const richLinkPropertiesSchema = z.object({
  mimeType: z.string().optional(),
  title: z.string().optional(),
  uri: z.string().optional(),
});

export const sectionColumnPropertiesSchema = z.object({
  paddingEnd: dimensionSchema.optional(),
  width: dimensionSchema.optional(),
});

export const sectionStyleSchema = z.object({
  columnProperties: z.array(sectionColumnPropertiesSchema).optional(),
  columnSeparatorStyle: z
    .union([z.literal('COLUMN_SEPARATOR_STYLE_UNSPECIFIED'), z.literal('NONE'), z.literal('BETWEEN_EACH_COLUMN')])
    .optional(),
  contentDirection: z
    .union([z.literal('CONTENT_DIRECTION_UNSPECIFIED'), z.literal('LEFT_TO_RIGHT'), z.literal('RIGHT_TO_LEFT')])
    .optional(),
  defaultFooterId: z.string().optional(),
  defaultHeaderId: z.string().optional(),
  evenPageFooterId: z.string().optional(),
  evenPageHeaderId: z.string().optional(),
  firstPageFooterId: z.string().optional(),
  firstPageHeaderId: z.string().optional(),
  flipPageOrientation: z.boolean().optional(),
  marginBottom: dimensionSchema.optional(),
  marginFooter: dimensionSchema.optional(),
  marginHeader: dimensionSchema.optional(),
  marginLeft: dimensionSchema.optional(),
  marginRight: dimensionSchema.optional(),
  marginTop: dimensionSchema.optional(),
  pageNumberStart: z.number().optional(),
  sectionType: z
    .union([z.literal('SECTION_TYPE_UNSPECIFIED'), z.literal('CONTINUOUS'), z.literal('NEXT_PAGE')])
    .optional(),
  useFirstPageHeaderFooter: z.boolean().optional(),
});

export const columnSeparatorStyleSchema = z.union([
  z.literal('COLUMN_SEPARATOR_STYLE_UNSPECIFIED'),
  z.literal('NONE'),
  z.literal('BETWEEN_EACH_COLUMN'),
]);

export const contentDirectionSchema = z.union([
  z.literal('CONTENT_DIRECTION_UNSPECIFIED'),
  z.literal('LEFT_TO_RIGHT'),
  z.literal('RIGHT_TO_LEFT'),
]);

export const sectionBreakSchema = z.object({
  sectionStyle: sectionStyleSchema.optional(),
  suggestedDeletionIds: z.array(z.string()).optional(),
  suggestedInsertionIds: z.array(z.string()).optional(),
});

export const bulletSuggestionStateSchema = z.object({
  listIdSuggested: z.boolean().optional(),
  nestingLevelSuggested: z.boolean().optional(),
  textStyleSuggestionState: textStyleSuggestionStateSchema.optional(),
});

export const documentStyleSuggestionStateSchema = z.object({
  backgroundSuggestionState: backgroundSuggestionStateSchema.optional(),
  defaultFooterIdSuggested: z.boolean().optional(),
  defaultHeaderIdSuggested: z.boolean().optional(),
  evenPageFooterIdSuggested: z.boolean().optional(),
  evenPageHeaderIdSuggested: z.boolean().optional(),
  firstPageFooterIdSuggested: z.boolean().optional(),
  firstPageHeaderIdSuggested: z.boolean().optional(),
  flipPageOrientationSuggested: z.boolean().optional(),
  marginBottomSuggested: z.boolean().optional(),
  marginFooterSuggested: z.boolean().optional(),
  marginHeaderSuggested: z.boolean().optional(),
  marginLeftSuggested: z.boolean().optional(),
  marginRightSuggested: z.boolean().optional(),
  marginTopSuggested: z.boolean().optional(),
  pageNumberStartSuggested: z.boolean().optional(),
  pageSizeSuggestionState: sizeSuggestionStateSchema.optional(),
  useCustomHeaderFooterMarginsSuggested: z.boolean().optional(),
  useEvenPageHeaderFooterSuggested: z.boolean().optional(),
  useFirstPageHeaderFooterSuggested: z.boolean().optional(),
});

export const listPropertiesSuggestionStateSchema = z.object({
  nestingLevelsSuggestionStates: z.array(nestingLevelSuggestionStateSchema).optional(),
});

export const paragraphStyleSchema = z.object({
  alignment: z
    .union([
      z.literal('ALIGNMENT_UNSPECIFIED'),
      z.literal('START'),
      z.literal('CENTER'),
      z.literal('END'),
      z.literal('JUSTIFIED'),
    ])
    .optional(),
  avoidWidowAndOrphan: z.boolean().optional(),
  borderBetween: paragraphBorderSchema.optional(),
  borderBottom: paragraphBorderSchema.optional(),
  borderLeft: paragraphBorderSchema.optional(),
  borderRight: paragraphBorderSchema.optional(),
  borderTop: paragraphBorderSchema.optional(),
  direction: z
    .union([z.literal('CONTENT_DIRECTION_UNSPECIFIED'), z.literal('LEFT_TO_RIGHT'), z.literal('RIGHT_TO_LEFT')])
    .optional(),
  headingId: z.string().optional(),
  indentEnd: dimensionSchema.optional(),
  indentFirstLine: dimensionSchema.optional(),
  indentStart: dimensionSchema.optional(),
  keepLinesTogether: z.boolean().optional(),
  keepWithNext: z.boolean().optional(),
  lineSpacing: z.number().optional(),
  namedStyleType: z
    .union([
      z.literal('NAMED_STYLE_TYPE_UNSPECIFIED'),
      z.literal('NORMAL_TEXT'),
      z.literal('TITLE'),
      z.literal('SUBTITLE'),
      z.literal('HEADING_1'),
      z.literal('HEADING_2'),
      z.literal('HEADING_3'),
      z.literal('HEADING_4'),
      z.literal('HEADING_5'),
      z.literal('HEADING_6'),
    ])
    .optional(),
  pageBreakBefore: z.boolean().optional(),
  shading: shadingSchema.optional(),
  spaceAbove: dimensionSchema.optional(),
  spaceBelow: dimensionSchema.optional(),
  spacingMode: z
    .union([z.literal('SPACING_MODE_UNSPECIFIED'), z.literal('NEVER_COLLAPSE'), z.literal('COLLAPSE_LISTS')])
    .optional(),
  tabStops: z.array(tabStopSchema).optional(),
});

export const paragraphStyleSuggestionStateSchema = z.object({
  alignmentSuggested: z.boolean().optional(),
  avoidWidowAndOrphanSuggested: z.boolean().optional(),
  borderBetweenSuggested: z.boolean().optional(),
  borderBottomSuggested: z.boolean().optional(),
  borderLeftSuggested: z.boolean().optional(),
  borderRightSuggested: z.boolean().optional(),
  borderTopSuggested: z.boolean().optional(),
  directionSuggested: z.boolean().optional(),
  headingIdSuggested: z.boolean().optional(),
  indentEndSuggested: z.boolean().optional(),
  indentFirstLineSuggested: z.boolean().optional(),
  indentStartSuggested: z.boolean().optional(),
  keepLinesTogetherSuggested: z.boolean().optional(),
  keepWithNextSuggested: z.boolean().optional(),
  lineSpacingSuggested: z.boolean().optional(),
  namedStyleTypeSuggested: z.boolean().optional(),
  pageBreakBeforeSuggested: z.boolean().optional(),
  shadingSuggestionState: shadingSuggestionStateSchema.optional(),
  spaceAboveSuggested: z.boolean().optional(),
  spaceBelowSuggested: z.boolean().optional(),
  spacingModeSuggested: z.boolean().optional(),
});

export const tableCellStyleSuggestionStateSchema = z.object({
  backgroundColorSuggested: z.boolean().optional(),
  borderBottomSuggested: z.boolean().optional(),
  borderLeftSuggested: z.boolean().optional(),
  borderRightSuggested: z.boolean().optional(),
  borderTopSuggested: z.boolean().optional(),
  columnSpanSuggested: z.boolean().optional(),
  contentAlignmentSuggested: z.boolean().optional(),
  paddingBottomSuggested: z.boolean().optional(),
  paddingLeftSuggested: z.boolean().optional(),
  paddingRightSuggested: z.boolean().optional(),
  paddingTopSuggested: z.boolean().optional(),
  rowSpanSuggested: z.boolean().optional(),
});

export const tableRowStyleSchema = z.object({
  minRowHeight: dimensionSchema.optional(),
  preventOverflow: z.boolean().optional(),
  tableHeader: z.boolean().optional(),
});

export const tableRowStyleSuggestionStateSchema = z.object({
  minRowHeightSuggested: z.boolean().optional(),
});

export const alignment2Schema = z.union([
  z.literal('TAB_STOP_ALIGNMENT_UNSPECIFIED'),
  z.literal('START'),
  z.literal('CENTER'),
  z.literal('END'),
]);

export const tableCellBorderSchema = z.object({
  color: optionalColorSchema.optional(),
  dashStyle: z
    .union([z.literal('DASH_STYLE_UNSPECIFIED'), z.literal('SOLID'), z.literal('DOT'), z.literal('DASH')])
    .optional(),
  width: dimensionSchema.optional(),
});

export const tableCellStyleSchema = z.object({
  backgroundColor: optionalColorSchema.optional(),
  borderBottom: tableCellBorderSchema.optional(),
  borderLeft: tableCellBorderSchema.optional(),
  borderRight: tableCellBorderSchema.optional(),
  borderTop: tableCellBorderSchema.optional(),
  columnSpan: z.number().optional(),
  contentAlignment: z
    .union([
      z.literal('CONTENT_ALIGNMENT_UNSPECIFIED'),
      z.literal('CONTENT_ALIGNMENT_UNSUPPORTED'),
      z.literal('TOP'),
      z.literal('MIDDLE'),
      z.literal('BOTTOM'),
    ])
    .optional(),
  paddingBottom: dimensionSchema.optional(),
  paddingLeft: dimensionSchema.optional(),
  paddingRight: dimensionSchema.optional(),
  paddingTop: dimensionSchema.optional(),
  rowSpan: z.number().optional(),
});

export const contentAlignmentSchema = z.union([
  z.literal('CONTENT_ALIGNMENT_UNSPECIFIED'),
  z.literal('CONTENT_ALIGNMENT_UNSUPPORTED'),
  z.literal('TOP'),
  z.literal('MIDDLE'),
  z.literal('BOTTOM'),
]);

export const tableColumnPropertiesSchema = z.object({
  width: dimensionSchema.optional(),
  widthType: z
    .union([z.literal('WIDTH_TYPE_UNSPECIFIED'), z.literal('EVENLY_DISTRIBUTED'), z.literal('FIXED_WIDTH')])
    .optional(),
});

export const widthTypeSchema = z.union([
  z.literal('WIDTH_TYPE_UNSPECIFIED'),
  z.literal('EVENLY_DISTRIBUTED'),
  z.literal('FIXED_WIDTH'),
]);

export const tableStyleSchema = z.object({
  tableColumnProperties: z.array(tableColumnPropertiesSchema).optional(),
});

export const weightedFontFamilySchema = z.object({
  fontFamily: z.string().optional(),
  weight: z.number().optional(),
});

export const baselineOffsetSchema = z.union([
  z.literal('BASELINE_OFFSET_UNSPECIFIED'),
  z.literal('NONE'),
  z.literal('SUPERSCRIPT'),
  z.literal('SUBSCRIPT'),
]);

export const updateParagraphStyleRequestSchema = z.object({
  fields: z.string().optional(),
  paragraphStyle: paragraphStyleSchema.optional(),
  range: rangeSchema.optional(),
});

export const updateSectionStyleRequestSchema = z.object({
  fields: z.string().optional(),
  range: rangeSchema.optional(),
  sectionStyle: sectionStyleSchema.optional(),
});

export const updateTableCellStyleRequestSchema = z.object({
  fields: z.string().optional(),
  tableCellStyle: tableCellStyleSchema.optional(),
  tableRange: tableRangeSchema.optional(),
  tableStartLocation: locationSchema.optional(),
});

export const updateTableColumnPropertiesRequestSchema = z.object({
  columnIndices: z.array(z.number()).optional(),
  fields: z.string().optional(),
  tableColumnProperties: tableColumnPropertiesSchema.optional(),
  tableStartLocation: locationSchema.optional(),
});

export const updateTableRowStyleRequestSchema = z.object({
  fields: z.string().optional(),
  rowIndices: z.array(z.number()).optional(),
  tableRowStyle: tableRowStyleSchema.optional(),
  tableStartLocation: locationSchema.optional(),
});

export const textStyleSchema = z.object({
  backgroundColor: optionalColorSchema.optional(),
  baselineOffset: z
    .union([
      z.literal('BASELINE_OFFSET_UNSPECIFIED'),
      z.literal('NONE'),
      z.literal('SUPERSCRIPT'),
      z.literal('SUBSCRIPT'),
    ])
    .optional(),
  bold: z.boolean().optional(),
  fontSize: dimensionSchema.optional(),
  foregroundColor: optionalColorSchema.optional(),
  italic: z.boolean().optional(),
  link: linkSchema.optional(),
  smallCaps: z.boolean().optional(),
  strikethrough: z.boolean().optional(),
  underline: z.boolean().optional(),
  weightedFontFamily: weightedFontFamilySchema.optional(),
});

export const parameterXgafvSchema = z.union([z.literal('1'), z.literal('2')]);

export const parameteraccessTokenSchema = z.string();

export const parameteraltSchema = z.union([z.literal('json'), z.literal('media'), z.literal('proto')]);

export const parametercallbackSchema = z.string();

export const parameterfieldsSchema = z.string();

export const parameterkeySchema = z.string();

export const parameteroauthTokenSchema = z.string();

export const parameterprettyPrintSchema = z.boolean();

export const parameterquotaUserSchema = z.string();

export const parameteruploadTypeSchema = z.string();

export const parameteruploadProtocolSchema = z.string();

export const docsDocumentsCreateErrorSchema = z.unknown();

export const docsDocumentsGetDataSchema = z.object({
  path: z.object({
    documentId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      suggestionsViewMode: z
        .union([
          z.literal('DEFAULT_FOR_CURRENT_ACCESS'),
          z.literal('SUGGESTIONS_INLINE'),
          z.literal('PREVIEW_SUGGESTIONS_ACCEPTED'),
          z.literal('PREVIEW_WITHOUT_SUGGESTIONS'),
        ])
        .optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const docsDocumentsGetErrorSchema = z.unknown();

export const batchUpdateDocumentResponseSchema = z.object({
  documentId: z.string().optional(),
  replies: z.array(responseSchema).optional(),
  writeControl: writeControlSchema.optional(),
});

export const docsDocumentsBatchUpdateErrorSchema = z.unknown();

export const backgroundSchema = z.object({
  color: optionalColorSchema.optional(),
});

export const bulletSchema = z.object({
  listId: z.string().optional(),
  nestingLevel: z.number().optional(),
  textStyle: textStyleSchema.optional(),
});

export const documentStyleSchema = z.object({
  background: backgroundSchema.optional(),
  defaultFooterId: z.string().optional(),
  defaultHeaderId: z.string().optional(),
  evenPageFooterId: z.string().optional(),
  evenPageHeaderId: z.string().optional(),
  firstPageFooterId: z.string().optional(),
  firstPageHeaderId: z.string().optional(),
  flipPageOrientation: z.boolean().optional(),
  marginBottom: dimensionSchema.optional(),
  marginFooter: dimensionSchema.optional(),
  marginHeader: dimensionSchema.optional(),
  marginLeft: dimensionSchema.optional(),
  marginRight: dimensionSchema.optional(),
  marginTop: dimensionSchema.optional(),
  pageNumberStart: z.number().optional(),
  pageSize: sizeSchema.optional(),
  useCustomHeaderFooterMargins: z.boolean().optional(),
  useEvenPageHeaderFooter: z.boolean().optional(),
  useFirstPageHeaderFooter: z.boolean().optional(),
});

export const embeddedObjectBorderSchema = z.object({
  color: optionalColorSchema.optional(),
  dashStyle: z
    .union([z.literal('DASH_STYLE_UNSPECIFIED'), z.literal('SOLID'), z.literal('DOT'), z.literal('DASH')])
    .optional(),
  propertyState: z.union([z.literal('RENDERED'), z.literal('NOT_RENDERED')]).optional(),
  width: dimensionSchema.optional(),
});

export const linkedContentReferenceSchema = z.object({
  sheetsChartReference: sheetsChartReferenceSchema.optional(),
});

export const linkedContentReferenceSuggestionStateSchema = z.object({
  sheetsChartReferenceSuggestionState: sheetsChartReferenceSuggestionStateSchema.optional(),
});

export const embeddedObjectSchema = z.object({
  description: z.string().optional(),
  embeddedDrawingProperties: embeddedDrawingPropertiesSchema.optional(),
  embeddedObjectBorder: embeddedObjectBorderSchema.optional(),
  imageProperties: imagePropertiesSchema.optional(),
  linkedContentReference: linkedContentReferenceSchema.optional(),
  marginBottom: dimensionSchema.optional(),
  marginLeft: dimensionSchema.optional(),
  marginRight: dimensionSchema.optional(),
  marginTop: dimensionSchema.optional(),
  size: sizeSchema.optional(),
  title: z.string().optional(),
});

export const embeddedObjectSuggestionStateSchema = z.object({
  descriptionSuggested: z.boolean().optional(),
  embeddedDrawingPropertiesSuggestionState: embeddedDrawingPropertiesSuggestionStateSchema.optional(),
  embeddedObjectBorderSuggestionState: embeddedObjectBorderSuggestionStateSchema.optional(),
  imagePropertiesSuggestionState: imagePropertiesSuggestionStateSchema.optional(),
  linkedContentReferenceSuggestionState: linkedContentReferenceSuggestionStateSchema.optional(),
  marginBottomSuggested: z.boolean().optional(),
  marginLeftSuggested: z.boolean().optional(),
  marginRightSuggested: z.boolean().optional(),
  marginTopSuggested: z.boolean().optional(),
  sizeSuggestionState: sizeSuggestionStateSchema.optional(),
  titleSuggested: z.boolean().optional(),
});

export const nestingLevelSchema = z.object({
  bulletAlignment: z
    .union([z.literal('BULLET_ALIGNMENT_UNSPECIFIED'), z.literal('START'), z.literal('CENTER'), z.literal('END')])
    .optional(),
  glyphFormat: z.string().optional(),
  glyphSymbol: z.string().optional(),
  glyphType: z
    .union([
      z.literal('GLYPH_TYPE_UNSPECIFIED'),
      z.literal('NONE'),
      z.literal('DECIMAL'),
      z.literal('ZERO_DECIMAL'),
      z.literal('UPPER_ALPHA'),
      z.literal('ALPHA'),
      z.literal('UPPER_ROMAN'),
      z.literal('ROMAN'),
    ])
    .optional(),
  indentFirstLine: dimensionSchema.optional(),
  indentStart: dimensionSchema.optional(),
  startNumber: z.number().optional(),
  textStyle: textStyleSchema.optional(),
});

export const namedStyleSchema = z.object({
  namedStyleType: z
    .union([
      z.literal('NAMED_STYLE_TYPE_UNSPECIFIED'),
      z.literal('NORMAL_TEXT'),
      z.literal('TITLE'),
      z.literal('SUBTITLE'),
      z.literal('HEADING_1'),
      z.literal('HEADING_2'),
      z.literal('HEADING_3'),
      z.literal('HEADING_4'),
      z.literal('HEADING_5'),
      z.literal('HEADING_6'),
    ])
    .optional(),
  paragraphStyle: paragraphStyleSchema.optional(),
  textStyle: textStyleSchema.optional(),
});

export const namedStyleSuggestionStateSchema = z.object({
  namedStyleType: z
    .union([
      z.literal('NAMED_STYLE_TYPE_UNSPECIFIED'),
      z.literal('NORMAL_TEXT'),
      z.literal('TITLE'),
      z.literal('SUBTITLE'),
      z.literal('HEADING_1'),
      z.literal('HEADING_2'),
      z.literal('HEADING_3'),
      z.literal('HEADING_4'),
      z.literal('HEADING_5'),
      z.literal('HEADING_6'),
    ])
    .optional(),
  paragraphStyleSuggestionState: paragraphStyleSuggestionStateSchema.optional(),
  textStyleSuggestionState: textStyleSuggestionStateSchema.optional(),
});

export const namedStylesSchema = z.object({
  styles: z.array(namedStyleSchema).optional(),
});

export const namedStylesSuggestionStateSchema = z.object({
  stylesSuggestionStates: z.array(namedStyleSuggestionStateSchema).optional(),
});

export const positionedObjectPropertiesSchema = z.object({
  embeddedObject: embeddedObjectSchema.optional(),
  positioning: positionedObjectPositioningSchema.optional(),
});

export const positionedObjectPropertiesSuggestionStateSchema = z.object({
  embeddedObjectSuggestionState: embeddedObjectSuggestionStateSchema.optional(),
  positioningSuggestionState: positionedObjectPositioningSuggestionStateSchema.optional(),
});

export const updateDocumentStyleRequestSchema = z.object({
  documentStyle: documentStyleSchema.optional(),
  fields: z.string().optional(),
});

export const updateTextStyleRequestSchema = z.object({
  fields: z.string().optional(),
  range: rangeSchema.optional(),
  textStyle: textStyleSchema.optional(),
});

export const suggestedBulletSchema = z.object({
  bullet: bulletSchema.optional(),
  bulletSuggestionState: bulletSuggestionStateSchema.optional(),
});

export const suggestedDocumentStyleSchema = z.object({
  documentStyle: documentStyleSchema.optional(),
  documentStyleSuggestionState: documentStyleSuggestionStateSchema.optional(),
});

export const inlineObjectPropertiesSchema = z.object({
  embeddedObject: embeddedObjectSchema.optional(),
});

export const inlineObjectPropertiesSuggestionStateSchema = z.object({
  embeddedObjectSuggestionState: embeddedObjectSuggestionStateSchema.optional(),
});

export const listPropertiesSchema = z.object({
  nestingLevels: z.array(nestingLevelSchema).optional(),
});

export const suggestedNamedStylesSchema = z.object({
  namedStyles: namedStylesSchema.optional(),
  namedStylesSuggestionState: namedStylesSuggestionStateSchema.optional(),
});

export const suggestedParagraphStyleSchema = z.object({
  paragraphStyle: paragraphStyleSchema.optional(),
  paragraphStyleSuggestionState: paragraphStyleSuggestionStateSchema.optional(),
});

export const suggestedPositionedObjectPropertiesSchema = z.object({
  positionedObjectProperties: positionedObjectPropertiesSchema.optional(),
  positionedObjectPropertiesSuggestionState: positionedObjectPropertiesSuggestionStateSchema.optional(),
});

export const suggestedTableCellStyleSchema = z.object({
  tableCellStyle: tableCellStyleSchema.optional(),
  tableCellStyleSuggestionState: tableCellStyleSuggestionStateSchema.optional(),
});

export const suggestedTableRowStyleSchema = z.object({
  tableRowStyle: tableRowStyleSchema.optional(),
  tableRowStyleSuggestionState: tableRowStyleSuggestionStateSchema.optional(),
});

export const suggestedTextStyleSchema = z.object({
  textStyle: textStyleSchema.optional(),
  textStyleSuggestionState: textStyleSuggestionStateSchema.optional(),
});

export const textRunSchema = z.object({
  content: z.string().optional(),
  suggestedDeletionIds: z.array(z.string()).optional(),
  suggestedInsertionIds: z.array(z.string()).optional(),
  suggestedTextStyleChanges: z.record(suggestedTextStyleSchema).optional(),
  textStyle: textStyleSchema.optional(),
});

export const docsDocumentsBatchUpdateResponseSchema = batchUpdateDocumentResponseSchema;

export const autoTextSchema = z.object({
  suggestedDeletionIds: z.array(z.string()).optional(),
  suggestedInsertionIds: z.array(z.string()).optional(),
  suggestedTextStyleChanges: z.record(suggestedTextStyleSchema).optional(),
  textStyle: textStyleSchema.optional(),
  type: z.union([z.literal('TYPE_UNSPECIFIED'), z.literal('PAGE_NUMBER'), z.literal('PAGE_COUNT')]).optional(),
});

export const requestSchema = z.object({
  createFooter: createFooterRequestSchema.optional(),
  createFootnote: createFootnoteRequestSchema.optional(),
  createHeader: createHeaderRequestSchema.optional(),
  createNamedRange: createNamedRangeRequestSchema.optional(),
  createParagraphBullets: createParagraphBulletsRequestSchema.optional(),
  deleteContentRange: deleteContentRangeRequestSchema.optional(),
  deleteFooter: deleteFooterRequestSchema.optional(),
  deleteHeader: deleteHeaderRequestSchema.optional(),
  deleteNamedRange: deleteNamedRangeRequestSchema.optional(),
  deleteParagraphBullets: deleteParagraphBulletsRequestSchema.optional(),
  deletePositionedObject: deletePositionedObjectRequestSchema.optional(),
  deleteTableColumn: deleteTableColumnRequestSchema.optional(),
  deleteTableRow: deleteTableRowRequestSchema.optional(),
  insertInlineImage: insertInlineImageRequestSchema.optional(),
  insertPageBreak: insertPageBreakRequestSchema.optional(),
  insertSectionBreak: insertSectionBreakRequestSchema.optional(),
  insertTable: insertTableRequestSchema.optional(),
  insertTableColumn: insertTableColumnRequestSchema.optional(),
  insertTableRow: insertTableRowRequestSchema.optional(),
  insertText: insertTextRequestSchema.optional(),
  mergeTableCells: mergeTableCellsRequestSchema.optional(),
  pinTableHeaderRows: pinTableHeaderRowsRequestSchema.optional(),
  replaceAllText: replaceAllTextRequestSchema.optional(),
  replaceImage: replaceImageRequestSchema.optional(),
  replaceNamedRangeContent: replaceNamedRangeContentRequestSchema.optional(),
  unmergeTableCells: unmergeTableCellsRequestSchema.optional(),
  updateDocumentStyle: updateDocumentStyleRequestSchema.optional(),
  updateParagraphStyle: updateParagraphStyleRequestSchema.optional(),
  updateSectionStyle: updateSectionStyleRequestSchema.optional(),
  updateTableCellStyle: updateTableCellStyleRequestSchema.optional(),
  updateTableColumnProperties: updateTableColumnPropertiesRequestSchema.optional(),
  updateTableRowStyle: updateTableRowStyleRequestSchema.optional(),
  updateTextStyle: updateTextStyleRequestSchema.optional(),
});

export const columnBreakSchema = z.object({
  suggestedDeletionIds: z.array(z.string()).optional(),
  suggestedInsertionIds: z.array(z.string()).optional(),
  suggestedTextStyleChanges: z.record(suggestedTextStyleSchema).optional(),
  textStyle: textStyleSchema.optional(),
});

export const footnoteReferenceSchema = z.object({
  footnoteId: z.string().optional(),
  footnoteNumber: z.string().optional(),
  suggestedDeletionIds: z.array(z.string()).optional(),
  suggestedInsertionIds: z.array(z.string()).optional(),
  suggestedTextStyleChanges: z.record(suggestedTextStyleSchema).optional(),
  textStyle: textStyleSchema.optional(),
});

export const horizontalRuleSchema = z.object({
  suggestedDeletionIds: z.array(z.string()).optional(),
  suggestedInsertionIds: z.array(z.string()).optional(),
  suggestedTextStyleChanges: z.record(suggestedTextStyleSchema).optional(),
  textStyle: textStyleSchema.optional(),
});

export const inlineObjectElementSchema = z.object({
  inlineObjectId: z.string().optional(),
  suggestedDeletionIds: z.array(z.string()).optional(),
  suggestedInsertionIds: z.array(z.string()).optional(),
  suggestedTextStyleChanges: z.record(suggestedTextStyleSchema).optional(),
  textStyle: textStyleSchema.optional(),
});

export const pageBreakSchema = z.object({
  suggestedDeletionIds: z.array(z.string()).optional(),
  suggestedInsertionIds: z.array(z.string()).optional(),
  suggestedTextStyleChanges: z.record(suggestedTextStyleSchema).optional(),
  textStyle: textStyleSchema.optional(),
});

export const personSchema = z.object({
  personId: z.string().optional(),
  personProperties: personPropertiesSchema.optional(),
  suggestedDeletionIds: z.array(z.string()).optional(),
  suggestedInsertionIds: z.array(z.string()).optional(),
  suggestedTextStyleChanges: z.record(suggestedTextStyleSchema).optional(),
  textStyle: textStyleSchema.optional(),
});

export const richLinkSchema = z.object({
  richLinkId: z.string().optional(),
  richLinkProperties: richLinkPropertiesSchema.optional(),
  suggestedDeletionIds: z.array(z.string()).optional(),
  suggestedInsertionIds: z.array(z.string()).optional(),
  suggestedTextStyleChanges: z.record(suggestedTextStyleSchema).optional(),
  textStyle: textStyleSchema.optional(),
});

export const positionedObjectSchema = z.object({
  objectId: z.string().optional(),
  positionedObjectProperties: positionedObjectPropertiesSchema.optional(),
  suggestedDeletionIds: z.array(z.string()).optional(),
  suggestedInsertionId: z.string().optional(),
  suggestedPositionedObjectPropertiesChanges: z.record(suggestedPositionedObjectPropertiesSchema).optional(),
});

export const suggestedInlineObjectPropertiesSchema = z.object({
  inlineObjectProperties: inlineObjectPropertiesSchema.optional(),
  inlineObjectPropertiesSuggestionState: inlineObjectPropertiesSuggestionStateSchema.optional(),
});

export const suggestedListPropertiesSchema = z.object({
  listProperties: listPropertiesSchema.optional(),
  listPropertiesSuggestionState: listPropertiesSuggestionStateSchema.optional(),
});

export const batchUpdateDocumentRequestSchema = z.object({
  requests: z.array(requestSchema).optional(),
  writeControl: writeControlSchema.optional(),
});

export const inlineObjectSchema = z.object({
  inlineObjectProperties: inlineObjectPropertiesSchema.optional(),
  objectId: z.string().optional(),
  suggestedDeletionIds: z.array(z.string()).optional(),
  suggestedInlineObjectPropertiesChanges: z.record(suggestedInlineObjectPropertiesSchema).optional(),
  suggestedInsertionId: z.string().optional(),
});

export const listSchema = z.object({
  listProperties: listPropertiesSchema.optional(),
  suggestedDeletionIds: z.array(z.string()).optional(),
  suggestedInsertionId: z.string().optional(),
  suggestedListPropertiesChanges: z.record(suggestedListPropertiesSchema).optional(),
});

export const paragraphElementSchema = z.object({
  autoText: autoTextSchema.optional(),
  columnBreak: columnBreakSchema.optional(),
  endIndex: z.number().optional(),
  equation: equationSchema.optional(),
  footnoteReference: footnoteReferenceSchema.optional(),
  horizontalRule: horizontalRuleSchema.optional(),
  inlineObjectElement: inlineObjectElementSchema.optional(),
  pageBreak: pageBreakSchema.optional(),
  person: personSchema.optional(),
  richLink: richLinkSchema.optional(),
  startIndex: z.number().optional(),
  textRun: textRunSchema.optional(),
});

export const paragraphSchema = z.object({
  bullet: bulletSchema.optional(),
  elements: z.array(paragraphElementSchema).optional(),
  paragraphStyle: paragraphStyleSchema.optional(),
  positionedObjectIds: z.array(z.string()).optional(),
  suggestedBulletChanges: z.record(suggestedBulletSchema).optional(),
  suggestedParagraphStyleChanges: z.record(suggestedParagraphStyleSchema).optional(),
  suggestedPositionedObjectIds: z.record(objectReferencesSchema).optional(),
});

export const docsDocumentsBatchUpdateDataSchema = z.object({
  body: batchUpdateDocumentRequestSchema.optional(),
  path: z.object({
    documentId: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const bodySchema: z.ZodSchema<Body> = z.lazy(() =>
  z.object({
    content: z.array(structuralElementSchema).optional(),
  }),
);

export const structuralElementSchema: z.ZodSchema<StructuralElement> = z.lazy(() =>
  z.object({
    endIndex: z.number().optional(),
    paragraph: paragraphSchema.optional(),
    sectionBreak: sectionBreakSchema.optional(),
    startIndex: z.number().optional(),
    table: tableSchema.optional(),
    tableOfContents: tableOfContentsSchema.optional(),
  }),
);

export const documentSchema: z.ZodSchema<Document> = z.lazy(() =>
  z.object({
    body: bodySchema.optional(),
    documentId: z.string().optional(),
    documentStyle: documentStyleSchema.optional(),
    footers: z.record(footerSchema).optional(),
    footnotes: z.record(footnoteSchema).optional(),
    headers: z.record(headerSchema).optional(),
    inlineObjects: z.record(inlineObjectSchema).optional(),
    lists: z.record(listSchema).optional(),
    namedRanges: z.record(namedRangesSchema).optional(),
    namedStyles: namedStylesSchema.optional(),
    positionedObjects: z.record(positionedObjectSchema).optional(),
    revisionId: z.string().optional(),
    suggestedDocumentStyleChanges: z.record(suggestedDocumentStyleSchema).optional(),
    suggestedNamedStylesChanges: z.record(suggestedNamedStylesSchema).optional(),
    suggestionsViewMode: z
      .union([
        z.literal('DEFAULT_FOR_CURRENT_ACCESS'),
        z.literal('SUGGESTIONS_INLINE'),
        z.literal('PREVIEW_SUGGESTIONS_ACCEPTED'),
        z.literal('PREVIEW_WITHOUT_SUGGESTIONS'),
      ])
      .optional(),
    title: z.string().optional(),
  }),
);

export const footerSchema: z.ZodSchema<Footer> = z.lazy(() =>
  z.object({
    content: z.array(structuralElementSchema).optional(),
    footerId: z.string().optional(),
  }),
);

export const footnoteSchema: z.ZodSchema<Footnote> = z.lazy(() =>
  z.object({
    content: z.array(structuralElementSchema).optional(),
    footnoteId: z.string().optional(),
  }),
);

export const headerSchema: z.ZodSchema<Header> = z.lazy(() =>
  z.object({
    content: z.array(structuralElementSchema).optional(),
    headerId: z.string().optional(),
  }),
);

export const tableSchema: z.ZodSchema<Table> = z.lazy(() =>
  z.object({
    columns: z.number().optional(),
    rows: z.number().optional(),
    suggestedDeletionIds: z.array(z.string()).optional(),
    suggestedInsertionIds: z.array(z.string()).optional(),
    tableRows: z.array(tableRowSchema).optional(),
    tableStyle: tableStyleSchema.optional(),
  }),
);

export const tableOfContentsSchema: z.ZodSchema<TableOfContents> = z.lazy(() =>
  z.object({
    content: z.array(structuralElementSchema).optional(),
    suggestedDeletionIds: z.array(z.string()).optional(),
    suggestedInsertionIds: z.array(z.string()).optional(),
  }),
);

export const tableRowSchema: z.ZodSchema<TableRow> = z.lazy(() =>
  z.object({
    endIndex: z.number().optional(),
    startIndex: z.number().optional(),
    suggestedDeletionIds: z.array(z.string()).optional(),
    suggestedInsertionIds: z.array(z.string()).optional(),
    suggestedTableRowStyleChanges: z.record(suggestedTableRowStyleSchema).optional(),
    tableCells: z.array(tableCellSchema).optional(),
    tableRowStyle: tableRowStyleSchema.optional(),
  }),
);

export const tableCellSchema: z.ZodSchema<TableCell> = z.lazy(() =>
  z.object({
    content: z.array(structuralElementSchema).optional(),
    endIndex: z.number().optional(),
    startIndex: z.number().optional(),
    suggestedDeletionIds: z.array(z.string()).optional(),
    suggestedInsertionIds: z.array(z.string()).optional(),
    suggestedTableCellStyleChanges: z.record(suggestedTableCellStyleSchema).optional(),
    tableCellStyle: tableCellStyleSchema.optional(),
  }),
);

export const docsDocumentsCreateDataSchema: z.ZodSchema<DocsDocumentsCreateData> = z.lazy(() =>
  z.object({
    body: documentSchema.optional(),
    query: z
      .object({
        '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
        access_token: z.string().optional(),
        alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
        callback: z.string().optional(),
        fields: z.string().optional(),
        key: z.string().optional(),
        oauth_token: z.string().optional(),
        prettyPrint: z.boolean().optional(),
        quotaUser: z.string().optional(),
        upload_protocol: z.string().optional(),
        uploadType: z.string().optional(),
      })
      .optional(),
  }),
);

export const docsDocumentsCreateResponseSchema: z.ZodSchema<DocsDocumentsCreateResponse> = z.lazy(() => documentSchema);

export const docsDocumentsGetResponseSchema: z.ZodSchema<DocsDocumentsGetResponse> = z.lazy(() => documentSchema);
