// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  DocsDocumentsCreateData,
  DocsDocumentsCreateError,
  DocsDocumentsCreateResponse,
  DocsDocumentsGetData,
  DocsDocumentsGetError,
  DocsDocumentsGetResponse,
  DocsDocumentsBatchUpdateData,
  DocsDocumentsBatchUpdateError,
  DocsDocumentsBatchUpdateResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Creates a blank document using the title given in the request. Other fields in the request, including any provided content, are ignored. Returns the created document.
 */
export const docsDocumentsCreate = <ThrowOnError extends boolean = false>(
  options?: Options<DocsDocumentsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<DocsDocumentsCreateResponse, DocsDocumentsCreateError, ThrowOnError>({
    ...options,
    url: '/v1/documents',
  });
};

/**
 * Gets the latest version of the specified document.
 */
export const docsDocumentsGet = <ThrowOnError extends boolean = false>(
  options: Options<DocsDocumentsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<DocsDocumentsGetResponse, DocsDocumentsGetError, ThrowOnError>({
    ...options,
    url: '/v1/documents/{documentId}',
  });
};

/**
 * Applies one or more updates to the document. Each request is validated before being applied. If any request is not valid, then the entire request will fail and nothing will be applied. Some requests have replies to give you some information about how they are applied. Other requests do not need to return information; these each return an empty reply. The order of replies matches that of the requests. For example, suppose you call batchUpdate with four updates, and only the third one returns information. The response would have two empty replies, the reply to the third request, and another empty reply, in that order. Because other users may be editing the document, the document might not exactly reflect your changes: your changes may be altered with respect to collaborator changes. If there are no collaborators, the document should reflect your changes. In any case, the updates in your request are guaranteed to be applied together atomically.
 */
export const docsDocumentsBatchUpdate = <ThrowOnError extends boolean = false>(
  options: Options<DocsDocumentsBatchUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    DocsDocumentsBatchUpdateResponse,
    DocsDocumentsBatchUpdateError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/documents/{documentId}:batchUpdate',
  });
};
