// Generated by ts-to-zod
import { z } from 'zod';

export const aclRuleSchema = z.object({
  etag: z.string().optional(),
  id: z.string().optional(),
  kind: z.string().optional(),
  role: z.string().optional(),
  scope: z
    .object({
      type: z.string().optional(),
      value: z.string().optional(),
    })
    .optional(),
});

export const conferencePropertiesSchema = z.object({
  allowedConferenceSolutionTypes: z.array(z.string()).optional(),
});

export const eventReminderSchema = z.object({
  method: z.string().optional(),
  minutes: z.number().optional(),
});

export const calendarNotificationSchema = z.object({
  method: z.string().optional(),
  type: z.string().optional(),
});

export const channelSchema = z.object({
  address: z.string().optional(),
  expiration: z.string().optional(),
  id: z.string().optional(),
  kind: z.string().optional(),
  params: z.record(z.string()).optional(),
  payload: z.boolean().optional(),
  resourceId: z.string().optional(),
  resourceUri: z.string().optional(),
  token: z.string().optional(),
  type: z.string().optional(),
});

export const colorDefinitionSchema = z.object({
  background: z.string().optional(),
  foreground: z.string().optional(),
});

export const colorsSchema = z.object({
  calendar: z.record(colorDefinitionSchema).optional(),
  event: z.record(colorDefinitionSchema).optional(),
  kind: z.string().optional(),
  updated: z.string().optional(),
});

export const entryPointSchema = z.object({
  accessCode: z.string().optional(),
  entryPointFeatures: z.array(z.string()).optional(),
  entryPointType: z.string().optional(),
  label: z.string().optional(),
  meetingCode: z.string().optional(),
  passcode: z.string().optional(),
  password: z.string().optional(),
  pin: z.string().optional(),
  regionCode: z.string().optional(),
  uri: z.string().optional(),
});

export const conferenceParametersAddOnParametersSchema = z.object({
  parameters: z.record(z.string()).optional(),
});

export const conferenceRequestStatusSchema = z.object({
  statusCode: z.string().optional(),
});

export const conferenceSolutionKeySchema = z.object({
  type: z.string().optional(),
});

export const createConferenceRequestSchema = z.object({
  conferenceSolutionKey: conferenceSolutionKeySchema.optional(),
  requestId: z.string().optional(),
  status: conferenceRequestStatusSchema.optional(),
});

export const errorSchema = z.object({
  domain: z.string().optional(),
  reason: z.string().optional(),
});

export const eventAttachmentSchema = z.object({
  fileId: z.string().optional(),
  fileUrl: z.string().optional(),
  iconLink: z.string().optional(),
  mimeType: z.string().optional(),
  title: z.string().optional(),
});

export const eventAttendeeSchema = z.object({
  additionalGuests: z.number().optional(),
  comment: z.string().optional(),
  displayName: z.string().optional(),
  email: z.string().optional(),
  id: z.string().optional(),
  optional: z.boolean().optional(),
  organizer: z.boolean().optional(),
  resource: z.boolean().optional(),
  responseStatus: z.string().optional(),
  self: z.boolean().optional(),
});

export const eventDateTimeSchema = z.object({
  date: z.string().optional(),
  dateTime: z.string().optional(),
  timeZone: z.string().optional(),
});

export const eventFocusTimePropertiesSchema = z.object({
  autoDeclineMode: z.string().optional(),
  chatStatus: z.string().optional(),
  declineMessage: z.string().optional(),
});

export const eventOutOfOfficePropertiesSchema = z.object({
  autoDeclineMode: z.string().optional(),
  declineMessage: z.string().optional(),
});

export const eventWorkingLocationPropertiesSchema = z.object({
  customLocation: z
    .object({
      label: z.string().optional(),
    })
    .optional(),
  homeOffice: z.unknown().optional(),
  officeLocation: z
    .object({
      buildingId: z.string().optional(),
      deskId: z.string().optional(),
      floorId: z.string().optional(),
      floorSectionId: z.string().optional(),
      label: z.string().optional(),
    })
    .optional(),
  type: z.string().optional(),
});

export const timePeriodSchema = z.object({
  end: z.string().optional(),
  start: z.string().optional(),
});

export const freeBusyGroupSchema = z.object({
  calendars: z.array(z.string()).optional(),
  errors: z.array(errorSchema).optional(),
});

export const freeBusyRequestItemSchema = z.object({
  id: z.string().optional(),
});

export const settingSchema = z.object({
  etag: z.string().optional(),
  id: z.string().optional(),
  kind: z.string().optional(),
  value: z.string().optional(),
});

export const settingsSchema = z.object({
  etag: z.string().optional(),
  items: z.array(settingSchema).optional(),
  kind: z.string().optional(),
  nextPageToken: z.string().optional(),
  nextSyncToken: z.string().optional(),
});

export const parameteraltSchema = z.literal('json');

export const parameterfieldsSchema = z.string();

export const parameterkeySchema = z.string();

export const parameteroauthTokenSchema = z.string();

export const parameterprettyPrintSchema = z.boolean();

export const parameterquotaUserSchema = z.string();

export const parameteruserIpSchema = z.string();

export const calendarSchema = z.object({
  conferenceProperties: conferencePropertiesSchema.optional(),
  description: z.string().optional(),
  etag: z.string().optional(),
  id: z.string().optional(),
  kind: z.string().optional(),
  location: z.string().optional(),
  summary: z.string().optional(),
  timeZone: z.string().optional(),
});

export const calendarCalendarsInsertResponseSchema = calendarSchema;

export const calendarCalendarsInsertErrorSchema = z.unknown();

export const calendarCalendarsDeleteDataSchema = z.object({
  path: z.object({
    calendarId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarCalendarsDeleteResponseSchema = z.unknown();

export const calendarCalendarsDeleteErrorSchema = z.unknown();

export const calendarCalendarsGetDataSchema = z.object({
  path: z.object({
    calendarId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarCalendarsGetResponseSchema = calendarSchema;

export const calendarCalendarsGetErrorSchema = z.unknown();

export const calendarCalendarsPatchDataSchema = z.object({
  body: calendarSchema.optional(),
  path: z.object({
    calendarId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarCalendarsPatchResponseSchema = calendarSchema;

export const calendarCalendarsPatchErrorSchema = z.unknown();

export const calendarCalendarsUpdateDataSchema = z.object({
  body: calendarSchema.optional(),
  path: z.object({
    calendarId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarCalendarsUpdateResponseSchema = calendarSchema;

export const calendarCalendarsUpdateErrorSchema = z.unknown();

export const calendarAclListDataSchema = z.object({
  path: z.object({
    calendarId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      maxResults: z.number().optional(),
      oauth_token: z.string().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      showDeleted: z.boolean().optional(),
      syncToken: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const aclSchema = z.object({
  etag: z.string().optional(),
  items: z.array(aclRuleSchema).optional(),
  kind: z.string().optional(),
  nextPageToken: z.string().optional(),
  nextSyncToken: z.string().optional(),
});

export const calendarAclListErrorSchema = z.unknown();

export const calendarAclInsertDataSchema = z.object({
  body: aclRuleSchema.optional(),
  path: z.object({
    calendarId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      sendNotifications: z.boolean().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarAclInsertResponseSchema = aclRuleSchema;

export const calendarAclInsertErrorSchema = z.unknown();

export const calendarAclWatchDataSchema = z.object({
  body: channelSchema.optional(),
  path: z.object({
    calendarId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      maxResults: z.number().optional(),
      oauth_token: z.string().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      showDeleted: z.boolean().optional(),
      syncToken: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarAclWatchResponseSchema = channelSchema;

export const calendarAclWatchErrorSchema = z.unknown();

export const calendarAclDeleteDataSchema = z.object({
  path: z.object({
    calendarId: z.string(),
    ruleId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarAclDeleteResponseSchema = z.unknown();

export const calendarAclDeleteErrorSchema = z.unknown();

export const calendarAclGetDataSchema = z.object({
  path: z.object({
    calendarId: z.string(),
    ruleId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarAclGetResponseSchema = aclRuleSchema;

export const calendarAclGetErrorSchema = z.unknown();

export const calendarAclPatchDataSchema = z.object({
  body: aclRuleSchema.optional(),
  path: z.object({
    calendarId: z.string(),
    ruleId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      sendNotifications: z.boolean().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarAclPatchResponseSchema = aclRuleSchema;

export const calendarAclPatchErrorSchema = z.unknown();

export const calendarAclUpdateDataSchema = z.object({
  body: aclRuleSchema.optional(),
  path: z.object({
    calendarId: z.string(),
    ruleId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      sendNotifications: z.boolean().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarAclUpdateResponseSchema = aclRuleSchema;

export const calendarAclUpdateErrorSchema = z.unknown();

export const calendarCalendarsClearDataSchema = z.object({
  path: z.object({
    calendarId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarCalendarsClearResponseSchema = z.unknown();

export const calendarCalendarsClearErrorSchema = z.unknown();

export const calendarEventsListDataSchema = z.object({
  path: z.object({
    calendarId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      alwaysIncludeEmail: z.boolean().optional(),
      eventTypes: z
        .array(
          z.union([
            z.literal('default'),
            z.literal('focusTime'),
            z.literal('outOfOffice'),
            z.literal('workingLocation'),
          ]),
        )
        .optional(),
      fields: z.string().optional(),
      iCalUID: z.string().optional(),
      key: z.string().optional(),
      maxAttendees: z.number().optional(),
      maxResults: z.number().optional(),
      oauth_token: z.string().optional(),
      orderBy: z.union([z.literal('startTime'), z.literal('updated')]).optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      privateExtendedProperty: z.array(z.string()).optional(),
      q: z.string().optional(),
      quotaUser: z.string().optional(),
      sharedExtendedProperty: z.array(z.string()).optional(),
      showDeleted: z.boolean().optional(),
      showHiddenInvitations: z.boolean().optional(),
      singleEvents: z.boolean().optional(),
      syncToken: z.string().optional(),
      timeMax: z.string().optional(),
      timeMin: z.string().optional(),
      timeZone: z.string().optional(),
      updatedMin: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarEventsListErrorSchema = z.unknown();

export const calendarEventsInsertErrorSchema = z.unknown();

export const calendarEventsImportErrorSchema = z.unknown();

export const calendarEventsQuickAddDataSchema = z.object({
  path: z.object({
    calendarId: z.string(),
  }),
  query: z.object({
    alt: z.literal('json').optional(),
    fields: z.string().optional(),
    key: z.string().optional(),
    oauth_token: z.string().optional(),
    prettyPrint: z.boolean().optional(),
    quotaUser: z.string().optional(),
    sendNotifications: z.boolean().optional(),
    sendUpdates: z.union([z.literal('all'), z.literal('externalOnly'), z.literal('none')]).optional(),
    text: z.string(),
    userIp: z.string().optional(),
  }),
});

export const calendarEventsQuickAddErrorSchema = z.unknown();

export const calendarEventsWatchDataSchema = z.object({
  body: channelSchema.optional(),
  path: z.object({
    calendarId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      alwaysIncludeEmail: z.boolean().optional(),
      eventTypes: z
        .array(
          z.union([
            z.literal('default'),
            z.literal('focusTime'),
            z.literal('outOfOffice'),
            z.literal('workingLocation'),
          ]),
        )
        .optional(),
      fields: z.string().optional(),
      iCalUID: z.string().optional(),
      key: z.string().optional(),
      maxAttendees: z.number().optional(),
      maxResults: z.number().optional(),
      oauth_token: z.string().optional(),
      orderBy: z.union([z.literal('startTime'), z.literal('updated')]).optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      privateExtendedProperty: z.array(z.string()).optional(),
      q: z.string().optional(),
      quotaUser: z.string().optional(),
      sharedExtendedProperty: z.array(z.string()).optional(),
      showDeleted: z.boolean().optional(),
      showHiddenInvitations: z.boolean().optional(),
      singleEvents: z.boolean().optional(),
      syncToken: z.string().optional(),
      timeMax: z.string().optional(),
      timeMin: z.string().optional(),
      timeZone: z.string().optional(),
      updatedMin: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarEventsWatchResponseSchema = channelSchema;

export const calendarEventsWatchErrorSchema = z.unknown();

export const calendarEventsDeleteDataSchema = z.object({
  path: z.object({
    calendarId: z.string(),
    eventId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      sendNotifications: z.boolean().optional(),
      sendUpdates: z.union([z.literal('all'), z.literal('externalOnly'), z.literal('none')]).optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarEventsDeleteResponseSchema = z.unknown();

export const calendarEventsDeleteErrorSchema = z.unknown();

export const calendarEventsGetDataSchema = z.object({
  path: z.object({
    calendarId: z.string(),
    eventId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      alwaysIncludeEmail: z.boolean().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      maxAttendees: z.number().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      timeZone: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarEventsGetErrorSchema = z.unknown();

export const calendarEventsPatchErrorSchema = z.unknown();

export const calendarEventsUpdateErrorSchema = z.unknown();

export const calendarEventsInstancesDataSchema = z.object({
  path: z.object({
    calendarId: z.string(),
    eventId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      alwaysIncludeEmail: z.boolean().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      maxAttendees: z.number().optional(),
      maxResults: z.number().optional(),
      oauth_token: z.string().optional(),
      originalStart: z.string().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      showDeleted: z.boolean().optional(),
      timeMax: z.string().optional(),
      timeMin: z.string().optional(),
      timeZone: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarEventsInstancesErrorSchema = z.unknown();

export const calendarEventsMoveDataSchema = z.object({
  path: z.object({
    calendarId: z.string(),
    eventId: z.string(),
  }),
  query: z.object({
    alt: z.literal('json').optional(),
    destination: z.string(),
    fields: z.string().optional(),
    key: z.string().optional(),
    oauth_token: z.string().optional(),
    prettyPrint: z.boolean().optional(),
    quotaUser: z.string().optional(),
    sendNotifications: z.boolean().optional(),
    sendUpdates: z.union([z.literal('all'), z.literal('externalOnly'), z.literal('none')]).optional(),
    userIp: z.string().optional(),
  }),
});

export const calendarEventsMoveErrorSchema = z.unknown();

export const calendarChannelsStopDataSchema = z.object({
  body: channelSchema.optional(),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarChannelsStopResponseSchema = z.unknown();

export const calendarChannelsStopErrorSchema = z.unknown();

export const calendarColorsGetDataSchema = z.object({
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarColorsGetResponseSchema = colorsSchema;

export const calendarColorsGetErrorSchema = z.unknown();

export const freeBusyRequestSchema = z.object({
  calendarExpansionMax: z.number().optional(),
  groupExpansionMax: z.number().optional(),
  items: z.array(freeBusyRequestItemSchema).optional(),
  timeMax: z.string().optional(),
  timeMin: z.string().optional(),
  timeZone: z.string().optional(),
});

export const calendarFreebusyQueryErrorSchema = z.unknown();

export const calendarCalendarListListDataSchema = z.object({
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      maxResults: z.number().optional(),
      minAccessRole: z
        .union([z.literal('freeBusyReader'), z.literal('owner'), z.literal('reader'), z.literal('writer')])
        .optional(),
      oauth_token: z.string().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      showDeleted: z.boolean().optional(),
      showHidden: z.boolean().optional(),
      syncToken: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarCalendarListListErrorSchema = z.unknown();

export const calendarListEntrySchema = z.object({
  accessRole: z.string().optional(),
  backgroundColor: z.string().optional(),
  colorId: z.string().optional(),
  conferenceProperties: conferencePropertiesSchema.optional(),
  defaultReminders: z.array(eventReminderSchema).optional(),
  deleted: z.boolean().optional(),
  description: z.string().optional(),
  etag: z.string().optional(),
  foregroundColor: z.string().optional(),
  hidden: z.boolean().optional(),
  id: z.string().optional(),
  kind: z.string().optional(),
  location: z.string().optional(),
  notificationSettings: z
    .object({
      notifications: z.array(calendarNotificationSchema).optional(),
    })
    .optional(),
  primary: z.boolean().optional(),
  selected: z.boolean().optional(),
  summary: z.string().optional(),
  summaryOverride: z.string().optional(),
  timeZone: z.string().optional(),
});

export const calendarCalendarListInsertResponseSchema = calendarListEntrySchema;

export const calendarCalendarListInsertErrorSchema = z.unknown();

export const calendarCalendarListWatchDataSchema = z.object({
  body: channelSchema.optional(),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      maxResults: z.number().optional(),
      minAccessRole: z
        .union([z.literal('freeBusyReader'), z.literal('owner'), z.literal('reader'), z.literal('writer')])
        .optional(),
      oauth_token: z.string().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      showDeleted: z.boolean().optional(),
      showHidden: z.boolean().optional(),
      syncToken: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarCalendarListWatchResponseSchema = channelSchema;

export const calendarCalendarListWatchErrorSchema = z.unknown();

export const calendarCalendarListDeleteDataSchema = z.object({
  path: z.object({
    calendarId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarCalendarListDeleteResponseSchema = z.unknown();

export const calendarCalendarListDeleteErrorSchema = z.unknown();

export const calendarCalendarListGetDataSchema = z.object({
  path: z.object({
    calendarId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarCalendarListGetResponseSchema = calendarListEntrySchema;

export const calendarCalendarListGetErrorSchema = z.unknown();

export const calendarCalendarListPatchDataSchema = z.object({
  body: calendarListEntrySchema.optional(),
  path: z.object({
    calendarId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      colorRgbFormat: z.boolean().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarCalendarListPatchResponseSchema = calendarListEntrySchema;

export const calendarCalendarListPatchErrorSchema = z.unknown();

export const calendarCalendarListUpdateDataSchema = z.object({
  body: calendarListEntrySchema.optional(),
  path: z.object({
    calendarId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      colorRgbFormat: z.boolean().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarCalendarListUpdateResponseSchema = calendarListEntrySchema;

export const calendarCalendarListUpdateErrorSchema = z.unknown();

export const calendarSettingsListDataSchema = z.object({
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      maxResults: z.number().optional(),
      oauth_token: z.string().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      syncToken: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarSettingsListResponseSchema = settingsSchema;

export const calendarSettingsListErrorSchema = z.unknown();

export const calendarSettingsWatchDataSchema = z.object({
  body: channelSchema.optional(),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      maxResults: z.number().optional(),
      oauth_token: z.string().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      syncToken: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarSettingsWatchResponseSchema = channelSchema;

export const calendarSettingsWatchErrorSchema = z.unknown();

export const calendarSettingsGetDataSchema = z.object({
  path: z.object({
    setting: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarSettingsGetResponseSchema = settingSchema;

export const calendarSettingsGetErrorSchema = z.unknown();

export const calendarListSchema = z.object({
  etag: z.string().optional(),
  items: z.array(calendarListEntrySchema).optional(),
  kind: z.string().optional(),
  nextPageToken: z.string().optional(),
  nextSyncToken: z.string().optional(),
});

export const conferenceSolutionSchema = z.object({
  iconUri: z.string().optional(),
  key: conferenceSolutionKeySchema.optional(),
  name: z.string().optional(),
});

export const conferenceParametersSchema = z.object({
  addOnParameters: conferenceParametersAddOnParametersSchema.optional(),
});

export const conferenceDataSchema = z.object({
  conferenceId: z.string().optional(),
  conferenceSolution: conferenceSolutionSchema.optional(),
  createRequest: createConferenceRequestSchema.optional(),
  entryPoints: z.array(entryPointSchema).optional(),
  notes: z.string().optional(),
  parameters: conferenceParametersSchema.optional(),
  signature: z.string().optional(),
});

export const eventSchema = z.object({
  anyoneCanAddSelf: z.boolean().optional(),
  attachments: z.array(eventAttachmentSchema).optional(),
  attendees: z.array(eventAttendeeSchema).optional(),
  attendeesOmitted: z.boolean().optional(),
  colorId: z.string().optional(),
  conferenceData: conferenceDataSchema.optional(),
  created: z.string().optional(),
  creator: z
    .object({
      displayName: z.string().optional(),
      email: z.string().optional(),
      id: z.string().optional(),
      self: z.boolean().optional(),
    })
    .optional(),
  description: z.string().optional(),
  end: eventDateTimeSchema.optional(),
  endTimeUnspecified: z.boolean().optional(),
  etag: z.string().optional(),
  eventType: z.string().optional(),
  extendedProperties: z
    .object({
      private: z.record(z.string()).optional(),
      shared: z.record(z.string()).optional(),
    })
    .optional(),
  focusTimeProperties: eventFocusTimePropertiesSchema.optional(),
  gadget: z
    .object({
      display: z.string().optional(),
      height: z.number().optional(),
      iconLink: z.string().optional(),
      link: z.string().optional(),
      preferences: z.record(z.string()).optional(),
      title: z.string().optional(),
      type: z.string().optional(),
      width: z.number().optional(),
    })
    .optional(),
  guestsCanInviteOthers: z.boolean().optional(),
  guestsCanModify: z.boolean().optional(),
  guestsCanSeeOtherGuests: z.boolean().optional(),
  hangoutLink: z.string().optional(),
  htmlLink: z.string().optional(),
  iCalUID: z.string().optional(),
  id: z.string().optional(),
  kind: z.string().optional(),
  location: z.string().optional(),
  locked: z.boolean().optional(),
  organizer: z
    .object({
      displayName: z.string().optional(),
      email: z.string().optional(),
      id: z.string().optional(),
      self: z.boolean().optional(),
    })
    .optional(),
  originalStartTime: eventDateTimeSchema.optional(),
  outOfOfficeProperties: eventOutOfOfficePropertiesSchema.optional(),
  privateCopy: z.boolean().optional(),
  recurrence: z.array(z.string()).optional(),
  recurringEventId: z.string().optional(),
  reminders: z
    .object({
      overrides: z.array(eventReminderSchema).optional(),
      useDefault: z.boolean().optional(),
    })
    .optional(),
  sequence: z.number().optional(),
  source: z
    .object({
      title: z.string().optional(),
      url: z.string().optional(),
    })
    .optional(),
  start: eventDateTimeSchema.optional(),
  status: z.string().optional(),
  summary: z.string().optional(),
  transparency: z.string().optional(),
  updated: z.string().optional(),
  visibility: z.string().optional(),
  workingLocationProperties: eventWorkingLocationPropertiesSchema.optional(),
});

export const freeBusyCalendarSchema = z.object({
  busy: z.array(timePeriodSchema).optional(),
  errors: z.array(errorSchema).optional(),
});

export const freeBusyResponseSchema = z.object({
  calendars: z.record(freeBusyCalendarSchema).optional(),
  groups: z.record(freeBusyGroupSchema).optional(),
  kind: z.string().optional(),
  timeMax: z.string().optional(),
  timeMin: z.string().optional(),
});

export const calendarCalendarsInsertDataSchema = z.object({
  body: calendarSchema.optional(),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarAclListResponseSchema = aclSchema;

export const eventsSchema = z.object({
  accessRole: z.string().optional(),
  defaultReminders: z.array(eventReminderSchema).optional(),
  description: z.string().optional(),
  etag: z.string().optional(),
  items: z.array(eventSchema).optional(),
  kind: z.string().optional(),
  nextPageToken: z.string().optional(),
  nextSyncToken: z.string().optional(),
  summary: z.string().optional(),
  timeZone: z.string().optional(),
  updated: z.string().optional(),
});

export const calendarEventsInsertDataSchema = z.object({
  body: eventSchema.optional(),
  path: z.object({
    calendarId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      conferenceDataVersion: z.number().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      maxAttendees: z.number().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      sendNotifications: z.boolean().optional(),
      sendUpdates: z.union([z.literal('all'), z.literal('externalOnly'), z.literal('none')]).optional(),
      supportsAttachments: z.boolean().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarEventsInsertResponseSchema = eventSchema;

export const calendarEventsImportDataSchema = z.object({
  body: eventSchema.optional(),
  path: z.object({
    calendarId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      conferenceDataVersion: z.number().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      supportsAttachments: z.boolean().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarEventsImportResponseSchema = eventSchema;

export const calendarEventsQuickAddResponseSchema = eventSchema;

export const calendarEventsGetResponseSchema = eventSchema;

export const calendarEventsPatchDataSchema = z.object({
  body: eventSchema.optional(),
  path: z.object({
    calendarId: z.string(),
    eventId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      alwaysIncludeEmail: z.boolean().optional(),
      conferenceDataVersion: z.number().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      maxAttendees: z.number().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      sendNotifications: z.boolean().optional(),
      sendUpdates: z.union([z.literal('all'), z.literal('externalOnly'), z.literal('none')]).optional(),
      supportsAttachments: z.boolean().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarEventsPatchResponseSchema = eventSchema;

export const calendarEventsUpdateDataSchema = z.object({
  body: eventSchema.optional(),
  path: z.object({
    calendarId: z.string(),
    eventId: z.string(),
  }),
  query: z
    .object({
      alt: z.literal('json').optional(),
      alwaysIncludeEmail: z.boolean().optional(),
      conferenceDataVersion: z.number().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      maxAttendees: z.number().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      sendNotifications: z.boolean().optional(),
      sendUpdates: z.union([z.literal('all'), z.literal('externalOnly'), z.literal('none')]).optional(),
      supportsAttachments: z.boolean().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarEventsUpdateResponseSchema = eventSchema;

export const calendarEventsInstancesResponseSchema = eventsSchema;

export const calendarEventsMoveResponseSchema = eventSchema;

export const calendarFreebusyQueryDataSchema = z.object({
  body: freeBusyRequestSchema.optional(),
  query: z
    .object({
      alt: z.literal('json').optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarFreebusyQueryResponseSchema = freeBusyResponseSchema;

export const calendarCalendarListListResponseSchema = calendarListSchema;

export const calendarCalendarListInsertDataSchema = z.object({
  body: calendarListEntrySchema.optional(),
  query: z
    .object({
      alt: z.literal('json').optional(),
      colorRgbFormat: z.boolean().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      userIp: z.string().optional(),
    })
    .optional(),
});

export const calendarEventsListResponseSchema = eventsSchema;
