// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  CalendarCalendarsInsertData,
  CalendarCalendarsInsertError,
  CalendarCalendarsInsertResponse,
  CalendarCalendarsDeleteData,
  CalendarCalendarsDeleteError,
  CalendarCalendarsDeleteResponse,
  CalendarCalendarsGetData,
  CalendarCalendarsGetError,
  CalendarCalendarsGetResponse,
  CalendarCalendarsPatchData,
  CalendarCalendarsPatchError,
  CalendarCalendarsPatchResponse,
  CalendarCalendarsUpdateData,
  CalendarCalendarsUpdateError,
  CalendarCalendarsUpdateResponse,
  CalendarAclListData,
  CalendarAclListError,
  CalendarAclListResponse,
  CalendarAclInsertData,
  CalendarAclInsertError,
  CalendarAclInsertResponse,
  CalendarAclWatchData,
  CalendarAclWatchError,
  CalendarAclWatchResponse,
  CalendarAclDeleteData,
  CalendarAclDeleteError,
  CalendarAclDeleteResponse,
  CalendarAclGetData,
  CalendarAclGetError,
  CalendarAclGetResponse,
  CalendarAclPatchData,
  CalendarAclPatchError,
  CalendarAclPatchResponse,
  CalendarAclUpdateData,
  CalendarAclUpdateError,
  CalendarAclUpdateResponse,
  CalendarCalendarsClearData,
  CalendarCalendarsClearError,
  CalendarCalendarsClearResponse,
  CalendarEventsListData,
  CalendarEventsListError,
  CalendarEventsListResponse,
  CalendarEventsInsertData,
  CalendarEventsInsertError,
  CalendarEventsInsertResponse,
  CalendarEventsImportData,
  CalendarEventsImportError,
  CalendarEventsImportResponse,
  CalendarEventsQuickAddData,
  CalendarEventsQuickAddError,
  CalendarEventsQuickAddResponse,
  CalendarEventsWatchData,
  CalendarEventsWatchError,
  CalendarEventsWatchResponse,
  CalendarEventsDeleteData,
  CalendarEventsDeleteError,
  CalendarEventsDeleteResponse,
  CalendarEventsGetData,
  CalendarEventsGetError,
  CalendarEventsGetResponse,
  CalendarEventsPatchData,
  CalendarEventsPatchError,
  CalendarEventsPatchResponse,
  CalendarEventsUpdateData,
  CalendarEventsUpdateError,
  CalendarEventsUpdateResponse,
  CalendarEventsInstancesData,
  CalendarEventsInstancesError,
  CalendarEventsInstancesResponse,
  CalendarEventsMoveData,
  CalendarEventsMoveError,
  CalendarEventsMoveResponse,
  CalendarChannelsStopData,
  CalendarChannelsStopError,
  CalendarChannelsStopResponse,
  CalendarColorsGetData,
  CalendarColorsGetError,
  CalendarColorsGetResponse,
  CalendarFreebusyQueryData,
  CalendarFreebusyQueryError,
  CalendarFreebusyQueryResponse,
  CalendarCalendarListListData,
  CalendarCalendarListListError,
  CalendarCalendarListListResponse,
  CalendarCalendarListInsertData,
  CalendarCalendarListInsertError,
  CalendarCalendarListInsertResponse,
  CalendarCalendarListWatchData,
  CalendarCalendarListWatchError,
  CalendarCalendarListWatchResponse,
  CalendarCalendarListDeleteData,
  CalendarCalendarListDeleteError,
  CalendarCalendarListDeleteResponse,
  CalendarCalendarListGetData,
  CalendarCalendarListGetError,
  CalendarCalendarListGetResponse,
  CalendarCalendarListPatchData,
  CalendarCalendarListPatchError,
  CalendarCalendarListPatchResponse,
  CalendarCalendarListUpdateData,
  CalendarCalendarListUpdateError,
  CalendarCalendarListUpdateResponse,
  CalendarSettingsListData,
  CalendarSettingsListError,
  CalendarSettingsListResponse,
  CalendarSettingsWatchData,
  CalendarSettingsWatchError,
  CalendarSettingsWatchResponse,
  CalendarSettingsGetData,
  CalendarSettingsGetError,
  CalendarSettingsGetResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Creates a secondary calendar.
 */
export const calendarCalendarsInsert = <ThrowOnError extends boolean = false>(
  options?: Options<CalendarCalendarsInsertData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CalendarCalendarsInsertResponse, CalendarCalendarsInsertError, ThrowOnError>({
    ...options,
    url: '/calendars',
  });
};

/**
 * Deletes a secondary calendar. Use calendars.clear for clearing all events on primary calendars.
 */
export const calendarCalendarsDelete = <ThrowOnError extends boolean = false>(
  options: Options<CalendarCalendarsDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    CalendarCalendarsDeleteResponse,
    CalendarCalendarsDeleteError,
    ThrowOnError
  >({
    ...options,
    url: '/calendars/{calendarId}',
  });
};

/**
 * Returns metadata for a calendar.
 */
export const calendarCalendarsGet = <ThrowOnError extends boolean = false>(
  options: Options<CalendarCalendarsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CalendarCalendarsGetResponse, CalendarCalendarsGetError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}',
  });
};

/**
 * Updates metadata for a calendar. This method supports patch semantics.
 */
export const calendarCalendarsPatch = <ThrowOnError extends boolean = false>(
  options: Options<CalendarCalendarsPatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<CalendarCalendarsPatchResponse, CalendarCalendarsPatchError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}',
  });
};

/**
 * Updates metadata for a calendar.
 */
export const calendarCalendarsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<CalendarCalendarsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CalendarCalendarsUpdateResponse, CalendarCalendarsUpdateError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}',
  });
};

/**
 * Returns the rules in the access control list for the calendar.
 */
export const calendarAclList = <ThrowOnError extends boolean = false>(
  options: Options<CalendarAclListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CalendarAclListResponse, CalendarAclListError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/acl',
  });
};

/**
 * Creates an access control rule.
 */
export const calendarAclInsert = <ThrowOnError extends boolean = false>(
  options: Options<CalendarAclInsertData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CalendarAclInsertResponse, CalendarAclInsertError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/acl',
  });
};

/**
 * Watch for changes to ACL resources.
 */
export const calendarAclWatch = <ThrowOnError extends boolean = false>(
  options: Options<CalendarAclWatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CalendarAclWatchResponse, CalendarAclWatchError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/acl/watch',
  });
};

/**
 * Deletes an access control rule.
 */
export const calendarAclDelete = <ThrowOnError extends boolean = false>(
  options: Options<CalendarAclDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<CalendarAclDeleteResponse, CalendarAclDeleteError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/acl/{ruleId}',
  });
};

/**
 * Returns an access control rule.
 */
export const calendarAclGet = <ThrowOnError extends boolean = false>(
  options: Options<CalendarAclGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CalendarAclGetResponse, CalendarAclGetError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/acl/{ruleId}',
  });
};

/**
 * Updates an access control rule. This method supports patch semantics.
 */
export const calendarAclPatch = <ThrowOnError extends boolean = false>(
  options: Options<CalendarAclPatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<CalendarAclPatchResponse, CalendarAclPatchError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/acl/{ruleId}',
  });
};

/**
 * Updates an access control rule.
 */
export const calendarAclUpdate = <ThrowOnError extends boolean = false>(
  options: Options<CalendarAclUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CalendarAclUpdateResponse, CalendarAclUpdateError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/acl/{ruleId}',
  });
};

/**
 * Clears a primary calendar. This operation deletes all events associated with the primary calendar of an account.
 */
export const calendarCalendarsClear = <ThrowOnError extends boolean = false>(
  options: Options<CalendarCalendarsClearData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CalendarCalendarsClearResponse, CalendarCalendarsClearError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/clear',
  });
};

/**
 * Returns events on the specified calendar.
 */
export const calendarEventsList = <ThrowOnError extends boolean = false>(
  options: Options<CalendarEventsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CalendarEventsListResponse, CalendarEventsListError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/events',
  });
};

/**
 * Creates an event.
 */
export const calendarEventsInsert = <ThrowOnError extends boolean = false>(
  options: Options<CalendarEventsInsertData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CalendarEventsInsertResponse, CalendarEventsInsertError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/events',
  });
};

/**
 * Imports an event. This operation is used to add a private copy of an existing event to a calendar.
 */
export const calendarEventsImport = <ThrowOnError extends boolean = false>(
  options: Options<CalendarEventsImportData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CalendarEventsImportResponse, CalendarEventsImportError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/events/import',
  });
};

/**
 * Creates an event based on a simple text string.
 */
export const calendarEventsQuickAdd = <ThrowOnError extends boolean = false>(
  options: Options<CalendarEventsQuickAddData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CalendarEventsQuickAddResponse, CalendarEventsQuickAddError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/events/quickAdd',
  });
};

/**
 * Watch for changes to Events resources.
 */
export const calendarEventsWatch = <ThrowOnError extends boolean = false>(
  options: Options<CalendarEventsWatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CalendarEventsWatchResponse, CalendarEventsWatchError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/events/watch',
  });
};

/**
 * Deletes an event.
 */
export const calendarEventsDelete = <ThrowOnError extends boolean = false>(
  options: Options<CalendarEventsDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<CalendarEventsDeleteResponse, CalendarEventsDeleteError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/events/{eventId}',
  });
};

/**
 * Returns an event based on its Google Calendar ID. To retrieve an event using its iCalendar ID, call the events.list method using the iCalUID parameter.
 */
export const calendarEventsGet = <ThrowOnError extends boolean = false>(
  options: Options<CalendarEventsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CalendarEventsGetResponse, CalendarEventsGetError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/events/{eventId}',
  });
};

/**
 * Updates an event. This method supports patch semantics.
 */
export const calendarEventsPatch = <ThrowOnError extends boolean = false>(
  options: Options<CalendarEventsPatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<CalendarEventsPatchResponse, CalendarEventsPatchError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/events/{eventId}',
  });
};

/**
 * Updates an event.
 */
export const calendarEventsUpdate = <ThrowOnError extends boolean = false>(
  options: Options<CalendarEventsUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<CalendarEventsUpdateResponse, CalendarEventsUpdateError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/events/{eventId}',
  });
};

/**
 * Returns instances of the specified recurring event.
 */
export const calendarEventsInstances = <ThrowOnError extends boolean = false>(
  options: Options<CalendarEventsInstancesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CalendarEventsInstancesResponse, CalendarEventsInstancesError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/events/{eventId}/instances',
  });
};

/**
 * Moves an event to another calendar, i.e. changes an event's organizer. Note that only default events can be moved; outOfOffice, focusTime and workingLocation events cannot be moved.
 */
export const calendarEventsMove = <ThrowOnError extends boolean = false>(
  options: Options<CalendarEventsMoveData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CalendarEventsMoveResponse, CalendarEventsMoveError, ThrowOnError>({
    ...options,
    url: '/calendars/{calendarId}/events/{eventId}/move',
  });
};

/**
 * Stop watching resources through this channel
 */
export const calendarChannelsStop = <ThrowOnError extends boolean = false>(
  options?: Options<CalendarChannelsStopData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CalendarChannelsStopResponse, CalendarChannelsStopError, ThrowOnError>({
    ...options,
    url: '/channels/stop',
  });
};

/**
 * Returns the color definitions for calendars and events.
 */
export const calendarColorsGet = <ThrowOnError extends boolean = false>(
  options?: Options<CalendarColorsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CalendarColorsGetResponse, CalendarColorsGetError, ThrowOnError>({
    ...options,
    url: '/colors',
  });
};

/**
 * Returns free/busy information for a set of calendars.
 */
export const calendarFreebusyQuery = <ThrowOnError extends boolean = false>(
  options?: Options<CalendarFreebusyQueryData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CalendarFreebusyQueryResponse, CalendarFreebusyQueryError, ThrowOnError>({
    ...options,
    url: '/freeBusy',
  });
};

/**
 * Returns the calendars on the user's calendar list.
 */
export const calendarCalendarListList = <ThrowOnError extends boolean = false>(
  options?: Options<CalendarCalendarListListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CalendarCalendarListListResponse, CalendarCalendarListListError, ThrowOnError>(
    {
      ...options,
      url: '/users/me/calendarList',
    },
  );
};

/**
 * Inserts an existing calendar into the user's calendar list.
 */
export const calendarCalendarListInsert = <ThrowOnError extends boolean = false>(
  options?: Options<CalendarCalendarListInsertData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CalendarCalendarListInsertResponse,
    CalendarCalendarListInsertError,
    ThrowOnError
  >({
    ...options,
    url: '/users/me/calendarList',
  });
};

/**
 * Watch for changes to CalendarList resources.
 */
export const calendarCalendarListWatch = <ThrowOnError extends boolean = false>(
  options?: Options<CalendarCalendarListWatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    CalendarCalendarListWatchResponse,
    CalendarCalendarListWatchError,
    ThrowOnError
  >({
    ...options,
    url: '/users/me/calendarList/watch',
  });
};

/**
 * Removes a calendar from the user's calendar list.
 */
export const calendarCalendarListDelete = <ThrowOnError extends boolean = false>(
  options: Options<CalendarCalendarListDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    CalendarCalendarListDeleteResponse,
    CalendarCalendarListDeleteError,
    ThrowOnError
  >({
    ...options,
    url: '/users/me/calendarList/{calendarId}',
  });
};

/**
 * Returns a calendar from the user's calendar list.
 */
export const calendarCalendarListGet = <ThrowOnError extends boolean = false>(
  options: Options<CalendarCalendarListGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CalendarCalendarListGetResponse, CalendarCalendarListGetError, ThrowOnError>({
    ...options,
    url: '/users/me/calendarList/{calendarId}',
  });
};

/**
 * Updates an existing calendar on the user's calendar list. This method supports patch semantics.
 */
export const calendarCalendarListPatch = <ThrowOnError extends boolean = false>(
  options: Options<CalendarCalendarListPatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    CalendarCalendarListPatchResponse,
    CalendarCalendarListPatchError,
    ThrowOnError
  >({
    ...options,
    url: '/users/me/calendarList/{calendarId}',
  });
};

/**
 * Updates an existing calendar on the user's calendar list.
 */
export const calendarCalendarListUpdate = <ThrowOnError extends boolean = false>(
  options: Options<CalendarCalendarListUpdateData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<
    CalendarCalendarListUpdateResponse,
    CalendarCalendarListUpdateError,
    ThrowOnError
  >({
    ...options,
    url: '/users/me/calendarList/{calendarId}',
  });
};

/**
 * Returns all user settings for the authenticated user.
 */
export const calendarSettingsList = <ThrowOnError extends boolean = false>(
  options?: Options<CalendarSettingsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CalendarSettingsListResponse, CalendarSettingsListError, ThrowOnError>({
    ...options,
    url: '/users/me/settings',
  });
};

/**
 * Watch for changes to Settings resources.
 */
export const calendarSettingsWatch = <ThrowOnError extends boolean = false>(
  options?: Options<CalendarSettingsWatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<CalendarSettingsWatchResponse, CalendarSettingsWatchError, ThrowOnError>({
    ...options,
    url: '/users/me/settings/watch',
  });
};

/**
 * Returns a single user setting.
 */
export const calendarSettingsGet = <ThrowOnError extends boolean = false>(
  options: Options<CalendarSettingsGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<CalendarSettingsGetResponse, CalendarSettingsGetError, ThrowOnError>({
    ...options,
    url: '/users/me/settings/{setting}',
  });
};
