// Generated by ts-to-zod
import { z } from 'zod';

export const timeZoneSchema = z.object({
  id: z.string().optional(),
  version: z.string().optional(),
});

export const stateSchema = z.union([
  z.literal('STATE_UNSPECIFIED'),
  z.literal('READY'),
  z.literal('NEEDS_ATTENTION'),
  z.literal('CLOSED'),
]);

export const adBlockingRecoveryTagSchema = z.object({
  errorProtectionCode: z.string().optional(),
  tag: z.string().optional(),
});

export const adClientSchema = z.object({
  name: z.string().optional(),
  productCode: z.string().optional(),
  reportingDimensionId: z.string().optional(),
  state: z
    .union([
      z.literal('STATE_UNSPECIFIED'),
      z.literal('READY'),
      z.literal('GETTING_READY'),
      z.literal('REQUIRES_REVIEW'),
    ])
    .optional(),
});

export const state2Schema = z.union([
  z.literal('STATE_UNSPECIFIED'),
  z.literal('READY'),
  z.literal('GETTING_READY'),
  z.literal('REQUIRES_REVIEW'),
]);

export const adClientAdCodeSchema = z.object({
  adCode: z.string().optional(),
  ampBody: z.string().optional(),
  ampHead: z.string().optional(),
});

export const contentAdsSettingsSchema = z.object({
  size: z.string().optional(),
  type: z
    .union([
      z.literal('TYPE_UNSPECIFIED'),
      z.literal('DISPLAY'),
      z.literal('FEED'),
      z.literal('ARTICLE'),
      z.literal('MATCHED_CONTENT'),
      z.literal('LINK'),
    ])
    .optional(),
});

export const state3Schema = z.union([z.literal('STATE_UNSPECIFIED'), z.literal('ACTIVE'), z.literal('ARCHIVED')]);

export const adUnitAdCodeSchema = z.object({
  adCode: z.string().optional(),
});

export const alertSchema = z.object({
  message: z.string().optional(),
  name: z.string().optional(),
  severity: z
    .union([z.literal('SEVERITY_UNSPECIFIED'), z.literal('INFO'), z.literal('WARNING'), z.literal('SEVERE')])
    .optional(),
  type: z.string().optional(),
});

export const severitySchema = z.union([
  z.literal('SEVERITY_UNSPECIFIED'),
  z.literal('INFO'),
  z.literal('WARNING'),
  z.literal('SEVERE'),
]);

export const cellSchema = z.object({
  value: z.string().optional(),
});

export const typeSchema = z.union([
  z.literal('TYPE_UNSPECIFIED'),
  z.literal('DISPLAY'),
  z.literal('FEED'),
  z.literal('ARTICLE'),
  z.literal('MATCHED_CONTENT'),
  z.literal('LINK'),
]);

export const customChannelSchema = z.object({
  active: z.boolean().optional(),
  displayName: z.string().optional(),
  name: z.string().optional(),
  reportingDimensionId: z.string().optional(),
});

export const googleDateSchema = z.object({
  day: z.number().optional(),
  month: z.number().optional(),
  year: z.number().optional(),
});

export const emptySchema = z.record(z.unknown());

export const headerSchema = z.object({
  currencyCode: z.string().optional(),
  name: z.string().optional(),
  type: z
    .union([
      z.literal('HEADER_TYPE_UNSPECIFIED'),
      z.literal('DIMENSION'),
      z.literal('METRIC_TALLY'),
      z.literal('METRIC_RATIO'),
      z.literal('METRIC_CURRENCY'),
      z.literal('METRIC_MILLISECONDS'),
      z.literal('METRIC_DECIMAL'),
    ])
    .optional(),
});

export const type2Schema = z.union([
  z.literal('HEADER_TYPE_UNSPECIFIED'),
  z.literal('DIMENSION'),
  z.literal('METRIC_TALLY'),
  z.literal('METRIC_RATIO'),
  z.literal('METRIC_CURRENCY'),
  z.literal('METRIC_MILLISECONDS'),
  z.literal('METRIC_DECIMAL'),
]);

export const httpBodySchema = z.object({
  contentType: z.string().optional(),
  data: z.string().optional(),
  extensions: z.array(z.record(z.unknown())).optional(),
});

export const accountSchema = z.object({
  createTime: z.string().optional(),
  displayName: z.string().optional(),
  name: z.string().optional(),
  pendingTasks: z.array(z.string()).optional(),
  premium: z.boolean().optional(),
  state: z
    .union([z.literal('STATE_UNSPECIFIED'), z.literal('READY'), z.literal('NEEDS_ATTENTION'), z.literal('CLOSED')])
    .optional(),
  timeZone: timeZoneSchema.optional(),
});

export const listAdClientsResponseSchema = z.object({
  adClients: z.array(adClientSchema).optional(),
  nextPageToken: z.string().optional(),
});

export const adUnitSchema = z.object({
  contentAdsSettings: contentAdsSettingsSchema.optional(),
  displayName: z.string().optional(),
  name: z.string().optional(),
  reportingDimensionId: z.string().optional(),
  state: z.union([z.literal('STATE_UNSPECIFIED'), z.literal('ACTIVE'), z.literal('ARCHIVED')]).optional(),
});

export const listAlertsResponseSchema = z.object({
  alerts: z.array(alertSchema).optional(),
});

export const listChildAccountsResponseSchema = z.object({
  accounts: z.array(accountSchema).optional(),
  nextPageToken: z.string().optional(),
});

export const listCustomChannelsResponseSchema = z.object({
  customChannels: z.array(customChannelSchema).optional(),
  nextPageToken: z.string().optional(),
});

export const listLinkedAdUnitsResponseSchema = z.object({
  adUnits: z.array(adUnitSchema).optional(),
  nextPageToken: z.string().optional(),
});

export const listLinkedCustomChannelsResponseSchema = z.object({
  customChannels: z.array(customChannelSchema).optional(),
  nextPageToken: z.string().optional(),
});

export const paymentSchema = z.object({
  amount: z.string().optional(),
  date: googleDateSchema.optional(),
  name: z.string().optional(),
});

export const savedReportSchema = z.object({
  name: z.string().optional(),
  title: z.string().optional(),
});

export const siteSchema = z.object({
  autoAdsEnabled: z.boolean().optional(),
  domain: z.string().optional(),
  name: z.string().optional(),
  reportingDimensionId: z.string().optional(),
  state: z
    .union([
      z.literal('STATE_UNSPECIFIED'),
      z.literal('REQUIRES_REVIEW'),
      z.literal('GETTING_READY'),
      z.literal('READY'),
      z.literal('NEEDS_ATTENTION'),
    ])
    .optional(),
});

export const urlChannelSchema = z.object({
  name: z.string().optional(),
  reportingDimensionId: z.string().optional(),
  uriPattern: z.string().optional(),
});

export const rowSchema = z.object({
  cells: z.array(cellSchema).optional(),
});

export const state4Schema = z.union([
  z.literal('STATE_UNSPECIFIED'),
  z.literal('REQUIRES_REVIEW'),
  z.literal('GETTING_READY'),
  z.literal('READY'),
  z.literal('NEEDS_ATTENTION'),
]);

export const parameterXgafvSchema = z.union([z.literal('1'), z.literal('2')]);

export const parameteraccessTokenSchema = z.string();

export const parameteraltSchema = z.union([z.literal('json'), z.literal('media'), z.literal('proto')]);

export const parametercallbackSchema = z.string();

export const parameterfieldsSchema = z.string();

export const parameterkeySchema = z.string();

export const parameteroauthTokenSchema = z.string();

export const parameterprettyPrintSchema = z.boolean();

export const parameterquotaUserSchema = z.string();

export const parameteruploadTypeSchema = z.string();

export const parameteruploadProtocolSchema = z.string();

export const adsenseAccountsListDataSchema = z.object({
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const listAccountsResponseSchema = z.object({
  accounts: z.array(accountSchema).optional(),
  nextPageToken: z.string().optional(),
});

export const adsenseAccountsListErrorSchema = z.unknown();

export const adsenseAccountsReportsGenerateDataSchema = z.object({
  path: z.object({
    account: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      currencyCode: z.string().optional(),
      dateRange: z
        .union([
          z.literal('REPORTING_DATE_RANGE_UNSPECIFIED'),
          z.literal('CUSTOM'),
          z.literal('TODAY'),
          z.literal('YESTERDAY'),
          z.literal('MONTH_TO_DATE'),
          z.literal('YEAR_TO_DATE'),
          z.literal('LAST_7_DAYS'),
          z.literal('LAST_30_DAYS'),
        ])
        .optional(),
      dimensions: z
        .array(
          z.union([
            z.literal('DIMENSION_UNSPECIFIED'),
            z.literal('DATE'),
            z.literal('WEEK'),
            z.literal('MONTH'),
            z.literal('ACCOUNT_NAME'),
            z.literal('AD_CLIENT_ID'),
            z.literal('HOSTED_AD_CLIENT_ID'),
            z.literal('PRODUCT_NAME'),
            z.literal('PRODUCT_CODE'),
            z.literal('AD_UNIT_NAME'),
            z.literal('AD_UNIT_ID'),
            z.literal('AD_UNIT_SIZE_NAME'),
            z.literal('AD_UNIT_SIZE_CODE'),
            z.literal('CUSTOM_CHANNEL_NAME'),
            z.literal('CUSTOM_CHANNEL_ID'),
            z.literal('OWNED_SITE_DOMAIN_NAME'),
            z.literal('OWNED_SITE_ID'),
            z.literal('PAGE_URL'),
            z.literal('URL_CHANNEL_NAME'),
            z.literal('URL_CHANNEL_ID'),
            z.literal('BUYER_NETWORK_NAME'),
            z.literal('BUYER_NETWORK_ID'),
            z.literal('BID_TYPE_NAME'),
            z.literal('BID_TYPE_CODE'),
            z.literal('CREATIVE_SIZE_NAME'),
            z.literal('CREATIVE_SIZE_CODE'),
            z.literal('DOMAIN_NAME'),
            z.literal('DOMAIN_CODE'),
            z.literal('COUNTRY_NAME'),
            z.literal('COUNTRY_CODE'),
            z.literal('PLATFORM_TYPE_NAME'),
            z.literal('PLATFORM_TYPE_CODE'),
            z.literal('TARGETING_TYPE_NAME'),
            z.literal('TARGETING_TYPE_CODE'),
            z.literal('CONTENT_PLATFORM_NAME'),
            z.literal('CONTENT_PLATFORM_CODE'),
            z.literal('AD_PLACEMENT_NAME'),
            z.literal('AD_PLACEMENT_CODE'),
            z.literal('REQUESTED_AD_TYPE_NAME'),
            z.literal('REQUESTED_AD_TYPE_CODE'),
            z.literal('SERVED_AD_TYPE_NAME'),
            z.literal('SERVED_AD_TYPE_CODE'),
            z.literal('AD_FORMAT_NAME'),
            z.literal('AD_FORMAT_CODE'),
            z.literal('CUSTOM_SEARCH_STYLE_NAME'),
            z.literal('CUSTOM_SEARCH_STYLE_ID'),
            z.literal('DOMAIN_REGISTRANT'),
            z.literal('WEBSEARCH_QUERY_STRING'),
          ]),
        )
        .optional(),
      'endDate.day': z.number().optional(),
      'endDate.month': z.number().optional(),
      'endDate.year': z.number().optional(),
      fields: z.string().optional(),
      filters: z.array(z.string()).optional(),
      key: z.string().optional(),
      languageCode: z.string().optional(),
      limit: z.number().optional(),
      metrics: z
        .array(
          z.union([
            z.literal('METRIC_UNSPECIFIED'),
            z.literal('PAGE_VIEWS'),
            z.literal('AD_REQUESTS'),
            z.literal('MATCHED_AD_REQUESTS'),
            z.literal('TOTAL_IMPRESSIONS'),
            z.literal('IMPRESSIONS'),
            z.literal('INDIVIDUAL_AD_IMPRESSIONS'),
            z.literal('CLICKS'),
            z.literal('PAGE_VIEWS_SPAM_RATIO'),
            z.literal('AD_REQUESTS_SPAM_RATIO'),
            z.literal('MATCHED_AD_REQUESTS_SPAM_RATIO'),
            z.literal('IMPRESSIONS_SPAM_RATIO'),
            z.literal('INDIVIDUAL_AD_IMPRESSIONS_SPAM_RATIO'),
            z.literal('CLICKS_SPAM_RATIO'),
            z.literal('AD_REQUESTS_COVERAGE'),
            z.literal('PAGE_VIEWS_CTR'),
            z.literal('AD_REQUESTS_CTR'),
            z.literal('MATCHED_AD_REQUESTS_CTR'),
            z.literal('IMPRESSIONS_CTR'),
            z.literal('INDIVIDUAL_AD_IMPRESSIONS_CTR'),
            z.literal('ACTIVE_VIEW_MEASURABILITY'),
            z.literal('ACTIVE_VIEW_VIEWABILITY'),
            z.literal('ACTIVE_VIEW_TIME'),
            z.literal('ESTIMATED_EARNINGS'),
            z.literal('PAGE_VIEWS_RPM'),
            z.literal('AD_REQUESTS_RPM'),
            z.literal('MATCHED_AD_REQUESTS_RPM'),
            z.literal('IMPRESSIONS_RPM'),
            z.literal('INDIVIDUAL_AD_IMPRESSIONS_RPM'),
            z.literal('COST_PER_CLICK'),
            z.literal('ADS_PER_IMPRESSION'),
            z.literal('TOTAL_EARNINGS'),
            z.literal('WEBSEARCH_RESULT_PAGES'),
            z.literal('FUNNEL_REQUESTS'),
            z.literal('FUNNEL_IMPRESSIONS'),
            z.literal('FUNNEL_CLICKS'),
            z.literal('FUNNEL_RPM'),
          ]),
        )
        .optional(),
      oauth_token: z.string().optional(),
      orderBy: z.array(z.string()).optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      reportingTimeZone: z
        .union([
          z.literal('REPORTING_TIME_ZONE_UNSPECIFIED'),
          z.literal('ACCOUNT_TIME_ZONE'),
          z.literal('GOOGLE_TIME_ZONE'),
        ])
        .optional(),
      'startDate.day': z.number().optional(),
      'startDate.month': z.number().optional(),
      'startDate.year': z.number().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const reportResultSchema = z.object({
  averages: rowSchema.optional(),
  endDate: googleDateSchema.optional(),
  headers: z.array(headerSchema).optional(),
  rows: z.array(rowSchema).optional(),
  startDate: googleDateSchema.optional(),
  totalMatchedRows: z.string().optional(),
  totals: rowSchema.optional(),
  warnings: z.array(z.string()).optional(),
});

export const adsenseAccountsReportsGenerateErrorSchema = z.unknown();

export const adsenseAccountsReportsGenerateCsvDataSchema = z.object({
  path: z.object({
    account: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      currencyCode: z.string().optional(),
      dateRange: z
        .union([
          z.literal('REPORTING_DATE_RANGE_UNSPECIFIED'),
          z.literal('CUSTOM'),
          z.literal('TODAY'),
          z.literal('YESTERDAY'),
          z.literal('MONTH_TO_DATE'),
          z.literal('YEAR_TO_DATE'),
          z.literal('LAST_7_DAYS'),
          z.literal('LAST_30_DAYS'),
        ])
        .optional(),
      dimensions: z
        .array(
          z.union([
            z.literal('DIMENSION_UNSPECIFIED'),
            z.literal('DATE'),
            z.literal('WEEK'),
            z.literal('MONTH'),
            z.literal('ACCOUNT_NAME'),
            z.literal('AD_CLIENT_ID'),
            z.literal('HOSTED_AD_CLIENT_ID'),
            z.literal('PRODUCT_NAME'),
            z.literal('PRODUCT_CODE'),
            z.literal('AD_UNIT_NAME'),
            z.literal('AD_UNIT_ID'),
            z.literal('AD_UNIT_SIZE_NAME'),
            z.literal('AD_UNIT_SIZE_CODE'),
            z.literal('CUSTOM_CHANNEL_NAME'),
            z.literal('CUSTOM_CHANNEL_ID'),
            z.literal('OWNED_SITE_DOMAIN_NAME'),
            z.literal('OWNED_SITE_ID'),
            z.literal('PAGE_URL'),
            z.literal('URL_CHANNEL_NAME'),
            z.literal('URL_CHANNEL_ID'),
            z.literal('BUYER_NETWORK_NAME'),
            z.literal('BUYER_NETWORK_ID'),
            z.literal('BID_TYPE_NAME'),
            z.literal('BID_TYPE_CODE'),
            z.literal('CREATIVE_SIZE_NAME'),
            z.literal('CREATIVE_SIZE_CODE'),
            z.literal('DOMAIN_NAME'),
            z.literal('DOMAIN_CODE'),
            z.literal('COUNTRY_NAME'),
            z.literal('COUNTRY_CODE'),
            z.literal('PLATFORM_TYPE_NAME'),
            z.literal('PLATFORM_TYPE_CODE'),
            z.literal('TARGETING_TYPE_NAME'),
            z.literal('TARGETING_TYPE_CODE'),
            z.literal('CONTENT_PLATFORM_NAME'),
            z.literal('CONTENT_PLATFORM_CODE'),
            z.literal('AD_PLACEMENT_NAME'),
            z.literal('AD_PLACEMENT_CODE'),
            z.literal('REQUESTED_AD_TYPE_NAME'),
            z.literal('REQUESTED_AD_TYPE_CODE'),
            z.literal('SERVED_AD_TYPE_NAME'),
            z.literal('SERVED_AD_TYPE_CODE'),
            z.literal('AD_FORMAT_NAME'),
            z.literal('AD_FORMAT_CODE'),
            z.literal('CUSTOM_SEARCH_STYLE_NAME'),
            z.literal('CUSTOM_SEARCH_STYLE_ID'),
            z.literal('DOMAIN_REGISTRANT'),
            z.literal('WEBSEARCH_QUERY_STRING'),
          ]),
        )
        .optional(),
      'endDate.day': z.number().optional(),
      'endDate.month': z.number().optional(),
      'endDate.year': z.number().optional(),
      fields: z.string().optional(),
      filters: z.array(z.string()).optional(),
      key: z.string().optional(),
      languageCode: z.string().optional(),
      limit: z.number().optional(),
      metrics: z
        .array(
          z.union([
            z.literal('METRIC_UNSPECIFIED'),
            z.literal('PAGE_VIEWS'),
            z.literal('AD_REQUESTS'),
            z.literal('MATCHED_AD_REQUESTS'),
            z.literal('TOTAL_IMPRESSIONS'),
            z.literal('IMPRESSIONS'),
            z.literal('INDIVIDUAL_AD_IMPRESSIONS'),
            z.literal('CLICKS'),
            z.literal('PAGE_VIEWS_SPAM_RATIO'),
            z.literal('AD_REQUESTS_SPAM_RATIO'),
            z.literal('MATCHED_AD_REQUESTS_SPAM_RATIO'),
            z.literal('IMPRESSIONS_SPAM_RATIO'),
            z.literal('INDIVIDUAL_AD_IMPRESSIONS_SPAM_RATIO'),
            z.literal('CLICKS_SPAM_RATIO'),
            z.literal('AD_REQUESTS_COVERAGE'),
            z.literal('PAGE_VIEWS_CTR'),
            z.literal('AD_REQUESTS_CTR'),
            z.literal('MATCHED_AD_REQUESTS_CTR'),
            z.literal('IMPRESSIONS_CTR'),
            z.literal('INDIVIDUAL_AD_IMPRESSIONS_CTR'),
            z.literal('ACTIVE_VIEW_MEASURABILITY'),
            z.literal('ACTIVE_VIEW_VIEWABILITY'),
            z.literal('ACTIVE_VIEW_TIME'),
            z.literal('ESTIMATED_EARNINGS'),
            z.literal('PAGE_VIEWS_RPM'),
            z.literal('AD_REQUESTS_RPM'),
            z.literal('MATCHED_AD_REQUESTS_RPM'),
            z.literal('IMPRESSIONS_RPM'),
            z.literal('INDIVIDUAL_AD_IMPRESSIONS_RPM'),
            z.literal('COST_PER_CLICK'),
            z.literal('ADS_PER_IMPRESSION'),
            z.literal('TOTAL_EARNINGS'),
            z.literal('WEBSEARCH_RESULT_PAGES'),
            z.literal('FUNNEL_REQUESTS'),
            z.literal('FUNNEL_IMPRESSIONS'),
            z.literal('FUNNEL_CLICKS'),
            z.literal('FUNNEL_RPM'),
          ]),
        )
        .optional(),
      oauth_token: z.string().optional(),
      orderBy: z.array(z.string()).optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      reportingTimeZone: z
        .union([
          z.literal('REPORTING_TIME_ZONE_UNSPECIFIED'),
          z.literal('ACCOUNT_TIME_ZONE'),
          z.literal('GOOGLE_TIME_ZONE'),
        ])
        .optional(),
      'startDate.day': z.number().optional(),
      'startDate.month': z.number().optional(),
      'startDate.year': z.number().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const adsenseAccountsReportsGenerateCsvResponseSchema = httpBodySchema;

export const adsenseAccountsReportsGenerateCsvErrorSchema = z.unknown();

export const adsenseAccountsAdclientsCustomchannelsDeleteDataSchema = z.object({
  path: z.object({
    name: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const adsenseAccountsAdclientsCustomchannelsDeleteResponseSchema = emptySchema;

export const adsenseAccountsAdclientsCustomchannelsDeleteErrorSchema = z.unknown();

export const adsenseAccountsSitesGetDataSchema = z.object({
  path: z.object({
    name: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const adsenseAccountsSitesGetResponseSchema = siteSchema;

export const adsenseAccountsSitesGetErrorSchema = z.unknown();

export const adsenseAccountsAdclientsCustomchannelsPatchDataSchema = z.object({
  body: customChannelSchema.optional(),
  path: z.object({
    name: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      updateMask: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const adsenseAccountsAdclientsCustomchannelsPatchResponseSchema = customChannelSchema;

export const adsenseAccountsAdclientsCustomchannelsPatchErrorSchema = z.unknown();

export const adsenseAccountsGetAdBlockingRecoveryTagDataSchema = z.object({
  path: z.object({
    name: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const adsenseAccountsGetAdBlockingRecoveryTagResponseSchema = adBlockingRecoveryTagSchema;

export const adsenseAccountsGetAdBlockingRecoveryTagErrorSchema = z.unknown();

export const adsenseAccountsAdclientsAdunitsGetAdcodeDataSchema = z.object({
  path: z.object({
    name: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const adsenseAccountsAdclientsAdunitsGetAdcodeResponseSchema = adUnitAdCodeSchema;

export const adsenseAccountsAdclientsAdunitsGetAdcodeErrorSchema = z.unknown();

export const adsenseAccountsReportsGetSavedDataSchema = z.object({
  path: z.object({
    name: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const adsenseAccountsReportsGetSavedResponseSchema = savedReportSchema;

export const adsenseAccountsReportsGetSavedErrorSchema = z.unknown();

export const adsenseAccountsReportsSavedGenerateDataSchema = z.object({
  path: z.object({
    name: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      currencyCode: z.string().optional(),
      dateRange: z
        .union([
          z.literal('REPORTING_DATE_RANGE_UNSPECIFIED'),
          z.literal('CUSTOM'),
          z.literal('TODAY'),
          z.literal('YESTERDAY'),
          z.literal('MONTH_TO_DATE'),
          z.literal('YEAR_TO_DATE'),
          z.literal('LAST_7_DAYS'),
          z.literal('LAST_30_DAYS'),
        ])
        .optional(),
      'endDate.day': z.number().optional(),
      'endDate.month': z.number().optional(),
      'endDate.year': z.number().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      languageCode: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      reportingTimeZone: z
        .union([
          z.literal('REPORTING_TIME_ZONE_UNSPECIFIED'),
          z.literal('ACCOUNT_TIME_ZONE'),
          z.literal('GOOGLE_TIME_ZONE'),
        ])
        .optional(),
      'startDate.day': z.number().optional(),
      'startDate.month': z.number().optional(),
      'startDate.year': z.number().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const adsenseAccountsReportsSavedGenerateResponseSchema = reportResultSchema;

export const adsenseAccountsReportsSavedGenerateErrorSchema = z.unknown();

export const adsenseAccountsReportsSavedGenerateCsvDataSchema = z.object({
  path: z.object({
    name: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      currencyCode: z.string().optional(),
      dateRange: z
        .union([
          z.literal('REPORTING_DATE_RANGE_UNSPECIFIED'),
          z.literal('CUSTOM'),
          z.literal('TODAY'),
          z.literal('YESTERDAY'),
          z.literal('MONTH_TO_DATE'),
          z.literal('YEAR_TO_DATE'),
          z.literal('LAST_7_DAYS'),
          z.literal('LAST_30_DAYS'),
        ])
        .optional(),
      'endDate.day': z.number().optional(),
      'endDate.month': z.number().optional(),
      'endDate.year': z.number().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      languageCode: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      reportingTimeZone: z
        .union([
          z.literal('REPORTING_TIME_ZONE_UNSPECIFIED'),
          z.literal('ACCOUNT_TIME_ZONE'),
          z.literal('GOOGLE_TIME_ZONE'),
        ])
        .optional(),
      'startDate.day': z.number().optional(),
      'startDate.month': z.number().optional(),
      'startDate.year': z.number().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const adsenseAccountsReportsSavedGenerateCsvResponseSchema = httpBodySchema;

export const adsenseAccountsReportsSavedGenerateCsvErrorSchema = z.unknown();

export const adsenseAccountsAdclientsListDataSchema = z.object({
  path: z.object({
    parent: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const adsenseAccountsAdclientsListResponseSchema = listAdClientsResponseSchema;

export const adsenseAccountsAdclientsListErrorSchema = z.unknown();

export const adsenseAccountsAdclientsAdunitsListDataSchema = z.object({
  path: z.object({
    parent: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const listAdUnitsResponseSchema = z.object({
  adUnits: z.array(adUnitSchema).optional(),
  nextPageToken: z.string().optional(),
});

export const adsenseAccountsAdclientsAdunitsListErrorSchema = z.unknown();

export const adsenseAccountsAdclientsAdunitsCreateDataSchema = z.object({
  body: adUnitSchema.optional(),
  path: z.object({
    parent: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const adsenseAccountsAdclientsAdunitsCreateResponseSchema = adUnitSchema;

export const adsenseAccountsAdclientsAdunitsCreateErrorSchema = z.unknown();

export const adsenseAccountsAlertsListDataSchema = z.object({
  path: z.object({
    parent: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      languageCode: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const adsenseAccountsAlertsListResponseSchema = listAlertsResponseSchema;

export const adsenseAccountsAlertsListErrorSchema = z.unknown();

export const adsenseAccountsAdclientsCustomchannelsListDataSchema = z.object({
  path: z.object({
    parent: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const adsenseAccountsAdclientsCustomchannelsListResponseSchema = listCustomChannelsResponseSchema;

export const adsenseAccountsAdclientsCustomchannelsListErrorSchema = z.unknown();

export const adsenseAccountsAdclientsCustomchannelsCreateDataSchema = z.object({
  body: customChannelSchema.optional(),
  path: z.object({
    parent: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const adsenseAccountsAdclientsCustomchannelsCreateResponseSchema = customChannelSchema;

export const adsenseAccountsAdclientsCustomchannelsCreateErrorSchema = z.unknown();

export const adsenseAccountsPaymentsListDataSchema = z.object({
  path: z.object({
    parent: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const listPaymentsResponseSchema = z.object({
  payments: z.array(paymentSchema).optional(),
});

export const adsenseAccountsPaymentsListErrorSchema = z.unknown();

export const adsenseAccountsReportsSavedListDataSchema = z.object({
  path: z.object({
    parent: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const listSavedReportsResponseSchema = z.object({
  nextPageToken: z.string().optional(),
  savedReports: z.array(savedReportSchema).optional(),
});

export const adsenseAccountsReportsSavedListErrorSchema = z.unknown();

export const adsenseAccountsSitesListDataSchema = z.object({
  path: z.object({
    parent: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const listSitesResponseSchema = z.object({
  nextPageToken: z.string().optional(),
  sites: z.array(siteSchema).optional(),
});

export const adsenseAccountsSitesListErrorSchema = z.unknown();

export const adsenseAccountsAdclientsUrlchannelsListDataSchema = z.object({
  path: z.object({
    parent: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const listUrlChannelsResponseSchema = z.object({
  nextPageToken: z.string().optional(),
  urlChannels: z.array(urlChannelSchema).optional(),
});

export const adsenseAccountsAdclientsUrlchannelsListErrorSchema = z.unknown();

export const adsenseAccountsListChildAccountsDataSchema = z.object({
  path: z.object({
    parent: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const adsenseAccountsListChildAccountsResponseSchema = listChildAccountsResponseSchema;

export const adsenseAccountsListChildAccountsErrorSchema = z.unknown();

export const adsenseAccountsAdclientsCustomchannelsListLinkedAdUnitsDataSchema = z.object({
  path: z.object({
    parent: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const adsenseAccountsAdclientsCustomchannelsListLinkedAdUnitsResponseSchema = listLinkedAdUnitsResponseSchema;

export const adsenseAccountsAdclientsCustomchannelsListLinkedAdUnitsErrorSchema = z.unknown();

export const adsenseAccountsAdclientsAdunitsListLinkedCustomChannelsDataSchema = z.object({
  path: z.object({
    parent: z.string(),
  }),
  query: z
    .object({
      '$.xgafv': z.union([z.literal('1'), z.literal('2')]).optional(),
      access_token: z.string().optional(),
      alt: z.union([z.literal('json'), z.literal('media'), z.literal('proto')]).optional(),
      callback: z.string().optional(),
      fields: z.string().optional(),
      key: z.string().optional(),
      oauth_token: z.string().optional(),
      pageSize: z.number().optional(),
      pageToken: z.string().optional(),
      prettyPrint: z.boolean().optional(),
      quotaUser: z.string().optional(),
      upload_protocol: z.string().optional(),
      uploadType: z.string().optional(),
    })
    .optional(),
});

export const adsenseAccountsAdclientsAdunitsListLinkedCustomChannelsResponseSchema =
  listLinkedCustomChannelsResponseSchema;

export const adsenseAccountsAdclientsAdunitsListLinkedCustomChannelsErrorSchema = z.unknown();

export const adsenseAccountsListResponseSchema = listAccountsResponseSchema;

export const adsenseAccountsReportsGenerateResponseSchema = reportResultSchema;

export const adsenseAccountsAdclientsAdunitsListResponseSchema = listAdUnitsResponseSchema;

export const adsenseAccountsPaymentsListResponseSchema = listPaymentsResponseSchema;

export const adsenseAccountsReportsSavedListResponseSchema = listSavedReportsResponseSchema;

export const adsenseAccountsSitesListResponseSchema = listSitesResponseSchema;

export const adsenseAccountsAdclientsUrlchannelsListResponseSchema = listUrlChannelsResponseSchema;
