// This file is auto-generated by @hey-api/openapi-ts

/**
 * Representation of an account.
 */
export type Account = {
  /**
   * Output only. Creation time of the account.
   */
  readonly createTime?: string;
  /**
   * Output only. Display name of this account.
   */
  readonly displayName?: string;
  /**
   * Output only. Resource name of the account. Format: accounts/pub-[0-9]+
   */
  readonly name?: string;
  /**
   * Output only. Outstanding tasks that need to be completed as part of the sign-up process for a new account. e.g. "billing-profile-creation", "phone-pin-verification".
   */
  readonly pendingTasks?: Array<string>;
  /**
   * Output only. Whether this account is premium.
   */
  readonly premium?: boolean;
  /**
   * Output only. State of the account.
   */
  readonly state?: 'STATE_UNSPECIFIED' | 'READY' | 'NEEDS_ATTENTION' | 'CLOSED';
  /**
   * The account time zone, as used by reporting. For more information, see [changing the time zone of your reports](https://support.google.com/adsense/answer/9830725).
   */
  timeZone?: TimeZone;
};

/**
 * Output only. State of the account.
 */
export type state = 'STATE_UNSPECIFIED' | 'READY' | 'NEEDS_ATTENTION' | 'CLOSED';

/**
 * Representation of an ad blocking recovery tag. See https://support.google.com/adsense/answer/11575177.
 */
export type AdBlockingRecoveryTag = {
  /**
   * Error protection code that can be used in conjunction with the tag. It'll display a message to users if an [ad blocking extension blocks their access to your site](https://support.google.com/adsense/answer/11575480).
   */
  errorProtectionCode?: string;
  /**
   * The ad blocking recovery tag. Note that the message generated by the tag can be blocked by an ad blocking extension. If this is not your desired outcome, then you'll need to use it in conjunction with the error protection code.
   */
  tag?: string;
};

/**
 * Representation of an ad client. An ad client represents a user's subscription with a specific AdSense product.
 */
export type AdClient = {
  /**
   * Output only. Resource name of the ad client. Format: accounts/{account}/adclients/{adclient}
   */
  readonly name?: string;
  /**
   * Output only. Reporting product code of the ad client. For example, "AFC" for AdSense for Content. Corresponds to the `PRODUCT_CODE` dimension, and present only if the ad client supports reporting.
   */
  readonly productCode?: string;
  /**
   * Output only. Unique ID of the ad client as used in the `AD_CLIENT_ID` reporting dimension. Present only if the ad client supports reporting.
   */
  readonly reportingDimensionId?: string;
  /**
   * Output only. State of the ad client.
   */
  readonly state?: 'STATE_UNSPECIFIED' | 'READY' | 'GETTING_READY' | 'REQUIRES_REVIEW';
};

/**
 * Output only. State of the ad client.
 */
export type state2 = 'STATE_UNSPECIFIED' | 'READY' | 'GETTING_READY' | 'REQUIRES_REVIEW';

/**
 * Representation of the AdSense code for a given ad client. For more information, see [About the AdSense code](https://support.google.com/adsense/answer/9274634).
 */
export type AdClientAdCode = {
  /**
   * Output only. The AdSense code snippet to add to the head of an HTML page.
   */
  readonly adCode?: string;
  /**
   * Output only. The AdSense code snippet to add to the body of an AMP page.
   */
  readonly ampBody?: string;
  /**
   * Output only. The AdSense code snippet to add to the head of an AMP page.
   */
  readonly ampHead?: string;
};

/**
 * Representation of an ad unit. An ad unit represents a saved ad unit with a specific set of ad settings that have been customized within an account.
 */
export type AdUnit = {
  /**
   * Required. Settings specific to content ads (AFC).
   */
  contentAdsSettings?: ContentAdsSettings;
  /**
   * Required. Display name of the ad unit, as provided when the ad unit was created.
   */
  displayName?: string;
  /**
   * Output only. Resource name of the ad unit. Format: accounts/{account}/adclients/{adclient}/adunits/{adunit}
   */
  readonly name?: string;
  /**
   * Output only. Unique ID of the ad unit as used in the `AD_UNIT_ID` reporting dimension.
   */
  readonly reportingDimensionId?: string;
  /**
   * Required. State of the ad unit.
   */
  state?: 'STATE_UNSPECIFIED' | 'ACTIVE' | 'ARCHIVED';
};

/**
 * Required. State of the ad unit.
 */
export type state3 = 'STATE_UNSPECIFIED' | 'ACTIVE' | 'ARCHIVED';

/**
 * Representation of the ad unit code for a given ad unit. For more information, see [About the AdSense code](https://support.google.com/adsense/answer/9274634) and [Where to place the ad code in your HTML](https://support.google.com/adsense/answer/9190028).
 */
export type AdUnitAdCode = {
  /**
   * Output only. The code snippet to add to the body of an HTML page.
   */
  readonly adCode?: string;
};

/**
 * Representation of an alert.
 */
export type Alert = {
  /**
   * Output only. The localized alert message. This may contain HTML markup, such as phrase elements or links.
   */
  readonly message?: string;
  /**
   * Output only. Resource name of the alert. Format: accounts/{account}/alerts/{alert}
   */
  readonly name?: string;
  /**
   * Output only. Severity of this alert.
   */
  readonly severity?: 'SEVERITY_UNSPECIFIED' | 'INFO' | 'WARNING' | 'SEVERE';
  /**
   * Output only. Type of alert. This identifies the broad type of this alert, and provides a stable machine-readable identifier that will not be translated. For example, "payment-hold".
   */
  readonly type?: string;
};

/**
 * Output only. Severity of this alert.
 */
export type severity = 'SEVERITY_UNSPECIFIED' | 'INFO' | 'WARNING' | 'SEVERE';

/**
 * Cell representation.
 */
export type Cell = {
  /**
   * Value in the cell. The dimension cells contain strings, and the metric cells contain numbers.
   */
  value?: string;
};

/**
 * Settings specific to content ads (AFC).
 */
export type ContentAdsSettings = {
  /**
   * Required. Size of the ad unit. e.g. "728x90", "1x3" (for responsive ad units).
   */
  size?: string;
  /**
   * Required. Type of the ad unit.
   */
  type?: 'TYPE_UNSPECIFIED' | 'DISPLAY' | 'FEED' | 'ARTICLE' | 'MATCHED_CONTENT' | 'LINK';
};

/**
 * Required. Type of the ad unit.
 */
export type type = 'TYPE_UNSPECIFIED' | 'DISPLAY' | 'FEED' | 'ARTICLE' | 'MATCHED_CONTENT' | 'LINK';

/**
 * Representation of a custom channel.
 */
export type CustomChannel = {
  /**
   * Whether the custom channel is active and collecting data. See https://support.google.com/adsense/answer/10077192.
   */
  active?: boolean;
  /**
   * Required. Display name of the custom channel.
   */
  displayName?: string;
  /**
   * Output only. Resource name of the custom channel. Format: accounts/{account}/adclients/{adclient}/customchannels/{customchannel}
   */
  readonly name?: string;
  /**
   * Output only. Unique ID of the custom channel as used in the `CUSTOM_CHANNEL_ID` reporting dimension.
   */
  readonly reportingDimensionId?: string;
};

/**
 * Represents a whole or partial calendar date, such as a birthday. The time of day and time zone are either specified elsewhere or are insignificant. The date is relative to the Gregorian Calendar. This can represent one of the following: * A full date, with non-zero year, month, and day values. * A month and day, with a zero year (for example, an anniversary). * A year on its own, with a zero month and a zero day. * A year and month, with a zero day (for example, a credit card expiration date). Related types: * google.type.TimeOfDay * google.type.DateTime * google.protobuf.Timestamp
 */
export type GoogleDate = {
  /**
   * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
   */
  day?: number;
  /**
   * Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
   */
  month?: number;
  /**
   * Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
   */
  year?: number;
};

/**
 * A generic empty message that you can re-use to avoid defining duplicated empty messages in your APIs. A typical example is to use it as the request or the response type of an API method. For instance: service Foo { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
 */
export type Empty = {
  [key: string]: unknown;
};

/**
 * The header information of the columns requested in the report.
 */
export type Header = {
  /**
   * The [ISO-4217 currency code](https://en.wikipedia.org/wiki/ISO_4217) of this column. Only present if the header type is METRIC_CURRENCY.
   */
  currencyCode?: string;
  /**
   * Required. Name of the header.
   */
  name?: string;
  /**
   * Required. Type of the header.
   */
  type?:
    | 'HEADER_TYPE_UNSPECIFIED'
    | 'DIMENSION'
    | 'METRIC_TALLY'
    | 'METRIC_RATIO'
    | 'METRIC_CURRENCY'
    | 'METRIC_MILLISECONDS'
    | 'METRIC_DECIMAL';
};

/**
 * Required. Type of the header.
 */
export type type2 =
  | 'HEADER_TYPE_UNSPECIFIED'
  | 'DIMENSION'
  | 'METRIC_TALLY'
  | 'METRIC_RATIO'
  | 'METRIC_CURRENCY'
  | 'METRIC_MILLISECONDS'
  | 'METRIC_DECIMAL';

/**
 * Message that represents an arbitrary HTTP body. It should only be used for payload formats that can't be represented as JSON, such as raw binary or an HTML page. This message can be used both in streaming and non-streaming API methods in the request as well as the response. It can be used as a top-level request field, which is convenient if one wants to extract parameters from either the URL or HTTP template into the request fields and also want access to the raw HTTP body. Example: message GetResourceRequest { // A unique request id. string request_id = 1; // The raw HTTP body is bound to this field. google.api.HttpBody http_body = 2; } service ResourceService { rpc GetResource(GetResourceRequest) returns (google.api.HttpBody); rpc UpdateResource(google.api.HttpBody) returns (google.protobuf.Empty); } Example with streaming methods: service CaldavService { rpc GetCalendar(stream google.api.HttpBody) returns (stream google.api.HttpBody); rpc UpdateCalendar(stream google.api.HttpBody) returns (stream google.api.HttpBody); } Use of this type only changes how the request and response bodies are handled, all other features will continue to work unchanged.
 */
export type HttpBody = {
  /**
   * The HTTP Content-Type header value specifying the content type of the body.
   */
  contentType?: string;
  /**
   * The HTTP request/response body as raw binary.
   */
  data?: string;
  /**
   * Application specific response metadata. Must be set in the first response for streaming APIs.
   */
  extensions?: Array<{
    [key: string]: unknown;
  }>;
};

/**
 * Response definition for the account list rpc.
 */
export type ListAccountsResponse = {
  /**
   * The accounts returned in this list response.
   */
  accounts?: Array<Account>;
  /**
   * Continuation token used to page through accounts. To retrieve the next page of the results, set the next request's "page_token" value to this.
   */
  nextPageToken?: string;
};

/**
 * Response definition for the ad client list rpc.
 */
export type ListAdClientsResponse = {
  /**
   * The ad clients returned in this list response.
   */
  adClients?: Array<AdClient>;
  /**
   * Continuation token used to page through ad clients. To retrieve the next page of the results, set the next request's "page_token" value to this.
   */
  nextPageToken?: string;
};

/**
 * Response definition for the adunit list rpc.
 */
export type ListAdUnitsResponse = {
  /**
   * The ad units returned in the list response.
   */
  adUnits?: Array<AdUnit>;
  /**
   * Continuation token used to page through ad units. To retrieve the next page of the results, set the next request's "page_token" value to this.
   */
  nextPageToken?: string;
};

/**
 * Response definition for the alerts list rpc.
 */
export type ListAlertsResponse = {
  /**
   * The alerts returned in this list response.
   */
  alerts?: Array<Alert>;
};

/**
 * Response definition for the child account list rpc.
 */
export type ListChildAccountsResponse = {
  /**
   * The accounts returned in this list response.
   */
  accounts?: Array<Account>;
  /**
   * Continuation token used to page through accounts. To retrieve the next page of the results, set the next request's "page_token" value to this.
   */
  nextPageToken?: string;
};

/**
 * Response definition for the custom channel list rpc.
 */
export type ListCustomChannelsResponse = {
  /**
   * The custom channels returned in this list response.
   */
  customChannels?: Array<CustomChannel>;
  /**
   * Continuation token used to page through alerts. To retrieve the next page of the results, set the next request's "page_token" value to this.
   */
  nextPageToken?: string;
};

/**
 * Response definition for the ad units linked to a custom channel list rpc.
 */
export type ListLinkedAdUnitsResponse = {
  /**
   * The ad units returned in the list response.
   */
  adUnits?: Array<AdUnit>;
  /**
   * Continuation token used to page through ad units. To retrieve the next page of the results, set the next request's "page_token" value to this.
   */
  nextPageToken?: string;
};

/**
 * Response definition for the custom channels linked to an adunit list rpc.
 */
export type ListLinkedCustomChannelsResponse = {
  /**
   * The custom channels returned in this list response.
   */
  customChannels?: Array<CustomChannel>;
  /**
   * Continuation token used to page through alerts. To retrieve the next page of the results, set the next request's "page_token" value to this.
   */
  nextPageToken?: string;
};

/**
 * Response definition for the payments list rpc.
 */
export type ListPaymentsResponse = {
  /**
   * The payments returned in this list response.
   */
  payments?: Array<Payment>;
};

/**
 * Response definition for the saved reports list rpc.
 */
export type ListSavedReportsResponse = {
  /**
   * Continuation token used to page through reports. To retrieve the next page of the results, set the next request's "page_token" value to this.
   */
  nextPageToken?: string;
  /**
   * The reports returned in this list response.
   */
  savedReports?: Array<SavedReport>;
};

/**
 * Response definition for the sites list rpc.
 */
export type ListSitesResponse = {
  /**
   * Continuation token used to page through sites. To retrieve the next page of the results, set the next request's "page_token" value to this.
   */
  nextPageToken?: string;
  /**
   * The sites returned in this list response.
   */
  sites?: Array<Site>;
};

/**
 * Response definition for the url channels list rpc.
 */
export type ListUrlChannelsResponse = {
  /**
   * Continuation token used to page through url channels. To retrieve the next page of the results, set the next request's "page_token" value to this.
   */
  nextPageToken?: string;
  /**
   * The url channels returned in this list response.
   */
  urlChannels?: Array<UrlChannel>;
};

/**
 * Representation of an unpaid or paid payment. See [Payment timelines for AdSense](https://support.google.com/adsense/answer/7164703) for more information about payments and the [YouTube homepage and payments account](https://support.google.com/adsense/answer/11622510) article for information about dedicated payments accounts for YouTube.
 */
export type Payment = {
  /**
   * Output only. The amount of unpaid or paid earnings, as a formatted string, including the currency. E.g. "¥1,235 JPY", "$1,234.57", "£87.65".
   */
  readonly amount?: string;
  /**
   * Output only. For paid earnings, the date that the payment was credited. For unpaid earnings, this field is empty. Payment dates are always returned in the billing timezone (America/Los_Angeles).
   */
  readonly date?: GoogleDate;
  /**
   * Output only. Resource name of the payment. Format: - accounts/{account}/payments/unpaid for unpaid (current) AdSense earnings. - accounts/{account}/payments/youtube-unpaid for unpaid (current) YouTube earnings. - accounts/{account}/payments/yyyy-MM-dd for paid AdSense earnings. - accounts/{account}/payments/youtube-yyyy-MM-dd for paid YouTube earnings.
   */
  readonly name?: string;
};

/**
 * Result of a generated report.
 */
export type ReportResult = {
  /**
   * The averages of the report. This is the same length as any other row in the report; cells corresponding to dimension columns are empty.
   */
  averages?: Row;
  /**
   * Required. End date of the range (inclusive).
   */
  endDate?: GoogleDate;
  /**
   * The header information; one for each dimension in the request, followed by one for each metric in the request.
   */
  headers?: Array<Header>;
  /**
   * The output rows of the report. Each row is a list of cells; one for each dimension in the request, followed by one for each metric in the request.
   */
  rows?: Array<Row>;
  /**
   * Required. Start date of the range (inclusive).
   */
  startDate?: GoogleDate;
  /**
   * The total number of rows matched by the report request.
   */
  totalMatchedRows?: string;
  /**
   * The totals of the report. This is the same length as any other row in the report; cells corresponding to dimension columns are empty.
   */
  totals?: Row;
  /**
   * Any warnings associated with generation of the report. These warnings are always returned in English.
   */
  warnings?: Array<string>;
};

/**
 * Row representation.
 */
export type Row = {
  /**
   * Cells in the row.
   */
  cells?: Array<Cell>;
};

/**
 * Representation of a saved report.
 */
export type SavedReport = {
  /**
   * Output only. Resource name of the report. Format: accounts/{account}/reports/{report}
   */
  readonly name?: string;
  /**
   * Report title as specified by publisher.
   */
  title?: string;
};

/**
 * Representation of a Site.
 */
export type Site = {
  /**
   * Whether auto ads is turned on for the site.
   */
  autoAdsEnabled?: boolean;
  /**
   * Domain (or subdomain) of the site, e.g. "example.com" or "www.example.com". This is used in the `OWNED_SITE_DOMAIN_NAME` reporting dimension.
   */
  domain?: string;
  /**
   * Output only. Resource name of a site. Format: accounts/{account}/sites/{site}
   */
  readonly name?: string;
  /**
   * Output only. Unique ID of the site as used in the `OWNED_SITE_ID` reporting dimension.
   */
  readonly reportingDimensionId?: string;
  /**
   * Output only. State of a site.
   */
  readonly state?: 'STATE_UNSPECIFIED' | 'REQUIRES_REVIEW' | 'GETTING_READY' | 'READY' | 'NEEDS_ATTENTION';
};

/**
 * Output only. State of a site.
 */
export type state4 = 'STATE_UNSPECIFIED' | 'REQUIRES_REVIEW' | 'GETTING_READY' | 'READY' | 'NEEDS_ATTENTION';

/**
 * Represents a time zone from the [IANA Time Zone Database](https://www.iana.org/time-zones).
 */
export type TimeZone = {
  /**
   * IANA Time Zone Database time zone, e.g. "America/New_York".
   */
  id?: string;
  /**
   * Optional. IANA Time Zone Database version number, e.g. "2019a".
   */
  version?: string;
};

/**
 * Representation of a URL channel. URL channels allow you to track the performance of particular pages in your site; see [URL channels](https://support.google.com/adsense/answer/2923836) for more information.
 */
export type UrlChannel = {
  /**
   * Output only. Resource name of the URL channel. Format: accounts/{account}/adclients/{adclient}/urlchannels/{urlchannel}
   */
  readonly name?: string;
  /**
   * Output only. Unique ID of the custom channel as used in the `URL_CHANNEL_ID` reporting dimension.
   */
  readonly reportingDimensionId?: string;
  /**
   * URI pattern of the channel. Does not include "http://" or "https://". Example: www.example.com/home
   */
  uriPattern?: string;
};

/**
 * V1 error format.
 */
export type Parameter__xgafv = '1' | '2';

/**
 * OAuth access token.
 */
export type Parameteraccess_token = string;

/**
 * Data format for response.
 */
export type Parameteralt = 'json' | 'media' | 'proto';

/**
 * JSONP
 */
export type Parametercallback = string;

/**
 * Selector specifying which fields to include in a partial response.
 */
export type Parameterfields = string;

/**
 * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
 */
export type Parameterkey = string;

/**
 * OAuth 2.0 token for the current user.
 */
export type Parameteroauth_token = string;

/**
 * Returns response with indentations and line breaks.
 */
export type ParameterprettyPrint = boolean;

/**
 * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
 */
export type ParameterquotaUser = string;

/**
 * Legacy upload protocol for media (e.g. "media", "multipart").
 */
export type ParameteruploadType = string;

/**
 * Upload protocol for media (e.g. "raw", "multipart").
 */
export type Parameterupload_protocol = string;

export type AdsenseAccountsListData = {
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The maximum number of accounts to include in the response, used for paging. If unspecified, at most 10000 accounts will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.
     */
    pageSize?: number;
    /**
     * A page token, received from a previous `ListAccounts` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListAccounts` must match the call that provided the page token.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsListResponse = ListAccountsResponse;

export type AdsenseAccountsListError = unknown;

export type AdsenseAccountsReportsGenerateData = {
  path: {
    /**
     * Required. The account which owns the collection of reports. Format: accounts/{account}
     */
    account: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * The [ISO-4217 currency code](https://en.wikipedia.org/wiki/ISO_4217) to use when reporting on monetary metrics. Defaults to the account's currency if not set.
     */
    currencyCode?: string;
    /**
     * Date range of the report, if unset the range will be considered CUSTOM.
     */
    dateRange?:
      | 'REPORTING_DATE_RANGE_UNSPECIFIED'
      | 'CUSTOM'
      | 'TODAY'
      | 'YESTERDAY'
      | 'MONTH_TO_DATE'
      | 'YEAR_TO_DATE'
      | 'LAST_7_DAYS'
      | 'LAST_30_DAYS';
    /**
     * Dimensions to base the report on.
     */
    dimensions?: Array<
      | 'DIMENSION_UNSPECIFIED'
      | 'DATE'
      | 'WEEK'
      | 'MONTH'
      | 'ACCOUNT_NAME'
      | 'AD_CLIENT_ID'
      | 'HOSTED_AD_CLIENT_ID'
      | 'PRODUCT_NAME'
      | 'PRODUCT_CODE'
      | 'AD_UNIT_NAME'
      | 'AD_UNIT_ID'
      | 'AD_UNIT_SIZE_NAME'
      | 'AD_UNIT_SIZE_CODE'
      | 'CUSTOM_CHANNEL_NAME'
      | 'CUSTOM_CHANNEL_ID'
      | 'OWNED_SITE_DOMAIN_NAME'
      | 'OWNED_SITE_ID'
      | 'PAGE_URL'
      | 'URL_CHANNEL_NAME'
      | 'URL_CHANNEL_ID'
      | 'BUYER_NETWORK_NAME'
      | 'BUYER_NETWORK_ID'
      | 'BID_TYPE_NAME'
      | 'BID_TYPE_CODE'
      | 'CREATIVE_SIZE_NAME'
      | 'CREATIVE_SIZE_CODE'
      | 'DOMAIN_NAME'
      | 'DOMAIN_CODE'
      | 'COUNTRY_NAME'
      | 'COUNTRY_CODE'
      | 'PLATFORM_TYPE_NAME'
      | 'PLATFORM_TYPE_CODE'
      | 'TARGETING_TYPE_NAME'
      | 'TARGETING_TYPE_CODE'
      | 'CONTENT_PLATFORM_NAME'
      | 'CONTENT_PLATFORM_CODE'
      | 'AD_PLACEMENT_NAME'
      | 'AD_PLACEMENT_CODE'
      | 'REQUESTED_AD_TYPE_NAME'
      | 'REQUESTED_AD_TYPE_CODE'
      | 'SERVED_AD_TYPE_NAME'
      | 'SERVED_AD_TYPE_CODE'
      | 'AD_FORMAT_NAME'
      | 'AD_FORMAT_CODE'
      | 'CUSTOM_SEARCH_STYLE_NAME'
      | 'CUSTOM_SEARCH_STYLE_ID'
      | 'DOMAIN_REGISTRANT'
      | 'WEBSEARCH_QUERY_STRING'
    >;
    /**
     * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
     */
    'endDate.day'?: number;
    /**
     * Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
     */
    'endDate.month'?: number;
    /**
     * Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
     */
    'endDate.year'?: number;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * A list of [filters](/adsense/management/reporting/filtering) to apply to the report. All provided filters must match in order for the data to be included in the report.
     */
    filters?: Array<string>;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * The language to use for translating report output. If unspecified, this defaults to English ("en"). If the given language is not supported, report output will be returned in English. The language is specified as an [IETF BCP-47 language code](https://en.wikipedia.org/wiki/IETF_language_tag).
     */
    languageCode?: string;
    /**
     * The maximum number of rows of report data to return. Reports producing more rows than the requested limit will be truncated. If unset, this defaults to 100,000 rows for `Reports.GenerateReport` and 1,000,000 rows for `Reports.GenerateCsvReport`, which are also the maximum values permitted here. Report truncation can be identified (for `Reports.GenerateReport` only) by comparing the number of rows returned to the value returned in `total_matched_rows`.
     */
    limit?: number;
    /**
     * Required. Reporting metrics.
     */
    metrics?: Array<
      | 'METRIC_UNSPECIFIED'
      | 'PAGE_VIEWS'
      | 'AD_REQUESTS'
      | 'MATCHED_AD_REQUESTS'
      | 'TOTAL_IMPRESSIONS'
      | 'IMPRESSIONS'
      | 'INDIVIDUAL_AD_IMPRESSIONS'
      | 'CLICKS'
      | 'PAGE_VIEWS_SPAM_RATIO'
      | 'AD_REQUESTS_SPAM_RATIO'
      | 'MATCHED_AD_REQUESTS_SPAM_RATIO'
      | 'IMPRESSIONS_SPAM_RATIO'
      | 'INDIVIDUAL_AD_IMPRESSIONS_SPAM_RATIO'
      | 'CLICKS_SPAM_RATIO'
      | 'AD_REQUESTS_COVERAGE'
      | 'PAGE_VIEWS_CTR'
      | 'AD_REQUESTS_CTR'
      | 'MATCHED_AD_REQUESTS_CTR'
      | 'IMPRESSIONS_CTR'
      | 'INDIVIDUAL_AD_IMPRESSIONS_CTR'
      | 'ACTIVE_VIEW_MEASURABILITY'
      | 'ACTIVE_VIEW_VIEWABILITY'
      | 'ACTIVE_VIEW_TIME'
      | 'ESTIMATED_EARNINGS'
      | 'PAGE_VIEWS_RPM'
      | 'AD_REQUESTS_RPM'
      | 'MATCHED_AD_REQUESTS_RPM'
      | 'IMPRESSIONS_RPM'
      | 'INDIVIDUAL_AD_IMPRESSIONS_RPM'
      | 'COST_PER_CLICK'
      | 'ADS_PER_IMPRESSION'
      | 'TOTAL_EARNINGS'
      | 'WEBSEARCH_RESULT_PAGES'
      | 'FUNNEL_REQUESTS'
      | 'FUNNEL_IMPRESSIONS'
      | 'FUNNEL_CLICKS'
      | 'FUNNEL_RPM'
    >;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The name of a dimension or metric to sort the resulting report on, can be prefixed with "+" to sort ascending or "-" to sort descending. If no prefix is specified, the column is sorted ascending.
     */
    orderBy?: Array<string>;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Timezone in which to generate the report. If unspecified, this defaults to the account timezone. For more information, see [changing the time zone of your reports](https://support.google.com/adsense/answer/9830725).
     */
    reportingTimeZone?: 'REPORTING_TIME_ZONE_UNSPECIFIED' | 'ACCOUNT_TIME_ZONE' | 'GOOGLE_TIME_ZONE';
    /**
     * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
     */
    'startDate.day'?: number;
    /**
     * Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
     */
    'startDate.month'?: number;
    /**
     * Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
     */
    'startDate.year'?: number;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsReportsGenerateResponse = ReportResult;

export type AdsenseAccountsReportsGenerateError = unknown;

export type AdsenseAccountsReportsGenerateCsvData = {
  path: {
    /**
     * Required. The account which owns the collection of reports. Format: accounts/{account}
     */
    account: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * The [ISO-4217 currency code](https://en.wikipedia.org/wiki/ISO_4217) to use when reporting on monetary metrics. Defaults to the account's currency if not set.
     */
    currencyCode?: string;
    /**
     * Date range of the report, if unset the range will be considered CUSTOM.
     */
    dateRange?:
      | 'REPORTING_DATE_RANGE_UNSPECIFIED'
      | 'CUSTOM'
      | 'TODAY'
      | 'YESTERDAY'
      | 'MONTH_TO_DATE'
      | 'YEAR_TO_DATE'
      | 'LAST_7_DAYS'
      | 'LAST_30_DAYS';
    /**
     * Dimensions to base the report on.
     */
    dimensions?: Array<
      | 'DIMENSION_UNSPECIFIED'
      | 'DATE'
      | 'WEEK'
      | 'MONTH'
      | 'ACCOUNT_NAME'
      | 'AD_CLIENT_ID'
      | 'HOSTED_AD_CLIENT_ID'
      | 'PRODUCT_NAME'
      | 'PRODUCT_CODE'
      | 'AD_UNIT_NAME'
      | 'AD_UNIT_ID'
      | 'AD_UNIT_SIZE_NAME'
      | 'AD_UNIT_SIZE_CODE'
      | 'CUSTOM_CHANNEL_NAME'
      | 'CUSTOM_CHANNEL_ID'
      | 'OWNED_SITE_DOMAIN_NAME'
      | 'OWNED_SITE_ID'
      | 'PAGE_URL'
      | 'URL_CHANNEL_NAME'
      | 'URL_CHANNEL_ID'
      | 'BUYER_NETWORK_NAME'
      | 'BUYER_NETWORK_ID'
      | 'BID_TYPE_NAME'
      | 'BID_TYPE_CODE'
      | 'CREATIVE_SIZE_NAME'
      | 'CREATIVE_SIZE_CODE'
      | 'DOMAIN_NAME'
      | 'DOMAIN_CODE'
      | 'COUNTRY_NAME'
      | 'COUNTRY_CODE'
      | 'PLATFORM_TYPE_NAME'
      | 'PLATFORM_TYPE_CODE'
      | 'TARGETING_TYPE_NAME'
      | 'TARGETING_TYPE_CODE'
      | 'CONTENT_PLATFORM_NAME'
      | 'CONTENT_PLATFORM_CODE'
      | 'AD_PLACEMENT_NAME'
      | 'AD_PLACEMENT_CODE'
      | 'REQUESTED_AD_TYPE_NAME'
      | 'REQUESTED_AD_TYPE_CODE'
      | 'SERVED_AD_TYPE_NAME'
      | 'SERVED_AD_TYPE_CODE'
      | 'AD_FORMAT_NAME'
      | 'AD_FORMAT_CODE'
      | 'CUSTOM_SEARCH_STYLE_NAME'
      | 'CUSTOM_SEARCH_STYLE_ID'
      | 'DOMAIN_REGISTRANT'
      | 'WEBSEARCH_QUERY_STRING'
    >;
    /**
     * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
     */
    'endDate.day'?: number;
    /**
     * Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
     */
    'endDate.month'?: number;
    /**
     * Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
     */
    'endDate.year'?: number;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * A list of [filters](/adsense/management/reporting/filtering) to apply to the report. All provided filters must match in order for the data to be included in the report.
     */
    filters?: Array<string>;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * The language to use for translating report output. If unspecified, this defaults to English ("en"). If the given language is not supported, report output will be returned in English. The language is specified as an [IETF BCP-47 language code](https://en.wikipedia.org/wiki/IETF_language_tag).
     */
    languageCode?: string;
    /**
     * The maximum number of rows of report data to return. Reports producing more rows than the requested limit will be truncated. If unset, this defaults to 100,000 rows for `Reports.GenerateReport` and 1,000,000 rows for `Reports.GenerateCsvReport`, which are also the maximum values permitted here. Report truncation can be identified (for `Reports.GenerateReport` only) by comparing the number of rows returned to the value returned in `total_matched_rows`.
     */
    limit?: number;
    /**
     * Required. Reporting metrics.
     */
    metrics?: Array<
      | 'METRIC_UNSPECIFIED'
      | 'PAGE_VIEWS'
      | 'AD_REQUESTS'
      | 'MATCHED_AD_REQUESTS'
      | 'TOTAL_IMPRESSIONS'
      | 'IMPRESSIONS'
      | 'INDIVIDUAL_AD_IMPRESSIONS'
      | 'CLICKS'
      | 'PAGE_VIEWS_SPAM_RATIO'
      | 'AD_REQUESTS_SPAM_RATIO'
      | 'MATCHED_AD_REQUESTS_SPAM_RATIO'
      | 'IMPRESSIONS_SPAM_RATIO'
      | 'INDIVIDUAL_AD_IMPRESSIONS_SPAM_RATIO'
      | 'CLICKS_SPAM_RATIO'
      | 'AD_REQUESTS_COVERAGE'
      | 'PAGE_VIEWS_CTR'
      | 'AD_REQUESTS_CTR'
      | 'MATCHED_AD_REQUESTS_CTR'
      | 'IMPRESSIONS_CTR'
      | 'INDIVIDUAL_AD_IMPRESSIONS_CTR'
      | 'ACTIVE_VIEW_MEASURABILITY'
      | 'ACTIVE_VIEW_VIEWABILITY'
      | 'ACTIVE_VIEW_TIME'
      | 'ESTIMATED_EARNINGS'
      | 'PAGE_VIEWS_RPM'
      | 'AD_REQUESTS_RPM'
      | 'MATCHED_AD_REQUESTS_RPM'
      | 'IMPRESSIONS_RPM'
      | 'INDIVIDUAL_AD_IMPRESSIONS_RPM'
      | 'COST_PER_CLICK'
      | 'ADS_PER_IMPRESSION'
      | 'TOTAL_EARNINGS'
      | 'WEBSEARCH_RESULT_PAGES'
      | 'FUNNEL_REQUESTS'
      | 'FUNNEL_IMPRESSIONS'
      | 'FUNNEL_CLICKS'
      | 'FUNNEL_RPM'
    >;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The name of a dimension or metric to sort the resulting report on, can be prefixed with "+" to sort ascending or "-" to sort descending. If no prefix is specified, the column is sorted ascending.
     */
    orderBy?: Array<string>;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Timezone in which to generate the report. If unspecified, this defaults to the account timezone. For more information, see [changing the time zone of your reports](https://support.google.com/adsense/answer/9830725).
     */
    reportingTimeZone?: 'REPORTING_TIME_ZONE_UNSPECIFIED' | 'ACCOUNT_TIME_ZONE' | 'GOOGLE_TIME_ZONE';
    /**
     * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
     */
    'startDate.day'?: number;
    /**
     * Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
     */
    'startDate.month'?: number;
    /**
     * Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
     */
    'startDate.year'?: number;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsReportsGenerateCsvResponse = HttpBody;

export type AdsenseAccountsReportsGenerateCsvError = unknown;

export type AdsenseAccountsAdclientsCustomchannelsDeleteData = {
  path: {
    /**
     * Required. Name of the custom channel to delete. Format: accounts/{account}/adclients/{adclient}/customchannels/{customchannel}
     */
    name: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsAdclientsCustomchannelsDeleteResponse = Empty;

export type AdsenseAccountsAdclientsCustomchannelsDeleteError = unknown;

export type AdsenseAccountsSitesGetData = {
  path: {
    /**
     * Required. Name of the site. Format: accounts/{account}/sites/{site}
     */
    name: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsSitesGetResponse = Site;

export type AdsenseAccountsSitesGetError = unknown;

export type AdsenseAccountsAdclientsCustomchannelsPatchData = {
  body?: CustomChannel;
  path: {
    /**
     * Output only. Resource name of the custom channel. Format: accounts/{account}/adclients/{adclient}/customchannels/{customchannel}
     */
    name: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * The list of fields to update. If empty, a full update is performed.
     */
    updateMask?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsAdclientsCustomchannelsPatchResponse = CustomChannel;

export type AdsenseAccountsAdclientsCustomchannelsPatchError = unknown;

export type AdsenseAccountsGetAdBlockingRecoveryTagData = {
  path: {
    /**
     * Required. The name of the account to get the tag for. Format: accounts/{account}
     */
    name: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsGetAdBlockingRecoveryTagResponse = AdBlockingRecoveryTag;

export type AdsenseAccountsGetAdBlockingRecoveryTagError = unknown;

export type AdsenseAccountsAdclientsAdunitsGetAdcodeData = {
  path: {
    /**
     * Required. Name of the adunit for which to get the adcode. Format: accounts/{account}/adclients/{adclient}/adunits/{adunit}
     */
    name: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsAdclientsAdunitsGetAdcodeResponse = AdUnitAdCode;

export type AdsenseAccountsAdclientsAdunitsGetAdcodeError = unknown;

export type AdsenseAccountsReportsGetSavedData = {
  path: {
    /**
     * Required. The name of the saved report to retrieve. Format: accounts/{account}/reports/{report}
     */
    name: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsReportsGetSavedResponse = SavedReport;

export type AdsenseAccountsReportsGetSavedError = unknown;

export type AdsenseAccountsReportsSavedGenerateData = {
  path: {
    /**
     * Required. Name of the saved report. Format: accounts/{account}/reports/{report}
     */
    name: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * The [ISO-4217 currency code](https://en.wikipedia.org/wiki/ISO_4217) to use when reporting on monetary metrics. Defaults to the account's currency if not set.
     */
    currencyCode?: string;
    /**
     * Date range of the report, if unset the range will be considered CUSTOM.
     */
    dateRange?:
      | 'REPORTING_DATE_RANGE_UNSPECIFIED'
      | 'CUSTOM'
      | 'TODAY'
      | 'YESTERDAY'
      | 'MONTH_TO_DATE'
      | 'YEAR_TO_DATE'
      | 'LAST_7_DAYS'
      | 'LAST_30_DAYS';
    /**
     * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
     */
    'endDate.day'?: number;
    /**
     * Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
     */
    'endDate.month'?: number;
    /**
     * Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
     */
    'endDate.year'?: number;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * The language to use for translating report output. If unspecified, this defaults to English ("en"). If the given language is not supported, report output will be returned in English. The language is specified as an [IETF BCP-47 language code](https://en.wikipedia.org/wiki/IETF_language_tag).
     */
    languageCode?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Timezone in which to generate the report. If unspecified, this defaults to the account timezone. For more information, see [changing the time zone of your reports](https://support.google.com/adsense/answer/9830725).
     */
    reportingTimeZone?: 'REPORTING_TIME_ZONE_UNSPECIFIED' | 'ACCOUNT_TIME_ZONE' | 'GOOGLE_TIME_ZONE';
    /**
     * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
     */
    'startDate.day'?: number;
    /**
     * Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
     */
    'startDate.month'?: number;
    /**
     * Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
     */
    'startDate.year'?: number;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsReportsSavedGenerateResponse = ReportResult;

export type AdsenseAccountsReportsSavedGenerateError = unknown;

export type AdsenseAccountsReportsSavedGenerateCsvData = {
  path: {
    /**
     * Required. Name of the saved report. Format: accounts/{account}/reports/{report}
     */
    name: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * The [ISO-4217 currency code](https://en.wikipedia.org/wiki/ISO_4217) to use when reporting on monetary metrics. Defaults to the account's currency if not set.
     */
    currencyCode?: string;
    /**
     * Date range of the report, if unset the range will be considered CUSTOM.
     */
    dateRange?:
      | 'REPORTING_DATE_RANGE_UNSPECIFIED'
      | 'CUSTOM'
      | 'TODAY'
      | 'YESTERDAY'
      | 'MONTH_TO_DATE'
      | 'YEAR_TO_DATE'
      | 'LAST_7_DAYS'
      | 'LAST_30_DAYS';
    /**
     * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
     */
    'endDate.day'?: number;
    /**
     * Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
     */
    'endDate.month'?: number;
    /**
     * Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
     */
    'endDate.year'?: number;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * The language to use for translating report output. If unspecified, this defaults to English ("en"). If the given language is not supported, report output will be returned in English. The language is specified as an [IETF BCP-47 language code](https://en.wikipedia.org/wiki/IETF_language_tag).
     */
    languageCode?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Timezone in which to generate the report. If unspecified, this defaults to the account timezone. For more information, see [changing the time zone of your reports](https://support.google.com/adsense/answer/9830725).
     */
    reportingTimeZone?: 'REPORTING_TIME_ZONE_UNSPECIFIED' | 'ACCOUNT_TIME_ZONE' | 'GOOGLE_TIME_ZONE';
    /**
     * Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a year and month where the day isn't significant.
     */
    'startDate.day'?: number;
    /**
     * Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.
     */
    'startDate.month'?: number;
    /**
     * Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.
     */
    'startDate.year'?: number;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsReportsSavedGenerateCsvResponse = HttpBody;

export type AdsenseAccountsReportsSavedGenerateCsvError = unknown;

export type AdsenseAccountsAdclientsListData = {
  path: {
    /**
     * Required. The account which owns the collection of ad clients. Format: accounts/{account}
     */
    parent: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The maximum number of ad clients to include in the response, used for paging. If unspecified, at most 10000 ad clients will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.
     */
    pageSize?: number;
    /**
     * A page token, received from a previous `ListAdClients` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListAdClients` must match the call that provided the page token.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsAdclientsListResponse = ListAdClientsResponse;

export type AdsenseAccountsAdclientsListError = unknown;

export type AdsenseAccountsAdclientsAdunitsListData = {
  path: {
    /**
     * Required. The ad client which owns the collection of ad units. Format: accounts/{account}/adclients/{adclient}
     */
    parent: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The maximum number of ad units to include in the response, used for paging. If unspecified, at most 10000 ad units will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.
     */
    pageSize?: number;
    /**
     * A page token, received from a previous `ListAdUnits` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListAdUnits` must match the call that provided the page token.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsAdclientsAdunitsListResponse = ListAdUnitsResponse;

export type AdsenseAccountsAdclientsAdunitsListError = unknown;

export type AdsenseAccountsAdclientsAdunitsCreateData = {
  body?: AdUnit;
  path: {
    /**
     * Required. Ad client to create an ad unit under. Format: accounts/{account}/adclients/{adclient}
     */
    parent: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsAdclientsAdunitsCreateResponse = AdUnit;

export type AdsenseAccountsAdclientsAdunitsCreateError = unknown;

export type AdsenseAccountsAlertsListData = {
  path: {
    /**
     * Required. The account which owns the collection of alerts. Format: accounts/{account}
     */
    parent: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * The language to use for translating alert messages. If unspecified, this defaults to the user's display language. If the given language is not supported, alerts will be returned in English. The language is specified as an [IETF BCP-47 language code](https://en.wikipedia.org/wiki/IETF_language_tag).
     */
    languageCode?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsAlertsListResponse = ListAlertsResponse;

export type AdsenseAccountsAlertsListError = unknown;

export type AdsenseAccountsAdclientsCustomchannelsListData = {
  path: {
    /**
     * Required. The ad client which owns the collection of custom channels. Format: accounts/{account}/adclients/{adclient}
     */
    parent: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The maximum number of custom channels to include in the response, used for paging. If unspecified, at most 10000 custom channels will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.
     */
    pageSize?: number;
    /**
     * A page token, received from a previous `ListCustomChannels` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListCustomChannels` must match the call that provided the page token.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsAdclientsCustomchannelsListResponse = ListCustomChannelsResponse;

export type AdsenseAccountsAdclientsCustomchannelsListError = unknown;

export type AdsenseAccountsAdclientsCustomchannelsCreateData = {
  body?: CustomChannel;
  path: {
    /**
     * Required. The ad client to create a custom channel under. Format: accounts/{account}/adclients/{adclient}
     */
    parent: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsAdclientsCustomchannelsCreateResponse = CustomChannel;

export type AdsenseAccountsAdclientsCustomchannelsCreateError = unknown;

export type AdsenseAccountsPaymentsListData = {
  path: {
    /**
     * Required. The account which owns the collection of payments. Format: accounts/{account}
     */
    parent: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsPaymentsListResponse = ListPaymentsResponse;

export type AdsenseAccountsPaymentsListError = unknown;

export type AdsenseAccountsReportsSavedListData = {
  path: {
    /**
     * Required. The account which owns the collection of reports. Format: accounts/{account}
     */
    parent: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The maximum number of reports to include in the response, used for paging. If unspecified, at most 10000 reports will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.
     */
    pageSize?: number;
    /**
     * A page token, received from a previous `ListSavedReports` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListSavedReports` must match the call that provided the page token.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsReportsSavedListResponse = ListSavedReportsResponse;

export type AdsenseAccountsReportsSavedListError = unknown;

export type AdsenseAccountsSitesListData = {
  path: {
    /**
     * Required. The account which owns the collection of sites. Format: accounts/{account}
     */
    parent: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The maximum number of sites to include in the response, used for paging. If unspecified, at most 10000 sites will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.
     */
    pageSize?: number;
    /**
     * A page token, received from a previous `ListSites` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListSites` must match the call that provided the page token.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsSitesListResponse = ListSitesResponse;

export type AdsenseAccountsSitesListError = unknown;

export type AdsenseAccountsAdclientsUrlchannelsListData = {
  path: {
    /**
     * Required. The ad client which owns the collection of url channels. Format: accounts/{account}/adclients/{adclient}
     */
    parent: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The maximum number of url channels to include in the response, used for paging. If unspecified, at most 10000 url channels will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.
     */
    pageSize?: number;
    /**
     * A page token, received from a previous `ListUrlChannels` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListUrlChannels` must match the call that provided the page token.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsAdclientsUrlchannelsListResponse = ListUrlChannelsResponse;

export type AdsenseAccountsAdclientsUrlchannelsListError = unknown;

export type AdsenseAccountsListChildAccountsData = {
  path: {
    /**
     * Required. The parent account, which owns the child accounts. Format: accounts/{account}
     */
    parent: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The maximum number of accounts to include in the response, used for paging. If unspecified, at most 10000 accounts will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.
     */
    pageSize?: number;
    /**
     * A page token, received from a previous `ListChildAccounts` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListChildAccounts` must match the call that provided the page token.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsListChildAccountsResponse = ListChildAccountsResponse;

export type AdsenseAccountsListChildAccountsError = unknown;

export type AdsenseAccountsAdclientsCustomchannelsListLinkedAdUnitsData = {
  path: {
    /**
     * Required. The custom channel which owns the collection of ad units. Format: accounts/{account}/adclients/{adclient}/customchannels/{customchannel}
     */
    parent: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The maximum number of ad units to include in the response, used for paging. If unspecified, at most 10000 ad units will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.
     */
    pageSize?: number;
    /**
     * A page token, received from a previous `ListLinkedAdUnits` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListLinkedAdUnits` must match the call that provided the page token.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsAdclientsCustomchannelsListLinkedAdUnitsResponse = ListLinkedAdUnitsResponse;

export type AdsenseAccountsAdclientsCustomchannelsListLinkedAdUnitsError = unknown;

export type AdsenseAccountsAdclientsAdunitsListLinkedCustomChannelsData = {
  path: {
    /**
     * Required. The ad unit which owns the collection of custom channels. Format: accounts/{account}/adclients/{adclient}/adunits/{adunit}
     */
    parent: string;
  };
  query?: {
    /**
     * V1 error format.
     */
    '$.xgafv'?: '1' | '2';
    /**
     * OAuth access token.
     */
    access_token?: string;
    /**
     * Data format for response.
     */
    alt?: 'json' | 'media' | 'proto';
    /**
     * JSONP
     */
    callback?: string;
    /**
     * Selector specifying which fields to include in a partial response.
     */
    fields?: string;
    /**
     * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
     */
    key?: string;
    /**
     * OAuth 2.0 token for the current user.
     */
    oauth_token?: string;
    /**
     * The maximum number of custom channels to include in the response, used for paging. If unspecified, at most 10000 custom channels will be returned. The maximum value is 10000; values above 10000 will be coerced to 10000.
     */
    pageSize?: number;
    /**
     * A page token, received from a previous `ListLinkedCustomChannels` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListLinkedCustomChannels` must match the call that provided the page token.
     */
    pageToken?: string;
    /**
     * Returns response with indentations and line breaks.
     */
    prettyPrint?: boolean;
    /**
     * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
     */
    quotaUser?: string;
    /**
     * Upload protocol for media (e.g. "raw", "multipart").
     */
    upload_protocol?: string;
    /**
     * Legacy upload protocol for media (e.g. "media", "multipart").
     */
    uploadType?: string;
  };
};

export type AdsenseAccountsAdclientsAdunitsListLinkedCustomChannelsResponse = ListLinkedCustomChannelsResponse;

export type AdsenseAccountsAdclientsAdunitsListLinkedCustomChannelsError = unknown;
