// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  AdsenseAccountsListData,
  AdsenseAccountsListError,
  AdsenseAccountsListResponse,
  AdsenseAccountsReportsGenerateData,
  AdsenseAccountsReportsGenerateError,
  AdsenseAccountsReportsGenerateResponse,
  AdsenseAccountsReportsGenerateCsvData,
  AdsenseAccountsReportsGenerateCsvError,
  AdsenseAccountsReportsGenerateCsvResponse,
  AdsenseAccountsAdclientsCustomchannelsDeleteData,
  AdsenseAccountsAdclientsCustomchannelsDeleteError,
  AdsenseAccountsAdclientsCustomchannelsDeleteResponse,
  AdsenseAccountsSitesGetData,
  AdsenseAccountsSitesGetError,
  AdsenseAccountsSitesGetResponse,
  AdsenseAccountsAdclientsCustomchannelsPatchData,
  AdsenseAccountsAdclientsCustomchannelsPatchError,
  AdsenseAccountsAdclientsCustomchannelsPatchResponse,
  AdsenseAccountsGetAdBlockingRecoveryTagData,
  AdsenseAccountsGetAdBlockingRecoveryTagError,
  AdsenseAccountsGetAdBlockingRecoveryTagResponse,
  AdsenseAccountsAdclientsAdunitsGetAdcodeData,
  AdsenseAccountsAdclientsAdunitsGetAdcodeError,
  AdsenseAccountsAdclientsAdunitsGetAdcodeResponse,
  AdsenseAccountsReportsGetSavedData,
  AdsenseAccountsReportsGetSavedError,
  AdsenseAccountsReportsGetSavedResponse,
  AdsenseAccountsReportsSavedGenerateData,
  AdsenseAccountsReportsSavedGenerateError,
  AdsenseAccountsReportsSavedGenerateResponse,
  AdsenseAccountsReportsSavedGenerateCsvData,
  AdsenseAccountsReportsSavedGenerateCsvError,
  AdsenseAccountsReportsSavedGenerateCsvResponse,
  AdsenseAccountsAdclientsListData,
  AdsenseAccountsAdclientsListError,
  AdsenseAccountsAdclientsListResponse,
  AdsenseAccountsAdclientsAdunitsListData,
  AdsenseAccountsAdclientsAdunitsListError,
  AdsenseAccountsAdclientsAdunitsListResponse,
  AdsenseAccountsAdclientsAdunitsCreateData,
  AdsenseAccountsAdclientsAdunitsCreateError,
  AdsenseAccountsAdclientsAdunitsCreateResponse,
  AdsenseAccountsAlertsListData,
  AdsenseAccountsAlertsListError,
  AdsenseAccountsAlertsListResponse,
  AdsenseAccountsAdclientsCustomchannelsListData,
  AdsenseAccountsAdclientsCustomchannelsListError,
  AdsenseAccountsAdclientsCustomchannelsListResponse,
  AdsenseAccountsAdclientsCustomchannelsCreateData,
  AdsenseAccountsAdclientsCustomchannelsCreateError,
  AdsenseAccountsAdclientsCustomchannelsCreateResponse,
  AdsenseAccountsPaymentsListData,
  AdsenseAccountsPaymentsListError,
  AdsenseAccountsPaymentsListResponse,
  AdsenseAccountsReportsSavedListData,
  AdsenseAccountsReportsSavedListError,
  AdsenseAccountsReportsSavedListResponse,
  AdsenseAccountsSitesListData,
  AdsenseAccountsSitesListError,
  AdsenseAccountsSitesListResponse,
  AdsenseAccountsAdclientsUrlchannelsListData,
  AdsenseAccountsAdclientsUrlchannelsListError,
  AdsenseAccountsAdclientsUrlchannelsListResponse,
  AdsenseAccountsListChildAccountsData,
  AdsenseAccountsListChildAccountsError,
  AdsenseAccountsListChildAccountsResponse,
  AdsenseAccountsAdclientsCustomchannelsListLinkedAdUnitsData,
  AdsenseAccountsAdclientsCustomchannelsListLinkedAdUnitsError,
  AdsenseAccountsAdclientsCustomchannelsListLinkedAdUnitsResponse,
  AdsenseAccountsAdclientsAdunitsListLinkedCustomChannelsData,
  AdsenseAccountsAdclientsAdunitsListLinkedCustomChannelsError,
  AdsenseAccountsAdclientsAdunitsListLinkedCustomChannelsResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Lists all accounts available to this user.
 */
export const adsenseAccountsList = <ThrowOnError extends boolean = false>(
  options?: Options<AdsenseAccountsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AdsenseAccountsListResponse, AdsenseAccountsListError, ThrowOnError>({
    ...options,
    url: '/v2/accounts',
  });
};

/**
 * Generates an ad hoc report.
 */
export const adsenseAccountsReportsGenerate = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsReportsGenerateData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdsenseAccountsReportsGenerateResponse,
    AdsenseAccountsReportsGenerateError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{account}/reports:generate',
  });
};

/**
 * Generates a csv formatted ad hoc report.
 */
export const adsenseAccountsReportsGenerateCsv = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsReportsGenerateCsvData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdsenseAccountsReportsGenerateCsvResponse,
    AdsenseAccountsReportsGenerateCsvError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{account}/reports:generateCsv',
  });
};

/**
 * Deletes a custom channel. This method can only be used by projects enabled for the [AdSense for Platforms](https://developers.google.com/adsense/platforms/) product.
 */
export const adsenseAccountsAdclientsCustomchannelsDelete = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsAdclientsCustomchannelsDeleteData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<
    AdsenseAccountsAdclientsCustomchannelsDeleteResponse,
    AdsenseAccountsAdclientsCustomchannelsDeleteError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{name}',
  });
};

/**
 * Gets information about the selected site.
 */
export const adsenseAccountsSitesGet = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsSitesGetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AdsenseAccountsSitesGetResponse, AdsenseAccountsSitesGetError, ThrowOnError>({
    ...options,
    url: '/v2/{name}',
  });
};

/**
 * Updates a custom channel. This method can only be used by projects enabled for the [AdSense for Platforms](https://developers.google.com/adsense/platforms/) product.
 */
export const adsenseAccountsAdclientsCustomchannelsPatch = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsAdclientsCustomchannelsPatchData, ThrowOnError>,
) => {
  return (options?.client ?? client).patch<
    AdsenseAccountsAdclientsCustomchannelsPatchResponse,
    AdsenseAccountsAdclientsCustomchannelsPatchError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{name}',
  });
};

/**
 * Gets the ad blocking recovery tag of an account.
 */
export const adsenseAccountsGetAdBlockingRecoveryTag = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsGetAdBlockingRecoveryTagData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdsenseAccountsGetAdBlockingRecoveryTagResponse,
    AdsenseAccountsGetAdBlockingRecoveryTagError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{name}/adBlockingRecoveryTag',
  });
};

/**
 * Gets the ad unit code for a given ad unit. For more information, see [About the AdSense code](https://support.google.com/adsense/answer/9274634) and [Where to place the ad code in your HTML](https://support.google.com/adsense/answer/9190028).
 */
export const adsenseAccountsAdclientsAdunitsGetAdcode = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsAdclientsAdunitsGetAdcodeData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdsenseAccountsAdclientsAdunitsGetAdcodeResponse,
    AdsenseAccountsAdclientsAdunitsGetAdcodeError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{name}/adcode',
  });
};

/**
 * Gets the saved report from the given resource name.
 */
export const adsenseAccountsReportsGetSaved = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsReportsGetSavedData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdsenseAccountsReportsGetSavedResponse,
    AdsenseAccountsReportsGetSavedError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{name}/saved',
  });
};

/**
 * Generates a saved report.
 */
export const adsenseAccountsReportsSavedGenerate = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsReportsSavedGenerateData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdsenseAccountsReportsSavedGenerateResponse,
    AdsenseAccountsReportsSavedGenerateError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{name}/saved:generate',
  });
};

/**
 * Generates a csv formatted saved report.
 */
export const adsenseAccountsReportsSavedGenerateCsv = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsReportsSavedGenerateCsvData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdsenseAccountsReportsSavedGenerateCsvResponse,
    AdsenseAccountsReportsSavedGenerateCsvError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{name}/saved:generateCsv',
  });
};

/**
 * Lists all the ad clients available in an account.
 */
export const adsenseAccountsAdclientsList = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsAdclientsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdsenseAccountsAdclientsListResponse,
    AdsenseAccountsAdclientsListError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{parent}/adclients',
  });
};

/**
 * Lists all ad units under a specified account and ad client.
 */
export const adsenseAccountsAdclientsAdunitsList = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsAdclientsAdunitsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdsenseAccountsAdclientsAdunitsListResponse,
    AdsenseAccountsAdclientsAdunitsListError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{parent}/adunits',
  });
};

/**
 * Creates an ad unit. This method can only be used by projects enabled for the [AdSense for Platforms](https://developers.google.com/adsense/platforms/) product. Note that ad units can only be created for ad clients with an "AFC" product code. For more info see the [AdClient resource](/adsense/management/reference/rest/v2/accounts.adclients). For now, this method can only be used to create `DISPLAY` ad units. See: https://support.google.com/adsense/answer/9183566
 */
export const adsenseAccountsAdclientsAdunitsCreate = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsAdclientsAdunitsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AdsenseAccountsAdclientsAdunitsCreateResponse,
    AdsenseAccountsAdclientsAdunitsCreateError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{parent}/adunits',
  });
};

/**
 * Lists all the alerts available in an account.
 */
export const adsenseAccountsAlertsList = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsAlertsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdsenseAccountsAlertsListResponse,
    AdsenseAccountsAlertsListError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{parent}/alerts',
  });
};

/**
 * Lists all the custom channels available in an ad client.
 */
export const adsenseAccountsAdclientsCustomchannelsList = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsAdclientsCustomchannelsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdsenseAccountsAdclientsCustomchannelsListResponse,
    AdsenseAccountsAdclientsCustomchannelsListError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{parent}/customchannels',
  });
};

/**
 * Creates a custom channel. This method can only be used by projects enabled for the [AdSense for Platforms](https://developers.google.com/adsense/platforms/) product.
 */
export const adsenseAccountsAdclientsCustomchannelsCreate = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsAdclientsCustomchannelsCreateData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<
    AdsenseAccountsAdclientsCustomchannelsCreateResponse,
    AdsenseAccountsAdclientsCustomchannelsCreateError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{parent}/customchannels',
  });
};

/**
 * Lists all the payments available for an account.
 */
export const adsenseAccountsPaymentsList = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsPaymentsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdsenseAccountsPaymentsListResponse,
    AdsenseAccountsPaymentsListError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{parent}/payments',
  });
};

/**
 * Lists saved reports.
 */
export const adsenseAccountsReportsSavedList = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsReportsSavedListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdsenseAccountsReportsSavedListResponse,
    AdsenseAccountsReportsSavedListError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{parent}/reports/saved',
  });
};

/**
 * Lists all the sites available in an account.
 */
export const adsenseAccountsSitesList = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsSitesListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<AdsenseAccountsSitesListResponse, AdsenseAccountsSitesListError, ThrowOnError>(
    {
      ...options,
      url: '/v2/{parent}/sites',
    },
  );
};

/**
 * Lists active url channels.
 */
export const adsenseAccountsAdclientsUrlchannelsList = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsAdclientsUrlchannelsListData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdsenseAccountsAdclientsUrlchannelsListResponse,
    AdsenseAccountsAdclientsUrlchannelsListError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{parent}/urlchannels',
  });
};

/**
 * Lists all accounts directly managed by the given AdSense account.
 */
export const adsenseAccountsListChildAccounts = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsListChildAccountsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdsenseAccountsListChildAccountsResponse,
    AdsenseAccountsListChildAccountsError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{parent}:listChildAccounts',
  });
};

/**
 * Lists all the ad units available for a custom channel.
 */
export const adsenseAccountsAdclientsCustomchannelsListLinkedAdUnits = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsAdclientsCustomchannelsListLinkedAdUnitsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdsenseAccountsAdclientsCustomchannelsListLinkedAdUnitsResponse,
    AdsenseAccountsAdclientsCustomchannelsListLinkedAdUnitsError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{parent}:listLinkedAdUnits',
  });
};

/**
 * Lists all the custom channels available for an ad unit.
 */
export const adsenseAccountsAdclientsAdunitsListLinkedCustomChannels = <ThrowOnError extends boolean = false>(
  options: Options<AdsenseAccountsAdclientsAdunitsListLinkedCustomChannelsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    AdsenseAccountsAdclientsAdunitsListLinkedCustomChannelsResponse,
    AdsenseAccountsAdclientsAdunitsListLinkedCustomChannelsError,
    ThrowOnError
  >({
    ...options,
    url: '/v2/{parent}:listLinkedCustomChannels',
  });
};
