// Generated by ts-to-zod
import { z } from 'zod';

import {
  type HasChildrenTrait,
  type SubcanvasNode,
  type TransitionSourceTrait,
  type Interaction,
  type FrameTraits,
  type DefaultShapeTraits,
  type CornerRadiusShapeTraits,
  type RectangularShapeTraits,
  type Node,
  type BooleanOperationNode,
  type ComponentNode,
  type ComponentSetNode,
  type EllipseNode,
  type FrameNode,
  type GroupNode,
  type InstanceNode,
  type LineNode,
  type RectangleNode,
  type RegularPolygonNode,
  type SectionNode,
  type StarNode,
  type TableNode,
  type TextNode,
  type VectorNode,
  type WashiTapeNode,
  type WidgetNode,
  type DocumentNode,
  type CanvasNode,
  type Action,
  type SetVariableAction,
  type ConditionalAction,
  type VariableData,
  type ConditionalBlock,
  type Expression,
  type GetFileResponse,
  type GetFileNodesResponse,
} from './types.gen';

export const variableAliasSchema = z.object({
  type: z.literal('VARIABLE_ALIAS'),
  id: z.string(),
});

export const scrollBehaviorSchema = z.union([z.literal('SCROLLS'), z.literal('FIXED'), z.literal('STICKY_SCROLLS')]);

export const rectangleSchema = z.object({
  x: z.number(),
  y: z.number(),
  width: z.number(),
  height: z.number(),
});

export const layoutConstraintSchema = z.object({
  vertical: z.union([
    z.literal('TOP'),
    z.literal('BOTTOM'),
    z.literal('CENTER'),
    z.literal('TOP_BOTTOM'),
    z.literal('SCALE'),
  ]),
  horizontal: z.union([
    z.literal('LEFT'),
    z.literal('RIGHT'),
    z.literal('CENTER'),
    z.literal('LEFT_RIGHT'),
    z.literal('SCALE'),
  ]),
});

export const transformSchema = z.tuple([
  z.tuple([z.number(), z.number(), z.number()]),
  z.tuple([z.number(), z.number(), z.number()]),
]);

export const vectorSchema = z.object({
  x: z.number(),
  y: z.number(),
});

export const layoutAlignSchema = z.union([
  z.literal('INHERIT'),
  z.literal('STRETCH'),
  z.literal('MIN'),
  z.literal('CENTER'),
  z.literal('MAX'),
]);

export const layoutGrowSchema = z.union([z.literal(0), z.literal(1)]);

export const layoutPositioningSchema = z.union([z.literal('AUTO'), z.literal('ABSOLUTE')]);

export const layoutSizingHorizontalSchema = z.union([z.literal('FIXED'), z.literal('HUG'), z.literal('FILL')]);

export const layoutSizingVerticalSchema = z.union([z.literal('FIXED'), z.literal('HUG'), z.literal('FILL')]);

export const rgbaSchema = z.object({
  r: z.number(),
  g: z.number(),
  b: z.number(),
  a: z.number(),
});

export const layoutGridSchema = z.object({
  pattern: z.union([z.literal('COLUMNS'), z.literal('ROWS'), z.literal('GRID')]),
  sectionSize: z.number(),
  visible: z.boolean(),
  color: rgbaSchema,
  alignment: z.union([z.literal('MIN'), z.literal('MAX'), z.literal('STRETCH'), z.literal('CENTER')]),
  gutterSize: z.number(),
  offset: z.number(),
  count: z.number(),
  boundVariables: z
    .object({
      gutterSize: variableAliasSchema.optional(),
      numSections: variableAliasSchema.optional(),
      sectionSize: variableAliasSchema.optional(),
      offset: variableAliasSchema.optional(),
    })
    .optional(),
});

export const overflowDirectionSchema = z.union([
  z.literal('HORIZONTAL_SCROLLING'),
  z.literal('VERTICAL_SCROLLING'),
  z.literal('HORIZONTAL_AND_VERTICAL_SCROLLING'),
  z.literal('NONE'),
]);

export const layoutModeSchema = z.union([z.literal('NONE'), z.literal('HORIZONTAL'), z.literal('VERTICAL')]);

export const primaryAxisSizingModeSchema = z.union([z.literal('FIXED'), z.literal('AUTO')]);

export const counterAxisSizingModeSchema = z.union([z.literal('FIXED'), z.literal('AUTO')]);

export const primaryAxisAlignItemsSchema = z.union([
  z.literal('MIN'),
  z.literal('CENTER'),
  z.literal('MAX'),
  z.literal('SPACE_BETWEEN'),
]);

export const counterAxisAlignItemsSchema = z.union([
  z.literal('MIN'),
  z.literal('CENTER'),
  z.literal('MAX'),
  z.literal('BASELINE'),
]);

export const layoutWrapSchema = z.union([z.literal('NO_WRAP'), z.literal('WRAP')]);

export const counterAxisAlignContentSchema = z.union([z.literal('AUTO'), z.literal('SPACE_BETWEEN')]);

export const blendModeSchema = z.union([
  z.literal('PASS_THROUGH'),
  z.literal('NORMAL'),
  z.literal('DARKEN'),
  z.literal('MULTIPLY'),
  z.literal('LINEAR_BURN'),
  z.literal('COLOR_BURN'),
  z.literal('LIGHTEN'),
  z.literal('SCREEN'),
  z.literal('LINEAR_DODGE'),
  z.literal('COLOR_DODGE'),
  z.literal('OVERLAY'),
  z.literal('SOFT_LIGHT'),
  z.literal('HARD_LIGHT'),
  z.literal('DIFFERENCE'),
  z.literal('EXCLUSION'),
  z.literal('HUE'),
  z.literal('SATURATION'),
  z.literal('COLOR'),
  z.literal('LUMINOSITY'),
]);

export const pathSchema = z.object({
  path: z.string(),
  windingRule: z.union([z.literal('NONZERO'), z.literal('EVENODD')]),
  overrideID: z.number().optional(),
});

export const strokeCapSchema = z.union([
  z.literal('NONE'),
  z.literal('ROUND'),
  z.literal('SQUARE'),
  z.literal('LINE_ARROW'),
  z.literal('TRIANGLE_ARROW'),
  z.literal('DIAMOND_FILLED'),
  z.literal('CIRCLE_FILLED'),
  z.literal('TRIANGLE_FILLED'),
  z.literal('WASHI_TAPE_1'),
  z.literal('WASHI_TAPE_2'),
  z.literal('WASHI_TAPE_3'),
  z.literal('WASHI_TAPE_4'),
  z.literal('WASHI_TAPE_5'),
  z.literal('WASHI_TAPE_6'),
]);

export const strokeAlignSchema = z.union([z.literal('INSIDE'), z.literal('OUTSIDE'), z.literal('CENTER')]);

export const strokeJoinSchema = z.union([z.literal('MITER'), z.literal('BEVEL'), z.literal('ROUND')]);

export const strokeWeightsSchema = z.object({
  top: z.number(),
  right: z.number(),
  bottom: z.number(),
  left: z.number(),
});

export const cornerTraitSchema = z.object({
  cornerRadius: z.number().optional(),
  cornerSmoothing: z.number().optional(),
  rectangleCornerRadii: z.tuple([z.number(), z.number(), z.number(), z.number()]).optional(),
});

export const hasMaskTraitSchema = z.object({
  isMask: z.boolean().optional(),
  maskType: z.union([z.literal('ALPHA'), z.literal('VECTOR'), z.literal('LUMINANCE')]).optional(),
  isMaskOutline: z.boolean().optional(),
});

export const maskTypeSchema = z.union([z.literal('ALPHA'), z.literal('VECTOR'), z.literal('LUMINANCE')]);

export const hasTextSublayerTraitSchema = z.object({
  characters: z.string(),
});

export const easingTypeSchema = z.union([
  z.literal('EASE_IN'),
  z.literal('EASE_OUT'),
  z.literal('EASE_IN_AND_OUT'),
  z.literal('LINEAR'),
  z.literal('EASE_IN_BACK'),
  z.literal('EASE_OUT_BACK'),
  z.literal('EASE_IN_AND_OUT_BACK'),
  z.literal('CUSTOM_CUBIC_BEZIER'),
  z.literal('GENTLE'),
  z.literal('QUICK'),
  z.literal('BOUNCY'),
  z.literal('SLOW'),
  z.literal('CUSTOM_SPRING'),
]);

export const devStatusTraitSchema = z.object({
  devStatus: z
    .object({
      type: z.union([z.literal('NONE'), z.literal('READY_FOR_DEV'), z.literal('COMPLETED')]),
      description: z.string().optional(),
    })
    .optional(),
});

export const typeSchema = z.union([z.literal('NONE'), z.literal('READY_FOR_DEV'), z.literal('COMPLETED')]);

export const isLayerTraitSchema = z.object({
  id: z.string(),
  name: z.string(),
  type: z.string(),
  visible: z.boolean().optional(),
  locked: z.boolean().optional(),
  isFixed: z.boolean().optional(),
  scrollBehavior: z.union([z.literal('SCROLLS'), z.literal('FIXED'), z.literal('STICKY_SCROLLS')]),
  rotation: z.number().optional(),
  componentPropertyReferences: z.record(z.string()).optional(),
  pluginData: z.unknown().optional(),
  sharedPluginData: z.unknown().optional(),
  boundVariables: z
    .object({
      size: z
        .object({
          x: variableAliasSchema.optional(),
          y: variableAliasSchema.optional(),
        })
        .optional(),
      individualStrokeWeights: z
        .object({
          top: variableAliasSchema.optional(),
          bottom: variableAliasSchema.optional(),
          left: variableAliasSchema.optional(),
          right: variableAliasSchema.optional(),
        })
        .optional(),
      characters: variableAliasSchema.optional(),
      itemSpacing: variableAliasSchema.optional(),
      paddingLeft: variableAliasSchema.optional(),
      paddingRight: variableAliasSchema.optional(),
      paddingTop: variableAliasSchema.optional(),
      paddingBottom: variableAliasSchema.optional(),
      visible: variableAliasSchema.optional(),
      topLeftRadius: variableAliasSchema.optional(),
      topRightRadius: variableAliasSchema.optional(),
      bottomLeftRadius: variableAliasSchema.optional(),
      bottomRightRadius: variableAliasSchema.optional(),
      minWidth: variableAliasSchema.optional(),
      maxWidth: variableAliasSchema.optional(),
      minHeight: variableAliasSchema.optional(),
      maxHeight: variableAliasSchema.optional(),
      counterAxisSpacing: variableAliasSchema.optional(),
      opacity: variableAliasSchema.optional(),
      fontFamily: z.array(variableAliasSchema).optional(),
      fontSize: z.array(variableAliasSchema).optional(),
      fontStyle: z.array(variableAliasSchema).optional(),
      fontWeight: z.array(variableAliasSchema).optional(),
      letterSpacing: z.array(variableAliasSchema).optional(),
      lineHeight: z.array(variableAliasSchema).optional(),
      paragraphSpacing: z.array(variableAliasSchema).optional(),
      paragraphIndent: z.array(variableAliasSchema).optional(),
      fills: z.array(variableAliasSchema).optional(),
      strokes: z.array(variableAliasSchema).optional(),
      componentProperties: z.record(variableAliasSchema).optional(),
      textRangeFills: z.array(variableAliasSchema).optional(),
      effects: z.array(variableAliasSchema).optional(),
      layoutGrids: z.array(variableAliasSchema).optional(),
    })
    .optional(),
  explicitVariableModes: z.record(z.string()).optional(),
});

export const hasBlendModeAndOpacityTraitSchema = z.object({
  blendMode: blendModeSchema,
  opacity: z.number().optional(),
});

export const hasLayoutTraitSchema = z.object({
  absoluteBoundingBox: rectangleSchema.nullable(),
  absoluteRenderBounds: rectangleSchema.nullable(),
  preserveRatio: z.boolean().optional(),
  constraints: layoutConstraintSchema.optional(),
  relativeTransform: transformSchema.optional(),
  size: vectorSchema.optional(),
  layoutAlign: z
    .union([z.literal('INHERIT'), z.literal('STRETCH'), z.literal('MIN'), z.literal('CENTER'), z.literal('MAX')])
    .optional(),
  layoutGrow: z.union([z.literal(0), z.literal(1)]).optional(),
  layoutPositioning: z.union([z.literal('AUTO'), z.literal('ABSOLUTE')]).optional(),
  minWidth: z.number().optional(),
  maxWidth: z.number().optional(),
  minHeight: z.number().optional(),
  maxHeight: z.number().optional(),
  layoutSizingHorizontal: z.union([z.literal('FIXED'), z.literal('HUG'), z.literal('FILL')]).optional(),
  layoutSizingVertical: z.union([z.literal('FIXED'), z.literal('HUG'), z.literal('FILL')]).optional(),
});

export const individualStrokesTraitSchema = z.object({
  individualStrokeWeights: strokeWeightsSchema.optional(),
});

export const sliceNodeSchema = z
  .object({
    type: z.literal('SLICE'),
  })
  .and(isLayerTraitSchema);

export const type2Schema = z.literal('DOCUMENT');

export const flowStartingPointSchema = z.object({
  nodeId: z.string(),
  name: z.string(),
});

export const type3Schema = z.literal('CANVAS');

export const type4Schema = z.literal('BOOLEAN_OPERATION');

export const booleanOperationSchema = z.union([
  z.literal('UNION'),
  z.literal('INTERSECT'),
  z.literal('SUBTRACT'),
  z.literal('EXCLUDE'),
]);

export const type5Schema = z.literal('SECTION');

export const type6Schema = z.literal('FRAME');

export const type7Schema = z.literal('GROUP');

export const type8Schema = z.literal('COMPONENT');

export const type9Schema = z.literal('COMPONENT_SET');

export const type10Schema = z.literal('VECTOR');

export const type11Schema = z.literal('STAR');

export const type12Schema = z.literal('LINE');

export const arcDataSchema = z.object({
  startingAngle: z.number(),
  endingAngle: z.number(),
  innerRadius: z.number(),
});

export const type13Schema = z.literal('ELLIPSE');

export const type14Schema = z.literal('REGULAR_POLYGON');

export const type15Schema = z.literal('RECTANGLE');

export const type16Schema = z.literal('TEXT');

export const type17Schema = z.literal('TABLE');

export const type18Schema = z.literal('TABLE_CELL');

export const type19Schema = z.literal('SLICE');

export const overridesSchema = z.object({
  id: z.string(),
  overriddenFields: z.array(z.string()),
});

export const type20Schema = z.literal('INSTANCE');

export const type21Schema = z.literal('EMBED');

export const type22Schema = z.literal('LINK_UNFURL');

export const type23Schema = z.literal('STICKY');

export const shapeTypeSchema = z.union([
  z.literal('SQUARE'),
  z.literal('ELLIPSE'),
  z.literal('ROUNDED_RECTANGLE'),
  z.literal('DIAMOND'),
  z.literal('TRIANGLE_UP'),
  z.literal('TRIANGLE_DOWN'),
  z.literal('PARALLELOGRAM_RIGHT'),
  z.literal('PARALLELOGRAM_LEFT'),
  z.literal('ENG_DATABASE'),
  z.literal('ENG_QUEUE'),
  z.literal('ENG_FILE'),
  z.literal('ENG_FOLDER'),
  z.literal('TRAPEZOID'),
  z.literal('PREDEFINED_PROCESS'),
  z.literal('SHIELD'),
  z.literal('DOCUMENT_SINGLE'),
  z.literal('DOCUMENT_MULTIPLE'),
  z.literal('MANUAL_INPUT'),
  z.literal('HEXAGON'),
  z.literal('CHEVRON'),
  z.literal('PENTAGON'),
  z.literal('OCTAGON'),
  z.literal('STAR'),
  z.literal('PLUS'),
  z.literal('ARROW_LEFT'),
  z.literal('ARROW_RIGHT'),
  z.literal('SUMMING_JUNCTION'),
  z.literal('OR'),
  z.literal('SPEECH_BUBBLE'),
  z.literal('INTERNAL_STORAGE'),
]);

export const type24Schema = z.literal('SHAPE_WITH_TEXT');

export const connectorEndpointSchema = z.union([
  z.object({
    endpointNodeId: z.string().optional(),
    position: vectorSchema.optional(),
  }),
  z.object({
    endpointNodeId: z.string().optional(),
    magnet: z
      .union([
        z.literal('AUTO'),
        z.literal('TOP'),
        z.literal('BOTTOM'),
        z.literal('LEFT'),
        z.literal('RIGHT'),
        z.literal('CENTER'),
      ])
      .optional(),
  }),
]);

export const connectorLineTypeSchema = z.union([z.literal('STRAIGHT'), z.literal('ELBOWED')]);

export const type25Schema = z.literal('CONNECTOR');

export const connectorStartStrokeCapSchema = z.union([
  z.literal('NONE'),
  z.literal('LINE_ARROW'),
  z.literal('TRIANGLE_ARROW'),
  z.literal('DIAMOND_FILLED'),
  z.literal('CIRCLE_FILLED'),
  z.literal('TRIANGLE_FILLED'),
]);

export const connectorEndStrokeCapSchema = z.union([
  z.literal('NONE'),
  z.literal('LINE_ARROW'),
  z.literal('TRIANGLE_ARROW'),
  z.literal('DIAMOND_FILLED'),
  z.literal('CIRCLE_FILLED'),
  z.literal('TRIANGLE_FILLED'),
]);

export const type26Schema = z.literal('WASHI_TAPE');

export const type27Schema = z.literal('WIDGET');

export const rgbSchema = z.object({
  r: z.number(),
  g: z.number(),
  b: z.number(),
});

export const sizeSchema = z.object({
  width: z.number(),
  height: z.number(),
});

export const prototypeDeviceSchema = z.object({
  type: z.union([z.literal('NONE'), z.literal('PRESET'), z.literal('CUSTOM'), z.literal('PRESENTATION')]),
  size: sizeSchema.optional(),
  presetIdentifier: z.string().optional(),
  rotation: z.union([z.literal('NONE'), z.literal('CCW_90')]),
});

export const type28Schema = z.union([
  z.literal('NONE'),
  z.literal('PRESET'),
  z.literal('CUSTOM'),
  z.literal('PRESENTATION'),
]);

export const rotationSchema = z.union([z.literal('NONE'), z.literal('CCW_90')]);

export const constraintSchema = z.object({
  type: z.union([z.literal('SCALE'), z.literal('WIDTH'), z.literal('HEIGHT')]),
  value: z.number(),
});

export const type29Schema = z.union([z.literal('SCALE'), z.literal('WIDTH'), z.literal('HEIGHT')]);

export const exportSettingSchema = z.object({
  suffix: z.string(),
  format: z.union([z.literal('JPG'), z.literal('PNG'), z.literal('SVG'), z.literal('PDF')]),
  constraint: constraintSchema,
});

export const formatSchema = z.union([z.literal('JPG'), z.literal('PNG'), z.literal('SVG'), z.literal('PDF')]);

export const colorStopSchema = z.object({
  position: z.number(),
  color: rgbaSchema,
  boundVariables: z
    .object({
      color: variableAliasSchema.optional(),
    })
    .optional(),
});

export const imageFiltersSchema = z.object({
  exposure: z.number().optional(),
  contrast: z.number().optional(),
  saturation: z.number().optional(),
  temperature: z.number().optional(),
  tint: z.number().optional(),
  highlights: z.number().optional(),
  shadows: z.number().optional(),
});

export const basePaintSchema = z.object({
  visible: z.boolean().optional(),
  opacity: z.number().optional(),
  blendMode: blendModeSchema,
});

export const solidPaintSchema = z
  .object({
    type: z.literal('SOLID'),
    color: rgbaSchema,
    boundVariables: z
      .object({
        color: variableAliasSchema.optional(),
      })
      .optional(),
  })
  .and(basePaintSchema);

export const type30Schema = z.literal('SOLID');

export const gradientPaintSchema = z
  .object({
    type: z.union([
      z.literal('GRADIENT_LINEAR'),
      z.literal('GRADIENT_RADIAL'),
      z.literal('GRADIENT_ANGULAR'),
      z.literal('GRADIENT_DIAMOND'),
    ]),
    gradientHandlePositions: z.array(vectorSchema),
    gradientStops: z.array(colorStopSchema),
  })
  .and(basePaintSchema);

export const type31Schema = z.union([
  z.literal('GRADIENT_LINEAR'),
  z.literal('GRADIENT_RADIAL'),
  z.literal('GRADIENT_ANGULAR'),
  z.literal('GRADIENT_DIAMOND'),
]);

export const imagePaintSchema = z
  .object({
    type: z.literal('IMAGE'),
    scaleMode: z.union([z.literal('FILL'), z.literal('FIT'), z.literal('TILE'), z.literal('STRETCH')]),
    imageRef: z.string(),
    imageTransform: transformSchema.optional(),
    scalingFactor: z.number().optional(),
    filters: imageFiltersSchema.optional(),
    rotation: z.number().optional(),
    gifRef: z.string().optional(),
  })
  .and(basePaintSchema);

export const type32Schema = z.literal('IMAGE');

export const scaleModeSchema = z.union([z.literal('FILL'), z.literal('FIT'), z.literal('TILE'), z.literal('STRETCH')]);

export const paintSchema = z.union([solidPaintSchema, gradientPaintSchema, imagePaintSchema]);

export const verticalSchema = z.union([
  z.literal('TOP'),
  z.literal('BOTTOM'),
  z.literal('CENTER'),
  z.literal('TOP_BOTTOM'),
  z.literal('SCALE'),
]);

export const horizontalSchema = z.union([
  z.literal('LEFT'),
  z.literal('RIGHT'),
  z.literal('CENTER'),
  z.literal('LEFT_RIGHT'),
  z.literal('SCALE'),
]);

export const patternSchema = z.union([z.literal('COLUMNS'), z.literal('ROWS'), z.literal('GRID')]);

export const alignmentSchema = z.union([z.literal('MIN'), z.literal('MAX'), z.literal('STRETCH'), z.literal('CENTER')]);

export const baseShadowEffectSchema = z.object({
  color: rgbaSchema,
  blendMode: blendModeSchema,
  offset: vectorSchema,
  radius: z.number(),
  spread: z.number().optional(),
  visible: z.boolean(),
  boundVariables: z
    .object({
      radius: variableAliasSchema.optional(),
      spread: variableAliasSchema.optional(),
      color: variableAliasSchema.optional(),
      offsetX: variableAliasSchema.optional(),
      offsetY: variableAliasSchema.optional(),
    })
    .optional(),
});

export const dropShadowEffectSchema = z
  .object({
    type: z.literal('DROP_SHADOW'),
    showShadowBehindNode: z.boolean(),
  })
  .and(baseShadowEffectSchema);

export const type33Schema = z.literal('DROP_SHADOW');

export const innerShadowEffectSchema = z
  .object({
    type: z.literal('INNER_SHADOW').optional(),
  })
  .and(baseShadowEffectSchema);

export const type34Schema = z.literal('INNER_SHADOW');

export const blurEffectSchema = z.object({
  type: z.literal('BACKGROUND_BLUR'),
  visible: z.boolean(),
  radius: z.number(),
  boundVariables: z
    .object({
      radius: variableAliasSchema.optional(),
    })
    .optional(),
});

export const effectSchema = z.union([dropShadowEffectSchema, innerShadowEffectSchema, blurEffectSchema]);

export const styleTypeSchema = z.union([z.literal('FILL'), z.literal('TEXT'), z.literal('EFFECT'), z.literal('GRID')]);

export const paintOverrideSchema = z.object({
  fills: z.array(paintSchema).optional(),
  inheritFillStyleId: z.string().optional(),
});

export const windingRuleSchema = z.union([z.literal('NONZERO'), z.literal('EVENODD')]);

export const hyperlinkSchema = z.object({
  type: z.union([z.literal('URL'), z.literal('NODE')]),
  url: z.string().optional(),
  nodeID: z.string().optional(),
});

export const type35Schema = z.union([z.literal('URL'), z.literal('NODE')]);

export const typeStyleSchema = z.object({
  fontFamily: z.string().optional(),
  fontPostScriptName: z.string().optional().nullable(),
  paragraphSpacing: z.number().optional(),
  paragraphIndent: z.number().optional(),
  listSpacing: z.number().optional(),
  italic: z.boolean().optional(),
  fontWeight: z.number().optional(),
  fontSize: z.number().optional(),
  textCase: z
    .union([
      z.literal('UPPER'),
      z.literal('LOWER'),
      z.literal('TITLE'),
      z.literal('SMALL_CAPS'),
      z.literal('SMALL_CAPS_FORCED'),
    ])
    .optional(),
  textDecoration: z.union([z.literal('NONE'), z.literal('STRIKETHROUGH'), z.literal('UNDERLINE')]).optional(),
  textAutoResize: z
    .union([z.literal('NONE'), z.literal('WIDTH_AND_HEIGHT'), z.literal('HEIGHT'), z.literal('TRUNCATE')])
    .optional(),
  textTruncation: z.union([z.literal('DISABLED'), z.literal('ENDING')]).optional(),
  maxLines: z.number().optional(),
  textAlignHorizontal: z
    .union([z.literal('LEFT'), z.literal('RIGHT'), z.literal('CENTER'), z.literal('JUSTIFIED')])
    .optional(),
  textAlignVertical: z.union([z.literal('TOP'), z.literal('CENTER'), z.literal('BOTTOM')]).optional(),
  letterSpacing: z.number().optional(),
  fills: z.array(paintSchema).optional(),
  hyperlink: hyperlinkSchema.optional(),
  opentypeFlags: z.record(z.number()).optional(),
  lineHeightPx: z.number().optional(),
  lineHeightPercent: z.number().optional(),
  lineHeightPercentFontSize: z.number().optional(),
  lineHeightUnit: z.union([z.literal('PIXELS'), z.literal('FONT_SIZE_%'), z.literal('INTRINSIC_%')]).optional(),
  boundVariables: z
    .object({
      fontFamily: variableAliasSchema.optional(),
      fontSize: variableAliasSchema.optional(),
      fontStyle: variableAliasSchema.optional(),
      fontWeight: variableAliasSchema.optional(),
      letterSpacing: variableAliasSchema.optional(),
      lineHeight: variableAliasSchema.optional(),
      paragraphSpacing: variableAliasSchema.optional(),
      paragraphIndent: variableAliasSchema.optional(),
    })
    .optional(),
  isOverrideOverTextStyle: z.boolean().optional(),
  semanticWeight: z.union([z.literal('BOLD'), z.literal('NORMAL')]).optional(),
  semanticItalic: z.union([z.literal('ITALIC'), z.literal('NORMAL')]).optional(),
});

export const textCaseSchema = z.union([
  z.literal('UPPER'),
  z.literal('LOWER'),
  z.literal('TITLE'),
  z.literal('SMALL_CAPS'),
  z.literal('SMALL_CAPS_FORCED'),
]);

export const textDecorationSchema = z.union([z.literal('NONE'), z.literal('STRIKETHROUGH'), z.literal('UNDERLINE')]);

export const textAutoResizeSchema = z.union([
  z.literal('NONE'),
  z.literal('WIDTH_AND_HEIGHT'),
  z.literal('HEIGHT'),
  z.literal('TRUNCATE'),
]);

export const textTruncationSchema = z.union([z.literal('DISABLED'), z.literal('ENDING')]);

export const textAlignHorizontalSchema = z.union([
  z.literal('LEFT'),
  z.literal('RIGHT'),
  z.literal('CENTER'),
  z.literal('JUSTIFIED'),
]);

export const textAlignVerticalSchema = z.union([z.literal('TOP'), z.literal('CENTER'), z.literal('BOTTOM')]);

export const lineHeightUnitSchema = z.union([z.literal('PIXELS'), z.literal('FONT_SIZE_%'), z.literal('INTRINSIC_%')]);

export const semanticWeightSchema = z.union([z.literal('BOLD'), z.literal('NORMAL')]);

export const semanticItalicSchema = z.union([z.literal('ITALIC'), z.literal('NORMAL')]);

export const componentPropertyTypeSchema = z.union([
  z.literal('BOOLEAN'),
  z.literal('INSTANCE_SWAP'),
  z.literal('TEXT'),
  z.literal('VARIANT'),
]);

export const instanceSwapPreferredValueSchema = z.object({
  type: z.union([z.literal('COMPONENT'), z.literal('COMPONENT_SET')]),
  key: z.string(),
});

export const type36Schema = z.union([z.literal('COMPONENT'), z.literal('COMPONENT_SET')]);

export const componentPropertyDefinitionSchema = z.object({
  type: componentPropertyTypeSchema,
  defaultValue: z.union([z.boolean(), z.string()]),
  variantOptions: z.array(z.string()).optional(),
  preferredValues: z.array(instanceSwapPreferredValueSchema).optional(),
});

export const componentPropertySchema = z.object({
  type: componentPropertyTypeSchema,
  value: z.union([z.boolean(), z.string()]),
  preferredValues: z.array(instanceSwapPreferredValueSchema).optional(),
  boundVariables: z
    .object({
      value: variableAliasSchema.optional(),
    })
    .optional(),
});

export const magnetSchema = z.union([
  z.literal('AUTO'),
  z.literal('TOP'),
  z.literal('BOTTOM'),
  z.literal('LEFT'),
  z.literal('RIGHT'),
  z.literal('CENTER'),
]);

export const minimalFillsTraitSchema = z.object({
  fills: z.array(paintSchema),
  styles: z.record(z.string()).optional(),
});

export const documentationLinkSchema = z.object({
  uri: z.string(),
});

export const componentSetSchema = z.object({
  key: z.string(),
  name: z.string(),
  description: z.string(),
  documentationLinks: z.array(documentationLinkSchema).optional(),
  remote: z.boolean().optional(),
});

export const type37Schema = z.literal('VARIABLE_ALIAS');

export const afterTimeoutTriggerSchema = z.object({
  type: z.literal('AFTER_TIMEOUT'),
  timeout: z.number(),
});

export const onKeyDownTriggerSchema = z.object({
  type: z.literal('ON_KEY_DOWN'),
  device: z.union([
    z.literal('KEYBOARD'),
    z.literal('XBOX_ONE'),
    z.literal('PS4'),
    z.literal('SWITCH_PRO'),
    z.literal('UNKNOWN_CONTROLLER'),
  ]),
  keyCodes: z.array(z.number()),
});

export const onMediaHitTriggerSchema = z.object({
  type: z.literal('ON_MEDIA_HIT'),
  mediaHitTime: z.number(),
});

export const type38Schema = z.union([
  z.literal('ON_CLICK'),
  z.literal('ON_HOVER'),
  z.literal('ON_PRESS'),
  z.literal('ON_DRAG'),
]);

export const type39Schema = z.literal('AFTER_TIMEOUT');

export const type40Schema = z.literal('ON_KEY_DOWN');

export const deviceSchema = z.union([
  z.literal('KEYBOARD'),
  z.literal('XBOX_ONE'),
  z.literal('PS4'),
  z.literal('SWITCH_PRO'),
  z.literal('UNKNOWN_CONTROLLER'),
]);

export const type41Schema = z.literal('ON_MEDIA_HIT');

export const openURLActionSchema = z.object({
  type: z.literal('URL'),
  url: z.string(),
});

export const updateMediaRuntimeActionSchema = z.union([
  z.object({
    type: z.literal('UPDATE_MEDIA_RUNTIME'),
    destinationId: z.string().nullable(),
    mediaAction: z.union([
      z.literal('PLAY'),
      z.literal('PAUSE'),
      z.literal('TOGGLE_PLAY_PAUSE'),
      z.literal('MUTE'),
      z.literal('UNMUTE'),
      z.literal('TOGGLE_MUTE_UNMUTE'),
    ]),
  }),
  z.object({
    type: z.literal('UPDATE_MEDIA_RUNTIME'),
    destinationId: z.string().optional().nullable(),
    mediaAction: z.union([z.literal('SKIP_FORWARD'), z.literal('SKIP_BACKWARD')]),
    amountToSkip: z.number(),
  }),
  z.object({
    type: z.literal('UPDATE_MEDIA_RUNTIME'),
    destinationId: z.string().optional().nullable(),
    mediaAction: z.literal('SKIP_TO'),
    newTimestamp: z.number(),
  }),
]);

export const setVariableModeActionSchema = z.object({
  type: z.literal('SET_VARIABLE_MODE'),
  variableCollectionId: z.string().optional().nullable(),
  variableModeId: z.string().optional().nullable(),
});

export const type42Schema = z.union([z.literal('BACK'), z.literal('CLOSE')]);

export const type43Schema = z.literal('URL');

export const type44Schema = z.literal('UPDATE_MEDIA_RUNTIME');

export const mediaActionSchema = z.union([
  z.literal('PLAY'),
  z.literal('PAUSE'),
  z.literal('TOGGLE_PLAY_PAUSE'),
  z.literal('MUTE'),
  z.literal('UNMUTE'),
  z.literal('TOGGLE_MUTE_UNMUTE'),
]);

export const navigationSchema = z.union([
  z.literal('NAVIGATE'),
  z.literal('SWAP'),
  z.literal('OVERLAY'),
  z.literal('SCROLL_TO'),
  z.literal('CHANGE_TO'),
]);

export const type45Schema = z.literal('NODE');

export const easingSchema = z.object({
  type: easingTypeSchema,
  easingFunctionCubicBezier: z
    .object({
      x1: z.number(),
      y1: z.number(),
      x2: z.number(),
      y2: z.number(),
    })
    .optional(),
  easingFunctionSpring: z
    .object({
      mass: z.number(),
      stiffness: z.number(),
      damping: z.number(),
    })
    .optional(),
});

export const type46Schema = z.union([z.literal('DISSOLVE'), z.literal('SMART_ANIMATE'), z.literal('SCROLL_ANIMATE')]);

export const directionalTransitionSchema = z.object({
  type: z.union([
    z.literal('MOVE_IN'),
    z.literal('MOVE_OUT'),
    z.literal('PUSH'),
    z.literal('SLIDE_IN'),
    z.literal('SLIDE_OUT'),
  ]),
  direction: z.union([z.literal('LEFT'), z.literal('RIGHT'), z.literal('TOP'), z.literal('BOTTOM')]),
  duration: z.number(),
  easing: easingSchema,
  matchLayers: z.boolean().optional(),
});

export const type47Schema = z.union([
  z.literal('MOVE_IN'),
  z.literal('MOVE_OUT'),
  z.literal('PUSH'),
  z.literal('SLIDE_IN'),
  z.literal('SLIDE_OUT'),
]);

export const directionSchema = z.union([z.literal('LEFT'), z.literal('RIGHT'), z.literal('TOP'), z.literal('BOTTOM')]);

export const type48Schema = z.literal('SET_VARIABLE');

export const type49Schema = z.literal('SET_VARIABLE_MODE');

export const type50Schema = z.literal('CONDITIONAL');

export const variableDataTypeSchema = z.union([
  z.literal('BOOLEAN'),
  z.literal('FLOAT'),
  z.literal('STRING'),
  z.literal('COLOR'),
  z.literal('VARIABLE_ALIAS'),
  z.literal('EXPRESSION'),
]);

export const variableResolvedDataTypeSchema = z.union([
  z.literal('BOOLEAN'),
  z.literal('FLOAT'),
  z.literal('STRING'),
  z.literal('COLOR'),
]);

export const expressionFunctionSchema = z.union([
  z.literal('ADDITION'),
  z.literal('SUBTRACTION'),
  z.literal('MULTIPLICATION'),
  z.literal('DIVISION'),
  z.literal('EQUALS'),
  z.literal('NOT_EQUAL'),
  z.literal('LESS_THAN'),
  z.literal('LESS_THAN_OR_EQUAL'),
  z.literal('GREATER_THAN'),
  z.literal('GREATER_THAN_OR_EQUAL'),
  z.literal('AND'),
  z.literal('OR'),
  z.literal('VAR_MODE_LOOKUP'),
  z.literal('NEGATE'),
  z.literal('NOT'),
]);

export const frameOffsetSchema = z.object({
  node_id: z.string(),
  node_offset: vectorSchema,
});

export const regionSchema = z.object({
  x: z.number(),
  y: z.number(),
  region_height: z.number(),
  region_width: z.number(),
  comment_pin_corner: z
    .union([z.literal('top-left'), z.literal('top-right'), z.literal('bottom-left'), z.literal('bottom-right')])
    .optional(),
});

export const commentPinCornerSchema = z.union([
  z.literal('top-left'),
  z.literal('top-right'),
  z.literal('bottom-left'),
  z.literal('bottom-right'),
]);

export const frameOffsetRegionSchema = z.object({
  node_id: z.string(),
  node_offset: vectorSchema,
  region_height: z.number(),
  region_width: z.number(),
  comment_pin_corner: z
    .union([z.literal('top-left'), z.literal('top-right'), z.literal('bottom-left'), z.literal('bottom-right')])
    .optional(),
});

export const userSchema = z.object({
  id: z.string(),
  handle: z.string(),
  img_url: z.string(),
});

export const emojiSchema = z.string();

export const frameInfoSchema = z.object({
  nodeId: z.string().optional(),
  name: z.string().optional(),
  backgroundColor: z.string().optional(),
  pageId: z.string(),
  pageName: z.string(),
});

export const publishedComponentSchema = z.object({
  key: z.string(),
  file_key: z.string(),
  node_id: z.string(),
  thumbnail_url: z.string().optional(),
  name: z.string(),
  description: z.string(),
  created_at: z.string(),
  updated_at: z.string(),
  user: userSchema,
  containing_frame: frameInfoSchema.optional(),
});

export const publishedComponentSetSchema = z.object({
  key: z.string(),
  file_key: z.string(),
  node_id: z.string(),
  thumbnail_url: z.string().optional(),
  name: z.string(),
  description: z.string(),
  created_at: z.string(),
  updated_at: z.string(),
  user: userSchema,
  containing_frame: frameInfoSchema.optional(),
});

export const publishedStyleSchema = z.object({
  key: z.string(),
  file_key: z.string(),
  node_id: z.string(),
  style_type: styleTypeSchema,
  thumbnail_url: z.string().optional(),
  name: z.string(),
  description: z.string(),
  created_at: z.string(),
  updated_at: z.string(),
  user: userSchema,
  sort_position: z.string(),
});

export const projectSchema = z.object({
  id: z.string(),
  name: z.string(),
});

export const versionSchema = z.object({
  id: z.string(),
  created_at: z.string(),
  label: z.string().nullable(),
  description: z.string().nullable(),
  user: userSchema,
  thumbnail_url: z.string().optional(),
});

export const webhookV2EventSchema = z.union([
  z.literal('PING'),
  z.literal('FILE_UPDATE'),
  z.literal('FILE_VERSION_UPDATE'),
  z.literal('FILE_DELETE'),
  z.literal('LIBRARY_PUBLISH'),
  z.literal('FILE_COMMENT'),
]);

export const webhookV2StatusSchema = z.union([z.literal('ACTIVE'), z.literal('PAUSED')]);

export const webhookV2RequestInfoSchema = z.object({
  id: z.string(),
  endpoint: z.string(),
  payload: z.record(z.unknown()),
  sent_at: z.string(),
});

export const webhookV2ResponseInfoSchema = z
  .object({
    status: z.string(),
    received_at: z.string(),
  })
  .nullable();

export const libraryItemDataSchema = z.object({
  key: z.string(),
  name: z.string(),
});

export const commentFragmentSchema = z.object({
  text: z.string().optional(),
  mention: z.string().optional(),
});

export const webhookBasePayloadSchema = z.object({
  passcode: z.string(),
  timestamp: z.string(),
  webhook_id: z.string(),
});

export const webhookPingPayloadSchema = webhookBasePayloadSchema.and(
  z.object({
    event_type: z.literal('PING'),
  }),
);

export const eventTypeSchema = z.literal('PING');

export const webhookFileUpdatePayloadSchema = webhookBasePayloadSchema.and(
  z.object({
    event_type: z.literal('FILE_UPDATE'),
    file_key: z.string(),
    file_name: z.string(),
  }),
);

export const eventType2Schema = z.literal('FILE_UPDATE');

export const webhookFileDeletePayloadSchema = webhookBasePayloadSchema.and(
  z.object({
    event_type: z.literal('FILE_DELETE'),
    file_key: z.string(),
    file_name: z.string(),
    triggered_by: userSchema,
  }),
);

export const eventType3Schema = z.literal('FILE_DELETE');

export const webhookFileVersionUpdatePayloadSchema = webhookBasePayloadSchema.and(
  z.object({
    event_type: z.literal('FILE_VERSION_UPDATE'),
    created_at: z.string(),
    description: z.string().optional(),
    file_key: z.string(),
    file_name: z.string(),
    triggered_by: userSchema,
    version_id: z.string(),
  }),
);

export const eventType4Schema = z.literal('FILE_VERSION_UPDATE');

export const webhookLibraryPublishPayloadSchema = webhookBasePayloadSchema.and(
  z.object({
    event_type: z.literal('LIBRARY_PUBLISH'),
    created_components: z.array(libraryItemDataSchema),
    created_styles: z.array(libraryItemDataSchema),
    created_variables: z.array(libraryItemDataSchema),
    modified_components: z.array(libraryItemDataSchema),
    modified_styles: z.array(libraryItemDataSchema),
    modified_variables: z.array(libraryItemDataSchema),
    deleted_components: z.array(libraryItemDataSchema),
    deleted_styles: z.array(libraryItemDataSchema),
    deleted_variables: z.array(libraryItemDataSchema),
    description: z.string().optional(),
    file_key: z.string(),
    file_name: z.string(),
    library_item: libraryItemDataSchema,
    triggered_by: userSchema,
  }),
);

export const eventType5Schema = z.literal('LIBRARY_PUBLISH');

export const webhookFileCommentPayloadSchema = webhookBasePayloadSchema.and(
  z.object({
    event_type: z.literal('FILE_COMMENT'),
    comment: z.array(commentFragmentSchema),
    comment_id: z.string(),
    created_at: z.string(),
    file_key: z.string(),
    file_name: z.string(),
    mentions: z.array(userSchema).optional(),
    triggered_by: userSchema,
  }),
);

export const eventType6Schema = z.literal('FILE_COMMENT');

export const activityLogUserEntitySchema = z.object({
  type: z.literal('user'),
  id: z.string(),
  name: z.string(),
  email: z.string(),
});

export const type51Schema = z.literal('user');

export const activityLogFileEntitySchema = z.object({
  type: z.literal('file'),
  key: z.string(),
  name: z.string(),
  editor_type: z.union([z.literal('figma'), z.literal('figjam')]),
  link_access: z.union([
    z.literal('view'),
    z.literal('edit'),
    z.literal('org_view'),
    z.literal('org_edit'),
    z.literal('inherit'),
  ]),
  proto_link_access: z.union([z.literal('view'), z.literal('org_view'), z.literal('inherit')]),
});

export const type52Schema = z.literal('file');

export const editorTypeSchema = z.union([z.literal('figma'), z.literal('figjam')]);

export const linkAccessSchema = z.union([
  z.literal('view'),
  z.literal('edit'),
  z.literal('org_view'),
  z.literal('org_edit'),
  z.literal('inherit'),
]);

export const protoLinkAccessSchema = z.union([z.literal('view'), z.literal('org_view'), z.literal('inherit')]);

export const activityLogFileRepoEntitySchema = z.object({
  type: z.literal('file_repo'),
  id: z.string(),
  name: z.string(),
  main_file_key: z.string(),
});

export const type53Schema = z.literal('file_repo');

export const activityLogProjectEntitySchema = z.object({
  type: z.literal('project'),
  id: z.string(),
  name: z.string(),
});

export const type54Schema = z.literal('project');

export const activityLogTeamEntitySchema = z.object({
  type: z.literal('team'),
  id: z.string(),
  name: z.string(),
});

export const type55Schema = z.literal('team');

export const activityLogWorkspaceEntitySchema = z.object({
  type: z.literal('workspace'),
  id: z.string(),
  name: z.string(),
});

export const type56Schema = z.literal('workspace');

export const activityLogOrgEntitySchema = z.object({
  type: z.literal('org'),
  id: z.string(),
  name: z.string(),
});

export const type57Schema = z.literal('org');

export const activityLogPluginEntitySchema = z.object({
  type: z.literal('plugin'),
  id: z.string(),
  name: z.string(),
  editor_type: z.union([z.literal('figma'), z.literal('figjam')]),
});

export const type58Schema = z.literal('plugin');

export const activityLogWidgetEntitySchema = z.object({
  type: z.literal('widget'),
  id: z.string(),
  name: z.string(),
  editor_type: z.union([z.literal('figma'), z.literal('figjam')]),
});

export const type59Schema = z.literal('widget');

export const activityLogSchema = z.object({
  id: z.string(),
  timestamp: z.number(),
  actor: z
    .object({
      type: z.literal('user').optional(),
      id: z.string().optional(),
      name: z.string(),
      email: z.string().optional(),
    })
    .nullable(),
  action: z.object({
    type: z.string(),
    details: z.record(z.unknown()).nullable(),
  }),
  entity: z.union([
    activityLogUserEntitySchema,
    activityLogFileEntitySchema,
    activityLogFileRepoEntitySchema,
    activityLogProjectEntitySchema,
    activityLogTeamEntitySchema,
    activityLogWorkspaceEntitySchema,
    activityLogOrgEntitySchema,
    activityLogPluginEntitySchema,
    activityLogWidgetEntitySchema,
  ]),
  context: z.object({
    client_name: z.string().nullable(),
    ip_address: z.string(),
    is_figma_support_team_action: z.boolean(),
    org_id: z.string(),
    team_id: z.string().nullable(),
  }),
});

export const paymentStatusSchema = z.object({
  type: z.union([z.literal('UNPAID'), z.literal('PAID'), z.literal('TRIAL')]).optional(),
});

export const type60Schema = z.union([z.literal('UNPAID'), z.literal('PAID'), z.literal('TRIAL')]);

export const paymentInformationSchema = z.object({
  user_id: z.string(),
  resource_id: z.string(),
  resource_type: z.union([z.literal('PLUGIN'), z.literal('WIDGET'), z.literal('COMMUNITY_FILE')]),
  payment_status: paymentStatusSchema,
  date_of_purchase: z.string().optional(),
});

export const resourceTypeSchema = z.union([z.literal('PLUGIN'), z.literal('WIDGET'), z.literal('COMMUNITY_FILE')]);

export const variableScopeSchema = z.union([
  z.literal('ALL_SCOPES'),
  z.literal('TEXT_CONTENT'),
  z.literal('CORNER_RADIUS'),
  z.literal('WIDTH_HEIGHT'),
  z.literal('GAP'),
  z.literal('ALL_FILLS'),
  z.literal('FRAME_FILL'),
  z.literal('SHAPE_FILL'),
  z.literal('TEXT_FILL'),
  z.literal('STROKE_COLOR'),
  z.literal('STROKE_FLOAT'),
  z.literal('EFFECT_FLOAT'),
  z.literal('EFFECT_COLOR'),
  z.literal('OPACITY'),
  z.literal('FONT_FAMILY'),
  z.literal('FONT_STYLE'),
  z.literal('FONT_WEIGHT'),
  z.literal('FONT_SIZE'),
  z.literal('LINE_HEIGHT'),
  z.literal('LETTER_SPACING'),
  z.literal('PARAGRAPH_SPACING'),
  z.literal('PARAGRAPH_INDENT'),
]);

export const variableCodeSyntaxSchema = z.object({
  WEB: z.string().optional(),
  ANDROID: z.string().optional(),
  iOS: z.string().optional(),
});

export const localVariableCollectionSchema = z.object({
  id: z.string(),
  name: z.string(),
  key: z.string(),
  modes: z.array(
    z.object({
      modeId: z.string(),
      name: z.string(),
    }),
  ),
  defaultModeId: z.string(),
  remote: z.boolean(),
  hiddenFromPublishing: z.boolean(),
  variableIds: z.array(z.string()),
});

export const localVariableSchema = z.object({
  id: z.string(),
  name: z.string(),
  key: z.string(),
  variableCollectionId: z.string(),
  resolvedType: z.union([z.literal('BOOLEAN'), z.literal('FLOAT'), z.literal('STRING'), z.literal('COLOR')]),
  valuesByMode: z.record(z.union([z.boolean(), z.number(), z.string(), rgbaSchema, variableAliasSchema])),
  remote: z.boolean(),
  description: z.string(),
  hiddenFromPublishing: z.boolean(),
  scopes: z.array(variableScopeSchema),
  codeSyntax: variableCodeSyntaxSchema,
});

export const resolvedTypeSchema = z.union([
  z.literal('BOOLEAN'),
  z.literal('FLOAT'),
  z.literal('STRING'),
  z.literal('COLOR'),
]);

export const publishedVariableCollectionSchema = z.object({
  id: z.string(),
  subscribed_id: z.string(),
  name: z.string(),
  key: z.string(),
  updatedAt: z.string(),
});

export const publishedVariableSchema = z.object({
  id: z.string(),
  subscribed_id: z.string(),
  name: z.string(),
  key: z.string(),
  variableCollectionId: z.string(),
  resolvedDataType: z.union([z.literal('BOOLEAN'), z.literal('FLOAT'), z.literal('STRING'), z.literal('COLOR')]),
  updatedAt: z.string(),
});

export const resolvedDataTypeSchema = z.union([
  z.literal('BOOLEAN'),
  z.literal('FLOAT'),
  z.literal('STRING'),
  z.literal('COLOR'),
]);

export const variableCollectionCreateSchema = z.object({
  action: z.literal('CREATE'),
  id: z.string().optional(),
  name: z.string(),
  initialModeId: z.string().optional(),
  hiddenFromPublishing: z.boolean().optional(),
});

export const variableCollectionUpdateSchema = z.object({
  action: z.literal('UPDATE'),
  id: z.string(),
  name: z.string().optional(),
  hiddenFromPublishing: z.boolean().optional(),
});

export const variableCollectionDeleteSchema = z.object({
  action: z.literal('DELETE'),
  id: z.string(),
});

export const variableCollectionChangeSchema = z.union([
  variableCollectionCreateSchema,
  variableCollectionUpdateSchema,
  variableCollectionDeleteSchema,
]);

export const variableModeCreateSchema = z.object({
  action: z.literal('CREATE'),
  id: z.string().optional(),
  name: z.string(),
  variableCollectionId: z.string(),
});

export const variableModeUpdateSchema = z.object({
  action: z.literal('UPDATE'),
  id: z.string(),
  name: z.string().optional(),
  variableCollectionId: z.string(),
});

export const variableModeDeleteSchema = z.object({
  action: z.literal('DELETE'),
  id: z.string(),
});

export const variableModeChangeSchema = z.union([
  variableModeCreateSchema,
  variableModeUpdateSchema,
  variableModeDeleteSchema,
]);

export const variableCreateSchema = z.object({
  action: z.literal('CREATE'),
  id: z.string().optional(),
  name: z.string(),
  variableCollectionId: z.string(),
  resolvedType: z.union([z.literal('BOOLEAN'), z.literal('FLOAT'), z.literal('STRING'), z.literal('COLOR')]),
  description: z.string().optional(),
  hiddenFromPublishing: z.boolean().optional(),
  scopes: z.array(variableScopeSchema).optional(),
  codeSyntax: variableCodeSyntaxSchema.optional(),
});

export const variableUpdateSchema = z.object({
  action: z.literal('UPDATE'),
  id: z.string(),
  name: z.string().optional(),
  description: z.string().optional(),
  hiddenFromPublishing: z.boolean().optional(),
  scopes: z.array(variableScopeSchema).optional(),
  codeSyntax: variableCodeSyntaxSchema.optional(),
});

export const variableDeleteSchema = z.object({
  action: z.literal('DELETE'),
  id: z.string(),
});

export const variableChangeSchema = z.union([variableCreateSchema, variableUpdateSchema, variableDeleteSchema]);

export const variableValueSchema = z.union([
  z.boolean(),
  z.number(),
  z.string(),
  rgbSchema,
  rgbaSchema,
  variableAliasSchema,
]);

export const devResourceSchema = z.object({
  id: z.string(),
  name: z.string(),
  url: z.string(),
  file_key: z.string(),
  node_id: z.string(),
});

export const libraryAnalyticsActionsByComponentSchema = z.object({
  week: z.string(),
  component_key: z.string(),
  component_name: z.string(),
  detachments: z.number(),
  insertions: z.number(),
});

export const libraryAnalyticsActionsByTeamSchema = z.object({
  week: z.string(),
  team_name: z.string(),
  workspace_name: z.string().optional(),
  detachments: z.number(),
  insertions: z.number(),
});

export const libraryAnalyticsUsagesByComponentSchema = z.object({
  component_key: z.string(),
  component_name: z.string(),
  num_instances: z.number(),
  num_teams_using: z.number(),
  num_files_using: z.number(),
});

export const libraryAnalyticsUsagesByFileSchema = z.object({
  file_name: z.string(),
  team_name: z.string(),
  workspace_name: z.string().optional(),
  num_instances: z.number(),
});

export const responsePaginationSchema = z.object({
  prev_page: z.string().optional(),
  next_page: z.string().optional(),
});

export const responseCursorSchema = z.object({
  before: z.number().optional(),
  after: z.number().optional(),
});

export const errorResponsePayloadWithErrMessageSchema = z.object({
  status: z.number(),
  err: z.string(),
});

export const errorResponsePayloadWithErrorBooleanSchema = z.object({
  error: z.boolean(),
  status: z.number(),
  message: z.string(),
});

export const getFileDataSchema = z.object({
  path: z.object({
    file_key: z.string(),
  }),
  query: z
    .object({
      branch_data: z.boolean().optional(),
      depth: z.number().optional(),
      geometry: z.string().optional(),
      ids: z.string().optional(),
      plugin_data: z.string().optional(),
      version: z.string().optional(),
    })
    .optional(),
});

export const getFileErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getFileNodesDataSchema = z.object({
  path: z.object({
    file_key: z.string(),
  }),
  query: z.object({
    depth: z.number().optional(),
    geometry: z.string().optional(),
    ids: z.string(),
    plugin_data: z.string().optional(),
    version: z.string().optional(),
  }),
});

export const getFileNodesErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getImagesDataSchema = z.object({
  path: z.object({
    file_key: z.string(),
  }),
  query: z.object({
    contents_only: z.boolean().optional(),
    format: z.union([z.literal('jpg'), z.literal('png'), z.literal('svg'), z.literal('pdf')]).optional(),
    ids: z.string(),
    scale: z.number().optional(),
    svg_include_id: z.boolean().optional(),
    svg_include_node_id: z.boolean().optional(),
    svg_outline_text: z.boolean().optional(),
    svg_simplify_stroke: z.boolean().optional(),
    use_absolute_bounds: z.boolean().optional(),
    version: z.string().optional(),
  }),
});

export const getImagesResponseSchema = z.object({
  err: z.null(),
  images: z.record(z.string().nullable()),
});

export const getImagesErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getImageFillsDataSchema = z.object({
  path: z.object({
    file_key: z.string(),
  }),
});

export const getImageFillsResponseSchema = z.object({
  error: z.boolean(),
  status: z.literal(200),
  meta: z.object({
    images: z.record(z.string()),
  }),
});

export const getImageFillsErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getTeamProjectsDataSchema = z.object({
  path: z.object({
    team_id: z.string(),
  }),
});

export const getTeamProjectsResponseSchema = z.object({
  name: z.string(),
  projects: z.array(projectSchema),
});

export const getTeamProjectsErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getProjectFilesDataSchema = z.object({
  path: z.object({
    project_id: z.string(),
  }),
  query: z
    .object({
      branch_data: z.boolean().optional(),
    })
    .optional(),
});

export const getProjectFilesResponseSchema = z.object({
  name: z.string(),
  files: z.array(
    z.object({
      key: z.string(),
      name: z.string(),
      thumbnail_url: z.string().optional(),
      last_modified: z.string(),
    }),
  ),
});

export const getProjectFilesErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getFileVersionsDataSchema = z.object({
  path: z.object({
    file_key: z.string(),
  }),
  query: z
    .object({
      after: z.number().optional(),
      before: z.number().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const getFileVersionsResponseSchema = z.object({
  versions: z.array(versionSchema),
  pagination: responsePaginationSchema,
});

export const getFileVersionsErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getCommentsDataSchema = z.object({
  path: z.object({
    file_key: z.string(),
  }),
  query: z
    .object({
      as_md: z.boolean().optional(),
    })
    .optional(),
});

export const getCommentsErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const postCommentDataSchema = z.object({
  body: z.object({
    message: z.string(),
    comment_id: z.string().optional(),
    client_meta: z.union([vectorSchema, frameOffsetSchema, regionSchema, frameOffsetRegionSchema]).optional(),
  }),
  path: z.object({
    file_key: z.string(),
  }),
});

export const postCommentErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const deleteCommentDataSchema = z.object({
  path: z.object({
    comment_id: z.string(),
    file_key: z.string(),
  }),
});

export const deleteCommentResponseSchema = z.object({
  status: z.literal(200),
  error: z.boolean(),
});

export const deleteCommentErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getCommentReactionsDataSchema = z.object({
  path: z.object({
    comment_id: z.string(),
    file_key: z.string(),
  }),
  query: z
    .object({
      cursor: z.string().optional(),
    })
    .optional(),
});

export const reactionSchema = z.object({
  user: userSchema,
  emoji: emojiSchema,
  created_at: z.string(),
});

export const getCommentReactionsErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const postCommentReactionDataSchema = z.object({
  body: z.object({
    emoji: emojiSchema,
  }),
  path: z.object({
    comment_id: z.string(),
    file_key: z.string(),
  }),
});

export const postCommentReactionResponseSchema = z.object({
  status: z.literal(200),
  error: z.boolean(),
});

export const postCommentReactionErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const deleteCommentReactionDataSchema = z.object({
  path: z.object({
    comment_id: z.string(),
    file_key: z.string(),
  }),
  query: z.object({
    emoji: emojiSchema,
  }),
});

export const deleteCommentReactionResponseSchema = z.object({
  status: z.literal(200),
  error: z.boolean(),
});

export const deleteCommentReactionErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getMeResponseSchema = userSchema.and(
  z.object({
    email: z.string(),
  }),
);

export const getMeErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getTeamComponentsDataSchema = z.object({
  path: z.object({
    team_id: z.string(),
  }),
  query: z
    .object({
      after: z.number().optional(),
      before: z.number().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const getTeamComponentsResponseSchema = z.object({
  status: z.literal(200),
  error: z.boolean(),
  meta: z.object({
    components: z.array(publishedComponentSchema),
    cursor: responseCursorSchema.optional(),
  }),
});

export const getTeamComponentsErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getFileComponentsDataSchema = z.object({
  path: z.object({
    file_key: z.string(),
  }),
});

export const getFileComponentsResponseSchema = z.object({
  status: z.literal(200),
  error: z.boolean(),
  meta: z.object({
    components: z.array(publishedComponentSchema),
  }),
});

export const getFileComponentsErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getComponentDataSchema = z.object({
  path: z.object({
    key: z.string(),
  }),
});

export const getComponentResponseSchema = z.object({
  status: z.literal(200),
  error: z.boolean(),
  meta: publishedComponentSchema,
});

export const getComponentErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getTeamComponentSetsDataSchema = z.object({
  path: z.object({
    team_id: z.string(),
  }),
  query: z
    .object({
      after: z.number().optional(),
      before: z.number().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const getTeamComponentSetsResponseSchema = z.object({
  status: z.literal(200),
  error: z.boolean(),
  meta: z.object({
    component_sets: z.array(publishedComponentSetSchema),
    cursor: responseCursorSchema.optional(),
  }),
});

export const getTeamComponentSetsErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getFileComponentSetsDataSchema = z.object({
  path: z.object({
    file_key: z.string(),
  }),
});

export const getFileComponentSetsResponseSchema = z.object({
  status: z.literal(200),
  error: z.boolean(),
  meta: z.object({
    component_sets: z.array(publishedComponentSetSchema),
  }),
});

export const getFileComponentSetsErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getComponentSetDataSchema = z.object({
  path: z.object({
    key: z.string(),
  }),
});

export const getComponentSetResponseSchema = z.object({
  status: z.literal(200),
  error: z.boolean(),
  meta: publishedComponentSetSchema,
});

export const getComponentSetErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getTeamStylesDataSchema = z.object({
  path: z.object({
    team_id: z.string(),
  }),
  query: z
    .object({
      after: z.number().optional(),
      before: z.number().optional(),
      page_size: z.number().optional(),
    })
    .optional(),
});

export const getTeamStylesResponseSchema = z.object({
  status: z.literal(200),
  error: z.boolean(),
  meta: z.object({
    styles: z.array(publishedStyleSchema),
    cursor: responseCursorSchema.optional(),
  }),
});

export const getTeamStylesErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getFileStylesDataSchema = z.object({
  path: z.object({
    file_key: z.string(),
  }),
});

export const getFileStylesResponseSchema = z.object({
  status: z.literal(200),
  error: z.boolean(),
  meta: z.object({
    styles: z.array(publishedStyleSchema),
  }),
});

export const getFileStylesErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getStyleDataSchema = z.object({
  path: z.object({
    key: z.string(),
  }),
});

export const getStyleResponseSchema = z.object({
  status: z.literal(200),
  error: z.boolean(),
  meta: publishedStyleSchema,
});

export const getStyleErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const postWebhookDataSchema = z.object({
  body: z.object({
    event_type: webhookV2EventSchema,
    team_id: z.string(),
    endpoint: z.string(),
    passcode: z.string(),
    status: webhookV2StatusSchema.optional(),
    description: z.string().optional(),
  }),
});

export const webhookV2Schema = z.object({
  id: z.string(),
  event_type: webhookV2EventSchema,
  team_id: z.string(),
  status: webhookV2StatusSchema,
  client_id: z.string().nullable(),
  passcode: z.string(),
  endpoint: z.string(),
  description: z.string().nullable(),
});

export const postWebhookErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getWebhookDataSchema = z.object({
  path: z.object({
    webhook_id: z.string(),
  }),
});

export const getWebhookResponseSchema = webhookV2Schema;

export const getWebhookErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const putWebhookDataSchema = z.object({
  body: z.object({
    event_type: webhookV2EventSchema,
    endpoint: z.string(),
    passcode: z.string(),
    status: webhookV2StatusSchema.optional(),
    description: z.string().optional(),
  }),
  path: z.object({
    webhook_id: z.string(),
  }),
});

export const putWebhookResponseSchema = webhookV2Schema;

export const putWebhookErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const deleteWebhookDataSchema = z.object({
  path: z.object({
    webhook_id: z.string(),
  }),
});

export const deleteWebhookResponseSchema = webhookV2Schema;

export const deleteWebhookErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getTeamWebhooksDataSchema = z.object({
  path: z.object({
    team_id: z.string(),
  }),
});

export const getTeamWebhooksResponseSchema = z.object({
  webhooks: z.array(webhookV2Schema),
});

export const getTeamWebhooksErrorSchema = z.union([
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getWebhookRequestsDataSchema = z.object({
  path: z.object({
    webhook_id: z.string(),
  }),
});

export const webhookV2RequestSchema = z.object({
  webhook_id: z.string(),
  request_info: webhookV2RequestInfoSchema,
  response_info: webhookV2ResponseInfoSchema,
  error_msg: z.string().nullable(),
});

export const getWebhookRequestsErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrMessageSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getActivityLogsDataSchema = z.object({
  query: z
    .object({
      end_time: z.number().optional(),
      events: z.string().optional(),
      limit: z.number().optional(),
      order: z.union([z.literal('asc'), z.literal('desc')]).optional(),
      start_time: z.number().optional(),
    })
    .optional(),
});

export const getActivityLogsResponseSchema = z.object({
  status: z.literal(200).optional(),
  error: z.boolean().optional(),
  meta: z
    .object({
      activity_logs: z.array(activityLogSchema).optional(),
      cursor: z.string().optional(),
      next_page: z.boolean().optional(),
    })
    .optional(),
});

export const getActivityLogsErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(401),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getPaymentsDataSchema = z.object({
  query: z
    .object({
      community_file_id: z.number().optional(),
      plugin_id: z.number().optional(),
      plugin_payment_token: z.string().optional(),
      user_id: z.number().optional(),
      widget_id: z.number().optional(),
    })
    .optional(),
});

export const getPaymentsResponseSchema = z.object({
  status: z.literal(200),
  error: z.boolean(),
  meta: paymentInformationSchema,
});

export const getPaymentsErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(401),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getLocalVariablesDataSchema = z.object({
  path: z.object({
    file_key: z.string(),
  }),
});

export const getLocalVariablesResponseSchema = z.object({
  status: z.literal(200),
  error: z.boolean(),
  meta: z.object({
    variables: z.record(localVariableSchema),
    variableCollections: z.record(localVariableCollectionSchema),
  }),
});

export const getLocalVariablesErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(401),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getPublishedVariablesDataSchema = z.object({
  path: z.object({
    file_key: z.string(),
  }),
});

export const getPublishedVariablesResponseSchema = z.object({
  status: z.literal(200),
  error: z.boolean(),
  meta: z.object({
    variables: z.record(publishedVariableSchema),
    variableCollections: z.record(publishedVariableCollectionSchema),
  }),
});

export const getPublishedVariablesErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(401),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const variableModeValueSchema = z.object({
  variableId: z.string(),
  modeId: z.string(),
  value: variableValueSchema,
});

export const postVariablesResponseSchema = z.object({
  status: z.literal(200),
  error: z.boolean(),
  meta: z.object({
    tempIdToRealId: z.record(z.string()),
  }),
});

export const postVariablesErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(401),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getDevResourcesDataSchema = z.object({
  path: z.object({
    file_key: z.string(),
  }),
  query: z
    .object({
      node_ids: z.string().optional(),
    })
    .optional(),
});

export const getDevResourcesResponseSchema = z.object({
  dev_resources: z.array(devResourceSchema),
});

export const getDevResourcesErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(401),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const postDevResourcesDataSchema = z.object({
  body: z.object({
    dev_resources: z.array(
      z.object({
        name: z.string(),
        url: z.string(),
        file_key: z.string(),
        node_id: z.string(),
      }),
    ),
  }),
});

export const postDevResourcesResponseSchema = z.object({
  links_created: z.array(devResourceSchema),
  errors: z
    .array(
      z.object({
        file_key: z.string().optional().nullable(),
        node_id: z.string().optional().nullable(),
        error: z.string(),
      }),
    )
    .optional(),
});

export const postDevResourcesErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(401),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const putDevResourcesDataSchema = z.object({
  body: z.object({
    dev_resources: z.array(
      z.object({
        id: z.string(),
        name: z.string().optional(),
        url: z.string().optional(),
      }),
    ),
  }),
});

export const putDevResourcesResponseSchema = z.object({
  links_updated: z.array(devResourceSchema).optional(),
  errors: z
    .array(
      z.object({
        id: z.string().optional(),
        error: z.string(),
      }),
    )
    .optional(),
});

export const putDevResourcesErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(401),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const deleteDevResourceDataSchema = z.object({
  path: z.object({
    dev_resource_id: z.string(),
    file_key: z.string(),
  }),
});

export const deleteDevResourceResponseSchema = z.unknown();

export const deleteDevResourceErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(401),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(404),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getLibraryAnalyticsActionsDataSchema = z.object({
  path: z.object({
    file_key: z.string(),
  }),
  query: z.object({
    cursor: z.string().optional(),
    end_date: z.string().optional(),
    group_by: z.union([z.literal('component'), z.literal('team')]),
    order: z.union([z.literal('asc'), z.literal('desc')]).optional(),
    start_date: z.string().optional(),
  }),
});

export const getLibraryAnalyticsActionsResponseSchema = z.object({
  rows: z.union([z.array(libraryAnalyticsActionsByComponentSchema), z.array(libraryAnalyticsActionsByTeamSchema)]),
  next_page: z.boolean(),
  cursor: z.string().optional(),
});

export const getLibraryAnalyticsActionsErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(401),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const getLibraryAnalyticsUsagesDataSchema = z.object({
  path: z.object({
    file_key: z.string(),
  }),
  query: z.object({
    cursor: z.string().optional(),
    group_by: z.union([z.literal('component'), z.literal('file')]),
    order: z.union([z.literal('asc'), z.literal('desc')]).optional(),
  }),
});

export const getLibraryAnalyticsUsagesResponseSchema = z.object({
  components: z.array(libraryAnalyticsUsagesByComponentSchema).optional(),
  files: z.array(libraryAnalyticsUsagesByFileSchema).optional(),
  next_page: z.boolean(),
  cursor: z.string().optional(),
});

export const getLibraryAnalyticsUsagesErrorSchema = z.union([
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(400),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(401),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(403),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(429),
    }),
  ),
  errorResponsePayloadWithErrorBooleanSchema.and(
    z.object({
      status: z.literal(500),
    }),
  ),
]);

export const hasFramePropertiesTraitSchema = z.object({
  clipsContent: z.boolean(),
  background: z.array(paintSchema).optional(),
  backgroundColor: rgbaSchema.optional(),
  layoutGrids: z.array(layoutGridSchema).optional(),
  overflowDirection: z
    .union([
      z.literal('HORIZONTAL_SCROLLING'),
      z.literal('VERTICAL_SCROLLING'),
      z.literal('HORIZONTAL_AND_VERTICAL_SCROLLING'),
      z.literal('NONE'),
    ])
    .optional(),
  layoutMode: z.union([z.literal('NONE'), z.literal('HORIZONTAL'), z.literal('VERTICAL')]).optional(),
  primaryAxisSizingMode: z.union([z.literal('FIXED'), z.literal('AUTO')]).optional(),
  counterAxisSizingMode: z.union([z.literal('FIXED'), z.literal('AUTO')]).optional(),
  primaryAxisAlignItems: z
    .union([z.literal('MIN'), z.literal('CENTER'), z.literal('MAX'), z.literal('SPACE_BETWEEN')])
    .optional(),
  counterAxisAlignItems: z
    .union([z.literal('MIN'), z.literal('CENTER'), z.literal('MAX'), z.literal('BASELINE')])
    .optional(),
  paddingLeft: z.number().optional(),
  paddingRight: z.number().optional(),
  paddingTop: z.number().optional(),
  paddingBottom: z.number().optional(),
  itemSpacing: z.number().optional(),
  itemReverseZIndex: z.boolean().optional(),
  strokesIncludedInLayout: z.boolean().optional(),
  layoutWrap: z.union([z.literal('NO_WRAP'), z.literal('WRAP')]).optional(),
  counterAxisSpacing: z.number().optional(),
  counterAxisAlignContent: z.union([z.literal('AUTO'), z.literal('SPACE_BETWEEN')]).optional(),
});

export const hasExportSettingsTraitSchema = z.object({
  exportSettings: z.array(exportSettingSchema).optional(),
});

export const minimalStrokesTraitSchema = z.object({
  strokes: z.array(paintSchema).optional(),
  strokeWeight: z.number().optional(),
  strokeAlign: z.union([z.literal('INSIDE'), z.literal('OUTSIDE'), z.literal('CENTER')]).optional(),
  strokeJoin: z.union([z.literal('MITER'), z.literal('BEVEL'), z.literal('ROUND')]).optional(),
  strokeDashes: z.array(z.number()).optional(),
});

export const hasEffectsTraitSchema = z.object({
  effects: z.array(effectSchema),
});

export const componentPropertiesTraitSchema = z.object({
  componentPropertyDefinitions: z.record(componentPropertyDefinitionSchema).optional(),
});

export const typePropertiesTraitSchema = z.object({
  characters: z.string(),
  style: typeStyleSchema,
  characterStyleOverrides: z.array(z.number()),
  layoutVersion: z.number().optional(),
  styleOverrideTable: z.record(typeStyleSchema),
  lineTypes: z.array(z.union([z.literal('NONE'), z.literal('ORDERED'), z.literal('UNORDERED')])),
  lineIndentations: z.array(z.number()),
});

export const hasGeometryTraitSchema = minimalFillsTraitSchema.and(minimalStrokesTraitSchema).and(
  z.object({
    fillOverrideTable: z.record(paintOverrideSchema.nullable()).optional(),
    fillGeometry: z.array(pathSchema).optional(),
    strokeGeometry: z.array(pathSchema).optional(),
    strokeCap: z
      .union([
        z.literal('NONE'),
        z.literal('ROUND'),
        z.literal('SQUARE'),
        z.literal('LINE_ARROW'),
        z.literal('TRIANGLE_ARROW'),
        z.literal('DIAMOND_FILLED'),
        z.literal('CIRCLE_FILLED'),
        z.literal('TRIANGLE_FILLED'),
        z.literal('WASHI_TAPE_1'),
        z.literal('WASHI_TAPE_2'),
        z.literal('WASHI_TAPE_3'),
        z.literal('WASHI_TAPE_4'),
        z.literal('WASHI_TAPE_5'),
        z.literal('WASHI_TAPE_6'),
      ])
      .optional(),
    strokeMiterAngle: z.number().optional(),
  }),
);

export const embedNodeSchema = z
  .object({
    type: z.literal('EMBED'),
  })
  .and(isLayerTraitSchema)
  .and(hasExportSettingsTraitSchema);

export const linkUnfurlNodeSchema = z
  .object({
    type: z.literal('LINK_UNFURL'),
  })
  .and(isLayerTraitSchema)
  .and(hasExportSettingsTraitSchema);

export const shapeWithTextNodeSchema = z
  .object({
    type: z.literal('SHAPE_WITH_TEXT'),
    shapeType: shapeTypeSchema,
  })
  .and(isLayerTraitSchema)
  .and(hasLayoutTraitSchema)
  .and(hasBlendModeAndOpacityTraitSchema)
  .and(minimalFillsTraitSchema)
  .and(hasMaskTraitSchema)
  .and(hasEffectsTraitSchema)
  .and(hasExportSettingsTraitSchema)
  .and(hasTextSublayerTraitSchema)
  .and(cornerTraitSchema)
  .and(minimalStrokesTraitSchema);

export const stickyNodeSchema = z
  .object({
    type: z.literal('STICKY'),
    authorVisible: z.boolean().optional(),
  })
  .and(isLayerTraitSchema)
  .and(hasLayoutTraitSchema)
  .and(hasBlendModeAndOpacityTraitSchema)
  .and(minimalFillsTraitSchema)
  .and(hasMaskTraitSchema)
  .and(hasEffectsTraitSchema)
  .and(hasExportSettingsTraitSchema)
  .and(hasTextSublayerTraitSchema);

export const tableCellNodeSchema = z
  .object({
    type: z.literal('TABLE_CELL'),
  })
  .and(isLayerTraitSchema)
  .and(minimalFillsTraitSchema)
  .and(hasLayoutTraitSchema)
  .and(hasTextSublayerTraitSchema);

export const connectorTextBackgroundSchema = cornerTraitSchema.and(minimalFillsTraitSchema);

export const styleSchema = z.object({
  key: z.string(),
  name: z.string(),
  description: z.string(),
  remote: z.boolean(),
  styleType: styleTypeSchema,
});

export const componentSchema = z.object({
  key: z.string(),
  name: z.string(),
  description: z.string(),
  componentSetId: z.string().optional(),
  documentationLinks: z.array(documentationLinkSchema),
  remote: z.boolean(),
});

export const triggerSchema = z.union([
  z.object({
    type: z.union([z.literal('ON_CLICK'), z.literal('ON_HOVER'), z.literal('ON_PRESS'), z.literal('ON_DRAG')]),
  }),
  afterTimeoutTriggerSchema,
  z.object({
    type: z.union([z.literal('MOUSE_ENTER'), z.literal('MOUSE_LEAVE'), z.literal('MOUSE_UP'), z.literal('MOUSE_DOWN')]),
    delay: z.number(),
    deprecatedVersion: z.boolean().optional(),
  }),
  onKeyDownTriggerSchema,
  onMediaHitTriggerSchema,
  z.object({
    type: z.literal('ON_MEDIA_END'),
  }),
]);

export const simpleTransitionSchema = z.object({
  type: z.union([z.literal('DISSOLVE'), z.literal('SMART_ANIMATE'), z.literal('SCROLL_ANIMATE')]),
  duration: z.number(),
  easing: easingSchema,
});

export const commentSchema = z.object({
  id: z.string(),
  client_meta: z.union([vectorSchema, frameOffsetSchema, regionSchema, frameOffsetRegionSchema]),
  file_key: z.string(),
  parent_id: z.string().optional(),
  user: userSchema,
  created_at: z.string(),
  resolved_at: z.string().optional().nullable(),
  message: z.string(),
  order_id: z.string().nullable(),
  reactions: z.array(reactionSchema),
});

export const getCommentsResponseSchema = z.object({
  comments: z.array(commentSchema),
});

export const postCommentResponseSchema = commentSchema;

export const getCommentReactionsResponseSchema = z.object({
  reactions: z.array(reactionSchema),
  pagination: responsePaginationSchema,
});

export const postWebhookResponseSchema = webhookV2Schema;

export const getWebhookRequestsResponseSchema = z.object({
  requests: z.array(webhookV2RequestSchema),
});

export const postVariablesDataSchema = z.object({
  body: z.object({
    variableCollections: z.array(variableCollectionChangeSchema).optional(),
    variableModes: z.array(variableModeChangeSchema).optional(),
    variables: z.array(variableChangeSchema).optional(),
    variableModeValues: z.array(variableModeValueSchema).optional(),
  }),
  path: z.object({
    file_key: z.string(),
  }),
});

export const connectorNodeSchema = z
  .object({
    type: z.literal('CONNECTOR'),
    connectorStart: connectorEndpointSchema,
    connectorEnd: connectorEndpointSchema,
    connectorStartStrokeCap: z.union([
      z.literal('NONE'),
      z.literal('LINE_ARROW'),
      z.literal('TRIANGLE_ARROW'),
      z.literal('DIAMOND_FILLED'),
      z.literal('CIRCLE_FILLED'),
      z.literal('TRIANGLE_FILLED'),
    ]),
    connectorEndStrokeCap: z.union([
      z.literal('NONE'),
      z.literal('LINE_ARROW'),
      z.literal('TRIANGLE_ARROW'),
      z.literal('DIAMOND_FILLED'),
      z.literal('CIRCLE_FILLED'),
      z.literal('TRIANGLE_FILLED'),
    ]),
    connectorLineType: connectorLineTypeSchema,
    textBackground: connectorTextBackgroundSchema.optional(),
  })
  .and(isLayerTraitSchema)
  .and(hasLayoutTraitSchema)
  .and(hasBlendModeAndOpacityTraitSchema)
  .and(hasEffectsTraitSchema)
  .and(hasExportSettingsTraitSchema)
  .and(hasTextSublayerTraitSchema)
  .and(minimalStrokesTraitSchema);

export const transitionSchema = z.union([simpleTransitionSchema, directionalTransitionSchema]);

export const nodeActionSchema = z.object({
  type: z.literal('NODE'),
  destinationId: z.string().nullable(),
  navigation: navigationSchema,
  transition: transitionSchema.nullable(),
  preserveScrollPosition: z.boolean().optional(),
  overlayRelativePosition: vectorSchema.optional(),
  resetVideoPosition: z.boolean().optional(),
  resetScrollPosition: z.boolean().optional(),
  resetInteractiveComponents: z.boolean().optional(),
});

export const hasChildrenTraitSchema: z.ZodSchema<HasChildrenTrait> = z.lazy(() =>
  z.object({
    children: z.array(subcanvasNodeSchema),
  }),
);

export const subcanvasNodeSchema: z.ZodSchema<SubcanvasNode> = z.lazy(() =>
  z.union([
    booleanOperationNodeSchema,
    componentNodeSchema,
    componentSetNodeSchema,
    connectorNodeSchema,
    ellipseNodeSchema,
    embedNodeSchema,
    frameNodeSchema,
    groupNodeSchema,
    instanceNodeSchema,
    lineNodeSchema,
    linkUnfurlNodeSchema,
    rectangleNodeSchema,
    regularPolygonNodeSchema,
    sectionNodeSchema,
    shapeWithTextNodeSchema,
    sliceNodeSchema,
    starNodeSchema,
    stickyNodeSchema,
    tableNodeSchema,
    tableCellNodeSchema,
    textNodeSchema,
    vectorNodeSchema,
    washiTapeNodeSchema,
    widgetNodeSchema,
  ]),
);

export const transitionSourceTraitSchema: z.ZodSchema<TransitionSourceTrait> = z.lazy(() =>
  z.object({
    transitionNodeID: z.string().optional(),
    transitionDuration: z.number().optional(),
    transitionEasing: easingTypeSchema.optional(),
    interactions: z.array(interactionSchema).optional(),
  }),
);

export const interactionSchema: z.ZodSchema<Interaction> = z.lazy(() =>
  z.object({
    trigger: triggerSchema.nullable(),
    actions: z.array(actionSchema).optional(),
  }),
);

export const frameTraitsSchema: z.ZodSchema<FrameTraits> = z.lazy(() =>
  isLayerTraitSchema
    .and(hasBlendModeAndOpacityTraitSchema)
    .and(hasChildrenTraitSchema)
    .and(hasLayoutTraitSchema)
    .and(hasFramePropertiesTraitSchema)
    .and(cornerTraitSchema)
    .and(hasGeometryTraitSchema)
    .and(hasExportSettingsTraitSchema)
    .and(hasEffectsTraitSchema)
    .and(hasMaskTraitSchema)
    .and(transitionSourceTraitSchema)
    .and(individualStrokesTraitSchema)
    .and(devStatusTraitSchema),
);

export const defaultShapeTraitsSchema: z.ZodSchema<DefaultShapeTraits> = z.lazy(() =>
  isLayerTraitSchema
    .and(hasBlendModeAndOpacityTraitSchema)
    .and(hasLayoutTraitSchema)
    .and(hasGeometryTraitSchema)
    .and(hasExportSettingsTraitSchema)
    .and(hasEffectsTraitSchema)
    .and(hasMaskTraitSchema)
    .and(transitionSourceTraitSchema),
);

export const cornerRadiusShapeTraitsSchema: z.ZodSchema<CornerRadiusShapeTraits> = z.lazy(() =>
  defaultShapeTraitsSchema.and(cornerTraitSchema),
);

export const rectangularShapeTraitsSchema: z.ZodSchema<RectangularShapeTraits> = z.lazy(() =>
  defaultShapeTraitsSchema.and(cornerTraitSchema).and(individualStrokesTraitSchema),
);

export const nodeSchema: z.ZodSchema<Node> = z.lazy(() =>
  z.union([
    booleanOperationNodeSchema,
    componentNodeSchema,
    componentSetNodeSchema,
    connectorNodeSchema,
    ellipseNodeSchema,
    embedNodeSchema,
    frameNodeSchema,
    groupNodeSchema,
    instanceNodeSchema,
    lineNodeSchema,
    linkUnfurlNodeSchema,
    rectangleNodeSchema,
    regularPolygonNodeSchema,
    sectionNodeSchema,
    shapeWithTextNodeSchema,
    sliceNodeSchema,
    starNodeSchema,
    stickyNodeSchema,
    tableNodeSchema,
    tableCellNodeSchema,
    textNodeSchema,
    vectorNodeSchema,
    washiTapeNodeSchema,
    widgetNodeSchema,
    documentNodeSchema,
    canvasNodeSchema,
  ]),
);

export const booleanOperationNodeSchema: z.ZodSchema<BooleanOperationNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('BOOLEAN_OPERATION'),
      booleanOperation: z.union([
        z.literal('UNION'),
        z.literal('INTERSECT'),
        z.literal('SUBTRACT'),
        z.literal('EXCLUDE'),
      ]),
    })
    .and(isLayerTraitSchema)
    .and(hasBlendModeAndOpacityTraitSchema)
    .and(hasChildrenTraitSchema)
    .and(hasLayoutTraitSchema)
    .and(hasGeometryTraitSchema)
    .and(hasExportSettingsTraitSchema)
    .and(hasEffectsTraitSchema)
    .and(hasMaskTraitSchema)
    .and(transitionSourceTraitSchema),
);

export const componentNodeSchema: z.ZodSchema<ComponentNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('COMPONENT'),
    })
    .and(frameTraitsSchema)
    .and(componentPropertiesTraitSchema),
);

export const componentSetNodeSchema: z.ZodSchema<ComponentSetNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('COMPONENT_SET'),
    })
    .and(frameTraitsSchema)
    .and(componentPropertiesTraitSchema),
);

export const ellipseNodeSchema: z.ZodSchema<EllipseNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('ELLIPSE'),
      arcData: arcDataSchema,
    })
    .and(defaultShapeTraitsSchema),
);

export const frameNodeSchema: z.ZodSchema<FrameNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('FRAME'),
    })
    .and(frameTraitsSchema),
);

export const groupNodeSchema: z.ZodSchema<GroupNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('GROUP'),
    })
    .and(frameTraitsSchema),
);

export const instanceNodeSchema: z.ZodSchema<InstanceNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('INSTANCE'),
      componentId: z.string(),
      isExposedInstance: z.boolean().optional(),
      exposedInstances: z.array(z.string()).optional(),
      componentProperties: z.record(componentPropertySchema).optional(),
      overrides: z.array(overridesSchema),
    })
    .and(frameTraitsSchema),
);

export const lineNodeSchema: z.ZodSchema<LineNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('LINE'),
    })
    .and(defaultShapeTraitsSchema),
);

export const rectangleNodeSchema: z.ZodSchema<RectangleNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('RECTANGLE'),
    })
    .and(rectangularShapeTraitsSchema),
);

export const regularPolygonNodeSchema: z.ZodSchema<RegularPolygonNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('REGULAR_POLYGON'),
    })
    .and(cornerRadiusShapeTraitsSchema),
);

export const sectionNodeSchema: z.ZodSchema<SectionNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('SECTION'),
      sectionContentsHidden: z.boolean(),
    })
    .and(isLayerTraitSchema)
    .and(hasGeometryTraitSchema)
    .and(hasChildrenTraitSchema)
    .and(hasLayoutTraitSchema)
    .and(devStatusTraitSchema),
);

export const starNodeSchema: z.ZodSchema<StarNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('STAR'),
    })
    .and(cornerRadiusShapeTraitsSchema),
);

export const tableNodeSchema: z.ZodSchema<TableNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('TABLE'),
    })
    .and(isLayerTraitSchema)
    .and(hasChildrenTraitSchema)
    .and(hasLayoutTraitSchema)
    .and(minimalStrokesTraitSchema)
    .and(hasEffectsTraitSchema)
    .and(hasBlendModeAndOpacityTraitSchema)
    .and(hasExportSettingsTraitSchema),
);

export const textNodeSchema: z.ZodSchema<TextNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('TEXT'),
    })
    .and(defaultShapeTraitsSchema)
    .and(typePropertiesTraitSchema),
);

export const vectorNodeSchema: z.ZodSchema<VectorNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('VECTOR'),
    })
    .and(cornerRadiusShapeTraitsSchema),
);

export const washiTapeNodeSchema: z.ZodSchema<WashiTapeNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('WASHI_TAPE'),
    })
    .and(defaultShapeTraitsSchema),
);

export const widgetNodeSchema: z.ZodSchema<WidgetNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('WIDGET'),
    })
    .and(isLayerTraitSchema)
    .and(hasExportSettingsTraitSchema)
    .and(hasChildrenTraitSchema),
);

export const documentNodeSchema: z.ZodSchema<DocumentNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('DOCUMENT'),
      children: z.array(canvasNodeSchema),
    })
    .and(isLayerTraitSchema),
);

export const canvasNodeSchema: z.ZodSchema<CanvasNode> = z.lazy(() =>
  z
    .object({
      type: z.literal('CANVAS'),
      children: z.array(subcanvasNodeSchema),
      backgroundColor: rgbaSchema,
      prototypeStartNodeID: z.string().nullable(),
      flowStartingPoints: z.array(flowStartingPointSchema),
      prototypeDevice: prototypeDeviceSchema,
    })
    .and(isLayerTraitSchema)
    .and(hasExportSettingsTraitSchema),
);

export const actionSchema: z.ZodSchema<Action> = z.lazy(() =>
  z.union([
    z.object({
      type: z.union([z.literal('BACK'), z.literal('CLOSE')]),
    }),
    openURLActionSchema,
    updateMediaRuntimeActionSchema,
    setVariableActionSchema,
    setVariableModeActionSchema,
    conditionalActionSchema,
    nodeActionSchema,
  ]),
);

export const setVariableActionSchema: z.ZodSchema<SetVariableAction> = z.lazy(() =>
  z.object({
    type: z.literal('SET_VARIABLE'),
    variableId: z.string().nullable(),
    variableValue: variableDataSchema.optional(),
  }),
);

export const conditionalActionSchema: z.ZodSchema<ConditionalAction> = z.lazy(() =>
  z.object({
    type: z.literal('CONDITIONAL'),
    conditionalBlocks: z.array(conditionalBlockSchema),
  }),
);

export const variableDataSchema: z.ZodSchema<VariableData> = z.lazy(() =>
  z.object({
    type: variableDataTypeSchema.optional(),
    resolvedType: variableResolvedDataTypeSchema.optional(),
    value: z
      .union([z.boolean(), z.number(), z.string(), rgbSchema, rgbaSchema, variableAliasSchema, expressionSchema])
      .optional(),
  }),
);

export const conditionalBlockSchema: z.ZodSchema<ConditionalBlock> = z.lazy(() =>
  z.object({
    condition: variableDataSchema.optional(),
    actions: z.array(actionSchema),
  }),
);

export const expressionSchema: z.ZodSchema<Expression> = z.lazy(() =>
  z.object({
    expressionFunction: expressionFunctionSchema,
    expressionArguments: z.array(variableDataSchema),
  }),
);

export const getFileResponseSchema: z.ZodSchema<GetFileResponse> = z.lazy(() =>
  z.object({
    name: z.string(),
    role: z.union([z.literal('owner'), z.literal('editor'), z.literal('viewer')]),
    lastModified: z.string(),
    editorType: z.union([z.literal('figma'), z.literal('figjam')]),
    thumbnailUrl: z.string().optional(),
    version: z.string(),
    document: documentNodeSchema,
    components: z.record(componentSchema),
    componentSets: z.record(componentSetSchema),
    schemaVersion: z.number(),
    styles: z.record(styleSchema),
    mainFileKey: z.string().optional(),
    branches: z
      .array(
        z.object({
          key: z.string(),
          name: z.string(),
          thumbnail_url: z.string(),
          last_modified: z.string(),
        }),
      )
      .optional(),
  }),
);

export const getFileNodesResponseSchema: z.ZodSchema<GetFileNodesResponse> = z.lazy(() =>
  z.object({
    name: z.string(),
    role: z.union([z.literal('owner'), z.literal('editor'), z.literal('viewer')]),
    lastModified: z.string(),
    editorType: z.union([z.literal('figma'), z.literal('figjam')]),
    thumbnailUrl: z.string(),
    version: z.string(),
    nodes: z.record(
      z.object({
        document: nodeSchema,
        components: z.record(componentSchema),
        componentSets: z.record(componentSetSchema),
        schemaVersion: z.number(),
        styles: z.record(styleSchema),
      }),
    ),
  }),
);
