// This file is auto-generated by @hey-api/openapi-ts
import { createClient, createConfig, type Options } from '@hey-api/client-fetch';

import type {
  GetFileData,
  GetFileError,
  GetFileResponse,
  GetFileNodesData,
  GetFileNodesError,
  GetFileNodesResponse,
  GetImagesData,
  GetImagesError,
  GetImagesResponse,
  GetImageFillsData,
  GetImageFillsError,
  GetImageFillsResponse,
  GetTeamProjectsData,
  GetTeamProjectsError,
  GetTeamProjectsResponse,
  GetProjectFilesData,
  GetProjectFilesError,
  GetProjectFilesResponse,
  GetFileVersionsData,
  GetFileVersionsError,
  GetFileVersionsResponse,
  GetCommentsData,
  GetCommentsError,
  GetCommentsResponse,
  PostCommentData,
  PostCommentError,
  PostCommentResponse,
  DeleteCommentData,
  DeleteCommentError,
  DeleteCommentResponse,
  GetCommentReactionsData,
  GetCommentReactionsError,
  GetCommentReactionsResponse,
  PostCommentReactionData,
  PostCommentReactionError,
  PostCommentReactionResponse,
  DeleteCommentReactionData,
  DeleteCommentReactionError,
  DeleteCommentReactionResponse,
  GetMeError,
  GetMeResponse,
  GetTeamComponentsData,
  GetTeamComponentsError,
  GetTeamComponentsResponse,
  GetFileComponentsData,
  GetFileComponentsError,
  GetFileComponentsResponse,
  GetComponentData,
  GetComponentError,
  GetComponentResponse,
  GetTeamComponentSetsData,
  GetTeamComponentSetsError,
  GetTeamComponentSetsResponse,
  GetFileComponentSetsData,
  GetFileComponentSetsError,
  GetFileComponentSetsResponse,
  GetComponentSetData,
  GetComponentSetError,
  GetComponentSetResponse,
  GetTeamStylesData,
  GetTeamStylesError,
  GetTeamStylesResponse,
  GetFileStylesData,
  GetFileStylesError,
  GetFileStylesResponse,
  GetStyleData,
  GetStyleError,
  GetStyleResponse,
  PostWebhookData,
  PostWebhookError,
  PostWebhookResponse,
  GetWebhookData,
  GetWebhookError,
  GetWebhookResponse,
  PutWebhookData,
  PutWebhookError,
  PutWebhookResponse,
  DeleteWebhookData,
  DeleteWebhookError,
  DeleteWebhookResponse,
  GetTeamWebhooksData,
  GetTeamWebhooksError,
  GetTeamWebhooksResponse,
  GetWebhookRequestsData,
  GetWebhookRequestsError,
  GetWebhookRequestsResponse,
  GetActivityLogsData,
  GetActivityLogsError,
  GetActivityLogsResponse,
  GetPaymentsData,
  GetPaymentsError,
  GetPaymentsResponse,
  GetLocalVariablesData,
  GetLocalVariablesError,
  GetLocalVariablesResponse,
  GetPublishedVariablesData,
  GetPublishedVariablesError,
  GetPublishedVariablesResponse,
  PostVariablesData,
  PostVariablesError,
  PostVariablesResponse,
  GetDevResourcesData,
  GetDevResourcesError,
  GetDevResourcesResponse,
  PostDevResourcesData,
  PostDevResourcesError,
  PostDevResourcesResponse,
  PutDevResourcesData,
  PutDevResourcesError,
  PutDevResourcesResponse,
  DeleteDevResourceData,
  DeleteDevResourceError,
  DeleteDevResourceResponse,
  GetLibraryAnalyticsActionsData,
  GetLibraryAnalyticsActionsError,
  GetLibraryAnalyticsActionsResponse,
  GetLibraryAnalyticsUsagesData,
  GetLibraryAnalyticsUsagesError,
  GetLibraryAnalyticsUsagesResponse,
} from './types.gen';

export const client = createClient(createConfig());

/**
 * Get file JSON
 * Returns the document identified by `file_key` as a JSON object. The file key can be parsed from any Figma file url: `https://www.figma.com/file/{file_key}/{title}`.
 *
 * The `document` property contains a node of type `DOCUMENT`.
 *
 * The `components` property contains a mapping from node IDs to component metadata. This is to help you determine which components each instance comes from.
 */
export const getFile = <ThrowOnError extends boolean = false>(options: Options<GetFileData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetFileResponse, GetFileError, ThrowOnError>({
    ...options,
    url: '/v1/files/{file_key}',
  });
};

/**
 * Get file JSON for specific nodes
 * Returns the nodes referenced to by `ids` as a JSON object. The nodes are retrieved from the Figma file referenced to by `file_key`.
 *
 * The node ID and file key can be parsed from any Figma node url: `https://www.figma.com/file/{file_key}/{title}?node-id={id}`
 *
 * The `name`, `lastModified`, `thumbnailUrl`, `editorType`, and `version` attributes are all metadata of the specified file.
 *
 * The `linkAccess` field describes the file link share permission level. There are 5 types of permissions a shared link can have: `"inherit"`, `"view"`, `"edit"`, `"org_view"`, and `"org_edit"`. `"inherit"` is the default permission applied to files created in a team project, and will inherit the project's permissions. `"org_view"` and `"org_edit"` restrict the link to org users.
 *
 * The `document` attribute contains a Node of type `DOCUMENT`.
 *
 * The `components` key contains a mapping from node IDs to component metadata. This is to help you determine which components each instance comes from.
 *
 * By default, no vector data is returned. To return vector data, pass the geometry=paths parameter to the endpoint.
 * Each node can also inherit properties from applicable styles. The styles key contains a mapping from style IDs to style metadata.
 *
 * Important: the nodes map may contain values that are `null`. This may be due to the node id not existing within the specified file.
 */
export const getFileNodes = <ThrowOnError extends boolean = false>(
  options: Options<GetFileNodesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetFileNodesResponse, GetFileNodesError, ThrowOnError>({
    ...options,
    url: '/v1/files/{file_key}/nodes',
  });
};

/**
 * Render images of file nodes
 * Renders images from a file.
 *
 * If no error occurs, `"images"` will be populated with a map from node IDs to URLs of the rendered images, and `"status"` will be omitted. The image assets will expire after 30 days. Images up to 32 megapixels can be exported. Any images that are larger will be scaled down.
 *
 * Important: the image map may contain values that are `null`. This indicates that rendering of that specific node has failed. This may be due to the node id not existing, or other reasons such has the node having no renderable components. It is guaranteed that any node that was requested for rendering will be represented in this map whether or not the render succeeded.
 *
 * To render multiple images from the same file, use the `ids` query parameter to specify multiple node ids.
 *
 * ```
 * GET /v1/images/:key?ids=1:2,1:3,1:4
 * ```
 *
 */
export const getImages = <ThrowOnError extends boolean = false>(options: Options<GetImagesData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetImagesResponse, GetImagesError, ThrowOnError>({
    ...options,
    url: '/v1/images/{file_key}',
  });
};

/**
 * Get image fills
 * Returns download links for all images present in image fills in a document. Image fills are how Figma represents any user supplied images. When you drag an image into Figma, we create a rectangle with a single fill that represents the image, and the user is able to transform the rectangle (and properties on the fill) as they wish.
 *
 * This endpoint returns a mapping from image references to the URLs at which the images may be download. Image URLs will expire after no more than 14 days. Image references are located in the output of the GET files endpoint under the `imageRef` attribute in a `Paint`.
 */
export const getImageFills = <ThrowOnError extends boolean = false>(
  options: Options<GetImageFillsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetImageFillsResponse, GetImageFillsError, ThrowOnError>({
    ...options,
    url: '/v1/files/{file_key}/images',
  });
};

/**
 * Get projects in a team
 * You can use this endpoint to get a list of all the Projects within the specified team. This will only return projects visible to the authenticated user or owner of the developer token. Note: it is not currently possible to programmatically obtain the team id of a user just from a token. To obtain a team id, navigate to a team page of a team you are a part of. The team id will be present in the URL after the word team and before your team name.
 */
export const getTeamProjects = <ThrowOnError extends boolean = false>(
  options: Options<GetTeamProjectsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTeamProjectsResponse, GetTeamProjectsError, ThrowOnError>({
    ...options,
    url: '/v1/teams/{team_id}/projects',
  });
};

/**
 * Get files in a project
 * Get a list of all the Files within the specified project.
 */
export const getProjectFiles = <ThrowOnError extends boolean = false>(
  options: Options<GetProjectFilesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetProjectFilesResponse, GetProjectFilesError, ThrowOnError>({
    ...options,
    url: '/v1/projects/{project_id}/files',
  });
};

/**
 * Get versions of a file
 * This endpoint fetches the version history of a file, allowing you to see the progression of a file over time. You can then use this information to render a specific version of the file, via another endpoint.
 */
export const getFileVersions = <ThrowOnError extends boolean = false>(
  options: Options<GetFileVersionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetFileVersionsResponse, GetFileVersionsError, ThrowOnError>({
    ...options,
    url: '/v1/files/{file_key}/versions',
  });
};

/**
 * Get comments in a file
 * Gets a list of comments left on the file.
 */
export const getComments = <ThrowOnError extends boolean = false>(options: Options<GetCommentsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetCommentsResponse, GetCommentsError, ThrowOnError>({
    ...options,
    url: '/v1/files/{file_key}/comments',
  });
};

/**
 * Add a comment to a file
 * Posts a new comment on the file.
 */
export const postComment = <ThrowOnError extends boolean = false>(options: Options<PostCommentData, ThrowOnError>) => {
  return (options?.client ?? client).post<PostCommentResponse, PostCommentError, ThrowOnError>({
    ...options,
    url: '/v1/files/{file_key}/comments',
  });
};

/**
 * Delete a comment
 * Deletes a specific comment. Only the person who made the comment is allowed to delete it.
 */
export const deleteComment = <ThrowOnError extends boolean = false>(
  options: Options<DeleteCommentData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteCommentResponse, DeleteCommentError, ThrowOnError>({
    ...options,
    url: '/v1/files/{file_key}/comments/{comment_id}',
  });
};

/**
 * Get reactions for a comment
 * Gets a paginated list of reactions left on the comment.
 */
export const getCommentReactions = <ThrowOnError extends boolean = false>(
  options: Options<GetCommentReactionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetCommentReactionsResponse, GetCommentReactionsError, ThrowOnError>({
    ...options,
    url: '/v1/files/{file_key}/comments/{comment_id}/reactions',
  });
};

/**
 * Add a reaction to a comment
 * Posts a new comment reaction on a file comment.
 */
export const postCommentReaction = <ThrowOnError extends boolean = false>(
  options: Options<PostCommentReactionData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostCommentReactionResponse, PostCommentReactionError, ThrowOnError>({
    ...options,
    url: '/v1/files/{file_key}/comments/{comment_id}/reactions',
  });
};

/**
 * Delete a reaction
 * Deletes a specific comment reaction. Only the person who made the reaction is allowed to delete it.
 */
export const deleteCommentReaction = <ThrowOnError extends boolean = false>(
  options: Options<DeleteCommentReactionData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteCommentReactionResponse, DeleteCommentReactionError, ThrowOnError>({
    ...options,
    url: '/v1/files/{file_key}/comments/{comment_id}/reactions',
  });
};

/**
 * Get current user
 * Returns the user information for the currently authenticated user.
 */
export const getMe = <ThrowOnError extends boolean = false>(options?: Options<unknown, ThrowOnError>) => {
  return (options?.client ?? client).get<GetMeResponse, GetMeError, ThrowOnError>({
    ...options,
    url: '/v1/me',
  });
};

/**
 * Get team components
 * Get a paginated list of published components within a team library.
 */
export const getTeamComponents = <ThrowOnError extends boolean = false>(
  options: Options<GetTeamComponentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTeamComponentsResponse, GetTeamComponentsError, ThrowOnError>({
    ...options,
    url: '/v1/teams/{team_id}/components',
  });
};

/**
 * Get file components
 * Get a list of published components within a file library.
 */
export const getFileComponents = <ThrowOnError extends boolean = false>(
  options: Options<GetFileComponentsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetFileComponentsResponse, GetFileComponentsError, ThrowOnError>({
    ...options,
    url: '/v1/files/{file_key}/components',
  });
};

/**
 * Get component
 * Get metadata on a component by key.
 */
export const getComponent = <ThrowOnError extends boolean = false>(
  options: Options<GetComponentData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetComponentResponse, GetComponentError, ThrowOnError>({
    ...options,
    url: '/v1/components/{key}',
  });
};

/**
 * Get team component sets
 * Get a paginated list of published component sets within a team library.
 */
export const getTeamComponentSets = <ThrowOnError extends boolean = false>(
  options: Options<GetTeamComponentSetsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTeamComponentSetsResponse, GetTeamComponentSetsError, ThrowOnError>({
    ...options,
    url: '/v1/teams/{team_id}/component_sets',
  });
};

/**
 * Get file component sets
 * Get a list of published component sets within a file library.
 */
export const getFileComponentSets = <ThrowOnError extends boolean = false>(
  options: Options<GetFileComponentSetsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetFileComponentSetsResponse, GetFileComponentSetsError, ThrowOnError>({
    ...options,
    url: '/v1/files/{file_key}/component_sets',
  });
};

/**
 * Get component set
 * Get metadata on a component set by key.
 */
export const getComponentSet = <ThrowOnError extends boolean = false>(
  options: Options<GetComponentSetData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetComponentSetResponse, GetComponentSetError, ThrowOnError>({
    ...options,
    url: '/v1/component_sets/{key}',
  });
};

/**
 * Get team styles
 * Get a paginated list of published styles within a team library.
 */
export const getTeamStyles = <ThrowOnError extends boolean = false>(
  options: Options<GetTeamStylesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTeamStylesResponse, GetTeamStylesError, ThrowOnError>({
    ...options,
    url: '/v1/teams/{team_id}/styles',
  });
};

/**
 * Get file styles
 * Get a list of published styles within a file library.
 */
export const getFileStyles = <ThrowOnError extends boolean = false>(
  options: Options<GetFileStylesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetFileStylesResponse, GetFileStylesError, ThrowOnError>({
    ...options,
    url: '/v1/files/{file_key}/styles',
  });
};

/**
 * Get style
 * Get metadata on a style by key.
 */
export const getStyle = <ThrowOnError extends boolean = false>(options: Options<GetStyleData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetStyleResponse, GetStyleError, ThrowOnError>({
    ...options,
    url: '/v1/styles/{key}',
  });
};

/**
 * Create a webhook
 * Create a new webhook which will call the specified endpoint when the event triggers. By default, this webhook will automatically send a PING event to the endpoint when it is created. If this behavior is not desired, you can create the webhook and set the status to PAUSED and reactivate it later.
 */
export const postWebhook = <ThrowOnError extends boolean = false>(options: Options<PostWebhookData, ThrowOnError>) => {
  return (options?.client ?? client).post<PostWebhookResponse, PostWebhookError, ThrowOnError>({
    ...options,
    url: '/v2/webhooks',
  });
};

/**
 * Get a webhook
 * Get a webhook by ID.
 */
export const getWebhook = <ThrowOnError extends boolean = false>(options: Options<GetWebhookData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetWebhookResponse, GetWebhookError, ThrowOnError>({
    ...options,
    url: '/v2/webhooks/{webhook_id}',
  });
};

/**
 * Update a webhook
 * Update a webhook by ID.
 */
export const putWebhook = <ThrowOnError extends boolean = false>(options: Options<PutWebhookData, ThrowOnError>) => {
  return (options?.client ?? client).put<PutWebhookResponse, PutWebhookError, ThrowOnError>({
    ...options,
    url: '/v2/webhooks/{webhook_id}',
  });
};

/**
 * Delete a webhook
 * Deletes the specified webhook. This operation cannot be reversed.
 */
export const deleteWebhook = <ThrowOnError extends boolean = false>(
  options: Options<DeleteWebhookData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteWebhookResponse, DeleteWebhookError, ThrowOnError>({
    ...options,
    url: '/v2/webhooks/{webhook_id}',
  });
};

/**
 * Get team webhooks
 * Returns all webhooks registered under the specified team.
 */
export const getTeamWebhooks = <ThrowOnError extends boolean = false>(
  options: Options<GetTeamWebhooksData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetTeamWebhooksResponse, GetTeamWebhooksError, ThrowOnError>({
    ...options,
    url: '/v2/teams/{team_id}/webhooks',
  });
};

/**
 * Get webhook requests
 * Returns all webhook requests sent within the last week. Useful for debugging.
 */
export const getWebhookRequests = <ThrowOnError extends boolean = false>(
  options: Options<GetWebhookRequestsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetWebhookRequestsResponse, GetWebhookRequestsError, ThrowOnError>({
    ...options,
    url: '/v2/webhooks/{webhook_id}/requests',
  });
};

/**
 * Get activity logs
 * Returns a list of activity log events
 */
export const getActivityLogs = <ThrowOnError extends boolean = false>(
  options?: Options<GetActivityLogsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetActivityLogsResponse, GetActivityLogsError, ThrowOnError>({
    ...options,
    url: '/v1/activity_logs',
  });
};

/**
 * Get payments
 * There are two methods to query for a user's payment information on a plugin, widget, or Community file. The first method, using plugin payment tokens, is typically used when making queries from a plugin's or widget's code. The second method, providing a user ID and resource ID, is typically used when making queries from anywhere else.
 *
 * Note that you can only query for resources that you own. In most cases, this means that you can only query resources that you originally created.
 */
export const getPayments = <ThrowOnError extends boolean = false>(options?: Options<GetPaymentsData, ThrowOnError>) => {
  return (options?.client ?? client).get<GetPaymentsResponse, GetPaymentsError, ThrowOnError>({
    ...options,
    url: '/v1/payments',
  });
};

/**
 * Get local variables
 * **This API is available to full members of Enterprise orgs.**
 *
 * The `GET /v1/files/:file_key/variables/local` endpoint lets you enumerate local variables created in the file and remote variables used in the file. Remote variables are referenced by their `subscribed_id`.
 *
 * As a part of the Variables related API additions, the `GET /v1/files/:file_key` endpoint now returns a `boundVariables` property, containing the `variableId` of the bound variable. The `GET /v1/files/:file_key/variables/local` endpoint can be used to get the full variable or variable collection object.
 *
 * Note that `GET /v1/files/:file_key/variables/published` does not return modes. Instead, you will need to use the `GET /v1/files/:file_key/variables/local` endpoint, in the same file, to examine the mode values.
 *
 */
export const getLocalVariables = <ThrowOnError extends boolean = false>(
  options: Options<GetLocalVariablesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetLocalVariablesResponse, GetLocalVariablesError, ThrowOnError>({
    ...options,
    url: '/v1/files/{file_key}/variables/local',
  });
};

/**
 * Get published variables
 * **This API is available to full members of Enterprise orgs.**
 *
 * The `GET /v1/files/:file_key/variables/published` endpoint returns the variables that are published from the given file.
 *
 * The response for this endpoint contains some key differences compared to the `GET /v1/files/:file_key/variables/local` endpoint:
 *
 * - Each variable and variable collection contains a `subscribed_id`.
 * - Modes are omitted for published variable collections
 *
 * Published variables have two ids: an id that is assigned in the file where it is created (`id`), and an id that is used by subscribing files (`subscribed_id`). The `id` and `key` are stable over the lifetime of the variable. The `subscribed_id` changes every time the variable is modified and published. The same is true for variable collections.
 *
 * The `updatedAt` fields are ISO 8601 timestamps that indicate the last time that a change to a variable was published. For variable collections, this timestamp will change any time a variable in the collection is changed.
 */
export const getPublishedVariables = <ThrowOnError extends boolean = false>(
  options: Options<GetPublishedVariablesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetPublishedVariablesResponse, GetPublishedVariablesError, ThrowOnError>({
    ...options,
    url: '/v1/files/{file_key}/variables/published',
  });
};

/**
 * Create/modify/delete variables
 * **This API is available to full members of Enterprise orgs with Editor seats.**
 *
 * The `POST /v1/files/:file_key/variables` endpoint lets you bulk create, update, and delete variables and variable collections.
 *
 * The request body supports the following 4 top-level arrays. Changes from these arrays will be applied in the below order, and within each array, by array order.
 *
 * - **variableCollections**: For creating, updating, and deleting variable collections
 * - **variableModes**: For creating, updating, and deleting modes within variable collections
 * - Each collection can have a maximum of 40 modes
 * - Mode names cannot be longer than 40 characters
 * - **variables**: For creating, updating, and deleting variables
 * - Each collection can have a maximum of 5000 variables
 * - Variable names must be unique within a collection and cannot contain certain special characters such as `.{}`
 * - **variableModeValues**: For setting a variable value under a specific mode.
 * - When setting aliases, a variable cannot be aliased to itself or form an alias cycle
 *
 * Temporary ids can be used to reference an object later in the same POST request body. They can be used at create time in the `id` property of variable collections, modes, variables, and in the `initialModeId` property of variable collections. They are scoped to a single request body, and must be unique within the body. The mapping of temporary ids to real ids is returned in the response.
 *
 * This endpoint has the following key behaviors:
 *
 * - The request body must be 4MB or less.
 * - Must include an `action` property for collections, modes, and variables to tell the API whether to create, update, or delete the object.
 * - When creating a collection, mode, or variable, you can include a temporary `id` that can be referenced in dependent objects in the same request. For example, you can create a new collection with the id `"my_new_collection"`. You can then set `variableCollectionId` to `"my_new_collection"` in new modes or variables. Temporary ids must be unique in the request body.
 * - New collections always come with one mode. You can reference this mode by setting `initialModeId` to a temporary id in the request body. This is useful if you want to set values for variables in the mode in the `variableModeValues` array.
 * - The `tempIdToRealId` array returns a mapping of the temporary ids in the request, to the real ids of the newly created objects.
 * - When adding new modes or variables, default variable values will be applied, consistent with what happens in the UI.
 * - Everything to be created, updated, and deleted in the request body is treated as one atomic operation. If there is any validation failure, you will get a 400 status code response, and no changes will be persisted.
 * - You will not be able to update remote variables or variable collections. You can only update variables in the file where they were originally created.
 */
export const postVariables = <ThrowOnError extends boolean = false>(
  options: Options<PostVariablesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostVariablesResponse, PostVariablesError, ThrowOnError>({
    ...options,
    url: '/v1/files/{file_key}/variables',
  });
};

/**
 * Get dev resources
 * Get dev resources in a file
 */
export const getDevResources = <ThrowOnError extends boolean = false>(
  options: Options<GetDevResourcesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<GetDevResourcesResponse, GetDevResourcesError, ThrowOnError>({
    ...options,
    url: '/v1/files/{file_key}/dev_resources',
  });
};

/**
 * Create dev resources
 * Bulk create dev resources across multiple files.
 * Dev resources that are successfully created will show up in the links_created array in the response.
 *
 * If there are any dev resources that cannot be created, you may still get a 200 response. These resources will show up in the errors array. Some reasons a dev resource cannot be created include:
 *
 * - Resource points to a `file_key` that cannot be found.
 * - The node already has the maximum of 10 dev resources.
 * - Another dev resource for the node has the same url.
 */
export const postDevResources = <ThrowOnError extends boolean = false>(
  options: Options<PostDevResourcesData, ThrowOnError>,
) => {
  return (options?.client ?? client).post<PostDevResourcesResponse, PostDevResourcesError, ThrowOnError>({
    ...options,
    url: '/v1/dev_resources',
  });
};

/**
 * Update dev resources
 * Bulk update dev resources across multiple files.
 *
 * Ids for dev resources that are successfully updated will show up in the `links_updated` array in the response.
 *
 * If there are any dev resources that cannot be updated, you may still get a 200 response. These resources will show up in the `errors` array.
 */
export const putDevResources = <ThrowOnError extends boolean = false>(
  options: Options<PutDevResourcesData, ThrowOnError>,
) => {
  return (options?.client ?? client).put<PutDevResourcesResponse, PutDevResourcesError, ThrowOnError>({
    ...options,
    url: '/v1/dev_resources',
  });
};

/**
 * Delete dev resource
 * Delete a dev resource from a file
 */
export const deleteDevResource = <ThrowOnError extends boolean = false>(
  options: Options<DeleteDevResourceData, ThrowOnError>,
) => {
  return (options?.client ?? client).delete<DeleteDevResourceResponse, DeleteDevResourceError, ThrowOnError>({
    ...options,
    url: '/v1/files/{file_key}/dev_resources/{dev_resource_id}',
  });
};

/**
 * Get library analytics action data.
 * Returns a list of library analytics actions data broken down by the requested dimension.
 */
export const getLibraryAnalyticsActions = <ThrowOnError extends boolean = false>(
  options: Options<GetLibraryAnalyticsActionsData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetLibraryAnalyticsActionsResponse,
    GetLibraryAnalyticsActionsError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/analytics/libraries/{file_key}/actions',
  });
};

/**
 * Get library analytics usage data.
 * Returns a list of library analytics usage data broken down by the requested dimension.
 */
export const getLibraryAnalyticsUsages = <ThrowOnError extends boolean = false>(
  options: Options<GetLibraryAnalyticsUsagesData, ThrowOnError>,
) => {
  return (options?.client ?? client).get<
    GetLibraryAnalyticsUsagesResponse,
    GetLibraryAnalyticsUsagesError,
    ThrowOnError
  >({
    ...options,
    url: '/v1/analytics/libraries/{file_key}/usages',
  });
};
