// @ts-nocheck
export type TPaths = {
  '/service_information': {
    get: {
      deprecated: false;
      description: 'Retrieves the available REST API versions.\n\nDocuSign Production system: https://www.docusign.net/restapi/service_information\nDocuSign Demo system: https://demo.docusign.net/restapi/service_information\n\nYou do not need an integration key to view the REST API versions and resources.';
      operationId: 'ServiceInformation_GetServiceInformation';
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/serviceInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieves the available REST API versions.';
      tags: ['Services'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getService';
      'x-ds-service': 'Diagnostics';
    };
    parameters: [];
  };
  '/v2.1': {
    get: {
      deprecated: false;
      description: 'Retrieves the base resources available for the eSignature REST API.\n\nYou do not need an integrator key to view the REST API versions and resources.\n\n';
      operationId: 'ServiceInformation_GetResourceInformation';
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/resourceInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Lists resources for REST version specified';
      tags: ['Resources'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getResources';
      'x-ds-service': 'Diagnostics';
    };
    parameters: [];
  };
  '/v2.1/accounts': {
    parameters: [];
    post: {
      deprecated: false;
      description: 'Creates new DocuSign accounts.\nYou can use this method to create\na single account\nor up to 100 accounts at a time.\n\n**Note:**  This method is restricted to partner integrations.\nYou must work with DocuSign Professional Services\nor DocuSign Business Development,\nwho will provide you with the Distributor Code\nand Distributor Password\nthat you need to include in the request body.\n\n\nWhen creating a single account,\nthe body of the request is a\n[`newAccountRequest`][newAccountRequest]\nobject.\n\nExample:\n\n```\n{\n  "newAccountRequest": [\n    {\n      "accountName":"Test Account",\n      "distributorCode":"MY_DIST_CODE",\n      "distributorPassword":"MY_DIST_PWD",\n      "initialUser":{\n        "email":"user@emaildomain.com",\n        "firstName":"John",\n        "middleName": "Harry",\n        "lastName":"Doe",\n        "suffixName": "",\n        "userName": "John Doe",\n        "jobTitle": "Engineer",\n        "company": "Test Company"\n      },\n      "addressInformation":{\n        "address1": "1234 Main Street",\n        "address2": "Suite 100",\n        "city": "Seattle",\n        "state": "WA",\n        "postalCode": "98101",\n        "country": "US",\n        "phone": "1234567890",\n        "fax": "1234567891"\n      },\n      "planInformation":{\n        "planId":"37085696-xxxx-xxxx-xxxx-7ea067752959"\n      },\n      "referralInformation":{\n        "includedSeats": "1",\n        "referralCode": "code",\n        "referrerName": "name"\n      }\n    }\n  ]\n}\n\n```\nIf the request succeeds,\nit returns a\n201 (Created) HTTP response code.\nThe response returns the new account ID, password, and the default user\ninformation for each newly created account.\n\n\nWhen creating multiple accounts,\nthe body of the request is a\n`newAccountRequests`\nobject,\nwhich contains one or more\n[`newAccountDefinition`][newAccountDefinition]\nobjects.\nYou can create up to 100 new accounts\nat a time this way.\n\nThe body for a multi-account\ncreation request\nlooks like this in JSON:\n\n```\n{\n  "newAccountRequests": [\n    {\n      "accountName": "accountone",\n      . . .\n    },\n    {\n      "accountName": "accounttwo",\n      . . .\n    }\n  ]\n}\n```\n\nA multi-account request\nlooks like this in XML:\n\n```\n<newAccountsDefinition xmlns:i="http://www.w3.org/2001/XMLSchema-instance" xmlns="http://www.docusign.com/restapi">\n  <newAccountRequests>\n    <newAccountDefinition>\n      . . .\n    </newAccountDefinition>\n    <newAccountDefinition>\n      . . .\n    </newAccountDefinition>\n  </newAccountRequests>\n</newAccountsDefinition>\n```\n\nA multi-account creation request\nmay succeed (report a 201 code)\neven if some accounts could not be created.\nIn this case, the `errorDetails` property\nin the response contains specific information\nabout the failure.\n\n\n\n[newAccountDefinition]: #/definitions/newAccountDefinition\n[nameValue]: #/definitions/nameValue\n[newAccountRequest]: #/definitions/newAccountRequest\n';
      operationId: 'Accounts_PostAccounts';
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/newAccountDefinition';
            };
          };
        };
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/newAccountSummary';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates new accounts.';
      tags: ['Accounts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'create';
      'x-ds-service': 'Accounts';
    };
  };
  '/v2.1/accounts/provisioning': {
    get: {
      deprecated: false;
      description: 'Retrieves the account provisioning information for the account.';
      operationId: 'Accounts_GetProvisioning';
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/provisioningInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieves the account provisioning information for the account.';
      tags: ['Accounts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getProvisioning';
      'x-ds-methodname': 'getProvisioning';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}': {
    delete: {
      deprecated: false;
      description: 'This closes the specified account. You must be an account admin to close your account. Once closed, an account must be reopened by DocuSign.';
      operationId: 'Accounts_DeleteAccount';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes the specified account.';
      tags: ['Accounts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'delete';
      'x-ds-service': 'Accounts';
    };
    get: {
      deprecated: false;
      description: 'Retrieves the account information for the specified account.';
      operationId: 'Accounts_GetAccount';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** includes account settings in the response. The default value is **false.**';
          in: 'query';
          name: 'include_account_settings';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/accountInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieves the account information for the specified account.';
      tags: ['Accounts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'GetAccountInformation';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/billing_charges': {
    get: {
      deprecated: false;
      description: 'Retrieves the list of recurring and usage charges for the account. This can be used to determine the charge structure and usage of charge plan items. \n\nPrivileges required: account administrator ';
      operationId: 'BillingCharges_GetAccountBillingCharges';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies which billing charges to return.\nValid values are:\n\n* envelopes\n* seats\n';
          in: 'query';
          name: 'include_charges';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/billingChargeResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets list of recurring and usage charges for the account.';
      tags: ['Accounts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getBillingCharges';
      'x-ds-methodname': 'getBillingCharges';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/billing_invoices': {
    get: {
      deprecated: false;
      description: 'Retrieves a list of invoices for the account. If the from date or to date queries are not specified, the response returns invoices for the last 365 days.\n\nPrivileges required: account administrator ';
      operationId: 'BillingInvoices_GetBillingInvoices';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies the date/time of the earliest invoice in the account to retrieve.';
          in: 'query';
          name: 'from_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies the date/time of the latest invoice in the account to retrieve.';
          in: 'query';
          name: 'to_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/billingInvoicesResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Get a List of Billing Invoices';
      tags: ['Invoices'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listInvoices';
      'x-ds-service': 'Billing';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/billing_invoices/{invoiceId}': {
    get: {
      deprecated: false;
      description: "Retrieves the specified invoice.\n\n**Note:** If the `pdfAvailable` property in the response is set to *true*, you can download a PDF version of the invoice. To download the PDF, make the call again and change the value of the `Accept` property in the header to `Accept: application/pdf`.\n\nPrivileges required: account administrator\n\nThe response returns a list of charges and information about the charges. Quantities are usually shown as 'unlimited' or an integer. Amounts are shown in the currency set for the account.\n\n**Response**\nThe following table provides a description of the different `chargeName` property values. The information will grow as more chargeable items are added to the system.\n\n| chargeName | Description |\n| --- | --- |\n| id_check | ID Check Charge |\n| in_person_signing | In Person Signing charge |\n| envelopes Included | Sent Envelopes for the account |\n| age_verify | Age verification check |\n| ofac | OFAC Check |\n| id_confirm | ID confirmation check |\n| student_authentication | STAN PIN authentication check |\n| wet_sign_fax | Pages for returning signed documents by fax |\n| attachment_fax | Pages for returning attachments by fax |\n| phone_authentication | Phone authentication charge |\n| powerforms | PowerForm envelopes sent |\n| signer_payments | Payment processing charge |\n| outbound_fax | Send by fax charge |\n| bulk_recipient_envelopes | Bulk Recipient Envelopes sent |\n| sms_authentications | SMS authentication charge |\n| saml_authentications | SAML authentication charge |\n| express_signer_certificate | DocuSign Express Certificate charge |\n| personal_signer_certificate | Personal Signer Certificate charge |\n| safe_certificate | SAFE BioPharma Signer Certificate charge |\n| seats | Included active seats charge |\n| open_trust_certificate | OpenTrust Signer Certificate charge |";
      operationId: 'BillingInvoices_GetBillingInvoice';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the invoice.';
          in: 'path';
          name: 'invoiceId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/billingInvoice';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieves a billing invoice.';
      tags: ['Invoices'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getInvoice';
      'x-ds-service': 'Billing';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/billing_invoices_past_due': {
    get: {
      deprecated: false;
      description: 'Returns a list past due invoices for the account and notes if payment can be made through the REST API. \n\nPrivileges Required: account administrator';
      operationId: 'BillingInvoices_GetBillingInvoicesPastDue';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/billingInvoicesSummary';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Get a list of past due invoices.';
      tags: ['Invoices'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'listPastDue';
      'x-ds-methodname': 'listInvoicesPastDue';
      'x-ds-service': 'Billing';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/billing_payments': {
    get: {
      deprecated: false;
      description: 'Retrieves a list containing information about one or more payments. If the from date or to date queries are not used, the response returns payment information for the last 365 days. \n\nPrivileges required: account administrator ';
      operationId: 'BillingPayments_GetPaymentList';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies the date/time of the earliest payment in the account to retrieve.';
          in: 'query';
          name: 'from_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies the date/time of the latest payment in the account to retrieve.';
          in: 'query';
          name: 'to_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/billingPaymentsResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets payment information for one or more payments.';
      tags: ['Payments'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listPayments';
      'x-ds-service': 'Billing';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Posts a payment to a past due invoice.\n\nThis method can only be used if the `paymentAllowed` value for a past due invoice is true. This can be determined calling [Billing::listInvoicesPastDue](/docs/esign-rest-api/reference/billing/invoices/listpastdue/).\n\nThe response returns information for a single payment\nif a payment ID was used in the endpoint, or a list of payments.\nIf the from date or to date queries or payment ID are not used,\nthe response returns payment information for the last 365 days.\n\nIf the request was for a single payment ID, the `nextUri` and `previousUri` properties are not returned.\n\nPrivileges required: account administrator\n';
      operationId: 'BillingPayments_PostPayment';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/billingPaymentRequest';
            };
          };
        };
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/billingPaymentResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Posts a payment to a past due invoice.';
      tags: ['Payments'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'makePayment';
      'x-ds-service': 'Billing';
    };
  };
  '/v2.1/accounts/{accountId}/billing_payments/{paymentId}': {
    get: {
      deprecated: false;
      description: 'Retrieves the information for a specified payment. \n\nPrivileges required: account administrator ';
      operationId: 'BillingPayments_GetPayment';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the payment.';
          in: 'path';
          name: 'paymentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/billingPaymentItem';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets billing payment information for a specific payment.';
      tags: ['Payments'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getPayment';
      'x-ds-service': 'Billing';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/billing_plan': {
    get: {
      deprecated: false;
      description: 'Retrieves the billing plan information for the specified account, including the current billing plan, successor plans, billing address, and billing credit card.\n\nBy default the successor plan and credit card information is included in the response. You can exclude this information from the response by adding the appropriate optional query string and setting it to **false.**\n\nResponse\n\nThe response returns the billing plan information, including the currency code, for the plan. The `billingPlan` and `succesorPlans` property values are the same as those shown in the [Billing: getBillingPlan](/docs/esign-rest-api/reference/billing/billingplans/get/) reference. the `billingAddress` and `creditCardInformation` property values are the same as those shown in the [Billing: updatePlan](/docs/esign-rest-api/reference/billing/billingplans/update/) reference.\n\n**Note:** When credit card number information displays, a mask is applied to the response so that only the last 4 digits of the card number are visible.\n';
      operationId: 'BillingPlan_GetBillingPlan';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** payment information including credit card information will show in the return.';
          in: 'query';
          name: 'include_credit_card_information';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'include_downgrade_information';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the `canUpgrade` and `renewalStatus` properties are included the response and an array of `supportedCountries` is added to the `billingAddress` information. ';
          in: 'query';
          name: 'include_metadata';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** excludes successor information from the response.';
          in: 'query';
          name: 'include_successor_plans';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'include_tax_exempt_id';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/accountBillingPlanResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Get Account Billing Plan';
      tags: ['BillingPlans'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getAccountPlan';
      'x-ds-methodname': 'getPlan';
      'x-ds-service': 'Billing';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Updates the billing plan information, billing address, and credit card information for the specified account.';
      operationId: 'BillingPlan_PutBillingPlan';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** updates the account using a preview billing plan.';
          in: 'query';
          name: 'preview_billing_plan';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/billingPlanInformation';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/billingPlanUpdateResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates an account billing plan.';
      tags: ['BillingPlans'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updatePlan';
      'x-ds-service': 'Billing';
    };
  };
  '/v2.1/accounts/{accountId}/billing_plan/credit_card': {
    get: {
      deprecated: false;
      description: 'This method returns information about a credit card associated with an account.';
      operationId: 'BillingPlan_GetCreditCardInfo';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/creditCardInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Get credit card information';
      tags: ['BillingPlans'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getCreditCard';
      'x-ds-methodname': 'getCreditCardInfo';
      'x-ds-service': 'Billing';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/billing_plan/downgrade': {
    get: {
      deprecated: false;
      description: '';
      operationId: 'BillingPlan_GetDowngradeRequestBillingInfo';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/downgradRequestBillingInfoResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns downgrade plan information for the specified account.';
      tags: ['BillingPlans'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getDowngradeRequestBillingInfo';
      'x-ds-methodname': 'getDowngradeRequestBillingInfo';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: '';
      operationId: 'BillingPlan_PutDowngradeAccountBillingPlan';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/downgradeBillingPlanInformation';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/downgradePlanUpdateResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Queues downgrade billing plan request for an account.';
      tags: ['BillingPlans'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateDowngradeAccountBillingPlan';
      'x-ds-methodname': 'updateDowngradeAccountBillingPlan';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/billing_plan/purchased_envelopes': {
    parameters: [];
    put: {
      deprecated: false;
      description: 'Reserved: At this time, this endpoint is limited to DocuSign internal use only. Completes the purchase of envelopes for your account. The actual purchase is done as part of an internal workflow interaction with an envelope vendor.';
      operationId: 'PurchasedEnvelopes_PutPurchasedEnvelopes';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/purchasedEnvelopesInformation';
            };
          };
        };
      };
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Reserved: Purchase additional envelopes.';
      tags: ['BillingPlans'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'purchaseEnvelopes';
      'x-ds-methodname': 'purchaseEnvelopes';
      'x-ds-service': 'Billing';
    };
  };
  '/v2.1/accounts/{accountId}/brands': {
    delete: {
      deprecated: false;
      description: 'This method deletes one or more brand profiles from an account, based on the brand IDs that you include in the `brandsRequest`.\n\nEither or both of the following settings must be enabled for the account to use this method:\n\n- `canSelfBrandSign`\n- `canSelfBrandSend`\n\n### Related topics\n\n- [How to create a brand](/docs/esign-rest-api/how-to/create-brand/)\n';
      operationId: 'Brands_DeleteBrands';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/brandsRequest';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/AccountBrands';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes one or more brand profiles.';
      tags: ['AccountBrands'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteList';
      'x-ds-methodname': 'deleteBrands';
      'x-ds-service': 'Accounts';
    };
    get: {
      deprecated: false;
      description: 'This method returns details about all of the brands associated with an account,\nincluding the default brand profiles.\n\nEither or both of the following settings must be enabled for the account to use this method:\n\n- `canSelfBrandSign`\n- `canSelfBrandSend`\n\n### Related topics\n\n- [How to create a brand](/docs/esign-rest-api/how-to/create-brand/)\n';
      operationId: 'Brands_GetBrands';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** excludes distributor brand information from the response set.';
          in: 'query';
          name: 'exclude_distributor_brand';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** returns the logos associated with the brand.';
          in: 'query';
          name: 'include_logos';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/AccountBrands';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a list of brands.';
      tags: ['AccountBrands'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listBrands';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'This method creates one or more brand profile files for an account.\n\nTo specify logos for the brand,\nuse the\n[AccountBrands: updateLogo](/docs/esign-rest-api/reference/accounts/accountbrands/updatelogo/)\nmethod\nafter you create the brand.\n\n\nEither or both of the following settings must be enabled for the account to use this method:\n\n- `canSelfBrandSign`\n- `canSelfBrandSend`\n\n### Related topics\n\n- [How to create a brand](/docs/esign-rest-api/how-to/create-brand/)\n';
      operationId: 'Brands_PostBrands';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/brand';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/AccountBrands';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates one or more brand profiles for an account.';
      tags: ['AccountBrands'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createBrand';
      'x-ds-service': 'Accounts';
    };
  };
  '/v2.1/accounts/{accountId}/brands/{brandId}': {
    delete: {
      deprecated: false;
      description: 'This method deletes a brand from an account.\n\n**Note:** Branding for either signing or sending must be enabled for the account (`canSelfBrandSend` , `canSelfBrandSign`, or both of these account settings must be **true**).';
      operationId: 'Brand_DeleteBrand';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the brand.';
          in: 'path';
          name: 'brandId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes a brand.';
      tags: ['AccountBrands'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteBrand';
      'x-ds-service': 'Accounts';
    };
    get: {
      deprecated: false;
      description: 'This method returns details about an account brand.\n\n**Note:** Branding for either signing or sending must be enabled for the account (`canSelfBrandSend` , `canSelfBrandSign`, or both of these account settings must be **true**).';
      operationId: 'Brand_GetBrand';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the brand.';
          in: 'path';
          name: 'brandId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the landing pages and links associated with the brand are included in the response.';
          in: 'query';
          name: 'include_external_references';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the URIs for the logos associated with the brand are included in the response.';
          in: 'query';
          name: 'include_logos';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/brand';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets information about a brand.';
      tags: ['AccountBrands'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getBrand';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method updates an account brand. \n\n**Note:** Branding for either signing or sending must be enabled for the account (`canSelfBrandSend` , `canSelfBrandSign`, or both of these account settings must be **true**).';
      operationId: 'Brand_PutBrand';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the brand.';
          in: 'path';
          name: 'brandId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** replaces the brand instead of updating it. The only unchanged value is the brand ID. The request body must be XML. The default value is **false.**';
          in: 'query';
          name: 'replace_brand';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/brand';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/brand';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates an existing brand.';
      tags: ['AccountBrands'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateBrand';
      'x-ds-service': 'Accounts';
    };
  };
  '/v2.1/accounts/{accountId}/brands/{brandId}/file': {
    get: {
      deprecated: false;
      description: 'This method exports information about a brand to an XML file.\n\n**Note:** Branding for either signing or sending must be enabled for the account (`canSelfBrandSend` , `canSelfBrandSign`, or both of these account settings must be **true**).';
      operationId: 'BrandExport_GetBrandExportFile';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the brand.';
          in: 'path';
          name: 'brandId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Exports a brand.';
      tags: ['AccountBrands'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getExportFile';
      'x-ds-methodname': 'getBrandExportFile';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/brands/{brandId}/logos/{logoType}': {
    delete: {
      deprecated: false;
      description: 'This method deletes a single logo from an account brand.\n\n**Note:** Branding for either signing or sending must be enabled for the account (`canSelfBrandSend` , `canSelfBrandSign`, or both of these account settings must be **true**).';
      operationId: 'BrandLogo_DeleteBrandLogo';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the brand.';
          in: 'path';
          name: 'brandId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The type of logo. Valid values are:\n\n- `primary` \n- `secondary` \n- `email`';
          in: 'path';
          name: 'logoType';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes a brand logo.';
      tags: ['AccountBrands'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteLogo';
      'x-ds-methodname': 'deleteBrandLogoByType';
      'x-ds-service': 'Accounts';
    };
    get: {
      deprecated: false;
      description: 'This method returns a specific logo that is used in a brand.\n\n**Note:** Branding for either signing or sending must be enabled for the account (`canSelfBrandSend` , `canSelfBrandSign`, or both of these account settings must be **true**).';
      operationId: 'BrandLogo_GetBrandLogo';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the brand.';
          in: 'path';
          name: 'brandId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The type of logo. Valid values are:\n\n- `primary` \n- `secondary` \n- `email`';
          in: 'path';
          name: 'logoType';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'image/png': {
              schema: {
                format: 'binary';
                type: 'string';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            'image/png': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a brand logo.';
      tags: ['AccountBrands'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getLogo';
      'x-ds-methodname': 'getBrandLogoByType';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method updates a single brand logo.\n\nYou pass in the new version of the resource in the `Content-Disposition` header. Example:\n\n`Content-Disposition: form-data; name="file"; filename="logo.jpg"`\n\n**Note:** Branding for either signing or sending must be enabled for the account (`canSelfBrandSend` , `canSelfBrandSign`, or both of these account settings must be **true**).';
      operationId: 'BrandLogo_PutBrandLogo';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the brand.';
          in: 'path';
          name: 'brandId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The type of logo. Valid values are:\n\n- `primary` \n- `secondary` \n- `email`';
          in: 'path';
          name: 'logoType';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'image/png': {
            schema: {
              format: 'binary';
              type: 'string';
            };
          };
        };
        description: 'Brand logo binary Stream. Supported formats: JPG, GIF, PNG. Maximum file size: 300 KB. Recommended dimensions: 296 x 76 pixels (larger images will be resized). Changes may take up to one hour to display in all places';
        required: true;
      };
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates a brand logo.';
      tags: ['AccountBrands'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateLogo';
      'x-ds-methodname': 'updateBrandLogoByType';
      'x-ds-service': 'Accounts';
    };
  };
  '/v2.1/accounts/{accountId}/brands/{brandId}/resources': {
    get: {
      deprecated: false;
      description: 'This method returns metadata about the branding resources that are associated with an account.\n\n**Note:** Branding for either signing or sending must be enabled for the account (`canSelfBrandSend` , `canSelfBrandSign`, or both of these account settings must be **true**).';
      operationId: 'BrandResources_GetBrandResourcesList';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the brand.';
          in: 'path';
          name: 'brandId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/brandResourcesList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns metadata about the branding resources for an account.';
      tags: ['AccountBrands'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'listResources';
      'x-ds-methodname': 'getBrandResources';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/brands/{brandId}/resources/{resourceContentType}': {
    get: {
      deprecated: false;
      description: 'This method returns a specific branding resource file.\n\nA brand uses a set of brand resource files to control the sending, signing, email message, and captive (embedded) signing experiences.  You can modify the default email messages and formats in these files and upload them to your brand to customize the user experience.\n\n**Important:** When you upload a modified resource file, only the elements that differ from the master resource file are saved as your resource file. Similarly, when you download your resource files, only the modified elements are included in the file. \n\n**Note:** Branding for either signing or sending must be enabled for the account (`canSelfBrandSend` , `canSelfBrandSign`, or both of these account settings must be **true**).';
      operationId: 'BrandResources_GetBrandResources';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the brand.';
          in: 'path';
          name: 'brandId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The type of brand resource file to return. Valid values are:\n\n- `sending`\n- `signing`\n- `email`\n- `signing_captive`';
          in: 'path';
          name: 'resourceContentType';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ISO 3166-1 alpha-2 codes for the languages that the brand supports.';
          in: 'query';
          name: 'langcode';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies which resource file data to return. When **true,** only the master resource file is returned. When **false,** only the elements that you modified are returned.';
          in: 'query';
          name: 'return_master';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns a branding resource file.';
      tags: ['AccountBrands'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getResource';
      'x-ds-methodname': 'getBrandResourcesByContentType';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method updates a branding resource file.\n\nYou pass in the new version of the resource file in the `Content-Disposition` header. Example:\n\n`Content-Disposition: form-data; name="file"; filename="DocuSign_SigningResource_4328673.xml"`\n\n**Note:** Branding for either signing or sending must be enabled for the account (`canSelfBrandSend` , `canSelfBrandSign`, or both of these account settings must be **true**).\n\n**Important:** Customizing resource files is an advanced branding configuration option which can significantly impact your account, and should be done only by someone with expertise in XML and HTML. The master resource files are subject to change without notice. If you customize your resource files, after each release, DocuSign recommends you review any changes and update your custom files as needed.\n\nWhen you upload a modified resource file, only the elements that differ from the master resource file are saved as your resource file. Similarly, when you download your resource files, only the modified elements are included in the file.';
      operationId: 'BrandResources_PutBrandResources';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the brand.';
          in: 'path';
          name: 'brandId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The type of brand resource file that you are updating. Valid values are:\n\n- `sending`\n- `signing`\n- `email`\n- `signing_captive`';
          in: 'path';
          name: 'resourceContentType';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'multipart/form-data': {
            schema: {
              properties: {
                'file.xml': {
                  description: 'Brand resource XML file.';
                  format: 'binary';
                  type: 'string';
                };
              };
              required: ['file.xml'];
              type: 'object';
            };
          };
        };
        required: true;
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/brandResources';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates a branding resource file.';
      tags: ['AccountBrands'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateResource';
      'x-ds-methodname': 'updateBrandResourcesByContentType';
      'x-ds-service': 'Accounts';
    };
  };
  '/v2.1/accounts/{accountId}/bulk_send_batch': {
    get: {
      deprecated: false;
      description: 'Returns a summary of bulk send batches.\n\nUse the `batch_ids` query parameter to narrow the list of batches.';
      operationId: 'BulkSendV2Batch_GetBulkSendBatches';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of batch IDs to query.';
          in: 'query';
          name: 'batch_ids';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.\n\nUse `start_position` to specify the number of results to skip.\n\nValid values: `1` to `100`<br>\nDefault: `100`';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The start date for a date range in UTC DateTime format.\n\n**Note:** If this property is null, no date filtering is applied.';
          in: 'query';
          name: 'from_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Use this parameter to search for specific text.';
          in: 'query';
          name: 'search_text';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nUse with `count` to limit the number\nof results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The kind of results to collect. Must be one of:\n\n- all\n- failed\n- sent\n- queued';
          in: 'query';
          name: 'status';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The end of a search date range in UTC DateTime format. When you use this parameter, only templates created up to this date and time are returned.\n\n**Note:** If this property is null, the value defaults to the current date.';
          in: 'query';
          name: 'to_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'user_id';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/bulkSendBatchSummaries';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns a list of bulk send batch summaries. ';
      tags: ['BulkSend'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getBulkSendBatches';
      'x-ds-methodname': 'getBulkSendBatches';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}': {
    get: {
      deprecated: false;
      description: 'Gets the general status of a specific bulk send batch such as:\n\n- number of successes\n- number pending\n- number of errors\n\nThe `bulkErrors` property of the response object contains more information about the errors.\n\n### Related topics\n\n- [How to bulk send envelopes](/docs/esign-rest-api/how-to/bulk-send-envelopes/)\n';
      operationId: 'BulkSendV2Batch_GetBulkSendBatchStatus';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The batch ID.';
          in: 'path';
          name: 'bulkSendBatchId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/bulkSendBatchStatus';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the status of a specific bulk send batch.';
      tags: ['BulkSend'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getBulkSendBatchStatus';
      'x-ds-methodname': 'getBulkSendBatchStatus';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Updates the name of a bulk send batch.';
      operationId: 'BulkSendV2Batch_PutBulkSendBatchStatus';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The batch ID.';
          in: 'path';
          name: 'bulkSendBatchId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/bulkSendBatchRequest';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/bulkSendBatchStatus';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the name of a bulk send batch.';
      tags: ['BulkSend'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateBulkSendBatchStatus';
      'x-ds-methodname': 'updateBulkSendBatchStatus';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}/envelopes': {
    get: {
      deprecated: false;
      description: 'This method returns a list of envelopes in a specified bulk batch. Use the query parameters to filter and sort the envelopes by different attributes.';
      operationId: 'BulkSendV2Envelopes_GetBulkSendBatchEnvelopes';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The batch ID.';
          in: 'path';
          name: 'bulkSendBatchId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.\n\nUse `start_position` to specify the number of results to skip.\n\nValid values: `1` to `1000`\n';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When `recipients`, only envelopes with recipient nodes will be included in the response.';
          in: 'query';
          name: 'include';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The order in which to sort the results. Valid values are:\n\n- Descending order: `desc` (default)\n- Ascending order: `asc`';
          in: 'query';
          name: 'order';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The envelope attribute used to sort the results. Valid values are:\n\n- `created` (default)\n- `completed`\n- `last_modified`\n- `sent`\n- `status`\n- `subject`\n- `status_changed`';
          in: 'query';
          name: 'order_by';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Use this parameter to search for specific text.';
          in: 'query';
          name: 'search_text';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nUse with `count` to limit the number\nof results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Comma-separated list of envelope statuses.\n\nNote that `any` should not be included with other statuses. In other words, `any` is a valid parameter value, but `any,sent` is not.\n\nUse the value `deliveryfailure` to get all envelopes with `AuthFailed` and `AutoResponded` status. This value is specific to bulk sending.';
          in: 'query';
          name: 'status';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopesInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets envelopes from a specific bulk send batch.';
      tags: ['BulkSend'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getBulkSendBatchEnvelopes';
      'x-ds-methodname': 'getBulkSendBatchEnvelopes';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/bulk_send_batch/{bulkSendBatchId}/{bulkAction}': {
    parameters: [];
    put: {
      deprecated: false;
      description: 'Use this endpoint to resend, correct, or void all envelopes from a specified bulk send.';
      operationId: 'BulkSendV2Batch_PutBulkSendBatchAction';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The action to apply. Valid values:\n* `resend`\n* `correct`\n* `void`\n';
          in: 'path';
          name: 'bulkAction';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The batch ID.';
          in: 'path';
          name: 'bulkSendBatchId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/bulkSendBatchActionRequest';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/bulkSendBatchStatus';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Applies a bulk action to all envelopes from a specified bulk send.';
      tags: ['BulkSend'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateBulkSendBatchAction';
      'x-ds-methodname': 'updateBulkSendBatchAction';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/bulk_send_lists': {
    get: {
      deprecated: false;
      description: 'This method returns a list of bulk send lists belonging to the current user, as well as basic information about each list.';
      operationId: 'BulkSendV2CRUD_GetBulkSendLists';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/bulkSendingListSummaries';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets bulk send lists.';
      tags: ['BulkSend'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getBulkSendLists';
      'x-ds-methodname': 'getBulkSendLists';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: "This method creates a bulk send list that you can use to send an envelope to up to 1,000 recipients at once.\n\n### Related topics\n\n- [How to bulk send envelopes](/docs/esign-rest-api/how-to/bulk-send-envelopes/)\n\n### Errors\n\n| Error code                                              | Description                                                                                                                                                                                                                                                                              |\n| :------------------------------------------------------ | :--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |\n| BULK_SEND_MAX_COPIES_EXCEEDED                           | A bulk sending list cannot specify more than XXX copies in the mailing list. Call the settings API endpoint to find the maximum number of copies in a batch allowed for your account. In almost all cases, the default limit is 1000.                                                    |\n| BULK_SEND_RECIPIENT_IDS_MUST_BE_UNIQUE                  | No two recipientIds can be same within a bulkCopy. Same restriction as a regular envelope applies. Specify unique recipient IDs for each recipient within a bulkCopy (model for envelope in mailing list).                                                                               |\n| BULK_SEND_RECIPIENT_ID_REQUIRED                         | If no RoleName is present, recipientID is required in mailing list's bulkCopy. Add a roleName (that coalesces with template/envelope) or a recipientID.                                                                                                                                  |\n| BULK_SEND_RECIPIENT_NAME_REQUIRED                       | Recipient {0} has no name. Specify a name for the recipient.                                                                                                                                                                                                                             |\n| BULK_SEND_EMAIL_ADDRESS_REQUIRED_FOR_EMAIL_RECIPIENT    | Recipient {0} is an email recipient with no email address. Specify an email for the email recipient.                                                                                                                                                                                     |\n| BULK_SEND_FAX_NUMBER_REQUIRED_FOR_FAX_RECIPIENT         | Recipient {0} is a fax recipient with no fax number. Specify a fax number for the fax recipient.                                                                                                                                                                                         |\n| BULK_SEND_FAX_NUMBER_NOT_VALID                          | Recipient {0} specifies fax number {1}, which is not valid. Specify a valid fax number for the fax recipient.                                                                                                                                                                            |\n| BULK_SEND_EMAIL_ADDRESS_NOT_VALID                       | Recipient {0} specifies email address {1}, which is not a valid email address.  Specify a valid email address for the recipient.                                                                                                                                                         |\n| BULK_SEND_PHONE_NUMBER_REQURED_FOR_SMS_AUTH             | Recipient {0} specifies SMS auth, but no number was provided. Specify a phone number for the SMS auth recipient.                                                                                                                                                                         |\n| BULK_SEND_PHONE_NUMBER_INVALID_FOR_SMS_AUTH             | Recipient {0} specifies phone number {1} for SMS auth, which is not valid. Specify a valid phone number for the SMS auth recipient.                                                                                                                                                      |\n| BULK_SEND_ROLE_NAMES_MUST_BE_UNIQUE                     | Recipient role names cannot be duplicated; role {duplicateRecipientRole} appears multiple times. Use unique roleNames for recipients.                                                                                                                                                    |\n| BULK_SEND_CANNOT_USE_BOTH_ROLE_AND_ID_ON_SAME_RECIPIENT | Recipients cannot have both ID and Role; {0} has both. Specify a roleName or recipientId, but not both for the same recipient.                                                                                                                                                           |\n| BULK_SEND_CANNOT_USE_BOTH_ROLE_AND_ID_IN_SAME_LIST      | Cannot use both recipient role and ID in the same list. Specify a roleName or recipientId, but not both in the same list.                                                                                                                                                                |\n| BULK_SEND_INVALID_ID_CHECK_CONFIGURATION                | Recipient {0} specified SMS authentication, but no SMS auth settings were provided. Provide an SMS auth setting (proper ID configuration) if SMS auth is specified.                                                                                                                      |\n| BULK_SEND_INVALID_SBS_INPUT_CONFIGURATION               | Recipient {0} has more than one signature provider specified. Or signingProviderName is not specified. Or Signature provider : {0} is either unknown or not an available pen for this account. One or more SBS configuration is missing or invalid. The error details provide specifics. |\n| BULK_SEND_TAB_LABELS_MUST_BE_UNIQUE                     | Tab label {0} is duplicated. Needs to be unique. Use a unique tab label.                                                                                                                                                                                                                 |\n| BULK_SEND_TAB_LABEL_REQUIRED                            | Tab label is required. Specify a tab label.                                                                                                                                                                                                                                              |\n| BULK_SEND_TAB_VALUE_REQUIRED                            | Tab Label value is required. Specify a value for the tab label.                                                                                                                                                                                                                          |\n| BULK_SEND_ENVELOPE_CUSTOM_FIELD_NAME_MUST_BE_UNIQUE     | Custom fields must have distinct names. The field {0} appears more than once in a copy. Use unique names for custom fields.                                                                                                                                                              |\n| BULK_SEND_ENVELOPE_CUSTOM_FIELD_NAME_REQUIRED           | All custom fields must have names. Specify a name for the custom field.                                                                                                                                                                                                                  |\n| BULK_SEND_ENVELOPE_CUSTOM_FIELD_VALUE_REQUIRED          | Custom field {0} has no value. A custom field can have an empty value, but it cannot have a null value. Specify a value for the custom field.                                                                                                                                            |";
      operationId: 'BulkSendV2CRUD_PostBulkSendList';
      parameters: [
        {
          description: 'The ID of the account.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/bulkSendingList';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/bulkSendingList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates a bulk send list.';
      tags: ['BulkSend'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createBulkSendList';
      'x-ds-methodname': 'createBulkSendList';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}': {
    delete: {
      deprecated: false;
      description: 'This method deletes a bulk send list.';
      operationId: 'BulkSendV2CRUD_DeleteBulkSendList';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The GUID of the bulk send list. This property is created after you post a new bulk send list.';
          in: 'path';
          name: 'bulkSendListId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/bulkSendingListSummaries';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes a bulk send list.';
      tags: ['BulkSend'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteBulkSendList';
      'x-ds-methodname': 'deleteBulkSendList';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: 'This method returns all of the details associated with a specific bulk send list that belongs to the current user.';
      operationId: 'BulkSendV2CRUD_GetBulkSendList';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The GUID of the bulk send list. This property is created after you post a new bulk send list.';
          in: 'path';
          name: 'bulkSendListId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/bulkSendingList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a specific bulk send list.';
      tags: ['BulkSend'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getBulkSendList';
      'x-ds-methodname': 'getBulkSendList';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method replaces the definition of an existing bulk send list.';
      operationId: 'BulkSendV2CRUD_PutBulkSendList';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The GUID of the bulk send list. This property is created after you post a new bulk send list.';
          in: 'path';
          name: 'bulkSendListId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/bulkSendingList';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/bulkSendingList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates a bulk send list.';
      tags: ['BulkSend'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateBulkSendList';
      'x-ds-methodname': 'updateBulkSendList';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}/send': {
    parameters: [];
    post: {
      deprecated: false;
      description: "This method initiates the bulk send process. It generates a bulk send request based on an [existing bulk send list][create_list] and an envelope or template.\n\nConsider using the [BulkSend::createBulkSendTestRequest][create_test] method to test your bulk send list for compatibility with the envelope or template that you want to send first. To learn about the complete bulk send flow, see the [Bulk Send overview][BulkSendOverview].\n\nIf the envelopes were successfully queued for asynchronous processing, the response contains a `batchId` that you can use to get the status of the batch. If a failure occurs, the API returns an error message.\n\n**Note:** Partial success or failure generally does not occur. Only the entire batch is queued for asynchronous processing.\n\n### Related topics\n\n- [How to bulk send envelopes](/docs/esign-rest-api/how-to/bulk-send-envelopes/)\n\n\n### Errors\n\nThis method returns the following errors:\n\n| Error code                                                 | Description                                                                                                                                                                                                                                                                                            |\n| :--------------------------------------------------------- | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |\n| BULK_SEND_ENVELOPE_NOT_IN_SENDABLE_STATE                   | Envelope {0} is not in a sendable state. The envelope is not complete. Make sure it has a sendable status, such as `created`.                                                                                                                                                                          |\n| BULK_SEND_ENVELOPE_LIST_CONTAINS_NO_COPIES                 | Cannot send an envelope with a bulk sending list which contains no copies.  The list you're trying to bulk send is empty. Make sure the bulk sending list you're using contains recipients.                                                                                                            |\n| BULK_SEND_ENVELOPE_LIST_CONTAINS_TOO_MANY_COPIES           | Bulk sending list contains more than {0} copies. The list you're trying to bulk send will cause your account to exceed the 1,000-copy limit imposed for all accounts. Try sending two or more separate lists.                                                                                          |\n| BULK_SEND_ENVELOPE_CANNOT_BE_NULL                          | Cannot send a bulk list without an envelope. Specify the envelope ID or template ID for the envelope you want to bulk send.                                                                                                                                                                            |\n| BULK_SEND_BLOB_STORE_ERROR                                 | Could not save copy of bulk sending list. An error writing to the database occurred. Try again. If the error persists, contact DocuSign Support.                                                                                                                                                       |\n| BULK_SEND_ACCOUNT_HAS_TOO_MANY_QUEUED_ENVELOPES            | Cannot send this bulk sending list because doing so would exceed the maximum of {maxCopies} in-flight envelopes. This account currently has {unprocessedEnvelopes} envelopes waiting to be processed. Please try again later.\" .Try again later, or contact DocuSign Support to request a higher tier. |\n| BULK_SEND_ENVELOPE_NOT_FOUND                               | Envelope {envelopeOrTemplateId} does not exist or you do not have permission to access it. The envelopeId or templateId specified could not be found. Specify a valid value.                                                                                                                           |\n| BULK_SEND_LIST_NOT_FOUND                                   | Bulk Sending list {listId} does not exist or you do not have permission to access it. The mailingListId specified could not be found. Specify a valid value.                                                                                                                                           |\n| BULK_SEND_ENVELOPE_HAS_NO_RECIPIENTS                       | Bulk sending copy contains recipients, but the specified envelope does not. The recipients on the envelope and the bulk send list do not match. Make sure the envelope and list are compatible for sending.                                                                                            |\n| BULK_SEND_RECIPIENT_ID_DOES_NOT_EXIST_IN_ENVELOPE          | Recipient {0} does not exist in the envelope. Add the missing recipient to the envelope.                                                                                                                                                                                                               |\n| BULK_SEND_RECIPIENT_ID_DOES_NOT_MATCH                      | Recipient ID {envelopeMember.ID} does not match. Make sure the recipient information in the list and the envelope match up.                                                                                                                                                                            |\n| BULK_SEND_ENVELOPE_HAS_BULK_RECIPIENT                      | Recipient {0} is a bulk recipient.  This is not supported. No legacy 'bulk recipient' allowed. In v2.1 of the eSignature API, you must use a bulk send list instead of a bulk recipient. See the API documentation for details.                                                                        |\n| BULK_SEND_RECIPIENT_ROLE_DOES_NOT_MATCH                    | Recipient Role {envelopeMember.RoleName} does not match. Make sure the recipient information in the list and the envelope is compatible.                                                                                                                                                               |\n| BULK_SEND_DUPLICATE_RECIPIENT_DETECTED                     | Duplicate recipients ({0}) not allowed, unless recipients have unique routing order specified on envelope.                                                                                                                                                                                             |\n| BULK_SEND_ENVELOPE_HAS_NO_TABS                             | Bulk sending copy contains tabs, but the specified envelope does not. List and envelope tabs cannot be coalesced. Make sure they are compatible for sending.                                                                                                                                           |\n| BULK_SEND_TAB_LABEL_DOES_NOT_EXIST_IN_ENVELOPE             | Tab with label {0} does not exist in envelope. Add the tab label to the envelope, remove the label from the list, or make sure you're specifying the correct list and envelope.                                                                                                                        |\n| BULK_SEND_TAB_DOES_NOT_MATCH                               | Tab {0} does not match {0} in envelope. A tab exists on the list that does not match or is missing on the envelope. Make sure the tabs on the list and the envelope match.                                                                                                                             |\n| BULK_SEND_ENVELOPE_HAS_NO_ENVELOPE_CUSTOM_FIELDS           | Bulk sending copy contains custom fields, but the specified envelope does not. There are custom fields on the list that the envelope does not have. Make sure that any custom fields on the list and the envelope match.                                                                               |\n| BULK_SEND_ENVELOPE_CUSTOM_FIELD_DOES_NOT_EXIST_IN_ENVELOPE | Custom field {0} does not exist in the envelope. Either add the custom field on the list to the envelope, remove the custom field from the list, or make sure you're specifying the correct list and envelope.                                                                                         |\n| BULK_SEND_ENVELOPE_CUSTOM_FIELD_NAME_DOES_NOT_MATCH        | Custom field names must match. {0} and {1} do not match. The custom field names on the list and the envelope do not match. Use identical names for both.                                                                                                                                               |\n\n[create_list]:      /docs/esign-rest-api/reference/bulkenvelopes/bulksend/createbulksendlist/\n[create_test]:      /docs/esign-rest-api/reference/bulkenvelopes/bulksend/createbulksendtestrequest/\n[BulkSendOverview]: /docs/esign-rest-api/reference/bulkenvelopes/bulksend/\n\n";
      operationId: 'BulkSendV2Send_PostBulkSendRequest';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The GUID of the bulk send list. This property is created after you post a new bulk send list.';
          in: 'path';
          name: 'bulkSendListId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/bulkSendRequest';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/bulkSendResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates a bulk send request.';
      tags: ['BulkSend'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createBulkSendRequest';
      'x-ds-methodname': 'createBulkSendRequest';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/bulk_send_lists/{bulkSendListId}/test': {
    parameters: [];
    post: {
      deprecated: false;
      description: "This method tests a bulk send list for compatibility with the envelope or template that you want to send. For example, a template that has three roles is not compatible with a bulk send list that has only two recipients. For this reason, you might want to test compatibility first.\n\nA successful test result returns `true` for the `canBeSent` property. An unsuccessful test returns a JSON response that contains information about the errors that occurred.\n\nIf the test is successful, you can then send the envelope or template by using the [BulkSend::createBulkSendRequest][BulkSendRequest] method.\n\n## Envelope Compatibility Checks\n\nThis section describes the envelope compatibility checks that the system performs.\n\n**Top-Level Issues**\n\n- Envelopes must be in a sendable state.\n- The bulk send list must contain at least one copy (instance of an envelope), and no more than the maximum number of copies allowed for the account.\n- The envelope must not be null and must be visible to the current user.\n- The account cannot have more queued envelopes than the maximum number configured for the account.\n- The bulk send list must exist.\n\n**Recipients**\n\n- The envelope must have recipients.\n- If you are using an envelope, all of the recipients defined in the bulk send list must have corresponding recipient IDs in the envelope definition. If you are using a template, you must either match the recipient IDs or role IDs.\n- The envelope cannot contain a bulk recipient (an artifact of the legacy version of DocuSign's bulk send\n  functionality).\n\n**Recipient Tabs**\n\n- Every `recipient ID, tab label` pair in the bulk send list must correspond to a tab in the envelope.\n\n**Custom Fields**\n\n- Each envelope-level custom field in the bulk send list must correspond to the name of a `customField` in the\n  envelope definition. You do not have to match the recipient-level custom fields.\n\n[BulkSendRequest]:  /docs/esign-rest-api/reference/bulkenvelopes/bulksend/createbulksendrequest/\n\n\n";
      operationId: 'BulkSendV2Test_PostBulkSendTestRequest';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The GUID of the bulk send list. This property is created after you post a new bulk send list.';
          in: 'path';
          name: 'bulkSendListId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/bulkSendRequest';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/bulkSendTestResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates a bulk send test.';
      tags: ['BulkSend'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createBulkSendTestRequest';
      'x-ds-methodname': 'createBulkSendTestRequest';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/captive_recipients/{recipientPart}': {
    delete: {
      deprecated: false;
      description: 'This method deletes the signature for one or more captive recipient records. It is primarily used for testing. This functionality provides a way to reset the signature associated with a client user ID so that a new signature can be created the next time the client user ID is used.';
      operationId: 'CaptiveRecipients_DeleteCaptiveRecipientsPart';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Signature is the only supported value. ';
          in: 'path';
          name: 'recipientPart';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/captiveRecipientInformation';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/captiveRecipientInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes the signature for one or more captive recipient records.';
      tags: ['Accounts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteCaptiveRecipient';
      'x-ds-methodname': 'deleteCaptiveRecipient';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/chunked_uploads': {
    parameters: [];
    post: {
      deprecated: false;
      description: 'This method initiates a new chunked upload with the first part of the content.';
      operationId: 'ChunkedUploads_PostChunkedUploads';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/chunkedUploadRequest';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/chunkedUploadResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Initiate a new chunked upload.';
      tags: ['ChunkedUploads'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createChunkedUpload';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}': {
    delete: {
      deprecated: false;
      description: 'Deletes a chunked upload that has been committed but not yet consumed.\n\nThis method cannot be used to delete the following types of chunked uploads, which the system deletes automatically:\n\n\n- Chunked uploads that have been consumed by use in another API call.\n- Expired chunked uploads.\n\n**Note:** If you are aware of a chunked upload that can be discarded, the best practice is to explicitly delete it. If you wait for the system to automatically delete it after it expires, the chunked upload will continue to count against your quota.';
      operationId: 'ChunkedUploads_DeleteChunkedUpload';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the chunked upload. ';
          in: 'path';
          name: 'chunkedUploadId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/chunkedUploadResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes a chunked upload.';
      tags: ['ChunkedUploads'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteChunkedUpload';
      'x-ds-service': 'Envelopes';
    };
    get: {
      deprecated: false;
      description: 'Returns the details (but not the content) about a chunked upload.\n\n**Note:** You cannot obtain details about a chunked upload that has expired, been deleted, or consumed by other actions.';
      operationId: 'ChunkedUploads_GetChunkedUpload';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the chunked upload. ';
          in: 'path';
          name: 'chunkedUploadId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '(Optional) This parameter enables you to include additional attribute data in the response. The valid value for this method is `checksum`, which returns an SHA256 checksum of the content of the chunked upload in the response. You can use compare this checksum against your own checksum of the original content to verify that there are no missing parts before you attempt to commit the chunked upload.';
          in: 'query';
          name: 'include';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/chunkedUploadResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieves metadata about a chunked upload.';
      tags: ['ChunkedUploads'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getChunkedUpload';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method checks the integrity of a chunked upload and then commits it. When this request is successful, the chunked upload is then ready to be referenced in other API calls.\n\nIf the request is unsuccessful, ensure that you have uploaded all of the parts by using the Update method.\n\n**Note:** After you commit a chunked upload, it no longer accepts additional parts.';
      operationId: 'ChunkedUploads_PutChunkedUploads';
      parameters: [
        {
          description: '(Required) The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '(Required) The ID of the chunked upload to commit.';
          in: 'path';
          name: 'chunkedUploadId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '(Required) You must use this query parameter with the value `commit`, which affirms the request to validate and prepare the chunked upload for use with other API calls.';
          in: 'query';
          name: 'action';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/chunkedUploadResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Commit a chunked upload.';
      tags: ['ChunkedUploads'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'commit';
      'x-ds-methodname': 'updateChunkedUpload';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}/{chunkedUploadPartSeq}': {
    parameters: [];
    put: {
      deprecated: false;
      description: 'Adds a chunk or part to an existing chunked upload. After you use the Create method to initiate a new chunked upload and upload the first part, \nuse this method to upload subsequent parts.\n\nFor simplicity, DocuSign recommends that you upload the parts in their sequential order ( 1,2, 3, 4, etc.). The Create method adds the first part and assigns it the `sequence` value `0`. As a result, DocuSign recommends that you start with a `sequence` value of `1` when you use this method, and continue uploading parts contiguously until you have uploaded the entirety of the original content to DocuSign.\n\nExample:\n\n\n```\nPUT /v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}/1\nPUT /v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}/2\nPUT /v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}/3\n```\n\n**Note:** You cannot replace a part that DocuSign has already received, or add parts to a chunked upload that is already successfully committed.';
      operationId: 'ChunkedUploads_PutChunkedUploadPart';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the chunked upload. ';
          in: 'path';
          name: 'chunkedUploadId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The sequence or order of the part in the chunked upload. By default, the sequence of the first part that is uploaded as part of the Create request is `0`.\n\n**Note:** You can add parts out of order. However, the chunked upload must consist of a contiguous series of one or more parts before you can successfully commit it.';
          in: 'path';
          name: 'chunkedUploadPartSeq';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/chunkedUploadRequest';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/chunkedUploadResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Add a chunk to an existing chunked upload.';
      tags: ['ChunkedUploads'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateChunkedUploadPart';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/connect': {
    get: {
      deprecated: false;
      description: 'Retrieves all the DocuSign Custom Connect definitions for the specified account.\n\n**Note:** To use this function, you must be an account administrator and Connect must be enabled on your account.';
      operationId: 'Connect_GetConnectConfigs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/connectConfigResults';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Get Connect configuration information.';
      tags: ['ConnectConfigurations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listConfigurations';
      'x-ds-service': 'Connect';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Creates a custom Connect configuration for the specified account.\n\nConnect is a webhook service that provides updates when certain events occur in your eSignature workflows. You can use this endpoint to create:\n* Account-level Connect configurations to listen for events related to any envelopes sent by one or more account users\n* Recipient Connect configurations that are triggered when one or more of your account users receive an envelope\n\nTo set an account-level configuration, set `configurationType` to **custom.**\nTo set a Recipient Connect configuration, set `configurationType` to **customrecipient.**\n\nIf you want to listen for events on only one envelope, use the [eventNotification](/docs/esign-rest-api/reference/envelopes/envelopes/create/#schema__envelopedefinition_eventnotification) object instead.\n\n**Note:** To use this function, you must be an account administrator and Connect must be enabled on your account.\n\n## Data models\n\nThere are four possible data models for your Connect configuration. Consider:\n* Do you want the data in JSON or XML?\n* Do you want events sent individually (SIM) or in aggregate?\n\nDocuSign recommends using the [JSON SIM event model](/platform/webhooks/connect/improved-json-sim-event-model/).\n\n<ds-column>\n\n<ds-step open="false" hideIcon="true">\n<h3>JSON SIM (Recommended)</h3>\n<div>\n\nSet `deliveryMode` to **SIM** and `eventData.version` to **restv2.1.** Use the `events` property to set the event statuses that will trigger your configuration.\n\nThe following sample request shows how to create an envelope-level configuration using JSON SIM:\n```\n{\n  "configurationType": "custom",\n  "urlToPublishTo": "YOUR-WEBHOOK-URL",\n  "allUsers": "true",\n  "name": "jsonSimTest",\n  "deliveryMode": "SIM",\n  "allowEnvelopePublish": "true",\n  "enableLog": "true",\n  "eventData": {\n      "version": "restv2.1"\n  },\n  "events": [\n      "envelope-sent",\n      "envelope-delivered",\n      "envelope-completed"\n  ]\n}\n```\n\nThe following sample request shows how to create a Recipient Connect configuration using JSON SIM:\n```\n{\n  "configurationType": "customrecipient",\n  "urlToPublishTo": "YOUR-WEBHOOK-URL",\n  "allUsers": "true",\n  "name": "jsonSimTest",\n  "deliveryMode": "SIM",\n  "allowEnvelopePublish": "true",\n  "enableLog": "true",\n  "eventData": {\n      "version": "restv2.1"\n  },\n  "events": [\n      "recipient-sent",\n      "recipient-completed"\n  ]\n}\n```\n\n</div></ds-step>\n\n<ds-step open="false" hideIcon="true">\n<h3>JSON Aggregate</h3>\n<div>\n\nSet `deliveryMode` to **aggregate** and `eventData.version` to **restv2.1.** Use the `envelopeEvents` or `recipientEvents` property to set the event statuses that will trigger your configuration.\n\n</div></ds-step>\n\n<ds-step open="false" hideIcon="true">\n<h3>XML Aggregate</h3>\n<div>\n\nSet `deliveryMode` to **aggregate.** Use the `envelopeEvents` or `recipientEvents` property to set the event statuses that will trigger your configuration.\n\n</div></ds-step>\n\n<ds-step open="false" hideIcon="true">\n<h3>XML SIM (Legacy apps only)</h3>\n<div>\n\n**Note:** This model [will be deprecated](https://www.docusign.com/blog/developers/docusign-connect-xml-sim-messaging-format-deprecated). \n\nSet `deliveryMode` to **SIM.** Use the `envelopeEvents` or `recipientEvents` property to set the event statuses that will trigger your configuration.\n\n</div></ds-step>\n</ds-column>\n\n## Troubleshooting\n\nIf your configuration is not working, check the following.\n\n* Connect must be enabled for your account to use this function.\n* If you are using `envelopeEvents` or `recipientEvents`, make sure that the event values are sentence case, not lowercase.\n* Make sure you have either set `allUsers` to **true** or set `userIds` to a non-empty array of IDs.\n* By default, this endpoint creates a disabled configuration. To enable the configuration immediately, set the body parameter `allowEnvelopePublish` to **true.** You can also enable the configuration in the UI.\n* To check if events are being emitted, set `enableLog` to **true** to view event logs in the Connect console.\n\n## Related topics\n\n* For more information about Connect, see the [DocuSign Connect guide](/platform/webhooks/connect/).\n* Use the MyAPICalls sample app to see an [example of this endpoint](https://myapicalls.sampleapps.docusign.com/scenario/6) using the JSON SIM model.';
      operationId: 'Connect_PostConnectConfiguration';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/connectCustomConfiguration';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/connectCustomConfiguration';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates a Connect configuration.';
      tags: ['ConnectConfigurations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createConfiguration';
      'x-ds-service': 'Connect';
    };
    put: {
      deprecated: false;
      description: 'Updates the specified DocuSign Connect configuration in your account. To enable the configuration, set the `allowEnvelopePublish` property to **true.**\n\nAfter any updates, test your configuration to make sure it works as expected.\n\n**Note:** To use this function, you must be an account administrator and Connect must be enabled on your account.';
      operationId: 'Connect_PutConnectConfiguration';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/connectCustomConfiguration';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/connectCustomConfiguration';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates a specified Connect configuration.';
      tags: ['ConnectConfigurations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateConfiguration';
      'x-ds-service': 'Connect';
    };
  };
  '/v2.1/accounts/{accountId}/connect/envelopes/publish/historical': {
    parameters: [];
    post: {
      deprecated: false;
      description: 'This endpoint submits a batch of existing envelopes to a webhook of your choice. Set the webhook address with the `urlToPublishTo` request body parameter.\n\nThis endpoint does not call an existing Connect configuration or create a new Connect listener to monitor new activity. It simply uses an ad hoc configuration to submit existing envelopes. You must include all the configuration data in the request body.\n\nThe envelope data will always be transmitted in JSON format. XML, Salesforce, and eOriginal configuration types are not supported.\n\nYour request should match the following format:\n\n```\n{\n    "envelopes": ["4280f274-xxxx-xxxx-xxxx-b218b7eeda08", "8373a938-xxxx-xxxx-xxxx-e992a2abae01"],\n    "config": {\n        "configurationType":"custom",\n        "name": "Test",\n        "urlToPublishTo":"YOUR-WEBHOOK-URL",\n        "allowEnvelopePublish": "true",\n        "enableLog": "true",\n        "requiresAcknowledgement": "true",\n        "IncludeHMAC": "true",\n        "SignMessageWithX509Cert": "true",\n        "deliveryMode": "SIM",\n        "eventData": {\n            "version": "restv2.1",\n            "format": "json",\n            "includedata": ["tabs","payment_tabs","custom_fields","powerform","recipients","folde rs","extensions","attachments", "prefill_tabs", "documents"]\n        }\n    }\n}\n```\n\nIf the request succeeds, it returns a 201 (Created) HTTP response code and the response body property `processingStatus` will be set to `processing`. You can then view the status of each historical republish request in the [Bulk Actions Log](https://support.docusign.com/s/document-item?language=en_US&bundleId=pik1583277475390&topicId=nvf1648497452396.html&_LANG=enus).';
      operationId: 'HistoricalEnvelopePublish_PostHistoricalEnvelopePublishTransaction';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/connectHistoricalEnvelopeRepublish';
            };
          };
        };
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopePublishTransaction';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Submits a batch of historical envelopes for republish to a webhook.';
      tags: ['EnvelopePublish'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createHistoricalEnvelopePublishTransaction';
      'x-ds-methodname': 'createHistoricalEnvelopePublishTransaction';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/connect/envelopes/retry_queue': {
    parameters: [];
    put: {
      deprecated: false;
      description: 'Republishes Connect information for the  specified set of envelopes. The primary use is to republish Connect post failures by including envelope IDs for the envelopes that failed to post in the request. The list of envelope IDs that failed to post correctly can be retrieved by calling to [Connect::listEventLogs](/docs/esign-rest-api/reference/connect/connectevents/list/) retrieve the failure log.\n\n**Note:** To use this function, you must be an account administrator and Connect must be enabled on your account.';
      operationId: 'ConnectPublish_PutConnectRetry';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/connectFailureFilter';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/connectFailureResults';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Republishes Connect information for multiple envelopes.';
      tags: ['ConnectEvents'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'retryForEnvelopes';
      'x-ds-methodname': 'retryEventForEnvelopes';
      'x-ds-service': 'Connect';
    };
  };
  '/v2.1/accounts/{accountId}/connect/envelopes/{envelopeId}/retry_queue': {
    parameters: [];
    put: {
      deprecated: false;
      description: 'Republishes Connect information for the specified envelope.\n\n**Note:** To use this function, you must be an account administrator and Connect must be enabled on your account.';
      operationId: 'ConnectPublish_PutConnectRetryByEnvelope';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/connectFailureResults';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Republishes Connect information for the specified envelope.';
      tags: ['ConnectEvents'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'retryForEnvelope';
      'x-ds-methodname': 'retryEventForEnvelope';
      'x-ds-service': 'Connect';
    };
  };
  '/v2.1/accounts/{accountId}/connect/failures': {
    get: {
      deprecated: false;
      description: 'Retrieves the Connect failure log information. You can use this log to determine which envelopes failed to post, in order to create a republish request.\n\n**Note:** To use this function, you must be an account administrator and Connect must be enabled on your account.';
      operationId: 'ConnectFailures_GetConnectLogs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The start date for a date range in UTC DateTime format.\n\n**Note:** If this property is null, no date filtering is applied.';
          in: 'query';
          name: 'from_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The end of a search date range in UTC DateTime format. When you use this parameter, only templates created up to this date and time are returned.\n\n**Note:** If this property is null, the value defaults to the current date.';
          in: 'query';
          name: 'to_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/connectLogs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the Connect failure log information.';
      tags: ['ConnectEvents'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'listFailures';
      'x-ds-methodname': 'listEventFailureLogs';
      'x-ds-service': 'Connect';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/connect/failures/{failureId}': {
    delete: {
      deprecated: false;
      description: 'Deletes the Connect failure log information for the specified entry.\n\n**Note:** To use this function, you must be an account administrator and Connect must be enabled on your account.';
      operationId: 'ConnectFailures_DeleteConnectFailureLog';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the Connect post failure. Use `all` to delete all failures for the account.';
          in: 'path';
          name: 'failureId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/connectDeleteFailureResult';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes a Connect failure log entry.';
      tags: ['ConnectEvents'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteFailure';
      'x-ds-methodname': 'deleteEventFailureLog';
      'x-ds-service': 'Connect';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/connect/logs': {
    delete: {
      deprecated: false;
      description: 'Deletes a list of Connect log entries for your account.\n\n**Note:** To use this function, you must be an account administrator and Connect must be enabled on your account.';
      operationId: 'ConnectLog_DeleteConnectLogs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes a list of Connect log entries.';
      tags: ['ConnectEvents'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteList';
      'x-ds-methodname': 'deleteEventLogs';
      'x-ds-service': 'Connect';
    };
    get: {
      deprecated: false;
      description: 'Retrieves a list of the 100 most recent connect log entries for your account.\n\nThe `enableLog` setting in the Connect configuration must be set to **true** to enable logging.\nIf logging is not enabled, then no log entries are recorded.\n\n**Note:** To use this function, you must be an account administrator and Connect must be enabled on your account.';
      operationId: 'ConnectLog_GetConnectLogs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The start date for a date range in UTC DateTime format.\n\n**Note:** If this property is null, no date filtering is applied.';
          in: 'query';
          name: 'from_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The end of a search date range in UTC DateTime format. When you use this parameter, only templates created up to this date and time are returned.\n\n**Note:** If this property is null, the value defaults to the current date.';
          in: 'query';
          name: 'to_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/connectLogs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the Connect log.';
      tags: ['ConnectEvents'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listEventLogs';
      'x-ds-service': 'Connect';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/connect/logs/{logId}': {
    delete: {
      deprecated: false;
      description: 'Deletes a specified entry from the Connect Log.\n\n**Note:** To use this function, you must be an account administrator and Connect must be enabled on your account.';
      operationId: 'ConnectLog_DeleteConnectLog';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the Connect log entry.';
          in: 'path';
          name: 'logId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes a specified Connect log entry.';
      tags: ['ConnectEvents'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteEventLog';
      'x-ds-service': 'Connect';
    };
    get: {
      deprecated: false;
      description: 'Retrieves the specified Connect log entry for your account.\n\nThe `enableLog` setting in the Connect configuration must be set to **true** to enable logging.\nIf logging is not enabled, then no log entries are recorded.\n\n**Note:** To use this function, you must be an account administrator and Connect must be enabled on your account.';
      operationId: 'ConnectLog_GetConnectLog';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the Connect log entry.';
          in: 'path';
          name: 'logId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the response includes the `connectDebugLog` information.';
          in: 'query';
          name: 'additional_info';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/connectLog';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a Connect log entry.';
      tags: ['ConnectEvents'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getEventLog';
      'x-ds-service': 'Connect';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/connect/oauth': {
    delete: {
      deprecated: false;
      description: 'Deletes the Connect OAuth configuration for the specified account.\n\n**Note:** To use this function, you must be an account administrator and Connect must be enabled on your account.\n\n## Related topics:\n- [OAuth for DocuSign Connect](/platform/webhooks/connect/validation-and-security/oauth-connect/)\n';
      operationId: 'ConnectOAuthConfig_DeleteConnectOAuthConfig';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Delete the Connect OAuth configuration.';
      tags: ['ConnectConfigurations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteConnectOAuthConfig';
      'x-ds-methodname': 'deleteConnectOAuthConfig';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: 'Gets the Connect OAuth configuration for the specified account.\n\n**Note:** To use this function, you must be an account administrator and Connect must be enabled on your account.\n\n## Related topics:\n- [OAuth for DocuSign Connect](/platform/webhooks/connect/validation-and-security/oauth-connect/)\n';
      operationId: 'ConnectOAuthConfig_GetConnectOAuthConfig';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/connectOAuthConfig';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieves the Connect OAuth information for the account.';
      tags: ['ConnectConfigurations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getConnectOAuthConfig';
      'x-ds-methodname': 'getConnectOAuthConfig';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: "Sets up Connect OAuth for the specified account using an authorization server of your choice. To use this endpoint, get the client ID and client secret from your authorization server.\n\nWhen you call this endpoint, DocuSign requests an access token from your authorization server. DocuSign will use that token in the Authorization HTTP header of your account's Connect messages. Finally, your listener will be responsible for validating the token by calling the authorization server.\n\n**Note:** To use this function, you must be an account administrator and Connect must be enabled on your account.\n\n## Related topics:\n- [OAuth for DocuSign Connect](/platform/webhooks/connect/validation-and-security/oauth-connect/)\n";
      operationId: 'ConnectOAuthConfig_PostConnectOAuthConfig';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/connectOAuthConfig';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/connectOAuthConfig';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Set up Connect OAuth for the specified account.';
      tags: ['ConnectConfigurations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createConnectOAuthConfig';
      'x-ds-methodname': 'createConnectOAuthConfig';
      'x-ds-service': 'Uncategorized';
    };
    put: {
      deprecated: false;
      description: '';
      operationId: 'ConnectOAuthConfig_PutConnectOAuthConfig';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/connectOAuthConfig';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/connectOAuthConfig';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the existing Connect OAuth configuration for the account.\n';
      tags: ['ConnectConfigurations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateConnectOAuthConfig';
      'x-ds-methodname': 'updateConnectOAuthConfig';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/connect/{connectId}': {
    delete: {
      deprecated: false;
      description: 'Deletes the specified DocuSign Connect configuration.\n\n**Note:** To use this function, you must be an account administrator and Connect must be enabled on your account.\n\n\n';
      operationId: 'Connect_DeleteConnectConfig';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the custom Connect configuration being accessed.';
          in: 'path';
          name: 'connectId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes the specified Connect configuration.';
      tags: ['ConnectConfigurations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteConfiguration';
      'x-ds-service': 'Connect';
    };
    get: {
      deprecated: false;
      description: 'Retrieves the information for the specified DocuSign Connect configuration.\n\n**Note:** To use this function, you must be an account administrator and Connect must be enabled on your account.\n';
      operationId: 'Connect_GetConnectConfig';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the custom Connect configuration being accessed.';
          in: 'path';
          name: 'connectId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/connectConfigResults';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the details about a Connect configuration.';
      tags: ['ConnectConfigurations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getConfiguration';
      'x-ds-service': 'Connect';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/connect/{connectId}/all/users': {
    get: {
      deprecated: false;
      description: 'Returns all users from the configured Connect service.\n\n**Note:** To use this function, you must be an account administrator and Connect must be enabled on your account.';
      operationId: 'Connect_GetConnectAllUsers';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the custom Connect configuration being accessed.';
          in: 'path';
          name: 'connectId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'domain_users_only';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters returned user records by full email address or a substring of email address.';
          in: 'query';
          name: 'email_substring';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The position within the total result set from which to start returning values. The value **thumbnail** may be used to return the page image.';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The status of the item.';
          in: 'query';
          name: 'status';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters results based on a full or partial user name.\n\n**Note:** When you enter a partial user name, you do not use a wildcard character.';
          in: 'query';
          name: 'user_name_substring';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/integratedConnectUserInfoList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns all users from the configured Connect service.';
      tags: ['ConnectConfigurations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getConnectAllUsers';
      'x-ds-methodname': 'getConnectAllUsers';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/connect/{connectId}/users': {
    get: {
      deprecated: false;
      description: 'Returns users from the configured Connect service.\n\n**Note:** To use this function, you must be an account administrator and Connect must be enabled on your account.';
      operationId: 'Connect_GetConnectUsers';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the custom Connect configuration being accessed.';
          in: 'path';
          name: 'connectId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.\n\nUse `start_position` to specify the number of results to skip.\n\n';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters returned user records by full email address or a substring of email address.';
          in: 'query';
          name: 'email_substring';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'list_included_users';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nUse with `count` to limit the number\nof results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters the results by user status.\nYou can specify a comma-separated\nlist of the following statuses:\n\n* ActivationRequired \n* ActivationSent \n* Active\n* Closed \n* Disabled\n';
          in: 'query';
          name: 'status';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters results based on a full or partial user name.\n\n**Note:** When you enter a partial user name, you do not use a wildcard character.';
          in: 'query';
          name: 'user_name_substring';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/integratedUserInfoList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns users from the configured Connect service.';
      tags: ['ConnectConfigurations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'listUsers';
      'x-ds-methodname': 'connectUsers';
      'x-ds-service': 'Connect';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/consumer_disclosure': {
    get: {
      deprecated: false;
      description: 'Retrieves the default, HTML-formatted Electronic Record and Signature Disclosure (ERSD) associated with the account. \n\nThis is the default ERSD disclosure that DocuSign provides for the convenience of U.S.-based customers only. This default disclosure is only valid for transactions between U.S.-based parties.\n\nTo set the language of the disclosure that you want to retrieve, use the optional `langCode` query parameter.';
      operationId: 'ConsumerDisclosure_GetConsumerDisclosure';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The code for the signer language version of the disclosure that you want to retrieve. The following languages are supported:\n\n- Arabic (`ar`)\n- Bulgarian (`bg`)\n- Czech (`cs`)\n- Chinese Simplified (`zh_CN`)\n- Chinese Traditional (`zh_TW`)\n- Croatian (`hr`)\n- Danish (`da`)\n- Dutch (`nl`)\n- English US (`en`)\n- English UK (`en_GB`)\n- Estonian (`et`)\n- Farsi (`fa`)\n- Finnish (`fi`)\n- French (`fr`)\n- French Canadian (`fr_CA`)\n- German (`de`)\n- Greek (`el`)\n- Hebrew (`he`)\n- Hindi (`hi`)\n- Hungarian (`hu`)\n- Bahasa Indonesian (`id`)\n- Italian (`it`)\n- Japanese (`ja`)\n- Korean (`ko`)\n- Latvian (`lv`)\n- Lithuanian (`lt`)\n- Bahasa Melayu (`ms`)\n- Norwegian (`no`)\n- Polish (`pl`)\n- Portuguese (`pt`)\n- Portuguese Brazil (`pt_BR`)\n- Romanian (`ro`)\n- Russian (`ru`)\n- Serbian (`sr`)\n- Slovak (`sk`)\n- Slovenian (`sl`)\n- Spanish (`es`)\n- Spanish Latin America (`es_MX`)\n- Swedish (`sv`)\n- Thai (`th`)\n- Turkish (`tr`)\n- Ukrainian (`uk`)\n- Vietnamese (`vi`)\n\nAdditionally, you can automatically detect the browser language being used by the viewer and display the disclosure in that language by setting the value to `browser`.';
          in: 'query';
          name: 'langCode';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/AccountConsumerDisclosures';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the default Electronic Record and Signature Disclosure for an account.';
      tags: ['AccountConsumerDisclosures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getDefault';
      'x-ds-methodname': 'getConsumerDisclosureDefault';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/consumer_disclosure/{langCode}': {
    get: {
      deprecated: false;
      description: 'Retrieves the HTML-formatted Electronic Record and Signature Disclosure (ERSD) associated with the account. \n\nTo set the language of the disclosure that you want to retrieve, use the optional `langCode` query parameter.\n\n**Note:** The text of the default disclosure is always in English, but if you are using a custom disclosure and have created versions of it in different signer languages, you can use the `langCode` parameter to specify the signer language version that you want to retrieve.  ';
      operationId: 'ConsumerDisclosure_GetConsumerDisclosureLangCode';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The code for the signer language version of the disclosure that you want to retrieve. The following languages are supported:\n\n- Arabic (`ar`)\n- Bulgarian (`bg`)\n- Czech (`cs`)\n- Chinese Simplified (`zh_CN`)\n- Chinese Traditional (`zh_TW`)\n- Croatian (`hr`)\n- Danish (`da`)\n- Dutch (`nl`)\n- English US (`en`)\n- English UK (`en_GB`)\n- Estonian (`et`)\n- Farsi (`fa`)\n- Finnish (`fi`)\n- French (`fr`)\n- French Canadian (`fr_CA`)\n- German (`de`)\n- Greek (`el`)\n- Hebrew (`he`)\n- Hindi (`hi`)\n- Hungarian (`hu`)\n- Bahasa Indonesian (`id`)\n- Italian (`it`)\n- Japanese (`ja`)\n- Korean (`ko`)\n- Latvian (`lv`)\n- Lithuanian (`lt`)\n- Bahasa Melayu (`ms`)\n- Norwegian (`no`)\n- Polish (`pl`)\n- Portuguese (`pt`)\n- Portuguese Brazil (`pt_BR`)\n- Romanian (`ro`)\n- Russian (`ru`)\n- Serbian (`sr`)\n- Slovak (`sk`)\n- Slovenian (`sl`)\n- Spanish (`es`)\n- Spanish Latin America (`es_MX`)\n- Swedish (`sv`)\n- Thai (`th`)\n- Turkish (`tr`)\n- Ukrainian (`uk`)\n- Vietnamese (`vi`)\n\nAdditionally, you can automatically detect the browser language being used by the viewer and display the disclosure in that language by setting the value to `browser`.';
          in: 'path';
          name: 'langCode';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/AccountConsumerDisclosures';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the Electronic Record and Signature Disclosure for an account.';
      tags: ['AccountConsumerDisclosures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getConsumerDisclosure';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Account administrators can use this method to perform the following tasks:\n\n- Customize values in the default disclosure.\n- Switch to a custom disclosure that uses your own text and HTML formatting.\n- Change values in your existing consumer disclosure. \n\nTo specify the signer language version of the disclosure that you are updating, use the optional `langCode` query parameter.\n\n**Note:** Only account administrators can use this method. Each time you change the disclosure content, all unsigned recipients of outstanding documents will be required to accept a new version. \n\n## Updating the default disclosure\n\nWhen you update the default disclosure, you can edit all properties except for the following ones:\n\n- `accountEsignId`: This property is read-only.\n- `custom`: The default value is **false.** Editing this property causes the default disclosure to switch to a custom disclosure.\n- `esignAgreement`: This property is read-only.\n- `esignText`: You cannot edit this property when `custom` is set to **false.** The API returns a 200 OK HTTP response, but does not update the `esignText`.\n- Metadata properties: These properties are read-only.\n\n**Note:** The text of the default disclosure is always in English.\n\n## Switching to a custom disclosure\n\nTo switch to a custom disclosure, set the `custom` property to **true** and customize the value for the `eSignText` property. \n\nYou can also edit all of the other properties except for the following ones:\n\n- `accountEsignId`: This property is read-only.\n- `esignAgreement`: This property is read-only.\n- Metadata properties: These properties are read-only.\n\n**Note:** When you use a custom disclosure, you can create versions of it in different signer languages and se the `langCode` parameter to specify the signer language version that you are updating.\n\n**Important:**  When you switch from a default to a custom disclosure, note the following information:\n\n- You will not be able to return to using the default disclosure.\n- Only the disclosure for the currently selected signer language is saved. DocuSign will not automatically translate your custom disclosure. You must create a disclosure for each language that your signers use.\n\n## Updating a custom disclosure\n\nWhen you update a custom disclosure, you can update all of the properties except for the following ones:\n\n- `accountEsignId`: This property is read-only. \n- `esignAgreement`: This property is read-only.\n- Metadata properties: These properties are read-only.\n\n**Important:** Only the disclosure for the currently selected signer language is saved. DocuSign will not automatically translate your custom disclosure. You must create a disclosure for each language that your signers use.\n\n';
      operationId: 'ConsumerDisclosure_PutConsumerDisclosure';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The code for the signer language version of the disclosure that you want to update. The following languages are supported:\n\n- Arabic (`ar`)\n- Bulgarian (`bg`)\n- Czech (`cs`)\n- Chinese Simplified (`zh_CN`)\n- Chinese Traditional (`zh_TW`)\n- Croatian (`hr`)\n- Danish (`da`)\n- Dutch (`nl`)\n- English US (`en`)\n- English UK (`en_GB`)\n- Estonian (`et`)\n- Farsi (`fa`)\n- Finnish (`fi`)\n- French (`fr`)\n- French Canadian (`fr_CA`)\n- German (`de`)\n- Greek (`el`)\n- Hebrew (`he`)\n- Hindi (`hi`)\n- Hungarian (`hu`)\n- Bahasa Indonesian (`id`)\n- Italian (`it`)\n- Japanese (`ja`)\n- Korean (`ko`)\n- Latvian (`lv`)\n- Lithuanian (`lt`)\n- Bahasa Melayu (`ms`)\n- Norwegian (`no`)\n- Polish (`pl`)\n- Portuguese (`pt`)\n- Portuguese Brazil (`pt_BR`)\n- Romanian (`ro`)\n- Russian (`ru`)\n- Serbian (`sr`)\n- Slovak (`sk`)\n- Slovenian (`sl`)\n- Spanish (`es`)\n- Spanish Latin America (`es_MX`)\n- Swedish (`sv`)\n- Thai (`th`)\n- Turkish (`tr`)\n- Ukrainian (`uk`)\n- Vietnamese (`vi`)\n\nAdditionally, you can automatically detect the browser language being used by the viewer and display the disclosure in that language by setting the value to `browser`.';
          in: 'path';
          name: 'langCode';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '(Optional) When true, the response includes metadata indicating which properties are editable.';
          in: 'query';
          name: 'include_metadata';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/consumerDisclosure';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/consumerDisclosure';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the Electronic Record and Signature Disclosure for an account.';
      tags: ['AccountConsumerDisclosures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateConsumerDisclosure';
      'x-ds-service': 'Accounts';
    };
  };
  '/v2.1/accounts/{accountId}/contacts': {
    delete: {
      deprecated: false;
      description: 'This method deletes multiple contacts associated with an account.';
      operationId: 'Contacts_DeleteContacts';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/contactModRequest';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/contactUpdateResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes multiple contacts from an account.';
      tags: ['Contacts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteList';
      'x-ds-methodname': 'deleteContacts';
      'x-ds-service': 'Users';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'This method adds multiple contacts into a contacts list.';
      operationId: 'Contacts_PostContacts';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/contactModRequest';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/contactUpdateResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Add contacts to a contacts list.';
      tags: ['Contacts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'postContacts';
      'x-ds-service': 'Users';
    };
    put: {
      deprecated: false;
      description: 'This method updates one or more contacts associated with an account.';
      operationId: 'Contacts_PutContacts';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/contactModRequest';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/contactUpdateResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates one or more contacts.';
      tags: ['Contacts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'putContacts';
      'x-ds-service': 'Users';
    };
  };
  '/v2.1/accounts/{accountId}/contacts/{contactId}': {
    delete: {
      deprecated: false;
      description: 'This method deletes a contact associated with an account.';
      operationId: 'Contacts_DeleteContactWithId';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of a contact person in the account's address book.";
          in: 'path';
          name: 'contactId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/contactUpdateResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes a contact.';
      tags: ['Contacts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteContactWithId';
      'x-ds-service': 'Users';
    };
    get: {
      deprecated: false;
      description: "This method returns one or more contacts\nassociated with a DocuSign account. You can also\nretrieve contacts from connected [cloud storage][CloudStorage] providers by using the\n`cloud_provider` query parameter. By default,\ncontacts are retrieved from the DocuSign account's\ndefault address book.\n\nTo return a specific contact, use the `contactId`\nquery parameter. To return all contacts associated\nwith an account, omit this parameter.\n\n[CloudStorage]: /docs/esign-rest-api/reference/cloudstorage/";
      operationId: 'Contacts_GetContactById';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of a contact person in the account's address book.\n\n**Note:** To return all contacts, omit this parameter. It is not required.";
          in: 'path';
          name: 'contactId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '(Optional) The cloud provider from which to retrieve the contacts. Valid values are:\n\n- `rooms`\n- `docusignCore` (default)';
          in: 'query';
          name: 'cloud_provider';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/contactGetResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets one or more contacts.';
      tags: ['Contacts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getContactById';
      'x-ds-service': 'Users';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/custom_fields': {
    get: {
      deprecated: false;
      description: 'This method returns a list of the envelope and document custom fields associated with an account.';
      operationId: 'AccountCustomFields_GetAccountCustomFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/AccountCustomFields';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a list of custom fields.';
      tags: ['AccountCustomFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listCustomFields';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'This method creates a custom field and makes it available for all new envelopes associated with an account.';
      operationId: 'AccountCustomFields_PostAccountCustomFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '(Optional) When **true,** the new custom field is applied to all of the templates on the account.';
          in: 'query';
          name: 'apply_to_templates';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/customField';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/AccountCustomFields';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates an account custom field.';
      tags: ['AccountCustomFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createCustomField';
      'x-ds-service': 'Accounts';
    };
  };
  '/v2.1/accounts/{accountId}/custom_fields/{customFieldId}': {
    delete: {
      deprecated: false;
      description: 'This method deletes an existing account custom field.';
      operationId: 'AccountCustomFields_DeleteAccountCustomFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'customFieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'apply_to_templates';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes an account custom field.';
      tags: ['AccountCustomFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteCustomField';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method updates an existing account custom field.';
      operationId: 'AccountCustomFields_PutAccountCustomFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the custom field.';
          in: 'path';
          name: 'customFieldId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'apply_to_templates';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/customField';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/AccountCustomFields';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates an account custom field.';
      tags: ['AccountCustomFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateCustomField';
      'x-ds-service': 'Accounts';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes': {
    get: {
      deprecated: false;
      description: 'This method lets you\n[search for envelopes](/docs/esign-rest-api/esign101/concepts/envelopes/)\nin your accounts.\nA large set of filters let you narrow the scope of your search\nby date,\nby envelope ID,\nor by status codes.\nYour request must include one or more of the following parameters:\n\n* `from_date`\n* `envelope_ids`\n* `transaction_ids`\n\n\nTo avoid unnecessary database queries, the DocuSign\nsignature platform first checks requests to ensure that the\nfilter set supplied does not result in a zero-size response\nbefore querying the database.\n\nFor example, for a request with a `from_to_status` of\n`delivered` and a current `status` of `created,sent`,\nDocuSign will always return an empty list.\nThis is because the request translates to: find the\nenvelopes that were delivered between the `from_date` and\n`to_date` dates that have a current status of `created` or\n`sent`. Since an envelope that has been delivered can\nnever have a status of `created` or `sent`, a zero-size\nresponse would be generated.\nIn this case, DocuSign does not query the database\nand returns an empty list immediately.\n\nGetting envelope status using `transaction_ids` is useful\nfor offline signing situations where it can be used\ndetermine if an envelope was created or not. It can be used\nfor the cases where a network connection was lost, before\nthe envelope status could be returned.\n\n\nThe following table shows the valid current envelope\nstatuses (`status` parameter) for the different status\nqualifiers (`from_to_status` parameter) in the request. If\nthe status and status qualifiers in the API request do not\ncontain any of the values shown in the Valid Current\nStatuses column, then an empty list is returned.\n\nClient applications should check that the statuses (`status`\nparameter) they are requesting make sense for a given\n`from_to_status` parameter value.\n\n| Status Qualifier<br>(`from_to_status`) | Effective Status Qualifier | Valid Current Statuses                                                      |\n| :------------------------------------- | :------------------------- | :-------------------------------------------------------------------------- |\n| any (changed)                          | StatusChanged              | any, created, sent, delivered, signed, completed, declined, voided, deleted |\n| created                                | Created                    | any, created, sent, delivered, signed, completed, declined, voided, deleted |\n| sent                                   | Sent                       | any, sent, delivered, signed, completed, declined, voided, deleted          |\n| delivered                              | StatusChanged              | any, delivered, signed, completed, declined, voided, deleted                |\n| signed                                 | StatusChanged              | any, signed, completed, declined, voided, deleted                           |\n| completed                              | Completed                  | any, completed, declined, voided, deleted                                   |\n| declined                               | StatusChanged              | any, declined, voided, deleted                                              |\n| timedout<br>always return zero results | StatusChanged              | any, voided, deleted                                                        |\n| voided                                 | Voided                     | any, voided, deleted                                                        |\n| deleted                                | StatusChanged              | any, deleted                                                                |\n\n## Extraneous results\n\nIn some cases, a request for a specific envelope status will\ninclude envelopes with additional statuses. For example, in\na request with a `from_date` of 2017-01-01, a `to_date` of\n2017-01-07 and the status qualifier (`from_to_status`) set\nto `delivered`, the response set might contain envelopes\nthat were created during that time period, but not delivered\nduring the time period. As a workaround, check the envelope\nstatus values in the result set as needed.\n\n\n### Related topics\n\n- [Searching for envelopes](/docs/esign-rest-api/esign101/concepts/envelopes/search/)\n- [How to list envelope status changes](/docs/esign-rest-api/how-to/list-envelope-status-changes/)\n';
      operationId: 'Envelopes_GetEnvelopes';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies the Authoritative Copy Status for the envelopes. Valid values: Unknown, Original, Transferred, AuthoritativeCopy, AuthoritativeCopyExportPending, AuthoritativeCopyExported, DepositPending, Deposited, DepositedEO, or DepositFailed.';
          in: 'query';
          name: 'ac_status';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Reserved for DocuSign.\n';
          in: 'query';
          name: 'block';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Reserved for DocuSign.\n';
          in: 'query';
          name: 'cdse_mode';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Reserved for DocuSign.';
          in: 'query';
          name: 'continuation_token';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.\n\nUse `start_position` to specify the number of results to skip.\n';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Optional. Specifies an envelope custom field name and value searched for in the envelopes. Format: `custom_envelope_field_name=desired_value`\n\nExample: If you have an envelope custom field named "Region" and you want to search for all envelopes where the value is "West" you would use set this parameter to `Region=West`. \n \n';
          in: 'query';
          name: 'custom_field';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Limit results to envelopes\nsent by the account user\nwith this email address.\n\n`user_name` must be given as well,\nand both `email` and `user_name`\nmust refer to an existing account user.\n';
          in: 'query';
          name: 'email';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Comma separated list of `envelopeId` values.';
          in: 'query';
          name: 'envelope_ids';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Excludes information from the response. Enter  as a comma-separated list (e.g., `folders,powerforms`). Valid values are:\n\n- `recipients`\n- `powerforms`\n- `folders`';
          in: 'query';
          name: 'exclude';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Returns the envelopes from specific folders. Enter as a comma-separated list of either valid folder Guids or the following values: \n\n- `awaiting_my_signature`\n- `completed`\n- `draft`\n- `drafts`\n- `expiring_soon`\n- `inbox`\n- `out_for_signature`\n- `recyclebin`\n- `sentitems`\n- `waiting_for_others`';
          in: 'query';
          name: 'folder_ids';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of folder types you want to retrieve envelopes from. Valid values are: \n\n- `normal`\n- `inbox`\n- `sentitems`\n- `draft`\n- `templates`';
          in: 'query';
          name: 'folder_types';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: "Specifies the date and time\nto start looking for status changes.\nThis parameter is required\nunless `envelopeIds` or `transactionIds`\nare set.\n\n\nAlthough you can use any date format\nsupported by the .NET system library's\n[`DateTime.Parse()`][msoft] function,\nDocuSign recommends\nusing [ISO 8601][] format dates\nwith an explicit time zone offset\nIf you do not provide\na time zone offset,\nthe method uses the server's time zone.\n\nFor example, the following dates and times refer to the same instant:\n\n* `2017-05-02T01:44Z`\n* `2017-05-01T21:44-04:00`\n* `2017-05-01T18:44-07:00`\n\n\n[msoft]: https://docs.microsoft.com/en-us/dotnet/api/system.datetime.parse?redirectedfrom=MSDN&view=net-5.0#overloads\n[ISO 8601]: https://en.wikipedia.org/wiki/ISO_8601";
          in: 'query';
          name: 'from_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'This is the status type checked for in the `from_date`/`to_date` period. If `changed` is specified, then envelopes that changed status during the period are found. If for example, `created` is specified, then envelopes created during the period are found. Default is `changed`. \n\nPossible values are: Voided, Changed, Created, Deleted, Sent, Delivered, Signed, Completed, Declined, TimedOut and Processing.';
          in: 'query';
          name: 'from_to_status';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies additional information to return  about the envelopes.\nUse a comma-separated list, such as `folders, recipients` to specify information.\nValid values are:\n\n- `custom_fields`: The custom fields associated with the envelope.\n- `documents`: The documents associated with the envelope.\n- `attachments`: The attachments associated with the envelope.\n- `extensions`: Information about the email settings associated with the envelope.\n- `folders`: The folders where the envelope exists.\n- `recipients`: The recipients associated with the envelope.\n- `powerform`: The PowerForms associated with the envelope.\n- `payment_tabs`: The payment tabs associated with the envelope.\n';
          in: 'query';
          name: 'include';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** information about envelopes that have been deleted is included in the response.';
          in: 'query';
          name: 'include_purge_information';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of folders that you want want to get envelopes from. Valid values are: \n\n- `normal`\n- `inbox`\n- `sentitems`\n- `draft`\n- `templates`';
          in: 'query';
          name: 'intersecting_folder_ids';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Returns envelopes that were modified prior to the specified date and time. \n\nExample: `2020-05-09T21:56:12.2500000Z`';
          in: 'query';
          name: 'last_queried_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Returns envelopes in either ascending (`asc`) or descending (`desc`) order.';
          in: 'query';
          name: 'order';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Sorts results according to a specific property. Valid values are:\n\n- `last_modified`\n- `action_required`\n- `created`\n- `completed`\n- `envelope_name`\n- `expire`\n- `sent`\n- `signer_list`\n- `status`\n- `subject`\n- `user_name`\n- `status_changed`\n- `last_modified`';
          in: 'query';
          name: 'order_by';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of `PowerFormId` values.';
          in: 'query';
          name: 'powerformids';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The time in seconds that the query should run before returning data.';
          in: 'query';
          name: 'query_budget';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'requester_date_format';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Free text search criteria that you can use to filter the list of envelopes that is returned.';
          in: 'query';
          name: 'search_text';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nUse with `count` to limit the number\nof results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of current envelope statuses to included in the response. Possible values are:\n\n* `completed`\n* `created`\n* `declined`\n* `deleted`\n* `delivered`\n* `processing`\n* `sent`\n* `signed`\n* `timedout`\n* `voided`\n\nThe `any` value is equivalent to any status.\n';
          in: 'query';
          name: 'status';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: "Specifies the date and time\nto stop looking for status changes.\nThe default is the current date and time.\n\nAlthough you can use any date format\nsupported by the .NET system library's\n[`DateTime.Parse()`][msoft] function,\nDocuSign recommends\nusing [ISO 8601][] format dates\nwith an explicit time zone offset\nIf you do not provide\na time zone offset,\nthe method uses the server's time zone.\n\nFor example, the following dates and times refer to the same instant:\n\n* `2017-05-02T01:44Z`\n* `2017-05-01T21:44-04:00`\n* `2017-05-01T18:44-07:00`\n\n\n[msoft]: https://docs.microsoft.com/en-us/dotnet/api/system.datetime.parse?redirectedfrom=MSDN&view=net-5.0#overloads\n[ISO 8601]: https://en.wikipedia.org/wiki/ISO_8601\n";
          in: 'query';
          name: 'to_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'If included in the query string, this is a comma separated list of envelope `transactionId`s. \n\nIf included in the `request_body`, this is a list of envelope `transactionId`s. \n\n###### Note: `transactionId`s are only valid in the DocuSign system for seven days.\n';
          in: 'query';
          name: 'transaction_ids';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Returns envelopes where the current user is the recipient, the sender, or the recipient only. (For example, `user_filter=sender`.) Valid values are:\n\n- `sender`\n- `recipient`\n- `recipient_only`';
          in: 'query';
          name: 'user_filter';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the user who created the envelopes to be retrieved. Note that an account can have multiple users, and any user with account access can retrieve envelopes by user_id from the account.';
          in: 'query';
          name: 'user_id';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Limit results to envelopes\nsent by the account user\nwith this user name.\n\n`email` must be given as well,\nand both `email` and `user_name`\nmust refer to an existing account user.\n';
          in: 'query';
          name: 'user_name';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopesInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Search for specific sets of envelopes by using search filters.';
      tags: ['Envelopes'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'listStatusChanges';
      'x-ds-methodname': 'listStatusChanges';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: "Creates and sends an envelope or creates a draft envelope.\nEnvelopes are fundamental resources in the DocuSign platform.\n\n\nWith this method you can:\n\n* Create and send an envelope\n  with [documents][], [recipients][], and [tabs][].\n* [Create and send an envelope from a template](/docs/esign-rest-api/esign101/concepts/templates/).\n* [Create and send an envelope from\n  a combination of documents and templates](/docs/esign-rest-api/esign101/concepts/templates/composite/).\n* Create a draft envelope.\n\n\nWhen you use this method\nto create and send an envelope\nin a single request,\nthe following parameters in the request body (an [`envelopeDefinition`][envelopeDefinition] object) are required:\n\n| Parameter      | Description |\n| :--------      | :---------- |\n| `status`       | Set to `sent` to send the envelope to recipients.<br>Set to `created` (or don't set at all) to save the envelope as a draft. |\n| `emailSubject` | The subject of the email used to send the envelope. |\n| `documents`    | The [documents][] to be signed. |\n| `recipients`   | The email addresses of the envelope [recipients][]. |\n\n\nWhen you create an envelope by using a\n[composite template](/docs/esign-rest-api/esign101/concepts/templates/composite/),\nyou should specify the envelope custom fields in the inline template.\nAny custom fields that you specify at the root level are ignored.\n\nIf the envelope has a workflow definition\nand the `workflowStatus` is `paused`,\nthe envelope will not be sent immediately,\neven if the envelope's `status` is `sent`.\n\n\n### Related topics\n\n[Envelope][envelopes] and [template][templates]\nobjects along with [documents][documents],\n[recipients][recipients], and [tabs][tabs]\nare the five object models at the core of the eSignature API.\nThe [eSignature concepts guide](/docs/esign-rest-api/esign101/concepts/)\ndescribes how the five object models work together.\n\nThe following how-to articles contain\npractical examples that show you how to\nto\nconfigure this method's\n[`envelopeDefinition`][envelopeDefinition] request body\nto perform common tasks.\n\nRequesting signatures\n\n- [How to request a signature by email](/docs/esign-rest-api/how-to/request-signature-email-remote/)\n- [How to request a signature by email using a template](/docs/esign-rest-api/how-to/request-signature-template-remote/)\n- [How to request a signature by SMS delivery](/docs/esign-rest-api/how-to/request-signature-sms/)\n- [How to request a signature using a composite template](/docs/esign-rest-api/how-to/request-signature-composite-template-embedded/)\n\nRequiring authentication\n\n- [How to require access code authentication for a recipient](/docs/esign-rest-api/how-to/require-access-code-recipient/)\n- [How to require phone authentication for a recipient](/docs/esign-rest-api/how-to/phone-auth/)\n- [How to require knowledge-based authentication (KBA) for a recipient](/docs/esign-rest-api/how-to/knowledge-based-authentication/)\n- [How to require ID verification (IDV) for a recipient](/docs/esign-rest-api/how-to/id-verification/)\n\nSending envelopes\n\n- [How to send an envelope via your app](/docs/esign-rest-api/how-to/embedded-sending/)\n- [How to bulk send envelopes](/docs/esign-rest-api/how-to/bulk-send-envelopes/)\n- [How to send a request for payment](/docs/esign-rest-api/how-to/request-a-payment/)\n\nSetting tab values\n\n- [How to set envelope tab values](/docs/esign-rest-api/how-to/set-envelope-tab-values/)\n- [How to set tab values in a template](/docs/esign-rest-api/how-to/set-template-tab-values/)\n\nApplying brands\n\n- [How to apply a brand to an envelope](/docs/esign-rest-api/how-to/apply-brand-to-envelope/)\n- [How to apply a brand and template to an envelope](/docs/esign-rest-api/how-to/apply-brand-and-template-to-envelope/)\n\nDocuments, conditional recipients, pausing a workflow\n\n- [How to attach documents via binary transfer](/docs/esign-rest-api/how-to/send-binary/)\n- [How to use conditional recipients](/docs/esign-rest-api/how-to/use-conditional-recipients/)\n- [How to pause a signature workflow](/docs/esign-rest-api/how-to/pause-workflow/)\n\n\n\n\n\n[addingdocs]:           /docs/esign-rest-api/esign101/concepts/envelopes/\n[attachments]:          /docs/esign-rest-api/esign101/concepts/documents/attachments/\n[authcopies]:           /docs/esign-rest-api/esign101/concepts/documents/authoritative-copies/\n[conoverview]:          /docs/esign-rest-api/esign101/concepts/overview/\n[deleting]:             /docs/esign-rest-api/esign101/concepts/envelopes/\n[documents]:            /docs/esign-rest-api/esign101/concepts/documents/\n[envelopeDefinition]:   /docs/esign-rest-api/reference/envelopes/envelopes/create/#schema__envelopedefinition\n[envelopes]:            /docs/esign-rest-api/esign101/concepts/envelopes/\n[locking]:              /docs/esign-rest-api/esign101/concepts/envelopes/lock/\n[payments]:             /docs/esign-rest-api/esign101/concepts/tabs/payment/\n[purging]:              /docs/esign-rest-api/esign101/concepts/documents/purging/\n[recipients]:           /docs/esign-rest-api/esign101/concepts/recipients/\n[recipstatus]:          /docs/esign-rest-api/esign101/concepts/recipients/#recipient-status\n[reciptypes]:           /docs/esign-rest-api/esign101/concepts/recipients/#recipient-types\n[supdocs]:              /docs/esign-rest-api/esign101/concepts/documents/supplemental/\n[tabanchor]:            /docs/esign-rest-api/esign101/concepts/tabs/auto-place/\n[tabcustom]:            /docs/esign-rest-api/esign101/concepts/tabs/custom-tabs/\n[tabs]:                 /docs/esign-rest-api/esign101/concepts/tabs/\n[tabtypes]:             /docs/esign-rest-api/esign101/concepts/tabs/\n[templates]:            /docs/esign-rest-api/esign101/concepts/templates/\n[tracking]:             /docs/esign-rest-api/esign101/concepts/envelopes/\n\n";
      operationId: 'Envelopes_PostEnvelopes';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Reserved for DocuSign.\n';
          in: 'query';
          name: 'cdse_mode';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When true, users can define the routing order of recipients while sending documents for signature.';
          in: 'query';
          name: 'change_routing_order';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Reserved for DocuSign.\n';
          in: 'query';
          name: 'completed_documents_only';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** template roles will be merged, and empty recipients will be removed. This parameter applies when you create a draft envelope with multiple templates. (To create a draft envelope, the `status` field is set to `created`.)\n\n**Note:** DocuSign recommends that this parameter should be set to **true** whenever you create a draft envelope with multiple templates.';
          in: 'query';
          name: 'merge_roles_on_draft';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/envelopeDefinition';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeSummary';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates an envelope.';
      tags: ['Envelopes'];
      'x-ds-examples': [
        {
          description: 'This example shows a request/response that includes:\n\n* A single PDF document to be signed\n* One tab positioned using anchor text\n* One recipient\n';
          direction: 'both';
          format: 'json';
          request: {
            documents: [
              {
                documentBase64: '[Document content (PDF File)]';
                documentId: '1';
                fileExtension: 'pdf';
                name: 'NDA.pdf';
              },
            ];
            emailSubject: 'Please sign the NDA';
            recipients: {
              signers: [
                {
                  email: 'the_nda_signer@example.com';
                  name: 'Darlene Petersen';
                  recipientId: '1';
                  routingOrder: '1';
                  tabs: {
                    dateSignedTabs: [
                      {
                        anchorString: 'signer1date';
                        anchorYOffset: '-6';
                        fontSize: 'Size12';
                        name: 'Date Signed';
                        recipientId: '1';
                        tabLabel: 'date_signed';
                      },
                    ];
                    fullNameTabs: [
                      {
                        anchorString: 'signer1name';
                        anchorYOffset: '-6';
                        fontSize: 'Size12';
                        name: 'Full Name';
                        recipientId: '1';
                        tabLabel: 'Full Name';
                      },
                    ];
                    signHereTabs: [
                      {
                        anchorString: 'signer1sig';
                        anchorUnits: 'mms';
                        anchorXOffset: '0';
                        anchorYOffset: '0';
                        name: 'Please sign here';
                        optional: 'false';
                        recipientId: '1';
                        scaleValue: 1;
                        tabLabel: 'signer1sig';
                      },
                    ];
                  };
                },
              ];
            };
            status: 'sent';
          };
          response: {
            envelopeId: '63e05468-xxxx-xxxx-xxxx-8b48f7dbeb80';
            status: 'sent';
            statusDateTime: '2016-05-29T17:11:56.1800000Z';
            uri: '/envelopes/63e05468-xxxx-xxxx-xxxx-8b48f7dbeb80';
          };
          style: 'custom';
          title: 'Request Signature on Single Document by Email';
        },
        {
          description: 'This example shows a request/response that includes:\n\n* Multiple documents, both pdf and Word docx files.\n* Multiple tabs including signing, fullName, dateSigned, and text tabs.\n* Tabs positioned using anchor text.\n* Two recipients, a signer and a cc recipient.\n';
          direction: 'both';
          format: 'json';
          request: {
            documents: [
              {
                documentBase64: '[Document 1 content (PDF File)]';
                documentId: '1';
                fileExtension: 'pdf';
                name: 'NDA.pdf';
              },
              {
                documentBase64: '[Document 2 content (PDF File)]';
                documentId: '2';
                fileExtension: 'pdf';
                name: 'House.pdf';
              },
              {
                documentBase64: '[Document 3 content (Word file)]';
                documentId: '3';
                fileExtension: 'docx';
                name: 'contractor_agreement.docx';
              },
            ];
            emailSubject: 'Please sign the house documentation package';
            recipients: {
              carbonCopies: [
                {
                  email: 'cody_vigil@worldwidecorp.example.com';
                  name: 'Cody Vigil';
                  recipientId: '2';
                  routingOrder: '2';
                },
              ];
              signers: [
                {
                  email: 'darlene_petersen@newco.example.com';
                  name: 'Darlene Petersen';
                  recipientId: '1';
                  routingOrder: '1';
                  tabs: {
                    dateSignedTabs: [
                      {
                        anchorString: 'signer1date';
                        anchorYOffset: '-6';
                        fontSize: 'Size12';
                        name: 'Date Signed';
                        recipientId: '1';
                        tabLabel: 'date_signed';
                      },
                      {
                        documentId: '2';
                        fontSize: 'Size12';
                        name: 'Date Signed';
                        pageNumber: '1';
                        recipientId: '1';
                        tabLabel: 'doc3_date_signed';
                        xPosition: '89';
                        yPosition: '100';
                      },
                    ];
                    fullNameTabs: [
                      {
                        anchorString: 'signer1name';
                        anchorYOffset: '-6';
                        fontSize: 'Size12';
                        name: 'Full Name';
                        recipientId: '1';
                        tabLabel: 'Full Name';
                      },
                    ];
                    signHereTabs: [
                      {
                        anchorString: 'signer1sig';
                        anchorUnits: 'mms';
                        anchorXOffset: '0';
                        anchorYOffset: '0';
                        name: 'Please sign here';
                        optional: 'false';
                        recipientId: '1';
                        scaleValue: 1;
                        tabLabel: 'signer1sig';
                      },
                      {
                        documentId: '2';
                        name: 'Please sign here';
                        optional: 'false';
                        pageNumber: '1';
                        recipientId: '2';
                        scaleValue: 1;
                        tabLabel: 'signer1_doc2';
                        xPosition: '89';
                        yPosition: '40';
                      },
                      {
                        anchorString: 'Client Signature';
                        anchorUnits: 'mms';
                        anchorXOffset: '0';
                        anchorYOffset: '-4';
                        name: 'Please sign here';
                        optional: 'false';
                        recipientId: '1';
                        scaleValue: 1;
                        tabLabel: 'doc3_client_sig';
                      },
                    ];
                    textTabs: [
                      {
                        anchorString: 'signer1company';
                        anchorYOffset: '-8';
                        fontSize: 'Size12';
                        name: 'Company';
                        recipientId: '1';
                        required: 'true';
                        tabLabel: 'Company';
                      },
                      {
                        anchorString: 'Client Name';
                        anchorYOffset: '-38';
                        fontSize: 'Size12';
                        name: 'Company';
                        recipientId: '1';
                        required: 'true';
                        tabLabel: 'Company';
                      },
                      {
                        documentId: '3';
                        fontSize: 'Size10';
                        name: 'Company';
                        pageNumber: '1';
                        recipientId: '1';
                        required: 'true';
                        tabLabel: 'Company';
                        xPosition: '145';
                        yPosition: '195';
                      },
                    ];
                  };
                },
              ];
            };
            status: 'sent';
          };
          response: {
            envelopeId: '63e05468-xxxx-xxxx-xxxx-8b48f7dbeb80';
            status: 'sent';
            statusDateTime: '2016-05-29T17:11:56.1800000Z';
            uri: '/envelopes/63e05468-xxxx-xxxx-xxxx-8b48f7dbeb80';
          };
          style: 'custom';
          title: 'Multiple Documents and Tabs, Signer and CC Recipients';
        },
        {
          description: "For some documents, one or more signatures must be witnessed by an appointed [notary public](https://en.wikipedia.org/wiki/Notary_public).\n\nDocuSign supports eNotary services for many jurisdictions. This example demonstrates how to send an envelope to be signed by Susan Signer with her signature witnessed by Nancy Notary. You must know the name and email address of the signer and the notary public for a signature to be notarized.\n\nNote that the full legal name of the signer must be used. It will be checked against the signer's government-issued proof of identity by the notary public.\n\nPlease see the [DocuSign eNotary resource page](https://support.docusign.com/en/guides/ndse-user-guide-enotary-resources) for further information. It lists the jurisdictions participating in the DocuSign eNotary program and additional reference information.\n\nNote that eNotary services are not included with all account types and are **not** included by default with demo/developer sandbox accounts. To enable eNotary service for your sandbox account, contact your DocuSign technical support person or DocuSign customer service.\n\nThe example includes event notification via the Connect service.";
          direction: 'both';
          format: 'json';
          request: {
            documents: [
              {
                documentBase64: '[Contents elided]';
                documentId: '1';
                fileExtension: 'docx';
                name: 'important document.docx';
              },
            ];
            emailSubject: 'Important agreement for notarized signature';
            eventNotification: {
              envelopeEvents: [
                {
                  envelopeEventStatusCode: 'Completed';
                },
                {
                  envelopeEventStatusCode: 'Declined';
                },
                {
                  envelopeEventStatusCode: 'Voided';
                },
              ];
              includeDocumentFields: 'false';
              includeDocuments: 'false';
              includeSenderAccountAsCustomField: 'true';
              loggingEnabled: 'true';
              requireAcknowledgment: 'true';
              signMessageWithX509Cert: 'true';
              url: 'https://listener.example.com/docusign_notifications';
            };
            recipients: {
              inPersonSigners: [
                {
                  email: 'susan_signer@gmail.com';
                  inPersonSigningType: 'notary';
                  name: 'Susan Anne Signer';
                  notaryHost: {
                    email: 'nancy@notary-svc.com';
                    name: 'Nancy Notary';
                    recipientId: 2;
                  };
                  recipientId: 1;
                  routingOrder: 1;
                  tabs: {
                    signHereTabs: [
                      {
                        documentId: '1';
                        name: 'Please sign here';
                        optional: 'false';
                        pageNumber: '1';
                        recipientId: '1';
                        tabLabel: 'signer1sig';
                        xPosition: '100';
                        yPosition: '100';
                      },
                    ];
                  };
                },
              ];
            };
            status: 'sent';
          };
          response: {
            envelopeId: 'aaaaaaaa-xxxx-xxxx-xxxx-52a86fb94be8';
            status: 'sent';
            statusDateTime: '2017-06-15T11:02:39.3996430Z';
            uri: '/envelopes/aaaaaaaa-xxxx-xxxx-xxxx-52a86fb94be8';
          };
          style: 'custom';
          title: 'Create a Notarized Signing Recipient';
        },
        {
          description: 'DocuSign enables document signers to use\nelectronic or\ndigital signatures.\n\nDocuSign has tightly integrated standard digital signatures into the DocuSign Signature platform. This enables a single envelope to include:\n\n* electronic signatures,\n* AES digital signatures using certificates from DocuSign or from your organization,\n* QES digital signatures from government certified Trust Service Providers (TSPs).\n\nThis example enables the signer to create an eIDAS compliant AES signature with embedded signing. InPerson signers can also use SBS digital signatures.\n\n[More information on creating SBS digital signature requests.](/docs/esign-rest-api/esign101/concepts/standards-based-signatures/)\n\nThe `clientId` in the example tells DocuSign that the Signing Ceremony will be embedded.\nThe example also includes an `eventNotification` object for receiving envelope status updates from DocuSign.\n\n## Embedding the signing ceremony\n1. Send the `Envelopes: create` call as shown below in the Request/Response section.\n2. The response will include the `envelopeId`\n3. Use the [EnvelopeViews: createRecipient](/docs/esign-rest-api/reference/envelopes/envelopeviews/createrecipient/) request to obtain the redirectURL as follows:\n\n`POST /v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/recipient`\n\n````\n{\n    "clientUserId": "1000",\n    "email": "Sam@spade.com",\n    "userName": "Sam Spade",\n    "returnUrl": "https://your_app.example.com",\n    "AuthenticationMethod": "Password"\n}\n````\nThe response will include the `url`. Redirect the user\'s browser to the URL to start the signing ceremony.\n\n**Note:** You must **immediately** redirect the user to the URL you receive from DocuSign. The URL is only valid for 5 minutes. Don\'t request a recipient view URL until you are ready to redirect the user\'s browser.\n';
          direction: 'both';
          format: 'json';
          request: {
            documents: [
              {
                documentBase64: '[Contents elided]';
                documentId: '1';
                fileExtension: 'html';
                name: ' Agreement';
              },
            ];
            emailSubject: 'NewCo agreement for signature';
            eventNotification: {
              envelopeEvents: [
                {
                  envelopeEventStatusCode: 'Completed';
                },
                {
                  envelopeEventStatusCode: 'Declined';
                },
                {
                  envelopeEventStatusCode: 'Voided';
                },
              ];
              includeDocumentFields: 'false';
              includeDocuments: 'false';
              includeSenderAccountAsCustomField: 'true';
              loggingEnabled: 'true';
              requireAcknowledgment: 'true';
              signMessageWithX509Cert: 'true';
              url: 'https://your_app.example.com/listener';
            };
            recipients: {
              signers: [
                {
                  clientUserId: '1000';
                  email: 'Sam@spade.com';
                  name: 'Sam Spade';
                  recipientId: '1';
                  recipientSignatureProviders: [
                    {
                      signatureProviderName: 'UniversalSignaturePen_OpenTrust_Hash_TSP';
                      signatureProviderOptions: {
                        SMS: '+33134567899';
                      };
                    },
                  ];
                  routingOrder: '1';
                  tabs: {
                    signHereTabs: [
                      {
                        anchorString: 'signer1sig';
                        documentId: '1';
                        name: 'Please sign here';
                        optional: 'false';
                        recipientId: '1';
                        tabLabel: 'signer1sig';
                      },
                    ];
                  };
                },
              ];
            };
            status: 'sent';
          };
          response: {
            envelopeId: 'caaaaaaa-xxxx-xxxx-xxxx-c171528e99c8';
            status: 'sent';
            statusDateTime: '2017-06-22T06:44:49.1642220Z';
            uri: '/envelopes/caaaaaaa-xxxx-xxxx-xxxx-c171528e99c8';
          };
          style: 'custom';
          title: 'Request an SBS digital signature, with an embedded signing ceremony';
        },
      ];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createEnvelope';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/status': {
    parameters: [];
    put: {
      deprecated: false;
      description: 'Retrieves envelope statuses for a set of envelopes.\n\nYou must specify exactly one of the following query parameters:\n\n| Parameter         | Description                                                                      |\n| :---------------- | :------------------------------------------------------------------------------- |\n| `from_date`       | a valid UTC DateTime:  `2016-01-01`                                              |\n| `envelope_ids`    | A comma-separated list of envelope IDs<br>or the special value `request_body`    |\n| `transaction_ids` | A comma-separated list of transaction IDs<br>or the special value `request_body` |\n\nWhen you use the special value `request_body`, the request body looks like this:\n\n```\n{\n  "envelopeIds": [\n    "44c5ad6c-xxxx-xxxx-xxxx-ebda5e2dfe15",\n    "8e26040d-xxxx-xxxx-xxxx-1e29b924d237",\n    "c8b40a2d-xxxx-xxxx-xxxx-4fe56fe10f95"\n  ]\n}\n```\n\n**Note:** Omitting the request body altogether causes the endpoint to return an error.\nThe request body must be at least `{}`.\n';
      operationId: 'Envelopes_PutStatus';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies the Authoritative Copy Status for the envelopes. Valid values: \n\n- `Unknown`\n- `Original`\n- `Transferred`\n- `AuthoritativeCopy`\n- `AuthoritativeCopyExportPending`\n- `AuthoritativeCopyExported`\n- `DepositPending`\n- `Deposited`\n- `DepositedEO`\n- `DepositFailed`';
          in: 'query';
          name: 'ac_status';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** removes any results that match one of the provided `transaction_ids`.';
          in: 'query';
          name: 'block';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.\n\nUse `start_position` to specify the number of results to skip.\n\n';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The email address of the sender.';
          in: 'query';
          name: 'email';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The envelope IDs to include in the results.\n\nThe value of this property can be:\n- A comma-separated list of envelope IDs\n- The special value `request_body`. In this case, the method uses the envelope IDs in the request body.';
          in: 'query';
          name: 'envelope_ids';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The date/time setting that specifies when the request begins checking for status changes for envelopes in the account. This is required unless parameters `envelope_ids` and/or `transaction_Ids` are provided.\n\n**Note:** This parameter must be set to a valid  `DateTime`, or  `envelope_ids` and/or `transaction_ids` must be specified.';
          in: 'query';
          name: 'from_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The envelope status that you are checking for. Possible values are:\n\n\n- `Changed` (default)\n- `Completed`\n- `Created`\n- `Declined`\n- `Deleted`\n- `Delivered`\n- `Processing`\n- `Sent`\n- `Signed`\n- `TimedOut`\n- `Voided`\n\nFor example, if you specify `Changed`, this method\nreturns a list of envelopes that changed status\nduring the `from_date` to `to_date` time period. \n';
          in: 'query';
          name: 'from_to_status';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nUse with `count` to limit the number\nof results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of envelope status to search for. Possible values are:\n\n- `completed`\n- `created`\n- `declined`\n- `deleted`\n- `delivered`\n- `processing`\n- `sent`\n- `signed`\n- `template`\n- `voided`\n';
          in: 'query';
          name: 'status';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Optional date/time setting\nthat specifies the last date/time \nor envelope status changes in the result set. \n\nThe default value is the time that you call the method. \n';
          in: 'query';
          name: 'to_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The transaction IDs to include in the results. Note that transaction IDs are valid for seven days.\n\nThe value of this property can be:\n- A list of comma-separated transaction IDs\n- The special value `request_body`. In this case, this method uses the transaction IDs in the request body.';
          in: 'query';
          name: 'transaction_ids';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Limits results to envelopes\nsent by the account user\nwith this user name.\n\n`email` must be given as well,\nand both `email` and `user_name`\nmust refer to an existing account user.\n';
          in: 'query';
          name: 'user_name';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/envelopeIdsRequest';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopesInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets envelope statuses for a set of envelopes.';
      tags: ['Envelopes'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'listStatus';
      'x-ds-methodname': 'listStatus';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/transfer_rules': {
    get: {
      deprecated: false;
      description: 'This method retrieves a list of envelope transfer rules associated with an account.\n\n**Note:** Only Administrators can create and use envelope transfer rules. In addition, to use envelope transfer rules, the **Transfer Custody** feature must be enabled for your account.';
      operationId: 'EnvelopeTransferRules_GetEnvelopeTransferRules';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.\n\nUse `start_position` to specify the number of results to skip.\n';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nUse with `count` to limit the number\nof results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeTransferRuleInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets envelope transfer rules.';
      tags: ['EnvelopeTransferRules'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'get';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'This method creates an envelope transfer rule.\n\nWhen you create an envelope transfer rule, you specify the following properties: \n\n- `eventType`\n- `fromGroups`\n- `toUser`\n- `toFolder`\n- `carbonCopyOriginalOwner`\n- `enabled`\n\n**Note:** Only Administrators can create envelope transfer rules. In addition, to use envelope transfer rules, the **Transfer Custody** feature must be enabled for your account.';
      operationId: 'EnvelopeTransferRules_PostEnvelopeTransferRules';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/envelopeTransferRuleRequest';
            };
          };
        };
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeTransferRuleInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates an envelope transfer rule.';
      tags: ['EnvelopeTransferRules'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'create';
      'x-ds-service': 'Uncategorized';
    };
    put: {
      deprecated: false;
      description: 'This method changes the status for one or more envelope transfer rules based on the `envelopeTransferRuleId`s in the request body. You use this method to change whether or not the rules are enabled.\n\n**Note:** You cannot change any other information about the envelope transfer rule. Only Administrators can update envelope transfer rules. In addition, to use envelope transfer rules, the **Transfer Custody** feature must be enabled for your account.';
      operationId: 'EnvelopeTransferRules_PutEnvelopeTransferRules';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/envelopeTransferRuleInformation';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeTransferRuleInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Changes the status of multiple envelope transfer rules.';
      tags: ['EnvelopeTransferRules'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'update';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/transfer_rules/{envelopeTransferRuleId}': {
    delete: {
      deprecated: false;
      description: 'This method deletes an envelope transfer rule.\n\n**Note:** Only Administrators can delete envelope transfer rules. In addition, to use envelope transfer rules, the **Transfer Custody** feature must be enabled for your account.';
      operationId: 'EnvelopeTransferRules_DeleteEnvelopeTransferRules';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the envelope transfer rule. The system generates this ID when the rule is first created.';
          in: 'path';
          name: 'envelopeTransferRuleId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes an envelope transfer rule.';
      tags: ['EnvelopeTransferRules'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'delete';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method changes the status of an envelope transfer rule. You use this method to change whether or not the rule is enabled.\n\nYou must include the `envelopeTransferRuleId` both as a query parameter, and in the request body.\n\n**Note:** You cannot change any other information about the envelope transfer rule. Only Administrators can update an envelope transfer rule. In addition, to use envelope transfer rules, the **Transfer Custody** feature must be enabled for your account.';
      operationId: 'EnvelopeTransferRules_PutEnvelopeTransferRule';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the envelope transfer rule. The system generates this ID when the rule is first created.';
          in: 'path';
          name: 'envelopeTransferRuleId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/envelopeTransferRule';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeTransferRule';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Changes the status of an envelope transfer rule.';
      tags: ['EnvelopeTransferRules'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateEnvelopeTransferRule';
      'x-ds-methodname': 'updateEnvelopeTransferRule';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}': {
    get: {
      deprecated: false;
      description: 'Retrieves the overall status for the specified envelope.\nTo get the status of a list of envelopes, use\n[Envelope: listStatusChanges ](/docs/esign-rest-api/reference/envelopes/envelopes/liststatuschanges/).\n\n### Related topics\n\n- [How to get envelope information](/docs/esign-rest-api/how-to/get-envelope-information/)\n';
      operationId: 'Envelopes_GetEnvelope';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** envelope information can be added or modified.';
          in: 'query';
          name: 'advanced_update';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies additional information about the envelope to return. Enter a comma-separated list, such as `tabs,recipients`. Valid values are:\n\n- `custom_fields`: The custom fields associated with the envelope.\n- `documents`: The documents associated with the envelope.\n- `attachments`: The attachments associated with the envelope.\n- `extensions`: The email settings associated with the envelope.\n- `folders`: The folder where the envelope exists.\n- `recipients`: The recipients associated with the envelope.\n- `powerform`: The PowerForms associated with the envelope.\n- `tabs`: The tabs associated with the envelope.\n- `payment_tabs`: The payment tabs associated with the envelope.\n- `workflow`: The workflow definition associated with the envelope.\n';
          in: 'query';
          name: 'include';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelope';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the status of a single envelope.';
      tags: ['Envelopes'];
      'x-ds-examples': [
        {
          description: 'This example shows a how to get information about\nan envelope with a given envelope id.\n\nThe request for this endpoint has no payload.\n\n### Request\n```\nGET /restapi/v2.1/accounts/1703061/envelopes/4b728be4-xxxx-xxxx-xxxx-d63e23f822b6\n```\n';
          direction: 'response';
          format: 'json';
          response: {
            allowMarkup: 'false';
            autoNavigation: 'true';
            brandId: '56502fe1-xxxx-xxxx-xxxx-97cb5c43176a';
            certificateUri: '/envelopes/4b728be4-xxxx-xxxx-xxxx-d63e23f822b6/documents/certificate';
            createdDateTime: '2016-10-05T01:04:58.1830000Z';
            customFieldsUri: '/envelopes/4b728be4-xxxx-xxxx-xxxx-d63e23f822b6/custom_fields';
            documentsCombinedUri: '/envelopes/4b728be4-xxxx-xxxx-xxxx-d63e23f822b6/documents/combined';
            documentsUri: '/envelopes/4b728be4-xxxx-xxxx-xxxx-d63e23f822b6/documents';
            emailSubject: 'Please sign the NDA';
            enableWetSign: 'true';
            envelopeId: '4b728be4-xxxx-xxxx-xxxx-d63e23f822b6';
            envelopeIdStamping: 'true';
            envelopeUri: '/envelopes/4b728be4-xxxx-xxxx-xxxx-d63e23f822b6';
            initialSentDateTime: '2016-10-05T01:04:58.7770000Z';
            is21CFRPart11: 'false';
            isSignatureProviderEnvelope: 'false';
            lastModifiedDateTime: '2016-10-05T01:04:58.1830000Z';
            notificationUri: '/envelopes/4b728be4-xxxx-xxxx-xxxx-d63e23f822b6/notification';
            purgeState: 'unpurged';
            recipientsUri: '/envelopes/4b728be4-xxxx-xxxx-xxxx-d63e23f822b6/recipients';
            sentDateTime: '2016-10-05T01:04:58.7770000Z';
            status: 'sent';
            statusChangedDateTime: '2016-10-05T01:04:58.7770000Z';
            templatesUri: '/envelopes/4b728be4-xxxx-xxxx-xxxx-d63e23f822b6/templates';
          };
          style: 'custom';
          title: 'Get Status About a Specific Envelope';
        },
      ];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getEnvelope';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method enables you to make changes to an envelope.\nYou can use it to:\n\n* [Send a draft envelope](#sending-a-draft-envelope)\n* [Void an in-process envelope](#voiding-an-in-process-envelope)\n* [Modify a draft envelope](#modifying-envelope-email-information)\n* [Purge documents and envelope metadata from the DocuSign platform](#purging-documents-from-docusign)\n\nAlthough the request body for this method\nis a complete envelope definition,\nyou only need to provide\nthe properties that\nyou\'re updating.\n\n## Sending a draft envelope\n\nTo send a draft envelope, include the following code in the request body:\n\n```json\n{\n  "status": "sent"\n}\n```\n\nYou can attach a workflow before sending the envelope:\n\n```json\n{\n  "status": "sent",\n  "workflow": {\n    "workflowSteps": [\n      {\n        "action": "pause_before",\n        "description": "pause_before routing order 2",\n        "itemId": 2,\n        "triggerOnItem": "routing_order"\n      }\n    ]\n  }\n}\n```\n\n## Working with workflows\n\nTo unpause a workflow, the request body should include this:\n\n```json\n{\n  "workflow": {\n    "workflowStatus": "in_progress"\n  }\n}\n```\n\n## Voiding an in-process envelope\n\nTo void an in-process envelope, include the following code in the request body:\n\n```json\n{\n  "status": "voided",\n  "voidedReason": "The reason for voiding the envelope"\n}\n```\n\n## Modifying envelope email information\n\nTo change the email subject and message of a draft envelope,\ninclude the following code in the request body:\n\n```json\n{\n  "emailSubject": "new email subject",\n  "emailBlurb": "new email message"\n}\n```\n\n## Purging documents from docusign\n\nTo place only the documents\nin the purge queue,\nleaving any\ncorresponding attachments\nand tabs in the DocuSign platform,\nset the `purgeState` property\nto `documents_queued`.\n\n```json\n{\n  "envelopeId": "222e6847-xxxx-xxxx-xxxx-72a3c9c16fca",\n  "purgeState": "documents_queued"\n}\n```\n\nTo place documents,\nattachments,\nand tabs\nin the purge queue,\nset the `purgeState` property\nto `documents_and_metadata_queued`.\n\n```json\n{\n  "envelopeId": "222e6847-xxxx-xxxx-xxxx-72a3c9c16fca",\n  "purgeState": "documents_and_metadata_queued"\n}\n```\n\nTo place documents,\nattachments,\nand tabs\nin the purge queue\nand to redact personal information,\nset the `purgeState` property\nto `documents_and_metadata_and_redact_queued`.\n\n```json\n{\n  "envelopeId": "222e6847-xxxx-xxxx-xxxx-72a3c9c16fca",\n  "purgeState": "documents_and_metadata_and_redact_queued"\n}\n```\n\nYou can purge documents\nonly from completed envelopes\nthat are not marked as the authoritative copy.\nThe user requesting the purge\nmust have permission to purge documents\nand\nmust be the sender or be acting on behalf of the sender.\n\nWhen the purge request is initiated\nthe items to be purged\nare placed in the purge queue\nfor deletion in 14 days.\nThe sender\nand\nall recipients with DocuSign accounts\nassociated with the envelope\nget an email notification\nthe documents will be deleted in 14 days.\nThe notification contains a link\nto the documents.\nA second email notification\nis sent 7 days later.\nAt the end of the 14-day period\nthe documents are deleted from the system.\nRecipients without DocuSign accounts\ndo not receive email notifications.\n\nIf your account has a Document Retention policy,\nenvelope documents\nare automatically placed\nin the purge queue,\nand notification emails are sent\nat the end of the retention period.\nSetting a Document Retention policy is the same as setting a\nschedule for purging documents.\n\n## Removing documents from the purge queue\n\nTo remove documents from the purge queue, include the following code in the request body:\n\n```json\n{\n  "envelopeId": "222e6847-xxxx-xxxx-xxxx-72a3c9c16fca",\n  "purgeState": "documents_dequeued"\n}\n```\n\n### Related topics\n\n- [Void an envelope](https://www.docusign.com/blog/dsdev-common-api-tasks-void-an-envelope) ([Common API Tasks](https://www.docusign.com/blog/tags/common-api-tasks))\n- [Purging documents (eSignature Concepts)](/docs/esign-rest-api/esign101/concepts/documents/purging/)\n- [Purging documents in an envelope (blog post)](https://www.docusign.com/blog/developers/purging-documents-envelope)\n- [How to unpause a signature workflow](/docs/esign-rest-api/how-to/unpause-workflow/)\n';
      operationId: 'Envelopes_PutEnvelope';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** allows the caller to update recipients, tabs, custom fields, notification, email settings and other envelope attributes.';
          in: 'query';
          name: 'advanced_update';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,**\nsends the specified envelope again.';
          in: 'query';
          name: 'resend_envelope';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/envelope';
            };
          };
        };
        description: 'A container used to send documents to recipients. The envelope carries information about the sender and timestamps to indicate the progress of the delivery procedure. It can contain collections of Documents, Tabs and Recipients.';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeUpdateSummary';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Send, void, or modify a draft envelope. Purge documents from a completed envelope.';
      tags: ['Envelopes'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'update';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments': {
    delete: {
      deprecated: false;
      description: 'Deletes one or more attachments from a draft envelope.';
      operationId: 'Attachments_DeleteAttachments';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/envelopeAttachmentsRequest';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeAttachmentsResult';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes one or more attachments from a draft envelope.';
      tags: ['EnvelopeAttachments'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteAttachments';
      'x-ds-service': 'Envelopes';
    };
    get: {
      deprecated: false;
      description: 'Returns a list of attachments associated with a specified envelope.';
      operationId: 'Attachments_GetAttachments';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeAttachmentsResult';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns a list of attachments associated with a specified envelope';
      tags: ['EnvelopeAttachments'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'getAttachments';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Adds one or more attachments to a draft or in-process envelope.\n\nEnvelope attachments are files that an application can include in an envelope. They are not converted to PDF. Envelope attachments are available only through the API. There is no user interface in the DocuSign web application for them.\n\nFor a list of supported file formats, see [Supported File Formats](https://support.docusign.com/guides/ndse-user-guide-supported-file-formats).';
      operationId: 'Attachments_PutAttachments';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/envelopeAttachmentsRequest';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeAttachmentsResult';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds one or more attachments to a draft or in-process envelope.';
      tags: ['EnvelopeAttachments'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'putAttachments';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments/{attachmentId}': {
    get: {
      deprecated: false;
      description: 'Retrieves an attachment from an envelope.';
      operationId: 'Attachments_GetAttachment';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique identifier for the attachment.';
          in: 'path';
          name: 'attachmentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieves an attachment from an envelope.';
      tags: ['EnvelopeAttachments'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getAttachment';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Adds an attachment to a draft or in-process envelope.';
      operationId: 'Attachments_PutAttachment';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique identifier for the attachment.';
          in: 'path';
          name: 'attachmentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/attachment';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeAttachmentsResult';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds an attachment to a draft or in-process envelope.';
      tags: ['EnvelopeAttachments'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'putAttachment';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/audit_events': {
    get: {
      deprecated: false;
      description: 'Gets the envelope audit events for the specified envelope.';
      operationId: 'AuditEvents_GetAuditEvents';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeAuditEventResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the envelope audit events for an envelope.';
      tags: ['Envelopes'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'listAuditEvents';
      'x-ds-methodname': 'listAuditEvents';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/comments/transcript': {
    get: {
      deprecated: false;
      description: 'Retrieves a PDF file containing all of the comments that senders and recipients have added to the documents in an envelope.\n\nThe response body of this method is the PDF file as a byte\nstream.\n\n\n**Note:** Comments are disabled by default. To use the comments feature, an account administrator must enable comments on the account (in the `accountSettingsInformation` object, set the `enableSigningExtensionComments` property to **true**). ';
      operationId: 'Comments_GetCommentsTranscript';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '(Optional) The encoding to use for the file.';
          in: 'query';
          name: 'encoding';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/pdf': {
              schema: {
                format: 'binary';
                type: 'string';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            'application/pdf': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a PDF transcript of all of the comments in an envelope.';
      tags: ['Comments'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getCommentsTranscript';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields': {
    delete: {
      deprecated: false;
      description: 'Deletes envelope custom fields for draft and in-process envelopes.';
      operationId: 'CustomFields_DeleteCustomFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/EnvelopeCustomFields';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeCustomFields';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes envelope custom fields for draft and in-process envelopes.';
      tags: ['EnvelopeCustomFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteCustomFields';
      'x-ds-service': 'Envelopes';
    };
    get: {
      deprecated: false;
      description: 'Retrieves the custom field information for the specified envelope. You can use these fields in the envelopes for your account to record information about the envelope, help search for envelopes, and track information. The envelope custom fields are shown in the Envelope Settings section when a user is creating an envelope in the DocuSign member console. The envelope custom fields are not seen by the envelope recipients.\n\nThere are two types of envelope custom fields, text, and list. A text custom field lets the sender enter the value for the field. With a list custom field, the sender selects the value of the field from a pre-made list.\n\n\n### Related topics\n\n- [How to get envelope custom tab values](/docs/esign-rest-api/how-to/get-envelope-custom-tab-values/)\n';
      operationId: 'CustomFields_GetCustomFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/customFieldsEnvelope';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the custom field information for the specified envelope.';
      tags: ['EnvelopeCustomFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listCustomFields';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Updates the envelope custom fields for draft and in-process envelopes.\n\n### Related topics\n\n- [How to bulk send envelopes](/docs/esign-rest-api/how-to/bulk-send-envelopes/)\n';
      operationId: 'CustomFields_PostCustomFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/EnvelopeCustomFields';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeCustomFields';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates envelope custom fields for an envelope.';
      tags: ['EnvelopeCustomFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createCustomFields';
      'x-ds-service': 'Envelopes';
    };
    put: {
      deprecated: false;
      description: 'Updates the envelope custom fields in draft and in-process envelopes.\n\nEach custom field used in an envelope must have a unique name.\n';
      operationId: 'CustomFields_PutCustomFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/EnvelopeCustomFields';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeCustomFields';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates envelope custom fields in an envelope.';
      tags: ['EnvelopeCustomFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateCustomFields';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/docGenFormFields': {
    get: {
      deprecated: false;
      description: '';
      operationId: 'DocGenFormFields_GetEnvelopeDocGenFormFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/docGenFormFieldResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns formfields for an envelope';
      tags: ['DocumentGeneration'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getEnvelopeDocGenFormFields';
      'x-ds-methodname': 'getEnvelopeDocGenFormFields';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: '';
      operationId: 'DocGenFormFields_PutEnvelopeDocGenFormFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'update_docgen_formfields_only';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/docGenFormFieldRequest';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/docGenFormFieldResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates formfields for an envelope';
      tags: ['DocumentGeneration'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateEnvelopeDocGenFormFields';
      'x-ds-methodname': 'updateEnvelopeDocGenFormFields';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents': {
    delete: {
      deprecated: false;
      description: 'Deletes one or more documents from an existing envelope that has not yet been completed.\n\nTo delete a document, use only the relevant parts of the [`envelopeDefinition`](#envelopeDefinition).\nFor example, this request body specifies that you want to delete the document whose `documentId` is "1".\n\n\n```text\n{\n  "documents": [\n    {\n      "documentId": "1"\n    }\n  ]\n}\n```\n\nThe envelope status must be one of:\n\n- `created`\n- `sent`\n- `delivered`\n\n\n';
      operationId: 'Documents_DeleteDocuments';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/envelopeDefinition';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeDocumentsResult';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes documents from a draft envelope.';
      tags: ['EnvelopeDocuments'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteDocuments';
      'x-ds-service': 'Envelopes';
    };
    get: {
      deprecated: false;
      description: 'Retrieves a list of documents associated with the specified envelope.\n\n### Related topics\n\n- [How to list envelope documents](/docs/esign-rest-api/how-to/list-envelope-documents/)\n';
      operationId: 'Documents_GetDocuments';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** allows recipients to get documents by their user id. For example, if a user is included in two different routing orders with different visibilities, using this parameter returns all of the documents from both routing orders.';
          in: 'query';
          name: 'documents_by_userid';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Reserved for DocuSign.';
          in: 'query';
          name: 'include_docgen_formfields';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the response includes metadata that indicates which properties the sender can edit.';
          in: 'query';
          name: 'include_metadata';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** information about the tabs, including prefill tabs, associated with the documents are included in the response.';
          in: 'query';
          name: 'include_tabs';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Allows the sender to retrieve the documents as one of the recipients that they control. The `documents_by_userid` parameter must be set to **false** for this to work.';
          in: 'query';
          name: 'recipient_id';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of a shared user that you want to impersonate in order to\nretrieve their view of the list of documents. This parameter is\nused in the context of a shared inbox (i.e., when you share\nenvelopes from one user to another through the DocuSign Admin console).';
          in: 'query';
          name: 'shared_user_id';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeDocumentsResult';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a list of documents in an envelope.';
      tags: ['EnvelopeDocuments'];
      'x-ds-examples': [
        {
          description: 'This example shows how\nto get a list\nof all the documents in an envelope.\n\nThe request for this endpoint has no payload.\n\n### Request\n\n```\nGET /restapi/v2.1/accounts/1703061/envelopes/44efc9e6-xxxx-xxxx-xxxx-801410d6922d/documents\n```\n';
          direction: 'response';
          format: 'json';
          response: {
            envelopeDocuments: [
              {
                availableDocumentTypes: [
                  {
                    isDefault: 'true';
                    type: 'electronic';
                  },
                ];
                display: 'inline';
                documentId: '1';
                includeInDownload: 'true';
                name: 'NDA.pdf';
                order: '1';
                pages: '3';
                signerMustAcknowledge: 'no_interaction';
                type: 'content';
                uri: '/envelopes/44efc9e6-xxxx-xxxx-xxxx-801410d6922d/documents/1';
              },
              {
                availableDocumentTypes: [
                  {
                    isDefault: 'true';
                    type: 'electronic';
                  },
                ];
                display: 'inline';
                documentId: '2';
                includeInDownload: 'true';
                name: 'House.pdf';
                order: '2';
                pages: '1';
                signerMustAcknowledge: 'no_interaction';
                type: 'content';
                uri: '/envelopes/44efc9e6-xxxx-xxxx-xxxx-801410d6922d/documents/2';
              },
              {
                availableDocumentTypes: [
                  {
                    isDefault: 'true';
                    type: 'electronic';
                  },
                ];
                display: 'inline';
                documentId: '3';
                includeInDownload: 'true';
                name: 'contractor_agreement.docx';
                order: '3';
                pages: '2';
                signerMustAcknowledge: 'no_interaction';
                type: 'content';
                uri: '/envelopes/44efc9e6-xxxx-xxxx-xxxx-801410d6922d/documents/3';
              },
              {
                availableDocumentTypes: [
                  {
                    isDefault: 'true';
                    type: 'electronic';
                  },
                ];
                display: 'inline';
                documentId: 'certificate';
                includeInDownload: 'true';
                name: 'Summary';
                order: '999';
                pages: '4';
                signerMustAcknowledge: 'no_interaction';
                type: 'summary';
                uri: '/envelopes/44efc9e6-xxxx-xxxx-xxxx-801410d6922d/documents/certificate';
              },
            ];
            envelopeId: '44efc9e6-xxxx-xxxx-xxxx-801410d6922d';
          };
          style: 'custom';
          title: 'List All Documents in an Envelope';
        },
      ];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listDocuments';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Adds one or more documents to an existing envelope.\nThe tabs of the original document will be applied to the new document.\n\n\n**Note:** When adding or modifying documents for an in-process envelope,\nDocuSign recommends\n[locking the envelope](/docs/esign-rest-api/reference/envelopes/envelopelocks/create/)\nprior to making any changes.\n\nIf the file name of a document contains Unicode characters, you need to include a `Content-Disposition` header. Example:\n\n\n**Header:** `Content-Disposition`\n\n\n**Value:** `file; filename=\\"name\\";fileExtension=ext;documentId=1`';
      operationId: 'Documents_PutDocuments';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/envelopeDefinition';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeDocumentsResult';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds one or more documents to an existing envelope.';
      tags: ['EnvelopeDocuments'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateList';
      'x-ds-methodname': 'updateDocuments';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}': {
    get: {
      deprecated: false;
      description: 'Retrieves a single document or all documents from an envelope.\n\nTo retrieve a single document, provide the ID of the document in the `documentId` path parameter.\nAlternatively, by setting the `documentId` parameter to special keyword values,\nyou can retrieve all the documents (as a combined PDF, portfolio PDF, or ZIP archive)\nor just the certificate of completion. See the `documentId` description for how to retrieve each format.\n\n\nThe response body of this method\nis a file. If you request multiple documents,\nthe result is a ZIP archive\nthat contains all of the documents.\n\nIn all other cases, the response is a PDF\nfile or PDF portfolio.\n\n\nYou can get the file name and document ID from the response\'s `Content-Disposition` header:\n\n```\nContent-Disposition: file; filename="NDA.pdf"; documentid="1\n```\n\nBy default, the response is the PDF file\nas a byte stream.\nFor example a request/response in `curl` looks like this:\n\n```\n$ curl --request GET \'https://demo.docusign.net/restapi/v2/accounts/0cdb3ff3-xxxx-xxxx-xxxx-e43af011006d/envelopes/ea4cc25b-xxxx-xxxx-xxxx-a67a0a2a4f6c/documents/1/\' \\\n       --header \'Authorization: Bearer eyJ...bqg\'\n\n\nHTTP/1.1 200 OK\nContent-Length: 167539\nContent-Type: application/pdf\n. . .\nContent-Disposition: file; filename="Lorem_Ipsum.pdf"; documentid="1"\nDate: Tue, 23 Aug 2022 01:13:15 GMT\n\n%PDF-1.4\n%˚¸˝˛\n6 0 obj\n<</Length 14>>stream\n. . .\n```\n\nBy using the `Content-Transfer-Encoding`\nheader in the request, you can obtain the PDF file\nencoded in base64. The same `curl` request with\nthe base64 header would look like this:\n\n```\n$ curl --request GET \'https://demo.docusign.net/restapi/v2/accounts/0cdb3ff3-xxxx-xxxx-xxxx-e43af011006d/envelopes/ea4cc25b-xxxx-xxxx-xxxx-a67a0a2a4f6c/documents/1/\' \\\n       --header \'Authorization: Bearer eyJ...bqg\' \\\n       --header \'Content-Transfer-Encoding: base64\'\n\n\nHTTP/1.1 200 OK\nContent-Length: 223384\nContent-Type: application/pdf\n. . .\nContent-Disposition: file; filename="Lorem_Ipsum.pdf"; documentid="1"\nContent-Transfer-Encoding: base64\nDate: Tue, 23 Aug 2022 01:12:30 GMT\n\nJVBERi0xLjQKJfv8/f4KNiAwIG9iago8PC9MZW. . .==\n```\n\n\n(In an actual `curl` request you would use the `--output` switch to\nsave the byte stream into a file.)\n\n### Related topics\n\n- [How to download envelope documents](/docs/esign-rest-api/how-to/download-envelope-documents/)\n';
      operationId: 'Documents_GetDocument';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the document to retrieve. Alternatively, you can use one of the following special keywords:\n\n- `combined`: Retrieves all of the documents as a single PDF file.\n  When the query parameter `certificate` is **true,** the certificate of completion is included in the PDF file.\n  When the query parameter `certificate` is **false,** the certificate of completion is not included in the PDF file.\n- `archive`: Retrieves a ZIP archive that contains all of the PDF documents and the certificate of completion.\n- `certificate`: Retrieves only the certificate of completion as a PDF file.\n- `portfolio`: Retrieves the envelope documents as a [PDF portfolio](https://helpx.adobe.com/acrobat/using/overview-pdf-portfolios.html).';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Used only when the `documentId` parameter is the special keyword `combined`.\n\nWhen **true,** the certificate of completion is included in the combined PDF file.\nWhen **false,** (the default) the certificate of completion is not included in the combined PDF file.\n\n';
          in: 'query';
          name: 'certificate';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** allows recipients to get documents by their user id. For example, if a user is included in two different routing orders with different visibilities, using this parameter returns all of the documents from both routing orders.';
          in: 'query';
          name: 'documents_by_userid';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Reserved for DocuSign.';
          in: 'query';
          name: 'encoding';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the PDF bytes returned in the response are encrypted for all the key managers configured on your DocuSign account. You can decrypt the documents by using the Key Manager DecryptDocument API method. For more information about Key Manager, see the DocuSign Security Appliance Installation Guide that your organization received from DocuSign.';
          in: 'query';
          name: 'encrypt';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies the language for the Certificate of Completion in the response. The supported languages are: Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Dutch (nl), English US (en), French (fr), German (de), Italian (it), Japanese (ja), Korean (ko), Portuguese (pt), Portuguese (Brazil) (pt_BR), Russian (ru), Spanish (es). ';
          in: 'query';
          name: 'language';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Allows the sender to retrieve the documents as one of the recipients that they control. The `documents_by_userid` parameter must be set to **false** for this functionality to work.';
          in: 'query';
          name: 'recipient_id';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of a shared user that you want to impersonate in order to\nretrieve their view of the list of documents. This parameter is\nused in the context of a shared inbox (i.e., when you share\nenvelopes from one user to another through the DocuSign Admin console).';
          in: 'query';
          name: 'shared_user_id';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** any changed fields for the returned PDF are highlighted in yellow and optional signatures or initials outlined in red. The account must have the **Highlight Data Changes** feature enabled.';
          in: 'query';
          name: 'show_changes';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the account has the watermark feature enabled, and the envelope is not complete, then the watermark for the account is added to the PDF documents. This option can remove the watermark. ';
          in: 'query';
          name: 'watermark';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/pdf': {
              schema: {
                format: 'binary';
                type: 'string';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            'application/pdf': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieves a single document or all documents from an envelope.';
      tags: ['EnvelopeDocuments'];
      'x-ds-examples': [
        {
          description: 'This example shows how to retrieve\na single document from an envelope\nas a PDF file.\n\n\nThe request for this endpoint has no payload.\n\n### Request\n\n```\nGET /restapi/v2.1/accounts/0cdb3ff3-xxxx-xxxx-xxxx-e43af011006d/envelopes/44efc9e6-xxxx-xxxx-xxxx-801410d6922d/documents/3\n```\n\n';
          direction: 'response';
          format: 'json';
          response: 'A byte stream representing a PDF file.';
          style: 'custom';
          title: 'Get a Single Document as a PDF File';
        },
        {
          description: 'If you use `combined` instead of a document id\nthe response is a PDF file that contains\nall of the documents in the specified envelope.\n\nThe request for this endpoint has no payload.\n\n### Request\n\n```\nGET /restapi/v2.1/accounts/0cdb3ff3-xxxx-xxxx-xxxx-e43af011006d/envelopes/44efc9e6-xxxx-xxxx-xxxx-801410d6922d/documents/combined\n```\n\n';
          direction: 'response';
          format: 'json';
          response: 'A byte stream representing a PDF file.';
          style: 'custom';
          title: 'Get All Documents as a Single PDF File';
        },
        {
          description: 'This example shows how\nto get a list\nof all the documents in an envelope.\n\nThe request for this endpoint has no payload.\n\n### Request\n\n```\nGET /restapi/v2.1/accounts/1703061/envelopes/44efc9e6-xxxx-xxxx-xxxx-801410d6922d/documents\n```\n';
          direction: 'response';
          format: 'json';
          response: {
            envelopeDocuments: [
              {
                availableDocumentTypes: [
                  {
                    isDefault: 'true';
                    type: 'electronic';
                  },
                ];
                display: 'inline';
                documentId: '1';
                includeInDownload: 'true';
                name: 'NDA.pdf';
                order: '1';
                pages: '3';
                signerMustAcknowledge: 'no_interaction';
                type: 'content';
                uri: '/envelopes/44efc9e6-xxxx-xxxx-xxxx-801410d6922d/documents/1';
              },
              {
                availableDocumentTypes: [
                  {
                    isDefault: 'true';
                    type: 'electronic';
                  },
                ];
                display: 'inline';
                documentId: '2';
                includeInDownload: 'true';
                name: 'House.pdf';
                order: '2';
                pages: '1';
                signerMustAcknowledge: 'no_interaction';
                type: 'content';
                uri: '/envelopes/44efc9e6-xxxx-xxxx-xxxx-801410d6922d/documents/2';
              },
              {
                availableDocumentTypes: [
                  {
                    isDefault: 'true';
                    type: 'electronic';
                  },
                ];
                display: 'inline';
                documentId: '3';
                includeInDownload: 'true';
                name: 'contractor_agreement.docx';
                order: '3';
                pages: '2';
                signerMustAcknowledge: 'no_interaction';
                type: 'content';
                uri: '/envelopes/44efc9e6-xxxx-xxxx-xxxx-801410d6922d/documents/3';
              },
              {
                availableDocumentTypes: [
                  {
                    isDefault: 'true';
                    type: 'electronic';
                  },
                ];
                display: 'inline';
                documentId: 'certificate';
                includeInDownload: 'true';
                name: 'Summary';
                order: '999';
                pages: '4';
                signerMustAcknowledge: 'no_interaction';
                type: 'summary';
                uri: '/envelopes/44efc9e6-xxxx-xxxx-xxxx-801410d6922d/documents/certificate';
              },
            ];
            envelopeId: '44efc9e6-xxxx-xxxx-xxxx-801410d6922d';
          };
          style: 'custom';
          title: 'List All Documents in an Envelope';
        },
      ];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getDocument';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: "Adds or replaces a document in an existing draft or in-process envelope.\nAn in-process envelope is one that has been sent but not yet completed or voided.\n\n\n**Note:** When adding or modifying documents for an in-process envelope,\nDocuSign recommends\n[locking the envelope](/docs/esign-rest-api/reference/envelopes/envelopelocks/create/)\nprior to making any changes.\n\nTo add a new document, set the `documentId` path parameter to a new document ID.\n\nTo replace a document, set the `documentId` path parameter to the document ID of the existing document.\nThe tabs of the original document will be applied to the new document.\nFor example, a request in cURL looks like this:\n\n```\n$ curl --location --request PUT 'https://demo.docusign.net/restapi/v2.1/accounts/0cdb3ff3-xxxx-xxxx-xxxx-e43af011006d/envelopes/ea4cc25b-xxxx-xxxx-xxxx-a67a0a2a4f6c/documents/1' \\\n    --header 'Authorization: Bearer eyJ...bqg' \\\n    --header 'Content-Disposition: filename=\"newDocument\"' \\\n    --header 'Content-Type: application/pdf' \\\n    --data-binary '@/location/of/document.pdf'\n```\n";
      operationId: 'Documents_PutDocument';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/pdf': {
            schema: {
              format: 'binary';
              type: 'string';
            };
          };
        };
        description: 'Updated document content.';
        required: true;
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeDocument';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds or replaces a document in an existing envelope.';
      tags: ['EnvelopeDocuments'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateDocument';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields': {
    delete: {
      deprecated: false;
      description: 'Deletes custom document fields from an existing envelope document.';
      operationId: 'DocumentFields_DeleteDocumentFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/EnvelopeDocumentFields';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeDocumentFields';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes custom document fields from an existing envelope document.';
      tags: ['EnvelopeDocumentFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteDocumentFields';
      'x-ds-service': 'Envelopes';
    };
    get: {
      deprecated: false;
      description: 'Retrieves the custom document field information from an existing envelope document.';
      operationId: 'DocumentFields_GetDocumentFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeDocumentFields';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the custom document fields from an  existing envelope document.';
      tags: ['EnvelopeDocumentFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listDocumentFields';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Creates custom document fields in an existing envelope document.';
      operationId: 'DocumentFields_PostDocumentFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/EnvelopeDocumentFields';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeDocumentFields';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates custom document fields in an existing envelope document.';
      tags: ['EnvelopeDocumentFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createDocumentFields';
      'x-ds-service': 'Envelopes';
    };
    put: {
      deprecated: false;
      description: 'Updates existing custom document fields in an existing envelope document.';
      operationId: 'DocumentFields_PutDocumentFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/EnvelopeDocumentFields';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeDocumentFields';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates existing custom document fields in an existing envelope document.';
      tags: ['EnvelopeDocumentFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateDocumentFields';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/html_definitions': {
    get: {
      deprecated: false;
      description: 'Retrieves the HTML definition used to generate a dynamically sized responsive document.\n\nIf the document was not created as a signable HTML document, this endpoint will return a 200-OK response and an empty JSON body. \n\n**Note:** The `documentId` query parameter is a GUID value, not an integer document ID. If an invalid document ID is provided, this endpoint will return a 200-OK response and an empty JSON body.\n\n### Related topics\n\n- [Responsive signing](/docs/esign-rest-api/esign101/concepts/responsive/)';
      operationId: 'ResponsiveHtml_GetEnvelopeDocumentHtmlDefinitions';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The GUID of the document.\n\nExample: c671747c-xxxx-xxxx-xxxx-4a4a48e23744';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/documentHtmlDefinitionOriginals';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieves the HTML definition used to generate a dynamically sized responsive document.';
      tags: ['EnvelopeDocumentHtmlDefinitions'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getEnvelopeDocumentHtmlDefinitions';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages': {
    get: {
      deprecated: false;
      description: 'Returns images of the pages in a document for display based on the parameters that you specify.';
      operationId: 'Pages_GetPageImages';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The number of dots per inch (DPI) for the resulting images. Valid values are 1-310 DPI. The default value is 94.';
          in: 'query';
          name: 'dpi';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Sets the maximum height of the returned images in pixels.';
          in: 'query';
          name: 'max_height';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Sets the maximum width of the returned images in pixels.';
          in: 'query';
          name: 'max_width';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** using cache is disabled and image information is retrieved from a database. **True** is the default value. ';
          in: 'query';
          name: 'nocache';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** changes display in the user interface.';
          in: 'query';
          name: 'show_changes';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The position within the total result set from which to start returning values. The value **thumbnail** may be used to return the page image.';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/pageImages';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns document page images based on input.';
      tags: ['Envelopes'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getPageImages';
      'x-ds-methodname': 'getDocumentPageImages';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}': {
    delete: {
      deprecated: false;
      description: 'Deletes a page from a document in an envelope based on the page number.';
      operationId: 'Pages_DeletePage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The page number being accessed.';
          in: 'path';
          name: 'pageNumber';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes a page from a document in an envelope.';
      tags: ['Envelopes'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteDocumentPage';
      'x-ds-methodname': 'deleteDocumentPage';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/page_image': {
    get: {
      deprecated: false;
      description: 'Returns an image of a page in a document for display.';
      operationId: 'Pages_GetPageImage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The page number being accessed.';
          in: 'path';
          name: 'pageNumber';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Sets the dots per inch (DPI) for the returned image.';
          in: 'query';
          name: 'dpi';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Sets the maximum height for the page image in pixels. The DPI is recalculated based on this setting.';
          in: 'query';
          name: 'max_height';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Sets the maximum width for the page image in pixels. The DPI is recalculated based on this setting.';
          in: 'query';
          name: 'max_width';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** changes display in the user interface.';
          in: 'query';
          name: 'show_changes';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'image/png': {
              schema: {
                format: 'binary';
                type: 'string';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            'image/png': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a page image from an envelope for display.';
      tags: ['Envelopes'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getPageImage';
      'x-ds-methodname': 'getDocumentPageImage';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Rotates page image from an envelope for display. The page image can be rotated to the left or right.';
      operationId: 'Pages_PutPageImage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The page number being accessed.';
          in: 'path';
          name: 'pageNumber';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/pageRequest';
      };
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Rotates page image from an envelope for display.';
      tags: ['Envelopes'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'rotateDocumentPage';
      'x-ds-methodname': 'rotateDocumentPage';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/tabs': {
    get: {
      deprecated: false;
      description: 'Returns the tabs from the page specified by `pageNumber` of the document specified by `documentId` in the\nenvelope specified by `envelopeId`.\n';
      operationId: 'Tabs_GetPageTabs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The page number being accessed.';
          in: 'path';
          name: 'pageNumber';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeDocumentTabs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns tabs on the specified page.';
      tags: ['EnvelopeDocumentTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getByPage';
      'x-ds-methodname': 'getPageTabs';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/responsive_html_preview': {
    parameters: [];
    post: {
      deprecated: false;
      description: 'Creates a preview of the\n[responsive](/docs/esign-rest-api/esign101/concepts/responsive/)\nHTML version of a specific document.\nThis method enables you to preview a PDF document\nconversion to responsive HTML across device types prior to sending.\n\nThe request body is a `documentHtmlDefinition` object, which holds the responsive signing parameters that define how to generate the HTML version of the signing document.';
      operationId: 'ResponsiveHtml_PostDocumentResponsiveHtmlPreview';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/documentHtmlDefinition';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/documentHtmlDefinitions';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates a preview of the responsive version of a document.';
      tags: ['DocumentResponsiveHtmlPreview'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createDocumentResponsiveHtmlPreview';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs': {
    delete: {
      deprecated: false;
      description: 'Deletes tabs from the document specified by `documentId` in the\nenvelope specified by `envelopeId`.\n';
      operationId: 'Tabs_DeleteDocumentTabs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/tabs';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/tabs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes tabs from a document in an envelope.';
      tags: ['EnvelopeDocumentTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteDocumentTabs';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: 'Returns the tabs on the document specified by `documentId` in the\nenvelope specified by `envelopeId`.\n';
      operationId: 'Tabs_GetDocumentTabs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the response includes metadata indicating which properties are editable.';
          in: 'query';
          name: 'include_metadata';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters for tabs that occur on the pages that you specify. Enter as a comma-separated list of page GUIDs.\n\nExample: `page_numbers=2,6`\n\nNote: You can only enter individual page numbers, and not a page range.';
          in: 'query';
          name: 'page_numbers';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeDocumentTabs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns the tabs on a document.';
      tags: ['EnvelopeDocumentTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getDocumentTabs';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Adds tabs to the document specified by `documentId` in the\nenvelope specified by `envelopeId`.\n\nIn the request body, you only need to specify the tabs that your\nare adding. For example, to add a text\n[prefill tab](/docs/esign-rest-api/reference/envelopes/envelopedocumenttabs/create/#definition__tabs_prefilltabs),\nyour request body might look like this:\n\n```\n{\n  "prefillTabs": {\n    "textTabs": [\n      {\n        "value": "a prefill text tab",\n        "pageNumber": "1",\n        "documentId": "1",\n        "xPosition": 316,\n        "yPosition": 97\n      }\n    ]\n  }\n}\n```\n';
      operationId: 'Tabs_PostDocumentTabs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/tabs';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/tabs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds tabs to a document in an envelope.';
      tags: ['EnvelopeDocumentTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createDocumentTabs';
      'x-ds-service': 'Uncategorized';
    };
    put: {
      deprecated: false;
      description: 'Updates tabs in the document specified by `documentId` in the\nenvelope specified by `envelopeId`.\n';
      operationId: 'Tabs_PutDocumentTabs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/tabs';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/tabs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the tabs for document.';
      tags: ['EnvelopeDocumentTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateDocumentTabs';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates': {
    get: {
      deprecated: false;
      description: 'Retrieves the templates associated with a document in the specified envelope.';
      operationId: 'Templates_GetDocumentTemplates';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list that limits the results.\nValid values are:\n\n* `applied`\n* `matched`\n';
          in: 'query';
          name: 'include';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/templateInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the templates associated with a document in an existing envelope.';
      tags: ['EnvelopeTemplates'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'listByDocument';
      'x-ds-methodname': 'listTemplatesForDocument';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Adds templates to a document in the specified envelope.';
      operationId: 'Templates_PostDocumentTemplates';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'If omitted or set to false (the default),\nenvelope recipients _will be removed_\nif the template being applied\nincludes only  tabs positioned via anchor text for the recipient,\nand none of the documents include the anchor text. \n\nWhen **true,** the recipients _will be preserved_ after the template is applied.\n\n';
          in: 'query';
          name: 'preserve_template_recipient';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/documentTemplateList';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/documentTemplateList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds templates to a document in an  envelope.';
      tags: ['EnvelopeTemplates'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'applyToDocument';
      'x-ds-methodname': 'applyTemplateToDocument';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates/{templateId}': {
    delete: {
      deprecated: false;
      description: 'Deletes the specified template from a document in an existing envelope.';
      operationId: 'Templates_DeleteDocumentTemplates';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes a template from a document in an existing envelope.';
      tags: ['EnvelopeTemplates'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteTemplatesFromDocument';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings': {
    delete: {
      deprecated: false;
      description: 'Deletes all existing email override settings for the envelope. If you want to delete an individual email override setting, use the PUT and set the value to an empty string. Note that deleting email settings will only affect email communications that occur after the deletion and the normal account email settings are used for future email communications.';
      operationId: 'EmailSettings_DeleteEmailSettings';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/emailSettings';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes the email setting overrides for an envelope.';
      tags: ['EnvelopeEmailSettings'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteEmailSettings';
      'x-ds-service': 'Envelopes';
    };
    get: {
      deprecated: false;
      description: 'Retrieves the email override settings for the specified envelope.';
      operationId: 'EmailSettings_GetEmailSettings';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/emailSettings';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the email setting overrides for an envelope.';
      tags: ['EnvelopeEmailSettings'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getEmailSettings';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Adds email override settings, changing the email address to reply to an email address, name, or the BCC for email archive information, for the envelope. Note that adding email settings will only affect email communications that occur after the addition was made.\n\nThe BCC Email address feature is designed to provide a copy of all email communications for external archiving purposes.\nTo send a copy of the envelope to a recipient who does not need to sign, use a Carbon Copy or Certified Delivery recipient type.\n\n**Note:** DocuSign recommends that envelopes sent using the BCC for Email Archive feature, including the BCC Email Override option, include additional signer authentication options. ';
      operationId: 'EmailSettings_PostEmailSettings';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/emailSettings';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/emailSettings';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds email setting overrides to an envelope.';
      tags: ['EnvelopeEmailSettings'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createEmailSettings';
      'x-ds-service': 'Envelopes';
    };
    put: {
      deprecated: false;
      description: 'Updates the existing email override settings for the specified envelope. Note that modifying email settings will only affect email communications that occur after the modification was made.\n\nThis can also be used to delete an individual email override setting by using an empty string for the value to be deleted.';
      operationId: 'EmailSettings_PutEmailSettings';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/emailSettings';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/emailSettings';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the email setting overrides for an envelope.';
      tags: ['EnvelopeEmailSettings'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateEmailSettings';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/form_data': {
    get: {
      deprecated: false;
      description: 'This method downloads the envelope and tab data (also called form data) from any in-process, completed, or canceled envelope that you sent or that is shared with you. Recipients who are also full administrators on an account can view form data for any envelopes that another user on the account has sent to them.\n\n**Note:** To use this feature, the Sending Setting "Allow sender to download form data" must be enabled for the account.\n\n### Related topics\n\n- [How to get envelope tab values](/docs/esign-rest-api/how-to/get-envelope-tab-values/)\n';
      operationId: 'FormData_GetFormData';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeFormData';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns envelope tab data for an existing envelope.';
      tags: ['EnvelopeFormData'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getFormData';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/html_definitions': {
    get: {
      deprecated: false;
      description: '';
      operationId: 'ResponsiveHtml_GetEnvelopeHtmlDefinitions';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/documentHtmlDefinitionOriginals';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the Original HTML Definition used to generate the Responsive HTML for the envelope.';
      tags: ['EnvelopeHtmlDefinitions'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'getEnvelopeHtmlDefinitions';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock': {
    delete: {
      deprecated: false;
      description: 'Deletes the lock from the specified envelope.\nThe user deleting the lock must be the same user\nwho locked the envelope.\n\nYou must include the `X-DocuSign-Edit` header\nas described in\n[EnvelopeLocks: create](/docs/esign-rest-api/reference/envelopes/envelopelocks/create/).\n\nThis method takes an optional query parameter\nthat lets you specify whether\nchanges made while the envelope was locked\nare kept or discarded.\n\n\n| Query Parameter | Description                                                                                                                                                                         |\n| :-------------- | :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |\n| `save_changes`  | When **true** (the default), any changes made while the lock was active are saved. When **false,** any changes made while the envelope was locked are discarded. |\n\n### Related topics\n\n- [Common API Tasks: Locking and unlocking envelopes](https://www.docusign.com/blog/dsdev-common-api-tasks-locking-and-unlocking-envelopes)\n\n';
      operationId: 'Lock_DeleteEnvelopeLock';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeLocks';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes an envelope lock.';
      tags: ['EnvelopeLocks'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteLock';
      'x-ds-service': 'Envelopes';
    };
    get: {
      deprecated: false;
      description: 'Retrieves general information about an envelope lock.\n\nThe user requesting the information must be the same user\nwho locked the envelope.\n\nYou can use this method to recover the lock information,\nincluding the `lockToken`,\nfor a locked envelope.\nThe `X-DocuSign-Edit` header is included in the response.\n\nSee [EnvelopeLocks: create](/docs/esign-rest-api/reference/envelopes/envelopelocks/create/)\nfor a description of the `X-DocuSign-Edit` header.\n\n### Related topics\n\n- [Common API Tasks: Locking and unlocking envelopes](https://www.docusign.com/blog/dsdev-common-api-tasks-locking-and-unlocking-envelopes)\n\n';
      operationId: 'Lock_GetEnvelopeLock';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeLocks';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets envelope lock information.';
      tags: ['EnvelopeLocks'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getLock';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'This method locks the specified envelope and sets the time until\nthe lock expires to prevent other users or recipients from\nchanging the envelope.\n\nThe response to this request includes a `lockToken` parameter\nthat you must use in the `X-DocuSign-Edit` header for\nevery PUT method (typically a method that updates an envelope)\nwhile the envelope is locked.\n\n\nIf you do not provide the `lockToken` when accessing\na locked envelope, you will get the following\nerror:\n\n```\n{\n   "errorCode": "EDIT_LOCK_NOT_LOCK_OWNER",\n   "message": "The user is not the owner of the lock. The template is locked by another user or in another application"\n}\n```\n\n\n### The X-DocuSign-Edit header\n\nThe `X-DocuSign-Edit` header looks like this\nand can be specified in either JSON or XML.\n\n**JSON**\n```\n{\n  "LockToken": "token-from-response",\n  "LockDurationInSeconds": "600"\n}\n```\n\n**XML**\n```\n<DocuSignEdit>\n  <LockToken>token-from-response</LockToken>\n  <LockDurationInSeconds>600</LockDurationInSeconds>\n</DocuSignEdit>\n```\n\nIn the actual HTTP header, you would remove the linebreaks:\n\n```\nX-DocuSign-Edit: {"LockToken": "token-from-response", "LockDurationInSeconds": "600" }\n    or\nX-DocuSign-Edit:<DocuSignEdit><LockToken>token-from-response</LockToken><LockDurationInSeconds>600</LockDurationInSeconds></DocuSignEdit>\n```\n\n\n### Related topics\n\n- [Common API Tasks: Locking and unlocking envelopes](https://www.docusign.com/blog/dsdev-common-api-tasks-locking-and-unlocking-envelopes)\n\n';
      operationId: 'Lock_PostEnvelopeLock';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/lockRequest';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeLocks';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Locks an envelope.';
      tags: ['EnvelopeLocks'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createLock';
      'x-ds-service': 'Envelopes';
    };
    put: {
      deprecated: false;
      description: 'Updates the lock information for a locked envelope.\n\nYou must include the `X-DocuSign-Edit` header\nas described in\n[EnvelopeLocks: create](/docs/esign-rest-api/reference/envelopes/envelopelocks/create/).\n\n\nUse this method to change the duration\nof the lock (`lockDurationInSeconds`)\nor the `lockedByApp` string.\n\nThe request body is a full `lockRequest` object,\nbut you only need to specify the\nproperties that you are updating. For example:\n\n```\n{\n  "lockDurationInSeconds": "3600",\n  "lockedByApp": "My Application"\n}\n```\n\n';
      operationId: 'Lock_PutEnvelopeLock';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/lockRequest';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeLocks';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates an envelope lock.';
      tags: ['EnvelopeLocks'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateLock';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/notification': {
    get: {
      deprecated: false;
      description: 'Retrieves the envelope notification, reminders and expirations, information for an existing envelope.';
      operationId: 'Notification_GetEnvelopesEnvelopeIdNotification';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/notification';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets envelope notification information.';
      tags: ['Envelopes'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getNotificationSettings';
      'x-ds-methodname': 'getNotificationSettings';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method sets the notifications (reminders and expirations) for an existing envelope. The request body sends a structure containing reminders and expirations settings. It also specifies whether to use the settings specified in the request, or the account default notification settings for the envelope.\n\nNote that this request only specifies when notifications are sent; it does not initiate sending of email messages.';
      operationId: 'Notification_PutEnvelopesEnvelopeIdNotification';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/envelopeNotificationRequest';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/notification';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Sets envelope notifications for an existing envelope.';
      tags: ['Envelopes'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateNotificationSettings';
      'x-ds-methodname': 'updateNotificationSettings';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients': {
    delete: {
      deprecated: false;
      description: 'Deletes one or more recipients from a draft or sent envelope. List the recipients that you want to delete in the body of the request. This method uses the `recipientId` as the key for deleting recipients.\n\nIf the envelope is `In Process`, meaning that it has been sent and has not been completed or voided, recipients that have completed their actions cannot be deleted.';
      operationId: 'Recipients_DeleteRecipients';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/EnvelopeRecipients';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeRecipients';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes recipients from an envelope.';
      tags: ['EnvelopeRecipients'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteList';
      'x-ds-methodname': 'deleteRecipients';
      'x-ds-service': 'Envelopes';
    };
    get: {
      deprecated: false;
      description: 'Retrieves the status of all recipients in a single envelope and identifies the current recipient in the routing list. This method can also be used to retrieve the tab values.\n\nThe `currentRoutingOrder` property of the response contains the `routingOrder` value of the current recipient indicating that the envelope has been sent to the recipient, but the recipient has not completed their actions.\n\n### Related topics\n\n- [How to list envelope recipients](/docs/esign-rest-api/how-to/get-envelope-recipients/)\n';
      operationId: 'Recipients_GetRecipients';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: ' When **true** and `include_tabs` value is set to **true,** all tabs with anchor tab properties are included in the response. ';
          in: 'query';
          name: 'include_anchor_tab_locations';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: ' When **true,** the extended properties are included in the response. ';
          in: 'query';
          name: 'include_extended';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Boolean value that specifies whether to include metadata associated with the recipients (for envelopes only, not templates).';
          in: 'query';
          name: 'include_metadata';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the tab information associated with the recipient is included in the response.';
          in: 'query';
          name: 'include_tabs';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeRecipients';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the status of recipients for an envelope.';
      tags: ['EnvelopeRecipients'];
      'x-ds-examples': [
        {
          description: "This example shows the result of an envelope\nwith one signer and a CC'ed recipient.\n\n\n### Request\nThe request for this endpoint has no payload.\n\n```\nGET /restapi/v2.1/accounts/1703061/envelopes/44efc9e6-xxxx-xxxx-xxxx-801410d6922d/recipients\n```\n\n\n";
          direction: 'response';
          format: 'json';
          response: {
            agents: [];
            carbonCopies: [
              {
                email: 'aoneil@example.com';
                name: "Ariana O'Neill";
                recipientId: '2';
                recipientIdGuid: '72edf9b6-xxxx-xxxx-xxxx-86bc5d598bb8';
                requireIdLookup: 'false';
                routingOrder: '2';
                status: 'completed';
                userId: 'b72bd827-xxxx-xxxx-xxxx-64ab32f0a0eb';
              },
            ];
            certifiedDeliveries: [];
            currentRoutingOrder: '1';
            editors: [];
            inPersonSigners: [];
            intermediaries: [];
            recipientCount: '2';
            signers: [
              {
                deliveredDateTime: '2016-10-05T21:18:12.3330000Z';
                email: 'jallard@example.com';
                isBulkRecipient: 'false';
                name: 'Jennie Allard';
                recipientId: '1';
                recipientIdGuid: '4575d5e9-xxxx-xxxx-xxxx-6c59ca7c43f8';
                requireIdLookup: 'false';
                routingOrder: '1';
                signedDateTime: '2016-10-05T21:18:41.6930000Z';
                status: 'completed';
                userId: 'ca45284a-xxxx-xxxx-xxxx-76035bd795b2';
              },
            ];
          };
          style: 'custom';
          title: 'List Recipients and CC-ed Recipients';
        },
        {
          description: "This example shows the method's response after the envelope was signed.\n\nThe signer recipient successfully authenticated using:\n* An access code (a pre-shared secret between the sender and the signer)\n* Authentication via Facebook. The Facebook email address is recorded in the Certificate of Completion\n";
          direction: 'response';
          format: 'json';
          response: {
            agents: [];
            carbonCopies: [];
            certifiedDeliveries: [];
            currentRoutingOrder: '1';
            editors: [];
            inPersonSigners: [];
            intermediaries: [];
            recipientCount: '1';
            signers: [
              {
                accessCode: '1234';
                deliveredDateTime: '2016-07-11T06:19:36.4200000Z';
                email: 'larry@example.com';
                idCheckConfigurationName: 'Facebook';
                isBulkRecipient: 'false';
                name: 'Larry Smithers';
                recipientAuthenticationStatus: {
                  accessCodeResult: {
                    eventTimestamp: '2016-07-11T06:18:55.7170000Z';
                    status: 'Passed';
                  };
                  facebookResult: {
                    eventTimestamp: '2016-07-11T06:19:28.3170000Z';
                    status: 'Passed';
                  };
                };
                recipientId: '1';
                recipientIdGuid: '9670e679-xxxx-xxxx-xxxx-02b43027cb0a';
                requireIdLookup: 'true';
                routingOrder: '1';
                signInEachLocation: 'false';
                signedDateTime: '2016-07-11T06:19:44.7470000Z';
                status: 'completed';
                userId: '57a7b68f-xxxx-xxxx-xxxx-381042d14ca5';
              },
            ];
          };
          style: 'custom';
          title: 'List Recipients Who Used Facebook and Access Code Authentication';
        },
      ];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listRecipients';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Adds one or more recipients to an envelope.\n\nFor an in-process envelope,\none that has been sent and has not been completed or voided,\nan email is sent to a new recipient\nwhen they are reached in the routing order.\nIf the new recipient\'s routing order\nis before or the same as the envelope\'s\nnext recipient,\nan email is only sent if the optional\n`resend_envelope` query string is set to **true.**\n\n\n**Note:** This method works on recipients only.\nTo add recipient tabs,\nuse methods from the [EnvelopeRecipientTabs][recipientTabs] resource.\nFor example, this request body will add a recipient (`astanton@example.com`)\nbut **NOT** the Sign Here recipient tab.\n\n```json\n{\n  "signers": [\n    {\n      "email": "astanton@example.com",\n      "name": "Anne Stanton",\n      "recipientId": "1",\n      "tabs": {           // These tabs will NOT be added\n        "signHereTabs": [ // with this method. See note above.\n          {\n            "anchorString": "below",\n            "tooltip": "please sign here"\n          },\n          . . .\n        ]\n      }\n    }\n  ]\n}\n```\n\n[recipientTabs]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n\n\n### Related topics\n\n- [How to bulk send envelopes](/docs/esign-rest-api/how-to/bulk-send-envelopes/)\n\n\n\n';
      operationId: 'Recipients_PostRecipients';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "When **true,**\nforces the envelope to be resent\nif it would not be resent otherwise.\n\nOrdinarily, if the recipient's routing order\nis before or the same as the envelope's next recipient,\nthe envelope is not resent.\n\nSetting this query parameter\nto **false** has no effect and is the same as omitting\nit altogether.\n";
          in: 'query';
          name: 'resend_envelope';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/EnvelopeRecipients';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeRecipients';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds one or more recipients to an envelope.';
      tags: ['EnvelopeRecipients'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createRecipient';
      'x-ds-service': 'Envelopes';
    };
    put: {
      deprecated: false;
      description: 'Updates the recipients of a draft envelope or corrects recipient information for an in-process envelope.\n\nIf you send information for a recipient that does not already\nexist in a draft envelope, the recipient is added to the envelope\n(similar to the [EnvelopeRecipients: Create][EnvelopeRecipients-create] method).\n\nYou can also use this method to resend an envelope to a recipient\nby using the `resend_envelope` option.\n\n**Updating Sent Envelopes**\n\nAfter an envelope has been sent, you can edit only the following properties:\n\n- `accessCode`\n- `agentCanEditName`\n- `agentCanEditEmail`\n- `customFields`\n- `deliveryMethod`\n- `documentVisibility`\n- `email` (If you provide an email address in this method, it will be treated as a new email address, even if it is exactly the same as the current address. Do not provide an email address if you do not want a correction email sent.)\n- `emailNotification`\n- `idCheckConfigurationName`\n- `identityVerification`\n- `name`\n- `note`\n- `phoneAuthentication`\n- `recipientType` (For this to work, you must also change the recipient object to match the recipient type.)\n- `requireIdLookup`\n- `routingOrder`\n- `routingOrder`\n- `signingGroupId` (You can change this ID to switch to a different signing group and its corresponding set of recipients.)\n- `smsAuthentication`\n- `suppressEmails`\n- `userName`\n\nIf the recipient has signed,\nbut the envelope is still active,\nthe method will return success,\nbut the `recipientUpdateResults` property\nin the response will include an error\nthat the recipient could not be updated:\n\n```\n{\n  "recipientUpdateResults": [\n    {\n      "recipientId": "999",\n      "errorDetails": {\n        "errorCode": "RECIPIENT_UPDATE_FAILED",\n        "message": "The recipient could not be updated.  Recipient not in state that allows correction."\n      }\n    }\n  ]\n}\n```\n\nIf the envelope is completed,\nand you try to change a recipient\'s address,\nthe method will fail with this error:\n\n```\n{\n  "errorCode": "ENVELOPE_INVALID_STATUS",\n  "message": "Invalid envelope status. Envelope status is not one of: Created, Sent, Delivered, Correct."\n}\n```\n\n**Note:** This method works on recipients only.\nTo add recipient tabs,\nuse methods from the [EnvelopeRecipientTabs][recipientTabs] resource.\nFor example, this request body will add a recipient (`astanton@example.com`)\nbut **NOT** the Sign Here recipient tab.\n\n```json\n{\n  "signers": [\n    {\n      "email": "astanton@example.com",\n      "name": "Anne Stanton",\n      "recipientId": "1",\n// THIS WILL NOT WORK\n      "tabs": {\n        "signHereTabs": [\n          {\n            "anchorString": "below",\n            "tooltip": "please sign here3"\n          },\n          . . .\n        ]\n      }\n    }\n  ]\n}\n```\n\n\n[EnvelopeRecipients-create]: /docs/esign-rest-api/reference/envelopes/enveloperecipients/create/\n[recipientTabs]: /docs/esign-rest-api/reference/envelopes/enveloperecipienttabs/\n\n';
      operationId: 'Recipients_PutRecipients';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** recipients are combined or merged with matching recipients. Recipient matching occurs as part of [template matching](https://support.docusign.com/en/guides/ndse-user-guide-manage-automatic-template-matching), and is based on Recipient Role and Routing Order.';
          in: 'query';
          name: 'combine_same_order_recipients';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Indicates if offline signing is enabled for the recipient when a network connection is unavailable. ';
          in: 'query';
          name: 'offline_signing';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: "When **true,**\nforces the envelope to be resent\nif it would not be resent otherwise.\n\nOrdinarily, if the recipient's routing order\nis before or the same as the envelope's next recipient,\nthe envelope is not resent.\n\nSetting this query parameter\nto **false** has no effect and is the same as omitting\nit altogether.\n";
          in: 'query';
          name: 'resend_envelope';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/EnvelopeRecipients';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/recipientsUpdateSummary';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates recipients in a draft envelope or corrects recipient information for an in-process envelope.';
      tags: ['EnvelopeRecipients'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateRecipients';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/document_visibility': {
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method updates document visibility for one or more recipients based on the `recipientId` and `visible` values that you include in the request body.\n\n**Note:** A document cannot be hidden from a recipient if the recipient has tabs assigned to them on the document. Carbon Copy, Certified Delivery (Needs to Sign), Editor, and Agent recipients can always see all documents.';
      operationId: 'Recipients_PutRecipientsDocumentVisibility';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/documentVisibilityList';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/documentVisibilityList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates document visibility for recipients';
      tags: ['EnvelopeDocumentVisibility'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateRecipientsDocumentVisibility';
      'x-ds-methodname': 'updateRecipientsDocumentVisibility';
      'x-ds-service': 'EnvelopeDocumentVisibility';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}': {
    delete: {
      deprecated: false;
      description: 'Deletes a recipient from a `draft` or `sent` envelope.\n\nIf the envelope is "In Process" (has been sent and is not completed or voided), recipients that have completed their actions cannot be deleted.';
      operationId: 'Recipients_DeleteRecipient';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeRecipients';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes a recipient from an envelope.';
      tags: ['EnvelopeRecipients'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteRecipient';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/consumer_disclosure': {
    get: {
      deprecated: false;
      description: 'Retrieves the default, HTML-formatted Electronic Record and Signature Disclosure (ERSD) for the envelope that you specify. \n\nThis is the default ERSD disclosure that DocuSign provides for the convenience of U.S.-based customers only. This default disclosure is only valid for transactions between U.S.-based parties.\n\nTo set the language of the disclosure that you want to retrieve, use the optional `langCode` query parameter.';
      operationId: 'ConsumerDisclosure_GetConsumerDisclosureEnvelopeIdRecipientId';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '(Optional) The code for the signer language version of the disclosure that you want to retrieve. The following languages are supported:\n\n- Arabic (`ar`)\n- Bulgarian (`bg`)\n- Czech (`cs`)\n- Chinese Simplified (`zh_CN`)\n- Chinese Traditional (`zh_TW`)\n- Croatian (`hr`)\n- Danish (`da`)\n- Dutch (`nl`)\n- English US (`en`)\n- English UK (`en_GB`)\n- Estonian (`et`)\n- Farsi (`fa`)\n- Finnish (`fi`)\n- French (`fr`)\n- French Canadian (`fr_CA`)\n- German (`de`)\n- Greek (`el`)\n- Hebrew (`he`)\n- Hindi (`hi`)\n- Hungarian (`hu`)\n- Bahasa Indonesian (`id`)\n- Italian (`it`)\n- Japanese (`ja`)\n- Korean (`ko`)\n- Latvian (`lv`)\n- Lithuanian (`lt`)\n- Bahasa Melayu (`ms`)\n- Norwegian (`no`)\n- Polish (`pl`)\n- Portuguese (`pt`)\n- Portuguese Brazil (`pt_BR`)\n- Romanian (`ro`)\n- Russian (`ru`)\n- Serbian (`sr`)\n- Slovak (`sk`)\n- Slovenian (`sl`)\n- Spanish (`es`)\n- Spanish Latin America (`es_MX`)\n- Swedish (`sv`)\n- Thai (`th`)\n- Turkish (`tr`)\n- Ukrainian (`uk`) \n- Vietnamese (`vi`)\n\nAdditionally, you can automatically detect the browser language being used by the viewer and display the disclosure in that language by setting the value to `browser`.';
          in: 'query';
          name: 'langCode';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/consumerDisclosure';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the default Electronic Record and Signature Disclosure for an envelope.';
      tags: ['EnvelopeConsumerDisclosures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getDefault';
      'x-ds-methodname': 'getConsumerDisclosureDefault';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/consumer_disclosure/{langCode}': {
    get: {
      deprecated: false;
      description: "Retrieves the HTML-formatted Electronic Record and Signature Disclosure (ERSD) for the envelope recipient that you specify. This disclosure might differ from the account-level disclosure, based on the signing brand applied to the envelope and the recipient's language settings.\n\nTo set the language of the disclosure that you want to retrieve, specify the `langCode` as either a path or query parameter.";
      operationId: 'ConsumerDisclosure_GetConsumerDisclosureEnvelopeIdRecipientIdLangCode';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '(Optional) The code for the signer language version of the disclosure that you want to retrieve, as a path parameter. The following languages are supported:\n\n- Arabic (`ar`)\n- Bulgarian (`bg`)\n- Czech (`cs`)\n- Chinese Simplified (`zh_CN`)\n- Chinese Traditional (`zh_TW`)\n- Croatian (`hr`)\n- Danish (`da`)\n- Dutch (`nl`)\n- English US (`en`)\n- English UK (`en_GB`)\n- Estonian (`et`)\n- Farsi (`fa`)\n- Finnish (`fi`)\n- French (`fr`)\n- French Canadian (`fr_CA`)\n- German (`de`)\n- Greek (`el`)\n- Hebrew (`he`)\n- Hindi (`hi`)\n- Hungarian (`hu`)\n- Bahasa Indonesian (`id`)\n- Italian (`it`)\n- Japanese (`ja`)\n- Korean (`ko`)\n- Latvian (`lv`)\n- Lithuanian (`lt`)\n- Bahasa Melayu (`ms`)\n- Norwegian (`no`)\n- Polish (`pl`)\n- Portuguese (`pt`)\n- Portuguese Brazil (`pt_BR`)\n- Romanian (`ro`)\n- Russian (`ru`)\n- Serbian (`sr`)\n- Slovak (`sk`)\n- Slovenian (`sl`)\n- Spanish (`es`)\n- Spanish Latin America (`es_MX`)\n- Swedish (`sv`)\n- Thai (`th`)\n- Turkish (`tr`)\n- Ukrainian (`uk`) \n- Vietnamese (`vi`)\n\nAdditionally, you can automatically detect the browser language being used by the viewer and display the disclosure in that language by setting the value to `browser`.';
          in: 'path';
          name: 'langCode';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '(Optional) The code for the signer language version of the disclosure that you want to retrieve, as a query parameter. The following languages are supported:\n\n- Arabic (`ar`)\n- Bulgarian (`bg`)\n- Czech (`cs`)\n- Chinese Simplified (`zh_CN`)\n- Chinese Traditional (`zh_TW`)\n- Croatian (`hr`)\n- Danish (`da`)\n- Dutch (`nl`)\n- English US (`en`)\n- English UK (`en_GB`)\n- Estonian (`et`)\n- Farsi (`fa`)\n- Finnish (`fi`)\n- French (`fr`)\n- French Canadian (`fr_CA`)\n- German (`de`)\n- Greek (`el`)\n- Hebrew (`he`)\n- Hindi (`hi`)\n- Hungarian (`hu`)\n- Bahasa Indonesian (`id`)\n- Italian (`it`)\n- Japanese (`ja`)\n- Korean (`ko`)\n- Latvian (`lv`)\n- Lithuanian (`lt`)\n- Bahasa Melayu (`ms`)\n- Norwegian (`no`)\n- Polish (`pl`)\n- Portuguese (`pt`)\n- Portuguese Brazil (`pt_BR`)\n- Romanian (`ro`)\n- Russian (`ru`)\n- Serbian (`sr`)\n- Slovak (`sk`)\n- Slovenian (`sl`)\n- Spanish (`es`)\n- Spanish Latin America (`es_MX`)\n- Swedish (`sv`)\n- Thai (`th`)\n- Turkish (`tr`)\n- Ukrainian (`uk`) \n- Vietnamese (`vi`)\n\nAdditionally, you can automatically detect the browser language being used by the viewer and display the disclosure in that language by setting the value to `browser`.';
          in: 'query';
          name: 'langCode';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/consumerDisclosure';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the Electronic Record and Signature Disclosure for a specific envelope recipient.';
      tags: ['EnvelopeConsumerDisclosures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getConsumerDisclosure';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/document_visibility': {
    get: {
      deprecated: false;
      description: 'This method returns information about document visibility for a recipient.';
      operationId: 'Recipients_GetRecipientDocumentVisibility';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/documentVisibilityList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns document visibility for a recipient';
      tags: ['EnvelopeDocumentVisibility'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getRecipientDocumentVisibility';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method updates document visibility for a recipient.\n\n**Note:** A document cannot be hidden from a recipient if the recipient has tabs assigned to them on the document. Carbon Copy, Certified Delivery (Needs to Sign), Editor, and Agent recipients can always see all documents.';
      operationId: 'Recipients_PutRecipientDocumentVisibility';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/documentVisibilityList';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/documentVisibilityList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates document visibility for a recipient';
      tags: ['EnvelopeDocumentVisibility'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateRecipientDocumentVisibility';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/identity_proof_token': {
    parameters: [];
    post: {
      deprecated: false;
      description: 'Creates a resource token for a sender. This token allows a sender to return identification data for a recipient using the [ID Evidence API](/docs/idevidence-api/).';
      operationId: 'Recipients_PostRecipientProofFileResourceToken';
      parameters: [
        {
          description: 'The account ID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The `recipientIdGuid`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/idEvidenceResourceToken';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates a resource token for a sender to request ID Evidence data. ';
      tags: ['EnvelopeRecipients'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'createRecipientProofFileResourceToken';
      'x-ds-methodname': 'createRecipientProofFileResourceToken';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/initials_image': {
    get: {
      deprecated: false;
      description: 'Retrieves the initials image for the specified user. The image is returned in the same format as it was uploaded. In the request you can specify if the chrome (the added line and identifier around the initial image) is returned with the image.\n\nThe userId specified in the endpoint must match the authenticated user\'s user ID and the user must be a member of the account.\n\nThe `signatureIdOrName` parameter accepts signature ID or signature name. DocuSign recommends you use signature ID (`signatureId`), since some names contain characters that do not properly URL encode. If you use the user name, it is likely that the name includes spaces and you might need to URL encode the name before using it in the endpoint.\n\nFor example: "Bob Smith" to "Bob%20Smith"\n\nOlder envelopes might only contain chromed images. If getting the non-chromed image fails, try getting the chromed image.';
      operationId: 'Recipients_GetRecipientInitialsImage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The added line and identifier around the initial image. Note: Older envelopes might only have chromed images. If getting the non-chromed image fails, try getting the chromed image.';
          in: 'query';
          name: 'include_chrome';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'image/gif': {
              schema: {
                format: 'binary';
                type: 'string';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            'image/gif': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the initials image for a user.';
      tags: ['Envelopes'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getRecipientInitialsImage';
      'x-ds-methodname': 'getRecipientInitialsImage';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Updates the initials image for a signer that does not have a DocuSign account. The supported image formats for this file are: gif, png, jpeg, and bmp. The file size must be less than 200K.\n\nFor the Authentication/Authorization for this call, the credentials must match the sender of the envelope, the recipient must be an accountless signer or in person signer. The account must have the `CanSendEnvelope` property set to **true** and the `ExpressSendOnly` property in `SendingUser` structure must be set to **false.**';
      operationId: 'Recipients_PutRecipientInitialsImage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Sets the initials image for an accountless signer.';
      tags: ['Envelopes'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateRecipientInitialsImage';
      'x-ds-methodname': 'updateRecipientInitialsImage';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature': {
    get: {
      deprecated: false;
      description: 'Retrieves signature information for a signer or sign-in-person recipient.';
      operationId: 'Recipients_GetRecipientSignature';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userSignature';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets signature information for a signer or sign-in-person recipient.';
      tags: ['Envelopes'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getRecipientSignature';
      'x-ds-methodname': 'getRecipientSignature';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature_image': {
    get: {
      deprecated: false;
      description: 'Retrieves the specified user signature image. The image is returned in the same format as uploaded. In the request you can specify if the chrome (the added line and identifier around the initial image) is returned with the image.\n\nThe userId specified in the endpoint must match the authenticated user\'s user ID and the user must be a member of the account.\n\nThe `signatureIdOrName` parameter accepts signature ID or signature name. DocuSign recommends you use signature ID (`signatureId`), since some names contain characters that don\'t properly URL encode. If you use the user name, it is likely that the name includes spaces and you might need to URL encode the name before using it in the endpoint. \n\nFor example: "Bob Smith" to "Bob%20Smith"\n\nOlder envelopes might only have chromed images. If getting the non-chromed image fails, try getting the chromed image.';
      operationId: 'Recipients_GetRecipientSignatureImage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the response includes the chromed version of the signature image.';
          in: 'query';
          name: 'include_chrome';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'image/gif': {
              schema: {
                format: 'binary';
                type: 'string';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            'image/gif': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieve signature image information for a signer/sign-in-person recipient.';
      tags: ['Envelopes'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getRecipientSignatureImage';
      'x-ds-methodname': 'getRecipientSignatureImage';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Updates the signature image for an accountless signer. The supported image formats for this file are: gif, png, jpeg, and bmp. The file size must be less than 200K.\n\nFor the Authentication/Authorization for this call, the credentials must match the sender of the envelope, the recipient must be an accountless signer or in person signer. The account must have the `CanSendEnvelope` property set to **true** and the `ExpressSendOnly` property in `SendingUser` structure must be set to **false.**';
      operationId: 'Recipients_PutRecipientSignatureImage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Sets the signature image for an accountless signer.';
      tags: ['Envelopes'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateRecipientSignatureImage';
      'x-ds-methodname': 'updateRecipientSignatureImage';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs': {
    delete: {
      deprecated: false;
      description: 'Deletes one or more tabs associated with a recipient in a draft envelope.';
      operationId: 'Recipients_DeleteRecipientTabs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/EnvelopeRecipientTabs';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeRecipientTabs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes the tabs associated with a recipient.\n\n**Note:** It is an error to delete a tab that has the\n`templateLocked` property set to true.\nThis property corresponds to the **Restrict changes** option in the web app.\n\n';
      tags: ['EnvelopeRecipientTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteTabs';
      'x-ds-service': 'Envelopes';
    };
    get: {
      deprecated: false;
      description: 'Retrieves information about the tabs associated\nwith a recipient. You can make a single API call\nto get all the tab values and information from a\ngiven, completed envelope in addition to draft\nones.  Tab values can be retrieved by using the\n[EnvelopeRecipients:list method](/docs/esign-rest-api/reference/envelopes/enveloperecipients/list/)\nwith query parameter `include_tabs` set to **true.**';
      operationId: 'Recipients_GetRecipientTabs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** all tabs with anchor tab properties are included in the response. The default value is **false.**';
          in: 'query';
          name: 'include_anchor_tab_locations';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the response includes metadata indicating which properties are editable.';
          in: 'query';
          name: 'include_metadata';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeRecipientTabs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the tabs information for a signer or sign-in-person recipient in an envelope.';
      tags: ['EnvelopeRecipientTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listTabs';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Adds one or more tabs for a recipient.';
      operationId: 'Recipients_PostRecipientTabs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/EnvelopeRecipientTabs';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeRecipientTabs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds tabs for a recipient.';
      tags: ['EnvelopeRecipientTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createTabs';
      'x-ds-service': 'Envelopes';
    };
    put: {
      deprecated: false;
      description: 'Updates one or more tabs for a recipient in a draft envelope.\nA draft envelope is one that is not yet complete.\n\n**Note:** It is an error to update a tab that has the\n`templateLocked` property set to true.\nThis property corresponds to the **Restrict changes** option in the web app.\n\n';
      operationId: 'Recipients_PutRecipientTabs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/EnvelopeRecipientTabs';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeRecipientTabs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the tabs for a recipient.\n\n';
      tags: ['EnvelopeRecipientTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateTabs';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/views/identity_manual_review': {
    parameters: [];
    post: {
      deprecated: false;
      description: 'This method returns the URL of the page that allows a sender to [manually review](https://support.docusign.com/en/guides/ndse-user-guide-send-documents-with-id-verification) the ID of a recipient. ';
      operationId: 'Views_PostRecipientManualReviewView';
      parameters: [
        {
          description: 'A value that identifies your account. This value is automatically generated by DocuSign for any account you create. Copy the value from the API Account ID field in the [AppsI and Keys](https://support.docusign.com/en/guides/ndse-admin-guide-api-and-keys) page.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A GUID value that DocuSign assigns to identify each recipient in an envelope. This value is globally unique for all recipients, not just those in your account.\n\nThe specified recipient must belong to a workflow that allows the [manual review](https://support.docusign.com/en/guides/Identity-Verification-DocuSign-eSignature-Admin-Guide) of IDs. In addition, the status of the automatic verification for this recipient must return `Failed` and the value of the `vendorFailureStatusCode` field must be `MANUAL_REVIEW_STARTED` as shown in the following extract of a response to the [GET ENVELOPE](/docs/esign-rest-api/reference/envelopes/envelopes/get/) method:\n<p>\n\n```\n"recipientAuthenticationStatus": {\n       "identityVerificationResult": { \n             "status": "Failed",\n             "eventTimestamp": "2020-09-04T16:59:42.8045667Z",\n             "vendorFailureStatusCode": "MANUAL_REVIEW_STARTED"\n        }\n  }\n```';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/viewUrl';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Create the link to the page for manually reviewing IDs.';
      tags: ['EnvelopeRecipients'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createRecipientManualReviewView';
      'x-ds-methodname': 'createRecipientManualReviewView';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/responsive_html_preview': {
    parameters: [];
    post: {
      deprecated: false;
      description: 'Creates a preview of the\n[responsive](/docs/esign-rest-api/esign101/concepts/responsive/),\nHTML versions of all of the documents in an\nenvelope. This method enables you to preview the\nPDF document conversions to responsive HTML across\ndevice types prior to sending.\n\nThe request body is a `documentHtmlDefinition`\nobject, which holds the responsive signing\nparameters that define how to generate the HTML\nversion of the documents.\n';
      operationId: 'ResponsiveHtml_PostResponsiveHtmlPreview';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/documentHtmlDefinition';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/documentHtmlDefinitions';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates a preview of the responsive versions of all of the documents in an envelope.';
      tags: ['ResponsiveHtmlPreview'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createResponsiveHtmlPreview';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/tabs_blob': {
    get: {
      deprecated: false;
      description: 'This endpoint has been deprecated.';
      operationId: 'TabsBlob_GetTabsBlob';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Reserved for DocuSign.';
      tags: ['TabsBlob'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getTabsBlob';
      'x-ds-methodname': 'getTabsBlob';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This endpoint has been deprecated.';
      operationId: 'TabsBlob_PutTabsBlob';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Reserved for DocuSign.';
      tags: ['TabsBlob'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'putTabsBlob';
      'x-ds-methodname': 'putTabsBlob';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/templates': {
    get: {
      deprecated: false;
      description: 'This returns a list of the server-side templates, their name and ID, used in an envelope.\n';
      operationId: 'Templates_GetEnvelopeTemplates';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The possible value is `matching_applied`, which returns template matching information for the template.';
          in: 'query';
          name: 'include';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/templateInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Get List of Templates used in an Envelope';
      tags: ['EnvelopeTemplates'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listTemplates';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Adds templates to the specified envelope.';
      operationId: 'Templates_PostEnvelopeTemplates';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'If omitted or set to false (the default),\nenvelope recipients _will be removed_\nif the template being applied\nincludes only  tabs positioned via anchor text for the recipient,\nand none of the documents include the anchor text. \n\nWhen **true,** the recipients _will be preserved_ after the template is applied.\n\n';
          in: 'query';
          name: 'preserve_template_recipient';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/documentTemplateList';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/documentTemplateList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds templates to an envelope.';
      tags: ['EnvelopeTemplates'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'apply';
      'x-ds-methodname': 'applyTemplate';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/correct': {
    delete: {
      deprecated: false;
      description: 'Revokes the correction view URL to the Envelope UI.';
      operationId: 'Views_DeleteEnvelopeCorrectView';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/correctViewRequest';
      };
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Revokes the correction view URL to the Envelope UI.';
      tags: ['EnvelopeViews'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteEnvelopeCorrectView';
      'x-ds-methodname': 'deleteEnvelopeCorrectView';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Returns a URL that allows you to embed the envelope correction view of the DocuSign UI. To customize the appearance of the correction view, you can add special query parameters to the returned URL when you use it in your application.\n\nYou can revoke this URL by calling the [deleteEnvelopeCorrectView](/docs/esign-rest-api/reference/envelopes/envelopeviews/deleteenvelopecorrectview/) endpoint.\n\n## Best practices\n\nThe returned URL expires after 10 minutes and can only be used once. Therefore, request the URL immediately before you redirect your user to it.\n\nDue to screen space issues, do not use an `<iframe>` for embedded operations on mobile devices. For iOS devices, DocuSign recommends using a WebView.\n\n## Customizing the correction view\n\nTo customize the appearance of the correction view, you can add query parameters **to the URL that is returned by this endpoint and used in your application.** Do not add these query parameters to the URL of the endpoint itself.\n\nFor example, adding the following query parameters to the URL returned by this method causes the sending view to:\n\n- start in the tagging screen\n- hide the Edit Pages command\n- hide all of the options under the Actions dropdown except Save, Close, and Discard\n\n```\nhttps://demo.docusign.net/Member/StartInSession.aspx?StartConsole=1&t=dd3b7c4c-xxxx-xxxx-xxxx-50cd195a3401&DocuEnvelope=f37489d3-xxxx-xxxx-xxxx-4de057063d0e&\\\n        advcorrect=1&\\\n        showEditPages=false&\\\n        showHeaderActions=false\n```\n\n\nThe default value reflects what happens\nif you omit the customization query parameter.\n<!--\nYou can use the interactive\n[Embedded Sending Demo tool](https://dsdemos.esigndemos.com/embeddedsending/v3/embeddedsending.aspx)\nto see the effect of using different query parameters.\n -->\n\n\n\n| Query Parameter             | Default Value                                                                                                    | Alternate Value                                                                                                                                                                                                                                   |\n| :-------------------------- | :--------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |\n| sendButtonAction            | `send`<br><br>The Send button operates normally.                                                                 | `redirect`<br><br>The text of the button changes to Continue. Clicking it redirects to the `returnUrl` in the request object. If you intend to modify the envelope after redirection, see [this note](#modifying-the-envelope-after-redirection). |\n| backButtonAction            | `previousPage`<br><br>The back arrow and back button operate normally.                                           | `redirect`<br><br>Clicking the back arrow and back button redirects to the `returnUrl` in the request object. If you intend to modify the envelope after redirection, see [this note](#modifying-the-envelope-after-redirection).                 |\n| showBackButton              | `true` <br><br> Shows the back arrow and the back button.                                                        | `false`<br><br>Hides the back arrow and the back button.                                                                                                                                                                                          |\n| showEditRecipients          | `true` <br><br> Shows the Edit Recipients command in the action menu and in the Conditional Recipients settings. | `false`<br><br>Hides the Edit Recipients command.                                                                                                                                                                                                 |\n| showEditDocuments           | `true` <br><br> Shows the Edit Documents command in the action menu and removes the Documents Gear icon.         | `false`<br><br>Hides the Edit Documents command.                                                                                                                                                                                                  |\n| showEditDocumentVisibility  | `true` <br><br> Shows the Documents Gear icon where the sender can edit document visibility.                     | `false`<br><br>Hides the Documents Gear icon.                                                                                                                                                                                                     |\n| showEditPages               | `true` <br><br> Shows the Edit Pages command under the document thumbnail.                                       | `false`<br><br>Hides the Edit Pages command.                                                                                                                                                                                                      |\n| showMatchingTemplatesPrompt | `true` <br><br> Shows the matching template prompt.                                                              | `false`<br><br>Hides the matching template prompt.                                                                                                                                                                                                |\n| showHeaderActions           | `true` <br><br> Shows all options under the Actions dropdown.                                                    | `false`<br><br>Hides all options under the Actions dropdown except Save, Close, and Discard.                                                                                                                                                      |\n| showDiscardAction           | `true` <br><br> Shows the Discard command under the Actions dropdown.                                            | `false`<br><br>Hides the Discard command.                                                                                                                                                                                                         |\n| advcorrect                  | `1`    <br><br> Starts the signer in the tagging screen.                                                         | `0`<br><br>Starts the signer in the prepare screen.                                                                                                                                                                                               |\n| tabPaletteType              | `standard` <br><br> Displays the standard tab palette.                                                           | `custom`<br>`merge`<br>`notary`<br>`seals`<br>`smartcontracts`<br>`annotations`<br>`smartSections`<br><br>Displays the specified tab palette before the standard palette.                                                                         |\n\n\n##  Modifying the envelope after redirection\n\nIf you use `sendButtonAction=redirect` or `backButtonAction=redirect`, and you intend to modify the envelope after redirection, you will need to lock the envelope and add an extra query parameter:\n\n1.  [Create a lock token][createLock] for the envelope.\n2.  Add the new lock token to the URL with the `lockToken` query parameter.<br>\n    `...&sendButtonAction=redirect&lockToken=MDgxZxabUVBiMWUzZWYz`<br>\n    **Note:** The `lockToken` query parameter is case-sensitive.\n\n\nAfter clicking Continue,\nyour user is redirected back to your integration.\nYou can then [delete the lock token][deleteLock].\n\n[createLock]: /docs/esign-rest-api/reference/envelopes/envelopelocks/create/\n[deleteLock]: /docs/esign-rest-api/reference/envelopes/envelopelocks/delete/\n\n\n## Information security notice\n\nThis method provides full access to the sending account. When you\nuse this view, the current user has full access to the account.\nIf the account has administrative privileges, then this method\nalso provides administrator access.\n\nIf your use case needs to enable a sender to update a draft\nenvelope before it is sent or make other changes, take one of the\nfollowing steps:\n\n- Configure each sender to have their own individual user account\n  to use this API method.\n- Enhance your API integration so that this method is not needed.\n  Your integration can create the tabs, recipients,\n  and other envelope settings as needed.\n\n\n### Related topics\n\n- [Embedded signing and sending](/docs/esign-rest-api/esign101/concepts/embedding/)\n- [How to send an envelope via your app](/docs/esign-rest-api/how-to/embedded-sending/)\n- [How to embed the DocuSign UI in your app](/docs/esign-rest-api/how-to/embed-ui/)\n- [Introducing customizable embedded sending](https://www.docusign.com/blog/developers/introducing-customizable-embedded-sending)\n';
      operationId: 'Views_PostEnvelopeCorrectView';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/correctViewRequest';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeViews';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns a URL to the envelope correction UI.';
      tags: ['EnvelopeViews'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createCorrect';
      'x-ds-methodname': 'createCorrectView';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/edit': {
    parameters: [];
    post: {
      deprecated: false;
      description: 'Returns a URL that enables you to embed the edit view of the DocuSign UI in your applications. This is a one-time use login token that allows the user to be placed into the DocuSign editing view.  Upon sending completion, the user is returned to the return URL provided by the API application.\n\nSee [Embedded signing and sending](/docs/esign-rest-api/esign101/concepts/embedding/)\nto learn more about embedding.\n\nDue to screen space issues,\ndo not use an `<iframe>` for embedded operations on mobile devices.\nFor iOS devices, DocuSign recommends using a WebView.\n\n### Revoking the URL\n\nYou can revoke this URL by making\na DELETE HTTP request to the URL\nwith no request body.\n\n## Information security notice\n\nThis method provides full access to the sending account. When you\nuse this view, the current user has full access to the account.\nIf the account has administrative privileges, then this method\nalso provides administrator access.\n\nIf your use case needs to enable a sender to update a draft envelope before it is sent or make other changes, take one of the following steps:\n\n- Configure each sender to have their own individual user account to use this API method.</li>\n- Enhance your API integration so that this method is not needed. Your integration can create the tabs, recipients, and other envelope settings as needed.</li>\n\n### Related topics\n\n- [Embedded signing and sending](/docs/esign-rest-api/esign101/concepts/embedding/)\n- [How to send an envelope via your app](/docs/esign-rest-api/how-to/embedded-sending/)\n- [How to embed the DocuSign UI in your app](/docs/esign-rest-api/how-to/embed-ui/)\n';
      operationId: 'Views_PostEnvelopeEditView';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/returnUrlRequest';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeViews';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns a URL to the edit view UI.';
      tags: ['EnvelopeViews'];
      'x-ds-examples': [
        {
          description: 'The response contains the URL\nof the embeddable edit view\nfor a specified envelope.\n\nThe request body contains\na `returnUrl`.\nThis is the URL\nthat the DocuSign platform\nwill redirect the user to\nwhen the view is closed.\n\n';
          direction: 'both';
          format: 'json';
          request: {
            returnUrl: 'https://dsapp.example.com/return/from/edit/view';
          };
          response: {
            url: 'https://demo.docusign.net/Member/StartInSession.aspx?StartConsole=1&t=c8dc7c1e-xxxx-xxxx-xxxx-405ba1f7d38b&DocuEnvelope=4b728be4-xxxx-xxxx-xxxx-d63e23f822b6&send=1';
          };
          style: 'custom';
          title: 'Getting an Edit View URL and Setting a Return URL';
        },
      ];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createEdit';
      'x-ds-methodname': 'createEditView';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/recipient': {
    parameters: [];
    post: {
      deprecated: false;
      description: "Returns a URL that enables you to\n[embed the recipient view](/docs/esign-rest-api/esign101/concepts/embedding/)\nof the\nDocuSign UI in your applications. If the recipient is a signer,\nthen the view will provide the signing ceremony.\n\nThis method is only used with envelopes in the `sent` status.\n\nDue to screen space issues,\ndo not use an `<iframe>` for embedded operations on mobile devices.\nFor iOS devices, DocuSign recommends using a WebView.\n\n### Revoking the URL\n\nYou can revoke this URL by making\na DELETE HTTP request to the URL\nwith no request body.\n\n\n## Authentication\n\nYour application is responsible for authenticating the identity\nof the recipient or signer when you use this method. Use the\nfollowing parameters to record how the recipient\nwas authenticated.\n\n- `assertionId`\n- `authenticationInstant`\n- `authenticationMethod`\n- `clientUserId`\n- `securityDomain`\n\nAt a minimum, `authenticationMethod` and `clientUserId` are\nrequired. The information that you provide is included in the\nenvelope's certificate of completion.\n\n## Redirects\nAfter the signer completes or ends the signing ceremony, DocuSign\nredirects the user's browser back to your app via the\n`returnUrl` that you supply.\n\n**Note:** The user may be redirected through various DocuSign\nsubdomains, depending on the region of the account sending the\nenvelope. Please consult the **Allowlists for DocuSign eSignature service**\nsection in [Security for DocuSign eSignature](https://www.docusign.com/trust/security/esignature)\nwhen setting up your allowlists.\n\n### The event status parameter\nDocuSign appends an `event` query parameter to the `returnUrl` with the\noutcome of the signing ceremony. Your app can use this event\nparameter to determine the next step for the envelope.\nDo not fetch the envelope status by using\n[Envelopes: get](/docs/esign-rest-api/reference/envelopes/envelopes/get/)\nor a similar method because doing so could break\nthe DocuSign rule against polling.\n\n**Note:** Because a user can cancel redirection, close their\nbrowser after signing, or spoof the landing URL, the\n`returnUrl` should not be the single source of truth for envelope\nstatus for your integration.\n\n## The URL is time-limited\n\nThe URL returned in this method's response is valid for one use,\nand you must use or display it within a couple of minutes after\nit is generated. After the recipient is redirected to the\nrecipient view, they must interact with the DocuSign system\nperiodically or their session will time out.\n\nBecause the URL is time-limited, it should not be stored or sent\nthrough email. After you receive it, immediately redirect the\nuser's browser to the URL.\n\nIf you want to invite someone to an embedded signing session via\nemail, the email invitation's URL must be to your application.\nWhen invoked, your app should request a `recipientView` URL from\nDocuSign and then redirect the signer to that URL.\n\n## Maintaining State\nAfter the recipient completes the recipient view (or signing\nceremony), they are redirected to your application. Your\napplication can recover state information about the transaction\nby storing information in a cookie, or by including query\nparameters in the `returnUrl` field. For example.\n`https://myapp.example.com/docusign_return?myState=12345` When the\nuser is redirected to your app, the `event` query parameter will\nbe appended. In this example, prevent spoofing by not using a\nguessable value as the state value.\n\n\n## How to specify the default language\n\nThe language for the recipient view\nfollows this order or precedence:\n\n- The language specified by the sender for the recipient.\n- The `locale` parameter appended to the URL.\n- The account language if the signer has a DocuSign account.\n- The language used in a previous signing if the signer is return signer.\n- The browser language.\n\nYou can append the `locale`\nquery parameter\nto the URL returned by this method\nto specify a language.\nFor example, to set the default language\nto Canadian French, you would set\nit like this:\n\n```\n...?locale=fr_CA\n```\n\n## Sending to a remote signer\n\nYou can request a signing session for a remote recipient\nwho has a DocuSign account.\n\nAuthenticate the request using the recipient's\ncredentials, and do not specify a  `clientUserId`.\nThis differs from the typical behavior where the\nrequest is authenticated using the sender's credentials,\nand the recipient has a `clientUserId` defined.\n\n\n\n\n### Related topics\n\n- [How to request a signature by email](/docs/esign-rest-api/how-to/request-signature-email-remote/)\n- [How to request a signature through your app](/docs/esign-rest-api/how-to/request-signature-in-app-embedded/)\n- [How to request a signature using a composite template](/docs/esign-rest-api/how-to/request-signature-composite-template-embedded/)\n- [How to send an envelope via your app](/docs/esign-rest-api/how-to/embedded-sending/)\n- [How to set envelope tab values](/docs/esign-rest-api/how-to/set-envelope-tab-values/)\n- [How to set tab values in a template](/docs/esign-rest-api/how-to/set-template-tab-values/)\n\n";
      operationId: 'Views_PostEnvelopeRecipientView';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the draft envelope or template to preview.';
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/recipientViewRequest';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeViews';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns a URL to the recipient view UI.';
      tags: ['EnvelopeViews'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createRecipient';
      'x-ds-methodname': 'createRecipientView';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/recipient_preview': {
    parameters: [];
    post: {
      deprecated: false;
      description: "Returns a URL to preview the recipients' view of a draft envelope or template. You can embed this view in your application to enable the sender to preview the recipients' experience.\n\nFor more information, see [Preview and Send](https://support.docusign.com/en/guides/ndse-user-guide-send-your-documents).";
      operationId: 'Views_PostEnvelopeRecipientPreview';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/recipientPreviewRequest';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/viewUrl';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates an envelope recipient preview.';
      tags: ['EnvelopeRecipients'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createEnvelopeRecipientPreview';
      'x-ds-methodname': 'createEnvelopeRecipientPreview';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/sender': {
    parameters: [];
    post: {
      deprecated: false;
      description: "Returns a URL that enables you to embed the sender view\nof the DocuSign UI in your applications.\n\nSee [Embedded signing and sending](/docs/esign-rest-api/esign101/concepts/embedding/)\nto learn more about embedding.\n\nThe returned URL can only be redirected to immediately after it\nis generated. It can only be used once. Therefore, request the\nURL immediately before you redirect your user to it.\n\nDue to screen space issues,\ndo not use an `<iframe>` for embedded operations on mobile devices.\nFor iOS devices, DocuSign recommends using a WebView.\n\nAfter the user has completed the sending view, the browser is\nredirected to the `returnUrl` supplied.\n\nBy default, if the envelope already contains one or more\ndocuments, DocuSign will initially show the document tagging view\nwhen you redirect to the URL.\n\nTo start with the envelope's recipients and documents view\ninstead, examine the URL in the method's response. Then change\nthe query parameter from `send=1` to `send=0` to start with the\nrecipients/documents view.\n\n### Revoking the URL\n\nYou can revoke this URL by making\na DELETE HTTP request to the URL\nwith no request body.\n\n\n\n## Customizing the sending view\n\nYou can add query parameters\nto customize the appearance of the sending view.\nFor example, adding the following query parameters\nto the URL returned by this method\ncauses the sending view to:\n\n- start in the tagging screen\n- hide the Edit Pages command\n- hide all of the options under the Actions dropdown except Save, Close, and Discard\n\n```\nhttps://demo.docusign.net/Member/StartInSession.aspx?StartConsole=1&t=dd3b7c4c-xxxx-xxxx-xxxx-50cd195a3401&DocuEnvelope=f37489d3-xxxx-xxxx-xxxx-4de057063d0e&\\\n        send=1&\\\n        showEditPages=false&\\\n        showHeaderActions=false\n```\n\n\nThe default value reflects what happens\nif you omit the customization query parameter.\n<!--\nYou can use the interactive\n[Embedded Sending Demo tool](https://dsdemos.esigndemos.com/embeddedsending/v3/embeddedsending.aspx)\nto see the effect of using different query parameters.\n -->\n\n| Query Parameter             | Default Value                                                                                                    | Alternate Value                                                                                                                                                                                                                                   |\n| :-------------------------- | :--------------------------------------------------------------------------------------------------------------- | :------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |\n| sendButtonAction            | `send`<br><br>The Send button operates normally.                                                                 | `redirect`<br><br>The text of the button changes to Continue. Clicking it redirects to the `returnUrl` in the request object. If you intend to modify the envelope after redirection, see [this note](#modifying-the-envelope-after-redirection). |\n| backButtonAction            | `previousPage`<br><br>The back arrow and back button operate normally.                                           | `redirect`<br><br>Clicking the back arrow and back button redirects to the `returnUrl` in the request object. If you intend to modify the envelope after redirection, see [this note](#modifying-the-envelope-after-redirection).                 |\n| showBackButton              | `true` <br><br> Shows the back arrow and the back button.                                                        | `false`<br><br>Hides the back arrow and the back button.                                                                                                                                                                                          |\n| showEditRecipients          | `true` <br><br> Shows the Edit Recipients command in the action menu and in the Conditional Recipients settings. | `false`<br><br>Hides the Edit Recipients command.                                                                                                                                                                                                 |\n| showEditDocuments           | `true` <br><br> Shows the Edit Documents command in the action menu and removes the Documents Gear icon.         | `false`<br><br>Hides the Edit Documents command.                                                                                                                                                                                                  |\n| showEditDocumentVisibility  | `true` <br><br> Shows the Documents Gear icon where the sender can edit document visibility.                     | `false`<br><br>Hides the Documents Gear icon.                                                                                                                                                                                                     |\n| showEditPages               | `true` <br><br> Shows the Edit Pages command under the document thumbnail.                                       | `false`<br><br>Hides the Edit Pages command.                                                                                                                                                                                                      |\n| showMatchingTemplatesPrompt | `true` <br><br> Shows the matching template prompt.                                                              | `false`<br><br>Hides the matching template prompt.                                                                                                                                                                                                |\n| showHeaderActions           | `true` <br><br> Shows all options under the Actions dropdown.                                                    | `false`<br><br>Hides all options under the Actions dropdown except Save, Close, and Discard.                                                                                                                                                      |\n| showDiscardAction           | `true` <br><br> Shows the Discard command under the Actions dropdown.                                            | `false`<br><br>Hides the Discard command.                                                                                                                                                                                                         |\n| send                        | `1`    <br><br> Starts the signer in the tagging screen.                                                         | `0`<br><br>Starts the signer in the prepare screen.                                                                                                                                                                                               |\n| tabPaletteType              | `standard` <br><br> Displays the standard tab palette.                                                           | `custom`<br>`merge`<br>`notary`<br>`seals`<br>`smartcontracts`<br>`annotations`<br>`smartSections`<br><br>Displays the specified tab palette before the standard palette.                                                                         |\n\n##  Modifying the envelope after redirection\n\nIf you use `sendButtonAction=redirect`\nor\n`backButtonAction=redirect`,\nand\nyou intend to modify the envelope after redirection,\nyou will need to lock the envelope\nand\nadd an extra query parameter:\n\n1.  [Create a lock token][createLock] for the envelope.\n2.  Add the new lock token to the URL with the `lockToken` query parameter.<br>\n    `...&sendButtonAction=redirect&lockToken=MDgxZxabUVBiMWUzZWYz`<br>\n    **Note:** The `lockToken` query parameter is case-sensitive.\n\n\nAfter clicking Continue,\nyour user is redirected back to your integration.\nYou can then [delete the lock token][deleteLock].\n\n[createLock]: /docs/esign-rest-api/reference/envelopes/envelopelocks/create/\n[deleteLock]: /docs/esign-rest-api/reference/envelopes/envelopelocks/delete/\n\n\n## Information security notice\n\nThis method provides full access to the sending account. When you\nuse this view, the current user has full access to the account.\nIf the account has administrative privileges, then this method\nalso provides administrator access.\n\nIf your use case needs to enable a sender to update a draft\nenvelope before it is sent or make other changes, take one of the\nfollowing steps:\n\n- Configure each sender to have their own individual user account\n  to use this API method.\n- Enhance your API integration so that this method is not needed.\n  Your integration can create the tabs, recipients,\n  and other envelope settings as needed.\n\n\n### Related topics\n\n- [Embedded signing and sending](/docs/esign-rest-api/esign101/concepts/embedding/)\n- [How to send an envelope via your app](/docs/esign-rest-api/how-to/embedded-sending/)\n- [How to embed the DocuSign UI in your app](/docs/esign-rest-api/how-to/embed-ui/)\n- [Introducing customizable embedded sending](https://www.docusign.com/blog/developers/introducing-customizable-embedded-sending)\n";
      operationId: 'Views_PostEnvelopeSenderView';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/returnUrlRequest';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeViews';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns a URL to the sender view UI.';
      tags: ['EnvelopeViews'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createSender';
      'x-ds-methodname': 'createSenderView';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/shared': {
    parameters: [];
    post: {
      deprecated: false;
      description: 'Returns a URL that enables you to embed the DocuSign UI recipient view of a [shared envelope](https://support.docusign.com/en/guides/ndse-admin-guide-share-envelopes) in your applications. This is the view that a user sees of an envelope that a recipient on the same account has shared with them.\n\nDue to screen space issues,\ndo not use an `<iframe>` for embedded operations on mobile devices.\nFor iOS devices, DocuSign recommends using a WebView.\n\n### Revoking the URL\n\nYou can revoke this URL by making\na DELETE HTTP request to the URL\nwith no request body.\n\n### Related topics\n\n- [Embedded signing and sending](/docs/esign-rest-api/esign101/concepts/embedding/)\n- [How to send an envelope via your app](/docs/esign-rest-api/how-to/embedded-sending/)\n- [How to embed the DocuSign UI in your app](/docs/esign-rest-api/how-to/embed-ui/)\n';
      operationId: 'Views_PostEnvelopeRecipientSharedView';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/recipientViewRequest';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/viewUrl';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns a URL to the shared recipient view UI for an envelope.';
      tags: ['EnvelopeViews'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createSharedRecipient';
      'x-ds-methodname': 'createEnvelopeRecipientSharedView';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow': {
    delete: {
      deprecated: false;
      description: "Deletes the specified envelope's workflow definition if it has one.\n\n**Note:** If the envelope was scheduled to be sent, this endpoint will cancel the scheduled send and the envelope status will be reset to \n`created`. To resend the envelope, call the update the status to `sent` with the [Envelopes::Update](/docs/esign-rest-api/reference/envelopes/envelopes/update/) method.\n";
      operationId: 'EnvelopeWorkflowDefinitionV2_DeleteEnvelopeWorkflowDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Delete the workflow definition for an envelope.';
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteEnvelopeWorkflowDefinition';
      'x-ds-methodname': 'deleteEnvelopeWorkflowDefinition';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: 'Returns the workflow definition for the envelope specified by `envelopeId`. If the envelope does not have a workflow object, this method returns a 404.\n';
      operationId: 'EnvelopeWorkflowDefinitionV2_GetEnvelopeWorkflowDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/workflow';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns the workflow definition for an envelope.';
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getEnvelopeWorkflowDefinition';
      'x-ds-methodname': 'getEnvelopeWorkflowDefinition';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: "Updates the specified envelope's workflow.\n\nYou can use this endpoint to add scheduled sending to a draft envelope. You can also update the scheduled sending for a sent envelope if the scheduled sending countdown is in progress. In that case, the envelope will be reset to a draft state.\n\nYou can also add delayed routing to a draft envelope or a sent envelope that has not started workflow processing.";
      operationId: 'EnvelopeWorkflowDefinitionV2_PutEnvelopeWorkflowDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/workflow';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/workflow';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the workflow definition for an envelope.';
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateEnvelopeWorkflowDefinition';
      'x-ds-methodname': 'updateEnvelopeWorkflowDefinition';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/scheduledSending': {
    delete: {
      deprecated: false;
      description: "Deletes the scheduled sending rules for an envelope's workflow. You cannot call this endpoint once the scheduled sending countdown has begun.";
      operationId: 'EnvelopeWorkflowScheduledSending_DeleteEnvelopeScheduledSendingDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: "Deletes the scheduled sending rules for the envelope's workflow.";
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteEnvelopeScheduledSendingDefinition';
      'x-ds-methodname': 'deleteEnvelopeScheduledSendingDefinition';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: 'Given a template and a workflow step, returns the scheduled sending rules for that workflow step.\n\n**Note:** If the workflow step does not have a scheduled sending object, this method returns a 404.';
      operationId: 'EnvelopeWorkflowScheduledSending_GetEnvelopeScheduledSendingDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/scheduledSending';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: "Returns the scheduled sending rules for an envelope's workflow definition.";
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getEnvelopeScheduledSendingDefinition';
      'x-ds-methodname': 'getEnvelopeScheduledSendingDefinition';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: "Updates the scheduled sending rules for an envelope's workflow. The envelope must have an existing workflow object.";
      operationId: 'EnvelopeWorkflowScheduledSending_PutEnvelopeScheduledSendingDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/scheduledSending';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/scheduledSending';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: "Updates the scheduled sending rules for an envelope's workflow.";
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateEnvelopeScheduledSendingDefinition';
      'x-ds-methodname': 'updateEnvelopeScheduledSendingDefinition';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps': {
    parameters: [];
    post: {
      deprecated: false;
      description: "Adds a new step to an envelope's workflow.";
      operationId: 'EnvelopeWorkflowStep_PostEnvelopeWorkflowStepDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/workflowStep';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/workflowStep';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: "Adds a new step to an envelope's workflow.";
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createEnvelopeWorkflowStepDefinition';
      'x-ds-methodname': 'createEnvelopeWorkflowStepDefinition';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}': {
    delete: {
      deprecated: false;
      description: 'Deletes the workflow step specified by `workflowStepId` from an envelope specified by `envelopeId`.';
      operationId: 'EnvelopeWorkflowStep_DeleteEnvelopeWorkflowStepDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workflow step.';
          in: 'path';
          name: 'workflowStepId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: "Deletes a workflow step from an envelope's workflow definition.";
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteEnvelopeWorkflowStepDefinition';
      'x-ds-methodname': 'deleteEnvelopeWorkflowStepDefinition';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: 'Returns a workflow step specified by `workflowStepId` for an envelope specified by `envelopeId`.';
      operationId: 'EnvelopeWorkflowStep_GetEnvelopeWorkflowStepDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workflow step.';
          in: 'path';
          name: 'workflowStepId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/workflowStep';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns a specified workflow step for a specified template.';
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getEnvelopeWorkflowStepDefinition';
      'x-ds-methodname': 'getEnvelopeWorkflowStepDefinition';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Updates the workflow step specified by `workflowStepId` for an envelope.\n\nYou can use this endpoint to add or update delayed routing for a draft envelope. You can add or update delayed routing for a sent envelope as long as the previous workflow step has not been completed.';
      operationId: 'EnvelopeWorkflowStep_PutEnvelopeWorkflowStepDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workflow step.';
          in: 'path';
          name: 'workflowStepId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/workflowStep';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/workflowStep';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the specified workflow step for an envelope.';
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateEnvelopeWorkflowStepDefinition';
      'x-ds-methodname': 'updateEnvelopeWorkflowStepDefinition';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}/delayedRouting': {
    delete: {
      deprecated: false;
      description: "Delete the delayed routing object for an envelope's workflow step. You cannot call this endpoint once the delay is in progress. As a workaround, you can update the delay or send time to one minute in the future using the [updateEnvelopeDelayedRoutingDefinition](/docs/esign-rest-api/reference/envelopes/envelopeworkflowdefinition/updateEnvelopeDelayedRoutingDefinition/) endpoint. \n\n**Note:** After deleting the delayed routing object, the workflow step still contains the `pause_before` action. Once the workflow step is reached, you will need to [unpause the envelope](/docs/esign-rest-api/how-to/unpause-workflow/). If you want to delete the step entirely, use [deleteEnvelopeWorkflowStepDefinition](/docs/esign-rest-api/reference/envelopes/envelopeworkflowdefinition/deleteenvelopeworkflowstepdefinition/) instead.\n";
      operationId: 'EnvelopeWorkflowDelayedRouting_DeleteEnvelopeDelayedRoutingDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workflow step.';
          in: 'path';
          name: 'workflowStepId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes the delayed routing rules for the specified envelope workflow step.';
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteEnvelopeDelayedRoutingDefinition';
      'x-ds-methodname': 'deleteEnvelopeDelayedRoutingDefinition';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: 'Given an envelope and a workflow step, returns the delayed routing rules for that workflow step.\n\n**Note:** If the workflow step does not have a delayed routing object, this method returns a 404.';
      operationId: 'EnvelopeWorkflowDelayedRouting_GetEnvelopeDelayedRoutingDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workflow step.';
          in: 'path';
          name: 'workflowStepId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/delayedRouting';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: "Returns the delayed routing rules for an envelope's workflow step definition.";
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getEnvelopeDelayedRoutingDefinition';
      'x-ds-methodname': 'getEnvelopeDelayedRoutingDefinition';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: "Updates the delayed routing rules for an envelope's workflow step definition.\n\nYou can use this endpoint to add delayed routing to a draft envelope or a sent envelope (as long as the previous workflow step has not yet been completed). You can also update the delayed routing rule for an envelope, as long as the delay is not yet complete. If you update the delayed routing rule while the delay is already in progress, the countdown will reset.";
      operationId: 'EnvelopeWorkflowDelayedRouting_PutEnvelopeDelayedRoutingDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The envelope's GUID. \n\nExample: `93be49ab-xxxx-xxxx-xxxx-f752070d71ec`\n";
          in: 'path';
          name: 'envelopeId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workflow step.';
          in: 'path';
          name: 'workflowStepId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/delayedRouting';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/delayedRouting';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: "Updates the delayed routing rules for an envelope's workflow step definition.";
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateEnvelopeDelayedRoutingDefinition';
      'x-ds-methodname': 'updateEnvelopeDelayedRoutingDefinition';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/favorite_templates': {
    delete: {
      deprecated: false;
      description: 'Remove one or more templates from the account favorites. \n\nYour request should include each template to remove as a separate `favoriteTemplatesContentItem` JSON object, like this:\n```\n{\n    "favoriteTemplates": [\n        {\n            "templateId": "6bc0584f-xxxx-xxxx-xxxx-35ab28cc44e1"\n        },\n        {\n            "templateId": "8ae9b3452-xxxx-xxxx-xxx-ac0de23fa57f"\n        }\n    ]\n}\n```\n\nThe response includes the IDs of the templates that were successfully removed from your favorites. To get the account\'s remaining favorite templates, use the [getFavoriteTemplates](/docs/esign-rest-api/reference/accounts/favoritetemplates/getfavoritetemplates/) endpoint.';
      operationId: 'FavoriteTemplates_UnFavoriteTemplate';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/favoriteTemplatesInfo';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/favoriteTemplatesInfo';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Remove one or more templates from the account favorites.';
      tags: ['FavoriteTemplates'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'unFavoriteTemplate';
      'x-ds-methodname': 'unFavoriteTemplate';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: 'Retrieves the list of favorite templates for the account.';
      operationId: 'FavoriteTemplates_GetFavoriteTemplates';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/favoriteTemplatesInfo';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieves the list of favorite templates for the account.';
      tags: ['FavoriteTemplates'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'getFavoriteTemplates';
      'x-ds-methodname': 'getFavoriteTemplates';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Set one or more templates as account favorites.\n\nYour request should include each template as a separate `favoriteTemplatesContentItem` JSON object, like this:\n```\n{\n    "favoriteTemplates": [\n        {\n            "templateId": "6bc0584f-xxxx-xxxx-xxxx-35ab28cc44e1"\n        },\n        {\n            "templateId": "8ae9b3452-xxxx-xxxx-xxx-ac0de23fa57f"\n        }\n    ]\n}\n```\n';
      operationId: 'FavoriteTemplates_PutFavoriteTemplate';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/favoriteTemplatesInfo';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/favoriteTemplatesInfo';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Set one or more templates as account favorites.';
      tags: ['FavoriteTemplates'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateFavoriteTemplate';
      'x-ds-methodname': 'updateFavoriteTemplate';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/folders': {
    get: {
      deprecated: false;
      description: 'Retrieves a list of the folders for the account.\n\nUse the `include` query parameter to specify the kinds of folders to return.\n\nBy default, only the first level of subfolders is shown.\nSet the `sub_folder_depth` query parameter to `-1` to return the entire folder hierarchy.\n\n\n<ds-column>\n\n<ds-step open="false" hideIcon="true">\n\nDefault returns only top-level folders.\n\n<div>\n\n`GET \'https://demo.docusign.net/restapi/v2.1/accounts/624e3e00-xxxx-xxxx-xxxx-43918c520dab/folders\'`\n\n\n```json\n{\n  "resultSetSize": "5",\n  "startPosition": "0",\n  "endPosition": "4",\n  "totalSetSize": "5",\n  "folders": [\n    {\n      "name": "Draft",\n      "type": "draft",\n      "itemCount": "1",\n      "subFolderCount": "0",\n      "hasSubFolders": "false"\n    },\n    {\n      "name": "Inbox",\n      "type": "inbox",\n      "itemCount": "0",\n      "subFolderCount": "1",\n      "hasSubFolders": "true",\n      "folders": [\n        {\n          "name": "Project Fair",\n          "type": "normal",\n          "hasSubFolders": "false",\n          "parentFolderId": "3ed02ee3-xxxx-xxxx-xxxx-e6795f96a840",\n          "parentFolderUri": "/folders/3ed02ee3-xxxx-xxxx-xxxx-e6795f96a840"\n        }\n      ]\n    },\n    {\n      "name": "Deleted Items",\n      "type": "recyclebin",\n      "itemCount": "0",\n      "subFolderCount": "0",\n      "hasSubFolders": "false"\n    },\n    {\n      "name": "Sent Items",\n      "type": "sentitems",\n      "itemCount": "3",\n      "subFolderCount": "0",\n      "hasSubFolders": "false"\n    }\n  ]\n}\n\n```\n\n</div></ds-step>\n\n\n<ds-step open="false" hideIcon="true">\n\nSetting `sub_folder_depth` to `-1` returns the entire folder hierarchy.\n\n\n<div>\n\n`GET \'https://demo.docusign.net/restapi/v2.1/accounts/624e3e00-xxxx-xxxx-xxxx-43918c520dab/folders?sub_folder_depth=-1\'`\n\nOne envelope has been moved from the `Inbox` folder to the\n`Project Fair/Phase 1` folder, and the endpoint is invoked\nwith `sub_folder_depth=-1`.\n\n\n```json\n{\n  "resultSetSize": "5",\n  "startPosition": "0",\n  "endPosition": "4",\n  "totalSetSize": "4",\n  "folders": [\n    {\n      "name": "Draft",\n      "type": "draft",\n      "itemCount": "1",\n      "hasSubFolders": "false"\n    },\n    {\n      "name": "Inbox",\n      "type": "inbox",\n      "itemCount": "0",\n      "hasSubFolders": "true",\n      "folders": [\n        {\n          "name": "Project Fair",\n          "type": "normal",\n          "itemCount": "0",\n          "hasSubFolders": "true",\n          "parentFolderId": "3ed02ee3-xxxx-xxxx-xxxx-e6795f96a840",\n          "parentFolderUri": "/folders/3ed02ee3-xxxx-xxxx-xxxx-e6795f96a840",\n          "folders": [\n            {\n              "name": "NDAs",\n              "type": "normal",\n              "itemCount": "0",\n              "hasSubFolders": "false",\n              "parentFolderId": "12882f2f-xxxx-xxxx-xxxx-e04a714f8e2d",\n              "parentFolderUri": "/folders/12882f2f-xxxx-xxxx-xxxx-e04a714f8e2d"\n            },\n            {\n              "name": "Phase 1",\n              "type": "normal",\n              "itemCount": "1",\n              "hasSubFolders": "false",\n              "parentFolderId": "12882f2f-xxxx-xxxx-xxxx-e04a714f8e2d",\n              "parentFolderUri": "/folders/12882f2f-xxxx-xxxx-xxxx-e04a714f8e2d"\n            }\n          ]\n        }\n      ]\n    },\n    {\n      "name": "Deleted Items",\n      "type": "recyclebin",\n      "itemCount": "0",\n      "hasSubFolders": "false"\n    },\n    {\n      "name": "Sent Items",\n      "type": "sentitems",\n      "itemCount": "1",\n      "hasSubFolders": "false"\n    }\n  ]\n}\n```\n\n</div></ds-step>\n</ds-column>\n\n\n### Related topics\n\n- [Searching for envelopes](/docs/esign-rest-api/esign101/concepts/envelopes/search/)\n- [Sharing templates](/docs/esign-rest-api/esign101/concepts/templates/sharing/)\n';
      operationId: 'Folders_GetFolders';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of folder types to include in the response.\nValid values are:\n\n- `envelope_folders`: Returns a list of envelope folders. (Default)\n- `template_folders`: Returns a list of template folders. \n- `shared_template_folders`: Returns a list of shared template folders.\n';
          in: 'query';
          name: 'include';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Indicates whether folder items are included in the response. If this parameter is omitted, the default is false.';
          in: 'query';
          name: 'include_items';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'If missing or any value other than `-1`, the returned list contains only the top-level folders.\nA value of `-1` returns the complete folder hierarchy.\n';
          in: 'query';
          name: 'sub_folder_depth';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'This parameter is deprecated as of version 2.1. Use `include` instead.';
          in: 'query';
          name: 'template';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Narrows down the resulting folder list by the following values:\n\n- `all`: Returns all templates owned or shared with the user. (default)\n- `owned_by_me`: Returns only  templates the user owns.\n- `shared_with_me`: Returns only templates that are shared with the user.\n';
          in: 'query';
          name: 'user_filter';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/foldersResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a list of the folders for the account.';
      tags: ['Folders'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'list';
      'x-ds-service': 'Folders';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/folders/{folderId}': {
    get: {
      deprecated: false;
      description: 'Gets information about the specified folder. To include a list of the items in the folder, set the `include_items` query parameter to **true.**\n\n### Related topics\n\n- [Searching for envelopes](/docs/esign-rest-api/esign101/concepts/envelopes/search/)\n- [Sharing templates](/docs/esign-rest-api/esign101/concepts/templates/sharing/)\n';
      operationId: 'Folders_GetFolderItems';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the folder.';
          in: 'path';
          name: 'folderId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Reserved for DocuSign.';
          in: 'query';
          name: 'from_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Indicates whether folder items are included in the response. If this parameter is omitted, the default is false.';
          in: 'query';
          name: 'include_items';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Reserved for DocuSign.';
          in: 'query';
          name: 'owner_email';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Reserved for DocuSign.';
          in: 'query';
          name: 'owner_name';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Reserved for DocuSign.';
          in: 'query';
          name: 'search_text';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Reserved for DocuSign.';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Reserved for DocuSign.';
          in: 'query';
          name: 'status';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Reserved for DocuSign.';
          in: 'query';
          name: 'to_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/folderItemsResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets information about the specified folder.';
      tags: ['Folders'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'listItems';
      'x-ds-methodname': 'listItems';
      'x-ds-service': 'Folders';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Moves an envelope from its current folder to the specified folder.\n\nYou can use this method to delete envelopes by specifying `recyclebin` in the `folderId` parameter.\nPlacing an in-process envelope (envelope status of `sent` or `delivered`) in the recycle bin voids the envelope.\n\nYou can also use this method\nto delete templates\nby specifying a template ID\ninstead of an envelope ID in the `envelopeIds` property\nand specifying `recyclebin` in the `folderId` parameter.\n\n### Related topics\n\n- [Searching for envelopes](/docs/esign-rest-api/esign101/concepts/envelopes/search/)\n- [Sharing templates](/docs/esign-rest-api/esign101/concepts/templates/sharing/)\n';
      operationId: 'Folders_PutFolderById';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the folder.';
          in: 'path';
          name: 'folderId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/foldersRequest';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/foldersResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Moves an envelope from its current folder to the specified folder.';
      tags: ['Folders'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'moveEnvelopes';
      'x-ds-methodname': 'moveEnvelopes';
      'x-ds-service': 'Folders';
    };
  };
  '/v2.1/accounts/{accountId}/groups': {
    delete: {
      deprecated: false;
      description: 'Deletes an existing user group.\n\nWhen you delete a group, you include only the `groupId` in the request body.\n\nExample:\n\n```\n{\n  "groups": [\n    {\n      "groupId": "12345"\n    }\n}\n```\n';
      operationId: 'Groups_DeleteGroups';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/groupInformation';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/groupInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes an existing user group.';
      tags: ['Groups'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteGroups';
      'x-ds-service': 'Groups';
    };
    get: {
      deprecated: false;
      description: "Retrieves information about groups associated with the account.\n\n**Note:** To retrieve a group's users, use this endpoint to get the group ID and then call the [listGroupUsers](/docs/esign-rest-api/reference/usergroups/groupusers/list/) endpoint.\n\n ### Related topics\n\n- [How to set a permission profile](/docs/esign-rest-api/how-to/permission-profile-setting/)";
      operationId: 'Groups_GetGroups';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.\n\nUse `start_position` to specify the number of results to skip.\n\nValid values: `1` to `100`';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The type of group to return. Valid values:\n\n* `AdminGroup`\n* `CustomGroup`\n* `EveryoneGroup`';
          in: 'query';
          name: 'group_type';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** every group returned in the response includes a `userCount` property that contains the total number of users in the group. The default is **true.**';
          in: 'query';
          name: 'include_usercount';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters the results of a GET request based on the text that you specify.';
          in: 'query';
          name: 'search_text';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nUse with `count` to limit the number\nof results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/groupInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets information about groups associated with the account.';
      tags: ['Groups'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listGroups';
      'x-ds-service': 'Groups';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Creates one or more groups for the account.\n\nGroups can be used to help manage users by associating users with a group. You can associate a group with a Permission Profile, which sets the user permissions for users in that group without having to set the `userSettings` property for each user. You are not required to set Permission Profiles for a group, but it makes it easier to manage user permissions for a large number of users. You can also use groups with template sharing to limit user access to templates.';
      operationId: 'Groups_PostGroups';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/groupInformation';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/groupInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates one or more groups for the account.';
      tags: ['Groups'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createGroups';
      'x-ds-service': 'Groups';
    };
    put: {
      deprecated: false;
      description: 'Updates the group name and modifies, or sets, the permission profile for the group.\n\n### Related topics\n\n- [How-To Set Up a Permission Profile](/docs/esign-rest-api/how-to/permission-profile-setting/)';
      operationId: 'Groups_PutGroups';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/groupInformation';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/groupInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the group information for a group.';
      tags: ['Groups'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateGroups';
      'x-ds-service': 'Groups';
    };
  };
  '/v2.1/accounts/{accountId}/groups/{groupId}/brands': {
    delete: {
      deprecated: false;
      description: 'This method deletes one or more brands from a group.';
      operationId: 'Brands_DeleteGroupBrands';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the group.';
          in: 'path';
          name: 'groupId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/brandsRequest';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/GroupBrands';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes brand information from a group.';
      tags: ['GroupBrands'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteBrands';
      'x-ds-service': 'Groups';
    };
    get: {
      deprecated: false;
      description: 'This method returns information about the brands associated with a group.';
      operationId: 'Brands_GetGroupBrands';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the group.';
          in: 'path';
          name: 'groupId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/GroupBrands';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the brand information for a group.';
      tags: ['GroupBrands'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getBrands';
      'x-ds-service': 'Groups';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method adds one or more existing brands to a group based on the `groupId`.';
      operationId: 'Brands_PutGroupBrands';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the group being accessed.';
          in: 'path';
          name: 'groupId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/brandsRequest';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/GroupBrands';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds an existing brand to a group.';
      tags: ['GroupBrands'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateBrands';
      'x-ds-service': 'Groups';
    };
  };
  '/v2.1/accounts/{accountId}/groups/{groupId}/users': {
    delete: {
      deprecated: false;
      description: 'Deletes one or more users from a group. This request takes a `userInfoList` that contains the users that you want to delete.\n';
      operationId: 'Groups_DeleteGroupUsers';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the group being accessed.';
          in: 'path';
          name: 'groupId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/userInfoList';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/usersResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes one or more users from a group';
      tags: ['GroupUsers'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteGroupUsers';
      'x-ds-service': 'Groups';
    };
    get: {
      deprecated: false;
      description: 'Retrieves a list of users in a group.';
      operationId: 'Groups_GetGroupUsers';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the group being accessed.';
          in: 'path';
          name: 'groupId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.\n\nUse `start_position` to specify the number of results to skip.\n\nValid values: `1` to `100`\n';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nUse with `count` to limit the number\nof results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/usersResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a list of users in a group.';
      tags: ['GroupUsers'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listGroupUsers';
      'x-ds-service': 'Groups';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Adds one or more existing DocuSign users to an existing group.';
      operationId: 'Groups_PutGroupUsers';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the group being accessed.';
          in: 'path';
          name: 'groupId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/userInfoList';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/usersResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds one or more users to an existing group.';
      tags: ['GroupUsers'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateGroupUsers';
      'x-ds-service': 'Groups';
    };
  };
  '/v2.1/accounts/{accountId}/identity_verification': {
    get: {
      deprecated: false;
      description: 'This method returns a list of Identity Verification workflows that are available to an account.\n\n**Note:** To use this method, you must either be an account administrator or a sender.\n\n### Related topics\n\n- [How to require ID Verification (IDV) for a recipient](/docs/esign-rest-api/how-to/id-verification/)\n\n';
      operationId: 'AccountIdentityVerification_GetAccountIdentityVerification';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/accountIdentityVerificationResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieves the Identity Verification workflows available to an account.';
      tags: ['IdentityVerifications'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'getAccountIdentityVerification';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/payment_gateway_accounts': {
    get: {
      deprecated: false;
      description: 'This method returns a list of payment gateway accounts and basic information about them.';
      operationId: 'PaymentGatewayAccounts_GetAllPaymentGatewayAccounts';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/paymentGatewayAccountsInfo';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'List payment gateway accounts';
      tags: ['PaymentGatewayAccounts'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'getAllPaymentGatewayAccounts';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/permission_profiles': {
    get: {
      deprecated: false;
      description: 'This method returns a list of permission profiles that are associated with an account.\n\nExample:\n\n```json\n{\n  "permissionProfiles": [\n    {\n      "permissionProfileId": "1665536",\n      "permissionProfileName": "Account Administrator",\n      "modifiedDateTime": "2018-03-26T03:54:40.4470000Z",\n      "modifiedByUsername": ""\n    },\n    {\n      "permissionProfileId": "1665537",\n      "permissionProfileName": "DocuSign Sender",\n      "modifiedDateTime": "2018-03-26T03:54:40.4470000Z",\n      "modifiedByUsername": ""\n    },\n    {\n      "permissionProfileId": "1665538",\n      "permissionProfileName": "DocuSign Viewer",\n      "modifiedDateTime": "2016-06-02T01:53:15.6830000Z",\n      "modifiedByUsername": ""\n    },\n    {\n      "permissionProfileId": "10325926",\n      "permissionProfileName": "DS Manage Company Member Accounts",\n      "modifiedDateTime": "2020-05-15T00:28:36.8230000Z",\n      "modifiedByUsername": "Nat Irving"\n    }\n  ]\n}\n```';
      operationId: 'PermissionProfiles_GetPermissionProfiles';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of additional properties to return in the response. Valid values are:\n\n- `user_count`: The total number of users associated with the permission profile.\n- `closed_users`: Includes closed users in the `user_count`.\n- `account_management`: The account management settings.\n- `metadata`: Metadata indicating whether the properties associated with the account permission profile are editable.\n\nExample: `user_count,closed_users`\n';
          in: 'query';
          name: 'include';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/permissionProfileInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a list of permission profiles.';
      tags: ['AccountPermissionProfiles'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listPermissions';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'This method creates a new permission profile for an account.\n\n### Related topics\n\n- [How to create a permission profile](/docs/esign-rest-api/how-to/permission-profile-creating/)\n';
      operationId: 'PermissionProfiles_PostPermissionProfiles';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of additional properties to return in the response. The only valid value for this request is `metadata`, which returns metadata indicating whether the properties associated with the account permission profile are editable.';
          in: 'query';
          name: 'include';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/permissionProfile';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/permissionProfile';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates a new permission profile for an account.';
      tags: ['AccountPermissionProfiles'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createPermissionProfile';
      'x-ds-service': 'Accounts';
    };
  };
  '/v2.1/accounts/{accountId}/permission_profiles/{permissionProfileId}': {
    delete: {
      deprecated: false;
      description: 'This method deletes a permission profile from an account.\n\nTo delete a permission profile, it must not have any users associated with it. When you use this method to delete a permission profile, you can reassign the users associated with it to a new permission profile at the same time by using the `move_users_to` query parameter.\n\n\n### Related topics\n\n- [How to delete a permission profile](/docs/esign-rest-api/how-to/permission-profile-deleting/)';
      operationId: 'PermissionProfiles_DeletePermissionProfiles';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the permission profile.\n\nUse [AccountPermissionProfiles: list](/docs/esign-rest-api/reference/accounts/accountpermissionprofiles/list/)\nto get a list of permission profiles and their IDs.\n\nYou can also download a CSV file of all permission profiles\nand their IDs from the **Settings > Permission Profiles** page\nof your eSignature account page.\n';
          in: 'path';
          name: 'permissionProfileId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'move_users_to';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes a permission profile from an account.';
      tags: ['AccountPermissionProfiles'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deletePermissionProfile';
      'x-ds-service': 'Accounts';
    };
    get: {
      deprecated: false;
      description: 'This method returns information about a specific permission profile that is associated with an account.\n\n### Related topics\n\n- [How to set a permission profile](/docs/esign-rest-api/how-to/permission-profile-setting/)\n';
      operationId: 'PermissionProfiles_GetPermissionProfile';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the permission profile.\n\nUse [AccountPermissionProfiles: list](/docs/esign-rest-api/reference/accounts/accountpermissionprofiles/list/)\nto get a list of permission profiles and their IDs.\n\nYou can also download a CSV file of all permission profiles\nand their IDs from the **Settings > Permission Profiles** page\nof your eSignature account page.\n';
          in: 'path';
          name: 'permissionProfileId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of additional properties to return in the response. The only valid value for this request is `metadata`, which returns metadata indicating whether the properties associated with the account permission profile are editable.';
          in: 'query';
          name: 'include';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/permissionProfile';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns a permission profile for an account.';
      tags: ['AccountPermissionProfiles'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getPermissionProfile';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method updates an account permission profile.\n\n### Related topics\n\n- [How to update individual permission settings](/docs/esign-rest-api/how-to/permission-profile-updating/)\n';
      operationId: 'PermissionProfiles_PutPermissionProfiles';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the permission profile.\n\nUse [AccountPermissionProfiles: list](/docs/esign-rest-api/reference/accounts/accountpermissionprofiles/list/)\nto get a list of permission profiles and their IDs.\n\nYou can also download a CSV file of all permission profiles\nand their IDs from the **Settings > Permission Profiles** page\nof your eSignature account page.\n';
          in: 'path';
          name: 'permissionProfileId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of additional properties to return in the response. The only valid value for this request is `metadata`, which returns metadata indicating whether the properties associated with the account permission profile are editable.';
          in: 'query';
          name: 'include';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/permissionProfile';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/permissionProfile';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates a permission profile.';
      tags: ['AccountPermissionProfiles'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updatePermissionProfile';
      'x-ds-service': 'Accounts';
    };
  };
  '/v2.1/accounts/{accountId}/powerforms': {
    delete: {
      deprecated: false;
      description: 'This method deletes one or more PowerForms. The request body takes an array of PowerForm objects that are deleted based on the `powerFormId`.';
      operationId: 'PowerForms_DeletePowerFormsList';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/powerFormsRequest';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/powerFormsResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes one or more PowerForms.';
      tags: ['PowerForms'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteList';
      'x-ds-methodname': 'deletePowerForms';
      'x-ds-service': 'PowerForms';
    };
    get: {
      deprecated: false;
      description: 'This method returns a list of PowerForms that are available to the user.';
      operationId: 'PowerForms_GetPowerFormsList';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The start date for a date range.\n\n**Note:** If no value is provided, no date filtering is applied.';
          in: 'query';
          name: 'from_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The order in which to sort the results.\n\nValid values are: \n\n\n* `asc`: Ascending order.\n* `desc`: Descending order. ';
          in: 'query';
          name: 'order';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The file attribute to use to sort the results.\n\nValid values are:\n\n- `sender`\n- `auth`\n- `used`\n- `remaining`\n- `lastused`\n- `status`\n- `type`\n- `templatename`\n- `created`';
          in: 'query';
          name: 'order_by';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of additional properties to include in a search.\n\n- `sender`: Include sender name and email in the search.\n- `recipients`: Include recipient names and emails in the search.\n- `envelope`: Include envelope information in the search.\n';
          in: 'query';
          name: 'search_fields';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Use this parameter to search for specific text.';
          in: 'query';
          name: 'search_text';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The end date for a date range.\n\n**Note:** If no value is provided, this property defaults to the current date.';
          in: 'query';
          name: 'to_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/powerFormsResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns a list of PowerForms.';
      tags: ['PowerForms'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listPowerForms';
      'x-ds-service': 'PowerForms';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: "This method creates a new PowerForm.\n\nYou create a PowerForm from an existing DocuSign [template](/docs/esign-rest-api/reference/templates/templates/create/), based on the `templateId` in the request body.\n\n PowerForms that you create from a template are referred to as *web PowerForms*.\n\n**Note:** The DocuSign Admin console also supports creating a PowerForm by uploading a PDF file that has active form fields (referred to as a *PDF PowerForm*). However, PDF PowerForms are deprecated and are not supported in the API.\n\n**Note:** A PowerForm can have only one sender. (Because PowerForms are not necessarily sent by email, this user is also referred to as the PowerForm *initiator*.) If you need to associate multiple senders with a PowerForm, create multiple copies of the PowerForm by using the same template (one copy for each sender). By default, the sender is the PowerForm Administrator who creates the PowerForm.\n\n\n### Signing modes\n\nYou can use one of the following signing modes for a PowerForm:\n\n**`email`**\n\nThis mode verifies the recipient's identity by using email authentication before the recipient can sign a document. The recipient enters their email address on the landing page and then clicks **Begin Signing** to begin the signing process. The system then sends an email message with a validation code to the recipient. If the recipient does not provide a valid email address, they do not receive the email message containing the access code and are not able to open and sign the document.\n\nAlternatively, you can make the process easier for signers by using email authentication only and omitting the access code. To do this, you append the `activateonly` flag to the PowerForm URL and set it to true by passing in the value `1`.  When the flag is active, the first recipient receives an email with a link that initiates the signing session without having to enter access code.\n\nExample: `activateonly=1`\n\n**`direct`**\n\nThis mode does not require any verification. After a recipient enters their email address on the landing page and clicks **Begin Signing,** a new browser tab opens and the recipient can immediately begin the signing process.\n\nBecause the `direct` signing mode does not verify the recipient's identity by using email authentication, we strongly recommend that you use this mode only when the PowerForm is accessible behind a secure portal where the recipient's identity is already authenticated, or where another form of authentication is specified for the recipient in the DocuSign template (for example, an access code, phone authentication, or ID check).\n\n**Note:** In the account settings, `enablePowerFormDirect` must be **true** to use `direct` as the `signingMode`.\n\n### Redirect URLs\n\nYou can control the URL to which signers are redirected after signing your PowerForm. However, the URL is specified elsewhere, outside of the PowerForm creation process. For details, see [How do I specify a URL to redirect to when a PowerForm is completed?](https://support.docusign.com/en/articles/How-do-I-specify-a-URL-to-redirect-to-when-a-Powerform-is-completed).\n\n### More information\n\nFor more information about creating PowerForms, see [Create a PowerForm](https://support.docusign.com/en/guides/ndse-user-guide-create-a-powerform).\n\n";
      operationId: 'PowerForms_PostPowerForm';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/powerForm';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/powerForm';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates a new PowerForm';
      tags: ['PowerForms'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createPowerForm';
      'x-ds-service': 'PowerForms';
    };
  };
  '/v2.1/accounts/{accountId}/powerforms/senders': {
    get: {
      deprecated: false;
      description: 'This method returns a list of users who have sent PowerForms.';
      operationId: 'PowerForms_GetPowerFormsSenders';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The position within the total result set from which to start returning values. The value **thumbnail** may be used to return the page image.';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/powerFormSendersResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets PowerForm senders.';
      tags: ['PowerForms'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'listSenders';
      'x-ds-methodname': 'listPowerFormSenders';
      'x-ds-service': 'PowerForms';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/powerforms/{powerFormId}': {
    delete: {
      deprecated: false;
      description: 'This method deletes a PowerForm.';
      operationId: 'PowerForms_DeletePowerForm';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the PowerForm.';
          in: 'path';
          name: 'powerFormId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes a PowerForm.';
      tags: ['PowerForms'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deletePowerForm';
      'x-ds-service': 'PowerForms';
    };
    get: {
      deprecated: false;
      description: 'This method returns detailed information about a specific PowerForm.';
      operationId: 'PowerForms_GetPowerForm';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the PowerForm.';
          in: 'path';
          name: 'powerFormId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/powerForm';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns a single PowerForm.';
      tags: ['PowerForms'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getPowerForm';
      'x-ds-service': 'PowerForms';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method updates an existing PowerForm.';
      operationId: 'PowerForms_PutPowerForm';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the PowerForm.';
          in: 'path';
          name: 'powerFormId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/powerForm';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/powerForm';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates an existing PowerForm.';
      tags: ['PowerForms'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updatePowerForm';
      'x-ds-service': 'PowerForms';
    };
  };
  '/v2.1/accounts/{accountId}/powerforms/{powerFormId}/form_data': {
    get: {
      deprecated: false;
      description: 'This method enables Powerform Administrators or the sender of a PowerForm to download the data that recipients have entered into a PowerForm.\n\nYou specify the format in which you want to retrieve the data in the `Accept` header. This header accepts the following values:\n\n\n- `application/json`: JSON format\n- `application/xml`: XML format\n- `text/csv`: Comma-separated value (CSV) format\n\n**Note:** Only PowerForm Administrators or the PowerForm Sender can download the data associated with a PowerForm.';
      operationId: 'PowerForms_GetPowerFormFormData';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the PowerForm.';
          in: 'path';
          name: 'powerFormId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The layout in which to return the PowerForm data. Valid values are:\n\n- `Native`\n- `Csv_Classic`\n- `Csv_One_Envelope_Per_Line`\n- `Xml_Classic`';
          in: 'query';
          name: 'data_layout';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The start date for a date range in UTC DateTime format.\n\n**Note:** If this property is null, no date filtering is applied.';
          in: 'query';
          name: 'from_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The end date of a date range in UTC DateTime format. The default value is `UtcNow`.';
          in: 'query';
          name: 'to_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/powerFormsFormDataResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns the data that users entered in a PowerForm.';
      tags: ['PowerFormData'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'getPowerFormData';
      'x-ds-service': 'PowerForms';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/recipient_names': {
    get: {
      deprecated: false;
      description: "Retrieves a list of all of the names associated with the email address that you pass in. This list can include variants of a single recipient's name that are used for signing, as well as the names of multiple different recipients.";
      operationId: 'RecipientNames_GetRecipientNames';
      parameters: [
        {
          description: '(Required) The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The email address for which you want to retrieve recipient names.';
          in: 'query';
          name: 'email';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/recipientNamesResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the recipient names associated with an email address.';
      tags: ['Accounts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'listRecipientNamesByEmail';
      'x-ds-methodname': 'listRecipientNamesByEmail';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/seals': {
    get: {
      deprecated: false;
      description: '';
      operationId: 'AccountSignatureProviders_GetSealProviders';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/AccountSealProviders';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns available seals for specified account.';
      tags: ['AccountSealProviders'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'getSealProviders';
      'x-ds-service': 'TrustServiceProviders';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/search_folders/{searchFolderId}': {
    get: {
      deprecated: false;
      description: '**This method is deprecated in API v2.1.**\n\nUse  [Envelopes::listStatusChanges](/docs/esign-rest-api/reference/envelopes/envelopes/liststatuschanges/) instead.\n\nRetrieves a list of items that match the criteria specified in the query.\n\nIf the user ID of the user making the call is the same as the user ID for any returned recipient, then the userId property is added to the returned information for those recipients.';
      operationId: 'SearchFolders_GetSearchFolderContents';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies the envelope group that is searched by the request. These are logical groupings, not actual folder names. Valid values are: drafts, awaiting_my_signature, completed, out_for_signature.';
          in: 'path';
          name: 'searchFolderId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies that all envelopes that match the criteria are returned.';
          in: 'query';
          name: 'all';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.\n\nUse `start_position` to specify the number of results to skip.\n\nValid values: `1` to `100`\n';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies the start of the date range to return. If no value is provided, the default search is the previous 30 days.';
          in: 'query';
          name: 'from_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the recipient information is returned in the response.';
          in: 'query';
          name: 'include_recipients';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies the order in which the list is returned. Valid values are: `asc` for ascending order, and `desc` for descending order.';
          in: 'query';
          name: 'order';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies the property used to sort the list. Valid values are: `action_required`, `created`, `completed`, `sent`, `signer_list`, `status`, or `subject`.';
          in: 'query';
          name: 'order_by';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nUse with `count` to limit the number\nof results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies the end of the date range to return.';
          in: 'query';
          name: 'to_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/folderItemResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a list of envelopes in folders matching the specified criteria.';
      tags: ['Folders'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'search';
      'x-ds-methodname': 'search';
      'x-ds-service': 'Folders';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/settings': {
    get: {
      deprecated: false;
      description: 'Retrieves the account settings information for the specified account.';
      operationId: 'Settings_GetSettings';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/accountSettingsInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets account settings information.';
      tags: ['Accounts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'listSettings';
      'x-ds-methodname': 'listSettings';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Updates the account settings for the specified account.\n\nAlthough the request body for this method\nis a complete\n`accountSettingsInformation` object,\nyou only need to provide\nthe properties that\nyou are updating.';
      operationId: 'Settings_PutSettings';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/accountSettingsInformation';
            };
          };
        };
      };
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the account settings for an account.';
      tags: ['Accounts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateSettings';
      'x-ds-methodname': 'updateSettings';
      'x-ds-service': 'Accounts';
    };
  };
  '/v2.1/accounts/{accountId}/settings/bcc_email_archives': {
    get: {
      deprecated: false;
      description: 'This method retrieves all of the BCC email archive configurations associated with an account.';
      operationId: 'BCCEmailArchive_GetBCCEmailArchiveList';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.\n\nUse `start_position` to specify the number of results to skip.\n';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nUse with `count` to limit the number\nof results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/bccEmailArchiveList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the BCC email archive configurations for an account.';
      tags: ['BCCEmailArchive'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'list';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'This method creates a BCC email archive configuration for an account (adds a BCC email address to the account for archiving the emails that DocuSign generates).\n\nThe only property that you must set in the request body is the BCC email address that you want to use.\n\n**Note:** An account can have up to five active and pending email archive addresses combined, but you must use this method to add them to the account one at a time. Each email address is considered a separate BCC email archive configuration.\n';
      operationId: 'BCCEmailArchive_PostBCCEmailArchive';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/bccEmailArchive';
            };
          };
        };
        description: 'Boolean that specifies whether BCC for Email Archive is enabled for the account. BCC for Email Archive allows you to set up an archive email address so that a BCC copy of an envelope is sent only to that address.';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/bccEmailArchive';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates a BCC email archive configuration.';
      tags: ['BCCEmailArchive'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'create';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/settings/bcc_email_archives/{bccEmailArchiveId}': {
    delete: {
      deprecated: false;
      description: 'This method deletes a BCC email archive configuration from an account.\n\nWhen you use this method, the status of the BCC email archive configuration switches to `closed` and the BCC email address is no longer used to archive DocuSign-generated email messages.\n';
      operationId: 'BCCEmailArchive_DeleteBCCEmailArchive';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the BCC email archive configuration.';
          in: 'path';
          name: 'bccEmailArchiveId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes a BCC email archive configuration.';
      tags: ['BCCEmailArchive'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'delete';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: 'This method returns a specific BCC email archive configuration for an account, as well as the history of changes to the email address.';
      operationId: 'BCCEmailArchive_GetBCCEmailArchiveHistoryList';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the BCC email archive configuration.';
          in: 'path';
          name: 'bccEmailArchiveId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.\n\nUse `start_position` to specify the number of items to skip.\n';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nUse with `count` to limit the number\nof results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/bccEmailArchiveHistoryList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a BCC email archive configuration and its history.';
      tags: ['BCCEmailArchive'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'get';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/settings/enote_configuration': {
    delete: {
      deprecated: false;
      description: '';
      operationId: 'ENoteConfiguration_DeleteENoteConfiguration';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes configuration information for the eNote eOriginal integration.';
      tags: ['ENoteConfigurations'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteENoteConfiguration';
      'x-ds-service': 'Accounts';
    };
    get: {
      deprecated: false;
      description: '';
      operationId: 'ENoteConfiguration_GetENoteConfiguration';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/eNoteConfiguration';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns the configuration information for the eNote eOriginal integration.';
      tags: ['ENoteConfigurations'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getENoteConfiguration';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: '';
      operationId: 'ENoteConfiguration_PutENoteConfiguration';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/eNoteConfiguration';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/eNoteConfiguration';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates configuration information for the eNote eOriginal integration.';
      tags: ['ENoteConfigurations'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateENoteConfiguration';
      'x-ds-service': 'Accounts';
    };
  };
  '/v2.1/accounts/{accountId}/settings/envelope_purge_configuration': {
    get: {
      deprecated: false;
      description: 'An envelope purge configuration enables account administrators to permanently remove documents and their field data from completed and voided envelopes after a specified retention period (`retentionDays`). This method retrieves the current envelope purge configuration for your account.\n\n**Note:** To use this method, you must be an account administrator.';
      operationId: 'EnvelopePurgeConfiguration_GetEnvelopePurgeConfiguration';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopePurgeConfiguration';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the envelope purge configuration for an account.';
      tags: ['Accounts'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'getEnvelopePurgeConfiguration';
      'x-ds-methodname': 'getEnvelopePurgeConfiguration';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'An envelope purge configuration enables account administrators to permanently remove documents and their field data from completed and voided envelopes after a specified retention period (`retentionDays`). This method sets the envelope purge configuration for your account.\n\n**Note:** To use this method, you must be an account administrator.\n\nFor more information, see [Purge Envelopes](https://support.docusign.com/en/guides/ndse-user-guide-purge-envelopes).';
      operationId: 'EnvelopePurgeConfiguration_PutEnvelopePurgeConfiguration';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/envelopePurgeConfiguration';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopePurgeConfiguration';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Sets the envelope purge configuration for an account.';
      tags: ['Accounts'];
      'x-ds-api-status': 'beta';
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateEnvelopePurgeConfiguration';
      'x-ds-methodname': 'updateEnvelopePurgeConfiguration';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/settings/notification_defaults': {
    get: {
      deprecated: false;
      description: 'This method returns the default settings for the email notifications that signers and senders receive about envelopes.';
      operationId: 'NotificationDefaults_GetNotificationDefaults';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/notificationDefaults';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets envelope notification defaults.';
      tags: ['Accounts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getNotificationDefaults';
      'x-ds-methodname': 'getNotificationDefaults';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method changes the default settings for the email notifications that signers and senders receive about envelopes.';
      operationId: 'NotificationDefaults_PutNotificationDefaults';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/notificationDefaults';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/notificationDefaults';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates envelope notification default settings.';
      tags: ['Accounts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateNotificationDefaults';
      'x-ds-methodname': 'updateNotificationDefaults';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/settings/password_rules': {
    get: {
      deprecated: false;
      description: 'This method retrieves the password rules for an account.';
      operationId: 'AccountPasswordRules_GetAccountPasswordRules';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/accountPasswordRules';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the password rules for an account.';
      tags: ['AccountPasswordRules'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getAccountPasswordRules';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method updates the password rules for an account.\n\n**Note:** To update the password rules for an account, you must be an account administrator.';
      operationId: 'AccountPasswordRules_PutAccountPasswordRules';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/accountPasswordRules';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/accountPasswordRules';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the password rules for an account.';
      tags: ['AccountPasswordRules'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateAccountPasswordRules';
      'x-ds-service': 'Accounts';
    };
  };
  '/v2.1/accounts/{accountId}/settings/tabs': {
    get: {
      deprecated: false;
      description: 'This method returns information about the tab types and tab functionality that is currently enabled for an account.';
      operationId: 'TabSettings_GetTabSettings';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/tabAccountSettings';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns tab settings list for specified account';
      tags: ['AccountTabSettings'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getAccountTabSettings';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method modifies the tab types and tab functionality that is enabled for an account.';
      operationId: 'TabSettings_PutSettings';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/tabAccountSettings';
            };
          };
        };
        description: 'Account-wide tab settings.';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/tabAccountSettings';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Modifies tab settings for specified account';
      tags: ['AccountTabSettings'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateAccountTabSettings';
      'x-ds-service': 'Accounts';
    };
  };
  '/v2.1/accounts/{accountId}/shared_access': {
    get: {
      deprecated: false;
      description: 'Retrieves shared item status for one or more users and types of items.\n\nUsers with account administration privileges can retrieve shared access information for all account users. Users without account administrator privileges can only retrieve shared access information for themselves, and the returned information is limited to retrieving the status of the members of the account that are sharing their folders to the user. This is equivalent to setting the `shared` parameter to `shared_from`.';
      operationId: 'SharedAccess_GetSharedAccess';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.\n\nUse `start_position` to specify the number of results to skip.\n\nDefault: `1000`\n';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'This query parameter works in conjunction with `user_ids`. When you specify one of the following user statuses, the query limits the results to only users that match the specified status:\n- `ActivationRequired`: Membership Activation required\n- `ActivationSent`: Membership activation sent to user\n- `Active`: User Membership is active\n- `Closed`: User Membership is closed\n- `Disabled`: User Membership is disabled';
          in: 'query';
          name: 'envelopes_not_shared_user_status';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of folder IDs for which to return shared item information. If `item_type` is set to `folders`, at least one folder ID is required.';
          in: 'query';
          name: 'folder_ids';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies the type of shared item being requested. Valid values:\n\n- `envelopes`: Get information about envelope sharing between users.\n- `templates`: Get information about template sharing among users and groups.\n- `folders`: Get information about folder sharing among users and groups.\n';
          in: 'query';
          name: 'item_type';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: "Filter user names based on the specified string. The wild-card '*' (asterisk) can be used in the string.";
          in: 'query';
          name: 'search_text';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of sharing filters that specifies which users appear in the response. \n\n- `not_shared`: The response lists users who do not share items of `item_type` with the current user.\n\n- `shared_to`: The response lists users in `user_list` who are sharing items to current user.\n\n- `shared_from`: The response lists users in `user_list` who are sharing items from the current user.\n\n- `shared_to_and_from`: The response lists users in `user_list` who are sharing items to and from the current user.\n\nIf the current user does not have administrative privileges, only the `shared_to` option is valid.';
          in: 'query';
          name: 'shared';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nUse with `count` to limit the number\nof results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of user IDs for whom the shared item information is being requested.';
          in: 'query';
          name: 'user_ids';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/accountSharedAccess';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Reserved: Gets the shared item status for one or more users.';
      tags: ['Accounts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'listSharedAccess';
      'x-ds-methodname': 'listSharedAccess';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This sets the shared access status for one or more users or templates.\n\nWhen setting user shared access, only users with account administration privileges can set shared access status for envelopes.\n\nWhen setting template shared access, only users who own a template and have sharing permission or with account administration privileges can set shared access for templates.\n\nChanges to the shared items status are not additive. The change always replaces the current status.\n\nTo change template shared access, add the query parameter `item_type` = `templates` to the request. When this is set, the user and envelopes properties are not required.\n\n**Note:** This functionality is a newer version of the [Update Group Share](/docs/esign-rest-api/reference/templates/templates/updategroupshare/) functionality.\n\n';
      operationId: 'SharedAccess_PutSharedAccess';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies the type of shared item being set:\n- `envelopes`: Set envelope sharing between users.\n- `templates`: Set information about template sharing among users and groups.\n- `folders`: Get information about folder sharing among users and groups.\n';
          in: 'query';
          name: 'item_type';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** preserve the existing shared access settings.';
          in: 'query';
          name: 'preserve_existing_shared_access';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of IDs for users whose shared item access is being set.';
          in: 'query';
          name: 'user_ids';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/accountSharedAccess';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/accountSharedAccess';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Reserved: Sets the shared access information for users.';
      tags: ['Accounts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateSharedAccess';
      'x-ds-methodname': 'updateSharedAccess';
      'x-ds-service': 'Accounts';
    };
  };
  '/v2.1/accounts/{accountId}/signatureProviders': {
    get: {
      deprecated: false;
      description: 'Returns a list of signature providers that the specified account can use.';
      operationId: 'AccountSignatureProviders_GetSignatureProviders';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/accountSignatureProviders';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the available signature providers for an account.';
      tags: ['AccountSignatureProviders'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listSignatureProviders';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/signatures': {
    get: {
      deprecated: false;
      description: 'Returns a list of stamps available in the account.';
      operationId: 'AccountSignatures_GetAccountSignatures';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The format of the stamp to return. Valid values:\n- `NameDateHanko`\n- `NameHanko`\n- `PlaceholderHanko`';
          in: 'query';
          name: 'stamp_format';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The name associated with the stamps to return. This value can be a Japanese surname (up to 5 characters) or a purchase order ID.';
          in: 'query';
          name: 'stamp_name';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The type of the stamps to return. Valid values:\n- `name_stamp`\n- `stamp`\n- `signature`';
          in: 'query';
          name: 'stamp_type';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/accountSignaturesInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns a list of stamps available in the account.';
      tags: ['AccountSignatures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getAccountSignatures';
      'x-ds-methodname': 'getAccountSignatures';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Adds or updates one or more account stamps.\n';
      operationId: 'AccountSignatures_PostAccountSignatures';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'decode_only';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/accountSignaturesInformation';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/accountSignaturesInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds or updates one or more account stamps.';
      tags: ['AccountSignatures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createAccountSignatures';
      'x-ds-methodname': 'createAccountSignatures';
      'x-ds-service': 'Uncategorized';
    };
    put: {
      deprecated: false;
      description: 'Adds or updates one or more account stamps. This request may include images in multi-part format.';
      operationId: 'AccountSignatures_PutAccountSignature';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/accountSignaturesInformation';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/accountSignaturesInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates an account stamp.';
      tags: ['AccountSignatures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateAccountSignature';
      'x-ds-methodname': 'updateAccountSignature';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/signatures/{signatureId}': {
    delete: {
      deprecated: false;
      description: 'Deletes a stamp specified by `signatureId`.\n';
      operationId: 'AccountSignatures_DeleteAccountSignature';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the account stamp.';
          in: 'path';
          name: 'signatureId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes an account stamp.';
      tags: ['AccountSignatures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteAccountSignature';
      'x-ds-methodname': 'deleteAccountSignature';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: 'Returns information about the specified stamp.';
      operationId: 'AccountSignatures_GetAccountSignature';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the account stamp.';
          in: 'path';
          name: 'signatureId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/accountSignature';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns information about the specified stamp.';
      tags: ['AccountSignatures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getAccountSignature';
      'x-ds-methodname': 'getAccountSignature';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Updates an account stamp specified by the `signatureId` query parameter.';
      operationId: 'AccountSignatures_PutAccountSignatureById';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the account stamp.';
          in: 'path';
          name: 'signatureId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** closes the current signature.';
          in: 'query';
          name: 'close_existing_signature';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/accountSignatureDefinition';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/accountSignature';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates an account stamp by ID.';
      tags: ['AccountSignatures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateAccountSignatureById';
      'x-ds-methodname': 'updateAccountSignatureById';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/signatures/{signatureId}/{imageType}': {
    delete: {
      deprecated: false;
      description: 'Deletes the image for a stamp specified by `signatureId`.';
      operationId: 'AccountSignatures_DeleteAccountSignatureImage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specificies the type of image. Valid values:\n\n- `stamp_image`\n- `signature_image`\n- `initials_image`';
          in: 'path';
          name: 'imageType';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the account stamp.';
          in: 'path';
          name: 'signatureId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/accountSignature';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes the image for a stamp.';
      tags: ['AccountSignatures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteAccountSignatureImage';
      'x-ds-methodname': 'deleteAccountSignatureImage';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: 'Returns the image for an account stamp.';
      operationId: 'AccountSignatures_GetAccountSignatureImage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specificies the type of image. Valid values:\n\n- `stamp_image`\n- `signature_image`\n- `initials_image`';
          in: 'path';
          name: 'imageType';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the account stamp.';
          in: 'path';
          name: 'signatureId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the chrome (or frame containing the added line and identifier) is included with the signature image.';
          in: 'query';
          name: 'include_chrome';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'image/gif': {
              schema: {
                format: 'binary';
                type: 'string';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            'image/gif': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns the image for an account stamp.';
      tags: ['AccountSignatures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getAccountSignatureImage';
      'x-ds-methodname': 'getAccountSignatureImage';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Sets a signature image, initials, or stamp.';
      operationId: 'AccountSignatures_PutAccountSignatureImage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specificies the type of image. Valid values:\n\n- `stamp_image`\n- `signature_image`\n- `initials_image`';
          in: 'path';
          name: 'imageType';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the account stamp.';
          in: 'path';
          name: 'signatureId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'transparent_png';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/accountSignature';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Sets a signature image, initials, or stamp.';
      tags: ['AccountSignatures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateAccountSignatureImage';
      'x-ds-methodname': 'updateAccountSignatureImage';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/signing_groups': {
    delete: {
      deprecated: false;
      description: 'Deletes one or more signing groups in the specified account.';
      operationId: 'SigningGroups_DeleteSigningGroups';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/signingGroupInformation';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/signingGroupInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes one or more signing groups.';
      tags: ['SigningGroups'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteList';
      'x-ds-service': 'SigningGroups';
    };
    get: {
      deprecated: false;
      description: 'Retrieves a list of all signing groups in the specified account.';
      operationId: 'SigningGroups_GetSigningGroups';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters by the type of signing group. Valid values:\n* `sharedSigningGroup`\n* `privateSigningGroup`\n* `systemSigningGroup`';
          in: 'query';
          name: 'group_type';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the response includes the signing group members. ';
          in: 'query';
          name: 'include_users';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/signingGroupInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a list of the Signing Groups in an account.';
      tags: ['SigningGroups'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'list';
      'x-ds-service': 'SigningGroups';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Creates one or more signing groups. \n\nMultiple signing groups can be created in one call. Only users with account administrator privileges can create signing groups. \n\nAn account can have a maximum of 50 signing groups. Each signing group can have a maximum of 50 group members.\n \nSigning groups can be used by any account user.';
      operationId: 'SigningGroups_PostSigningGroups';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/signingGroupInformation';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/signingGroupInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates a signing group. ';
      tags: ['SigningGroups'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createList';
      'x-ds-service': 'SigningGroups';
    };
    put: {
      deprecated: false;
      description: 'Updates the name of one or more existing signing groups. ';
      operationId: 'SigningGroups_PutSigningGroups';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/signingGroupInformation';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/signingGroupInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates signing group names.';
      tags: ['SigningGroups'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateList';
      'x-ds-methodname': 'updateList';
      'x-ds-service': 'SigningGroups';
    };
  };
  '/v2.1/accounts/{accountId}/signing_groups/{signingGroupId}': {
    get: {
      deprecated: false;
      description: 'Retrieves information, including group member information, for the specified signing group. ';
      operationId: 'SigningGroups_GetSigningGroup';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the [signing group](https://support.docusign.com/en/guides/ndse-user-guide-signing-groups).\n';
          in: 'path';
          name: 'signingGroupId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/signingGroup';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets information about a signing group. ';
      tags: ['SigningGroups'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'get';
      'x-ds-service': 'SigningGroups';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Updates signing group name and member information. You can also add new members to the signing group. A signing group can have a maximum of 50 members. ';
      operationId: 'SigningGroups_PutSigningGroup';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the [signing group](https://support.docusign.com/en/guides/ndse-user-guide-signing-groups).\n';
          in: 'path';
          name: 'signingGroupId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/signingGroup';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/signingGroup';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates a signing group. ';
      tags: ['SigningGroups'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'update';
      'x-ds-service': 'SigningGroups';
    };
  };
  '/v2.1/accounts/{accountId}/signing_groups/{signingGroupId}/users': {
    delete: {
      deprecated: false;
      description: 'Deletes  one or more members from the specified signing group. ';
      operationId: 'SigningGroups_DeleteSigningGroupUsers';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the [signing group](https://support.docusign.com/en/guides/ndse-user-guide-signing-groups).\n\n**Note:** When you send an envelope to a signing group,\nanyone in the group can open it and sign it with their own signature.\nFor this reason, DocuSign recommends that\nyou do not include non-signer recipients\n(such as carbon copy recipients)\nin the same signing group as signer recipients.\nHowever, you could create a second signing group\nfor the non-signer recipients and change t\nhe default action of Needs to Sign to a different value,\nsuch as Receives a Copy.';
          in: 'path';
          name: 'signingGroupId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/signingGroupUsers';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/signingGroupUsers';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes  one or more members from a signing group.';
      tags: ['SigningGroupUsers'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteUsers';
      'x-ds-service': 'SigningGroups';
    };
    get: {
      deprecated: false;
      description: 'Retrieves the list of members in the specified Signing Group.';
      operationId: 'SigningGroups_GetSigningGroupUsers';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the [signing group](https://support.docusign.com/en/guides/ndse-user-guide-signing-groups).\n\n**Note:** When you send an envelope to a signing group,\nanyone in the group can open it and sign it with their own signature.\nFor this reason, DocuSign recommends that\nyou do not include non-signer recipients\n(such as carbon copy recipients)\nin the same signing group as signer recipients.\nHowever, you could create a second signing group\nfor the non-signer recipients and change t\nhe default action of Needs to Sign to a different value,\nsuch as Receives a Copy.';
          in: 'path';
          name: 'signingGroupId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/signingGroupUsers';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a list of members in a Signing Group.';
      tags: ['SigningGroupUsers'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listUsers';
      'x-ds-service': 'SigningGroups';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Adds one or more new members to a signing group. A signing group can have a maximum of 50 members. ';
      operationId: 'SigningGroups_PutSigningGroupUsers';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the [signing group](https://support.docusign.com/en/guides/ndse-user-guide-signing-groups).\n\n**Note:** When you send an envelope to a signing group,\nanyone in the group can open it and sign it with their own signature.\nFor this reason, DocuSign recommends that\nyou do not include non-signer recipients\n(such as carbon copy recipients)\nin the same signing group as signer recipients.\nHowever, you could create a second signing group\nfor the non-signer recipients and change t\nhe default action of Needs to Sign to a different value,\nsuch as Receives a Copy.';
          in: 'path';
          name: 'signingGroupId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/signingGroupUsers';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/signingGroupUsers';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds members to a signing group. ';
      tags: ['SigningGroupUsers'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateUsers';
      'x-ds-service': 'SigningGroups';
    };
  };
  '/v2.1/accounts/{accountId}/supported_languages': {
    get: {
      deprecated: false;
      description: "Retrieves a list of supported languages that you can set for an individual recipient when creating an envelope, as well as their simple type enumeration values. These are the languages that you can set for the standard email format and signing view for each recipient.\n\nFor example, in the recipient's email notification, this setting affects elements such as the standard introductory text describing the request to sign. It also determines the language used for buttons and tabs in both the email notification and the signing experience.\n\n**Note:** Setting a language for a recipient affects only the DocuSign standard text. Any custom text that you enter for the `emailBody` and `emailSubject` of the notification is not translated, and appears exactly as you enter it.\n\nFor more information, see [Set Recipient Language and Specify Custom Email Messages](https://support.docusign.com/en/guides/ndse-user-guide-recipient-language).";
      operationId: 'SupportedLanguages_GetSupportedLanguages';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/supportedLanguages';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the supported languages for envelope recipients.';
      tags: ['Accounts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'listSupportedLanguages';
      'x-ds-methodname': 'getSupportedLanguages';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/tab_definitions': {
    get: {
      deprecated: false;
      description: 'Retrieves a list of all tabs associated with the account.';
      operationId: 'Tabs_GetTabDefinitions';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** only custom tabs are returned in the response. ';
          in: 'query';
          name: 'custom_tab_only';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/tabMetadataList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a list of all account tabs.';
      tags: ['CustomTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'list';
      'x-ds-service': 'CustomTabs';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Creates a tab with pre-defined properties, such as a text tab with a certain font type and validation pattern. Users can access the custom tabs when sending documents through the DocuSign web application.\n\nCustom tabs can be created for approve, checkbox, company, date, date signed, decline, email, email address, envelope ID, first name, formula, full name, initial here, last name, list, note, number, radio, sign here, signer attachment, SSN, text, title, and zip tabs.';
      operationId: 'Tabs_PostTabDefinitions';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/tabMetadata';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/tabMetadata';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates a custom tab.';
      tags: ['CustomTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'create';
      'x-ds-service': 'CustomTabs';
    };
  };
  '/v2.1/accounts/{accountId}/tab_definitions/{customTabId}': {
    delete: {
      deprecated: false;
      description: 'Deletes the custom from the specified account.';
      operationId: 'Tab_DeleteCustomTab';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The DocuSign-generated custom tab ID for the custom tab to be applied. This can only be used when adding new tabs for a recipient. When used, the new tab inherits all the custom tab properties.';
          in: 'path';
          name: 'customTabId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes custom tab information.';
      tags: ['CustomTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'delete';
      'x-ds-service': 'CustomTabs';
    };
    get: {
      deprecated: false;
      description: 'Retrieves information about the requested custom tab on the specified account.';
      operationId: 'Tab_GetCustomTab';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The DocuSign-generated custom tab ID for the custom tab to be applied. This can only be used when adding new tabs for a recipient. When used, the new tab inherits all the custom tab properties.';
          in: 'path';
          name: 'customTabId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/tabMetadata';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets custom tab information.';
      tags: ['CustomTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'get';
      'x-ds-service': 'CustomTabs';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Updates the information in a custom tab for the specified account.';
      operationId: 'Tab_PutCustomTab';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The DocuSign-generated custom tab ID for the custom tab to be applied. This can only be used when adding new tabs for a recipient. When used, the new tab inherits all the custom tab properties.';
          in: 'path';
          name: 'customTabId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/tabMetadata';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/tabMetadata';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates custom tab information.\n\n';
      tags: ['CustomTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'update';
      'x-ds-service': 'CustomTabs';
    };
  };
  '/v2.1/accounts/{accountId}/templates': {
    get: {
      deprecated: false;
      description: 'Retrieves the list of templates for the specified account. The request can be limited to a specific folder.\n\n### Related topics\n\n- [How to create a template](/docs/esign-rest-api/how-to/create-template/)\n';
      operationId: 'Templates_GetTemplates';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.\n\nUse `start_position` to specify the number of results to skip.\n';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Lists templates created on or after this date.';
          in: 'query';
          name: 'created_from_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Lists templates modified before this date.';
          in: 'query';
          name: 'created_to_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of folder ID GUIDs.';
          in: 'query';
          name: 'folder_ids';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The type of folder to return templates for. Possible values are:\n\n- `templates`: Templates in the **My Templates** folder.\n  Templates in the **Shared Templates**  and **All Template** folders (if the request ID from and Admin) are excluded.\n- `templates_root`: Templates in the root level of the **My Templates** folder, but not in an actual folder. Note that the **My Templates** folder is not a real folder.\n- `recylebin`: Templates that have been deleted.\n';
          in: 'query';
          name: 'folder_types';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Start of the search date range. Only returns templates created on or after this date/time. If no value is specified, there is no limit on the earliest date created.';
          in: 'query';
          name: 'from_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list\nof additional template attributes\nto include in the response.\nValid values are:\n\n- `powerforms`: Includes details about the PowerForms associated with the templates.\n- `documents`: Includes information about template documents.\n- `folders`: Includes information about the folder that holds the template.\n- `favorite_template_status`: Includes the template `favoritedByMe` property. **Note:** You can mark a template as a favorite only in eSignature v2.1.\n- `advanced_templates`: Includes information about advanced templates.\n- `recipients`: Includes information about template recipients.\n- `custom_fields`: Includes information about template custom fields.\n- `notifications`: Includes information about the notification settings for templates.';
          in: 'query';
          name: 'include';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** retrieves templates that have been permanently deleted. The default is **false.**\n\n**Note:** After you delete a template, you can see it in the `Deleted` bin in the UI for 24 hours. After 24 hours, the template is permanently deleted.\n';
          in: 'query';
          name: 'is_deleted_template_only';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** downloads the templates listed in `template_ids` as a collection of JSON definitions in a single zip file.\n\nThe `Content-Disposition` header is set in the response. The value of the header provides the filename of the file.\n\nThe default is **false.**\n\n**Note:** This parameter only works when you specify a list of templates in the `template_ids` parameter.';
          in: 'query';
          name: 'is_download';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Lists templates modified on or after this date.';
          in: 'query';
          name: 'modified_from_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Lists templates modified before this date.';
          in: 'query';
          name: 'modified_to_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies the sort order of the search results.\nValid values are:\n\n- `asc`: Ascending (A to Z)\n- `desc`: Descending (Z to A)';
          in: 'query';
          name: 'order';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specifies how the search results are listed.\nValid values are:\n\n- `name`: template name\n- `modified`: date/time template was last modified\n- `used`: date/time the template was last used.';
          in: 'query';
          name: 'order_by';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of additional template properties to search.\n\n\n- `sender`: Include sender name and email in the search.\n- `recipients`: Include recipient names and emails in the search.\n- `envelope`: Not used in template searches.\n';
          in: 'query';
          name: 'search_fields';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The text to use to search the names of templates.\n\nLimit: 48 characters.';
          in: 'query';
          name: 'search_text';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the response only includes templates shared by the user. When **false,** the response only returns template not shared by the user. If not specified, templates are returned whether or not they have been shared by the user.';
          in: 'query';
          name: 'shared_by_me';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nUse with `count` to limit the number\nof results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list of template IDs to download. This value is valid only when `is_download` is **true.**';
          in: 'query';
          name: 'template_ids';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The end of a search date range in UTC DateTime format. When you use this parameter, only templates created up to this date and time are returned.\n\n**Note:** If this property is null, the value defaults to the current date.';
          in: 'query';
          name: 'to_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Start of the search date range. Only returns templates used or edited on or after this date/time. If no value is specified, there is no limit on the earliest date used.';
          in: 'query';
          name: 'used_from_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'End of the search date range. Only returns templates used or edited up to this date/time. If no value is provided, this defaults to the current date.';
          in: 'query';
          name: 'used_to_date';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters the templates in the response. Valid values are: \n\n- `owned_by_me`: Results include only templates owned by the user.\n- `shared_with_me`: Results include only templates shared with the user.  \n- `all`:  Results include all templates owned or shared with the user.';
          in: 'query';
          name: 'user_filter';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the user.';
          in: 'query';
          name: 'user_id';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeTemplateResults';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the list of templates.';
      tags: ['Templates'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'ListTemplates';
      'x-ds-service': 'Templates';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Creates one or more template definitions, using a multipart\nrequest for each template.\n\n[Templates](/docs/esign-rest-api/esign101/concepts/templates/)\nhelp streamline the sending process when you frequently\nsend the same or similar documents, or send different documents\nto the same group of people.\n\nWhen you create a template, you define placeholder roles. Rather\nthan specifying a person, you specify a role that regularly\nparticipates in a transaction that uses the template. Then, when\nyou create or send an envelope based on the template, you assign\nactual recipients to the template roles. The recipients\nautomatically inherit all of the workflow that is defined for\nthat role in the template, such as the tabs and routing\ninformation.\n\n## Template Email Subject Merge Fields\n\nPlaceholder roles have associated merge fields that personalize\nthe email notification that DocuSign sends. For example, the\ntemplate automatically personalizes the email message by adding\nplaceholders for the recipient\'s name and email address within\nthe email subject line, based on the recipient\'s role. When the\nsender adds the name and email information for the recipient and\nsends the envelope, the recipient information is automatically\nmerged into the appropriate fields in the email subject line.\n\nBoth the sender and the recipients will see the information in\nthe email subject line for any emails associated with the\ntemplate. This provides an easy way for senders to organize their\nenvelope emails without having to open an envelope to find out\nwho the recipient is.\n\n\n\nUse the following placeholders\nto insert a recipient\'s name or\nemail address in the subject line\n\nTo insert a recipient\'s name into the subject line,\nuse the `[[<roleName>_UserName]]` placeholder\nin the  `emailSubject` property when you create the\ntemplate:\n\nTo include a recipient\'s name\nor email address in the subject line,\nuse the following placeholders\nin the `emailSubject` property:\n\n- `[[<roleName>_UserName]]`\n- `[[<roleName>_Email]]`\n\n\nFor example, if the role name is `Signer 1`,\nyou might set `emailSubject` to one of these strings:\n\n- `"[[Signer 1_UserName]], Please sign this NDA"`\n- `"[[Signer 1_Email]], Please sign this NDA"`\n\n\n**Note:** The maximum length of the\nsubject line is 100 characters,\nincluding any merged text.\n\n\n## Creating multiple templates\n\nTo create multiple templates, you provide a zip file of JSON\nfiles. You can also use the Templates::ListTemplates method with\nthe `is_download` query parameter to download a zip file\ncontaining your existing templates and use that as a guide. The\nAPI supports both .zip and .gzip file formats as input.\n\nYou also need to set the\n`Content-Length`,\n`Content-Type`,\nand\n`Content-Disposition`\nheaders:\n\n\n```\nContent-Length: 71068\nContent-Type: application/zip\nContent-Disposition: file; filename="DocuSignTemplates_Nov_25_2019_20_40_21.zip"; fileExtension=.zip\n```\n\n### Related topics\n\n- [How to create a template](/docs/esign-rest-api/how-to/create-template/)\n';
      operationId: 'Templates_PostTemplates';
      parameters: [
        {
          description: '(Required) The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/envelopeTemplate';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/templateSummary';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates one or more templates.';
      tags: ['Templates'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createTemplate';
      'x-ds-service': 'Templates';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}': {
    get: {
      deprecated: false;
      description: 'Retrieves the definition of the specified template.';
      operationId: 'Templates_GetTemplate';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma-separated list\nof additional template attributes\nto include in the response.\nValid values are:\n\n- `powerforms`: Includes information about PowerForms.\n- `tabs`: Includes information about tabs.\n- `documents`: Includes information about documents.\n- `favorite_template_status`: : Includes the template `favoritedByMe` property in the response. **Note:** You can mark a template as a favorite only in eSignature v2.1.';
          in: 'query';
          name: 'include';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeTemplate';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a specific template associated with a specified account.';
      tags: ['Templates'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'get';
      'x-ds-service': 'Templates';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Updates an existing template.';
      operationId: 'Templates_PutTemplate';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/envelopeTemplate';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/templateUpdateSummary';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates an existing template.';
      tags: ['Templates'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'update';
      'x-ds-service': 'Templates';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/custom_fields': {
    delete: {
      deprecated: false;
      description: 'Deletes envelope custom fields in a template.';
      operationId: 'CustomFields_DeleteTemplateCustomFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/templateCustomFields';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/customFields';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes envelope custom fields in a template.';
      tags: ['TemplateCustomFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteCustomFields';
      'x-ds-service': 'Templates';
    };
    get: {
      deprecated: false;
      description: 'Retrieves the custom document field information from an existing template.';
      operationId: 'CustomFields_GetTemplateCustomFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/customFields';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the custom document fields from a template.';
      tags: ['TemplateCustomFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listCustomFields';
      'x-ds-service': 'Templates';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Creates custom document fields in an existing template document.';
      operationId: 'CustomFields_PostTemplateCustomFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/templateCustomFields';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/customFields';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates custom document fields in an existing template document.';
      tags: ['TemplateCustomFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createCustomFields';
      'x-ds-service': 'Templates';
    };
    put: {
      deprecated: false;
      description: 'Updates the custom fields in a template.\n\nEach custom field used in a template must have a unique name.';
      operationId: 'CustomFields_PutTemplateCustomFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/templateCustomFields';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/customFields';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates envelope custom fields in a template.';
      tags: ['TemplateCustomFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateCustomFields';
      'x-ds-service': 'Templates';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/documents': {
    delete: {
      deprecated: false;
      description: 'This method deletes one or more documents from an existing template.\n\nTo delete a document, use only the relevant parts of the [`envelopeDefinition`](#envelopeDefinition).\nFor example, this request body specifies that you want to delete the document whose `documentId` is "1".\n\n\n```text\n{\n  "documents": [\n    {\n      "documentId": "1"\n    }\n  ]\n}\n```';
      operationId: 'Documents_DeleteTemplateDocuments';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/envelopeDefinition';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/templateDocumentsResult';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes documents from a template.';
      tags: ['TemplateDocuments'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteDocuments';
      'x-ds-service': 'Templates';
    };
    get: {
      deprecated: false;
      description: 'Retrieves a list of documents associated with the specified template.';
      operationId: 'Documents_GetTemplateDocuments';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Reserved for DocuSign.';
          in: 'query';
          name: 'include_tabs';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/templateDocumentsResult';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a list of documents associated with a template.';
      tags: ['TemplateDocuments'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listDocuments';
      'x-ds-service': 'Templates';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Adds one or more documents to an existing template document.';
      operationId: 'Documents_PutTemplateDocuments';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/envelopeDefinition';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/templateDocumentsResult';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds documents to a template document.';
      tags: ['TemplateDocuments'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateList';
      'x-ds-methodname': 'updateDocuments';
      'x-ds-service': 'Templates';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}': {
    get: {
      deprecated: false;
      description: 'This method retrieves one or more PDF documents from the template that you specify.\n\nYou can specify the ID of the document to retrieve, or pass in the value `combined` to retrieve all documents in the template as a single PDF file.';
      operationId: 'Documents_GetTemplateDocument';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the PDF bytes returned in the response are encrypted for all the key managers configured on your DocuSign account. You can decrypt the documents by using the Key Manager DecryptDocument API method. For more information about Key Manager, see the DocuSign Security Appliance Installation Guide that your organization received from DocuSign.';
          in: 'query';
          name: 'encrypt';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** any document fields that a recipient changed are highlighted in yellow in the returned PDF document, and optional signatures or initials are outlined in red.';
          in: 'query';
          name: 'show_changes';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'application/pdf': {
              schema: {
                format: 'binary';
                type: 'string';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            'application/pdf': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets PDF documents from a template.';
      tags: ['TemplateDocuments'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getDocument';
      'x-ds-service': 'Templates';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This methods updates an existing template document.';
      operationId: 'Documents_PutTemplateDocument';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'is_envelope_definition';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/envelopeDefinition';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/envelopeDocument';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates a template document.';
      tags: ['TemplateDocuments'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateDocument';
      'x-ds-service': 'Templates';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields': {
    delete: {
      deprecated: false;
      description: 'Deletes custom document fields from an existing template document.';
      operationId: 'DocumentFields_DeleteTemplateDocumentFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/documentFieldsInformation';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/documentFieldsInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes custom document fields from an existing template document.';
      tags: ['TemplateDocumentFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteDocumentFields';
      'x-ds-service': 'Templates';
    };
    get: {
      deprecated: false;
      description: 'This method retrieves the custom document fields for an existing template document.';
      operationId: 'DocumentFields_GetTemplateDocumentFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/documentFieldsInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the custom document fields for a an existing template document.';
      tags: ['TemplateDocumentFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listDocumentFields';
      'x-ds-service': 'Templates';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Creates custom document fields in an existing template document.';
      operationId: 'DocumentFields_PostTemplateDocumentFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/documentFieldsInformation';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/documentFieldsInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates custom document fields in an existing template document.';
      tags: ['TemplateDocumentFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createDocumentFields';
      'x-ds-service': 'Templates';
    };
    put: {
      deprecated: false;
      description: 'Updates existing custom document fields in an existing template document.';
      operationId: 'DocumentFields_PutTemplateDocumentFields';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/documentFieldsInformation';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/documentFieldsInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates existing custom document fields in an existing template document.';
      tags: ['TemplateDocumentFields'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateDocumentFields';
      'x-ds-service': 'Templates';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/html_definitions': {
    get: {
      deprecated: false;
      description: '';
      operationId: 'ResponsiveHtml_GetTemplateDocumentHtmlDefinitions';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/documentHtmlDefinitionOriginals';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the Original HTML Definition used to generate the Responsive HTML for a given document in a template.';
      tags: ['TemplateDocumentHtmlDefinitions'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'getTemplateDocumentHtmlDefinitions';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages': {
    get: {
      deprecated: false;
      description: 'Returns images of the pages in a template document for display based on the parameters that you specify.';
      operationId: 'Pages_GetTemplatePageImages';
      parameters: [
        {
          description: '(Required) The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '(Required) The ID of the document.';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '(Required) The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The number of dots per inch (DPI) for the resulting images. Valid values are 1-310 DPI. The default value is 94.';
          in: 'query';
          name: 'dpi';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Sets the maximum height of the returned images in pixels.';
          in: 'query';
          name: 'max_height';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Sets the maximum width of the returned images in pixels.';
          in: 'query';
          name: 'max_width';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** using cache is disabled and image information is retrieved from a database. **True** is the default value. ';
          in: 'query';
          name: 'nocache';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** changes display in the user interface.';
          in: 'query';
          name: 'show_changes';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The position within the total result set from which to start returning values. The value **thumbnail** may be used to return the page image.';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/pageImages';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns document page images based on input.';
      tags: ['Templates'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getPageImages';
      'x-ds-methodname': 'getDocumentPageImages';
      'x-ds-service': 'Templates';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}': {
    delete: {
      deprecated: false;
      description: 'Deletes a page from a document in a template based on the page number.';
      operationId: 'Pages_DeleteTemplatePage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The page number being accessed.';
          in: 'path';
          name: 'pageNumber';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/pageRequest';
      };
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes a page from a document in an template.';
      tags: ['Templates'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteDocumentPage';
      'x-ds-methodname': 'deleteDocumentPage';
      'x-ds-service': 'Templates';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}/page_image': {
    get: {
      deprecated: false;
      description: 'Retrieves a page image for display from the specified template.';
      operationId: 'Pages_GetTemplatePageImage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The page number being accessed.';
          in: 'path';
          name: 'pageNumber';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The number of dots per inch (DPI) for the resulting images. Valid values are 1-310 DPI. The default value is 94.';
          in: 'query';
          name: 'dpi';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Sets the maximum height of the returned images in pixels.';
          in: 'query';
          name: 'max_height';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Sets the maximum width of the returned images in pixels.';
          in: 'query';
          name: 'max_width';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'show_changes';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'image/png': {
              schema: {
                format: 'binary';
                type: 'string';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            'image/png': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a page image from a template for display.';
      tags: ['Templates'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getDocumentPageImage';
      'x-ds-methodname': 'getDocumentPageImage';
      'x-ds-service': 'Templates';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Rotates page image from a template for display. The page image can be rotated to the left or right.';
      operationId: 'Pages_PutTemplatePageImage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The page number being accessed.';
          in: 'path';
          name: 'pageNumber';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/pageRequest';
      };
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Rotates page image from a template for display.';
      tags: ['Templates'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'rotateDocumentPage';
      'x-ds-methodname': 'rotateDocumentPage';
      'x-ds-service': 'Templates';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}/tabs': {
    get: {
      deprecated: false;
      description: 'Returns the tabs from the page specified by `pageNumber` of the document specified by `documentId` in the\ntemplate specified by `templateId`.\n';
      operationId: 'Tabs_GetTemplatePageTabs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The page number being accessed.';
          in: 'path';
          name: 'pageNumber';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/TemplateDocumentTabs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns tabs on the specified page.';
      tags: ['TemplateDocumentTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getByPage';
      'x-ds-methodname': 'getPageTabs';
      'x-ds-service': 'Templates';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/responsive_html_preview': {
    parameters: [];
    post: {
      deprecated: false;
      description: 'Creates a preview of the\n[responsive](/docs/esign-rest-api/esign101/concepts/responsive/),\nHTML version of a specific template document. This\nmethod enables you to preview a PDF document\nconversion to responsive HTML across device types\nprior to sending.\n\nThe request body is a `documentHtmlDefinition`\nobject, which holds the responsive signing\nparameters that define how to generate the HTML\nversion of the signing document.';
      operationId: 'ResponsiveHtml_PostTemplateDocumentResponsiveHtmlPreview';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/documentHtmlDefinition';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/documentHtmlDefinitions';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates a preview of the responsive version of a template document.';
      tags: ['TemplateDocumentResponsiveHtmlPreview'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createTemplateDocumentResponsiveHtmlPreview';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/documents/{documentId}/tabs': {
    delete: {
      deprecated: false;
      description: 'Deletes tabs from the document specified by `documentId` in the\ntemplate specified by `templateId`.\n';
      operationId: 'Tabs_DeleteTemplateDocumentTabs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/templateTabs';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/tabs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes tabs from a template.';
      tags: ['TemplateDocumentTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteDocumentTabs';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: 'Returns the tabs on the document specified by `documentId` in the\ntemplate specified by `templateId`.\n\n';
      operationId: 'Tabs_GetTemplateDocumentTabs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters for tabs that occur on the pages that you specify. Enter as a comma-separated list of page Guids.\n\nExample: `page_numbers=2,6`';
          in: 'query';
          name: 'page_numbers';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/TemplateDocumentTabs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns tabs on a template.';
      tags: ['TemplateDocumentTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getDocumentTabs';
      'x-ds-service': 'Templates';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Adds tabs to the document specified by `documentId` in the\ntemplate specified by `templateId`.\n\nIn the request body, you only need to specify the tabs that your\nare adding. For example, to add a text\n[prefill tab](/docs/esign-rest-api/reference/templates/templatedocumenttabs/create/#definition__templatetabs_prefilltabs),\nyour request body might look like this:\n\n```\n{\n  "prefillTabs": {\n    "textTabs": [\n      {\n        "value": "a prefill text tab",\n        "pageNumber": "1",\n        "documentId": "1",\n        "xPosition": 316,\n        "yPosition": 97\n      }\n    ]\n  }\n}\n```\n';
      operationId: 'Tabs_PostTemplateDocumentTabs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/templateTabs';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/tabs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds tabs to a document in a template.';
      tags: ['TemplateDocumentTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'postDocumentTabs';
      'x-ds-service': 'Uncategorized';
    };
    put: {
      deprecated: false;
      description: 'Updates tabs in the document specified by `documentId` in the\ntemplate specified by `templateId`.\n';
      operationId: 'Tabs_PutTemplateDocumentTabs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The unique ID of the document within the envelope.\n\nUnlike other IDs in the eSignature API,\nyou specify the `documentId` yourself.\nTypically the first document has the ID\n`1`, the second document `2`, and so on,\nbut you can use any numbering scheme\nthat fits within a 32-bit signed integer\n(1 through 2147483647).\n\n\nTab objects have a `documentId` property\nthat specifies the document on which to place\nthe tab.\n';
          in: 'path';
          name: 'documentId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/templateTabs';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/tabs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the tabs for a template.';
      tags: ['TemplateDocumentTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'putDocumentTabs';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/html_definitions': {
    get: {
      deprecated: false;
      description: '';
      operationId: 'ResponsiveHtml_GetTemplateHtmlDefinitions';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/documentHtmlDefinitionOriginals';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the Original HTML Definition used to generate the Responsive HTML for the template.';
      tags: ['TemplateHtmlDefinitions'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'getTemplateHtmlDefinitions';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/lock': {
    delete: {
      deprecated: false;
      description: 'Deletes the lock from the specified template.\nThe user deleting the lock must be the same user\nwho locked the template.\n\nYou must include the `X-DocuSign-Edit` header\nas described in\n[TemplateLocks: create](/docs/esign-rest-api/reference/templates/templatelocks/create/).\n\nThis method takes an optional query parameter\nthat lets you specify whether\nchanges made while the template was locked\nare kept or discarded.\n\n\n| Query Parameter | Description                                                                                                                                                                         |\n| :-------------- | :---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |\n| `save_changes`  | When **true** (the default), any changes made while the lock was active are saved. When **false,** any changes made while the template was locked are discarded. |\n\n\n### Related topics\n\n- [Common API Tasks: Locking and unlocking envelopes](https://www.docusign.com/blog/dsdev-common-api-tasks-locking-and-unlocking-envelopes)\n\n';
      operationId: 'Lock_DeleteTemplateLock';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/lockRequest';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/lockInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes a template lock.';
      tags: ['TemplateLocks'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteLock';
      'x-ds-service': 'Templates';
    };
    get: {
      deprecated: false;
      description: 'Retrieves general information about a template lock.\n\nThe user requesting the information must be the same user\nwho locked the template.\n\nYou can use this method to recover the lock information,\nincluding the `lockToken`,\nfor a locked template.\nThe `X-DocuSign-Edit` header is included in the response.\n\nSee\n[TemplateLocks: create](/docs/esign-rest-api/reference/templates/templatelocks/create/)\nfor a description of the `X-DocuSign-Edit` header.\n\n### Related topics\n\n- [Common API Tasks: Locking and unlocking envelopes](https://www.docusign.com/blog/dsdev-common-api-tasks-locking-and-unlocking-envelopes)\n\n';
      operationId: 'Lock_GetTemplateLock';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/lockInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets template lock information.';
      tags: ['TemplateLocks'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getLock';
      'x-ds-service': 'Templates';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'This method locks the specified template and sets the time until\nthe lock expires to prevent other users or recipients from\nchanging the template.\n\nThe response to this request includes a `lockToken` parameter\nthat you must use in the `X-DocuSign-Edit` header for\nevery PUT method (typically a method that updates a template)\nwhile the template is locked.\n\n\nIf you do not provide the `lockToken` when accessing\na locked template, you will get the following\nerror:\n\n```\n{\n   "errorCode": "EDIT_LOCK_NOT_LOCK_OWNER",\n   "message": "The user is not the owner of the lock. The template is locked by another user or in another application"\n}\n```\n\n\n### The X-DocuSign-Edit header\n\nThe `X-DocuSign-Edit` header looks like this\nand can be specified in either JSON or XML.\n\n**JSON**\n```\n{\n  "LockToken": "token-from-response",\n  "LockDurationInSeconds": "600"\n}\n```\n\n**XML**\n```\n<DocuSignEdit>\n  <LockToken>token-from-response</LockToken>\n  <LockDurationInSeconds>600</LockDurationInSeconds>\n</DocuSignEdit>\n```\n\nIn the actual HTTP header, you would remove the linebreaks:\n\n```\nX-DocuSign-Edit: {"LockToken": "token-from-response", "LockDurationInSeconds": "600" }\n    or\nX-DocuSign-Edit:<DocuSignEdit><LockToken>token-from-response</LockToken><LockDurationInSeconds>600</LockDurationInSeconds></DocuSignEdit>\n```\n\n\n### Related topics\n\n- [Common API Tasks: Locking and unlocking envelopes](https://www.docusign.com/blog/dsdev-common-api-tasks-locking-and-unlocking-envelopes)\n\n';
      operationId: 'Lock_PostTemplateLock';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/lockRequest';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/lockInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Locks a template.';
      tags: ['TemplateLocks'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createLock';
      'x-ds-service': 'Templates';
    };
    put: {
      deprecated: false;
      description: 'Updates the lock information for a locked template.\n\nYou must include the `X-DocuSign-Edit` header\nas described in\n[TemplateLocks: create](/docs/esign-rest-api/reference/templates/templatelocks/create/).\n\n\nUse this method to change the duration\nof the lock (`lockDurationInSeconds`)\nor the `lockedByApp` string.\n\nThe request body is a full `lockRequest` object,\nbut you only need to specify the\nproperties that you are updating. For example:\n\n```\n{\n  "lockDurationInSeconds": "3600",\n  "lockedByApp": "My Application"\n}\n```\n\n';
      operationId: 'Lock_PutTemplateLock';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/lockRequest';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/lockInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates a template lock.';
      tags: ['TemplateLocks'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateLock';
      'x-ds-service': 'Templates';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/notification': {
    get: {
      deprecated: false;
      description: 'Retrieves the envelope notification, reminders and expirations, information for an existing template.';
      operationId: 'Notification_GetTemplatesTemplateIdNotification';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/notification';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets template notification information.';
      tags: ['Templates'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getNotificationSettings';
      'x-ds-methodname': 'getNotificationSettings';
      'x-ds-service': 'Templates';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Updates the notification structure for an existing template. Use this endpoint to set reminder and expiration notifications.';
      operationId: 'Notification_PutTemplatesTemplateIdNotification';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/templateNotificationRequest';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/notification';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the notification  structure for an existing template.';
      tags: ['Templates'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateNotificationSettings';
      'x-ds-methodname': 'updateNotificationSettings';
      'x-ds-service': 'Templates';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/recipients': {
    delete: {
      deprecated: false;
      description: 'Deletes one or more recipients from a template. Recipients to be deleted are listed in the request, with the `recipientId` being used as the key for deleting recipients.';
      operationId: 'Recipients_DeleteTemplateRecipients';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/templateRecipients';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/recipients';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes recipients from a template.';
      tags: ['TemplateRecipients'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteList';
      'x-ds-methodname': 'deleteRecipients';
      'x-ds-service': 'Templates';
    };
    get: {
      deprecated: false;
      description: 'Retrieves the information for all recipients in the specified template.';
      operationId: 'Recipients_GetTemplateRecipients';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: ' When **true** and `include_tabs` is set to **true,** all tabs with anchor tab properties are included in the response. ';
          in: 'query';
          name: 'include_anchor_tab_locations';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: ' When **true,** the extended properties are included in the response. ';
          in: 'query';
          name: 'include_extended';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the tab information associated with the recipient is included in the response.';
          in: 'query';
          name: 'include_tabs';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/recipients';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets recipient information from a template.';
      tags: ['TemplateRecipients'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listRecipients';
      'x-ds-service': 'Templates';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Adds one or more recipients to a template.';
      operationId: 'Recipients_PostTemplateRecipients';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,**\nresends the envelope to the recipients\nthat you specify in the request body.\nUse this parameter to resend the envelope\nto a recipient\nwho deleted the original email notification.\n\n**Note:** Correcting an envelope is a different process.\nDocuSign always resends an envelope when you correct it,\nregardless of the value that you enter here.';
          in: 'query';
          name: 'resend_envelope';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/templateRecipients';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/recipients';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds tabs for a recipient.';
      tags: ['TemplateRecipients'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createRecipients';
      'x-ds-service': 'Templates';
    };
    put: {
      deprecated: false;
      description: 'Updates recipients in a template. \n\nYou can edit the following properties: `email`, `userName`, `routingOrder`, `faxNumber`, `deliveryMethod`, `accessCode`, and `requireIdLookup`.';
      operationId: 'Recipients_PutTemplateRecipients';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,**\nresends the envelope to the recipients\nthat you specify in the request body.\nUse this parameter to resend the envelope\nto a recipient\nwho deleted the original email notification.\n\n**Note:** Correcting an envelope is a different process.\nDocuSign always resends an envelope when you correct it,\nregardless of the value that you enter here.';
          in: 'query';
          name: 'resend_envelope';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/templateRecipients';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/recipientsUpdateSummary';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates recipients in a template.';
      tags: ['TemplateRecipients'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateRecipients';
      'x-ds-service': 'Templates';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/document_visibility': {
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method updates document visibility for one or more template recipients based on the `recipientId` and `visible` values that you include in the request body.\n\n\n**Note:** A document cannot be hidden from a recipient if the recipient has tabs assigned to them on the document. Carbon Copy, Certified Delivery (Needs to Sign), Editor, and Agent recipients can always see all documents.';
      operationId: 'Recipients_PutTemplateRecipientsDocumentVisibility';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/templateDocumentVisibilityList';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/templateDocumentVisibilityList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates document visibility for template recipients';
      tags: ['TemplateDocumentVisibility'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateList';
      'x-ds-methodname': 'updateTemplateRecipientsDocumentVisibility';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}': {
    delete: {
      deprecated: false;
      description: 'Deletes the specified recipient file from the specified template.';
      operationId: 'Recipients_DeleteTemplateRecipient';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/templateRecipients';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/recipients';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes the specified recipient file from a template.';
      tags: ['TemplateRecipients'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteRecipient';
      'x-ds-service': 'Templates';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/document_visibility': {
    get: {
      deprecated: false;
      description: 'This method returns information about document visibility for a template recipient.';
      operationId: 'Recipients_GetTemplateRecipientDocumentVisibility';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/documentVisibilityList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns document visibility for a template recipient';
      tags: ['TemplateDocumentVisibility'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getTemplateRecipientDocumentVisibility';
      'x-ds-service': 'Envelopes';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method updates the document visibility for a template recipient.\n\n**Note:** A document cannot be hidden from a recipient if the recipient has tabs assigned to them on the document. Carbon Copy, Certified Delivery (Needs to Sign), Editor, and Agent recipients can always see all documents.';
      operationId: 'Recipients_PutTemplateRecipientDocumentVisibility';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/templateDocumentVisibilityList';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/templateDocumentVisibilityList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates document visibility for a template recipient';
      tags: ['TemplateDocumentVisibility'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateTemplateRecipientDocumentVisibility';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs': {
    delete: {
      deprecated: false;
      description: 'Deletes one or more tabs associated with a recipient in a template.';
      operationId: 'Recipients_DeleteTemplateRecipientTabs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/templateTabs';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/tabs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes the tabs associated with a recipient in a template.';
      tags: ['TemplateRecipientTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteTabs';
      'x-ds-service': 'Templates';
    };
    get: {
      deprecated: false;
      description: 'Gets the tabs information for a signer or sign-in-person recipient in a template.';
      operationId: 'Recipients_GetTemplateRecipientTabs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** all tabs with anchor tab properties are included in the response. The default value is **false.**';
          in: 'query';
          name: 'include_anchor_tab_locations';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the response includes metadata indicating which properties are editable.';
          in: 'query';
          name: 'include_metadata';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/tabs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the tabs information for a signer or sign-in-person recipient in a template.';
      tags: ['TemplateRecipientTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listTabs';
      'x-ds-service': 'Templates';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Adds one or more tabs for a recipient.';
      operationId: 'Recipients_PostTemplateRecipientTabs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/templateTabs';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/tabs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds tabs for a recipient.';
      tags: ['TemplateRecipientTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createTabs';
      'x-ds-service': 'Templates';
    };
    put: {
      deprecated: false;
      description: 'Updates one or more tabs for a recipient in a template.';
      operationId: 'Recipients_PutTemplateRecipientTabs';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A local reference that senders use to map recipients to other objects, such as specific document tabs. Within an envelope, each `recipientId` must be unique, but there is no uniqueness requirement across envelopes. For example, many envelopes assign the first recipient a `recipientId` of `1`.';
          in: 'path';
          name: 'recipientId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/templateTabs';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/tabs';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the tabs for a recipient.';
      tags: ['TemplateRecipientTabs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateTabs';
      'x-ds-service': 'Templates';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/responsive_html_preview': {
    parameters: [];
    post: {
      deprecated: false;
      description: 'Creates a preview of the\n[responsive](/docs/esign-rest-api/esign101/concepts/responsive/),\nHTML versions of all of the documents associated\nwith a template. This method enables you to\npreview the PDF document conversions to responsive\nHTML across device types prior to sending.\n\nThe request body is a `documentHtmlDefinition`\nobject, which holds the responsive signing\nparameters that define how to generate the HTML\nversion of the documents.';
      operationId: 'ResponsiveHtml_PostTemplateResponsiveHtmlPreview';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/documentHtmlDefinition';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/documentHtmlDefinitions';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates a preview of the responsive versions of all of the documents associated with a template.';
      tags: ['TemplateResponsiveHtmlPreview'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createTemplateResponsiveHtmlPreview';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/views/edit': {
    parameters: [];
    post: {
      deprecated: false;
      description: 'This method returns a URL for starting an edit view of a template that uses the DocuSign Template UI. The URL can only be used once.\n\nTo prevent the user from accessing the sending account, set the `returnUrl` value in the request body.\n\n## Information security notice\n\nIf the `returnUrl` value is not set, this method provides full access to the sending account. If the account has administrative privileges, then this method also provides administrator access.';
      operationId: 'Views_PostTemplateEditView';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/returnUrlRequest';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/viewUrl';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a URL for a template edit view.';
      tags: ['TemplateViews'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createEdit';
      'x-ds-methodname': 'createEditView';
      'x-ds-service': 'Templates';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/views/recipient_preview': {
    parameters: [];
    post: {
      deprecated: false;
      description: "This method returns a URL for a template recipient preview  in the DocuSign UI that you can embed in your application. You use this method to enable the sender to preview the recipients' experience.\n\nFor more information, see [Preview and Send](https://support.docusign.com/en/guides/ndse-user-guide-send-your-documents).";
      operationId: 'Views_PostTemplateRecipientPreview';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/recipientPreviewRequest';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/viewUrl';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates a template recipient preview.';
      tags: ['TemplateRecipients'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createTemplateRecipientPreview';
      'x-ds-methodname': 'createTemplateRecipientPreview';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/workflow': {
    delete: {
      deprecated: false;
      description: "Deletes the specified template's workflow definition if it has one.\n\n**Note:** If the specified template does not have a workflow definition, this endpoint returns a 200 response.";
      operationId: 'TemplateWorkflowDefinition_DeleteTemplateWorkflowDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Delete the workflow definition for a template.';
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteTemplateWorkflowDefinition';
      'x-ds-methodname': 'deleteTemplateWorkflowDefinition';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: 'Returns the workflow definition for the template specified by `templateId`. If the template does not have a workflow object, this method returns a 404.\n';
      operationId: 'TemplateWorkflowDefinition_GetTemplateWorkflowDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/workflow';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns the workflow definition for a template.';
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getTemplateWorkflowDefinition';
      'x-ds-methodname': 'getTemplateWorkflowDefinition';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: "Updates the specified template's workflow definition.";
      operationId: 'TemplateWorkflowDefinition_PutTemplateWorkflowDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/workflow';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/workflow';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the workflow definition for a template.';
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateTemplateWorkflowDefinition';
      'x-ds-methodname': 'updateTemplateWorkflowDefinition';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/workflow/scheduledSending': {
    delete: {
      deprecated: false;
      description: "Deletes the scheduled sending rules for the template's workflow.";
      operationId: 'TemplateWorkflowScheduledSending_DeleteTemplateScheduledSendingDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: "Deletes the scheduled sending rules for the template's workflow.";
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteTemplateScheduledSendingDefinition';
      'x-ds-methodname': 'deleteTemplateScheduledSendingDefinition';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: "Given a template specified by `templateId`, returns the scheduled sending rules for that template's workflow object.\n\n**Note:** If the template's workflow does not have a scheduled sending object, this method returns a 404.";
      operationId: 'TemplateWorkflowScheduledSending_GetTemplateScheduledSendingDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/scheduledSending';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: "Returns the scheduled sending rules for a template's workflow definition.";
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getTemplateScheduledSendingDefinition';
      'x-ds-methodname': 'getTemplateScheduledSendingDefinition';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: '';
      operationId: 'TemplateWorkflowScheduledSending_PutTemplateScheduledSendingDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/scheduledSending';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/scheduledSending';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: "Updates the scheduled sending rules for a template's workflow definition.";
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateTemplateScheduledSendingDefinition';
      'x-ds-methodname': 'updateTemplateScheduledSendingDefinition';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps': {
    parameters: [];
    post: {
      deprecated: false;
      description: "Adds a new step to a template's workflow.";
      operationId: 'TemplateWorkflowStep_PostTemplateWorkflowStepDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/workflowStep';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/workflowStep';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: "Adds a new step to a template's workflow.";
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createTemplateWorkflowStepDefinition';
      'x-ds-methodname': 'createTemplateWorkflowStepDefinition';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}': {
    delete: {
      deprecated: false;
      description: "Deletes a workflow step from an template's workflow definition.";
      operationId: 'TemplateWorkflowStep_DeleteTemplateWorkflowStepDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workflow step.';
          in: 'path';
          name: 'workflowStepId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: "Deletes a workflow step from an template's workflow definition.";
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteTemplateWorkflowStepDefinition';
      'x-ds-methodname': 'deleteTemplateWorkflowStepDefinition';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: 'Returns a workflow step specified by `workflowStepId` for a template specified by `templateId`.';
      operationId: 'TemplateWorkflowStep_GetTemplateWorkflowStepDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workflow step.';
          in: 'path';
          name: 'workflowStepId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/workflowStep';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns a specified workflow step for a specified envelope.';
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getTemplateWorkflowStepDefinition';
      'x-ds-methodname': 'getTemplateWorkflowStepDefinition';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Updates a specified workflow step for a template.';
      operationId: 'TemplateWorkflowStep_PutTemplateWorkflowStepDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workflow step.';
          in: 'path';
          name: 'workflowStepId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/workflowStep';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/workflowStep';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates a specified workflow step for a template.';
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateTemplateWorkflowStepDefinition';
      'x-ds-methodname': 'updateTemplateWorkflowStepDefinition';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}/delayedRouting': {
    delete: {
      deprecated: false;
      description: 'Deletes the delayed routing rules for the specified template workflow step.';
      operationId: 'TemplateWorkflowDelayedRouting_DeleteTemplateDelayedRoutingDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workflow step.';
          in: 'path';
          name: 'workflowStepId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes the delayed routing rules for the specified template workflow step.';
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteTemplateDelayedRoutingDefinition';
      'x-ds-methodname': 'deleteTemplateDelayedRoutingDefinition';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: 'Given a template and a workflow step, returns the delayed routing rules for that workflow step.\n\n**Note:** If the workflow step does not have a delayed routing object, this method returns a 404.';
      operationId: 'TemplateWorkflowDelayedRouting_GetTemplateDelayedRoutingDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workflow step.';
          in: 'path';
          name: 'workflowStepId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/delayedRouting';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: "Returns the delayed routing rules for a template's workflow step definition.";
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getTemplateDelayedRoutingDefinition';
      'x-ds-methodname': 'getTemplateDelayedRoutingDefinition';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: "Updates the scheduled sending rules for a template's workflow.";
      operationId: 'TemplateWorkflowDelayedRouting_PutTemplateDelayedRoutingDefinition';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workflow step.';
          in: 'path';
          name: 'workflowStepId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/delayedRouting';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/delayedRouting';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: "Updates the delayed routing rules for a template's workflow step.";
      tags: ['EnvelopeWorkflowDefinition'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateTemplateDelayedRoutingDefinition';
      'x-ds-methodname': 'updateTemplateDelayedRoutingDefinition';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/templates/{templateId}/{templatePart}': {
    delete: {
      deprecated: false;
      description: "Removes a member group's sharing permissions for a specified template.";
      operationId: 'Templates_DeleteTemplatePart';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Currently, the only defined part is **groups.**';
          in: 'path';
          name: 'templatePart';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/groupInformation';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/groupInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: "Removes a member group's sharing permissions for a template.";
      tags: ['Templates'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteGroupShare';
      'x-ds-methodname': 'deleteGroupShare';
      'x-ds-service': 'Templates';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Shares a template with the specified members group.\n\n**Note:** For a newer version of this functionality, see [Accounts: Update Shared Access](/docs/esign-rest-api/reference/accounts/accounts/updatesharedaccess/).';
      operationId: 'Templates_PutTemplatePart';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the template.';
          in: 'path';
          name: 'templateId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Currently, the only defined part is **groups.**';
          in: 'path';
          name: 'templatePart';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/groupInformation';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/groupInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Shares a template with a group.';
      tags: ['Templates'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateGroupShare';
      'x-ds-methodname': 'updateGroupShare';
      'x-ds-service': 'Templates';
    };
  };
  '/v2.1/accounts/{accountId}/unsupported_file_types': {
    get: {
      deprecated: false;
      description: 'Retrieves a list of file types (mime-types and file-extensions) that are not supported for upload through the DocuSign system.';
      operationId: 'UnsupportedFileTypes_GetUnsupportedFileTypes';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/fileTypeList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a list of unsupported file types.';
      tags: ['Accounts'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'listUnsupportedFileTypes';
      'x-ds-methodname': 'listUnsupportedFileTypes';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/users': {
    delete: {
      deprecated: false;
      description: 'Closes one or more users in the account,\npreventing them from accessing account features.\nUsers are not permanently deleted.\n\nThe request body requires only\nthe IDs of the users to close:\n\n```json\n{\n    "users": [\n        { "userId": "6b67a1ee-xxxx-xxxx-xxxx-385763624163" },\n        { "userId": "b6c74c52-xxxx-xxxx-xxxx-457a81d88926" },\n        { "userId": "464f7988-xxxx-xxxx-xxxx-781ee556ab7a" }\n    ]\n}\n```\n\nYou can use [`Users:update`](/docs/esign-rest-api/reference/users/users/update/)\nto re-open a closed user.\n\n';
      operationId: 'Users_DeleteUsers';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A list of groups to remove the user from.\nA comma-separated list of the following:\n\n- `Groups`\n- `PermissionSet`\n- `SigningGroupsEmail`';
          in: 'query';
          name: 'delete';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/userInfoList';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/usersResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Closes one or more users in the account.';
      tags: ['Users'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'delete';
      'x-ds-service': 'Users';
    };
    get: {
      deprecated: false;
      description: 'Retrieves the list of users for the specified account.\n\nThe response returns the list of users for the account, with information about the result set. If the `additional_info` query is added to the endpoint and set to **true,** full user information is returned for each user.';
      operationId: 'Users_GetUsers';
      parameters: [
        {
          description: '(Required) The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the custom settings information is returned for each user in the account. If this parameter is omitted, the default behavior is **false.**';
          in: 'query';
          name: 'additional_info';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'alternate_admins_only';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.\n\nUse `start_position` to specify the number of results to skip.\n\nValid values: `1` to `100`\n';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'domain_users_only';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters results based on the email address associated with the user that you want to return.\n\n**Note:** You can use either this parameter or the `email_substring` parameter, but not both. For older accounts, this parameter might return multiple users who are associated with a single email address. ';
          in: 'query';
          name: 'email';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters results based on a fragment of an email address. For example, you could enter `gmail` to return all users who have Gmail addresses.\n\n**Note:** You do not use a wildcard character with this parameter. You can use either this parameter or the `email` parameter, but not both. ';
          in: 'query';
          name: 'email_substring';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters results based on one or more group IDs.';
          in: 'query';
          name: 'group_id';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the response includes the `userSettings` object data in CSV format.';
          in: 'query';
          name: 'include_usersettings_for_csv';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the response includes the login status of each user.';
          in: 'query';
          name: 'login_status';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Return user records excluding the specified group IDs.';
          in: 'query';
          name: 'not_group_id';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nUse with `count` to limit the number\nof results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters results by user account status.\nA comma-separated list of any of the following:\n\n* `ActivationRequired`\n* `ActivationSent`\n* `Active`\n* `Closed`\n* `Disabled`\n';
          in: 'query';
          name: 'status';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters the user records returned by the user name or a sub-string of user name.';
          in: 'query';
          name: 'user_name_substring';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userInformationList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieves the list of users for the specified account.';
      tags: ['Users'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'list';
      'x-ds-service': 'Users';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Adds new users to an account. \n\nThe body of this request is an array of `newUsers` objects. For each new user, you must provide at least the `userName` and `email` properties. The maximum number of users you can create in one request is 500 users. \n\nThe `userSettings` property specifies the actions users can perform. In the example below, Tal Mason will be able to send envelopes, and the activation email will be in French because the `locale` is set to `fr`.\n\n\n```\nPOST /restapi/v2.1/accounts/{accountId}/users\nContent-Type: application/json\n```\n```\n{\n  "newUsers": [\n    {\n      "userName": "Claire Horace",\n      "email": "claire@example.com"\n    },\n    {\n      "userName": "Tal Mason",\n      "email": "talmason@example.com",\n      "company": "TeleSel",\n      "userSettings": {\n        "locale": "fr",\n        "canSendEnvelope": true\n      }\n    }\n  ]\n}\n```\n\nA successful response is a `newUsers` array with information about the newly created users. If there was a problem in creating a user, that user entry will contain an `errorDetails` property that describes what went wrong.\n\n```json\n{\n  "newUsers": [\n    {\n      "userId": "18f3be12-xxxx-xxxx-xxxx-883d8f9b8ade",\n      "uri": "/users/18f3be12-xxxx-xxxx-xxxx-883d8f9b8ade",\n      "email": "claire@example.com",\n      "userName": "Claire Horace",\n      "createdDateTime": "0001-01-01T08:00:00.0000000Z",\n      "errorDetails": {\n        "errorCode": "USER_ALREADY_EXISTS_IN_ACCOUNT",\n        "message": "Username and email combination already exists for this account."\n      }\n    },\n    {\n      "userId": "be9899a3-xxxx-xxxx-xxxx-2c8dd7156e33",\n      "uri": "/users/be9899a3-xxxx-xxxx-xxxx-2c8dd7156e33",\n      "email": "talmason@example.com",\n      "userName": "Tal Mason",\n      "userStatus": "ActivationSent",\n      "createdDateTime": "2020-05-26T23:25:30.7330000Z"\n    }\n  ]\n}\n```\n';
      operationId: 'Users_PostUsers';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/newUsersDefinition';
            };
          };
        };
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/newUsersSummary';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds new users to the specified account.';
      tags: ['Users'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'create';
      'x-ds-service': 'Users';
    };
    put: {
      deprecated: false;
      description: 'This method updates the information about one or more account users.';
      operationId: 'Users_PutUsers';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'allow_all_languages';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/userInformationList';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userInformationList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Changes one or more users in the specified account.';
      tags: ['Users'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateList';
      'x-ds-methodname': 'updateUsers';
      'x-ds-service': 'Users';
    };
  };
  '/v2.1/accounts/{accountId}/users/{userId}': {
    get: {
      deprecated: false;
      description: 'Retrieves the user information for the specified user.  For example:\n\n```json\n{\n  "userName": "Tania Morales",\n  "userId": "6b67a1ee-xxxx-xxxx-xxxx-385763624163",\n  "userType": "CompanyUser",\n  "isAdmin": "False",\n  "isNAREnabled": "false",\n  "userStatus": "Active",\n  "uri": "/users/6b67a1ee-xxxx-xxxx-xxxx-385763624163",\n  "email": "examplename42@orobia.net",\n  "createdDateTime": "2019-04-01T22:11:56.4570000Z",\n  "userAddedToAccountDateTime": "0001-01-01T08:00:00.0000000Z",\n  "firstName": "Tania",\n  "lastName": "Morales",\n  "jobTitle": "",\n  "company": "Company",\n  "permissionProfileId": "12345678",\n  "permissionProfileName": "DocuSign Viewer",\n  "userSettings": {. . .},\n  "sendActivationOnInvalidLogin": "false",\n  "enableConnectForUser": "false",\n  "groupList": [. . .],\n  "workAddress": {. . .},\n  "homeAddress": {. . .},\n  "signatureImageUri": "/users/6b67a1ee-xxxx-xxxx-xxxx-385763624163/signatures/0304c47b-xxxx-xxxx-xxxx-c9673963bb50/signature_image",\n  "initialsImageUri": "/users/6b67a1ee-xxxx-xxxx-xxxx-385763624163/signatures/0304c47b-xxxx-xxxx-xxxx-c9673963bb50/initials_image",\n  "defaultAccountId": "f636f297-xxxx-xxxx-xxxx-8e7a14715950"\n}\n```\n\n';
      operationId: 'User_GetUser';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Setting this parameter has no effect in this operation.';
          in: 'query';
          name: 'additional_info';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Setting this parameter has no effect in this operation.';
          in: 'query';
          name: 'email';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the user information for a specified user.';
      tags: ['Users'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getInformation';
      'x-ds-service': 'Users';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'To update user information for a specific user, submit a [Users](#Users) object with updated field values in the request body of this operation.';
      operationId: 'User_PutUser';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'allow_all_languages';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/userInformation';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates user information for the specified user.';
      tags: ['Users'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateUser';
      'x-ds-service': 'Users';
    };
  };
  '/v2.1/accounts/{accountId}/users/{userId}/authorization': {
    parameters: [];
    post: {
      deprecated: false;
      description: '';
      operationId: 'UserAuthorization_CreateUserAuthorization';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/userAuthorizationCreateRequest';
            };
          };
        };
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userAuthorization';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates the user authorization.\n';
      tags: ['Authorizations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createUserAuthorization';
      'x-ds-methodname': 'createUserAuthorization';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/users/{userId}/authorization/{authorizationId}': {
    delete: {
      deprecated: false;
      description: '';
      operationId: 'UserAuthorization_DeleteUserAuthorization';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'path';
          name: 'authorizationId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes the user authorization.\n';
      tags: ['Authorizations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteUserAuthorization';
      'x-ds-methodname': 'deleteUserAuthorization';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: '';
      operationId: 'UserAuthorization_GetUserAuthorization';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'path';
          name: 'authorizationId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userAuthorization';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns the user authorization for a given authorization ID.\n';
      tags: ['Authorizations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getUserAuthorization';
      'x-ds-methodname': 'getUserAuthorization';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: '';
      operationId: 'UserAuthorization_UpdateUserAuthorization';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'path';
          name: 'authorizationId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/userAuthorizationUpdateRequest';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userAuthorization';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the user authorization.\n';
      tags: ['Authorizations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateUserAuthorization';
      'x-ds-methodname': 'updateUserAuthorization';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/users/{userId}/authorizations': {
    delete: {
      deprecated: false;
      description: '';
      operationId: 'UserAuthorizations_DeleteUserAuthorizations';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/userAuthorizationsDeleteRequest';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userAuthorizationsDeleteResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes the user authorizations.\n';
      tags: ['Authorizations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteUserAuthorizations';
      'x-ds-methodname': 'deleteUserAuthorizations';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: '';
      operationId: 'UserAuthorizations_GetPrincipalUserAuthorizations';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'active_only';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters returned user records by full email address or a substring of email address.';
          in: 'query';
          name: 'email_substring';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'permissions';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The position within the total result set from which to start returning values. The value **thumbnail** may be used to return the page image.';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters results based on a full or partial user name.\n\n**Note:** When you enter a partial user name, you do not use a wildcard character.';
          in: 'query';
          name: 'user_name_substring';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userAuthorizations';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns the principal user authorizations.\n';
      tags: ['Authorizations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getPrincipalUserAuthorizations';
      'x-ds-methodname': 'getPrincipalUserAuthorizations';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: '';
      operationId: 'UserAuthorizations_PostUserAuthorizations';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/userAuthorizationsRequest';
            };
          };
        };
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userAuthorizationsResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates or updates user authorizations.\n';
      tags: ['Authorizations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createUserAuthorizations';
      'x-ds-methodname': 'createUserAuthorizations';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/accounts/{accountId}/users/{userId}/authorizations/agent': {
    get: {
      deprecated: false;
      description: '';
      operationId: 'UserAgentAuthorizations_GetAgentUserAuthorizations';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'active_only';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters returned user records by full email address or a substring of email address.';
          in: 'query';
          name: 'email_substring';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'permissions';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The position within the total result set from which to start returning values. The value **thumbnail** may be used to return the page image.';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Filters results based on a full or partial user name.\n\n**Note:** When you enter a partial user name, you do not use a wildcard character.';
          in: 'query';
          name: 'user_name_substring';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userAuthorizations';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns the agent user authorizations.\n';
      tags: ['Authorizations'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getAgentUserAuthorizations';
      'x-ds-methodname': 'getAgentUserAuthorizations';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/users/{userId}/cloud_storage': {
    delete: {
      deprecated: false;
      description: 'Deletes the user authentication information for one or more cloud storage providers. The next time the user tries to access the cloud storage provider, they must pass normal authentication.';
      operationId: 'CloudStorage_DeleteCloudStorageProviders';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/cloudStorageProviders';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/cloudStorageProviders';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes the user authentication information for one or more cloud storage providers.';
      tags: ['CloudStorageProviders'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteList';
      'x-ds-methodname': 'deleteProviders';
      'x-ds-service': 'CloudStorage';
    };
    get: {
      deprecated: false;
      description: 'Retrieves the list of cloud storage providers enabled for the account and the configuration information for the user.\n';
      operationId: 'CloudStorage_GetCloudStorageProviders';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: ' The URL the user is redirected to after the cloud storage provider authenticates the user. Using this will append the redirectUrl to the authenticationUrl.\n\nThe redirectUrl is restricted to URLs in the docusign.com or docusign.net domains.\n ';
          in: 'query';
          name: 'redirectUrl';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/cloudStorageProviders';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Get the Cloud Storage Provider configuration for the specified user.';
      tags: ['CloudStorageProviders'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listProviders';
      'x-ds-service': 'CloudStorage';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Configures the redirect URL information  for one or more cloud storage providers for the specified user. The redirect URL is added to the authentication URL to complete the return route.';
      operationId: 'CloudStorage_PostCloudStorage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/cloudStorageProviders';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/cloudStorageProviders';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Configures the redirect URL information  for one or more cloud storage providers for the specified user.';
      tags: ['CloudStorageProviders'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createProvider';
      'x-ds-service': 'CloudStorage';
    };
  };
  '/v2.1/accounts/{accountId}/users/{userId}/cloud_storage/{serviceId}': {
    delete: {
      deprecated: false;
      description: 'Deletes the user authentication information for the specified cloud storage provider. The next time the user tries to access the cloud storage provider, they must pass normal authentication for this cloud storage provider.';
      operationId: 'CloudStorage_DeleteCloudStorage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the service to access. \n\nValid values are the service name ("Box") or the numerical serviceId ("4136").';
          in: 'path';
          name: 'serviceId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/cloudStorageProviders';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes the user authentication information for the specified cloud storage provider.';
      tags: ['CloudStorageProviders'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteProvider';
      'x-ds-service': 'CloudStorage';
    };
    get: {
      deprecated: false;
      description: 'Retrieves the list of cloud storage providers enabled for the account and the configuration information for the user.';
      operationId: 'CloudStorage_GetCloudStorage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the service to access. \n\nValid values are the service name ("Box") or the numerical serviceId ("4136").';
          in: 'path';
          name: 'serviceId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: ' The URL the user is redirected to after the cloud storage provider authenticates the user. Using this will append the redirectUrl to the authenticationUrl.\n\nThe redirectUrl is restricted to URLs in the docusign.com or docusign.net domains.\n ';
          in: 'query';
          name: 'redirectUrl';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/cloudStorageProviders';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the specified Cloud Storage Provider configuration for the User.';
      tags: ['CloudStorageProviders'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getProvider';
      'x-ds-service': 'CloudStorage';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/users/{userId}/cloud_storage/{serviceId}/folders': {
    get: {
      deprecated: false;
      description: 'Retrieves a list of all the items in a specified folder from the specified cloud storage provider. ';
      operationId: 'CloudStorageFolder_GetCloudStorageFolderAll';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the service to access. \n\nValid values are the service name ("Box") or the numerical serviceId ("4136").';
          in: 'path';
          name: 'serviceId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A comma separated list of folder IDs included in the request. ';
          in: 'query';
          name: 'cloud_storage_folder_path';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.\n\nUse `start_position` to specify the number of results to skip.\n\nDefault: `25`\n';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The order in which to sort the results.\n\nValid values are: \n\n\n* `asc`: Ascending order.\n* `desc`: Descending order. ';
          in: 'query';
          name: 'order';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The file attribute to use to sort the results.\n\nValid values are: \n\n* `modified`\n* `name`';
          in: 'query';
          name: 'order_by';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Use this parameter to search for specific text.';
          in: 'query';
          name: 'search_text';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nUse with `count` to limit the number\nof results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/externalFolder';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieves a list of all the items in a specified folder from the specified cloud storage provider.';
      tags: ['CloudStorage'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'listFolders';
      'x-ds-methodname': 'listFolders';
      'x-ds-service': 'CloudStorage';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/users/{userId}/cloud_storage/{serviceId}/folders/{folderId}': {
    get: {
      deprecated: false;
      description: "Retrieves a list of the user's items from the specified cloud storage provider. \n\nTo limit the scope of the items returned, provide a comma-separated list of folder IDs in the request.";
      operationId: 'CloudStorageFolder_GetCloudStorageFolder';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the folder.';
          in: 'path';
          name: 'folderId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the service to access. \n\nValid values are the service name ("Box") or the numerical serviceId ("4136").';
          in: 'path';
          name: 'serviceId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The file path to a cloud storage folder.';
          in: 'query';
          name: 'cloud_storage_folder_path';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'A plain-text folder ID that you can use as an alternative to the existing folder id. This property is mainly used for rooms. Enter multiple folder IDs as a comma-separated list.';
          in: 'query';
          name: 'cloud_storage_folderid_plain';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.\n\nUse `start_position` to specify the number of results to skip.\n\nDefault: `25`\n';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The order in which to sort the results.\n\nValid values are: \n\n\n* `asc`: Ascending order.\n* `desc`: Descending order. ';
          in: 'query';
          name: 'order';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The file attribute to use to sort the results.\n\nValid values are: \n\n* `modified`\n* `name`';
          in: 'query';
          name: 'order_by';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Use this parameter to search for specific text.';
          in: 'query';
          name: 'search_text';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nUse with `count` to limit the number\nof results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/externalFolder';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a list of items from a cloud storage provider.';
      tags: ['CloudStorage'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'list';
      'x-ds-service': 'CloudStorage';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/users/{userId}/custom_settings': {
    delete: {
      deprecated: false;
      description: 'Deletes the specified custom user settings for a single user.\n\nIf the custom user settings you want to delete are grouped, you\nmust include the `X-DocuSign-User-Settings-Key` header\nin the request:\n\n`X-DocuSign-User-Settings-Key:group_name`\n\nWhere the `group_name` is your designated name for the group of\ncustomer user settings.\n\nIf the `X-DocuSign-User-Settings-Key` header is not included,\nonly the custom user settings that were added without\na group are deleted.';
      operationId: 'UserCustomSettings_DeleteCustomSettings';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/customSettingsInformation';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/customSettingsInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes custom user settings for a specified user.';
      tags: ['UserCustomSettings'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteCustomSettings';
      'x-ds-service': 'Users';
    };
    get: {
      deprecated: false;
      description: 'Retrieves a list of custom user settings for a single user.\n\nCustom settings provide a flexible way to store and retrieve\ncustom user information that can be used in your own system.\n\n**Note:** Custom user settings are not the same as user account\nsettings.\n\n\nIf the custom user settings you want to retrieve are grouped, you\nmust include the `X-DocuSign-User-Settings-Key` header\nin the request:\n\n`X-DocuSign-User-Settings-Key:group_name`\n\nWhere the `group_name` is your designated name for the group of\ncustomer user settings.\n\nIf the `X-DocuSign-User-Settings-Key` header is not included, only the custom\nuser settings that were added without a group are retrieved.';
      operationId: 'UserCustomSettings_GetCustomSettings';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/customSettingsInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieves the custom user settings for a specified user.';
      tags: ['UserCustomSettings'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listCustomSettings';
      'x-ds-service': 'Users';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Adds or updates custom user settings for the specified user.\n\n**Note:** Custom user settings are not the same as user account\nsettings.\n\nCustom settings provide a flexible way to store and retrieve\ncustom user information that you can use in your own system.\n\n**Important:** There is a limit on the size for all the custom\nuser settings for a single user. The limit is 4,000 characters,\nwhich includes the XML and JSON structure for the settings.\n\nYou can group custom user settings when adding them. Grouping\nallows you to retrieve settings that are in a specific group,\ninstead of retrieving all the user custom settings.\n\nTo group custom user settings, include the\n`X-DocuSign-User-Settings-Key` header in the request:\n\n`X-DocuSign-User-Settings-Key:group_name`\n\nWhere the `group_name` is your designated name for the group of\ncustomer user settings.\n\nWhen getting or deleting grouped custom user settings, you must\ninclude the `X-DocuSign-User-Settings-Key` header information.\n\nGrouping custom user settings is not required and if the `X-DocuSign-User-Settings-Key`\nheader information is not included, the custom user settings are\nadded normally and can be retrieved or deleted without including\nthe `X-DocuSign-User-Settings-Key` header.\n';
      operationId: 'UserCustomSettings_PutCustomSettings';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/customSettingsInformation';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/customSettingsInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds or updates custom user settings for the specified user.';
      tags: ['UserCustomSettings'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateCustomSettings';
      'x-ds-service': 'Users';
    };
  };
  '/v2.1/accounts/{accountId}/users/{userId}/profile': {
    get: {
      deprecated: false;
      description: "Retrieves the user profile information, the privacy settings and personal information (address, phone number, etc.) for the specified user.\n\nThe userId parameter specified in the endpoint must match the authenticated user's user ID and the user must be a member of the specified account.";
      operationId: 'UserProfile_GetProfile';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userProfile';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieves the user profile for a specified user.';
      tags: ['UserProfiles'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getProfile';
      'x-ds-service': 'Users';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: "Updates the user's detail information, profile information, privacy settings, and personal information in the user ID card.\n\nYou can also change a user's name by changing the information in the `userDetails` property. When changing a user's name, you can either change the information in the `userName` property OR change the information in `firstName`, `middleName`, `lastName, suffixName`, and `title` properties. Changes to `firstName`, `middleName`, `lastName`, `suffixName`, and `title` properties take precedence over changes to the `userName` property.";
      operationId: 'UserProfile_PutProfile';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/userProfile';
            };
          };
        };
      };
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the user profile information for the specified user.';
      tags: ['UserProfiles'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateProfile';
      'x-ds-service': 'Users';
    };
  };
  '/v2.1/accounts/{accountId}/users/{userId}/profile/image': {
    delete: {
      deprecated: false;
      description: "Deletes the user profile image from the  specified user's profile.\n\nThe userId parameter specified in the endpoint must match the authenticated user's user ID and the user must be a member of the specified account.";
      operationId: 'UserProfileImage_DeleteUserProfileImage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes the user profile image for the specified user.';
      tags: ['Users'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteProfileImage';
      'x-ds-methodname': 'deleteProfileImage';
      'x-ds-service': 'Users';
    };
    get: {
      deprecated: false;
      description: "Retrieves the user profile picture for the specified user.\n\nThe `userId` path parameter must match the authenticated user's user ID,\nand the user must be a member of the specified account.\n\n| Return value      | Meaning                                                                        |\n| :---------------- | :----------------------------------------------------------------------------- |\n| `200 OK`          | The response contains the profile image in the same format as it was uploaded. |\n| `404 Not found`   | The user does not have a profile image.                                        |\n| `400 Bad request` | There was an error in the request. The response has more information.          |\n";
      operationId: 'UserProfileImage_GetUserProfileImage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Reserved for DocuSign.';
          in: 'query';
          name: 'encoding';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'image/gif': {
              schema: {
                format: 'binary';
                type: 'string';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            'image/gif': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieves the user profile image for the specified user.';
      tags: ['Users'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getProfileImage';
      'x-ds-methodname': 'getProfileImage';
      'x-ds-service': 'Users';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Updates the user profile image by uploading an image to the user profile.\n\nThe supported image formats are: gif, png, jpeg, and bmp. The file must be less than 200K. For best viewing results, DocuSign recommends that the image is no more than 79 pixels wide and high.';
      operationId: 'UserProfileImage_PutUserProfileImage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the user profile image for a specified user.';
      tags: ['Users'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateProfileImage';
      'x-ds-methodname': 'updateProfileImage';
      'x-ds-service': 'Users';
    };
  };
  '/v2.1/accounts/{accountId}/users/{userId}/settings': {
    get: {
      deprecated: false;
      description: 'Retrieves a list of the account settings and email\nnotification information for the specified user.\n\nThe response returns the account setting\nname/value information and the email notification\nsettings for the specified user. For more\ninformation, see\n[Users:create](/docs/esign-rest-api/reference/users/users/create/).\n\n\n';
      operationId: 'UserSettings_GetUserSettings';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userSettingsInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the user account settings for a specified user.';
      tags: ['Users'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getSettings';
      'x-ds-methodname': 'getSettings';
      'x-ds-service': 'Users';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Updates the account settings list and email notification types for the specified user.';
      operationId: 'UserSettings_PutUserSettings';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'allow_all_languages';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/userSettingsInformation';
            };
          };
        };
      };
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the user account settings for a specified user.';
      tags: ['Users'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateSettings';
      'x-ds-methodname': 'updateSettings';
      'x-ds-service': 'Users';
    };
  };
  '/v2.1/accounts/{accountId}/users/{userId}/signatures': {
    get: {
      deprecated: false;
      description: 'This method retrieves the signature definitions for the user that you specify.\n\nThe `userId` parameter specified in the endpoint must match the authenticated user\'s user ID, and the user must be a member of the account.\n\nThe `signatureId` parameter accepts a signature ID or a signature name. DocuSign recommends you use signature ID (`signatureId`), since some names contain characters that do not properly encode into a URL. If you use the user name, it is likely that the name includes spaces. In that case, URL encode the name before using it in the endpoint. \n\nFor example, encode "Bob Smith" as "Bob%20Smith".';
      operationId: 'UserSignatures_GetUserSignatures';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The type of stamps to return. Valid values are:\n\n- `signature`: Returns information about signature images only. This is the default value.\n- `stamp`: Returns information about eHanko and custom stamps only.\n- null';
          in: 'query';
          name: 'stamp_type';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userSignaturesInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieves a list of signature definitions for a user.';
      tags: ['UserSignatures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listSignatures';
      'x-ds-service': 'Users';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Adds a user signature image and/or user initials image to the specified user. \n\nThe userId property specified in the endpoint must match the authenticated user\'s `userId` and the user must be a member of the account.\n\nThe rules and processes associated with this are:\n\n* If `Content-Type` is set to `application/json`, then the default behavior for creating a default signature image, based on the name and a DocuSign font, is used.\n* If `Content-Type` is set to `multipart/form-data`, then the request must contain a first part with the user signature information, followed by parts that contain the images.\n\nFor each Image part, the Content-Disposition header has a "filename" value that is used to map to the `signatureName` and/or `signatureInitials` properties in the JSON to the image. \n\nFor example: \n`Content-Disposition: file; filename="Ron Test20121127083900"`\n\nIf no matching image (by filename value) is found, then the image is not set. One, both, or neither of the signature and initials images can be set with this call.\n\nThe Content-Transfer-Encoding: base64 header, set in the header for the part containing the image, can be set to indicate that the images are formatted as base64 instead of as binary.\n\nIf successful, 200-OK is returned, and a JSON structure containing the signature information is provided, note that the signatureId can change with each API POST, PUT, or DELETE since the changes to the signature structure cause the current signature to be closed, and a new signature record to be created.';
      operationId: 'UserSignatures_PostUserSignatures';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/userSignaturesInformation';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userSignaturesInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds user Signature and initials images to a Signature.';
      tags: ['UserSignatures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createSignatures';
      'x-ds-service': 'Users';
    };
    put: {
      deprecated: false;
      description: '';
      operationId: 'UserSignatures_PutUserSignature';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/userSignaturesInformation';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userSignaturesInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Adds/updates a user signature.';
      tags: ['UserSignatures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateList';
      'x-ds-methodname': 'updateSignatures';
      'x-ds-service': 'Users';
    };
  };
  '/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}': {
    delete: {
      deprecated: false;
      description: 'Removes the signature information for the user.\n\nThe userId parameter specified in the endpoint must match the authenticated user\'s user ID and the user must be a member of the account.\n\nThe `signatureId` accepts a signature ID or a signature name. DocuSign recommends you use signature ID (`signatureId`), since some names contain characters that do not properly encode into a URL. If you use the user name, it is likely that the name includes spaces. In that case, URL encode the name before using it in the endpoint. \n\nFor example encode "Bob Smith" as "Bob%20Smith".';
      operationId: 'UserSignatures_DeleteUserSignature';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the account stamp.';
          in: 'path';
          name: 'signatureId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Removes removes signature information for the specified user.';
      tags: ['UserSignatures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteSignature';
      'x-ds-service': 'Users';
    };
    get: {
      deprecated: false;
      description: 'Retrieves the structure of a single signature with a known signature name.\n\nThe userId specified in the endpoint must match the authenticated user\'s user ID and the user must be a member of the account.\n\nThe `signatureId` parameter accepts a signature ID or a signature name. DocuSign recommends you use signature ID (`signatureId`), since some names contain characters that do not properly encode into a URL. If you use the user name, it is likely that the name includes spaces. In that case, URL encode the name before using it in the endpoint. \n\nFor example encode "Bob Smith" as "Bob%20Smith".';
      operationId: 'UserSignatures_GetUserSignature';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the account stamp.';
          in: 'path';
          name: 'signatureId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userSignature';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the user signature information for the specified user.';
      tags: ['UserSignatures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getSignature';
      'x-ds-service': 'Users';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Creates, or updates, the signature font and initials for the specified user. When creating a signature, you use this resource to create the signature name and then add the signature and initials images into the signature.\n\n**Note:** This will also create a default signature for the user when one does not exist.\n\nThe userId property specified in the endpoint must match the authenticated user\'s user ID and the user must be a member of the account.\n\nThe `signatureId` parameter accepts a signature ID. DocuSign recommends you use signature ID (`signatureId`), since some names contain characters that do not properly encode into a URL. If you use the user name, it is likely that the name includes spaces. In that case, URL encode the name before using it in the endpoint.\n\nFor example encode "Bob Smith" as "Bob%20Smith".';
      operationId: 'UserSignatures_PutUserSignatureById';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the account stamp.';
          in: 'path';
          name: 'signatureId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** closes the current signature.';
          in: 'query';
          name: 'close_existing_signature';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/userSignatureDefinition';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userSignature';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the user signature for a specified user.';
      tags: ['UserSignatures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateSignature';
      'x-ds-service': 'Users';
    };
  };
  '/v2.1/accounts/{accountId}/users/{userId}/signatures/{signatureId}/{imageType}': {
    delete: {
      deprecated: false;
      description: 'Deletes the specified initials image or signature image for the specified user.\n\nThe function deletes one or the other of the image types, to delete both the initials image and signature image you must call the endpoint twice.\n\nThe userId parameter specified in the endpoint must match the authenticated user\'s user ID and the user must be a member of the account.\n\nThe `signatureId` parameter accepts a signature ID or a signature name. DocuSign recommends you use signature ID (`signatureId`), since some names contain characters that do not properly encode into a URL. If you use the user name, it is likely that the name includes spaces. In that case, URL encode the name before using it in the endpoint. \n\nFor example encode "Bob Smith" as "Bob%20Smith".';
      operationId: 'UserSignatures_DeleteUserSignatureImage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specificies the type of image. Valid values:\n\n- `stamp_image`\n- `signature_image`\n- `initials_image`';
          in: 'path';
          name: 'imageType';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the account stamp.';
          in: 'path';
          name: 'signatureId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userSignature';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes the user initials image or the  user signature image for the specified user.';
      tags: ['UserSignatures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteImage';
      'x-ds-methodname': 'deleteSignatureImage';
      'x-ds-service': 'Users';
    };
    get: {
      deprecated: false;
      description: 'Retrieves the specified initials image or signature image for the specified user. The image is returned in the same format in which it was uploaded. In the request you can specify if the chrome (the added line and identifier around the initial image) is returned with the image.\n\nThe userId property specified in the endpoint must match the authenticated user\'s user ID and the user must be a member of the account.\n\nThe `signatureId` parameter accepts a signature ID or a signature name. DocuSign recommends you use signature ID (`signatureId`), since some names contain characters that do not properly encode into a URL. If you use the user name, it is likely that the name includes spaces. In that case, URL encode the name before using it in the endpoint.\n\nFor example encode "Bob Smith" as "Bob%20Smith".\n\n**Note:** Older envelopes might only have chromed images. If getting the non-chromed image fails, try getting the chromed image.';
      operationId: 'UserSignatures_GetUserSignatureImage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specificies the type of image. Valid values:\n\n- `stamp_image`\n- `signature_image`\n- `initials_image`';
          in: 'path';
          name: 'imageType';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the account stamp.';
          in: 'path';
          name: 'signatureId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the chrome (or frame containing the added line and identifier) is included with the signature image.';
          in: 'query';
          name: 'include_chrome';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'image/gif': {
              schema: {
                format: 'binary';
                type: 'string';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            'image/gif': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Retrieves the user initials image or the  user signature image for the specified user.';
      tags: ['UserSignatures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getImage';
      'x-ds-methodname': 'getSignatureImage';
      'x-ds-service': 'Users';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Updates the user signature image or user initials image for the specified user. The supported image formats for this file are: gif, png, jpeg, and bmp. The file must be less than 200K.\n\nThe userId property specified in the endpoint must match the authenticated user\'s user ID and the user must be a member of the account.\n\nThe `signatureId` parameter accepts a signature ID or a signature name. DocuSign recommends you use signature ID (`signatureId`), since some names contain characters that do not properly encode into a URL. If you use the user name, it is likely that the name includes spaces. In that case, URL encode the name before using it in the endpoint. \n\nFor example encode "Bob Smith" as "Bob%20Smith".\n';
      operationId: 'UserSignatures_PutUserSignatureImage';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Specificies the type of image. Valid values:\n\n- `stamp_image`\n- `signature_image`\n- `initials_image`';
          in: 'path';
          name: 'imageType';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the account stamp.';
          in: 'path';
          name: 'signatureId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: "The ID of the user to access.\n\n**Note:** Users can only access their own information. A user, even one with Admin rights, cannot access another user's settings.";
          in: 'path';
          name: 'userId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: '';
          in: 'query';
          name: 'transparent_png';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userSignature';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the user signature image or user initials image for the specified user.';
      tags: ['UserSignatures'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateImage';
      'x-ds-methodname': 'updateSignatureImage';
      'x-ds-service': 'Users';
    };
  };
  '/v2.1/accounts/{accountId}/views/console': {
    parameters: [];
    post: {
      deprecated: false;
      description: 'Returns a URL that enables you to embed the DocuSign UI in your applications. To view a specific envelope, set the `envelopeId` property in the request body.\n\n### Revoking the URL\n\nYou can revoke this URL by making a HTTP DELETE request to the URL with no request body.\n\n## Information security notice\n\nThis method provides full access to the sending account.\n\n### Related topics\n\n- [How to embed the DocuSign UI in your app](/docs/esign-rest-api/how-to/embed-ui/)\n';
      operationId: 'Views_PostAccountConsoleView';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/consoleViewRequest';
            };
          };
        };
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/EnvelopeViews';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns a URL to the DocuSign UI.';
      tags: ['EnvelopeViews'];
      'x-ds-examples': [
        {
          description: "The response contains the URL\nof the account's console.\n\nThe request body contains\na `returnUrl`.\nThis is the URL\nthat the DocuSign platform\nwill redirect the user to\nwhen the view is closed.\n\n";
          direction: 'both';
          format: 'json';
          request: {
            returnUrl: 'https://dsapp.example.com/return/from/console/view';
          };
          response: {
            url: 'https://demo.docusign.net/Member/StartInSession.aspx?StartConsole=1&t=644ea697-xxxx-xxxx-xxxx-d95a5c23340b&accountid=624e3e00-xxxx-xxxx-xxxx-43918c520dab';
          };
          style: 'custom';
          title: 'Getting a Console View URL and Setting a Return URL';
        },
      ];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createConsole';
      'x-ds-methodname': 'createConsoleView';
      'x-ds-service': 'Envelopes';
    };
  };
  '/v2.1/accounts/{accountId}/watermark': {
    get: {
      deprecated: false;
      description: 'Enables you to preview a watermark specified by the request.';
      operationId: 'Watermark_GetWatermark';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/watermark';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Get watermark information.';
      tags: ['AccountWatermarks'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getWatermark';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Returns information about the watermark for the account.';
      operationId: 'Watermark_PutWatermark';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/watermark';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/watermark';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Update watermark information.';
      tags: ['AccountWatermarks'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateWatermark';
      'x-ds-service': 'Accounts';
    };
  };
  '/v2.1/accounts/{accountId}/watermark/preview': {
    parameters: [];
    put: {
      deprecated: false;
      description: 'Update the watermark for the account.\n\n**Note:** Many of the request fields must be set to specific values. If you use an invalid value for one of these fields, the endpoint may return 200 OK but set the field to a default value. See the request body for more information.';
      operationId: 'WatermarkPreview_PutWatermarkPreview';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/watermark';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/watermark';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Get watermark preview.';
      tags: ['AccountWatermarks'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'preview';
      'x-ds-methodname': 'getWatermarkPreview';
      'x-ds-service': 'Accounts';
    };
  };
  '/v2.1/accounts/{accountId}/workspaces': {
    get: {
      deprecated: false;
      description: 'Gets information about the Workspaces that have been created.';
      operationId: 'Workspace_GetWorkspaces';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/workspaceList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'List Workspaces';
      tags: ['Workspaces'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listWorkspaces';
      'x-ds-service': 'Workspaces';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'This method creates a new workspace.';
      operationId: 'Workspace_PostWorkspace';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/workspace';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/workspace';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Create a Workspace';
      tags: ['Workspaces'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'create';
      'x-ds-methodname': 'createWorkspace';
      'x-ds-service': 'Workspaces';
    };
  };
  '/v2.1/accounts/{accountId}/workspaces/{workspaceId}': {
    delete: {
      deprecated: false;
      description: 'Deletes an existing workspace (logically).';
      operationId: 'Workspace_DeleteWorkspace';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workspace.';
          in: 'path';
          name: 'workspaceId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/workspace';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Delete Workspace';
      tags: ['Workspaces'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteWorkspace';
      'x-ds-service': 'Workspaces';
    };
    get: {
      deprecated: false;
      description: 'Retrieves properties about a workspace given a unique workspaceId. ';
      operationId: 'Workspace_GetWorkspace';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workspace.';
          in: 'path';
          name: 'workspaceId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/workspace';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Get Workspace';
      tags: ['Workspaces'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getWorkspace';
      'x-ds-service': 'Workspaces';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Updates information about a specific workspace.';
      operationId: 'Workspace_PutWorkspace';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workspace.';
          in: 'path';
          name: 'workspaceId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/workspace';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/workspace';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Update Workspace';
      tags: ['Workspaces'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'update';
      'x-ds-methodname': 'updateWorkspace';
      'x-ds-service': 'Workspaces';
    };
  };
  '/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}': {
    delete: {
      deprecated: false;
      description: 'This method deletes one or more files or sub-folders from a workspace folder or root.\n\nNote: To delete items from a workspace, the `status` of the workspace must be `active`.';
      operationId: 'WorkspaceFolder_DeleteWorkspaceItems';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the folder.';
          in: 'path';
          name: 'folderId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workspace.';
          in: 'path';
          name: 'workspaceId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/workspaceItemList';
            };
          };
        };
      };
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes files or sub-folders from a workspace.';
      tags: ['WorkspaceItems'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteFolderItems';
      'x-ds-methodname': 'deleteWorkspaceFolderItems';
      'x-ds-service': 'Workspaces';
    };
    get: {
      deprecated: false;
      description: 'This method returns the contents of a workspace folder, which can include sub-folders and files.';
      operationId: 'WorkspaceFolder_GetWorkspaceFolder';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the folder.';
          in: 'path';
          name: 'folderId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workspace.';
          in: 'path';
          name: 'workspaceId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.\n\nUse `start_position` to specify the number of results to skip.\n';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the response includes file information (in addition to folder information). The default is **false.**';
          in: 'query';
          name: 'include_files';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the response includes information about the sub-folders of the current folder. The default is **false.**';
          in: 'query';
          name: 'include_sub_folders';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the response returns thumbnails.  The default is **false.**';
          in: 'query';
          name: 'include_thumbnails';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the response includes extended details about the user. The default is **false.**';
          in: 'query';
          name: 'include_user_detail';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nUse with `count` to limit the number\nof results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'If set, the response only includes results associated with the `userId` that you specify.';
          in: 'query';
          name: 'workspace_user_id';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/workspaceFolderContents';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'List workspace folder contents';
      tags: ['WorkspaceItems'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'listFolderItems';
      'x-ds-methodname': 'listWorkspaceFolderItems';
      'x-ds-service': 'Workspaces';
    };
    parameters: [];
  };
  '/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files': {
    parameters: [];
    post: {
      deprecated: false;
      description: 'This method adds a file to a workspace.';
      operationId: 'WorkspaceFile_PostWorkspaceFiles';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the folder.';
          in: 'path';
          name: 'folderId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workspace.';
          in: 'path';
          name: 'workspaceId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/workspaceItem';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates a workspace file.';
      tags: ['WorkspaceItems'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createFIle';
      'x-ds-methodname': 'createWorkspaceFile';
      'x-ds-service': 'Workspaces';
    };
  };
  '/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}': {
    get: {
      deprecated: false;
      description: 'This method returns a binary version of a file in a workspace.';
      operationId: 'WorkspaceFile_GetWorkspaceFile';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the file.';
          in: 'path';
          name: 'fileId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the folder.';
          in: 'path';
          name: 'folderId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workspace.';
          in: 'path';
          name: 'workspaceId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true,** the `Content-Disposition` header is set in the response. The value of the header provides the filename of the file. The default is **false.**';
          in: 'query';
          name: 'is_download';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'When **true** the file is returned in PDF format.';
          in: 'query';
          name: 'pdf_version';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a workspace file';
      tags: ['WorkspaceItems'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getFile';
      'x-ds-methodname': 'getWorkspaceFile';
      'x-ds-service': 'Workspaces';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'This method updates the metadata for one or more specific files or folders in a workspace.';
      operationId: 'WorkspaceFile_PutWorkspaceFile';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the file.';
          in: 'path';
          name: 'fileId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the folder.';
          in: 'path';
          name: 'folderId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workspace.';
          in: 'path';
          name: 'workspaceId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/workspaceItem';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Update workspace file or folder metadata';
      tags: ['WorkspaceItems'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateFile';
      'x-ds-methodname': 'updateWorkspaceFile';
      'x-ds-service': 'Workspaces';
    };
  };
  '/v2.1/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}/pages': {
    get: {
      deprecated: false;
      description: 'This method returns a workspace file as rasterized pages.';
      operationId: 'WorkspaceFilePages_GetWorkspaceFilePages';
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.';
          in: 'path';
          name: 'accountId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the file.';
          in: 'path';
          name: 'fileId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the folder.';
          in: 'path';
          name: 'folderId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The ID of the workspace.';
          in: 'path';
          name: 'workspaceId';
          required: true;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The maximum number of results to return.\n\nUse `start_position` to specify the number of results to skip.\n';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The number of dots per inch (DPI) for the resulting images. Valid values are 1-310 DPI. The default value is 94.';
          in: 'query';
          name: 'dpi';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Sets the maximum height of the returned images in pixels.';
          in: 'query';
          name: 'max_height';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Sets the maximum width of the returned images in pixels.';
          in: 'query';
          name: 'max_width';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The zero-based index of the\nresult from which to start returning results.\n\nUse with `count` to limit the number\nof results.\n\nThe default value is `0`.\n';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/pageImages';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'List File Pages';
      tags: ['WorkspaceItems'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'listFilePages';
      'x-ds-methodname': 'listWorkspaceFilePages';
      'x-ds-service': 'Workspaces';
    };
    parameters: [];
  };
  '/v2.1/billing_plans': {
    get: {
      deprecated: false;
      description: 'Retrieves a list of the billing plans associated with a distributor.';
      operationId: 'BillingPlans_GetBillingPlans';
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/billingPlansResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a list of available billing plans.';
      tags: ['BillingPlans'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listBillingPlans';
      'x-ds-service': 'Billing';
    };
    parameters: [];
  };
  '/v2.1/billing_plans/{billingPlanId}': {
    get: {
      deprecated: false;
      description: 'Retrieves the billing plan details for the specified billing plan ID.';
      operationId: 'BillingPlans_GetBillingPlan';
      parameters: [
        {
          description: 'The ID of the billing plan being accessed.';
          in: 'path';
          name: 'billingPlanId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/billingPlanResponse';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets billing plan details.';
      tags: ['BillingPlans'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getBillingPlan';
      'x-ds-service': 'Billing';
    };
    parameters: [];
  };
  '/v2.1/current_user/notary': {
    get: {
      deprecated: false;
      description: 'Gets settings for a notary user.\nThe current user must be a notary.';
      operationId: 'Notary_GetNotary';
      parameters: [
        {
          description: 'When **true,** the response will include a `jurisdiction` property that contains an array of all supported jurisdictions for the current user.';
          in: 'query';
          name: 'include_jurisdictions';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/notaryResult';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets settings for a  notary user.';
      tags: ['Notary'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getNotary';
      'x-ds-methodname': 'getNotary';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Registers the current user as a notary.';
      operationId: 'Notary_PostNotary';
      requestBody: {
        $ref: '#/components/requestBodies/notary';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/notary';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Registers the current user as a notary.';
      tags: ['Notary'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createNotary';
      'x-ds-methodname': 'createNotary';
      'x-ds-service': 'Uncategorized';
    };
    put: {
      deprecated: false;
      description: 'Updates notary information for the current user.';
      operationId: 'Notary_PutNotary';
      requestBody: {
        $ref: '#/components/requestBodies/notary';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/notary';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates notary information for the current user.';
      tags: ['Notary'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateNotary';
      'x-ds-methodname': 'updateNotary';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/current_user/notary/journals': {
    get: {
      deprecated: false;
      description: '';
      operationId: 'NotaryJournals_GetNotaryJournals';
      parameters: [
        {
          description: 'The maximum number of results to return.';
          in: 'query';
          name: 'count';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'Use this parameter to search for specific text.';
          in: 'query';
          name: 'search_text';
          required: false;
          schema: {
            type: 'string';
          };
        },
        {
          description: 'The position within the total result set from which to start returning values. The value **thumbnail** may be used to return the page image.';
          in: 'query';
          name: 'start_position';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/notaryJournalList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets notary jurisdictions for a user.';
      tags: ['NotaryJournals'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listNotaryJournals';
      'x-ds-service': 'Notary';
    };
    parameters: [];
  };
  '/v2.1/current_user/notary/jurisdictions': {
    get: {
      deprecated: false;
      description: 'Returns a list of jurisdictions that the notary is registered in.\nThe current user must be a notary.';
      operationId: 'NotaryJurisdictions_GetNotaryJurisdictions';
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/notaryJurisdictionList';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Returns a list of jurisdictions that the notary is registered in.';
      tags: ['NotaryJurisdiction'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getNotaryJurisdictions';
      'x-ds-methodname': 'getNotaryJurisdictions';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    post: {
      deprecated: false;
      description: 'Creates a jurisdiction object.';
      operationId: 'NotaryJurisdictions_PostNotaryJurisdictions';
      requestBody: {
        $ref: '#/components/requestBodies/notaryJurisdiction';
      };
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/notaryJurisdiction';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Creates a jurisdiction object.';
      tags: ['NotaryJurisdiction'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'createNotaryJurisdictions';
      'x-ds-methodname': 'createNotaryJurisdictions';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/current_user/notary/jurisdictions/{jurisdictionId}': {
    delete: {
      deprecated: false;
      description: 'Deletes the specified jurisdiction.';
      operationId: 'NotaryJurisdictions_DeleteNotaryJurisdiction';
      parameters: [
        {
          description: 'The ID of the jurisdiction.\nThe following jurisdictions\nare supported:\n\n-  `5 - California`\n-  `6 - Colorado`\n-  `9 - Florida`\n-  `10 - Georgia`\n-  `12 - Idaho`\n-  `13 - Illinois`\n-  `14 - Indiana`\n-  `15 - Iowa`\n-  `17 - Kentucky`\n-  `23 - Minnesota`\n-  `25 - Missouri`\n-  `30 - New Jersey`\n-  `32 - New York`\n-  `33 - North Carolina`\n-  `35 - Ohio`\n-  `37 - Oregon`\n-  `38 - Pennsylvania`\n-  `40 - South Carolina`\n-  `43 - Texas`\n-  `44 - Utah`\n-  `47 - Washington`\n-  `48 - West Virginia`\n-  `49 - Wisconsin`\n-  `62 - Florida Commissioner of Deeds`\n';
          in: 'path';
          name: 'jurisdictionId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes the specified jurisdiction.';
      tags: ['NotaryJurisdiction'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'deleteNotaryJurisdiction';
      'x-ds-methodname': 'deleteNotaryJurisdiction';
      'x-ds-service': 'Uncategorized';
    };
    get: {
      deprecated: false;
      description: 'Gets a jurisdiction object for the current user.  The following restrictions apply:\n\n- The current user must be a notary.\n- The `jurisdictionId` must be a jurisdiction that the notary is registered for.\n';
      operationId: 'NotaryJurisdictions_GetNotaryJurisdiction';
      parameters: [
        {
          description: 'The ID of the jurisdiction.\nThe following jurisdictions\nare supported:\n\n-  `5 - California`\n-  `6 - Colorado`\n-  `9 - Florida`\n-  `10 - Georgia`\n-  `12 - Idaho`\n-  `13 - Illinois`\n-  `14 - Indiana`\n-  `15 - Iowa`\n-  `17 - Kentucky`\n-  `23 - Minnesota`\n-  `25 - Missouri`\n-  `30 - New Jersey`\n-  `32 - New York`\n-  `33 - North Carolina`\n-  `35 - Ohio`\n-  `37 - Oregon`\n-  `38 - Pennsylvania`\n-  `40 - South Carolina`\n-  `43 - Texas`\n-  `44 - Utah`\n-  `47 - Washington`\n-  `48 - West Virginia`\n-  `49 - Wisconsin`\n-  `62 - Florida Commissioner of Deeds`\n';
          in: 'path';
          name: 'jurisdictionId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/notaryJurisdiction';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a jurisdiction object for the current user. The user must be a notary.';
      tags: ['NotaryJurisdiction'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getNotaryJurisdiction';
      'x-ds-methodname': 'getNotaryJurisdiction';
      'x-ds-service': 'Uncategorized';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Updates the jurisdiction information about a notary.\n\nThe following restrictions apply:\n\n- The current user must be a notary.\n- The `jurisdictionId` path parameter must be a jurisdiction that the notary is registered for.\n- The `jurisdictionId` path parameter must match the request body\'s `jurisdiction.jurisdictionId`.\n\nThe request body must have a full `jurisdiction` object for the jurisdiction property.\nThe best way to do this is to use `getNotaryJurisdiction` to obtain the current values and update the properties you want to change.\n\nFor example, assume `getNotaryJurisdiction` returns this:\n\n```\n{\n    "jurisdiction": {\n        "jurisdictionId": "15",\n        "name": "Iowa",\n        "county": "",\n        "enabled": "true",\n        "countyInSeal": "false",\n        "commissionIdInSeal": "true",\n        "stateNameInSeal": "true",\n        "notaryPublicInSeal": "true",\n        "allowSystemCreatedSeal": "true",\n        "allowUserUploadedSeal": "false"\n    },\n    "commissionId": "123456",\n    "commissionExpiration": "2020-08-31T07:00:00.0000000Z",\n    "registeredName": "Bob Notary",\n    "county": "Adams",\n    "sealType": "system_created"\n}\n```\n\nIf you want to change the name of the notary from "Bob Notary" to "Robert Notary", your request body would be:\n\n```\n{\n    "jurisdiction": {\n        "jurisdictionId": "15",\n        "name": "Iowa",\n        "county": "",\n        "enabled": "true",\n        "countyInSeal": "false",\n        "commissionIdInSeal": "true",\n        "stateNameInSeal": "true",\n        "notaryPublicInSeal": "true",\n        "allowSystemCreatedSeal": "true",\n        "allowUserUploadedSeal": "false"\n    },\n    "commissionId": "123456",\n    "commissionExpiration": "2020-08-31T07:00:00.0000000Z",\n    "registeredName": "Robert Notary",\n    "county": "Adams",\n    "sealType": "system_created"\n}\n```\n';
      operationId: 'NotaryJurisdictions_PutNotaryJurisdiction';
      parameters: [
        {
          description: 'The ID of the jurisdiction.\nThe following jurisdictions\nare supported:\n\n-  `5 - California`\n-  `6 - Colorado`\n-  `9 - Florida`\n-  `10 - Georgia`\n-  `12 - Idaho`\n-  `13 - Illinois`\n-  `14 - Indiana`\n-  `15 - Iowa`\n-  `17 - Kentucky`\n-  `23 - Minnesota`\n-  `25 - Missouri`\n-  `30 - New Jersey`\n-  `32 - New York`\n-  `33 - North Carolina`\n-  `35 - Ohio`\n-  `37 - Oregon`\n-  `38 - Pennsylvania`\n-  `40 - South Carolina`\n-  `43 - Texas`\n-  `44 - Utah`\n-  `47 - Washington`\n-  `48 - West Virginia`\n-  `49 - Wisconsin`\n-  `62 - Florida Commissioner of Deeds`\n';
          in: 'path';
          name: 'jurisdictionId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      requestBody: {
        $ref: '#/components/requestBodies/notaryJurisdiction';
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/notaryJurisdiction';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Updates the jurisdiction information about a notary.';
      tags: ['NotaryJurisdiction'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateNotaryJurisdiction';
      'x-ds-methodname': 'updateNotaryJurisdiction';
      'x-ds-service': 'Uncategorized';
    };
  };
  '/v2.1/current_user/password_rules': {
    get: {
      deprecated: false;
      description: '';
      operationId: 'PasswordRules_GetPasswordRules';
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/userPasswordRules';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets membership account password rules.';
      tags: ['AccountPasswordRules'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getForUser';
      'x-ds-methodname': 'getPasswordRules';
      'x-ds-service': 'Accounts';
    };
    parameters: [];
  };
  '/v2.1/diagnostics/request_logs': {
    delete: {
      deprecated: false;
      description: 'Deletes the request log files.';
      operationId: 'APIRequestLog_DeleteRequestLogs';
      responses: {
        '200': {
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Deletes the request log files.';
      tags: ['RequestLogs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'delete';
      'x-ds-methodname': 'deleteRequestLogs';
      'x-ds-service': 'Diagnostics';
    };
    get: {
      deprecated: false;
      description: 'Retrieves a list of log entries as a JSON or XML object or as a zip file containing the entries.\n\nIf the Accept header is set to `application/zip`, the response is a zip file containing individual text files, each representing an API request.\n\nIf the Accept header is set to `application/json` or `application/xml`, the response returns list of log entries in either JSON or XML. An example JSON response body is shown below. ';
      operationId: 'APIRequestLog_GetRequestLogs';
      parameters: [
        {
          description: 'Reserved for DocuSign.';
          in: 'query';
          name: 'encoding';
          required: false;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/apiRequestLogsResult';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the API request logging log files.';
      tags: ['RequestLogs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'list';
      'x-ds-methodname': 'listRequestLogs';
      'x-ds-service': 'Diagnostics';
    };
    parameters: [];
  };
  '/v2.1/diagnostics/request_logs/{requestLogId}': {
    get: {
      deprecated: false;
      description: 'Retrieves information for a single log entry.\n\n**Request**\nThe `requestLogId` property can be retrieved by getting the list of log entries. The Content-Transfer-Encoding header can be set to base64 to retrieve the API request/response as base 64 string. Otherwise the bytes of the request/response are returned.\n\n**Response**\nIf the Content-Transfer-Encoding header was set to base64, the log is returned as a base64 string.';
      operationId: 'APIRequestLog_GetRequestLog';
      parameters: [
        {
          description: 'The ID of the log entry.';
          in: 'path';
          name: 'requestLogId';
          required: true;
          schema: {
            type: 'string';
          };
        },
      ];
      responses: {
        '200': {
          content: {
            'text/plain': {
              schema: {
                format: 'binary';
                type: 'string';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            'text/plain': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets a request logging log file.';
      tags: ['RequestLogs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'get';
      'x-ds-methodname': 'getRequestLog';
      'x-ds-service': 'Diagnostics';
    };
    parameters: [];
  };
  '/v2.1/diagnostics/settings': {
    get: {
      deprecated: false;
      description: 'Retrieves the current API request logging setting for the user and remaining log entries.\n\n**Response**\nThe response includes the current API request logging setting for the user, along with the maximum log entries and remaining log entries.';
      operationId: 'APIRequestLog_GetRequestLogSettings';
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/diagnosticsSettingsInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Gets the API request logging settings.';
      tags: ['RequestLogs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'getSettings';
      'x-ds-methodname': 'getRequestLogSettings';
      'x-ds-service': 'Diagnostics';
    };
    parameters: [];
    put: {
      deprecated: false;
      description: 'Enables or disables API request logging for troubleshooting.\n\nWhen enabled (`apiRequestLogging` is **true**),\nREST API requests and responses for the user are added to a log.\nA log can have up to 50 requests/responses\nand the current number of log entries can be determined\nby getting the settings.\nLogging is automatically disabled when the log limit of 50 is reached.\n\nYou can call\n[Diagnostics: getRequestLog](/docs/esign-rest-api/reference/diagnostics/requestlogs/get/)\nor\n[Diagnostics: listRequestLogs](/docs/esign-rest-api/reference/diagnostics/requestlogs/list/)\nto download the log files (individually or as a zip file).\nCall [Diagnostics: deleteRequestLogs](/docs/esign-rest-api/reference/diagnostics/requestlogs/delete/)\nto clear the log by deleting current entries.\n\nPrivate information, such as passwords and integration key information,\nwhich is normally located in the call header is omitted from the request/response log.\n\nAPI request logging only captures requests from the authenticated user.\nAny call that does not authenticate the user and resolve a userId is not logged.\n';
      operationId: 'APIRequestLog_PutRequestLogSettings';
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/diagnosticsSettingsInformation';
            };
          };
        };
      };
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/diagnosticsSettingsInformation';
              };
            };
          };
          description: 'Successful response.';
        };
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails';
              };
            };
          };
          description: 'Error encountered.';
        };
      };
      summary: 'Enables or disables API request logging for troubleshooting.';
      tags: ['RequestLogs'];
      'x-ds-in-sdk': true;
      'x-ds-method': 'updateSettings';
      'x-ds-methodname': 'updateRequestLogSettings';
      'x-ds-service': 'Diagnostics';
    };
  };
};
export const paths = {
  '/service_information': {
    get: {
      deprecated: false,
      description:
        'Retrieves the available REST API versions.\n\nDocuSign Production system: https://www.docusign.net/restapi/service_information\nDocuSign Demo system: https://demo.docusign.net/restapi/service_information\n\nYou do not need an integration key to view the REST API versions and resources.',
      operationId: 'ServiceInformation_GetServiceInformation',
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/serviceInformation',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Retrieves the available REST API versions.',
      tags: ['Services'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'get',
      'x-ds-methodname': 'getService',
      'x-ds-service': 'Diagnostics',
    },
    parameters: [],
  },
  '/v2.1': {
    get: {
      deprecated: false,
      description:
        'Retrieves the base resources available for the eSignature REST API.\n\nYou do not need an integrator key to view the REST API versions and resources.\n\n',
      operationId: 'ServiceInformation_GetResourceInformation',
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/resourceInformation',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Lists resources for REST version specified',
      tags: ['Resources'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'get',
      'x-ds-methodname': 'getResources',
      'x-ds-service': 'Diagnostics',
    },
    parameters: [],
  },
  '/v2.1/accounts': {
    parameters: [],
    post: {
      deprecated: false,
      description:
        'Creates new DocuSign accounts.\nYou can use this method to create\na single account\nor up to 100 accounts at a time.\n\n**Note:**  This method is restricted to partner integrations.\nYou must work with DocuSign Professional Services\nor DocuSign Business Development,\nwho will provide you with the Distributor Code\nand Distributor Password\nthat you need to include in the request body.\n\n\nWhen creating a single account,\nthe body of the request is a\n[`newAccountRequest`][newAccountRequest]\nobject.\n\nExample:\n\n```\n{\n  "newAccountRequest": [\n    {\n      "accountName":"Test Account",\n      "distributorCode":"MY_DIST_CODE",\n      "distributorPassword":"MY_DIST_PWD",\n      "initialUser":{\n        "email":"user@emaildomain.com",\n        "firstName":"John",\n        "middleName": "Harry",\n        "lastName":"Doe",\n        "suffixName": "",\n        "userName": "John Doe",\n        "jobTitle": "Engineer",\n        "company": "Test Company"\n      },\n      "addressInformation":{\n        "address1": "1234 Main Street",\n        "address2": "Suite 100",\n        "city": "Seattle",\n        "state": "WA",\n        "postalCode": "98101",\n        "country": "US",\n        "phone": "1234567890",\n        "fax": "1234567891"\n      },\n      "planInformation":{\n        "planId":"37085696-xxxx-xxxx-xxxx-7ea067752959"\n      },\n      "referralInformation":{\n        "includedSeats": "1",\n        "referralCode": "code",\n        "referrerName": "name"\n      }\n    }\n  ]\n}\n\n```\nIf the request succeeds,\nit returns a\n201 (Created) HTTP response code.\nThe response returns the new account ID, password, and the default user\ninformation for each newly created account.\n\n\nWhen creating multiple accounts,\nthe body of the request is a\n`newAccountRequests`\nobject,\nwhich contains one or more\n[`newAccountDefinition`][newAccountDefinition]\nobjects.\nYou can create up to 100 new accounts\nat a time this way.\n\nThe body for a multi-account\ncreation request\nlooks like this in JSON:\n\n```\n{\n  "newAccountRequests": [\n    {\n      "accountName": "accountone",\n      . . .\n    },\n    {\n      "accountName": "accounttwo",\n      . . .\n    }\n  ]\n}\n```\n\nA multi-account request\nlooks like this in XML:\n\n```\n<newAccountsDefinition xmlns:i="http://www.w3.org/2001/XMLSchema-instance" xmlns="http://www.docusign.com/restapi">\n  <newAccountRequests>\n    <newAccountDefinition>\n      . . .\n    </newAccountDefinition>\n    <newAccountDefinition>\n      . . .\n    </newAccountDefinition>\n  </newAccountRequests>\n</newAccountsDefinition>\n```\n\nA multi-account creation request\nmay succeed (report a 201 code)\neven if some accounts could not be created.\nIn this case, the `errorDetails` property\nin the response contains specific information\nabout the failure.\n\n\n\n[newAccountDefinition]: #/definitions/newAccountDefinition\n[nameValue]: #/definitions/nameValue\n[newAccountRequest]: #/definitions/newAccountRequest\n',
      operationId: 'Accounts_PostAccounts',
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/newAccountDefinition',
            },
          },
        },
      },
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/newAccountSummary',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Creates new accounts.',
      tags: ['Accounts'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'create',
      'x-ds-methodname': 'create',
      'x-ds-service': 'Accounts',
    },
  },
  '/v2.1/accounts/provisioning': {
    get: {
      deprecated: false,
      description: 'Retrieves the account provisioning information for the account.',
      operationId: 'Accounts_GetProvisioning',
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/provisioningInformation',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Retrieves the account provisioning information for the account.',
      tags: ['Accounts'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'getProvisioning',
      'x-ds-methodname': 'getProvisioning',
      'x-ds-service': 'Accounts',
    },
    parameters: [],
  },
  '/v2.1/accounts/{accountId}': {
    delete: {
      deprecated: false,
      description:
        'This closes the specified account. You must be an account admin to close your account. Once closed, an account must be reopened by DocuSign.',
      operationId: 'Accounts_DeleteAccount',
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.',
          in: 'path',
          name: 'accountId',
          required: true,
          schema: {
            type: 'string',
          },
        },
      ],
      responses: {
        '200': {
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Deletes the specified account.',
      tags: ['Accounts'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'delete',
      'x-ds-methodname': 'delete',
      'x-ds-service': 'Accounts',
    },
    get: {
      deprecated: false,
      description: 'Retrieves the account information for the specified account.',
      operationId: 'Accounts_GetAccount',
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.',
          in: 'path',
          name: 'accountId',
          required: true,
          schema: {
            type: 'string',
          },
        },
        {
          description: 'When **true,** includes account settings in the response. The default value is **false.**',
          in: 'query',
          name: 'include_account_settings',
          required: false,
          schema: {
            type: 'string',
          },
        },
      ],
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/accountInformation',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Retrieves the account information for the specified account.',
      tags: ['Accounts'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'get',
      'x-ds-methodname': 'GetAccountInformation',
      'x-ds-service': 'Accounts',
    },
    parameters: [],
  },
  '/v2.1/accounts/{accountId}/billing_charges': {
    get: {
      deprecated: false,
      description:
        'Retrieves the list of recurring and usage charges for the account. This can be used to determine the charge structure and usage of charge plan items. \n\nPrivileges required: account administrator ',
      operationId: 'BillingCharges_GetAccountBillingCharges',
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.',
          in: 'path',
          name: 'accountId',
          required: true,
          schema: {
            type: 'string',
          },
        },
        {
          description: 'Specifies which billing charges to return.\nValid values are:\n\n* envelopes\n* seats\n',
          in: 'query',
          name: 'include_charges',
          required: false,
          schema: {
            type: 'string',
          },
        },
      ],
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/billingChargeResponse',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Gets list of recurring and usage charges for the account.',
      tags: ['Accounts'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'getBillingCharges',
      'x-ds-methodname': 'getBillingCharges',
      'x-ds-service': 'Accounts',
    },
    parameters: [],
  },
  '/v2.1/accounts/{accountId}/billing_invoices': {
    get: {
      deprecated: false,
      description:
        'Retrieves a list of invoices for the account. If the from date or to date queries are not specified, the response returns invoices for the last 365 days.\n\nPrivileges required: account administrator ',
      operationId: 'BillingInvoices_GetBillingInvoices',
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.',
          in: 'path',
          name: 'accountId',
          required: true,
          schema: {
            type: 'string',
          },
        },
        {
          description: 'Specifies the date/time of the earliest invoice in the account to retrieve.',
          in: 'query',
          name: 'from_date',
          required: false,
          schema: {
            type: 'string',
          },
        },
        {
          description: 'Specifies the date/time of the latest invoice in the account to retrieve.',
          in: 'query',
          name: 'to_date',
          required: false,
          schema: {
            type: 'string',
          },
        },
      ],
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/billingInvoicesResponse',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Get a List of Billing Invoices',
      tags: ['Invoices'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'list',
      'x-ds-methodname': 'listInvoices',
      'x-ds-service': 'Billing',
    },
    parameters: [],
  },
  '/v2.1/accounts/{accountId}/billing_invoices/{invoiceId}': {
    get: {
      deprecated: false,
      description:
        "Retrieves the specified invoice.\n\n**Note:** If the `pdfAvailable` property in the response is set to *true*, you can download a PDF version of the invoice. To download the PDF, make the call again and change the value of the `Accept` property in the header to `Accept: application/pdf`.\n\nPrivileges required: account administrator\n\nThe response returns a list of charges and information about the charges. Quantities are usually shown as 'unlimited' or an integer. Amounts are shown in the currency set for the account.\n\n**Response**\nThe following table provides a description of the different `chargeName` property values. The information will grow as more chargeable items are added to the system.\n\n| chargeName | Description |\n| --- | --- |\n| id_check | ID Check Charge |\n| in_person_signing | In Person Signing charge |\n| envelopes Included | Sent Envelopes for the account |\n| age_verify | Age verification check |\n| ofac | OFAC Check |\n| id_confirm | ID confirmation check |\n| student_authentication | STAN PIN authentication check |\n| wet_sign_fax | Pages for returning signed documents by fax |\n| attachment_fax | Pages for returning attachments by fax |\n| phone_authentication | Phone authentication charge |\n| powerforms | PowerForm envelopes sent |\n| signer_payments | Payment processing charge |\n| outbound_fax | Send by fax charge |\n| bulk_recipient_envelopes | Bulk Recipient Envelopes sent |\n| sms_authentications | SMS authentication charge |\n| saml_authentications | SAML authentication charge |\n| express_signer_certificate | DocuSign Express Certificate charge |\n| personal_signer_certificate | Personal Signer Certificate charge |\n| safe_certificate | SAFE BioPharma Signer Certificate charge |\n| seats | Included active seats charge |\n| open_trust_certificate | OpenTrust Signer Certificate charge |",
      operationId: 'BillingInvoices_GetBillingInvoice',
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.',
          in: 'path',
          name: 'accountId',
          required: true,
          schema: {
            type: 'string',
          },
        },
        {
          description: 'The ID of the invoice.',
          in: 'path',
          name: 'invoiceId',
          required: true,
          schema: {
            type: 'string',
          },
        },
      ],
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/billingInvoice',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Retrieves a billing invoice.',
      tags: ['Invoices'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'get',
      'x-ds-methodname': 'getInvoice',
      'x-ds-service': 'Billing',
    },
    parameters: [],
  },
  '/v2.1/accounts/{accountId}/billing_invoices_past_due': {
    get: {
      deprecated: false,
      description:
        'Returns a list past due invoices for the account and notes if payment can be made through the REST API. \n\nPrivileges Required: account administrator',
      operationId: 'BillingInvoices_GetBillingInvoicesPastDue',
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.',
          in: 'path',
          name: 'accountId',
          required: true,
          schema: {
            type: 'string',
          },
        },
      ],
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/billingInvoicesSummary',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Get a list of past due invoices.',
      tags: ['Invoices'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'listPastDue',
      'x-ds-methodname': 'listInvoicesPastDue',
      'x-ds-service': 'Billing',
    },
    parameters: [],
  },
  '/v2.1/accounts/{accountId}/billing_payments': {
    get: {
      deprecated: false,
      description:
        'Retrieves a list containing information about one or more payments. If the from date or to date queries are not used, the response returns payment information for the last 365 days. \n\nPrivileges required: account administrator ',
      operationId: 'BillingPayments_GetPaymentList',
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.',
          in: 'path',
          name: 'accountId',
          required: true,
          schema: {
            type: 'string',
          },
        },
        {
          description: 'Specifies the date/time of the earliest payment in the account to retrieve.',
          in: 'query',
          name: 'from_date',
          required: false,
          schema: {
            type: 'string',
          },
        },
        {
          description: 'Specifies the date/time of the latest payment in the account to retrieve.',
          in: 'query',
          name: 'to_date',
          required: false,
          schema: {
            type: 'string',
          },
        },
      ],
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/billingPaymentsResponse',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Gets payment information for one or more payments.',
      tags: ['Payments'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'list',
      'x-ds-methodname': 'listPayments',
      'x-ds-service': 'Billing',
    },
    parameters: [],
    post: {
      deprecated: false,
      description:
        'Posts a payment to a past due invoice.\n\nThis method can only be used if the `paymentAllowed` value for a past due invoice is true. This can be determined calling [Billing::listInvoicesPastDue](/docs/esign-rest-api/reference/billing/invoices/listpastdue/).\n\nThe response returns information for a single payment\nif a payment ID was used in the endpoint, or a list of payments.\nIf the from date or to date queries or payment ID are not used,\nthe response returns payment information for the last 365 days.\n\nIf the request was for a single payment ID, the `nextUri` and `previousUri` properties are not returned.\n\nPrivileges required: account administrator\n',
      operationId: 'BillingPayments_PostPayment',
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.',
          in: 'path',
          name: 'accountId',
          required: true,
          schema: {
            type: 'string',
          },
        },
      ],
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/billingPaymentRequest',
            },
          },
        },
      },
      responses: {
        '201': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/billingPaymentResponse',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Posts a payment to a past due invoice.',
      tags: ['Payments'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'create',
      'x-ds-methodname': 'makePayment',
      'x-ds-service': 'Billing',
    },
  },
  '/v2.1/accounts/{accountId}/billing_payments/{paymentId}': {
    get: {
      deprecated: false,
      description: 'Retrieves the information for a specified payment. \n\nPrivileges required: account administrator ',
      operationId: 'BillingPayments_GetPayment',
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.',
          in: 'path',
          name: 'accountId',
          required: true,
          schema: {
            type: 'string',
          },
        },
        {
          description: 'The ID of the payment.',
          in: 'path',
          name: 'paymentId',
          required: true,
          schema: {
            type: 'string',
          },
        },
      ],
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/billingPaymentItem',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Gets billing payment information for a specific payment.',
      tags: ['Payments'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'get',
      'x-ds-methodname': 'getPayment',
      'x-ds-service': 'Billing',
    },
    parameters: [],
  },
  '/v2.1/accounts/{accountId}/billing_plan': {
    get: {
      deprecated: false,
      description:
        'Retrieves the billing plan information for the specified account, including the current billing plan, successor plans, billing address, and billing credit card.\n\nBy default the successor plan and credit card information is included in the response. You can exclude this information from the response by adding the appropriate optional query string and setting it to **false.**\n\nResponse\n\nThe response returns the billing plan information, including the currency code, for the plan. The `billingPlan` and `succesorPlans` property values are the same as those shown in the [Billing: getBillingPlan](/docs/esign-rest-api/reference/billing/billingplans/get/) reference. the `billingAddress` and `creditCardInformation` property values are the same as those shown in the [Billing: updatePlan](/docs/esign-rest-api/reference/billing/billingplans/update/) reference.\n\n**Note:** When credit card number information displays, a mask is applied to the response so that only the last 4 digits of the card number are visible.\n',
      operationId: 'BillingPlan_GetBillingPlan',
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.',
          in: 'path',
          name: 'accountId',
          required: true,
          schema: {
            type: 'string',
          },
        },
        {
          description: 'When **true,** payment information including credit card information will show in the return.',
          in: 'query',
          name: 'include_credit_card_information',
          required: false,
          schema: {
            type: 'string',
          },
        },
        {
          description: '',
          in: 'query',
          name: 'include_downgrade_information',
          required: false,
          schema: {
            type: 'string',
          },
        },
        {
          description:
            'When **true,** the `canUpgrade` and `renewalStatus` properties are included the response and an array of `supportedCountries` is added to the `billingAddress` information. ',
          in: 'query',
          name: 'include_metadata',
          required: false,
          schema: {
            type: 'string',
          },
        },
        {
          description: 'When **true,** excludes successor information from the response.',
          in: 'query',
          name: 'include_successor_plans',
          required: false,
          schema: {
            type: 'string',
          },
        },
        {
          description: '',
          in: 'query',
          name: 'include_tax_exempt_id',
          required: false,
          schema: {
            type: 'string',
          },
        },
      ],
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/accountBillingPlanResponse',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Get Account Billing Plan',
      tags: ['BillingPlans'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'getAccountPlan',
      'x-ds-methodname': 'getPlan',
      'x-ds-service': 'Billing',
    },
    parameters: [],
    put: {
      deprecated: false,
      description:
        'Updates the billing plan information, billing address, and credit card information for the specified account.',
      operationId: 'BillingPlan_PutBillingPlan',
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.',
          in: 'path',
          name: 'accountId',
          required: true,
          schema: {
            type: 'string',
          },
        },
        {
          description: 'When **true,** updates the account using a preview billing plan.',
          in: 'query',
          name: 'preview_billing_plan',
          required: false,
          schema: {
            type: 'string',
          },
        },
      ],
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/billingPlanInformation',
            },
          },
        },
      },
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/billingPlanUpdateResponse',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Updates an account billing plan.',
      tags: ['BillingPlans'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'update',
      'x-ds-methodname': 'updatePlan',
      'x-ds-service': 'Billing',
    },
  },
  '/v2.1/accounts/{accountId}/billing_plan/credit_card': {
    get: {
      deprecated: false,
      description: 'This method returns information about a credit card associated with an account.',
      operationId: 'BillingPlan_GetCreditCardInfo',
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.',
          in: 'path',
          name: 'accountId',
          required: true,
          schema: {
            type: 'string',
          },
        },
      ],
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/creditCardInformation',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Get credit card information',
      tags: ['BillingPlans'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'getCreditCard',
      'x-ds-methodname': 'getCreditCardInfo',
      'x-ds-service': 'Billing',
    },
    parameters: [],
  },
  '/v2.1/accounts/{accountId}/billing_plan/downgrade': {
    get: {
      deprecated: false,
      description: '',
      operationId: 'BillingPlan_GetDowngradeRequestBillingInfo',
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.',
          in: 'path',
          name: 'accountId',
          required: true,
          schema: {
            type: 'string',
          },
        },
      ],
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/downgradRequestBillingInfoResponse',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Returns downgrade plan information for the specified account.',
      tags: ['BillingPlans'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'getDowngradeRequestBillingInfo',
      'x-ds-methodname': 'getDowngradeRequestBillingInfo',
      'x-ds-service': 'Uncategorized',
    },
    parameters: [],
    put: {
      deprecated: false,
      description: '',
      operationId: 'BillingPlan_PutDowngradeAccountBillingPlan',
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.',
          in: 'path',
          name: 'accountId',
          required: true,
          schema: {
            type: 'string',
          },
        },
      ],
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/downgradeBillingPlanInformation',
            },
          },
        },
      },
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/downgradePlanUpdateResponse',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Queues downgrade billing plan request for an account.',
      tags: ['BillingPlans'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'updateDowngradeAccountBillingPlan',
      'x-ds-methodname': 'updateDowngradeAccountBillingPlan',
      'x-ds-service': 'Uncategorized',
    },
  },
  '/v2.1/accounts/{accountId}/billing_plan/purchased_envelopes': {
    parameters: [],
    put: {
      deprecated: false,
      description:
        'Reserved: At this time, this endpoint is limited to DocuSign internal use only. Completes the purchase of envelopes for your account. The actual purchase is done as part of an internal workflow interaction with an envelope vendor.',
      operationId: 'PurchasedEnvelopes_PutPurchasedEnvelopes',
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.',
          in: 'path',
          name: 'accountId',
          required: true,
          schema: {
            type: 'string',
          },
        },
      ],
      requestBody: {
        content: {
          'application/json': {
            schema: {
              $ref: '#/components/schemas/purchasedEnvelopesInformation',
            },
          },
        },
      },
      responses: {
        '200': {
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Reserved: Purchase additional envelopes.',
      tags: ['BillingPlans'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'purchaseEnvelopes',
      'x-ds-methodname': 'purchaseEnvelopes',
      'x-ds-service': 'Billing',
    },
  },
  '/v2.1/accounts/{accountId}/brands': {
    delete: {
      deprecated: false,
      description:
        'This method deletes one or more brand profiles from an account, based on the brand IDs that you include in the `brandsRequest`.\n\nEither or both of the following settings must be enabled for the account to use this method:\n\n- `canSelfBrandSign`\n- `canSelfBrandSend`\n\n### Related topics\n\n- [How to create a brand](/docs/esign-rest-api/how-to/create-brand/)\n',
      operationId: 'Brands_DeleteBrands',
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.',
          in: 'path',
          name: 'accountId',
          required: true,
          schema: {
            type: 'string',
          },
        },
      ],
      requestBody: {
        $ref: '#/components/requestBodies/brandsRequest',
      },
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/AccountBrands',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Deletes one or more brand profiles.',
      tags: ['AccountBrands'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'deleteList',
      'x-ds-methodname': 'deleteBrands',
      'x-ds-service': 'Accounts',
    },
    get: {
      deprecated: false,
      description:
        'This method returns details about all of the brands associated with an account,\nincluding the default brand profiles.\n\nEither or both of the following settings must be enabled for the account to use this method:\n\n- `canSelfBrandSign`\n- `canSelfBrandSend`\n\n### Related topics\n\n- [How to create a brand](/docs/esign-rest-api/how-to/create-brand/)\n',
      operationId: 'Brands_GetBrands',
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.',
          in: 'path',
          name: 'accountId',
          required: true,
          schema: {
            type: 'string',
          },
        },
        {
          description: 'When **true,** excludes distributor brand information from the response set.',
          in: 'query',
          name: 'exclude_distributor_brand',
          required: false,
          schema: {
            type: 'string',
          },
        },
        {
          description: 'When **true,** returns the logos associated with the brand.',
          in: 'query',
          name: 'include_logos',
          required: false,
          schema: {
            type: 'string',
          },
        },
      ],
      responses: {
        '200': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/AccountBrands',
              },
            },
          },
          description: 'Successful response.',
        },
        '400': {
          content: {
            '*/*': {
              schema: {
                $ref: '#/components/schemas/errorDetails',
              },
            },
          },
          description: 'Error encountered.',
        },
      },
      summary: 'Gets a list of brands.',
      tags: ['AccountBrands'],
      'x-ds-in-sdk': true,
      'x-ds-method': 'list',
      'x-ds-methodname': 'listBrands',
      'x-ds-service': 'Accounts',
    },
    parameters: [],
    post: {
      deprecated: false,
      description:
        'This method creates one or more brand profile files for an account.\n\nTo specify logos for the brand,\nuse the\n[AccountBrands: updateLogo](/docs/esign-rest-api/reference/accounts/accountbrands/updatelogo/)\nmethod\nafter you create the brand.\n\n\nEither or both of the following settings must be enabled for the account to use this method:\n\n- `canSelfBrandSign`\n- `canSelfBrandSend`\n\n### Related topics\n\n- [How to create a brand](/docs/esign-rest-api/how-to/create-brand/)\n',
      operationId: 'Brands_PostBrands',
      parameters: [
        {
          description: 'The external account number (int) or account ID GUID.',
          in: 'path',
          name: 'accountId',
          required: true,
          schema: {
            type: 'string',
          },
        },
      ],
      requestBody: {
        $ref: '#/components/requestBodies/brand',
      },
      responses: {
        '201': {
          content: {
            '*/*': {
     